#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CMB_FI_S_IMPORT_INTERFACE_CMB_ACRFI_TYPES
#define CMB_FI_S_IMPORT_INTERFACE_CMB_ACRFI_SERVICEINFO
#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_TYPES
#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_SERVICEINFO
#define CMB_FI_S_IMPORT_INTERFACE_CMB_VEHICLESENSORFI_TYPES
#define CMB_FI_S_IMPORT_INTERFACE_CMB_VEHICLESENSORFI_SERVICEINFO
#define CMB_FI_S_IMPORT_INTERFACE_CMB_VOICEFI_TYPES
#define CMB_FI_S_IMPORT_INTERFACE_CMB_VOICEFI_SERVICEINFO
#include "cmb_fi_gen_if.h"

#include "alltypefactory.h"

fi_tclTypeBase* cmb_fi_poGetFIObject(tU16 u16ServiceId, tU16 u16FunctionId, tU8 u8Opcode)
{
   fi_tclMessageBase* poType
   = cmb_fi_poGetMessageBaseObject(u16ServiceId, u16FunctionId, u8Opcode);
   if (poType)
      return &poType->rfoGetTypeBase();
   else
      return OSAL_NULL;
}

fi_tclMessageBase* cmb_fi_poGetMessageBaseObject(tU16 u16ServiceId, tU16 u16FunctionId, tU8 u8Opcode)
{
   switch(u16ServiceId)
   {
      case CMB_ACRFI_C_U16_SERVICE_ID:
         return cmb_acrfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case CMB_SENSORFI_C_U16_SERVICE_ID:
         return cmb_sensorfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case CMB_VEHICLESENSORFI_C_U16_SERVICE_ID:
         return cmb_vehiclesensorfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case CMB_VOICEFI_C_U16_SERVICE_ID:
         return cmb_voicefi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      default: 
         return OSAL_NULL;
   }
}

