#ifndef CMB_VOICEFILANGUAGE_HEADER
#define CMB_VOICEFILANGUAGE_HEADER

class cmb_voicefi_tclInContext;
class cmb_voicefi_tclOutContext;
class cmb_voicefi_tclVisitorBase;

class MY_DECL cmb_voicefi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  cmb_voicefi_tclDescription(fi_tclInContext* poIn, cmb_voicefi_tclVisitorBase* poVisit);
  cmb_voicefi_tclDescription(fi_tclOutContext* poOut, cmb_voicefi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(cmb_voicefi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(cmb_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ cmb_voicefi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  cmb_voicefi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<cmb_voicefi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<cmb_voicefi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline cmb_voicefi_tclDescription::cmb_voicefi_tclDescription(fi_tclInContext* poIn, cmb_voicefi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline cmb_voicefi_tclDescription::cmb_voicefi_tclDescription(fi_tclOutContext* poOut, cmb_voicefi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

