#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CMB_FI_S_IMPORT_INTERFACE_CMB_VOICEFI_STDVISITORS
#include "cmb_fi_gen_if.h"

tBool cmb_voicefi_tclDescription::bInitMessage(cmb_voicefi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case cmb_voicefi_tclToken::EN_LAST_TOKEN:
   case cmb_voicefi_tclToken::EN_LIST:
   case cmb_voicefi_tclToken::EN_END_OF_STRUCT:
   case cmb_voicefi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;
   // include the expansions for the messages
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADMETHODSTART:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_SD_PACKAGE,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_MSG_SPEECHDATA)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODSTART:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U32,cmb_voicefi_tclSemanticDomain::EN_MSG_NOOFBYTES)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U32,cmb_voicefi_tclSemanticDomain::EN_MSG_STARTADDRESS)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8_SD_PACKAGEID,cmb_voicefi_tclSemanticDomain::EN_MSG_SD_PACKAGE)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODRESULT:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_MSG_SD_CONTENTS)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACRCCHECKMETHODSTART:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8_SD_PACKAGEID,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_MSG_CHECKPACKAGES)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_PREPARETTSMETHODSTART:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_BOOL,cmb_voicefi_tclSemanticDomain::EN_MSG_HASDICT)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U32,cmb_voicefi_tclSemanticDomain::EN_MSG_EXPIRY)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_STRING,cmb_voicefi_tclSemanticDomain::EN_MSG_TEXTANDTAGS)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCEMETHODSTART:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_SD_SENTENCE,cmb_voicefi_tclSemanticDomain::EN_MSG_SENTENCE)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEAKCATEGORIZEDSENTENCEMETHODSTART:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_B16_CATEGORYADDINFO,cmb_voicefi_tclSemanticDomain::EN_MSG_REQUESTADDINFO)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U32,cmb_voicefi_tclSemanticDomain::EN_MSG_TIMEOUT)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_SD_SENTENCE,cmb_voicefi_tclSemanticDomain::EN_MSG_SENTENCE)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_E8_SPEECHCATEGORY,cmb_voicefi_tclSemanticDomain::EN_MSG_CATEGORY)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCESELECTMETHODSTART:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_SD_SENTENCEANDPARAM,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_MSG_SENTENCELIST)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_E8_SPEECHSEQUENCE,cmb_voicefi_tclSemanticDomain::EN_MSG_SPEECHSEQUENCE)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCESELECTMETHODRESULT:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8,cmb_voicefi_tclSemanticDomain::EN_MSG_INDEX)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEAKSTOPMETHODSTART:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_E8_STOPVOPRIORITY,cmb_voicefi_tclSemanticDomain::EN_MSG_E8STOPVOPRIORITY)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_SD_PACKAGELOADSTATUS,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_MSG_AVAILABLEPACKAGE)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYSTATUS:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8_SD_PACKAGEID,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_MSG_SD_DAMAGEDPACKAGES)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_E8_SD_DAMAGE,cmb_voicefi_tclSemanticDomain::EN_MSG_SD_DAMAGE)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAMEMORYSTATUS:
   {
      if (4 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U16,cmb_voicefi_tclSemanticDomain::EN_MSG_SD_KB_SIZE)) && bResult;
      }
      if (poOutContext->u16GetMajorVersion() <= 3)
      {
         bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8,cmb_voicefi_tclSemanticDomain::EN_MSG_SD_MB_SIZE)) && bResult;
      }
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAFORMATSTATUS:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_E8_SD_FORMAT,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_MSG_SD_FORMAT)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACUSTOMERSTATUS:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U32,cmb_voicefi_tclSemanticDomain::EN_MSG_SD_PLATFORMID)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U32,cmb_voicefi_tclSemanticDomain::EN_MSG_SD_CUSTOMERID)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOSET:
   {
      if (4 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_SD_PHRASE,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
         bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_MSG_PHRASESTOKEEP)) && bResult;
      }
      if (poOutContext->u16GetMajorVersion() <= 3)
      {
         bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U16,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
         bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_MSG_PHRASESTOKEEP_V3)) && bResult;
      }
   } break;
   case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOSTATUS:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_TTSPHRASEINFO,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_MSG_PHRASES)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYSTATUS:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U32,cmb_voicefi_tclSemanticDomain::EN_MSG_MISSING)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U32,cmb_voicefi_tclSemanticDomain::EN_MSG_TOTAL)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_TTSVOICESTATUS:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8,cmb_voicefi_tclSemanticDomain::EN_MSG_GENDER)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_MSG_NAME)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U16,cmb_voicefi_tclSemanticDomain::EN_MSG_COUNTRYCODE)) && bResult;
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U16,cmb_voicefi_tclSemanticDomain::EN_MSG_LANGUAGECODE)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATASETTINGSSET:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_SD_SETTINGS,cmb_voicefi_tclSemanticDomain::EN_MSG_SD_SETTINGS)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATASETTINGSSTATUS:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_SD_SETTINGS,cmb_voicefi_tclSemanticDomain::EN_MSG_SD_SETTINGS)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAREFERENCESET:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_SD_REFERENCE,cmb_voicefi_tclSemanticDomain::EN_MSG_SD_REFERENCE)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAREFERENCESTATUS:
   {
      bResult = oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_BOOL,cmb_voicefi_tclSemanticDomain::EN_MSG_BSUCCESS)) && bResult;
   } break;
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADMETHODRESULT:
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACRCCHECKMETHODRESULT:
   case cmb_voicefi_tclToken::EN_MSG_PREPARETTSMETHODRESULT:
   case cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCEMETHODRESULT:
   case cmb_voicefi_tclToken::EN_MSG_SPEAKCATEGORIZEDSENTENCEMETHODRESULT:
   case cmb_voicefi_tclToken::EN_MSG_SPEAKSTOPMETHODRESULT:
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSGET:
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSUPREG:
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSRELUPREG:
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYGET:
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYUPREG:
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYRELUPREG:
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAMEMORYGET:
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAFORMATGET:
   case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACUSTOMERGET:
   case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOGET:
   case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOUPREG:
   case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFORELUPREG:
   case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYGET:
   case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYUPREG:
   case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYRELUPREG:
   case cmb_voicefi_tclToken::EN_MSG_TTSVOICEGET:
   case cmb_voicefi_tclToken::EN_MSG_TTSVOICEUPREG:
   case cmb_voicefi_tclToken::EN_MSG_TTSVOICERELUPREG:
   case cmb_voicefi_tclToken::EN_BINCONTAINER:
   case cmb_voicefi_tclToken::EN_U8_SD_PACKAGEID:
   case cmb_voicefi_tclToken::EN_SD_PACKAGE:
   case cmb_voicefi_tclToken::EN_E8_DOWNLOADSTATUS:
   case cmb_voicefi_tclToken::EN_SD_PACKAGELOADSTATUS:
   case cmb_voicefi_tclToken::EN_E8_SD_DAMAGE:
   case cmb_voicefi_tclToken::EN_E8_SD_FORMAT:
   case cmb_voicefi_tclToken::EN_E8_SPEECHCATEGORY:
   case cmb_voicefi_tclToken::EN_B16_CATEGORYADDINFO:
   case cmb_voicefi_tclToken::EN_E8_SPEECHSEQUENCE:
   case cmb_voicefi_tclToken::EN_SD_PHRASE:
   case cmb_voicefi_tclToken::EN_SD_SENTENCE:
   case cmb_voicefi_tclToken::EN_SD_SENTENCEANDPARAM:
   case cmb_voicefi_tclToken::EN_U16_SD_SAMPLEFREQUENCY:
   case cmb_voicefi_tclToken::EN_SD_SETTINGS:
   case cmb_voicefi_tclToken::EN_U8_SD_SIZE:
   case cmb_voicefi_tclToken::EN_SD_REFERENCE:
   case cmb_voicefi_tclToken::EN_E8_STOPVOPRIORITY:
   case cmb_voicefi_tclToken::EN_B8_PHRASESTATUS:
   case cmb_voicefi_tclToken::EN_TTSPHRASEINFO:
   case cmb_voicefi_tclToken::EN_U8:   
   case cmb_voicefi_tclToken::EN_S8:   
   case cmb_voicefi_tclToken::EN_U16:   
   case cmb_voicefi_tclToken::EN_S16:   
   case cmb_voicefi_tclToken::EN_U24:   
   case cmb_voicefi_tclToken::EN_S24:   
   case cmb_voicefi_tclToken::EN_U32:   
   case cmb_voicefi_tclToken::EN_S32:   
   case cmb_voicefi_tclToken::EN_U64:   
   case cmb_voicefi_tclToken::EN_S64:   
   case cmb_voicefi_tclToken::EN_F32:   
   case cmb_voicefi_tclToken::EN_F64:   
   case cmb_voicefi_tclToken::EN_BOOL:   
   case cmb_voicefi_tclToken::EN_STRING:   
   case cmb_voicefi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(enMsgToken,cmb_voicefi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool cmb_voicefi_tclDescription::bDoIt(cmb_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool cmb_voicefi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      cmb_voicefi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      cmb_voicefi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      cmb_voicefi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(cmb_voicefi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case cmb_voicefi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == cmb_voicefi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_LIST: 
      {
         cmb_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            cmb_voicefi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            cmb_voicefi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case cmb_voicefi_tclToken::EN_U8: 
      {
         cmb_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case cmb_voicefi_tclToken::EN_U16: 
      {
         cmb_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_U24: 
      {
         cmb_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_U32: 
      {
         cmb_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_U64: 
      {
         cmb_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_S8: 
      {
         cmb_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_S16: 
      {
         cmb_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_S24: 
      {
         cmb_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_S32: 
      {
         cmb_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_S64: 
      {
         cmb_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_F32: 
      {
         cmb_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_F64: 
      {
         cmb_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_BOOL: 
      {
         cmb_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_STRING: 
      {
         cmb_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         cmb_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADMETHODSTART:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADMETHODRESULT:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODSTART:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODRESULT:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACRCCHECKMETHODSTART:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACRCCHECKMETHODRESULT:
      case cmb_voicefi_tclToken::EN_MSG_PREPARETTSMETHODSTART:
      case cmb_voicefi_tclToken::EN_MSG_PREPARETTSMETHODRESULT:
      case cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCEMETHODSTART:
      case cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCEMETHODRESULT:
      case cmb_voicefi_tclToken::EN_MSG_SPEAKCATEGORIZEDSENTENCEMETHODSTART:
      case cmb_voicefi_tclToken::EN_MSG_SPEAKCATEGORIZEDSENTENCEMETHODRESULT:
      case cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCESELECTMETHODSTART:
      case cmb_voicefi_tclToken::EN_MSG_SPEAKSENTENCESELECTMETHODRESULT:
      case cmb_voicefi_tclToken::EN_MSG_SPEAKSTOPMETHODSTART:
      case cmb_voicefi_tclToken::EN_MSG_SPEAKSTOPMETHODRESULT:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSGET:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSUPREG:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSRELUPREG:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDOWNLOADSTATUSSTATUS:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYGET:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYUPREG:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYRELUPREG:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAINTEGRITYSTATUS:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAMEMORYGET:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAMEMORYSTATUS:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAFORMATGET:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAFORMATSTATUS:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACUSTOMERGET:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATACUSTOMERSTATUS:
      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOGET:
      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOSET:
      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOUPREG:
      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFORELUPREG:
      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEINFOSTATUS:
      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYGET:
      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYUPREG:
      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYRELUPREG:
      case cmb_voicefi_tclToken::EN_MSG_TTSPHRASEMEMORYSTATUS:
      case cmb_voicefi_tclToken::EN_MSG_TTSVOICEGET:
      case cmb_voicefi_tclToken::EN_MSG_TTSVOICEUPREG:
      case cmb_voicefi_tclToken::EN_MSG_TTSVOICERELUPREG:
      case cmb_voicefi_tclToken::EN_MSG_TTSVOICESTATUS:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATASETTINGSSET:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATASETTINGSSTATUS:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAREFERENCESET:
      case cmb_voicefi_tclToken::EN_MSG_SPEECHDATAREFERENCESTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case cmb_voicefi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_END_OF_STRUCT,cmb_voicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         cmb_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_voicefi_tclToken::EN_U8_SD_PACKAGEID:
      {
         cmb_fi_tcl_u8_SD_PackageID o_u8_SD_PackageID;
         if (!bDoIt(o_u8_SD_PackageID))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_SD_PACKAGE:
      {
      if (poVisitor->bDoExpand_SD_Package(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_END_OF_STRUCT,cmb_voicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_STRING,cmb_voicefi_tclSemanticDomain::EN_SD_PATH));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_STRING,cmb_voicefi_tclSemanticDomain::EN_SD_PACKAGE));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8_SD_PACKAGEID,cmb_voicefi_tclSemanticDomain::EN_PACKAGEID));
      }
      else
      {
         cmb_fi_tcl_SD_Package o_SD_Package;
         if (!bDoIt(o_SD_Package))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_Package.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_Package.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_voicefi_tclToken::EN_E8_DOWNLOADSTATUS:
      {
         cmb_fi_tcl_e8_DownloadStatus o_e8_DownloadStatus;
         if (!bDoIt(o_e8_DownloadStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_SD_PACKAGELOADSTATUS:
      {
      if (poVisitor->bDoExpand_SD_PackageLoadStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_END_OF_STRUCT,cmb_voicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_E8_DOWNLOADSTATUS,cmb_voicefi_tclSemanticDomain::EN_DOWNLOADSTATUS));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8_SD_PACKAGEID,cmb_voicefi_tclSemanticDomain::EN_PACKAGEID));
      }
      else
      {
         cmb_fi_tcl_SD_PackageLoadStatus o_SD_PackageLoadStatus;
         if (!bDoIt(o_SD_PackageLoadStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_PackageLoadStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_PackageLoadStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_voicefi_tclToken::EN_E8_SD_DAMAGE:
      {
         cmb_fi_tcl_e8_SD_Damage o_e8_SD_Damage;
         if (!bDoIt(o_e8_SD_Damage))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_E8_SD_FORMAT:
      {
         cmb_fi_tcl_e8_SD_Format o_e8_SD_Format;
         if (!bDoIt(o_e8_SD_Format))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_E8_SPEECHCATEGORY:
      {
         cmb_fi_tcl_e8_SpeechCategory o_e8_SpeechCategory;
         if (!bDoIt(o_e8_SpeechCategory))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_B16_CATEGORYADDINFO:
      {
         cmb_fi_tcl_b16_CategoryAddInfo o_b16_CategoryAddInfo;
         if (!bDoIt(o_b16_CategoryAddInfo))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_E8_SPEECHSEQUENCE:
      {
         cmb_fi_tcl_e8_SpeechSequence o_e8_SpeechSequence;
         if (!bDoIt(o_e8_SpeechSequence))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_SD_PHRASE:
      {
      if (poVisitor->bDoExpand_SD_Phrase(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_END_OF_STRUCT,cmb_voicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U16,cmb_voicefi_tclSemanticDomain::EN_PHRASENUMBER));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8_SD_PACKAGEID,cmb_voicefi_tclSemanticDomain::EN_PACKAGEID));
      }
      else
      {
         cmb_fi_tcl_SD_Phrase o_SD_Phrase;
         if (!bDoIt(o_SD_Phrase))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_Phrase.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_Phrase.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_voicefi_tclToken::EN_SD_SENTENCE:
      {
      if (poVisitor->bDoExpand_SD_Sentence(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_END_OF_STRUCT,cmb_voicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_SD_PHRASE,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_PHRASES));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_E8_SPEECHSEQUENCE,cmb_voicefi_tclSemanticDomain::EN_SPEECHSEQUENCE));
      }
      else
      {
         cmb_fi_tcl_SD_Sentence o_SD_Sentence;
         if (!bDoIt(o_SD_Sentence))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_Sentence.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_Sentence.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_voicefi_tclToken::EN_SD_SENTENCEANDPARAM:
      {
      if (poVisitor->bDoExpand_SD_SentenceAndParam(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_END_OF_STRUCT,cmb_voicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_B16_CATEGORYADDINFO,cmb_voicefi_tclSemanticDomain::EN_REQUESTADDINFO));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U32,cmb_voicefi_tclSemanticDomain::EN_TIMEOUT));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_E8_SPEECHCATEGORY,cmb_voicefi_tclSemanticDomain::EN_CATEGORY));
         if (5 <= u16MajorVersion)
         {
            (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_STRING,cmb_voicefi_tclSemanticDomain::EN_SENTENCETEXT));
         }
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_SD_PHRASE,cmb_voicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_LIST,cmb_voicefi_tclSemanticDomain::EN_PHRASES));
      }
      else
      {
         cmb_fi_tcl_SD_SentenceAndParam o_SD_SentenceAndParam;
         if (!bDoIt(o_SD_SentenceAndParam))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_SentenceAndParam.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_SentenceAndParam.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_voicefi_tclToken::EN_U16_SD_SAMPLEFREQUENCY:
      {
         cmb_fi_tcl_u16_SD_SampleFrequency o_u16_SD_SampleFrequency;
         if (!bDoIt(o_u16_SD_SampleFrequency))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_SD_SETTINGS:
      {
      if (poVisitor->bDoExpand_SD_Settings(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_END_OF_STRUCT,cmb_voicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_BOOL,cmb_voicefi_tclSemanticDomain::EN_MONO));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8,cmb_voicefi_tclSemanticDomain::EN_RESOLUTION));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U16_SD_SAMPLEFREQUENCY,cmb_voicefi_tclSemanticDomain::EN_SAMPLEFREQUENCY));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_E8_SD_FORMAT,cmb_voicefi_tclSemanticDomain::EN_SPEECHDATAFORMAT));
      }
      else
      {
         cmb_fi_tcl_SD_Settings o_SD_Settings;
         if (!bDoIt(o_SD_Settings))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_Settings.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_Settings.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_voicefi_tclToken::EN_U8_SD_SIZE:
      {
         cmb_fi_tcl_u8_SD_Size o_u8_SD_Size;
         if (!bDoIt(o_u8_SD_Size))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_SD_REFERENCE:
      {
      if (poVisitor->bDoExpand_SD_Reference(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_END_OF_STRUCT,cmb_voicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8_SD_SIZE,cmb_voicefi_tclSemanticDomain::EN_STOPADDSIZE));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8_SD_SIZE,cmb_voicefi_tclSemanticDomain::EN_STARTADDSIZE));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8_SD_SIZE,cmb_voicefi_tclSemanticDomain::EN_PHRASENOSIZE));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U8_SD_SIZE,cmb_voicefi_tclSemanticDomain::EN_HEADERSIZE));
      }
      else
      {
         cmb_fi_tcl_SD_Reference o_SD_Reference;
         if (!bDoIt(o_SD_Reference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_Reference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_Reference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_voicefi_tclToken::EN_E8_STOPVOPRIORITY:
      {
         cmb_fi_tcl_e8_StopVOPriority o_e8_StopVOPriority;
         if (!bDoIt(o_e8_StopVOPriority))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_B8_PHRASESTATUS:
      {
         cmb_fi_tcl_b8_PhraseStatus o_b8_PhraseStatus;
         if (!bDoIt(o_b8_PhraseStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_voicefi_tclToken::EN_TTSPHRASEINFO:
      {
      if (poVisitor->bDoExpand_TTSPhraseInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_END_OF_STRUCT,cmb_voicefi_tclSemanticDomain::EN_UNKNOWN));
         if (5 <= u16MajorVersion)
         {
            (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_B8_PHRASESTATUS,cmb_voicefi_tclSemanticDomain::EN_PHRASESTATUS));
         }
         if (u16MajorVersion <= 4)
         {
            (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_BOOL,cmb_voicefi_tclSemanticDomain::EN_SPEAKABLE));
         }
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U32,cmb_voicefi_tclSemanticDomain::EN_PHRASESIZE));
         (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U16,cmb_voicefi_tclSemanticDomain::EN_PHRASELENGTH));
         if (4 <= u16MajorVersion)
         {
            (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_SD_PHRASE,cmb_voicefi_tclSemanticDomain::EN_PHRASE));
         }
         if (u16MajorVersion <= 3)
         {
            (tVoid) oPath.bGoDown(cmb_voicefi_tclKnot(cmb_voicefi_tclToken::EN_U16,cmb_voicefi_tclSemanticDomain::EN_PHRASENUMBER));
         }
      }
      else
      {
         cmb_fi_tcl_TTSPhraseInfo o_TTSPhraseInfo;
         if (!bDoIt(o_TTSPhraseInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TTSPhraseInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TTSPhraseInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_voicefi_tclToken::EN_UNKNOWN:
      case cmb_voicefi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

