/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef CMB_VEHICLESENSORFITYPES_HEADER
#define CMB_VEHICLESENSORFITYPES_HEADER


class cmb_vehiclesensorfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for cmb_VehicleSensor_FI message types

fi_tclMessageBase* cmb_vehiclesensorfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class cmb_vehiclesensorfi_tclMsgBaseMessage : public cmb_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   cmb_vehiclesensorfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class cmb_vehiclesensorfi_tclMsgSlipUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSlipUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgSlipUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgSlipUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSlipRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSlipRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgSlipRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgSlipRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSlipGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSlipGet();

   virtual ~cmb_vehiclesensorfi_tclMsgSlipGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgSlipGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSlipStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSlipStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgSlipStatus& operator=(const cmb_vehiclesensorfi_tclMsgSlipStatus& coRef);
   cmb_vehiclesensorfi_tclMsgSlipStatus(const cmb_vehiclesensorfi_tclMsgSlipStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   std::vector<cmb_fi_tcl_VeSe_WheelSlip, std::allocator<cmb_fi_tcl_VeSe_WheelSlip> > WheelSlipList;
   virtual ~cmb_vehiclesensorfi_tclMsgSlipStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgSlipStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSpeedUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSpeedUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgSpeedUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgSpeedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSpeedRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSpeedRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgSpeedRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgSpeedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSpeedGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSpeedGet();

   virtual ~cmb_vehiclesensorfi_tclMsgSpeedGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgSpeedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSpeedStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSpeedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgSpeedStatus& operator=(const cmb_vehiclesensorfi_tclMsgSpeedStatus& coRef);
   cmb_vehiclesensorfi_tclMsgSpeedStatus(const cmb_vehiclesensorfi_tclMsgSpeedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_s16_CentimeterSecond VehicleSpeed;
   cmb_fi_tcl_e8_VeSe_VehicleDrivingCondition VehicleDrivingCondition;
   virtual ~cmb_vehiclesensorfi_tclMsgSpeedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgSpeedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgRainUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgRainUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgRainUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgRainUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgRainRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgRainRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgRainRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgRainRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgRainGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgRainGet();

   virtual ~cmb_vehiclesensorfi_tclMsgRainGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgRainGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgRainStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgRainStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgRainStatus& operator=(const cmb_vehiclesensorfi_tclMsgRainStatus& coRef);
   cmb_vehiclesensorfi_tclMsgRainStatus(const cmb_vehiclesensorfi_tclMsgRainStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_u16_RPM WiperSpeed;
   cmb_fi_tcl_u8_Percent IntensityRain;
   cmb_fi_tcl_e8_VeSe_Activation RainSensorInNormalMode;
   virtual ~cmb_vehiclesensorfi_tclMsgRainStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgRainStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgLightsUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgLightsUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgLightsUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgLightsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgLightsRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgLightsRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgLightsRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgLightsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgLightsGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgLightsGet();

   virtual ~cmb_vehiclesensorfi_tclMsgLightsGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgLightsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgLightsStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgLightsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgLightsStatus& operator=(const cmb_vehiclesensorfi_tclMsgLightsStatus& coRef);
   cmb_vehiclesensorfi_tclMsgLightsStatus(const cmb_vehiclesensorfi_tclMsgLightsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_e8_VeSe_HeadLights HeadLights;
   cmb_fi_tcl_e8_VeSe_Activation DaytimeRunningLight;
   cmb_fi_tcl_e8_VeSe_Activation FrontFogLight;
   cmb_fi_tcl_e8_VeSe_Activation RearFogLight;
   cmb_fi_tcl_e8_VeSe_DirectionIndicator DirectionIndication;
   virtual ~cmb_vehiclesensorfi_tclMsgLightsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgLightsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDoorsUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDoorsUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgDoorsUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgDoorsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDoorsRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDoorsRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgDoorsRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgDoorsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDoorsGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDoorsGet();

   virtual ~cmb_vehiclesensorfi_tclMsgDoorsGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgDoorsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDoorsStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDoorsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgDoorsStatus& operator=(const cmb_vehiclesensorfi_tclMsgDoorsStatus& coRef);
   cmb_vehiclesensorfi_tclMsgDoorsStatus(const cmb_vehiclesensorfi_tclMsgDoorsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   std::vector<cmb_fi_tcl_VeSe_DoorStatus, std::allocator<cmb_fi_tcl_VeSe_DoorStatus> > DoorStatusList;
   cmb_fi_tcl_b16_VeSe_CentralLocking CentralLockingState;
   virtual ~cmb_vehiclesensorfi_tclMsgDoorsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgDoorsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgEnginePerformanceUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgEnginePerformanceUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgEnginePerformanceUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgEnginePerformanceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgEnginePerformanceRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgEnginePerformanceRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgEnginePerformanceRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgEnginePerformanceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgEnginePerformanceGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgEnginePerformanceGet();

   virtual ~cmb_vehiclesensorfi_tclMsgEnginePerformanceGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgEnginePerformanceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus& operator=(const cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus& coRef);
   cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus(const cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_u16_RPM EngineSpeed;
   cmb_fi_tcl_u8_Percent AccPedal;
   cmb_fi_tcl_s16_VeSe_Torque WheelMoment;
   cmb_fi_tcl_s16_VeSe_Torque EngineTorque;
   cmb_fi_tcl_e8_VeSe_RotationIrregularity RotationIrregularity;
   cmb_fi_tcl_e8_VeSe_OverrunFuelShutoff OverRunFuelShutoff;
   cmb_fi_tcl_s16_VeSe_Torque TorqueMinimum;
   cmb_fi_tcl_s16_VeSe_Torque TorqueDriversChoice;
   cmb_fi_tcl_s16_VeSe_Torque TorqueDriversChoiceAtClutchLevel;
   cmb_fi_tcl_e8_VeSe_Activation FullLoadActive;
   virtual ~cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgBrakeUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgBrakeUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgBrakeUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgBrakeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgBrakeRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgBrakeRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgBrakeRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgBrakeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgBrakeGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgBrakeGet();

   virtual ~cmb_vehiclesensorfi_tclMsgBrakeGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgBrakeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgBrakeStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgBrakeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgBrakeStatus& operator=(const cmb_vehiclesensorfi_tclMsgBrakeStatus& coRef);
   cmb_vehiclesensorfi_tclMsgBrakeStatus(const cmb_vehiclesensorfi_tclMsgBrakeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_e8_VeSe_Activation BrakePedalPressed;
   std::vector<cmb_fi_tcl_VeSe_WheelBrakePressure, std::allocator<cmb_fi_tcl_VeSe_WheelBrakePressure> > BrakePressureList;
   cmb_fi_tcl_b32_VeSe_BrakeControlMode CloseLoopControlStatus;
   cmb_fi_tcl_e8_VeSe_Activation HandBrakeStatus;
   cmb_fi_tcl_e8_VeSe_Activation EMFBrake;
   cmb_fi_tcl_s16_PerThousand RetarderBrake;
   virtual ~cmb_vehiclesensorfi_tclMsgBrakeStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgBrakeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgGearBoxUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgGearBoxUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgGearBoxUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgGearBoxUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgGearBoxRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgGearBoxRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgGearBoxRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgGearBoxRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgGearBoxGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgGearBoxGet();

   virtual ~cmb_vehiclesensorfi_tclMsgGearBoxGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgGearBoxGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgGearBoxStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgGearBoxStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgGearBoxStatus& operator=(const cmb_vehiclesensorfi_tclMsgGearBoxStatus& coRef);
   cmb_vehiclesensorfi_tclMsgGearBoxStatus(const cmb_vehiclesensorfi_tclMsgGearBoxStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_e8_VeSe_GearNum GearPosition;
   cmb_fi_tcl_e8_VeSe_GearNum GearLeverPosition;
   cmb_fi_tcl_b8_VeSe_GearBoxState GearBoxState;
   cmb_fi_tcl_e8_VeSe_ConverterClutch TorqueConverterLockupClutch;
   cmb_fi_tcl_e8_VeSe_GearboxSportSwitch GearboxSportSwitch;
   cmb_fi_tcl_e8_VeSe_Activation SwitchClutch;
   virtual ~cmb_vehiclesensorfi_tclMsgGearBoxStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgGearBoxStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgIgnitionUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgIgnitionUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgIgnitionUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgIgnitionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgIgnitionRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgIgnitionRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgIgnitionRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgIgnitionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgIgnitionGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgIgnitionGet();

   virtual ~cmb_vehiclesensorfi_tclMsgIgnitionGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgIgnitionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgIgnitionStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgIgnitionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgIgnitionStatus& operator=(const cmb_vehiclesensorfi_tclMsgIgnitionStatus& coRef);
   cmb_vehiclesensorfi_tclMsgIgnitionStatus(const cmb_vehiclesensorfi_tclMsgIgnitionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_e8_VeSe_Ignition Ignition;
   virtual ~cmb_vehiclesensorfi_tclMsgIgnitionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgIgnitionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSteeringWheelAngleUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSteeringWheelAngleUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgSteeringWheelAngleUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgSteeringWheelAngleUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSteeringWheelAngleRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSteeringWheelAngleRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgSteeringWheelAngleRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgSteeringWheelAngleRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSteeringWheelAngleGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSteeringWheelAngleGet();

   virtual ~cmb_vehiclesensorfi_tclMsgSteeringWheelAngleGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgSteeringWheelAngleGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus& operator=(const cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus& coRef);
   cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus(const cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   tS32 WheelAngle;
   tS32 WheelRate;
   cmb_fi_tcl_e8_VeSe_Activation WheelAngleSensorOk;
   cmb_fi_tcl_e8_VeSe_Activation WheelRateSensorOk;
   virtual ~cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgCruiseControlUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgCruiseControlUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgCruiseControlUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgCruiseControlUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgCruiseControlRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgCruiseControlRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgCruiseControlRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgCruiseControlRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgCruiseControlGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgCruiseControlGet();

   virtual ~cmb_vehiclesensorfi_tclMsgCruiseControlGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgCruiseControlGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgCruiseControlStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgCruiseControlStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgCruiseControlStatus& operator=(const cmb_vehiclesensorfi_tclMsgCruiseControlStatus& coRef);
   cmb_vehiclesensorfi_tclMsgCruiseControlStatus(const cmb_vehiclesensorfi_tclMsgCruiseControlStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_e8_VeSe_CCType Type;
   cmb_fi_tcl_e8_VeSe_CCState State;
   cmb_fi_tcl_s16_CentimeterSecond SetSpeed;
   cmb_fi_tcl_e8_VeSe_Activation CoastingActive;
   cmb_fi_tcl_s16_CentimeterSecond CoastingSetSpeed;
   cmb_fi_tcl_e8_VeSe_Activation LockedLeadCar;
   cmb_fi_tcl_e8_VeSe_Activation DistanceToLockedLeadCarSufficient;
   cmb_fi_tcl_s16_Meter DistanceToLockedLeadCar;
   cmb_fi_tcl_s16_CentimeterSecond LockedLeadCarSpeed;
   cmb_fi_tcl_s16_VeSe_Torque DesiredTorqueACC;
   tBool DesiredTorqueApprovedACC;
   cmb_fi_tcl_s16_CentimeterSquareSecond DesiredDecelerationACC;
   tBool DesiredDecelerationApprovedACC;
   virtual ~cmb_vehiclesensorfi_tclMsgCruiseControlStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgCruiseControlStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgHybridOperationUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgHybridOperationUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgHybridOperationUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgHybridOperationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgHybridOperationRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgHybridOperationRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgHybridOperationRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgHybridOperationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgHybridOperationGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgHybridOperationGet();

   virtual ~cmb_vehiclesensorfi_tclMsgHybridOperationGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgHybridOperationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgHybridOperationStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgHybridOperationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgHybridOperationStatus& operator=(const cmb_vehiclesensorfi_tclMsgHybridOperationStatus& coRef);
   cmb_vehiclesensorfi_tclMsgHybridOperationStatus(const cmb_vehiclesensorfi_tclMsgHybridOperationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_s16_PerThousand SOCStatus;
   cmb_fi_tcl_s16_PerThousand SOCSet;
   cmb_fi_tcl_u32_Microliter FuelConsumptionHybrid;
   cmb_fi_tcl_s16_PerThousand FuelSaving;
   tU16 CostFactorCharge;
   tU16 CostFactorDischarge;
   cmb_fi_tcl_e8_VeSe_K0Status StatusK0;
   virtual ~cmb_vehiclesensorfi_tclMsgHybridOperationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgHybridOperationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgVehicleDynamicUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgVehicleDynamicUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgVehicleDynamicUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgVehicleDynamicUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgVehicleDynamicRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgVehicleDynamicRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgVehicleDynamicRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgVehicleDynamicRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgVehicleDynamicGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgVehicleDynamicGet();

   virtual ~cmb_vehiclesensorfi_tclMsgVehicleDynamicGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgVehicleDynamicGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus& operator=(const cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus& coRef);
   cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus(const cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   tU32 OldestTimestamp;
   cmb_fi_tcl_s16_CentiDegreeSecond Yawrate;
   cmb_fi_tcl_s16_CentimeterSquareSecond LongitudinalAcceleration;
   cmb_fi_tcl_s16_CentimeterSquareSecond LateralAcceleration;
   cmb_fi_tcl_s16_PerThousand Slope;
   cmb_fi_tcl_s16_PerThousand SlopeConfidence;
   cmb_fi_tcl_s16_CurvatureValue DrivenCurvature;
   cmb_fi_tcl_s16_PerThousand DrivenCurvatureConfidence;
   virtual ~cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgStaticVehicleParametersUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgStaticVehicleParametersUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgStaticVehicleParametersUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgStaticVehicleParametersUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgStaticVehicleParametersRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgStaticVehicleParametersRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgStaticVehicleParametersRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgStaticVehicleParametersRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgStaticVehicleParametersGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgStaticVehicleParametersGet();

   virtual ~cmb_vehiclesensorfi_tclMsgStaticVehicleParametersGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgStaticVehicleParametersGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus& operator=(const cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus& coRef);
   cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus(const cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tclString ChassisNumber;
   cmb_fi_tcl_s16_CentimeterSecond LowerCriticalVelocity;
   cmb_fi_tcl_e8_VeSe_SideIndicator Drive;
   tU8 NumberOfSeats;
   tU8 NumberOfDoors;
   cmb_fi_tcl_s32_Kilogram VehicleWeight;
   virtual ~cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgKeyStatusUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgKeyStatusUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgKeyStatusUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgKeyStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgKeyStatusRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgKeyStatusRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgKeyStatusRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgKeyStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgKeyStatusGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgKeyStatusGet();

   virtual ~cmb_vehiclesensorfi_tclMsgKeyStatusGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgKeyStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgKeyStatusStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgKeyStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgKeyStatusStatus& operator=(const cmb_vehiclesensorfi_tclMsgKeyStatusStatus& coRef);
   cmb_vehiclesensorfi_tclMsgKeyStatusStatus(const cmb_vehiclesensorfi_tclMsgKeyStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_e8_VeSe_KeyValidity KeyValid;
   tU8 KeyNumber;
   cmb_fi_tcl_e8_VeSe_KeyType KeyTyp;
   cmb_fi_tcl_b16_VeSe_KeyLocation KeyLocation;
   virtual ~cmb_vehiclesensorfi_tclMsgKeyStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgKeyStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgClimateControlUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgClimateControlUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgClimateControlUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgClimateControlUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgClimateControlRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgClimateControlRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgClimateControlRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgClimateControlRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgClimateControlGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgClimateControlGet();

   virtual ~cmb_vehiclesensorfi_tclMsgClimateControlGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgClimateControlGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgClimateControlStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgClimateControlStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgClimateControlStatus& operator=(const cmb_vehiclesensorfi_tclMsgClimateControlStatus& coRef);
   cmb_vehiclesensorfi_tclMsgClimateControlStatus(const cmb_vehiclesensorfi_tclMsgClimateControlStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_e8_VeSe_Activation ACCompressorStatus;
   cmb_fi_tcl_e8_VeSe_Activation ACStatus;
   cmb_fi_tcl_e8_VeSe_Activation DefrosterStatus;
   cmb_fi_tcl_s16_VeSe_Torque CompressorLoad;
   virtual ~cmb_vehiclesensorfi_tclMsgClimateControlStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgClimateControlStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgWindowsUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgWindowsUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgWindowsUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgWindowsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgWindowsRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgWindowsRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgWindowsRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgWindowsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgWindowsGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgWindowsGet();

   virtual ~cmb_vehiclesensorfi_tclMsgWindowsGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgWindowsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgWindowsStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgWindowsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgWindowsStatus& operator=(const cmb_vehiclesensorfi_tclMsgWindowsStatus& coRef);
   cmb_vehiclesensorfi_tclMsgWindowsStatus(const cmb_vehiclesensorfi_tclMsgWindowsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   std::vector<cmb_fi_tcl_VeSe_WindowStatus, std::allocator<cmb_fi_tcl_VeSe_WindowStatus> > WindowPositionList;
   virtual ~cmb_vehiclesensorfi_tclMsgWindowsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgWindowsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgEnvironmentUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgEnvironmentUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgEnvironmentUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgEnvironmentUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgEnvironmentRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgEnvironmentRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgEnvironmentRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgEnvironmentRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgEnvironmentGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgEnvironmentGet();

   virtual ~cmb_vehiclesensorfi_tclMsgEnvironmentGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgEnvironmentGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgEnvironmentStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgEnvironmentStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgEnvironmentStatus& operator=(const cmb_vehiclesensorfi_tclMsgEnvironmentStatus& coRef);
   cmb_vehiclesensorfi_tclMsgEnvironmentStatus(const cmb_vehiclesensorfi_tclMsgEnvironmentStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_s16_DeciKelvin OutsideTemperature;
   cmb_fi_tcl_s32_Pascal AirPressure;
   cmb_fi_tcl_u32_MilliLux AmbienceBrightness;
   virtual ~cmb_vehiclesensorfi_tclMsgEnvironmentStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgEnvironmentStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgWheelsUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgWheelsUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgWheelsUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgWheelsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgWheelsRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgWheelsRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgWheelsRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgWheelsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgWheelsGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgWheelsGet();

   virtual ~cmb_vehiclesensorfi_tclMsgWheelsGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgWheelsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgWheelsStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgWheelsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgWheelsStatus& operator=(const cmb_vehiclesensorfi_tclMsgWheelsStatus& coRef);
   cmb_vehiclesensorfi_tclMsgWheelsStatus(const cmb_vehiclesensorfi_tclMsgWheelsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   std::vector<cmb_fi_tcl_VeSe_WheelAirPressure, std::allocator<cmb_fi_tcl_VeSe_WheelAirPressure> > TirePressureList;
   virtual ~cmb_vehiclesensorfi_tclMsgWheelsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgWheelsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgVehicleLoadUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgVehicleLoadUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgVehicleLoadUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgVehicleLoadUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgVehicleLoadRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgVehicleLoadRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgVehicleLoadRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgVehicleLoadRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgVehicleLoadGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgVehicleLoadGet();

   virtual ~cmb_vehiclesensorfi_tclMsgVehicleLoadGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgVehicleLoadGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgVehicleLoadStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgVehicleLoadStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgVehicleLoadStatus& operator=(const cmb_vehiclesensorfi_tclMsgVehicleLoadStatus& coRef);
   cmb_vehiclesensorfi_tclMsgVehicleLoadStatus(const cmb_vehiclesensorfi_tclMsgVehicleLoadStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_s16_DirectionRelative_CentiDegree VehicleTilt;
   cmb_fi_tcl_e8_VeSe_Activation TrailerAttached;
   virtual ~cmb_vehiclesensorfi_tclMsgVehicleLoadStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgVehicleLoadStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgEngineParameterUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgEngineParameterUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgEngineParameterUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgEngineParameterUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgEngineParameterRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgEngineParameterRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgEngineParameterRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgEngineParameterRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgEngineParameterGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgEngineParameterGet();

   virtual ~cmb_vehiclesensorfi_tclMsgEngineParameterGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgEngineParameterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgEngineParameterStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgEngineParameterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgEngineParameterStatus& operator=(const cmb_vehiclesensorfi_tclMsgEngineParameterStatus& coRef);
   cmb_vehiclesensorfi_tclMsgEngineParameterStatus(const cmb_vehiclesensorfi_tclMsgEngineParameterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_s16_DeciKelvin TemperatureEngine;
   cmb_fi_tcl_s16_DeciKelvin TemperatureEngineOil;
   cmb_fi_tcl_b16_VeSe_EngineStatus StatusEngineRunning;
   cmb_fi_tcl_u32_Microliter InjectionVolumeFuel;
   cmb_fi_tcl_e8_VeSe_ReductionRPM ReductionDownControlRPM;
   cmb_fi_tcl_e8_VeSe_Activation StatusRBMZyklus;
   tU16 RPMIdlingTarget;
   virtual ~cmb_vehiclesensorfi_tclMsgEngineParameterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgEngineParameterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDefrosterUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDefrosterUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgDefrosterUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgDefrosterUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDefrosterRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDefrosterRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgDefrosterRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgDefrosterRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDefrosterGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDefrosterGet();

   virtual ~cmb_vehiclesensorfi_tclMsgDefrosterGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgDefrosterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDefrosterStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDefrosterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgDefrosterStatus& operator=(const cmb_vehiclesensorfi_tclMsgDefrosterStatus& coRef);
   cmb_vehiclesensorfi_tclMsgDefrosterStatus(const cmb_vehiclesensorfi_tclMsgDefrosterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_e8_VeSe_Activation RearDefroster;
   cmb_fi_tcl_e8_VeSe_Activation RearViewDefroster;
   cmb_fi_tcl_e8_VeSe_Activation FrontDefroster;
   virtual ~cmb_vehiclesensorfi_tclMsgDefrosterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgDefrosterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgLDWUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgLDWUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgLDWUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgLDWUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgLDWRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgLDWRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgLDWRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgLDWRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgLDWGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgLDWGet();

   virtual ~cmb_vehiclesensorfi_tclMsgLDWGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgLDWGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgLDWStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgLDWStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgLDWStatus& operator=(const cmb_vehiclesensorfi_tclMsgLDWStatus& coRef);
   cmb_vehiclesensorfi_tclMsgLDWStatus(const cmb_vehiclesensorfi_tclMsgLDWStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_s32_Centimeter DistanceToLine;
   cmb_fi_tcl_u16_MilliSecond TimeToLine;
   cmb_fi_tcl_e8_VeSe_SideIndicator LDWSideIndicator;
   virtual ~cmb_vehiclesensorfi_tclMsgLDWStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgLDWStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgLaneDetectionUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgLaneDetectionUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgLaneDetectionUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgLaneDetectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgLaneDetectionRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgLaneDetectionRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgLaneDetectionRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgLaneDetectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgLaneDetectionGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgLaneDetectionGet();

   virtual ~cmb_vehiclesensorfi_tclMsgLaneDetectionGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgLaneDetectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgLaneDetectionStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgLaneDetectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgLaneDetectionStatus& operator=(const cmb_vehiclesensorfi_tclMsgLaneDetectionStatus& coRef);
   cmb_vehiclesensorfi_tclMsgLaneDetectionStatus(const cmb_vehiclesensorfi_tclMsgLaneDetectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   std::vector<cmb_fi_tcl_VeSe_LineInfo, std::allocator<cmb_fi_tcl_VeSe_LineInfo> > DetectedLineList;
   virtual ~cmb_vehiclesensorfi_tclMsgLaneDetectionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgLaneDetectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDetectedObjectsUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDetectedObjectsUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgDetectedObjectsUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgDetectedObjectsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDetectedObjectsRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDetectedObjectsRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgDetectedObjectsRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgDetectedObjectsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDetectedObjectsGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDetectedObjectsGet();

   virtual ~cmb_vehiclesensorfi_tclMsgDetectedObjectsGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgDetectedObjectsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus& operator=(const cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus& coRef);
   cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus(const cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   tU32 OldestTimestamp;
   std::vector<cmb_fi_tcl_VeSe_DetectedObject, std::allocator<cmb_fi_tcl_VeSe_DetectedObject> > DetectedObjectsList;
   virtual ~cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsGet();

   virtual ~cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus& operator=(const cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus& coRef);
   cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus(const cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   std::vector<cmb_fi_tcl_VeSe_DetectedTrafficSign, std::allocator<cmb_fi_tcl_VeSe_DetectedTrafficSign> > DetectedTrafficSignList;
   virtual ~cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSeatsUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSeatsUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgSeatsUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgSeatsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSeatsRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSeatsRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgSeatsRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgSeatsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSeatsGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSeatsGet();

   virtual ~cmb_vehiclesensorfi_tclMsgSeatsGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgSeatsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgSeatsStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgSeatsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgSeatsStatus& operator=(const cmb_vehiclesensorfi_tclMsgSeatsStatus& coRef);
   cmb_vehiclesensorfi_tclMsgSeatsStatus(const cmb_vehiclesensorfi_tclMsgSeatsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   std::vector<cmb_fi_tcl_VeSe_SeatStatus, std::allocator<cmb_fi_tcl_VeSe_SeatStatus> > SeatList;
   virtual ~cmb_vehiclesensorfi_tclMsgSeatsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgSeatsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgElectricalMachineUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgElectricalMachineUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgElectricalMachineUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgElectricalMachineUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgElectricalMachineRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgElectricalMachineRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgElectricalMachineRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgElectricalMachineRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgElectricalMachineGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgElectricalMachineGet();

   virtual ~cmb_vehiclesensorfi_tclMsgElectricalMachineGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgElectricalMachineGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgElectricalMachineStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgElectricalMachineStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgElectricalMachineStatus& operator=(const cmb_vehiclesensorfi_tclMsgElectricalMachineStatus& coRef);
   cmb_vehiclesensorfi_tclMsgElectricalMachineStatus(const cmb_vehiclesensorfi_tclMsgElectricalMachineStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_ElectricalMachine, std::allocator<cmb_fi_tcl_ElectricalMachine> > ElectricalMachineList;
   virtual ~cmb_vehiclesensorfi_tclMsgElectricalMachineStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgElectricalMachineStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgBatteryStatusUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgBatteryStatusUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgBatteryStatusUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgBatteryStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgBatteryStatusRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgBatteryStatusRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgBatteryStatusRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgBatteryStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgBatteryStatusGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgBatteryStatusGet();

   virtual ~cmb_vehiclesensorfi_tclMsgBatteryStatusGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgBatteryStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgBatteryStatusStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgBatteryStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgBatteryStatusStatus& operator=(const cmb_vehiclesensorfi_tclMsgBatteryStatusStatus& coRef);
   cmb_vehiclesensorfi_tclMsgBatteryStatusStatus(const cmb_vehiclesensorfi_tclMsgBatteryStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_u32_Ws RemainingCapacity;
   cmb_fi_tcl_u32_Ws NominalCapacity;
   cmb_fi_tcl_s16_PerThousand SOCStatus;
   cmb_fi_tcl_s16_PerThousand SOCSet;
   cmb_fi_tcl_s16_DeciKelvin BatteryTemperature;
   cmb_fi_tcl_VeSe_VoltageParams BatteryVoltageParams;
   cmb_fi_tcl_VeSe_CurrentParams BatteryCurrentParams;
   virtual ~cmb_vehiclesensorfi_tclMsgBatteryStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgBatteryStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionGet();

   virtual ~cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus& operator=(const cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus& coRef);
   cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus(const cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   cmb_fi_tcl_EnergyConsumption InitialConditioningMinEnergyConsumption;
   std::vector<cmb_fi_tcl_PowerDemandAtSpeed, std::allocator<cmb_fi_tcl_PowerDemandAtSpeed> > MaintainingConditionMinPowerDemand;
   cmb_fi_tcl_EnergyConsumption InitialConditioningMaxEnergyConsumption;
   std::vector<cmb_fi_tcl_PowerDemandAtSpeed, std::allocator<cmb_fi_tcl_PowerDemandAtSpeed> > MaintainingConditionMaxPowerDemand;
   cmb_fi_tcl_EnergyConsumption InitialConditioningAverageEnergyConsumption;
   std::vector<cmb_fi_tcl_PowerDemandAtSpeed, std::allocator<cmb_fi_tcl_PowerDemandAtSpeed> > MaintainingConditionAveragePowerDemand;
   virtual ~cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgProblemMarkerUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgProblemMarkerUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgProblemMarkerUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgProblemMarkerUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgProblemMarkerRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgProblemMarkerRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgProblemMarkerRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgProblemMarkerRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgProblemMarkerGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgProblemMarkerGet();

   virtual ~cmb_vehiclesensorfi_tclMsgProblemMarkerGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgProblemMarkerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgProblemMarkerStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgProblemMarkerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgProblemMarkerStatus& operator=(const cmb_vehiclesensorfi_tclMsgProblemMarkerStatus& coRef);
   cmb_vehiclesensorfi_tclMsgProblemMarkerStatus(const cmb_vehiclesensorfi_tclMsgProblemMarkerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   tU64 LinkId;
   cmb_fi_tcl_s32_Centimeter OffsetOnLinkId;
   cmb_fi_tcl_PositionWGS84 Position;
   tU8 EntityTypeId;
   tU8 EntityContent;
   tU8 EntityId;
   cmb_fi_tcl_s32_MilliSecond TimeExtensionBackwards;
   cmb_fi_tcl_s32_MilliSecond TimeExtensionForward;
   cmb_fi_tcl_s32_Centimeter DistanceExtensionBackwards;
   cmb_fi_tcl_s32_Centimeter DistanceExtensionForward;
   virtual ~cmb_vehiclesensorfi_tclMsgProblemMarkerStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgProblemMarkerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSGet();

   virtual ~cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus& operator=(const cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus& coRef);
   cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus(const cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   tU64 StartLinkId;
   cmb_fi_tcl_s32_Centimeter OffsetOnStartLinkId;
   tU64 EndLinkId;
   cmb_fi_tcl_s32_Centimeter OffsetOnEndLinkId;
   tU8 EntityTypeId;
   tU8 EntityContent;
   tU16 EntityId;
   virtual ~cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgIPPCPlusDataUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgIPPCPlusDataUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgIPPCPlusDataUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgIPPCPlusDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgIPPCPlusDataRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgIPPCPlusDataRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgIPPCPlusDataRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgIPPCPlusDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgIPPCPlusDataGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgIPPCPlusDataGet();

   virtual ~cmb_vehiclesensorfi_tclMsgIPPCPlusDataGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgIPPCPlusDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus& operator=(const cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus& coRef);
   cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus(const cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_VeSe_IPPCPlusData, std::allocator<cmb_fi_tcl_VeSe_IPPCPlusData> > DataList;
   virtual ~cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoRelUpReg : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoRelUpReg();

   virtual ~cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoRelUpReg();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoGet : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoGet();

   virtual ~cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoGet();

   inline tBool operator==(const cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus : public cmb_vehiclesensorfi_tclMsgBaseMessage
{
public:

   cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus& operator=(const cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus& coRef);
   cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus(const cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Timestamp;
   tU8 VehicleType;
   tU8 TrailerConnected;
   tU16 GrossVehicleWeight;
   tU8 HazardousGoods;
   tS8 OffsetUTC_Hours;
   tS8 OffsetUTC_Minutes;
   virtual ~cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
