/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CMB_FI_S_IMPORT_INTERFACE_CMB_VEHICLESENSORFI_TYPES
#define CMB_FI_S_IMPORT_INTERFACE_CMB_VEHICLESENSORFI_FUNCTIONIDS
#define CMB_FI_S_IMPORT_INTERFACE_CMB_VEHICLESENSORFI_SERVICEINFO
#include "cmb_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for cmb_VehicleSensor_FI message types

fi_tclMessageBase* cmb_vehiclesensorfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSlipUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSlipRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSlipGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSlipStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSpeedUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSpeedRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSpeedGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSpeedStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_RAINUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgRainUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_RAINRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgRainRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_RAINGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgRainGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_RAINSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgRainStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgLightsUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgLightsRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgLightsGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgLightsStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDoorsUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDoorsRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDoorsGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDoorsStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCEUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgEnginePerformanceUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCERELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgEnginePerformanceRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCEGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgEnginePerformanceGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCESTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKEUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgBrakeUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKERELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgBrakeRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKEGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgBrakeGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKESTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgBrakeStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgGearBoxUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgGearBoxRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgGearBoxGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgGearBoxStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgIgnitionUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgIgnitionRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgIgnitionGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgIgnitionStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLEUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSteeringWheelAngleUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLERELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSteeringWheelAngleRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLEGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSteeringWheelAngleGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLESTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgCruiseControlUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgCruiseControlRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgCruiseControlGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgCruiseControlStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgHybridOperationUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgHybridOperationRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgHybridOperationGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgHybridOperationStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgVehicleDynamicUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgVehicleDynamicRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgVehicleDynamicGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgStaticVehicleParametersUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgStaticVehicleParametersRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgStaticVehicleParametersGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgKeyStatusUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgKeyStatusRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgKeyStatusGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgKeyStatusStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgClimateControlUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgClimateControlRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgClimateControlGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgClimateControlStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgWindowsUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgWindowsRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgWindowsGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgWindowsStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgEnvironmentUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgEnvironmentRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgEnvironmentGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgEnvironmentStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgWheelsUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgWheelsRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgWheelsGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgWheelsStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgVehicleLoadUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgVehicleLoadRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgVehicleLoadGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgVehicleLoadStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgEngineParameterUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgEngineParameterRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgEngineParameterGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgEngineParameterStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDefrosterUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDefrosterRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDefrosterGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDefrosterStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_LDWUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgLDWUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_LDWRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgLDWRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_LDWGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgLDWGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_LDWSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgLDWStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgLaneDetectionUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgLaneDetectionRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgLaneDetectionGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgLaneDetectionStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDetectedObjectsUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDetectedObjectsRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDetectedObjectsGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSeatsUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSeatsRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSeatsGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgSeatsStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINEUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgElectricalMachineUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINERELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgElectricalMachineRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINEGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgElectricalMachineGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINESTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgElectricalMachineStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgBatteryStatusUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgBatteryStatusRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgBatteryStatusGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgBatteryStatusStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgProblemMarkerUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgProblemMarkerRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgProblemMarkerGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgProblemMarkerStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSRELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATAUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgIPPCPlusDataUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATARELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgIPPCPlusDataRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATAGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgIPPCPlusDataGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATASTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFOUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFORELUPREG:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoRelUpReg;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFOGET:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoGet;

      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFOSTATUS:
         return OSAL_NEW cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all cmb_vehiclesensorfifi messages

// common functions

tU16 cmb_vehiclesensorfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return CMB_VEHICLESENSORFI_C_U16_SERVICE_ID;
}

tU16 cmb_vehiclesensorfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 cmb_vehiclesensorfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& cmb_vehiclesensorfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& cmb_vehiclesensorfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 cmb_vehiclesensorfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgSlipUpReg::cmb_vehiclesensorfi_tclMsgSlipUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSlipUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPUPREG;
}


cmb_vehiclesensorfi_tclMsgSlipUpReg::~cmb_vehiclesensorfi_tclMsgSlipUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgSlipRelUpReg::cmb_vehiclesensorfi_tclMsgSlipRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSlipRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPRELUPREG;
}


cmb_vehiclesensorfi_tclMsgSlipRelUpReg::~cmb_vehiclesensorfi_tclMsgSlipRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgSlipGet::cmb_vehiclesensorfi_tclMsgSlipGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSlipGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPGET;
}


cmb_vehiclesensorfi_tclMsgSlipGet::~cmb_vehiclesensorfi_tclMsgSlipGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgSlipStatus::cmb_vehiclesensorfi_tclMsgSlipStatus(const cmb_vehiclesensorfi_tclMsgSlipStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   WheelSlipList = coRef.WheelSlipList;
}
cmb_vehiclesensorfi_tclMsgSlipStatus& cmb_vehiclesensorfi_tclMsgSlipStatus::operator=(const cmb_vehiclesensorfi_tclMsgSlipStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   WheelSlipList = coRef.WheelSlipList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgSlipStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < WheelSlipList.size(); ++u32Idx)
         WheelSlipList[u32Idx].vDestroy();
   WheelSlipList.clear();
   }
}

cmb_vehiclesensorfi_tclMsgSlipStatus::cmb_vehiclesensorfi_tclMsgSlipStatus()
:Timestamp(0)

 {}

tS32 cmb_vehiclesensorfi_tclMsgSlipStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPSTATUS;
}


cmb_vehiclesensorfi_tclMsgSlipStatus::~cmb_vehiclesensorfi_tclMsgSlipStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgSlipStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(WheelSlipList.size()*4);
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgSlipStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < WheelSlipList.size(); ++u32Idx)
      {
         WheelSlipList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      WheelSlipList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> WheelSlipList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgSlipStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << (tU32)WheelSlipList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < WheelSlipList.size(); ++u32Idx)
         (tVoid) (oOut << WheelSlipList[u32Idx]);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgSlipStatus::operator==(const cmb_vehiclesensorfi_tclMsgSlipStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
      bResult = bResult && (WheelSlipList.size() == roRef.WheelSlipList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WheelSlipList.size()); ++u32Idx)
            bResult = bResult && (WheelSlipList[u32Idx] == roRef.WheelSlipList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgSpeedUpReg::cmb_vehiclesensorfi_tclMsgSpeedUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSpeedUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDUPREG;
}


cmb_vehiclesensorfi_tclMsgSpeedUpReg::~cmb_vehiclesensorfi_tclMsgSpeedUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgSpeedRelUpReg::cmb_vehiclesensorfi_tclMsgSpeedRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSpeedRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDRELUPREG;
}


cmb_vehiclesensorfi_tclMsgSpeedRelUpReg::~cmb_vehiclesensorfi_tclMsgSpeedRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgSpeedGet::cmb_vehiclesensorfi_tclMsgSpeedGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSpeedGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDGET;
}


cmb_vehiclesensorfi_tclMsgSpeedGet::~cmb_vehiclesensorfi_tclMsgSpeedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgSpeedStatus::cmb_vehiclesensorfi_tclMsgSpeedStatus(const cmb_vehiclesensorfi_tclMsgSpeedStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   VehicleSpeed = coRef.VehicleSpeed;
   VehicleDrivingCondition = coRef.VehicleDrivingCondition;
}
cmb_vehiclesensorfi_tclMsgSpeedStatus& cmb_vehiclesensorfi_tclMsgSpeedStatus::operator=(const cmb_vehiclesensorfi_tclMsgSpeedStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   VehicleSpeed = coRef.VehicleSpeed;
   VehicleDrivingCondition = coRef.VehicleDrivingCondition;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgSpeedStatus::cmb_vehiclesensorfi_tclMsgSpeedStatus()
:Timestamp(0)
,VehicleSpeed()
,VehicleDrivingCondition()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSpeedStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDSTATUS;
}


cmb_vehiclesensorfi_tclMsgSpeedStatus::~cmb_vehiclesensorfi_tclMsgSpeedStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgSpeedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgSpeedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> VehicleSpeed);
   (tVoid) (oIn >> VehicleDrivingCondition);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgSpeedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << VehicleSpeed);
   (tVoid) (oOut << VehicleDrivingCondition);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgSpeedStatus::operator==(const cmb_vehiclesensorfi_tclMsgSpeedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (VehicleSpeed == roRef.VehicleSpeed);
   bResult = bResult && (VehicleDrivingCondition == roRef.VehicleDrivingCondition);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgRainUpReg::cmb_vehiclesensorfi_tclMsgRainUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgRainUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_RAINUPREG;
}


cmb_vehiclesensorfi_tclMsgRainUpReg::~cmb_vehiclesensorfi_tclMsgRainUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgRainRelUpReg::cmb_vehiclesensorfi_tclMsgRainRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgRainRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_RAINRELUPREG;
}


cmb_vehiclesensorfi_tclMsgRainRelUpReg::~cmb_vehiclesensorfi_tclMsgRainRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgRainGet::cmb_vehiclesensorfi_tclMsgRainGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgRainGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_RAINGET;
}


cmb_vehiclesensorfi_tclMsgRainGet::~cmb_vehiclesensorfi_tclMsgRainGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgRainStatus::cmb_vehiclesensorfi_tclMsgRainStatus(const cmb_vehiclesensorfi_tclMsgRainStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   WiperSpeed = coRef.WiperSpeed;
   IntensityRain = coRef.IntensityRain;
   RainSensorInNormalMode = coRef.RainSensorInNormalMode;
}
cmb_vehiclesensorfi_tclMsgRainStatus& cmb_vehiclesensorfi_tclMsgRainStatus::operator=(const cmb_vehiclesensorfi_tclMsgRainStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   WiperSpeed = coRef.WiperSpeed;
   IntensityRain = coRef.IntensityRain;
   RainSensorInNormalMode = coRef.RainSensorInNormalMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgRainStatus::cmb_vehiclesensorfi_tclMsgRainStatus()
:Timestamp(0)
,WiperSpeed()
,IntensityRain()
,RainSensorInNormalMode()
 {}

tS32 cmb_vehiclesensorfi_tclMsgRainStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_RAINSTATUS;
}


cmb_vehiclesensorfi_tclMsgRainStatus::~cmb_vehiclesensorfi_tclMsgRainStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgRainStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgRainStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> WiperSpeed);
   (tVoid) (oIn >> IntensityRain);
   (tVoid) (oIn >> RainSensorInNormalMode);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgRainStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << WiperSpeed);
   (tVoid) (oOut << IntensityRain);
   (tVoid) (oOut << RainSensorInNormalMode);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgRainStatus::operator==(const cmb_vehiclesensorfi_tclMsgRainStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (WiperSpeed == roRef.WiperSpeed);
   bResult = bResult && (IntensityRain == roRef.IntensityRain);
   bResult = bResult && (RainSensorInNormalMode == roRef.RainSensorInNormalMode);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgLightsUpReg::cmb_vehiclesensorfi_tclMsgLightsUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgLightsUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSUPREG;
}


cmb_vehiclesensorfi_tclMsgLightsUpReg::~cmb_vehiclesensorfi_tclMsgLightsUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgLightsRelUpReg::cmb_vehiclesensorfi_tclMsgLightsRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgLightsRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSRELUPREG;
}


cmb_vehiclesensorfi_tclMsgLightsRelUpReg::~cmb_vehiclesensorfi_tclMsgLightsRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgLightsGet::cmb_vehiclesensorfi_tclMsgLightsGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgLightsGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSGET;
}


cmb_vehiclesensorfi_tclMsgLightsGet::~cmb_vehiclesensorfi_tclMsgLightsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgLightsStatus::cmb_vehiclesensorfi_tclMsgLightsStatus(const cmb_vehiclesensorfi_tclMsgLightsStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   HeadLights = coRef.HeadLights;
   DaytimeRunningLight = coRef.DaytimeRunningLight;
   FrontFogLight = coRef.FrontFogLight;
   RearFogLight = coRef.RearFogLight;
   DirectionIndication = coRef.DirectionIndication;
}
cmb_vehiclesensorfi_tclMsgLightsStatus& cmb_vehiclesensorfi_tclMsgLightsStatus::operator=(const cmb_vehiclesensorfi_tclMsgLightsStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   HeadLights = coRef.HeadLights;
   DaytimeRunningLight = coRef.DaytimeRunningLight;
   FrontFogLight = coRef.FrontFogLight;
   RearFogLight = coRef.RearFogLight;
   DirectionIndication = coRef.DirectionIndication;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgLightsStatus::cmb_vehiclesensorfi_tclMsgLightsStatus()
:Timestamp(0)
,HeadLights()
,DaytimeRunningLight()
,FrontFogLight()
,RearFogLight()
,DirectionIndication()
 {}

tS32 cmb_vehiclesensorfi_tclMsgLightsStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSSTATUS;
}


cmb_vehiclesensorfi_tclMsgLightsStatus::~cmb_vehiclesensorfi_tclMsgLightsStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgLightsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgLightsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> HeadLights);
   (tVoid) (oIn >> DaytimeRunningLight);
   (tVoid) (oIn >> FrontFogLight);
   (tVoid) (oIn >> RearFogLight);
   (tVoid) (oIn >> DirectionIndication);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgLightsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << HeadLights);
   (tVoid) (oOut << DaytimeRunningLight);
   (tVoid) (oOut << FrontFogLight);
   (tVoid) (oOut << RearFogLight);
   (tVoid) (oOut << DirectionIndication);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgLightsStatus::operator==(const cmb_vehiclesensorfi_tclMsgLightsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (HeadLights == roRef.HeadLights);
   bResult = bResult && (DaytimeRunningLight == roRef.DaytimeRunningLight);
   bResult = bResult && (FrontFogLight == roRef.FrontFogLight);
   bResult = bResult && (RearFogLight == roRef.RearFogLight);
   bResult = bResult && (DirectionIndication == roRef.DirectionIndication);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgDoorsUpReg::cmb_vehiclesensorfi_tclMsgDoorsUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDoorsUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSUPREG;
}


cmb_vehiclesensorfi_tclMsgDoorsUpReg::~cmb_vehiclesensorfi_tclMsgDoorsUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgDoorsRelUpReg::cmb_vehiclesensorfi_tclMsgDoorsRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDoorsRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSRELUPREG;
}


cmb_vehiclesensorfi_tclMsgDoorsRelUpReg::~cmb_vehiclesensorfi_tclMsgDoorsRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgDoorsGet::cmb_vehiclesensorfi_tclMsgDoorsGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDoorsGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSGET;
}


cmb_vehiclesensorfi_tclMsgDoorsGet::~cmb_vehiclesensorfi_tclMsgDoorsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgDoorsStatus::cmb_vehiclesensorfi_tclMsgDoorsStatus(const cmb_vehiclesensorfi_tclMsgDoorsStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   DoorStatusList = coRef.DoorStatusList;
   CentralLockingState = coRef.CentralLockingState;
}
cmb_vehiclesensorfi_tclMsgDoorsStatus& cmb_vehiclesensorfi_tclMsgDoorsStatus::operator=(const cmb_vehiclesensorfi_tclMsgDoorsStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   DoorStatusList = coRef.DoorStatusList;
   CentralLockingState = coRef.CentralLockingState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgDoorsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DoorStatusList.size(); ++u32Idx)
         DoorStatusList[u32Idx].vDestroy();
   DoorStatusList.clear();
   }
}

cmb_vehiclesensorfi_tclMsgDoorsStatus::cmb_vehiclesensorfi_tclMsgDoorsStatus()
:Timestamp(0)

,CentralLockingState()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDoorsStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSSTATUS;
}


cmb_vehiclesensorfi_tclMsgDoorsStatus::~cmb_vehiclesensorfi_tclMsgDoorsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgDoorsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10+ static_cast<tU32>(DoorStatusList.size()*4);
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgDoorsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DoorStatusList.size(); ++u32Idx)
      {
         DoorStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DoorStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DoorStatusList[u32Idx]);
      }
   }
   (tVoid) (oIn >> CentralLockingState);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgDoorsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << (tU32)DoorStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DoorStatusList.size(); ++u32Idx)
         (tVoid) (oOut << DoorStatusList[u32Idx]);
   }
   (tVoid) (oOut << CentralLockingState);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgDoorsStatus::operator==(const cmb_vehiclesensorfi_tclMsgDoorsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
      bResult = bResult && (DoorStatusList.size() == roRef.DoorStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DoorStatusList.size()); ++u32Idx)
            bResult = bResult && (DoorStatusList[u32Idx] == roRef.DoorStatusList[u32Idx]);
      }
   bResult = bResult && (CentralLockingState == roRef.CentralLockingState);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgEnginePerformanceUpReg::cmb_vehiclesensorfi_tclMsgEnginePerformanceUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgEnginePerformanceUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCEUPREG;
}


cmb_vehiclesensorfi_tclMsgEnginePerformanceUpReg::~cmb_vehiclesensorfi_tclMsgEnginePerformanceUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgEnginePerformanceRelUpReg::cmb_vehiclesensorfi_tclMsgEnginePerformanceRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgEnginePerformanceRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCERELUPREG;
}


cmb_vehiclesensorfi_tclMsgEnginePerformanceRelUpReg::~cmb_vehiclesensorfi_tclMsgEnginePerformanceRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgEnginePerformanceGet::cmb_vehiclesensorfi_tclMsgEnginePerformanceGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgEnginePerformanceGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCEGET;
}


cmb_vehiclesensorfi_tclMsgEnginePerformanceGet::~cmb_vehiclesensorfi_tclMsgEnginePerformanceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus::cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus(const cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   EngineSpeed = coRef.EngineSpeed;
   AccPedal = coRef.AccPedal;
   WheelMoment = coRef.WheelMoment;
   EngineTorque = coRef.EngineTorque;
   RotationIrregularity = coRef.RotationIrregularity;
   OverRunFuelShutoff = coRef.OverRunFuelShutoff;
   TorqueMinimum = coRef.TorqueMinimum;
   TorqueDriversChoice = coRef.TorqueDriversChoice;
   TorqueDriversChoiceAtClutchLevel = coRef.TorqueDriversChoiceAtClutchLevel;
   FullLoadActive = coRef.FullLoadActive;
}
cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus& cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus::operator=(const cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   EngineSpeed = coRef.EngineSpeed;
   AccPedal = coRef.AccPedal;
   WheelMoment = coRef.WheelMoment;
   EngineTorque = coRef.EngineTorque;
   RotationIrregularity = coRef.RotationIrregularity;
   OverRunFuelShutoff = coRef.OverRunFuelShutoff;
   TorqueMinimum = coRef.TorqueMinimum;
   TorqueDriversChoice = coRef.TorqueDriversChoice;
   TorqueDriversChoiceAtClutchLevel = coRef.TorqueDriversChoiceAtClutchLevel;
   FullLoadActive = coRef.FullLoadActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus::cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus()
:Timestamp(0)
,EngineSpeed()
,AccPedal()
,WheelMoment()
,EngineTorque()
,RotationIrregularity()
,OverRunFuelShutoff()
,TorqueMinimum()
,TorqueDriversChoice()
,TorqueDriversChoiceAtClutchLevel()
,FullLoadActive()
 {}

tS32 cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCESTATUS;
}


cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus::~cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (10 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+17;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> EngineSpeed);
   (tVoid) (oIn >> AccPedal);
   (tVoid) (oIn >> WheelMoment);
   (tVoid) (oIn >> EngineTorque);
   (tVoid) (oIn >> RotationIrregularity);
   (tVoid) (oIn >> OverRunFuelShutoff);
   (tVoid) (oIn >> TorqueMinimum);
   (tVoid) (oIn >> TorqueDriversChoice);
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> TorqueDriversChoiceAtClutchLevel);
   }
   if (10 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> FullLoadActive);
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << EngineSpeed);
   (tVoid) (oOut << AccPedal);
   (tVoid) (oOut << WheelMoment);
   (tVoid) (oOut << EngineTorque);
   (tVoid) (oOut << RotationIrregularity);
   (tVoid) (oOut << OverRunFuelShutoff);
   (tVoid) (oOut << TorqueMinimum);
   (tVoid) (oOut << TorqueDriversChoice);
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << TorqueDriversChoiceAtClutchLevel);
   }
   if (10 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << FullLoadActive);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus::operator==(const cmb_vehiclesensorfi_tclMsgEnginePerformanceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (EngineSpeed == roRef.EngineSpeed);
   bResult = bResult && (AccPedal == roRef.AccPedal);
   bResult = bResult && (WheelMoment == roRef.WheelMoment);
   bResult = bResult && (EngineTorque == roRef.EngineTorque);
   bResult = bResult && (RotationIrregularity == roRef.RotationIrregularity);
   bResult = bResult && (OverRunFuelShutoff == roRef.OverRunFuelShutoff);
   bResult = bResult && (TorqueMinimum == roRef.TorqueMinimum);
   bResult = bResult && (TorqueDriversChoice == roRef.TorqueDriversChoice);
   bResult = bResult && (TorqueDriversChoiceAtClutchLevel == roRef.TorqueDriversChoiceAtClutchLevel);
   bResult = bResult && (FullLoadActive == roRef.FullLoadActive);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgBrakeUpReg::cmb_vehiclesensorfi_tclMsgBrakeUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgBrakeUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKEUPREG;
}


cmb_vehiclesensorfi_tclMsgBrakeUpReg::~cmb_vehiclesensorfi_tclMsgBrakeUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgBrakeRelUpReg::cmb_vehiclesensorfi_tclMsgBrakeRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgBrakeRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKERELUPREG;
}


cmb_vehiclesensorfi_tclMsgBrakeRelUpReg::~cmb_vehiclesensorfi_tclMsgBrakeRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgBrakeGet::cmb_vehiclesensorfi_tclMsgBrakeGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgBrakeGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKEGET;
}


cmb_vehiclesensorfi_tclMsgBrakeGet::~cmb_vehiclesensorfi_tclMsgBrakeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgBrakeStatus::cmb_vehiclesensorfi_tclMsgBrakeStatus(const cmb_vehiclesensorfi_tclMsgBrakeStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   BrakePedalPressed = coRef.BrakePedalPressed;
   BrakePressureList = coRef.BrakePressureList;
   CloseLoopControlStatus = coRef.CloseLoopControlStatus;
   HandBrakeStatus = coRef.HandBrakeStatus;
   EMFBrake = coRef.EMFBrake;
   RetarderBrake = coRef.RetarderBrake;
}
cmb_vehiclesensorfi_tclMsgBrakeStatus& cmb_vehiclesensorfi_tclMsgBrakeStatus::operator=(const cmb_vehiclesensorfi_tclMsgBrakeStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   BrakePedalPressed = coRef.BrakePedalPressed;
   BrakePressureList = coRef.BrakePressureList;
   CloseLoopControlStatus = coRef.CloseLoopControlStatus;
   HandBrakeStatus = coRef.HandBrakeStatus;
   EMFBrake = coRef.EMFBrake;
   RetarderBrake = coRef.RetarderBrake;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgBrakeStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < BrakePressureList.size(); ++u32Idx)
         BrakePressureList[u32Idx].vDestroy();
   BrakePressureList.clear();
   }
}

cmb_vehiclesensorfi_tclMsgBrakeStatus::cmb_vehiclesensorfi_tclMsgBrakeStatus()
:Timestamp(0)
,BrakePedalPressed()

,CloseLoopControlStatus()
,HandBrakeStatus()
,EMFBrake()
,RetarderBrake()
 {}

tS32 cmb_vehiclesensorfi_tclMsgBrakeStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKESTATUS;
}


cmb_vehiclesensorfi_tclMsgBrakeStatus::~cmb_vehiclesensorfi_tclMsgBrakeStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgBrakeStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (10 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+15+ static_cast<tU32>(BrakePressureList.size()*6);
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgBrakeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> BrakePedalPressed);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BrakePressureList.size(); ++u32Idx)
      {
         BrakePressureList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      BrakePressureList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> BrakePressureList[u32Idx]);
      }
   }
   (tVoid) (oIn >> CloseLoopControlStatus);
   (tVoid) (oIn >> HandBrakeStatus);
   (tVoid) (oIn >> EMFBrake);
   if (10 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> RetarderBrake);
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgBrakeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << BrakePedalPressed);
   (tVoid) (oOut << (tU32)BrakePressureList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < BrakePressureList.size(); ++u32Idx)
         (tVoid) (oOut << BrakePressureList[u32Idx]);
   }
   (tVoid) (oOut << CloseLoopControlStatus);
   (tVoid) (oOut << HandBrakeStatus);
   (tVoid) (oOut << EMFBrake);
   if (10 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << RetarderBrake);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgBrakeStatus::operator==(const cmb_vehiclesensorfi_tclMsgBrakeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (BrakePedalPressed == roRef.BrakePedalPressed);
      bResult = bResult && (BrakePressureList.size() == roRef.BrakePressureList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BrakePressureList.size()); ++u32Idx)
            bResult = bResult && (BrakePressureList[u32Idx] == roRef.BrakePressureList[u32Idx]);
      }
   bResult = bResult && (CloseLoopControlStatus == roRef.CloseLoopControlStatus);
   bResult = bResult && (HandBrakeStatus == roRef.HandBrakeStatus);
   bResult = bResult && (EMFBrake == roRef.EMFBrake);
   bResult = bResult && (RetarderBrake == roRef.RetarderBrake);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgGearBoxUpReg::cmb_vehiclesensorfi_tclMsgGearBoxUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgGearBoxUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXUPREG;
}


cmb_vehiclesensorfi_tclMsgGearBoxUpReg::~cmb_vehiclesensorfi_tclMsgGearBoxUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgGearBoxRelUpReg::cmb_vehiclesensorfi_tclMsgGearBoxRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgGearBoxRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXRELUPREG;
}


cmb_vehiclesensorfi_tclMsgGearBoxRelUpReg::~cmb_vehiclesensorfi_tclMsgGearBoxRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgGearBoxGet::cmb_vehiclesensorfi_tclMsgGearBoxGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgGearBoxGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXGET;
}


cmb_vehiclesensorfi_tclMsgGearBoxGet::~cmb_vehiclesensorfi_tclMsgGearBoxGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgGearBoxStatus::cmb_vehiclesensorfi_tclMsgGearBoxStatus(const cmb_vehiclesensorfi_tclMsgGearBoxStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   GearPosition = coRef.GearPosition;
   GearLeverPosition = coRef.GearLeverPosition;
   GearBoxState = coRef.GearBoxState;
   TorqueConverterLockupClutch = coRef.TorqueConverterLockupClutch;
   GearboxSportSwitch = coRef.GearboxSportSwitch;
   SwitchClutch = coRef.SwitchClutch;
}
cmb_vehiclesensorfi_tclMsgGearBoxStatus& cmb_vehiclesensorfi_tclMsgGearBoxStatus::operator=(const cmb_vehiclesensorfi_tclMsgGearBoxStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   GearPosition = coRef.GearPosition;
   GearLeverPosition = coRef.GearLeverPosition;
   GearBoxState = coRef.GearBoxState;
   TorqueConverterLockupClutch = coRef.TorqueConverterLockupClutch;
   GearboxSportSwitch = coRef.GearboxSportSwitch;
   SwitchClutch = coRef.SwitchClutch;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgGearBoxStatus::cmb_vehiclesensorfi_tclMsgGearBoxStatus()
:Timestamp(0)
,GearPosition()
,GearLeverPosition()
,GearBoxState()
,TorqueConverterLockupClutch()
,GearboxSportSwitch()
,SwitchClutch()
 {}

tS32 cmb_vehiclesensorfi_tclMsgGearBoxStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXSTATUS;
}


cmb_vehiclesensorfi_tclMsgGearBoxStatus::~cmb_vehiclesensorfi_tclMsgGearBoxStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgGearBoxStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgGearBoxStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> GearPosition);
   (tVoid) (oIn >> GearLeverPosition);
   (tVoid) (oIn >> GearBoxState);
   (tVoid) (oIn >> TorqueConverterLockupClutch);
   (tVoid) (oIn >> GearboxSportSwitch);
   (tVoid) (oIn >> SwitchClutch);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgGearBoxStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << GearPosition);
   (tVoid) (oOut << GearLeverPosition);
   (tVoid) (oOut << GearBoxState);
   (tVoid) (oOut << TorqueConverterLockupClutch);
   (tVoid) (oOut << GearboxSportSwitch);
   (tVoid) (oOut << SwitchClutch);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgGearBoxStatus::operator==(const cmb_vehiclesensorfi_tclMsgGearBoxStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (GearPosition == roRef.GearPosition);
   bResult = bResult && (GearLeverPosition == roRef.GearLeverPosition);
   bResult = bResult && (GearBoxState == roRef.GearBoxState);
   bResult = bResult && (TorqueConverterLockupClutch == roRef.TorqueConverterLockupClutch);
   bResult = bResult && (GearboxSportSwitch == roRef.GearboxSportSwitch);
   bResult = bResult && (SwitchClutch == roRef.SwitchClutch);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgIgnitionUpReg::cmb_vehiclesensorfi_tclMsgIgnitionUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgIgnitionUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONUPREG;
}


cmb_vehiclesensorfi_tclMsgIgnitionUpReg::~cmb_vehiclesensorfi_tclMsgIgnitionUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgIgnitionRelUpReg::cmb_vehiclesensorfi_tclMsgIgnitionRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgIgnitionRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONRELUPREG;
}


cmb_vehiclesensorfi_tclMsgIgnitionRelUpReg::~cmb_vehiclesensorfi_tclMsgIgnitionRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgIgnitionGet::cmb_vehiclesensorfi_tclMsgIgnitionGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgIgnitionGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONGET;
}


cmb_vehiclesensorfi_tclMsgIgnitionGet::~cmb_vehiclesensorfi_tclMsgIgnitionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgIgnitionStatus::cmb_vehiclesensorfi_tclMsgIgnitionStatus(const cmb_vehiclesensorfi_tclMsgIgnitionStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   Ignition = coRef.Ignition;
}
cmb_vehiclesensorfi_tclMsgIgnitionStatus& cmb_vehiclesensorfi_tclMsgIgnitionStatus::operator=(const cmb_vehiclesensorfi_tclMsgIgnitionStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   Ignition = coRef.Ignition;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgIgnitionStatus::cmb_vehiclesensorfi_tclMsgIgnitionStatus()
:Timestamp(0)
,Ignition()
 {}

tS32 cmb_vehiclesensorfi_tclMsgIgnitionStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONSTATUS;
}


cmb_vehiclesensorfi_tclMsgIgnitionStatus::~cmb_vehiclesensorfi_tclMsgIgnitionStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgIgnitionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgIgnitionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> Ignition);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgIgnitionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << Ignition);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgIgnitionStatus::operator==(const cmb_vehiclesensorfi_tclMsgIgnitionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (Ignition == roRef.Ignition);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgSteeringWheelAngleUpReg::cmb_vehiclesensorfi_tclMsgSteeringWheelAngleUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSteeringWheelAngleUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLEUPREG;
}


cmb_vehiclesensorfi_tclMsgSteeringWheelAngleUpReg::~cmb_vehiclesensorfi_tclMsgSteeringWheelAngleUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgSteeringWheelAngleRelUpReg::cmb_vehiclesensorfi_tclMsgSteeringWheelAngleRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSteeringWheelAngleRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLERELUPREG;
}


cmb_vehiclesensorfi_tclMsgSteeringWheelAngleRelUpReg::~cmb_vehiclesensorfi_tclMsgSteeringWheelAngleRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgSteeringWheelAngleGet::cmb_vehiclesensorfi_tclMsgSteeringWheelAngleGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSteeringWheelAngleGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLEGET;
}


cmb_vehiclesensorfi_tclMsgSteeringWheelAngleGet::~cmb_vehiclesensorfi_tclMsgSteeringWheelAngleGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus::cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus(const cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   WheelAngle = coRef.WheelAngle;
   WheelRate = coRef.WheelRate;
   WheelAngleSensorOk = coRef.WheelAngleSensorOk;
   WheelRateSensorOk = coRef.WheelRateSensorOk;
}
cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus& cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus::operator=(const cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   WheelAngle = coRef.WheelAngle;
   WheelRate = coRef.WheelRate;
   WheelAngleSensorOk = coRef.WheelAngleSensorOk;
   WheelRateSensorOk = coRef.WheelRateSensorOk;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus::cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus()
:Timestamp(0)
,WheelAngle(0)
,WheelRate(0)
,WheelAngleSensorOk()
,WheelRateSensorOk()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLESTATUS;
}


cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus::~cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> WheelAngle);
   (tVoid) (oIn >> WheelRate);
   (tVoid) (oIn >> WheelAngleSensorOk);
   (tVoid) (oIn >> WheelRateSensorOk);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << WheelAngle);
   (tVoid) (oOut << WheelRate);
   (tVoid) (oOut << WheelAngleSensorOk);
   (tVoid) (oOut << WheelRateSensorOk);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus::operator==(const cmb_vehiclesensorfi_tclMsgSteeringWheelAngleStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (WheelAngle == roRef.WheelAngle);
   bResult = bResult && (WheelRate == roRef.WheelRate);
   bResult = bResult && (WheelAngleSensorOk == roRef.WheelAngleSensorOk);
   bResult = bResult && (WheelRateSensorOk == roRef.WheelRateSensorOk);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgCruiseControlUpReg::cmb_vehiclesensorfi_tclMsgCruiseControlUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgCruiseControlUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLUPREG;
}


cmb_vehiclesensorfi_tclMsgCruiseControlUpReg::~cmb_vehiclesensorfi_tclMsgCruiseControlUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgCruiseControlRelUpReg::cmb_vehiclesensorfi_tclMsgCruiseControlRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgCruiseControlRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLRELUPREG;
}


cmb_vehiclesensorfi_tclMsgCruiseControlRelUpReg::~cmb_vehiclesensorfi_tclMsgCruiseControlRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgCruiseControlGet::cmb_vehiclesensorfi_tclMsgCruiseControlGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgCruiseControlGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLGET;
}


cmb_vehiclesensorfi_tclMsgCruiseControlGet::~cmb_vehiclesensorfi_tclMsgCruiseControlGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgCruiseControlStatus::cmb_vehiclesensorfi_tclMsgCruiseControlStatus(const cmb_vehiclesensorfi_tclMsgCruiseControlStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   Type = coRef.Type;
   State = coRef.State;
   SetSpeed = coRef.SetSpeed;
   CoastingActive = coRef.CoastingActive;
   CoastingSetSpeed = coRef.CoastingSetSpeed;
   LockedLeadCar = coRef.LockedLeadCar;
   DistanceToLockedLeadCarSufficient = coRef.DistanceToLockedLeadCarSufficient;
   DistanceToLockedLeadCar = coRef.DistanceToLockedLeadCar;
   LockedLeadCarSpeed = coRef.LockedLeadCarSpeed;
   DesiredTorqueACC = coRef.DesiredTorqueACC;
   DesiredTorqueApprovedACC = coRef.DesiredTorqueApprovedACC;
   DesiredDecelerationACC = coRef.DesiredDecelerationACC;
   DesiredDecelerationApprovedACC = coRef.DesiredDecelerationApprovedACC;
}
cmb_vehiclesensorfi_tclMsgCruiseControlStatus& cmb_vehiclesensorfi_tclMsgCruiseControlStatus::operator=(const cmb_vehiclesensorfi_tclMsgCruiseControlStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   Type = coRef.Type;
   State = coRef.State;
   SetSpeed = coRef.SetSpeed;
   CoastingActive = coRef.CoastingActive;
   CoastingSetSpeed = coRef.CoastingSetSpeed;
   LockedLeadCar = coRef.LockedLeadCar;
   DistanceToLockedLeadCarSufficient = coRef.DistanceToLockedLeadCarSufficient;
   DistanceToLockedLeadCar = coRef.DistanceToLockedLeadCar;
   LockedLeadCarSpeed = coRef.LockedLeadCarSpeed;
   DesiredTorqueACC = coRef.DesiredTorqueACC;
   DesiredTorqueApprovedACC = coRef.DesiredTorqueApprovedACC;
   DesiredDecelerationACC = coRef.DesiredDecelerationACC;
   DesiredDecelerationApprovedACC = coRef.DesiredDecelerationApprovedACC;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgCruiseControlStatus::cmb_vehiclesensorfi_tclMsgCruiseControlStatus()
:Timestamp(0)
,Type()
,State()
,SetSpeed()
,CoastingActive()
,CoastingSetSpeed()
,LockedLeadCar()
,DistanceToLockedLeadCarSufficient()
,DistanceToLockedLeadCar()
,LockedLeadCarSpeed()
,DesiredTorqueACC()
,DesiredTorqueApprovedACC(0)
,DesiredDecelerationACC()
,DesiredDecelerationApprovedACC(0)
 {}

tS32 cmb_vehiclesensorfi_tclMsgCruiseControlStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLSTATUS;
}


cmb_vehiclesensorfi_tclMsgCruiseControlStatus::~cmb_vehiclesensorfi_tclMsgCruiseControlStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgCruiseControlStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+15;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgCruiseControlStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> Type);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> SetSpeed);
   (tVoid) (oIn >> CoastingActive);
   (tVoid) (oIn >> CoastingSetSpeed);
   (tVoid) (oIn >> LockedLeadCar);
   (tVoid) (oIn >> DistanceToLockedLeadCarSufficient);
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> DistanceToLockedLeadCar);
   }
   (tVoid) (oIn >> LockedLeadCarSpeed);
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> DesiredTorqueACC);
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> DesiredTorqueApprovedACC);
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> DesiredDecelerationACC);
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> DesiredDecelerationApprovedACC);
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgCruiseControlStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << Type);
   (tVoid) (oOut << State);
   (tVoid) (oOut << SetSpeed);
   (tVoid) (oOut << CoastingActive);
   (tVoid) (oOut << CoastingSetSpeed);
   (tVoid) (oOut << LockedLeadCar);
   (tVoid) (oOut << DistanceToLockedLeadCarSufficient);
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << DistanceToLockedLeadCar);
   }
   (tVoid) (oOut << LockedLeadCarSpeed);
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << DesiredTorqueACC);
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << DesiredTorqueApprovedACC);
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << DesiredDecelerationACC);
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << DesiredDecelerationApprovedACC);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgCruiseControlStatus::operator==(const cmb_vehiclesensorfi_tclMsgCruiseControlStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (Type == roRef.Type);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (SetSpeed == roRef.SetSpeed);
   bResult = bResult && (CoastingActive == roRef.CoastingActive);
   bResult = bResult && (CoastingSetSpeed == roRef.CoastingSetSpeed);
   bResult = bResult && (LockedLeadCar == roRef.LockedLeadCar);
   bResult = bResult && (DistanceToLockedLeadCarSufficient == roRef.DistanceToLockedLeadCarSufficient);
   bResult = bResult && (DistanceToLockedLeadCar == roRef.DistanceToLockedLeadCar);
   bResult = bResult && (LockedLeadCarSpeed == roRef.LockedLeadCarSpeed);
   bResult = bResult && (DesiredTorqueACC == roRef.DesiredTorqueACC);
   bResult = bResult && (DesiredTorqueApprovedACC == roRef.DesiredTorqueApprovedACC);
   bResult = bResult && (DesiredDecelerationACC == roRef.DesiredDecelerationACC);
   bResult = bResult && (DesiredDecelerationApprovedACC == roRef.DesiredDecelerationApprovedACC);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgHybridOperationUpReg::cmb_vehiclesensorfi_tclMsgHybridOperationUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgHybridOperationUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONUPREG;
}


cmb_vehiclesensorfi_tclMsgHybridOperationUpReg::~cmb_vehiclesensorfi_tclMsgHybridOperationUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgHybridOperationRelUpReg::cmb_vehiclesensorfi_tclMsgHybridOperationRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgHybridOperationRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONRELUPREG;
}


cmb_vehiclesensorfi_tclMsgHybridOperationRelUpReg::~cmb_vehiclesensorfi_tclMsgHybridOperationRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgHybridOperationGet::cmb_vehiclesensorfi_tclMsgHybridOperationGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgHybridOperationGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONGET;
}


cmb_vehiclesensorfi_tclMsgHybridOperationGet::~cmb_vehiclesensorfi_tclMsgHybridOperationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgHybridOperationStatus::cmb_vehiclesensorfi_tclMsgHybridOperationStatus(const cmb_vehiclesensorfi_tclMsgHybridOperationStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   SOCStatus = coRef.SOCStatus;
   SOCSet = coRef.SOCSet;
   FuelConsumptionHybrid = coRef.FuelConsumptionHybrid;
   FuelSaving = coRef.FuelSaving;
   CostFactorCharge = coRef.CostFactorCharge;
   CostFactorDischarge = coRef.CostFactorDischarge;
   StatusK0 = coRef.StatusK0;
}
cmb_vehiclesensorfi_tclMsgHybridOperationStatus& cmb_vehiclesensorfi_tclMsgHybridOperationStatus::operator=(const cmb_vehiclesensorfi_tclMsgHybridOperationStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   SOCStatus = coRef.SOCStatus;
   SOCSet = coRef.SOCSet;
   FuelConsumptionHybrid = coRef.FuelConsumptionHybrid;
   FuelSaving = coRef.FuelSaving;
   CostFactorCharge = coRef.CostFactorCharge;
   CostFactorDischarge = coRef.CostFactorDischarge;
   StatusK0 = coRef.StatusK0;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgHybridOperationStatus::cmb_vehiclesensorfi_tclMsgHybridOperationStatus()
:Timestamp(0)
,SOCStatus()
,SOCSet()
,FuelConsumptionHybrid()
,FuelSaving()
,CostFactorCharge(0)
,CostFactorDischarge(0)
,StatusK0()
 {}

tS32 cmb_vehiclesensorfi_tclMsgHybridOperationStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONSTATUS;
}


cmb_vehiclesensorfi_tclMsgHybridOperationStatus::~cmb_vehiclesensorfi_tclMsgHybridOperationStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgHybridOperationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 8)
   {
      u32DynamicSize += 2;
   }
   if (u16MajorVersion <= 8)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+10;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgHybridOperationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   if (oIn.u16GetMajorVersion() <= 8)
   {
      (tVoid) (oIn >> SOCStatus);
   }
   if (oIn.u16GetMajorVersion() <= 8)
   {
      (tVoid) (oIn >> SOCSet);
   }
   (tVoid) (oIn >> FuelConsumptionHybrid);
   (tVoid) (oIn >> FuelSaving);
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> CostFactorCharge);
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> CostFactorDischarge);
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> StatusK0);
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgHybridOperationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   if (oOut.u16GetMajorVersion() <= 8)
   {
      (tVoid) (oOut << SOCStatus);
   }
   if (oOut.u16GetMajorVersion() <= 8)
   {
      (tVoid) (oOut << SOCSet);
   }
   (tVoid) (oOut << FuelConsumptionHybrid);
   (tVoid) (oOut << FuelSaving);
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << CostFactorCharge);
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << CostFactorDischarge);
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << StatusK0);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgHybridOperationStatus::operator==(const cmb_vehiclesensorfi_tclMsgHybridOperationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (SOCStatus == roRef.SOCStatus);
   bResult = bResult && (SOCSet == roRef.SOCSet);
   bResult = bResult && (FuelConsumptionHybrid == roRef.FuelConsumptionHybrid);
   bResult = bResult && (FuelSaving == roRef.FuelSaving);
   bResult = bResult && (CostFactorCharge == roRef.CostFactorCharge);
   bResult = bResult && (CostFactorDischarge == roRef.CostFactorDischarge);
   bResult = bResult && (StatusK0 == roRef.StatusK0);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgVehicleDynamicUpReg::cmb_vehiclesensorfi_tclMsgVehicleDynamicUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgVehicleDynamicUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICUPREG;
}


cmb_vehiclesensorfi_tclMsgVehicleDynamicUpReg::~cmb_vehiclesensorfi_tclMsgVehicleDynamicUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgVehicleDynamicRelUpReg::cmb_vehiclesensorfi_tclMsgVehicleDynamicRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgVehicleDynamicRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICRELUPREG;
}


cmb_vehiclesensorfi_tclMsgVehicleDynamicRelUpReg::~cmb_vehiclesensorfi_tclMsgVehicleDynamicRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgVehicleDynamicGet::cmb_vehiclesensorfi_tclMsgVehicleDynamicGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgVehicleDynamicGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICGET;
}


cmb_vehiclesensorfi_tclMsgVehicleDynamicGet::~cmb_vehiclesensorfi_tclMsgVehicleDynamicGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus::cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus(const cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   OldestTimestamp = coRef.OldestTimestamp;
   Yawrate = coRef.Yawrate;
   LongitudinalAcceleration = coRef.LongitudinalAcceleration;
   LateralAcceleration = coRef.LateralAcceleration;
   Slope = coRef.Slope;
   SlopeConfidence = coRef.SlopeConfidence;
   DrivenCurvature = coRef.DrivenCurvature;
   DrivenCurvatureConfidence = coRef.DrivenCurvatureConfidence;
}
cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus& cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus::operator=(const cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   OldestTimestamp = coRef.OldestTimestamp;
   Yawrate = coRef.Yawrate;
   LongitudinalAcceleration = coRef.LongitudinalAcceleration;
   LateralAcceleration = coRef.LateralAcceleration;
   Slope = coRef.Slope;
   SlopeConfidence = coRef.SlopeConfidence;
   DrivenCurvature = coRef.DrivenCurvature;
   DrivenCurvatureConfidence = coRef.DrivenCurvatureConfidence;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus::cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus()
:Timestamp(0)
,OldestTimestamp(0)
,Yawrate()
,LongitudinalAcceleration()
,LateralAcceleration()
,Slope()
,SlopeConfidence()
,DrivenCurvature()
,DrivenCurvatureConfidence()
 {}

tS32 cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICSTATUS;
}


cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus::~cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (10 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (10 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (10 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+14;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> OldestTimestamp);
   (tVoid) (oIn >> Yawrate);
   (tVoid) (oIn >> LongitudinalAcceleration);
   (tVoid) (oIn >> LateralAcceleration);
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> Slope);
   }
   if (10 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> SlopeConfidence);
   }
   if (10 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> DrivenCurvature);
   }
   if (10 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> DrivenCurvatureConfidence);
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << OldestTimestamp);
   (tVoid) (oOut << Yawrate);
   (tVoid) (oOut << LongitudinalAcceleration);
   (tVoid) (oOut << LateralAcceleration);
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << Slope);
   }
   if (10 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << SlopeConfidence);
   }
   if (10 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << DrivenCurvature);
   }
   if (10 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << DrivenCurvatureConfidence);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus::operator==(const cmb_vehiclesensorfi_tclMsgVehicleDynamicStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (OldestTimestamp == roRef.OldestTimestamp);
   bResult = bResult && (Yawrate == roRef.Yawrate);
   bResult = bResult && (LongitudinalAcceleration == roRef.LongitudinalAcceleration);
   bResult = bResult && (LateralAcceleration == roRef.LateralAcceleration);
   bResult = bResult && (Slope == roRef.Slope);
   bResult = bResult && (SlopeConfidence == roRef.SlopeConfidence);
   bResult = bResult && (DrivenCurvature == roRef.DrivenCurvature);
   bResult = bResult && (DrivenCurvatureConfidence == roRef.DrivenCurvatureConfidence);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgStaticVehicleParametersUpReg::cmb_vehiclesensorfi_tclMsgStaticVehicleParametersUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgStaticVehicleParametersUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSUPREG;
}


cmb_vehiclesensorfi_tclMsgStaticVehicleParametersUpReg::~cmb_vehiclesensorfi_tclMsgStaticVehicleParametersUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgStaticVehicleParametersRelUpReg::cmb_vehiclesensorfi_tclMsgStaticVehicleParametersRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgStaticVehicleParametersRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSRELUPREG;
}


cmb_vehiclesensorfi_tclMsgStaticVehicleParametersRelUpReg::~cmb_vehiclesensorfi_tclMsgStaticVehicleParametersRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgStaticVehicleParametersGet::cmb_vehiclesensorfi_tclMsgStaticVehicleParametersGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgStaticVehicleParametersGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSGET;
}


cmb_vehiclesensorfi_tclMsgStaticVehicleParametersGet::~cmb_vehiclesensorfi_tclMsgStaticVehicleParametersGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus::cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus(const cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   ChassisNumber = coRef.ChassisNumber;
   LowerCriticalVelocity = coRef.LowerCriticalVelocity;
   Drive = coRef.Drive;
   NumberOfSeats = coRef.NumberOfSeats;
   NumberOfDoors = coRef.NumberOfDoors;
   VehicleWeight = coRef.VehicleWeight;
}
cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus& cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus::operator=(const cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   ChassisNumber = coRef.ChassisNumber;
   LowerCriticalVelocity = coRef.LowerCriticalVelocity;
   Drive = coRef.Drive;
   NumberOfSeats = coRef.NumberOfSeats;
   NumberOfDoors = coRef.NumberOfDoors;
   VehicleWeight = coRef.VehicleWeight;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus::vDestroy()
{
   ChassisNumber.vDestroy();
}

cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus::cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus()
:Timestamp(0)
,ChassisNumber()
,LowerCriticalVelocity()
,Drive()
,NumberOfSeats(0)
,NumberOfDoors(0)
,VehicleWeight()
 {}

tS32 cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSSTATUS;
}


cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus::~cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (10 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+9+ChassisNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> ChassisNumber);
   (tVoid) (oIn >> LowerCriticalVelocity);
   (tVoid) (oIn >> Drive);
   (tVoid) (oIn >> NumberOfSeats);
   (tVoid) (oIn >> NumberOfDoors);
   if (10 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> VehicleWeight);
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << ChassisNumber);
   (tVoid) (oOut << LowerCriticalVelocity);
   (tVoid) (oOut << Drive);
   (tVoid) (oOut << NumberOfSeats);
   (tVoid) (oOut << NumberOfDoors);
   if (10 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << VehicleWeight);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus::operator==(const cmb_vehiclesensorfi_tclMsgStaticVehicleParametersStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (ChassisNumber == roRef.ChassisNumber);
   bResult = bResult && (LowerCriticalVelocity == roRef.LowerCriticalVelocity);
   bResult = bResult && (Drive == roRef.Drive);
   bResult = bResult && (NumberOfSeats == roRef.NumberOfSeats);
   bResult = bResult && (NumberOfDoors == roRef.NumberOfDoors);
   bResult = bResult && (VehicleWeight == roRef.VehicleWeight);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgKeyStatusUpReg::cmb_vehiclesensorfi_tclMsgKeyStatusUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgKeyStatusUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSUPREG;
}


cmb_vehiclesensorfi_tclMsgKeyStatusUpReg::~cmb_vehiclesensorfi_tclMsgKeyStatusUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgKeyStatusRelUpReg::cmb_vehiclesensorfi_tclMsgKeyStatusRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgKeyStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSRELUPREG;
}


cmb_vehiclesensorfi_tclMsgKeyStatusRelUpReg::~cmb_vehiclesensorfi_tclMsgKeyStatusRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgKeyStatusGet::cmb_vehiclesensorfi_tclMsgKeyStatusGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgKeyStatusGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSGET;
}


cmb_vehiclesensorfi_tclMsgKeyStatusGet::~cmb_vehiclesensorfi_tclMsgKeyStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgKeyStatusStatus::cmb_vehiclesensorfi_tclMsgKeyStatusStatus(const cmb_vehiclesensorfi_tclMsgKeyStatusStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   KeyValid = coRef.KeyValid;
   KeyNumber = coRef.KeyNumber;
   KeyTyp = coRef.KeyTyp;
   KeyLocation = coRef.KeyLocation;
}
cmb_vehiclesensorfi_tclMsgKeyStatusStatus& cmb_vehiclesensorfi_tclMsgKeyStatusStatus::operator=(const cmb_vehiclesensorfi_tclMsgKeyStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   KeyValid = coRef.KeyValid;
   KeyNumber = coRef.KeyNumber;
   KeyTyp = coRef.KeyTyp;
   KeyLocation = coRef.KeyLocation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgKeyStatusStatus::cmb_vehiclesensorfi_tclMsgKeyStatusStatus()
:Timestamp(0)
,KeyValid()
,KeyNumber(0)
,KeyTyp()
,KeyLocation()
 {}

tS32 cmb_vehiclesensorfi_tclMsgKeyStatusStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSSTATUS;
}


cmb_vehiclesensorfi_tclMsgKeyStatusStatus::~cmb_vehiclesensorfi_tclMsgKeyStatusStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgKeyStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgKeyStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> KeyValid);
   (tVoid) (oIn >> KeyNumber);
   (tVoid) (oIn >> KeyTyp);
   (tVoid) (oIn >> KeyLocation);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgKeyStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << KeyValid);
   (tVoid) (oOut << KeyNumber);
   (tVoid) (oOut << KeyTyp);
   (tVoid) (oOut << KeyLocation);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgKeyStatusStatus::operator==(const cmb_vehiclesensorfi_tclMsgKeyStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (KeyValid == roRef.KeyValid);
   bResult = bResult && (KeyNumber == roRef.KeyNumber);
   bResult = bResult && (KeyTyp == roRef.KeyTyp);
   bResult = bResult && (KeyLocation == roRef.KeyLocation);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgClimateControlUpReg::cmb_vehiclesensorfi_tclMsgClimateControlUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgClimateControlUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLUPREG;
}


cmb_vehiclesensorfi_tclMsgClimateControlUpReg::~cmb_vehiclesensorfi_tclMsgClimateControlUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgClimateControlRelUpReg::cmb_vehiclesensorfi_tclMsgClimateControlRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgClimateControlRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLRELUPREG;
}


cmb_vehiclesensorfi_tclMsgClimateControlRelUpReg::~cmb_vehiclesensorfi_tclMsgClimateControlRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgClimateControlGet::cmb_vehiclesensorfi_tclMsgClimateControlGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgClimateControlGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLGET;
}


cmb_vehiclesensorfi_tclMsgClimateControlGet::~cmb_vehiclesensorfi_tclMsgClimateControlGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgClimateControlStatus::cmb_vehiclesensorfi_tclMsgClimateControlStatus(const cmb_vehiclesensorfi_tclMsgClimateControlStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   ACCompressorStatus = coRef.ACCompressorStatus;
   ACStatus = coRef.ACStatus;
   DefrosterStatus = coRef.DefrosterStatus;
   CompressorLoad = coRef.CompressorLoad;
}
cmb_vehiclesensorfi_tclMsgClimateControlStatus& cmb_vehiclesensorfi_tclMsgClimateControlStatus::operator=(const cmb_vehiclesensorfi_tclMsgClimateControlStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   ACCompressorStatus = coRef.ACCompressorStatus;
   ACStatus = coRef.ACStatus;
   DefrosterStatus = coRef.DefrosterStatus;
   CompressorLoad = coRef.CompressorLoad;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgClimateControlStatus::cmb_vehiclesensorfi_tclMsgClimateControlStatus()
:Timestamp(0)
,ACCompressorStatus()
,ACStatus()
,DefrosterStatus()
,CompressorLoad()
 {}

tS32 cmb_vehiclesensorfi_tclMsgClimateControlStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLSTATUS;
}


cmb_vehiclesensorfi_tclMsgClimateControlStatus::~cmb_vehiclesensorfi_tclMsgClimateControlStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgClimateControlStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+7;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgClimateControlStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> ACCompressorStatus);
   (tVoid) (oIn >> ACStatus);
   (tVoid) (oIn >> DefrosterStatus);
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> CompressorLoad);
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgClimateControlStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << ACCompressorStatus);
   (tVoid) (oOut << ACStatus);
   (tVoid) (oOut << DefrosterStatus);
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << CompressorLoad);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgClimateControlStatus::operator==(const cmb_vehiclesensorfi_tclMsgClimateControlStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (ACCompressorStatus == roRef.ACCompressorStatus);
   bResult = bResult && (ACStatus == roRef.ACStatus);
   bResult = bResult && (DefrosterStatus == roRef.DefrosterStatus);
   bResult = bResult && (CompressorLoad == roRef.CompressorLoad);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgWindowsUpReg::cmb_vehiclesensorfi_tclMsgWindowsUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgWindowsUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSUPREG;
}


cmb_vehiclesensorfi_tclMsgWindowsUpReg::~cmb_vehiclesensorfi_tclMsgWindowsUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgWindowsRelUpReg::cmb_vehiclesensorfi_tclMsgWindowsRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgWindowsRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSRELUPREG;
}


cmb_vehiclesensorfi_tclMsgWindowsRelUpReg::~cmb_vehiclesensorfi_tclMsgWindowsRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgWindowsGet::cmb_vehiclesensorfi_tclMsgWindowsGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgWindowsGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSGET;
}


cmb_vehiclesensorfi_tclMsgWindowsGet::~cmb_vehiclesensorfi_tclMsgWindowsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgWindowsStatus::cmb_vehiclesensorfi_tclMsgWindowsStatus(const cmb_vehiclesensorfi_tclMsgWindowsStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   WindowPositionList = coRef.WindowPositionList;
}
cmb_vehiclesensorfi_tclMsgWindowsStatus& cmb_vehiclesensorfi_tclMsgWindowsStatus::operator=(const cmb_vehiclesensorfi_tclMsgWindowsStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   WindowPositionList = coRef.WindowPositionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgWindowsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < WindowPositionList.size(); ++u32Idx)
         WindowPositionList[u32Idx].vDestroy();
   WindowPositionList.clear();
   }
}

cmb_vehiclesensorfi_tclMsgWindowsStatus::cmb_vehiclesensorfi_tclMsgWindowsStatus()
:Timestamp(0)

 {}

tS32 cmb_vehiclesensorfi_tclMsgWindowsStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSSTATUS;
}


cmb_vehiclesensorfi_tclMsgWindowsStatus::~cmb_vehiclesensorfi_tclMsgWindowsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgWindowsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(WindowPositionList.size()*4);
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgWindowsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < WindowPositionList.size(); ++u32Idx)
      {
         WindowPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      WindowPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> WindowPositionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgWindowsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << (tU32)WindowPositionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < WindowPositionList.size(); ++u32Idx)
         (tVoid) (oOut << WindowPositionList[u32Idx]);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgWindowsStatus::operator==(const cmb_vehiclesensorfi_tclMsgWindowsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
      bResult = bResult && (WindowPositionList.size() == roRef.WindowPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WindowPositionList.size()); ++u32Idx)
            bResult = bResult && (WindowPositionList[u32Idx] == roRef.WindowPositionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgEnvironmentUpReg::cmb_vehiclesensorfi_tclMsgEnvironmentUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgEnvironmentUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTUPREG;
}


cmb_vehiclesensorfi_tclMsgEnvironmentUpReg::~cmb_vehiclesensorfi_tclMsgEnvironmentUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgEnvironmentRelUpReg::cmb_vehiclesensorfi_tclMsgEnvironmentRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgEnvironmentRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTRELUPREG;
}


cmb_vehiclesensorfi_tclMsgEnvironmentRelUpReg::~cmb_vehiclesensorfi_tclMsgEnvironmentRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgEnvironmentGet::cmb_vehiclesensorfi_tclMsgEnvironmentGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgEnvironmentGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTGET;
}


cmb_vehiclesensorfi_tclMsgEnvironmentGet::~cmb_vehiclesensorfi_tclMsgEnvironmentGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgEnvironmentStatus::cmb_vehiclesensorfi_tclMsgEnvironmentStatus(const cmb_vehiclesensorfi_tclMsgEnvironmentStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   OutsideTemperature = coRef.OutsideTemperature;
   AirPressure = coRef.AirPressure;
   AmbienceBrightness = coRef.AmbienceBrightness;
}
cmb_vehiclesensorfi_tclMsgEnvironmentStatus& cmb_vehiclesensorfi_tclMsgEnvironmentStatus::operator=(const cmb_vehiclesensorfi_tclMsgEnvironmentStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   OutsideTemperature = coRef.OutsideTemperature;
   AirPressure = coRef.AirPressure;
   AmbienceBrightness = coRef.AmbienceBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgEnvironmentStatus::cmb_vehiclesensorfi_tclMsgEnvironmentStatus()
:Timestamp(0)
,OutsideTemperature()
,AirPressure()
,AmbienceBrightness()
 {}

tS32 cmb_vehiclesensorfi_tclMsgEnvironmentStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTSTATUS;
}


cmb_vehiclesensorfi_tclMsgEnvironmentStatus::~cmb_vehiclesensorfi_tclMsgEnvironmentStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgEnvironmentStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgEnvironmentStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> OutsideTemperature);
   (tVoid) (oIn >> AirPressure);
   (tVoid) (oIn >> AmbienceBrightness);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgEnvironmentStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << OutsideTemperature);
   (tVoid) (oOut << AirPressure);
   (tVoid) (oOut << AmbienceBrightness);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgEnvironmentStatus::operator==(const cmb_vehiclesensorfi_tclMsgEnvironmentStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (OutsideTemperature == roRef.OutsideTemperature);
   bResult = bResult && (AirPressure == roRef.AirPressure);
   bResult = bResult && (AmbienceBrightness == roRef.AmbienceBrightness);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgWheelsUpReg::cmb_vehiclesensorfi_tclMsgWheelsUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgWheelsUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSUPREG;
}


cmb_vehiclesensorfi_tclMsgWheelsUpReg::~cmb_vehiclesensorfi_tclMsgWheelsUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgWheelsRelUpReg::cmb_vehiclesensorfi_tclMsgWheelsRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgWheelsRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSRELUPREG;
}


cmb_vehiclesensorfi_tclMsgWheelsRelUpReg::~cmb_vehiclesensorfi_tclMsgWheelsRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgWheelsGet::cmb_vehiclesensorfi_tclMsgWheelsGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgWheelsGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSGET;
}


cmb_vehiclesensorfi_tclMsgWheelsGet::~cmb_vehiclesensorfi_tclMsgWheelsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgWheelsStatus::cmb_vehiclesensorfi_tclMsgWheelsStatus(const cmb_vehiclesensorfi_tclMsgWheelsStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   TirePressureList = coRef.TirePressureList;
}
cmb_vehiclesensorfi_tclMsgWheelsStatus& cmb_vehiclesensorfi_tclMsgWheelsStatus::operator=(const cmb_vehiclesensorfi_tclMsgWheelsStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   TirePressureList = coRef.TirePressureList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgWheelsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TirePressureList.size(); ++u32Idx)
         TirePressureList[u32Idx].vDestroy();
   TirePressureList.clear();
   }
}

cmb_vehiclesensorfi_tclMsgWheelsStatus::cmb_vehiclesensorfi_tclMsgWheelsStatus()
:Timestamp(0)

 {}

tS32 cmb_vehiclesensorfi_tclMsgWheelsStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSSTATUS;
}


cmb_vehiclesensorfi_tclMsgWheelsStatus::~cmb_vehiclesensorfi_tclMsgWheelsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgWheelsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(TirePressureList.size()*6);
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgWheelsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TirePressureList.size(); ++u32Idx)
      {
         TirePressureList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TirePressureList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TirePressureList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgWheelsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << (tU32)TirePressureList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TirePressureList.size(); ++u32Idx)
         (tVoid) (oOut << TirePressureList[u32Idx]);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgWheelsStatus::operator==(const cmb_vehiclesensorfi_tclMsgWheelsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
      bResult = bResult && (TirePressureList.size() == roRef.TirePressureList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TirePressureList.size()); ++u32Idx)
            bResult = bResult && (TirePressureList[u32Idx] == roRef.TirePressureList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgVehicleLoadUpReg::cmb_vehiclesensorfi_tclMsgVehicleLoadUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgVehicleLoadUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADUPREG;
}


cmb_vehiclesensorfi_tclMsgVehicleLoadUpReg::~cmb_vehiclesensorfi_tclMsgVehicleLoadUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgVehicleLoadRelUpReg::cmb_vehiclesensorfi_tclMsgVehicleLoadRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgVehicleLoadRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADRELUPREG;
}


cmb_vehiclesensorfi_tclMsgVehicleLoadRelUpReg::~cmb_vehiclesensorfi_tclMsgVehicleLoadRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgVehicleLoadGet::cmb_vehiclesensorfi_tclMsgVehicleLoadGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgVehicleLoadGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADGET;
}


cmb_vehiclesensorfi_tclMsgVehicleLoadGet::~cmb_vehiclesensorfi_tclMsgVehicleLoadGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgVehicleLoadStatus::cmb_vehiclesensorfi_tclMsgVehicleLoadStatus(const cmb_vehiclesensorfi_tclMsgVehicleLoadStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   VehicleTilt = coRef.VehicleTilt;
   TrailerAttached = coRef.TrailerAttached;
}
cmb_vehiclesensorfi_tclMsgVehicleLoadStatus& cmb_vehiclesensorfi_tclMsgVehicleLoadStatus::operator=(const cmb_vehiclesensorfi_tclMsgVehicleLoadStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   VehicleTilt = coRef.VehicleTilt;
   TrailerAttached = coRef.TrailerAttached;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgVehicleLoadStatus::cmb_vehiclesensorfi_tclMsgVehicleLoadStatus()
:Timestamp(0)
,VehicleTilt()
,TrailerAttached()
 {}

tS32 cmb_vehiclesensorfi_tclMsgVehicleLoadStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADSTATUS;
}


cmb_vehiclesensorfi_tclMsgVehicleLoadStatus::~cmb_vehiclesensorfi_tclMsgVehicleLoadStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgVehicleLoadStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgVehicleLoadStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> VehicleTilt);
   (tVoid) (oIn >> TrailerAttached);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgVehicleLoadStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << VehicleTilt);
   (tVoid) (oOut << TrailerAttached);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgVehicleLoadStatus::operator==(const cmb_vehiclesensorfi_tclMsgVehicleLoadStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (VehicleTilt == roRef.VehicleTilt);
   bResult = bResult && (TrailerAttached == roRef.TrailerAttached);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgEngineParameterUpReg::cmb_vehiclesensorfi_tclMsgEngineParameterUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgEngineParameterUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERUPREG;
}


cmb_vehiclesensorfi_tclMsgEngineParameterUpReg::~cmb_vehiclesensorfi_tclMsgEngineParameterUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgEngineParameterRelUpReg::cmb_vehiclesensorfi_tclMsgEngineParameterRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgEngineParameterRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERRELUPREG;
}


cmb_vehiclesensorfi_tclMsgEngineParameterRelUpReg::~cmb_vehiclesensorfi_tclMsgEngineParameterRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgEngineParameterGet::cmb_vehiclesensorfi_tclMsgEngineParameterGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgEngineParameterGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERGET;
}


cmb_vehiclesensorfi_tclMsgEngineParameterGet::~cmb_vehiclesensorfi_tclMsgEngineParameterGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgEngineParameterStatus::cmb_vehiclesensorfi_tclMsgEngineParameterStatus(const cmb_vehiclesensorfi_tclMsgEngineParameterStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   TemperatureEngine = coRef.TemperatureEngine;
   TemperatureEngineOil = coRef.TemperatureEngineOil;
   StatusEngineRunning = coRef.StatusEngineRunning;
   InjectionVolumeFuel = coRef.InjectionVolumeFuel;
   ReductionDownControlRPM = coRef.ReductionDownControlRPM;
   StatusRBMZyklus = coRef.StatusRBMZyklus;
   RPMIdlingTarget = coRef.RPMIdlingTarget;
}
cmb_vehiclesensorfi_tclMsgEngineParameterStatus& cmb_vehiclesensorfi_tclMsgEngineParameterStatus::operator=(const cmb_vehiclesensorfi_tclMsgEngineParameterStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   TemperatureEngine = coRef.TemperatureEngine;
   TemperatureEngineOil = coRef.TemperatureEngineOil;
   StatusEngineRunning = coRef.StatusEngineRunning;
   InjectionVolumeFuel = coRef.InjectionVolumeFuel;
   ReductionDownControlRPM = coRef.ReductionDownControlRPM;
   StatusRBMZyklus = coRef.StatusRBMZyklus;
   RPMIdlingTarget = coRef.RPMIdlingTarget;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgEngineParameterStatus::cmb_vehiclesensorfi_tclMsgEngineParameterStatus()
:Timestamp(0)
,TemperatureEngine()
,TemperatureEngineOil()
,StatusEngineRunning()
,InjectionVolumeFuel()
,ReductionDownControlRPM()
,StatusRBMZyklus()
,RPMIdlingTarget(0)
 {}

tS32 cmb_vehiclesensorfi_tclMsgEngineParameterStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERSTATUS;
}


cmb_vehiclesensorfi_tclMsgEngineParameterStatus::~cmb_vehiclesensorfi_tclMsgEngineParameterStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgEngineParameterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgEngineParameterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> TemperatureEngine);
   (tVoid) (oIn >> TemperatureEngineOil);
   (tVoid) (oIn >> StatusEngineRunning);
   (tVoid) (oIn >> InjectionVolumeFuel);
   (tVoid) (oIn >> ReductionDownControlRPM);
   (tVoid) (oIn >> StatusRBMZyklus);
   (tVoid) (oIn >> RPMIdlingTarget);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgEngineParameterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << TemperatureEngine);
   (tVoid) (oOut << TemperatureEngineOil);
   (tVoid) (oOut << StatusEngineRunning);
   (tVoid) (oOut << InjectionVolumeFuel);
   (tVoid) (oOut << ReductionDownControlRPM);
   (tVoid) (oOut << StatusRBMZyklus);
   (tVoid) (oOut << RPMIdlingTarget);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgEngineParameterStatus::operator==(const cmb_vehiclesensorfi_tclMsgEngineParameterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (TemperatureEngine == roRef.TemperatureEngine);
   bResult = bResult && (TemperatureEngineOil == roRef.TemperatureEngineOil);
   bResult = bResult && (StatusEngineRunning == roRef.StatusEngineRunning);
   bResult = bResult && (InjectionVolumeFuel == roRef.InjectionVolumeFuel);
   bResult = bResult && (ReductionDownControlRPM == roRef.ReductionDownControlRPM);
   bResult = bResult && (StatusRBMZyklus == roRef.StatusRBMZyklus);
   bResult = bResult && (RPMIdlingTarget == roRef.RPMIdlingTarget);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgDefrosterUpReg::cmb_vehiclesensorfi_tclMsgDefrosterUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDefrosterUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERUPREG;
}


cmb_vehiclesensorfi_tclMsgDefrosterUpReg::~cmb_vehiclesensorfi_tclMsgDefrosterUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgDefrosterRelUpReg::cmb_vehiclesensorfi_tclMsgDefrosterRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDefrosterRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERRELUPREG;
}


cmb_vehiclesensorfi_tclMsgDefrosterRelUpReg::~cmb_vehiclesensorfi_tclMsgDefrosterRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgDefrosterGet::cmb_vehiclesensorfi_tclMsgDefrosterGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDefrosterGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERGET;
}


cmb_vehiclesensorfi_tclMsgDefrosterGet::~cmb_vehiclesensorfi_tclMsgDefrosterGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgDefrosterStatus::cmb_vehiclesensorfi_tclMsgDefrosterStatus(const cmb_vehiclesensorfi_tclMsgDefrosterStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   RearDefroster = coRef.RearDefroster;
   RearViewDefroster = coRef.RearViewDefroster;
   FrontDefroster = coRef.FrontDefroster;
}
cmb_vehiclesensorfi_tclMsgDefrosterStatus& cmb_vehiclesensorfi_tclMsgDefrosterStatus::operator=(const cmb_vehiclesensorfi_tclMsgDefrosterStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   RearDefroster = coRef.RearDefroster;
   RearViewDefroster = coRef.RearViewDefroster;
   FrontDefroster = coRef.FrontDefroster;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgDefrosterStatus::cmb_vehiclesensorfi_tclMsgDefrosterStatus()
:Timestamp(0)
,RearDefroster()
,RearViewDefroster()
,FrontDefroster()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDefrosterStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERSTATUS;
}


cmb_vehiclesensorfi_tclMsgDefrosterStatus::~cmb_vehiclesensorfi_tclMsgDefrosterStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgDefrosterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgDefrosterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> RearDefroster);
   (tVoid) (oIn >> RearViewDefroster);
   (tVoid) (oIn >> FrontDefroster);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgDefrosterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << RearDefroster);
   (tVoid) (oOut << RearViewDefroster);
   (tVoid) (oOut << FrontDefroster);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgDefrosterStatus::operator==(const cmb_vehiclesensorfi_tclMsgDefrosterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (RearDefroster == roRef.RearDefroster);
   bResult = bResult && (RearViewDefroster == roRef.RearViewDefroster);
   bResult = bResult && (FrontDefroster == roRef.FrontDefroster);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgLDWUpReg::cmb_vehiclesensorfi_tclMsgLDWUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgLDWUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_LDWUPREG;
}


cmb_vehiclesensorfi_tclMsgLDWUpReg::~cmb_vehiclesensorfi_tclMsgLDWUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgLDWRelUpReg::cmb_vehiclesensorfi_tclMsgLDWRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgLDWRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_LDWRELUPREG;
}


cmb_vehiclesensorfi_tclMsgLDWRelUpReg::~cmb_vehiclesensorfi_tclMsgLDWRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgLDWGet::cmb_vehiclesensorfi_tclMsgLDWGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgLDWGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_LDWGET;
}


cmb_vehiclesensorfi_tclMsgLDWGet::~cmb_vehiclesensorfi_tclMsgLDWGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgLDWStatus::cmb_vehiclesensorfi_tclMsgLDWStatus(const cmb_vehiclesensorfi_tclMsgLDWStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   DistanceToLine = coRef.DistanceToLine;
   TimeToLine = coRef.TimeToLine;
   LDWSideIndicator = coRef.LDWSideIndicator;
}
cmb_vehiclesensorfi_tclMsgLDWStatus& cmb_vehiclesensorfi_tclMsgLDWStatus::operator=(const cmb_vehiclesensorfi_tclMsgLDWStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   DistanceToLine = coRef.DistanceToLine;
   TimeToLine = coRef.TimeToLine;
   LDWSideIndicator = coRef.LDWSideIndicator;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgLDWStatus::cmb_vehiclesensorfi_tclMsgLDWStatus()
:Timestamp(0)
,DistanceToLine()
,TimeToLine()
,LDWSideIndicator()
 {}

tS32 cmb_vehiclesensorfi_tclMsgLDWStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_LDWSTATUS;
}


cmb_vehiclesensorfi_tclMsgLDWStatus::~cmb_vehiclesensorfi_tclMsgLDWStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgLDWStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgLDWStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> DistanceToLine);
   (tVoid) (oIn >> TimeToLine);
   (tVoid) (oIn >> LDWSideIndicator);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgLDWStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << DistanceToLine);
   (tVoid) (oOut << TimeToLine);
   (tVoid) (oOut << LDWSideIndicator);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgLDWStatus::operator==(const cmb_vehiclesensorfi_tclMsgLDWStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (DistanceToLine == roRef.DistanceToLine);
   bResult = bResult && (TimeToLine == roRef.TimeToLine);
   bResult = bResult && (LDWSideIndicator == roRef.LDWSideIndicator);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgLaneDetectionUpReg::cmb_vehiclesensorfi_tclMsgLaneDetectionUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgLaneDetectionUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONUPREG;
}


cmb_vehiclesensorfi_tclMsgLaneDetectionUpReg::~cmb_vehiclesensorfi_tclMsgLaneDetectionUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgLaneDetectionRelUpReg::cmb_vehiclesensorfi_tclMsgLaneDetectionRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgLaneDetectionRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONRELUPREG;
}


cmb_vehiclesensorfi_tclMsgLaneDetectionRelUpReg::~cmb_vehiclesensorfi_tclMsgLaneDetectionRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgLaneDetectionGet::cmb_vehiclesensorfi_tclMsgLaneDetectionGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgLaneDetectionGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONGET;
}


cmb_vehiclesensorfi_tclMsgLaneDetectionGet::~cmb_vehiclesensorfi_tclMsgLaneDetectionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgLaneDetectionStatus::cmb_vehiclesensorfi_tclMsgLaneDetectionStatus(const cmb_vehiclesensorfi_tclMsgLaneDetectionStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   DetectedLineList = coRef.DetectedLineList;
}
cmb_vehiclesensorfi_tclMsgLaneDetectionStatus& cmb_vehiclesensorfi_tclMsgLaneDetectionStatus::operator=(const cmb_vehiclesensorfi_tclMsgLaneDetectionStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   DetectedLineList = coRef.DetectedLineList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgLaneDetectionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DetectedLineList.size(); ++u32Idx)
         DetectedLineList[u32Idx].vDestroy();
   DetectedLineList.clear();
   }
}

cmb_vehiclesensorfi_tclMsgLaneDetectionStatus::cmb_vehiclesensorfi_tclMsgLaneDetectionStatus()
:Timestamp(0)

 {}

tS32 cmb_vehiclesensorfi_tclMsgLaneDetectionStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONSTATUS;
}


cmb_vehiclesensorfi_tclMsgLaneDetectionStatus::~cmb_vehiclesensorfi_tclMsgLaneDetectionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgLaneDetectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(DetectedLineList.size()*16);
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgLaneDetectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DetectedLineList.size(); ++u32Idx)
      {
         DetectedLineList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DetectedLineList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DetectedLineList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgLaneDetectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << (tU32)DetectedLineList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DetectedLineList.size(); ++u32Idx)
         (tVoid) (oOut << DetectedLineList[u32Idx]);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgLaneDetectionStatus::operator==(const cmb_vehiclesensorfi_tclMsgLaneDetectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
      bResult = bResult && (DetectedLineList.size() == roRef.DetectedLineList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DetectedLineList.size()); ++u32Idx)
            bResult = bResult && (DetectedLineList[u32Idx] == roRef.DetectedLineList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgDetectedObjectsUpReg::cmb_vehiclesensorfi_tclMsgDetectedObjectsUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDetectedObjectsUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSUPREG;
}


cmb_vehiclesensorfi_tclMsgDetectedObjectsUpReg::~cmb_vehiclesensorfi_tclMsgDetectedObjectsUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgDetectedObjectsRelUpReg::cmb_vehiclesensorfi_tclMsgDetectedObjectsRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDetectedObjectsRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSRELUPREG;
}


cmb_vehiclesensorfi_tclMsgDetectedObjectsRelUpReg::~cmb_vehiclesensorfi_tclMsgDetectedObjectsRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgDetectedObjectsGet::cmb_vehiclesensorfi_tclMsgDetectedObjectsGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDetectedObjectsGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSGET;
}


cmb_vehiclesensorfi_tclMsgDetectedObjectsGet::~cmb_vehiclesensorfi_tclMsgDetectedObjectsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus::cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus(const cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   OldestTimestamp = coRef.OldestTimestamp;
   DetectedObjectsList = coRef.DetectedObjectsList;
}
cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus& cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus::operator=(const cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   OldestTimestamp = coRef.OldestTimestamp;
   DetectedObjectsList = coRef.DetectedObjectsList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DetectedObjectsList.size(); ++u32Idx)
         DetectedObjectsList[u32Idx].vDestroy();
   DetectedObjectsList.clear();
   }
}

cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus::cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus()
:Timestamp(0)
,OldestTimestamp(0)

 {}

tS32 cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSSTATUS;
}


cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus::~cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12+ static_cast<tU32>(DetectedObjectsList.size()*29);
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> OldestTimestamp);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DetectedObjectsList.size(); ++u32Idx)
      {
         DetectedObjectsList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DetectedObjectsList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DetectedObjectsList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << OldestTimestamp);
   (tVoid) (oOut << (tU32)DetectedObjectsList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DetectedObjectsList.size(); ++u32Idx)
         (tVoid) (oOut << DetectedObjectsList[u32Idx]);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus::operator==(const cmb_vehiclesensorfi_tclMsgDetectedObjectsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (OldestTimestamp == roRef.OldestTimestamp);
      bResult = bResult && (DetectedObjectsList.size() == roRef.DetectedObjectsList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DetectedObjectsList.size()); ++u32Idx)
            bResult = bResult && (DetectedObjectsList[u32Idx] == roRef.DetectedObjectsList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsUpReg::cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSUPREG;
}


cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsUpReg::~cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsRelUpReg::cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSRELUPREG;
}


cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsRelUpReg::~cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsGet::cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSGET;
}


cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsGet::~cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus::cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus(const cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   DetectedTrafficSignList = coRef.DetectedTrafficSignList;
}
cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus& cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus::operator=(const cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   DetectedTrafficSignList = coRef.DetectedTrafficSignList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DetectedTrafficSignList.size(); ++u32Idx)
         DetectedTrafficSignList[u32Idx].vDestroy();
   DetectedTrafficSignList.clear();
   }
}

cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus::cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus()
:Timestamp(0)

 {}

tS32 cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSSTATUS;
}


cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus::~cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DetectedTrafficSignList.size(); ++u32ListIdx)
      u32DynamicSize += DetectedTrafficSignList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DetectedTrafficSignList.size(); ++u32Idx)
      {
         DetectedTrafficSignList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DetectedTrafficSignList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DetectedTrafficSignList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << (tU32)DetectedTrafficSignList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DetectedTrafficSignList.size(); ++u32Idx)
         (tVoid) (oOut << DetectedTrafficSignList[u32Idx]);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus::operator==(const cmb_vehiclesensorfi_tclMsgDetectedTrafficSignsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
      bResult = bResult && (DetectedTrafficSignList.size() == roRef.DetectedTrafficSignList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DetectedTrafficSignList.size()); ++u32Idx)
            bResult = bResult && (DetectedTrafficSignList[u32Idx] == roRef.DetectedTrafficSignList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgSeatsUpReg::cmb_vehiclesensorfi_tclMsgSeatsUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSeatsUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSUPREG;
}


cmb_vehiclesensorfi_tclMsgSeatsUpReg::~cmb_vehiclesensorfi_tclMsgSeatsUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgSeatsRelUpReg::cmb_vehiclesensorfi_tclMsgSeatsRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSeatsRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSRELUPREG;
}


cmb_vehiclesensorfi_tclMsgSeatsRelUpReg::~cmb_vehiclesensorfi_tclMsgSeatsRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgSeatsGet::cmb_vehiclesensorfi_tclMsgSeatsGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgSeatsGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSGET;
}


cmb_vehiclesensorfi_tclMsgSeatsGet::~cmb_vehiclesensorfi_tclMsgSeatsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgSeatsStatus::cmb_vehiclesensorfi_tclMsgSeatsStatus(const cmb_vehiclesensorfi_tclMsgSeatsStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   SeatList = coRef.SeatList;
}
cmb_vehiclesensorfi_tclMsgSeatsStatus& cmb_vehiclesensorfi_tclMsgSeatsStatus::operator=(const cmb_vehiclesensorfi_tclMsgSeatsStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   SeatList = coRef.SeatList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgSeatsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SeatList.size(); ++u32Idx)
         SeatList[u32Idx].vDestroy();
   SeatList.clear();
   }
}

cmb_vehiclesensorfi_tclMsgSeatsStatus::cmb_vehiclesensorfi_tclMsgSeatsStatus()
:Timestamp(0)

 {}

tS32 cmb_vehiclesensorfi_tclMsgSeatsStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSSTATUS;
}


cmb_vehiclesensorfi_tclMsgSeatsStatus::~cmb_vehiclesensorfi_tclMsgSeatsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgSeatsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(SeatList.size()*11);
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgSeatsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SeatList.size(); ++u32Idx)
      {
         SeatList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SeatList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SeatList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgSeatsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << (tU32)SeatList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SeatList.size(); ++u32Idx)
         (tVoid) (oOut << SeatList[u32Idx]);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgSeatsStatus::operator==(const cmb_vehiclesensorfi_tclMsgSeatsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
      bResult = bResult && (SeatList.size() == roRef.SeatList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SeatList.size()); ++u32Idx)
            bResult = bResult && (SeatList[u32Idx] == roRef.SeatList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgElectricalMachineUpReg::cmb_vehiclesensorfi_tclMsgElectricalMachineUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgElectricalMachineUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINEUPREG;
}


cmb_vehiclesensorfi_tclMsgElectricalMachineUpReg::~cmb_vehiclesensorfi_tclMsgElectricalMachineUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgElectricalMachineRelUpReg::cmb_vehiclesensorfi_tclMsgElectricalMachineRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgElectricalMachineRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINERELUPREG;
}


cmb_vehiclesensorfi_tclMsgElectricalMachineRelUpReg::~cmb_vehiclesensorfi_tclMsgElectricalMachineRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgElectricalMachineGet::cmb_vehiclesensorfi_tclMsgElectricalMachineGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgElectricalMachineGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINEGET;
}


cmb_vehiclesensorfi_tclMsgElectricalMachineGet::~cmb_vehiclesensorfi_tclMsgElectricalMachineGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgElectricalMachineStatus::cmb_vehiclesensorfi_tclMsgElectricalMachineStatus(const cmb_vehiclesensorfi_tclMsgElectricalMachineStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   ElectricalMachineList = coRef.ElectricalMachineList;
}
cmb_vehiclesensorfi_tclMsgElectricalMachineStatus& cmb_vehiclesensorfi_tclMsgElectricalMachineStatus::operator=(const cmb_vehiclesensorfi_tclMsgElectricalMachineStatus& coRef)
{
   if (this == &coRef) return *this;
   ElectricalMachineList = coRef.ElectricalMachineList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgElectricalMachineStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ElectricalMachineList.size(); ++u32Idx)
         ElectricalMachineList[u32Idx].vDestroy();
   ElectricalMachineList.clear();
   }
}

cmb_vehiclesensorfi_tclMsgElectricalMachineStatus::cmb_vehiclesensorfi_tclMsgElectricalMachineStatus()

 {}

tS32 cmb_vehiclesensorfi_tclMsgElectricalMachineStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINESTATUS;
}


cmb_vehiclesensorfi_tclMsgElectricalMachineStatus::~cmb_vehiclesensorfi_tclMsgElectricalMachineStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgElectricalMachineStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ElectricalMachineList.size(); ++u32ListIdx)
      u32DynamicSize += ElectricalMachineList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgElectricalMachineStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ElectricalMachineList.size(); ++u32Idx)
      {
         ElectricalMachineList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ElectricalMachineList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ElectricalMachineList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgElectricalMachineStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ElectricalMachineList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ElectricalMachineList.size(); ++u32Idx)
         (tVoid) (oOut << ElectricalMachineList[u32Idx]);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgElectricalMachineStatus::operator==(const cmb_vehiclesensorfi_tclMsgElectricalMachineStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ElectricalMachineList.size() == roRef.ElectricalMachineList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElectricalMachineList.size()); ++u32Idx)
            bResult = bResult && (ElectricalMachineList[u32Idx] == roRef.ElectricalMachineList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgBatteryStatusUpReg::cmb_vehiclesensorfi_tclMsgBatteryStatusUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgBatteryStatusUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSUPREG;
}


cmb_vehiclesensorfi_tclMsgBatteryStatusUpReg::~cmb_vehiclesensorfi_tclMsgBatteryStatusUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgBatteryStatusRelUpReg::cmb_vehiclesensorfi_tclMsgBatteryStatusRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgBatteryStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSRELUPREG;
}


cmb_vehiclesensorfi_tclMsgBatteryStatusRelUpReg::~cmb_vehiclesensorfi_tclMsgBatteryStatusRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgBatteryStatusGet::cmb_vehiclesensorfi_tclMsgBatteryStatusGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgBatteryStatusGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSGET;
}


cmb_vehiclesensorfi_tclMsgBatteryStatusGet::~cmb_vehiclesensorfi_tclMsgBatteryStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgBatteryStatusStatus::cmb_vehiclesensorfi_tclMsgBatteryStatusStatus(const cmb_vehiclesensorfi_tclMsgBatteryStatusStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   RemainingCapacity = coRef.RemainingCapacity;
   NominalCapacity = coRef.NominalCapacity;
   SOCStatus = coRef.SOCStatus;
   SOCSet = coRef.SOCSet;
   BatteryTemperature = coRef.BatteryTemperature;
   BatteryVoltageParams = coRef.BatteryVoltageParams;
   BatteryCurrentParams = coRef.BatteryCurrentParams;
}
cmb_vehiclesensorfi_tclMsgBatteryStatusStatus& cmb_vehiclesensorfi_tclMsgBatteryStatusStatus::operator=(const cmb_vehiclesensorfi_tclMsgBatteryStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   RemainingCapacity = coRef.RemainingCapacity;
   NominalCapacity = coRef.NominalCapacity;
   SOCStatus = coRef.SOCStatus;
   SOCSet = coRef.SOCSet;
   BatteryTemperature = coRef.BatteryTemperature;
   BatteryVoltageParams = coRef.BatteryVoltageParams;
   BatteryCurrentParams = coRef.BatteryCurrentParams;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgBatteryStatusStatus::cmb_vehiclesensorfi_tclMsgBatteryStatusStatus()
:Timestamp(0)
,RemainingCapacity()
,NominalCapacity()
,SOCStatus()
,SOCSet()
,BatteryTemperature()
,BatteryVoltageParams()
,BatteryCurrentParams()
 {}

tS32 cmb_vehiclesensorfi_tclMsgBatteryStatusStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSSTATUS;
}


cmb_vehiclesensorfi_tclMsgBatteryStatusStatus::~cmb_vehiclesensorfi_tclMsgBatteryStatusStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgBatteryStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 12;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 12;
   }
   return u32DynamicSize+12;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgBatteryStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> RemainingCapacity);
   (tVoid) (oIn >> NominalCapacity);
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> SOCStatus);
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> SOCSet);
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> BatteryTemperature);
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> BatteryVoltageParams);
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> BatteryCurrentParams);
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgBatteryStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << RemainingCapacity);
   (tVoid) (oOut << NominalCapacity);
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << SOCStatus);
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << SOCSet);
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << BatteryTemperature);
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << BatteryVoltageParams);
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << BatteryCurrentParams);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgBatteryStatusStatus::operator==(const cmb_vehiclesensorfi_tclMsgBatteryStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (RemainingCapacity == roRef.RemainingCapacity);
   bResult = bResult && (NominalCapacity == roRef.NominalCapacity);
   bResult = bResult && (SOCStatus == roRef.SOCStatus);
   bResult = bResult && (SOCSet == roRef.SOCSet);
   bResult = bResult && (BatteryTemperature == roRef.BatteryTemperature);
   bResult = bResult && (BatteryVoltageParams == roRef.BatteryVoltageParams);
   bResult = bResult && (BatteryCurrentParams == roRef.BatteryCurrentParams);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionUpReg::cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONUPREG;
}


cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionUpReg::~cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionRelUpReg::cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONRELUPREG;
}


cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionRelUpReg::~cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionGet::cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONGET;
}


cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionGet::~cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus::cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus(const cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   InitialConditioningMinEnergyConsumption = coRef.InitialConditioningMinEnergyConsumption;
   MaintainingConditionMinPowerDemand = coRef.MaintainingConditionMinPowerDemand;
   InitialConditioningMaxEnergyConsumption = coRef.InitialConditioningMaxEnergyConsumption;
   MaintainingConditionMaxPowerDemand = coRef.MaintainingConditionMaxPowerDemand;
   InitialConditioningAverageEnergyConsumption = coRef.InitialConditioningAverageEnergyConsumption;
   MaintainingConditionAveragePowerDemand = coRef.MaintainingConditionAveragePowerDemand;
}
cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus& cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus::operator=(const cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   InitialConditioningMinEnergyConsumption = coRef.InitialConditioningMinEnergyConsumption;
   MaintainingConditionMinPowerDemand = coRef.MaintainingConditionMinPowerDemand;
   InitialConditioningMaxEnergyConsumption = coRef.InitialConditioningMaxEnergyConsumption;
   MaintainingConditionMaxPowerDemand = coRef.MaintainingConditionMaxPowerDemand;
   InitialConditioningAverageEnergyConsumption = coRef.InitialConditioningAverageEnergyConsumption;
   MaintainingConditionAveragePowerDemand = coRef.MaintainingConditionAveragePowerDemand;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus::vDestroy()
{
   InitialConditioningMinEnergyConsumption.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < MaintainingConditionMinPowerDemand.size(); ++u32Idx)
         MaintainingConditionMinPowerDemand[u32Idx].vDestroy();
   MaintainingConditionMinPowerDemand.clear();
   }
   InitialConditioningMaxEnergyConsumption.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < MaintainingConditionMaxPowerDemand.size(); ++u32Idx)
         MaintainingConditionMaxPowerDemand[u32Idx].vDestroy();
   MaintainingConditionMaxPowerDemand.clear();
   }
   InitialConditioningAverageEnergyConsumption.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < MaintainingConditionAveragePowerDemand.size(); ++u32Idx)
         MaintainingConditionAveragePowerDemand[u32Idx].vDestroy();
   MaintainingConditionAveragePowerDemand.clear();
   }
}

cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus::cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus()
:Timestamp(0)
,InitialConditioningMinEnergyConsumption()

,InitialConditioningMaxEnergyConsumption()

,InitialConditioningAverageEnergyConsumption()

 {}

tS32 cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONSTATUS;
}


cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus::~cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 28+ static_cast<tU32>(MaintainingConditionMinPowerDemand.size()*4)+ static_cast<tU32>(MaintainingConditionMaxPowerDemand.size()*4)+ static_cast<tU32>(MaintainingConditionAveragePowerDemand.size()*4);
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> InitialConditioningMinEnergyConsumption);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MaintainingConditionMinPowerDemand.size(); ++u32Idx)
      {
         MaintainingConditionMinPowerDemand[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      MaintainingConditionMinPowerDemand.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MaintainingConditionMinPowerDemand[u32Idx]);
      }
   }
   (tVoid) (oIn >> InitialConditioningMaxEnergyConsumption);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MaintainingConditionMaxPowerDemand.size(); ++u32Idx)
      {
         MaintainingConditionMaxPowerDemand[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      MaintainingConditionMaxPowerDemand.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MaintainingConditionMaxPowerDemand[u32Idx]);
      }
   }
   (tVoid) (oIn >> InitialConditioningAverageEnergyConsumption);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MaintainingConditionAveragePowerDemand.size(); ++u32Idx)
      {
         MaintainingConditionAveragePowerDemand[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      MaintainingConditionAveragePowerDemand.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MaintainingConditionAveragePowerDemand[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << InitialConditioningMinEnergyConsumption);
   (tVoid) (oOut << (tU32)MaintainingConditionMinPowerDemand.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MaintainingConditionMinPowerDemand.size(); ++u32Idx)
         (tVoid) (oOut << MaintainingConditionMinPowerDemand[u32Idx]);
   }
   (tVoid) (oOut << InitialConditioningMaxEnergyConsumption);
   (tVoid) (oOut << (tU32)MaintainingConditionMaxPowerDemand.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MaintainingConditionMaxPowerDemand.size(); ++u32Idx)
         (tVoid) (oOut << MaintainingConditionMaxPowerDemand[u32Idx]);
   }
   (tVoid) (oOut << InitialConditioningAverageEnergyConsumption);
   (tVoid) (oOut << (tU32)MaintainingConditionAveragePowerDemand.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MaintainingConditionAveragePowerDemand.size(); ++u32Idx)
         (tVoid) (oOut << MaintainingConditionAveragePowerDemand[u32Idx]);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus::operator==(const cmb_vehiclesensorfi_tclMsgAuxiliaryConsumerPredictionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (InitialConditioningMinEnergyConsumption == roRef.InitialConditioningMinEnergyConsumption);
      bResult = bResult && (MaintainingConditionMinPowerDemand.size() == roRef.MaintainingConditionMinPowerDemand.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MaintainingConditionMinPowerDemand.size()); ++u32Idx)
            bResult = bResult && (MaintainingConditionMinPowerDemand[u32Idx] == roRef.MaintainingConditionMinPowerDemand[u32Idx]);
      }
   bResult = bResult && (InitialConditioningMaxEnergyConsumption == roRef.InitialConditioningMaxEnergyConsumption);
      bResult = bResult && (MaintainingConditionMaxPowerDemand.size() == roRef.MaintainingConditionMaxPowerDemand.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MaintainingConditionMaxPowerDemand.size()); ++u32Idx)
            bResult = bResult && (MaintainingConditionMaxPowerDemand[u32Idx] == roRef.MaintainingConditionMaxPowerDemand[u32Idx]);
      }
   bResult = bResult && (InitialConditioningAverageEnergyConsumption == roRef.InitialConditioningAverageEnergyConsumption);
      bResult = bResult && (MaintainingConditionAveragePowerDemand.size() == roRef.MaintainingConditionAveragePowerDemand.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MaintainingConditionAveragePowerDemand.size()); ++u32Idx)
            bResult = bResult && (MaintainingConditionAveragePowerDemand[u32Idx] == roRef.MaintainingConditionAveragePowerDemand[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgProblemMarkerUpReg::cmb_vehiclesensorfi_tclMsgProblemMarkerUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgProblemMarkerUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERUPREG;
}


cmb_vehiclesensorfi_tclMsgProblemMarkerUpReg::~cmb_vehiclesensorfi_tclMsgProblemMarkerUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgProblemMarkerRelUpReg::cmb_vehiclesensorfi_tclMsgProblemMarkerRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgProblemMarkerRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERRELUPREG;
}


cmb_vehiclesensorfi_tclMsgProblemMarkerRelUpReg::~cmb_vehiclesensorfi_tclMsgProblemMarkerRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgProblemMarkerGet::cmb_vehiclesensorfi_tclMsgProblemMarkerGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgProblemMarkerGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERGET;
}


cmb_vehiclesensorfi_tclMsgProblemMarkerGet::~cmb_vehiclesensorfi_tclMsgProblemMarkerGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgProblemMarkerStatus::cmb_vehiclesensorfi_tclMsgProblemMarkerStatus(const cmb_vehiclesensorfi_tclMsgProblemMarkerStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   LinkId = coRef.LinkId;
   OffsetOnLinkId = coRef.OffsetOnLinkId;
   Position = coRef.Position;
   EntityTypeId = coRef.EntityTypeId;
   EntityContent = coRef.EntityContent;
   EntityId = coRef.EntityId;
   TimeExtensionBackwards = coRef.TimeExtensionBackwards;
   TimeExtensionForward = coRef.TimeExtensionForward;
   DistanceExtensionBackwards = coRef.DistanceExtensionBackwards;
   DistanceExtensionForward = coRef.DistanceExtensionForward;
}
cmb_vehiclesensorfi_tclMsgProblemMarkerStatus& cmb_vehiclesensorfi_tclMsgProblemMarkerStatus::operator=(const cmb_vehiclesensorfi_tclMsgProblemMarkerStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   LinkId = coRef.LinkId;
   OffsetOnLinkId = coRef.OffsetOnLinkId;
   Position = coRef.Position;
   EntityTypeId = coRef.EntityTypeId;
   EntityContent = coRef.EntityContent;
   EntityId = coRef.EntityId;
   TimeExtensionBackwards = coRef.TimeExtensionBackwards;
   TimeExtensionForward = coRef.TimeExtensionForward;
   DistanceExtensionBackwards = coRef.DistanceExtensionBackwards;
   DistanceExtensionForward = coRef.DistanceExtensionForward;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgProblemMarkerStatus::cmb_vehiclesensorfi_tclMsgProblemMarkerStatus()
:Timestamp(0)
,LinkId(0)
,OffsetOnLinkId()
,Position()
,EntityTypeId(0)
,EntityContent(0)
,EntityId(0)
,TimeExtensionBackwards()
,TimeExtensionForward()
,DistanceExtensionBackwards()
,DistanceExtensionForward()
 {}

tS32 cmb_vehiclesensorfi_tclMsgProblemMarkerStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERSTATUS;
}


cmb_vehiclesensorfi_tclMsgProblemMarkerStatus::~cmb_vehiclesensorfi_tclMsgProblemMarkerStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgProblemMarkerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 43;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgProblemMarkerStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> LinkId);
   (tVoid) (oIn >> OffsetOnLinkId);
   (tVoid) (oIn >> Position);
   (tVoid) (oIn >> EntityTypeId);
   (tVoid) (oIn >> EntityContent);
   (tVoid) (oIn >> EntityId);
   (tVoid) (oIn >> TimeExtensionBackwards);
   (tVoid) (oIn >> TimeExtensionForward);
   (tVoid) (oIn >> DistanceExtensionBackwards);
   (tVoid) (oIn >> DistanceExtensionForward);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgProblemMarkerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << LinkId);
   (tVoid) (oOut << OffsetOnLinkId);
   (tVoid) (oOut << Position);
   (tVoid) (oOut << EntityTypeId);
   (tVoid) (oOut << EntityContent);
   (tVoid) (oOut << EntityId);
   (tVoid) (oOut << TimeExtensionBackwards);
   (tVoid) (oOut << TimeExtensionForward);
   (tVoid) (oOut << DistanceExtensionBackwards);
   (tVoid) (oOut << DistanceExtensionForward);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgProblemMarkerStatus::operator==(const cmb_vehiclesensorfi_tclMsgProblemMarkerStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (LinkId == roRef.LinkId);
   bResult = bResult && (OffsetOnLinkId == roRef.OffsetOnLinkId);
   bResult = bResult && (Position == roRef.Position);
   bResult = bResult && (EntityTypeId == roRef.EntityTypeId);
   bResult = bResult && (EntityContent == roRef.EntityContent);
   bResult = bResult && (EntityId == roRef.EntityId);
   bResult = bResult && (TimeExtensionBackwards == roRef.TimeExtensionBackwards);
   bResult = bResult && (TimeExtensionForward == roRef.TimeExtensionForward);
   bResult = bResult && (DistanceExtensionBackwards == roRef.DistanceExtensionBackwards);
   bResult = bResult && (DistanceExtensionForward == roRef.DistanceExtensionForward);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSUpReg::cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSUPREG;
}


cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSUpReg::~cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSRelUpReg::cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSRELUPREG;
}


cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSRelUpReg::~cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSGet::cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSGET;
}


cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSGet::~cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus::cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus(const cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   StartLinkId = coRef.StartLinkId;
   OffsetOnStartLinkId = coRef.OffsetOnStartLinkId;
   EndLinkId = coRef.EndLinkId;
   OffsetOnEndLinkId = coRef.OffsetOnEndLinkId;
   EntityTypeId = coRef.EntityTypeId;
   EntityContent = coRef.EntityContent;
   EntityId = coRef.EntityId;
}
cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus& cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus::operator=(const cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   StartLinkId = coRef.StartLinkId;
   OffsetOnStartLinkId = coRef.OffsetOnStartLinkId;
   EndLinkId = coRef.EndLinkId;
   OffsetOnEndLinkId = coRef.OffsetOnEndLinkId;
   EntityTypeId = coRef.EntityTypeId;
   EntityContent = coRef.EntityContent;
   EntityId = coRef.EntityId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus::cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus()
:Timestamp(0)
,StartLinkId(0)
,OffsetOnStartLinkId()
,EndLinkId(0)
,OffsetOnEndLinkId()
,EntityTypeId(0)
,EntityContent(0)
,EntityId(0)
 {}

tS32 cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSSTATUS;
}


cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus::~cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (11 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+31;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> StartLinkId);
   (tVoid) (oIn >> OffsetOnStartLinkId);
   (tVoid) (oIn >> EndLinkId);
   (tVoid) (oIn >> OffsetOnEndLinkId);
   (tVoid) (oIn >> EntityTypeId);
   if (11 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> EntityContent);
   }
   (tVoid) (oIn >> EntityId);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << StartLinkId);
   (tVoid) (oOut << OffsetOnStartLinkId);
   (tVoid) (oOut << EndLinkId);
   (tVoid) (oOut << OffsetOnEndLinkId);
   (tVoid) (oOut << EntityTypeId);
   if (11 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << EntityContent);
   }
   (tVoid) (oOut << EntityId);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus::operator==(const cmb_vehiclesensorfi_tclMsgProblemMarkerIPPCPLUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (StartLinkId == roRef.StartLinkId);
   bResult = bResult && (OffsetOnStartLinkId == roRef.OffsetOnStartLinkId);
   bResult = bResult && (EndLinkId == roRef.EndLinkId);
   bResult = bResult && (OffsetOnEndLinkId == roRef.OffsetOnEndLinkId);
   bResult = bResult && (EntityTypeId == roRef.EntityTypeId);
   bResult = bResult && (EntityContent == roRef.EntityContent);
   bResult = bResult && (EntityId == roRef.EntityId);
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgIPPCPlusDataUpReg::cmb_vehiclesensorfi_tclMsgIPPCPlusDataUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgIPPCPlusDataUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATAUPREG;
}


cmb_vehiclesensorfi_tclMsgIPPCPlusDataUpReg::~cmb_vehiclesensorfi_tclMsgIPPCPlusDataUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgIPPCPlusDataRelUpReg::cmb_vehiclesensorfi_tclMsgIPPCPlusDataRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgIPPCPlusDataRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATARELUPREG;
}


cmb_vehiclesensorfi_tclMsgIPPCPlusDataRelUpReg::~cmb_vehiclesensorfi_tclMsgIPPCPlusDataRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgIPPCPlusDataGet::cmb_vehiclesensorfi_tclMsgIPPCPlusDataGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgIPPCPlusDataGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATAGET;
}


cmb_vehiclesensorfi_tclMsgIPPCPlusDataGet::~cmb_vehiclesensorfi_tclMsgIPPCPlusDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus::cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus(const cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   DataList = coRef.DataList;
}
cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus& cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus::operator=(const cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus& coRef)
{
   if (this == &coRef) return *this;
   DataList = coRef.DataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DataList.size(); ++u32Idx)
         DataList[u32Idx].vDestroy();
   DataList.clear();
   }
}

cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus::cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus()

 {}

tS32 cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATASTATUS;
}


cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus::~cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(DataList.size()*16);
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DataList.size(); ++u32Idx)
      {
         DataList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DataList.size(); ++u32Idx)
         (tVoid) (oOut << DataList[u32Idx]);
   }
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus::operator==(const cmb_vehiclesensorfi_tclMsgIPPCPlusDataStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DataList.size() == roRef.DataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DataList.size()); ++u32Idx)
            bResult = bResult && (DataList[u32Idx] == roRef.DataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoUpReg::cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFOUPREG;
}


cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoUpReg::~cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoRelUpReg::cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoRelUpReg()
 {}

tS32 cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFORELUPREG;
}


cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoRelUpReg::~cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoRelUpReg()
{}

//=============================================================================

cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoGet::cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoGet()
 {}

tS32 cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoGet::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFOGET;
}


cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoGet::~cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus::cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus(const cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus& coRef)
   : cmb_vehiclesensorfi_tclMsgBaseMessage(coRef)
{
   Timestamp = coRef.Timestamp;
   VehicleType = coRef.VehicleType;
   TrailerConnected = coRef.TrailerConnected;
   GrossVehicleWeight = coRef.GrossVehicleWeight;
   HazardousGoods = coRef.HazardousGoods;
   OffsetUTC_Hours = coRef.OffsetUTC_Hours;
   OffsetUTC_Minutes = coRef.OffsetUTC_Minutes;
}
cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus& cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus::operator=(const cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   VehicleType = coRef.VehicleType;
   TrailerConnected = coRef.TrailerConnected;
   GrossVehicleWeight = coRef.GrossVehicleWeight;
   HazardousGoods = coRef.HazardousGoods;
   OffsetUTC_Hours = coRef.OffsetUTC_Hours;
   OffsetUTC_Minutes = coRef.OffsetUTC_Minutes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus::cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus()
:Timestamp(0)
,VehicleType(0)
,TrailerConnected(0)
,GrossVehicleWeight(0)
,HazardousGoods(0)
,OffsetUTC_Hours(0)
,OffsetUTC_Minutes(0)
 {}

tS32 cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus::s32GetTypeId() const
{
   return (tS32) cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFOSTATUS;
}


cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus::~cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus()
{}

tU32 cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> VehicleType);
   (tVoid) (oIn >> TrailerConnected);
   (tVoid) (oIn >> GrossVehicleWeight);
   (tVoid) (oIn >> HazardousGoods);
   (tVoid) (oIn >> OffsetUTC_Hours);
   (tVoid) (oIn >> OffsetUTC_Minutes);
   return oIn;
}

fi_tclOutContext& cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << VehicleType);
   (tVoid) (oOut << TrailerConnected);
   (tVoid) (oOut << GrossVehicleWeight);
   (tVoid) (oOut << HazardousGoods);
   (tVoid) (oOut << OffsetUTC_Hours);
   (tVoid) (oOut << OffsetUTC_Minutes);
   return oOut;
}

tBool cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus::operator==(const cmb_vehiclesensorfi_tclMsgIPPCPlusSpeedLimitRelInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (VehicleType == roRef.VehicleType);
   bResult = bResult && (TrailerConnected == roRef.TrailerConnected);
   bResult = bResult && (GrossVehicleWeight == roRef.GrossVehicleWeight);
   bResult = bResult && (HazardousGoods == roRef.HazardousGoods);
   bResult = bResult && (OffsetUTC_Hours == roRef.OffsetUTC_Hours);
   bResult = bResult && (OffsetUTC_Minutes == roRef.OffsetUTC_Minutes);
   return bResult;
}

