#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CMB_FI_S_IMPORT_INTERFACE_CMB_VEHICLESENSORFI_STDVISITORS
#include "cmb_fi_gen_if.h"

tBool cmb_vehiclesensorfi_tclDescription::bInitMessage(cmb_vehiclesensorfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case cmb_vehiclesensorfi_tclToken::EN_LAST_TOKEN:
   case cmb_vehiclesensorfi_tclToken::EN_LIST:
   case cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT:
   case cmb_vehiclesensorfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;
   // include the expansions for the messages
   case cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_WHEELSLIP,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_WHEELSLIPLIST)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_VEHICLEDRIVINGCONDITION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_VEHICLEDRIVINGCONDITION)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_VEHICLESPEED)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_RAINSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_RAINSENSORINNORMALMODE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8_PERCENT,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_INTENSITYRAIN)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U16_RPM,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_WIPERSPEED)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_DIRECTIONINDICATOR,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DIRECTIONINDICATION)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_REARFOGLIGHT)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_FRONTFOGLIGHT)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DAYTIMERUNNINGLIGHT)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_HEADLIGHTS,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_HEADLIGHTS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_B16_VESE_CENTRALLOCKING,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_CENTRALLOCKINGSTATE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_DOORSTATUS,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DOORSTATUSLIST)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCESTATUS:
   {
      if (10 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_FULLLOADACTIVE)) && bResult;
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TORQUEDRIVERSCHOICEATCLUTCHLEVEL)) && bResult;
      }
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TORQUEDRIVERSCHOICE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TORQUEMINIMUM)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_OVERRUNFUELSHUTOFF,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_OVERRUNFUELSHUTOFF)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ROTATIONIRREGULARITY,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ROTATIONIRREGULARITY)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ENGINETORQUE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_WHEELMOMENT)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8_PERCENT,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ACCPEDAL)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U16_RPM,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ENGINESPEED)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKESTATUS:
   {
      if (10 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_RETARDERBRAKE)) && bResult;
      }
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_EMFBRAKE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_HANDBRAKESTATUS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_B32_VESE_BRAKECONTROLMODE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_CLOSELOOPCONTROLSTATUS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_WHEELBRAKEPRESSURE,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_BRAKEPRESSURELIST)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_BRAKEPEDALPRESSED)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_SWITCHCLUTCH)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_GEARBOXSPORTSWITCH,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_GEARBOXSPORTSWITCH)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_CONVERTERCLUTCH,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TORQUECONVERTERLOCKUPCLUTCH)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_B8_VESE_GEARBOXSTATE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_GEARBOXSTATE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_GEARNUM,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_GEARLEVERPOSITION)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_GEARNUM,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_GEARPOSITION)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_IGNITION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_IGNITION)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLESTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_WHEELRATESENSOROK)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_WHEELANGLESENSOROK)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_WHEELRATE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_WHEELANGLE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLSTATUS:
   {
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_BOOL,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DESIREDDECELERATIONAPPROVEDACC)) && bResult;
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSQUARESECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DESIREDDECELERATIONACC)) && bResult;
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_BOOL,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DESIREDTORQUEAPPROVEDACC)) && bResult;
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DESIREDTORQUEACC)) && bResult;
      }
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_LOCKEDLEADCARSPEED)) && bResult;
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_METER,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DISTANCETOLOCKEDLEADCAR)) && bResult;
      }
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DISTANCETOLOCKEDLEADCARSUFFICIENT)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_LOCKEDLEADCAR)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_COASTINGSETSPEED)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_COASTINGACTIVE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_SETSPEED)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_CCSTATE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_STATE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_CCTYPE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TYPE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONSTATUS:
   {
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_K0STATUS,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_STATUSK0)) && bResult;
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U16,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_COSTFACTORDISCHARGE)) && bResult;
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U16,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_COSTFACTORCHARGE)) && bResult;
      }
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_FUELSAVING)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32_MICROLITER,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_FUELCONSUMPTIONHYBRID)) && bResult;
      if (poOutContext->u16GetMajorVersion() <= 8)
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_SOCSET)) && bResult;
      }
      if (poOutContext->u16GetMajorVersion() <= 8)
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_SOCSTATUS)) && bResult;
      }
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICSTATUS:
   {
      if (10 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DRIVENCURVATURECONFIDENCE)) && bResult;
      }
      if (10 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CURVATUREVALUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DRIVENCURVATURE)) && bResult;
      }
      if (10 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_SLOPECONFIDENCE)) && bResult;
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_SLOPE)) && bResult;
      }
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSQUARESECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_LATERALACCELERATION)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSQUARESECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_LONGITUDINALACCELERATION)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CENTIDEGREESECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_YAWRATE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_OLDESTTIMESTAMP)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSSTATUS:
   {
      if (10 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_KILOGRAM,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_VEHICLEWEIGHT)) && bResult;
      }
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_NUMBEROFDOORS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_NUMBEROFSEATS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_SIDEINDICATOR,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DRIVE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_LOWERCRITICALVELOCITY)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_STRING,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_CHASSISNUMBER)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_B16_VESE_KEYLOCATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_KEYLOCATION)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_KEYTYPE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_KEYTYP)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_KEYNUMBER)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_KEYVALIDITY,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_KEYVALID)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLSTATUS:
   {
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_COMPRESSORLOAD)) && bResult;
      }
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DEFROSTERSTATUS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ACSTATUS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ACCOMPRESSORSTATUS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_WINDOWSTATUS,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_WINDOWPOSITIONLIST)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32_MILLILUX,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_AMBIENCEBRIGHTNESS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_PASCAL,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_AIRPRESSURE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_DECIKELVIN,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_OUTSIDETEMPERATURE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_WHEELAIRPRESSURE,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIREPRESSURELIST)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TRAILERATTACHED)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_VEHICLETILT)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U16,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_RPMIDLINGTARGET)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_STATUSRBMZYKLUS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_REDUCTIONRPM,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_REDUCTIONDOWNCONTROLRPM)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32_MICROLITER,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_INJECTIONVOLUMEFUEL)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_B16_VESE_ENGINESTATUS,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_STATUSENGINERUNNING)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_DECIKELVIN,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TEMPERATUREENGINEOIL)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_DECIKELVIN,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TEMPERATUREENGINE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_FRONTDEFROSTER)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_REARVIEWDEFROSTER)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_REARDEFROSTER)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_LDWSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_SIDEINDICATOR,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_LDWSIDEINDICATOR)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U16_MILLISECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMETOLINE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DISTANCETOLINE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_LINEINFO,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DETECTEDLINELIST)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_DETECTEDOBJECT,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DETECTEDOBJECTSLIST)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_OLDESTTIMESTAMP)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_DETECTEDTRAFFICSIGN,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DETECTEDTRAFFICSIGNLIST)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_SEATSTATUS,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_SEATLIST)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINESTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_ELECTRICALMACHINE,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ELECTRICALMACHINELIST)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSSTATUS:
   {
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_CURRENTPARAMS,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_BATTERYCURRENTPARAMS)) && bResult;
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_VOLTAGEPARAMS,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_BATTERYVOLTAGEPARAMS)) && bResult;
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_DECIKELVIN,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_BATTERYTEMPERATURE)) && bResult;
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_SOCSET)) && bResult;
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_SOCSTATUS)) && bResult;
      }
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32_WS,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_NOMINALCAPACITY)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32_WS,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_REMAININGCAPACITY)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_POWERDEMANDATSPEED,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_MAINTAININGCONDITIONAVERAGEPOWERDEMAND)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_ENERGYCONSUMPTION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_INITIALCONDITIONINGAVERAGEENERGYCONSUMPTION)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_POWERDEMANDATSPEED,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_MAINTAININGCONDITIONMAXPOWERDEMAND)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_ENERGYCONSUMPTION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_INITIALCONDITIONINGMAXENERGYCONSUMPTION)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_POWERDEMANDATSPEED,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_MAINTAININGCONDITIONMINPOWERDEMAND)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_ENERGYCONSUMPTION,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_INITIALCONDITIONINGMINENERGYCONSUMPTION)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DISTANCEEXTENSIONFORWARD)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DISTANCEEXTENSIONBACKWARDS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_MILLISECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMEEXTENSIONFORWARD)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_MILLISECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMEEXTENSIONBACKWARDS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ENTITYID)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ENTITYCONTENT)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ENTITYTYPEID)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_POSITIONWGS84,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_POSITION)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_OFFSETONLINKID)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U64,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_LINKID)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U16,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ENTITYID)) && bResult;
      if (11 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ENTITYCONTENT)) && bResult;
      }
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ENTITYTYPEID)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_OFFSETONENDLINKID)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U64,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_ENDLINKID)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_OFFSETONSTARTLINKID)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U64,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_STARTLINKID)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATASTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_IPPCPLUSDATA,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_DATALIST)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFOSTATUS:
   {
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_OFFSETUTC_MINUTES)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_OFFSETUTC_HOURS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_HAZARDOUSGOODS)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U16,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_GROSSVEHICLEWEIGHT)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TRAILERCONNECTED)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_VEHICLETYPE)) && bResult;
      bResult = oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_MSG_TIMESTAMP)) && bResult;
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_RAINUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_RAINRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_RAINGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCEUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCERELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCEGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKEUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKERELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKEGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLEUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLERELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLEGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_LDWUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_LDWRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_LDWGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINEUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINERELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINEGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSRELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATAUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATARELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATAGET:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFOUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFORELUPREG:
   case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFOGET:
   case cmb_vehiclesensorfi_tclToken::EN_BINCONTAINER:
   case cmb_vehiclesensorfi_tclToken::EN_RESERVED:
   case cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND:
   case cmb_vehiclesensorfi_tclToken::EN_S32_PASCAL:
   case cmb_vehiclesensorfi_tclToken::EN_U8_PERCENT:
   case cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER:
   case cmb_vehiclesensorfi_tclToken::EN_S16_CENTIDEGREE:
   case cmb_vehiclesensorfi_tclToken::EN_S16_KMPERHOUR:
   case cmb_vehiclesensorfi_tclToken::EN_U16_RPM:
   case cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSECOND:
   case cmb_vehiclesensorfi_tclToken::EN_S16_METER:
   case cmb_vehiclesensorfi_tclToken::EN_S32_METER:
   case cmb_vehiclesensorfi_tclToken::EN_S32_YARDS:
   case cmb_vehiclesensorfi_tclToken::EN_S32_INCH:
   case cmb_vehiclesensorfi_tclToken::EN_S32_KILOGRAM:
   case cmb_vehiclesensorfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE:
   case cmb_vehiclesensorfi_tclToken::EN_U16_MILLISECOND:
   case cmb_vehiclesensorfi_tclToken::EN_S32_MILLISECOND:
   case cmb_vehiclesensorfi_tclToken::EN_S32_LONGITUDE:
   case cmb_vehiclesensorfi_tclToken::EN_S32_LATITUDE:
   case cmb_vehiclesensorfi_tclToken::EN_POSITIONWGS84:
   case cmb_vehiclesensorfi_tclToken::EN_S16_MILESPERHOUR:
   case cmb_vehiclesensorfi_tclToken::EN_S32_POUND:
   case cmb_vehiclesensorfi_tclToken::EN_S16_DECIKELVIN:
   case cmb_vehiclesensorfi_tclToken::EN_S16_CENTIDEGREESECOND:
   case cmb_vehiclesensorfi_tclToken::EN_U32_MILLILUX:
   case cmb_vehiclesensorfi_tclToken::EN_U32_MICROLITER:
   case cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSQUARESECOND:
   case cmb_vehiclesensorfi_tclToken::EN_S16_CURVATUREVALUE:
   case cmb_vehiclesensorfi_tclToken::EN_S32_CURVATURECHANGE:
   case cmb_vehiclesensorfi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY:
   case cmb_vehiclesensorfi_tclToken::EN_E8_SPEEDSIGN:
   case cmb_vehiclesensorfi_tclToken::EN_E16_WARNINGSIGN:
   case cmb_vehiclesensorfi_tclToken::EN_E16_REGULATORYSIGN:
   case cmb_vehiclesensorfi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN:
   case cmb_vehiclesensorfi_tclToken::EN_TIMEDEPENDENTSTRING:
   case cmb_vehiclesensorfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY:
   case cmb_vehiclesensorfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER:
   case cmb_vehiclesensorfi_tclToken::EN_ADDITIONALTRAFFICSIGN:
   case cmb_vehiclesensorfi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0:
   case cmb_vehiclesensorfi_tclToken::EN_TRAFFICSIGNELEMENT:
   case cmb_vehiclesensorfi_tclToken::EN_TRAFFICSIGNELEMENTUNION0:
   case cmb_vehiclesensorfi_tclToken::EN_TRAFFICSIGNELEMENTUNION1:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_WHEELSLIP:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_WHEELBRAKEPRESSURE:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_WHEELAIRPRESSURE:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_DOORTYPE:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_WINDOWTYPE:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_LINECOLOR:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_DOORSTATUS:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_WINDOWSTATUS:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_SEATOCCUPATION:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_DIRECTIONINDICATOR:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_GEARNUM:
   case cmb_vehiclesensorfi_tclToken::EN_B8_VESE_GEARBOXSTATE:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_CCTYPE:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_CCSTATE:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_IGNITION:
   case cmb_vehiclesensorfi_tclToken::EN_B32_VESE_BRAKECONTROLMODE:
   case cmb_vehiclesensorfi_tclToken::EN_B16_VESE_CENTRALLOCKING:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ROTATIONIRREGULARITY:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_OVERRUNFUELSHUTOFF:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_CONVERTERCLUTCH:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_GEARBOXSPORTSWITCH:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_HEADLIGHTS:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_SEATSTATUS:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_VEHICLEDRIVINGCONDITION:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_KEYVALIDITY:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_KEYTYPE:
   case cmb_vehiclesensorfi_tclToken::EN_B16_VESE_KEYLOCATION:
   case cmb_vehiclesensorfi_tclToken::EN_B16_VESE_ENGINESTATUS:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_REDUCTIONRPM:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_SIDEINDICATOR:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_LINEINFO:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_OBJECTTYPE:
   case cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_DETECTEDOBJECT:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_TSCLASSIFICATIONQUALITY:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_TSQUALITY:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_DETECTEDTRAFFICSIGN:
   case cmb_vehiclesensorfi_tclToken::EN_S32_WS:
   case cmb_vehiclesensorfi_tclToken::EN_U32_WS:
   case cmb_vehiclesensorfi_tclToken::EN_U16_W:
   case cmb_vehiclesensorfi_tclToken::EN_S32_MILLIVOLT:
   case cmb_vehiclesensorfi_tclToken::EN_S32_MILLIAMPERE:
   case cmb_vehiclesensorfi_tclToken::EN_U16_MIN:
   case cmb_vehiclesensorfi_tclToken::EN_E8_EOPERATIONMODE:
   case cmb_vehiclesensorfi_tclToken::EN_B8_COUPLINGMODE:
   case cmb_vehiclesensorfi_tclToken::EN_ENERGYCONSUMPTION:
   case cmb_vehiclesensorfi_tclToken::EN_POWERDEMANDATSPEED:
   case cmb_vehiclesensorfi_tclToken::EN_ELECTRICALMACHINE:
   case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_K0STATUS:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_VOLTAGEPARAMS:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_CURRENTPARAMS:
   case cmb_vehiclesensorfi_tclToken::EN_B16_VESE_ENVIRONMENT:
   case cmb_vehiclesensorfi_tclToken::EN_VESE_IPPCPLUSDATA:
   case cmb_vehiclesensorfi_tclToken::EN_U8:   
   case cmb_vehiclesensorfi_tclToken::EN_S8:   
   case cmb_vehiclesensorfi_tclToken::EN_U16:   
   case cmb_vehiclesensorfi_tclToken::EN_S16:   
   case cmb_vehiclesensorfi_tclToken::EN_U24:   
   case cmb_vehiclesensorfi_tclToken::EN_S24:   
   case cmb_vehiclesensorfi_tclToken::EN_U32:   
   case cmb_vehiclesensorfi_tclToken::EN_S32:   
   case cmb_vehiclesensorfi_tclToken::EN_U64:   
   case cmb_vehiclesensorfi_tclToken::EN_S64:   
   case cmb_vehiclesensorfi_tclToken::EN_F32:   
   case cmb_vehiclesensorfi_tclToken::EN_F64:   
   case cmb_vehiclesensorfi_tclToken::EN_BOOL:   
   case cmb_vehiclesensorfi_tclToken::EN_STRING:   
   case cmb_vehiclesensorfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(enMsgToken,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool cmb_vehiclesensorfi_tclDescription::bDoIt(cmb_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool cmb_vehiclesensorfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      cmb_vehiclesensorfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      cmb_vehiclesensorfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      cmb_vehiclesensorfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(cmb_vehiclesensorfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == cmb_vehiclesensorfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_LIST: 
      {
         cmb_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            cmb_vehiclesensorfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            cmb_vehiclesensorfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U8: 
      {
         cmb_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U16: 
      {
         cmb_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U24: 
      {
         cmb_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U32: 
      {
         cmb_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U64: 
      {
         cmb_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S8: 
      {
         cmb_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16: 
      {
         cmb_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S24: 
      {
         cmb_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32: 
      {
         cmb_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S64: 
      {
         cmb_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_F32: 
      {
         cmb_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_F64: 
      {
         cmb_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_BOOL: 
      {
         cmb_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_STRING: 
      {
         cmb_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         cmb_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SLIPSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SPEEDSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_RAINUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_RAINRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_RAINGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_RAINSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_LIGHTSSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DOORSSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCEUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCERELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCEGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPERFORMANCESTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKEUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKERELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKEGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_BRAKESTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_GEARBOXSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_IGNITIONSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLEUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLERELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLEGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_STEERINGWHEELANGLESTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_CRUISECONTROLSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_HYBRIDOPERATIONSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLEDYNAMICSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_STATICVEHICLEPARAMETERSSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_KEYSTATUSSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_CLIMATECONTROLSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_WINDOWSSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENVIRONMENTSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_WHEELSSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_VEHICLELOADSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ENGINEPARAMETERSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DEFROSTERSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_LDWUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_LDWRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_LDWGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_LDWSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_LANEDETECTIONSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDOBJECTSSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_DETECTEDTRAFFICSIGNSSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_SEATSSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINEUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINERELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINEGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_ELECTRICALMACHINESTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_BATTERYSTATUSSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_AUXILIARYCONSUMERPREDICTIONSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSRELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_PROBLEMMARKERIPPCPLUSSTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATAUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATARELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATAGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSDATASTATUS:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFOUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFORELUPREG:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFOGET:
      case cmb_vehiclesensorfi_tclToken::EN_MSG_IPPCPLUSSPEEDLIMITRELINFOSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case cmb_vehiclesensorfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         cmb_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_RESERVED:
      {
      (tVoid) oCallStack.bGoUp();
      (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND:
      {
         cmb_fi_tcl_s16_PerThousand o_s16_PerThousand;
         if (!bDoIt(o_s16_PerThousand))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_PASCAL:
      {
         cmb_fi_tcl_s32_Pascal o_s32_Pascal;
         if (!bDoIt(o_s32_Pascal))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U8_PERCENT:
      {
         cmb_fi_tcl_u8_Percent o_u8_Percent;
         if (!bDoIt(o_u8_Percent))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER:
      {
         cmb_fi_tcl_s32_Centimeter o_s32_Centimeter;
         if (!bDoIt(o_s32_Centimeter))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16_CENTIDEGREE:
      {
         cmb_fi_tcl_s16_CentiDegree o_s16_CentiDegree;
         if (!bDoIt(o_s16_CentiDegree))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16_KMPERHOUR:
      {
         cmb_fi_tcl_s16_KmPerHour o_s16_KmPerHour;
         if (!bDoIt(o_s16_KmPerHour))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U16_RPM:
      {
         cmb_fi_tcl_u16_RPM o_u16_RPM;
         if (!bDoIt(o_u16_RPM))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSECOND:
      {
         cmb_fi_tcl_s16_CentimeterSecond o_s16_CentimeterSecond;
         if (!bDoIt(o_s16_CentimeterSecond))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16_METER:
      {
         cmb_fi_tcl_s16_Meter o_s16_Meter;
         if (!bDoIt(o_s16_Meter))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_METER:
      {
         cmb_fi_tcl_s32_Meter o_s32_Meter;
         if (!bDoIt(o_s32_Meter))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_YARDS:
      {
         cmb_fi_tcl_s32_Yards o_s32_Yards;
         if (!bDoIt(o_s32_Yards))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_INCH:
      {
         cmb_fi_tcl_s32_Inch o_s32_Inch;
         if (!bDoIt(o_s32_Inch))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_KILOGRAM:
      {
         cmb_fi_tcl_s32_Kilogram o_s32_Kilogram;
         if (!bDoIt(o_s32_Kilogram))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE:
      {
         cmb_fi_tcl_s16_DirectionRelative_CentiDegree o_s16_DirectionRelative_CentiDegree;
         if (!bDoIt(o_s16_DirectionRelative_CentiDegree))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U16_MILLISECOND:
      {
         cmb_fi_tcl_u16_MilliSecond o_u16_MilliSecond;
         if (!bDoIt(o_u16_MilliSecond))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_MILLISECOND:
      {
         cmb_fi_tcl_s32_MilliSecond o_s32_MilliSecond;
         if (!bDoIt(o_s32_MilliSecond))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_LONGITUDE:
      {
         cmb_fi_tcl_s32_Longitude o_s32_Longitude;
         if (!bDoIt(o_s32_Longitude))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_LATITUDE:
      {
         cmb_fi_tcl_s32_Latitude o_s32_Latitude;
         if (!bDoIt(o_s32_Latitude))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_POSITIONWGS84:
      {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_LATITUDE,cmb_vehiclesensorfi_tclSemanticDomain::EN_LATITUDE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_LONGITUDE,cmb_vehiclesensorfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         cmb_fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16_MILESPERHOUR:
      {
         cmb_fi_tcl_s16_MilesPerHour o_s16_MilesPerHour;
         if (!bDoIt(o_s16_MilesPerHour))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_POUND:
      {
         cmb_fi_tcl_s32_Pound o_s32_Pound;
         if (!bDoIt(o_s32_Pound))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16_DECIKELVIN:
      {
         cmb_fi_tcl_s16_DeciKelvin o_s16_DeciKelvin;
         if (!bDoIt(o_s16_DeciKelvin))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16_CENTIDEGREESECOND:
      {
         cmb_fi_tcl_s16_CentiDegreeSecond o_s16_CentiDegreeSecond;
         if (!bDoIt(o_s16_CentiDegreeSecond))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U32_MILLILUX:
      {
         cmb_fi_tcl_u32_MilliLux o_u32_MilliLux;
         if (!bDoIt(o_u32_MilliLux))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U32_MICROLITER:
      {
         cmb_fi_tcl_u32_Microliter o_u32_Microliter;
         if (!bDoIt(o_u32_Microliter))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSQUARESECOND:
      {
         cmb_fi_tcl_s16_CentimeterSquareSecond o_s16_CentimeterSquareSecond;
         if (!bDoIt(o_s16_CentimeterSquareSecond))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16_CURVATUREVALUE:
      {
         cmb_fi_tcl_s16_CurvatureValue o_s16_CurvatureValue;
         if (!bDoIt(o_s16_CurvatureValue))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_CURVATURECHANGE:
      {
         cmb_fi_tcl_s32_CurvatureChange o_s32_CurvatureChange;
         if (!bDoIt(o_s32_CurvatureChange))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY:
      {
         cmb_fi_tcl_e8_BaseTrafficSignCategory o_e8_BaseTrafficSignCategory;
         if (!bDoIt(o_e8_BaseTrafficSignCategory))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_SPEEDSIGN:
      {
         cmb_fi_tcl_e8_SpeedSign o_e8_SpeedSign;
         if (!bDoIt(o_e8_SpeedSign))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E16_WARNINGSIGN:
      {
         cmb_fi_tcl_e16_WarningSign o_e16_WarningSign;
         if (!bDoIt(o_e16_WarningSign))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E16_REGULATORYSIGN:
      {
         cmb_fi_tcl_e16_RegulatorySign o_e16_RegulatorySign;
         if (!bDoIt(o_e16_RegulatorySign))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN:
      {
         cmb_fi_tcl_e16_AdditionalTrafficSign o_e16_AdditionalTrafficSign;
         if (!bDoIt(o_e16_AdditionalTrafficSign))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_TIMEDEPENDENTSTRING:
      {
         cmb_fi_tcl_TimeDependentString o_TimeDependentString;
         if (!bDoIt(o_TimeDependentString))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY:
      {
         cmb_fi_tcl_b8_LaneDependentValidity o_b8_LaneDependentValidity;
         if (!bDoIt(o_b8_LaneDependentValidity))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER:
      {
         cmb_fi_tcl_e8_TrafficSignQuantifier o_e8_TrafficSignQuantifier;
         if (!bDoIt(o_e8_TrafficSignQuantifier))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
   case cmb_vehiclesensorfi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0:
   {
      (tVoid) oPath.bGoUp();
      (tVoid) oCallStack.bGoUp();
      cmb_fi_tcl_e8_TrafficSignQuantifier oDataType;
      oCallStack.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER,cmb_vehiclesensorfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      (tVoid) bDoIt(oDataType);
      (tVoid) oCallStack.bGoUp();
      if ((oDataType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_RESERVED,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_KMPERHOUR,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_MILESPERHOUR,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_STRING,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8_PERCENT,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_TIMEDEPENDENTSTRING,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_METER,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_YARDS,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_MULTILANGUAGESTRING,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_INCH,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_KILOGRAM,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_POUND,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      }
   } break;
      case cmb_vehiclesensorfi_tclToken::EN_ADDITIONALTRAFFICSIGN:
      {
      if (poVisitor->bDoExpand_AdditionalTrafficSign(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN,cmb_vehiclesensorfi_tclSemanticDomain::EN_ADDITIONALSIGN));
      }
      else
      {
         cmb_fi_tcl_AdditionalTrafficSign o_AdditionalTrafficSign;
         if (!bDoIt(o_AdditionalTrafficSign))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AdditionalTrafficSign.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AdditionalTrafficSign.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
   case cmb_vehiclesensorfi_tclToken::EN_TRAFFICSIGNELEMENTUNION0:
   {
      (tVoid) oPath.bGoUp();
      (tVoid) oCallStack.bGoUp();
      cmb_fi_tcl_e8_BaseTrafficSignCategory oDataType;
      oCallStack.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY,cmb_vehiclesensorfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      (tVoid) bDoIt(oDataType);
      (tVoid) oCallStack.bGoUp();
      if ((oDataType.enType == cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_RESERVED,cmb_vehiclesensorfi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E8_SPEEDSIGN:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_SPEEDSIGN,cmb_vehiclesensorfi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_WARNINGSIGN:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E16_WARNINGSIGN,cmb_vehiclesensorfi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E16_REGULATORYSIGN,cmb_vehiclesensorfi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      }
   } break;
   case cmb_vehiclesensorfi_tclToken::EN_TRAFFICSIGNELEMENTUNION1:
   {
      (tVoid) oPath.bGoUp();
      (tVoid) oCallStack.bGoUp();
      cmb_fi_tcl_e8_TrafficSignQuantifier oDataType;
      oCallStack.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER,cmb_vehiclesensorfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      (tVoid) bDoIt(oDataType);
      (tVoid) oCallStack.bGoUp();
      if ((oDataType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_RESERVED,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_KMPERHOUR,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_MILESPERHOUR,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_STRING,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8_PERCENT,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_TIMEDEPENDENTSTRING,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_METER,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_YARDS,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_MULTILANGUAGESTRING,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_INCH,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_KILOGRAM,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_POUND,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      }
   } break;
      case cmb_vehiclesensorfi_tclToken::EN_TRAFFICSIGNELEMENT:
      {
      if (poVisitor->bDoExpand_TrafficSignElement(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_ADDITIONALTRAFFICSIGN,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_ADDITIONALSIGNLIST));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_TRAFFICSIGNELEMENTUNION1,cmb_vehiclesensorfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_TRAFFICSIGNELEMENTUNION0,cmb_vehiclesensorfi_tclSemanticDomain::EN_BASESIGNUNION));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_BOOL,cmb_vehiclesensorfi_tclSemanticDomain::EN_VIRTUALTRAFFICSIGN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_BOOL,cmb_vehiclesensorfi_tclSemanticDomain::EN_DYNAMICTRAFFICSIGN));
      }
      else
      {
         cmb_fi_tcl_TrafficSignElement o_TrafficSignElement;
         if (!bDoIt(o_TrafficSignElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_WHEELSLIP:
      {
      if (poVisitor->bDoExpand_VeSe_WheelSlip(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_SLIP));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_POSONAXLE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_AXLE));
      }
      else
      {
         cmb_fi_tcl_VeSe_WheelSlip o_VeSe_WheelSlip;
         if (!bDoIt(o_VeSe_WheelSlip))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_WheelSlip.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_WheelSlip.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_WHEELBRAKEPRESSURE:
      {
      if (poVisitor->bDoExpand_VeSe_WheelBrakePressure(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_PASCAL,cmb_vehiclesensorfi_tclSemanticDomain::EN_BRAKEPRESSURE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_POSONAXLE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_AXLE));
      }
      else
      {
         cmb_fi_tcl_VeSe_WheelBrakePressure o_VeSe_WheelBrakePressure;
         if (!bDoIt(o_VeSe_WheelBrakePressure))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_WheelBrakePressure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_WheelBrakePressure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_WHEELAIRPRESSURE:
      {
      if (poVisitor->bDoExpand_VeSe_WheelAirPressure(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_PASCAL,cmb_vehiclesensorfi_tclSemanticDomain::EN_AIRPRESSURE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_POSONAXLE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_AXLE));
      }
      else
      {
         cmb_fi_tcl_VeSe_WheelAirPressure o_VeSe_WheelAirPressure;
         if (!bDoIt(o_VeSe_WheelAirPressure))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_WheelAirPressure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_WheelAirPressure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION:
      {
         cmb_fi_tcl_e8_VeSe_Activation o_e8_VeSe_Activation;
         if (!bDoIt(o_e8_VeSe_Activation))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_DOORTYPE:
      {
         cmb_fi_tcl_e8_VeSe_DoorType o_e8_VeSe_DoorType;
         if (!bDoIt(o_e8_VeSe_DoorType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_WINDOWTYPE:
      {
         cmb_fi_tcl_e8_VeSe_WindowType o_e8_VeSe_WindowType;
         if (!bDoIt(o_e8_VeSe_WindowType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_LINECOLOR:
      {
         cmb_fi_tcl_e8_VeSe_LineColor o_e8_VeSe_LineColor;
         if (!bDoIt(o_e8_VeSe_LineColor))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_DOORSTATUS:
      {
      if (poVisitor->bDoExpand_VeSe_DoorStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_DOORTYPE,cmb_vehiclesensorfi_tclSemanticDomain::EN_DOORTYPE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_CLOSED));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_YPOSITION));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_XPOSITION));
      }
      else
      {
         cmb_fi_tcl_VeSe_DoorStatus o_VeSe_DoorStatus;
         if (!bDoIt(o_VeSe_DoorStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_DoorStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_DoorStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_WINDOWSTATUS:
      {
      if (poVisitor->bDoExpand_VeSe_WindowStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_WINDOWTYPE,cmb_vehiclesensorfi_tclSemanticDomain::EN_WINDOWTYPE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8_PERCENT,cmb_vehiclesensorfi_tclSemanticDomain::EN_OPENINGLEVEL));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_YPOSITION));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_XPOSITION));
      }
      else
      {
         cmb_fi_tcl_VeSe_WindowStatus o_VeSe_WindowStatus;
         if (!bDoIt(o_VeSe_WindowStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_WindowStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_WindowStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_SEATOCCUPATION:
      {
         cmb_fi_tcl_e8_VeSe_SeatOccupation o_e8_VeSe_SeatOccupation;
         if (!bDoIt(o_e8_VeSe_SeatOccupation))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_DIRECTIONINDICATOR:
      {
         cmb_fi_tcl_e8_VeSe_DirectionIndicator o_e8_VeSe_DirectionIndicator;
         if (!bDoIt(o_e8_VeSe_DirectionIndicator))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_GEARNUM:
      {
         cmb_fi_tcl_e8_VeSe_GearNum o_e8_VeSe_GearNum;
         if (!bDoIt(o_e8_VeSe_GearNum))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_B8_VESE_GEARBOXSTATE:
      {
         cmb_fi_tcl_b8_VeSe_GearBoxState o_b8_VeSe_GearBoxState;
         if (!bDoIt(o_b8_VeSe_GearBoxState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_CCTYPE:
      {
         cmb_fi_tcl_e8_VeSe_CCType o_e8_VeSe_CCType;
         if (!bDoIt(o_e8_VeSe_CCType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_CCSTATE:
      {
         cmb_fi_tcl_e8_VeSe_CCState o_e8_VeSe_CCState;
         if (!bDoIt(o_e8_VeSe_CCState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_IGNITION:
      {
         cmb_fi_tcl_e8_VeSe_Ignition o_e8_VeSe_Ignition;
         if (!bDoIt(o_e8_VeSe_Ignition))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_B32_VESE_BRAKECONTROLMODE:
      {
         cmb_fi_tcl_b32_VeSe_BrakeControlMode o_b32_VeSe_BrakeControlMode;
         if (!bDoIt(o_b32_VeSe_BrakeControlMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_B16_VESE_CENTRALLOCKING:
      {
         cmb_fi_tcl_b16_VeSe_CentralLocking o_b16_VeSe_CentralLocking;
         if (!bDoIt(o_b16_VeSe_CentralLocking))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ROTATIONIRREGULARITY:
      {
         cmb_fi_tcl_e8_VeSe_RotationIrregularity o_e8_VeSe_RotationIrregularity;
         if (!bDoIt(o_e8_VeSe_RotationIrregularity))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_OVERRUNFUELSHUTOFF:
      {
         cmb_fi_tcl_e8_VeSe_OverrunFuelShutoff o_e8_VeSe_OverrunFuelShutoff;
         if (!bDoIt(o_e8_VeSe_OverrunFuelShutoff))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_CONVERTERCLUTCH:
      {
         cmb_fi_tcl_e8_VeSe_ConverterClutch o_e8_VeSe_ConverterClutch;
         if (!bDoIt(o_e8_VeSe_ConverterClutch))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_GEARBOXSPORTSWITCH:
      {
         cmb_fi_tcl_e8_VeSe_GearboxSportSwitch o_e8_VeSe_GearboxSportSwitch;
         if (!bDoIt(o_e8_VeSe_GearboxSportSwitch))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_HEADLIGHTS:
      {
         cmb_fi_tcl_e8_VeSe_HeadLights o_e8_VeSe_HeadLights;
         if (!bDoIt(o_e8_VeSe_HeadLights))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_SEATSTATUS:
      {
      if (poVisitor->bDoExpand_VeSe_SeatStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_DECIKELVIN,cmb_vehiclesensorfi_tclSemanticDomain::EN_STRATSEATHEATER));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8_PERCENT,cmb_vehiclesensorfi_tclSemanticDomain::EN_NECKHEATER));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8_PERCENT,cmb_vehiclesensorfi_tclSemanticDomain::EN_SEATHEATER));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_DECIKELVIN,cmb_vehiclesensorfi_tclSemanticDomain::EN_REALTEMPERATURE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8_PERCENT,cmb_vehiclesensorfi_tclSemanticDomain::EN_SEATCLIMATE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_SEATBELTLOCK));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_SEATOCCUPATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_OCCUPATION));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_PLACEINROW));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_ROW));
      }
      else
      {
         cmb_fi_tcl_VeSe_SeatStatus o_VeSe_SeatStatus;
         if (!bDoIt(o_VeSe_SeatStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_SeatStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_SeatStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_VEHICLEDRIVINGCONDITION:
      {
         cmb_fi_tcl_e8_VeSe_VehicleDrivingCondition o_e8_VeSe_VehicleDrivingCondition;
         if (!bDoIt(o_e8_VeSe_VehicleDrivingCondition))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_KEYVALIDITY:
      {
         cmb_fi_tcl_e8_VeSe_KeyValidity o_e8_VeSe_KeyValidity;
         if (!bDoIt(o_e8_VeSe_KeyValidity))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_KEYTYPE:
      {
         cmb_fi_tcl_e8_VeSe_KeyType o_e8_VeSe_KeyType;
         if (!bDoIt(o_e8_VeSe_KeyType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_B16_VESE_KEYLOCATION:
      {
         cmb_fi_tcl_b16_VeSe_KeyLocation o_b16_VeSe_KeyLocation;
         if (!bDoIt(o_b16_VeSe_KeyLocation))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_B16_VESE_ENGINESTATUS:
      {
         cmb_fi_tcl_b16_VeSe_EngineStatus o_b16_VeSe_EngineStatus;
         if (!bDoIt(o_b16_VeSe_EngineStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_REDUCTIONRPM:
      {
         cmb_fi_tcl_e8_VeSe_ReductionRPM o_e8_VeSe_ReductionRPM;
         if (!bDoIt(o_e8_VeSe_ReductionRPM))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_SIDEINDICATOR:
      {
         cmb_fi_tcl_e8_VeSe_SideIndicator o_e8_VeSe_SideIndicator;
         if (!bDoIt(o_e8_VeSe_SideIndicator))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_LINEINFO:
      {
      if (poVisitor->bDoExpand_VeSe_LineInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CURVATURECHANGE,cmb_vehiclesensorfi_tclSemanticDomain::EN_HORCURVATURECHANGE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CURVATUREVALUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_HORCURVATURE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CENTIDEGREE,cmb_vehiclesensorfi_tclSemanticDomain::EN_ANGLETOBEGIN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_LATERALDISTANCE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_LINECOLOR,cmb_vehiclesensorfi_tclSemanticDomain::EN_LINECOLOR));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_PROBABILITY));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_LINEID));
      }
      else
      {
         cmb_fi_tcl_VeSe_LineInfo o_VeSe_LineInfo;
         if (!bDoIt(o_VeSe_LineInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_LineInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_LineInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_OBJECTTYPE:
      {
         cmb_fi_tcl_e8_VeSe_ObjectType o_e8_VeSe_ObjectType;
         if (!bDoIt(o_e8_VeSe_ObjectType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE:
      {
         cmb_fi_tcl_s16_VeSe_Torque o_s16_VeSe_Torque;
         if (!bDoIt(o_s16_VeSe_Torque))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_DETECTEDOBJECT:
      {
      if (poVisitor->bDoExpand_VeSe_DetectedObject(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_DEVIATIONWIDTH));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_DEVIATIONLATERALOFFSET));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_DEVIATIONLONGITUDINALDISTANCE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_OBJECTWIDTH));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_LATERALOFFSET));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_LONGITUDINALDISTANCE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_EXISTPROBABILITY));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_ACTIVATION,cmb_vehiclesensorfi_tclSemanticDomain::EN_OBJECTMEASURED));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_VESE_OBJECTTYPE,cmb_vehiclesensorfi_tclSemanticDomain::EN_OBJECTTYPE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_OBJECTID));
      }
      else
      {
         cmb_fi_tcl_VeSe_DetectedObject o_VeSe_DetectedObject;
         if (!bDoIt(o_VeSe_DetectedObject))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_DetectedObject.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_DetectedObject.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_TSCLASSIFICATIONQUALITY:
      {
      if (poVisitor->bDoExpand_VeSe_TSClassificationQuality(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8_PERCENT,cmb_vehiclesensorfi_tclSemanticDomain::EN_TSQUANTIFIERQUALITY));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8_PERCENT,cmb_vehiclesensorfi_tclSemanticDomain::EN_TSQUALITY));
      }
      else
      {
         cmb_fi_tcl_VeSe_TSClassificationQuality o_VeSe_TSClassificationQuality;
         if (!bDoIt(o_VeSe_TSClassificationQuality))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_TSClassificationQuality.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_TSClassificationQuality.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_TSQUALITY:
      {
      if (poVisitor->bDoExpand_VeSe_TSQuality(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_TSCLASSIFICATIONQUALITY,cmb_vehiclesensorfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_LIST,cmb_vehiclesensorfi_tclSemanticDomain::EN_ADDITIONALTSQUALITYLIST));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_TSCLASSIFICATIONQUALITY,cmb_vehiclesensorfi_tclSemanticDomain::EN_TSQUALITY));
      }
      else
      {
         cmb_fi_tcl_VeSe_TSQuality o_VeSe_TSQuality;
         if (!bDoIt(o_VeSe_TSQuality))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_TSQuality.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_TSQuality.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_DETECTEDTRAFFICSIGN:
      {
      if (poVisitor->bDoExpand_VeSe_DetectedTrafficSign(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_VESE_TSQUALITY,cmb_vehiclesensorfi_tclSemanticDomain::EN_TSQUALITY));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_TSHEIGHT));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_TSLATERALOFFSET));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_CENTIMETER,cmb_vehiclesensorfi_tclSemanticDomain::EN_TSLONGITUDINALDISTANCE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_TRAFFICSIGNELEMENT,cmb_vehiclesensorfi_tclSemanticDomain::EN_TRAFFICSIGN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_IDOFTRAFFICSIGNABOVE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U8,cmb_vehiclesensorfi_tclSemanticDomain::EN_TRAFFICSIGNID));
      }
      else
      {
         cmb_fi_tcl_VeSe_DetectedTrafficSign o_VeSe_DetectedTrafficSign;
         if (!bDoIt(o_VeSe_DetectedTrafficSign))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_DetectedTrafficSign.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_DetectedTrafficSign.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_WS:
      {
         cmb_fi_tcl_s32_Ws o_s32_Ws;
         if (!bDoIt(o_s32_Ws))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U32_WS:
      {
         cmb_fi_tcl_u32_Ws o_u32_Ws;
         if (!bDoIt(o_u32_Ws))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U16_W:
      {
         cmb_fi_tcl_u16_W o_u16_W;
         if (!bDoIt(o_u16_W))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_MILLIVOLT:
      {
         cmb_fi_tcl_s32_MilliVolt o_s32_MilliVolt;
         if (!bDoIt(o_s32_MilliVolt))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_S32_MILLIAMPERE:
      {
         cmb_fi_tcl_s32_MilliAmpere o_s32_MilliAmpere;
         if (!bDoIt(o_s32_MilliAmpere))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_U16_MIN:
      {
         cmb_fi_tcl_u16_min o_u16_min;
         if (!bDoIt(o_u16_min))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_EOPERATIONMODE:
      {
         cmb_fi_tcl_e8_EOperationMode o_e8_EOperationMode;
         if (!bDoIt(o_e8_EOperationMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_B8_COUPLINGMODE:
      {
         cmb_fi_tcl_b8_CouplingMode o_b8_CouplingMode;
         if (!bDoIt(o_b8_CouplingMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_ENERGYCONSUMPTION:
      {
      if (poVisitor->bDoExpand_EnergyConsumption(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U16_MIN,cmb_vehiclesensorfi_tclSemanticDomain::EN_DURATION));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U16_W,cmb_vehiclesensorfi_tclSemanticDomain::EN_POWERDEMAND));
      }
      else
      {
         cmb_fi_tcl_EnergyConsumption o_EnergyConsumption;
         if (!bDoIt(o_EnergyConsumption))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EnergyConsumption.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EnergyConsumption.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_POWERDEMANDATSPEED:
      {
      if (poVisitor->bDoExpand_PowerDemandAtSpeed(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U16_W,cmb_vehiclesensorfi_tclSemanticDomain::EN_POWERDEMAND));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_KMPERHOUR,cmb_vehiclesensorfi_tclSemanticDomain::EN_VALIDVEHICLESPEED));
      }
      else
      {
         cmb_fi_tcl_PowerDemandAtSpeed o_PowerDemandAtSpeed;
         if (!bDoIt(o_PowerDemandAtSpeed))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PowerDemandAtSpeed.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PowerDemandAtSpeed.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_ELECTRICALMACHINE:
      {
      if (poVisitor->bDoExpand_ElectricalMachine(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_B8_COUPLINGMODE,cmb_vehiclesensorfi_tclSemanticDomain::EN_COUPLINGMODE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_E8_EOPERATIONMODE,cmb_vehiclesensorfi_tclSemanticDomain::EN_OPERATIONMODE));
         if (9 <= u16MajorVersion)
         {
            (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MINALLOWEDENGINETORQUENEXT10SEC));
         }
         if (9 <= u16MajorVersion)
         {
            (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MAXALLOWEDENGINETORQUENEXT10SEC));
         }
         if (9 <= u16MajorVersion)
         {
            (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MINALLOWEDENGINETORQUENEXT2SEC));
         }
         if (9 <= u16MajorVersion)
         {
            (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MAXALLOWEDENGINETORQUENEXT2SEC));
         }
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_VESE_TORQUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_ENGINETORQUE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U16_RPM,cmb_vehiclesensorfi_tclSemanticDomain::EN_ENGINESPEED));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_WS,cmb_vehiclesensorfi_tclSemanticDomain::EN_TOTALENERGYCONSUMPTION));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_WS,cmb_vehiclesensorfi_tclSemanticDomain::EN_ENERGYCONSUMPTION));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_TIMESTAMP));
      }
      else
      {
         cmb_fi_tcl_ElectricalMachine o_ElectricalMachine;
         if (!bDoIt(o_ElectricalMachine))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ElectricalMachine.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ElectricalMachine.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_E8_VESE_K0STATUS:
      {
         cmb_fi_tcl_e8_VeSe_K0Status o_e8_VeSe_K0Status;
         if (!bDoIt(o_e8_VeSe_K0Status))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_VOLTAGEPARAMS:
      {
      if (poVisitor->bDoExpand_VeSe_VoltageParams(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_MILLIVOLT,cmb_vehiclesensorfi_tclSemanticDomain::EN_MINALLOWEDDISCHARGINGVOLTAGEFOR10SEC));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_MILLIVOLT,cmb_vehiclesensorfi_tclSemanticDomain::EN_MINALLOWEDCHARGINGVOLTAGEFOR10SEC));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_MILLIVOLT,cmb_vehiclesensorfi_tclSemanticDomain::EN_CURRENTVOLTAGE));
      }
      else
      {
         cmb_fi_tcl_VeSe_VoltageParams o_VeSe_VoltageParams;
         if (!bDoIt(o_VeSe_VoltageParams))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_VoltageParams.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_VoltageParams.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_CURRENTPARAMS:
      {
      if (poVisitor->bDoExpand_VeSe_CurrentParams(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_MILLIAMPERE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MAXALLOWEDDISCHARGINGCURRENTFOR10SEC));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_MILLIAMPERE,cmb_vehiclesensorfi_tclSemanticDomain::EN_MAXALLOWEDCHARGINGCURRENTFOR10SEC));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S32_MILLIAMPERE,cmb_vehiclesensorfi_tclSemanticDomain::EN_CURRENTCURRENT));
      }
      else
      {
         cmb_fi_tcl_VeSe_CurrentParams o_VeSe_CurrentParams;
         if (!bDoIt(o_VeSe_CurrentParams))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_CurrentParams.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_CurrentParams.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_B16_VESE_ENVIRONMENT:
      {
         cmb_fi_tcl_b16_VeSe_Environment o_b16_VeSe_Environment;
         if (!bDoIt(o_b16_VeSe_Environment))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_VESE_IPPCPLUSDATA:
      {
      if (poVisitor->bDoExpand_VeSe_IPPCPlusData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_END_OF_STRUCT,cmb_vehiclesensorfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_B16_VESE_ENVIRONMENT,cmb_vehiclesensorfi_tclSemanticDomain::EN_ENVIRONMENT));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CENTIMETERSECOND,cmb_vehiclesensorfi_tclSemanticDomain::EN_VEHICLESPEED));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_DRIVENCURVATURECONFIDENCE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_CURVATUREVALUE,cmb_vehiclesensorfi_tclSemanticDomain::EN_DRIVENCURVATURE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_SLOPECONFIDENCE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_S16_PERTHOUSAND,cmb_vehiclesensorfi_tclSemanticDomain::EN_SLOPE));
         (tVoid) oPath.bGoDown(cmb_vehiclesensorfi_tclKnot(cmb_vehiclesensorfi_tclToken::EN_U32,cmb_vehiclesensorfi_tclSemanticDomain::EN_TIMESTAMP));
      }
      else
      {
         cmb_fi_tcl_VeSe_IPPCPlusData o_VeSe_IPPCPlusData;
         if (!bDoIt(o_VeSe_IPPCPlusData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_IPPCPlusData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VeSe_IPPCPlusData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_vehiclesensorfi_tclToken::EN_UNKNOWN:
      case cmb_vehiclesensorfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

