/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef CMB_SENSORFITYPES_HEADER
#define CMB_SENSORFITYPES_HEADER


class cmb_sensorfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for CMB_Sensor_FI message types

fi_tclMessageBase* cmb_sensorfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class cmb_sensorfi_tclMsgBaseMessage : public cmb_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   cmb_sensorfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart& operator=(const cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart& coRef);
   cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart(const cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 UseTyreValue;
   virtual ~cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodResult();

   virtual ~cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodResult();

   inline tBool operator==(const cmb_sensorfi_tclMsgCalcOdometerCalibrationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodStart();

   virtual ~cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodStart();

   inline tBool operator==(const cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult& operator=(const cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult& coRef);
   cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult(const cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSuccess;
   virtual ~cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgSetDefaultGyroParameterForGyroTypeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTestmodeMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTestmodeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsTestmodeMethodStart& operator=(const cmb_sensorfi_tclMsgGpsTestmodeMethodStart& coRef);
   cmb_sensorfi_tclMsgGpsTestmodeMethodStart(const cmb_sensorfi_tclMsgGpsTestmodeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_SetData SetData;
   virtual ~cmb_sensorfi_tclMsgGpsTestmodeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsTestmodeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTestmodeMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTestmodeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsTestmodeMethodResult& operator=(const cmb_sensorfi_tclMsgGpsTestmodeMethodResult& coRef);
   cmb_sensorfi_tclMsgGpsTestmodeMethodResult(const cmb_sensorfi_tclMsgGpsTestmodeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_TestModeData TestModeData;
   virtual ~cmb_sensorfi_tclMsgGpsTestmodeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsTestmodeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroSelftestMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroSelftestMethodStart();

   virtual ~cmb_sensorfi_tclMsgGyroSelftestMethodStart();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroSelftestMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroSelftestMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroSelftestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroSelftestMethodResult& operator=(const cmb_sensorfi_tclMsgGyroSelftestMethodResult& coRef);
   cmb_sensorfi_tclMsgGyroSelftestMethodResult(const cmb_sensorfi_tclMsgGyroSelftestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSuccess;
   virtual ~cmb_sensorfi_tclMsgGyroSelftestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroSelftestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgSavePersistentMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgSavePersistentMethodStart();

   virtual ~cmb_sensorfi_tclMsgSavePersistentMethodStart();

   inline tBool operator==(const cmb_sensorfi_tclMsgSavePersistentMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgSavePersistentMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgSavePersistentMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgSavePersistentMethodResult& operator=(const cmb_sensorfi_tclMsgSavePersistentMethodResult& coRef);
   cmb_sensorfi_tclMsgSavePersistentMethodResult(const cmb_sensorfi_tclMsgSavePersistentMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSuccess;
   virtual ~cmb_sensorfi_tclMsgSavePersistentMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgSavePersistentMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsSetHintsMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsSetHintsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsSetHintsMethodStart& operator=(const cmb_sensorfi_tclMsgGpsSetHintsMethodStart& coRef);
   cmb_sensorfi_tclMsgGpsSetHintsMethodStart(const cmb_sensorfi_tclMsgGpsSetHintsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_GpsHints Hint;
   virtual ~cmb_sensorfi_tclMsgGpsSetHintsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsSetHintsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsSetHintsMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsSetHintsMethodResult();

   virtual ~cmb_sensorfi_tclMsgGpsSetHintsMethodResult();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsSetHintsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart& operator=(const cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart& coRef);
   cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart(const cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_GpsExtHints Hint;
   virtual ~cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsSetExtHintsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsSetExtHintsMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsSetExtHintsMethodResult();

   virtual ~cmb_sensorfi_tclMsgGpsSetExtHintsMethodResult();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsSetExtHintsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart& operator=(const cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart& coRef);
   cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart(const cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_e8_GpsFrontEndDataPattern DataPattern;
   virtual ~cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsFrontEndTestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult& operator=(const cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult& coRef);
   cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult(const cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 PinToggle;
   virtual ~cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsFrontEndTestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgUpdateDiagLogMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgUpdateDiagLogMethodStart();

   virtual ~cmb_sensorfi_tclMsgUpdateDiagLogMethodStart();

   inline tBool operator==(const cmb_sensorfi_tclMsgUpdateDiagLogMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgUpdateDiagLogMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgUpdateDiagLogMethodResult();

   virtual ~cmb_sensorfi_tclMsgUpdateDiagLogMethodResult();

   inline tBool operator==(const cmb_sensorfi_tclMsgUpdateDiagLogMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart& operator=(const cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart& coRef);
   cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart(const cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_GpsExtTestmodeStart Start;
   virtual ~cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsExtTestmodeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult& operator=(const cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult& coRef);
   cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult(const cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_GpsExtTestmodeResult Result;
   virtual ~cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsExtTestmodeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgFactorySettingsMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgFactorySettingsMethodStart();

   virtual ~cmb_sensorfi_tclMsgFactorySettingsMethodStart();

   inline tBool operator==(const cmb_sensorfi_tclMsgFactorySettingsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgFactorySettingsMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgFactorySettingsMethodResult();

   virtual ~cmb_sensorfi_tclMsgFactorySettingsMethodResult();

   inline tBool operator==(const cmb_sensorfi_tclMsgFactorySettingsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart& operator=(const cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart& coRef);
   cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart(const cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Deactivate;
   virtual ~cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodResult();

   virtual ~cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodResult();

   inline tBool operator==(const cmb_sensorfi_tclMsgDeactivateGpsEncoderMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart& operator=(const cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart& coRef);
   cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart(const cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_e8_DefSetGroups DefSetGroup;
   cmb_fi_tcl_e8_DefSetMode DefSetMode;
   virtual ~cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgUpdateFactorySettingsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult& operator=(const cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult& coRef);
   cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult(const cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_e8_DefSetGroups DefSetGroup;
   cmb_fi_tcl_e8_DefSetMode DefSetMode;
   tBool DefSetStateSuccessful;
   virtual ~cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgUpdateFactorySettingsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodStart();

   virtual ~cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodStart();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult& operator=(const cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult& coRef);
   cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult(const cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_3dGyroHwInfo Gyro3dHwInfo;
   virtual ~cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyro3dGetHwInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodStart : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodStart();

   virtual ~cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodStart();

   inline tBool operator==(const cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult& operator=(const cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult& coRef);
   cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult(const cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_3dAccHwInfo Acc3dHwInfo;
   virtual ~cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgAcc3dGetHwInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerData_InitGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerData_InitGet();

   virtual ~cmb_sensorfi_tclMsgOdometerData_InitGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgOdometerData_InitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerData_InitStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerData_InitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgOdometerData_InitStatus& operator=(const cmb_sensorfi_tclMsgOdometerData_InitStatus& coRef);
   cmb_sensorfi_tclMsgOdometerData_InitStatus(const cmb_sensorfi_tclMsgOdometerData_InitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_OdometerData OdometerData_Init;
   tU32 DistanceCalibrationValue;
   tU32 TyreExpansionValue;
   tU16 OdometerMsg_SendPeriod;
   virtual ~cmb_sensorfi_tclMsgOdometerData_InitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgOdometerData_InitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerData_UpdateGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerData_UpdateGet();

   virtual ~cmb_sensorfi_tclMsgOdometerData_UpdateGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgOdometerData_UpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerData_UpdateUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerData_UpdateUpReg();

   virtual ~cmb_sensorfi_tclMsgOdometerData_UpdateUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgOdometerData_UpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerData_UpdateRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerData_UpdateRelUpReg();

   virtual ~cmb_sensorfi_tclMsgOdometerData_UpdateRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgOdometerData_UpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerData_UpdateStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerData_UpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgOdometerData_UpdateStatus& operator=(const cmb_sensorfi_tclMsgOdometerData_UpdateStatus& coRef);
   cmb_sensorfi_tclMsgOdometerData_UpdateStatus(const cmb_sensorfi_tclMsgOdometerData_UpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_OdometerData, std::allocator<cmb_fi_tcl_OdometerData> > OdometerData;
   tBool FirstOdomValueIsInitial;
   virtual ~cmb_sensorfi_tclMsgOdometerData_UpdateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgOdometerData_UpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroData_InitGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroData_InitGet();

   virtual ~cmb_sensorfi_tclMsgGyroData_InitGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroData_InitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroData_InitStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroData_InitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroData_InitStatus& operator=(const cmb_sensorfi_tclMsgGyroData_InitStatus& coRef);
   cmb_sensorfi_tclMsgGyroData_InitStatus(const cmb_sensorfi_tclMsgGyroData_InitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_GyroData GyroData_Init;
   tU32 GyroOffset;
   tU16 GyroScalefactor;
   tU16 GyroMsg_SendPeriod;
   virtual ~cmb_sensorfi_tclMsgGyroData_InitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroData_InitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroData_UpdateGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroData_UpdateGet();

   virtual ~cmb_sensorfi_tclMsgGyroData_UpdateGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroData_UpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroData_UpdateUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroData_UpdateUpReg();

   virtual ~cmb_sensorfi_tclMsgGyroData_UpdateUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroData_UpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroData_UpdateRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroData_UpdateRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGyroData_UpdateRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroData_UpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroData_UpdateStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroData_UpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroData_UpdateStatus& operator=(const cmb_sensorfi_tclMsgGyroData_UpdateStatus& coRef);
   cmb_sensorfi_tclMsgGyroData_UpdateStatus(const cmb_sensorfi_tclMsgGyroData_UpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_GyroData, std::allocator<cmb_fi_tcl_GyroData> > GyroData;
   virtual ~cmb_sensorfi_tclMsgGyroData_UpdateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroData_UpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsDataGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsDataGet();

   virtual ~cmb_sensorfi_tclMsgGpsDataGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsDataUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsDataUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsDataUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsDataRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsDataRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsDataRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsDataStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsDataStatus& operator=(const cmb_sensorfi_tclMsgGpsDataStatus& coRef);
   cmb_sensorfi_tclMsgGpsDataStatus(const cmb_sensorfi_tclMsgGpsDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_GpsBigdata GpsData;
   virtual ~cmb_sensorfi_tclMsgGpsDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsData_ValidContentGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsData_ValidContentGet();

   virtual ~cmb_sensorfi_tclMsgGpsData_ValidContentGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsData_ValidContentGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsData_ValidContentStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsData_ValidContentStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsData_ValidContentStatus& operator=(const cmb_sensorfi_tclMsgGpsData_ValidContentStatus& coRef);
   cmb_sensorfi_tclMsgGpsData_ValidContentStatus(const cmb_sensorfi_tclMsgGpsData_ValidContentStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_GpsBigdata GpsDataValid;
   virtual ~cmb_sensorfi_tclMsgGpsData_ValidContentStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsData_ValidContentStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreWidthGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreWidthGet();

   virtual ~cmb_sensorfi_tclMsgTyreWidthGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgTyreWidthGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreWidthSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreWidthSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgTyreWidthSet& operator=(const cmb_sensorfi_tclMsgTyreWidthSet& coRef);
   cmb_sensorfi_tclMsgTyreWidthSet(const cmb_sensorfi_tclMsgTyreWidthSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 TyreWidth;
   virtual ~cmb_sensorfi_tclMsgTyreWidthSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgTyreWidthSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreWidthStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreWidthStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgTyreWidthStatus& operator=(const cmb_sensorfi_tclMsgTyreWidthStatus& coRef);
   cmb_sensorfi_tclMsgTyreWidthStatus(const cmb_sensorfi_tclMsgTyreWidthStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 TyreWidth;
   virtual ~cmb_sensorfi_tclMsgTyreWidthStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgTyreWidthStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreHeightWidthRatioGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreHeightWidthRatioGet();

   virtual ~cmb_sensorfi_tclMsgTyreHeightWidthRatioGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgTyreHeightWidthRatioGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreHeightWidthRatioSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreHeightWidthRatioSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgTyreHeightWidthRatioSet& operator=(const cmb_sensorfi_tclMsgTyreHeightWidthRatioSet& coRef);
   cmb_sensorfi_tclMsgTyreHeightWidthRatioSet(const cmb_sensorfi_tclMsgTyreHeightWidthRatioSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TyreHeightWidthRatio;
   virtual ~cmb_sensorfi_tclMsgTyreHeightWidthRatioSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgTyreHeightWidthRatioSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus& operator=(const cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus& coRef);
   cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus(const cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TyreHeightWidthRatio;
   virtual ~cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgTyreHeightWidthRatioStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgRimDiameterGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgRimDiameterGet();

   virtual ~cmb_sensorfi_tclMsgRimDiameterGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgRimDiameterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgRimDiameterSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgRimDiameterSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgRimDiameterSet& operator=(const cmb_sensorfi_tclMsgRimDiameterSet& coRef);
   cmb_sensorfi_tclMsgRimDiameterSet(const cmb_sensorfi_tclMsgRimDiameterSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 RimDiameter;
   virtual ~cmb_sensorfi_tclMsgRimDiameterSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgRimDiameterSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgRimDiameterStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgRimDiameterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgRimDiameterStatus& operator=(const cmb_sensorfi_tclMsgRimDiameterStatus& coRef);
   cmb_sensorfi_tclMsgRimDiameterStatus(const cmb_sensorfi_tclMsgRimDiameterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 RimDiameter;
   virtual ~cmb_sensorfi_tclMsgRimDiameterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgRimDiameterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreConditionGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreConditionGet();

   virtual ~cmb_sensorfi_tclMsgTyreConditionGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgTyreConditionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreConditionSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreConditionSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgTyreConditionSet& operator=(const cmb_sensorfi_tclMsgTyreConditionSet& coRef);
   cmb_sensorfi_tclMsgTyreConditionSet(const cmb_sensorfi_tclMsgTyreConditionSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TyreCondition;
   virtual ~cmb_sensorfi_tclMsgTyreConditionSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgTyreConditionSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreConditionStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreConditionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgTyreConditionStatus& operator=(const cmb_sensorfi_tclMsgTyreConditionStatus& coRef);
   cmb_sensorfi_tclMsgTyreConditionStatus(const cmb_sensorfi_tclMsgTyreConditionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TyreCondition;
   virtual ~cmb_sensorfi_tclMsgTyreConditionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgTyreConditionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreCircumferenceGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreCircumferenceGet();

   virtual ~cmb_sensorfi_tclMsgTyreCircumferenceGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgTyreCircumferenceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreCircumferenceSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreCircumferenceSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgTyreCircumferenceSet& operator=(const cmb_sensorfi_tclMsgTyreCircumferenceSet& coRef);
   cmb_sensorfi_tclMsgTyreCircumferenceSet(const cmb_sensorfi_tclMsgTyreCircumferenceSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 TyreCircumference;
   virtual ~cmb_sensorfi_tclMsgTyreCircumferenceSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgTyreCircumferenceSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreCircumferenceStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreCircumferenceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgTyreCircumferenceStatus& operator=(const cmb_sensorfi_tclMsgTyreCircumferenceStatus& coRef);
   cmb_sensorfi_tclMsgTyreCircumferenceStatus(const cmb_sensorfi_tclMsgTyreCircumferenceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 TyreCircumference;
   virtual ~cmb_sensorfi_tclMsgTyreCircumferenceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgTyreCircumferenceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceGet();

   virtual ~cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet& operator=(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet& coRef);
   cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 PulsesPerTyreCircumference;
   virtual ~cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus& operator=(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus& coRef);
   cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 PulsesPerTyreCircumference;
   virtual ~cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgPulsesPerTyreCircumferenceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgDistanceCalibrationValueGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgDistanceCalibrationValueGet();

   virtual ~cmb_sensorfi_tclMsgDistanceCalibrationValueGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgDistanceCalibrationValueGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgDistanceCalibrationValueSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgDistanceCalibrationValueSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgDistanceCalibrationValueSet& operator=(const cmb_sensorfi_tclMsgDistanceCalibrationValueSet& coRef);
   cmb_sensorfi_tclMsgDistanceCalibrationValueSet(const cmb_sensorfi_tclMsgDistanceCalibrationValueSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DistanceCalibrationValue;
   virtual ~cmb_sensorfi_tclMsgDistanceCalibrationValueSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgDistanceCalibrationValueSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgDistanceCalibrationValueUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgDistanceCalibrationValueUpReg();

   virtual ~cmb_sensorfi_tclMsgDistanceCalibrationValueUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgDistanceCalibrationValueUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgDistanceCalibrationValueRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgDistanceCalibrationValueRelUpReg();

   virtual ~cmb_sensorfi_tclMsgDistanceCalibrationValueRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgDistanceCalibrationValueRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgDistanceCalibrationValueStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgDistanceCalibrationValueStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgDistanceCalibrationValueStatus& operator=(const cmb_sensorfi_tclMsgDistanceCalibrationValueStatus& coRef);
   cmb_sensorfi_tclMsgDistanceCalibrationValueStatus(const cmb_sensorfi_tclMsgDistanceCalibrationValueStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DistanceCalibrationValue;
   virtual ~cmb_sensorfi_tclMsgDistanceCalibrationValueStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgDistanceCalibrationValueStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreExpansionValueGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreExpansionValueGet();

   virtual ~cmb_sensorfi_tclMsgTyreExpansionValueGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgTyreExpansionValueGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreExpansionValueSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreExpansionValueSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgTyreExpansionValueSet& operator=(const cmb_sensorfi_tclMsgTyreExpansionValueSet& coRef);
   cmb_sensorfi_tclMsgTyreExpansionValueSet(const cmb_sensorfi_tclMsgTyreExpansionValueSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 TyreExpansionValue;
   tU32 TyreQuadExpansionValue;
   virtual ~cmb_sensorfi_tclMsgTyreExpansionValueSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgTyreExpansionValueSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTyreExpansionValueStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTyreExpansionValueStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgTyreExpansionValueStatus& operator=(const cmb_sensorfi_tclMsgTyreExpansionValueStatus& coRef);
   cmb_sensorfi_tclMsgTyreExpansionValueStatus(const cmb_sensorfi_tclMsgTyreExpansionValueStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 TyreExpansionValue;
   tU32 TyreQuadExpansionValue;
   virtual ~cmb_sensorfi_tclMsgTyreExpansionValueStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgTyreExpansionValueStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroManufacturerGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroManufacturerGet();

   virtual ~cmb_sensorfi_tclMsgGyroManufacturerGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroManufacturerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroManufacturerSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroManufacturerSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroManufacturerSet& operator=(const cmb_sensorfi_tclMsgGyroManufacturerSet& coRef);
   cmb_sensorfi_tclMsgGyroManufacturerSet(const cmb_sensorfi_tclMsgGyroManufacturerSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 GyroManufacturer;
   virtual ~cmb_sensorfi_tclMsgGyroManufacturerSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroManufacturerSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroManufacturerStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroManufacturerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroManufacturerStatus& operator=(const cmb_sensorfi_tclMsgGyroManufacturerStatus& coRef);
   cmb_sensorfi_tclMsgGyroManufacturerStatus(const cmb_sensorfi_tclMsgGyroManufacturerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 GyroManufacturer;
   virtual ~cmb_sensorfi_tclMsgGyroManufacturerStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroManufacturerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroTypeGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroTypeGet();

   virtual ~cmb_sensorfi_tclMsgGyroTypeGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroTypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroTypeSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroTypeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroTypeSet& operator=(const cmb_sensorfi_tclMsgGyroTypeSet& coRef);
   cmb_sensorfi_tclMsgGyroTypeSet(const cmb_sensorfi_tclMsgGyroTypeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 GyroType;
   virtual ~cmb_sensorfi_tclMsgGyroTypeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroTypeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroTypeStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroTypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroTypeStatus& operator=(const cmb_sensorfi_tclMsgGyroTypeStatus& coRef);
   cmb_sensorfi_tclMsgGyroTypeStatus(const cmb_sensorfi_tclMsgGyroTypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 GyroType;
   virtual ~cmb_sensorfi_tclMsgGyroTypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroTypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroOffsetGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroOffsetGet();

   virtual ~cmb_sensorfi_tclMsgGyroOffsetGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroOffsetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroOffsetSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroOffsetSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroOffsetSet& operator=(const cmb_sensorfi_tclMsgGyroOffsetSet& coRef);
   cmb_sensorfi_tclMsgGyroOffsetSet(const cmb_sensorfi_tclMsgGyroOffsetSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 GyroOffset;
   virtual ~cmb_sensorfi_tclMsgGyroOffsetSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroOffsetSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroOffsetUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroOffsetUpReg();

   virtual ~cmb_sensorfi_tclMsgGyroOffsetUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroOffsetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroOffsetRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroOffsetRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGyroOffsetRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroOffsetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroOffsetStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroOffsetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroOffsetStatus& operator=(const cmb_sensorfi_tclMsgGyroOffsetStatus& coRef);
   cmb_sensorfi_tclMsgGyroOffsetStatus(const cmb_sensorfi_tclMsgGyroOffsetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 GyroOffset;
   virtual ~cmb_sensorfi_tclMsgGyroOffsetStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroOffsetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroScalefactorGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroScalefactorGet();

   virtual ~cmb_sensorfi_tclMsgGyroScalefactorGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroScalefactorGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroScalefactorSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroScalefactorSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroScalefactorSet& operator=(const cmb_sensorfi_tclMsgGyroScalefactorSet& coRef);
   cmb_sensorfi_tclMsgGyroScalefactorSet(const cmb_sensorfi_tclMsgGyroScalefactorSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 GyroScalefactor;
   virtual ~cmb_sensorfi_tclMsgGyroScalefactorSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroScalefactorSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroScalefactorUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroScalefactorUpReg();

   virtual ~cmb_sensorfi_tclMsgGyroScalefactorUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroScalefactorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroScalefactorRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroScalefactorRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGyroScalefactorRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroScalefactorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroScalefactorStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroScalefactorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroScalefactorStatus& operator=(const cmb_sensorfi_tclMsgGyroScalefactorStatus& coRef);
   cmb_sensorfi_tclMsgGyroScalefactorStatus(const cmb_sensorfi_tclMsgGyroScalefactorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 GyroScalefactor;
   virtual ~cmb_sensorfi_tclMsgGyroScalefactorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroScalefactorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsCommunicationProtocolGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsCommunicationProtocolGet();

   virtual ~cmb_sensorfi_tclMsgGpsCommunicationProtocolGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsCommunicationProtocolGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsCommunicationProtocolSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsCommunicationProtocolSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsCommunicationProtocolSet& operator=(const cmb_sensorfi_tclMsgGpsCommunicationProtocolSet& coRef);
   cmb_sensorfi_tclMsgGpsCommunicationProtocolSet(const cmb_sensorfi_tclMsgGpsCommunicationProtocolSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_GpsCommunicationProtocol, std::allocator<cmb_fi_tcl_GpsCommunicationProtocol> > GpsCommunicationProtocol;
   virtual ~cmb_sensorfi_tclMsgGpsCommunicationProtocolSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsCommunicationProtocolSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus& operator=(const cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus& coRef);
   cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus(const cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_GpsCommunicationProtocol, std::allocator<cmb_fi_tcl_GpsCommunicationProtocol> > GpsCommunicationProtocol;
   virtual ~cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsCommunicationProtocolStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTemperatureGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTemperatureGet();

   virtual ~cmb_sensorfi_tclMsgGpsTemperatureGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsTemperatureGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTemperatureUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTemperatureUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsTemperatureUpReg& operator=(const cmb_sensorfi_tclMsgGpsTemperatureUpReg& coRef);
   cmb_sensorfi_tclMsgGpsTemperatureUpReg(const cmb_sensorfi_tclMsgGpsTemperatureUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 GpsTemperatureSendPeriod;
   virtual ~cmb_sensorfi_tclMsgGpsTemperatureUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsTemperatureUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTemperatureRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTemperatureRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsTemperatureRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsTemperatureRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTemperatureStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTemperatureStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsTemperatureStatus& operator=(const cmb_sensorfi_tclMsgGpsTemperatureStatus& coRef);
   cmb_sensorfi_tclMsgGpsTemperatureStatus(const cmb_sensorfi_tclMsgGpsTemperatureStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 GpsTemperature;
   virtual ~cmb_sensorfi_tclMsgGpsTemperatureStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsTemperatureStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsFilterModeGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsFilterModeGet();

   virtual ~cmb_sensorfi_tclMsgGpsFilterModeGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsFilterModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsFilterModeSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsFilterModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsFilterModeSet& operator=(const cmb_sensorfi_tclMsgGpsFilterModeSet& coRef);
   cmb_sensorfi_tclMsgGpsFilterModeSet(const cmb_sensorfi_tclMsgGpsFilterModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 GpsFilterMode;
   virtual ~cmb_sensorfi_tclMsgGpsFilterModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsFilterModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsFilterModeStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsFilterModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsFilterModeStatus& operator=(const cmb_sensorfi_tclMsgGpsFilterModeStatus& coRef);
   cmb_sensorfi_tclMsgGpsFilterModeStatus(const cmb_sensorfi_tclMsgGpsFilterModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 GpsFilterMode;
   virtual ~cmb_sensorfi_tclMsgGpsFilterModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsFilterModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgXoCompensationGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgXoCompensationGet();

   virtual ~cmb_sensorfi_tclMsgXoCompensationGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgXoCompensationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgXoCompensationSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgXoCompensationSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgXoCompensationSet& operator=(const cmb_sensorfi_tclMsgXoCompensationSet& coRef);
   cmb_sensorfi_tclMsgXoCompensationSet(const cmb_sensorfi_tclMsgXoCompensationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_XoCompensation XoData;
   virtual ~cmb_sensorfi_tclMsgXoCompensationSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgXoCompensationSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgXoCompensationStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgXoCompensationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgXoCompensationStatus& operator=(const cmb_sensorfi_tclMsgXoCompensationStatus& coRef);
   cmb_sensorfi_tclMsgXoCompensationStatus(const cmb_sensorfi_tclMsgXoCompensationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_XoCompensation XoData;
   virtual ~cmb_sensorfi_tclMsgXoCompensationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgXoCompensationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAntennaCurrentGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAntennaCurrentGet();

   virtual ~cmb_sensorfi_tclMsgAntennaCurrentGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgAntennaCurrentGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAntennaCurrentUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAntennaCurrentUpReg();

   virtual ~cmb_sensorfi_tclMsgAntennaCurrentUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgAntennaCurrentUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAntennaCurrentRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAntennaCurrentRelUpReg();

   virtual ~cmb_sensorfi_tclMsgAntennaCurrentRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgAntennaCurrentRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAntennaCurrentStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAntennaCurrentStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgAntennaCurrentStatus& operator=(const cmb_sensorfi_tclMsgAntennaCurrentStatus& coRef);
   cmb_sensorfi_tclMsgAntennaCurrentStatus(const cmb_sensorfi_tclMsgAntennaCurrentStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 AntennaCurrent;
   virtual ~cmb_sensorfi_tclMsgAntennaCurrentStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgAntennaCurrentStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroADCBitRangeGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroADCBitRangeGet();

   virtual ~cmb_sensorfi_tclMsgGyroADCBitRangeGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroADCBitRangeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroADCBitRangeSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroADCBitRangeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroADCBitRangeSet& operator=(const cmb_sensorfi_tclMsgGyroADCBitRangeSet& coRef);
   cmb_sensorfi_tclMsgGyroADCBitRangeSet(const cmb_sensorfi_tclMsgGyroADCBitRangeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 GyroADCBitMinValue;
   tU32 GyroADCBitMaxValue;
   virtual ~cmb_sensorfi_tclMsgGyroADCBitRangeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroADCBitRangeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroADCBitRangeStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroADCBitRangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroADCBitRangeStatus& operator=(const cmb_sensorfi_tclMsgGyroADCBitRangeStatus& coRef);
   cmb_sensorfi_tclMsgGyroADCBitRangeStatus(const cmb_sensorfi_tclMsgGyroADCBitRangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 GyroADCBitMinValue;
   tU32 GyroADCBitMaxValue;
   virtual ~cmb_sensorfi_tclMsgGyroADCBitRangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroADCBitRangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOsalTimeEventGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOsalTimeEventGet();

   virtual ~cmb_sensorfi_tclMsgOsalTimeEventGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgOsalTimeEventGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOsalTimeEventUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOsalTimeEventUpReg();

   virtual ~cmb_sensorfi_tclMsgOsalTimeEventUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgOsalTimeEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOsalTimeEventRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOsalTimeEventRelUpReg();

   virtual ~cmb_sensorfi_tclMsgOsalTimeEventRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgOsalTimeEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOsalTimeEventStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOsalTimeEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgOsalTimeEventStatus& operator=(const cmb_sensorfi_tclMsgOsalTimeEventStatus& coRef);
   cmb_sensorfi_tclMsgOsalTimeEventStatus(const cmb_sensorfi_tclMsgOsalTimeEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 foo;
   virtual ~cmb_sensorfi_tclMsgOsalTimeEventStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgOsalTimeEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerUsageGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerUsageGet();

   virtual ~cmb_sensorfi_tclMsgOdometerUsageGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgOdometerUsageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerUsageSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerUsageSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgOdometerUsageSet& operator=(const cmb_sensorfi_tclMsgOdometerUsageSet& coRef);
   cmb_sensorfi_tclMsgOdometerUsageSet(const cmb_sensorfi_tclMsgOdometerUsageSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 foo;
   virtual ~cmb_sensorfi_tclMsgOdometerUsageSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgOdometerUsageSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerUsageUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerUsageUpReg();

   virtual ~cmb_sensorfi_tclMsgOdometerUsageUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgOdometerUsageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerUsageRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerUsageRelUpReg();

   virtual ~cmb_sensorfi_tclMsgOdometerUsageRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgOdometerUsageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerUsageStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerUsageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgOdometerUsageStatus& operator=(const cmb_sensorfi_tclMsgOdometerUsageStatus& coRef);
   cmb_sensorfi_tclMsgOdometerUsageStatus(const cmb_sensorfi_tclMsgOdometerUsageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 foo;
   virtual ~cmb_sensorfi_tclMsgOdometerUsageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgOdometerUsageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsExtDataGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsExtDataGet();

   virtual ~cmb_sensorfi_tclMsgGpsExtDataGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsExtDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsExtDataUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsExtDataUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsExtDataUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsExtDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsExtDataRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsExtDataRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsExtDataRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsExtDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsExtDataStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsExtDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsExtDataStatus& operator=(const cmb_sensorfi_tclMsgGpsExtDataStatus& coRef);
   cmb_sensorfi_tclMsgGpsExtDataStatus(const cmb_sensorfi_tclMsgGpsExtDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_GpsExtBigData GpsData;
   virtual ~cmb_sensorfi_tclMsgGpsExtDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsExtDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsFrontEndGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsFrontEndGet();

   virtual ~cmb_sensorfi_tclMsgGpsFrontEndGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsFrontEndGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsFrontEndUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsFrontEndUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsFrontEndUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsFrontEndUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsFrontEndRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsFrontEndRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsFrontEndRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsFrontEndRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsFrontEndStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsFrontEndStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsFrontEndStatus& operator=(const cmb_sensorfi_tclMsgGpsFrontEndStatus& coRef);
   cmb_sensorfi_tclMsgGpsFrontEndStatus(const cmb_sensorfi_tclMsgGpsFrontEndStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_e8_GpsFrontEndStatus FrontEndStatus;
   tU32 PinToggle;
   virtual ~cmb_sensorfi_tclMsgGpsFrontEndStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsFrontEndStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsOscillatorGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsOscillatorGet();

   virtual ~cmb_sensorfi_tclMsgGpsOscillatorGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsOscillatorGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsOscillatorUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsOscillatorUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsOscillatorUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsOscillatorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsOscillatorRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsOscillatorRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsOscillatorRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsOscillatorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsOscillatorStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsOscillatorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsOscillatorStatus& operator=(const cmb_sensorfi_tclMsgGpsOscillatorStatus& coRef);
   cmb_sensorfi_tclMsgGpsOscillatorStatus(const cmb_sensorfi_tclMsgGpsOscillatorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 OscillatorFrequency;
   tF32 TempCompOffset;
   tF32 CalcOffset;
   tF32 IFOffset;
   virtual ~cmb_sensorfi_tclMsgGpsOscillatorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsOscillatorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroErrorGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroErrorGet();

   virtual ~cmb_sensorfi_tclMsgGyroErrorGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroErrorGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroErrorUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroErrorUpReg();

   virtual ~cmb_sensorfi_tclMsgGyroErrorUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroErrorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroErrorRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroErrorRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGyroErrorRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroErrorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroErrorStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroErrorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroErrorStatus& operator=(const cmb_sensorfi_tclMsgGyroErrorStatus& coRef);
   cmb_sensorfi_tclMsgGyroErrorStatus(const cmb_sensorfi_tclMsgGyroErrorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_e8_GyroError ErrorState;
   virtual ~cmb_sensorfi_tclMsgGyroErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroErrorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTestAdditionalDataGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTestAdditionalDataGet();

   virtual ~cmb_sensorfi_tclMsgGpsTestAdditionalDataGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsTestAdditionalDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTestAdditionalDataUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTestAdditionalDataUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsTestAdditionalDataUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsTestAdditionalDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTestAdditionalDataRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTestAdditionalDataRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsTestAdditionalDataRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsTestAdditionalDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus& operator=(const cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus& coRef);
   cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus(const cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_GpsTestAdditionalData Data;
   virtual ~cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsTestAdditionalDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTightCouplingDataGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTightCouplingDataGet();

   virtual ~cmb_sensorfi_tclMsgGpsTightCouplingDataGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsTightCouplingDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTightCouplingDataUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTightCouplingDataUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsTightCouplingDataUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsTightCouplingDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTightCouplingDataRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTightCouplingDataRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsTightCouplingDataRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsTightCouplingDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsTightCouplingDataStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsTightCouplingDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsTightCouplingDataStatus& operator=(const cmb_sensorfi_tclMsgGpsTightCouplingDataStatus& coRef);
   cmb_sensorfi_tclMsgGpsTightCouplingDataStatus(const cmb_sensorfi_tclMsgGpsTightCouplingDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_GpsTightCouplingData Data;
   virtual ~cmb_sensorfi_tclMsgGpsTightCouplingDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsTightCouplingDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAbsDataGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAbsDataGet();

   virtual ~cmb_sensorfi_tclMsgAbsDataGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgAbsDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAbsDataUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAbsDataUpReg();

   virtual ~cmb_sensorfi_tclMsgAbsDataUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgAbsDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAbsDataRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAbsDataRelUpReg();

   virtual ~cmb_sensorfi_tclMsgAbsDataRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgAbsDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAbsDataStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAbsDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgAbsDataStatus& operator=(const cmb_sensorfi_tclMsgAbsDataStatus& coRef);
   cmb_sensorfi_tclMsgAbsDataStatus(const cmb_sensorfi_tclMsgAbsDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_AbsData, std::allocator<cmb_fi_tcl_AbsData> > AbsData;
   virtual ~cmb_sensorfi_tclMsgAbsDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgAbsDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgSteeringDataGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgSteeringDataGet();

   virtual ~cmb_sensorfi_tclMsgSteeringDataGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgSteeringDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgSteeringDataUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgSteeringDataUpReg();

   virtual ~cmb_sensorfi_tclMsgSteeringDataUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgSteeringDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgSteeringDataRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgSteeringDataRelUpReg();

   virtual ~cmb_sensorfi_tclMsgSteeringDataRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgSteeringDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgSteeringDataStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgSteeringDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgSteeringDataStatus& operator=(const cmb_sensorfi_tclMsgSteeringDataStatus& coRef);
   cmb_sensorfi_tclMsgSteeringDataStatus(const cmb_sensorfi_tclMsgSteeringDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_SteeringData, std::allocator<cmb_fi_tcl_SteeringData> > SteeringData;
   virtual ~cmb_sensorfi_tclMsgSteeringDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgSteeringDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerRangeGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerRangeGet();

   virtual ~cmb_sensorfi_tclMsgOdometerRangeGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgOdometerRangeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerRangeSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerRangeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgOdometerRangeSet& operator=(const cmb_sensorfi_tclMsgOdometerRangeSet& coRef);
   cmb_sensorfi_tclMsgOdometerRangeSet(const cmb_sensorfi_tclMsgOdometerRangeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 PulsesPerMeterMin;
   tF32 PulsesPerMeterMax;
   cmb_fi_tcl_e8_OdometerRangeStatus OdometerRangeStatus;
   virtual ~cmb_sensorfi_tclMsgOdometerRangeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgOdometerRangeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgOdometerRangeStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgOdometerRangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgOdometerRangeStatus& operator=(const cmb_sensorfi_tclMsgOdometerRangeStatus& coRef);
   cmb_sensorfi_tclMsgOdometerRangeStatus(const cmb_sensorfi_tclMsgOdometerRangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 PulsesPerMeterMin;
   tF32 PulsesPerMeterMax;
   cmb_fi_tcl_e8_OdometerRangeStatus OdometerRangeStatus;
   virtual ~cmb_sensorfi_tclMsgOdometerRangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgOdometerRangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroDiagDataGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroDiagDataGet();

   virtual ~cmb_sensorfi_tclMsgGyroDiagDataGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroDiagDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroDiagDataStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroDiagDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroDiagDataStatus& operator=(const cmb_sensorfi_tclMsgGyroDiagDataStatus& coRef);
   cmb_sensorfi_tclMsgGyroDiagDataStatus(const cmb_sensorfi_tclMsgGyroDiagDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 GyroVdd;
   tU32 GyroValue;
   virtual ~cmb_sensorfi_tclMsgGyroDiagDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroDiagDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsDiagPositionGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsDiagPositionGet();

   virtual ~cmb_sensorfi_tclMsgGpsDiagPositionGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsDiagPositionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsDiagPositionSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsDiagPositionSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsDiagPositionSet& operator=(const cmb_sensorfi_tclMsgGpsDiagPositionSet& coRef);
   cmb_sensorfi_tclMsgGpsDiagPositionSet(const cmb_sensorfi_tclMsgGpsDiagPositionSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 LatDeg;
   tS16 LatMin;
   tS16 LatSec;
   tS16 LongDeg;
   tS16 LongMin;
   tS16 LongSec;
   tS16 Altitude;
   virtual ~cmb_sensorfi_tclMsgGpsDiagPositionSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsDiagPositionSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsDiagPositionStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsDiagPositionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsDiagPositionStatus& operator=(const cmb_sensorfi_tclMsgGpsDiagPositionStatus& coRef);
   cmb_sensorfi_tclMsgGpsDiagPositionStatus(const cmb_sensorfi_tclMsgGpsDiagPositionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 LatDeg;
   tS16 LatMin;
   tS16 LatSec;
   tS16 LongDeg;
   tS16 LongMin;
   tS16 LongSec;
   tS16 Altitude;
   virtual ~cmb_sensorfi_tclMsgGpsDiagPositionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsDiagPositionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgDriveDirectionGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgDriveDirectionGet();

   virtual ~cmb_sensorfi_tclMsgDriveDirectionGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgDriveDirectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgDriveDirectionUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgDriveDirectionUpReg();

   virtual ~cmb_sensorfi_tclMsgDriveDirectionUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgDriveDirectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgDriveDirectionRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgDriveDirectionRelUpReg();

   virtual ~cmb_sensorfi_tclMsgDriveDirectionRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgDriveDirectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgDriveDirectionStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgDriveDirectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgDriveDirectionStatus& operator=(const cmb_sensorfi_tclMsgDriveDirectionStatus& coRef);
   cmb_sensorfi_tclMsgDriveDirectionStatus(const cmb_sensorfi_tclMsgDriveDirectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_e8_OdometerDirection Direction;
   virtual ~cmb_sensorfi_tclMsgDriveDirectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgDriveDirectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGalaSpeedGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGalaSpeedGet();

   virtual ~cmb_sensorfi_tclMsgGalaSpeedGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGalaSpeedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGalaSpeedUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGalaSpeedUpReg();

   virtual ~cmb_sensorfi_tclMsgGalaSpeedUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGalaSpeedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGalaSpeedRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGalaSpeedRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGalaSpeedRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGalaSpeedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGalaSpeedStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGalaSpeedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGalaSpeedStatus& operator=(const cmb_sensorfi_tclMsgGalaSpeedStatus& coRef);
   cmb_sensorfi_tclMsgGalaSpeedStatus(const cmb_sensorfi_tclMsgGalaSpeedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 Speed;
   virtual ~cmb_sensorfi_tclMsgGalaSpeedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGalaSpeedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityGet();

   virtual ~cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus& operator=(const cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus& coRef);
   cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus(const cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 NoiseLevel;
   tU32 TimePosValid;
   virtual ~cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGpsNoiselevelTimePosValidityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyro3dDiagDataGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyro3dDiagDataGet();

   virtual ~cmb_sensorfi_tclMsgGyro3dDiagDataGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyro3dDiagDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyro3dDiagDataStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyro3dDiagDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyro3dDiagDataStatus& operator=(const cmb_sensorfi_tclMsgGyro3dDiagDataStatus& coRef);
   cmb_sensorfi_tclMsgGyro3dDiagDataStatus(const cmb_sensorfi_tclMsgGyro3dDiagDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 r_axis;
   tU32 s_axis;
   tU32 t_axis;
   virtual ~cmb_sensorfi_tclMsgGyro3dDiagDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyro3dDiagDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAcc3dDiagDataGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAcc3dDiagDataGet();

   virtual ~cmb_sensorfi_tclMsgAcc3dDiagDataGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgAcc3dDiagDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAcc3dDiagDataStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAcc3dDiagDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgAcc3dDiagDataStatus& operator=(const cmb_sensorfi_tclMsgAcc3dDiagDataStatus& coRef);
   cmb_sensorfi_tclMsgAcc3dDiagDataStatus(const cmb_sensorfi_tclMsgAcc3dDiagDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 x_axis;
   tU32 y_axis;
   tU32 z_axis;
   virtual ~cmb_sensorfi_tclMsgAcc3dDiagDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgAcc3dDiagDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyro3dData_UpdateGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyro3dData_UpdateGet();

   virtual ~cmb_sensorfi_tclMsgGyro3dData_UpdateGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyro3dData_UpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyro3dData_UpdateUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyro3dData_UpdateUpReg();

   virtual ~cmb_sensorfi_tclMsgGyro3dData_UpdateUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyro3dData_UpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyro3dData_UpdateRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyro3dData_UpdateRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGyro3dData_UpdateRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyro3dData_UpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyro3dData_UpdateStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyro3dData_UpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyro3dData_UpdateStatus& operator=(const cmb_sensorfi_tclMsgGyro3dData_UpdateStatus& coRef);
   cmb_sensorfi_tclMsgGyro3dData_UpdateStatus(const cmb_sensorfi_tclMsgGyro3dData_UpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_3dGyroData, std::allocator<cmb_fi_tcl_3dGyroData> > Gyro3dData;
   virtual ~cmb_sensorfi_tclMsgGyro3dData_UpdateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyro3dData_UpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAcc3dData_UpdateGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAcc3dData_UpdateGet();

   virtual ~cmb_sensorfi_tclMsgAcc3dData_UpdateGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgAcc3dData_UpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAcc3dData_UpdateUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAcc3dData_UpdateUpReg();

   virtual ~cmb_sensorfi_tclMsgAcc3dData_UpdateUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgAcc3dData_UpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAcc3dData_UpdateRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAcc3dData_UpdateRelUpReg();

   virtual ~cmb_sensorfi_tclMsgAcc3dData_UpdateRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgAcc3dData_UpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgAcc3dData_UpdateStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgAcc3dData_UpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgAcc3dData_UpdateStatus& operator=(const cmb_sensorfi_tclMsgAcc3dData_UpdateStatus& coRef);
   cmb_sensorfi_tclMsgAcc3dData_UpdateStatus(const cmb_sensorfi_tclMsgAcc3dData_UpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<cmb_fi_tcl_3dAccData, std::allocator<cmb_fi_tcl_3dAccData> > Acc3dData;
   virtual ~cmb_sensorfi_tclMsgAcc3dData_UpdateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgAcc3dData_UpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroTemperatureGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroTemperatureGet();

   virtual ~cmb_sensorfi_tclMsgGyroTemperatureGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroTemperatureGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroTemperatureUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroTemperatureUpReg();

   virtual ~cmb_sensorfi_tclMsgGyroTemperatureUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroTemperatureUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroTemperatureRelUpReg : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroTemperatureRelUpReg();

   virtual ~cmb_sensorfi_tclMsgGyroTemperatureRelUpReg();

   inline tBool operator==(const cmb_sensorfi_tclMsgGyroTemperatureRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGyroTemperatureStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGyroTemperatureStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGyroTemperatureStatus& operator=(const cmb_sensorfi_tclMsgGyroTemperatureStatus& coRef);
   cmb_sensorfi_tclMsgGyroTemperatureStatus(const cmb_sensorfi_tclMsgGyroTemperatureStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 GyroTemperature;
   virtual ~cmb_sensorfi_tclMsgGyroTemperatureStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGyroTemperatureStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGnssSatSystemGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGnssSatSystemGet();

   virtual ~cmb_sensorfi_tclMsgGnssSatSystemGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGnssSatSystemGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGnssSatSystemSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGnssSatSystemSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGnssSatSystemSet& operator=(const cmb_sensorfi_tclMsgGnssSatSystemSet& coRef);
   cmb_sensorfi_tclMsgGnssSatSystemSet(const cmb_sensorfi_tclMsgGnssSatSystemSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_b8_GnssSatSys TargetGnssSatSys;
   virtual ~cmb_sensorfi_tclMsgGnssSatSystemSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGnssSatSystemSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGnssSatSystemStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGnssSatSystemStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGnssSatSystemStatus& operator=(const cmb_sensorfi_tclMsgGnssSatSystemStatus& coRef);
   cmb_sensorfi_tclMsgGnssSatSystemStatus(const cmb_sensorfi_tclMsgGnssSatSystemStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_b8_GnssSatSys ActualGnssSatSys;
   virtual ~cmb_sensorfi_tclMsgGnssSatSystemStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGnssSatSystemStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGnssWnEpochGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGnssWnEpochGet();

   virtual ~cmb_sensorfi_tclMsgGnssWnEpochGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgGnssWnEpochGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGnssWnEpochSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGnssWnEpochSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGnssWnEpochSet& operator=(const cmb_sensorfi_tclMsgGnssWnEpochSet& coRef);
   cmb_sensorfi_tclMsgGnssWnEpochSet(const cmb_sensorfi_tclMsgGnssWnEpochSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_TimeDate TargetWnDate;
   virtual ~cmb_sensorfi_tclMsgGnssWnEpochSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGnssWnEpochSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgGnssWnEpochStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgGnssWnEpochStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgGnssWnEpochStatus& operator=(const cmb_sensorfi_tclMsgGnssWnEpochStatus& coRef);
   cmb_sensorfi_tclMsgGnssWnEpochStatus(const cmb_sensorfi_tclMsgGnssWnEpochStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_TimeDate ActualWnDate;
   virtual ~cmb_sensorfi_tclMsgGnssWnEpochStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgGnssWnEpochStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTimeModeGet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTimeModeGet();

   virtual ~cmb_sensorfi_tclMsgTimeModeGet();

   inline tBool operator==(const cmb_sensorfi_tclMsgTimeModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTimeModeSet : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTimeModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgTimeModeSet& operator=(const cmb_sensorfi_tclMsgTimeModeSet& coRef);
   cmb_sensorfi_tclMsgTimeModeSet(const cmb_sensorfi_tclMsgTimeModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_e8_timeMode targetTimeMode;
   cmb_fi_tcl_TimeDate targetTimeDate;
   virtual ~cmb_sensorfi_tclMsgTimeModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgTimeModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_sensorfi_tclMsgTimeModeStatus : public cmb_sensorfi_tclMsgBaseMessage
{
public:

   cmb_sensorfi_tclMsgTimeModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_sensorfi_tclMsgTimeModeStatus& operator=(const cmb_sensorfi_tclMsgTimeModeStatus& coRef);
   cmb_sensorfi_tclMsgTimeModeStatus(const cmb_sensorfi_tclMsgTimeModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_e8_timeMode actualTimeMode;
   virtual ~cmb_sensorfi_tclMsgTimeModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_sensorfi_tclMsgTimeModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
