/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef CMB_ACRFITYPES_HEADER
#define CMB_ACRFITYPES_HEADER


class cmb_acrfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for CMB_ACR_FI message types

fi_tclMessageBase* cmb_acrfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class cmb_acrfi_tclMsgBaseMessage : public cmb_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   cmb_acrfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class cmb_acrfi_tclMsgVoiceAdviceMethodStart : public cmb_acrfi_tclMsgBaseMessage
{
public:

   cmb_acrfi_tclMsgVoiceAdviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_acrfi_tclMsgVoiceAdviceMethodStart& operator=(const cmb_acrfi_tclMsgVoiceAdviceMethodStart& coRef);
   cmb_acrfi_tclMsgVoiceAdviceMethodStart(const cmb_acrfi_tclMsgVoiceAdviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_AudioChannelAdvice AudioChannelAdvice;
   virtual ~cmb_acrfi_tclMsgVoiceAdviceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_acrfi_tclMsgVoiceAdviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_acrfi_tclMsgVoiceAdviceMethodResult : public cmb_acrfi_tclMsgBaseMessage
{
public:

   cmb_acrfi_tclMsgVoiceAdviceMethodResult();

   virtual ~cmb_acrfi_tclMsgVoiceAdviceMethodResult();

   inline tBool operator==(const cmb_acrfi_tclMsgVoiceAdviceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_acrfi_tclMsgChannelRequestGet : public cmb_acrfi_tclMsgBaseMessage
{
public:

   cmb_acrfi_tclMsgChannelRequestGet();

   virtual ~cmb_acrfi_tclMsgChannelRequestGet();

   inline tBool operator==(const cmb_acrfi_tclMsgChannelRequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_acrfi_tclMsgChannelRequestStatus : public cmb_acrfi_tclMsgBaseMessage
{
public:

   cmb_acrfi_tclMsgChannelRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_acrfi_tclMsgChannelRequestStatus& operator=(const cmb_acrfi_tclMsgChannelRequestStatus& coRef);
   cmb_acrfi_tclMsgChannelRequestStatus(const cmb_acrfi_tclMsgChannelRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_ChannelRequestStatusList ChannelRequestStatusList;
   virtual ~cmb_acrfi_tclMsgChannelRequestStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_acrfi_tclMsgChannelRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_acrfi_tclMsgChannelRequestUpReg : public cmb_acrfi_tclMsgBaseMessage
{
public:

   cmb_acrfi_tclMsgChannelRequestUpReg();

   virtual ~cmb_acrfi_tclMsgChannelRequestUpReg();

   inline tBool operator==(const cmb_acrfi_tclMsgChannelRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_acrfi_tclMsgChannelRequestRelUpReg : public cmb_acrfi_tclMsgBaseMessage
{
public:

   cmb_acrfi_tclMsgChannelRequestRelUpReg();

   virtual ~cmb_acrfi_tclMsgChannelRequestRelUpReg();

   inline tBool operator==(const cmb_acrfi_tclMsgChannelRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_acrfi_tclMsgInstancesPerCategoryGet : public cmb_acrfi_tclMsgBaseMessage
{
public:

   cmb_acrfi_tclMsgInstancesPerCategoryGet();

   virtual ~cmb_acrfi_tclMsgInstancesPerCategoryGet();

   inline tBool operator==(const cmb_acrfi_tclMsgInstancesPerCategoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_acrfi_tclMsgInstancesPerCategoryStatus : public cmb_acrfi_tclMsgBaseMessage
{
public:

   cmb_acrfi_tclMsgInstancesPerCategoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cmb_acrfi_tclMsgInstancesPerCategoryStatus& operator=(const cmb_acrfi_tclMsgInstancesPerCategoryStatus& coRef);
   cmb_acrfi_tclMsgInstancesPerCategoryStatus(const cmb_acrfi_tclMsgInstancesPerCategoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cmb_fi_tcl_InstancesPerCategoryList InstancesPerCategoryList;
   virtual ~cmb_acrfi_tclMsgInstancesPerCategoryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cmb_acrfi_tclMsgInstancesPerCategoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cmb_acrfi_tclMsgInstancesPerCategoryUpReg : public cmb_acrfi_tclMsgBaseMessage
{
public:

   cmb_acrfi_tclMsgInstancesPerCategoryUpReg();

   virtual ~cmb_acrfi_tclMsgInstancesPerCategoryUpReg();

   inline tBool operator==(const cmb_acrfi_tclMsgInstancesPerCategoryUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cmb_acrfi_tclMsgInstancesPerCategoryRelUpReg : public cmb_acrfi_tclMsgBaseMessage
{
public:

   cmb_acrfi_tclMsgInstancesPerCategoryRelUpReg();

   virtual ~cmb_acrfi_tclMsgInstancesPerCategoryRelUpReg();

   inline tBool operator==(const cmb_acrfi_tclMsgInstancesPerCategoryRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};


#endif
