/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CMB_FI_S_IMPORT_INTERFACE_CMB_ACRFI_TYPES
#define CMB_FI_S_IMPORT_INTERFACE_CMB_ACRFI_FUNCTIONIDS
#define CMB_FI_S_IMPORT_INTERFACE_CMB_ACRFI_SERVICEINFO
#include "cmb_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for CMB_ACR_FI message types

fi_tclMessageBase* cmb_acrfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case cmb_acrfi_tclToken::EN_MSG_VOICEADVICEMETHODSTART:
         return OSAL_NEW cmb_acrfi_tclMsgVoiceAdviceMethodStart;

      case cmb_acrfi_tclToken::EN_MSG_VOICEADVICEMETHODRESULT:
         return OSAL_NEW cmb_acrfi_tclMsgVoiceAdviceMethodResult;

      case cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTGET:
         return OSAL_NEW cmb_acrfi_tclMsgChannelRequestGet;

      case cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTSTATUS:
         return OSAL_NEW cmb_acrfi_tclMsgChannelRequestStatus;

      case cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTUPREG:
         return OSAL_NEW cmb_acrfi_tclMsgChannelRequestUpReg;

      case cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTRELUPREG:
         return OSAL_NEW cmb_acrfi_tclMsgChannelRequestRelUpReg;

      case cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYGET:
         return OSAL_NEW cmb_acrfi_tclMsgInstancesPerCategoryGet;

      case cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYSTATUS:
         return OSAL_NEW cmb_acrfi_tclMsgInstancesPerCategoryStatus;

      case cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYUPREG:
         return OSAL_NEW cmb_acrfi_tclMsgInstancesPerCategoryUpReg;

      case cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYRELUPREG:
         return OSAL_NEW cmb_acrfi_tclMsgInstancesPerCategoryRelUpReg;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all cmb_acrfifi messages

// common functions

tU16 cmb_acrfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return CMB_ACRFI_C_U16_SERVICE_ID;
}

tU16 cmb_acrfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 cmb_acrfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& cmb_acrfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& cmb_acrfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 cmb_acrfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& cmb_acrfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& cmb_acrfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_acrfi_tclMsgVoiceAdviceMethodStart::cmb_acrfi_tclMsgVoiceAdviceMethodStart(const cmb_acrfi_tclMsgVoiceAdviceMethodStart& coRef)
   : cmb_acrfi_tclMsgBaseMessage(coRef)
{
   AudioChannelAdvice = coRef.AudioChannelAdvice;
}
cmb_acrfi_tclMsgVoiceAdviceMethodStart& cmb_acrfi_tclMsgVoiceAdviceMethodStart::operator=(const cmb_acrfi_tclMsgVoiceAdviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AudioChannelAdvice = coRef.AudioChannelAdvice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_acrfi_tclMsgVoiceAdviceMethodStart::vDestroy()
{
   AudioChannelAdvice.vDestroy(); 
}

cmb_acrfi_tclMsgVoiceAdviceMethodStart::cmb_acrfi_tclMsgVoiceAdviceMethodStart()
:AudioChannelAdvice()
 {}

tS32 cmb_acrfi_tclMsgVoiceAdviceMethodStart::s32GetTypeId() const
{
   return (tS32) cmb_acrfi_tclToken::EN_MSG_VOICEADVICEMETHODSTART;
}


cmb_acrfi_tclMsgVoiceAdviceMethodStart::~cmb_acrfi_tclMsgVoiceAdviceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_acrfi_tclMsgVoiceAdviceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AudioChannelAdvice.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_acrfi_tclMsgVoiceAdviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudioChannelAdvice);
   return oIn;
}

fi_tclOutContext& cmb_acrfi_tclMsgVoiceAdviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudioChannelAdvice);
   return oOut;
}

tBool cmb_acrfi_tclMsgVoiceAdviceMethodStart::operator==(const cmb_acrfi_tclMsgVoiceAdviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudioChannelAdvice == roRef.AudioChannelAdvice);
   return bResult;
}

//=============================================================================

cmb_acrfi_tclMsgVoiceAdviceMethodResult::cmb_acrfi_tclMsgVoiceAdviceMethodResult()
 {}

tS32 cmb_acrfi_tclMsgVoiceAdviceMethodResult::s32GetTypeId() const
{
   return (tS32) cmb_acrfi_tclToken::EN_MSG_VOICEADVICEMETHODRESULT;
}


cmb_acrfi_tclMsgVoiceAdviceMethodResult::~cmb_acrfi_tclMsgVoiceAdviceMethodResult()
{}

//=============================================================================

cmb_acrfi_tclMsgChannelRequestGet::cmb_acrfi_tclMsgChannelRequestGet()
 {}

tS32 cmb_acrfi_tclMsgChannelRequestGet::s32GetTypeId() const
{
   return (tS32) cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTGET;
}


cmb_acrfi_tclMsgChannelRequestGet::~cmb_acrfi_tclMsgChannelRequestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_acrfi_tclMsgChannelRequestStatus::cmb_acrfi_tclMsgChannelRequestStatus(const cmb_acrfi_tclMsgChannelRequestStatus& coRef)
   : cmb_acrfi_tclMsgBaseMessage(coRef)
{
   ChannelRequestStatusList = coRef.ChannelRequestStatusList;
}
cmb_acrfi_tclMsgChannelRequestStatus& cmb_acrfi_tclMsgChannelRequestStatus::operator=(const cmb_acrfi_tclMsgChannelRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   ChannelRequestStatusList = coRef.ChannelRequestStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_acrfi_tclMsgChannelRequestStatus::vDestroy()
{
   ChannelRequestStatusList.vDestroy(); 
}

cmb_acrfi_tclMsgChannelRequestStatus::cmb_acrfi_tclMsgChannelRequestStatus()
:ChannelRequestStatusList()
 {}

tS32 cmb_acrfi_tclMsgChannelRequestStatus::s32GetTypeId() const
{
   return (tS32) cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTSTATUS;
}


cmb_acrfi_tclMsgChannelRequestStatus::~cmb_acrfi_tclMsgChannelRequestStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_acrfi_tclMsgChannelRequestStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ChannelRequestStatusList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_acrfi_tclMsgChannelRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelRequestStatusList);
   return oIn;
}

fi_tclOutContext& cmb_acrfi_tclMsgChannelRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelRequestStatusList);
   return oOut;
}

tBool cmb_acrfi_tclMsgChannelRequestStatus::operator==(const cmb_acrfi_tclMsgChannelRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelRequestStatusList == roRef.ChannelRequestStatusList);
   return bResult;
}

//=============================================================================

cmb_acrfi_tclMsgChannelRequestUpReg::cmb_acrfi_tclMsgChannelRequestUpReg()
 {}

tS32 cmb_acrfi_tclMsgChannelRequestUpReg::s32GetTypeId() const
{
   return (tS32) cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTUPREG;
}


cmb_acrfi_tclMsgChannelRequestUpReg::~cmb_acrfi_tclMsgChannelRequestUpReg()
{}

//=============================================================================

cmb_acrfi_tclMsgChannelRequestRelUpReg::cmb_acrfi_tclMsgChannelRequestRelUpReg()
 {}

tS32 cmb_acrfi_tclMsgChannelRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTRELUPREG;
}


cmb_acrfi_tclMsgChannelRequestRelUpReg::~cmb_acrfi_tclMsgChannelRequestRelUpReg()
{}

//=============================================================================

cmb_acrfi_tclMsgInstancesPerCategoryGet::cmb_acrfi_tclMsgInstancesPerCategoryGet()
 {}

tS32 cmb_acrfi_tclMsgInstancesPerCategoryGet::s32GetTypeId() const
{
   return (tS32) cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYGET;
}


cmb_acrfi_tclMsgInstancesPerCategoryGet::~cmb_acrfi_tclMsgInstancesPerCategoryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_acrfi_tclMsgInstancesPerCategoryStatus::cmb_acrfi_tclMsgInstancesPerCategoryStatus(const cmb_acrfi_tclMsgInstancesPerCategoryStatus& coRef)
   : cmb_acrfi_tclMsgBaseMessage(coRef)
{
   InstancesPerCategoryList = coRef.InstancesPerCategoryList;
}
cmb_acrfi_tclMsgInstancesPerCategoryStatus& cmb_acrfi_tclMsgInstancesPerCategoryStatus::operator=(const cmb_acrfi_tclMsgInstancesPerCategoryStatus& coRef)
{
   if (this == &coRef) return *this;
   InstancesPerCategoryList = coRef.InstancesPerCategoryList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_acrfi_tclMsgInstancesPerCategoryStatus::vDestroy()
{
   InstancesPerCategoryList.vDestroy(); 
}

cmb_acrfi_tclMsgInstancesPerCategoryStatus::cmb_acrfi_tclMsgInstancesPerCategoryStatus()
:InstancesPerCategoryList()
 {}

tS32 cmb_acrfi_tclMsgInstancesPerCategoryStatus::s32GetTypeId() const
{
   return (tS32) cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYSTATUS;
}


cmb_acrfi_tclMsgInstancesPerCategoryStatus::~cmb_acrfi_tclMsgInstancesPerCategoryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_acrfi_tclMsgInstancesPerCategoryStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+InstancesPerCategoryList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_acrfi_tclMsgInstancesPerCategoryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> InstancesPerCategoryList);
   return oIn;
}

fi_tclOutContext& cmb_acrfi_tclMsgInstancesPerCategoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << InstancesPerCategoryList);
   return oOut;
}

tBool cmb_acrfi_tclMsgInstancesPerCategoryStatus::operator==(const cmb_acrfi_tclMsgInstancesPerCategoryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (InstancesPerCategoryList == roRef.InstancesPerCategoryList);
   return bResult;
}

//=============================================================================

cmb_acrfi_tclMsgInstancesPerCategoryUpReg::cmb_acrfi_tclMsgInstancesPerCategoryUpReg()
 {}

tS32 cmb_acrfi_tclMsgInstancesPerCategoryUpReg::s32GetTypeId() const
{
   return (tS32) cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYUPREG;
}


cmb_acrfi_tclMsgInstancesPerCategoryUpReg::~cmb_acrfi_tclMsgInstancesPerCategoryUpReg()
{}

//=============================================================================

cmb_acrfi_tclMsgInstancesPerCategoryRelUpReg::cmb_acrfi_tclMsgInstancesPerCategoryRelUpReg()
 {}

tS32 cmb_acrfi_tclMsgInstancesPerCategoryRelUpReg::s32GetTypeId() const
{
   return (tS32) cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYRELUPREG;
}


cmb_acrfi_tclMsgInstancesPerCategoryRelUpReg::~cmb_acrfi_tclMsgInstancesPerCategoryRelUpReg()
{}

