#ifndef CMB_ACRFILANGUAGE_HEADER
#define CMB_ACRFILANGUAGE_HEADER

class cmb_acrfi_tclInContext;
class cmb_acrfi_tclOutContext;
class cmb_acrfi_tclVisitorBase;

class MY_DECL cmb_acrfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  cmb_acrfi_tclDescription(fi_tclInContext* poIn, cmb_acrfi_tclVisitorBase* poVisit);
  cmb_acrfi_tclDescription(fi_tclOutContext* poOut, cmb_acrfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(cmb_acrfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(cmb_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ cmb_acrfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  cmb_acrfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<cmb_acrfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<cmb_acrfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline cmb_acrfi_tclDescription::cmb_acrfi_tclDescription(fi_tclInContext* poIn, cmb_acrfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline cmb_acrfi_tclDescription::cmb_acrfi_tclDescription(fi_tclOutContext* poOut, cmb_acrfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

