#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CMB_FI_S_IMPORT_INTERFACE_CMB_ACRFI_STDVISITORS
#include "cmb_fi_gen_if.h"

tBool cmb_acrfi_tclDescription::bInitMessage(cmb_acrfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case cmb_acrfi_tclToken::EN_LAST_TOKEN:
   case cmb_acrfi_tclToken::EN_LIST:
   case cmb_acrfi_tclToken::EN_END_OF_STRUCT:
   case cmb_acrfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;
   // include the expansions for the messages
   case cmb_acrfi_tclToken::EN_MSG_VOICEADVICEMETHODSTART:
   {
      bResult = oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_AUDIOCHANNELADVICE,cmb_acrfi_tclSemanticDomain::EN_MSG_AUDIOCHANNELADVICE)) && bResult;
   } break;
   case cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTSTATUS:
   {
      bResult = oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_CHANNELREQUESTSTATUSLIST,cmb_acrfi_tclSemanticDomain::EN_MSG_CHANNELREQUESTSTATUSLIST)) && bResult;
   } break;
   case cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYSTATUS:
   {
      bResult = oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_INSTANCESPERCATEGORYLIST,cmb_acrfi_tclSemanticDomain::EN_MSG_INSTANCESPERCATEGORYLIST)) && bResult;
   } break;
   case cmb_acrfi_tclToken::EN_MSG_VOICEADVICEMETHODRESULT:
   case cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTGET:
   case cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTUPREG:
   case cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTRELUPREG:
   case cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYGET:
   case cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYUPREG:
   case cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYRELUPREG:
   case cmb_acrfi_tclToken::EN_BINCONTAINER:
   case cmb_acrfi_tclToken::EN_E8_AUDIOCHANNELADVICE:
   case cmb_acrfi_tclToken::EN_E8_VOICECATEGORY:
   case cmb_acrfi_tclToken::EN_E8_CATSTATUS:
   case cmb_acrfi_tclToken::EN_AUDIOCHANNELADVICE:
   case cmb_acrfi_tclToken::EN_B8_AUDIOOUTPUTLOCATION:
   case cmb_acrfi_tclToken::EN_B8_AUDIOFORMAT:
   case cmb_acrfi_tclToken::EN_INSTANCESPERCATEGORY:
   case cmb_acrfi_tclToken::EN_INSTANCESPERCATEGORYLIST:
   case cmb_acrfi_tclToken::EN_B16_REQUESTADDINFO:
   case cmb_acrfi_tclToken::EN_CHANNELREQUESTSTATUS:
   case cmb_acrfi_tclToken::EN_CHANNELREQUESTSTATUSLIST:
   case cmb_acrfi_tclToken::EN_U8:   
   case cmb_acrfi_tclToken::EN_S8:   
   case cmb_acrfi_tclToken::EN_U16:   
   case cmb_acrfi_tclToken::EN_S16:   
   case cmb_acrfi_tclToken::EN_U24:   
   case cmb_acrfi_tclToken::EN_S24:   
   case cmb_acrfi_tclToken::EN_U32:   
   case cmb_acrfi_tclToken::EN_S32:   
   case cmb_acrfi_tclToken::EN_U64:   
   case cmb_acrfi_tclToken::EN_S64:   
   case cmb_acrfi_tclToken::EN_F32:   
   case cmb_acrfi_tclToken::EN_F64:   
   case cmb_acrfi_tclToken::EN_BOOL:   
   case cmb_acrfi_tclToken::EN_STRING:   
   case cmb_acrfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(enMsgToken,cmb_acrfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool cmb_acrfi_tclDescription::bDoIt(cmb_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool cmb_acrfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      cmb_acrfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      cmb_acrfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      cmb_acrfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == cmb_acrfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(cmb_acrfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case cmb_acrfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == cmb_acrfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_LIST: 
      {
         cmb_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            cmb_acrfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            cmb_acrfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case cmb_acrfi_tclToken::EN_U8: 
      {
         cmb_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case cmb_acrfi_tclToken::EN_U16: 
      {
         cmb_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_U24: 
      {
         cmb_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_U32: 
      {
         cmb_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_U64: 
      {
         cmb_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_S8: 
      {
         cmb_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_S16: 
      {
         cmb_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_S24: 
      {
         cmb_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_S32: 
      {
         cmb_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_S64: 
      {
         cmb_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_F32: 
      {
         cmb_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_F64: 
      {
         cmb_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_BOOL: 
      {
         cmb_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_STRING: 
      {
         cmb_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         cmb_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case cmb_acrfi_tclToken::EN_MSG_VOICEADVICEMETHODSTART:
      case cmb_acrfi_tclToken::EN_MSG_VOICEADVICEMETHODRESULT:
      case cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTGET:
      case cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTSTATUS:
      case cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTUPREG:
      case cmb_acrfi_tclToken::EN_MSG_CHANNELREQUESTRELUPREG:
      case cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYGET:
      case cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYSTATUS:
      case cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYUPREG:
      case cmb_acrfi_tclToken::EN_MSG_INSTANCESPERCATEGORYRELUPREG:
         (tVoid) bInitMessage(enToken);
         break;
      case cmb_acrfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_END_OF_STRUCT,cmb_acrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_U8,cmb_acrfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_LIST,cmb_acrfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         cmb_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_acrfi_tclToken::EN_E8_AUDIOCHANNELADVICE:
      {
         cmb_fi_tcl_e8_AudioChannelAdvice o_e8_AudioChannelAdvice;
         if (!bDoIt(o_e8_AudioChannelAdvice))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_E8_VOICECATEGORY:
      {
         cmb_fi_tcl_e8_VoiceCategory o_e8_VoiceCategory;
         if (!bDoIt(o_e8_VoiceCategory))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_E8_CATSTATUS:
      {
         cmb_fi_tcl_e8_CatStatus o_e8_CatStatus;
         if (!bDoIt(o_e8_CatStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_AUDIOCHANNELADVICE:
      {
      if (poVisitor->bDoExpand_AudioChannelAdvice(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_END_OF_STRUCT,cmb_acrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_STRING,cmb_acrfi_tclSemanticDomain::EN_DEVICE));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_U8,cmb_acrfi_tclSemanticDomain::EN_INDEX));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_E8_AUDIOCHANNELADVICE,cmb_acrfi_tclSemanticDomain::EN_CHANNELADVICE));
      }
      else
      {
         cmb_fi_tcl_AudioChannelAdvice o_AudioChannelAdvice;
         if (!bDoIt(o_AudioChannelAdvice))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AudioChannelAdvice.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AudioChannelAdvice.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_acrfi_tclToken::EN_B8_AUDIOOUTPUTLOCATION:
      {
         cmb_fi_tcl_b8_AudioOutputLocation o_b8_AudioOutputLocation;
         if (!bDoIt(o_b8_AudioOutputLocation))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_B8_AUDIOFORMAT:
      {
         cmb_fi_tcl_b8_AudioFormat o_b8_AudioFormat;
         if (!bDoIt(o_b8_AudioFormat))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_INSTANCESPERCATEGORY:
      {
      if (poVisitor->bDoExpand_InstancesPerCategory(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_END_OF_STRUCT,cmb_acrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_U8,cmb_acrfi_tclSemanticDomain::EN_NUMBEROFINSTANCES));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_E8_VOICECATEGORY,cmb_acrfi_tclSemanticDomain::EN_VOICECATEGORY));
      }
      else
      {
         cmb_fi_tcl_InstancesPerCategory o_InstancesPerCategory;
         if (!bDoIt(o_InstancesPerCategory))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_InstancesPerCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_InstancesPerCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_acrfi_tclToken::EN_INSTANCESPERCATEGORYLIST:
      {
      if (poVisitor->bDoExpand_InstancesPerCategoryList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_END_OF_STRUCT,cmb_acrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_U8,cmb_acrfi_tclSemanticDomain::EN_MAXAMOUNTINSTANCES));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_INSTANCESPERCATEGORY,cmb_acrfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_LIST,cmb_acrfi_tclSemanticDomain::EN_INSTANCESPERCATEGORY));
      }
      else
      {
         cmb_fi_tcl_InstancesPerCategoryList o_InstancesPerCategoryList;
         if (!bDoIt(o_InstancesPerCategoryList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_InstancesPerCategoryList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_InstancesPerCategoryList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_acrfi_tclToken::EN_B16_REQUESTADDINFO:
      {
         cmb_fi_tcl_b16_RequestAddInfo o_b16_RequestAddInfo;
         if (!bDoIt(o_b16_RequestAddInfo))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case cmb_acrfi_tclToken::EN_CHANNELREQUESTSTATUS:
      {
      if (poVisitor->bDoExpand_ChannelRequestStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_END_OF_STRUCT,cmb_acrfi_tclSemanticDomain::EN_UNKNOWN));
         if (2 <= u16MajorVersion)
         {
            (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_B16_REQUESTADDINFO,cmb_acrfi_tclSemanticDomain::EN_REQUESTADDINFO));
         }
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_B8_AUDIOOUTPUTLOCATION,cmb_acrfi_tclSemanticDomain::EN_AUDIOOUTPUTLOCATION));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_B8_AUDIOFORMAT,cmb_acrfi_tclSemanticDomain::EN_AUDIOFORMAT));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_E8_CATSTATUS,cmb_acrfi_tclSemanticDomain::EN_STATUS));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_U8,cmb_acrfi_tclSemanticDomain::EN_INDEX));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_E8_VOICECATEGORY,cmb_acrfi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         cmb_fi_tcl_ChannelRequestStatus o_ChannelRequestStatus;
         if (!bDoIt(o_ChannelRequestStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ChannelRequestStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ChannelRequestStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_acrfi_tclToken::EN_CHANNELREQUESTSTATUSLIST:
      {
      if (poVisitor->bDoExpand_ChannelRequestStatusList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_END_OF_STRUCT,cmb_acrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_CHANNELREQUESTSTATUS,cmb_acrfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(cmb_acrfi_tclKnot(cmb_acrfi_tclToken::EN_LIST,cmb_acrfi_tclSemanticDomain::EN_CHANNELREQUESTSTATUSLIST));
      }
      else
      {
         cmb_fi_tcl_ChannelRequestStatusList o_ChannelRequestStatusList;
         if (!bDoIt(o_ChannelRequestStatusList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ChannelRequestStatusList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ChannelRequestStatusList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case cmb_acrfi_tclToken::EN_UNKNOWN:
      case cmb_acrfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

