/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_TYPES
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_FUNCTIONIDS
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_SERVICEINFO
#include "clock_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for clock_main_fi message types

fi_tclMessageBase* clock_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case clock_mainfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODSTART:
         return OSAL_NEW clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart;

      case clock_mainfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODRESULT:
         return OSAL_NEW clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult;

      case clock_mainfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODSTART:
         return OSAL_NEW clock_mainfi_tclMsgGetTimeDateFromValueMethodStart;

      case clock_mainfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODRESULT:
         return OSAL_NEW clock_mainfi_tclMsgGetTimeDateFromValueMethodResult;

      case clock_mainfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODSTART:
         return OSAL_NEW clock_mainfi_tclMsgGetDaysPerMonthMethodStart;

      case clock_mainfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODRESULT:
         return OSAL_NEW clock_mainfi_tclMsgGetDaysPerMonthMethodResult;

      case clock_mainfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODSTART:
         return OSAL_NEW clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart;

      case clock_mainfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODRESULT:
         return OSAL_NEW clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult;

      case clock_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODSTART:
         return OSAL_NEW clock_mainfi_tclMsgResetHistoryMethodStart;

      case clock_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODRESULT:
         return OSAL_NEW clock_mainfi_tclMsgResetHistoryMethodResult;

      case clock_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODSTART:
         return OSAL_NEW clock_mainfi_tclMsgVersionInfoMethodStart;

      case clock_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODRESULT:
         return OSAL_NEW clock_mainfi_tclMsgVersionInfoMethodResult;

      case clock_mainfi_tclToken::EN_MSG_TIMEZONEGET:
         return OSAL_NEW clock_mainfi_tclMsgTimeZoneGet;

      case clock_mainfi_tclToken::EN_MSG_TIMEZONESET:
         return OSAL_NEW clock_mainfi_tclMsgTimeZoneSet;

      case clock_mainfi_tclToken::EN_MSG_TIMEZONEUPREG:
         return OSAL_NEW clock_mainfi_tclMsgTimeZoneUpReg;

      case clock_mainfi_tclToken::EN_MSG_TIMEZONERELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgTimeZoneRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_TIMEZONESTATUS:
         return OSAL_NEW clock_mainfi_tclMsgTimeZoneStatus;

      case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEGET:
         return OSAL_NEW clock_mainfi_tclMsgDaylightSavingTimeGet;

      case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESET:
         return OSAL_NEW clock_mainfi_tclMsgDaylightSavingTimeSet;

      case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEUPREG:
         return OSAL_NEW clock_mainfi_tclMsgDaylightSavingTimeUpReg;

      case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMERELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgDaylightSavingTimeRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESTATUS:
         return OSAL_NEW clock_mainfi_tclMsgDaylightSavingTimeStatus;

      case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCGET:
         return OSAL_NEW clock_mainfi_tclMsgGPS_AutoSyncGet;

      case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCSET:
         return OSAL_NEW clock_mainfi_tclMsgGPS_AutoSyncSet;

      case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCUPREG:
         return OSAL_NEW clock_mainfi_tclMsgGPS_AutoSyncUpReg;

      case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgGPS_AutoSyncRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgGPS_AutoSyncStatus;

      case clock_mainfi_tclToken::EN_MSG_SYNCMODEGET:
         return OSAL_NEW clock_mainfi_tclMsgSyncModeGet;

      case clock_mainfi_tclToken::EN_MSG_SYNCMODESET:
         return OSAL_NEW clock_mainfi_tclMsgSyncModeSet;

      case clock_mainfi_tclToken::EN_MSG_SYNCMODEUPREG:
         return OSAL_NEW clock_mainfi_tclMsgSyncModeUpReg;

      case clock_mainfi_tclToken::EN_MSG_SYNCMODERELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgSyncModeRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_SYNCMODESTATUS:
         return OSAL_NEW clock_mainfi_tclMsgSyncModeStatus;

      case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHGET:
         return OSAL_NEW clock_mainfi_tclMsgGPS_WeekEpochGet;

      case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHSET:
         return OSAL_NEW clock_mainfi_tclMsgGPS_WeekEpochSet;

      case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHUPREG:
         return OSAL_NEW clock_mainfi_tclMsgGPS_WeekEpochUpReg;

      case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgGPS_WeekEpochRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgGPS_WeekEpochStatus;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETUPREG:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeOffsetUpReg;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeOffsetRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETGET:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeOffsetGet;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeOffsetStatus;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETSET:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeOffsetSet;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATEUPREG:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeDateUpReg;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATERELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeDateRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATEGET:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeDateGet;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATESTATUS:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeDateStatus;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATESET:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeDateSet;

      case clock_mainfi_tclToken::EN_MSG_TIMEFORMATUPREG:
         return OSAL_NEW clock_mainfi_tclMsgTimeFormatUpReg;

      case clock_mainfi_tclToken::EN_MSG_TIMEFORMATRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgTimeFormatRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_TIMEFORMATGET:
         return OSAL_NEW clock_mainfi_tclMsgTimeFormatGet;

      case clock_mainfi_tclToken::EN_MSG_TIMEFORMATSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgTimeFormatStatus;

      case clock_mainfi_tclToken::EN_MSG_TIMEFORMATSET:
         return OSAL_NEW clock_mainfi_tclMsgTimeFormatSet;

      case clock_mainfi_tclToken::EN_MSG_DATEFORMATUPREG:
         return OSAL_NEW clock_mainfi_tclMsgDateFormatUpReg;

      case clock_mainfi_tclToken::EN_MSG_DATEFORMATRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgDateFormatRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_DATEFORMATGET:
         return OSAL_NEW clock_mainfi_tclMsgDateFormatGet;

      case clock_mainfi_tclToken::EN_MSG_DATEFORMATSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgDateFormatStatus;

      case clock_mainfi_tclToken::EN_MSG_DATEFORMATSET:
         return OSAL_NEW clock_mainfi_tclMsgDateFormatSet;

      case clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSUPREG:
         return OSAL_NEW clock_mainfi_tclMsgClockSourceStatusUpReg;

      case clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgClockSourceStatusRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSGET:
         return OSAL_NEW clock_mainfi_tclMsgClockSourceStatusGet;

      case clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgClockSourceStatusStatus;

      case clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSUPREG:
         return OSAL_NEW clock_mainfi_tclMsgFormatSourceStatusUpReg;

      case clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgFormatSourceStatusRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSGET:
         return OSAL_NEW clock_mainfi_tclMsgFormatSourceStatusGet;

      case clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgFormatSourceStatusStatus;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATEUPREG:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateUpReg;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATERELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATEGET:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateGet;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATESTATUS:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus;

      case clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATESET:
         return OSAL_NEW clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet;

      case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONEGET:
         return OSAL_NEW clock_mainfi_tclMsgRegion_TimeZoneGet;

      case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONESET:
         return OSAL_NEW clock_mainfi_tclMsgRegion_TimeZoneSet;

      case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONEUPREG:
         return OSAL_NEW clock_mainfi_tclMsgRegion_TimeZoneUpReg;

      case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONERELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgRegion_TimeZoneRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONESTATUS:
         return OSAL_NEW clock_mainfi_tclMsgRegion_TimeZoneStatus;

      case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETUPREG:
         return OSAL_NEW clock_mainfi_tclMsgAuto_TimeZoneOffsetUpReg;

      case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgAuto_TimeZoneOffsetRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETGET:
         return OSAL_NEW clock_mainfi_tclMsgAuto_TimeZoneOffsetGet;

      case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus;

      case clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETSET:
         return OSAL_NEW clock_mainfi_tclMsgAuto_TimeZoneOffsetSet;

      case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATUPREG:
         return OSAL_NEW clock_mainfi_tclMsgNewDateFormatUpReg;

      case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgNewDateFormatRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATGET:
         return OSAL_NEW clock_mainfi_tclMsgNewDateFormatGet;

      case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgNewDateFormatStatus;

      case clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATSET:
         return OSAL_NEW clock_mainfi_tclMsgNewDateFormatSet;

      case clock_mainfi_tclToken::EN_MSG_CONNECTIONUPREG:
         return OSAL_NEW clock_mainfi_tclMsgConnectionUpReg;

      case clock_mainfi_tclToken::EN_MSG_CONNECTIONRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgConnectionRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_CONNECTIONGET:
         return OSAL_NEW clock_mainfi_tclMsgConnectionGet;

      case clock_mainfi_tclToken::EN_MSG_CONNECTIONSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgConnectionStatus;

      case clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYUPREG:
         return OSAL_NEW clock_mainfi_tclMsgTimeZone_DSTAvailabilityUpReg;

      case clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgTimeZone_DSTAvailabilityRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYGET:
         return OSAL_NEW clock_mainfi_tclMsgTimeZone_DSTAvailabilityGet;

      case clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus;

      case clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONUPREG:
         return OSAL_NEW clock_mainfi_tclMsgHardwareVersionUpReg;

      case clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgHardwareVersionRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONGET:
         return OSAL_NEW clock_mainfi_tclMsgHardwareVersionGet;

      case clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgHardwareVersionStatus;

      case clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONUPREG:
         return OSAL_NEW clock_mainfi_tclMsgSoftwareVersionUpReg;

      case clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgSoftwareVersionRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONGET:
         return OSAL_NEW clock_mainfi_tclMsgSoftwareVersionGet;

      case clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgSoftwareVersionStatus;

      case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATEUPREG:
         return OSAL_NEW clock_mainfi_tclMsgDebugMode_TimeDateUpReg;

      case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATERELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgDebugMode_TimeDateRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATEGET:
         return OSAL_NEW clock_mainfi_tclMsgDebugMode_TimeDateGet;

      case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATESTATUS:
         return OSAL_NEW clock_mainfi_tclMsgDebugMode_TimeDateStatus;

      case clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATESET:
         return OSAL_NEW clock_mainfi_tclMsgDebugMode_TimeDateSet;

      case clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATEUPREG:
         return OSAL_NEW clock_mainfi_tclMsgUTC_TimeDateUpdateUpReg;

      case clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATERELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgUTC_TimeDateUpdateRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATEGET:
         return OSAL_NEW clock_mainfi_tclMsgUTC_TimeDateUpdateGet;

      case clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATESTATUS:
         return OSAL_NEW clock_mainfi_tclMsgUTC_TimeDateUpdateStatus;

      case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONGET:
         return OSAL_NEW clock_mainfi_tclMsgHUD_ActivationGet;

      case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONSET:
         return OSAL_NEW clock_mainfi_tclMsgHUD_ActivationSet;

      case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONUPREG:
         return OSAL_NEW clock_mainfi_tclMsgHUD_ActivationUpReg;

      case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgHUD_ActivationRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgHUD_ActivationStatus;

      case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONUPREG:
         return OSAL_NEW clock_mainfi_tclMsgHUD_PostitionUpReg;

      case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONRELUPREG:
         return OSAL_NEW clock_mainfi_tclMsgHUD_PostitionRelUpReg;

      case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONGET:
         return OSAL_NEW clock_mainfi_tclMsgHUD_PostitionGet;

      case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONSTATUS:
         return OSAL_NEW clock_mainfi_tclMsgHUD_PostitionStatus;

      case clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONSET:
         return OSAL_NEW clock_mainfi_tclMsgHUD_PostitionSet;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all clock_mainfifi messages

// common functions

tU16 clock_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return CLOCK_MAINFI_C_U16_SERVICE_ID;
}

tU16 clock_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 clock_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& clock_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& clock_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 clock_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& clock_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& clock_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart::clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart()
 {}

tS32 clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODSTART;
}


clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart::~clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult::clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult(const clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   aszDescriptions = coRef.aszDescriptions;
   u16Indexes = coRef.u16Indexes;
}
clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult& clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult::operator=(const clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   aszDescriptions = coRef.aszDescriptions;
   u16Indexes = coRef.u16Indexes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aszDescriptions.size(); ++u32Idx)
         aszDescriptions[u32Idx].vDestroy();
   aszDescriptions.clear();
   }
   {
   u16Indexes.clear();
   }
}

clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult::clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult()


 {}

tS32 clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODRESULT;
}


clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult::~clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aszDescriptions.size(); ++u32ListIdx)
      u32DynamicSize += aszDescriptions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+ static_cast<tU32>(u16Indexes.size()*2);
}

fi_tclInContext& clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aszDescriptions.size(); ++u32Idx)
      {
         aszDescriptions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      aszDescriptions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> aszDescriptions[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      u16Indexes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> u16Indexes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)aszDescriptions.size());
   {
      for (tU32 u32Idx = 0; u32Idx < aszDescriptions.size(); ++u32Idx)
         (tVoid) (oOut << aszDescriptions[u32Idx]);
   }
   (tVoid) (oOut << (tU32)u16Indexes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < u16Indexes.size(); ++u32Idx)
         (tVoid) (oOut << u16Indexes[u32Idx]);
   }
   return oOut;
}

tBool clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult::operator==(const clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (aszDescriptions.size() == roRef.aszDescriptions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aszDescriptions.size()); ++u32Idx)
            bResult = bResult && (aszDescriptions[u32Idx] == roRef.aszDescriptions[u32Idx]);
      }
      bResult = bResult && (u16Indexes.size() == roRef.u16Indexes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < u16Indexes.size()); ++u32Idx)
            bResult = bResult && (u16Indexes[u32Idx] == roRef.u16Indexes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgGetTimeDateFromValueMethodStart::clock_mainfi_tclMsgGetTimeDateFromValueMethodStart(const clock_mainfi_tclMsgGetTimeDateFromValueMethodStart& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   u32TimeDateValue = coRef.u32TimeDateValue;
   u8SourceDomain = coRef.u8SourceDomain;
   u8TargetDomain = coRef.u8TargetDomain;
}
clock_mainfi_tclMsgGetTimeDateFromValueMethodStart& clock_mainfi_tclMsgGetTimeDateFromValueMethodStart::operator=(const clock_mainfi_tclMsgGetTimeDateFromValueMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32TimeDateValue = coRef.u32TimeDateValue;
   u8SourceDomain = coRef.u8SourceDomain;
   u8TargetDomain = coRef.u8TargetDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgGetTimeDateFromValueMethodStart::clock_mainfi_tclMsgGetTimeDateFromValueMethodStart()
:u32TimeDateValue(0)
,u8SourceDomain(1)
,u8TargetDomain(1)
 {}

tS32 clock_mainfi_tclMsgGetTimeDateFromValueMethodStart::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODSTART;
}


clock_mainfi_tclMsgGetTimeDateFromValueMethodStart::~clock_mainfi_tclMsgGetTimeDateFromValueMethodStart()
{}

tU32 clock_mainfi_tclMsgGetTimeDateFromValueMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& clock_mainfi_tclMsgGetTimeDateFromValueMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32TimeDateValue);
   (tVoid) (oIn >> u8SourceDomain);
   (tVoid) (oIn >> u8TargetDomain);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgGetTimeDateFromValueMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32TimeDateValue);
   (tVoid) (oOut << u8SourceDomain);
   (tVoid) (oOut << u8TargetDomain);
   return oOut;
}

tBool clock_mainfi_tclMsgGetTimeDateFromValueMethodStart::operator==(const clock_mainfi_tclMsgGetTimeDateFromValueMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32TimeDateValue == roRef.u32TimeDateValue);
   bResult = bResult && (u8SourceDomain == roRef.u8SourceDomain);
   bResult = bResult && (u8TargetDomain == roRef.u8TargetDomain);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgGetTimeDateFromValueMethodResult::clock_mainfi_tclMsgGetTimeDateFromValueMethodResult(const clock_mainfi_tclMsgGetTimeDateFromValueMethodResult& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
}
clock_mainfi_tclMsgGetTimeDateFromValueMethodResult& clock_mainfi_tclMsgGetTimeDateFromValueMethodResult::operator=(const clock_mainfi_tclMsgGetTimeDateFromValueMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgGetTimeDateFromValueMethodResult::clock_mainfi_tclMsgGetTimeDateFromValueMethodResult()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hours(0)
,u8Minutes(0)
,u8Seconds(0)
,u8Weekday(0)
 {}

tS32 clock_mainfi_tclMsgGetTimeDateFromValueMethodResult::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODRESULT;
}


clock_mainfi_tclMsgGetTimeDateFromValueMethodResult::~clock_mainfi_tclMsgGetTimeDateFromValueMethodResult()
{}

tU32 clock_mainfi_tclMsgGetTimeDateFromValueMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& clock_mainfi_tclMsgGetTimeDateFromValueMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hours);
   (tVoid) (oIn >> u8Minutes);
   (tVoid) (oIn >> u8Seconds);
   (tVoid) (oIn >> u8Weekday);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgGetTimeDateFromValueMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hours);
   (tVoid) (oOut << u8Minutes);
   (tVoid) (oOut << u8Seconds);
   (tVoid) (oOut << u8Weekday);
   return oOut;
}

tBool clock_mainfi_tclMsgGetTimeDateFromValueMethodResult::operator==(const clock_mainfi_tclMsgGetTimeDateFromValueMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hours == roRef.u8Hours);
   bResult = bResult && (u8Minutes == roRef.u8Minutes);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   bResult = bResult && (u8Weekday == roRef.u8Weekday);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgGetDaysPerMonthMethodStart::clock_mainfi_tclMsgGetDaysPerMonthMethodStart(const clock_mainfi_tclMsgGetDaysPerMonthMethodStart& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
}
clock_mainfi_tclMsgGetDaysPerMonthMethodStart& clock_mainfi_tclMsgGetDaysPerMonthMethodStart::operator=(const clock_mainfi_tclMsgGetDaysPerMonthMethodStart& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgGetDaysPerMonthMethodStart::clock_mainfi_tclMsgGetDaysPerMonthMethodStart()
:s16Year(0)
,u8Month(0)
 {}

tS32 clock_mainfi_tclMsgGetDaysPerMonthMethodStart::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODSTART;
}


clock_mainfi_tclMsgGetDaysPerMonthMethodStart::~clock_mainfi_tclMsgGetDaysPerMonthMethodStart()
{}

tU32 clock_mainfi_tclMsgGetDaysPerMonthMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& clock_mainfi_tclMsgGetDaysPerMonthMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgGetDaysPerMonthMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   return oOut;
}

tBool clock_mainfi_tclMsgGetDaysPerMonthMethodStart::operator==(const clock_mainfi_tclMsgGetDaysPerMonthMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgGetDaysPerMonthMethodResult::clock_mainfi_tclMsgGetDaysPerMonthMethodResult(const clock_mainfi_tclMsgGetDaysPerMonthMethodResult& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   u8NumberOfDays = coRef.u8NumberOfDays;
}
clock_mainfi_tclMsgGetDaysPerMonthMethodResult& clock_mainfi_tclMsgGetDaysPerMonthMethodResult::operator=(const clock_mainfi_tclMsgGetDaysPerMonthMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8NumberOfDays = coRef.u8NumberOfDays;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgGetDaysPerMonthMethodResult::clock_mainfi_tclMsgGetDaysPerMonthMethodResult()
:u8NumberOfDays(0)
 {}

tS32 clock_mainfi_tclMsgGetDaysPerMonthMethodResult::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODRESULT;
}


clock_mainfi_tclMsgGetDaysPerMonthMethodResult::~clock_mainfi_tclMsgGetDaysPerMonthMethodResult()
{}

tU32 clock_mainfi_tclMsgGetDaysPerMonthMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgGetDaysPerMonthMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumberOfDays);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgGetDaysPerMonthMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumberOfDays);
   return oOut;
}

tBool clock_mainfi_tclMsgGetDaysPerMonthMethodResult::operator==(const clock_mainfi_tclMsgGetDaysPerMonthMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumberOfDays == roRef.u8NumberOfDays);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart(const clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
}
clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::operator=(const clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart()
:DefSetStateGroup()
,DefSetStateMode()
 {}

tS32 clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODSTART;
}


clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::~clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart()
{}

tU32 clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   return oOut;
}

tBool clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::operator==(const clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult(const clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   Status = coRef.Status;
}
clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::operator=(const clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult()
:DefSetStateGroup()
,DefSetStateMode()
,Status(0)
 {}

tS32 clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODRESULT;
}


clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::~clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult()
{}

tU32 clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::operator==(const clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgResetHistoryMethodStart::clock_mainfi_tclMsgResetHistoryMethodStart()
 {}

tS32 clock_mainfi_tclMsgResetHistoryMethodStart::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODSTART;
}


clock_mainfi_tclMsgResetHistoryMethodStart::~clock_mainfi_tclMsgResetHistoryMethodStart()
{}

//=============================================================================

clock_mainfi_tclMsgResetHistoryMethodResult::clock_mainfi_tclMsgResetHistoryMethodResult()
 {}

tS32 clock_mainfi_tclMsgResetHistoryMethodResult::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODRESULT;
}


clock_mainfi_tclMsgResetHistoryMethodResult::~clock_mainfi_tclMsgResetHistoryMethodResult()
{}

//=============================================================================

clock_mainfi_tclMsgVersionInfoMethodStart::clock_mainfi_tclMsgVersionInfoMethodStart()
 {}

tS32 clock_mainfi_tclMsgVersionInfoMethodStart::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODSTART;
}


clock_mainfi_tclMsgVersionInfoMethodStart::~clock_mainfi_tclMsgVersionInfoMethodStart()
{}

//=============================================================================

clock_mainfi_tclMsgVersionInfoMethodResult::clock_mainfi_tclMsgVersionInfoMethodResult()
 {}

tS32 clock_mainfi_tclMsgVersionInfoMethodResult::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODRESULT;
}


clock_mainfi_tclMsgVersionInfoMethodResult::~clock_mainfi_tclMsgVersionInfoMethodResult()
{}

//=============================================================================

clock_mainfi_tclMsgTimeZoneGet::clock_mainfi_tclMsgTimeZoneGet()
 {}

tS32 clock_mainfi_tclMsgTimeZoneGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEZONEGET;
}


clock_mainfi_tclMsgTimeZoneGet::~clock_mainfi_tclMsgTimeZoneGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgTimeZoneSet::clock_mainfi_tclMsgTimeZoneSet(const clock_mainfi_tclMsgTimeZoneSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   u16Index = coRef.u16Index;
}
clock_mainfi_tclMsgTimeZoneSet& clock_mainfi_tclMsgTimeZoneSet::operator=(const clock_mainfi_tclMsgTimeZoneSet& coRef)
{
   if (this == &coRef) return *this;
   u16Index = coRef.u16Index;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgTimeZoneSet::clock_mainfi_tclMsgTimeZoneSet()
:u16Index(0)
 {}

tS32 clock_mainfi_tclMsgTimeZoneSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEZONESET;
}


clock_mainfi_tclMsgTimeZoneSet::~clock_mainfi_tclMsgTimeZoneSet()
{}

tU32 clock_mainfi_tclMsgTimeZoneSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& clock_mainfi_tclMsgTimeZoneSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16Index);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgTimeZoneSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16Index);
   return oOut;
}

tBool clock_mainfi_tclMsgTimeZoneSet::operator==(const clock_mainfi_tclMsgTimeZoneSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16Index == roRef.u16Index);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgTimeZoneUpReg::clock_mainfi_tclMsgTimeZoneUpReg()
 {}

tS32 clock_mainfi_tclMsgTimeZoneUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEZONEUPREG;
}


clock_mainfi_tclMsgTimeZoneUpReg::~clock_mainfi_tclMsgTimeZoneUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgTimeZoneRelUpReg::clock_mainfi_tclMsgTimeZoneRelUpReg()
 {}

tS32 clock_mainfi_tclMsgTimeZoneRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEZONERELUPREG;
}


clock_mainfi_tclMsgTimeZoneRelUpReg::~clock_mainfi_tclMsgTimeZoneRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgTimeZoneStatus::clock_mainfi_tclMsgTimeZoneStatus(const clock_mainfi_tclMsgTimeZoneStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   u16Index = coRef.u16Index;
   szDescription = coRef.szDescription;
}
clock_mainfi_tclMsgTimeZoneStatus& clock_mainfi_tclMsgTimeZoneStatus::operator=(const clock_mainfi_tclMsgTimeZoneStatus& coRef)
{
   if (this == &coRef) return *this;
   u16Index = coRef.u16Index;
   szDescription = coRef.szDescription;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid clock_mainfi_tclMsgTimeZoneStatus::vDestroy()
{
   szDescription.vDestroy();
}

clock_mainfi_tclMsgTimeZoneStatus::clock_mainfi_tclMsgTimeZoneStatus()
:u16Index(0)
,szDescription()
 {}

tS32 clock_mainfi_tclMsgTimeZoneStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEZONESTATUS;
}


clock_mainfi_tclMsgTimeZoneStatus::~clock_mainfi_tclMsgTimeZoneStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 clock_mainfi_tclMsgTimeZoneStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDescription.u32GetSize(u16MajorVersion);
}

fi_tclInContext& clock_mainfi_tclMsgTimeZoneStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16Index);
   (tVoid) (oIn >> szDescription);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgTimeZoneStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16Index);
   (tVoid) (oOut << szDescription);
   return oOut;
}

tBool clock_mainfi_tclMsgTimeZoneStatus::operator==(const clock_mainfi_tclMsgTimeZoneStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16Index == roRef.u16Index);
   bResult = bResult && (szDescription == roRef.szDescription);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgDaylightSavingTimeGet::clock_mainfi_tclMsgDaylightSavingTimeGet()
 {}

tS32 clock_mainfi_tclMsgDaylightSavingTimeGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEGET;
}


clock_mainfi_tclMsgDaylightSavingTimeGet::~clock_mainfi_tclMsgDaylightSavingTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgDaylightSavingTimeSet::clock_mainfi_tclMsgDaylightSavingTimeSet(const clock_mainfi_tclMsgDaylightSavingTimeSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enDST_Setting = coRef.enDST_Setting;
}
clock_mainfi_tclMsgDaylightSavingTimeSet& clock_mainfi_tclMsgDaylightSavingTimeSet::operator=(const clock_mainfi_tclMsgDaylightSavingTimeSet& coRef)
{
   if (this == &coRef) return *this;
   enDST_Setting = coRef.enDST_Setting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgDaylightSavingTimeSet::clock_mainfi_tclMsgDaylightSavingTimeSet()
:enDST_Setting()
 {}

tS32 clock_mainfi_tclMsgDaylightSavingTimeSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESET;
}


clock_mainfi_tclMsgDaylightSavingTimeSet::~clock_mainfi_tclMsgDaylightSavingTimeSet()
{}

tU32 clock_mainfi_tclMsgDaylightSavingTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgDaylightSavingTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enDST_Setting);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgDaylightSavingTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enDST_Setting);
   return oOut;
}

tBool clock_mainfi_tclMsgDaylightSavingTimeSet::operator==(const clock_mainfi_tclMsgDaylightSavingTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enDST_Setting == roRef.enDST_Setting);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgDaylightSavingTimeUpReg::clock_mainfi_tclMsgDaylightSavingTimeUpReg()
 {}

tS32 clock_mainfi_tclMsgDaylightSavingTimeUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEUPREG;
}


clock_mainfi_tclMsgDaylightSavingTimeUpReg::~clock_mainfi_tclMsgDaylightSavingTimeUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgDaylightSavingTimeRelUpReg::clock_mainfi_tclMsgDaylightSavingTimeRelUpReg()
 {}

tS32 clock_mainfi_tclMsgDaylightSavingTimeRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMERELUPREG;
}


clock_mainfi_tclMsgDaylightSavingTimeRelUpReg::~clock_mainfi_tclMsgDaylightSavingTimeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgDaylightSavingTimeStatus::clock_mainfi_tclMsgDaylightSavingTimeStatus(const clock_mainfi_tclMsgDaylightSavingTimeStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   bDST_Status = coRef.bDST_Status;
   bDST_AutoAdjust = coRef.bDST_AutoAdjust;
   enDST_Status = coRef.enDST_Status;
}
clock_mainfi_tclMsgDaylightSavingTimeStatus& clock_mainfi_tclMsgDaylightSavingTimeStatus::operator=(const clock_mainfi_tclMsgDaylightSavingTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   bDST_Status = coRef.bDST_Status;
   bDST_AutoAdjust = coRef.bDST_AutoAdjust;
   enDST_Status = coRef.enDST_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgDaylightSavingTimeStatus::clock_mainfi_tclMsgDaylightSavingTimeStatus()
:bDST_Status(0)
,bDST_AutoAdjust(0)
,enDST_Status()
 {}

tS32 clock_mainfi_tclMsgDaylightSavingTimeStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESTATUS;
}


clock_mainfi_tclMsgDaylightSavingTimeStatus::~clock_mainfi_tclMsgDaylightSavingTimeStatus()
{}

tU32 clock_mainfi_tclMsgDaylightSavingTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& clock_mainfi_tclMsgDaylightSavingTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDST_Status);
   (tVoid) (oIn >> bDST_AutoAdjust);
   (tVoid) (oIn >> enDST_Status);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgDaylightSavingTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDST_Status);
   (tVoid) (oOut << bDST_AutoAdjust);
   (tVoid) (oOut << enDST_Status);
   return oOut;
}

tBool clock_mainfi_tclMsgDaylightSavingTimeStatus::operator==(const clock_mainfi_tclMsgDaylightSavingTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDST_Status == roRef.bDST_Status);
   bResult = bResult && (bDST_AutoAdjust == roRef.bDST_AutoAdjust);
   bResult = bResult && (enDST_Status == roRef.enDST_Status);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgGPS_AutoSyncGet::clock_mainfi_tclMsgGPS_AutoSyncGet()
 {}

tS32 clock_mainfi_tclMsgGPS_AutoSyncGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCGET;
}


clock_mainfi_tclMsgGPS_AutoSyncGet::~clock_mainfi_tclMsgGPS_AutoSyncGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgGPS_AutoSyncSet::clock_mainfi_tclMsgGPS_AutoSyncSet(const clock_mainfi_tclMsgGPS_AutoSyncSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   bEnabled = coRef.bEnabled;
   bPositionBased = coRef.bPositionBased;
}
clock_mainfi_tclMsgGPS_AutoSyncSet& clock_mainfi_tclMsgGPS_AutoSyncSet::operator=(const clock_mainfi_tclMsgGPS_AutoSyncSet& coRef)
{
   if (this == &coRef) return *this;
   bEnabled = coRef.bEnabled;
   bPositionBased = coRef.bPositionBased;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgGPS_AutoSyncSet::clock_mainfi_tclMsgGPS_AutoSyncSet()
:bEnabled(0)
,bPositionBased(0)
 {}

tS32 clock_mainfi_tclMsgGPS_AutoSyncSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCSET;
}


clock_mainfi_tclMsgGPS_AutoSyncSet::~clock_mainfi_tclMsgGPS_AutoSyncSet()
{}

tU32 clock_mainfi_tclMsgGPS_AutoSyncSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& clock_mainfi_tclMsgGPS_AutoSyncSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnabled);
   (tVoid) (oIn >> bPositionBased);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgGPS_AutoSyncSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnabled);
   (tVoid) (oOut << bPositionBased);
   return oOut;
}

tBool clock_mainfi_tclMsgGPS_AutoSyncSet::operator==(const clock_mainfi_tclMsgGPS_AutoSyncSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnabled == roRef.bEnabled);
   bResult = bResult && (bPositionBased == roRef.bPositionBased);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgGPS_AutoSyncUpReg::clock_mainfi_tclMsgGPS_AutoSyncUpReg()
 {}

tS32 clock_mainfi_tclMsgGPS_AutoSyncUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCUPREG;
}


clock_mainfi_tclMsgGPS_AutoSyncUpReg::~clock_mainfi_tclMsgGPS_AutoSyncUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgGPS_AutoSyncRelUpReg::clock_mainfi_tclMsgGPS_AutoSyncRelUpReg()
 {}

tS32 clock_mainfi_tclMsgGPS_AutoSyncRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCRELUPREG;
}


clock_mainfi_tclMsgGPS_AutoSyncRelUpReg::~clock_mainfi_tclMsgGPS_AutoSyncRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgGPS_AutoSyncStatus::clock_mainfi_tclMsgGPS_AutoSyncStatus(const clock_mainfi_tclMsgGPS_AutoSyncStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   bEnabled = coRef.bEnabled;
   bPositionBased = coRef.bPositionBased;
}
clock_mainfi_tclMsgGPS_AutoSyncStatus& clock_mainfi_tclMsgGPS_AutoSyncStatus::operator=(const clock_mainfi_tclMsgGPS_AutoSyncStatus& coRef)
{
   if (this == &coRef) return *this;
   bEnabled = coRef.bEnabled;
   bPositionBased = coRef.bPositionBased;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgGPS_AutoSyncStatus::clock_mainfi_tclMsgGPS_AutoSyncStatus()
:bEnabled(0)
,bPositionBased(0)
 {}

tS32 clock_mainfi_tclMsgGPS_AutoSyncStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GPS_AUTOSYNCSTATUS;
}


clock_mainfi_tclMsgGPS_AutoSyncStatus::~clock_mainfi_tclMsgGPS_AutoSyncStatus()
{}

tU32 clock_mainfi_tclMsgGPS_AutoSyncStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& clock_mainfi_tclMsgGPS_AutoSyncStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnabled);
   (tVoid) (oIn >> bPositionBased);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgGPS_AutoSyncStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnabled);
   (tVoid) (oOut << bPositionBased);
   return oOut;
}

tBool clock_mainfi_tclMsgGPS_AutoSyncStatus::operator==(const clock_mainfi_tclMsgGPS_AutoSyncStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnabled == roRef.bEnabled);
   bResult = bResult && (bPositionBased == roRef.bPositionBased);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgSyncModeGet::clock_mainfi_tclMsgSyncModeGet()
 {}

tS32 clock_mainfi_tclMsgSyncModeGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_SYNCMODEGET;
}


clock_mainfi_tclMsgSyncModeGet::~clock_mainfi_tclMsgSyncModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgSyncModeSet::clock_mainfi_tclMsgSyncModeSet(const clock_mainfi_tclMsgSyncModeSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enMode = coRef.enMode;
}
clock_mainfi_tclMsgSyncModeSet& clock_mainfi_tclMsgSyncModeSet::operator=(const clock_mainfi_tclMsgSyncModeSet& coRef)
{
   if (this == &coRef) return *this;
   enMode = coRef.enMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgSyncModeSet::clock_mainfi_tclMsgSyncModeSet()
:enMode()
 {}

tS32 clock_mainfi_tclMsgSyncModeSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_SYNCMODESET;
}


clock_mainfi_tclMsgSyncModeSet::~clock_mainfi_tclMsgSyncModeSet()
{}

tU32 clock_mainfi_tclMsgSyncModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgSyncModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enMode);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgSyncModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enMode);
   return oOut;
}

tBool clock_mainfi_tclMsgSyncModeSet::operator==(const clock_mainfi_tclMsgSyncModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enMode == roRef.enMode);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgSyncModeUpReg::clock_mainfi_tclMsgSyncModeUpReg()
 {}

tS32 clock_mainfi_tclMsgSyncModeUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_SYNCMODEUPREG;
}


clock_mainfi_tclMsgSyncModeUpReg::~clock_mainfi_tclMsgSyncModeUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgSyncModeRelUpReg::clock_mainfi_tclMsgSyncModeRelUpReg()
 {}

tS32 clock_mainfi_tclMsgSyncModeRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_SYNCMODERELUPREG;
}


clock_mainfi_tclMsgSyncModeRelUpReg::~clock_mainfi_tclMsgSyncModeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgSyncModeStatus::clock_mainfi_tclMsgSyncModeStatus(const clock_mainfi_tclMsgSyncModeStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enMode = coRef.enMode;
}
clock_mainfi_tclMsgSyncModeStatus& clock_mainfi_tclMsgSyncModeStatus::operator=(const clock_mainfi_tclMsgSyncModeStatus& coRef)
{
   if (this == &coRef) return *this;
   enMode = coRef.enMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgSyncModeStatus::clock_mainfi_tclMsgSyncModeStatus()
:enMode()
 {}

tS32 clock_mainfi_tclMsgSyncModeStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_SYNCMODESTATUS;
}


clock_mainfi_tclMsgSyncModeStatus::~clock_mainfi_tclMsgSyncModeStatus()
{}

tU32 clock_mainfi_tclMsgSyncModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgSyncModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enMode);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgSyncModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enMode);
   return oOut;
}

tBool clock_mainfi_tclMsgSyncModeStatus::operator==(const clock_mainfi_tclMsgSyncModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enMode == roRef.enMode);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgGPS_WeekEpochGet::clock_mainfi_tclMsgGPS_WeekEpochGet()
 {}

tS32 clock_mainfi_tclMsgGPS_WeekEpochGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHGET;
}


clock_mainfi_tclMsgGPS_WeekEpochGet::~clock_mainfi_tclMsgGPS_WeekEpochGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgGPS_WeekEpochSet::clock_mainfi_tclMsgGPS_WeekEpochSet(const clock_mainfi_tclMsgGPS_WeekEpochSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   GPSepoch = coRef.GPSepoch;
}
clock_mainfi_tclMsgGPS_WeekEpochSet& clock_mainfi_tclMsgGPS_WeekEpochSet::operator=(const clock_mainfi_tclMsgGPS_WeekEpochSet& coRef)
{
   if (this == &coRef) return *this;
   GPSepoch = coRef.GPSepoch;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgGPS_WeekEpochSet::clock_mainfi_tclMsgGPS_WeekEpochSet()
:GPSepoch()
 {}

tS32 clock_mainfi_tclMsgGPS_WeekEpochSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHSET;
}


clock_mainfi_tclMsgGPS_WeekEpochSet::~clock_mainfi_tclMsgGPS_WeekEpochSet()
{}

tU32 clock_mainfi_tclMsgGPS_WeekEpochSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgGPS_WeekEpochSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GPSepoch);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgGPS_WeekEpochSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GPSepoch);
   return oOut;
}

tBool clock_mainfi_tclMsgGPS_WeekEpochSet::operator==(const clock_mainfi_tclMsgGPS_WeekEpochSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GPSepoch == roRef.GPSepoch);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgGPS_WeekEpochUpReg::clock_mainfi_tclMsgGPS_WeekEpochUpReg()
 {}

tS32 clock_mainfi_tclMsgGPS_WeekEpochUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHUPREG;
}


clock_mainfi_tclMsgGPS_WeekEpochUpReg::~clock_mainfi_tclMsgGPS_WeekEpochUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgGPS_WeekEpochRelUpReg::clock_mainfi_tclMsgGPS_WeekEpochRelUpReg()
 {}

tS32 clock_mainfi_tclMsgGPS_WeekEpochRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHRELUPREG;
}


clock_mainfi_tclMsgGPS_WeekEpochRelUpReg::~clock_mainfi_tclMsgGPS_WeekEpochRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgGPS_WeekEpochStatus::clock_mainfi_tclMsgGPS_WeekEpochStatus(const clock_mainfi_tclMsgGPS_WeekEpochStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   GPSepoch = coRef.GPSepoch;
}
clock_mainfi_tclMsgGPS_WeekEpochStatus& clock_mainfi_tclMsgGPS_WeekEpochStatus::operator=(const clock_mainfi_tclMsgGPS_WeekEpochStatus& coRef)
{
   if (this == &coRef) return *this;
   GPSepoch = coRef.GPSepoch;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgGPS_WeekEpochStatus::clock_mainfi_tclMsgGPS_WeekEpochStatus()
:GPSepoch()
 {}

tS32 clock_mainfi_tclMsgGPS_WeekEpochStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_GPS_WEEKEPOCHSTATUS;
}


clock_mainfi_tclMsgGPS_WeekEpochStatus::~clock_mainfi_tclMsgGPS_WeekEpochStatus()
{}

tU32 clock_mainfi_tclMsgGPS_WeekEpochStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgGPS_WeekEpochStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GPSepoch);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgGPS_WeekEpochStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GPSepoch);
   return oOut;
}

tBool clock_mainfi_tclMsgGPS_WeekEpochStatus::operator==(const clock_mainfi_tclMsgGPS_WeekEpochStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GPSepoch == roRef.GPSepoch);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgLocalTimeOffsetUpReg::clock_mainfi_tclMsgLocalTimeOffsetUpReg()
 {}

tS32 clock_mainfi_tclMsgLocalTimeOffsetUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETUPREG;
}


clock_mainfi_tclMsgLocalTimeOffsetUpReg::~clock_mainfi_tclMsgLocalTimeOffsetUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgLocalTimeOffsetRelUpReg::clock_mainfi_tclMsgLocalTimeOffsetRelUpReg()
 {}

tS32 clock_mainfi_tclMsgLocalTimeOffsetRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETRELUPREG;
}


clock_mainfi_tclMsgLocalTimeOffsetRelUpReg::~clock_mainfi_tclMsgLocalTimeOffsetRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgLocalTimeOffsetGet::clock_mainfi_tclMsgLocalTimeOffsetGet()
 {}

tS32 clock_mainfi_tclMsgLocalTimeOffsetGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETGET;
}


clock_mainfi_tclMsgLocalTimeOffsetGet::~clock_mainfi_tclMsgLocalTimeOffsetGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgLocalTimeOffsetStatus::clock_mainfi_tclMsgLocalTimeOffsetStatus(const clock_mainfi_tclMsgLocalTimeOffsetStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   s64Offset_ScalarValue = coRef.s64Offset_ScalarValue;
   bIsOffsetPostive = coRef.bIsOffsetPostive;
   s16Offset_Year = coRef.s16Offset_Year;
   u8Offset_Month = coRef.u8Offset_Month;
   u8Offset_Day = coRef.u8Offset_Day;
   u8Offset_Hour = coRef.u8Offset_Hour;
   u8Offset_Minute = coRef.u8Offset_Minute;
   u8Offset_Second = coRef.u8Offset_Second;
   u32UTCTimeDate_ScalarValue = coRef.u32UTCTimeDate_ScalarValue;
   s16UTCTimeDate_Year = coRef.s16UTCTimeDate_Year;
   u8UTCTimeDate_Month = coRef.u8UTCTimeDate_Month;
   u8UTCTimeDate_Day = coRef.u8UTCTimeDate_Day;
   u8UTCTimeDate_Hour = coRef.u8UTCTimeDate_Hour;
   u8UTCTimeDate_Minute = coRef.u8UTCTimeDate_Minute;
   u8UTCTimeDate_Second = coRef.u8UTCTimeDate_Second;
   u8UTCTimeDate_Weekday = coRef.u8UTCTimeDate_Weekday;
   enGpsRtcTimeState = coRef.enGpsRtcTimeState;
}
clock_mainfi_tclMsgLocalTimeOffsetStatus& clock_mainfi_tclMsgLocalTimeOffsetStatus::operator=(const clock_mainfi_tclMsgLocalTimeOffsetStatus& coRef)
{
   if (this == &coRef) return *this;
   s64Offset_ScalarValue = coRef.s64Offset_ScalarValue;
   bIsOffsetPostive = coRef.bIsOffsetPostive;
   s16Offset_Year = coRef.s16Offset_Year;
   u8Offset_Month = coRef.u8Offset_Month;
   u8Offset_Day = coRef.u8Offset_Day;
   u8Offset_Hour = coRef.u8Offset_Hour;
   u8Offset_Minute = coRef.u8Offset_Minute;
   u8Offset_Second = coRef.u8Offset_Second;
   u32UTCTimeDate_ScalarValue = coRef.u32UTCTimeDate_ScalarValue;
   s16UTCTimeDate_Year = coRef.s16UTCTimeDate_Year;
   u8UTCTimeDate_Month = coRef.u8UTCTimeDate_Month;
   u8UTCTimeDate_Day = coRef.u8UTCTimeDate_Day;
   u8UTCTimeDate_Hour = coRef.u8UTCTimeDate_Hour;
   u8UTCTimeDate_Minute = coRef.u8UTCTimeDate_Minute;
   u8UTCTimeDate_Second = coRef.u8UTCTimeDate_Second;
   u8UTCTimeDate_Weekday = coRef.u8UTCTimeDate_Weekday;
   enGpsRtcTimeState = coRef.enGpsRtcTimeState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgLocalTimeOffsetStatus::clock_mainfi_tclMsgLocalTimeOffsetStatus()
:s64Offset_ScalarValue(0)
,bIsOffsetPostive(0)
,s16Offset_Year(0)
,u8Offset_Month(0)
,u8Offset_Day(0)
,u8Offset_Hour(0)
,u8Offset_Minute(0)
,u8Offset_Second(0)
,u32UTCTimeDate_ScalarValue(0)
,s16UTCTimeDate_Year(0)
,u8UTCTimeDate_Month(0)
,u8UTCTimeDate_Day(0)
,u8UTCTimeDate_Hour(0)
,u8UTCTimeDate_Minute(0)
,u8UTCTimeDate_Second(0)
,u8UTCTimeDate_Weekday(0)
,enGpsRtcTimeState()
 {}

tS32 clock_mainfi_tclMsgLocalTimeOffsetStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETSTATUS;
}


clock_mainfi_tclMsgLocalTimeOffsetStatus::~clock_mainfi_tclMsgLocalTimeOffsetStatus()
{}

tU32 clock_mainfi_tclMsgLocalTimeOffsetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 29;
}

fi_tclInContext& clock_mainfi_tclMsgLocalTimeOffsetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s64Offset_ScalarValue);
   (tVoid) (oIn >> bIsOffsetPostive);
   (tVoid) (oIn >> s16Offset_Year);
   (tVoid) (oIn >> u8Offset_Month);
   (tVoid) (oIn >> u8Offset_Day);
   (tVoid) (oIn >> u8Offset_Hour);
   (tVoid) (oIn >> u8Offset_Minute);
   (tVoid) (oIn >> u8Offset_Second);
   (tVoid) (oIn >> u32UTCTimeDate_ScalarValue);
   (tVoid) (oIn >> s16UTCTimeDate_Year);
   (tVoid) (oIn >> u8UTCTimeDate_Month);
   (tVoid) (oIn >> u8UTCTimeDate_Day);
   (tVoid) (oIn >> u8UTCTimeDate_Hour);
   (tVoid) (oIn >> u8UTCTimeDate_Minute);
   (tVoid) (oIn >> u8UTCTimeDate_Second);
   (tVoid) (oIn >> u8UTCTimeDate_Weekday);
   (tVoid) (oIn >> enGpsRtcTimeState);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgLocalTimeOffsetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s64Offset_ScalarValue);
   (tVoid) (oOut << bIsOffsetPostive);
   (tVoid) (oOut << s16Offset_Year);
   (tVoid) (oOut << u8Offset_Month);
   (tVoid) (oOut << u8Offset_Day);
   (tVoid) (oOut << u8Offset_Hour);
   (tVoid) (oOut << u8Offset_Minute);
   (tVoid) (oOut << u8Offset_Second);
   (tVoid) (oOut << u32UTCTimeDate_ScalarValue);
   (tVoid) (oOut << s16UTCTimeDate_Year);
   (tVoid) (oOut << u8UTCTimeDate_Month);
   (tVoid) (oOut << u8UTCTimeDate_Day);
   (tVoid) (oOut << u8UTCTimeDate_Hour);
   (tVoid) (oOut << u8UTCTimeDate_Minute);
   (tVoid) (oOut << u8UTCTimeDate_Second);
   (tVoid) (oOut << u8UTCTimeDate_Weekday);
   (tVoid) (oOut << enGpsRtcTimeState);
   return oOut;
}

tBool clock_mainfi_tclMsgLocalTimeOffsetStatus::operator==(const clock_mainfi_tclMsgLocalTimeOffsetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s64Offset_ScalarValue == roRef.s64Offset_ScalarValue);
   bResult = bResult && (bIsOffsetPostive == roRef.bIsOffsetPostive);
   bResult = bResult && (s16Offset_Year == roRef.s16Offset_Year);
   bResult = bResult && (u8Offset_Month == roRef.u8Offset_Month);
   bResult = bResult && (u8Offset_Day == roRef.u8Offset_Day);
   bResult = bResult && (u8Offset_Hour == roRef.u8Offset_Hour);
   bResult = bResult && (u8Offset_Minute == roRef.u8Offset_Minute);
   bResult = bResult && (u8Offset_Second == roRef.u8Offset_Second);
   bResult = bResult && (u32UTCTimeDate_ScalarValue == roRef.u32UTCTimeDate_ScalarValue);
   bResult = bResult && (s16UTCTimeDate_Year == roRef.s16UTCTimeDate_Year);
   bResult = bResult && (u8UTCTimeDate_Month == roRef.u8UTCTimeDate_Month);
   bResult = bResult && (u8UTCTimeDate_Day == roRef.u8UTCTimeDate_Day);
   bResult = bResult && (u8UTCTimeDate_Hour == roRef.u8UTCTimeDate_Hour);
   bResult = bResult && (u8UTCTimeDate_Minute == roRef.u8UTCTimeDate_Minute);
   bResult = bResult && (u8UTCTimeDate_Second == roRef.u8UTCTimeDate_Second);
   bResult = bResult && (u8UTCTimeDate_Weekday == roRef.u8UTCTimeDate_Weekday);
   bResult = bResult && (enGpsRtcTimeState == roRef.enGpsRtcTimeState);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgLocalTimeOffsetSet::clock_mainfi_tclMsgLocalTimeOffsetSet()
 {}

tS32 clock_mainfi_tclMsgLocalTimeOffsetSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEOFFSETSET;
}


clock_mainfi_tclMsgLocalTimeOffsetSet::~clock_mainfi_tclMsgLocalTimeOffsetSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgLocalTimeDateUpReg::clock_mainfi_tclMsgLocalTimeDateUpReg(const clock_mainfi_tclMsgLocalTimeDateUpReg& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   u8UpdatePeriod = coRef.u8UpdatePeriod;
}
clock_mainfi_tclMsgLocalTimeDateUpReg& clock_mainfi_tclMsgLocalTimeDateUpReg::operator=(const clock_mainfi_tclMsgLocalTimeDateUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8UpdatePeriod = coRef.u8UpdatePeriod;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgLocalTimeDateUpReg::clock_mainfi_tclMsgLocalTimeDateUpReg()
:u8UpdatePeriod(0)
 {}

tS32 clock_mainfi_tclMsgLocalTimeDateUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATEUPREG;
}


clock_mainfi_tclMsgLocalTimeDateUpReg::~clock_mainfi_tclMsgLocalTimeDateUpReg()
{}

tU32 clock_mainfi_tclMsgLocalTimeDateUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgLocalTimeDateUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8UpdatePeriod);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgLocalTimeDateUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8UpdatePeriod);
   return oOut;
}

tBool clock_mainfi_tclMsgLocalTimeDateUpReg::operator==(const clock_mainfi_tclMsgLocalTimeDateUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8UpdatePeriod == roRef.u8UpdatePeriod);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgLocalTimeDateRelUpReg::clock_mainfi_tclMsgLocalTimeDateRelUpReg(const clock_mainfi_tclMsgLocalTimeDateRelUpReg& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   u8UpdatePeriod = coRef.u8UpdatePeriod;
}
clock_mainfi_tclMsgLocalTimeDateRelUpReg& clock_mainfi_tclMsgLocalTimeDateRelUpReg::operator=(const clock_mainfi_tclMsgLocalTimeDateRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8UpdatePeriod = coRef.u8UpdatePeriod;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgLocalTimeDateRelUpReg::clock_mainfi_tclMsgLocalTimeDateRelUpReg()
:u8UpdatePeriod(0)
 {}

tS32 clock_mainfi_tclMsgLocalTimeDateRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATERELUPREG;
}


clock_mainfi_tclMsgLocalTimeDateRelUpReg::~clock_mainfi_tclMsgLocalTimeDateRelUpReg()
{}

tU32 clock_mainfi_tclMsgLocalTimeDateRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgLocalTimeDateRelUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8UpdatePeriod);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgLocalTimeDateRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8UpdatePeriod);
   return oOut;
}

tBool clock_mainfi_tclMsgLocalTimeDateRelUpReg::operator==(const clock_mainfi_tclMsgLocalTimeDateRelUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8UpdatePeriod == roRef.u8UpdatePeriod);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgLocalTimeDateGet::clock_mainfi_tclMsgLocalTimeDateGet()
 {}

tS32 clock_mainfi_tclMsgLocalTimeDateGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATEGET;
}


clock_mainfi_tclMsgLocalTimeDateGet::~clock_mainfi_tclMsgLocalTimeDateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgLocalTimeDateStatus::clock_mainfi_tclMsgLocalTimeDateStatus(const clock_mainfi_tclMsgLocalTimeDateStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   u8TimeDateStatus = coRef.u8TimeDateStatus;
   u32TimeDateValue = coRef.u32TimeDateValue;
}
clock_mainfi_tclMsgLocalTimeDateStatus& clock_mainfi_tclMsgLocalTimeDateStatus::operator=(const clock_mainfi_tclMsgLocalTimeDateStatus& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   u8TimeDateStatus = coRef.u8TimeDateStatus;
   u32TimeDateValue = coRef.u32TimeDateValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgLocalTimeDateStatus::clock_mainfi_tclMsgLocalTimeDateStatus()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hours(0)
,u8Minutes(0)
,u8Seconds(0)
,u8Weekday(0)
,u8TimeDateStatus(0)
,u32TimeDateValue(0)
 {}

tS32 clock_mainfi_tclMsgLocalTimeDateStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATESTATUS;
}


clock_mainfi_tclMsgLocalTimeDateStatus::~clock_mainfi_tclMsgLocalTimeDateStatus()
{}

tU32 clock_mainfi_tclMsgLocalTimeDateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& clock_mainfi_tclMsgLocalTimeDateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hours);
   (tVoid) (oIn >> u8Minutes);
   (tVoid) (oIn >> u8Seconds);
   (tVoid) (oIn >> u8Weekday);
   (tVoid) (oIn >> u8TimeDateStatus);
   (tVoid) (oIn >> u32TimeDateValue);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgLocalTimeDateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hours);
   (tVoid) (oOut << u8Minutes);
   (tVoid) (oOut << u8Seconds);
   (tVoid) (oOut << u8Weekday);
   (tVoid) (oOut << u8TimeDateStatus);
   (tVoid) (oOut << u32TimeDateValue);
   return oOut;
}

tBool clock_mainfi_tclMsgLocalTimeDateStatus::operator==(const clock_mainfi_tclMsgLocalTimeDateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hours == roRef.u8Hours);
   bResult = bResult && (u8Minutes == roRef.u8Minutes);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   bResult = bResult && (u8Weekday == roRef.u8Weekday);
   bResult = bResult && (u8TimeDateStatus == roRef.u8TimeDateStatus);
   bResult = bResult && (u32TimeDateValue == roRef.u32TimeDateValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgLocalTimeDateSet::clock_mainfi_tclMsgLocalTimeDateSet(const clock_mainfi_tclMsgLocalTimeDateSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   u8ChangeMask = coRef.u8ChangeMask;
}
clock_mainfi_tclMsgLocalTimeDateSet& clock_mainfi_tclMsgLocalTimeDateSet::operator=(const clock_mainfi_tclMsgLocalTimeDateSet& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   u8ChangeMask = coRef.u8ChangeMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgLocalTimeDateSet::clock_mainfi_tclMsgLocalTimeDateSet()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hours(0)
,u8Minutes(0)
,u8Seconds(0)
,u8Weekday(0)
,u8ChangeMask(0)
 {}

tS32 clock_mainfi_tclMsgLocalTimeDateSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATESET;
}


clock_mainfi_tclMsgLocalTimeDateSet::~clock_mainfi_tclMsgLocalTimeDateSet()
{}

tU32 clock_mainfi_tclMsgLocalTimeDateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& clock_mainfi_tclMsgLocalTimeDateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hours);
   (tVoid) (oIn >> u8Minutes);
   (tVoid) (oIn >> u8Seconds);
   (tVoid) (oIn >> u8Weekday);
   (tVoid) (oIn >> u8ChangeMask);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgLocalTimeDateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hours);
   (tVoid) (oOut << u8Minutes);
   (tVoid) (oOut << u8Seconds);
   (tVoid) (oOut << u8Weekday);
   (tVoid) (oOut << u8ChangeMask);
   return oOut;
}

tBool clock_mainfi_tclMsgLocalTimeDateSet::operator==(const clock_mainfi_tclMsgLocalTimeDateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hours == roRef.u8Hours);
   bResult = bResult && (u8Minutes == roRef.u8Minutes);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   bResult = bResult && (u8Weekday == roRef.u8Weekday);
   bResult = bResult && (u8ChangeMask == roRef.u8ChangeMask);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgTimeFormatUpReg::clock_mainfi_tclMsgTimeFormatUpReg()
 {}

tS32 clock_mainfi_tclMsgTimeFormatUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEFORMATUPREG;
}


clock_mainfi_tclMsgTimeFormatUpReg::~clock_mainfi_tclMsgTimeFormatUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgTimeFormatRelUpReg::clock_mainfi_tclMsgTimeFormatRelUpReg()
 {}

tS32 clock_mainfi_tclMsgTimeFormatRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEFORMATRELUPREG;
}


clock_mainfi_tclMsgTimeFormatRelUpReg::~clock_mainfi_tclMsgTimeFormatRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgTimeFormatGet::clock_mainfi_tclMsgTimeFormatGet()
 {}

tS32 clock_mainfi_tclMsgTimeFormatGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEFORMATGET;
}


clock_mainfi_tclMsgTimeFormatGet::~clock_mainfi_tclMsgTimeFormatGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgTimeFormatStatus::clock_mainfi_tclMsgTimeFormatStatus(const clock_mainfi_tclMsgTimeFormatStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enTimeFormat = coRef.enTimeFormat;
}
clock_mainfi_tclMsgTimeFormatStatus& clock_mainfi_tclMsgTimeFormatStatus::operator=(const clock_mainfi_tclMsgTimeFormatStatus& coRef)
{
   if (this == &coRef) return *this;
   enTimeFormat = coRef.enTimeFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgTimeFormatStatus::clock_mainfi_tclMsgTimeFormatStatus()
:enTimeFormat()
 {}

tS32 clock_mainfi_tclMsgTimeFormatStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEFORMATSTATUS;
}


clock_mainfi_tclMsgTimeFormatStatus::~clock_mainfi_tclMsgTimeFormatStatus()
{}

tU32 clock_mainfi_tclMsgTimeFormatStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgTimeFormatStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enTimeFormat);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgTimeFormatStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enTimeFormat);
   return oOut;
}

tBool clock_mainfi_tclMsgTimeFormatStatus::operator==(const clock_mainfi_tclMsgTimeFormatStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enTimeFormat == roRef.enTimeFormat);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgTimeFormatSet::clock_mainfi_tclMsgTimeFormatSet(const clock_mainfi_tclMsgTimeFormatSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enTimeFormat = coRef.enTimeFormat;
}
clock_mainfi_tclMsgTimeFormatSet& clock_mainfi_tclMsgTimeFormatSet::operator=(const clock_mainfi_tclMsgTimeFormatSet& coRef)
{
   if (this == &coRef) return *this;
   enTimeFormat = coRef.enTimeFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgTimeFormatSet::clock_mainfi_tclMsgTimeFormatSet()
:enTimeFormat()
 {}

tS32 clock_mainfi_tclMsgTimeFormatSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEFORMATSET;
}


clock_mainfi_tclMsgTimeFormatSet::~clock_mainfi_tclMsgTimeFormatSet()
{}

tU32 clock_mainfi_tclMsgTimeFormatSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgTimeFormatSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enTimeFormat);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgTimeFormatSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enTimeFormat);
   return oOut;
}

tBool clock_mainfi_tclMsgTimeFormatSet::operator==(const clock_mainfi_tclMsgTimeFormatSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enTimeFormat == roRef.enTimeFormat);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgDateFormatUpReg::clock_mainfi_tclMsgDateFormatUpReg()
 {}

tS32 clock_mainfi_tclMsgDateFormatUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DATEFORMATUPREG;
}


clock_mainfi_tclMsgDateFormatUpReg::~clock_mainfi_tclMsgDateFormatUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgDateFormatRelUpReg::clock_mainfi_tclMsgDateFormatRelUpReg()
 {}

tS32 clock_mainfi_tclMsgDateFormatRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DATEFORMATRELUPREG;
}


clock_mainfi_tclMsgDateFormatRelUpReg::~clock_mainfi_tclMsgDateFormatRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgDateFormatGet::clock_mainfi_tclMsgDateFormatGet()
 {}

tS32 clock_mainfi_tclMsgDateFormatGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DATEFORMATGET;
}


clock_mainfi_tclMsgDateFormatGet::~clock_mainfi_tclMsgDateFormatGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgDateFormatStatus::clock_mainfi_tclMsgDateFormatStatus(const clock_mainfi_tclMsgDateFormatStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enDateFormat = coRef.enDateFormat;
}
clock_mainfi_tclMsgDateFormatStatus& clock_mainfi_tclMsgDateFormatStatus::operator=(const clock_mainfi_tclMsgDateFormatStatus& coRef)
{
   if (this == &coRef) return *this;
   enDateFormat = coRef.enDateFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgDateFormatStatus::clock_mainfi_tclMsgDateFormatStatus()
:enDateFormat()
 {}

tS32 clock_mainfi_tclMsgDateFormatStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DATEFORMATSTATUS;
}


clock_mainfi_tclMsgDateFormatStatus::~clock_mainfi_tclMsgDateFormatStatus()
{}

tU32 clock_mainfi_tclMsgDateFormatStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgDateFormatStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enDateFormat);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgDateFormatStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enDateFormat);
   return oOut;
}

tBool clock_mainfi_tclMsgDateFormatStatus::operator==(const clock_mainfi_tclMsgDateFormatStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enDateFormat == roRef.enDateFormat);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgDateFormatSet::clock_mainfi_tclMsgDateFormatSet(const clock_mainfi_tclMsgDateFormatSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enDateFormat = coRef.enDateFormat;
}
clock_mainfi_tclMsgDateFormatSet& clock_mainfi_tclMsgDateFormatSet::operator=(const clock_mainfi_tclMsgDateFormatSet& coRef)
{
   if (this == &coRef) return *this;
   enDateFormat = coRef.enDateFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgDateFormatSet::clock_mainfi_tclMsgDateFormatSet()
:enDateFormat()
 {}

tS32 clock_mainfi_tclMsgDateFormatSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DATEFORMATSET;
}


clock_mainfi_tclMsgDateFormatSet::~clock_mainfi_tclMsgDateFormatSet()
{}

tU32 clock_mainfi_tclMsgDateFormatSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgDateFormatSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enDateFormat);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgDateFormatSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enDateFormat);
   return oOut;
}

tBool clock_mainfi_tclMsgDateFormatSet::operator==(const clock_mainfi_tclMsgDateFormatSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enDateFormat == roRef.enDateFormat);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgClockSourceStatusUpReg::clock_mainfi_tclMsgClockSourceStatusUpReg()
 {}

tS32 clock_mainfi_tclMsgClockSourceStatusUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSUPREG;
}


clock_mainfi_tclMsgClockSourceStatusUpReg::~clock_mainfi_tclMsgClockSourceStatusUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgClockSourceStatusRelUpReg::clock_mainfi_tclMsgClockSourceStatusRelUpReg()
 {}

tS32 clock_mainfi_tclMsgClockSourceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSRELUPREG;
}


clock_mainfi_tclMsgClockSourceStatusRelUpReg::~clock_mainfi_tclMsgClockSourceStatusRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgClockSourceStatusGet::clock_mainfi_tclMsgClockSourceStatusGet()
 {}

tS32 clock_mainfi_tclMsgClockSourceStatusGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSGET;
}


clock_mainfi_tclMsgClockSourceStatusGet::~clock_mainfi_tclMsgClockSourceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgClockSourceStatusStatus::clock_mainfi_tclMsgClockSourceStatusStatus(const clock_mainfi_tclMsgClockSourceStatusStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enSourcesValid = coRef.enSourcesValid;
}
clock_mainfi_tclMsgClockSourceStatusStatus& clock_mainfi_tclMsgClockSourceStatusStatus::operator=(const clock_mainfi_tclMsgClockSourceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   enSourcesValid = coRef.enSourcesValid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgClockSourceStatusStatus::clock_mainfi_tclMsgClockSourceStatusStatus()
:enSourcesValid()
 {}

tS32 clock_mainfi_tclMsgClockSourceStatusStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_CLOCKSOURCESTATUSSTATUS;
}


clock_mainfi_tclMsgClockSourceStatusStatus::~clock_mainfi_tclMsgClockSourceStatusStatus()
{}

tU32 clock_mainfi_tclMsgClockSourceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgClockSourceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enSourcesValid);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgClockSourceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enSourcesValid);
   return oOut;
}

tBool clock_mainfi_tclMsgClockSourceStatusStatus::operator==(const clock_mainfi_tclMsgClockSourceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enSourcesValid == roRef.enSourcesValid);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgFormatSourceStatusUpReg::clock_mainfi_tclMsgFormatSourceStatusUpReg()
 {}

tS32 clock_mainfi_tclMsgFormatSourceStatusUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSUPREG;
}


clock_mainfi_tclMsgFormatSourceStatusUpReg::~clock_mainfi_tclMsgFormatSourceStatusUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgFormatSourceStatusRelUpReg::clock_mainfi_tclMsgFormatSourceStatusRelUpReg()
 {}

tS32 clock_mainfi_tclMsgFormatSourceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSRELUPREG;
}


clock_mainfi_tclMsgFormatSourceStatusRelUpReg::~clock_mainfi_tclMsgFormatSourceStatusRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgFormatSourceStatusGet::clock_mainfi_tclMsgFormatSourceStatusGet()
 {}

tS32 clock_mainfi_tclMsgFormatSourceStatusGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSGET;
}


clock_mainfi_tclMsgFormatSourceStatusGet::~clock_mainfi_tclMsgFormatSourceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgFormatSourceStatusStatus::clock_mainfi_tclMsgFormatSourceStatusStatus(const clock_mainfi_tclMsgFormatSourceStatusStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enFormatSourceStatus = coRef.enFormatSourceStatus;
}
clock_mainfi_tclMsgFormatSourceStatusStatus& clock_mainfi_tclMsgFormatSourceStatusStatus::operator=(const clock_mainfi_tclMsgFormatSourceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   enFormatSourceStatus = coRef.enFormatSourceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgFormatSourceStatusStatus::clock_mainfi_tclMsgFormatSourceStatusStatus()
:enFormatSourceStatus()
 {}

tS32 clock_mainfi_tclMsgFormatSourceStatusStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_FORMATSOURCESTATUSSTATUS;
}


clock_mainfi_tclMsgFormatSourceStatusStatus::~clock_mainfi_tclMsgFormatSourceStatusStatus()
{}

tU32 clock_mainfi_tclMsgFormatSourceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgFormatSourceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enFormatSourceStatus);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgFormatSourceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enFormatSourceStatus);
   return oOut;
}

tBool clock_mainfi_tclMsgFormatSourceStatusStatus::operator==(const clock_mainfi_tclMsgFormatSourceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enFormatSourceStatus == roRef.enFormatSourceStatus);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateUpReg::clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateUpReg()
 {}

tS32 clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATEUPREG;
}


clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateUpReg::~clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateRelUpReg::clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateRelUpReg()
 {}

tS32 clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATERELUPREG;
}


clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateRelUpReg::~clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateGet::clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateGet()
 {}

tS32 clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATEGET;
}


clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateGet::~clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus::clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   u8TimeDateStatus = coRef.u8TimeDateStatus;
   u32TimeDateValue = coRef.u32TimeDateValue;
}
clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus& clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus::operator=(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   u8TimeDateStatus = coRef.u8TimeDateStatus;
   u32TimeDateValue = coRef.u32TimeDateValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus::clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hours(0)
,u8Minutes(0)
,u8Seconds(0)
,u8Weekday(0)
,u8TimeDateStatus(0)
,u32TimeDateValue(0)
 {}

tS32 clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATESTATUS;
}


clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus::~clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus()
{}

tU32 clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hours);
   (tVoid) (oIn >> u8Minutes);
   (tVoid) (oIn >> u8Seconds);
   (tVoid) (oIn >> u8Weekday);
   (tVoid) (oIn >> u8TimeDateStatus);
   (tVoid) (oIn >> u32TimeDateValue);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hours);
   (tVoid) (oOut << u8Minutes);
   (tVoid) (oOut << u8Seconds);
   (tVoid) (oOut << u8Weekday);
   (tVoid) (oOut << u8TimeDateStatus);
   (tVoid) (oOut << u32TimeDateValue);
   return oOut;
}

tBool clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus::operator==(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hours == roRef.u8Hours);
   bResult = bResult && (u8Minutes == roRef.u8Minutes);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   bResult = bResult && (u8Weekday == roRef.u8Weekday);
   bResult = bResult && (u8TimeDateStatus == roRef.u8TimeDateStatus);
   bResult = bResult && (u32TimeDateValue == roRef.u32TimeDateValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet::clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   u8ChangeMask = coRef.u8ChangeMask;
}
clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet& clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet::operator=(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   u8ChangeMask = coRef.u8ChangeMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet::clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hours(0)
,u8Minutes(0)
,u8Seconds(0)
,u8Weekday(0)
,u8ChangeMask(0)
 {}

tS32 clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_LOCALTIMEDATE_MINUTEUPDATESET;
}


clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet::~clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet()
{}

tU32 clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hours);
   (tVoid) (oIn >> u8Minutes);
   (tVoid) (oIn >> u8Seconds);
   (tVoid) (oIn >> u8Weekday);
   (tVoid) (oIn >> u8ChangeMask);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hours);
   (tVoid) (oOut << u8Minutes);
   (tVoid) (oOut << u8Seconds);
   (tVoid) (oOut << u8Weekday);
   (tVoid) (oOut << u8ChangeMask);
   return oOut;
}

tBool clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet::operator==(const clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hours == roRef.u8Hours);
   bResult = bResult && (u8Minutes == roRef.u8Minutes);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   bResult = bResult && (u8Weekday == roRef.u8Weekday);
   bResult = bResult && (u8ChangeMask == roRef.u8ChangeMask);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgRegion_TimeZoneGet::clock_mainfi_tclMsgRegion_TimeZoneGet()
 {}

tS32 clock_mainfi_tclMsgRegion_TimeZoneGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONEGET;
}


clock_mainfi_tclMsgRegion_TimeZoneGet::~clock_mainfi_tclMsgRegion_TimeZoneGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgRegion_TimeZoneSet::clock_mainfi_tclMsgRegion_TimeZoneSet(const clock_mainfi_tclMsgRegion_TimeZoneSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enTIMEZONE_Settings = coRef.enTIMEZONE_Settings;
}
clock_mainfi_tclMsgRegion_TimeZoneSet& clock_mainfi_tclMsgRegion_TimeZoneSet::operator=(const clock_mainfi_tclMsgRegion_TimeZoneSet& coRef)
{
   if (this == &coRef) return *this;
   enTIMEZONE_Settings = coRef.enTIMEZONE_Settings;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgRegion_TimeZoneSet::clock_mainfi_tclMsgRegion_TimeZoneSet()
:enTIMEZONE_Settings()
 {}

tS32 clock_mainfi_tclMsgRegion_TimeZoneSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONESET;
}


clock_mainfi_tclMsgRegion_TimeZoneSet::~clock_mainfi_tclMsgRegion_TimeZoneSet()
{}

tU32 clock_mainfi_tclMsgRegion_TimeZoneSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgRegion_TimeZoneSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enTIMEZONE_Settings);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgRegion_TimeZoneSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enTIMEZONE_Settings);
   return oOut;
}

tBool clock_mainfi_tclMsgRegion_TimeZoneSet::operator==(const clock_mainfi_tclMsgRegion_TimeZoneSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enTIMEZONE_Settings == roRef.enTIMEZONE_Settings);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgRegion_TimeZoneUpReg::clock_mainfi_tclMsgRegion_TimeZoneUpReg()
 {}

tS32 clock_mainfi_tclMsgRegion_TimeZoneUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONEUPREG;
}


clock_mainfi_tclMsgRegion_TimeZoneUpReg::~clock_mainfi_tclMsgRegion_TimeZoneUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgRegion_TimeZoneRelUpReg::clock_mainfi_tclMsgRegion_TimeZoneRelUpReg()
 {}

tS32 clock_mainfi_tclMsgRegion_TimeZoneRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONERELUPREG;
}


clock_mainfi_tclMsgRegion_TimeZoneRelUpReg::~clock_mainfi_tclMsgRegion_TimeZoneRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgRegion_TimeZoneStatus::clock_mainfi_tclMsgRegion_TimeZoneStatus(const clock_mainfi_tclMsgRegion_TimeZoneStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enTIMEZONE_Status = coRef.enTIMEZONE_Status;
   szDescription = coRef.szDescription;
}
clock_mainfi_tclMsgRegion_TimeZoneStatus& clock_mainfi_tclMsgRegion_TimeZoneStatus::operator=(const clock_mainfi_tclMsgRegion_TimeZoneStatus& coRef)
{
   if (this == &coRef) return *this;
   enTIMEZONE_Status = coRef.enTIMEZONE_Status;
   szDescription = coRef.szDescription;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid clock_mainfi_tclMsgRegion_TimeZoneStatus::vDestroy()
{
   szDescription.vDestroy();
}

clock_mainfi_tclMsgRegion_TimeZoneStatus::clock_mainfi_tclMsgRegion_TimeZoneStatus()
:enTIMEZONE_Status()
,szDescription()
 {}

tS32 clock_mainfi_tclMsgRegion_TimeZoneStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_REGION_TIMEZONESTATUS;
}


clock_mainfi_tclMsgRegion_TimeZoneStatus::~clock_mainfi_tclMsgRegion_TimeZoneStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 clock_mainfi_tclMsgRegion_TimeZoneStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+szDescription.u32GetSize(u16MajorVersion);
}

fi_tclInContext& clock_mainfi_tclMsgRegion_TimeZoneStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enTIMEZONE_Status);
   (tVoid) (oIn >> szDescription);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgRegion_TimeZoneStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enTIMEZONE_Status);
   (tVoid) (oOut << szDescription);
   return oOut;
}

tBool clock_mainfi_tclMsgRegion_TimeZoneStatus::operator==(const clock_mainfi_tclMsgRegion_TimeZoneStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enTIMEZONE_Status == roRef.enTIMEZONE_Status);
   bResult = bResult && (szDescription == roRef.szDescription);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgAuto_TimeZoneOffsetUpReg::clock_mainfi_tclMsgAuto_TimeZoneOffsetUpReg()
 {}

tS32 clock_mainfi_tclMsgAuto_TimeZoneOffsetUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETUPREG;
}


clock_mainfi_tclMsgAuto_TimeZoneOffsetUpReg::~clock_mainfi_tclMsgAuto_TimeZoneOffsetUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgAuto_TimeZoneOffsetRelUpReg::clock_mainfi_tclMsgAuto_TimeZoneOffsetRelUpReg()
 {}

tS32 clock_mainfi_tclMsgAuto_TimeZoneOffsetRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETRELUPREG;
}


clock_mainfi_tclMsgAuto_TimeZoneOffsetRelUpReg::~clock_mainfi_tclMsgAuto_TimeZoneOffsetRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgAuto_TimeZoneOffsetGet::clock_mainfi_tclMsgAuto_TimeZoneOffsetGet()
 {}

tS32 clock_mainfi_tclMsgAuto_TimeZoneOffsetGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETGET;
}


clock_mainfi_tclMsgAuto_TimeZoneOffsetGet::~clock_mainfi_tclMsgAuto_TimeZoneOffsetGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus::clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus(const clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   s8Offset_Hour = coRef.s8Offset_Hour;
   s8Offset_Minute = coRef.s8Offset_Minute;
}
clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus& clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus::operator=(const clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus& coRef)
{
   if (this == &coRef) return *this;
   s8Offset_Hour = coRef.s8Offset_Hour;
   s8Offset_Minute = coRef.s8Offset_Minute;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus::clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus()
:s8Offset_Hour(0)
,s8Offset_Minute(0)
 {}

tS32 clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETSTATUS;
}


clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus::~clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus()
{}

tU32 clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s8Offset_Hour);
   (tVoid) (oIn >> s8Offset_Minute);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s8Offset_Hour);
   (tVoid) (oOut << s8Offset_Minute);
   return oOut;
}

tBool clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus::operator==(const clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s8Offset_Hour == roRef.s8Offset_Hour);
   bResult = bResult && (s8Offset_Minute == roRef.s8Offset_Minute);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgAuto_TimeZoneOffsetSet::clock_mainfi_tclMsgAuto_TimeZoneOffsetSet(const clock_mainfi_tclMsgAuto_TimeZoneOffsetSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   s8Offset_Hour = coRef.s8Offset_Hour;
   s8Offset_Minute = coRef.s8Offset_Minute;
}
clock_mainfi_tclMsgAuto_TimeZoneOffsetSet& clock_mainfi_tclMsgAuto_TimeZoneOffsetSet::operator=(const clock_mainfi_tclMsgAuto_TimeZoneOffsetSet& coRef)
{
   if (this == &coRef) return *this;
   s8Offset_Hour = coRef.s8Offset_Hour;
   s8Offset_Minute = coRef.s8Offset_Minute;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgAuto_TimeZoneOffsetSet::clock_mainfi_tclMsgAuto_TimeZoneOffsetSet()
:s8Offset_Hour(0)
,s8Offset_Minute(0)
 {}

tS32 clock_mainfi_tclMsgAuto_TimeZoneOffsetSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_AUTO_TIMEZONEOFFSETSET;
}


clock_mainfi_tclMsgAuto_TimeZoneOffsetSet::~clock_mainfi_tclMsgAuto_TimeZoneOffsetSet()
{}

tU32 clock_mainfi_tclMsgAuto_TimeZoneOffsetSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& clock_mainfi_tclMsgAuto_TimeZoneOffsetSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s8Offset_Hour);
   (tVoid) (oIn >> s8Offset_Minute);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgAuto_TimeZoneOffsetSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s8Offset_Hour);
   (tVoid) (oOut << s8Offset_Minute);
   return oOut;
}

tBool clock_mainfi_tclMsgAuto_TimeZoneOffsetSet::operator==(const clock_mainfi_tclMsgAuto_TimeZoneOffsetSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s8Offset_Hour == roRef.s8Offset_Hour);
   bResult = bResult && (s8Offset_Minute == roRef.s8Offset_Minute);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgNewDateFormatUpReg::clock_mainfi_tclMsgNewDateFormatUpReg()
 {}

tS32 clock_mainfi_tclMsgNewDateFormatUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATUPREG;
}


clock_mainfi_tclMsgNewDateFormatUpReg::~clock_mainfi_tclMsgNewDateFormatUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgNewDateFormatRelUpReg::clock_mainfi_tclMsgNewDateFormatRelUpReg()
 {}

tS32 clock_mainfi_tclMsgNewDateFormatRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATRELUPREG;
}


clock_mainfi_tclMsgNewDateFormatRelUpReg::~clock_mainfi_tclMsgNewDateFormatRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgNewDateFormatGet::clock_mainfi_tclMsgNewDateFormatGet()
 {}

tS32 clock_mainfi_tclMsgNewDateFormatGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATGET;
}


clock_mainfi_tclMsgNewDateFormatGet::~clock_mainfi_tclMsgNewDateFormatGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgNewDateFormatStatus::clock_mainfi_tclMsgNewDateFormatStatus(const clock_mainfi_tclMsgNewDateFormatStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enDateFormat = coRef.enDateFormat;
}
clock_mainfi_tclMsgNewDateFormatStatus& clock_mainfi_tclMsgNewDateFormatStatus::operator=(const clock_mainfi_tclMsgNewDateFormatStatus& coRef)
{
   if (this == &coRef) return *this;
   enDateFormat = coRef.enDateFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgNewDateFormatStatus::clock_mainfi_tclMsgNewDateFormatStatus()
:enDateFormat()
 {}

tS32 clock_mainfi_tclMsgNewDateFormatStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATSTATUS;
}


clock_mainfi_tclMsgNewDateFormatStatus::~clock_mainfi_tclMsgNewDateFormatStatus()
{}

tU32 clock_mainfi_tclMsgNewDateFormatStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgNewDateFormatStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enDateFormat);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgNewDateFormatStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enDateFormat);
   return oOut;
}

tBool clock_mainfi_tclMsgNewDateFormatStatus::operator==(const clock_mainfi_tclMsgNewDateFormatStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enDateFormat == roRef.enDateFormat);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgNewDateFormatSet::clock_mainfi_tclMsgNewDateFormatSet(const clock_mainfi_tclMsgNewDateFormatSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enDateFormat = coRef.enDateFormat;
}
clock_mainfi_tclMsgNewDateFormatSet& clock_mainfi_tclMsgNewDateFormatSet::operator=(const clock_mainfi_tclMsgNewDateFormatSet& coRef)
{
   if (this == &coRef) return *this;
   enDateFormat = coRef.enDateFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgNewDateFormatSet::clock_mainfi_tclMsgNewDateFormatSet()
:enDateFormat()
 {}

tS32 clock_mainfi_tclMsgNewDateFormatSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_NEWDATEFORMATSET;
}


clock_mainfi_tclMsgNewDateFormatSet::~clock_mainfi_tclMsgNewDateFormatSet()
{}

tU32 clock_mainfi_tclMsgNewDateFormatSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgNewDateFormatSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enDateFormat);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgNewDateFormatSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enDateFormat);
   return oOut;
}

tBool clock_mainfi_tclMsgNewDateFormatSet::operator==(const clock_mainfi_tclMsgNewDateFormatSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enDateFormat == roRef.enDateFormat);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgConnectionUpReg::clock_mainfi_tclMsgConnectionUpReg()
 {}

tS32 clock_mainfi_tclMsgConnectionUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_CONNECTIONUPREG;
}


clock_mainfi_tclMsgConnectionUpReg::~clock_mainfi_tclMsgConnectionUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgConnectionRelUpReg::clock_mainfi_tclMsgConnectionRelUpReg()
 {}

tS32 clock_mainfi_tclMsgConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_CONNECTIONRELUPREG;
}


clock_mainfi_tclMsgConnectionRelUpReg::~clock_mainfi_tclMsgConnectionRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgConnectionGet::clock_mainfi_tclMsgConnectionGet()
 {}

tS32 clock_mainfi_tclMsgConnectionGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_CONNECTIONGET;
}


clock_mainfi_tclMsgConnectionGet::~clock_mainfi_tclMsgConnectionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgConnectionStatus::clock_mainfi_tclMsgConnectionStatus(const clock_mainfi_tclMsgConnectionStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   SWCUnitConnectionStatus = coRef.SWCUnitConnectionStatus;
}
clock_mainfi_tclMsgConnectionStatus& clock_mainfi_tclMsgConnectionStatus::operator=(const clock_mainfi_tclMsgConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   SWCUnitConnectionStatus = coRef.SWCUnitConnectionStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgConnectionStatus::clock_mainfi_tclMsgConnectionStatus()
:SWCUnitConnectionStatus()
 {}

tS32 clock_mainfi_tclMsgConnectionStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_CONNECTIONSTATUS;
}


clock_mainfi_tclMsgConnectionStatus::~clock_mainfi_tclMsgConnectionStatus()
{}

tU32 clock_mainfi_tclMsgConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& clock_mainfi_tclMsgConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SWCUnitConnectionStatus);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SWCUnitConnectionStatus);
   return oOut;
}

tBool clock_mainfi_tclMsgConnectionStatus::operator==(const clock_mainfi_tclMsgConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SWCUnitConnectionStatus == roRef.SWCUnitConnectionStatus);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgTimeZone_DSTAvailabilityUpReg::clock_mainfi_tclMsgTimeZone_DSTAvailabilityUpReg()
 {}

tS32 clock_mainfi_tclMsgTimeZone_DSTAvailabilityUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYUPREG;
}


clock_mainfi_tclMsgTimeZone_DSTAvailabilityUpReg::~clock_mainfi_tclMsgTimeZone_DSTAvailabilityUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgTimeZone_DSTAvailabilityRelUpReg::clock_mainfi_tclMsgTimeZone_DSTAvailabilityRelUpReg()
 {}

tS32 clock_mainfi_tclMsgTimeZone_DSTAvailabilityRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYRELUPREG;
}


clock_mainfi_tclMsgTimeZone_DSTAvailabilityRelUpReg::~clock_mainfi_tclMsgTimeZone_DSTAvailabilityRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgTimeZone_DSTAvailabilityGet::clock_mainfi_tclMsgTimeZone_DSTAvailabilityGet()
 {}

tS32 clock_mainfi_tclMsgTimeZone_DSTAvailabilityGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYGET;
}


clock_mainfi_tclMsgTimeZone_DSTAvailabilityGet::~clock_mainfi_tclMsgTimeZone_DSTAvailabilityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus::clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus(const clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   bTimeZone_DSTAvailabilityForRegion = coRef.bTimeZone_DSTAvailabilityForRegion;
}
clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus& clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus::operator=(const clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus& coRef)
{
   if (this == &coRef) return *this;
   bTimeZone_DSTAvailabilityForRegion = coRef.bTimeZone_DSTAvailabilityForRegion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus::clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus()
:bTimeZone_DSTAvailabilityForRegion(0)
 {}

tS32 clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_TIMEZONE_DSTAVAILABILITYSTATUS;
}


clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus::~clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus()
{}

tU32 clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bTimeZone_DSTAvailabilityForRegion);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bTimeZone_DSTAvailabilityForRegion);
   return oOut;
}

tBool clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus::operator==(const clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bTimeZone_DSTAvailabilityForRegion == roRef.bTimeZone_DSTAvailabilityForRegion);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgHardwareVersionUpReg::clock_mainfi_tclMsgHardwareVersionUpReg()
 {}

tS32 clock_mainfi_tclMsgHardwareVersionUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONUPREG;
}


clock_mainfi_tclMsgHardwareVersionUpReg::~clock_mainfi_tclMsgHardwareVersionUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgHardwareVersionRelUpReg::clock_mainfi_tclMsgHardwareVersionRelUpReg()
 {}

tS32 clock_mainfi_tclMsgHardwareVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONRELUPREG;
}


clock_mainfi_tclMsgHardwareVersionRelUpReg::~clock_mainfi_tclMsgHardwareVersionRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgHardwareVersionGet::clock_mainfi_tclMsgHardwareVersionGet()
 {}

tS32 clock_mainfi_tclMsgHardwareVersionGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONGET;
}


clock_mainfi_tclMsgHardwareVersionGet::~clock_mainfi_tclMsgHardwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgHardwareVersionStatus::clock_mainfi_tclMsgHardwareVersionStatus(const clock_mainfi_tclMsgHardwareVersionStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   arHardwareVersionList = coRef.arHardwareVersionList;
}
clock_mainfi_tclMsgHardwareVersionStatus& clock_mainfi_tclMsgHardwareVersionStatus::operator=(const clock_mainfi_tclMsgHardwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   arHardwareVersionList = coRef.arHardwareVersionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid clock_mainfi_tclMsgHardwareVersionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arHardwareVersionList.size(); ++u32Idx)
         arHardwareVersionList[u32Idx].vDestroy();
   arHardwareVersionList.clear();
   }
}

clock_mainfi_tclMsgHardwareVersionStatus::clock_mainfi_tclMsgHardwareVersionStatus()

 {}

tS32 clock_mainfi_tclMsgHardwareVersionStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HARDWAREVERSIONSTATUS;
}


clock_mainfi_tclMsgHardwareVersionStatus::~clock_mainfi_tclMsgHardwareVersionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 clock_mainfi_tclMsgHardwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(arHardwareVersionList.size()*4);
}

fi_tclInContext& clock_mainfi_tclMsgHardwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arHardwareVersionList.size(); ++u32Idx)
      {
         arHardwareVersionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arHardwareVersionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arHardwareVersionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgHardwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arHardwareVersionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arHardwareVersionList.size(); ++u32Idx)
         (tVoid) (oOut << arHardwareVersionList[u32Idx]);
   }
   return oOut;
}

tBool clock_mainfi_tclMsgHardwareVersionStatus::operator==(const clock_mainfi_tclMsgHardwareVersionStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arHardwareVersionList.size() == roRef.arHardwareVersionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arHardwareVersionList.size()); ++u32Idx)
            bResult = bResult && (arHardwareVersionList[u32Idx] == roRef.arHardwareVersionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgSoftwareVersionUpReg::clock_mainfi_tclMsgSoftwareVersionUpReg()
 {}

tS32 clock_mainfi_tclMsgSoftwareVersionUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONUPREG;
}


clock_mainfi_tclMsgSoftwareVersionUpReg::~clock_mainfi_tclMsgSoftwareVersionUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgSoftwareVersionRelUpReg::clock_mainfi_tclMsgSoftwareVersionRelUpReg()
 {}

tS32 clock_mainfi_tclMsgSoftwareVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONRELUPREG;
}


clock_mainfi_tclMsgSoftwareVersionRelUpReg::~clock_mainfi_tclMsgSoftwareVersionRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgSoftwareVersionGet::clock_mainfi_tclMsgSoftwareVersionGet()
 {}

tS32 clock_mainfi_tclMsgSoftwareVersionGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONGET;
}


clock_mainfi_tclMsgSoftwareVersionGet::~clock_mainfi_tclMsgSoftwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgSoftwareVersionStatus::clock_mainfi_tclMsgSoftwareVersionStatus(const clock_mainfi_tclMsgSoftwareVersionStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   arSoftwareVersionList = coRef.arSoftwareVersionList;
}
clock_mainfi_tclMsgSoftwareVersionStatus& clock_mainfi_tclMsgSoftwareVersionStatus::operator=(const clock_mainfi_tclMsgSoftwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   arSoftwareVersionList = coRef.arSoftwareVersionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid clock_mainfi_tclMsgSoftwareVersionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arSoftwareVersionList.size(); ++u32Idx)
         arSoftwareVersionList[u32Idx].vDestroy();
   arSoftwareVersionList.clear();
   }
}

clock_mainfi_tclMsgSoftwareVersionStatus::clock_mainfi_tclMsgSoftwareVersionStatus()

 {}

tS32 clock_mainfi_tclMsgSoftwareVersionStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONSTATUS;
}


clock_mainfi_tclMsgSoftwareVersionStatus::~clock_mainfi_tclMsgSoftwareVersionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 clock_mainfi_tclMsgSoftwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(arSoftwareVersionList.size()*4);
}

fi_tclInContext& clock_mainfi_tclMsgSoftwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arSoftwareVersionList.size(); ++u32Idx)
      {
         arSoftwareVersionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arSoftwareVersionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arSoftwareVersionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgSoftwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arSoftwareVersionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arSoftwareVersionList.size(); ++u32Idx)
         (tVoid) (oOut << arSoftwareVersionList[u32Idx]);
   }
   return oOut;
}

tBool clock_mainfi_tclMsgSoftwareVersionStatus::operator==(const clock_mainfi_tclMsgSoftwareVersionStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arSoftwareVersionList.size() == roRef.arSoftwareVersionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arSoftwareVersionList.size()); ++u32Idx)
            bResult = bResult && (arSoftwareVersionList[u32Idx] == roRef.arSoftwareVersionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgDebugMode_TimeDateUpReg::clock_mainfi_tclMsgDebugMode_TimeDateUpReg()
 {}

tS32 clock_mainfi_tclMsgDebugMode_TimeDateUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATEUPREG;
}


clock_mainfi_tclMsgDebugMode_TimeDateUpReg::~clock_mainfi_tclMsgDebugMode_TimeDateUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgDebugMode_TimeDateRelUpReg::clock_mainfi_tclMsgDebugMode_TimeDateRelUpReg()
 {}

tS32 clock_mainfi_tclMsgDebugMode_TimeDateRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATERELUPREG;
}


clock_mainfi_tclMsgDebugMode_TimeDateRelUpReg::~clock_mainfi_tclMsgDebugMode_TimeDateRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgDebugMode_TimeDateGet::clock_mainfi_tclMsgDebugMode_TimeDateGet()
 {}

tS32 clock_mainfi_tclMsgDebugMode_TimeDateGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATEGET;
}


clock_mainfi_tclMsgDebugMode_TimeDateGet::~clock_mainfi_tclMsgDebugMode_TimeDateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgDebugMode_TimeDateStatus::clock_mainfi_tclMsgDebugMode_TimeDateStatus(const clock_mainfi_tclMsgDebugMode_TimeDateStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   bdebugMode = coRef.bdebugMode;
}
clock_mainfi_tclMsgDebugMode_TimeDateStatus& clock_mainfi_tclMsgDebugMode_TimeDateStatus::operator=(const clock_mainfi_tclMsgDebugMode_TimeDateStatus& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   bdebugMode = coRef.bdebugMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgDebugMode_TimeDateStatus::clock_mainfi_tclMsgDebugMode_TimeDateStatus()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hours(0)
,u8Minutes(0)
,u8Seconds(0)
,u8Weekday(0)
,bdebugMode(0)
 {}

tS32 clock_mainfi_tclMsgDebugMode_TimeDateStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATESTATUS;
}


clock_mainfi_tclMsgDebugMode_TimeDateStatus::~clock_mainfi_tclMsgDebugMode_TimeDateStatus()
{}

tU32 clock_mainfi_tclMsgDebugMode_TimeDateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& clock_mainfi_tclMsgDebugMode_TimeDateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hours);
   (tVoid) (oIn >> u8Minutes);
   (tVoid) (oIn >> u8Seconds);
   (tVoid) (oIn >> u8Weekday);
   (tVoid) (oIn >> bdebugMode);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgDebugMode_TimeDateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hours);
   (tVoid) (oOut << u8Minutes);
   (tVoid) (oOut << u8Seconds);
   (tVoid) (oOut << u8Weekday);
   (tVoid) (oOut << bdebugMode);
   return oOut;
}

tBool clock_mainfi_tclMsgDebugMode_TimeDateStatus::operator==(const clock_mainfi_tclMsgDebugMode_TimeDateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hours == roRef.u8Hours);
   bResult = bResult && (u8Minutes == roRef.u8Minutes);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   bResult = bResult && (u8Weekday == roRef.u8Weekday);
   bResult = bResult && (bdebugMode == roRef.bdebugMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgDebugMode_TimeDateSet::clock_mainfi_tclMsgDebugMode_TimeDateSet(const clock_mainfi_tclMsgDebugMode_TimeDateSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   bdebugMode = coRef.bdebugMode;
   u8ChangeMask = coRef.u8ChangeMask;
}
clock_mainfi_tclMsgDebugMode_TimeDateSet& clock_mainfi_tclMsgDebugMode_TimeDateSet::operator=(const clock_mainfi_tclMsgDebugMode_TimeDateSet& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   bdebugMode = coRef.bdebugMode;
   u8ChangeMask = coRef.u8ChangeMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgDebugMode_TimeDateSet::clock_mainfi_tclMsgDebugMode_TimeDateSet()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hours(0)
,u8Minutes(0)
,u8Seconds(0)
,u8Weekday(0)
,bdebugMode(0)
,u8ChangeMask(0)
 {}

tS32 clock_mainfi_tclMsgDebugMode_TimeDateSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_DEBUGMODE_TIMEDATESET;
}


clock_mainfi_tclMsgDebugMode_TimeDateSet::~clock_mainfi_tclMsgDebugMode_TimeDateSet()
{}

tU32 clock_mainfi_tclMsgDebugMode_TimeDateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& clock_mainfi_tclMsgDebugMode_TimeDateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hours);
   (tVoid) (oIn >> u8Minutes);
   (tVoid) (oIn >> u8Seconds);
   (tVoid) (oIn >> u8Weekday);
   (tVoid) (oIn >> bdebugMode);
   (tVoid) (oIn >> u8ChangeMask);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgDebugMode_TimeDateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hours);
   (tVoid) (oOut << u8Minutes);
   (tVoid) (oOut << u8Seconds);
   (tVoid) (oOut << u8Weekday);
   (tVoid) (oOut << bdebugMode);
   (tVoid) (oOut << u8ChangeMask);
   return oOut;
}

tBool clock_mainfi_tclMsgDebugMode_TimeDateSet::operator==(const clock_mainfi_tclMsgDebugMode_TimeDateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hours == roRef.u8Hours);
   bResult = bResult && (u8Minutes == roRef.u8Minutes);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   bResult = bResult && (u8Weekday == roRef.u8Weekday);
   bResult = bResult && (bdebugMode == roRef.bdebugMode);
   bResult = bResult && (u8ChangeMask == roRef.u8ChangeMask);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgUTC_TimeDateUpdateUpReg::clock_mainfi_tclMsgUTC_TimeDateUpdateUpReg()
 {}

tS32 clock_mainfi_tclMsgUTC_TimeDateUpdateUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATEUPREG;
}


clock_mainfi_tclMsgUTC_TimeDateUpdateUpReg::~clock_mainfi_tclMsgUTC_TimeDateUpdateUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgUTC_TimeDateUpdateRelUpReg::clock_mainfi_tclMsgUTC_TimeDateUpdateRelUpReg()
 {}

tS32 clock_mainfi_tclMsgUTC_TimeDateUpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATERELUPREG;
}


clock_mainfi_tclMsgUTC_TimeDateUpdateRelUpReg::~clock_mainfi_tclMsgUTC_TimeDateUpdateRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgUTC_TimeDateUpdateGet::clock_mainfi_tclMsgUTC_TimeDateUpdateGet()
 {}

tS32 clock_mainfi_tclMsgUTC_TimeDateUpdateGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATEGET;
}


clock_mainfi_tclMsgUTC_TimeDateUpdateGet::~clock_mainfi_tclMsgUTC_TimeDateUpdateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgUTC_TimeDateUpdateStatus::clock_mainfi_tclMsgUTC_TimeDateUpdateStatus(const clock_mainfi_tclMsgUTC_TimeDateUpdateStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   bTimeValidity = coRef.bTimeValidity;
}
clock_mainfi_tclMsgUTC_TimeDateUpdateStatus& clock_mainfi_tclMsgUTC_TimeDateUpdateStatus::operator=(const clock_mainfi_tclMsgUTC_TimeDateUpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   bTimeValidity = coRef.bTimeValidity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgUTC_TimeDateUpdateStatus::clock_mainfi_tclMsgUTC_TimeDateUpdateStatus()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hours(0)
,u8Minutes(0)
,u8Seconds(0)
,u8Weekday(0)
,bTimeValidity(0)
 {}

tS32 clock_mainfi_tclMsgUTC_TimeDateUpdateStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_UTC_TIMEDATEUPDATESTATUS;
}


clock_mainfi_tclMsgUTC_TimeDateUpdateStatus::~clock_mainfi_tclMsgUTC_TimeDateUpdateStatus()
{}

tU32 clock_mainfi_tclMsgUTC_TimeDateUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& clock_mainfi_tclMsgUTC_TimeDateUpdateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hours);
   (tVoid) (oIn >> u8Minutes);
   (tVoid) (oIn >> u8Seconds);
   (tVoid) (oIn >> u8Weekday);
   (tVoid) (oIn >> bTimeValidity);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgUTC_TimeDateUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hours);
   (tVoid) (oOut << u8Minutes);
   (tVoid) (oOut << u8Seconds);
   (tVoid) (oOut << u8Weekday);
   (tVoid) (oOut << bTimeValidity);
   return oOut;
}

tBool clock_mainfi_tclMsgUTC_TimeDateUpdateStatus::operator==(const clock_mainfi_tclMsgUTC_TimeDateUpdateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hours == roRef.u8Hours);
   bResult = bResult && (u8Minutes == roRef.u8Minutes);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   bResult = bResult && (u8Weekday == roRef.u8Weekday);
   bResult = bResult && (bTimeValidity == roRef.bTimeValidity);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgHUD_ActivationGet::clock_mainfi_tclMsgHUD_ActivationGet()
 {}

tS32 clock_mainfi_tclMsgHUD_ActivationGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONGET;
}


clock_mainfi_tclMsgHUD_ActivationGet::~clock_mainfi_tclMsgHUD_ActivationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgHUD_ActivationSet::clock_mainfi_tclMsgHUD_ActivationSet(const clock_mainfi_tclMsgHUD_ActivationSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   enHUD_Setting = coRef.enHUD_Setting;
}
clock_mainfi_tclMsgHUD_ActivationSet& clock_mainfi_tclMsgHUD_ActivationSet::operator=(const clock_mainfi_tclMsgHUD_ActivationSet& coRef)
{
   if (this == &coRef) return *this;
   enHUD_Setting = coRef.enHUD_Setting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgHUD_ActivationSet::clock_mainfi_tclMsgHUD_ActivationSet()
:enHUD_Setting()
 {}

tS32 clock_mainfi_tclMsgHUD_ActivationSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONSET;
}


clock_mainfi_tclMsgHUD_ActivationSet::~clock_mainfi_tclMsgHUD_ActivationSet()
{}

tU32 clock_mainfi_tclMsgHUD_ActivationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgHUD_ActivationSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enHUD_Setting);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgHUD_ActivationSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enHUD_Setting);
   return oOut;
}

tBool clock_mainfi_tclMsgHUD_ActivationSet::operator==(const clock_mainfi_tclMsgHUD_ActivationSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enHUD_Setting == roRef.enHUD_Setting);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgHUD_ActivationUpReg::clock_mainfi_tclMsgHUD_ActivationUpReg()
 {}

tS32 clock_mainfi_tclMsgHUD_ActivationUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONUPREG;
}


clock_mainfi_tclMsgHUD_ActivationUpReg::~clock_mainfi_tclMsgHUD_ActivationUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgHUD_ActivationRelUpReg::clock_mainfi_tclMsgHUD_ActivationRelUpReg()
 {}

tS32 clock_mainfi_tclMsgHUD_ActivationRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONRELUPREG;
}


clock_mainfi_tclMsgHUD_ActivationRelUpReg::~clock_mainfi_tclMsgHUD_ActivationRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgHUD_ActivationStatus::clock_mainfi_tclMsgHUD_ActivationStatus(const clock_mainfi_tclMsgHUD_ActivationStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   bHUD_Status = coRef.bHUD_Status;
}
clock_mainfi_tclMsgHUD_ActivationStatus& clock_mainfi_tclMsgHUD_ActivationStatus::operator=(const clock_mainfi_tclMsgHUD_ActivationStatus& coRef)
{
   if (this == &coRef) return *this;
   bHUD_Status = coRef.bHUD_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgHUD_ActivationStatus::clock_mainfi_tclMsgHUD_ActivationStatus()
:bHUD_Status(0)
 {}

tS32 clock_mainfi_tclMsgHUD_ActivationStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HUD_ACTIVATIONSTATUS;
}


clock_mainfi_tclMsgHUD_ActivationStatus::~clock_mainfi_tclMsgHUD_ActivationStatus()
{}

tU32 clock_mainfi_tclMsgHUD_ActivationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& clock_mainfi_tclMsgHUD_ActivationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bHUD_Status);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgHUD_ActivationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bHUD_Status);
   return oOut;
}

tBool clock_mainfi_tclMsgHUD_ActivationStatus::operator==(const clock_mainfi_tclMsgHUD_ActivationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bHUD_Status == roRef.bHUD_Status);
   return bResult;
}

//=============================================================================

clock_mainfi_tclMsgHUD_PostitionUpReg::clock_mainfi_tclMsgHUD_PostitionUpReg()
 {}

tS32 clock_mainfi_tclMsgHUD_PostitionUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONUPREG;
}


clock_mainfi_tclMsgHUD_PostitionUpReg::~clock_mainfi_tclMsgHUD_PostitionUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgHUD_PostitionRelUpReg::clock_mainfi_tclMsgHUD_PostitionRelUpReg()
 {}

tS32 clock_mainfi_tclMsgHUD_PostitionRelUpReg::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONRELUPREG;
}


clock_mainfi_tclMsgHUD_PostitionRelUpReg::~clock_mainfi_tclMsgHUD_PostitionRelUpReg()
{}

//=============================================================================

clock_mainfi_tclMsgHUD_PostitionGet::clock_mainfi_tclMsgHUD_PostitionGet()
 {}

tS32 clock_mainfi_tclMsgHUD_PostitionGet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONGET;
}


clock_mainfi_tclMsgHUD_PostitionGet::~clock_mainfi_tclMsgHUD_PostitionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgHUD_PostitionStatus::clock_mainfi_tclMsgHUD_PostitionStatus(const clock_mainfi_tclMsgHUD_PostitionStatus& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   u8Up_Position = coRef.u8Up_Position;
   u8Down_Position = coRef.u8Down_Position;
}
clock_mainfi_tclMsgHUD_PostitionStatus& clock_mainfi_tclMsgHUD_PostitionStatus::operator=(const clock_mainfi_tclMsgHUD_PostitionStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Up_Position = coRef.u8Up_Position;
   u8Down_Position = coRef.u8Down_Position;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgHUD_PostitionStatus::clock_mainfi_tclMsgHUD_PostitionStatus()
:u8Up_Position(0)
,u8Down_Position(0)
 {}

tS32 clock_mainfi_tclMsgHUD_PostitionStatus::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONSTATUS;
}


clock_mainfi_tclMsgHUD_PostitionStatus::~clock_mainfi_tclMsgHUD_PostitionStatus()
{}

tU32 clock_mainfi_tclMsgHUD_PostitionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& clock_mainfi_tclMsgHUD_PostitionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Up_Position);
   (tVoid) (oIn >> u8Down_Position);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgHUD_PostitionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Up_Position);
   (tVoid) (oOut << u8Down_Position);
   return oOut;
}

tBool clock_mainfi_tclMsgHUD_PostitionStatus::operator==(const clock_mainfi_tclMsgHUD_PostitionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Up_Position == roRef.u8Up_Position);
   bResult = bResult && (u8Down_Position == roRef.u8Down_Position);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
clock_mainfi_tclMsgHUD_PostitionSet::clock_mainfi_tclMsgHUD_PostitionSet(const clock_mainfi_tclMsgHUD_PostitionSet& coRef)
   : clock_mainfi_tclMsgBaseMessage(coRef)
{
   u8Up_Position = coRef.u8Up_Position;
   u8Down_Position = coRef.u8Down_Position;
}
clock_mainfi_tclMsgHUD_PostitionSet& clock_mainfi_tclMsgHUD_PostitionSet::operator=(const clock_mainfi_tclMsgHUD_PostitionSet& coRef)
{
   if (this == &coRef) return *this;
   u8Up_Position = coRef.u8Up_Position;
   u8Down_Position = coRef.u8Down_Position;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

clock_mainfi_tclMsgHUD_PostitionSet::clock_mainfi_tclMsgHUD_PostitionSet()
:u8Up_Position(0)
,u8Down_Position(0)
 {}

tS32 clock_mainfi_tclMsgHUD_PostitionSet::s32GetTypeId() const
{
   return (tS32) clock_mainfi_tclToken::EN_MSG_HUD_POSTITIONSET;
}


clock_mainfi_tclMsgHUD_PostitionSet::~clock_mainfi_tclMsgHUD_PostitionSet()
{}

tU32 clock_mainfi_tclMsgHUD_PostitionSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& clock_mainfi_tclMsgHUD_PostitionSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Up_Position);
   (tVoid) (oIn >> u8Down_Position);
   return oIn;
}

fi_tclOutContext& clock_mainfi_tclMsgHUD_PostitionSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Up_Position);
   (tVoid) (oOut << u8Down_Position);
   return oOut;
}

tBool clock_mainfi_tclMsgHUD_PostitionSet::operator==(const clock_mainfi_tclMsgHUD_PostitionSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Up_Position == roRef.u8Up_Position);
   bResult = bResult && (u8Down_Position == roRef.u8Down_Position);
   return bResult;
}

