#ifndef __CLOCK_MAINFIDEBUGVISITOR_H__
#define __CLOCK_MAINFIDEBUGVISITOR_H__

class MY_DECL clock_mainfi_tclPrintVisitor : public clock_mainfi_tclVisitorBase {

private:
   /* default constructor */ clock_mainfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   clock_mainfi_tclPrintVisitor(clock_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(clock_fi_tclU8& oU8);
   virtual tVoid vVisitS8(clock_fi_tclS8& oS8);
   virtual tVoid vVisitU16(clock_fi_tclU16& oU16);
   virtual tVoid vVisitS16(clock_fi_tclS16& oS16);
   virtual tVoid vVisitU24(clock_fi_tclU24& oU24);
   virtual tVoid vVisitS24(clock_fi_tclS24& oS24);
   virtual tVoid vVisitU32(clock_fi_tclU32& oU32);
   virtual tVoid vVisitS32(clock_fi_tclS32& oS32);
   virtual tVoid vVisitU64(clock_fi_tclU64& oU64);
   virtual tVoid vVisitS64(clock_fi_tclS64& oS64);
   virtual tVoid vVisitBool(clock_fi_tclBool& oBool);
   virtual tVoid vVisitString(clock_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(clock_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(clock_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(clock_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DefSetMode(clock_fi_tcl_e8_DefSetMode& o_e8_DefSetMode);
   virtual tVoid vVisit_e8_DefSetGroups(clock_fi_tcl_e8_DefSetGroups& o_e8_DefSetGroups);
   virtual tVoid vVisit_e8_MCanUnitType(clock_fi_tcl_e8_MCanUnitType& o_e8_MCanUnitType);
   virtual tVoid vVisit_e8_UnitType(clock_fi_tcl_e8_UnitType& o_e8_UnitType);
   virtual tBool bDoExpand_SWC_UnitConnectionStatus(clock_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VdClock_VersionInfo(clock_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VdClock_UnitVersion(clock_mainfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisitDCLK_TEN_ClockSourceStatus(clock_fi_tclDCLK_TEN_ClockSourceStatus& oDCLK_TEN_ClockSourceStatus);
   virtual tVoid vVisitDCLK_TEN_DateFormat(clock_fi_tclDCLK_TEN_DateFormat& oDCLK_TEN_DateFormat);
   virtual tVoid vVisitDCLK_TEN_DST_Setting(clock_fi_tclDCLK_TEN_DST_Setting& oDCLK_TEN_DST_Setting);
   virtual tVoid vVisitDCLK_TEN_FormatSourceStatus(clock_fi_tclDCLK_TEN_FormatSourceStatus& oDCLK_TEN_FormatSourceStatus);
   virtual tVoid vVisitDCLK_TEN_GPS_EPOCH(clock_fi_tclDCLK_TEN_GPS_EPOCH& oDCLK_TEN_GPS_EPOCH);
   virtual tVoid vVisitDCLK_TEN_GPSRTCTIMESTATE(clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE& oDCLK_TEN_GPSRTCTIMESTATE);
   virtual tVoid vVisitDCLK_TEN_NewDateFormat(clock_fi_tclDCLK_TEN_NewDateFormat& oDCLK_TEN_NewDateFormat);
   virtual tVoid vVisitDCLK_TEN_SyncMode(clock_fi_tclDCLK_TEN_SyncMode& oDCLK_TEN_SyncMode);
   virtual tVoid vVisitDCLK_TEN_TimeFormat(clock_fi_tclDCLK_TEN_TimeFormat& oDCLK_TEN_TimeFormat);
   virtual tVoid vVisitDCLK_TEN_TIMEZONE_Setting(clock_fi_tclDCLK_TEN_TIMEZONE_Setting& oDCLK_TEN_TIMEZONE_Setting);
   virtual tVoid vVisitDCLK_TEN_HUD_ActivationSettings(clock_fi_tclDCLK_TEN_HUD_ActivationSettings& oDCLK_TEN_HUD_ActivationSettings);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   clock_fi_tclOutput* poOutput;
};


class MY_DECL clock_mainfi_tclRandomInitVisitor : public clock_mainfi_tclVisitorBase {
public:

   clock_mainfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(clock_fi_tclU8& oU8);
   virtual tVoid vVisitS8(clock_fi_tclS8& oS8);
   virtual tVoid vVisitU16(clock_fi_tclU16& oU16);
   virtual tVoid vVisitS16(clock_fi_tclS16& oS16);
   virtual tVoid vVisitU24(clock_fi_tclU24& oU24);
   virtual tVoid vVisitS24(clock_fi_tclS24& oS24);
   virtual tVoid vVisitU32(clock_fi_tclU32& oU32);
   virtual tVoid vVisitS32(clock_fi_tclS32& oS32);
   virtual tVoid vVisitU64(clock_fi_tclU64& oU64);
   virtual tVoid vVisitS64(clock_fi_tclS64& oS64);
   virtual tVoid vVisitBool(clock_fi_tclBool& oBool);
   virtual tVoid vVisitString(clock_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(clock_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(clock_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e8_DefSetMode(clock_fi_tcl_e8_DefSetMode& o_e8_DefSetMode);
   virtual tVoid vVisit_e8_DefSetGroups(clock_fi_tcl_e8_DefSetGroups& o_e8_DefSetGroups);
   virtual tVoid vVisit_e8_MCanUnitType(clock_fi_tcl_e8_MCanUnitType& o_e8_MCanUnitType);
   virtual tVoid vVisit_e8_UnitType(clock_fi_tcl_e8_UnitType& o_e8_UnitType);
   virtual tVoid vVisitDCLK_TEN_ClockSourceStatus(clock_fi_tclDCLK_TEN_ClockSourceStatus& oDCLK_TEN_ClockSourceStatus);
   virtual tVoid vVisitDCLK_TEN_DateFormat(clock_fi_tclDCLK_TEN_DateFormat& oDCLK_TEN_DateFormat);
   virtual tVoid vVisitDCLK_TEN_DST_Setting(clock_fi_tclDCLK_TEN_DST_Setting& oDCLK_TEN_DST_Setting);
   virtual tVoid vVisitDCLK_TEN_FormatSourceStatus(clock_fi_tclDCLK_TEN_FormatSourceStatus& oDCLK_TEN_FormatSourceStatus);
   virtual tVoid vVisitDCLK_TEN_GPS_EPOCH(clock_fi_tclDCLK_TEN_GPS_EPOCH& oDCLK_TEN_GPS_EPOCH);
   virtual tVoid vVisitDCLK_TEN_GPSRTCTIMESTATE(clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE& oDCLK_TEN_GPSRTCTIMESTATE);
   virtual tVoid vVisitDCLK_TEN_NewDateFormat(clock_fi_tclDCLK_TEN_NewDateFormat& oDCLK_TEN_NewDateFormat);
   virtual tVoid vVisitDCLK_TEN_SyncMode(clock_fi_tclDCLK_TEN_SyncMode& oDCLK_TEN_SyncMode);
   virtual tVoid vVisitDCLK_TEN_TimeFormat(clock_fi_tclDCLK_TEN_TimeFormat& oDCLK_TEN_TimeFormat);
   virtual tVoid vVisitDCLK_TEN_TIMEZONE_Setting(clock_fi_tclDCLK_TEN_TIMEZONE_Setting& oDCLK_TEN_TIMEZONE_Setting);
   virtual tVoid vVisitDCLK_TEN_HUD_ActivationSettings(clock_fi_tclDCLK_TEN_HUD_ActivationSettings& oDCLK_TEN_HUD_ActivationSettings);
	tU32 u32ListSize;
};

#endif
