/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef CFC_VEHICLEFITYPES_HEADER
#define CFC_VEHICLEFITYPES_HEADER


class cfc_vehiclefi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for CFC_VEHICLE_FI message types

fi_tclMessageBase* cfc_vehiclefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class cfc_vehiclefi_tclMsgBaseMessage : public cfc_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   cfc_vehiclefi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class cfc_vehiclefi_tclMsgIgnitionUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIgnitionUpReg();

   virtual ~cfc_vehiclefi_tclMsgIgnitionUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgIgnitionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIgnitionRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIgnitionRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgIgnitionRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgIgnitionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIgnitionGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIgnitionGet();

   virtual ~cfc_vehiclefi_tclMsgIgnitionGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgIgnitionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIgnitionStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIgnitionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgIgnitionStatus& operator=(const cfc_vehiclefi_tclMsgIgnitionStatus& coRef);
   cfc_vehiclefi_tclMsgIgnitionStatus(const cfc_vehiclefi_tclMsgIgnitionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool IgnitionStatus;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgIgnitionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgIgnitionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgKey_InsertionUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgKey_InsertionUpReg();

   virtual ~cfc_vehiclefi_tclMsgKey_InsertionUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgKey_InsertionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgKey_InsertionRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgKey_InsertionRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgKey_InsertionRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgKey_InsertionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgKey_InsertionGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgKey_InsertionGet();

   virtual ~cfc_vehiclefi_tclMsgKey_InsertionGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgKey_InsertionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgKey_InsertionStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgKey_InsertionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgKey_InsertionStatus& operator=(const cfc_vehiclefi_tclMsgKey_InsertionStatus& coRef);
   cfc_vehiclefi_tclMsgKey_InsertionStatus(const cfc_vehiclefi_tclMsgKey_InsertionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool KeyInsertionState;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgKey_InsertionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgKey_InsertionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIllumination_CAN_DisplayUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIllumination_CAN_DisplayUpReg();

   virtual ~cfc_vehiclefi_tclMsgIllumination_CAN_DisplayUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgIllumination_CAN_DisplayUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIllumination_CAN_DisplayRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIllumination_CAN_DisplayRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgIllumination_CAN_DisplayRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgIllumination_CAN_DisplayRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIllumination_CAN_DisplayGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIllumination_CAN_DisplayGet();

   virtual ~cfc_vehiclefi_tclMsgIllumination_CAN_DisplayGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgIllumination_CAN_DisplayGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus& operator=(const cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus& coRef);
   cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus(const cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 IlluminationValue;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgIllumination_CAN_DisplayStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus(const cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Illumination_CAN_Day_Night;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Illumination_CAN_Day_NightStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorUpReg();

   virtual ~cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorGet();

   virtual ~cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus& operator=(const cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus& coRef);
   cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus(const cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 IlluminationValue;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgPQ_Illumination_CAN_SensorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgError_Forget_CounterUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgError_Forget_CounterUpReg();

   virtual ~cfc_vehiclefi_tclMsgError_Forget_CounterUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgError_Forget_CounterUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgError_Forget_CounterRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgError_Forget_CounterRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgError_Forget_CounterRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgError_Forget_CounterRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgError_Forget_CounterGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgError_Forget_CounterGet();

   virtual ~cfc_vehiclefi_tclMsgError_Forget_CounterGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgError_Forget_CounterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgError_Forget_CounterStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgError_Forget_CounterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgError_Forget_CounterStatus& operator=(const cfc_vehiclefi_tclMsgError_Forget_CounterStatus& coRef);
   cfc_vehiclefi_tclMsgError_Forget_CounterStatus(const cfc_vehiclefi_tclMsgError_Forget_CounterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CounterValue;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgError_Forget_CounterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgError_Forget_CounterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_MileageUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_MileageUpReg();

   virtual ~cfc_vehiclefi_tclMsgCurrent_MileageUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCurrent_MileageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_MileageRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_MileageRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgCurrent_MileageRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCurrent_MileageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_MileageGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_MileageGet();

   virtual ~cfc_vehiclefi_tclMsgCurrent_MileageGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCurrent_MileageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_MileageStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_MileageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgCurrent_MileageStatus& operator=(const cfc_vehiclefi_tclMsgCurrent_MileageStatus& coRef);
   cfc_vehiclefi_tclMsgCurrent_MileageStatus(const cfc_vehiclefi_tclMsgCurrent_MileageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Value;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgCurrent_MileageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgCurrent_MileageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_DateUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_DateUpReg();

   virtual ~cfc_vehiclefi_tclMsgCurrent_DateUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCurrent_DateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_DateRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_DateRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgCurrent_DateRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCurrent_DateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_DateGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_DateGet();

   virtual ~cfc_vehiclefi_tclMsgCurrent_DateGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCurrent_DateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_DateStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_DateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgCurrent_DateStatus& operator=(const cfc_vehiclefi_tclMsgCurrent_DateStatus& coRef);
   cfc_vehiclefi_tclMsgCurrent_DateStatus(const cfc_vehiclefi_tclMsgCurrent_DateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Year;
   tU8 Month;
   tU8 Day;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgCurrent_DateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgCurrent_DateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_TimeUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_TimeUpReg();

   virtual ~cfc_vehiclefi_tclMsgCurrent_TimeUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCurrent_TimeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_TimeRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_TimeRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgCurrent_TimeRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCurrent_TimeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_TimeGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_TimeGet();

   virtual ~cfc_vehiclefi_tclMsgCurrent_TimeGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCurrent_TimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_TimeStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_TimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgCurrent_TimeStatus& operator=(const cfc_vehiclefi_tclMsgCurrent_TimeStatus& coRef);
   cfc_vehiclefi_tclMsgCurrent_TimeStatus(const cfc_vehiclefi_tclMsgCurrent_TimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Hour;
   tU8 Minutes;
   tU8 Seconds;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgCurrent_TimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgCurrent_TimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgACC_StatusUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgACC_StatusUpReg();

   virtual ~cfc_vehiclefi_tclMsgACC_StatusUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgACC_StatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgACC_StatusRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgACC_StatusRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgACC_StatusRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgACC_StatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgACC_StatusGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgACC_StatusGet();

   virtual ~cfc_vehiclefi_tclMsgACC_StatusGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgACC_StatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgACC_StatusStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgACC_StatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgACC_StatusStatus& operator=(const cfc_vehiclefi_tclMsgACC_StatusStatus& coRef);
   cfc_vehiclefi_tclMsgACC_StatusStatus(const cfc_vehiclefi_tclMsgACC_StatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_Vehicle_Data_U8_ACC_Status Status;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgACC_StatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgACC_StatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCranking_RequestUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCranking_RequestUpReg();

   virtual ~cfc_vehiclefi_tclMsgCranking_RequestUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCranking_RequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCranking_RequestRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCranking_RequestRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgCranking_RequestRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCranking_RequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCranking_RequestGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCranking_RequestGet();

   virtual ~cfc_vehiclefi_tclMsgCranking_RequestGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCranking_RequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCranking_RequestStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCranking_RequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgCranking_RequestStatus& operator=(const cfc_vehiclefi_tclMsgCranking_RequestStatus& coRef);
   cfc_vehiclefi_tclMsgCranking_RequestStatus(const cfc_vehiclefi_tclMsgCranking_RequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RequestState;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgCranking_RequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgCranking_RequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgReverseGearUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgReverseGearUpReg();

   virtual ~cfc_vehiclefi_tclMsgReverseGearUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgReverseGearUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgReverseGearRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgReverseGearRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgReverseGearRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgReverseGearRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgReverseGearGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgReverseGearGet();

   virtual ~cfc_vehiclefi_tclMsgReverseGearGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgReverseGearGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgReverseGearStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgReverseGearStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgReverseGearStatus& operator=(const cfc_vehiclefi_tclMsgReverseGearStatus& coRef);
   cfc_vehiclefi_tclMsgReverseGearStatus(const cfc_vehiclefi_tclMsgReverseGearStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgReverseGearStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgReverseGearStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCrankingUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCrankingUpReg();

   virtual ~cfc_vehiclefi_tclMsgCrankingUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCrankingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCrankingRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCrankingRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgCrankingRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCrankingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCrankingGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCrankingGet();

   virtual ~cfc_vehiclefi_tclMsgCrankingGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCrankingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCrankingStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCrankingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgCrankingStatus& operator=(const cfc_vehiclefi_tclMsgCrankingStatus& coRef);
   cfc_vehiclefi_tclMsgCrankingStatus(const cfc_vehiclefi_tclMsgCrankingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgCrankingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgCrankingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgAccelerator_KickdownUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgAccelerator_KickdownUpReg();

   virtual ~cfc_vehiclefi_tclMsgAccelerator_KickdownUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgAccelerator_KickdownUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgAccelerator_KickdownRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgAccelerator_KickdownRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgAccelerator_KickdownRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgAccelerator_KickdownRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgAccelerator_KickdownGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgAccelerator_KickdownGet();

   virtual ~cfc_vehiclefi_tclMsgAccelerator_KickdownGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgAccelerator_KickdownGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgAccelerator_KickdownStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgAccelerator_KickdownStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgAccelerator_KickdownStatus& operator=(const cfc_vehiclefi_tclMsgAccelerator_KickdownStatus& coRef);
   cfc_vehiclefi_tclMsgAccelerator_KickdownStatus(const cfc_vehiclefi_tclMsgAccelerator_KickdownStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgAccelerator_KickdownStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgAccelerator_KickdownStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSpeedUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSpeedUpReg();

   virtual ~cfc_vehiclefi_tclMsgSpeedUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgSpeedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSpeedRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSpeedRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgSpeedRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgSpeedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSpeedGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSpeedGet();

   virtual ~cfc_vehiclefi_tclMsgSpeedGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgSpeedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSpeedStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSpeedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgSpeedStatus& operator=(const cfc_vehiclefi_tclMsgSpeedStatus& coRef);
   cfc_vehiclefi_tclMsgSpeedStatus(const cfc_vehiclefi_tclMsgSpeedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 Speed;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgSpeedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgSpeedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIndicatorUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIndicatorUpReg();

   virtual ~cfc_vehiclefi_tclMsgIndicatorUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgIndicatorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIndicatorRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIndicatorRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgIndicatorRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgIndicatorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIndicatorGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIndicatorGet();

   virtual ~cfc_vehiclefi_tclMsgIndicatorGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgIndicatorGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIndicatorStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIndicatorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgIndicatorStatus& operator=(const cfc_vehiclefi_tclMsgIndicatorStatus& coRef);
   cfc_vehiclefi_tclMsgIndicatorStatus(const cfc_vehiclefi_tclMsgIndicatorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Right_Status;
   tBool Left_Status;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgIndicatorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgIndicatorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgRemote_Start_OperationUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgRemote_Start_OperationUpReg();

   virtual ~cfc_vehiclefi_tclMsgRemote_Start_OperationUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgRemote_Start_OperationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgRemote_Start_OperationRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgRemote_Start_OperationRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgRemote_Start_OperationRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgRemote_Start_OperationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgRemote_Start_OperationGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgRemote_Start_OperationGet();

   virtual ~cfc_vehiclefi_tclMsgRemote_Start_OperationGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgRemote_Start_OperationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgRemote_Start_OperationStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgRemote_Start_OperationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgRemote_Start_OperationStatus& operator=(const cfc_vehiclefi_tclMsgRemote_Start_OperationStatus& coRef);
   cfc_vehiclefi_tclMsgRemote_Start_OperationStatus(const cfc_vehiclefi_tclMsgRemote_Start_OperationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgRemote_Start_OperationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgRemote_Start_OperationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Crash_IntensityUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Crash_IntensityUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Crash_IntensityUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Crash_IntensityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Crash_IntensityRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Crash_IntensityRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Crash_IntensityRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Crash_IntensityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Crash_IntensityGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Crash_IntensityGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Crash_IntensityGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Crash_IntensityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus(const cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_Vehicle_Data_U8_Crash_Intensity Status;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Crash_IntensityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Anzeige_aktivUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Anzeige_aktivUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Anzeige_aktivUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Anzeige_aktivUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Anzeige_aktivRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Anzeige_aktivRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Anzeige_aktivRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Anzeige_aktivRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Anzeige_aktivGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Anzeige_aktivGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Anzeige_aktivGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Anzeige_aktivGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus(const cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Anzeige_aktivStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgOil_Level_Min_WarningUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgOil_Level_Min_WarningUpReg();

   virtual ~cfc_vehiclefi_tclMsgOil_Level_Min_WarningUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgOil_Level_Min_WarningUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgOil_Level_Min_WarningRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgOil_Level_Min_WarningRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgOil_Level_Min_WarningRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgOil_Level_Min_WarningRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgOil_Level_Min_WarningGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgOil_Level_Min_WarningGet();

   virtual ~cfc_vehiclefi_tclMsgOil_Level_Min_WarningGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgOil_Level_Min_WarningGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus& operator=(const cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus& coRef);
   cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus(const cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Warning;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgOil_Level_Min_WarningStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_OelstandUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_OelstandUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_OelstandUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_OelstandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_OelstandRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_OelstandRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_OelstandRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_OelstandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_OelstandGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_OelstandGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_OelstandGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_OelstandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_OelstandStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_OelstandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_OelstandStatus& operator=(const cfc_vehiclefi_tclMsgMQB_OelstandStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_OelstandStatus(const cfc_vehiclefi_tclMsgMQB_OelstandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Level;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_OelstandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_OelstandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus(const cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool State;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Oelsystem_aktivStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_betriebswarmUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_betriebswarmUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_betriebswarmUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_betriebswarmUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_betriebswarmRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_betriebswarmRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_betriebswarmRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_betriebswarmRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_betriebswarmGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_betriebswarmGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_betriebswarmGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_betriebswarmGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_betriebswarmStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_betriebswarmStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_betriebswarmStatus& operator=(const cfc_vehiclefi_tclMsgMQB_betriebswarmStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_betriebswarmStatus(const cfc_vehiclefi_tclMsgMQB_betriebswarmStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool State;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_betriebswarmStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_betriebswarmStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus(const cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Warning;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Ueberfuell_WarnStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus(const cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_Vehicle_Data_U8_Oil_Info_Status State;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Oil_Info_ValidityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_OelmengeUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_OelmengeUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_OelmengeUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_OelmengeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_OelmengeRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_OelmengeRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_OelmengeRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_OelmengeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_OelmengeGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_OelmengeGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_OelmengeGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_OelmengeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_OelmengeStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_OelmengeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_OelmengeStatus& operator=(const cfc_vehiclefi_tclMsgMQB_OelmengeStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_OelmengeStatus(const cfc_vehiclefi_tclMsgMQB_OelmengeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 State;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_OelmengeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_OelmengeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus(const cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Available;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Oil_Level_AvailableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningUpReg();

   virtual ~cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningGet();

   virtual ~cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus& operator=(const cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus& coRef);
   cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus(const cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Warning;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgOil_Level_Unterfuell_WarningStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Vehicle_LockedUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Vehicle_LockedUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Vehicle_LockedUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Vehicle_LockedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Vehicle_LockedRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Vehicle_LockedRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Vehicle_LockedRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Vehicle_LockedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Vehicle_LockedGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Vehicle_LockedGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Vehicle_LockedGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Vehicle_LockedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus(const cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Locked;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Vehicle_LockedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Door_StateUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Door_StateUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Door_StateUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Door_StateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Door_StateRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Door_StateRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Door_StateRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Door_StateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Door_StateGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Door_StateGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Door_StateGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Door_StateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Door_StateStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Door_StateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Door_StateStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Door_StateStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Door_StateStatus(const cfc_vehiclefi_tclMsgMQB_Door_StateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool MQB_ZV_HFS_offen;
   tBool MQB_ZV_HBFS_offen;
   tBool MQB_ZV_BT_offen;
   tBool MQB_ZV_FT_offen;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Door_StateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Door_StateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Roof_StateUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Roof_StateUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Roof_StateUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Roof_StateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Roof_StateRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Roof_StateRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Roof_StateRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Roof_StateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Roof_StateGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Roof_StateGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Roof_StateGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Roof_StateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Roof_StateStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Roof_StateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Roof_StateStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Roof_StateStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Roof_StateStatus(const cfc_vehiclefi_tclMsgMQB_Roof_StateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool MQB_VS_VD_offen_ver;
   tBool MQB_VS_VD_zu_ver;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Roof_StateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Roof_StateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_TrunkUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_TrunkUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_TrunkUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_TrunkUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_TrunkRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_TrunkRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_TrunkRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_TrunkRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_TrunkGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_TrunkGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_TrunkGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_TrunkGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_TrunkStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_TrunkStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_TrunkStatus& operator=(const cfc_vehiclefi_tclMsgMQB_TrunkStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_TrunkStatus(const cfc_vehiclefi_tclMsgMQB_TrunkStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Trunk;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_TrunkStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_TrunkStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSpeed_QualityUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSpeed_QualityUpReg();

   virtual ~cfc_vehiclefi_tclMsgSpeed_QualityUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgSpeed_QualityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSpeed_QualityRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSpeed_QualityRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgSpeed_QualityRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgSpeed_QualityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSpeed_QualityGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSpeed_QualityGet();

   virtual ~cfc_vehiclefi_tclMsgSpeed_QualityGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgSpeed_QualityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSpeed_QualityStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSpeed_QualityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgSpeed_QualityStatus& operator=(const cfc_vehiclefi_tclMsgSpeed_QualityStatus& coRef);
   cfc_vehiclefi_tclMsgSpeed_QualityStatus(const cfc_vehiclefi_tclMsgSpeed_QualityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Quality;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgSpeed_QualityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgSpeed_QualityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgLongitudinal_AccelerationUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgLongitudinal_AccelerationUpReg();

   virtual ~cfc_vehiclefi_tclMsgLongitudinal_AccelerationUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgLongitudinal_AccelerationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgLongitudinal_AccelerationRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgLongitudinal_AccelerationRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgLongitudinal_AccelerationRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgLongitudinal_AccelerationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgLongitudinal_AccelerationGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgLongitudinal_AccelerationGet();

   virtual ~cfc_vehiclefi_tclMsgLongitudinal_AccelerationGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgLongitudinal_AccelerationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus& operator=(const cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus& coRef);
   cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus(const cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgLongitudinal_AccelerationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_GierrateUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_GierrateUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_GierrateUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_GierrateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_GierrateRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_GierrateRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_GierrateRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_GierrateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_GierrateGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_GierrateGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_GierrateGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_GierrateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_GierrateStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_GierrateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_GierrateStatus& operator=(const cfc_vehiclefi_tclMsgMQB_GierrateStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_GierrateStatus(const cfc_vehiclefi_tclMsgMQB_GierrateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_GierrateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_GierrateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Gierrate_SignUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Gierrate_SignUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Gierrate_SignUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Gierrate_SignUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Gierrate_SignRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Gierrate_SignRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Gierrate_SignRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Gierrate_SignRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Gierrate_SignGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Gierrate_SignGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Gierrate_SignGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Gierrate_SignGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus(const cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Sign;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Gierrate_SignStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Motor_laeuftUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Motor_laeuftUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Motor_laeuftUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Motor_laeuftUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Motor_laeuftRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Motor_laeuftRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Motor_laeuftRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Motor_laeuftRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Motor_laeuftGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Motor_laeuftGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Motor_laeuftGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Motor_laeuftGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus(const cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Motor_laeuftStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrake_SwitchUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrake_SwitchUpReg();

   virtual ~cfc_vehiclefi_tclMsgBrake_SwitchUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrake_SwitchUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrake_SwitchRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrake_SwitchRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgBrake_SwitchRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrake_SwitchRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrake_SwitchGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrake_SwitchGet();

   virtual ~cfc_vehiclefi_tclMsgBrake_SwitchGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrake_SwitchGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrake_SwitchStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrake_SwitchStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgBrake_SwitchStatus& operator=(const cfc_vehiclefi_tclMsgBrake_SwitchStatus& coRef);
   cfc_vehiclefi_tclMsgBrake_SwitchStatus(const cfc_vehiclefi_tclMsgBrake_SwitchStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgBrake_SwitchStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgBrake_SwitchStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgClutchUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgClutchUpReg();

   virtual ~cfc_vehiclefi_tclMsgClutchUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgClutchUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgClutchRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgClutchRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgClutchRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgClutchRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgClutchGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgClutchGet();

   virtual ~cfc_vehiclefi_tclMsgClutchGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgClutchGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgClutchStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgClutchStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgClutchStatus& operator=(const cfc_vehiclefi_tclMsgClutchStatus& coRef);
   cfc_vehiclefi_tclMsgClutchStatus(const cfc_vehiclefi_tclMsgClutchStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgClutchStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgClutchStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMFL_Key_CodeUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMFL_Key_CodeUpReg();

   virtual ~cfc_vehiclefi_tclMsgMFL_Key_CodeUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMFL_Key_CodeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMFL_Key_CodeRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMFL_Key_CodeRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMFL_Key_CodeRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMFL_Key_CodeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMFL_Key_CodeGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMFL_Key_CodeGet();

   virtual ~cfc_vehiclefi_tclMsgMFL_Key_CodeGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMFL_Key_CodeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMFL_Key_CodeStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMFL_Key_CodeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMFL_Key_CodeStatus& operator=(const cfc_vehiclefi_tclMsgMFL_Key_CodeStatus& coRef);
   cfc_vehiclefi_tclMsgMFL_Key_CodeStatus(const cfc_vehiclefi_tclMsgMFL_Key_CodeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code MFL_Tastencode_1;
   cfc_fi_tcl_Vehicle_Data_U8_MFL_Key_Code MFL_Tastencode_2;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMFL_Key_CodeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMFL_Key_CodeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMFL_Event_CodeUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMFL_Event_CodeUpReg();

   virtual ~cfc_vehiclefi_tclMsgMFL_Event_CodeUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMFL_Event_CodeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMFL_Event_CodeRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMFL_Event_CodeRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMFL_Event_CodeRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMFL_Event_CodeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMFL_Event_CodeGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMFL_Event_CodeGet();

   virtual ~cfc_vehiclefi_tclMsgMFL_Event_CodeGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMFL_Event_CodeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMFL_Event_CodeStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMFL_Event_CodeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMFL_Event_CodeStatus& operator=(const cfc_vehiclefi_tclMsgMFL_Event_CodeStatus& coRef);
   cfc_vehiclefi_tclMsgMFL_Event_CodeStatus(const cfc_vehiclefi_tclMsgMFL_Event_CodeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode MFL_Eventcode_1;
   cfc_fi_tcl_Vehicle_Data_U8_MFL_EventCode MFL_Eventcode_2;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMFL_Event_CodeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMFL_Event_CodeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMFL_TypeUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMFL_TypeUpReg();

   virtual ~cfc_vehiclefi_tclMsgMFL_TypeUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMFL_TypeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMFL_TypeRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMFL_TypeRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMFL_TypeRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMFL_TypeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMFL_TypeGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMFL_TypeGet();

   virtual ~cfc_vehiclefi_tclMsgMFL_TypeGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMFL_TypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMFL_TypeStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMFL_TypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMFL_TypeStatus& operator=(const cfc_vehiclefi_tclMsgMFL_TypeStatus& coRef);
   cfc_vehiclefi_tclMsgMFL_TypeStatus(const cfc_vehiclefi_tclMsgMFL_TypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MFL_Marke;
   tU8 MFL_Variante;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMFL_TypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMFL_TypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBatteryUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBatteryUpReg();

   virtual ~cfc_vehiclefi_tclMsgBatteryUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBatteryUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBatteryRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBatteryRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgBatteryRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBatteryRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBatteryGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBatteryGet();

   virtual ~cfc_vehiclefi_tclMsgBatteryGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBatteryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBatteryStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBatteryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgBatteryStatus& operator=(const cfc_vehiclefi_tclMsgBatteryStatus& coRef);
   cfc_vehiclefi_tclMsgBatteryStatus(const cfc_vehiclefi_tclMsgBatteryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Abschaltstufen;
   tBool MMI_Vorwarnung;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgBatteryStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgBatteryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_StromsparmodusUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_StromsparmodusUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_StromsparmodusUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_StromsparmodusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_StromsparmodusRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_StromsparmodusRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_StromsparmodusRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_StromsparmodusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_StromsparmodusGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_StromsparmodusGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_StromsparmodusGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_StromsparmodusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus& operator=(const cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus(const cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Stromsparmodus;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_StromsparmodusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgWheel_AngleUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgWheel_AngleUpReg();

   virtual ~cfc_vehiclefi_tclMsgWheel_AngleUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgWheel_AngleUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgWheel_AngleRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgWheel_AngleRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgWheel_AngleRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgWheel_AngleRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgWheel_AngleGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgWheel_AngleGet();

   virtual ~cfc_vehiclefi_tclMsgWheel_AngleGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgWheel_AngleGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgWheel_AngleStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgWheel_AngleStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgWheel_AngleStatus& operator=(const cfc_vehiclefi_tclMsgWheel_AngleStatus& coRef);
   cfc_vehiclefi_tclMsgWheel_AngleStatus(const cfc_vehiclefi_tclMsgWheel_AngleStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgWheel_AngleStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgWheel_AngleStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgWheel_Angle_SignUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgWheel_Angle_SignUpReg();

   virtual ~cfc_vehiclefi_tclMsgWheel_Angle_SignUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgWheel_Angle_SignUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgWheel_Angle_SignRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgWheel_Angle_SignRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgWheel_Angle_SignRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgWheel_Angle_SignRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgWheel_Angle_SignGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgWheel_Angle_SignGet();

   virtual ~cfc_vehiclefi_tclMsgWheel_Angle_SignGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgWheel_Angle_SignGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgWheel_Angle_SignStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgWheel_Angle_SignStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgWheel_Angle_SignStatus& operator=(const cfc_vehiclefi_tclMsgWheel_Angle_SignStatus& coRef);
   cfc_vehiclefi_tclMsgWheel_Angle_SignStatus(const cfc_vehiclefi_tclMsgWheel_Angle_SignStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Sign;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgWheel_Angle_SignStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgWheel_Angle_SignStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityUpReg();

   virtual ~cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityGet();

   virtual ~cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus& operator=(const cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus& coRef);
   cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus(const cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgAcoustic_ParkingSystem_ActivityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgNWDFUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgNWDFUpReg();

   virtual ~cfc_vehiclefi_tclMsgNWDFUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgNWDFUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgNWDFRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgNWDFRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgNWDFRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgNWDFRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgNWDFGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgNWDFGet();

   virtual ~cfc_vehiclefi_tclMsgNWDFGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgNWDFGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgNWDFStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgNWDFStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgNWDFStatus& operator=(const cfc_vehiclefi_tclMsgNWDFStatus& coRef);
   cfc_vehiclefi_tclMsgNWDFStatus(const cfc_vehiclefi_tclMsgNWDFStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgNWDFStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgNWDFStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgQRS_ModeUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgQRS_ModeUpReg();

   virtual ~cfc_vehiclefi_tclMsgQRS_ModeUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgQRS_ModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgQRS_ModeRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgQRS_ModeRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgQRS_ModeRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgQRS_ModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgQRS_ModeGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgQRS_ModeGet();

   virtual ~cfc_vehiclefi_tclMsgQRS_ModeGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgQRS_ModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgQRS_ModeStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgQRS_ModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgQRS_ModeStatus& operator=(const cfc_vehiclefi_tclMsgQRS_ModeStatus& coRef);
   cfc_vehiclefi_tclMsgQRS_ModeStatus(const cfc_vehiclefi_tclMsgQRS_ModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgQRS_ModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgQRS_ModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus(const cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Eco_Charisma_TasteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Amplifier_MuteUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Amplifier_MuteUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Amplifier_MuteUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Amplifier_MuteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Amplifier_MuteRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Amplifier_MuteRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Amplifier_MuteRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Amplifier_MuteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Amplifier_MuteGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Amplifier_MuteGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Amplifier_MuteGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Amplifier_MuteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus(const cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool State;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Amplifier_MuteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_BlinkerUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_BlinkerUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_BlinkerUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_BlinkerUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_BlinkerRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_BlinkerRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_BlinkerRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_BlinkerRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_BlinkerGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_BlinkerGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_BlinkerGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_BlinkerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_BlinkerStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_BlinkerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_BlinkerStatus& operator=(const cfc_vehiclefi_tclMsgMQB_BlinkerStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_BlinkerStatus(const cfc_vehiclefi_tclMsgMQB_BlinkerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Left_State;
   tBool Right_State;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_BlinkerStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_BlinkerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCAN_UnitUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCAN_UnitUpReg();

   virtual ~cfc_vehiclefi_tclMsgCAN_UnitUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCAN_UnitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCAN_UnitRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCAN_UnitRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgCAN_UnitRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCAN_UnitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCAN_UnitGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCAN_UnitGet();

   virtual ~cfc_vehiclefi_tclMsgCAN_UnitGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCAN_UnitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCAN_UnitStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCAN_UnitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgCAN_UnitStatus& operator=(const cfc_vehiclefi_tclMsgCAN_UnitStatus& coRef);
   cfc_vehiclefi_tclMsgCAN_UnitStatus(const cfc_vehiclefi_tclMsgCAN_UnitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Date;
   tBool PQ_Distance;
   tU8 MQB_Pressure;
   tBool Temperature;
   tBool Hour;
   tU8 Consumption_Display;
   tBool MQB_Speed;
   tBool Volume;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgCAN_UnitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgCAN_UnitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgLanguageUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgLanguageUpReg();

   virtual ~cfc_vehiclefi_tclMsgLanguageUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgLanguageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgLanguageRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgLanguageRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgLanguageRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgLanguageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgLanguageGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgLanguageGet();

   virtual ~cfc_vehiclefi_tclMsgLanguageGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgLanguageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgLanguageStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgLanguageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgLanguageStatus& operator=(const cfc_vehiclefi_tclMsgLanguageStatus& coRef);
   cfc_vehiclefi_tclMsgLanguageStatus(const cfc_vehiclefi_tclMsgLanguageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgLanguageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgLanguageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMotor_RPMUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMotor_RPMUpReg();

   virtual ~cfc_vehiclefi_tclMsgMotor_RPMUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMotor_RPMUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMotor_RPMRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMotor_RPMRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMotor_RPMRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMotor_RPMRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMotor_RPMGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMotor_RPMGet();

   virtual ~cfc_vehiclefi_tclMsgMotor_RPMGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMotor_RPMGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMotor_RPMStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMotor_RPMStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMotor_RPMStatus& operator=(const cfc_vehiclefi_tclMsgMotor_RPMStatus& coRef);
   cfc_vehiclefi_tclMsgMotor_RPMStatus(const cfc_vehiclefi_tclMsgMotor_RPMStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 RPM;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMotor_RPMStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMotor_RPMStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Brake_PressureUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Brake_PressureUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Brake_PressureUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Brake_PressureUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Brake_PressureRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Brake_PressureRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Brake_PressureRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Brake_PressureRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Brake_PressureGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Brake_PressureGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Brake_PressureGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Brake_PressureGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus(const cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 Value;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Brake_PressureStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Current_TorqueUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Current_TorqueUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Current_TorqueUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Current_TorqueUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Current_TorqueRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Current_TorqueRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Current_TorqueRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Current_TorqueRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Current_TorqueGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Current_TorqueGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Current_TorqueGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Current_TorqueGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus(const cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 Value;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Current_TorqueStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgAccelerator_PositionUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgAccelerator_PositionUpReg();

   virtual ~cfc_vehiclefi_tclMsgAccelerator_PositionUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgAccelerator_PositionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgAccelerator_PositionRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgAccelerator_PositionRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgAccelerator_PositionRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgAccelerator_PositionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgAccelerator_PositionGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgAccelerator_PositionGet();

   virtual ~cfc_vehiclefi_tclMsgAccelerator_PositionGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgAccelerator_PositionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgAccelerator_PositionStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgAccelerator_PositionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgAccelerator_PositionStatus& operator=(const cfc_vehiclefi_tclMsgAccelerator_PositionStatus& coRef);
   cfc_vehiclefi_tclMsgAccelerator_PositionStatus(const cfc_vehiclefi_tclMsgAccelerator_PositionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 Value;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgAccelerator_PositionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgAccelerator_PositionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureUpReg();

   virtual ~cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureGet();

   virtual ~cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus& operator=(const cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus& coRef);
   cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus(const cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 Value;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgGearbox_Oil_TemperatureStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgKlima_Power_consumptionUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgKlima_Power_consumptionUpReg();

   virtual ~cfc_vehiclefi_tclMsgKlima_Power_consumptionUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgKlima_Power_consumptionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgKlima_Power_consumptionRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgKlima_Power_consumptionRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgKlima_Power_consumptionRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgKlima_Power_consumptionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgKlima_Power_consumptionGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgKlima_Power_consumptionGet();

   virtual ~cfc_vehiclefi_tclMsgKlima_Power_consumptionGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgKlima_Power_consumptionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus& operator=(const cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus& coRef);
   cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus(const cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 Power;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgKlima_Power_consumptionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgFuelWarning_SecondaryUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgFuelWarning_SecondaryUpReg();

   virtual ~cfc_vehiclefi_tclMsgFuelWarning_SecondaryUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgFuelWarning_SecondaryUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgFuelWarning_SecondaryRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgFuelWarning_SecondaryRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgFuelWarning_SecondaryRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgFuelWarning_SecondaryRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgFuelWarning_SecondaryGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgFuelWarning_SecondaryGet();

   virtual ~cfc_vehiclefi_tclMsgFuelWarning_SecondaryGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgFuelWarning_SecondaryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus& operator=(const cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus& coRef);
   cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus(const cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Power;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgFuelWarning_SecondaryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Battery_VoltageUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Battery_VoltageUpReg();

   virtual ~cfc_vehiclefi_tclMsgPQ_Battery_VoltageUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Battery_VoltageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Battery_VoltageRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Battery_VoltageRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgPQ_Battery_VoltageRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Battery_VoltageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Battery_VoltageGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Battery_VoltageGet();

   virtual ~cfc_vehiclefi_tclMsgPQ_Battery_VoltageGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Battery_VoltageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus& operator=(const cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus& coRef);
   cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus(const cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 Value;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesUpReg();

   virtual ~cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesGet();

   virtual ~cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus& operator=(const cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus& coRef);
   cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus(const cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 IlluminationValue;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgIllumination_CAN_SwitchesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgEngine_StatusUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgEngine_StatusUpReg();

   virtual ~cfc_vehiclefi_tclMsgEngine_StatusUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgEngine_StatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgEngine_StatusRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgEngine_StatusRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgEngine_StatusRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgEngine_StatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgEngine_StatusGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgEngine_StatusGet();

   virtual ~cfc_vehiclefi_tclMsgEngine_StatusGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgEngine_StatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgEngine_StatusStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgEngine_StatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgEngine_StatusStatus& operator=(const cfc_vehiclefi_tclMsgEngine_StatusStatus& coRef);
   cfc_vehiclefi_tclMsgEngine_StatusStatus(const cfc_vehiclefi_tclMsgEngine_StatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Status;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgEngine_StatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgEngine_StatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Boost_PressureUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Boost_PressureUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Boost_PressureUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Boost_PressureUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Boost_PressureRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Boost_PressureRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Boost_PressureRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Boost_PressureRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Boost_PressureGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Boost_PressureGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Boost_PressureGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Boost_PressureGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus(const cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Absolute;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Boost_PressureStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus(const cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Relative;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Relative_Boost_PressureStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgGear_InfoUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgGear_InfoUpReg();

   virtual ~cfc_vehiclefi_tclMsgGear_InfoUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgGear_InfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgGear_InfoRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgGear_InfoRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgGear_InfoRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgGear_InfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgGear_InfoGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgGear_InfoGet();

   virtual ~cfc_vehiclefi_tclMsgGear_InfoGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgGear_InfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgGear_InfoStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgGear_InfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgGear_InfoStatus& operator=(const cfc_vehiclefi_tclMsgGear_InfoStatus& coRef);
   cfc_vehiclefi_tclMsgGear_InfoStatus(const cfc_vehiclefi_tclMsgGear_InfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Current;
   tU8 Ideal;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgGear_InfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgGear_InfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableUpReg();

   virtual ~cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableGet();

   virtual ~cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus& operator=(const cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus& coRef);
   cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus(const cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Value;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgSwitch_Sensitivity_AvailableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgEngine_SpeedUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgEngine_SpeedUpReg();

   virtual ~cfc_vehiclefi_tclMsgEngine_SpeedUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgEngine_SpeedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgEngine_SpeedRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgEngine_SpeedRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgEngine_SpeedRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgEngine_SpeedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgEngine_SpeedGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgEngine_SpeedGet();

   virtual ~cfc_vehiclefi_tclMsgEngine_SpeedGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgEngine_SpeedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgEngine_SpeedStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgEngine_SpeedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgEngine_SpeedStatus& operator=(const cfc_vehiclefi_tclMsgEngine_SpeedStatus& coRef);
   cfc_vehiclefi_tclMsgEngine_SpeedStatus(const cfc_vehiclefi_tclMsgEngine_SpeedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Value;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgEngine_SpeedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgEngine_SpeedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceUpReg();

   virtual ~cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceGet();

   virtual ~cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus& operator=(const cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus& coRef);
   cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus(const cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Value;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgPQ_Medium_Tire_CircumferenceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Outside_TemperatureUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Outside_TemperatureUpReg();

   virtual ~cfc_vehiclefi_tclMsgPQ_Outside_TemperatureUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Outside_TemperatureUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Outside_TemperatureRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Outside_TemperatureRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgPQ_Outside_TemperatureRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Outside_TemperatureRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Outside_TemperatureGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Outside_TemperatureGet();

   virtual ~cfc_vehiclefi_tclMsgPQ_Outside_TemperatureGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Outside_TemperatureGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus& operator=(const cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus& coRef);
   cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus(const cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 Value;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgPQ_Outside_TemperatureStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgTacho_SpeedUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgTacho_SpeedUpReg();

   virtual ~cfc_vehiclefi_tclMsgTacho_SpeedUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgTacho_SpeedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgTacho_SpeedRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgTacho_SpeedRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgTacho_SpeedRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgTacho_SpeedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgTacho_SpeedGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgTacho_SpeedGet();

   virtual ~cfc_vehiclefi_tclMsgTacho_SpeedGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgTacho_SpeedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgTacho_SpeedStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgTacho_SpeedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgTacho_SpeedStatus& operator=(const cfc_vehiclefi_tclMsgTacho_SpeedStatus& coRef);
   cfc_vehiclefi_tclMsgTacho_SpeedStatus(const cfc_vehiclefi_tclMsgTacho_SpeedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 Value;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgTacho_SpeedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgTacho_SpeedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSpeed_In_KombiUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSpeed_In_KombiUpReg();

   virtual ~cfc_vehiclefi_tclMsgSpeed_In_KombiUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgSpeed_In_KombiUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSpeed_In_KombiRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSpeed_In_KombiRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgSpeed_In_KombiRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgSpeed_In_KombiRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSpeed_In_KombiGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSpeed_In_KombiGet();

   virtual ~cfc_vehiclefi_tclMsgSpeed_In_KombiGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgSpeed_In_KombiGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgSpeed_In_KombiStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgSpeed_In_KombiStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgSpeed_In_KombiStatus& operator=(const cfc_vehiclefi_tclMsgSpeed_In_KombiStatus& coRef);
   cfc_vehiclefi_tclMsgSpeed_In_KombiStatus(const cfc_vehiclefi_tclMsgSpeed_In_KombiStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Value;
   tBool Unit;
   tU8 Source;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgSpeed_In_KombiStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgSpeed_In_KombiStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Car_TypeUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Car_TypeUpReg();

   virtual ~cfc_vehiclefi_tclMsgPQ_Car_TypeUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Car_TypeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Car_TypeRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Car_TypeRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgPQ_Car_TypeRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Car_TypeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Car_TypeGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Car_TypeGet();

   virtual ~cfc_vehiclefi_tclMsgPQ_Car_TypeGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgPQ_Car_TypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgPQ_Car_TypeStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgPQ_Car_TypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgPQ_Car_TypeStatus& operator=(const cfc_vehiclefi_tclMsgPQ_Car_TypeStatus& coRef);
   cfc_vehiclefi_tclMsgPQ_Car_TypeStatus(const cfc_vehiclefi_tclMsgPQ_Car_TypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Klasse;
   tU8 Marke;
   tU8 Derivation;
   tU8 Generation;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgPQ_Car_TypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgPQ_Car_TypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgVINUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgVINUpReg();

   virtual ~cfc_vehiclefi_tclMsgVINUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgVINUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgVINRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgVINRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgVINRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgVINRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgVINGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgVINGet();

   virtual ~cfc_vehiclefi_tclMsgVINGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgVINGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgVINStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgVINStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgVINStatus& operator=(const cfc_vehiclefi_tclMsgVINStatus& coRef);
   cfc_vehiclefi_tclMsgVINStatus(const cfc_vehiclefi_tclMsgVINStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   cfc_fi_tclString Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgVINStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgVINStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCountryUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCountryUpReg();

   virtual ~cfc_vehiclefi_tclMsgCountryUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCountryUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCountryRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCountryRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgCountryRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCountryRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCountryGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCountryGet();

   virtual ~cfc_vehiclefi_tclMsgCountryGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCountryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCountryStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCountryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgCountryStatus& operator=(const cfc_vehiclefi_tclMsgCountryStatus& coRef);
   cfc_vehiclefi_tclMsgCountryStatus(const cfc_vehiclefi_tclMsgCountryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgCountryStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgCountryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Key_InfoUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Key_InfoUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Key_InfoUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Key_InfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Key_InfoRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Key_InfoRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMQB_Key_InfoRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Key_InfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Key_InfoGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Key_InfoGet();

   virtual ~cfc_vehiclefi_tclMsgMQB_Key_InfoGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMQB_Key_InfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMQB_Key_InfoStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMQB_Key_InfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMQB_Key_InfoStatus& operator=(const cfc_vehiclefi_tclMsgMQB_Key_InfoStatus& coRef);
   cfc_vehiclefi_tclMsgMQB_Key_InfoStatus(const cfc_vehiclefi_tclMsgMQB_Key_InfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Recommended_Position;
   tU8 Current_Position;
   tU8 Key_Number;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgMQB_Key_InfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMQB_Key_InfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgUser_ProfileUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgUser_ProfileUpReg();

   virtual ~cfc_vehiclefi_tclMsgUser_ProfileUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgUser_ProfileUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgUser_ProfileRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgUser_ProfileRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgUser_ProfileRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgUser_ProfileRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgUser_ProfileGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgUser_ProfileGet();

   virtual ~cfc_vehiclefi_tclMsgUser_ProfileGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgUser_ProfileGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgUser_ProfileStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgUser_ProfileStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgUser_ProfileStatus& operator=(const cfc_vehiclefi_tclMsgUser_ProfileStatus& coRef);
   cfc_vehiclefi_tclMsgUser_ProfileStatus(const cfc_vehiclefi_tclMsgUser_ProfileStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 User_Number;
   tU8 User_Control_Item;
   tU8 User_Control_Item_Parameter;
   tU8 User_Status;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgUser_ProfileStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgUser_ProfileStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgTransmission_TypeUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgTransmission_TypeUpReg();

   virtual ~cfc_vehiclefi_tclMsgTransmission_TypeUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgTransmission_TypeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgTransmission_TypeRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgTransmission_TypeRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgTransmission_TypeRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgTransmission_TypeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgTransmission_TypeGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgTransmission_TypeGet();

   virtual ~cfc_vehiclefi_tclMsgTransmission_TypeGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgTransmission_TypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgTransmission_TypeStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgTransmission_TypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgTransmission_TypeStatus& operator=(const cfc_vehiclefi_tclMsgTransmission_TypeStatus& coRef);
   cfc_vehiclefi_tclMsgTransmission_TypeStatus(const cfc_vehiclefi_tclMsgTransmission_TypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Data;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgTransmission_TypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgTransmission_TypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgVariantUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgVariantUpReg();

   virtual ~cfc_vehiclefi_tclMsgVariantUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgVariantUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgVariantRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgVariantRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgVariantRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgVariantRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgVariantGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgVariantGet();

   virtual ~cfc_vehiclefi_tclMsgVariantGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgVariantGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgVariantStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgVariantStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgVariantStatus& operator=(const cfc_vehiclefi_tclMsgVariantStatus& coRef);
   cfc_vehiclefi_tclMsgVariantStatus(const cfc_vehiclefi_tclMsgVariantStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Data;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgVariantStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgVariantStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCoasting_IsActiveUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCoasting_IsActiveUpReg();

   virtual ~cfc_vehiclefi_tclMsgCoasting_IsActiveUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCoasting_IsActiveUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCoasting_IsActiveRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCoasting_IsActiveRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgCoasting_IsActiveRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCoasting_IsActiveRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCoasting_IsActiveGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCoasting_IsActiveGet();

   virtual ~cfc_vehiclefi_tclMsgCoasting_IsActiveGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCoasting_IsActiveGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCoasting_IsActiveStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCoasting_IsActiveStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgCoasting_IsActiveStatus& operator=(const cfc_vehiclefi_tclMsgCoasting_IsActiveStatus& coRef);
   cfc_vehiclefi_tclMsgCoasting_IsActiveStatus(const cfc_vehiclefi_tclMsgCoasting_IsActiveStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgCoasting_IsActiveStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgCoasting_IsActiveStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_Output_PowerUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_Output_PowerUpReg();

   virtual ~cfc_vehiclefi_tclMsgCurrent_Output_PowerUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCurrent_Output_PowerUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_Output_PowerRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_Output_PowerRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgCurrent_Output_PowerRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCurrent_Output_PowerRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_Output_PowerGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_Output_PowerGet();

   virtual ~cfc_vehiclefi_tclMsgCurrent_Output_PowerGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCurrent_Output_PowerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus& operator=(const cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus& coRef);
   cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus(const cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Data;
   tU8 SignalState;
   cfc_fi_tcl_Car_ViewOptions ViewOptions;
   virtual ~cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgCurrent_Output_PowerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgVehicleStandStillUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgVehicleStandStillUpReg();

   virtual ~cfc_vehiclefi_tclMsgVehicleStandStillUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgVehicleStandStillUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgVehicleStandStillRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgVehicleStandStillRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgVehicleStandStillRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgVehicleStandStillRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgVehicleStandStillGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgVehicleStandStillGet();

   virtual ~cfc_vehiclefi_tclMsgVehicleStandStillGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgVehicleStandStillGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgVehicleStandStillStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgVehicleStandStillStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgVehicleStandStillStatus& operator=(const cfc_vehiclefi_tclMsgVehicleStandStillStatus& coRef);
   cfc_vehiclefi_tclMsgVehicleStandStillStatus(const cfc_vehiclefi_tclMsgVehicleStandStillStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Data;
   virtual ~cfc_vehiclefi_tclMsgVehicleStandStillStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgVehicleStandStillStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgTV_VelocityThresholdUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgTV_VelocityThresholdUpReg();

   virtual ~cfc_vehiclefi_tclMsgTV_VelocityThresholdUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgTV_VelocityThresholdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgTV_VelocityThresholdRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgTV_VelocityThresholdRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgTV_VelocityThresholdRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgTV_VelocityThresholdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgTV_VelocityThresholdGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgTV_VelocityThresholdGet();

   virtual ~cfc_vehiclefi_tclMsgTV_VelocityThresholdGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgTV_VelocityThresholdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus& operator=(const cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus& coRef);
   cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Exceeded;
   virtual ~cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgTV_VelocityThresholdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCar_VelocityThresholdUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCar_VelocityThresholdUpReg();

   virtual ~cfc_vehiclefi_tclMsgCar_VelocityThresholdUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCar_VelocityThresholdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCar_VelocityThresholdRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCar_VelocityThresholdRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgCar_VelocityThresholdRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCar_VelocityThresholdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCar_VelocityThresholdGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCar_VelocityThresholdGet();

   virtual ~cfc_vehiclefi_tclMsgCar_VelocityThresholdGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgCar_VelocityThresholdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus& operator=(const cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus& coRef);
   cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Exceeded;
   virtual ~cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgCar_VelocityThresholdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgHDD_VelocityThresholdUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgHDD_VelocityThresholdUpReg();

   virtual ~cfc_vehiclefi_tclMsgHDD_VelocityThresholdUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgHDD_VelocityThresholdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgHDD_VelocityThresholdRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgHDD_VelocityThresholdRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgHDD_VelocityThresholdRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgHDD_VelocityThresholdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgHDD_VelocityThresholdGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgHDD_VelocityThresholdGet();

   virtual ~cfc_vehiclefi_tclMsgHDD_VelocityThresholdGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgHDD_VelocityThresholdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus& operator=(const cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus& coRef);
   cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Exceeded;
   virtual ~cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgHDD_VelocityThresholdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdUpReg();

   virtual ~cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdGet();

   virtual ~cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus& operator=(const cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus& coRef);
   cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Exceeded;
   virtual ~cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgBrowserSlides_VelocityThresholdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdUpReg();

   virtual ~cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdGet();

   virtual ~cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus& operator=(const cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus& coRef);
   cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Exceeded;
   virtual ~cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgBrowserBordBook_VelocityThresholdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdUpReg();

   virtual ~cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdGet();

   virtual ~cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus& operator=(const cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus& coRef);
   cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Exceeded;
   virtual ~cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgBrowserTravelAgent_VelocityThresholdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdUpReg();

   virtual ~cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdGet();

   virtual ~cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus& operator=(const cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus& coRef);
   cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Exceeded;
   virtual ~cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgBrowserWeb_VelocityThresholdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBWS_VelocityThresholdUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBWS_VelocityThresholdUpReg();

   virtual ~cfc_vehiclefi_tclMsgBWS_VelocityThresholdUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBWS_VelocityThresholdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBWS_VelocityThresholdRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBWS_VelocityThresholdRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgBWS_VelocityThresholdRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBWS_VelocityThresholdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBWS_VelocityThresholdGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBWS_VelocityThresholdGet();

   virtual ~cfc_vehiclefi_tclMsgBWS_VelocityThresholdGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBWS_VelocityThresholdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus& operator=(const cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus& coRef);
   cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Exceeded;
   virtual ~cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgBWS_VelocityThresholdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgRadioText_VelocityThresholdUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgRadioText_VelocityThresholdUpReg();

   virtual ~cfc_vehiclefi_tclMsgRadioText_VelocityThresholdUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgRadioText_VelocityThresholdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgRadioText_VelocityThresholdRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgRadioText_VelocityThresholdRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgRadioText_VelocityThresholdRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgRadioText_VelocityThresholdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgRadioText_VelocityThresholdGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgRadioText_VelocityThresholdGet();

   virtual ~cfc_vehiclefi_tclMsgRadioText_VelocityThresholdGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgRadioText_VelocityThresholdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus& operator=(const cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus& coRef);
   cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Exceeded;
   virtual ~cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgRadioText_VelocityThresholdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdUpReg();

   virtual ~cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdGet();

   virtual ~cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus& operator=(const cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus& coRef);
   cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Exceeded;
   virtual ~cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgBTBonding_VelocityThresholdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdUpReg();

   virtual ~cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdGet();

   virtual ~cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus& operator=(const cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus& coRef);
   cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Exceeded;
   virtual ~cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgDestinationInput_VelocityThresholdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMessaging_VelocityThresholdUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMessaging_VelocityThresholdUpReg();

   virtual ~cfc_vehiclefi_tclMsgMessaging_VelocityThresholdUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMessaging_VelocityThresholdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMessaging_VelocityThresholdRelUpReg : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMessaging_VelocityThresholdRelUpReg();

   virtual ~cfc_vehiclefi_tclMsgMessaging_VelocityThresholdRelUpReg();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMessaging_VelocityThresholdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMessaging_VelocityThresholdGet : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMessaging_VelocityThresholdGet();

   virtual ~cfc_vehiclefi_tclMsgMessaging_VelocityThresholdGet();

   inline tBool operator==(const cfc_vehiclefi_tclMsgMessaging_VelocityThresholdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus : public cfc_vehiclefi_tclMsgBaseMessage
{
public:

   cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus& operator=(const cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus& coRef);
   cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus(const cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Exceeded;
   virtual ~cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const cfc_vehiclefi_tclMsgMessaging_VelocityThresholdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
