#ifndef CFC_VEHICLEFILANGUAGE_HEADER
#define CFC_VEHICLEFILANGUAGE_HEADER

class cfc_vehiclefi_tclInContext;
class cfc_vehiclefi_tclOutContext;
class cfc_vehiclefi_tclVisitorBase;

class MY_DECL cfc_vehiclefi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  cfc_vehiclefi_tclDescription(fi_tclInContext* poIn, cfc_vehiclefi_tclVisitorBase* poVisit);
  cfc_vehiclefi_tclDescription(fi_tclOutContext* poOut, cfc_vehiclefi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(cfc_vehiclefi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(cfc_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ cfc_vehiclefi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  cfc_vehiclefi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<cfc_vehiclefi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<cfc_vehiclefi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline cfc_vehiclefi_tclDescription::cfc_vehiclefi_tclDescription(fi_tclInContext* poIn, cfc_vehiclefi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline cfc_vehiclefi_tclDescription::cfc_vehiclefi_tclDescription(fi_tclOutContext* poOut, cfc_vehiclefi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

