
/******************************************************************************

 .FILE             [ navififuncid.h  ]

 .SW-COMPONENT      NAFI

 .DESCRIPTION
  This file includes the enumeration over all function ids (methods and properties)

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTHOR               [ J. Bruns (generated by script)                   ]

 .HISTORY

  Date     | Name            Modification
 ----------|---------------------------------------------------------------
  25.02.02 | CM-DI/ESN1-Br   initial version
********************************************************************************/

#ifndef CFC_VEHICLEFI_FUNCID_HEADER
#define CFC_VEHICLEFI_FUNCID_HEADER

//
// definition of function ids
//

enum {
   CFC_VEHICLEFI_C_U16_IGNITION = 0x01,
   CFC_VEHICLEFI_C_U16_KEY_INSERTION = 0x02,
   CFC_VEHICLEFI_C_U16_ILLUMINATION_CAN_DISPLAY = 0x03,
   CFC_VEHICLEFI_C_U16_MQB_ILLUMINATION_CAN_DAY_NIGHT = 0x04,
   CFC_VEHICLEFI_C_U16_PQ_ILLUMINATION_CAN_SENSOR = 0x05,
   CFC_VEHICLEFI_C_U16_ERROR_FORGET_COUNTER = 0x06,
   CFC_VEHICLEFI_C_U16_CURRENT_MILEAGE = 0x07,
   CFC_VEHICLEFI_C_U16_CURRENT_DATE = 0x08,
   CFC_VEHICLEFI_C_U16_CURRENT_TIME = 0x0B,
   CFC_VEHICLEFI_C_U16_ACC_STATUS = 0x0E,
   CFC_VEHICLEFI_C_U16_CRANKING_REQUEST = 0x0F,
   CFC_VEHICLEFI_C_U16_REVERSEGEAR = 0x10,
   CFC_VEHICLEFI_C_U16_CRANKING = 0x11,
   CFC_VEHICLEFI_C_U16_ACCELERATOR_KICKDOWN = 0x12,
   CFC_VEHICLEFI_C_U16_SPEED = 0x13,
   CFC_VEHICLEFI_C_U16_INDICATOR = 0x14,
   CFC_VEHICLEFI_C_U16_REMOTE_START_OPERATION = 0x16,
   CFC_VEHICLEFI_C_U16_MQB_CRASH_INTENSITY = 0x17,
   CFC_VEHICLEFI_C_U16_MQB_ANZEIGE_AKTIV = 0x18,
   CFC_VEHICLEFI_C_U16_OIL_LEVEL_MIN_WARNING = 0x19,
   CFC_VEHICLEFI_C_U16_MQB_OELSTAND = 0x1A,
   CFC_VEHICLEFI_C_U16_MQB_OELSYSTEM_AKTIV = 0x1B,
   CFC_VEHICLEFI_C_U16_MQB_BETRIEBSWARM = 0x1C,
   CFC_VEHICLEFI_C_U16_MQB_UEBERFUELL_WARN = 0x1D,
   CFC_VEHICLEFI_C_U16_MQB_OIL_INFO_VALIDITY = 0x1E,
   CFC_VEHICLEFI_C_U16_MQB_OELMENGE = 0x1F,
   CFC_VEHICLEFI_C_U16_MQB_OIL_LEVEL_AVAILABLE = 0x20,
   CFC_VEHICLEFI_C_U16_OIL_LEVEL_UNTERFUELL_WARNING = 0x21,
   CFC_VEHICLEFI_C_U16_MQB_VEHICLE_LOCKED = 0x22,
   CFC_VEHICLEFI_C_U16_MQB_DOOR_STATE = 0x23,
   CFC_VEHICLEFI_C_U16_MQB_ROOF_STATE = 0x27,
   CFC_VEHICLEFI_C_U16_MQB_TRUNK = 0x29,
   CFC_VEHICLEFI_C_U16_SPEED_QUALITY = 0x2A,
   CFC_VEHICLEFI_C_U16_LONGITUDINAL_ACCELERATION = 0x2B,
   CFC_VEHICLEFI_C_U16_MQB_GIERRATE = 0x2C,
   CFC_VEHICLEFI_C_U16_MQB_GIERRATE_SIGN = 0x2D,
   CFC_VEHICLEFI_C_U16_MQB_MOTOR_LAEUFT = 0x2E,
   CFC_VEHICLEFI_C_U16_BRAKE_SWITCH = 0x2F,
   CFC_VEHICLEFI_C_U16_CLUTCH = 0x30,
   CFC_VEHICLEFI_C_U16_MFL_KEY_CODE = 0x31,
   CFC_VEHICLEFI_C_U16_MFL_EVENT_CODE = 0x32,
   CFC_VEHICLEFI_C_U16_MFL_TYPE = 0x33,
   CFC_VEHICLEFI_C_U16_BATTERY = 0x37,
   CFC_VEHICLEFI_C_U16_MQB_STROMSPARMODUS = 0x39,
   CFC_VEHICLEFI_C_U16_WHEEL_ANGLE = 0x3A,
   CFC_VEHICLEFI_C_U16_WHEEL_ANGLE_SIGN = 0x3B,
   CFC_VEHICLEFI_C_U16_ACOUSTIC_PARKINGSYSTEM_ACTIVITY = 0x3C,
   CFC_VEHICLEFI_C_U16_NWDF = 0x3D,
   CFC_VEHICLEFI_C_U16_QRS_MODE = 0x3E,
   CFC_VEHICLEFI_C_U16_MQB_ECO_CHARISMA_TASTE = 0x3F,
   CFC_VEHICLEFI_C_U16_MQB_AMPLIFIER_MUTE = 0x40,
   CFC_VEHICLEFI_C_U16_MQB_BLINKER = 0x41,
   CFC_VEHICLEFI_C_U16_CAN_UNIT = 0x43,
   CFC_VEHICLEFI_C_U16_LANGUAGE = 0x4B,
   CFC_VEHICLEFI_C_U16_MOTOR_RPM = 0x4C,
   CFC_VEHICLEFI_C_U16_MQB_BRAKE_PRESSURE = 0x4D,
   CFC_VEHICLEFI_C_U16_MQB_CURRENT_TORQUE = 0x4E,
   CFC_VEHICLEFI_C_U16_ACCELERATOR_POSITION = 0x4F,
   CFC_VEHICLEFI_C_U16_GEARBOX_OIL_TEMPERATURE = 0x50,
   CFC_VEHICLEFI_C_U16_KLIMA_POWER_CONSUMPTION = 0x51,
   CFC_VEHICLEFI_C_U16_FUELWARNING_SECONDARY = 0x52,
   CFC_VEHICLEFI_C_U16_PQ_BATTERY_VOLTAGE = 0x53,
   CFC_VEHICLEFI_C_U16_ILLUMINATION_CAN_SWITCHES = 0x54,
   CFC_VEHICLEFI_C_U16_ENGINE_STATUS = 0x55,
   CFC_VEHICLEFI_C_U16_MQB_BOOST_PRESSURE = 0x56,
   CFC_VEHICLEFI_C_U16_MQB_RELATIVE_BOOST_PRESSURE = 0x57,
   CFC_VEHICLEFI_C_U16_GEAR_INFO = 0x58,
   CFC_VEHICLEFI_C_U16_SWITCH_SENSITIVITY_AVAILABLE = 0x5A,
   CFC_VEHICLEFI_C_U16_ENGINE_SPEED = 0x5B,
   CFC_VEHICLEFI_C_U16_PQ_MEDIUM_TIRE_CIRCUMFERENCE = 0x5C,
   CFC_VEHICLEFI_C_U16_PQ_OUTSIDE_TEMPERATURE = 0x5D,
   CFC_VEHICLEFI_C_U16_TACHO_SPEED = 0x5E,
   CFC_VEHICLEFI_C_U16_SPEED_IN_KOMBI = 0x5F,
   CFC_VEHICLEFI_C_U16_PQ_CAR_TYPE = 0x62,
   CFC_VEHICLEFI_C_U16_VIN = 0x66,
   CFC_VEHICLEFI_C_U16_COUNTRY = 0x67,
   CFC_VEHICLEFI_C_U16_MQB_KEY_INFO = 0x68,
   CFC_VEHICLEFI_C_U16_USER_PROFILE = 0x6B,
   CFC_VEHICLEFI_C_U16_TRANSMISSION_TYPE = 0x6F,
   CFC_VEHICLEFI_C_U16_VARIANT = 0x70,
   CFC_VEHICLEFI_C_U16_COASTING_ISACTIVE = 0x71,
   CFC_VEHICLEFI_C_U16_CURRENT_OUTPUT_POWER = 0x72,
   CFC_VEHICLEFI_C_U16_VEHICLESTANDSTILL = 0x73,
   CFC_VEHICLEFI_C_U16_TV_VELOCITYTHRESHOLD = 0x74,
   CFC_VEHICLEFI_C_U16_CAR_VELOCITYTHRESHOLD = 0x75,
   CFC_VEHICLEFI_C_U16_HDD_VELOCITYTHRESHOLD = 0x76,
   CFC_VEHICLEFI_C_U16_BROWSERSLIDES_VELOCITYTHRESHOLD = 0x77,
   CFC_VEHICLEFI_C_U16_BROWSERBORDBOOK_VELOCITYTHRESHOLD = 0x78,
   CFC_VEHICLEFI_C_U16_BROWSERTRAVELAGENT_VELOCITYTHRESHOLD = 0x79,
   CFC_VEHICLEFI_C_U16_BROWSERWEB_VELOCITYTHRESHOLD = 0x7A,
   CFC_VEHICLEFI_C_U16_BWS_VELOCITYTHRESHOLD = 0x7B,
   CFC_VEHICLEFI_C_U16_RADIOTEXT_VELOCITYTHRESHOLD = 0x7C,
   CFC_VEHICLEFI_C_U16_BTBONDING_VELOCITYTHRESHOLD = 0x7D,
   CFC_VEHICLEFI_C_U16_DESTINATIONINPUT_VELOCITYTHRESHOLD = 0x7E,
   CFC_VEHICLEFI_C_U16_MESSAGING_VELOCITYTHRESHOLD = 0x7F,
   CFC_VEHICLEFI_C_U16_INVALID_FUNCTIONID = 0xFFFF
};
#endif
