/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_TYPES
#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_FUNCTIONIDS
#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_SERVICEINFO
#include "cfc_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for CFC_SPM_FI message types

fi_tclMessageBase* cfc_spmfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case cfc_spmfi_tclToken::EN_MSG_SYSTEMMODEMETHODSTART:
         return OSAL_NEW cfc_spmfi_tclMsgSystemModeMethodStart;

      case cfc_spmfi_tclToken::EN_MSG_SYSTEMMODEMETHODRESULT:
         return OSAL_NEW cfc_spmfi_tclMsgSystemModeMethodResult;

      case cfc_spmfi_tclToken::EN_MSG_STARTPROCESSMETHODSTART:
         return OSAL_NEW cfc_spmfi_tclMsgStartProcessMethodStart;

      case cfc_spmfi_tclToken::EN_MSG_STARTPROCESSMETHODRESULT:
         return OSAL_NEW cfc_spmfi_tclMsgStartProcessMethodResult;

      case cfc_spmfi_tclToken::EN_MSG_ENTERTAINDEMUTEMETHODSTART:
         return OSAL_NEW cfc_spmfi_tclMsgEntertainDeMuteMethodStart;

      case cfc_spmfi_tclToken::EN_MSG_ENTERTAINDEMUTEMETHODRESULT:
         return OSAL_NEW cfc_spmfi_tclMsgEntertainDeMuteMethodResult;

      case cfc_spmfi_tclToken::EN_MSG_AUDIOSOURCECHANGEMETHODSTART:
         return OSAL_NEW cfc_spmfi_tclMsgAudioSourceChangeMethodStart;

      case cfc_spmfi_tclToken::EN_MSG_AUDIOSOURCECHANGEMETHODRESULT:
         return OSAL_NEW cfc_spmfi_tclMsgAudioSourceChangeMethodResult;

      case cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGMETHODSTART:
         return OSAL_NEW cfc_spmfi_tclMsgFactorySettingMethodStart;

      case cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGMETHODRESULT:
         return OSAL_NEW cfc_spmfi_tclMsgFactorySettingMethodResult;

      case cfc_spmfi_tclToken::EN_MSG_DIAGCONFIGURATIONMETHODSTART:
         return OSAL_NEW cfc_spmfi_tclMsgDiagConfigurationMethodStart;

      case cfc_spmfi_tclToken::EN_MSG_DIAGCONFIGURATIONMETHODRESULT:
         return OSAL_NEW cfc_spmfi_tclMsgDiagConfigurationMethodResult;

      case cfc_spmfi_tclToken::EN_MSG_PERFORMTESTMETHODSTART:
         return OSAL_NEW cfc_spmfi_tclMsgPerformTestMethodStart;

      case cfc_spmfi_tclToken::EN_MSG_PERFORMTESTMETHODRESULT:
         return OSAL_NEW cfc_spmfi_tclMsgPerformTestMethodResult;

      case cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgSystemStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgSystemStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgSystemStateGet;

      case cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSystemStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_ONOFFREASONSET:
         return OSAL_NEW cfc_spmfi_tclMsgOnOffReasonSet;

      case cfc_spmfi_tclToken::EN_MSG_ONOFFREASONGET:
         return OSAL_NEW cfc_spmfi_tclMsgOnOffReasonGet;

      case cfc_spmfi_tclToken::EN_MSG_ONOFFREASONSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgOnOffReasonStatus;

      case cfc_spmfi_tclToken::EN_MSG_ONOFFREASONUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgOnOffReasonUpReg;

      case cfc_spmfi_tclToken::EN_MSG_ONOFFREASONRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgOnOffReasonRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_SUBSTATESSET:
         return OSAL_NEW cfc_spmfi_tclMsgSubStatesSet;

      case cfc_spmfi_tclToken::EN_MSG_SUBSTATESGET:
         return OSAL_NEW cfc_spmfi_tclMsgSubStatesGet;

      case cfc_spmfi_tclToken::EN_MSG_SUBSTATESSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSubStatesStatus;

      case cfc_spmfi_tclToken::EN_MSG_SUBSTATESUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgSubStatesUpReg;

      case cfc_spmfi_tclToken::EN_MSG_SUBSTATESRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgSubStatesRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_STARTUPSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgStartupStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_STARTUPSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgStartupStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_STARTUPSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgStartupStateGet;

      case cfc_spmfi_tclToken::EN_MSG_STARTUPSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgStartupStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_PROCESSLISTUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgProcessListUpReg;

      case cfc_spmfi_tclToken::EN_MSG_PROCESSLISTRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgProcessListRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_PROCESSLISTGET:
         return OSAL_NEW cfc_spmfi_tclMsgProcessListGet;

      case cfc_spmfi_tclToken::EN_MSG_PROCESSLISTSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgProcessListStatus;

      case cfc_spmfi_tclToken::EN_MSG_WAKEUPREASONGET:
         return OSAL_NEW cfc_spmfi_tclMsgWakeupReasonGet;

      case cfc_spmfi_tclToken::EN_MSG_WAKEUPREASONSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgWakeupReasonStatus;

      case cfc_spmfi_tclToken::EN_MSG_STARTUPREASONGET:
         return OSAL_NEW cfc_spmfi_tclMsgStartupReasonGet;

      case cfc_spmfi_tclToken::EN_MSG_STARTUPREASONSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgStartupReasonStatus;

      case cfc_spmfi_tclToken::EN_MSG_CONNECTTOBATTERYGET:
         return OSAL_NEW cfc_spmfi_tclMsgConnectToBatteryGet;

      case cfc_spmfi_tclToken::EN_MSG_CONNECTTOBATTERYSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgConnectToBatteryStatus;

      case cfc_spmfi_tclToken::EN_MSG_CVMEVENTUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgCvmEventUpReg;

      case cfc_spmfi_tclToken::EN_MSG_CVMEVENTRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgCvmEventRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_CVMEVENTGET:
         return OSAL_NEW cfc_spmfi_tclMsgCvmEventGet;

      case cfc_spmfi_tclToken::EN_MSG_CVMEVENTSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgCvmEventStatus;

      case cfc_spmfi_tclToken::EN_MSG_UBATSENSEGET:
         return OSAL_NEW cfc_spmfi_tclMsgUBatSenseGet;

      case cfc_spmfi_tclToken::EN_MSG_UBATSENSESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgUBatSenseStatus;

      case cfc_spmfi_tclToken::EN_MSG_CALIBRATEDCVMEVENTUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgCalibratedCvmEventUpReg;

      case cfc_spmfi_tclToken::EN_MSG_CALIBRATEDCVMEVENTRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgCalibratedCvmEventRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_CALIBRATEDCVMEVENTGET:
         return OSAL_NEW cfc_spmfi_tclMsgCalibratedCvmEventGet;

      case cfc_spmfi_tclToken::EN_MSG_CALIBRATEDCVMEVENTSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgCalibratedCvmEventStatus;

      case cfc_spmfi_tclToken::EN_MSG_IGNITIONCYCLESUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgIgnitionCyclesUpReg;

      case cfc_spmfi_tclToken::EN_MSG_IGNITIONCYCLESRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgIgnitionCyclesRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_IGNITIONCYCLESGET:
         return OSAL_NEW cfc_spmfi_tclMsgIgnitionCyclesGet;

      case cfc_spmfi_tclToken::EN_MSG_IGNITIONCYCLESSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgIgnitionCyclesStatus;

      case cfc_spmfi_tclToken::EN_MSG_SYSPWRMODEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgSysPwrModeUpReg;

      case cfc_spmfi_tclToken::EN_MSG_SYSPWRMODERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgSysPwrModeRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_SYSPWRMODEGET:
         return OSAL_NEW cfc_spmfi_tclMsgSysPwrModeGet;

      case cfc_spmfi_tclToken::EN_MSG_SYSPWRMODESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSysPwrModeStatus;

      case cfc_spmfi_tclToken::EN_MSG_SYSPWRSAVEMODEGET:
         return OSAL_NEW cfc_spmfi_tclMsgSysPwrSaveModeGet;

      case cfc_spmfi_tclToken::EN_MSG_SYSPWRSAVEMODESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSysPwrSaveModeStatus;

      case cfc_spmfi_tclToken::EN_MSG_RVCSTATESET:
         return OSAL_NEW cfc_spmfi_tclMsgRVCStateSet;

      case cfc_spmfi_tclToken::EN_MSG_RVCSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgRVCStateGet;

      case cfc_spmfi_tclToken::EN_MSG_RVCSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgRVCStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_LIFESIGNUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgLifesignUpReg;

      case cfc_spmfi_tclToken::EN_MSG_LIFESIGNRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgLifesignRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_LIFESIGNGET:
         return OSAL_NEW cfc_spmfi_tclMsgLifesignGet;

      case cfc_spmfi_tclToken::EN_MSG_LIFESIGNSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgLifesignStatus;

      case cfc_spmfi_tclToken::EN_MSG_HMISTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgHmiStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_HMISTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgHmiStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_HMISTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgHmiStateGet;

      case cfc_spmfi_tclToken::EN_MSG_HMISTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgHmiStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgSystemPowerBehaviourUpReg;

      case cfc_spmfi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgSystemPowerBehaviourRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURGET:
         return OSAL_NEW cfc_spmfi_tclMsgSystemPowerBehaviourGet;

      case cfc_spmfi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSystemPowerBehaviourStatus;

      case cfc_spmfi_tclToken::EN_MSG_ENTERTAINMUTEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgEntertainMuteUpReg;

      case cfc_spmfi_tclToken::EN_MSG_ENTERTAINMUTERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgEntertainMuteRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_ENTERTAINMUTEGET:
         return OSAL_NEW cfc_spmfi_tclMsgEntertainMuteGet;

      case cfc_spmfi_tclToken::EN_MSG_ENTERTAINMUTESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgEntertainMuteStatus;

      case cfc_spmfi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneHandoverWarnTimeUpReg;

      case cfc_spmfi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneHandoverWarnTimeRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMEGET:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneHandoverWarnTimeGet;

      case cfc_spmfi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMESET:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet;

      case cfc_spmfi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus;

      case cfc_spmfi_tclToken::EN_MSG_DIMSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgDimStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_DIMSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgDimStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_DIMSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgDimStateGet;

      case cfc_spmfi_tclToken::EN_MSG_DIMSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgDimStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_DIMMINGSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgDimmingStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_DIMMINGSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgDimmingStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_DIMMINGSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgDimmingStateGet;

      case cfc_spmfi_tclToken::EN_MSG_DIMMINGSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgDimmingStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_MMGRSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgMmgrStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_MMGRSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgMmgrStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_MMGRSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgMmgrStateGet;

      case cfc_spmfi_tclToken::EN_MSG_MMGRSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgMmgrStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_AUDIOSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgAudioStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_AUDIOSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgAudioStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_AUDIOSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgAudioStateGet;

      case cfc_spmfi_tclToken::EN_MSG_AUDIOSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgAudioStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_SYSSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgSysStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_SYSSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgSysStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_SYSSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgSysStateGet;

      case cfc_spmfi_tclToken::EN_MSG_SYSSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSysStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_MOSTSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgMostStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_MOSTSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgMostStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_MOSTSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgMostStateGet;

      case cfc_spmfi_tclToken::EN_MSG_MOSTSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgMostStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_MOSTVERSIONGET:
         return OSAL_NEW cfc_spmfi_tclMsgMostVersionGet;

      case cfc_spmfi_tclToken::EN_MSG_MOSTVERSIONSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgMostVersionStatus;

      case cfc_spmfi_tclToken::EN_MSG_STANDBYTIMEGET:
         return OSAL_NEW cfc_spmfi_tclMsgStandbyTimeGet;

      case cfc_spmfi_tclToken::EN_MSG_STANDBYTIMESET:
         return OSAL_NEW cfc_spmfi_tclMsgStandbyTimeSet;

      case cfc_spmfi_tclToken::EN_MSG_STANDBYTIMESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgStandbyTimeStatus;

      case cfc_spmfi_tclToken::EN_MSG_PERSITENTSTANDBYTIMEGET:
         return OSAL_NEW cfc_spmfi_tclMsgPersitentStandbyTimeGet;

      case cfc_spmfi_tclToken::EN_MSG_PERSITENTSTANDBYTIMESET:
         return OSAL_NEW cfc_spmfi_tclMsgPersitentStandbyTimeSet;

      case cfc_spmfi_tclToken::EN_MSG_PERSITENTSTANDBYTIMESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgPersitentStandbyTimeStatus;

      case cfc_spmfi_tclToken::EN_MSG_SUSPENDTIMEGET:
         return OSAL_NEW cfc_spmfi_tclMsgSuspendTimeGet;

      case cfc_spmfi_tclToken::EN_MSG_SUSPENDTIMESET:
         return OSAL_NEW cfc_spmfi_tclMsgSuspendTimeSet;

      case cfc_spmfi_tclToken::EN_MSG_SUSPENDTIMESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSuspendTimeStatus;

      case cfc_spmfi_tclToken::EN_MSG_IGNITIONOFFTIMEGET:
         return OSAL_NEW cfc_spmfi_tclMsgIgnitionOffTimeGet;

      case cfc_spmfi_tclToken::EN_MSG_IGNITIONOFFTIMESET:
         return OSAL_NEW cfc_spmfi_tclMsgIgnitionOffTimeSet;

      case cfc_spmfi_tclToken::EN_MSG_IGNITIONOFFTIMESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgIgnitionOffTimeStatus;

      case cfc_spmfi_tclToken::EN_MSG_DOOROPENTIMEGET:
         return OSAL_NEW cfc_spmfi_tclMsgDoorOpenTimeGet;

      case cfc_spmfi_tclToken::EN_MSG_DOOROPENTIMESET:
         return OSAL_NEW cfc_spmfi_tclMsgDoorOpenTimeSet;

      case cfc_spmfi_tclToken::EN_MSG_DOOROPENTIMESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgDoorOpenTimeStatus;

      case cfc_spmfi_tclToken::EN_MSG_CLOCKDISPLAYTIMEGET:
         return OSAL_NEW cfc_spmfi_tclMsgClockDisplayTimeGet;

      case cfc_spmfi_tclToken::EN_MSG_CLOCKDISPLAYTIMESET:
         return OSAL_NEW cfc_spmfi_tclMsgClockDisplayTimeSet;

      case cfc_spmfi_tclToken::EN_MSG_CLOCKDISPLAYTIMESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgClockDisplayTimeStatus;

      case cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATETIMEGET:
         return OSAL_NEW cfc_spmfi_tclMsgSystemStateTimeGet;

      case cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATETIMESET:
         return OSAL_NEW cfc_spmfi_tclMsgSystemStateTimeSet;

      case cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATETIMESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSystemStateTimeStatus;

      case cfc_spmfi_tclToken::EN_MSG_FGSSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgFgsStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_FGSSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgFgsStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_FGSSTATESET:
         return OSAL_NEW cfc_spmfi_tclMsgFgsStateSet;

      case cfc_spmfi_tclToken::EN_MSG_FGSSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgFgsStateGet;

      case cfc_spmfi_tclToken::EN_MSG_FGSSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgFgsStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_COPROSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgCoproStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_COPROSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgCoproStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_COPROSTATESET:
         return OSAL_NEW cfc_spmfi_tclMsgCoproStateSet;

      case cfc_spmfi_tclToken::EN_MSG_COPROSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgCoproStateGet;

      case cfc_spmfi_tclToken::EN_MSG_COPROSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgCoproStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_DABSTATESET:
         return OSAL_NEW cfc_spmfi_tclMsgDabStateSet;

      case cfc_spmfi_tclToken::EN_MSG_DABSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgDabStateGet;

      case cfc_spmfi_tclToken::EN_MSG_DABSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgDabStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_EJECTSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgEjectStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_EJECTSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgEjectStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_EJECTSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgEjectStateGet;

      case cfc_spmfi_tclToken::EN_MSG_EJECTSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgEjectStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_INSERTSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgInsertStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_INSERTSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgInsertStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_INSERTSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgInsertStateGet;

      case cfc_spmfi_tclToken::EN_MSG_INSERTSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgInsertStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_MEDIAEJECTSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgMediaEjectStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_MEDIAEJECTSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgMediaEjectStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_MEDIAEJECTSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgMediaEjectStateGet;

      case cfc_spmfi_tclToken::EN_MSG_MEDIAEJECTSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgMediaEjectStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_PHONEMUTESTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneMuteStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_PHONEMUTESTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneMuteStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_PHONEMUTESTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneMuteStateGet;

      case cfc_spmfi_tclToken::EN_MSG_PHONEMUTESTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneMuteStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_RMTENABLESTATESET:
         return OSAL_NEW cfc_spmfi_tclMsgRmtEnableStateSet;

      case cfc_spmfi_tclToken::EN_MSG_RMTENABLESTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgRmtEnableStateGet;

      case cfc_spmfi_tclToken::EN_MSG_RMTENABLESTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgRmtEnableStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_ONTIPPERSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgOnTipperStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_ONTIPPERSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgOnTipperStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_ONTIPPERSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgOnTipperStateGet;

      case cfc_spmfi_tclToken::EN_MSG_ONTIPPERSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgOnTipperStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_CODEREQUESTSTATEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgCodeRequestStateUpReg;

      case cfc_spmfi_tclToken::EN_MSG_CODEREQUESTSTATERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgCodeRequestStateRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_CODEREQUESTSTATESET:
         return OSAL_NEW cfc_spmfi_tclMsgCodeRequestStateSet;

      case cfc_spmfi_tclToken::EN_MSG_CODEREQUESTSTATEGET:
         return OSAL_NEW cfc_spmfi_tclMsgCodeRequestStateGet;

      case cfc_spmfi_tclToken::EN_MSG_CODEREQUESTSTATESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgCodeRequestStateStatus;

      case cfc_spmfi_tclToken::EN_MSG_PHONEABORTUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneAbortUpReg;

      case cfc_spmfi_tclToken::EN_MSG_PHONEABORTRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneAbortRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_PHONEABORTSET:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneAbortSet;

      case cfc_spmfi_tclToken::EN_MSG_PHONEABORTGET:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneAbortGet;

      case cfc_spmfi_tclToken::EN_MSG_PHONEABORTSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgPhoneAbortStatus;

      case cfc_spmfi_tclToken::EN_MSG_DISPLAYSIZEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgDisplaySizeUpReg;

      case cfc_spmfi_tclToken::EN_MSG_DISPLAYSIZERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgDisplaySizeRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_DISPLAYSIZEGET:
         return OSAL_NEW cfc_spmfi_tclMsgDisplaySizeGet;

      case cfc_spmfi_tclToken::EN_MSG_DISPLAYSIZESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgDisplaySizeStatus;

      case cfc_spmfi_tclToken::EN_MSG_RESTARTUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgRestartUpReg;

      case cfc_spmfi_tclToken::EN_MSG_RESTARTRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgRestartRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_RESTARTSET:
         return OSAL_NEW cfc_spmfi_tclMsgRestartSet;

      case cfc_spmfi_tclToken::EN_MSG_RESTARTGET:
         return OSAL_NEW cfc_spmfi_tclMsgRestartGet;

      case cfc_spmfi_tclToken::EN_MSG_RESTARTSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgRestartStatus;

      case cfc_spmfi_tclToken::EN_MSG_DEVICEPOWERONTIMEGET:
         return OSAL_NEW cfc_spmfi_tclMsgDevicePowerOnTimeGet;

      case cfc_spmfi_tclToken::EN_MSG_DEVICEPOWERONTIMESET:
         return OSAL_NEW cfc_spmfi_tclMsgDevicePowerOnTimeSet;

      case cfc_spmfi_tclToken::EN_MSG_DEVICEPOWERONTIMESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgDevicePowerOnTimeStatus;

      case cfc_spmfi_tclToken::EN_MSG_LASTSYSTEMRUNTIMEGET:
         return OSAL_NEW cfc_spmfi_tclMsgLastSystemRuntimeGet;

      case cfc_spmfi_tclToken::EN_MSG_LASTSYSTEMRUNTIMESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgLastSystemRuntimeStatus;

      case cfc_spmfi_tclToken::EN_MSG_CURRENTSYSTEMRUNTIMEGET:
         return OSAL_NEW cfc_spmfi_tclMsgCurrentSystemRuntimeGet;

      case cfc_spmfi_tclToken::EN_MSG_CURRENTSYSTEMRUNTIMESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgCurrentSystemRuntimeStatus;

      case cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGSTATUSUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgFactorySettingStatusUpReg;

      case cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGSTATUSRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgFactorySettingStatusRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGSTATUSGET:
         return OSAL_NEW cfc_spmfi_tclMsgFactorySettingStatusGet;

      case cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGSTATUSSET:
         return OSAL_NEW cfc_spmfi_tclMsgFactorySettingStatusSet;

      case cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGSTATUSSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgFactorySettingStatusStatus;

      case cfc_spmfi_tclToken::EN_MSG_SECURITYCOMMERRORGET:
         return OSAL_NEW cfc_spmfi_tclMsgSecurityCommErrorGet;

      case cfc_spmfi_tclToken::EN_MSG_SECURITYCOMMERRORSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSecurityCommErrorStatus;

      case cfc_spmfi_tclToken::EN_MSG_SECURITYMORETHAN10VINGET:
         return OSAL_NEW cfc_spmfi_tclMsgSecurityMoreThan10VinGet;

      case cfc_spmfi_tclToken::EN_MSG_SECURITYMORETHAN10VINSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSecurityMoreThan10VinStatus;

      case cfc_spmfi_tclToken::EN_MSG_SECURITYINVALIDVINGET:
         return OSAL_NEW cfc_spmfi_tclMsgSecurityInvalidVinGet;

      case cfc_spmfi_tclToken::EN_MSG_SECURITYINVALIDVINSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSecurityInvalidVinStatus;

      case cfc_spmfi_tclToken::EN_MSG_SECURITYCURRENTVINGET:
         return OSAL_NEW cfc_spmfi_tclMsgSecurityCurrentVinGet;

      case cfc_spmfi_tclToken::EN_MSG_SECURITYCURRENTVINSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSecurityCurrentVinStatus;

      case cfc_spmfi_tclToken::EN_MSG_SECURITYVINHISTORYGET:
         return OSAL_NEW cfc_spmfi_tclMsgSecurityVinHistoryGet;

      case cfc_spmfi_tclToken::EN_MSG_SECURITYVINHISTORYSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSecurityVinHistoryStatus;

      case cfc_spmfi_tclToken::EN_MSG_RESETLISTSET:
         return OSAL_NEW cfc_spmfi_tclMsgResetListSet;

      case cfc_spmfi_tclToken::EN_MSG_RESETLISTGET:
         return OSAL_NEW cfc_spmfi_tclMsgResetListGet;

      case cfc_spmfi_tclToken::EN_MSG_RESETLISTSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgResetListStatus;

      case cfc_spmfi_tclToken::EN_MSG_RESETCOUNTERSET:
         return OSAL_NEW cfc_spmfi_tclMsgResetCounterSet;

      case cfc_spmfi_tclToken::EN_MSG_RESETCOUNTERGET:
         return OSAL_NEW cfc_spmfi_tclMsgResetCounterGet;

      case cfc_spmfi_tclToken::EN_MSG_RESETCOUNTERUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgResetCounterUpReg;

      case cfc_spmfi_tclToken::EN_MSG_RESETCOUNTERRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgResetCounterRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_RESETCOUNTERSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgResetCounterStatus;

      case cfc_spmfi_tclToken::EN_MSG_WAKEUPLISTSET:
         return OSAL_NEW cfc_spmfi_tclMsgWakeupListSet;

      case cfc_spmfi_tclToken::EN_MSG_WAKEUPLISTGET:
         return OSAL_NEW cfc_spmfi_tclMsgWakeupListGet;

      case cfc_spmfi_tclToken::EN_MSG_WAKEUPLISTSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgWakeupListStatus;

      case cfc_spmfi_tclToken::EN_MSG_TRANSPORTMODELISTSET:
         return OSAL_NEW cfc_spmfi_tclMsgTransportModeListSet;

      case cfc_spmfi_tclToken::EN_MSG_TRANSPORTMODELISTGET:
         return OSAL_NEW cfc_spmfi_tclMsgTransportModeListGet;

      case cfc_spmfi_tclToken::EN_MSG_TRANSPORTMODELISTSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgTransportModeListStatus;

      case cfc_spmfi_tclToken::EN_MSG_RESETHISTORYSET:
         return OSAL_NEW cfc_spmfi_tclMsgResetHistorySet;

      case cfc_spmfi_tclToken::EN_MSG_RESETHISTORYGET:
         return OSAL_NEW cfc_spmfi_tclMsgResetHistoryGet;

      case cfc_spmfi_tclToken::EN_MSG_RESETHISTORYSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgResetHistoryStatus;

      case cfc_spmfi_tclToken::EN_MSG_WAKEUPHISTORYSET:
         return OSAL_NEW cfc_spmfi_tclMsgWakeupHistorySet;

      case cfc_spmfi_tclToken::EN_MSG_WAKEUPHISTORYGET:
         return OSAL_NEW cfc_spmfi_tclMsgWakeupHistoryGet;

      case cfc_spmfi_tclToken::EN_MSG_WAKEUPHISTORYSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgWakeupHistoryStatus;

      case cfc_spmfi_tclToken::EN_MSG_STATEHISTORYSET:
         return OSAL_NEW cfc_spmfi_tclMsgStateHistorySet;

      case cfc_spmfi_tclToken::EN_MSG_STATEHISTORYGET:
         return OSAL_NEW cfc_spmfi_tclMsgStateHistoryGet;

      case cfc_spmfi_tclToken::EN_MSG_STATEHISTORYSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgStateHistoryStatus;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY01SET:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory01Set;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY01GET:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory01Get;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY01STATUS:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory01Status;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY02SET:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory02Set;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY02GET:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory02Get;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY02STATUS:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory02Status;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY03SET:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory03Set;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY03GET:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory03Get;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY03STATUS:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory03Status;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY04SET:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory04Set;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY04GET:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory04Get;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY04STATUS:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory04Status;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY05SET:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory05Set;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY05GET:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory05Get;

      case cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY05STATUS:
         return OSAL_NEW cfc_spmfi_tclMsgErrStateHistory05Status;

      case cfc_spmfi_tclToken::EN_MSG_SWITCHONHISTORYSET:
         return OSAL_NEW cfc_spmfi_tclMsgSwitchOnHistorySet;

      case cfc_spmfi_tclToken::EN_MSG_SWITCHONHISTORYGET:
         return OSAL_NEW cfc_spmfi_tclMsgSwitchOnHistoryGet;

      case cfc_spmfi_tclToken::EN_MSG_SWITCHONHISTORYSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgSwitchOnHistoryStatus;

      case cfc_spmfi_tclToken::EN_MSG_VEHICLETYPEGET:
         return OSAL_NEW cfc_spmfi_tclMsgVehicleTypeGet;

      case cfc_spmfi_tclToken::EN_MSG_VEHICLETYPESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgVehicleTypeStatus;

      case cfc_spmfi_tclToken::EN_MSG_CSMSIGNALSGET:
         return OSAL_NEW cfc_spmfi_tclMsgCsmSignalsGet;

      case cfc_spmfi_tclToken::EN_MSG_CSMSIGNALSSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgCsmSignalsStatus;

      case cfc_spmfi_tclToken::EN_MSG_CSMSIGNALSUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgCsmSignalsUpReg;

      case cfc_spmfi_tclToken::EN_MSG_CSMSIGNALSRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgCsmSignalsRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_HWSIGNALSGET:
         return OSAL_NEW cfc_spmfi_tclMsgHwSignalsGet;

      case cfc_spmfi_tclToken::EN_MSG_HWSIGNALSSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgHwSignalsStatus;

      case cfc_spmfi_tclToken::EN_MSG_PERSONALIZATIONENABLEDUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgPersonalizationEnabledUpReg;

      case cfc_spmfi_tclToken::EN_MSG_PERSONALIZATIONENABLEDRELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgPersonalizationEnabledRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_PERSONALIZATIONENABLEDGET:
         return OSAL_NEW cfc_spmfi_tclMsgPersonalizationEnabledGet;

      case cfc_spmfi_tclToken::EN_MSG_PERSONALIZATIONENABLEDSTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgPersonalizationEnabledStatus;

      case cfc_spmfi_tclToken::EN_MSG_PROFILECHANGEATRUNTIMEUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgProfileChangeAtRuntimeUpReg;

      case cfc_spmfi_tclToken::EN_MSG_PROFILECHANGEATRUNTIMERELUPREG:
         return OSAL_NEW cfc_spmfi_tclMsgProfileChangeAtRuntimeRelUpReg;

      case cfc_spmfi_tclToken::EN_MSG_PROFILECHANGEATRUNTIMEGET:
         return OSAL_NEW cfc_spmfi_tclMsgProfileChangeAtRuntimeGet;

      case cfc_spmfi_tclToken::EN_MSG_PROFILECHANGEATRUNTIMESTATUS:
         return OSAL_NEW cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all cfc_spmfifi messages

// common functions

tU16 cfc_spmfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return CFC_SPMFI_C_U16_SERVICE_ID;
}

tU16 cfc_spmfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 cfc_spmfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& cfc_spmfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& cfc_spmfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 cfc_spmfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& cfc_spmfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& cfc_spmfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSystemModeMethodStart::cfc_spmfi_tclMsgSystemModeMethodStart(const cfc_spmfi_tclMsgSystemModeMethodStart& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   eSystemMode = coRef.eSystemMode;
}
cfc_spmfi_tclMsgSystemModeMethodStart& cfc_spmfi_tclMsgSystemModeMethodStart::operator=(const cfc_spmfi_tclMsgSystemModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eSystemMode = coRef.eSystemMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSystemModeMethodStart::cfc_spmfi_tclMsgSystemModeMethodStart()
:eSystemMode()
 {}

tS32 cfc_spmfi_tclMsgSystemModeMethodStart::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMMODEMETHODSTART;
}


cfc_spmfi_tclMsgSystemModeMethodStart::~cfc_spmfi_tclMsgSystemModeMethodStart()
{}

tU32 cfc_spmfi_tclMsgSystemModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_spmfi_tclMsgSystemModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eSystemMode);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSystemModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eSystemMode);
   return oOut;
}

tBool cfc_spmfi_tclMsgSystemModeMethodStart::operator==(const cfc_spmfi_tclMsgSystemModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eSystemMode == roRef.eSystemMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSystemModeMethodResult::cfc_spmfi_tclMsgSystemModeMethodResult(const cfc_spmfi_tclMsgSystemModeMethodResult& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
cfc_spmfi_tclMsgSystemModeMethodResult& cfc_spmfi_tclMsgSystemModeMethodResult::operator=(const cfc_spmfi_tclMsgSystemModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSystemModeMethodResult::cfc_spmfi_tclMsgSystemModeMethodResult()
:s32ReturnVal(0)
 {}

tS32 cfc_spmfi_tclMsgSystemModeMethodResult::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMMODEMETHODRESULT;
}


cfc_spmfi_tclMsgSystemModeMethodResult::~cfc_spmfi_tclMsgSystemModeMethodResult()
{}

tU32 cfc_spmfi_tclMsgSystemModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgSystemModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSystemModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool cfc_spmfi_tclMsgSystemModeMethodResult::operator==(const cfc_spmfi_tclMsgSystemModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgStartProcessMethodStart::cfc_spmfi_tclMsgStartProcessMethodStart(const cfc_spmfi_tclMsgStartProcessMethodStart& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   strLocation = coRef.strLocation;
   u32Prio = coRef.u32Prio;
   u32Affinity = coRef.u32Affinity;
   u32AffinityEnd = coRef.u32AffinityEnd;
   u32NiceLevel = coRef.u32NiceLevel;
   u32NiceLevelEnd = coRef.u32NiceLevelEnd;
   u32Type = coRef.u32Type;
   u32Info = coRef.u32Info;
}
cfc_spmfi_tclMsgStartProcessMethodStart& cfc_spmfi_tclMsgStartProcessMethodStart::operator=(const cfc_spmfi_tclMsgStartProcessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strLocation = coRef.strLocation;
   u32Prio = coRef.u32Prio;
   u32Affinity = coRef.u32Affinity;
   u32AffinityEnd = coRef.u32AffinityEnd;
   u32NiceLevel = coRef.u32NiceLevel;
   u32NiceLevelEnd = coRef.u32NiceLevelEnd;
   u32Type = coRef.u32Type;
   u32Info = coRef.u32Info;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgStartProcessMethodStart::vDestroy()
{
   strLocation.vDestroy();
}

cfc_spmfi_tclMsgStartProcessMethodStart::cfc_spmfi_tclMsgStartProcessMethodStart()
:strLocation()
,u32Prio(0)
,u32Affinity(0)
,u32AffinityEnd(0)
,u32NiceLevel(0)
,u32NiceLevelEnd(0)
,u32Type()
,u32Info(0)
 {}

tS32 cfc_spmfi_tclMsgStartProcessMethodStart::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STARTPROCESSMETHODSTART;
}


cfc_spmfi_tclMsgStartProcessMethodStart::~cfc_spmfi_tclMsgStartProcessMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgStartProcessMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 28+strLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cfc_spmfi_tclMsgStartProcessMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strLocation);
   (tVoid) (oIn >> u32Prio);
   (tVoid) (oIn >> u32Affinity);
   (tVoid) (oIn >> u32AffinityEnd);
   (tVoid) (oIn >> u32NiceLevel);
   (tVoid) (oIn >> u32NiceLevelEnd);
   (tVoid) (oIn >> u32Type);
   (tVoid) (oIn >> u32Info);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgStartProcessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strLocation);
   (tVoid) (oOut << u32Prio);
   (tVoid) (oOut << u32Affinity);
   (tVoid) (oOut << u32AffinityEnd);
   (tVoid) (oOut << u32NiceLevel);
   (tVoid) (oOut << u32NiceLevelEnd);
   (tVoid) (oOut << u32Type);
   (tVoid) (oOut << u32Info);
   return oOut;
}

tBool cfc_spmfi_tclMsgStartProcessMethodStart::operator==(const cfc_spmfi_tclMsgStartProcessMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strLocation == roRef.strLocation);
   bResult = bResult && (u32Prio == roRef.u32Prio);
   bResult = bResult && (u32Affinity == roRef.u32Affinity);
   bResult = bResult && (u32AffinityEnd == roRef.u32AffinityEnd);
   bResult = bResult && (u32NiceLevel == roRef.u32NiceLevel);
   bResult = bResult && (u32NiceLevelEnd == roRef.u32NiceLevelEnd);
   bResult = bResult && (u32Type == roRef.u32Type);
   bResult = bResult && (u32Info == roRef.u32Info);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgStartProcessMethodResult::cfc_spmfi_tclMsgStartProcessMethodResult(const cfc_spmfi_tclMsgStartProcessMethodResult& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
   u32SpawnDuration = coRef.u32SpawnDuration;
}
cfc_spmfi_tclMsgStartProcessMethodResult& cfc_spmfi_tclMsgStartProcessMethodResult::operator=(const cfc_spmfi_tclMsgStartProcessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
   u32SpawnDuration = coRef.u32SpawnDuration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgStartProcessMethodResult::vDestroy()
{
   strLocation.vDestroy();
}

cfc_spmfi_tclMsgStartProcessMethodResult::cfc_spmfi_tclMsgStartProcessMethodResult()
:s32ReturnVal(0)
,strLocation()
,u32ProcId(0)
,u32SpawnDuration(0)
 {}

tS32 cfc_spmfi_tclMsgStartProcessMethodResult::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STARTPROCESSMETHODRESULT;
}


cfc_spmfi_tclMsgStartProcessMethodResult::~cfc_spmfi_tclMsgStartProcessMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgStartProcessMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+strLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cfc_spmfi_tclMsgStartProcessMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   (tVoid) (oIn >> strLocation);
   (tVoid) (oIn >> u32ProcId);
   (tVoid) (oIn >> u32SpawnDuration);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgStartProcessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   (tVoid) (oOut << strLocation);
   (tVoid) (oOut << u32ProcId);
   (tVoid) (oOut << u32SpawnDuration);
   return oOut;
}

tBool cfc_spmfi_tclMsgStartProcessMethodResult::operator==(const cfc_spmfi_tclMsgStartProcessMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   bResult = bResult && (strLocation == roRef.strLocation);
   bResult = bResult && (u32ProcId == roRef.u32ProcId);
   bResult = bResult && (u32SpawnDuration == roRef.u32SpawnDuration);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgEntertainDeMuteMethodStart::cfc_spmfi_tclMsgEntertainDeMuteMethodStart()
 {}

tS32 cfc_spmfi_tclMsgEntertainDeMuteMethodStart::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ENTERTAINDEMUTEMETHODSTART;
}


cfc_spmfi_tclMsgEntertainDeMuteMethodStart::~cfc_spmfi_tclMsgEntertainDeMuteMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgEntertainDeMuteMethodResult::cfc_spmfi_tclMsgEntertainDeMuteMethodResult(const cfc_spmfi_tclMsgEntertainDeMuteMethodResult& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
cfc_spmfi_tclMsgEntertainDeMuteMethodResult& cfc_spmfi_tclMsgEntertainDeMuteMethodResult::operator=(const cfc_spmfi_tclMsgEntertainDeMuteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgEntertainDeMuteMethodResult::cfc_spmfi_tclMsgEntertainDeMuteMethodResult()
:s32ReturnVal(0)
 {}

tS32 cfc_spmfi_tclMsgEntertainDeMuteMethodResult::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ENTERTAINDEMUTEMETHODRESULT;
}


cfc_spmfi_tclMsgEntertainDeMuteMethodResult::~cfc_spmfi_tclMsgEntertainDeMuteMethodResult()
{}

tU32 cfc_spmfi_tclMsgEntertainDeMuteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgEntertainDeMuteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgEntertainDeMuteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool cfc_spmfi_tclMsgEntertainDeMuteMethodResult::operator==(const cfc_spmfi_tclMsgEntertainDeMuteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgAudioSourceChangeMethodStart::cfc_spmfi_tclMsgAudioSourceChangeMethodStart(const cfc_spmfi_tclMsgAudioSourceChangeMethodStart& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   eAudioSrc = coRef.eAudioSrc;
}
cfc_spmfi_tclMsgAudioSourceChangeMethodStart& cfc_spmfi_tclMsgAudioSourceChangeMethodStart::operator=(const cfc_spmfi_tclMsgAudioSourceChangeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eAudioSrc = coRef.eAudioSrc;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgAudioSourceChangeMethodStart::cfc_spmfi_tclMsgAudioSourceChangeMethodStart()
:eAudioSrc()
 {}

tS32 cfc_spmfi_tclMsgAudioSourceChangeMethodStart::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_AUDIOSOURCECHANGEMETHODSTART;
}


cfc_spmfi_tclMsgAudioSourceChangeMethodStart::~cfc_spmfi_tclMsgAudioSourceChangeMethodStart()
{}

tU32 cfc_spmfi_tclMsgAudioSourceChangeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgAudioSourceChangeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eAudioSrc);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgAudioSourceChangeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eAudioSrc);
   return oOut;
}

tBool cfc_spmfi_tclMsgAudioSourceChangeMethodStart::operator==(const cfc_spmfi_tclMsgAudioSourceChangeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eAudioSrc == roRef.eAudioSrc);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgAudioSourceChangeMethodResult::cfc_spmfi_tclMsgAudioSourceChangeMethodResult()
 {}

tS32 cfc_spmfi_tclMsgAudioSourceChangeMethodResult::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_AUDIOSOURCECHANGEMETHODRESULT;
}


cfc_spmfi_tclMsgAudioSourceChangeMethodResult::~cfc_spmfi_tclMsgAudioSourceChangeMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgFactorySettingMethodStart::cfc_spmfi_tclMsgFactorySettingMethodStart(const cfc_spmfi_tclMsgFactorySettingMethodStart& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
}
cfc_spmfi_tclMsgFactorySettingMethodStart& cfc_spmfi_tclMsgFactorySettingMethodStart::operator=(const cfc_spmfi_tclMsgFactorySettingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgFactorySettingMethodStart::cfc_spmfi_tclMsgFactorySettingMethodStart()
:DefSetStateGroup(0)
,DefSetStateMode()
 {}

tS32 cfc_spmfi_tclMsgFactorySettingMethodStart::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGMETHODSTART;
}


cfc_spmfi_tclMsgFactorySettingMethodStart::~cfc_spmfi_tclMsgFactorySettingMethodStart()
{}

tU32 cfc_spmfi_tclMsgFactorySettingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_spmfi_tclMsgFactorySettingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgFactorySettingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   return oOut;
}

tBool cfc_spmfi_tclMsgFactorySettingMethodStart::operator==(const cfc_spmfi_tclMsgFactorySettingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgFactorySettingMethodResult::cfc_spmfi_tclMsgFactorySettingMethodResult(const cfc_spmfi_tclMsgFactorySettingMethodResult& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetServiceStatus = coRef.DefSetServiceStatus;
}
cfc_spmfi_tclMsgFactorySettingMethodResult& cfc_spmfi_tclMsgFactorySettingMethodResult::operator=(const cfc_spmfi_tclMsgFactorySettingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetServiceStatus = coRef.DefSetServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgFactorySettingMethodResult::cfc_spmfi_tclMsgFactorySettingMethodResult()
:DefSetStateGroup(0)
,DefSetServiceStatus()
 {}

tS32 cfc_spmfi_tclMsgFactorySettingMethodResult::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGMETHODRESULT;
}


cfc_spmfi_tclMsgFactorySettingMethodResult::~cfc_spmfi_tclMsgFactorySettingMethodResult()
{}

tU32 cfc_spmfi_tclMsgFactorySettingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_spmfi_tclMsgFactorySettingMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetServiceStatus);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgFactorySettingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetServiceStatus);
   return oOut;
}

tBool cfc_spmfi_tclMsgFactorySettingMethodResult::operator==(const cfc_spmfi_tclMsgFactorySettingMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetServiceStatus == roRef.DefSetServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgDiagConfigurationMethodStart::cfc_spmfi_tclMsgDiagConfigurationMethodStart(const cfc_spmfi_tclMsgDiagConfigurationMethodStart& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
}
cfc_spmfi_tclMsgDiagConfigurationMethodStart& cfc_spmfi_tclMsgDiagConfigurationMethodStart::operator=(const cfc_spmfi_tclMsgDiagConfigurationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgDiagConfigurationMethodStart::cfc_spmfi_tclMsgDiagConfigurationMethodStart()
:DefSetStateGroup(0)
,DefSetStateMode()
 {}

tS32 cfc_spmfi_tclMsgDiagConfigurationMethodStart::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DIAGCONFIGURATIONMETHODSTART;
}


cfc_spmfi_tclMsgDiagConfigurationMethodStart::~cfc_spmfi_tclMsgDiagConfigurationMethodStart()
{}

tU32 cfc_spmfi_tclMsgDiagConfigurationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_spmfi_tclMsgDiagConfigurationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgDiagConfigurationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   return oOut;
}

tBool cfc_spmfi_tclMsgDiagConfigurationMethodStart::operator==(const cfc_spmfi_tclMsgDiagConfigurationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgDiagConfigurationMethodResult::cfc_spmfi_tclMsgDiagConfigurationMethodResult(const cfc_spmfi_tclMsgDiagConfigurationMethodResult& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetServiceStatus = coRef.DefSetServiceStatus;
}
cfc_spmfi_tclMsgDiagConfigurationMethodResult& cfc_spmfi_tclMsgDiagConfigurationMethodResult::operator=(const cfc_spmfi_tclMsgDiagConfigurationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetServiceStatus = coRef.DefSetServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgDiagConfigurationMethodResult::cfc_spmfi_tclMsgDiagConfigurationMethodResult()
:DefSetStateGroup(0)
,DefSetServiceStatus()
 {}

tS32 cfc_spmfi_tclMsgDiagConfigurationMethodResult::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DIAGCONFIGURATIONMETHODRESULT;
}


cfc_spmfi_tclMsgDiagConfigurationMethodResult::~cfc_spmfi_tclMsgDiagConfigurationMethodResult()
{}

tU32 cfc_spmfi_tclMsgDiagConfigurationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_spmfi_tclMsgDiagConfigurationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetServiceStatus);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgDiagConfigurationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetServiceStatus);
   return oOut;
}

tBool cfc_spmfi_tclMsgDiagConfigurationMethodResult::operator==(const cfc_spmfi_tclMsgDiagConfigurationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetServiceStatus == roRef.DefSetServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgPerformTestMethodStart::cfc_spmfi_tclMsgPerformTestMethodStart(const cfc_spmfi_tclMsgPerformTestMethodStart& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   TestRoutineParameterList = coRef.TestRoutineParameterList;
}
cfc_spmfi_tclMsgPerformTestMethodStart& cfc_spmfi_tclMsgPerformTestMethodStart::operator=(const cfc_spmfi_tclMsgPerformTestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TestRoutineParameterList = coRef.TestRoutineParameterList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgPerformTestMethodStart::vDestroy()
{
   TestRoutineParameterList.vDestroy(); 
}

cfc_spmfi_tclMsgPerformTestMethodStart::cfc_spmfi_tclMsgPerformTestMethodStart()
:TestRoutineParameterList()
 {}

tS32 cfc_spmfi_tclMsgPerformTestMethodStart::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PERFORMTESTMETHODSTART;
}


cfc_spmfi_tclMsgPerformTestMethodStart::~cfc_spmfi_tclMsgPerformTestMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgPerformTestMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TestRoutineParameterList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cfc_spmfi_tclMsgPerformTestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestRoutineParameterList);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgPerformTestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestRoutineParameterList);
   return oOut;
}

tBool cfc_spmfi_tclMsgPerformTestMethodStart::operator==(const cfc_spmfi_tclMsgPerformTestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestRoutineParameterList == roRef.TestRoutineParameterList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgPerformTestMethodResult::cfc_spmfi_tclMsgPerformTestMethodResult(const cfc_spmfi_tclMsgPerformTestMethodResult& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   TestResultList = coRef.TestResultList;
}
cfc_spmfi_tclMsgPerformTestMethodResult& cfc_spmfi_tclMsgPerformTestMethodResult::operator=(const cfc_spmfi_tclMsgPerformTestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TestResultList = coRef.TestResultList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgPerformTestMethodResult::vDestroy()
{
   TestResultList.vDestroy(); 
}

cfc_spmfi_tclMsgPerformTestMethodResult::cfc_spmfi_tclMsgPerformTestMethodResult()
:TestResultList()
 {}

tS32 cfc_spmfi_tclMsgPerformTestMethodResult::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PERFORMTESTMETHODRESULT;
}


cfc_spmfi_tclMsgPerformTestMethodResult::~cfc_spmfi_tclMsgPerformTestMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgPerformTestMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TestResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cfc_spmfi_tclMsgPerformTestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestResultList);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgPerformTestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestResultList);
   return oOut;
}

tBool cfc_spmfi_tclMsgPerformTestMethodResult::operator==(const cfc_spmfi_tclMsgPerformTestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestResultList == roRef.TestResultList);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSystemStateUpReg::cfc_spmfi_tclMsgSystemStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgSystemStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATEUPREG;
}


cfc_spmfi_tclMsgSystemStateUpReg::~cfc_spmfi_tclMsgSystemStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgSystemStateRelUpReg::cfc_spmfi_tclMsgSystemStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgSystemStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATERELUPREG;
}


cfc_spmfi_tclMsgSystemStateRelUpReg::~cfc_spmfi_tclMsgSystemStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgSystemStateGet::cfc_spmfi_tclMsgSystemStateGet()
 {}

tS32 cfc_spmfi_tclMsgSystemStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATEGET;
}


cfc_spmfi_tclMsgSystemStateGet::~cfc_spmfi_tclMsgSystemStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSystemStateStatus::cfc_spmfi_tclMsgSystemStateStatus(const cfc_spmfi_tclMsgSystemStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   SystemState = coRef.SystemState;
}
cfc_spmfi_tclMsgSystemStateStatus& cfc_spmfi_tclMsgSystemStateStatus::operator=(const cfc_spmfi_tclMsgSystemStateStatus& coRef)
{
   if (this == &coRef) return *this;
   SystemState = coRef.SystemState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSystemStateStatus::cfc_spmfi_tclMsgSystemStateStatus()
:SystemState()
 {}

tS32 cfc_spmfi_tclMsgSystemStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATESTATUS;
}


cfc_spmfi_tclMsgSystemStateStatus::~cfc_spmfi_tclMsgSystemStateStatus()
{}

tU32 cfc_spmfi_tclMsgSystemStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgSystemStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SystemState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSystemStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SystemState);
   return oOut;
}

tBool cfc_spmfi_tclMsgSystemStateStatus::operator==(const cfc_spmfi_tclMsgSystemStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SystemState == roRef.SystemState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgOnOffReasonSet::cfc_spmfi_tclMsgOnOffReasonSet(const cfc_spmfi_tclMsgOnOffReasonSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   OnOffReason = coRef.OnOffReason;
}
cfc_spmfi_tclMsgOnOffReasonSet& cfc_spmfi_tclMsgOnOffReasonSet::operator=(const cfc_spmfi_tclMsgOnOffReasonSet& coRef)
{
   if (this == &coRef) return *this;
   OnOffReason = coRef.OnOffReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgOnOffReasonSet::cfc_spmfi_tclMsgOnOffReasonSet()
:OnOffReason()
 {}

tS32 cfc_spmfi_tclMsgOnOffReasonSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ONOFFREASONSET;
}


cfc_spmfi_tclMsgOnOffReasonSet::~cfc_spmfi_tclMsgOnOffReasonSet()
{}

tU32 cfc_spmfi_tclMsgOnOffReasonSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgOnOffReasonSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OnOffReason);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgOnOffReasonSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OnOffReason);
   return oOut;
}

tBool cfc_spmfi_tclMsgOnOffReasonSet::operator==(const cfc_spmfi_tclMsgOnOffReasonSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OnOffReason == roRef.OnOffReason);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgOnOffReasonGet::cfc_spmfi_tclMsgOnOffReasonGet()
 {}

tS32 cfc_spmfi_tclMsgOnOffReasonGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ONOFFREASONGET;
}


cfc_spmfi_tclMsgOnOffReasonGet::~cfc_spmfi_tclMsgOnOffReasonGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgOnOffReasonStatus::cfc_spmfi_tclMsgOnOffReasonStatus(const cfc_spmfi_tclMsgOnOffReasonStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   OnOffReason = coRef.OnOffReason;
}
cfc_spmfi_tclMsgOnOffReasonStatus& cfc_spmfi_tclMsgOnOffReasonStatus::operator=(const cfc_spmfi_tclMsgOnOffReasonStatus& coRef)
{
   if (this == &coRef) return *this;
   OnOffReason = coRef.OnOffReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgOnOffReasonStatus::cfc_spmfi_tclMsgOnOffReasonStatus()
:OnOffReason()
 {}

tS32 cfc_spmfi_tclMsgOnOffReasonStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ONOFFREASONSTATUS;
}


cfc_spmfi_tclMsgOnOffReasonStatus::~cfc_spmfi_tclMsgOnOffReasonStatus()
{}

tU32 cfc_spmfi_tclMsgOnOffReasonStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgOnOffReasonStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OnOffReason);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgOnOffReasonStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OnOffReason);
   return oOut;
}

tBool cfc_spmfi_tclMsgOnOffReasonStatus::operator==(const cfc_spmfi_tclMsgOnOffReasonStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OnOffReason == roRef.OnOffReason);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgOnOffReasonUpReg::cfc_spmfi_tclMsgOnOffReasonUpReg()
 {}

tS32 cfc_spmfi_tclMsgOnOffReasonUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ONOFFREASONUPREG;
}


cfc_spmfi_tclMsgOnOffReasonUpReg::~cfc_spmfi_tclMsgOnOffReasonUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgOnOffReasonRelUpReg::cfc_spmfi_tclMsgOnOffReasonRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgOnOffReasonRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ONOFFREASONRELUPREG;
}


cfc_spmfi_tclMsgOnOffReasonRelUpReg::~cfc_spmfi_tclMsgOnOffReasonRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSubStatesSet::cfc_spmfi_tclMsgSubStatesSet(const cfc_spmfi_tclMsgSubStatesSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   SubStateType = coRef.SubStateType;
   SubStateData = coRef.SubStateData;
}
cfc_spmfi_tclMsgSubStatesSet& cfc_spmfi_tclMsgSubStatesSet::operator=(const cfc_spmfi_tclMsgSubStatesSet& coRef)
{
   if (this == &coRef) return *this;
   SubStateType = coRef.SubStateType;
   SubStateData = coRef.SubStateData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSubStatesSet::cfc_spmfi_tclMsgSubStatesSet()
:SubStateType()
,SubStateData(0)
 {}

tS32 cfc_spmfi_tclMsgSubStatesSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SUBSTATESSET;
}


cfc_spmfi_tclMsgSubStatesSet::~cfc_spmfi_tclMsgSubStatesSet()
{}

tU32 cfc_spmfi_tclMsgSubStatesSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& cfc_spmfi_tclMsgSubStatesSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SubStateType);
   (tVoid) (oIn >> SubStateData);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSubStatesSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SubStateType);
   (tVoid) (oOut << SubStateData);
   return oOut;
}

tBool cfc_spmfi_tclMsgSubStatesSet::operator==(const cfc_spmfi_tclMsgSubStatesSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SubStateType == roRef.SubStateType);
   bResult = bResult && (SubStateData == roRef.SubStateData);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSubStatesGet::cfc_spmfi_tclMsgSubStatesGet()
 {}

tS32 cfc_spmfi_tclMsgSubStatesGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SUBSTATESGET;
}


cfc_spmfi_tclMsgSubStatesGet::~cfc_spmfi_tclMsgSubStatesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSubStatesStatus::cfc_spmfi_tclMsgSubStatesStatus(const cfc_spmfi_tclMsgSubStatesStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   SubState = coRef.SubState;
   HwSubState = coRef.HwSubState;
   InternSubState = coRef.InternSubState;
}
cfc_spmfi_tclMsgSubStatesStatus& cfc_spmfi_tclMsgSubStatesStatus::operator=(const cfc_spmfi_tclMsgSubStatesStatus& coRef)
{
   if (this == &coRef) return *this;
   SubState = coRef.SubState;
   HwSubState = coRef.HwSubState;
   InternSubState = coRef.InternSubState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSubStatesStatus::cfc_spmfi_tclMsgSubStatesStatus()
:SubState(0)
,HwSubState(0)
,InternSubState(0)
 {}

tS32 cfc_spmfi_tclMsgSubStatesStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SUBSTATESSTATUS;
}


cfc_spmfi_tclMsgSubStatesStatus::~cfc_spmfi_tclMsgSubStatesStatus()
{}

tU32 cfc_spmfi_tclMsgSubStatesStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& cfc_spmfi_tclMsgSubStatesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SubState);
   (tVoid) (oIn >> HwSubState);
   (tVoid) (oIn >> InternSubState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSubStatesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SubState);
   (tVoid) (oOut << HwSubState);
   (tVoid) (oOut << InternSubState);
   return oOut;
}

tBool cfc_spmfi_tclMsgSubStatesStatus::operator==(const cfc_spmfi_tclMsgSubStatesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SubState == roRef.SubState);
   bResult = bResult && (HwSubState == roRef.HwSubState);
   bResult = bResult && (InternSubState == roRef.InternSubState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSubStatesUpReg::cfc_spmfi_tclMsgSubStatesUpReg()
 {}

tS32 cfc_spmfi_tclMsgSubStatesUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SUBSTATESUPREG;
}


cfc_spmfi_tclMsgSubStatesUpReg::~cfc_spmfi_tclMsgSubStatesUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgSubStatesRelUpReg::cfc_spmfi_tclMsgSubStatesRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgSubStatesRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SUBSTATESRELUPREG;
}


cfc_spmfi_tclMsgSubStatesRelUpReg::~cfc_spmfi_tclMsgSubStatesRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgStartupStateUpReg::cfc_spmfi_tclMsgStartupStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgStartupStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STARTUPSTATEUPREG;
}


cfc_spmfi_tclMsgStartupStateUpReg::~cfc_spmfi_tclMsgStartupStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgStartupStateRelUpReg::cfc_spmfi_tclMsgStartupStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgStartupStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STARTUPSTATERELUPREG;
}


cfc_spmfi_tclMsgStartupStateRelUpReg::~cfc_spmfi_tclMsgStartupStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgStartupStateGet::cfc_spmfi_tclMsgStartupStateGet()
 {}

tS32 cfc_spmfi_tclMsgStartupStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STARTUPSTATEGET;
}


cfc_spmfi_tclMsgStartupStateGet::~cfc_spmfi_tclMsgStartupStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgStartupStateStatus::cfc_spmfi_tclMsgStartupStateStatus(const cfc_spmfi_tclMsgStartupStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   StartupState = coRef.StartupState;
}
cfc_spmfi_tclMsgStartupStateStatus& cfc_spmfi_tclMsgStartupStateStatus::operator=(const cfc_spmfi_tclMsgStartupStateStatus& coRef)
{
   if (this == &coRef) return *this;
   StartupState = coRef.StartupState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgStartupStateStatus::cfc_spmfi_tclMsgStartupStateStatus()
:StartupState()
 {}

tS32 cfc_spmfi_tclMsgStartupStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STARTUPSTATESTATUS;
}


cfc_spmfi_tclMsgStartupStateStatus::~cfc_spmfi_tclMsgStartupStateStatus()
{}

tU32 cfc_spmfi_tclMsgStartupStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgStartupStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StartupState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgStartupStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StartupState);
   return oOut;
}

tBool cfc_spmfi_tclMsgStartupStateStatus::operator==(const cfc_spmfi_tclMsgStartupStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StartupState == roRef.StartupState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgProcessListUpReg::cfc_spmfi_tclMsgProcessListUpReg()
 {}

tS32 cfc_spmfi_tclMsgProcessListUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PROCESSLISTUPREG;
}


cfc_spmfi_tclMsgProcessListUpReg::~cfc_spmfi_tclMsgProcessListUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgProcessListRelUpReg::cfc_spmfi_tclMsgProcessListRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgProcessListRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PROCESSLISTRELUPREG;
}


cfc_spmfi_tclMsgProcessListRelUpReg::~cfc_spmfi_tclMsgProcessListRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgProcessListGet::cfc_spmfi_tclMsgProcessListGet()
 {}

tS32 cfc_spmfi_tclMsgProcessListGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PROCESSLISTGET;
}


cfc_spmfi_tclMsgProcessListGet::~cfc_spmfi_tclMsgProcessListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgProcessListStatus::cfc_spmfi_tclMsgProcessListStatus(const cfc_spmfi_tclMsgProcessListStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tProcesses = coRef.tProcesses;
}
cfc_spmfi_tclMsgProcessListStatus& cfc_spmfi_tclMsgProcessListStatus::operator=(const cfc_spmfi_tclMsgProcessListStatus& coRef)
{
   if (this == &coRef) return *this;
   tProcesses = coRef.tProcesses;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgProcessListStatus::vDestroy()
{
   tProcesses.vDestroy(); 
}

cfc_spmfi_tclMsgProcessListStatus::cfc_spmfi_tclMsgProcessListStatus()
:tProcesses()
 {}

tS32 cfc_spmfi_tclMsgProcessListStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PROCESSLISTSTATUS;
}


cfc_spmfi_tclMsgProcessListStatus::~cfc_spmfi_tclMsgProcessListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgProcessListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+tProcesses.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cfc_spmfi_tclMsgProcessListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tProcesses);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgProcessListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tProcesses);
   return oOut;
}

tBool cfc_spmfi_tclMsgProcessListStatus::operator==(const cfc_spmfi_tclMsgProcessListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tProcesses == roRef.tProcesses);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgWakeupReasonGet::cfc_spmfi_tclMsgWakeupReasonGet()
 {}

tS32 cfc_spmfi_tclMsgWakeupReasonGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_WAKEUPREASONGET;
}


cfc_spmfi_tclMsgWakeupReasonGet::~cfc_spmfi_tclMsgWakeupReasonGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgWakeupReasonStatus::cfc_spmfi_tclMsgWakeupReasonStatus(const cfc_spmfi_tclMsgWakeupReasonStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   WakeupReason = coRef.WakeupReason;
}
cfc_spmfi_tclMsgWakeupReasonStatus& cfc_spmfi_tclMsgWakeupReasonStatus::operator=(const cfc_spmfi_tclMsgWakeupReasonStatus& coRef)
{
   if (this == &coRef) return *this;
   WakeupReason = coRef.WakeupReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgWakeupReasonStatus::cfc_spmfi_tclMsgWakeupReasonStatus()
:WakeupReason()
 {}

tS32 cfc_spmfi_tclMsgWakeupReasonStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_WAKEUPREASONSTATUS;
}


cfc_spmfi_tclMsgWakeupReasonStatus::~cfc_spmfi_tclMsgWakeupReasonStatus()
{}

tU32 cfc_spmfi_tclMsgWakeupReasonStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgWakeupReasonStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WakeupReason);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgWakeupReasonStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WakeupReason);
   return oOut;
}

tBool cfc_spmfi_tclMsgWakeupReasonStatus::operator==(const cfc_spmfi_tclMsgWakeupReasonStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WakeupReason == roRef.WakeupReason);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgStartupReasonGet::cfc_spmfi_tclMsgStartupReasonGet()
 {}

tS32 cfc_spmfi_tclMsgStartupReasonGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STARTUPREASONGET;
}


cfc_spmfi_tclMsgStartupReasonGet::~cfc_spmfi_tclMsgStartupReasonGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgStartupReasonStatus::cfc_spmfi_tclMsgStartupReasonStatus(const cfc_spmfi_tclMsgStartupReasonStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   StartupReason = coRef.StartupReason;
}
cfc_spmfi_tclMsgStartupReasonStatus& cfc_spmfi_tclMsgStartupReasonStatus::operator=(const cfc_spmfi_tclMsgStartupReasonStatus& coRef)
{
   if (this == &coRef) return *this;
   StartupReason = coRef.StartupReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgStartupReasonStatus::cfc_spmfi_tclMsgStartupReasonStatus()
:StartupReason()
 {}

tS32 cfc_spmfi_tclMsgStartupReasonStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STARTUPREASONSTATUS;
}


cfc_spmfi_tclMsgStartupReasonStatus::~cfc_spmfi_tclMsgStartupReasonStatus()
{}

tU32 cfc_spmfi_tclMsgStartupReasonStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgStartupReasonStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StartupReason);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgStartupReasonStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StartupReason);
   return oOut;
}

tBool cfc_spmfi_tclMsgStartupReasonStatus::operator==(const cfc_spmfi_tclMsgStartupReasonStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StartupReason == roRef.StartupReason);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgConnectToBatteryGet::cfc_spmfi_tclMsgConnectToBatteryGet()
 {}

tS32 cfc_spmfi_tclMsgConnectToBatteryGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CONNECTTOBATTERYGET;
}


cfc_spmfi_tclMsgConnectToBatteryGet::~cfc_spmfi_tclMsgConnectToBatteryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgConnectToBatteryStatus::cfc_spmfi_tclMsgConnectToBatteryStatus(const cfc_spmfi_tclMsgConnectToBatteryStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   ConnectToBatteryState = coRef.ConnectToBatteryState;
   ConnectToBatteryCount = coRef.ConnectToBatteryCount;
}
cfc_spmfi_tclMsgConnectToBatteryStatus& cfc_spmfi_tclMsgConnectToBatteryStatus::operator=(const cfc_spmfi_tclMsgConnectToBatteryStatus& coRef)
{
   if (this == &coRef) return *this;
   ConnectToBatteryState = coRef.ConnectToBatteryState;
   ConnectToBatteryCount = coRef.ConnectToBatteryCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgConnectToBatteryStatus::cfc_spmfi_tclMsgConnectToBatteryStatus()
:ConnectToBatteryState(0)
,ConnectToBatteryCount(0)
 {}

tS32 cfc_spmfi_tclMsgConnectToBatteryStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CONNECTTOBATTERYSTATUS;
}


cfc_spmfi_tclMsgConnectToBatteryStatus::~cfc_spmfi_tclMsgConnectToBatteryStatus()
{}

tU32 cfc_spmfi_tclMsgConnectToBatteryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_spmfi_tclMsgConnectToBatteryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConnectToBatteryState);
   (tVoid) (oIn >> ConnectToBatteryCount);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgConnectToBatteryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConnectToBatteryState);
   (tVoid) (oOut << ConnectToBatteryCount);
   return oOut;
}

tBool cfc_spmfi_tclMsgConnectToBatteryStatus::operator==(const cfc_spmfi_tclMsgConnectToBatteryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConnectToBatteryState == roRef.ConnectToBatteryState);
   bResult = bResult && (ConnectToBatteryCount == roRef.ConnectToBatteryCount);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgCvmEventUpReg::cfc_spmfi_tclMsgCvmEventUpReg()
 {}

tS32 cfc_spmfi_tclMsgCvmEventUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CVMEVENTUPREG;
}


cfc_spmfi_tclMsgCvmEventUpReg::~cfc_spmfi_tclMsgCvmEventUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgCvmEventRelUpReg::cfc_spmfi_tclMsgCvmEventRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgCvmEventRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CVMEVENTRELUPREG;
}


cfc_spmfi_tclMsgCvmEventRelUpReg::~cfc_spmfi_tclMsgCvmEventRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgCvmEventGet::cfc_spmfi_tclMsgCvmEventGet()
 {}

tS32 cfc_spmfi_tclMsgCvmEventGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CVMEVENTGET;
}


cfc_spmfi_tclMsgCvmEventGet::~cfc_spmfi_tclMsgCvmEventGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgCvmEventStatus::cfc_spmfi_tclMsgCvmEventStatus(const cfc_spmfi_tclMsgCvmEventStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   CvmEvent = coRef.CvmEvent;
}
cfc_spmfi_tclMsgCvmEventStatus& cfc_spmfi_tclMsgCvmEventStatus::operator=(const cfc_spmfi_tclMsgCvmEventStatus& coRef)
{
   if (this == &coRef) return *this;
   CvmEvent = coRef.CvmEvent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgCvmEventStatus::cfc_spmfi_tclMsgCvmEventStatus()
:CvmEvent()
 {}

tS32 cfc_spmfi_tclMsgCvmEventStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CVMEVENTSTATUS;
}


cfc_spmfi_tclMsgCvmEventStatus::~cfc_spmfi_tclMsgCvmEventStatus()
{}

tU32 cfc_spmfi_tclMsgCvmEventStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgCvmEventStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CvmEvent);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgCvmEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CvmEvent);
   return oOut;
}

tBool cfc_spmfi_tclMsgCvmEventStatus::operator==(const cfc_spmfi_tclMsgCvmEventStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CvmEvent == roRef.CvmEvent);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgUBatSenseGet::cfc_spmfi_tclMsgUBatSenseGet()
 {}

tS32 cfc_spmfi_tclMsgUBatSenseGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_UBATSENSEGET;
}


cfc_spmfi_tclMsgUBatSenseGet::~cfc_spmfi_tclMsgUBatSenseGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgUBatSenseStatus::cfc_spmfi_tclMsgUBatSenseStatus(const cfc_spmfi_tclMsgUBatSenseStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   UBatSense = coRef.UBatSense;
}
cfc_spmfi_tclMsgUBatSenseStatus& cfc_spmfi_tclMsgUBatSenseStatus::operator=(const cfc_spmfi_tclMsgUBatSenseStatus& coRef)
{
   if (this == &coRef) return *this;
   UBatSense = coRef.UBatSense;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgUBatSenseStatus::cfc_spmfi_tclMsgUBatSenseStatus()
:UBatSense(0)
 {}

tS32 cfc_spmfi_tclMsgUBatSenseStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_UBATSENSESTATUS;
}


cfc_spmfi_tclMsgUBatSenseStatus::~cfc_spmfi_tclMsgUBatSenseStatus()
{}

tU32 cfc_spmfi_tclMsgUBatSenseStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_spmfi_tclMsgUBatSenseStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UBatSense);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgUBatSenseStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UBatSense);
   return oOut;
}

tBool cfc_spmfi_tclMsgUBatSenseStatus::operator==(const cfc_spmfi_tclMsgUBatSenseStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UBatSense == roRef.UBatSense);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgCalibratedCvmEventUpReg::cfc_spmfi_tclMsgCalibratedCvmEventUpReg()
 {}

tS32 cfc_spmfi_tclMsgCalibratedCvmEventUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CALIBRATEDCVMEVENTUPREG;
}


cfc_spmfi_tclMsgCalibratedCvmEventUpReg::~cfc_spmfi_tclMsgCalibratedCvmEventUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgCalibratedCvmEventRelUpReg::cfc_spmfi_tclMsgCalibratedCvmEventRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgCalibratedCvmEventRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CALIBRATEDCVMEVENTRELUPREG;
}


cfc_spmfi_tclMsgCalibratedCvmEventRelUpReg::~cfc_spmfi_tclMsgCalibratedCvmEventRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgCalibratedCvmEventGet::cfc_spmfi_tclMsgCalibratedCvmEventGet()
 {}

tS32 cfc_spmfi_tclMsgCalibratedCvmEventGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CALIBRATEDCVMEVENTGET;
}


cfc_spmfi_tclMsgCalibratedCvmEventGet::~cfc_spmfi_tclMsgCalibratedCvmEventGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgCalibratedCvmEventStatus::cfc_spmfi_tclMsgCalibratedCvmEventStatus(const cfc_spmfi_tclMsgCalibratedCvmEventStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   CvmEvent = coRef.CvmEvent;
}
cfc_spmfi_tclMsgCalibratedCvmEventStatus& cfc_spmfi_tclMsgCalibratedCvmEventStatus::operator=(const cfc_spmfi_tclMsgCalibratedCvmEventStatus& coRef)
{
   if (this == &coRef) return *this;
   CvmEvent = coRef.CvmEvent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgCalibratedCvmEventStatus::cfc_spmfi_tclMsgCalibratedCvmEventStatus()
:CvmEvent()
 {}

tS32 cfc_spmfi_tclMsgCalibratedCvmEventStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CALIBRATEDCVMEVENTSTATUS;
}


cfc_spmfi_tclMsgCalibratedCvmEventStatus::~cfc_spmfi_tclMsgCalibratedCvmEventStatus()
{}

tU32 cfc_spmfi_tclMsgCalibratedCvmEventStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgCalibratedCvmEventStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CvmEvent);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgCalibratedCvmEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CvmEvent);
   return oOut;
}

tBool cfc_spmfi_tclMsgCalibratedCvmEventStatus::operator==(const cfc_spmfi_tclMsgCalibratedCvmEventStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CvmEvent == roRef.CvmEvent);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgIgnitionCyclesUpReg::cfc_spmfi_tclMsgIgnitionCyclesUpReg()
 {}

tS32 cfc_spmfi_tclMsgIgnitionCyclesUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_IGNITIONCYCLESUPREG;
}


cfc_spmfi_tclMsgIgnitionCyclesUpReg::~cfc_spmfi_tclMsgIgnitionCyclesUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgIgnitionCyclesRelUpReg::cfc_spmfi_tclMsgIgnitionCyclesRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgIgnitionCyclesRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_IGNITIONCYCLESRELUPREG;
}


cfc_spmfi_tclMsgIgnitionCyclesRelUpReg::~cfc_spmfi_tclMsgIgnitionCyclesRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgIgnitionCyclesGet::cfc_spmfi_tclMsgIgnitionCyclesGet()
 {}

tS32 cfc_spmfi_tclMsgIgnitionCyclesGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_IGNITIONCYCLESGET;
}


cfc_spmfi_tclMsgIgnitionCyclesGet::~cfc_spmfi_tclMsgIgnitionCyclesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgIgnitionCyclesStatus::cfc_spmfi_tclMsgIgnitionCyclesStatus(const cfc_spmfi_tclMsgIgnitionCyclesStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   IgnitionCycle = coRef.IgnitionCycle;
}
cfc_spmfi_tclMsgIgnitionCyclesStatus& cfc_spmfi_tclMsgIgnitionCyclesStatus::operator=(const cfc_spmfi_tclMsgIgnitionCyclesStatus& coRef)
{
   if (this == &coRef) return *this;
   IgnitionCycle = coRef.IgnitionCycle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgIgnitionCyclesStatus::cfc_spmfi_tclMsgIgnitionCyclesStatus()
:IgnitionCycle(0)
 {}

tS32 cfc_spmfi_tclMsgIgnitionCyclesStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_IGNITIONCYCLESSTATUS;
}


cfc_spmfi_tclMsgIgnitionCyclesStatus::~cfc_spmfi_tclMsgIgnitionCyclesStatus()
{}

tU32 cfc_spmfi_tclMsgIgnitionCyclesStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgIgnitionCyclesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IgnitionCycle);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgIgnitionCyclesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IgnitionCycle);
   return oOut;
}

tBool cfc_spmfi_tclMsgIgnitionCyclesStatus::operator==(const cfc_spmfi_tclMsgIgnitionCyclesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IgnitionCycle == roRef.IgnitionCycle);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSysPwrModeUpReg::cfc_spmfi_tclMsgSysPwrModeUpReg()
 {}

tS32 cfc_spmfi_tclMsgSysPwrModeUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSPWRMODEUPREG;
}


cfc_spmfi_tclMsgSysPwrModeUpReg::~cfc_spmfi_tclMsgSysPwrModeUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgSysPwrModeRelUpReg::cfc_spmfi_tclMsgSysPwrModeRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgSysPwrModeRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSPWRMODERELUPREG;
}


cfc_spmfi_tclMsgSysPwrModeRelUpReg::~cfc_spmfi_tclMsgSysPwrModeRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgSysPwrModeGet::cfc_spmfi_tclMsgSysPwrModeGet()
 {}

tS32 cfc_spmfi_tclMsgSysPwrModeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSPWRMODEGET;
}


cfc_spmfi_tclMsgSysPwrModeGet::~cfc_spmfi_tclMsgSysPwrModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSysPwrModeStatus::cfc_spmfi_tclMsgSysPwrModeStatus(const cfc_spmfi_tclMsgSysPwrModeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   SysPwrMode = coRef.SysPwrMode;
}
cfc_spmfi_tclMsgSysPwrModeStatus& cfc_spmfi_tclMsgSysPwrModeStatus::operator=(const cfc_spmfi_tclMsgSysPwrModeStatus& coRef)
{
   if (this == &coRef) return *this;
   SysPwrMode = coRef.SysPwrMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSysPwrModeStatus::cfc_spmfi_tclMsgSysPwrModeStatus()
:SysPwrMode()
 {}

tS32 cfc_spmfi_tclMsgSysPwrModeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSPWRMODESTATUS;
}


cfc_spmfi_tclMsgSysPwrModeStatus::~cfc_spmfi_tclMsgSysPwrModeStatus()
{}

tU32 cfc_spmfi_tclMsgSysPwrModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgSysPwrModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SysPwrMode);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSysPwrModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SysPwrMode);
   return oOut;
}

tBool cfc_spmfi_tclMsgSysPwrModeStatus::operator==(const cfc_spmfi_tclMsgSysPwrModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SysPwrMode == roRef.SysPwrMode);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSysPwrSaveModeGet::cfc_spmfi_tclMsgSysPwrSaveModeGet()
 {}

tS32 cfc_spmfi_tclMsgSysPwrSaveModeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSPWRSAVEMODEGET;
}


cfc_spmfi_tclMsgSysPwrSaveModeGet::~cfc_spmfi_tclMsgSysPwrSaveModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSysPwrSaveModeStatus::cfc_spmfi_tclMsgSysPwrSaveModeStatus(const cfc_spmfi_tclMsgSysPwrSaveModeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   SysPwrSaveMode = coRef.SysPwrSaveMode;
}
cfc_spmfi_tclMsgSysPwrSaveModeStatus& cfc_spmfi_tclMsgSysPwrSaveModeStatus::operator=(const cfc_spmfi_tclMsgSysPwrSaveModeStatus& coRef)
{
   if (this == &coRef) return *this;
   SysPwrSaveMode = coRef.SysPwrSaveMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSysPwrSaveModeStatus::cfc_spmfi_tclMsgSysPwrSaveModeStatus()
:SysPwrSaveMode()
 {}

tS32 cfc_spmfi_tclMsgSysPwrSaveModeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSPWRSAVEMODESTATUS;
}


cfc_spmfi_tclMsgSysPwrSaveModeStatus::~cfc_spmfi_tclMsgSysPwrSaveModeStatus()
{}

tU32 cfc_spmfi_tclMsgSysPwrSaveModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgSysPwrSaveModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SysPwrSaveMode);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSysPwrSaveModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SysPwrSaveMode);
   return oOut;
}

tBool cfc_spmfi_tclMsgSysPwrSaveModeStatus::operator==(const cfc_spmfi_tclMsgSysPwrSaveModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SysPwrSaveMode == roRef.SysPwrSaveMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgRVCStateSet::cfc_spmfi_tclMsgRVCStateSet(const cfc_spmfi_tclMsgRVCStateSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
cfc_spmfi_tclMsgRVCStateSet& cfc_spmfi_tclMsgRVCStateSet::operator=(const cfc_spmfi_tclMsgRVCStateSet& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgRVCStateSet::cfc_spmfi_tclMsgRVCStateSet()
:State(0)
 {}

tS32 cfc_spmfi_tclMsgRVCStateSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RVCSTATESET;
}


cfc_spmfi_tclMsgRVCStateSet::~cfc_spmfi_tclMsgRVCStateSet()
{}

tU32 cfc_spmfi_tclMsgRVCStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_spmfi_tclMsgRVCStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgRVCStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool cfc_spmfi_tclMsgRVCStateSet::operator==(const cfc_spmfi_tclMsgRVCStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgRVCStateGet::cfc_spmfi_tclMsgRVCStateGet()
 {}

tS32 cfc_spmfi_tclMsgRVCStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RVCSTATEGET;
}


cfc_spmfi_tclMsgRVCStateGet::~cfc_spmfi_tclMsgRVCStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgRVCStateStatus::cfc_spmfi_tclMsgRVCStateStatus(const cfc_spmfi_tclMsgRVCStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
cfc_spmfi_tclMsgRVCStateStatus& cfc_spmfi_tclMsgRVCStateStatus::operator=(const cfc_spmfi_tclMsgRVCStateStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgRVCStateStatus::cfc_spmfi_tclMsgRVCStateStatus()
:State(0)
 {}

tS32 cfc_spmfi_tclMsgRVCStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RVCSTATESTATUS;
}


cfc_spmfi_tclMsgRVCStateStatus::~cfc_spmfi_tclMsgRVCStateStatus()
{}

tU32 cfc_spmfi_tclMsgRVCStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_spmfi_tclMsgRVCStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgRVCStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool cfc_spmfi_tclMsgRVCStateStatus::operator==(const cfc_spmfi_tclMsgRVCStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgLifesignUpReg::cfc_spmfi_tclMsgLifesignUpReg()
 {}

tS32 cfc_spmfi_tclMsgLifesignUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_LIFESIGNUPREG;
}


cfc_spmfi_tclMsgLifesignUpReg::~cfc_spmfi_tclMsgLifesignUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgLifesignRelUpReg::cfc_spmfi_tclMsgLifesignRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgLifesignRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_LIFESIGNRELUPREG;
}


cfc_spmfi_tclMsgLifesignRelUpReg::~cfc_spmfi_tclMsgLifesignRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgLifesignGet::cfc_spmfi_tclMsgLifesignGet()
 {}

tS32 cfc_spmfi_tclMsgLifesignGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_LIFESIGNGET;
}


cfc_spmfi_tclMsgLifesignGet::~cfc_spmfi_tclMsgLifesignGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgLifesignStatus::cfc_spmfi_tclMsgLifesignStatus(const cfc_spmfi_tclMsgLifesignStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   Lifesign = coRef.Lifesign;
}
cfc_spmfi_tclMsgLifesignStatus& cfc_spmfi_tclMsgLifesignStatus::operator=(const cfc_spmfi_tclMsgLifesignStatus& coRef)
{
   if (this == &coRef) return *this;
   Lifesign = coRef.Lifesign;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgLifesignStatus::cfc_spmfi_tclMsgLifesignStatus()
:Lifesign(0)
 {}

tS32 cfc_spmfi_tclMsgLifesignStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_LIFESIGNSTATUS;
}


cfc_spmfi_tclMsgLifesignStatus::~cfc_spmfi_tclMsgLifesignStatus()
{}

tU32 cfc_spmfi_tclMsgLifesignStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgLifesignStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Lifesign);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgLifesignStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Lifesign);
   return oOut;
}

tBool cfc_spmfi_tclMsgLifesignStatus::operator==(const cfc_spmfi_tclMsgLifesignStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Lifesign == roRef.Lifesign);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgHmiStateUpReg::cfc_spmfi_tclMsgHmiStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgHmiStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_HMISTATEUPREG;
}


cfc_spmfi_tclMsgHmiStateUpReg::~cfc_spmfi_tclMsgHmiStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgHmiStateRelUpReg::cfc_spmfi_tclMsgHmiStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgHmiStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_HMISTATERELUPREG;
}


cfc_spmfi_tclMsgHmiStateRelUpReg::~cfc_spmfi_tclMsgHmiStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgHmiStateGet::cfc_spmfi_tclMsgHmiStateGet()
 {}

tS32 cfc_spmfi_tclMsgHmiStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_HMISTATEGET;
}


cfc_spmfi_tclMsgHmiStateGet::~cfc_spmfi_tclMsgHmiStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgHmiStateStatus::cfc_spmfi_tclMsgHmiStateStatus(const cfc_spmfi_tclMsgHmiStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   HmiState = coRef.HmiState;
}
cfc_spmfi_tclMsgHmiStateStatus& cfc_spmfi_tclMsgHmiStateStatus::operator=(const cfc_spmfi_tclMsgHmiStateStatus& coRef)
{
   if (this == &coRef) return *this;
   HmiState = coRef.HmiState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgHmiStateStatus::cfc_spmfi_tclMsgHmiStateStatus()
:HmiState()
 {}

tS32 cfc_spmfi_tclMsgHmiStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_HMISTATESTATUS;
}


cfc_spmfi_tclMsgHmiStateStatus::~cfc_spmfi_tclMsgHmiStateStatus()
{}

tU32 cfc_spmfi_tclMsgHmiStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgHmiStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> HmiState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgHmiStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << HmiState);
   return oOut;
}

tBool cfc_spmfi_tclMsgHmiStateStatus::operator==(const cfc_spmfi_tclMsgHmiStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (HmiState == roRef.HmiState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSystemPowerBehaviourUpReg::cfc_spmfi_tclMsgSystemPowerBehaviourUpReg()
 {}

tS32 cfc_spmfi_tclMsgSystemPowerBehaviourUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURUPREG;
}


cfc_spmfi_tclMsgSystemPowerBehaviourUpReg::~cfc_spmfi_tclMsgSystemPowerBehaviourUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgSystemPowerBehaviourRelUpReg::cfc_spmfi_tclMsgSystemPowerBehaviourRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgSystemPowerBehaviourRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURRELUPREG;
}


cfc_spmfi_tclMsgSystemPowerBehaviourRelUpReg::~cfc_spmfi_tclMsgSystemPowerBehaviourRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgSystemPowerBehaviourGet::cfc_spmfi_tclMsgSystemPowerBehaviourGet()
 {}

tS32 cfc_spmfi_tclMsgSystemPowerBehaviourGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURGET;
}


cfc_spmfi_tclMsgSystemPowerBehaviourGet::~cfc_spmfi_tclMsgSystemPowerBehaviourGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSystemPowerBehaviourStatus::cfc_spmfi_tclMsgSystemPowerBehaviourStatus(const cfc_spmfi_tclMsgSystemPowerBehaviourStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   eSystemPowerBehaviour = coRef.eSystemPowerBehaviour;
}
cfc_spmfi_tclMsgSystemPowerBehaviourStatus& cfc_spmfi_tclMsgSystemPowerBehaviourStatus::operator=(const cfc_spmfi_tclMsgSystemPowerBehaviourStatus& coRef)
{
   if (this == &coRef) return *this;
   eSystemPowerBehaviour = coRef.eSystemPowerBehaviour;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSystemPowerBehaviourStatus::cfc_spmfi_tclMsgSystemPowerBehaviourStatus()
:eSystemPowerBehaviour()
 {}

tS32 cfc_spmfi_tclMsgSystemPowerBehaviourStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURSTATUS;
}


cfc_spmfi_tclMsgSystemPowerBehaviourStatus::~cfc_spmfi_tclMsgSystemPowerBehaviourStatus()
{}

tU32 cfc_spmfi_tclMsgSystemPowerBehaviourStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgSystemPowerBehaviourStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eSystemPowerBehaviour);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSystemPowerBehaviourStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eSystemPowerBehaviour);
   return oOut;
}

tBool cfc_spmfi_tclMsgSystemPowerBehaviourStatus::operator==(const cfc_spmfi_tclMsgSystemPowerBehaviourStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eSystemPowerBehaviour == roRef.eSystemPowerBehaviour);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgEntertainMuteUpReg::cfc_spmfi_tclMsgEntertainMuteUpReg()
 {}

tS32 cfc_spmfi_tclMsgEntertainMuteUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ENTERTAINMUTEUPREG;
}


cfc_spmfi_tclMsgEntertainMuteUpReg::~cfc_spmfi_tclMsgEntertainMuteUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgEntertainMuteRelUpReg::cfc_spmfi_tclMsgEntertainMuteRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgEntertainMuteRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ENTERTAINMUTERELUPREG;
}


cfc_spmfi_tclMsgEntertainMuteRelUpReg::~cfc_spmfi_tclMsgEntertainMuteRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgEntertainMuteGet::cfc_spmfi_tclMsgEntertainMuteGet()
 {}

tS32 cfc_spmfi_tclMsgEntertainMuteGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ENTERTAINMUTEGET;
}


cfc_spmfi_tclMsgEntertainMuteGet::~cfc_spmfi_tclMsgEntertainMuteGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgEntertainMuteStatus::cfc_spmfi_tclMsgEntertainMuteStatus(const cfc_spmfi_tclMsgEntertainMuteStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   bMuteState = coRef.bMuteState;
}
cfc_spmfi_tclMsgEntertainMuteStatus& cfc_spmfi_tclMsgEntertainMuteStatus::operator=(const cfc_spmfi_tclMsgEntertainMuteStatus& coRef)
{
   if (this == &coRef) return *this;
   bMuteState = coRef.bMuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgEntertainMuteStatus::cfc_spmfi_tclMsgEntertainMuteStatus()
:bMuteState(0)
 {}

tS32 cfc_spmfi_tclMsgEntertainMuteStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ENTERTAINMUTESTATUS;
}


cfc_spmfi_tclMsgEntertainMuteStatus::~cfc_spmfi_tclMsgEntertainMuteStatus()
{}

tU32 cfc_spmfi_tclMsgEntertainMuteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_spmfi_tclMsgEntertainMuteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bMuteState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgEntertainMuteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bMuteState);
   return oOut;
}

tBool cfc_spmfi_tclMsgEntertainMuteStatus::operator==(const cfc_spmfi_tclMsgEntertainMuteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bMuteState == roRef.bMuteState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgPhoneHandoverWarnTimeUpReg::cfc_spmfi_tclMsgPhoneHandoverWarnTimeUpReg()
 {}

tS32 cfc_spmfi_tclMsgPhoneHandoverWarnTimeUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMEUPREG;
}


cfc_spmfi_tclMsgPhoneHandoverWarnTimeUpReg::~cfc_spmfi_tclMsgPhoneHandoverWarnTimeUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgPhoneHandoverWarnTimeRelUpReg::cfc_spmfi_tclMsgPhoneHandoverWarnTimeRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgPhoneHandoverWarnTimeRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMERELUPREG;
}


cfc_spmfi_tclMsgPhoneHandoverWarnTimeRelUpReg::~cfc_spmfi_tclMsgPhoneHandoverWarnTimeRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgPhoneHandoverWarnTimeGet::cfc_spmfi_tclMsgPhoneHandoverWarnTimeGet()
 {}

tS32 cfc_spmfi_tclMsgPhoneHandoverWarnTimeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMEGET;
}


cfc_spmfi_tclMsgPhoneHandoverWarnTimeGet::~cfc_spmfi_tclMsgPhoneHandoverWarnTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet::cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   u32Time = coRef.u32Time;
}
cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet& cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet::operator=(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet& coRef)
{
   if (this == &coRef) return *this;
   u32Time = coRef.u32Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet::cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet()
:u32Time(0)
 {}

tS32 cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMESET;
}


cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet::~cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet()
{}

tU32 cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Time);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Time);
   return oOut;
}

tBool cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet::operator==(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Time == roRef.u32Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus::cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   u32Time = coRef.u32Time;
}
cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus& cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus::operator=(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32Time = coRef.u32Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus::cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus()
:u32Time(0)
 {}

tS32 cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMESTATUS;
}


cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus::~cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus()
{}

tU32 cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Time);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Time);
   return oOut;
}

tBool cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus::operator==(const cfc_spmfi_tclMsgPhoneHandoverWarnTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Time == roRef.u32Time);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgDimStateUpReg::cfc_spmfi_tclMsgDimStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgDimStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DIMSTATEUPREG;
}


cfc_spmfi_tclMsgDimStateUpReg::~cfc_spmfi_tclMsgDimStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgDimStateRelUpReg::cfc_spmfi_tclMsgDimStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgDimStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DIMSTATERELUPREG;
}


cfc_spmfi_tclMsgDimStateRelUpReg::~cfc_spmfi_tclMsgDimStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgDimStateGet::cfc_spmfi_tclMsgDimStateGet()
 {}

tS32 cfc_spmfi_tclMsgDimStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DIMSTATEGET;
}


cfc_spmfi_tclMsgDimStateGet::~cfc_spmfi_tclMsgDimStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgDimStateStatus::cfc_spmfi_tclMsgDimStateStatus(const cfc_spmfi_tclMsgDimStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DimState = coRef.DimState;
}
cfc_spmfi_tclMsgDimStateStatus& cfc_spmfi_tclMsgDimStateStatus::operator=(const cfc_spmfi_tclMsgDimStateStatus& coRef)
{
   if (this == &coRef) return *this;
   DimState = coRef.DimState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgDimStateStatus::cfc_spmfi_tclMsgDimStateStatus()
:DimState()
 {}

tS32 cfc_spmfi_tclMsgDimStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DIMSTATESTATUS;
}


cfc_spmfi_tclMsgDimStateStatus::~cfc_spmfi_tclMsgDimStateStatus()
{}

tU32 cfc_spmfi_tclMsgDimStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgDimStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgDimStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimState);
   return oOut;
}

tBool cfc_spmfi_tclMsgDimStateStatus::operator==(const cfc_spmfi_tclMsgDimStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimState == roRef.DimState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgDimmingStateUpReg::cfc_spmfi_tclMsgDimmingStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgDimmingStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DIMMINGSTATEUPREG;
}


cfc_spmfi_tclMsgDimmingStateUpReg::~cfc_spmfi_tclMsgDimmingStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgDimmingStateRelUpReg::cfc_spmfi_tclMsgDimmingStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgDimmingStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DIMMINGSTATERELUPREG;
}


cfc_spmfi_tclMsgDimmingStateRelUpReg::~cfc_spmfi_tclMsgDimmingStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgDimmingStateGet::cfc_spmfi_tclMsgDimmingStateGet()
 {}

tS32 cfc_spmfi_tclMsgDimmingStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DIMMINGSTATEGET;
}


cfc_spmfi_tclMsgDimmingStateGet::~cfc_spmfi_tclMsgDimmingStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgDimmingStateStatus::cfc_spmfi_tclMsgDimmingStateStatus(const cfc_spmfi_tclMsgDimmingStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DimState = coRef.DimState;
}
cfc_spmfi_tclMsgDimmingStateStatus& cfc_spmfi_tclMsgDimmingStateStatus::operator=(const cfc_spmfi_tclMsgDimmingStateStatus& coRef)
{
   if (this == &coRef) return *this;
   DimState = coRef.DimState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgDimmingStateStatus::cfc_spmfi_tclMsgDimmingStateStatus()
:DimState()
 {}

tS32 cfc_spmfi_tclMsgDimmingStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DIMMINGSTATESTATUS;
}


cfc_spmfi_tclMsgDimmingStateStatus::~cfc_spmfi_tclMsgDimmingStateStatus()
{}

tU32 cfc_spmfi_tclMsgDimmingStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgDimmingStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgDimmingStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimState);
   return oOut;
}

tBool cfc_spmfi_tclMsgDimmingStateStatus::operator==(const cfc_spmfi_tclMsgDimmingStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimState == roRef.DimState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgMmgrStateUpReg::cfc_spmfi_tclMsgMmgrStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgMmgrStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MMGRSTATEUPREG;
}


cfc_spmfi_tclMsgMmgrStateUpReg::~cfc_spmfi_tclMsgMmgrStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgMmgrStateRelUpReg::cfc_spmfi_tclMsgMmgrStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgMmgrStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MMGRSTATERELUPREG;
}


cfc_spmfi_tclMsgMmgrStateRelUpReg::~cfc_spmfi_tclMsgMmgrStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgMmgrStateGet::cfc_spmfi_tclMsgMmgrStateGet()
 {}

tS32 cfc_spmfi_tclMsgMmgrStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MMGRSTATEGET;
}


cfc_spmfi_tclMsgMmgrStateGet::~cfc_spmfi_tclMsgMmgrStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgMmgrStateStatus::cfc_spmfi_tclMsgMmgrStateStatus(const cfc_spmfi_tclMsgMmgrStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   MmgrState = coRef.MmgrState;
}
cfc_spmfi_tclMsgMmgrStateStatus& cfc_spmfi_tclMsgMmgrStateStatus::operator=(const cfc_spmfi_tclMsgMmgrStateStatus& coRef)
{
   if (this == &coRef) return *this;
   MmgrState = coRef.MmgrState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgMmgrStateStatus::cfc_spmfi_tclMsgMmgrStateStatus()
:MmgrState()
 {}

tS32 cfc_spmfi_tclMsgMmgrStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MMGRSTATESTATUS;
}


cfc_spmfi_tclMsgMmgrStateStatus::~cfc_spmfi_tclMsgMmgrStateStatus()
{}

tU32 cfc_spmfi_tclMsgMmgrStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgMmgrStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MmgrState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgMmgrStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MmgrState);
   return oOut;
}

tBool cfc_spmfi_tclMsgMmgrStateStatus::operator==(const cfc_spmfi_tclMsgMmgrStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MmgrState == roRef.MmgrState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgAudioStateUpReg::cfc_spmfi_tclMsgAudioStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgAudioStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_AUDIOSTATEUPREG;
}


cfc_spmfi_tclMsgAudioStateUpReg::~cfc_spmfi_tclMsgAudioStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgAudioStateRelUpReg::cfc_spmfi_tclMsgAudioStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgAudioStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_AUDIOSTATERELUPREG;
}


cfc_spmfi_tclMsgAudioStateRelUpReg::~cfc_spmfi_tclMsgAudioStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgAudioStateGet::cfc_spmfi_tclMsgAudioStateGet()
 {}

tS32 cfc_spmfi_tclMsgAudioStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_AUDIOSTATEGET;
}


cfc_spmfi_tclMsgAudioStateGet::~cfc_spmfi_tclMsgAudioStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgAudioStateStatus::cfc_spmfi_tclMsgAudioStateStatus(const cfc_spmfi_tclMsgAudioStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   AudioState = coRef.AudioState;
}
cfc_spmfi_tclMsgAudioStateStatus& cfc_spmfi_tclMsgAudioStateStatus::operator=(const cfc_spmfi_tclMsgAudioStateStatus& coRef)
{
   if (this == &coRef) return *this;
   AudioState = coRef.AudioState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgAudioStateStatus::cfc_spmfi_tclMsgAudioStateStatus()
:AudioState()
 {}

tS32 cfc_spmfi_tclMsgAudioStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_AUDIOSTATESTATUS;
}


cfc_spmfi_tclMsgAudioStateStatus::~cfc_spmfi_tclMsgAudioStateStatus()
{}

tU32 cfc_spmfi_tclMsgAudioStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgAudioStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudioState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgAudioStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudioState);
   return oOut;
}

tBool cfc_spmfi_tclMsgAudioStateStatus::operator==(const cfc_spmfi_tclMsgAudioStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudioState == roRef.AudioState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSysStateUpReg::cfc_spmfi_tclMsgSysStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgSysStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSSTATEUPREG;
}


cfc_spmfi_tclMsgSysStateUpReg::~cfc_spmfi_tclMsgSysStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgSysStateRelUpReg::cfc_spmfi_tclMsgSysStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgSysStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSSTATERELUPREG;
}


cfc_spmfi_tclMsgSysStateRelUpReg::~cfc_spmfi_tclMsgSysStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgSysStateGet::cfc_spmfi_tclMsgSysStateGet()
 {}

tS32 cfc_spmfi_tclMsgSysStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSSTATEGET;
}


cfc_spmfi_tclMsgSysStateGet::~cfc_spmfi_tclMsgSysStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSysStateStatus::cfc_spmfi_tclMsgSysStateStatus(const cfc_spmfi_tclMsgSysStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   SysState = coRef.SysState;
}
cfc_spmfi_tclMsgSysStateStatus& cfc_spmfi_tclMsgSysStateStatus::operator=(const cfc_spmfi_tclMsgSysStateStatus& coRef)
{
   if (this == &coRef) return *this;
   SysState = coRef.SysState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSysStateStatus::cfc_spmfi_tclMsgSysStateStatus()
:SysState()
 {}

tS32 cfc_spmfi_tclMsgSysStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSSTATESTATUS;
}


cfc_spmfi_tclMsgSysStateStatus::~cfc_spmfi_tclMsgSysStateStatus()
{}

tU32 cfc_spmfi_tclMsgSysStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgSysStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SysState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSysStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SysState);
   return oOut;
}

tBool cfc_spmfi_tclMsgSysStateStatus::operator==(const cfc_spmfi_tclMsgSysStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SysState == roRef.SysState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgMostStateUpReg::cfc_spmfi_tclMsgMostStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgMostStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MOSTSTATEUPREG;
}


cfc_spmfi_tclMsgMostStateUpReg::~cfc_spmfi_tclMsgMostStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgMostStateRelUpReg::cfc_spmfi_tclMsgMostStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgMostStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MOSTSTATERELUPREG;
}


cfc_spmfi_tclMsgMostStateRelUpReg::~cfc_spmfi_tclMsgMostStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgMostStateGet::cfc_spmfi_tclMsgMostStateGet()
 {}

tS32 cfc_spmfi_tclMsgMostStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MOSTSTATEGET;
}


cfc_spmfi_tclMsgMostStateGet::~cfc_spmfi_tclMsgMostStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgMostStateStatus::cfc_spmfi_tclMsgMostStateStatus(const cfc_spmfi_tclMsgMostStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   MostEvent = coRef.MostEvent;
   MostConfigurationState = coRef.MostConfigurationState;
   FirstReceiveTime = coRef.FirstReceiveTime;
   TLAState = coRef.TLAState;
   OvertemperatureMostOff = coRef.OvertemperatureMostOff;
}
cfc_spmfi_tclMsgMostStateStatus& cfc_spmfi_tclMsgMostStateStatus::operator=(const cfc_spmfi_tclMsgMostStateStatus& coRef)
{
   if (this == &coRef) return *this;
   MostEvent = coRef.MostEvent;
   MostConfigurationState = coRef.MostConfigurationState;
   FirstReceiveTime = coRef.FirstReceiveTime;
   TLAState = coRef.TLAState;
   OvertemperatureMostOff = coRef.OvertemperatureMostOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgMostStateStatus::cfc_spmfi_tclMsgMostStateStatus()
:MostEvent()
,MostConfigurationState()
,FirstReceiveTime(0)
,TLAState()
,OvertemperatureMostOff(0)
 {}

tS32 cfc_spmfi_tclMsgMostStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MOSTSTATESTATUS;
}


cfc_spmfi_tclMsgMostStateStatus::~cfc_spmfi_tclMsgMostStateStatus()
{}

tU32 cfc_spmfi_tclMsgMostStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& cfc_spmfi_tclMsgMostStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MostEvent);
   (tVoid) (oIn >> MostConfigurationState);
   (tVoid) (oIn >> FirstReceiveTime);
   (tVoid) (oIn >> TLAState);
   (tVoid) (oIn >> OvertemperatureMostOff);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgMostStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MostEvent);
   (tVoid) (oOut << MostConfigurationState);
   (tVoid) (oOut << FirstReceiveTime);
   (tVoid) (oOut << TLAState);
   (tVoid) (oOut << OvertemperatureMostOff);
   return oOut;
}

tBool cfc_spmfi_tclMsgMostStateStatus::operator==(const cfc_spmfi_tclMsgMostStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MostEvent == roRef.MostEvent);
   bResult = bResult && (MostConfigurationState == roRef.MostConfigurationState);
   bResult = bResult && (FirstReceiveTime == roRef.FirstReceiveTime);
   bResult = bResult && (TLAState == roRef.TLAState);
   bResult = bResult && (OvertemperatureMostOff == roRef.OvertemperatureMostOff);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgMostVersionGet::cfc_spmfi_tclMsgMostVersionGet()
 {}

tS32 cfc_spmfi_tclMsgMostVersionGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MOSTVERSIONGET;
}


cfc_spmfi_tclMsgMostVersionGet::~cfc_spmfi_tclMsgMostVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgMostVersionStatus::cfc_spmfi_tclMsgMostVersionStatus(const cfc_spmfi_tclMsgMostVersionStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   MostVersion = coRef.MostVersion;
}
cfc_spmfi_tclMsgMostVersionStatus& cfc_spmfi_tclMsgMostVersionStatus::operator=(const cfc_spmfi_tclMsgMostVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   MostVersion = coRef.MostVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgMostVersionStatus::vDestroy()
{
   MostVersion.vDestroy();
}

cfc_spmfi_tclMsgMostVersionStatus::cfc_spmfi_tclMsgMostVersionStatus()
:MostVersion()
 {}

tS32 cfc_spmfi_tclMsgMostVersionStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MOSTVERSIONSTATUS;
}


cfc_spmfi_tclMsgMostVersionStatus::~cfc_spmfi_tclMsgMostVersionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgMostVersionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+MostVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cfc_spmfi_tclMsgMostVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MostVersion);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgMostVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MostVersion);
   return oOut;
}

tBool cfc_spmfi_tclMsgMostVersionStatus::operator==(const cfc_spmfi_tclMsgMostVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MostVersion == roRef.MostVersion);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgStandbyTimeGet::cfc_spmfi_tclMsgStandbyTimeGet()
 {}

tS32 cfc_spmfi_tclMsgStandbyTimeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STANDBYTIMEGET;
}


cfc_spmfi_tclMsgStandbyTimeGet::~cfc_spmfi_tclMsgStandbyTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgStandbyTimeSet::cfc_spmfi_tclMsgStandbyTimeSet(const cfc_spmfi_tclMsgStandbyTimeSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   StandbyTime = coRef.StandbyTime;
}
cfc_spmfi_tclMsgStandbyTimeSet& cfc_spmfi_tclMsgStandbyTimeSet::operator=(const cfc_spmfi_tclMsgStandbyTimeSet& coRef)
{
   if (this == &coRef) return *this;
   StandbyTime = coRef.StandbyTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgStandbyTimeSet::cfc_spmfi_tclMsgStandbyTimeSet()
:StandbyTime(0)
 {}

tS32 cfc_spmfi_tclMsgStandbyTimeSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STANDBYTIMESET;
}


cfc_spmfi_tclMsgStandbyTimeSet::~cfc_spmfi_tclMsgStandbyTimeSet()
{}

tU32 cfc_spmfi_tclMsgStandbyTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgStandbyTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StandbyTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgStandbyTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StandbyTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgStandbyTimeSet::operator==(const cfc_spmfi_tclMsgStandbyTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StandbyTime == roRef.StandbyTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgStandbyTimeStatus::cfc_spmfi_tclMsgStandbyTimeStatus(const cfc_spmfi_tclMsgStandbyTimeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   StandbyTime = coRef.StandbyTime;
}
cfc_spmfi_tclMsgStandbyTimeStatus& cfc_spmfi_tclMsgStandbyTimeStatus::operator=(const cfc_spmfi_tclMsgStandbyTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   StandbyTime = coRef.StandbyTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgStandbyTimeStatus::cfc_spmfi_tclMsgStandbyTimeStatus()
:StandbyTime(0)
 {}

tS32 cfc_spmfi_tclMsgStandbyTimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STANDBYTIMESTATUS;
}


cfc_spmfi_tclMsgStandbyTimeStatus::~cfc_spmfi_tclMsgStandbyTimeStatus()
{}

tU32 cfc_spmfi_tclMsgStandbyTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgStandbyTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StandbyTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgStandbyTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StandbyTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgStandbyTimeStatus::operator==(const cfc_spmfi_tclMsgStandbyTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StandbyTime == roRef.StandbyTime);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgPersitentStandbyTimeGet::cfc_spmfi_tclMsgPersitentStandbyTimeGet()
 {}

tS32 cfc_spmfi_tclMsgPersitentStandbyTimeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PERSITENTSTANDBYTIMEGET;
}


cfc_spmfi_tclMsgPersitentStandbyTimeGet::~cfc_spmfi_tclMsgPersitentStandbyTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgPersitentStandbyTimeSet::cfc_spmfi_tclMsgPersitentStandbyTimeSet(const cfc_spmfi_tclMsgPersitentStandbyTimeSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   PersitentStandbyTime = coRef.PersitentStandbyTime;
}
cfc_spmfi_tclMsgPersitentStandbyTimeSet& cfc_spmfi_tclMsgPersitentStandbyTimeSet::operator=(const cfc_spmfi_tclMsgPersitentStandbyTimeSet& coRef)
{
   if (this == &coRef) return *this;
   PersitentStandbyTime = coRef.PersitentStandbyTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgPersitentStandbyTimeSet::cfc_spmfi_tclMsgPersitentStandbyTimeSet()
:PersitentStandbyTime(0)
 {}

tS32 cfc_spmfi_tclMsgPersitentStandbyTimeSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PERSITENTSTANDBYTIMESET;
}


cfc_spmfi_tclMsgPersitentStandbyTimeSet::~cfc_spmfi_tclMsgPersitentStandbyTimeSet()
{}

tU32 cfc_spmfi_tclMsgPersitentStandbyTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgPersitentStandbyTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PersitentStandbyTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgPersitentStandbyTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PersitentStandbyTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgPersitentStandbyTimeSet::operator==(const cfc_spmfi_tclMsgPersitentStandbyTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PersitentStandbyTime == roRef.PersitentStandbyTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgPersitentStandbyTimeStatus::cfc_spmfi_tclMsgPersitentStandbyTimeStatus(const cfc_spmfi_tclMsgPersitentStandbyTimeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   PersitentStandbyTime = coRef.PersitentStandbyTime;
}
cfc_spmfi_tclMsgPersitentStandbyTimeStatus& cfc_spmfi_tclMsgPersitentStandbyTimeStatus::operator=(const cfc_spmfi_tclMsgPersitentStandbyTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   PersitentStandbyTime = coRef.PersitentStandbyTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgPersitentStandbyTimeStatus::cfc_spmfi_tclMsgPersitentStandbyTimeStatus()
:PersitentStandbyTime(0)
 {}

tS32 cfc_spmfi_tclMsgPersitentStandbyTimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PERSITENTSTANDBYTIMESTATUS;
}


cfc_spmfi_tclMsgPersitentStandbyTimeStatus::~cfc_spmfi_tclMsgPersitentStandbyTimeStatus()
{}

tU32 cfc_spmfi_tclMsgPersitentStandbyTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgPersitentStandbyTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PersitentStandbyTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgPersitentStandbyTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PersitentStandbyTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgPersitentStandbyTimeStatus::operator==(const cfc_spmfi_tclMsgPersitentStandbyTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PersitentStandbyTime == roRef.PersitentStandbyTime);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSuspendTimeGet::cfc_spmfi_tclMsgSuspendTimeGet()
 {}

tS32 cfc_spmfi_tclMsgSuspendTimeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SUSPENDTIMEGET;
}


cfc_spmfi_tclMsgSuspendTimeGet::~cfc_spmfi_tclMsgSuspendTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSuspendTimeSet::cfc_spmfi_tclMsgSuspendTimeSet(const cfc_spmfi_tclMsgSuspendTimeSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   SuspendTime = coRef.SuspendTime;
}
cfc_spmfi_tclMsgSuspendTimeSet& cfc_spmfi_tclMsgSuspendTimeSet::operator=(const cfc_spmfi_tclMsgSuspendTimeSet& coRef)
{
   if (this == &coRef) return *this;
   SuspendTime = coRef.SuspendTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSuspendTimeSet::cfc_spmfi_tclMsgSuspendTimeSet()
:SuspendTime(0)
 {}

tS32 cfc_spmfi_tclMsgSuspendTimeSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SUSPENDTIMESET;
}


cfc_spmfi_tclMsgSuspendTimeSet::~cfc_spmfi_tclMsgSuspendTimeSet()
{}

tU32 cfc_spmfi_tclMsgSuspendTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgSuspendTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SuspendTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSuspendTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SuspendTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgSuspendTimeSet::operator==(const cfc_spmfi_tclMsgSuspendTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SuspendTime == roRef.SuspendTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSuspendTimeStatus::cfc_spmfi_tclMsgSuspendTimeStatus(const cfc_spmfi_tclMsgSuspendTimeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   SuspendTime = coRef.SuspendTime;
}
cfc_spmfi_tclMsgSuspendTimeStatus& cfc_spmfi_tclMsgSuspendTimeStatus::operator=(const cfc_spmfi_tclMsgSuspendTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   SuspendTime = coRef.SuspendTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSuspendTimeStatus::cfc_spmfi_tclMsgSuspendTimeStatus()
:SuspendTime(0)
 {}

tS32 cfc_spmfi_tclMsgSuspendTimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SUSPENDTIMESTATUS;
}


cfc_spmfi_tclMsgSuspendTimeStatus::~cfc_spmfi_tclMsgSuspendTimeStatus()
{}

tU32 cfc_spmfi_tclMsgSuspendTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgSuspendTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SuspendTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSuspendTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SuspendTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgSuspendTimeStatus::operator==(const cfc_spmfi_tclMsgSuspendTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SuspendTime == roRef.SuspendTime);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgIgnitionOffTimeGet::cfc_spmfi_tclMsgIgnitionOffTimeGet()
 {}

tS32 cfc_spmfi_tclMsgIgnitionOffTimeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_IGNITIONOFFTIMEGET;
}


cfc_spmfi_tclMsgIgnitionOffTimeGet::~cfc_spmfi_tclMsgIgnitionOffTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgIgnitionOffTimeSet::cfc_spmfi_tclMsgIgnitionOffTimeSet(const cfc_spmfi_tclMsgIgnitionOffTimeSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   IgnitionOffTime = coRef.IgnitionOffTime;
}
cfc_spmfi_tclMsgIgnitionOffTimeSet& cfc_spmfi_tclMsgIgnitionOffTimeSet::operator=(const cfc_spmfi_tclMsgIgnitionOffTimeSet& coRef)
{
   if (this == &coRef) return *this;
   IgnitionOffTime = coRef.IgnitionOffTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgIgnitionOffTimeSet::cfc_spmfi_tclMsgIgnitionOffTimeSet()
:IgnitionOffTime(0)
 {}

tS32 cfc_spmfi_tclMsgIgnitionOffTimeSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_IGNITIONOFFTIMESET;
}


cfc_spmfi_tclMsgIgnitionOffTimeSet::~cfc_spmfi_tclMsgIgnitionOffTimeSet()
{}

tU32 cfc_spmfi_tclMsgIgnitionOffTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgIgnitionOffTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IgnitionOffTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgIgnitionOffTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IgnitionOffTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgIgnitionOffTimeSet::operator==(const cfc_spmfi_tclMsgIgnitionOffTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IgnitionOffTime == roRef.IgnitionOffTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgIgnitionOffTimeStatus::cfc_spmfi_tclMsgIgnitionOffTimeStatus(const cfc_spmfi_tclMsgIgnitionOffTimeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   IgnitionOffTime = coRef.IgnitionOffTime;
}
cfc_spmfi_tclMsgIgnitionOffTimeStatus& cfc_spmfi_tclMsgIgnitionOffTimeStatus::operator=(const cfc_spmfi_tclMsgIgnitionOffTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   IgnitionOffTime = coRef.IgnitionOffTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgIgnitionOffTimeStatus::cfc_spmfi_tclMsgIgnitionOffTimeStatus()
:IgnitionOffTime(0)
 {}

tS32 cfc_spmfi_tclMsgIgnitionOffTimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_IGNITIONOFFTIMESTATUS;
}


cfc_spmfi_tclMsgIgnitionOffTimeStatus::~cfc_spmfi_tclMsgIgnitionOffTimeStatus()
{}

tU32 cfc_spmfi_tclMsgIgnitionOffTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgIgnitionOffTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IgnitionOffTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgIgnitionOffTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IgnitionOffTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgIgnitionOffTimeStatus::operator==(const cfc_spmfi_tclMsgIgnitionOffTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IgnitionOffTime == roRef.IgnitionOffTime);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgDoorOpenTimeGet::cfc_spmfi_tclMsgDoorOpenTimeGet()
 {}

tS32 cfc_spmfi_tclMsgDoorOpenTimeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DOOROPENTIMEGET;
}


cfc_spmfi_tclMsgDoorOpenTimeGet::~cfc_spmfi_tclMsgDoorOpenTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgDoorOpenTimeSet::cfc_spmfi_tclMsgDoorOpenTimeSet(const cfc_spmfi_tclMsgDoorOpenTimeSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DoorOpenTime = coRef.DoorOpenTime;
}
cfc_spmfi_tclMsgDoorOpenTimeSet& cfc_spmfi_tclMsgDoorOpenTimeSet::operator=(const cfc_spmfi_tclMsgDoorOpenTimeSet& coRef)
{
   if (this == &coRef) return *this;
   DoorOpenTime = coRef.DoorOpenTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgDoorOpenTimeSet::cfc_spmfi_tclMsgDoorOpenTimeSet()
:DoorOpenTime(0)
 {}

tS32 cfc_spmfi_tclMsgDoorOpenTimeSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DOOROPENTIMESET;
}


cfc_spmfi_tclMsgDoorOpenTimeSet::~cfc_spmfi_tclMsgDoorOpenTimeSet()
{}

tU32 cfc_spmfi_tclMsgDoorOpenTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgDoorOpenTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DoorOpenTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgDoorOpenTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DoorOpenTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgDoorOpenTimeSet::operator==(const cfc_spmfi_tclMsgDoorOpenTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DoorOpenTime == roRef.DoorOpenTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgDoorOpenTimeStatus::cfc_spmfi_tclMsgDoorOpenTimeStatus(const cfc_spmfi_tclMsgDoorOpenTimeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DoorOpenTime = coRef.DoorOpenTime;
}
cfc_spmfi_tclMsgDoorOpenTimeStatus& cfc_spmfi_tclMsgDoorOpenTimeStatus::operator=(const cfc_spmfi_tclMsgDoorOpenTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   DoorOpenTime = coRef.DoorOpenTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgDoorOpenTimeStatus::cfc_spmfi_tclMsgDoorOpenTimeStatus()
:DoorOpenTime(0)
 {}

tS32 cfc_spmfi_tclMsgDoorOpenTimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DOOROPENTIMESTATUS;
}


cfc_spmfi_tclMsgDoorOpenTimeStatus::~cfc_spmfi_tclMsgDoorOpenTimeStatus()
{}

tU32 cfc_spmfi_tclMsgDoorOpenTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgDoorOpenTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DoorOpenTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgDoorOpenTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DoorOpenTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgDoorOpenTimeStatus::operator==(const cfc_spmfi_tclMsgDoorOpenTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DoorOpenTime == roRef.DoorOpenTime);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgClockDisplayTimeGet::cfc_spmfi_tclMsgClockDisplayTimeGet()
 {}

tS32 cfc_spmfi_tclMsgClockDisplayTimeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CLOCKDISPLAYTIMEGET;
}


cfc_spmfi_tclMsgClockDisplayTimeGet::~cfc_spmfi_tclMsgClockDisplayTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgClockDisplayTimeSet::cfc_spmfi_tclMsgClockDisplayTimeSet(const cfc_spmfi_tclMsgClockDisplayTimeSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   ClockDisplayTime = coRef.ClockDisplayTime;
}
cfc_spmfi_tclMsgClockDisplayTimeSet& cfc_spmfi_tclMsgClockDisplayTimeSet::operator=(const cfc_spmfi_tclMsgClockDisplayTimeSet& coRef)
{
   if (this == &coRef) return *this;
   ClockDisplayTime = coRef.ClockDisplayTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgClockDisplayTimeSet::cfc_spmfi_tclMsgClockDisplayTimeSet()
:ClockDisplayTime(0)
 {}

tS32 cfc_spmfi_tclMsgClockDisplayTimeSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CLOCKDISPLAYTIMESET;
}


cfc_spmfi_tclMsgClockDisplayTimeSet::~cfc_spmfi_tclMsgClockDisplayTimeSet()
{}

tU32 cfc_spmfi_tclMsgClockDisplayTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgClockDisplayTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ClockDisplayTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgClockDisplayTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ClockDisplayTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgClockDisplayTimeSet::operator==(const cfc_spmfi_tclMsgClockDisplayTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ClockDisplayTime == roRef.ClockDisplayTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgClockDisplayTimeStatus::cfc_spmfi_tclMsgClockDisplayTimeStatus(const cfc_spmfi_tclMsgClockDisplayTimeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   ClockDisplayTime = coRef.ClockDisplayTime;
}
cfc_spmfi_tclMsgClockDisplayTimeStatus& cfc_spmfi_tclMsgClockDisplayTimeStatus::operator=(const cfc_spmfi_tclMsgClockDisplayTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   ClockDisplayTime = coRef.ClockDisplayTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgClockDisplayTimeStatus::cfc_spmfi_tclMsgClockDisplayTimeStatus()
:ClockDisplayTime(0)
 {}

tS32 cfc_spmfi_tclMsgClockDisplayTimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CLOCKDISPLAYTIMESTATUS;
}


cfc_spmfi_tclMsgClockDisplayTimeStatus::~cfc_spmfi_tclMsgClockDisplayTimeStatus()
{}

tU32 cfc_spmfi_tclMsgClockDisplayTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgClockDisplayTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ClockDisplayTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgClockDisplayTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ClockDisplayTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgClockDisplayTimeStatus::operator==(const cfc_spmfi_tclMsgClockDisplayTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ClockDisplayTime == roRef.ClockDisplayTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSystemStateTimeGet::cfc_spmfi_tclMsgSystemStateTimeGet(const cfc_spmfi_tclMsgSystemStateTimeGet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tSystemState = coRef.tSystemState;
}
cfc_spmfi_tclMsgSystemStateTimeGet& cfc_spmfi_tclMsgSystemStateTimeGet::operator=(const cfc_spmfi_tclMsgSystemStateTimeGet& coRef)
{
   if (this == &coRef) return *this;
   tSystemState = coRef.tSystemState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSystemStateTimeGet::cfc_spmfi_tclMsgSystemStateTimeGet()
:tSystemState()
 {}

tS32 cfc_spmfi_tclMsgSystemStateTimeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATETIMEGET;
}


cfc_spmfi_tclMsgSystemStateTimeGet::~cfc_spmfi_tclMsgSystemStateTimeGet()
{}

tU32 cfc_spmfi_tclMsgSystemStateTimeGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgSystemStateTimeGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSystemState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSystemStateTimeGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSystemState);
   return oOut;
}

tBool cfc_spmfi_tclMsgSystemStateTimeGet::operator==(const cfc_spmfi_tclMsgSystemStateTimeGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSystemState == roRef.tSystemState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSystemStateTimeSet::cfc_spmfi_tclMsgSystemStateTimeSet(const cfc_spmfi_tclMsgSystemStateTimeSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tSystemState = coRef.tSystemState;
   tStateTimerValue = coRef.tStateTimerValue;
}
cfc_spmfi_tclMsgSystemStateTimeSet& cfc_spmfi_tclMsgSystemStateTimeSet::operator=(const cfc_spmfi_tclMsgSystemStateTimeSet& coRef)
{
   if (this == &coRef) return *this;
   tSystemState = coRef.tSystemState;
   tStateTimerValue = coRef.tStateTimerValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSystemStateTimeSet::cfc_spmfi_tclMsgSystemStateTimeSet()
:tSystemState()
,tStateTimerValue(0)
 {}

tS32 cfc_spmfi_tclMsgSystemStateTimeSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATETIMESET;
}


cfc_spmfi_tclMsgSystemStateTimeSet::~cfc_spmfi_tclMsgSystemStateTimeSet()
{}

tU32 cfc_spmfi_tclMsgSystemStateTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cfc_spmfi_tclMsgSystemStateTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSystemState);
   (tVoid) (oIn >> tStateTimerValue);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSystemStateTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSystemState);
   (tVoid) (oOut << tStateTimerValue);
   return oOut;
}

tBool cfc_spmfi_tclMsgSystemStateTimeSet::operator==(const cfc_spmfi_tclMsgSystemStateTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSystemState == roRef.tSystemState);
   bResult = bResult && (tStateTimerValue == roRef.tStateTimerValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSystemStateTimeStatus::cfc_spmfi_tclMsgSystemStateTimeStatus(const cfc_spmfi_tclMsgSystemStateTimeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tSystemState = coRef.tSystemState;
   tStateTimerValue = coRef.tStateTimerValue;
}
cfc_spmfi_tclMsgSystemStateTimeStatus& cfc_spmfi_tclMsgSystemStateTimeStatus::operator=(const cfc_spmfi_tclMsgSystemStateTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   tSystemState = coRef.tSystemState;
   tStateTimerValue = coRef.tStateTimerValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSystemStateTimeStatus::cfc_spmfi_tclMsgSystemStateTimeStatus()
:tSystemState()
,tStateTimerValue(0)
 {}

tS32 cfc_spmfi_tclMsgSystemStateTimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SYSTEMSTATETIMESTATUS;
}


cfc_spmfi_tclMsgSystemStateTimeStatus::~cfc_spmfi_tclMsgSystemStateTimeStatus()
{}

tU32 cfc_spmfi_tclMsgSystemStateTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cfc_spmfi_tclMsgSystemStateTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSystemState);
   (tVoid) (oIn >> tStateTimerValue);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSystemStateTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSystemState);
   (tVoid) (oOut << tStateTimerValue);
   return oOut;
}

tBool cfc_spmfi_tclMsgSystemStateTimeStatus::operator==(const cfc_spmfi_tclMsgSystemStateTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSystemState == roRef.tSystemState);
   bResult = bResult && (tStateTimerValue == roRef.tStateTimerValue);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgFgsStateUpReg::cfc_spmfi_tclMsgFgsStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgFgsStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_FGSSTATEUPREG;
}


cfc_spmfi_tclMsgFgsStateUpReg::~cfc_spmfi_tclMsgFgsStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgFgsStateRelUpReg::cfc_spmfi_tclMsgFgsStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgFgsStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_FGSSTATERELUPREG;
}


cfc_spmfi_tclMsgFgsStateRelUpReg::~cfc_spmfi_tclMsgFgsStateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgFgsStateSet::cfc_spmfi_tclMsgFgsStateSet(const cfc_spmfi_tclMsgFgsStateSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   FgsState = coRef.FgsState;
}
cfc_spmfi_tclMsgFgsStateSet& cfc_spmfi_tclMsgFgsStateSet::operator=(const cfc_spmfi_tclMsgFgsStateSet& coRef)
{
   if (this == &coRef) return *this;
   FgsState = coRef.FgsState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgFgsStateSet::cfc_spmfi_tclMsgFgsStateSet()
:FgsState()
 {}

tS32 cfc_spmfi_tclMsgFgsStateSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_FGSSTATESET;
}


cfc_spmfi_tclMsgFgsStateSet::~cfc_spmfi_tclMsgFgsStateSet()
{}

tU32 cfc_spmfi_tclMsgFgsStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgFgsStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FgsState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgFgsStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FgsState);
   return oOut;
}

tBool cfc_spmfi_tclMsgFgsStateSet::operator==(const cfc_spmfi_tclMsgFgsStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FgsState == roRef.FgsState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgFgsStateGet::cfc_spmfi_tclMsgFgsStateGet()
 {}

tS32 cfc_spmfi_tclMsgFgsStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_FGSSTATEGET;
}


cfc_spmfi_tclMsgFgsStateGet::~cfc_spmfi_tclMsgFgsStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgFgsStateStatus::cfc_spmfi_tclMsgFgsStateStatus(const cfc_spmfi_tclMsgFgsStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   FgsState = coRef.FgsState;
}
cfc_spmfi_tclMsgFgsStateStatus& cfc_spmfi_tclMsgFgsStateStatus::operator=(const cfc_spmfi_tclMsgFgsStateStatus& coRef)
{
   if (this == &coRef) return *this;
   FgsState = coRef.FgsState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgFgsStateStatus::cfc_spmfi_tclMsgFgsStateStatus()
:FgsState()
 {}

tS32 cfc_spmfi_tclMsgFgsStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_FGSSTATESTATUS;
}


cfc_spmfi_tclMsgFgsStateStatus::~cfc_spmfi_tclMsgFgsStateStatus()
{}

tU32 cfc_spmfi_tclMsgFgsStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgFgsStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FgsState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgFgsStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FgsState);
   return oOut;
}

tBool cfc_spmfi_tclMsgFgsStateStatus::operator==(const cfc_spmfi_tclMsgFgsStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FgsState == roRef.FgsState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgCoproStateUpReg::cfc_spmfi_tclMsgCoproStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgCoproStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_COPROSTATEUPREG;
}


cfc_spmfi_tclMsgCoproStateUpReg::~cfc_spmfi_tclMsgCoproStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgCoproStateRelUpReg::cfc_spmfi_tclMsgCoproStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgCoproStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_COPROSTATERELUPREG;
}


cfc_spmfi_tclMsgCoproStateRelUpReg::~cfc_spmfi_tclMsgCoproStateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgCoproStateSet::cfc_spmfi_tclMsgCoproStateSet(const cfc_spmfi_tclMsgCoproStateSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   CoproState = coRef.CoproState;
}
cfc_spmfi_tclMsgCoproStateSet& cfc_spmfi_tclMsgCoproStateSet::operator=(const cfc_spmfi_tclMsgCoproStateSet& coRef)
{
   if (this == &coRef) return *this;
   CoproState = coRef.CoproState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgCoproStateSet::cfc_spmfi_tclMsgCoproStateSet()
:CoproState()
 {}

tS32 cfc_spmfi_tclMsgCoproStateSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_COPROSTATESET;
}


cfc_spmfi_tclMsgCoproStateSet::~cfc_spmfi_tclMsgCoproStateSet()
{}

tU32 cfc_spmfi_tclMsgCoproStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgCoproStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CoproState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgCoproStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CoproState);
   return oOut;
}

tBool cfc_spmfi_tclMsgCoproStateSet::operator==(const cfc_spmfi_tclMsgCoproStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CoproState == roRef.CoproState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgCoproStateGet::cfc_spmfi_tclMsgCoproStateGet()
 {}

tS32 cfc_spmfi_tclMsgCoproStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_COPROSTATEGET;
}


cfc_spmfi_tclMsgCoproStateGet::~cfc_spmfi_tclMsgCoproStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgCoproStateStatus::cfc_spmfi_tclMsgCoproStateStatus(const cfc_spmfi_tclMsgCoproStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   CoproState = coRef.CoproState;
}
cfc_spmfi_tclMsgCoproStateStatus& cfc_spmfi_tclMsgCoproStateStatus::operator=(const cfc_spmfi_tclMsgCoproStateStatus& coRef)
{
   if (this == &coRef) return *this;
   CoproState = coRef.CoproState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgCoproStateStatus::cfc_spmfi_tclMsgCoproStateStatus()
:CoproState()
 {}

tS32 cfc_spmfi_tclMsgCoproStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_COPROSTATESTATUS;
}


cfc_spmfi_tclMsgCoproStateStatus::~cfc_spmfi_tclMsgCoproStateStatus()
{}

tU32 cfc_spmfi_tclMsgCoproStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgCoproStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CoproState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgCoproStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CoproState);
   return oOut;
}

tBool cfc_spmfi_tclMsgCoproStateStatus::operator==(const cfc_spmfi_tclMsgCoproStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CoproState == roRef.CoproState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgDabStateSet::cfc_spmfi_tclMsgDabStateSet(const cfc_spmfi_tclMsgDabStateSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DabState = coRef.DabState;
}
cfc_spmfi_tclMsgDabStateSet& cfc_spmfi_tclMsgDabStateSet::operator=(const cfc_spmfi_tclMsgDabStateSet& coRef)
{
   if (this == &coRef) return *this;
   DabState = coRef.DabState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgDabStateSet::cfc_spmfi_tclMsgDabStateSet()
:DabState()
 {}

tS32 cfc_spmfi_tclMsgDabStateSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DABSTATESET;
}


cfc_spmfi_tclMsgDabStateSet::~cfc_spmfi_tclMsgDabStateSet()
{}

tU32 cfc_spmfi_tclMsgDabStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgDabStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DabState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgDabStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DabState);
   return oOut;
}

tBool cfc_spmfi_tclMsgDabStateSet::operator==(const cfc_spmfi_tclMsgDabStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DabState == roRef.DabState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgDabStateGet::cfc_spmfi_tclMsgDabStateGet()
 {}

tS32 cfc_spmfi_tclMsgDabStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DABSTATEGET;
}


cfc_spmfi_tclMsgDabStateGet::~cfc_spmfi_tclMsgDabStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgDabStateStatus::cfc_spmfi_tclMsgDabStateStatus(const cfc_spmfi_tclMsgDabStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DabState = coRef.DabState;
}
cfc_spmfi_tclMsgDabStateStatus& cfc_spmfi_tclMsgDabStateStatus::operator=(const cfc_spmfi_tclMsgDabStateStatus& coRef)
{
   if (this == &coRef) return *this;
   DabState = coRef.DabState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgDabStateStatus::cfc_spmfi_tclMsgDabStateStatus()
:DabState()
 {}

tS32 cfc_spmfi_tclMsgDabStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DABSTATESTATUS;
}


cfc_spmfi_tclMsgDabStateStatus::~cfc_spmfi_tclMsgDabStateStatus()
{}

tU32 cfc_spmfi_tclMsgDabStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgDabStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DabState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgDabStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DabState);
   return oOut;
}

tBool cfc_spmfi_tclMsgDabStateStatus::operator==(const cfc_spmfi_tclMsgDabStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DabState == roRef.DabState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgEjectStateUpReg::cfc_spmfi_tclMsgEjectStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgEjectStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_EJECTSTATEUPREG;
}


cfc_spmfi_tclMsgEjectStateUpReg::~cfc_spmfi_tclMsgEjectStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgEjectStateRelUpReg::cfc_spmfi_tclMsgEjectStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgEjectStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_EJECTSTATERELUPREG;
}


cfc_spmfi_tclMsgEjectStateRelUpReg::~cfc_spmfi_tclMsgEjectStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgEjectStateGet::cfc_spmfi_tclMsgEjectStateGet()
 {}

tS32 cfc_spmfi_tclMsgEjectStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_EJECTSTATEGET;
}


cfc_spmfi_tclMsgEjectStateGet::~cfc_spmfi_tclMsgEjectStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgEjectStateStatus::cfc_spmfi_tclMsgEjectStateStatus(const cfc_spmfi_tclMsgEjectStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   EjectState = coRef.EjectState;
}
cfc_spmfi_tclMsgEjectStateStatus& cfc_spmfi_tclMsgEjectStateStatus::operator=(const cfc_spmfi_tclMsgEjectStateStatus& coRef)
{
   if (this == &coRef) return *this;
   EjectState = coRef.EjectState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgEjectStateStatus::cfc_spmfi_tclMsgEjectStateStatus()
:EjectState()
 {}

tS32 cfc_spmfi_tclMsgEjectStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_EJECTSTATESTATUS;
}


cfc_spmfi_tclMsgEjectStateStatus::~cfc_spmfi_tclMsgEjectStateStatus()
{}

tU32 cfc_spmfi_tclMsgEjectStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgEjectStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EjectState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgEjectStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EjectState);
   return oOut;
}

tBool cfc_spmfi_tclMsgEjectStateStatus::operator==(const cfc_spmfi_tclMsgEjectStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EjectState == roRef.EjectState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgInsertStateUpReg::cfc_spmfi_tclMsgInsertStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgInsertStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_INSERTSTATEUPREG;
}


cfc_spmfi_tclMsgInsertStateUpReg::~cfc_spmfi_tclMsgInsertStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgInsertStateRelUpReg::cfc_spmfi_tclMsgInsertStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgInsertStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_INSERTSTATERELUPREG;
}


cfc_spmfi_tclMsgInsertStateRelUpReg::~cfc_spmfi_tclMsgInsertStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgInsertStateGet::cfc_spmfi_tclMsgInsertStateGet()
 {}

tS32 cfc_spmfi_tclMsgInsertStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_INSERTSTATEGET;
}


cfc_spmfi_tclMsgInsertStateGet::~cfc_spmfi_tclMsgInsertStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgInsertStateStatus::cfc_spmfi_tclMsgInsertStateStatus(const cfc_spmfi_tclMsgInsertStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   InsertState = coRef.InsertState;
}
cfc_spmfi_tclMsgInsertStateStatus& cfc_spmfi_tclMsgInsertStateStatus::operator=(const cfc_spmfi_tclMsgInsertStateStatus& coRef)
{
   if (this == &coRef) return *this;
   InsertState = coRef.InsertState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgInsertStateStatus::cfc_spmfi_tclMsgInsertStateStatus()
:InsertState()
 {}

tS32 cfc_spmfi_tclMsgInsertStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_INSERTSTATESTATUS;
}


cfc_spmfi_tclMsgInsertStateStatus::~cfc_spmfi_tclMsgInsertStateStatus()
{}

tU32 cfc_spmfi_tclMsgInsertStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgInsertStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> InsertState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgInsertStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << InsertState);
   return oOut;
}

tBool cfc_spmfi_tclMsgInsertStateStatus::operator==(const cfc_spmfi_tclMsgInsertStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (InsertState == roRef.InsertState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgMediaEjectStateUpReg::cfc_spmfi_tclMsgMediaEjectStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgMediaEjectStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MEDIAEJECTSTATEUPREG;
}


cfc_spmfi_tclMsgMediaEjectStateUpReg::~cfc_spmfi_tclMsgMediaEjectStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgMediaEjectStateRelUpReg::cfc_spmfi_tclMsgMediaEjectStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgMediaEjectStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MEDIAEJECTSTATERELUPREG;
}


cfc_spmfi_tclMsgMediaEjectStateRelUpReg::~cfc_spmfi_tclMsgMediaEjectStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgMediaEjectStateGet::cfc_spmfi_tclMsgMediaEjectStateGet()
 {}

tS32 cfc_spmfi_tclMsgMediaEjectStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MEDIAEJECTSTATEGET;
}


cfc_spmfi_tclMsgMediaEjectStateGet::~cfc_spmfi_tclMsgMediaEjectStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgMediaEjectStateStatus::cfc_spmfi_tclMsgMediaEjectStateStatus(const cfc_spmfi_tclMsgMediaEjectStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   MediaEjectState = coRef.MediaEjectState;
}
cfc_spmfi_tclMsgMediaEjectStateStatus& cfc_spmfi_tclMsgMediaEjectStateStatus::operator=(const cfc_spmfi_tclMsgMediaEjectStateStatus& coRef)
{
   if (this == &coRef) return *this;
   MediaEjectState = coRef.MediaEjectState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgMediaEjectStateStatus::cfc_spmfi_tclMsgMediaEjectStateStatus()
:MediaEjectState()
 {}

tS32 cfc_spmfi_tclMsgMediaEjectStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_MEDIAEJECTSTATESTATUS;
}


cfc_spmfi_tclMsgMediaEjectStateStatus::~cfc_spmfi_tclMsgMediaEjectStateStatus()
{}

tU32 cfc_spmfi_tclMsgMediaEjectStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgMediaEjectStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaEjectState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgMediaEjectStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaEjectState);
   return oOut;
}

tBool cfc_spmfi_tclMsgMediaEjectStateStatus::operator==(const cfc_spmfi_tclMsgMediaEjectStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaEjectState == roRef.MediaEjectState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgPhoneMuteStateUpReg::cfc_spmfi_tclMsgPhoneMuteStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgPhoneMuteStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEMUTESTATEUPREG;
}


cfc_spmfi_tclMsgPhoneMuteStateUpReg::~cfc_spmfi_tclMsgPhoneMuteStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgPhoneMuteStateRelUpReg::cfc_spmfi_tclMsgPhoneMuteStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgPhoneMuteStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEMUTESTATERELUPREG;
}


cfc_spmfi_tclMsgPhoneMuteStateRelUpReg::~cfc_spmfi_tclMsgPhoneMuteStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgPhoneMuteStateGet::cfc_spmfi_tclMsgPhoneMuteStateGet()
 {}

tS32 cfc_spmfi_tclMsgPhoneMuteStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEMUTESTATEGET;
}


cfc_spmfi_tclMsgPhoneMuteStateGet::~cfc_spmfi_tclMsgPhoneMuteStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgPhoneMuteStateStatus::cfc_spmfi_tclMsgPhoneMuteStateStatus(const cfc_spmfi_tclMsgPhoneMuteStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   PhoneMuteState = coRef.PhoneMuteState;
}
cfc_spmfi_tclMsgPhoneMuteStateStatus& cfc_spmfi_tclMsgPhoneMuteStateStatus::operator=(const cfc_spmfi_tclMsgPhoneMuteStateStatus& coRef)
{
   if (this == &coRef) return *this;
   PhoneMuteState = coRef.PhoneMuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgPhoneMuteStateStatus::cfc_spmfi_tclMsgPhoneMuteStateStatus()
:PhoneMuteState()
 {}

tS32 cfc_spmfi_tclMsgPhoneMuteStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEMUTESTATESTATUS;
}


cfc_spmfi_tclMsgPhoneMuteStateStatus::~cfc_spmfi_tclMsgPhoneMuteStateStatus()
{}

tU32 cfc_spmfi_tclMsgPhoneMuteStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgPhoneMuteStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneMuteState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgPhoneMuteStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneMuteState);
   return oOut;
}

tBool cfc_spmfi_tclMsgPhoneMuteStateStatus::operator==(const cfc_spmfi_tclMsgPhoneMuteStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneMuteState == roRef.PhoneMuteState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgRmtEnableStateSet::cfc_spmfi_tclMsgRmtEnableStateSet(const cfc_spmfi_tclMsgRmtEnableStateSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   RmtEnableState = coRef.RmtEnableState;
}
cfc_spmfi_tclMsgRmtEnableStateSet& cfc_spmfi_tclMsgRmtEnableStateSet::operator=(const cfc_spmfi_tclMsgRmtEnableStateSet& coRef)
{
   if (this == &coRef) return *this;
   RmtEnableState = coRef.RmtEnableState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgRmtEnableStateSet::cfc_spmfi_tclMsgRmtEnableStateSet()
:RmtEnableState(0)
 {}

tS32 cfc_spmfi_tclMsgRmtEnableStateSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RMTENABLESTATESET;
}


cfc_spmfi_tclMsgRmtEnableStateSet::~cfc_spmfi_tclMsgRmtEnableStateSet()
{}

tU32 cfc_spmfi_tclMsgRmtEnableStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_spmfi_tclMsgRmtEnableStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RmtEnableState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgRmtEnableStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RmtEnableState);
   return oOut;
}

tBool cfc_spmfi_tclMsgRmtEnableStateSet::operator==(const cfc_spmfi_tclMsgRmtEnableStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RmtEnableState == roRef.RmtEnableState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgRmtEnableStateGet::cfc_spmfi_tclMsgRmtEnableStateGet()
 {}

tS32 cfc_spmfi_tclMsgRmtEnableStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RMTENABLESTATEGET;
}


cfc_spmfi_tclMsgRmtEnableStateGet::~cfc_spmfi_tclMsgRmtEnableStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgRmtEnableStateStatus::cfc_spmfi_tclMsgRmtEnableStateStatus(const cfc_spmfi_tclMsgRmtEnableStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   RmtEnableState = coRef.RmtEnableState;
}
cfc_spmfi_tclMsgRmtEnableStateStatus& cfc_spmfi_tclMsgRmtEnableStateStatus::operator=(const cfc_spmfi_tclMsgRmtEnableStateStatus& coRef)
{
   if (this == &coRef) return *this;
   RmtEnableState = coRef.RmtEnableState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgRmtEnableStateStatus::cfc_spmfi_tclMsgRmtEnableStateStatus()
:RmtEnableState(0)
 {}

tS32 cfc_spmfi_tclMsgRmtEnableStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RMTENABLESTATESTATUS;
}


cfc_spmfi_tclMsgRmtEnableStateStatus::~cfc_spmfi_tclMsgRmtEnableStateStatus()
{}

tU32 cfc_spmfi_tclMsgRmtEnableStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_spmfi_tclMsgRmtEnableStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RmtEnableState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgRmtEnableStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RmtEnableState);
   return oOut;
}

tBool cfc_spmfi_tclMsgRmtEnableStateStatus::operator==(const cfc_spmfi_tclMsgRmtEnableStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RmtEnableState == roRef.RmtEnableState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgOnTipperStateUpReg::cfc_spmfi_tclMsgOnTipperStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgOnTipperStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ONTIPPERSTATEUPREG;
}


cfc_spmfi_tclMsgOnTipperStateUpReg::~cfc_spmfi_tclMsgOnTipperStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgOnTipperStateRelUpReg::cfc_spmfi_tclMsgOnTipperStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgOnTipperStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ONTIPPERSTATERELUPREG;
}


cfc_spmfi_tclMsgOnTipperStateRelUpReg::~cfc_spmfi_tclMsgOnTipperStateRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgOnTipperStateGet::cfc_spmfi_tclMsgOnTipperStateGet()
 {}

tS32 cfc_spmfi_tclMsgOnTipperStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ONTIPPERSTATEGET;
}


cfc_spmfi_tclMsgOnTipperStateGet::~cfc_spmfi_tclMsgOnTipperStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgOnTipperStateStatus::cfc_spmfi_tclMsgOnTipperStateStatus(const cfc_spmfi_tclMsgOnTipperStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   OnTipperState = coRef.OnTipperState;
}
cfc_spmfi_tclMsgOnTipperStateStatus& cfc_spmfi_tclMsgOnTipperStateStatus::operator=(const cfc_spmfi_tclMsgOnTipperStateStatus& coRef)
{
   if (this == &coRef) return *this;
   OnTipperState = coRef.OnTipperState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgOnTipperStateStatus::cfc_spmfi_tclMsgOnTipperStateStatus()
:OnTipperState()
 {}

tS32 cfc_spmfi_tclMsgOnTipperStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ONTIPPERSTATESTATUS;
}


cfc_spmfi_tclMsgOnTipperStateStatus::~cfc_spmfi_tclMsgOnTipperStateStatus()
{}

tU32 cfc_spmfi_tclMsgOnTipperStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgOnTipperStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OnTipperState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgOnTipperStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OnTipperState);
   return oOut;
}

tBool cfc_spmfi_tclMsgOnTipperStateStatus::operator==(const cfc_spmfi_tclMsgOnTipperStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OnTipperState == roRef.OnTipperState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgCodeRequestStateUpReg::cfc_spmfi_tclMsgCodeRequestStateUpReg()
 {}

tS32 cfc_spmfi_tclMsgCodeRequestStateUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CODEREQUESTSTATEUPREG;
}


cfc_spmfi_tclMsgCodeRequestStateUpReg::~cfc_spmfi_tclMsgCodeRequestStateUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgCodeRequestStateRelUpReg::cfc_spmfi_tclMsgCodeRequestStateRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgCodeRequestStateRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CODEREQUESTSTATERELUPREG;
}


cfc_spmfi_tclMsgCodeRequestStateRelUpReg::~cfc_spmfi_tclMsgCodeRequestStateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgCodeRequestStateSet::cfc_spmfi_tclMsgCodeRequestStateSet(const cfc_spmfi_tclMsgCodeRequestStateSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   CodeRequestState = coRef.CodeRequestState;
}
cfc_spmfi_tclMsgCodeRequestStateSet& cfc_spmfi_tclMsgCodeRequestStateSet::operator=(const cfc_spmfi_tclMsgCodeRequestStateSet& coRef)
{
   if (this == &coRef) return *this;
   CodeRequestState = coRef.CodeRequestState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgCodeRequestStateSet::cfc_spmfi_tclMsgCodeRequestStateSet()
:CodeRequestState()
 {}

tS32 cfc_spmfi_tclMsgCodeRequestStateSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CODEREQUESTSTATESET;
}


cfc_spmfi_tclMsgCodeRequestStateSet::~cfc_spmfi_tclMsgCodeRequestStateSet()
{}

tU32 cfc_spmfi_tclMsgCodeRequestStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgCodeRequestStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CodeRequestState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgCodeRequestStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CodeRequestState);
   return oOut;
}

tBool cfc_spmfi_tclMsgCodeRequestStateSet::operator==(const cfc_spmfi_tclMsgCodeRequestStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CodeRequestState == roRef.CodeRequestState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgCodeRequestStateGet::cfc_spmfi_tclMsgCodeRequestStateGet()
 {}

tS32 cfc_spmfi_tclMsgCodeRequestStateGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CODEREQUESTSTATEGET;
}


cfc_spmfi_tclMsgCodeRequestStateGet::~cfc_spmfi_tclMsgCodeRequestStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgCodeRequestStateStatus::cfc_spmfi_tclMsgCodeRequestStateStatus(const cfc_spmfi_tclMsgCodeRequestStateStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   CodeRequestState = coRef.CodeRequestState;
}
cfc_spmfi_tclMsgCodeRequestStateStatus& cfc_spmfi_tclMsgCodeRequestStateStatus::operator=(const cfc_spmfi_tclMsgCodeRequestStateStatus& coRef)
{
   if (this == &coRef) return *this;
   CodeRequestState = coRef.CodeRequestState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgCodeRequestStateStatus::cfc_spmfi_tclMsgCodeRequestStateStatus()
:CodeRequestState()
 {}

tS32 cfc_spmfi_tclMsgCodeRequestStateStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CODEREQUESTSTATESTATUS;
}


cfc_spmfi_tclMsgCodeRequestStateStatus::~cfc_spmfi_tclMsgCodeRequestStateStatus()
{}

tU32 cfc_spmfi_tclMsgCodeRequestStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgCodeRequestStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CodeRequestState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgCodeRequestStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CodeRequestState);
   return oOut;
}

tBool cfc_spmfi_tclMsgCodeRequestStateStatus::operator==(const cfc_spmfi_tclMsgCodeRequestStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CodeRequestState == roRef.CodeRequestState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgPhoneAbortUpReg::cfc_spmfi_tclMsgPhoneAbortUpReg()
 {}

tS32 cfc_spmfi_tclMsgPhoneAbortUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEABORTUPREG;
}


cfc_spmfi_tclMsgPhoneAbortUpReg::~cfc_spmfi_tclMsgPhoneAbortUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgPhoneAbortRelUpReg::cfc_spmfi_tclMsgPhoneAbortRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgPhoneAbortRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEABORTRELUPREG;
}


cfc_spmfi_tclMsgPhoneAbortRelUpReg::~cfc_spmfi_tclMsgPhoneAbortRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgPhoneAbortSet::cfc_spmfi_tclMsgPhoneAbortSet(const cfc_spmfi_tclMsgPhoneAbortSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   PhoneAbort = coRef.PhoneAbort;
}
cfc_spmfi_tclMsgPhoneAbortSet& cfc_spmfi_tclMsgPhoneAbortSet::operator=(const cfc_spmfi_tclMsgPhoneAbortSet& coRef)
{
   if (this == &coRef) return *this;
   PhoneAbort = coRef.PhoneAbort;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgPhoneAbortSet::cfc_spmfi_tclMsgPhoneAbortSet()
:PhoneAbort()
 {}

tS32 cfc_spmfi_tclMsgPhoneAbortSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEABORTSET;
}


cfc_spmfi_tclMsgPhoneAbortSet::~cfc_spmfi_tclMsgPhoneAbortSet()
{}

tU32 cfc_spmfi_tclMsgPhoneAbortSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgPhoneAbortSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneAbort);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgPhoneAbortSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneAbort);
   return oOut;
}

tBool cfc_spmfi_tclMsgPhoneAbortSet::operator==(const cfc_spmfi_tclMsgPhoneAbortSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneAbort == roRef.PhoneAbort);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgPhoneAbortGet::cfc_spmfi_tclMsgPhoneAbortGet()
 {}

tS32 cfc_spmfi_tclMsgPhoneAbortGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEABORTGET;
}


cfc_spmfi_tclMsgPhoneAbortGet::~cfc_spmfi_tclMsgPhoneAbortGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgPhoneAbortStatus::cfc_spmfi_tclMsgPhoneAbortStatus(const cfc_spmfi_tclMsgPhoneAbortStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   PhoneAbort = coRef.PhoneAbort;
}
cfc_spmfi_tclMsgPhoneAbortStatus& cfc_spmfi_tclMsgPhoneAbortStatus::operator=(const cfc_spmfi_tclMsgPhoneAbortStatus& coRef)
{
   if (this == &coRef) return *this;
   PhoneAbort = coRef.PhoneAbort;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgPhoneAbortStatus::cfc_spmfi_tclMsgPhoneAbortStatus()
:PhoneAbort()
 {}

tS32 cfc_spmfi_tclMsgPhoneAbortStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PHONEABORTSTATUS;
}


cfc_spmfi_tclMsgPhoneAbortStatus::~cfc_spmfi_tclMsgPhoneAbortStatus()
{}

tU32 cfc_spmfi_tclMsgPhoneAbortStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgPhoneAbortStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneAbort);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgPhoneAbortStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneAbort);
   return oOut;
}

tBool cfc_spmfi_tclMsgPhoneAbortStatus::operator==(const cfc_spmfi_tclMsgPhoneAbortStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneAbort == roRef.PhoneAbort);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgDisplaySizeUpReg::cfc_spmfi_tclMsgDisplaySizeUpReg()
 {}

tS32 cfc_spmfi_tclMsgDisplaySizeUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DISPLAYSIZEUPREG;
}


cfc_spmfi_tclMsgDisplaySizeUpReg::~cfc_spmfi_tclMsgDisplaySizeUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgDisplaySizeRelUpReg::cfc_spmfi_tclMsgDisplaySizeRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgDisplaySizeRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DISPLAYSIZERELUPREG;
}


cfc_spmfi_tclMsgDisplaySizeRelUpReg::~cfc_spmfi_tclMsgDisplaySizeRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgDisplaySizeGet::cfc_spmfi_tclMsgDisplaySizeGet()
 {}

tS32 cfc_spmfi_tclMsgDisplaySizeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DISPLAYSIZEGET;
}


cfc_spmfi_tclMsgDisplaySizeGet::~cfc_spmfi_tclMsgDisplaySizeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgDisplaySizeStatus::cfc_spmfi_tclMsgDisplaySizeStatus(const cfc_spmfi_tclMsgDisplaySizeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   u16Width = coRef.u16Width;
   u16Height = coRef.u16Height;
}
cfc_spmfi_tclMsgDisplaySizeStatus& cfc_spmfi_tclMsgDisplaySizeStatus::operator=(const cfc_spmfi_tclMsgDisplaySizeStatus& coRef)
{
   if (this == &coRef) return *this;
   u16Width = coRef.u16Width;
   u16Height = coRef.u16Height;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgDisplaySizeStatus::cfc_spmfi_tclMsgDisplaySizeStatus()
:u16Width(0)
,u16Height(0)
 {}

tS32 cfc_spmfi_tclMsgDisplaySizeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DISPLAYSIZESTATUS;
}


cfc_spmfi_tclMsgDisplaySizeStatus::~cfc_spmfi_tclMsgDisplaySizeStatus()
{}

tU32 cfc_spmfi_tclMsgDisplaySizeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgDisplaySizeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16Width);
   (tVoid) (oIn >> u16Height);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgDisplaySizeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16Width);
   (tVoid) (oOut << u16Height);
   return oOut;
}

tBool cfc_spmfi_tclMsgDisplaySizeStatus::operator==(const cfc_spmfi_tclMsgDisplaySizeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16Width == roRef.u16Width);
   bResult = bResult && (u16Height == roRef.u16Height);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgRestartUpReg::cfc_spmfi_tclMsgRestartUpReg()
 {}

tS32 cfc_spmfi_tclMsgRestartUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESTARTUPREG;
}


cfc_spmfi_tclMsgRestartUpReg::~cfc_spmfi_tclMsgRestartUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgRestartRelUpReg::cfc_spmfi_tclMsgRestartRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgRestartRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESTARTRELUPREG;
}


cfc_spmfi_tclMsgRestartRelUpReg::~cfc_spmfi_tclMsgRestartRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgRestartSet::cfc_spmfi_tclMsgRestartSet(const cfc_spmfi_tclMsgRestartSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   Restart = coRef.Restart;
}
cfc_spmfi_tclMsgRestartSet& cfc_spmfi_tclMsgRestartSet::operator=(const cfc_spmfi_tclMsgRestartSet& coRef)
{
   if (this == &coRef) return *this;
   Restart = coRef.Restart;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgRestartSet::cfc_spmfi_tclMsgRestartSet()
:Restart()
 {}

tS32 cfc_spmfi_tclMsgRestartSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESTARTSET;
}


cfc_spmfi_tclMsgRestartSet::~cfc_spmfi_tclMsgRestartSet()
{}

tU32 cfc_spmfi_tclMsgRestartSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgRestartSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Restart);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgRestartSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Restart);
   return oOut;
}

tBool cfc_spmfi_tclMsgRestartSet::operator==(const cfc_spmfi_tclMsgRestartSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Restart == roRef.Restart);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgRestartGet::cfc_spmfi_tclMsgRestartGet()
 {}

tS32 cfc_spmfi_tclMsgRestartGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESTARTGET;
}


cfc_spmfi_tclMsgRestartGet::~cfc_spmfi_tclMsgRestartGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgRestartStatus::cfc_spmfi_tclMsgRestartStatus(const cfc_spmfi_tclMsgRestartStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   Restart = coRef.Restart;
}
cfc_spmfi_tclMsgRestartStatus& cfc_spmfi_tclMsgRestartStatus::operator=(const cfc_spmfi_tclMsgRestartStatus& coRef)
{
   if (this == &coRef) return *this;
   Restart = coRef.Restart;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgRestartStatus::cfc_spmfi_tclMsgRestartStatus()
:Restart()
 {}

tS32 cfc_spmfi_tclMsgRestartStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESTARTSTATUS;
}


cfc_spmfi_tclMsgRestartStatus::~cfc_spmfi_tclMsgRestartStatus()
{}

tU32 cfc_spmfi_tclMsgRestartStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgRestartStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Restart);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgRestartStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Restart);
   return oOut;
}

tBool cfc_spmfi_tclMsgRestartStatus::operator==(const cfc_spmfi_tclMsgRestartStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Restart == roRef.Restart);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgDevicePowerOnTimeGet::cfc_spmfi_tclMsgDevicePowerOnTimeGet()
 {}

tS32 cfc_spmfi_tclMsgDevicePowerOnTimeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DEVICEPOWERONTIMEGET;
}


cfc_spmfi_tclMsgDevicePowerOnTimeGet::~cfc_spmfi_tclMsgDevicePowerOnTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgDevicePowerOnTimeSet::cfc_spmfi_tclMsgDevicePowerOnTimeSet(const cfc_spmfi_tclMsgDevicePowerOnTimeSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DevicePowerOnTime = coRef.DevicePowerOnTime;
}
cfc_spmfi_tclMsgDevicePowerOnTimeSet& cfc_spmfi_tclMsgDevicePowerOnTimeSet::operator=(const cfc_spmfi_tclMsgDevicePowerOnTimeSet& coRef)
{
   if (this == &coRef) return *this;
   DevicePowerOnTime = coRef.DevicePowerOnTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgDevicePowerOnTimeSet::cfc_spmfi_tclMsgDevicePowerOnTimeSet()
:DevicePowerOnTime(0)
 {}

tS32 cfc_spmfi_tclMsgDevicePowerOnTimeSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DEVICEPOWERONTIMESET;
}


cfc_spmfi_tclMsgDevicePowerOnTimeSet::~cfc_spmfi_tclMsgDevicePowerOnTimeSet()
{}

tU32 cfc_spmfi_tclMsgDevicePowerOnTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgDevicePowerOnTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DevicePowerOnTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgDevicePowerOnTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DevicePowerOnTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgDevicePowerOnTimeSet::operator==(const cfc_spmfi_tclMsgDevicePowerOnTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DevicePowerOnTime == roRef.DevicePowerOnTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgDevicePowerOnTimeStatus::cfc_spmfi_tclMsgDevicePowerOnTimeStatus(const cfc_spmfi_tclMsgDevicePowerOnTimeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DevicePowerOnTime = coRef.DevicePowerOnTime;
}
cfc_spmfi_tclMsgDevicePowerOnTimeStatus& cfc_spmfi_tclMsgDevicePowerOnTimeStatus::operator=(const cfc_spmfi_tclMsgDevicePowerOnTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   DevicePowerOnTime = coRef.DevicePowerOnTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgDevicePowerOnTimeStatus::cfc_spmfi_tclMsgDevicePowerOnTimeStatus()
:DevicePowerOnTime(0)
 {}

tS32 cfc_spmfi_tclMsgDevicePowerOnTimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_DEVICEPOWERONTIMESTATUS;
}


cfc_spmfi_tclMsgDevicePowerOnTimeStatus::~cfc_spmfi_tclMsgDevicePowerOnTimeStatus()
{}

tU32 cfc_spmfi_tclMsgDevicePowerOnTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgDevicePowerOnTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DevicePowerOnTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgDevicePowerOnTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DevicePowerOnTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgDevicePowerOnTimeStatus::operator==(const cfc_spmfi_tclMsgDevicePowerOnTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DevicePowerOnTime == roRef.DevicePowerOnTime);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgLastSystemRuntimeGet::cfc_spmfi_tclMsgLastSystemRuntimeGet()
 {}

tS32 cfc_spmfi_tclMsgLastSystemRuntimeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_LASTSYSTEMRUNTIMEGET;
}


cfc_spmfi_tclMsgLastSystemRuntimeGet::~cfc_spmfi_tclMsgLastSystemRuntimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgLastSystemRuntimeStatus::cfc_spmfi_tclMsgLastSystemRuntimeStatus(const cfc_spmfi_tclMsgLastSystemRuntimeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   u32RunTime = coRef.u32RunTime;
}
cfc_spmfi_tclMsgLastSystemRuntimeStatus& cfc_spmfi_tclMsgLastSystemRuntimeStatus::operator=(const cfc_spmfi_tclMsgLastSystemRuntimeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32RunTime = coRef.u32RunTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgLastSystemRuntimeStatus::cfc_spmfi_tclMsgLastSystemRuntimeStatus()
:u32RunTime(0)
 {}

tS32 cfc_spmfi_tclMsgLastSystemRuntimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_LASTSYSTEMRUNTIMESTATUS;
}


cfc_spmfi_tclMsgLastSystemRuntimeStatus::~cfc_spmfi_tclMsgLastSystemRuntimeStatus()
{}

tU32 cfc_spmfi_tclMsgLastSystemRuntimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgLastSystemRuntimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32RunTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgLastSystemRuntimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32RunTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgLastSystemRuntimeStatus::operator==(const cfc_spmfi_tclMsgLastSystemRuntimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32RunTime == roRef.u32RunTime);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgCurrentSystemRuntimeGet::cfc_spmfi_tclMsgCurrentSystemRuntimeGet()
 {}

tS32 cfc_spmfi_tclMsgCurrentSystemRuntimeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CURRENTSYSTEMRUNTIMEGET;
}


cfc_spmfi_tclMsgCurrentSystemRuntimeGet::~cfc_spmfi_tclMsgCurrentSystemRuntimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgCurrentSystemRuntimeStatus::cfc_spmfi_tclMsgCurrentSystemRuntimeStatus(const cfc_spmfi_tclMsgCurrentSystemRuntimeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   u32RunTime = coRef.u32RunTime;
}
cfc_spmfi_tclMsgCurrentSystemRuntimeStatus& cfc_spmfi_tclMsgCurrentSystemRuntimeStatus::operator=(const cfc_spmfi_tclMsgCurrentSystemRuntimeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32RunTime = coRef.u32RunTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgCurrentSystemRuntimeStatus::cfc_spmfi_tclMsgCurrentSystemRuntimeStatus()
:u32RunTime(0)
 {}

tS32 cfc_spmfi_tclMsgCurrentSystemRuntimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CURRENTSYSTEMRUNTIMESTATUS;
}


cfc_spmfi_tclMsgCurrentSystemRuntimeStatus::~cfc_spmfi_tclMsgCurrentSystemRuntimeStatus()
{}

tU32 cfc_spmfi_tclMsgCurrentSystemRuntimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgCurrentSystemRuntimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32RunTime);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgCurrentSystemRuntimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32RunTime);
   return oOut;
}

tBool cfc_spmfi_tclMsgCurrentSystemRuntimeStatus::operator==(const cfc_spmfi_tclMsgCurrentSystemRuntimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32RunTime == roRef.u32RunTime);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgFactorySettingStatusUpReg::cfc_spmfi_tclMsgFactorySettingStatusUpReg()
 {}

tS32 cfc_spmfi_tclMsgFactorySettingStatusUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGSTATUSUPREG;
}


cfc_spmfi_tclMsgFactorySettingStatusUpReg::~cfc_spmfi_tclMsgFactorySettingStatusUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgFactorySettingStatusRelUpReg::cfc_spmfi_tclMsgFactorySettingStatusRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgFactorySettingStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGSTATUSRELUPREG;
}


cfc_spmfi_tclMsgFactorySettingStatusRelUpReg::~cfc_spmfi_tclMsgFactorySettingStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgFactorySettingStatusGet::cfc_spmfi_tclMsgFactorySettingStatusGet(const cfc_spmfi_tclMsgFactorySettingStatusGet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
}
cfc_spmfi_tclMsgFactorySettingStatusGet& cfc_spmfi_tclMsgFactorySettingStatusGet::operator=(const cfc_spmfi_tclMsgFactorySettingStatusGet& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgFactorySettingStatusGet::cfc_spmfi_tclMsgFactorySettingStatusGet()
:DefSetStateGroup(0)
,DefSetStateMode()
,DefSetStateSuccessful(0)
,DefSetStateFirstDifferentParameterId(0)
 {}

tS32 cfc_spmfi_tclMsgFactorySettingStatusGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGSTATUSGET;
}


cfc_spmfi_tclMsgFactorySettingStatusGet::~cfc_spmfi_tclMsgFactorySettingStatusGet()
{}

tU32 cfc_spmfi_tclMsgFactorySettingStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& cfc_spmfi_tclMsgFactorySettingStatusGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> DefSetStateSuccessful);
   (tVoid) (oIn >> DefSetStateFirstDifferentParameterId);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgFactorySettingStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << DefSetStateSuccessful);
   (tVoid) (oOut << DefSetStateFirstDifferentParameterId);
   return oOut;
}

tBool cfc_spmfi_tclMsgFactorySettingStatusGet::operator==(const cfc_spmfi_tclMsgFactorySettingStatusGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (DefSetStateSuccessful == roRef.DefSetStateSuccessful);
   bResult = bResult && (DefSetStateFirstDifferentParameterId == roRef.DefSetStateFirstDifferentParameterId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgFactorySettingStatusSet::cfc_spmfi_tclMsgFactorySettingStatusSet(const cfc_spmfi_tclMsgFactorySettingStatusSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
}
cfc_spmfi_tclMsgFactorySettingStatusSet& cfc_spmfi_tclMsgFactorySettingStatusSet::operator=(const cfc_spmfi_tclMsgFactorySettingStatusSet& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgFactorySettingStatusSet::cfc_spmfi_tclMsgFactorySettingStatusSet()
:DefSetStateGroup(0)
,DefSetStateMode()
,DefSetStateSuccessful(0)
,DefSetStateFirstDifferentParameterId(0)
 {}

tS32 cfc_spmfi_tclMsgFactorySettingStatusSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGSTATUSSET;
}


cfc_spmfi_tclMsgFactorySettingStatusSet::~cfc_spmfi_tclMsgFactorySettingStatusSet()
{}

tU32 cfc_spmfi_tclMsgFactorySettingStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& cfc_spmfi_tclMsgFactorySettingStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> DefSetStateSuccessful);
   (tVoid) (oIn >> DefSetStateFirstDifferentParameterId);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgFactorySettingStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << DefSetStateSuccessful);
   (tVoid) (oOut << DefSetStateFirstDifferentParameterId);
   return oOut;
}

tBool cfc_spmfi_tclMsgFactorySettingStatusSet::operator==(const cfc_spmfi_tclMsgFactorySettingStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (DefSetStateSuccessful == roRef.DefSetStateSuccessful);
   bResult = bResult && (DefSetStateFirstDifferentParameterId == roRef.DefSetStateFirstDifferentParameterId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgFactorySettingStatusStatus::cfc_spmfi_tclMsgFactorySettingStatusStatus(const cfc_spmfi_tclMsgFactorySettingStatusStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
}
cfc_spmfi_tclMsgFactorySettingStatusStatus& cfc_spmfi_tclMsgFactorySettingStatusStatus::operator=(const cfc_spmfi_tclMsgFactorySettingStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgFactorySettingStatusStatus::cfc_spmfi_tclMsgFactorySettingStatusStatus()
:DefSetStateGroup(0)
,DefSetStateMode()
,DefSetStateSuccessful(0)
,DefSetStateFirstDifferentParameterId(0)
 {}

tS32 cfc_spmfi_tclMsgFactorySettingStatusStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_FACTORYSETTINGSTATUSSTATUS;
}


cfc_spmfi_tclMsgFactorySettingStatusStatus::~cfc_spmfi_tclMsgFactorySettingStatusStatus()
{}

tU32 cfc_spmfi_tclMsgFactorySettingStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& cfc_spmfi_tclMsgFactorySettingStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> DefSetStateSuccessful);
   (tVoid) (oIn >> DefSetStateFirstDifferentParameterId);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgFactorySettingStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << DefSetStateSuccessful);
   (tVoid) (oOut << DefSetStateFirstDifferentParameterId);
   return oOut;
}

tBool cfc_spmfi_tclMsgFactorySettingStatusStatus::operator==(const cfc_spmfi_tclMsgFactorySettingStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (DefSetStateSuccessful == roRef.DefSetStateSuccessful);
   bResult = bResult && (DefSetStateFirstDifferentParameterId == roRef.DefSetStateFirstDifferentParameterId);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSecurityCommErrorGet::cfc_spmfi_tclMsgSecurityCommErrorGet()
 {}

tS32 cfc_spmfi_tclMsgSecurityCommErrorGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SECURITYCOMMERRORGET;
}


cfc_spmfi_tclMsgSecurityCommErrorGet::~cfc_spmfi_tclMsgSecurityCommErrorGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSecurityCommErrorStatus::cfc_spmfi_tclMsgSecurityCommErrorStatus(const cfc_spmfi_tclMsgSecurityCommErrorStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   CommErrorCount = coRef.CommErrorCount;
}
cfc_spmfi_tclMsgSecurityCommErrorStatus& cfc_spmfi_tclMsgSecurityCommErrorStatus::operator=(const cfc_spmfi_tclMsgSecurityCommErrorStatus& coRef)
{
   if (this == &coRef) return *this;
   CommErrorCount = coRef.CommErrorCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSecurityCommErrorStatus::cfc_spmfi_tclMsgSecurityCommErrorStatus()
:CommErrorCount(0)
 {}

tS32 cfc_spmfi_tclMsgSecurityCommErrorStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SECURITYCOMMERRORSTATUS;
}


cfc_spmfi_tclMsgSecurityCommErrorStatus::~cfc_spmfi_tclMsgSecurityCommErrorStatus()
{}

tU32 cfc_spmfi_tclMsgSecurityCommErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_spmfi_tclMsgSecurityCommErrorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CommErrorCount);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSecurityCommErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CommErrorCount);
   return oOut;
}

tBool cfc_spmfi_tclMsgSecurityCommErrorStatus::operator==(const cfc_spmfi_tclMsgSecurityCommErrorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CommErrorCount == roRef.CommErrorCount);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSecurityMoreThan10VinGet::cfc_spmfi_tclMsgSecurityMoreThan10VinGet()
 {}

tS32 cfc_spmfi_tclMsgSecurityMoreThan10VinGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SECURITYMORETHAN10VINGET;
}


cfc_spmfi_tclMsgSecurityMoreThan10VinGet::~cfc_spmfi_tclMsgSecurityMoreThan10VinGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSecurityMoreThan10VinStatus::cfc_spmfi_tclMsgSecurityMoreThan10VinStatus(const cfc_spmfi_tclMsgSecurityMoreThan10VinStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   MoreThan10VinCount = coRef.MoreThan10VinCount;
}
cfc_spmfi_tclMsgSecurityMoreThan10VinStatus& cfc_spmfi_tclMsgSecurityMoreThan10VinStatus::operator=(const cfc_spmfi_tclMsgSecurityMoreThan10VinStatus& coRef)
{
   if (this == &coRef) return *this;
   MoreThan10VinCount = coRef.MoreThan10VinCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSecurityMoreThan10VinStatus::cfc_spmfi_tclMsgSecurityMoreThan10VinStatus()
:MoreThan10VinCount(0)
 {}

tS32 cfc_spmfi_tclMsgSecurityMoreThan10VinStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SECURITYMORETHAN10VINSTATUS;
}


cfc_spmfi_tclMsgSecurityMoreThan10VinStatus::~cfc_spmfi_tclMsgSecurityMoreThan10VinStatus()
{}

tU32 cfc_spmfi_tclMsgSecurityMoreThan10VinStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_spmfi_tclMsgSecurityMoreThan10VinStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MoreThan10VinCount);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSecurityMoreThan10VinStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MoreThan10VinCount);
   return oOut;
}

tBool cfc_spmfi_tclMsgSecurityMoreThan10VinStatus::operator==(const cfc_spmfi_tclMsgSecurityMoreThan10VinStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MoreThan10VinCount == roRef.MoreThan10VinCount);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSecurityInvalidVinGet::cfc_spmfi_tclMsgSecurityInvalidVinGet()
 {}

tS32 cfc_spmfi_tclMsgSecurityInvalidVinGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SECURITYINVALIDVINGET;
}


cfc_spmfi_tclMsgSecurityInvalidVinGet::~cfc_spmfi_tclMsgSecurityInvalidVinGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSecurityInvalidVinStatus::cfc_spmfi_tclMsgSecurityInvalidVinStatus(const cfc_spmfi_tclMsgSecurityInvalidVinStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   InvalidVinCount = coRef.InvalidVinCount;
}
cfc_spmfi_tclMsgSecurityInvalidVinStatus& cfc_spmfi_tclMsgSecurityInvalidVinStatus::operator=(const cfc_spmfi_tclMsgSecurityInvalidVinStatus& coRef)
{
   if (this == &coRef) return *this;
   InvalidVinCount = coRef.InvalidVinCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgSecurityInvalidVinStatus::cfc_spmfi_tclMsgSecurityInvalidVinStatus()
:InvalidVinCount(0)
 {}

tS32 cfc_spmfi_tclMsgSecurityInvalidVinStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SECURITYINVALIDVINSTATUS;
}


cfc_spmfi_tclMsgSecurityInvalidVinStatus::~cfc_spmfi_tclMsgSecurityInvalidVinStatus()
{}

tU32 cfc_spmfi_tclMsgSecurityInvalidVinStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cfc_spmfi_tclMsgSecurityInvalidVinStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> InvalidVinCount);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSecurityInvalidVinStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << InvalidVinCount);
   return oOut;
}

tBool cfc_spmfi_tclMsgSecurityInvalidVinStatus::operator==(const cfc_spmfi_tclMsgSecurityInvalidVinStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (InvalidVinCount == roRef.InvalidVinCount);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSecurityCurrentVinGet::cfc_spmfi_tclMsgSecurityCurrentVinGet()
 {}

tS32 cfc_spmfi_tclMsgSecurityCurrentVinGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SECURITYCURRENTVINGET;
}


cfc_spmfi_tclMsgSecurityCurrentVinGet::~cfc_spmfi_tclMsgSecurityCurrentVinGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSecurityCurrentVinStatus::cfc_spmfi_tclMsgSecurityCurrentVinStatus(const cfc_spmfi_tclMsgSecurityCurrentVinStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   CurrentVin = coRef.CurrentVin;
}
cfc_spmfi_tclMsgSecurityCurrentVinStatus& cfc_spmfi_tclMsgSecurityCurrentVinStatus::operator=(const cfc_spmfi_tclMsgSecurityCurrentVinStatus& coRef)
{
   if (this == &coRef) return *this;
   CurrentVin = coRef.CurrentVin;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgSecurityCurrentVinStatus::vDestroy()
{
   CurrentVin.vDestroy(); 
}

cfc_spmfi_tclMsgSecurityCurrentVinStatus::cfc_spmfi_tclMsgSecurityCurrentVinStatus()
:CurrentVin()
 {}

tS32 cfc_spmfi_tclMsgSecurityCurrentVinStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SECURITYCURRENTVINSTATUS;
}


cfc_spmfi_tclMsgSecurityCurrentVinStatus::~cfc_spmfi_tclMsgSecurityCurrentVinStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgSecurityCurrentVinStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CurrentVin.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cfc_spmfi_tclMsgSecurityCurrentVinStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentVin);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSecurityCurrentVinStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentVin);
   return oOut;
}

tBool cfc_spmfi_tclMsgSecurityCurrentVinStatus::operator==(const cfc_spmfi_tclMsgSecurityCurrentVinStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentVin == roRef.CurrentVin);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSecurityVinHistoryGet::cfc_spmfi_tclMsgSecurityVinHistoryGet()
 {}

tS32 cfc_spmfi_tclMsgSecurityVinHistoryGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SECURITYVINHISTORYGET;
}


cfc_spmfi_tclMsgSecurityVinHistoryGet::~cfc_spmfi_tclMsgSecurityVinHistoryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSecurityVinHistoryStatus::cfc_spmfi_tclMsgSecurityVinHistoryStatus(const cfc_spmfi_tclMsgSecurityVinHistoryStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   VinHistory = coRef.VinHistory;
}
cfc_spmfi_tclMsgSecurityVinHistoryStatus& cfc_spmfi_tclMsgSecurityVinHistoryStatus::operator=(const cfc_spmfi_tclMsgSecurityVinHistoryStatus& coRef)
{
   if (this == &coRef) return *this;
   VinHistory = coRef.VinHistory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgSecurityVinHistoryStatus::vDestroy()
{
   VinHistory.vDestroy(); 
}

cfc_spmfi_tclMsgSecurityVinHistoryStatus::cfc_spmfi_tclMsgSecurityVinHistoryStatus()
:VinHistory()
 {}

tS32 cfc_spmfi_tclMsgSecurityVinHistoryStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SECURITYVINHISTORYSTATUS;
}


cfc_spmfi_tclMsgSecurityVinHistoryStatus::~cfc_spmfi_tclMsgSecurityVinHistoryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgSecurityVinHistoryStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+VinHistory.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cfc_spmfi_tclMsgSecurityVinHistoryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VinHistory);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSecurityVinHistoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VinHistory);
   return oOut;
}

tBool cfc_spmfi_tclMsgSecurityVinHistoryStatus::operator==(const cfc_spmfi_tclMsgSecurityVinHistoryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VinHistory == roRef.VinHistory);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgResetListSet::cfc_spmfi_tclMsgResetListSet(const cfc_spmfi_tclMsgResetListSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   ResetResetList = coRef.ResetResetList;
}
cfc_spmfi_tclMsgResetListSet& cfc_spmfi_tclMsgResetListSet::operator=(const cfc_spmfi_tclMsgResetListSet& coRef)
{
   if (this == &coRef) return *this;
   ResetResetList = coRef.ResetResetList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgResetListSet::cfc_spmfi_tclMsgResetListSet()
:ResetResetList(0)
 {}

tS32 cfc_spmfi_tclMsgResetListSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESETLISTSET;
}


cfc_spmfi_tclMsgResetListSet::~cfc_spmfi_tclMsgResetListSet()
{}

tU32 cfc_spmfi_tclMsgResetListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgResetListSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResetResetList);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgResetListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResetResetList);
   return oOut;
}

tBool cfc_spmfi_tclMsgResetListSet::operator==(const cfc_spmfi_tclMsgResetListSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResetResetList == roRef.ResetResetList);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgResetListGet::cfc_spmfi_tclMsgResetListGet()
 {}

tS32 cfc_spmfi_tclMsgResetListGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESETLISTGET;
}


cfc_spmfi_tclMsgResetListGet::~cfc_spmfi_tclMsgResetListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgResetListStatus::cfc_spmfi_tclMsgResetListStatus(const cfc_spmfi_tclMsgResetListStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   LastResetReason = coRef.LastResetReason;
   DateHour = coRef.DateHour;
   DateMinute = coRef.DateMinute;
   DateDay = coRef.DateDay;
   DateMonth = coRef.DateMonth;
   DateYear = coRef.DateYear;
   CoproResetByHmi = coRef.CoproResetByHmi;
   CoproResetByUndervoltage = coRef.CoproResetByUndervoltage;
   HmiResetByCoproStartup = coRef.HmiResetByCoproStartup;
   HmiResetByCoproRun = coRef.HmiResetByCoproRun;
   HmiResetByCoproShutdown = coRef.HmiResetByCoproShutdown;
   HmiResetByHmiWdg = coRef.HmiResetByHmiWdg;
   HmiResetByHmiApp = coRef.HmiResetByHmiApp;
   HmiResetByHmiException = coRef.HmiResetByHmiException;
   HmiResetByHmiExtern = coRef.HmiResetByHmiExtern;
   HmiResetByHmiDownload = coRef.HmiResetByHmiDownload;
   HmiResetByHmiDiag = coRef.HmiResetByHmiDiag;
   FgsResetByHmi = coRef.FgsResetByHmi;
}
cfc_spmfi_tclMsgResetListStatus& cfc_spmfi_tclMsgResetListStatus::operator=(const cfc_spmfi_tclMsgResetListStatus& coRef)
{
   if (this == &coRef) return *this;
   LastResetReason = coRef.LastResetReason;
   DateHour = coRef.DateHour;
   DateMinute = coRef.DateMinute;
   DateDay = coRef.DateDay;
   DateMonth = coRef.DateMonth;
   DateYear = coRef.DateYear;
   CoproResetByHmi = coRef.CoproResetByHmi;
   CoproResetByUndervoltage = coRef.CoproResetByUndervoltage;
   HmiResetByCoproStartup = coRef.HmiResetByCoproStartup;
   HmiResetByCoproRun = coRef.HmiResetByCoproRun;
   HmiResetByCoproShutdown = coRef.HmiResetByCoproShutdown;
   HmiResetByHmiWdg = coRef.HmiResetByHmiWdg;
   HmiResetByHmiApp = coRef.HmiResetByHmiApp;
   HmiResetByHmiException = coRef.HmiResetByHmiException;
   HmiResetByHmiExtern = coRef.HmiResetByHmiExtern;
   HmiResetByHmiDownload = coRef.HmiResetByHmiDownload;
   HmiResetByHmiDiag = coRef.HmiResetByHmiDiag;
   FgsResetByHmi = coRef.FgsResetByHmi;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgResetListStatus::cfc_spmfi_tclMsgResetListStatus()
:LastResetReason()
,DateHour(0)
,DateMinute(0)
,DateDay(0)
,DateMonth(0)
,DateYear(0)
,CoproResetByHmi(0)
,CoproResetByUndervoltage(0)
,HmiResetByCoproStartup(0)
,HmiResetByCoproRun(0)
,HmiResetByCoproShutdown(0)
,HmiResetByHmiWdg(0)
,HmiResetByHmiApp(0)
,HmiResetByHmiException(0)
,HmiResetByHmiExtern(0)
,HmiResetByHmiDownload(0)
,HmiResetByHmiDiag(0)
,FgsResetByHmi(0)
 {}

tS32 cfc_spmfi_tclMsgResetListStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESETLISTSTATUS;
}


cfc_spmfi_tclMsgResetListStatus::~cfc_spmfi_tclMsgResetListStatus()
{}

tU32 cfc_spmfi_tclMsgResetListStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 19;
}

fi_tclInContext& cfc_spmfi_tclMsgResetListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LastResetReason);
   (tVoid) (oIn >> DateHour);
   (tVoid) (oIn >> DateMinute);
   (tVoid) (oIn >> DateDay);
   (tVoid) (oIn >> DateMonth);
   (tVoid) (oIn >> DateYear);
   (tVoid) (oIn >> CoproResetByHmi);
   (tVoid) (oIn >> CoproResetByUndervoltage);
   (tVoid) (oIn >> HmiResetByCoproStartup);
   (tVoid) (oIn >> HmiResetByCoproRun);
   (tVoid) (oIn >> HmiResetByCoproShutdown);
   (tVoid) (oIn >> HmiResetByHmiWdg);
   (tVoid) (oIn >> HmiResetByHmiApp);
   (tVoid) (oIn >> HmiResetByHmiException);
   (tVoid) (oIn >> HmiResetByHmiExtern);
   (tVoid) (oIn >> HmiResetByHmiDownload);
   (tVoid) (oIn >> HmiResetByHmiDiag);
   (tVoid) (oIn >> FgsResetByHmi);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgResetListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LastResetReason);
   (tVoid) (oOut << DateHour);
   (tVoid) (oOut << DateMinute);
   (tVoid) (oOut << DateDay);
   (tVoid) (oOut << DateMonth);
   (tVoid) (oOut << DateYear);
   (tVoid) (oOut << CoproResetByHmi);
   (tVoid) (oOut << CoproResetByUndervoltage);
   (tVoid) (oOut << HmiResetByCoproStartup);
   (tVoid) (oOut << HmiResetByCoproRun);
   (tVoid) (oOut << HmiResetByCoproShutdown);
   (tVoid) (oOut << HmiResetByHmiWdg);
   (tVoid) (oOut << HmiResetByHmiApp);
   (tVoid) (oOut << HmiResetByHmiException);
   (tVoid) (oOut << HmiResetByHmiExtern);
   (tVoid) (oOut << HmiResetByHmiDownload);
   (tVoid) (oOut << HmiResetByHmiDiag);
   (tVoid) (oOut << FgsResetByHmi);
   return oOut;
}

tBool cfc_spmfi_tclMsgResetListStatus::operator==(const cfc_spmfi_tclMsgResetListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LastResetReason == roRef.LastResetReason);
   bResult = bResult && (DateHour == roRef.DateHour);
   bResult = bResult && (DateMinute == roRef.DateMinute);
   bResult = bResult && (DateDay == roRef.DateDay);
   bResult = bResult && (DateMonth == roRef.DateMonth);
   bResult = bResult && (DateYear == roRef.DateYear);
   bResult = bResult && (CoproResetByHmi == roRef.CoproResetByHmi);
   bResult = bResult && (CoproResetByUndervoltage == roRef.CoproResetByUndervoltage);
   bResult = bResult && (HmiResetByCoproStartup == roRef.HmiResetByCoproStartup);
   bResult = bResult && (HmiResetByCoproRun == roRef.HmiResetByCoproRun);
   bResult = bResult && (HmiResetByCoproShutdown == roRef.HmiResetByCoproShutdown);
   bResult = bResult && (HmiResetByHmiWdg == roRef.HmiResetByHmiWdg);
   bResult = bResult && (HmiResetByHmiApp == roRef.HmiResetByHmiApp);
   bResult = bResult && (HmiResetByHmiException == roRef.HmiResetByHmiException);
   bResult = bResult && (HmiResetByHmiExtern == roRef.HmiResetByHmiExtern);
   bResult = bResult && (HmiResetByHmiDownload == roRef.HmiResetByHmiDownload);
   bResult = bResult && (HmiResetByHmiDiag == roRef.HmiResetByHmiDiag);
   bResult = bResult && (FgsResetByHmi == roRef.FgsResetByHmi);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgResetCounterSet::cfc_spmfi_tclMsgResetCounterSet(const cfc_spmfi_tclMsgResetCounterSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   ResetCounter = coRef.ResetCounter;
}
cfc_spmfi_tclMsgResetCounterSet& cfc_spmfi_tclMsgResetCounterSet::operator=(const cfc_spmfi_tclMsgResetCounterSet& coRef)
{
   if (this == &coRef) return *this;
   ResetCounter = coRef.ResetCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgResetCounterSet::cfc_spmfi_tclMsgResetCounterSet()
:ResetCounter(0)
 {}

tS32 cfc_spmfi_tclMsgResetCounterSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESETCOUNTERSET;
}


cfc_spmfi_tclMsgResetCounterSet::~cfc_spmfi_tclMsgResetCounterSet()
{}

tU32 cfc_spmfi_tclMsgResetCounterSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgResetCounterSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResetCounter);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgResetCounterSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResetCounter);
   return oOut;
}

tBool cfc_spmfi_tclMsgResetCounterSet::operator==(const cfc_spmfi_tclMsgResetCounterSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResetCounter == roRef.ResetCounter);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgResetCounterGet::cfc_spmfi_tclMsgResetCounterGet()
 {}

tS32 cfc_spmfi_tclMsgResetCounterGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESETCOUNTERGET;
}


cfc_spmfi_tclMsgResetCounterGet::~cfc_spmfi_tclMsgResetCounterGet()
{}

//=============================================================================

cfc_spmfi_tclMsgResetCounterUpReg::cfc_spmfi_tclMsgResetCounterUpReg()
 {}

tS32 cfc_spmfi_tclMsgResetCounterUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESETCOUNTERUPREG;
}


cfc_spmfi_tclMsgResetCounterUpReg::~cfc_spmfi_tclMsgResetCounterUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgResetCounterRelUpReg::cfc_spmfi_tclMsgResetCounterRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgResetCounterRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESETCOUNTERRELUPREG;
}


cfc_spmfi_tclMsgResetCounterRelUpReg::~cfc_spmfi_tclMsgResetCounterRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgResetCounterStatus::cfc_spmfi_tclMsgResetCounterStatus(const cfc_spmfi_tclMsgResetCounterStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tLastResetDate = coRef.tLastResetDate;
   tLastResetReason = coRef.tLastResetReason;
   u32ApApplicationError = coRef.u32ApApplicationError;
   u32ApSoftware = coRef.u32ApSoftware;
   u32ApEcuReset = coRef.u32ApEcuReset;
   u32ApDownload = coRef.u32ApDownload;
   u32ApDownloadError = coRef.u32ApDownloadError;
   u32ApOvertemperature = coRef.u32ApOvertemperature;
   u32ApUser = coRef.u32ApUser;
   u32ApLcmIntern = coRef.u32ApLcmIntern;
   u32ApWarmstartCount = coRef.u32ApWarmstartCount;
   u32ApPowerOnCount = coRef.u32ApPowerOnCount;
   u32ApPowerLossCount = coRef.u32ApPowerLossCount;
   u32ApPowerOffCount = coRef.u32ApPowerOffCount;
   u32ApSccCount = coRef.u32ApSccCount;
   u32ApUnknownCount = coRef.u32ApUnknownCount;
   u32SccHwWdtCount = coRef.u32SccHwWdtCount;
   u32SccPowerOnCount = coRef.u32SccPowerOnCount;
   u32SccColdstartCount = coRef.u32SccColdstartCount;
   u32SccAppmodeChangeCount = coRef.u32SccAppmodeChangeCount;
   u32SccDuringLpwCount = coRef.u32SccDuringLpwCount;
   u32SccDuringPllOszCount = coRef.u32SccDuringPllOszCount;
   u32SccDuringSWCount = coRef.u32SccDuringSWCount;
   u32SccWarmstartCount = coRef.u32SccWarmstartCount;
}
cfc_spmfi_tclMsgResetCounterStatus& cfc_spmfi_tclMsgResetCounterStatus::operator=(const cfc_spmfi_tclMsgResetCounterStatus& coRef)
{
   if (this == &coRef) return *this;
   tLastResetDate = coRef.tLastResetDate;
   tLastResetReason = coRef.tLastResetReason;
   u32ApApplicationError = coRef.u32ApApplicationError;
   u32ApSoftware = coRef.u32ApSoftware;
   u32ApEcuReset = coRef.u32ApEcuReset;
   u32ApDownload = coRef.u32ApDownload;
   u32ApDownloadError = coRef.u32ApDownloadError;
   u32ApOvertemperature = coRef.u32ApOvertemperature;
   u32ApUser = coRef.u32ApUser;
   u32ApLcmIntern = coRef.u32ApLcmIntern;
   u32ApWarmstartCount = coRef.u32ApWarmstartCount;
   u32ApPowerOnCount = coRef.u32ApPowerOnCount;
   u32ApPowerLossCount = coRef.u32ApPowerLossCount;
   u32ApPowerOffCount = coRef.u32ApPowerOffCount;
   u32ApSccCount = coRef.u32ApSccCount;
   u32ApUnknownCount = coRef.u32ApUnknownCount;
   u32SccHwWdtCount = coRef.u32SccHwWdtCount;
   u32SccPowerOnCount = coRef.u32SccPowerOnCount;
   u32SccColdstartCount = coRef.u32SccColdstartCount;
   u32SccAppmodeChangeCount = coRef.u32SccAppmodeChangeCount;
   u32SccDuringLpwCount = coRef.u32SccDuringLpwCount;
   u32SccDuringPllOszCount = coRef.u32SccDuringPllOszCount;
   u32SccDuringSWCount = coRef.u32SccDuringSWCount;
   u32SccWarmstartCount = coRef.u32SccWarmstartCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgResetCounterStatus::cfc_spmfi_tclMsgResetCounterStatus()
:tLastResetDate()
,tLastResetReason()
,u32ApApplicationError(0)
,u32ApSoftware(0)
,u32ApEcuReset(0)
,u32ApDownload(0)
,u32ApDownloadError(0)
,u32ApOvertemperature(0)
,u32ApUser(0)
,u32ApLcmIntern(0)
,u32ApWarmstartCount(0)
,u32ApPowerOnCount(0)
,u32ApPowerLossCount(0)
,u32ApPowerOffCount(0)
,u32ApSccCount(0)
,u32ApUnknownCount(0)
,u32SccHwWdtCount(0)
,u32SccPowerOnCount(0)
,u32SccColdstartCount(0)
,u32SccAppmodeChangeCount(0)
,u32SccDuringLpwCount(0)
,u32SccDuringPllOszCount(0)
,u32SccDuringSWCount(0)
,u32SccWarmstartCount(0)
 {}

tS32 cfc_spmfi_tclMsgResetCounterStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESETCOUNTERSTATUS;
}


cfc_spmfi_tclMsgResetCounterStatus::~cfc_spmfi_tclMsgResetCounterStatus()
{}

tU32 cfc_spmfi_tclMsgResetCounterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 96;
}

fi_tclInContext& cfc_spmfi_tclMsgResetCounterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tLastResetDate);
   (tVoid) (oIn >> tLastResetReason);
   (tVoid) (oIn >> u32ApApplicationError);
   (tVoid) (oIn >> u32ApSoftware);
   (tVoid) (oIn >> u32ApEcuReset);
   (tVoid) (oIn >> u32ApDownload);
   (tVoid) (oIn >> u32ApDownloadError);
   (tVoid) (oIn >> u32ApOvertemperature);
   (tVoid) (oIn >> u32ApUser);
   (tVoid) (oIn >> u32ApLcmIntern);
   (tVoid) (oIn >> u32ApWarmstartCount);
   (tVoid) (oIn >> u32ApPowerOnCount);
   (tVoid) (oIn >> u32ApPowerLossCount);
   (tVoid) (oIn >> u32ApPowerOffCount);
   (tVoid) (oIn >> u32ApSccCount);
   (tVoid) (oIn >> u32ApUnknownCount);
   (tVoid) (oIn >> u32SccHwWdtCount);
   (tVoid) (oIn >> u32SccPowerOnCount);
   (tVoid) (oIn >> u32SccColdstartCount);
   (tVoid) (oIn >> u32SccAppmodeChangeCount);
   (tVoid) (oIn >> u32SccDuringLpwCount);
   (tVoid) (oIn >> u32SccDuringPllOszCount);
   (tVoid) (oIn >> u32SccDuringSWCount);
   (tVoid) (oIn >> u32SccWarmstartCount);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgResetCounterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tLastResetDate);
   (tVoid) (oOut << tLastResetReason);
   (tVoid) (oOut << u32ApApplicationError);
   (tVoid) (oOut << u32ApSoftware);
   (tVoid) (oOut << u32ApEcuReset);
   (tVoid) (oOut << u32ApDownload);
   (tVoid) (oOut << u32ApDownloadError);
   (tVoid) (oOut << u32ApOvertemperature);
   (tVoid) (oOut << u32ApUser);
   (tVoid) (oOut << u32ApLcmIntern);
   (tVoid) (oOut << u32ApWarmstartCount);
   (tVoid) (oOut << u32ApPowerOnCount);
   (tVoid) (oOut << u32ApPowerLossCount);
   (tVoid) (oOut << u32ApPowerOffCount);
   (tVoid) (oOut << u32ApSccCount);
   (tVoid) (oOut << u32ApUnknownCount);
   (tVoid) (oOut << u32SccHwWdtCount);
   (tVoid) (oOut << u32SccPowerOnCount);
   (tVoid) (oOut << u32SccColdstartCount);
   (tVoid) (oOut << u32SccAppmodeChangeCount);
   (tVoid) (oOut << u32SccDuringLpwCount);
   (tVoid) (oOut << u32SccDuringPllOszCount);
   (tVoid) (oOut << u32SccDuringSWCount);
   (tVoid) (oOut << u32SccWarmstartCount);
   return oOut;
}

tBool cfc_spmfi_tclMsgResetCounterStatus::operator==(const cfc_spmfi_tclMsgResetCounterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tLastResetDate == roRef.tLastResetDate);
   bResult = bResult && (tLastResetReason == roRef.tLastResetReason);
   bResult = bResult && (u32ApApplicationError == roRef.u32ApApplicationError);
   bResult = bResult && (u32ApSoftware == roRef.u32ApSoftware);
   bResult = bResult && (u32ApEcuReset == roRef.u32ApEcuReset);
   bResult = bResult && (u32ApDownload == roRef.u32ApDownload);
   bResult = bResult && (u32ApDownloadError == roRef.u32ApDownloadError);
   bResult = bResult && (u32ApOvertemperature == roRef.u32ApOvertemperature);
   bResult = bResult && (u32ApUser == roRef.u32ApUser);
   bResult = bResult && (u32ApLcmIntern == roRef.u32ApLcmIntern);
   bResult = bResult && (u32ApWarmstartCount == roRef.u32ApWarmstartCount);
   bResult = bResult && (u32ApPowerOnCount == roRef.u32ApPowerOnCount);
   bResult = bResult && (u32ApPowerLossCount == roRef.u32ApPowerLossCount);
   bResult = bResult && (u32ApPowerOffCount == roRef.u32ApPowerOffCount);
   bResult = bResult && (u32ApSccCount == roRef.u32ApSccCount);
   bResult = bResult && (u32ApUnknownCount == roRef.u32ApUnknownCount);
   bResult = bResult && (u32SccHwWdtCount == roRef.u32SccHwWdtCount);
   bResult = bResult && (u32SccPowerOnCount == roRef.u32SccPowerOnCount);
   bResult = bResult && (u32SccColdstartCount == roRef.u32SccColdstartCount);
   bResult = bResult && (u32SccAppmodeChangeCount == roRef.u32SccAppmodeChangeCount);
   bResult = bResult && (u32SccDuringLpwCount == roRef.u32SccDuringLpwCount);
   bResult = bResult && (u32SccDuringPllOszCount == roRef.u32SccDuringPllOszCount);
   bResult = bResult && (u32SccDuringSWCount == roRef.u32SccDuringSWCount);
   bResult = bResult && (u32SccWarmstartCount == roRef.u32SccWarmstartCount);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgWakeupListSet::cfc_spmfi_tclMsgWakeupListSet(const cfc_spmfi_tclMsgWakeupListSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   WakeupList = coRef.WakeupList;
}
cfc_spmfi_tclMsgWakeupListSet& cfc_spmfi_tclMsgWakeupListSet::operator=(const cfc_spmfi_tclMsgWakeupListSet& coRef)
{
   if (this == &coRef) return *this;
   WakeupList = coRef.WakeupList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgWakeupListSet::cfc_spmfi_tclMsgWakeupListSet()
:WakeupList(0)
 {}

tS32 cfc_spmfi_tclMsgWakeupListSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_WAKEUPLISTSET;
}


cfc_spmfi_tclMsgWakeupListSet::~cfc_spmfi_tclMsgWakeupListSet()
{}

tU32 cfc_spmfi_tclMsgWakeupListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgWakeupListSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WakeupList);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgWakeupListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WakeupList);
   return oOut;
}

tBool cfc_spmfi_tclMsgWakeupListSet::operator==(const cfc_spmfi_tclMsgWakeupListSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WakeupList == roRef.WakeupList);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgWakeupListGet::cfc_spmfi_tclMsgWakeupListGet()
 {}

tS32 cfc_spmfi_tclMsgWakeupListGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_WAKEUPLISTGET;
}


cfc_spmfi_tclMsgWakeupListGet::~cfc_spmfi_tclMsgWakeupListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgWakeupListStatus::cfc_spmfi_tclMsgWakeupListStatus(const cfc_spmfi_tclMsgWakeupListStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   WakeUpReason1 = coRef.WakeUpReason1;
   WakeUpReason2 = coRef.WakeUpReason2;
   WakeUpReason3 = coRef.WakeUpReason3;
   WakeUpReason4 = coRef.WakeUpReason4;
   WakeUpReason5 = coRef.WakeUpReason5;
   WakeUpReason6 = coRef.WakeUpReason6;
   WakeUpReason7 = coRef.WakeUpReason7;
   WakeUpReason8 = coRef.WakeUpReason8;
   WakeUpReason9 = coRef.WakeUpReason9;
   WakeUpReason10 = coRef.WakeUpReason10;
}
cfc_spmfi_tclMsgWakeupListStatus& cfc_spmfi_tclMsgWakeupListStatus::operator=(const cfc_spmfi_tclMsgWakeupListStatus& coRef)
{
   if (this == &coRef) return *this;
   WakeUpReason1 = coRef.WakeUpReason1;
   WakeUpReason2 = coRef.WakeUpReason2;
   WakeUpReason3 = coRef.WakeUpReason3;
   WakeUpReason4 = coRef.WakeUpReason4;
   WakeUpReason5 = coRef.WakeUpReason5;
   WakeUpReason6 = coRef.WakeUpReason6;
   WakeUpReason7 = coRef.WakeUpReason7;
   WakeUpReason8 = coRef.WakeUpReason8;
   WakeUpReason9 = coRef.WakeUpReason9;
   WakeUpReason10 = coRef.WakeUpReason10;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgWakeupListStatus::cfc_spmfi_tclMsgWakeupListStatus()
:WakeUpReason1()
,WakeUpReason2()
,WakeUpReason3()
,WakeUpReason4()
,WakeUpReason5()
,WakeUpReason6()
,WakeUpReason7()
,WakeUpReason8()
,WakeUpReason9()
,WakeUpReason10()
 {}

tS32 cfc_spmfi_tclMsgWakeupListStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_WAKEUPLISTSTATUS;
}


cfc_spmfi_tclMsgWakeupListStatus::~cfc_spmfi_tclMsgWakeupListStatus()
{}

tU32 cfc_spmfi_tclMsgWakeupListStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cfc_spmfi_tclMsgWakeupListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WakeUpReason1);
   (tVoid) (oIn >> WakeUpReason2);
   (tVoid) (oIn >> WakeUpReason3);
   (tVoid) (oIn >> WakeUpReason4);
   (tVoid) (oIn >> WakeUpReason5);
   (tVoid) (oIn >> WakeUpReason6);
   (tVoid) (oIn >> WakeUpReason7);
   (tVoid) (oIn >> WakeUpReason8);
   (tVoid) (oIn >> WakeUpReason9);
   (tVoid) (oIn >> WakeUpReason10);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgWakeupListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WakeUpReason1);
   (tVoid) (oOut << WakeUpReason2);
   (tVoid) (oOut << WakeUpReason3);
   (tVoid) (oOut << WakeUpReason4);
   (tVoid) (oOut << WakeUpReason5);
   (tVoid) (oOut << WakeUpReason6);
   (tVoid) (oOut << WakeUpReason7);
   (tVoid) (oOut << WakeUpReason8);
   (tVoid) (oOut << WakeUpReason9);
   (tVoid) (oOut << WakeUpReason10);
   return oOut;
}

tBool cfc_spmfi_tclMsgWakeupListStatus::operator==(const cfc_spmfi_tclMsgWakeupListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WakeUpReason1 == roRef.WakeUpReason1);
   bResult = bResult && (WakeUpReason2 == roRef.WakeUpReason2);
   bResult = bResult && (WakeUpReason3 == roRef.WakeUpReason3);
   bResult = bResult && (WakeUpReason4 == roRef.WakeUpReason4);
   bResult = bResult && (WakeUpReason5 == roRef.WakeUpReason5);
   bResult = bResult && (WakeUpReason6 == roRef.WakeUpReason6);
   bResult = bResult && (WakeUpReason7 == roRef.WakeUpReason7);
   bResult = bResult && (WakeUpReason8 == roRef.WakeUpReason8);
   bResult = bResult && (WakeUpReason9 == roRef.WakeUpReason9);
   bResult = bResult && (WakeUpReason10 == roRef.WakeUpReason10);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgTransportModeListSet::cfc_spmfi_tclMsgTransportModeListSet(const cfc_spmfi_tclMsgTransportModeListSet& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   TransPortList = coRef.TransPortList;
}
cfc_spmfi_tclMsgTransportModeListSet& cfc_spmfi_tclMsgTransportModeListSet::operator=(const cfc_spmfi_tclMsgTransportModeListSet& coRef)
{
   if (this == &coRef) return *this;
   TransPortList = coRef.TransPortList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgTransportModeListSet::cfc_spmfi_tclMsgTransportModeListSet()
:TransPortList(0)
 {}

tS32 cfc_spmfi_tclMsgTransportModeListSet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_TRANSPORTMODELISTSET;
}


cfc_spmfi_tclMsgTransportModeListSet::~cfc_spmfi_tclMsgTransportModeListSet()
{}

tU32 cfc_spmfi_tclMsgTransportModeListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgTransportModeListSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TransPortList);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgTransportModeListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TransPortList);
   return oOut;
}

tBool cfc_spmfi_tclMsgTransportModeListSet::operator==(const cfc_spmfi_tclMsgTransportModeListSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TransPortList == roRef.TransPortList);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgTransportModeListGet::cfc_spmfi_tclMsgTransportModeListGet()
 {}

tS32 cfc_spmfi_tclMsgTransportModeListGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_TRANSPORTMODELISTGET;
}


cfc_spmfi_tclMsgTransportModeListGet::~cfc_spmfi_tclMsgTransportModeListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgTransportModeListStatus::cfc_spmfi_tclMsgTransportModeListStatus(const cfc_spmfi_tclMsgTransportModeListStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   TransportModeList = coRef.TransportModeList;
}
cfc_spmfi_tclMsgTransportModeListStatus& cfc_spmfi_tclMsgTransportModeListStatus::operator=(const cfc_spmfi_tclMsgTransportModeListStatus& coRef)
{
   if (this == &coRef) return *this;
   TransportModeList = coRef.TransportModeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgTransportModeListStatus::vDestroy()
{
   TransportModeList.vDestroy(); 
}

cfc_spmfi_tclMsgTransportModeListStatus::cfc_spmfi_tclMsgTransportModeListStatus()
:TransportModeList()
 {}

tS32 cfc_spmfi_tclMsgTransportModeListStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_TRANSPORTMODELISTSTATUS;
}


cfc_spmfi_tclMsgTransportModeListStatus::~cfc_spmfi_tclMsgTransportModeListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgTransportModeListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TransportModeList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cfc_spmfi_tclMsgTransportModeListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TransportModeList);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgTransportModeListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TransportModeList);
   return oOut;
}

tBool cfc_spmfi_tclMsgTransportModeListStatus::operator==(const cfc_spmfi_tclMsgTransportModeListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TransportModeList == roRef.TransportModeList);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgResetHistorySet::cfc_spmfi_tclMsgResetHistorySet()
 {}

tS32 cfc_spmfi_tclMsgResetHistorySet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESETHISTORYSET;
}


cfc_spmfi_tclMsgResetHistorySet::~cfc_spmfi_tclMsgResetHistorySet()
{}

//=============================================================================

cfc_spmfi_tclMsgResetHistoryGet::cfc_spmfi_tclMsgResetHistoryGet()
 {}

tS32 cfc_spmfi_tclMsgResetHistoryGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESETHISTORYGET;
}


cfc_spmfi_tclMsgResetHistoryGet::~cfc_spmfi_tclMsgResetHistoryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgResetHistoryStatus::cfc_spmfi_tclMsgResetHistoryStatus(const cfc_spmfi_tclMsgResetHistoryStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tResetList = coRef.tResetList;
}
cfc_spmfi_tclMsgResetHistoryStatus& cfc_spmfi_tclMsgResetHistoryStatus::operator=(const cfc_spmfi_tclMsgResetHistoryStatus& coRef)
{
   if (this == &coRef) return *this;
   tResetList = coRef.tResetList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgResetHistoryStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tResetList.size(); ++u32Idx)
         tResetList[u32Idx].vDestroy();
   tResetList.clear();
   }
}

cfc_spmfi_tclMsgResetHistoryStatus::cfc_spmfi_tclMsgResetHistoryStatus()

 {}

tS32 cfc_spmfi_tclMsgResetHistoryStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_RESETHISTORYSTATUS;
}


cfc_spmfi_tclMsgResetHistoryStatus::~cfc_spmfi_tclMsgResetHistoryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgResetHistoryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tResetList.size()*8);
}

fi_tclInContext& cfc_spmfi_tclMsgResetHistoryStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tResetList.size(); ++u32Idx)
      {
         tResetList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tResetList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tResetList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgResetHistoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tResetList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tResetList.size(); ++u32Idx)
         (tVoid) (oOut << tResetList[u32Idx]);
   }
   return oOut;
}

tBool cfc_spmfi_tclMsgResetHistoryStatus::operator==(const cfc_spmfi_tclMsgResetHistoryStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tResetList.size() == roRef.tResetList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tResetList.size()); ++u32Idx)
            bResult = bResult && (tResetList[u32Idx] == roRef.tResetList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgWakeupHistorySet::cfc_spmfi_tclMsgWakeupHistorySet()
 {}

tS32 cfc_spmfi_tclMsgWakeupHistorySet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_WAKEUPHISTORYSET;
}


cfc_spmfi_tclMsgWakeupHistorySet::~cfc_spmfi_tclMsgWakeupHistorySet()
{}

//=============================================================================

cfc_spmfi_tclMsgWakeupHistoryGet::cfc_spmfi_tclMsgWakeupHistoryGet()
 {}

tS32 cfc_spmfi_tclMsgWakeupHistoryGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_WAKEUPHISTORYGET;
}


cfc_spmfi_tclMsgWakeupHistoryGet::~cfc_spmfi_tclMsgWakeupHistoryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgWakeupHistoryStatus::cfc_spmfi_tclMsgWakeupHistoryStatus(const cfc_spmfi_tclMsgWakeupHistoryStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tWakeupList = coRef.tWakeupList;
}
cfc_spmfi_tclMsgWakeupHistoryStatus& cfc_spmfi_tclMsgWakeupHistoryStatus::operator=(const cfc_spmfi_tclMsgWakeupHistoryStatus& coRef)
{
   if (this == &coRef) return *this;
   tWakeupList = coRef.tWakeupList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgWakeupHistoryStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tWakeupList.size(); ++u32Idx)
         tWakeupList[u32Idx].vDestroy();
   tWakeupList.clear();
   }
}

cfc_spmfi_tclMsgWakeupHistoryStatus::cfc_spmfi_tclMsgWakeupHistoryStatus()

 {}

tS32 cfc_spmfi_tclMsgWakeupHistoryStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_WAKEUPHISTORYSTATUS;
}


cfc_spmfi_tclMsgWakeupHistoryStatus::~cfc_spmfi_tclMsgWakeupHistoryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgWakeupHistoryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tWakeupList.size()*11);
}

fi_tclInContext& cfc_spmfi_tclMsgWakeupHistoryStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tWakeupList.size(); ++u32Idx)
      {
         tWakeupList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tWakeupList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tWakeupList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgWakeupHistoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tWakeupList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tWakeupList.size(); ++u32Idx)
         (tVoid) (oOut << tWakeupList[u32Idx]);
   }
   return oOut;
}

tBool cfc_spmfi_tclMsgWakeupHistoryStatus::operator==(const cfc_spmfi_tclMsgWakeupHistoryStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tWakeupList.size() == roRef.tWakeupList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tWakeupList.size()); ++u32Idx)
            bResult = bResult && (tWakeupList[u32Idx] == roRef.tWakeupList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgStateHistorySet::cfc_spmfi_tclMsgStateHistorySet()
 {}

tS32 cfc_spmfi_tclMsgStateHistorySet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STATEHISTORYSET;
}


cfc_spmfi_tclMsgStateHistorySet::~cfc_spmfi_tclMsgStateHistorySet()
{}

//=============================================================================

cfc_spmfi_tclMsgStateHistoryGet::cfc_spmfi_tclMsgStateHistoryGet()
 {}

tS32 cfc_spmfi_tclMsgStateHistoryGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STATEHISTORYGET;
}


cfc_spmfi_tclMsgStateHistoryGet::~cfc_spmfi_tclMsgStateHistoryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgStateHistoryStatus::cfc_spmfi_tclMsgStateHistoryStatus(const cfc_spmfi_tclMsgStateHistoryStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tStateList = coRef.tStateList;
}
cfc_spmfi_tclMsgStateHistoryStatus& cfc_spmfi_tclMsgStateHistoryStatus::operator=(const cfc_spmfi_tclMsgStateHistoryStatus& coRef)
{
   if (this == &coRef) return *this;
   tStateList = coRef.tStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgStateHistoryStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         tStateList[u32Idx].vDestroy();
   tStateList.clear();
   }
}

cfc_spmfi_tclMsgStateHistoryStatus::cfc_spmfi_tclMsgStateHistoryStatus()

 {}

tS32 cfc_spmfi_tclMsgStateHistoryStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_STATEHISTORYSTATUS;
}


cfc_spmfi_tclMsgStateHistoryStatus::~cfc_spmfi_tclMsgStateHistoryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgStateHistoryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tStateList.size()*41);
}

fi_tclInContext& cfc_spmfi_tclMsgStateHistoryStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
      {
         tStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgStateHistoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         (tVoid) (oOut << tStateList[u32Idx]);
   }
   return oOut;
}

tBool cfc_spmfi_tclMsgStateHistoryStatus::operator==(const cfc_spmfi_tclMsgStateHistoryStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStateList.size() == roRef.tStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateList.size()); ++u32Idx)
            bResult = bResult && (tStateList[u32Idx] == roRef.tStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgErrStateHistory01Set::cfc_spmfi_tclMsgErrStateHistory01Set()
 {}

tS32 cfc_spmfi_tclMsgErrStateHistory01Set::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY01SET;
}


cfc_spmfi_tclMsgErrStateHistory01Set::~cfc_spmfi_tclMsgErrStateHistory01Set()
{}

//=============================================================================

cfc_spmfi_tclMsgErrStateHistory01Get::cfc_spmfi_tclMsgErrStateHistory01Get()
 {}

tS32 cfc_spmfi_tclMsgErrStateHistory01Get::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY01GET;
}


cfc_spmfi_tclMsgErrStateHistory01Get::~cfc_spmfi_tclMsgErrStateHistory01Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgErrStateHistory01Status::cfc_spmfi_tclMsgErrStateHistory01Status(const cfc_spmfi_tclMsgErrStateHistory01Status& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tStateList = coRef.tStateList;
}
cfc_spmfi_tclMsgErrStateHistory01Status& cfc_spmfi_tclMsgErrStateHistory01Status::operator=(const cfc_spmfi_tclMsgErrStateHistory01Status& coRef)
{
   if (this == &coRef) return *this;
   tStateList = coRef.tStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgErrStateHistory01Status::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         tStateList[u32Idx].vDestroy();
   tStateList.clear();
   }
}

cfc_spmfi_tclMsgErrStateHistory01Status::cfc_spmfi_tclMsgErrStateHistory01Status()

 {}

tS32 cfc_spmfi_tclMsgErrStateHistory01Status::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY01STATUS;
}


cfc_spmfi_tclMsgErrStateHistory01Status::~cfc_spmfi_tclMsgErrStateHistory01Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgErrStateHistory01Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tStateList.size()*41);
}

fi_tclInContext& cfc_spmfi_tclMsgErrStateHistory01Status::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
      {
         tStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgErrStateHistory01Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         (tVoid) (oOut << tStateList[u32Idx]);
   }
   return oOut;
}

tBool cfc_spmfi_tclMsgErrStateHistory01Status::operator==(const cfc_spmfi_tclMsgErrStateHistory01Status& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStateList.size() == roRef.tStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateList.size()); ++u32Idx)
            bResult = bResult && (tStateList[u32Idx] == roRef.tStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgErrStateHistory02Set::cfc_spmfi_tclMsgErrStateHistory02Set()
 {}

tS32 cfc_spmfi_tclMsgErrStateHistory02Set::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY02SET;
}


cfc_spmfi_tclMsgErrStateHistory02Set::~cfc_spmfi_tclMsgErrStateHistory02Set()
{}

//=============================================================================

cfc_spmfi_tclMsgErrStateHistory02Get::cfc_spmfi_tclMsgErrStateHistory02Get()
 {}

tS32 cfc_spmfi_tclMsgErrStateHistory02Get::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY02GET;
}


cfc_spmfi_tclMsgErrStateHistory02Get::~cfc_spmfi_tclMsgErrStateHistory02Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgErrStateHistory02Status::cfc_spmfi_tclMsgErrStateHistory02Status(const cfc_spmfi_tclMsgErrStateHistory02Status& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tStateList = coRef.tStateList;
}
cfc_spmfi_tclMsgErrStateHistory02Status& cfc_spmfi_tclMsgErrStateHistory02Status::operator=(const cfc_spmfi_tclMsgErrStateHistory02Status& coRef)
{
   if (this == &coRef) return *this;
   tStateList = coRef.tStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgErrStateHistory02Status::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         tStateList[u32Idx].vDestroy();
   tStateList.clear();
   }
}

cfc_spmfi_tclMsgErrStateHistory02Status::cfc_spmfi_tclMsgErrStateHistory02Status()

 {}

tS32 cfc_spmfi_tclMsgErrStateHistory02Status::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY02STATUS;
}


cfc_spmfi_tclMsgErrStateHistory02Status::~cfc_spmfi_tclMsgErrStateHistory02Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgErrStateHistory02Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tStateList.size()*41);
}

fi_tclInContext& cfc_spmfi_tclMsgErrStateHistory02Status::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
      {
         tStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgErrStateHistory02Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         (tVoid) (oOut << tStateList[u32Idx]);
   }
   return oOut;
}

tBool cfc_spmfi_tclMsgErrStateHistory02Status::operator==(const cfc_spmfi_tclMsgErrStateHistory02Status& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStateList.size() == roRef.tStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateList.size()); ++u32Idx)
            bResult = bResult && (tStateList[u32Idx] == roRef.tStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgErrStateHistory03Set::cfc_spmfi_tclMsgErrStateHistory03Set()
 {}

tS32 cfc_spmfi_tclMsgErrStateHistory03Set::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY03SET;
}


cfc_spmfi_tclMsgErrStateHistory03Set::~cfc_spmfi_tclMsgErrStateHistory03Set()
{}

//=============================================================================

cfc_spmfi_tclMsgErrStateHistory03Get::cfc_spmfi_tclMsgErrStateHistory03Get()
 {}

tS32 cfc_spmfi_tclMsgErrStateHistory03Get::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY03GET;
}


cfc_spmfi_tclMsgErrStateHistory03Get::~cfc_spmfi_tclMsgErrStateHistory03Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgErrStateHistory03Status::cfc_spmfi_tclMsgErrStateHistory03Status(const cfc_spmfi_tclMsgErrStateHistory03Status& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tStateList = coRef.tStateList;
}
cfc_spmfi_tclMsgErrStateHistory03Status& cfc_spmfi_tclMsgErrStateHistory03Status::operator=(const cfc_spmfi_tclMsgErrStateHistory03Status& coRef)
{
   if (this == &coRef) return *this;
   tStateList = coRef.tStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgErrStateHistory03Status::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         tStateList[u32Idx].vDestroy();
   tStateList.clear();
   }
}

cfc_spmfi_tclMsgErrStateHistory03Status::cfc_spmfi_tclMsgErrStateHistory03Status()

 {}

tS32 cfc_spmfi_tclMsgErrStateHistory03Status::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY03STATUS;
}


cfc_spmfi_tclMsgErrStateHistory03Status::~cfc_spmfi_tclMsgErrStateHistory03Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgErrStateHistory03Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tStateList.size()*41);
}

fi_tclInContext& cfc_spmfi_tclMsgErrStateHistory03Status::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
      {
         tStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgErrStateHistory03Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         (tVoid) (oOut << tStateList[u32Idx]);
   }
   return oOut;
}

tBool cfc_spmfi_tclMsgErrStateHistory03Status::operator==(const cfc_spmfi_tclMsgErrStateHistory03Status& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStateList.size() == roRef.tStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateList.size()); ++u32Idx)
            bResult = bResult && (tStateList[u32Idx] == roRef.tStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgErrStateHistory04Set::cfc_spmfi_tclMsgErrStateHistory04Set()
 {}

tS32 cfc_spmfi_tclMsgErrStateHistory04Set::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY04SET;
}


cfc_spmfi_tclMsgErrStateHistory04Set::~cfc_spmfi_tclMsgErrStateHistory04Set()
{}

//=============================================================================

cfc_spmfi_tclMsgErrStateHistory04Get::cfc_spmfi_tclMsgErrStateHistory04Get()
 {}

tS32 cfc_spmfi_tclMsgErrStateHistory04Get::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY04GET;
}


cfc_spmfi_tclMsgErrStateHistory04Get::~cfc_spmfi_tclMsgErrStateHistory04Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgErrStateHistory04Status::cfc_spmfi_tclMsgErrStateHistory04Status(const cfc_spmfi_tclMsgErrStateHistory04Status& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tStateList = coRef.tStateList;
}
cfc_spmfi_tclMsgErrStateHistory04Status& cfc_spmfi_tclMsgErrStateHistory04Status::operator=(const cfc_spmfi_tclMsgErrStateHistory04Status& coRef)
{
   if (this == &coRef) return *this;
   tStateList = coRef.tStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgErrStateHistory04Status::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         tStateList[u32Idx].vDestroy();
   tStateList.clear();
   }
}

cfc_spmfi_tclMsgErrStateHistory04Status::cfc_spmfi_tclMsgErrStateHistory04Status()

 {}

tS32 cfc_spmfi_tclMsgErrStateHistory04Status::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY04STATUS;
}


cfc_spmfi_tclMsgErrStateHistory04Status::~cfc_spmfi_tclMsgErrStateHistory04Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgErrStateHistory04Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tStateList.size()*41);
}

fi_tclInContext& cfc_spmfi_tclMsgErrStateHistory04Status::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
      {
         tStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgErrStateHistory04Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         (tVoid) (oOut << tStateList[u32Idx]);
   }
   return oOut;
}

tBool cfc_spmfi_tclMsgErrStateHistory04Status::operator==(const cfc_spmfi_tclMsgErrStateHistory04Status& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStateList.size() == roRef.tStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateList.size()); ++u32Idx)
            bResult = bResult && (tStateList[u32Idx] == roRef.tStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgErrStateHistory05Set::cfc_spmfi_tclMsgErrStateHistory05Set()
 {}

tS32 cfc_spmfi_tclMsgErrStateHistory05Set::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY05SET;
}


cfc_spmfi_tclMsgErrStateHistory05Set::~cfc_spmfi_tclMsgErrStateHistory05Set()
{}

//=============================================================================

cfc_spmfi_tclMsgErrStateHistory05Get::cfc_spmfi_tclMsgErrStateHistory05Get()
 {}

tS32 cfc_spmfi_tclMsgErrStateHistory05Get::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY05GET;
}


cfc_spmfi_tclMsgErrStateHistory05Get::~cfc_spmfi_tclMsgErrStateHistory05Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgErrStateHistory05Status::cfc_spmfi_tclMsgErrStateHistory05Status(const cfc_spmfi_tclMsgErrStateHistory05Status& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tStateList = coRef.tStateList;
}
cfc_spmfi_tclMsgErrStateHistory05Status& cfc_spmfi_tclMsgErrStateHistory05Status::operator=(const cfc_spmfi_tclMsgErrStateHistory05Status& coRef)
{
   if (this == &coRef) return *this;
   tStateList = coRef.tStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgErrStateHistory05Status::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         tStateList[u32Idx].vDestroy();
   tStateList.clear();
   }
}

cfc_spmfi_tclMsgErrStateHistory05Status::cfc_spmfi_tclMsgErrStateHistory05Status()

 {}

tS32 cfc_spmfi_tclMsgErrStateHistory05Status::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_ERRSTATEHISTORY05STATUS;
}


cfc_spmfi_tclMsgErrStateHistory05Status::~cfc_spmfi_tclMsgErrStateHistory05Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgErrStateHistory05Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tStateList.size()*41);
}

fi_tclInContext& cfc_spmfi_tclMsgErrStateHistory05Status::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
      {
         tStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgErrStateHistory05Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         (tVoid) (oOut << tStateList[u32Idx]);
   }
   return oOut;
}

tBool cfc_spmfi_tclMsgErrStateHistory05Status::operator==(const cfc_spmfi_tclMsgErrStateHistory05Status& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStateList.size() == roRef.tStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateList.size()); ++u32Idx)
            bResult = bResult && (tStateList[u32Idx] == roRef.tStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgSwitchOnHistorySet::cfc_spmfi_tclMsgSwitchOnHistorySet()
 {}

tS32 cfc_spmfi_tclMsgSwitchOnHistorySet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SWITCHONHISTORYSET;
}


cfc_spmfi_tclMsgSwitchOnHistorySet::~cfc_spmfi_tclMsgSwitchOnHistorySet()
{}

//=============================================================================

cfc_spmfi_tclMsgSwitchOnHistoryGet::cfc_spmfi_tclMsgSwitchOnHistoryGet()
 {}

tS32 cfc_spmfi_tclMsgSwitchOnHistoryGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SWITCHONHISTORYGET;
}


cfc_spmfi_tclMsgSwitchOnHistoryGet::~cfc_spmfi_tclMsgSwitchOnHistoryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgSwitchOnHistoryStatus::cfc_spmfi_tclMsgSwitchOnHistoryStatus(const cfc_spmfi_tclMsgSwitchOnHistoryStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   tSwitchOnList = coRef.tSwitchOnList;
}
cfc_spmfi_tclMsgSwitchOnHistoryStatus& cfc_spmfi_tclMsgSwitchOnHistoryStatus::operator=(const cfc_spmfi_tclMsgSwitchOnHistoryStatus& coRef)
{
   if (this == &coRef) return *this;
   tSwitchOnList = coRef.tSwitchOnList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cfc_spmfi_tclMsgSwitchOnHistoryStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tSwitchOnList.size(); ++u32Idx)
         tSwitchOnList[u32Idx].vDestroy();
   tSwitchOnList.clear();
   }
}

cfc_spmfi_tclMsgSwitchOnHistoryStatus::cfc_spmfi_tclMsgSwitchOnHistoryStatus()

 {}

tS32 cfc_spmfi_tclMsgSwitchOnHistoryStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_SWITCHONHISTORYSTATUS;
}


cfc_spmfi_tclMsgSwitchOnHistoryStatus::~cfc_spmfi_tclMsgSwitchOnHistoryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cfc_spmfi_tclMsgSwitchOnHistoryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tSwitchOnList.size()*11);
}

fi_tclInContext& cfc_spmfi_tclMsgSwitchOnHistoryStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tSwitchOnList.size(); ++u32Idx)
      {
         tSwitchOnList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tSwitchOnList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tSwitchOnList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgSwitchOnHistoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tSwitchOnList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tSwitchOnList.size(); ++u32Idx)
         (tVoid) (oOut << tSwitchOnList[u32Idx]);
   }
   return oOut;
}

tBool cfc_spmfi_tclMsgSwitchOnHistoryStatus::operator==(const cfc_spmfi_tclMsgSwitchOnHistoryStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tSwitchOnList.size() == roRef.tSwitchOnList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tSwitchOnList.size()); ++u32Idx)
            bResult = bResult && (tSwitchOnList[u32Idx] == roRef.tSwitchOnList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgVehicleTypeGet::cfc_spmfi_tclMsgVehicleTypeGet()
 {}

tS32 cfc_spmfi_tclMsgVehicleTypeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_VEHICLETYPEGET;
}


cfc_spmfi_tclMsgVehicleTypeGet::~cfc_spmfi_tclMsgVehicleTypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgVehicleTypeStatus::cfc_spmfi_tclMsgVehicleTypeStatus(const cfc_spmfi_tclMsgVehicleTypeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   VehicleType = coRef.VehicleType;
}
cfc_spmfi_tclMsgVehicleTypeStatus& cfc_spmfi_tclMsgVehicleTypeStatus::operator=(const cfc_spmfi_tclMsgVehicleTypeStatus& coRef)
{
   if (this == &coRef) return *this;
   VehicleType = coRef.VehicleType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgVehicleTypeStatus::cfc_spmfi_tclMsgVehicleTypeStatus()
:VehicleType(0)
 {}

tS32 cfc_spmfi_tclMsgVehicleTypeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_VEHICLETYPESTATUS;
}


cfc_spmfi_tclMsgVehicleTypeStatus::~cfc_spmfi_tclMsgVehicleTypeStatus()
{}

tU32 cfc_spmfi_tclMsgVehicleTypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgVehicleTypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VehicleType);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgVehicleTypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VehicleType);
   return oOut;
}

tBool cfc_spmfi_tclMsgVehicleTypeStatus::operator==(const cfc_spmfi_tclMsgVehicleTypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VehicleType == roRef.VehicleType);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgCsmSignalsGet::cfc_spmfi_tclMsgCsmSignalsGet()
 {}

tS32 cfc_spmfi_tclMsgCsmSignalsGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CSMSIGNALSGET;
}


cfc_spmfi_tclMsgCsmSignalsGet::~cfc_spmfi_tclMsgCsmSignalsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgCsmSignalsStatus::cfc_spmfi_tclMsgCsmSignalsStatus(const cfc_spmfi_tclMsgCsmSignalsStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   CsmSignalIgnition = coRef.CsmSignalIgnition;
   CsmSignalVehicleType = coRef.CsmSignalVehicleType;
   CsmSignalDoorState = coRef.CsmSignalDoorState;
   CsmSignalLockState = coRef.CsmSignalLockState;
   CsmSignalPassengerDoorState = coRef.CsmSignalPassengerDoorState;
   CsmSignalLockStateValid = coRef.CsmSignalLockStateValid;
   CsmSignalHmiState = coRef.CsmSignalHmiState;
}
cfc_spmfi_tclMsgCsmSignalsStatus& cfc_spmfi_tclMsgCsmSignalsStatus::operator=(const cfc_spmfi_tclMsgCsmSignalsStatus& coRef)
{
   if (this == &coRef) return *this;
   CsmSignalIgnition = coRef.CsmSignalIgnition;
   CsmSignalVehicleType = coRef.CsmSignalVehicleType;
   CsmSignalDoorState = coRef.CsmSignalDoorState;
   CsmSignalLockState = coRef.CsmSignalLockState;
   CsmSignalPassengerDoorState = coRef.CsmSignalPassengerDoorState;
   CsmSignalLockStateValid = coRef.CsmSignalLockStateValid;
   CsmSignalHmiState = coRef.CsmSignalHmiState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgCsmSignalsStatus::cfc_spmfi_tclMsgCsmSignalsStatus()
:CsmSignalIgnition(0)
,CsmSignalVehicleType(0)
,CsmSignalDoorState(0)
,CsmSignalLockState(0)
,CsmSignalPassengerDoorState(0)
,CsmSignalLockStateValid(0)
,CsmSignalHmiState(0)
 {}

tS32 cfc_spmfi_tclMsgCsmSignalsStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CSMSIGNALSSTATUS;
}


cfc_spmfi_tclMsgCsmSignalsStatus::~cfc_spmfi_tclMsgCsmSignalsStatus()
{}

tU32 cfc_spmfi_tclMsgCsmSignalsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 28;
}

fi_tclInContext& cfc_spmfi_tclMsgCsmSignalsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CsmSignalIgnition);
   (tVoid) (oIn >> CsmSignalVehicleType);
   (tVoid) (oIn >> CsmSignalDoorState);
   (tVoid) (oIn >> CsmSignalLockState);
   (tVoid) (oIn >> CsmSignalPassengerDoorState);
   (tVoid) (oIn >> CsmSignalLockStateValid);
   (tVoid) (oIn >> CsmSignalHmiState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgCsmSignalsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CsmSignalIgnition);
   (tVoid) (oOut << CsmSignalVehicleType);
   (tVoid) (oOut << CsmSignalDoorState);
   (tVoid) (oOut << CsmSignalLockState);
   (tVoid) (oOut << CsmSignalPassengerDoorState);
   (tVoid) (oOut << CsmSignalLockStateValid);
   (tVoid) (oOut << CsmSignalHmiState);
   return oOut;
}

tBool cfc_spmfi_tclMsgCsmSignalsStatus::operator==(const cfc_spmfi_tclMsgCsmSignalsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CsmSignalIgnition == roRef.CsmSignalIgnition);
   bResult = bResult && (CsmSignalVehicleType == roRef.CsmSignalVehicleType);
   bResult = bResult && (CsmSignalDoorState == roRef.CsmSignalDoorState);
   bResult = bResult && (CsmSignalLockState == roRef.CsmSignalLockState);
   bResult = bResult && (CsmSignalPassengerDoorState == roRef.CsmSignalPassengerDoorState);
   bResult = bResult && (CsmSignalLockStateValid == roRef.CsmSignalLockStateValid);
   bResult = bResult && (CsmSignalHmiState == roRef.CsmSignalHmiState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgCsmSignalsUpReg::cfc_spmfi_tclMsgCsmSignalsUpReg()
 {}

tS32 cfc_spmfi_tclMsgCsmSignalsUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CSMSIGNALSUPREG;
}


cfc_spmfi_tclMsgCsmSignalsUpReg::~cfc_spmfi_tclMsgCsmSignalsUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgCsmSignalsRelUpReg::cfc_spmfi_tclMsgCsmSignalsRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgCsmSignalsRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_CSMSIGNALSRELUPREG;
}


cfc_spmfi_tclMsgCsmSignalsRelUpReg::~cfc_spmfi_tclMsgCsmSignalsRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgHwSignalsGet::cfc_spmfi_tclMsgHwSignalsGet()
 {}

tS32 cfc_spmfi_tclMsgHwSignalsGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_HWSIGNALSGET;
}


cfc_spmfi_tclMsgHwSignalsGet::~cfc_spmfi_tclMsgHwSignalsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgHwSignalsStatus::cfc_spmfi_tclMsgHwSignalsStatus(const cfc_spmfi_tclMsgHwSignalsStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   HwSignalsIgnition = coRef.HwSignalsIgnition;
}
cfc_spmfi_tclMsgHwSignalsStatus& cfc_spmfi_tclMsgHwSignalsStatus::operator=(const cfc_spmfi_tclMsgHwSignalsStatus& coRef)
{
   if (this == &coRef) return *this;
   HwSignalsIgnition = coRef.HwSignalsIgnition;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgHwSignalsStatus::cfc_spmfi_tclMsgHwSignalsStatus()
:HwSignalsIgnition(0)
 {}

tS32 cfc_spmfi_tclMsgHwSignalsStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_HWSIGNALSSTATUS;
}


cfc_spmfi_tclMsgHwSignalsStatus::~cfc_spmfi_tclMsgHwSignalsStatus()
{}

tU32 cfc_spmfi_tclMsgHwSignalsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cfc_spmfi_tclMsgHwSignalsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> HwSignalsIgnition);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgHwSignalsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << HwSignalsIgnition);
   return oOut;
}

tBool cfc_spmfi_tclMsgHwSignalsStatus::operator==(const cfc_spmfi_tclMsgHwSignalsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (HwSignalsIgnition == roRef.HwSignalsIgnition);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgPersonalizationEnabledUpReg::cfc_spmfi_tclMsgPersonalizationEnabledUpReg()
 {}

tS32 cfc_spmfi_tclMsgPersonalizationEnabledUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PERSONALIZATIONENABLEDUPREG;
}


cfc_spmfi_tclMsgPersonalizationEnabledUpReg::~cfc_spmfi_tclMsgPersonalizationEnabledUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgPersonalizationEnabledRelUpReg::cfc_spmfi_tclMsgPersonalizationEnabledRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgPersonalizationEnabledRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PERSONALIZATIONENABLEDRELUPREG;
}


cfc_spmfi_tclMsgPersonalizationEnabledRelUpReg::~cfc_spmfi_tclMsgPersonalizationEnabledRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgPersonalizationEnabledGet::cfc_spmfi_tclMsgPersonalizationEnabledGet()
 {}

tS32 cfc_spmfi_tclMsgPersonalizationEnabledGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PERSONALIZATIONENABLEDGET;
}


cfc_spmfi_tclMsgPersonalizationEnabledGet::~cfc_spmfi_tclMsgPersonalizationEnabledGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgPersonalizationEnabledStatus::cfc_spmfi_tclMsgPersonalizationEnabledStatus(const cfc_spmfi_tclMsgPersonalizationEnabledStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   PersonalizationState = coRef.PersonalizationState;
}
cfc_spmfi_tclMsgPersonalizationEnabledStatus& cfc_spmfi_tclMsgPersonalizationEnabledStatus::operator=(const cfc_spmfi_tclMsgPersonalizationEnabledStatus& coRef)
{
   if (this == &coRef) return *this;
   PersonalizationState = coRef.PersonalizationState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgPersonalizationEnabledStatus::cfc_spmfi_tclMsgPersonalizationEnabledStatus()
:PersonalizationState(0)
 {}

tS32 cfc_spmfi_tclMsgPersonalizationEnabledStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PERSONALIZATIONENABLEDSTATUS;
}


cfc_spmfi_tclMsgPersonalizationEnabledStatus::~cfc_spmfi_tclMsgPersonalizationEnabledStatus()
{}

tU32 cfc_spmfi_tclMsgPersonalizationEnabledStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_spmfi_tclMsgPersonalizationEnabledStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PersonalizationState);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgPersonalizationEnabledStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PersonalizationState);
   return oOut;
}

tBool cfc_spmfi_tclMsgPersonalizationEnabledStatus::operator==(const cfc_spmfi_tclMsgPersonalizationEnabledStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PersonalizationState == roRef.PersonalizationState);
   return bResult;
}

//=============================================================================

cfc_spmfi_tclMsgProfileChangeAtRuntimeUpReg::cfc_spmfi_tclMsgProfileChangeAtRuntimeUpReg()
 {}

tS32 cfc_spmfi_tclMsgProfileChangeAtRuntimeUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PROFILECHANGEATRUNTIMEUPREG;
}


cfc_spmfi_tclMsgProfileChangeAtRuntimeUpReg::~cfc_spmfi_tclMsgProfileChangeAtRuntimeUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgProfileChangeAtRuntimeRelUpReg::cfc_spmfi_tclMsgProfileChangeAtRuntimeRelUpReg()
 {}

tS32 cfc_spmfi_tclMsgProfileChangeAtRuntimeRelUpReg::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PROFILECHANGEATRUNTIMERELUPREG;
}


cfc_spmfi_tclMsgProfileChangeAtRuntimeRelUpReg::~cfc_spmfi_tclMsgProfileChangeAtRuntimeRelUpReg()
{}

//=============================================================================

cfc_spmfi_tclMsgProfileChangeAtRuntimeGet::cfc_spmfi_tclMsgProfileChangeAtRuntimeGet()
 {}

tS32 cfc_spmfi_tclMsgProfileChangeAtRuntimeGet::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PROFILECHANGEATRUNTIMEGET;
}


cfc_spmfi_tclMsgProfileChangeAtRuntimeGet::~cfc_spmfi_tclMsgProfileChangeAtRuntimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus::cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus(const cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus& coRef)
   : cfc_spmfi_tclMsgBaseMessage(coRef)
{
   ProfileChangeStatus = coRef.ProfileChangeStatus;
}
cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus& cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus::operator=(const cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus& coRef)
{
   if (this == &coRef) return *this;
   ProfileChangeStatus = coRef.ProfileChangeStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus::cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus()
:ProfileChangeStatus()
 {}

tS32 cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus::s32GetTypeId() const
{
   return (tS32) cfc_spmfi_tclToken::EN_MSG_PROFILECHANGEATRUNTIMESTATUS;
}


cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus::~cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus()
{}

tU32 cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProfileChangeStatus);
   return oIn;
}

fi_tclOutContext& cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProfileChangeStatus);
   return oOut;
}

tBool cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus::operator==(const cfc_spmfi_tclMsgProfileChangeAtRuntimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProfileChangeStatus == roRef.ProfileChangeStatus);
   return bResult;
}

