#ifndef AUX_FIVISITOR_HEADER
#define AUX_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class aux_fi_tclOutput {
public:
   aux_fi_tclOutput();
   virtual ~aux_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class aux_fi_tclFileOutput : public aux_fi_tclOutput 
{
public:
   aux_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   aux_fi_tclFileOutput(); //lint !e1704
   aux_fi_tclFileOutput& operator=(const aux_fi_tclFileOutput& coRef);
   aux_fi_tclFileOutput(const aux_fi_tclFileOutput& coRef); //lint !e1704
};

class aux_fi_tclMemOutput : public aux_fi_tclOutput
{
public:
   aux_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~aux_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   aux_fi_tclMemOutput(); //lint !e1704
   aux_fi_tclMemOutput(const aux_fi_tclMemOutput& coRef); //lint !e1704
   aux_fi_tclMemOutput& operator=(const aux_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL aux_fi_tclVisitorBase {
public:

   // --Konstruktor
   aux_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~aux_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(aux_fi_tclU8& oU8);
   virtual tVoid vVisitS8(aux_fi_tclS8& oS8);
   virtual tVoid vVisitU16(aux_fi_tclU16& oU16);
   virtual tVoid vVisitS16(aux_fi_tclS16& oS16);
   virtual tVoid vVisitU24(aux_fi_tclU24& oU24);
   virtual tVoid vVisitS24(aux_fi_tclS24& oS24);
   virtual tVoid vVisitU32(aux_fi_tclU32& oU32);
   virtual tVoid vVisitS32(aux_fi_tclS32& oS32);
   virtual tVoid vVisitU64(aux_fi_tclU64& oU64);
   virtual tVoid vVisitS64(aux_fi_tclS64& oS64);
   virtual tVoid vVisitF32(aux_fi_tclF32& oF32);
   virtual tVoid vVisitF64(aux_fi_tclF64& oF64);
   virtual tVoid vVisitBool(aux_fi_tclBool& oBool);
   virtual tVoid vVisitString(aux_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(aux_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(aux_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(aux_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(aux_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(aux_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(aux_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(aux_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(aux_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(aux_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(aux_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(aux_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(aux_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(aux_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(aux_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(aux_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(aux_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(aux_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(aux_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(aux_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(aux_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(aux_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(aux_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(aux_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(aux_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(aux_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(aux_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(aux_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(aux_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(aux_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(aux_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(aux_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(aux_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(aux_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(aux_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(aux_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(aux_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(aux_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(aux_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(aux_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(aux_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(aux_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(aux_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(aux_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(aux_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(aux_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(aux_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(aux_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(aux_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(aux_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e8_AUXConfigurationState(aux_fi_tcl_e8_AUXConfigurationState& oe8_AUXConfigurationState);

   virtual tVoid vVisit_e8_AUXAvailabilityState(aux_fi_tcl_e8_AUXAvailabilityState& oe8_AUXAvailabilityState);

   virtual tVoid vVisit_e8_AUXConnectionState(aux_fi_tcl_e8_AUXConnectionState& oe8_AUXConnectionState);

   virtual tVoid vVisit_e8_AUXSwitchState(aux_fi_tcl_e8_AUXSwitchState& oe8_AUXSwitchState);

   virtual tVoid vVisit_AUX_State(aux_fi_tcl_AUX_State& oAUX_State);

   virtual tVoid vVisit_AUX_States(aux_fi_tcl_AUX_States& oAUX_States);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
