/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define AUX_FI_S_IMPORT_INTERFACE_AUX_MAINFI_TYPES
#define AUX_FI_S_IMPORT_INTERFACE_AUX_MAINFI_FUNCTIONIDS
#define AUX_FI_S_IMPORT_INTERFACE_AUX_MAINFI_SERVICEINFO
#include "aux_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for aux_main_fi message types

fi_tclMessageBase* aux_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYUPREG:
         return OSAL_NEW aux_mainfi_tclMsgAvailibilityUpReg;

      case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYRELUPREG:
         return OSAL_NEW aux_mainfi_tclMsgAvailibilityRelUpReg;

      case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYSET:
         return OSAL_NEW aux_mainfi_tclMsgAvailibilitySet;

      case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYGET:
         return OSAL_NEW aux_mainfi_tclMsgAvailibilityGet;

      case aux_mainfi_tclToken::EN_MSG_AVAILIBILITYSTATUS:
         return OSAL_NEW aux_mainfi_tclMsgAvailibilityStatus;

      case aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATEUPREG:
         return OSAL_NEW aux_mainfi_tclMsgConnectionStateUpReg;

      case aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATERELUPREG:
         return OSAL_NEW aux_mainfi_tclMsgConnectionStateRelUpReg;

      case aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATEGET:
         return OSAL_NEW aux_mainfi_tclMsgConnectionStateGet;

      case aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATESTATUS:
         return OSAL_NEW aux_mainfi_tclMsgConnectionStateStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all aux_mainfifi messages

// common functions

tU16 aux_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return AUX_MAINFI_C_U16_SERVICE_ID;
}

tU16 aux_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 aux_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& aux_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& aux_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 aux_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& aux_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& aux_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

aux_mainfi_tclMsgAvailibilityUpReg::aux_mainfi_tclMsgAvailibilityUpReg()
 {}

tS32 aux_mainfi_tclMsgAvailibilityUpReg::s32GetTypeId() const
{
   return (tS32) aux_mainfi_tclToken::EN_MSG_AVAILIBILITYUPREG;
}


aux_mainfi_tclMsgAvailibilityUpReg::~aux_mainfi_tclMsgAvailibilityUpReg()
{}

//=============================================================================

aux_mainfi_tclMsgAvailibilityRelUpReg::aux_mainfi_tclMsgAvailibilityRelUpReg()
 {}

tS32 aux_mainfi_tclMsgAvailibilityRelUpReg::s32GetTypeId() const
{
   return (tS32) aux_mainfi_tclToken::EN_MSG_AVAILIBILITYRELUPREG;
}


aux_mainfi_tclMsgAvailibilityRelUpReg::~aux_mainfi_tclMsgAvailibilityRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
aux_mainfi_tclMsgAvailibilitySet::aux_mainfi_tclMsgAvailibilitySet(const aux_mainfi_tclMsgAvailibilitySet& coRef)
   : aux_mainfi_tclMsgBaseMessage(coRef)
{
   enAUXNumber = coRef.enAUXNumber;
   enAUXAvailState = coRef.enAUXAvailState;
}
aux_mainfi_tclMsgAvailibilitySet& aux_mainfi_tclMsgAvailibilitySet::operator=(const aux_mainfi_tclMsgAvailibilitySet& coRef)
{
   if (this == &coRef) return *this;
   enAUXNumber = coRef.enAUXNumber;
   enAUXAvailState = coRef.enAUXAvailState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

aux_mainfi_tclMsgAvailibilitySet::aux_mainfi_tclMsgAvailibilitySet()
:enAUXNumber(0)
,enAUXAvailState()
 {}

tS32 aux_mainfi_tclMsgAvailibilitySet::s32GetTypeId() const
{
   return (tS32) aux_mainfi_tclToken::EN_MSG_AVAILIBILITYSET;
}


aux_mainfi_tclMsgAvailibilitySet::~aux_mainfi_tclMsgAvailibilitySet()
{}

tU32 aux_mainfi_tclMsgAvailibilitySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& aux_mainfi_tclMsgAvailibilitySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enAUXNumber);
   (tVoid) (oIn >> enAUXAvailState);
   return oIn;
}

fi_tclOutContext& aux_mainfi_tclMsgAvailibilitySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enAUXNumber);
   (tVoid) (oOut << enAUXAvailState);
   return oOut;
}

tBool aux_mainfi_tclMsgAvailibilitySet::operator==(const aux_mainfi_tclMsgAvailibilitySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enAUXNumber == roRef.enAUXNumber);
   bResult = bResult && (enAUXAvailState == roRef.enAUXAvailState);
   return bResult;
}

//=============================================================================

aux_mainfi_tclMsgAvailibilityGet::aux_mainfi_tclMsgAvailibilityGet()
 {}

tS32 aux_mainfi_tclMsgAvailibilityGet::s32GetTypeId() const
{
   return (tS32) aux_mainfi_tclToken::EN_MSG_AVAILIBILITYGET;
}


aux_mainfi_tclMsgAvailibilityGet::~aux_mainfi_tclMsgAvailibilityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
aux_mainfi_tclMsgAvailibilityStatus::aux_mainfi_tclMsgAvailibilityStatus(const aux_mainfi_tclMsgAvailibilityStatus& coRef)
   : aux_mainfi_tclMsgBaseMessage(coRef)
{
   oStates = coRef.oStates;
}
aux_mainfi_tclMsgAvailibilityStatus& aux_mainfi_tclMsgAvailibilityStatus::operator=(const aux_mainfi_tclMsgAvailibilityStatus& coRef)
{
   if (this == &coRef) return *this;
   oStates = coRef.oStates;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid aux_mainfi_tclMsgAvailibilityStatus::vDestroy()
{
   oStates.vDestroy(); 
}

aux_mainfi_tclMsgAvailibilityStatus::aux_mainfi_tclMsgAvailibilityStatus()
:oStates()
 {}

tS32 aux_mainfi_tclMsgAvailibilityStatus::s32GetTypeId() const
{
   return (tS32) aux_mainfi_tclToken::EN_MSG_AVAILIBILITYSTATUS;
}


aux_mainfi_tclMsgAvailibilityStatus::~aux_mainfi_tclMsgAvailibilityStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 aux_mainfi_tclMsgAvailibilityStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oStates.u32GetSize(u16MajorVersion);
}

fi_tclInContext& aux_mainfi_tclMsgAvailibilityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oStates);
   return oIn;
}

fi_tclOutContext& aux_mainfi_tclMsgAvailibilityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oStates);
   return oOut;
}

tBool aux_mainfi_tclMsgAvailibilityStatus::operator==(const aux_mainfi_tclMsgAvailibilityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oStates == roRef.oStates);
   return bResult;
}

//=============================================================================

aux_mainfi_tclMsgConnectionStateUpReg::aux_mainfi_tclMsgConnectionStateUpReg()
 {}

tS32 aux_mainfi_tclMsgConnectionStateUpReg::s32GetTypeId() const
{
   return (tS32) aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATEUPREG;
}


aux_mainfi_tclMsgConnectionStateUpReg::~aux_mainfi_tclMsgConnectionStateUpReg()
{}

//=============================================================================

aux_mainfi_tclMsgConnectionStateRelUpReg::aux_mainfi_tclMsgConnectionStateRelUpReg()
 {}

tS32 aux_mainfi_tclMsgConnectionStateRelUpReg::s32GetTypeId() const
{
   return (tS32) aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATERELUPREG;
}


aux_mainfi_tclMsgConnectionStateRelUpReg::~aux_mainfi_tclMsgConnectionStateRelUpReg()
{}

//=============================================================================

aux_mainfi_tclMsgConnectionStateGet::aux_mainfi_tclMsgConnectionStateGet()
 {}

tS32 aux_mainfi_tclMsgConnectionStateGet::s32GetTypeId() const
{
   return (tS32) aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATEGET;
}


aux_mainfi_tclMsgConnectionStateGet::~aux_mainfi_tclMsgConnectionStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
aux_mainfi_tclMsgConnectionStateStatus::aux_mainfi_tclMsgConnectionStateStatus(const aux_mainfi_tclMsgConnectionStateStatus& coRef)
   : aux_mainfi_tclMsgBaseMessage(coRef)
{
   oStates = coRef.oStates;
}
aux_mainfi_tclMsgConnectionStateStatus& aux_mainfi_tclMsgConnectionStateStatus::operator=(const aux_mainfi_tclMsgConnectionStateStatus& coRef)
{
   if (this == &coRef) return *this;
   oStates = coRef.oStates;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid aux_mainfi_tclMsgConnectionStateStatus::vDestroy()
{
   oStates.vDestroy(); 
}

aux_mainfi_tclMsgConnectionStateStatus::aux_mainfi_tclMsgConnectionStateStatus()
:oStates()
 {}

tS32 aux_mainfi_tclMsgConnectionStateStatus::s32GetTypeId() const
{
   return (tS32) aux_mainfi_tclToken::EN_MSG_CONNECTIONSTATESTATUS;
}


aux_mainfi_tclMsgConnectionStateStatus::~aux_mainfi_tclMsgConnectionStateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 aux_mainfi_tclMsgConnectionStateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oStates.u32GetSize(u16MajorVersion);
}

fi_tclInContext& aux_mainfi_tclMsgConnectionStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oStates);
   return oIn;
}

fi_tclOutContext& aux_mainfi_tclMsgConnectionStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oStates);
   return oOut;
}

tBool aux_mainfi_tclMsgConnectionStateStatus::operator==(const aux_mainfi_tclMsgConnectionStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oStates == roRef.oStates);
   return bResult;
}

