/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "org/bosch/cm/veda/VedaAsf.h"
#include "org/bosch/cm/veda/VedaAsfComponent.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "VedaAsf" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace cm {
namespace veda {

DEFINE_LOGGER_AND_LEVEL (_logger, "/org/bosch/cm/veda/VedaAsf", Info);

/* static */ const char* VedaAsf::asfComponent = "asfComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool VedaAsf_enabledASFSignalHandler = false;

void importVedaAsf() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach VedaAsf, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression0;
        {
            __expression0.setApplicationId(47);
        }
        ccaConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Thread 'AsfClientThread'

    ::asf::core::ComponentContainerSharedPtr AsfClientThread(new ::asf::core::ComponentContainer("AsfClientThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (AsfClientThread);

        // Component 'VedaAsfComponent asfComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::org::bosch::cm::veda::VedaAsfComponent > > asfComponentFactory(new ::asf::core::ComponentFactory< ::org::bosch::cm::veda::VedaAsfComponent >);
        ::asf::core::ComponentDescriptionSharedPtr asfComponentDescription(new ::asf::core::ComponentDescription(1, "asfComponent", /* immediate = */ true, /* threadBridge = */ false, asfComponentFactory));
        AsfClientThread->addComponentDescription(asfComponentDescription);

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& asfComponent_spmFiPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)asfComponent_spmFiPort; // prevent unused variable warning

            // Port 'diaglogFiPort'

            ::asf::core::RequiredPort& asfComponent_diaglogFiPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("diaglog_main_fi", "diaglogFiPort"));
            (void)asfComponent_diaglogFiPort; // prevent unused variable warning

            // Port 'SDSAdapterFiPort'

            ::asf::core::RequiredPort& asfComponent_SDSAdapterFiPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("sds_gui_fi.SdsGuiService", "SDSAdapterFiPort"));
            (void)asfComponent_SDSAdapterFiPort; // prevent unused variable warning

            // Port 'profileFiPort'

            ::asf::core::RequiredPort& asfComponent_profileFiPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.profile", "profileFiPort"));
            (void)asfComponent_profileFiPort; // prevent unused variable warning

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0x00, 1, 2, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_spmFiPort, spmFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& diaglogFiImport = ccaConnector_->importByName (0x0100, 1, 6, 2);
    diaglogFiImport.setServiceName("diaglog_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_diaglogFiPort, diaglogFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& SDSAdapterFiImport = dbusConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_gui_fi/SdsGuiService/SdsAdapter"));
    SDSAdapterFiImport.setServiceName("sds_gui_fi.SdsGuiService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_SDSAdapterFiPort, SDSAdapterFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& profileFiImport = dbusConnector_->importByName (::std::string("app.core.ProfileMngr"), ::std::string("/com/bosch/cm/profileMngr"));
    profileFiImport.setServiceName("bosch.cm.profile");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_profileFiPort, profileFiImport);


    LOG_INFO_STATIC("Starting application 'VedaAsf' version 1.0.0");

    app->start();
}

int executeVedaAsf(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("org.bosch.cm.veda", "VedaAsf");
    } else {
        ::asf::core::Logger::setupLogging ("org.bosch.cm.veda", "VedaAsf", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", VedaAsf_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("org.bosch.cm.veda", "VedaAsf", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create VedaAsf");

    app->enableExceptionHandler(false);

    importVedaAsf();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace veda
} // namespace cm
} // namespace bosch
} // namespace org

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::org::bosch::cm::veda::executeVedaAsf(argc, argv);
}

