/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaConnector.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "org/bosch/cm/timestampsync/TimestampsyncAsf.h"
#include "org/bosch/cm/timestampsync/TimestampsyncAsfComponent.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "TimestampsyncAsf" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace cm {
namespace timestampsync {

DEFINE_LOGGER_AND_LEVEL (_logger, "/org/bosch/cm/timestampsync/TimestampsyncAsf", Info);

/* static */ const char* TimestampsyncAsf::asfComponent = "asfComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool TimestampsyncAsf_enabledASFSignalHandler = false;

void importTimestampsyncAsf() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach TimestampsyncAsf, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression0;
        {
            __expression0.setApplicationId(124);
        }
        ccaConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Thread 'AsfClientThread'

    ::asf::core::ComponentContainerSharedPtr AsfClientThread(new ::asf::core::ComponentContainer("AsfClientThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (AsfClientThread);

        // Component 'TimestampsyncAsfComponent asfComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::org::bosch::cm::timestampsync::TimestampsyncAsfComponent > > asfComponentFactory(new ::asf::core::ComponentFactory< ::org::bosch::cm::timestampsync::TimestampsyncAsfComponent >);
        ::asf::core::ComponentDescriptionSharedPtr asfComponentDescription(new ::asf::core::ComponentDescription(1, "asfComponent", /* immediate = */ true, /* threadBridge = */ false, asfComponentFactory));
        AsfClientThread->addComponentDescription(asfComponentDescription);

            // Port 'echoFiPort'

            ::asf::core::ProvidedPort& asfComponent_echoFiPort = asfComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.incTimeSync.IncTimeSync", "echoFiPort", false, false));
            (void)asfComponent_echoFiPort; // prevent unused variable warning

    // Expression

    dbusConnector_->exportByName (asfComponent_echoFiPort, ::std::string("/com/bosch/cm/timestampsync/server/echo"));


    LOG_INFO_STATIC("Starting application 'TimestampsyncAsf' version 1.0.0");

    app->start();
}

int executeTimestampsyncAsf(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("org.bosch.cm.timestampsync", "TimestampsyncAsf");
    } else {
        ::asf::core::Logger::setupLogging ("org.bosch.cm.timestampsync", "TimestampsyncAsf", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", TimestampsyncAsf_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("org.bosch.cm.timestampsync", "TimestampsyncAsf", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create TimestampsyncAsf");

    app->enableExceptionHandler(true);

    importTimestampsyncAsf();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace timestampsync
} // namespace cm
} // namespace bosch
} // namespace org

int main(int argc, char* argv[]) {
    ::org::bosch::cm::timestampsync::TimestampsyncAsf_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::org::bosch::cm::timestampsync::executeTimestampsyncAsf(argc, argv);
}

