/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "ai_sw_update/common/core/imp/SWUCoreService.h"
#include "ai_sw_update/common/core/imp/SWUCoreServiceConst.h"
#include "ai_sw_update/common/core/imp/SWUCoreServiceDBus.h"
#include "ai_sw_update/common/core/imp/SWUCoreServiceJson.h"
#include "ai_sw_update/common/core/imp/SWUCoreServiceStub.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace ai_sw_update {
namespace common {
namespace core {
namespace imp {
namespace SWUCoreService {

DEFINE_CLASS_LOGGER("/ai_sw_update/common/core/imp/ai_sw_update/common/core/imp/SWUCoreService", SWUCoreServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 10, "SetIsoPath", 4 },
    { 12, "AbortInstall", 2 },
    { 12, "StartInstall", 5 },
    { 17, "ExitUpdateSession", 1 },
    { 18, "EnterUpdateSession", 0 },
    { 19, "ConfigUpdateSession", 6 },
    { 23, "RequestRecoveryDownload", 3 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 8, "Progress", 0 },
    { 8, "UsbFound", 1 },
    { 11, "DisplayText", 2 },
    { 12, "UpdateStates", 3 },
    { 14, "DisplayBgImage", 4 },
};

class SWUCoreServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SWUCoreServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SWUCoreServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SWUCoreServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "ai_sw_update.common.core.imp.SWUCoreService"),
          _logger(logger) {}

    virtual ~SWUCoreServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SWUCoreServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 7, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'EnterUpdateSession'

            LOG_DEBUG_STUB("process method '%s'", "EnterUpdateSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnterUpdateSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EnterUpdateSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EnterUpdateSessionRequest > payload = ::boost::static_pointer_cast<EnterUpdateSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SWUCoreServiceStub*>(getStub())->onEnterUpdateSessionRequest(payload);
            return;
        }
        case 1: {

            // method 'ExitUpdateSession'

            LOG_DEBUG_STUB("process method '%s'", "ExitUpdateSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExitUpdateSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ExitUpdateSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ExitUpdateSessionRequest > payload = ::boost::static_pointer_cast<ExitUpdateSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SWUCoreServiceStub*>(getStub())->onExitUpdateSessionRequest(payload);
            return;
        }
        case 2: {

            // method 'AbortInstall'

            LOG_DEBUG_STUB("process method '%s'", "AbortInstall");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AbortInstallRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AbortInstall", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AbortInstallRequest > payload = ::boost::static_pointer_cast<AbortInstallRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SWUCoreServiceStub*>(getStub())->onAbortInstallRequest(payload);
            return;
        }
        case 3: {

            // method 'RequestRecoveryDownload'

            LOG_DEBUG_STUB("process method '%s'", "RequestRecoveryDownload");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestRecoveryDownloadRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestRecoveryDownload", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestRecoveryDownloadRequest > payload = ::boost::static_pointer_cast<RequestRecoveryDownloadRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SWUCoreServiceStub*>(getStub())->onRequestRecoveryDownloadRequest(payload);
            return;
        }
        case 4: {

            // method 'SetIsoPath'

            LOG_DEBUG_STUB("process method '%s'", "SetIsoPath");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetIsoPathRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetIsoPath", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetIsoPathRequest > payload = ::boost::static_pointer_cast<SetIsoPathRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SWUCoreServiceStub*>(getStub())->onSetIsoPathRequest(payload);
            return;
        }
        case 5: {

            // method 'StartInstall'

            LOG_DEBUG_STUB("process method '%s'", "StartInstall");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartInstallRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartInstall", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartInstallRequest > payload = ::boost::static_pointer_cast<StartInstallRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SWUCoreServiceStub*>(getStub())->onStartInstallRequest(payload);
            return;
        }
        case 6: {

            // method 'ConfigUpdateSession'

            LOG_DEBUG_STUB("process method '%s'", "ConfigUpdateSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConfigUpdateSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ConfigUpdateSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ConfigUpdateSessionRequest > payload = ::boost::static_pointer_cast<ConfigUpdateSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SWUCoreServiceStub*>(getStub())->onConfigUpdateSessionRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SWUCoreServiceStubDelegate::introspect() const {
    return     "<interface name=\"ai_sw_update.common.core.imp.SWUCoreService\">\n"
            "    <property access=\"readwrite\" name=\"Progress\" type=\"((y(u))s(y(u)))\"/>\n"
            "    <property access=\"readwrite\" name=\"UsbFound\" type=\"(bs)\"/>\n"
            "    <property access=\"readwrite\" name=\"DisplayText\" type=\"(sss)\"/>\n"
            "    <property access=\"readwrite\" name=\"UpdateStates\" type=\"(ba(su))\"/>\n"
            "    <property access=\"readwrite\" name=\"DisplayBgImage\" type=\"(ss)\"/>\n"
            "    <method name=\"EnterUpdateSession\">\n"
            "      <doc>\n"
            "        <line>EnterUpdateSession = enter update seesion</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = return value bOk</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ExitUpdateSession\">\n"
            "      <doc>\n"
            "        <line>ExitUpdateSession = exit update session</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = return value bOk</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"AbortInstall\">\n"
            "      <doc>\n"
            "        <line>AbortInstall = abort install</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"inModId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>inModId = in mod Id</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = return value bOk</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"outModId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>outModId = out mod Id</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RequestRecoveryDownload\">\n"
            "      <doc>\n"
            "        <line>RequestRecoveryDownload = request recovery donwload</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = return value bOk</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetIsoPath\">\n"
            "      <doc>\n"
            "        <line>SetIsoPath = set iso path</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"inIsoPath\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>inIsoPath = in iso path</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"rCkSum\" type=\"(utuaays)\">\n"
            "        <doc>\n"
            "          <line>rCkSum (of type trCkSum) = checksum</line>\n"
            "          <line>trCkSum struct[enType, u64Len, u32SegSize, chkSumChunks, encryptParam] = struct of check sum</line>\n"
            "          <line>0: trCkSum.enType ('?') = check sum type</line>\n"
            "          <line>1: trCkSum.u64Len ('t') = file size</line>\n"
            "          <line>2: trCkSum.u32SegSize ('u') = check sum segmentation size</line>\n"
            "          <line>3: trCkSum.chkSumChunks ('?') = check sum chunks</line>\n"
            "          <line>4: trCkSum.encryptParam ('s') = check sum encryptParam</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = return value bOk</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"outIsoPath\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>outIsoPath = out iso path</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StartInstall\">\n"
            "      <doc>\n"
            "        <line>StartInstall = start install,</line>\n"
            "        <line>don't remove the out, otherwise it become fire &amp; forget.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"inModId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>inModId = in mod Id</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"toolsContainer\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>toolsContainer = tools container</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"usbLogPath\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>usbLogPath = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"toolsCksum\" type=\"(utuaays)\">\n"
            "        <doc>\n"
            "          <line>toolsCksum (of type trCkSum) = tools checksum</line>\n"
            "          <line>trCkSum struct[enType, u64Len, u32SegSize, chkSumChunks, encryptParam] = struct of check sum</line>\n"
            "          <line>0: trCkSum.enType ('?') = check sum type</line>\n"
            "          <line>1: trCkSum.u64Len ('t') = file size</line>\n"
            "          <line>2: trCkSum.u32SegSize ('u') = check sum segmentation size</line>\n"
            "          <line>3: trCkSum.chkSumChunks ('?') = check sum chunks</line>\n"
            "          <line>4: trCkSum.encryptParam ('s') = check sum encryptParam</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"dataFile\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>dataFile = data file</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"dataFileDataCksum\" type=\"(utuaays)\">\n"
            "        <doc>\n"
            "          <line>dataFileDataCksum (of type trCkSum) = date file of data checksums</line>\n"
            "          <line>trCkSum struct[enType, u64Len, u32SegSize, chkSumChunks, encryptParam] = struct of check sum</line>\n"
            "          <line>0: trCkSum.enType ('?') = check sum type</line>\n"
            "          <line>1: trCkSum.u64Len ('t') = file size</line>\n"
            "          <line>2: trCkSum.u32SegSize ('u') = check sum segmentation size</line>\n"
            "          <line>3: trCkSum.chkSumChunks ('?') = check sum chunks</line>\n"
            "          <line>4: trCkSum.encryptParam ('s') = check sum encryptParam</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"keyValuePairs\" type=\"(a(ss))\">\n"
            "        <doc>\n"
            "          <line>keyValuePairs = pairs of key / value</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"outModId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>outModId = out mod Id</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"enResult\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enResult (of type tenInstallResult) = install result</line>\n"
            "          <line>enum[OK (0), ERR_TOOLS_CKSUM (1), ERR_DATA_CKSUM (2), ERR_TOOLS_NOT_FOUND (3), ERR_DATA_NOT_FOUND (4), ERR_DEVICE_ERROR (5), ABORD_ON_REQUEST (6), ERR_BUSY (7), ERR_READ (8), ERR_NOT_ENOUGH_MEMORY (9), ERR_UNKNOWN (10), ERR_IMAGE_SIZE (11), ERR_TOOLS_SIZE (12), ERR_IMAGE_INVALID_SECTOR (13), ERR_IMAGE_INCOMPATIBLE_VERSION (14), ERR_IMAGE_READ (15), ERR_IMAGE_FLASHING (16), ERR_DEVICE_NOT_SUPPORTED (17), ERR_DEVICE_NOT_READY (18), ERR_TOOLS_READ (19), RETRY_RECOVERY (20), RETRY_ALL_RECOVERY (21), ERR_MEDIUM_REMOVED (22)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ConfigUpdateSession\">\n"
            "      <doc>\n"
            "        <line>ConfigUpdateSession = config update session</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"modIds\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>modIds = mod Ids</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"StartInstallResponse\">\n"
            "      <doc>\n"
            "        <line>StartInstallResponse = startInstallSuccess signal</line>\n"
            "        <line>callback that is called when StartInstall is done</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"outModId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>outModId = out mod Id</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"enResult\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>enResult (of type tenInstallResult) = install result</line>\n"
            "          <line>enum[OK (0), ERR_TOOLS_CKSUM (1), ERR_DATA_CKSUM (2), ERR_TOOLS_NOT_FOUND (3), ERR_DATA_NOT_FOUND (4), ERR_DEVICE_ERROR (5), ABORD_ON_REQUEST (6), ERR_BUSY (7), ERR_READ (8), ERR_NOT_ENOUGH_MEMORY (9), ERR_UNKNOWN (10), ERR_IMAGE_SIZE (11), ERR_TOOLS_SIZE (12), ERR_IMAGE_INVALID_SECTOR (13), ERR_IMAGE_INCOMPATIBLE_VERSION (14), ERR_IMAGE_READ (15), ERR_IMAGE_FLASHING (16), ERR_DEVICE_NOT_SUPPORTED (17), ERR_DEVICE_NOT_READY (18), ERR_TOOLS_READ (19), RETRY_RECOVERY (20), RETRY_ALL_RECOVERY (21), ERR_MEDIUM_REMOVED (22)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void SWUCoreServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SWUCoreServiceStub*>(getStub()))->onGetAll (properties);
}

void SWUCoreServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 5, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Progress");
            ::boost::shared_ptr< ProgressSet > payload(new ProgressSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SWUCoreServiceStub*>(getStub())->onProgressSet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "UsbFound");
            ::boost::shared_ptr< UsbFoundSet > payload(new UsbFoundSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SWUCoreServiceStub*>(getStub())->onUsbFoundSet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "DisplayText");
            ::boost::shared_ptr< DisplayTextSet > payload(new DisplayTextSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SWUCoreServiceStub*>(getStub())->onDisplayTextSet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateStates");
            ::boost::shared_ptr< UpdateStatesSet > payload(new UpdateStatesSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SWUCoreServiceStub*>(getStub())->onUpdateStatesSet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "DisplayBgImage");
            ::boost::shared_ptr< DisplayBgImageSet > payload(new DisplayBgImageSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SWUCoreServiceStub*>(getStub())->onDisplayBgImageSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SWUCoreServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 5, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Progress");
            ::boost::shared_ptr< ProgressGet > payload(new ProgressGet());
            payload->setAct(act);
            static_cast<SWUCoreServiceStub*>(getStub())->onProgressGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "UsbFound");
            ::boost::shared_ptr< UsbFoundGet > payload(new UsbFoundGet());
            payload->setAct(act);
            static_cast<SWUCoreServiceStub*>(getStub())->onUsbFoundGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "DisplayText");
            ::boost::shared_ptr< DisplayTextGet > payload(new DisplayTextGet());
            payload->setAct(act);
            static_cast<SWUCoreServiceStub*>(getStub())->onDisplayTextGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateStates");
            ::boost::shared_ptr< UpdateStatesGet > payload(new UpdateStatesGet());
            payload->setAct(act);
            static_cast<SWUCoreServiceStub*>(getStub())->onUpdateStatesGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "DisplayBgImage");
            ::boost::shared_ptr< DisplayBgImageGet > payload(new DisplayBgImageGet());
            payload->setAct(act);
            static_cast<SWUCoreServiceStub*>(getStub())->onDisplayBgImageGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SWUCoreServiceStub::SWUCoreServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SWUCoreServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SWUCoreServiceStub::SWUCoreServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SWUCoreServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SWUCoreServiceStub::~SWUCoreServiceStub() {
    delete _stubDelegate;
}

void SWUCoreServiceStub::sendStartInstallResponseSignal(const ::std::string& outModId, tenInstallResult enResult) {
    if (_stubDelegate->isConnected()) {
        StartInstallResponseSignal* payload = new StartInstallResponseSignal(outModId, enResult);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "StartInstallResponse", StartInstallResponseSignal, payload)
        LOG_INFO ("-> send%sSignal", "StartInstallResponse");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "StartInstallResponse");
    }
}

void SWUCoreServiceStub::sendProgressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ProgressUpdate payload(_ProgressProperty);

        LOG_INFO ("-> send%s", "ProgressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Progress", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("ai_sw_update.common.core.imp.SWUCoreService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ProgressUpdate");
    }
}

void SWUCoreServiceStub::onProgressGet(const ::boost::shared_ptr< ProgressGet >& progress) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ProgressGet", progress->getAct());
    sendProgressGetUpdate(_ProgressProperty.getProgress(), progress->getAct());
}

void SWUCoreServiceStub::sendProgressGetUpdate(const trProgress& progress, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ProgressGet payload(progress);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ProgressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SWUCoreServiceStub::onProgressSet(const ::boost::shared_ptr< ProgressSet >& progress) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ProgressSet", progress->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*progress, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setProgress (progress->getProgress());
    sendProgressSetUpdate(progress->getAct());
}

void SWUCoreServiceStub::sendProgressSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ProgressSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SWUCoreServiceStub::setProgress(const trProgress& progress) {
    if(progress!=_ProgressProperty.getProgress()) {
        _ProgressProperty.setProgress(progress);
        sendProgressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trProgress& SWUCoreServiceStub::getProgress() const {
    return _ProgressProperty.getProgress();
}

trProgress& SWUCoreServiceStub::getProgressMutable() {
    return _ProgressProperty.getProgressMutable();
}

void SWUCoreServiceStub::sendUsbFoundUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UsbFoundUpdate payload(_UsbFoundProperty);

        LOG_INFO ("-> send%s", "UsbFoundUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UsbFound", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("ai_sw_update.common.core.imp.SWUCoreService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UsbFoundUpdate");
    }
}

void SWUCoreServiceStub::onUsbFoundGet(const ::boost::shared_ptr< UsbFoundGet >& usbFound) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UsbFoundGet", usbFound->getAct());
    sendUsbFoundGetUpdate(_UsbFoundProperty.getUsbFound(), usbFound->getAct());
}

void SWUCoreServiceStub::sendUsbFoundGetUpdate(const trUsbFound& usbFound, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UsbFoundGet payload(usbFound);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UsbFoundGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SWUCoreServiceStub::onUsbFoundSet(const ::boost::shared_ptr< UsbFoundSet >& usbFound) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UsbFoundSet", usbFound->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*usbFound, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setUsbFound (usbFound->getUsbFound());
    sendUsbFoundSetUpdate(usbFound->getAct());
}

void SWUCoreServiceStub::sendUsbFoundSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UsbFoundSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SWUCoreServiceStub::setUsbFound(const trUsbFound& usbFound) {
    if(usbFound!=_UsbFoundProperty.getUsbFound()) {
        _UsbFoundProperty.setUsbFound(usbFound);
        sendUsbFoundUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trUsbFound& SWUCoreServiceStub::getUsbFound() const {
    return _UsbFoundProperty.getUsbFound();
}

trUsbFound& SWUCoreServiceStub::getUsbFoundMutable() {
    return _UsbFoundProperty.getUsbFoundMutable();
}

void SWUCoreServiceStub::sendDisplayTextUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DisplayTextUpdate payload(_DisplayTextProperty);

        LOG_INFO ("-> send%s", "DisplayTextUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DisplayText", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("ai_sw_update.common.core.imp.SWUCoreService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DisplayTextUpdate");
    }
}

void SWUCoreServiceStub::onDisplayTextGet(const ::boost::shared_ptr< DisplayTextGet >& displayText) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DisplayTextGet", displayText->getAct());
    sendDisplayTextGetUpdate(_DisplayTextProperty.getDisplayText(), displayText->getAct());
}

void SWUCoreServiceStub::sendDisplayTextGetUpdate(const trDisplayText& displayText, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DisplayTextGet payload(displayText);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DisplayTextGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SWUCoreServiceStub::onDisplayTextSet(const ::boost::shared_ptr< DisplayTextSet >& displayText) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DisplayTextSet", displayText->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*displayText, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setDisplayText (displayText->getDisplayText());
    sendDisplayTextSetUpdate(displayText->getAct());
}

void SWUCoreServiceStub::sendDisplayTextSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DisplayTextSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SWUCoreServiceStub::setDisplayText(const trDisplayText& displayText) {
    if(displayText!=_DisplayTextProperty.getDisplayText()) {
        _DisplayTextProperty.setDisplayText(displayText);
        sendDisplayTextUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trDisplayText& SWUCoreServiceStub::getDisplayText() const {
    return _DisplayTextProperty.getDisplayText();
}

trDisplayText& SWUCoreServiceStub::getDisplayTextMutable() {
    return _DisplayTextProperty.getDisplayTextMutable();
}

void SWUCoreServiceStub::sendUpdateStatesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UpdateStatesUpdate payload(_UpdateStatesProperty);

        LOG_INFO ("-> send%s", "UpdateStatesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UpdateStates", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("ai_sw_update.common.core.imp.SWUCoreService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UpdateStatesUpdate");
    }
}

void SWUCoreServiceStub::onUpdateStatesGet(const ::boost::shared_ptr< UpdateStatesGet >& updateStates) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateStatesGet", updateStates->getAct());
    sendUpdateStatesGetUpdate(_UpdateStatesProperty.getUpdateStates(), updateStates->getAct());
}

void SWUCoreServiceStub::sendUpdateStatesGetUpdate(const trUpdateStates& updateStates, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UpdateStatesGet payload(updateStates);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateStatesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SWUCoreServiceStub::onUpdateStatesSet(const ::boost::shared_ptr< UpdateStatesSet >& updateStates) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateStatesSet", updateStates->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*updateStates, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setUpdateStates (updateStates->getUpdateStates());
    sendUpdateStatesSetUpdate(updateStates->getAct());
}

void SWUCoreServiceStub::sendUpdateStatesSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateStatesSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SWUCoreServiceStub::setUpdateStates(const trUpdateStates& updateStates) {
    if(updateStates!=_UpdateStatesProperty.getUpdateStates()) {
        _UpdateStatesProperty.setUpdateStates(updateStates);
        sendUpdateStatesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trUpdateStates& SWUCoreServiceStub::getUpdateStates() const {
    return _UpdateStatesProperty.getUpdateStates();
}

trUpdateStates& SWUCoreServiceStub::getUpdateStatesMutable() {
    return _UpdateStatesProperty.getUpdateStatesMutable();
}

void SWUCoreServiceStub::sendDisplayBgImageUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DisplayBgImageUpdate payload(_DisplayBgImageProperty);

        LOG_INFO ("-> send%s", "DisplayBgImageUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DisplayBgImage", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("ai_sw_update.common.core.imp.SWUCoreService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DisplayBgImageUpdate");
    }
}

void SWUCoreServiceStub::onDisplayBgImageGet(const ::boost::shared_ptr< DisplayBgImageGet >& displayBgImage) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DisplayBgImageGet", displayBgImage->getAct());
    sendDisplayBgImageGetUpdate(_DisplayBgImageProperty.getDisplayBgImage(), displayBgImage->getAct());
}

void SWUCoreServiceStub::sendDisplayBgImageGetUpdate(const trDisplayBgImage& displayBgImage, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DisplayBgImageGet payload(displayBgImage);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DisplayBgImageGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SWUCoreServiceStub::onDisplayBgImageSet(const ::boost::shared_ptr< DisplayBgImageSet >& displayBgImage) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DisplayBgImageSet", displayBgImage->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*displayBgImage, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setDisplayBgImage (displayBgImage->getDisplayBgImage());
    sendDisplayBgImageSetUpdate(displayBgImage->getAct());
}

void SWUCoreServiceStub::sendDisplayBgImageSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DisplayBgImageSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SWUCoreServiceStub::setDisplayBgImage(const trDisplayBgImage& displayBgImage) {
    if(displayBgImage!=_DisplayBgImageProperty.getDisplayBgImage()) {
        _DisplayBgImageProperty.setDisplayBgImage(displayBgImage);
        sendDisplayBgImageUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trDisplayBgImage& SWUCoreServiceStub::getDisplayBgImage() const {
    return _DisplayBgImageProperty.getDisplayBgImage();
}

trDisplayBgImage& SWUCoreServiceStub::getDisplayBgImageMutable() {
    return _DisplayBgImageProperty.getDisplayBgImageMutable();
}

void  SWUCoreServiceStub::sendEnterUpdateSessionResponse (bool bOk, act_t act) {
    EnterUpdateSessionResponse* payload = new EnterUpdateSessionResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "EnterUpdateSession", EnterUpdateSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EnterUpdateSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendEnterUpdateSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EnterUpdateSessionError* payload = new EnterUpdateSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "EnterUpdateSession", EnterUpdateSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EnterUpdateSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendExitUpdateSessionResponse (bool bOk, act_t act) {
    ExitUpdateSessionResponse* payload = new ExitUpdateSessionResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "ExitUpdateSession", ExitUpdateSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ExitUpdateSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendExitUpdateSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ExitUpdateSessionError* payload = new ExitUpdateSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ExitUpdateSession", ExitUpdateSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ExitUpdateSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendAbortInstallResponse (bool bOk, const ::std::string& outModId, act_t act) {
    AbortInstallResponse* payload = new AbortInstallResponse(bOk, outModId);
    DBUS_MESSAGE_REPLY(dbusMessage, "AbortInstall", AbortInstallResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AbortInstall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendAbortInstallError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AbortInstallError* payload = new AbortInstallError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AbortInstall", AbortInstallError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AbortInstall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendRequestRecoveryDownloadResponse (bool bOk, act_t act) {
    RequestRecoveryDownloadResponse* payload = new RequestRecoveryDownloadResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestRecoveryDownload", RequestRecoveryDownloadResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestRecoveryDownload", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendRequestRecoveryDownloadError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestRecoveryDownloadError* payload = new RequestRecoveryDownloadError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestRecoveryDownload", RequestRecoveryDownloadError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestRecoveryDownload", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendSetIsoPathResponse (bool bOk, const ::std::string& outIsoPath, act_t act) {
    SetIsoPathResponse* payload = new SetIsoPathResponse(bOk, outIsoPath);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetIsoPath", SetIsoPathResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetIsoPath", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendSetIsoPathError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetIsoPathError* payload = new SetIsoPathError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetIsoPath", SetIsoPathError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetIsoPath", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendStartInstallResponse (const ::std::string& outModId, tenInstallResult enResult, act_t act) {
    StartInstallResponse* payload = new StartInstallResponse(outModId, enResult);
    DBUS_MESSAGE_REPLY(dbusMessage, "StartInstall", StartInstallResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartInstall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendStartInstallError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartInstallError* payload = new StartInstallError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartInstall", StartInstallError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartInstall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendConfigUpdateSessionResponse (act_t act) {
    ConfigUpdateSessionResponse* payload = new ConfigUpdateSessionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ConfigUpdateSession", ConfigUpdateSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ConfigUpdateSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SWUCoreServiceStub::sendConfigUpdateSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ConfigUpdateSessionError* payload = new ConfigUpdateSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ConfigUpdateSession", ConfigUpdateSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ConfigUpdateSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SWUCoreServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Progress'
    {
        ::asf::dbus::DBusVariant variant;
        ProgressGet payload(_ProgressProperty.getProgress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Progress", variant));
    }

    //property 'UsbFound'
    {
        ::asf::dbus::DBusVariant variant;
        UsbFoundGet payload(_UsbFoundProperty.getUsbFound());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UsbFound", variant));
    }

    //property 'DisplayText'
    {
        ::asf::dbus::DBusVariant variant;
        DisplayTextGet payload(_DisplayTextProperty.getDisplayText());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DisplayText", variant));
    }

    //property 'UpdateStates'
    {
        ::asf::dbus::DBusVariant variant;
        UpdateStatesGet payload(_UpdateStatesProperty.getUpdateStates());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UpdateStates", variant));
    }

    //property 'DisplayBgImage'
    {
        ::asf::dbus::DBusVariant variant;
        DisplayBgImageGet payload(_DisplayBgImageProperty.getDisplayBgImage());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DisplayBgImage", variant));
    }
}

} // namespace SWUCoreService
} // namespace imp
} // namespace core
} // namespace common
} // namespace ai_sw_update
