/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef AI_SW_UPDATE_COMMON_CORE_IMP_SWUCORESERVICECONST_H
#define AI_SW_UPDATE_COMMON_CORE_IMP_SWUCORESERVICECONST_H

#include <cstddef>

/**
 * Download interface.
 */

namespace ai_sw_update {
namespace common {
namespace core {
namespace imp {
namespace SWUCoreService {

/**
 * checksum type
 */
enum tenCkSumType {

    /**
     * NONE
     */
    tenCkSumType__NONE = 0u,
    /**
     * SHA1
     */
    tenCkSumType__SHA1 = 1u,
    /**
     * MD5
     */
    tenCkSumType__MD5 = 2u,
    /**
     * SHA256
     */
    tenCkSumType__SHA256 = 3u

};

bool tenCkSumType_Parse (const char *str, size_t length, tenCkSumType &value);

const char* tenCkSumType_Name (tenCkSumType value);

bool tenCkSumType_IsValid (tenCkSumType value);

/**
 * install results
 */
enum tenInstallResult {

    /**
     * install result: OK - Updated sucessfully
     */
    tenInstallResult__OK = 0u,
    /**
     * install result: ERR_TOOLS_CKSUM - The Checksum of the Tools-File was not correct
     */
    tenInstallResult__ERR_TOOLS_CKSUM = 1u,
    /**
     * install result: ERR_DATA_CKSUM - The Checksum of the Data-File was not correct
     */
    tenInstallResult__ERR_DATA_CKSUM = 2u,
    /**
     * install result: ERR_TOOLS_NOT_FOUND - There is no file at the given Position for the Tools-File
     */
    tenInstallResult__ERR_TOOLS_NOT_FOUND = 3u,
    /**
     * install result: DATA_NOT_FOUND - There is no file at the given Position for the Data-File
     */
    tenInstallResult__ERR_DATA_NOT_FOUND = 4u,
    /**
     * Updating the device failed and no other error fitted.
     */
    tenInstallResult__ERR_DEVICE_ERROR = 5u,
    /**
     * install result: ABORD_ON_REQUEST - The download was stopped up on Request
     */
    tenInstallResult__ABORD_ON_REQUEST = 6u,
    /**
     * install result: ERR_BUSY - Download is busy (another update is running)
     */
    tenInstallResult__ERR_BUSY = 7u,
    /**
     * install result: ERR_READ - Error Reading data (not tools file or data file, these have seperate error code)
     */
    tenInstallResult__ERR_READ = 8u,
    /**
     * install result: ERR_NOT_ENOUGH_MEMORY - Not enogh memory to run the update
     */
    tenInstallResult__ERR_NOT_ENOUGH_MEMORY = 9u,
    /**
     * install result: ERR_UNKNOWN - Any other error, not mentioned here (means, that we should update this list)
     */
    tenInstallResult__ERR_UNKNOWN = 10u,
    /**
     * install result: ERR_IMAGE_SIZE - Image size of Checksum Data does not fit file size
     */
    tenInstallResult__ERR_IMAGE_SIZE = 11u,
    /**
     * install result: ERR_TOOLS_SIZE - Tools size vorm Checksum Data does not fit file size
     */
    tenInstallResult__ERR_TOOLS_SIZE = 12u,
    /**
     * install result: ERR_IMAGE_INVALID_SECTOR - Invalid Data in data file
     */
    tenInstallResult__ERR_IMAGE_INVALID_SECTOR = 13u,
    /**
     * install result: ERR_IMAGE_INCOMPATIBLE_VERSION - The given update data do not fit the available hardware
     */
    tenInstallResult__ERR_IMAGE_INCOMPATIBLE_VERSION = 14u,
    /**
     * install result: ERR_IMAGE_READ - Could not read the data file
     */
    tenInstallResult__ERR_IMAGE_READ = 15u,
    /**
     * install result: ERR_IMAGE_FLASHING - Could not write the data (flashing failed)
     */
    tenInstallResult__ERR_IMAGE_FLASHING = 16u,
    /**
     * install result: ERR_DEVICE_NOT_SUPPORTED - The given module is not supported
     */
    tenInstallResult__ERR_DEVICE_NOT_SUPPORTED = 17u,
    /**
     * install result: ERR_DEVICE_NOT_READY - The given module is not ready to be flashed
     */
    tenInstallResult__ERR_DEVICE_NOT_READY = 18u,
    /**
     * install result: ERR_TOOLS_READ - Could not read the tools file
     */
    tenInstallResult__ERR_TOOLS_READ = 19u,
    /**
     * install result: RETRY_RECOVERY - step has to be repeated in recovery-mode
     */
    tenInstallResult__RETRY_RECOVERY = 20u,
    /**
     * install result: RETRY_ALL_RECOVERY - complete update has to repeated in recovery-mode
     */
    tenInstallResult__RETRY_ALL_RECOVERY = 21u,
    /**
     * install result: ERR_MEDIUM_REMOVED - dl-medium has been removed
     */
    tenInstallResult__ERR_MEDIUM_REMOVED = 22u

};

bool tenInstallResult_Parse (const char *str, size_t length, tenInstallResult &value);

const char* tenInstallResult_Name (tenInstallResult value);

bool tenInstallResult_IsValid (tenInstallResult value);

/**
 * enum update state
 */
enum tenUpdateState {

    /**
     * update state IDLE
     */
    tenUpdateState__IDLE = 0u,
    /**
     * update state RUNNING
     */
    tenUpdateState__RUNNING = 1u,
    /**
     * update stateA BORTING
     */
    tenUpdateState__ABORTING = 2u,
    /**
     * update state ERROR
     */
    tenUpdateState__ERROR = 3u,
    /**
     * update state COMPLETE
     */
    tenUpdateState__COMPLETE = 4u

};

bool tenUpdateState_Parse (const char *str, size_t length, tenUpdateState &value);

const char* tenUpdateState_Name (tenUpdateState value);

bool tenUpdateState_IsValid (tenUpdateState value);

} // namespace SWUCoreService
} // namespace imp
} // namespace core
} // namespace common
} // namespace ai_sw_update

#endif // AI_SW_UPDATE_COMMON_CORE_IMP_SWUCORESERVICECONST_H
