#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef AI_SW_UPDATE_COMMON_CORE_IMP_SWUCORESERVICE_H
#define AI_SW_UPDATE_COMMON_CORE_IMP_SWUCORESERVICE_H

#include "ai_sw_update/common/core/imp/SWUCoreServiceConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Download interface.
 */

namespace ai_sw_update {
namespace common {
namespace core {
namespace imp {
namespace SWUCoreService {

// method IDs
static const uint16 ID_EnterUpdateSession = 0;
static const uint16 ID_ExitUpdateSession = 1;
static const uint16 ID_AbortInstall = 2;
static const uint16 ID_RequestRecoveryDownload = 3;
static const uint16 ID_SetIsoPath = 4;
static const uint16 ID_StartInstall = 5;
static const uint16 ID_ConfigUpdateSession = 6;

// signal IDs
static const uint16 ID_StartInstallResponse = 7;

// property IDs
static const uint16 ID_Progress = 8;
static const uint16 ID_UsbFound = 9;
static const uint16 ID_DisplayText = 10;
static const uint16 ID_UpdateStates = 11;
static const uint16 ID_DisplayBgImage = 12;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 2;

static const int VERSION_PATCH = 0;

// forward declarations
class trCkSum;

class trKeyValuePair;

class trKeyValuePairs;

class trTime;

class trProgressInfo;

class trProgress;

class trUsbFound;

class trDisplayText;

class trUpdateState;

class trUpdateStates;

class trDisplayBgImage;

class EnterUpdateSessionResponse;

class ExitUpdateSessionResponse;

class AbortInstallRequest;

class AbortInstallResponse;

class RequestRecoveryDownloadResponse;

class SetIsoPathRequest;

class SetIsoPathResponse;

class StartInstallRequest;

class StartInstallResponse;

class ConfigUpdateSessionRequest;

class ProgressUpdate;

class ProgressRegister;

class UsbFoundUpdate;

class UsbFoundRegister;

class DisplayTextUpdate;

class DisplayTextRegister;

class UpdateStatesUpdate;

class UpdateStatesRegister;

class DisplayBgImageUpdate;

class DisplayBgImageRegister;

class StartInstallResponseSignal;

// type definitions
/**
 * enter update seesion
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EnterUpdateSessionRequest;

/**
 * If the meaning of "EnterUpdateSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EnterUpdateSessionError;

/**
 * exit update session
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ExitUpdateSessionRequest;

/**
 * If the meaning of "ExitUpdateSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ExitUpdateSessionError;

/**
 * If the meaning of "AbortInstallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AbortInstallError;

/**
 * request recovery donwload
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestRecoveryDownloadRequest;

/**
 * If the meaning of "RequestRecoveryDownloadError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestRecoveryDownloadError;

/**
 * If the meaning of "SetIsoPathError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetIsoPathError;

/**
 * If the meaning of "StartInstallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartInstallError;

/**
 * config update session
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ConfigUpdateSessionResponse;

/**
 * If the meaning of "ConfigUpdateSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConfigUpdateSessionError;

/**
 * indicates sw update progress
 */
typedef ProgressUpdate ProgressSet;

/**
 * indicates sw update progress
 */
typedef ProgressUpdate ProgressGet;

/**
 * If the meaning of "ProgressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProgressError;

/**
 * indicate found USB stick
 */
typedef UsbFoundUpdate UsbFoundSet;

/**
 * indicate found USB stick
 */
typedef UsbFoundUpdate UsbFoundGet;

/**
 * If the meaning of "UsbFoundError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UsbFoundError;

/**
 * download info text
 */
typedef DisplayTextUpdate DisplayTextSet;

/**
 * download info text
 */
typedef DisplayTextUpdate DisplayTextGet;

/**
 * If the meaning of "DisplayTextError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisplayTextError;

/**
 * indicates update state
 */
typedef UpdateStatesUpdate UpdateStatesSet;

/**
 * indicates update state
 */
typedef UpdateStatesUpdate UpdateStatesGet;

/**
 * If the meaning of "UpdateStatesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateStatesError;

/**
 * Background image details
 */
typedef DisplayBgImageUpdate DisplayBgImageSet;

/**
 * Background image details
 */
typedef DisplayBgImageUpdate DisplayBgImageGet;

/**
 * If the meaning of "DisplayBgImageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisplayBgImageError;

/**
 * If the meaning of "StartInstallResponseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartInstallResponseError;


/**
 * struct of check sum
 */
class trCkSum {
public:

    /**
     * Default constructor
     */
    inline  trCkSum ();

    /**
     * Copy constructor
     */
    inline  trCkSum (const trCkSum &rhs);

    /**
     * All fields constructor
     */
    inline  trCkSum (tenCkSumType enType_, uint64 u64Len_, uint32 u32SegSize_, const ::std::vector< ::std::vector< uint8 > >& chkSumChunks_, const ::std::string& encryptParam_);

    /**
     * Destructor
     */
    inline  ~trCkSum();

    /**
     * Assignment operator
     */
    inline trCkSum& operator = (const trCkSum& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trCkSum& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trCkSum& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trCkSum& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trCkSum& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enType"

    static const int kEnType = 0;

    /**
     * Clears the field "enType".
     *
     * The field will be set to its default value. The hasEnType()
     * method will return false.
     */
    inline void clearEnType();

    /**
     * Checks whether the field "enType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnType()). Otherwise it will return false.
     */
    inline bool hasEnType () const;

    /**
     * Returns the value of the member "enType".
     *
     * check sum type
     *
     * @return The value of the field "enType"
     */
    inline tenCkSumType getEnType () const;

    /**
     * Sets the value of the member "enType".
     *
     * check sum type
     *
     * @param enType The value which will be set
     */
    inline void setEnType (tenCkSumType enType_);

    // API of field "u64Len"

    static const int kU64Len = 1;

    /**
     * Clears the field "u64Len".
     *
     * The field will be set to its default value. The hasU64Len()
     * method will return false.
     */
    inline void clearU64Len();

    /**
     * Checks whether the field "u64Len" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64Len()). Otherwise it will return false.
     */
    inline bool hasU64Len () const;

    /**
     * Returns the value of the member "u64Len".
     *
     * file size
     *
     * @return The value of the field "u64Len"
     */
    inline uint64 getU64Len () const;

    /**
     * Sets the value of the member "u64Len".
     *
     * file size
     *
     * @param u64Len The value which will be set
     */
    inline void setU64Len (uint64 u64Len_);

    // API of field "u32SegSize"

    static const int kU32SegSize = 2;

    /**
     * Clears the field "u32SegSize".
     *
     * The field will be set to its default value. The hasU32SegSize()
     * method will return false.
     */
    inline void clearU32SegSize();

    /**
     * Checks whether the field "u32SegSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SegSize()). Otherwise it will return false.
     */
    inline bool hasU32SegSize () const;

    /**
     * Returns the value of the member "u32SegSize".
     *
     * check sum segmentation size
     *
     * @return The value of the field "u32SegSize"
     */
    inline uint32 getU32SegSize () const;

    /**
     * Sets the value of the member "u32SegSize".
     *
     * check sum segmentation size
     *
     * @param u32SegSize The value which will be set
     */
    inline void setU32SegSize (uint32 u32SegSize_);

    // API of field "chkSumChunks"

    static const int kChkSumChunks = 3;

    /**
     * Clears the field "chkSumChunks".
     *
     * The field will be set to its default value. The hasChkSumChunks()
     * method will return false.
     */
    inline void clearChkSumChunks();

    /**
     * Checks whether the field "chkSumChunks" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChkSumChunks()). Otherwise it will return false.
     */
    inline bool hasChkSumChunks () const;

    /**
     * Returns the value of the member "chkSumChunks".
     *
     * check sum chunks
     *
     * @return The value of the field "chkSumChunks"
     */
    inline const ::std::vector< ::std::vector< uint8 > >& getChkSumChunks () const;

    /**
     * Retrieves the value of the field "chkSumChunks" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "chkSumChunks".
     */
    inline ::std::vector< ::std::vector< uint8 > >& getChkSumChunksMutable ();

    /**
     * Sets the value of the member "chkSumChunks".
     *
     * check sum chunks
     *
     * @param chkSumChunks The value which will be set
     */
    inline void setChkSumChunks (const ::std::vector< ::std::vector< uint8 > >& chkSumChunks_);

    // API of field "encryptParam"

    static const int kEncryptParam = 4;

    /**
     * Clears the field "encryptParam".
     *
     * The field will be set to its default value. The hasEncryptParam()
     * method will return false.
     */
    inline void clearEncryptParam();

    /**
     * Checks whether the field "encryptParam" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncryptParam()). Otherwise it will return false.
     */
    inline bool hasEncryptParam () const;

    /**
     * Returns the value of the member "encryptParam".
     *
     * check sum encryptParam
     *
     * @return The value of the field "encryptParam"
     */
    inline const ::std::string& getEncryptParam () const;

    /**
     * Retrieves the value of the field "encryptParam" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "encryptParam".
     */
    inline ::std::string& getEncryptParamMutable ();

    /**
     * Sets the value of the member "encryptParam".
     *
     * check sum encryptParam
     *
     * @param encryptParam The value which will be set
     */
    inline void setEncryptParam (const ::std::string& encryptParam_);

    /**
     * Sets the value of the member "encryptParam".
     *
     * check sum encryptParam
     *
     * @param encryptParam The value which will be set
     */
    inline void setEncryptParam (const char* encryptParam_);

    /**
     * Sets the value of the member "encryptParam".
     *
     * check sum encryptParam
     *
     * @param encryptParam The value which will be set
     */
    inline void setEncryptParam (const char* value, size_t size);

    static const trCkSum &getDefaultInstance();

private:

    static const ::std::vector< ::std::vector< uint8 > >& getUint8List_List_DefaultInstance ();

    inline void set_has_enType ();

    inline void clear_has_enType ();

    inline void set_has_u64Len ();

    inline void clear_has_u64Len ();

    inline void set_has_u32SegSize ();

    inline void clear_has_u32SegSize ();

    inline void set_has_chkSumChunks ();

    inline void clear_has_chkSumChunks ();

    inline void set_has_encryptParam ();

    inline void clear_has_encryptParam ();

    uint32 _has_bits_[ (5 + 31) / 32];

    tenCkSumType _enType;

    uint64 _u64Len;

    uint32 _u32SegSize;

    ::std::vector< ::std::vector< uint8 > > _chkSumChunks;

    ::std::string _encryptParam;

};

/**
 * pair of key / value
 */
class trKeyValuePair {
public:

    /**
     * Default constructor
     */
    inline  trKeyValuePair ();

    /**
     * Copy constructor
     */
    inline  trKeyValuePair (const trKeyValuePair &rhs);

    /**
     * All fields constructor
     */
    inline  trKeyValuePair (const ::std::string& key_, const ::std::string& value_);

    /**
     * Destructor
     */
    inline  ~trKeyValuePair();

    /**
     * Assignment operator
     */
    inline trKeyValuePair& operator = (const trKeyValuePair& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trKeyValuePair& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trKeyValuePair& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trKeyValuePair& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trKeyValuePair& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "key"

    static const int kKey = 0;

    /**
     * Clears the field "key".
     *
     * The field will be set to its default value. The hasKey()
     * method will return false.
     */
    inline void clearKey();

    /**
     * Checks whether the field "key" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKey()). Otherwise it will return false.
     */
    inline bool hasKey () const;

    /**
     * Returns the value of the member "key".
     *
     * key
     *
     * @return The value of the field "key"
     */
    inline const ::std::string& getKey () const;

    /**
     * Retrieves the value of the field "key" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "key".
     */
    inline ::std::string& getKeyMutable ();

    /**
     * Sets the value of the member "key".
     *
     * key
     *
     * @param key The value which will be set
     */
    inline void setKey (const ::std::string& key_);

    /**
     * Sets the value of the member "key".
     *
     * key
     *
     * @param key The value which will be set
     */
    inline void setKey (const char* key_);

    /**
     * Sets the value of the member "key".
     *
     * key
     *
     * @param key The value which will be set
     */
    inline void setKey (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * value
     *
     * @return The value of the field "value"
     */
    inline const ::std::string& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::std::string& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * value
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::std::string& value_);

    /**
     * Sets the value of the member "value".
     *
     * value
     *
     * @param value The value which will be set
     */
    inline void setValue (const char* value_);

    /**
     * Sets the value of the member "value".
     *
     * value
     *
     * @param value The value which will be set
     */
    inline void setValue (const char* value, size_t size);

    static const trKeyValuePair &getDefaultInstance();

private:

    inline void set_has_key ();

    inline void clear_has_key ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _key;

    ::std::string _value;

};

/**
 * If the meaning of "trKeyValuePairs" isn't clear, then there should be a description here.
 */
class trKeyValuePairs {
public:

    /**
     * Default constructor
     */
    inline  trKeyValuePairs ();

    /**
     * Copy constructor
     */
    inline  trKeyValuePairs (const trKeyValuePairs &rhs);

    /**
     * All fields constructor
     */
    inline  trKeyValuePairs (const ::std::vector< trKeyValuePair >& rKeyValuePair_);

    /**
     * Destructor
     */
    inline  ~trKeyValuePairs();

    /**
     * Assignment operator
     */
    inline trKeyValuePairs& operator = (const trKeyValuePairs& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trKeyValuePairs& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trKeyValuePairs& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trKeyValuePairs& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trKeyValuePairs& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rKeyValuePair"

    static const int kRKeyValuePair = 0;

    /**
     * Clears the field "rKeyValuePair".
     *
     * The field will be set to its default value. The hasRKeyValuePair()
     * method will return false.
     */
    inline void clearRKeyValuePair();

    /**
     * Checks whether the field "rKeyValuePair" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRKeyValuePair()). Otherwise it will return false.
     */
    inline bool hasRKeyValuePair () const;

    /**
     * Returns the value of the member "rKeyValuePair".
     *
     * If the meaning of "rKeyValuePair" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rKeyValuePair"
     */
    inline const ::std::vector< trKeyValuePair >& getRKeyValuePair () const;

    /**
     * Retrieves the value of the field "rKeyValuePair" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rKeyValuePair".
     */
    inline ::std::vector< trKeyValuePair >& getRKeyValuePairMutable ();

    /**
     * Sets the value of the member "rKeyValuePair".
     *
     * If the meaning of "rKeyValuePair" isn't clear, then there should be a description here.
     *
     * @param rKeyValuePair The value which will be set
     */
    inline void setRKeyValuePair (const ::std::vector< trKeyValuePair >& rKeyValuePair_);

    static const trKeyValuePairs &getDefaultInstance();

private:

    static const ::std::vector< trKeyValuePair >& getTrKeyValuePairList_DefaultInstance ();

    inline void set_has_rKeyValuePair ();

    inline void clear_has_rKeyValuePair ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< trKeyValuePair > _rKeyValuePair;

};

/**
 * struct of time
 */
class trTime {
public:

    /**
     * Default constructor
     */
    inline  trTime ();

    /**
     * Copy constructor
     */
    inline  trTime (const trTime &rhs);

    /**
     * All fields constructor
     */
    inline  trTime (uint32 u32Seconds_);

    /**
     * Destructor
     */
    inline  ~trTime();

    /**
     * Assignment operator
     */
    inline trTime& operator = (const trTime& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trTime& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trTime& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trTime& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trTime& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Seconds"

    static const int kU32Seconds = 0;

    /**
     * Clears the field "u32Seconds".
     *
     * The field will be set to its default value. The hasU32Seconds()
     * method will return false.
     */
    inline void clearU32Seconds();

    /**
     * Checks whether the field "u32Seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Seconds()). Otherwise it will return false.
     */
    inline bool hasU32Seconds () const;

    /**
     * Returns the value of the member "u32Seconds".
     *
     * seconds
     *
     * @return The value of the field "u32Seconds"
     */
    inline uint32 getU32Seconds () const;

    /**
     * Sets the value of the member "u32Seconds".
     *
     * seconds
     *
     * @param u32Seconds The value which will be set
     */
    inline void setU32Seconds (uint32 u32Seconds_);

    static const trTime &getDefaultInstance();

private:

    inline void set_has_u32Seconds ();

    inline void clear_has_u32Seconds ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Seconds;

};

/**
 * struct of progress info
 */
class trProgressInfo {
public:

    /**
     * Default constructor
     */
    inline  trProgressInfo ();

    /**
     * Copy constructor
     */
    inline  trProgressInfo (const trProgressInfo &rhs);

    /**
     * All fields constructor
     */
    inline  trProgressInfo (uint8 u8Percent_, const trTime& time_);

    /**
     * Destructor
     */
    inline  ~trProgressInfo();

    /**
     * Assignment operator
     */
    inline trProgressInfo& operator = (const trProgressInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trProgressInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trProgressInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trProgressInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trProgressInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Percent"

    static const int kU8Percent = 0;

    /**
     * Clears the field "u8Percent".
     *
     * The field will be set to its default value. The hasU8Percent()
     * method will return false.
     */
    inline void clearU8Percent();

    /**
     * Checks whether the field "u8Percent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Percent()). Otherwise it will return false.
     */
    inline bool hasU8Percent () const;

    /**
     * Returns the value of the member "u8Percent".
     *
     * progress info precent
     *
     * @return The value of the field "u8Percent"
     */
    inline uint8 getU8Percent () const;

    /**
     * Sets the value of the member "u8Percent".
     *
     * progress info precent
     *
     * @param u8Percent The value which will be set
     */
    inline void setU8Percent (uint8 u8Percent_);

    // API of field "time"

    static const int kTime = 1;

    /**
     * Clears the field "time".
     *
     * The field will be set to its default value. The hasTime()
     * method will return false.
     */
    inline void clearTime();

    /**
     * Checks whether the field "time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTime()). Otherwise it will return false.
     */
    inline bool hasTime () const;

    /**
     * Returns the value of the member "time".
     *
     * progress info time
     *
     * @return The value of the field "time"
     */
    inline const trTime& getTime () const;

    /**
     * Retrieves the value of the field "time" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "time".
     */
    inline trTime& getTimeMutable ();

    /**
     * Sets the value of the member "time".
     *
     * progress info time
     *
     * @param time The value which will be set
     */
    inline void setTime (const trTime& time_);

    static const trProgressInfo &getDefaultInstance();

private:

    inline void set_has_u8Percent ();

    inline void clear_has_u8Percent ();

    inline void set_has_time ();

    inline void clear_has_time ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8Percent;

    trTime _time;

};

/**
 * struct of progress
 */
class trProgress {
public:

    /**
     * Default constructor
     */
    inline  trProgress ();

    /**
     * Copy constructor
     */
    inline  trProgress (const trProgress &rhs);

    /**
     * All fields constructor
     */
    inline  trProgress (const trProgressInfo& progressOverall_, const ::std::string& curModId_, const trProgressInfo& progressModId_);

    /**
     * Destructor
     */
    inline  ~trProgress();

    /**
     * Assignment operator
     */
    inline trProgress& operator = (const trProgress& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trProgress& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trProgress& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trProgress& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trProgress& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "progressOverall"

    static const int kProgressOverall = 0;

    /**
     * Clears the field "progressOverall".
     *
     * The field will be set to its default value. The hasProgressOverall()
     * method will return false.
     */
    inline void clearProgressOverall();

    /**
     * Checks whether the field "progressOverall" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProgressOverall()). Otherwise it will return false.
     */
    inline bool hasProgressOverall () const;

    /**
     * Returns the value of the member "progressOverall".
     *
     * overall progress
     *
     * @return The value of the field "progressOverall"
     */
    inline const trProgressInfo& getProgressOverall () const;

    /**
     * Retrieves the value of the field "progressOverall" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "progressOverall".
     */
    inline trProgressInfo& getProgressOverallMutable ();

    /**
     * Sets the value of the member "progressOverall".
     *
     * overall progress
     *
     * @param progressOverall The value which will be set
     */
    inline void setProgressOverall (const trProgressInfo& progressOverall_);

    // API of field "curModId"

    static const int kCurModId = 1;

    /**
     * Clears the field "curModId".
     *
     * The field will be set to its default value. The hasCurModId()
     * method will return false.
     */
    inline void clearCurModId();

    /**
     * Checks whether the field "curModId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurModId()). Otherwise it will return false.
     */
    inline bool hasCurModId () const;

    /**
     * Returns the value of the member "curModId".
     *
     * current modId
     *
     * @return The value of the field "curModId"
     */
    inline const ::std::string& getCurModId () const;

    /**
     * Retrieves the value of the field "curModId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "curModId".
     */
    inline ::std::string& getCurModIdMutable ();

    /**
     * Sets the value of the member "curModId".
     *
     * current modId
     *
     * @param curModId The value which will be set
     */
    inline void setCurModId (const ::std::string& curModId_);

    /**
     * Sets the value of the member "curModId".
     *
     * current modId
     *
     * @param curModId The value which will be set
     */
    inline void setCurModId (const char* curModId_);

    /**
     * Sets the value of the member "curModId".
     *
     * current modId
     *
     * @param curModId The value which will be set
     */
    inline void setCurModId (const char* value, size_t size);

    // API of field "progressModId"

    static const int kProgressModId = 2;

    /**
     * Clears the field "progressModId".
     *
     * The field will be set to its default value. The hasProgressModId()
     * method will return false.
     */
    inline void clearProgressModId();

    /**
     * Checks whether the field "progressModId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProgressModId()). Otherwise it will return false.
     */
    inline bool hasProgressModId () const;

    /**
     * Returns the value of the member "progressModId".
     *
     * progress with modId
     *
     * @return The value of the field "progressModId"
     */
    inline const trProgressInfo& getProgressModId () const;

    /**
     * Retrieves the value of the field "progressModId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "progressModId".
     */
    inline trProgressInfo& getProgressModIdMutable ();

    /**
     * Sets the value of the member "progressModId".
     *
     * progress with modId
     *
     * @param progressModId The value which will be set
     */
    inline void setProgressModId (const trProgressInfo& progressModId_);

    static const trProgress &getDefaultInstance();

private:

    inline void set_has_progressOverall ();

    inline void clear_has_progressOverall ();

    inline void set_has_curModId ();

    inline void clear_has_curModId ();

    inline void set_has_progressModId ();

    inline void clear_has_progressModId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    trProgressInfo _progressOverall;

    ::std::string _curModId;

    trProgressInfo _progressModId;

};

/**
 * struct for usb
 */
class trUsbFound {
public:

    /**
     * Default constructor
     */
    inline  trUsbFound ();

    /**
     * Copy constructor
     */
    inline  trUsbFound (const trUsbFound &rhs);

    /**
     * All fields constructor
     */
    inline  trUsbFound (bool bFound_, const ::std::string& path_);

    /**
     * Destructor
     */
    inline  ~trUsbFound();

    /**
     * Assignment operator
     */
    inline trUsbFound& operator = (const trUsbFound& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trUsbFound& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trUsbFound& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trUsbFound& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trUsbFound& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bFound"

    static const int kBFound = 0;

    /**
     * Clears the field "bFound".
     *
     * The field will be set to its default value. The hasBFound()
     * method will return false.
     */
    inline void clearBFound();

    /**
     * Checks whether the field "bFound" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBFound()). Otherwise it will return false.
     */
    inline bool hasBFound () const;

    /**
     * Returns the value of the member "bFound".
     *
     * USB stick found
     *
     * @return The value of the field "bFound"
     */
    inline bool getBFound () const;

    /**
     * Sets the value of the member "bFound".
     *
     * USB stick found
     *
     * @param bFound The value which will be set
     */
    inline void setBFound (bool bFound_);

    // API of field "path"

    static const int kPath = 1;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * path
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * path
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * path
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * path
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const trUsbFound &getDefaultInstance();

private:

    inline void set_has_bFound ();

    inline void clear_has_bFound ();

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bFound;

    ::std::string _path;

};

/**
 * display text
 */
class trDisplayText {
public:

    /**
     * Default constructor
     */
    inline  trDisplayText ();

    /**
     * Copy constructor
     */
    inline  trDisplayText (const trDisplayText &rhs);

    /**
     * All fields constructor
     */
    inline  trDisplayText (const ::std::string& line1_, const ::std::string& line2_, const ::std::string& luaCmd_);

    /**
     * Destructor
     */
    inline  ~trDisplayText();

    /**
     * Assignment operator
     */
    inline trDisplayText& operator = (const trDisplayText& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trDisplayText& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trDisplayText& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trDisplayText& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trDisplayText& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "line1"

    static const int kLine1 = 0;

    /**
     * Clears the field "line1".
     *
     * The field will be set to its default value. The hasLine1()
     * method will return false.
     */
    inline void clearLine1();

    /**
     * Checks whether the field "line1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLine1()). Otherwise it will return false.
     */
    inline bool hasLine1 () const;

    /**
     * Returns the value of the member "line1".
     *
     * text line 1
     *
     * @return The value of the field "line1"
     */
    inline const ::std::string& getLine1 () const;

    /**
     * Retrieves the value of the field "line1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "line1".
     */
    inline ::std::string& getLine1Mutable ();

    /**
     * Sets the value of the member "line1".
     *
     * text line 1
     *
     * @param line1 The value which will be set
     */
    inline void setLine1 (const ::std::string& line1_);

    /**
     * Sets the value of the member "line1".
     *
     * text line 1
     *
     * @param line1 The value which will be set
     */
    inline void setLine1 (const char* line1_);

    /**
     * Sets the value of the member "line1".
     *
     * text line 1
     *
     * @param line1 The value which will be set
     */
    inline void setLine1 (const char* value, size_t size);

    // API of field "line2"

    static const int kLine2 = 1;

    /**
     * Clears the field "line2".
     *
     * The field will be set to its default value. The hasLine2()
     * method will return false.
     */
    inline void clearLine2();

    /**
     * Checks whether the field "line2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLine2()). Otherwise it will return false.
     */
    inline bool hasLine2 () const;

    /**
     * Returns the value of the member "line2".
     *
     * text line 2
     *
     * @return The value of the field "line2"
     */
    inline const ::std::string& getLine2 () const;

    /**
     * Retrieves the value of the field "line2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "line2".
     */
    inline ::std::string& getLine2Mutable ();

    /**
     * Sets the value of the member "line2".
     *
     * text line 2
     *
     * @param line2 The value which will be set
     */
    inline void setLine2 (const ::std::string& line2_);

    /**
     * Sets the value of the member "line2".
     *
     * text line 2
     *
     * @param line2 The value which will be set
     */
    inline void setLine2 (const char* line2_);

    /**
     * Sets the value of the member "line2".
     *
     * text line 2
     *
     * @param line2 The value which will be set
     */
    inline void setLine2 (const char* value, size_t size);

    // API of field "luaCmd"

    static const int kLuaCmd = 2;

    /**
     * Clears the field "luaCmd".
     *
     * The field will be set to its default value. The hasLuaCmd()
     * method will return false.
     */
    inline void clearLuaCmd();

    /**
     * Checks whether the field "luaCmd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLuaCmd()). Otherwise it will return false.
     */
    inline bool hasLuaCmd () const;

    /**
     * Returns the value of the member "luaCmd".
     *
     * If the meaning of "luaCmd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "luaCmd"
     */
    inline const ::std::string& getLuaCmd () const;

    /**
     * Retrieves the value of the field "luaCmd" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "luaCmd".
     */
    inline ::std::string& getLuaCmdMutable ();

    /**
     * Sets the value of the member "luaCmd".
     *
     * If the meaning of "luaCmd" isn't clear, then there should be a description here.
     *
     * @param luaCmd The value which will be set
     */
    inline void setLuaCmd (const ::std::string& luaCmd_);

    /**
     * Sets the value of the member "luaCmd".
     *
     * If the meaning of "luaCmd" isn't clear, then there should be a description here.
     *
     * @param luaCmd The value which will be set
     */
    inline void setLuaCmd (const char* luaCmd_);

    /**
     * Sets the value of the member "luaCmd".
     *
     * If the meaning of "luaCmd" isn't clear, then there should be a description here.
     *
     * @param luaCmd The value which will be set
     */
    inline void setLuaCmd (const char* value, size_t size);

    static const trDisplayText &getDefaultInstance();

private:

    inline void set_has_line1 ();

    inline void clear_has_line1 ();

    inline void set_has_line2 ();

    inline void clear_has_line2 ();

    inline void set_has_luaCmd ();

    inline void clear_has_luaCmd ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _line1;

    ::std::string _line2;

    ::std::string _luaCmd;

};

/**
 * struct for update state
 */
class trUpdateState {
public:

    /**
     * Default constructor
     */
    inline  trUpdateState ();

    /**
     * Copy constructor
     */
    inline  trUpdateState (const trUpdateState &rhs);

    /**
     * All fields constructor
     */
    inline  trUpdateState (const ::std::string& modId_, tenUpdateState enState_);

    /**
     * Destructor
     */
    inline  ~trUpdateState();

    /**
     * Assignment operator
     */
    inline trUpdateState& operator = (const trUpdateState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trUpdateState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trUpdateState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trUpdateState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trUpdateState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "modId"

    static const int kModId = 0;

    /**
     * Clears the field "modId".
     *
     * The field will be set to its default value. The hasModId()
     * method will return false.
     */
    inline void clearModId();

    /**
     * Checks whether the field "modId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setModId()). Otherwise it will return false.
     */
    inline bool hasModId () const;

    /**
     * Returns the value of the member "modId".
     *
     * modId
     *
     * @return The value of the field "modId"
     */
    inline const ::std::string& getModId () const;

    /**
     * Retrieves the value of the field "modId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "modId".
     */
    inline ::std::string& getModIdMutable ();

    /**
     * Sets the value of the member "modId".
     *
     * modId
     *
     * @param modId The value which will be set
     */
    inline void setModId (const ::std::string& modId_);

    /**
     * Sets the value of the member "modId".
     *
     * modId
     *
     * @param modId The value which will be set
     */
    inline void setModId (const char* modId_);

    /**
     * Sets the value of the member "modId".
     *
     * modId
     *
     * @param modId The value which will be set
     */
    inline void setModId (const char* value, size_t size);

    // API of field "enState"

    static const int kEnState = 1;

    /**
     * Clears the field "enState".
     *
     * The field will be set to its default value. The hasEnState()
     * method will return false.
     */
    inline void clearEnState();

    /**
     * Checks whether the field "enState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnState()). Otherwise it will return false.
     */
    inline bool hasEnState () const;

    /**
     * Returns the value of the member "enState".
     *
     * update state
     *
     * @return The value of the field "enState"
     */
    inline tenUpdateState getEnState () const;

    /**
     * Sets the value of the member "enState".
     *
     * update state
     *
     * @param enState The value which will be set
     */
    inline void setEnState (tenUpdateState enState_);

    static const trUpdateState &getDefaultInstance();

private:

    inline void set_has_modId ();

    inline void clear_has_modId ();

    inline void set_has_enState ();

    inline void clear_has_enState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _modId;

    tenUpdateState _enState;

};

/**
 * infos to update state
 */
class trUpdateStates {
public:

    /**
     * Default constructor
     */
    inline  trUpdateStates ();

    /**
     * Copy constructor
     */
    inline  trUpdateStates (const trUpdateStates &rhs);

    /**
     * All fields constructor
     */
    inline  trUpdateStates (bool bSessionActive_, const ::std::vector< trUpdateState >& states_);

    /**
     * Destructor
     */
    inline  ~trUpdateStates();

    /**
     * Assignment operator
     */
    inline trUpdateStates& operator = (const trUpdateStates& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trUpdateStates& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trUpdateStates& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trUpdateStates& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trUpdateStates& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSessionActive"

    static const int kBSessionActive = 0;

    /**
     * Clears the field "bSessionActive".
     *
     * The field will be set to its default value. The hasBSessionActive()
     * method will return false.
     */
    inline void clearBSessionActive();

    /**
     * Checks whether the field "bSessionActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSessionActive()). Otherwise it will return false.
     */
    inline bool hasBSessionActive () const;

    /**
     * Returns the value of the member "bSessionActive".
     *
     * update session is active
     *
     * @return The value of the field "bSessionActive"
     */
    inline bool getBSessionActive () const;

    /**
     * Sets the value of the member "bSessionActive".
     *
     * update session is active
     *
     * @param bSessionActive The value which will be set
     */
    inline void setBSessionActive (bool bSessionActive_);

    // API of field "states"

    static const int kStates = 1;

    /**
     * Clears the field "states".
     *
     * The field will be set to its default value. The hasStates()
     * method will return false.
     */
    inline void clearStates();

    /**
     * Checks whether the field "states" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStates()). Otherwise it will return false.
     */
    inline bool hasStates () const;

    /**
     * Returns the value of the member "states".
     *
     * update states
     *
     * @return The value of the field "states"
     */
    inline const ::std::vector< trUpdateState >& getStates () const;

    /**
     * Retrieves the value of the field "states" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "states".
     */
    inline ::std::vector< trUpdateState >& getStatesMutable ();

    /**
     * Sets the value of the member "states".
     *
     * update states
     *
     * @param states The value which will be set
     */
    inline void setStates (const ::std::vector< trUpdateState >& states_);

    static const trUpdateStates &getDefaultInstance();

private:

    static const ::std::vector< trUpdateState >& getTrUpdateStateList_DefaultInstance ();

    inline void set_has_bSessionActive ();

    inline void clear_has_bSessionActive ();

    inline void set_has_states ();

    inline void clear_has_states ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bSessionActive;

    ::std::vector< trUpdateState > _states;

};

/**
 * Background image details
 */
class trDisplayBgImage {
public:

    /**
     * Default constructor
     */
    inline  trDisplayBgImage ();

    /**
     * Copy constructor
     */
    inline  trDisplayBgImage (const trDisplayBgImage &rhs);

    /**
     * All fields constructor
     */
    inline  trDisplayBgImage (const ::std::string& imgDirPath_, const ::std::string& imgName_);

    /**
     * Destructor
     */
    inline  ~trDisplayBgImage();

    /**
     * Assignment operator
     */
    inline trDisplayBgImage& operator = (const trDisplayBgImage& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trDisplayBgImage& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trDisplayBgImage& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trDisplayBgImage& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trDisplayBgImage& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "imgDirPath"

    static const int kImgDirPath = 0;

    /**
     * Clears the field "imgDirPath".
     *
     * The field will be set to its default value. The hasImgDirPath()
     * method will return false.
     */
    inline void clearImgDirPath();

    /**
     * Checks whether the field "imgDirPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImgDirPath()). Otherwise it will return false.
     */
    inline bool hasImgDirPath () const;

    /**
     * Returns the value of the member "imgDirPath".
     *
     * Background image dir path
     *
     * @return The value of the field "imgDirPath"
     */
    inline const ::std::string& getImgDirPath () const;

    /**
     * Retrieves the value of the field "imgDirPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "imgDirPath".
     */
    inline ::std::string& getImgDirPathMutable ();

    /**
     * Sets the value of the member "imgDirPath".
     *
     * Background image dir path
     *
     * @param imgDirPath The value which will be set
     */
    inline void setImgDirPath (const ::std::string& imgDirPath_);

    /**
     * Sets the value of the member "imgDirPath".
     *
     * Background image dir path
     *
     * @param imgDirPath The value which will be set
     */
    inline void setImgDirPath (const char* imgDirPath_);

    /**
     * Sets the value of the member "imgDirPath".
     *
     * Background image dir path
     *
     * @param imgDirPath The value which will be set
     */
    inline void setImgDirPath (const char* value, size_t size);

    // API of field "imgName"

    static const int kImgName = 1;

    /**
     * Clears the field "imgName".
     *
     * The field will be set to its default value. The hasImgName()
     * method will return false.
     */
    inline void clearImgName();

    /**
     * Checks whether the field "imgName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImgName()). Otherwise it will return false.
     */
    inline bool hasImgName () const;

    /**
     * Returns the value of the member "imgName".
     *
     * Background image name
     *
     * @return The value of the field "imgName"
     */
    inline const ::std::string& getImgName () const;

    /**
     * Retrieves the value of the field "imgName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "imgName".
     */
    inline ::std::string& getImgNameMutable ();

    /**
     * Sets the value of the member "imgName".
     *
     * Background image name
     *
     * @param imgName The value which will be set
     */
    inline void setImgName (const ::std::string& imgName_);

    /**
     * Sets the value of the member "imgName".
     *
     * Background image name
     *
     * @param imgName The value which will be set
     */
    inline void setImgName (const char* imgName_);

    /**
     * Sets the value of the member "imgName".
     *
     * Background image name
     *
     * @param imgName The value which will be set
     */
    inline void setImgName (const char* value, size_t size);

    static const trDisplayBgImage &getDefaultInstance();

private:

    inline void set_has_imgDirPath ();

    inline void clear_has_imgDirPath ();

    inline void set_has_imgName ();

    inline void clear_has_imgName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _imgDirPath;

    ::std::string _imgName;

};

/**
 * enter update seesion
 */
class EnterUpdateSessionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnterUpdateSessionResponse ();

    /**
     * Copy constructor
     */
    inline  EnterUpdateSessionResponse (const EnterUpdateSessionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EnterUpdateSessionResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~EnterUpdateSessionResponse();

    /**
     * Assignment operator
     */
    inline EnterUpdateSessionResponse& operator = (const EnterUpdateSessionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnterUpdateSessionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnterUpdateSessionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnterUpdateSessionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnterUpdateSessionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * return value bOk
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * return value bOk
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const EnterUpdateSessionResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * exit update session
 */
class ExitUpdateSessionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ExitUpdateSessionResponse ();

    /**
     * Copy constructor
     */
    inline  ExitUpdateSessionResponse (const ExitUpdateSessionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ExitUpdateSessionResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~ExitUpdateSessionResponse();

    /**
     * Assignment operator
     */
    inline ExitUpdateSessionResponse& operator = (const ExitUpdateSessionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExitUpdateSessionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExitUpdateSessionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExitUpdateSessionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExitUpdateSessionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * return value bOk
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * return value bOk
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const ExitUpdateSessionResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * abort install
 */
class AbortInstallRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AbortInstallRequest ();

    /**
     * Copy constructor
     */
    inline  AbortInstallRequest (const AbortInstallRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AbortInstallRequest (const ::std::string& inModId_);

    /**
     * Destructor
     */
    inline virtual  ~AbortInstallRequest();

    /**
     * Assignment operator
     */
    inline AbortInstallRequest& operator = (const AbortInstallRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbortInstallRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbortInstallRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbortInstallRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbortInstallRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "inModId"

    static const int kInModId = 0;

    /**
     * Clears the field "inModId".
     *
     * The field will be set to its default value. The hasInModId()
     * method will return false.
     */
    inline void clearInModId();

    /**
     * Checks whether the field "inModId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInModId()). Otherwise it will return false.
     */
    inline bool hasInModId () const;

    /**
     * Returns the value of the member "inModId".
     *
     * in mod Id
     *
     * @return The value of the field "inModId"
     */
    inline const ::std::string& getInModId () const;

    /**
     * Retrieves the value of the field "inModId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "inModId".
     */
    inline ::std::string& getInModIdMutable ();

    /**
     * Sets the value of the member "inModId".
     *
     * in mod Id
     *
     * @param inModId The value which will be set
     */
    inline void setInModId (const ::std::string& inModId_);

    /**
     * Sets the value of the member "inModId".
     *
     * in mod Id
     *
     * @param inModId The value which will be set
     */
    inline void setInModId (const char* inModId_);

    /**
     * Sets the value of the member "inModId".
     *
     * in mod Id
     *
     * @param inModId The value which will be set
     */
    inline void setInModId (const char* value, size_t size);

    static const AbortInstallRequest &getDefaultInstance();

private:

    inline void set_has_inModId ();

    inline void clear_has_inModId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _inModId;

};

/**
 * abort install
 */
class AbortInstallResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AbortInstallResponse ();

    /**
     * Copy constructor
     */
    inline  AbortInstallResponse (const AbortInstallResponse &rhs);

    /**
     * All fields constructor
     */
    inline  AbortInstallResponse (bool bOk_, const ::std::string& outModId_);

    /**
     * Destructor
     */
    inline virtual  ~AbortInstallResponse();

    /**
     * Assignment operator
     */
    inline AbortInstallResponse& operator = (const AbortInstallResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbortInstallResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbortInstallResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbortInstallResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbortInstallResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * return value bOk
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * return value bOk
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "outModId"

    static const int kOutModId = 1;

    /**
     * Clears the field "outModId".
     *
     * The field will be set to its default value. The hasOutModId()
     * method will return false.
     */
    inline void clearOutModId();

    /**
     * Checks whether the field "outModId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOutModId()). Otherwise it will return false.
     */
    inline bool hasOutModId () const;

    /**
     * Returns the value of the member "outModId".
     *
     * out mod Id
     *
     * @return The value of the field "outModId"
     */
    inline const ::std::string& getOutModId () const;

    /**
     * Retrieves the value of the field "outModId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "outModId".
     */
    inline ::std::string& getOutModIdMutable ();

    /**
     * Sets the value of the member "outModId".
     *
     * out mod Id
     *
     * @param outModId The value which will be set
     */
    inline void setOutModId (const ::std::string& outModId_);

    /**
     * Sets the value of the member "outModId".
     *
     * out mod Id
     *
     * @param outModId The value which will be set
     */
    inline void setOutModId (const char* outModId_);

    /**
     * Sets the value of the member "outModId".
     *
     * out mod Id
     *
     * @param outModId The value which will be set
     */
    inline void setOutModId (const char* value, size_t size);

    static const AbortInstallResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_outModId ();

    inline void clear_has_outModId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    ::std::string _outModId;

};

/**
 * request recovery donwload
 */
class RequestRecoveryDownloadResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestRecoveryDownloadResponse ();

    /**
     * Copy constructor
     */
    inline  RequestRecoveryDownloadResponse (const RequestRecoveryDownloadResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestRecoveryDownloadResponse (bool bOk_);

    /**
     * Destructor
     */
    inline virtual  ~RequestRecoveryDownloadResponse();

    /**
     * Assignment operator
     */
    inline RequestRecoveryDownloadResponse& operator = (const RequestRecoveryDownloadResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestRecoveryDownloadResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestRecoveryDownloadResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestRecoveryDownloadResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestRecoveryDownloadResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * return value bOk
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * return value bOk
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    static const RequestRecoveryDownloadResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bOk;

};

/**
 * set iso path
 */
class SetIsoPathRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetIsoPathRequest ();

    /**
     * Copy constructor
     */
    inline  SetIsoPathRequest (const SetIsoPathRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetIsoPathRequest (const ::std::string& inIsoPath_, const trCkSum& rCkSum_);

    /**
     * Destructor
     */
    inline virtual  ~SetIsoPathRequest();

    /**
     * Assignment operator
     */
    inline SetIsoPathRequest& operator = (const SetIsoPathRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetIsoPathRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetIsoPathRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetIsoPathRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetIsoPathRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "inIsoPath"

    static const int kInIsoPath = 0;

    /**
     * Clears the field "inIsoPath".
     *
     * The field will be set to its default value. The hasInIsoPath()
     * method will return false.
     */
    inline void clearInIsoPath();

    /**
     * Checks whether the field "inIsoPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInIsoPath()). Otherwise it will return false.
     */
    inline bool hasInIsoPath () const;

    /**
     * Returns the value of the member "inIsoPath".
     *
     * in iso path
     *
     * @return The value of the field "inIsoPath"
     */
    inline const ::std::string& getInIsoPath () const;

    /**
     * Retrieves the value of the field "inIsoPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "inIsoPath".
     */
    inline ::std::string& getInIsoPathMutable ();

    /**
     * Sets the value of the member "inIsoPath".
     *
     * in iso path
     *
     * @param inIsoPath The value which will be set
     */
    inline void setInIsoPath (const ::std::string& inIsoPath_);

    /**
     * Sets the value of the member "inIsoPath".
     *
     * in iso path
     *
     * @param inIsoPath The value which will be set
     */
    inline void setInIsoPath (const char* inIsoPath_);

    /**
     * Sets the value of the member "inIsoPath".
     *
     * in iso path
     *
     * @param inIsoPath The value which will be set
     */
    inline void setInIsoPath (const char* value, size_t size);

    // API of field "rCkSum"

    static const int kRCkSum = 1;

    /**
     * Clears the field "rCkSum".
     *
     * The field will be set to its default value. The hasRCkSum()
     * method will return false.
     */
    inline void clearRCkSum();

    /**
     * Checks whether the field "rCkSum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCkSum()). Otherwise it will return false.
     */
    inline bool hasRCkSum () const;

    /**
     * Returns the value of the member "rCkSum".
     *
     * checksum
     *
     * @return The value of the field "rCkSum"
     */
    inline const trCkSum& getRCkSum () const;

    /**
     * Retrieves the value of the field "rCkSum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCkSum".
     */
    inline trCkSum& getRCkSumMutable ();

    /**
     * Sets the value of the member "rCkSum".
     *
     * checksum
     *
     * @param rCkSum The value which will be set
     */
    inline void setRCkSum (const trCkSum& rCkSum_);

    static const SetIsoPathRequest &getDefaultInstance();

private:

    inline void set_has_inIsoPath ();

    inline void clear_has_inIsoPath ();

    inline void set_has_rCkSum ();

    inline void clear_has_rCkSum ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _inIsoPath;

    trCkSum _rCkSum;

};

/**
 * set iso path
 */
class SetIsoPathResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetIsoPathResponse ();

    /**
     * Copy constructor
     */
    inline  SetIsoPathResponse (const SetIsoPathResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetIsoPathResponse (bool bOk_, const ::std::string& outIsoPath_);

    /**
     * Destructor
     */
    inline virtual  ~SetIsoPathResponse();

    /**
     * Assignment operator
     */
    inline SetIsoPathResponse& operator = (const SetIsoPathResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetIsoPathResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetIsoPathResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetIsoPathResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetIsoPathResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOk"

    static const int kBOk = 0;

    /**
     * Clears the field "bOk".
     *
     * The field will be set to its default value. The hasBOk()
     * method will return false.
     */
    inline void clearBOk();

    /**
     * Checks whether the field "bOk" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOk()). Otherwise it will return false.
     */
    inline bool hasBOk () const;

    /**
     * Returns the value of the member "bOk".
     *
     * return value bOk
     *
     * @return The value of the field "bOk"
     */
    inline bool getBOk () const;

    /**
     * Sets the value of the member "bOk".
     *
     * return value bOk
     *
     * @param bOk The value which will be set
     */
    inline void setBOk (bool bOk_);

    // API of field "outIsoPath"

    static const int kOutIsoPath = 1;

    /**
     * Clears the field "outIsoPath".
     *
     * The field will be set to its default value. The hasOutIsoPath()
     * method will return false.
     */
    inline void clearOutIsoPath();

    /**
     * Checks whether the field "outIsoPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOutIsoPath()). Otherwise it will return false.
     */
    inline bool hasOutIsoPath () const;

    /**
     * Returns the value of the member "outIsoPath".
     *
     * out iso path
     *
     * @return The value of the field "outIsoPath"
     */
    inline const ::std::string& getOutIsoPath () const;

    /**
     * Retrieves the value of the field "outIsoPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "outIsoPath".
     */
    inline ::std::string& getOutIsoPathMutable ();

    /**
     * Sets the value of the member "outIsoPath".
     *
     * out iso path
     *
     * @param outIsoPath The value which will be set
     */
    inline void setOutIsoPath (const ::std::string& outIsoPath_);

    /**
     * Sets the value of the member "outIsoPath".
     *
     * out iso path
     *
     * @param outIsoPath The value which will be set
     */
    inline void setOutIsoPath (const char* outIsoPath_);

    /**
     * Sets the value of the member "outIsoPath".
     *
     * out iso path
     *
     * @param outIsoPath The value which will be set
     */
    inline void setOutIsoPath (const char* value, size_t size);

    static const SetIsoPathResponse &getDefaultInstance();

private:

    inline void set_has_bOk ();

    inline void clear_has_bOk ();

    inline void set_has_outIsoPath ();

    inline void clear_has_outIsoPath ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bOk;

    ::std::string _outIsoPath;

};

/**
 * start install,
 *                           don't remove the out, otherwise it become fire & forget.
 */
class StartInstallRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartInstallRequest ();

    /**
     * Copy constructor
     */
    inline  StartInstallRequest (const StartInstallRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartInstallRequest (const ::std::string& inModId_, const ::std::string& toolsContainer_, const ::std::string& usbLogPath_, const trCkSum& toolsCksum_, const ::std::string& dataFile_, const trCkSum& dataFileDataCksum_, const trKeyValuePairs& keyValuePairs_);

    /**
     * Destructor
     */
    inline virtual  ~StartInstallRequest();

    /**
     * Assignment operator
     */
    inline StartInstallRequest& operator = (const StartInstallRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartInstallRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartInstallRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartInstallRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartInstallRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "inModId"

    static const int kInModId = 0;

    /**
     * Clears the field "inModId".
     *
     * The field will be set to its default value. The hasInModId()
     * method will return false.
     */
    inline void clearInModId();

    /**
     * Checks whether the field "inModId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInModId()). Otherwise it will return false.
     */
    inline bool hasInModId () const;

    /**
     * Returns the value of the member "inModId".
     *
     * in mod Id
     *
     * @return The value of the field "inModId"
     */
    inline const ::std::string& getInModId () const;

    /**
     * Retrieves the value of the field "inModId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "inModId".
     */
    inline ::std::string& getInModIdMutable ();

    /**
     * Sets the value of the member "inModId".
     *
     * in mod Id
     *
     * @param inModId The value which will be set
     */
    inline void setInModId (const ::std::string& inModId_);

    /**
     * Sets the value of the member "inModId".
     *
     * in mod Id
     *
     * @param inModId The value which will be set
     */
    inline void setInModId (const char* inModId_);

    /**
     * Sets the value of the member "inModId".
     *
     * in mod Id
     *
     * @param inModId The value which will be set
     */
    inline void setInModId (const char* value, size_t size);

    // API of field "toolsContainer"

    static const int kToolsContainer = 1;

    /**
     * Clears the field "toolsContainer".
     *
     * The field will be set to its default value. The hasToolsContainer()
     * method will return false.
     */
    inline void clearToolsContainer();

    /**
     * Checks whether the field "toolsContainer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setToolsContainer()). Otherwise it will return false.
     */
    inline bool hasToolsContainer () const;

    /**
     * Returns the value of the member "toolsContainer".
     *
     * tools container
     *
     * @return The value of the field "toolsContainer"
     */
    inline const ::std::string& getToolsContainer () const;

    /**
     * Retrieves the value of the field "toolsContainer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "toolsContainer".
     */
    inline ::std::string& getToolsContainerMutable ();

    /**
     * Sets the value of the member "toolsContainer".
     *
     * tools container
     *
     * @param toolsContainer The value which will be set
     */
    inline void setToolsContainer (const ::std::string& toolsContainer_);

    /**
     * Sets the value of the member "toolsContainer".
     *
     * tools container
     *
     * @param toolsContainer The value which will be set
     */
    inline void setToolsContainer (const char* toolsContainer_);

    /**
     * Sets the value of the member "toolsContainer".
     *
     * tools container
     *
     * @param toolsContainer The value which will be set
     */
    inline void setToolsContainer (const char* value, size_t size);

    // API of field "usbLogPath"

    static const int kUsbLogPath = 2;

    /**
     * Clears the field "usbLogPath".
     *
     * The field will be set to its default value. The hasUsbLogPath()
     * method will return false.
     */
    inline void clearUsbLogPath();

    /**
     * Checks whether the field "usbLogPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUsbLogPath()). Otherwise it will return false.
     */
    inline bool hasUsbLogPath () const;

    /**
     * Returns the value of the member "usbLogPath".
     *
     * If the meaning of "usbLogPath" isn't clear, then there should be a description here.
     *
     * @return The value of the field "usbLogPath"
     */
    inline const ::std::string& getUsbLogPath () const;

    /**
     * Retrieves the value of the field "usbLogPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "usbLogPath".
     */
    inline ::std::string& getUsbLogPathMutable ();

    /**
     * Sets the value of the member "usbLogPath".
     *
     * If the meaning of "usbLogPath" isn't clear, then there should be a description here.
     *
     * @param usbLogPath The value which will be set
     */
    inline void setUsbLogPath (const ::std::string& usbLogPath_);

    /**
     * Sets the value of the member "usbLogPath".
     *
     * If the meaning of "usbLogPath" isn't clear, then there should be a description here.
     *
     * @param usbLogPath The value which will be set
     */
    inline void setUsbLogPath (const char* usbLogPath_);

    /**
     * Sets the value of the member "usbLogPath".
     *
     * If the meaning of "usbLogPath" isn't clear, then there should be a description here.
     *
     * @param usbLogPath The value which will be set
     */
    inline void setUsbLogPath (const char* value, size_t size);

    // API of field "toolsCksum"

    static const int kToolsCksum = 3;

    /**
     * Clears the field "toolsCksum".
     *
     * The field will be set to its default value. The hasToolsCksum()
     * method will return false.
     */
    inline void clearToolsCksum();

    /**
     * Checks whether the field "toolsCksum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setToolsCksum()). Otherwise it will return false.
     */
    inline bool hasToolsCksum () const;

    /**
     * Returns the value of the member "toolsCksum".
     *
     * tools checksum
     *
     * @return The value of the field "toolsCksum"
     */
    inline const trCkSum& getToolsCksum () const;

    /**
     * Retrieves the value of the field "toolsCksum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "toolsCksum".
     */
    inline trCkSum& getToolsCksumMutable ();

    /**
     * Sets the value of the member "toolsCksum".
     *
     * tools checksum
     *
     * @param toolsCksum The value which will be set
     */
    inline void setToolsCksum (const trCkSum& toolsCksum_);

    // API of field "dataFile"

    static const int kDataFile = 4;

    /**
     * Clears the field "dataFile".
     *
     * The field will be set to its default value. The hasDataFile()
     * method will return false.
     */
    inline void clearDataFile();

    /**
     * Checks whether the field "dataFile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataFile()). Otherwise it will return false.
     */
    inline bool hasDataFile () const;

    /**
     * Returns the value of the member "dataFile".
     *
     * data file
     *
     * @return The value of the field "dataFile"
     */
    inline const ::std::string& getDataFile () const;

    /**
     * Retrieves the value of the field "dataFile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dataFile".
     */
    inline ::std::string& getDataFileMutable ();

    /**
     * Sets the value of the member "dataFile".
     *
     * data file
     *
     * @param dataFile The value which will be set
     */
    inline void setDataFile (const ::std::string& dataFile_);

    /**
     * Sets the value of the member "dataFile".
     *
     * data file
     *
     * @param dataFile The value which will be set
     */
    inline void setDataFile (const char* dataFile_);

    /**
     * Sets the value of the member "dataFile".
     *
     * data file
     *
     * @param dataFile The value which will be set
     */
    inline void setDataFile (const char* value, size_t size);

    // API of field "dataFileDataCksum"

    static const int kDataFileDataCksum = 5;

    /**
     * Clears the field "dataFileDataCksum".
     *
     * The field will be set to its default value. The hasDataFileDataCksum()
     * method will return false.
     */
    inline void clearDataFileDataCksum();

    /**
     * Checks whether the field "dataFileDataCksum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataFileDataCksum()). Otherwise it will return false.
     */
    inline bool hasDataFileDataCksum () const;

    /**
     * Returns the value of the member "dataFileDataCksum".
     *
     * date file of data checksums
     *
     * @return The value of the field "dataFileDataCksum"
     */
    inline const trCkSum& getDataFileDataCksum () const;

    /**
     * Retrieves the value of the field "dataFileDataCksum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dataFileDataCksum".
     */
    inline trCkSum& getDataFileDataCksumMutable ();

    /**
     * Sets the value of the member "dataFileDataCksum".
     *
     * date file of data checksums
     *
     * @param dataFileDataCksum The value which will be set
     */
    inline void setDataFileDataCksum (const trCkSum& dataFileDataCksum_);

    // API of field "keyValuePairs"

    static const int kKeyValuePairs = 6;

    /**
     * Clears the field "keyValuePairs".
     *
     * The field will be set to its default value. The hasKeyValuePairs()
     * method will return false.
     */
    inline void clearKeyValuePairs();

    /**
     * Checks whether the field "keyValuePairs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyValuePairs()). Otherwise it will return false.
     */
    inline bool hasKeyValuePairs () const;

    /**
     * Returns the value of the member "keyValuePairs".
     *
     * pairs of key / value
     *
     * @return The value of the field "keyValuePairs"
     */
    inline const trKeyValuePairs& getKeyValuePairs () const;

    /**
     * Retrieves the value of the field "keyValuePairs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "keyValuePairs".
     */
    inline trKeyValuePairs& getKeyValuePairsMutable ();

    /**
     * Sets the value of the member "keyValuePairs".
     *
     * pairs of key / value
     *
     * @param keyValuePairs The value which will be set
     */
    inline void setKeyValuePairs (const trKeyValuePairs& keyValuePairs_);

    static const StartInstallRequest &getDefaultInstance();

private:

    inline void set_has_inModId ();

    inline void clear_has_inModId ();

    inline void set_has_toolsContainer ();

    inline void clear_has_toolsContainer ();

    inline void set_has_usbLogPath ();

    inline void clear_has_usbLogPath ();

    inline void set_has_toolsCksum ();

    inline void clear_has_toolsCksum ();

    inline void set_has_dataFile ();

    inline void clear_has_dataFile ();

    inline void set_has_dataFileDataCksum ();

    inline void clear_has_dataFileDataCksum ();

    inline void set_has_keyValuePairs ();

    inline void clear_has_keyValuePairs ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::std::string _inModId;

    ::std::string _toolsContainer;

    ::std::string _usbLogPath;

    trCkSum _toolsCksum;

    ::std::string _dataFile;

    trCkSum _dataFileDataCksum;

    trKeyValuePairs _keyValuePairs;

};

/**
 * start install,
 *                           don't remove the out, otherwise it become fire & forget.
 */
class StartInstallResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartInstallResponse ();

    /**
     * Copy constructor
     */
    inline  StartInstallResponse (const StartInstallResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StartInstallResponse (const ::std::string& outModId_, tenInstallResult enResult_);

    /**
     * Destructor
     */
    inline virtual  ~StartInstallResponse();

    /**
     * Assignment operator
     */
    inline StartInstallResponse& operator = (const StartInstallResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartInstallResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartInstallResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartInstallResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartInstallResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "outModId"

    static const int kOutModId = 0;

    /**
     * Clears the field "outModId".
     *
     * The field will be set to its default value. The hasOutModId()
     * method will return false.
     */
    inline void clearOutModId();

    /**
     * Checks whether the field "outModId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOutModId()). Otherwise it will return false.
     */
    inline bool hasOutModId () const;

    /**
     * Returns the value of the member "outModId".
     *
     * out mod Id
     *
     * @return The value of the field "outModId"
     */
    inline const ::std::string& getOutModId () const;

    /**
     * Retrieves the value of the field "outModId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "outModId".
     */
    inline ::std::string& getOutModIdMutable ();

    /**
     * Sets the value of the member "outModId".
     *
     * out mod Id
     *
     * @param outModId The value which will be set
     */
    inline void setOutModId (const ::std::string& outModId_);

    /**
     * Sets the value of the member "outModId".
     *
     * out mod Id
     *
     * @param outModId The value which will be set
     */
    inline void setOutModId (const char* outModId_);

    /**
     * Sets the value of the member "outModId".
     *
     * out mod Id
     *
     * @param outModId The value which will be set
     */
    inline void setOutModId (const char* value, size_t size);

    // API of field "enResult"

    static const int kEnResult = 1;

    /**
     * Clears the field "enResult".
     *
     * The field will be set to its default value. The hasEnResult()
     * method will return false.
     */
    inline void clearEnResult();

    /**
     * Checks whether the field "enResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnResult()). Otherwise it will return false.
     */
    inline bool hasEnResult () const;

    /**
     * Returns the value of the member "enResult".
     *
     * install result
     *
     * @return The value of the field "enResult"
     */
    inline tenInstallResult getEnResult () const;

    /**
     * Sets the value of the member "enResult".
     *
     * install result
     *
     * @param enResult The value which will be set
     */
    inline void setEnResult (tenInstallResult enResult_);

    static const StartInstallResponse &getDefaultInstance();

private:

    inline void set_has_outModId ();

    inline void clear_has_outModId ();

    inline void set_has_enResult ();

    inline void clear_has_enResult ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _outModId;

    tenInstallResult _enResult;

};

/**
 * config update session
 */
class ConfigUpdateSessionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConfigUpdateSessionRequest ();

    /**
     * Copy constructor
     */
    inline  ConfigUpdateSessionRequest (const ConfigUpdateSessionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ConfigUpdateSessionRequest (const ::std::vector< ::std::string >& modIds_);

    /**
     * Destructor
     */
    inline virtual  ~ConfigUpdateSessionRequest();

    /**
     * Assignment operator
     */
    inline ConfigUpdateSessionRequest& operator = (const ConfigUpdateSessionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConfigUpdateSessionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConfigUpdateSessionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConfigUpdateSessionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConfigUpdateSessionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "modIds"

    static const int kModIds = 0;

    /**
     * Clears the field "modIds".
     *
     * The field will be set to its default value. The hasModIds()
     * method will return false.
     */
    inline void clearModIds();

    /**
     * Checks whether the field "modIds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setModIds()). Otherwise it will return false.
     */
    inline bool hasModIds () const;

    /**
     * Returns the value of the member "modIds".
     *
     * mod Ids
     *
     * @return The value of the field "modIds"
     */
    inline const ::std::vector< ::std::string >& getModIds () const;

    /**
     * Retrieves the value of the field "modIds" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "modIds".
     */
    inline ::std::vector< ::std::string >& getModIdsMutable ();

    /**
     * Sets the value of the member "modIds".
     *
     * mod Ids
     *
     * @param modIds The value which will be set
     */
    inline void setModIds (const ::std::vector< ::std::string >& modIds_);

    static const ConfigUpdateSessionRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_modIds ();

    inline void clear_has_modIds ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _modIds;

};

/**
 * indicates sw update progress
 */
class ProgressUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProgressUpdate ();

    /**
     * Copy constructor
     */
    inline  ProgressUpdate (const ProgressUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ProgressUpdate (const trProgress& Progress_);

    /**
     * Destructor
     */
    inline virtual  ~ProgressUpdate();

    /**
     * Assignment operator
     */
    inline ProgressUpdate& operator = (const ProgressUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProgressUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProgressUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProgressUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProgressUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Progress"

    static const int kProgress = 0;

    /**
     * Clears the field "Progress".
     *
     * The field will be set to its default value. The hasProgress()
     * method will return false.
     */
    inline void clearProgress();

    /**
     * Checks whether the field "Progress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProgress()). Otherwise it will return false.
     */
    inline bool hasProgress () const;

    /**
     * Returns the value of the member "Progress".
     *
     * indicates sw update progress
     *
     * @return The value of the field "Progress"
     */
    inline const trProgress& getProgress () const;

    /**
     * Retrieves the value of the field "Progress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Progress".
     */
    inline trProgress& getProgressMutable ();

    /**
     * Sets the value of the member "Progress".
     *
     * indicates sw update progress
     *
     * @param Progress The value which will be set
     */
    inline void setProgress (const trProgress& Progress_);

    static const ProgressUpdate &getDefaultInstance();

private:

    inline void set_has_Progress ();

    inline void clear_has_Progress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trProgress _Progress;

};

/**
 * indicates sw update progress
 */
class ProgressRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProgressRegister ();

    /**
     * Copy constructor
     */
    inline  ProgressRegister (const ProgressRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ProgressRegister();

    /**
     * Assignment operator
     */
    inline ProgressRegister& operator = (const ProgressRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProgressRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProgressRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProgressRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProgressRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ProgressRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * indicate found USB stick
 */
class UsbFoundUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UsbFoundUpdate ();

    /**
     * Copy constructor
     */
    inline  UsbFoundUpdate (const UsbFoundUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UsbFoundUpdate (const trUsbFound& UsbFound_);

    /**
     * Destructor
     */
    inline virtual  ~UsbFoundUpdate();

    /**
     * Assignment operator
     */
    inline UsbFoundUpdate& operator = (const UsbFoundUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UsbFoundUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UsbFoundUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UsbFoundUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UsbFoundUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UsbFound"

    static const int kUsbFound = 0;

    /**
     * Clears the field "UsbFound".
     *
     * The field will be set to its default value. The hasUsbFound()
     * method will return false.
     */
    inline void clearUsbFound();

    /**
     * Checks whether the field "UsbFound" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUsbFound()). Otherwise it will return false.
     */
    inline bool hasUsbFound () const;

    /**
     * Returns the value of the member "UsbFound".
     *
     * indicate found USB stick
     *
     * @return The value of the field "UsbFound"
     */
    inline const trUsbFound& getUsbFound () const;

    /**
     * Retrieves the value of the field "UsbFound" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UsbFound".
     */
    inline trUsbFound& getUsbFoundMutable ();

    /**
     * Sets the value of the member "UsbFound".
     *
     * indicate found USB stick
     *
     * @param UsbFound The value which will be set
     */
    inline void setUsbFound (const trUsbFound& UsbFound_);

    static const UsbFoundUpdate &getDefaultInstance();

private:

    inline void set_has_UsbFound ();

    inline void clear_has_UsbFound ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trUsbFound _UsbFound;

};

/**
 * indicate found USB stick
 */
class UsbFoundRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UsbFoundRegister ();

    /**
     * Copy constructor
     */
    inline  UsbFoundRegister (const UsbFoundRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UsbFoundRegister();

    /**
     * Assignment operator
     */
    inline UsbFoundRegister& operator = (const UsbFoundRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UsbFoundRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UsbFoundRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UsbFoundRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UsbFoundRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UsbFoundRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * download info text
 */
class DisplayTextUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayTextUpdate ();

    /**
     * Copy constructor
     */
    inline  DisplayTextUpdate (const DisplayTextUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DisplayTextUpdate (const trDisplayText& DisplayText_);

    /**
     * Destructor
     */
    inline virtual  ~DisplayTextUpdate();

    /**
     * Assignment operator
     */
    inline DisplayTextUpdate& operator = (const DisplayTextUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayTextUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayTextUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayTextUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayTextUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DisplayText"

    static const int kDisplayText = 0;

    /**
     * Clears the field "DisplayText".
     *
     * The field will be set to its default value. The hasDisplayText()
     * method will return false.
     */
    inline void clearDisplayText();

    /**
     * Checks whether the field "DisplayText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayText()). Otherwise it will return false.
     */
    inline bool hasDisplayText () const;

    /**
     * Returns the value of the member "DisplayText".
     *
     * download info text
     *
     * @return The value of the field "DisplayText"
     */
    inline const trDisplayText& getDisplayText () const;

    /**
     * Retrieves the value of the field "DisplayText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayText".
     */
    inline trDisplayText& getDisplayTextMutable ();

    /**
     * Sets the value of the member "DisplayText".
     *
     * download info text
     *
     * @param DisplayText The value which will be set
     */
    inline void setDisplayText (const trDisplayText& DisplayText_);

    static const DisplayTextUpdate &getDefaultInstance();

private:

    inline void set_has_DisplayText ();

    inline void clear_has_DisplayText ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trDisplayText _DisplayText;

};

/**
 * download info text
 */
class DisplayTextRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayTextRegister ();

    /**
     * Copy constructor
     */
    inline  DisplayTextRegister (const DisplayTextRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DisplayTextRegister();

    /**
     * Assignment operator
     */
    inline DisplayTextRegister& operator = (const DisplayTextRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayTextRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayTextRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayTextRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayTextRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DisplayTextRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * indicates update state
 */
class UpdateStatesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateStatesUpdate ();

    /**
     * Copy constructor
     */
    inline  UpdateStatesUpdate (const UpdateStatesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateStatesUpdate (const trUpdateStates& UpdateStates_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateStatesUpdate();

    /**
     * Assignment operator
     */
    inline UpdateStatesUpdate& operator = (const UpdateStatesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateStatesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateStatesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateStatesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateStatesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateStates"

    static const int kUpdateStates = 0;

    /**
     * Clears the field "UpdateStates".
     *
     * The field will be set to its default value. The hasUpdateStates()
     * method will return false.
     */
    inline void clearUpdateStates();

    /**
     * Checks whether the field "UpdateStates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateStates()). Otherwise it will return false.
     */
    inline bool hasUpdateStates () const;

    /**
     * Returns the value of the member "UpdateStates".
     *
     * indicates update state
     *
     * @return The value of the field "UpdateStates"
     */
    inline const trUpdateStates& getUpdateStates () const;

    /**
     * Retrieves the value of the field "UpdateStates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UpdateStates".
     */
    inline trUpdateStates& getUpdateStatesMutable ();

    /**
     * Sets the value of the member "UpdateStates".
     *
     * indicates update state
     *
     * @param UpdateStates The value which will be set
     */
    inline void setUpdateStates (const trUpdateStates& UpdateStates_);

    static const UpdateStatesUpdate &getDefaultInstance();

private:

    inline void set_has_UpdateStates ();

    inline void clear_has_UpdateStates ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trUpdateStates _UpdateStates;

};

/**
 * indicates update state
 */
class UpdateStatesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateStatesRegister ();

    /**
     * Copy constructor
     */
    inline  UpdateStatesRegister (const UpdateStatesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UpdateStatesRegister();

    /**
     * Assignment operator
     */
    inline UpdateStatesRegister& operator = (const UpdateStatesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateStatesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateStatesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateStatesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateStatesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UpdateStatesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Background image details
 */
class DisplayBgImageUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayBgImageUpdate ();

    /**
     * Copy constructor
     */
    inline  DisplayBgImageUpdate (const DisplayBgImageUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DisplayBgImageUpdate (const trDisplayBgImage& DisplayBgImage_);

    /**
     * Destructor
     */
    inline virtual  ~DisplayBgImageUpdate();

    /**
     * Assignment operator
     */
    inline DisplayBgImageUpdate& operator = (const DisplayBgImageUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayBgImageUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayBgImageUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayBgImageUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayBgImageUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DisplayBgImage"

    static const int kDisplayBgImage = 0;

    /**
     * Clears the field "DisplayBgImage".
     *
     * The field will be set to its default value. The hasDisplayBgImage()
     * method will return false.
     */
    inline void clearDisplayBgImage();

    /**
     * Checks whether the field "DisplayBgImage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayBgImage()). Otherwise it will return false.
     */
    inline bool hasDisplayBgImage () const;

    /**
     * Returns the value of the member "DisplayBgImage".
     *
     * Background image details
     *
     * @return The value of the field "DisplayBgImage"
     */
    inline const trDisplayBgImage& getDisplayBgImage () const;

    /**
     * Retrieves the value of the field "DisplayBgImage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayBgImage".
     */
    inline trDisplayBgImage& getDisplayBgImageMutable ();

    /**
     * Sets the value of the member "DisplayBgImage".
     *
     * Background image details
     *
     * @param DisplayBgImage The value which will be set
     */
    inline void setDisplayBgImage (const trDisplayBgImage& DisplayBgImage_);

    static const DisplayBgImageUpdate &getDefaultInstance();

private:

    inline void set_has_DisplayBgImage ();

    inline void clear_has_DisplayBgImage ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trDisplayBgImage _DisplayBgImage;

};

/**
 * Background image details
 */
class DisplayBgImageRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayBgImageRegister ();

    /**
     * Copy constructor
     */
    inline  DisplayBgImageRegister (const DisplayBgImageRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DisplayBgImageRegister();

    /**
     * Assignment operator
     */
    inline DisplayBgImageRegister& operator = (const DisplayBgImageRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayBgImageRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayBgImageRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayBgImageRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayBgImageRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DisplayBgImageRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * startInstallSuccess signal
 *                           callback that is called when StartInstall is done
 */
class StartInstallResponseSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartInstallResponseSignal ();

    /**
     * Copy constructor
     */
    inline  StartInstallResponseSignal (const StartInstallResponseSignal &rhs);

    /**
     * All fields constructor
     */
    inline  StartInstallResponseSignal (const ::std::string& outModId_, tenInstallResult enResult_);

    /**
     * Destructor
     */
    inline virtual  ~StartInstallResponseSignal();

    /**
     * Assignment operator
     */
    inline StartInstallResponseSignal& operator = (const StartInstallResponseSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartInstallResponseSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartInstallResponseSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartInstallResponseSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartInstallResponseSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "outModId"

    static const int kOutModId = 0;

    /**
     * Clears the field "outModId".
     *
     * The field will be set to its default value. The hasOutModId()
     * method will return false.
     */
    inline void clearOutModId();

    /**
     * Checks whether the field "outModId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOutModId()). Otherwise it will return false.
     */
    inline bool hasOutModId () const;

    /**
     * Returns the value of the member "outModId".
     *
     * out mod Id
     *
     * @return The value of the field "outModId"
     */
    inline const ::std::string& getOutModId () const;

    /**
     * Retrieves the value of the field "outModId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "outModId".
     */
    inline ::std::string& getOutModIdMutable ();

    /**
     * Sets the value of the member "outModId".
     *
     * out mod Id
     *
     * @param outModId The value which will be set
     */
    inline void setOutModId (const ::std::string& outModId_);

    /**
     * Sets the value of the member "outModId".
     *
     * out mod Id
     *
     * @param outModId The value which will be set
     */
    inline void setOutModId (const char* outModId_);

    /**
     * Sets the value of the member "outModId".
     *
     * out mod Id
     *
     * @param outModId The value which will be set
     */
    inline void setOutModId (const char* value, size_t size);

    // API of field "enResult"

    static const int kEnResult = 1;

    /**
     * Clears the field "enResult".
     *
     * The field will be set to its default value. The hasEnResult()
     * method will return false.
     */
    inline void clearEnResult();

    /**
     * Checks whether the field "enResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnResult()). Otherwise it will return false.
     */
    inline bool hasEnResult () const;

    /**
     * Returns the value of the member "enResult".
     *
     * install result
     *
     * @return The value of the field "enResult"
     */
    inline tenInstallResult getEnResult () const;

    /**
     * Sets the value of the member "enResult".
     *
     * install result
     *
     * @param enResult The value which will be set
     */
    inline void setEnResult (tenInstallResult enResult_);

    static const StartInstallResponseSignal &getDefaultInstance();

private:

    inline void set_has_outModId ();

    inline void clear_has_outModId ();

    inline void set_has_enResult ();

    inline void clear_has_enResult ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _outModId;

    tenInstallResult _enResult;

};

inline  trCkSum::trCkSum ()  :
    _enType (::ai_sw_update::common::core::imp::SWUCoreService::tenCkSumType__NONE),
    _u64Len (0u),
    _u32SegSize (0u),
    _chkSumChunks (),
    _encryptParam ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trCkSum::trCkSum (const trCkSum &rhs)  :
    _enType (::ai_sw_update::common::core::imp::SWUCoreService::tenCkSumType__NONE),
    _u64Len (0u),
    _u32SegSize (0u),
    _chkSumChunks (),
    _encryptParam ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trCkSum::trCkSum (tenCkSumType enType_, uint64 u64Len_, uint32 u32SegSize_, const ::std::vector< ::std::vector< uint8 > >& chkSumChunks_, const ::std::string& encryptParam_)  :
    _enType (enType_),
    _u64Len (u64Len_),
    _u32SegSize (u32SegSize_),
    _chkSumChunks (chkSumChunks_),
    _encryptParam (encryptParam_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenCkSumType_IsValid(enType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enType_, "tenCkSumType", "enType", "trCkSum");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (encryptParam_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trCkSum::~trCkSum() {
}

inline trCkSum& trCkSum::operator = (const trCkSum& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnType()) {
            setEnType(rhs.getEnType());
        } else {
            clearEnType();
        }
        if (rhs.hasU64Len()) {
            setU64Len(rhs.getU64Len());
        } else {
            clearU64Len();
        }
        if (rhs.hasU32SegSize()) {
            setU32SegSize(rhs.getU32SegSize());
        } else {
            clearU32SegSize();
        }
        if (rhs.hasChkSumChunks()) {
            setChkSumChunks(rhs.getChkSumChunks());
        } else {
            clearChkSumChunks();
        }
        if (rhs.hasEncryptParam()) {
            setEncryptParam(rhs.getEncryptParam());
        } else {
            clearEncryptParam();
        }
    }
    return *this;
}

inline bool trCkSum::operator == (const trCkSum& rhs) const {
    return (((!hasEnType() && !rhs.hasEnType()) || getEnType() == rhs.getEnType()) &&
        ((!hasU64Len() && !rhs.hasU64Len()) || getU64Len() == rhs.getU64Len()) &&
        ((!hasU32SegSize() && !rhs.hasU32SegSize()) || getU32SegSize() == rhs.getU32SegSize()) &&
        ((!hasChkSumChunks() && !rhs.hasChkSumChunks()) || getChkSumChunks() == rhs.getChkSumChunks()) &&
        ((!hasEncryptParam() && !rhs.hasEncryptParam()) || getEncryptParam() == rhs.getEncryptParam()));
}

inline bool trCkSum::operator != (const trCkSum& rhs) const {
    return ! (*this == rhs);
}

inline bool trCkSum::operator < (const trCkSum& rhs) const {
    if (hasEnType() || rhs.hasEnType()) {
        if ((uint32)getEnType() < (uint32)rhs.getEnType()) return true;
        if ((uint32)getEnType() > (uint32)rhs.getEnType()) return false;
    }
    if (hasU64Len() || rhs.hasU64Len()) {
        if (getU64Len() < rhs.getU64Len()) return true;
        if (getU64Len() > rhs.getU64Len()) return false;
    }
    if (hasU32SegSize() || rhs.hasU32SegSize()) {
        if (getU32SegSize() < rhs.getU32SegSize()) return true;
        if (getU32SegSize() > rhs.getU32SegSize()) return false;
    }
    if (hasChkSumChunks() || rhs.hasChkSumChunks()) {
        if (getChkSumChunks() < rhs.getChkSumChunks()) return true;
        if (getChkSumChunks() > rhs.getChkSumChunks()) return false;
    }
    if (hasEncryptParam() || rhs.hasEncryptParam()) {
        if (getEncryptParam() < rhs.getEncryptParam()) return true;
        if (getEncryptParam() > rhs.getEncryptParam()) return false;
    }
    return false;
}

inline bool trCkSum::operator > (const trCkSum& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trCkSum::clear() {
    clearEnType();
    clearU64Len();
    clearU32SegSize();
    clearChkSumChunks();
    clearEncryptParam();
}

inline void trCkSum::clearEnType() {
    if (hasEnType()) {
         clear_has_enType();
        _enType = ::ai_sw_update::common::core::imp::SWUCoreService::tenCkSumType__NONE;
     }
}

inline bool trCkSum::hasEnType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenCkSumType trCkSum::getEnType () const {
    return _enType;
}

inline void trCkSum::setEnType (tenCkSumType enType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenCkSumType_IsValid(enType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enType_, "tenCkSumType", "enType", "trCkSum");
    }
    set_has_enType();
    this->_enType = enType_;
}

inline void trCkSum::clearU64Len() {
    if (hasU64Len()) {
         clear_has_u64Len();
        _u64Len = 0u;
     }
}

inline bool trCkSum::hasU64Len () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint64 trCkSum::getU64Len () const {
    return _u64Len;
}

inline void trCkSum::setU64Len (uint64 u64Len_) {
    set_has_u64Len();
    this->_u64Len = u64Len_;
}

inline void trCkSum::clearU32SegSize() {
    if (hasU32SegSize()) {
         clear_has_u32SegSize();
        _u32SegSize = 0u;
     }
}

inline bool trCkSum::hasU32SegSize () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 trCkSum::getU32SegSize () const {
    return _u32SegSize;
}

inline void trCkSum::setU32SegSize (uint32 u32SegSize_) {
    set_has_u32SegSize();
    this->_u32SegSize = u32SegSize_;
}

inline void trCkSum::clearChkSumChunks() {
    if (hasChkSumChunks()) {
         clear_has_chkSumChunks();
        _chkSumChunks.clear();
     }
}

inline bool trCkSum::hasChkSumChunks () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< ::std::vector< uint8 > >& trCkSum::getChkSumChunks () const {
    return _chkSumChunks;
}

inline ::std::vector< ::std::vector< uint8 > >& trCkSum::getChkSumChunksMutable () {
    set_has_chkSumChunks();
    return _chkSumChunks;
}

inline void trCkSum::setChkSumChunks (const ::std::vector< ::std::vector< uint8 > >& chkSumChunks_) {
    set_has_chkSumChunks();
    this->_chkSumChunks = chkSumChunks_;
}

inline void trCkSum::clearEncryptParam() {
    if (hasEncryptParam()) {
         clear_has_encryptParam();
        _encryptParam.clear();
     }
}

inline bool trCkSum::hasEncryptParam () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& trCkSum::getEncryptParam () const {
    return _encryptParam;
}

inline ::std::string& trCkSum::getEncryptParamMutable () {
    set_has_encryptParam();
    return _encryptParam;
}

inline void trCkSum::setEncryptParam (const ::std::string& encryptParam_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (encryptParam_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_encryptParam();
    this->_encryptParam = encryptParam_;
}

inline void trCkSum::setEncryptParam (const char* encryptParam_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (encryptParam_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_encryptParam();
    this->_encryptParam.assign(encryptParam_);
}

inline void trCkSum::setEncryptParam (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_encryptParam();
    this->_encryptParam.assign(value, size);
}

inline void trCkSum::set_has_enType () {
    _has_bits_[0] |= 1u << 0;
}

inline void trCkSum::clear_has_enType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trCkSum::set_has_u64Len () {
    _has_bits_[0] |= 1u << 1;
}

inline void trCkSum::clear_has_u64Len () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trCkSum::set_has_u32SegSize () {
    _has_bits_[0] |= 1u << 2;
}

inline void trCkSum::clear_has_u32SegSize () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trCkSum::set_has_chkSumChunks () {
    _has_bits_[0] |= 1u << 3;
}

inline void trCkSum::clear_has_chkSumChunks () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void trCkSum::set_has_encryptParam () {
    _has_bits_[0] |= 1u << 4;
}

inline void trCkSum::clear_has_encryptParam () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  trKeyValuePair::trKeyValuePair ()  :
    _key (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trKeyValuePair::trKeyValuePair (const trKeyValuePair &rhs)  :
    _key (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trKeyValuePair::trKeyValuePair (const ::std::string& key_, const ::std::string& value_)  :
    _key (key_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (key_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trKeyValuePair::~trKeyValuePair() {
}

inline trKeyValuePair& trKeyValuePair::operator = (const trKeyValuePair& rhs) {
    if( this != &rhs ) {
        if (rhs.hasKey()) {
            setKey(rhs.getKey());
        } else {
            clearKey();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool trKeyValuePair::operator == (const trKeyValuePair& rhs) const {
    return (((!hasKey() && !rhs.hasKey()) || getKey() == rhs.getKey()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool trKeyValuePair::operator != (const trKeyValuePair& rhs) const {
    return ! (*this == rhs);
}

inline bool trKeyValuePair::operator < (const trKeyValuePair& rhs) const {
    if (hasKey() || rhs.hasKey()) {
        if (getKey() < rhs.getKey()) return true;
        if (getKey() > rhs.getKey()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline bool trKeyValuePair::operator > (const trKeyValuePair& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trKeyValuePair::clear() {
    clearKey();
    clearValue();
}

inline void trKeyValuePair::clearKey() {
    if (hasKey()) {
         clear_has_key();
        _key.clear();
     }
}

inline bool trKeyValuePair::hasKey () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trKeyValuePair::getKey () const {
    return _key;
}

inline ::std::string& trKeyValuePair::getKeyMutable () {
    set_has_key();
    return _key;
}

inline void trKeyValuePair::setKey (const ::std::string& key_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (key_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_key();
    this->_key = key_;
}

inline void trKeyValuePair::setKey (const char* key_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (key_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_key();
    this->_key.assign(key_);
}

inline void trKeyValuePair::setKey (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_key();
    this->_key.assign(value, size);
}

inline void trKeyValuePair::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value.clear();
     }
}

inline bool trKeyValuePair::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trKeyValuePair::getValue () const {
    return _value;
}

inline ::std::string& trKeyValuePair::getValueMutable () {
    set_has_value();
    return _value;
}

inline void trKeyValuePair::setValue (const ::std::string& value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value = value_;
}

inline void trKeyValuePair::setValue (const char* value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value.assign(value_);
}

inline void trKeyValuePair::setValue (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value.assign(value, size);
}

inline void trKeyValuePair::set_has_key () {
    _has_bits_[0] |= 1u << 0;
}

inline void trKeyValuePair::clear_has_key () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trKeyValuePair::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void trKeyValuePair::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trKeyValuePairs::trKeyValuePairs ()  :
    _rKeyValuePair ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trKeyValuePairs::trKeyValuePairs (const trKeyValuePairs &rhs)  :
    _rKeyValuePair ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trKeyValuePairs::trKeyValuePairs (const ::std::vector< trKeyValuePair >& rKeyValuePair_)  :
    _rKeyValuePair (rKeyValuePair_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trKeyValuePairs::~trKeyValuePairs() {
}

inline trKeyValuePairs& trKeyValuePairs::operator = (const trKeyValuePairs& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRKeyValuePair()) {
            setRKeyValuePair(rhs.getRKeyValuePair());
        } else {
            clearRKeyValuePair();
        }
    }
    return *this;
}

inline bool trKeyValuePairs::operator == (const trKeyValuePairs& rhs) const {
    return (((!hasRKeyValuePair() && !rhs.hasRKeyValuePair()) || getRKeyValuePair() == rhs.getRKeyValuePair()));
}

inline bool trKeyValuePairs::operator != (const trKeyValuePairs& rhs) const {
    return ! (*this == rhs);
}

inline bool trKeyValuePairs::operator < (const trKeyValuePairs& rhs) const {
    if (hasRKeyValuePair() || rhs.hasRKeyValuePair()) {
        if (getRKeyValuePair() < rhs.getRKeyValuePair()) return true;
        if (getRKeyValuePair() > rhs.getRKeyValuePair()) return false;
    }
    return false;
}

inline bool trKeyValuePairs::operator > (const trKeyValuePairs& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trKeyValuePairs::clear() {
    clearRKeyValuePair();
}

inline void trKeyValuePairs::clearRKeyValuePair() {
    if (hasRKeyValuePair()) {
         clear_has_rKeyValuePair();
        _rKeyValuePair.clear();
     }
}

inline bool trKeyValuePairs::hasRKeyValuePair () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< trKeyValuePair >& trKeyValuePairs::getRKeyValuePair () const {
    return _rKeyValuePair;
}

inline ::std::vector< trKeyValuePair >& trKeyValuePairs::getRKeyValuePairMutable () {
    set_has_rKeyValuePair();
    return _rKeyValuePair;
}

inline void trKeyValuePairs::setRKeyValuePair (const ::std::vector< trKeyValuePair >& rKeyValuePair_) {
    set_has_rKeyValuePair();
    this->_rKeyValuePair = rKeyValuePair_;
}

inline void trKeyValuePairs::set_has_rKeyValuePair () {
    _has_bits_[0] |= 1u << 0;
}

inline void trKeyValuePairs::clear_has_rKeyValuePair () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trTime::trTime ()  :
    _u32Seconds (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trTime::trTime (const trTime &rhs)  :
    _u32Seconds (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trTime::trTime (uint32 u32Seconds_)  :
    _u32Seconds (u32Seconds_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trTime::~trTime() {
}

inline trTime& trTime::operator = (const trTime& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32Seconds()) {
            setU32Seconds(rhs.getU32Seconds());
        } else {
            clearU32Seconds();
        }
    }
    return *this;
}

inline bool trTime::operator == (const trTime& rhs) const {
    return (((!hasU32Seconds() && !rhs.hasU32Seconds()) || getU32Seconds() == rhs.getU32Seconds()));
}

inline bool trTime::operator != (const trTime& rhs) const {
    return ! (*this == rhs);
}

inline bool trTime::operator < (const trTime& rhs) const {
    if (hasU32Seconds() || rhs.hasU32Seconds()) {
        if (getU32Seconds() < rhs.getU32Seconds()) return true;
        if (getU32Seconds() > rhs.getU32Seconds()) return false;
    }
    return false;
}

inline bool trTime::operator > (const trTime& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trTime::clear() {
    clearU32Seconds();
}

inline void trTime::clearU32Seconds() {
    if (hasU32Seconds()) {
         clear_has_u32Seconds();
        _u32Seconds = 0u;
     }
}

inline bool trTime::hasU32Seconds () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 trTime::getU32Seconds () const {
    return _u32Seconds;
}

inline void trTime::setU32Seconds (uint32 u32Seconds_) {
    set_has_u32Seconds();
    this->_u32Seconds = u32Seconds_;
}

inline void trTime::set_has_u32Seconds () {
    _has_bits_[0] |= 1u << 0;
}

inline void trTime::clear_has_u32Seconds () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trProgressInfo::trProgressInfo ()  :
    _u8Percent (0u),
    _time ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trProgressInfo::trProgressInfo (const trProgressInfo &rhs)  :
    _u8Percent (0u),
    _time ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trProgressInfo::trProgressInfo (uint8 u8Percent_, const trTime& time_)  :
    _u8Percent (u8Percent_),
    _time (time_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trProgressInfo::~trProgressInfo() {
}

inline trProgressInfo& trProgressInfo::operator = (const trProgressInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Percent()) {
            setU8Percent(rhs.getU8Percent());
        } else {
            clearU8Percent();
        }
        if (rhs.hasTime()) {
            setTime(rhs.getTime());
        } else {
            clearTime();
        }
    }
    return *this;
}

inline bool trProgressInfo::operator == (const trProgressInfo& rhs) const {
    return (((!hasU8Percent() && !rhs.hasU8Percent()) || getU8Percent() == rhs.getU8Percent()) &&
        ((!hasTime() && !rhs.hasTime()) || getTime() == rhs.getTime()));
}

inline bool trProgressInfo::operator != (const trProgressInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool trProgressInfo::operator < (const trProgressInfo& rhs) const {
    if (hasU8Percent() || rhs.hasU8Percent()) {
        if (getU8Percent() < rhs.getU8Percent()) return true;
        if (getU8Percent() > rhs.getU8Percent()) return false;
    }
    if (hasTime() || rhs.hasTime()) {
        if (getTime() < rhs.getTime()) return true;
        if (getTime() > rhs.getTime()) return false;
    }
    return false;
}

inline bool trProgressInfo::operator > (const trProgressInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trProgressInfo::clear() {
    clearU8Percent();
    clearTime();
}

inline void trProgressInfo::clearU8Percent() {
    if (hasU8Percent()) {
         clear_has_u8Percent();
        _u8Percent = 0u;
     }
}

inline bool trProgressInfo::hasU8Percent () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 trProgressInfo::getU8Percent () const {
    return _u8Percent;
}

inline void trProgressInfo::setU8Percent (uint8 u8Percent_) {
    set_has_u8Percent();
    this->_u8Percent = u8Percent_;
}

inline void trProgressInfo::clearTime() {
    if (hasTime()) {
         clear_has_time();
        _time.clear();
     }
}

inline bool trProgressInfo::hasTime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const trTime& trProgressInfo::getTime () const {
    return _time;
}

inline trTime& trProgressInfo::getTimeMutable () {
    set_has_time();
    return _time;
}

inline void trProgressInfo::setTime (const trTime& time_) {
    set_has_time();
    this->_time = time_;
}

inline void trProgressInfo::set_has_u8Percent () {
    _has_bits_[0] |= 1u << 0;
}

inline void trProgressInfo::clear_has_u8Percent () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trProgressInfo::set_has_time () {
    _has_bits_[0] |= 1u << 1;
}

inline void trProgressInfo::clear_has_time () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trProgress::trProgress ()  :
    _progressOverall (),
    _curModId (),
    _progressModId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trProgress::trProgress (const trProgress &rhs)  :
    _progressOverall (),
    _curModId (),
    _progressModId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trProgress::trProgress (const trProgressInfo& progressOverall_, const ::std::string& curModId_, const trProgressInfo& progressModId_)  :
    _progressOverall (progressOverall_),
    _curModId (curModId_),
    _progressModId (progressModId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (curModId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trProgress::~trProgress() {
}

inline trProgress& trProgress::operator = (const trProgress& rhs) {
    if( this != &rhs ) {
        if (rhs.hasProgressOverall()) {
            setProgressOverall(rhs.getProgressOverall());
        } else {
            clearProgressOverall();
        }
        if (rhs.hasCurModId()) {
            setCurModId(rhs.getCurModId());
        } else {
            clearCurModId();
        }
        if (rhs.hasProgressModId()) {
            setProgressModId(rhs.getProgressModId());
        } else {
            clearProgressModId();
        }
    }
    return *this;
}

inline bool trProgress::operator == (const trProgress& rhs) const {
    return (((!hasProgressOverall() && !rhs.hasProgressOverall()) || getProgressOverall() == rhs.getProgressOverall()) &&
        ((!hasCurModId() && !rhs.hasCurModId()) || getCurModId() == rhs.getCurModId()) &&
        ((!hasProgressModId() && !rhs.hasProgressModId()) || getProgressModId() == rhs.getProgressModId()));
}

inline bool trProgress::operator != (const trProgress& rhs) const {
    return ! (*this == rhs);
}

inline bool trProgress::operator < (const trProgress& rhs) const {
    if (hasProgressOverall() || rhs.hasProgressOverall()) {
        if (getProgressOverall() < rhs.getProgressOverall()) return true;
        if (getProgressOverall() > rhs.getProgressOverall()) return false;
    }
    if (hasCurModId() || rhs.hasCurModId()) {
        if (getCurModId() < rhs.getCurModId()) return true;
        if (getCurModId() > rhs.getCurModId()) return false;
    }
    if (hasProgressModId() || rhs.hasProgressModId()) {
        if (getProgressModId() < rhs.getProgressModId()) return true;
        if (getProgressModId() > rhs.getProgressModId()) return false;
    }
    return false;
}

inline bool trProgress::operator > (const trProgress& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trProgress::clear() {
    clearProgressOverall();
    clearCurModId();
    clearProgressModId();
}

inline void trProgress::clearProgressOverall() {
    if (hasProgressOverall()) {
         clear_has_progressOverall();
        _progressOverall.clear();
     }
}

inline bool trProgress::hasProgressOverall () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trProgressInfo& trProgress::getProgressOverall () const {
    return _progressOverall;
}

inline trProgressInfo& trProgress::getProgressOverallMutable () {
    set_has_progressOverall();
    return _progressOverall;
}

inline void trProgress::setProgressOverall (const trProgressInfo& progressOverall_) {
    set_has_progressOverall();
    this->_progressOverall = progressOverall_;
}

inline void trProgress::clearCurModId() {
    if (hasCurModId()) {
         clear_has_curModId();
        _curModId.clear();
     }
}

inline bool trProgress::hasCurModId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trProgress::getCurModId () const {
    return _curModId;
}

inline ::std::string& trProgress::getCurModIdMutable () {
    set_has_curModId();
    return _curModId;
}

inline void trProgress::setCurModId (const ::std::string& curModId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (curModId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_curModId();
    this->_curModId = curModId_;
}

inline void trProgress::setCurModId (const char* curModId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (curModId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_curModId();
    this->_curModId.assign(curModId_);
}

inline void trProgress::setCurModId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_curModId();
    this->_curModId.assign(value, size);
}

inline void trProgress::clearProgressModId() {
    if (hasProgressModId()) {
         clear_has_progressModId();
        _progressModId.clear();
     }
}

inline bool trProgress::hasProgressModId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const trProgressInfo& trProgress::getProgressModId () const {
    return _progressModId;
}

inline trProgressInfo& trProgress::getProgressModIdMutable () {
    set_has_progressModId();
    return _progressModId;
}

inline void trProgress::setProgressModId (const trProgressInfo& progressModId_) {
    set_has_progressModId();
    this->_progressModId = progressModId_;
}

inline void trProgress::set_has_progressOverall () {
    _has_bits_[0] |= 1u << 0;
}

inline void trProgress::clear_has_progressOverall () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trProgress::set_has_curModId () {
    _has_bits_[0] |= 1u << 1;
}

inline void trProgress::clear_has_curModId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trProgress::set_has_progressModId () {
    _has_bits_[0] |= 1u << 2;
}

inline void trProgress::clear_has_progressModId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  trUsbFound::trUsbFound ()  :
    _bFound (false),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trUsbFound::trUsbFound (const trUsbFound &rhs)  :
    _bFound (false),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trUsbFound::trUsbFound (bool bFound_, const ::std::string& path_)  :
    _bFound (bFound_),
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trUsbFound::~trUsbFound() {
}

inline trUsbFound& trUsbFound::operator = (const trUsbFound& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBFound()) {
            setBFound(rhs.getBFound());
        } else {
            clearBFound();
        }
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool trUsbFound::operator == (const trUsbFound& rhs) const {
    return (((!hasBFound() && !rhs.hasBFound()) || getBFound() == rhs.getBFound()) &&
        ((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool trUsbFound::operator != (const trUsbFound& rhs) const {
    return ! (*this == rhs);
}

inline bool trUsbFound::operator < (const trUsbFound& rhs) const {
    if (hasBFound() || rhs.hasBFound()) {
        if (getBFound() < rhs.getBFound()) return true;
        if (getBFound() > rhs.getBFound()) return false;
    }
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline bool trUsbFound::operator > (const trUsbFound& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trUsbFound::clear() {
    clearBFound();
    clearPath();
}

inline void trUsbFound::clearBFound() {
    if (hasBFound()) {
         clear_has_bFound();
        _bFound = false;
     }
}

inline bool trUsbFound::hasBFound () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool trUsbFound::getBFound () const {
    return _bFound;
}

inline void trUsbFound::setBFound (bool bFound_) {
    set_has_bFound();
    this->_bFound = bFound_;
}

inline void trUsbFound::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool trUsbFound::hasPath () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trUsbFound::getPath () const {
    return _path;
}

inline ::std::string& trUsbFound::getPathMutable () {
    set_has_path();
    return _path;
}

inline void trUsbFound::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void trUsbFound::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void trUsbFound::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void trUsbFound::set_has_bFound () {
    _has_bits_[0] |= 1u << 0;
}

inline void trUsbFound::clear_has_bFound () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trUsbFound::set_has_path () {
    _has_bits_[0] |= 1u << 1;
}

inline void trUsbFound::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trDisplayText::trDisplayText ()  :
    _line1 (),
    _line2 (),
    _luaCmd ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trDisplayText::trDisplayText (const trDisplayText &rhs)  :
    _line1 (),
    _line2 (),
    _luaCmd ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trDisplayText::trDisplayText (const ::std::string& line1_, const ::std::string& line2_, const ::std::string& luaCmd_)  :
    _line1 (line1_),
    _line2 (line2_),
    _luaCmd (luaCmd_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (line1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (line2_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (luaCmd_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trDisplayText::~trDisplayText() {
}

inline trDisplayText& trDisplayText::operator = (const trDisplayText& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLine1()) {
            setLine1(rhs.getLine1());
        } else {
            clearLine1();
        }
        if (rhs.hasLine2()) {
            setLine2(rhs.getLine2());
        } else {
            clearLine2();
        }
        if (rhs.hasLuaCmd()) {
            setLuaCmd(rhs.getLuaCmd());
        } else {
            clearLuaCmd();
        }
    }
    return *this;
}

inline bool trDisplayText::operator == (const trDisplayText& rhs) const {
    return (((!hasLine1() && !rhs.hasLine1()) || getLine1() == rhs.getLine1()) &&
        ((!hasLine2() && !rhs.hasLine2()) || getLine2() == rhs.getLine2()) &&
        ((!hasLuaCmd() && !rhs.hasLuaCmd()) || getLuaCmd() == rhs.getLuaCmd()));
}

inline bool trDisplayText::operator != (const trDisplayText& rhs) const {
    return ! (*this == rhs);
}

inline bool trDisplayText::operator < (const trDisplayText& rhs) const {
    if (hasLine1() || rhs.hasLine1()) {
        if (getLine1() < rhs.getLine1()) return true;
        if (getLine1() > rhs.getLine1()) return false;
    }
    if (hasLine2() || rhs.hasLine2()) {
        if (getLine2() < rhs.getLine2()) return true;
        if (getLine2() > rhs.getLine2()) return false;
    }
    if (hasLuaCmd() || rhs.hasLuaCmd()) {
        if (getLuaCmd() < rhs.getLuaCmd()) return true;
        if (getLuaCmd() > rhs.getLuaCmd()) return false;
    }
    return false;
}

inline bool trDisplayText::operator > (const trDisplayText& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trDisplayText::clear() {
    clearLine1();
    clearLine2();
    clearLuaCmd();
}

inline void trDisplayText::clearLine1() {
    if (hasLine1()) {
         clear_has_line1();
        _line1.clear();
     }
}

inline bool trDisplayText::hasLine1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trDisplayText::getLine1 () const {
    return _line1;
}

inline ::std::string& trDisplayText::getLine1Mutable () {
    set_has_line1();
    return _line1;
}

inline void trDisplayText::setLine1 (const ::std::string& line1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (line1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_line1();
    this->_line1 = line1_;
}

inline void trDisplayText::setLine1 (const char* line1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (line1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_line1();
    this->_line1.assign(line1_);
}

inline void trDisplayText::setLine1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_line1();
    this->_line1.assign(value, size);
}

inline void trDisplayText::clearLine2() {
    if (hasLine2()) {
         clear_has_line2();
        _line2.clear();
     }
}

inline bool trDisplayText::hasLine2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trDisplayText::getLine2 () const {
    return _line2;
}

inline ::std::string& trDisplayText::getLine2Mutable () {
    set_has_line2();
    return _line2;
}

inline void trDisplayText::setLine2 (const ::std::string& line2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (line2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_line2();
    this->_line2 = line2_;
}

inline void trDisplayText::setLine2 (const char* line2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (line2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_line2();
    this->_line2.assign(line2_);
}

inline void trDisplayText::setLine2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_line2();
    this->_line2.assign(value, size);
}

inline void trDisplayText::clearLuaCmd() {
    if (hasLuaCmd()) {
         clear_has_luaCmd();
        _luaCmd.clear();
     }
}

inline bool trDisplayText::hasLuaCmd () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& trDisplayText::getLuaCmd () const {
    return _luaCmd;
}

inline ::std::string& trDisplayText::getLuaCmdMutable () {
    set_has_luaCmd();
    return _luaCmd;
}

inline void trDisplayText::setLuaCmd (const ::std::string& luaCmd_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (luaCmd_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_luaCmd();
    this->_luaCmd = luaCmd_;
}

inline void trDisplayText::setLuaCmd (const char* luaCmd_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (luaCmd_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_luaCmd();
    this->_luaCmd.assign(luaCmd_);
}

inline void trDisplayText::setLuaCmd (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_luaCmd();
    this->_luaCmd.assign(value, size);
}

inline void trDisplayText::set_has_line1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void trDisplayText::clear_has_line1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trDisplayText::set_has_line2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void trDisplayText::clear_has_line2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trDisplayText::set_has_luaCmd () {
    _has_bits_[0] |= 1u << 2;
}

inline void trDisplayText::clear_has_luaCmd () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  trUpdateState::trUpdateState ()  :
    _modId (),
    _enState (::ai_sw_update::common::core::imp::SWUCoreService::tenUpdateState__IDLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trUpdateState::trUpdateState (const trUpdateState &rhs)  :
    _modId (),
    _enState (::ai_sw_update::common::core::imp::SWUCoreService::tenUpdateState__IDLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trUpdateState::trUpdateState (const ::std::string& modId_, tenUpdateState enState_)  :
    _modId (modId_),
    _enState (enState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (modId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdateState_IsValid(enState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enState_, "tenUpdateState", "enState", "trUpdateState");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trUpdateState::~trUpdateState() {
}

inline trUpdateState& trUpdateState::operator = (const trUpdateState& rhs) {
    if( this != &rhs ) {
        if (rhs.hasModId()) {
            setModId(rhs.getModId());
        } else {
            clearModId();
        }
        if (rhs.hasEnState()) {
            setEnState(rhs.getEnState());
        } else {
            clearEnState();
        }
    }
    return *this;
}

inline bool trUpdateState::operator == (const trUpdateState& rhs) const {
    return (((!hasModId() && !rhs.hasModId()) || getModId() == rhs.getModId()) &&
        ((!hasEnState() && !rhs.hasEnState()) || getEnState() == rhs.getEnState()));
}

inline bool trUpdateState::operator != (const trUpdateState& rhs) const {
    return ! (*this == rhs);
}

inline bool trUpdateState::operator < (const trUpdateState& rhs) const {
    if (hasModId() || rhs.hasModId()) {
        if (getModId() < rhs.getModId()) return true;
        if (getModId() > rhs.getModId()) return false;
    }
    if (hasEnState() || rhs.hasEnState()) {
        if ((uint32)getEnState() < (uint32)rhs.getEnState()) return true;
        if ((uint32)getEnState() > (uint32)rhs.getEnState()) return false;
    }
    return false;
}

inline bool trUpdateState::operator > (const trUpdateState& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trUpdateState::clear() {
    clearModId();
    clearEnState();
}

inline void trUpdateState::clearModId() {
    if (hasModId()) {
         clear_has_modId();
        _modId.clear();
     }
}

inline bool trUpdateState::hasModId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trUpdateState::getModId () const {
    return _modId;
}

inline ::std::string& trUpdateState::getModIdMutable () {
    set_has_modId();
    return _modId;
}

inline void trUpdateState::setModId (const ::std::string& modId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (modId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_modId();
    this->_modId = modId_;
}

inline void trUpdateState::setModId (const char* modId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (modId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_modId();
    this->_modId.assign(modId_);
}

inline void trUpdateState::setModId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_modId();
    this->_modId.assign(value, size);
}

inline void trUpdateState::clearEnState() {
    if (hasEnState()) {
         clear_has_enState();
        _enState = ::ai_sw_update::common::core::imp::SWUCoreService::tenUpdateState__IDLE;
     }
}

inline bool trUpdateState::hasEnState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline tenUpdateState trUpdateState::getEnState () const {
    return _enState;
}

inline void trUpdateState::setEnState (tenUpdateState enState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenUpdateState_IsValid(enState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enState_, "tenUpdateState", "enState", "trUpdateState");
    }
    set_has_enState();
    this->_enState = enState_;
}

inline void trUpdateState::set_has_modId () {
    _has_bits_[0] |= 1u << 0;
}

inline void trUpdateState::clear_has_modId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trUpdateState::set_has_enState () {
    _has_bits_[0] |= 1u << 1;
}

inline void trUpdateState::clear_has_enState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trUpdateStates::trUpdateStates ()  :
    _bSessionActive (false),
    _states ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trUpdateStates::trUpdateStates (const trUpdateStates &rhs)  :
    _bSessionActive (false),
    _states ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trUpdateStates::trUpdateStates (bool bSessionActive_, const ::std::vector< trUpdateState >& states_)  :
    _bSessionActive (bSessionActive_),
    _states (states_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trUpdateStates::~trUpdateStates() {
}

inline trUpdateStates& trUpdateStates::operator = (const trUpdateStates& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBSessionActive()) {
            setBSessionActive(rhs.getBSessionActive());
        } else {
            clearBSessionActive();
        }
        if (rhs.hasStates()) {
            setStates(rhs.getStates());
        } else {
            clearStates();
        }
    }
    return *this;
}

inline bool trUpdateStates::operator == (const trUpdateStates& rhs) const {
    return (((!hasBSessionActive() && !rhs.hasBSessionActive()) || getBSessionActive() == rhs.getBSessionActive()) &&
        ((!hasStates() && !rhs.hasStates()) || getStates() == rhs.getStates()));
}

inline bool trUpdateStates::operator != (const trUpdateStates& rhs) const {
    return ! (*this == rhs);
}

inline bool trUpdateStates::operator < (const trUpdateStates& rhs) const {
    if (hasBSessionActive() || rhs.hasBSessionActive()) {
        if (getBSessionActive() < rhs.getBSessionActive()) return true;
        if (getBSessionActive() > rhs.getBSessionActive()) return false;
    }
    if (hasStates() || rhs.hasStates()) {
        if (getStates() < rhs.getStates()) return true;
        if (getStates() > rhs.getStates()) return false;
    }
    return false;
}

inline bool trUpdateStates::operator > (const trUpdateStates& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trUpdateStates::clear() {
    clearBSessionActive();
    clearStates();
}

inline void trUpdateStates::clearBSessionActive() {
    if (hasBSessionActive()) {
         clear_has_bSessionActive();
        _bSessionActive = false;
     }
}

inline bool trUpdateStates::hasBSessionActive () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool trUpdateStates::getBSessionActive () const {
    return _bSessionActive;
}

inline void trUpdateStates::setBSessionActive (bool bSessionActive_) {
    set_has_bSessionActive();
    this->_bSessionActive = bSessionActive_;
}

inline void trUpdateStates::clearStates() {
    if (hasStates()) {
         clear_has_states();
        _states.clear();
     }
}

inline bool trUpdateStates::hasStates () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< trUpdateState >& trUpdateStates::getStates () const {
    return _states;
}

inline ::std::vector< trUpdateState >& trUpdateStates::getStatesMutable () {
    set_has_states();
    return _states;
}

inline void trUpdateStates::setStates (const ::std::vector< trUpdateState >& states_) {
    set_has_states();
    this->_states = states_;
}

inline void trUpdateStates::set_has_bSessionActive () {
    _has_bits_[0] |= 1u << 0;
}

inline void trUpdateStates::clear_has_bSessionActive () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trUpdateStates::set_has_states () {
    _has_bits_[0] |= 1u << 1;
}

inline void trUpdateStates::clear_has_states () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trDisplayBgImage::trDisplayBgImage ()  :
    _imgDirPath (),
    _imgName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trDisplayBgImage::trDisplayBgImage (const trDisplayBgImage &rhs)  :
    _imgDirPath (),
    _imgName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trDisplayBgImage::trDisplayBgImage (const ::std::string& imgDirPath_, const ::std::string& imgName_)  :
    _imgDirPath (imgDirPath_),
    _imgName (imgName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imgDirPath_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imgName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trDisplayBgImage::~trDisplayBgImage() {
}

inline trDisplayBgImage& trDisplayBgImage::operator = (const trDisplayBgImage& rhs) {
    if( this != &rhs ) {
        if (rhs.hasImgDirPath()) {
            setImgDirPath(rhs.getImgDirPath());
        } else {
            clearImgDirPath();
        }
        if (rhs.hasImgName()) {
            setImgName(rhs.getImgName());
        } else {
            clearImgName();
        }
    }
    return *this;
}

inline bool trDisplayBgImage::operator == (const trDisplayBgImage& rhs) const {
    return (((!hasImgDirPath() && !rhs.hasImgDirPath()) || getImgDirPath() == rhs.getImgDirPath()) &&
        ((!hasImgName() && !rhs.hasImgName()) || getImgName() == rhs.getImgName()));
}

inline bool trDisplayBgImage::operator != (const trDisplayBgImage& rhs) const {
    return ! (*this == rhs);
}

inline bool trDisplayBgImage::operator < (const trDisplayBgImage& rhs) const {
    if (hasImgDirPath() || rhs.hasImgDirPath()) {
        if (getImgDirPath() < rhs.getImgDirPath()) return true;
        if (getImgDirPath() > rhs.getImgDirPath()) return false;
    }
    if (hasImgName() || rhs.hasImgName()) {
        if (getImgName() < rhs.getImgName()) return true;
        if (getImgName() > rhs.getImgName()) return false;
    }
    return false;
}

inline bool trDisplayBgImage::operator > (const trDisplayBgImage& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trDisplayBgImage::clear() {
    clearImgDirPath();
    clearImgName();
}

inline void trDisplayBgImage::clearImgDirPath() {
    if (hasImgDirPath()) {
         clear_has_imgDirPath();
        _imgDirPath.clear();
     }
}

inline bool trDisplayBgImage::hasImgDirPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& trDisplayBgImage::getImgDirPath () const {
    return _imgDirPath;
}

inline ::std::string& trDisplayBgImage::getImgDirPathMutable () {
    set_has_imgDirPath();
    return _imgDirPath;
}

inline void trDisplayBgImage::setImgDirPath (const ::std::string& imgDirPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imgDirPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imgDirPath();
    this->_imgDirPath = imgDirPath_;
}

inline void trDisplayBgImage::setImgDirPath (const char* imgDirPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imgDirPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imgDirPath();
    this->_imgDirPath.assign(imgDirPath_);
}

inline void trDisplayBgImage::setImgDirPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imgDirPath();
    this->_imgDirPath.assign(value, size);
}

inline void trDisplayBgImage::clearImgName() {
    if (hasImgName()) {
         clear_has_imgName();
        _imgName.clear();
     }
}

inline bool trDisplayBgImage::hasImgName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trDisplayBgImage::getImgName () const {
    return _imgName;
}

inline ::std::string& trDisplayBgImage::getImgNameMutable () {
    set_has_imgName();
    return _imgName;
}

inline void trDisplayBgImage::setImgName (const ::std::string& imgName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imgName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imgName();
    this->_imgName = imgName_;
}

inline void trDisplayBgImage::setImgName (const char* imgName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (imgName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imgName();
    this->_imgName.assign(imgName_);
}

inline void trDisplayBgImage::setImgName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_imgName();
    this->_imgName.assign(value, size);
}

inline void trDisplayBgImage::set_has_imgDirPath () {
    _has_bits_[0] |= 1u << 0;
}

inline void trDisplayBgImage::clear_has_imgDirPath () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trDisplayBgImage::set_has_imgName () {
    _has_bits_[0] |= 1u << 1;
}

inline void trDisplayBgImage::clear_has_imgName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EnterUpdateSessionResponse::EnterUpdateSessionResponse ()  :
    _bOk (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EnterUpdateSessionResponse::EnterUpdateSessionResponse (const EnterUpdateSessionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _bOk (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EnterUpdateSessionResponse::EnterUpdateSessionResponse (bool bOk_)  :
    _bOk (bOk_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EnterUpdateSessionResponse::~EnterUpdateSessionResponse() {
}

inline EnterUpdateSessionResponse& EnterUpdateSessionResponse::operator = (const EnterUpdateSessionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBOk()) {
            setBOk(rhs.getBOk());
        } else {
            clearBOk();
        }
    }
    return *this;
}

inline bool EnterUpdateSessionResponse::operator == (const EnterUpdateSessionResponse& rhs) const {
    return (((!hasBOk() && !rhs.hasBOk()) || getBOk() == rhs.getBOk()));
}

inline bool EnterUpdateSessionResponse::operator != (const EnterUpdateSessionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EnterUpdateSessionResponse::operator < (const EnterUpdateSessionResponse& rhs) const {
    if (hasBOk() || rhs.hasBOk()) {
        if (getBOk() < rhs.getBOk()) return true;
        if (getBOk() > rhs.getBOk()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EnterUpdateSessionResponse::clone() {
    return new EnterUpdateSessionResponse(*this);
}

inline bool EnterUpdateSessionResponse::operator > (const EnterUpdateSessionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EnterUpdateSessionResponse::clear() {
    clearBOk();
}

inline void EnterUpdateSessionResponse::clearBOk() {
    if (hasBOk()) {
         clear_has_bOk();
        _bOk = false;
     }
}

inline bool EnterUpdateSessionResponse::hasBOk () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool EnterUpdateSessionResponse::getBOk () const {
    return _bOk;
}

inline void EnterUpdateSessionResponse::setBOk (bool bOk_) {
    set_has_bOk();
    this->_bOk = bOk_;
}

inline void EnterUpdateSessionResponse::set_has_bOk () {
    _has_bits_[0] |= 1u << 0;
}

inline void EnterUpdateSessionResponse::clear_has_bOk () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ExitUpdateSessionResponse::ExitUpdateSessionResponse ()  :
    _bOk (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ExitUpdateSessionResponse::ExitUpdateSessionResponse (const ExitUpdateSessionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _bOk (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ExitUpdateSessionResponse::ExitUpdateSessionResponse (bool bOk_)  :
    _bOk (bOk_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ExitUpdateSessionResponse::~ExitUpdateSessionResponse() {
}

inline ExitUpdateSessionResponse& ExitUpdateSessionResponse::operator = (const ExitUpdateSessionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBOk()) {
            setBOk(rhs.getBOk());
        } else {
            clearBOk();
        }
    }
    return *this;
}

inline bool ExitUpdateSessionResponse::operator == (const ExitUpdateSessionResponse& rhs) const {
    return (((!hasBOk() && !rhs.hasBOk()) || getBOk() == rhs.getBOk()));
}

inline bool ExitUpdateSessionResponse::operator != (const ExitUpdateSessionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ExitUpdateSessionResponse::operator < (const ExitUpdateSessionResponse& rhs) const {
    if (hasBOk() || rhs.hasBOk()) {
        if (getBOk() < rhs.getBOk()) return true;
        if (getBOk() > rhs.getBOk()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ExitUpdateSessionResponse::clone() {
    return new ExitUpdateSessionResponse(*this);
}

inline bool ExitUpdateSessionResponse::operator > (const ExitUpdateSessionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ExitUpdateSessionResponse::clear() {
    clearBOk();
}

inline void ExitUpdateSessionResponse::clearBOk() {
    if (hasBOk()) {
         clear_has_bOk();
        _bOk = false;
     }
}

inline bool ExitUpdateSessionResponse::hasBOk () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ExitUpdateSessionResponse::getBOk () const {
    return _bOk;
}

inline void ExitUpdateSessionResponse::setBOk (bool bOk_) {
    set_has_bOk();
    this->_bOk = bOk_;
}

inline void ExitUpdateSessionResponse::set_has_bOk () {
    _has_bits_[0] |= 1u << 0;
}

inline void ExitUpdateSessionResponse::clear_has_bOk () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AbortInstallRequest::AbortInstallRequest ()  :
    _inModId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AbortInstallRequest::AbortInstallRequest (const AbortInstallRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _inModId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AbortInstallRequest::AbortInstallRequest (const ::std::string& inModId_)  :
    _inModId (inModId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (inModId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AbortInstallRequest::~AbortInstallRequest() {
}

inline AbortInstallRequest& AbortInstallRequest::operator = (const AbortInstallRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInModId()) {
            setInModId(rhs.getInModId());
        } else {
            clearInModId();
        }
    }
    return *this;
}

inline bool AbortInstallRequest::operator == (const AbortInstallRequest& rhs) const {
    return (((!hasInModId() && !rhs.hasInModId()) || getInModId() == rhs.getInModId()));
}

inline bool AbortInstallRequest::operator != (const AbortInstallRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AbortInstallRequest::operator < (const AbortInstallRequest& rhs) const {
    if (hasInModId() || rhs.hasInModId()) {
        if (getInModId() < rhs.getInModId()) return true;
        if (getInModId() > rhs.getInModId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AbortInstallRequest::clone() {
    return new AbortInstallRequest(*this);
}

inline bool AbortInstallRequest::operator > (const AbortInstallRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AbortInstallRequest::clear() {
    clearInModId();
}

inline void AbortInstallRequest::clearInModId() {
    if (hasInModId()) {
         clear_has_inModId();
        _inModId.clear();
     }
}

inline bool AbortInstallRequest::hasInModId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AbortInstallRequest::getInModId () const {
    return _inModId;
}

inline ::std::string& AbortInstallRequest::getInModIdMutable () {
    set_has_inModId();
    return _inModId;
}

inline void AbortInstallRequest::setInModId (const ::std::string& inModId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (inModId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_inModId();
    this->_inModId = inModId_;
}

inline void AbortInstallRequest::setInModId (const char* inModId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (inModId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_inModId();
    this->_inModId.assign(inModId_);
}

inline void AbortInstallRequest::setInModId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_inModId();
    this->_inModId.assign(value, size);
}

inline void AbortInstallRequest::set_has_inModId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AbortInstallRequest::clear_has_inModId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AbortInstallResponse::AbortInstallResponse ()  :
    _bOk (false),
    _outModId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AbortInstallResponse::AbortInstallResponse (const AbortInstallResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _bOk (false),
    _outModId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AbortInstallResponse::AbortInstallResponse (bool bOk_, const ::std::string& outModId_)  :
    _bOk (bOk_),
    _outModId (outModId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outModId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AbortInstallResponse::~AbortInstallResponse() {
}

inline AbortInstallResponse& AbortInstallResponse::operator = (const AbortInstallResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBOk()) {
            setBOk(rhs.getBOk());
        } else {
            clearBOk();
        }
        if (rhs.hasOutModId()) {
            setOutModId(rhs.getOutModId());
        } else {
            clearOutModId();
        }
    }
    return *this;
}

inline bool AbortInstallResponse::operator == (const AbortInstallResponse& rhs) const {
    return (((!hasBOk() && !rhs.hasBOk()) || getBOk() == rhs.getBOk()) &&
        ((!hasOutModId() && !rhs.hasOutModId()) || getOutModId() == rhs.getOutModId()));
}

inline bool AbortInstallResponse::operator != (const AbortInstallResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool AbortInstallResponse::operator < (const AbortInstallResponse& rhs) const {
    if (hasBOk() || rhs.hasBOk()) {
        if (getBOk() < rhs.getBOk()) return true;
        if (getBOk() > rhs.getBOk()) return false;
    }
    if (hasOutModId() || rhs.hasOutModId()) {
        if (getOutModId() < rhs.getOutModId()) return true;
        if (getOutModId() > rhs.getOutModId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AbortInstallResponse::clone() {
    return new AbortInstallResponse(*this);
}

inline bool AbortInstallResponse::operator > (const AbortInstallResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AbortInstallResponse::clear() {
    clearBOk();
    clearOutModId();
}

inline void AbortInstallResponse::clearBOk() {
    if (hasBOk()) {
         clear_has_bOk();
        _bOk = false;
     }
}

inline bool AbortInstallResponse::hasBOk () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AbortInstallResponse::getBOk () const {
    return _bOk;
}

inline void AbortInstallResponse::setBOk (bool bOk_) {
    set_has_bOk();
    this->_bOk = bOk_;
}

inline void AbortInstallResponse::clearOutModId() {
    if (hasOutModId()) {
         clear_has_outModId();
        _outModId.clear();
     }
}

inline bool AbortInstallResponse::hasOutModId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& AbortInstallResponse::getOutModId () const {
    return _outModId;
}

inline ::std::string& AbortInstallResponse::getOutModIdMutable () {
    set_has_outModId();
    return _outModId;
}

inline void AbortInstallResponse::setOutModId (const ::std::string& outModId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outModId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outModId();
    this->_outModId = outModId_;
}

inline void AbortInstallResponse::setOutModId (const char* outModId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outModId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outModId();
    this->_outModId.assign(outModId_);
}

inline void AbortInstallResponse::setOutModId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outModId();
    this->_outModId.assign(value, size);
}

inline void AbortInstallResponse::set_has_bOk () {
    _has_bits_[0] |= 1u << 0;
}

inline void AbortInstallResponse::clear_has_bOk () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AbortInstallResponse::set_has_outModId () {
    _has_bits_[0] |= 1u << 1;
}

inline void AbortInstallResponse::clear_has_outModId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RequestRecoveryDownloadResponse::RequestRecoveryDownloadResponse ()  :
    _bOk (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestRecoveryDownloadResponse::RequestRecoveryDownloadResponse (const RequestRecoveryDownloadResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _bOk (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestRecoveryDownloadResponse::RequestRecoveryDownloadResponse (bool bOk_)  :
    _bOk (bOk_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestRecoveryDownloadResponse::~RequestRecoveryDownloadResponse() {
}

inline RequestRecoveryDownloadResponse& RequestRecoveryDownloadResponse::operator = (const RequestRecoveryDownloadResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBOk()) {
            setBOk(rhs.getBOk());
        } else {
            clearBOk();
        }
    }
    return *this;
}

inline bool RequestRecoveryDownloadResponse::operator == (const RequestRecoveryDownloadResponse& rhs) const {
    return (((!hasBOk() && !rhs.hasBOk()) || getBOk() == rhs.getBOk()));
}

inline bool RequestRecoveryDownloadResponse::operator != (const RequestRecoveryDownloadResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestRecoveryDownloadResponse::operator < (const RequestRecoveryDownloadResponse& rhs) const {
    if (hasBOk() || rhs.hasBOk()) {
        if (getBOk() < rhs.getBOk()) return true;
        if (getBOk() > rhs.getBOk()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestRecoveryDownloadResponse::clone() {
    return new RequestRecoveryDownloadResponse(*this);
}

inline bool RequestRecoveryDownloadResponse::operator > (const RequestRecoveryDownloadResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestRecoveryDownloadResponse::clear() {
    clearBOk();
}

inline void RequestRecoveryDownloadResponse::clearBOk() {
    if (hasBOk()) {
         clear_has_bOk();
        _bOk = false;
     }
}

inline bool RequestRecoveryDownloadResponse::hasBOk () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RequestRecoveryDownloadResponse::getBOk () const {
    return _bOk;
}

inline void RequestRecoveryDownloadResponse::setBOk (bool bOk_) {
    set_has_bOk();
    this->_bOk = bOk_;
}

inline void RequestRecoveryDownloadResponse::set_has_bOk () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestRecoveryDownloadResponse::clear_has_bOk () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetIsoPathRequest::SetIsoPathRequest ()  :
    _inIsoPath (),
    _rCkSum ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetIsoPathRequest::SetIsoPathRequest (const SetIsoPathRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _inIsoPath (),
    _rCkSum ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetIsoPathRequest::SetIsoPathRequest (const ::std::string& inIsoPath_, const trCkSum& rCkSum_)  :
    _inIsoPath (inIsoPath_),
    _rCkSum (rCkSum_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (inIsoPath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetIsoPathRequest::~SetIsoPathRequest() {
}

inline SetIsoPathRequest& SetIsoPathRequest::operator = (const SetIsoPathRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInIsoPath()) {
            setInIsoPath(rhs.getInIsoPath());
        } else {
            clearInIsoPath();
        }
        if (rhs.hasRCkSum()) {
            setRCkSum(rhs.getRCkSum());
        } else {
            clearRCkSum();
        }
    }
    return *this;
}

inline bool SetIsoPathRequest::operator == (const SetIsoPathRequest& rhs) const {
    return (((!hasInIsoPath() && !rhs.hasInIsoPath()) || getInIsoPath() == rhs.getInIsoPath()) &&
        ((!hasRCkSum() && !rhs.hasRCkSum()) || getRCkSum() == rhs.getRCkSum()));
}

inline bool SetIsoPathRequest::operator != (const SetIsoPathRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetIsoPathRequest::operator < (const SetIsoPathRequest& rhs) const {
    if (hasInIsoPath() || rhs.hasInIsoPath()) {
        if (getInIsoPath() < rhs.getInIsoPath()) return true;
        if (getInIsoPath() > rhs.getInIsoPath()) return false;
    }
    if (hasRCkSum() || rhs.hasRCkSum()) {
        if (getRCkSum() < rhs.getRCkSum()) return true;
        if (getRCkSum() > rhs.getRCkSum()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetIsoPathRequest::clone() {
    return new SetIsoPathRequest(*this);
}

inline bool SetIsoPathRequest::operator > (const SetIsoPathRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetIsoPathRequest::clear() {
    clearInIsoPath();
    clearRCkSum();
}

inline void SetIsoPathRequest::clearInIsoPath() {
    if (hasInIsoPath()) {
         clear_has_inIsoPath();
        _inIsoPath.clear();
     }
}

inline bool SetIsoPathRequest::hasInIsoPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetIsoPathRequest::getInIsoPath () const {
    return _inIsoPath;
}

inline ::std::string& SetIsoPathRequest::getInIsoPathMutable () {
    set_has_inIsoPath();
    return _inIsoPath;
}

inline void SetIsoPathRequest::setInIsoPath (const ::std::string& inIsoPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (inIsoPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_inIsoPath();
    this->_inIsoPath = inIsoPath_;
}

inline void SetIsoPathRequest::setInIsoPath (const char* inIsoPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (inIsoPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_inIsoPath();
    this->_inIsoPath.assign(inIsoPath_);
}

inline void SetIsoPathRequest::setInIsoPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_inIsoPath();
    this->_inIsoPath.assign(value, size);
}

inline void SetIsoPathRequest::clearRCkSum() {
    if (hasRCkSum()) {
         clear_has_rCkSum();
        _rCkSum.clear();
     }
}

inline bool SetIsoPathRequest::hasRCkSum () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const trCkSum& SetIsoPathRequest::getRCkSum () const {
    return _rCkSum;
}

inline trCkSum& SetIsoPathRequest::getRCkSumMutable () {
    set_has_rCkSum();
    return _rCkSum;
}

inline void SetIsoPathRequest::setRCkSum (const trCkSum& rCkSum_) {
    set_has_rCkSum();
    this->_rCkSum = rCkSum_;
}

inline void SetIsoPathRequest::set_has_inIsoPath () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetIsoPathRequest::clear_has_inIsoPath () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetIsoPathRequest::set_has_rCkSum () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetIsoPathRequest::clear_has_rCkSum () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetIsoPathResponse::SetIsoPathResponse ()  :
    _bOk (false),
    _outIsoPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetIsoPathResponse::SetIsoPathResponse (const SetIsoPathResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _bOk (false),
    _outIsoPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetIsoPathResponse::SetIsoPathResponse (bool bOk_, const ::std::string& outIsoPath_)  :
    _bOk (bOk_),
    _outIsoPath (outIsoPath_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outIsoPath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetIsoPathResponse::~SetIsoPathResponse() {
}

inline SetIsoPathResponse& SetIsoPathResponse::operator = (const SetIsoPathResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBOk()) {
            setBOk(rhs.getBOk());
        } else {
            clearBOk();
        }
        if (rhs.hasOutIsoPath()) {
            setOutIsoPath(rhs.getOutIsoPath());
        } else {
            clearOutIsoPath();
        }
    }
    return *this;
}

inline bool SetIsoPathResponse::operator == (const SetIsoPathResponse& rhs) const {
    return (((!hasBOk() && !rhs.hasBOk()) || getBOk() == rhs.getBOk()) &&
        ((!hasOutIsoPath() && !rhs.hasOutIsoPath()) || getOutIsoPath() == rhs.getOutIsoPath()));
}

inline bool SetIsoPathResponse::operator != (const SetIsoPathResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetIsoPathResponse::operator < (const SetIsoPathResponse& rhs) const {
    if (hasBOk() || rhs.hasBOk()) {
        if (getBOk() < rhs.getBOk()) return true;
        if (getBOk() > rhs.getBOk()) return false;
    }
    if (hasOutIsoPath() || rhs.hasOutIsoPath()) {
        if (getOutIsoPath() < rhs.getOutIsoPath()) return true;
        if (getOutIsoPath() > rhs.getOutIsoPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetIsoPathResponse::clone() {
    return new SetIsoPathResponse(*this);
}

inline bool SetIsoPathResponse::operator > (const SetIsoPathResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetIsoPathResponse::clear() {
    clearBOk();
    clearOutIsoPath();
}

inline void SetIsoPathResponse::clearBOk() {
    if (hasBOk()) {
         clear_has_bOk();
        _bOk = false;
     }
}

inline bool SetIsoPathResponse::hasBOk () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetIsoPathResponse::getBOk () const {
    return _bOk;
}

inline void SetIsoPathResponse::setBOk (bool bOk_) {
    set_has_bOk();
    this->_bOk = bOk_;
}

inline void SetIsoPathResponse::clearOutIsoPath() {
    if (hasOutIsoPath()) {
         clear_has_outIsoPath();
        _outIsoPath.clear();
     }
}

inline bool SetIsoPathResponse::hasOutIsoPath () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SetIsoPathResponse::getOutIsoPath () const {
    return _outIsoPath;
}

inline ::std::string& SetIsoPathResponse::getOutIsoPathMutable () {
    set_has_outIsoPath();
    return _outIsoPath;
}

inline void SetIsoPathResponse::setOutIsoPath (const ::std::string& outIsoPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outIsoPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outIsoPath();
    this->_outIsoPath = outIsoPath_;
}

inline void SetIsoPathResponse::setOutIsoPath (const char* outIsoPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outIsoPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outIsoPath();
    this->_outIsoPath.assign(outIsoPath_);
}

inline void SetIsoPathResponse::setOutIsoPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outIsoPath();
    this->_outIsoPath.assign(value, size);
}

inline void SetIsoPathResponse::set_has_bOk () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetIsoPathResponse::clear_has_bOk () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetIsoPathResponse::set_has_outIsoPath () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetIsoPathResponse::clear_has_outIsoPath () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StartInstallRequest::StartInstallRequest ()  :
    _inModId (),
    _toolsContainer (),
    _usbLogPath (),
    _toolsCksum (),
    _dataFile (),
    _dataFileDataCksum (),
    _keyValuePairs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartInstallRequest::StartInstallRequest (const StartInstallRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _inModId (),
    _toolsContainer (),
    _usbLogPath (),
    _toolsCksum (),
    _dataFile (),
    _dataFileDataCksum (),
    _keyValuePairs ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartInstallRequest::StartInstallRequest (const ::std::string& inModId_, const ::std::string& toolsContainer_, const ::std::string& usbLogPath_, const trCkSum& toolsCksum_, const ::std::string& dataFile_, const trCkSum& dataFileDataCksum_, const trKeyValuePairs& keyValuePairs_)  :
    _inModId (inModId_),
    _toolsContainer (toolsContainer_),
    _usbLogPath (usbLogPath_),
    _toolsCksum (toolsCksum_),
    _dataFile (dataFile_),
    _dataFileDataCksum (dataFileDataCksum_),
    _keyValuePairs (keyValuePairs_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (inModId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (toolsContainer_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (usbLogPath_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (dataFile_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartInstallRequest::~StartInstallRequest() {
}

inline StartInstallRequest& StartInstallRequest::operator = (const StartInstallRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInModId()) {
            setInModId(rhs.getInModId());
        } else {
            clearInModId();
        }
        if (rhs.hasToolsContainer()) {
            setToolsContainer(rhs.getToolsContainer());
        } else {
            clearToolsContainer();
        }
        if (rhs.hasUsbLogPath()) {
            setUsbLogPath(rhs.getUsbLogPath());
        } else {
            clearUsbLogPath();
        }
        if (rhs.hasToolsCksum()) {
            setToolsCksum(rhs.getToolsCksum());
        } else {
            clearToolsCksum();
        }
        if (rhs.hasDataFile()) {
            setDataFile(rhs.getDataFile());
        } else {
            clearDataFile();
        }
        if (rhs.hasDataFileDataCksum()) {
            setDataFileDataCksum(rhs.getDataFileDataCksum());
        } else {
            clearDataFileDataCksum();
        }
        if (rhs.hasKeyValuePairs()) {
            setKeyValuePairs(rhs.getKeyValuePairs());
        } else {
            clearKeyValuePairs();
        }
    }
    return *this;
}

inline bool StartInstallRequest::operator == (const StartInstallRequest& rhs) const {
    return (((!hasInModId() && !rhs.hasInModId()) || getInModId() == rhs.getInModId()) &&
        ((!hasToolsContainer() && !rhs.hasToolsContainer()) || getToolsContainer() == rhs.getToolsContainer()) &&
        ((!hasUsbLogPath() && !rhs.hasUsbLogPath()) || getUsbLogPath() == rhs.getUsbLogPath()) &&
        ((!hasToolsCksum() && !rhs.hasToolsCksum()) || getToolsCksum() == rhs.getToolsCksum()) &&
        ((!hasDataFile() && !rhs.hasDataFile()) || getDataFile() == rhs.getDataFile()) &&
        ((!hasDataFileDataCksum() && !rhs.hasDataFileDataCksum()) || getDataFileDataCksum() == rhs.getDataFileDataCksum()) &&
        ((!hasKeyValuePairs() && !rhs.hasKeyValuePairs()) || getKeyValuePairs() == rhs.getKeyValuePairs()));
}

inline bool StartInstallRequest::operator != (const StartInstallRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartInstallRequest::operator < (const StartInstallRequest& rhs) const {
    if (hasInModId() || rhs.hasInModId()) {
        if (getInModId() < rhs.getInModId()) return true;
        if (getInModId() > rhs.getInModId()) return false;
    }
    if (hasToolsContainer() || rhs.hasToolsContainer()) {
        if (getToolsContainer() < rhs.getToolsContainer()) return true;
        if (getToolsContainer() > rhs.getToolsContainer()) return false;
    }
    if (hasUsbLogPath() || rhs.hasUsbLogPath()) {
        if (getUsbLogPath() < rhs.getUsbLogPath()) return true;
        if (getUsbLogPath() > rhs.getUsbLogPath()) return false;
    }
    if (hasToolsCksum() || rhs.hasToolsCksum()) {
        if (getToolsCksum() < rhs.getToolsCksum()) return true;
        if (getToolsCksum() > rhs.getToolsCksum()) return false;
    }
    if (hasDataFile() || rhs.hasDataFile()) {
        if (getDataFile() < rhs.getDataFile()) return true;
        if (getDataFile() > rhs.getDataFile()) return false;
    }
    if (hasDataFileDataCksum() || rhs.hasDataFileDataCksum()) {
        if (getDataFileDataCksum() < rhs.getDataFileDataCksum()) return true;
        if (getDataFileDataCksum() > rhs.getDataFileDataCksum()) return false;
    }
    if (hasKeyValuePairs() || rhs.hasKeyValuePairs()) {
        if (getKeyValuePairs() < rhs.getKeyValuePairs()) return true;
        if (getKeyValuePairs() > rhs.getKeyValuePairs()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartInstallRequest::clone() {
    return new StartInstallRequest(*this);
}

inline bool StartInstallRequest::operator > (const StartInstallRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartInstallRequest::clear() {
    clearInModId();
    clearToolsContainer();
    clearUsbLogPath();
    clearToolsCksum();
    clearDataFile();
    clearDataFileDataCksum();
    clearKeyValuePairs();
}

inline void StartInstallRequest::clearInModId() {
    if (hasInModId()) {
         clear_has_inModId();
        _inModId.clear();
     }
}

inline bool StartInstallRequest::hasInModId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartInstallRequest::getInModId () const {
    return _inModId;
}

inline ::std::string& StartInstallRequest::getInModIdMutable () {
    set_has_inModId();
    return _inModId;
}

inline void StartInstallRequest::setInModId (const ::std::string& inModId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (inModId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_inModId();
    this->_inModId = inModId_;
}

inline void StartInstallRequest::setInModId (const char* inModId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (inModId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_inModId();
    this->_inModId.assign(inModId_);
}

inline void StartInstallRequest::setInModId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_inModId();
    this->_inModId.assign(value, size);
}

inline void StartInstallRequest::clearToolsContainer() {
    if (hasToolsContainer()) {
         clear_has_toolsContainer();
        _toolsContainer.clear();
     }
}

inline bool StartInstallRequest::hasToolsContainer () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& StartInstallRequest::getToolsContainer () const {
    return _toolsContainer;
}

inline ::std::string& StartInstallRequest::getToolsContainerMutable () {
    set_has_toolsContainer();
    return _toolsContainer;
}

inline void StartInstallRequest::setToolsContainer (const ::std::string& toolsContainer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (toolsContainer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_toolsContainer();
    this->_toolsContainer = toolsContainer_;
}

inline void StartInstallRequest::setToolsContainer (const char* toolsContainer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (toolsContainer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_toolsContainer();
    this->_toolsContainer.assign(toolsContainer_);
}

inline void StartInstallRequest::setToolsContainer (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_toolsContainer();
    this->_toolsContainer.assign(value, size);
}

inline void StartInstallRequest::clearUsbLogPath() {
    if (hasUsbLogPath()) {
         clear_has_usbLogPath();
        _usbLogPath.clear();
     }
}

inline bool StartInstallRequest::hasUsbLogPath () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& StartInstallRequest::getUsbLogPath () const {
    return _usbLogPath;
}

inline ::std::string& StartInstallRequest::getUsbLogPathMutable () {
    set_has_usbLogPath();
    return _usbLogPath;
}

inline void StartInstallRequest::setUsbLogPath (const ::std::string& usbLogPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (usbLogPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_usbLogPath();
    this->_usbLogPath = usbLogPath_;
}

inline void StartInstallRequest::setUsbLogPath (const char* usbLogPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (usbLogPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_usbLogPath();
    this->_usbLogPath.assign(usbLogPath_);
}

inline void StartInstallRequest::setUsbLogPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_usbLogPath();
    this->_usbLogPath.assign(value, size);
}

inline void StartInstallRequest::clearToolsCksum() {
    if (hasToolsCksum()) {
         clear_has_toolsCksum();
        _toolsCksum.clear();
     }
}

inline bool StartInstallRequest::hasToolsCksum () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const trCkSum& StartInstallRequest::getToolsCksum () const {
    return _toolsCksum;
}

inline trCkSum& StartInstallRequest::getToolsCksumMutable () {
    set_has_toolsCksum();
    return _toolsCksum;
}

inline void StartInstallRequest::setToolsCksum (const trCkSum& toolsCksum_) {
    set_has_toolsCksum();
    this->_toolsCksum = toolsCksum_;
}

inline void StartInstallRequest::clearDataFile() {
    if (hasDataFile()) {
         clear_has_dataFile();
        _dataFile.clear();
     }
}

inline bool StartInstallRequest::hasDataFile () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& StartInstallRequest::getDataFile () const {
    return _dataFile;
}

inline ::std::string& StartInstallRequest::getDataFileMutable () {
    set_has_dataFile();
    return _dataFile;
}

inline void StartInstallRequest::setDataFile (const ::std::string& dataFile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (dataFile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_dataFile();
    this->_dataFile = dataFile_;
}

inline void StartInstallRequest::setDataFile (const char* dataFile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (dataFile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_dataFile();
    this->_dataFile.assign(dataFile_);
}

inline void StartInstallRequest::setDataFile (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_dataFile();
    this->_dataFile.assign(value, size);
}

inline void StartInstallRequest::clearDataFileDataCksum() {
    if (hasDataFileDataCksum()) {
         clear_has_dataFileDataCksum();
        _dataFileDataCksum.clear();
     }
}

inline bool StartInstallRequest::hasDataFileDataCksum () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const trCkSum& StartInstallRequest::getDataFileDataCksum () const {
    return _dataFileDataCksum;
}

inline trCkSum& StartInstallRequest::getDataFileDataCksumMutable () {
    set_has_dataFileDataCksum();
    return _dataFileDataCksum;
}

inline void StartInstallRequest::setDataFileDataCksum (const trCkSum& dataFileDataCksum_) {
    set_has_dataFileDataCksum();
    this->_dataFileDataCksum = dataFileDataCksum_;
}

inline void StartInstallRequest::clearKeyValuePairs() {
    if (hasKeyValuePairs()) {
         clear_has_keyValuePairs();
        _keyValuePairs.clear();
     }
}

inline bool StartInstallRequest::hasKeyValuePairs () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const trKeyValuePairs& StartInstallRequest::getKeyValuePairs () const {
    return _keyValuePairs;
}

inline trKeyValuePairs& StartInstallRequest::getKeyValuePairsMutable () {
    set_has_keyValuePairs();
    return _keyValuePairs;
}

inline void StartInstallRequest::setKeyValuePairs (const trKeyValuePairs& keyValuePairs_) {
    set_has_keyValuePairs();
    this->_keyValuePairs = keyValuePairs_;
}

inline void StartInstallRequest::set_has_inModId () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartInstallRequest::clear_has_inModId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartInstallRequest::set_has_toolsContainer () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartInstallRequest::clear_has_toolsContainer () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void StartInstallRequest::set_has_usbLogPath () {
    _has_bits_[0] |= 1u << 2;
}

inline void StartInstallRequest::clear_has_usbLogPath () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void StartInstallRequest::set_has_toolsCksum () {
    _has_bits_[0] |= 1u << 3;
}

inline void StartInstallRequest::clear_has_toolsCksum () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void StartInstallRequest::set_has_dataFile () {
    _has_bits_[0] |= 1u << 4;
}

inline void StartInstallRequest::clear_has_dataFile () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void StartInstallRequest::set_has_dataFileDataCksum () {
    _has_bits_[0] |= 1u << 5;
}

inline void StartInstallRequest::clear_has_dataFileDataCksum () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void StartInstallRequest::set_has_keyValuePairs () {
    _has_bits_[0] |= 1u << 6;
}

inline void StartInstallRequest::clear_has_keyValuePairs () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  StartInstallResponse::StartInstallResponse ()  :
    _outModId (),
    _enResult (::ai_sw_update::common::core::imp::SWUCoreService::tenInstallResult__OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartInstallResponse::StartInstallResponse (const StartInstallResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _outModId (),
    _enResult (::ai_sw_update::common::core::imp::SWUCoreService::tenInstallResult__OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartInstallResponse::StartInstallResponse (const ::std::string& outModId_, tenInstallResult enResult_)  :
    _outModId (outModId_),
    _enResult (enResult_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outModId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenInstallResult_IsValid(enResult_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enResult_, "tenInstallResult", "enResult", "StartInstallResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartInstallResponse::~StartInstallResponse() {
}

inline StartInstallResponse& StartInstallResponse::operator = (const StartInstallResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOutModId()) {
            setOutModId(rhs.getOutModId());
        } else {
            clearOutModId();
        }
        if (rhs.hasEnResult()) {
            setEnResult(rhs.getEnResult());
        } else {
            clearEnResult();
        }
    }
    return *this;
}

inline bool StartInstallResponse::operator == (const StartInstallResponse& rhs) const {
    return (((!hasOutModId() && !rhs.hasOutModId()) || getOutModId() == rhs.getOutModId()) &&
        ((!hasEnResult() && !rhs.hasEnResult()) || getEnResult() == rhs.getEnResult()));
}

inline bool StartInstallResponse::operator != (const StartInstallResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool StartInstallResponse::operator < (const StartInstallResponse& rhs) const {
    if (hasOutModId() || rhs.hasOutModId()) {
        if (getOutModId() < rhs.getOutModId()) return true;
        if (getOutModId() > rhs.getOutModId()) return false;
    }
    if (hasEnResult() || rhs.hasEnResult()) {
        if ((uint32)getEnResult() < (uint32)rhs.getEnResult()) return true;
        if ((uint32)getEnResult() > (uint32)rhs.getEnResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartInstallResponse::clone() {
    return new StartInstallResponse(*this);
}

inline bool StartInstallResponse::operator > (const StartInstallResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartInstallResponse::clear() {
    clearOutModId();
    clearEnResult();
}

inline void StartInstallResponse::clearOutModId() {
    if (hasOutModId()) {
         clear_has_outModId();
        _outModId.clear();
     }
}

inline bool StartInstallResponse::hasOutModId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartInstallResponse::getOutModId () const {
    return _outModId;
}

inline ::std::string& StartInstallResponse::getOutModIdMutable () {
    set_has_outModId();
    return _outModId;
}

inline void StartInstallResponse::setOutModId (const ::std::string& outModId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outModId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outModId();
    this->_outModId = outModId_;
}

inline void StartInstallResponse::setOutModId (const char* outModId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outModId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outModId();
    this->_outModId.assign(outModId_);
}

inline void StartInstallResponse::setOutModId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outModId();
    this->_outModId.assign(value, size);
}

inline void StartInstallResponse::clearEnResult() {
    if (hasEnResult()) {
         clear_has_enResult();
        _enResult = ::ai_sw_update::common::core::imp::SWUCoreService::tenInstallResult__OK;
     }
}

inline bool StartInstallResponse::hasEnResult () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline tenInstallResult StartInstallResponse::getEnResult () const {
    return _enResult;
}

inline void StartInstallResponse::setEnResult (tenInstallResult enResult_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenInstallResult_IsValid(enResult_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enResult_, "tenInstallResult", "enResult", "StartInstallResponse");
    }
    set_has_enResult();
    this->_enResult = enResult_;
}

inline void StartInstallResponse::set_has_outModId () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartInstallResponse::clear_has_outModId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartInstallResponse::set_has_enResult () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartInstallResponse::clear_has_enResult () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ConfigUpdateSessionRequest::ConfigUpdateSessionRequest ()  :
    _modIds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConfigUpdateSessionRequest::ConfigUpdateSessionRequest (const ConfigUpdateSessionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _modIds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConfigUpdateSessionRequest::ConfigUpdateSessionRequest (const ::std::vector< ::std::string >& modIds_)  :
    _modIds (modIds_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConfigUpdateSessionRequest::~ConfigUpdateSessionRequest() {
}

inline ConfigUpdateSessionRequest& ConfigUpdateSessionRequest::operator = (const ConfigUpdateSessionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasModIds()) {
            setModIds(rhs.getModIds());
        } else {
            clearModIds();
        }
    }
    return *this;
}

inline bool ConfigUpdateSessionRequest::operator == (const ConfigUpdateSessionRequest& rhs) const {
    return (((!hasModIds() && !rhs.hasModIds()) || getModIds() == rhs.getModIds()));
}

inline bool ConfigUpdateSessionRequest::operator != (const ConfigUpdateSessionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ConfigUpdateSessionRequest::operator < (const ConfigUpdateSessionRequest& rhs) const {
    if (hasModIds() || rhs.hasModIds()) {
        if (getModIds() < rhs.getModIds()) return true;
        if (getModIds() > rhs.getModIds()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConfigUpdateSessionRequest::clone() {
    return new ConfigUpdateSessionRequest(*this);
}

inline bool ConfigUpdateSessionRequest::operator > (const ConfigUpdateSessionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConfigUpdateSessionRequest::clear() {
    clearModIds();
}

inline void ConfigUpdateSessionRequest::clearModIds() {
    if (hasModIds()) {
         clear_has_modIds();
        _modIds.clear();
     }
}

inline bool ConfigUpdateSessionRequest::hasModIds () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& ConfigUpdateSessionRequest::getModIds () const {
    return _modIds;
}

inline ::std::vector< ::std::string >& ConfigUpdateSessionRequest::getModIdsMutable () {
    set_has_modIds();
    return _modIds;
}

inline void ConfigUpdateSessionRequest::setModIds (const ::std::vector< ::std::string >& modIds_) {
    set_has_modIds();
    this->_modIds = modIds_;
}

inline void ConfigUpdateSessionRequest::set_has_modIds () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConfigUpdateSessionRequest::clear_has_modIds () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ProgressUpdate::ProgressUpdate ()  :
    _Progress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProgressUpdate::ProgressUpdate (const ProgressUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Progress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProgressUpdate::ProgressUpdate (const trProgress& Progress_)  :
    _Progress (Progress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProgressUpdate::~ProgressUpdate() {
}

inline ProgressUpdate& ProgressUpdate::operator = (const ProgressUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProgress()) {
            setProgress(rhs.getProgress());
        } else {
            clearProgress();
        }
    }
    return *this;
}

inline bool ProgressUpdate::operator == (const ProgressUpdate& rhs) const {
    return (((!hasProgress() && !rhs.hasProgress()) || getProgress() == rhs.getProgress()));
}

inline bool ProgressUpdate::operator != (const ProgressUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ProgressUpdate::operator < (const ProgressUpdate& rhs) const {
    if (hasProgress() || rhs.hasProgress()) {
        if (getProgress() < rhs.getProgress()) return true;
        if (getProgress() > rhs.getProgress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProgressUpdate::clone() {
    return new ProgressUpdate(*this);
}

inline bool ProgressUpdate::operator > (const ProgressUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProgressUpdate::clear() {
    clearProgress();
}

inline void ProgressUpdate::clearProgress() {
    if (hasProgress()) {
         clear_has_Progress();
        _Progress.clear();
     }
}

inline bool ProgressUpdate::hasProgress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trProgress& ProgressUpdate::getProgress () const {
    return _Progress;
}

inline trProgress& ProgressUpdate::getProgressMutable () {
    set_has_Progress();
    return _Progress;
}

inline void ProgressUpdate::setProgress (const trProgress& Progress_) {
    set_has_Progress();
    this->_Progress = Progress_;
}

inline void ProgressUpdate::set_has_Progress () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProgressUpdate::clear_has_Progress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ProgressRegister::ProgressRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProgressRegister::ProgressRegister (const ProgressRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProgressRegister::~ProgressRegister() {
}

inline ProgressRegister& ProgressRegister::operator = (const ProgressRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ProgressRegister::operator == (const ProgressRegister& ) const {
    return true;
}

inline bool ProgressRegister::operator != (const ProgressRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ProgressRegister::operator < (const ProgressRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ProgressRegister::clone() {
    return new ProgressRegister(*this);
}

inline bool ProgressRegister::operator > (const ProgressRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProgressRegister::clear() {
}

inline  UsbFoundUpdate::UsbFoundUpdate ()  :
    _UsbFound ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UsbFoundUpdate::UsbFoundUpdate (const UsbFoundUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _UsbFound ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UsbFoundUpdate::UsbFoundUpdate (const trUsbFound& UsbFound_)  :
    _UsbFound (UsbFound_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UsbFoundUpdate::~UsbFoundUpdate() {
}

inline UsbFoundUpdate& UsbFoundUpdate::operator = (const UsbFoundUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUsbFound()) {
            setUsbFound(rhs.getUsbFound());
        } else {
            clearUsbFound();
        }
    }
    return *this;
}

inline bool UsbFoundUpdate::operator == (const UsbFoundUpdate& rhs) const {
    return (((!hasUsbFound() && !rhs.hasUsbFound()) || getUsbFound() == rhs.getUsbFound()));
}

inline bool UsbFoundUpdate::operator != (const UsbFoundUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool UsbFoundUpdate::operator < (const UsbFoundUpdate& rhs) const {
    if (hasUsbFound() || rhs.hasUsbFound()) {
        if (getUsbFound() < rhs.getUsbFound()) return true;
        if (getUsbFound() > rhs.getUsbFound()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UsbFoundUpdate::clone() {
    return new UsbFoundUpdate(*this);
}

inline bool UsbFoundUpdate::operator > (const UsbFoundUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UsbFoundUpdate::clear() {
    clearUsbFound();
}

inline void UsbFoundUpdate::clearUsbFound() {
    if (hasUsbFound()) {
         clear_has_UsbFound();
        _UsbFound.clear();
     }
}

inline bool UsbFoundUpdate::hasUsbFound () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trUsbFound& UsbFoundUpdate::getUsbFound () const {
    return _UsbFound;
}

inline trUsbFound& UsbFoundUpdate::getUsbFoundMutable () {
    set_has_UsbFound();
    return _UsbFound;
}

inline void UsbFoundUpdate::setUsbFound (const trUsbFound& UsbFound_) {
    set_has_UsbFound();
    this->_UsbFound = UsbFound_;
}

inline void UsbFoundUpdate::set_has_UsbFound () {
    _has_bits_[0] |= 1u << 0;
}

inline void UsbFoundUpdate::clear_has_UsbFound () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UsbFoundRegister::UsbFoundRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UsbFoundRegister::UsbFoundRegister (const UsbFoundRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UsbFoundRegister::~UsbFoundRegister() {
}

inline UsbFoundRegister& UsbFoundRegister::operator = (const UsbFoundRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool UsbFoundRegister::operator == (const UsbFoundRegister& ) const {
    return true;
}

inline bool UsbFoundRegister::operator != (const UsbFoundRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool UsbFoundRegister::operator < (const UsbFoundRegister& ) const {
    return false;
}

inline ::asf::core::Payload* UsbFoundRegister::clone() {
    return new UsbFoundRegister(*this);
}

inline bool UsbFoundRegister::operator > (const UsbFoundRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UsbFoundRegister::clear() {
}

inline  DisplayTextUpdate::DisplayTextUpdate ()  :
    _DisplayText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisplayTextUpdate::DisplayTextUpdate (const DisplayTextUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DisplayText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisplayTextUpdate::DisplayTextUpdate (const trDisplayText& DisplayText_)  :
    _DisplayText (DisplayText_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DisplayTextUpdate::~DisplayTextUpdate() {
}

inline DisplayTextUpdate& DisplayTextUpdate::operator = (const DisplayTextUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDisplayText()) {
            setDisplayText(rhs.getDisplayText());
        } else {
            clearDisplayText();
        }
    }
    return *this;
}

inline bool DisplayTextUpdate::operator == (const DisplayTextUpdate& rhs) const {
    return (((!hasDisplayText() && !rhs.hasDisplayText()) || getDisplayText() == rhs.getDisplayText()));
}

inline bool DisplayTextUpdate::operator != (const DisplayTextUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DisplayTextUpdate::operator < (const DisplayTextUpdate& rhs) const {
    if (hasDisplayText() || rhs.hasDisplayText()) {
        if (getDisplayText() < rhs.getDisplayText()) return true;
        if (getDisplayText() > rhs.getDisplayText()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DisplayTextUpdate::clone() {
    return new DisplayTextUpdate(*this);
}

inline bool DisplayTextUpdate::operator > (const DisplayTextUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisplayTextUpdate::clear() {
    clearDisplayText();
}

inline void DisplayTextUpdate::clearDisplayText() {
    if (hasDisplayText()) {
         clear_has_DisplayText();
        _DisplayText.clear();
     }
}

inline bool DisplayTextUpdate::hasDisplayText () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trDisplayText& DisplayTextUpdate::getDisplayText () const {
    return _DisplayText;
}

inline trDisplayText& DisplayTextUpdate::getDisplayTextMutable () {
    set_has_DisplayText();
    return _DisplayText;
}

inline void DisplayTextUpdate::setDisplayText (const trDisplayText& DisplayText_) {
    set_has_DisplayText();
    this->_DisplayText = DisplayText_;
}

inline void DisplayTextUpdate::set_has_DisplayText () {
    _has_bits_[0] |= 1u << 0;
}

inline void DisplayTextUpdate::clear_has_DisplayText () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DisplayTextRegister::DisplayTextRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisplayTextRegister::DisplayTextRegister (const DisplayTextRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisplayTextRegister::~DisplayTextRegister() {
}

inline DisplayTextRegister& DisplayTextRegister::operator = (const DisplayTextRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DisplayTextRegister::operator == (const DisplayTextRegister& ) const {
    return true;
}

inline bool DisplayTextRegister::operator != (const DisplayTextRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DisplayTextRegister::operator < (const DisplayTextRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DisplayTextRegister::clone() {
    return new DisplayTextRegister(*this);
}

inline bool DisplayTextRegister::operator > (const DisplayTextRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisplayTextRegister::clear() {
}

inline  UpdateStatesUpdate::UpdateStatesUpdate ()  :
    _UpdateStates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateStatesUpdate::UpdateStatesUpdate (const UpdateStatesUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _UpdateStates ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateStatesUpdate::UpdateStatesUpdate (const trUpdateStates& UpdateStates_)  :
    _UpdateStates (UpdateStates_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateStatesUpdate::~UpdateStatesUpdate() {
}

inline UpdateStatesUpdate& UpdateStatesUpdate::operator = (const UpdateStatesUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUpdateStates()) {
            setUpdateStates(rhs.getUpdateStates());
        } else {
            clearUpdateStates();
        }
    }
    return *this;
}

inline bool UpdateStatesUpdate::operator == (const UpdateStatesUpdate& rhs) const {
    return (((!hasUpdateStates() && !rhs.hasUpdateStates()) || getUpdateStates() == rhs.getUpdateStates()));
}

inline bool UpdateStatesUpdate::operator != (const UpdateStatesUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateStatesUpdate::operator < (const UpdateStatesUpdate& rhs) const {
    if (hasUpdateStates() || rhs.hasUpdateStates()) {
        if (getUpdateStates() < rhs.getUpdateStates()) return true;
        if (getUpdateStates() > rhs.getUpdateStates()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateStatesUpdate::clone() {
    return new UpdateStatesUpdate(*this);
}

inline bool UpdateStatesUpdate::operator > (const UpdateStatesUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateStatesUpdate::clear() {
    clearUpdateStates();
}

inline void UpdateStatesUpdate::clearUpdateStates() {
    if (hasUpdateStates()) {
         clear_has_UpdateStates();
        _UpdateStates.clear();
     }
}

inline bool UpdateStatesUpdate::hasUpdateStates () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trUpdateStates& UpdateStatesUpdate::getUpdateStates () const {
    return _UpdateStates;
}

inline trUpdateStates& UpdateStatesUpdate::getUpdateStatesMutable () {
    set_has_UpdateStates();
    return _UpdateStates;
}

inline void UpdateStatesUpdate::setUpdateStates (const trUpdateStates& UpdateStates_) {
    set_has_UpdateStates();
    this->_UpdateStates = UpdateStates_;
}

inline void UpdateStatesUpdate::set_has_UpdateStates () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateStatesUpdate::clear_has_UpdateStates () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UpdateStatesRegister::UpdateStatesRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateStatesRegister::UpdateStatesRegister (const UpdateStatesRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateStatesRegister::~UpdateStatesRegister() {
}

inline UpdateStatesRegister& UpdateStatesRegister::operator = (const UpdateStatesRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool UpdateStatesRegister::operator == (const UpdateStatesRegister& ) const {
    return true;
}

inline bool UpdateStatesRegister::operator != (const UpdateStatesRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateStatesRegister::operator < (const UpdateStatesRegister& ) const {
    return false;
}

inline ::asf::core::Payload* UpdateStatesRegister::clone() {
    return new UpdateStatesRegister(*this);
}

inline bool UpdateStatesRegister::operator > (const UpdateStatesRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateStatesRegister::clear() {
}

inline  DisplayBgImageUpdate::DisplayBgImageUpdate ()  :
    _DisplayBgImage ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisplayBgImageUpdate::DisplayBgImageUpdate (const DisplayBgImageUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DisplayBgImage ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisplayBgImageUpdate::DisplayBgImageUpdate (const trDisplayBgImage& DisplayBgImage_)  :
    _DisplayBgImage (DisplayBgImage_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DisplayBgImageUpdate::~DisplayBgImageUpdate() {
}

inline DisplayBgImageUpdate& DisplayBgImageUpdate::operator = (const DisplayBgImageUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDisplayBgImage()) {
            setDisplayBgImage(rhs.getDisplayBgImage());
        } else {
            clearDisplayBgImage();
        }
    }
    return *this;
}

inline bool DisplayBgImageUpdate::operator == (const DisplayBgImageUpdate& rhs) const {
    return (((!hasDisplayBgImage() && !rhs.hasDisplayBgImage()) || getDisplayBgImage() == rhs.getDisplayBgImage()));
}

inline bool DisplayBgImageUpdate::operator != (const DisplayBgImageUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DisplayBgImageUpdate::operator < (const DisplayBgImageUpdate& rhs) const {
    if (hasDisplayBgImage() || rhs.hasDisplayBgImage()) {
        if (getDisplayBgImage() < rhs.getDisplayBgImage()) return true;
        if (getDisplayBgImage() > rhs.getDisplayBgImage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DisplayBgImageUpdate::clone() {
    return new DisplayBgImageUpdate(*this);
}

inline bool DisplayBgImageUpdate::operator > (const DisplayBgImageUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisplayBgImageUpdate::clear() {
    clearDisplayBgImage();
}

inline void DisplayBgImageUpdate::clearDisplayBgImage() {
    if (hasDisplayBgImage()) {
         clear_has_DisplayBgImage();
        _DisplayBgImage.clear();
     }
}

inline bool DisplayBgImageUpdate::hasDisplayBgImage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trDisplayBgImage& DisplayBgImageUpdate::getDisplayBgImage () const {
    return _DisplayBgImage;
}

inline trDisplayBgImage& DisplayBgImageUpdate::getDisplayBgImageMutable () {
    set_has_DisplayBgImage();
    return _DisplayBgImage;
}

inline void DisplayBgImageUpdate::setDisplayBgImage (const trDisplayBgImage& DisplayBgImage_) {
    set_has_DisplayBgImage();
    this->_DisplayBgImage = DisplayBgImage_;
}

inline void DisplayBgImageUpdate::set_has_DisplayBgImage () {
    _has_bits_[0] |= 1u << 0;
}

inline void DisplayBgImageUpdate::clear_has_DisplayBgImage () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DisplayBgImageRegister::DisplayBgImageRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisplayBgImageRegister::DisplayBgImageRegister (const DisplayBgImageRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisplayBgImageRegister::~DisplayBgImageRegister() {
}

inline DisplayBgImageRegister& DisplayBgImageRegister::operator = (const DisplayBgImageRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DisplayBgImageRegister::operator == (const DisplayBgImageRegister& ) const {
    return true;
}

inline bool DisplayBgImageRegister::operator != (const DisplayBgImageRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DisplayBgImageRegister::operator < (const DisplayBgImageRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DisplayBgImageRegister::clone() {
    return new DisplayBgImageRegister(*this);
}

inline bool DisplayBgImageRegister::operator > (const DisplayBgImageRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisplayBgImageRegister::clear() {
}

inline  StartInstallResponseSignal::StartInstallResponseSignal ()  :
    _outModId (),
    _enResult (::ai_sw_update::common::core::imp::SWUCoreService::tenInstallResult__OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartInstallResponseSignal::StartInstallResponseSignal (const StartInstallResponseSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _outModId (),
    _enResult (::ai_sw_update::common::core::imp::SWUCoreService::tenInstallResult__OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartInstallResponseSignal::StartInstallResponseSignal (const ::std::string& outModId_, tenInstallResult enResult_)  :
    _outModId (outModId_),
    _enResult (enResult_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outModId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenInstallResult_IsValid(enResult_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enResult_, "tenInstallResult", "enResult", "StartInstallResponseSignal");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartInstallResponseSignal::~StartInstallResponseSignal() {
}

inline StartInstallResponseSignal& StartInstallResponseSignal::operator = (const StartInstallResponseSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOutModId()) {
            setOutModId(rhs.getOutModId());
        } else {
            clearOutModId();
        }
        if (rhs.hasEnResult()) {
            setEnResult(rhs.getEnResult());
        } else {
            clearEnResult();
        }
    }
    return *this;
}

inline bool StartInstallResponseSignal::operator == (const StartInstallResponseSignal& rhs) const {
    return (((!hasOutModId() && !rhs.hasOutModId()) || getOutModId() == rhs.getOutModId()) &&
        ((!hasEnResult() && !rhs.hasEnResult()) || getEnResult() == rhs.getEnResult()));
}

inline bool StartInstallResponseSignal::operator != (const StartInstallResponseSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool StartInstallResponseSignal::operator < (const StartInstallResponseSignal& rhs) const {
    if (hasOutModId() || rhs.hasOutModId()) {
        if (getOutModId() < rhs.getOutModId()) return true;
        if (getOutModId() > rhs.getOutModId()) return false;
    }
    if (hasEnResult() || rhs.hasEnResult()) {
        if ((uint32)getEnResult() < (uint32)rhs.getEnResult()) return true;
        if ((uint32)getEnResult() > (uint32)rhs.getEnResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartInstallResponseSignal::clone() {
    return new StartInstallResponseSignal(*this);
}

inline bool StartInstallResponseSignal::operator > (const StartInstallResponseSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartInstallResponseSignal::clear() {
    clearOutModId();
    clearEnResult();
}

inline void StartInstallResponseSignal::clearOutModId() {
    if (hasOutModId()) {
         clear_has_outModId();
        _outModId.clear();
     }
}

inline bool StartInstallResponseSignal::hasOutModId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartInstallResponseSignal::getOutModId () const {
    return _outModId;
}

inline ::std::string& StartInstallResponseSignal::getOutModIdMutable () {
    set_has_outModId();
    return _outModId;
}

inline void StartInstallResponseSignal::setOutModId (const ::std::string& outModId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outModId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outModId();
    this->_outModId = outModId_;
}

inline void StartInstallResponseSignal::setOutModId (const char* outModId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outModId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outModId();
    this->_outModId.assign(outModId_);
}

inline void StartInstallResponseSignal::setOutModId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outModId();
    this->_outModId.assign(value, size);
}

inline void StartInstallResponseSignal::clearEnResult() {
    if (hasEnResult()) {
         clear_has_enResult();
        _enResult = ::ai_sw_update::common::core::imp::SWUCoreService::tenInstallResult__OK;
     }
}

inline bool StartInstallResponseSignal::hasEnResult () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline tenInstallResult StartInstallResponseSignal::getEnResult () const {
    return _enResult;
}

inline void StartInstallResponseSignal::setEnResult (tenInstallResult enResult_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenInstallResult_IsValid(enResult_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", enResult_, "tenInstallResult", "enResult", "StartInstallResponseSignal");
    }
    set_has_enResult();
    this->_enResult = enResult_;
}

inline void StartInstallResponseSignal::set_has_outModId () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartInstallResponseSignal::clear_has_outModId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartInstallResponseSignal::set_has_enResult () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartInstallResponseSignal::clear_has_enResult () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace SWUCoreService
} // namespace imp
} // namespace core
} // namespace common
} // namespace ai_sw_update

#endif // AI_SW_UPDATE_COMMON_CORE_IMP_SWUCORESERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
