/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SENSOR_LOCATION_FIPROXY_H
#define SENSOR_LOCATION_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "location_fi_types.h"
#include "location_fi_typesConst.h"
#include "sensor_location_fi.h"

namespace sensor_location_fi {

class Sensor_location_fiProxy;

class AbsDataCallbackIF {
public:
    virtual ~AbsDataCallbackIF() {}

    virtual void onAbsDataError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< AbsDataError >& error) = 0;

    virtual void onAbsDataStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< AbsDataStatus >& status) = 0;
};

class Acc3dData_UpdateCallbackIF {
public:
    virtual ~Acc3dData_UpdateCallbackIF() {}

    virtual void onAcc3dData_UpdateError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< Acc3dData_UpdateError >& error) = 0;

    virtual void onAcc3dData_UpdateStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< Acc3dData_UpdateStatus >& status) = 0;
};

class Acc3dGetHwInfoCallbackIF {
public:
    virtual ~Acc3dGetHwInfoCallbackIF() {}

    virtual void onAcc3dGetHwInfoError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< Acc3dGetHwInfoError >& error) = 0;

    virtual void onAcc3dGetHwInfoResult(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< Acc3dGetHwInfoResult >& result) = 0;
};

class AccSelfTestCallbackIF {
public:
    virtual ~AccSelfTestCallbackIF() {}

    virtual void onAccSelfTestError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< AccSelfTestError >& error) = 0;

    virtual void onAccSelfTestResult(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< AccSelfTestResult >& result) = 0;
};

class AccTemperatureCallbackIF {
public:
    virtual ~AccTemperatureCallbackIF() {}

    virtual void onAccTemperatureError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< AccTemperatureError >& error) = 0;

    virtual void onAccTemperatureStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< AccTemperatureStatus >& status) = 0;
};

class AllSensorDataCallbackIF {
public:
    virtual ~AllSensorDataCallbackIF() {}

    virtual void onAllSensorDataError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< AllSensorDataError >& error) = 0;

    virtual void onAllSensorDataStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< AllSensorDataStatus >& status) = 0;
};

class DiagGnssSatSystemCallbackIF {
public:
    virtual ~DiagGnssSatSystemCallbackIF() {}

    virtual void onDiagGnssSatSystemError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< DiagGnssSatSystemError >& error) = 0;

    virtual void onDiagGnssSatSystemStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< DiagGnssSatSystemStatus >& status) = 0;
};

class FactorySettingsCallbackIF {
public:
    virtual ~FactorySettingsCallbackIF() {}

    virtual void onFactorySettingsError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< FactorySettingsError >& error) = 0;

    virtual void onFactorySettingsResult(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< FactorySettingsResult >& result) = 0;
};

class GnssConfigDataCallbackIF {
public:
    virtual ~GnssConfigDataCallbackIF() {}

    virtual void onGnssConfigDataError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssConfigDataError >& error) = 0;

    virtual void onGnssConfigDataStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssConfigDataStatus >& status) = 0;
};

class GnssDataCallbackIF {
public:
    virtual ~GnssDataCallbackIF() {}

    virtual void onGnssDataError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssDataError >& error) = 0;

    virtual void onGnssDataStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssDataStatus >& status) = 0;
};

class GnssSatSystemCallbackIF {
public:
    virtual ~GnssSatSystemCallbackIF() {}

    virtual void onGnssSatSystemError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssSatSystemError >& error) = 0;

    virtual void onGnssSatSystemStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssSatSystemStatus >& status) = 0;
};

class GnssWnEpochCallbackIF {
public:
    virtual ~GnssWnEpochCallbackIF() {}

    virtual void onGnssWnEpochError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssWnEpochError >& error) = 0;

    virtual void onGnssWnEpochStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssWnEpochStatus >& status) = 0;
};

class Gyro3dData_UpdateCallbackIF {
public:
    virtual ~Gyro3dData_UpdateCallbackIF() {}

    virtual void onGyro3dData_UpdateError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< Gyro3dData_UpdateError >& error) = 0;

    virtual void onGyro3dData_UpdateStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< Gyro3dData_UpdateStatus >& status) = 0;
};

class Gyro3dGetHwInfoCallbackIF {
public:
    virtual ~Gyro3dGetHwInfoCallbackIF() {}

    virtual void onGyro3dGetHwInfoError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< Gyro3dGetHwInfoError >& error) = 0;

    virtual void onGyro3dGetHwInfoResult(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< Gyro3dGetHwInfoResult >& result) = 0;
};

class GyroSelfTestCallbackIF {
public:
    virtual ~GyroSelfTestCallbackIF() {}

    virtual void onGyroSelfTestError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GyroSelfTestError >& error) = 0;

    virtual void onGyroSelfTestResult(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GyroSelfTestResult >& result) = 0;
};

class GyroTemperatureCallbackIF {
public:
    virtual ~GyroTemperatureCallbackIF() {}

    virtual void onGyroTemperatureError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GyroTemperatureError >& error) = 0;

    virtual void onGyroTemperatureStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GyroTemperatureStatus >& status) = 0;
};

class OdometerData_UpdateCallbackIF {
public:
    virtual ~OdometerData_UpdateCallbackIF() {}

    virtual void onOdometerData_UpdateError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< OdometerData_UpdateError >& error) = 0;

    virtual void onOdometerData_UpdateStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< OdometerData_UpdateStatus >& status) = 0;
};

class SavePersistentCallbackIF {
public:
    virtual ~SavePersistentCallbackIF() {}

    virtual void onSavePersistentError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< SavePersistentError >& error) = 0;

    virtual void onSavePersistentResult(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< SavePersistentResult >& result) = 0;
};

class UpdateDiagLogCallbackIF {
public:
    virtual ~UpdateDiagLogCallbackIF() {}

    virtual void onUpdateDiagLogError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< UpdateDiagLogError >& error) = 0;

    virtual void onUpdateDiagLogResult(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< UpdateDiagLogResult >& result) = 0;
};

class UpdateFactorySettingsCallbackIF {
public:
    virtual ~UpdateFactorySettingsCallbackIF() {}

    virtual void onUpdateFactorySettingsError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< UpdateFactorySettingsError >& error) = 0;

    virtual void onUpdateFactorySettingsResult(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< UpdateFactorySettingsResult >& result) = 0;
};

class VdsVersionInfoCallbackIF {
public:
    virtual ~VdsVersionInfoCallbackIF() {}

    virtual void onVdsVersionInfoError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< VdsVersionInfoError >& error) = 0;

    virtual void onVdsVersionInfoStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< VdsVersionInfoStatus >& status) = 0;
};

class Sensor_location_fiProxyCallback;

/**
 * Sensor_location_fiProxy is the client side representation of the CCA
 * Functional Interface 'sensor_location_fi' (specified in file
 * sensor_location_fi.xml).
 *
 * CCA Functional Interface 'sensor_location_fi'
 *
 * Fullname: VD_Sensor Functional Interface
 *
 * Version: v1.2.1
 *
 * Author: Kai Fischer, Andreas Vogel, Joachim Frieï¿½
 *
 * Date: $Date: 06.06.2018$
 *
 * Department:
 *       CM-AI/ECO1
 *
 * Title: SensorFI
 *
 * <b>Description of 'sensor_location_fi':</b>
 *
 * This document serves as an reference for the functional
 * interface of the VD_Sensor (SensorFI).
 */
class Sensor_location_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Sensor_location_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sensor_location_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sensor_location_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sensor_location_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sensor_location_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Sensor_location_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Sensor_location_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Sensor_location_fiProxy();

    // Method 'SavePersistent'

    /**
     * Call the method 'SavePersistent'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SavePersistent'</b>:
     *
     * Causes VD Sensor to save all persistent data to persistent memory
     * immediately. (Normally, this is done when the CCA application state
     * changes.)
     *
     * Rationale: Some OEM customers require settings made in diagnostic mode
     * to be saved persistently immediately.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSavePersistentStart(SavePersistentCallbackIF& cb);

    // Method 'UpdateDiagLog'

    /**
     * Call the method 'UpdateDiagLog'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'UpdateDiagLog'</b>:
     *
     * Force VD Sensor to send the current error states to VD Diaglog.  The
     * state of both active and inactive error conditions are sent.  This
     * method is meant to be used after the error memory has been reset to
     * reenter the currently active errors.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUpdateDiagLogStart(UpdateDiagLogCallbackIF& cb);

    // Method 'FactorySettings'

    /**
     * Call the method 'FactorySettings'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'FactorySettings'</b>:
     *
     * Restore factory settings. This method deletes any persistently stored
     * sensor calibration data and forces a GNSS cold start.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFactorySettingsStart(FactorySettingsCallbackIF& cb);

    // Method 'UpdateFactorySettings'

    /**
     * Call the method 'UpdateFactorySettings'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'UpdateFactorySettings'</b>:
     *
     * Restore parts of factory settings. The method updates some parameter
     * for configuration.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DefSetGroup Group ID: e.g. DEFSET_GROUP_MAINTENANCE.
     *
     * @param DefSetMode Mode: e.g. DEFSET_SRC_CODING.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUpdateFactorySettingsStart(UpdateFactorySettingsCallbackIF& cb, ::location_fi_types::T_e8_DefSetGroups defSetGroup, ::location_fi_types::T_e8_DefSetMode defSetMode);

    // Method 'Gyro3dGetHwInfo'

    /**
     * Call the method 'Gyro3dGetHwInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'Gyro3dGetHwInfo'</b>:
     *
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGyro3dGetHwInfoStart(Gyro3dGetHwInfoCallbackIF& cb);

    // Method 'Acc3dGetHwInfo'

    /**
     * Call the method 'Acc3dGetHwInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'Acc3dGetHwInfo'</b>:
     *
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAcc3dGetHwInfoStart(Acc3dGetHwInfoCallbackIF& cb);

    // Method 'GyroSelfTest'

    /**
     * Call the method 'GyroSelfTest'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'GyroSelfTest'</b>:
     *
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGyroSelfTestStart(GyroSelfTestCallbackIF& cb);

    // Method 'AccSelfTest'

    /**
     * Call the method 'AccSelfTest'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'AccSelfTest'</b>:
     *
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAccSelfTestStart(AccSelfTestCallbackIF& cb);

    // Property 'OdometerData_Update'

    /**
     * Notify on the property 'OdometerData_Update'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'OdometerData_Update'</b>:
     *
     * <p>(periodical) odometer-data-messages with a block of odometer values.</p>
     * <p>Attention: starting with version 5.0 the beahavior of this property
     * changed. It delivers actual data only.</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOdometerData_UpdateUpReg(OdometerData_UpdateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'OdometerData_Update'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'OdometerData_Update'</b>:
     *
     * <p>(periodical) odometer-data-messages with a block of odometer values.</p>
     * <p>Attention: starting with version 5.0 the beahavior of this property
     * changed. It delivers actual data only.</p>
     *
     * @param act The act which was previously returned by the
     * sendOdometerData_UpdateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendOdometerData_UpdateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'OdometerData_Update'.
     */
    void sendOdometerData_UpdateRelUpRegAll ();

    /**
     * Returns the current value of the property 'OdometerData_Update' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasOdometerData_Update() returns true.
     *
     * @return the previously received value of the property 'OdometerData_Update'.
     */
    const OdometerData_UpdateStatus& getOdometerData_Update() const;

    /**
     * Determines whether a status message for the property 'OdometerData_Update' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasOdometerData_Update() const;

    /**
     * Request the value of the property 'OdometerData_Update' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'OdometerData_Update'</b>:
     *
     * <p>(periodical) odometer-data-messages with a block of odometer values.</p>
     * <p>Attention: starting with version 5.0 the beahavior of this property
     * changed. It delivers actual data only.</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOdometerData_UpdateGet(OdometerData_UpdateCallbackIF& cb);

    // Property 'AbsData'

    /**
     * Notify on the property 'AbsData'. This method sends a UpReg message to
     * the CCA server.
     *
     * <b>Documentation of 'AbsData'</b>:
     *
     * <p>Periodically updated ABS data property. Contains a block of ABS
     * data records.</p>
     * <p>Attention: starting with version 5.0 the behavior of this property
     * changed. It delivers actual data only.</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAbsDataUpReg(AbsDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AbsData'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AbsData'</b>:
     *
     * <p>Periodically updated ABS data property. Contains a block of ABS
     * data records.</p>
     * <p>Attention: starting with version 5.0 the behavior of this property
     * changed. It delivers actual data only.</p>
     *
     * @param act The act which was previously returned by the
     * sendAbsDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAbsDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AbsData'.
     */
    void sendAbsDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'AbsData' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAbsData()
     * returns true.
     *
     * @return the previously received value of the property 'AbsData'.
     */
    const AbsDataStatus& getAbsData() const;

    /**
     * Determines whether a status message for the property 'AbsData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAbsData() const;

    /**
     * Request the value of the property 'AbsData' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AbsData'</b>:
     *
     * <p>Periodically updated ABS data property. Contains a block of ABS
     * data records.</p>
     * <p>Attention: starting with version 5.0 the behavior of this property
     * changed. It delivers actual data only.</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAbsDataGet(AbsDataCallbackIF& cb);

    // Property 'Gyro3dData_Update'

    /**
     * Notify on the property 'Gyro3dData_Update'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'Gyro3dData_Update'</b>:
     *
     * List with new 3d-gyro samples.
     * <p>Attention: starting with version 5.0 the behavior of this property
     * changed. It delivers actual data only.</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGyro3dData_UpdateUpReg(Gyro3dData_UpdateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Gyro3dData_Update'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Gyro3dData_Update'</b>:
     *
     * List with new 3d-gyro samples.
     * <p>Attention: starting with version 5.0 the behavior of this property
     * changed. It delivers actual data only.</p>
     *
     * @param act The act which was previously returned by the
     * sendGyro3dData_UpdateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGyro3dData_UpdateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Gyro3dData_Update'.
     */
    void sendGyro3dData_UpdateRelUpRegAll ();

    /**
     * Returns the current value of the property 'Gyro3dData_Update' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasGyro3dData_Update() returns true.
     *
     * @return the previously received value of the property 'Gyro3dData_Update'.
     */
    const Gyro3dData_UpdateStatus& getGyro3dData_Update() const;

    /**
     * Determines whether a status message for the property 'Gyro3dData_Update' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGyro3dData_Update() const;

    /**
     * Request the value of the property 'Gyro3dData_Update' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Gyro3dData_Update'</b>:
     *
     * List with new 3d-gyro samples.
     * <p>Attention: starting with version 5.0 the behavior of this property
     * changed. It delivers actual data only.</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGyro3dData_UpdateGet(Gyro3dData_UpdateCallbackIF& cb);

    // Property 'Acc3dData_Update'

    /**
     * Notify on the property 'Acc3dData_Update'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'Acc3dData_Update'</b>:
     *
     * List with new 3d-acc sample.
     * <p>Attention: starting with version 5.0 the beahavior of this property
     * changed. It delivers actual data only.</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAcc3dData_UpdateUpReg(Acc3dData_UpdateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Acc3dData_Update'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Acc3dData_Update'</b>:
     *
     * List with new 3d-acc sample.
     * <p>Attention: starting with version 5.0 the beahavior of this property
     * changed. It delivers actual data only.</p>
     *
     * @param act The act which was previously returned by the
     * sendAcc3dData_UpdateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAcc3dData_UpdateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Acc3dData_Update'.
     */
    void sendAcc3dData_UpdateRelUpRegAll ();

    /**
     * Returns the current value of the property 'Acc3dData_Update' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAcc3dData_Update() returns true.
     *
     * @return the previously received value of the property 'Acc3dData_Update'.
     */
    const Acc3dData_UpdateStatus& getAcc3dData_Update() const;

    /**
     * Determines whether a status message for the property 'Acc3dData_Update' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAcc3dData_Update() const;

    /**
     * Request the value of the property 'Acc3dData_Update' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Acc3dData_Update'</b>:
     *
     * List with new 3d-acc sample.
     * <p>Attention: starting with version 5.0 the beahavior of this property
     * changed. It delivers actual data only.</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAcc3dData_UpdateGet(Acc3dData_UpdateCallbackIF& cb);

    // Property 'GyroTemperature'

    /**
     * Notify on the property 'GyroTemperature'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'GyroTemperature'</b>:
     *
     * Current temperature measured in or close to the gyro sensor. [K]
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGyroTemperatureUpReg(GyroTemperatureCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GyroTemperature'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GyroTemperature'</b>:
     *
     * Current temperature measured in or close to the gyro sensor. [K]
     *
     * @param act The act which was previously returned by the
     * sendGyroTemperatureUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGyroTemperatureRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GyroTemperature'.
     */
    void sendGyroTemperatureRelUpRegAll ();

    /**
     * Returns the current value of the property 'GyroTemperature' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasGyroTemperature() returns true.
     *
     * @return the previously received value of the property 'GyroTemperature'.
     */
    const GyroTemperatureStatus& getGyroTemperature() const;

    /**
     * Determines whether a status message for the property 'GyroTemperature' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGyroTemperature() const;

    /**
     * Request the value of the property 'GyroTemperature' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'GyroTemperature'</b>:
     *
     * Current temperature measured in or close to the gyro sensor. [K]
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGyroTemperatureGet(GyroTemperatureCallbackIF& cb);

    // Property 'GnssSatSystem'

    /**
     * Notify on the property 'GnssSatSystem'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'GnssSatSystem'</b>:
     *
     * There are different global navigation satellite systems (GNSS)
     * available. Depending on the characteristics of the applied GNSS
     * receiver and antenna, it's possible to activate multiple systems at a
     * time or choose another system e.g. GLONASS instead of GPS. The
     * activated constellation may be persisted depending on projects
     * configuration.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGnssSatSystemUpReg(GnssSatSystemCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GnssSatSystem'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GnssSatSystem'</b>:
     *
     * There are different global navigation satellite systems (GNSS)
     * available. Depending on the characteristics of the applied GNSS
     * receiver and antenna, it's possible to activate multiple systems at a
     * time or choose another system e.g. GLONASS instead of GPS. The
     * activated constellation may be persisted depending on projects
     * configuration.
     *
     * @param act The act which was previously returned by the
     * sendGnssSatSystemUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGnssSatSystemRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GnssSatSystem'.
     */
    void sendGnssSatSystemRelUpRegAll ();

    /**
     * Returns the current value of the property 'GnssSatSystem' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasGnssSatSystem() returns true.
     *
     * @return the previously received value of the property 'GnssSatSystem'.
     */
    const GnssSatSystemStatus& getGnssSatSystem() const;

    /**
     * Determines whether a status message for the property 'GnssSatSystem' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGnssSatSystem() const;

    /**
     * Request the value of the property 'GnssSatSystem' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'GnssSatSystem'</b>:
     *
     * There are different global navigation satellite systems (GNSS)
     * available. Depending on the characteristics of the applied GNSS
     * receiver and antenna, it's possible to activate multiple systems at a
     * time or choose another system e.g. GLONASS instead of GPS. The
     * activated constellation may be persisted depending on projects
     * configuration.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGnssSatSystemGet(GnssSatSystemCallbackIF& cb);

    /**
     * Set the value of the property 'GnssSatSystem'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'GnssSatSystem'</b>:
     *
     * There are different global navigation satellite systems (GNSS)
     * available. Depending on the characteristics of the applied GNSS
     * receiver and antenna, it's possible to activate multiple systems at a
     * time or choose another system e.g. GLONASS instead of GPS. The
     * activated constellation may be persisted depending on projects
     * configuration.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param TargetGnssSatSys If the meaning of "TargetGnssSatSys" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGnssSatSystemSet(GnssSatSystemCallbackIF& cb, const ::location_fi_types::T_b8_GnssSatSys& targetGnssSatSys);

    // Property 'GnssWnEpoch'

    /**
     * Notify on the property 'GnssWnEpoch'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'GnssWnEpoch'</b>:
     *
     * This property allows to adjust the GPS Epoch. GPS determines the
     * actual year from the weeknumber counter. This counter is a 10bit
     * counter which leads every 1024 weeks (~ 20 years) to a rollover .  In
     * general GPS has no means to determine which 20 year block (epoch) is
     * the actual one. In order to select the apropiate epoch, the "set" method
     * is called with a date (day, month and year) from the desired epoch. By
     * setting this date the epoch is [date..date+1024 weeks]
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGnssWnEpochUpReg(GnssWnEpochCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GnssWnEpoch'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GnssWnEpoch'</b>:
     *
     * This property allows to adjust the GPS Epoch. GPS determines the
     * actual year from the weeknumber counter. This counter is a 10bit
     * counter which leads every 1024 weeks (~ 20 years) to a rollover .  In
     * general GPS has no means to determine which 20 year block (epoch) is
     * the actual one. In order to select the apropiate epoch, the "set" method
     * is called with a date (day, month and year) from the desired epoch. By
     * setting this date the epoch is [date..date+1024 weeks]
     *
     * @param act The act which was previously returned by the
     * sendGnssWnEpochUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGnssWnEpochRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GnssWnEpoch'.
     */
    void sendGnssWnEpochRelUpRegAll ();

    /**
     * Returns the current value of the property 'GnssWnEpoch' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasGnssWnEpoch() returns true.
     *
     * @return the previously received value of the property 'GnssWnEpoch'.
     */
    const GnssWnEpochStatus& getGnssWnEpoch() const;

    /**
     * Determines whether a status message for the property 'GnssWnEpoch' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGnssWnEpoch() const;

    /**
     * Request the value of the property 'GnssWnEpoch' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'GnssWnEpoch'</b>:
     *
     * This property allows to adjust the GPS Epoch. GPS determines the
     * actual year from the weeknumber counter. This counter is a 10bit
     * counter which leads every 1024 weeks (~ 20 years) to a rollover .  In
     * general GPS has no means to determine which 20 year block (epoch) is
     * the actual one. In order to select the apropiate epoch, the "set" method
     * is called with a date (day, month and year) from the desired epoch. By
     * setting this date the epoch is [date..date+1024 weeks]
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGnssWnEpochGet(GnssWnEpochCallbackIF& cb);

    /**
     * Set the value of the property 'GnssWnEpoch'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'GnssWnEpoch'</b>:
     *
     * This property allows to adjust the GPS Epoch. GPS determines the
     * actual year from the weeknumber counter. This counter is a 10bit
     * counter which leads every 1024 weeks (~ 20 years) to a rollover .  In
     * general GPS has no means to determine which 20 year block (epoch) is
     * the actual one. In order to select the apropiate epoch, the "set" method
     * is called with a date (day, month and year) from the desired epoch. By
     * setting this date the epoch is [date..date+1024 weeks]
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param TargetWnDate Set the GPS epoch according to TargetWnDate. Only day, month and
     * year of the T_TimeDate structure have to be filled. The hour,
     * minute, second and millisecond elements of that structure are
     * ignored
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGnssWnEpochSet(GnssWnEpochCallbackIF& cb, const ::location_fi_types::T_TimeDate& targetWnDate);

    // Property 'GnssConfigData'

    /**
     * Notify on the property 'GnssConfigData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'GnssConfigData'</b>:
     *
     * Configuration data of the GNSS receiver
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGnssConfigDataUpReg(GnssConfigDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GnssConfigData'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GnssConfigData'</b>:
     *
     * Configuration data of the GNSS receiver
     *
     * @param act The act which was previously returned by the
     * sendGnssConfigDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGnssConfigDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GnssConfigData'.
     */
    void sendGnssConfigDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'GnssConfigData' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasGnssConfigData() returns true.
     *
     * @return the previously received value of the property 'GnssConfigData'.
     */
    const GnssConfigDataStatus& getGnssConfigData() const;

    /**
     * Determines whether a status message for the property 'GnssConfigData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGnssConfigData() const;

    /**
     * Request the value of the property 'GnssConfigData' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'GnssConfigData'</b>:
     *
     * Configuration data of the GNSS receiver
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGnssConfigDataGet(GnssConfigDataCallbackIF& cb);

    // Property 'GnssData'

    /**
     * Notify on the property 'GnssData'. This method sends a UpReg message to
     * the CCA server.
     *
     * <b>Documentation of 'GnssData'</b>:
     *
     * periodical GNSS-data-message
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGnssDataUpReg(GnssDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GnssData'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GnssData'</b>:
     *
     * periodical GNSS-data-message
     *
     * @param act The act which was previously returned by the
     * sendGnssDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGnssDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GnssData'.
     */
    void sendGnssDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'GnssData' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasGnssData()
     * returns true.
     *
     * @return the previously received value of the property 'GnssData'.
     */
    const GnssDataStatus& getGnssData() const;

    /**
     * Determines whether a status message for the property 'GnssData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGnssData() const;

    /**
     * Request the value of the property 'GnssData' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'GnssData'</b>:
     *
     * periodical GNSS-data-message
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGnssDataGet(GnssDataCallbackIF& cb);

    // Property 'AllSensorData'

    /**
     * Notify on the property 'AllSensorData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AllSensorData'</b>:
     *
     * periodical update of all sensor data that are relevant for the
     * position calculation (Ortung). This includes GNSS, odometer, 3D-Gyro
     * and 3D-Acc data. There is no more need to register for the different
     * sensor data separatly. In normal operation every second one of these
     * data blocks get transmitted. In contrast to the dedicated properties
     * for each sensor the "AllSensorData" delivers on UpReg next to the
     * actual data set all available datasets from the buffers.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAllSensorDataUpReg(AllSensorDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AllSensorData'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AllSensorData'</b>:
     *
     * periodical update of all sensor data that are relevant for the
     * position calculation (Ortung). This includes GNSS, odometer, 3D-Gyro
     * and 3D-Acc data. There is no more need to register for the different
     * sensor data separatly. In normal operation every second one of these
     * data blocks get transmitted. In contrast to the dedicated properties
     * for each sensor the "AllSensorData" delivers on UpReg next to the
     * actual data set all available datasets from the buffers.
     *
     * @param act The act which was previously returned by the
     * sendAllSensorDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAllSensorDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AllSensorData'.
     */
    void sendAllSensorDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'AllSensorData' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAllSensorData() returns true.
     *
     * @return the previously received value of the property 'AllSensorData'.
     */
    const AllSensorDataStatus& getAllSensorData() const;

    /**
     * Determines whether a status message for the property 'AllSensorData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAllSensorData() const;

    // Property 'VdsVersionInfo'

    /**
     * Notify on the property 'VdsVersionInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'VdsVersionInfo'</b>:
     *
     * Gives some information about the Vd_Sensor verion used and about the
     * target it is running on.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVdsVersionInfoUpReg(VdsVersionInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'VdsVersionInfo'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'VdsVersionInfo'</b>:
     *
     * Gives some information about the Vd_Sensor verion used and about the
     * target it is running on.
     *
     * @param act The act which was previously returned by the
     * sendVdsVersionInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVdsVersionInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'VdsVersionInfo'.
     */
    void sendVdsVersionInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'VdsVersionInfo' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasVdsVersionInfo() returns true.
     *
     * @return the previously received value of the property 'VdsVersionInfo'.
     */
    const VdsVersionInfoStatus& getVdsVersionInfo() const;

    /**
     * Determines whether a status message for the property 'VdsVersionInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVdsVersionInfo() const;

    /**
     * Request the value of the property 'VdsVersionInfo' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'VdsVersionInfo'</b>:
     *
     * Gives some information about the Vd_Sensor verion used and about the
     * target it is running on.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVdsVersionInfoGet(VdsVersionInfoCallbackIF& cb);

    // Property 'AccTemperature'

    /**
     * Notify on the property 'AccTemperature'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AccTemperature'</b>:
     *
     * Current temperature measured in or close to the acceleration sensor. [K]
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAccTemperatureUpReg(AccTemperatureCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AccTemperature'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AccTemperature'</b>:
     *
     * Current temperature measured in or close to the acceleration sensor. [K]
     *
     * @param act The act which was previously returned by the
     * sendAccTemperatureUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAccTemperatureRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AccTemperature'.
     */
    void sendAccTemperatureRelUpRegAll ();

    /**
     * Returns the current value of the property 'AccTemperature' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAccTemperature() returns true.
     *
     * @return the previously received value of the property 'AccTemperature'.
     */
    const AccTemperatureStatus& getAccTemperature() const;

    /**
     * Determines whether a status message for the property 'AccTemperature' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAccTemperature() const;

    /**
     * Request the value of the property 'AccTemperature' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AccTemperature'</b>:
     *
     * Current temperature measured in or close to the acceleration sensor. [K]
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAccTemperatureGet(AccTemperatureCallbackIF& cb);

    // Property 'DiagGnssSatSystem'

    /**
     * Notify on the property 'DiagGnssSatSystem'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiagGnssSatSystem'</b>:
     *
     * This property is similar to the "GnssSatSystem" property. The main
     * difference is that the changes are not persisted and lost after reboot.
     * This is needed e.g. by diagnosis to test the different satellite
     * systems without spoiling the default/factory configuration.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiagGnssSatSystemUpReg(DiagGnssSatSystemCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiagGnssSatSystem'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiagGnssSatSystem'</b>:
     *
     * This property is similar to the "GnssSatSystem" property. The main
     * difference is that the changes are not persisted and lost after reboot.
     * This is needed e.g. by diagnosis to test the different satellite
     * systems without spoiling the default/factory configuration.
     *
     * @param act The act which was previously returned by the
     * sendDiagGnssSatSystemUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiagGnssSatSystemRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiagGnssSatSystem'.
     */
    void sendDiagGnssSatSystemRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiagGnssSatSystem' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiagGnssSatSystem() returns true.
     *
     * @return the previously received value of the property 'DiagGnssSatSystem'.
     */
    const DiagGnssSatSystemStatus& getDiagGnssSatSystem() const;

    /**
     * Determines whether a status message for the property 'DiagGnssSatSystem' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiagGnssSatSystem() const;

    /**
     * Request the value of the property 'DiagGnssSatSystem' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiagGnssSatSystem'</b>:
     *
     * This property is similar to the "GnssSatSystem" property. The main
     * difference is that the changes are not persisted and lost after reboot.
     * This is needed e.g. by diagnosis to test the different satellite
     * systems without spoiling the default/factory configuration.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiagGnssSatSystemGet(DiagGnssSatSystemCallbackIF& cb);

    /**
     * Set the value of the property 'DiagGnssSatSystem'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'DiagGnssSatSystem'</b>:
     *
     * This property is similar to the "GnssSatSystem" property. The main
     * difference is that the changes are not persisted and lost after reboot.
     * This is needed e.g. by diagnosis to test the different satellite
     * systems without spoiling the default/factory configuration.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param TargetGnssSatSys If the meaning of "TargetGnssSatSys" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiagGnssSatSystemSet(DiagGnssSatSystemCallbackIF& cb, const ::location_fi_types::T_b8_GnssSatSys& targetGnssSatSys);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Sensor_location_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'OdometerData_Update'

    ::asf::core::nullable< OdometerData_UpdateStatus > _odometerData_Update;

    // Property 'AbsData'

    ::asf::core::nullable< AbsDataStatus > _absData;

    // Property 'Gyro3dData_Update'

    ::asf::core::nullable< Gyro3dData_UpdateStatus > _gyro3dData_Update;

    // Property 'Acc3dData_Update'

    ::asf::core::nullable< Acc3dData_UpdateStatus > _acc3dData_Update;

    // Property 'GyroTemperature'

    ::asf::core::nullable< GyroTemperatureStatus > _gyroTemperature;

    // Property 'GnssSatSystem'

    ::asf::core::nullable< GnssSatSystemStatus > _gnssSatSystem;

    // Property 'GnssWnEpoch'

    ::asf::core::nullable< GnssWnEpochStatus > _gnssWnEpoch;

    // Property 'GnssConfigData'

    ::asf::core::nullable< GnssConfigDataStatus > _gnssConfigData;

    // Property 'GnssData'

    ::asf::core::nullable< GnssDataStatus > _gnssData;

    // Property 'AllSensorData'

    ::asf::core::nullable< AllSensorDataStatus > _allSensorData;

    // Property 'VdsVersionInfo'

    ::asf::core::nullable< VdsVersionInfoStatus > _vdsVersionInfo;

    // Property 'AccTemperature'

    ::asf::core::nullable< AccTemperatureStatus > _accTemperature;

    // Property 'DiagGnssSatSystem'

    ::asf::core::nullable< DiagGnssSatSystemStatus > _diagGnssSatSystem;

    DECLARE_CLASS_LOGGER();

    friend class Sensor_location_fiProxyCallback;
};

} // namespace sensor_location_fi

#endif // SENSOR_LOCATION_FIPROXY_H
