/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "location_fi_typesConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * Types location_fi_types
 */

using namespace ::asf::stream::json;

namespace location_fi_types {

bool T_e8_OdometerStatus_Parse (const char *str, size_t length, T_e8_OdometerStatus &value)
{
    static stringEntry entries[] = {
        {17,"ODOMSTATE_UNKNOWN", 255U},
        {22,"ODOMSTATE_DISCONNECTED", 254U},
        {25,"ODOMSTATE_CONNECTED_ERROR", 253U},
        {26,"ODOMSTATE_CONNECTED_NOINFO", 251U},
        {26,"ODOMSTATE_CONNECTED_NORMAL", 0U},
        {30,"ODOMSTATE_CONNECTED_NOMOVEMENT", 252U},
        {32,"ODOMSTATE_CONNECTED_DATA_INVALID", 249U},
        {33,"ODOMSTATE_CONNECTED_INTERNALERROR", 250U},
        {34,"ODOMSTATE_CONNECTED_NO_CALIBRATION", 248U},
    };

    return lookupInStringEntryTable (str, length, entries, 9, (unsigned int&) value);
}

const char* T_e8_OdometerStatus_Name (T_e8_OdometerStatus value)
{
    static const char* enumerationLiterals[] = {
        "ODOMSTATE_CONNECTED_NORMAL",
        "ODOMSTATE_CONNECTED_NO_CALIBRATION",
        "ODOMSTATE_CONNECTED_DATA_INVALID",
        "ODOMSTATE_CONNECTED_INTERNALERROR",
        "ODOMSTATE_CONNECTED_NOINFO",
        "ODOMSTATE_CONNECTED_NOMOVEMENT",
        "ODOMSTATE_CONNECTED_ERROR",
        "ODOMSTATE_DISCONNECTED",
        "ODOMSTATE_UNKNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        248U,
        249U,
        250U,
        251U,
        252U,
        253U,
        254U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 9, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_OdometerStatus_IsValid (T_e8_OdometerStatus value)
{
    switch (value) {
    case T_e8_OdometerStatus__ODOMSTATE_CONNECTED_NORMAL:
    case T_e8_OdometerStatus__ODOMSTATE_CONNECTED_NO_CALIBRATION:
    case T_e8_OdometerStatus__ODOMSTATE_CONNECTED_DATA_INVALID:
    case T_e8_OdometerStatus__ODOMSTATE_CONNECTED_INTERNALERROR:
    case T_e8_OdometerStatus__ODOMSTATE_CONNECTED_NOINFO:
    case T_e8_OdometerStatus__ODOMSTATE_CONNECTED_NOMOVEMENT:
    case T_e8_OdometerStatus__ODOMSTATE_CONNECTED_ERROR:
    case T_e8_OdometerStatus__ODOMSTATE_DISCONNECTED:
    case T_e8_OdometerStatus__ODOMSTATE_UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_OdometerDirection_Parse (const char *str, size_t length, T_e8_OdometerDirection &value)
{
    static stringEntry entries[] = {
        {15,"ODOMDIR_FORWARD", 1U},
        {15,"ODOMDIR_REVERSE", 2U},
        {15,"ODOMDIR_UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_OdometerDirection_Name (T_e8_OdometerDirection value)
{
    static const char* enumerationLiterals[] = {
        "ODOMDIR_UNKNOWN",
        "ODOMDIR_FORWARD",
        "ODOMDIR_REVERSE",
    };

    if (T_e8_OdometerDirection_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_OdometerDirection_IsValid (T_e8_OdometerDirection value)
{
    switch (value) {
    case T_e8_OdometerDirection__ODOMDIR_UNKNOWN:
    case T_e8_OdometerDirection__ODOMDIR_FORWARD:
    case T_e8_OdometerDirection__ODOMDIR_REVERSE:
        return true;
    default:
        return false;
    }
}

bool T_e8_AbsStatus_Parse (const char *str, size_t length, T_e8_AbsStatus &value)
{
    static stringEntry entries[] = {
        {16,"ABS_STATUS_ERROR", 253U},
        {17,"ABS_STATUS_NORMAL", 0U},
        {18,"ABS_STATUS_NO_INFO", 251U},
        {18,"ABS_STATUS_UNKNOWN", 255U},
        {22,"ABS_STATUS_NO_MOVEMENT", 252U},
        {23,"ABS_STATUS_DATA_INVALID", 249U},
        {23,"ABS_STATUS_DISCONNECTED", 254U},
        {25,"ABS_STATUS_INTERNAL_ERROR", 250U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_AbsStatus_Name (T_e8_AbsStatus value)
{
    static const char* enumerationLiterals[] = {
        "ABS_STATUS_NORMAL",
        "ABS_STATUS_DATA_INVALID",
        "ABS_STATUS_INTERNAL_ERROR",
        "ABS_STATUS_NO_INFO",
        "ABS_STATUS_NO_MOVEMENT",
        "ABS_STATUS_ERROR",
        "ABS_STATUS_DISCONNECTED",
        "ABS_STATUS_UNKNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        249U,
        250U,
        251U,
        252U,
        253U,
        254U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 8, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_AbsStatus_IsValid (T_e8_AbsStatus value)
{
    switch (value) {
    case T_e8_AbsStatus__ABS_STATUS_NORMAL:
    case T_e8_AbsStatus__ABS_STATUS_DATA_INVALID:
    case T_e8_AbsStatus__ABS_STATUS_INTERNAL_ERROR:
    case T_e8_AbsStatus__ABS_STATUS_NO_INFO:
    case T_e8_AbsStatus__ABS_STATUS_NO_MOVEMENT:
    case T_e8_AbsStatus__ABS_STATUS_ERROR:
    case T_e8_AbsStatus__ABS_STATUS_DISCONNECTED:
    case T_e8_AbsStatus__ABS_STATUS_UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_AbsDirection_Parse (const char *str, size_t length, T_e8_AbsDirection &value)
{
    static stringEntry entries[] = {
        {21,"ABS_DIRECTION_FORWARD", 1U},
        {21,"ABS_DIRECTION_REVERSE", 2U},
        {21,"ABS_DIRECTION_UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_AbsDirection_Name (T_e8_AbsDirection value)
{
    static const char* enumerationLiterals[] = {
        "ABS_DIRECTION_UNKNOWN",
        "ABS_DIRECTION_FORWARD",
        "ABS_DIRECTION_REVERSE",
    };

    if (T_e8_AbsDirection_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AbsDirection_IsValid (T_e8_AbsDirection value)
{
    switch (value) {
    case T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN:
    case T_e8_AbsDirection__ABS_DIRECTION_FORWARD:
    case T_e8_AbsDirection__ABS_DIRECTION_REVERSE:
        return true;
    default:
        return false;
    }
}

bool T_e16_GyroStatus_Parse (const char *str, size_t length, T_e16_GyroStatus &value)
{
    static stringEntry entries[] = {
        {18,"GYROSTATE_OVERHEAT", 65532U},
        {22,"GYROSTATE_OUT_OF_ORDER", 65531U},
        {26,"GYROSTATE_CONNECTED_NORMAL", 0U},
        {28,"GYROSTATE_SENSOR_NOT_PRESENT", 65533U},
        {32,"GYROSTATE_CONNECTED_DATA_INVALID", 65534U},
        {33,"GYROSTATE_CONNECTED_INTERNALERROR", 65535U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e16_GyroStatus_Name (T_e16_GyroStatus value)
{
    static const char* enumerationLiterals[] = {
        "GYROSTATE_CONNECTED_NORMAL",
        "GYROSTATE_OUT_OF_ORDER",
        "GYROSTATE_OVERHEAT",
        "GYROSTATE_SENSOR_NOT_PRESENT",
        "GYROSTATE_CONNECTED_DATA_INVALID",
        "GYROSTATE_CONNECTED_INTERNALERROR",
    };

    static unsigned int enumerationValues[] = {
        0U,
        65531U,
        65532U,
        65533U,
        65534U,
        65535U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e16_GyroStatus_IsValid (T_e16_GyroStatus value)
{
    switch (value) {
    case T_e16_GyroStatus__GYROSTATE_CONNECTED_NORMAL:
    case T_e16_GyroStatus__GYROSTATE_OUT_OF_ORDER:
    case T_e16_GyroStatus__GYROSTATE_OVERHEAT:
    case T_e16_GyroStatus__GYROSTATE_SENSOR_NOT_PRESENT:
    case T_e16_GyroStatus__GYROSTATE_CONNECTED_DATA_INVALID:
    case T_e16_GyroStatus__GYROSTATE_CONNECTED_INTERNALERROR:
        return true;
    default:
        return false;
    }
}

bool T_e16_AccStatus_Parse (const char *str, size_t length, T_e16_AccStatus &value)
{
    static stringEntry entries[] = {
        {17,"ACCSTATE_OVERHEAT", 65532U},
        {21,"ACCSTATE_OUT_OF_ORDER", 65531U},
        {25,"ACCSTATE_CONNECTED_NORMAL", 0U},
        {27,"ACCSTATE_SENSOR_NOT_PRESENT", 65533U},
        {31,"ACCSTATE_CONNECTED_DATA_INVALID", 65534U},
        {32,"ACCSTATE_CONNECTED_INTERNALERROR", 65535U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e16_AccStatus_Name (T_e16_AccStatus value)
{
    static const char* enumerationLiterals[] = {
        "ACCSTATE_CONNECTED_NORMAL",
        "ACCSTATE_OUT_OF_ORDER",
        "ACCSTATE_OVERHEAT",
        "ACCSTATE_SENSOR_NOT_PRESENT",
        "ACCSTATE_CONNECTED_DATA_INVALID",
        "ACCSTATE_CONNECTED_INTERNALERROR",
    };

    static unsigned int enumerationValues[] = {
        0U,
        65531U,
        65532U,
        65533U,
        65534U,
        65535U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e16_AccStatus_IsValid (T_e16_AccStatus value)
{
    switch (value) {
    case T_e16_AccStatus__ACCSTATE_CONNECTED_NORMAL:
    case T_e16_AccStatus__ACCSTATE_OUT_OF_ORDER:
    case T_e16_AccStatus__ACCSTATE_OVERHEAT:
    case T_e16_AccStatus__ACCSTATE_SENSOR_NOT_PRESENT:
    case T_e16_AccStatus__ACCSTATE_CONNECTED_DATA_INVALID:
    case T_e16_AccStatus__ACCSTATE_CONNECTED_INTERNALERROR:
        return true;
    default:
        return false;
    }
}

bool T_e8_GnssHw_Parse (const char *str, size_t length, T_e8_GnssHw &value)
{
    static stringEntry entries[] = {
        {12,"GNSS_HW_GPS5", 1U},
        {14,"GNSS_HW_GPS1_4", 0U},
        {14,"GNSS_HW_GPS6_7", 2U},
        {15,"GNSS_HW_STA8088", 16U},
        {15,"GNSS_HW_STA8089", 17U},
        {15,"GNSS_HW_UNKNOWN", 255U},
        {16,"GNSS_HW_NMEA_GPS", 14U},
        {17,"GNSS_HW_GPS_ELENA", 10U},
        {18,"GNSS_HW_IPHONE_GPS", 15U},
        {19,"GNSS_HW_BPGPS_ARION", 11U},
        {20,"GNSS_HW_BPGPS_DRAGON", 13U},
        {24,"GNSS_HW_BPGPS_DRAGON_ES1", 12U},
    };

    return lookupInStringEntryTable (str, length, entries, 12, (unsigned int&) value);
}

const char* T_e8_GnssHw_Name (T_e8_GnssHw value)
{
    static const char* enumerationLiterals[] = {
        "GNSS_HW_GPS1_4",
        "GNSS_HW_GPS5",
        "GNSS_HW_GPS6_7",
        "GNSS_HW_GPS_ELENA",
        "GNSS_HW_BPGPS_ARION",
        "GNSS_HW_BPGPS_DRAGON_ES1",
        "GNSS_HW_BPGPS_DRAGON",
        "GNSS_HW_NMEA_GPS",
        "GNSS_HW_IPHONE_GPS",
        "GNSS_HW_STA8088",
        "GNSS_HW_STA8089",
        "GNSS_HW_UNKNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 12, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_GnssHw_IsValid (T_e8_GnssHw value)
{
    switch (value) {
    case T_e8_GnssHw__GNSS_HW_GPS1_4:
    case T_e8_GnssHw__GNSS_HW_GPS5:
    case T_e8_GnssHw__GNSS_HW_GPS6_7:
    case T_e8_GnssHw__GNSS_HW_GPS_ELENA:
    case T_e8_GnssHw__GNSS_HW_BPGPS_ARION:
    case T_e8_GnssHw__GNSS_HW_BPGPS_DRAGON_ES1:
    case T_e8_GnssHw__GNSS_HW_BPGPS_DRAGON:
    case T_e8_GnssHw__GNSS_HW_NMEA_GPS:
    case T_e8_GnssHw__GNSS_HW_IPHONE_GPS:
    case T_e8_GnssHw__GNSS_HW_STA8088:
    case T_e8_GnssHw__GNSS_HW_STA8089:
    case T_e8_GnssHw__GNSS_HW_UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_GnssQuality_Parse (const char *str, size_t length, T_e8_GnssQuality &value)
{
    static stringEntry entries[] = {
        {17,"GNSSQUALITY_NOFIX", 0U},
        {19,"GNSSQUALITY_UNKNOWN", 255U},
        {22,"GNSSQUALITY_AUTONOMOUS", 1U},
        {24,"GNSSQUALITY_DIFFERENTIAL", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_GnssQuality_Name (T_e8_GnssQuality value)
{
    static const char* enumerationLiterals[] = {
        "GNSSQUALITY_NOFIX",
        "GNSSQUALITY_AUTONOMOUS",
        "GNSSQUALITY_DIFFERENTIAL",
        "GNSSQUALITY_UNKNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_GnssQuality_IsValid (T_e8_GnssQuality value)
{
    switch (value) {
    case T_e8_GnssQuality__GNSSQUALITY_NOFIX:
    case T_e8_GnssQuality__GNSSQUALITY_AUTONOMOUS:
    case T_e8_GnssQuality__GNSSQUALITY_DIFFERENTIAL:
    case T_e8_GnssQuality__GNSSQUALITY_UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_GnssMode_Parse (const char *str, size_t length, T_e8_GnssMode &value)
{
    static stringEntry entries[] = {
        {14,"GNSSMODE_2DFIX", 2U},
        {14,"GNSSMODE_3DFIX", 3U},
        {14,"GNSSMODE_NOFIX", 1U},
        {16,"GNSSMODE_UNKNOWN", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_GnssMode_Name (T_e8_GnssMode value)
{
    static const char* enumerationLiterals[] = {
        "GNSSMODE_NOFIX",
        "GNSSMODE_2DFIX",
        "GNSSMODE_3DFIX",
        "GNSSMODE_UNKNOWN",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        3U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_GnssMode_IsValid (T_e8_GnssMode value)
{
    switch (value) {
    case T_e8_GnssMode__GNSSMODE_NOFIX:
    case T_e8_GnssMode__GNSSMODE_2DFIX:
    case T_e8_GnssMode__GNSSMODE_3DFIX:
    case T_e8_GnssMode__GNSSMODE_UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_timeMode_Parse (const char *str, size_t length, T_e8_timeMode &value)
{
    static stringEntry entries[] = {
        {13,"TIMEMODE_AUTO", 1U},
        {15,"TIMEMODE_MANUAL", 2U},
        {16,"TIMEMODE_DEFAULT", 0U},
        {16,"TIMEMODE_INVALID", 254U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_timeMode_Name (T_e8_timeMode value)
{
    static const char* enumerationLiterals[] = {
        "TIMEMODE_DEFAULT",
        "TIMEMODE_AUTO",
        "TIMEMODE_MANUAL",
        "TIMEMODE_INVALID",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        254U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_timeMode_IsValid (T_e8_timeMode value)
{
    switch (value) {
    case T_e8_timeMode__TIMEMODE_DEFAULT:
    case T_e8_timeMode__TIMEMODE_AUTO:
    case T_e8_timeMode__TIMEMODE_MANUAL:
    case T_e8_timeMode__TIMEMODE_INVALID:
        return true;
    default:
        return false;
    }
}

bool T_e8_DefSetGroups_Parse (const char *str, size_t length, T_e8_DefSetGroups &value)
{
    static stringEntry entries[] = {
        {24,"DEFSET_GROUP_MAINTENANCE", 13U},
    };

    return lookupInStringEntryTable (str, length, entries, 1, (unsigned int&) value);
}

const char* T_e8_DefSetGroups_Name (T_e8_DefSetGroups value)
{
    static const char* enumerationLiterals[] = {
        "DEFSET_GROUP_MAINTENANCE",
    };

    if (T_e8_DefSetGroups_IsValid(value))
        return enumerationLiterals[value - 13U];
    else
        return NULL;
}

bool T_e8_DefSetGroups_IsValid (T_e8_DefSetGroups value)
{
    switch (value) {
    case T_e8_DefSetGroups__DEFSET_GROUP_MAINTENANCE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DefSetMode_Parse (const char *str, size_t length, T_e8_DefSetMode &value)
{
    static stringEntry entries[] = {
        {17,"DEFSET_SRC_CODING", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 1, (unsigned int&) value);
}

const char* T_e8_DefSetMode_Name (T_e8_DefSetMode value)
{
    static const char* enumerationLiterals[] = {
        "DEFSET_SRC_CODING",
    };

    if (T_e8_DefSetMode_IsValid(value))
        return enumerationLiterals[value - 5U];
    else
        return NULL;
}

bool T_e8_DefSetMode_IsValid (T_e8_DefSetMode value)
{
    switch (value) {
    case T_e8_DefSetMode__DEFSET_SRC_CODING:
        return true;
    default:
        return false;
    }
}

} // namespace location_fi_types
