#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef LOCATION_FI_TYPES_H
#define LOCATION_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "location_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types location_fi_types
 */

namespace location_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_VdsVersionInfo;

class T_OdometerData;

class T_AbsData;

class T_SensorHwInfo;

class T_3dMountAngles;

class T_3dGyroHwInfo;

class T_3dAccHwInfo;

class T_3dGyroData;

class T_3dAccData;

class T_b8_GnssSatSys;

class T_b8_GnssSatStatus;

class T_GnssConfigData;

class T_GnssStatus;

class T_CovarianceMatrixUpperTriangle;

class T_TimeDate;

class T_GnssPvtData;

class T_GnssChanData;

class T_GnssData;

class T_AllSensorData;


/**
 * Infomation about the SW and the HW used.
 */
class T_VdsVersionInfo {
public:

    /**
     * Default constructor
     */
    inline  T_VdsVersionInfo ();

    /**
     * Copy constructor
     */
    inline  T_VdsVersionInfo (const T_VdsVersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_VdsVersionInfo (const ::std::string& vdsVersion_, const ::std::string& boardVersion_);

    /**
     * Destructor
     */
    inline  ~T_VdsVersionInfo();

    /**
     * Assignment operator
     */
    inline T_VdsVersionInfo& operator = (const T_VdsVersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_VdsVersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_VdsVersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_VdsVersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_VdsVersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "vdsVersion"

    static const int kVdsVersion = 0;

    /**
     * Clears the field "vdsVersion".
     *
     * The field will be set to its default value. The hasVdsVersion()
     * method will return false.
     */
    inline void clearVdsVersion();

    /**
     * Checks whether the field "vdsVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVdsVersion()). Otherwise it will return false.
     */
    inline bool hasVdsVersion () const;

    /**
     * Returns the value of the member "vdsVersion".
     *
     * Describes the base label of the ai_sensor from which this version of
     * the VD_Sensor is compiled from e.g. "14.0V01".
     *
     * @return The value of the field "vdsVersion"
     */
    inline const ::std::string& getVdsVersion () const;

    /**
     * Retrieves the value of the field "vdsVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "vdsVersion".
     */
    inline ::std::string& getVdsVersionMutable ();

    /**
     * Sets the value of the member "vdsVersion".
     *
     * Describes the base label of the ai_sensor from which this version of
     * the VD_Sensor is compiled from e.g. "14.0V01".
     *
     * @param vdsVersion The value which will be set
     */
    inline void setVdsVersion (const ::std::string& vdsVersion_);

    /**
     * Sets the value of the member "vdsVersion".
     *
     * Describes the base label of the ai_sensor from which this version of
     * the VD_Sensor is compiled from e.g. "14.0V01".
     *
     * @param vdsVersion The value which will be set
     */
    inline void setVdsVersion (const char* vdsVersion_);

    /**
     * Sets the value of the member "vdsVersion".
     *
     * Describes the base label of the ai_sensor from which this version of
     * the VD_Sensor is compiled from e.g. "14.0V01".
     *
     * @param vdsVersion The value which will be set
     */
    inline void setVdsVersion (const char* value, size_t size);

    // API of field "boardVersion"

    static const int kBoardVersion = 1;

    /**
     * Clears the field "boardVersion".
     *
     * The field will be set to its default value. The hasBoardVersion()
     * method will return false.
     */
    inline void clearBoardVersion();

    /**
     * Checks whether the field "boardVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBoardVersion()). Otherwise it will return false.
     */
    inline bool hasBoardVersion () const;

    /**
     * Returns the value of the member "boardVersion".
     *
     * Gives some information about the HW the VD_Sensor is running on. At
     * least the BoardId/BootId is provided.
     *
     * @return The value of the field "boardVersion"
     */
    inline const ::std::string& getBoardVersion () const;

    /**
     * Retrieves the value of the field "boardVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "boardVersion".
     */
    inline ::std::string& getBoardVersionMutable ();

    /**
     * Sets the value of the member "boardVersion".
     *
     * Gives some information about the HW the VD_Sensor is running on. At
     * least the BoardId/BootId is provided.
     *
     * @param boardVersion The value which will be set
     */
    inline void setBoardVersion (const ::std::string& boardVersion_);

    /**
     * Sets the value of the member "boardVersion".
     *
     * Gives some information about the HW the VD_Sensor is running on. At
     * least the BoardId/BootId is provided.
     *
     * @param boardVersion The value which will be set
     */
    inline void setBoardVersion (const char* boardVersion_);

    /**
     * Sets the value of the member "boardVersion".
     *
     * Gives some information about the HW the VD_Sensor is running on. At
     * least the BoardId/BootId is provided.
     *
     * @param boardVersion The value which will be set
     */
    inline void setBoardVersion (const char* value, size_t size);

    static const T_VdsVersionInfo &getDefaultInstance();

private:

    inline void set_has_vdsVersion ();

    inline void clear_has_vdsVersion ();

    inline void set_has_boardVersion ();

    inline void clear_has_boardVersion ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _vdsVersion;

    ::std::string _boardVersion;

};

/**
 * Structure type holding the odometer counter
 * value and additional information.
 */
class T_OdometerData {
public:

    /**
     * Default constructor
     */
    inline  T_OdometerData ();

    /**
     * Copy constructor
     */
    inline  T_OdometerData (const T_OdometerData &rhs);

    /**
     * All fields constructor
     */
    inline  T_OdometerData (uint32 Timestamp_, uint16 OdometerCount_, T_e8_OdometerStatus OdometerStatus_, T_e8_OdometerDirection OdometerCount_Direction_);

    /**
     * Destructor
     */
    inline  ~T_OdometerData();

    /**
     * Assignment operator
     */
    inline T_OdometerData& operator = (const T_OdometerData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_OdometerData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_OdometerData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_OdometerData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_OdometerData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Timestamp"

    static const int kTimestamp = 0;

    /**
     * Clears the field "Timestamp".
     *
     * The field will be set to its default value. The hasTimestamp()
     * method will return false.
     */
    inline void clearTimestamp();

    /**
     * Checks whether the field "Timestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimestamp()). Otherwise it will return false.
     */
    inline bool hasTimestamp () const;

    /**
     * Returns the value of the member "Timestamp".
     *
     * sensor-tics (wrap around counter with
     * separate count frequency defined by /dev/auxclock)
     *
     * @return The value of the field "Timestamp"
     */
    inline uint32 getTimestamp () const;

    /**
     * Sets the value of the member "Timestamp".
     *
     * sensor-tics (wrap around counter with
     * separate count frequency defined by /dev/auxclock)
     *
     * @param Timestamp The value which will be set
     */
    inline void setTimestamp (uint32 Timestamp_);

    // API of field "OdometerCount"

    static const int kOdometerCount = 1;

    /**
     * Clears the field "OdometerCount".
     *
     * The field will be set to its default value. The hasOdometerCount()
     * method will return false.
     */
    inline void clearOdometerCount();

    /**
     * Checks whether the field "OdometerCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOdometerCount()). Otherwise it will return false.
     */
    inline bool hasOdometerCount () const;

    /**
     * Returns the value of the member "OdometerCount".
     *
     * odometer puls counter value (wrap around counter). The
     * counter counts up while driving forwards and down while driving
     * backwards.
     *
     * @return The value of the field "OdometerCount"
     */
    inline uint16 getOdometerCount () const;

    /**
     * Sets the value of the member "OdometerCount".
     *
     * odometer puls counter value (wrap around counter). The
     * counter counts up while driving forwards and down while driving
     * backwards.
     *
     * @param OdometerCount The value which will be set
     */
    inline void setOdometerCount (uint16 OdometerCount_);

    // API of field "OdometerStatus"

    static const int kOdometerStatus = 2;

    /**
     * Clears the field "OdometerStatus".
     *
     * The field will be set to its default value. The hasOdometerStatus()
     * method will return false.
     */
    inline void clearOdometerStatus();

    /**
     * Checks whether the field "OdometerStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOdometerStatus()). Otherwise it will return false.
     */
    inline bool hasOdometerStatus () const;

    /**
     * Returns the value of the member "OdometerStatus".
     *
     *
     *
     * @return The value of the field "OdometerStatus"
     */
    inline T_e8_OdometerStatus getOdometerStatus () const;

    /**
     * Sets the value of the member "OdometerStatus".
     *
     *
     *
     * @param OdometerStatus The value which will be set
     */
    inline void setOdometerStatus (T_e8_OdometerStatus OdometerStatus_);

    // API of field "OdometerCount_Direction"

    static const int kOdometerCount_Direction = 3;

    /**
     * Clears the field "OdometerCount_Direction".
     *
     * The field will be set to its default value. The hasOdometerCount_Direction()
     * method will return false.
     */
    inline void clearOdometerCount_Direction();

    /**
     * Checks whether the field "OdometerCount_Direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOdometerCount_Direction()). Otherwise it will return false.
     */
    inline bool hasOdometerCount_Direction () const;

    /**
     * Returns the value of the member "OdometerCount_Direction".
     *
     *
     *
     * @return The value of the field "OdometerCount_Direction"
     */
    inline T_e8_OdometerDirection getOdometerCount_Direction () const;

    /**
     * Sets the value of the member "OdometerCount_Direction".
     *
     *
     *
     * @param OdometerCount_Direction The value which will be set
     */
    inline void setOdometerCount_Direction (T_e8_OdometerDirection OdometerCount_Direction_);

    static const T_OdometerData &getDefaultInstance();

private:

    inline void set_has_Timestamp ();

    inline void clear_has_Timestamp ();

    inline void set_has_OdometerCount ();

    inline void clear_has_OdometerCount ();

    inline void set_has_OdometerStatus ();

    inline void clear_has_OdometerStatus ();

    inline void set_has_OdometerCount_Direction ();

    inline void clear_has_OdometerCount_Direction ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _Timestamp;

    uint16 _OdometerCount;

    T_e8_OdometerStatus _OdometerStatus;

    T_e8_OdometerDirection _OdometerCount_Direction;

};

/**
 * ABS wheel rotation counters from all four wheels.
 */
class T_AbsData {
public:

    /**
     * Default constructor
     */
    inline  T_AbsData ();

    /**
     * Copy constructor
     */
    inline  T_AbsData (const T_AbsData &rhs);

    /**
     * All fields constructor
     */
    inline  T_AbsData (uint32 AbsTimeStamp_, uint16 WheelCounterFrontLeft_, uint16 WheelCounterFrontRight_, uint16 WheelCounterRearLeft_, uint16 WheelCounterRearRight_, T_e8_AbsStatus StatusFrontLeft_, T_e8_AbsStatus StatusFrontRight_, T_e8_AbsStatus StatusRearLeft_, T_e8_AbsStatus StatusRearRight_, T_e8_AbsDirection DirectionFrontLeft_, T_e8_AbsDirection DirectionFrontRight_, T_e8_AbsDirection DirectionRearLeft_, T_e8_AbsDirection DirectionRearRight_);

    /**
     * Destructor
     */
    inline  ~T_AbsData();

    /**
     * Assignment operator
     */
    inline T_AbsData& operator = (const T_AbsData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AbsData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AbsData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AbsData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AbsData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AbsTimeStamp"

    static const int kAbsTimeStamp = 0;

    /**
     * Clears the field "AbsTimeStamp".
     *
     * The field will be set to its default value. The hasAbsTimeStamp()
     * method will return false.
     */
    inline void clearAbsTimeStamp();

    /**
     * Checks whether the field "AbsTimeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAbsTimeStamp()). Otherwise it will return false.
     */
    inline bool hasAbsTimeStamp () const;

    /**
     * Returns the value of the member "AbsTimeStamp".
     *
     *
     *
     * @return The value of the field "AbsTimeStamp"
     */
    inline uint32 getAbsTimeStamp () const;

    /**
     * Sets the value of the member "AbsTimeStamp".
     *
     *
     *
     * @param AbsTimeStamp The value which will be set
     */
    inline void setAbsTimeStamp (uint32 AbsTimeStamp_);

    // API of field "WheelCounterFrontLeft"

    static const int kWheelCounterFrontLeft = 1;

    /**
     * Clears the field "WheelCounterFrontLeft".
     *
     * The field will be set to its default value. The hasWheelCounterFrontLeft()
     * method will return false.
     */
    inline void clearWheelCounterFrontLeft();

    /**
     * Checks whether the field "WheelCounterFrontLeft" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWheelCounterFrontLeft()). Otherwise it will return false.
     */
    inline bool hasWheelCounterFrontLeft () const;

    /**
     * Returns the value of the member "WheelCounterFrontLeft".
     *
     * Wheel rotation counter (wrap around counter) for the front left
     * wheel.  The counter wraps around. The counter counts up while
     * driving forwards and down while driving backwards.
     *
     * @return The value of the field "WheelCounterFrontLeft"
     */
    inline uint16 getWheelCounterFrontLeft () const;

    /**
     * Sets the value of the member "WheelCounterFrontLeft".
     *
     * Wheel rotation counter (wrap around counter) for the front left
     * wheel.  The counter wraps around. The counter counts up while
     * driving forwards and down while driving backwards.
     *
     * @param WheelCounterFrontLeft The value which will be set
     */
    inline void setWheelCounterFrontLeft (uint16 WheelCounterFrontLeft_);

    // API of field "WheelCounterFrontRight"

    static const int kWheelCounterFrontRight = 2;

    /**
     * Clears the field "WheelCounterFrontRight".
     *
     * The field will be set to its default value. The hasWheelCounterFrontRight()
     * method will return false.
     */
    inline void clearWheelCounterFrontRight();

    /**
     * Checks whether the field "WheelCounterFrontRight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWheelCounterFrontRight()). Otherwise it will return false.
     */
    inline bool hasWheelCounterFrontRight () const;

    /**
     * Returns the value of the member "WheelCounterFrontRight".
     *
     * Wheel rotation counter (wrap around counter) for the front right
     * wheel. The counter counts up while driving forwards and down while
     * driving backwards.
     *
     * @return The value of the field "WheelCounterFrontRight"
     */
    inline uint16 getWheelCounterFrontRight () const;

    /**
     * Sets the value of the member "WheelCounterFrontRight".
     *
     * Wheel rotation counter (wrap around counter) for the front right
     * wheel. The counter counts up while driving forwards and down while
     * driving backwards.
     *
     * @param WheelCounterFrontRight The value which will be set
     */
    inline void setWheelCounterFrontRight (uint16 WheelCounterFrontRight_);

    // API of field "WheelCounterRearLeft"

    static const int kWheelCounterRearLeft = 3;

    /**
     * Clears the field "WheelCounterRearLeft".
     *
     * The field will be set to its default value. The hasWheelCounterRearLeft()
     * method will return false.
     */
    inline void clearWheelCounterRearLeft();

    /**
     * Checks whether the field "WheelCounterRearLeft" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWheelCounterRearLeft()). Otherwise it will return false.
     */
    inline bool hasWheelCounterRearLeft () const;

    /**
     * Returns the value of the member "WheelCounterRearLeft".
     *
     * Wheel rotation counter (wrap around counter) for the rear left
     * wheel. The counter wraps around. The counter counts up while driving
     * forwards and down while driving backwards.
     *
     * @return The value of the field "WheelCounterRearLeft"
     */
    inline uint16 getWheelCounterRearLeft () const;

    /**
     * Sets the value of the member "WheelCounterRearLeft".
     *
     * Wheel rotation counter (wrap around counter) for the rear left
     * wheel. The counter wraps around. The counter counts up while driving
     * forwards and down while driving backwards.
     *
     * @param WheelCounterRearLeft The value which will be set
     */
    inline void setWheelCounterRearLeft (uint16 WheelCounterRearLeft_);

    // API of field "WheelCounterRearRight"

    static const int kWheelCounterRearRight = 4;

    /**
     * Clears the field "WheelCounterRearRight".
     *
     * The field will be set to its default value. The hasWheelCounterRearRight()
     * method will return false.
     */
    inline void clearWheelCounterRearRight();

    /**
     * Checks whether the field "WheelCounterRearRight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWheelCounterRearRight()). Otherwise it will return false.
     */
    inline bool hasWheelCounterRearRight () const;

    /**
     * Returns the value of the member "WheelCounterRearRight".
     *
     * Wheel rotation counter (wrap around counter) for the rear right
     * wheel. The counter counts up while driving forwards and down while
     * driving backwards.
     *
     * @return The value of the field "WheelCounterRearRight"
     */
    inline uint16 getWheelCounterRearRight () const;

    /**
     * Sets the value of the member "WheelCounterRearRight".
     *
     * Wheel rotation counter (wrap around counter) for the rear right
     * wheel. The counter counts up while driving forwards and down while
     * driving backwards.
     *
     * @param WheelCounterRearRight The value which will be set
     */
    inline void setWheelCounterRearRight (uint16 WheelCounterRearRight_);

    // API of field "StatusFrontLeft"

    static const int kStatusFrontLeft = 5;

    /**
     * Clears the field "StatusFrontLeft".
     *
     * The field will be set to its default value. The hasStatusFrontLeft()
     * method will return false.
     */
    inline void clearStatusFrontLeft();

    /**
     * Checks whether the field "StatusFrontLeft" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusFrontLeft()). Otherwise it will return false.
     */
    inline bool hasStatusFrontLeft () const;

    /**
     * Returns the value of the member "StatusFrontLeft".
     *
     *
     *
     * @return The value of the field "StatusFrontLeft"
     */
    inline T_e8_AbsStatus getStatusFrontLeft () const;

    /**
     * Sets the value of the member "StatusFrontLeft".
     *
     *
     *
     * @param StatusFrontLeft The value which will be set
     */
    inline void setStatusFrontLeft (T_e8_AbsStatus StatusFrontLeft_);

    // API of field "StatusFrontRight"

    static const int kStatusFrontRight = 6;

    /**
     * Clears the field "StatusFrontRight".
     *
     * The field will be set to its default value. The hasStatusFrontRight()
     * method will return false.
     */
    inline void clearStatusFrontRight();

    /**
     * Checks whether the field "StatusFrontRight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusFrontRight()). Otherwise it will return false.
     */
    inline bool hasStatusFrontRight () const;

    /**
     * Returns the value of the member "StatusFrontRight".
     *
     *
     *
     * @return The value of the field "StatusFrontRight"
     */
    inline T_e8_AbsStatus getStatusFrontRight () const;

    /**
     * Sets the value of the member "StatusFrontRight".
     *
     *
     *
     * @param StatusFrontRight The value which will be set
     */
    inline void setStatusFrontRight (T_e8_AbsStatus StatusFrontRight_);

    // API of field "StatusRearLeft"

    static const int kStatusRearLeft = 7;

    /**
     * Clears the field "StatusRearLeft".
     *
     * The field will be set to its default value. The hasStatusRearLeft()
     * method will return false.
     */
    inline void clearStatusRearLeft();

    /**
     * Checks whether the field "StatusRearLeft" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusRearLeft()). Otherwise it will return false.
     */
    inline bool hasStatusRearLeft () const;

    /**
     * Returns the value of the member "StatusRearLeft".
     *
     *
     *
     * @return The value of the field "StatusRearLeft"
     */
    inline T_e8_AbsStatus getStatusRearLeft () const;

    /**
     * Sets the value of the member "StatusRearLeft".
     *
     *
     *
     * @param StatusRearLeft The value which will be set
     */
    inline void setStatusRearLeft (T_e8_AbsStatus StatusRearLeft_);

    // API of field "StatusRearRight"

    static const int kStatusRearRight = 8;

    /**
     * Clears the field "StatusRearRight".
     *
     * The field will be set to its default value. The hasStatusRearRight()
     * method will return false.
     */
    inline void clearStatusRearRight();

    /**
     * Checks whether the field "StatusRearRight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusRearRight()). Otherwise it will return false.
     */
    inline bool hasStatusRearRight () const;

    /**
     * Returns the value of the member "StatusRearRight".
     *
     *
     *
     * @return The value of the field "StatusRearRight"
     */
    inline T_e8_AbsStatus getStatusRearRight () const;

    /**
     * Sets the value of the member "StatusRearRight".
     *
     *
     *
     * @param StatusRearRight The value which will be set
     */
    inline void setStatusRearRight (T_e8_AbsStatus StatusRearRight_);

    // API of field "DirectionFrontLeft"

    static const int kDirectionFrontLeft = 9;

    /**
     * Clears the field "DirectionFrontLeft".
     *
     * The field will be set to its default value. The hasDirectionFrontLeft()
     * method will return false.
     */
    inline void clearDirectionFrontLeft();

    /**
     * Checks whether the field "DirectionFrontLeft" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirectionFrontLeft()). Otherwise it will return false.
     */
    inline bool hasDirectionFrontLeft () const;

    /**
     * Returns the value of the member "DirectionFrontLeft".
     *
     *
     *
     * @return The value of the field "DirectionFrontLeft"
     */
    inline T_e8_AbsDirection getDirectionFrontLeft () const;

    /**
     * Sets the value of the member "DirectionFrontLeft".
     *
     *
     *
     * @param DirectionFrontLeft The value which will be set
     */
    inline void setDirectionFrontLeft (T_e8_AbsDirection DirectionFrontLeft_);

    // API of field "DirectionFrontRight"

    static const int kDirectionFrontRight = 10;

    /**
     * Clears the field "DirectionFrontRight".
     *
     * The field will be set to its default value. The hasDirectionFrontRight()
     * method will return false.
     */
    inline void clearDirectionFrontRight();

    /**
     * Checks whether the field "DirectionFrontRight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirectionFrontRight()). Otherwise it will return false.
     */
    inline bool hasDirectionFrontRight () const;

    /**
     * Returns the value of the member "DirectionFrontRight".
     *
     *
     *
     * @return The value of the field "DirectionFrontRight"
     */
    inline T_e8_AbsDirection getDirectionFrontRight () const;

    /**
     * Sets the value of the member "DirectionFrontRight".
     *
     *
     *
     * @param DirectionFrontRight The value which will be set
     */
    inline void setDirectionFrontRight (T_e8_AbsDirection DirectionFrontRight_);

    // API of field "DirectionRearLeft"

    static const int kDirectionRearLeft = 11;

    /**
     * Clears the field "DirectionRearLeft".
     *
     * The field will be set to its default value. The hasDirectionRearLeft()
     * method will return false.
     */
    inline void clearDirectionRearLeft();

    /**
     * Checks whether the field "DirectionRearLeft" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirectionRearLeft()). Otherwise it will return false.
     */
    inline bool hasDirectionRearLeft () const;

    /**
     * Returns the value of the member "DirectionRearLeft".
     *
     *
     *
     * @return The value of the field "DirectionRearLeft"
     */
    inline T_e8_AbsDirection getDirectionRearLeft () const;

    /**
     * Sets the value of the member "DirectionRearLeft".
     *
     *
     *
     * @param DirectionRearLeft The value which will be set
     */
    inline void setDirectionRearLeft (T_e8_AbsDirection DirectionRearLeft_);

    // API of field "DirectionRearRight"

    static const int kDirectionRearRight = 12;

    /**
     * Clears the field "DirectionRearRight".
     *
     * The field will be set to its default value. The hasDirectionRearRight()
     * method will return false.
     */
    inline void clearDirectionRearRight();

    /**
     * Checks whether the field "DirectionRearRight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirectionRearRight()). Otherwise it will return false.
     */
    inline bool hasDirectionRearRight () const;

    /**
     * Returns the value of the member "DirectionRearRight".
     *
     *
     *
     * @return The value of the field "DirectionRearRight"
     */
    inline T_e8_AbsDirection getDirectionRearRight () const;

    /**
     * Sets the value of the member "DirectionRearRight".
     *
     *
     *
     * @param DirectionRearRight The value which will be set
     */
    inline void setDirectionRearRight (T_e8_AbsDirection DirectionRearRight_);

    static const T_AbsData &getDefaultInstance();

private:

    inline void set_has_AbsTimeStamp ();

    inline void clear_has_AbsTimeStamp ();

    inline void set_has_WheelCounterFrontLeft ();

    inline void clear_has_WheelCounterFrontLeft ();

    inline void set_has_WheelCounterFrontRight ();

    inline void clear_has_WheelCounterFrontRight ();

    inline void set_has_WheelCounterRearLeft ();

    inline void clear_has_WheelCounterRearLeft ();

    inline void set_has_WheelCounterRearRight ();

    inline void clear_has_WheelCounterRearRight ();

    inline void set_has_StatusFrontLeft ();

    inline void clear_has_StatusFrontLeft ();

    inline void set_has_StatusFrontRight ();

    inline void clear_has_StatusFrontRight ();

    inline void set_has_StatusRearLeft ();

    inline void clear_has_StatusRearLeft ();

    inline void set_has_StatusRearRight ();

    inline void clear_has_StatusRearRight ();

    inline void set_has_DirectionFrontLeft ();

    inline void clear_has_DirectionFrontLeft ();

    inline void set_has_DirectionFrontRight ();

    inline void clear_has_DirectionFrontRight ();

    inline void set_has_DirectionRearLeft ();

    inline void clear_has_DirectionRearLeft ();

    inline void set_has_DirectionRearRight ();

    inline void clear_has_DirectionRearRight ();

    uint32 _has_bits_[ (13 + 31) / 32];

    uint32 _AbsTimeStamp;

    uint16 _WheelCounterFrontLeft;

    uint16 _WheelCounterFrontRight;

    uint16 _WheelCounterRearLeft;

    uint16 _WheelCounterRearRight;

    T_e8_AbsStatus _StatusFrontLeft;

    T_e8_AbsStatus _StatusFrontRight;

    T_e8_AbsStatus _StatusRearLeft;

    T_e8_AbsStatus _StatusRearRight;

    T_e8_AbsDirection _DirectionFrontLeft;

    T_e8_AbsDirection _DirectionFrontRight;

    T_e8_AbsDirection _DirectionRearLeft;

    T_e8_AbsDirection _DirectionRearRight;

};

/**
 * This struct keeps information about the sensor hardware used. This
 * information can veray for each axes. These information is used for example
 * for the acc and gyro sensors.  If some of the empirical values are unknown
 * they are set to 0.0 for floats and 0 for integer values.
 */
class T_SensorHwInfo {
public:

    /**
     * Default constructor
     */
    inline  T_SensorHwInfo ();

    /**
     * Copy constructor
     */
    inline  T_SensorHwInfo (const T_SensorHwInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_SensorHwInfo (uint32 AdcRangeMin_, uint32 AdcRangeMax_, uint32 SampleMin_, uint32 SampleMax_, float MinNoiseValue_, float EstimOffset_, float MinOffset_, float MaxOffset_, float DriftOffset_, float MaxUnsteadOffset_, float BestCalibOffset_, float EstimScaleFactor_, float MinScaleFactor_, float MaxScaleFactor_, float DriftScaleFactor_, float MaxUnsteadScaleFactor_, float BestCalibScaleFactor_, float DriftOffsetTime_, float DriftScaleFactorTime_);

    /**
     * Destructor
     */
    inline  ~T_SensorHwInfo();

    /**
     * Assignment operator
     */
    inline T_SensorHwInfo& operator = (const T_SensorHwInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SensorHwInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SensorHwInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SensorHwInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SensorHwInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AdcRangeMin"

    static const int kAdcRangeMin = 0;

    /**
     * Clears the field "AdcRangeMin".
     *
     * The field will be set to its default value. The hasAdcRangeMin()
     * method will return false.
     */
    inline void clearAdcRangeMin();

    /**
     * Checks whether the field "AdcRangeMin" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAdcRangeMin()). Otherwise it will return false.
     */
    inline bool hasAdcRangeMin () const;

    /**
     * Returns the value of the member "AdcRangeMin".
     *
     * Minimal value of the ADC used.
     *
     * @return The value of the field "AdcRangeMin"
     */
    inline uint32 getAdcRangeMin () const;

    /**
     * Sets the value of the member "AdcRangeMin".
     *
     * Minimal value of the ADC used.
     *
     * @param AdcRangeMin The value which will be set
     */
    inline void setAdcRangeMin (uint32 AdcRangeMin_);

    // API of field "AdcRangeMax"

    static const int kAdcRangeMax = 1;

    /**
     * Clears the field "AdcRangeMax".
     *
     * The field will be set to its default value. The hasAdcRangeMax()
     * method will return false.
     */
    inline void clearAdcRangeMax();

    /**
     * Checks whether the field "AdcRangeMax" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAdcRangeMax()). Otherwise it will return false.
     */
    inline bool hasAdcRangeMax () const;

    /**
     * Returns the value of the member "AdcRangeMax".
     *
     * Maximal value of the ADC used.
     *
     * @return The value of the field "AdcRangeMax"
     */
    inline uint32 getAdcRangeMax () const;

    /**
     * Sets the value of the member "AdcRangeMax".
     *
     * Maximal value of the ADC used.
     *
     * @param AdcRangeMax The value which will be set
     */
    inline void setAdcRangeMax (uint32 AdcRangeMax_);

    // API of field "SampleMin"

    static const int kSampleMin = 2;

    /**
     * Clears the field "SampleMin".
     *
     * The field will be set to its default value. The hasSampleMin()
     * method will return false.
     */
    inline void clearSampleMin();

    /**
     * Checks whether the field "SampleMin" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSampleMin()). Otherwise it will return false.
     */
    inline bool hasSampleMin () const;

    /**
     * Returns the value of the member "SampleMin".
     *
     * Minimal sample value which in general is greater than the minimal ADC
     * value.
     *
     * @return The value of the field "SampleMin"
     */
    inline uint32 getSampleMin () const;

    /**
     * Sets the value of the member "SampleMin".
     *
     * Minimal sample value which in general is greater than the minimal ADC
     * value.
     *
     * @param SampleMin The value which will be set
     */
    inline void setSampleMin (uint32 SampleMin_);

    // API of field "SampleMax"

    static const int kSampleMax = 3;

    /**
     * Clears the field "SampleMax".
     *
     * The field will be set to its default value. The hasSampleMax()
     * method will return false.
     */
    inline void clearSampleMax();

    /**
     * Checks whether the field "SampleMax" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSampleMax()). Otherwise it will return false.
     */
    inline bool hasSampleMax () const;

    /**
     * Returns the value of the member "SampleMax".
     *
     * Maximal sample value which in general is less than the maximal ADC value.
     *
     * @return The value of the field "SampleMax"
     */
    inline uint32 getSampleMax () const;

    /**
     * Sets the value of the member "SampleMax".
     *
     * Maximal sample value which in general is less than the maximal ADC value.
     *
     * @param SampleMax The value which will be set
     */
    inline void setSampleMax (uint32 SampleMax_);

    // API of field "MinNoiseValue"

    static const int kMinNoiseValue = 4;

    /**
     * Clears the field "MinNoiseValue".
     *
     * The field will be set to its default value. The hasMinNoiseValue()
     * method will return false.
     */
    inline void clearMinNoiseValue();

    /**
     * Checks whether the field "MinNoiseValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinNoiseValue()). Otherwise it will return false.
     */
    inline bool hasMinNoiseValue () const;

    /**
     * Returns the value of the member "MinNoiseValue".
     *
     * The smallest noise value the sensor is generating, described by the 1
     * sigma standard deviation.
     *
     * @return The value of the field "MinNoiseValue"
     */
    inline float getMinNoiseValue () const;

    /**
     * Sets the value of the member "MinNoiseValue".
     *
     * The smallest noise value the sensor is generating, described by the 1
     * sigma standard deviation.
     *
     * @param MinNoiseValue The value which will be set
     */
    inline void setMinNoiseValue (float MinNoiseValue_);

    // API of field "EstimOffset"

    static const int kEstimOffset = 5;

    /**
     * Clears the field "EstimOffset".
     *
     * The field will be set to its default value. The hasEstimOffset()
     * method will return false.
     */
    inline void clearEstimOffset();

    /**
     * Checks whether the field "EstimOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEstimOffset()). Otherwise it will return false.
     */
    inline bool hasEstimOffset () const;

    /**
     * Returns the value of the member "EstimOffset".
     *
     * Estimated offset taken from the specification. This is the ADC value
     * one gets if the system is standing still e.g. if no turn or
     * acceleration is happening.
     *
     * @return The value of the field "EstimOffset"
     */
    inline float getEstimOffset () const;

    /**
     * Sets the value of the member "EstimOffset".
     *
     * Estimated offset taken from the specification. This is the ADC value
     * one gets if the system is standing still e.g. if no turn or
     * acceleration is happening.
     *
     * @param EstimOffset The value which will be set
     */
    inline void setEstimOffset (float EstimOffset_);

    // API of field "MinOffset"

    static const int kMinOffset = 6;

    /**
     * Clears the field "MinOffset".
     *
     * The field will be set to its default value. The hasMinOffset()
     * method will return false.
     */
    inline void clearMinOffset();

    /**
     * Checks whether the field "MinOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinOffset()). Otherwise it will return false.
     */
    inline bool hasMinOffset () const;

    /**
     * Returns the value of the member "MinOffset".
     *
     * Minimal offset taken from the specification.
     *
     * @return The value of the field "MinOffset"
     */
    inline float getMinOffset () const;

    /**
     * Sets the value of the member "MinOffset".
     *
     * Minimal offset taken from the specification.
     *
     * @param MinOffset The value which will be set
     */
    inline void setMinOffset (float MinOffset_);

    // API of field "MaxOffset"

    static const int kMaxOffset = 7;

    /**
     * Clears the field "MaxOffset".
     *
     * The field will be set to its default value. The hasMaxOffset()
     * method will return false.
     */
    inline void clearMaxOffset();

    /**
     * Checks whether the field "MaxOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxOffset()). Otherwise it will return false.
     */
    inline bool hasMaxOffset () const;

    /**
     * Returns the value of the member "MaxOffset".
     *
     * Maximal offset taken from the specification.
     *
     * @return The value of the field "MaxOffset"
     */
    inline float getMaxOffset () const;

    /**
     * Sets the value of the member "MaxOffset".
     *
     * Maximal offset taken from the specification.
     *
     * @param MaxOffset The value which will be set
     */
    inline void setMaxOffset (float MaxOffset_);

    // API of field "DriftOffset"

    static const int kDriftOffset = 8;

    /**
     * Clears the field "DriftOffset".
     *
     * The field will be set to its default value. The hasDriftOffset()
     * method will return false.
     */
    inline void clearDriftOffset();

    /**
     * Checks whether the field "DriftOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriftOffset()). Otherwise it will return false.
     */
    inline bool hasDriftOffset () const;

    /**
     * Returns the value of the member "DriftOffset".
     *
     * Drift of the offset as a function of temperature [1/ï¿½]. This is an
     * empirical value.
     *
     * @return The value of the field "DriftOffset"
     */
    inline float getDriftOffset () const;

    /**
     * Sets the value of the member "DriftOffset".
     *
     * Drift of the offset as a function of temperature [1/ï¿½]. This is an
     * empirical value.
     *
     * @param DriftOffset The value which will be set
     */
    inline void setDriftOffset (float DriftOffset_);

    // API of field "MaxUnsteadOffset"

    static const int kMaxUnsteadOffset = 9;

    /**
     * Clears the field "MaxUnsteadOffset".
     *
     * The field will be set to its default value. The hasMaxUnsteadOffset()
     * method will return false.
     */
    inline void clearMaxUnsteadOffset();

    /**
     * Checks whether the field "MaxUnsteadOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxUnsteadOffset()). Otherwise it will return false.
     */
    inline bool hasMaxUnsteadOffset () const;

    /**
     * Returns the value of the member "MaxUnsteadOffset".
     *
     * Maximal unsteadiness of the offset measured by the 1 sigma
     * standard deviation.
     *
     * @return The value of the field "MaxUnsteadOffset"
     */
    inline float getMaxUnsteadOffset () const;

    /**
     * Sets the value of the member "MaxUnsteadOffset".
     *
     * Maximal unsteadiness of the offset measured by the 1 sigma
     * standard deviation.
     *
     * @param MaxUnsteadOffset The value which will be set
     */
    inline void setMaxUnsteadOffset (float MaxUnsteadOffset_);

    // API of field "BestCalibOffset"

    static const int kBestCalibOffset = 10;

    /**
     * Clears the field "BestCalibOffset".
     *
     * The field will be set to its default value. The hasBestCalibOffset()
     * method will return false.
     */
    inline void clearBestCalibOffset();

    /**
     * Checks whether the field "BestCalibOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBestCalibOffset()). Otherwise it will return false.
     */
    inline bool hasBestCalibOffset () const;

    /**
     * Returns the value of the member "BestCalibOffset".
     *
     * Best quality of offset calibration. The calibration should not try to
     * get better then that value. The value describes the 1 sigma
     * standard deviation.
     *
     * @return The value of the field "BestCalibOffset"
     */
    inline float getBestCalibOffset () const;

    /**
     * Sets the value of the member "BestCalibOffset".
     *
     * Best quality of offset calibration. The calibration should not try to
     * get better then that value. The value describes the 1 sigma
     * standard deviation.
     *
     * @param BestCalibOffset The value which will be set
     */
    inline void setBestCalibOffset (float BestCalibOffset_);

    // API of field "EstimScaleFactor"

    static const int kEstimScaleFactor = 11;

    /**
     * Clears the field "EstimScaleFactor".
     *
     * The field will be set to its default value. The hasEstimScaleFactor()
     * method will return false.
     */
    inline void clearEstimScaleFactor();

    /**
     * Checks whether the field "EstimScaleFactor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEstimScaleFactor()). Otherwise it will return false.
     */
    inline bool hasEstimScaleFactor () const;

    /**
     * Returns the value of the member "EstimScaleFactor".
     *
     * The estimated scale factor is taken from the specification.  Unit of
     * the value is digits/ï¿½/s for the Gyro and digits/m/s/s for the acc.
     * For the gyro a positve angular rate results in a right hand
     * rotation. The sense of the rotation is counter clock wise. A negative
     * value results in a clockwise rotation. The sense of rotation must be
     * taken from the specification of the gyro and the mounting position of
     * the IC on the PCB.  For ACC a positve acceleration is in direction of
     * the R,S,T axis.
     *
     * @return The value of the field "EstimScaleFactor"
     */
    inline float getEstimScaleFactor () const;

    /**
     * Sets the value of the member "EstimScaleFactor".
     *
     * The estimated scale factor is taken from the specification.  Unit of
     * the value is digits/ï¿½/s for the Gyro and digits/m/s/s for the acc.
     * For the gyro a positve angular rate results in a right hand
     * rotation. The sense of the rotation is counter clock wise. A negative
     * value results in a clockwise rotation. The sense of rotation must be
     * taken from the specification of the gyro and the mounting position of
     * the IC on the PCB.  For ACC a positve acceleration is in direction of
     * the R,S,T axis.
     *
     * @param EstimScaleFactor The value which will be set
     */
    inline void setEstimScaleFactor (float EstimScaleFactor_);

    // API of field "MinScaleFactor"

    static const int kMinScaleFactor = 12;

    /**
     * Clears the field "MinScaleFactor".
     *
     * The field will be set to its default value. The hasMinScaleFactor()
     * method will return false.
     */
    inline void clearMinScaleFactor();

    /**
     * Checks whether the field "MinScaleFactor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinScaleFactor()). Otherwise it will return false.
     */
    inline bool hasMinScaleFactor () const;

    /**
     * Returns the value of the member "MinScaleFactor".
     *
     * Minimal scale factor taken from the specification.
     *
     * @return The value of the field "MinScaleFactor"
     */
    inline float getMinScaleFactor () const;

    /**
     * Sets the value of the member "MinScaleFactor".
     *
     * Minimal scale factor taken from the specification.
     *
     * @param MinScaleFactor The value which will be set
     */
    inline void setMinScaleFactor (float MinScaleFactor_);

    // API of field "MaxScaleFactor"

    static const int kMaxScaleFactor = 13;

    /**
     * Clears the field "MaxScaleFactor".
     *
     * The field will be set to its default value. The hasMaxScaleFactor()
     * method will return false.
     */
    inline void clearMaxScaleFactor();

    /**
     * Checks whether the field "MaxScaleFactor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxScaleFactor()). Otherwise it will return false.
     */
    inline bool hasMaxScaleFactor () const;

    /**
     * Returns the value of the member "MaxScaleFactor".
     *
     * Maximal scale factor taken from the specification.
     *
     * @return The value of the field "MaxScaleFactor"
     */
    inline float getMaxScaleFactor () const;

    /**
     * Sets the value of the member "MaxScaleFactor".
     *
     * Maximal scale factor taken from the specification.
     *
     * @param MaxScaleFactor The value which will be set
     */
    inline void setMaxScaleFactor (float MaxScaleFactor_);

    // API of field "DriftScaleFactor"

    static const int kDriftScaleFactor = 14;

    /**
     * Clears the field "DriftScaleFactor".
     *
     * The field will be set to its default value. The hasDriftScaleFactor()
     * method will return false.
     */
    inline void clearDriftScaleFactor();

    /**
     * Checks whether the field "DriftScaleFactor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriftScaleFactor()). Otherwise it will return false.
     */
    inline bool hasDriftScaleFactor () const;

    /**
     * Returns the value of the member "DriftScaleFactor".
     *
     * Drift of the scale factor as a function of temperature in
     * [1/ï¿½]. This is an empirical value.
     *
     * @return The value of the field "DriftScaleFactor"
     */
    inline float getDriftScaleFactor () const;

    /**
     * Sets the value of the member "DriftScaleFactor".
     *
     * Drift of the scale factor as a function of temperature in
     * [1/ï¿½]. This is an empirical value.
     *
     * @param DriftScaleFactor The value which will be set
     */
    inline void setDriftScaleFactor (float DriftScaleFactor_);

    // API of field "MaxUnsteadScaleFactor"

    static const int kMaxUnsteadScaleFactor = 15;

    /**
     * Clears the field "MaxUnsteadScaleFactor".
     *
     * The field will be set to its default value. The hasMaxUnsteadScaleFactor()
     * method will return false.
     */
    inline void clearMaxUnsteadScaleFactor();

    /**
     * Checks whether the field "MaxUnsteadScaleFactor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxUnsteadScaleFactor()). Otherwise it will return false.
     */
    inline bool hasMaxUnsteadScaleFactor () const;

    /**
     * Returns the value of the member "MaxUnsteadScaleFactor".
     *
     * Maximal unsteadiness of the scale factor given by the 1 sigma standard
     * deviation.
     *
     * @return The value of the field "MaxUnsteadScaleFactor"
     */
    inline float getMaxUnsteadScaleFactor () const;

    /**
     * Sets the value of the member "MaxUnsteadScaleFactor".
     *
     * Maximal unsteadiness of the scale factor given by the 1 sigma standard
     * deviation.
     *
     * @param MaxUnsteadScaleFactor The value which will be set
     */
    inline void setMaxUnsteadScaleFactor (float MaxUnsteadScaleFactor_);

    // API of field "BestCalibScaleFactor"

    static const int kBestCalibScaleFactor = 16;

    /**
     * Clears the field "BestCalibScaleFactor".
     *
     * The field will be set to its default value. The hasBestCalibScaleFactor()
     * method will return false.
     */
    inline void clearBestCalibScaleFactor();

    /**
     * Checks whether the field "BestCalibScaleFactor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBestCalibScaleFactor()). Otherwise it will return false.
     */
    inline bool hasBestCalibScaleFactor () const;

    /**
     * Returns the value of the member "BestCalibScaleFactor".
     *
     * Best quality of scale factor calibration. The calibration should not
     * try to get better then that value. The value describes the 1 sigma
     * standard deviation.
     *
     * @return The value of the field "BestCalibScaleFactor"
     */
    inline float getBestCalibScaleFactor () const;

    /**
     * Sets the value of the member "BestCalibScaleFactor".
     *
     * Best quality of scale factor calibration. The calibration should not
     * try to get better then that value. The value describes the 1 sigma
     * standard deviation.
     *
     * @param BestCalibScaleFactor The value which will be set
     */
    inline void setBestCalibScaleFactor (float BestCalibScaleFactor_);

    // API of field "DriftOffsetTime"

    static const int kDriftOffsetTime = 17;

    /**
     * Clears the field "DriftOffsetTime".
     *
     * The field will be set to its default value. The hasDriftOffsetTime()
     * method will return false.
     */
    inline void clearDriftOffsetTime();

    /**
     * Checks whether the field "DriftOffsetTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriftOffsetTime()). Otherwise it will return false.
     */
    inline bool hasDriftOffsetTime () const;

    /**
     * Returns the value of the member "DriftOffsetTime".
     *
     * Drift of the offset as a function of time in [1/s]. This is an
     * empirical value.
     *
     * @return The value of the field "DriftOffsetTime"
     */
    inline float getDriftOffsetTime () const;

    /**
     * Sets the value of the member "DriftOffsetTime".
     *
     * Drift of the offset as a function of time in [1/s]. This is an
     * empirical value.
     *
     * @param DriftOffsetTime The value which will be set
     */
    inline void setDriftOffsetTime (float DriftOffsetTime_);

    // API of field "DriftScaleFactorTime"

    static const int kDriftScaleFactorTime = 18;

    /**
     * Clears the field "DriftScaleFactorTime".
     *
     * The field will be set to its default value. The hasDriftScaleFactorTime()
     * method will return false.
     */
    inline void clearDriftScaleFactorTime();

    /**
     * Checks whether the field "DriftScaleFactorTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriftScaleFactorTime()). Otherwise it will return false.
     */
    inline bool hasDriftScaleFactorTime () const;

    /**
     * Returns the value of the member "DriftScaleFactorTime".
     *
     * Drift of the scale factor as a function of time in [1/s]. This is an
     * empirical value.
     *
     * @return The value of the field "DriftScaleFactorTime"
     */
    inline float getDriftScaleFactorTime () const;

    /**
     * Sets the value of the member "DriftScaleFactorTime".
     *
     * Drift of the scale factor as a function of time in [1/s]. This is an
     * empirical value.
     *
     * @param DriftScaleFactorTime The value which will be set
     */
    inline void setDriftScaleFactorTime (float DriftScaleFactorTime_);

    static const T_SensorHwInfo &getDefaultInstance();

private:

    inline void set_has_AdcRangeMin ();

    inline void clear_has_AdcRangeMin ();

    inline void set_has_AdcRangeMax ();

    inline void clear_has_AdcRangeMax ();

    inline void set_has_SampleMin ();

    inline void clear_has_SampleMin ();

    inline void set_has_SampleMax ();

    inline void clear_has_SampleMax ();

    inline void set_has_MinNoiseValue ();

    inline void clear_has_MinNoiseValue ();

    inline void set_has_EstimOffset ();

    inline void clear_has_EstimOffset ();

    inline void set_has_MinOffset ();

    inline void clear_has_MinOffset ();

    inline void set_has_MaxOffset ();

    inline void clear_has_MaxOffset ();

    inline void set_has_DriftOffset ();

    inline void clear_has_DriftOffset ();

    inline void set_has_MaxUnsteadOffset ();

    inline void clear_has_MaxUnsteadOffset ();

    inline void set_has_BestCalibOffset ();

    inline void clear_has_BestCalibOffset ();

    inline void set_has_EstimScaleFactor ();

    inline void clear_has_EstimScaleFactor ();

    inline void set_has_MinScaleFactor ();

    inline void clear_has_MinScaleFactor ();

    inline void set_has_MaxScaleFactor ();

    inline void clear_has_MaxScaleFactor ();

    inline void set_has_DriftScaleFactor ();

    inline void clear_has_DriftScaleFactor ();

    inline void set_has_MaxUnsteadScaleFactor ();

    inline void clear_has_MaxUnsteadScaleFactor ();

    inline void set_has_BestCalibScaleFactor ();

    inline void clear_has_BestCalibScaleFactor ();

    inline void set_has_DriftOffsetTime ();

    inline void clear_has_DriftOffsetTime ();

    inline void set_has_DriftScaleFactorTime ();

    inline void clear_has_DriftScaleFactorTime ();

    uint32 _has_bits_[ (19 + 31) / 32];

    uint32 _AdcRangeMin;

    uint32 _AdcRangeMax;

    uint32 _SampleMin;

    uint32 _SampleMax;

    float _MinNoiseValue;

    float _EstimOffset;

    float _MinOffset;

    float _MaxOffset;

    float _DriftOffset;

    float _MaxUnsteadOffset;

    float _BestCalibOffset;

    float _EstimScaleFactor;

    float _MinScaleFactor;

    float _MaxScaleFactor;

    float _DriftScaleFactor;

    float _MaxUnsteadScaleFactor;

    float _BestCalibScaleFactor;

    float _DriftOffsetTime;

    float _DriftScaleFactorTime;

};

/**
 * <p>@Figure fileName = ./figures/XYZ_RST_300dpi.gif width =</p>
 * <p>These angles describe the mounting position of the device in the car. The
 * angles are in degrees (grad) with 1ï¿½ steps (whole-numbers). Each angle can
 * be between 0ï¿½and 180ï¿½. The car coordinate system is fixed with X axis
 * showing into forward direction, Y showing to the left side and Z showing up
 * into the sky. The device itself has a coordinate system which is formed by
 * the axes R, S and T. Both coordinate systems are right hand and
 * orthogonal. The mounting angles describe the correlation of the XYZ
 * coordinate system to the RST coordinate system if the device is assembled
 * in certain position in the car. The nine angles used in the structure
 * describe the angles between each axis from the XYZ system to the RST
 * system. For example the angle AngRX describes the angle between the X-axis
 * and the R-axis. In general the RST coordinate system of the gyro and the
 * acc can differ.</p>
 */
class T_3dMountAngles {
public:

    /**
     * Default constructor
     */
    inline  T_3dMountAngles ();

    /**
     * Copy constructor
     */
    inline  T_3dMountAngles (const T_3dMountAngles &rhs);

    /**
     * All fields constructor
     */
    inline  T_3dMountAngles (uint8 AngRX_, uint8 AngRY_, uint8 AngRZ_, uint8 AngSX_, uint8 AngSY_, uint8 AngSZ_, uint8 AngTX_, uint8 AngTY_, uint8 AngTZ_);

    /**
     * Destructor
     */
    inline  ~T_3dMountAngles();

    /**
     * Assignment operator
     */
    inline T_3dMountAngles& operator = (const T_3dMountAngles& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_3dMountAngles& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_3dMountAngles& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_3dMountAngles& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_3dMountAngles& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AngRX"

    static const int kAngRX = 0;

    /**
     * Clears the field "AngRX".
     *
     * The field will be set to its default value. The hasAngRX()
     * method will return false.
     */
    inline void clearAngRX();

    /**
     * Checks whether the field "AngRX" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAngRX()). Otherwise it will return false.
     */
    inline bool hasAngRX () const;

    /**
     * Returns the value of the member "AngRX".
     *
     *
     *
     * @return The value of the field "AngRX"
     */
    inline uint8 getAngRX () const;

    /**
     * Sets the value of the member "AngRX".
     *
     *
     *
     * @param AngRX The value which will be set
     */
    inline void setAngRX (uint8 AngRX_);

    // API of field "AngRY"

    static const int kAngRY = 1;

    /**
     * Clears the field "AngRY".
     *
     * The field will be set to its default value. The hasAngRY()
     * method will return false.
     */
    inline void clearAngRY();

    /**
     * Checks whether the field "AngRY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAngRY()). Otherwise it will return false.
     */
    inline bool hasAngRY () const;

    /**
     * Returns the value of the member "AngRY".
     *
     *
     *
     * @return The value of the field "AngRY"
     */
    inline uint8 getAngRY () const;

    /**
     * Sets the value of the member "AngRY".
     *
     *
     *
     * @param AngRY The value which will be set
     */
    inline void setAngRY (uint8 AngRY_);

    // API of field "AngRZ"

    static const int kAngRZ = 2;

    /**
     * Clears the field "AngRZ".
     *
     * The field will be set to its default value. The hasAngRZ()
     * method will return false.
     */
    inline void clearAngRZ();

    /**
     * Checks whether the field "AngRZ" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAngRZ()). Otherwise it will return false.
     */
    inline bool hasAngRZ () const;

    /**
     * Returns the value of the member "AngRZ".
     *
     *
     *
     * @return The value of the field "AngRZ"
     */
    inline uint8 getAngRZ () const;

    /**
     * Sets the value of the member "AngRZ".
     *
     *
     *
     * @param AngRZ The value which will be set
     */
    inline void setAngRZ (uint8 AngRZ_);

    // API of field "AngSX"

    static const int kAngSX = 3;

    /**
     * Clears the field "AngSX".
     *
     * The field will be set to its default value. The hasAngSX()
     * method will return false.
     */
    inline void clearAngSX();

    /**
     * Checks whether the field "AngSX" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAngSX()). Otherwise it will return false.
     */
    inline bool hasAngSX () const;

    /**
     * Returns the value of the member "AngSX".
     *
     *
     *
     * @return The value of the field "AngSX"
     */
    inline uint8 getAngSX () const;

    /**
     * Sets the value of the member "AngSX".
     *
     *
     *
     * @param AngSX The value which will be set
     */
    inline void setAngSX (uint8 AngSX_);

    // API of field "AngSY"

    static const int kAngSY = 4;

    /**
     * Clears the field "AngSY".
     *
     * The field will be set to its default value. The hasAngSY()
     * method will return false.
     */
    inline void clearAngSY();

    /**
     * Checks whether the field "AngSY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAngSY()). Otherwise it will return false.
     */
    inline bool hasAngSY () const;

    /**
     * Returns the value of the member "AngSY".
     *
     *
     *
     * @return The value of the field "AngSY"
     */
    inline uint8 getAngSY () const;

    /**
     * Sets the value of the member "AngSY".
     *
     *
     *
     * @param AngSY The value which will be set
     */
    inline void setAngSY (uint8 AngSY_);

    // API of field "AngSZ"

    static const int kAngSZ = 5;

    /**
     * Clears the field "AngSZ".
     *
     * The field will be set to its default value. The hasAngSZ()
     * method will return false.
     */
    inline void clearAngSZ();

    /**
     * Checks whether the field "AngSZ" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAngSZ()). Otherwise it will return false.
     */
    inline bool hasAngSZ () const;

    /**
     * Returns the value of the member "AngSZ".
     *
     *
     *
     * @return The value of the field "AngSZ"
     */
    inline uint8 getAngSZ () const;

    /**
     * Sets the value of the member "AngSZ".
     *
     *
     *
     * @param AngSZ The value which will be set
     */
    inline void setAngSZ (uint8 AngSZ_);

    // API of field "AngTX"

    static const int kAngTX = 6;

    /**
     * Clears the field "AngTX".
     *
     * The field will be set to its default value. The hasAngTX()
     * method will return false.
     */
    inline void clearAngTX();

    /**
     * Checks whether the field "AngTX" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAngTX()). Otherwise it will return false.
     */
    inline bool hasAngTX () const;

    /**
     * Returns the value of the member "AngTX".
     *
     *
     *
     * @return The value of the field "AngTX"
     */
    inline uint8 getAngTX () const;

    /**
     * Sets the value of the member "AngTX".
     *
     *
     *
     * @param AngTX The value which will be set
     */
    inline void setAngTX (uint8 AngTX_);

    // API of field "AngTY"

    static const int kAngTY = 7;

    /**
     * Clears the field "AngTY".
     *
     * The field will be set to its default value. The hasAngTY()
     * method will return false.
     */
    inline void clearAngTY();

    /**
     * Checks whether the field "AngTY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAngTY()). Otherwise it will return false.
     */
    inline bool hasAngTY () const;

    /**
     * Returns the value of the member "AngTY".
     *
     *
     *
     * @return The value of the field "AngTY"
     */
    inline uint8 getAngTY () const;

    /**
     * Sets the value of the member "AngTY".
     *
     *
     *
     * @param AngTY The value which will be set
     */
    inline void setAngTY (uint8 AngTY_);

    // API of field "AngTZ"

    static const int kAngTZ = 8;

    /**
     * Clears the field "AngTZ".
     *
     * The field will be set to its default value. The hasAngTZ()
     * method will return false.
     */
    inline void clearAngTZ();

    /**
     * Checks whether the field "AngTZ" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAngTZ()). Otherwise it will return false.
     */
    inline bool hasAngTZ () const;

    /**
     * Returns the value of the member "AngTZ".
     *
     *
     *
     * @return The value of the field "AngTZ"
     */
    inline uint8 getAngTZ () const;

    /**
     * Sets the value of the member "AngTZ".
     *
     *
     *
     * @param AngTZ The value which will be set
     */
    inline void setAngTZ (uint8 AngTZ_);

    static const T_3dMountAngles &getDefaultInstance();

private:

    inline void set_has_AngRX ();

    inline void clear_has_AngRX ();

    inline void set_has_AngRY ();

    inline void clear_has_AngRY ();

    inline void set_has_AngRZ ();

    inline void clear_has_AngRZ ();

    inline void set_has_AngSX ();

    inline void clear_has_AngSX ();

    inline void set_has_AngSY ();

    inline void clear_has_AngSY ();

    inline void set_has_AngSZ ();

    inline void clear_has_AngSZ ();

    inline void set_has_AngTX ();

    inline void clear_has_AngTX ();

    inline void set_has_AngTY ();

    inline void clear_has_AngTY ();

    inline void set_has_AngTZ ();

    inline void clear_has_AngTZ ();

    uint32 _has_bits_[ (9 + 31) / 32];

    uint8 _AngRX;

    uint8 _AngRY;

    uint8 _AngRZ;

    uint8 _AngSX;

    uint8 _AngSY;

    uint8 _AngSZ;

    uint8 _AngTX;

    uint8 _AngTY;

    uint8 _AngTZ;

};

/**
 * <p>The 3DGyroHwInfo type keeps the hardware dependent gyro sensor information
 * on a per axes basis. The axes R, S and T correspond to the wirering of the
 * three axes. If the 3D functionality is reached via seperate ICs it is
 * assumed that the axes form a righthand orthogonal system.</p>
 */
class T_3dGyroHwInfo {
public:

    /**
     * Default constructor
     */
    inline  T_3dGyroHwInfo ();

    /**
     * Copy constructor
     */
    inline  T_3dGyroHwInfo (const T_3dGyroHwInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_3dGyroHwInfo (uint32 SampleRate_, const T_3dMountAngles& MountAngles_, const T_SensorHwInfo& RAxes_, const T_SensorHwInfo& SAxes_, const T_SensorHwInfo& TAxes_);

    /**
     * Destructor
     */
    inline  ~T_3dGyroHwInfo();

    /**
     * Assignment operator
     */
    inline T_3dGyroHwInfo& operator = (const T_3dGyroHwInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_3dGyroHwInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_3dGyroHwInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_3dGyroHwInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_3dGyroHwInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SampleRate"

    static const int kSampleRate = 0;

    /**
     * Clears the field "SampleRate".
     *
     * The field will be set to its default value. The hasSampleRate()
     * method will return false.
     */
    inline void clearSampleRate();

    /**
     * Checks whether the field "SampleRate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSampleRate()). Otherwise it will return false.
     */
    inline bool hasSampleRate () const;

    /**
     * Returns the value of the member "SampleRate".
     *
     * Samplerate. samples per second.
     *
     * @return The value of the field "SampleRate"
     */
    inline uint32 getSampleRate () const;

    /**
     * Sets the value of the member "SampleRate".
     *
     * Samplerate. samples per second.
     *
     * @param SampleRate The value which will be set
     */
    inline void setSampleRate (uint32 SampleRate_);

    // API of field "MountAngles"

    static const int kMountAngles = 1;

    /**
     * Clears the field "MountAngles".
     *
     * The field will be set to its default value. The hasMountAngles()
     * method will return false.
     */
    inline void clearMountAngles();

    /**
     * Checks whether the field "MountAngles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMountAngles()). Otherwise it will return false.
     */
    inline bool hasMountAngles () const;

    /**
     * Returns the value of the member "MountAngles".
     *
     * Mounting angles of the gyro
     *
     * @return The value of the field "MountAngles"
     */
    inline const T_3dMountAngles& getMountAngles () const;

    /**
     * Retrieves the value of the field "MountAngles" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MountAngles".
     */
    inline T_3dMountAngles& getMountAnglesMutable ();

    /**
     * Sets the value of the member "MountAngles".
     *
     * Mounting angles of the gyro
     *
     * @param MountAngles The value which will be set
     */
    inline void setMountAngles (const T_3dMountAngles& MountAngles_);

    // API of field "RAxes"

    static const int kRAxes = 2;

    /**
     * Clears the field "RAxes".
     *
     * The field will be set to its default value. The hasRAxes()
     * method will return false.
     */
    inline void clearRAxes();

    /**
     * Checks whether the field "RAxes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRAxes()). Otherwise it will return false.
     */
    inline bool hasRAxes () const;

    /**
     * Returns the value of the member "RAxes".
     *
     * Gyro hardware dependent information for the R-axes.
     *
     * @return The value of the field "RAxes"
     */
    inline const T_SensorHwInfo& getRAxes () const;

    /**
     * Retrieves the value of the field "RAxes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RAxes".
     */
    inline T_SensorHwInfo& getRAxesMutable ();

    /**
     * Sets the value of the member "RAxes".
     *
     * Gyro hardware dependent information for the R-axes.
     *
     * @param RAxes The value which will be set
     */
    inline void setRAxes (const T_SensorHwInfo& RAxes_);

    // API of field "SAxes"

    static const int kSAxes = 3;

    /**
     * Clears the field "SAxes".
     *
     * The field will be set to its default value. The hasSAxes()
     * method will return false.
     */
    inline void clearSAxes();

    /**
     * Checks whether the field "SAxes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAxes()). Otherwise it will return false.
     */
    inline bool hasSAxes () const;

    /**
     * Returns the value of the member "SAxes".
     *
     * Gyro hardware dependent information for the S-axes.
     *
     * @return The value of the field "SAxes"
     */
    inline const T_SensorHwInfo& getSAxes () const;

    /**
     * Retrieves the value of the field "SAxes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SAxes".
     */
    inline T_SensorHwInfo& getSAxesMutable ();

    /**
     * Sets the value of the member "SAxes".
     *
     * Gyro hardware dependent information for the S-axes.
     *
     * @param SAxes The value which will be set
     */
    inline void setSAxes (const T_SensorHwInfo& SAxes_);

    // API of field "TAxes"

    static const int kTAxes = 4;

    /**
     * Clears the field "TAxes".
     *
     * The field will be set to its default value. The hasTAxes()
     * method will return false.
     */
    inline void clearTAxes();

    /**
     * Checks whether the field "TAxes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTAxes()). Otherwise it will return false.
     */
    inline bool hasTAxes () const;

    /**
     * Returns the value of the member "TAxes".
     *
     * Gyro hardware dependent information for the T-axes.
     *
     * @return The value of the field "TAxes"
     */
    inline const T_SensorHwInfo& getTAxes () const;

    /**
     * Retrieves the value of the field "TAxes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TAxes".
     */
    inline T_SensorHwInfo& getTAxesMutable ();

    /**
     * Sets the value of the member "TAxes".
     *
     * Gyro hardware dependent information for the T-axes.
     *
     * @param TAxes The value which will be set
     */
    inline void setTAxes (const T_SensorHwInfo& TAxes_);

    static const T_3dGyroHwInfo &getDefaultInstance();

private:

    inline void set_has_SampleRate ();

    inline void clear_has_SampleRate ();

    inline void set_has_MountAngles ();

    inline void clear_has_MountAngles ();

    inline void set_has_RAxes ();

    inline void clear_has_RAxes ();

    inline void set_has_SAxes ();

    inline void clear_has_SAxes ();

    inline void set_has_TAxes ();

    inline void clear_has_TAxes ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _SampleRate;

    T_3dMountAngles _MountAngles;

    T_SensorHwInfo _RAxes;

    T_SensorHwInfo _SAxes;

    T_SensorHwInfo _TAxes;

};

/**
 * The 3DACCHwInfo type keeps the hardware dependent acceleration sensor
 * information on a per axis basis. The axis R, S, T correspond to the
 * wirering of the three axes. If the 3D funcionality is reached via seperate
 * ICs it is assumed that the acc axes form a righthand orthogonal
 * system.
 */
class T_3dAccHwInfo {
public:

    /**
     * Default constructor
     */
    inline  T_3dAccHwInfo ();

    /**
     * Copy constructor
     */
    inline  T_3dAccHwInfo (const T_3dAccHwInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_3dAccHwInfo (uint32 SampleRate_, const T_3dMountAngles& MountAngles_, const T_SensorHwInfo& RAxes_, const T_SensorHwInfo& SAxes_, const T_SensorHwInfo& TAxes_);

    /**
     * Destructor
     */
    inline  ~T_3dAccHwInfo();

    /**
     * Assignment operator
     */
    inline T_3dAccHwInfo& operator = (const T_3dAccHwInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_3dAccHwInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_3dAccHwInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_3dAccHwInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_3dAccHwInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SampleRate"

    static const int kSampleRate = 0;

    /**
     * Clears the field "SampleRate".
     *
     * The field will be set to its default value. The hasSampleRate()
     * method will return false.
     */
    inline void clearSampleRate();

    /**
     * Checks whether the field "SampleRate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSampleRate()). Otherwise it will return false.
     */
    inline bool hasSampleRate () const;

    /**
     * Returns the value of the member "SampleRate".
     *
     * Samplerate. Samples per second.
     *
     * @return The value of the field "SampleRate"
     */
    inline uint32 getSampleRate () const;

    /**
     * Sets the value of the member "SampleRate".
     *
     * Samplerate. Samples per second.
     *
     * @param SampleRate The value which will be set
     */
    inline void setSampleRate (uint32 SampleRate_);

    // API of field "MountAngles"

    static const int kMountAngles = 1;

    /**
     * Clears the field "MountAngles".
     *
     * The field will be set to its default value. The hasMountAngles()
     * method will return false.
     */
    inline void clearMountAngles();

    /**
     * Checks whether the field "MountAngles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMountAngles()). Otherwise it will return false.
     */
    inline bool hasMountAngles () const;

    /**
     * Returns the value of the member "MountAngles".
     *
     * Mounting angles of the acc.
     *
     * @return The value of the field "MountAngles"
     */
    inline const T_3dMountAngles& getMountAngles () const;

    /**
     * Retrieves the value of the field "MountAngles" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MountAngles".
     */
    inline T_3dMountAngles& getMountAnglesMutable ();

    /**
     * Sets the value of the member "MountAngles".
     *
     * Mounting angles of the acc.
     *
     * @param MountAngles The value which will be set
     */
    inline void setMountAngles (const T_3dMountAngles& MountAngles_);

    // API of field "RAxes"

    static const int kRAxes = 2;

    /**
     * Clears the field "RAxes".
     *
     * The field will be set to its default value. The hasRAxes()
     * method will return false.
     */
    inline void clearRAxes();

    /**
     * Checks whether the field "RAxes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRAxes()). Otherwise it will return false.
     */
    inline bool hasRAxes () const;

    /**
     * Returns the value of the member "RAxes".
     *
     * Acc hardware dependent information for the R-axes.
     *
     * @return The value of the field "RAxes"
     */
    inline const T_SensorHwInfo& getRAxes () const;

    /**
     * Retrieves the value of the field "RAxes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RAxes".
     */
    inline T_SensorHwInfo& getRAxesMutable ();

    /**
     * Sets the value of the member "RAxes".
     *
     * Acc hardware dependent information for the R-axes.
     *
     * @param RAxes The value which will be set
     */
    inline void setRAxes (const T_SensorHwInfo& RAxes_);

    // API of field "SAxes"

    static const int kSAxes = 3;

    /**
     * Clears the field "SAxes".
     *
     * The field will be set to its default value. The hasSAxes()
     * method will return false.
     */
    inline void clearSAxes();

    /**
     * Checks whether the field "SAxes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAxes()). Otherwise it will return false.
     */
    inline bool hasSAxes () const;

    /**
     * Returns the value of the member "SAxes".
     *
     * Acc hardware dependent information for the S-axes.
     *
     * @return The value of the field "SAxes"
     */
    inline const T_SensorHwInfo& getSAxes () const;

    /**
     * Retrieves the value of the field "SAxes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SAxes".
     */
    inline T_SensorHwInfo& getSAxesMutable ();

    /**
     * Sets the value of the member "SAxes".
     *
     * Acc hardware dependent information for the S-axes.
     *
     * @param SAxes The value which will be set
     */
    inline void setSAxes (const T_SensorHwInfo& SAxes_);

    // API of field "TAxes"

    static const int kTAxes = 4;

    /**
     * Clears the field "TAxes".
     *
     * The field will be set to its default value. The hasTAxes()
     * method will return false.
     */
    inline void clearTAxes();

    /**
     * Checks whether the field "TAxes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTAxes()). Otherwise it will return false.
     */
    inline bool hasTAxes () const;

    /**
     * Returns the value of the member "TAxes".
     *
     * Acc hardware info for the T-axes.
     *
     * @return The value of the field "TAxes"
     */
    inline const T_SensorHwInfo& getTAxes () const;

    /**
     * Retrieves the value of the field "TAxes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TAxes".
     */
    inline T_SensorHwInfo& getTAxesMutable ();

    /**
     * Sets the value of the member "TAxes".
     *
     * Acc hardware info for the T-axes.
     *
     * @param TAxes The value which will be set
     */
    inline void setTAxes (const T_SensorHwInfo& TAxes_);

    static const T_3dAccHwInfo &getDefaultInstance();

private:

    inline void set_has_SampleRate ();

    inline void clear_has_SampleRate ();

    inline void set_has_MountAngles ();

    inline void clear_has_MountAngles ();

    inline void set_has_RAxes ();

    inline void clear_has_RAxes ();

    inline void set_has_SAxes ();

    inline void clear_has_SAxes ();

    inline void set_has_TAxes ();

    inline void clear_has_TAxes ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _SampleRate;

    T_3dMountAngles _MountAngles;

    T_SensorHwInfo _RAxes;

    T_SensorHwInfo _SAxes;

    T_SensorHwInfo _TAxes;

};

/**
 * This type describes one sample of the 3D-gyro. One sample consists of a
 * timestamp, the three ADC values, and status information for every axes.
 */
class T_3dGyroData {
public:

    /**
     * Default constructor
     */
    inline  T_3dGyroData ();

    /**
     * Copy constructor
     */
    inline  T_3dGyroData (const T_3dGyroData &rhs);

    /**
     * All fields constructor
     */
    inline  T_3dGyroData (uint32 TimeStamp3dGyro_, uint32 RVal_, uint32 SVal_, uint32 TVal_, T_e16_GyroStatus RStatus_, T_e16_GyroStatus SStatus_, T_e16_GyroStatus TStatus_);

    /**
     * Destructor
     */
    inline  ~T_3dGyroData();

    /**
     * Assignment operator
     */
    inline T_3dGyroData& operator = (const T_3dGyroData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_3dGyroData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_3dGyroData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_3dGyroData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_3dGyroData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TimeStamp3dGyro"

    static const int kTimeStamp3dGyro = 0;

    /**
     * Clears the field "TimeStamp3dGyro".
     *
     * The field will be set to its default value. The hasTimeStamp3dGyro()
     * method will return false.
     */
    inline void clearTimeStamp3dGyro();

    /**
     * Checks whether the field "TimeStamp3dGyro" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeStamp3dGyro()). Otherwise it will return false.
     */
    inline bool hasTimeStamp3dGyro () const;

    /**
     * Returns the value of the member "TimeStamp3dGyro".
     *
     * sensor-tics (wrap around counter with separate count frequency defined
     * by /dev/auxclock)
     *
     * @return The value of the field "TimeStamp3dGyro"
     */
    inline uint32 getTimeStamp3dGyro () const;

    /**
     * Sets the value of the member "TimeStamp3dGyro".
     *
     * sensor-tics (wrap around counter with separate count frequency defined
     * by /dev/auxclock)
     *
     * @param TimeStamp3dGyro The value which will be set
     */
    inline void setTimeStamp3dGyro (uint32 TimeStamp3dGyro_);

    // API of field "RVal"

    static const int kRVal = 1;

    /**
     * Clears the field "RVal".
     *
     * The field will be set to its default value. The hasRVal()
     * method will return false.
     */
    inline void clearRVal();

    /**
     * Checks whether the field "RVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRVal()). Otherwise it will return false.
     */
    inline bool hasRVal () const;

    /**
     * Returns the value of the member "RVal".
     *
     * adc-value of the gyro r-coordinate
     *
     * @return The value of the field "RVal"
     */
    inline uint32 getRVal () const;

    /**
     * Sets the value of the member "RVal".
     *
     * adc-value of the gyro r-coordinate
     *
     * @param RVal The value which will be set
     */
    inline void setRVal (uint32 RVal_);

    // API of field "SVal"

    static const int kSVal = 2;

    /**
     * Clears the field "SVal".
     *
     * The field will be set to its default value. The hasSVal()
     * method will return false.
     */
    inline void clearSVal();

    /**
     * Checks whether the field "SVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSVal()). Otherwise it will return false.
     */
    inline bool hasSVal () const;

    /**
     * Returns the value of the member "SVal".
     *
     * adc-value of the gyro s-coordinate
     *
     * @return The value of the field "SVal"
     */
    inline uint32 getSVal () const;

    /**
     * Sets the value of the member "SVal".
     *
     * adc-value of the gyro s-coordinate
     *
     * @param SVal The value which will be set
     */
    inline void setSVal (uint32 SVal_);

    // API of field "TVal"

    static const int kTVal = 3;

    /**
     * Clears the field "TVal".
     *
     * The field will be set to its default value. The hasTVal()
     * method will return false.
     */
    inline void clearTVal();

    /**
     * Checks whether the field "TVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTVal()). Otherwise it will return false.
     */
    inline bool hasTVal () const;

    /**
     * Returns the value of the member "TVal".
     *
     * adc-value of the gyro t-coordinate
     *
     * @return The value of the field "TVal"
     */
    inline uint32 getTVal () const;

    /**
     * Sets the value of the member "TVal".
     *
     * adc-value of the gyro t-coordinate
     *
     * @param TVal The value which will be set
     */
    inline void setTVal (uint32 TVal_);

    // API of field "RStatus"

    static const int kRStatus = 4;

    /**
     * Clears the field "RStatus".
     *
     * The field will be set to its default value. The hasRStatus()
     * method will return false.
     */
    inline void clearRStatus();

    /**
     * Checks whether the field "RStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRStatus()). Otherwise it will return false.
     */
    inline bool hasRStatus () const;

    /**
     * Returns the value of the member "RStatus".
     *
     *
     *
     * @return The value of the field "RStatus"
     */
    inline T_e16_GyroStatus getRStatus () const;

    /**
     * Sets the value of the member "RStatus".
     *
     *
     *
     * @param RStatus The value which will be set
     */
    inline void setRStatus (T_e16_GyroStatus RStatus_);

    // API of field "SStatus"

    static const int kSStatus = 5;

    /**
     * Clears the field "SStatus".
     *
     * The field will be set to its default value. The hasSStatus()
     * method will return false.
     */
    inline void clearSStatus();

    /**
     * Checks whether the field "SStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSStatus()). Otherwise it will return false.
     */
    inline bool hasSStatus () const;

    /**
     * Returns the value of the member "SStatus".
     *
     *
     *
     * @return The value of the field "SStatus"
     */
    inline T_e16_GyroStatus getSStatus () const;

    /**
     * Sets the value of the member "SStatus".
     *
     *
     *
     * @param SStatus The value which will be set
     */
    inline void setSStatus (T_e16_GyroStatus SStatus_);

    // API of field "TStatus"

    static const int kTStatus = 6;

    /**
     * Clears the field "TStatus".
     *
     * The field will be set to its default value. The hasTStatus()
     * method will return false.
     */
    inline void clearTStatus();

    /**
     * Checks whether the field "TStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStatus()). Otherwise it will return false.
     */
    inline bool hasTStatus () const;

    /**
     * Returns the value of the member "TStatus".
     *
     *
     *
     * @return The value of the field "TStatus"
     */
    inline T_e16_GyroStatus getTStatus () const;

    /**
     * Sets the value of the member "TStatus".
     *
     *
     *
     * @param TStatus The value which will be set
     */
    inline void setTStatus (T_e16_GyroStatus TStatus_);

    static const T_3dGyroData &getDefaultInstance();

private:

    inline void set_has_TimeStamp3dGyro ();

    inline void clear_has_TimeStamp3dGyro ();

    inline void set_has_RVal ();

    inline void clear_has_RVal ();

    inline void set_has_SVal ();

    inline void clear_has_SVal ();

    inline void set_has_TVal ();

    inline void clear_has_TVal ();

    inline void set_has_RStatus ();

    inline void clear_has_RStatus ();

    inline void set_has_SStatus ();

    inline void clear_has_SStatus ();

    inline void set_has_TStatus ();

    inline void clear_has_TStatus ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint32 _TimeStamp3dGyro;

    uint32 _RVal;

    uint32 _SVal;

    uint32 _TVal;

    T_e16_GyroStatus _RStatus;

    T_e16_GyroStatus _SStatus;

    T_e16_GyroStatus _TStatus;

};

/**
 * This type describes one sample of the 3D ACC sensor. One sample consists of
 * a timestamp, the three ADC values, and status information for every axes.
 */
class T_3dAccData {
public:

    /**
     * Default constructor
     */
    inline  T_3dAccData ();

    /**
     * Copy constructor
     */
    inline  T_3dAccData (const T_3dAccData &rhs);

    /**
     * All fields constructor
     */
    inline  T_3dAccData (uint32 TimeStamp3dAcc_, uint32 RVal_, uint32 SVal_, uint32 TVal_, T_e16_AccStatus RStatus_, T_e16_AccStatus SStatus_, T_e16_AccStatus TStatus_);

    /**
     * Destructor
     */
    inline  ~T_3dAccData();

    /**
     * Assignment operator
     */
    inline T_3dAccData& operator = (const T_3dAccData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_3dAccData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_3dAccData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_3dAccData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_3dAccData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TimeStamp3dAcc"

    static const int kTimeStamp3dAcc = 0;

    /**
     * Clears the field "TimeStamp3dAcc".
     *
     * The field will be set to its default value. The hasTimeStamp3dAcc()
     * method will return false.
     */
    inline void clearTimeStamp3dAcc();

    /**
     * Checks whether the field "TimeStamp3dAcc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeStamp3dAcc()). Otherwise it will return false.
     */
    inline bool hasTimeStamp3dAcc () const;

    /**
     * Returns the value of the member "TimeStamp3dAcc".
     *
     * sensor-tics (wrap around counter with separate count frequency defined
     * by /dev/auxclock)
     *
     * @return The value of the field "TimeStamp3dAcc"
     */
    inline uint32 getTimeStamp3dAcc () const;

    /**
     * Sets the value of the member "TimeStamp3dAcc".
     *
     * sensor-tics (wrap around counter with separate count frequency defined
     * by /dev/auxclock)
     *
     * @param TimeStamp3dAcc The value which will be set
     */
    inline void setTimeStamp3dAcc (uint32 TimeStamp3dAcc_);

    // API of field "RVal"

    static const int kRVal = 1;

    /**
     * Clears the field "RVal".
     *
     * The field will be set to its default value. The hasRVal()
     * method will return false.
     */
    inline void clearRVal();

    /**
     * Checks whether the field "RVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRVal()). Otherwise it will return false.
     */
    inline bool hasRVal () const;

    /**
     * Returns the value of the member "RVal".
     *
     * adc-value of the R-axes
     *
     * @return The value of the field "RVal"
     */
    inline uint32 getRVal () const;

    /**
     * Sets the value of the member "RVal".
     *
     * adc-value of the R-axes
     *
     * @param RVal The value which will be set
     */
    inline void setRVal (uint32 RVal_);

    // API of field "SVal"

    static const int kSVal = 2;

    /**
     * Clears the field "SVal".
     *
     * The field will be set to its default value. The hasSVal()
     * method will return false.
     */
    inline void clearSVal();

    /**
     * Checks whether the field "SVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSVal()). Otherwise it will return false.
     */
    inline bool hasSVal () const;

    /**
     * Returns the value of the member "SVal".
     *
     * adc-value of the S-axes
     *
     * @return The value of the field "SVal"
     */
    inline uint32 getSVal () const;

    /**
     * Sets the value of the member "SVal".
     *
     * adc-value of the S-axes
     *
     * @param SVal The value which will be set
     */
    inline void setSVal (uint32 SVal_);

    // API of field "TVal"

    static const int kTVal = 3;

    /**
     * Clears the field "TVal".
     *
     * The field will be set to its default value. The hasTVal()
     * method will return false.
     */
    inline void clearTVal();

    /**
     * Checks whether the field "TVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTVal()). Otherwise it will return false.
     */
    inline bool hasTVal () const;

    /**
     * Returns the value of the member "TVal".
     *
     * adc-value of the T-axes
     *
     * @return The value of the field "TVal"
     */
    inline uint32 getTVal () const;

    /**
     * Sets the value of the member "TVal".
     *
     * adc-value of the T-axes
     *
     * @param TVal The value which will be set
     */
    inline void setTVal (uint32 TVal_);

    // API of field "RStatus"

    static const int kRStatus = 4;

    /**
     * Clears the field "RStatus".
     *
     * The field will be set to its default value. The hasRStatus()
     * method will return false.
     */
    inline void clearRStatus();

    /**
     * Checks whether the field "RStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRStatus()). Otherwise it will return false.
     */
    inline bool hasRStatus () const;

    /**
     * Returns the value of the member "RStatus".
     *
     *
     *
     * @return The value of the field "RStatus"
     */
    inline T_e16_AccStatus getRStatus () const;

    /**
     * Sets the value of the member "RStatus".
     *
     *
     *
     * @param RStatus The value which will be set
     */
    inline void setRStatus (T_e16_AccStatus RStatus_);

    // API of field "SStatus"

    static const int kSStatus = 5;

    /**
     * Clears the field "SStatus".
     *
     * The field will be set to its default value. The hasSStatus()
     * method will return false.
     */
    inline void clearSStatus();

    /**
     * Checks whether the field "SStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSStatus()). Otherwise it will return false.
     */
    inline bool hasSStatus () const;

    /**
     * Returns the value of the member "SStatus".
     *
     *
     *
     * @return The value of the field "SStatus"
     */
    inline T_e16_AccStatus getSStatus () const;

    /**
     * Sets the value of the member "SStatus".
     *
     *
     *
     * @param SStatus The value which will be set
     */
    inline void setSStatus (T_e16_AccStatus SStatus_);

    // API of field "TStatus"

    static const int kTStatus = 6;

    /**
     * Clears the field "TStatus".
     *
     * The field will be set to its default value. The hasTStatus()
     * method will return false.
     */
    inline void clearTStatus();

    /**
     * Checks whether the field "TStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStatus()). Otherwise it will return false.
     */
    inline bool hasTStatus () const;

    /**
     * Returns the value of the member "TStatus".
     *
     *
     *
     * @return The value of the field "TStatus"
     */
    inline T_e16_AccStatus getTStatus () const;

    /**
     * Sets the value of the member "TStatus".
     *
     *
     *
     * @param TStatus The value which will be set
     */
    inline void setTStatus (T_e16_AccStatus TStatus_);

    static const T_3dAccData &getDefaultInstance();

private:

    inline void set_has_TimeStamp3dAcc ();

    inline void clear_has_TimeStamp3dAcc ();

    inline void set_has_RVal ();

    inline void clear_has_RVal ();

    inline void set_has_SVal ();

    inline void clear_has_SVal ();

    inline void set_has_TVal ();

    inline void clear_has_TVal ();

    inline void set_has_RStatus ();

    inline void clear_has_RStatus ();

    inline void set_has_SStatus ();

    inline void clear_has_SStatus ();

    inline void set_has_TStatus ();

    inline void clear_has_TStatus ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint32 _TimeStamp3dAcc;

    uint32 _RVal;

    uint32 _SVal;

    uint32 _TVal;

    T_e16_AccStatus _RStatus;

    T_e16_AccStatus _SStatus;

    T_e16_AccStatus _TStatus;

};

/**
 * Bit field type defining the GNSS satellite systems that is/are or should be
 * used.
 */
class T_b8_GnssSatSys {
public:

    /**
     * Default constructor
     */
    inline  T_b8_GnssSatSys ();

    /**
     * Copy constructor
     */
    inline  T_b8_GnssSatSys (const T_b8_GnssSatSys &c);

    /**
     * Field constructor
     */
    inline  T_b8_GnssSatSys (bool GNSS_SATSYS_GPS, bool GNSS_SATSYS_GLONASS, bool GNSS_SATSYS_GALILEO, bool GNSS_SATSYS_COMPASS, bool GNSS_SATSYS_SBAS, bool GNSS_SATSYS_QZSS);

    /**
     * Assignment operator
     */
    inline T_b8_GnssSatSys& operator = (const T_b8_GnssSatSys& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_GnssSatSys& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_GnssSatSys& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_GnssSatSys& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_GnssSatSys& rhs) const;

    /**
     * Sets the value of the member "GNSS_SATSYS_GPS".
     *
     * If the meaning of "GNSS_SATSYS_GPS" isn't clear, then there should be a description here.
     *
     * @param GNSS_SATSYS_GPS The value which will be set
     */
    inline void setGNSS_SATSYS_GPS (bool GNSS_SATSYS_GPS);

    /**
     * Returns the value of the member "GNSS_SATSYS_GPS".
     *
     * If the meaning of "GNSS_SATSYS_GPS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GNSS_SATSYS_GPS"
     */
    inline bool getGNSS_SATSYS_GPS () const;

    /**
     * Sets the value of the member "GNSS_SATSYS_GLONASS".
     *
     * If the meaning of "GNSS_SATSYS_GLONASS" isn't clear, then there should be a description here.
     *
     * @param GNSS_SATSYS_GLONASS The value which will be set
     */
    inline void setGNSS_SATSYS_GLONASS (bool GNSS_SATSYS_GLONASS);

    /**
     * Returns the value of the member "GNSS_SATSYS_GLONASS".
     *
     * If the meaning of "GNSS_SATSYS_GLONASS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GNSS_SATSYS_GLONASS"
     */
    inline bool getGNSS_SATSYS_GLONASS () const;

    /**
     * Sets the value of the member "GNSS_SATSYS_GALILEO".
     *
     * If the meaning of "GNSS_SATSYS_GALILEO" isn't clear, then there should be a description here.
     *
     * @param GNSS_SATSYS_GALILEO The value which will be set
     */
    inline void setGNSS_SATSYS_GALILEO (bool GNSS_SATSYS_GALILEO);

    /**
     * Returns the value of the member "GNSS_SATSYS_GALILEO".
     *
     * If the meaning of "GNSS_SATSYS_GALILEO" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GNSS_SATSYS_GALILEO"
     */
    inline bool getGNSS_SATSYS_GALILEO () const;

    /**
     * Sets the value of the member "GNSS_SATSYS_COMPASS".
     *
     * If the meaning of "GNSS_SATSYS_COMPASS" isn't clear, then there should be a description here.
     *
     * @param GNSS_SATSYS_COMPASS The value which will be set
     */
    inline void setGNSS_SATSYS_COMPASS (bool GNSS_SATSYS_COMPASS);

    /**
     * Returns the value of the member "GNSS_SATSYS_COMPASS".
     *
     * If the meaning of "GNSS_SATSYS_COMPASS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GNSS_SATSYS_COMPASS"
     */
    inline bool getGNSS_SATSYS_COMPASS () const;

    /**
     * Sets the value of the member "GNSS_SATSYS_SBAS".
     *
     * If the meaning of "GNSS_SATSYS_SBAS" isn't clear, then there should be a description here.
     *
     * @param GNSS_SATSYS_SBAS The value which will be set
     */
    inline void setGNSS_SATSYS_SBAS (bool GNSS_SATSYS_SBAS);

    /**
     * Returns the value of the member "GNSS_SATSYS_SBAS".
     *
     * If the meaning of "GNSS_SATSYS_SBAS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GNSS_SATSYS_SBAS"
     */
    inline bool getGNSS_SATSYS_SBAS () const;

    /**
     * Sets the value of the member "GNSS_SATSYS_QZSS".
     *
     * If the meaning of "GNSS_SATSYS_QZSS" isn't clear, then there should be a description here.
     *
     * @param GNSS_SATSYS_QZSS The value which will be set
     */
    inline void setGNSS_SATSYS_QZSS (bool GNSS_SATSYS_QZSS);

    /**
     * Returns the value of the member "GNSS_SATSYS_QZSS".
     *
     * If the meaning of "GNSS_SATSYS_QZSS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GNSS_SATSYS_QZSS"
     */
    inline bool getGNSS_SATSYS_QZSS () const;

    static const T_b8_GnssSatSys &getDefaultInstance();

private:

    bool _GNSS_SATSYS_GPS:1;

    bool _GNSS_SATSYS_GLONASS:1;

    bool _GNSS_SATSYS_GALILEO:1;

    bool _GNSS_SATSYS_COMPASS:1;

    bool _GNSS_SATSYS_SBAS:1;

    bool _GNSS_SATSYS_QZSS:1;

};

/**
 * This bitfield keeps some status information of the satellite that the
 * channel is configured to, if it is tracked and if it is used for the
 * position calculation. This information has to be used with the bitmask
 * from the GnssConfigData structure.
 */
class T_b8_GnssSatStatus {
public:

    /**
     * Default constructor
     */
    inline  T_b8_GnssSatStatus ();

    /**
     * Copy constructor
     */
    inline  T_b8_GnssSatStatus (const T_b8_GnssSatStatus &c);

    /**
     * Field constructor
     */
    inline  T_b8_GnssSatStatus (bool SAT_HEALTHY, bool SAT_ALMANAC_AVAILABLE, bool SAT_EPHEMERIS_AVAILABLE, bool SAT_DGPS_AVAILABLE, bool SAT_TRACKED, bool SAT_USED_FOR_POSCALC);

    /**
     * Assignment operator
     */
    inline T_b8_GnssSatStatus& operator = (const T_b8_GnssSatStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_GnssSatStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_GnssSatStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_GnssSatStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_GnssSatStatus& rhs) const;

    /**
     * Sets the value of the member "SAT_HEALTHY".
     *
     * If the meaning of "SAT_HEALTHY" isn't clear, then there should be a description here.
     *
     * @param SAT_HEALTHY The value which will be set
     */
    inline void setSAT_HEALTHY (bool SAT_HEALTHY);

    /**
     * Returns the value of the member "SAT_HEALTHY".
     *
     * If the meaning of "SAT_HEALTHY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SAT_HEALTHY"
     */
    inline bool getSAT_HEALTHY () const;

    /**
     * Sets the value of the member "SAT_ALMANAC_AVAILABLE".
     *
     * If the meaning of "SAT_ALMANAC_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param SAT_ALMANAC_AVAILABLE The value which will be set
     */
    inline void setSAT_ALMANAC_AVAILABLE (bool SAT_ALMANAC_AVAILABLE);

    /**
     * Returns the value of the member "SAT_ALMANAC_AVAILABLE".
     *
     * If the meaning of "SAT_ALMANAC_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SAT_ALMANAC_AVAILABLE"
     */
    inline bool getSAT_ALMANAC_AVAILABLE () const;

    /**
     * Sets the value of the member "SAT_EPHEMERIS_AVAILABLE".
     *
     * If the meaning of "SAT_EPHEMERIS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param SAT_EPHEMERIS_AVAILABLE The value which will be set
     */
    inline void setSAT_EPHEMERIS_AVAILABLE (bool SAT_EPHEMERIS_AVAILABLE);

    /**
     * Returns the value of the member "SAT_EPHEMERIS_AVAILABLE".
     *
     * If the meaning of "SAT_EPHEMERIS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SAT_EPHEMERIS_AVAILABLE"
     */
    inline bool getSAT_EPHEMERIS_AVAILABLE () const;

    /**
     * Sets the value of the member "SAT_DGPS_AVAILABLE".
     *
     * If the meaning of "SAT_DGPS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param SAT_DGPS_AVAILABLE The value which will be set
     */
    inline void setSAT_DGPS_AVAILABLE (bool SAT_DGPS_AVAILABLE);

    /**
     * Returns the value of the member "SAT_DGPS_AVAILABLE".
     *
     * If the meaning of "SAT_DGPS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SAT_DGPS_AVAILABLE"
     */
    inline bool getSAT_DGPS_AVAILABLE () const;

    /**
     * Sets the value of the member "SAT_TRACKED".
     *
     * If the meaning of "SAT_TRACKED" isn't clear, then there should be a description here.
     *
     * @param SAT_TRACKED The value which will be set
     */
    inline void setSAT_TRACKED (bool SAT_TRACKED);

    /**
     * Returns the value of the member "SAT_TRACKED".
     *
     * If the meaning of "SAT_TRACKED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SAT_TRACKED"
     */
    inline bool getSAT_TRACKED () const;

    /**
     * Sets the value of the member "SAT_USED_FOR_POSCALC".
     *
     * If the meaning of "SAT_USED_FOR_POSCALC" isn't clear, then there should be a description here.
     *
     * @param SAT_USED_FOR_POSCALC The value which will be set
     */
    inline void setSAT_USED_FOR_POSCALC (bool SAT_USED_FOR_POSCALC);

    /**
     * Returns the value of the member "SAT_USED_FOR_POSCALC".
     *
     * If the meaning of "SAT_USED_FOR_POSCALC" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SAT_USED_FOR_POSCALC"
     */
    inline bool getSAT_USED_FOR_POSCALC () const;

    static const T_b8_GnssSatStatus &getDefaultInstance();

private:

    bool _SAT_HEALTHY:1;

    bool _SAT_ALMANAC_AVAILABLE:1;

    bool _SAT_EPHEMERIS_AVAILABLE:1;

    bool _SAT_DGPS_AVAILABLE:1;

    bool _SAT_TRACKED:1;

    bool _SAT_USED_FOR_POSCALC:1;

};

/**
 * Structure to keep all relevant information about the GNSS receiver and its
 * configuration.
 */
class T_GnssConfigData {
public:

    /**
     * Default constructor
     */
    inline  T_GnssConfigData ();

    /**
     * Copy constructor
     */
    inline  T_GnssConfigData (const T_GnssConfigData &rhs);

    /**
     * All fields constructor
     */
    inline  T_GnssConfigData (T_e8_GnssHw GnssHardwareType_, uint32 GnssReceiverFirmwareVersion_, uint32 GnssReceiverFirmwareCrc_, uint16 NumberOfChannels_, const T_b8_GnssSatStatus& UsedSatStatusBits_, uint8 UpdateFrequency_);

    /**
     * Destructor
     */
    inline  ~T_GnssConfigData();

    /**
     * Assignment operator
     */
    inline T_GnssConfigData& operator = (const T_GnssConfigData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_GnssConfigData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_GnssConfigData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_GnssConfigData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_GnssConfigData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GnssHardwareType"

    static const int kGnssHardwareType = 0;

    /**
     * Clears the field "GnssHardwareType".
     *
     * The field will be set to its default value. The hasGnssHardwareType()
     * method will return false.
     */
    inline void clearGnssHardwareType();

    /**
     * Checks whether the field "GnssHardwareType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssHardwareType()). Otherwise it will return false.
     */
    inline bool hasGnssHardwareType () const;

    /**
     * Returns the value of the member "GnssHardwareType".
     *
     * Type of GNSS receiver.
     *
     * @return The value of the field "GnssHardwareType"
     */
    inline T_e8_GnssHw getGnssHardwareType () const;

    /**
     * Sets the value of the member "GnssHardwareType".
     *
     * Type of GNSS receiver.
     *
     * @param GnssHardwareType The value which will be set
     */
    inline void setGnssHardwareType (T_e8_GnssHw GnssHardwareType_);

    // API of field "GnssReceiverFirmwareVersion"

    static const int kGnssReceiverFirmwareVersion = 1;

    /**
     * Clears the field "GnssReceiverFirmwareVersion".
     *
     * The field will be set to its default value. The hasGnssReceiverFirmwareVersion()
     * method will return false.
     */
    inline void clearGnssReceiverFirmwareVersion();

    /**
     * Checks whether the field "GnssReceiverFirmwareVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssReceiverFirmwareVersion()). Otherwise it will return false.
     */
    inline bool hasGnssReceiverFirmwareVersion () const;

    /**
     * Returns the value of the member "GnssReceiverFirmwareVersion".
     *
     * <p>The 4 bytes of the tU32 value form the version number in the following
     * fashion: 0x11223344 => 0x11.0x22.0x33.0x44 => 17.34.51.68</p>
     *
     * @return The value of the field "GnssReceiverFirmwareVersion"
     */
    inline uint32 getGnssReceiverFirmwareVersion () const;

    /**
     * Sets the value of the member "GnssReceiverFirmwareVersion".
     *
     * <p>The 4 bytes of the tU32 value form the version number in the following
     * fashion: 0x11223344 => 0x11.0x22.0x33.0x44 => 17.34.51.68</p>
     *
     * @param GnssReceiverFirmwareVersion The value which will be set
     */
    inline void setGnssReceiverFirmwareVersion (uint32 GnssReceiverFirmwareVersion_);

    // API of field "GnssReceiverFirmwareCrc"

    static const int kGnssReceiverFirmwareCrc = 2;

    /**
     * Clears the field "GnssReceiverFirmwareCrc".
     *
     * The field will be set to its default value. The hasGnssReceiverFirmwareCrc()
     * method will return false.
     */
    inline void clearGnssReceiverFirmwareCrc();

    /**
     * Checks whether the field "GnssReceiverFirmwareCrc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssReceiverFirmwareCrc()). Otherwise it will return false.
     */
    inline bool hasGnssReceiverFirmwareCrc () const;

    /**
     * Returns the value of the member "GnssReceiverFirmwareCrc".
     *
     * <p>CRC of the actual receiver firmware. If unknown the
     * value is set to 0.</p>
     *
     * @return The value of the field "GnssReceiverFirmwareCrc"
     */
    inline uint32 getGnssReceiverFirmwareCrc () const;

    /**
     * Sets the value of the member "GnssReceiverFirmwareCrc".
     *
     * <p>CRC of the actual receiver firmware. If unknown the
     * value is set to 0.</p>
     *
     * @param GnssReceiverFirmwareCrc The value which will be set
     */
    inline void setGnssReceiverFirmwareCrc (uint32 GnssReceiverFirmwareCrc_);

    // API of field "NumberOfChannels"

    static const int kNumberOfChannels = 3;

    /**
     * Clears the field "NumberOfChannels".
     *
     * The field will be set to its default value. The hasNumberOfChannels()
     * method will return false.
     */
    inline void clearNumberOfChannels();

    /**
     * Checks whether the field "NumberOfChannels" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberOfChannels()). Otherwise it will return false.
     */
    inline bool hasNumberOfChannels () const;

    /**
     * Returns the value of the member "NumberOfChannels".
     *
     * Physical number of channels of the GNSS receiver. This will also be
     * the upper limit for elements in channel based lists like the
     * GnssChanDataList.
     *
     * @return The value of the field "NumberOfChannels"
     */
    inline uint16 getNumberOfChannels () const;

    /**
     * Sets the value of the member "NumberOfChannels".
     *
     * Physical number of channels of the GNSS receiver. This will also be
     * the upper limit for elements in channel based lists like the
     * GnssChanDataList.
     *
     * @param NumberOfChannels The value which will be set
     */
    inline void setNumberOfChannels (uint16 NumberOfChannels_);

    // API of field "UsedSatStatusBits"

    static const int kUsedSatStatusBits = 4;

    /**
     * Clears the field "UsedSatStatusBits".
     *
     * The field will be set to its default value. The hasUsedSatStatusBits()
     * method will return false.
     */
    inline void clearUsedSatStatusBits();

    /**
     * Checks whether the field "UsedSatStatusBits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUsedSatStatusBits()). Otherwise it will return false.
     */
    inline bool hasUsedSatStatusBits () const;

    /**
     * Returns the value of the member "UsedSatStatusBits".
     *
     * This bitfield tells which satellite status bits in the T_GnssChanData
     * substructure SatStatus are used. This information is needed since not
     * all GNSS recievers provide all of the required information. Only the status
     * information that are set in the UsedSatStatusBits are save to
     * evaluate.
     *
     * @return The value of the field "UsedSatStatusBits"
     */
    inline const T_b8_GnssSatStatus& getUsedSatStatusBits () const;

    /**
     * Retrieves the value of the field "UsedSatStatusBits" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UsedSatStatusBits".
     */
    inline T_b8_GnssSatStatus& getUsedSatStatusBitsMutable ();

    /**
     * Sets the value of the member "UsedSatStatusBits".
     *
     * This bitfield tells which satellite status bits in the T_GnssChanData
     * substructure SatStatus are used. This information is needed since not
     * all GNSS recievers provide all of the required information. Only the status
     * information that are set in the UsedSatStatusBits are save to
     * evaluate.
     *
     * @param UsedSatStatusBits The value which will be set
     */
    inline void setUsedSatStatusBits (const T_b8_GnssSatStatus& UsedSatStatusBits_);

    // API of field "UpdateFrequency"

    static const int kUpdateFrequency = 5;

    /**
     * Clears the field "UpdateFrequency".
     *
     * The field will be set to its default value. The hasUpdateFrequency()
     * method will return false.
     */
    inline void clearUpdateFrequency();

    /**
     * Checks whether the field "UpdateFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateFrequency()). Otherwise it will return false.
     */
    inline bool hasUpdateFrequency () const;

    /**
     * Returns the value of the member "UpdateFrequency".
     *
     * The update frequency tells how many postions will be calculated per
     * second by the GNSS receiver. The unit is Hz.
     *
     * @return The value of the field "UpdateFrequency"
     */
    inline uint8 getUpdateFrequency () const;

    /**
     * Sets the value of the member "UpdateFrequency".
     *
     * The update frequency tells how many postions will be calculated per
     * second by the GNSS receiver. The unit is Hz.
     *
     * @param UpdateFrequency The value which will be set
     */
    inline void setUpdateFrequency (uint8 UpdateFrequency_);

    static const T_GnssConfigData &getDefaultInstance();

private:

    inline void set_has_GnssHardwareType ();

    inline void clear_has_GnssHardwareType ();

    inline void set_has_GnssReceiverFirmwareVersion ();

    inline void clear_has_GnssReceiverFirmwareVersion ();

    inline void set_has_GnssReceiverFirmwareCrc ();

    inline void clear_has_GnssReceiverFirmwareCrc ();

    inline void set_has_NumberOfChannels ();

    inline void clear_has_NumberOfChannels ();

    inline void set_has_UsedSatStatusBits ();

    inline void clear_has_UsedSatStatusBits ();

    inline void set_has_UpdateFrequency ();

    inline void clear_has_UpdateFrequency ();

    uint32 _has_bits_[ (6 + 31) / 32];

    T_e8_GnssHw _GnssHardwareType;

    uint32 _GnssReceiverFirmwareVersion;

    uint32 _GnssReceiverFirmwareCrc;

    uint16 _NumberOfChannels;

    T_b8_GnssSatStatus _UsedSatStatusBits;

    uint8 _UpdateFrequency;

};

/**
 * The status is a combination of the quality and mode information.
 */
class T_GnssStatus {
public:

    /**
     * Default constructor
     */
    inline  T_GnssStatus ();

    /**
     * Copy constructor
     */
    inline  T_GnssStatus (const T_GnssStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_GnssStatus (T_e8_GnssQuality GnssQuality_, T_e8_GnssMode GnssMode_);

    /**
     * Destructor
     */
    inline  ~T_GnssStatus();

    /**
     * Assignment operator
     */
    inline T_GnssStatus& operator = (const T_GnssStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_GnssStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_GnssStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_GnssStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_GnssStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GnssQuality"

    static const int kGnssQuality = 0;

    /**
     * Clears the field "GnssQuality".
     *
     * The field will be set to its default value. The hasGnssQuality()
     * method will return false.
     */
    inline void clearGnssQuality();

    /**
     * Checks whether the field "GnssQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssQuality()). Otherwise it will return false.
     */
    inline bool hasGnssQuality () const;

    /**
     * Returns the value of the member "GnssQuality".
     *
     * If the meaning of "GnssQuality" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GnssQuality"
     */
    inline T_e8_GnssQuality getGnssQuality () const;

    /**
     * Sets the value of the member "GnssQuality".
     *
     * If the meaning of "GnssQuality" isn't clear, then there should be a description here.
     *
     * @param GnssQuality The value which will be set
     */
    inline void setGnssQuality (T_e8_GnssQuality GnssQuality_);

    // API of field "GnssMode"

    static const int kGnssMode = 1;

    /**
     * Clears the field "GnssMode".
     *
     * The field will be set to its default value. The hasGnssMode()
     * method will return false.
     */
    inline void clearGnssMode();

    /**
     * Checks whether the field "GnssMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssMode()). Otherwise it will return false.
     */
    inline bool hasGnssMode () const;

    /**
     * Returns the value of the member "GnssMode".
     *
     * If the meaning of "GnssMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GnssMode"
     */
    inline T_e8_GnssMode getGnssMode () const;

    /**
     * Sets the value of the member "GnssMode".
     *
     * If the meaning of "GnssMode" isn't clear, then there should be a description here.
     *
     * @param GnssMode The value which will be set
     */
    inline void setGnssMode (T_e8_GnssMode GnssMode_);

    static const T_GnssStatus &getDefaultInstance();

private:

    inline void set_has_GnssQuality ();

    inline void clear_has_GnssQuality ();

    inline void set_has_GnssMode ();

    inline void clear_has_GnssMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_GnssQuality _GnssQuality;

    T_e8_GnssMode _GnssMode;

};

/**
 * Structure type holding the relevant information from a GPS covariance
 * matrix.  The fact that the matrix is symmetric is used; only the upper
 * triangle must be specified.  The GPS software calculates a 4x4 matrix, but
 * the last column is not relevant to the navigation application. All in all,
 * only 6 elements of the matrix must be specified.
 */
class T_CovarianceMatrixUpperTriangle {
public:

    /**
     * Default constructor
     */
    inline  T_CovarianceMatrixUpperTriangle ();

    /**
     * Copy constructor
     */
    inline  T_CovarianceMatrixUpperTriangle (const T_CovarianceMatrixUpperTriangle &rhs);

    /**
     * All fields constructor
     */
    inline  T_CovarianceMatrixUpperTriangle (float Elem0_, float Elem4_, float Elem5_, float Elem8_, float Elem9_, float Elem10_);

    /**
     * Destructor
     */
    inline  ~T_CovarianceMatrixUpperTriangle();

    /**
     * Assignment operator
     */
    inline T_CovarianceMatrixUpperTriangle& operator = (const T_CovarianceMatrixUpperTriangle& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CovarianceMatrixUpperTriangle& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CovarianceMatrixUpperTriangle& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CovarianceMatrixUpperTriangle& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CovarianceMatrixUpperTriangle& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Elem0"

    static const int kElem0 = 0;

    /**
     * Clears the field "Elem0".
     *
     * The field will be set to its default value. The hasElem0()
     * method will return false.
     */
    inline void clearElem0();

    /**
     * Checks whether the field "Elem0" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem0()). Otherwise it will return false.
     */
    inline bool hasElem0 () const;

    /**
     * Returns the value of the member "Elem0".
     *
     *
     *
     * @return The value of the field "Elem0"
     */
    inline float getElem0 () const;

    /**
     * Sets the value of the member "Elem0".
     *
     *
     *
     * @param Elem0 The value which will be set
     */
    inline void setElem0 (float Elem0_);

    // API of field "Elem4"

    static const int kElem4 = 1;

    /**
     * Clears the field "Elem4".
     *
     * The field will be set to its default value. The hasElem4()
     * method will return false.
     */
    inline void clearElem4();

    /**
     * Checks whether the field "Elem4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem4()). Otherwise it will return false.
     */
    inline bool hasElem4 () const;

    /**
     * Returns the value of the member "Elem4".
     *
     *
     *
     * @return The value of the field "Elem4"
     */
    inline float getElem4 () const;

    /**
     * Sets the value of the member "Elem4".
     *
     *
     *
     * @param Elem4 The value which will be set
     */
    inline void setElem4 (float Elem4_);

    // API of field "Elem5"

    static const int kElem5 = 2;

    /**
     * Clears the field "Elem5".
     *
     * The field will be set to its default value. The hasElem5()
     * method will return false.
     */
    inline void clearElem5();

    /**
     * Checks whether the field "Elem5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem5()). Otherwise it will return false.
     */
    inline bool hasElem5 () const;

    /**
     * Returns the value of the member "Elem5".
     *
     *
     *
     * @return The value of the field "Elem5"
     */
    inline float getElem5 () const;

    /**
     * Sets the value of the member "Elem5".
     *
     *
     *
     * @param Elem5 The value which will be set
     */
    inline void setElem5 (float Elem5_);

    // API of field "Elem8"

    static const int kElem8 = 3;

    /**
     * Clears the field "Elem8".
     *
     * The field will be set to its default value. The hasElem8()
     * method will return false.
     */
    inline void clearElem8();

    /**
     * Checks whether the field "Elem8" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem8()). Otherwise it will return false.
     */
    inline bool hasElem8 () const;

    /**
     * Returns the value of the member "Elem8".
     *
     *
     *
     * @return The value of the field "Elem8"
     */
    inline float getElem8 () const;

    /**
     * Sets the value of the member "Elem8".
     *
     *
     *
     * @param Elem8 The value which will be set
     */
    inline void setElem8 (float Elem8_);

    // API of field "Elem9"

    static const int kElem9 = 4;

    /**
     * Clears the field "Elem9".
     *
     * The field will be set to its default value. The hasElem9()
     * method will return false.
     */
    inline void clearElem9();

    /**
     * Checks whether the field "Elem9" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem9()). Otherwise it will return false.
     */
    inline bool hasElem9 () const;

    /**
     * Returns the value of the member "Elem9".
     *
     *
     *
     * @return The value of the field "Elem9"
     */
    inline float getElem9 () const;

    /**
     * Sets the value of the member "Elem9".
     *
     *
     *
     * @param Elem9 The value which will be set
     */
    inline void setElem9 (float Elem9_);

    // API of field "Elem10"

    static const int kElem10 = 5;

    /**
     * Clears the field "Elem10".
     *
     * The field will be set to its default value. The hasElem10()
     * method will return false.
     */
    inline void clearElem10();

    /**
     * Checks whether the field "Elem10" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem10()). Otherwise it will return false.
     */
    inline bool hasElem10 () const;

    /**
     * Returns the value of the member "Elem10".
     *
     *
     *
     * @return The value of the field "Elem10"
     */
    inline float getElem10 () const;

    /**
     * Sets the value of the member "Elem10".
     *
     *
     *
     * @param Elem10 The value which will be set
     */
    inline void setElem10 (float Elem10_);

    static const T_CovarianceMatrixUpperTriangle &getDefaultInstance();

private:

    inline void set_has_Elem0 ();

    inline void clear_has_Elem0 ();

    inline void set_has_Elem4 ();

    inline void clear_has_Elem4 ();

    inline void set_has_Elem5 ();

    inline void clear_has_Elem5 ();

    inline void set_has_Elem8 ();

    inline void clear_has_Elem8 ();

    inline void set_has_Elem9 ();

    inline void clear_has_Elem9 ();

    inline void set_has_Elem10 ();

    inline void clear_has_Elem10 ();

    uint32 _has_bits_[ (6 + 31) / 32];

    float _Elem0;

    float _Elem4;

    float _Elem5;

    float _Elem8;

    float _Elem9;

    float _Elem10;

};

/**
 * structure for describing a point in time (date and time)
 * e.g. 2012.12.24 20:01:00,123. This signifies year=2012,
 * mount=12, day=24, hour=20, minute=01, second=0,123
 */
class T_TimeDate {
public:

    /**
     * Default constructor
     */
    inline  T_TimeDate ();

    /**
     * Copy constructor
     */
    inline  T_TimeDate (const T_TimeDate &rhs);

    /**
     * All fields constructor
     */
    inline  T_TimeDate (uint16 td_year_, uint8 td_month_, uint8 td_day_, uint8 td_hour_, uint8 td_minute_, uint8 td_second_, uint16 td_milliSeconds_);

    /**
     * Destructor
     */
    inline  ~T_TimeDate();

    /**
     * Assignment operator
     */
    inline T_TimeDate& operator = (const T_TimeDate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TimeDate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TimeDate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TimeDate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TimeDate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "td_year"

    static const int kTd_year = 0;

    /**
     * Clears the field "td_year".
     *
     * The field will be set to its default value. The hasTd_year()
     * method will return false.
     */
    inline void clearTd_year();

    /**
     * Checks whether the field "td_year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTd_year()). Otherwise it will return false.
     */
    inline bool hasTd_year () const;

    /**
     * Returns the value of the member "td_year".
     *
     * year (0..65535) (e.g.)2012
     *
     * @return The value of the field "td_year"
     */
    inline uint16 getTd_year () const;

    /**
     * Sets the value of the member "td_year".
     *
     * year (0..65535) (e.g.)2012
     *
     * @param td_year The value which will be set
     */
    inline void setTd_year (uint16 td_year_);

    // API of field "td_month"

    static const int kTd_month = 1;

    /**
     * Clears the field "td_month".
     *
     * The field will be set to its default value. The hasTd_month()
     * method will return false.
     */
    inline void clearTd_month();

    /**
     * Checks whether the field "td_month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTd_month()). Otherwise it will return false.
     */
    inline bool hasTd_month () const;

    /**
     * Returns the value of the member "td_month".
     *
     * month of year (0..12). 0 if month is unknown.
     *
     * @return The value of the field "td_month"
     */
    inline uint8 getTd_month () const;

    /**
     * Sets the value of the member "td_month".
     *
     * month of year (0..12). 0 if month is unknown.
     *
     * @param td_month The value which will be set
     */
    inline void setTd_month (uint8 td_month_);

    // API of field "td_day"

    static const int kTd_day = 2;

    /**
     * Clears the field "td_day".
     *
     * The field will be set to its default value. The hasTd_day()
     * method will return false.
     */
    inline void clearTd_day();

    /**
     * Checks whether the field "td_day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTd_day()). Otherwise it will return false.
     */
    inline bool hasTd_day () const;

    /**
     * Returns the value of the member "td_day".
     *
     * day of month (0..31). 0 if day is unknown.
     *
     * @return The value of the field "td_day"
     */
    inline uint8 getTd_day () const;

    /**
     * Sets the value of the member "td_day".
     *
     * day of month (0..31). 0 if day is unknown.
     *
     * @param td_day The value which will be set
     */
    inline void setTd_day (uint8 td_day_);

    // API of field "td_hour"

    static const int kTd_hour = 3;

    /**
     * Clears the field "td_hour".
     *
     * The field will be set to its default value. The hasTd_hour()
     * method will return false.
     */
    inline void clearTd_hour();

    /**
     * Checks whether the field "td_hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTd_hour()). Otherwise it will return false.
     */
    inline bool hasTd_hour () const;

    /**
     * Returns the value of the member "td_hour".
     *
     * hour of day (0..23)
     *
     * @return The value of the field "td_hour"
     */
    inline uint8 getTd_hour () const;

    /**
     * Sets the value of the member "td_hour".
     *
     * hour of day (0..23)
     *
     * @param td_hour The value which will be set
     */
    inline void setTd_hour (uint8 td_hour_);

    // API of field "td_minute"

    static const int kTd_minute = 4;

    /**
     * Clears the field "td_minute".
     *
     * The field will be set to its default value. The hasTd_minute()
     * method will return false.
     */
    inline void clearTd_minute();

    /**
     * Checks whether the field "td_minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTd_minute()). Otherwise it will return false.
     */
    inline bool hasTd_minute () const;

    /**
     * Returns the value of the member "td_minute".
     *
     * minutes (0..59)
     *
     * @return The value of the field "td_minute"
     */
    inline uint8 getTd_minute () const;

    /**
     * Sets the value of the member "td_minute".
     *
     * minutes (0..59)
     *
     * @param td_minute The value which will be set
     */
    inline void setTd_minute (uint8 td_minute_);

    // API of field "td_second"

    static const int kTd_second = 5;

    /**
     * Clears the field "td_second".
     *
     * The field will be set to its default value. The hasTd_second()
     * method will return false.
     */
    inline void clearTd_second();

    /**
     * Checks whether the field "td_second" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTd_second()). Otherwise it will return false.
     */
    inline bool hasTd_second () const;

    /**
     * Returns the value of the member "td_second".
     *
     * seconds (0..59)
     *
     * @return The value of the field "td_second"
     */
    inline uint8 getTd_second () const;

    /**
     * Sets the value of the member "td_second".
     *
     * seconds (0..59)
     *
     * @param td_second The value which will be set
     */
    inline void setTd_second (uint8 td_second_);

    // API of field "td_milliSeconds"

    static const int kTd_milliSeconds = 6;

    /**
     * Clears the field "td_milliSeconds".
     *
     * The field will be set to its default value. The hasTd_milliSeconds()
     * method will return false.
     */
    inline void clearTd_milliSeconds();

    /**
     * Checks whether the field "td_milliSeconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTd_milliSeconds()). Otherwise it will return false.
     */
    inline bool hasTd_milliSeconds () const;

    /**
     * Returns the value of the member "td_milliSeconds".
     *
     * milli seconds (0..999).
     *
     * @return The value of the field "td_milliSeconds"
     */
    inline uint16 getTd_milliSeconds () const;

    /**
     * Sets the value of the member "td_milliSeconds".
     *
     * milli seconds (0..999).
     *
     * @param td_milliSeconds The value which will be set
     */
    inline void setTd_milliSeconds (uint16 td_milliSeconds_);

    static const T_TimeDate &getDefaultInstance();

private:

    inline void set_has_td_year ();

    inline void clear_has_td_year ();

    inline void set_has_td_month ();

    inline void clear_has_td_month ();

    inline void set_has_td_day ();

    inline void clear_has_td_day ();

    inline void set_has_td_hour ();

    inline void clear_has_td_hour ();

    inline void set_has_td_minute ();

    inline void clear_has_td_minute ();

    inline void set_has_td_second ();

    inline void clear_has_td_second ();

    inline void set_has_td_milliSeconds ();

    inline void clear_has_td_milliSeconds ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint16 _td_year;

    uint8 _td_month;

    uint8 _td_day;

    uint8 _td_hour;

    uint8 _td_minute;

    uint8 _td_second;

    uint16 _td_milliSeconds;

};

/**
 * Structure for the position, velocity and time (PVT) information of the
 * GNSS receiver. This information is updated with each GNSS sample.
 */
class T_GnssPvtData {
public:

    /**
     * Default constructor
     */
    inline  T_GnssPvtData ();

    /**
     * Copy constructor
     */
    inline  T_GnssPvtData (const T_GnssPvtData &rhs);

    /**
     * All fields constructor
     */
    inline  T_GnssPvtData (const T_TimeDate& UtcTimeDate_, double Latitude_, double Longitude_, float AltitudeWGS84_, float GeoidalSeparation_, float VelocityNorth_, float VelocityEast_, float VelocityUp_, const T_CovarianceMatrixUpperTriangle& PositionCovarianceMatrix_, const T_CovarianceMatrixUpperTriangle& VelocityCovarianceMatrix_, const T_GnssStatus& GnssStatus_, float GDOP_, float PDOP_, float HDOP_, float TDOP_, float VDOP_, const T_b8_GnssSatSys& SatSysUsed_, uint16 SatellitesVisible_, uint16 SatellitesReceived_, uint16 SatellitesUsed_);

    /**
     * Destructor
     */
    inline  ~T_GnssPvtData();

    /**
     * Assignment operator
     */
    inline T_GnssPvtData& operator = (const T_GnssPvtData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_GnssPvtData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_GnssPvtData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_GnssPvtData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_GnssPvtData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UtcTimeDate"

    static const int kUtcTimeDate = 0;

    /**
     * Clears the field "UtcTimeDate".
     *
     * The field will be set to its default value. The hasUtcTimeDate()
     * method will return false.
     */
    inline void clearUtcTimeDate();

    /**
     * Checks whether the field "UtcTimeDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUtcTimeDate()). Otherwise it will return false.
     */
    inline bool hasUtcTimeDate () const;

    /**
     * Returns the value of the member "UtcTimeDate".
     *
     * date and time information of the sample
     *
     * @return The value of the field "UtcTimeDate"
     */
    inline const T_TimeDate& getUtcTimeDate () const;

    /**
     * Retrieves the value of the field "UtcTimeDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UtcTimeDate".
     */
    inline T_TimeDate& getUtcTimeDateMutable ();

    /**
     * Sets the value of the member "UtcTimeDate".
     *
     * date and time information of the sample
     *
     * @param UtcTimeDate The value which will be set
     */
    inline void setUtcTimeDate (const T_TimeDate& UtcTimeDate_);

    // API of field "Latitude"

    static const int kLatitude = 1;

    /**
     * Clears the field "Latitude".
     *
     * The field will be set to its default value. The hasLatitude()
     * method will return false.
     */
    inline void clearLatitude();

    /**
     * Checks whether the field "Latitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLatitude()). Otherwise it will return false.
     */
    inline bool hasLatitude () const;

    /**
     * Returns the value of the member "Latitude".
     *
     * The latitude of the GNSS position in [ï¿½] .
     *
     * @return The value of the field "Latitude"
     */
    inline double getLatitude () const;

    /**
     * Sets the value of the member "Latitude".
     *
     * The latitude of the GNSS position in [ï¿½] .
     *
     * @param Latitude The value which will be set
     */
    inline void setLatitude (double Latitude_);

    // API of field "Longitude"

    static const int kLongitude = 2;

    /**
     * Clears the field "Longitude".
     *
     * The field will be set to its default value. The hasLongitude()
     * method will return false.
     */
    inline void clearLongitude();

    /**
     * Checks whether the field "Longitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLongitude()). Otherwise it will return false.
     */
    inline bool hasLongitude () const;

    /**
     * Returns the value of the member "Longitude".
     *
     * The longitude of the GNSS position in [ï¿½].
     *
     * @return The value of the field "Longitude"
     */
    inline double getLongitude () const;

    /**
     * Sets the value of the member "Longitude".
     *
     * The longitude of the GNSS position in [ï¿½].
     *
     * @param Longitude The value which will be set
     */
    inline void setLongitude (double Longitude_);

    // API of field "AltitudeWGS84"

    static const int kAltitudeWGS84 = 3;

    /**
     * Clears the field "AltitudeWGS84".
     *
     * The field will be set to its default value. The hasAltitudeWGS84()
     * method will return false.
     */
    inline void clearAltitudeWGS84();

    /**
     * Checks whether the field "AltitudeWGS84" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAltitudeWGS84()). Otherwise it will return false.
     */
    inline bool hasAltitudeWGS84 () const;

    /**
     * Returns the value of the member "AltitudeWGS84".
     *
     * The altitude related to the WGS84 ellipsoid of the
     * current position in [m].
     *
     * @return The value of the field "AltitudeWGS84"
     */
    inline float getAltitudeWGS84 () const;

    /**
     * Sets the value of the member "AltitudeWGS84".
     *
     * The altitude related to the WGS84 ellipsoid of the
     * current position in [m].
     *
     * @param AltitudeWGS84 The value which will be set
     */
    inline void setAltitudeWGS84 (float AltitudeWGS84_);

    // API of field "GeoidalSeparation"

    static const int kGeoidalSeparation = 4;

    /**
     * Clears the field "GeoidalSeparation".
     *
     * The field will be set to its default value. The hasGeoidalSeparation()
     * method will return false.
     */
    inline void clearGeoidalSeparation();

    /**
     * Checks whether the field "GeoidalSeparation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeoidalSeparation()). Otherwise it will return false.
     */
    inline bool hasGeoidalSeparation () const;

    /**
     * Returns the value of the member "GeoidalSeparation".
     *
     * The difference between the 0 altitude level of the WGS84 ellipsoid and
     * the mean sea level. This value can be used to calculate the altitude
     * related to mean sea level in [m].
     *
     * @return The value of the field "GeoidalSeparation"
     */
    inline float getGeoidalSeparation () const;

    /**
     * Sets the value of the member "GeoidalSeparation".
     *
     * The difference between the 0 altitude level of the WGS84 ellipsoid and
     * the mean sea level. This value can be used to calculate the altitude
     * related to mean sea level in [m].
     *
     * @param GeoidalSeparation The value which will be set
     */
    inline void setGeoidalSeparation (float GeoidalSeparation_);

    // API of field "VelocityNorth"

    static const int kVelocityNorth = 5;

    /**
     * Clears the field "VelocityNorth".
     *
     * The field will be set to its default value. The hasVelocityNorth()
     * method will return false.
     */
    inline void clearVelocityNorth();

    /**
     * Checks whether the field "VelocityNorth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVelocityNorth()). Otherwise it will return false.
     */
    inline bool hasVelocityNorth () const;

    /**
     * Returns the value of the member "VelocityNorth".
     *
     * North component of velocity vector in [m/s].
     *
     * @return The value of the field "VelocityNorth"
     */
    inline float getVelocityNorth () const;

    /**
     * Sets the value of the member "VelocityNorth".
     *
     * North component of velocity vector in [m/s].
     *
     * @param VelocityNorth The value which will be set
     */
    inline void setVelocityNorth (float VelocityNorth_);

    // API of field "VelocityEast"

    static const int kVelocityEast = 6;

    /**
     * Clears the field "VelocityEast".
     *
     * The field will be set to its default value. The hasVelocityEast()
     * method will return false.
     */
    inline void clearVelocityEast();

    /**
     * Checks whether the field "VelocityEast" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVelocityEast()). Otherwise it will return false.
     */
    inline bool hasVelocityEast () const;

    /**
     * Returns the value of the member "VelocityEast".
     *
     * East component of velocity vector in [m/s].
     *
     * @return The value of the field "VelocityEast"
     */
    inline float getVelocityEast () const;

    /**
     * Sets the value of the member "VelocityEast".
     *
     * East component of velocity vector in [m/s].
     *
     * @param VelocityEast The value which will be set
     */
    inline void setVelocityEast (float VelocityEast_);

    // API of field "VelocityUp"

    static const int kVelocityUp = 7;

    /**
     * Clears the field "VelocityUp".
     *
     * The field will be set to its default value. The hasVelocityUp()
     * method will return false.
     */
    inline void clearVelocityUp();

    /**
     * Checks whether the field "VelocityUp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVelocityUp()). Otherwise it will return false.
     */
    inline bool hasVelocityUp () const;

    /**
     * Returns the value of the member "VelocityUp".
     *
     * Upwards component of velocity vector in [m/s].
     *
     * @return The value of the field "VelocityUp"
     */
    inline float getVelocityUp () const;

    /**
     * Sets the value of the member "VelocityUp".
     *
     * Upwards component of velocity vector in [m/s].
     *
     * @param VelocityUp The value which will be set
     */
    inline void setVelocityUp (float VelocityUp_);

    // API of field "PositionCovarianceMatrix"

    static const int kPositionCovarianceMatrix = 8;

    /**
     * Clears the field "PositionCovarianceMatrix".
     *
     * The field will be set to its default value. The hasPositionCovarianceMatrix()
     * method will return false.
     */
    inline void clearPositionCovarianceMatrix();

    /**
     * Checks whether the field "PositionCovarianceMatrix" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPositionCovarianceMatrix()). Otherwise it will return false.
     */
    inline bool hasPositionCovarianceMatrix () const;

    /**
     * Returns the value of the member "PositionCovarianceMatrix".
     *
     * Covariance matrix for the position in [m^2].
     *
     * @return The value of the field "PositionCovarianceMatrix"
     */
    inline const T_CovarianceMatrixUpperTriangle& getPositionCovarianceMatrix () const;

    /**
     * Retrieves the value of the field "PositionCovarianceMatrix" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PositionCovarianceMatrix".
     */
    inline T_CovarianceMatrixUpperTriangle& getPositionCovarianceMatrixMutable ();

    /**
     * Sets the value of the member "PositionCovarianceMatrix".
     *
     * Covariance matrix for the position in [m^2].
     *
     * @param PositionCovarianceMatrix The value which will be set
     */
    inline void setPositionCovarianceMatrix (const T_CovarianceMatrixUpperTriangle& PositionCovarianceMatrix_);

    // API of field "VelocityCovarianceMatrix"

    static const int kVelocityCovarianceMatrix = 9;

    /**
     * Clears the field "VelocityCovarianceMatrix".
     *
     * The field will be set to its default value. The hasVelocityCovarianceMatrix()
     * method will return false.
     */
    inline void clearVelocityCovarianceMatrix();

    /**
     * Checks whether the field "VelocityCovarianceMatrix" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVelocityCovarianceMatrix()). Otherwise it will return false.
     */
    inline bool hasVelocityCovarianceMatrix () const;

    /**
     * Returns the value of the member "VelocityCovarianceMatrix".
     *
     * Covariance matrix for the velocity in [m^2/s^2].
     *
     * @return The value of the field "VelocityCovarianceMatrix"
     */
    inline const T_CovarianceMatrixUpperTriangle& getVelocityCovarianceMatrix () const;

    /**
     * Retrieves the value of the field "VelocityCovarianceMatrix" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VelocityCovarianceMatrix".
     */
    inline T_CovarianceMatrixUpperTriangle& getVelocityCovarianceMatrixMutable ();

    /**
     * Sets the value of the member "VelocityCovarianceMatrix".
     *
     * Covariance matrix for the velocity in [m^2/s^2].
     *
     * @param VelocityCovarianceMatrix The value which will be set
     */
    inline void setVelocityCovarianceMatrix (const T_CovarianceMatrixUpperTriangle& VelocityCovarianceMatrix_);

    // API of field "GnssStatus"

    static const int kGnssStatus = 10;

    /**
     * Clears the field "GnssStatus".
     *
     * The field will be set to its default value. The hasGnssStatus()
     * method will return false.
     */
    inline void clearGnssStatus();

    /**
     * Checks whether the field "GnssStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssStatus()). Otherwise it will return false.
     */
    inline bool hasGnssStatus () const;

    /**
     * Returns the value of the member "GnssStatus".
     *
     * status of the GNSS position: 2D or 3D and autonomous or differential.
     *
     * @return The value of the field "GnssStatus"
     */
    inline const T_GnssStatus& getGnssStatus () const;

    /**
     * Retrieves the value of the field "GnssStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GnssStatus".
     */
    inline T_GnssStatus& getGnssStatusMutable ();

    /**
     * Sets the value of the member "GnssStatus".
     *
     * status of the GNSS position: 2D or 3D and autonomous or differential.
     *
     * @param GnssStatus The value which will be set
     */
    inline void setGnssStatus (const T_GnssStatus& GnssStatus_);

    // API of field "GDOP"

    static const int kGDOP = 11;

    /**
     * Clears the field "GDOP".
     *
     * The field will be set to its default value. The hasGDOP()
     * method will return false.
     */
    inline void clearGDOP();

    /**
     * Checks whether the field "GDOP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGDOP()). Otherwise it will return false.
     */
    inline bool hasGDOP () const;

    /**
     * Returns the value of the member "GDOP".
     *
     * geometric DOP. 0.0 = not available
     *
     * @return The value of the field "GDOP"
     */
    inline float getGDOP () const;

    /**
     * Sets the value of the member "GDOP".
     *
     * geometric DOP. 0.0 = not available
     *
     * @param GDOP The value which will be set
     */
    inline void setGDOP (float GDOP_);

    // API of field "PDOP"

    static const int kPDOP = 12;

    /**
     * Clears the field "PDOP".
     *
     * The field will be set to its default value. The hasPDOP()
     * method will return false.
     */
    inline void clearPDOP();

    /**
     * Checks whether the field "PDOP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPDOP()). Otherwise it will return false.
     */
    inline bool hasPDOP () const;

    /**
     * Returns the value of the member "PDOP".
     *
     * positional DOP (3D). 0.0 = not available
     *
     * @return The value of the field "PDOP"
     */
    inline float getPDOP () const;

    /**
     * Sets the value of the member "PDOP".
     *
     * positional DOP (3D). 0.0 = not available
     *
     * @param PDOP The value which will be set
     */
    inline void setPDOP (float PDOP_);

    // API of field "HDOP"

    static const int kHDOP = 13;

    /**
     * Clears the field "HDOP".
     *
     * The field will be set to its default value. The hasHDOP()
     * method will return false.
     */
    inline void clearHDOP();

    /**
     * Checks whether the field "HDOP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHDOP()). Otherwise it will return false.
     */
    inline bool hasHDOP () const;

    /**
     * Returns the value of the member "HDOP".
     *
     * horizontal DOP. 0.0 = not available
     *
     * @return The value of the field "HDOP"
     */
    inline float getHDOP () const;

    /**
     * Sets the value of the member "HDOP".
     *
     * horizontal DOP. 0.0 = not available
     *
     * @param HDOP The value which will be set
     */
    inline void setHDOP (float HDOP_);

    // API of field "TDOP"

    static const int kTDOP = 14;

    /**
     * Clears the field "TDOP".
     *
     * The field will be set to its default value. The hasTDOP()
     * method will return false.
     */
    inline void clearTDOP();

    /**
     * Checks whether the field "TDOP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTDOP()). Otherwise it will return false.
     */
    inline bool hasTDOP () const;

    /**
     * Returns the value of the member "TDOP".
     *
     * time DOP. 0.0 = not available
     *
     * @return The value of the field "TDOP"
     */
    inline float getTDOP () const;

    /**
     * Sets the value of the member "TDOP".
     *
     * time DOP. 0.0 = not available
     *
     * @param TDOP The value which will be set
     */
    inline void setTDOP (float TDOP_);

    // API of field "VDOP"

    static const int kVDOP = 15;

    /**
     * Clears the field "VDOP".
     *
     * The field will be set to its default value. The hasVDOP()
     * method will return false.
     */
    inline void clearVDOP();

    /**
     * Checks whether the field "VDOP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVDOP()). Otherwise it will return false.
     */
    inline bool hasVDOP () const;

    /**
     * Returns the value of the member "VDOP".
     *
     * vertical DOP. 0.0 = not available
     *
     * @return The value of the field "VDOP"
     */
    inline float getVDOP () const;

    /**
     * Sets the value of the member "VDOP".
     *
     * vertical DOP. 0.0 = not available
     *
     * @param VDOP The value which will be set
     */
    inline void setVDOP (float VDOP_);

    // API of field "SatSysUsed"

    static const int kSatSysUsed = 16;

    /**
     * Clears the field "SatSysUsed".
     *
     * The field will be set to its default value. The hasSatSysUsed()
     * method will return false.
     */
    inline void clearSatSysUsed();

    /**
     * Checks whether the field "SatSysUsed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSatSysUsed()). Otherwise it will return false.
     */
    inline bool hasSatSysUsed () const;

    /**
     * Returns the value of the member "SatSysUsed".
     *
     * Tells which satellite systems are enabled.
     *
     * @return The value of the field "SatSysUsed"
     */
    inline const T_b8_GnssSatSys& getSatSysUsed () const;

    /**
     * Retrieves the value of the field "SatSysUsed" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SatSysUsed".
     */
    inline T_b8_GnssSatSys& getSatSysUsedMutable ();

    /**
     * Sets the value of the member "SatSysUsed".
     *
     * Tells which satellite systems are enabled.
     *
     * @param SatSysUsed The value which will be set
     */
    inline void setSatSysUsed (const T_b8_GnssSatSys& SatSysUsed_);

    // API of field "SatellitesVisible"

    static const int kSatellitesVisible = 17;

    /**
     * Clears the field "SatellitesVisible".
     *
     * The field will be set to its default value. The hasSatellitesVisible()
     * method will return false.
     */
    inline void clearSatellitesVisible();

    /**
     * Checks whether the field "SatellitesVisible" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSatellitesVisible()). Otherwise it will return false.
     */
    inline bool hasSatellitesVisible () const;

    /**
     * Returns the value of the member "SatellitesVisible".
     *
     * Total number of visible satellites of all satellite systems.
     *
     * @return The value of the field "SatellitesVisible"
     */
    inline uint16 getSatellitesVisible () const;

    /**
     * Sets the value of the member "SatellitesVisible".
     *
     * Total number of visible satellites of all satellite systems.
     *
     * @param SatellitesVisible The value which will be set
     */
    inline void setSatellitesVisible (uint16 SatellitesVisible_);

    // API of field "SatellitesReceived"

    static const int kSatellitesReceived = 18;

    /**
     * Clears the field "SatellitesReceived".
     *
     * The field will be set to its default value. The hasSatellitesReceived()
     * method will return false.
     */
    inline void clearSatellitesReceived();

    /**
     * Checks whether the field "SatellitesReceived" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSatellitesReceived()). Otherwise it will return false.
     */
    inline bool hasSatellitesReceived () const;

    /**
     * Returns the value of the member "SatellitesReceived".
     *
     * Total number of received satellites of all satellite systems.
     *
     * @return The value of the field "SatellitesReceived"
     */
    inline uint16 getSatellitesReceived () const;

    /**
     * Sets the value of the member "SatellitesReceived".
     *
     * Total number of received satellites of all satellite systems.
     *
     * @param SatellitesReceived The value which will be set
     */
    inline void setSatellitesReceived (uint16 SatellitesReceived_);

    // API of field "SatellitesUsed"

    static const int kSatellitesUsed = 19;

    /**
     * Clears the field "SatellitesUsed".
     *
     * The field will be set to its default value. The hasSatellitesUsed()
     * method will return false.
     */
    inline void clearSatellitesUsed();

    /**
     * Checks whether the field "SatellitesUsed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSatellitesUsed()). Otherwise it will return false.
     */
    inline bool hasSatellitesUsed () const;

    /**
     * Returns the value of the member "SatellitesUsed".
     *
     * Total number of satellites used for position calculation.
     *
     * @return The value of the field "SatellitesUsed"
     */
    inline uint16 getSatellitesUsed () const;

    /**
     * Sets the value of the member "SatellitesUsed".
     *
     * Total number of satellites used for position calculation.
     *
     * @param SatellitesUsed The value which will be set
     */
    inline void setSatellitesUsed (uint16 SatellitesUsed_);

    static const T_GnssPvtData &getDefaultInstance();

private:

    inline void set_has_UtcTimeDate ();

    inline void clear_has_UtcTimeDate ();

    inline void set_has_Latitude ();

    inline void clear_has_Latitude ();

    inline void set_has_Longitude ();

    inline void clear_has_Longitude ();

    inline void set_has_AltitudeWGS84 ();

    inline void clear_has_AltitudeWGS84 ();

    inline void set_has_GeoidalSeparation ();

    inline void clear_has_GeoidalSeparation ();

    inline void set_has_VelocityNorth ();

    inline void clear_has_VelocityNorth ();

    inline void set_has_VelocityEast ();

    inline void clear_has_VelocityEast ();

    inline void set_has_VelocityUp ();

    inline void clear_has_VelocityUp ();

    inline void set_has_PositionCovarianceMatrix ();

    inline void clear_has_PositionCovarianceMatrix ();

    inline void set_has_VelocityCovarianceMatrix ();

    inline void clear_has_VelocityCovarianceMatrix ();

    inline void set_has_GnssStatus ();

    inline void clear_has_GnssStatus ();

    inline void set_has_GDOP ();

    inline void clear_has_GDOP ();

    inline void set_has_PDOP ();

    inline void clear_has_PDOP ();

    inline void set_has_HDOP ();

    inline void clear_has_HDOP ();

    inline void set_has_TDOP ();

    inline void clear_has_TDOP ();

    inline void set_has_VDOP ();

    inline void clear_has_VDOP ();

    inline void set_has_SatSysUsed ();

    inline void clear_has_SatSysUsed ();

    inline void set_has_SatellitesVisible ();

    inline void clear_has_SatellitesVisible ();

    inline void set_has_SatellitesReceived ();

    inline void clear_has_SatellitesReceived ();

    inline void set_has_SatellitesUsed ();

    inline void clear_has_SatellitesUsed ();

    uint32 _has_bits_[ (20 + 31) / 32];

    T_TimeDate _UtcTimeDate;

    double _Latitude;

    double _Longitude;

    float _AltitudeWGS84;

    float _GeoidalSeparation;

    float _VelocityNorth;

    float _VelocityEast;

    float _VelocityUp;

    T_CovarianceMatrixUpperTriangle _PositionCovarianceMatrix;

    T_CovarianceMatrixUpperTriangle _VelocityCovarianceMatrix;

    T_GnssStatus _GnssStatus;

    float _GDOP;

    float _PDOP;

    float _HDOP;

    float _TDOP;

    float _VDOP;

    T_b8_GnssSatSys _SatSysUsed;

    uint16 _SatellitesVisible;

    uint16 _SatellitesReceived;

    uint16 _SatellitesUsed;

};

/**
 * Structure holding the variable part of the GNSS information. Infos are per
 * satellite channel.
 */
class T_GnssChanData {
public:

    /**
     * Default constructor
     */
    inline  T_GnssChanData ();

    /**
     * Copy constructor
     */
    inline  T_GnssChanData (const T_GnssChanData &rhs);

    /**
     * All fields constructor
     */
    inline  T_GnssChanData (uint16 SvId_, const T_b8_GnssSatStatus& SatStatus_, float Azimuth_, float Elevation_, uint8 CarrierToNoiseRatio_);

    /**
     * Destructor
     */
    inline  ~T_GnssChanData();

    /**
     * Assignment operator
     */
    inline T_GnssChanData& operator = (const T_GnssChanData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_GnssChanData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_GnssChanData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_GnssChanData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_GnssChanData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SvId"

    static const int kSvId = 0;

    /**
     * Clears the field "SvId".
     *
     * The field will be set to its default value. The hasSvId()
     * method will return false.
     */
    inline void clearSvId();

    /**
     * Checks whether the field "SvId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSvId()). Otherwise it will return false.
     */
    inline bool hasSvId () const;

    /**
     * Returns the value of the member "SvId".
     *
     * <p>Space vehicle ID (SVId). Each satellite system has a reserved ID range:</p>
     * GPS: [0..99]
     * GLONASS: [100..199]
     * GALILEO:[200..299]
     * COMPASS: [300..399]
     * SBAS: [400..499]
     * QZSS: [500..599]
     *
     * @return The value of the field "SvId"
     */
    inline uint16 getSvId () const;

    /**
     * Sets the value of the member "SvId".
     *
     * <p>Space vehicle ID (SVId). Each satellite system has a reserved ID range:</p>
     * GPS: [0..99]
     * GLONASS: [100..199]
     * GALILEO:[200..299]
     * COMPASS: [300..399]
     * SBAS: [400..499]
     * QZSS: [500..599]
     *
     * @param SvId The value which will be set
     */
    inline void setSvId (uint16 SvId_);

    // API of field "SatStatus"

    static const int kSatStatus = 1;

    /**
     * Clears the field "SatStatus".
     *
     * The field will be set to its default value. The hasSatStatus()
     * method will return false.
     */
    inline void clearSatStatus();

    /**
     * Checks whether the field "SatStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSatStatus()). Otherwise it will return false.
     */
    inline bool hasSatStatus () const;

    /**
     * Returns the value of the member "SatStatus".
     *
     * Different information about the status of the satellite the channel
     * is configured to. Please take always the information from the
     * GnssConfigData about which fields of the status byte are populated
     * into account.
     *
     * @return The value of the field "SatStatus"
     */
    inline const T_b8_GnssSatStatus& getSatStatus () const;

    /**
     * Retrieves the value of the field "SatStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SatStatus".
     */
    inline T_b8_GnssSatStatus& getSatStatusMutable ();

    /**
     * Sets the value of the member "SatStatus".
     *
     * Different information about the status of the satellite the channel
     * is configured to. Please take always the information from the
     * GnssConfigData about which fields of the status byte are populated
     * into account.
     *
     * @param SatStatus The value which will be set
     */
    inline void setSatStatus (const T_b8_GnssSatStatus& SatStatus_);

    // API of field "Azimuth"

    static const int kAzimuth = 2;

    /**
     * Clears the field "Azimuth".
     *
     * The field will be set to its default value. The hasAzimuth()
     * method will return false.
     */
    inline void clearAzimuth();

    /**
     * Checks whether the field "Azimuth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAzimuth()). Otherwise it will return false.
     */
    inline bool hasAzimuth () const;

    /**
     * Returns the value of the member "Azimuth".
     *
     * Azimuth of the satellite in [ï¿½].
     *
     * @return The value of the field "Azimuth"
     */
    inline float getAzimuth () const;

    /**
     * Sets the value of the member "Azimuth".
     *
     * Azimuth of the satellite in [ï¿½].
     *
     * @param Azimuth The value which will be set
     */
    inline void setAzimuth (float Azimuth_);

    // API of field "Elevation"

    static const int kElevation = 3;

    /**
     * Clears the field "Elevation".
     *
     * The field will be set to its default value. The hasElevation()
     * method will return false.
     */
    inline void clearElevation();

    /**
     * Checks whether the field "Elevation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElevation()). Otherwise it will return false.
     */
    inline bool hasElevation () const;

    /**
     * Returns the value of the member "Elevation".
     *
     * Elevation of the satellite in [ï¿½].
     *
     * @return The value of the field "Elevation"
     */
    inline float getElevation () const;

    /**
     * Sets the value of the member "Elevation".
     *
     * Elevation of the satellite in [ï¿½].
     *
     * @param Elevation The value which will be set
     */
    inline void setElevation (float Elevation_);

    // API of field "CarrierToNoiseRatio"

    static const int kCarrierToNoiseRatio = 4;

    /**
     * Clears the field "CarrierToNoiseRatio".
     *
     * The field will be set to its default value. The hasCarrierToNoiseRatio()
     * method will return false.
     */
    inline void clearCarrierToNoiseRatio();

    /**
     * Checks whether the field "CarrierToNoiseRatio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarrierToNoiseRatio()). Otherwise it will return false.
     */
    inline bool hasCarrierToNoiseRatio () const;

    /**
     * Returns the value of the member "CarrierToNoiseRatio".
     *
     *
     *
     * @return The value of the field "CarrierToNoiseRatio"
     */
    inline uint8 getCarrierToNoiseRatio () const;

    /**
     * Sets the value of the member "CarrierToNoiseRatio".
     *
     *
     *
     * @param CarrierToNoiseRatio The value which will be set
     */
    inline void setCarrierToNoiseRatio (uint8 CarrierToNoiseRatio_);

    static const T_GnssChanData &getDefaultInstance();

private:

    inline void set_has_SvId ();

    inline void clear_has_SvId ();

    inline void set_has_SatStatus ();

    inline void clear_has_SatStatus ();

    inline void set_has_Azimuth ();

    inline void clear_has_Azimuth ();

    inline void set_has_Elevation ();

    inline void clear_has_Elevation ();

    inline void set_has_CarrierToNoiseRatio ();

    inline void clear_has_CarrierToNoiseRatio ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint16 _SvId;

    T_b8_GnssSatStatus _SatStatus;

    float _Azimuth;

    float _Elevation;

    uint8 _CarrierToNoiseRatio;

};

/**
 * Structure type holding the GNSS information.
 */
class T_GnssData {
public:

    /**
     * Default constructor
     */
    inline  T_GnssData ();

    /**
     * Copy constructor
     */
    inline  T_GnssData (const T_GnssData &rhs);

    /**
     * All fields constructor
     */
    inline  T_GnssData (uint32 Timestamp_, const T_GnssPvtData& GnssPvtData_, const ::std::vector< T_GnssChanData >& GnssChanDataList_);

    /**
     * Destructor
     */
    inline  ~T_GnssData();

    /**
     * Assignment operator
     */
    inline T_GnssData& operator = (const T_GnssData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_GnssData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_GnssData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_GnssData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_GnssData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Timestamp"

    static const int kTimestamp = 0;

    /**
     * Clears the field "Timestamp".
     *
     * The field will be set to its default value. The hasTimestamp()
     * method will return false.
     */
    inline void clearTimestamp();

    /**
     * Checks whether the field "Timestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimestamp()). Otherwise it will return false.
     */
    inline bool hasTimestamp () const;

    /**
     * Returns the value of the member "Timestamp".
     *
     * Time stamp of the GNSS sample acquired from /dev/auxclock.
     *
     * @return The value of the field "Timestamp"
     */
    inline uint32 getTimestamp () const;

    /**
     * Sets the value of the member "Timestamp".
     *
     * Time stamp of the GNSS sample acquired from /dev/auxclock.
     *
     * @param Timestamp The value which will be set
     */
    inline void setTimestamp (uint32 Timestamp_);

    // API of field "GnssPvtData"

    static const int kGnssPvtData = 1;

    /**
     * Clears the field "GnssPvtData".
     *
     * The field will be set to its default value. The hasGnssPvtData()
     * method will return false.
     */
    inline void clearGnssPvtData();

    /**
     * Checks whether the field "GnssPvtData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssPvtData()). Otherwise it will return false.
     */
    inline bool hasGnssPvtData () const;

    /**
     * Returns the value of the member "GnssPvtData".
     *
     * GNSS PVT(position, velocity and time) information.
     *
     * @return The value of the field "GnssPvtData"
     */
    inline const T_GnssPvtData& getGnssPvtData () const;

    /**
     * Retrieves the value of the field "GnssPvtData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GnssPvtData".
     */
    inline T_GnssPvtData& getGnssPvtDataMutable ();

    /**
     * Sets the value of the member "GnssPvtData".
     *
     * GNSS PVT(position, velocity and time) information.
     *
     * @param GnssPvtData The value which will be set
     */
    inline void setGnssPvtData (const T_GnssPvtData& GnssPvtData_);

    // API of field "GnssChanDataList"

    static const int kGnssChanDataList = 2;

    /**
     * Clears the field "GnssChanDataList".
     *
     * The field will be set to its default value. The hasGnssChanDataList()
     * method will return false.
     */
    inline void clearGnssChanDataList();

    /**
     * Checks whether the field "GnssChanDataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssChanDataList()). Otherwise it will return false.
     */
    inline bool hasGnssChanDataList () const;

    /**
     * Returns the value of the member "GnssChanDataList".
     *
     * Information about each channel of the GNSS receiver.
     *
     * @return The value of the field "GnssChanDataList"
     */
    inline const ::std::vector< T_GnssChanData >& getGnssChanDataList () const;

    /**
     * Retrieves the value of the field "GnssChanDataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GnssChanDataList".
     */
    inline ::std::vector< T_GnssChanData >& getGnssChanDataListMutable ();

    /**
     * Sets the value of the member "GnssChanDataList".
     *
     * Information about each channel of the GNSS receiver.
     *
     * @param GnssChanDataList The value which will be set
     */
    inline void setGnssChanDataList (const ::std::vector< T_GnssChanData >& GnssChanDataList_);

    static const T_GnssData &getDefaultInstance();

private:

    static const ::std::vector< T_GnssChanData >& getT_GnssChanDataList_DefaultInstance ();

    inline void set_has_Timestamp ();

    inline void clear_has_Timestamp ();

    inline void set_has_GnssPvtData ();

    inline void clear_has_GnssPvtData ();

    inline void set_has_GnssChanDataList ();

    inline void clear_has_GnssChanDataList ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _Timestamp;

    T_GnssPvtData _GnssPvtData;

    ::std::vector< T_GnssChanData > _GnssChanDataList;

};

/**
 * A block of all the periodically changing sensor data e.g. GNSS,
 * odometer, abs, gyro and acc data collected in one big structure. The
 * block will be updated whenever there are new GNSS data available which
 * is in general every second. If there is no GNSS data available a timeout
 * mechanism triggers sending the data block. If a sensor is not present the
 * list of that sensor will be empty.
 */
class T_AllSensorData {
public:

    /**
     * Default constructor
     */
    inline  T_AllSensorData ();

    /**
     * Copy constructor
     */
    inline  T_AllSensorData (const T_AllSensorData &rhs);

    /**
     * All fields constructor
     */
    inline  T_AllSensorData (const ::std::vector< T_GnssData >& GnssUpdate_, const ::std::vector< T_OdometerData >& OdometerUpdate_, const ::std::vector< T_AbsData >& AbsUpdate_, const ::std::vector< T_3dGyroData >& GyroUpdate_, float GyroTemperature_, const ::std::vector< T_3dAccData >& AccUpdate_, float AccTemperature_);

    /**
     * Destructor
     */
    inline  ~T_AllSensorData();

    /**
     * Assignment operator
     */
    inline T_AllSensorData& operator = (const T_AllSensorData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AllSensorData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AllSensorData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AllSensorData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AllSensorData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GnssUpdate"

    static const int kGnssUpdate = 0;

    /**
     * Clears the field "GnssUpdate".
     *
     * The field will be set to its default value. The hasGnssUpdate()
     * method will return false.
     */
    inline void clearGnssUpdate();

    /**
     * Checks whether the field "GnssUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssUpdate()). Otherwise it will return false.
     */
    inline bool hasGnssUpdate () const;

    /**
     * Returns the value of the member "GnssUpdate".
     *
     * GNSS data block
     *
     * @return The value of the field "GnssUpdate"
     */
    inline const ::std::vector< T_GnssData >& getGnssUpdate () const;

    /**
     * Retrieves the value of the field "GnssUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GnssUpdate".
     */
    inline ::std::vector< T_GnssData >& getGnssUpdateMutable ();

    /**
     * Sets the value of the member "GnssUpdate".
     *
     * GNSS data block
     *
     * @param GnssUpdate The value which will be set
     */
    inline void setGnssUpdate (const ::std::vector< T_GnssData >& GnssUpdate_);

    // API of field "OdometerUpdate"

    static const int kOdometerUpdate = 1;

    /**
     * Clears the field "OdometerUpdate".
     *
     * The field will be set to its default value. The hasOdometerUpdate()
     * method will return false.
     */
    inline void clearOdometerUpdate();

    /**
     * Checks whether the field "OdometerUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOdometerUpdate()). Otherwise it will return false.
     */
    inline bool hasOdometerUpdate () const;

    /**
     * Returns the value of the member "OdometerUpdate".
     *
     * Odometer data block.
     *
     * @return The value of the field "OdometerUpdate"
     */
    inline const ::std::vector< T_OdometerData >& getOdometerUpdate () const;

    /**
     * Retrieves the value of the field "OdometerUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OdometerUpdate".
     */
    inline ::std::vector< T_OdometerData >& getOdometerUpdateMutable ();

    /**
     * Sets the value of the member "OdometerUpdate".
     *
     * Odometer data block.
     *
     * @param OdometerUpdate The value which will be set
     */
    inline void setOdometerUpdate (const ::std::vector< T_OdometerData >& OdometerUpdate_);

    // API of field "AbsUpdate"

    static const int kAbsUpdate = 2;

    /**
     * Clears the field "AbsUpdate".
     *
     * The field will be set to its default value. The hasAbsUpdate()
     * method will return false.
     */
    inline void clearAbsUpdate();

    /**
     * Checks whether the field "AbsUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAbsUpdate()). Otherwise it will return false.
     */
    inline bool hasAbsUpdate () const;

    /**
     * Returns the value of the member "AbsUpdate".
     *
     * Abs data block.
     *
     * @return The value of the field "AbsUpdate"
     */
    inline const ::std::vector< T_AbsData >& getAbsUpdate () const;

    /**
     * Retrieves the value of the field "AbsUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AbsUpdate".
     */
    inline ::std::vector< T_AbsData >& getAbsUpdateMutable ();

    /**
     * Sets the value of the member "AbsUpdate".
     *
     * Abs data block.
     *
     * @param AbsUpdate The value which will be set
     */
    inline void setAbsUpdate (const ::std::vector< T_AbsData >& AbsUpdate_);

    // API of field "GyroUpdate"

    static const int kGyroUpdate = 3;

    /**
     * Clears the field "GyroUpdate".
     *
     * The field will be set to its default value. The hasGyroUpdate()
     * method will return false.
     */
    inline void clearGyroUpdate();

    /**
     * Checks whether the field "GyroUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGyroUpdate()). Otherwise it will return false.
     */
    inline bool hasGyroUpdate () const;

    /**
     * Returns the value of the member "GyroUpdate".
     *
     * Gyro data block.
     *
     * @return The value of the field "GyroUpdate"
     */
    inline const ::std::vector< T_3dGyroData >& getGyroUpdate () const;

    /**
     * Retrieves the value of the field "GyroUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GyroUpdate".
     */
    inline ::std::vector< T_3dGyroData >& getGyroUpdateMutable ();

    /**
     * Sets the value of the member "GyroUpdate".
     *
     * Gyro data block.
     *
     * @param GyroUpdate The value which will be set
     */
    inline void setGyroUpdate (const ::std::vector< T_3dGyroData >& GyroUpdate_);

    // API of field "GyroTemperature"

    static const int kGyroTemperature = 4;

    /**
     * Clears the field "GyroTemperature".
     *
     * The field will be set to its default value. The hasGyroTemperature()
     * method will return false.
     */
    inline void clearGyroTemperature();

    /**
     * Checks whether the field "GyroTemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGyroTemperature()). Otherwise it will return false.
     */
    inline bool hasGyroTemperature () const;

    /**
     * Returns the value of the member "GyroTemperature".
     *
     * Gyro temperature in [K].
     *
     * @return The value of the field "GyroTemperature"
     */
    inline float getGyroTemperature () const;

    /**
     * Sets the value of the member "GyroTemperature".
     *
     * Gyro temperature in [K].
     *
     * @param GyroTemperature The value which will be set
     */
    inline void setGyroTemperature (float GyroTemperature_);

    // API of field "AccUpdate"

    static const int kAccUpdate = 5;

    /**
     * Clears the field "AccUpdate".
     *
     * The field will be set to its default value. The hasAccUpdate()
     * method will return false.
     */
    inline void clearAccUpdate();

    /**
     * Checks whether the field "AccUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccUpdate()). Otherwise it will return false.
     */
    inline bool hasAccUpdate () const;

    /**
     * Returns the value of the member "AccUpdate".
     *
     * Acc data block.
     *
     * @return The value of the field "AccUpdate"
     */
    inline const ::std::vector< T_3dAccData >& getAccUpdate () const;

    /**
     * Retrieves the value of the field "AccUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AccUpdate".
     */
    inline ::std::vector< T_3dAccData >& getAccUpdateMutable ();

    /**
     * Sets the value of the member "AccUpdate".
     *
     * Acc data block.
     *
     * @param AccUpdate The value which will be set
     */
    inline void setAccUpdate (const ::std::vector< T_3dAccData >& AccUpdate_);

    // API of field "AccTemperature"

    static const int kAccTemperature = 6;

    /**
     * Clears the field "AccTemperature".
     *
     * The field will be set to its default value. The hasAccTemperature()
     * method will return false.
     */
    inline void clearAccTemperature();

    /**
     * Checks whether the field "AccTemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccTemperature()). Otherwise it will return false.
     */
    inline bool hasAccTemperature () const;

    /**
     * Returns the value of the member "AccTemperature".
     *
     * Acc temperature in [K].
     *
     * @return The value of the field "AccTemperature"
     */
    inline float getAccTemperature () const;

    /**
     * Sets the value of the member "AccTemperature".
     *
     * Acc temperature in [K].
     *
     * @param AccTemperature The value which will be set
     */
    inline void setAccTemperature (float AccTemperature_);

    static const T_AllSensorData &getDefaultInstance();

private:

    static const ::std::vector< T_GnssData >& getT_GnssDataList_DefaultInstance ();

    static const ::std::vector< T_OdometerData >& getT_OdometerDataList_DefaultInstance ();

    static const ::std::vector< T_AbsData >& getT_AbsDataList_DefaultInstance ();

    static const ::std::vector< T_3dGyroData >& getT_3dGyroDataList_DefaultInstance ();

    static const ::std::vector< T_3dAccData >& getT_3dAccDataList_DefaultInstance ();

    inline void set_has_GnssUpdate ();

    inline void clear_has_GnssUpdate ();

    inline void set_has_OdometerUpdate ();

    inline void clear_has_OdometerUpdate ();

    inline void set_has_AbsUpdate ();

    inline void clear_has_AbsUpdate ();

    inline void set_has_GyroUpdate ();

    inline void clear_has_GyroUpdate ();

    inline void set_has_GyroTemperature ();

    inline void clear_has_GyroTemperature ();

    inline void set_has_AccUpdate ();

    inline void clear_has_AccUpdate ();

    inline void set_has_AccTemperature ();

    inline void clear_has_AccTemperature ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::std::vector< T_GnssData > _GnssUpdate;

    ::std::vector< T_OdometerData > _OdometerUpdate;

    ::std::vector< T_AbsData > _AbsUpdate;

    ::std::vector< T_3dGyroData > _GyroUpdate;

    float _GyroTemperature;

    ::std::vector< T_3dAccData > _AccUpdate;

    float _AccTemperature;

};

inline  T_VdsVersionInfo::T_VdsVersionInfo ()  :
    _vdsVersion (),
    _boardVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_VdsVersionInfo::T_VdsVersionInfo (const T_VdsVersionInfo &rhs)  :
    _vdsVersion (),
    _boardVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_VdsVersionInfo::T_VdsVersionInfo (const ::std::string& vdsVersion_, const ::std::string& boardVersion_)  :
    _vdsVersion (vdsVersion_),
    _boardVersion (boardVersion_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (vdsVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (boardVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_VdsVersionInfo::~T_VdsVersionInfo() {
}

inline T_VdsVersionInfo& T_VdsVersionInfo::operator = (const T_VdsVersionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasVdsVersion()) {
            setVdsVersion(rhs.getVdsVersion());
        } else {
            clearVdsVersion();
        }
        if (rhs.hasBoardVersion()) {
            setBoardVersion(rhs.getBoardVersion());
        } else {
            clearBoardVersion();
        }
    }
    return *this;
}

inline bool T_VdsVersionInfo::operator == (const T_VdsVersionInfo& rhs) const {
    return (((!hasVdsVersion() && !rhs.hasVdsVersion()) || getVdsVersion() == rhs.getVdsVersion()) &&
        ((!hasBoardVersion() && !rhs.hasBoardVersion()) || getBoardVersion() == rhs.getBoardVersion()));
}

inline bool T_VdsVersionInfo::operator != (const T_VdsVersionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_VdsVersionInfo::operator < (const T_VdsVersionInfo& rhs) const {
    if (hasVdsVersion() || rhs.hasVdsVersion()) {
        if (getVdsVersion() < rhs.getVdsVersion()) return true;
        if (getVdsVersion() > rhs.getVdsVersion()) return false;
    }
    if (hasBoardVersion() || rhs.hasBoardVersion()) {
        if (getBoardVersion() < rhs.getBoardVersion()) return true;
        if (getBoardVersion() > rhs.getBoardVersion()) return false;
    }
    return false;
}

inline bool T_VdsVersionInfo::operator > (const T_VdsVersionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_VdsVersionInfo::clear() {
    clearVdsVersion();
    clearBoardVersion();
}

inline void T_VdsVersionInfo::clearVdsVersion() {
    if (hasVdsVersion()) {
         clear_has_vdsVersion();
        _vdsVersion.clear();
     }
}

inline bool T_VdsVersionInfo::hasVdsVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_VdsVersionInfo::getVdsVersion () const {
    return _vdsVersion;
}

inline ::std::string& T_VdsVersionInfo::getVdsVersionMutable () {
    set_has_vdsVersion();
    return _vdsVersion;
}

inline void T_VdsVersionInfo::setVdsVersion (const ::std::string& vdsVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (vdsVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_vdsVersion();
    this->_vdsVersion = vdsVersion_;
}

inline void T_VdsVersionInfo::setVdsVersion (const char* vdsVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (vdsVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_vdsVersion();
    this->_vdsVersion.assign(vdsVersion_);
}

inline void T_VdsVersionInfo::setVdsVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_vdsVersion();
    this->_vdsVersion.assign(value, size);
}

inline void T_VdsVersionInfo::clearBoardVersion() {
    if (hasBoardVersion()) {
         clear_has_boardVersion();
        _boardVersion.clear();
     }
}

inline bool T_VdsVersionInfo::hasBoardVersion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_VdsVersionInfo::getBoardVersion () const {
    return _boardVersion;
}

inline ::std::string& T_VdsVersionInfo::getBoardVersionMutable () {
    set_has_boardVersion();
    return _boardVersion;
}

inline void T_VdsVersionInfo::setBoardVersion (const ::std::string& boardVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (boardVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_boardVersion();
    this->_boardVersion = boardVersion_;
}

inline void T_VdsVersionInfo::setBoardVersion (const char* boardVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (boardVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_boardVersion();
    this->_boardVersion.assign(boardVersion_);
}

inline void T_VdsVersionInfo::setBoardVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_boardVersion();
    this->_boardVersion.assign(value, size);
}

inline void T_VdsVersionInfo::set_has_vdsVersion () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_VdsVersionInfo::clear_has_vdsVersion () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_VdsVersionInfo::set_has_boardVersion () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_VdsVersionInfo::clear_has_boardVersion () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_OdometerData::T_OdometerData ()  :
    _Timestamp (0u),
    _OdometerCount (0u),
    _OdometerStatus (::location_fi_types::T_e8_OdometerStatus__ODOMSTATE_CONNECTED_NORMAL),
    _OdometerCount_Direction (::location_fi_types::T_e8_OdometerDirection__ODOMDIR_UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_OdometerData::T_OdometerData (const T_OdometerData &rhs)  :
    _Timestamp (0u),
    _OdometerCount (0u),
    _OdometerStatus (::location_fi_types::T_e8_OdometerStatus__ODOMSTATE_CONNECTED_NORMAL),
    _OdometerCount_Direction (::location_fi_types::T_e8_OdometerDirection__ODOMDIR_UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_OdometerData::T_OdometerData (uint32 Timestamp_, uint16 OdometerCount_, T_e8_OdometerStatus OdometerStatus_, T_e8_OdometerDirection OdometerCount_Direction_)  :
    _Timestamp (Timestamp_),
    _OdometerCount (OdometerCount_),
    _OdometerStatus (OdometerStatus_),
    _OdometerCount_Direction (OdometerCount_Direction_)
{
    #ifndef NDEBUG
    if (!(T_e8_OdometerStatus_IsValid(OdometerStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", OdometerStatus_, "T_e8_OdometerStatus", "OdometerStatus", "T_OdometerData");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_OdometerDirection_IsValid(OdometerCount_Direction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", OdometerCount_Direction_, "T_e8_OdometerDirection", "OdometerCount_Direction", "T_OdometerData");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_OdometerData::~T_OdometerData() {
}

inline T_OdometerData& T_OdometerData::operator = (const T_OdometerData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTimestamp()) {
            setTimestamp(rhs.getTimestamp());
        } else {
            clearTimestamp();
        }
        if (rhs.hasOdometerCount()) {
            setOdometerCount(rhs.getOdometerCount());
        } else {
            clearOdometerCount();
        }
        if (rhs.hasOdometerStatus()) {
            setOdometerStatus(rhs.getOdometerStatus());
        } else {
            clearOdometerStatus();
        }
        if (rhs.hasOdometerCount_Direction()) {
            setOdometerCount_Direction(rhs.getOdometerCount_Direction());
        } else {
            clearOdometerCount_Direction();
        }
    }
    return *this;
}

inline bool T_OdometerData::operator == (const T_OdometerData& rhs) const {
    return (((!hasTimestamp() && !rhs.hasTimestamp()) || getTimestamp() == rhs.getTimestamp()) &&
        ((!hasOdometerCount() && !rhs.hasOdometerCount()) || getOdometerCount() == rhs.getOdometerCount()) &&
        ((!hasOdometerStatus() && !rhs.hasOdometerStatus()) || getOdometerStatus() == rhs.getOdometerStatus()) &&
        ((!hasOdometerCount_Direction() && !rhs.hasOdometerCount_Direction()) || getOdometerCount_Direction() == rhs.getOdometerCount_Direction()));
}

inline bool T_OdometerData::operator != (const T_OdometerData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_OdometerData::operator < (const T_OdometerData& rhs) const {
    if (hasTimestamp() || rhs.hasTimestamp()) {
        if (getTimestamp() < rhs.getTimestamp()) return true;
        if (getTimestamp() > rhs.getTimestamp()) return false;
    }
    if (hasOdometerCount() || rhs.hasOdometerCount()) {
        if (getOdometerCount() < rhs.getOdometerCount()) return true;
        if (getOdometerCount() > rhs.getOdometerCount()) return false;
    }
    if (hasOdometerStatus() || rhs.hasOdometerStatus()) {
        if ((uint32)getOdometerStatus() < (uint32)rhs.getOdometerStatus()) return true;
        if ((uint32)getOdometerStatus() > (uint32)rhs.getOdometerStatus()) return false;
    }
    if (hasOdometerCount_Direction() || rhs.hasOdometerCount_Direction()) {
        if ((uint32)getOdometerCount_Direction() < (uint32)rhs.getOdometerCount_Direction()) return true;
        if ((uint32)getOdometerCount_Direction() > (uint32)rhs.getOdometerCount_Direction()) return false;
    }
    return false;
}

inline bool T_OdometerData::operator > (const T_OdometerData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_OdometerData::clear() {
    clearTimestamp();
    clearOdometerCount();
    clearOdometerStatus();
    clearOdometerCount_Direction();
}

inline void T_OdometerData::clearTimestamp() {
    if (hasTimestamp()) {
         clear_has_Timestamp();
        _Timestamp = 0u;
     }
}

inline bool T_OdometerData::hasTimestamp () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_OdometerData::getTimestamp () const {
    return _Timestamp;
}

inline void T_OdometerData::setTimestamp (uint32 Timestamp_) {
    set_has_Timestamp();
    this->_Timestamp = Timestamp_;
}

inline void T_OdometerData::clearOdometerCount() {
    if (hasOdometerCount()) {
         clear_has_OdometerCount();
        _OdometerCount = 0u;
     }
}

inline bool T_OdometerData::hasOdometerCount () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_OdometerData::getOdometerCount () const {
    return _OdometerCount;
}

inline void T_OdometerData::setOdometerCount (uint16 OdometerCount_) {
    set_has_OdometerCount();
    this->_OdometerCount = OdometerCount_;
}

inline void T_OdometerData::clearOdometerStatus() {
    if (hasOdometerStatus()) {
         clear_has_OdometerStatus();
        _OdometerStatus = ::location_fi_types::T_e8_OdometerStatus__ODOMSTATE_CONNECTED_NORMAL;
     }
}

inline bool T_OdometerData::hasOdometerStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_OdometerStatus T_OdometerData::getOdometerStatus () const {
    return _OdometerStatus;
}

inline void T_OdometerData::setOdometerStatus (T_e8_OdometerStatus OdometerStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_OdometerStatus_IsValid(OdometerStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", OdometerStatus_, "T_e8_OdometerStatus", "OdometerStatus", "T_OdometerData");
    }
    #endif
    set_has_OdometerStatus();
    this->_OdometerStatus = OdometerStatus_;
}

inline void T_OdometerData::clearOdometerCount_Direction() {
    if (hasOdometerCount_Direction()) {
         clear_has_OdometerCount_Direction();
        _OdometerCount_Direction = ::location_fi_types::T_e8_OdometerDirection__ODOMDIR_UNKNOWN;
     }
}

inline bool T_OdometerData::hasOdometerCount_Direction () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_OdometerDirection T_OdometerData::getOdometerCount_Direction () const {
    return _OdometerCount_Direction;
}

inline void T_OdometerData::setOdometerCount_Direction (T_e8_OdometerDirection OdometerCount_Direction_) {
    #ifndef NDEBUG
    if (!(T_e8_OdometerDirection_IsValid(OdometerCount_Direction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", OdometerCount_Direction_, "T_e8_OdometerDirection", "OdometerCount_Direction", "T_OdometerData");
    }
    #endif
    set_has_OdometerCount_Direction();
    this->_OdometerCount_Direction = OdometerCount_Direction_;
}

inline void T_OdometerData::set_has_Timestamp () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_OdometerData::clear_has_Timestamp () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_OdometerData::set_has_OdometerCount () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_OdometerData::clear_has_OdometerCount () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_OdometerData::set_has_OdometerStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_OdometerData::clear_has_OdometerStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_OdometerData::set_has_OdometerCount_Direction () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_OdometerData::clear_has_OdometerCount_Direction () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_AbsData::T_AbsData ()  :
    _AbsTimeStamp (0u),
    _WheelCounterFrontLeft (0u),
    _WheelCounterFrontRight (0u),
    _WheelCounterRearLeft (0u),
    _WheelCounterRearRight (0u),
    _StatusFrontLeft (::location_fi_types::T_e8_AbsStatus__ABS_STATUS_NORMAL),
    _StatusFrontRight (::location_fi_types::T_e8_AbsStatus__ABS_STATUS_NORMAL),
    _StatusRearLeft (::location_fi_types::T_e8_AbsStatus__ABS_STATUS_NORMAL),
    _StatusRearRight (::location_fi_types::T_e8_AbsStatus__ABS_STATUS_NORMAL),
    _DirectionFrontLeft (::location_fi_types::T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN),
    _DirectionFrontRight (::location_fi_types::T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN),
    _DirectionRearLeft (::location_fi_types::T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN),
    _DirectionRearRight (::location_fi_types::T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AbsData::T_AbsData (const T_AbsData &rhs)  :
    _AbsTimeStamp (0u),
    _WheelCounterFrontLeft (0u),
    _WheelCounterFrontRight (0u),
    _WheelCounterRearLeft (0u),
    _WheelCounterRearRight (0u),
    _StatusFrontLeft (::location_fi_types::T_e8_AbsStatus__ABS_STATUS_NORMAL),
    _StatusFrontRight (::location_fi_types::T_e8_AbsStatus__ABS_STATUS_NORMAL),
    _StatusRearLeft (::location_fi_types::T_e8_AbsStatus__ABS_STATUS_NORMAL),
    _StatusRearRight (::location_fi_types::T_e8_AbsStatus__ABS_STATUS_NORMAL),
    _DirectionFrontLeft (::location_fi_types::T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN),
    _DirectionFrontRight (::location_fi_types::T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN),
    _DirectionRearLeft (::location_fi_types::T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN),
    _DirectionRearRight (::location_fi_types::T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AbsData::T_AbsData (uint32 AbsTimeStamp_, uint16 WheelCounterFrontLeft_, uint16 WheelCounterFrontRight_, uint16 WheelCounterRearLeft_, uint16 WheelCounterRearRight_, T_e8_AbsStatus StatusFrontLeft_, T_e8_AbsStatus StatusFrontRight_, T_e8_AbsStatus StatusRearLeft_, T_e8_AbsStatus StatusRearRight_, T_e8_AbsDirection DirectionFrontLeft_, T_e8_AbsDirection DirectionFrontRight_, T_e8_AbsDirection DirectionRearLeft_, T_e8_AbsDirection DirectionRearRight_)  :
    _AbsTimeStamp (AbsTimeStamp_),
    _WheelCounterFrontLeft (WheelCounterFrontLeft_),
    _WheelCounterFrontRight (WheelCounterFrontRight_),
    _WheelCounterRearLeft (WheelCounterRearLeft_),
    _WheelCounterRearRight (WheelCounterRearRight_),
    _StatusFrontLeft (StatusFrontLeft_),
    _StatusFrontRight (StatusFrontRight_),
    _StatusRearLeft (StatusRearLeft_),
    _StatusRearRight (StatusRearRight_),
    _DirectionFrontLeft (DirectionFrontLeft_),
    _DirectionFrontRight (DirectionFrontRight_),
    _DirectionRearLeft (DirectionRearLeft_),
    _DirectionRearRight (DirectionRearRight_)
{
    #ifndef NDEBUG
    if (!(T_e8_AbsStatus_IsValid(StatusFrontLeft_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusFrontLeft_, "T_e8_AbsStatus", "StatusFrontLeft", "T_AbsData");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AbsStatus_IsValid(StatusFrontRight_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusFrontRight_, "T_e8_AbsStatus", "StatusFrontRight", "T_AbsData");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AbsStatus_IsValid(StatusRearLeft_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusRearLeft_, "T_e8_AbsStatus", "StatusRearLeft", "T_AbsData");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AbsStatus_IsValid(StatusRearRight_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusRearRight_, "T_e8_AbsStatus", "StatusRearRight", "T_AbsData");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AbsDirection_IsValid(DirectionFrontLeft_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DirectionFrontLeft_, "T_e8_AbsDirection", "DirectionFrontLeft", "T_AbsData");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AbsDirection_IsValid(DirectionFrontRight_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DirectionFrontRight_, "T_e8_AbsDirection", "DirectionFrontRight", "T_AbsData");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AbsDirection_IsValid(DirectionRearLeft_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DirectionRearLeft_, "T_e8_AbsDirection", "DirectionRearLeft", "T_AbsData");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AbsDirection_IsValid(DirectionRearRight_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DirectionRearRight_, "T_e8_AbsDirection", "DirectionRearRight", "T_AbsData");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AbsData::~T_AbsData() {
}

inline T_AbsData& T_AbsData::operator = (const T_AbsData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAbsTimeStamp()) {
            setAbsTimeStamp(rhs.getAbsTimeStamp());
        } else {
            clearAbsTimeStamp();
        }
        if (rhs.hasWheelCounterFrontLeft()) {
            setWheelCounterFrontLeft(rhs.getWheelCounterFrontLeft());
        } else {
            clearWheelCounterFrontLeft();
        }
        if (rhs.hasWheelCounterFrontRight()) {
            setWheelCounterFrontRight(rhs.getWheelCounterFrontRight());
        } else {
            clearWheelCounterFrontRight();
        }
        if (rhs.hasWheelCounterRearLeft()) {
            setWheelCounterRearLeft(rhs.getWheelCounterRearLeft());
        } else {
            clearWheelCounterRearLeft();
        }
        if (rhs.hasWheelCounterRearRight()) {
            setWheelCounterRearRight(rhs.getWheelCounterRearRight());
        } else {
            clearWheelCounterRearRight();
        }
        if (rhs.hasStatusFrontLeft()) {
            setStatusFrontLeft(rhs.getStatusFrontLeft());
        } else {
            clearStatusFrontLeft();
        }
        if (rhs.hasStatusFrontRight()) {
            setStatusFrontRight(rhs.getStatusFrontRight());
        } else {
            clearStatusFrontRight();
        }
        if (rhs.hasStatusRearLeft()) {
            setStatusRearLeft(rhs.getStatusRearLeft());
        } else {
            clearStatusRearLeft();
        }
        if (rhs.hasStatusRearRight()) {
            setStatusRearRight(rhs.getStatusRearRight());
        } else {
            clearStatusRearRight();
        }
        if (rhs.hasDirectionFrontLeft()) {
            setDirectionFrontLeft(rhs.getDirectionFrontLeft());
        } else {
            clearDirectionFrontLeft();
        }
        if (rhs.hasDirectionFrontRight()) {
            setDirectionFrontRight(rhs.getDirectionFrontRight());
        } else {
            clearDirectionFrontRight();
        }
        if (rhs.hasDirectionRearLeft()) {
            setDirectionRearLeft(rhs.getDirectionRearLeft());
        } else {
            clearDirectionRearLeft();
        }
        if (rhs.hasDirectionRearRight()) {
            setDirectionRearRight(rhs.getDirectionRearRight());
        } else {
            clearDirectionRearRight();
        }
    }
    return *this;
}

inline bool T_AbsData::operator == (const T_AbsData& rhs) const {
    return (((!hasAbsTimeStamp() && !rhs.hasAbsTimeStamp()) || getAbsTimeStamp() == rhs.getAbsTimeStamp()) &&
        ((!hasWheelCounterFrontLeft() && !rhs.hasWheelCounterFrontLeft()) || getWheelCounterFrontLeft() == rhs.getWheelCounterFrontLeft()) &&
        ((!hasWheelCounterFrontRight() && !rhs.hasWheelCounterFrontRight()) || getWheelCounterFrontRight() == rhs.getWheelCounterFrontRight()) &&
        ((!hasWheelCounterRearLeft() && !rhs.hasWheelCounterRearLeft()) || getWheelCounterRearLeft() == rhs.getWheelCounterRearLeft()) &&
        ((!hasWheelCounterRearRight() && !rhs.hasWheelCounterRearRight()) || getWheelCounterRearRight() == rhs.getWheelCounterRearRight()) &&
        ((!hasStatusFrontLeft() && !rhs.hasStatusFrontLeft()) || getStatusFrontLeft() == rhs.getStatusFrontLeft()) &&
        ((!hasStatusFrontRight() && !rhs.hasStatusFrontRight()) || getStatusFrontRight() == rhs.getStatusFrontRight()) &&
        ((!hasStatusRearLeft() && !rhs.hasStatusRearLeft()) || getStatusRearLeft() == rhs.getStatusRearLeft()) &&
        ((!hasStatusRearRight() && !rhs.hasStatusRearRight()) || getStatusRearRight() == rhs.getStatusRearRight()) &&
        ((!hasDirectionFrontLeft() && !rhs.hasDirectionFrontLeft()) || getDirectionFrontLeft() == rhs.getDirectionFrontLeft()) &&
        ((!hasDirectionFrontRight() && !rhs.hasDirectionFrontRight()) || getDirectionFrontRight() == rhs.getDirectionFrontRight()) &&
        ((!hasDirectionRearLeft() && !rhs.hasDirectionRearLeft()) || getDirectionRearLeft() == rhs.getDirectionRearLeft()) &&
        ((!hasDirectionRearRight() && !rhs.hasDirectionRearRight()) || getDirectionRearRight() == rhs.getDirectionRearRight()));
}

inline bool T_AbsData::operator != (const T_AbsData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AbsData::operator < (const T_AbsData& rhs) const {
    if (hasAbsTimeStamp() || rhs.hasAbsTimeStamp()) {
        if (getAbsTimeStamp() < rhs.getAbsTimeStamp()) return true;
        if (getAbsTimeStamp() > rhs.getAbsTimeStamp()) return false;
    }
    if (hasWheelCounterFrontLeft() || rhs.hasWheelCounterFrontLeft()) {
        if (getWheelCounterFrontLeft() < rhs.getWheelCounterFrontLeft()) return true;
        if (getWheelCounterFrontLeft() > rhs.getWheelCounterFrontLeft()) return false;
    }
    if (hasWheelCounterFrontRight() || rhs.hasWheelCounterFrontRight()) {
        if (getWheelCounterFrontRight() < rhs.getWheelCounterFrontRight()) return true;
        if (getWheelCounterFrontRight() > rhs.getWheelCounterFrontRight()) return false;
    }
    if (hasWheelCounterRearLeft() || rhs.hasWheelCounterRearLeft()) {
        if (getWheelCounterRearLeft() < rhs.getWheelCounterRearLeft()) return true;
        if (getWheelCounterRearLeft() > rhs.getWheelCounterRearLeft()) return false;
    }
    if (hasWheelCounterRearRight() || rhs.hasWheelCounterRearRight()) {
        if (getWheelCounterRearRight() < rhs.getWheelCounterRearRight()) return true;
        if (getWheelCounterRearRight() > rhs.getWheelCounterRearRight()) return false;
    }
    if (hasStatusFrontLeft() || rhs.hasStatusFrontLeft()) {
        if ((uint32)getStatusFrontLeft() < (uint32)rhs.getStatusFrontLeft()) return true;
        if ((uint32)getStatusFrontLeft() > (uint32)rhs.getStatusFrontLeft()) return false;
    }
    if (hasStatusFrontRight() || rhs.hasStatusFrontRight()) {
        if ((uint32)getStatusFrontRight() < (uint32)rhs.getStatusFrontRight()) return true;
        if ((uint32)getStatusFrontRight() > (uint32)rhs.getStatusFrontRight()) return false;
    }
    if (hasStatusRearLeft() || rhs.hasStatusRearLeft()) {
        if ((uint32)getStatusRearLeft() < (uint32)rhs.getStatusRearLeft()) return true;
        if ((uint32)getStatusRearLeft() > (uint32)rhs.getStatusRearLeft()) return false;
    }
    if (hasStatusRearRight() || rhs.hasStatusRearRight()) {
        if ((uint32)getStatusRearRight() < (uint32)rhs.getStatusRearRight()) return true;
        if ((uint32)getStatusRearRight() > (uint32)rhs.getStatusRearRight()) return false;
    }
    if (hasDirectionFrontLeft() || rhs.hasDirectionFrontLeft()) {
        if ((uint32)getDirectionFrontLeft() < (uint32)rhs.getDirectionFrontLeft()) return true;
        if ((uint32)getDirectionFrontLeft() > (uint32)rhs.getDirectionFrontLeft()) return false;
    }
    if (hasDirectionFrontRight() || rhs.hasDirectionFrontRight()) {
        if ((uint32)getDirectionFrontRight() < (uint32)rhs.getDirectionFrontRight()) return true;
        if ((uint32)getDirectionFrontRight() > (uint32)rhs.getDirectionFrontRight()) return false;
    }
    if (hasDirectionRearLeft() || rhs.hasDirectionRearLeft()) {
        if ((uint32)getDirectionRearLeft() < (uint32)rhs.getDirectionRearLeft()) return true;
        if ((uint32)getDirectionRearLeft() > (uint32)rhs.getDirectionRearLeft()) return false;
    }
    if (hasDirectionRearRight() || rhs.hasDirectionRearRight()) {
        if ((uint32)getDirectionRearRight() < (uint32)rhs.getDirectionRearRight()) return true;
        if ((uint32)getDirectionRearRight() > (uint32)rhs.getDirectionRearRight()) return false;
    }
    return false;
}

inline bool T_AbsData::operator > (const T_AbsData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AbsData::clear() {
    clearAbsTimeStamp();
    clearWheelCounterFrontLeft();
    clearWheelCounterFrontRight();
    clearWheelCounterRearLeft();
    clearWheelCounterRearRight();
    clearStatusFrontLeft();
    clearStatusFrontRight();
    clearStatusRearLeft();
    clearStatusRearRight();
    clearDirectionFrontLeft();
    clearDirectionFrontRight();
    clearDirectionRearLeft();
    clearDirectionRearRight();
}

inline void T_AbsData::clearAbsTimeStamp() {
    if (hasAbsTimeStamp()) {
         clear_has_AbsTimeStamp();
        _AbsTimeStamp = 0u;
     }
}

inline bool T_AbsData::hasAbsTimeStamp () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_AbsData::getAbsTimeStamp () const {
    return _AbsTimeStamp;
}

inline void T_AbsData::setAbsTimeStamp (uint32 AbsTimeStamp_) {
    set_has_AbsTimeStamp();
    this->_AbsTimeStamp = AbsTimeStamp_;
}

inline void T_AbsData::clearWheelCounterFrontLeft() {
    if (hasWheelCounterFrontLeft()) {
         clear_has_WheelCounterFrontLeft();
        _WheelCounterFrontLeft = 0u;
     }
}

inline bool T_AbsData::hasWheelCounterFrontLeft () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_AbsData::getWheelCounterFrontLeft () const {
    return _WheelCounterFrontLeft;
}

inline void T_AbsData::setWheelCounterFrontLeft (uint16 WheelCounterFrontLeft_) {
    set_has_WheelCounterFrontLeft();
    this->_WheelCounterFrontLeft = WheelCounterFrontLeft_;
}

inline void T_AbsData::clearWheelCounterFrontRight() {
    if (hasWheelCounterFrontRight()) {
         clear_has_WheelCounterFrontRight();
        _WheelCounterFrontRight = 0u;
     }
}

inline bool T_AbsData::hasWheelCounterFrontRight () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_AbsData::getWheelCounterFrontRight () const {
    return _WheelCounterFrontRight;
}

inline void T_AbsData::setWheelCounterFrontRight (uint16 WheelCounterFrontRight_) {
    set_has_WheelCounterFrontRight();
    this->_WheelCounterFrontRight = WheelCounterFrontRight_;
}

inline void T_AbsData::clearWheelCounterRearLeft() {
    if (hasWheelCounterRearLeft()) {
         clear_has_WheelCounterRearLeft();
        _WheelCounterRearLeft = 0u;
     }
}

inline bool T_AbsData::hasWheelCounterRearLeft () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_AbsData::getWheelCounterRearLeft () const {
    return _WheelCounterRearLeft;
}

inline void T_AbsData::setWheelCounterRearLeft (uint16 WheelCounterRearLeft_) {
    set_has_WheelCounterRearLeft();
    this->_WheelCounterRearLeft = WheelCounterRearLeft_;
}

inline void T_AbsData::clearWheelCounterRearRight() {
    if (hasWheelCounterRearRight()) {
         clear_has_WheelCounterRearRight();
        _WheelCounterRearRight = 0u;
     }
}

inline bool T_AbsData::hasWheelCounterRearRight () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 T_AbsData::getWheelCounterRearRight () const {
    return _WheelCounterRearRight;
}

inline void T_AbsData::setWheelCounterRearRight (uint16 WheelCounterRearRight_) {
    set_has_WheelCounterRearRight();
    this->_WheelCounterRearRight = WheelCounterRearRight_;
}

inline void T_AbsData::clearStatusFrontLeft() {
    if (hasStatusFrontLeft()) {
         clear_has_StatusFrontLeft();
        _StatusFrontLeft = ::location_fi_types::T_e8_AbsStatus__ABS_STATUS_NORMAL;
     }
}

inline bool T_AbsData::hasStatusFrontLeft () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_AbsStatus T_AbsData::getStatusFrontLeft () const {
    return _StatusFrontLeft;
}

inline void T_AbsData::setStatusFrontLeft (T_e8_AbsStatus StatusFrontLeft_) {
    #ifndef NDEBUG
    if (!(T_e8_AbsStatus_IsValid(StatusFrontLeft_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusFrontLeft_, "T_e8_AbsStatus", "StatusFrontLeft", "T_AbsData");
    }
    #endif
    set_has_StatusFrontLeft();
    this->_StatusFrontLeft = StatusFrontLeft_;
}

inline void T_AbsData::clearStatusFrontRight() {
    if (hasStatusFrontRight()) {
         clear_has_StatusFrontRight();
        _StatusFrontRight = ::location_fi_types::T_e8_AbsStatus__ABS_STATUS_NORMAL;
     }
}

inline bool T_AbsData::hasStatusFrontRight () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_AbsStatus T_AbsData::getStatusFrontRight () const {
    return _StatusFrontRight;
}

inline void T_AbsData::setStatusFrontRight (T_e8_AbsStatus StatusFrontRight_) {
    #ifndef NDEBUG
    if (!(T_e8_AbsStatus_IsValid(StatusFrontRight_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusFrontRight_, "T_e8_AbsStatus", "StatusFrontRight", "T_AbsData");
    }
    #endif
    set_has_StatusFrontRight();
    this->_StatusFrontRight = StatusFrontRight_;
}

inline void T_AbsData::clearStatusRearLeft() {
    if (hasStatusRearLeft()) {
         clear_has_StatusRearLeft();
        _StatusRearLeft = ::location_fi_types::T_e8_AbsStatus__ABS_STATUS_NORMAL;
     }
}

inline bool T_AbsData::hasStatusRearLeft () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline T_e8_AbsStatus T_AbsData::getStatusRearLeft () const {
    return _StatusRearLeft;
}

inline void T_AbsData::setStatusRearLeft (T_e8_AbsStatus StatusRearLeft_) {
    #ifndef NDEBUG
    if (!(T_e8_AbsStatus_IsValid(StatusRearLeft_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusRearLeft_, "T_e8_AbsStatus", "StatusRearLeft", "T_AbsData");
    }
    #endif
    set_has_StatusRearLeft();
    this->_StatusRearLeft = StatusRearLeft_;
}

inline void T_AbsData::clearStatusRearRight() {
    if (hasStatusRearRight()) {
         clear_has_StatusRearRight();
        _StatusRearRight = ::location_fi_types::T_e8_AbsStatus__ABS_STATUS_NORMAL;
     }
}

inline bool T_AbsData::hasStatusRearRight () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline T_e8_AbsStatus T_AbsData::getStatusRearRight () const {
    return _StatusRearRight;
}

inline void T_AbsData::setStatusRearRight (T_e8_AbsStatus StatusRearRight_) {
    #ifndef NDEBUG
    if (!(T_e8_AbsStatus_IsValid(StatusRearRight_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StatusRearRight_, "T_e8_AbsStatus", "StatusRearRight", "T_AbsData");
    }
    #endif
    set_has_StatusRearRight();
    this->_StatusRearRight = StatusRearRight_;
}

inline void T_AbsData::clearDirectionFrontLeft() {
    if (hasDirectionFrontLeft()) {
         clear_has_DirectionFrontLeft();
        _DirectionFrontLeft = ::location_fi_types::T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN;
     }
}

inline bool T_AbsData::hasDirectionFrontLeft () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline T_e8_AbsDirection T_AbsData::getDirectionFrontLeft () const {
    return _DirectionFrontLeft;
}

inline void T_AbsData::setDirectionFrontLeft (T_e8_AbsDirection DirectionFrontLeft_) {
    #ifndef NDEBUG
    if (!(T_e8_AbsDirection_IsValid(DirectionFrontLeft_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DirectionFrontLeft_, "T_e8_AbsDirection", "DirectionFrontLeft", "T_AbsData");
    }
    #endif
    set_has_DirectionFrontLeft();
    this->_DirectionFrontLeft = DirectionFrontLeft_;
}

inline void T_AbsData::clearDirectionFrontRight() {
    if (hasDirectionFrontRight()) {
         clear_has_DirectionFrontRight();
        _DirectionFrontRight = ::location_fi_types::T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN;
     }
}

inline bool T_AbsData::hasDirectionFrontRight () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline T_e8_AbsDirection T_AbsData::getDirectionFrontRight () const {
    return _DirectionFrontRight;
}

inline void T_AbsData::setDirectionFrontRight (T_e8_AbsDirection DirectionFrontRight_) {
    #ifndef NDEBUG
    if (!(T_e8_AbsDirection_IsValid(DirectionFrontRight_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DirectionFrontRight_, "T_e8_AbsDirection", "DirectionFrontRight", "T_AbsData");
    }
    #endif
    set_has_DirectionFrontRight();
    this->_DirectionFrontRight = DirectionFrontRight_;
}

inline void T_AbsData::clearDirectionRearLeft() {
    if (hasDirectionRearLeft()) {
         clear_has_DirectionRearLeft();
        _DirectionRearLeft = ::location_fi_types::T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN;
     }
}

inline bool T_AbsData::hasDirectionRearLeft () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline T_e8_AbsDirection T_AbsData::getDirectionRearLeft () const {
    return _DirectionRearLeft;
}

inline void T_AbsData::setDirectionRearLeft (T_e8_AbsDirection DirectionRearLeft_) {
    #ifndef NDEBUG
    if (!(T_e8_AbsDirection_IsValid(DirectionRearLeft_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DirectionRearLeft_, "T_e8_AbsDirection", "DirectionRearLeft", "T_AbsData");
    }
    #endif
    set_has_DirectionRearLeft();
    this->_DirectionRearLeft = DirectionRearLeft_;
}

inline void T_AbsData::clearDirectionRearRight() {
    if (hasDirectionRearRight()) {
         clear_has_DirectionRearRight();
        _DirectionRearRight = ::location_fi_types::T_e8_AbsDirection__ABS_DIRECTION_UNKNOWN;
     }
}

inline bool T_AbsData::hasDirectionRearRight () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline T_e8_AbsDirection T_AbsData::getDirectionRearRight () const {
    return _DirectionRearRight;
}

inline void T_AbsData::setDirectionRearRight (T_e8_AbsDirection DirectionRearRight_) {
    #ifndef NDEBUG
    if (!(T_e8_AbsDirection_IsValid(DirectionRearRight_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DirectionRearRight_, "T_e8_AbsDirection", "DirectionRearRight", "T_AbsData");
    }
    #endif
    set_has_DirectionRearRight();
    this->_DirectionRearRight = DirectionRearRight_;
}

inline void T_AbsData::set_has_AbsTimeStamp () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AbsData::clear_has_AbsTimeStamp () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AbsData::set_has_WheelCounterFrontLeft () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AbsData::clear_has_WheelCounterFrontLeft () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AbsData::set_has_WheelCounterFrontRight () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AbsData::clear_has_WheelCounterFrontRight () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AbsData::set_has_WheelCounterRearLeft () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AbsData::clear_has_WheelCounterRearLeft () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_AbsData::set_has_WheelCounterRearRight () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_AbsData::clear_has_WheelCounterRearRight () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_AbsData::set_has_StatusFrontLeft () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_AbsData::clear_has_StatusFrontLeft () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_AbsData::set_has_StatusFrontRight () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_AbsData::clear_has_StatusFrontRight () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_AbsData::set_has_StatusRearLeft () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_AbsData::clear_has_StatusRearLeft () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_AbsData::set_has_StatusRearRight () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_AbsData::clear_has_StatusRearRight () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_AbsData::set_has_DirectionFrontLeft () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_AbsData::clear_has_DirectionFrontLeft () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_AbsData::set_has_DirectionFrontRight () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_AbsData::clear_has_DirectionFrontRight () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_AbsData::set_has_DirectionRearLeft () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_AbsData::clear_has_DirectionRearLeft () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_AbsData::set_has_DirectionRearRight () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_AbsData::clear_has_DirectionRearRight () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline  T_SensorHwInfo::T_SensorHwInfo ()  :
    _AdcRangeMin (0u),
    _AdcRangeMax (0u),
    _SampleMin (0u),
    _SampleMax (0u),
    _MinNoiseValue (0.0f),
    _EstimOffset (0.0f),
    _MinOffset (0.0f),
    _MaxOffset (0.0f),
    _DriftOffset (0.0f),
    _MaxUnsteadOffset (0.0f),
    _BestCalibOffset (0.0f),
    _EstimScaleFactor (0.0f),
    _MinScaleFactor (0.0f),
    _MaxScaleFactor (0.0f),
    _DriftScaleFactor (0.0f),
    _MaxUnsteadScaleFactor (0.0f),
    _BestCalibScaleFactor (0.0f),
    _DriftOffsetTime (0.0f),
    _DriftScaleFactorTime (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SensorHwInfo::T_SensorHwInfo (const T_SensorHwInfo &rhs)  :
    _AdcRangeMin (0u),
    _AdcRangeMax (0u),
    _SampleMin (0u),
    _SampleMax (0u),
    _MinNoiseValue (0.0f),
    _EstimOffset (0.0f),
    _MinOffset (0.0f),
    _MaxOffset (0.0f),
    _DriftOffset (0.0f),
    _MaxUnsteadOffset (0.0f),
    _BestCalibOffset (0.0f),
    _EstimScaleFactor (0.0f),
    _MinScaleFactor (0.0f),
    _MaxScaleFactor (0.0f),
    _DriftScaleFactor (0.0f),
    _MaxUnsteadScaleFactor (0.0f),
    _BestCalibScaleFactor (0.0f),
    _DriftOffsetTime (0.0f),
    _DriftScaleFactorTime (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SensorHwInfo::T_SensorHwInfo (uint32 AdcRangeMin_, uint32 AdcRangeMax_, uint32 SampleMin_, uint32 SampleMax_, float MinNoiseValue_, float EstimOffset_, float MinOffset_, float MaxOffset_, float DriftOffset_, float MaxUnsteadOffset_, float BestCalibOffset_, float EstimScaleFactor_, float MinScaleFactor_, float MaxScaleFactor_, float DriftScaleFactor_, float MaxUnsteadScaleFactor_, float BestCalibScaleFactor_, float DriftOffsetTime_, float DriftScaleFactorTime_)  :
    _AdcRangeMin (AdcRangeMin_),
    _AdcRangeMax (AdcRangeMax_),
    _SampleMin (SampleMin_),
    _SampleMax (SampleMax_),
    _MinNoiseValue (MinNoiseValue_),
    _EstimOffset (EstimOffset_),
    _MinOffset (MinOffset_),
    _MaxOffset (MaxOffset_),
    _DriftOffset (DriftOffset_),
    _MaxUnsteadOffset (MaxUnsteadOffset_),
    _BestCalibOffset (BestCalibOffset_),
    _EstimScaleFactor (EstimScaleFactor_),
    _MinScaleFactor (MinScaleFactor_),
    _MaxScaleFactor (MaxScaleFactor_),
    _DriftScaleFactor (DriftScaleFactor_),
    _MaxUnsteadScaleFactor (MaxUnsteadScaleFactor_),
    _BestCalibScaleFactor (BestCalibScaleFactor_),
    _DriftOffsetTime (DriftOffsetTime_),
    _DriftScaleFactorTime (DriftScaleFactorTime_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SensorHwInfo::~T_SensorHwInfo() {
}

inline T_SensorHwInfo& T_SensorHwInfo::operator = (const T_SensorHwInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAdcRangeMin()) {
            setAdcRangeMin(rhs.getAdcRangeMin());
        } else {
            clearAdcRangeMin();
        }
        if (rhs.hasAdcRangeMax()) {
            setAdcRangeMax(rhs.getAdcRangeMax());
        } else {
            clearAdcRangeMax();
        }
        if (rhs.hasSampleMin()) {
            setSampleMin(rhs.getSampleMin());
        } else {
            clearSampleMin();
        }
        if (rhs.hasSampleMax()) {
            setSampleMax(rhs.getSampleMax());
        } else {
            clearSampleMax();
        }
        if (rhs.hasMinNoiseValue()) {
            setMinNoiseValue(rhs.getMinNoiseValue());
        } else {
            clearMinNoiseValue();
        }
        if (rhs.hasEstimOffset()) {
            setEstimOffset(rhs.getEstimOffset());
        } else {
            clearEstimOffset();
        }
        if (rhs.hasMinOffset()) {
            setMinOffset(rhs.getMinOffset());
        } else {
            clearMinOffset();
        }
        if (rhs.hasMaxOffset()) {
            setMaxOffset(rhs.getMaxOffset());
        } else {
            clearMaxOffset();
        }
        if (rhs.hasDriftOffset()) {
            setDriftOffset(rhs.getDriftOffset());
        } else {
            clearDriftOffset();
        }
        if (rhs.hasMaxUnsteadOffset()) {
            setMaxUnsteadOffset(rhs.getMaxUnsteadOffset());
        } else {
            clearMaxUnsteadOffset();
        }
        if (rhs.hasBestCalibOffset()) {
            setBestCalibOffset(rhs.getBestCalibOffset());
        } else {
            clearBestCalibOffset();
        }
        if (rhs.hasEstimScaleFactor()) {
            setEstimScaleFactor(rhs.getEstimScaleFactor());
        } else {
            clearEstimScaleFactor();
        }
        if (rhs.hasMinScaleFactor()) {
            setMinScaleFactor(rhs.getMinScaleFactor());
        } else {
            clearMinScaleFactor();
        }
        if (rhs.hasMaxScaleFactor()) {
            setMaxScaleFactor(rhs.getMaxScaleFactor());
        } else {
            clearMaxScaleFactor();
        }
        if (rhs.hasDriftScaleFactor()) {
            setDriftScaleFactor(rhs.getDriftScaleFactor());
        } else {
            clearDriftScaleFactor();
        }
        if (rhs.hasMaxUnsteadScaleFactor()) {
            setMaxUnsteadScaleFactor(rhs.getMaxUnsteadScaleFactor());
        } else {
            clearMaxUnsteadScaleFactor();
        }
        if (rhs.hasBestCalibScaleFactor()) {
            setBestCalibScaleFactor(rhs.getBestCalibScaleFactor());
        } else {
            clearBestCalibScaleFactor();
        }
        if (rhs.hasDriftOffsetTime()) {
            setDriftOffsetTime(rhs.getDriftOffsetTime());
        } else {
            clearDriftOffsetTime();
        }
        if (rhs.hasDriftScaleFactorTime()) {
            setDriftScaleFactorTime(rhs.getDriftScaleFactorTime());
        } else {
            clearDriftScaleFactorTime();
        }
    }
    return *this;
}

inline bool T_SensorHwInfo::operator == (const T_SensorHwInfo& rhs) const {
    return (((!hasAdcRangeMin() && !rhs.hasAdcRangeMin()) || getAdcRangeMin() == rhs.getAdcRangeMin()) &&
        ((!hasAdcRangeMax() && !rhs.hasAdcRangeMax()) || getAdcRangeMax() == rhs.getAdcRangeMax()) &&
        ((!hasSampleMin() && !rhs.hasSampleMin()) || getSampleMin() == rhs.getSampleMin()) &&
        ((!hasSampleMax() && !rhs.hasSampleMax()) || getSampleMax() == rhs.getSampleMax()) &&
        ((!hasMinNoiseValue() && !rhs.hasMinNoiseValue()) || getMinNoiseValue() == rhs.getMinNoiseValue()) &&
        ((!hasEstimOffset() && !rhs.hasEstimOffset()) || getEstimOffset() == rhs.getEstimOffset()) &&
        ((!hasMinOffset() && !rhs.hasMinOffset()) || getMinOffset() == rhs.getMinOffset()) &&
        ((!hasMaxOffset() && !rhs.hasMaxOffset()) || getMaxOffset() == rhs.getMaxOffset()) &&
        ((!hasDriftOffset() && !rhs.hasDriftOffset()) || getDriftOffset() == rhs.getDriftOffset()) &&
        ((!hasMaxUnsteadOffset() && !rhs.hasMaxUnsteadOffset()) || getMaxUnsteadOffset() == rhs.getMaxUnsteadOffset()) &&
        ((!hasBestCalibOffset() && !rhs.hasBestCalibOffset()) || getBestCalibOffset() == rhs.getBestCalibOffset()) &&
        ((!hasEstimScaleFactor() && !rhs.hasEstimScaleFactor()) || getEstimScaleFactor() == rhs.getEstimScaleFactor()) &&
        ((!hasMinScaleFactor() && !rhs.hasMinScaleFactor()) || getMinScaleFactor() == rhs.getMinScaleFactor()) &&
        ((!hasMaxScaleFactor() && !rhs.hasMaxScaleFactor()) || getMaxScaleFactor() == rhs.getMaxScaleFactor()) &&
        ((!hasDriftScaleFactor() && !rhs.hasDriftScaleFactor()) || getDriftScaleFactor() == rhs.getDriftScaleFactor()) &&
        ((!hasMaxUnsteadScaleFactor() && !rhs.hasMaxUnsteadScaleFactor()) || getMaxUnsteadScaleFactor() == rhs.getMaxUnsteadScaleFactor()) &&
        ((!hasBestCalibScaleFactor() && !rhs.hasBestCalibScaleFactor()) || getBestCalibScaleFactor() == rhs.getBestCalibScaleFactor()) &&
        ((!hasDriftOffsetTime() && !rhs.hasDriftOffsetTime()) || getDriftOffsetTime() == rhs.getDriftOffsetTime()) &&
        ((!hasDriftScaleFactorTime() && !rhs.hasDriftScaleFactorTime()) || getDriftScaleFactorTime() == rhs.getDriftScaleFactorTime()));
}

inline bool T_SensorHwInfo::operator != (const T_SensorHwInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SensorHwInfo::operator < (const T_SensorHwInfo& rhs) const {
    if (hasAdcRangeMin() || rhs.hasAdcRangeMin()) {
        if (getAdcRangeMin() < rhs.getAdcRangeMin()) return true;
        if (getAdcRangeMin() > rhs.getAdcRangeMin()) return false;
    }
    if (hasAdcRangeMax() || rhs.hasAdcRangeMax()) {
        if (getAdcRangeMax() < rhs.getAdcRangeMax()) return true;
        if (getAdcRangeMax() > rhs.getAdcRangeMax()) return false;
    }
    if (hasSampleMin() || rhs.hasSampleMin()) {
        if (getSampleMin() < rhs.getSampleMin()) return true;
        if (getSampleMin() > rhs.getSampleMin()) return false;
    }
    if (hasSampleMax() || rhs.hasSampleMax()) {
        if (getSampleMax() < rhs.getSampleMax()) return true;
        if (getSampleMax() > rhs.getSampleMax()) return false;
    }
    if (hasMinNoiseValue() || rhs.hasMinNoiseValue()) {
        if (getMinNoiseValue() < rhs.getMinNoiseValue()) return true;
        if (getMinNoiseValue() > rhs.getMinNoiseValue()) return false;
    }
    if (hasEstimOffset() || rhs.hasEstimOffset()) {
        if (getEstimOffset() < rhs.getEstimOffset()) return true;
        if (getEstimOffset() > rhs.getEstimOffset()) return false;
    }
    if (hasMinOffset() || rhs.hasMinOffset()) {
        if (getMinOffset() < rhs.getMinOffset()) return true;
        if (getMinOffset() > rhs.getMinOffset()) return false;
    }
    if (hasMaxOffset() || rhs.hasMaxOffset()) {
        if (getMaxOffset() < rhs.getMaxOffset()) return true;
        if (getMaxOffset() > rhs.getMaxOffset()) return false;
    }
    if (hasDriftOffset() || rhs.hasDriftOffset()) {
        if (getDriftOffset() < rhs.getDriftOffset()) return true;
        if (getDriftOffset() > rhs.getDriftOffset()) return false;
    }
    if (hasMaxUnsteadOffset() || rhs.hasMaxUnsteadOffset()) {
        if (getMaxUnsteadOffset() < rhs.getMaxUnsteadOffset()) return true;
        if (getMaxUnsteadOffset() > rhs.getMaxUnsteadOffset()) return false;
    }
    if (hasBestCalibOffset() || rhs.hasBestCalibOffset()) {
        if (getBestCalibOffset() < rhs.getBestCalibOffset()) return true;
        if (getBestCalibOffset() > rhs.getBestCalibOffset()) return false;
    }
    if (hasEstimScaleFactor() || rhs.hasEstimScaleFactor()) {
        if (getEstimScaleFactor() < rhs.getEstimScaleFactor()) return true;
        if (getEstimScaleFactor() > rhs.getEstimScaleFactor()) return false;
    }
    if (hasMinScaleFactor() || rhs.hasMinScaleFactor()) {
        if (getMinScaleFactor() < rhs.getMinScaleFactor()) return true;
        if (getMinScaleFactor() > rhs.getMinScaleFactor()) return false;
    }
    if (hasMaxScaleFactor() || rhs.hasMaxScaleFactor()) {
        if (getMaxScaleFactor() < rhs.getMaxScaleFactor()) return true;
        if (getMaxScaleFactor() > rhs.getMaxScaleFactor()) return false;
    }
    if (hasDriftScaleFactor() || rhs.hasDriftScaleFactor()) {
        if (getDriftScaleFactor() < rhs.getDriftScaleFactor()) return true;
        if (getDriftScaleFactor() > rhs.getDriftScaleFactor()) return false;
    }
    if (hasMaxUnsteadScaleFactor() || rhs.hasMaxUnsteadScaleFactor()) {
        if (getMaxUnsteadScaleFactor() < rhs.getMaxUnsteadScaleFactor()) return true;
        if (getMaxUnsteadScaleFactor() > rhs.getMaxUnsteadScaleFactor()) return false;
    }
    if (hasBestCalibScaleFactor() || rhs.hasBestCalibScaleFactor()) {
        if (getBestCalibScaleFactor() < rhs.getBestCalibScaleFactor()) return true;
        if (getBestCalibScaleFactor() > rhs.getBestCalibScaleFactor()) return false;
    }
    if (hasDriftOffsetTime() || rhs.hasDriftOffsetTime()) {
        if (getDriftOffsetTime() < rhs.getDriftOffsetTime()) return true;
        if (getDriftOffsetTime() > rhs.getDriftOffsetTime()) return false;
    }
    if (hasDriftScaleFactorTime() || rhs.hasDriftScaleFactorTime()) {
        if (getDriftScaleFactorTime() < rhs.getDriftScaleFactorTime()) return true;
        if (getDriftScaleFactorTime() > rhs.getDriftScaleFactorTime()) return false;
    }
    return false;
}

inline bool T_SensorHwInfo::operator > (const T_SensorHwInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SensorHwInfo::clear() {
    clearAdcRangeMin();
    clearAdcRangeMax();
    clearSampleMin();
    clearSampleMax();
    clearMinNoiseValue();
    clearEstimOffset();
    clearMinOffset();
    clearMaxOffset();
    clearDriftOffset();
    clearMaxUnsteadOffset();
    clearBestCalibOffset();
    clearEstimScaleFactor();
    clearMinScaleFactor();
    clearMaxScaleFactor();
    clearDriftScaleFactor();
    clearMaxUnsteadScaleFactor();
    clearBestCalibScaleFactor();
    clearDriftOffsetTime();
    clearDriftScaleFactorTime();
}

inline void T_SensorHwInfo::clearAdcRangeMin() {
    if (hasAdcRangeMin()) {
         clear_has_AdcRangeMin();
        _AdcRangeMin = 0u;
     }
}

inline bool T_SensorHwInfo::hasAdcRangeMin () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_SensorHwInfo::getAdcRangeMin () const {
    return _AdcRangeMin;
}

inline void T_SensorHwInfo::setAdcRangeMin (uint32 AdcRangeMin_) {
    set_has_AdcRangeMin();
    this->_AdcRangeMin = AdcRangeMin_;
}

inline void T_SensorHwInfo::clearAdcRangeMax() {
    if (hasAdcRangeMax()) {
         clear_has_AdcRangeMax();
        _AdcRangeMax = 0u;
     }
}

inline bool T_SensorHwInfo::hasAdcRangeMax () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_SensorHwInfo::getAdcRangeMax () const {
    return _AdcRangeMax;
}

inline void T_SensorHwInfo::setAdcRangeMax (uint32 AdcRangeMax_) {
    set_has_AdcRangeMax();
    this->_AdcRangeMax = AdcRangeMax_;
}

inline void T_SensorHwInfo::clearSampleMin() {
    if (hasSampleMin()) {
         clear_has_SampleMin();
        _SampleMin = 0u;
     }
}

inline bool T_SensorHwInfo::hasSampleMin () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_SensorHwInfo::getSampleMin () const {
    return _SampleMin;
}

inline void T_SensorHwInfo::setSampleMin (uint32 SampleMin_) {
    set_has_SampleMin();
    this->_SampleMin = SampleMin_;
}

inline void T_SensorHwInfo::clearSampleMax() {
    if (hasSampleMax()) {
         clear_has_SampleMax();
        _SampleMax = 0u;
     }
}

inline bool T_SensorHwInfo::hasSampleMax () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_SensorHwInfo::getSampleMax () const {
    return _SampleMax;
}

inline void T_SensorHwInfo::setSampleMax (uint32 SampleMax_) {
    set_has_SampleMax();
    this->_SampleMax = SampleMax_;
}

inline void T_SensorHwInfo::clearMinNoiseValue() {
    if (hasMinNoiseValue()) {
         clear_has_MinNoiseValue();
        _MinNoiseValue = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasMinNoiseValue () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline float T_SensorHwInfo::getMinNoiseValue () const {
    return _MinNoiseValue;
}

inline void T_SensorHwInfo::setMinNoiseValue (float MinNoiseValue_) {
    set_has_MinNoiseValue();
    this->_MinNoiseValue = MinNoiseValue_;
}

inline void T_SensorHwInfo::clearEstimOffset() {
    if (hasEstimOffset()) {
         clear_has_EstimOffset();
        _EstimOffset = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasEstimOffset () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline float T_SensorHwInfo::getEstimOffset () const {
    return _EstimOffset;
}

inline void T_SensorHwInfo::setEstimOffset (float EstimOffset_) {
    set_has_EstimOffset();
    this->_EstimOffset = EstimOffset_;
}

inline void T_SensorHwInfo::clearMinOffset() {
    if (hasMinOffset()) {
         clear_has_MinOffset();
        _MinOffset = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasMinOffset () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline float T_SensorHwInfo::getMinOffset () const {
    return _MinOffset;
}

inline void T_SensorHwInfo::setMinOffset (float MinOffset_) {
    set_has_MinOffset();
    this->_MinOffset = MinOffset_;
}

inline void T_SensorHwInfo::clearMaxOffset() {
    if (hasMaxOffset()) {
         clear_has_MaxOffset();
        _MaxOffset = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasMaxOffset () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline float T_SensorHwInfo::getMaxOffset () const {
    return _MaxOffset;
}

inline void T_SensorHwInfo::setMaxOffset (float MaxOffset_) {
    set_has_MaxOffset();
    this->_MaxOffset = MaxOffset_;
}

inline void T_SensorHwInfo::clearDriftOffset() {
    if (hasDriftOffset()) {
         clear_has_DriftOffset();
        _DriftOffset = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasDriftOffset () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline float T_SensorHwInfo::getDriftOffset () const {
    return _DriftOffset;
}

inline void T_SensorHwInfo::setDriftOffset (float DriftOffset_) {
    set_has_DriftOffset();
    this->_DriftOffset = DriftOffset_;
}

inline void T_SensorHwInfo::clearMaxUnsteadOffset() {
    if (hasMaxUnsteadOffset()) {
         clear_has_MaxUnsteadOffset();
        _MaxUnsteadOffset = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasMaxUnsteadOffset () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline float T_SensorHwInfo::getMaxUnsteadOffset () const {
    return _MaxUnsteadOffset;
}

inline void T_SensorHwInfo::setMaxUnsteadOffset (float MaxUnsteadOffset_) {
    set_has_MaxUnsteadOffset();
    this->_MaxUnsteadOffset = MaxUnsteadOffset_;
}

inline void T_SensorHwInfo::clearBestCalibOffset() {
    if (hasBestCalibOffset()) {
         clear_has_BestCalibOffset();
        _BestCalibOffset = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasBestCalibOffset () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline float T_SensorHwInfo::getBestCalibOffset () const {
    return _BestCalibOffset;
}

inline void T_SensorHwInfo::setBestCalibOffset (float BestCalibOffset_) {
    set_has_BestCalibOffset();
    this->_BestCalibOffset = BestCalibOffset_;
}

inline void T_SensorHwInfo::clearEstimScaleFactor() {
    if (hasEstimScaleFactor()) {
         clear_has_EstimScaleFactor();
        _EstimScaleFactor = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasEstimScaleFactor () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline float T_SensorHwInfo::getEstimScaleFactor () const {
    return _EstimScaleFactor;
}

inline void T_SensorHwInfo::setEstimScaleFactor (float EstimScaleFactor_) {
    set_has_EstimScaleFactor();
    this->_EstimScaleFactor = EstimScaleFactor_;
}

inline void T_SensorHwInfo::clearMinScaleFactor() {
    if (hasMinScaleFactor()) {
         clear_has_MinScaleFactor();
        _MinScaleFactor = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasMinScaleFactor () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline float T_SensorHwInfo::getMinScaleFactor () const {
    return _MinScaleFactor;
}

inline void T_SensorHwInfo::setMinScaleFactor (float MinScaleFactor_) {
    set_has_MinScaleFactor();
    this->_MinScaleFactor = MinScaleFactor_;
}

inline void T_SensorHwInfo::clearMaxScaleFactor() {
    if (hasMaxScaleFactor()) {
         clear_has_MaxScaleFactor();
        _MaxScaleFactor = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasMaxScaleFactor () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline float T_SensorHwInfo::getMaxScaleFactor () const {
    return _MaxScaleFactor;
}

inline void T_SensorHwInfo::setMaxScaleFactor (float MaxScaleFactor_) {
    set_has_MaxScaleFactor();
    this->_MaxScaleFactor = MaxScaleFactor_;
}

inline void T_SensorHwInfo::clearDriftScaleFactor() {
    if (hasDriftScaleFactor()) {
         clear_has_DriftScaleFactor();
        _DriftScaleFactor = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasDriftScaleFactor () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline float T_SensorHwInfo::getDriftScaleFactor () const {
    return _DriftScaleFactor;
}

inline void T_SensorHwInfo::setDriftScaleFactor (float DriftScaleFactor_) {
    set_has_DriftScaleFactor();
    this->_DriftScaleFactor = DriftScaleFactor_;
}

inline void T_SensorHwInfo::clearMaxUnsteadScaleFactor() {
    if (hasMaxUnsteadScaleFactor()) {
         clear_has_MaxUnsteadScaleFactor();
        _MaxUnsteadScaleFactor = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasMaxUnsteadScaleFactor () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline float T_SensorHwInfo::getMaxUnsteadScaleFactor () const {
    return _MaxUnsteadScaleFactor;
}

inline void T_SensorHwInfo::setMaxUnsteadScaleFactor (float MaxUnsteadScaleFactor_) {
    set_has_MaxUnsteadScaleFactor();
    this->_MaxUnsteadScaleFactor = MaxUnsteadScaleFactor_;
}

inline void T_SensorHwInfo::clearBestCalibScaleFactor() {
    if (hasBestCalibScaleFactor()) {
         clear_has_BestCalibScaleFactor();
        _BestCalibScaleFactor = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasBestCalibScaleFactor () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline float T_SensorHwInfo::getBestCalibScaleFactor () const {
    return _BestCalibScaleFactor;
}

inline void T_SensorHwInfo::setBestCalibScaleFactor (float BestCalibScaleFactor_) {
    set_has_BestCalibScaleFactor();
    this->_BestCalibScaleFactor = BestCalibScaleFactor_;
}

inline void T_SensorHwInfo::clearDriftOffsetTime() {
    if (hasDriftOffsetTime()) {
         clear_has_DriftOffsetTime();
        _DriftOffsetTime = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasDriftOffsetTime () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline float T_SensorHwInfo::getDriftOffsetTime () const {
    return _DriftOffsetTime;
}

inline void T_SensorHwInfo::setDriftOffsetTime (float DriftOffsetTime_) {
    set_has_DriftOffsetTime();
    this->_DriftOffsetTime = DriftOffsetTime_;
}

inline void T_SensorHwInfo::clearDriftScaleFactorTime() {
    if (hasDriftScaleFactorTime()) {
         clear_has_DriftScaleFactorTime();
        _DriftScaleFactorTime = 0.0f;
     }
}

inline bool T_SensorHwInfo::hasDriftScaleFactorTime () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline float T_SensorHwInfo::getDriftScaleFactorTime () const {
    return _DriftScaleFactorTime;
}

inline void T_SensorHwInfo::setDriftScaleFactorTime (float DriftScaleFactorTime_) {
    set_has_DriftScaleFactorTime();
    this->_DriftScaleFactorTime = DriftScaleFactorTime_;
}

inline void T_SensorHwInfo::set_has_AdcRangeMin () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SensorHwInfo::clear_has_AdcRangeMin () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SensorHwInfo::set_has_AdcRangeMax () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SensorHwInfo::clear_has_AdcRangeMax () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SensorHwInfo::set_has_SampleMin () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SensorHwInfo::clear_has_SampleMin () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SensorHwInfo::set_has_SampleMax () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SensorHwInfo::clear_has_SampleMax () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SensorHwInfo::set_has_MinNoiseValue () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SensorHwInfo::clear_has_MinNoiseValue () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SensorHwInfo::set_has_EstimOffset () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SensorHwInfo::clear_has_EstimOffset () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SensorHwInfo::set_has_MinOffset () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SensorHwInfo::clear_has_MinOffset () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SensorHwInfo::set_has_MaxOffset () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SensorHwInfo::clear_has_MaxOffset () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_SensorHwInfo::set_has_DriftOffset () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_SensorHwInfo::clear_has_DriftOffset () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_SensorHwInfo::set_has_MaxUnsteadOffset () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_SensorHwInfo::clear_has_MaxUnsteadOffset () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_SensorHwInfo::set_has_BestCalibOffset () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_SensorHwInfo::clear_has_BestCalibOffset () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_SensorHwInfo::set_has_EstimScaleFactor () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_SensorHwInfo::clear_has_EstimScaleFactor () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_SensorHwInfo::set_has_MinScaleFactor () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_SensorHwInfo::clear_has_MinScaleFactor () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_SensorHwInfo::set_has_MaxScaleFactor () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_SensorHwInfo::clear_has_MaxScaleFactor () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_SensorHwInfo::set_has_DriftScaleFactor () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_SensorHwInfo::clear_has_DriftScaleFactor () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_SensorHwInfo::set_has_MaxUnsteadScaleFactor () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_SensorHwInfo::clear_has_MaxUnsteadScaleFactor () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_SensorHwInfo::set_has_BestCalibScaleFactor () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_SensorHwInfo::clear_has_BestCalibScaleFactor () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_SensorHwInfo::set_has_DriftOffsetTime () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_SensorHwInfo::clear_has_DriftOffsetTime () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_SensorHwInfo::set_has_DriftScaleFactorTime () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_SensorHwInfo::clear_has_DriftScaleFactorTime () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline  T_3dMountAngles::T_3dMountAngles ()  :
    _AngRX (0u),
    _AngRY (0u),
    _AngRZ (0u),
    _AngSX (0u),
    _AngSY (0u),
    _AngSZ (0u),
    _AngTX (0u),
    _AngTY (0u),
    _AngTZ (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_3dMountAngles::T_3dMountAngles (const T_3dMountAngles &rhs)  :
    _AngRX (0u),
    _AngRY (0u),
    _AngRZ (0u),
    _AngSX (0u),
    _AngSY (0u),
    _AngSZ (0u),
    _AngTX (0u),
    _AngTY (0u),
    _AngTZ (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_3dMountAngles::T_3dMountAngles (uint8 AngRX_, uint8 AngRY_, uint8 AngRZ_, uint8 AngSX_, uint8 AngSY_, uint8 AngSZ_, uint8 AngTX_, uint8 AngTY_, uint8 AngTZ_)  :
    _AngRX (AngRX_),
    _AngRY (AngRY_),
    _AngRZ (AngRZ_),
    _AngSX (AngSX_),
    _AngSY (AngSY_),
    _AngSZ (AngSZ_),
    _AngTX (AngTX_),
    _AngTY (AngTY_),
    _AngTZ (AngTZ_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_3dMountAngles::~T_3dMountAngles() {
}

inline T_3dMountAngles& T_3dMountAngles::operator = (const T_3dMountAngles& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAngRX()) {
            setAngRX(rhs.getAngRX());
        } else {
            clearAngRX();
        }
        if (rhs.hasAngRY()) {
            setAngRY(rhs.getAngRY());
        } else {
            clearAngRY();
        }
        if (rhs.hasAngRZ()) {
            setAngRZ(rhs.getAngRZ());
        } else {
            clearAngRZ();
        }
        if (rhs.hasAngSX()) {
            setAngSX(rhs.getAngSX());
        } else {
            clearAngSX();
        }
        if (rhs.hasAngSY()) {
            setAngSY(rhs.getAngSY());
        } else {
            clearAngSY();
        }
        if (rhs.hasAngSZ()) {
            setAngSZ(rhs.getAngSZ());
        } else {
            clearAngSZ();
        }
        if (rhs.hasAngTX()) {
            setAngTX(rhs.getAngTX());
        } else {
            clearAngTX();
        }
        if (rhs.hasAngTY()) {
            setAngTY(rhs.getAngTY());
        } else {
            clearAngTY();
        }
        if (rhs.hasAngTZ()) {
            setAngTZ(rhs.getAngTZ());
        } else {
            clearAngTZ();
        }
    }
    return *this;
}

inline bool T_3dMountAngles::operator == (const T_3dMountAngles& rhs) const {
    return (((!hasAngRX() && !rhs.hasAngRX()) || getAngRX() == rhs.getAngRX()) &&
        ((!hasAngRY() && !rhs.hasAngRY()) || getAngRY() == rhs.getAngRY()) &&
        ((!hasAngRZ() && !rhs.hasAngRZ()) || getAngRZ() == rhs.getAngRZ()) &&
        ((!hasAngSX() && !rhs.hasAngSX()) || getAngSX() == rhs.getAngSX()) &&
        ((!hasAngSY() && !rhs.hasAngSY()) || getAngSY() == rhs.getAngSY()) &&
        ((!hasAngSZ() && !rhs.hasAngSZ()) || getAngSZ() == rhs.getAngSZ()) &&
        ((!hasAngTX() && !rhs.hasAngTX()) || getAngTX() == rhs.getAngTX()) &&
        ((!hasAngTY() && !rhs.hasAngTY()) || getAngTY() == rhs.getAngTY()) &&
        ((!hasAngTZ() && !rhs.hasAngTZ()) || getAngTZ() == rhs.getAngTZ()));
}

inline bool T_3dMountAngles::operator != (const T_3dMountAngles& rhs) const {
    return ! (*this == rhs);
}

inline bool T_3dMountAngles::operator < (const T_3dMountAngles& rhs) const {
    if (hasAngRX() || rhs.hasAngRX()) {
        if (getAngRX() < rhs.getAngRX()) return true;
        if (getAngRX() > rhs.getAngRX()) return false;
    }
    if (hasAngRY() || rhs.hasAngRY()) {
        if (getAngRY() < rhs.getAngRY()) return true;
        if (getAngRY() > rhs.getAngRY()) return false;
    }
    if (hasAngRZ() || rhs.hasAngRZ()) {
        if (getAngRZ() < rhs.getAngRZ()) return true;
        if (getAngRZ() > rhs.getAngRZ()) return false;
    }
    if (hasAngSX() || rhs.hasAngSX()) {
        if (getAngSX() < rhs.getAngSX()) return true;
        if (getAngSX() > rhs.getAngSX()) return false;
    }
    if (hasAngSY() || rhs.hasAngSY()) {
        if (getAngSY() < rhs.getAngSY()) return true;
        if (getAngSY() > rhs.getAngSY()) return false;
    }
    if (hasAngSZ() || rhs.hasAngSZ()) {
        if (getAngSZ() < rhs.getAngSZ()) return true;
        if (getAngSZ() > rhs.getAngSZ()) return false;
    }
    if (hasAngTX() || rhs.hasAngTX()) {
        if (getAngTX() < rhs.getAngTX()) return true;
        if (getAngTX() > rhs.getAngTX()) return false;
    }
    if (hasAngTY() || rhs.hasAngTY()) {
        if (getAngTY() < rhs.getAngTY()) return true;
        if (getAngTY() > rhs.getAngTY()) return false;
    }
    if (hasAngTZ() || rhs.hasAngTZ()) {
        if (getAngTZ() < rhs.getAngTZ()) return true;
        if (getAngTZ() > rhs.getAngTZ()) return false;
    }
    return false;
}

inline bool T_3dMountAngles::operator > (const T_3dMountAngles& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_3dMountAngles::clear() {
    clearAngRX();
    clearAngRY();
    clearAngRZ();
    clearAngSX();
    clearAngSY();
    clearAngSZ();
    clearAngTX();
    clearAngTY();
    clearAngTZ();
}

inline void T_3dMountAngles::clearAngRX() {
    if (hasAngRX()) {
         clear_has_AngRX();
        _AngRX = 0u;
     }
}

inline bool T_3dMountAngles::hasAngRX () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_3dMountAngles::getAngRX () const {
    return _AngRX;
}

inline void T_3dMountAngles::setAngRX (uint8 AngRX_) {
    set_has_AngRX();
    this->_AngRX = AngRX_;
}

inline void T_3dMountAngles::clearAngRY() {
    if (hasAngRY()) {
         clear_has_AngRY();
        _AngRY = 0u;
     }
}

inline bool T_3dMountAngles::hasAngRY () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_3dMountAngles::getAngRY () const {
    return _AngRY;
}

inline void T_3dMountAngles::setAngRY (uint8 AngRY_) {
    set_has_AngRY();
    this->_AngRY = AngRY_;
}

inline void T_3dMountAngles::clearAngRZ() {
    if (hasAngRZ()) {
         clear_has_AngRZ();
        _AngRZ = 0u;
     }
}

inline bool T_3dMountAngles::hasAngRZ () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_3dMountAngles::getAngRZ () const {
    return _AngRZ;
}

inline void T_3dMountAngles::setAngRZ (uint8 AngRZ_) {
    set_has_AngRZ();
    this->_AngRZ = AngRZ_;
}

inline void T_3dMountAngles::clearAngSX() {
    if (hasAngSX()) {
         clear_has_AngSX();
        _AngSX = 0u;
     }
}

inline bool T_3dMountAngles::hasAngSX () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_3dMountAngles::getAngSX () const {
    return _AngSX;
}

inline void T_3dMountAngles::setAngSX (uint8 AngSX_) {
    set_has_AngSX();
    this->_AngSX = AngSX_;
}

inline void T_3dMountAngles::clearAngSY() {
    if (hasAngSY()) {
         clear_has_AngSY();
        _AngSY = 0u;
     }
}

inline bool T_3dMountAngles::hasAngSY () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_3dMountAngles::getAngSY () const {
    return _AngSY;
}

inline void T_3dMountAngles::setAngSY (uint8 AngSY_) {
    set_has_AngSY();
    this->_AngSY = AngSY_;
}

inline void T_3dMountAngles::clearAngSZ() {
    if (hasAngSZ()) {
         clear_has_AngSZ();
        _AngSZ = 0u;
     }
}

inline bool T_3dMountAngles::hasAngSZ () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_3dMountAngles::getAngSZ () const {
    return _AngSZ;
}

inline void T_3dMountAngles::setAngSZ (uint8 AngSZ_) {
    set_has_AngSZ();
    this->_AngSZ = AngSZ_;
}

inline void T_3dMountAngles::clearAngTX() {
    if (hasAngTX()) {
         clear_has_AngTX();
        _AngTX = 0u;
     }
}

inline bool T_3dMountAngles::hasAngTX () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_3dMountAngles::getAngTX () const {
    return _AngTX;
}

inline void T_3dMountAngles::setAngTX (uint8 AngTX_) {
    set_has_AngTX();
    this->_AngTX = AngTX_;
}

inline void T_3dMountAngles::clearAngTY() {
    if (hasAngTY()) {
         clear_has_AngTY();
        _AngTY = 0u;
     }
}

inline bool T_3dMountAngles::hasAngTY () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_3dMountAngles::getAngTY () const {
    return _AngTY;
}

inline void T_3dMountAngles::setAngTY (uint8 AngTY_) {
    set_has_AngTY();
    this->_AngTY = AngTY_;
}

inline void T_3dMountAngles::clearAngTZ() {
    if (hasAngTZ()) {
         clear_has_AngTZ();
        _AngTZ = 0u;
     }
}

inline bool T_3dMountAngles::hasAngTZ () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 T_3dMountAngles::getAngTZ () const {
    return _AngTZ;
}

inline void T_3dMountAngles::setAngTZ (uint8 AngTZ_) {
    set_has_AngTZ();
    this->_AngTZ = AngTZ_;
}

inline void T_3dMountAngles::set_has_AngRX () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_3dMountAngles::clear_has_AngRX () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_3dMountAngles::set_has_AngRY () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_3dMountAngles::clear_has_AngRY () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_3dMountAngles::set_has_AngRZ () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_3dMountAngles::clear_has_AngRZ () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_3dMountAngles::set_has_AngSX () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_3dMountAngles::clear_has_AngSX () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_3dMountAngles::set_has_AngSY () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_3dMountAngles::clear_has_AngSY () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_3dMountAngles::set_has_AngSZ () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_3dMountAngles::clear_has_AngSZ () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_3dMountAngles::set_has_AngTX () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_3dMountAngles::clear_has_AngTX () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_3dMountAngles::set_has_AngTY () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_3dMountAngles::clear_has_AngTY () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_3dMountAngles::set_has_AngTZ () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_3dMountAngles::clear_has_AngTZ () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_3dGyroHwInfo::T_3dGyroHwInfo ()  :
    _SampleRate (0u),
    _MountAngles (),
    _RAxes (),
    _SAxes (),
    _TAxes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_3dGyroHwInfo::T_3dGyroHwInfo (const T_3dGyroHwInfo &rhs)  :
    _SampleRate (0u),
    _MountAngles (),
    _RAxes (),
    _SAxes (),
    _TAxes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_3dGyroHwInfo::T_3dGyroHwInfo (uint32 SampleRate_, const T_3dMountAngles& MountAngles_, const T_SensorHwInfo& RAxes_, const T_SensorHwInfo& SAxes_, const T_SensorHwInfo& TAxes_)  :
    _SampleRate (SampleRate_),
    _MountAngles (MountAngles_),
    _RAxes (RAxes_),
    _SAxes (SAxes_),
    _TAxes (TAxes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_3dGyroHwInfo::~T_3dGyroHwInfo() {
}

inline T_3dGyroHwInfo& T_3dGyroHwInfo::operator = (const T_3dGyroHwInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSampleRate()) {
            setSampleRate(rhs.getSampleRate());
        } else {
            clearSampleRate();
        }
        if (rhs.hasMountAngles()) {
            setMountAngles(rhs.getMountAngles());
        } else {
            clearMountAngles();
        }
        if (rhs.hasRAxes()) {
            setRAxes(rhs.getRAxes());
        } else {
            clearRAxes();
        }
        if (rhs.hasSAxes()) {
            setSAxes(rhs.getSAxes());
        } else {
            clearSAxes();
        }
        if (rhs.hasTAxes()) {
            setTAxes(rhs.getTAxes());
        } else {
            clearTAxes();
        }
    }
    return *this;
}

inline bool T_3dGyroHwInfo::operator == (const T_3dGyroHwInfo& rhs) const {
    return (((!hasSampleRate() && !rhs.hasSampleRate()) || getSampleRate() == rhs.getSampleRate()) &&
        ((!hasMountAngles() && !rhs.hasMountAngles()) || getMountAngles() == rhs.getMountAngles()) &&
        ((!hasRAxes() && !rhs.hasRAxes()) || getRAxes() == rhs.getRAxes()) &&
        ((!hasSAxes() && !rhs.hasSAxes()) || getSAxes() == rhs.getSAxes()) &&
        ((!hasTAxes() && !rhs.hasTAxes()) || getTAxes() == rhs.getTAxes()));
}

inline bool T_3dGyroHwInfo::operator != (const T_3dGyroHwInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_3dGyroHwInfo::operator < (const T_3dGyroHwInfo& rhs) const {
    if (hasSampleRate() || rhs.hasSampleRate()) {
        if (getSampleRate() < rhs.getSampleRate()) return true;
        if (getSampleRate() > rhs.getSampleRate()) return false;
    }
    if (hasMountAngles() || rhs.hasMountAngles()) {
        if (getMountAngles() < rhs.getMountAngles()) return true;
        if (getMountAngles() > rhs.getMountAngles()) return false;
    }
    if (hasRAxes() || rhs.hasRAxes()) {
        if (getRAxes() < rhs.getRAxes()) return true;
        if (getRAxes() > rhs.getRAxes()) return false;
    }
    if (hasSAxes() || rhs.hasSAxes()) {
        if (getSAxes() < rhs.getSAxes()) return true;
        if (getSAxes() > rhs.getSAxes()) return false;
    }
    if (hasTAxes() || rhs.hasTAxes()) {
        if (getTAxes() < rhs.getTAxes()) return true;
        if (getTAxes() > rhs.getTAxes()) return false;
    }
    return false;
}

inline bool T_3dGyroHwInfo::operator > (const T_3dGyroHwInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_3dGyroHwInfo::clear() {
    clearSampleRate();
    clearMountAngles();
    clearRAxes();
    clearSAxes();
    clearTAxes();
}

inline void T_3dGyroHwInfo::clearSampleRate() {
    if (hasSampleRate()) {
         clear_has_SampleRate();
        _SampleRate = 0u;
     }
}

inline bool T_3dGyroHwInfo::hasSampleRate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_3dGyroHwInfo::getSampleRate () const {
    return _SampleRate;
}

inline void T_3dGyroHwInfo::setSampleRate (uint32 SampleRate_) {
    set_has_SampleRate();
    this->_SampleRate = SampleRate_;
}

inline void T_3dGyroHwInfo::clearMountAngles() {
    if (hasMountAngles()) {
         clear_has_MountAngles();
        _MountAngles.clear();
     }
}

inline bool T_3dGyroHwInfo::hasMountAngles () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_3dMountAngles& T_3dGyroHwInfo::getMountAngles () const {
    return _MountAngles;
}

inline T_3dMountAngles& T_3dGyroHwInfo::getMountAnglesMutable () {
    set_has_MountAngles();
    return _MountAngles;
}

inline void T_3dGyroHwInfo::setMountAngles (const T_3dMountAngles& MountAngles_) {
    set_has_MountAngles();
    this->_MountAngles = MountAngles_;
}

inline void T_3dGyroHwInfo::clearRAxes() {
    if (hasRAxes()) {
         clear_has_RAxes();
        _RAxes.clear();
     }
}

inline bool T_3dGyroHwInfo::hasRAxes () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_SensorHwInfo& T_3dGyroHwInfo::getRAxes () const {
    return _RAxes;
}

inline T_SensorHwInfo& T_3dGyroHwInfo::getRAxesMutable () {
    set_has_RAxes();
    return _RAxes;
}

inline void T_3dGyroHwInfo::setRAxes (const T_SensorHwInfo& RAxes_) {
    set_has_RAxes();
    this->_RAxes = RAxes_;
}

inline void T_3dGyroHwInfo::clearSAxes() {
    if (hasSAxes()) {
         clear_has_SAxes();
        _SAxes.clear();
     }
}

inline bool T_3dGyroHwInfo::hasSAxes () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_SensorHwInfo& T_3dGyroHwInfo::getSAxes () const {
    return _SAxes;
}

inline T_SensorHwInfo& T_3dGyroHwInfo::getSAxesMutable () {
    set_has_SAxes();
    return _SAxes;
}

inline void T_3dGyroHwInfo::setSAxes (const T_SensorHwInfo& SAxes_) {
    set_has_SAxes();
    this->_SAxes = SAxes_;
}

inline void T_3dGyroHwInfo::clearTAxes() {
    if (hasTAxes()) {
         clear_has_TAxes();
        _TAxes.clear();
     }
}

inline bool T_3dGyroHwInfo::hasTAxes () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const T_SensorHwInfo& T_3dGyroHwInfo::getTAxes () const {
    return _TAxes;
}

inline T_SensorHwInfo& T_3dGyroHwInfo::getTAxesMutable () {
    set_has_TAxes();
    return _TAxes;
}

inline void T_3dGyroHwInfo::setTAxes (const T_SensorHwInfo& TAxes_) {
    set_has_TAxes();
    this->_TAxes = TAxes_;
}

inline void T_3dGyroHwInfo::set_has_SampleRate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_3dGyroHwInfo::clear_has_SampleRate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_3dGyroHwInfo::set_has_MountAngles () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_3dGyroHwInfo::clear_has_MountAngles () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_3dGyroHwInfo::set_has_RAxes () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_3dGyroHwInfo::clear_has_RAxes () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_3dGyroHwInfo::set_has_SAxes () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_3dGyroHwInfo::clear_has_SAxes () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_3dGyroHwInfo::set_has_TAxes () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_3dGyroHwInfo::clear_has_TAxes () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_3dAccHwInfo::T_3dAccHwInfo ()  :
    _SampleRate (0u),
    _MountAngles (),
    _RAxes (),
    _SAxes (),
    _TAxes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_3dAccHwInfo::T_3dAccHwInfo (const T_3dAccHwInfo &rhs)  :
    _SampleRate (0u),
    _MountAngles (),
    _RAxes (),
    _SAxes (),
    _TAxes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_3dAccHwInfo::T_3dAccHwInfo (uint32 SampleRate_, const T_3dMountAngles& MountAngles_, const T_SensorHwInfo& RAxes_, const T_SensorHwInfo& SAxes_, const T_SensorHwInfo& TAxes_)  :
    _SampleRate (SampleRate_),
    _MountAngles (MountAngles_),
    _RAxes (RAxes_),
    _SAxes (SAxes_),
    _TAxes (TAxes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_3dAccHwInfo::~T_3dAccHwInfo() {
}

inline T_3dAccHwInfo& T_3dAccHwInfo::operator = (const T_3dAccHwInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSampleRate()) {
            setSampleRate(rhs.getSampleRate());
        } else {
            clearSampleRate();
        }
        if (rhs.hasMountAngles()) {
            setMountAngles(rhs.getMountAngles());
        } else {
            clearMountAngles();
        }
        if (rhs.hasRAxes()) {
            setRAxes(rhs.getRAxes());
        } else {
            clearRAxes();
        }
        if (rhs.hasSAxes()) {
            setSAxes(rhs.getSAxes());
        } else {
            clearSAxes();
        }
        if (rhs.hasTAxes()) {
            setTAxes(rhs.getTAxes());
        } else {
            clearTAxes();
        }
    }
    return *this;
}

inline bool T_3dAccHwInfo::operator == (const T_3dAccHwInfo& rhs) const {
    return (((!hasSampleRate() && !rhs.hasSampleRate()) || getSampleRate() == rhs.getSampleRate()) &&
        ((!hasMountAngles() && !rhs.hasMountAngles()) || getMountAngles() == rhs.getMountAngles()) &&
        ((!hasRAxes() && !rhs.hasRAxes()) || getRAxes() == rhs.getRAxes()) &&
        ((!hasSAxes() && !rhs.hasSAxes()) || getSAxes() == rhs.getSAxes()) &&
        ((!hasTAxes() && !rhs.hasTAxes()) || getTAxes() == rhs.getTAxes()));
}

inline bool T_3dAccHwInfo::operator != (const T_3dAccHwInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_3dAccHwInfo::operator < (const T_3dAccHwInfo& rhs) const {
    if (hasSampleRate() || rhs.hasSampleRate()) {
        if (getSampleRate() < rhs.getSampleRate()) return true;
        if (getSampleRate() > rhs.getSampleRate()) return false;
    }
    if (hasMountAngles() || rhs.hasMountAngles()) {
        if (getMountAngles() < rhs.getMountAngles()) return true;
        if (getMountAngles() > rhs.getMountAngles()) return false;
    }
    if (hasRAxes() || rhs.hasRAxes()) {
        if (getRAxes() < rhs.getRAxes()) return true;
        if (getRAxes() > rhs.getRAxes()) return false;
    }
    if (hasSAxes() || rhs.hasSAxes()) {
        if (getSAxes() < rhs.getSAxes()) return true;
        if (getSAxes() > rhs.getSAxes()) return false;
    }
    if (hasTAxes() || rhs.hasTAxes()) {
        if (getTAxes() < rhs.getTAxes()) return true;
        if (getTAxes() > rhs.getTAxes()) return false;
    }
    return false;
}

inline bool T_3dAccHwInfo::operator > (const T_3dAccHwInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_3dAccHwInfo::clear() {
    clearSampleRate();
    clearMountAngles();
    clearRAxes();
    clearSAxes();
    clearTAxes();
}

inline void T_3dAccHwInfo::clearSampleRate() {
    if (hasSampleRate()) {
         clear_has_SampleRate();
        _SampleRate = 0u;
     }
}

inline bool T_3dAccHwInfo::hasSampleRate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_3dAccHwInfo::getSampleRate () const {
    return _SampleRate;
}

inline void T_3dAccHwInfo::setSampleRate (uint32 SampleRate_) {
    set_has_SampleRate();
    this->_SampleRate = SampleRate_;
}

inline void T_3dAccHwInfo::clearMountAngles() {
    if (hasMountAngles()) {
         clear_has_MountAngles();
        _MountAngles.clear();
     }
}

inline bool T_3dAccHwInfo::hasMountAngles () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_3dMountAngles& T_3dAccHwInfo::getMountAngles () const {
    return _MountAngles;
}

inline T_3dMountAngles& T_3dAccHwInfo::getMountAnglesMutable () {
    set_has_MountAngles();
    return _MountAngles;
}

inline void T_3dAccHwInfo::setMountAngles (const T_3dMountAngles& MountAngles_) {
    set_has_MountAngles();
    this->_MountAngles = MountAngles_;
}

inline void T_3dAccHwInfo::clearRAxes() {
    if (hasRAxes()) {
         clear_has_RAxes();
        _RAxes.clear();
     }
}

inline bool T_3dAccHwInfo::hasRAxes () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_SensorHwInfo& T_3dAccHwInfo::getRAxes () const {
    return _RAxes;
}

inline T_SensorHwInfo& T_3dAccHwInfo::getRAxesMutable () {
    set_has_RAxes();
    return _RAxes;
}

inline void T_3dAccHwInfo::setRAxes (const T_SensorHwInfo& RAxes_) {
    set_has_RAxes();
    this->_RAxes = RAxes_;
}

inline void T_3dAccHwInfo::clearSAxes() {
    if (hasSAxes()) {
         clear_has_SAxes();
        _SAxes.clear();
     }
}

inline bool T_3dAccHwInfo::hasSAxes () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_SensorHwInfo& T_3dAccHwInfo::getSAxes () const {
    return _SAxes;
}

inline T_SensorHwInfo& T_3dAccHwInfo::getSAxesMutable () {
    set_has_SAxes();
    return _SAxes;
}

inline void T_3dAccHwInfo::setSAxes (const T_SensorHwInfo& SAxes_) {
    set_has_SAxes();
    this->_SAxes = SAxes_;
}

inline void T_3dAccHwInfo::clearTAxes() {
    if (hasTAxes()) {
         clear_has_TAxes();
        _TAxes.clear();
     }
}

inline bool T_3dAccHwInfo::hasTAxes () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const T_SensorHwInfo& T_3dAccHwInfo::getTAxes () const {
    return _TAxes;
}

inline T_SensorHwInfo& T_3dAccHwInfo::getTAxesMutable () {
    set_has_TAxes();
    return _TAxes;
}

inline void T_3dAccHwInfo::setTAxes (const T_SensorHwInfo& TAxes_) {
    set_has_TAxes();
    this->_TAxes = TAxes_;
}

inline void T_3dAccHwInfo::set_has_SampleRate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_3dAccHwInfo::clear_has_SampleRate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_3dAccHwInfo::set_has_MountAngles () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_3dAccHwInfo::clear_has_MountAngles () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_3dAccHwInfo::set_has_RAxes () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_3dAccHwInfo::clear_has_RAxes () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_3dAccHwInfo::set_has_SAxes () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_3dAccHwInfo::clear_has_SAxes () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_3dAccHwInfo::set_has_TAxes () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_3dAccHwInfo::clear_has_TAxes () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_3dGyroData::T_3dGyroData ()  :
    _TimeStamp3dGyro (0u),
    _RVal (0u),
    _SVal (0u),
    _TVal (0u),
    _RStatus (::location_fi_types::T_e16_GyroStatus__GYROSTATE_CONNECTED_NORMAL),
    _SStatus (::location_fi_types::T_e16_GyroStatus__GYROSTATE_CONNECTED_NORMAL),
    _TStatus (::location_fi_types::T_e16_GyroStatus__GYROSTATE_CONNECTED_NORMAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_3dGyroData::T_3dGyroData (const T_3dGyroData &rhs)  :
    _TimeStamp3dGyro (0u),
    _RVal (0u),
    _SVal (0u),
    _TVal (0u),
    _RStatus (::location_fi_types::T_e16_GyroStatus__GYROSTATE_CONNECTED_NORMAL),
    _SStatus (::location_fi_types::T_e16_GyroStatus__GYROSTATE_CONNECTED_NORMAL),
    _TStatus (::location_fi_types::T_e16_GyroStatus__GYROSTATE_CONNECTED_NORMAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_3dGyroData::T_3dGyroData (uint32 TimeStamp3dGyro_, uint32 RVal_, uint32 SVal_, uint32 TVal_, T_e16_GyroStatus RStatus_, T_e16_GyroStatus SStatus_, T_e16_GyroStatus TStatus_)  :
    _TimeStamp3dGyro (TimeStamp3dGyro_),
    _RVal (RVal_),
    _SVal (SVal_),
    _TVal (TVal_),
    _RStatus (RStatus_),
    _SStatus (SStatus_),
    _TStatus (TStatus_)
{
    #ifndef NDEBUG
    if (!(T_e16_GyroStatus_IsValid(RStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RStatus_, "T_e16_GyroStatus", "RStatus", "T_3dGyroData");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e16_GyroStatus_IsValid(SStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SStatus_, "T_e16_GyroStatus", "SStatus", "T_3dGyroData");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e16_GyroStatus_IsValid(TStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TStatus_, "T_e16_GyroStatus", "TStatus", "T_3dGyroData");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_3dGyroData::~T_3dGyroData() {
}

inline T_3dGyroData& T_3dGyroData::operator = (const T_3dGyroData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTimeStamp3dGyro()) {
            setTimeStamp3dGyro(rhs.getTimeStamp3dGyro());
        } else {
            clearTimeStamp3dGyro();
        }
        if (rhs.hasRVal()) {
            setRVal(rhs.getRVal());
        } else {
            clearRVal();
        }
        if (rhs.hasSVal()) {
            setSVal(rhs.getSVal());
        } else {
            clearSVal();
        }
        if (rhs.hasTVal()) {
            setTVal(rhs.getTVal());
        } else {
            clearTVal();
        }
        if (rhs.hasRStatus()) {
            setRStatus(rhs.getRStatus());
        } else {
            clearRStatus();
        }
        if (rhs.hasSStatus()) {
            setSStatus(rhs.getSStatus());
        } else {
            clearSStatus();
        }
        if (rhs.hasTStatus()) {
            setTStatus(rhs.getTStatus());
        } else {
            clearTStatus();
        }
    }
    return *this;
}

inline bool T_3dGyroData::operator == (const T_3dGyroData& rhs) const {
    return (((!hasTimeStamp3dGyro() && !rhs.hasTimeStamp3dGyro()) || getTimeStamp3dGyro() == rhs.getTimeStamp3dGyro()) &&
        ((!hasRVal() && !rhs.hasRVal()) || getRVal() == rhs.getRVal()) &&
        ((!hasSVal() && !rhs.hasSVal()) || getSVal() == rhs.getSVal()) &&
        ((!hasTVal() && !rhs.hasTVal()) || getTVal() == rhs.getTVal()) &&
        ((!hasRStatus() && !rhs.hasRStatus()) || getRStatus() == rhs.getRStatus()) &&
        ((!hasSStatus() && !rhs.hasSStatus()) || getSStatus() == rhs.getSStatus()) &&
        ((!hasTStatus() && !rhs.hasTStatus()) || getTStatus() == rhs.getTStatus()));
}

inline bool T_3dGyroData::operator != (const T_3dGyroData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_3dGyroData::operator < (const T_3dGyroData& rhs) const {
    if (hasTimeStamp3dGyro() || rhs.hasTimeStamp3dGyro()) {
        if (getTimeStamp3dGyro() < rhs.getTimeStamp3dGyro()) return true;
        if (getTimeStamp3dGyro() > rhs.getTimeStamp3dGyro()) return false;
    }
    if (hasRVal() || rhs.hasRVal()) {
        if (getRVal() < rhs.getRVal()) return true;
        if (getRVal() > rhs.getRVal()) return false;
    }
    if (hasSVal() || rhs.hasSVal()) {
        if (getSVal() < rhs.getSVal()) return true;
        if (getSVal() > rhs.getSVal()) return false;
    }
    if (hasTVal() || rhs.hasTVal()) {
        if (getTVal() < rhs.getTVal()) return true;
        if (getTVal() > rhs.getTVal()) return false;
    }
    if (hasRStatus() || rhs.hasRStatus()) {
        if ((uint32)getRStatus() < (uint32)rhs.getRStatus()) return true;
        if ((uint32)getRStatus() > (uint32)rhs.getRStatus()) return false;
    }
    if (hasSStatus() || rhs.hasSStatus()) {
        if ((uint32)getSStatus() < (uint32)rhs.getSStatus()) return true;
        if ((uint32)getSStatus() > (uint32)rhs.getSStatus()) return false;
    }
    if (hasTStatus() || rhs.hasTStatus()) {
        if ((uint32)getTStatus() < (uint32)rhs.getTStatus()) return true;
        if ((uint32)getTStatus() > (uint32)rhs.getTStatus()) return false;
    }
    return false;
}

inline bool T_3dGyroData::operator > (const T_3dGyroData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_3dGyroData::clear() {
    clearTimeStamp3dGyro();
    clearRVal();
    clearSVal();
    clearTVal();
    clearRStatus();
    clearSStatus();
    clearTStatus();
}

inline void T_3dGyroData::clearTimeStamp3dGyro() {
    if (hasTimeStamp3dGyro()) {
         clear_has_TimeStamp3dGyro();
        _TimeStamp3dGyro = 0u;
     }
}

inline bool T_3dGyroData::hasTimeStamp3dGyro () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_3dGyroData::getTimeStamp3dGyro () const {
    return _TimeStamp3dGyro;
}

inline void T_3dGyroData::setTimeStamp3dGyro (uint32 TimeStamp3dGyro_) {
    set_has_TimeStamp3dGyro();
    this->_TimeStamp3dGyro = TimeStamp3dGyro_;
}

inline void T_3dGyroData::clearRVal() {
    if (hasRVal()) {
         clear_has_RVal();
        _RVal = 0u;
     }
}

inline bool T_3dGyroData::hasRVal () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_3dGyroData::getRVal () const {
    return _RVal;
}

inline void T_3dGyroData::setRVal (uint32 RVal_) {
    set_has_RVal();
    this->_RVal = RVal_;
}

inline void T_3dGyroData::clearSVal() {
    if (hasSVal()) {
         clear_has_SVal();
        _SVal = 0u;
     }
}

inline bool T_3dGyroData::hasSVal () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_3dGyroData::getSVal () const {
    return _SVal;
}

inline void T_3dGyroData::setSVal (uint32 SVal_) {
    set_has_SVal();
    this->_SVal = SVal_;
}

inline void T_3dGyroData::clearTVal() {
    if (hasTVal()) {
         clear_has_TVal();
        _TVal = 0u;
     }
}

inline bool T_3dGyroData::hasTVal () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_3dGyroData::getTVal () const {
    return _TVal;
}

inline void T_3dGyroData::setTVal (uint32 TVal_) {
    set_has_TVal();
    this->_TVal = TVal_;
}

inline void T_3dGyroData::clearRStatus() {
    if (hasRStatus()) {
         clear_has_RStatus();
        _RStatus = ::location_fi_types::T_e16_GyroStatus__GYROSTATE_CONNECTED_NORMAL;
     }
}

inline bool T_3dGyroData::hasRStatus () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e16_GyroStatus T_3dGyroData::getRStatus () const {
    return _RStatus;
}

inline void T_3dGyroData::setRStatus (T_e16_GyroStatus RStatus_) {
    #ifndef NDEBUG
    if (!(T_e16_GyroStatus_IsValid(RStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RStatus_, "T_e16_GyroStatus", "RStatus", "T_3dGyroData");
    }
    #endif
    set_has_RStatus();
    this->_RStatus = RStatus_;
}

inline void T_3dGyroData::clearSStatus() {
    if (hasSStatus()) {
         clear_has_SStatus();
        _SStatus = ::location_fi_types::T_e16_GyroStatus__GYROSTATE_CONNECTED_NORMAL;
     }
}

inline bool T_3dGyroData::hasSStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e16_GyroStatus T_3dGyroData::getSStatus () const {
    return _SStatus;
}

inline void T_3dGyroData::setSStatus (T_e16_GyroStatus SStatus_) {
    #ifndef NDEBUG
    if (!(T_e16_GyroStatus_IsValid(SStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SStatus_, "T_e16_GyroStatus", "SStatus", "T_3dGyroData");
    }
    #endif
    set_has_SStatus();
    this->_SStatus = SStatus_;
}

inline void T_3dGyroData::clearTStatus() {
    if (hasTStatus()) {
         clear_has_TStatus();
        _TStatus = ::location_fi_types::T_e16_GyroStatus__GYROSTATE_CONNECTED_NORMAL;
     }
}

inline bool T_3dGyroData::hasTStatus () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e16_GyroStatus T_3dGyroData::getTStatus () const {
    return _TStatus;
}

inline void T_3dGyroData::setTStatus (T_e16_GyroStatus TStatus_) {
    #ifndef NDEBUG
    if (!(T_e16_GyroStatus_IsValid(TStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TStatus_, "T_e16_GyroStatus", "TStatus", "T_3dGyroData");
    }
    #endif
    set_has_TStatus();
    this->_TStatus = TStatus_;
}

inline void T_3dGyroData::set_has_TimeStamp3dGyro () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_3dGyroData::clear_has_TimeStamp3dGyro () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_3dGyroData::set_has_RVal () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_3dGyroData::clear_has_RVal () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_3dGyroData::set_has_SVal () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_3dGyroData::clear_has_SVal () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_3dGyroData::set_has_TVal () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_3dGyroData::clear_has_TVal () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_3dGyroData::set_has_RStatus () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_3dGyroData::clear_has_RStatus () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_3dGyroData::set_has_SStatus () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_3dGyroData::clear_has_SStatus () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_3dGyroData::set_has_TStatus () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_3dGyroData::clear_has_TStatus () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_3dAccData::T_3dAccData ()  :
    _TimeStamp3dAcc (0u),
    _RVal (0u),
    _SVal (0u),
    _TVal (0u),
    _RStatus (::location_fi_types::T_e16_AccStatus__ACCSTATE_CONNECTED_NORMAL),
    _SStatus (::location_fi_types::T_e16_AccStatus__ACCSTATE_CONNECTED_NORMAL),
    _TStatus (::location_fi_types::T_e16_AccStatus__ACCSTATE_CONNECTED_NORMAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_3dAccData::T_3dAccData (const T_3dAccData &rhs)  :
    _TimeStamp3dAcc (0u),
    _RVal (0u),
    _SVal (0u),
    _TVal (0u),
    _RStatus (::location_fi_types::T_e16_AccStatus__ACCSTATE_CONNECTED_NORMAL),
    _SStatus (::location_fi_types::T_e16_AccStatus__ACCSTATE_CONNECTED_NORMAL),
    _TStatus (::location_fi_types::T_e16_AccStatus__ACCSTATE_CONNECTED_NORMAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_3dAccData::T_3dAccData (uint32 TimeStamp3dAcc_, uint32 RVal_, uint32 SVal_, uint32 TVal_, T_e16_AccStatus RStatus_, T_e16_AccStatus SStatus_, T_e16_AccStatus TStatus_)  :
    _TimeStamp3dAcc (TimeStamp3dAcc_),
    _RVal (RVal_),
    _SVal (SVal_),
    _TVal (TVal_),
    _RStatus (RStatus_),
    _SStatus (SStatus_),
    _TStatus (TStatus_)
{
    #ifndef NDEBUG
    if (!(T_e16_AccStatus_IsValid(RStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RStatus_, "T_e16_AccStatus", "RStatus", "T_3dAccData");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e16_AccStatus_IsValid(SStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SStatus_, "T_e16_AccStatus", "SStatus", "T_3dAccData");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e16_AccStatus_IsValid(TStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TStatus_, "T_e16_AccStatus", "TStatus", "T_3dAccData");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_3dAccData::~T_3dAccData() {
}

inline T_3dAccData& T_3dAccData::operator = (const T_3dAccData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTimeStamp3dAcc()) {
            setTimeStamp3dAcc(rhs.getTimeStamp3dAcc());
        } else {
            clearTimeStamp3dAcc();
        }
        if (rhs.hasRVal()) {
            setRVal(rhs.getRVal());
        } else {
            clearRVal();
        }
        if (rhs.hasSVal()) {
            setSVal(rhs.getSVal());
        } else {
            clearSVal();
        }
        if (rhs.hasTVal()) {
            setTVal(rhs.getTVal());
        } else {
            clearTVal();
        }
        if (rhs.hasRStatus()) {
            setRStatus(rhs.getRStatus());
        } else {
            clearRStatus();
        }
        if (rhs.hasSStatus()) {
            setSStatus(rhs.getSStatus());
        } else {
            clearSStatus();
        }
        if (rhs.hasTStatus()) {
            setTStatus(rhs.getTStatus());
        } else {
            clearTStatus();
        }
    }
    return *this;
}

inline bool T_3dAccData::operator == (const T_3dAccData& rhs) const {
    return (((!hasTimeStamp3dAcc() && !rhs.hasTimeStamp3dAcc()) || getTimeStamp3dAcc() == rhs.getTimeStamp3dAcc()) &&
        ((!hasRVal() && !rhs.hasRVal()) || getRVal() == rhs.getRVal()) &&
        ((!hasSVal() && !rhs.hasSVal()) || getSVal() == rhs.getSVal()) &&
        ((!hasTVal() && !rhs.hasTVal()) || getTVal() == rhs.getTVal()) &&
        ((!hasRStatus() && !rhs.hasRStatus()) || getRStatus() == rhs.getRStatus()) &&
        ((!hasSStatus() && !rhs.hasSStatus()) || getSStatus() == rhs.getSStatus()) &&
        ((!hasTStatus() && !rhs.hasTStatus()) || getTStatus() == rhs.getTStatus()));
}

inline bool T_3dAccData::operator != (const T_3dAccData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_3dAccData::operator < (const T_3dAccData& rhs) const {
    if (hasTimeStamp3dAcc() || rhs.hasTimeStamp3dAcc()) {
        if (getTimeStamp3dAcc() < rhs.getTimeStamp3dAcc()) return true;
        if (getTimeStamp3dAcc() > rhs.getTimeStamp3dAcc()) return false;
    }
    if (hasRVal() || rhs.hasRVal()) {
        if (getRVal() < rhs.getRVal()) return true;
        if (getRVal() > rhs.getRVal()) return false;
    }
    if (hasSVal() || rhs.hasSVal()) {
        if (getSVal() < rhs.getSVal()) return true;
        if (getSVal() > rhs.getSVal()) return false;
    }
    if (hasTVal() || rhs.hasTVal()) {
        if (getTVal() < rhs.getTVal()) return true;
        if (getTVal() > rhs.getTVal()) return false;
    }
    if (hasRStatus() || rhs.hasRStatus()) {
        if ((uint32)getRStatus() < (uint32)rhs.getRStatus()) return true;
        if ((uint32)getRStatus() > (uint32)rhs.getRStatus()) return false;
    }
    if (hasSStatus() || rhs.hasSStatus()) {
        if ((uint32)getSStatus() < (uint32)rhs.getSStatus()) return true;
        if ((uint32)getSStatus() > (uint32)rhs.getSStatus()) return false;
    }
    if (hasTStatus() || rhs.hasTStatus()) {
        if ((uint32)getTStatus() < (uint32)rhs.getTStatus()) return true;
        if ((uint32)getTStatus() > (uint32)rhs.getTStatus()) return false;
    }
    return false;
}

inline bool T_3dAccData::operator > (const T_3dAccData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_3dAccData::clear() {
    clearTimeStamp3dAcc();
    clearRVal();
    clearSVal();
    clearTVal();
    clearRStatus();
    clearSStatus();
    clearTStatus();
}

inline void T_3dAccData::clearTimeStamp3dAcc() {
    if (hasTimeStamp3dAcc()) {
         clear_has_TimeStamp3dAcc();
        _TimeStamp3dAcc = 0u;
     }
}

inline bool T_3dAccData::hasTimeStamp3dAcc () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_3dAccData::getTimeStamp3dAcc () const {
    return _TimeStamp3dAcc;
}

inline void T_3dAccData::setTimeStamp3dAcc (uint32 TimeStamp3dAcc_) {
    set_has_TimeStamp3dAcc();
    this->_TimeStamp3dAcc = TimeStamp3dAcc_;
}

inline void T_3dAccData::clearRVal() {
    if (hasRVal()) {
         clear_has_RVal();
        _RVal = 0u;
     }
}

inline bool T_3dAccData::hasRVal () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_3dAccData::getRVal () const {
    return _RVal;
}

inline void T_3dAccData::setRVal (uint32 RVal_) {
    set_has_RVal();
    this->_RVal = RVal_;
}

inline void T_3dAccData::clearSVal() {
    if (hasSVal()) {
         clear_has_SVal();
        _SVal = 0u;
     }
}

inline bool T_3dAccData::hasSVal () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_3dAccData::getSVal () const {
    return _SVal;
}

inline void T_3dAccData::setSVal (uint32 SVal_) {
    set_has_SVal();
    this->_SVal = SVal_;
}

inline void T_3dAccData::clearTVal() {
    if (hasTVal()) {
         clear_has_TVal();
        _TVal = 0u;
     }
}

inline bool T_3dAccData::hasTVal () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_3dAccData::getTVal () const {
    return _TVal;
}

inline void T_3dAccData::setTVal (uint32 TVal_) {
    set_has_TVal();
    this->_TVal = TVal_;
}

inline void T_3dAccData::clearRStatus() {
    if (hasRStatus()) {
         clear_has_RStatus();
        _RStatus = ::location_fi_types::T_e16_AccStatus__ACCSTATE_CONNECTED_NORMAL;
     }
}

inline bool T_3dAccData::hasRStatus () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e16_AccStatus T_3dAccData::getRStatus () const {
    return _RStatus;
}

inline void T_3dAccData::setRStatus (T_e16_AccStatus RStatus_) {
    #ifndef NDEBUG
    if (!(T_e16_AccStatus_IsValid(RStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RStatus_, "T_e16_AccStatus", "RStatus", "T_3dAccData");
    }
    #endif
    set_has_RStatus();
    this->_RStatus = RStatus_;
}

inline void T_3dAccData::clearSStatus() {
    if (hasSStatus()) {
         clear_has_SStatus();
        _SStatus = ::location_fi_types::T_e16_AccStatus__ACCSTATE_CONNECTED_NORMAL;
     }
}

inline bool T_3dAccData::hasSStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e16_AccStatus T_3dAccData::getSStatus () const {
    return _SStatus;
}

inline void T_3dAccData::setSStatus (T_e16_AccStatus SStatus_) {
    #ifndef NDEBUG
    if (!(T_e16_AccStatus_IsValid(SStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SStatus_, "T_e16_AccStatus", "SStatus", "T_3dAccData");
    }
    #endif
    set_has_SStatus();
    this->_SStatus = SStatus_;
}

inline void T_3dAccData::clearTStatus() {
    if (hasTStatus()) {
         clear_has_TStatus();
        _TStatus = ::location_fi_types::T_e16_AccStatus__ACCSTATE_CONNECTED_NORMAL;
     }
}

inline bool T_3dAccData::hasTStatus () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e16_AccStatus T_3dAccData::getTStatus () const {
    return _TStatus;
}

inline void T_3dAccData::setTStatus (T_e16_AccStatus TStatus_) {
    #ifndef NDEBUG
    if (!(T_e16_AccStatus_IsValid(TStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TStatus_, "T_e16_AccStatus", "TStatus", "T_3dAccData");
    }
    #endif
    set_has_TStatus();
    this->_TStatus = TStatus_;
}

inline void T_3dAccData::set_has_TimeStamp3dAcc () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_3dAccData::clear_has_TimeStamp3dAcc () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_3dAccData::set_has_RVal () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_3dAccData::clear_has_RVal () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_3dAccData::set_has_SVal () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_3dAccData::clear_has_SVal () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_3dAccData::set_has_TVal () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_3dAccData::clear_has_TVal () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_3dAccData::set_has_RStatus () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_3dAccData::clear_has_RStatus () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_3dAccData::set_has_SStatus () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_3dAccData::clear_has_SStatus () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_3dAccData::set_has_TStatus () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_3dAccData::clear_has_TStatus () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_b8_GnssSatSys::T_b8_GnssSatSys ()  :
    _GNSS_SATSYS_GPS (false),
    _GNSS_SATSYS_GLONASS (false),
    _GNSS_SATSYS_GALILEO (false),
    _GNSS_SATSYS_COMPASS (false),
    _GNSS_SATSYS_SBAS (false),
    _GNSS_SATSYS_QZSS (false)
{
}

inline  T_b8_GnssSatSys::T_b8_GnssSatSys (const T_b8_GnssSatSys &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_GnssSatSys::T_b8_GnssSatSys (bool GNSS_SATSYS_GPS, bool GNSS_SATSYS_GLONASS, bool GNSS_SATSYS_GALILEO, bool GNSS_SATSYS_COMPASS, bool GNSS_SATSYS_SBAS, bool GNSS_SATSYS_QZSS) :
    _GNSS_SATSYS_GPS (GNSS_SATSYS_GPS),
    _GNSS_SATSYS_GLONASS (GNSS_SATSYS_GLONASS),
    _GNSS_SATSYS_GALILEO (GNSS_SATSYS_GALILEO),
    _GNSS_SATSYS_COMPASS (GNSS_SATSYS_COMPASS),
    _GNSS_SATSYS_SBAS (GNSS_SATSYS_SBAS),
    _GNSS_SATSYS_QZSS (GNSS_SATSYS_QZSS)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_GnssSatSys& T_b8_GnssSatSys::operator = (const T_b8_GnssSatSys& rhs) {
    if( this != &rhs ) {
        _GNSS_SATSYS_GPS = rhs._GNSS_SATSYS_GPS;
        _GNSS_SATSYS_GLONASS = rhs._GNSS_SATSYS_GLONASS;
        _GNSS_SATSYS_GALILEO = rhs._GNSS_SATSYS_GALILEO;
        _GNSS_SATSYS_COMPASS = rhs._GNSS_SATSYS_COMPASS;
        _GNSS_SATSYS_SBAS = rhs._GNSS_SATSYS_SBAS;
        _GNSS_SATSYS_QZSS = rhs._GNSS_SATSYS_QZSS;
    }
    return *this;
}

inline bool T_b8_GnssSatSys::operator == (const T_b8_GnssSatSys& rhs) const {
    return (_GNSS_SATSYS_GPS == rhs._GNSS_SATSYS_GPS &&
        _GNSS_SATSYS_GLONASS == rhs._GNSS_SATSYS_GLONASS &&
        _GNSS_SATSYS_GALILEO == rhs._GNSS_SATSYS_GALILEO &&
        _GNSS_SATSYS_COMPASS == rhs._GNSS_SATSYS_COMPASS &&
        _GNSS_SATSYS_SBAS == rhs._GNSS_SATSYS_SBAS &&
        _GNSS_SATSYS_QZSS == rhs._GNSS_SATSYS_QZSS);
}

inline bool T_b8_GnssSatSys::operator != (const T_b8_GnssSatSys& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_GnssSatSys::operator < (const T_b8_GnssSatSys& rhs) const {
    if (getGNSS_SATSYS_GPS() < rhs.getGNSS_SATSYS_GPS()) return true;
    if (getGNSS_SATSYS_GPS() > rhs.getGNSS_SATSYS_GPS()) return false;

    if (getGNSS_SATSYS_GLONASS() < rhs.getGNSS_SATSYS_GLONASS()) return true;
    if (getGNSS_SATSYS_GLONASS() > rhs.getGNSS_SATSYS_GLONASS()) return false;

    if (getGNSS_SATSYS_GALILEO() < rhs.getGNSS_SATSYS_GALILEO()) return true;
    if (getGNSS_SATSYS_GALILEO() > rhs.getGNSS_SATSYS_GALILEO()) return false;

    if (getGNSS_SATSYS_COMPASS() < rhs.getGNSS_SATSYS_COMPASS()) return true;
    if (getGNSS_SATSYS_COMPASS() > rhs.getGNSS_SATSYS_COMPASS()) return false;

    if (getGNSS_SATSYS_SBAS() < rhs.getGNSS_SATSYS_SBAS()) return true;
    if (getGNSS_SATSYS_SBAS() > rhs.getGNSS_SATSYS_SBAS()) return false;

    if (getGNSS_SATSYS_QZSS() < rhs.getGNSS_SATSYS_QZSS()) return true;
    if (getGNSS_SATSYS_QZSS() > rhs.getGNSS_SATSYS_QZSS()) return false;

    return false;
}

inline bool T_b8_GnssSatSys::operator > (const T_b8_GnssSatSys& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_GnssSatSys::setGNSS_SATSYS_GPS (bool GNSS_SATSYS_GPS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GNSS_SATSYS_GPS = GNSS_SATSYS_GPS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_GnssSatSys::getGNSS_SATSYS_GPS () const {
    return _GNSS_SATSYS_GPS;
}

inline void T_b8_GnssSatSys::setGNSS_SATSYS_GLONASS (bool GNSS_SATSYS_GLONASS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GNSS_SATSYS_GLONASS = GNSS_SATSYS_GLONASS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_GnssSatSys::getGNSS_SATSYS_GLONASS () const {
    return _GNSS_SATSYS_GLONASS;
}

inline void T_b8_GnssSatSys::setGNSS_SATSYS_GALILEO (bool GNSS_SATSYS_GALILEO) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GNSS_SATSYS_GALILEO = GNSS_SATSYS_GALILEO;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_GnssSatSys::getGNSS_SATSYS_GALILEO () const {
    return _GNSS_SATSYS_GALILEO;
}

inline void T_b8_GnssSatSys::setGNSS_SATSYS_COMPASS (bool GNSS_SATSYS_COMPASS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GNSS_SATSYS_COMPASS = GNSS_SATSYS_COMPASS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_GnssSatSys::getGNSS_SATSYS_COMPASS () const {
    return _GNSS_SATSYS_COMPASS;
}

inline void T_b8_GnssSatSys::setGNSS_SATSYS_SBAS (bool GNSS_SATSYS_SBAS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GNSS_SATSYS_SBAS = GNSS_SATSYS_SBAS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_GnssSatSys::getGNSS_SATSYS_SBAS () const {
    return _GNSS_SATSYS_SBAS;
}

inline void T_b8_GnssSatSys::setGNSS_SATSYS_QZSS (bool GNSS_SATSYS_QZSS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GNSS_SATSYS_QZSS = GNSS_SATSYS_QZSS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_GnssSatSys::getGNSS_SATSYS_QZSS () const {
    return _GNSS_SATSYS_QZSS;
}

inline  T_b8_GnssSatStatus::T_b8_GnssSatStatus ()  :
    _SAT_HEALTHY (false),
    _SAT_ALMANAC_AVAILABLE (false),
    _SAT_EPHEMERIS_AVAILABLE (false),
    _SAT_DGPS_AVAILABLE (false),
    _SAT_TRACKED (false),
    _SAT_USED_FOR_POSCALC (false)
{
}

inline  T_b8_GnssSatStatus::T_b8_GnssSatStatus (const T_b8_GnssSatStatus &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_GnssSatStatus::T_b8_GnssSatStatus (bool SAT_HEALTHY, bool SAT_ALMANAC_AVAILABLE, bool SAT_EPHEMERIS_AVAILABLE, bool SAT_DGPS_AVAILABLE, bool SAT_TRACKED, bool SAT_USED_FOR_POSCALC) :
    _SAT_HEALTHY (SAT_HEALTHY),
    _SAT_ALMANAC_AVAILABLE (SAT_ALMANAC_AVAILABLE),
    _SAT_EPHEMERIS_AVAILABLE (SAT_EPHEMERIS_AVAILABLE),
    _SAT_DGPS_AVAILABLE (SAT_DGPS_AVAILABLE),
    _SAT_TRACKED (SAT_TRACKED),
    _SAT_USED_FOR_POSCALC (SAT_USED_FOR_POSCALC)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_GnssSatStatus& T_b8_GnssSatStatus::operator = (const T_b8_GnssSatStatus& rhs) {
    if( this != &rhs ) {
        _SAT_HEALTHY = rhs._SAT_HEALTHY;
        _SAT_ALMANAC_AVAILABLE = rhs._SAT_ALMANAC_AVAILABLE;
        _SAT_EPHEMERIS_AVAILABLE = rhs._SAT_EPHEMERIS_AVAILABLE;
        _SAT_DGPS_AVAILABLE = rhs._SAT_DGPS_AVAILABLE;
        _SAT_TRACKED = rhs._SAT_TRACKED;
        _SAT_USED_FOR_POSCALC = rhs._SAT_USED_FOR_POSCALC;
    }
    return *this;
}

inline bool T_b8_GnssSatStatus::operator == (const T_b8_GnssSatStatus& rhs) const {
    return (_SAT_HEALTHY == rhs._SAT_HEALTHY &&
        _SAT_ALMANAC_AVAILABLE == rhs._SAT_ALMANAC_AVAILABLE &&
        _SAT_EPHEMERIS_AVAILABLE == rhs._SAT_EPHEMERIS_AVAILABLE &&
        _SAT_DGPS_AVAILABLE == rhs._SAT_DGPS_AVAILABLE &&
        _SAT_TRACKED == rhs._SAT_TRACKED &&
        _SAT_USED_FOR_POSCALC == rhs._SAT_USED_FOR_POSCALC);
}

inline bool T_b8_GnssSatStatus::operator != (const T_b8_GnssSatStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_GnssSatStatus::operator < (const T_b8_GnssSatStatus& rhs) const {
    if (getSAT_HEALTHY() < rhs.getSAT_HEALTHY()) return true;
    if (getSAT_HEALTHY() > rhs.getSAT_HEALTHY()) return false;

    if (getSAT_ALMANAC_AVAILABLE() < rhs.getSAT_ALMANAC_AVAILABLE()) return true;
    if (getSAT_ALMANAC_AVAILABLE() > rhs.getSAT_ALMANAC_AVAILABLE()) return false;

    if (getSAT_EPHEMERIS_AVAILABLE() < rhs.getSAT_EPHEMERIS_AVAILABLE()) return true;
    if (getSAT_EPHEMERIS_AVAILABLE() > rhs.getSAT_EPHEMERIS_AVAILABLE()) return false;

    if (getSAT_DGPS_AVAILABLE() < rhs.getSAT_DGPS_AVAILABLE()) return true;
    if (getSAT_DGPS_AVAILABLE() > rhs.getSAT_DGPS_AVAILABLE()) return false;

    if (getSAT_TRACKED() < rhs.getSAT_TRACKED()) return true;
    if (getSAT_TRACKED() > rhs.getSAT_TRACKED()) return false;

    if (getSAT_USED_FOR_POSCALC() < rhs.getSAT_USED_FOR_POSCALC()) return true;
    if (getSAT_USED_FOR_POSCALC() > rhs.getSAT_USED_FOR_POSCALC()) return false;

    return false;
}

inline bool T_b8_GnssSatStatus::operator > (const T_b8_GnssSatStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_GnssSatStatus::setSAT_HEALTHY (bool SAT_HEALTHY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SAT_HEALTHY = SAT_HEALTHY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_GnssSatStatus::getSAT_HEALTHY () const {
    return _SAT_HEALTHY;
}

inline void T_b8_GnssSatStatus::setSAT_ALMANAC_AVAILABLE (bool SAT_ALMANAC_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SAT_ALMANAC_AVAILABLE = SAT_ALMANAC_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_GnssSatStatus::getSAT_ALMANAC_AVAILABLE () const {
    return _SAT_ALMANAC_AVAILABLE;
}

inline void T_b8_GnssSatStatus::setSAT_EPHEMERIS_AVAILABLE (bool SAT_EPHEMERIS_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SAT_EPHEMERIS_AVAILABLE = SAT_EPHEMERIS_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_GnssSatStatus::getSAT_EPHEMERIS_AVAILABLE () const {
    return _SAT_EPHEMERIS_AVAILABLE;
}

inline void T_b8_GnssSatStatus::setSAT_DGPS_AVAILABLE (bool SAT_DGPS_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SAT_DGPS_AVAILABLE = SAT_DGPS_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_GnssSatStatus::getSAT_DGPS_AVAILABLE () const {
    return _SAT_DGPS_AVAILABLE;
}

inline void T_b8_GnssSatStatus::setSAT_TRACKED (bool SAT_TRACKED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SAT_TRACKED = SAT_TRACKED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_GnssSatStatus::getSAT_TRACKED () const {
    return _SAT_TRACKED;
}

inline void T_b8_GnssSatStatus::setSAT_USED_FOR_POSCALC (bool SAT_USED_FOR_POSCALC) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SAT_USED_FOR_POSCALC = SAT_USED_FOR_POSCALC;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_GnssSatStatus::getSAT_USED_FOR_POSCALC () const {
    return _SAT_USED_FOR_POSCALC;
}

inline  T_GnssConfigData::T_GnssConfigData ()  :
    _GnssHardwareType (::location_fi_types::T_e8_GnssHw__GNSS_HW_GPS1_4),
    _GnssReceiverFirmwareVersion (0u),
    _GnssReceiverFirmwareCrc (0u),
    _NumberOfChannels (0u),
    _UsedSatStatusBits (),
    _UpdateFrequency (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_GnssConfigData::T_GnssConfigData (const T_GnssConfigData &rhs)  :
    _GnssHardwareType (::location_fi_types::T_e8_GnssHw__GNSS_HW_GPS1_4),
    _GnssReceiverFirmwareVersion (0u),
    _GnssReceiverFirmwareCrc (0u),
    _NumberOfChannels (0u),
    _UsedSatStatusBits (),
    _UpdateFrequency (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_GnssConfigData::T_GnssConfigData (T_e8_GnssHw GnssHardwareType_, uint32 GnssReceiverFirmwareVersion_, uint32 GnssReceiverFirmwareCrc_, uint16 NumberOfChannels_, const T_b8_GnssSatStatus& UsedSatStatusBits_, uint8 UpdateFrequency_)  :
    _GnssHardwareType (GnssHardwareType_),
    _GnssReceiverFirmwareVersion (GnssReceiverFirmwareVersion_),
    _GnssReceiverFirmwareCrc (GnssReceiverFirmwareCrc_),
    _NumberOfChannels (NumberOfChannels_),
    _UsedSatStatusBits (UsedSatStatusBits_),
    _UpdateFrequency (UpdateFrequency_)
{
    #ifndef NDEBUG
    if (!(T_e8_GnssHw_IsValid(GnssHardwareType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GnssHardwareType_, "T_e8_GnssHw", "GnssHardwareType", "T_GnssConfigData");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_GnssConfigData::~T_GnssConfigData() {
}

inline T_GnssConfigData& T_GnssConfigData::operator = (const T_GnssConfigData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGnssHardwareType()) {
            setGnssHardwareType(rhs.getGnssHardwareType());
        } else {
            clearGnssHardwareType();
        }
        if (rhs.hasGnssReceiverFirmwareVersion()) {
            setGnssReceiverFirmwareVersion(rhs.getGnssReceiverFirmwareVersion());
        } else {
            clearGnssReceiverFirmwareVersion();
        }
        if (rhs.hasGnssReceiverFirmwareCrc()) {
            setGnssReceiverFirmwareCrc(rhs.getGnssReceiverFirmwareCrc());
        } else {
            clearGnssReceiverFirmwareCrc();
        }
        if (rhs.hasNumberOfChannels()) {
            setNumberOfChannels(rhs.getNumberOfChannels());
        } else {
            clearNumberOfChannels();
        }
        if (rhs.hasUsedSatStatusBits()) {
            setUsedSatStatusBits(rhs.getUsedSatStatusBits());
        } else {
            clearUsedSatStatusBits();
        }
        if (rhs.hasUpdateFrequency()) {
            setUpdateFrequency(rhs.getUpdateFrequency());
        } else {
            clearUpdateFrequency();
        }
    }
    return *this;
}

inline bool T_GnssConfigData::operator == (const T_GnssConfigData& rhs) const {
    return (((!hasGnssHardwareType() && !rhs.hasGnssHardwareType()) || getGnssHardwareType() == rhs.getGnssHardwareType()) &&
        ((!hasGnssReceiverFirmwareVersion() && !rhs.hasGnssReceiverFirmwareVersion()) || getGnssReceiverFirmwareVersion() == rhs.getGnssReceiverFirmwareVersion()) &&
        ((!hasGnssReceiverFirmwareCrc() && !rhs.hasGnssReceiverFirmwareCrc()) || getGnssReceiverFirmwareCrc() == rhs.getGnssReceiverFirmwareCrc()) &&
        ((!hasNumberOfChannels() && !rhs.hasNumberOfChannels()) || getNumberOfChannels() == rhs.getNumberOfChannels()) &&
        ((!hasUsedSatStatusBits() && !rhs.hasUsedSatStatusBits()) || getUsedSatStatusBits() == rhs.getUsedSatStatusBits()) &&
        ((!hasUpdateFrequency() && !rhs.hasUpdateFrequency()) || getUpdateFrequency() == rhs.getUpdateFrequency()));
}

inline bool T_GnssConfigData::operator != (const T_GnssConfigData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_GnssConfigData::operator < (const T_GnssConfigData& rhs) const {
    if (hasGnssHardwareType() || rhs.hasGnssHardwareType()) {
        if ((uint32)getGnssHardwareType() < (uint32)rhs.getGnssHardwareType()) return true;
        if ((uint32)getGnssHardwareType() > (uint32)rhs.getGnssHardwareType()) return false;
    }
    if (hasGnssReceiverFirmwareVersion() || rhs.hasGnssReceiverFirmwareVersion()) {
        if (getGnssReceiverFirmwareVersion() < rhs.getGnssReceiverFirmwareVersion()) return true;
        if (getGnssReceiverFirmwareVersion() > rhs.getGnssReceiverFirmwareVersion()) return false;
    }
    if (hasGnssReceiverFirmwareCrc() || rhs.hasGnssReceiverFirmwareCrc()) {
        if (getGnssReceiverFirmwareCrc() < rhs.getGnssReceiverFirmwareCrc()) return true;
        if (getGnssReceiverFirmwareCrc() > rhs.getGnssReceiverFirmwareCrc()) return false;
    }
    if (hasNumberOfChannels() || rhs.hasNumberOfChannels()) {
        if (getNumberOfChannels() < rhs.getNumberOfChannels()) return true;
        if (getNumberOfChannels() > rhs.getNumberOfChannels()) return false;
    }
    if (hasUsedSatStatusBits() || rhs.hasUsedSatStatusBits()) {
        if (getUsedSatStatusBits() < rhs.getUsedSatStatusBits()) return true;
        if (getUsedSatStatusBits() > rhs.getUsedSatStatusBits()) return false;
    }
    if (hasUpdateFrequency() || rhs.hasUpdateFrequency()) {
        if (getUpdateFrequency() < rhs.getUpdateFrequency()) return true;
        if (getUpdateFrequency() > rhs.getUpdateFrequency()) return false;
    }
    return false;
}

inline bool T_GnssConfigData::operator > (const T_GnssConfigData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_GnssConfigData::clear() {
    clearGnssHardwareType();
    clearGnssReceiverFirmwareVersion();
    clearGnssReceiverFirmwareCrc();
    clearNumberOfChannels();
    clearUsedSatStatusBits();
    clearUpdateFrequency();
}

inline void T_GnssConfigData::clearGnssHardwareType() {
    if (hasGnssHardwareType()) {
         clear_has_GnssHardwareType();
        _GnssHardwareType = ::location_fi_types::T_e8_GnssHw__GNSS_HW_GPS1_4;
     }
}

inline bool T_GnssConfigData::hasGnssHardwareType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_GnssHw T_GnssConfigData::getGnssHardwareType () const {
    return _GnssHardwareType;
}

inline void T_GnssConfigData::setGnssHardwareType (T_e8_GnssHw GnssHardwareType_) {
    #ifndef NDEBUG
    if (!(T_e8_GnssHw_IsValid(GnssHardwareType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GnssHardwareType_, "T_e8_GnssHw", "GnssHardwareType", "T_GnssConfigData");
    }
    #endif
    set_has_GnssHardwareType();
    this->_GnssHardwareType = GnssHardwareType_;
}

inline void T_GnssConfigData::clearGnssReceiverFirmwareVersion() {
    if (hasGnssReceiverFirmwareVersion()) {
         clear_has_GnssReceiverFirmwareVersion();
        _GnssReceiverFirmwareVersion = 0u;
     }
}

inline bool T_GnssConfigData::hasGnssReceiverFirmwareVersion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_GnssConfigData::getGnssReceiverFirmwareVersion () const {
    return _GnssReceiverFirmwareVersion;
}

inline void T_GnssConfigData::setGnssReceiverFirmwareVersion (uint32 GnssReceiverFirmwareVersion_) {
    set_has_GnssReceiverFirmwareVersion();
    this->_GnssReceiverFirmwareVersion = GnssReceiverFirmwareVersion_;
}

inline void T_GnssConfigData::clearGnssReceiverFirmwareCrc() {
    if (hasGnssReceiverFirmwareCrc()) {
         clear_has_GnssReceiverFirmwareCrc();
        _GnssReceiverFirmwareCrc = 0u;
     }
}

inline bool T_GnssConfigData::hasGnssReceiverFirmwareCrc () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_GnssConfigData::getGnssReceiverFirmwareCrc () const {
    return _GnssReceiverFirmwareCrc;
}

inline void T_GnssConfigData::setGnssReceiverFirmwareCrc (uint32 GnssReceiverFirmwareCrc_) {
    set_has_GnssReceiverFirmwareCrc();
    this->_GnssReceiverFirmwareCrc = GnssReceiverFirmwareCrc_;
}

inline void T_GnssConfigData::clearNumberOfChannels() {
    if (hasNumberOfChannels()) {
         clear_has_NumberOfChannels();
        _NumberOfChannels = 0u;
     }
}

inline bool T_GnssConfigData::hasNumberOfChannels () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_GnssConfigData::getNumberOfChannels () const {
    return _NumberOfChannels;
}

inline void T_GnssConfigData::setNumberOfChannels (uint16 NumberOfChannels_) {
    set_has_NumberOfChannels();
    this->_NumberOfChannels = NumberOfChannels_;
}

inline void T_GnssConfigData::clearUsedSatStatusBits() {
    if (hasUsedSatStatusBits()) {
         clear_has_UsedSatStatusBits();
        _UsedSatStatusBits = T_b8_GnssSatStatus ();
     }
}

inline bool T_GnssConfigData::hasUsedSatStatusBits () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const T_b8_GnssSatStatus& T_GnssConfigData::getUsedSatStatusBits () const {
    return _UsedSatStatusBits;
}

inline T_b8_GnssSatStatus& T_GnssConfigData::getUsedSatStatusBitsMutable () {
    set_has_UsedSatStatusBits();
    return _UsedSatStatusBits;
}

inline void T_GnssConfigData::setUsedSatStatusBits (const T_b8_GnssSatStatus& UsedSatStatusBits_) {
    set_has_UsedSatStatusBits();
    this->_UsedSatStatusBits = UsedSatStatusBits_;
}

inline void T_GnssConfigData::clearUpdateFrequency() {
    if (hasUpdateFrequency()) {
         clear_has_UpdateFrequency();
        _UpdateFrequency = 0u;
     }
}

inline bool T_GnssConfigData::hasUpdateFrequency () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_GnssConfigData::getUpdateFrequency () const {
    return _UpdateFrequency;
}

inline void T_GnssConfigData::setUpdateFrequency (uint8 UpdateFrequency_) {
    set_has_UpdateFrequency();
    this->_UpdateFrequency = UpdateFrequency_;
}

inline void T_GnssConfigData::set_has_GnssHardwareType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_GnssConfigData::clear_has_GnssHardwareType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_GnssConfigData::set_has_GnssReceiverFirmwareVersion () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_GnssConfigData::clear_has_GnssReceiverFirmwareVersion () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_GnssConfigData::set_has_GnssReceiverFirmwareCrc () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_GnssConfigData::clear_has_GnssReceiverFirmwareCrc () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_GnssConfigData::set_has_NumberOfChannels () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_GnssConfigData::clear_has_NumberOfChannels () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_GnssConfigData::set_has_UsedSatStatusBits () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_GnssConfigData::clear_has_UsedSatStatusBits () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_GnssConfigData::set_has_UpdateFrequency () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_GnssConfigData::clear_has_UpdateFrequency () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_GnssStatus::T_GnssStatus ()  :
    _GnssQuality (::location_fi_types::T_e8_GnssQuality__GNSSQUALITY_NOFIX),
    _GnssMode (::location_fi_types::T_e8_GnssMode__GNSSMODE_NOFIX)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_GnssStatus::T_GnssStatus (const T_GnssStatus &rhs)  :
    _GnssQuality (::location_fi_types::T_e8_GnssQuality__GNSSQUALITY_NOFIX),
    _GnssMode (::location_fi_types::T_e8_GnssMode__GNSSMODE_NOFIX)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_GnssStatus::T_GnssStatus (T_e8_GnssQuality GnssQuality_, T_e8_GnssMode GnssMode_)  :
    _GnssQuality (GnssQuality_),
    _GnssMode (GnssMode_)
{
    #ifndef NDEBUG
    if (!(T_e8_GnssQuality_IsValid(GnssQuality_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GnssQuality_, "T_e8_GnssQuality", "GnssQuality", "T_GnssStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_GnssMode_IsValid(GnssMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GnssMode_, "T_e8_GnssMode", "GnssMode", "T_GnssStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_GnssStatus::~T_GnssStatus() {
}

inline T_GnssStatus& T_GnssStatus::operator = (const T_GnssStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGnssQuality()) {
            setGnssQuality(rhs.getGnssQuality());
        } else {
            clearGnssQuality();
        }
        if (rhs.hasGnssMode()) {
            setGnssMode(rhs.getGnssMode());
        } else {
            clearGnssMode();
        }
    }
    return *this;
}

inline bool T_GnssStatus::operator == (const T_GnssStatus& rhs) const {
    return (((!hasGnssQuality() && !rhs.hasGnssQuality()) || getGnssQuality() == rhs.getGnssQuality()) &&
        ((!hasGnssMode() && !rhs.hasGnssMode()) || getGnssMode() == rhs.getGnssMode()));
}

inline bool T_GnssStatus::operator != (const T_GnssStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_GnssStatus::operator < (const T_GnssStatus& rhs) const {
    if (hasGnssQuality() || rhs.hasGnssQuality()) {
        if ((uint32)getGnssQuality() < (uint32)rhs.getGnssQuality()) return true;
        if ((uint32)getGnssQuality() > (uint32)rhs.getGnssQuality()) return false;
    }
    if (hasGnssMode() || rhs.hasGnssMode()) {
        if ((uint32)getGnssMode() < (uint32)rhs.getGnssMode()) return true;
        if ((uint32)getGnssMode() > (uint32)rhs.getGnssMode()) return false;
    }
    return false;
}

inline bool T_GnssStatus::operator > (const T_GnssStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_GnssStatus::clear() {
    clearGnssQuality();
    clearGnssMode();
}

inline void T_GnssStatus::clearGnssQuality() {
    if (hasGnssQuality()) {
         clear_has_GnssQuality();
        _GnssQuality = ::location_fi_types::T_e8_GnssQuality__GNSSQUALITY_NOFIX;
     }
}

inline bool T_GnssStatus::hasGnssQuality () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_GnssQuality T_GnssStatus::getGnssQuality () const {
    return _GnssQuality;
}

inline void T_GnssStatus::setGnssQuality (T_e8_GnssQuality GnssQuality_) {
    #ifndef NDEBUG
    if (!(T_e8_GnssQuality_IsValid(GnssQuality_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GnssQuality_, "T_e8_GnssQuality", "GnssQuality", "T_GnssStatus");
    }
    #endif
    set_has_GnssQuality();
    this->_GnssQuality = GnssQuality_;
}

inline void T_GnssStatus::clearGnssMode() {
    if (hasGnssMode()) {
         clear_has_GnssMode();
        _GnssMode = ::location_fi_types::T_e8_GnssMode__GNSSMODE_NOFIX;
     }
}

inline bool T_GnssStatus::hasGnssMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_GnssMode T_GnssStatus::getGnssMode () const {
    return _GnssMode;
}

inline void T_GnssStatus::setGnssMode (T_e8_GnssMode GnssMode_) {
    #ifndef NDEBUG
    if (!(T_e8_GnssMode_IsValid(GnssMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GnssMode_, "T_e8_GnssMode", "GnssMode", "T_GnssStatus");
    }
    #endif
    set_has_GnssMode();
    this->_GnssMode = GnssMode_;
}

inline void T_GnssStatus::set_has_GnssQuality () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_GnssStatus::clear_has_GnssQuality () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_GnssStatus::set_has_GnssMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_GnssStatus::clear_has_GnssMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_CovarianceMatrixUpperTriangle::T_CovarianceMatrixUpperTriangle ()  :
    _Elem0 (0.0f),
    _Elem4 (0.0f),
    _Elem5 (0.0f),
    _Elem8 (0.0f),
    _Elem9 (0.0f),
    _Elem10 (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CovarianceMatrixUpperTriangle::T_CovarianceMatrixUpperTriangle (const T_CovarianceMatrixUpperTriangle &rhs)  :
    _Elem0 (0.0f),
    _Elem4 (0.0f),
    _Elem5 (0.0f),
    _Elem8 (0.0f),
    _Elem9 (0.0f),
    _Elem10 (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CovarianceMatrixUpperTriangle::T_CovarianceMatrixUpperTriangle (float Elem0_, float Elem4_, float Elem5_, float Elem8_, float Elem9_, float Elem10_)  :
    _Elem0 (Elem0_),
    _Elem4 (Elem4_),
    _Elem5 (Elem5_),
    _Elem8 (Elem8_),
    _Elem9 (Elem9_),
    _Elem10 (Elem10_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CovarianceMatrixUpperTriangle::~T_CovarianceMatrixUpperTriangle() {
}

inline T_CovarianceMatrixUpperTriangle& T_CovarianceMatrixUpperTriangle::operator = (const T_CovarianceMatrixUpperTriangle& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem0()) {
            setElem0(rhs.getElem0());
        } else {
            clearElem0();
        }
        if (rhs.hasElem4()) {
            setElem4(rhs.getElem4());
        } else {
            clearElem4();
        }
        if (rhs.hasElem5()) {
            setElem5(rhs.getElem5());
        } else {
            clearElem5();
        }
        if (rhs.hasElem8()) {
            setElem8(rhs.getElem8());
        } else {
            clearElem8();
        }
        if (rhs.hasElem9()) {
            setElem9(rhs.getElem9());
        } else {
            clearElem9();
        }
        if (rhs.hasElem10()) {
            setElem10(rhs.getElem10());
        } else {
            clearElem10();
        }
    }
    return *this;
}

inline bool T_CovarianceMatrixUpperTriangle::operator == (const T_CovarianceMatrixUpperTriangle& rhs) const {
    return (((!hasElem0() && !rhs.hasElem0()) || getElem0() == rhs.getElem0()) &&
        ((!hasElem4() && !rhs.hasElem4()) || getElem4() == rhs.getElem4()) &&
        ((!hasElem5() && !rhs.hasElem5()) || getElem5() == rhs.getElem5()) &&
        ((!hasElem8() && !rhs.hasElem8()) || getElem8() == rhs.getElem8()) &&
        ((!hasElem9() && !rhs.hasElem9()) || getElem9() == rhs.getElem9()) &&
        ((!hasElem10() && !rhs.hasElem10()) || getElem10() == rhs.getElem10()));
}

inline bool T_CovarianceMatrixUpperTriangle::operator != (const T_CovarianceMatrixUpperTriangle& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CovarianceMatrixUpperTriangle::operator < (const T_CovarianceMatrixUpperTriangle& rhs) const {
    if (hasElem0() || rhs.hasElem0()) {
        if (getElem0() < rhs.getElem0()) return true;
        if (getElem0() > rhs.getElem0()) return false;
    }
    if (hasElem4() || rhs.hasElem4()) {
        if (getElem4() < rhs.getElem4()) return true;
        if (getElem4() > rhs.getElem4()) return false;
    }
    if (hasElem5() || rhs.hasElem5()) {
        if (getElem5() < rhs.getElem5()) return true;
        if (getElem5() > rhs.getElem5()) return false;
    }
    if (hasElem8() || rhs.hasElem8()) {
        if (getElem8() < rhs.getElem8()) return true;
        if (getElem8() > rhs.getElem8()) return false;
    }
    if (hasElem9() || rhs.hasElem9()) {
        if (getElem9() < rhs.getElem9()) return true;
        if (getElem9() > rhs.getElem9()) return false;
    }
    if (hasElem10() || rhs.hasElem10()) {
        if (getElem10() < rhs.getElem10()) return true;
        if (getElem10() > rhs.getElem10()) return false;
    }
    return false;
}

inline bool T_CovarianceMatrixUpperTriangle::operator > (const T_CovarianceMatrixUpperTriangle& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CovarianceMatrixUpperTriangle::clear() {
    clearElem0();
    clearElem4();
    clearElem5();
    clearElem8();
    clearElem9();
    clearElem10();
}

inline void T_CovarianceMatrixUpperTriangle::clearElem0() {
    if (hasElem0()) {
         clear_has_Elem0();
        _Elem0 = 0.0f;
     }
}

inline bool T_CovarianceMatrixUpperTriangle::hasElem0 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline float T_CovarianceMatrixUpperTriangle::getElem0 () const {
    return _Elem0;
}

inline void T_CovarianceMatrixUpperTriangle::setElem0 (float Elem0_) {
    set_has_Elem0();
    this->_Elem0 = Elem0_;
}

inline void T_CovarianceMatrixUpperTriangle::clearElem4() {
    if (hasElem4()) {
         clear_has_Elem4();
        _Elem4 = 0.0f;
     }
}

inline bool T_CovarianceMatrixUpperTriangle::hasElem4 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline float T_CovarianceMatrixUpperTriangle::getElem4 () const {
    return _Elem4;
}

inline void T_CovarianceMatrixUpperTriangle::setElem4 (float Elem4_) {
    set_has_Elem4();
    this->_Elem4 = Elem4_;
}

inline void T_CovarianceMatrixUpperTriangle::clearElem5() {
    if (hasElem5()) {
         clear_has_Elem5();
        _Elem5 = 0.0f;
     }
}

inline bool T_CovarianceMatrixUpperTriangle::hasElem5 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline float T_CovarianceMatrixUpperTriangle::getElem5 () const {
    return _Elem5;
}

inline void T_CovarianceMatrixUpperTriangle::setElem5 (float Elem5_) {
    set_has_Elem5();
    this->_Elem5 = Elem5_;
}

inline void T_CovarianceMatrixUpperTriangle::clearElem8() {
    if (hasElem8()) {
         clear_has_Elem8();
        _Elem8 = 0.0f;
     }
}

inline bool T_CovarianceMatrixUpperTriangle::hasElem8 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline float T_CovarianceMatrixUpperTriangle::getElem8 () const {
    return _Elem8;
}

inline void T_CovarianceMatrixUpperTriangle::setElem8 (float Elem8_) {
    set_has_Elem8();
    this->_Elem8 = Elem8_;
}

inline void T_CovarianceMatrixUpperTriangle::clearElem9() {
    if (hasElem9()) {
         clear_has_Elem9();
        _Elem9 = 0.0f;
     }
}

inline bool T_CovarianceMatrixUpperTriangle::hasElem9 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline float T_CovarianceMatrixUpperTriangle::getElem9 () const {
    return _Elem9;
}

inline void T_CovarianceMatrixUpperTriangle::setElem9 (float Elem9_) {
    set_has_Elem9();
    this->_Elem9 = Elem9_;
}

inline void T_CovarianceMatrixUpperTriangle::clearElem10() {
    if (hasElem10()) {
         clear_has_Elem10();
        _Elem10 = 0.0f;
     }
}

inline bool T_CovarianceMatrixUpperTriangle::hasElem10 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline float T_CovarianceMatrixUpperTriangle::getElem10 () const {
    return _Elem10;
}

inline void T_CovarianceMatrixUpperTriangle::setElem10 (float Elem10_) {
    set_has_Elem10();
    this->_Elem10 = Elem10_;
}

inline void T_CovarianceMatrixUpperTriangle::set_has_Elem0 () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CovarianceMatrixUpperTriangle::clear_has_Elem0 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CovarianceMatrixUpperTriangle::set_has_Elem4 () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CovarianceMatrixUpperTriangle::clear_has_Elem4 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_CovarianceMatrixUpperTriangle::set_has_Elem5 () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_CovarianceMatrixUpperTriangle::clear_has_Elem5 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_CovarianceMatrixUpperTriangle::set_has_Elem8 () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_CovarianceMatrixUpperTriangle::clear_has_Elem8 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_CovarianceMatrixUpperTriangle::set_has_Elem9 () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_CovarianceMatrixUpperTriangle::clear_has_Elem9 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_CovarianceMatrixUpperTriangle::set_has_Elem10 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_CovarianceMatrixUpperTriangle::clear_has_Elem10 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_TimeDate::T_TimeDate ()  :
    _td_year (0u),
    _td_month (0u),
    _td_day (0u),
    _td_hour (0u),
    _td_minute (0u),
    _td_second (0u),
    _td_milliSeconds (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TimeDate::T_TimeDate (const T_TimeDate &rhs)  :
    _td_year (0u),
    _td_month (0u),
    _td_day (0u),
    _td_hour (0u),
    _td_minute (0u),
    _td_second (0u),
    _td_milliSeconds (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TimeDate::T_TimeDate (uint16 td_year_, uint8 td_month_, uint8 td_day_, uint8 td_hour_, uint8 td_minute_, uint8 td_second_, uint16 td_milliSeconds_)  :
    _td_year (td_year_),
    _td_month (td_month_),
    _td_day (td_day_),
    _td_hour (td_hour_),
    _td_minute (td_minute_),
    _td_second (td_second_),
    _td_milliSeconds (td_milliSeconds_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(td_month_ <= 12, "Range check for uint8 failed: %d", td_month_);
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(td_day_ <= 31, "Range check for uint8 failed: %d", td_day_);
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(td_hour_ <= 23, "Range check for uint8 failed: %d", td_hour_);
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(td_minute_ <= 59, "Range check for uint8 failed: %d", td_minute_);
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(td_second_ <= 59, "Range check for uint8 failed: %d", td_second_);
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(td_milliSeconds_ <= 999, "Range check for uint16 failed: %d", td_milliSeconds_);
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TimeDate::~T_TimeDate() {
}

inline T_TimeDate& T_TimeDate::operator = (const T_TimeDate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTd_year()) {
            setTd_year(rhs.getTd_year());
        } else {
            clearTd_year();
        }
        if (rhs.hasTd_month()) {
            setTd_month(rhs.getTd_month());
        } else {
            clearTd_month();
        }
        if (rhs.hasTd_day()) {
            setTd_day(rhs.getTd_day());
        } else {
            clearTd_day();
        }
        if (rhs.hasTd_hour()) {
            setTd_hour(rhs.getTd_hour());
        } else {
            clearTd_hour();
        }
        if (rhs.hasTd_minute()) {
            setTd_minute(rhs.getTd_minute());
        } else {
            clearTd_minute();
        }
        if (rhs.hasTd_second()) {
            setTd_second(rhs.getTd_second());
        } else {
            clearTd_second();
        }
        if (rhs.hasTd_milliSeconds()) {
            setTd_milliSeconds(rhs.getTd_milliSeconds());
        } else {
            clearTd_milliSeconds();
        }
    }
    return *this;
}

inline bool T_TimeDate::operator == (const T_TimeDate& rhs) const {
    return (((!hasTd_year() && !rhs.hasTd_year()) || getTd_year() == rhs.getTd_year()) &&
        ((!hasTd_month() && !rhs.hasTd_month()) || getTd_month() == rhs.getTd_month()) &&
        ((!hasTd_day() && !rhs.hasTd_day()) || getTd_day() == rhs.getTd_day()) &&
        ((!hasTd_hour() && !rhs.hasTd_hour()) || getTd_hour() == rhs.getTd_hour()) &&
        ((!hasTd_minute() && !rhs.hasTd_minute()) || getTd_minute() == rhs.getTd_minute()) &&
        ((!hasTd_second() && !rhs.hasTd_second()) || getTd_second() == rhs.getTd_second()) &&
        ((!hasTd_milliSeconds() && !rhs.hasTd_milliSeconds()) || getTd_milliSeconds() == rhs.getTd_milliSeconds()));
}

inline bool T_TimeDate::operator != (const T_TimeDate& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TimeDate::operator < (const T_TimeDate& rhs) const {
    if (hasTd_year() || rhs.hasTd_year()) {
        if (getTd_year() < rhs.getTd_year()) return true;
        if (getTd_year() > rhs.getTd_year()) return false;
    }
    if (hasTd_month() || rhs.hasTd_month()) {
        if (getTd_month() < rhs.getTd_month()) return true;
        if (getTd_month() > rhs.getTd_month()) return false;
    }
    if (hasTd_day() || rhs.hasTd_day()) {
        if (getTd_day() < rhs.getTd_day()) return true;
        if (getTd_day() > rhs.getTd_day()) return false;
    }
    if (hasTd_hour() || rhs.hasTd_hour()) {
        if (getTd_hour() < rhs.getTd_hour()) return true;
        if (getTd_hour() > rhs.getTd_hour()) return false;
    }
    if (hasTd_minute() || rhs.hasTd_minute()) {
        if (getTd_minute() < rhs.getTd_minute()) return true;
        if (getTd_minute() > rhs.getTd_minute()) return false;
    }
    if (hasTd_second() || rhs.hasTd_second()) {
        if (getTd_second() < rhs.getTd_second()) return true;
        if (getTd_second() > rhs.getTd_second()) return false;
    }
    if (hasTd_milliSeconds() || rhs.hasTd_milliSeconds()) {
        if (getTd_milliSeconds() < rhs.getTd_milliSeconds()) return true;
        if (getTd_milliSeconds() > rhs.getTd_milliSeconds()) return false;
    }
    return false;
}

inline bool T_TimeDate::operator > (const T_TimeDate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TimeDate::clear() {
    clearTd_year();
    clearTd_month();
    clearTd_day();
    clearTd_hour();
    clearTd_minute();
    clearTd_second();
    clearTd_milliSeconds();
}

inline void T_TimeDate::clearTd_year() {
    if (hasTd_year()) {
         clear_has_td_year();
        _td_year = 0u;
     }
}

inline bool T_TimeDate::hasTd_year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_TimeDate::getTd_year () const {
    return _td_year;
}

inline void T_TimeDate::setTd_year (uint16 td_year_) {
    set_has_td_year();
    this->_td_year = td_year_;
}

inline void T_TimeDate::clearTd_month() {
    if (hasTd_month()) {
         clear_has_td_month();
        _td_month = 0u;
     }
}

inline bool T_TimeDate::hasTd_month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TimeDate::getTd_month () const {
    return _td_month;
}

inline void T_TimeDate::setTd_month (uint8 td_month_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(td_month_ <= 12, "Range check for uint8 failed: %d", td_month_);
    }
    set_has_td_month();
    this->_td_month = td_month_;
}

inline void T_TimeDate::clearTd_day() {
    if (hasTd_day()) {
         clear_has_td_day();
        _td_day = 0u;
     }
}

inline bool T_TimeDate::hasTd_day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_TimeDate::getTd_day () const {
    return _td_day;
}

inline void T_TimeDate::setTd_day (uint8 td_day_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(td_day_ <= 31, "Range check for uint8 failed: %d", td_day_);
    }
    set_has_td_day();
    this->_td_day = td_day_;
}

inline void T_TimeDate::clearTd_hour() {
    if (hasTd_hour()) {
         clear_has_td_hour();
        _td_hour = 0u;
     }
}

inline bool T_TimeDate::hasTd_hour () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_TimeDate::getTd_hour () const {
    return _td_hour;
}

inline void T_TimeDate::setTd_hour (uint8 td_hour_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(td_hour_ <= 23, "Range check for uint8 failed: %d", td_hour_);
    }
    set_has_td_hour();
    this->_td_hour = td_hour_;
}

inline void T_TimeDate::clearTd_minute() {
    if (hasTd_minute()) {
         clear_has_td_minute();
        _td_minute = 0u;
     }
}

inline bool T_TimeDate::hasTd_minute () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_TimeDate::getTd_minute () const {
    return _td_minute;
}

inline void T_TimeDate::setTd_minute (uint8 td_minute_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(td_minute_ <= 59, "Range check for uint8 failed: %d", td_minute_);
    }
    set_has_td_minute();
    this->_td_minute = td_minute_;
}

inline void T_TimeDate::clearTd_second() {
    if (hasTd_second()) {
         clear_has_td_second();
        _td_second = 0u;
     }
}

inline bool T_TimeDate::hasTd_second () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_TimeDate::getTd_second () const {
    return _td_second;
}

inline void T_TimeDate::setTd_second (uint8 td_second_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(td_second_ <= 59, "Range check for uint8 failed: %d", td_second_);
    }
    set_has_td_second();
    this->_td_second = td_second_;
}

inline void T_TimeDate::clearTd_milliSeconds() {
    if (hasTd_milliSeconds()) {
         clear_has_td_milliSeconds();
        _td_milliSeconds = 0u;
     }
}

inline bool T_TimeDate::hasTd_milliSeconds () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint16 T_TimeDate::getTd_milliSeconds () const {
    return _td_milliSeconds;
}

inline void T_TimeDate::setTd_milliSeconds (uint16 td_milliSeconds_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(td_milliSeconds_ <= 999, "Range check for uint16 failed: %d", td_milliSeconds_);
    }
    set_has_td_milliSeconds();
    this->_td_milliSeconds = td_milliSeconds_;
}

inline void T_TimeDate::set_has_td_year () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TimeDate::clear_has_td_year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TimeDate::set_has_td_month () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TimeDate::clear_has_td_month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TimeDate::set_has_td_day () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TimeDate::clear_has_td_day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TimeDate::set_has_td_hour () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TimeDate::clear_has_td_hour () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TimeDate::set_has_td_minute () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TimeDate::clear_has_td_minute () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TimeDate::set_has_td_second () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TimeDate::clear_has_td_second () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TimeDate::set_has_td_milliSeconds () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TimeDate::clear_has_td_milliSeconds () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_GnssPvtData::T_GnssPvtData ()  :
    _UtcTimeDate (),
    _Latitude (0.0),
    _Longitude (0.0),
    _AltitudeWGS84 (0.0f),
    _GeoidalSeparation (0.0f),
    _VelocityNorth (0.0f),
    _VelocityEast (0.0f),
    _VelocityUp (0.0f),
    _PositionCovarianceMatrix (),
    _VelocityCovarianceMatrix (),
    _GnssStatus (),
    _GDOP (0.0f),
    _PDOP (0.0f),
    _HDOP (0.0f),
    _TDOP (0.0f),
    _VDOP (0.0f),
    _SatSysUsed (),
    _SatellitesVisible (0u),
    _SatellitesReceived (0u),
    _SatellitesUsed (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_GnssPvtData::T_GnssPvtData (const T_GnssPvtData &rhs)  :
    _UtcTimeDate (),
    _Latitude (0.0),
    _Longitude (0.0),
    _AltitudeWGS84 (0.0f),
    _GeoidalSeparation (0.0f),
    _VelocityNorth (0.0f),
    _VelocityEast (0.0f),
    _VelocityUp (0.0f),
    _PositionCovarianceMatrix (),
    _VelocityCovarianceMatrix (),
    _GnssStatus (),
    _GDOP (0.0f),
    _PDOP (0.0f),
    _HDOP (0.0f),
    _TDOP (0.0f),
    _VDOP (0.0f),
    _SatSysUsed (),
    _SatellitesVisible (0u),
    _SatellitesReceived (0u),
    _SatellitesUsed (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_GnssPvtData::T_GnssPvtData (const T_TimeDate& UtcTimeDate_, double Latitude_, double Longitude_, float AltitudeWGS84_, float GeoidalSeparation_, float VelocityNorth_, float VelocityEast_, float VelocityUp_, const T_CovarianceMatrixUpperTriangle& PositionCovarianceMatrix_, const T_CovarianceMatrixUpperTriangle& VelocityCovarianceMatrix_, const T_GnssStatus& GnssStatus_, float GDOP_, float PDOP_, float HDOP_, float TDOP_, float VDOP_, const T_b8_GnssSatSys& SatSysUsed_, uint16 SatellitesVisible_, uint16 SatellitesReceived_, uint16 SatellitesUsed_)  :
    _UtcTimeDate (UtcTimeDate_),
    _Latitude (Latitude_),
    _Longitude (Longitude_),
    _AltitudeWGS84 (AltitudeWGS84_),
    _GeoidalSeparation (GeoidalSeparation_),
    _VelocityNorth (VelocityNorth_),
    _VelocityEast (VelocityEast_),
    _VelocityUp (VelocityUp_),
    _PositionCovarianceMatrix (PositionCovarianceMatrix_),
    _VelocityCovarianceMatrix (VelocityCovarianceMatrix_),
    _GnssStatus (GnssStatus_),
    _GDOP (GDOP_),
    _PDOP (PDOP_),
    _HDOP (HDOP_),
    _TDOP (TDOP_),
    _VDOP (VDOP_),
    _SatSysUsed (SatSysUsed_),
    _SatellitesVisible (SatellitesVisible_),
    _SatellitesReceived (SatellitesReceived_),
    _SatellitesUsed (SatellitesUsed_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_GnssPvtData::~T_GnssPvtData() {
}

inline T_GnssPvtData& T_GnssPvtData::operator = (const T_GnssPvtData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUtcTimeDate()) {
            setUtcTimeDate(rhs.getUtcTimeDate());
        } else {
            clearUtcTimeDate();
        }
        if (rhs.hasLatitude()) {
            setLatitude(rhs.getLatitude());
        } else {
            clearLatitude();
        }
        if (rhs.hasLongitude()) {
            setLongitude(rhs.getLongitude());
        } else {
            clearLongitude();
        }
        if (rhs.hasAltitudeWGS84()) {
            setAltitudeWGS84(rhs.getAltitudeWGS84());
        } else {
            clearAltitudeWGS84();
        }
        if (rhs.hasGeoidalSeparation()) {
            setGeoidalSeparation(rhs.getGeoidalSeparation());
        } else {
            clearGeoidalSeparation();
        }
        if (rhs.hasVelocityNorth()) {
            setVelocityNorth(rhs.getVelocityNorth());
        } else {
            clearVelocityNorth();
        }
        if (rhs.hasVelocityEast()) {
            setVelocityEast(rhs.getVelocityEast());
        } else {
            clearVelocityEast();
        }
        if (rhs.hasVelocityUp()) {
            setVelocityUp(rhs.getVelocityUp());
        } else {
            clearVelocityUp();
        }
        if (rhs.hasPositionCovarianceMatrix()) {
            setPositionCovarianceMatrix(rhs.getPositionCovarianceMatrix());
        } else {
            clearPositionCovarianceMatrix();
        }
        if (rhs.hasVelocityCovarianceMatrix()) {
            setVelocityCovarianceMatrix(rhs.getVelocityCovarianceMatrix());
        } else {
            clearVelocityCovarianceMatrix();
        }
        if (rhs.hasGnssStatus()) {
            setGnssStatus(rhs.getGnssStatus());
        } else {
            clearGnssStatus();
        }
        if (rhs.hasGDOP()) {
            setGDOP(rhs.getGDOP());
        } else {
            clearGDOP();
        }
        if (rhs.hasPDOP()) {
            setPDOP(rhs.getPDOP());
        } else {
            clearPDOP();
        }
        if (rhs.hasHDOP()) {
            setHDOP(rhs.getHDOP());
        } else {
            clearHDOP();
        }
        if (rhs.hasTDOP()) {
            setTDOP(rhs.getTDOP());
        } else {
            clearTDOP();
        }
        if (rhs.hasVDOP()) {
            setVDOP(rhs.getVDOP());
        } else {
            clearVDOP();
        }
        if (rhs.hasSatSysUsed()) {
            setSatSysUsed(rhs.getSatSysUsed());
        } else {
            clearSatSysUsed();
        }
        if (rhs.hasSatellitesVisible()) {
            setSatellitesVisible(rhs.getSatellitesVisible());
        } else {
            clearSatellitesVisible();
        }
        if (rhs.hasSatellitesReceived()) {
            setSatellitesReceived(rhs.getSatellitesReceived());
        } else {
            clearSatellitesReceived();
        }
        if (rhs.hasSatellitesUsed()) {
            setSatellitesUsed(rhs.getSatellitesUsed());
        } else {
            clearSatellitesUsed();
        }
    }
    return *this;
}

inline bool T_GnssPvtData::operator == (const T_GnssPvtData& rhs) const {
    return (((!hasUtcTimeDate() && !rhs.hasUtcTimeDate()) || getUtcTimeDate() == rhs.getUtcTimeDate()) &&
        ((!hasLatitude() && !rhs.hasLatitude()) || getLatitude() == rhs.getLatitude()) &&
        ((!hasLongitude() && !rhs.hasLongitude()) || getLongitude() == rhs.getLongitude()) &&
        ((!hasAltitudeWGS84() && !rhs.hasAltitudeWGS84()) || getAltitudeWGS84() == rhs.getAltitudeWGS84()) &&
        ((!hasGeoidalSeparation() && !rhs.hasGeoidalSeparation()) || getGeoidalSeparation() == rhs.getGeoidalSeparation()) &&
        ((!hasVelocityNorth() && !rhs.hasVelocityNorth()) || getVelocityNorth() == rhs.getVelocityNorth()) &&
        ((!hasVelocityEast() && !rhs.hasVelocityEast()) || getVelocityEast() == rhs.getVelocityEast()) &&
        ((!hasVelocityUp() && !rhs.hasVelocityUp()) || getVelocityUp() == rhs.getVelocityUp()) &&
        ((!hasPositionCovarianceMatrix() && !rhs.hasPositionCovarianceMatrix()) || getPositionCovarianceMatrix() == rhs.getPositionCovarianceMatrix()) &&
        ((!hasVelocityCovarianceMatrix() && !rhs.hasVelocityCovarianceMatrix()) || getVelocityCovarianceMatrix() == rhs.getVelocityCovarianceMatrix()) &&
        ((!hasGnssStatus() && !rhs.hasGnssStatus()) || getGnssStatus() == rhs.getGnssStatus()) &&
        ((!hasGDOP() && !rhs.hasGDOP()) || getGDOP() == rhs.getGDOP()) &&
        ((!hasPDOP() && !rhs.hasPDOP()) || getPDOP() == rhs.getPDOP()) &&
        ((!hasHDOP() && !rhs.hasHDOP()) || getHDOP() == rhs.getHDOP()) &&
        ((!hasTDOP() && !rhs.hasTDOP()) || getTDOP() == rhs.getTDOP()) &&
        ((!hasVDOP() && !rhs.hasVDOP()) || getVDOP() == rhs.getVDOP()) &&
        ((!hasSatSysUsed() && !rhs.hasSatSysUsed()) || getSatSysUsed() == rhs.getSatSysUsed()) &&
        ((!hasSatellitesVisible() && !rhs.hasSatellitesVisible()) || getSatellitesVisible() == rhs.getSatellitesVisible()) &&
        ((!hasSatellitesReceived() && !rhs.hasSatellitesReceived()) || getSatellitesReceived() == rhs.getSatellitesReceived()) &&
        ((!hasSatellitesUsed() && !rhs.hasSatellitesUsed()) || getSatellitesUsed() == rhs.getSatellitesUsed()));
}

inline bool T_GnssPvtData::operator != (const T_GnssPvtData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_GnssPvtData::operator < (const T_GnssPvtData& rhs) const {
    if (hasUtcTimeDate() || rhs.hasUtcTimeDate()) {
        if (getUtcTimeDate() < rhs.getUtcTimeDate()) return true;
        if (getUtcTimeDate() > rhs.getUtcTimeDate()) return false;
    }
    if (hasLatitude() || rhs.hasLatitude()) {
        if (getLatitude() < rhs.getLatitude()) return true;
        if (getLatitude() > rhs.getLatitude()) return false;
    }
    if (hasLongitude() || rhs.hasLongitude()) {
        if (getLongitude() < rhs.getLongitude()) return true;
        if (getLongitude() > rhs.getLongitude()) return false;
    }
    if (hasAltitudeWGS84() || rhs.hasAltitudeWGS84()) {
        if (getAltitudeWGS84() < rhs.getAltitudeWGS84()) return true;
        if (getAltitudeWGS84() > rhs.getAltitudeWGS84()) return false;
    }
    if (hasGeoidalSeparation() || rhs.hasGeoidalSeparation()) {
        if (getGeoidalSeparation() < rhs.getGeoidalSeparation()) return true;
        if (getGeoidalSeparation() > rhs.getGeoidalSeparation()) return false;
    }
    if (hasVelocityNorth() || rhs.hasVelocityNorth()) {
        if (getVelocityNorth() < rhs.getVelocityNorth()) return true;
        if (getVelocityNorth() > rhs.getVelocityNorth()) return false;
    }
    if (hasVelocityEast() || rhs.hasVelocityEast()) {
        if (getVelocityEast() < rhs.getVelocityEast()) return true;
        if (getVelocityEast() > rhs.getVelocityEast()) return false;
    }
    if (hasVelocityUp() || rhs.hasVelocityUp()) {
        if (getVelocityUp() < rhs.getVelocityUp()) return true;
        if (getVelocityUp() > rhs.getVelocityUp()) return false;
    }
    if (hasPositionCovarianceMatrix() || rhs.hasPositionCovarianceMatrix()) {
        if (getPositionCovarianceMatrix() < rhs.getPositionCovarianceMatrix()) return true;
        if (getPositionCovarianceMatrix() > rhs.getPositionCovarianceMatrix()) return false;
    }
    if (hasVelocityCovarianceMatrix() || rhs.hasVelocityCovarianceMatrix()) {
        if (getVelocityCovarianceMatrix() < rhs.getVelocityCovarianceMatrix()) return true;
        if (getVelocityCovarianceMatrix() > rhs.getVelocityCovarianceMatrix()) return false;
    }
    if (hasGnssStatus() || rhs.hasGnssStatus()) {
        if (getGnssStatus() < rhs.getGnssStatus()) return true;
        if (getGnssStatus() > rhs.getGnssStatus()) return false;
    }
    if (hasGDOP() || rhs.hasGDOP()) {
        if (getGDOP() < rhs.getGDOP()) return true;
        if (getGDOP() > rhs.getGDOP()) return false;
    }
    if (hasPDOP() || rhs.hasPDOP()) {
        if (getPDOP() < rhs.getPDOP()) return true;
        if (getPDOP() > rhs.getPDOP()) return false;
    }
    if (hasHDOP() || rhs.hasHDOP()) {
        if (getHDOP() < rhs.getHDOP()) return true;
        if (getHDOP() > rhs.getHDOP()) return false;
    }
    if (hasTDOP() || rhs.hasTDOP()) {
        if (getTDOP() < rhs.getTDOP()) return true;
        if (getTDOP() > rhs.getTDOP()) return false;
    }
    if (hasVDOP() || rhs.hasVDOP()) {
        if (getVDOP() < rhs.getVDOP()) return true;
        if (getVDOP() > rhs.getVDOP()) return false;
    }
    if (hasSatSysUsed() || rhs.hasSatSysUsed()) {
        if (getSatSysUsed() < rhs.getSatSysUsed()) return true;
        if (getSatSysUsed() > rhs.getSatSysUsed()) return false;
    }
    if (hasSatellitesVisible() || rhs.hasSatellitesVisible()) {
        if (getSatellitesVisible() < rhs.getSatellitesVisible()) return true;
        if (getSatellitesVisible() > rhs.getSatellitesVisible()) return false;
    }
    if (hasSatellitesReceived() || rhs.hasSatellitesReceived()) {
        if (getSatellitesReceived() < rhs.getSatellitesReceived()) return true;
        if (getSatellitesReceived() > rhs.getSatellitesReceived()) return false;
    }
    if (hasSatellitesUsed() || rhs.hasSatellitesUsed()) {
        if (getSatellitesUsed() < rhs.getSatellitesUsed()) return true;
        if (getSatellitesUsed() > rhs.getSatellitesUsed()) return false;
    }
    return false;
}

inline bool T_GnssPvtData::operator > (const T_GnssPvtData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_GnssPvtData::clear() {
    clearUtcTimeDate();
    clearLatitude();
    clearLongitude();
    clearAltitudeWGS84();
    clearGeoidalSeparation();
    clearVelocityNorth();
    clearVelocityEast();
    clearVelocityUp();
    clearPositionCovarianceMatrix();
    clearVelocityCovarianceMatrix();
    clearGnssStatus();
    clearGDOP();
    clearPDOP();
    clearHDOP();
    clearTDOP();
    clearVDOP();
    clearSatSysUsed();
    clearSatellitesVisible();
    clearSatellitesReceived();
    clearSatellitesUsed();
}

inline void T_GnssPvtData::clearUtcTimeDate() {
    if (hasUtcTimeDate()) {
         clear_has_UtcTimeDate();
        _UtcTimeDate.clear();
     }
}

inline bool T_GnssPvtData::hasUtcTimeDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_TimeDate& T_GnssPvtData::getUtcTimeDate () const {
    return _UtcTimeDate;
}

inline T_TimeDate& T_GnssPvtData::getUtcTimeDateMutable () {
    set_has_UtcTimeDate();
    return _UtcTimeDate;
}

inline void T_GnssPvtData::setUtcTimeDate (const T_TimeDate& UtcTimeDate_) {
    set_has_UtcTimeDate();
    this->_UtcTimeDate = UtcTimeDate_;
}

inline void T_GnssPvtData::clearLatitude() {
    if (hasLatitude()) {
         clear_has_Latitude();
        _Latitude = 0.0;
     }
}

inline bool T_GnssPvtData::hasLatitude () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline double T_GnssPvtData::getLatitude () const {
    return _Latitude;
}

inline void T_GnssPvtData::setLatitude (double Latitude_) {
    set_has_Latitude();
    this->_Latitude = Latitude_;
}

inline void T_GnssPvtData::clearLongitude() {
    if (hasLongitude()) {
         clear_has_Longitude();
        _Longitude = 0.0;
     }
}

inline bool T_GnssPvtData::hasLongitude () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline double T_GnssPvtData::getLongitude () const {
    return _Longitude;
}

inline void T_GnssPvtData::setLongitude (double Longitude_) {
    set_has_Longitude();
    this->_Longitude = Longitude_;
}

inline void T_GnssPvtData::clearAltitudeWGS84() {
    if (hasAltitudeWGS84()) {
         clear_has_AltitudeWGS84();
        _AltitudeWGS84 = 0.0f;
     }
}

inline bool T_GnssPvtData::hasAltitudeWGS84 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline float T_GnssPvtData::getAltitudeWGS84 () const {
    return _AltitudeWGS84;
}

inline void T_GnssPvtData::setAltitudeWGS84 (float AltitudeWGS84_) {
    set_has_AltitudeWGS84();
    this->_AltitudeWGS84 = AltitudeWGS84_;
}

inline void T_GnssPvtData::clearGeoidalSeparation() {
    if (hasGeoidalSeparation()) {
         clear_has_GeoidalSeparation();
        _GeoidalSeparation = 0.0f;
     }
}

inline bool T_GnssPvtData::hasGeoidalSeparation () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline float T_GnssPvtData::getGeoidalSeparation () const {
    return _GeoidalSeparation;
}

inline void T_GnssPvtData::setGeoidalSeparation (float GeoidalSeparation_) {
    set_has_GeoidalSeparation();
    this->_GeoidalSeparation = GeoidalSeparation_;
}

inline void T_GnssPvtData::clearVelocityNorth() {
    if (hasVelocityNorth()) {
         clear_has_VelocityNorth();
        _VelocityNorth = 0.0f;
     }
}

inline bool T_GnssPvtData::hasVelocityNorth () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline float T_GnssPvtData::getVelocityNorth () const {
    return _VelocityNorth;
}

inline void T_GnssPvtData::setVelocityNorth (float VelocityNorth_) {
    set_has_VelocityNorth();
    this->_VelocityNorth = VelocityNorth_;
}

inline void T_GnssPvtData::clearVelocityEast() {
    if (hasVelocityEast()) {
         clear_has_VelocityEast();
        _VelocityEast = 0.0f;
     }
}

inline bool T_GnssPvtData::hasVelocityEast () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline float T_GnssPvtData::getVelocityEast () const {
    return _VelocityEast;
}

inline void T_GnssPvtData::setVelocityEast (float VelocityEast_) {
    set_has_VelocityEast();
    this->_VelocityEast = VelocityEast_;
}

inline void T_GnssPvtData::clearVelocityUp() {
    if (hasVelocityUp()) {
         clear_has_VelocityUp();
        _VelocityUp = 0.0f;
     }
}

inline bool T_GnssPvtData::hasVelocityUp () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline float T_GnssPvtData::getVelocityUp () const {
    return _VelocityUp;
}

inline void T_GnssPvtData::setVelocityUp (float VelocityUp_) {
    set_has_VelocityUp();
    this->_VelocityUp = VelocityUp_;
}

inline void T_GnssPvtData::clearPositionCovarianceMatrix() {
    if (hasPositionCovarianceMatrix()) {
         clear_has_PositionCovarianceMatrix();
        _PositionCovarianceMatrix.clear();
     }
}

inline bool T_GnssPvtData::hasPositionCovarianceMatrix () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const T_CovarianceMatrixUpperTriangle& T_GnssPvtData::getPositionCovarianceMatrix () const {
    return _PositionCovarianceMatrix;
}

inline T_CovarianceMatrixUpperTriangle& T_GnssPvtData::getPositionCovarianceMatrixMutable () {
    set_has_PositionCovarianceMatrix();
    return _PositionCovarianceMatrix;
}

inline void T_GnssPvtData::setPositionCovarianceMatrix (const T_CovarianceMatrixUpperTriangle& PositionCovarianceMatrix_) {
    set_has_PositionCovarianceMatrix();
    this->_PositionCovarianceMatrix = PositionCovarianceMatrix_;
}

inline void T_GnssPvtData::clearVelocityCovarianceMatrix() {
    if (hasVelocityCovarianceMatrix()) {
         clear_has_VelocityCovarianceMatrix();
        _VelocityCovarianceMatrix.clear();
     }
}

inline bool T_GnssPvtData::hasVelocityCovarianceMatrix () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const T_CovarianceMatrixUpperTriangle& T_GnssPvtData::getVelocityCovarianceMatrix () const {
    return _VelocityCovarianceMatrix;
}

inline T_CovarianceMatrixUpperTriangle& T_GnssPvtData::getVelocityCovarianceMatrixMutable () {
    set_has_VelocityCovarianceMatrix();
    return _VelocityCovarianceMatrix;
}

inline void T_GnssPvtData::setVelocityCovarianceMatrix (const T_CovarianceMatrixUpperTriangle& VelocityCovarianceMatrix_) {
    set_has_VelocityCovarianceMatrix();
    this->_VelocityCovarianceMatrix = VelocityCovarianceMatrix_;
}

inline void T_GnssPvtData::clearGnssStatus() {
    if (hasGnssStatus()) {
         clear_has_GnssStatus();
        _GnssStatus.clear();
     }
}

inline bool T_GnssPvtData::hasGnssStatus () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const T_GnssStatus& T_GnssPvtData::getGnssStatus () const {
    return _GnssStatus;
}

inline T_GnssStatus& T_GnssPvtData::getGnssStatusMutable () {
    set_has_GnssStatus();
    return _GnssStatus;
}

inline void T_GnssPvtData::setGnssStatus (const T_GnssStatus& GnssStatus_) {
    set_has_GnssStatus();
    this->_GnssStatus = GnssStatus_;
}

inline void T_GnssPvtData::clearGDOP() {
    if (hasGDOP()) {
         clear_has_GDOP();
        _GDOP = 0.0f;
     }
}

inline bool T_GnssPvtData::hasGDOP () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline float T_GnssPvtData::getGDOP () const {
    return _GDOP;
}

inline void T_GnssPvtData::setGDOP (float GDOP_) {
    set_has_GDOP();
    this->_GDOP = GDOP_;
}

inline void T_GnssPvtData::clearPDOP() {
    if (hasPDOP()) {
         clear_has_PDOP();
        _PDOP = 0.0f;
     }
}

inline bool T_GnssPvtData::hasPDOP () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline float T_GnssPvtData::getPDOP () const {
    return _PDOP;
}

inline void T_GnssPvtData::setPDOP (float PDOP_) {
    set_has_PDOP();
    this->_PDOP = PDOP_;
}

inline void T_GnssPvtData::clearHDOP() {
    if (hasHDOP()) {
         clear_has_HDOP();
        _HDOP = 0.0f;
     }
}

inline bool T_GnssPvtData::hasHDOP () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline float T_GnssPvtData::getHDOP () const {
    return _HDOP;
}

inline void T_GnssPvtData::setHDOP (float HDOP_) {
    set_has_HDOP();
    this->_HDOP = HDOP_;
}

inline void T_GnssPvtData::clearTDOP() {
    if (hasTDOP()) {
         clear_has_TDOP();
        _TDOP = 0.0f;
     }
}

inline bool T_GnssPvtData::hasTDOP () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline float T_GnssPvtData::getTDOP () const {
    return _TDOP;
}

inline void T_GnssPvtData::setTDOP (float TDOP_) {
    set_has_TDOP();
    this->_TDOP = TDOP_;
}

inline void T_GnssPvtData::clearVDOP() {
    if (hasVDOP()) {
         clear_has_VDOP();
        _VDOP = 0.0f;
     }
}

inline bool T_GnssPvtData::hasVDOP () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline float T_GnssPvtData::getVDOP () const {
    return _VDOP;
}

inline void T_GnssPvtData::setVDOP (float VDOP_) {
    set_has_VDOP();
    this->_VDOP = VDOP_;
}

inline void T_GnssPvtData::clearSatSysUsed() {
    if (hasSatSysUsed()) {
         clear_has_SatSysUsed();
        _SatSysUsed = T_b8_GnssSatSys ();
     }
}

inline bool T_GnssPvtData::hasSatSysUsed () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline const T_b8_GnssSatSys& T_GnssPvtData::getSatSysUsed () const {
    return _SatSysUsed;
}

inline T_b8_GnssSatSys& T_GnssPvtData::getSatSysUsedMutable () {
    set_has_SatSysUsed();
    return _SatSysUsed;
}

inline void T_GnssPvtData::setSatSysUsed (const T_b8_GnssSatSys& SatSysUsed_) {
    set_has_SatSysUsed();
    this->_SatSysUsed = SatSysUsed_;
}

inline void T_GnssPvtData::clearSatellitesVisible() {
    if (hasSatellitesVisible()) {
         clear_has_SatellitesVisible();
        _SatellitesVisible = 0u;
     }
}

inline bool T_GnssPvtData::hasSatellitesVisible () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline uint16 T_GnssPvtData::getSatellitesVisible () const {
    return _SatellitesVisible;
}

inline void T_GnssPvtData::setSatellitesVisible (uint16 SatellitesVisible_) {
    set_has_SatellitesVisible();
    this->_SatellitesVisible = SatellitesVisible_;
}

inline void T_GnssPvtData::clearSatellitesReceived() {
    if (hasSatellitesReceived()) {
         clear_has_SatellitesReceived();
        _SatellitesReceived = 0u;
     }
}

inline bool T_GnssPvtData::hasSatellitesReceived () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline uint16 T_GnssPvtData::getSatellitesReceived () const {
    return _SatellitesReceived;
}

inline void T_GnssPvtData::setSatellitesReceived (uint16 SatellitesReceived_) {
    set_has_SatellitesReceived();
    this->_SatellitesReceived = SatellitesReceived_;
}

inline void T_GnssPvtData::clearSatellitesUsed() {
    if (hasSatellitesUsed()) {
         clear_has_SatellitesUsed();
        _SatellitesUsed = 0u;
     }
}

inline bool T_GnssPvtData::hasSatellitesUsed () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline uint16 T_GnssPvtData::getSatellitesUsed () const {
    return _SatellitesUsed;
}

inline void T_GnssPvtData::setSatellitesUsed (uint16 SatellitesUsed_) {
    set_has_SatellitesUsed();
    this->_SatellitesUsed = SatellitesUsed_;
}

inline void T_GnssPvtData::set_has_UtcTimeDate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_GnssPvtData::clear_has_UtcTimeDate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_GnssPvtData::set_has_Latitude () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_GnssPvtData::clear_has_Latitude () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_GnssPvtData::set_has_Longitude () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_GnssPvtData::clear_has_Longitude () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_GnssPvtData::set_has_AltitudeWGS84 () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_GnssPvtData::clear_has_AltitudeWGS84 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_GnssPvtData::set_has_GeoidalSeparation () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_GnssPvtData::clear_has_GeoidalSeparation () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_GnssPvtData::set_has_VelocityNorth () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_GnssPvtData::clear_has_VelocityNorth () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_GnssPvtData::set_has_VelocityEast () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_GnssPvtData::clear_has_VelocityEast () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_GnssPvtData::set_has_VelocityUp () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_GnssPvtData::clear_has_VelocityUp () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_GnssPvtData::set_has_PositionCovarianceMatrix () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_GnssPvtData::clear_has_PositionCovarianceMatrix () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_GnssPvtData::set_has_VelocityCovarianceMatrix () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_GnssPvtData::clear_has_VelocityCovarianceMatrix () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_GnssPvtData::set_has_GnssStatus () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_GnssPvtData::clear_has_GnssStatus () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_GnssPvtData::set_has_GDOP () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_GnssPvtData::clear_has_GDOP () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_GnssPvtData::set_has_PDOP () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_GnssPvtData::clear_has_PDOP () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_GnssPvtData::set_has_HDOP () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_GnssPvtData::clear_has_HDOP () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_GnssPvtData::set_has_TDOP () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_GnssPvtData::clear_has_TDOP () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_GnssPvtData::set_has_VDOP () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_GnssPvtData::clear_has_VDOP () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_GnssPvtData::set_has_SatSysUsed () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_GnssPvtData::clear_has_SatSysUsed () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_GnssPvtData::set_has_SatellitesVisible () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_GnssPvtData::clear_has_SatellitesVisible () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_GnssPvtData::set_has_SatellitesReceived () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_GnssPvtData::clear_has_SatellitesReceived () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_GnssPvtData::set_has_SatellitesUsed () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_GnssPvtData::clear_has_SatellitesUsed () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline  T_GnssChanData::T_GnssChanData ()  :
    _SvId (0u),
    _SatStatus (),
    _Azimuth (0.0f),
    _Elevation (0.0f),
    _CarrierToNoiseRatio (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_GnssChanData::T_GnssChanData (const T_GnssChanData &rhs)  :
    _SvId (0u),
    _SatStatus (),
    _Azimuth (0.0f),
    _Elevation (0.0f),
    _CarrierToNoiseRatio (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_GnssChanData::T_GnssChanData (uint16 SvId_, const T_b8_GnssSatStatus& SatStatus_, float Azimuth_, float Elevation_, uint8 CarrierToNoiseRatio_)  :
    _SvId (SvId_),
    _SatStatus (SatStatus_),
    _Azimuth (Azimuth_),
    _Elevation (Elevation_),
    _CarrierToNoiseRatio (CarrierToNoiseRatio_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_GnssChanData::~T_GnssChanData() {
}

inline T_GnssChanData& T_GnssChanData::operator = (const T_GnssChanData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSvId()) {
            setSvId(rhs.getSvId());
        } else {
            clearSvId();
        }
        if (rhs.hasSatStatus()) {
            setSatStatus(rhs.getSatStatus());
        } else {
            clearSatStatus();
        }
        if (rhs.hasAzimuth()) {
            setAzimuth(rhs.getAzimuth());
        } else {
            clearAzimuth();
        }
        if (rhs.hasElevation()) {
            setElevation(rhs.getElevation());
        } else {
            clearElevation();
        }
        if (rhs.hasCarrierToNoiseRatio()) {
            setCarrierToNoiseRatio(rhs.getCarrierToNoiseRatio());
        } else {
            clearCarrierToNoiseRatio();
        }
    }
    return *this;
}

inline bool T_GnssChanData::operator == (const T_GnssChanData& rhs) const {
    return (((!hasSvId() && !rhs.hasSvId()) || getSvId() == rhs.getSvId()) &&
        ((!hasSatStatus() && !rhs.hasSatStatus()) || getSatStatus() == rhs.getSatStatus()) &&
        ((!hasAzimuth() && !rhs.hasAzimuth()) || getAzimuth() == rhs.getAzimuth()) &&
        ((!hasElevation() && !rhs.hasElevation()) || getElevation() == rhs.getElevation()) &&
        ((!hasCarrierToNoiseRatio() && !rhs.hasCarrierToNoiseRatio()) || getCarrierToNoiseRatio() == rhs.getCarrierToNoiseRatio()));
}

inline bool T_GnssChanData::operator != (const T_GnssChanData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_GnssChanData::operator < (const T_GnssChanData& rhs) const {
    if (hasSvId() || rhs.hasSvId()) {
        if (getSvId() < rhs.getSvId()) return true;
        if (getSvId() > rhs.getSvId()) return false;
    }
    if (hasSatStatus() || rhs.hasSatStatus()) {
        if (getSatStatus() < rhs.getSatStatus()) return true;
        if (getSatStatus() > rhs.getSatStatus()) return false;
    }
    if (hasAzimuth() || rhs.hasAzimuth()) {
        if (getAzimuth() < rhs.getAzimuth()) return true;
        if (getAzimuth() > rhs.getAzimuth()) return false;
    }
    if (hasElevation() || rhs.hasElevation()) {
        if (getElevation() < rhs.getElevation()) return true;
        if (getElevation() > rhs.getElevation()) return false;
    }
    if (hasCarrierToNoiseRatio() || rhs.hasCarrierToNoiseRatio()) {
        if (getCarrierToNoiseRatio() < rhs.getCarrierToNoiseRatio()) return true;
        if (getCarrierToNoiseRatio() > rhs.getCarrierToNoiseRatio()) return false;
    }
    return false;
}

inline bool T_GnssChanData::operator > (const T_GnssChanData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_GnssChanData::clear() {
    clearSvId();
    clearSatStatus();
    clearAzimuth();
    clearElevation();
    clearCarrierToNoiseRatio();
}

inline void T_GnssChanData::clearSvId() {
    if (hasSvId()) {
         clear_has_SvId();
        _SvId = 0u;
     }
}

inline bool T_GnssChanData::hasSvId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_GnssChanData::getSvId () const {
    return _SvId;
}

inline void T_GnssChanData::setSvId (uint16 SvId_) {
    set_has_SvId();
    this->_SvId = SvId_;
}

inline void T_GnssChanData::clearSatStatus() {
    if (hasSatStatus()) {
         clear_has_SatStatus();
        _SatStatus = T_b8_GnssSatStatus ();
     }
}

inline bool T_GnssChanData::hasSatStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_b8_GnssSatStatus& T_GnssChanData::getSatStatus () const {
    return _SatStatus;
}

inline T_b8_GnssSatStatus& T_GnssChanData::getSatStatusMutable () {
    set_has_SatStatus();
    return _SatStatus;
}

inline void T_GnssChanData::setSatStatus (const T_b8_GnssSatStatus& SatStatus_) {
    set_has_SatStatus();
    this->_SatStatus = SatStatus_;
}

inline void T_GnssChanData::clearAzimuth() {
    if (hasAzimuth()) {
         clear_has_Azimuth();
        _Azimuth = 0.0f;
     }
}

inline bool T_GnssChanData::hasAzimuth () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline float T_GnssChanData::getAzimuth () const {
    return _Azimuth;
}

inline void T_GnssChanData::setAzimuth (float Azimuth_) {
    set_has_Azimuth();
    this->_Azimuth = Azimuth_;
}

inline void T_GnssChanData::clearElevation() {
    if (hasElevation()) {
         clear_has_Elevation();
        _Elevation = 0.0f;
     }
}

inline bool T_GnssChanData::hasElevation () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline float T_GnssChanData::getElevation () const {
    return _Elevation;
}

inline void T_GnssChanData::setElevation (float Elevation_) {
    set_has_Elevation();
    this->_Elevation = Elevation_;
}

inline void T_GnssChanData::clearCarrierToNoiseRatio() {
    if (hasCarrierToNoiseRatio()) {
         clear_has_CarrierToNoiseRatio();
        _CarrierToNoiseRatio = 0u;
     }
}

inline bool T_GnssChanData::hasCarrierToNoiseRatio () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_GnssChanData::getCarrierToNoiseRatio () const {
    return _CarrierToNoiseRatio;
}

inline void T_GnssChanData::setCarrierToNoiseRatio (uint8 CarrierToNoiseRatio_) {
    set_has_CarrierToNoiseRatio();
    this->_CarrierToNoiseRatio = CarrierToNoiseRatio_;
}

inline void T_GnssChanData::set_has_SvId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_GnssChanData::clear_has_SvId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_GnssChanData::set_has_SatStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_GnssChanData::clear_has_SatStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_GnssChanData::set_has_Azimuth () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_GnssChanData::clear_has_Azimuth () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_GnssChanData::set_has_Elevation () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_GnssChanData::clear_has_Elevation () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_GnssChanData::set_has_CarrierToNoiseRatio () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_GnssChanData::clear_has_CarrierToNoiseRatio () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_GnssData::T_GnssData ()  :
    _Timestamp (0u),
    _GnssPvtData (),
    _GnssChanDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_GnssData::T_GnssData (const T_GnssData &rhs)  :
    _Timestamp (0u),
    _GnssPvtData (),
    _GnssChanDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_GnssData::T_GnssData (uint32 Timestamp_, const T_GnssPvtData& GnssPvtData_, const ::std::vector< T_GnssChanData >& GnssChanDataList_)  :
    _Timestamp (Timestamp_),
    _GnssPvtData (GnssPvtData_),
    _GnssChanDataList (GnssChanDataList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_GnssData::~T_GnssData() {
}

inline T_GnssData& T_GnssData::operator = (const T_GnssData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTimestamp()) {
            setTimestamp(rhs.getTimestamp());
        } else {
            clearTimestamp();
        }
        if (rhs.hasGnssPvtData()) {
            setGnssPvtData(rhs.getGnssPvtData());
        } else {
            clearGnssPvtData();
        }
        if (rhs.hasGnssChanDataList()) {
            setGnssChanDataList(rhs.getGnssChanDataList());
        } else {
            clearGnssChanDataList();
        }
    }
    return *this;
}

inline bool T_GnssData::operator == (const T_GnssData& rhs) const {
    return (((!hasTimestamp() && !rhs.hasTimestamp()) || getTimestamp() == rhs.getTimestamp()) &&
        ((!hasGnssPvtData() && !rhs.hasGnssPvtData()) || getGnssPvtData() == rhs.getGnssPvtData()) &&
        ((!hasGnssChanDataList() && !rhs.hasGnssChanDataList()) || getGnssChanDataList() == rhs.getGnssChanDataList()));
}

inline bool T_GnssData::operator != (const T_GnssData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_GnssData::operator < (const T_GnssData& rhs) const {
    if (hasTimestamp() || rhs.hasTimestamp()) {
        if (getTimestamp() < rhs.getTimestamp()) return true;
        if (getTimestamp() > rhs.getTimestamp()) return false;
    }
    if (hasGnssPvtData() || rhs.hasGnssPvtData()) {
        if (getGnssPvtData() < rhs.getGnssPvtData()) return true;
        if (getGnssPvtData() > rhs.getGnssPvtData()) return false;
    }
    if (hasGnssChanDataList() || rhs.hasGnssChanDataList()) {
        if (getGnssChanDataList() < rhs.getGnssChanDataList()) return true;
        if (getGnssChanDataList() > rhs.getGnssChanDataList()) return false;
    }
    return false;
}

inline bool T_GnssData::operator > (const T_GnssData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_GnssData::clear() {
    clearTimestamp();
    clearGnssPvtData();
    clearGnssChanDataList();
}

inline void T_GnssData::clearTimestamp() {
    if (hasTimestamp()) {
         clear_has_Timestamp();
        _Timestamp = 0u;
     }
}

inline bool T_GnssData::hasTimestamp () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_GnssData::getTimestamp () const {
    return _Timestamp;
}

inline void T_GnssData::setTimestamp (uint32 Timestamp_) {
    set_has_Timestamp();
    this->_Timestamp = Timestamp_;
}

inline void T_GnssData::clearGnssPvtData() {
    if (hasGnssPvtData()) {
         clear_has_GnssPvtData();
        _GnssPvtData.clear();
     }
}

inline bool T_GnssData::hasGnssPvtData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_GnssPvtData& T_GnssData::getGnssPvtData () const {
    return _GnssPvtData;
}

inline T_GnssPvtData& T_GnssData::getGnssPvtDataMutable () {
    set_has_GnssPvtData();
    return _GnssPvtData;
}

inline void T_GnssData::setGnssPvtData (const T_GnssPvtData& GnssPvtData_) {
    set_has_GnssPvtData();
    this->_GnssPvtData = GnssPvtData_;
}

inline void T_GnssData::clearGnssChanDataList() {
    if (hasGnssChanDataList()) {
         clear_has_GnssChanDataList();
        _GnssChanDataList.clear();
     }
}

inline bool T_GnssData::hasGnssChanDataList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< T_GnssChanData >& T_GnssData::getGnssChanDataList () const {
    return _GnssChanDataList;
}

inline ::std::vector< T_GnssChanData >& T_GnssData::getGnssChanDataListMutable () {
    set_has_GnssChanDataList();
    return _GnssChanDataList;
}

inline void T_GnssData::setGnssChanDataList (const ::std::vector< T_GnssChanData >& GnssChanDataList_) {
    set_has_GnssChanDataList();
    this->_GnssChanDataList = GnssChanDataList_;
}

inline void T_GnssData::set_has_Timestamp () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_GnssData::clear_has_Timestamp () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_GnssData::set_has_GnssPvtData () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_GnssData::clear_has_GnssPvtData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_GnssData::set_has_GnssChanDataList () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_GnssData::clear_has_GnssChanDataList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_AllSensorData::T_AllSensorData ()  :
    _GnssUpdate (),
    _OdometerUpdate (),
    _AbsUpdate (),
    _GyroUpdate (),
    _GyroTemperature (0.0f),
    _AccUpdate (),
    _AccTemperature (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AllSensorData::T_AllSensorData (const T_AllSensorData &rhs)  :
    _GnssUpdate (),
    _OdometerUpdate (),
    _AbsUpdate (),
    _GyroUpdate (),
    _GyroTemperature (0.0f),
    _AccUpdate (),
    _AccTemperature (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AllSensorData::T_AllSensorData (const ::std::vector< T_GnssData >& GnssUpdate_, const ::std::vector< T_OdometerData >& OdometerUpdate_, const ::std::vector< T_AbsData >& AbsUpdate_, const ::std::vector< T_3dGyroData >& GyroUpdate_, float GyroTemperature_, const ::std::vector< T_3dAccData >& AccUpdate_, float AccTemperature_)  :
    _GnssUpdate (GnssUpdate_),
    _OdometerUpdate (OdometerUpdate_),
    _AbsUpdate (AbsUpdate_),
    _GyroUpdate (GyroUpdate_),
    _GyroTemperature (GyroTemperature_),
    _AccUpdate (AccUpdate_),
    _AccTemperature (AccTemperature_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AllSensorData::~T_AllSensorData() {
}

inline T_AllSensorData& T_AllSensorData::operator = (const T_AllSensorData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGnssUpdate()) {
            setGnssUpdate(rhs.getGnssUpdate());
        } else {
            clearGnssUpdate();
        }
        if (rhs.hasOdometerUpdate()) {
            setOdometerUpdate(rhs.getOdometerUpdate());
        } else {
            clearOdometerUpdate();
        }
        if (rhs.hasAbsUpdate()) {
            setAbsUpdate(rhs.getAbsUpdate());
        } else {
            clearAbsUpdate();
        }
        if (rhs.hasGyroUpdate()) {
            setGyroUpdate(rhs.getGyroUpdate());
        } else {
            clearGyroUpdate();
        }
        if (rhs.hasGyroTemperature()) {
            setGyroTemperature(rhs.getGyroTemperature());
        } else {
            clearGyroTemperature();
        }
        if (rhs.hasAccUpdate()) {
            setAccUpdate(rhs.getAccUpdate());
        } else {
            clearAccUpdate();
        }
        if (rhs.hasAccTemperature()) {
            setAccTemperature(rhs.getAccTemperature());
        } else {
            clearAccTemperature();
        }
    }
    return *this;
}

inline bool T_AllSensorData::operator == (const T_AllSensorData& rhs) const {
    return (((!hasGnssUpdate() && !rhs.hasGnssUpdate()) || getGnssUpdate() == rhs.getGnssUpdate()) &&
        ((!hasOdometerUpdate() && !rhs.hasOdometerUpdate()) || getOdometerUpdate() == rhs.getOdometerUpdate()) &&
        ((!hasAbsUpdate() && !rhs.hasAbsUpdate()) || getAbsUpdate() == rhs.getAbsUpdate()) &&
        ((!hasGyroUpdate() && !rhs.hasGyroUpdate()) || getGyroUpdate() == rhs.getGyroUpdate()) &&
        ((!hasGyroTemperature() && !rhs.hasGyroTemperature()) || getGyroTemperature() == rhs.getGyroTemperature()) &&
        ((!hasAccUpdate() && !rhs.hasAccUpdate()) || getAccUpdate() == rhs.getAccUpdate()) &&
        ((!hasAccTemperature() && !rhs.hasAccTemperature()) || getAccTemperature() == rhs.getAccTemperature()));
}

inline bool T_AllSensorData::operator != (const T_AllSensorData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AllSensorData::operator < (const T_AllSensorData& rhs) const {
    if (hasGnssUpdate() || rhs.hasGnssUpdate()) {
        if (getGnssUpdate() < rhs.getGnssUpdate()) return true;
        if (getGnssUpdate() > rhs.getGnssUpdate()) return false;
    }
    if (hasOdometerUpdate() || rhs.hasOdometerUpdate()) {
        if (getOdometerUpdate() < rhs.getOdometerUpdate()) return true;
        if (getOdometerUpdate() > rhs.getOdometerUpdate()) return false;
    }
    if (hasAbsUpdate() || rhs.hasAbsUpdate()) {
        if (getAbsUpdate() < rhs.getAbsUpdate()) return true;
        if (getAbsUpdate() > rhs.getAbsUpdate()) return false;
    }
    if (hasGyroUpdate() || rhs.hasGyroUpdate()) {
        if (getGyroUpdate() < rhs.getGyroUpdate()) return true;
        if (getGyroUpdate() > rhs.getGyroUpdate()) return false;
    }
    if (hasGyroTemperature() || rhs.hasGyroTemperature()) {
        if (getGyroTemperature() < rhs.getGyroTemperature()) return true;
        if (getGyroTemperature() > rhs.getGyroTemperature()) return false;
    }
    if (hasAccUpdate() || rhs.hasAccUpdate()) {
        if (getAccUpdate() < rhs.getAccUpdate()) return true;
        if (getAccUpdate() > rhs.getAccUpdate()) return false;
    }
    if (hasAccTemperature() || rhs.hasAccTemperature()) {
        if (getAccTemperature() < rhs.getAccTemperature()) return true;
        if (getAccTemperature() > rhs.getAccTemperature()) return false;
    }
    return false;
}

inline bool T_AllSensorData::operator > (const T_AllSensorData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AllSensorData::clear() {
    clearGnssUpdate();
    clearOdometerUpdate();
    clearAbsUpdate();
    clearGyroUpdate();
    clearGyroTemperature();
    clearAccUpdate();
    clearAccTemperature();
}

inline void T_AllSensorData::clearGnssUpdate() {
    if (hasGnssUpdate()) {
         clear_has_GnssUpdate();
        _GnssUpdate.clear();
     }
}

inline bool T_AllSensorData::hasGnssUpdate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< T_GnssData >& T_AllSensorData::getGnssUpdate () const {
    return _GnssUpdate;
}

inline ::std::vector< T_GnssData >& T_AllSensorData::getGnssUpdateMutable () {
    set_has_GnssUpdate();
    return _GnssUpdate;
}

inline void T_AllSensorData::setGnssUpdate (const ::std::vector< T_GnssData >& GnssUpdate_) {
    set_has_GnssUpdate();
    this->_GnssUpdate = GnssUpdate_;
}

inline void T_AllSensorData::clearOdometerUpdate() {
    if (hasOdometerUpdate()) {
         clear_has_OdometerUpdate();
        _OdometerUpdate.clear();
     }
}

inline bool T_AllSensorData::hasOdometerUpdate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_OdometerData >& T_AllSensorData::getOdometerUpdate () const {
    return _OdometerUpdate;
}

inline ::std::vector< T_OdometerData >& T_AllSensorData::getOdometerUpdateMutable () {
    set_has_OdometerUpdate();
    return _OdometerUpdate;
}

inline void T_AllSensorData::setOdometerUpdate (const ::std::vector< T_OdometerData >& OdometerUpdate_) {
    set_has_OdometerUpdate();
    this->_OdometerUpdate = OdometerUpdate_;
}

inline void T_AllSensorData::clearAbsUpdate() {
    if (hasAbsUpdate()) {
         clear_has_AbsUpdate();
        _AbsUpdate.clear();
     }
}

inline bool T_AllSensorData::hasAbsUpdate () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< T_AbsData >& T_AllSensorData::getAbsUpdate () const {
    return _AbsUpdate;
}

inline ::std::vector< T_AbsData >& T_AllSensorData::getAbsUpdateMutable () {
    set_has_AbsUpdate();
    return _AbsUpdate;
}

inline void T_AllSensorData::setAbsUpdate (const ::std::vector< T_AbsData >& AbsUpdate_) {
    set_has_AbsUpdate();
    this->_AbsUpdate = AbsUpdate_;
}

inline void T_AllSensorData::clearGyroUpdate() {
    if (hasGyroUpdate()) {
         clear_has_GyroUpdate();
        _GyroUpdate.clear();
     }
}

inline bool T_AllSensorData::hasGyroUpdate () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< T_3dGyroData >& T_AllSensorData::getGyroUpdate () const {
    return _GyroUpdate;
}

inline ::std::vector< T_3dGyroData >& T_AllSensorData::getGyroUpdateMutable () {
    set_has_GyroUpdate();
    return _GyroUpdate;
}

inline void T_AllSensorData::setGyroUpdate (const ::std::vector< T_3dGyroData >& GyroUpdate_) {
    set_has_GyroUpdate();
    this->_GyroUpdate = GyroUpdate_;
}

inline void T_AllSensorData::clearGyroTemperature() {
    if (hasGyroTemperature()) {
         clear_has_GyroTemperature();
        _GyroTemperature = 0.0f;
     }
}

inline bool T_AllSensorData::hasGyroTemperature () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline float T_AllSensorData::getGyroTemperature () const {
    return _GyroTemperature;
}

inline void T_AllSensorData::setGyroTemperature (float GyroTemperature_) {
    set_has_GyroTemperature();
    this->_GyroTemperature = GyroTemperature_;
}

inline void T_AllSensorData::clearAccUpdate() {
    if (hasAccUpdate()) {
         clear_has_AccUpdate();
        _AccUpdate.clear();
     }
}

inline bool T_AllSensorData::hasAccUpdate () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::vector< T_3dAccData >& T_AllSensorData::getAccUpdate () const {
    return _AccUpdate;
}

inline ::std::vector< T_3dAccData >& T_AllSensorData::getAccUpdateMutable () {
    set_has_AccUpdate();
    return _AccUpdate;
}

inline void T_AllSensorData::setAccUpdate (const ::std::vector< T_3dAccData >& AccUpdate_) {
    set_has_AccUpdate();
    this->_AccUpdate = AccUpdate_;
}

inline void T_AllSensorData::clearAccTemperature() {
    if (hasAccTemperature()) {
         clear_has_AccTemperature();
        _AccTemperature = 0.0f;
     }
}

inline bool T_AllSensorData::hasAccTemperature () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline float T_AllSensorData::getAccTemperature () const {
    return _AccTemperature;
}

inline void T_AllSensorData::setAccTemperature (float AccTemperature_) {
    set_has_AccTemperature();
    this->_AccTemperature = AccTemperature_;
}

inline void T_AllSensorData::set_has_GnssUpdate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AllSensorData::clear_has_GnssUpdate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AllSensorData::set_has_OdometerUpdate () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AllSensorData::clear_has_OdometerUpdate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AllSensorData::set_has_AbsUpdate () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AllSensorData::clear_has_AbsUpdate () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AllSensorData::set_has_GyroUpdate () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AllSensorData::clear_has_GyroUpdate () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_AllSensorData::set_has_GyroTemperature () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_AllSensorData::clear_has_GyroTemperature () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_AllSensorData::set_has_AccUpdate () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_AllSensorData::clear_has_AccUpdate () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_AllSensorData::set_has_AccTemperature () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_AllSensorData::clear_has_AccTemperature () {
    _has_bits_[0] &= ~ (1u << 6);
}

} // namespace location_fi_types

#endif // LOCATION_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
