/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "app/core/ProfileMngrOnline.h"
#include "app/core/ProfileMngrOnlineComp.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "ProfileMngrOnline" isn't clear, then there should be a description here.
 */

namespace app {
namespace core {

DEFINE_LOGGER_AND_LEVEL (_logger, "/app/core/ProfileMngrOnline", Info);

/* static */ const char* ProfileMngrOnline::asfComponent = "asfComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool ProfileMngrOnline_enabledASFSignalHandler = false;

void importProfileMngrOnline() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach ProfileMngrOnline, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression1;
        {
            __expression1.setApplicationId(260);
        }
        ccaConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'ProfileOnlineThread'

    ::asf::core::ComponentContainerSharedPtr ProfileOnlineThread(new ::asf::core::ComponentContainer("ProfileOnlineThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (ProfileOnlineThread);

        // Component 'ProfileMngrOnlineComp asfComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::app::core::ProfileMngrOnlineComp > > asfComponentFactory(new ::asf::core::ComponentFactory< ::app::core::ProfileMngrOnlineComp >);
        ::asf::core::ComponentDescriptionSharedPtr asfComponentDescription(new ::asf::core::ComponentDescription(1, "asfComponent", /* immediate = */ true, /* threadBridge = */ false, asfComponentFactory));
        ProfileOnlineThread->addComponentDescription(asfComponentDescription);

            // Port 'profileMngrOnlineDBUSPort'

            ::asf::core::ProvidedPort& asfComponent_profileMngrOnlineDBUSPort = asfComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.profileConnected", "profileMngrOnlineDBUSPort", false, false));
            (void)asfComponent_profileMngrOnlineDBUSPort; // prevent unused variable warning

            // Port 'configDataPort'

            ::asf::core::ProvidedPort& asfComponent_configDataPort = asfComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("de.bosch.cm.ConfigManager.ConfigData", "configDataPort", false, false));
            (void)asfComponent_configDataPort; // prevent unused variable warning

            // Port 'ConfigManagementClientFiPort'

            ::asf::core::RequiredPort& asfComponent_ConfigManagementClientFiPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("de.bosch.cm.ConfigManager.ConfigManagement", "ConfigManagementClientFiPort"));
            (void)asfComponent_ConfigManagementClientFiPort; // prevent unused variable warning

            // Port 'userProfilePort'

            ::asf::core::RequiredPort& asfComponent_userProfilePort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.profile", "userProfilePort"));
            (void)asfComponent_userProfilePort; // prevent unused variable warning

            // Port 'tcuUsbMainFiPort'

            ::asf::core::RequiredPort& asfComponent_tcuUsbMainFiPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("tcu_usb_main_fi", "tcuUsbMainFiPort"));
            (void)asfComponent_tcuUsbMainFiPort; // prevent unused variable warning

            // Port 'fcdummservicePort'

            ::asf::core::RequiredPort& asfComponent_fcdummservicePort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("com.bosch.cm.dumm.DummService", "fcdummservicePort"));
            (void)asfComponent_fcdummservicePort; // prevent unused variable warning

    // Expression

    dbusSessionConnector_->exportByName (asfComponent_profileMngrOnlineDBUSPort, ::std::string("/com/bosch/cm/profileConnected"));

    // Expression

    dbusSessionConnector_->exportByName (asfComponent_configDataPort, ::std::string("/de/bosch/cm/ConfigManager/ConfigDataInterface"));

    // Expression

    ::asf::dbus::DBusImportedPort& ConfigManagementClientFiImport = dbusSessionConnector_->importByName (::std::string("asf.ProcConfigManager"), ::std::string("/de/bosch/cm/ConfigManager/ConfigManagement"));
    ConfigManagementClientFiImport.setServiceName("de.bosch.cm.ConfigManager.ConfigManagement");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_ConfigManagementClientFiPort, ConfigManagementClientFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& userProfileImport = dbusSessionConnector_->importByName (::std::string("app.core.ProfileMngr"), ::std::string("/com/bosch/cm/profileMngr"));
    userProfileImport.setServiceName("bosch.cm.profile");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_userProfilePort, userProfileImport);

    // Expression

    ::asf::cca::CcaImportedPort& tcuUsbMainFiImport = ccaConnector_->importByName (180, 1, 0, 2);
    tcuUsbMainFiImport.setServiceName("tcu_usb_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_tcuUsbMainFiPort, tcuUsbMainFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& fcdummserviceImport = dbusSessionConnector_->importByName (::std::string("org.bosch.cm.fc_dumm.Fc_dummAsf"), ::std::string("/com/bosch/cm/fc_dumm/server/DummService"));
    fcdummserviceImport.setServiceName("com.bosch.cm.dumm.DummService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_fcdummservicePort, fcdummserviceImport);


    LOG_INFO_STATIC("Starting application 'ProfileMngrOnline' version 1.0.0");

    app->start();
}

int executeProfileMngrOnline(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("app.core", "ProfileMngrOnline");
    } else {
        ::asf::core::Logger::setupLogging ("app.core", "ProfileMngrOnline", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", ProfileMngrOnline_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("app.core", "ProfileMngrOnline", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create ProfileMngrOnline");

    app->enableExceptionHandler(false);

    importProfileMngrOnline();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace core
} // namespace app

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::app::core::executeProfileMngrOnline(argc, argv);
}

