#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MPLAY_MEDIAPLAYER_FI_H
#define MPLAY_MEDIAPLAYER_FI_H

#include "MPlay_fi_types.h"
#include "MPlay_fi_typesConst.h"
#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "mplay_shared_fi_types.h"
#include "mplay_shared_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'mplay_MediaPlayer_FI'
 *
 * Fullname: Proprietary - MediaPlayer
 *
 * Version: 4.6
 *
 * Author: Stefan Scherber
 *
 * Date: 2016-06-22
 *
 * Department:
 *
 * Title:
 *       mplay_MediaPlayer_FI
 *
 * <b>Description of 'mplay_MediaPlayer_FI':</b>
 *
 * <p>The MediaPlayer performs the control and meta-data retrieval functions required to support playback of digital audio and video files.</p>
 */

namespace mplay_MediaPlayer_FI {

static const int SERVICE_ID = 558;

static const int FID_MediaPlayerListChange = 517;

static const int FID_NowPlaying = 519;

static const int FID_Playtime = 520;

static const int FID_PlaybackState = 521;

static const int FID_PlaybackMode = 528;

static const int FID_RepeatMode = 529;

static const int FID_IndexingState = 532;

static const int FID_MediaPlayerDeviceConnections = 537;

static const int FID_ActiveMediaDevice = 544;

static const int FID_MyMediaSupported = 560;

static const int FID_CurrentFolderPath = 565;

static const int FID_ScanMode = 566;

static const int FID_DiscError = 596;

static const int FID_DiscMechanicalInfo = 597;

static const int FID_CMSkipAvailable = 598;

static const int FID_DirectSelectAvailable = 599;

static const int FID_DVDAngleInfo = 600;

static const int FID_DVDSubtitleInfo = 601;

static const int FID_DVDAudioChannelInfo = 608;

static const int FID_DVDCurrentAudioInfo = 609;

static const int FID_DisplayMode = 610;

static const int FID_DVDPlayerLangSetting = 611;

static const int FID_AngleMarkSetting = 612;

static const int FID_PlayStatusSetting = 613;

static const int FID_DRCSetting = 614;

static const int FID_DVDCommandStatus = 615;

static const int FID_AutoRipping = 616;

static const int FID_GracenoteLookupMode = 617;

static const int FID_GracenoteVersion = 624;

static const int FID_RippingErrors = 625;

static const int FID_ResolveGracenoteAmbuiguities = 626;

static const int FID_DVDMenuPlaybackOngoing = 628;

static const int FID_DVDDriveInfo = 629;

static const int FID_RippingState = 792;

static const int FID_RippingEncodingQuality = 793;

static const int FID_GNMetadataExtractionStatus = 800;

static const int FID_Language = 1025;

static const int FID_PlaybackRepeatMode = 1041;

static const int FID_SlideshowTime = 1281;

static const int FID_NowShowing = 1283;

static const int FID_SlideshowState = 1284;

static const int FID_MediaPlayerOpticalDiscSlotState = 1540;

static const int FID_MediaPlayerOpticalDiscCDInfo = 1541;

static const int FID_iPodCommunicationError = 1542;

static const int FID_DeviceStreamingInfo = 1552;

static const int FID_VideoBrightness = 1633;

static const int FID_VideoHue = 1634;

static const int FID_VideoSaturation = 1635;

static const int FID_VideoContrast = 1636;

static const int FID_VideoBrightnessOffset = 1637;

static const int FID_VideoHueOffset = 1638;

static const int FID_VideoSaturationOffset = 1639;

static const int FID_VideoScaling = 1632;

static const int FID_UpdatePlaybackSpeed = 1640;

static const int FID_UserFavoritesChanged = 2309;

static const int FID_FolderBrowseStructureCleared = 2310;

static const int FID_ReadyToPlay = 38;

static const int FID_BluetoothAudioDeviceStatus = 630;

static const int FID_CreateMediaPlayerQuickPlayList = 514;

static const int FID_CreateMediaPlayerIndexedList = 515;

static const int FID_RequestMediaPlayerIndexedListSlice = 516;

static const int FID_ReleaseMediaPlayerList = 518;

static const int FID_RequestPlaybackAction = 530;

static const int FID_SeekTo = 531;

static const int FID_GetMediaObjectAlbumArt = 533;

static const int FID_SearchKeyboardMediaPlayerList = 534;

static const int FID_CreateMediaPlayerListSearchString = 535;

static const int FID_GetMediaObject = 536;

static const int FID_CreateMediaPlayerFileList = 545;

static const int FID_RequestMediaPlayerFileListSlice = 546;

static const int FID_CreateMediaPlayerPlaylistList = 547;

static const int FID_RequestMediaPlayerPlaylistListSlice = 548;

static const int FID_RequestMediaPlayerQuickPlayListSlice = 549;

static const int FID_GetMediaObjectAlbumArtInfo = 550;

static const int FID_PlayMediaPlayerObject = 552;

static const int FID_PlayItemFromList = 553;

static const int FID_ClearMediaPlayerData = 554;

static const int FID_Umount = 768;

static const int FID_Reindexing = 769;

static const int FID_DiagnosisPlaySong = 770;

static const int FID_RequestListDetails = 561;

static const int FID_RequestListInformation = 562;

static const int FID_TransferTagsToDevice = 563;

static const int FID_PlayItemFromListByTag = 564;

static const int FID_PlaybackSpeedSet = 567;

static const int FID_ClearLastModePause = 568;

static const int FID_RequestDiscOperation = 576;

static const int FID_RequestVCDAudioChannel = 577;

static const int FID_RequestDVDAudioChannel = 578;

static const int FID_SendNavigationKey = 579;

static const int FID_SendTouchCommand = 580;

static const int FID_RequestDirectSearch = 582;

static const int FID_RequestAngleChange = 583;

static const int FID_SetMenuPlayBackControl = 584;

static const int FID_SelectDirectNumber = 585;

static const int FID_RequestTitleSearch = 592;

static const int FID_RequestSubtitleChange = 594;

static const int FID_RequestCMSkip = 595;

static const int FID_RequestDVDTemperature = 627;

static const int FID_ReorderInternalPlaylist = 663;

static const int FID_DeleteMediaContentByFilterTags = 664;

static const int FID_DeleteMediaContentByMediaObjectTags = 665;

static const int FID_DeleteMediaContentByUrls = 772;

static const int FID_EditMetaDataByMediaObjectTag = 773;

static const int FID_EditMetaDataByMediaObjectUrl = 774;

static const int FID_StartRipping = 775;

static const int FID_StopRipping = 776;

static const int FID_ExtractGracenoteMetadata = 777;

static const int FID_CreateInternalFileNamePlaylist = 784;

static const int FID_AddFilenameToInternalPlaylist = 785;

static const int FID_DeleteEntryFromPlaylist = 786;

static const int FID_RenameInternalPlaylist = 787;

static const int FID_DeleteInternalPlaylist = 788;

static const int FID_CreateMediaPlayerInternalPlaylistList = 789;

static const int FID_RequestMediaPlayerInternalPlaylistListSlice = 790;

static const int FID_GetListPositionOfObject = 791;

static const int FID_CreateMediaPlayerFileListExt = 1024;

static const int FID_StartSlideshow = 1280;

static const int FID_RequestSlideshowAction = 1282;

static const int FID_Quicksearch = 1286;

static const int FID_EjectOpticalDisc = 1536;

static const int FID_CreateMediaPlayerIndexedImageFolderList = 1793;

static const int FID_RequestMediaPlayerIndexedImageFolderListSlice = 1794;

static const int FID_CreateMediaPlayerCDList = 1795;

static const int FID_RequestMediaPlayerFolderInfo = 2049;

static const int FID_SetFilePermissionByMediaObjectTags = 2050;

static const int FID_AddFilenameToInternalPlaylistByTags = 2051;

static const int FID_StorePersonalizedFavorite = 2305;

static const int FID_DeletePersonalizedFavorite = 2306;

static const int FID_CreateMediaPlayerGlobalSearchList = 555;

static const int FID_CreateMediaPlayerAlbumArtList = 557;

static const int FID_RequestMediaPlayerAlbumArtListSlice = 558;

static const int FID_SendAppleHIDCommand = 559;

static const int FID_RequestBluetoothAudioDevice = 801;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 4;

static const int VERSION_MINOR = 6;

static const int VERSION_PATCH = 0;

// forward declarations
class MediaPlayerListChangeStatus;

class NowPlayingStatus;

class PlaytimeStatus;

class PlaybackStateStatus;

class PlaybackModeStatus;

class PlaybackModeSet;

class RepeatModeStatus;

class RepeatModeSet;

class IndexingStateStatus;

class MediaPlayerDeviceConnectionsStatus;

class ActiveMediaDeviceStatus;

class ActiveMediaDeviceSet;

class MyMediaSupportedStatus;

class CurrentFolderPathStatus;

class ScanModeStatus;

class ScanModeSet;

class DiscErrorStatus;

class DiscMechanicalInfoStatus;

class CMSkipAvailableStatus;

class DirectSelectAvailableStatus;

class DVDAngleInfoStatus;

class DVDSubtitleInfoStatus;

class DVDAudioChannelInfoStatus;

class DVDCurrentAudioInfoStatus;

class DisplayModeStatus;

class DisplayModeSet;

class DVDPlayerLangSettingStatus;

class DVDPlayerLangSettingSet;

class AngleMarkSettingStatus;

class AngleMarkSettingSet;

class PlayStatusSettingStatus;

class PlayStatusSettingSet;

class DRCSettingStatus;

class DRCSettingSet;

class DVDCommandStatusStatus;

class AutoRippingStatus;

class AutoRippingSet;

class GracenoteLookupModeStatus;

class GracenoteLookupModeSet;

class GracenoteVersionStatus;

class RippingErrorsStatus;

class ResolveGracenoteAmbuiguitiesStatus;

class DVDMenuPlaybackOngoingStatus;

class DVDDriveInfoStatus;

class RippingStateStatus;

class RippingEncodingQualityStatus;

class RippingEncodingQualitySet;

class GNMetadataExtractionStatusStatus;

class LanguageStatus;

class LanguageSet;

class PlaybackRepeatModeStatus;

class PlaybackRepeatModeSet;

class SlideshowTimeStatus;

class SlideshowTimeSet;

class NowShowingStatus;

class SlideshowStateStatus;

class MediaPlayerOpticalDiscSlotStateStatus;

class MediaPlayerOpticalDiscCDInfoStatus;

class IPodCommunicationErrorStatus;

class DeviceStreamingInfoStatus;

class VideoBrightnessStatus;

class VideoBrightnessSet;

class VideoHueStatus;

class VideoHueSet;

class VideoSaturationStatus;

class VideoSaturationSet;

class VideoContrastStatus;

class VideoContrastSet;

class VideoBrightnessOffsetStatus;

class VideoBrightnessOffsetSet;

class VideoHueOffsetStatus;

class VideoHueOffsetSet;

class VideoSaturationOffsetStatus;

class VideoSaturationOffsetSet;

class VideoScalingStatus;

class VideoScalingSet;

class UpdatePlaybackSpeedStatus;

class UserFavoritesChangedStatus;

class FolderBrowseStructureClearedStatus;

class ReadyToPlayStatus;

class BluetoothAudioDeviceStatusStatus;

class CreateMediaPlayerQuickPlayListStart;

class CreateMediaPlayerQuickPlayListResult;

class CreateMediaPlayerIndexedListStart;

class CreateMediaPlayerIndexedListResult;

class RequestMediaPlayerIndexedListSliceStart;

class RequestMediaPlayerIndexedListSliceResult;

class ReleaseMediaPlayerListStart;

class RequestPlaybackActionStart;

class SeekToStart;

class GetMediaObjectAlbumArtStart;

class GetMediaObjectAlbumArtResult;

class SearchKeyboardMediaPlayerListStart;

class SearchKeyboardMediaPlayerListResult;

class CreateMediaPlayerListSearchStringStart;

class CreateMediaPlayerListSearchStringAbort;

class CreateMediaPlayerListSearchStringResultFirst;

class CreateMediaPlayerListSearchStringResultMiddle;

class CreateMediaPlayerListSearchStringResultLast;

class GetMediaObjectStart;

class GetMediaObjectResult;

class CreateMediaPlayerFileListStart;

class CreateMediaPlayerFileListResult;

class RequestMediaPlayerFileListSliceStart;

class RequestMediaPlayerFileListSliceResult;

class CreateMediaPlayerPlaylistListStart;

class CreateMediaPlayerPlaylistListResult;

class RequestMediaPlayerPlaylistListSliceStart;

class RequestMediaPlayerPlaylistListSliceResult;

class RequestMediaPlayerQuickPlayListSliceStart;

class RequestMediaPlayerQuickPlayListSliceResult;

class GetMediaObjectAlbumArtInfoStart;

class GetMediaObjectAlbumArtInfoResult;

class PlayMediaPlayerObjectStart;

class PlayMediaPlayerObjectResult;

class PlayItemFromListStart;

class PlayItemFromListResult;

class UmountStart;

class UmountResult;

class ReindexingStart;

class DiagnosisPlaySongStart;

class RequestListDetailsStart;

class RequestListDetailsResult;

class RequestListInformationStart;

class RequestListInformationResult;

class TransferTagsToDeviceStart;

class TransferTagsToDeviceResult;

class PlayItemFromListByTagStart;

class PlaybackSpeedSetStart;

class PlaybackSpeedSetResult;

class ClearLastModePauseStart;

class RequestDiscOperationStart;

class RequestVCDAudioChannelStart;

class RequestDVDAudioChannelStart;

class SendNavigationKeyStart;

class SendTouchCommandStart;

class RequestDirectSearchStart;

class RequestAngleChangeStart;

class SetMenuPlayBackControlStart;

class SelectDirectNumberStart;

class RequestTitleSearchStart;

class RequestSubtitleChangeStart;

class RequestCMSkipStart;

class RequestDVDTemperatureResult;

class ReorderInternalPlaylistStart;

class ReorderInternalPlaylistResult;

class DeleteMediaContentByFilterTagsStart;

class DeleteMediaContentByFilterTagsResult;

class DeleteMediaContentByMediaObjectTagsStart;

class DeleteMediaContentByMediaObjectTagsResult;

class DeleteMediaContentByUrlsStart;

class DeleteMediaContentByUrlsResult;

class EditMetaDataByMediaObjectTagStart;

class EditMetaDataByMediaObjectTagResult;

class EditMetaDataByMediaObjectUrlStart;

class EditMetaDataByMediaObjectUrlResult;

class ExtractGracenoteMetadataStart;

class CreateInternalFileNamePlaylistStart;

class CreateInternalFileNamePlaylistResult;

class AddFilenameToInternalPlaylistStart;

class AddFilenameToInternalPlaylistResult;

class DeleteEntryFromPlaylistStart;

class DeleteEntryFromPlaylistResult;

class RenameInternalPlaylistStart;

class RenameInternalPlaylistResult;

class DeleteInternalPlaylistStart;

class DeleteInternalPlaylistResult;

class CreateMediaPlayerInternalPlaylistListStart;

class CreateMediaPlayerInternalPlaylistListResult;

class RequestMediaPlayerInternalPlaylistListSliceStart;

class RequestMediaPlayerInternalPlaylistListSliceResult;

class GetListPositionOfObjectStart;

class GetListPositionOfObjectResult;

class CreateMediaPlayerFileListExtStart;

class CreateMediaPlayerFileListExtResult;

class StartSlideshowStart;

class RequestSlideshowActionStart;

class QuicksearchStart;

class QuicksearchResult;

class EjectOpticalDiscStart;

class EjectOpticalDiscResult;

class CreateMediaPlayerIndexedImageFolderListStart;

class CreateMediaPlayerIndexedImageFolderListResult;

class RequestMediaPlayerIndexedImageFolderListSliceStart;

class RequestMediaPlayerIndexedImageFolderListSliceResult;

class CreateMediaPlayerCDListStart;

class CreateMediaPlayerCDListResult;

class RequestMediaPlayerFolderInfoStart;

class RequestMediaPlayerFolderInfoResult;

class SetFilePermissionByMediaObjectTagsStart;

class SetFilePermissionByMediaObjectTagsResult;

class AddFilenameToInternalPlaylistByTagsStart;

class AddFilenameToInternalPlaylistByTagsResult;

class StorePersonalizedFavoriteStart;

class StorePersonalizedFavoriteResult;

class DeletePersonalizedFavoriteStart;

class DeletePersonalizedFavoriteResult;

class CreateMediaPlayerGlobalSearchListStart;

class CreateMediaPlayerGlobalSearchListResult;

class CreateMediaPlayerAlbumArtListStart;

class CreateMediaPlayerAlbumArtListResult;

class RequestMediaPlayerAlbumArtListSliceStart;

class RequestMediaPlayerAlbumArtListSliceResult;

class SendAppleHIDCommandStart;

class SendAppleHIDCommandResult;

class RequestBluetoothAudioDeviceStart;

class RequestBluetoothAudioDeviceResult;

// type definitions
/**
 * The upreg message of the property "MediaPlayerListChange"
 * The MediaPlayerListChange property provides notifications about changes
 * that occur in a created list.
 * These changes include:
 * Insertion of a new item into the list.
 * Removal of an item from the list.
 * A change in meta-data for an item in the list
 * A change of the PlaybackState of an item in the list (IsPlaying parameter)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayerListChangeUpReg;

/**
 * The relUpReg message of the property "MediaPlayerListChange"
 * The MediaPlayerListChange property provides notifications about changes
 * that occur in a created list.
 * These changes include:
 * Insertion of a new item into the list.
 * Removal of an item from the list.
 * A change in meta-data for an item in the list
 * A change of the PlaybackState of an item in the list (IsPlaying parameter)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayerListChangeRelUpReg;

/**
 * The error message of 'MediaPlayerListChange'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaPlayerListChangeError;

/**
 * The get message of the property "NowPlaying"
 * This property identifies all information about the currently playing item:
 * ListHandle of the active playlist.
 * Position within the list of the active item
 * The Tag value of the active item
 * Metadata for the active item
 * Tree of ListHandles from the root list down to the ListHandle of the
 * active playlist. This tree is used to restore the list hierarchy
 * relationships at initialization (internally saved by MediaPlayer).
 * This information is used to determine the item that is currently being
 * played. The information returned by the NowPlaying function can be used
 * with the RequestMediaPlayerPlaylistListSlice function to obtain all
 * meta-data information for the active item.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NowPlayingGet;

/**
 * The upreg message of the property "NowPlaying"
 * This property identifies all information about the currently playing item:
 * ListHandle of the active playlist.
 * Position within the list of the active item
 * The Tag value of the active item
 * Metadata for the active item
 * Tree of ListHandles from the root list down to the ListHandle of the
 * active playlist. This tree is used to restore the list hierarchy
 * relationships at initialization (internally saved by MediaPlayer).
 * This information is used to determine the item that is currently being
 * played. The information returned by the NowPlaying function can be used
 * with the RequestMediaPlayerPlaylistListSlice function to obtain all
 * meta-data information for the active item.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NowPlayingUpReg;

/**
 * The relUpReg message of the property "NowPlaying"
 * This property identifies all information about the currently playing item:
 * ListHandle of the active playlist.
 * Position within the list of the active item
 * The Tag value of the active item
 * Metadata for the active item
 * Tree of ListHandles from the root list down to the ListHandle of the
 * active playlist. This tree is used to restore the list hierarchy
 * relationships at initialization (internally saved by MediaPlayer).
 * This information is used to determine the item that is currently being
 * played. The information returned by the NowPlaying function can be used
 * with the RequestMediaPlayerPlaylistListSlice function to obtain all
 * meta-data information for the active item.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NowPlayingRelUpReg;

/**
 * The error message of 'NowPlaying'
 */
typedef ::asf::cca::CcaTypes::DefaultError NowPlayingError;

/**
 * The get message of the property "Playtime"
 * Identifies the amount of time elapsed and total duration of a media object.  Resolution is in seconds.  The MediaPlayer shall send out updates to registered HMI controllers upon each 1 second change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlaytimeGet;

/**
 * The upreg message of the property "Playtime"
 * Identifies the amount of time elapsed and total duration of a media object.  Resolution is in seconds.  The MediaPlayer shall send out updates to registered HMI controllers upon each 1 second change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlaytimeUpReg;

/**
 * The relUpReg message of the property "Playtime"
 * Identifies the amount of time elapsed and total duration of a media object.  Resolution is in seconds.  The MediaPlayer shall send out updates to registered HMI controllers upon each 1 second change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlaytimeRelUpReg;

/**
 * The error message of 'Playtime'
 */
typedef ::asf::cca::CcaTypes::DefaultError PlaytimeError;

/**
 * The get message of the property "PlaybackState"
 * The current playback state of the MediaPlayer
 * PBS_PLAYING: The Media Player is actively playing a media object. The
 * object being played can be obtained using the NowPlaying function
 * PBS_PAUSED: The Media Player is not actively playing a media object.
 * The item to queued to play can be obtained using the NowPlaying
 * function
 * PBS_STOPPED: The Media Player has stopped playback. The NowPlaying
 * function does not return an item
 * PBS_FFWD: The Media Player is fast forwarding.
 * PBS_FRWD: The Media Player is fast reversing.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlaybackStateGet;

/**
 * The upreg message of the property "PlaybackState"
 * The current playback state of the MediaPlayer
 * PBS_PLAYING: The Media Player is actively playing a media object. The
 * object being played can be obtained using the NowPlaying function
 * PBS_PAUSED: The Media Player is not actively playing a media object.
 * The item to queued to play can be obtained using the NowPlaying
 * function
 * PBS_STOPPED: The Media Player has stopped playback. The NowPlaying
 * function does not return an item
 * PBS_FFWD: The Media Player is fast forwarding.
 * PBS_FRWD: The Media Player is fast reversing.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlaybackStateUpReg;

/**
 * The relUpReg message of the property "PlaybackState"
 * The current playback state of the MediaPlayer
 * PBS_PLAYING: The Media Player is actively playing a media object. The
 * object being played can be obtained using the NowPlaying function
 * PBS_PAUSED: The Media Player is not actively playing a media object.
 * The item to queued to play can be obtained using the NowPlaying
 * function
 * PBS_STOPPED: The Media Player has stopped playback. The NowPlaying
 * function does not return an item
 * PBS_FFWD: The Media Player is fast forwarding.
 * PBS_FRWD: The Media Player is fast reversing.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlaybackStateRelUpReg;

/**
 * The error message of 'PlaybackState'
 */
typedef ::asf::cca::CcaTypes::DefaultError PlaybackStateError;

/**
 * The get message of the property "PlaybackMode"
 * The current playback mode of the media player instance:
 * Normal: Navigate through the active playlist sequentially
 * Random: Enable shuffle mode by playing items in the active playlist in
 * a random order
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlaybackModeGet;

/**
 * The upreg message of the property "PlaybackMode"
 * The current playback mode of the media player instance:
 * Normal: Navigate through the active playlist sequentially
 * Random: Enable shuffle mode by playing items in the active playlist in
 * a random order
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlaybackModeUpReg;

/**
 * The relUpReg message of the property "PlaybackMode"
 * The current playback mode of the media player instance:
 * Normal: Navigate through the active playlist sequentially
 * Random: Enable shuffle mode by playing items in the active playlist in
 * a random order
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlaybackModeRelUpReg;

/**
 * The error message of 'PlaybackMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError PlaybackModeError;

/**
 * The get message of the property "RepeatMode"
 * The current repeat setting of the media player instance
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RepeatModeGet;

/**
 * The upreg message of the property "RepeatMode"
 * The current repeat setting of the media player instance
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RepeatModeUpReg;

/**
 * The relUpReg message of the property "RepeatMode"
 * The current repeat setting of the media player instance
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RepeatModeRelUpReg;

/**
 * The error message of 'RepeatMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError RepeatModeError;

/**
 * The get message of the property "IndexingState"
 * The IndexingState property indicates the status of the indexing operation for a connected device.  The Get operation triggers a Status response with a Stream list of the indexing state of all currently connected devices.  A change in indexing on one or more devices is sent as a Status response for just the device(s) that changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IndexingStateGet;

/**
 * The upreg message of the property "IndexingState"
 * The IndexingState property indicates the status of the indexing operation for a connected device.  The Get operation triggers a Status response with a Stream list of the indexing state of all currently connected devices.  A change in indexing on one or more devices is sent as a Status response for just the device(s) that changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IndexingStateUpReg;

/**
 * The relUpReg message of the property "IndexingState"
 * The IndexingState property indicates the status of the indexing operation for a connected device.  The Get operation triggers a Status response with a Stream list of the indexing state of all currently connected devices.  A change in indexing on one or more devices is sent as a Status response for just the device(s) that changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IndexingStateRelUpReg;

/**
 * The error message of 'IndexingState'
 */
typedef ::asf::cca::CcaTypes::DefaultError IndexingStateError;

/**
 * The get message of the property "MediaPlayerDeviceConnections"
 * Provides notification of the number of devices connected that support media playback.  For each connected device, this property provides specific information about the device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayerDeviceConnectionsGet;

/**
 * The upreg message of the property "MediaPlayerDeviceConnections"
 * Provides notification of the number of devices connected that support media playback.  For each connected device, this property provides specific information about the device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayerDeviceConnectionsUpReg;

/**
 * The relUpReg message of the property "MediaPlayerDeviceConnections"
 * Provides notification of the number of devices connected that support media playback.  For each connected device, this property provides specific information about the device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayerDeviceConnectionsRelUpReg;

/**
 * The error message of 'MediaPlayerDeviceConnections'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaPlayerDeviceConnectionsError;

/**
 * The get message of the property "ActiveMediaDevice"
 * Identifies the media device that is currently sourced. The DeviceTag of
 * 0x00 is reserved as the "My Media" device. When this tag is the
 * ActiveMediaSource, the user is presented with an indexed library of
 * aggregated media from all connected devices with DeviceIndexedStates of
 * IDS_PARTIAL and IDS_COMPLETE.This function is used to set an
 * active media source by DeviceTag. This function can also be used to
 * retrieve the DeviceTag and DeviceInfo of the active media source.Note
 * that the DeviceIndexedState field within the DeviceInfo stream can be used
 * by HMI controllers to determine whether or not the device supports
 * indexing or not. For a device that does not support indexing, only the
 * file and playlist-based functions may be used.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActiveMediaDeviceGet;

/**
 * The upreg message of the property "ActiveMediaDevice"
 * Identifies the media device that is currently sourced. The DeviceTag of
 * 0x00 is reserved as the "My Media" device. When this tag is the
 * ActiveMediaSource, the user is presented with an indexed library of
 * aggregated media from all connected devices with DeviceIndexedStates of
 * IDS_PARTIAL and IDS_COMPLETE.This function is used to set an
 * active media source by DeviceTag. This function can also be used to
 * retrieve the DeviceTag and DeviceInfo of the active media source.Note
 * that the DeviceIndexedState field within the DeviceInfo stream can be used
 * by HMI controllers to determine whether or not the device supports
 * indexing or not. For a device that does not support indexing, only the
 * file and playlist-based functions may be used.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActiveMediaDeviceUpReg;

/**
 * The relUpReg message of the property "ActiveMediaDevice"
 * Identifies the media device that is currently sourced. The DeviceTag of
 * 0x00 is reserved as the "My Media" device. When this tag is the
 * ActiveMediaSource, the user is presented with an indexed library of
 * aggregated media from all connected devices with DeviceIndexedStates of
 * IDS_PARTIAL and IDS_COMPLETE.This function is used to set an
 * active media source by DeviceTag. This function can also be used to
 * retrieve the DeviceTag and DeviceInfo of the active media source.Note
 * that the DeviceIndexedState field within the DeviceInfo stream can be used
 * by HMI controllers to determine whether or not the device supports
 * indexing or not. For a device that does not support indexing, only the
 * file and playlist-based functions may be used.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActiveMediaDeviceRelUpReg;

/**
 * The error message of 'ActiveMediaDevice'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActiveMediaDeviceError;

/**
 * The get message of the property "MyMediaSupported"
 * This Property is used to indicate whether this instance of the MediaPlayer
 * FBlock supports the MyMedia functionality or not so that the IMediaPlayer
 * interface can be used without changes in both Base and Uplevel systems as
 * follows:
 *
 * MyMediaSupported shall be used to allow HMI controllers that control
 * the MediaPlayer FBlock to be able to automatically configure their HMI
 * menus at runtime without internal calibrations. This property shall be
 * set statically by each FBlock and shall not change dynamically at
 * runtime. Therefore, MyMediaSupported has been declared as a
 * non-notifieable property.
 *
 * When MyMediaSupported is False, then no HMI Controller shall use
 * DeviceTag=0x00 in any of the FktIDs herein. As defined in the
 * ActiveMediaDevice property, DeviceTag=0x00 is reserved for the virtual
 * MyMedia device. Consequently, for a MediaPlayer FBlock implementation
 * that does not support MyMedia functionality, receipt of any FktID with
 * DeviceTag = 0x00 shall trigger an error response.
 *
 * When MyMediaSupported is True, then DeviceTag=0x00 is valid and may be
 * used within any of the FktIDs where it is defined to access MyMedia
 * functionality.
 *
 * When MyMediaSupported == FALSE, all QuickPlaylist features are not
 * supported by the MediaPlayer FBlock.  This means that both
 * CreateMediaPlayerQuickPlaylistList 0x223 and
 * RequestMediaPlayerQuickPlayListSlice (0x225) are not supported.  HMI
 * controllers shall instead use PlayMediaPlayerObject (0x228) to play
 * items retrieved via a RequestMediaPlayerFileListSlice (0x222) or
 * RequestMediaPlayerIndexedListSlice (0x204) Method call.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MyMediaSupportedGet;

/**
 * The upreg message of the property "MyMediaSupported"
 * This Property is used to indicate whether this instance of the MediaPlayer
 * FBlock supports the MyMedia functionality or not so that the IMediaPlayer
 * interface can be used without changes in both Base and Uplevel systems as
 * follows:
 *
 * MyMediaSupported shall be used to allow HMI controllers that control
 * the MediaPlayer FBlock to be able to automatically configure their HMI
 * menus at runtime without internal calibrations. This property shall be
 * set statically by each FBlock and shall not change dynamically at
 * runtime. Therefore, MyMediaSupported has been declared as a
 * non-notifieable property.
 *
 * When MyMediaSupported is False, then no HMI Controller shall use
 * DeviceTag=0x00 in any of the FktIDs herein. As defined in the
 * ActiveMediaDevice property, DeviceTag=0x00 is reserved for the virtual
 * MyMedia device. Consequently, for a MediaPlayer FBlock implementation
 * that does not support MyMedia functionality, receipt of any FktID with
 * DeviceTag = 0x00 shall trigger an error response.
 *
 * When MyMediaSupported is True, then DeviceTag=0x00 is valid and may be
 * used within any of the FktIDs where it is defined to access MyMedia
 * functionality.
 *
 * When MyMediaSupported == FALSE, all QuickPlaylist features are not
 * supported by the MediaPlayer FBlock.  This means that both
 * CreateMediaPlayerQuickPlaylistList 0x223 and
 * RequestMediaPlayerQuickPlayListSlice (0x225) are not supported.  HMI
 * controllers shall instead use PlayMediaPlayerObject (0x228) to play
 * items retrieved via a RequestMediaPlayerFileListSlice (0x222) or
 * RequestMediaPlayerIndexedListSlice (0x204) Method call.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MyMediaSupportedUpReg;

/**
 * The relUpReg message of the property "MyMediaSupported"
 * This Property is used to indicate whether this instance of the MediaPlayer
 * FBlock supports the MyMedia functionality or not so that the IMediaPlayer
 * interface can be used without changes in both Base and Uplevel systems as
 * follows:
 *
 * MyMediaSupported shall be used to allow HMI controllers that control
 * the MediaPlayer FBlock to be able to automatically configure their HMI
 * menus at runtime without internal calibrations. This property shall be
 * set statically by each FBlock and shall not change dynamically at
 * runtime. Therefore, MyMediaSupported has been declared as a
 * non-notifieable property.
 *
 * When MyMediaSupported is False, then no HMI Controller shall use
 * DeviceTag=0x00 in any of the FktIDs herein. As defined in the
 * ActiveMediaDevice property, DeviceTag=0x00 is reserved for the virtual
 * MyMedia device. Consequently, for a MediaPlayer FBlock implementation
 * that does not support MyMedia functionality, receipt of any FktID with
 * DeviceTag = 0x00 shall trigger an error response.
 *
 * When MyMediaSupported is True, then DeviceTag=0x00 is valid and may be
 * used within any of the FktIDs where it is defined to access MyMedia
 * functionality.
 *
 * When MyMediaSupported == FALSE, all QuickPlaylist features are not
 * supported by the MediaPlayer FBlock.  This means that both
 * CreateMediaPlayerQuickPlaylistList 0x223 and
 * RequestMediaPlayerQuickPlayListSlice (0x225) are not supported.  HMI
 * controllers shall instead use PlayMediaPlayerObject (0x228) to play
 * items retrieved via a RequestMediaPlayerFileListSlice (0x222) or
 * RequestMediaPlayerIndexedListSlice (0x204) Method call.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MyMediaSupportedRelUpReg;

/**
 * The error message of 'MyMediaSupported'
 */
typedef ::asf::cca::CcaTypes::DefaultError MyMediaSupportedError;

/**
 * The get message of the property "CurrentFolderPath"
 * Reports the current folder base path when the MediaPlayer is playing from
 * a folder list. This property was added in version 4.2 to provide a way for
 * HMI controllers to know the base path to the folder containing the
 * currently playing item, as well as a handle to the list containing the
 * item, as follows:
 *
 * HMI controllers register for notification at startup.
 *
 * When the MediaPlayer is not playing from a file list, the ListHandle
 * parameter shall be set to NULL = 0x00000000 and the CurrentFolderPath
 * parameter shall be set to a zero-length null string. HMI controllers
 * shall interpret a Status update with these values to mean that there
 * is no global folder path defined.
 *
 * When the MediaPlayer is playing from a file list, the ListHandle shall
 * be set to the handle of the directory list containing the currently
 * playing item, and the CurrentFolderPath shall be set to the base path
 * of the containing directory. HMI controllers may not call
 * RequestListInformation with the CurrentFolderListID to retrieve the
 * list containing the current item, as there is no 'Folder' ListType
 * defined.  However, controllers may use the returned CurrentFolderPath
 * in RequestMediaPlayerFileList calls to allow the user to browse up or
 * down the device hierarchy, on that particular controller's HMI,
 * starting from the currently playing it.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentFolderPathGet;

/**
 * The upreg message of the property "CurrentFolderPath"
 * Reports the current folder base path when the MediaPlayer is playing from
 * a folder list. This property was added in version 4.2 to provide a way for
 * HMI controllers to know the base path to the folder containing the
 * currently playing item, as well as a handle to the list containing the
 * item, as follows:
 *
 * HMI controllers register for notification at startup.
 *
 * When the MediaPlayer is not playing from a file list, the ListHandle
 * parameter shall be set to NULL = 0x00000000 and the CurrentFolderPath
 * parameter shall be set to a zero-length null string. HMI controllers
 * shall interpret a Status update with these values to mean that there
 * is no global folder path defined.
 *
 * When the MediaPlayer is playing from a file list, the ListHandle shall
 * be set to the handle of the directory list containing the currently
 * playing item, and the CurrentFolderPath shall be set to the base path
 * of the containing directory. HMI controllers may not call
 * RequestListInformation with the CurrentFolderListID to retrieve the
 * list containing the current item, as there is no 'Folder' ListType
 * defined.  However, controllers may use the returned CurrentFolderPath
 * in RequestMediaPlayerFileList calls to allow the user to browse up or
 * down the device hierarchy, on that particular controller's HMI,
 * starting from the currently playing it.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentFolderPathUpReg;

/**
 * The relUpReg message of the property "CurrentFolderPath"
 * Reports the current folder base path when the MediaPlayer is playing from
 * a folder list. This property was added in version 4.2 to provide a way for
 * HMI controllers to know the base path to the folder containing the
 * currently playing item, as well as a handle to the list containing the
 * item, as follows:
 *
 * HMI controllers register for notification at startup.
 *
 * When the MediaPlayer is not playing from a file list, the ListHandle
 * parameter shall be set to NULL = 0x00000000 and the CurrentFolderPath
 * parameter shall be set to a zero-length null string. HMI controllers
 * shall interpret a Status update with these values to mean that there
 * is no global folder path defined.
 *
 * When the MediaPlayer is playing from a file list, the ListHandle shall
 * be set to the handle of the directory list containing the currently
 * playing item, and the CurrentFolderPath shall be set to the base path
 * of the containing directory. HMI controllers may not call
 * RequestListInformation with the CurrentFolderListID to retrieve the
 * list containing the current item, as there is no 'Folder' ListType
 * defined.  However, controllers may use the returned CurrentFolderPath
 * in RequestMediaPlayerFileList calls to allow the user to browse up or
 * down the device hierarchy, on that particular controller's HMI,
 * starting from the currently playing it.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentFolderPathRelUpReg;

/**
 * The error message of 'CurrentFolderPath'
 */
typedef ::asf::cca::CcaTypes::DefaultError CurrentFolderPathError;

/**
 * The get message of the property "ScanMode"
 * Contains whether scan mode is ON/OFF
 *
 * This method may only be called on a device that supports scan feature
 * according to its DeviceInfo.bScanSupported reported by
 * MediaPlayerDeviceConnection property or bScanSupported reported by ActiveMediaDevice property.
 * If bScanSupported = FALSE for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ScanModeGet;

/**
 * The upreg message of the property "ScanMode"
 * Contains whether scan mode is ON/OFF
 *
 * This method may only be called on a device that supports scan feature
 * according to its DeviceInfo.bScanSupported reported by
 * MediaPlayerDeviceConnection property or bScanSupported reported by ActiveMediaDevice property.
 * If bScanSupported = FALSE for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ScanModeUpReg;

/**
 * The relUpReg message of the property "ScanMode"
 * Contains whether scan mode is ON/OFF
 *
 * This method may only be called on a device that supports scan feature
 * according to its DeviceInfo.bScanSupported reported by
 * MediaPlayerDeviceConnection property or bScanSupported reported by ActiveMediaDevice property.
 * If bScanSupported = FALSE for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ScanModeRelUpReg;

/**
 * The error message of 'ScanMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError ScanModeError;

/**
 * The get message of the property "DiscError"
 * This will give the error state of the disc inserted if there is a error
 * DVD Video Region Code Error
 * DVD descramble failed
 * Read error
 * Unknown Disc
 * Unknown DVD
 * Unknown CD
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiscErrorGet;

/**
 * The upreg message of the property "DiscError"
 * This will give the error state of the disc inserted if there is a error
 * DVD Video Region Code Error
 * DVD descramble failed
 * Read error
 * Unknown Disc
 * Unknown DVD
 * Unknown CD
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiscErrorUpReg;

/**
 * The relUpReg message of the property "DiscError"
 * This will give the error state of the disc inserted if there is a error
 * DVD Video Region Code Error
 * DVD descramble failed
 * Read error
 * Unknown Disc
 * Unknown DVD
 * Unknown CD
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiscErrorRelUpReg;

/**
 * The error message of 'DiscError'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiscErrorError;

/**
 * The get message of the property "DiscMechanicalInfo"
 * This will give the error state of the disc inserted
 * Disc chucking
 * During disc loading
 * Disc eject finish
 * During disc eject
 * Disc eject finish
 * Disc stop
 * Disc mechanism undecided
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiscMechanicalInfoGet;

/**
 * The upreg message of the property "DiscMechanicalInfo"
 * This will give the error state of the disc inserted
 * Disc chucking
 * During disc loading
 * Disc eject finish
 * During disc eject
 * Disc eject finish
 * Disc stop
 * Disc mechanism undecided
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiscMechanicalInfoUpReg;

/**
 * The relUpReg message of the property "DiscMechanicalInfo"
 * This will give the error state of the disc inserted
 * Disc chucking
 * During disc loading
 * Disc eject finish
 * During disc eject
 * Disc eject finish
 * Disc stop
 * Disc mechanism undecided
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiscMechanicalInfoRelUpReg;

/**
 * The error message of 'DiscMechanicalInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiscMechanicalInfoError;

/**
 * The get message of the property "CMSkipAvailable"
 * This will give the CM Skip function availablity for the current playing video file
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CMSkipAvailableGet;

/**
 * The upreg message of the property "CMSkipAvailable"
 * This will give the CM Skip function availablity for the current playing video file
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CMSkipAvailableUpReg;

/**
 * The relUpReg message of the property "CMSkipAvailable"
 * This will give the CM Skip function availablity for the current playing video file
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CMSkipAvailableRelUpReg;

/**
 * The error message of 'CMSkipAvailable'
 */
typedef ::asf::cca::CcaTypes::DefaultError CMSkipAvailableError;

/**
 * The get message of the property "DirectSelectAvailable"
 * This will give the Direct Select function availablity for the current playing disc ,
 * Supported only in Video CD v2.0 (Type C) for direct selection of the number specified as parameter and In DVD Audio (Type D)
 * and DVD Video (Type F) for selecting the button equivalent to the number.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DirectSelectAvailableGet;

/**
 * The upreg message of the property "DirectSelectAvailable"
 * This will give the Direct Select function availablity for the current playing disc ,
 * Supported only in Video CD v2.0 (Type C) for direct selection of the number specified as parameter and In DVD Audio (Type D)
 * and DVD Video (Type F) for selecting the button equivalent to the number.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DirectSelectAvailableUpReg;

/**
 * The relUpReg message of the property "DirectSelectAvailable"
 * This will give the Direct Select function availablity for the current playing disc ,
 * Supported only in Video CD v2.0 (Type C) for direct selection of the number specified as parameter and In DVD Audio (Type D)
 * and DVD Video (Type F) for selecting the button equivalent to the number.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DirectSelectAvailableRelUpReg;

/**
 * The error message of 'DirectSelectAvailable'
 */
typedef ::asf::cca::CcaTypes::DefaultError DirectSelectAvailableError;

/**
 * The get message of the property "DVDAngleInfo"
 * This will give the Dvd Angle information of the current playing content
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDAngleInfoGet;

/**
 * The upreg message of the property "DVDAngleInfo"
 * This will give the Dvd Angle information of the current playing content
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDAngleInfoUpReg;

/**
 * The relUpReg message of the property "DVDAngleInfo"
 * This will give the Dvd Angle information of the current playing content
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDAngleInfoRelUpReg;

/**
 * The error message of 'DVDAngleInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DVDAngleInfoError;

/**
 * The get message of the property "DVDSubtitleInfo"
 * This will give the Dvd Angle information of the current playing content
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDSubtitleInfoGet;

/**
 * The upreg message of the property "DVDSubtitleInfo"
 * This will give the Dvd Angle information of the current playing content
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDSubtitleInfoUpReg;

/**
 * The relUpReg message of the property "DVDSubtitleInfo"
 * This will give the Dvd Angle information of the current playing content
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDSubtitleInfoRelUpReg;

/**
 * The error message of 'DVDSubtitleInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DVDSubtitleInfoError;

/**
 * The get message of the property "DVDAudioChannelInfo"
 * This will give the Dvd audio information of the current playing disc , channels supported and sub woofer availability
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDAudioChannelInfoGet;

/**
 * The upreg message of the property "DVDAudioChannelInfo"
 * This will give the Dvd audio information of the current playing disc , channels supported and sub woofer availability
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDAudioChannelInfoUpReg;

/**
 * The relUpReg message of the property "DVDAudioChannelInfo"
 * This will give the Dvd audio information of the current playing disc , channels supported and sub woofer availability
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDAudioChannelInfoRelUpReg;

/**
 * The error message of 'DVDAudioChannelInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DVDAudioChannelInfoError;

/**
 * The get message of the property "DVDCurrentAudioInfo"
 * This will give the audio information of the current playing content
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDCurrentAudioInfoGet;

/**
 * The upreg message of the property "DVDCurrentAudioInfo"
 * This will give the audio information of the current playing content
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDCurrentAudioInfoUpReg;

/**
 * The relUpReg message of the property "DVDCurrentAudioInfo"
 * This will give the audio information of the current playing content
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDCurrentAudioInfoRelUpReg;

/**
 * The error message of 'DVDCurrentAudioInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DVDCurrentAudioInfoError;

/**
 * The get message of the property "DisplayMode"
 * This will give the Display mode (Aspect Ratio) for the current playing content , cannot be set during playback
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DisplayModeGet;

/**
 * The upreg message of the property "DisplayMode"
 * This will give the Display mode (Aspect Ratio) for the current playing content , cannot be set during playback
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DisplayModeUpReg;

/**
 * The relUpReg message of the property "DisplayMode"
 * This will give the Display mode (Aspect Ratio) for the current playing content , cannot be set during playback
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DisplayModeRelUpReg;

/**
 * The error message of 'DisplayMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError DisplayModeError;

/**
 * The get message of the property "DVDPlayerLangSetting"
 * Specifies the Language settings for the setup of the DVD Drive ,cannot be set during playback
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDPlayerLangSettingGet;

/**
 * The upreg message of the property "DVDPlayerLangSetting"
 * Specifies the Language settings for the setup of the DVD Drive ,cannot be set during playback
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDPlayerLangSettingUpReg;

/**
 * The relUpReg message of the property "DVDPlayerLangSetting"
 * Specifies the Language settings for the setup of the DVD Drive ,cannot be set during playback
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDPlayerLangSettingRelUpReg;

/**
 * The error message of 'DVDPlayerLangSetting'
 */
typedef ::asf::cca::CcaTypes::DefaultError DVDPlayerLangSettingError;

/**
 * The get message of the property "AngleMarkSetting"
 * This will decide whether the angle mark status has to be displayed or not ,can be set during playback.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AngleMarkSettingGet;

/**
 * The upreg message of the property "AngleMarkSetting"
 * This will decide whether the angle mark status has to be displayed or not ,can be set during playback.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AngleMarkSettingUpReg;

/**
 * The relUpReg message of the property "AngleMarkSetting"
 * This will decide whether the angle mark status has to be displayed or not ,can be set during playback.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AngleMarkSettingRelUpReg;

/**
 * The error message of 'AngleMarkSetting'
 */
typedef ::asf::cca::CcaTypes::DefaultError AngleMarkSettingError;

/**
 * The get message of the property "PlayStatusSetting"
 * This will decide whether the play status has to be displayed or not ,can be set during playback.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlayStatusSettingGet;

/**
 * The upreg message of the property "PlayStatusSetting"
 * This will decide whether the play status has to be displayed or not ,can be set during playback.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlayStatusSettingUpReg;

/**
 * The relUpReg message of the property "PlayStatusSetting"
 * This will decide whether the play status has to be displayed or not ,can be set during playback.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlayStatusSettingRelUpReg;

/**
 * The error message of 'PlayStatusSetting'
 */
typedef ::asf::cca::CcaTypes::DefaultError PlayStatusSettingError;

/**
 * The get message of the property "DRCSetting"
 * This will set the dynamic range compression value of the disc playing,can be set during playback.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DRCSettingGet;

/**
 * The upreg message of the property "DRCSetting"
 * This will set the dynamic range compression value of the disc playing,can be set during playback.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DRCSettingUpReg;

/**
 * The relUpReg message of the property "DRCSetting"
 * This will set the dynamic range compression value of the disc playing,can be set during playback.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DRCSettingRelUpReg;

/**
 * The error message of 'DRCSetting'
 */
typedef ::asf::cca::CcaTypes::DefaultError DRCSettingError;

/**
 * The upreg message of the property "DVDCommandStatus"
 * This will get command error message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDCommandStatusUpReg;

/**
 * The relUpReg message of the property "DVDCommandStatus"
 * This will get command error message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDCommandStatusRelUpReg;

/**
 * The error message of 'DVDCommandStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError DVDCommandStatusError;

/**
 * The get message of the property "AutoRipping"
 * The AutoRipping property directs mediaplayer to start or stops the ripping process.
 * The behaviour of the property is as follows:
 * if autoripping option is set to true and if the user inserts cdda, then the ripping will be started automatically.
 * if autoripping option is set to true and if the  cdda playback is ongoing, then the ripping will not be started automatically until the user re insert the disc or
 * user does a ignition off on cycle.
 * if autoripping option is set to false and if the user inserts cdda, then the ripping will not be started and mediaplayer will start the playback of the disc.
 * if autoripping option is set to false and if the ripping is going on, ripping will be stopped immediatly and mediaplayer starts the playback of the disc.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoRippingGet;

/**
 * The upreg message of the property "AutoRipping"
 * The AutoRipping property directs mediaplayer to start or stops the ripping process.
 * The behaviour of the property is as follows:
 * if autoripping option is set to true and if the user inserts cdda, then the ripping will be started automatically.
 * if autoripping option is set to true and if the  cdda playback is ongoing, then the ripping will not be started automatically until the user re insert the disc or
 * user does a ignition off on cycle.
 * if autoripping option is set to false and if the user inserts cdda, then the ripping will not be started and mediaplayer will start the playback of the disc.
 * if autoripping option is set to false and if the ripping is going on, ripping will be stopped immediatly and mediaplayer starts the playback of the disc.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoRippingUpReg;

/**
 * The relUpReg message of the property "AutoRipping"
 * The AutoRipping property directs mediaplayer to start or stops the ripping process.
 * The behaviour of the property is as follows:
 * if autoripping option is set to true and if the user inserts cdda, then the ripping will be started automatically.
 * if autoripping option is set to true and if the  cdda playback is ongoing, then the ripping will not be started automatically until the user re insert the disc or
 * user does a ignition off on cycle.
 * if autoripping option is set to false and if the user inserts cdda, then the ripping will not be started and mediaplayer will start the playback of the disc.
 * if autoripping option is set to false and if the ripping is going on, ripping will be stopped immediatly and mediaplayer starts the playback of the disc.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoRippingRelUpReg;

/**
 * The error message of 'AutoRipping'
 */
typedef ::asf::cca::CcaTypes::DefaultError AutoRippingError;

/**
 * The get message of the property "GracenoteLookupMode"
 * Clients uses this property to inform mediaplayer about the preferred  look up mode(online or offline mode) for the gracenote SDK.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GracenoteLookupModeGet;

/**
 * The upreg message of the property "GracenoteLookupMode"
 * Clients uses this property to inform mediaplayer about the preferred  look up mode(online or offline mode) for the gracenote SDK.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GracenoteLookupModeUpReg;

/**
 * The relUpReg message of the property "GracenoteLookupMode"
 * Clients uses this property to inform mediaplayer about the preferred  look up mode(online or offline mode) for the gracenote SDK.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GracenoteLookupModeRelUpReg;

/**
 * The error message of 'GracenoteLookupMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError GracenoteLookupModeError;

/**
 * The get message of the property "GracenoteVersion"
 * Gets the gracenote SDK version used to get the cd metadata.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GracenoteVersionGet;

/**
 * The upreg message of the property "GracenoteVersion"
 * Gets the gracenote SDK version used to get the cd metadata.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GracenoteVersionUpReg;

/**
 * The relUpReg message of the property "GracenoteVersion"
 * Gets the gracenote SDK version used to get the cd metadata.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GracenoteVersionRelUpReg;

/**
 * The error message of 'GracenoteVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError GracenoteVersionError;

/**
 * The get message of the property "RippingErrors"
 * The RippingErrors property indicates the errors encountered during the ripping operation for a connected device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RippingErrorsGet;

/**
 * The upreg message of the property "RippingErrors"
 * The RippingErrors property indicates the errors encountered during the ripping operation for a connected device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RippingErrorsUpReg;

/**
 * The relUpReg message of the property "RippingErrors"
 * The RippingErrors property indicates the errors encountered during the ripping operation for a connected device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RippingErrorsRelUpReg;

/**
 * The error message of 'RippingErrors'
 */
typedef ::asf::cca::CcaTypes::DefaultError RippingErrorsError;

/**
 * The get message of the property "ResolveGracenoteAmbuiguities"
 * If the gracenote SDK finds more than one matching albums for a CDID(TOC),
 * then the user has to select which one album from the list of albums returned from gracenote.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResolveGracenoteAmbuiguitiesGet;

/**
 * The upreg message of the property "ResolveGracenoteAmbuiguities"
 * If the gracenote SDK finds more than one matching albums for a CDID(TOC),
 * then the user has to select which one album from the list of albums returned from gracenote.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResolveGracenoteAmbuiguitiesUpReg;

/**
 * The relUpReg message of the property "ResolveGracenoteAmbuiguities"
 * If the gracenote SDK finds more than one matching albums for a CDID(TOC),
 * then the user has to select which one album from the list of albums returned from gracenote.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResolveGracenoteAmbuiguitiesRelUpReg;

/**
 * The error message of 'ResolveGracenoteAmbuiguities'
 */
typedef ::asf::cca::CcaTypes::DefaultError ResolveGracenoteAmbuiguitiesError;

/**
 * The get message of the property "DVDMenuPlaybackOngoing"
 * This will give whether the current playing file is a menu screen or not
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDMenuPlaybackOngoingGet;

/**
 * The upreg message of the property "DVDMenuPlaybackOngoing"
 * This will give whether the current playing file is a menu screen or not
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDMenuPlaybackOngoingUpReg;

/**
 * The relUpReg message of the property "DVDMenuPlaybackOngoing"
 * This will give whether the current playing file is a menu screen or not
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDMenuPlaybackOngoingRelUpReg;

/**
 * The error message of 'DVDMenuPlaybackOngoing'
 */
typedef ::asf::cca::CcaTypes::DefaultError DVDMenuPlaybackOngoingError;

/**
 * The get message of the property "DVDDriveInfo"
 * This will give dvd drive info necessary for device manager
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDDriveInfoGet;

/**
 * The upreg message of the property "DVDDriveInfo"
 * This will give dvd drive info necessary for device manager
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDDriveInfoUpReg;

/**
 * The relUpReg message of the property "DVDDriveInfo"
 * This will give dvd drive info necessary for device manager
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDDriveInfoRelUpReg;

/**
 * The error message of 'DVDDriveInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DVDDriveInfoError;

/**
 * The get message of the property "RippingState"
 * The RippingState property indicates the status of the ripping operation for a connected device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RippingStateGet;

/**
 * The upreg message of the property "RippingState"
 * The RippingState property indicates the status of the ripping operation for a connected device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RippingStateUpReg;

/**
 * The relUpReg message of the property "RippingState"
 * The RippingState property indicates the status of the ripping operation for a connected device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RippingStateRelUpReg;

/**
 * The error message of 'RippingState'
 */
typedef ::asf::cca::CcaTypes::DefaultError RippingStateError;

/**
 * The get message of the property "RippingEncodingQuality"
 * Interface to get current bit rate and configure the  ripping bit rate. As per HMI spec two bit rate possible 96 and 128 kbps
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RippingEncodingQualityGet;

/**
 * The upreg message of the property "RippingEncodingQuality"
 * Interface to get current bit rate and configure the  ripping bit rate. As per HMI spec two bit rate possible 96 and 128 kbps
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RippingEncodingQualityUpReg;

/**
 * The relUpReg message of the property "RippingEncodingQuality"
 * Interface to get current bit rate and configure the  ripping bit rate. As per HMI spec two bit rate possible 96 and 128 kbps
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RippingEncodingQualityRelUpReg;

/**
 * The error message of 'RippingEncodingQuality'
 */
typedef ::asf::cca::CcaTypes::DefaultError RippingEncodingQualityError;

/**
 * The get message of the property "GNMetadataExtractionStatus"
 * If gracenote metadata is available for album selected by the user, update the metadata
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GNMetadataExtractionStatusGet;

/**
 * The upreg message of the property "GNMetadataExtractionStatus"
 * If gracenote metadata is available for album selected by the user, update the metadata
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GNMetadataExtractionStatusUpReg;

/**
 * The relUpReg message of the property "GNMetadataExtractionStatus"
 * If gracenote metadata is available for album selected by the user, update the metadata
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GNMetadataExtractionStatusRelUpReg;

/**
 * The error message of 'GNMetadataExtractionStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError GNMetadataExtractionStatusError;

/**
 * The get message of the property "Language"
 * Set the language
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LanguageGet;

/**
 * The upreg message of the property "Language"
 * Set the language
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LanguageUpReg;

/**
 * The relUpReg message of the property "Language"
 * Set the language
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LanguageRelUpReg;

/**
 * The error message of 'Language'
 */
typedef ::asf::cca::CcaTypes::DefaultError LanguageError;

/**
 * The get message of the property "PlaybackRepeatMode"
 * Property to set and read current playback mode and repeat of the media player
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlaybackRepeatModeGet;

/**
 * The upreg message of the property "PlaybackRepeatMode"
 * Property to set and read current playback mode and repeat of the media player
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlaybackRepeatModeUpReg;

/**
 * The relUpReg message of the property "PlaybackRepeatMode"
 * Property to set and read current playback mode and repeat of the media player
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlaybackRepeatModeRelUpReg;

/**
 * The error message of 'PlaybackRepeatMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError PlaybackRepeatModeError;

/**
 * The get message of the property "SlideshowTime"
 * The current slideshow time of the media player instance
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SlideshowTimeGet;

/**
 * The upreg message of the property "SlideshowTime"
 * The current slideshow time of the media player instance
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SlideshowTimeUpReg;

/**
 * The relUpReg message of the property "SlideshowTime"
 * The current slideshow time of the media player instance
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SlideshowTimeRelUpReg;

/**
 * The error message of 'SlideshowTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError SlideshowTimeError;

/**
 * The get message of the property "NowShowing"
 * This property identifies all information about the currently showing item.
 * The HMI has to use this information to load, if necessary to convert and to show the current image.
 * Additionally, the next image is delivered to the HMI to realize a preloading mechanism
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NowShowingGet;

/**
 * The upreg message of the property "NowShowing"
 * This property identifies all information about the currently showing item.
 * The HMI has to use this information to load, if necessary to convert and to show the current image.
 * Additionally, the next image is delivered to the HMI to realize a preloading mechanism
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NowShowingUpReg;

/**
 * The relUpReg message of the property "NowShowing"
 * This property identifies all information about the currently showing item.
 * The HMI has to use this information to load, if necessary to convert and to show the current image.
 * Additionally, the next image is delivered to the HMI to realize a preloading mechanism
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NowShowingRelUpReg;

/**
 * The error message of 'NowShowing'
 */
typedef ::asf::cca::CcaTypes::DefaultError NowShowingError;

/**
 * The get message of the property "SlideshowState"
 * The current slideshow state of the MediaPlayer
 * PBS_PLAYING: The Media Player is showing an image object. The
 * object being played can be obtained using the NowShowing function
 * PBS_PAUSED: The slideshow is paused
 * PBS_STOPPED: The slideshow is not active.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SlideshowStateGet;

/**
 * The upreg message of the property "SlideshowState"
 * The current slideshow state of the MediaPlayer
 * PBS_PLAYING: The Media Player is showing an image object. The
 * object being played can be obtained using the NowShowing function
 * PBS_PAUSED: The slideshow is paused
 * PBS_STOPPED: The slideshow is not active.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SlideshowStateUpReg;

/**
 * The relUpReg message of the property "SlideshowState"
 * The current slideshow state of the MediaPlayer
 * PBS_PLAYING: The Media Player is showing an image object. The
 * object being played can be obtained using the NowShowing function
 * PBS_PAUSED: The slideshow is paused
 * PBS_STOPPED: The slideshow is not active.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SlideshowStateRelUpReg;

/**
 * The error message of 'SlideshowState'
 */
typedef ::asf::cca::CcaTypes::DefaultError SlideshowStateError;

/**
 * The get message of the property "MediaPlayerOpticalDiscSlotState"
 * Used to notify about the connection status of Optical disks.The Mediaplayer gets this from  VD_Devicemanager which gets the information from
 * VD_Mediamanager component which gets it from osal device cdctrl. Objective is to forward this without further adapter - HMI hsould have interface of mediaplayer
 * as main communication partner.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayerOpticalDiscSlotStateGet;

/**
 * The upreg message of the property "MediaPlayerOpticalDiscSlotState"
 * Used to notify about the connection status of Optical disks.The Mediaplayer gets this from  VD_Devicemanager which gets the information from
 * VD_Mediamanager component which gets it from osal device cdctrl. Objective is to forward this without further adapter - HMI hsould have interface of mediaplayer
 * as main communication partner.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayerOpticalDiscSlotStateUpReg;

/**
 * The relUpReg message of the property "MediaPlayerOpticalDiscSlotState"
 * Used to notify about the connection status of Optical disks.The Mediaplayer gets this from  VD_Devicemanager which gets the information from
 * VD_Mediamanager component which gets it from osal device cdctrl. Objective is to forward this without further adapter - HMI hsould have interface of mediaplayer
 * as main communication partner.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayerOpticalDiscSlotStateRelUpReg;

/**
 * The error message of 'MediaPlayerOpticalDiscSlotState'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaPlayerOpticalDiscSlotStateError;

/**
 * The get message of the property "MediaPlayerOpticalDiscCDInfo"
 * Used to notify about the CD Info of Optical disks.The Mediaplayer gets this from  VD_Devicemanager which gets the information from
 * VD_Mediamanager component which gets it from osal device cdctrl. Objective is to forward this without further adapter - HMI should have interface of mediaplayer
 * as main communication partner.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayerOpticalDiscCDInfoGet;

/**
 * The upreg message of the property "MediaPlayerOpticalDiscCDInfo"
 * Used to notify about the CD Info of Optical disks.The Mediaplayer gets this from  VD_Devicemanager which gets the information from
 * VD_Mediamanager component which gets it from osal device cdctrl. Objective is to forward this without further adapter - HMI should have interface of mediaplayer
 * as main communication partner.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayerOpticalDiscCDInfoUpReg;

/**
 * The relUpReg message of the property "MediaPlayerOpticalDiscCDInfo"
 * Used to notify about the CD Info of Optical disks.The Mediaplayer gets this from  VD_Devicemanager which gets the information from
 * VD_Mediamanager component which gets it from osal device cdctrl. Objective is to forward this without further adapter - HMI should have interface of mediaplayer
 * as main communication partner.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayerOpticalDiscCDInfoRelUpReg;

/**
 * The error message of 'MediaPlayerOpticalDiscCDInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaPlayerOpticalDiscCDInfoError;

/**
 * The get message of the property "iPodCommunicationError"
 * The iPodCommunicationError property provides update to HMI for any error received by Media Player from apple device for the commands executed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPodCommunicationErrorGet;

/**
 * The upreg message of the property "iPodCommunicationError"
 * The iPodCommunicationError property provides update to HMI for any error received by Media Player from apple device for the commands executed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPodCommunicationErrorUpReg;

/**
 * The relUpReg message of the property "iPodCommunicationError"
 * The iPodCommunicationError property provides update to HMI for any error received by Media Player from apple device for the commands executed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPodCommunicationErrorRelUpReg;

/**
 * The error message of 'iPodCommunicationError'
 */
typedef ::asf::cca::CcaTypes::DefaultError IPodCommunicationErrorError;

/**
 * The get message of the property "DeviceStreamingInfo"
 * The DeviceStreamingInfo property provides update to HMI current streaming status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceStreamingInfoGet;

/**
 * The upreg message of the property "DeviceStreamingInfo"
 * The DeviceStreamingInfo property provides update to HMI current streaming status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceStreamingInfoUpReg;

/**
 * The relUpReg message of the property "DeviceStreamingInfo"
 * The DeviceStreamingInfo property provides update to HMI current streaming status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceStreamingInfoRelUpReg;

/**
 * The error message of 'DeviceStreamingInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStreamingInfoError;

/**
 * The get message of the property "VideoBrightness"
 * Property to set and get the video brightness level of the playable video objects.
 *
 * Valid range of video brightness level is 0-200.
 * Default value of brightness level is 100.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoBrightnessGet;

/**
 * The upreg message of the property "VideoBrightness"
 * Property to set and get the video brightness level of the playable video objects.
 *
 * Valid range of video brightness level is 0-200.
 * Default value of brightness level is 100.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoBrightnessUpReg;

/**
 * The relUpReg message of the property "VideoBrightness"
 * Property to set and get the video brightness level of the playable video objects.
 *
 * Valid range of video brightness level is 0-200.
 * Default value of brightness level is 100.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoBrightnessRelUpReg;

/**
 * The error message of 'VideoBrightness'
 */
typedef ::asf::cca::CcaTypes::DefaultError VideoBrightnessError;

/**
 * The get message of the property "VideoHue"
 * Property to set and get the video hue level of the playable video objects.
 *
 * Valid range of video hue level is -180 - +180.
 * Default value of hue level is 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoHueGet;

/**
 * The upreg message of the property "VideoHue"
 * Property to set and get the video hue level of the playable video objects.
 *
 * Valid range of video hue level is -180 - +180.
 * Default value of hue level is 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoHueUpReg;

/**
 * The relUpReg message of the property "VideoHue"
 * Property to set and get the video hue level of the playable video objects.
 *
 * Valid range of video hue level is -180 - +180.
 * Default value of hue level is 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoHueRelUpReg;

/**
 * The error message of 'VideoHue'
 */
typedef ::asf::cca::CcaTypes::DefaultError VideoHueError;

/**
 * The get message of the property "VideoSaturation"
 * Property to set and get the video saturation level of the playable video objects.
 *
 * Valid range of video saturation level is 0 - 200.
 * Default value of saturation level is 100.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoSaturationGet;

/**
 * The upreg message of the property "VideoSaturation"
 * Property to set and get the video saturation level of the playable video objects.
 *
 * Valid range of video saturation level is 0 - 200.
 * Default value of saturation level is 100.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoSaturationUpReg;

/**
 * The relUpReg message of the property "VideoSaturation"
 * Property to set and get the video saturation level of the playable video objects.
 *
 * Valid range of video saturation level is 0 - 200.
 * Default value of saturation level is 100.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoSaturationRelUpReg;

/**
 * The error message of 'VideoSaturation'
 */
typedef ::asf::cca::CcaTypes::DefaultError VideoSaturationError;

/**
 * The get message of the property "VideoContrast"
 * Property to set and get the video contrast level of the playable video objects.
 *
 * Valid range of video contrast level is 0 - 200.
 * Default value of contrast level is 100.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoContrastGet;

/**
 * The upreg message of the property "VideoContrast"
 * Property to set and get the video contrast level of the playable video objects.
 *
 * Valid range of video contrast level is 0 - 200.
 * Default value of contrast level is 100.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoContrastUpReg;

/**
 * The relUpReg message of the property "VideoContrast"
 * Property to set and get the video contrast level of the playable video objects.
 *
 * Valid range of video contrast level is 0 - 200.
 * Default value of contrast level is 100.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoContrastRelUpReg;

/**
 * The error message of 'VideoContrast'
 */
typedef ::asf::cca::CcaTypes::DefaultError VideoContrastError;

/**
 * The get message of the property "VideoBrightnessOffset"
 * Property to set and get the video brightness offset level of the playable video objects.
 *
 * Valid range of video brightness offset level is -100 - +100.
 * Default value of brightness offset level is 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoBrightnessOffsetGet;

/**
 * The upreg message of the property "VideoBrightnessOffset"
 * Property to set and get the video brightness offset level of the playable video objects.
 *
 * Valid range of video brightness offset level is -100 - +100.
 * Default value of brightness offset level is 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoBrightnessOffsetUpReg;

/**
 * The relUpReg message of the property "VideoBrightnessOffset"
 * Property to set and get the video brightness offset level of the playable video objects.
 *
 * Valid range of video brightness offset level is -100 - +100.
 * Default value of brightness offset level is 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoBrightnessOffsetRelUpReg;

/**
 * The error message of 'VideoBrightnessOffset'
 */
typedef ::asf::cca::CcaTypes::DefaultError VideoBrightnessOffsetError;

/**
 * The get message of the property "VideoHueOffset"
 * Property to set and get the video hue offset level of the playable video objects.
 *
 * Valid range of video hue offset level is -180 - +180.
 * Default value of hue offset level is 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoHueOffsetGet;

/**
 * The upreg message of the property "VideoHueOffset"
 * Property to set and get the video hue offset level of the playable video objects.
 *
 * Valid range of video hue offset level is -180 - +180.
 * Default value of hue offset level is 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoHueOffsetUpReg;

/**
 * The relUpReg message of the property "VideoHueOffset"
 * Property to set and get the video hue offset level of the playable video objects.
 *
 * Valid range of video hue offset level is -180 - +180.
 * Default value of hue offset level is 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoHueOffsetRelUpReg;

/**
 * The error message of 'VideoHueOffset'
 */
typedef ::asf::cca::CcaTypes::DefaultError VideoHueOffsetError;

/**
 * The get message of the property "VideoSaturationOffset"
 * Property to set and get the video saturation offset level of the playable video objects.
 *
 * Valid range of video saturation offset level is 0 - 200.
 * Default value of saturation offset level is 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoSaturationOffsetGet;

/**
 * The upreg message of the property "VideoSaturationOffset"
 * Property to set and get the video saturation offset level of the playable video objects.
 *
 * Valid range of video saturation offset level is 0 - 200.
 * Default value of saturation offset level is 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoSaturationOffsetUpReg;

/**
 * The relUpReg message of the property "VideoSaturationOffset"
 * Property to set and get the video saturation offset level of the playable video objects.
 *
 * Valid range of video saturation offset level is 0 - 200.
 * Default value of saturation offset level is 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoSaturationOffsetRelUpReg;

/**
 * The error message of 'VideoSaturationOffset'
 */
typedef ::asf::cca::CcaTypes::DefaultError VideoSaturationOffsetError;

/**
 * The get message of the property "VideoScaling"
 * Property to set and get the video scaling level of the playable video objects.
 * The following modes are supported -->
 * Normal ,
 * Full  ,
 * Stretched
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoScalingGet;

/**
 * The upreg message of the property "VideoScaling"
 * Property to set and get the video scaling level of the playable video objects.
 * The following modes are supported -->
 * Normal ,
 * Full  ,
 * Stretched
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoScalingUpReg;

/**
 * The relUpReg message of the property "VideoScaling"
 * Property to set and get the video scaling level of the playable video objects.
 * The following modes are supported -->
 * Normal ,
 * Full  ,
 * Stretched
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoScalingRelUpReg;

/**
 * The error message of 'VideoScaling'
 */
typedef ::asf::cca::CcaTypes::DefaultError VideoScalingError;

/**
 * The set message of the property "UpdatePlaybackSpeed"
 * Property to get the PlaybackSpeed of the playable video objects. Valid range of playback speed level is 1x-32x. Default value of brightness level is 1x.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdatePlaybackSpeedSet;

/**
 * The get message of the property "UpdatePlaybackSpeed"
 * Property to get the PlaybackSpeed of the playable video objects. Valid range of playback speed level is 1x-32x. Default value of brightness level is 1x.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdatePlaybackSpeedGet;

/**
 * The upreg message of the property "UpdatePlaybackSpeed"
 * Property to get the PlaybackSpeed of the playable video objects. Valid range of playback speed level is 1x-32x. Default value of brightness level is 1x.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdatePlaybackSpeedUpReg;

/**
 * The relUpReg message of the property "UpdatePlaybackSpeed"
 * Property to get the PlaybackSpeed of the playable video objects. Valid range of playback speed level is 1x-32x. Default value of brightness level is 1x.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdatePlaybackSpeedRelUpReg;

/**
 * The error message of 'UpdatePlaybackSpeed'
 */
typedef ::asf::cca::CcaTypes::DefaultError UpdatePlaybackSpeedError;

/**
 * The upreg message of the property "UserFavoritesChanged"
 * The UserFavoritesChanged property provides notification about changes that
 * occurred to the stored favorites. These changes include:
 *
 * 1) On startup
 * 2) Addition of a new favorite
 * 3) Deletion of a favorite
 *
 * The ListChangeType = LCH_CONTENT_CHANGED when the FavoriteInfo record
 * elements have been determined for all stored favorites after system
 * initialization.
 *
 * If the ListChangeType = LCH_CONTENT_CHANGED, i.e. the entire list
 * changed, then NumItems = 0 and the ChangedFavorites array is empty.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UserFavoritesChangedUpReg;

/**
 * The relUpReg message of the property "UserFavoritesChanged"
 * The UserFavoritesChanged property provides notification about changes that
 * occurred to the stored favorites. These changes include:
 *
 * 1) On startup
 * 2) Addition of a new favorite
 * 3) Deletion of a favorite
 *
 * The ListChangeType = LCH_CONTENT_CHANGED when the FavoriteInfo record
 * elements have been determined for all stored favorites after system
 * initialization.
 *
 * If the ListChangeType = LCH_CONTENT_CHANGED, i.e. the entire list
 * changed, then NumItems = 0 and the ChangedFavorites array is empty.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UserFavoritesChangedRelUpReg;

/**
 * The error message of 'UserFavoritesChanged'
 */
typedef ::asf::cca::CcaTypes::DefaultError UserFavoritesChangedError;

/**
 * The upreg message of the property "FolderBrowseStructureCleared"
 * The Browse structure stored internal to mediaplayer can be cleared in two cases.
 *
 * 1) Player Changed (Browsed Player)
 * 2) UIDsChanged in Phone
 *
 * The Device Tag indicates the device id of the device for which, the browse structure is cleared.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FolderBrowseStructureClearedUpReg;

/**
 * The relUpReg message of the property "FolderBrowseStructureCleared"
 * The Browse structure stored internal to mediaplayer can be cleared in two cases.
 *
 * 1) Player Changed (Browsed Player)
 * 2) UIDsChanged in Phone
 *
 * The Device Tag indicates the device id of the device for which, the browse structure is cleared.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FolderBrowseStructureClearedRelUpReg;

/**
 * The error message of 'FolderBrowseStructureCleared'
 */
typedef ::asf::cca::CcaTypes::DefaultError FolderBrowseStructureClearedError;

/**
 * The get message of the property "ReadyToPlay"
 * Update playback state when user starts playback on the phone
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReadyToPlayGet;

/**
 * The upreg message of the property "ReadyToPlay"
 * Update playback state when user starts playback on the phone
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReadyToPlayUpReg;

/**
 * The relUpReg message of the property "ReadyToPlay"
 * Update playback state when user starts playback on the phone
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReadyToPlayRelUpReg;

/**
 * The error message of 'ReadyToPlay'
 */
typedef ::asf::cca::CcaTypes::DefaultError ReadyToPlayError;

/**
 * The get message of the property "BluetoothAudioDeviceStatus"
 * Update the busy or free status of Bluetooth Audio input device.
 * BT audio input device should not be read by multiple processes. Incase any process
 * wants to use Bluetooth Audio input device, process has to request the device
 * to Mediaplayer by method RequestBluetoothAudioDevice if the device is free
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothAudioDeviceStatusGet;

/**
 * The upreg message of the property "BluetoothAudioDeviceStatus"
 * Update the busy or free status of Bluetooth Audio input device.
 * BT audio input device should not be read by multiple processes. Incase any process
 * wants to use Bluetooth Audio input device, process has to request the device
 * to Mediaplayer by method RequestBluetoothAudioDevice if the device is free
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothAudioDeviceStatusUpReg;

/**
 * The relUpReg message of the property "BluetoothAudioDeviceStatus"
 * Update the busy or free status of Bluetooth Audio input device.
 * BT audio input device should not be read by multiple processes. Incase any process
 * wants to use Bluetooth Audio input device, process has to request the device
 * to Mediaplayer by method RequestBluetoothAudioDevice if the device is free
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothAudioDeviceStatusRelUpReg;

/**
 * The error message of 'BluetoothAudioDeviceStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError BluetoothAudioDeviceStatusError;

/**
 * The abort error message of the method "CreateMediaPlayerQuickPlayList"
 * This method generates an ordered list of media objects that match all
 * the specified filter criteria. The order and contents of the list
 * generated are dependent on the filter criteria and the AutoPlay
 * parameter. The list created by this method creates the list of objects
 * to play, in the order to play them as follows:
 *
 * This method may only be called on a device that supported indexing
 * ccording to its DeviceInfo.DeviceIndexedState property as reported by
 * either MediaPlayerDeviceConnections or ActiveMediaDevice. If
 * DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 *
 * This method returns a handle to the created playlist and the number of
 * objects in the list.
 *
 * A list is considered to be valid until the ReleaseMediaPlayerList
 * function is executed.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 *
 * QuickPlayList features are only supported by the MediaPlayer FBlock
 * when MyMediaSupported (0x230) == TRUE.  If MyMediaSupported == FALSE
 * (i.e. for a Base Radio MediaPlayer implementation), then both
 * CreateMediaPlayerQuickPlaylistList and
 * RequestMediaPlayerQuickPlayListSlice shall not be called by a
 * controller.  If they are called in error when MyMediaSupported =
 * FALSE, the MediaPlayer FBlock shall respond with error.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerQuickPlayListAbortError;

/**
 * The error message of 'CreateMediaPlayerQuickPlayList'
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerQuickPlayListError;

/**
 * The abort error message of the method "CreateMediaPlayerIndexedList"
 * This method creates a new list that contains the meta-data values of the
 * requested indexed media as follows:
 *
 * The client can specify up to three filter Tags, dependent on the type
 * of list requested. The order and contents of the list generated are
 * dependent on the filter criteria.
 *
 * This method may only be called on a device that supported indexing
 * ccording to its DeviceInfo.DeviceIndexedState property as reported by
 * either MediaPlayerDeviceConnections or ActiveMediaDevice. If
 * DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 *
 * This method returns a handle to the created playlist and the number of
 * objects in the list.
 *
 * A list is considered to be valid until the ReleaseMediaPlayerList
 * function is executed.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 *
 * The CreateMediaPlayerIndexedList function assigns a unique ListHandle
 * for each filtered list created and returns this value, as well as the
 * number of results in the filtered list.
 *
 * A list is considered to be valid until the ReleaseMediaPlayerList
 * function is executed.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerIndexedListAbortError;

/**
 * The error message of 'CreateMediaPlayerIndexedList'
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerIndexedListError;

/**
 * The abort error message of the method "RequestMediaPlayerIndexedListSlice"
 * The RequestMediaPlayerIndexedListSlice method provides a slice of the
 * filtered list specified by the ListHandle parameter. The slice begins
 * with the item at location WindowStart and includes in sequential order
 * the number of items specified by the parameter WindowSize.
 *
 * The RequestListSlice method returns the slice as a MediaObjects stream.
 * The data contained in each MediaObject is used by the HMI to determine
 * the meta-data and other properties of the media object.
 *
 * If the number of items in the list starting at WindowStart is less than
 * the WindowSize parameter then the number of items provided in the slice
 * will be less than the WindowSize calling parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerIndexedListSliceAbortError;

/**
 * The error message of 'RequestMediaPlayerIndexedListSlice'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerIndexedListSliceError;

/**
 * The result message of the method "ReleaseMediaPlayerList"
 * The ReleaseMediaPlayerList function releases a list that has been
 * created by the  CreateMediaPlayerFileList, CreateMediaPlayerIndexedList,
 * CreateMediaPlayerQuickPlayList methods.  The list to release is
 * specified by the ListHandle parameter. The ListHandle becomes invalid by
 * this function.
 *
 * Possible errors that may be encountered include: ERR_INVALID_HANDLE
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReleaseMediaPlayerListResult;

/**
 * The abort error message of the method "ReleaseMediaPlayerList"
 * The ReleaseMediaPlayerList function releases a list that has been
 * created by the  CreateMediaPlayerFileList, CreateMediaPlayerIndexedList,
 * CreateMediaPlayerQuickPlayList methods.  The list to release is
 * specified by the ListHandle parameter. The ListHandle becomes invalid by
 * this function.
 *
 * Possible errors that may be encountered include: ERR_INVALID_HANDLE
 */
typedef ::asf::cca::CcaTypes::DefaultError ReleaseMediaPlayerListAbortError;

/**
 * The error message of 'ReleaseMediaPlayerList'
 */
typedef ::asf::cca::CcaTypes::DefaultError ReleaseMediaPlayerListError;

/**
 * The result message of the method "RequestPlaybackAction"
 * Requests the playback action for the currently playing media files.
 * Playback actions include:
 * Previous or next track
 * Fast forward or fast reverse
 * Play, pause, or stop
 * Folder up or folder down
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestPlaybackActionResult;

/**
 * The abort error message of the method "RequestPlaybackAction"
 * Requests the playback action for the currently playing media files.
 * Playback actions include:
 * Previous or next track
 * Fast forward or fast reverse
 * Play, pause, or stop
 * Folder up or folder down
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestPlaybackActionAbortError;

/**
 * The error message of 'RequestPlaybackAction'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestPlaybackActionError;

/**
 * The result message of the method "SeekTo"
 * Requests to move to a specific point within the current track. The desired
 * position can be expressed either as a percentage of the TotalPlaytime or
 * as the absolute desired playpoint position. The two parameters are
 * mutually exclusive.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SeekToResult;

/**
 * The abort error message of the method "SeekTo"
 * Requests to move to a specific point within the current track. The desired
 * position can be expressed either as a percentage of the TotalPlaytime or
 * as the absolute desired playpoint position. The two parameters are
 * mutually exclusive.
 */
typedef ::asf::cca::CcaTypes::DefaultError SeekToAbortError;

/**
 * The error message of 'SeekTo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SeekToError;

/**
 * The abort error message of the method "GetMediaObjectAlbumArt"
 * The GetMediaObjectAlbumArt method is called to retrieve the album art
 * image, if it exists, for a particular media object. The image is returned
 * in a MIME-typed image format. To get the MIME type, as well as image size,
 * controllers first call the GetMediaObjectAlbumArtInfo Method, retrieve the
 * MIME type and size to set up the retrieval of the album art, then call
 * GetMediaObjectAlbumArt to retrieve the actual image data. The size of the image can be defined by the
 * values u32SizeX and u32SizeY. This values shall be identical to the used values in GetMediaObjectAlbumArtInfo.
 * The FBlock and calling controller shall support the following image file
 * formats. If a particular media object's Album art is not in one of these
 * supported formats, the FBlock shall either transcode the album art into
 * one of these formats or report no album art (by setting the AlbumArt URL
 * to a NULL zero-length string for the object in the GetMediaObject
 * ResultAck data).
 * PNG Format
 * MIME Type = 'image/png'
 * PNG 'TrueColor' 24-bit format without Alpha blending
 * PNG 'Indexed' with 1, 2, 4, and 8 bits per pixel
 * BMP Format
 * MIME Type = 'image/x-ms-bmp'
 * Header field = 'BM' (other header types not supported)
 * Bits per pixel = 8, 16, or 24
 * Number of colors in color palette = 0, full color, as well as
 * paletted support for the above Bits per pixel avalues.
 * Compression = RGB, RLE8, and BITFIELDS
 *
 * JPEG and PNGs contained within a BMP are intended for printer
 * support only and are not required. JPEG and PNG images shall be
 * transmitted as dedicated JPEG and PNG images instead of
 * containerizing within the BMP format.
 * GIF Format
 * MIME Type = 'image/gif'
 * LZW compressed support only. No Animated GIF support required.
 * JPEG Format (JPEG File Interchange Format (JFIF) per ISO/IEC FCD
 * 10918-5)
 * MIME Type = 'image/jpeg'
 * Thumbnail data and JFIF extension segment format not required.
 * i.e. Only one image per each JPEG formatted MHP transmission.
 * For all of the formats above, the maximum size and image resolution
 * are limited by internal calibrations within the FBlock. For album art
 * above this limit, the FBlock shall scale the image down to the maximum
 * supported size if possible. If image re-scaling is not possible, then
 * the FBlock shall report no image for the associated Album art.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetMediaObjectAlbumArtAbortError;

/**
 * The error message of 'GetMediaObjectAlbumArt'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetMediaObjectAlbumArtError;

/**
 * The abort error message of the method "SearchKeyboardMediaPlayerList"
 * This function returns the search keyboard for a particular ListHandle.  The returned list identifies which letters of the Vertical Keyboard have at
 * least one Media Player entry that start with that letter. The index of the
 * first entry associated with the letter is also provided.If a
 * letter does not have an index then a Media Player entry that starts with
 * that letter does not exist.
 *
 * Note that the returned search keyboard list may no longer be valid if items in the underlying list have changed.  Thus, controllers shall re-request the search keyboard list upon a receipt of MediaPlayerListChange for the ListHandle tied to the returned search keyboard.
 */
typedef ::asf::cca::CcaTypes::DefaultError SearchKeyboardMediaPlayerListAbortError;

/**
 * The error message of 'SearchKeyboardMediaPlayerList'
 */
typedef ::asf::cca::CcaTypes::DefaultError SearchKeyboardMediaPlayerListError;

/**
 * The abort result message of the method "CreateMediaPlayerListSearchString"
 * <p>This method creates a new list that contains the meta-data values of the
 * requested indexed media based on a parent list plus a character or string search.</p>
 * <p>Before using this function client has to setup a parent list using function CreateMediaPlayerIdexedList
 * or CreateMediaPlayerFileList.
 *
 * This is premisses for function 'CreateMediaPlayerListSearchString' to be used</p>
 * <p>A search string is the main parameter in addition to the ListID of the previously created parent list.
 * Internally from this parent ID filter Tags of parent are gained which are used then in additiona to the mentioned  characted or string to
 * search subset results in the metadata database.
 *
 * In other words the order and content of the list generated
 * dependent on the filter criteria of the parent list plus the character or string used.
 *
 * To get an overview which types of list are supported please refer to ai_mediaplayer/components/GenericMediaplayer/Common/TypeDefinitions.h
 * and 'tListType' for all supported parent list types a list type '_SEARCH' exists. Example 'LTY_ALBUM' has 'LTY_ALBUM_SEARCH'
 *
 * Special: File Lists are supported after indexing as Browse lists (under construction)</p>
 * <p>Method 'CreateMediaPlayerListSearchString' returns a handle (ListID). And a size. If size of this list is 0 the list is empty.
 *
 * As a next reaction 3 types of messages are send: MethodReturnFirst (once), MethodReturnMiddle (several), MethodReturnLast (once)
 *
 * Scenario Empty list size==0:
 * MethodReturnFirst once sends size 0, MethodReturnMiddle once sends size 0 and MethodReturnLast once sends size 0
 *
 * Scenario List size==1:
 * MethodReturnFirst once sends size 1, MethodReturnMiddle once sends size 1 and MethodReturnLast once sends size 1
 *
 * Scenario List size==10 (example increment would be 5):
 * MethodReturnFirst once sends size 1, MethodReturnMiddle sends 1,5,10 and MethodReturnLast once sends size 10
 *
 * Note: The increment is defined within mediaplayer (under construction: configurable per project) above '5' is just given as an example.</p>
 * <p>Scenario: Delete list:
 * A list is considered to be valid until the ReleaseMediaPlayerList function is executed.
 *
 * Between executing search increments the full text search thread search is interruptable. To do the following options:
 *
 * Release parent list results in release of parent list plus all search lists which depend on it.
 *
 * Release a search list based on listID (handle) of search lists release this specific list.
 *
 * Create new search list with having previously created search list as parameter 'replacable list'
 *
 * Internally shutdown of mediaplayer releases all lists and thus also all search lists.
 *
 * If full text search is aborted in the mentioned way then no MethodReturnLast is send. Instead MethodAbort is send</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CreateMediaPlayerListSearchStringAbortResult;

/**
 * The abort error message of the method "CreateMediaPlayerListSearchString"
 * <p>This method creates a new list that contains the meta-data values of the
 * requested indexed media based on a parent list plus a character or string search.</p>
 * <p>Before using this function client has to setup a parent list using function CreateMediaPlayerIdexedList
 * or CreateMediaPlayerFileList.
 *
 * This is premisses for function 'CreateMediaPlayerListSearchString' to be used</p>
 * <p>A search string is the main parameter in addition to the ListID of the previously created parent list.
 * Internally from this parent ID filter Tags of parent are gained which are used then in additiona to the mentioned  characted or string to
 * search subset results in the metadata database.
 *
 * In other words the order and content of the list generated
 * dependent on the filter criteria of the parent list plus the character or string used.
 *
 * To get an overview which types of list are supported please refer to ai_mediaplayer/components/GenericMediaplayer/Common/TypeDefinitions.h
 * and 'tListType' for all supported parent list types a list type '_SEARCH' exists. Example 'LTY_ALBUM' has 'LTY_ALBUM_SEARCH'
 *
 * Special: File Lists are supported after indexing as Browse lists (under construction)</p>
 * <p>Method 'CreateMediaPlayerListSearchString' returns a handle (ListID). And a size. If size of this list is 0 the list is empty.
 *
 * As a next reaction 3 types of messages are send: MethodReturnFirst (once), MethodReturnMiddle (several), MethodReturnLast (once)
 *
 * Scenario Empty list size==0:
 * MethodReturnFirst once sends size 0, MethodReturnMiddle once sends size 0 and MethodReturnLast once sends size 0
 *
 * Scenario List size==1:
 * MethodReturnFirst once sends size 1, MethodReturnMiddle once sends size 1 and MethodReturnLast once sends size 1
 *
 * Scenario List size==10 (example increment would be 5):
 * MethodReturnFirst once sends size 1, MethodReturnMiddle sends 1,5,10 and MethodReturnLast once sends size 10
 *
 * Note: The increment is defined within mediaplayer (under construction: configurable per project) above '5' is just given as an example.</p>
 * <p>Scenario: Delete list:
 * A list is considered to be valid until the ReleaseMediaPlayerList function is executed.
 *
 * Between executing search increments the full text search thread search is interruptable. To do the following options:
 *
 * Release parent list results in release of parent list plus all search lists which depend on it.
 *
 * Release a search list based on listID (handle) of search lists release this specific list.
 *
 * Create new search list with having previously created search list as parameter 'replacable list'
 *
 * Internally shutdown of mediaplayer releases all lists and thus also all search lists.
 *
 * If full text search is aborted in the mentioned way then no MethodReturnLast is send. Instead MethodAbort is send</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerListSearchStringAbortError;

/**
 * The error message of 'CreateMediaPlayerListSearchString'
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerListSearchStringError;

/**
 * The abort error message of the method "GetMediaObject"
 * Request all meta-data information for a requested Tag item.  The CategoryType parameter is optional and can be used to limit the scope of a tag search.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetMediaObjectAbortError;

/**
 * The error message of 'GetMediaObject'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetMediaObjectError;

/**
 * The abort error message of the method "CreateMediaPlayerFileList"
 * This method create a list of all supported files and folders in the "Path"
 * directory. The CreateMediaPlayerFileList function assigns a unique
 * ListHandle for each filtered list created and returns this value, as well
 * as the number of results in the filtered list. A list is considered to be
 * valid until the ReleaseMediaPlayerList function is executed. Changes to a
 * list are reported by the MediaPlayerListChange property.This
 * method also returns the total number of Files (FileType != FOLDER) and
 * Folders (FileType = Folder) in the associated List. These numbers are
 * static for each List at creation time and are included as returned
 * parameters to allow HMI controllers to configure their view accordingly
 * without requiring the controller to pull the entire list and iterate it
 * first.
 * The parameter e8FileTypeSelection can be used to qualify the content of the list.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerFileListAbortError;

/**
 * The error message of 'CreateMediaPlayerFileList'
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerFileListError;

/**
 * The abort error message of the method "RequestMediaPlayerFileListSlice"
 * The RequestMediaPlayerFileListSlice method provides a slice of the
 * filtered list specified by the ListHandle parameter. The slice begins
 * with the item at location WindowStart and includes in sequential order
 * the number of items specified by the parameter WindowSize.
 *
 * The RequestMediaPlayerFileListSlice method returns the slice as a
 * FileList stream.
 *
 * If the number of items in the list starting at WindowStart is less than
 * the WindowSize parameter then the number of items provided in the slice
 * will be less than the WindowSize calling parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerFileListSliceAbortError;

/**
 * The error message of 'RequestMediaPlayerFileListSlice'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerFileListSliceError;

/**
 * The abort error message of the method "CreateMediaPlayerPlaylistList"
 * This method generates a list of the items in a playlist.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerPlaylistListAbortError;

/**
 * The error message of 'CreateMediaPlayerPlaylistList'
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerPlaylistListError;

/**
 * The abort error message of the method "RequestMediaPlayerPlaylistListSlice"
 * The RequestMediaPlayerPlaylistListSlice method provides a slice of the
 * list specified by the ListHandle parameter. The slice begins with the item
 * at location WindowStart and includes in sequential order the number of
 * items specified by the parameter WindowSize. The contents of the list are
 * filenames from a playlist.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerPlaylistListSliceAbortError;

/**
 * The error message of 'RequestMediaPlayerPlaylistListSlice'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerPlaylistListSliceError;

/**
 * The abort error message of the method "RequestMediaPlayerQuickPlayListSlice"
 * The RequestMediaPlayerQuickPlayListSlice method provides a slice of the
 * filtered list specified by the ListHandle parameter as follows:
 *
 * The slice begins with the item at location WindowStart and includes in
 * sequential order the number of items specified by the parameter
 * WindowSize.
 *
 * The RequestMediaPlayerListSlice method returns the slice as a
 * MediaObjects stream. The data contained in each MediaObject is used by
 * the HMI to determine the meta-data and other properties of the media
 * object.
 *
 * If the number of items in the list starting at WindowStart is less
 * than the WindowSize parameter then the number of items provided in the
 * slice will be less than the WindowSize calling parameter.
 *
 * QuickPlayList features are only supported by the MediaPlayer FBlock
 * when MyMediaSupported (0x230) == TRUE. If MyMediaSupported == FALSE
 * (i.e. for a Base Radio MediaPlayer implementation), then both
 * CreateMediaPlayerQuickPlaylistList and
 * RequestMediaPlayerQuickPlayListSlice shall not be called by a
 * controller. If they are called in error when MyMediaSupported = FALSE,
 * the MediaPlayer FBlock shall respond with an error
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerQuickPlayListSliceAbortError;

/**
 * The error message of 'RequestMediaPlayerQuickPlayListSlice'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerQuickPlayListSliceError;

/**
 * The abort error message of the method "GetMediaObjectAlbumArtInfo"
 * This Method is used to retrieve the MIME type and size of the album art
 * image associated with a particular media object (if one exists for the
 * requested object). The size is dependent from the u32SizeX and u32SizeY. The actual album art image is retrieved by calling the
 * GetMediaObjectAlbumArt function. This function shall be called with the same value u32SizeX and u32SizeY.  See the description for the
 * GetMediaObjectAlbumArt Method for specific format support requirements.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetMediaObjectAlbumArtInfoAbortError;

/**
 * The error message of 'GetMediaObjectAlbumArtInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetMediaObjectAlbumArtInfoError;

/**
 * The abort error message of the method "PlayMediaPlayerObject"
 * The PlayMediaPlayerObject method is called to set the play object within
 * the MediaPlayer. The MediaPlayer handles this function as follows:
 *
 * If the MediaPlayer is not currently playing audio, it internally
 * stores the new object as the object to play the next time that the
 * MediaPlayer is connected for audio playback through the AVManager by
 * an HMI controller within the system.
 *
 * If the MediaPlayer is already connected on the network and playing
 * audio on another media object, it stops playback of that media object
 * and starts playing the new object automatically
 *
 * Note that the connect operation to the AVManager (RequestAVActivation
 * method) is not performed by the MediaPlayer and is instead performed
 * by an HMI controller. For example, if the user directly selects an
 * Artist from an HMI menu, the HMI controller would first call
 * PlayMediaPlayerObject and then would call the
 * AVManager.RequestAVActivation to connect the MediaPlayer over a
 * Logical Audio Channel.
 */
typedef ::asf::cca::CcaTypes::DefaultError PlayMediaPlayerObjectAbortError;

/**
 * The error message of 'PlayMediaPlayerObject'
 */
typedef ::asf::cca::CcaTypes::DefaultError PlayMediaPlayerObjectError;

/**
 * The abort error message of the method "PlayItemFromList"
 * The PlayItemFromList shall be used ONLY for accessing items from a Folder
 * list.  For all other lists, the new (as of 2.4.3) method
 * PlayItemFromListByTag 0x234 instead.The reason for this
 * restriction is that when the MediaPlayer adds items to the list, the
 * supplied StartIndex+StartOffset in the PlayItemFromList.StartResultAck may
 * now point to a different item in the list than the one that the user
 * selected. In PlayItemFromListByTag, the Tag of the item from which to
 * start play is sent instead, and, because the Tag doesn't change as the
 * list is updated, this error cannot occur.  However, this behavior does not
 * occur for Folder lists because the lists are static and do not change
 * after creation.The PlayItemFromList method is called to play an
 * item from a Folder list that has already been created. This method is
 * handled by the MediaPlayer as follows:
 *
 *
 * If the MediaPlayer is not currently connected as an audio source to
 * the AVManager, then the MediaPlayer sets the
 * item in the list, and the rest of the list as well, as the next media
 * object to be played when the MediaPlayer is next connected to the
 * AVManager.
 *
 * If the MediaPlayer is already connected on the network and playing
 * audio on another media object, it stops playback of that media object
 * and starts playing the selected list item automatically.
 *
 * Playback begins at the position specified by the StartIndex parameter
 * and continues in the order of the items included in the list defined
 * by the ListHandle parameter.
 *
 * In order to use this method, all items in the list must be "playable".
 * Therefore, this method is mainly used in conjunction with
 * CreateMediaPlayerQuickPlayList but can also be used with
 * CreateMediaPlayerFile.
 */
typedef ::asf::cca::CcaTypes::DefaultError PlayItemFromListAbortError;

/**
 * The error message of 'PlayItemFromList'
 */
typedef ::asf::cca::CcaTypes::DefaultError PlayItemFromListError;

/**
 * The start message of the method "ClearMediaPlayerData"
 * This function is called to clear out all stored information within the MediaPlayer including all index information.  Upon receipt of the StartAck optype,the PhoneBook FBlock shall permanently delete all index information from both temporary (e.g. DRAM) and permanent (Flash) memory.
 *
 * This function is used, for example, to delete all the media player index information when a vehicle is turned-in at the end of lease.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearMediaPlayerDataStart;

/**
 * The result message of the method "ClearMediaPlayerData"
 * This function is called to clear out all stored information within the MediaPlayer including all index information.  Upon receipt of the StartAck optype,the PhoneBook FBlock shall permanently delete all index information from both temporary (e.g. DRAM) and permanent (Flash) memory.
 *
 * This function is used, for example, to delete all the media player index information when a vehicle is turned-in at the end of lease.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearMediaPlayerDataResult;

/**
 * The abort error message of the method "ClearMediaPlayerData"
 * This function is called to clear out all stored information within the MediaPlayer including all index information.  Upon receipt of the StartAck optype,the PhoneBook FBlock shall permanently delete all index information from both temporary (e.g. DRAM) and permanent (Flash) memory.
 *
 * This function is used, for example, to delete all the media player index information when a vehicle is turned-in at the end of lease.
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearMediaPlayerDataAbortError;

/**
 * The error message of 'ClearMediaPlayerData'
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearMediaPlayerDataError;

/**
 * The abort error message of the method "Umount"
 * The Umount method is called to support a safe disconnection of the SDCard.
 */
typedef ::asf::cca::CcaTypes::DefaultError UmountAbortError;

/**
 * The error message of 'Umount'
 */
typedef ::asf::cca::CcaTypes::DefaultError UmountError;

/**
 * The result message of the method "Reindexing"
 * The reindexing function can be called by controller to start a indexing of a specified device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReindexingResult;

/**
 * The abort error message of the method "Reindexing"
 * The reindexing function can be called by controller to start a indexing of a specified device.
 */
typedef ::asf::cca::CcaTypes::DefaultError ReindexingAbortError;

/**
 * The error message of 'Reindexing'
 */
typedef ::asf::cca::CcaTypes::DefaultError ReindexingError;

/**
 * The result message of the method "DiagnosisPlaySong"
 * This function searches the first connected device of the specifed type and tries to play the song
 * specified in sFilename in an infinite loop.
 * sFileName contains the complete path and the filename.
 * To come out of the infinite loop behaviour, from HMI PBA_NEXT can be issued or a different song
 * can be selected for playback from any indexed/file list.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagnosisPlaySongResult;

/**
 * The abort error message of the method "DiagnosisPlaySong"
 * This function searches the first connected device of the specifed type and tries to play the song
 * specified in sFilename in an infinite loop.
 * sFileName contains the complete path and the filename.
 * To come out of the infinite loop behaviour, from HMI PBA_NEXT can be issued or a different song
 * can be selected for playback from any indexed/file list.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiagnosisPlaySongAbortError;

/**
 * The error message of 'DiagnosisPlaySong'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiagnosisPlaySongError;

/**
 * The abort error message of the method "RequestListDetails"
 * deprecated. The RequestListDetails Method is deprecated and its use is discouraged. It is retained within
 * the function catalog for backward compatibility only. All controllers
 * should use the RequestListInformation Method FktID 0x232 instead.
 *
 * The RequestListDetails Method can be called
 * by HMI controllers to retrieve the following information associated with
 * the supplied ListHandle:
 * The ListType for this list.
 * The llist parent's ListHandle or NULL if the supplied ListHandle
 * corresponds to a top-level, root list.
 * The DeviceTag from which the list was generated (either a specific
 * device or 0 for MyMedia)
 * The object's position within the parent's list starting from 0 (within
 * the Position parameter)
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestListDetailsAbortError;

/**
 * The error message of 'RequestListDetails'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestListDetailsError;

/**
 * The abort error message of the method "RequestListInformation"
 * The RequestListInformation Method provides a means for HMI controllers to
 * retrieve detailed information on a ListHandle as follows:
 *
 * This method was added to allow controllers to determine type, size,
 * and parent list information for the ListHandle transmitted in the
 * NowPlaying property Status notifications. Only the ListHandle is sent
 * within the NowPlaying.Status notification, but controllers need type,
 * parent, and size information to implement the required functionality.
 *
 * The following information is returned in the ResultAck response.
 * ListType contains the type of the list for the supplied ListHandle.
 * ParentListHandle contains the handle of the parent to this list.
 * If the supplied ListHandle is the 'root' list and does not have a
 * parent, the returned ListHandle will be NULL (0x00000000).
 * DeviceTag points to the device from which the list was generated
 * which will be either 0 for MyMedia if the list was generated from
 * the MyMedia database across all devices or a valid device-specific
 * tag if the list only includes information from a specific user
 * device.
 * Position of this list item within the parent's list (the list
 * pointed by the ParentListHandle). If this list does not have a
 * parent (ParentListHandle = NULL, 0x00000000), then the Position
 * parameter shall be set to 0 as a NULL default.
 * ListSize is the current number of items in the list pointed by the
 * supplied ListHandle.
 * RequestListInformation replaces the deprecated RequestListDetails
 * 0x231 FktID. RequestListDetails did not include the ListSize parameter
 * which was determined to be required in order for controllers to
 * properly handling their subsequent RequestMediaPlayerIndexedListSlice
 * calls. RequestListInformation was thus created as an extension of
 * RequestListDetails that also includes the ListSize. All new controller
 * designs shall use RequestListInformation instead of RequestListDetails.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestListInformationAbortError;

/**
 * The error message of 'RequestListInformation'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestListInformationError;

/**
 * The abort error message of the method "TransferTagsToDevice"
 * TransferTagsToDevice is called by a controller to transfer tags to a
 * customer portable device (generally an Apple iPod/iPhone/iTouch, etc.)
 * connected to the USB port as follows:
 *
 * The controller accumulates information for tagging via interfaces on
 * the tuner FBlocks (HD AM or FMTuner, SDARS FBlock,etc.).
 *
 * The controller passes the accumulated tag information to the
 * MediaPlayer FBlock via the StartResultAck of this method, generally
 * upon connection of the user's device.
 *
 * Upon receipt of the StartResultAck, the MediaPlayer FBlock attempts to
 * transfer the tags to a customer device connected to the MediaPlayer
 * FBlock, generally via the USB port.
 *
 * The TagTransferStatus parameter in the ResultAck response indicates
 * the completion status of the operation. Note that if TagTransferStatus
 * != SUCCESS, then one or more tags could not be transferred. The ID
 * information for the tags that were not transferred is passed back in
 * the UntransferredTagStream property.
 *
 * Upon receipt of the ResultAck response, the requesting controller may
 * delete the stored tags that were successfully transferred. If there
 * were transfer errors, then the controller should keep the
 * untransferred tags and attempt to transfer them again at the next
 * device connection.
 *
 * This function replaces the deprecated TransferTags FktID 0x227 Method.
 */
typedef ::asf::cca::CcaTypes::DefaultError TransferTagsToDeviceAbortError;

/**
 * The error message of 'TransferTagsToDevice'
 */
typedef ::asf::cca::CcaTypes::DefaultError TransferTagsToDeviceError;

/**
 * The result message of the method "PlayItemFromListByTag"
 * The PlayItemFromListByTag method is called to play an item from a
 * previously created list. The item is identified by the Tag parameter which
 * must point to an item currently in the list. PlayItemFromListByTag
 * replaces PlayItemFromList 0x229 because PlayItemFromList uses an index to
 * identify the item to play.
 * The PlayItemFromListByTag method is handled by the MediaPlayer as follows:
 *
 * If the MediaPlayer is not currently connected as an audio source to
 * the AVManager, then the MediaPlayer sets the
 * item in the list, and the rest of the list as well, as the next media
 * object to be played when the MediaPlayer is next connected to the
 * AVManager.
 *
 * If the MediaPlayer is already connected on the network and playing
 * audio on another media object, it stops playback of that media object
 * and starts playing the selected list item automatically.
 *
 * Playback begins at the object identifed by the Tag parameter and
 * continues according to the order of the list identified by the
 * ListHandle parameter.
 *
 * In order to use this method, all items in the list must be "playable".
 * Therefore, this method is mainly used in conjunction with
 * CreateMediaPlayerQuickPlayList but can also be used with
 * CreateMediaPlayerFile.
 *
 * The item identified by the Tag must currently exist in the list. If it
 * does not exist, the MediaPlayer shall respond with an error.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PlayItemFromListByTagResult;

/**
 * The abort error message of the method "PlayItemFromListByTag"
 * The PlayItemFromListByTag method is called to play an item from a
 * previously created list. The item is identified by the Tag parameter which
 * must point to an item currently in the list. PlayItemFromListByTag
 * replaces PlayItemFromList 0x229 because PlayItemFromList uses an index to
 * identify the item to play.
 * The PlayItemFromListByTag method is handled by the MediaPlayer as follows:
 *
 * If the MediaPlayer is not currently connected as an audio source to
 * the AVManager, then the MediaPlayer sets the
 * item in the list, and the rest of the list as well, as the next media
 * object to be played when the MediaPlayer is next connected to the
 * AVManager.
 *
 * If the MediaPlayer is already connected on the network and playing
 * audio on another media object, it stops playback of that media object
 * and starts playing the selected list item automatically.
 *
 * Playback begins at the object identifed by the Tag parameter and
 * continues according to the order of the list identified by the
 * ListHandle parameter.
 *
 * In order to use this method, all items in the list must be "playable".
 * Therefore, this method is mainly used in conjunction with
 * CreateMediaPlayerQuickPlayList but can also be used with
 * CreateMediaPlayerFile.
 *
 * The item identified by the Tag must currently exist in the list. If it
 * does not exist, the MediaPlayer shall respond with an error.
 */
typedef ::asf::cca::CcaTypes::DefaultError PlayItemFromListByTagAbortError;

/**
 * The error message of 'PlayItemFromListByTag'
 */
typedef ::asf::cca::CcaTypes::DefaultError PlayItemFromListByTagError;

/**
 * The abort error message of the method "PlaybackSpeedSet"
 * Sets the playback speed for the currently playing media file.
 */
typedef ::asf::cca::CcaTypes::DefaultError PlaybackSpeedSetAbortError;

/**
 * The error message of 'PlaybackSpeedSet'
 */
typedef ::asf::cca::CcaTypes::DefaultError PlaybackSpeedSetError;

/**
 * The result message of the method "ClearLastModePause"
 * On receiving this request,When the device(of given u8DeviceTag) is activated,playback is resumed irrespective of its lastmode pause.
 * This need to be invoked by Speech ONLY when it wants to activate a Device and NOT when it wants mediaplayer to play user uttered MediaItem.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearLastModePauseResult;

/**
 * The abort error message of the method "ClearLastModePause"
 * On receiving this request,When the device(of given u8DeviceTag) is activated,playback is resumed irrespective of its lastmode pause.
 * This need to be invoked by Speech ONLY when it wants to activate a Device and NOT when it wants mediaplayer to play user uttered MediaItem.
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearLastModePauseAbortError;

/**
 * The error message of 'ClearLastModePause'
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearLastModePauseError;

/**
 * The result message of the method "RequestDiscOperation"
 * Sends the command to perform disc operations like loading and ejecting
 * Load
 * Eject
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestDiscOperationResult;

/**
 * The abort error message of the method "RequestDiscOperation"
 * Sends the command to perform disc operations like loading and ejecting
 * Load
 * Eject
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestDiscOperationAbortError;

/**
 * The error message of 'RequestDiscOperation'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestDiscOperationError;

/**
 * The result message of the method "RequestVCDAudioChannel"
 * Requests the audio channel mode change
 * For non SVCD there will not be 2 channels so channel 1 is taken as default audio channel mode
 * Which includes
 * Channel 1 Stereo
 * Channel 1 LL
 * Channel 1 RR
 * Channel 1 Mono
 * Channel 2 Stereo
 * Channel 2 LL
 * Channel 2 RR
 * Channel 2 Mono
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestVCDAudioChannelResult;

/**
 * The abort error message of the method "RequestVCDAudioChannel"
 * Requests the audio channel mode change
 * For non SVCD there will not be 2 channels so channel 1 is taken as default audio channel mode
 * Which includes
 * Channel 1 Stereo
 * Channel 1 LL
 * Channel 1 RR
 * Channel 1 Mono
 * Channel 2 Stereo
 * Channel 2 LL
 * Channel 2 RR
 * Channel 2 Mono
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestVCDAudioChannelAbortError;

/**
 * The error message of 'RequestVCDAudioChannel'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestVCDAudioChannelError;

/**
 * The result message of the method "RequestDVDAudioChannel"
 * Requests the DVD audio number change, It varies from 1-8.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestDVDAudioChannelResult;

/**
 * The abort error message of the method "RequestDVDAudioChannel"
 * Requests the DVD audio number change, It varies from 1-8.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestDVDAudioChannelAbortError;

/**
 * The error message of 'RequestDVDAudioChannel'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestDVDAudioChannelError;

/**
 * The result message of the method "SendNavigationKey"
 * Sends the command to navigate which includes
 * UPPER
 * LOWER
 * LEFT
 * RIGHT
 * ENTER
 * RETURN
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SendNavigationKeyResult;

/**
 * The abort error message of the method "SendNavigationKey"
 * Sends the command to navigate which includes
 * UPPER
 * LOWER
 * LEFT
 * RIGHT
 * ENTER
 * RETURN
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNavigationKeyAbortError;

/**
 * The error message of 'SendNavigationKey'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNavigationKeyError;

/**
 * The result message of the method "SendTouchCommand"
 * Sends the command to navigate when it is a direct touch
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SendTouchCommandResult;

/**
 * The abort error message of the method "SendTouchCommand"
 * Sends the command to navigate when it is a direct touch
 */
typedef ::asf::cca::CcaTypes::DefaultError SendTouchCommandAbortError;

/**
 * The error message of 'SendTouchCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendTouchCommandError;

/**
 * The result message of the method "RequestDirectSearch"
 * Sends the command to Search the correct track/ chapter or file number.
 * It works only for DVD Disc Type – D, F, G and data disc
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestDirectSearchResult;

/**
 * The abort error message of the method "RequestDirectSearch"
 * Sends the command to Search the correct track/ chapter or file number.
 * It works only for DVD Disc Type – D, F, G and data disc
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestDirectSearchAbortError;

/**
 * The error message of 'RequestDirectSearch'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestDirectSearchError;

/**
 * The result message of the method "RequestAngleChange"
 * Sends the command to Specify the angle to use. Applicable only for DVD-Video and DVD Audio. Angle varies from 1 to 9.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestAngleChangeResult;

/**
 * The abort error message of the method "RequestAngleChange"
 * Sends the command to Specify the angle to use. Applicable only for DVD-Video and DVD Audio. Angle varies from 1 to 9.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestAngleChangeAbortError;

/**
 * The error message of 'RequestAngleChange'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestAngleChangeError;

/**
 * The result message of the method "SetMenuPlayBackControl"
 * Sends the command to do menu playback operations.
 * Not applicable for CD Audio -Type A and data disc -Type E.
 * In VCD (Type B and Type C) Top Menu is invalid and Menu command is used for playback control ON\OFF and media type change at the same time.
 * In DVD-VR (Type G) Top Menu is invalid and Menu command is used for playlist mode ON\OFF.
 * In DVD Audio, if Top menu (AMGM) is present playback happens else it becomes invalid or returns to group play mode. Menu is invalid.
 * In DVD Video, if Top menu (VMGM) is present playback happens else it becomes invalid or returns to title play mode. If Menu (VTSM) is present playback happens else it becomes invalid or returns to title play mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetMenuPlayBackControlResult;

/**
 * The abort error message of the method "SetMenuPlayBackControl"
 * Sends the command to do menu playback operations.
 * Not applicable for CD Audio -Type A and data disc -Type E.
 * In VCD (Type B and Type C) Top Menu is invalid and Menu command is used for playback control ON\OFF and media type change at the same time.
 * In DVD-VR (Type G) Top Menu is invalid and Menu command is used for playlist mode ON\OFF.
 * In DVD Audio, if Top menu (AMGM) is present playback happens else it becomes invalid or returns to group play mode. Menu is invalid.
 * In DVD Video, if Top menu (VMGM) is present playback happens else it becomes invalid or returns to title play mode. If Menu (VTSM) is present playback happens else it becomes invalid or returns to title play mode.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetMenuPlayBackControlAbortError;

/**
 * The error message of 'SetMenuPlayBackControl'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetMenuPlayBackControlError;

/**
 * The result message of the method "SelectDirectNumber"
 * Sends the command to perfrorm direct number selection in Internal DVD
 * Supported only in Video CD v2.0 (Type C) for direct selection of the number specified as parameter
 * and In DVD Audio (Type D) and DVD Video (Type F) for selecting the button equivalent to the number.
 * DirectSelectAvailable property will be set true if this operation is permitted by the current playing disc.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SelectDirectNumberResult;

/**
 * The abort error message of the method "SelectDirectNumber"
 * Sends the command to perfrorm direct number selection in Internal DVD
 * Supported only in Video CD v2.0 (Type C) for direct selection of the number specified as parameter
 * and In DVD Audio (Type D) and DVD Video (Type F) for selecting the button equivalent to the number.
 * DirectSelectAvailable property will be set true if this operation is permitted by the current playing disc.
 */
typedef ::asf::cca::CcaTypes::DefaultError SelectDirectNumberAbortError;

/**
 * The error message of 'SelectDirectNumber'
 */
typedef ::asf::cca::CcaTypes::DefaultError SelectDirectNumberError;

/**
 * The result message of the method "RequestTitleSearch"
 * Sends the command to start play back from the first chapter or track from the specific position mentioned
 * Supported in DVD-VR (Type G) and DVD Audio (Type D) for title number(1-99)
 * DVD Video (Type F) for Group Number (0-9)
 * Data Disc for folder number(1-254)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestTitleSearchResult;

/**
 * The abort error message of the method "RequestTitleSearch"
 * Sends the command to start play back from the first chapter or track from the specific position mentioned
 * Supported in DVD-VR (Type G) and DVD Audio (Type D) for title number(1-99)
 * DVD Video (Type F) for Group Number (0-9)
 * Data Disc for folder number(1-254)
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestTitleSearchAbortError;

/**
 * The error message of 'RequestTitleSearch'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestTitleSearchError;

/**
 * The result message of the method "RequestSubtitleChange"
 * Sends the command to switch on/off subtitle, toggle between subtitles or directly select a subtitle
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestSubtitleChangeResult;

/**
 * The abort error message of the method "RequestSubtitleChange"
 * Sends the command to switch on/off subtitle, toggle between subtitles or directly select a subtitle
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestSubtitleChangeAbortError;

/**
 * The error message of 'RequestSubtitleChange'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestSubtitleChangeError;

/**
 * The result message of the method "RequestCMSkip"
 * Used as a skip functionality , we can some forward or backward at 15s , 30s and 45s while playing a video file.
 * This method will be supported if CMSkipAvailable property is true.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestCMSkipResult;

/**
 * The abort error message of the method "RequestCMSkip"
 * Used as a skip functionality , we can some forward or backward at 15s , 30s and 45s while playing a video file.
 * This method will be supported if CMSkipAvailable property is true.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestCMSkipAbortError;

/**
 * The error message of 'RequestCMSkip'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestCMSkipError;

/**
 * The start message of the method "RequestDVDTemperature"
 * Requests the DVD Drive's current temperature
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestDVDTemperatureStart;

/**
 * The abort error message of the method "RequestDVDTemperature"
 * Requests the DVD Drive's current temperature
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestDVDTemperatureAbortError;

/**
 * The error message of 'RequestDVDTemperature'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestDVDTemperatureError;

/**
 * The abort error message of the method "ReorderInternalPlaylist"
 * Function reorder an entry in an internal playlist.
 */
typedef ::asf::cca::CcaTypes::DefaultError ReorderInternalPlaylistAbortError;

/**
 * The error message of 'ReorderInternalPlaylist'
 */
typedef ::asf::cca::CcaTypes::DefaultError ReorderInternalPlaylistError;

/**
 * The abort error message of the method "DeleteMediaContentByFilterTags"
 * This method deletes the media content from a source that contains the meta-data values of the
 * requested indexed media as follows:
 *
 * The client can specify up to three filter Tags, dependent on the type
 * of list requested.
 *
 * This method may only be called on a device that supports indexing
 * according to its 'DeviceInfo.DeviceIndexedState' property as reported by
 * either MediaPlayerDeviceConnections or ActiveMediaDevice. If
 * DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteMediaContentByFilterTagsAbortError;

/**
 * The error message of 'DeleteMediaContentByFilterTags'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteMediaContentByFilterTagsError;

/**
 * The abort error message of the method "DeleteMediaContentByMediaObjectTags"
 * This method deletes the media content from a source that contains the meta-data values of the
 * requested indexed media as follows:
 *
 * The client can specify up to three filter Tags, dependent on the type
 * of list requested.
 *
 * This method may only be called on a device that supports indexing
 * according to its 'DeviceInfo.DeviceIndexedState' property as reported by
 * either MediaPlayerDeviceConnections or ActiveMediaDevice. If
 * DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteMediaContentByMediaObjectTagsAbortError;

/**
 * The error message of 'DeleteMediaContentByMediaObjectTags'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteMediaContentByMediaObjectTagsError;

/**
 * The abort error message of the method "DeleteMediaContentByUrls"
 * This method deletes the media content from a source that contains the meta-data values of the
 * requested indexed media as follows:
 *
 * The client can specify up to three filter Tags, dependent on the type
 * of list requested.
 *
 * This method may only be called on a device that supports indexing
 * according to its 'DeviceInfo.DeviceIndexedState' property as reported by
 * either MediaPlayerDeviceConnections or ActiveMediaDevice. If
 * DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteMediaContentByUrlsAbortError;

/**
 * The error message of 'DeleteMediaContentByUrls'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteMediaContentByUrlsError;

/**
 * The abort error message of the method "EditMetaDataByMediaObjectTag"
 * This method Edit the media content of a media object as follows:
 *
 * The client can specify up to four meta data fields for the media object tag value supplied.
 *
 * This method may only be called on a device that supports indexing
 * according to its 'DeviceInfo.DeviceIndexedState' property as reported by
 * either MediaPlayerDeviceConnections or ActiveMediaDevice. If
 * DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 */
typedef ::asf::cca::CcaTypes::DefaultError EditMetaDataByMediaObjectTagAbortError;

/**
 * The error message of 'EditMetaDataByMediaObjectTag'
 */
typedef ::asf::cca::CcaTypes::DefaultError EditMetaDataByMediaObjectTagError;

/**
 * The abort error message of the method "EditMetaDataByMediaObjectUrl"
 * This method Edit the media content of a media object as follows:
 *
 * The client can specify up to four meta data fields for the media object tag value supplied.
 *
 * This method may only be called on a device that supports indexing
 * according to its 'DeviceInfo.DeviceIndexedState' property as reported by
 * either MediaPlayerDeviceConnections or ActiveMediaDevice. If
 * DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 */
typedef ::asf::cca::CcaTypes::DefaultError EditMetaDataByMediaObjectUrlAbortError;

/**
 * The error message of 'EditMetaDataByMediaObjectUrl'
 */
typedef ::asf::cca::CcaTypes::DefaultError EditMetaDataByMediaObjectUrlError;

/**
 * The start message of the method "StartRipping"
 * This method will start the ripping process if the following conditions are met.
 * The feature is enabled for the project
 * CDDA is inserted to the target
 * If ripping is in progess
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartRippingStart;

/**
 * The result message of the method "StartRipping"
 * This method will start the ripping process if the following conditions are met.
 * The feature is enabled for the project
 * CDDA is inserted to the target
 * If ripping is in progess
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartRippingResult;

/**
 * The abort error message of the method "StartRipping"
 * This method will start the ripping process if the following conditions are met.
 * The feature is enabled for the project
 * CDDA is inserted to the target
 * If ripping is in progess
 */
typedef ::asf::cca::CcaTypes::DefaultError StartRippingAbortError;

/**
 * The error message of 'StartRipping'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartRippingError;

/**
 * The start message of the method "StopRipping"
 * This method will stop the ripping process if it is already in progress.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StopRippingStart;

/**
 * The result message of the method "StopRipping"
 * This method will stop the ripping process if it is already in progress.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StopRippingResult;

/**
 * The abort error message of the method "StopRipping"
 * This method will stop the ripping process if it is already in progress.
 */
typedef ::asf::cca::CcaTypes::DefaultError StopRippingAbortError;

/**
 * The error message of 'StopRipping'
 */
typedef ::asf::cca::CcaTypes::DefaultError StopRippingError;

/**
 * The result message of the method "ExtractGracenoteMetadata"
 * This method will resolve the ambuiguity if gracenote finds more than one matching albums for a single CDID(TOC)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ExtractGracenoteMetadataResult;

/**
 * The abort error message of the method "ExtractGracenoteMetadata"
 * This method will resolve the ambuiguity if gracenote finds more than one matching albums for a single CDID(TOC)
 */
typedef ::asf::cca::CcaTypes::DefaultError ExtractGracenoteMetadataAbortError;

/**
 * The error message of 'ExtractGracenoteMetadata'
 */
typedef ::asf::cca::CcaTypes::DefaultError ExtractGracenoteMetadataError;

/**
 * The abort error message of the method "CreateInternalFileNamePlaylist"
 * This function creates an internal playlist. It expects the name of the playlist and the device tag
 * for which the playlist will contain references. If the creation of the playlist is successful,
 * the MethodResult message returns a path including the filename. This path must be used for all other playlist functions.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateInternalFileNamePlaylistAbortError;

/**
 * The error message of 'CreateInternalFileNamePlaylist'
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateInternalFileNamePlaylistError;

/**
 * The abort error message of the method "AddFilenameToInternalPlaylist"
 * Function adds multiple entries into internal playlist
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFilenameToInternalPlaylistAbortError;

/**
 * The error message of 'AddFilenameToInternalPlaylist'
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFilenameToInternalPlaylistError;

/**
 * The abort error message of the method "DeleteEntryFromPlaylist"
 * Function deletes multiple entries from an internal playlist.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteEntryFromPlaylistAbortError;

/**
 * The error message of 'DeleteEntryFromPlaylist'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteEntryFromPlaylistError;

/**
 * The abort error message of the method "RenameInternalPlaylist"
 * Renames an internal playlist
 */
typedef ::asf::cca::CcaTypes::DefaultError RenameInternalPlaylistAbortError;

/**
 * The error message of 'RenameInternalPlaylist'
 */
typedef ::asf::cca::CcaTypes::DefaultError RenameInternalPlaylistError;

/**
 * The abort error message of the method "DeleteInternalPlaylist"
 * Deletes an internal playlist
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteInternalPlaylistAbortError;

/**
 * The error message of 'DeleteInternalPlaylist'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteInternalPlaylistError;

/**
 * The abort error message of the method "CreateMediaPlayerInternalPlaylistList"
 * Creates a list of all internal playlists of a device. If the device id 0 is used all internal playlists
 * are shown. The internal playlists are shown regardless if the Devices are connected or not.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerInternalPlaylistListAbortError;

/**
 * The error message of 'CreateMediaPlayerInternalPlaylistList'
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerInternalPlaylistListError;

/**
 * The abort error message of the method "RequestMediaPlayerInternalPlaylistListSlice"
 * requests a list slice of the internal play list.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerInternalPlaylistListSliceAbortError;

/**
 * The error message of 'RequestMediaPlayerInternalPlaylistListSlice'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerInternalPlaylistListSliceError;

/**
 * The abort error message of the method "GetListPositionOfObject"
 * Request the list position of an object in a non-playing list (e.g. browse list).
 */
typedef ::asf::cca::CcaTypes::DefaultError GetListPositionOfObjectAbortError;

/**
 * The error message of 'GetListPositionOfObject'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetListPositionOfObjectError;

/**
 * The abort error message of the method "CreateMediaPlayerFileListExt"
 * This method is an extension of the method CreateMediaPlayerFileList. It expects a filename including the path to the file.
 * The directory is used to create the file list. The filename is used to identify the index of this file
 * within the directory.
 * The parameter e8FileTypeSelection can be used to qualify the content of the list.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerFileListExtAbortError;

/**
 * The error message of 'CreateMediaPlayerFileListExt'
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerFileListExtError;

/**
 * The result message of the method "StartSlideshow"
 * The StartSlideshow method is called to start a slideshow from a
 * previously created image list or filelist. The item is identified by the Tag parameter which
 * must point to an item currently in the list. Audio, video and playlist files are skipped.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartSlideshowResult;

/**
 * The abort error message of the method "StartSlideshow"
 * The StartSlideshow method is called to start a slideshow from a
 * previously created image list or filelist. The item is identified by the Tag parameter which
 * must point to an item currently in the list. Audio, video and playlist files are skipped.
 */
typedef ::asf::cca::CcaTypes::DefaultError StartSlideshowAbortError;

/**
 * The error message of 'StartSlideshow'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartSlideshowError;

/**
 * The result message of the method "RequestSlideshowAction"
 * Requests the slideshow action for the currently playing image files.
 * Slideshow actions include:
 * Previous or next track
 * Fast forward or fast reverse are ignored
 * Play, pause, or stop
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestSlideshowActionResult;

/**
 * The abort error message of the method "RequestSlideshowAction"
 * Requests the slideshow action for the currently playing image files.
 * Slideshow actions include:
 * Previous or next track
 * Fast forward or fast reverse are ignored
 * Play, pause, or stop
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestSlideshowActionAbortError;

/**
 * The error message of 'RequestSlideshowAction'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestSlideshowActionError;

/**
 * The abort error message of the method "Quicksearch"
 * Quicksearch function is used to search a string in a list and returns the position of the string in the list. If the string is not found the
 * GMP returns the following position or if the end of list is reached it returns end of list information.
 * The search start position can be defined by client.
 */
typedef ::asf::cca::CcaTypes::DefaultError QuicksearchAbortError;

/**
 * The error message of 'Quicksearch'
 */
typedef ::asf::cca::CcaTypes::DefaultError QuicksearchError;

/**
 * The abort error message of the method "EjectOpticalDisc"
 * Eject or insert optical disc
 */
typedef ::asf::cca::CcaTypes::DefaultError EjectOpticalDiscAbortError;

/**
 * The error message of 'EjectOpticalDisc'
 */
typedef ::asf::cca::CcaTypes::DefaultError EjectOpticalDiscError;

/**
 * The abort error message of the method "CreateMediaPlayerIndexedImageFolderList"
 * This method creates a list using list type, path and device tag.
 * If the list type is LTY_IMAGE_FOLDER : This method returns a handle to the created Folder list and the number of
 * folders in the list.The resulting list is a root list (i.e) without any folder/subfolder hierachy.
 * If the list type is LTY_IMAGE_FOLDER_ITEM and Folder Path is provided : This method returns a handle to the list of images in the selected folder and the number of
 * images in the Folderpath.
 * A list is considered to be valid until the ReleaseMediaPlayerList
 * function is executed.
 * If DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 * Changes to a list are reported by the MediaPlayerListChange property
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerIndexedImageFolderListAbortError;

/**
 * The error message of 'CreateMediaPlayerIndexedImageFolderList'
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerIndexedImageFolderListError;

/**
 * The abort error message of the method "RequestMediaPlayerIndexedImageFolderListSlice"
 * The RequestMediaPlayerIndexedImageFolderListSlice method provides a slice of the
 * filtered ImageFolder/Image list specified by the ListHandle parameter. The slice begins
 * with the item at location WindowStart and includes in sequential order
 * the number of items specified by the parameter WindowSize.
 * The RequestListSlice method returns the slice as a ImageObject stream.
 * If the list handle belongs to LTY_IMAGE_FOLDER, The data contained in each ImageObject is used by the HMI to determine
 * the meta-data and other properties of the Folder and First image in it .
 * If the list handle belongs to LTY_IMAGE_FOLDER_ITEM, The data contained in each ImageObject is used by the HMI to determine
 * the meta-data and other properties of the image in the folder .
 * If the number of items in the list starting at WindowStart is less than
 * the WindowSize parameter then the number of items provided in the slice
 * will be less than the WindowSize calling parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerIndexedImageFolderListSliceAbortError;

/**
 * The error message of 'RequestMediaPlayerIndexedImageFolderListSlice'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerIndexedImageFolderListSliceError;

/**
 * The abort error message of the method "CreateMediaPlayerCDList"
 * This method create a list of all supported files and folders in the "Path"
 * directory. The CreateMediaPlayerFileList function assigns a unique
 * ListHandle for each filtered list created and returns this value, as well
 * as the number of results in the filtered list. A list is considered to be
 * valid until the ReleaseMediaPlayerList function is executed. Changes to a
 * list are reported by the MediaPlayerListChange property.This
 * method also returns the total number of Files (FileType != FOLDER) and
 * Folders (FileType = Folder) in the associated List. These numbers are
 * static for each List at creation time and are included as returned
 * parameters to allow HMI controllers to configure their view accordingly
 * without requiring the controller to pull the entire list and iterate it
 * first.
 * The parameter e8FileTypeSelection can be used to qualify the content of the list.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerCDListAbortError;

/**
 * The error message of 'CreateMediaPlayerCDList'
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerCDListError;

/**
 * The abort error message of the method "RequestMediaPlayerFolderInfo"
 * This method is to Send media object with extended information as total file size,
 * total number of file, number of protected file and size of protected file.
 * This method may only be called on a device that supports indexing
 * Information will be available after IndexingState complete.
 * To get extended information for total SR device please send Path as "/"
 * To get extended information for folder "Continuous Recording" set Path as
 * "/Continuous Recording". To get correct extended information indexing should be completed.
 * otherwise indexComplete values is false.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerFolderInfoAbortError;

/**
 * The error message of 'RequestMediaPlayerFolderInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerFolderInfoError;

/**
 * The abort error message of the method "SetFilePermissionByMediaObjectTags"
 * This method set the file permission for the media content from a source that contains the meta-data values of the
 * requested indexed media as follows:
 *
 * This method may only be called on a device that supports indexing
 * according to its 'DeviceInfo.DeviceIndexedState' property as reported by
 * either MediaPlayerDeviceConnections or ActiveMediaDevice. If
 * DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 * Changes to a list are reported by the MediaPlayerListChange property.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFilePermissionByMediaObjectTagsAbortError;

/**
 * The error message of 'SetFilePermissionByMediaObjectTags'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFilePermissionByMediaObjectTagsError;

/**
 * The abort error message of the method "AddFilenameToInternalPlaylistByTags"
 * Function adds multiple entries into internal playlist if the HMI supplies filter tags.
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFilenameToInternalPlaylistByTagsAbortError;

/**
 * The error message of 'AddFilenameToInternalPlaylistByTags'
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFilenameToInternalPlaylistByTagsError;

/**
 * The abort error message of the method "StorePersonalizedFavorite"
 * The StorePersonalizedFavorite function stores in persistent memory recall
 * information for the object identified by the ObjectID. This favorite would be specific to a user.
 * The recall information stored enables the following actions to be performed at a
 * later time:
 * Recall the favorite using a favorites list
 * The StorePersonalizedFavorite function assigns a locally-unique FavoriteID to the
 * new favorite. This FavoriteID and recall information are bound and
 * stored in persistent memory.
 */
typedef ::asf::cca::CcaTypes::DefaultError StorePersonalizedFavoriteAbortError;

/**
 * The error message of 'StorePersonalizedFavorite'
 */
typedef ::asf::cca::CcaTypes::DefaultError StorePersonalizedFavoriteError;

/**
 * The abort error message of the method "DeletePersonalizedFavorite"
 * The DeletePersonalizedFavorite function deletes the Favorites from the favorites list.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeletePersonalizedFavoriteAbortError;

/**
 * The error message of 'DeletePersonalizedFavorite'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeletePersonalizedFavoriteError;

/**
 * The abort error message of the method "CreateMediaPlayerGlobalSearchList"
 * <p>GLOBAL SEARCH:</p>
 * <p>This FI supports global search of contents present in the entire device which has the searchString in their title/name. It can either be indexed content search or Folder content search.</p>
 * <p></p>
 * <p>Search type parameter is the primary key to differentiate the type of search.
 * If its GLOBAL_SEARCH_AUDIO_INDEXED then all the indexed audio data of the device identified using the device tag will be searched.
 * If its GLOBAL_SEARCH_AUDIO_FOLDER / GLOBAL_SEARCH_VIDEO_FOLDER  then all the folders and files which are children of the current folder and will be searched for the audio/video content.</p>
 * <p></p>
 * <p>u32ListHandleOfParent - Parent list handle for the search. For folder search , this links to the parent folder where search has to happen. If it is 0 for Folder search, entire device will be searched. For indexed list this must be 0</p>
 * <p></p>
 * <p>u32ListHandleOfReplaceableList - ListID of previous search request. If it has a valid listID, corresponding list will be released as the previous search list is not valid anymore</p>
 * <p>Example Scenario: User types in first character then this Method CreateIndexListWithSearchString() is used with Method RequestListSize()
 * to show results. It e.g. return 'ListHandle1' If the user types in an additional character CreateIndexListWithSearchString()is called to get another list but with
 * parameter u32ListHandleOfReplaceableList=ListHandle1. The first list then gets obsolete/deleted.</p>
 * <p></p>
 * <p>Result of the search:</p>
 * <p>This method returns a handle to the created search list and the number of objects in the list.
 * A list is considered to be valid until the u32ListHandleOfReplaceableList is sent via the same FI or till ReleaseMediaPlayerList method is executed.
 * Changes to a list are reported by the MediaPlayerListChange property.</p>
 * <p></p>
 * <p>For Processing Further:</p>
 * <p>This list can be sliced to obtain the media objects as a result of this search. MediaObjects will be in the order: Albums, Artists, Songs, Playlists, Podcasts, Genres, Composers, Audiobooks
 * The media objects obtained through list slice has fields for Category and media type which is to be used for displaying the category of the searched content.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerGlobalSearchListAbortError;

/**
 * The error message of 'CreateMediaPlayerGlobalSearchList'
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerGlobalSearchListError;

/**
 * The abort error message of the method "CreateMediaPlayerAlbumArtList"
 * This method creates a new list that contains unique albumart urls related to the given ListID.
 *
 * This method returns a handle to the created list and the number of unique albumart
 * urls in the list.
 *
 * One albumart url contains the extracted and resized(if applicable) albumart of an album in the device.It is an url available in the coverart partition in RFS(root filesystem) of target hardware.
 * Albumart is extracted from anyone of the album's track.Once the albumart url is created,it is valid until the album exist in the device.
 * i.e any change(e.g editing metadata) of the tracks of album or adding track to the album or removing track from the album do not affect the albumart url.
 *
 * If given ListID is metadata browse list,then the ListSize is the number of unique albumart urls under that list.
 * e.g If given ListID is of ListType LTY_GENRE_ARTIST,then the newly created albumart list will have unique albumart of albums
 * under the browsed genre.
 *
 * If given ListID is file browse list,then the ListSize is the number of unique albumart urls in that list.
 * e.g If given ListID is of ListType LTY_FILELIST and FileTypeSelection FTS_AUDIO_PLAYLIST,then the newly created albumart list will have unique albumarts
 * found from the audio files in the current browsed path.
 *
 *
 * This method shall be called only for mass storage devices in connected state and when CoverArt Indexing is enabled
 * for such devices.
 *
 * A list is considered to be valid until the ReleaseMediaPlayerList
 * method is called for that list handle.
 *
 * Changes to the list are reported by the MediaPlayerListChange property.
 *
 * NOTE:This interface is supported only for USB Mass storage class Devices.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerAlbumArtListAbortError;

/**
 * The error message of 'CreateMediaPlayerAlbumArtList'
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMediaPlayerAlbumArtListError;

/**
 * The abort error message of the method "RequestMediaPlayerAlbumArtListSlice"
 * The RequestMediaPlayerAlbumArtListSlice method provides items at the requested
 * indices of the list.
 *
 * This method shall be called only for the albumart listID received in result of method call CreateMediaPlayerAlbumArtList.
 *
 * This method returns the albumart urls in the requested range of Indices or requested Indices.
 *
 * An albumart url refers to an image file in .png format available in the coverart partition in root filesystem of target hardware.This image file contains the resized(if applicable) albumart
 * of an album in the device.
 * The client shall read the albumarts from the albumart urls and resize them if needed.
 *
 * Default pixel width x height of a .png file(i.e albumart url) stored is 280 x 280. This value shall be configured by Mediaplayer as per project requirement.
 * This configuration shall be used by mediaplayer for resizing the original albumart and storing them as png files.
 * During such resizing, Storage Aspect Ratio (SAR) of the albumart is preserved.
 *
 * Mediaplayer supports only downscaling of original albumart to the configured width and height.
 * Hence,if original albumart's width is less than configuration,Mediaplayer donot upscale.Instead albumart with original width is stored.
 * Also,if original albumart's height is less than configuration,Mediaplayer donot upscale.Instead albumart with original height is stored.
 *
 * NOTE:This interface is supported only for USB Mass storage class Devices.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerAlbumArtListSliceAbortError;

/**
 * The error message of 'RequestMediaPlayerAlbumArtListSlice'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMediaPlayerAlbumArtListSliceError;

/**
 * The abort error message of the method "SendAppleHIDCommand"
 * Request to send the "Media Playback Remote" HID command to the connected Apple device via iAP2.
 * The HID commands include HID usages for Playback action, Random, Repeat modes and Voice command (Siri).
 * Play, Pause
 * ScanNextTrack, ScanPreviousTrack.
 * When ScanNextTrack is presses and released immediately (Apple defined time out), Next Track is selected by the device.
 * When ScanNextTrack is pressed and held (Apple defined time out), Apple device will perform Fast Forward until button is released.
 * Similarly for ScanPreviousTrack, Previous track or Fast Reverse is performed by Apple device based on press and release time gap.
 * Random, Repeat
 * VoiceCommand (Siri)
 * Mute
 */
typedef ::asf::cca::CcaTypes::DefaultError SendAppleHIDCommandAbortError;

/**
 * The error message of 'SendAppleHIDCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendAppleHIDCommandError;

/**
 * The abort error message of the method "RequestBluetoothAudioDevice"
 * Method to request or release BT audio device
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestBluetoothAudioDeviceAbortError;

/**
 * The error message of 'RequestBluetoothAudioDevice'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestBluetoothAudioDeviceError;


/**
 * The status message of the property "MediaPlayerListChange"
 * The MediaPlayerListChange property provides notifications about changes
 * that occur in a created list.
 * These changes include:
 * Insertion of a new item into the list.
 * Removal of an item from the list.
 * A change in meta-data for an item in the list
 * A change of the PlaybackState of an item in the list (IsPlaying parameter)
 */
class MediaPlayerListChangeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaPlayerListChangeStatus ();

    /**
     * Copy constructor
     */
    inline  MediaPlayerListChangeStatus (const MediaPlayerListChangeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MediaPlayerListChangeStatus (uint32 u32ListHandle_, ::MPlay_fi_types::T_e8_MPlayChange e8Change_, uint32 u32ListSize_, const ::MPlay_fi_types::T_MPlayItems& oItems_);

    /**
     * Destructor
     */
    inline virtual  ~MediaPlayerListChangeStatus();

    /**
     * Assignment operator
     */
    inline MediaPlayerListChangeStatus& operator = (const MediaPlayerListChangeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaPlayerListChangeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaPlayerListChangeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaPlayerListChangeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaPlayerListChangeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "e8Change"

    static const int kE8Change = 1;

    /**
     * Clears the field "e8Change".
     *
     * The field will be set to its default value. The hasE8Change()
     * method will return false.
     */
    inline void clearE8Change();

    /**
     * Checks whether the field "e8Change" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Change()). Otherwise it will return false.
     */
    inline bool hasE8Change () const;

    /**
     * Returns the value of the member "e8Change".
     *
     * Contains the type of change.
     *
     * @return The value of the field "e8Change"
     */
    inline ::MPlay_fi_types::T_e8_MPlayChange getE8Change () const;

    /**
     * Sets the value of the member "e8Change".
     *
     * Contains the type of change.
     *
     * @param e8Change The value which will be set
     */
    inline void setE8Change (::MPlay_fi_types::T_e8_MPlayChange e8Change_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 2;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    // API of field "oItems"

    static const int kOItems = 3;

    /**
     * Clears the field "oItems".
     *
     * The field will be set to its default value. The hasOItems()
     * method will return false.
     */
    inline void clearOItems();

    /**
     * Checks whether the field "oItems" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOItems()). Otherwise it will return false.
     */
    inline bool hasOItems () const;

    /**
     * Returns the value of the member "oItems".
     *
     * Positions of the items that have been added, removed or changed. This stream is empty in case the kind of change is 'ContentChanged'.
     *
     * @return The value of the field "oItems"
     */
    inline const ::MPlay_fi_types::T_MPlayItems& getOItems () const;

    /**
     * Retrieves the value of the field "oItems" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oItems".
     */
    inline ::MPlay_fi_types::T_MPlayItems& getOItemsMutable ();

    /**
     * Sets the value of the member "oItems".
     *
     * Positions of the items that have been added, removed or changed. This stream is empty in case the kind of change is 'ContentChanged'.
     *
     * @param oItems The value which will be set
     */
    inline void setOItems (const ::MPlay_fi_types::T_MPlayItems& oItems_);

    static const MediaPlayerListChangeStatus &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_e8Change ();

    inline void clear_has_e8Change ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    inline void set_has_oItems ();

    inline void clear_has_oItems ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _u32ListHandle;

    ::MPlay_fi_types::T_e8_MPlayChange _e8Change;

    uint32 _u32ListSize;

    ::MPlay_fi_types::T_MPlayItems _oItems;

};

/**
 * The status message of the property "NowPlaying"
 * This property identifies all information about the currently playing item:
 * ListHandle of the active playlist.
 * Position within the list of the active item
 * The Tag value of the active item
 * Metadata for the active item
 * Tree of ListHandles from the root list down to the ListHandle of the
 * active playlist. This tree is used to restore the list hierarchy
 * relationships at initialization (internally saved by MediaPlayer).
 * This information is used to determine the item that is currently being
 * played. The information returned by the NowPlaying function can be used
 * with the RequestMediaPlayerPlaylistListSlice function to obtain all
 * meta-data information for the active item.
 */
class NowPlayingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NowPlayingStatus ();

    /**
     * Copy constructor
     */
    inline  NowPlayingStatus (const NowPlayingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NowPlayingStatus (uint32 u32ListHandle_, ::MPlay_fi_types::T_e8_MPlayNowPlayingState e8NowPlayingState_, uint32 u32Position_, uint32 u32Tag_, const ::MPlay_fi_types::T_MPlayMediaObject& oMediaObject_);

    /**
     * Destructor
     */
    inline virtual  ~NowPlayingStatus();

    /**
     * Assignment operator
     */
    inline NowPlayingStatus& operator = (const NowPlayingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NowPlayingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NowPlayingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NowPlayingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NowPlayingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "e8NowPlayingState"

    static const int kE8NowPlayingState = 1;

    /**
     * Clears the field "e8NowPlayingState".
     *
     * The field will be set to its default value. The hasE8NowPlayingState()
     * method will return false.
     */
    inline void clearE8NowPlayingState();

    /**
     * Checks whether the field "e8NowPlayingState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8NowPlayingState()). Otherwise it will return false.
     */
    inline bool hasE8NowPlayingState () const;

    /**
     * Returns the value of the member "e8NowPlayingState".
     *
     * Describes the state of the active playlist upon transitions between items in the list.
     *
     * @return The value of the field "e8NowPlayingState"
     */
    inline ::MPlay_fi_types::T_e8_MPlayNowPlayingState getE8NowPlayingState () const;

    /**
     * Sets the value of the member "e8NowPlayingState".
     *
     * Describes the state of the active playlist upon transitions between items in the list.
     *
     * @param e8NowPlayingState The value which will be set
     */
    inline void setE8NowPlayingState (::MPlay_fi_types::T_e8_MPlayNowPlayingState e8NowPlayingState_);

    // API of field "u32Position"

    static const int kU32Position = 2;

    /**
     * Clears the field "u32Position".
     *
     * The field will be set to its default value. The hasU32Position()
     * method will return false.
     */
    inline void clearU32Position();

    /**
     * Checks whether the field "u32Position" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Position()). Otherwise it will return false.
     */
    inline bool hasU32Position () const;

    /**
     * Returns the value of the member "u32Position".
     *
     * Contains the position (or index) of the item within the specified list starting at 0 for the first element in the list.
     *
     * @return The value of the field "u32Position"
     */
    inline uint32 getU32Position () const;

    /**
     * Sets the value of the member "u32Position".
     *
     * Contains the position (or index) of the item within the specified list starting at 0 for the first element in the list.
     *
     * @param u32Position The value which will be set
     */
    inline void setU32Position (uint32 u32Position_);

    // API of field "u32Tag"

    static const int kU32Tag = 3;

    /**
     * Clears the field "u32Tag".
     *
     * The field will be set to its default value. The hasU32Tag()
     * method will return false.
     */
    inline void clearU32Tag();

    /**
     * Checks whether the field "u32Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Tag()). Otherwise it will return false.
     */
    inline bool hasU32Tag () const;

    /**
     * Returns the value of the member "u32Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value
     * identifies the media object to play.
     *
     * @return The value of the field "u32Tag"
     */
    inline uint32 getU32Tag () const;

    /**
     * Sets the value of the member "u32Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value
     * identifies the media object to play.
     *
     * @param u32Tag The value which will be set
     */
    inline void setU32Tag (uint32 u32Tag_);

    // API of field "oMediaObject"

    static const int kOMediaObject = 4;

    /**
     * Clears the field "oMediaObject".
     *
     * The field will be set to its default value. The hasOMediaObject()
     * method will return false.
     */
    inline void clearOMediaObject();

    /**
     * Checks whether the field "oMediaObject" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMediaObject()). Otherwise it will return false.
     */
    inline bool hasOMediaObject () const;

    /**
     * Returns the value of the member "oMediaObject".
     *
     * All information necessary to retrieve and play a given media object, including all meta-data for that object
     *
     * @return The value of the field "oMediaObject"
     */
    inline const ::MPlay_fi_types::T_MPlayMediaObject& getOMediaObject () const;

    /**
     * Retrieves the value of the field "oMediaObject" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMediaObject".
     */
    inline ::MPlay_fi_types::T_MPlayMediaObject& getOMediaObjectMutable ();

    /**
     * Sets the value of the member "oMediaObject".
     *
     * All information necessary to retrieve and play a given media object, including all meta-data for that object
     *
     * @param oMediaObject The value which will be set
     */
    inline void setOMediaObject (const ::MPlay_fi_types::T_MPlayMediaObject& oMediaObject_);

    static const NowPlayingStatus &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_e8NowPlayingState ();

    inline void clear_has_e8NowPlayingState ();

    inline void set_has_u32Position ();

    inline void clear_has_u32Position ();

    inline void set_has_u32Tag ();

    inline void clear_has_u32Tag ();

    inline void set_has_oMediaObject ();

    inline void clear_has_oMediaObject ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _u32ListHandle;

    ::MPlay_fi_types::T_e8_MPlayNowPlayingState _e8NowPlayingState;

    uint32 _u32Position;

    uint32 _u32Tag;

    ::MPlay_fi_types::T_MPlayMediaObject _oMediaObject;

};

/**
 * The status message of the property "Playtime"
 * Identifies the amount of time elapsed and total duration of a media object.  Resolution is in seconds.  The MediaPlayer shall send out updates to registered HMI controllers upon each 1 second change.
 */
class PlaytimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlaytimeStatus ();

    /**
     * Copy constructor
     */
    inline  PlaytimeStatus (const PlaytimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PlaytimeStatus (uint32 u32ElapsedPlaytime_, uint32 u32TotalPlaytime_, uint32 u32Tag_);

    /**
     * Destructor
     */
    inline virtual  ~PlaytimeStatus();

    /**
     * Assignment operator
     */
    inline PlaytimeStatus& operator = (const PlaytimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlaytimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlaytimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlaytimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlaytimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ElapsedPlaytime"

    static const int kU32ElapsedPlaytime = 0;

    /**
     * Clears the field "u32ElapsedPlaytime".
     *
     * The field will be set to its default value. The hasU32ElapsedPlaytime()
     * method will return false.
     */
    inline void clearU32ElapsedPlaytime();

    /**
     * Checks whether the field "u32ElapsedPlaytime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ElapsedPlaytime()). Otherwise it will return false.
     */
    inline bool hasU32ElapsedPlaytime () const;

    /**
     * Returns the value of the member "u32ElapsedPlaytime".
     *
     * Contains the elapsed playtime of the currently playing media file in seconds.
     *
     * @return The value of the field "u32ElapsedPlaytime"
     */
    inline uint32 getU32ElapsedPlaytime () const;

    /**
     * Sets the value of the member "u32ElapsedPlaytime".
     *
     * Contains the elapsed playtime of the currently playing media file in seconds.
     *
     * @param u32ElapsedPlaytime The value which will be set
     */
    inline void setU32ElapsedPlaytime (uint32 u32ElapsedPlaytime_);

    // API of field "u32TotalPlaytime"

    static const int kU32TotalPlaytime = 1;

    /**
     * Clears the field "u32TotalPlaytime".
     *
     * The field will be set to its default value. The hasU32TotalPlaytime()
     * method will return false.
     */
    inline void clearU32TotalPlaytime();

    /**
     * Checks whether the field "u32TotalPlaytime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TotalPlaytime()). Otherwise it will return false.
     */
    inline bool hasU32TotalPlaytime () const;

    /**
     * Returns the value of the member "u32TotalPlaytime".
     *
     * Total playtime of the media object in seconds.
     *
     * @return The value of the field "u32TotalPlaytime"
     */
    inline uint32 getU32TotalPlaytime () const;

    /**
     * Sets the value of the member "u32TotalPlaytime".
     *
     * Total playtime of the media object in seconds.
     *
     * @param u32TotalPlaytime The value which will be set
     */
    inline void setU32TotalPlaytime (uint32 u32TotalPlaytime_);

    // API of field "u32Tag"

    static const int kU32Tag = 2;

    /**
     * Clears the field "u32Tag".
     *
     * The field will be set to its default value. The hasU32Tag()
     * method will return false.
     */
    inline void clearU32Tag();

    /**
     * Checks whether the field "u32Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Tag()). Otherwise it will return false.
     */
    inline bool hasU32Tag () const;

    /**
     * Returns the value of the member "u32Tag".
     *
     * The Tag value identifies the media object to which the param1 and param2 correspond to.
     * Note:objectID is reliable only for Mass Storage devices and MTP Devices
     *
     * @return The value of the field "u32Tag"
     */
    inline uint32 getU32Tag () const;

    /**
     * Sets the value of the member "u32Tag".
     *
     * The Tag value identifies the media object to which the param1 and param2 correspond to.
     * Note:objectID is reliable only for Mass Storage devices and MTP Devices
     *
     * @param u32Tag The value which will be set
     */
    inline void setU32Tag (uint32 u32Tag_);

    static const PlaytimeStatus &getDefaultInstance();

private:

    inline void set_has_u32ElapsedPlaytime ();

    inline void clear_has_u32ElapsedPlaytime ();

    inline void set_has_u32TotalPlaytime ();

    inline void clear_has_u32TotalPlaytime ();

    inline void set_has_u32Tag ();

    inline void clear_has_u32Tag ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32ElapsedPlaytime;

    uint32 _u32TotalPlaytime;

    uint32 _u32Tag;

};

/**
 * The status message of the property "PlaybackState"
 * The current playback state of the MediaPlayer
 * PBS_PLAYING: The Media Player is actively playing a media object. The
 * object being played can be obtained using the NowPlaying function
 * PBS_PAUSED: The Media Player is not actively playing a media object.
 * The item to queued to play can be obtained using the NowPlaying
 * function
 * PBS_STOPPED: The Media Player has stopped playback. The NowPlaying
 * function does not return an item
 * PBS_FFWD: The Media Player is fast forwarding.
 * PBS_FRWD: The Media Player is fast reversing.
 */
class PlaybackStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlaybackStateStatus ();

    /**
     * Copy constructor
     */
    inline  PlaybackStateStatus (const PlaybackStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PlaybackStateStatus (::MPlay_fi_types::T_e8_MPlayState e8State_);

    /**
     * Destructor
     */
    inline virtual  ~PlaybackStateStatus();

    /**
     * Assignment operator
     */
    inline PlaybackStateStatus& operator = (const PlaybackStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlaybackStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlaybackStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlaybackStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlaybackStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8State"

    static const int kE8State = 0;

    /**
     * Clears the field "e8State".
     *
     * The field will be set to its default value. The hasE8State()
     * method will return false.
     */
    inline void clearE8State();

    /**
     * Checks whether the field "e8State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8State()). Otherwise it will return false.
     */
    inline bool hasE8State () const;

    /**
     * Returns the value of the member "e8State".
     *
     * Playback state of the Media Player
     *
     * @return The value of the field "e8State"
     */
    inline ::MPlay_fi_types::T_e8_MPlayState getE8State () const;

    /**
     * Sets the value of the member "e8State".
     *
     * Playback state of the Media Player
     *
     * @param e8State The value which will be set
     */
    inline void setE8State (::MPlay_fi_types::T_e8_MPlayState e8State_);

    static const PlaybackStateStatus &getDefaultInstance();

private:

    inline void set_has_e8State ();

    inline void clear_has_e8State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayState _e8State;

};

/**
 * The status message of the property "PlaybackMode"
 * The current playback mode of the media player instance:
 * Normal: Navigate through the active playlist sequentially
 * Random: Enable shuffle mode by playing items in the active playlist in
 * a random order
 */
class PlaybackModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlaybackModeStatus ();

    /**
     * Copy constructor
     */
    inline  PlaybackModeStatus (const PlaybackModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PlaybackModeStatus (::MPlay_fi_types::T_e8_MPlayMode e8Mode_);

    /**
     * Destructor
     */
    inline virtual  ~PlaybackModeStatus();

    /**
     * Assignment operator
     */
    inline PlaybackModeStatus& operator = (const PlaybackModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlaybackModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlaybackModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlaybackModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlaybackModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Mode"

    static const int kE8Mode = 0;

    /**
     * Clears the field "e8Mode".
     *
     * The field will be set to its default value. The hasE8Mode()
     * method will return false.
     */
    inline void clearE8Mode();

    /**
     * Checks whether the field "e8Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Mode()). Otherwise it will return false.
     */
    inline bool hasE8Mode () const;

    /**
     * Returns the value of the member "e8Mode".
     *
     * Contains the current playback mode, which defines how the MediaPlayer determines the next media object to play.
     *
     * @return The value of the field "e8Mode"
     */
    inline ::MPlay_fi_types::T_e8_MPlayMode getE8Mode () const;

    /**
     * Sets the value of the member "e8Mode".
     *
     * Contains the current playback mode, which defines how the MediaPlayer determines the next media object to play.
     *
     * @param e8Mode The value which will be set
     */
    inline void setE8Mode (::MPlay_fi_types::T_e8_MPlayMode e8Mode_);

    static const PlaybackModeStatus &getDefaultInstance();

private:

    inline void set_has_e8Mode ();

    inline void clear_has_e8Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayMode _e8Mode;

};

/**
 * The set message of the property "PlaybackMode"
 * The current playback mode of the media player instance:
 * Normal: Navigate through the active playlist sequentially
 * Random: Enable shuffle mode by playing items in the active playlist in
 * a random order
 */
class PlaybackModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlaybackModeSet ();

    /**
     * Copy constructor
     */
    inline  PlaybackModeSet (const PlaybackModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  PlaybackModeSet (::MPlay_fi_types::T_e8_MPlayMode e8Mode_);

    /**
     * Destructor
     */
    inline virtual  ~PlaybackModeSet();

    /**
     * Assignment operator
     */
    inline PlaybackModeSet& operator = (const PlaybackModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlaybackModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlaybackModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlaybackModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlaybackModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Mode"

    static const int kE8Mode = 0;

    /**
     * Clears the field "e8Mode".
     *
     * The field will be set to its default value. The hasE8Mode()
     * method will return false.
     */
    inline void clearE8Mode();

    /**
     * Checks whether the field "e8Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Mode()). Otherwise it will return false.
     */
    inline bool hasE8Mode () const;

    /**
     * Returns the value of the member "e8Mode".
     *
     * Contains the current playback mode, which defines how the MediaPlayer determines the next media object to play.
     *
     * @return The value of the field "e8Mode"
     */
    inline ::MPlay_fi_types::T_e8_MPlayMode getE8Mode () const;

    /**
     * Sets the value of the member "e8Mode".
     *
     * Contains the current playback mode, which defines how the MediaPlayer determines the next media object to play.
     *
     * @param e8Mode The value which will be set
     */
    inline void setE8Mode (::MPlay_fi_types::T_e8_MPlayMode e8Mode_);

    static const PlaybackModeSet &getDefaultInstance();

private:

    inline void set_has_e8Mode ();

    inline void clear_has_e8Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayMode _e8Mode;

};

/**
 * The status message of the property "RepeatMode"
 * The current repeat setting of the media player instance
 */
class RepeatModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RepeatModeStatus ();

    /**
     * Copy constructor
     */
    inline  RepeatModeStatus (const RepeatModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RepeatModeStatus (::MPlay_fi_types::T_e8_MPlayRepeat e8Repeat_);

    /**
     * Destructor
     */
    inline virtual  ~RepeatModeStatus();

    /**
     * Assignment operator
     */
    inline RepeatModeStatus& operator = (const RepeatModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RepeatModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RepeatModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RepeatModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RepeatModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Repeat"

    static const int kE8Repeat = 0;

    /**
     * Clears the field "e8Repeat".
     *
     * The field will be set to its default value. The hasE8Repeat()
     * method will return false.
     */
    inline void clearE8Repeat();

    /**
     * Checks whether the field "e8Repeat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Repeat()). Otherwise it will return false.
     */
    inline bool hasE8Repeat () const;

    /**
     * Returns the value of the member "e8Repeat".
     *
     *
     *
     * @return The value of the field "e8Repeat"
     */
    inline ::MPlay_fi_types::T_e8_MPlayRepeat getE8Repeat () const;

    /**
     * Sets the value of the member "e8Repeat".
     *
     *
     *
     * @param e8Repeat The value which will be set
     */
    inline void setE8Repeat (::MPlay_fi_types::T_e8_MPlayRepeat e8Repeat_);

    static const RepeatModeStatus &getDefaultInstance();

private:

    inline void set_has_e8Repeat ();

    inline void clear_has_e8Repeat ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayRepeat _e8Repeat;

};

/**
 * The set message of the property "RepeatMode"
 * The current repeat setting of the media player instance
 */
class RepeatModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RepeatModeSet ();

    /**
     * Copy constructor
     */
    inline  RepeatModeSet (const RepeatModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  RepeatModeSet (::MPlay_fi_types::T_e8_MPlayRepeat e8Repeat_);

    /**
     * Destructor
     */
    inline virtual  ~RepeatModeSet();

    /**
     * Assignment operator
     */
    inline RepeatModeSet& operator = (const RepeatModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RepeatModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RepeatModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RepeatModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RepeatModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Repeat"

    static const int kE8Repeat = 0;

    /**
     * Clears the field "e8Repeat".
     *
     * The field will be set to its default value. The hasE8Repeat()
     * method will return false.
     */
    inline void clearE8Repeat();

    /**
     * Checks whether the field "e8Repeat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Repeat()). Otherwise it will return false.
     */
    inline bool hasE8Repeat () const;

    /**
     * Returns the value of the member "e8Repeat".
     *
     *
     *
     * @return The value of the field "e8Repeat"
     */
    inline ::MPlay_fi_types::T_e8_MPlayRepeat getE8Repeat () const;

    /**
     * Sets the value of the member "e8Repeat".
     *
     *
     *
     * @param e8Repeat The value which will be set
     */
    inline void setE8Repeat (::MPlay_fi_types::T_e8_MPlayRepeat e8Repeat_);

    static const RepeatModeSet &getDefaultInstance();

private:

    inline void set_has_e8Repeat ();

    inline void clear_has_e8Repeat ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayRepeat _e8Repeat;

};

/**
 * The status message of the property "IndexingState"
 * The IndexingState property indicates the status of the indexing operation for a connected device.  The Get operation triggers a Status response with a Stream list of the indexing state of all currently connected devices.  A change in indexing on one or more devices is sent as a Status response for just the device(s) that changed.
 */
class IndexingStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IndexingStateStatus ();

    /**
     * Copy constructor
     */
    inline  IndexingStateStatus (const IndexingStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IndexingStateStatus (const ::MPlay_fi_types::T_MPlayIndexingStateResult& oIndexingStateResult_);

    /**
     * Destructor
     */
    inline virtual  ~IndexingStateStatus();

    /**
     * Assignment operator
     */
    inline IndexingStateStatus& operator = (const IndexingStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IndexingStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IndexingStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IndexingStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IndexingStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oIndexingStateResult"

    static const int kOIndexingStateResult = 0;

    /**
     * Clears the field "oIndexingStateResult".
     *
     * The field will be set to its default value. The hasOIndexingStateResult()
     * method will return false.
     */
    inline void clearOIndexingStateResult();

    /**
     * Checks whether the field "oIndexingStateResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOIndexingStateResult()). Otherwise it will return false.
     */
    inline bool hasOIndexingStateResult () const;

    /**
     * Returns the value of the member "oIndexingStateResult".
     *
     * Stream for list of DeviceTag vs. DeviceIndexedState
     *
     * @return The value of the field "oIndexingStateResult"
     */
    inline const ::MPlay_fi_types::T_MPlayIndexingStateResult& getOIndexingStateResult () const;

    /**
     * Retrieves the value of the field "oIndexingStateResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oIndexingStateResult".
     */
    inline ::MPlay_fi_types::T_MPlayIndexingStateResult& getOIndexingStateResultMutable ();

    /**
     * Sets the value of the member "oIndexingStateResult".
     *
     * Stream for list of DeviceTag vs. DeviceIndexedState
     *
     * @param oIndexingStateResult The value which will be set
     */
    inline void setOIndexingStateResult (const ::MPlay_fi_types::T_MPlayIndexingStateResult& oIndexingStateResult_);

    static const IndexingStateStatus &getDefaultInstance();

private:

    static const ::std::vector< ::MPlay_fi_types::T_MPlayIndexingStateResultItem >& getT_MPlayIndexingStateResultItemList_DefaultInstance ();

    inline void set_has_oIndexingStateResult ();

    inline void clear_has_oIndexingStateResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_MPlayIndexingStateResult _oIndexingStateResult;

};

/**
 * The status message of the property "MediaPlayerDeviceConnections"
 * Provides notification of the number of devices connected that support media playback.  For each connected device, this property provides specific information about the device.
 */
class MediaPlayerDeviceConnectionsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaPlayerDeviceConnectionsStatus ();

    /**
     * Copy constructor
     */
    inline  MediaPlayerDeviceConnectionsStatus (const MediaPlayerDeviceConnectionsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MediaPlayerDeviceConnectionsStatus (const ::MPlay_fi_types::T_MPlayDeviceInfo& oDeviceInfo_);

    /**
     * Destructor
     */
    inline virtual  ~MediaPlayerDeviceConnectionsStatus();

    /**
     * Assignment operator
     */
    inline MediaPlayerDeviceConnectionsStatus& operator = (const MediaPlayerDeviceConnectionsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaPlayerDeviceConnectionsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaPlayerDeviceConnectionsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaPlayerDeviceConnectionsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaPlayerDeviceConnectionsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oDeviceInfo"

    static const int kODeviceInfo = 0;

    /**
     * Clears the field "oDeviceInfo".
     *
     * The field will be set to its default value. The hasODeviceInfo()
     * method will return false.
     */
    inline void clearODeviceInfo();

    /**
     * Checks whether the field "oDeviceInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceInfo()). Otherwise it will return false.
     */
    inline bool hasODeviceInfo () const;

    /**
     * Returns the value of the member "oDeviceInfo".
     *
     * Specific information about the connected devices.
     *
     * @return The value of the field "oDeviceInfo"
     */
    inline const ::MPlay_fi_types::T_MPlayDeviceInfo& getODeviceInfo () const;

    /**
     * Retrieves the value of the field "oDeviceInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceInfo".
     */
    inline ::MPlay_fi_types::T_MPlayDeviceInfo& getODeviceInfoMutable ();

    /**
     * Sets the value of the member "oDeviceInfo".
     *
     * Specific information about the connected devices.
     *
     * @param oDeviceInfo The value which will be set
     */
    inline void setODeviceInfo (const ::MPlay_fi_types::T_MPlayDeviceInfo& oDeviceInfo_);

    static const MediaPlayerDeviceConnectionsStatus &getDefaultInstance();

private:

    static const ::std::vector< ::MPlay_fi_types::T_MPlayDeviceInfoItem >& getT_MPlayDeviceInfoItemList_DefaultInstance ();

    inline void set_has_oDeviceInfo ();

    inline void clear_has_oDeviceInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_MPlayDeviceInfo _oDeviceInfo;

};

/**
 * The status message of the property "ActiveMediaDevice"
 * Identifies the media device that is currently sourced. The DeviceTag of
 * 0x00 is reserved as the "My Media" device. When this tag is the
 * ActiveMediaSource, the user is presented with an indexed library of
 * aggregated media from all connected devices with DeviceIndexedStates of
 * IDS_PARTIAL and IDS_COMPLETE.This function is used to set an
 * active media source by DeviceTag. This function can also be used to
 * retrieve the DeviceTag and DeviceInfo of the active media source.Note
 * that the DeviceIndexedState field within the DeviceInfo stream can be used
 * by HMI controllers to determine whether or not the device supports
 * indexing or not. For a device that does not support indexing, only the
 * file and playlist-based functions may be used.
 */
class ActiveMediaDeviceStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveMediaDeviceStatus ();

    /**
     * Copy constructor
     */
    inline  ActiveMediaDeviceStatus (const ActiveMediaDeviceStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveMediaDeviceStatus (uint8 u8DeviceTag_, bool bDeviceActiveSource_, bool bScanSupported_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveMediaDeviceStatus();

    /**
     * Assignment operator
     */
    inline ActiveMediaDeviceStatus& operator = (const ActiveMediaDeviceStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveMediaDeviceStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveMediaDeviceStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveMediaDeviceStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveMediaDeviceStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "bDeviceActiveSource"

    static const int kBDeviceActiveSource = 1;

    /**
     * Clears the field "bDeviceActiveSource".
     *
     * The field will be set to its default value. The hasBDeviceActiveSource()
     * method will return false.
     */
    inline void clearBDeviceActiveSource();

    /**
     * Checks whether the field "bDeviceActiveSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDeviceActiveSource()). Otherwise it will return false.
     */
    inline bool hasBDeviceActiveSource () const;

    /**
     * Returns the value of the member "bDeviceActiveSource".
     *
     * Identifies whether a connected device is the active media source.  The value is "True" if the device is the active media source and the value is "False" if the device is not the active media source.
     *
     * @return The value of the field "bDeviceActiveSource"
     */
    inline bool getBDeviceActiveSource () const;

    /**
     * Sets the value of the member "bDeviceActiveSource".
     *
     * Identifies whether a connected device is the active media source.  The value is "True" if the device is the active media source and the value is "False" if the device is not the active media source.
     *
     * @param bDeviceActiveSource The value which will be set
     */
    inline void setBDeviceActiveSource (bool bDeviceActiveSource_);

    // API of field "bScanSupported"

    static const int kBScanSupported = 2;

    /**
     * Clears the field "bScanSupported".
     *
     * The field will be set to its default value. The hasBScanSupported()
     * method will return false.
     */
    inline void clearBScanSupported();

    /**
     * Checks whether the field "bScanSupported" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBScanSupported()). Otherwise it will return false.
     */
    inline bool hasBScanSupported () const;

    /**
     * Returns the value of the member "bScanSupported".
     *
     * Identifies whether the device Supports scan feature.The value is "True" if the device supports scan feature and the value is "False" if the device doesn't supports scan feature
     *
     * @return The value of the field "bScanSupported"
     */
    inline bool getBScanSupported () const;

    /**
     * Sets the value of the member "bScanSupported".
     *
     * Identifies whether the device Supports scan feature.The value is "True" if the device supports scan feature and the value is "False" if the device doesn't supports scan feature
     *
     * @param bScanSupported The value which will be set
     */
    inline void setBScanSupported (bool bScanSupported_);

    static const ActiveMediaDeviceStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_bDeviceActiveSource ();

    inline void clear_has_bDeviceActiveSource ();

    inline void set_has_bScanSupported ();

    inline void clear_has_bScanSupported ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceTag;

    bool _bDeviceActiveSource;

    bool _bScanSupported;

};

/**
 * The set message of the property "ActiveMediaDevice"
 * Identifies the media device that is currently sourced. The DeviceTag of
 * 0x00 is reserved as the "My Media" device. When this tag is the
 * ActiveMediaSource, the user is presented with an indexed library of
 * aggregated media from all connected devices with DeviceIndexedStates of
 * IDS_PARTIAL and IDS_COMPLETE.This function is used to set an
 * active media source by DeviceTag. This function can also be used to
 * retrieve the DeviceTag and DeviceInfo of the active media source.Note
 * that the DeviceIndexedState field within the DeviceInfo stream can be used
 * by HMI controllers to determine whether or not the device supports
 * indexing or not. For a device that does not support indexing, only the
 * file and playlist-based functions may be used.
 */
class ActiveMediaDeviceSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveMediaDeviceSet ();

    /**
     * Copy constructor
     */
    inline  ActiveMediaDeviceSet (const ActiveMediaDeviceSet &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveMediaDeviceSet (uint8 u8DeviceTag_, bool bDeviceActiveSource_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveMediaDeviceSet();

    /**
     * Assignment operator
     */
    inline ActiveMediaDeviceSet& operator = (const ActiveMediaDeviceSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveMediaDeviceSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveMediaDeviceSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveMediaDeviceSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveMediaDeviceSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "bDeviceActiveSource"

    static const int kBDeviceActiveSource = 1;

    /**
     * Clears the field "bDeviceActiveSource".
     *
     * The field will be set to its default value. The hasBDeviceActiveSource()
     * method will return false.
     */
    inline void clearBDeviceActiveSource();

    /**
     * Checks whether the field "bDeviceActiveSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDeviceActiveSource()). Otherwise it will return false.
     */
    inline bool hasBDeviceActiveSource () const;

    /**
     * Returns the value of the member "bDeviceActiveSource".
     *
     * Identifies whether a connected device is the active media source.  The value is "True" if the device is the active media source and the value is "False" if the device is not the active media source.
     *
     * @return The value of the field "bDeviceActiveSource"
     */
    inline bool getBDeviceActiveSource () const;

    /**
     * Sets the value of the member "bDeviceActiveSource".
     *
     * Identifies whether a connected device is the active media source.  The value is "True" if the device is the active media source and the value is "False" if the device is not the active media source.
     *
     * @param bDeviceActiveSource The value which will be set
     */
    inline void setBDeviceActiveSource (bool bDeviceActiveSource_);

    static const ActiveMediaDeviceSet &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_bDeviceActiveSource ();

    inline void clear_has_bDeviceActiveSource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceTag;

    bool _bDeviceActiveSource;

};

/**
 * The status message of the property "MyMediaSupported"
 * This Property is used to indicate whether this instance of the MediaPlayer
 * FBlock supports the MyMedia functionality or not so that the IMediaPlayer
 * interface can be used without changes in both Base and Uplevel systems as
 * follows:
 *
 * MyMediaSupported shall be used to allow HMI controllers that control
 * the MediaPlayer FBlock to be able to automatically configure their HMI
 * menus at runtime without internal calibrations. This property shall be
 * set statically by each FBlock and shall not change dynamically at
 * runtime. Therefore, MyMediaSupported has been declared as a
 * non-notifieable property.
 *
 * When MyMediaSupported is False, then no HMI Controller shall use
 * DeviceTag=0x00 in any of the FktIDs herein. As defined in the
 * ActiveMediaDevice property, DeviceTag=0x00 is reserved for the virtual
 * MyMedia device. Consequently, for a MediaPlayer FBlock implementation
 * that does not support MyMedia functionality, receipt of any FktID with
 * DeviceTag = 0x00 shall trigger an error response.
 *
 * When MyMediaSupported is True, then DeviceTag=0x00 is valid and may be
 * used within any of the FktIDs where it is defined to access MyMedia
 * functionality.
 *
 * When MyMediaSupported == FALSE, all QuickPlaylist features are not
 * supported by the MediaPlayer FBlock.  This means that both
 * CreateMediaPlayerQuickPlaylistList 0x223 and
 * RequestMediaPlayerQuickPlayListSlice (0x225) are not supported.  HMI
 * controllers shall instead use PlayMediaPlayerObject (0x228) to play
 * items retrieved via a RequestMediaPlayerFileListSlice (0x222) or
 * RequestMediaPlayerIndexedListSlice (0x204) Method call.
 */
class MyMediaSupportedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MyMediaSupportedStatus ();

    /**
     * Copy constructor
     */
    inline  MyMediaSupportedStatus (const MyMediaSupportedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MyMediaSupportedStatus (bool bMyMediaSupportedFlag_);

    /**
     * Destructor
     */
    inline virtual  ~MyMediaSupportedStatus();

    /**
     * Assignment operator
     */
    inline MyMediaSupportedStatus& operator = (const MyMediaSupportedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MyMediaSupportedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MyMediaSupportedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MyMediaSupportedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MyMediaSupportedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bMyMediaSupportedFlag"

    static const int kBMyMediaSupportedFlag = 0;

    /**
     * Clears the field "bMyMediaSupportedFlag".
     *
     * The field will be set to its default value. The hasBMyMediaSupportedFlag()
     * method will return false.
     */
    inline void clearBMyMediaSupportedFlag();

    /**
     * Checks whether the field "bMyMediaSupportedFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMyMediaSupportedFlag()). Otherwise it will return false.
     */
    inline bool hasBMyMediaSupportedFlag () const;

    /**
     * Returns the value of the member "bMyMediaSupportedFlag".
     *
     *
     *
     * @return The value of the field "bMyMediaSupportedFlag"
     */
    inline bool getBMyMediaSupportedFlag () const;

    /**
     * Sets the value of the member "bMyMediaSupportedFlag".
     *
     *
     *
     * @param bMyMediaSupportedFlag The value which will be set
     */
    inline void setBMyMediaSupportedFlag (bool bMyMediaSupportedFlag_);

    static const MyMediaSupportedStatus &getDefaultInstance();

private:

    inline void set_has_bMyMediaSupportedFlag ();

    inline void clear_has_bMyMediaSupportedFlag ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bMyMediaSupportedFlag;

};

/**
 * The status message of the property "CurrentFolderPath"
 * Reports the current folder base path when the MediaPlayer is playing from
 * a folder list. This property was added in version 4.2 to provide a way for
 * HMI controllers to know the base path to the folder containing the
 * currently playing item, as well as a handle to the list containing the
 * item, as follows:
 *
 * HMI controllers register for notification at startup.
 *
 * When the MediaPlayer is not playing from a file list, the ListHandle
 * parameter shall be set to NULL = 0x00000000 and the CurrentFolderPath
 * parameter shall be set to a zero-length null string. HMI controllers
 * shall interpret a Status update with these values to mean that there
 * is no global folder path defined.
 *
 * When the MediaPlayer is playing from a file list, the ListHandle shall
 * be set to the handle of the directory list containing the currently
 * playing item, and the CurrentFolderPath shall be set to the base path
 * of the containing directory. HMI controllers may not call
 * RequestListInformation with the CurrentFolderListID to retrieve the
 * list containing the current item, as there is no 'Folder' ListType
 * defined.  However, controllers may use the returned CurrentFolderPath
 * in RequestMediaPlayerFileList calls to allow the user to browse up or
 * down the device hierarchy, on that particular controller's HMI,
 * starting from the currently playing it.
 */
class CurrentFolderPathStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentFolderPathStatus ();

    /**
     * Copy constructor
     */
    inline  CurrentFolderPathStatus (const CurrentFolderPathStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentFolderPathStatus (const ::std::string& sCurrentFolderPath_, uint32 u32ListHandle_, uint64 Tag_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentFolderPathStatus();

    /**
     * Assignment operator
     */
    inline CurrentFolderPathStatus& operator = (const CurrentFolderPathStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentFolderPathStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentFolderPathStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentFolderPathStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentFolderPathStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sCurrentFolderPath"

    static const int kSCurrentFolderPath = 0;

    /**
     * Clears the field "sCurrentFolderPath".
     *
     * The field will be set to its default value. The hasSCurrentFolderPath()
     * method will return false.
     */
    inline void clearSCurrentFolderPath();

    /**
     * Checks whether the field "sCurrentFolderPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCurrentFolderPath()). Otherwise it will return false.
     */
    inline bool hasSCurrentFolderPath () const;

    /**
     * Returns the value of the member "sCurrentFolderPath".
     *
     * The folder path to the folder containing the currently playing item.
     *
     * @return The value of the field "sCurrentFolderPath"
     */
    inline const ::std::string& getSCurrentFolderPath () const;

    /**
     * Retrieves the value of the field "sCurrentFolderPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCurrentFolderPath".
     */
    inline ::std::string& getSCurrentFolderPathMutable ();

    /**
     * Sets the value of the member "sCurrentFolderPath".
     *
     * The folder path to the folder containing the currently playing item.
     *
     * @param sCurrentFolderPath The value which will be set
     */
    inline void setSCurrentFolderPath (const ::std::string& sCurrentFolderPath_);

    /**
     * Sets the value of the member "sCurrentFolderPath".
     *
     * The folder path to the folder containing the currently playing item.
     *
     * @param sCurrentFolderPath The value which will be set
     */
    inline void setSCurrentFolderPath (const char* sCurrentFolderPath_);

    /**
     * Sets the value of the member "sCurrentFolderPath".
     *
     * The folder path to the folder containing the currently playing item.
     *
     * @param sCurrentFolderPath The value which will be set
     */
    inline void setSCurrentFolderPath (const char* value, size_t size);

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 1;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "Tag"

    static const int kTag = 2;

    /**
     * Clears the field "Tag".
     *
     * The field will be set to its default value. The hasTag()
     * method will return false.
     */
    inline void clearTag();

    /**
     * Checks whether the field "Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTag()). Otherwise it will return false.
     */
    inline bool hasTag () const;

    /**
     * Returns the value of the member "Tag".
     *
     * Tag of the Directory given in "sPath".THIS MUST BE FILLED FOR 64 BIT PLATFORM
     *
     * @return The value of the field "Tag"
     */
    inline uint64 getTag () const;

    /**
     * Sets the value of the member "Tag".
     *
     * Tag of the Directory given in "sPath".THIS MUST BE FILLED FOR 64 BIT PLATFORM
     *
     * @param Tag The value which will be set
     */
    inline void setTag (uint64 Tag_);

    static const CurrentFolderPathStatus &getDefaultInstance();

private:

    inline void set_has_sCurrentFolderPath ();

    inline void clear_has_sCurrentFolderPath ();

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_Tag ();

    inline void clear_has_Tag ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sCurrentFolderPath;

    uint32 _u32ListHandle;

    uint64 _Tag;

};

/**
 * The status message of the property "ScanMode"
 * Contains whether scan mode is ON/OFF
 *
 * This method may only be called on a device that supports scan feature
 * according to its DeviceInfo.bScanSupported reported by
 * MediaPlayerDeviceConnection property or bScanSupported reported by ActiveMediaDevice property.
 * If bScanSupported = FALSE for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 */
class ScanModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ScanModeStatus ();

    /**
     * Copy constructor
     */
    inline  ScanModeStatus (const ScanModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ScanModeStatus (bool bScanMode_);

    /**
     * Destructor
     */
    inline virtual  ~ScanModeStatus();

    /**
     * Assignment operator
     */
    inline ScanModeStatus& operator = (const ScanModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ScanModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ScanModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ScanModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ScanModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bScanMode"

    static const int kBScanMode = 0;

    /**
     * Clears the field "bScanMode".
     *
     * The field will be set to its default value. The hasBScanMode()
     * method will return false.
     */
    inline void clearBScanMode();

    /**
     * Checks whether the field "bScanMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBScanMode()). Otherwise it will return false.
     */
    inline bool hasBScanMode () const;

    /**
     * Returns the value of the member "bScanMode".
     *
     * Contains whether scan mode is ON/OFF .If ON(i.e TRUE) ,track will be played for a configured  scan time(i.e few seconds) .If OFF(i.e FALSE), track plays till its end.
     *
     * @return The value of the field "bScanMode"
     */
    inline bool getBScanMode () const;

    /**
     * Sets the value of the member "bScanMode".
     *
     * Contains whether scan mode is ON/OFF .If ON(i.e TRUE) ,track will be played for a configured  scan time(i.e few seconds) .If OFF(i.e FALSE), track plays till its end.
     *
     * @param bScanMode The value which will be set
     */
    inline void setBScanMode (bool bScanMode_);

    static const ScanModeStatus &getDefaultInstance();

private:

    inline void set_has_bScanMode ();

    inline void clear_has_bScanMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bScanMode;

};

/**
 * The set message of the property "ScanMode"
 * Contains whether scan mode is ON/OFF
 *
 * This method may only be called on a device that supports scan feature
 * according to its DeviceInfo.bScanSupported reported by
 * MediaPlayerDeviceConnection property or bScanSupported reported by ActiveMediaDevice property.
 * If bScanSupported = FALSE for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 */
class ScanModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ScanModeSet ();

    /**
     * Copy constructor
     */
    inline  ScanModeSet (const ScanModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  ScanModeSet (bool bScanMode_);

    /**
     * Destructor
     */
    inline virtual  ~ScanModeSet();

    /**
     * Assignment operator
     */
    inline ScanModeSet& operator = (const ScanModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ScanModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ScanModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ScanModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ScanModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bScanMode"

    static const int kBScanMode = 0;

    /**
     * Clears the field "bScanMode".
     *
     * The field will be set to its default value. The hasBScanMode()
     * method will return false.
     */
    inline void clearBScanMode();

    /**
     * Checks whether the field "bScanMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBScanMode()). Otherwise it will return false.
     */
    inline bool hasBScanMode () const;

    /**
     * Returns the value of the member "bScanMode".
     *
     * Contains whether scan mode is ON/OFF . If ON(i.e TRUE), track will be played for a configured  scan time(i.e few seconds) .If OFF(i.e FALSE), track plays till its end.
     *
     * @return The value of the field "bScanMode"
     */
    inline bool getBScanMode () const;

    /**
     * Sets the value of the member "bScanMode".
     *
     * Contains whether scan mode is ON/OFF . If ON(i.e TRUE), track will be played for a configured  scan time(i.e few seconds) .If OFF(i.e FALSE), track plays till its end.
     *
     * @param bScanMode The value which will be set
     */
    inline void setBScanMode (bool bScanMode_);

    static const ScanModeSet &getDefaultInstance();

private:

    inline void set_has_bScanMode ();

    inline void clear_has_bScanMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bScanMode;

};

/**
 * The status message of the property "DiscError"
 * This will give the error state of the disc inserted if there is a error
 * DVD Video Region Code Error
 * DVD descramble failed
 * Read error
 * Unknown Disc
 * Unknown DVD
 * Unknown CD
 */
class DiscErrorStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiscErrorStatus ();

    /**
     * Copy constructor
     */
    inline  DiscErrorStatus (const DiscErrorStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiscErrorStatus (bool bIsError_, ::MPlay_fi_types::T_e8_MDiscError e8DiscError_);

    /**
     * Destructor
     */
    inline virtual  ~DiscErrorStatus();

    /**
     * Assignment operator
     */
    inline DiscErrorStatus& operator = (const DiscErrorStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiscErrorStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiscErrorStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiscErrorStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiscErrorStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bIsError"

    static const int kBIsError = 0;

    /**
     * Clears the field "bIsError".
     *
     * The field will be set to its default value. The hasBIsError()
     * method will return false.
     */
    inline void clearBIsError();

    /**
     * Checks whether the field "bIsError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsError()). Otherwise it will return false.
     */
    inline bool hasBIsError () const;

    /**
     * Returns the value of the member "bIsError".
     *
     * This will give the error state of the disc inserted ,True if it is an error disc else false
     *
     * @return The value of the field "bIsError"
     */
    inline bool getBIsError () const;

    /**
     * Sets the value of the member "bIsError".
     *
     * This will give the error state of the disc inserted ,True if it is an error disc else false
     *
     * @param bIsError The value which will be set
     */
    inline void setBIsError (bool bIsError_);

    // API of field "e8DiscError"

    static const int kE8DiscError = 1;

    /**
     * Clears the field "e8DiscError".
     *
     * The field will be set to its default value. The hasE8DiscError()
     * method will return false.
     */
    inline void clearE8DiscError();

    /**
     * Checks whether the field "e8DiscError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiscError()). Otherwise it will return false.
     */
    inline bool hasE8DiscError () const;

    /**
     * Returns the value of the member "e8DiscError".
     *
     * This will give the error type of the disc inserted
     *
     * @return The value of the field "e8DiscError"
     */
    inline ::MPlay_fi_types::T_e8_MDiscError getE8DiscError () const;

    /**
     * Sets the value of the member "e8DiscError".
     *
     * This will give the error type of the disc inserted
     *
     * @param e8DiscError The value which will be set
     */
    inline void setE8DiscError (::MPlay_fi_types::T_e8_MDiscError e8DiscError_);

    static const DiscErrorStatus &getDefaultInstance();

private:

    inline void set_has_bIsError ();

    inline void clear_has_bIsError ();

    inline void set_has_e8DiscError ();

    inline void clear_has_e8DiscError ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bIsError;

    ::MPlay_fi_types::T_e8_MDiscError _e8DiscError;

};

/**
 * The status message of the property "DiscMechanicalInfo"
 * This will give the error state of the disc inserted
 * Disc chucking
 * During disc loading
 * Disc eject finish
 * During disc eject
 * Disc eject finish
 * Disc stop
 * Disc mechanism undecided
 */
class DiscMechanicalInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiscMechanicalInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DiscMechanicalInfoStatus (const DiscMechanicalInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiscMechanicalInfoStatus (::MPlay_fi_types::T_e8_MDiscMechanicalInfo e8DiscMechanicalInfo_);

    /**
     * Destructor
     */
    inline virtual  ~DiscMechanicalInfoStatus();

    /**
     * Assignment operator
     */
    inline DiscMechanicalInfoStatus& operator = (const DiscMechanicalInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiscMechanicalInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiscMechanicalInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiscMechanicalInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiscMechanicalInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DiscMechanicalInfo"

    static const int kE8DiscMechanicalInfo = 0;

    /**
     * Clears the field "e8DiscMechanicalInfo".
     *
     * The field will be set to its default value. The hasE8DiscMechanicalInfo()
     * method will return false.
     */
    inline void clearE8DiscMechanicalInfo();

    /**
     * Checks whether the field "e8DiscMechanicalInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiscMechanicalInfo()). Otherwise it will return false.
     */
    inline bool hasE8DiscMechanicalInfo () const;

    /**
     * Returns the value of the member "e8DiscMechanicalInfo".
     *
     * This will give the mechanical state of the disc inserted
     *
     * @return The value of the field "e8DiscMechanicalInfo"
     */
    inline ::MPlay_fi_types::T_e8_MDiscMechanicalInfo getE8DiscMechanicalInfo () const;

    /**
     * Sets the value of the member "e8DiscMechanicalInfo".
     *
     * This will give the mechanical state of the disc inserted
     *
     * @param e8DiscMechanicalInfo The value which will be set
     */
    inline void setE8DiscMechanicalInfo (::MPlay_fi_types::T_e8_MDiscMechanicalInfo e8DiscMechanicalInfo_);

    static const DiscMechanicalInfoStatus &getDefaultInstance();

private:

    inline void set_has_e8DiscMechanicalInfo ();

    inline void clear_has_e8DiscMechanicalInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MDiscMechanicalInfo _e8DiscMechanicalInfo;

};

/**
 * The status message of the property "CMSkipAvailable"
 * This will give the CM Skip function availablity for the current playing video file
 */
class CMSkipAvailableStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CMSkipAvailableStatus ();

    /**
     * Copy constructor
     */
    inline  CMSkipAvailableStatus (const CMSkipAvailableStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CMSkipAvailableStatus (bool bCMSkipAvailable_);

    /**
     * Destructor
     */
    inline virtual  ~CMSkipAvailableStatus();

    /**
     * Assignment operator
     */
    inline CMSkipAvailableStatus& operator = (const CMSkipAvailableStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CMSkipAvailableStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CMSkipAvailableStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CMSkipAvailableStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CMSkipAvailableStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bCMSkipAvailable"

    static const int kBCMSkipAvailable = 0;

    /**
     * Clears the field "bCMSkipAvailable".
     *
     * The field will be set to its default value. The hasBCMSkipAvailable()
     * method will return false.
     */
    inline void clearBCMSkipAvailable();

    /**
     * Checks whether the field "bCMSkipAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCMSkipAvailable()). Otherwise it will return false.
     */
    inline bool hasBCMSkipAvailable () const;

    /**
     * Returns the value of the member "bCMSkipAvailable".
     *
     * This will give the CM Skip function availability of the video playing
     *
     * @return The value of the field "bCMSkipAvailable"
     */
    inline bool getBCMSkipAvailable () const;

    /**
     * Sets the value of the member "bCMSkipAvailable".
     *
     * This will give the CM Skip function availability of the video playing
     *
     * @param bCMSkipAvailable The value which will be set
     */
    inline void setBCMSkipAvailable (bool bCMSkipAvailable_);

    static const CMSkipAvailableStatus &getDefaultInstance();

private:

    inline void set_has_bCMSkipAvailable ();

    inline void clear_has_bCMSkipAvailable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bCMSkipAvailable;

};

/**
 * The status message of the property "DirectSelectAvailable"
 * This will give the Direct Select function availablity for the current playing disc ,
 * Supported only in Video CD v2.0 (Type C) for direct selection of the number specified as parameter and In DVD Audio (Type D)
 * and DVD Video (Type F) for selecting the button equivalent to the number.
 */
class DirectSelectAvailableStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DirectSelectAvailableStatus ();

    /**
     * Copy constructor
     */
    inline  DirectSelectAvailableStatus (const DirectSelectAvailableStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DirectSelectAvailableStatus (bool bDirectSelectAvailable_);

    /**
     * Destructor
     */
    inline virtual  ~DirectSelectAvailableStatus();

    /**
     * Assignment operator
     */
    inline DirectSelectAvailableStatus& operator = (const DirectSelectAvailableStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DirectSelectAvailableStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DirectSelectAvailableStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DirectSelectAvailableStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DirectSelectAvailableStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bDirectSelectAvailable"

    static const int kBDirectSelectAvailable = 0;

    /**
     * Clears the field "bDirectSelectAvailable".
     *
     * The field will be set to its default value. The hasBDirectSelectAvailable()
     * method will return false.
     */
    inline void clearBDirectSelectAvailable();

    /**
     * Checks whether the field "bDirectSelectAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDirectSelectAvailable()). Otherwise it will return false.
     */
    inline bool hasBDirectSelectAvailable () const;

    /**
     * Returns the value of the member "bDirectSelectAvailable".
     *
     * This will give the CM Skip function availability of the video playing
     *
     * @return The value of the field "bDirectSelectAvailable"
     */
    inline bool getBDirectSelectAvailable () const;

    /**
     * Sets the value of the member "bDirectSelectAvailable".
     *
     * This will give the CM Skip function availability of the video playing
     *
     * @param bDirectSelectAvailable The value which will be set
     */
    inline void setBDirectSelectAvailable (bool bDirectSelectAvailable_);

    static const DirectSelectAvailableStatus &getDefaultInstance();

private:

    inline void set_has_bDirectSelectAvailable ();

    inline void clear_has_bDirectSelectAvailable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bDirectSelectAvailable;

};

/**
 * The status message of the property "DVDAngleInfo"
 * This will give the Dvd Angle information of the current playing content
 */
class DVDAngleInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DVDAngleInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DVDAngleInfoStatus (const DVDAngleInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DVDAngleInfoStatus (::MPlay_fi_types::T_e8_MAngle e8CurrentAngle_, ::MPlay_fi_types::T_e8_MAngle e8TotalAngle_);

    /**
     * Destructor
     */
    inline virtual  ~DVDAngleInfoStatus();

    /**
     * Assignment operator
     */
    inline DVDAngleInfoStatus& operator = (const DVDAngleInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DVDAngleInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DVDAngleInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DVDAngleInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DVDAngleInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8CurrentAngle"

    static const int kE8CurrentAngle = 0;

    /**
     * Clears the field "e8CurrentAngle".
     *
     * The field will be set to its default value. The hasE8CurrentAngle()
     * method will return false.
     */
    inline void clearE8CurrentAngle();

    /**
     * Checks whether the field "e8CurrentAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CurrentAngle()). Otherwise it will return false.
     */
    inline bool hasE8CurrentAngle () const;

    /**
     * Returns the value of the member "e8CurrentAngle".
     *
     * Specifies the current angle in use.
     *
     * @return The value of the field "e8CurrentAngle"
     */
    inline ::MPlay_fi_types::T_e8_MAngle getE8CurrentAngle () const;

    /**
     * Sets the value of the member "e8CurrentAngle".
     *
     * Specifies the current angle in use.
     *
     * @param e8CurrentAngle The value which will be set
     */
    inline void setE8CurrentAngle (::MPlay_fi_types::T_e8_MAngle e8CurrentAngle_);

    // API of field "e8TotalAngle"

    static const int kE8TotalAngle = 1;

    /**
     * Clears the field "e8TotalAngle".
     *
     * The field will be set to its default value. The hasE8TotalAngle()
     * method will return false.
     */
    inline void clearE8TotalAngle();

    /**
     * Checks whether the field "e8TotalAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TotalAngle()). Otherwise it will return false.
     */
    inline bool hasE8TotalAngle () const;

    /**
     * Returns the value of the member "e8TotalAngle".
     *
     * Specifies the total number of angle supported by the disc.
     *
     * @return The value of the field "e8TotalAngle"
     */
    inline ::MPlay_fi_types::T_e8_MAngle getE8TotalAngle () const;

    /**
     * Sets the value of the member "e8TotalAngle".
     *
     * Specifies the total number of angle supported by the disc.
     *
     * @param e8TotalAngle The value which will be set
     */
    inline void setE8TotalAngle (::MPlay_fi_types::T_e8_MAngle e8TotalAngle_);

    static const DVDAngleInfoStatus &getDefaultInstance();

private:

    inline void set_has_e8CurrentAngle ();

    inline void clear_has_e8CurrentAngle ();

    inline void set_has_e8TotalAngle ();

    inline void clear_has_e8TotalAngle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::MPlay_fi_types::T_e8_MAngle _e8CurrentAngle;

    ::MPlay_fi_types::T_e8_MAngle _e8TotalAngle;

};

/**
 * The status message of the property "DVDSubtitleInfo"
 * This will give the Dvd Angle information of the current playing content
 */
class DVDSubtitleInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DVDSubtitleInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DVDSubtitleInfoStatus (const DVDSubtitleInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DVDSubtitleInfoStatus (bool subtitleState_, uint8 u8CurrentSubtitle_, uint8 u8TotalSubtitle_, uint16 u16SubtitleLang_);

    /**
     * Destructor
     */
    inline virtual  ~DVDSubtitleInfoStatus();

    /**
     * Assignment operator
     */
    inline DVDSubtitleInfoStatus& operator = (const DVDSubtitleInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DVDSubtitleInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DVDSubtitleInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DVDSubtitleInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DVDSubtitleInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "subtitleState"

    static const int kSubtitleState = 0;

    /**
     * Clears the field "subtitleState".
     *
     * The field will be set to its default value. The hasSubtitleState()
     * method will return false.
     */
    inline void clearSubtitleState();

    /**
     * Checks whether the field "subtitleState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubtitleState()). Otherwise it will return false.
     */
    inline bool hasSubtitleState () const;

    /**
     * Returns the value of the member "subtitleState".
     *
     * If true the subtitle statusis ON else OFF
     *
     * @return The value of the field "subtitleState"
     */
    inline bool getSubtitleState () const;

    /**
     * Sets the value of the member "subtitleState".
     *
     * If true the subtitle statusis ON else OFF
     *
     * @param subtitleState The value which will be set
     */
    inline void setSubtitleState (bool subtitleState_);

    // API of field "u8CurrentSubtitle"

    static const int kU8CurrentSubtitle = 1;

    /**
     * Clears the field "u8CurrentSubtitle".
     *
     * The field will be set to its default value. The hasU8CurrentSubtitle()
     * method will return false.
     */
    inline void clearU8CurrentSubtitle();

    /**
     * Checks whether the field "u8CurrentSubtitle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CurrentSubtitle()). Otherwise it will return false.
     */
    inline bool hasU8CurrentSubtitle () const;

    /**
     * Returns the value of the member "u8CurrentSubtitle".
     *
     * Specifies the  subtitle number to select , 1 to  32
     *
     * @return The value of the field "u8CurrentSubtitle"
     */
    inline uint8 getU8CurrentSubtitle () const;

    /**
     * Sets the value of the member "u8CurrentSubtitle".
     *
     * Specifies the  subtitle number to select , 1 to  32
     *
     * @param u8CurrentSubtitle The value which will be set
     */
    inline void setU8CurrentSubtitle (uint8 u8CurrentSubtitle_);

    // API of field "u8TotalSubtitle"

    static const int kU8TotalSubtitle = 2;

    /**
     * Clears the field "u8TotalSubtitle".
     *
     * The field will be set to its default value. The hasU8TotalSubtitle()
     * method will return false.
     */
    inline void clearU8TotalSubtitle();

    /**
     * Checks whether the field "u8TotalSubtitle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TotalSubtitle()). Otherwise it will return false.
     */
    inline bool hasU8TotalSubtitle () const;

    /**
     * Returns the value of the member "u8TotalSubtitle".
     *
     * Specifies the  total subtitle number supported , maximum of 32
     *
     * @return The value of the field "u8TotalSubtitle"
     */
    inline uint8 getU8TotalSubtitle () const;

    /**
     * Sets the value of the member "u8TotalSubtitle".
     *
     * Specifies the  total subtitle number supported , maximum of 32
     *
     * @param u8TotalSubtitle The value which will be set
     */
    inline void setU8TotalSubtitle (uint8 u8TotalSubtitle_);

    // API of field "u16SubtitleLang"

    static const int kU16SubtitleLang = 3;

    /**
     * Clears the field "u16SubtitleLang".
     *
     * The field will be set to its default value. The hasU16SubtitleLang()
     * method will return false.
     */
    inline void clearU16SubtitleLang();

    /**
     * Checks whether the field "u16SubtitleLang" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SubtitleLang()). Otherwise it will return false.
     */
    inline bool hasU16SubtitleLang () const;

    /**
     * Returns the value of the member "u16SubtitleLang".
     *
     * Specifies the current subtitle language code
     *
     * @return The value of the field "u16SubtitleLang"
     */
    inline uint16 getU16SubtitleLang () const;

    /**
     * Sets the value of the member "u16SubtitleLang".
     *
     * Specifies the current subtitle language code
     *
     * @param u16SubtitleLang The value which will be set
     */
    inline void setU16SubtitleLang (uint16 u16SubtitleLang_);

    static const DVDSubtitleInfoStatus &getDefaultInstance();

private:

    inline void set_has_subtitleState ();

    inline void clear_has_subtitleState ();

    inline void set_has_u8CurrentSubtitle ();

    inline void clear_has_u8CurrentSubtitle ();

    inline void set_has_u8TotalSubtitle ();

    inline void clear_has_u8TotalSubtitle ();

    inline void set_has_u16SubtitleLang ();

    inline void clear_has_u16SubtitleLang ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _subtitleState;

    uint8 _u8CurrentSubtitle;

    uint8 _u8TotalSubtitle;

    uint16 _u16SubtitleLang;

};

/**
 * The status message of the property "DVDAudioChannelInfo"
 * This will give the Dvd audio information of the current playing disc , channels supported and sub woofer availability
 */
class DVDAudioChannelInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DVDAudioChannelInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DVDAudioChannelInfoStatus (const DVDAudioChannelInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DVDAudioChannelInfoStatus (::MPlay_fi_types::T_e8_MTotalChannel e8totalChannels_, bool bSubWooferAvailable_, ::MPlay_fi_types::T_e8_MChannelAssignment e8CurrentAssignment_);

    /**
     * Destructor
     */
    inline virtual  ~DVDAudioChannelInfoStatus();

    /**
     * Assignment operator
     */
    inline DVDAudioChannelInfoStatus& operator = (const DVDAudioChannelInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DVDAudioChannelInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DVDAudioChannelInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DVDAudioChannelInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DVDAudioChannelInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8totalChannels"

    static const int kE8totalChannels = 0;

    /**
     * Clears the field "e8totalChannels".
     *
     * The field will be set to its default value. The hasE8totalChannels()
     * method will return false.
     */
    inline void clearE8totalChannels();

    /**
     * Checks whether the field "e8totalChannels" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8totalChannels()). Otherwise it will return false.
     */
    inline bool hasE8totalChannels () const;

    /**
     * Returns the value of the member "e8totalChannels".
     *
     * It gives us the total channel available
     *
     * @return The value of the field "e8totalChannels"
     */
    inline ::MPlay_fi_types::T_e8_MTotalChannel getE8totalChannels () const;

    /**
     * Sets the value of the member "e8totalChannels".
     *
     * It gives us the total channel available
     *
     * @param e8totalChannels The value which will be set
     */
    inline void setE8totalChannels (::MPlay_fi_types::T_e8_MTotalChannel e8totalChannels_);

    // API of field "bSubWooferAvailable"

    static const int kBSubWooferAvailable = 1;

    /**
     * Clears the field "bSubWooferAvailable".
     *
     * The field will be set to its default value. The hasBSubWooferAvailable()
     * method will return false.
     */
    inline void clearBSubWooferAvailable();

    /**
     * Checks whether the field "bSubWooferAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSubWooferAvailable()). Otherwise it will return false.
     */
    inline bool hasBSubWooferAvailable () const;

    /**
     * Returns the value of the member "bSubWooferAvailable".
     *
     * Specifies whether subwoofer is available or not
     *
     * @return The value of the field "bSubWooferAvailable"
     */
    inline bool getBSubWooferAvailable () const;

    /**
     * Sets the value of the member "bSubWooferAvailable".
     *
     * Specifies whether subwoofer is available or not
     *
     * @param bSubWooferAvailable The value which will be set
     */
    inline void setBSubWooferAvailable (bool bSubWooferAvailable_);

    // API of field "e8CurrentAssignment"

    static const int kE8CurrentAssignment = 2;

    /**
     * Clears the field "e8CurrentAssignment".
     *
     * The field will be set to its default value. The hasE8CurrentAssignment()
     * method will return false.
     */
    inline void clearE8CurrentAssignment();

    /**
     * Checks whether the field "e8CurrentAssignment" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CurrentAssignment()). Otherwise it will return false.
     */
    inline bool hasE8CurrentAssignment () const;

    /**
     * Returns the value of the member "e8CurrentAssignment".
     *
     * Specifies the current channel assigned
     *
     * @return The value of the field "e8CurrentAssignment"
     */
    inline ::MPlay_fi_types::T_e8_MChannelAssignment getE8CurrentAssignment () const;

    /**
     * Sets the value of the member "e8CurrentAssignment".
     *
     * Specifies the current channel assigned
     *
     * @param e8CurrentAssignment The value which will be set
     */
    inline void setE8CurrentAssignment (::MPlay_fi_types::T_e8_MChannelAssignment e8CurrentAssignment_);

    static const DVDAudioChannelInfoStatus &getDefaultInstance();

private:

    inline void set_has_e8totalChannels ();

    inline void clear_has_e8totalChannels ();

    inline void set_has_bSubWooferAvailable ();

    inline void clear_has_bSubWooferAvailable ();

    inline void set_has_e8CurrentAssignment ();

    inline void clear_has_e8CurrentAssignment ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::MPlay_fi_types::T_e8_MTotalChannel _e8totalChannels;

    bool _bSubWooferAvailable;

    ::MPlay_fi_types::T_e8_MChannelAssignment _e8CurrentAssignment;

};

/**
 * The status message of the property "DVDCurrentAudioInfo"
 * This will give the audio information of the current playing content
 */
class DVDCurrentAudioInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DVDCurrentAudioInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DVDCurrentAudioInfoStatus (const DVDCurrentAudioInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DVDCurrentAudioInfoStatus (::MPlay_fi_types::T_e8_MSoundFormat e8SoundFormat_, ::MPlay_fi_types::T_e8_MVCDAudioMode e8VCDAudioOutput_, ::MPlay_fi_types::T_e8_MAudioOutputNumber e8DVDAudioChannel_, ::MPlay_fi_types::T_e8_MAudioOutputNumber e8DVDTotalAudio_, uint16 u16DVDAudioLang_);

    /**
     * Destructor
     */
    inline virtual  ~DVDCurrentAudioInfoStatus();

    /**
     * Assignment operator
     */
    inline DVDCurrentAudioInfoStatus& operator = (const DVDCurrentAudioInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DVDCurrentAudioInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DVDCurrentAudioInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DVDCurrentAudioInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DVDCurrentAudioInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SoundFormat"

    static const int kE8SoundFormat = 0;

    /**
     * Clears the field "e8SoundFormat".
     *
     * The field will be set to its default value. The hasE8SoundFormat()
     * method will return false.
     */
    inline void clearE8SoundFormat();

    /**
     * Checks whether the field "e8SoundFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SoundFormat()). Otherwise it will return false.
     */
    inline bool hasE8SoundFormat () const;

    /**
     * Returns the value of the member "e8SoundFormat".
     *
     * It gives us the current sound output - linear PCM, DD, DTS
     *
     * @return The value of the field "e8SoundFormat"
     */
    inline ::MPlay_fi_types::T_e8_MSoundFormat getE8SoundFormat () const;

    /**
     * Sets the value of the member "e8SoundFormat".
     *
     * It gives us the current sound output - linear PCM, DD, DTS
     *
     * @param e8SoundFormat The value which will be set
     */
    inline void setE8SoundFormat (::MPlay_fi_types::T_e8_MSoundFormat e8SoundFormat_);

    // API of field "e8VCDAudioOutput"

    static const int kE8VCDAudioOutput = 1;

    /**
     * Clears the field "e8VCDAudioOutput".
     *
     * The field will be set to its default value. The hasE8VCDAudioOutput()
     * method will return false.
     */
    inline void clearE8VCDAudioOutput();

    /**
     * Checks whether the field "e8VCDAudioOutput" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8VCDAudioOutput()). Otherwise it will return false.
     */
    inline bool hasE8VCDAudioOutput () const;

    /**
     * Returns the value of the member "e8VCDAudioOutput".
     *
     * Specifies the current VCD Audio output incase inserted disc is a VCD or SVCD
     *
     * @return The value of the field "e8VCDAudioOutput"
     */
    inline ::MPlay_fi_types::T_e8_MVCDAudioMode getE8VCDAudioOutput () const;

    /**
     * Sets the value of the member "e8VCDAudioOutput".
     *
     * Specifies the current VCD Audio output incase inserted disc is a VCD or SVCD
     *
     * @param e8VCDAudioOutput The value which will be set
     */
    inline void setE8VCDAudioOutput (::MPlay_fi_types::T_e8_MVCDAudioMode e8VCDAudioOutput_);

    // API of field "e8DVDAudioChannel"

    static const int kE8DVDAudioChannel = 2;

    /**
     * Clears the field "e8DVDAudioChannel".
     *
     * The field will be set to its default value. The hasE8DVDAudioChannel()
     * method will return false.
     */
    inline void clearE8DVDAudioChannel();

    /**
     * Checks whether the field "e8DVDAudioChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DVDAudioChannel()). Otherwise it will return false.
     */
    inline bool hasE8DVDAudioChannel () const;

    /**
     * Returns the value of the member "e8DVDAudioChannel".
     *
     * Specifies the current DVD Audio output incase inserted disc is a DVD
     *
     * @return The value of the field "e8DVDAudioChannel"
     */
    inline ::MPlay_fi_types::T_e8_MAudioOutputNumber getE8DVDAudioChannel () const;

    /**
     * Sets the value of the member "e8DVDAudioChannel".
     *
     * Specifies the current DVD Audio output incase inserted disc is a DVD
     *
     * @param e8DVDAudioChannel The value which will be set
     */
    inline void setE8DVDAudioChannel (::MPlay_fi_types::T_e8_MAudioOutputNumber e8DVDAudioChannel_);

    // API of field "e8DVDTotalAudio"

    static const int kE8DVDTotalAudio = 3;

    /**
     * Clears the field "e8DVDTotalAudio".
     *
     * The field will be set to its default value. The hasE8DVDTotalAudio()
     * method will return false.
     */
    inline void clearE8DVDTotalAudio();

    /**
     * Checks whether the field "e8DVDTotalAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DVDTotalAudio()). Otherwise it will return false.
     */
    inline bool hasE8DVDTotalAudio () const;

    /**
     * Returns the value of the member "e8DVDTotalAudio".
     *
     * Specifies the Total Audio output available incase of a DVD
     *
     * @return The value of the field "e8DVDTotalAudio"
     */
    inline ::MPlay_fi_types::T_e8_MAudioOutputNumber getE8DVDTotalAudio () const;

    /**
     * Sets the value of the member "e8DVDTotalAudio".
     *
     * Specifies the Total Audio output available incase of a DVD
     *
     * @param e8DVDTotalAudio The value which will be set
     */
    inline void setE8DVDTotalAudio (::MPlay_fi_types::T_e8_MAudioOutputNumber e8DVDTotalAudio_);

    // API of field "u16DVDAudioLang"

    static const int kU16DVDAudioLang = 4;

    /**
     * Clears the field "u16DVDAudioLang".
     *
     * The field will be set to its default value. The hasU16DVDAudioLang()
     * method will return false.
     */
    inline void clearU16DVDAudioLang();

    /**
     * Checks whether the field "u16DVDAudioLang" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16DVDAudioLang()). Otherwise it will return false.
     */
    inline bool hasU16DVDAudioLang () const;

    /**
     * Returns the value of the member "u16DVDAudioLang".
     *
     * Specifies the current audio language code
     *
     * @return The value of the field "u16DVDAudioLang"
     */
    inline uint16 getU16DVDAudioLang () const;

    /**
     * Sets the value of the member "u16DVDAudioLang".
     *
     * Specifies the current audio language code
     *
     * @param u16DVDAudioLang The value which will be set
     */
    inline void setU16DVDAudioLang (uint16 u16DVDAudioLang_);

    static const DVDCurrentAudioInfoStatus &getDefaultInstance();

private:

    inline void set_has_e8SoundFormat ();

    inline void clear_has_e8SoundFormat ();

    inline void set_has_e8VCDAudioOutput ();

    inline void clear_has_e8VCDAudioOutput ();

    inline void set_has_e8DVDAudioChannel ();

    inline void clear_has_e8DVDAudioChannel ();

    inline void set_has_e8DVDTotalAudio ();

    inline void clear_has_e8DVDTotalAudio ();

    inline void set_has_u16DVDAudioLang ();

    inline void clear_has_u16DVDAudioLang ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::MPlay_fi_types::T_e8_MSoundFormat _e8SoundFormat;

    ::MPlay_fi_types::T_e8_MVCDAudioMode _e8VCDAudioOutput;

    ::MPlay_fi_types::T_e8_MAudioOutputNumber _e8DVDAudioChannel;

    ::MPlay_fi_types::T_e8_MAudioOutputNumber _e8DVDTotalAudio;

    uint16 _u16DVDAudioLang;

};

/**
 * The status message of the property "DisplayMode"
 * This will give the Display mode (Aspect Ratio) for the current playing content , cannot be set during playback
 */
class DisplayModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayModeStatus ();

    /**
     * Copy constructor
     */
    inline  DisplayModeStatus (const DisplayModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DisplayModeStatus (::MPlay_fi_types::T_e8_MDisplayMode e8DisplayMode_);

    /**
     * Destructor
     */
    inline virtual  ~DisplayModeStatus();

    /**
     * Assignment operator
     */
    inline DisplayModeStatus& operator = (const DisplayModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DisplayMode"

    static const int kE8DisplayMode = 0;

    /**
     * Clears the field "e8DisplayMode".
     *
     * The field will be set to its default value. The hasE8DisplayMode()
     * method will return false.
     */
    inline void clearE8DisplayMode();

    /**
     * Checks whether the field "e8DisplayMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DisplayMode()). Otherwise it will return false.
     */
    inline bool hasE8DisplayMode () const;

    /**
     * Returns the value of the member "e8DisplayMode".
     *
     * This will give the Display mode (Aspect Ratio) for the current playing content
     *
     * @return The value of the field "e8DisplayMode"
     */
    inline ::MPlay_fi_types::T_e8_MDisplayMode getE8DisplayMode () const;

    /**
     * Sets the value of the member "e8DisplayMode".
     *
     * This will give the Display mode (Aspect Ratio) for the current playing content
     *
     * @param e8DisplayMode The value which will be set
     */
    inline void setE8DisplayMode (::MPlay_fi_types::T_e8_MDisplayMode e8DisplayMode_);

    static const DisplayModeStatus &getDefaultInstance();

private:

    inline void set_has_e8DisplayMode ();

    inline void clear_has_e8DisplayMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MDisplayMode _e8DisplayMode;

};

/**
 * The set message of the property "DisplayMode"
 * This will give the Display mode (Aspect Ratio) for the current playing content , cannot be set during playback
 */
class DisplayModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayModeSet ();

    /**
     * Copy constructor
     */
    inline  DisplayModeSet (const DisplayModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  DisplayModeSet (::MPlay_fi_types::T_e8_MDisplayMode e8DisplayMode_);

    /**
     * Destructor
     */
    inline virtual  ~DisplayModeSet();

    /**
     * Assignment operator
     */
    inline DisplayModeSet& operator = (const DisplayModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DisplayMode"

    static const int kE8DisplayMode = 0;

    /**
     * Clears the field "e8DisplayMode".
     *
     * The field will be set to its default value. The hasE8DisplayMode()
     * method will return false.
     */
    inline void clearE8DisplayMode();

    /**
     * Checks whether the field "e8DisplayMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DisplayMode()). Otherwise it will return false.
     */
    inline bool hasE8DisplayMode () const;

    /**
     * Returns the value of the member "e8DisplayMode".
     *
     * This will give the Display mode (Aspect Ratio) for the current playing content
     *
     * @return The value of the field "e8DisplayMode"
     */
    inline ::MPlay_fi_types::T_e8_MDisplayMode getE8DisplayMode () const;

    /**
     * Sets the value of the member "e8DisplayMode".
     *
     * This will give the Display mode (Aspect Ratio) for the current playing content
     *
     * @param e8DisplayMode The value which will be set
     */
    inline void setE8DisplayMode (::MPlay_fi_types::T_e8_MDisplayMode e8DisplayMode_);

    static const DisplayModeSet &getDefaultInstance();

private:

    inline void set_has_e8DisplayMode ();

    inline void clear_has_e8DisplayMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MDisplayMode _e8DisplayMode;

};

/**
 * The status message of the property "DVDPlayerLangSetting"
 * Specifies the Language settings for the setup of the DVD Drive ,cannot be set during playback
 */
class DVDPlayerLangSettingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DVDPlayerLangSettingStatus ();

    /**
     * Copy constructor
     */
    inline  DVDPlayerLangSettingStatus (const DVDPlayerLangSettingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DVDPlayerLangSettingStatus (const ::MPlay_fi_types::T_MInternalDVDLangSetting& langSetting_);

    /**
     * Destructor
     */
    inline virtual  ~DVDPlayerLangSettingStatus();

    /**
     * Assignment operator
     */
    inline DVDPlayerLangSettingStatus& operator = (const DVDPlayerLangSettingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DVDPlayerLangSettingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DVDPlayerLangSettingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DVDPlayerLangSettingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DVDPlayerLangSettingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "langSetting"

    static const int kLangSetting = 0;

    /**
     * Clears the field "langSetting".
     *
     * The field will be set to its default value. The hasLangSetting()
     * method will return false.
     */
    inline void clearLangSetting();

    /**
     * Checks whether the field "langSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLangSetting()). Otherwise it will return false.
     */
    inline bool hasLangSetting () const;

    /**
     * Returns the value of the member "langSetting".
     *
     * Specifies the Language settings for the setup of the DVD Drive , These settings cannot be changed during playback
     *
     * @return The value of the field "langSetting"
     */
    inline const ::MPlay_fi_types::T_MInternalDVDLangSetting& getLangSetting () const;

    /**
     * Retrieves the value of the field "langSetting" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "langSetting".
     */
    inline ::MPlay_fi_types::T_MInternalDVDLangSetting& getLangSettingMutable ();

    /**
     * Sets the value of the member "langSetting".
     *
     * Specifies the Language settings for the setup of the DVD Drive , These settings cannot be changed during playback
     *
     * @param langSetting The value which will be set
     */
    inline void setLangSetting (const ::MPlay_fi_types::T_MInternalDVDLangSetting& langSetting_);

    static const DVDPlayerLangSettingStatus &getDefaultInstance();

private:

    inline void set_has_langSetting ();

    inline void clear_has_langSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_MInternalDVDLangSetting _langSetting;

};

/**
 * The set message of the property "DVDPlayerLangSetting"
 * Specifies the Language settings for the setup of the DVD Drive ,cannot be set during playback
 */
class DVDPlayerLangSettingSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DVDPlayerLangSettingSet ();

    /**
     * Copy constructor
     */
    inline  DVDPlayerLangSettingSet (const DVDPlayerLangSettingSet &rhs);

    /**
     * All fields constructor
     */
    inline  DVDPlayerLangSettingSet (const ::MPlay_fi_types::T_MInternalDVDLangSetting& langSetting_);

    /**
     * Destructor
     */
    inline virtual  ~DVDPlayerLangSettingSet();

    /**
     * Assignment operator
     */
    inline DVDPlayerLangSettingSet& operator = (const DVDPlayerLangSettingSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DVDPlayerLangSettingSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DVDPlayerLangSettingSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DVDPlayerLangSettingSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DVDPlayerLangSettingSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "langSetting"

    static const int kLangSetting = 0;

    /**
     * Clears the field "langSetting".
     *
     * The field will be set to its default value. The hasLangSetting()
     * method will return false.
     */
    inline void clearLangSetting();

    /**
     * Checks whether the field "langSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLangSetting()). Otherwise it will return false.
     */
    inline bool hasLangSetting () const;

    /**
     * Returns the value of the member "langSetting".
     *
     * Specifies the Language settings for the setup of the DVD Drive , These settings cannot be changed during playback
     *
     * @return The value of the field "langSetting"
     */
    inline const ::MPlay_fi_types::T_MInternalDVDLangSetting& getLangSetting () const;

    /**
     * Retrieves the value of the field "langSetting" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "langSetting".
     */
    inline ::MPlay_fi_types::T_MInternalDVDLangSetting& getLangSettingMutable ();

    /**
     * Sets the value of the member "langSetting".
     *
     * Specifies the Language settings for the setup of the DVD Drive , These settings cannot be changed during playback
     *
     * @param langSetting The value which will be set
     */
    inline void setLangSetting (const ::MPlay_fi_types::T_MInternalDVDLangSetting& langSetting_);

    static const DVDPlayerLangSettingSet &getDefaultInstance();

private:

    inline void set_has_langSetting ();

    inline void clear_has_langSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_MInternalDVDLangSetting _langSetting;

};

/**
 * The status message of the property "AngleMarkSetting"
 * This will decide whether the angle mark status has to be displayed or not ,can be set during playback.
 */
class AngleMarkSettingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AngleMarkSettingStatus ();

    /**
     * Copy constructor
     */
    inline  AngleMarkSettingStatus (const AngleMarkSettingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AngleMarkSettingStatus (bool bAngleMark_);

    /**
     * Destructor
     */
    inline virtual  ~AngleMarkSettingStatus();

    /**
     * Assignment operator
     */
    inline AngleMarkSettingStatus& operator = (const AngleMarkSettingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AngleMarkSettingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AngleMarkSettingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AngleMarkSettingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AngleMarkSettingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAngleMark"

    static const int kBAngleMark = 0;

    /**
     * Clears the field "bAngleMark".
     *
     * The field will be set to its default value. The hasBAngleMark()
     * method will return false.
     */
    inline void clearBAngleMark();

    /**
     * Checks whether the field "bAngleMark" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAngleMark()). Otherwise it will return false.
     */
    inline bool hasBAngleMark () const;

    /**
     * Returns the value of the member "bAngleMark".
     *
     * This will decide whether the angle mark status has to be displayed or not
     *
     * @return The value of the field "bAngleMark"
     */
    inline bool getBAngleMark () const;

    /**
     * Sets the value of the member "bAngleMark".
     *
     * This will decide whether the angle mark status has to be displayed or not
     *
     * @param bAngleMark The value which will be set
     */
    inline void setBAngleMark (bool bAngleMark_);

    static const AngleMarkSettingStatus &getDefaultInstance();

private:

    inline void set_has_bAngleMark ();

    inline void clear_has_bAngleMark ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bAngleMark;

};

/**
 * The set message of the property "AngleMarkSetting"
 * This will decide whether the angle mark status has to be displayed or not ,can be set during playback.
 */
class AngleMarkSettingSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AngleMarkSettingSet ();

    /**
     * Copy constructor
     */
    inline  AngleMarkSettingSet (const AngleMarkSettingSet &rhs);

    /**
     * All fields constructor
     */
    inline  AngleMarkSettingSet (bool bAngleMark_);

    /**
     * Destructor
     */
    inline virtual  ~AngleMarkSettingSet();

    /**
     * Assignment operator
     */
    inline AngleMarkSettingSet& operator = (const AngleMarkSettingSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AngleMarkSettingSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AngleMarkSettingSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AngleMarkSettingSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AngleMarkSettingSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAngleMark"

    static const int kBAngleMark = 0;

    /**
     * Clears the field "bAngleMark".
     *
     * The field will be set to its default value. The hasBAngleMark()
     * method will return false.
     */
    inline void clearBAngleMark();

    /**
     * Checks whether the field "bAngleMark" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAngleMark()). Otherwise it will return false.
     */
    inline bool hasBAngleMark () const;

    /**
     * Returns the value of the member "bAngleMark".
     *
     * This will decide whether the angle mark status has to be displayed or not
     *
     * @return The value of the field "bAngleMark"
     */
    inline bool getBAngleMark () const;

    /**
     * Sets the value of the member "bAngleMark".
     *
     * This will decide whether the angle mark status has to be displayed or not
     *
     * @param bAngleMark The value which will be set
     */
    inline void setBAngleMark (bool bAngleMark_);

    static const AngleMarkSettingSet &getDefaultInstance();

private:

    inline void set_has_bAngleMark ();

    inline void clear_has_bAngleMark ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bAngleMark;

};

/**
 * The status message of the property "PlayStatusSetting"
 * This will decide whether the play status has to be displayed or not ,can be set during playback.
 */
class PlayStatusSettingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlayStatusSettingStatus ();

    /**
     * Copy constructor
     */
    inline  PlayStatusSettingStatus (const PlayStatusSettingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PlayStatusSettingStatus (bool bPlayStatus_);

    /**
     * Destructor
     */
    inline virtual  ~PlayStatusSettingStatus();

    /**
     * Assignment operator
     */
    inline PlayStatusSettingStatus& operator = (const PlayStatusSettingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayStatusSettingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayStatusSettingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayStatusSettingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayStatusSettingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bPlayStatus"

    static const int kBPlayStatus = 0;

    /**
     * Clears the field "bPlayStatus".
     *
     * The field will be set to its default value. The hasBPlayStatus()
     * method will return false.
     */
    inline void clearBPlayStatus();

    /**
     * Checks whether the field "bPlayStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPlayStatus()). Otherwise it will return false.
     */
    inline bool hasBPlayStatus () const;

    /**
     * Returns the value of the member "bPlayStatus".
     *
     * This will decide whether the play status has to be displayed or not
     *
     * @return The value of the field "bPlayStatus"
     */
    inline bool getBPlayStatus () const;

    /**
     * Sets the value of the member "bPlayStatus".
     *
     * This will decide whether the play status has to be displayed or not
     *
     * @param bPlayStatus The value which will be set
     */
    inline void setBPlayStatus (bool bPlayStatus_);

    static const PlayStatusSettingStatus &getDefaultInstance();

private:

    inline void set_has_bPlayStatus ();

    inline void clear_has_bPlayStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bPlayStatus;

};

/**
 * The set message of the property "PlayStatusSetting"
 * This will decide whether the play status has to be displayed or not ,can be set during playback.
 */
class PlayStatusSettingSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlayStatusSettingSet ();

    /**
     * Copy constructor
     */
    inline  PlayStatusSettingSet (const PlayStatusSettingSet &rhs);

    /**
     * All fields constructor
     */
    inline  PlayStatusSettingSet (bool bPlayStatus_);

    /**
     * Destructor
     */
    inline virtual  ~PlayStatusSettingSet();

    /**
     * Assignment operator
     */
    inline PlayStatusSettingSet& operator = (const PlayStatusSettingSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayStatusSettingSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayStatusSettingSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayStatusSettingSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayStatusSettingSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bPlayStatus"

    static const int kBPlayStatus = 0;

    /**
     * Clears the field "bPlayStatus".
     *
     * The field will be set to its default value. The hasBPlayStatus()
     * method will return false.
     */
    inline void clearBPlayStatus();

    /**
     * Checks whether the field "bPlayStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPlayStatus()). Otherwise it will return false.
     */
    inline bool hasBPlayStatus () const;

    /**
     * Returns the value of the member "bPlayStatus".
     *
     * This will decide whether the play status has to be displayed or not
     *
     * @return The value of the field "bPlayStatus"
     */
    inline bool getBPlayStatus () const;

    /**
     * Sets the value of the member "bPlayStatus".
     *
     * This will decide whether the play status has to be displayed or not
     *
     * @param bPlayStatus The value which will be set
     */
    inline void setBPlayStatus (bool bPlayStatus_);

    static const PlayStatusSettingSet &getDefaultInstance();

private:

    inline void set_has_bPlayStatus ();

    inline void clear_has_bPlayStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bPlayStatus;

};

/**
 * The status message of the property "DRCSetting"
 * This will set the dynamic range compression value of the disc playing,can be set during playback.
 */
class DRCSettingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DRCSettingStatus ();

    /**
     * Copy constructor
     */
    inline  DRCSettingStatus (const DRCSettingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DRCSettingStatus (::MPlay_fi_types::T_e8_MDRCSetting e8DRCSetting_);

    /**
     * Destructor
     */
    inline virtual  ~DRCSettingStatus();

    /**
     * Assignment operator
     */
    inline DRCSettingStatus& operator = (const DRCSettingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DRCSettingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DRCSettingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DRCSettingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DRCSettingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DRCSetting"

    static const int kE8DRCSetting = 0;

    /**
     * Clears the field "e8DRCSetting".
     *
     * The field will be set to its default value. The hasE8DRCSetting()
     * method will return false.
     */
    inline void clearE8DRCSetting();

    /**
     * Checks whether the field "e8DRCSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DRCSetting()). Otherwise it will return false.
     */
    inline bool hasE8DRCSetting () const;

    /**
     * Returns the value of the member "e8DRCSetting".
     *
     * This will set the dynamic range compression value of the disc playing
     *
     * @return The value of the field "e8DRCSetting"
     */
    inline ::MPlay_fi_types::T_e8_MDRCSetting getE8DRCSetting () const;

    /**
     * Sets the value of the member "e8DRCSetting".
     *
     * This will set the dynamic range compression value of the disc playing
     *
     * @param e8DRCSetting The value which will be set
     */
    inline void setE8DRCSetting (::MPlay_fi_types::T_e8_MDRCSetting e8DRCSetting_);

    static const DRCSettingStatus &getDefaultInstance();

private:

    inline void set_has_e8DRCSetting ();

    inline void clear_has_e8DRCSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MDRCSetting _e8DRCSetting;

};

/**
 * The set message of the property "DRCSetting"
 * This will set the dynamic range compression value of the disc playing,can be set during playback.
 */
class DRCSettingSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DRCSettingSet ();

    /**
     * Copy constructor
     */
    inline  DRCSettingSet (const DRCSettingSet &rhs);

    /**
     * All fields constructor
     */
    inline  DRCSettingSet (::MPlay_fi_types::T_e8_MDRCSetting e8DRCSetting_);

    /**
     * Destructor
     */
    inline virtual  ~DRCSettingSet();

    /**
     * Assignment operator
     */
    inline DRCSettingSet& operator = (const DRCSettingSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DRCSettingSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DRCSettingSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DRCSettingSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DRCSettingSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DRCSetting"

    static const int kE8DRCSetting = 0;

    /**
     * Clears the field "e8DRCSetting".
     *
     * The field will be set to its default value. The hasE8DRCSetting()
     * method will return false.
     */
    inline void clearE8DRCSetting();

    /**
     * Checks whether the field "e8DRCSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DRCSetting()). Otherwise it will return false.
     */
    inline bool hasE8DRCSetting () const;

    /**
     * Returns the value of the member "e8DRCSetting".
     *
     * This will set the dynamic range compression value of the disc playing
     *
     * @return The value of the field "e8DRCSetting"
     */
    inline ::MPlay_fi_types::T_e8_MDRCSetting getE8DRCSetting () const;

    /**
     * Sets the value of the member "e8DRCSetting".
     *
     * This will set the dynamic range compression value of the disc playing
     *
     * @param e8DRCSetting The value which will be set
     */
    inline void setE8DRCSetting (::MPlay_fi_types::T_e8_MDRCSetting e8DRCSetting_);

    static const DRCSettingSet &getDefaultInstance();

private:

    inline void set_has_e8DRCSetting ();

    inline void clear_has_e8DRCSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MDRCSetting _e8DRCSetting;

};

/**
 * The status message of the property "DVDCommandStatus"
 * This will get command error message.
 */
class DVDCommandStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DVDCommandStatusStatus ();

    /**
     * Copy constructor
     */
    inline  DVDCommandStatusStatus (const DVDCommandStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DVDCommandStatusStatus (::MPlay_fi_types::T_e8_DVDCommandStatus e8CommandStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DVDCommandStatusStatus();

    /**
     * Assignment operator
     */
    inline DVDCommandStatusStatus& operator = (const DVDCommandStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DVDCommandStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DVDCommandStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DVDCommandStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DVDCommandStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8CommandStatus"

    static const int kE8CommandStatus = 0;

    /**
     * Clears the field "e8CommandStatus".
     *
     * The field will be set to its default value. The hasE8CommandStatus()
     * method will return false.
     */
    inline void clearE8CommandStatus();

    /**
     * Checks whether the field "e8CommandStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CommandStatus()). Otherwise it will return false.
     */
    inline bool hasE8CommandStatus () const;

    /**
     * Returns the value of the member "e8CommandStatus".
     *
     * return command error message
     *
     * @return The value of the field "e8CommandStatus"
     */
    inline ::MPlay_fi_types::T_e8_DVDCommandStatus getE8CommandStatus () const;

    /**
     * Sets the value of the member "e8CommandStatus".
     *
     * return command error message
     *
     * @param e8CommandStatus The value which will be set
     */
    inline void setE8CommandStatus (::MPlay_fi_types::T_e8_DVDCommandStatus e8CommandStatus_);

    static const DVDCommandStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8CommandStatus ();

    inline void clear_has_e8CommandStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_DVDCommandStatus _e8CommandStatus;

};

/**
 * The status message of the property "AutoRipping"
 * The AutoRipping property directs mediaplayer to start or stops the ripping process.
 * The behaviour of the property is as follows:
 * if autoripping option is set to true and if the user inserts cdda, then the ripping will be started automatically.
 * if autoripping option is set to true and if the  cdda playback is ongoing, then the ripping will not be started automatically until the user re insert the disc or
 * user does a ignition off on cycle.
 * if autoripping option is set to false and if the user inserts cdda, then the ripping will not be started and mediaplayer will start the playback of the disc.
 * if autoripping option is set to false and if the ripping is going on, ripping will be stopped immediatly and mediaplayer starts the playback of the disc.
 */
class AutoRippingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutoRippingStatus ();

    /**
     * Copy constructor
     */
    inline  AutoRippingStatus (const AutoRippingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AutoRippingStatus (bool bAutoRipping_);

    /**
     * Destructor
     */
    inline virtual  ~AutoRippingStatus();

    /**
     * Assignment operator
     */
    inline AutoRippingStatus& operator = (const AutoRippingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoRippingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoRippingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoRippingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoRippingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAutoRipping"

    static const int kBAutoRipping = 0;

    /**
     * Clears the field "bAutoRipping".
     *
     * The field will be set to its default value. The hasBAutoRipping()
     * method will return false.
     */
    inline void clearBAutoRipping();

    /**
     * Checks whether the field "bAutoRipping" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutoRipping()). Otherwise it will return false.
     */
    inline bool hasBAutoRipping () const;

    /**
     * Returns the value of the member "bAutoRipping".
     *
     * <p>TRUE: the ripping process will be started when the cdda is inserted.</p>
     * <p>FALSE:  Will disable the autoripping</p>
     *
     * @return The value of the field "bAutoRipping"
     */
    inline bool getBAutoRipping () const;

    /**
     * Sets the value of the member "bAutoRipping".
     *
     * <p>TRUE: the ripping process will be started when the cdda is inserted.</p>
     * <p>FALSE:  Will disable the autoripping</p>
     *
     * @param bAutoRipping The value which will be set
     */
    inline void setBAutoRipping (bool bAutoRipping_);

    static const AutoRippingStatus &getDefaultInstance();

private:

    inline void set_has_bAutoRipping ();

    inline void clear_has_bAutoRipping ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bAutoRipping;

};

/**
 * The set message of the property "AutoRipping"
 * The AutoRipping property directs mediaplayer to start or stops the ripping process.
 * The behaviour of the property is as follows:
 * if autoripping option is set to true and if the user inserts cdda, then the ripping will be started automatically.
 * if autoripping option is set to true and if the  cdda playback is ongoing, then the ripping will not be started automatically until the user re insert the disc or
 * user does a ignition off on cycle.
 * if autoripping option is set to false and if the user inserts cdda, then the ripping will not be started and mediaplayer will start the playback of the disc.
 * if autoripping option is set to false and if the ripping is going on, ripping will be stopped immediatly and mediaplayer starts the playback of the disc.
 */
class AutoRippingSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutoRippingSet ();

    /**
     * Copy constructor
     */
    inline  AutoRippingSet (const AutoRippingSet &rhs);

    /**
     * All fields constructor
     */
    inline  AutoRippingSet (bool bAutoRipping_);

    /**
     * Destructor
     */
    inline virtual  ~AutoRippingSet();

    /**
     * Assignment operator
     */
    inline AutoRippingSet& operator = (const AutoRippingSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoRippingSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoRippingSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoRippingSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoRippingSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAutoRipping"

    static const int kBAutoRipping = 0;

    /**
     * Clears the field "bAutoRipping".
     *
     * The field will be set to its default value. The hasBAutoRipping()
     * method will return false.
     */
    inline void clearBAutoRipping();

    /**
     * Checks whether the field "bAutoRipping" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutoRipping()). Otherwise it will return false.
     */
    inline bool hasBAutoRipping () const;

    /**
     * Returns the value of the member "bAutoRipping".
     *
     * <p>TRUE: the ripping process will be started when the cdda is inserted.</p>
     * <p>FALSE:  Will disable the autoripping</p>
     *
     * @return The value of the field "bAutoRipping"
     */
    inline bool getBAutoRipping () const;

    /**
     * Sets the value of the member "bAutoRipping".
     *
     * <p>TRUE: the ripping process will be started when the cdda is inserted.</p>
     * <p>FALSE:  Will disable the autoripping</p>
     *
     * @param bAutoRipping The value which will be set
     */
    inline void setBAutoRipping (bool bAutoRipping_);

    static const AutoRippingSet &getDefaultInstance();

private:

    inline void set_has_bAutoRipping ();

    inline void clear_has_bAutoRipping ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bAutoRipping;

};

/**
 * The status message of the property "GracenoteLookupMode"
 * Clients uses this property to inform mediaplayer about the preferred  look up mode(online or offline mode) for the gracenote SDK.
 */
class GracenoteLookupModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GracenoteLookupModeStatus ();

    /**
     * Copy constructor
     */
    inline  GracenoteLookupModeStatus (const GracenoteLookupModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GracenoteLookupModeStatus (bool bLookupMode_);

    /**
     * Destructor
     */
    inline virtual  ~GracenoteLookupModeStatus();

    /**
     * Assignment operator
     */
    inline GracenoteLookupModeStatus& operator = (const GracenoteLookupModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GracenoteLookupModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GracenoteLookupModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GracenoteLookupModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GracenoteLookupModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bLookupMode"

    static const int kBLookupMode = 0;

    /**
     * Clears the field "bLookupMode".
     *
     * The field will be set to its default value. The hasBLookupMode()
     * method will return false.
     */
    inline void clearBLookupMode();

    /**
     * Checks whether the field "bLookupMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBLookupMode()). Otherwise it will return false.
     */
    inline bool hasBLookupMode () const;

    /**
     * Returns the value of the member "bLookupMode".
     *
     * <p>TRUE :  Directs the mediaplayer to use online lookup mode of gracenote SDK to get the cd metadata</p>
     * <p>FALSE: Directs the mediaplayer to use offline lookup mode of gracenote SDK to get the cd metadata.</p>
     *
     * @return The value of the field "bLookupMode"
     */
    inline bool getBLookupMode () const;

    /**
     * Sets the value of the member "bLookupMode".
     *
     * <p>TRUE :  Directs the mediaplayer to use online lookup mode of gracenote SDK to get the cd metadata</p>
     * <p>FALSE: Directs the mediaplayer to use offline lookup mode of gracenote SDK to get the cd metadata.</p>
     *
     * @param bLookupMode The value which will be set
     */
    inline void setBLookupMode (bool bLookupMode_);

    static const GracenoteLookupModeStatus &getDefaultInstance();

private:

    inline void set_has_bLookupMode ();

    inline void clear_has_bLookupMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bLookupMode;

};

/**
 * The set message of the property "GracenoteLookupMode"
 * Clients uses this property to inform mediaplayer about the preferred  look up mode(online or offline mode) for the gracenote SDK.
 */
class GracenoteLookupModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GracenoteLookupModeSet ();

    /**
     * Copy constructor
     */
    inline  GracenoteLookupModeSet (const GracenoteLookupModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  GracenoteLookupModeSet (bool bLookupMode_);

    /**
     * Destructor
     */
    inline virtual  ~GracenoteLookupModeSet();

    /**
     * Assignment operator
     */
    inline GracenoteLookupModeSet& operator = (const GracenoteLookupModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GracenoteLookupModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GracenoteLookupModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GracenoteLookupModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GracenoteLookupModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bLookupMode"

    static const int kBLookupMode = 0;

    /**
     * Clears the field "bLookupMode".
     *
     * The field will be set to its default value. The hasBLookupMode()
     * method will return false.
     */
    inline void clearBLookupMode();

    /**
     * Checks whether the field "bLookupMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBLookupMode()). Otherwise it will return false.
     */
    inline bool hasBLookupMode () const;

    /**
     * Returns the value of the member "bLookupMode".
     *
     * <p>TRUE : The Gracenote SDK checks whether the metadata is available offline, if not present the Gracenote SDK uses the online lookup mode to get the cd metadata</p>
     * <p>FALSE: Directs the mediaplayer to use offline lookup mode of gracenote SDK to get the cd metadata.</p>
     *
     * @return The value of the field "bLookupMode"
     */
    inline bool getBLookupMode () const;

    /**
     * Sets the value of the member "bLookupMode".
     *
     * <p>TRUE : The Gracenote SDK checks whether the metadata is available offline, if not present the Gracenote SDK uses the online lookup mode to get the cd metadata</p>
     * <p>FALSE: Directs the mediaplayer to use offline lookup mode of gracenote SDK to get the cd metadata.</p>
     *
     * @param bLookupMode The value which will be set
     */
    inline void setBLookupMode (bool bLookupMode_);

    static const GracenoteLookupModeSet &getDefaultInstance();

private:

    inline void set_has_bLookupMode ();

    inline void clear_has_bLookupMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bLookupMode;

};

/**
 * The status message of the property "GracenoteVersion"
 * Gets the gracenote SDK version used to get the cd metadata.
 */
class GracenoteVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GracenoteVersionStatus ();

    /**
     * Copy constructor
     */
    inline  GracenoteVersionStatus (const GracenoteVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GracenoteVersionStatus (const ::std::string& sVersion_);

    /**
     * Destructor
     */
    inline virtual  ~GracenoteVersionStatus();

    /**
     * Assignment operator
     */
    inline GracenoteVersionStatus& operator = (const GracenoteVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GracenoteVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GracenoteVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GracenoteVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GracenoteVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sVersion"

    static const int kSVersion = 0;

    /**
     * Clears the field "sVersion".
     *
     * The field will be set to its default value. The hasSVersion()
     * method will return false.
     */
    inline void clearSVersion();

    /**
     * Checks whether the field "sVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSVersion()). Otherwise it will return false.
     */
    inline bool hasSVersion () const;

    /**
     * Returns the value of the member "sVersion".
     *
     * The version of the gracenote sdk used to get the cd metadata.
     *
     * @return The value of the field "sVersion"
     */
    inline const ::std::string& getSVersion () const;

    /**
     * Retrieves the value of the field "sVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sVersion".
     */
    inline ::std::string& getSVersionMutable ();

    /**
     * Sets the value of the member "sVersion".
     *
     * The version of the gracenote sdk used to get the cd metadata.
     *
     * @param sVersion The value which will be set
     */
    inline void setSVersion (const ::std::string& sVersion_);

    /**
     * Sets the value of the member "sVersion".
     *
     * The version of the gracenote sdk used to get the cd metadata.
     *
     * @param sVersion The value which will be set
     */
    inline void setSVersion (const char* sVersion_);

    /**
     * Sets the value of the member "sVersion".
     *
     * The version of the gracenote sdk used to get the cd metadata.
     *
     * @param sVersion The value which will be set
     */
    inline void setSVersion (const char* value, size_t size);

    static const GracenoteVersionStatus &getDefaultInstance();

private:

    inline void set_has_sVersion ();

    inline void clear_has_sVersion ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _sVersion;

};

/**
 * The status message of the property "RippingErrors"
 * The RippingErrors property indicates the errors encountered during the ripping operation for a connected device.
 */
class RippingErrorsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RippingErrorsStatus ();

    /**
     * Copy constructor
     */
    inline  RippingErrorsStatus (const RippingErrorsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RippingErrorsStatus (::MPlay_fi_types::T_MPlayRippingErrors oRippingErrors_);

    /**
     * Destructor
     */
    inline virtual  ~RippingErrorsStatus();

    /**
     * Assignment operator
     */
    inline RippingErrorsStatus& operator = (const RippingErrorsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RippingErrorsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RippingErrorsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RippingErrorsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RippingErrorsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oRippingErrors"

    static const int kORippingErrors = 0;

    /**
     * Clears the field "oRippingErrors".
     *
     * The field will be set to its default value. The hasORippingErrors()
     * method will return false.
     */
    inline void clearORippingErrors();

    /**
     * Checks whether the field "oRippingErrors" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setORippingErrors()). Otherwise it will return false.
     */
    inline bool hasORippingErrors () const;

    /**
     * Returns the value of the member "oRippingErrors".
     *
     * The version of the gracenote sdk used to get the cd metadata.
     *
     * @return The value of the field "oRippingErrors"
     */
    inline ::MPlay_fi_types::T_MPlayRippingErrors getORippingErrors () const;

    /**
     * Sets the value of the member "oRippingErrors".
     *
     * The version of the gracenote sdk used to get the cd metadata.
     *
     * @param oRippingErrors The value which will be set
     */
    inline void setORippingErrors (::MPlay_fi_types::T_MPlayRippingErrors oRippingErrors_);

    static const RippingErrorsStatus &getDefaultInstance();

private:

    inline void set_has_oRippingErrors ();

    inline void clear_has_oRippingErrors ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_MPlayRippingErrors _oRippingErrors;

};

/**
 * The status message of the property "ResolveGracenoteAmbuiguities"
 * If the gracenote SDK finds more than one matching albums for a CDID(TOC),
 * then the user has to select which one album from the list of albums returned from gracenote.
 */
class ResolveGracenoteAmbuiguitiesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResolveGracenoteAmbuiguitiesStatus ();

    /**
     * Copy constructor
     */
    inline  ResolveGracenoteAmbuiguitiesStatus (const ResolveGracenoteAmbuiguitiesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ResolveGracenoteAmbuiguitiesStatus (const ::std::string& sTOC_, const ::MPlay_fi_types::T_MPlayMediaAlbums& oAlbums_);

    /**
     * Destructor
     */
    inline virtual  ~ResolveGracenoteAmbuiguitiesStatus();

    /**
     * Assignment operator
     */
    inline ResolveGracenoteAmbuiguitiesStatus& operator = (const ResolveGracenoteAmbuiguitiesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResolveGracenoteAmbuiguitiesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResolveGracenoteAmbuiguitiesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResolveGracenoteAmbuiguitiesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResolveGracenoteAmbuiguitiesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sTOC"

    static const int kSTOC = 0;

    /**
     * Clears the field "sTOC".
     *
     * The field will be set to its default value. The hasSTOC()
     * method will return false.
     */
    inline void clearSTOC();

    /**
     * Checks whether the field "sTOC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTOC()). Otherwise it will return false.
     */
    inline bool hasSTOC () const;

    /**
     * Returns the value of the member "sTOC".
     *
     * TOC of the inserted CDDA disc.
     *
     * @return The value of the field "sTOC"
     */
    inline const ::std::string& getSTOC () const;

    /**
     * Retrieves the value of the field "sTOC" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTOC".
     */
    inline ::std::string& getSTOCMutable ();

    /**
     * Sets the value of the member "sTOC".
     *
     * TOC of the inserted CDDA disc.
     *
     * @param sTOC The value which will be set
     */
    inline void setSTOC (const ::std::string& sTOC_);

    /**
     * Sets the value of the member "sTOC".
     *
     * TOC of the inserted CDDA disc.
     *
     * @param sTOC The value which will be set
     */
    inline void setSTOC (const char* sTOC_);

    /**
     * Sets the value of the member "sTOC".
     *
     * TOC of the inserted CDDA disc.
     *
     * @param sTOC The value which will be set
     */
    inline void setSTOC (const char* value, size_t size);

    // API of field "oAlbums"

    static const int kOAlbums = 1;

    /**
     * Clears the field "oAlbums".
     *
     * The field will be set to its default value. The hasOAlbums()
     * method will return false.
     */
    inline void clearOAlbums();

    /**
     * Checks whether the field "oAlbums" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOAlbums()). Otherwise it will return false.
     */
    inline bool hasOAlbums () const;

    /**
     * Returns the value of the member "oAlbums".
     *
     * List of albums returned from gracenote. The user has to select one of the album title and pass it to mediaplayer in the method 'ExtractGracenoteMetadata'
     *
     * @return The value of the field "oAlbums"
     */
    inline const ::MPlay_fi_types::T_MPlayMediaAlbums& getOAlbums () const;

    /**
     * Retrieves the value of the field "oAlbums" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oAlbums".
     */
    inline ::MPlay_fi_types::T_MPlayMediaAlbums& getOAlbumsMutable ();

    /**
     * Sets the value of the member "oAlbums".
     *
     * List of albums returned from gracenote. The user has to select one of the album title and pass it to mediaplayer in the method 'ExtractGracenoteMetadata'
     *
     * @param oAlbums The value which will be set
     */
    inline void setOAlbums (const ::MPlay_fi_types::T_MPlayMediaAlbums& oAlbums_);

    static const ResolveGracenoteAmbuiguitiesStatus &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_sTOC ();

    inline void clear_has_sTOC ();

    inline void set_has_oAlbums ();

    inline void clear_has_oAlbums ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sTOC;

    ::MPlay_fi_types::T_MPlayMediaAlbums _oAlbums;

};

/**
 * The status message of the property "DVDMenuPlaybackOngoing"
 * This will give whether the current playing file is a menu screen or not
 */
class DVDMenuPlaybackOngoingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DVDMenuPlaybackOngoingStatus ();

    /**
     * Copy constructor
     */
    inline  DVDMenuPlaybackOngoingStatus (const DVDMenuPlaybackOngoingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DVDMenuPlaybackOngoingStatus (bool bDVDMenuPlaybackOngoing_);

    /**
     * Destructor
     */
    inline virtual  ~DVDMenuPlaybackOngoingStatus();

    /**
     * Assignment operator
     */
    inline DVDMenuPlaybackOngoingStatus& operator = (const DVDMenuPlaybackOngoingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DVDMenuPlaybackOngoingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DVDMenuPlaybackOngoingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DVDMenuPlaybackOngoingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DVDMenuPlaybackOngoingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bDVDMenuPlaybackOngoing"

    static const int kBDVDMenuPlaybackOngoing = 0;

    /**
     * Clears the field "bDVDMenuPlaybackOngoing".
     *
     * The field will be set to its default value. The hasBDVDMenuPlaybackOngoing()
     * method will return false.
     */
    inline void clearBDVDMenuPlaybackOngoing();

    /**
     * Checks whether the field "bDVDMenuPlaybackOngoing" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDVDMenuPlaybackOngoing()). Otherwise it will return false.
     */
    inline bool hasBDVDMenuPlaybackOngoing () const;

    /**
     * Returns the value of the member "bDVDMenuPlaybackOngoing".
     *
     * This will whether the current playing file is a menu screen or not
     *
     * @return The value of the field "bDVDMenuPlaybackOngoing"
     */
    inline bool getBDVDMenuPlaybackOngoing () const;

    /**
     * Sets the value of the member "bDVDMenuPlaybackOngoing".
     *
     * This will whether the current playing file is a menu screen or not
     *
     * @param bDVDMenuPlaybackOngoing The value which will be set
     */
    inline void setBDVDMenuPlaybackOngoing (bool bDVDMenuPlaybackOngoing_);

    static const DVDMenuPlaybackOngoingStatus &getDefaultInstance();

private:

    inline void set_has_bDVDMenuPlaybackOngoing ();

    inline void clear_has_bDVDMenuPlaybackOngoing ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bDVDMenuPlaybackOngoing;

};

/**
 * The status message of the property "DVDDriveInfo"
 * This will give dvd drive info necessary for device manager
 */
class DVDDriveInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DVDDriveInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DVDDriveInfoStatus (const DVDDriveInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DVDDriveInfoStatus (::MPlay_fi_types::T_e8_MDVDDiscType e8DVDDiscType_, ::MPlay_fi_types::T_e8_MDVDDriveMode e8DVDDriveMode_);

    /**
     * Destructor
     */
    inline virtual  ~DVDDriveInfoStatus();

    /**
     * Assignment operator
     */
    inline DVDDriveInfoStatus& operator = (const DVDDriveInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DVDDriveInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DVDDriveInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DVDDriveInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DVDDriveInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DVDDiscType"

    static const int kE8DVDDiscType = 0;

    /**
     * Clears the field "e8DVDDiscType".
     *
     * The field will be set to its default value. The hasE8DVDDiscType()
     * method will return false.
     */
    inline void clearE8DVDDiscType();

    /**
     * Checks whether the field "e8DVDDiscType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DVDDiscType()). Otherwise it will return false.
     */
    inline bool hasE8DVDDiscType () const;

    /**
     * Returns the value of the member "e8DVDDiscType".
     *
     * This will inform whether the disc inserted is Data disc or Non-Data Disc
     *
     * @return The value of the field "e8DVDDiscType"
     */
    inline ::MPlay_fi_types::T_e8_MDVDDiscType getE8DVDDiscType () const;

    /**
     * Sets the value of the member "e8DVDDiscType".
     *
     * This will inform whether the disc inserted is Data disc or Non-Data Disc
     *
     * @param e8DVDDiscType The value which will be set
     */
    inline void setE8DVDDiscType (::MPlay_fi_types::T_e8_MDVDDiscType e8DVDDiscType_);

    // API of field "e8DVDDriveMode"

    static const int kE8DVDDriveMode = 1;

    /**
     * Clears the field "e8DVDDriveMode".
     *
     * The field will be set to its default value. The hasE8DVDDriveMode()
     * method will return false.
     */
    inline void clearE8DVDDriveMode();

    /**
     * Checks whether the field "e8DVDDriveMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DVDDriveMode()). Otherwise it will return false.
     */
    inline bool hasE8DVDDriveMode () const;

    /**
     * Returns the value of the member "e8DVDDriveMode".
     *
     * This will give the drive mode as either BackEnd Mode or MassStorage Mode
     *
     * @return The value of the field "e8DVDDriveMode"
     */
    inline ::MPlay_fi_types::T_e8_MDVDDriveMode getE8DVDDriveMode () const;

    /**
     * Sets the value of the member "e8DVDDriveMode".
     *
     * This will give the drive mode as either BackEnd Mode or MassStorage Mode
     *
     * @param e8DVDDriveMode The value which will be set
     */
    inline void setE8DVDDriveMode (::MPlay_fi_types::T_e8_MDVDDriveMode e8DVDDriveMode_);

    static const DVDDriveInfoStatus &getDefaultInstance();

private:

    inline void set_has_e8DVDDiscType ();

    inline void clear_has_e8DVDDiscType ();

    inline void set_has_e8DVDDriveMode ();

    inline void clear_has_e8DVDDriveMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::MPlay_fi_types::T_e8_MDVDDiscType _e8DVDDiscType;

    ::MPlay_fi_types::T_e8_MDVDDriveMode _e8DVDDriveMode;

};

/**
 * The status message of the property "RippingState"
 * The RippingState property indicates the status of the ripping operation for a connected device.
 */
class RippingStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RippingStateStatus ();

    /**
     * Copy constructor
     */
    inline  RippingStateStatus (const RippingStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RippingStateStatus (const ::MPlay_fi_types::T_MPlayRippingStateResultItem& oRippingStateResult_);

    /**
     * Destructor
     */
    inline virtual  ~RippingStateStatus();

    /**
     * Assignment operator
     */
    inline RippingStateStatus& operator = (const RippingStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RippingStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RippingStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RippingStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RippingStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oRippingStateResult"

    static const int kORippingStateResult = 0;

    /**
     * Clears the field "oRippingStateResult".
     *
     * The field will be set to its default value. The hasORippingStateResult()
     * method will return false.
     */
    inline void clearORippingStateResult();

    /**
     * Checks whether the field "oRippingStateResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setORippingStateResult()). Otherwise it will return false.
     */
    inline bool hasORippingStateResult () const;

    /**
     * Returns the value of the member "oRippingStateResult".
     *
     * Identifies the state of the ripping operation: Not supported, not started, partially ripped, or complete.It also gives details about the total tracks in CD , current ripped index and percentage ripped.
     *
     * @return The value of the field "oRippingStateResult"
     */
    inline const ::MPlay_fi_types::T_MPlayRippingStateResultItem& getORippingStateResult () const;

    /**
     * Retrieves the value of the field "oRippingStateResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oRippingStateResult".
     */
    inline ::MPlay_fi_types::T_MPlayRippingStateResultItem& getORippingStateResultMutable ();

    /**
     * Sets the value of the member "oRippingStateResult".
     *
     * Identifies the state of the ripping operation: Not supported, not started, partially ripped, or complete.It also gives details about the total tracks in CD , current ripped index and percentage ripped.
     *
     * @param oRippingStateResult The value which will be set
     */
    inline void setORippingStateResult (const ::MPlay_fi_types::T_MPlayRippingStateResultItem& oRippingStateResult_);

    static const RippingStateStatus &getDefaultInstance();

private:

    inline void set_has_oRippingStateResult ();

    inline void clear_has_oRippingStateResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_MPlayRippingStateResultItem _oRippingStateResult;

};

/**
 * The status message of the property "RippingEncodingQuality"
 * Interface to get current bit rate and configure the  ripping bit rate. As per HMI spec two bit rate possible 96 and 128 kbps
 */
class RippingEncodingQualityStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RippingEncodingQualityStatus ();

    /**
     * Copy constructor
     */
    inline  RippingEncodingQualityStatus (const RippingEncodingQualityStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RippingEncodingQualityStatus (::MPlay_fi_types::T_e8_MPlayEncodingQuality e8EncodingQuality_);

    /**
     * Destructor
     */
    inline virtual  ~RippingEncodingQualityStatus();

    /**
     * Assignment operator
     */
    inline RippingEncodingQualityStatus& operator = (const RippingEncodingQualityStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RippingEncodingQualityStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RippingEncodingQualityStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RippingEncodingQualityStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RippingEncodingQualityStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8EncodingQuality"

    static const int kE8EncodingQuality = 0;

    /**
     * Clears the field "e8EncodingQuality".
     *
     * The field will be set to its default value. The hasE8EncodingQuality()
     * method will return false.
     */
    inline void clearE8EncodingQuality();

    /**
     * Checks whether the field "e8EncodingQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8EncodingQuality()). Otherwise it will return false.
     */
    inline bool hasE8EncodingQuality () const;

    /**
     * Returns the value of the member "e8EncodingQuality".
     *
     * Encoding quality supported at the moment.
     *
     * @return The value of the field "e8EncodingQuality"
     */
    inline ::MPlay_fi_types::T_e8_MPlayEncodingQuality getE8EncodingQuality () const;

    /**
     * Sets the value of the member "e8EncodingQuality".
     *
     * Encoding quality supported at the moment.
     *
     * @param e8EncodingQuality The value which will be set
     */
    inline void setE8EncodingQuality (::MPlay_fi_types::T_e8_MPlayEncodingQuality e8EncodingQuality_);

    static const RippingEncodingQualityStatus &getDefaultInstance();

private:

    inline void set_has_e8EncodingQuality ();

    inline void clear_has_e8EncodingQuality ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayEncodingQuality _e8EncodingQuality;

};

/**
 * The set message of the property "RippingEncodingQuality"
 * Interface to get current bit rate and configure the  ripping bit rate. As per HMI spec two bit rate possible 96 and 128 kbps
 */
class RippingEncodingQualitySet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RippingEncodingQualitySet ();

    /**
     * Copy constructor
     */
    inline  RippingEncodingQualitySet (const RippingEncodingQualitySet &rhs);

    /**
     * All fields constructor
     */
    inline  RippingEncodingQualitySet (::MPlay_fi_types::T_e8_MPlayEncodingQuality e8EncodingQuality_);

    /**
     * Destructor
     */
    inline virtual  ~RippingEncodingQualitySet();

    /**
     * Assignment operator
     */
    inline RippingEncodingQualitySet& operator = (const RippingEncodingQualitySet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RippingEncodingQualitySet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RippingEncodingQualitySet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RippingEncodingQualitySet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RippingEncodingQualitySet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8EncodingQuality"

    static const int kE8EncodingQuality = 0;

    /**
     * Clears the field "e8EncodingQuality".
     *
     * The field will be set to its default value. The hasE8EncodingQuality()
     * method will return false.
     */
    inline void clearE8EncodingQuality();

    /**
     * Checks whether the field "e8EncodingQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8EncodingQuality()). Otherwise it will return false.
     */
    inline bool hasE8EncodingQuality () const;

    /**
     * Returns the value of the member "e8EncodingQuality".
     *
     * Encoding quality requested by clients
     *
     * @return The value of the field "e8EncodingQuality"
     */
    inline ::MPlay_fi_types::T_e8_MPlayEncodingQuality getE8EncodingQuality () const;

    /**
     * Sets the value of the member "e8EncodingQuality".
     *
     * Encoding quality requested by clients
     *
     * @param e8EncodingQuality The value which will be set
     */
    inline void setE8EncodingQuality (::MPlay_fi_types::T_e8_MPlayEncodingQuality e8EncodingQuality_);

    static const RippingEncodingQualitySet &getDefaultInstance();

private:

    inline void set_has_e8EncodingQuality ();

    inline void clear_has_e8EncodingQuality ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayEncodingQuality _e8EncodingQuality;

};

/**
 * The status message of the property "GNMetadataExtractionStatus"
 * If gracenote metadata is available for album selected by the user, update the metadata
 */
class GNMetadataExtractionStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GNMetadataExtractionStatusStatus ();

    /**
     * Copy constructor
     */
    inline  GNMetadataExtractionStatusStatus (const GNMetadataExtractionStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GNMetadataExtractionStatusStatus (::MPlay_fi_types::T_e8_MPlayGNmetadataExtractionResult e8GNmetadataExtractionResult_);

    /**
     * Destructor
     */
    inline virtual  ~GNMetadataExtractionStatusStatus();

    /**
     * Assignment operator
     */
    inline GNMetadataExtractionStatusStatus& operator = (const GNMetadataExtractionStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GNMetadataExtractionStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GNMetadataExtractionStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GNMetadataExtractionStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GNMetadataExtractionStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8GNmetadataExtractionResult"

    static const int kE8GNmetadataExtractionResult = 0;

    /**
     * Clears the field "e8GNmetadataExtractionResult".
     *
     * The field will be set to its default value. The hasE8GNmetadataExtractionResult()
     * method will return false.
     */
    inline void clearE8GNmetadataExtractionResult();

    /**
     * Checks whether the field "e8GNmetadataExtractionResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8GNmetadataExtractionResult()). Otherwise it will return false.
     */
    inline bool hasE8GNmetadataExtractionResult () const;

    /**
     * Returns the value of the member "e8GNmetadataExtractionResult".
     *
     * Gracenote metadata available and is extracted.
     *
     * @return The value of the field "e8GNmetadataExtractionResult"
     */
    inline ::MPlay_fi_types::T_e8_MPlayGNmetadataExtractionResult getE8GNmetadataExtractionResult () const;

    /**
     * Sets the value of the member "e8GNmetadataExtractionResult".
     *
     * Gracenote metadata available and is extracted.
     *
     * @param e8GNmetadataExtractionResult The value which will be set
     */
    inline void setE8GNmetadataExtractionResult (::MPlay_fi_types::T_e8_MPlayGNmetadataExtractionResult e8GNmetadataExtractionResult_);

    static const GNMetadataExtractionStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8GNmetadataExtractionResult ();

    inline void clear_has_e8GNmetadataExtractionResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayGNmetadataExtractionResult _e8GNmetadataExtractionResult;

};

/**
 * The status message of the property "Language"
 * Set the language
 */
class LanguageStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LanguageStatus ();

    /**
     * Copy constructor
     */
    inline  LanguageStatus (const LanguageStatus &rhs);

    /**
     * All fields constructor
     */
    inline  LanguageStatus (::MPlay_fi_types::T_e8_MPlayLanguage e8Language_);

    /**
     * Destructor
     */
    inline virtual  ~LanguageStatus();

    /**
     * Assignment operator
     */
    inline LanguageStatus& operator = (const LanguageStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LanguageStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LanguageStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LanguageStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LanguageStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Language"

    static const int kE8Language = 0;

    /**
     * Clears the field "e8Language".
     *
     * The field will be set to its default value. The hasE8Language()
     * method will return false.
     */
    inline void clearE8Language();

    /**
     * Checks whether the field "e8Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Language()). Otherwise it will return false.
     */
    inline bool hasE8Language () const;

    /**
     * Returns the value of the member "e8Language".
     *
     * Returns current language.
     *
     * @return The value of the field "e8Language"
     */
    inline ::MPlay_fi_types::T_e8_MPlayLanguage getE8Language () const;

    /**
     * Sets the value of the member "e8Language".
     *
     * Returns current language.
     *
     * @param e8Language The value which will be set
     */
    inline void setE8Language (::MPlay_fi_types::T_e8_MPlayLanguage e8Language_);

    static const LanguageStatus &getDefaultInstance();

private:

    inline void set_has_e8Language ();

    inline void clear_has_e8Language ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayLanguage _e8Language;

};

/**
 * The set message of the property "Language"
 * Set the language
 */
class LanguageSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LanguageSet ();

    /**
     * Copy constructor
     */
    inline  LanguageSet (const LanguageSet &rhs);

    /**
     * All fields constructor
     */
    inline  LanguageSet (::MPlay_fi_types::T_e8_MPlayLanguage e8Language_);

    /**
     * Destructor
     */
    inline virtual  ~LanguageSet();

    /**
     * Assignment operator
     */
    inline LanguageSet& operator = (const LanguageSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LanguageSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LanguageSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LanguageSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LanguageSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Language"

    static const int kE8Language = 0;

    /**
     * Clears the field "e8Language".
     *
     * The field will be set to its default value. The hasE8Language()
     * method will return false.
     */
    inline void clearE8Language();

    /**
     * Checks whether the field "e8Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Language()). Otherwise it will return false.
     */
    inline bool hasE8Language () const;

    /**
     * Returns the value of the member "e8Language".
     *
     * Set the current language.
     *
     * @return The value of the field "e8Language"
     */
    inline ::MPlay_fi_types::T_e8_MPlayLanguage getE8Language () const;

    /**
     * Sets the value of the member "e8Language".
     *
     * Set the current language.
     *
     * @param e8Language The value which will be set
     */
    inline void setE8Language (::MPlay_fi_types::T_e8_MPlayLanguage e8Language_);

    static const LanguageSet &getDefaultInstance();

private:

    inline void set_has_e8Language ();

    inline void clear_has_e8Language ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayLanguage _e8Language;

};

/**
 * The status message of the property "PlaybackRepeatMode"
 * Property to set and read current playback mode and repeat of the media player
 */
class PlaybackRepeatModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlaybackRepeatModeStatus ();

    /**
     * Copy constructor
     */
    inline  PlaybackRepeatModeStatus (const PlaybackRepeatModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PlaybackRepeatModeStatus (::MPlay_fi_types::T_e8_MPlayMode e8Mode_, ::MPlay_fi_types::T_e8_MPlayRepeat e8Repeat_);

    /**
     * Destructor
     */
    inline virtual  ~PlaybackRepeatModeStatus();

    /**
     * Assignment operator
     */
    inline PlaybackRepeatModeStatus& operator = (const PlaybackRepeatModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlaybackRepeatModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlaybackRepeatModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlaybackRepeatModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlaybackRepeatModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Mode"

    static const int kE8Mode = 0;

    /**
     * Clears the field "e8Mode".
     *
     * The field will be set to its default value. The hasE8Mode()
     * method will return false.
     */
    inline void clearE8Mode();

    /**
     * Checks whether the field "e8Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Mode()). Otherwise it will return false.
     */
    inline bool hasE8Mode () const;

    /**
     * Returns the value of the member "e8Mode".
     *
     * Contains the current playback mode, which defines how the MediaPlayer determines the next media object to play.
     *
     * @return The value of the field "e8Mode"
     */
    inline ::MPlay_fi_types::T_e8_MPlayMode getE8Mode () const;

    /**
     * Sets the value of the member "e8Mode".
     *
     * Contains the current playback mode, which defines how the MediaPlayer determines the next media object to play.
     *
     * @param e8Mode The value which will be set
     */
    inline void setE8Mode (::MPlay_fi_types::T_e8_MPlayMode e8Mode_);

    // API of field "e8Repeat"

    static const int kE8Repeat = 1;

    /**
     * Clears the field "e8Repeat".
     *
     * The field will be set to its default value. The hasE8Repeat()
     * method will return false.
     */
    inline void clearE8Repeat();

    /**
     * Checks whether the field "e8Repeat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Repeat()). Otherwise it will return false.
     */
    inline bool hasE8Repeat () const;

    /**
     * Returns the value of the member "e8Repeat".
     *
     * Contains the current repeat mode.
     *
     * @return The value of the field "e8Repeat"
     */
    inline ::MPlay_fi_types::T_e8_MPlayRepeat getE8Repeat () const;

    /**
     * Sets the value of the member "e8Repeat".
     *
     * Contains the current repeat mode.
     *
     * @param e8Repeat The value which will be set
     */
    inline void setE8Repeat (::MPlay_fi_types::T_e8_MPlayRepeat e8Repeat_);

    static const PlaybackRepeatModeStatus &getDefaultInstance();

private:

    inline void set_has_e8Mode ();

    inline void clear_has_e8Mode ();

    inline void set_has_e8Repeat ();

    inline void clear_has_e8Repeat ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayMode _e8Mode;

    ::MPlay_fi_types::T_e8_MPlayRepeat _e8Repeat;

};

/**
 * The set message of the property "PlaybackRepeatMode"
 * Property to set and read current playback mode and repeat of the media player
 */
class PlaybackRepeatModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlaybackRepeatModeSet ();

    /**
     * Copy constructor
     */
    inline  PlaybackRepeatModeSet (const PlaybackRepeatModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  PlaybackRepeatModeSet (::MPlay_fi_types::T_e8_MPlayMode e8Mode_, ::MPlay_fi_types::T_e8_MPlayRepeat e8Repeat_);

    /**
     * Destructor
     */
    inline virtual  ~PlaybackRepeatModeSet();

    /**
     * Assignment operator
     */
    inline PlaybackRepeatModeSet& operator = (const PlaybackRepeatModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlaybackRepeatModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlaybackRepeatModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlaybackRepeatModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlaybackRepeatModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Mode"

    static const int kE8Mode = 0;

    /**
     * Clears the field "e8Mode".
     *
     * The field will be set to its default value. The hasE8Mode()
     * method will return false.
     */
    inline void clearE8Mode();

    /**
     * Checks whether the field "e8Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Mode()). Otherwise it will return false.
     */
    inline bool hasE8Mode () const;

    /**
     * Returns the value of the member "e8Mode".
     *
     * Contains the current playback mode, which defines how the MediaPlayer determines the next media object to play.
     *
     * @return The value of the field "e8Mode"
     */
    inline ::MPlay_fi_types::T_e8_MPlayMode getE8Mode () const;

    /**
     * Sets the value of the member "e8Mode".
     *
     * Contains the current playback mode, which defines how the MediaPlayer determines the next media object to play.
     *
     * @param e8Mode The value which will be set
     */
    inline void setE8Mode (::MPlay_fi_types::T_e8_MPlayMode e8Mode_);

    // API of field "e8Repeat"

    static const int kE8Repeat = 1;

    /**
     * Clears the field "e8Repeat".
     *
     * The field will be set to its default value. The hasE8Repeat()
     * method will return false.
     */
    inline void clearE8Repeat();

    /**
     * Checks whether the field "e8Repeat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Repeat()). Otherwise it will return false.
     */
    inline bool hasE8Repeat () const;

    /**
     * Returns the value of the member "e8Repeat".
     *
     * Contains the current repeat mode.
     *
     * @return The value of the field "e8Repeat"
     */
    inline ::MPlay_fi_types::T_e8_MPlayRepeat getE8Repeat () const;

    /**
     * Sets the value of the member "e8Repeat".
     *
     * Contains the current repeat mode.
     *
     * @param e8Repeat The value which will be set
     */
    inline void setE8Repeat (::MPlay_fi_types::T_e8_MPlayRepeat e8Repeat_);

    static const PlaybackRepeatModeSet &getDefaultInstance();

private:

    inline void set_has_e8Mode ();

    inline void clear_has_e8Mode ();

    inline void set_has_e8Repeat ();

    inline void clear_has_e8Repeat ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayMode _e8Mode;

    ::MPlay_fi_types::T_e8_MPlayRepeat _e8Repeat;

};

/**
 * The status message of the property "SlideshowTime"
 * The current slideshow time of the media player instance
 */
class SlideshowTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SlideshowTimeStatus ();

    /**
     * Copy constructor
     */
    inline  SlideshowTimeStatus (const SlideshowTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SlideshowTimeStatus (uint32 u32Time_);

    /**
     * Destructor
     */
    inline virtual  ~SlideshowTimeStatus();

    /**
     * Assignment operator
     */
    inline SlideshowTimeStatus& operator = (const SlideshowTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SlideshowTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SlideshowTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SlideshowTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SlideshowTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Time"

    static const int kU32Time = 0;

    /**
     * Clears the field "u32Time".
     *
     * The field will be set to its default value. The hasU32Time()
     * method will return false.
     */
    inline void clearU32Time();

    /**
     * Checks whether the field "u32Time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Time()). Otherwise it will return false.
     */
    inline bool hasU32Time () const;

    /**
     * Returns the value of the member "u32Time".
     *
     * Current slideshow time in seconds
     *
     * @return The value of the field "u32Time"
     */
    inline uint32 getU32Time () const;

    /**
     * Sets the value of the member "u32Time".
     *
     * Current slideshow time in seconds
     *
     * @param u32Time The value which will be set
     */
    inline void setU32Time (uint32 u32Time_);

    static const SlideshowTimeStatus &getDefaultInstance();

private:

    inline void set_has_u32Time ();

    inline void clear_has_u32Time ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Time;

};

/**
 * The set message of the property "SlideshowTime"
 * The current slideshow time of the media player instance
 */
class SlideshowTimeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SlideshowTimeSet ();

    /**
     * Copy constructor
     */
    inline  SlideshowTimeSet (const SlideshowTimeSet &rhs);

    /**
     * All fields constructor
     */
    inline  SlideshowTimeSet (uint32 u32Time_);

    /**
     * Destructor
     */
    inline virtual  ~SlideshowTimeSet();

    /**
     * Assignment operator
     */
    inline SlideshowTimeSet& operator = (const SlideshowTimeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SlideshowTimeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SlideshowTimeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SlideshowTimeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SlideshowTimeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Time"

    static const int kU32Time = 0;

    /**
     * Clears the field "u32Time".
     *
     * The field will be set to its default value. The hasU32Time()
     * method will return false.
     */
    inline void clearU32Time();

    /**
     * Checks whether the field "u32Time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Time()). Otherwise it will return false.
     */
    inline bool hasU32Time () const;

    /**
     * Returns the value of the member "u32Time".
     *
     * Time in seconds when the GMP shows the next image.
     * If -1 is set the GMP does not show the next image automatically.
     *
     * @return The value of the field "u32Time"
     */
    inline uint32 getU32Time () const;

    /**
     * Sets the value of the member "u32Time".
     *
     * Time in seconds when the GMP shows the next image.
     * If -1 is set the GMP does not show the next image automatically.
     *
     * @param u32Time The value which will be set
     */
    inline void setU32Time (uint32 u32Time_);

    static const SlideshowTimeSet &getDefaultInstance();

private:

    inline void set_has_u32Time ();

    inline void clear_has_u32Time ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Time;

};

/**
 * The status message of the property "NowShowing"
 * This property identifies all information about the currently showing item.
 * The HMI has to use this information to load, if necessary to convert and to show the current image.
 * Additionally, the next image is delivered to the HMI to realize a preloading mechanism
 */
class NowShowingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NowShowingStatus ();

    /**
     * Copy constructor
     */
    inline  NowShowingStatus (const NowShowingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NowShowingStatus (uint32 u32ListHandle_, ::MPlay_fi_types::T_e8_MPlayNowPlayingState e8NowPlayingState_, uint32 u32Position_, uint32 u32Tag_, const ::MPlay_fi_types::T_MPlayMediaObject& oMediaObject_, const ::std::string& sNextFile_);

    /**
     * Destructor
     */
    inline virtual  ~NowShowingStatus();

    /**
     * Assignment operator
     */
    inline NowShowingStatus& operator = (const NowShowingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NowShowingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NowShowingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NowShowingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NowShowingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer. The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer. The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "e8NowPlayingState"

    static const int kE8NowPlayingState = 1;

    /**
     * Clears the field "e8NowPlayingState".
     *
     * The field will be set to its default value. The hasE8NowPlayingState()
     * method will return false.
     */
    inline void clearE8NowPlayingState();

    /**
     * Checks whether the field "e8NowPlayingState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8NowPlayingState()). Otherwise it will return false.
     */
    inline bool hasE8NowPlayingState () const;

    /**
     * Returns the value of the member "e8NowPlayingState".
     *
     * Describes the state of the active list upon transitions between items in the list.
     *
     * @return The value of the field "e8NowPlayingState"
     */
    inline ::MPlay_fi_types::T_e8_MPlayNowPlayingState getE8NowPlayingState () const;

    /**
     * Sets the value of the member "e8NowPlayingState".
     *
     * Describes the state of the active list upon transitions between items in the list.
     *
     * @param e8NowPlayingState The value which will be set
     */
    inline void setE8NowPlayingState (::MPlay_fi_types::T_e8_MPlayNowPlayingState e8NowPlayingState_);

    // API of field "u32Position"

    static const int kU32Position = 2;

    /**
     * Clears the field "u32Position".
     *
     * The field will be set to its default value. The hasU32Position()
     * method will return false.
     */
    inline void clearU32Position();

    /**
     * Checks whether the field "u32Position" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Position()). Otherwise it will return false.
     */
    inline bool hasU32Position () const;

    /**
     * Returns the value of the member "u32Position".
     *
     * Contains the position (or index) of the item within the specified list starting at 0 for the first element in the list.
     *
     * @return The value of the field "u32Position"
     */
    inline uint32 getU32Position () const;

    /**
     * Sets the value of the member "u32Position".
     *
     * Contains the position (or index) of the item within the specified list starting at 0 for the first element in the list.
     *
     * @param u32Position The value which will be set
     */
    inline void setU32Position (uint32 u32Position_);

    // API of field "u32Tag"

    static const int kU32Tag = 3;

    /**
     * Clears the field "u32Tag".
     *
     * The field will be set to its default value. The hasU32Tag()
     * method will return false.
     */
    inline void clearU32Tag();

    /**
     * Checks whether the field "u32Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Tag()). Otherwise it will return false.
     */
    inline bool hasU32Tag () const;

    /**
     * Returns the value of the member "u32Tag".
     *
     * <p>
     * The Tag value identifies the media object to show.
     * </p>
     *
     * @return The value of the field "u32Tag"
     */
    inline uint32 getU32Tag () const;

    /**
     * Sets the value of the member "u32Tag".
     *
     * <p>
     * The Tag value identifies the media object to show.
     * </p>
     *
     * @param u32Tag The value which will be set
     */
    inline void setU32Tag (uint32 u32Tag_);

    // API of field "oMediaObject"

    static const int kOMediaObject = 4;

    /**
     * Clears the field "oMediaObject".
     *
     * The field will be set to its default value. The hasOMediaObject()
     * method will return false.
     */
    inline void clearOMediaObject();

    /**
     * Checks whether the field "oMediaObject" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMediaObject()). Otherwise it will return false.
     */
    inline bool hasOMediaObject () const;

    /**
     * Returns the value of the member "oMediaObject".
     *
     * All meta-data for that object
     *
     * @return The value of the field "oMediaObject"
     */
    inline const ::MPlay_fi_types::T_MPlayMediaObject& getOMediaObject () const;

    /**
     * Retrieves the value of the field "oMediaObject" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMediaObject".
     */
    inline ::MPlay_fi_types::T_MPlayMediaObject& getOMediaObjectMutable ();

    /**
     * Sets the value of the member "oMediaObject".
     *
     * All meta-data for that object
     *
     * @param oMediaObject The value which will be set
     */
    inline void setOMediaObject (const ::MPlay_fi_types::T_MPlayMediaObject& oMediaObject_);

    // API of field "sNextFile"

    static const int kSNextFile = 5;

    /**
     * Clears the field "sNextFile".
     *
     * The field will be set to its default value. The hasSNextFile()
     * method will return false.
     */
    inline void clearSNextFile();

    /**
     * Checks whether the field "sNextFile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSNextFile()). Otherwise it will return false.
     */
    inline bool hasSNextFile () const;

    /**
     * Returns the value of the member "sNextFile".
     *
     * sNextFile contains the path, filename and mountpoint of the next image.
     * This information can be used by the HMI to preload the next image.
     * It cannot be guaranteed that this is the next showing image.
     *
     * @return The value of the field "sNextFile"
     */
    inline const ::std::string& getSNextFile () const;

    /**
     * Retrieves the value of the field "sNextFile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sNextFile".
     */
    inline ::std::string& getSNextFileMutable ();

    /**
     * Sets the value of the member "sNextFile".
     *
     * sNextFile contains the path, filename and mountpoint of the next image.
     * This information can be used by the HMI to preload the next image.
     * It cannot be guaranteed that this is the next showing image.
     *
     * @param sNextFile The value which will be set
     */
    inline void setSNextFile (const ::std::string& sNextFile_);

    /**
     * Sets the value of the member "sNextFile".
     *
     * sNextFile contains the path, filename and mountpoint of the next image.
     * This information can be used by the HMI to preload the next image.
     * It cannot be guaranteed that this is the next showing image.
     *
     * @param sNextFile The value which will be set
     */
    inline void setSNextFile (const char* sNextFile_);

    /**
     * Sets the value of the member "sNextFile".
     *
     * sNextFile contains the path, filename and mountpoint of the next image.
     * This information can be used by the HMI to preload the next image.
     * It cannot be guaranteed that this is the next showing image.
     *
     * @param sNextFile The value which will be set
     */
    inline void setSNextFile (const char* value, size_t size);

    static const NowShowingStatus &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_e8NowPlayingState ();

    inline void clear_has_e8NowPlayingState ();

    inline void set_has_u32Position ();

    inline void clear_has_u32Position ();

    inline void set_has_u32Tag ();

    inline void clear_has_u32Tag ();

    inline void set_has_oMediaObject ();

    inline void clear_has_oMediaObject ();

    inline void set_has_sNextFile ();

    inline void clear_has_sNextFile ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint32 _u32ListHandle;

    ::MPlay_fi_types::T_e8_MPlayNowPlayingState _e8NowPlayingState;

    uint32 _u32Position;

    uint32 _u32Tag;

    ::MPlay_fi_types::T_MPlayMediaObject _oMediaObject;

    ::std::string _sNextFile;

};

/**
 * The status message of the property "SlideshowState"
 * The current slideshow state of the MediaPlayer
 * PBS_PLAYING: The Media Player is showing an image object. The
 * object being played can be obtained using the NowShowing function
 * PBS_PAUSED: The slideshow is paused
 * PBS_STOPPED: The slideshow is not active.
 */
class SlideshowStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SlideshowStateStatus ();

    /**
     * Copy constructor
     */
    inline  SlideshowStateStatus (const SlideshowStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SlideshowStateStatus (::MPlay_fi_types::T_e8_MPlayState e8State_);

    /**
     * Destructor
     */
    inline virtual  ~SlideshowStateStatus();

    /**
     * Assignment operator
     */
    inline SlideshowStateStatus& operator = (const SlideshowStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SlideshowStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SlideshowStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SlideshowStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SlideshowStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8State"

    static const int kE8State = 0;

    /**
     * Clears the field "e8State".
     *
     * The field will be set to its default value. The hasE8State()
     * method will return false.
     */
    inline void clearE8State();

    /**
     * Checks whether the field "e8State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8State()). Otherwise it will return false.
     */
    inline bool hasE8State () const;

    /**
     * Returns the value of the member "e8State".
     *
     * Slideshow state of the Media Player
     *
     * @return The value of the field "e8State"
     */
    inline ::MPlay_fi_types::T_e8_MPlayState getE8State () const;

    /**
     * Sets the value of the member "e8State".
     *
     * Slideshow state of the Media Player
     *
     * @param e8State The value which will be set
     */
    inline void setE8State (::MPlay_fi_types::T_e8_MPlayState e8State_);

    static const SlideshowStateStatus &getDefaultInstance();

private:

    inline void set_has_e8State ();

    inline void clear_has_e8State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayState _e8State;

};

/**
 * The status message of the property "MediaPlayerOpticalDiscSlotState"
 * Used to notify about the connection status of Optical disks.The Mediaplayer gets this from  VD_Devicemanager which gets the information from
 * VD_Mediamanager component which gets it from osal device cdctrl. Objective is to forward this without further adapter - HMI hsould have interface of mediaplayer
 * as main communication partner.
 */
class MediaPlayerOpticalDiscSlotStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaPlayerOpticalDiscSlotStateStatus ();

    /**
     * Copy constructor
     */
    inline  MediaPlayerOpticalDiscSlotStateStatus (const MediaPlayerOpticalDiscSlotStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MediaPlayerOpticalDiscSlotStateStatus (::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType e8State_);

    /**
     * Destructor
     */
    inline virtual  ~MediaPlayerOpticalDiscSlotStateStatus();

    /**
     * Assignment operator
     */
    inline MediaPlayerOpticalDiscSlotStateStatus& operator = (const MediaPlayerOpticalDiscSlotStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaPlayerOpticalDiscSlotStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaPlayerOpticalDiscSlotStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaPlayerOpticalDiscSlotStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaPlayerOpticalDiscSlotStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8State"

    static const int kE8State = 0;

    /**
     * Clears the field "e8State".
     *
     * The field will be set to its default value. The hasE8State()
     * method will return false.
     */
    inline void clearE8State();

    /**
     * Checks whether the field "e8State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8State()). Otherwise it will return false.
     */
    inline bool hasE8State () const;

    /**
     * Returns the value of the member "e8State".
     *
     * The Optical disk slot states.
     *
     * @return The value of the field "e8State"
     */
    inline ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType getE8State () const;

    /**
     * Sets the value of the member "e8State".
     *
     * The Optical disk slot states.
     *
     * @param e8State The value which will be set
     */
    inline void setE8State (::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType e8State_);

    static const MediaPlayerOpticalDiscSlotStateStatus &getDefaultInstance();

private:

    inline void set_has_e8State ();

    inline void clear_has_e8State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_shared_fi_types::T_e8_SlotStateOpticalDiscType _e8State;

};

/**
 * The status message of the property "MediaPlayerOpticalDiscCDInfo"
 * Used to notify about the CD Info of Optical disks.The Mediaplayer gets this from  VD_Devicemanager which gets the information from
 * VD_Mediamanager component which gets it from osal device cdctrl. Objective is to forward this without further adapter - HMI should have interface of mediaplayer
 * as main communication partner.
 */
class MediaPlayerOpticalDiscCDInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaPlayerOpticalDiscCDInfoStatus ();

    /**
     * Copy constructor
     */
    inline  MediaPlayerOpticalDiscCDInfoStatus (const MediaPlayerOpticalDiscCDInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MediaPlayerOpticalDiscCDInfoStatus (const ::mplay_shared_fi_types::T_e8_CDInfo& CDInfo_);

    /**
     * Destructor
     */
    inline virtual  ~MediaPlayerOpticalDiscCDInfoStatus();

    /**
     * Assignment operator
     */
    inline MediaPlayerOpticalDiscCDInfoStatus& operator = (const MediaPlayerOpticalDiscCDInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaPlayerOpticalDiscCDInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaPlayerOpticalDiscCDInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaPlayerOpticalDiscCDInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaPlayerOpticalDiscCDInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CDInfo"

    static const int kCDInfo = 0;

    /**
     * Clears the field "CDInfo".
     *
     * The field will be set to its default value. The hasCDInfo()
     * method will return false.
     */
    inline void clearCDInfo();

    /**
     * Checks whether the field "CDInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCDInfo()). Otherwise it will return false.
     */
    inline bool hasCDInfo () const;

    /**
     * Returns the value of the member "CDInfo".
     *
     *
     *
     * @return The value of the field "CDInfo"
     */
    inline const ::mplay_shared_fi_types::T_e8_CDInfo& getCDInfo () const;

    /**
     * Retrieves the value of the field "CDInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CDInfo".
     */
    inline ::mplay_shared_fi_types::T_e8_CDInfo& getCDInfoMutable ();

    /**
     * Sets the value of the member "CDInfo".
     *
     *
     *
     * @param CDInfo The value which will be set
     */
    inline void setCDInfo (const ::mplay_shared_fi_types::T_e8_CDInfo& CDInfo_);

    static const MediaPlayerOpticalDiscCDInfoStatus &getDefaultInstance();

private:

    inline void set_has_CDInfo ();

    inline void clear_has_CDInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_shared_fi_types::T_e8_CDInfo _CDInfo;

};

/**
 * The status message of the property "iPodCommunicationError"
 * The iPodCommunicationError property provides update to HMI for any error received by Media Player from apple device for the commands executed.
 */
class IPodCommunicationErrorStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPodCommunicationErrorStatus ();

    /**
     * Copy constructor
     */
    inline  IPodCommunicationErrorStatus (const IPodCommunicationErrorStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IPodCommunicationErrorStatus (uint8 u8DeviceTag_, ::MPlay_fi_types::T_e8_MPlayiPodCommunicationError e8iPodCommunicationError_);

    /**
     * Destructor
     */
    inline virtual  ~IPodCommunicationErrorStatus();

    /**
     * Assignment operator
     */
    inline IPodCommunicationErrorStatus& operator = (const IPodCommunicationErrorStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPodCommunicationErrorStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPodCommunicationErrorStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPodCommunicationErrorStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPodCommunicationErrorStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the iPhone device from where communication errors are received.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the iPhone device from where communication errors are received.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "e8iPodCommunicationError"

    static const int kE8iPodCommunicationError = 1;

    /**
     * Clears the field "e8iPodCommunicationError".
     *
     * The field will be set to its default value. The hasE8iPodCommunicationError()
     * method will return false.
     */
    inline void clearE8iPodCommunicationError();

    /**
     * Checks whether the field "e8iPodCommunicationError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8iPodCommunicationError()). Otherwise it will return false.
     */
    inline bool hasE8iPodCommunicationError () const;

    /**
     * Returns the value of the member "e8iPodCommunicationError".
     *
     * iPod Communication Errors sent by device to MediaPlayer.
     *
     * @return The value of the field "e8iPodCommunicationError"
     */
    inline ::MPlay_fi_types::T_e8_MPlayiPodCommunicationError getE8iPodCommunicationError () const;

    /**
     * Sets the value of the member "e8iPodCommunicationError".
     *
     * iPod Communication Errors sent by device to MediaPlayer.
     *
     * @param e8iPodCommunicationError The value which will be set
     */
    inline void setE8iPodCommunicationError (::MPlay_fi_types::T_e8_MPlayiPodCommunicationError e8iPodCommunicationError_);

    static const IPodCommunicationErrorStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_e8iPodCommunicationError ();

    inline void clear_has_e8iPodCommunicationError ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceTag;

    ::MPlay_fi_types::T_e8_MPlayiPodCommunicationError _e8iPodCommunicationError;

};

/**
 * The status message of the property "DeviceStreamingInfo"
 * The DeviceStreamingInfo property provides update to HMI current streaming status.
 */
class DeviceStreamingInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStreamingInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DeviceStreamingInfoStatus (const DeviceStreamingInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStreamingInfoStatus (::MPlay_fi_types::T_e8_MPlayStreamingInfo e8StreamingInfo_, uint8 u8DeviceTag_, uint8 u8DeviceType_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStreamingInfoStatus();

    /**
     * Assignment operator
     */
    inline DeviceStreamingInfoStatus& operator = (const DeviceStreamingInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStreamingInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStreamingInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStreamingInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStreamingInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8StreamingInfo"

    static const int kE8StreamingInfo = 0;

    /**
     * Clears the field "e8StreamingInfo".
     *
     * The field will be set to its default value. The hasE8StreamingInfo()
     * method will return false.
     */
    inline void clearE8StreamingInfo();

    /**
     * Checks whether the field "e8StreamingInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8StreamingInfo()). Otherwise it will return false.
     */
    inline bool hasE8StreamingInfo () const;

    /**
     * Returns the value of the member "e8StreamingInfo".
     *
     * Streaming Info sent by device to MediaPlayer.
     *
     * @return The value of the field "e8StreamingInfo"
     */
    inline ::MPlay_fi_types::T_e8_MPlayStreamingInfo getE8StreamingInfo () const;

    /**
     * Sets the value of the member "e8StreamingInfo".
     *
     * Streaming Info sent by device to MediaPlayer.
     *
     * @param e8StreamingInfo The value which will be set
     */
    inline void setE8StreamingInfo (::MPlay_fi_types::T_e8_MPlayStreamingInfo e8StreamingInfo_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 1;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Device Tag for the device
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Device Tag for the device
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "u8DeviceType"

    static const int kU8DeviceType = 2;

    /**
     * Clears the field "u8DeviceType".
     *
     * The field will be set to its default value. The hasU8DeviceType()
     * method will return false.
     */
    inline void clearU8DeviceType();

    /**
     * Checks whether the field "u8DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceType()). Otherwise it will return false.
     */
    inline bool hasU8DeviceType () const;

    /**
     * Returns the value of the member "u8DeviceType".
     *
     * Type of Device playback start
     *
     * @return The value of the field "u8DeviceType"
     */
    inline uint8 getU8DeviceType () const;

    /**
     * Sets the value of the member "u8DeviceType".
     *
     * Type of Device playback start
     *
     * @param u8DeviceType The value which will be set
     */
    inline void setU8DeviceType (uint8 u8DeviceType_);

    static const DeviceStreamingInfoStatus &getDefaultInstance();

private:

    inline void set_has_e8StreamingInfo ();

    inline void clear_has_e8StreamingInfo ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_u8DeviceType ();

    inline void clear_has_u8DeviceType ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayStreamingInfo _e8StreamingInfo;

    uint8 _u8DeviceTag;

    uint8 _u8DeviceType;

};

/**
 * The status message of the property "VideoBrightness"
 * Property to set and get the video brightness level of the playable video objects.
 *
 * Valid range of video brightness level is 0-200.
 * Default value of brightness level is 100.
 */
class VideoBrightnessStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoBrightnessStatus ();

    /**
     * Copy constructor
     */
    inline  VideoBrightnessStatus (const VideoBrightnessStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VideoBrightnessStatus (uint8 u8VideoBrightness_);

    /**
     * Destructor
     */
    inline virtual  ~VideoBrightnessStatus();

    /**
     * Assignment operator
     */
    inline VideoBrightnessStatus& operator = (const VideoBrightnessStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoBrightnessStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoBrightnessStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoBrightnessStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoBrightnessStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8VideoBrightness"

    static const int kU8VideoBrightness = 0;

    /**
     * Clears the field "u8VideoBrightness".
     *
     * The field will be set to its default value. The hasU8VideoBrightness()
     * method will return false.
     */
    inline void clearU8VideoBrightness();

    /**
     * Checks whether the field "u8VideoBrightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8VideoBrightness()). Otherwise it will return false.
     */
    inline bool hasU8VideoBrightness () const;

    /**
     * Returns the value of the member "u8VideoBrightness".
     *
     * Video brightness level within range 0-200.
     *
     * @return The value of the field "u8VideoBrightness"
     */
    inline uint8 getU8VideoBrightness () const;

    /**
     * Sets the value of the member "u8VideoBrightness".
     *
     * Video brightness level within range 0-200.
     *
     * @param u8VideoBrightness The value which will be set
     */
    inline void setU8VideoBrightness (uint8 u8VideoBrightness_);

    static const VideoBrightnessStatus &getDefaultInstance();

private:

    inline void set_has_u8VideoBrightness ();

    inline void clear_has_u8VideoBrightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8VideoBrightness;

};

/**
 * The set message of the property "VideoBrightness"
 * Property to set and get the video brightness level of the playable video objects.
 *
 * Valid range of video brightness level is 0-200.
 * Default value of brightness level is 100.
 */
class VideoBrightnessSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoBrightnessSet ();

    /**
     * Copy constructor
     */
    inline  VideoBrightnessSet (const VideoBrightnessSet &rhs);

    /**
     * All fields constructor
     */
    inline  VideoBrightnessSet (uint8 u8VideoBrightness_);

    /**
     * Destructor
     */
    inline virtual  ~VideoBrightnessSet();

    /**
     * Assignment operator
     */
    inline VideoBrightnessSet& operator = (const VideoBrightnessSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoBrightnessSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoBrightnessSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoBrightnessSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoBrightnessSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8VideoBrightness"

    static const int kU8VideoBrightness = 0;

    /**
     * Clears the field "u8VideoBrightness".
     *
     * The field will be set to its default value. The hasU8VideoBrightness()
     * method will return false.
     */
    inline void clearU8VideoBrightness();

    /**
     * Checks whether the field "u8VideoBrightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8VideoBrightness()). Otherwise it will return false.
     */
    inline bool hasU8VideoBrightness () const;

    /**
     * Returns the value of the member "u8VideoBrightness".
     *
     * Video brightness level within range 0-200.
     *
     * @return The value of the field "u8VideoBrightness"
     */
    inline uint8 getU8VideoBrightness () const;

    /**
     * Sets the value of the member "u8VideoBrightness".
     *
     * Video brightness level within range 0-200.
     *
     * @param u8VideoBrightness The value which will be set
     */
    inline void setU8VideoBrightness (uint8 u8VideoBrightness_);

    static const VideoBrightnessSet &getDefaultInstance();

private:

    inline void set_has_u8VideoBrightness ();

    inline void clear_has_u8VideoBrightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8VideoBrightness;

};

/**
 * The status message of the property "VideoHue"
 * Property to set and get the video hue level of the playable video objects.
 *
 * Valid range of video hue level is -180 - +180.
 * Default value of hue level is 0.
 */
class VideoHueStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoHueStatus ();

    /**
     * Copy constructor
     */
    inline  VideoHueStatus (const VideoHueStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VideoHueStatus (int16 s16VideoHue_);

    /**
     * Destructor
     */
    inline virtual  ~VideoHueStatus();

    /**
     * Assignment operator
     */
    inline VideoHueStatus& operator = (const VideoHueStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoHueStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoHueStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoHueStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoHueStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16VideoHue"

    static const int kS16VideoHue = 0;

    /**
     * Clears the field "s16VideoHue".
     *
     * The field will be set to its default value. The hasS16VideoHue()
     * method will return false.
     */
    inline void clearS16VideoHue();

    /**
     * Checks whether the field "s16VideoHue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16VideoHue()). Otherwise it will return false.
     */
    inline bool hasS16VideoHue () const;

    /**
     * Returns the value of the member "s16VideoHue".
     *
     * Video hue level within range -180 - +180.
     *
     * @return The value of the field "s16VideoHue"
     */
    inline int16 getS16VideoHue () const;

    /**
     * Sets the value of the member "s16VideoHue".
     *
     * Video hue level within range -180 - +180.
     *
     * @param s16VideoHue The value which will be set
     */
    inline void setS16VideoHue (int16 s16VideoHue_);

    static const VideoHueStatus &getDefaultInstance();

private:

    inline void set_has_s16VideoHue ();

    inline void clear_has_s16VideoHue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _s16VideoHue;

};

/**
 * The set message of the property "VideoHue"
 * Property to set and get the video hue level of the playable video objects.
 *
 * Valid range of video hue level is -180 - +180.
 * Default value of hue level is 0.
 */
class VideoHueSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoHueSet ();

    /**
     * Copy constructor
     */
    inline  VideoHueSet (const VideoHueSet &rhs);

    /**
     * All fields constructor
     */
    inline  VideoHueSet (int16 s16VideoHue_);

    /**
     * Destructor
     */
    inline virtual  ~VideoHueSet();

    /**
     * Assignment operator
     */
    inline VideoHueSet& operator = (const VideoHueSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoHueSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoHueSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoHueSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoHueSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16VideoHue"

    static const int kS16VideoHue = 0;

    /**
     * Clears the field "s16VideoHue".
     *
     * The field will be set to its default value. The hasS16VideoHue()
     * method will return false.
     */
    inline void clearS16VideoHue();

    /**
     * Checks whether the field "s16VideoHue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16VideoHue()). Otherwise it will return false.
     */
    inline bool hasS16VideoHue () const;

    /**
     * Returns the value of the member "s16VideoHue".
     *
     * Video hue level within range -180 - +180.
     *
     * @return The value of the field "s16VideoHue"
     */
    inline int16 getS16VideoHue () const;

    /**
     * Sets the value of the member "s16VideoHue".
     *
     * Video hue level within range -180 - +180.
     *
     * @param s16VideoHue The value which will be set
     */
    inline void setS16VideoHue (int16 s16VideoHue_);

    static const VideoHueSet &getDefaultInstance();

private:

    inline void set_has_s16VideoHue ();

    inline void clear_has_s16VideoHue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _s16VideoHue;

};

/**
 * The status message of the property "VideoSaturation"
 * Property to set and get the video saturation level of the playable video objects.
 *
 * Valid range of video saturation level is 0 - 200.
 * Default value of saturation level is 100.
 */
class VideoSaturationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoSaturationStatus ();

    /**
     * Copy constructor
     */
    inline  VideoSaturationStatus (const VideoSaturationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VideoSaturationStatus (uint8 u8VideoSaturation_);

    /**
     * Destructor
     */
    inline virtual  ~VideoSaturationStatus();

    /**
     * Assignment operator
     */
    inline VideoSaturationStatus& operator = (const VideoSaturationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoSaturationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoSaturationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoSaturationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoSaturationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8VideoSaturation"

    static const int kU8VideoSaturation = 0;

    /**
     * Clears the field "u8VideoSaturation".
     *
     * The field will be set to its default value. The hasU8VideoSaturation()
     * method will return false.
     */
    inline void clearU8VideoSaturation();

    /**
     * Checks whether the field "u8VideoSaturation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8VideoSaturation()). Otherwise it will return false.
     */
    inline bool hasU8VideoSaturation () const;

    /**
     * Returns the value of the member "u8VideoSaturation".
     *
     * Video saturation level within range 0 - 200.
     *
     * @return The value of the field "u8VideoSaturation"
     */
    inline uint8 getU8VideoSaturation () const;

    /**
     * Sets the value of the member "u8VideoSaturation".
     *
     * Video saturation level within range 0 - 200.
     *
     * @param u8VideoSaturation The value which will be set
     */
    inline void setU8VideoSaturation (uint8 u8VideoSaturation_);

    static const VideoSaturationStatus &getDefaultInstance();

private:

    inline void set_has_u8VideoSaturation ();

    inline void clear_has_u8VideoSaturation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8VideoSaturation;

};

/**
 * The set message of the property "VideoSaturation"
 * Property to set and get the video saturation level of the playable video objects.
 *
 * Valid range of video saturation level is 0 - 200.
 * Default value of saturation level is 100.
 */
class VideoSaturationSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoSaturationSet ();

    /**
     * Copy constructor
     */
    inline  VideoSaturationSet (const VideoSaturationSet &rhs);

    /**
     * All fields constructor
     */
    inline  VideoSaturationSet (uint8 u8VideoSaturation_);

    /**
     * Destructor
     */
    inline virtual  ~VideoSaturationSet();

    /**
     * Assignment operator
     */
    inline VideoSaturationSet& operator = (const VideoSaturationSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoSaturationSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoSaturationSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoSaturationSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoSaturationSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8VideoSaturation"

    static const int kU8VideoSaturation = 0;

    /**
     * Clears the field "u8VideoSaturation".
     *
     * The field will be set to its default value. The hasU8VideoSaturation()
     * method will return false.
     */
    inline void clearU8VideoSaturation();

    /**
     * Checks whether the field "u8VideoSaturation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8VideoSaturation()). Otherwise it will return false.
     */
    inline bool hasU8VideoSaturation () const;

    /**
     * Returns the value of the member "u8VideoSaturation".
     *
     * Video saturation level within range 0 - 200.
     *
     * @return The value of the field "u8VideoSaturation"
     */
    inline uint8 getU8VideoSaturation () const;

    /**
     * Sets the value of the member "u8VideoSaturation".
     *
     * Video saturation level within range 0 - 200.
     *
     * @param u8VideoSaturation The value which will be set
     */
    inline void setU8VideoSaturation (uint8 u8VideoSaturation_);

    static const VideoSaturationSet &getDefaultInstance();

private:

    inline void set_has_u8VideoSaturation ();

    inline void clear_has_u8VideoSaturation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8VideoSaturation;

};

/**
 * The status message of the property "VideoContrast"
 * Property to set and get the video contrast level of the playable video objects.
 *
 * Valid range of video contrast level is 0 - 200.
 * Default value of contrast level is 100.
 */
class VideoContrastStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoContrastStatus ();

    /**
     * Copy constructor
     */
    inline  VideoContrastStatus (const VideoContrastStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VideoContrastStatus (uint8 u8VideoContrast_);

    /**
     * Destructor
     */
    inline virtual  ~VideoContrastStatus();

    /**
     * Assignment operator
     */
    inline VideoContrastStatus& operator = (const VideoContrastStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoContrastStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoContrastStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoContrastStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoContrastStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8VideoContrast"

    static const int kU8VideoContrast = 0;

    /**
     * Clears the field "u8VideoContrast".
     *
     * The field will be set to its default value. The hasU8VideoContrast()
     * method will return false.
     */
    inline void clearU8VideoContrast();

    /**
     * Checks whether the field "u8VideoContrast" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8VideoContrast()). Otherwise it will return false.
     */
    inline bool hasU8VideoContrast () const;

    /**
     * Returns the value of the member "u8VideoContrast".
     *
     * Video contrast level within range 0 - 200.
     *
     * @return The value of the field "u8VideoContrast"
     */
    inline uint8 getU8VideoContrast () const;

    /**
     * Sets the value of the member "u8VideoContrast".
     *
     * Video contrast level within range 0 - 200.
     *
     * @param u8VideoContrast The value which will be set
     */
    inline void setU8VideoContrast (uint8 u8VideoContrast_);

    static const VideoContrastStatus &getDefaultInstance();

private:

    inline void set_has_u8VideoContrast ();

    inline void clear_has_u8VideoContrast ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8VideoContrast;

};

/**
 * The set message of the property "VideoContrast"
 * Property to set and get the video contrast level of the playable video objects.
 *
 * Valid range of video contrast level is 0 - 200.
 * Default value of contrast level is 100.
 */
class VideoContrastSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoContrastSet ();

    /**
     * Copy constructor
     */
    inline  VideoContrastSet (const VideoContrastSet &rhs);

    /**
     * All fields constructor
     */
    inline  VideoContrastSet (uint8 u8VideoContrast_);

    /**
     * Destructor
     */
    inline virtual  ~VideoContrastSet();

    /**
     * Assignment operator
     */
    inline VideoContrastSet& operator = (const VideoContrastSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoContrastSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoContrastSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoContrastSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoContrastSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8VideoContrast"

    static const int kU8VideoContrast = 0;

    /**
     * Clears the field "u8VideoContrast".
     *
     * The field will be set to its default value. The hasU8VideoContrast()
     * method will return false.
     */
    inline void clearU8VideoContrast();

    /**
     * Checks whether the field "u8VideoContrast" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8VideoContrast()). Otherwise it will return false.
     */
    inline bool hasU8VideoContrast () const;

    /**
     * Returns the value of the member "u8VideoContrast".
     *
     * Video contrast level within range 0 - 200.
     *
     * @return The value of the field "u8VideoContrast"
     */
    inline uint8 getU8VideoContrast () const;

    /**
     * Sets the value of the member "u8VideoContrast".
     *
     * Video contrast level within range 0 - 200.
     *
     * @param u8VideoContrast The value which will be set
     */
    inline void setU8VideoContrast (uint8 u8VideoContrast_);

    static const VideoContrastSet &getDefaultInstance();

private:

    inline void set_has_u8VideoContrast ();

    inline void clear_has_u8VideoContrast ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8VideoContrast;

};

/**
 * The status message of the property "VideoBrightnessOffset"
 * Property to set and get the video brightness offset level of the playable video objects.
 *
 * Valid range of video brightness offset level is -100 - +100.
 * Default value of brightness offset level is 0.
 */
class VideoBrightnessOffsetStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoBrightnessOffsetStatus ();

    /**
     * Copy constructor
     */
    inline  VideoBrightnessOffsetStatus (const VideoBrightnessOffsetStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VideoBrightnessOffsetStatus (int16 s16VideoBrightnessOffset_);

    /**
     * Destructor
     */
    inline virtual  ~VideoBrightnessOffsetStatus();

    /**
     * Assignment operator
     */
    inline VideoBrightnessOffsetStatus& operator = (const VideoBrightnessOffsetStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoBrightnessOffsetStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoBrightnessOffsetStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoBrightnessOffsetStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoBrightnessOffsetStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16VideoBrightnessOffset"

    static const int kS16VideoBrightnessOffset = 0;

    /**
     * Clears the field "s16VideoBrightnessOffset".
     *
     * The field will be set to its default value. The hasS16VideoBrightnessOffset()
     * method will return false.
     */
    inline void clearS16VideoBrightnessOffset();

    /**
     * Checks whether the field "s16VideoBrightnessOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16VideoBrightnessOffset()). Otherwise it will return false.
     */
    inline bool hasS16VideoBrightnessOffset () const;

    /**
     * Returns the value of the member "s16VideoBrightnessOffset".
     *
     * Video brightness offset level within range -100 - +100.
     *
     * @return The value of the field "s16VideoBrightnessOffset"
     */
    inline int16 getS16VideoBrightnessOffset () const;

    /**
     * Sets the value of the member "s16VideoBrightnessOffset".
     *
     * Video brightness offset level within range -100 - +100.
     *
     * @param s16VideoBrightnessOffset The value which will be set
     */
    inline void setS16VideoBrightnessOffset (int16 s16VideoBrightnessOffset_);

    static const VideoBrightnessOffsetStatus &getDefaultInstance();

private:

    inline void set_has_s16VideoBrightnessOffset ();

    inline void clear_has_s16VideoBrightnessOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _s16VideoBrightnessOffset;

};

/**
 * The set message of the property "VideoBrightnessOffset"
 * Property to set and get the video brightness offset level of the playable video objects.
 *
 * Valid range of video brightness offset level is -100 - +100.
 * Default value of brightness offset level is 0.
 */
class VideoBrightnessOffsetSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoBrightnessOffsetSet ();

    /**
     * Copy constructor
     */
    inline  VideoBrightnessOffsetSet (const VideoBrightnessOffsetSet &rhs);

    /**
     * All fields constructor
     */
    inline  VideoBrightnessOffsetSet (int16 s16VideoBrightnessOffset_);

    /**
     * Destructor
     */
    inline virtual  ~VideoBrightnessOffsetSet();

    /**
     * Assignment operator
     */
    inline VideoBrightnessOffsetSet& operator = (const VideoBrightnessOffsetSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoBrightnessOffsetSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoBrightnessOffsetSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoBrightnessOffsetSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoBrightnessOffsetSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16VideoBrightnessOffset"

    static const int kS16VideoBrightnessOffset = 0;

    /**
     * Clears the field "s16VideoBrightnessOffset".
     *
     * The field will be set to its default value. The hasS16VideoBrightnessOffset()
     * method will return false.
     */
    inline void clearS16VideoBrightnessOffset();

    /**
     * Checks whether the field "s16VideoBrightnessOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16VideoBrightnessOffset()). Otherwise it will return false.
     */
    inline bool hasS16VideoBrightnessOffset () const;

    /**
     * Returns the value of the member "s16VideoBrightnessOffset".
     *
     * Video brightness offset level within range -100 - +100.
     *
     * @return The value of the field "s16VideoBrightnessOffset"
     */
    inline int16 getS16VideoBrightnessOffset () const;

    /**
     * Sets the value of the member "s16VideoBrightnessOffset".
     *
     * Video brightness offset level within range -100 - +100.
     *
     * @param s16VideoBrightnessOffset The value which will be set
     */
    inline void setS16VideoBrightnessOffset (int16 s16VideoBrightnessOffset_);

    static const VideoBrightnessOffsetSet &getDefaultInstance();

private:

    inline void set_has_s16VideoBrightnessOffset ();

    inline void clear_has_s16VideoBrightnessOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _s16VideoBrightnessOffset;

};

/**
 * The status message of the property "VideoHueOffset"
 * Property to set and get the video hue offset level of the playable video objects.
 *
 * Valid range of video hue offset level is -180 - +180.
 * Default value of hue offset level is 0.
 */
class VideoHueOffsetStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoHueOffsetStatus ();

    /**
     * Copy constructor
     */
    inline  VideoHueOffsetStatus (const VideoHueOffsetStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VideoHueOffsetStatus (int16 s16VideoHueOffset_);

    /**
     * Destructor
     */
    inline virtual  ~VideoHueOffsetStatus();

    /**
     * Assignment operator
     */
    inline VideoHueOffsetStatus& operator = (const VideoHueOffsetStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoHueOffsetStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoHueOffsetStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoHueOffsetStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoHueOffsetStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16VideoHueOffset"

    static const int kS16VideoHueOffset = 0;

    /**
     * Clears the field "s16VideoHueOffset".
     *
     * The field will be set to its default value. The hasS16VideoHueOffset()
     * method will return false.
     */
    inline void clearS16VideoHueOffset();

    /**
     * Checks whether the field "s16VideoHueOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16VideoHueOffset()). Otherwise it will return false.
     */
    inline bool hasS16VideoHueOffset () const;

    /**
     * Returns the value of the member "s16VideoHueOffset".
     *
     * Video hue offset level within range -180 - +180.
     *
     * @return The value of the field "s16VideoHueOffset"
     */
    inline int16 getS16VideoHueOffset () const;

    /**
     * Sets the value of the member "s16VideoHueOffset".
     *
     * Video hue offset level within range -180 - +180.
     *
     * @param s16VideoHueOffset The value which will be set
     */
    inline void setS16VideoHueOffset (int16 s16VideoHueOffset_);

    static const VideoHueOffsetStatus &getDefaultInstance();

private:

    inline void set_has_s16VideoHueOffset ();

    inline void clear_has_s16VideoHueOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _s16VideoHueOffset;

};

/**
 * The set message of the property "VideoHueOffset"
 * Property to set and get the video hue offset level of the playable video objects.
 *
 * Valid range of video hue offset level is -180 - +180.
 * Default value of hue offset level is 0.
 */
class VideoHueOffsetSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoHueOffsetSet ();

    /**
     * Copy constructor
     */
    inline  VideoHueOffsetSet (const VideoHueOffsetSet &rhs);

    /**
     * All fields constructor
     */
    inline  VideoHueOffsetSet (int16 s16VideoHueOffset_);

    /**
     * Destructor
     */
    inline virtual  ~VideoHueOffsetSet();

    /**
     * Assignment operator
     */
    inline VideoHueOffsetSet& operator = (const VideoHueOffsetSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoHueOffsetSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoHueOffsetSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoHueOffsetSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoHueOffsetSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16VideoHueOffset"

    static const int kS16VideoHueOffset = 0;

    /**
     * Clears the field "s16VideoHueOffset".
     *
     * The field will be set to its default value. The hasS16VideoHueOffset()
     * method will return false.
     */
    inline void clearS16VideoHueOffset();

    /**
     * Checks whether the field "s16VideoHueOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16VideoHueOffset()). Otherwise it will return false.
     */
    inline bool hasS16VideoHueOffset () const;

    /**
     * Returns the value of the member "s16VideoHueOffset".
     *
     * Video hue offset level within range -180 - +180.
     *
     * @return The value of the field "s16VideoHueOffset"
     */
    inline int16 getS16VideoHueOffset () const;

    /**
     * Sets the value of the member "s16VideoHueOffset".
     *
     * Video hue offset level within range -180 - +180.
     *
     * @param s16VideoHueOffset The value which will be set
     */
    inline void setS16VideoHueOffset (int16 s16VideoHueOffset_);

    static const VideoHueOffsetSet &getDefaultInstance();

private:

    inline void set_has_s16VideoHueOffset ();

    inline void clear_has_s16VideoHueOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _s16VideoHueOffset;

};

/**
 * The status message of the property "VideoSaturationOffset"
 * Property to set and get the video saturation offset level of the playable video objects.
 *
 * Valid range of video saturation offset level is 0 - 200.
 * Default value of saturation offset level is 0.
 */
class VideoSaturationOffsetStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoSaturationOffsetStatus ();

    /**
     * Copy constructor
     */
    inline  VideoSaturationOffsetStatus (const VideoSaturationOffsetStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VideoSaturationOffsetStatus (uint8 u8VideoSaturationOffset_);

    /**
     * Destructor
     */
    inline virtual  ~VideoSaturationOffsetStatus();

    /**
     * Assignment operator
     */
    inline VideoSaturationOffsetStatus& operator = (const VideoSaturationOffsetStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoSaturationOffsetStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoSaturationOffsetStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoSaturationOffsetStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoSaturationOffsetStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8VideoSaturationOffset"

    static const int kU8VideoSaturationOffset = 0;

    /**
     * Clears the field "u8VideoSaturationOffset".
     *
     * The field will be set to its default value. The hasU8VideoSaturationOffset()
     * method will return false.
     */
    inline void clearU8VideoSaturationOffset();

    /**
     * Checks whether the field "u8VideoSaturationOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8VideoSaturationOffset()). Otherwise it will return false.
     */
    inline bool hasU8VideoSaturationOffset () const;

    /**
     * Returns the value of the member "u8VideoSaturationOffset".
     *
     * Video saturation offset level within range 0 - 200.
     *
     * @return The value of the field "u8VideoSaturationOffset"
     */
    inline uint8 getU8VideoSaturationOffset () const;

    /**
     * Sets the value of the member "u8VideoSaturationOffset".
     *
     * Video saturation offset level within range 0 - 200.
     *
     * @param u8VideoSaturationOffset The value which will be set
     */
    inline void setU8VideoSaturationOffset (uint8 u8VideoSaturationOffset_);

    static const VideoSaturationOffsetStatus &getDefaultInstance();

private:

    inline void set_has_u8VideoSaturationOffset ();

    inline void clear_has_u8VideoSaturationOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8VideoSaturationOffset;

};

/**
 * The set message of the property "VideoSaturationOffset"
 * Property to set and get the video saturation offset level of the playable video objects.
 *
 * Valid range of video saturation offset level is 0 - 200.
 * Default value of saturation offset level is 0.
 */
class VideoSaturationOffsetSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoSaturationOffsetSet ();

    /**
     * Copy constructor
     */
    inline  VideoSaturationOffsetSet (const VideoSaturationOffsetSet &rhs);

    /**
     * All fields constructor
     */
    inline  VideoSaturationOffsetSet (uint8 u8VideoSaturationOffset_);

    /**
     * Destructor
     */
    inline virtual  ~VideoSaturationOffsetSet();

    /**
     * Assignment operator
     */
    inline VideoSaturationOffsetSet& operator = (const VideoSaturationOffsetSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoSaturationOffsetSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoSaturationOffsetSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoSaturationOffsetSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoSaturationOffsetSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8VideoSaturationOffset"

    static const int kU8VideoSaturationOffset = 0;

    /**
     * Clears the field "u8VideoSaturationOffset".
     *
     * The field will be set to its default value. The hasU8VideoSaturationOffset()
     * method will return false.
     */
    inline void clearU8VideoSaturationOffset();

    /**
     * Checks whether the field "u8VideoSaturationOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8VideoSaturationOffset()). Otherwise it will return false.
     */
    inline bool hasU8VideoSaturationOffset () const;

    /**
     * Returns the value of the member "u8VideoSaturationOffset".
     *
     * Video saturation offset level within range 0 - 200.
     *
     * @return The value of the field "u8VideoSaturationOffset"
     */
    inline uint8 getU8VideoSaturationOffset () const;

    /**
     * Sets the value of the member "u8VideoSaturationOffset".
     *
     * Video saturation offset level within range 0 - 200.
     *
     * @param u8VideoSaturationOffset The value which will be set
     */
    inline void setU8VideoSaturationOffset (uint8 u8VideoSaturationOffset_);

    static const VideoSaturationOffsetSet &getDefaultInstance();

private:

    inline void set_has_u8VideoSaturationOffset ();

    inline void clear_has_u8VideoSaturationOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8VideoSaturationOffset;

};

/**
 * The status message of the property "VideoScaling"
 * Property to set and get the video scaling level of the playable video objects.
 * The following modes are supported -->
 * Normal ,
 * Full  ,
 * Stretched
 */
class VideoScalingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoScalingStatus ();

    /**
     * Copy constructor
     */
    inline  VideoScalingStatus (const VideoScalingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VideoScalingStatus (::MPlay_fi_types::T_VideoScalingType eVideoScaling_);

    /**
     * Destructor
     */
    inline virtual  ~VideoScalingStatus();

    /**
     * Assignment operator
     */
    inline VideoScalingStatus& operator = (const VideoScalingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoScalingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoScalingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoScalingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoScalingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eVideoScaling"

    static const int kEVideoScaling = 0;

    /**
     * Clears the field "eVideoScaling".
     *
     * The field will be set to its default value. The hasEVideoScaling()
     * method will return false.
     */
    inline void clearEVideoScaling();

    /**
     * Checks whether the field "eVideoScaling" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEVideoScaling()). Otherwise it will return false.
     */
    inline bool hasEVideoScaling () const;

    /**
     * Returns the value of the member "eVideoScaling".
     *
     * Video scaling is an enum value representing Normal, Full and Strech.
     *
     * @return The value of the field "eVideoScaling"
     */
    inline ::MPlay_fi_types::T_VideoScalingType getEVideoScaling () const;

    /**
     * Sets the value of the member "eVideoScaling".
     *
     * Video scaling is an enum value representing Normal, Full and Strech.
     *
     * @param eVideoScaling The value which will be set
     */
    inline void setEVideoScaling (::MPlay_fi_types::T_VideoScalingType eVideoScaling_);

    static const VideoScalingStatus &getDefaultInstance();

private:

    inline void set_has_eVideoScaling ();

    inline void clear_has_eVideoScaling ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_VideoScalingType _eVideoScaling;

};

/**
 * The set message of the property "VideoScaling"
 * Property to set and get the video scaling level of the playable video objects.
 * The following modes are supported -->
 * Normal ,
 * Full  ,
 * Stretched
 */
class VideoScalingSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoScalingSet ();

    /**
     * Copy constructor
     */
    inline  VideoScalingSet (const VideoScalingSet &rhs);

    /**
     * All fields constructor
     */
    inline  VideoScalingSet (::MPlay_fi_types::T_VideoScalingType eVideoScaling_);

    /**
     * Destructor
     */
    inline virtual  ~VideoScalingSet();

    /**
     * Assignment operator
     */
    inline VideoScalingSet& operator = (const VideoScalingSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoScalingSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoScalingSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoScalingSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoScalingSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eVideoScaling"

    static const int kEVideoScaling = 0;

    /**
     * Clears the field "eVideoScaling".
     *
     * The field will be set to its default value. The hasEVideoScaling()
     * method will return false.
     */
    inline void clearEVideoScaling();

    /**
     * Checks whether the field "eVideoScaling" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEVideoScaling()). Otherwise it will return false.
     */
    inline bool hasEVideoScaling () const;

    /**
     * Returns the value of the member "eVideoScaling".
     *
     * Video scaling is an enum value representing Normal, Full and Strech.
     *
     * @return The value of the field "eVideoScaling"
     */
    inline ::MPlay_fi_types::T_VideoScalingType getEVideoScaling () const;

    /**
     * Sets the value of the member "eVideoScaling".
     *
     * Video scaling is an enum value representing Normal, Full and Strech.
     *
     * @param eVideoScaling The value which will be set
     */
    inline void setEVideoScaling (::MPlay_fi_types::T_VideoScalingType eVideoScaling_);

    static const VideoScalingSet &getDefaultInstance();

private:

    inline void set_has_eVideoScaling ();

    inline void clear_has_eVideoScaling ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_VideoScalingType _eVideoScaling;

};

/**
 * The status message of the property "UpdatePlaybackSpeed"
 * Property to get the PlaybackSpeed of the playable video objects. Valid range of playback speed level is 1x-32x. Default value of brightness level is 1x.
 */
class UpdatePlaybackSpeedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdatePlaybackSpeedStatus ();

    /**
     * Copy constructor
     */
    inline  UpdatePlaybackSpeedStatus (const UpdatePlaybackSpeedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UpdatePlaybackSpeedStatus (::MPlay_fi_types::T_e8_MPlaybackSpeed e8PlaybackSpeed_);

    /**
     * Destructor
     */
    inline virtual  ~UpdatePlaybackSpeedStatus();

    /**
     * Assignment operator
     */
    inline UpdatePlaybackSpeedStatus& operator = (const UpdatePlaybackSpeedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdatePlaybackSpeedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdatePlaybackSpeedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdatePlaybackSpeedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdatePlaybackSpeedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PlaybackSpeed"

    static const int kE8PlaybackSpeed = 0;

    /**
     * Clears the field "e8PlaybackSpeed".
     *
     * The field will be set to its default value. The hasE8PlaybackSpeed()
     * method will return false.
     */
    inline void clearE8PlaybackSpeed();

    /**
     * Checks whether the field "e8PlaybackSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackSpeed()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackSpeed () const;

    /**
     * Returns the value of the member "e8PlaybackSpeed".
     *
     * Valid range of playback speed level is 1x-32x.
     *
     * @return The value of the field "e8PlaybackSpeed"
     */
    inline ::MPlay_fi_types::T_e8_MPlaybackSpeed getE8PlaybackSpeed () const;

    /**
     * Sets the value of the member "e8PlaybackSpeed".
     *
     * Valid range of playback speed level is 1x-32x.
     *
     * @param e8PlaybackSpeed The value which will be set
     */
    inline void setE8PlaybackSpeed (::MPlay_fi_types::T_e8_MPlaybackSpeed e8PlaybackSpeed_);

    static const UpdatePlaybackSpeedStatus &getDefaultInstance();

private:

    inline void set_has_e8PlaybackSpeed ();

    inline void clear_has_e8PlaybackSpeed ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlaybackSpeed _e8PlaybackSpeed;

};

/**
 * The status message of the property "UserFavoritesChanged"
 * The UserFavoritesChanged property provides notification about changes that
 * occurred to the stored favorites. These changes include:
 *
 * 1) On startup
 * 2) Addition of a new favorite
 * 3) Deletion of a favorite
 *
 * The ListChangeType = LCH_CONTENT_CHANGED when the FavoriteInfo record
 * elements have been determined for all stored favorites after system
 * initialization.
 *
 * If the ListChangeType = LCH_CONTENT_CHANGED, i.e. the entire list
 * changed, then NumItems = 0 and the ChangedFavorites array is empty.
 */
class UserFavoritesChangedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UserFavoritesChangedStatus ();

    /**
     * Copy constructor
     */
    inline  UserFavoritesChangedStatus (const UserFavoritesChangedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UserFavoritesChangedStatus (::MPlay_fi_types::T_e8_MPlayChange e8ListChangeType_, uint32 u32ListSize_, uint32 u32NumItems_, const ::MPlay_fi_types::T_MPlayFavoritesList& oChangedFavorites_);

    /**
     * Destructor
     */
    inline virtual  ~UserFavoritesChangedStatus();

    /**
     * Assignment operator
     */
    inline UserFavoritesChangedStatus& operator = (const UserFavoritesChangedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UserFavoritesChangedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UserFavoritesChangedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UserFavoritesChangedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UserFavoritesChangedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ListChangeType"

    static const int kE8ListChangeType = 0;

    /**
     * Clears the field "e8ListChangeType".
     *
     * The field will be set to its default value. The hasE8ListChangeType()
     * method will return false.
     */
    inline void clearE8ListChangeType();

    /**
     * Checks whether the field "e8ListChangeType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListChangeType()). Otherwise it will return false.
     */
    inline bool hasE8ListChangeType () const;

    /**
     * Returns the value of the member "e8ListChangeType".
     *
     * The ListChangeType parameter indicates the kind of change that occurred to the stored favorites.
     *
     * @return The value of the field "e8ListChangeType"
     */
    inline ::MPlay_fi_types::T_e8_MPlayChange getE8ListChangeType () const;

    /**
     * Sets the value of the member "e8ListChangeType".
     *
     * The ListChangeType parameter indicates the kind of change that occurred to the stored favorites.
     *
     * @param e8ListChangeType The value which will be set
     */
    inline void setE8ListChangeType (::MPlay_fi_types::T_e8_MPlayChange e8ListChangeType_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 1;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The ListSize parameter indicates how many favorites are currently stored within the favorites provider.
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The ListSize parameter indicates how many favorites are currently stored within the favorites provider.
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    // API of field "u32NumItems"

    static const int kU32NumItems = 2;

    /**
     * Clears the field "u32NumItems".
     *
     * The field will be set to its default value. The hasU32NumItems()
     * method will return false.
     */
    inline void clearU32NumItems();

    /**
     * Checks whether the field "u32NumItems" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumItems()). Otherwise it will return false.
     */
    inline bool hasU32NumItems () const;

    /**
     * Returns the value of the member "u32NumItems".
     *
     * The NumItems parameter specifies the number of items or groups of items in a stream.
     *
     * @return The value of the field "u32NumItems"
     */
    inline uint32 getU32NumItems () const;

    /**
     * Sets the value of the member "u32NumItems".
     *
     * The NumItems parameter specifies the number of items or groups of items in a stream.
     *
     * @param u32NumItems The value which will be set
     */
    inline void setU32NumItems (uint32 u32NumItems_);

    // API of field "oChangedFavorites"

    static const int kOChangedFavorites = 3;

    /**
     * Clears the field "oChangedFavorites".
     *
     * The field will be set to its default value. The hasOChangedFavorites()
     * method will return false.
     */
    inline void clearOChangedFavorites();

    /**
     * Checks whether the field "oChangedFavorites" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOChangedFavorites()). Otherwise it will return false.
     */
    inline bool hasOChangedFavorites () const;

    /**
     * Returns the value of the member "oChangedFavorites".
     *
     * The ChangedFavorites steam contains the FavoriteIDs of the stored favorites which have been added, removed or changed.  This steam is empty when the ListChangeType is LCH_CONTENT_CHANGED.
     *
     * @return The value of the field "oChangedFavorites"
     */
    inline const ::MPlay_fi_types::T_MPlayFavoritesList& getOChangedFavorites () const;

    /**
     * Retrieves the value of the field "oChangedFavorites" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oChangedFavorites".
     */
    inline ::MPlay_fi_types::T_MPlayFavoritesList& getOChangedFavoritesMutable ();

    /**
     * Sets the value of the member "oChangedFavorites".
     *
     * The ChangedFavorites steam contains the FavoriteIDs of the stored favorites which have been added, removed or changed.  This steam is empty when the ListChangeType is LCH_CONTENT_CHANGED.
     *
     * @param oChangedFavorites The value which will be set
     */
    inline void setOChangedFavorites (const ::MPlay_fi_types::T_MPlayFavoritesList& oChangedFavorites_);

    static const UserFavoritesChangedStatus &getDefaultInstance();

private:

    static const ::std::vector< uint64 >& getUint64List_DefaultInstance ();

    inline void set_has_e8ListChangeType ();

    inline void clear_has_e8ListChangeType ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    inline void set_has_u32NumItems ();

    inline void clear_has_u32NumItems ();

    inline void set_has_oChangedFavorites ();

    inline void clear_has_oChangedFavorites ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayChange _e8ListChangeType;

    uint32 _u32ListSize;

    uint32 _u32NumItems;

    ::MPlay_fi_types::T_MPlayFavoritesList _oChangedFavorites;

};

/**
 * The status message of the property "FolderBrowseStructureCleared"
 * The Browse structure stored internal to mediaplayer can be cleared in two cases.
 *
 * 1) Player Changed (Browsed Player)
 * 2) UIDsChanged in Phone
 *
 * The Device Tag indicates the device id of the device for which, the browse structure is cleared.
 */
class FolderBrowseStructureClearedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FolderBrowseStructureClearedStatus ();

    /**
     * Copy constructor
     */
    inline  FolderBrowseStructureClearedStatus (const FolderBrowseStructureClearedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FolderBrowseStructureClearedStatus (uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~FolderBrowseStructureClearedStatus();

    /**
     * Assignment operator
     */
    inline FolderBrowseStructureClearedStatus& operator = (const FolderBrowseStructureClearedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FolderBrowseStructureClearedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FolderBrowseStructureClearedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FolderBrowseStructureClearedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FolderBrowseStructureClearedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * The Device Tag indicates the device id of the device for which, the browse structure is cleared.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * The Device Tag indicates the device id of the device for which, the browse structure is cleared.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const FolderBrowseStructureClearedStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceTag;

};

/**
 * The status message of the property "ReadyToPlay"
 * Update playback state when user starts playback on the phone
 */
class ReadyToPlayStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReadyToPlayStatus ();

    /**
     * Copy constructor
     */
    inline  ReadyToPlayStatus (const ReadyToPlayStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ReadyToPlayStatus (const ::std::string& sDeviceSerialNumber_, bool bPlayingStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ReadyToPlayStatus();

    /**
     * Assignment operator
     */
    inline ReadyToPlayStatus& operator = (const ReadyToPlayStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadyToPlayStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadyToPlayStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadyToPlayStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadyToPlayStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceSerialNumber"

    static const int kSDeviceSerialNumber = 0;

    /**
     * Clears the field "sDeviceSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceSerialNumber();

    /**
     * Checks whether the field "sDeviceSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceSerialNumber".
     *
     * Serial number of the connected device.
     *
     * @return The value of the field "sDeviceSerialNumber"
     */
    inline const ::std::string& getSDeviceSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceSerialNumber".
     */
    inline ::std::string& getSDeviceSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceSerialNumber".
     *
     * Serial number of the connected device.
     *
     * @param sDeviceSerialNumber The value which will be set
     */
    inline void setSDeviceSerialNumber (const ::std::string& sDeviceSerialNumber_);

    /**
     * Sets the value of the member "sDeviceSerialNumber".
     *
     * Serial number of the connected device.
     *
     * @param sDeviceSerialNumber The value which will be set
     */
    inline void setSDeviceSerialNumber (const char* sDeviceSerialNumber_);

    /**
     * Sets the value of the member "sDeviceSerialNumber".
     *
     * Serial number of the connected device.
     *
     * @param sDeviceSerialNumber The value which will be set
     */
    inline void setSDeviceSerialNumber (const char* value, size_t size);

    // API of field "bPlayingStatus"

    static const int kBPlayingStatus = 1;

    /**
     * Clears the field "bPlayingStatus".
     *
     * The field will be set to its default value. The hasBPlayingStatus()
     * method will return false.
     */
    inline void clearBPlayingStatus();

    /**
     * Checks whether the field "bPlayingStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPlayingStatus()). Otherwise it will return false.
     */
    inline bool hasBPlayingStatus () const;

    /**
     * Returns the value of the member "bPlayingStatus".
     *
     * Playback status of the connected iPhone
     *
     * @return The value of the field "bPlayingStatus"
     */
    inline bool getBPlayingStatus () const;

    /**
     * Sets the value of the member "bPlayingStatus".
     *
     * Playback status of the connected iPhone
     *
     * @param bPlayingStatus The value which will be set
     */
    inline void setBPlayingStatus (bool bPlayingStatus_);

    static const ReadyToPlayStatus &getDefaultInstance();

private:

    inline void set_has_sDeviceSerialNumber ();

    inline void clear_has_sDeviceSerialNumber ();

    inline void set_has_bPlayingStatus ();

    inline void clear_has_bPlayingStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sDeviceSerialNumber;

    bool _bPlayingStatus;

};

/**
 * The status message of the property "BluetoothAudioDeviceStatus"
 * Update the busy or free status of Bluetooth Audio input device.
 * BT audio input device should not be read by multiple processes. Incase any process
 * wants to use Bluetooth Audio input device, process has to request the device
 * to Mediaplayer by method RequestBluetoothAudioDevice if the device is free
 */
class BluetoothAudioDeviceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BluetoothAudioDeviceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  BluetoothAudioDeviceStatusStatus (const BluetoothAudioDeviceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BluetoothAudioDeviceStatusStatus (bool bAudioDeviceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~BluetoothAudioDeviceStatusStatus();

    /**
     * Assignment operator
     */
    inline BluetoothAudioDeviceStatusStatus& operator = (const BluetoothAudioDeviceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothAudioDeviceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothAudioDeviceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothAudioDeviceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothAudioDeviceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAudioDeviceStatus"

    static const int kBAudioDeviceStatus = 0;

    /**
     * Clears the field "bAudioDeviceStatus".
     *
     * The field will be set to its default value. The hasBAudioDeviceStatus()
     * method will return false.
     */
    inline void clearBAudioDeviceStatus();

    /**
     * Checks whether the field "bAudioDeviceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAudioDeviceStatus()). Otherwise it will return false.
     */
    inline bool hasBAudioDeviceStatus () const;

    /**
     * Returns the value of the member "bAudioDeviceStatus".
     *
     * 1 = busy, 0 = free
     *
     * @return The value of the field "bAudioDeviceStatus"
     */
    inline bool getBAudioDeviceStatus () const;

    /**
     * Sets the value of the member "bAudioDeviceStatus".
     *
     * 1 = busy, 0 = free
     *
     * @param bAudioDeviceStatus The value which will be set
     */
    inline void setBAudioDeviceStatus (bool bAudioDeviceStatus_);

    static const BluetoothAudioDeviceStatusStatus &getDefaultInstance();

private:

    inline void set_has_bAudioDeviceStatus ();

    inline void clear_has_bAudioDeviceStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bAudioDeviceStatus;

};

/**
 * The start message of the method "CreateMediaPlayerQuickPlayList"
 * This method generates an ordered list of media objects that match all
 * the specified filter criteria. The order and contents of the list
 * generated are dependent on the filter criteria and the AutoPlay
 * parameter. The list created by this method creates the list of objects
 * to play, in the order to play them as follows:
 *
 * This method may only be called on a device that supported indexing
 * ccording to its DeviceInfo.DeviceIndexedState property as reported by
 * either MediaPlayerDeviceConnections or ActiveMediaDevice. If
 * DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 *
 * This method returns a handle to the created playlist and the number of
 * objects in the list.
 *
 * A list is considered to be valid until the ReleaseMediaPlayerList
 * function is executed.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 *
 * QuickPlayList features are only supported by the MediaPlayer FBlock
 * when MyMediaSupported (0x230) == TRUE.  If MyMediaSupported == FALSE
 * (i.e. for a Base Radio MediaPlayer implementation), then both
 * CreateMediaPlayerQuickPlaylistList and
 * RequestMediaPlayerQuickPlayListSlice shall not be called by a
 * controller.  If they are called in error when MyMediaSupported =
 * FALSE, the MediaPlayer FBlock shall respond with error.
 */
class CreateMediaPlayerQuickPlayListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerQuickPlayListStart ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerQuickPlayListStart (const CreateMediaPlayerQuickPlayListStart &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerQuickPlayListStart (::MPlay_fi_types::T_e8_MPlayListType e8ListType_, uint32 u32FilterTag1_, uint32 u32FilterTag2_, uint32 u32FilterTag3_, uint32 u32FilterTag4_, bool bAutoPlay_, uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerQuickPlayListStart();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerQuickPlayListStart& operator = (const CreateMediaPlayerQuickPlayListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerQuickPlayListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerQuickPlayListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerQuickPlayListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerQuickPlayListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ListType"

    static const int kE8ListType = 0;

    /**
     * Clears the field "e8ListType".
     *
     * The field will be set to its default value. The hasE8ListType()
     * method will return false.
     */
    inline void clearE8ListType();

    /**
     * Checks whether the field "e8ListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListType()). Otherwise it will return false.
     */
    inline bool hasE8ListType () const;

    /**
     * Returns the value of the member "e8ListType".
     *
     * Defines the type of list requested from the MediaPlayer.
     *
     * @return The value of the field "e8ListType"
     */
    inline ::MPlay_fi_types::T_e8_MPlayListType getE8ListType () const;

    /**
     * Sets the value of the member "e8ListType".
     *
     * Defines the type of list requested from the MediaPlayer.
     *
     * @param e8ListType The value which will be set
     */
    inline void setE8ListType (::MPlay_fi_types::T_e8_MPlayListType e8ListType_);

    // API of field "u32FilterTag1"

    static const int kU32FilterTag1 = 1;

    /**
     * Clears the field "u32FilterTag1".
     *
     * The field will be set to its default value. The hasU32FilterTag1()
     * method will return false.
     */
    inline void clearU32FilterTag1();

    /**
     * Checks whether the field "u32FilterTag1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FilterTag1()). Otherwise it will return false.
     */
    inline bool hasU32FilterTag1 () const;

    /**
     * Returns the value of the member "u32FilterTag1".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @return The value of the field "u32FilterTag1"
     */
    inline uint32 getU32FilterTag1 () const;

    /**
     * Sets the value of the member "u32FilterTag1".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @param u32FilterTag1 The value which will be set
     */
    inline void setU32FilterTag1 (uint32 u32FilterTag1_);

    // API of field "u32FilterTag2"

    static const int kU32FilterTag2 = 2;

    /**
     * Clears the field "u32FilterTag2".
     *
     * The field will be set to its default value. The hasU32FilterTag2()
     * method will return false.
     */
    inline void clearU32FilterTag2();

    /**
     * Checks whether the field "u32FilterTag2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FilterTag2()). Otherwise it will return false.
     */
    inline bool hasU32FilterTag2 () const;

    /**
     * Returns the value of the member "u32FilterTag2".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @return The value of the field "u32FilterTag2"
     */
    inline uint32 getU32FilterTag2 () const;

    /**
     * Sets the value of the member "u32FilterTag2".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @param u32FilterTag2 The value which will be set
     */
    inline void setU32FilterTag2 (uint32 u32FilterTag2_);

    // API of field "u32FilterTag3"

    static const int kU32FilterTag3 = 3;

    /**
     * Clears the field "u32FilterTag3".
     *
     * The field will be set to its default value. The hasU32FilterTag3()
     * method will return false.
     */
    inline void clearU32FilterTag3();

    /**
     * Checks whether the field "u32FilterTag3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FilterTag3()). Otherwise it will return false.
     */
    inline bool hasU32FilterTag3 () const;

    /**
     * Returns the value of the member "u32FilterTag3".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @return The value of the field "u32FilterTag3"
     */
    inline uint32 getU32FilterTag3 () const;

    /**
     * Sets the value of the member "u32FilterTag3".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @param u32FilterTag3 The value which will be set
     */
    inline void setU32FilterTag3 (uint32 u32FilterTag3_);

    // API of field "u32FilterTag4"

    static const int kU32FilterTag4 = 4;

    /**
     * Clears the field "u32FilterTag4".
     *
     * The field will be set to its default value. The hasU32FilterTag4()
     * method will return false.
     */
    inline void clearU32FilterTag4();

    /**
     * Checks whether the field "u32FilterTag4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FilterTag4()). Otherwise it will return false.
     */
    inline bool hasU32FilterTag4 () const;

    /**
     * Returns the value of the member "u32FilterTag4".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @return The value of the field "u32FilterTag4"
     */
    inline uint32 getU32FilterTag4 () const;

    /**
     * Sets the value of the member "u32FilterTag4".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @param u32FilterTag4 The value which will be set
     */
    inline void setU32FilterTag4 (uint32 u32FilterTag4_);

    // API of field "bAutoPlay"

    static const int kBAutoPlay = 5;

    /**
     * Clears the field "bAutoPlay".
     *
     * The field will be set to its default value. The hasBAutoPlay()
     * method will return false.
     */
    inline void clearBAutoPlay();

    /**
     * Checks whether the field "bAutoPlay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutoPlay()). Otherwise it will return false.
     */
    inline bool hasBAutoPlay () const;

    /**
     * Returns the value of the member "bAutoPlay".
     *
     * The AutoPlay parameter of the CreatePlaylist method behaves as follows:
     *
     * If the AutoPlay parameter is set to true, the MediaPlayer
     * continues playback based on the generated hierarchy after playback of the
     * user selection completes. This is the typical value of this parameter and
     * what is shown in this usage scenario.
     *
     * If the AutoPlay parameter is set
     * to false, playback stops upon completion of the user's selection.
     *
     * @return The value of the field "bAutoPlay"
     */
    inline bool getBAutoPlay () const;

    /**
     * Sets the value of the member "bAutoPlay".
     *
     * The AutoPlay parameter of the CreatePlaylist method behaves as follows:
     *
     * If the AutoPlay parameter is set to true, the MediaPlayer
     * continues playback based on the generated hierarchy after playback of the
     * user selection completes. This is the typical value of this parameter and
     * what is shown in this usage scenario.
     *
     * If the AutoPlay parameter is set
     * to false, playback stops upon completion of the user's selection.
     *
     * @param bAutoPlay The value which will be set
     */
    inline void setBAutoPlay (bool bAutoPlay_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 6;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const CreateMediaPlayerQuickPlayListStart &getDefaultInstance();

private:

    inline void set_has_e8ListType ();

    inline void clear_has_e8ListType ();

    inline void set_has_u32FilterTag1 ();

    inline void clear_has_u32FilterTag1 ();

    inline void set_has_u32FilterTag2 ();

    inline void clear_has_u32FilterTag2 ();

    inline void set_has_u32FilterTag3 ();

    inline void clear_has_u32FilterTag3 ();

    inline void set_has_u32FilterTag4 ();

    inline void clear_has_u32FilterTag4 ();

    inline void set_has_bAutoPlay ();

    inline void clear_has_bAutoPlay ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayListType _e8ListType;

    uint32 _u32FilterTag1;

    uint32 _u32FilterTag2;

    uint32 _u32FilterTag3;

    uint32 _u32FilterTag4;

    bool _bAutoPlay;

    uint8 _u8DeviceTag;

};

/**
 * The result message of the method "CreateMediaPlayerQuickPlayList"
 * This method generates an ordered list of media objects that match all
 * the specified filter criteria. The order and contents of the list
 * generated are dependent on the filter criteria and the AutoPlay
 * parameter. The list created by this method creates the list of objects
 * to play, in the order to play them as follows:
 *
 * This method may only be called on a device that supported indexing
 * ccording to its DeviceInfo.DeviceIndexedState property as reported by
 * either MediaPlayerDeviceConnections or ActiveMediaDevice. If
 * DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 *
 * This method returns a handle to the created playlist and the number of
 * objects in the list.
 *
 * A list is considered to be valid until the ReleaseMediaPlayerList
 * function is executed.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 *
 * QuickPlayList features are only supported by the MediaPlayer FBlock
 * when MyMediaSupported (0x230) == TRUE.  If MyMediaSupported == FALSE
 * (i.e. for a Base Radio MediaPlayer implementation), then both
 * CreateMediaPlayerQuickPlaylistList and
 * RequestMediaPlayerQuickPlayListSlice shall not be called by a
 * controller.  If they are called in error when MyMediaSupported =
 * FALSE, the MediaPlayer FBlock shall respond with error.
 */
class CreateMediaPlayerQuickPlayListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerQuickPlayListResult ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerQuickPlayListResult (const CreateMediaPlayerQuickPlayListResult &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerQuickPlayListResult (uint32 u32ListHandle_, uint32 u32ListSize_, uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerQuickPlayListResult();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerQuickPlayListResult& operator = (const CreateMediaPlayerQuickPlayListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerQuickPlayListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerQuickPlayListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerQuickPlayListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerQuickPlayListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 1;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 2;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const CreateMediaPlayerQuickPlayListResult &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32ListSize;

    uint8 _u8DeviceTag;

};

/**
 * The start message of the method "CreateMediaPlayerIndexedList"
 * This method creates a new list that contains the meta-data values of the
 * requested indexed media as follows:
 *
 * The client can specify up to three filter Tags, dependent on the type
 * of list requested. The order and contents of the list generated are
 * dependent on the filter criteria.
 *
 * This method may only be called on a device that supported indexing
 * ccording to its DeviceInfo.DeviceIndexedState property as reported by
 * either MediaPlayerDeviceConnections or ActiveMediaDevice. If
 * DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 *
 * This method returns a handle to the created playlist and the number of
 * objects in the list.
 *
 * A list is considered to be valid until the ReleaseMediaPlayerList
 * function is executed.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 *
 * The CreateMediaPlayerIndexedList function assigns a unique ListHandle
 * for each filtered list created and returns this value, as well as the
 * number of results in the filtered list.
 *
 * A list is considered to be valid until the ReleaseMediaPlayerList
 * function is executed.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 */
class CreateMediaPlayerIndexedListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerIndexedListStart ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerIndexedListStart (const CreateMediaPlayerIndexedListStart &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerIndexedListStart (::MPlay_fi_types::T_e8_MPlayListType e8ListType_, uint32 u32FilterTag1_, uint32 u32FilterTag2_, uint32 u32FilterTag3_, uint8 u8DeviceTag_, uint8 u8UserID_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerIndexedListStart();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerIndexedListStart& operator = (const CreateMediaPlayerIndexedListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerIndexedListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerIndexedListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerIndexedListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerIndexedListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ListType"

    static const int kE8ListType = 0;

    /**
     * Clears the field "e8ListType".
     *
     * The field will be set to its default value. The hasE8ListType()
     * method will return false.
     */
    inline void clearE8ListType();

    /**
     * Checks whether the field "e8ListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListType()). Otherwise it will return false.
     */
    inline bool hasE8ListType () const;

    /**
     * Returns the value of the member "e8ListType".
     *
     * Defines the type of list requested from the MediaPlayer.
     *
     * @return The value of the field "e8ListType"
     */
    inline ::MPlay_fi_types::T_e8_MPlayListType getE8ListType () const;

    /**
     * Sets the value of the member "e8ListType".
     *
     * Defines the type of list requested from the MediaPlayer.
     *
     * @param e8ListType The value which will be set
     */
    inline void setE8ListType (::MPlay_fi_types::T_e8_MPlayListType e8ListType_);

    // API of field "u32FilterTag1"

    static const int kU32FilterTag1 = 1;

    /**
     * Clears the field "u32FilterTag1".
     *
     * The field will be set to its default value. The hasU32FilterTag1()
     * method will return false.
     */
    inline void clearU32FilterTag1();

    /**
     * Checks whether the field "u32FilterTag1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FilterTag1()). Otherwise it will return false.
     */
    inline bool hasU32FilterTag1 () const;

    /**
     * Returns the value of the member "u32FilterTag1".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @return The value of the field "u32FilterTag1"
     */
    inline uint32 getU32FilterTag1 () const;

    /**
     * Sets the value of the member "u32FilterTag1".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @param u32FilterTag1 The value which will be set
     */
    inline void setU32FilterTag1 (uint32 u32FilterTag1_);

    // API of field "u32FilterTag2"

    static const int kU32FilterTag2 = 2;

    /**
     * Clears the field "u32FilterTag2".
     *
     * The field will be set to its default value. The hasU32FilterTag2()
     * method will return false.
     */
    inline void clearU32FilterTag2();

    /**
     * Checks whether the field "u32FilterTag2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FilterTag2()). Otherwise it will return false.
     */
    inline bool hasU32FilterTag2 () const;

    /**
     * Returns the value of the member "u32FilterTag2".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @return The value of the field "u32FilterTag2"
     */
    inline uint32 getU32FilterTag2 () const;

    /**
     * Sets the value of the member "u32FilterTag2".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @param u32FilterTag2 The value which will be set
     */
    inline void setU32FilterTag2 (uint32 u32FilterTag2_);

    // API of field "u32FilterTag3"

    static const int kU32FilterTag3 = 3;

    /**
     * Clears the field "u32FilterTag3".
     *
     * The field will be set to its default value. The hasU32FilterTag3()
     * method will return false.
     */
    inline void clearU32FilterTag3();

    /**
     * Checks whether the field "u32FilterTag3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FilterTag3()). Otherwise it will return false.
     */
    inline bool hasU32FilterTag3 () const;

    /**
     * Returns the value of the member "u32FilterTag3".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @return The value of the field "u32FilterTag3"
     */
    inline uint32 getU32FilterTag3 () const;

    /**
     * Sets the value of the member "u32FilterTag3".
     *
     * The FilterString contains the Tag of an object to use as filter criteria.
     * Depending on the ListType (and type of objects contained in the list),
     * this filter may either be empty or contain an object's Tag.
     *
     * @param u32FilterTag3 The value which will be set
     */
    inline void setU32FilterTag3 (uint32 u32FilterTag3_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 4;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "u8UserID"

    static const int kU8UserID = 5;

    /**
     * Clears the field "u8UserID".
     *
     * The field will be set to its default value. The hasU8UserID()
     * method will return false.
     */
    inline void clearU8UserID();

    /**
     * Checks whether the field "u8UserID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8UserID()). Otherwise it will return false.
     */
    inline bool hasU8UserID () const;

    /**
     * Returns the value of the member "u8UserID".
     *
     * The UserID is the unique ID set by the personalization component for each user. HMI will request to store favorite based on this.Later the stored favorites are fetched by this UserID.
     *
     * @return The value of the field "u8UserID"
     */
    inline uint8 getU8UserID () const;

    /**
     * Sets the value of the member "u8UserID".
     *
     * The UserID is the unique ID set by the personalization component for each user. HMI will request to store favorite based on this.Later the stored favorites are fetched by this UserID.
     *
     * @param u8UserID The value which will be set
     */
    inline void setU8UserID (uint8 u8UserID_);

    static const CreateMediaPlayerIndexedListStart &getDefaultInstance();

private:

    inline void set_has_e8ListType ();

    inline void clear_has_e8ListType ();

    inline void set_has_u32FilterTag1 ();

    inline void clear_has_u32FilterTag1 ();

    inline void set_has_u32FilterTag2 ();

    inline void clear_has_u32FilterTag2 ();

    inline void set_has_u32FilterTag3 ();

    inline void clear_has_u32FilterTag3 ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_u8UserID ();

    inline void clear_has_u8UserID ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayListType _e8ListType;

    uint32 _u32FilterTag1;

    uint32 _u32FilterTag2;

    uint32 _u32FilterTag3;

    uint8 _u8DeviceTag;

    uint8 _u8UserID;

};

/**
 * The result message of the method "CreateMediaPlayerIndexedList"
 * This method creates a new list that contains the meta-data values of the
 * requested indexed media as follows:
 *
 * The client can specify up to three filter Tags, dependent on the type
 * of list requested. The order and contents of the list generated are
 * dependent on the filter criteria.
 *
 * This method may only be called on a device that supported indexing
 * ccording to its DeviceInfo.DeviceIndexedState property as reported by
 * either MediaPlayerDeviceConnections or ActiveMediaDevice. If
 * DeviceIndexState=IDS_NOT_SUPPORTED for the requested device, then the
 * FBlock shall trigger an invalid argument error response.
 *
 * This method returns a handle to the created playlist and the number of
 * objects in the list.
 *
 * A list is considered to be valid until the ReleaseMediaPlayerList
 * function is executed.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 *
 * The CreateMediaPlayerIndexedList function assigns a unique ListHandle
 * for each filtered list created and returns this value, as well as the
 * number of results in the filtered list.
 *
 * A list is considered to be valid until the ReleaseMediaPlayerList
 * function is executed.
 *
 * Changes to a list are reported by the MediaPlayerListChange property.
 */
class CreateMediaPlayerIndexedListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerIndexedListResult ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerIndexedListResult (const CreateMediaPlayerIndexedListResult &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerIndexedListResult (uint32 u32ListHandle_, uint32 u32ListSize_, uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerIndexedListResult();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerIndexedListResult& operator = (const CreateMediaPlayerIndexedListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerIndexedListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerIndexedListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerIndexedListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerIndexedListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 1;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 2;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const CreateMediaPlayerIndexedListResult &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32ListSize;

    uint8 _u8DeviceTag;

};

/**
 * The start message of the method "RequestMediaPlayerIndexedListSlice"
 * The RequestMediaPlayerIndexedListSlice method provides a slice of the
 * filtered list specified by the ListHandle parameter. The slice begins
 * with the item at location WindowStart and includes in sequential order
 * the number of items specified by the parameter WindowSize.
 *
 * The RequestListSlice method returns the slice as a MediaObjects stream.
 * The data contained in each MediaObject is used by the HMI to determine
 * the meta-data and other properties of the media object.
 *
 * If the number of items in the list starting at WindowStart is less than
 * the WindowSize parameter then the number of items provided in the slice
 * will be less than the WindowSize calling parameter.
 */
class RequestMediaPlayerIndexedListSliceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestMediaPlayerIndexedListSliceStart ();

    /**
     * Copy constructor
     */
    inline  RequestMediaPlayerIndexedListSliceStart (const RequestMediaPlayerIndexedListSliceStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestMediaPlayerIndexedListSliceStart (uint32 u32ListHandle_, uint32 u32WindowStart_, uint16 u16WindowSize_, uint8 DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~RequestMediaPlayerIndexedListSliceStart();

    /**
     * Assignment operator
     */
    inline RequestMediaPlayerIndexedListSliceStart& operator = (const RequestMediaPlayerIndexedListSliceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestMediaPlayerIndexedListSliceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestMediaPlayerIndexedListSliceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestMediaPlayerIndexedListSliceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestMediaPlayerIndexedListSliceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32WindowStart"

    static const int kU32WindowStart = 1;

    /**
     * Clears the field "u32WindowStart".
     *
     * The field will be set to its default value. The hasU32WindowStart()
     * method will return false.
     */
    inline void clearU32WindowStart();

    /**
     * Checks whether the field "u32WindowStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WindowStart()). Otherwise it will return false.
     */
    inline bool hasU32WindowStart () const;

    /**
     * Returns the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @return The value of the field "u32WindowStart"
     */
    inline uint32 getU32WindowStart () const;

    /**
     * Sets the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @param u32WindowStart The value which will be set
     */
    inline void setU32WindowStart (uint32 u32WindowStart_);

    // API of field "u16WindowSize"

    static const int kU16WindowSize = 2;

    /**
     * Clears the field "u16WindowSize".
     *
     * The field will be set to its default value. The hasU16WindowSize()
     * method will return false.
     */
    inline void clearU16WindowSize();

    /**
     * Checks whether the field "u16WindowSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16WindowSize()). Otherwise it will return false.
     */
    inline bool hasU16WindowSize () const;

    /**
     * Returns the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @return The value of the field "u16WindowSize"
     */
    inline uint16 getU16WindowSize () const;

    /**
     * Sets the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @param u16WindowSize The value which will be set
     */
    inline void setU16WindowSize (uint16 u16WindowSize_);

    // API of field "DeviceTag"

    static const int kDeviceTag = 3;

    /**
     * Clears the field "DeviceTag".
     *
     * The field will be set to its default value. The hasDeviceTag()
     * method will return false.
     */
    inline void clearDeviceTag();

    /**
     * Checks whether the field "DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceTag()). Otherwise it will return false.
     */
    inline bool hasDeviceTag () const;

    /**
     * Returns the value of the member "DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     *
     * @return The value of the field "DeviceTag"
     */
    inline uint8 getDeviceTag () const;

    /**
     * Sets the value of the member "DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     *
     * @param DeviceTag The value which will be set
     */
    inline void setDeviceTag (uint8 DeviceTag_);

    static const RequestMediaPlayerIndexedListSliceStart &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32WindowStart ();

    inline void clear_has_u32WindowStart ();

    inline void set_has_u16WindowSize ();

    inline void clear_has_u16WindowSize ();

    inline void set_has_DeviceTag ();

    inline void clear_has_DeviceTag ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32WindowStart;

    uint16 _u16WindowSize;

    uint8 _DeviceTag;

};

/**
 * The result message of the method "RequestMediaPlayerIndexedListSlice"
 * The RequestMediaPlayerIndexedListSlice method provides a slice of the
 * filtered list specified by the ListHandle parameter. The slice begins
 * with the item at location WindowStart and includes in sequential order
 * the number of items specified by the parameter WindowSize.
 *
 * The RequestListSlice method returns the slice as a MediaObjects stream.
 * The data contained in each MediaObject is used by the HMI to determine
 * the meta-data and other properties of the media object.
 *
 * If the number of items in the list starting at WindowStart is less than
 * the WindowSize parameter then the number of items provided in the slice
 * will be less than the WindowSize calling parameter.
 */
class RequestMediaPlayerIndexedListSliceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestMediaPlayerIndexedListSliceResult ();

    /**
     * Copy constructor
     */
    inline  RequestMediaPlayerIndexedListSliceResult (const RequestMediaPlayerIndexedListSliceResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestMediaPlayerIndexedListSliceResult (const ::MPlay_fi_types::T_MPlayMediaObjects& oMediaObjects_);

    /**
     * Destructor
     */
    inline virtual  ~RequestMediaPlayerIndexedListSliceResult();

    /**
     * Assignment operator
     */
    inline RequestMediaPlayerIndexedListSliceResult& operator = (const RequestMediaPlayerIndexedListSliceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestMediaPlayerIndexedListSliceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestMediaPlayerIndexedListSliceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestMediaPlayerIndexedListSliceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestMediaPlayerIndexedListSliceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMediaObjects"

    static const int kOMediaObjects = 0;

    /**
     * Clears the field "oMediaObjects".
     *
     * The field will be set to its default value. The hasOMediaObjects()
     * method will return false.
     */
    inline void clearOMediaObjects();

    /**
     * Checks whether the field "oMediaObjects" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMediaObjects()). Otherwise it will return false.
     */
    inline bool hasOMediaObjects () const;

    /**
     * Returns the value of the member "oMediaObjects".
     *
     * All information necessary to retrieve and play a given media object, including all meta-data for that object
     *
     * @return The value of the field "oMediaObjects"
     */
    inline const ::MPlay_fi_types::T_MPlayMediaObjects& getOMediaObjects () const;

    /**
     * Retrieves the value of the field "oMediaObjects" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMediaObjects".
     */
    inline ::MPlay_fi_types::T_MPlayMediaObjects& getOMediaObjectsMutable ();

    /**
     * Sets the value of the member "oMediaObjects".
     *
     * All information necessary to retrieve and play a given media object, including all meta-data for that object
     *
     * @param oMediaObjects The value which will be set
     */
    inline void setOMediaObjects (const ::MPlay_fi_types::T_MPlayMediaObjects& oMediaObjects_);

    static const RequestMediaPlayerIndexedListSliceResult &getDefaultInstance();

private:

    static const ::std::vector< ::MPlay_fi_types::T_MPlayMediaObjectsItem >& getT_MPlayMediaObjectsItemList_DefaultInstance ();

    inline void set_has_oMediaObjects ();

    inline void clear_has_oMediaObjects ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects;

};

/**
 * The start message of the method "ReleaseMediaPlayerList"
 * The ReleaseMediaPlayerList function releases a list that has been
 * created by the  CreateMediaPlayerFileList, CreateMediaPlayerIndexedList,
 * CreateMediaPlayerQuickPlayList methods.  The list to release is
 * specified by the ListHandle parameter. The ListHandle becomes invalid by
 * this function.
 *
 * Possible errors that may be encountered include: ERR_INVALID_HANDLE
 */
class ReleaseMediaPlayerListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseMediaPlayerListStart ();

    /**
     * Copy constructor
     */
    inline  ReleaseMediaPlayerListStart (const ReleaseMediaPlayerListStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseMediaPlayerListStart (uint32 u32ListHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseMediaPlayerListStart();

    /**
     * Assignment operator
     */
    inline ReleaseMediaPlayerListStart& operator = (const ReleaseMediaPlayerListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseMediaPlayerListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseMediaPlayerListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseMediaPlayerListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseMediaPlayerListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    static const ReleaseMediaPlayerListStart &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32ListHandle;

};

/**
 * The start message of the method "RequestPlaybackAction"
 * Requests the playback action for the currently playing media files.
 * Playback actions include:
 * Previous or next track
 * Fast forward or fast reverse
 * Play, pause, or stop
 * Folder up or folder down
 */
class RequestPlaybackActionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPlaybackActionStart ();

    /**
     * Copy constructor
     */
    inline  RequestPlaybackActionStart (const RequestPlaybackActionStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPlaybackActionStart (::MPlay_fi_types::T_e8_MPlayAction e8Action_, uint8 u8NextPrevSkipCount_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPlaybackActionStart();

    /**
     * Assignment operator
     */
    inline RequestPlaybackActionStart& operator = (const RequestPlaybackActionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPlaybackActionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPlaybackActionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPlaybackActionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPlaybackActionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Action"

    static const int kE8Action = 0;

    /**
     * Clears the field "e8Action".
     *
     * The field will be set to its default value. The hasE8Action()
     * method will return false.
     */
    inline void clearE8Action();

    /**
     * Checks whether the field "e8Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Action()). Otherwise it will return false.
     */
    inline bool hasE8Action () const;

    /**
     * Returns the value of the member "e8Action".
     *
     * Specifies the playback action to request.
     *
     * @return The value of the field "e8Action"
     */
    inline ::MPlay_fi_types::T_e8_MPlayAction getE8Action () const;

    /**
     * Sets the value of the member "e8Action".
     *
     * Specifies the playback action to request.
     *
     * @param e8Action The value which will be set
     */
    inline void setE8Action (::MPlay_fi_types::T_e8_MPlayAction e8Action_);

    // API of field "u8NextPrevSkipCount"

    static const int kU8NextPrevSkipCount = 1;

    /**
     * Clears the field "u8NextPrevSkipCount".
     *
     * The field will be set to its default value. The hasU8NextPrevSkipCount()
     * method will return false.
     */
    inline void clearU8NextPrevSkipCount();

    /**
     * Checks whether the field "u8NextPrevSkipCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NextPrevSkipCount()). Otherwise it will return false.
     */
    inline bool hasU8NextPrevSkipCount () const;

    /**
     * Returns the value of the member "u8NextPrevSkipCount".
     *
     * The number of tracks to skip on a Next/Previous action or the number of folders to skip on a Folder_Up/Folder_Down action. Note that this parameter is unsigned and must be greater than/equal to 1. Also, this parameter is defined only for Next/Previous and Folder_Up/Folder_Down actions. For other Actions, it shall be defaulted to 1.
     *
     * @return The value of the field "u8NextPrevSkipCount"
     */
    inline uint8 getU8NextPrevSkipCount () const;

    /**
     * Sets the value of the member "u8NextPrevSkipCount".
     *
     * The number of tracks to skip on a Next/Previous action or the number of folders to skip on a Folder_Up/Folder_Down action. Note that this parameter is unsigned and must be greater than/equal to 1. Also, this parameter is defined only for Next/Previous and Folder_Up/Folder_Down actions. For other Actions, it shall be defaulted to 1.
     *
     * @param u8NextPrevSkipCount The value which will be set
     */
    inline void setU8NextPrevSkipCount (uint8 u8NextPrevSkipCount_);

    static const RequestPlaybackActionStart &getDefaultInstance();

private:

    inline void set_has_e8Action ();

    inline void clear_has_e8Action ();

    inline void set_has_u8NextPrevSkipCount ();

    inline void clear_has_u8NextPrevSkipCount ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayAction _e8Action;

    uint8 _u8NextPrevSkipCount;

};

/**
 * The start message of the method "SeekTo"
 * Requests to move to a specific point within the current track. The desired
 * position can be expressed either as a percentage of the TotalPlaytime or
 * as the absolute desired playpoint position. The two parameters are
 * mutually exclusive.
 */
class SeekToStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SeekToStart ();

    /**
     * Copy constructor
     */
    inline  SeekToStart (const SeekToStart &rhs);

    /**
     * All fields constructor
     */
    inline  SeekToStart (uint32 u32PlaypointPosition_, ::MPlay_fi_types::T_e8_MPlayPlaypointFormat e8PlaypointFormat_);

    /**
     * Destructor
     */
    inline virtual  ~SeekToStart();

    /**
     * Assignment operator
     */
    inline SeekToStart& operator = (const SeekToStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SeekToStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SeekToStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SeekToStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SeekToStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32PlaypointPosition"

    static const int kU32PlaypointPosition = 0;

    /**
     * Clears the field "u32PlaypointPosition".
     *
     * The field will be set to its default value. The hasU32PlaypointPosition()
     * method will return false.
     */
    inline void clearU32PlaypointPosition();

    /**
     * Checks whether the field "u32PlaypointPosition" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PlaypointPosition()). Otherwise it will return false.
     */
    inline bool hasU32PlaypointPosition () const;

    /**
     * Returns the value of the member "u32PlaypointPosition".
     *
     * The desired position in the current track to move the playpoint.  The , as an absolute time in milliseconds.
     * The desired position in the current track to move the playpoint, as a percentage of the TotalPlaytime
     *
     * @return The value of the field "u32PlaypointPosition"
     */
    inline uint32 getU32PlaypointPosition () const;

    /**
     * Sets the value of the member "u32PlaypointPosition".
     *
     * The desired position in the current track to move the playpoint.  The , as an absolute time in milliseconds.
     * The desired position in the current track to move the playpoint, as a percentage of the TotalPlaytime
     *
     * @param u32PlaypointPosition The value which will be set
     */
    inline void setU32PlaypointPosition (uint32 u32PlaypointPosition_);

    // API of field "e8PlaypointFormat"

    static const int kE8PlaypointFormat = 1;

    /**
     * Clears the field "e8PlaypointFormat".
     *
     * The field will be set to its default value. The hasE8PlaypointFormat()
     * method will return false.
     */
    inline void clearE8PlaypointFormat();

    /**
     * Checks whether the field "e8PlaypointFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaypointFormat()). Otherwise it will return false.
     */
    inline bool hasE8PlaypointFormat () const;

    /**
     * Returns the value of the member "e8PlaypointFormat".
     *
     * PlaypointFormat defines the interpretation of the PlaypointPosition parameter
     *
     * @return The value of the field "e8PlaypointFormat"
     */
    inline ::MPlay_fi_types::T_e8_MPlayPlaypointFormat getE8PlaypointFormat () const;

    /**
     * Sets the value of the member "e8PlaypointFormat".
     *
     * PlaypointFormat defines the interpretation of the PlaypointPosition parameter
     *
     * @param e8PlaypointFormat The value which will be set
     */
    inline void setE8PlaypointFormat (::MPlay_fi_types::T_e8_MPlayPlaypointFormat e8PlaypointFormat_);

    static const SeekToStart &getDefaultInstance();

private:

    inline void set_has_u32PlaypointPosition ();

    inline void clear_has_u32PlaypointPosition ();

    inline void set_has_e8PlaypointFormat ();

    inline void clear_has_e8PlaypointFormat ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32PlaypointPosition;

    ::MPlay_fi_types::T_e8_MPlayPlaypointFormat _e8PlaypointFormat;

};

/**
 * The start message of the method "GetMediaObjectAlbumArt"
 * The GetMediaObjectAlbumArt method is called to retrieve the album art
 * image, if it exists, for a particular media object. The image is returned
 * in a MIME-typed image format. To get the MIME type, as well as image size,
 * controllers first call the GetMediaObjectAlbumArtInfo Method, retrieve the
 * MIME type and size to set up the retrieval of the album art, then call
 * GetMediaObjectAlbumArt to retrieve the actual image data. The size of the image can be defined by the
 * values u32SizeX and u32SizeY. This values shall be identical to the used values in GetMediaObjectAlbumArtInfo.
 * The FBlock and calling controller shall support the following image file
 * formats. If a particular media object's Album art is not in one of these
 * supported formats, the FBlock shall either transcode the album art into
 * one of these formats or report no album art (by setting the AlbumArt URL
 * to a NULL zero-length string for the object in the GetMediaObject
 * ResultAck data).
 * PNG Format
 * MIME Type = 'image/png'
 * PNG 'TrueColor' 24-bit format without Alpha blending
 * PNG 'Indexed' with 1, 2, 4, and 8 bits per pixel
 * BMP Format
 * MIME Type = 'image/x-ms-bmp'
 * Header field = 'BM' (other header types not supported)
 * Bits per pixel = 8, 16, or 24
 * Number of colors in color palette = 0, full color, as well as
 * paletted support for the above Bits per pixel avalues.
 * Compression = RGB, RLE8, and BITFIELDS
 *
 * JPEG and PNGs contained within a BMP are intended for printer
 * support only and are not required. JPEG and PNG images shall be
 * transmitted as dedicated JPEG and PNG images instead of
 * containerizing within the BMP format.
 * GIF Format
 * MIME Type = 'image/gif'
 * LZW compressed support only. No Animated GIF support required.
 * JPEG Format (JPEG File Interchange Format (JFIF) per ISO/IEC FCD
 * 10918-5)
 * MIME Type = 'image/jpeg'
 * Thumbnail data and JFIF extension segment format not required.
 * i.e. Only one image per each JPEG formatted MHP transmission.
 * For all of the formats above, the maximum size and image resolution
 * are limited by internal calibrations within the FBlock. For album art
 * above this limit, the FBlock shall scale the image down to the maximum
 * supported size if possible. If image re-scaling is not possible, then
 * the FBlock shall report no image for the associated Album art.
 */
class GetMediaObjectAlbumArtStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMediaObjectAlbumArtStart ();

    /**
     * Copy constructor
     */
    inline  GetMediaObjectAlbumArtStart (const GetMediaObjectAlbumArtStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetMediaObjectAlbumArtStart (const ::std::string& sAlbumArt_, uint32 u32SizeX_, uint32 u32SizeY_);

    /**
     * Destructor
     */
    inline virtual  ~GetMediaObjectAlbumArtStart();

    /**
     * Assignment operator
     */
    inline GetMediaObjectAlbumArtStart& operator = (const GetMediaObjectAlbumArtStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMediaObjectAlbumArtStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMediaObjectAlbumArtStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMediaObjectAlbumArtStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMediaObjectAlbumArtStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sAlbumArt"

    static const int kSAlbumArt = 0;

    /**
     * Clears the field "sAlbumArt".
     *
     * The field will be set to its default value. The hasSAlbumArt()
     * method will return false.
     */
    inline void clearSAlbumArt();

    /**
     * Checks whether the field "sAlbumArt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAlbumArt()). Otherwise it will return false.
     */
    inline bool hasSAlbumArt () const;

    /**
     * Returns the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @return The value of the field "sAlbumArt"
     */
    inline const ::std::string& getSAlbumArt () const;

    /**
     * Retrieves the value of the field "sAlbumArt" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAlbumArt".
     */
    inline ::std::string& getSAlbumArtMutable ();

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const ::std::string& sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* value, size_t size);

    // API of field "u32SizeX"

    static const int kU32SizeX = 1;

    /**
     * Clears the field "u32SizeX".
     *
     * The field will be set to its default value. The hasU32SizeX()
     * method will return false.
     */
    inline void clearU32SizeX();

    /**
     * Checks whether the field "u32SizeX" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SizeX()). Otherwise it will return false.
     */
    inline bool hasU32SizeX () const;

    /**
     * Returns the value of the member "u32SizeX".
     *
     * Number of pixels in X direction
     *
     * @return The value of the field "u32SizeX"
     */
    inline uint32 getU32SizeX () const;

    /**
     * Sets the value of the member "u32SizeX".
     *
     * Number of pixels in X direction
     *
     * @param u32SizeX The value which will be set
     */
    inline void setU32SizeX (uint32 u32SizeX_);

    // API of field "u32SizeY"

    static const int kU32SizeY = 2;

    /**
     * Clears the field "u32SizeY".
     *
     * The field will be set to its default value. The hasU32SizeY()
     * method will return false.
     */
    inline void clearU32SizeY();

    /**
     * Checks whether the field "u32SizeY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SizeY()). Otherwise it will return false.
     */
    inline bool hasU32SizeY () const;

    /**
     * Returns the value of the member "u32SizeY".
     *
     * Number of pixels in Y direction
     *
     * @return The value of the field "u32SizeY"
     */
    inline uint32 getU32SizeY () const;

    /**
     * Sets the value of the member "u32SizeY".
     *
     * Number of pixels in Y direction
     *
     * @param u32SizeY The value which will be set
     */
    inline void setU32SizeY (uint32 u32SizeY_);

    static const GetMediaObjectAlbumArtStart &getDefaultInstance();

private:

    inline void set_has_sAlbumArt ();

    inline void clear_has_sAlbumArt ();

    inline void set_has_u32SizeX ();

    inline void clear_has_u32SizeX ();

    inline void set_has_u32SizeY ();

    inline void clear_has_u32SizeY ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sAlbumArt;

    uint32 _u32SizeX;

    uint32 _u32SizeY;

};

/**
 * The result message of the method "GetMediaObjectAlbumArt"
 * The GetMediaObjectAlbumArt method is called to retrieve the album art
 * image, if it exists, for a particular media object. The image is returned
 * in a MIME-typed image format. To get the MIME type, as well as image size,
 * controllers first call the GetMediaObjectAlbumArtInfo Method, retrieve the
 * MIME type and size to set up the retrieval of the album art, then call
 * GetMediaObjectAlbumArt to retrieve the actual image data. The size of the image can be defined by the
 * values u32SizeX and u32SizeY. This values shall be identical to the used values in GetMediaObjectAlbumArtInfo.
 * The FBlock and calling controller shall support the following image file
 * formats. If a particular media object's Album art is not in one of these
 * supported formats, the FBlock shall either transcode the album art into
 * one of these formats or report no album art (by setting the AlbumArt URL
 * to a NULL zero-length string for the object in the GetMediaObject
 * ResultAck data).
 * PNG Format
 * MIME Type = 'image/png'
 * PNG 'TrueColor' 24-bit format without Alpha blending
 * PNG 'Indexed' with 1, 2, 4, and 8 bits per pixel
 * BMP Format
 * MIME Type = 'image/x-ms-bmp'
 * Header field = 'BM' (other header types not supported)
 * Bits per pixel = 8, 16, or 24
 * Number of colors in color palette = 0, full color, as well as
 * paletted support for the above Bits per pixel avalues.
 * Compression = RGB, RLE8, and BITFIELDS
 *
 * JPEG and PNGs contained within a BMP are intended for printer
 * support only and are not required. JPEG and PNG images shall be
 * transmitted as dedicated JPEG and PNG images instead of
 * containerizing within the BMP format.
 * GIF Format
 * MIME Type = 'image/gif'
 * LZW compressed support only. No Animated GIF support required.
 * JPEG Format (JPEG File Interchange Format (JFIF) per ISO/IEC FCD
 * 10918-5)
 * MIME Type = 'image/jpeg'
 * Thumbnail data and JFIF extension segment format not required.
 * i.e. Only one image per each JPEG formatted MHP transmission.
 * For all of the formats above, the maximum size and image resolution
 * are limited by internal calibrations within the FBlock. For album art
 * above this limit, the FBlock shall scale the image down to the maximum
 * supported size if possible. If image re-scaling is not possible, then
 * the FBlock shall report no image for the associated Album art.
 */
class GetMediaObjectAlbumArtResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMediaObjectAlbumArtResult ();

    /**
     * Copy constructor
     */
    inline  GetMediaObjectAlbumArtResult (const GetMediaObjectAlbumArtResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetMediaObjectAlbumArtResult (const ::MPlay_fi_types::T_MPlayImageData& oImageData_);

    /**
     * Destructor
     */
    inline virtual  ~GetMediaObjectAlbumArtResult();

    /**
     * Assignment operator
     */
    inline GetMediaObjectAlbumArtResult& operator = (const GetMediaObjectAlbumArtResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMediaObjectAlbumArtResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMediaObjectAlbumArtResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMediaObjectAlbumArtResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMediaObjectAlbumArtResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oImageData"

    static const int kOImageData = 0;

    /**
     * Clears the field "oImageData".
     *
     * The field will be set to its default value. The hasOImageData()
     * method will return false.
     */
    inline void clearOImageData();

    /**
     * Checks whether the field "oImageData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOImageData()). Otherwise it will return false.
     */
    inline bool hasOImageData () const;

    /**
     * Returns the value of the member "oImageData".
     *
     * An image
     *
     * @return The value of the field "oImageData"
     */
    inline const ::MPlay_fi_types::T_MPlayImageData& getOImageData () const;

    /**
     * Retrieves the value of the field "oImageData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oImageData".
     */
    inline ::MPlay_fi_types::T_MPlayImageData& getOImageDataMutable ();

    /**
     * Sets the value of the member "oImageData".
     *
     * An image
     *
     * @param oImageData The value which will be set
     */
    inline void setOImageData (const ::MPlay_fi_types::T_MPlayImageData& oImageData_);

    static const GetMediaObjectAlbumArtResult &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_oImageData ();

    inline void clear_has_oImageData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_MPlayImageData _oImageData;

};

/**
 * The start message of the method "SearchKeyboardMediaPlayerList"
 * This function returns the search keyboard for a particular ListHandle.  The returned list identifies which letters of the Vertical Keyboard have at
 * least one Media Player entry that start with that letter. The index of the
 * first entry associated with the letter is also provided.If a
 * letter does not have an index then a Media Player entry that starts with
 * that letter does not exist.
 *
 * Note that the returned search keyboard list may no longer be valid if items in the underlying list have changed.  Thus, controllers shall re-request the search keyboard list upon a receipt of MediaPlayerListChange for the ListHandle tied to the returned search keyboard.
 */
class SearchKeyboardMediaPlayerListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SearchKeyboardMediaPlayerListStart ();

    /**
     * Copy constructor
     */
    inline  SearchKeyboardMediaPlayerListStart (const SearchKeyboardMediaPlayerListStart &rhs);

    /**
     * All fields constructor
     */
    inline  SearchKeyboardMediaPlayerListStart (uint32 u32ListHandle_);

    /**
     * Destructor
     */
    inline virtual  ~SearchKeyboardMediaPlayerListStart();

    /**
     * Assignment operator
     */
    inline SearchKeyboardMediaPlayerListStart& operator = (const SearchKeyboardMediaPlayerListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchKeyboardMediaPlayerListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchKeyboardMediaPlayerListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchKeyboardMediaPlayerListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchKeyboardMediaPlayerListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    static const SearchKeyboardMediaPlayerListStart &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32ListHandle;

};

/**
 * The result message of the method "SearchKeyboardMediaPlayerList"
 * This function returns the search keyboard for a particular ListHandle.  The returned list identifies which letters of the Vertical Keyboard have at
 * least one Media Player entry that start with that letter. The index of the
 * first entry associated with the letter is also provided.If a
 * letter does not have an index then a Media Player entry that starts with
 * that letter does not exist.
 *
 * Note that the returned search keyboard list may no longer be valid if items in the underlying list have changed.  Thus, controllers shall re-request the search keyboard list upon a receipt of MediaPlayerListChange for the ListHandle tied to the returned search keyboard.
 */
class SearchKeyboardMediaPlayerListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SearchKeyboardMediaPlayerListResult ();

    /**
     * Copy constructor
     */
    inline  SearchKeyboardMediaPlayerListResult (const SearchKeyboardMediaPlayerListResult &rhs);

    /**
     * All fields constructor
     */
    inline  SearchKeyboardMediaPlayerListResult (uint32 u32ListHandle_, const ::MPlay_fi_types::T_MPlaySearchKeyboardList& oSearchKeyboardList_);

    /**
     * Destructor
     */
    inline virtual  ~SearchKeyboardMediaPlayerListResult();

    /**
     * Assignment operator
     */
    inline SearchKeyboardMediaPlayerListResult& operator = (const SearchKeyboardMediaPlayerListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchKeyboardMediaPlayerListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchKeyboardMediaPlayerListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchKeyboardMediaPlayerListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchKeyboardMediaPlayerListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "oSearchKeyboardList"

    static const int kOSearchKeyboardList = 1;

    /**
     * Clears the field "oSearchKeyboardList".
     *
     * The field will be set to its default value. The hasOSearchKeyboardList()
     * method will return false.
     */
    inline void clearOSearchKeyboardList();

    /**
     * Checks whether the field "oSearchKeyboardList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOSearchKeyboardList()). Otherwise it will return false.
     */
    inline bool hasOSearchKeyboardList () const;

    /**
     * Returns the value of the member "oSearchKeyboardList".
     *
     * Provides a list of each letter of the alphabet and the start index within the media player
     *
     * @return The value of the field "oSearchKeyboardList"
     */
    inline const ::MPlay_fi_types::T_MPlaySearchKeyboardList& getOSearchKeyboardList () const;

    /**
     * Retrieves the value of the field "oSearchKeyboardList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oSearchKeyboardList".
     */
    inline ::MPlay_fi_types::T_MPlaySearchKeyboardList& getOSearchKeyboardListMutable ();

    /**
     * Sets the value of the member "oSearchKeyboardList".
     *
     * Provides a list of each letter of the alphabet and the start index within the media player
     *
     * @param oSearchKeyboardList The value which will be set
     */
    inline void setOSearchKeyboardList (const ::MPlay_fi_types::T_MPlaySearchKeyboardList& oSearchKeyboardList_);

    static const SearchKeyboardMediaPlayerListResult &getDefaultInstance();

private:

    static const ::std::vector< ::MPlay_fi_types::T_MPlaySearchKeyboardListItem >& getT_MPlaySearchKeyboardListItemList_DefaultInstance ();

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_oSearchKeyboardList ();

    inline void clear_has_oSearchKeyboardList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ListHandle;

    ::MPlay_fi_types::T_MPlaySearchKeyboardList _oSearchKeyboardList;

};

/**
 * The start message of the method "CreateMediaPlayerListSearchString"
 * <p>This method creates a new list that contains the meta-data values of the
 * requested indexed media based on a parent list plus a character or string search.</p>
 * <p>Before using this function client has to setup a parent list using function CreateMediaPlayerIdexedList
 * or CreateMediaPlayerFileList.
 *
 * This is premisses for function 'CreateMediaPlayerListSearchString' to be used</p>
 * <p>A search string is the main parameter in addition to the ListID of the previously created parent list.
 * Internally from this parent ID filter Tags of parent are gained which are used then in additiona to the mentioned  characted or string to
 * search subset results in the metadata database.
 *
 * In other words the order and content of the list generated
 * dependent on the filter criteria of the parent list plus the character or string used.
 *
 * To get an overview which types of list are supported please refer to ai_mediaplayer/components/GenericMediaplayer/Common/TypeDefinitions.h
 * and 'tListType' for all supported parent list types a list type '_SEARCH' exists. Example 'LTY_ALBUM' has 'LTY_ALBUM_SEARCH'
 *
 * Special: File Lists are supported after indexing as Browse lists (under construction)</p>
 * <p>Method 'CreateMediaPlayerListSearchString' returns a handle (ListID). And a size. If size of this list is 0 the list is empty.
 *
 * As a next reaction 3 types of messages are send: MethodReturnFirst (once), MethodReturnMiddle (several), MethodReturnLast (once)
 *
 * Scenario Empty list size==0:
 * MethodReturnFirst once sends size 0, MethodReturnMiddle once sends size 0 and MethodReturnLast once sends size 0
 *
 * Scenario List size==1:
 * MethodReturnFirst once sends size 1, MethodReturnMiddle once sends size 1 and MethodReturnLast once sends size 1
 *
 * Scenario List size==10 (example increment would be 5):
 * MethodReturnFirst once sends size 1, MethodReturnMiddle sends 1,5,10 and MethodReturnLast once sends size 10
 *
 * Note: The increment is defined within mediaplayer (under construction: configurable per project) above '5' is just given as an example.</p>
 * <p>Scenario: Delete list:
 * A list is considered to be valid until the ReleaseMediaPlayerList function is executed.
 *
 * Between executing search increments the full text search thread search is interruptable. To do the following options:
 *
 * Release parent list results in release of parent list plus all search lists which depend on it.
 *
 * Release a search list based on listID (handle) of search lists release this specific list.
 *
 * Create new search list with having previously created search list as parameter 'replacable list'
 *
 * Internally shutdown of mediaplayer releases all lists and thus also all search lists.
 *
 * If full text search is aborted in the mentioned way then no MethodReturnLast is send. Instead MethodAbort is send</p>
 */
class CreateMediaPlayerListSearchStringStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerListSearchStringStart ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerListSearchStringStart (const CreateMediaPlayerListSearchStringStart &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerListSearchStringStart (uint32 u32ListHandleOfParent_, uint32 u32ListHandleOfReplaceableList_, const ::std::string& sSearchString_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerListSearchStringStart();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerListSearchStringStart& operator = (const CreateMediaPlayerListSearchStringStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerListSearchStringStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerListSearchStringStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerListSearchStringStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerListSearchStringStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandleOfParent"

    static const int kU32ListHandleOfParent = 0;

    /**
     * Clears the field "u32ListHandleOfParent".
     *
     * The field will be set to its default value. The hasU32ListHandleOfParent()
     * method will return false.
     */
    inline void clearU32ListHandleOfParent();

    /**
     * Checks whether the field "u32ListHandleOfParent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandleOfParent()). Otherwise it will return false.
     */
    inline bool hasU32ListHandleOfParent () const;

    /**
     * Returns the value of the member "u32ListHandleOfParent".
     *
     * Each full text search list is based on
     * ListID gained with e.g. method CreateMediaPlayerIndexedList. Filter tags of such parent
     * list are used then internally to create the list.
     *
     * @return The value of the field "u32ListHandleOfParent"
     */
    inline uint32 getU32ListHandleOfParent () const;

    /**
     * Sets the value of the member "u32ListHandleOfParent".
     *
     * Each full text search list is based on
     * ListID gained with e.g. method CreateMediaPlayerIndexedList. Filter tags of such parent
     * list are used then internally to create the list.
     *
     * @param u32ListHandleOfParent The value which will be set
     */
    inline void setU32ListHandleOfParent (uint32 u32ListHandleOfParent_);

    // API of field "u32ListHandleOfReplaceableList"

    static const int kU32ListHandleOfReplaceableList = 1;

    /**
     * Clears the field "u32ListHandleOfReplaceableList".
     *
     * The field will be set to its default value. The hasU32ListHandleOfReplaceableList()
     * method will return false.
     */
    inline void clearU32ListHandleOfReplaceableList();

    /**
     * Checks whether the field "u32ListHandleOfReplaceableList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandleOfReplaceableList()). Otherwise it will return false.
     */
    inline bool hasU32ListHandleOfReplaceableList () const;

    /**
     * Returns the value of the member "u32ListHandleOfReplaceableList".
     *
     * <p>release list with ID/handle 'u32ListHandleOfReplaceableList'
     * 0 means no replacable list id.
     * >0 means valis listID this lsit should be released while creating the new one.</p>
     * <p>This list with ID/handle 'u32ListHandleOfReplaceableList' will be released in course of creation the new one with ID/handle u32ListHandleOfParent.
     * If parameter is 0 no List will be released. Otherwhise list with handle u32ListHandleOfReplaceableList will be deleted/released.
     * Example Scenario: User types in first character then this Method CreateIndexListWithSearchString() is used with Method RequestListSize()
     * to show results. It e.g. return 'ListHandle1' If the user types in an additional character CreateIndexListWithSearchString()is called to get another list but with
     * parameter u32ListHandleOfReplaceableList=ListHandle1. The first list then gets obsolete/deleted.</p>
     *
     * @return The value of the field "u32ListHandleOfReplaceableList"
     */
    inline uint32 getU32ListHandleOfReplaceableList () const;

    /**
     * Sets the value of the member "u32ListHandleOfReplaceableList".
     *
     * <p>release list with ID/handle 'u32ListHandleOfReplaceableList'
     * 0 means no replacable list id.
     * >0 means valis listID this lsit should be released while creating the new one.</p>
     * <p>This list with ID/handle 'u32ListHandleOfReplaceableList' will be released in course of creation the new one with ID/handle u32ListHandleOfParent.
     * If parameter is 0 no List will be released. Otherwhise list with handle u32ListHandleOfReplaceableList will be deleted/released.
     * Example Scenario: User types in first character then this Method CreateIndexListWithSearchString() is used with Method RequestListSize()
     * to show results. It e.g. return 'ListHandle1' If the user types in an additional character CreateIndexListWithSearchString()is called to get another list but with
     * parameter u32ListHandleOfReplaceableList=ListHandle1. The first list then gets obsolete/deleted.</p>
     *
     * @param u32ListHandleOfReplaceableList The value which will be set
     */
    inline void setU32ListHandleOfReplaceableList (uint32 u32ListHandleOfReplaceableList_);

    // API of field "sSearchString"

    static const int kSSearchString = 2;

    /**
     * Clears the field "sSearchString".
     *
     * The field will be set to its default value. The hasSSearchString()
     * method will return false.
     */
    inline void clearSSearchString();

    /**
     * Checks whether the field "sSearchString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSearchString()). Otherwise it will return false.
     */
    inline bool hasSSearchString () const;

    /**
     * Returns the value of the member "sSearchString".
     *
     * The FilterString contains unicode string to be useed as filter criteria in addition to
     * those of u32ListHandleOfParent
     *
     * @return The value of the field "sSearchString"
     */
    inline const ::std::string& getSSearchString () const;

    /**
     * Retrieves the value of the field "sSearchString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSearchString".
     */
    inline ::std::string& getSSearchStringMutable ();

    /**
     * Sets the value of the member "sSearchString".
     *
     * The FilterString contains unicode string to be useed as filter criteria in addition to
     * those of u32ListHandleOfParent
     *
     * @param sSearchString The value which will be set
     */
    inline void setSSearchString (const ::std::string& sSearchString_);

    /**
     * Sets the value of the member "sSearchString".
     *
     * The FilterString contains unicode string to be useed as filter criteria in addition to
     * those of u32ListHandleOfParent
     *
     * @param sSearchString The value which will be set
     */
    inline void setSSearchString (const char* sSearchString_);

    /**
     * Sets the value of the member "sSearchString".
     *
     * The FilterString contains unicode string to be useed as filter criteria in addition to
     * those of u32ListHandleOfParent
     *
     * @param sSearchString The value which will be set
     */
    inline void setSSearchString (const char* value, size_t size);

    static const CreateMediaPlayerListSearchStringStart &getDefaultInstance();

private:

    inline void set_has_u32ListHandleOfParent ();

    inline void clear_has_u32ListHandleOfParent ();

    inline void set_has_u32ListHandleOfReplaceableList ();

    inline void clear_has_u32ListHandleOfReplaceableList ();

    inline void set_has_sSearchString ();

    inline void clear_has_sSearchString ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32ListHandleOfParent;

    uint32 _u32ListHandleOfReplaceableList;

    ::std::string _sSearchString;

};

/**
 * The abort message of the method "CreateMediaPlayerListSearchString"
 * <p>This method creates a new list that contains the meta-data values of the
 * requested indexed media based on a parent list plus a character or string search.</p>
 * <p>Before using this function client has to setup a parent list using function CreateMediaPlayerIdexedList
 * or CreateMediaPlayerFileList.
 *
 * This is premisses for function 'CreateMediaPlayerListSearchString' to be used</p>
 * <p>A search string is the main parameter in addition to the ListID of the previously created parent list.
 * Internally from this parent ID filter Tags of parent are gained which are used then in additiona to the mentioned  characted or string to
 * search subset results in the metadata database.
 *
 * In other words the order and content of the list generated
 * dependent on the filter criteria of the parent list plus the character or string used.
 *
 * To get an overview which types of list are supported please refer to ai_mediaplayer/components/GenericMediaplayer/Common/TypeDefinitions.h
 * and 'tListType' for all supported parent list types a list type '_SEARCH' exists. Example 'LTY_ALBUM' has 'LTY_ALBUM_SEARCH'
 *
 * Special: File Lists are supported after indexing as Browse lists (under construction)</p>
 * <p>Method 'CreateMediaPlayerListSearchString' returns a handle (ListID). And a size. If size of this list is 0 the list is empty.
 *
 * As a next reaction 3 types of messages are send: MethodReturnFirst (once), MethodReturnMiddle (several), MethodReturnLast (once)
 *
 * Scenario Empty list size==0:
 * MethodReturnFirst once sends size 0, MethodReturnMiddle once sends size 0 and MethodReturnLast once sends size 0
 *
 * Scenario List size==1:
 * MethodReturnFirst once sends size 1, MethodReturnMiddle once sends size 1 and MethodReturnLast once sends size 1
 *
 * Scenario List size==10 (example increment would be 5):
 * MethodReturnFirst once sends size 1, MethodReturnMiddle sends 1,5,10 and MethodReturnLast once sends size 10
 *
 * Note: The increment is defined within mediaplayer (under construction: configurable per project) above '5' is just given as an example.</p>
 * <p>Scenario: Delete list:
 * A list is considered to be valid until the ReleaseMediaPlayerList function is executed.
 *
 * Between executing search increments the full text search thread search is interruptable. To do the following options:
 *
 * Release parent list results in release of parent list plus all search lists which depend on it.
 *
 * Release a search list based on listID (handle) of search lists release this specific list.
 *
 * Create new search list with having previously created search list as parameter 'replacable list'
 *
 * Internally shutdown of mediaplayer releases all lists and thus also all search lists.
 *
 * If full text search is aborted in the mentioned way then no MethodReturnLast is send. Instead MethodAbort is send</p>
 */
class CreateMediaPlayerListSearchStringAbort  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerListSearchStringAbort ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerListSearchStringAbort (const CreateMediaPlayerListSearchStringAbort &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerListSearchStringAbort (uint32 u32ListHandle_, uint32 u32ListSize_, uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerListSearchStringAbort();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerListSearchStringAbort& operator = (const CreateMediaPlayerListSearchStringAbort& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerListSearchStringAbort& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerListSearchStringAbort& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerListSearchStringAbort& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerListSearchStringAbort& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.
     * The handle is valid until ReleaseMediaPlayerList is called with this handle.
     * Or if u32ListHandle is given as u32ListHandleOfReplacementList with another call of
     * Method CreateMediaListWithSearchString()
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.
     * The handle is valid until ReleaseMediaPlayerList is called with this handle.
     * Or if u32ListHandle is given as u32ListHandleOfReplacementList with another call of
     * Method CreateMediaListWithSearchString()
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 1;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The number of elements of the list.  The size is valid until the list is modified or released.
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The number of elements of the list.  The size is valid until the list is modified or released.
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 2;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const CreateMediaPlayerListSearchStringAbort &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32ListSize;

    uint8 _u8DeviceTag;

};

/**
 * The result first message of the method "CreateMediaPlayerListSearchString"
 * <p>This method creates a new list that contains the meta-data values of the
 * requested indexed media based on a parent list plus a character or string search.</p>
 * <p>Before using this function client has to setup a parent list using function CreateMediaPlayerIdexedList
 * or CreateMediaPlayerFileList.
 *
 * This is premisses for function 'CreateMediaPlayerListSearchString' to be used</p>
 * <p>A search string is the main parameter in addition to the ListID of the previously created parent list.
 * Internally from this parent ID filter Tags of parent are gained which are used then in additiona to the mentioned  characted or string to
 * search subset results in the metadata database.
 *
 * In other words the order and content of the list generated
 * dependent on the filter criteria of the parent list plus the character or string used.
 *
 * To get an overview which types of list are supported please refer to ai_mediaplayer/components/GenericMediaplayer/Common/TypeDefinitions.h
 * and 'tListType' for all supported parent list types a list type '_SEARCH' exists. Example 'LTY_ALBUM' has 'LTY_ALBUM_SEARCH'
 *
 * Special: File Lists are supported after indexing as Browse lists (under construction)</p>
 * <p>Method 'CreateMediaPlayerListSearchString' returns a handle (ListID). And a size. If size of this list is 0 the list is empty.
 *
 * As a next reaction 3 types of messages are send: MethodReturnFirst (once), MethodReturnMiddle (several), MethodReturnLast (once)
 *
 * Scenario Empty list size==0:
 * MethodReturnFirst once sends size 0, MethodReturnMiddle once sends size 0 and MethodReturnLast once sends size 0
 *
 * Scenario List size==1:
 * MethodReturnFirst once sends size 1, MethodReturnMiddle once sends size 1 and MethodReturnLast once sends size 1
 *
 * Scenario List size==10 (example increment would be 5):
 * MethodReturnFirst once sends size 1, MethodReturnMiddle sends 1,5,10 and MethodReturnLast once sends size 10
 *
 * Note: The increment is defined within mediaplayer (under construction: configurable per project) above '5' is just given as an example.</p>
 * <p>Scenario: Delete list:
 * A list is considered to be valid until the ReleaseMediaPlayerList function is executed.
 *
 * Between executing search increments the full text search thread search is interruptable. To do the following options:
 *
 * Release parent list results in release of parent list plus all search lists which depend on it.
 *
 * Release a search list based on listID (handle) of search lists release this specific list.
 *
 * Create new search list with having previously created search list as parameter 'replacable list'
 *
 * Internally shutdown of mediaplayer releases all lists and thus also all search lists.
 *
 * If full text search is aborted in the mentioned way then no MethodReturnLast is send. Instead MethodAbort is send</p>
 */
class CreateMediaPlayerListSearchStringResultFirst  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerListSearchStringResultFirst ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerListSearchStringResultFirst (const CreateMediaPlayerListSearchStringResultFirst &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerListSearchStringResultFirst (uint32 u32ListHandle_, uint32 u32ListSize_, uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerListSearchStringResultFirst();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerListSearchStringResultFirst& operator = (const CreateMediaPlayerListSearchStringResultFirst& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerListSearchStringResultFirst& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerListSearchStringResultFirst& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerListSearchStringResultFirst& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerListSearchStringResultFirst& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.
     * The handle is valid until ReleaseMediaPlayerList is called with this handle.
     * Or if u32ListHandle is given as u32ListHandleOfReplacementList with another call of
     * Method CreateMediaListWithSearchString()
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.
     * The handle is valid until ReleaseMediaPlayerList is called with this handle.
     * Or if u32ListHandle is given as u32ListHandleOfReplacementList with another call of
     * Method CreateMediaListWithSearchString()
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 1;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The number of elements in a list found first.  The size is valid until the list is modified or released or MethodResultMiddle and MethodResultLast do update it
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The number of elements in a list found first.  The size is valid until the list is modified or released or MethodResultMiddle and MethodResultLast do update it
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 2;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const CreateMediaPlayerListSearchStringResultFirst &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32ListSize;

    uint8 _u8DeviceTag;

};

/**
 * The result middle message of the method "CreateMediaPlayerListSearchString"
 * <p>This method creates a new list that contains the meta-data values of the
 * requested indexed media based on a parent list plus a character or string search.</p>
 * <p>Before using this function client has to setup a parent list using function CreateMediaPlayerIdexedList
 * or CreateMediaPlayerFileList.
 *
 * This is premisses for function 'CreateMediaPlayerListSearchString' to be used</p>
 * <p>A search string is the main parameter in addition to the ListID of the previously created parent list.
 * Internally from this parent ID filter Tags of parent are gained which are used then in additiona to the mentioned  characted or string to
 * search subset results in the metadata database.
 *
 * In other words the order and content of the list generated
 * dependent on the filter criteria of the parent list plus the character or string used.
 *
 * To get an overview which types of list are supported please refer to ai_mediaplayer/components/GenericMediaplayer/Common/TypeDefinitions.h
 * and 'tListType' for all supported parent list types a list type '_SEARCH' exists. Example 'LTY_ALBUM' has 'LTY_ALBUM_SEARCH'
 *
 * Special: File Lists are supported after indexing as Browse lists (under construction)</p>
 * <p>Method 'CreateMediaPlayerListSearchString' returns a handle (ListID). And a size. If size of this list is 0 the list is empty.
 *
 * As a next reaction 3 types of messages are send: MethodReturnFirst (once), MethodReturnMiddle (several), MethodReturnLast (once)
 *
 * Scenario Empty list size==0:
 * MethodReturnFirst once sends size 0, MethodReturnMiddle once sends size 0 and MethodReturnLast once sends size 0
 *
 * Scenario List size==1:
 * MethodReturnFirst once sends size 1, MethodReturnMiddle once sends size 1 and MethodReturnLast once sends size 1
 *
 * Scenario List size==10 (example increment would be 5):
 * MethodReturnFirst once sends size 1, MethodReturnMiddle sends 1,5,10 and MethodReturnLast once sends size 10
 *
 * Note: The increment is defined within mediaplayer (under construction: configurable per project) above '5' is just given as an example.</p>
 * <p>Scenario: Delete list:
 * A list is considered to be valid until the ReleaseMediaPlayerList function is executed.
 *
 * Between executing search increments the full text search thread search is interruptable. To do the following options:
 *
 * Release parent list results in release of parent list plus all search lists which depend on it.
 *
 * Release a search list based on listID (handle) of search lists release this specific list.
 *
 * Create new search list with having previously created search list as parameter 'replacable list'
 *
 * Internally shutdown of mediaplayer releases all lists and thus also all search lists.
 *
 * If full text search is aborted in the mentioned way then no MethodReturnLast is send. Instead MethodAbort is send</p>
 */
class CreateMediaPlayerListSearchStringResultMiddle  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerListSearchStringResultMiddle ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerListSearchStringResultMiddle (const CreateMediaPlayerListSearchStringResultMiddle &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerListSearchStringResultMiddle (uint32 u32ListHandle_, uint32 u32ListSize_, uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerListSearchStringResultMiddle();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerListSearchStringResultMiddle& operator = (const CreateMediaPlayerListSearchStringResultMiddle& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerListSearchStringResultMiddle& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerListSearchStringResultMiddle& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerListSearchStringResultMiddle& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerListSearchStringResultMiddle& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.
     * The handle is valid until ReleaseMediaPlayerList is called with this handle.
     * Or if u32ListHandle is given as u32ListHandleOfReplacementList with another call of
     * Method CreateMediaListWithSearchString()
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.
     * The handle is valid until ReleaseMediaPlayerList is called with this handle.
     * Or if u32ListHandle is given as u32ListHandleOfReplacementList with another call of
     * Method CreateMediaListWithSearchString()
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 1;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The number of elements in a list found after MethodResultFirst has been returned.  The size is valid until the list is modified or released or MethodResultMiddle and MethodResultLast do update it
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The number of elements in a list found after MethodResultFirst has been returned.  The size is valid until the list is modified or released or MethodResultMiddle and MethodResultLast do update it
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 2;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const CreateMediaPlayerListSearchStringResultMiddle &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32ListSize;

    uint8 _u8DeviceTag;

};

/**
 * The result last message of the method "CreateMediaPlayerListSearchString"
 * <p>This method creates a new list that contains the meta-data values of the
 * requested indexed media based on a parent list plus a character or string search.</p>
 * <p>Before using this function client has to setup a parent list using function CreateMediaPlayerIdexedList
 * or CreateMediaPlayerFileList.
 *
 * This is premisses for function 'CreateMediaPlayerListSearchString' to be used</p>
 * <p>A search string is the main parameter in addition to the ListID of the previously created parent list.
 * Internally from this parent ID filter Tags of parent are gained which are used then in additiona to the mentioned  characted or string to
 * search subset results in the metadata database.
 *
 * In other words the order and content of the list generated
 * dependent on the filter criteria of the parent list plus the character or string used.
 *
 * To get an overview which types of list are supported please refer to ai_mediaplayer/components/GenericMediaplayer/Common/TypeDefinitions.h
 * and 'tListType' for all supported parent list types a list type '_SEARCH' exists. Example 'LTY_ALBUM' has 'LTY_ALBUM_SEARCH'
 *
 * Special: File Lists are supported after indexing as Browse lists (under construction)</p>
 * <p>Method 'CreateMediaPlayerListSearchString' returns a handle (ListID). And a size. If size of this list is 0 the list is empty.
 *
 * As a next reaction 3 types of messages are send: MethodReturnFirst (once), MethodReturnMiddle (several), MethodReturnLast (once)
 *
 * Scenario Empty list size==0:
 * MethodReturnFirst once sends size 0, MethodReturnMiddle once sends size 0 and MethodReturnLast once sends size 0
 *
 * Scenario List size==1:
 * MethodReturnFirst once sends size 1, MethodReturnMiddle once sends size 1 and MethodReturnLast once sends size 1
 *
 * Scenario List size==10 (example increment would be 5):
 * MethodReturnFirst once sends size 1, MethodReturnMiddle sends 1,5,10 and MethodReturnLast once sends size 10
 *
 * Note: The increment is defined within mediaplayer (under construction: configurable per project) above '5' is just given as an example.</p>
 * <p>Scenario: Delete list:
 * A list is considered to be valid until the ReleaseMediaPlayerList function is executed.
 *
 * Between executing search increments the full text search thread search is interruptable. To do the following options:
 *
 * Release parent list results in release of parent list plus all search lists which depend on it.
 *
 * Release a search list based on listID (handle) of search lists release this specific list.
 *
 * Create new search list with having previously created search list as parameter 'replacable list'
 *
 * Internally shutdown of mediaplayer releases all lists and thus also all search lists.
 *
 * If full text search is aborted in the mentioned way then no MethodReturnLast is send. Instead MethodAbort is send</p>
 */
class CreateMediaPlayerListSearchStringResultLast  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerListSearchStringResultLast ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerListSearchStringResultLast (const CreateMediaPlayerListSearchStringResultLast &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerListSearchStringResultLast (uint32 u32ListHandle_, uint32 u32ListSize_, uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerListSearchStringResultLast();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerListSearchStringResultLast& operator = (const CreateMediaPlayerListSearchStringResultLast& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerListSearchStringResultLast& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerListSearchStringResultLast& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerListSearchStringResultLast& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerListSearchStringResultLast& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.
     * The handle is valid until ReleaseMediaPlayerList is called with this handle.
     * Or if u32ListHandle is given as u32ListHandleOfReplacementList with another call of
     * Method CreateMediaListWithSearchString()
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.
     * The handle is valid until ReleaseMediaPlayerList is called with this handle.
     * Or if u32ListHandle is given as u32ListHandleOfReplacementList with another call of
     * Method CreateMediaListWithSearchString()
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 1;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The number of elements of the list.  The size is valid until the list is modified or released.
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The number of elements of the list.  The size is valid until the list is modified or released.
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 2;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const CreateMediaPlayerListSearchStringResultLast &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32ListSize;

    uint8 _u8DeviceTag;

};

/**
 * The start message of the method "GetMediaObject"
 * Request all meta-data information for a requested Tag item.  The CategoryType parameter is optional and can be used to limit the scope of a tag search.
 */
class GetMediaObjectStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMediaObjectStart ();

    /**
     * Copy constructor
     */
    inline  GetMediaObjectStart (const GetMediaObjectStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetMediaObjectStart (uint32 u32Tag_, ::MPlay_fi_types::T_e8_MPlayCategoryType e8CategoryType_);

    /**
     * Destructor
     */
    inline virtual  ~GetMediaObjectStart();

    /**
     * Assignment operator
     */
    inline GetMediaObjectStart& operator = (const GetMediaObjectStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMediaObjectStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMediaObjectStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMediaObjectStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMediaObjectStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Tag"

    static const int kU32Tag = 0;

    /**
     * Clears the field "u32Tag".
     *
     * The field will be set to its default value. The hasU32Tag()
     * method will return false.
     */
    inline void clearU32Tag();

    /**
     * Checks whether the field "u32Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Tag()). Otherwise it will return false.
     */
    inline bool hasU32Tag () const;

    /**
     * Returns the value of the member "u32Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value
     * identifies the media object to play.
     *
     * @return The value of the field "u32Tag"
     */
    inline uint32 getU32Tag () const;

    /**
     * Sets the value of the member "u32Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value
     * identifies the media object to play.
     *
     * @param u32Tag The value which will be set
     */
    inline void setU32Tag (uint32 u32Tag_);

    // API of field "e8CategoryType"

    static const int kE8CategoryType = 1;

    /**
     * Clears the field "e8CategoryType".
     *
     * The field will be set to its default value. The hasE8CategoryType()
     * method will return false.
     */
    inline void clearE8CategoryType();

    /**
     * Checks whether the field "e8CategoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CategoryType()). Otherwise it will return false.
     */
    inline bool hasE8CategoryType () const;

    /**
     * Returns the value of the member "e8CategoryType".
     *
     * Contains the category type of the media object.
     *
     * @return The value of the field "e8CategoryType"
     */
    inline ::MPlay_fi_types::T_e8_MPlayCategoryType getE8CategoryType () const;

    /**
     * Sets the value of the member "e8CategoryType".
     *
     * Contains the category type of the media object.
     *
     * @param e8CategoryType The value which will be set
     */
    inline void setE8CategoryType (::MPlay_fi_types::T_e8_MPlayCategoryType e8CategoryType_);

    static const GetMediaObjectStart &getDefaultInstance();

private:

    inline void set_has_u32Tag ();

    inline void clear_has_u32Tag ();

    inline void set_has_e8CategoryType ();

    inline void clear_has_e8CategoryType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32Tag;

    ::MPlay_fi_types::T_e8_MPlayCategoryType _e8CategoryType;

};

/**
 * The result message of the method "GetMediaObject"
 * Request all meta-data information for a requested Tag item.  The CategoryType parameter is optional and can be used to limit the scope of a tag search.
 */
class GetMediaObjectResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMediaObjectResult ();

    /**
     * Copy constructor
     */
    inline  GetMediaObjectResult (const GetMediaObjectResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetMediaObjectResult (const ::MPlay_fi_types::T_MPlayMediaObject& oMediaObject_);

    /**
     * Destructor
     */
    inline virtual  ~GetMediaObjectResult();

    /**
     * Assignment operator
     */
    inline GetMediaObjectResult& operator = (const GetMediaObjectResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMediaObjectResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMediaObjectResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMediaObjectResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMediaObjectResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMediaObject"

    static const int kOMediaObject = 0;

    /**
     * Clears the field "oMediaObject".
     *
     * The field will be set to its default value. The hasOMediaObject()
     * method will return false.
     */
    inline void clearOMediaObject();

    /**
     * Checks whether the field "oMediaObject" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMediaObject()). Otherwise it will return false.
     */
    inline bool hasOMediaObject () const;

    /**
     * Returns the value of the member "oMediaObject".
     *
     * All information necessary to retrieve and play a given media object, including all meta-data for that object
     *
     * @return The value of the field "oMediaObject"
     */
    inline const ::MPlay_fi_types::T_MPlayMediaObject& getOMediaObject () const;

    /**
     * Retrieves the value of the field "oMediaObject" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMediaObject".
     */
    inline ::MPlay_fi_types::T_MPlayMediaObject& getOMediaObjectMutable ();

    /**
     * Sets the value of the member "oMediaObject".
     *
     * All information necessary to retrieve and play a given media object, including all meta-data for that object
     *
     * @param oMediaObject The value which will be set
     */
    inline void setOMediaObject (const ::MPlay_fi_types::T_MPlayMediaObject& oMediaObject_);

    static const GetMediaObjectResult &getDefaultInstance();

private:

    inline void set_has_oMediaObject ();

    inline void clear_has_oMediaObject ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_MPlayMediaObject _oMediaObject;

};

/**
 * The start message of the method "CreateMediaPlayerFileList"
 * This method create a list of all supported files and folders in the "Path"
 * directory. The CreateMediaPlayerFileList function assigns a unique
 * ListHandle for each filtered list created and returns this value, as well
 * as the number of results in the filtered list. A list is considered to be
 * valid until the ReleaseMediaPlayerList function is executed. Changes to a
 * list are reported by the MediaPlayerListChange property.This
 * method also returns the total number of Files (FileType != FOLDER) and
 * Folders (FileType = Folder) in the associated List. These numbers are
 * static for each List at creation time and are included as returned
 * parameters to allow HMI controllers to configure their view accordingly
 * without requiring the controller to pull the entire list and iterate it
 * first.
 * The parameter e8FileTypeSelection can be used to qualify the content of the list.
 */
class CreateMediaPlayerFileListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerFileListStart ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerFileListStart (const CreateMediaPlayerFileListStart &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerFileListStart (const ::std::string& sPath_, uint8 u8DeviceTag_, ::MPlay_fi_types::T_e8_MPlayFileTypeSelection e8MPlayFileTypeSelection_, uint64 Tag_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerFileListStart();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerFileListStart& operator = (const CreateMediaPlayerFileListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerFileListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerFileListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerFileListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerFileListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sPath"

    static const int kSPath = 0;

    /**
     * Clears the field "sPath".
     *
     * The field will be set to its default value. The hasSPath()
     * method will return false.
     */
    inline void clearSPath();

    /**
     * Checks whether the field "sPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPath()). Otherwise it will return false.
     */
    inline bool hasSPath () const;

    /**
     * Returns the value of the member "sPath".
     *
     * Path to a directory on the device. The root value of the path parameter is "/".
     *
     * @return The value of the field "sPath"
     */
    inline const ::std::string& getSPath () const;

    /**
     * Retrieves the value of the field "sPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPath".
     */
    inline ::std::string& getSPathMutable ();

    /**
     * Sets the value of the member "sPath".
     *
     * Path to a directory on the device. The root value of the path parameter is "/".
     *
     * @param sPath The value which will be set
     */
    inline void setSPath (const ::std::string& sPath_);

    /**
     * Sets the value of the member "sPath".
     *
     * Path to a directory on the device. The root value of the path parameter is "/".
     *
     * @param sPath The value which will be set
     */
    inline void setSPath (const char* sPath_);

    /**
     * Sets the value of the member "sPath".
     *
     * Path to a directory on the device. The root value of the path parameter is "/".
     *
     * @param sPath The value which will be set
     */
    inline void setSPath (const char* value, size_t size);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 1;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "e8MPlayFileTypeSelection"

    static const int kE8MPlayFileTypeSelection = 2;

    /**
     * Clears the field "e8MPlayFileTypeSelection".
     *
     * The field will be set to its default value. The hasE8MPlayFileTypeSelection()
     * method will return false.
     */
    inline void clearE8MPlayFileTypeSelection();

    /**
     * Checks whether the field "e8MPlayFileTypeSelection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MPlayFileTypeSelection()). Otherwise it will return false.
     */
    inline bool hasE8MPlayFileTypeSelection () const;

    /**
     * Returns the value of the member "e8MPlayFileTypeSelection".
     *
     * Specifies the content (only audio files, only video files,...) of the list. Folders are delivered to
     * the HMI for all filter criteria.
     *
     * @return The value of the field "e8MPlayFileTypeSelection"
     */
    inline ::MPlay_fi_types::T_e8_MPlayFileTypeSelection getE8MPlayFileTypeSelection () const;

    /**
     * Sets the value of the member "e8MPlayFileTypeSelection".
     *
     * Specifies the content (only audio files, only video files,...) of the list. Folders are delivered to
     * the HMI for all filter criteria.
     *
     * @param e8MPlayFileTypeSelection The value which will be set
     */
    inline void setE8MPlayFileTypeSelection (::MPlay_fi_types::T_e8_MPlayFileTypeSelection e8MPlayFileTypeSelection_);

    // API of field "Tag"

    static const int kTag = 3;

    /**
     * Clears the field "Tag".
     *
     * The field will be set to its default value. The hasTag()
     * method will return false.
     */
    inline void clearTag();

    /**
     * Checks whether the field "Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTag()). Otherwise it will return false.
     */
    inline bool hasTag () const;

    /**
     * Returns the value of the member "Tag".
     *
     * Tag of the Directory given in "sPath".THIS MUST BE FILLED FOR 64 BIT PLATFORM
     *
     * @return The value of the field "Tag"
     */
    inline uint64 getTag () const;

    /**
     * Sets the value of the member "Tag".
     *
     * Tag of the Directory given in "sPath".THIS MUST BE FILLED FOR 64 BIT PLATFORM
     *
     * @param Tag The value which will be set
     */
    inline void setTag (uint64 Tag_);

    static const CreateMediaPlayerFileListStart &getDefaultInstance();

private:

    inline void set_has_sPath ();

    inline void clear_has_sPath ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_e8MPlayFileTypeSelection ();

    inline void clear_has_e8MPlayFileTypeSelection ();

    inline void set_has_Tag ();

    inline void clear_has_Tag ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _sPath;

    uint8 _u8DeviceTag;

    ::MPlay_fi_types::T_e8_MPlayFileTypeSelection _e8MPlayFileTypeSelection;

    uint64 _Tag;

};

/**
 * The result message of the method "CreateMediaPlayerFileList"
 * This method create a list of all supported files and folders in the "Path"
 * directory. The CreateMediaPlayerFileList function assigns a unique
 * ListHandle for each filtered list created and returns this value, as well
 * as the number of results in the filtered list. A list is considered to be
 * valid until the ReleaseMediaPlayerList function is executed. Changes to a
 * list are reported by the MediaPlayerListChange property.This
 * method also returns the total number of Files (FileType != FOLDER) and
 * Folders (FileType = Folder) in the associated List. These numbers are
 * static for each List at creation time and are included as returned
 * parameters to allow HMI controllers to configure their view accordingly
 * without requiring the controller to pull the entire list and iterate it
 * first.
 * The parameter e8FileTypeSelection can be used to qualify the content of the list.
 */
class CreateMediaPlayerFileListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerFileListResult ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerFileListResult (const CreateMediaPlayerFileListResult &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerFileListResult (uint32 u32ListHandle_, uint32 u32ListSize_, uint8 u8DeviceTag_, uint32 u32TotalNumFiles_, uint32 u32TotalNumFolders_, uint32 u32TotalNumMediaObjects_, uint32 u32TotalNumPlaylists_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerFileListResult();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerFileListResult& operator = (const CreateMediaPlayerFileListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerFileListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerFileListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerFileListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerFileListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 1;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 2;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "u32TotalNumFiles"

    static const int kU32TotalNumFiles = 3;

    /**
     * Clears the field "u32TotalNumFiles".
     *
     * The field will be set to its default value. The hasU32TotalNumFiles()
     * method will return false.
     */
    inline void clearU32TotalNumFiles();

    /**
     * Checks whether the field "u32TotalNumFiles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TotalNumFiles()). Otherwise it will return false.
     */
    inline bool hasU32TotalNumFiles () const;

    /**
     * Returns the value of the member "u32TotalNumFiles".
     *
     * The total number of objects in the list with FileType != FOLDER (i.e. AUDIO, VIDEO, or PLAYLIST).
     *
     * @return The value of the field "u32TotalNumFiles"
     */
    inline uint32 getU32TotalNumFiles () const;

    /**
     * Sets the value of the member "u32TotalNumFiles".
     *
     * The total number of objects in the list with FileType != FOLDER (i.e. AUDIO, VIDEO, or PLAYLIST).
     *
     * @param u32TotalNumFiles The value which will be set
     */
    inline void setU32TotalNumFiles (uint32 u32TotalNumFiles_);

    // API of field "u32TotalNumFolders"

    static const int kU32TotalNumFolders = 4;

    /**
     * Clears the field "u32TotalNumFolders".
     *
     * The field will be set to its default value. The hasU32TotalNumFolders()
     * method will return false.
     */
    inline void clearU32TotalNumFolders();

    /**
     * Checks whether the field "u32TotalNumFolders" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TotalNumFolders()). Otherwise it will return false.
     */
    inline bool hasU32TotalNumFolders () const;

    /**
     * Returns the value of the member "u32TotalNumFolders".
     *
     * The total number of objects in the list with FileType = FOLDER.
     *
     * @return The value of the field "u32TotalNumFolders"
     */
    inline uint32 getU32TotalNumFolders () const;

    /**
     * Sets the value of the member "u32TotalNumFolders".
     *
     * The total number of objects in the list with FileType = FOLDER.
     *
     * @param u32TotalNumFolders The value which will be set
     */
    inline void setU32TotalNumFolders (uint32 u32TotalNumFolders_);

    // API of field "u32TotalNumMediaObjects"

    static const int kU32TotalNumMediaObjects = 5;

    /**
     * Clears the field "u32TotalNumMediaObjects".
     *
     * The field will be set to its default value. The hasU32TotalNumMediaObjects()
     * method will return false.
     */
    inline void clearU32TotalNumMediaObjects();

    /**
     * Checks whether the field "u32TotalNumMediaObjects" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TotalNumMediaObjects()). Otherwise it will return false.
     */
    inline bool hasU32TotalNumMediaObjects () const;

    /**
     * Returns the value of the member "u32TotalNumMediaObjects".
     *
     * The total number of media objects in the list FileType != FOLDER AND FileType != PLAYLIST (i.e. AUDIO, VIDEO).
     *
     * @return The value of the field "u32TotalNumMediaObjects"
     */
    inline uint32 getU32TotalNumMediaObjects () const;

    /**
     * Sets the value of the member "u32TotalNumMediaObjects".
     *
     * The total number of media objects in the list FileType != FOLDER AND FileType != PLAYLIST (i.e. AUDIO, VIDEO).
     *
     * @param u32TotalNumMediaObjects The value which will be set
     */
    inline void setU32TotalNumMediaObjects (uint32 u32TotalNumMediaObjects_);

    // API of field "u32TotalNumPlaylists"

    static const int kU32TotalNumPlaylists = 6;

    /**
     * Clears the field "u32TotalNumPlaylists".
     *
     * The field will be set to its default value. The hasU32TotalNumPlaylists()
     * method will return false.
     */
    inline void clearU32TotalNumPlaylists();

    /**
     * Checks whether the field "u32TotalNumPlaylists" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TotalNumPlaylists()). Otherwise it will return false.
     */
    inline bool hasU32TotalNumPlaylists () const;

    /**
     * Returns the value of the member "u32TotalNumPlaylists".
     *
     * The total number of playlists in the list with FileType = PLAYLIST.
     *
     * @return The value of the field "u32TotalNumPlaylists"
     */
    inline uint32 getU32TotalNumPlaylists () const;

    /**
     * Sets the value of the member "u32TotalNumPlaylists".
     *
     * The total number of playlists in the list with FileType = PLAYLIST.
     *
     * @param u32TotalNumPlaylists The value which will be set
     */
    inline void setU32TotalNumPlaylists (uint32 u32TotalNumPlaylists_);

    static const CreateMediaPlayerFileListResult &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_u32TotalNumFiles ();

    inline void clear_has_u32TotalNumFiles ();

    inline void set_has_u32TotalNumFolders ();

    inline void clear_has_u32TotalNumFolders ();

    inline void set_has_u32TotalNumMediaObjects ();

    inline void clear_has_u32TotalNumMediaObjects ();

    inline void set_has_u32TotalNumPlaylists ();

    inline void clear_has_u32TotalNumPlaylists ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32ListSize;

    uint8 _u8DeviceTag;

    uint32 _u32TotalNumFiles;

    uint32 _u32TotalNumFolders;

    uint32 _u32TotalNumMediaObjects;

    uint32 _u32TotalNumPlaylists;

};

/**
 * The start message of the method "RequestMediaPlayerFileListSlice"
 * The RequestMediaPlayerFileListSlice method provides a slice of the
 * filtered list specified by the ListHandle parameter. The slice begins
 * with the item at location WindowStart and includes in sequential order
 * the number of items specified by the parameter WindowSize.
 *
 * The RequestMediaPlayerFileListSlice method returns the slice as a
 * FileList stream.
 *
 * If the number of items in the list starting at WindowStart is less than
 * the WindowSize parameter then the number of items provided in the slice
 * will be less than the WindowSize calling parameter.
 */
class RequestMediaPlayerFileListSliceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestMediaPlayerFileListSliceStart ();

    /**
     * Copy constructor
     */
    inline  RequestMediaPlayerFileListSliceStart (const RequestMediaPlayerFileListSliceStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestMediaPlayerFileListSliceStart (uint32 u32ListHandle_, uint32 u32WindowStart_, uint16 u16WindowSize_, uint8 DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~RequestMediaPlayerFileListSliceStart();

    /**
     * Assignment operator
     */
    inline RequestMediaPlayerFileListSliceStart& operator = (const RequestMediaPlayerFileListSliceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestMediaPlayerFileListSliceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestMediaPlayerFileListSliceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestMediaPlayerFileListSliceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestMediaPlayerFileListSliceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32WindowStart"

    static const int kU32WindowStart = 1;

    /**
     * Clears the field "u32WindowStart".
     *
     * The field will be set to its default value. The hasU32WindowStart()
     * method will return false.
     */
    inline void clearU32WindowStart();

    /**
     * Checks whether the field "u32WindowStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WindowStart()). Otherwise it will return false.
     */
    inline bool hasU32WindowStart () const;

    /**
     * Returns the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @return The value of the field "u32WindowStart"
     */
    inline uint32 getU32WindowStart () const;

    /**
     * Sets the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @param u32WindowStart The value which will be set
     */
    inline void setU32WindowStart (uint32 u32WindowStart_);

    // API of field "u16WindowSize"

    static const int kU16WindowSize = 2;

    /**
     * Clears the field "u16WindowSize".
     *
     * The field will be set to its default value. The hasU16WindowSize()
     * method will return false.
     */
    inline void clearU16WindowSize();

    /**
     * Checks whether the field "u16WindowSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16WindowSize()). Otherwise it will return false.
     */
    inline bool hasU16WindowSize () const;

    /**
     * Returns the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @return The value of the field "u16WindowSize"
     */
    inline uint16 getU16WindowSize () const;

    /**
     * Sets the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @param u16WindowSize The value which will be set
     */
    inline void setU16WindowSize (uint16 u16WindowSize_);

    // API of field "DeviceTag"

    static const int kDeviceTag = 3;

    /**
     * Clears the field "DeviceTag".
     *
     * The field will be set to its default value. The hasDeviceTag()
     * method will return false.
     */
    inline void clearDeviceTag();

    /**
     * Checks whether the field "DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceTag()). Otherwise it will return false.
     */
    inline bool hasDeviceTag () const;

    /**
     * Returns the value of the member "DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     *
     * @return The value of the field "DeviceTag"
     */
    inline uint8 getDeviceTag () const;

    /**
     * Sets the value of the member "DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     *
     * @param DeviceTag The value which will be set
     */
    inline void setDeviceTag (uint8 DeviceTag_);

    static const RequestMediaPlayerFileListSliceStart &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32WindowStart ();

    inline void clear_has_u32WindowStart ();

    inline void set_has_u16WindowSize ();

    inline void clear_has_u16WindowSize ();

    inline void set_has_DeviceTag ();

    inline void clear_has_DeviceTag ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32WindowStart;

    uint16 _u16WindowSize;

    uint8 _DeviceTag;

};

/**
 * The result message of the method "RequestMediaPlayerFileListSlice"
 * The RequestMediaPlayerFileListSlice method provides a slice of the
 * filtered list specified by the ListHandle parameter. The slice begins
 * with the item at location WindowStart and includes in sequential order
 * the number of items specified by the parameter WindowSize.
 *
 * The RequestMediaPlayerFileListSlice method returns the slice as a
 * FileList stream.
 *
 * If the number of items in the list starting at WindowStart is less than
 * the WindowSize parameter then the number of items provided in the slice
 * will be less than the WindowSize calling parameter.
 */
class RequestMediaPlayerFileListSliceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestMediaPlayerFileListSliceResult ();

    /**
     * Copy constructor
     */
    inline  RequestMediaPlayerFileListSliceResult (const RequestMediaPlayerFileListSliceResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestMediaPlayerFileListSliceResult (const ::MPlay_fi_types::T_MPlayFileList& oFileList_);

    /**
     * Destructor
     */
    inline virtual  ~RequestMediaPlayerFileListSliceResult();

    /**
     * Assignment operator
     */
    inline RequestMediaPlayerFileListSliceResult& operator = (const RequestMediaPlayerFileListSliceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestMediaPlayerFileListSliceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestMediaPlayerFileListSliceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestMediaPlayerFileListSliceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestMediaPlayerFileListSliceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oFileList"

    static const int kOFileList = 0;

    /**
     * Clears the field "oFileList".
     *
     * The field will be set to its default value. The hasOFileList()
     * method will return false.
     */
    inline void clearOFileList();

    /**
     * Checks whether the field "oFileList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOFileList()). Otherwise it will return false.
     */
    inline bool hasOFileList () const;

    /**
     * Returns the value of the member "oFileList".
     *
     * A list of all files associated with a ListHandle.
     *
     * @return The value of the field "oFileList"
     */
    inline const ::MPlay_fi_types::T_MPlayFileList& getOFileList () const;

    /**
     * Retrieves the value of the field "oFileList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oFileList".
     */
    inline ::MPlay_fi_types::T_MPlayFileList& getOFileListMutable ();

    /**
     * Sets the value of the member "oFileList".
     *
     * A list of all files associated with a ListHandle.
     *
     * @param oFileList The value which will be set
     */
    inline void setOFileList (const ::MPlay_fi_types::T_MPlayFileList& oFileList_);

    static const RequestMediaPlayerFileListSliceResult &getDefaultInstance();

private:

    static const ::std::vector< ::MPlay_fi_types::T_MPlayFileListItem >& getT_MPlayFileListItemList_DefaultInstance ();

    inline void set_has_oFileList ();

    inline void clear_has_oFileList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_MPlayFileList _oFileList;

};

/**
 * The start message of the method "CreateMediaPlayerPlaylistList"
 * This method generates a list of the items in a playlist.
 */
class CreateMediaPlayerPlaylistListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerPlaylistListStart ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerPlaylistListStart (const CreateMediaPlayerPlaylistListStart &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerPlaylistListStart (const ::std::string& sFilename_, uint64 Tag_, uint8 DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerPlaylistListStart();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerPlaylistListStart& operator = (const CreateMediaPlayerPlaylistListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerPlaylistListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerPlaylistListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerPlaylistListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerPlaylistListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sFilename"

    static const int kSFilename = 0;

    /**
     * Clears the field "sFilename".
     *
     * The field will be set to its default value. The hasSFilename()
     * method will return false.
     */
    inline void clearSFilename();

    /**
     * Checks whether the field "sFilename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFilename()). Otherwise it will return false.
     */
    inline bool hasSFilename () const;

    /**
     * Returns the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @return The value of the field "sFilename"
     */
    inline const ::std::string& getSFilename () const;

    /**
     * Retrieves the value of the field "sFilename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFilename".
     */
    inline ::std::string& getSFilenameMutable ();

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const ::std::string& sFilename_);

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const char* sFilename_);

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const char* value, size_t size);

    // API of field "Tag"

    static const int kTag = 1;

    /**
     * Clears the field "Tag".
     *
     * The field will be set to its default value. The hasTag()
     * method will return false.
     */
    inline void clearTag();

    /**
     * Checks whether the field "Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTag()). Otherwise it will return false.
     */
    inline bool hasTag () const;

    /**
     * Returns the value of the member "Tag".
     *
     * Tag of the Playlist.THIS MUST BE FILLED FOR 64 BIT PLATFORM
     *
     * @return The value of the field "Tag"
     */
    inline uint64 getTag () const;

    /**
     * Sets the value of the member "Tag".
     *
     * Tag of the Playlist.THIS MUST BE FILLED FOR 64 BIT PLATFORM
     *
     * @param Tag The value which will be set
     */
    inline void setTag (uint64 Tag_);

    // API of field "DeviceTag"

    static const int kDeviceTag = 2;

    /**
     * Clears the field "DeviceTag".
     *
     * The field will be set to its default value. The hasDeviceTag()
     * method will return false.
     */
    inline void clearDeviceTag();

    /**
     * Checks whether the field "DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceTag()). Otherwise it will return false.
     */
    inline bool hasDeviceTag () const;

    /**
     * Returns the value of the member "DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     *
     * @return The value of the field "DeviceTag"
     */
    inline uint8 getDeviceTag () const;

    /**
     * Sets the value of the member "DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     *
     * @param DeviceTag The value which will be set
     */
    inline void setDeviceTag (uint8 DeviceTag_);

    static const CreateMediaPlayerPlaylistListStart &getDefaultInstance();

private:

    inline void set_has_sFilename ();

    inline void clear_has_sFilename ();

    inline void set_has_Tag ();

    inline void clear_has_Tag ();

    inline void set_has_DeviceTag ();

    inline void clear_has_DeviceTag ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sFilename;

    uint64 _Tag;

    uint8 _DeviceTag;

};

/**
 * The result message of the method "CreateMediaPlayerPlaylistList"
 * This method generates a list of the items in a playlist.
 */
class CreateMediaPlayerPlaylistListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMediaPlayerPlaylistListResult ();

    /**
     * Copy constructor
     */
    inline  CreateMediaPlayerPlaylistListResult (const CreateMediaPlayerPlaylistListResult &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMediaPlayerPlaylistListResult (uint32 u32ListHandle_, uint32 u32ListSize_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMediaPlayerPlaylistListResult();

    /**
     * Assignment operator
     */
    inline CreateMediaPlayerPlaylistListResult& operator = (const CreateMediaPlayerPlaylistListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMediaPlayerPlaylistListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMediaPlayerPlaylistListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMediaPlayerPlaylistListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMediaPlayerPlaylistListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 1;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    static const CreateMediaPlayerPlaylistListResult &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32ListSize;

};

/**
 * The start message of the method "RequestMediaPlayerPlaylistListSlice"
 * The RequestMediaPlayerPlaylistListSlice method provides a slice of the
 * list specified by the ListHandle parameter. The slice begins with the item
 * at location WindowStart and includes in sequential order the number of
 * items specified by the parameter WindowSize. The contents of the list are
 * filenames from a playlist.
 */
class RequestMediaPlayerPlaylistListSliceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestMediaPlayerPlaylistListSliceStart ();

    /**
     * Copy constructor
     */
    inline  RequestMediaPlayerPlaylistListSliceStart (const RequestMediaPlayerPlaylistListSliceStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestMediaPlayerPlaylistListSliceStart (uint32 u32ListHandle_, uint32 u32WindowStart_, uint16 u16WindowSize_, uint8 DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~RequestMediaPlayerPlaylistListSliceStart();

    /**
     * Assignment operator
     */
    inline RequestMediaPlayerPlaylistListSliceStart& operator = (const RequestMediaPlayerPlaylistListSliceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestMediaPlayerPlaylistListSliceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestMediaPlayerPlaylistListSliceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestMediaPlayerPlaylistListSliceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestMediaPlayerPlaylistListSliceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32WindowStart"

    static const int kU32WindowStart = 1;

    /**
     * Clears the field "u32WindowStart".
     *
     * The field will be set to its default value. The hasU32WindowStart()
     * method will return false.
     */
    inline void clearU32WindowStart();

    /**
     * Checks whether the field "u32WindowStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WindowStart()). Otherwise it will return false.
     */
    inline bool hasU32WindowStart () const;

    /**
     * Returns the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @return The value of the field "u32WindowStart"
     */
    inline uint32 getU32WindowStart () const;

    /**
     * Sets the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @param u32WindowStart The value which will be set
     */
    inline void setU32WindowStart (uint32 u32WindowStart_);

    // API of field "u16WindowSize"

    static const int kU16WindowSize = 2;

    /**
     * Clears the field "u16WindowSize".
     *
     * The field will be set to its default value. The hasU16WindowSize()
     * method will return false.
     */
    inline void clearU16WindowSize();

    /**
     * Checks whether the field "u16WindowSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16WindowSize()). Otherwise it will return false.
     */
    inline bool hasU16WindowSize () const;

    /**
     * Returns the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @return The value of the field "u16WindowSize"
     */
    inline uint16 getU16WindowSize () const;

    /**
     * Sets the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @param u16WindowSize The value which will be set
     */
    inline void setU16WindowSize (uint16 u16WindowSize_);

    // API of field "DeviceTag"

    static const int kDeviceTag = 3;

    /**
     * Clears the field "DeviceTag".
     *
     * The field will be set to its default value. The hasDeviceTag()
     * method will return false.
     */
    inline void clearDeviceTag();

    /**
     * Checks whether the field "DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceTag()). Otherwise it will return false.
     */
    inline bool hasDeviceTag () const;

    /**
     * Returns the value of the member "DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     *
     * @return The value of the field "DeviceTag"
     */
    inline uint8 getDeviceTag () const;

    /**
     * Sets the value of the member "DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     *
     * @param DeviceTag The value which will be set
     */
    inline void setDeviceTag (uint8 DeviceTag_);

    static const RequestMediaPlayerPlaylistListSliceStart &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32WindowStart ();

    inline void clear_has_u32WindowStart ();

    inline void set_has_u16WindowSize ();

    inline void clear_has_u16WindowSize ();

    inline void set_has_DeviceTag ();

    inline void clear_has_DeviceTag ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32WindowStart;

    uint16 _u16WindowSize;

    uint8 _DeviceTag;

};

/**
 * The result message of the method "RequestMediaPlayerPlaylistListSlice"
 * The RequestMediaPlayerPlaylistListSlice method provides a slice of the
 * list specified by the ListHandle parameter. The slice begins with the item
 * at location WindowStart and includes in sequential order the number of
 * items specified by the parameter WindowSize. The contents of the list are
 * filenames from a playlist.
 */
class RequestMediaPlayerPlaylistListSliceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestMediaPlayerPlaylistListSliceResult ();

    /**
     * Copy constructor
     */
    inline  RequestMediaPlayerPlaylistListSliceResult (const RequestMediaPlayerPlaylistListSliceResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestMediaPlayerPlaylistListSliceResult (const ::MPlay_fi_types::T_MPlayFileList& oFileList_);

    /**
     * Destructor
     */
    inline virtual  ~RequestMediaPlayerPlaylistListSliceResult();

    /**
     * Assignment operator
     */
    inline RequestMediaPlayerPlaylistListSliceResult& operator = (const RequestMediaPlayerPlaylistListSliceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestMediaPlayerPlaylistListSliceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestMediaPlayerPlaylistListSliceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestMediaPlayerPlaylistListSliceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestMediaPlayerPlaylistListSliceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oFileList"

    static const int kOFileList = 0;

    /**
     * Clears the field "oFileList".
     *
     * The field will be set to its default value. The hasOFileList()
     * method will return false.
     */
    inline void clearOFileList();

    /**
     * Checks whether the field "oFileList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOFileList()). Otherwise it will return false.
     */
    inline bool hasOFileList () const;

    /**
     * Returns the value of the member "oFileList".
     *
     * A list of all files associated with a ListHandle.
     *
     * @return The value of the field "oFileList"
     */
    inline const ::MPlay_fi_types::T_MPlayFileList& getOFileList () const;

    /**
     * Retrieves the value of the field "oFileList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oFileList".
     */
    inline ::MPlay_fi_types::T_MPlayFileList& getOFileListMutable ();

    /**
     * Sets the value of the member "oFileList".
     *
     * A list of all files associated with a ListHandle.
     *
     * @param oFileList The value which will be set
     */
    inline void setOFileList (const ::MPlay_fi_types::T_MPlayFileList& oFileList_);

    static const RequestMediaPlayerPlaylistListSliceResult &getDefaultInstance();

private:

    static const ::std::vector< ::MPlay_fi_types::T_MPlayFileListItem >& getT_MPlayFileListItemList_DefaultInstance ();

    inline void set_has_oFileList ();

    inline void clear_has_oFileList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_MPlayFileList _oFileList;

};

/**
 * The start message of the method "RequestMediaPlayerQuickPlayListSlice"
 * The RequestMediaPlayerQuickPlayListSlice method provides a slice of the
 * filtered list specified by the ListHandle parameter as follows:
 *
 * The slice begins with the item at location WindowStart and includes in
 * sequential order the number of items specified by the parameter
 * WindowSize.
 *
 * The RequestMediaPlayerListSlice method returns the slice as a
 * MediaObjects stream. The data contained in each MediaObject is used by
 * the HMI to determine the meta-data and other properties of the media
 * object.
 *
 * If the number of items in the list starting at WindowStart is less
 * than the WindowSize parameter then the number of items provided in the
 * slice will be less than the WindowSize calling parameter.
 *
 * QuickPlayList features are only supported by the MediaPlayer FBlock
 * when MyMediaSupported (0x230) == TRUE. If MyMediaSupported == FALSE
 * (i.e. for a Base Radio MediaPlayer implementation), then both
 * CreateMediaPlayerQuickPlaylistList and
 * RequestMediaPlayerQuickPlayListSlice shall not be called by a
 * controller. If they are called in error when MyMediaSupported = FALSE,
 * the MediaPlayer FBlock shall respond with an error
 */
class RequestMediaPlayerQuickPlayListSliceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestMediaPlayerQuickPlayListSliceStart ();

    /**
     * Copy constructor
     */
    inline  RequestMediaPlayerQuickPlayListSliceStart (const RequestMediaPlayerQuickPlayListSliceStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestMediaPlayerQuickPlayListSliceStart (uint32 u32ListHandle_, uint32 u32WindowStart_, uint16 u16WindowSize_, uint8 DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~RequestMediaPlayerQuickPlayListSliceStart();

    /**
     * Assignment operator
     */
    inline RequestMediaPlayerQuickPlayListSliceStart& operator = (const RequestMediaPlayerQuickPlayListSliceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestMediaPlayerQuickPlayListSliceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestMediaPlayerQuickPlayListSliceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestMediaPlayerQuickPlayListSliceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestMediaPlayerQuickPlayListSliceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32WindowStart"

    static const int kU32WindowStart = 1;

    /**
     * Clears the field "u32WindowStart".
     *
     * The field will be set to its default value. The hasU32WindowStart()
     * method will return false.
     */
    inline void clearU32WindowStart();

    /**
     * Checks whether the field "u32WindowStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WindowStart()). Otherwise it will return false.
     */
    inline bool hasU32WindowStart () const;

    /**
     * Returns the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @return The value of the field "u32WindowStart"
     */
    inline uint32 getU32WindowStart () const;

    /**
     * Sets the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @param u32WindowStart The value which will be set
     */
    inline void setU32WindowStart (uint32 u32WindowStart_);

    // API of field "u16WindowSize"

    static const int kU16WindowSize = 2;

    /**
     * Clears the field "u16WindowSize".
     *
     * The field will be set to its default value. The hasU16WindowSize()
     * method will return false.
     */
    inline void clearU16WindowSize();

    /**
     * Checks whether the field "u16WindowSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16WindowSize()). Otherwise it will return false.
     */
    inline bool hasU16WindowSize () const;

    /**
     * Returns the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @return The value of the field "u16WindowSize"
     */
    inline uint16 getU16WindowSize () const;

    /**
     * Sets the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @param u16WindowSize The value which will be set
     */
    inline void setU16WindowSize (uint16 u16WindowSize_);

    // API of field "DeviceTag"

    static const int kDeviceTag = 3;

    /**
     * Clears the field "DeviceTag".
     *
     * The field will be set to its default value. The hasDeviceTag()
     * method will return false.
     */
    inline void clearDeviceTag();

    /**
     * Checks whether the field "DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceTag()). Otherwise it will return false.
     */
    inline bool hasDeviceTag () const;

    /**
     * Returns the value of the member "DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     *
     * @return The value of the field "DeviceTag"
     */
    inline uint8 getDeviceTag () const;

    /**
     * Sets the value of the member "DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     *
     * @param DeviceTag The value which will be set
     */
    inline void setDeviceTag (uint8 DeviceTag_);

    static const RequestMediaPlayerQuickPlayListSliceStart &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32WindowStart ();

    inline void clear_has_u32WindowStart ();

    inline void set_has_u16WindowSize ();

    inline void clear_has_u16WindowSize ();

    inline void set_has_DeviceTag ();

    inline void clear_has_DeviceTag ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32WindowStart;

    uint16 _u16WindowSize;

    uint8 _DeviceTag;

};

/**
 * The result message of the method "RequestMediaPlayerQuickPlayListSlice"
 * The RequestMediaPlayerQuickPlayListSlice method provides a slice of the
 * filtered list specified by the ListHandle parameter as follows:
 *
 * The slice begins with the item at location WindowStart and includes in
 * sequential order the number of items specified by the parameter
 * WindowSize.
 *
 * The RequestMediaPlayerListSlice method returns the slice as a
 * MediaObjects stream. The data contained in each MediaObject is used by
 * the HMI to determine the meta-data and other properties of the media
 * object.
 *
 * If the number of items in the list starting at WindowStart is less
 * than the WindowSize parameter then the number of items provided in the
 * slice will be less than the WindowSize calling parameter.
 *
 * QuickPlayList features are only supported by the MediaPlayer FBlock
 * when MyMediaSupported (0x230) == TRUE. If MyMediaSupported == FALSE
 * (i.e. for a Base Radio MediaPlayer implementation), then both
 * CreateMediaPlayerQuickPlaylistList and
 * RequestMediaPlayerQuickPlayListSlice shall not be called by a
 * controller. If they are called in error when MyMediaSupported = FALSE,
 * the MediaPlayer FBlock shall respond with an error
 */
class RequestMediaPlayerQuickPlayListSliceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestMediaPlayerQuickPlayListSliceResult ();

    /**
     * Copy constructor
     */
    inline  RequestMediaPlayerQuickPlayListSliceResult (const RequestMediaPlayerQuickPlayListSliceResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestMediaPlayerQuickPlayListSliceResult (const ::MPlay_fi_types::T_MPlayMediaObjects& oMediaObjects_);

    /**
     * Destructor
     */
    inline virtual  ~RequestMediaPlayerQuickPlayListSliceResult();

    /**
     * Assignment operator
     */
    inline RequestMediaPlayerQuickPlayListSliceResult& operator = (const RequestMediaPlayerQuickPlayListSliceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestMediaPlayerQuickPlayListSliceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestMediaPlayerQuickPlayListSliceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestMediaPlayerQuickPlayListSliceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestMediaPlayerQuickPlayListSliceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMediaObjects"

    static const int kOMediaObjects = 0;

    /**
     * Clears the field "oMediaObjects".
     *
     * The field will be set to its default value. The hasOMediaObjects()
     * method will return false.
     */
    inline void clearOMediaObjects();

    /**
     * Checks whether the field "oMediaObjects" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMediaObjects()). Otherwise it will return false.
     */
    inline bool hasOMediaObjects () const;

    /**
     * Returns the value of the member "oMediaObjects".
     *
     * All information necessary to retrieve and play a given media object, including all meta-data for that object
     *
     * @return The value of the field "oMediaObjects"
     */
    inline const ::MPlay_fi_types::T_MPlayMediaObjects& getOMediaObjects () const;

    /**
     * Retrieves the value of the field "oMediaObjects" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMediaObjects".
     */
    inline ::MPlay_fi_types::T_MPlayMediaObjects& getOMediaObjectsMutable ();

    /**
     * Sets the value of the member "oMediaObjects".
     *
     * All information necessary to retrieve and play a given media object, including all meta-data for that object
     *
     * @param oMediaObjects The value which will be set
     */
    inline void setOMediaObjects (const ::MPlay_fi_types::T_MPlayMediaObjects& oMediaObjects_);

    static const RequestMediaPlayerQuickPlayListSliceResult &getDefaultInstance();

private:

    static const ::std::vector< ::MPlay_fi_types::T_MPlayMediaObjectsItem >& getT_MPlayMediaObjectsItemList_DefaultInstance ();

    inline void set_has_oMediaObjects ();

    inline void clear_has_oMediaObjects ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects;

};

/**
 * The start message of the method "GetMediaObjectAlbumArtInfo"
 * This Method is used to retrieve the MIME type and size of the album art
 * image associated with a particular media object (if one exists for the
 * requested object). The size is dependent from the u32SizeX and u32SizeY. The actual album art image is retrieved by calling the
 * GetMediaObjectAlbumArt function. This function shall be called with the same value u32SizeX and u32SizeY.  See the description for the
 * GetMediaObjectAlbumArt Method for specific format support requirements.
 */
class GetMediaObjectAlbumArtInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMediaObjectAlbumArtInfoStart ();

    /**
     * Copy constructor
     */
    inline  GetMediaObjectAlbumArtInfoStart (const GetMediaObjectAlbumArtInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetMediaObjectAlbumArtInfoStart (const ::std::string& sAlbumArt_, uint32 u32SizeX_, uint32 u32SizeY_);

    /**
     * Destructor
     */
    inline virtual  ~GetMediaObjectAlbumArtInfoStart();

    /**
     * Assignment operator
     */
    inline GetMediaObjectAlbumArtInfoStart& operator = (const GetMediaObjectAlbumArtInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMediaObjectAlbumArtInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMediaObjectAlbumArtInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMediaObjectAlbumArtInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMediaObjectAlbumArtInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sAlbumArt"

    static const int kSAlbumArt = 0;

    /**
     * Clears the field "sAlbumArt".
     *
     * The field will be set to its default value. The hasSAlbumArt()
     * method will return false.
     */
    inline void clearSAlbumArt();

    /**
     * Checks whether the field "sAlbumArt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAlbumArt()). Otherwise it will return false.
     */
    inline bool hasSAlbumArt () const;

    /**
     * Returns the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @return The value of the field "sAlbumArt"
     */
    inline const ::std::string& getSAlbumArt () const;

    /**
     * Retrieves the value of the field "sAlbumArt" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAlbumArt".
     */
    inline ::std::string& getSAlbumArtMutable ();

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const ::std::string& sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* value, size_t size);

    // API of field "u32SizeX"

    static const int kU32SizeX = 1;

    /**
     * Clears the field "u32SizeX".
     *
     * The field will be set to its default value. The hasU32SizeX()
     * method will return false.
     */
    inline void clearU32SizeX();

    /**
     * Checks whether the field "u32SizeX" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SizeX()). Otherwise it will return false.
     */
    inline bool hasU32SizeX () const;

    /**
     * Returns the value of the member "u32SizeX".
     *
     * Number of pixels in X direction
     *
     * @return The value of the field "u32SizeX"
     */
    inline uint32 getU32SizeX () const;

    /**
     * Sets the value of the member "u32SizeX".
     *
     * Number of pixels in X direction
     *
     * @param u32SizeX The value which will be set
     */
    inline void setU32SizeX (uint32 u32SizeX_);

    // API of field "u32SizeY"

    static const int kU32SizeY = 2;

    /**
     * Clears the field "u32SizeY".
     *
     * The field will be set to its default value. The hasU32SizeY()
     * method will return false.
     */
    inline void clearU32SizeY();

    /**
     * Checks whether the field "u32SizeY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SizeY()). Otherwise it will return false.
     */
    inline bool hasU32SizeY () const;

    /**
     * Returns the value of the member "u32SizeY".
     *
     * Number of pixels in Y direction
     *
     * @return The value of the field "u32SizeY"
     */
    inline uint32 getU32SizeY () const;

    /**
     * Sets the value of the member "u32SizeY".
     *
     * Number of pixels in Y direction
     *
     * @param u32SizeY The value which will be set
     */
    inline void setU32SizeY (uint32 u32SizeY_);

    static const GetMediaObjectAlbumArtInfoStart &getDefaultInstance();

private:

    inline void set_has_sAlbumArt ();

    inline void clear_has_sAlbumArt ();

    inline void set_has_u32SizeX ();

    inline void clear_has_u32SizeX ();

    inline void set_has_u32SizeY ();

    inline void clear_has_u32SizeY ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sAlbumArt;

    uint32 _u32SizeX;

    uint32 _u32SizeY;

};

/**
 * The result message of the method "GetMediaObjectAlbumArtInfo"
 * This Method is used to retrieve the MIME type and size of the album art
 * image associated with a particular media object (if one exists for the
 * requested object). The size is dependent from the u32SizeX and u32SizeY. The actual album art image is retrieved by calling the
 * GetMediaObjectAlbumArt function. This function shall be called with the same value u32SizeX and u32SizeY.  See the description for the
 * GetMediaObjectAlbumArt Method for specific format support requirements.
 */
class GetMediaObjectAlbumArtInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMediaObjectAlbumArtInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetMediaObjectAlbumArtInfoResult (const GetMediaObjectAlbumArtInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetMediaObjectAlbumArtInfoResult (const ::std::string& sMIMEImageSubtype_, uint32 u32PhotoSize_);

    /**
     * Destructor
     */
    inline virtual  ~GetMediaObjectAlbumArtInfoResult();

    /**
     * Assignment operator
     */
    inline GetMediaObjectAlbumArtInfoResult& operator = (const GetMediaObjectAlbumArtInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMediaObjectAlbumArtInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMediaObjectAlbumArtInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMediaObjectAlbumArtInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMediaObjectAlbumArtInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sMIMEImageSubtype"

    static const int kSMIMEImageSubtype = 0;

    /**
     * Clears the field "sMIMEImageSubtype".
     *
     * The field will be set to its default value. The hasSMIMEImageSubtype()
     * method will return false.
     */
    inline void clearSMIMEImageSubtype();

    /**
     * Checks whether the field "sMIMEImageSubtype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMIMEImageSubtype()). Otherwise it will return false.
     */
    inline bool hasSMIMEImageSubtype () const;

    /**
     * Returns the value of the member "sMIMEImageSubtype".
     *
     * Identifies the MIME image subtype
     *
     * @return The value of the field "sMIMEImageSubtype"
     */
    inline const ::std::string& getSMIMEImageSubtype () const;

    /**
     * Retrieves the value of the field "sMIMEImageSubtype" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMIMEImageSubtype".
     */
    inline ::std::string& getSMIMEImageSubtypeMutable ();

    /**
     * Sets the value of the member "sMIMEImageSubtype".
     *
     * Identifies the MIME image subtype
     *
     * @param sMIMEImageSubtype The value which will be set
     */
    inline void setSMIMEImageSubtype (const ::std::string& sMIMEImageSubtype_);

    /**
     * Sets the value of the member "sMIMEImageSubtype".
     *
     * Identifies the MIME image subtype
     *
     * @param sMIMEImageSubtype The value which will be set
     */
    inline void setSMIMEImageSubtype (const char* sMIMEImageSubtype_);

    /**
     * Sets the value of the member "sMIMEImageSubtype".
     *
     * Identifies the MIME image subtype
     *
     * @param sMIMEImageSubtype The value which will be set
     */
    inline void setSMIMEImageSubtype (const char* value, size_t size);

    // API of field "u32PhotoSize"

    static const int kU32PhotoSize = 1;

    /**
     * Clears the field "u32PhotoSize".
     *
     * The field will be set to its default value. The hasU32PhotoSize()
     * method will return false.
     */
    inline void clearU32PhotoSize();

    /**
     * Checks whether the field "u32PhotoSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PhotoSize()). Otherwise it will return false.
     */
    inline bool hasU32PhotoSize () const;

    /**
     * Returns the value of the member "u32PhotoSize".
     *
     * The size of the photo in bytes
     *
     * @return The value of the field "u32PhotoSize"
     */
    inline uint32 getU32PhotoSize () const;

    /**
     * Sets the value of the member "u32PhotoSize".
     *
     * The size of the photo in bytes
     *
     * @param u32PhotoSize The value which will be set
     */
    inline void setU32PhotoSize (uint32 u32PhotoSize_);

    static const GetMediaObjectAlbumArtInfoResult &getDefaultInstance();

private:

    inline void set_has_sMIMEImageSubtype ();

    inline void clear_has_sMIMEImageSubtype ();

    inline void set_has_u32PhotoSize ();

    inline void clear_has_u32PhotoSize ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sMIMEImageSubtype;

    uint32 _u32PhotoSize;

};

/**
 * The start message of the method "PlayMediaPlayerObject"
 * The PlayMediaPlayerObject method is called to set the play object within
 * the MediaPlayer. The MediaPlayer handles this function as follows:
 *
 * If the MediaPlayer is not currently playing audio, it internally
 * stores the new object as the object to play the next time that the
 * MediaPlayer is connected for audio playback through the AVManager by
 * an HMI controller within the system.
 *
 * If the MediaPlayer is already connected on the network and playing
 * audio on another media object, it stops playback of that media object
 * and starts playing the new object automatically
 *
 * Note that the connect operation to the AVManager (RequestAVActivation
 * method) is not performed by the MediaPlayer and is instead performed
 * by an HMI controller. For example, if the user directly selects an
 * Artist from an HMI menu, the HMI controller would first call
 * PlayMediaPlayerObject and then would call the
 * AVManager.RequestAVActivation to connect the MediaPlayer over a
 * Logical Audio Channel.
 */
class PlayMediaPlayerObjectStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlayMediaPlayerObjectStart ();

    /**
     * Copy constructor
     */
    inline  PlayMediaPlayerObjectStart (const PlayMediaPlayerObjectStart &rhs);

    /**
     * All fields constructor
     */
    inline  PlayMediaPlayerObjectStart (uint32 u32Tag_, bool bAutoPlay_);

    /**
     * Destructor
     */
    inline virtual  ~PlayMediaPlayerObjectStart();

    /**
     * Assignment operator
     */
    inline PlayMediaPlayerObjectStart& operator = (const PlayMediaPlayerObjectStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayMediaPlayerObjectStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayMediaPlayerObjectStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayMediaPlayerObjectStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayMediaPlayerObjectStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Tag"

    static const int kU32Tag = 0;

    /**
     * Clears the field "u32Tag".
     *
     * The field will be set to its default value. The hasU32Tag()
     * method will return false.
     */
    inline void clearU32Tag();

    /**
     * Checks whether the field "u32Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Tag()). Otherwise it will return false.
     */
    inline bool hasU32Tag () const;

    /**
     * Returns the value of the member "u32Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value
     * identifies the media object to play.
     *
     * @return The value of the field "u32Tag"
     */
    inline uint32 getU32Tag () const;

    /**
     * Sets the value of the member "u32Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value
     * identifies the media object to play.
     *
     * @param u32Tag The value which will be set
     */
    inline void setU32Tag (uint32 u32Tag_);

    // API of field "bAutoPlay"

    static const int kBAutoPlay = 1;

    /**
     * Clears the field "bAutoPlay".
     *
     * The field will be set to its default value. The hasBAutoPlay()
     * method will return false.
     */
    inline void clearBAutoPlay();

    /**
     * Checks whether the field "bAutoPlay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutoPlay()). Otherwise it will return false.
     */
    inline bool hasBAutoPlay () const;

    /**
     * Returns the value of the member "bAutoPlay".
     *
     * If the AutoPlay parameter is set to True, the playlist includes all
     * available objects based on the Tagged objects type.
     *
     * If the AutoPlay parameter is set to False, the playlist only includes
     * objects 'underneath' the Tagged object. Only the hierarchy beneath the
     * user's selection is reflected in the playlist.
     *
     * @return The value of the field "bAutoPlay"
     */
    inline bool getBAutoPlay () const;

    /**
     * Sets the value of the member "bAutoPlay".
     *
     * If the AutoPlay parameter is set to True, the playlist includes all
     * available objects based on the Tagged objects type.
     *
     * If the AutoPlay parameter is set to False, the playlist only includes
     * objects 'underneath' the Tagged object. Only the hierarchy beneath the
     * user's selection is reflected in the playlist.
     *
     * @param bAutoPlay The value which will be set
     */
    inline void setBAutoPlay (bool bAutoPlay_);

    static const PlayMediaPlayerObjectStart &getDefaultInstance();

private:

    inline void set_has_u32Tag ();

    inline void clear_has_u32Tag ();

    inline void set_has_bAutoPlay ();

    inline void clear_has_bAutoPlay ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32Tag;

    bool _bAutoPlay;

};

/**
 * The result message of the method "PlayMediaPlayerObject"
 * The PlayMediaPlayerObject method is called to set the play object within
 * the MediaPlayer. The MediaPlayer handles this function as follows:
 *
 * If the MediaPlayer is not currently playing audio, it internally
 * stores the new object as the object to play the next time that the
 * MediaPlayer is connected for audio playback through the AVManager by
 * an HMI controller within the system.
 *
 * If the MediaPlayer is already connected on the network and playing
 * audio on another media object, it stops playback of that media object
 * and starts playing the new object automatically
 *
 * Note that the connect operation to the AVManager (RequestAVActivation
 * method) is not performed by the MediaPlayer and is instead performed
 * by an HMI controller. For example, if the user directly selects an
 * Artist from an HMI menu, the HMI controller would first call
 * PlayMediaPlayerObject and then would call the
 * AVManager.RequestAVActivation to connect the MediaPlayer over a
 * Logical Audio Channel.
 */
class PlayMediaPlayerObjectResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlayMediaPlayerObjectResult ();

    /**
     * Copy constructor
     */
    inline  PlayMediaPlayerObjectResult (const PlayMediaPlayerObjectResult &rhs);

    /**
     * All fields constructor
     */
    inline  PlayMediaPlayerObjectResult (uint32 u32ListHandle_, uint32 u32ListSize_);

    /**
     * Destructor
     */
    inline virtual  ~PlayMediaPlayerObjectResult();

    /**
     * Assignment operator
     */
    inline PlayMediaPlayerObjectResult& operator = (const PlayMediaPlayerObjectResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayMediaPlayerObjectResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayMediaPlayerObjectResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayMediaPlayerObjectResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayMediaPlayerObjectResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 1;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    static const PlayMediaPlayerObjectResult &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32ListSize;

};

/**
 * The start message of the method "PlayItemFromList"
 * The PlayItemFromList shall be used ONLY for accessing items from a Folder
 * list.  For all other lists, the new (as of 2.4.3) method
 * PlayItemFromListByTag 0x234 instead.The reason for this
 * restriction is that when the MediaPlayer adds items to the list, the
 * supplied StartIndex+StartOffset in the PlayItemFromList.StartResultAck may
 * now point to a different item in the list than the one that the user
 * selected. In PlayItemFromListByTag, the Tag of the item from which to
 * start play is sent instead, and, because the Tag doesn't change as the
 * list is updated, this error cannot occur.  However, this behavior does not
 * occur for Folder lists because the lists are static and do not change
 * after creation.The PlayItemFromList method is called to play an
 * item from a Folder list that has already been created. This method is
 * handled by the MediaPlayer as follows:
 *
 *
 * If the MediaPlayer is not currently connected as an audio source to
 * the AVManager, then the MediaPlayer sets the
 * item in the list, and the rest of the list as well, as the next media
 * object to be played when the MediaPlayer is next connected to the
 * AVManager.
 *
 * If the MediaPlayer is already connected on the network and playing
 * audio on another media object, it stops playback of that media object
 * and starts playing the selected list item automatically.
 *
 * Playback begins at the position specified by the StartIndex parameter
 * and continues in the order of the items included in the list defined
 * by the ListHandle parameter.
 *
 * In order to use this method, all items in the list must be "playable".
 * Therefore, this method is mainly used in conjunction with
 * CreateMediaPlayerQuickPlayList but can also be used with
 * CreateMediaPlayerFile.
 */
class PlayItemFromListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlayItemFromListStart ();

    /**
     * Copy constructor
     */
    inline  PlayItemFromListStart (const PlayItemFromListStart &rhs);

    /**
     * All fields constructor
     */
    inline  PlayItemFromListStart (uint32 u32ListHandle_, uint32 u32StartIndex_, uint32 u32StartOffset_);

    /**
     * Destructor
     */
    inline virtual  ~PlayItemFromListStart();

    /**
     * Assignment operator
     */
    inline PlayItemFromListStart& operator = (const PlayItemFromListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayItemFromListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayItemFromListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayItemFromListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayItemFromListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32StartIndex"

    static const int kU32StartIndex = 1;

    /**
     * Clears the field "u32StartIndex".
     *
     * The field will be set to its default value. The hasU32StartIndex()
     * method will return false.
     */
    inline void clearU32StartIndex();

    /**
     * Checks whether the field "u32StartIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32StartIndex()). Otherwise it will return false.
     */
    inline bool hasU32StartIndex () const;

    /**
     * Returns the value of the member "u32StartIndex".
     *
     * Index (or position) within the specified list handle of the item to play. If start index is -1 MediaPlayer searches for the firts playable object
     *
     * @return The value of the field "u32StartIndex"
     */
    inline uint32 getU32StartIndex () const;

    /**
     * Sets the value of the member "u32StartIndex".
     *
     * Index (or position) within the specified list handle of the item to play. If start index is -1 MediaPlayer searches for the firts playable object
     *
     * @param u32StartIndex The value which will be set
     */
    inline void setU32StartIndex (uint32 u32StartIndex_);

    // API of field "u32StartOffset"

    static const int kU32StartOffset = 2;

    /**
     * Clears the field "u32StartOffset".
     *
     * The field will be set to its default value. The hasU32StartOffset()
     * method will return false.
     */
    inline void clearU32StartOffset();

    /**
     * Checks whether the field "u32StartOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32StartOffset()). Otherwise it will return false.
     */
    inline bool hasU32StartOffset () const;

    /**
     * Returns the value of the member "u32StartOffset".
     *
     * Number of milliseconds into the track to begin playback
     *
     * @return The value of the field "u32StartOffset"
     */
    inline uint32 getU32StartOffset () const;

    /**
     * Sets the value of the member "u32StartOffset".
     *
     * Number of milliseconds into the track to begin playback
     *
     * @param u32StartOffset The value which will be set
     */
    inline void setU32StartOffset (uint32 u32StartOffset_);

    static const PlayItemFromListStart &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32StartIndex ();

    inline void clear_has_u32StartIndex ();

    inline void set_has_u32StartOffset ();

    inline void clear_has_u32StartOffset ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32StartIndex;

    uint32 _u32StartOffset;

};

/**
 * The result message of the method "PlayItemFromList"
 * The PlayItemFromList shall be used ONLY for accessing items from a Folder
 * list.  For all other lists, the new (as of 2.4.3) method
 * PlayItemFromListByTag 0x234 instead.The reason for this
 * restriction is that when the MediaPlayer adds items to the list, the
 * supplied StartIndex+StartOffset in the PlayItemFromList.StartResultAck may
 * now point to a different item in the list than the one that the user
 * selected. In PlayItemFromListByTag, the Tag of the item from which to
 * start play is sent instead, and, because the Tag doesn't change as the
 * list is updated, this error cannot occur.  However, this behavior does not
 * occur for Folder lists because the lists are static and do not change
 * after creation.The PlayItemFromList method is called to play an
 * item from a Folder list that has already been created. This method is
 * handled by the MediaPlayer as follows:
 *
 *
 * If the MediaPlayer is not currently connected as an audio source to
 * the AVManager, then the MediaPlayer sets the
 * item in the list, and the rest of the list as well, as the next media
 * object to be played when the MediaPlayer is next connected to the
 * AVManager.
 *
 * If the MediaPlayer is already connected on the network and playing
 * audio on another media object, it stops playback of that media object
 * and starts playing the selected list item automatically.
 *
 * Playback begins at the position specified by the StartIndex parameter
 * and continues in the order of the items included in the list defined
 * by the ListHandle parameter.
 *
 * In order to use this method, all items in the list must be "playable".
 * Therefore, this method is mainly used in conjunction with
 * CreateMediaPlayerQuickPlayList but can also be used with
 * CreateMediaPlayerFile.
 */
class PlayItemFromListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlayItemFromListResult ();

    /**
     * Copy constructor
     */
    inline  PlayItemFromListResult (const PlayItemFromListResult &rhs);

    /**
     * All fields constructor
     */
    inline  PlayItemFromListResult (uint32 u32ListHandle_, uint32 u32ListSize_);

    /**
     * Destructor
     */
    inline virtual  ~PlayItemFromListResult();

    /**
     * Assignment operator
     */
    inline PlayItemFromListResult& operator = (const PlayItemFromListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayItemFromListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayItemFromListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayItemFromListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayItemFromListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 1;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    static const PlayItemFromListResult &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32ListSize;

};

/**
 * The start message of the method "Umount"
 * The Umount method is called to support a safe disconnection of the SDCard.
 */
class UmountStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UmountStart ();

    /**
     * Copy constructor
     */
    inline  UmountStart (const UmountStart &rhs);

    /**
     * All fields constructor
     */
    inline  UmountStart (uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~UmountStart();

    /**
     * Assignment operator
     */
    inline UmountStart& operator = (const UmountStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UmountStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UmountStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UmountStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UmountStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const UmountStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceTag;

};

/**
 * The result message of the method "Umount"
 * The Umount method is called to support a safe disconnection of the SDCard.
 */
class UmountResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UmountResult ();

    /**
     * Copy constructor
     */
    inline  UmountResult (const UmountResult &rhs);

    /**
     * All fields constructor
     */
    inline  UmountResult (uint8 u8DeviceTag_, ::MPlay_fi_types::T_e8_MPlayUmountResult e8UmountResult_);

    /**
     * Destructor
     */
    inline virtual  ~UmountResult();

    /**
     * Assignment operator
     */
    inline UmountResult& operator = (const UmountResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UmountResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UmountResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UmountResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UmountResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "e8UmountResult"

    static const int kE8UmountResult = 1;

    /**
     * Clears the field "e8UmountResult".
     *
     * The field will be set to its default value. The hasE8UmountResult()
     * method will return false.
     */
    inline void clearE8UmountResult();

    /**
     * Checks whether the field "e8UmountResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8UmountResult()). Otherwise it will return false.
     */
    inline bool hasE8UmountResult () const;

    /**
     * Returns the value of the member "e8UmountResult".
     *
     * Returns the error code of the umount command.
     *
     * @return The value of the field "e8UmountResult"
     */
    inline ::MPlay_fi_types::T_e8_MPlayUmountResult getE8UmountResult () const;

    /**
     * Sets the value of the member "e8UmountResult".
     *
     * Returns the error code of the umount command.
     *
     * @param e8UmountResult The value which will be set
     */
    inline void setE8UmountResult (::MPlay_fi_types::T_e8_MPlayUmountResult e8UmountResult_);

    static const UmountResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_e8UmountResult ();

    inline void clear_has_e8UmountResult ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceTag;

    ::MPlay_fi_types::T_e8_MPlayUmountResult _e8UmountResult;

};

/**
 * The start message of the method "Reindexing"
 * The reindexing function can be called by controller to start a indexing of a specified device.
 */
class ReindexingStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReindexingStart ();

    /**
     * Copy constructor
     */
    inline  ReindexingStart (const ReindexingStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReindexingStart (uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~ReindexingStart();

    /**
     * Assignment operator
     */
    inline ReindexingStart& operator = (const ReindexingStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReindexingStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReindexingStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReindexingStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReindexingStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Device ID
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Device ID
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const ReindexingStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceTag;

};

/**
 * The start message of the method "DiagnosisPlaySong"
 * This function searches the first connected device of the specifed type and tries to play the song
 * specified in sFilename in an infinite loop.
 * sFileName contains the complete path and the filename.
 * To come out of the infinite loop behaviour, from HMI PBA_NEXT can be issued or a different song
 * can be selected for playback from any indexed/file list.
 */
class DiagnosisPlaySongStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagnosisPlaySongStart ();

    /**
     * Copy constructor
     */
    inline  DiagnosisPlaySongStart (const DiagnosisPlaySongStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiagnosisPlaySongStart (::MPlay_fi_types::T_e8_MPlayDeviceType e8DeviceType_, const ::std::string& sFilename_);

    /**
     * Destructor
     */
    inline virtual  ~DiagnosisPlaySongStart();

    /**
     * Assignment operator
     */
    inline DiagnosisPlaySongStart& operator = (const DiagnosisPlaySongStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagnosisPlaySongStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagnosisPlaySongStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagnosisPlaySongStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagnosisPlaySongStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DeviceType"

    static const int kE8DeviceType = 0;

    /**
     * Clears the field "e8DeviceType".
     *
     * The field will be set to its default value. The hasE8DeviceType()
     * method will return false.
     */
    inline void clearE8DeviceType();

    /**
     * Checks whether the field "e8DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceType()). Otherwise it will return false.
     */
    inline bool hasE8DeviceType () const;

    /**
     * Returns the value of the member "e8DeviceType".
     *
     * Device type
     *
     * @return The value of the field "e8DeviceType"
     */
    inline ::MPlay_fi_types::T_e8_MPlayDeviceType getE8DeviceType () const;

    /**
     * Sets the value of the member "e8DeviceType".
     *
     * Device type
     *
     * @param e8DeviceType The value which will be set
     */
    inline void setE8DeviceType (::MPlay_fi_types::T_e8_MPlayDeviceType e8DeviceType_);

    // API of field "sFilename"

    static const int kSFilename = 1;

    /**
     * Clears the field "sFilename".
     *
     * The field will be set to its default value. The hasSFilename()
     * method will return false.
     */
    inline void clearSFilename();

    /**
     * Checks whether the field "sFilename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFilename()). Otherwise it will return false.
     */
    inline bool hasSFilename () const;

    /**
     * Returns the value of the member "sFilename".
     *
     * Filename including the name and the path.
     *
     * @return The value of the field "sFilename"
     */
    inline const ::std::string& getSFilename () const;

    /**
     * Retrieves the value of the field "sFilename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFilename".
     */
    inline ::std::string& getSFilenameMutable ();

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename including the name and the path.
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const ::std::string& sFilename_);

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename including the name and the path.
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const char* sFilename_);

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename including the name and the path.
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const char* value, size_t size);

    static const DiagnosisPlaySongStart &getDefaultInstance();

private:

    inline void set_has_e8DeviceType ();

    inline void clear_has_e8DeviceType ();

    inline void set_has_sFilename ();

    inline void clear_has_sFilename ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayDeviceType _e8DeviceType;

    ::std::string _sFilename;

};

/**
 * The start message of the method "RequestListDetails"
 * deprecated. The RequestListDetails Method is deprecated and its use is discouraged. It is retained within
 * the function catalog for backward compatibility only. All controllers
 * should use the RequestListInformation Method FktID 0x232 instead.
 *
 * The RequestListDetails Method can be called
 * by HMI controllers to retrieve the following information associated with
 * the supplied ListHandle:
 * The ListType for this list.
 * The llist parent's ListHandle or NULL if the supplied ListHandle
 * corresponds to a top-level, root list.
 * The DeviceTag from which the list was generated (either a specific
 * device or 0 for MyMedia)
 * The object's position within the parent's list starting from 0 (within
 * the Position parameter)
 */
class RequestListDetailsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestListDetailsStart ();

    /**
     * Copy constructor
     */
    inline  RequestListDetailsStart (const RequestListDetailsStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestListDetailsStart (uint32 u32ListHandle_);

    /**
     * Destructor
     */
    inline virtual  ~RequestListDetailsStart();

    /**
     * Assignment operator
     */
    inline RequestListDetailsStart& operator = (const RequestListDetailsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestListDetailsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestListDetailsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestListDetailsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestListDetailsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    static const RequestListDetailsStart &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32ListHandle;

};

/**
 * The result message of the method "RequestListDetails"
 * deprecated. The RequestListDetails Method is deprecated and its use is discouraged. It is retained within
 * the function catalog for backward compatibility only. All controllers
 * should use the RequestListInformation Method FktID 0x232 instead.
 *
 * The RequestListDetails Method can be called
 * by HMI controllers to retrieve the following information associated with
 * the supplied ListHandle:
 * The ListType for this list.
 * The llist parent's ListHandle or NULL if the supplied ListHandle
 * corresponds to a top-level, root list.
 * The DeviceTag from which the list was generated (either a specific
 * device or 0 for MyMedia)
 * The object's position within the parent's list starting from 0 (within
 * the Position parameter)
 */
class RequestListDetailsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestListDetailsResult ();

    /**
     * Copy constructor
     */
    inline  RequestListDetailsResult (const RequestListDetailsResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestListDetailsResult (::MPlay_fi_types::T_e8_MPlayListType e8ListType_, uint32 u32ParentListHandle_, uint8 u8DeviceTag_, uint32 u32Position_);

    /**
     * Destructor
     */
    inline virtual  ~RequestListDetailsResult();

    /**
     * Assignment operator
     */
    inline RequestListDetailsResult& operator = (const RequestListDetailsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestListDetailsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestListDetailsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestListDetailsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestListDetailsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ListType"

    static const int kE8ListType = 0;

    /**
     * Clears the field "e8ListType".
     *
     * The field will be set to its default value. The hasE8ListType()
     * method will return false.
     */
    inline void clearE8ListType();

    /**
     * Checks whether the field "e8ListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListType()). Otherwise it will return false.
     */
    inline bool hasE8ListType () const;

    /**
     * Returns the value of the member "e8ListType".
     *
     * Defines the type of list requested from the MediaPlayer.
     *
     * @return The value of the field "e8ListType"
     */
    inline ::MPlay_fi_types::T_e8_MPlayListType getE8ListType () const;

    /**
     * Sets the value of the member "e8ListType".
     *
     * Defines the type of list requested from the MediaPlayer.
     *
     * @param e8ListType The value which will be set
     */
    inline void setE8ListType (::MPlay_fi_types::T_e8_MPlayListType e8ListType_);

    // API of field "u32ParentListHandle"

    static const int kU32ParentListHandle = 1;

    /**
     * Clears the field "u32ParentListHandle".
     *
     * The field will be set to its default value. The hasU32ParentListHandle()
     * method will return false.
     */
    inline void clearU32ParentListHandle();

    /**
     * Checks whether the field "u32ParentListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ParentListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ParentListHandle () const;

    /**
     * Returns the value of the member "u32ParentListHandle".
     *
     * The handle of the parent list to the supplied list handle.  If NULL (0x00000000), then the supplied ListHandle is already a top-level/root and has no parent.
     *
     * @return The value of the field "u32ParentListHandle"
     */
    inline uint32 getU32ParentListHandle () const;

    /**
     * Sets the value of the member "u32ParentListHandle".
     *
     * The handle of the parent list to the supplied list handle.  If NULL (0x00000000), then the supplied ListHandle is already a top-level/root and has no parent.
     *
     * @param u32ParentListHandle The value which will be set
     */
    inline void setU32ParentListHandle (uint32 u32ParentListHandle_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 2;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "u32Position"

    static const int kU32Position = 3;

    /**
     * Clears the field "u32Position".
     *
     * The field will be set to its default value. The hasU32Position()
     * method will return false.
     */
    inline void clearU32Position();

    /**
     * Checks whether the field "u32Position" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Position()). Otherwise it will return false.
     */
    inline bool hasU32Position () const;

    /**
     * Returns the value of the member "u32Position".
     *
     * Contains the position (or index) of the item within the specified list starting at 0 for the first element in the list.
     *
     * @return The value of the field "u32Position"
     */
    inline uint32 getU32Position () const;

    /**
     * Sets the value of the member "u32Position".
     *
     * Contains the position (or index) of the item within the specified list starting at 0 for the first element in the list.
     *
     * @param u32Position The value which will be set
     */
    inline void setU32Position (uint32 u32Position_);

    static const RequestListDetailsResult &getDefaultInstance();

private:

    inline void set_has_e8ListType ();

    inline void clear_has_e8ListType ();

    inline void set_has_u32ParentListHandle ();

    inline void clear_has_u32ParentListHandle ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_u32Position ();

    inline void clear_has_u32Position ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayListType _e8ListType;

    uint32 _u32ParentListHandle;

    uint8 _u8DeviceTag;

    uint32 _u32Position;

};

/**
 * The start message of the method "RequestListInformation"
 * The RequestListInformation Method provides a means for HMI controllers to
 * retrieve detailed information on a ListHandle as follows:
 *
 * This method was added to allow controllers to determine type, size,
 * and parent list information for the ListHandle transmitted in the
 * NowPlaying property Status notifications. Only the ListHandle is sent
 * within the NowPlaying.Status notification, but controllers need type,
 * parent, and size information to implement the required functionality.
 *
 * The following information is returned in the ResultAck response.
 * ListType contains the type of the list for the supplied ListHandle.
 * ParentListHandle contains the handle of the parent to this list.
 * If the supplied ListHandle is the 'root' list and does not have a
 * parent, the returned ListHandle will be NULL (0x00000000).
 * DeviceTag points to the device from which the list was generated
 * which will be either 0 for MyMedia if the list was generated from
 * the MyMedia database across all devices or a valid device-specific
 * tag if the list only includes information from a specific user
 * device.
 * Position of this list item within the parent's list (the list
 * pointed by the ParentListHandle). If this list does not have a
 * parent (ParentListHandle = NULL, 0x00000000), then the Position
 * parameter shall be set to 0 as a NULL default.
 * ListSize is the current number of items in the list pointed by the
 * supplied ListHandle.
 * RequestListInformation replaces the deprecated RequestListDetails
 * 0x231 FktID. RequestListDetails did not include the ListSize parameter
 * which was determined to be required in order for controllers to
 * properly handling their subsequent RequestMediaPlayerIndexedListSlice
 * calls. RequestListInformation was thus created as an extension of
 * RequestListDetails that also includes the ListSize. All new controller
 * designs shall use RequestListInformation instead of RequestListDetails.
 */
class RequestListInformationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestListInformationStart ();

    /**
     * Copy constructor
     */
    inline  RequestListInformationStart (const RequestListInformationStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestListInformationStart (uint32 u32ListHandle_);

    /**
     * Destructor
     */
    inline virtual  ~RequestListInformationStart();

    /**
     * Assignment operator
     */
    inline RequestListInformationStart& operator = (const RequestListInformationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestListInformationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestListInformationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestListInformationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestListInformationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer.  The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    static const RequestListInformationStart &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32ListHandle;

};

/**
 * The result message of the method "RequestListInformation"
 * The RequestListInformation Method provides a means for HMI controllers to
 * retrieve detailed information on a ListHandle as follows:
 *
 * This method was added to allow controllers to determine type, size,
 * and parent list information for the ListHandle transmitted in the
 * NowPlaying property Status notifications. Only the ListHandle is sent
 * within the NowPlaying.Status notification, but controllers need type,
 * parent, and size information to implement the required functionality.
 *
 * The following information is returned in the ResultAck response.
 * ListType contains the type of the list for the supplied ListHandle.
 * ParentListHandle contains the handle of the parent to this list.
 * If the supplied ListHandle is the 'root' list and does not have a
 * parent, the returned ListHandle will be NULL (0x00000000).
 * DeviceTag points to the device from which the list was generated
 * which will be either 0 for MyMedia if the list was generated from
 * the MyMedia database across all devices or a valid device-specific
 * tag if the list only includes information from a specific user
 * device.
 * Position of this list item within the parent's list (the list
 * pointed by the ParentListHandle). If this list does not have a
 * parent (ParentListHandle = NULL, 0x00000000), then the Position
 * parameter shall be set to 0 as a NULL default.
 * ListSize is the current number of items in the list pointed by the
 * supplied ListHandle.
 * RequestListInformation replaces the deprecated RequestListDetails
 * 0x231 FktID. RequestListDetails did not include the ListSize parameter
 * which was determined to be required in order for controllers to
 * properly handling their subsequent RequestMediaPlayerIndexedListSlice
 * calls. RequestListInformation was thus created as an extension of
 * RequestListDetails that also includes the ListSize. All new controller
 * designs shall use RequestListInformation instead of RequestListDetails.
 */
class RequestListInformationResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestListInformationResult ();

    /**
     * Copy constructor
     */
    inline  RequestListInformationResult (const RequestListInformationResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestListInformationResult (::MPlay_fi_types::T_e8_MPlayListType e8ListType_, uint32 u32ParentListHandle_, uint8 u8DeviceTag_, uint32 u32Position_, uint32 u32ListSize_, const ::std::string& sPath_);

    /**
     * Destructor
     */
    inline virtual  ~RequestListInformationResult();

    /**
     * Assignment operator
     */
    inline RequestListInformationResult& operator = (const RequestListInformationResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestListInformationResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestListInformationResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestListInformationResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestListInformationResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ListType"

    static const int kE8ListType = 0;

    /**
     * Clears the field "e8ListType".
     *
     * The field will be set to its default value. The hasE8ListType()
     * method will return false.
     */
    inline void clearE8ListType();

    /**
     * Checks whether the field "e8ListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListType()). Otherwise it will return false.
     */
    inline bool hasE8ListType () const;

    /**
     * Returns the value of the member "e8ListType".
     *
     * Defines the type of list requested from the MediaPlayer.
     *
     * @return The value of the field "e8ListType"
     */
    inline ::MPlay_fi_types::T_e8_MPlayListType getE8ListType () const;

    /**
     * Sets the value of the member "e8ListType".
     *
     * Defines the type of list requested from the MediaPlayer.
     *
     * @param e8ListType The value which will be set
     */
    inline void setE8ListType (::MPlay_fi_types::T_e8_MPlayListType e8ListType_);

    // API of field "u32ParentListHandle"

    static const int kU32ParentListHandle = 1;

    /**
     * Clears the field "u32ParentListHandle".
     *
     * The field will be set to its default value. The hasU32ParentListHandle()
     * method will return false.
     */
    inline void clearU32ParentListHandle();

    /**
     * Checks whether the field "u32ParentListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ParentListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ParentListHandle () const;

    /**
     * Returns the value of the member "u32ParentListHandle".
     *
     * The handle of the parent list to the supplied list handle.  If NULL (0x00000000), then the supplied ListHandle is already a top-level/root and has no parent.
     *
     * @return The value of the field "u32ParentListHandle"
     */
    inline uint32 getU32ParentListHandle () const;

    /**
     * Sets the value of the member "u32ParentListHandle".
     *
     * The handle of the parent list to the supplied list handle.  If NULL (0x00000000), then the supplied ListHandle is already a top-level/root and has no parent.
     *
     * @param u32ParentListHandle The value which will be set
     */
    inline void setU32ParentListHandle (uint32 u32ParentListHandle_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 2;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "u32Position"

    static const int kU32Position = 3;

    /**
     * Clears the field "u32Position".
     *
     * The field will be set to its default value. The hasU32Position()
     * method will return false.
     */
    inline void clearU32Position();

    /**
     * Checks whether the field "u32Position" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Position()). Otherwise it will return false.
     */
    inline bool hasU32Position () const;

    /**
     * Returns the value of the member "u32Position".
     *
     * The Position of this list as the index within the Parent list pointed by the ParentListHandle starting with 0 as the first element in the parent list.  If this list does not have a parent (ParentListHandle = NULL, 0x00000000), then this item shall be set to 0.
     *
     * @return The value of the field "u32Position"
     */
    inline uint32 getU32Position () const;

    /**
     * Sets the value of the member "u32Position".
     *
     * The Position of this list as the index within the Parent list pointed by the ParentListHandle starting with 0 as the first element in the parent list.  If this list does not have a parent (ParentListHandle = NULL, 0x00000000), then this item shall be set to 0.
     *
     * @param u32Position The value which will be set
     */
    inline void setU32Position (uint32 u32Position_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 4;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The number of elements in a list.  The size is valid until the list is modified or released.
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    // API of field "sPath"

    static const int kSPath = 5;

    /**
     * Clears the field "sPath".
     *
     * The field will be set to its default value. The hasSPath()
     * method will return false.
     */
    inline void clearSPath();

    /**
     * Checks whether the field "sPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPath()). Otherwise it will return false.
     */
    inline bool hasSPath () const;

    /**
     * Returns the value of the member "sPath".
     *
     * The root path of the list. This information is valid only for file lists.
     *
     * @return The value of the field "sPath"
     */
    inline const ::std::string& getSPath () const;

    /**
     * Retrieves the value of the field "sPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPath".
     */
    inline ::std::string& getSPathMutable ();

    /**
     * Sets the value of the member "sPath".
     *
     * The root path of the list. This information is valid only for file lists.
     *
     * @param sPath The value which will be set
     */
    inline void setSPath (const ::std::string& sPath_);

    /**
     * Sets the value of the member "sPath".
     *
     * The root path of the list. This information is valid only for file lists.
     *
     * @param sPath The value which will be set
     */
    inline void setSPath (const char* sPath_);

    /**
     * Sets the value of the member "sPath".
     *
     * The root path of the list. This information is valid only for file lists.
     *
     * @param sPath The value which will be set
     */
    inline void setSPath (const char* value, size_t size);

    static const RequestListInformationResult &getDefaultInstance();

private:

    inline void set_has_e8ListType ();

    inline void clear_has_e8ListType ();

    inline void set_has_u32ParentListHandle ();

    inline void clear_has_u32ParentListHandle ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_u32Position ();

    inline void clear_has_u32Position ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    inline void set_has_sPath ();

    inline void clear_has_sPath ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlayListType _e8ListType;

    uint32 _u32ParentListHandle;

    uint8 _u8DeviceTag;

    uint32 _u32Position;

    uint32 _u32ListSize;

    ::std::string _sPath;

};

/**
 * The start message of the method "TransferTagsToDevice"
 * TransferTagsToDevice is called by a controller to transfer tags to a
 * customer portable device (generally an Apple iPod/iPhone/iTouch, etc.)
 * connected to the USB port as follows:
 *
 * The controller accumulates information for tagging via interfaces on
 * the tuner FBlocks (HD AM or FMTuner, SDARS FBlock,etc.).
 *
 * The controller passes the accumulated tag information to the
 * MediaPlayer FBlock via the StartResultAck of this method, generally
 * upon connection of the user's device.
 *
 * Upon receipt of the StartResultAck, the MediaPlayer FBlock attempts to
 * transfer the tags to a customer device connected to the MediaPlayer
 * FBlock, generally via the USB port.
 *
 * The TagTransferStatus parameter in the ResultAck response indicates
 * the completion status of the operation. Note that if TagTransferStatus
 * != SUCCESS, then one or more tags could not be transferred. The ID
 * information for the tags that were not transferred is passed back in
 * the UntransferredTagStream property.
 *
 * Upon receipt of the ResultAck response, the requesting controller may
 * delete the stored tags that were successfully transferred. If there
 * were transfer errors, then the controller should keep the
 * untransferred tags and attempt to transfer them again at the next
 * device connection.
 *
 * This function replaces the deprecated TransferTags FktID 0x227 Method.
 */
class TransferTagsToDeviceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransferTagsToDeviceStart ();

    /**
     * Copy constructor
     */
    inline  TransferTagsToDeviceStart (const TransferTagsToDeviceStart &rhs);

    /**
     * All fields constructor
     */
    inline  TransferTagsToDeviceStart (uint8 u8DeviceTag_, const ::MPlay_fi_types::T_MPlayTagTransfer_2& oTagTransfer_);

    /**
     * Destructor
     */
    inline virtual  ~TransferTagsToDeviceStart();

    /**
     * Assignment operator
     */
    inline TransferTagsToDeviceStart& operator = (const TransferTagsToDeviceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransferTagsToDeviceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransferTagsToDeviceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransferTagsToDeviceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransferTagsToDeviceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "oTagTransfer"

    static const int kOTagTransfer = 1;

    /**
     * Clears the field "oTagTransfer".
     *
     * The field will be set to its default value. The hasOTagTransfer()
     * method will return false.
     */
    inline void clearOTagTransfer();

    /**
     * Checks whether the field "oTagTransfer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOTagTransfer()). Otherwise it will return false.
     */
    inline bool hasOTagTransfer () const;

    /**
     * Returns the value of the member "oTagTransfer".
     *
     * Stream with all the tags to transfer to an iPod
     *
     * @return The value of the field "oTagTransfer"
     */
    inline const ::MPlay_fi_types::T_MPlayTagTransfer_2& getOTagTransfer () const;

    /**
     * Retrieves the value of the field "oTagTransfer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oTagTransfer".
     */
    inline ::MPlay_fi_types::T_MPlayTagTransfer_2& getOTagTransferMutable ();

    /**
     * Sets the value of the member "oTagTransfer".
     *
     * Stream with all the tags to transfer to an iPod
     *
     * @param oTagTransfer The value which will be set
     */
    inline void setOTagTransfer (const ::MPlay_fi_types::T_MPlayTagTransfer_2& oTagTransfer_);

    static const TransferTagsToDeviceStart &getDefaultInstance();

private:

    static const ::std::vector< ::MPlay_fi_types::T_MPlayTagTransferItem_2 >& getT_MPlayTagTransferItem_2List_DefaultInstance ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_oTagTransfer ();

    inline void clear_has_oTagTransfer ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceTag;

    ::MPlay_fi_types::T_MPlayTagTransfer_2 _oTagTransfer;

};

/**
 * The result message of the method "TransferTagsToDevice"
 * TransferTagsToDevice is called by a controller to transfer tags to a
 * customer portable device (generally an Apple iPod/iPhone/iTouch, etc.)
 * connected to the USB port as follows:
 *
 * The controller accumulates information for tagging via interfaces on
 * the tuner FBlocks (HD AM or FMTuner, SDARS FBlock,etc.).
 *
 * The controller passes the accumulated tag information to the
 * MediaPlayer FBlock via the StartResultAck of this method, generally
 * upon connection of the user's device.
 *
 * Upon receipt of the StartResultAck, the MediaPlayer FBlock attempts to
 * transfer the tags to a customer device connected to the MediaPlayer
 * FBlock, generally via the USB port.
 *
 * The TagTransferStatus parameter in the ResultAck response indicates
 * the completion status of the operation. Note that if TagTransferStatus
 * != SUCCESS, then one or more tags could not be transferred. The ID
 * information for the tags that were not transferred is passed back in
 * the UntransferredTagStream property.
 *
 * Upon receipt of the ResultAck response, the requesting controller may
 * delete the stored tags that were successfully transferred. If there
 * were transfer errors, then the controller should keep the
 * untransferred tags and attempt to transfer them again at the next
 * device connection.
 *
 * This function replaces the deprecated TransferTags FktID 0x227 Method.
 */
class TransferTagsToDeviceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransferTagsToDeviceResult ();

    /**
     * Copy constructor
     */
    inline  TransferTagsToDeviceResult (const TransferTagsToDeviceResult &rhs);

    /**
     * All fields constructor
     */
    inline  TransferTagsToDeviceResult (uint8 u8DeviceTag_, ::MPlay_fi_types::T_e8_MPlayTagTransferStatus e8TagTransferStatus_, const ::MPlay_fi_types::T_MPlayUntransferredTagStream& oUntransferredTagStream_);

    /**
     * Destructor
     */
    inline virtual  ~TransferTagsToDeviceResult();

    /**
     * Assignment operator
     */
    inline TransferTagsToDeviceResult& operator = (const TransferTagsToDeviceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransferTagsToDeviceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransferTagsToDeviceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransferTagsToDeviceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransferTagsToDeviceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "e8TagTransferStatus"

    static const int kE8TagTransferStatus = 1;

    /**
     * Clears the field "e8TagTransferStatus".
     *
     * The field will be set to its default value. The hasE8TagTransferStatus()
     * method will return false.
     */
    inline void clearE8TagTransferStatus();

    /**
     * Checks whether the field "e8TagTransferStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TagTransferStatus()). Otherwise it will return false.
     */
    inline bool hasE8TagTransferStatus () const;

    /**
     * Returns the value of the member "e8TagTransferStatus".
     *
     * Returns the status of the requested TagTransfer.
     *
     * @return The value of the field "e8TagTransferStatus"
     */
    inline ::MPlay_fi_types::T_e8_MPlayTagTransferStatus getE8TagTransferStatus () const;

    /**
     * Sets the value of the member "e8TagTransferStatus".
     *
     * Returns the status of the requested TagTransfer.
     *
     * @param e8TagTransferStatus The value which will be set
     */
    inline void setE8TagTransferStatus (::MPlay_fi_types::T_e8_MPlayTagTransferStatus e8TagTransferStatus_);

    // API of field "oUntransferredTagStream"

    static const int kOUntransferredTagStream = 2;

    /**
     * Clears the field "oUntransferredTagStream".
     *
     * The field will be set to its default value. The hasOUntransferredTagStream()
     * method will return false.
     */
    inline void clearOUntransferredTagStream();

    /**
     * Checks whether the field "oUntransferredTagStream" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOUntransferredTagStream()). Otherwise it will return false.
     */
    inline bool hasOUntransferredTagStream () const;

    /**
     * Returns the value of the member "oUntransferredTagStream".
     *
     * The UntransferredTagStream contains the information for which of the tags
     * in the TransferTag parameter within the StartResultAck could not be
     * transferred due to some kind of error condition. These conditions include
     * a communication error or lack of space for additional tags in the USB
     * device.This stream will be empty if all of the tags present in the
     * TransferTag parameter were successfully transferred to the device
     * (TagTransferStatus = TAG_TRANSFER_SUCCESS). If UntransferredTagStream
     * contains one or more sets of tag information, then those tags could not be
     * transferred to the device and the calling controller should take
     * additional actions such as displaying an error message, saving the
     * untransferred tags until the device is connected again etc.. Specific
     * error messages are defined in the applicable Form and Behavior
     * specification(s).Note that UntransferredTagStream only includes a
     * subset of the parameters in the TransferTag stream that is sufficient to
     * uniquely identify which of the items in the TransferTag stream could not
     * be successfully transferred.
     *
     * @return The value of the field "oUntransferredTagStream"
     */
    inline const ::MPlay_fi_types::T_MPlayUntransferredTagStream& getOUntransferredTagStream () const;

    /**
     * Retrieves the value of the field "oUntransferredTagStream" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oUntransferredTagStream".
     */
    inline ::MPlay_fi_types::T_MPlayUntransferredTagStream& getOUntransferredTagStreamMutable ();

    /**
     * Sets the value of the member "oUntransferredTagStream".
     *
     * The UntransferredTagStream contains the information for which of the tags
     * in the TransferTag parameter within the StartResultAck could not be
     * transferred due to some kind of error condition. These conditions include
     * a communication error or lack of space for additional tags in the USB
     * device.This stream will be empty if all of the tags present in the
     * TransferTag parameter were successfully transferred to the device
     * (TagTransferStatus = TAG_TRANSFER_SUCCESS). If UntransferredTagStream
     * contains one or more sets of tag information, then those tags could not be
     * transferred to the device and the calling controller should take
     * additional actions such as displaying an error message, saving the
     * untransferred tags until the device is connected again etc.. Specific
     * error messages are defined in the applicable Form and Behavior
     * specification(s).Note that UntransferredTagStream only includes a
     * subset of the parameters in the TransferTag stream that is sufficient to
     * uniquely identify which of the items in the TransferTag stream could not
     * be successfully transferred.
     *
     * @param oUntransferredTagStream The value which will be set
     */
    inline void setOUntransferredTagStream (const ::MPlay_fi_types::T_MPlayUntransferredTagStream& oUntransferredTagStream_);

    static const TransferTagsToDeviceResult &getDefaultInstance();

private:

    static const ::std::vector< ::MPlay_fi_types::T_MPlayUntransferredTagStreamItem >& getT_MPlayUntransferredTagStreamItemList_DefaultInstance ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_e8TagTransferStatus ();

    inline void clear_has_e8TagTransferStatus ();

    inline void set_has_oUntransferredTagStream ();

    inline void clear_has_oUntransferredTagStream ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceTag;

    ::MPlay_fi_types::T_e8_MPlayTagTransferStatus _e8TagTransferStatus;

    ::MPlay_fi_types::T_MPlayUntransferredTagStream _oUntransferredTagStream;

};

/**
 * The start message of the method "PlayItemFromListByTag"
 * The PlayItemFromListByTag method is called to play an item from a
 * previously created list. The item is identified by the Tag parameter which
 * must point to an item currently in the list. PlayItemFromListByTag
 * replaces PlayItemFromList 0x229 because PlayItemFromList uses an index to
 * identify the item to play.
 * The PlayItemFromListByTag method is handled by the MediaPlayer as follows:
 *
 * If the MediaPlayer is not currently connected as an audio source to
 * the AVManager, then the MediaPlayer sets the
 * item in the list, and the rest of the list as well, as the next media
 * object to be played when the MediaPlayer is next connected to the
 * AVManager.
 *
 * If the MediaPlayer is already connected on the network and playing
 * audio on another media object, it stops playback of that media object
 * and starts playing the selected list item automatically.
 *
 * Playback begins at the object identifed by the Tag parameter and
 * continues according to the order of the list identified by the
 * ListHandle parameter.
 *
 * In order to use this method, all items in the list must be "playable".
 * Therefore, this method is mainly used in conjunction with
 * CreateMediaPlayerQuickPlayList but can also be used with
 * CreateMediaPlayerFile.
 *
 * The item identified by the Tag must currently exist in the list. If it
 * does not exist, the MediaPlayer shall respond with an error.
 */
class PlayItemFromListByTagStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlayItemFromListByTagStart ();

    /**
     * Copy constructor
     */
    inline  PlayItemFromListByTagStart (const PlayItemFromListByTagStart &rhs);

    /**
     * All fields constructor
     */
    inline  PlayItemFromListByTagStart (uint32 u32ListHandle_, uint32 u32Tag_);

    /**
     * Destructor
     */
    inline virtual  ~PlayItemFromListByTagStart();

    /**
     * Assignment operator
     */
    inline PlayItemFromListByTagStart& operator = (const PlayItemFromListByTagStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayItemFromListByTagStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayItemFromListByTagStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayItemFromListByTagStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayItemFromListByTagStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ListHandle"

    static const int kU32ListHandle = 0;

    /**
     * Clears the field "u32ListHandle".
     *
     * The field will be set to its default value. The hasU32ListHandle()
     * method will return false.
     */
    inline void clearU32ListHandle();

    /**
     * Checks whether the field "u32ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListHandle()). Otherwise it will return false.
     */
    inline bool hasU32ListHandle () const;

    /**
     * Returns the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer. The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @return The value of the field "u32ListHandle"
     */
    inline uint32 getU32ListHandle () const;

    /**
     * Sets the value of the member "u32ListHandle".
     *
     * The unique handle of a list stored by the MediaPlayer. The handle is valid until ReleaseMediaPlayerList is called with this handle.
     *
     * @param u32ListHandle The value which will be set
     */
    inline void setU32ListHandle (uint32 u32ListHandle_);

    // API of field "u32Tag"

    static const int kU32Tag = 1;

    /**
     * Clears the field "u32Tag".
     *
     * The field will be set to its default value. The hasU32Tag()
     * method will return false.
     */
    inline void clearU32Tag();

    /**
     * Checks whether the field "u32Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Tag()). Otherwise it will return false.
     */
    inline bool hasU32Tag () const;

    /**
     * Returns the value of the member "u32Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value
     * identifies the media object to play.
     *
     * @return The value of the field "u32Tag"
     */
    inline uint32 getU32Tag () const;

    /**
     * Sets the value of the member "u32Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value
     * identifies the media object to play.
     *
     * @param u32Tag The value which will be set
     */
    inline void setU32Tag (uint32 u32Tag_);

    static const PlayItemFromListByTagStart &getDefaultInstance();

private:

    inline void set_has_u32ListHandle ();

    inline void clear_has_u32ListHandle ();

    inline void set_has_u32Tag ();

    inline void clear_has_u32Tag ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ListHandle;

    uint32 _u32Tag;

};

/**
 * The start message of the method "PlaybackSpeedSet"
 * Sets the playback speed for the currently playing media file.
 */
class PlaybackSpeedSetStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlaybackSpeedSetStart ();

    /**
     * Copy constructor
     */
    inline  PlaybackSpeedSetStart (const PlaybackSpeedSetStart &rhs);

    /**
     * All fields constructor
     */
    inline  PlaybackSpeedSetStart (::MPlay_fi_types::T_e8_MPlaybackDirection e8PlaybackDirection_, ::MPlay_fi_types::T_e8_MPlaybackSpeed e8PlaybackSpeed_);

    /**
     * Destructor
     */
    inline virtual  ~PlaybackSpeedSetStart();

    /**
     * Assignment operator
     */
    inline PlaybackSpeedSetStart& operator = (const PlaybackSpeedSetStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlaybackSpeedSetStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlaybackSpeedSetStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlaybackSpeedSetStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlaybackSpeedSetStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PlaybackDirection"

    static const int kE8PlaybackDirection = 0;

    /**
     * Clears the field "e8PlaybackDirection".
     *
     * The field will be set to its default value. The hasE8PlaybackDirection()
     * method will return false.
     */
    inline void clearE8PlaybackDirection();

    /**
     * Checks whether the field "e8PlaybackDirection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackDirection()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackDirection () const;

    /**
     * Returns the value of the member "e8PlaybackDirection".
     *
     * Specifies the direction of playback speed setting.
     *
     * @return The value of the field "e8PlaybackDirection"
     */
    inline ::MPlay_fi_types::T_e8_MPlaybackDirection getE8PlaybackDirection () const;

    /**
     * Sets the value of the member "e8PlaybackDirection".
     *
     * Specifies the direction of playback speed setting.
     *
     * @param e8PlaybackDirection The value which will be set
     */
    inline void setE8PlaybackDirection (::MPlay_fi_types::T_e8_MPlaybackDirection e8PlaybackDirection_);

    // API of field "e8PlaybackSpeed"

    static const int kE8PlaybackSpeed = 1;

    /**
     * Clears the field "e8PlaybackSpeed".
     *
     * The field will be set to its default value. The hasE8PlaybackSpeed()
     * method will return false.
     */
    inline void clearE8PlaybackSpeed();

    /**
     * Checks whether the field "e8PlaybackSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackSpeed()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackSpeed () const;

    /**
     * Returns the value of the member "e8PlaybackSpeed".
     *
     * Playback Speed value
     *
     * @return The value of the field "e8PlaybackSpeed"
     */
    inline ::MPlay_fi_types::T_e8_MPlaybackSpeed getE8PlaybackSpeed () const;

    /**
     * Sets the value of the member "e8PlaybackSpeed".
     *
     * Playback Speed value
     *
     * @param e8PlaybackSpeed The value which will be set
     */
    inline void setE8PlaybackSpeed (::MPlay_fi_types::T_e8_MPlaybackSpeed e8PlaybackSpeed_);

    static const PlaybackSpeedSetStart &getDefaultInstance();

private:

    inline void set_has_e8PlaybackDirection ();

    inline void clear_has_e8PlaybackDirection ();

    inline void set_has_e8PlaybackSpeed ();

    inline void clear_has_e8PlaybackSpeed ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlaybackDirection _e8PlaybackDirection;

    ::MPlay_fi_types::T_e8_MPlaybackSpeed _e8PlaybackSpeed;

};

/**
 * The result message of the method "PlaybackSpeedSet"
 * Sets the playback speed for the currently playing media file.
 */
class PlaybackSpeedSetResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlaybackSpeedSetResult ();

    /**
     * Copy constructor
     */
    inline  PlaybackSpeedSetResult (const PlaybackSpeedSetResult &rhs);

    /**
     * All fields constructor
     */
    inline  PlaybackSpeedSetResult (::MPlay_fi_types::T_e8_MPlaybackDirection e8PlaybackDirection_, ::MPlay_fi_types::T_e8_MPlaybackSpeed e8PlaybackSpeed_);

    /**
     * Destructor
     */
    inline virtual  ~PlaybackSpeedSetResult();

    /**
     * Assignment operator
     */
    inline PlaybackSpeedSetResult& operator = (const PlaybackSpeedSetResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlaybackSpeedSetResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlaybackSpeedSetResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlaybackSpeedSetResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlaybackSpeedSetResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PlaybackDirection"

    static const int kE8PlaybackDirection = 0;

    /**
     * Clears the field "e8PlaybackDirection".
     *
     * The field will be set to its default value. The hasE8PlaybackDirection()
     * method will return false.
     */
    inline void clearE8PlaybackDirection();

    /**
     * Checks whether the field "e8PlaybackDirection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackDirection()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackDirection () const;

    /**
     * Returns the value of the member "e8PlaybackDirection".
     *
     * Specifies the direction of playback speed setting.
     *
     * @return The value of the field "e8PlaybackDirection"
     */
    inline ::MPlay_fi_types::T_e8_MPlaybackDirection getE8PlaybackDirection () const;

    /**
     * Sets the value of the member "e8PlaybackDirection".
     *
     * Specifies the direction of playback speed setting.
     *
     * @param e8PlaybackDirection The value which will be set
     */
    inline void setE8PlaybackDirection (::MPlay_fi_types::T_e8_MPlaybackDirection e8PlaybackDirection_);

    // API of field "e8PlaybackSpeed"

    static const int kE8PlaybackSpeed = 1;

    /**
     * Clears the field "e8PlaybackSpeed".
     *
     * The field will be set to its default value. The hasE8PlaybackSpeed()
     * method will return false.
     */
    inline void clearE8PlaybackSpeed();

    /**
     * Checks whether the field "e8PlaybackSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackSpeed()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackSpeed () const;

    /**
     * Returns the value of the member "e8PlaybackSpeed".
     *
     * Playback Speed value
     *
     * @return The value of the field "e8PlaybackSpeed"
     */
    inline ::MPlay_fi_types::T_e8_MPlaybackSpeed getE8PlaybackSpeed () const;

    /**
     * Sets the value of the member "e8PlaybackSpeed".
     *
     * Playback Speed value
     *
     * @param e8PlaybackSpeed The value which will be set
     */
    inline void setE8PlaybackSpeed (::MPlay_fi_types::T_e8_MPlaybackSpeed e8PlaybackSpeed_);

    static const PlaybackSpeedSetResult &getDefaultInstance();

private:

    inline void set_has_e8PlaybackDirection ();

    inline void clear_has_e8PlaybackDirection ();

    inline void set_has_e8PlaybackSpeed ();

    inline void clear_has_e8PlaybackSpeed ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::MPlay_fi_types::T_e8_MPlaybackDirection _e8PlaybackDirection;

    ::MPlay_fi_types::T_e8_MPlaybackSpeed _e8PlaybackSpeed;

};

/**
 * The start message of the method "ClearLastModePause"
 * On receiving this request,When the device(of given u8DeviceTag) is activated,playback is resumed irrespective of its lastmode pause.
 * This need to be invoked by Speech ONLY when it wants to activate a Device and NOT when it wants mediaplayer to play user uttered MediaItem.
 */
class ClearLastModePauseStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearLastModePauseStart ();

    /**
     * Copy constructor
     */
    inline  ClearLastModePauseStart (const ClearLastModePauseStart &rhs);

    /**
     * All fields constructor
     */
    inline  ClearLastModePauseStart (uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~ClearLastModePauseStart();

    /**
     * Assignment operator
     */
    inline ClearLastModePauseStart& operator = (const ClearLastModePauseStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearLastModePauseStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearLastModePauseStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearLastModePauseStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearLastModePauseStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     * Actual physical devices are numbered starting with DeviceTag=0x01.
     * DeviceTag of 0x00 is reserved as a virtual "My Media" device representing
     * aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const ClearLastModePauseStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceTag;

};

/**
 * The start message of the method "RequestDiscOperation"
 * Sends the command to perform disc operations like loading and ejecting
 * Load
 * Eject
 */
class RequestDiscOperationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDiscOperationStart ();

    /**
     * Copy constructor
     */
    inline  RequestDiscOperationStart (const RequestDiscOperationStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDiscOperationStart (::MPlay_fi_types::T_e8_MDiscOperation e8DiscOperation_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDiscOperationStart();

    /**
     * Assignment operator
     */
    inline RequestDiscOperationStart& operator = (const RequestDiscOperationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDiscOperationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDiscOperationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDiscOperationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDiscOperationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DiscOperation"

    static const int kE8DiscOperation = 0;

    /**
     * Clears the field "e8DiscOperation".
     *
     * The field will be set to its default value. The hasE8DiscOperation()
     * method will return false.
     */
    inline void clearE8DiscOperation();

    /**
     * Checks whether the field "e8DiscOperation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiscOperation()). Otherwise it will return false.
     */
    inline bool hasE8DiscOperation () const;

    /**
     * Returns the value of the member "e8DiscOperation".
     *
     * Specifies the operation to do(Load  or Eject )
     *
     * @return The value of the field "e8DiscOperation"
     */
    inline ::MPlay_fi_types::T_e8_MDiscOperation getE8DiscOperation () const;

    /**
     * Sets the value of the member "e8DiscOperation".
     *
     * Specifies the operation to do(Load  or Eject )
     *
     * @param e8DiscOperation The value which will be set
     */
    inline void setE8DiscOperation (::MPlay_fi_types::T_e8_MDiscOperation e8DiscOperation_);

    static const RequestDiscOperationStart &getDefaultInstance();

private:

    inline void set_has_e8DiscOperation ();

    inline void clear_has_e8DiscOperation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MDiscOperation _e8DiscOperation;

};

/**
 * The start message of the method "RequestVCDAudioChannel"
 * Requests the audio channel mode change
 * For non SVCD there will not be 2 channels so channel 1 is taken as default audio channel mode
 * Which includes
 * Channel 1 Stereo
 * Channel 1 LL
 * Channel 1 RR
 * Channel 1 Mono
 * Channel 2 Stereo
 * Channel 2 LL
 * Channel 2 RR
 * Channel 2 Mono
 */
class RequestVCDAudioChannelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestVCDAudioChannelStart ();

    /**
     * Copy constructor
     */
    inline  RequestVCDAudioChannelStart (const RequestVCDAudioChannelStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestVCDAudioChannelStart (::MPlay_fi_types::T_e8_MGeneralSelectionType e8SelectionType_, ::MPlay_fi_types::T_e8_MVCDAudioMode e8AudioMode_);

    /**
     * Destructor
     */
    inline virtual  ~RequestVCDAudioChannelStart();

    /**
     * Assignment operator
     */
    inline RequestVCDAudioChannelStart& operator = (const RequestVCDAudioChannelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestVCDAudioChannelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestVCDAudioChannelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestVCDAudioChannelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestVCDAudioChannelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SelectionType"

    static const int kE8SelectionType = 0;

    /**
     * Clears the field "e8SelectionType".
     *
     * The field will be set to its default value. The hasE8SelectionType()
     * method will return false.
     */
    inline void clearE8SelectionType();

    /**
     * Checks whether the field "e8SelectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SelectionType()). Otherwise it will return false.
     */
    inline bool hasE8SelectionType () const;

    /**
     * Returns the value of the member "e8SelectionType".
     *
     * Specifies the audio selection type, cyclic, reverse cyclic, direct
     *
     * @return The value of the field "e8SelectionType"
     */
    inline ::MPlay_fi_types::T_e8_MGeneralSelectionType getE8SelectionType () const;

    /**
     * Sets the value of the member "e8SelectionType".
     *
     * Specifies the audio selection type, cyclic, reverse cyclic, direct
     *
     * @param e8SelectionType The value which will be set
     */
    inline void setE8SelectionType (::MPlay_fi_types::T_e8_MGeneralSelectionType e8SelectionType_);

    // API of field "e8AudioMode"

    static const int kE8AudioMode = 1;

    /**
     * Clears the field "e8AudioMode".
     *
     * The field will be set to its default value. The hasE8AudioMode()
     * method will return false.
     */
    inline void clearE8AudioMode();

    /**
     * Checks whether the field "e8AudioMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AudioMode()). Otherwise it will return false.
     */
    inline bool hasE8AudioMode () const;

    /**
     * Returns the value of the member "e8AudioMode".
     *
     * Specifies the display mode request.
     *
     * @return The value of the field "e8AudioMode"
     */
    inline ::MPlay_fi_types::T_e8_MVCDAudioMode getE8AudioMode () const;

    /**
     * Sets the value of the member "e8AudioMode".
     *
     * Specifies the display mode request.
     *
     * @param e8AudioMode The value which will be set
     */
    inline void setE8AudioMode (::MPlay_fi_types::T_e8_MVCDAudioMode e8AudioMode_);

    static const RequestVCDAudioChannelStart &getDefaultInstance();

private:

    inline void set_has_e8SelectionType ();

    inline void clear_has_e8SelectionType ();

    inline void set_has_e8AudioMode ();

    inline void clear_has_e8AudioMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::MPlay_fi_types::T_e8_MGeneralSelectionType _e8SelectionType;

    ::MPlay_fi_types::T_e8_MVCDAudioMode _e8AudioMode;

};

/**
 * The start message of the method "RequestDVDAudioChannel"
 * Requests the DVD audio number change, It varies from 1-8.
 */
class RequestDVDAudioChannelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDVDAudioChannelStart ();

    /**
     * Copy constructor
     */
    inline  RequestDVDAudioChannelStart (const RequestDVDAudioChannelStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDVDAudioChannelStart (::MPlay_fi_types::T_e8_MGeneralSelectionType e8SelectionType_, ::MPlay_fi_types::T_e8_MAudioOutputNumber e8AudioNumber_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDVDAudioChannelStart();

    /**
     * Assignment operator
     */
    inline RequestDVDAudioChannelStart& operator = (const RequestDVDAudioChannelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDVDAudioChannelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDVDAudioChannelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDVDAudioChannelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDVDAudioChannelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SelectionType"

    static const int kE8SelectionType = 0;

    /**
     * Clears the field "e8SelectionType".
     *
     * The field will be set to its default value. The hasE8SelectionType()
     * method will return false.
     */
    inline void clearE8SelectionType();

    /**
     * Checks whether the field "e8SelectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SelectionType()). Otherwise it will return false.
     */
    inline bool hasE8SelectionType () const;

    /**
     * Returns the value of the member "e8SelectionType".
     *
     * Specifies the audio selection type, cyclic, reverse cyclic, direct
     *
     * @return The value of the field "e8SelectionType"
     */
    inline ::MPlay_fi_types::T_e8_MGeneralSelectionType getE8SelectionType () const;

    /**
     * Sets the value of the member "e8SelectionType".
     *
     * Specifies the audio selection type, cyclic, reverse cyclic, direct
     *
     * @param e8SelectionType The value which will be set
     */
    inline void setE8SelectionType (::MPlay_fi_types::T_e8_MGeneralSelectionType e8SelectionType_);

    // API of field "e8AudioNumber"

    static const int kE8AudioNumber = 1;

    /**
     * Clears the field "e8AudioNumber".
     *
     * The field will be set to its default value. The hasE8AudioNumber()
     * method will return false.
     */
    inline void clearE8AudioNumber();

    /**
     * Checks whether the field "e8AudioNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AudioNumber()). Otherwise it will return false.
     */
    inline bool hasE8AudioNumber () const;

    /**
     * Returns the value of the member "e8AudioNumber".
     *
     * Specifies the audio output request.
     *
     * @return The value of the field "e8AudioNumber"
     */
    inline ::MPlay_fi_types::T_e8_MAudioOutputNumber getE8AudioNumber () const;

    /**
     * Sets the value of the member "e8AudioNumber".
     *
     * Specifies the audio output request.
     *
     * @param e8AudioNumber The value which will be set
     */
    inline void setE8AudioNumber (::MPlay_fi_types::T_e8_MAudioOutputNumber e8AudioNumber_);

    static const RequestDVDAudioChannelStart &getDefaultInstance();

private:

    inline void set_has_e8SelectionType ();

    inline void clear_has_e8SelectionType ();

    inline void set_has_e8AudioNumber ();

    inline void clear_has_e8AudioNumber ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::MPlay_fi_types::T_e8_MGeneralSelectionType _e8SelectionType;

    ::MPlay_fi_types::T_e8_MAudioOutputNumber _e8AudioNumber;

};

/**
 * The start message of the method "SendNavigationKey"
 * Sends the command to navigate which includes
 * UPPER
 * LOWER
 * LEFT
 * RIGHT
 * ENTER
 * RETURN
 */
class SendNavigationKeyStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendNavigationKeyStart ();

    /**
     * Copy constructor
     */
    inline  SendNavigationKeyStart (const SendNavigationKeyStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendNavigationKeyStart (::MPlay_fi_types::T_e8_MNavigationKey e8Action_);

    /**
     * Destructor
     */
    inline virtual  ~SendNavigationKeyStart();

    /**
     * Assignment operator
     */
    inline SendNavigationKeyStart& operator = (const SendNavigationKeyStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendNavigationKeyStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendNavigationKeyStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendNavigationKeyStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendNavigationKeyStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Action"

    static const int kE8Action = 0;

    /**
     * Clears the field "e8Action".
     *
     * The field will be set to its default value. The hasE8Action()
     * method will return false.
     */
    inline void clearE8Action();

    /**
     * Checks whether the field "e8Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Action()). Otherwise it will return false.
     */
    inline bool hasE8Action () const;

    /**
     * Returns the value of the member "e8Action".
     *
     * Specifies the navigation cursor request.
     *
     * @return The value of the field "e8Action"
     */
    inline ::MPlay_fi_types::T_e8_MNavigationKey getE8Action () const;

    /**
     * Sets the value of the member "e8Action".
     *
     * Specifies the navigation cursor request.
     *
     * @param e8Action The value which will be set
     */
    inline void setE8Action (::MPlay_fi_types::T_e8_MNavigationKey e8Action_);

    static const SendNavigationKeyStart &getDefaultInstance();

private:

    inline void set_has_e8Action ();

    inline void clear_has_e8Action ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MNavigationKey _e8Action;

};

/**
 * The start message of the method "SendTouchCommand"
 * Sends the command to navigate when it is a direct touch
 */
class SendTouchCommandStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendTouchCommandStart ();

    /**
     * Copy constructor
     */
    inline  SendTouchCommandStart (const SendTouchCommandStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendTouchCommandStart (::MPlay_fi_types::T_e8_MTouchAction e8TouchAction_, uint16 u16Xcoordinate_, uint16 u16Ycoordinate_, uint16 u16MaxXcoordinate_, uint16 u16MaxYcoordinate_);

    /**
     * Destructor
     */
    inline virtual  ~SendTouchCommandStart();

    /**
     * Assignment operator
     */
    inline SendTouchCommandStart& operator = (const SendTouchCommandStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendTouchCommandStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendTouchCommandStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendTouchCommandStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendTouchCommandStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8TouchAction"

    static const int kE8TouchAction = 0;

    /**
     * Clears the field "e8TouchAction".
     *
     * The field will be set to its default value. The hasE8TouchAction()
     * method will return false.
     */
    inline void clearE8TouchAction();

    /**
     * Checks whether the field "e8TouchAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TouchAction()). Otherwise it will return false.
     */
    inline bool hasE8TouchAction () const;

    /**
     * Returns the value of the member "e8TouchAction".
     *
     * Specifies the touch action Touch ON / Touch OFF. It denotes whether the touch is on hold or released
     *
     * @return The value of the field "e8TouchAction"
     */
    inline ::MPlay_fi_types::T_e8_MTouchAction getE8TouchAction () const;

    /**
     * Sets the value of the member "e8TouchAction".
     *
     * Specifies the touch action Touch ON / Touch OFF. It denotes whether the touch is on hold or released
     *
     * @param e8TouchAction The value which will be set
     */
    inline void setE8TouchAction (::MPlay_fi_types::T_e8_MTouchAction e8TouchAction_);

    // API of field "u16Xcoordinate"

    static const int kU16Xcoordinate = 1;

    /**
     * Clears the field "u16Xcoordinate".
     *
     * The field will be set to its default value. The hasU16Xcoordinate()
     * method will return false.
     */
    inline void clearU16Xcoordinate();

    /**
     * Checks whether the field "u16Xcoordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Xcoordinate()). Otherwise it will return false.
     */
    inline bool hasU16Xcoordinate () const;

    /**
     * Returns the value of the member "u16Xcoordinate".
     *
     * Specifies the horizontal X co-ordinates 0-FFFF. 0 indicates the leftmost corner
     *
     * @return The value of the field "u16Xcoordinate"
     */
    inline uint16 getU16Xcoordinate () const;

    /**
     * Sets the value of the member "u16Xcoordinate".
     *
     * Specifies the horizontal X co-ordinates 0-FFFF. 0 indicates the leftmost corner
     *
     * @param u16Xcoordinate The value which will be set
     */
    inline void setU16Xcoordinate (uint16 u16Xcoordinate_);

    // API of field "u16Ycoordinate"

    static const int kU16Ycoordinate = 2;

    /**
     * Clears the field "u16Ycoordinate".
     *
     * The field will be set to its default value. The hasU16Ycoordinate()
     * method will return false.
     */
    inline void clearU16Ycoordinate();

    /**
     * Checks whether the field "u16Ycoordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Ycoordinate()). Otherwise it will return false.
     */
    inline bool hasU16Ycoordinate () const;

    /**
     * Returns the value of the member "u16Ycoordinate".
     *
     * Specifies the horizontal Y co-ordinates 0-FFFF. 0 indicates the leftmost corner
     *
     * @return The value of the field "u16Ycoordinate"
     */
    inline uint16 getU16Ycoordinate () const;

    /**
     * Sets the value of the member "u16Ycoordinate".
     *
     * Specifies the horizontal Y co-ordinates 0-FFFF. 0 indicates the leftmost corner
     *
     * @param u16Ycoordinate The value which will be set
     */
    inline void setU16Ycoordinate (uint16 u16Ycoordinate_);

    // API of field "u16MaxXcoordinate"

    static const int kU16MaxXcoordinate = 3;

    /**
     * Clears the field "u16MaxXcoordinate".
     *
     * The field will be set to its default value. The hasU16MaxXcoordinate()
     * method will return false.
     */
    inline void clearU16MaxXcoordinate();

    /**
     * Checks whether the field "u16MaxXcoordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MaxXcoordinate()). Otherwise it will return false.
     */
    inline bool hasU16MaxXcoordinate () const;

    /**
     * Returns the value of the member "u16MaxXcoordinate".
     *
     * Specifies the maximum horizontal X co-ordinates  supported on screen
     *
     * @return The value of the field "u16MaxXcoordinate"
     */
    inline uint16 getU16MaxXcoordinate () const;

    /**
     * Sets the value of the member "u16MaxXcoordinate".
     *
     * Specifies the maximum horizontal X co-ordinates  supported on screen
     *
     * @param u16MaxXcoordinate The value which will be set
     */
    inline void setU16MaxXcoordinate (uint16 u16MaxXcoordinate_);

    // API of field "u16MaxYcoordinate"

    static const int kU16MaxYcoordinate = 4;

    /**
     * Clears the field "u16MaxYcoordinate".
     *
     * The field will be set to its default value. The hasU16MaxYcoordinate()
     * method will return false.
     */
    inline void clearU16MaxYcoordinate();

    /**
     * Checks whether the field "u16MaxYcoordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MaxYcoordinate()). Otherwise it will return false.
     */
    inline bool hasU16MaxYcoordinate () const;

    /**
     * Returns the value of the member "u16MaxYcoordinate".
     *
     * Specifies the maximum horizontal Y co-ordinates  supported on screen
     *
     * @return The value of the field "u16MaxYcoordinate"
     */
    inline uint16 getU16MaxYcoordinate () const;

    /**
     * Sets the value of the member "u16MaxYcoordinate".
     *
     * Specifies the maximum horizontal Y co-ordinates  supported on screen
     *
     * @param u16MaxYcoordinate The value which will be set
     */
    inline void setU16MaxYcoordinate (uint16 u16MaxYcoordinate_);

    static const SendTouchCommandStart &getDefaultInstance();

private:

    inline void set_has_e8TouchAction ();

    inline void clear_has_e8TouchAction ();

    inline void set_has_u16Xcoordinate ();

    inline void clear_has_u16Xcoordinate ();

    inline void set_has_u16Ycoordinate ();

    inline void clear_has_u16Ycoordinate ();

    inline void set_has_u16MaxXcoordinate ();

    inline void clear_has_u16MaxXcoordinate ();

    inline void set_has_u16MaxYcoordinate ();

    inline void clear_has_u16MaxYcoordinate ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::MPlay_fi_types::T_e8_MTouchAction _e8TouchAction;

    uint16 _u16Xcoordinate;

    uint16 _u16Ycoordinate;

    uint16 _u16MaxXcoordinate;

    uint16 _u16MaxYcoordinate;

};

/**
 * The start message of the method "RequestDirectSearch"
 * Sends the command to Search the correct track/ chapter or file number.
 * It works only for DVD Disc Type – D, F, G and data disc
 */
class RequestDirectSearchStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDirectSearchStart ();

    /**
     * Copy constructor
     */
    inline  RequestDirectSearchStart (const RequestDirectSearchStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDirectSearchStart (uint32 TitleNumber_, uint32 ChapterNumber_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDirectSearchStart();

    /**
     * Assignment operator
     */
    inline RequestDirectSearchStart& operator = (const RequestDirectSearchStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDirectSearchStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDirectSearchStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDirectSearchStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDirectSearchStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TitleNumber"

    static const int kTitleNumber = 0;

    /**
     * Clears the field "TitleNumber".
     *
     * The field will be set to its default value. The hasTitleNumber()
     * method will return false.
     */
    inline void clearTitleNumber();

    /**
     * Checks whether the field "TitleNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTitleNumber()). Otherwise it will return false.
     */
    inline bool hasTitleNumber () const;

    /**
     * Returns the value of the member "TitleNumber".
     *
     * Specifies the Title Number(Type D and G)/Group Number (Type F) /Folder Number(Type E)
     *
     * @return The value of the field "TitleNumber"
     */
    inline uint32 getTitleNumber () const;

    /**
     * Sets the value of the member "TitleNumber".
     *
     * Specifies the Title Number(Type D and G)/Group Number (Type F) /Folder Number(Type E)
     *
     * @param TitleNumber The value which will be set
     */
    inline void setTitleNumber (uint32 TitleNumber_);

    // API of field "ChapterNumber"

    static const int kChapterNumber = 1;

    /**
     * Clears the field "ChapterNumber".
     *
     * The field will be set to its default value. The hasChapterNumber()
     * method will return false.
     */
    inline void clearChapterNumber();

    /**
     * Checks whether the field "ChapterNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChapterNumber()). Otherwise it will return false.
     */
    inline bool hasChapterNumber () const;

    /**
     * Returns the value of the member "ChapterNumber".
     *
     * Specifies the Chapter Number(Type D,G)/Track Number (Type F) /File Number(Type E)
     *
     * @return The value of the field "ChapterNumber"
     */
    inline uint32 getChapterNumber () const;

    /**
     * Sets the value of the member "ChapterNumber".
     *
     * Specifies the Chapter Number(Type D,G)/Track Number (Type F) /File Number(Type E)
     *
     * @param ChapterNumber The value which will be set
     */
    inline void setChapterNumber (uint32 ChapterNumber_);

    static const RequestDirectSearchStart &getDefaultInstance();

private:

    inline void set_has_TitleNumber ();

    inline void clear_has_TitleNumber ();

    inline void set_has_ChapterNumber ();

    inline void clear_has_ChapterNumber ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _TitleNumber;

    uint32 _ChapterNumber;

};

/**
 * The start message of the method "RequestAngleChange"
 * Sends the command to Specify the angle to use. Applicable only for DVD-Video and DVD Audio. Angle varies from 1 to 9.
 */
class RequestAngleChangeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestAngleChangeStart ();

    /**
     * Copy constructor
     */
    inline  RequestAngleChangeStart (const RequestAngleChangeStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestAngleChangeStart (::MPlay_fi_types::T_e8_MGeneralSelectionType e8SelectionType_, ::MPlay_fi_types::T_e8_MAngle e8Angle_);

    /**
     * Destructor
     */
    inline virtual  ~RequestAngleChangeStart();

    /**
     * Assignment operator
     */
    inline RequestAngleChangeStart& operator = (const RequestAngleChangeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAngleChangeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAngleChangeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAngleChangeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAngleChangeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SelectionType"

    static const int kE8SelectionType = 0;

    /**
     * Clears the field "e8SelectionType".
     *
     * The field will be set to its default value. The hasE8SelectionType()
     * method will return false.
     */
    inline void clearE8SelectionType();

    /**
     * Checks whether the field "e8SelectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SelectionType()). Otherwise it will return false.
     */
    inline bool hasE8SelectionType () const;

    /**
     * Returns the value of the member "e8SelectionType".
     *
     * Specifies the angle selection type, cyclic, reverse cyclic, direct
     *
     * @return The value of the field "e8SelectionType"
     */
    inline ::MPlay_fi_types::T_e8_MGeneralSelectionType getE8SelectionType () const;

    /**
     * Sets the value of the member "e8SelectionType".
     *
     * Specifies the angle selection type, cyclic, reverse cyclic, direct
     *
     * @param e8SelectionType The value which will be set
     */
    inline void setE8SelectionType (::MPlay_fi_types::T_e8_MGeneralSelectionType e8SelectionType_);

    // API of field "e8Angle"

    static const int kE8Angle = 1;

    /**
     * Clears the field "e8Angle".
     *
     * The field will be set to its default value. The hasE8Angle()
     * method will return false.
     */
    inline void clearE8Angle();

    /**
     * Checks whether the field "e8Angle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Angle()). Otherwise it will return false.
     */
    inline bool hasE8Angle () const;

    /**
     * Returns the value of the member "e8Angle".
     *
     * Specifies the angle to use.
     *
     * @return The value of the field "e8Angle"
     */
    inline ::MPlay_fi_types::T_e8_MAngle getE8Angle () const;

    /**
     * Sets the value of the member "e8Angle".
     *
     * Specifies the angle to use.
     *
     * @param e8Angle The value which will be set
     */
    inline void setE8Angle (::MPlay_fi_types::T_e8_MAngle e8Angle_);

    static const RequestAngleChangeStart &getDefaultInstance();

private:

    inline void set_has_e8SelectionType ();

    inline void clear_has_e8SelectionType ();

    inline void set_has_e8Angle ();

    inline void clear_has_e8Angle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::MPlay_fi_types::T_e8_MGeneralSelectionType _e8SelectionType;

    ::MPlay_fi_types::T_e8_MAngle _e8Angle;

};

/**
 * The start message of the method "SetMenuPlayBackControl"
 * Sends the command to do menu playback operations.
 * Not applicable for CD Audio -Type A and data disc -Type E.
 * In VCD (Type B and Type C) Top Menu is invalid and Menu command is used for playback control ON\OFF and media type change at the same time.
 * In DVD-VR (Type G) Top Menu is invalid and Menu command is used for playlist mode ON\OFF.
 * In DVD Audio, if Top menu (AMGM) is present playback happens else it becomes invalid or returns to group play mode. Menu is invalid.
 * In DVD Video, if Top menu (VMGM) is present playback happens else it becomes invalid or returns to title play mode. If Menu (VTSM) is present playback happens else it becomes invalid or returns to title play mode.
 */
class SetMenuPlayBackControlStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMenuPlayBackControlStart ();

    /**
     * Copy constructor
     */
    inline  SetMenuPlayBackControlStart (const SetMenuPlayBackControlStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetMenuPlayBackControlStart (::MPlay_fi_types::T_e8_MMenuControlData e8MenuControlData_);

    /**
     * Destructor
     */
    inline virtual  ~SetMenuPlayBackControlStart();

    /**
     * Assignment operator
     */
    inline SetMenuPlayBackControlStart& operator = (const SetMenuPlayBackControlStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMenuPlayBackControlStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMenuPlayBackControlStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMenuPlayBackControlStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMenuPlayBackControlStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MenuControlData"

    static const int kE8MenuControlData = 0;

    /**
     * Clears the field "e8MenuControlData".
     *
     * The field will be set to its default value. The hasE8MenuControlData()
     * method will return false.
     */
    inline void clearE8MenuControlData();

    /**
     * Checks whether the field "e8MenuControlData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MenuControlData()). Otherwise it will return false.
     */
    inline bool hasE8MenuControlData () const;

    /**
     * Returns the value of the member "e8MenuControlData".
     *
     * Specifies the menu control data. Top menu is 0 and sub menu is 1.
     *
     * @return The value of the field "e8MenuControlData"
     */
    inline ::MPlay_fi_types::T_e8_MMenuControlData getE8MenuControlData () const;

    /**
     * Sets the value of the member "e8MenuControlData".
     *
     * Specifies the menu control data. Top menu is 0 and sub menu is 1.
     *
     * @param e8MenuControlData The value which will be set
     */
    inline void setE8MenuControlData (::MPlay_fi_types::T_e8_MMenuControlData e8MenuControlData_);

    static const SetMenuPlayBackControlStart &getDefaultInstance();

private:

    inline void set_has_e8MenuControlData ();

    inline void clear_has_e8MenuControlData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MMenuControlData _e8MenuControlData;

};

/**
 * The start message of the method "SelectDirectNumber"
 * Sends the command to perfrorm direct number selection in Internal DVD
 * Supported only in Video CD v2.0 (Type C) for direct selection of the number specified as parameter
 * and In DVD Audio (Type D) and DVD Video (Type F) for selecting the button equivalent to the number.
 * DirectSelectAvailable property will be set true if this operation is permitted by the current playing disc.
 */
class SelectDirectNumberStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectDirectNumberStart ();

    /**
     * Copy constructor
     */
    inline  SelectDirectNumberStart (const SelectDirectNumberStart &rhs);

    /**
     * All fields constructor
     */
    inline  SelectDirectNumberStart (uint32 u32Number_);

    /**
     * Destructor
     */
    inline virtual  ~SelectDirectNumberStart();

    /**
     * Assignment operator
     */
    inline SelectDirectNumberStart& operator = (const SelectDirectNumberStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectDirectNumberStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectDirectNumberStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectDirectNumberStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectDirectNumberStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Number"

    static const int kU32Number = 0;

    /**
     * Clears the field "u32Number".
     *
     * The field will be set to its default value. The hasU32Number()
     * method will return false.
     */
    inline void clearU32Number();

    /**
     * Checks whether the field "u32Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Number()). Otherwise it will return false.
     */
    inline bool hasU32Number () const;

    /**
     * Returns the value of the member "u32Number".
     *
     * Specifies the number to use. Ranges between 0 to 999
     *
     * @return The value of the field "u32Number"
     */
    inline uint32 getU32Number () const;

    /**
     * Sets the value of the member "u32Number".
     *
     * Specifies the number to use. Ranges between 0 to 999
     *
     * @param u32Number The value which will be set
     */
    inline void setU32Number (uint32 u32Number_);

    static const SelectDirectNumberStart &getDefaultInstance();

private:

    inline void set_has_u32Number ();

    inline void clear_has_u32Number ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Number;

};

/**
 * The start message of the method "RequestTitleSearch"
 * Sends the command to start play back from the first chapter or track from the specific position mentioned
 * Supported in DVD-VR (Type G) and DVD Audio (Type D) for title number(1-99)
 * DVD Video (Type F) for Group Number (0-9)
 * Data Disc for folder number(1-254)
 */
class RequestTitleSearchStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestTitleSearchStart ();

    /**
     * Copy constructor
     */
    inline  RequestTitleSearchStart (const RequestTitleSearchStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestTitleSearchStart (uint32 u32SearchNumber_);

    /**
     * Destructor
     */
    inline virtual  ~RequestTitleSearchStart();

    /**
     * Assignment operator
     */
    inline RequestTitleSearchStart& operator = (const RequestTitleSearchStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestTitleSearchStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestTitleSearchStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestTitleSearchStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestTitleSearchStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32SearchNumber"

    static const int kU32SearchNumber = 0;

    /**
     * Clears the field "u32SearchNumber".
     *
     * The field will be set to its default value. The hasU32SearchNumber()
     * method will return false.
     */
    inline void clearU32SearchNumber();

    /**
     * Checks whether the field "u32SearchNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SearchNumber()). Otherwise it will return false.
     */
    inline bool hasU32SearchNumber () const;

    /**
     * Returns the value of the member "u32SearchNumber".
     *
     * Specifies the  number to search
     *
     * @return The value of the field "u32SearchNumber"
     */
    inline uint32 getU32SearchNumber () const;

    /**
     * Sets the value of the member "u32SearchNumber".
     *
     * Specifies the  number to search
     *
     * @param u32SearchNumber The value which will be set
     */
    inline void setU32SearchNumber (uint32 u32SearchNumber_);

    static const RequestTitleSearchStart &getDefaultInstance();

private:

    inline void set_has_u32SearchNumber ();

    inline void clear_has_u32SearchNumber ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32SearchNumber;

};

/**
 * The start message of the method "RequestSubtitleChange"
 * Sends the command to switch on/off subtitle, toggle between subtitles or directly select a subtitle
 */
class RequestSubtitleChangeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestSubtitleChangeStart ();

    /**
     * Copy constructor
     */
    inline  RequestSubtitleChangeStart (const RequestSubtitleChangeStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestSubtitleChangeStart (bool subtitleSwitchState_, ::MPlay_fi_types::T_e8_MSubtitleSelectionType e8SelectionType_, uint8 u8SubtitleSelection_);

    /**
     * Destructor
     */
    inline virtual  ~RequestSubtitleChangeStart();

    /**
     * Assignment operator
     */
    inline RequestSubtitleChangeStart& operator = (const RequestSubtitleChangeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSubtitleChangeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSubtitleChangeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSubtitleChangeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSubtitleChangeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "subtitleSwitchState"

    static const int kSubtitleSwitchState = 0;

    /**
     * Clears the field "subtitleSwitchState".
     *
     * The field will be set to its default value. The hasSubtitleSwitchState()
     * method will return false.
     */
    inline void clearSubtitleSwitchState();

    /**
     * Checks whether the field "subtitleSwitchState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubtitleSwitchState()). Otherwise it will return false.
     */
    inline bool hasSubtitleSwitchState () const;

    /**
     * Returns the value of the member "subtitleSwitchState".
     *
     * If true the subtitle status has to be toggled from ON to OFF or viceversa
     *
     * @return The value of the field "subtitleSwitchState"
     */
    inline bool getSubtitleSwitchState () const;

    /**
     * Sets the value of the member "subtitleSwitchState".
     *
     * If true the subtitle status has to be toggled from ON to OFF or viceversa
     *
     * @param subtitleSwitchState The value which will be set
     */
    inline void setSubtitleSwitchState (bool subtitleSwitchState_);

    // API of field "e8SelectionType"

    static const int kE8SelectionType = 1;

    /**
     * Clears the field "e8SelectionType".
     *
     * The field will be set to its default value. The hasE8SelectionType()
     * method will return false.
     */
    inline void clearE8SelectionType();

    /**
     * Checks whether the field "e8SelectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SelectionType()). Otherwise it will return false.
     */
    inline bool hasE8SelectionType () const;

    /**
     * Returns the value of the member "e8SelectionType".
     *
     * Specifies the subtitle selection type, cyclic with or without OFF, direct, reverse cyclic with or without OFF
     *
     * @return The value of the field "e8SelectionType"
     */
    inline ::MPlay_fi_types::T_e8_MSubtitleSelectionType getE8SelectionType () const;

    /**
     * Sets the value of the member "e8SelectionType".
     *
     * Specifies the subtitle selection type, cyclic with or without OFF, direct, reverse cyclic with or without OFF
     *
     * @param e8SelectionType The value which will be set
     */
    inline void setE8SelectionType (::MPlay_fi_types::T_e8_MSubtitleSelectionType e8SelectionType_);

    // API of field "u8SubtitleSelection"

    static const int kU8SubtitleSelection = 2;

    /**
     * Clears the field "u8SubtitleSelection".
     *
     * The field will be set to its default value. The hasU8SubtitleSelection()
     * method will return false.
     */
    inline void clearU8SubtitleSelection();

    /**
     * Checks whether the field "u8SubtitleSelection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SubtitleSelection()). Otherwise it will return false.
     */
    inline bool hasU8SubtitleSelection () const;

    /**
     * Returns the value of the member "u8SubtitleSelection".
     *
     * Specifies the  subtitle number to select , 1 to 32
     *
     * @return The value of the field "u8SubtitleSelection"
     */
    inline uint8 getU8SubtitleSelection () const;

    /**
     * Sets the value of the member "u8SubtitleSelection".
     *
     * Specifies the  subtitle number to select , 1 to 32
     *
     * @param u8SubtitleSelection The value which will be set
     */
    inline void setU8SubtitleSelection (uint8 u8SubtitleSelection_);

    static const RequestSubtitleChangeStart &getDefaultInstance();

private:

    inline void set_has_subtitleSwitchState ();

    inline void clear_has_subtitleSwitchState ();

    inline void set_has_e8SelectionType ();

    inline void clear_has_e8SelectionType ();

    inline void set_has_u8SubtitleSelection ();

    inline void clear_has_u8SubtitleSelection ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _subtitleSwitchState;

    ::MPlay_fi_types::T_e8_MSubtitleSelectionType _e8SelectionType;

    uint8 _u8SubtitleSelection;

};

/**
 * The start message of the method "RequestCMSkip"
 * Used as a skip functionality , we can some forward or backward at 15s , 30s and 45s while playing a video file.
 * This method will be supported if CMSkipAvailable property is true.
 */
class RequestCMSkipStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestCMSkipStart ();

    /**
     * Copy constructor
     */
    inline  RequestCMSkipStart (const RequestCMSkipStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestCMSkipStart (::MPlay_fi_types::T_e8_MCMSkipValue e8CMSkipValue_);

    /**
     * Destructor
     */
    inline virtual  ~RequestCMSkipStart();

    /**
     * Assignment operator
     */
    inline RequestCMSkipStart& operator = (const RequestCMSkipStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestCMSkipStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestCMSkipStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestCMSkipStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestCMSkipStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8CMSkipValue"

    static const int kE8CMSkipValue = 0;

    /**
     * Clears the field "e8CMSkipValue".
     *
     * The field will be set to its default value. The hasE8CMSkipValue()
     * method will return false.
     */
    inline void clearE8CMSkipValue();

    /**
     * Checks whether the field "e8CMSkipValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CMSkipValue()). Otherwise it will return false.
     */
    inline bool hasE8CMSkipValue () const;

    /**
     * Returns the value of the member "e8CMSkipValue".
     *
     * Specifies the Skip time and direction , applicable only for DVD Video
     *
     * @return The value of the field "e8CMSkipValue"
     */
    inline ::MPlay_fi_types::T_e8_MCMSkipValue getE8CMSkipValue () const;

    /**
     * Sets the value of the member "e8CMSkipValue".
     *
     * Specifies the Skip time and direction , applicable only for DVD Video
     *
     * @param e8CMSkipValue The value which will be set
     */
    inline void setE8CMSkipValue (::MPlay_fi_types::T_e8_MCMSkipValue e8CMSkipValue_);

    static const RequestCMSkipStart &getDefaultInstance();

private:

    inline void set_has_e8CMSkipValue ();

    inline void clear_has_e8CMSkipValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::MPlay_fi_types::T_e8_MCMSkipValue _e8CMSkipValue;

};

/**
 * The result message of the method "RequestDVDTemperature"
 * Requests the DVD Drive's current temperature
 */
class RequestDVDTemperatureResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDVDTemperatureResult ();

    /**
     * Copy constructor
     */
    inline  RequestDVDTemperatureResult (const RequestDVDTemperatureResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDVDTemperatureResult (uint16 u16Temperature_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDVDTemperatureResult();

    /**
     * Assignment operator
     */
    inline RequestDVDTemperatureResult& operator = (const RequestDVDTemperatureResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDVDTemperatureResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDVDTemperatureResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDVDTemperatureResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDVDTemperatureResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16Temperature"

    static const int kU16Temperature = 0;

    /**
     * Clears the field "u16Temperature".
     *
     * The field will be set to its default value. The hasU16Temperature()
     * method will return false.
     */
    inline void clearU16Temperature();

    /**
     * Checks whether the field "u16Temperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Temperature()). Otherwise it will return false.
     */
    inline bool hasU16Temperature () const;

    /**
     * Returns the value of the member "u16Temperature".
     *
     * Specifies the current temperature of the DVD Drive , Range -40.0 to +125.0 degree celsius
     * 0x0000 - 0x04E2 --> 0.0 to 125.0 degree celsius
     * 0x04E3 - 0x7FFF --> reserved
     * 0x8000 - 0xFE6F --> reserved
     * 0xFE70 - 0xFFFF --> -40.0 to -0.1 degree celsius
     *
     * @return The value of the field "u16Temperature"
     */
    inline uint16 getU16Temperature () const;

    /**
     * Sets the value of the member "u16Temperature".
     *
     * Specifies the current temperature of the DVD Drive , Range -40.0 to +125.0 degree celsius
     * 0x0000 - 0x04E2 --> 0.0 to 125.0 degree celsius
     * 0x04E3 - 0x7FFF --> reserved
     * 0x8000 - 0xFE6F --> reserved
     * 0xFE70 - 0xFFFF --> -40.0 to -0.1 degree celsius
     *
     * @param u16Temperature The value which will be set
     */
    inline void setU16Temperature (uint16 u16Temperature_);

    static const RequestDVDTemperatureResult &getDefaultInstance();

private:

    inline void set_has_u16Temperature ();

    inline void clear_has_u16Temperature ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16Temperature;

};

/**
 * The start message of the method "ReorderInternalPlaylist"
 * Function reorder an entry in an internal playlist.
 */
class ReorderInternalPlaylistStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReorderInternalPlaylistStart ();

    /**
     * Copy constructor
     */
    inline  ReorderInternalPlaylistStart (const ReorderInternalPlaylistStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReorderInternalPlaylistStart (const ::std::string& sPlaylistPath_, uint32 u32OldPosition_, uint32 u32NewPosition_, uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~ReorderInternalPlaylistStart();

    /**
     * Assignment operator
     */
    inline ReorderInternalPlaylistStart& operator = (const ReorderInternalPlaylistStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReorderInternalPlaylistStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReorderInternalPlaylistStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReorderInternalPlaylistStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReorderInternalPlaylistStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sPlaylistPath"

    static const int kSPlaylistPath = 0;

    /**
     * Clears the field "sPlaylistPath".
     *
     * The field will be set to its default value. The hasSPlaylistPath()
     * method will return false.
     */
    inline void clearSPlaylistPath();

    /**
     * Checks whether the field "sPlaylistPath" was set before.
     *
     * @return Returns true if the fi