/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "MPlay_fi_types.h"
#include "MPlay_fi_typesConst.h"
#include "MPlay_fi_typesJson.h"
#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_MInternalDVDLangSetting"

void serializeJson (const ::MPlay_fi_types::T_MInternalDVDLangSetting& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16AudioLanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "u16AudioLanguage" , 16);
        yajl_gen_integer(g, (long long)value.getU16AudioLanguage());
    }
    if (!isSparse || value.hasU16MenuLanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "u16MenuLanguage" , 15);
        yajl_gen_integer(g, (long long)value.getU16MenuLanguage());
    }
    if (!isSparse || value.hasU16SubtitleLanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "u16SubtitleLanguage" , 19);
        yajl_gen_integer(g, (long long)value.getU16SubtitleLanguage());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_MInternalDVDLangSetting& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MPlayDeviceInfoItem"

void serializeJson (const ::MPlay_fi_types::T_MPlayDeviceInfoItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DiscType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DiscType" , 10);
        const char* s = ::MPlay_fi_types::T_e8_MDiscType_Name(value.getE8DiscType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DiscType());
    }
    if (!isSparse || value.hasE8AvailabilityReason()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AvailabilityReason" , 20);
        const char* s = ::MPlay_fi_types::T_e8_MPlayAvailabilityReason_Name(value.getE8AvailabilityReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AvailabilityReason());
    }
    if (!isSparse || value.hasE8ConnectionState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ConnectionState" , 17);
        const char* s = ::MPlay_fi_types::T_e8_MPlayConnectionState_Name(value.getE8ConnectionState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ConnectionState());
    }
    if (!isSparse || value.hasE8ConnectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ConnectionType" , 16);
        const char* s = ::MPlay_fi_types::T_e8_MPlayConnectionType_Name(value.getE8ConnectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ConnectionType());
    }
    if (!isSparse || value.hasE8DeviceControlSupport()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DeviceControlSupport" , 22);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeviceControlSupport_Name(value.getE8DeviceControlSupport());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DeviceControlSupport());
    }
    if (!isSparse || value.hasE8DeviceIndexedState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DeviceIndexedState" , 20);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeviceIndexedState_Name(value.getE8DeviceIndexedState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DeviceIndexedState());
    }
    if (!isSparse || value.hasE8DeviceState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DeviceState" , 13);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeviceStatus_Name(value.getE8DeviceState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DeviceState());
    }
    if (!isSparse || value.hasE8DeviceType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DeviceType" , 12);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeviceType_Name(value.getE8DeviceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DeviceType());
    }
    if (!isSparse || value.hasE8DisconnectReason()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DisconnectReason" , 18);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDisconnectReason_Name(value.getE8DisconnectReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DisconnectReason());
    }
    if (!isSparse || value.hasE8FileSystemType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8FileSystemType" , 16);
        const char* s = ::MPlay_fi_types::T_e8_MPlayFileSystemType_Name(value.getE8FileSystemType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8FileSystemType());
    }
    if (!isSparse || value.hasBDeviceActiveSource()) {
        yajl_gen_string(g, (const unsigned char*)  "bDeviceActiveSource" , 19);
        yajl_gen_bool(g, (bool)value.getBDeviceActiveSource());
    }
    if (!isSparse || value.hasBDeviceConnected()) {
        yajl_gen_string(g, (const unsigned char*)  "bDeviceConnected" , 16);
        yajl_gen_bool(g, (bool)value.getBDeviceConnected());
    }
    if (!isSparse || value.hasBIsNowPlayingListAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsNowPlayingListAvailable" , 26);
        yajl_gen_bool(g, (bool)value.getBIsNowPlayingListAvailable());
    }
    if (!isSparse || value.hasBRepeatSupported()) {
        yajl_gen_string(g, (const unsigned char*)  "bRepeatSupported" , 16);
        yajl_gen_bool(g, (bool)value.getBRepeatSupported());
    }
    if (!isSparse || value.hasBScanSupported()) {
        yajl_gen_string(g, (const unsigned char*)  "bScanSupported" , 14);
        yajl_gen_bool(g, (bool)value.getBScanSupported());
    }
    if (!isSparse || value.hasBShuffleSupported()) {
        yajl_gen_string(g, (const unsigned char*)  "bShuffleSupported" , 17);
        yajl_gen_bool(g, (bool)value.getBShuffleSupported());
    }
    if (!isSparse || value.hasSDeviceName()) {
        yajl_gen_string(g, (const unsigned char*)  "sDeviceName" , 11);
        const char *s = value.getSDeviceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSDeviceSerialNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "sDeviceSerialNumber" , 19);
        const char *s = value.getSDeviceSerialNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSDeviceSysPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sDeviceSysPath" , 14);
        const char *s = value.getSDeviceSysPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSDeviceVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "sDeviceVersion" , 14);
        const char *s = value.getSDeviceVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSLastPlayedFile()) {
        yajl_gen_string(g, (const unsigned char*)  "sLastPlayedFile" , 15);
        const char *s = value.getSLastPlayedFile().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSMountPoint()) {
        yajl_gen_string(g, (const unsigned char*)  "sMountPoint" , 11);
        const char *s = value.getSMountPoint().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32FreeSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FreeSize" , 11);
        yajl_gen_integer(g, (long long)value.getU32FreeSize());
    }
    if (!isSparse || value.hasU32NumberOfFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumberOfFiles" , 16);
        yajl_gen_integer(g, (long long)value.getU32NumberOfFiles());
    }
    if (!isSparse || value.hasU32NumberOfImageFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumberOfImageFiles" , 21);
        yajl_gen_integer(g, (long long)value.getU32NumberOfImageFiles());
    }
    if (!isSparse || value.hasU32NumberOfVideoFiles()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumberOfVideoFiles" , 21);
        yajl_gen_integer(g, (long long)value.getU32NumberOfVideoFiles());
    }
    if (!isSparse || value.hasU32PartitionNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u32PartitionNumber" , 18);
        yajl_gen_integer(g, (long long)value.getU32PartitionNumber());
    }
    if (!isSparse || value.hasU32TotalSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalSize" , 12);
        yajl_gen_integer(g, (long long)value.getU32TotalSize());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasDeviceDBViewStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceDBViewStatus" , 18);
        const char* s = ::MPlay_fi_types::T_e_MPlayDeviceDBViewStatus_Name(value.getDeviceDBViewStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceDBViewStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_MPlayDeviceInfoItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MPlayFileListItem"

void serializeJson (const ::MPlay_fi_types::T_MPlayFileListItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8FileFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "e8FileFormat" , 12);
        const char* s = ::MPlay_fi_types::T_e8_MPlayFileFormat_Name(value.getE8FileFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8FileFormat());
    }
    if (!isSparse || value.hasE8FileType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8FileType" , 10);
        const char* s = ::MPlay_fi_types::T_e8_MPlayFileType_Name(value.getE8FileType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8FileType());
    }
    if (!isSparse || value.hasE8PlayableStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PlayableStatus" , 16);
        const char* s = ::MPlay_fi_types::T_e8_MPlayPlayableStatus_Name(value.getE8PlayableStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PlayableStatus());
    }
    if (!isSparse || value.hasBIsPlaying()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsPlaying" , 10);
        yajl_gen_bool(g, (bool)value.getBIsPlaying());
    }
    if (!isSparse || value.hasBReadOnlyFlag()) {
        yajl_gen_string(g, (const unsigned char*)  "bReadOnlyFlag" , 13);
        yajl_gen_bool(g, (bool)value.getBReadOnlyFlag());
    }
    if (!isSparse || value.hasSFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "sFilename" , 9);
        const char *s = value.getSFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    if (!isSparse || value.hasU8TrackNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TrackNumber" , 13);
        yajl_gen_integer(g, (long long)value.getU8TrackNumber());
    }
    if (!isSparse || value.hasSDateTime()) {
        yajl_gen_string(g, (const unsigned char*)  "sDateTime" , 9);
        const char *s = value.getSDateTime().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32TotalPlaytime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalPlaytime" , 16);
        yajl_gen_integer(g, (long long)value.getU32TotalPlaytime());
    }
    if (!isSparse || value.hasU64FileSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u64FileSize" , 11);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getU64FileSize(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasSCoverArt()) {
        yajl_gen_string(g, (const unsigned char*)  "sCoverArt" , 9);
        const char *s = value.getSCoverArt().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTag()) {
        yajl_gen_string(g, (const unsigned char*)  "Tag" , 3);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getTag(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasParentTag()) {
        yajl_gen_string(g, (const unsigned char*)  "ParentTag" , 9);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getParentTag(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_MPlayFileListItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MPlayImageObjectItem"

void serializeJson (const ::MPlay_fi_types::T_MPlayImageObjectItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8FileFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "e8FileFormat" , 12);
        const char* s = ::MPlay_fi_types::T_e8_MPlayFileFormat_Name(value.getE8FileFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8FileFormat());
    }
    if (!isSparse || value.hasE8FileType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8FileType" , 10);
        const char* s = ::MPlay_fi_types::T_e8_MPlayFileType_Name(value.getE8FileType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8FileType());
    }
    if (!isSparse || value.hasSDateTime()) {
        yajl_gen_string(g, (const unsigned char*)  "sDateTime" , 9);
        const char *s = value.getSDateTime().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSDimension()) {
        yajl_gen_string(g, (const unsigned char*)  "sDimension" , 10);
        const char *s = value.getSDimension().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSFolderTitle()) {
        yajl_gen_string(g, (const unsigned char*)  "sFolderTitle" , 12);
        const char *s = value.getSFolderTitle().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSImageFile()) {
        yajl_gen_string(g, (const unsigned char*)  "sImageFile" , 10);
        const char *s = value.getSImageFile().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSImageSize()) {
        yajl_gen_string(g, (const unsigned char*)  "sImageSize" , 10);
        const char *s = value.getSImageSize().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSImageTitle()) {
        yajl_gen_string(g, (const unsigned char*)  "sImageTitle" , 11);
        const char *s = value.getSImageTitle().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSMountPoint()) {
        yajl_gen_string(g, (const unsigned char*)  "sMountPoint" , 11);
        const char *s = value.getSMountPoint().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSPath()) {
        yajl_gen_string(g, (const unsigned char*)  "sPath" , 5);
        const char *s = value.getSPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSResolution()) {
        yajl_gen_string(g, (const unsigned char*)  "sResolution" , 11);
        const char *s = value.getSResolution().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32NumberOfImages()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumberOfImages" , 17);
        yajl_gen_integer(g, (long long)value.getU32NumberOfImages());
    }
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_MPlayImageObjectItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MPlayIndexingStateResultItem"

void serializeJson (const ::MPlay_fi_types::T_MPlayIndexingStateResultItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DeviceIndexedState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DeviceIndexedState" , 20);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeviceIndexedState_Name(value.getE8DeviceIndexedState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DeviceIndexedState());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasU8IndexingPercentComplete()) {
        yajl_gen_string(g, (const unsigned char*)  "u8IndexingPercentComplete" , 25);
        yajl_gen_integer(g, (long long)value.getU8IndexingPercentComplete());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_MPlayIndexingStateResultItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MPlayMediaObject"

void serializeJson (const ::MPlay_fi_types::T_MPlayMediaObject& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8AudioChannelFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AudioChannelFormat" , 20);
        const char* s = ::MPlay_fi_types::T_e8_MPlayAudioChannelFormat_Name(value.getE8AudioChannelFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AudioChannelFormat());
    }
    if (!isSparse || value.hasE8CategoryType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8CategoryType" , 14);
        const char* s = ::MPlay_fi_types::T_e8_MPlayCategoryType_Name(value.getE8CategoryType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8CategoryType());
    }
    if (!isSparse || value.hasE8DeviceType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DeviceType" , 12);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeviceType_Name(value.getE8DeviceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DeviceType());
    }
    if (!isSparse || value.hasE8FileFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "e8FileFormat" , 12);
        const char* s = ::MPlay_fi_types::T_e8_MPlayFileFormat_Name(value.getE8FileFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8FileFormat());
    }
    if (!isSparse || value.hasE8MediaType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8MediaType" , 11);
        const char* s = ::MPlay_fi_types::T_e8_MPlayMediaType_Name(value.getE8MediaType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8MediaType());
    }
    if (!isSparse || value.hasE8PlayableStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PlayableStatus" , 16);
        const char* s = ::MPlay_fi_types::T_e8_MPlayPlayableStatus_Name(value.getE8PlayableStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PlayableStatus());
    }
    if (!isSparse || value.hasBIsPlaying()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsPlaying" , 10);
        yajl_gen_bool(g, (bool)value.getBIsPlaying());
    }
    if (!isSparse || value.hasBVBR()) {
        yajl_gen_string(g, (const unsigned char*)  "bVBR" , 4);
        yajl_gen_bool(g, (bool)value.getBVBR());
    }
    if (!isSparse || value.hasSAlbumArt()) {
        yajl_gen_string(g, (const unsigned char*)  "sAlbumArt" , 9);
        const char *s = value.getSAlbumArt().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSDateTime()) {
        yajl_gen_string(g, (const unsigned char*)  "sDateTime" , 9);
        const char *s = value.getSDateTime().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSDeviceVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "sDeviceVersion" , 14);
        const char *s = value.getSDeviceVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "sFilename" , 9);
        const char *s = value.getSFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSMetaDataField1()) {
        yajl_gen_string(g, (const unsigned char*)  "sMetaDataField1" , 15);
        const char *s = value.getSMetaDataField1().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSMetaDataField2()) {
        yajl_gen_string(g, (const unsigned char*)  "sMetaDataField2" , 15);
        const char *s = value.getSMetaDataField2().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSMetaDataField3()) {
        yajl_gen_string(g, (const unsigned char*)  "sMetaDataField3" , 15);
        const char *s = value.getSMetaDataField3().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSMetaDataField4()) {
        yajl_gen_string(g, (const unsigned char*)  "sMetaDataField4" , 15);
        const char *s = value.getSMetaDataField4().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSYomiMetaDataTitle()) {
        yajl_gen_string(g, (const unsigned char*)  "sYomiMetaDataTitle" , 18);
        const char *s = value.getSYomiMetaDataTitle().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSYomiMetaDataArtist()) {
        yajl_gen_string(g, (const unsigned char*)  "sYomiMetaDataArtist" , 19);
        const char *s = value.getSYomiMetaDataArtist().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSYomiMetaDataAlbum()) {
        yajl_gen_string(g, (const unsigned char*)  "sYomiMetaDataAlbum" , 18);
        const char *s = value.getSYomiMetaDataAlbum().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSResolution()) {
        yajl_gen_string(g, (const unsigned char*)  "sResolution" , 11);
        const char *s = value.getSResolution().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU16ExtendedTrackNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ExtendedTrackNumber" , 22);
        yajl_gen_integer(g, (long long)value.getU16ExtendedTrackNumber());
    }
    if (!isSparse || value.hasU32BitRate()) {
        yajl_gen_string(g, (const unsigned char*)  "u32BitRate" , 10);
        yajl_gen_integer(g, (long long)value.getU32BitRate());
    }
    if (!isSparse || value.hasU32MetaDataTag1()) {
        yajl_gen_string(g, (const unsigned char*)  "u32MetaDataTag1" , 15);
        yajl_gen_integer(g, (long long)value.getU32MetaDataTag1());
    }
    if (!isSparse || value.hasU32MetaDataTag2()) {
        yajl_gen_string(g, (const unsigned char*)  "u32MetaDataTag2" , 15);
        yajl_gen_integer(g, (long long)value.getU32MetaDataTag2());
    }
    if (!isSparse || value.hasU32MetaDataTag3()) {
        yajl_gen_string(g, (const unsigned char*)  "u32MetaDataTag3" , 15);
        yajl_gen_integer(g, (long long)value.getU32MetaDataTag3());
    }
    if (!isSparse || value.hasU32MetaDataTag4()) {
        yajl_gen_string(g, (const unsigned char*)  "u32MetaDataTag4" , 15);
        yajl_gen_integer(g, (long long)value.getU32MetaDataTag4());
    }
    if (!isSparse || value.hasU32SampleRate()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SampleRate" , 13);
        yajl_gen_integer(g, (long long)value.getU32SampleRate());
    }
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    if (!isSparse || value.hasU32TotalPlaytime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalPlaytime" , 16);
        yajl_gen_integer(g, (long long)value.getU32TotalPlaytime());
    }
    if (!isSparse || value.hasU32Year()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Year" , 7);
        yajl_gen_integer(g, (long long)value.getU32Year());
    }
    if (!isSparse || value.hasU32YearID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32YearID" , 9);
        yajl_gen_integer(g, (long long)value.getU32YearID());
    }
    if (!isSparse || value.hasU64FileSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u64FileSize" , 11);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getU64FileSize(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasU8TrackNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TrackNumber" , 13);
        yajl_gen_integer(g, (long long)value.getU8TrackNumber());
    }
    if (!isSparse || value.hasBIsFavorite()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsFavorite" , 11);
        yajl_gen_bool(g, (bool)value.getBIsFavorite());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_MPlayMediaObject& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MPlayMediaObjectsItem"

void serializeJson (const ::MPlay_fi_types::T_MPlayMediaObjectsItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8CategoryType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8CategoryType" , 14);
        const char* s = ::MPlay_fi_types::T_e8_MPlayCategoryType_Name(value.getE8CategoryType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8CategoryType());
    }
    if (!isSparse || value.hasE8DeviceType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DeviceType" , 12);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeviceType_Name(value.getE8DeviceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DeviceType());
    }
    if (!isSparse || value.hasE8FileFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "e8FileFormat" , 12);
        const char* s = ::MPlay_fi_types::T_e8_MPlayFileFormat_Name(value.getE8FileFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8FileFormat());
    }
    if (!isSparse || value.hasE8MediaType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8MediaType" , 11);
        const char* s = ::MPlay_fi_types::T_e8_MPlayMediaType_Name(value.getE8MediaType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8MediaType());
    }
    if (!isSparse || value.hasE8PlayableStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PlayableStatus" , 16);
        const char* s = ::MPlay_fi_types::T_e8_MPlayPlayableStatus_Name(value.getE8PlayableStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PlayableStatus());
    }
    if (!isSparse || value.hasOThumbnailData()) {
        yajl_gen_string(g, (const unsigned char*)  "oThumbnailData" , 14);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o1 = value.getOThumbnailData();
        {
            ::std::vector< uint8 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasBIsPlaying()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsPlaying" , 10);
        yajl_gen_bool(g, (bool)value.getBIsPlaying());
    }
    if (!isSparse || value.hasBReadOnlyFlag()) {
        yajl_gen_string(g, (const unsigned char*)  "bReadOnlyFlag" , 13);
        yajl_gen_bool(g, (bool)value.getBReadOnlyFlag());
    }
    if (!isSparse || value.hasSAlbumArt()) {
        yajl_gen_string(g, (const unsigned char*)  "sAlbumArt" , 9);
        const char *s = value.getSAlbumArt().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSCoverArt()) {
        yajl_gen_string(g, (const unsigned char*)  "sCoverArt" , 9);
        const char *s = value.getSCoverArt().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSDateTime()) {
        yajl_gen_string(g, (const unsigned char*)  "sDateTime" , 9);
        const char *s = value.getSDateTime().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSDeviceVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "sDeviceVersion" , 14);
        const char *s = value.getSDeviceVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSFilename()) {
        yajl_gen_string(g, (const unsigned char*)  "sFilename" , 9);
        const char *s = value.getSFilename().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSMetaDataField1()) {
        yajl_gen_string(g, (const unsigned char*)  "sMetaDataField1" , 15);
        const char *s = value.getSMetaDataField1().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSMetaDataField2()) {
        yajl_gen_string(g, (const unsigned char*)  "sMetaDataField2" , 15);
        const char *s = value.getSMetaDataField2().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSMetaDataField3()) {
        yajl_gen_string(g, (const unsigned char*)  "sMetaDataField3" , 15);
        const char *s = value.getSMetaDataField3().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSMetaDataField4()) {
        yajl_gen_string(g, (const unsigned char*)  "sMetaDataField4" , 15);
        const char *s = value.getSMetaDataField4().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32MetaDataTag1()) {
        yajl_gen_string(g, (const unsigned char*)  "u32MetaDataTag1" , 15);
        yajl_gen_integer(g, (long long)value.getU32MetaDataTag1());
    }
    if (!isSparse || value.hasU32MetaDataTag2()) {
        yajl_gen_string(g, (const unsigned char*)  "u32MetaDataTag2" , 15);
        yajl_gen_integer(g, (long long)value.getU32MetaDataTag2());
    }
    if (!isSparse || value.hasU32MetaDataTag3()) {
        yajl_gen_string(g, (const unsigned char*)  "u32MetaDataTag3" , 15);
        yajl_gen_integer(g, (long long)value.getU32MetaDataTag3());
    }
    if (!isSparse || value.hasU32MetaDataTag4()) {
        yajl_gen_string(g, (const unsigned char*)  "u32MetaDataTag4" , 15);
        yajl_gen_integer(g, (long long)value.getU32MetaDataTag4());
    }
    if (!isSparse || value.hasSYomiMetaDataTitle()) {
        yajl_gen_string(g, (const unsigned char*)  "sYomiMetaDataTitle" , 18);
        const char *s = value.getSYomiMetaDataTitle().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSYomiMetaDataArtist()) {
        yajl_gen_string(g, (const unsigned char*)  "sYomiMetaDataArtist" , 19);
        const char *s = value.getSYomiMetaDataArtist().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSYomiMetaDataAlbum()) {
        yajl_gen_string(g, (const unsigned char*)  "sYomiMetaDataAlbum" , 18);
        const char *s = value.getSYomiMetaDataAlbum().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32Tag()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Tag" , 6);
        yajl_gen_integer(g, (long long)value.getU32Tag());
    }
    if (!isSparse || value.hasU32TotalPlaytime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TotalPlaytime" , 16);
        yajl_gen_integer(g, (long long)value.getU32TotalPlaytime());
    }
    if (!isSparse || value.hasU32Year()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Year" , 7);
        yajl_gen_integer(g, (long long)value.getU32Year());
    }
    if (!isSparse || value.hasU32YearID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32YearID" , 9);
        yajl_gen_integer(g, (long long)value.getU32YearID());
    }
    if (!isSparse || value.hasU64FileSize()) {
        yajl_gen_string(g, (const unsigned char*)  "u64FileSize" , 11);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getU64FileSize(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasU8TrackNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TrackNumber" , 13);
        yajl_gen_integer(g, (long long)value.getU8TrackNumber());
    }
    if (!isSparse || value.hasBIsFavorite()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsFavorite" , 11);
        yajl_gen_bool(g, (bool)value.getBIsFavorite());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_MPlayMediaObjectsItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_PermissionByTag"

void serializeJson (const ::MPlay_fi_types::T_PermissionByTag& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBReadOnlyFlag()) {
        yajl_gen_string(g, (const unsigned char*)  "bReadOnlyFlag" , 13);
        yajl_gen_bool(g, (bool)value.getBReadOnlyFlag());
    }
    if (!isSparse || value.hasMediaObjectTag()) {
        yajl_gen_string(g, (const unsigned char*)  "MediaObjectTag" , 14);
        yajl_gen_integer(g, (long long)value.getMediaObjectTag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_PermissionByTag& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MPlayRippingStateResultItem"

void serializeJson (const ::MPlay_fi_types::T_MPlayRippingStateResultItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DeviceRippingState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DeviceRippingState" , 20);
        const char* s = ::MPlay_fi_types::T_e8_MPlayDeviceRippingState_Name(value.getE8DeviceRippingState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DeviceRippingState());
    }
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasU8RippingPercentComplete()) {
        yajl_gen_string(g, (const unsigned char*)  "u8RippingPercentComplete" , 24);
        yajl_gen_integer(g, (long long)value.getU8RippingPercentComplete());
    }
    if (!isSparse || value.hasTotalTracksInCD()) {
        yajl_gen_string(g, (const unsigned char*)  "TotalTracksInCD" , 15);
        yajl_gen_integer(g, (long long)value.getTotalTracksInCD());
    }
    if (!isSparse || value.hasCurrentRippedTrackIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentRippedTrackIndex" , 23);
        yajl_gen_integer(g, (long long)value.getCurrentRippedTrackIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_MPlayRippingStateResultItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MPlaySearchKeyboardListItem"

void serializeJson (const ::MPlay_fi_types::T_MPlaySearchKeyboardListItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBLetterAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bLetterAvailable" , 16);
        yajl_gen_bool(g, (bool)value.getBLetterAvailable());
    }
    if (!isSparse || value.hasSSearchKeyboardLetter()) {
        yajl_gen_string(g, (const unsigned char*)  "sSearchKeyboardLetter" , 21);
        const char *s = value.getSSearchKeyboardLetter().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32LetterEndIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "u32LetterEndIndex" , 17);
        yajl_gen_integer(g, (long long)value.getU32LetterEndIndex());
    }
    if (!isSparse || value.hasU32LetterStartIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "u32LetterStartIndex" , 19);
        yajl_gen_integer(g, (long long)value.getU32LetterStartIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_MPlaySearchKeyboardListItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MPlayTagTransferItem_1"

void serializeJson (const ::MPlay_fi_types::T_MPlayTagTransferItem_1& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOUnknownData()) {
        yajl_gen_string(g, (const unsigned char*)  "oUnknownData" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o3 = value.getOUnknownData();
        {
            ::std::vector< uint8 >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                yajl_gen_integer(g, (long long)(*o2));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasSPodCastFeedURL()) {
        yajl_gen_string(g, (const unsigned char*)  "sPodCastFeedURL" , 15);
        const char *s = value.getSPodCastFeedURL().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSStationURL()) {
        yajl_gen_string(g, (const unsigned char*)  "sStationURL" , 11);
        const char *s = value.getSStationURL().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSStationURLFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "sStationURLFrequency" , 20);
        const char *s = value.getSStationURLFrequency().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagAffiliateID()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagAffiliateID" , 15);
        const char *s = value.getSTagAffiliateID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagAlbum()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagAlbum" , 9);
        const char *s = value.getSTagAlbum().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagArtistName()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagArtistName" , 14);
        const char *s = value.getSTagArtistName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagChannelName()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagChannelName" , 15);
        const char *s = value.getSTagChannelName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagChannelNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagChannelNumber" , 17);
        const char *s = value.getSTagChannelNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagGenre()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagGenre" , 9);
        const char *s = value.getSTagGenre().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagTimeStamp()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagTimeStamp" , 13);
        const char *s = value.getSTagTimeStamp().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagTrackName()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagTrackName" , 13);
        const char *s = value.getSTagTrackName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32TagSongID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TagSongID" , 12);
        yajl_gen_integer(g, (long long)value.getU32TagSongID());
    }
    if (!isSparse || value.hasU8AmbiguousTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AmbiguousTag" , 14);
        yajl_gen_integer(g, (long long)value.getU8AmbiguousTag());
    }
    if (!isSparse || value.hasU8ButtonPressed()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ButtonPressed" , 15);
        yajl_gen_integer(g, (long long)value.getU8ButtonPressed());
    }
    if (!isSparse || value.hasU8TagProgramNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TagProgramNumber" , 18);
        yajl_gen_integer(g, (long long)value.getU8TagProgramNumber());
    }
    if (!isSparse || value.hasU8TagStorefrontID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TagStorefrontID" , 17);
        yajl_gen_integer(g, (long long)value.getU8TagStorefrontID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_MPlayTagTransferItem_1& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MPlayTagTransferItem_2"

void serializeJson (const ::MPlay_fi_types::T_MPlayTagTransferItem_2& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOUnknownData()) {
        yajl_gen_string(g, (const unsigned char*)  "oUnknownData" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o5 = value.getOUnknownData();
        {
            ::std::vector< uint8 >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                yajl_gen_integer(g, (long long)(*o4));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasSPodCastFeedURL()) {
        yajl_gen_string(g, (const unsigned char*)  "sPodCastFeedURL" , 15);
        const char *s = value.getSPodCastFeedURL().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSStationURL()) {
        yajl_gen_string(g, (const unsigned char*)  "sStationURL" , 11);
        const char *s = value.getSStationURL().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSStationURLFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "sStationURLFrequency" , 20);
        const char *s = value.getSStationURLFrequency().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagAffiliateID()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagAffiliateID" , 15);
        const char *s = value.getSTagAffiliateID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagAlbum()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagAlbum" , 9);
        const char *s = value.getSTagAlbum().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagArtistName()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagArtistName" , 14);
        const char *s = value.getSTagArtistName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagChannelName()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagChannelName" , 15);
        const char *s = value.getSTagChannelName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagChannelNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagChannelNumber" , 17);
        const char *s = value.getSTagChannelNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagGenre()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagGenre" , 9);
        const char *s = value.getSTagGenre().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagTimeStamp()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagTimeStamp" , 13);
        const char *s = value.getSTagTimeStamp().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagTrackName()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagTrackName" , 13);
        const char *s = value.getSTagTrackName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32TagSongID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TagSongID" , 12);
        yajl_gen_integer(g, (long long)value.getU32TagSongID());
    }
    if (!isSparse || value.hasU32TagStorefrontID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TagStorefrontID" , 18);
        yajl_gen_integer(g, (long long)value.getU32TagStorefrontID());
    }
    if (!isSparse || value.hasU8AmbiguousTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AmbiguousTag" , 14);
        yajl_gen_integer(g, (long long)value.getU8AmbiguousTag());
    }
    if (!isSparse || value.hasU8ButtonPressed()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ButtonPressed" , 15);
        yajl_gen_integer(g, (long long)value.getU8ButtonPressed());
    }
    if (!isSparse || value.hasU8TagProgramNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TagProgramNumber" , 18);
        yajl_gen_integer(g, (long long)value.getU8TagProgramNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_MPlayTagTransferItem_2& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MPlayUntransferredTagStreamItem"

void serializeJson (const ::MPlay_fi_types::T_MPlayUntransferredTagStreamItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSTagArtistName()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagArtistName" , 14);
        const char *s = value.getSTagArtistName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTagTrackName()) {
        yajl_gen_string(g, (const unsigned char*)  "sTagTrackName" , 13);
        const char *s = value.getSTagTrackName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32TagSongID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TagSongID" , 12);
        yajl_gen_integer(g, (long long)value.getU32TagSongID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_MPlayUntransferredTagStreamItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SearchString"

void serializeJson (const ::MPlay_fi_types::T_SearchString& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSText()) {
        yajl_gen_string(g, (const unsigned char*)  "sText" , 5);
        const char *s = value.getSText().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8Encoding()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Encoding" , 10);
        yajl_gen_integer(g, (long long)value.getU8Encoding());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::MPlay_fi_types::T_SearchString& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_MInternalDVDLangSetting& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_MPlayDeviceInfoItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_MPlayFileListItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_MPlayImageObjectItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_MPlayIndexingStateResultItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_MPlayMediaObject& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_MPlayMediaObjectsItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_PermissionByTag& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_MPlayRippingStateResultItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_MPlaySearchKeyboardListItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_MPlayTagTransferItem_1& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_MPlayTagTransferItem_2& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_MPlayUntransferredTagStreamItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types
using namespace ::asf::stream::json;

namespace MPlay_fi_types {

std::ostream& operator<<(std::ostream& o, const ::MPlay_fi_types::T_SearchString& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace MPlay_fi_types

