#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MPLAY_FI_TYPES_H
#define MPLAY_FI_TYPES_H

#include "MPlay_fi_typesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types MPlay_fi_types
 */

namespace MPlay_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_MInternalDVDLangSetting;

class T_MPlayDeviceInfoItem;

class T_MPlayFileListItem;

class T_MPlayImageObjectItem;

class T_MPlayIndexingStateResultItem;

class T_MPlayMediaObject;

class T_MPlayMediaObjectsItem;

class T_PermissionByTag;

class T_MPlayRippingStateResultItem;

class T_MPlaySearchKeyboardListItem;

class T_MPlayTagTransferItem_1;

class T_MPlayTagTransferItem_2;

class T_MPlayUntransferredTagStreamItem;

class T_SearchString;

// type definitions
/**
 * If the meaning of "T_MPlayDeviceInfo" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MPlayDeviceInfoItem > T_MPlayDeviceInfo;

/**
 * If the meaning of "T_MPlayFavoritesList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint64 > T_MPlayFavoritesList;

/**
 * If the meaning of "T_MPlayFileList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MPlayFileListItem > T_MPlayFileList;

/**
 * If the meaning of "T_MPlayImageData" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_MPlayImageData;

/**
 * If the meaning of "T_MPlayImageObjects" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MPlayImageObjectItem > T_MPlayImageObjects;

/**
 * If the meaning of "T_MPlayIndexingStateResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MPlayIndexingStateResultItem > T_MPlayIndexingStateResult;

/**
 * If the meaning of "T_MPlayItems" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint32 > T_MPlayItems;

/**
 * If the meaning of "T_MPlayMediaAlbums" isn't clear, then there should be a description here.
 */
typedef ::std::vector< ::std::string > T_MPlayMediaAlbums;

/**
 * If the meaning of "T_MPlayMediaObjects" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MPlayMediaObjectsItem > T_MPlayMediaObjects;

/**
 * If the meaning of "T_MPlayMediaObjectTag" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint32 > T_MPlayMediaObjectTag;

/**
 * If the meaning of "T_MPlayMediaObjectUrl" isn't clear, then there should be a description here.
 */
typedef ::std::vector< ::std::string > T_MPlayMediaObjectUrl;

/**
 * If the meaning of "T_MPlayPermissionByTag" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_PermissionByTag > T_MPlayPermissionByTag;

/**
 * If the meaning of "T_MPlayPlayListPosition" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint32 > T_MPlayPlayListPosition;

/**
 * If the meaning of "T_MPlaySearchKeyboardList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MPlaySearchKeyboardListItem > T_MPlaySearchKeyboardList;

/**
 * If the meaning of "T_MPlayTagTransfer_1" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MPlayTagTransferItem_1 > T_MPlayTagTransfer_1;

/**
 * If the meaning of "T_MPlayTagTransfer_2" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MPlayTagTransferItem_2 > T_MPlayTagTransfer_2;

/**
 * If the meaning of "T_MPlayUntransferredTagStream" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MPlayUntransferredTagStreamItem > T_MPlayUntransferredTagStream;

/**
 * If the meaning of "T_IndicesList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint32 > T_IndicesList;

/**
 * If the meaning of "T_AlbumArtUrlList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< ::std::string > T_AlbumArtUrlList;


class T_MInternalDVDLangSetting {
public:

    /**
     * Default constructor
     */
    inline  T_MInternalDVDLangSetting ();

    /**
     * Copy constructor
     */
    inline  T_MInternalDVDLangSetting (const T_MInternalDVDLangSetting &rhs);

    /**
     * All fields constructor
     */
    inline  T_MInternalDVDLangSetting (uint16 u16AudioLanguage_, uint16 u16MenuLanguage_, uint16 u16SubtitleLanguage_);

    /**
     * Destructor
     */
    inline  ~T_MInternalDVDLangSetting();

    /**
     * Assignment operator
     */
    inline T_MInternalDVDLangSetting& operator = (const T_MInternalDVDLangSetting& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MInternalDVDLangSetting& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MInternalDVDLangSetting& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MInternalDVDLangSetting& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MInternalDVDLangSetting& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16AudioLanguage"

    static const int kU16AudioLanguage = 0;

    /**
     * Clears the field "u16AudioLanguage".
     *
     * The field will be set to its default value. The hasU16AudioLanguage()
     * method will return false.
     */
    inline void clearU16AudioLanguage();

    /**
     * Checks whether the field "u16AudioLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AudioLanguage()). Otherwise it will return false.
     */
    inline bool hasU16AudioLanguage () const;

    /**
     * Returns the value of the member "u16AudioLanguage".
     *
     * It represents the DVD Video Priority Audio Language of the Disc , 0xFFFF will be the default language
     *
     * @return The value of the field "u16AudioLanguage"
     */
    inline uint16 getU16AudioLanguage () const;

    /**
     * Sets the value of the member "u16AudioLanguage".
     *
     * It represents the DVD Video Priority Audio Language of the Disc , 0xFFFF will be the default language
     *
     * @param u16AudioLanguage The value which will be set
     */
    inline void setU16AudioLanguage (uint16 u16AudioLanguage_);

    // API of field "u16MenuLanguage"

    static const int kU16MenuLanguage = 1;

    /**
     * Clears the field "u16MenuLanguage".
     *
     * The field will be set to its default value. The hasU16MenuLanguage()
     * method will return false.
     */
    inline void clearU16MenuLanguage();

    /**
     * Checks whether the field "u16MenuLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MenuLanguage()). Otherwise it will return false.
     */
    inline bool hasU16MenuLanguage () const;

    /**
     * Returns the value of the member "u16MenuLanguage".
     *
     * It represents the DVD Priority Menu Language of the Disc , 0xFFFF will be the default language
     *
     * @return The value of the field "u16MenuLanguage"
     */
    inline uint16 getU16MenuLanguage () const;

    /**
     * Sets the value of the member "u16MenuLanguage".
     *
     * It represents the DVD Priority Menu Language of the Disc , 0xFFFF will be the default language
     *
     * @param u16MenuLanguage The value which will be set
     */
    inline void setU16MenuLanguage (uint16 u16MenuLanguage_);

    // API of field "u16SubtitleLanguage"

    static const int kU16SubtitleLanguage = 2;

    /**
     * Clears the field "u16SubtitleLanguage".
     *
     * The field will be set to its default value. The hasU16SubtitleLanguage()
     * method will return false.
     */
    inline void clearU16SubtitleLanguage();

    /**
     * Checks whether the field "u16SubtitleLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SubtitleLanguage()). Otherwise it will return false.
     */
    inline bool hasU16SubtitleLanguage () const;

    /**
     * Returns the value of the member "u16SubtitleLanguage".
     *
     * It represents the DVD Priority Subtitle Language of the Disc , 0xFFFF will be the default language
     *
     * @return The value of the field "u16SubtitleLanguage"
     */
    inline uint16 getU16SubtitleLanguage () const;

    /**
     * Sets the value of the member "u16SubtitleLanguage".
     *
     * It represents the DVD Priority Subtitle Language of the Disc , 0xFFFF will be the default language
     *
     * @param u16SubtitleLanguage The value which will be set
     */
    inline void setU16SubtitleLanguage (uint16 u16SubtitleLanguage_);

    static const T_MInternalDVDLangSetting &getDefaultInstance();

private:

    inline void set_has_u16AudioLanguage ();

    inline void clear_has_u16AudioLanguage ();

    inline void set_has_u16MenuLanguage ();

    inline void clear_has_u16MenuLanguage ();

    inline void set_has_u16SubtitleLanguage ();

    inline void clear_has_u16SubtitleLanguage ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16AudioLanguage;

    uint16 _u16MenuLanguage;

    uint16 _u16SubtitleLanguage;

};

/**
 * DeviceTag, DeviceName, DeviceType, DeviceSerialNumber, DeviceConnected, DeviceIndexedState, DeviceActiveSource, NumberOfFiles,NumberOfVideoFiles,NumberOfImageFiles, DeviceState, FileSystemType, PartitionNumber, TotalSize, FreeSize, ConnectionType, LastPlayedFile, DisconnectReason, DeviceControlSupport, ShuffleSupported, RepeatSupported, ScanSupported, DeviceVersion, DiscType
 */
class T_MPlayDeviceInfoItem {
public:

    /**
     * Default constructor
     */
    inline  T_MPlayDeviceInfoItem ();

    /**
     * Copy constructor
     */
    inline  T_MPlayDeviceInfoItem (const T_MPlayDeviceInfoItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MPlayDeviceInfoItem (T_e8_MDiscType e8DiscType_, T_e8_MPlayAvailabilityReason e8AvailabilityReason_, T_e8_MPlayConnectionState e8ConnectionState_, T_e8_MPlayConnectionType e8ConnectionType_, T_e8_MPlayDeviceControlSupport e8DeviceControlSupport_, T_e8_MPlayDeviceIndexedState e8DeviceIndexedState_, T_e8_MPlayDeviceStatus e8DeviceState_, T_e8_MPlayDeviceType e8DeviceType_, T_e8_MPlayDisconnectReason e8DisconnectReason_, T_e8_MPlayFileSystemType e8FileSystemType_, bool bDeviceActiveSource_, bool bDeviceConnected_, bool bIsNowPlayingListAvailable_, bool bRepeatSupported_, bool bScanSupported_, bool bShuffleSupported_, const ::std::string& sDeviceName_, const ::std::string& sDeviceSerialNumber_, const ::std::string& sDeviceSysPath_, const ::std::string& sDeviceVersion_, const ::std::string& sLastPlayedFile_, const ::std::string& sMountPoint_, uint32 u32FreeSize_, uint32 u32NumberOfFiles_, uint32 u32NumberOfImageFiles_, uint32 u32NumberOfVideoFiles_, uint32 u32PartitionNumber_, uint32 u32TotalSize_, uint8 u8DeviceTag_, T_e_MPlayDeviceDBViewStatus DeviceDBViewStatus_);

    /**
     * Destructor
     */
    inline  ~T_MPlayDeviceInfoItem();

    /**
     * Assignment operator
     */
    inline T_MPlayDeviceInfoItem& operator = (const T_MPlayDeviceInfoItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MPlayDeviceInfoItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MPlayDeviceInfoItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MPlayDeviceInfoItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MPlayDeviceInfoItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DiscType"

    static const int kE8DiscType = 0;

    /**
     * Clears the field "e8DiscType".
     *
     * The field will be set to its default value. The hasE8DiscType()
     * method will return false.
     */
    inline void clearE8DiscType();

    /**
     * Checks whether the field "e8DiscType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiscType()). Otherwise it will return false.
     */
    inline bool hasE8DiscType () const;

    /**
     * Returns the value of the member "e8DiscType".
     *
     * Disc type prsent in the device
     *
     * @return The value of the field "e8DiscType"
     */
    inline T_e8_MDiscType getE8DiscType () const;

    /**
     * Sets the value of the member "e8DiscType".
     *
     * Disc type prsent in the device
     *
     * @param e8DiscType The value which will be set
     */
    inline void setE8DiscType (T_e8_MDiscType e8DiscType_);

    // API of field "e8AvailabilityReason"

    static const int kE8AvailabilityReason = 1;

    /**
     * Clears the field "e8AvailabilityReason".
     *
     * The field will be set to its default value. The hasE8AvailabilityReason()
     * method will return false.
     */
    inline void clearE8AvailabilityReason();

    /**
     * Checks whether the field "e8AvailabilityReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AvailabilityReason()). Otherwise it will return false.
     */
    inline bool hasE8AvailabilityReason () const;

    /**
     * Returns the value of the member "e8AvailabilityReason".
     *
     * Reason of a device availability.
     *
     * @return The value of the field "e8AvailabilityReason"
     */
    inline T_e8_MPlayAvailabilityReason getE8AvailabilityReason () const;

    /**
     * Sets the value of the member "e8AvailabilityReason".
     *
     * Reason of a device availability.
     *
     * @param e8AvailabilityReason The value which will be set
     */
    inline void setE8AvailabilityReason (T_e8_MPlayAvailabilityReason e8AvailabilityReason_);

    // API of field "e8ConnectionState"

    static const int kE8ConnectionState = 2;

    /**
     * Clears the field "e8ConnectionState".
     *
     * The field will be set to its default value. The hasE8ConnectionState()
     * method will return false.
     */
    inline void clearE8ConnectionState();

    /**
     * Checks whether the field "e8ConnectionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConnectionState()). Otherwise it will return false.
     */
    inline bool hasE8ConnectionState () const;

    /**
     * Returns the value of the member "e8ConnectionState".
     *
     * State of device connection.
     *
     * @return The value of the field "e8ConnectionState"
     */
    inline T_e8_MPlayConnectionState getE8ConnectionState () const;

    /**
     * Sets the value of the member "e8ConnectionState".
     *
     * State of device connection.
     *
     * @param e8ConnectionState The value which will be set
     */
    inline void setE8ConnectionState (T_e8_MPlayConnectionState e8ConnectionState_);

    // API of field "e8ConnectionType"

    static const int kE8ConnectionType = 3;

    /**
     * Clears the field "e8ConnectionType".
     *
     * The field will be set to its default value. The hasE8ConnectionType()
     * method will return false.
     */
    inline void clearE8ConnectionType();

    /**
     * Checks whether the field "e8ConnectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConnectionType()). Otherwise it will return false.
     */
    inline bool hasE8ConnectionType () const;

    /**
     * Returns the value of the member "e8ConnectionType".
     *
     * Type of the connection.
     *
     * @return The value of the field "e8ConnectionType"
     */
    inline T_e8_MPlayConnectionType getE8ConnectionType () const;

    /**
     * Sets the value of the member "e8ConnectionType".
     *
     * Type of the connection.
     *
     * @param e8ConnectionType The value which will be set
     */
    inline void setE8ConnectionType (T_e8_MPlayConnectionType e8ConnectionType_);

    // API of field "e8DeviceControlSupport"

    static const int kE8DeviceControlSupport = 4;

    /**
     * Clears the field "e8DeviceControlSupport".
     *
     * The field will be set to its default value. The hasE8DeviceControlSupport()
     * method will return false.
     */
    inline void clearE8DeviceControlSupport();

    /**
     * Checks whether the field "e8DeviceControlSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceControlSupport()). Otherwise it will return false.
     */
    inline bool hasE8DeviceControlSupport () const;

    /**
     * Returns the value of the member "e8DeviceControlSupport".
     *
     * The Features Supported by the DeviceControl.
     *
     * @return The value of the field "e8DeviceControlSupport"
     */
    inline T_e8_MPlayDeviceControlSupport getE8DeviceControlSupport () const;

    /**
     * Sets the value of the member "e8DeviceControlSupport".
     *
     * The Features Supported by the DeviceControl.
     *
     * @param e8DeviceControlSupport The value which will be set
     */
    inline void setE8DeviceControlSupport (T_e8_MPlayDeviceControlSupport e8DeviceControlSupport_);

    // API of field "e8DeviceIndexedState"

    static const int kE8DeviceIndexedState = 5;

    /**
     * Clears the field "e8DeviceIndexedState".
     *
     * The field will be set to its default value. The hasE8DeviceIndexedState()
     * method will return false.
     */
    inline void clearE8DeviceIndexedState();

    /**
     * Checks whether the field "e8DeviceIndexedState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceIndexedState()). Otherwise it will return false.
     */
    inline bool hasE8DeviceIndexedState () const;

    /**
     * Returns the value of the member "e8DeviceIndexedState".
     *
     * Identifies the state of the indexing operation: Not supported, not started, partially indexed, or complete.
     *
     * @return The value of the field "e8DeviceIndexedState"
     */
    inline T_e8_MPlayDeviceIndexedState getE8DeviceIndexedState () const;

    /**
     * Sets the value of the member "e8DeviceIndexedState".
     *
     * Identifies the state of the indexing operation: Not supported, not started, partially indexed, or complete.
     *
     * @param e8DeviceIndexedState The value which will be set
     */
    inline void setE8DeviceIndexedState (T_e8_MPlayDeviceIndexedState e8DeviceIndexedState_);

    // API of field "e8DeviceState"

    static const int kE8DeviceState = 6;

    /**
     * Clears the field "e8DeviceState".
     *
     * The field will be set to its default value. The hasE8DeviceState()
     * method will return false.
     */
    inline void clearE8DeviceState();

    /**
     * Checks whether the field "e8DeviceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceState()). Otherwise it will return false.
     */
    inline bool hasE8DeviceState () const;

    /**
     * Returns the value of the member "e8DeviceState".
     *
     * State of the device.
     *
     * @return The value of the field "e8DeviceState"
     */
    inline T_e8_MPlayDeviceStatus getE8DeviceState () const;

    /**
     * Sets the value of the member "e8DeviceState".
     *
     * State of the device.
     *
     * @param e8DeviceState The value which will be set
     */
    inline void setE8DeviceState (T_e8_MPlayDeviceStatus e8DeviceState_);

    // API of field "e8DeviceType"

    static const int kE8DeviceType = 7;

    /**
     * Clears the field "e8DeviceType".
     *
     * The field will be set to its default value. The hasE8DeviceType()
     * method will return false.
     */
    inline void clearE8DeviceType();

    /**
     * Checks whether the field "e8DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceType()). Otherwise it will return false.
     */
    inline bool hasE8DeviceType () const;

    /**
     * Returns the value of the member "e8DeviceType".
     *
     * Type of device on which the media object is stored.
     *
     * @return The value of the field "e8DeviceType"
     */
    inline T_e8_MPlayDeviceType getE8DeviceType () const;

    /**
     * Sets the value of the member "e8DeviceType".
     *
     * Type of device on which the media object is stored.
     *
     * @param e8DeviceType The value which will be set
     */
    inline void setE8DeviceType (T_e8_MPlayDeviceType e8DeviceType_);

    // API of field "e8DisconnectReason"

    static const int kE8DisconnectReason = 8;

    /**
     * Clears the field "e8DisconnectReason".
     *
     * The field will be set to its default value. The hasE8DisconnectReason()
     * method will return false.
     */
    inline void clearE8DisconnectReason();

    /**
     * Checks whether the field "e8DisconnectReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DisconnectReason()). Otherwise it will return false.
     */
    inline bool hasE8DisconnectReason () const;

    /**
     * Returns the value of the member "e8DisconnectReason".
     *
     * Reason of a device disconnection.
     *
     * @return The value of the field "e8DisconnectReason"
     */
    inline T_e8_MPlayDisconnectReason getE8DisconnectReason () const;

    /**
     * Sets the value of the member "e8DisconnectReason".
     *
     * Reason of a device disconnection.
     *
     * @param e8DisconnectReason The value which will be set
     */
    inline void setE8DisconnectReason (T_e8_MPlayDisconnectReason e8DisconnectReason_);

    // API of field "e8FileSystemType"

    static const int kE8FileSystemType = 9;

    /**
     * Clears the field "e8FileSystemType".
     *
     * The field will be set to its default value. The hasE8FileSystemType()
     * method will return false.
     */
    inline void clearE8FileSystemType();

    /**
     * Checks whether the field "e8FileSystemType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FileSystemType()). Otherwise it will return false.
     */
    inline bool hasE8FileSystemType () const;

    /**
     * Returns the value of the member "e8FileSystemType".
     *
     * File system type of the device.
     *
     * @return The value of the field "e8FileSystemType"
     */
    inline T_e8_MPlayFileSystemType getE8FileSystemType () const;

    /**
     * Sets the value of the member "e8FileSystemType".
     *
     * File system type of the device.
     *
     * @param e8FileSystemType The value which will be set
     */
    inline void setE8FileSystemType (T_e8_MPlayFileSystemType e8FileSystemType_);

    // API of field "bDeviceActiveSource"

    static const int kBDeviceActiveSource = 10;

    /**
     * Clears the field "bDeviceActiveSource".
     *
     * The field will be set to its default value. The hasBDeviceActiveSource()
     * method will return false.
     */
    inline void clearBDeviceActiveSource();

    /**
     * Checks whether the field "bDeviceActiveSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDeviceActiveSource()). Otherwise it will return false.
     */
    inline bool hasBDeviceActiveSource () const;

    /**
     * Returns the value of the member "bDeviceActiveSource".
     *
     * Identifies whether a connected device is the active media source. The value is "True" if the device is the active media source and the value is "False" if the device is not the active media source.
     *
     * @return The value of the field "bDeviceActiveSource"
     */
    inline bool getBDeviceActiveSource () const;

    /**
     * Sets the value of the member "bDeviceActiveSource".
     *
     * Identifies whether a connected device is the active media source. The value is "True" if the device is the active media source and the value is "False" if the device is not the active media source.
     *
     * @param bDeviceActiveSource The value which will be set
     */
    inline void setBDeviceActiveSource (bool bDeviceActiveSource_);

    // API of field "bDeviceConnected"

    static const int kBDeviceConnected = 11;

    /**
     * Clears the field "bDeviceConnected".
     *
     * The field will be set to its default value. The hasBDeviceConnected()
     * method will return false.
     */
    inline void clearBDeviceConnected();

    /**
     * Checks whether the field "bDeviceConnected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDeviceConnected()). Otherwise it will return false.
     */
    inline bool hasBDeviceConnected () const;

    /**
     * Returns the value of the member "bDeviceConnected".
     *
     * Indicates whether a device is currently connected to the vehicle. The value is "True" if the device is connected and "False" if the device is not connected.
     *
     * @return The value of the field "bDeviceConnected"
     */
    inline bool getBDeviceConnected () const;

    /**
     * Sets the value of the member "bDeviceConnected".
     *
     * Indicates whether a device is currently connected to the vehicle. The value is "True" if the device is connected and "False" if the device is not connected.
     *
     * @param bDeviceConnected The value which will be set
     */
    inline void setBDeviceConnected (bool bDeviceConnected_);

    // API of field "bIsNowPlayingListAvailable"

    static const int kBIsNowPlayingListAvailable = 12;

    /**
     * Clears the field "bIsNowPlayingListAvailable".
     *
     * The field will be set to its default value. The hasBIsNowPlayingListAvailable()
     * method will return false.
     */
    inline void clearBIsNowPlayingListAvailable();

    /**
     * Checks whether the field "bIsNowPlayingListAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsNowPlayingListAvailable()). Otherwise it will return false.
     */
    inline bool hasBIsNowPlayingListAvailable () const;

    /**
     * Returns the value of the member "bIsNowPlayingListAvailable".
     *
     * NowPlayingList availability of the device
     *
     * @return The value of the field "bIsNowPlayingListAvailable"
     */
    inline bool getBIsNowPlayingListAvailable () const;

    /**
     * Sets the value of the member "bIsNowPlayingListAvailable".
     *
     * NowPlayingList availability of the device
     *
     * @param bIsNowPlayingListAvailable The value which will be set
     */
    inline void setBIsNowPlayingListAvailable (bool bIsNowPlayingListAvailable_);

    // API of field "bRepeatSupported"

    static const int kBRepeatSupported = 13;

    /**
     * Clears the field "bRepeatSupported".
     *
     * The field will be set to its default value. The hasBRepeatSupported()
     * method will return false.
     */
    inline void clearBRepeatSupported();

    /**
     * Checks whether the field "bRepeatSupported" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRepeatSupported()). Otherwise it will return false.
     */
    inline bool hasBRepeatSupported () const;

    /**
     * Returns the value of the member "bRepeatSupported".
     *
     * Indicates whether a device supports Repeat. The value is "True" if the device Supports it and "False" if the device if it doesnt Support
     *
     * @return The value of the field "bRepeatSupported"
     */
    inline bool getBRepeatSupported () const;

    /**
     * Sets the value of the member "bRepeatSupported".
     *
     * Indicates whether a device supports Repeat. The value is "True" if the device Supports it and "False" if the device if it doesnt Support
     *
     * @param bRepeatSupported The value which will be set
     */
    inline void setBRepeatSupported (bool bRepeatSupported_);

    // API of field "bScanSupported"

    static const int kBScanSupported = 14;

    /**
     * Clears the field "bScanSupported".
     *
     * The field will be set to its default value. The hasBScanSupported()
     * method will return false.
     */
    inline void clearBScanSupported();

    /**
     * Checks whether the field "bScanSupported" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBScanSupported()). Otherwise it will return false.
     */
    inline bool hasBScanSupported () const;

    /**
     * Returns the value of the member "bScanSupported".
     *
     * Identifies whether the device Supports scan feature.The value is "True" if the device supports scan feature and the value is "False" if the device doesn't supports scan feature
     *
     * @return The value of the field "bScanSupported"
     */
    inline bool getBScanSupported () const;

    /**
     * Sets the value of the member "bScanSupported".
     *
     * Identifies whether the device Supports scan feature.The value is "True" if the device supports scan feature and the value is "False" if the device doesn't supports scan feature
     *
     * @param bScanSupported The value which will be set
     */
    inline void setBScanSupported (bool bScanSupported_);

    // API of field "bShuffleSupported"

    static const int kBShuffleSupported = 15;

    /**
     * Clears the field "bShuffleSupported".
     *
     * The field will be set to its default value. The hasBShuffleSupported()
     * method will return false.
     */
    inline void clearBShuffleSupported();

    /**
     * Checks whether the field "bShuffleSupported" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBShuffleSupported()). Otherwise it will return false.
     */
    inline bool hasBShuffleSupported () const;

    /**
     * Returns the value of the member "bShuffleSupported".
     *
     * Indicates whether a device supports Shuffle. The value is "True" if the device Supports it and "False" if the device if it doesnt Support .
     *
     * @return The value of the field "bShuffleSupported"
     */
    inline bool getBShuffleSupported () const;

    /**
     * Sets the value of the member "bShuffleSupported".
     *
     * Indicates whether a device supports Shuffle. The value is "True" if the device Supports it and "False" if the device if it doesnt Support .
     *
     * @param bShuffleSupported The value which will be set
     */
    inline void setBShuffleSupported (bool bShuffleSupported_);

    // API of field "sDeviceName"

    static const int kSDeviceName = 16;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * Name of the device (friendly name)
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::std::string& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::std::string& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the device (friendly name)
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::std::string& sDeviceName_);

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the device (friendly name)
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const char* sDeviceName_);

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the device (friendly name)
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const char* value, size_t size);

    // API of field "sDeviceSerialNumber"

    static const int kSDeviceSerialNumber = 17;

    /**
     * Clears the field "sDeviceSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceSerialNumber();

    /**
     * Checks whether the field "sDeviceSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceSerialNumber".
     *
     * The serial number (or other device-specific unique identifer) of the device
     *
     * @return The value of the field "sDeviceSerialNumber"
     */
    inline const ::std::string& getSDeviceSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceSerialNumber".
     */
    inline ::std::string& getSDeviceSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceSerialNumber".
     *
     * The serial number (or other device-specific unique identifer) of the device
     *
     * @param sDeviceSerialNumber The value which will be set
     */
    inline void setSDeviceSerialNumber (const ::std::string& sDeviceSerialNumber_);

    /**
     * Sets the value of the member "sDeviceSerialNumber".
     *
     * The serial number (or other device-specific unique identifer) of the device
     *
     * @param sDeviceSerialNumber The value which will be set
     */
    inline void setSDeviceSerialNumber (const char* sDeviceSerialNumber_);

    /**
     * Sets the value of the member "sDeviceSerialNumber".
     *
     * The serial number (or other device-specific unique identifer) of the device
     *
     * @param sDeviceSerialNumber The value which will be set
     */
    inline void setSDeviceSerialNumber (const char* value, size_t size);

    // API of field "sDeviceSysPath"

    static const int kSDeviceSysPath = 18;

    /**
     * Clears the field "sDeviceSysPath".
     *
     * The field will be set to its default value. The hasSDeviceSysPath()
     * method will return false.
     */
    inline void clearSDeviceSysPath();

    /**
     * Checks whether the field "sDeviceSysPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceSysPath()). Otherwise it will return false.
     */
    inline bool hasSDeviceSysPath () const;

    /**
     * Returns the value of the member "sDeviceSysPath".
     *
     * Device Syspath of the device connected in port
     *
     * @return The value of the field "sDeviceSysPath"
     */
    inline const ::std::string& getSDeviceSysPath () const;

    /**
     * Retrieves the value of the field "sDeviceSysPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceSysPath".
     */
    inline ::std::string& getSDeviceSysPathMutable ();

    /**
     * Sets the value of the member "sDeviceSysPath".
     *
     * Device Syspath of the device connected in port
     *
     * @param sDeviceSysPath The value which will be set
     */
    inline void setSDeviceSysPath (const ::std::string& sDeviceSysPath_);

    /**
     * Sets the value of the member "sDeviceSysPath".
     *
     * Device Syspath of the device connected in port
     *
     * @param sDeviceSysPath The value which will be set
     */
    inline void setSDeviceSysPath (const char* sDeviceSysPath_);

    /**
     * Sets the value of the member "sDeviceSysPath".
     *
     * Device Syspath of the device connected in port
     *
     * @param sDeviceSysPath The value which will be set
     */
    inline void setSDeviceSysPath (const char* value, size_t size);

    // API of field "sDeviceVersion"

    static const int kSDeviceVersion = 19;

    /**
     * Clears the field "sDeviceVersion".
     *
     * The field will be set to its default value. The hasSDeviceVersion()
     * method will return false.
     */
    inline void clearSDeviceVersion();

    /**
     * Checks whether the field "sDeviceVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceVersion()). Otherwise it will return false.
     */
    inline bool hasSDeviceVersion () const;

    /**
     * Returns the value of the member "sDeviceVersion".
     *
     * The firmware version of the device inserted or removed from the system
     *
     * @return The value of the field "sDeviceVersion"
     */
    inline const ::std::string& getSDeviceVersion () const;

    /**
     * Retrieves the value of the field "sDeviceVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceVersion".
     */
    inline ::std::string& getSDeviceVersionMutable ();

    /**
     * Sets the value of the member "sDeviceVersion".
     *
     * The firmware version of the device inserted or removed from the system
     *
     * @param sDeviceVersion The value which will be set
     */
    inline void setSDeviceVersion (const ::std::string& sDeviceVersion_);

    /**
     * Sets the value of the member "sDeviceVersion".
     *
     * The firmware version of the device inserted or removed from the system
     *
     * @param sDeviceVersion The value which will be set
     */
    inline void setSDeviceVersion (const char* sDeviceVersion_);

    /**
     * Sets the value of the member "sDeviceVersion".
     *
     * The firmware version of the device inserted or removed from the system
     *
     * @param sDeviceVersion The value which will be set
     */
    inline void setSDeviceVersion (const char* value, size_t size);

    // API of field "sLastPlayedFile"

    static const int kSLastPlayedFile = 20;

    /**
     * Clears the field "sLastPlayedFile".
     *
     * The field will be set to its default value. The hasSLastPlayedFile()
     * method will return false.
     */
    inline void clearSLastPlayedFile();

    /**
     * Checks whether the field "sLastPlayedFile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLastPlayedFile()). Otherwise it will return false.
     */
    inline bool hasSLastPlayedFile () const;

    /**
     * Returns the value of the member "sLastPlayedFile".
     *
     * Filename and path of the last played media object. This information is not available for all device types.
     *
     * @return The value of the field "sLastPlayedFile"
     */
    inline const ::std::string& getSLastPlayedFile () const;

    /**
     * Retrieves the value of the field "sLastPlayedFile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLastPlayedFile".
     */
    inline ::std::string& getSLastPlayedFileMutable ();

    /**
     * Sets the value of the member "sLastPlayedFile".
     *
     * Filename and path of the last played media object. This information is not available for all device types.
     *
     * @param sLastPlayedFile The value which will be set
     */
    inline void setSLastPlayedFile (const ::std::string& sLastPlayedFile_);

    /**
     * Sets the value of the member "sLastPlayedFile".
     *
     * Filename and path of the last played media object. This information is not available for all device types.
     *
     * @param sLastPlayedFile The value which will be set
     */
    inline void setSLastPlayedFile (const char* sLastPlayedFile_);

    /**
     * Sets the value of the member "sLastPlayedFile".
     *
     * Filename and path of the last played media object. This information is not available for all device types.
     *
     * @param sLastPlayedFile The value which will be set
     */
    inline void setSLastPlayedFile (const char* value, size_t size);

    // API of field "sMountPoint"

    static const int kSMountPoint = 21;

    /**
     * Clears the field "sMountPoint".
     *
     * The field will be set to its default value. The hasSMountPoint()
     * method will return false.
     */
    inline void clearSMountPoint();

    /**
     * Checks whether the field "sMountPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMountPoint()). Otherwise it will return false.
     */
    inline bool hasSMountPoint () const;

    /**
     * Returns the value of the member "sMountPoint".
     *
     * Mount point of the device
     *
     * @return The value of the field "sMountPoint"
     */
    inline const ::std::string& getSMountPoint () const;

    /**
     * Retrieves the value of the field "sMountPoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMountPoint".
     */
    inline ::std::string& getSMountPointMutable ();

    /**
     * Sets the value of the member "sMountPoint".
     *
     * Mount point of the device
     *
     * @param sMountPoint The value which will be set
     */
    inline void setSMountPoint (const ::std::string& sMountPoint_);

    /**
     * Sets the value of the member "sMountPoint".
     *
     * Mount point of the device
     *
     * @param sMountPoint The value which will be set
     */
    inline void setSMountPoint (const char* sMountPoint_);

    /**
     * Sets the value of the member "sMountPoint".
     *
     * Mount point of the device
     *
     * @param sMountPoint The value which will be set
     */
    inline void setSMountPoint (const char* value, size_t size);

    // API of field "u32FreeSize"

    static const int kU32FreeSize = 22;

    /**
     * Clears the field "u32FreeSize".
     *
     * The field will be set to its default value. The hasU32FreeSize()
     * method will return false.
     */
    inline void clearU32FreeSize();

    /**
     * Checks whether the field "u32FreeSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FreeSize()). Otherwise it will return false.
     */
    inline bool hasU32FreeSize () const;

    /**
     * Returns the value of the member "u32FreeSize".
     *
     * Free size of device in KByte.
     *
     * @return The value of the field "u32FreeSize"
     */
    inline uint32 getU32FreeSize () const;

    /**
     * Sets the value of the member "u32FreeSize".
     *
     * Free size of device in KByte.
     *
     * @param u32FreeSize The value which will be set
     */
    inline void setU32FreeSize (uint32 u32FreeSize_);

    // API of field "u32NumberOfFiles"

    static const int kU32NumberOfFiles = 23;

    /**
     * Clears the field "u32NumberOfFiles".
     *
     * The field will be set to its default value. The hasU32NumberOfFiles()
     * method will return false.
     */
    inline void clearU32NumberOfFiles();

    /**
     * Checks whether the field "u32NumberOfFiles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumberOfFiles()). Otherwise it will return false.
     */
    inline bool hasU32NumberOfFiles () const;

    /**
     * Returns the value of the member "u32NumberOfFiles".
     *
     * number of playable files on medium or -1 (0xFFFFFFFF) if number is unknown.
     *
     * @return The value of the field "u32NumberOfFiles"
     */
    inline uint32 getU32NumberOfFiles () const;

    /**
     * Sets the value of the member "u32NumberOfFiles".
     *
     * number of playable files on medium or -1 (0xFFFFFFFF) if number is unknown.
     *
     * @param u32NumberOfFiles The value which will be set
     */
    inline void setU32NumberOfFiles (uint32 u32NumberOfFiles_);

    // API of field "u32NumberOfImageFiles"

    static const int kU32NumberOfImageFiles = 24;

    /**
     * Clears the field "u32NumberOfImageFiles".
     *
     * The field will be set to its default value. The hasU32NumberOfImageFiles()
     * method will return false.
     */
    inline void clearU32NumberOfImageFiles();

    /**
     * Checks whether the field "u32NumberOfImageFiles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumberOfImageFiles()). Otherwise it will return false.
     */
    inline bool hasU32NumberOfImageFiles () const;

    /**
     * Returns the value of the member "u32NumberOfImageFiles".
     *
     * number of Image files on medium or -1 (0xFFFFFFFF) if number is unknown.
     *
     * @return The value of the field "u32NumberOfImageFiles"
     */
    inline uint32 getU32NumberOfImageFiles () const;

    /**
     * Sets the value of the member "u32NumberOfImageFiles".
     *
     * number of Image files on medium or -1 (0xFFFFFFFF) if number is unknown.
     *
     * @param u32NumberOfImageFiles The value which will be set
     */
    inline void setU32NumberOfImageFiles (uint32 u32NumberOfImageFiles_);

    // API of field "u32NumberOfVideoFiles"

    static const int kU32NumberOfVideoFiles = 25;

    /**
     * Clears the field "u32NumberOfVideoFiles".
     *
     * The field will be set to its default value. The hasU32NumberOfVideoFiles()
     * method will return false.
     */
    inline void clearU32NumberOfVideoFiles();

    /**
     * Checks whether the field "u32NumberOfVideoFiles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumberOfVideoFiles()). Otherwise it will return false.
     */
    inline bool hasU32NumberOfVideoFiles () const;

    /**
     * Returns the value of the member "u32NumberOfVideoFiles".
     *
     * number of video playable files on medium or -1 (0xFFFFFFFF) if number is unknown.
     *
     * @return The value of the field "u32NumberOfVideoFiles"
     */
    inline uint32 getU32NumberOfVideoFiles () const;

    /**
     * Sets the value of the member "u32NumberOfVideoFiles".
     *
     * number of video playable files on medium or -1 (0xFFFFFFFF) if number is unknown.
     *
     * @param u32NumberOfVideoFiles The value which will be set
     */
    inline void setU32NumberOfVideoFiles (uint32 u32NumberOfVideoFiles_);

    // API of field "u32PartitionNumber"

    static const int kU32PartitionNumber = 26;

    /**
     * Clears the field "u32PartitionNumber".
     *
     * The field will be set to its default value. The hasU32PartitionNumber()
     * method will return false.
     */
    inline void clearU32PartitionNumber();

    /**
     * Checks whether the field "u32PartitionNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PartitionNumber()). Otherwise it will return false.
     */
    inline bool hasU32PartitionNumber () const;

    /**
     * Returns the value of the member "u32PartitionNumber".
     *
     * Partition number.
     *
     * @return The value of the field "u32PartitionNumber"
     */
    inline uint32 getU32PartitionNumber () const;

    /**
     * Sets the value of the member "u32PartitionNumber".
     *
     * Partition number.
     *
     * @param u32PartitionNumber The value which will be set
     */
    inline void setU32PartitionNumber (uint32 u32PartitionNumber_);

    // API of field "u32TotalSize"

    static const int kU32TotalSize = 27;

    /**
     * Clears the field "u32TotalSize".
     *
     * The field will be set to its default value. The hasU32TotalSize()
     * method will return false.
     */
    inline void clearU32TotalSize();

    /**
     * Checks whether the field "u32TotalSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TotalSize()). Otherwise it will return false.
     */
    inline bool hasU32TotalSize () const;

    /**
     * Returns the value of the member "u32TotalSize".
     *
     * Total size of device in KByte.
     *
     * @return The value of the field "u32TotalSize"
     */
    inline uint32 getU32TotalSize () const;

    /**
     * Sets the value of the member "u32TotalSize".
     *
     * Total size of device in KByte.
     *
     * @param u32TotalSize The value which will be set
     */
    inline void setU32TotalSize (uint32 u32TotalSize_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 28;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored. Actual physical devices are numbered starting with DeviceTag=0x01. DeviceTag of 0x00 is reserved as a virtual &quot;My Media&quot; device representing aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored. Actual physical devices are numbered starting with DeviceTag=0x01. DeviceTag of 0x00 is reserved as a virtual &quot;My Media&quot; device representing aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "DeviceDBViewStatus"

    static const int kDeviceDBViewStatus = 29;

    /**
     * Clears the field "DeviceDBViewStatus".
     *
     * The field will be set to its default value. The hasDeviceDBViewStatus()
     * method will return false.
     */
    inline void clearDeviceDBViewStatus();

    /**
     * Checks whether the field "DeviceDBViewStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceDBViewStatus()). Otherwise it will return false.
     */
    inline bool hasDeviceDBViewStatus () const;

    /**
     * Returns the value of the member "DeviceDBViewStatus".
     *
     * This parameter is used by Speech , it is designed only for gen4 based systems.
     * Identifies the status of the DB Views created for the particular device.
     * If set to DB_VIEW_STATUS_DONT_CARE means , This parameter need not be validated
     * If set to DB_VIEW_STATUS_NOT_AVAILABLE means , indexing is not started/on-going/completed but DB Views are not yet loaded with required data
     * If set to DB_VIEW_STATUS_AVAILABLE means , indexing is completed and DB Views are available with required data of connected device
     *
     * @return The value of the field "DeviceDBViewStatus"
     */
    inline T_e_MPlayDeviceDBViewStatus getDeviceDBViewStatus () const;

    /**
     * Sets the value of the member "DeviceDBViewStatus".
     *
     * This parameter is used by Speech , it is designed only for gen4 based systems.
     * Identifies the status of the DB Views created for the particular device.
     * If set to DB_VIEW_STATUS_DONT_CARE means , This parameter need not be validated
     * If set to DB_VIEW_STATUS_NOT_AVAILABLE means , indexing is not started/on-going/completed but DB Views are not yet loaded with required data
     * If set to DB_VIEW_STATUS_AVAILABLE means , indexing is completed and DB Views are available with required data of connected device
     *
     * @param DeviceDBViewStatus The value which will be set
     */
    inline void setDeviceDBViewStatus (T_e_MPlayDeviceDBViewStatus DeviceDBViewStatus_);

    static const T_MPlayDeviceInfoItem &getDefaultInstance();

private:

    inline void set_has_e8DiscType ();

    inline void clear_has_e8DiscType ();

    inline void set_has_e8AvailabilityReason ();

    inline void clear_has_e8AvailabilityReason ();

    inline void set_has_e8ConnectionState ();

    inline void clear_has_e8ConnectionState ();

    inline void set_has_e8ConnectionType ();

    inline void clear_has_e8ConnectionType ();

    inline void set_has_e8DeviceControlSupport ();

    inline void clear_has_e8DeviceControlSupport ();

    inline void set_has_e8DeviceIndexedState ();

    inline void clear_has_e8DeviceIndexedState ();

    inline void set_has_e8DeviceState ();

    inline void clear_has_e8DeviceState ();

    inline void set_has_e8DeviceType ();

    inline void clear_has_e8DeviceType ();

    inline void set_has_e8DisconnectReason ();

    inline void clear_has_e8DisconnectReason ();

    inline void set_has_e8FileSystemType ();

    inline void clear_has_e8FileSystemType ();

    inline void set_has_bDeviceActiveSource ();

    inline void clear_has_bDeviceActiveSource ();

    inline void set_has_bDeviceConnected ();

    inline void clear_has_bDeviceConnected ();

    inline void set_has_bIsNowPlayingListAvailable ();

    inline void clear_has_bIsNowPlayingListAvailable ();

    inline void set_has_bRepeatSupported ();

    inline void clear_has_bRepeatSupported ();

    inline void set_has_bScanSupported ();

    inline void clear_has_bScanSupported ();

    inline void set_has_bShuffleSupported ();

    inline void clear_has_bShuffleSupported ();

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    inline void set_has_sDeviceSerialNumber ();

    inline void clear_has_sDeviceSerialNumber ();

    inline void set_has_sDeviceSysPath ();

    inline void clear_has_sDeviceSysPath ();

    inline void set_has_sDeviceVersion ();

    inline void clear_has_sDeviceVersion ();

    inline void set_has_sLastPlayedFile ();

    inline void clear_has_sLastPlayedFile ();

    inline void set_has_sMountPoint ();

    inline void clear_has_sMountPoint ();

    inline void set_has_u32FreeSize ();

    inline void clear_has_u32FreeSize ();

    inline void set_has_u32NumberOfFiles ();

    inline void clear_has_u32NumberOfFiles ();

    inline void set_has_u32NumberOfImageFiles ();

    inline void clear_has_u32NumberOfImageFiles ();

    inline void set_has_u32NumberOfVideoFiles ();

    inline void clear_has_u32NumberOfVideoFiles ();

    inline void set_has_u32PartitionNumber ();

    inline void clear_has_u32PartitionNumber ();

    inline void set_has_u32TotalSize ();

    inline void clear_has_u32TotalSize ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_DeviceDBViewStatus ();

    inline void clear_has_DeviceDBViewStatus ();

    uint32 _has_bits_[ (30 + 31) / 32];

    T_e8_MDiscType _e8DiscType;

    T_e8_MPlayAvailabilityReason _e8AvailabilityReason;

    T_e8_MPlayConnectionState _e8ConnectionState;

    T_e8_MPlayConnectionType _e8ConnectionType;

    T_e8_MPlayDeviceControlSupport _e8DeviceControlSupport;

    T_e8_MPlayDeviceIndexedState _e8DeviceIndexedState;

    T_e8_MPlayDeviceStatus _e8DeviceState;

    T_e8_MPlayDeviceType _e8DeviceType;

    T_e8_MPlayDisconnectReason _e8DisconnectReason;

    T_e8_MPlayFileSystemType _e8FileSystemType;

    bool _bDeviceActiveSource;

    bool _bDeviceConnected;

    bool _bIsNowPlayingListAvailable;

    bool _bRepeatSupported;

    bool _bScanSupported;

    bool _bShuffleSupported;

    ::std::string _sDeviceName;

    ::std::string _sDeviceSerialNumber;

    ::std::string _sDeviceSysPath;

    ::std::string _sDeviceVersion;

    ::std::string _sLastPlayedFile;

    ::std::string _sMountPoint;

    uint32 _u32FreeSize;

    uint32 _u32NumberOfFiles;

    uint32 _u32NumberOfImageFiles;

    uint32 _u32NumberOfVideoFiles;

    uint32 _u32PartitionNumber;

    uint32 _u32TotalSize;

    uint8 _u8DeviceTag;

    T_e_MPlayDeviceDBViewStatus _DeviceDBViewStatus;

};

/**
 * FileType, TrackNumber, Filename, FileFormat, IsPlaying, PlayableStatus
 */
class T_MPlayFileListItem {
public:

    /**
     * Default constructor
     */
    inline  T_MPlayFileListItem ();

    /**
     * Copy constructor
     */
    inline  T_MPlayFileListItem (const T_MPlayFileListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MPlayFileListItem (T_e8_MPlayFileFormat e8FileFormat_, T_e8_MPlayFileType e8FileType_, T_e8_MPlayPlayableStatus e8PlayableStatus_, bool bIsPlaying_, bool bReadOnlyFlag_, const ::std::string& sFilename_, uint32 u32Tag_, uint8 u8TrackNumber_, const ::std::string& sDateTime_, uint32 u32TotalPlaytime_, uint64 u64FileSize_, const ::std::string& sCoverArt_, uint64 Tag_, uint64 ParentTag_);

    /**
     * Destructor
     */
    inline  ~T_MPlayFileListItem();

    /**
     * Assignment operator
     */
    inline T_MPlayFileListItem& operator = (const T_MPlayFileListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MPlayFileListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MPlayFileListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MPlayFileListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MPlayFileListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8FileFormat"

    static const int kE8FileFormat = 0;

    /**
     * Clears the field "e8FileFormat".
     *
     * The field will be set to its default value. The hasE8FileFormat()
     * method will return false.
     */
    inline void clearE8FileFormat();

    /**
     * Checks whether the field "e8FileFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FileFormat()). Otherwise it will return false.
     */
    inline bool hasE8FileFormat () const;

    /**
     * Returns the value of the member "e8FileFormat".
     *
     * The format of a media file.
     *
     * @return The value of the field "e8FileFormat"
     */
    inline T_e8_MPlayFileFormat getE8FileFormat () const;

    /**
     * Sets the value of the member "e8FileFormat".
     *
     * The format of a media file.
     *
     * @param e8FileFormat The value which will be set
     */
    inline void setE8FileFormat (T_e8_MPlayFileFormat e8FileFormat_);

    // API of field "e8FileType"

    static const int kE8FileType = 1;

    /**
     * Clears the field "e8FileType".
     *
     * The field will be set to its default value. The hasE8FileType()
     * method will return false.
     */
    inline void clearE8FileType();

    /**
     * Checks whether the field "e8FileType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FileType()). Otherwise it will return false.
     */
    inline bool hasE8FileType () const;

    /**
     * Returns the value of the member "e8FileType".
     *
     * FileType identifies the object type of an itme in the filesystem. IF the object is of type FT_AUDIO or FT_VIDEO, it can be played. If the object is of type FT_FOLDER, it can be browsed.
     *
     * @return The value of the field "e8FileType"
     */
    inline T_e8_MPlayFileType getE8FileType () const;

    /**
     * Sets the value of the member "e8FileType".
     *
     * FileType identifies the object type of an itme in the filesystem. IF the object is of type FT_AUDIO or FT_VIDEO, it can be played. If the object is of type FT_FOLDER, it can be browsed.
     *
     * @param e8FileType The value which will be set
     */
    inline void setE8FileType (T_e8_MPlayFileType e8FileType_);

    // API of field "e8PlayableStatus"

    static const int kE8PlayableStatus = 2;

    /**
     * Clears the field "e8PlayableStatus".
     *
     * The field will be set to its default value. The hasE8PlayableStatus()
     * method will return false.
     */
    inline void clearE8PlayableStatus();

    /**
     * Checks whether the field "e8PlayableStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlayableStatus()). Otherwise it will return false.
     */
    inline bool hasE8PlayableStatus () const;

    /**
     * Returns the value of the member "e8PlayableStatus".
     *
     * Playable status of song.
     *
     * @return The value of the field "e8PlayableStatus"
     */
    inline T_e8_MPlayPlayableStatus getE8PlayableStatus () const;

    /**
     * Sets the value of the member "e8PlayableStatus".
     *
     * Playable status of song.
     *
     * @param e8PlayableStatus The value which will be set
     */
    inline void setE8PlayableStatus (T_e8_MPlayPlayableStatus e8PlayableStatus_);

    // API of field "bIsPlaying"

    static const int kBIsPlaying = 3;

    /**
     * Clears the field "bIsPlaying".
     *
     * The field will be set to its default value. The hasBIsPlaying()
     * method will return false.
     */
    inline void clearBIsPlaying();

    /**
     * Checks whether the field "bIsPlaying" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsPlaying()). Otherwise it will return false.
     */
    inline bool hasBIsPlaying () const;

    /**
     * Returns the value of the member "bIsPlaying".
     *
     * Defines whether the media object is currently being played. This parameter is True when the media object is currently being played and False otherwise.
     *
     * @return The value of the field "bIsPlaying"
     */
    inline bool getBIsPlaying () const;

    /**
     * Sets the value of the member "bIsPlaying".
     *
     * Defines whether the media object is currently being played. This parameter is True when the media object is currently being played and False otherwise.
     *
     * @param bIsPlaying The value which will be set
     */
    inline void setBIsPlaying (bool bIsPlaying_);

    // API of field "bReadOnlyFlag"

    static const int kBReadOnlyFlag = 4;

    /**
     * Clears the field "bReadOnlyFlag".
     *
     * The field will be set to its default value. The hasBReadOnlyFlag()
     * method will return false.
     */
    inline void clearBReadOnlyFlag();

    /**
     * Checks whether the field "bReadOnlyFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBReadOnlyFlag()). Otherwise it will return false.
     */
    inline bool hasBReadOnlyFlag () const;

    /**
     * Returns the value of the member "bReadOnlyFlag".
     *
     * File is neither writable nor deletable, hence read only
     *
     * @return The value of the field "bReadOnlyFlag"
     */
    inline bool getBReadOnlyFlag () const;

    /**
     * Sets the value of the member "bReadOnlyFlag".
     *
     * File is neither writable nor deletable, hence read only
     *
     * @param bReadOnlyFlag The value which will be set
     */
    inline void setBReadOnlyFlag (bool bReadOnlyFlag_);

    // API of field "sFilename"

    static const int kSFilename = 5;

    /**
     * Clears the field "sFilename".
     *
     * The field will be set to its default value. The hasSFilename()
     * method will return false.
     */
    inline void clearSFilename();

    /**
     * Checks whether the field "sFilename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFilename()). Otherwise it will return false.
     */
    inline bool hasSFilename () const;

    /**
     * Returns the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @return The value of the field "sFilename"
     */
    inline const ::std::string& getSFilename () const;

    /**
     * Retrieves the value of the field "sFilename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFilename".
     */
    inline ::std::string& getSFilenameMutable ();

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const ::std::string& sFilename_);

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const char* sFilename_);

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const char* value, size_t size);

    // API of field "u32Tag"

    static const int kU32Tag = 6;

    /**
     * Clears the field "u32Tag".
     *
     * The field will be set to its default value. The hasU32Tag()
     * method will return false.
     */
    inline void clearU32Tag();

    /**
     * Checks whether the field "u32Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Tag()). Otherwise it will return false.
     */
    inline bool hasU32Tag () const;

    /**
     * Returns the value of the member "u32Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value identifies the media object to play.
     * Note:DEPRECATED IN 64 BIT PLATFORM. Tag should be used instead.
     *
     * @return The value of the field "u32Tag"
     */
    inline uint32 getU32Tag () const;

    /**
     * Sets the value of the member "u32Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value identifies the media object to play.
     * Note:DEPRECATED IN 64 BIT PLATFORM. Tag should be used instead.
     *
     * @param u32Tag The value which will be set
     */
    inline void setU32Tag (uint32 u32Tag_);

    // API of field "u8TrackNumber"

    static const int kU8TrackNumber = 7;

    /**
     * Clears the field "u8TrackNumber".
     *
     * The field will be set to its default value. The hasU8TrackNumber()
     * method will return false.
     */
    inline void clearU8TrackNumber();

    /**
     * Checks whether the field "u8TrackNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TrackNumber()). Otherwise it will return false.
     */
    inline bool hasU8TrackNumber () const;

    /**
     * Returns the value of the member "u8TrackNumber".
     *
     * deprecatedThis parameter was incorrectly defined as a single byte instead of a word during the 1.X MY13 development. All new designs shall use the 16-bit ExtendedTrackNumber (added at 2.4.3 for MY14) instead.This parameter shall be set as follows (in order to handle the restricted range of a byte): <item> If the media object's track number is = 255, then TrackNumber shall be set to the track number. </item> <item> >If the media object's track number is > 255, then the TrackNumber shall be set to the track number shall be set to 0. </item> In all cases, the 16-bit ExtendedTrackNumber shall be set to the media object's track number (if present, of course, in the media object's meta-data).
     *
     * @return The value of the field "u8TrackNumber"
     */
    inline uint8 getU8TrackNumber () const;

    /**
     * Sets the value of the member "u8TrackNumber".
     *
     * deprecatedThis parameter was incorrectly defined as a single byte instead of a word during the 1.X MY13 development. All new designs shall use the 16-bit ExtendedTrackNumber (added at 2.4.3 for MY14) instead.This parameter shall be set as follows (in order to handle the restricted range of a byte): <item> If the media object's track number is = 255, then TrackNumber shall be set to the track number. </item> <item> >If the media object's track number is > 255, then the TrackNumber shall be set to the track number shall be set to 0. </item> In all cases, the 16-bit ExtendedTrackNumber shall be set to the media object's track number (if present, of course, in the media object's meta-data).
     *
     * @param u8TrackNumber The value which will be set
     */
    inline void setU8TrackNumber (uint8 u8TrackNumber_);

    // API of field "sDateTime"

    static const int kSDateTime = 8;

    /**
     * Clears the field "sDateTime".
     *
     * The field will be set to its default value. The hasSDateTime()
     * method will return false.
     */
    inline void clearSDateTime();

    /**
     * Checks whether the field "sDateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDateTime()). Otherwise it will return false.
     */
    inline bool hasSDateTime () const;

    /**
     * Returns the value of the member "sDateTime".
     *
     * Last file modification date and time in Y:m:d H:M:S
     *
     * @return The value of the field "sDateTime"
     */
    inline const ::std::string& getSDateTime () const;

    /**
     * Retrieves the value of the field "sDateTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDateTime".
     */
    inline ::std::string& getSDateTimeMutable ();

    /**
     * Sets the value of the member "sDateTime".
     *
     * Last file modification date and time in Y:m:d H:M:S
     *
     * @param sDateTime The value which will be set
     */
    inline void setSDateTime (const ::std::string& sDateTime_);

    /**
     * Sets the value of the member "sDateTime".
     *
     * Last file modification date and time in Y:m:d H:M:S
     *
     * @param sDateTime The value which will be set
     */
    inline void setSDateTime (const char* sDateTime_);

    /**
     * Sets the value of the member "sDateTime".
     *
     * Last file modification date and time in Y:m:d H:M:S
     *
     * @param sDateTime The value which will be set
     */
    inline void setSDateTime (const char* value, size_t size);

    // API of field "u32TotalPlaytime"

    static const int kU32TotalPlaytime = 9;

    /**
     * Clears the field "u32TotalPlaytime".
     *
     * The field will be set to its default value. The hasU32TotalPlaytime()
     * method will return false.
     */
    inline void clearU32TotalPlaytime();

    /**
     * Checks whether the field "u32TotalPlaytime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TotalPlaytime()). Otherwise it will return false.
     */
    inline bool hasU32TotalPlaytime () const;

    /**
     * Returns the value of the member "u32TotalPlaytime".
     *
     * Total playtime of the media object in seconds.
     *
     * @return The value of the field "u32TotalPlaytime"
     */
    inline uint32 getU32TotalPlaytime () const;

    /**
     * Sets the value of the member "u32TotalPlaytime".
     *
     * Total playtime of the media object in seconds.
     *
     * @param u32TotalPlaytime The value which will be set
     */
    inline void setU32TotalPlaytime (uint32 u32TotalPlaytime_);

    // API of field "u64FileSize"

    static const int kU64FileSize = 10;

    /**
     * Clears the field "u64FileSize".
     *
     * The field will be set to its default value. The hasU64FileSize()
     * method will return false.
     */
    inline void clearU64FileSize();

    /**
     * Checks whether the field "u64FileSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64FileSize()). Otherwise it will return false.
     */
    inline bool hasU64FileSize () const;

    /**
     * Returns the value of the member "u64FileSize".
     *
     * File size in Byte
     *
     * @return The value of the field "u64FileSize"
     */
    inline uint64 getU64FileSize () const;

    /**
     * Sets the value of the member "u64FileSize".
     *
     * File size in Byte
     *
     * @param u64FileSize The value which will be set
     */
    inline void setU64FileSize (uint64 u64FileSize_);

    // API of field "sCoverArt"

    static const int kSCoverArt = 11;

    /**
     * Clears the field "sCoverArt".
     *
     * The field will be set to its default value. The hasSCoverArt()
     * method will return false.
     */
    inline void clearSCoverArt();

    /**
     * Checks whether the field "sCoverArt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCoverArt()). Otherwise it will return false.
     */
    inline bool hasSCoverArt () const;

    /**
     * Returns the value of the member "sCoverArt".
     *
     * Path to a cover art image on the flash
     *
     * @return The value of the field "sCoverArt"
     */
    inline const ::std::string& getSCoverArt () const;

    /**
     * Retrieves the value of the field "sCoverArt" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCoverArt".
     */
    inline ::std::string& getSCoverArtMutable ();

    /**
     * Sets the value of the member "sCoverArt".
     *
     * Path to a cover art image on the flash
     *
     * @param sCoverArt The value which will be set
     */
    inline void setSCoverArt (const ::std::string& sCoverArt_);

    /**
     * Sets the value of the member "sCoverArt".
     *
     * Path to a cover art image on the flash
     *
     * @param sCoverArt The value which will be set
     */
    inline void setSCoverArt (const char* sCoverArt_);

    /**
     * Sets the value of the member "sCoverArt".
     *
     * Path to a cover art image on the flash
     *
     * @param sCoverArt The value which will be set
     */
    inline void setSCoverArt (const char* value, size_t size);

    // API of field "Tag"

    static const int kTag = 12;

    /**
     * Clears the field "Tag".
     *
     * The field will be set to its default value. The hasTag()
     * method will return false.
     */
    inline void clearTag();

    /**
     * Checks whether the field "Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTag()). Otherwise it will return false.
     */
    inline bool hasTag () const;

    /**
     * Returns the value of the member "Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value identifies the media object to play.
     * This field should be used to update tag value on a 64-bit platform and will replace u32Tag param.
     *
     * @return The value of the field "Tag"
     */
    inline uint64 getTag () const;

    /**
     * Sets the value of the member "Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value identifies the media object to play.
     * This field should be used to update tag value on a 64-bit platform and will replace u32Tag param.
     *
     * @param Tag The value which will be set
     */
    inline void setTag (uint64 Tag_);

    // API of field "ParentTag"

    static const int kParentTag = 13;

    /**
     * Clears the field "ParentTag".
     *
     * The field will be set to its default value. The hasParentTag()
     * method will return false.
     */
    inline void clearParentTag();

    /**
     * Checks whether the field "ParentTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParentTag()). Otherwise it will return false.
     */
    inline bool hasParentTag () const;

    /**
     * Returns the value of the member "ParentTag".
     *
     * Unique ID of immediate parent folder - to be used for list creation in case of list creation from Global Search result
     *
     * @return The value of the field "ParentTag"
     */
    inline uint64 getParentTag () const;

    /**
     * Sets the value of the member "ParentTag".
     *
     * Unique ID of immediate parent folder - to be used for list creation in case of list creation from Global Search result
     *
     * @param ParentTag The value which will be set
     */
    inline void setParentTag (uint64 ParentTag_);

    static const T_MPlayFileListItem &getDefaultInstance();

private:

    inline void set_has_e8FileFormat ();

    inline void clear_has_e8FileFormat ();

    inline void set_has_e8FileType ();

    inline void clear_has_e8FileType ();

    inline void set_has_e8PlayableStatus ();

    inline void clear_has_e8PlayableStatus ();

    inline void set_has_bIsPlaying ();

    inline void clear_has_bIsPlaying ();

    inline void set_has_bReadOnlyFlag ();

    inline void clear_has_bReadOnlyFlag ();

    inline void set_has_sFilename ();

    inline void clear_has_sFilename ();

    inline void set_has_u32Tag ();

    inline void clear_has_u32Tag ();

    inline void set_has_u8TrackNumber ();

    inline void clear_has_u8TrackNumber ();

    inline void set_has_sDateTime ();

    inline void clear_has_sDateTime ();

    inline void set_has_u32TotalPlaytime ();

    inline void clear_has_u32TotalPlaytime ();

    inline void set_has_u64FileSize ();

    inline void clear_has_u64FileSize ();

    inline void set_has_sCoverArt ();

    inline void clear_has_sCoverArt ();

    inline void set_has_Tag ();

    inline void clear_has_Tag ();

    inline void set_has_ParentTag ();

    inline void clear_has_ParentTag ();

    uint32 _has_bits_[ (14 + 31) / 32];

    T_e8_MPlayFileFormat _e8FileFormat;

    T_e8_MPlayFileType _e8FileType;

    T_e8_MPlayPlayableStatus _e8PlayableStatus;

    bool _bIsPlaying;

    bool _bReadOnlyFlag;

    ::std::string _sFilename;

    uint32 _u32Tag;

    uint8 _u8TrackNumber;

    ::std::string _sDateTime;

    uint32 _u32TotalPlaytime;

    uint64 _u64FileSize;

    ::std::string _sCoverArt;

    uint64 _Tag;

    uint64 _ParentTag;

};

/**
 * Holds e8FileType,sFolderTitle,u32NumberOfImages,sImageSize,sDateTime,sDimension,sResolution,e8FileFormat,u32Tag,sImageTitle,sPath,sImageFile,u8DeviceTag,sMountPoint informations of a Image/Folder
 */
class T_MPlayImageObjectItem {
public:

    /**
     * Default constructor
     */
    inline  T_MPlayImageObjectItem ();

    /**
     * Copy constructor
     */
    inline  T_MPlayImageObjectItem (const T_MPlayImageObjectItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MPlayImageObjectItem (T_e8_MPlayFileFormat e8FileFormat_, T_e8_MPlayFileType e8FileType_, const ::std::string& sDateTime_, const ::std::string& sDimension_, const ::std::string& sFolderTitle_, const ::std::string& sImageFile_, const ::std::string& sImageSize_, const ::std::string& sImageTitle_, const ::std::string& sMountPoint_, const ::std::string& sPath_, const ::std::string& sResolution_, uint32 u32NumberOfImages_, uint32 u32Tag_, uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline  ~T_MPlayImageObjectItem();

    /**
     * Assignment operator
     */
    inline T_MPlayImageObjectItem& operator = (const T_MPlayImageObjectItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MPlayImageObjectItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MPlayImageObjectItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MPlayImageObjectItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MPlayImageObjectItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8FileFormat"

    static const int kE8FileFormat = 0;

    /**
     * Clears the field "e8FileFormat".
     *
     * The field will be set to its default value. The hasE8FileFormat()
     * method will return false.
     */
    inline void clearE8FileFormat();

    /**
     * Checks whether the field "e8FileFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FileFormat()). Otherwise it will return false.
     */
    inline bool hasE8FileFormat () const;

    /**
     * Returns the value of the member "e8FileFormat".
     *
     * format of a image file.
     *
     * @return The value of the field "e8FileFormat"
     */
    inline T_e8_MPlayFileFormat getE8FileFormat () const;

    /**
     * Sets the value of the member "e8FileFormat".
     *
     * format of a image file.
     *
     * @param e8FileFormat The value which will be set
     */
    inline void setE8FileFormat (T_e8_MPlayFileFormat e8FileFormat_);

    // API of field "e8FileType"

    static const int kE8FileType = 1;

    /**
     * Clears the field "e8FileType".
     *
     * The field will be set to its default value. The hasE8FileType()
     * method will return false.
     */
    inline void clearE8FileType();

    /**
     * Checks whether the field "e8FileType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FileType()). Otherwise it will return false.
     */
    inline bool hasE8FileType () const;

    /**
     * Returns the value of the member "e8FileType".
     *
     * FileType identifies the object type of an item in the filesystem. If the object is of type FT_IMAGE,should ignore FolderTitle and numberofimages. If the object is of type FT_FOLDER, other fields represents the information of first image except FolderTitle and NumberOfImages.
     *
     * @return The value of the field "e8FileType"
     */
    inline T_e8_MPlayFileType getE8FileType () const;

    /**
     * Sets the value of the member "e8FileType".
     *
     * FileType identifies the object type of an item in the filesystem. If the object is of type FT_IMAGE,should ignore FolderTitle and numberofimages. If the object is of type FT_FOLDER, other fields represents the information of first image except FolderTitle and NumberOfImages.
     *
     * @param e8FileType The value which will be set
     */
    inline void setE8FileType (T_e8_MPlayFileType e8FileType_);

    // API of field "sDateTime"

    static const int kSDateTime = 2;

    /**
     * Clears the field "sDateTime".
     *
     * The field will be set to its default value. The hasSDateTime()
     * method will return false.
     */
    inline void clearSDateTime();

    /**
     * Checks whether the field "sDateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDateTime()). Otherwise it will return false.
     */
    inline bool hasSDateTime () const;

    /**
     * Returns the value of the member "sDateTime".
     *
     * Represents image created time.
     *
     * @return The value of the field "sDateTime"
     */
    inline const ::std::string& getSDateTime () const;

    /**
     * Retrieves the value of the field "sDateTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDateTime".
     */
    inline ::std::string& getSDateTimeMutable ();

    /**
     * Sets the value of the member "sDateTime".
     *
     * Represents image created time.
     *
     * @param sDateTime The value which will be set
     */
    inline void setSDateTime (const ::std::string& sDateTime_);

    /**
     * Sets the value of the member "sDateTime".
     *
     * Represents image created time.
     *
     * @param sDateTime The value which will be set
     */
    inline void setSDateTime (const char* sDateTime_);

    /**
     * Sets the value of the member "sDateTime".
     *
     * Represents image created time.
     *
     * @param sDateTime The value which will be set
     */
    inline void setSDateTime (const char* value, size_t size);

    // API of field "sDimension"

    static const int kSDimension = 3;

    /**
     * Clears the field "sDimension".
     *
     * The field will be set to its default value. The hasSDimension()
     * method will return false.
     */
    inline void clearSDimension();

    /**
     * Checks whether the field "sDimension" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDimension()). Otherwise it will return false.
     */
    inline bool hasSDimension () const;

    /**
     * Returns the value of the member "sDimension".
     *
     * Represents Dimension of the image.
     *
     * @return The value of the field "sDimension"
     */
    inline const ::std::string& getSDimension () const;

    /**
     * Retrieves the value of the field "sDimension" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDimension".
     */
    inline ::std::string& getSDimensionMutable ();

    /**
     * Sets the value of the member "sDimension".
     *
     * Represents Dimension of the image.
     *
     * @param sDimension The value which will be set
     */
    inline void setSDimension (const ::std::string& sDimension_);

    /**
     * Sets the value of the member "sDimension".
     *
     * Represents Dimension of the image.
     *
     * @param sDimension The value which will be set
     */
    inline void setSDimension (const char* sDimension_);

    /**
     * Sets the value of the member "sDimension".
     *
     * Represents Dimension of the image.
     *
     * @param sDimension The value which will be set
     */
    inline void setSDimension (const char* value, size_t size);

    // API of field "sFolderTitle"

    static const int kSFolderTitle = 4;

    /**
     * Clears the field "sFolderTitle".
     *
     * The field will be set to its default value. The hasSFolderTitle()
     * method will return false.
     */
    inline void clearSFolderTitle();

    /**
     * Checks whether the field "sFolderTitle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFolderTitle()). Otherwise it will return false.
     */
    inline bool hasSFolderTitle () const;

    /**
     * Returns the value of the member "sFolderTitle".
     *
     * Represents name of the folder which has atleast one image.
     *
     * @return The value of the field "sFolderTitle"
     */
    inline const ::std::string& getSFolderTitle () const;

    /**
     * Retrieves the value of the field "sFolderTitle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFolderTitle".
     */
    inline ::std::string& getSFolderTitleMutable ();

    /**
     * Sets the value of the member "sFolderTitle".
     *
     * Represents name of the folder which has atleast one image.
     *
     * @param sFolderTitle The value which will be set
     */
    inline void setSFolderTitle (const ::std::string& sFolderTitle_);

    /**
     * Sets the value of the member "sFolderTitle".
     *
     * Represents name of the folder which has atleast one image.
     *
     * @param sFolderTitle The value which will be set
     */
    inline void setSFolderTitle (const char* sFolderTitle_);

    /**
     * Sets the value of the member "sFolderTitle".
     *
     * Represents name of the folder which has atleast one image.
     *
     * @param sFolderTitle The value which will be set
     */
    inline void setSFolderTitle (const char* value, size_t size);

    // API of field "sImageFile"

    static const int kSImageFile = 5;

    /**
     * Clears the field "sImageFile".
     *
     * The field will be set to its default value. The hasSImageFile()
     * method will return false.
     */
    inline void clearSImageFile();

    /**
     * Checks whether the field "sImageFile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSImageFile()). Otherwise it will return false.
     */
    inline bool hasSImageFile () const;

    /**
     * Returns the value of the member "sImageFile".
     *
     * Represents relative path of the file, with the name and file extension.
     *
     * @return The value of the field "sImageFile"
     */
    inline const ::std::string& getSImageFile () const;

    /**
     * Retrieves the value of the field "sImageFile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sImageFile".
     */
    inline ::std::string& getSImageFileMutable ();

    /**
     * Sets the value of the member "sImageFile".
     *
     * Represents relative path of the file, with the name and file extension.
     *
     * @param sImageFile The value which will be set
     */
    inline void setSImageFile (const ::std::string& sImageFile_);

    /**
     * Sets the value of the member "sImageFile".
     *
     * Represents relative path of the file, with the name and file extension.
     *
     * @param sImageFile The value which will be set
     */
    inline void setSImageFile (const char* sImageFile_);

    /**
     * Sets the value of the member "sImageFile".
     *
     * Represents relative path of the file, with the name and file extension.
     *
     * @param sImageFile The value which will be set
     */
    inline void setSImageFile (const char* value, size_t size);

    // API of field "sImageSize"

    static const int kSImageSize = 6;

    /**
     * Clears the field "sImageSize".
     *
     * The field will be set to its default value. The hasSImageSize()
     * method will return false.
     */
    inline void clearSImageSize();

    /**
     * Checks whether the field "sImageSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSImageSize()). Otherwise it will return false.
     */
    inline bool hasSImageSize () const;

    /**
     * Returns the value of the member "sImageSize".
     *
     * Represents Image size in bytes.
     *
     * @return The value of the field "sImageSize"
     */
    inline const ::std::string& getSImageSize () const;

    /**
     * Retrieves the value of the field "sImageSize" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sImageSize".
     */
    inline ::std::string& getSImageSizeMutable ();

    /**
     * Sets the value of the member "sImageSize".
     *
     * Represents Image size in bytes.
     *
     * @param sImageSize The value which will be set
     */
    inline void setSImageSize (const ::std::string& sImageSize_);

    /**
     * Sets the value of the member "sImageSize".
     *
     * Represents Image size in bytes.
     *
     * @param sImageSize The value which will be set
     */
    inline void setSImageSize (const char* sImageSize_);

    /**
     * Sets the value of the member "sImageSize".
     *
     * Represents Image size in bytes.
     *
     * @param sImageSize The value which will be set
     */
    inline void setSImageSize (const char* value, size_t size);

    // API of field "sImageTitle"

    static const int kSImageTitle = 7;

    /**
     * Clears the field "sImageTitle".
     *
     * The field will be set to its default value. The hasSImageTitle()
     * method will return false.
     */
    inline void clearSImageTitle();

    /**
     * Checks whether the field "sImageTitle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSImageTitle()). Otherwise it will return false.
     */
    inline bool hasSImageTitle () const;

    /**
     * Returns the value of the member "sImageTitle".
     *
     * Title of the image.
     *
     * @return The value of the field "sImageTitle"
     */
    inline const ::std::string& getSImageTitle () const;

    /**
     * Retrieves the value of the field "sImageTitle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sImageTitle".
     */
    inline ::std::string& getSImageTitleMutable ();

    /**
     * Sets the value of the member "sImageTitle".
     *
     * Title of the image.
     *
     * @param sImageTitle The value which will be set
     */
    inline void setSImageTitle (const ::std::string& sImageTitle_);

    /**
     * Sets the value of the member "sImageTitle".
     *
     * Title of the image.
     *
     * @param sImageTitle The value which will be set
     */
    inline void setSImageTitle (const char* sImageTitle_);

    /**
     * Sets the value of the member "sImageTitle".
     *
     * Title of the image.
     *
     * @param sImageTitle The value which will be set
     */
    inline void setSImageTitle (const char* value, size_t size);

    // API of field "sMountPoint"

    static const int kSMountPoint = 8;

    /**
     * Clears the field "sMountPoint".
     *
     * The field will be set to its default value. The hasSMountPoint()
     * method will return false.
     */
    inline void clearSMountPoint();

    /**
     * Checks whether the field "sMountPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMountPoint()). Otherwise it will return false.
     */
    inline bool hasSMountPoint () const;

    /**
     * Returns the value of the member "sMountPoint".
     *
     * Mount point of the device .
     *
     * @return The value of the field "sMountPoint"
     */
    inline const ::std::string& getSMountPoint () const;

    /**
     * Retrieves the value of the field "sMountPoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMountPoint".
     */
    inline ::std::string& getSMountPointMutable ();

    /**
     * Sets the value of the member "sMountPoint".
     *
     * Mount point of the device .
     *
     * @param sMountPoint The value which will be set
     */
    inline void setSMountPoint (const ::std::string& sMountPoint_);

    /**
     * Sets the value of the member "sMountPoint".
     *
     * Mount point of the device .
     *
     * @param sMountPoint The value which will be set
     */
    inline void setSMountPoint (const char* sMountPoint_);

    /**
     * Sets the value of the member "sMountPoint".
     *
     * Mount point of the device .
     *
     * @param sMountPoint The value which will be set
     */
    inline void setSMountPoint (const char* value, size_t size);

    // API of field "sPath"

    static const int kSPath = 9;

    /**
     * Clears the field "sPath".
     *
     * The field will be set to its default value. The hasSPath()
     * method will return false.
     */
    inline void clearSPath();

    /**
     * Checks whether the field "sPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPath()). Otherwise it will return false.
     */
    inline bool hasSPath () const;

    /**
     * Returns the value of the member "sPath".
     *
     * Path to a directory on the device. The root value of the path parameter is "/".
     *
     * @return The value of the field "sPath"
     */
    inline const ::std::string& getSPath () const;

    /**
     * Retrieves the value of the field "sPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPath".
     */
    inline ::std::string& getSPathMutable ();

    /**
     * Sets the value of the member "sPath".
     *
     * Path to a directory on the device. The root value of the path parameter is "/".
     *
     * @param sPath The value which will be set
     */
    inline void setSPath (const ::std::string& sPath_);

    /**
     * Sets the value of the member "sPath".
     *
     * Path to a directory on the device. The root value of the path parameter is "/".
     *
     * @param sPath The value which will be set
     */
    inline void setSPath (const char* sPath_);

    /**
     * Sets the value of the member "sPath".
     *
     * Path to a directory on the device. The root value of the path parameter is "/".
     *
     * @param sPath The value which will be set
     */
    inline void setSPath (const char* value, size_t size);

    // API of field "sResolution"

    static const int kSResolution = 10;

    /**
     * Clears the field "sResolution".
     *
     * The field will be set to its default value. The hasSResolution()
     * method will return false.
     */
    inline void clearSResolution();

    /**
     * Checks whether the field "sResolution" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSResolution()). Otherwise it will return false.
     */
    inline bool hasSResolution () const;

    /**
     * Returns the value of the member "sResolution".
     *
     * Represents resolution of the image.
     *
     * @return The value of the field "sResolution"
     */
    inline const ::std::string& getSResolution () const;

    /**
     * Retrieves the value of the field "sResolution" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sResolution".
     */
    inline ::std::string& getSResolutionMutable ();

    /**
     * Sets the value of the member "sResolution".
     *
     * Represents resolution of the image.
     *
     * @param sResolution The value which will be set
     */
    inline void setSResolution (const ::std::string& sResolution_);

    /**
     * Sets the value of the member "sResolution".
     *
     * Represents resolution of the image.
     *
     * @param sResolution The value which will be set
     */
    inline void setSResolution (const char* sResolution_);

    /**
     * Sets the value of the member "sResolution".
     *
     * Represents resolution of the image.
     *
     * @param sResolution The value which will be set
     */
    inline void setSResolution (const char* value, size_t size);

    // API of field "u32NumberOfImages"

    static const int kU32NumberOfImages = 11;

    /**
     * Clears the field "u32NumberOfImages".
     *
     * The field will be set to its default value. The hasU32NumberOfImages()
     * method will return false.
     */
    inline void clearU32NumberOfImages();

    /**
     * Checks whether the field "u32NumberOfImages" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumberOfImages()). Otherwise it will return false.
     */
    inline bool hasU32NumberOfImages () const;

    /**
     * Returns the value of the member "u32NumberOfImages".
     *
     * NumberOfImages present in the Folder.
     *
     * @return The value of the field "u32NumberOfImages"
     */
    inline uint32 getU32NumberOfImages () const;

    /**
     * Sets the value of the member "u32NumberOfImages".
     *
     * NumberOfImages present in the Folder.
     *
     * @param u32NumberOfImages The value which will be set
     */
    inline void setU32NumberOfImages (uint32 u32NumberOfImages_);

    // API of field "u32Tag"

    static const int kU32Tag = 12;

    /**
     * Clears the field "u32Tag".
     *
     * The field will be set to its default value. The hasU32Tag()
     * method will return false.
     */
    inline void clearU32Tag();

    /**
     * Checks whether the field "u32Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Tag()). Otherwise it will return false.
     */
    inline bool hasU32Tag () const;

    /**
     * Returns the value of the member "u32Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value identifies the image to show.
     *
     * @return The value of the field "u32Tag"
     */
    inline uint32 getU32Tag () const;

    /**
     * Sets the value of the member "u32Tag".
     *
     * Uniquely identifies any piece of meta-data information. The Tag value identifies the image to show.
     *
     * @param u32Tag The value which will be set
     */
    inline void setU32Tag (uint32 u32Tag_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 13;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored. Actual physical devices are numbered starting with DeviceTag=0x01. DeviceTag of 0x00 is reserved as a virtual &quot;My Media&quot; device representing aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored. Actual physical devices are numbered starting with DeviceTag=0x01. DeviceTag of 0x00 is reserved as a virtual &quot;My Media&quot; device representing aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const T_MPlayImageObjectItem &getDefaultInstance();

private:

    inline void set_has_e8FileFormat ();

    inline void clear_has_e8FileFormat ();

    inline void set_has_e8FileType ();

    inline void clear_has_e8FileType ();

    inline void set_has_sDateTime ();

    inline void clear_has_sDateTime ();

    inline void set_has_sDimension ();

    inline void clear_has_sDimension ();

    inline void set_has_sFolderTitle ();

    inline void clear_has_sFolderTitle ();

    inline void set_has_sImageFile ();

    inline void clear_has_sImageFile ();

    inline void set_has_sImageSize ();

    inline void clear_has_sImageSize ();

    inline void set_has_sImageTitle ();

    inline void clear_has_sImageTitle ();

    inline void set_has_sMountPoint ();

    inline void clear_has_sMountPoint ();

    inline void set_has_sPath ();

    inline void clear_has_sPath ();

    inline void set_has_sResolution ();

    inline void clear_has_sResolution ();

    inline void set_has_u32NumberOfImages ();

    inline void clear_has_u32NumberOfImages ();

    inline void set_has_u32Tag ();

    inline void clear_has_u32Tag ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (14 + 31) / 32];

    T_e8_MPlayFileFormat _e8FileFormat;

    T_e8_MPlayFileType _e8FileType;

    ::std::string _sDateTime;

    ::std::string _sDimension;

    ::std::string _sFolderTitle;

    ::std::string _sImageFile;

    ::std::string _sImageSize;

    ::std::string _sImageTitle;

    ::std::string _sMountPoint;

    ::std::string _sPath;

    ::std::string _sResolution;

    uint32 _u32NumberOfImages;

    uint32 _u32Tag;

    uint8 _u8DeviceTag;

};

class T_MPlayIndexingStateResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_MPlayIndexingStateResultItem ();

    /**
     * Copy constructor
     */
    inline  T_MPlayIndexingStateResultItem (const T_MPlayIndexingStateResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MPlayIndexingStateResultItem (T_e8_MPlayDeviceIndexedState e8DeviceIndexedState_, uint8 u8DeviceTag_, uint8 u8IndexingPercentComplete_);

    /**
     * Destructor
     */
    inline  ~T_MPlayIndexingStateResultItem();

    /**
     * Assignment operator
     */
    inline T_MPlayIndexingStateResultItem& operator = (const T_MPlayIndexingStateResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MPlayIndexingStateResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MPlayIndexingStateResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MPlayIndexingStateResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MPlayIndexingStateResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DeviceIndexedState"

    static const int kE8DeviceIndexedState = 0;

    /**
     * Clears the field "e8DeviceIndexedState".
     *
     * The field will be set to its default value. The hasE8DeviceIndexedState()
     * method will return false.
     */
    inline void clearE8DeviceIndexedState();

    /**
     * Checks whether the field "e8DeviceIndexedState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceIndexedState()). Otherwise it will return false.
     */
    inline bool hasE8DeviceIndexedState () const;

    /**
     * Returns the value of the member "e8DeviceIndexedState".
     *
     * Identifies the state of the indexing operation: Not supported, not started, partially indexed, or complete.
     *
     * @return The value of the field "e8DeviceIndexedState"
     */
    inline T_e8_MPlayDeviceIndexedState getE8DeviceIndexedState () const;

    /**
     * Sets the value of the member "e8DeviceIndexedState".
     *
     * Identifies the state of the indexing operation: Not supported, not started, partially indexed, or complete.
     *
     * @param e8DeviceIndexedState The value which will be set
     */
    inline void setE8DeviceIndexedState (T_e8_MPlayDeviceIndexedState e8DeviceIndexedState_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 1;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored. Actual physical devices are numbered starting with DeviceTag=0x01. DeviceTag of 0x00 is reserved as a virtual &quot;My Media&quot; device representing aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored. Actual physical devices are numbered starting with DeviceTag=0x01. DeviceTag of 0x00 is reserved as a virtual &quot;My Media&quot; device representing aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "u8IndexingPercentComplete"

    static const int kU8IndexingPercentComplete = 2;

    /**
     * Clears the field "u8IndexingPercentComplete".
     *
     * The field will be set to its default value. The hasU8IndexingPercentComplete()
     * method will return false.
     */
    inline void clearU8IndexingPercentComplete();

    /**
     * Checks whether the field "u8IndexingPercentComplete" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8IndexingPercentComplete()). Otherwise it will return false.
     */
    inline bool hasU8IndexingPercentComplete () const;

    /**
     * Returns the value of the member "u8IndexingPercentComplete".
     *
     * Percent completion of the indexing operation for a given device.
     *
     * @return The value of the field "u8IndexingPercentComplete"
     */
    inline uint8 getU8IndexingPercentComplete () const;

    /**
     * Sets the value of the member "u8IndexingPercentComplete".
     *
     * Percent completion of the indexing operation for a given device.
     *
     * @param u8IndexingPercentComplete The value which will be set
     */
    inline void setU8IndexingPercentComplete (uint8 u8IndexingPercentComplete_);

    static const T_MPlayIndexingStateResultItem &getDefaultInstance();

private:

    inline void set_has_e8DeviceIndexedState ();

    inline void clear_has_e8DeviceIndexedState ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_u8IndexingPercentComplete ();

    inline void clear_has_u8IndexingPercentComplete ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_MPlayDeviceIndexedState _e8DeviceIndexedState;

    uint8 _u8DeviceTag;

    uint8 _u8IndexingPercentComplete;

};

/**
 * AlbumArt, CategoryType, DeviceTag, DeviceType, DeviceVersion, FileFormat, Filename, IsPlaying, MediaType, MetaDataField1, MetaDataField2, MetaDataField3, MetaDataField4, MetaDataTag1, MetaDataTag2, MetaDataTag3, MetaDataTag4, Tag, TotalPlaytime, TrackNumber, ExtendedTrackNumber, BitRate, SampleRate, AudioChannelFormat, VBR, PlayableStatus}
 */
class T_MPlayMediaObject {
public:

    /**
     * Default constructor
     */
    inline  T_MPlayMediaObject ();

    /**
     * Copy constructor
     */
    inline  T_MPlayMediaObject (const T_MPlayMediaObject &rhs);

    /**
     * All fields constructor
     */
    inline  T_MPlayMediaObject (T_e8_MPlayAudioChannelFormat e8AudioChannelFormat_, T_e8_MPlayCategoryType e8CategoryType_, T_e8_MPlayDeviceType e8DeviceType_, T_e8_MPlayFileFormat e8FileFormat_, T_e8_MPlayMediaType e8MediaType_, T_e8_MPlayPlayableStatus e8PlayableStatus_, bool bIsPlaying_, bool bVBR_, const ::std::string& sAlbumArt_, const ::std::string& sDateTime_, const ::std::string& sDeviceVersion_, const ::std::string& sFilename_, const ::std::string& sMetaDataField1_, const ::std::string& sMetaDataField2_, const ::std::string& sMetaDataField3_, const ::std::string& sMetaDataField4_, const ::std::string& sYomiMetaDataTitle_, const ::std::string& sYomiMetaDataArtist_, const ::std::string& sYomiMetaDataAlbum_, const ::std::string& sResolution_, uint16 u16ExtendedTrackNumber_, uint32 u32BitRate_, uint32 u32MetaDataTag1_, uint32 u32MetaDataTag2_, uint32 u32MetaDataTag3_, uint32 u32MetaDataTag4_, uint32 u32SampleRate_, uint32 u32Tag_, uint32 u32TotalPlaytime_, uint32 u32Year_, uint32 u32YearID_, uint64 u64FileSize_, uint8 u8DeviceTag_, uint8 u8TrackNumber_, bool bIsFavorite_);

    /**
     * Destructor
     */
    inline  ~T_MPlayMediaObject();

    /**
     * Assignment operator
     */
    inline T_MPlayMediaObject& operator = (const T_MPlayMediaObject& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MPlayMediaObject& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MPlayMediaObject& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MPlayMediaObject& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MPlayMediaObject& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8AudioChannelFormat"

    static const int kE8AudioChannelFormat = 0;

    /**
     * Clears the field "e8AudioChannelFormat".
     *
     * The field will be set to its default value. The hasE8AudioChannelFormat()
     * method will return false.
     */
    inline void clearE8AudioChannelFormat();

    /**
     * Checks whether the field "e8AudioChannelFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AudioChannelFormat()). Otherwise it will return false.
     */
    inline bool hasE8AudioChannelFormat () const;

    /**
     * Returns the value of the member "e8AudioChannelFormat".
     *
     * Audio channel format of the currently played song
     *
     * @return The value of the field "e8AudioChannelFormat"
     */
    inline T_e8_MPlayAudioChannelFormat getE8AudioChannelFormat () const;

    /**
     * Sets the value of the member "e8AudioChannelFormat".
     *
     * Audio channel format of the currently played song
     *
     * @param e8AudioChannelFormat The value which will be set
     */
    inline void setE8AudioChannelFormat (T_e8_MPlayAudioChannelFormat e8AudioChannelFormat_);

    // API of field "e8CategoryType"

    static const int kE8CategoryType = 1;

    /**
     * Clears the field "e8CategoryType".
     *
     * The field will be set to its default value. The hasE8CategoryType()
     * method will return false.
     */
    inline void clearE8CategoryType();

    /**
     * Checks whether the field "e8CategoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CategoryType()). Otherwise it will return false.
     */
    inline bool hasE8CategoryType () const;

    /**
     * Returns the value of the member "e8CategoryType".
     *
     * Contains the category type of the media object.
     *
     * @return The value of the field "e8CategoryType"
     */
    inline T_e8_MPlayCategoryType getE8CategoryType () const;

    /**
     * Sets the value of the member "e8CategoryType".
     *
     * Contains the category type of the media object.
     *
     * @param e8CategoryType The value which will be set
     */
    inline void setE8CategoryType (T_e8_MPlayCategoryType e8CategoryType_);

    // API of field "e8DeviceType"

    static const int kE8DeviceType = 2;

    /**
     * Clears the field "e8DeviceType".
     *
     * The field will be set to its default value. The hasE8DeviceType()
     * method will return false.
     */
    inline void clearE8DeviceType();

    /**
     * Checks whether the field "e8DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceType()). Otherwise it will return false.
     */
    inline bool hasE8DeviceType () const;

    /**
     * Returns the value of the member "e8DeviceType".
     *
     * Type of device on which the media object is stored.
     *
     * @return The value of the field "e8DeviceType"
     */
    inline T_e8_MPlayDeviceType getE8DeviceType () const;

    /**
     * Sets the value of the member "e8DeviceType".
     *
     * Type of device on which the media object is stored.
     *
     * @param e8DeviceType The value which will be set
     */
    inline void setE8DeviceType (T_e8_MPlayDeviceType e8DeviceType_);

    // API of field "e8FileFormat"

    static const int kE8FileFormat = 3;

    /**
     * Clears the field "e8FileFormat".
     *
     * The field will be set to its default value. The hasE8FileFormat()
     * method will return false.
     */
    inline void clearE8FileFormat();

    /**
     * Checks whether the field "e8FileFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FileFormat()). Otherwise it will return false.
     */
    inline bool hasE8FileFormat () const;

    /**
     * Returns the value of the member "e8FileFormat".
     *
     * The format of a media file.
     *
     * @return The value of the field "e8FileFormat"
     */
    inline T_e8_MPlayFileFormat getE8FileFormat () const;

    /**
     * Sets the value of the member "e8FileFormat".
     *
     * The format of a media file.
     *
     * @param e8FileFormat The value which will be set
     */
    inline void setE8FileFormat (T_e8_MPlayFileFormat e8FileFormat_);

    // API of field "e8MediaType"

    static const int kE8MediaType = 4;

    /**
     * Clears the field "e8MediaType".
     *
     * The field will be set to its default value. The hasE8MediaType()
     * method will return false.
     */
    inline void clearE8MediaType();

    /**
     * Checks whether the field "e8MediaType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MediaType()). Otherwise it will return false.
     */
    inline bool hasE8MediaType () const;

    /**
     * Returns the value of the member "e8MediaType".
     *
     * Contains the type of media object.
     *
     * @return The value of the field "e8MediaType"
     */
    inline T_e8_MPlayMediaType getE8MediaType () const;

    /**
     * Sets the value of the member "e8MediaType".
     *
     * Contains the type of media object.
     *
     * @param e8MediaType The value which will be set
     */
    inline void setE8MediaType (T_e8_MPlayMediaType e8MediaType_);

    // API of field "e8PlayableStatus"

    static const int kE8PlayableStatus = 5;

    /**
     * Clears the field "e8PlayableStatus".
     *
     * The field will be set to its default value. The hasE8PlayableStatus()
     * method will return false.
     */
    inline void clearE8PlayableStatus();

    /**
     * Checks whether the field "e8PlayableStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlayableStatus()). Otherwise it will return false.
     */
    inline bool hasE8PlayableStatus () const;

    /**
     * Returns the value of the member "e8PlayableStatus".
     *
     * Playable status of object.
     *
     * @return The value of the field "e8PlayableStatus"
     */
    inline T_e8_MPlayPlayableStatus getE8PlayableStatus () const;

    /**
     * Sets the value of the member "e8PlayableStatus".
     *
     * Playable status of object.
     *
     * @param e8PlayableStatus The value which will be set
     */
    inline void setE8PlayableStatus (T_e8_MPlayPlayableStatus e8PlayableStatus_);

    // API of field "bIsPlaying"

    static const int kBIsPlaying = 6;

    /**
     * Clears the field "bIsPlaying".
     *
     * The field will be set to its default value. The hasBIsPlaying()
     * method will return false.
     */
    inline void clearBIsPlaying();

    /**
     * Checks whether the field "bIsPlaying" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsPlaying()). Otherwise it will return false.
     */
    inline bool hasBIsPlaying () const;

    /**
     * Returns the value of the member "bIsPlaying".
     *
     * Defines whether the media object is currently being played. This parameter is True when the media object is currently being played and False otherwise.
     *
     * @return The value of the field "bIsPlaying"
     */
    inline bool getBIsPlaying () const;

    /**
     * Sets the value of the member "bIsPlaying".
     *
     * Defines whether the media object is currently being played. This parameter is True when the media object is currently being played and False otherwise.
     *
     * @param bIsPlaying The value which will be set
     */
    inline void setBIsPlaying (bool bIsPlaying_);

    // API of field "bVBR"

    static const int kBVBR = 7;

    /**
     * Clears the field "bVBR".
     *
     * The field will be set to its default value. The hasBVBR()
     * method will return false.
     */
    inline void clearBVBR();

    /**
     * Checks whether the field "bVBR" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBVBR()). Otherwise it will return false.
     */
    inline bool hasBVBR () const;

    /**
     * Returns the value of the member "bVBR".
     *
     * If this flag is true, the bitrate is variable (VBR). If the flag is false, the bitrate is constant or the type unknown
     *
     * @return The value of the field "bVBR"
     */
    inline bool getBVBR () const;

    /**
     * Sets the value of the member "bVBR".
     *
     * If this flag is true, the bitrate is variable (VBR). If the flag is false, the bitrate is constant or the type unknown
     *
     * @param bVBR The value which will be set
     */
    inline void setBVBR (bool bVBR_);

    // API of field "sAlbumArt"

    static const int kSAlbumArt = 8;

    /**
     * Clears the field "sAlbumArt".
     *
     * The field will be set to its default value. The hasSAlbumArt()
     * method will return false.
     */
    inline void clearSAlbumArt();

    /**
     * Checks whether the field "sAlbumArt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAlbumArt()). Otherwise it will return false.
     */
    inline bool hasSAlbumArt () const;

    /**
     * Returns the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @return The value of the field "sAlbumArt"
     */
    inline const ::std::string& getSAlbumArt () const;

    /**
     * Retrieves the value of the field "sAlbumArt" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAlbumArt".
     */
    inline ::std::string& getSAlbumArtMutable ();

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const ::std::string& sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* value, size_t size);

    // API of field "sDateTime"

    static const int kSDateTime = 9;

    /**
     * Clears the field "sDateTime".
     *
     * The field will be set to its default value. The hasSDateTime()
     * method will return false.
     */
    inline void clearSDateTime();

    /**
     * Checks whether the field "sDateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDateTime()). Otherwise it will return false.
     */
    inline bool hasSDateTime () const;

    /**
     * Returns the value of the member "sDateTime".
     *
     * Last file modification date and time in Y:m:d H:M:S
     *
     * @return The value of the field "sDateTime"
     */
    inline const ::std::string& getSDateTime () const;

    /**
     * Retrieves the value of the field "sDateTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDateTime".
     */
    inline ::std::string& getSDateTimeMutable ();

    /**
     * Sets the value of the member "sDateTime".
     *
     * Last file modification date and time in Y:m:d H:M:S
     *
     * @param sDateTime The value which will be set
     */
    inline void setSDateTime (const ::std::string& sDateTime_);

    /**
     * Sets the value of the member "sDateTime".
     *
     * Last file modification date and time in Y:m:d H:M:S
     *
     * @param sDateTime The value which will be set
     */
    inline void setSDateTime (const char* sDateTime_);

    /**
     * Sets the value of the member "sDateTime".
     *
     * Last file modification date and time in Y:m:d H:M:S
     *
     * @param sDateTime The value which will be set
     */
    inline void setSDateTime (const char* value, size_t size);

    // API of field "sDeviceVersion"

    static const int kSDeviceVersion = 10;

    /**
     * Clears the field "sDeviceVersion".
     *
     * The field will be set to its default value. The hasSDeviceVersion()
     * method will return false.
     */
    inline void clearSDeviceVersion();

    /**
     * Checks whether the field "sDeviceVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceVersion()). Otherwise it will return false.
     */
    inline bool hasSDeviceVersion () const;

    /**
     * Returns the value of the member "sDeviceVersion".
     *
     * Version (or other identifying information) of the device. For example, this parameter could contain which version of the Bluetooth AVRCP profile is running.
     *
     * @return The value of the field "sDeviceVersion"
     */
    inline const ::std::string& getSDeviceVersion () const;

    /**
     * Retrieves the value of the field "sDeviceVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceVersion".
     */
    inline ::std::string& getSDeviceVersionMutable ();

    /**
     * Sets the value of the member "sDeviceVersion".
     *
     * Version (or other identifying information) of the device. For example, this parameter could contain which version of the Bluetooth AVRCP profile is running.
     *
     * @param sDeviceVersion The value which will be set
     */
    inline void setSDeviceVersion (const ::std::string& sDeviceVersion_);

    /**
     * Sets the value of the member "sDeviceVersion".
     *
     * Version (or other identifying information) of the device. For example, this parameter could contain which version of the Bluetooth AVRCP profile is running.
     *
     * @param sDeviceVersion The value which will be set
     */
    inline void setSDeviceVersion (const char* sDeviceVersion_);

    /**
     * Sets the value of the member "sDeviceVersion".
     *
     * Version (or other identifying information) of the device. For example, this parameter could contain which version of the Bluetooth AVRCP profile is running.
     *
     * @param sDeviceVersion The value which will be set
     */
    inline void setSDeviceVersion (const char* value, size_t size);

    // API of field "sFilename"

    static const int kSFilename = 11;

    /**
     * Clears the field "sFilename".
     *
     * The field will be set to its default value. The hasSFilename()
     * method will return false.
     */
    inline void clearSFilename();

    /**
     * Checks whether the field "sFilename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFilename()). Otherwise it will return false.
     */
    inline bool hasSFilename () const;

    /**
     * Returns the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @return The value of the field "sFilename"
     */
    inline const ::std::string& getSFilename () const;

    /**
     * Retrieves the value of the field "sFilename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFilename".
     */
    inline ::std::string& getSFilenameMutable ();

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const ::std::string& sFilename_);

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const char* sFilename_);

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const char* value, size_t size);

    // API of field "sMetaDataField1"

    static const int kSMetaDataField1 = 12;

    /**
     * Clears the field "sMetaDataField1".
     *
     * The field will be set to its default value. The hasSMetaDataField1()
     * method will return false.
     */
    inline void clearSMetaDataField1();

    /**
     * Checks whether the field "sMetaDataField1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMetaDataField1()). Otherwise it will return false.
     */
    inline bool hasSMetaDataField1 () const;

    /**
     * Returns the value of the member "sMetaDataField1".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "sMetaDataField1"
     */
    inline const ::std::string& getSMetaDataField1 () const;

    /**
     * Retrieves the value of the field "sMetaDataField1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMetaDataField1".
     */
    inline ::std::string& getSMetaDataField1Mutable ();

    /**
     * Sets the value of the member "sMetaDataField1".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField1 The value which will be set
     */
    inline void setSMetaDataField1 (const ::std::string& sMetaDataField1_);

    /**
     * Sets the value of the member "sMetaDataField1".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField1 The value which will be set
     */
    inline void setSMetaDataField1 (const char* sMetaDataField1_);

    /**
     * Sets the value of the member "sMetaDataField1".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField1 The value which will be set
     */
    inline void setSMetaDataField1 (const char* value, size_t size);

    // API of field "sMetaDataField2"

    static const int kSMetaDataField2 = 13;

    /**
     * Clears the field "sMetaDataField2".
     *
     * The field will be set to its default value. The hasSMetaDataField2()
     * method will return false.
     */
    inline void clearSMetaDataField2();

    /**
     * Checks whether the field "sMetaDataField2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMetaDataField2()). Otherwise it will return false.
     */
    inline bool hasSMetaDataField2 () const;

    /**
     * Returns the value of the member "sMetaDataField2".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "sMetaDataField2"
     */
    inline const ::std::string& getSMetaDataField2 () const;

    /**
     * Retrieves the value of the field "sMetaDataField2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMetaDataField2".
     */
    inline ::std::string& getSMetaDataField2Mutable ();

    /**
     * Sets the value of the member "sMetaDataField2".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField2 The value which will be set
     */
    inline void setSMetaDataField2 (const ::std::string& sMetaDataField2_);

    /**
     * Sets the value of the member "sMetaDataField2".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField2 The value which will be set
     */
    inline void setSMetaDataField2 (const char* sMetaDataField2_);

    /**
     * Sets the value of the member "sMetaDataField2".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField2 The value which will be set
     */
    inline void setSMetaDataField2 (const char* value, size_t size);

    // API of field "sMetaDataField3"

    static const int kSMetaDataField3 = 14;

    /**
     * Clears the field "sMetaDataField3".
     *
     * The field will be set to its default value. The hasSMetaDataField3()
     * method will return false.
     */
    inline void clearSMetaDataField3();

    /**
     * Checks whether the field "sMetaDataField3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMetaDataField3()). Otherwise it will return false.
     */
    inline bool hasSMetaDataField3 () const;

    /**
     * Returns the value of the member "sMetaDataField3".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "sMetaDataField3"
     */
    inline const ::std::string& getSMetaDataField3 () const;

    /**
     * Retrieves the value of the field "sMetaDataField3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMetaDataField3".
     */
    inline ::std::string& getSMetaDataField3Mutable ();

    /**
     * Sets the value of the member "sMetaDataField3".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField3 The value which will be set
     */
    inline void setSMetaDataField3 (const ::std::string& sMetaDataField3_);

    /**
     * Sets the value of the member "sMetaDataField3".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField3 The value which will be set
     */
    inline void setSMetaDataField3 (const char* sMetaDataField3_);

    /**
     * Sets the value of the member "sMetaDataField3".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField3 The value which will be set
     */
    inline void setSMetaDataField3 (const char* value, size_t size);

    // API of field "sMetaDataField4"

    static const int kSMetaDataField4 = 15;

    /**
     * Clears the field "sMetaDataField4".
     *
     * The field will be set to its default value. The hasSMetaDataField4()
     * method will return false.
     */
    inline void clearSMetaDataField4();

    /**
     * Checks whether the field "sMetaDataField4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMetaDataField4()). Otherwise it will return false.
     */
    inline bool hasSMetaDataField4 () const;

    /**
     * Returns the value of the member "sMetaDataField4".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "sMetaDataField4"
     */
    inline const ::std::string& getSMetaDataField4 () const;

    /**
     * Retrieves the value of the field "sMetaDataField4" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMetaDataField4".
     */
    inline ::std::string& getSMetaDataField4Mutable ();

    /**
     * Sets the value of the member "sMetaDataField4".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField4 The value which will be set
     */
    inline void setSMetaDataField4 (const ::std::string& sMetaDataField4_);

    /**
     * Sets the value of the member "sMetaDataField4".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField4 The value which will be set
     */
    inline void setSMetaDataField4 (const char* sMetaDataField4_);

    /**
     * Sets the value of the member "sMetaDataField4".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField4 The value which will be set
     */
    inline void setSMetaDataField4 (const char* value, size_t size);

    // API of field "sYomiMetaDataTitle"

    static const int kSYomiMetaDataTitle = 16;

    /**
     * Clears the field "sYomiMetaDataTitle".
     *
     * The field will be set to its default value. The hasSYomiMetaDataTitle()
     * method will return false.
     */
    inline void clearSYomiMetaDataTitle();

    /**
     * Checks whether the field "sYomiMetaDataTitle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSYomiMetaDataTitle()). Otherwise it will return false.
     */
    inline bool hasSYomiMetaDataTitle () const;

    /**
     * Returns the value of the member "sYomiMetaDataTitle".
     *
     * Contains the yomi metadata Title for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @return The value of the field "sYomiMetaDataTitle"
     */
    inline const ::std::string& getSYomiMetaDataTitle () const;

    /**
     * Retrieves the value of the field "sYomiMetaDataTitle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sYomiMetaDataTitle".
     */
    inline ::std::string& getSYomiMetaDataTitleMutable ();

    /**
     * Sets the value of the member "sYomiMetaDataTitle".
     *
     * Contains the yomi metadata Title for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataTitle The value which will be set
     */
    inline void setSYomiMetaDataTitle (const ::std::string& sYomiMetaDataTitle_);

    /**
     * Sets the value of the member "sYomiMetaDataTitle".
     *
     * Contains the yomi metadata Title for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataTitle The value which will be set
     */
    inline void setSYomiMetaDataTitle (const char* sYomiMetaDataTitle_);

    /**
     * Sets the value of the member "sYomiMetaDataTitle".
     *
     * Contains the yomi metadata Title for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataTitle The value which will be set
     */
    inline void setSYomiMetaDataTitle (const char* value, size_t size);

    // API of field "sYomiMetaDataArtist"

    static const int kSYomiMetaDataArtist = 17;

    /**
     * Clears the field "sYomiMetaDataArtist".
     *
     * The field will be set to its default value. The hasSYomiMetaDataArtist()
     * method will return false.
     */
    inline void clearSYomiMetaDataArtist();

    /**
     * Checks whether the field "sYomiMetaDataArtist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSYomiMetaDataArtist()). Otherwise it will return false.
     */
    inline bool hasSYomiMetaDataArtist () const;

    /**
     * Returns the value of the member "sYomiMetaDataArtist".
     *
     * Contains the yomi metadata Artist for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @return The value of the field "sYomiMetaDataArtist"
     */
    inline const ::std::string& getSYomiMetaDataArtist () const;

    /**
     * Retrieves the value of the field "sYomiMetaDataArtist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sYomiMetaDataArtist".
     */
    inline ::std::string& getSYomiMetaDataArtistMutable ();

    /**
     * Sets the value of the member "sYomiMetaDataArtist".
     *
     * Contains the yomi metadata Artist for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataArtist The value which will be set
     */
    inline void setSYomiMetaDataArtist (const ::std::string& sYomiMetaDataArtist_);

    /**
     * Sets the value of the member "sYomiMetaDataArtist".
     *
     * Contains the yomi metadata Artist for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataArtist The value which will be set
     */
    inline void setSYomiMetaDataArtist (const char* sYomiMetaDataArtist_);

    /**
     * Sets the value of the member "sYomiMetaDataArtist".
     *
     * Contains the yomi metadata Artist for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataArtist The value which will be set
     */
    inline void setSYomiMetaDataArtist (const char* value, size_t size);

    // API of field "sYomiMetaDataAlbum"

    static const int kSYomiMetaDataAlbum = 18;

    /**
     * Clears the field "sYomiMetaDataAlbum".
     *
     * The field will be set to its default value. The hasSYomiMetaDataAlbum()
     * method will return false.
     */
    inline void clearSYomiMetaDataAlbum();

    /**
     * Checks whether the field "sYomiMetaDataAlbum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSYomiMetaDataAlbum()). Otherwise it will return false.
     */
    inline bool hasSYomiMetaDataAlbum () const;

    /**
     * Returns the value of the member "sYomiMetaDataAlbum".
     *
     * Contains the yomi metadata Album for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @return The value of the field "sYomiMetaDataAlbum"
     */
    inline const ::std::string& getSYomiMetaDataAlbum () const;

    /**
     * Retrieves the value of the field "sYomiMetaDataAlbum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sYomiMetaDataAlbum".
     */
    inline ::std::string& getSYomiMetaDataAlbumMutable ();

    /**
     * Sets the value of the member "sYomiMetaDataAlbum".
     *
     * Contains the yomi metadata Album for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataAlbum The value which will be set
     */
    inline void setSYomiMetaDataAlbum (const ::std::string& sYomiMetaDataAlbum_);

    /**
     * Sets the value of the member "sYomiMetaDataAlbum".
     *
     * Contains the yomi metadata Album for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataAlbum The value which will be set
     */
    inline void setSYomiMetaDataAlbum (const char* sYomiMetaDataAlbum_);

    /**
     * Sets the value of the member "sYomiMetaDataAlbum".
     *
     * Contains the yomi metadata Album for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataAlbum The value which will be set
     */
    inline void setSYomiMetaDataAlbum (const char* value, size_t size);

    // API of field "sResolution"

    static const int kSResolution = 19;

    /**
     * Clears the field "sResolution".
     *
     * The field will be set to its default value. The hasSResolution()
     * method will return false.
     */
    inline void clearSResolution();

    /**
     * Checks whether the field "sResolution" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSResolution()). Otherwise it will return false.
     */
    inline bool hasSResolution () const;

    /**
     * Returns the value of the member "sResolution".
     *
     * Resolution (width x height)
     *
     * @return The value of the field "sResolution"
     */
    inline const ::std::string& getSResolution () const;

    /**
     * Retrieves the value of the field "sResolution" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sResolution".
     */
    inline ::std::string& getSResolutionMutable ();

    /**
     * Sets the value of the member "sResolution".
     *
     * Resolution (width x height)
     *
     * @param sResolution The value which will be set
     */
    inline void setSResolution (const ::std::string& sResolution_);

    /**
     * Sets the value of the member "sResolution".
     *
     * Resolution (width x height)
     *
     * @param sResolution The value which will be set
     */
    inline void setSResolution (const char* sResolution_);

    /**
     * Sets the value of the member "sResolution".
     *
     * Resolution (width x height)
     *
     * @param sResolution The value which will be set
     */
    inline void setSResolution (const char* value, size_t size);

    // API of field "u16ExtendedTrackNumber"

    static const int kU16ExtendedTrackNumber = 20;

    /**
     * Clears the field "u16ExtendedTrackNumber".
     *
     * The field will be set to its default value. The hasU16ExtendedTrackNumber()
     * method will return false.
     */
    inline void clearU16ExtendedTrackNumber();

    /**
     * Checks whether the field "u16ExtendedTrackNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ExtendedTrackNumber()). Otherwise it will return false.
     */
    inline bool hasU16ExtendedTrackNumber () const;

    /**
     * Returns the value of the member "u16ExtendedTrackNumber".
     *
     * This is the full 16-bit track number
     *
     * @return The value of the field "u16ExtendedTrackNumber"
     */
    inline uint16 getU16ExtendedTrackNumber () const;

    /**
     * Sets the value of the member "u16ExtendedTrackNumber".
     *
     * This is the full 16-bit track number
     *
     * @param u16ExtendedTrackNumber The value which will be set
     */
    inline void setU16ExtendedTrackNumber (uint16 u16ExtendedTrackNumber_);

    // API of field "u32BitRate"

    static const int kU32BitRate = 21;

    /**
     * Clears the field "u32BitRate".
     *
     * The field will be set to its default value. The hasU32BitRate()
     * method will return false.
     */
    inline void clearU32BitRate();

    /**
     * Checks whether the field "u32BitRate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32BitRate()). Otherwise it will return false.
     */
    inline bool hasU32BitRate () const;

    /**
     * Returns the value of the member "u32BitRate".
     *
     * Bit rate of the currently played song
     *
     * @return The value of the field "u32BitRate"
     */
    inline uint32 getU32BitRate () const;

    /**
     * Sets the value of the member "u32BitRate".
     *
     * Bit rate of the currently played song
     *
     * @param u32BitRate The value which will be set
     */
    inline void setU32BitRate (uint32 u32BitRate_);

    // API of field "u32MetaDataTag1"

    static const int kU32MetaDataTag1 = 22;

    /**
     * Clears the field "u32MetaDataTag1".
     *
     * The field will be set to its default value. The hasU32MetaDataTag1()
     * method will return false.
     */
    inline void clearU32MetaDataTag1();

    /**
     * Checks whether the field "u32MetaDataTag1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MetaDataTag1()). Otherwise it will return false.
     */
    inline bool hasU32MetaDataTag1 () const;

    /**
     * Returns the value of the member "u32MetaDataTag1".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "u32MetaDataTag1"
     */
    inline uint32 getU32MetaDataTag1 () const;

    /**
     * Sets the value of the member "u32MetaDataTag1".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param u32MetaDataTag1 The value which will be set
     */
    inline void setU32MetaDataTag1 (uint32 u32MetaDataTag1_);

    // API of field "u32MetaDataTag2"

    static const int kU32MetaDataTag2 = 23;

    /**
     * Clears the field "u32MetaDataTag2".
     *
     * The field will be set to its default value. The hasU32MetaDataTag2()
     * method will return false.
     */
    inline void clearU32MetaDataTag2();

    /**
     * Checks whether the field "u32MetaDataTag2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MetaDataTag2()). Otherwise it will return false.
     */
    inline bool hasU32MetaDataTag2 () const;

    /**
     * Returns the value of the member "u32MetaDataTag2".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "u32MetaDataTag2"
     */
    inline uint32 getU32MetaDataTag2 () const;

    /**
     * Sets the value of the member "u32MetaDataTag2".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param u32MetaDataTag2 The value which will be set
     */
    inline void setU32MetaDataTag2 (uint32 u32MetaDataTag2_);

    // API of field "u32MetaDataTag3"

    static const int kU32MetaDataTag3 = 24;

    /**
     * Clears the field "u32MetaDataTag3".
     *
     * The field will be set to its default value. The hasU32MetaDataTag3()
     * method will return false.
     */
    inline void clearU32MetaDataTag3();

    /**
     * Checks whether the field "u32MetaDataTag3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MetaDataTag3()). Otherwise it will return false.
     */
    inline bool hasU32MetaDataTag3 () const;

    /**
     * Returns the value of the member "u32MetaDataTag3".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "u32MetaDataTag3"
     */
    inline uint32 getU32MetaDataTag3 () const;

    /**
     * Sets the value of the member "u32MetaDataTag3".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param u32MetaDataTag3 The value which will be set
     */
    inline void setU32MetaDataTag3 (uint32 u32MetaDataTag3_);

    // API of field "u32MetaDataTag4"

    static const int kU32MetaDataTag4 = 25;

    /**
     * Clears the field "u32MetaDataTag4".
     *
     * The field will be set to its default value. The hasU32MetaDataTag4()
     * method will return false.
     */
    inline void clearU32MetaDataTag4();

    /**
     * Checks whether the field "u32MetaDataTag4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MetaDataTag4()). Otherwise it will return false.
     */
    inline bool hasU32MetaDataTag4 () const;

    /**
     * Returns the value of the member "u32MetaDataTag4".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "u32MetaDataTag4"
     */
    inline uint32 getU32MetaDataTag4 () const;

    /**
     * Sets the value of the member "u32MetaDataTag4".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param u32MetaDataTag4 The value which will be set
     */
    inline void setU32MetaDataTag4 (uint32 u32MetaDataTag4_);

    // API of field "u32SampleRate"

    static const int kU32SampleRate = 26;

    /**
     * Clears the field "u32SampleRate".
     *
     * The field will be set to its default value. The hasU32SampleRate()
     * method will return false.
     */
    inline void clearU32SampleRate();

    /**
     * Checks whether the field "u32SampleRate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SampleRate()). Otherwise it will return false.
     */
    inline bool hasU32SampleRate () const;

    /**
     * Returns the value of the member "u32SampleRate".
     *
     * Sample rate of the currently played song
     *
     * @return The value of the field "u32SampleRate"
     */
    inline uint32 getU32SampleRate () const;

    /**
     * Sets the value of the member "u32SampleRate".
     *
     * Sample rate of the currently played song
     *
     * @param u32SampleRate The value which will be set
     */
    inline void setU32SampleRate (uint32 u32SampleRate_);

    // API of field "u32Tag"

    static const int kU32Tag = 27;

    /**
     * Clears the field "u32Tag".
     *
     * The field will be set to its default value. The hasU32Tag()
     * method will return false.
     */
    inline void clearU32Tag();

    /**
     * Checks whether the field "u32Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Tag()). Otherwise it will return false.
     */
    inline bool hasU32Tag () const;

    /**
     * Returns the value of the member "u32Tag".
     *
     * <p> Uniquely identifies any piece of meta-data information. The Tag value identifies the media object to play. </p>
     *
     * @return The value of the field "u32Tag"
     */
    inline uint32 getU32Tag () const;

    /**
     * Sets the value of the member "u32Tag".
     *
     * <p> Uniquely identifies any piece of meta-data information. The Tag value identifies the media object to play. </p>
     *
     * @param u32Tag The value which will be set
     */
    inline void setU32Tag (uint32 u32Tag_);

    // API of field "u32TotalPlaytime"

    static const int kU32TotalPlaytime = 28;

    /**
     * Clears the field "u32TotalPlaytime".
     *
     * The field will be set to its default value. The hasU32TotalPlaytime()
     * method will return false.
     */
    inline void clearU32TotalPlaytime();

    /**
     * Checks whether the field "u32TotalPlaytime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TotalPlaytime()). Otherwise it will return false.
     */
    inline bool hasU32TotalPlaytime () const;

    /**
     * Returns the value of the member "u32TotalPlaytime".
     *
     * Total playtime of the media object in seconds.
     *
     * @return The value of the field "u32TotalPlaytime"
     */
    inline uint32 getU32TotalPlaytime () const;

    /**
     * Sets the value of the member "u32TotalPlaytime".
     *
     * Total playtime of the media object in seconds.
     *
     * @param u32TotalPlaytime The value which will be set
     */
    inline void setU32TotalPlaytime (uint32 u32TotalPlaytime_);

    // API of field "u32Year"

    static const int kU32Year = 29;

    /**
     * Clears the field "u32Year".
     *
     * The field will be set to its default value. The hasU32Year()
     * method will return false.
     */
    inline void clearU32Year();

    /**
     * Checks whether the field "u32Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Year()). Otherwise it will return false.
     */
    inline bool hasU32Year () const;

    /**
     * Returns the value of the member "u32Year".
     *
     * Recording Year of the media object
     *
     * @return The value of the field "u32Year"
     */
    inline uint32 getU32Year () const;

    /**
     * Sets the value of the member "u32Year".
     *
     * Recording Year of the media object
     *
     * @param u32Year The value which will be set
     */
    inline void setU32Year (uint32 u32Year_);

    // API of field "u32YearID"

    static const int kU32YearID = 30;

    /**
     * Clears the field "u32YearID".
     *
     * The field will be set to its default value. The hasU32YearID()
     * method will return false.
     */
    inline void clearU32YearID();

    /**
     * Checks whether the field "u32YearID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32YearID()). Otherwise it will return false.
     */
    inline bool hasU32YearID () const;

    /**
     * Returns the value of the member "u32YearID".
     *
     * Recording Year ID of the media object
     *
     * @return The value of the field "u32YearID"
     */
    inline uint32 getU32YearID () const;

    /**
     * Sets the value of the member "u32YearID".
     *
     * Recording Year ID of the media object
     *
     * @param u32YearID The value which will be set
     */
    inline void setU32YearID (uint32 u32YearID_);

    // API of field "u64FileSize"

    static const int kU64FileSize = 31;

    /**
     * Clears the field "u64FileSize".
     *
     * The field will be set to its default value. The hasU64FileSize()
     * method will return false.
     */
    inline void clearU64FileSize();

    /**
     * Checks whether the field "u64FileSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64FileSize()). Otherwise it will return false.
     */
    inline bool hasU64FileSize () const;

    /**
     * Returns the value of the member "u64FileSize".
     *
     * File size in Byte
     *
     * @return The value of the field "u64FileSize"
     */
    inline uint64 getU64FileSize () const;

    /**
     * Sets the value of the member "u64FileSize".
     *
     * File size in Byte
     *
     * @param u64FileSize The value which will be set
     */
    inline void setU64FileSize (uint64 u64FileSize_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 32;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored. Actual physical devices are numbered starting with DeviceTag=0x01. DeviceTag of 0x00 is reserved as a virtual &quot;My Media&quot; device representing aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored. Actual physical devices are numbered starting with DeviceTag=0x01. DeviceTag of 0x00 is reserved as a virtual &quot;My Media&quot; device representing aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "u8TrackNumber"

    static const int kU8TrackNumber = 33;

    /**
     * Clears the field "u8TrackNumber".
     *
     * The field will be set to its default value. The hasU8TrackNumber()
     * method will return false.
     */
    inline void clearU8TrackNumber();

    /**
     * Checks whether the field "u8TrackNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TrackNumber()). Otherwise it will return false.
     */
    inline bool hasU8TrackNumber () const;

    /**
     * Returns the value of the member "u8TrackNumber".
     *
     * deprecatedThis parameter was incorrectly defined as a single byte instead of a word during the 1.X MY13 development. All new designs shall use the 16-bit ExtendedTrackNumber (added at 2.4.3 for MY14) instead.This parameter shall be set as follows (in order to handle the restricted range of a byte): <item> If the media object's track number is = 255, then TrackNumber shall be set to the track number. </item> <item> >If the media object's track number is > 255, then the TrackNumber shall be set to the track number shall be set to 0. </item> In all cases, the 16-bit ExtendedTrackNumber shall be set to the media object's track number (if present, of course, in the media object's meta-data).
     *
     * @return The value of the field "u8TrackNumber"
     */
    inline uint8 getU8TrackNumber () const;

    /**
     * Sets the value of the member "u8TrackNumber".
     *
     * deprecatedThis parameter was incorrectly defined as a single byte instead of a word during the 1.X MY13 development. All new designs shall use the 16-bit ExtendedTrackNumber (added at 2.4.3 for MY14) instead.This parameter shall be set as follows (in order to handle the restricted range of a byte): <item> If the media object's track number is = 255, then TrackNumber shall be set to the track number. </item> <item> >If the media object's track number is > 255, then the TrackNumber shall be set to the track number shall be set to 0. </item> In all cases, the 16-bit ExtendedTrackNumber shall be set to the media object's track number (if present, of course, in the media object's meta-data).
     *
     * @param u8TrackNumber The value which will be set
     */
    inline void setU8TrackNumber (uint8 u8TrackNumber_);

    // API of field "bIsFavorite"

    static const int kBIsFavorite = 34;

    /**
     * Clears the field "bIsFavorite".
     *
     * The field will be set to its default value. The hasBIsFavorite()
     * method will return false.
     */
    inline void clearBIsFavorite();

    /**
     * Checks whether the field "bIsFavorite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsFavorite()). Otherwise it will return false.
     */
    inline bool hasBIsFavorite () const;

    /**
     * Returns the value of the member "bIsFavorite".
     *
     * Flag to check if the mediaobject is user favorite or not
     *
     * @return The value of the field "bIsFavorite"
     */
    inline bool getBIsFavorite () const;

    /**
     * Sets the value of the member "bIsFavorite".
     *
     * Flag to check if the mediaobject is user favorite or not
     *
     * @param bIsFavorite The value which will be set
     */
    inline void setBIsFavorite (bool bIsFavorite_);

    static const T_MPlayMediaObject &getDefaultInstance();

private:

    inline void set_has_e8AudioChannelFormat ();

    inline void clear_has_e8AudioChannelFormat ();

    inline void set_has_e8CategoryType ();

    inline void clear_has_e8CategoryType ();

    inline void set_has_e8DeviceType ();

    inline void clear_has_e8DeviceType ();

    inline void set_has_e8FileFormat ();

    inline void clear_has_e8FileFormat ();

    inline void set_has_e8MediaType ();

    inline void clear_has_e8MediaType ();

    inline void set_has_e8PlayableStatus ();

    inline void clear_has_e8PlayableStatus ();

    inline void set_has_bIsPlaying ();

    inline void clear_has_bIsPlaying ();

    inline void set_has_bVBR ();

    inline void clear_has_bVBR ();

    inline void set_has_sAlbumArt ();

    inline void clear_has_sAlbumArt ();

    inline void set_has_sDateTime ();

    inline void clear_has_sDateTime ();

    inline void set_has_sDeviceVersion ();

    inline void clear_has_sDeviceVersion ();

    inline void set_has_sFilename ();

    inline void clear_has_sFilename ();

    inline void set_has_sMetaDataField1 ();

    inline void clear_has_sMetaDataField1 ();

    inline void set_has_sMetaDataField2 ();

    inline void clear_has_sMetaDataField2 ();

    inline void set_has_sMetaDataField3 ();

    inline void clear_has_sMetaDataField3 ();

    inline void set_has_sMetaDataField4 ();

    inline void clear_has_sMetaDataField4 ();

    inline void set_has_sYomiMetaDataTitle ();

    inline void clear_has_sYomiMetaDataTitle ();

    inline void set_has_sYomiMetaDataArtist ();

    inline void clear_has_sYomiMetaDataArtist ();

    inline void set_has_sYomiMetaDataAlbum ();

    inline void clear_has_sYomiMetaDataAlbum ();

    inline void set_has_sResolution ();

    inline void clear_has_sResolution ();

    inline void set_has_u16ExtendedTrackNumber ();

    inline void clear_has_u16ExtendedTrackNumber ();

    inline void set_has_u32BitRate ();

    inline void clear_has_u32BitRate ();

    inline void set_has_u32MetaDataTag1 ();

    inline void clear_has_u32MetaDataTag1 ();

    inline void set_has_u32MetaDataTag2 ();

    inline void clear_has_u32MetaDataTag2 ();

    inline void set_has_u32MetaDataTag3 ();

    inline void clear_has_u32MetaDataTag3 ();

    inline void set_has_u32MetaDataTag4 ();

    inline void clear_has_u32MetaDataTag4 ();

    inline void set_has_u32SampleRate ();

    inline void clear_has_u32SampleRate ();

    inline void set_has_u32Tag ();

    inline void clear_has_u32Tag ();

    inline void set_has_u32TotalPlaytime ();

    inline void clear_has_u32TotalPlaytime ();

    inline void set_has_u32Year ();

    inline void clear_has_u32Year ();

    inline void set_has_u32YearID ();

    inline void clear_has_u32YearID ();

    inline void set_has_u64FileSize ();

    inline void clear_has_u64FileSize ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_u8TrackNumber ();

    inline void clear_has_u8TrackNumber ();

    inline void set_has_bIsFavorite ();

    inline void clear_has_bIsFavorite ();

    uint32 _has_bits_[ (35 + 31) / 32];

    T_e8_MPlayAudioChannelFormat _e8AudioChannelFormat;

    T_e8_MPlayCategoryType _e8CategoryType;

    T_e8_MPlayDeviceType _e8DeviceType;

    T_e8_MPlayFileFormat _e8FileFormat;

    T_e8_MPlayMediaType _e8MediaType;

    T_e8_MPlayPlayableStatus _e8PlayableStatus;

    bool _bIsPlaying;

    bool _bVBR;

    ::std::string _sAlbumArt;

    ::std::string _sDateTime;

    ::std::string _sDeviceVersion;

    ::std::string _sFilename;

    ::std::string _sMetaDataField1;

    ::std::string _sMetaDataField2;

    ::std::string _sMetaDataField3;

    ::std::string _sMetaDataField4;

    ::std::string _sYomiMetaDataTitle;

    ::std::string _sYomiMetaDataArtist;

    ::std::string _sYomiMetaDataAlbum;

    ::std::string _sResolution;

    uint16 _u16ExtendedTrackNumber;

    uint32 _u32BitRate;

    uint32 _u32MetaDataTag1;

    uint32 _u32MetaDataTag2;

    uint32 _u32MetaDataTag3;

    uint32 _u32MetaDataTag4;

    uint32 _u32SampleRate;

    uint32 _u32Tag;

    uint32 _u32TotalPlaytime;

    uint32 _u32Year;

    uint32 _u32YearID;

    uint64 _u64FileSize;

    uint8 _u8DeviceTag;

    uint8 _u8TrackNumber;

    bool _bIsFavorite;

};

/**
 * AlbumArt, CategoryType, DeviceTag, DeviceType, DeviceVersion, FileFormat, Filename, IsPlaying, MediaType, MetaDataField1, MetaDataField2, MetaDataField3, MetaDataField4, MetaDataTag1, MetaDataTag2, MetaDataTag3, MetaDataTag4, Tag, TotalPlaytime, TrackNumber, PlayableStatus}
 */
class T_MPlayMediaObjectsItem {
public:

    /**
     * Default constructor
     */
    inline  T_MPlayMediaObjectsItem ();

    /**
     * Copy constructor
     */
    inline  T_MPlayMediaObjectsItem (const T_MPlayMediaObjectsItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MPlayMediaObjectsItem (T_e8_MPlayCategoryType e8CategoryType_, T_e8_MPlayDeviceType e8DeviceType_, T_e8_MPlayFileFormat e8FileFormat_, T_e8_MPlayMediaType e8MediaType_, T_e8_MPlayPlayableStatus e8PlayableStatus_, const T_MPlayImageData& oThumbnailData_, bool bIsPlaying_, bool bReadOnlyFlag_, const ::std::string& sAlbumArt_, const ::std::string& sCoverArt_, const ::std::string& sDateTime_, const ::std::string& sDeviceVersion_, const ::std::string& sFilename_, const ::std::string& sMetaDataField1_, const ::std::string& sMetaDataField2_, const ::std::string& sMetaDataField3_, const ::std::string& sMetaDataField4_, uint32 u32MetaDataTag1_, uint32 u32MetaDataTag2_, uint32 u32MetaDataTag3_, uint32 u32MetaDataTag4_, const ::std::string& sYomiMetaDataTitle_, const ::std::string& sYomiMetaDataArtist_, const ::std::string& sYomiMetaDataAlbum_, uint32 u32Tag_, uint32 u32TotalPlaytime_, uint32 u32Year_, uint32 u32YearID_, uint64 u64FileSize_, uint8 u8DeviceTag_, uint8 u8TrackNumber_, bool bIsFavorite_);

    /**
     * Destructor
     */
    inline  ~T_MPlayMediaObjectsItem();

    /**
     * Assignment operator
     */
    inline T_MPlayMediaObjectsItem& operator = (const T_MPlayMediaObjectsItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MPlayMediaObjectsItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MPlayMediaObjectsItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MPlayMediaObjectsItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MPlayMediaObjectsItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8CategoryType"

    static const int kE8CategoryType = 0;

    /**
     * Clears the field "e8CategoryType".
     *
     * The field will be set to its default value. The hasE8CategoryType()
     * method will return false.
     */
    inline void clearE8CategoryType();

    /**
     * Checks whether the field "e8CategoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CategoryType()). Otherwise it will return false.
     */
    inline bool hasE8CategoryType () const;

    /**
     * Returns the value of the member "e8CategoryType".
     *
     * Contains the category type of the media object.
     *
     * @return The value of the field "e8CategoryType"
     */
    inline T_e8_MPlayCategoryType getE8CategoryType () const;

    /**
     * Sets the value of the member "e8CategoryType".
     *
     * Contains the category type of the media object.
     *
     * @param e8CategoryType The value which will be set
     */
    inline void setE8CategoryType (T_e8_MPlayCategoryType e8CategoryType_);

    // API of field "e8DeviceType"

    static const int kE8DeviceType = 1;

    /**
     * Clears the field "e8DeviceType".
     *
     * The field will be set to its default value. The hasE8DeviceType()
     * method will return false.
     */
    inline void clearE8DeviceType();

    /**
     * Checks whether the field "e8DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceType()). Otherwise it will return false.
     */
    inline bool hasE8DeviceType () const;

    /**
     * Returns the value of the member "e8DeviceType".
     *
     * Type of device on which the media object is stored.
     *
     * @return The value of the field "e8DeviceType"
     */
    inline T_e8_MPlayDeviceType getE8DeviceType () const;

    /**
     * Sets the value of the member "e8DeviceType".
     *
     * Type of device on which the media object is stored.
     *
     * @param e8DeviceType The value which will be set
     */
    inline void setE8DeviceType (T_e8_MPlayDeviceType e8DeviceType_);

    // API of field "e8FileFormat"

    static const int kE8FileFormat = 2;

    /**
     * Clears the field "e8FileFormat".
     *
     * The field will be set to its default value. The hasE8FileFormat()
     * method will return false.
     */
    inline void clearE8FileFormat();

    /**
     * Checks whether the field "e8FileFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FileFormat()). Otherwise it will return false.
     */
    inline bool hasE8FileFormat () const;

    /**
     * Returns the value of the member "e8FileFormat".
     *
     * The format of a media file.
     *
     * @return The value of the field "e8FileFormat"
     */
    inline T_e8_MPlayFileFormat getE8FileFormat () const;

    /**
     * Sets the value of the member "e8FileFormat".
     *
     * The format of a media file.
     *
     * @param e8FileFormat The value which will be set
     */
    inline void setE8FileFormat (T_e8_MPlayFileFormat e8FileFormat_);

    // API of field "e8MediaType"

    static const int kE8MediaType = 3;

    /**
     * Clears the field "e8MediaType".
     *
     * The field will be set to its default value. The hasE8MediaType()
     * method will return false.
     */
    inline void clearE8MediaType();

    /**
     * Checks whether the field "e8MediaType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MediaType()). Otherwise it will return false.
     */
    inline bool hasE8MediaType () const;

    /**
     * Returns the value of the member "e8MediaType".
     *
     * Contains the type of media object.
     *
     * @return The value of the field "e8MediaType"
     */
    inline T_e8_MPlayMediaType getE8MediaType () const;

    /**
     * Sets the value of the member "e8MediaType".
     *
     * Contains the type of media object.
     *
     * @param e8MediaType The value which will be set
     */
    inline void setE8MediaType (T_e8_MPlayMediaType e8MediaType_);

    // API of field "e8PlayableStatus"

    static const int kE8PlayableStatus = 4;

    /**
     * Clears the field "e8PlayableStatus".
     *
     * The field will be set to its default value. The hasE8PlayableStatus()
     * method will return false.
     */
    inline void clearE8PlayableStatus();

    /**
     * Checks whether the field "e8PlayableStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlayableStatus()). Otherwise it will return false.
     */
    inline bool hasE8PlayableStatus () const;

    /**
     * Returns the value of the member "e8PlayableStatus".
     *
     * Playable status of object.
     *
     * @return The value of the field "e8PlayableStatus"
     */
    inline T_e8_MPlayPlayableStatus getE8PlayableStatus () const;

    /**
     * Sets the value of the member "e8PlayableStatus".
     *
     * Playable status of object.
     *
     * @param e8PlayableStatus The value which will be set
     */
    inline void setE8PlayableStatus (T_e8_MPlayPlayableStatus e8PlayableStatus_);

    // API of field "oThumbnailData"

    static const int kOThumbnailData = 5;

    /**
     * Clears the field "oThumbnailData".
     *
     * The field will be set to its default value. The hasOThumbnailData()
     * method will return false.
     */
    inline void clearOThumbnailData();

    /**
     * Checks whether the field "oThumbnailData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOThumbnailData()). Otherwise it will return false.
     */
    inline bool hasOThumbnailData () const;

    /**
     * Returns the value of the member "oThumbnailData".
     *
     * A thumbnail image
     *
     * @return The value of the field "oThumbnailData"
     */
    inline const T_MPlayImageData& getOThumbnailData () const;

    /**
     * Retrieves the value of the field "oThumbnailData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oThumbnailData".
     */
    inline T_MPlayImageData& getOThumbnailDataMutable ();

    /**
     * Sets the value of the member "oThumbnailData".
     *
     * A thumbnail image
     *
     * @param oThumbnailData The value which will be set
     */
    inline void setOThumbnailData (const T_MPlayImageData& oThumbnailData_);

    // API of field "bIsPlaying"

    static const int kBIsPlaying = 6;

    /**
     * Clears the field "bIsPlaying".
     *
     * The field will be set to its default value. The hasBIsPlaying()
     * method will return false.
     */
    inline void clearBIsPlaying();

    /**
     * Checks whether the field "bIsPlaying" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsPlaying()). Otherwise it will return false.
     */
    inline bool hasBIsPlaying () const;

    /**
     * Returns the value of the member "bIsPlaying".
     *
     * Defines whether the media object is currently being played. This parameter is True when the media object is currently being played and False otherwise.
     *
     * @return The value of the field "bIsPlaying"
     */
    inline bool getBIsPlaying () const;

    /**
     * Sets the value of the member "bIsPlaying".
     *
     * Defines whether the media object is currently being played. This parameter is True when the media object is currently being played and False otherwise.
     *
     * @param bIsPlaying The value which will be set
     */
    inline void setBIsPlaying (bool bIsPlaying_);

    // API of field "bReadOnlyFlag"

    static const int kBReadOnlyFlag = 7;

    /**
     * Clears the field "bReadOnlyFlag".
     *
     * The field will be set to its default value. The hasBReadOnlyFlag()
     * method will return false.
     */
    inline void clearBReadOnlyFlag();

    /**
     * Checks whether the field "bReadOnlyFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBReadOnlyFlag()). Otherwise it will return false.
     */
    inline bool hasBReadOnlyFlag () const;

    /**
     * Returns the value of the member "bReadOnlyFlag".
     *
     * File is neither writable nor deletable, hence read only
     *
     * @return The value of the field "bReadOnlyFlag"
     */
    inline bool getBReadOnlyFlag () const;

    /**
     * Sets the value of the member "bReadOnlyFlag".
     *
     * File is neither writable nor deletable, hence read only
     *
     * @param bReadOnlyFlag The value which will be set
     */
    inline void setBReadOnlyFlag (bool bReadOnlyFlag_);

    // API of field "sAlbumArt"

    static const int kSAlbumArt = 8;

    /**
     * Clears the field "sAlbumArt".
     *
     * The field will be set to its default value. The hasSAlbumArt()
     * method will return false.
     */
    inline void clearSAlbumArt();

    /**
     * Checks whether the field "sAlbumArt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAlbumArt()). Otherwise it will return false.
     */
    inline bool hasSAlbumArt () const;

    /**
     * Returns the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @return The value of the field "sAlbumArt"
     */
    inline const ::std::string& getSAlbumArt () const;

    /**
     * Retrieves the value of the field "sAlbumArt" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAlbumArt".
     */
    inline ::std::string& getSAlbumArtMutable ();

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const ::std::string& sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* value, size_t size);

    // API of field "sCoverArt"

    static const int kSCoverArt = 9;

    /**
     * Clears the field "sCoverArt".
     *
     * The field will be set to its default value. The hasSCoverArt()
     * method will return false.
     */
    inline void clearSCoverArt();

    /**
     * Checks whether the field "sCoverArt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCoverArt()). Otherwise it will return false.
     */
    inline bool hasSCoverArt () const;

    /**
     * Returns the value of the member "sCoverArt".
     *
     * Path to a cover art image on the flash
     *
     * @return The value of the field "sCoverArt"
     */
    inline const ::std::string& getSCoverArt () const;

    /**
     * Retrieves the value of the field "sCoverArt" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCoverArt".
     */
    inline ::std::string& getSCoverArtMutable ();

    /**
     * Sets the value of the member "sCoverArt".
     *
     * Path to a cover art image on the flash
     *
     * @param sCoverArt The value which will be set
     */
    inline void setSCoverArt (const ::std::string& sCoverArt_);

    /**
     * Sets the value of the member "sCoverArt".
     *
     * Path to a cover art image on the flash
     *
     * @param sCoverArt The value which will be set
     */
    inline void setSCoverArt (const char* sCoverArt_);

    /**
     * Sets the value of the member "sCoverArt".
     *
     * Path to a cover art image on the flash
     *
     * @param sCoverArt The value which will be set
     */
    inline void setSCoverArt (const char* value, size_t size);

    // API of field "sDateTime"

    static const int kSDateTime = 10;

    /**
     * Clears the field "sDateTime".
     *
     * The field will be set to its default value. The hasSDateTime()
     * method will return false.
     */
    inline void clearSDateTime();

    /**
     * Checks whether the field "sDateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDateTime()). Otherwise it will return false.
     */
    inline bool hasSDateTime () const;

    /**
     * Returns the value of the member "sDateTime".
     *
     * Last file modification date and time in Y:m:d H:M:S
     *
     * @return The value of the field "sDateTime"
     */
    inline const ::std::string& getSDateTime () const;

    /**
     * Retrieves the value of the field "sDateTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDateTime".
     */
    inline ::std::string& getSDateTimeMutable ();

    /**
     * Sets the value of the member "sDateTime".
     *
     * Last file modification date and time in Y:m:d H:M:S
     *
     * @param sDateTime The value which will be set
     */
    inline void setSDateTime (const ::std::string& sDateTime_);

    /**
     * Sets the value of the member "sDateTime".
     *
     * Last file modification date and time in Y:m:d H:M:S
     *
     * @param sDateTime The value which will be set
     */
    inline void setSDateTime (const char* sDateTime_);

    /**
     * Sets the value of the member "sDateTime".
     *
     * Last file modification date and time in Y:m:d H:M:S
     *
     * @param sDateTime The value which will be set
     */
    inline void setSDateTime (const char* value, size_t size);

    // API of field "sDeviceVersion"

    static const int kSDeviceVersion = 11;

    /**
     * Clears the field "sDeviceVersion".
     *
     * The field will be set to its default value. The hasSDeviceVersion()
     * method will return false.
     */
    inline void clearSDeviceVersion();

    /**
     * Checks whether the field "sDeviceVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceVersion()). Otherwise it will return false.
     */
    inline bool hasSDeviceVersion () const;

    /**
     * Returns the value of the member "sDeviceVersion".
     *
     * Version (or other identifying information) of the device. For example, this parameter could contain which version of the Bluetooth AVRCP profile is running.
     *
     * @return The value of the field "sDeviceVersion"
     */
    inline const ::std::string& getSDeviceVersion () const;

    /**
     * Retrieves the value of the field "sDeviceVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceVersion".
     */
    inline ::std::string& getSDeviceVersionMutable ();

    /**
     * Sets the value of the member "sDeviceVersion".
     *
     * Version (or other identifying information) of the device. For example, this parameter could contain which version of the Bluetooth AVRCP profile is running.
     *
     * @param sDeviceVersion The value which will be set
     */
    inline void setSDeviceVersion (const ::std::string& sDeviceVersion_);

    /**
     * Sets the value of the member "sDeviceVersion".
     *
     * Version (or other identifying information) of the device. For example, this parameter could contain which version of the Bluetooth AVRCP profile is running.
     *
     * @param sDeviceVersion The value which will be set
     */
    inline void setSDeviceVersion (const char* sDeviceVersion_);

    /**
     * Sets the value of the member "sDeviceVersion".
     *
     * Version (or other identifying information) of the device. For example, this parameter could contain which version of the Bluetooth AVRCP profile is running.
     *
     * @param sDeviceVersion The value which will be set
     */
    inline void setSDeviceVersion (const char* value, size_t size);

    // API of field "sFilename"

    static const int kSFilename = 12;

    /**
     * Clears the field "sFilename".
     *
     * The field will be set to its default value. The hasSFilename()
     * method will return false.
     */
    inline void clearSFilename();

    /**
     * Checks whether the field "sFilename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFilename()). Otherwise it will return false.
     */
    inline bool hasSFilename () const;

    /**
     * Returns the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @return The value of the field "sFilename"
     */
    inline const ::std::string& getSFilename () const;

    /**
     * Retrieves the value of the field "sFilename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFilename".
     */
    inline ::std::string& getSFilenameMutable ();

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const ::std::string& sFilename_);

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const char* sFilename_);

    /**
     * Sets the value of the member "sFilename".
     *
     * Filename (URL) of the media object to play
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const char* value, size_t size);

    // API of field "sMetaDataField1"

    static const int kSMetaDataField1 = 13;

    /**
     * Clears the field "sMetaDataField1".
     *
     * The field will be set to its default value. The hasSMetaDataField1()
     * method will return false.
     */
    inline void clearSMetaDataField1();

    /**
     * Checks whether the field "sMetaDataField1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMetaDataField1()). Otherwise it will return false.
     */
    inline bool hasSMetaDataField1 () const;

    /**
     * Returns the value of the member "sMetaDataField1".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "sMetaDataField1"
     */
    inline const ::std::string& getSMetaDataField1 () const;

    /**
     * Retrieves the value of the field "sMetaDataField1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMetaDataField1".
     */
    inline ::std::string& getSMetaDataField1Mutable ();

    /**
     * Sets the value of the member "sMetaDataField1".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField1 The value which will be set
     */
    inline void setSMetaDataField1 (const ::std::string& sMetaDataField1_);

    /**
     * Sets the value of the member "sMetaDataField1".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField1 The value which will be set
     */
    inline void setSMetaDataField1 (const char* sMetaDataField1_);

    /**
     * Sets the value of the member "sMetaDataField1".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField1 The value which will be set
     */
    inline void setSMetaDataField1 (const char* value, size_t size);

    // API of field "sMetaDataField2"

    static const int kSMetaDataField2 = 14;

    /**
     * Clears the field "sMetaDataField2".
     *
     * The field will be set to its default value. The hasSMetaDataField2()
     * method will return false.
     */
    inline void clearSMetaDataField2();

    /**
     * Checks whether the field "sMetaDataField2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMetaDataField2()). Otherwise it will return false.
     */
    inline bool hasSMetaDataField2 () const;

    /**
     * Returns the value of the member "sMetaDataField2".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "sMetaDataField2"
     */
    inline const ::std::string& getSMetaDataField2 () const;

    /**
     * Retrieves the value of the field "sMetaDataField2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMetaDataField2".
     */
    inline ::std::string& getSMetaDataField2Mutable ();

    /**
     * Sets the value of the member "sMetaDataField2".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField2 The value which will be set
     */
    inline void setSMetaDataField2 (const ::std::string& sMetaDataField2_);

    /**
     * Sets the value of the member "sMetaDataField2".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField2 The value which will be set
     */
    inline void setSMetaDataField2 (const char* sMetaDataField2_);

    /**
     * Sets the value of the member "sMetaDataField2".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField2 The value which will be set
     */
    inline void setSMetaDataField2 (const char* value, size_t size);

    // API of field "sMetaDataField3"

    static const int kSMetaDataField3 = 15;

    /**
     * Clears the field "sMetaDataField3".
     *
     * The field will be set to its default value. The hasSMetaDataField3()
     * method will return false.
     */
    inline void clearSMetaDataField3();

    /**
     * Checks whether the field "sMetaDataField3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMetaDataField3()). Otherwise it will return false.
     */
    inline bool hasSMetaDataField3 () const;

    /**
     * Returns the value of the member "sMetaDataField3".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "sMetaDataField3"
     */
    inline const ::std::string& getSMetaDataField3 () const;

    /**
     * Retrieves the value of the field "sMetaDataField3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMetaDataField3".
     */
    inline ::std::string& getSMetaDataField3Mutable ();

    /**
     * Sets the value of the member "sMetaDataField3".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField3 The value which will be set
     */
    inline void setSMetaDataField3 (const ::std::string& sMetaDataField3_);

    /**
     * Sets the value of the member "sMetaDataField3".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField3 The value which will be set
     */
    inline void setSMetaDataField3 (const char* sMetaDataField3_);

    /**
     * Sets the value of the member "sMetaDataField3".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField3 The value which will be set
     */
    inline void setSMetaDataField3 (const char* value, size_t size);

    // API of field "sMetaDataField4"

    static const int kSMetaDataField4 = 16;

    /**
     * Clears the field "sMetaDataField4".
     *
     * The field will be set to its default value. The hasSMetaDataField4()
     * method will return false.
     */
    inline void clearSMetaDataField4();

    /**
     * Checks whether the field "sMetaDataField4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMetaDataField4()). Otherwise it will return false.
     */
    inline bool hasSMetaDataField4 () const;

    /**
     * Returns the value of the member "sMetaDataField4".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "sMetaDataField4"
     */
    inline const ::std::string& getSMetaDataField4 () const;

    /**
     * Retrieves the value of the field "sMetaDataField4" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMetaDataField4".
     */
    inline ::std::string& getSMetaDataField4Mutable ();

    /**
     * Sets the value of the member "sMetaDataField4".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField4 The value which will be set
     */
    inline void setSMetaDataField4 (const ::std::string& sMetaDataField4_);

    /**
     * Sets the value of the member "sMetaDataField4".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField4 The value which will be set
     */
    inline void setSMetaDataField4 (const char* sMetaDataField4_);

    /**
     * Sets the value of the member "sMetaDataField4".
     *
     * Specifies a piece of meta-data information for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param sMetaDataField4 The value which will be set
     */
    inline void setSMetaDataField4 (const char* value, size_t size);

    // API of field "u32MetaDataTag1"

    static const int kU32MetaDataTag1 = 17;

    /**
     * Clears the field "u32MetaDataTag1".
     *
     * The field will be set to its default value. The hasU32MetaDataTag1()
     * method will return false.
     */
    inline void clearU32MetaDataTag1();

    /**
     * Checks whether the field "u32MetaDataTag1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MetaDataTag1()). Otherwise it will return false.
     */
    inline bool hasU32MetaDataTag1 () const;

    /**
     * Returns the value of the member "u32MetaDataTag1".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "u32MetaDataTag1"
     */
    inline uint32 getU32MetaDataTag1 () const;

    /**
     * Sets the value of the member "u32MetaDataTag1".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param u32MetaDataTag1 The value which will be set
     */
    inline void setU32MetaDataTag1 (uint32 u32MetaDataTag1_);

    // API of field "u32MetaDataTag2"

    static const int kU32MetaDataTag2 = 18;

    /**
     * Clears the field "u32MetaDataTag2".
     *
     * The field will be set to its default value. The hasU32MetaDataTag2()
     * method will return false.
     */
    inline void clearU32MetaDataTag2();

    /**
     * Checks whether the field "u32MetaDataTag2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MetaDataTag2()). Otherwise it will return false.
     */
    inline bool hasU32MetaDataTag2 () const;

    /**
     * Returns the value of the member "u32MetaDataTag2".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "u32MetaDataTag2"
     */
    inline uint32 getU32MetaDataTag2 () const;

    /**
     * Sets the value of the member "u32MetaDataTag2".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param u32MetaDataTag2 The value which will be set
     */
    inline void setU32MetaDataTag2 (uint32 u32MetaDataTag2_);

    // API of field "u32MetaDataTag3"

    static const int kU32MetaDataTag3 = 19;

    /**
     * Clears the field "u32MetaDataTag3".
     *
     * The field will be set to its default value. The hasU32MetaDataTag3()
     * method will return false.
     */
    inline void clearU32MetaDataTag3();

    /**
     * Checks whether the field "u32MetaDataTag3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MetaDataTag3()). Otherwise it will return false.
     */
    inline bool hasU32MetaDataTag3 () const;

    /**
     * Returns the value of the member "u32MetaDataTag3".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "u32MetaDataTag3"
     */
    inline uint32 getU32MetaDataTag3 () const;

    /**
     * Sets the value of the member "u32MetaDataTag3".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param u32MetaDataTag3 The value which will be set
     */
    inline void setU32MetaDataTag3 (uint32 u32MetaDataTag3_);

    // API of field "u32MetaDataTag4"

    static const int kU32MetaDataTag4 = 20;

    /**
     * Clears the field "u32MetaDataTag4".
     *
     * The field will be set to its default value. The hasU32MetaDataTag4()
     * method will return false.
     */
    inline void clearU32MetaDataTag4();

    /**
     * Checks whether the field "u32MetaDataTag4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MetaDataTag4()). Otherwise it will return false.
     */
    inline bool hasU32MetaDataTag4 () const;

    /**
     * Returns the value of the member "u32MetaDataTag4".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @return The value of the field "u32MetaDataTag4"
     */
    inline uint32 getU32MetaDataTag4 () const;

    /**
     * Sets the value of the member "u32MetaDataTag4".
     *
     * Specifies that Tag value associated with a piece of meta-data for the object. The content of the field is dependent on the CategoryType of the object.
     *
     * @param u32MetaDataTag4 The value which will be set
     */
    inline void setU32MetaDataTag4 (uint32 u32MetaDataTag4_);

    // API of field "sYomiMetaDataTitle"

    static const int kSYomiMetaDataTitle = 21;

    /**
     * Clears the field "sYomiMetaDataTitle".
     *
     * The field will be set to its default value. The hasSYomiMetaDataTitle()
     * method will return false.
     */
    inline void clearSYomiMetaDataTitle();

    /**
     * Checks whether the field "sYomiMetaDataTitle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSYomiMetaDataTitle()). Otherwise it will return false.
     */
    inline bool hasSYomiMetaDataTitle () const;

    /**
     * Returns the value of the member "sYomiMetaDataTitle".
     *
     * Contains the yomi metadata Title for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @return The value of the field "sYomiMetaDataTitle"
     */
    inline const ::std::string& getSYomiMetaDataTitle () const;

    /**
     * Retrieves the value of the field "sYomiMetaDataTitle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sYomiMetaDataTitle".
     */
    inline ::std::string& getSYomiMetaDataTitleMutable ();

    /**
     * Sets the value of the member "sYomiMetaDataTitle".
     *
     * Contains the yomi metadata Title for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataTitle The value which will be set
     */
    inline void setSYomiMetaDataTitle (const ::std::string& sYomiMetaDataTitle_);

    /**
     * Sets the value of the member "sYomiMetaDataTitle".
     *
     * Contains the yomi metadata Title for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataTitle The value which will be set
     */
    inline void setSYomiMetaDataTitle (const char* sYomiMetaDataTitle_);

    /**
     * Sets the value of the member "sYomiMetaDataTitle".
     *
     * Contains the yomi metadata Title for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataTitle The value which will be set
     */
    inline void setSYomiMetaDataTitle (const char* value, size_t size);

    // API of field "sYomiMetaDataArtist"

    static const int kSYomiMetaDataArtist = 22;

    /**
     * Clears the field "sYomiMetaDataArtist".
     *
     * The field will be set to its default value. The hasSYomiMetaDataArtist()
     * method will return false.
     */
    inline void clearSYomiMetaDataArtist();

    /**
     * Checks whether the field "sYomiMetaDataArtist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSYomiMetaDataArtist()). Otherwise it will return false.
     */
    inline bool hasSYomiMetaDataArtist () const;

    /**
     * Returns the value of the member "sYomiMetaDataArtist".
     *
     * Contains the yomi metadata Artist for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @return The value of the field "sYomiMetaDataArtist"
     */
    inline const ::std::string& getSYomiMetaDataArtist () const;

    /**
     * Retrieves the value of the field "sYomiMetaDataArtist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sYomiMetaDataArtist".
     */
    inline ::std::string& getSYomiMetaDataArtistMutable ();

    /**
     * Sets the value of the member "sYomiMetaDataArtist".
     *
     * Contains the yomi metadata Artist for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataArtist The value which will be set
     */
    inline void setSYomiMetaDataArtist (const ::std::string& sYomiMetaDataArtist_);

    /**
     * Sets the value of the member "sYomiMetaDataArtist".
     *
     * Contains the yomi metadata Artist for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataArtist The value which will be set
     */
    inline void setSYomiMetaDataArtist (const char* sYomiMetaDataArtist_);

    /**
     * Sets the value of the member "sYomiMetaDataArtist".
     *
     * Contains the yomi metadata Artist for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataArtist The value which will be set
     */
    inline void setSYomiMetaDataArtist (const char* value, size_t size);

    // API of field "sYomiMetaDataAlbum"

    static const int kSYomiMetaDataAlbum = 23;

    /**
     * Clears the field "sYomiMetaDataAlbum".
     *
     * The field will be set to its default value. The hasSYomiMetaDataAlbum()
     * method will return false.
     */
    inline void clearSYomiMetaDataAlbum();

    /**
     * Checks whether the field "sYomiMetaDataAlbum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSYomiMetaDataAlbum()). Otherwise it will return false.
     */
    inline bool hasSYomiMetaDataAlbum () const;

    /**
     * Returns the value of the member "sYomiMetaDataAlbum".
     *
     * Contains the yomi metadata Album for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @return The value of the field "sYomiMetaDataAlbum"
     */
    inline const ::std::string& getSYomiMetaDataAlbum () const;

    /**
     * Retrieves the value of the field "sYomiMetaDataAlbum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sYomiMetaDataAlbum".
     */
    inline ::std::string& getSYomiMetaDataAlbumMutable ();

    /**
     * Sets the value of the member "sYomiMetaDataAlbum".
     *
     * Contains the yomi metadata Album for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataAlbum The value which will be set
     */
    inline void setSYomiMetaDataAlbum (const ::std::string& sYomiMetaDataAlbum_);

    /**
     * Sets the value of the member "sYomiMetaDataAlbum".
     *
     * Contains the yomi metadata Album for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataAlbum The value which will be set
     */
    inline void setSYomiMetaDataAlbum (const char* sYomiMetaDataAlbum_);

    /**
     * Sets the value of the member "sYomiMetaDataAlbum".
     *
     * Contains the yomi metadata Album for the object. This field will be filled only when the cdripping with gracenote feature is enabled.
     *
     * @param sYomiMetaDataAlbum The value which will be set
     */
    inline void setSYomiMetaDataAlbum (const char* value, size_t size);

    // API of field "u32Tag"

    static const int kU32Tag = 24;

    /**
     * Clears the field "u32Tag".
     *
     * The field will be set to its default value. The hasU32Tag()
     * method will return false.
     */
    inline void clearU32Tag();

    /**
     * Checks whether the field "u32Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Tag()). Otherwise it will return false.
     */
    inline bool hasU32Tag () const;

    /**
     * Returns the value of the member "u32Tag".
     *
     * <p> Uniquely identifies any piece of meta-data information. The Tag value identifies the media object to play. </p>
     *
     * @return The value of the field "u32Tag"
     */
    inline uint32 getU32Tag () const;

    /**
     * Sets the value of the member "u32Tag".
     *
     * <p> Uniquely identifies any piece of meta-data information. The Tag value identifies the media object to play. </p>
     *
     * @param u32Tag The value which will be set
     */
    inline void setU32Tag (uint32 u32Tag_);

    // API of field "u32TotalPlaytime"

    static const int kU32TotalPlaytime = 25;

    /**
     * Clears the field "u32TotalPlaytime".
     *
     * The field will be set to its default value. The hasU32TotalPlaytime()
     * method will return false.
     */
    inline void clearU32TotalPlaytime();

    /**
     * Checks whether the field "u32TotalPlaytime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TotalPlaytime()). Otherwise it will return false.
     */
    inline bool hasU32TotalPlaytime () const;

    /**
     * Returns the value of the member "u32TotalPlaytime".
     *
     * Total playtime of the media object in seconds.
     *
     * @return The value of the field "u32TotalPlaytime"
     */
    inline uint32 getU32TotalPlaytime () const;

    /**
     * Sets the value of the member "u32TotalPlaytime".
     *
     * Total playtime of the media object in seconds.
     *
     * @param u32TotalPlaytime The value which will be set
     */
    inline void setU32TotalPlaytime (uint32 u32TotalPlaytime_);

    // API of field "u32Year"

    static const int kU32Year = 26;

    /**
     * Clears the field "u32Year".
     *
     * The field will be set to its default value. The hasU32Year()
     * method will return false.
     */
    inline void clearU32Year();

    /**
     * Checks whether the field "u32Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Year()). Otherwise it will return false.
     */
    inline bool hasU32Year () const;

    /**
     * Returns the value of the member "u32Year".
     *
     * Recording Year of the media object
     *
     * @return The value of the field "u32Year"
     */
    inline uint32 getU32Year () const;

    /**
     * Sets the value of the member "u32Year".
     *
     * Recording Year of the media object
     *
     * @param u32Year The value which will be set
     */
    inline void setU32Year (uint32 u32Year_);

    // API of field "u32YearID"

    static const int kU32YearID = 27;

    /**
     * Clears the field "u32YearID".
     *
     * The field will be set to its default value. The hasU32YearID()
     * method will return false.
     */
    inline void clearU32YearID();

    /**
     * Checks whether the field "u32YearID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32YearID()). Otherwise it will return false.
     */
    inline bool hasU32YearID () const;

    /**
     * Returns the value of the member "u32YearID".
     *
     * Recording Year ID of the media object
     *
     * @return The value of the field "u32YearID"
     */
    inline uint32 getU32YearID () const;

    /**
     * Sets the value of the member "u32YearID".
     *
     * Recording Year ID of the media object
     *
     * @param u32YearID The value which will be set
     */
    inline void setU32YearID (uint32 u32YearID_);

    // API of field "u64FileSize"

    static const int kU64FileSize = 28;

    /**
     * Clears the field "u64FileSize".
     *
     * The field will be set to its default value. The hasU64FileSize()
     * method will return false.
     */
    inline void clearU64FileSize();

    /**
     * Checks whether the field "u64FileSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64FileSize()). Otherwise it will return false.
     */
    inline bool hasU64FileSize () const;

    /**
     * Returns the value of the member "u64FileSize".
     *
     * File size in Byte
     *
     * @return The value of the field "u64FileSize"
     */
    inline uint64 getU64FileSize () const;

    /**
     * Sets the value of the member "u64FileSize".
     *
     * File size in Byte
     *
     * @param u64FileSize The value which will be set
     */
    inline void setU64FileSize (uint64 u64FileSize_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 29;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored. Actual physical devices are numbered starting with DeviceTag=0x01. DeviceTag of 0x00 is reserved as a virtual &quot;My Media&quot; device representing aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored. Actual physical devices are numbered starting with DeviceTag=0x01. DeviceTag of 0x00 is reserved as a virtual &quot;My Media&quot; device representing aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "u8TrackNumber"

    static const int kU8TrackNumber = 30;

    /**
     * Clears the field "u8TrackNumber".
     *
     * The field will be set to its default value. The hasU8TrackNumber()
     * method will return false.
     */
    inline void clearU8TrackNumber();

    /**
     * Checks whether the field "u8TrackNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TrackNumber()). Otherwise it will return false.
     */
    inline bool hasU8TrackNumber () const;

    /**
     * Returns the value of the member "u8TrackNumber".
     *
     * deprecatedThis parameter was incorrectly defined as a single byte instead of a word during the 1.X MY13 development. All new designs shall use the 16-bit ExtendedTrackNumber (added at 2.4.3 for MY14) instead.This parameter shall be set as follows (in order to handle the restricted range of a byte): <item> If the media object's track number is = 255, then TrackNumber shall be set to the track number. </item> <item> >If the media object's track number is > 255, then the TrackNumber shall be set to the track number shall be set to 0. </item> In all cases, the 16-bit ExtendedTrackNumber shall be set to the media object's track number (if present, of course, in the media object's meta-data).
     *
     * @return The value of the field "u8TrackNumber"
     */
    inline uint8 getU8TrackNumber () const;

    /**
     * Sets the value of the member "u8TrackNumber".
     *
     * deprecatedThis parameter was incorrectly defined as a single byte instead of a word during the 1.X MY13 development. All new designs shall use the 16-bit ExtendedTrackNumber (added at 2.4.3 for MY14) instead.This parameter shall be set as follows (in order to handle the restricted range of a byte): <item> If the media object's track number is = 255, then TrackNumber shall be set to the track number. </item> <item> >If the media object's track number is > 255, then the TrackNumber shall be set to the track number shall be set to 0. </item> In all cases, the 16-bit ExtendedTrackNumber shall be set to the media object's track number (if present, of course, in the media object's meta-data).
     *
     * @param u8TrackNumber The value which will be set
     */
    inline void setU8TrackNumber (uint8 u8TrackNumber_);

    // API of field "bIsFavorite"

    static const int kBIsFavorite = 31;

    /**
     * Clears the field "bIsFavorite".
     *
     * The field will be set to its default value. The hasBIsFavorite()
     * method will return false.
     */
    inline void clearBIsFavorite();

    /**
     * Checks whether the field "bIsFavorite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsFavorite()). Otherwise it will return false.
     */
    inline bool hasBIsFavorite () const;

    /**
     * Returns the value of the member "bIsFavorite".
     *
     * Flag to check if the mediaobject is user favorite or not
     *
     * @return The value of the field "bIsFavorite"
     */
    inline bool getBIsFavorite () const;

    /**
     * Sets the value of the member "bIsFavorite".
     *
     * Flag to check if the mediaobject is user favorite or not
     *
     * @param bIsFavorite The value which will be set
     */
    inline void setBIsFavorite (bool bIsFavorite_);

    static const T_MPlayMediaObjectsItem &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8CategoryType ();

    inline void clear_has_e8CategoryType ();

    inline void set_has_e8DeviceType ();

    inline void clear_has_e8DeviceType ();

    inline void set_has_e8FileFormat ();

    inline void clear_has_e8FileFormat ();

    inline void set_has_e8MediaType ();

    inline void clear_has_e8MediaType ();

    inline void set_has_e8PlayableStatus ();

    inline void clear_has_e8PlayableStatus ();

    inline void set_has_oThumbnailData ();

    inline void clear_has_oThumbnailData ();

    inline void set_has_bIsPlaying ();

    inline void clear_has_bIsPlaying ();

    inline void set_has_bReadOnlyFlag ();

    inline void clear_has_bReadOnlyFlag ();

    inline void set_has_sAlbumArt ();

    inline void clear_has_sAlbumArt ();

    inline void set_has_sCoverArt ();

    inline void clear_has_sCoverArt ();

    inline void set_has_sDateTime ();

    inline void clear_has_sDateTime ();

    inline void set_has_sDeviceVersion ();

    inline void clear_has_sDeviceVersion ();

    inline void set_has_sFilename ();

    inline void clear_has_sFilename ();

    inline void set_has_sMetaDataField1 ();

    inline void clear_has_sMetaDataField1 ();

    inline void set_has_sMetaDataField2 ();

    inline void clear_has_sMetaDataField2 ();

    inline void set_has_sMetaDataField3 ();

    inline void clear_has_sMetaDataField3 ();

    inline void set_has_sMetaDataField4 ();

    inline void clear_has_sMetaDataField4 ();

    inline void set_has_u32MetaDataTag1 ();

    inline void clear_has_u32MetaDataTag1 ();

    inline void set_has_u32MetaDataTag2 ();

    inline void clear_has_u32MetaDataTag2 ();

    inline void set_has_u32MetaDataTag3 ();

    inline void clear_has_u32MetaDataTag3 ();

    inline void set_has_u32MetaDataTag4 ();

    inline void clear_has_u32MetaDataTag4 ();

    inline void set_has_sYomiMetaDataTitle ();

    inline void clear_has_sYomiMetaDataTitle ();

    inline void set_has_sYomiMetaDataArtist ();

    inline void clear_has_sYomiMetaDataArtist ();

    inline void set_has_sYomiMetaDataAlbum ();

    inline void clear_has_sYomiMetaDataAlbum ();

    inline void set_has_u32Tag ();

    inline void clear_has_u32Tag ();

    inline void set_has_u32TotalPlaytime ();

    inline void clear_has_u32TotalPlaytime ();

    inline void set_has_u32Year ();

    inline void clear_has_u32Year ();

    inline void set_has_u32YearID ();

    inline void clear_has_u32YearID ();

    inline void set_has_u64FileSize ();

    inline void clear_has_u64FileSize ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_u8TrackNumber ();

    inline void clear_has_u8TrackNumber ();

    inline void set_has_bIsFavorite ();

    inline void clear_has_bIsFavorite ();

    uint32 _has_bits_[ (32 + 31) / 32];

    T_e8_MPlayCategoryType _e8CategoryType;

    T_e8_MPlayDeviceType _e8DeviceType;

    T_e8_MPlayFileFormat _e8FileFormat;

    T_e8_MPlayMediaType _e8MediaType;

    T_e8_MPlayPlayableStatus _e8PlayableStatus;

    T_MPlayImageData _oThumbnailData;

    bool _bIsPlaying;

    bool _bReadOnlyFlag;

    ::std::string _sAlbumArt;

    ::std::string _sCoverArt;

    ::std::string _sDateTime;

    ::std::string _sDeviceVersion;

    ::std::string _sFilename;

    ::std::string _sMetaDataField1;

    ::std::string _sMetaDataField2;

    ::std::string _sMetaDataField3;

    ::std::string _sMetaDataField4;

    uint32 _u32MetaDataTag1;

    uint32 _u32MetaDataTag2;

    uint32 _u32MetaDataTag3;

    uint32 _u32MetaDataTag4;

    ::std::string _sYomiMetaDataTitle;

    ::std::string _sYomiMetaDataArtist;

    ::std::string _sYomiMetaDataAlbum;

    uint32 _u32Tag;

    uint32 _u32TotalPlaytime;

    uint32 _u32Year;

    uint32 _u32YearID;

    uint64 _u64FileSize;

    uint8 _u8DeviceTag;

    uint8 _u8TrackNumber;

    bool _bIsFavorite;

};

/**
 * File Permission and Object tag will be associated to change read only permission
 */
class T_PermissionByTag {
public:

    /**
     * Default constructor
     */
    inline  T_PermissionByTag ();

    /**
     * Copy constructor
     */
    inline  T_PermissionByTag (const T_PermissionByTag &rhs);

    /**
     * All fields constructor
     */
    inline  T_PermissionByTag (bool bReadOnlyFlag_, uint32 MediaObjectTag_);

    /**
     * Destructor
     */
    inline  ~T_PermissionByTag();

    /**
     * Assignment operator
     */
    inline T_PermissionByTag& operator = (const T_PermissionByTag& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PermissionByTag& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PermissionByTag& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PermissionByTag& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PermissionByTag& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bReadOnlyFlag"

    static const int kBReadOnlyFlag = 0;

    /**
     * Clears the field "bReadOnlyFlag".
     *
     * The field will be set to its default value. The hasBReadOnlyFlag()
     * method will return false.
     */
    inline void clearBReadOnlyFlag();

    /**
     * Checks whether the field "bReadOnlyFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBReadOnlyFlag()). Otherwise it will return false.
     */
    inline bool hasBReadOnlyFlag () const;

    /**
     * Returns the value of the member "bReadOnlyFlag".
     *
     * bReadOnlyFlag is TRUE to set read only flag
     *
     * @return The value of the field "bReadOnlyFlag"
     */
    inline bool getBReadOnlyFlag () const;

    /**
     * Sets the value of the member "bReadOnlyFlag".
     *
     * bReadOnlyFlag is TRUE to set read only flag
     *
     * @param bReadOnlyFlag The value which will be set
     */
    inline void setBReadOnlyFlag (bool bReadOnlyFlag_);

    // API of field "MediaObjectTag"

    static const int kMediaObjectTag = 1;

    /**
     * Clears the field "MediaObjectTag".
     *
     * The field will be set to its default value. The hasMediaObjectTag()
     * method will return false.
     */
    inline void clearMediaObjectTag();

    /**
     * Checks whether the field "MediaObjectTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaObjectTag()). Otherwise it will return false.
     */
    inline bool hasMediaObjectTag () const;

    /**
     * Returns the value of the member "MediaObjectTag".
     *
     *
     *
     * @return The value of the field "MediaObjectTag"
     */
    inline uint32 getMediaObjectTag () const;

    /**
     * Sets the value of the member "MediaObjectTag".
     *
     *
     *
     * @param MediaObjectTag The value which will be set
     */
    inline void setMediaObjectTag (uint32 MediaObjectTag_);

    static const T_PermissionByTag &getDefaultInstance();

private:

    inline void set_has_bReadOnlyFlag ();

    inline void clear_has_bReadOnlyFlag ();

    inline void set_has_MediaObjectTag ();

    inline void clear_has_MediaObjectTag ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bReadOnlyFlag;

    uint32 _MediaObjectTag;

};

class T_MPlayRippingStateResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_MPlayRippingStateResultItem ();

    /**
     * Copy constructor
     */
    inline  T_MPlayRippingStateResultItem (const T_MPlayRippingStateResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MPlayRippingStateResultItem (T_e8_MPlayDeviceRippingState e8DeviceRippingState_, uint8 u8DeviceTag_, uint8 u8RippingPercentComplete_, uint8 TotalTracksInCD_, uint8 CurrentRippedTrackIndex_);

    /**
     * Destructor
     */
    inline  ~T_MPlayRippingStateResultItem();

    /**
     * Assignment operator
     */
    inline T_MPlayRippingStateResultItem& operator = (const T_MPlayRippingStateResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MPlayRippingStateResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MPlayRippingStateResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MPlayRippingStateResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MPlayRippingStateResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DeviceRippingState"

    static const int kE8DeviceRippingState = 0;

    /**
     * Clears the field "e8DeviceRippingState".
     *
     * The field will be set to its default value. The hasE8DeviceRippingState()
     * method will return false.
     */
    inline void clearE8DeviceRippingState();

    /**
     * Checks whether the field "e8DeviceRippingState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceRippingState()). Otherwise it will return false.
     */
    inline bool hasE8DeviceRippingState () const;

    /**
     * Returns the value of the member "e8DeviceRippingState".
     *
     * Identifies the state of the ripping operation: Not supported, not started, partially ripped, or complete.
     * It also gives details about the total tracks in CD , current ripped index and percentage ripped.
     *
     * @return The value of the field "e8DeviceRippingState"
     */
    inline T_e8_MPlayDeviceRippingState getE8DeviceRippingState () const;

    /**
     * Sets the value of the member "e8DeviceRippingState".
     *
     * Identifies the state of the ripping operation: Not supported, not started, partially ripped, or complete.
     * It also gives details about the total tracks in CD , current ripped index and percentage ripped.
     *
     * @param e8DeviceRippingState The value which will be set
     */
    inline void setE8DeviceRippingState (T_e8_MPlayDeviceRippingState e8DeviceRippingState_);

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 1;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored. Actual physical devices are numbered starting with DeviceTag=0x01. DeviceTag of 0x00 is reserved as a virtual &quot;My Media&quot; device representing aggregated content across all devices currently connected.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device on which the media object is stored. Actual physical devices are numbered starting with DeviceTag=0x01. DeviceTag of 0x00 is reserved as a virtual &quot;My Media&quot; device representing aggregated content across all devices currently connected.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "u8RippingPercentComplete"

    static const int kU8RippingPercentComplete = 2;

    /**
     * Clears the field "u8RippingPercentComplete".
     *
     * The field will be set to its default value. The hasU8RippingPercentComplete()
     * method will return false.
     */
    inline void clearU8RippingPercentComplete();

    /**
     * Checks whether the field "u8RippingPercentComplete" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RippingPercentComplete()). Otherwise it will return false.
     */
    inline bool hasU8RippingPercentComplete () const;

    /**
     * Returns the value of the member "u8RippingPercentComplete".
     *
     * Percent completion of the ripping operation for a given device.
     *
     * @return The value of the field "u8RippingPercentComplete"
     */
    inline uint8 getU8RippingPercentComplete () const;

    /**
     * Sets the value of the member "u8RippingPercentComplete".
     *
     * Percent completion of the ripping operation for a given device.
     *
     * @param u8RippingPercentComplete The value which will be set
     */
    inline void setU8RippingPercentComplete (uint8 u8RippingPercentComplete_);

    // API of field "TotalTracksInCD"

    static const int kTotalTracksInCD = 3;

    /**
     * Clears the field "TotalTracksInCD".
     *
     * The field will be set to its default value. The hasTotalTracksInCD()
     * method will return false.
     */
    inline void clearTotalTracksInCD();

    /**
     * Checks whether the field "TotalTracksInCD" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTotalTracksInCD()). Otherwise it will return false.
     */
    inline bool hasTotalTracksInCD () const;

    /**
     * Returns the value of the member "TotalTracksInCD".
     *
     * Total tracks available in the CD which is ripping.
     *
     * @return The value of the field "TotalTracksInCD"
     */
    inline uint8 getTotalTracksInCD () const;

    /**
     * Sets the value of the member "TotalTracksInCD".
     *
     * Total tracks available in the CD which is ripping.
     *
     * @param TotalTracksInCD The value which will be set
     */
    inline void setTotalTracksInCD (uint8 TotalTracksInCD_);

    // API of field "CurrentRippedTrackIndex"

    static const int kCurrentRippedTrackIndex = 4;

    /**
     * Clears the field "CurrentRippedTrackIndex".
     *
     * The field will be set to its default value. The hasCurrentRippedTrackIndex()
     * method will return false.
     */
    inline void clearCurrentRippedTrackIndex();

    /**
     * Checks whether the field "CurrentRippedTrackIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentRippedTrackIndex()). Otherwise it will return false.
     */
    inline bool hasCurrentRippedTrackIndex () const;

    /**
     * Returns the value of the member "CurrentRippedTrackIndex".
     *
     * Index of the current Track which has been ripped
     *
     * @return The value of the field "CurrentRippedTrackIndex"
     */
    inline uint8 getCurrentRippedTrackIndex () const;

    /**
     * Sets the value of the member "CurrentRippedTrackIndex".
     *
     * Index of the current Track which has been ripped
     *
     * @param CurrentRippedTrackIndex The value which will be set
     */
    inline void setCurrentRippedTrackIndex (uint8 CurrentRippedTrackIndex_);

    static const T_MPlayRippingStateResultItem &getDefaultInstance();

private:

    inline void set_has_e8DeviceRippingState ();

    inline void clear_has_e8DeviceRippingState ();

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_u8RippingPercentComplete ();

    inline void clear_has_u8RippingPercentComplete ();

    inline void set_has_TotalTracksInCD ();

    inline void clear_has_TotalTracksInCD ();

    inline void set_has_CurrentRippedTrackIndex ();

    inline void clear_has_CurrentRippedTrackIndex ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_MPlayDeviceRippingState _e8DeviceRippingState;

    uint8 _u8DeviceTag;

    uint8 _u8RippingPercentComplete;

    uint8 _TotalTracksInCD;

    uint8 _CurrentRippedTrackIndex;

};

/**
 * SearchKeyboardLetter, LetterAvailable, LetterStartIndex, LetterEndIndex
 */
class T_MPlaySearchKeyboardListItem {
public:

    /**
     * Default constructor
     */
    inline  T_MPlaySearchKeyboardListItem ();

    /**
     * Copy constructor
     */
    inline  T_MPlaySearchKeyboardListItem (const T_MPlaySearchKeyboardListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MPlaySearchKeyboardListItem (bool bLetterAvailable_, const ::std::string& sSearchKeyboardLetter_, uint32 u32LetterEndIndex_, uint32 u32LetterStartIndex_);

    /**
     * Destructor
     */
    inline  ~T_MPlaySearchKeyboardListItem();

    /**
     * Assignment operator
     */
    inline T_MPlaySearchKeyboardListItem& operator = (const T_MPlaySearchKeyboardListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MPlaySearchKeyboardListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MPlaySearchKeyboardListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MPlaySearchKeyboardListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MPlaySearchKeyboardListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bLetterAvailable"

    static const int kBLetterAvailable = 0;

    /**
     * Clears the field "bLetterAvailable".
     *
     * The field will be set to its default value. The hasBLetterAvailable()
     * method will return false.
     */
    inline void clearBLetterAvailable();

    /**
     * Checks whether the field "bLetterAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBLetterAvailable()). Otherwise it will return false.
     */
    inline bool hasBLetterAvailable () const;

    /**
     * Returns the value of the member "bLetterAvailable".
     *
     * Identifies whether a media object that begins with the associated letter is available.
     *
     * @return The value of the field "bLetterAvailable"
     */
    inline bool getBLetterAvailable () const;

    /**
     * Sets the value of the member "bLetterAvailable".
     *
     * Identifies whether a media object that begins with the associated letter is available.
     *
     * @param bLetterAvailable The value which will be set
     */
    inline void setBLetterAvailable (bool bLetterAvailable_);

    // API of field "sSearchKeyboardLetter"

    static const int kSSearchKeyboardLetter = 1;

    /**
     * Clears the field "sSearchKeyboardLetter".
     *
     * The field will be set to its default value. The hasSSearchKeyboardLetter()
     * method will return false.
     */
    inline void clearSSearchKeyboardLetter();

    /**
     * Checks whether the field "sSearchKeyboardLetter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSearchKeyboardLetter()). Otherwise it will return false.
     */
    inline bool hasSSearchKeyboardLetter () const;

    /**
     * Returns the value of the member "sSearchKeyboardLetter".
     *
     * Letter of the alphabet.
     *
     * @return The value of the field "sSearchKeyboardLetter"
     */
    inline const ::std::string& getSSearchKeyboardLetter () const;

    /**
     * Retrieves the value of the field "sSearchKeyboardLetter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSearchKeyboardLetter".
     */
    inline ::std::string& getSSearchKeyboardLetterMutable ();

    /**
     * Sets the value of the member "sSearchKeyboardLetter".
     *
     * Letter of the alphabet.
     *
     * @param sSearchKeyboardLetter The value which will be set
     */
    inline void setSSearchKeyboardLetter (const ::std::string& sSearchKeyboardLetter_);

    /**
     * Sets the value of the member "sSearchKeyboardLetter".
     *
     * Letter of the alphabet.
     *
     * @param sSearchKeyboardLetter The value which will be set
     */
    inline void setSSearchKeyboardLetter (const char* sSearchKeyboardLetter_);

    /**
     * Sets the value of the member "sSearchKeyboardLetter".
     *
     * Letter of the alphabet.
     *
     * @param sSearchKeyboardLetter The value which will be set
     */
    inline void setSSearchKeyboardLetter (const char* value, size_t size);

    // API of field "u32LetterEndIndex"

    static const int kU32LetterEndIndex = 2;

    /**
     * Clears the field "u32LetterEndIndex".
     *
     * The field will be set to its default value. The hasU32LetterEndIndex()
     * method will return false.
     */
    inline void clearU32LetterEndIndex();

    /**
     * Checks whether the field "u32LetterEndIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32LetterEndIndex()). Otherwise it will return false.
     */
    inline bool hasU32LetterEndIndex () const;

    /**
     * Returns the value of the member "u32LetterEndIndex".
     *
     * Specifies the index for the last media object that begins with the selected letter.
     *
     * @return The value of the field "u32LetterEndIndex"
     */
    inline uint32 getU32LetterEndIndex () const;

    /**
     * Sets the value of the member "u32LetterEndIndex".
     *
     * Specifies the index for the last media object that begins with the selected letter.
     *
     * @param u32LetterEndIndex The value which will be set
     */
    inline void setU32LetterEndIndex (uint32 u32LetterEndIndex_);

    // API of field "u32LetterStartIndex"

    static const int kU32LetterStartIndex = 3;

    /**
     * Clears the field "u32LetterStartIndex".
     *
     * The field will be set to its default value. The hasU32LetterStartIndex()
     * method will return false.
     */
    inline void clearU32LetterStartIndex();

    /**
     * Checks whether the field "u32LetterStartIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32LetterStartIndex()). Otherwise it will return false.
     */
    inline bool hasU32LetterStartIndex () const;

    /**
     * Returns the value of the member "u32LetterStartIndex".
     *
     * Specifies the index for the first contact that begins with the selected letter.
     *
     * @return The value of the field "u32LetterStartIndex"
     */
    inline uint32 getU32LetterStartIndex () const;

    /**
     * Sets the value of the member "u32LetterStartIndex".
     *
     * Specifies the index for the first contact that begins with the selected letter.
     *
     * @param u32LetterStartIndex The value which will be set
     */
    inline void setU32LetterStartIndex (uint32 u32LetterStartIndex_);

    static const T_MPlaySearchKeyboardListItem &getDefaultInstance();

private:

    inline void set_has_bLetterAvailable ();

    inline void clear_has_bLetterAvailable ();

    inline void set_has_sSearchKeyboardLetter ();

    inline void clear_has_sSearchKeyboardLetter ();

    inline void set_has_u32LetterEndIndex ();

    inline void clear_has_u32LetterEndIndex ();

    inline void set_has_u32LetterStartIndex ();

    inline void clear_has_u32LetterStartIndex ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _bLetterAvailable;

    ::std::string _sSearchKeyboardLetter;

    uint32 _u32LetterEndIndex;

    uint32 _u32LetterStartIndex;

};

/**
 * TagTrackName, TagArtistName, TagChannelNumber, TagChannelName, TagAffiliateID, TagURL, TagSongID
 */
class T_MPlayTagTransferItem_1 {
public:

    /**
     * Default constructor
     */
    inline  T_MPlayTagTransferItem_1 ();

    /**
     * Copy constructor
     */
    inline  T_MPlayTagTransferItem_1 (const T_MPlayTagTransferItem_1 &rhs);

    /**
     * All fields constructor
     */
    inline  T_MPlayTagTransferItem_1 (const ::fi_basetypes::T_ShortStream& oUnknownData_, const ::std::string& sPodCastFeedURL_, const ::std::string& sStationURL_, const ::std::string& sStationURLFrequency_, const ::std::string& sTagAffiliateID_, const ::std::string& sTagAlbum_, const ::std::string& sTagArtistName_, const ::std::string& sTagChannelName_, const ::std::string& sTagChannelNumber_, const ::std::string& sTagGenre_, const ::std::string& sTagTimeStamp_, const ::std::string& sTagTrackName_, uint32 u32TagSongID_, uint8 u8AmbiguousTag_, uint8 u8ButtonPressed_, uint8 u8TagProgramNumber_, uint8 u8TagStorefrontID_);

    /**
     * Destructor
     */
    inline  ~T_MPlayTagTransferItem_1();

    /**
     * Assignment operator
     */
    inline T_MPlayTagTransferItem_1& operator = (const T_MPlayTagTransferItem_1& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MPlayTagTransferItem_1& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MPlayTagTransferItem_1& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MPlayTagTransferItem_1& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MPlayTagTransferItem_1& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oUnknownData"

    static const int kOUnknownData = 0;

    /**
     * Clears the field "oUnknownData".
     *
     * The field will be set to its default value. The hasOUnknownData()
     * method will return false.
     */
    inline void clearOUnknownData();

    /**
     * Checks whether the field "oUnknownData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOUnknownData()). Otherwise it will return false.
     */
    inline bool hasOUnknownData () const;

    /**
     * Returns the value of the member "oUnknownData".
     *
     *
     *
     * @return The value of the field "oUnknownData"
     */
    inline const ::fi_basetypes::T_ShortStream& getOUnknownData () const;

    /**
     * Retrieves the value of the field "oUnknownData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oUnknownData".
     */
    inline ::fi_basetypes::T_ShortStream& getOUnknownDataMutable ();

    /**
     * Sets the value of the member "oUnknownData".
     *
     *
     *
     * @param oUnknownData The value which will be set
     */
    inline void setOUnknownData (const ::fi_basetypes::T_ShortStream& oUnknownData_);

    // API of field "sPodCastFeedURL"

    static const int kSPodCastFeedURL = 1;

    /**
     * Clears the field "sPodCastFeedURL".
     *
     * The field will be set to its default value. The hasSPodCastFeedURL()
     * method will return false.
     */
    inline void clearSPodCastFeedURL();

    /**
     * Checks whether the field "sPodCastFeedURL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPodCastFeedURL()). Otherwise it will return false.
     */
    inline bool hasSPodCastFeedURL () const;

    /**
     * Returns the value of the member "sPodCastFeedURL".
     *
     * The PodCastFeedURL encoded as a String. For some implementations, such as the iPod, that encode this data as an integer, the decimal representation of the integer value shall be rendered as a String.
     *
     * @return The value of the field "sPodCastFeedURL"
     */
    inline const ::std::string& getSPodCastFeedURL () const;

    /**
     * Retrieves the value of the field "sPodCastFeedURL" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPodCastFeedURL".
     */
    inline ::std::string& getSPodCastFeedURLMutable ();

    /**
     * Sets the value of the member "sPodCastFeedURL".
     *
     * The PodCastFeedURL encoded as a String. For some implementations, such as the iPod, that encode this data as an integer, the decimal representation of the integer value shall be rendered as a String.
     *
     * @param sPodCastFeedURL The value which will be set
     */
    inline void setSPodCastFeedURL (const ::std::string& sPodCastFeedURL_);

    /**
     * Sets the value of the member "sPodCastFeedURL".
     *
     * The PodCastFeedURL encoded as a String. For some implementations, such as the iPod, that encode this data as an integer, the decimal representation of the integer value shall be rendered as a String.
     *
     * @param sPodCastFeedURL The value which will be set
     */
    inline void setSPodCastFeedURL (const char* sPodCastFeedURL_);

    /**
     * Sets the value of the member "sPodCastFeedURL".
     *
     * The PodCastFeedURL encoded as a String. For some implementations, such as the iPod, that encode this data as an integer, the decimal representation of the integer value shall be rendered as a String.
     *
     * @param sPodCastFeedURL The value which will be set
     */
    inline void setSPodCastFeedURL (const char* value, size_t size);

    // API of field "sStationURL"

    static const int kSStationURL = 2;

    /**
     * Clears the field "sStationURL".
     *
     * The field will be set to its default value. The hasSStationURL()
     * method will return false.
     */
    inline void clearSStationURL();

    /**
     * Checks whether the field "sStationURL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSStationURL()). Otherwise it will return false.
     */
    inline bool hasSStationURL () const;

    /**
     * Returns the value of the member "sStationURL".
     *
     * URL related to the station upon which the content was tagged.
     *
     * @return The value of the field "sStationURL"
     */
    inline const ::std::string& getSStationURL () const;

    /**
     * Retrieves the value of the field "sStationURL" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sStationURL".
     */
    inline ::std::string& getSStationURLMutable ();

    /**
     * Sets the value of the member "sStationURL".
     *
     * URL related to the station upon which the content was tagged.
     *
     * @param sStationURL The value which will be set
     */
    inline void setSStationURL (const ::std::string& sStationURL_);

    /**
     * Sets the value of the member "sStationURL".
     *
     * URL related to the station upon which the content was tagged.
     *
     * @param sStationURL The value which will be set
     */
    inline void setSStationURL (const char* sStationURL_);

    /**
     * Sets the value of the member "sStationURL".
     *
     * URL related to the station upon which the content was tagged.
     *
     * @param sStationURL The value which will be set
     */
    inline void setSStationURL (const char* value, size_t size);

    // API of field "sStationURLFrequency"

    static const int kSStationURLFrequency = 3;

    /**
     * Clears the field "sStationURLFrequency".
     *
     * The field will be set to its default value. The hasSStationURLFrequency()
     * method will return false.
     */
    inline void clearSStationURLFrequency();

    /**
     * Checks whether the field "sStationURLFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSStationURLFrequency()). Otherwise it will return false.
     */
    inline bool hasSStationURLFrequency () const;

    /**
     * Returns the value of the member "sStationURLFrequency".
     *
     * This is how frequently the customer portable device is supposed to be checking for updates of new podcast releases.
     *
     * @return The value of the field "sStationURLFrequency"
     */
    inline const ::std::string& getSStationURLFrequency () const;

    /**
     * Retrieves the value of the field "sStationURLFrequency" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sStationURLFrequency".
     */
    inline ::std::string& getSStationURLFrequencyMutable ();

    /**
     * Sets the value of the member "sStationURLFrequency".
     *
     * This is how frequently the customer portable device is supposed to be checking for updates of new podcast releases.
     *
     * @param sStationURLFrequency The value which will be set
     */
    inline void setSStationURLFrequency (const ::std::string& sStationURLFrequency_);

    /**
     * Sets the value of the member "sStationURLFrequency".
     *
     * This is how frequently the customer portable device is supposed to be checking for updates of new podcast releases.
     *
     * @param sStationURLFrequency The value which will be set
     */
    inline void setSStationURLFrequency (const char* sStationURLFrequency_);

    /**
     * Sets the value of the member "sStationURLFrequency".
     *
     * This is how frequently the customer portable device is supposed to be checking for updates of new podcast releases.
     *
     * @param sStationURLFrequency The value which will be set
     */
    inline void setSStationURLFrequency (const char* value, size_t size);

    // API of field "sTagAffiliateID"

    static const int kSTagAffiliateID = 4;

    /**
     * Clears the field "sTagAffiliateID".
     *
     * The field will be set to its default value. The hasSTagAffiliateID()
     * method will return false.
     */
    inline void clearSTagAffiliateID();

    /**
     * Checks whether the field "sTagAffiliateID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagAffiliateID()). Otherwise it will return false.
     */
    inline bool hasSTagAffiliateID () const;

    /**
     * Returns the value of the member "sTagAffiliateID".
     *
     * Product affiliate ID
     *
     * @return The value of the field "sTagAffiliateID"
     */
    inline const ::std::string& getSTagAffiliateID () const;

    /**
     * Retrieves the value of the field "sTagAffiliateID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagAffiliateID".
     */
    inline ::std::string& getSTagAffiliateIDMutable ();

    /**
     * Sets the value of the member "sTagAffiliateID".
     *
     * Product affiliate ID
     *
     * @param sTagAffiliateID The value which will be set
     */
    inline void setSTagAffiliateID (const ::std::string& sTagAffiliateID_);

    /**
     * Sets the value of the member "sTagAffiliateID".
     *
     * Product affiliate ID
     *
     * @param sTagAffiliateID The value which will be set
     */
    inline void setSTagAffiliateID (const char* sTagAffiliateID_);

    /**
     * Sets the value of the member "sTagAffiliateID".
     *
     * Product affiliate ID
     *
     * @param sTagAffiliateID The value which will be set
     */
    inline void setSTagAffiliateID (const char* value, size_t size);

    // API of field "sTagAlbum"

    static const int kSTagAlbum = 5;

    /**
     * Clears the field "sTagAlbum".
     *
     * The field will be set to its default value. The hasSTagAlbum()
     * method will return false.
     */
    inline void clearSTagAlbum();

    /**
     * Checks whether the field "sTagAlbum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagAlbum()). Otherwise it will return false.
     */
    inline bool hasSTagAlbum () const;

    /**
     * Returns the value of the member "sTagAlbum".
     *
     * Album of a tagged song
     *
     * @return The value of the field "sTagAlbum"
     */
    inline const ::std::string& getSTagAlbum () const;

    /**
     * Retrieves the value of the field "sTagAlbum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagAlbum".
     */
    inline ::std::string& getSTagAlbumMutable ();

    /**
     * Sets the value of the member "sTagAlbum".
     *
     * Album of a tagged song
     *
     * @param sTagAlbum The value which will be set
     */
    inline void setSTagAlbum (const ::std::string& sTagAlbum_);

    /**
     * Sets the value of the member "sTagAlbum".
     *
     * Album of a tagged song
     *
     * @param sTagAlbum The value which will be set
     */
    inline void setSTagAlbum (const char* sTagAlbum_);

    /**
     * Sets the value of the member "sTagAlbum".
     *
     * Album of a tagged song
     *
     * @param sTagAlbum The value which will be set
     */
    inline void setSTagAlbum (const char* value, size_t size);

    // API of field "sTagArtistName"

    static const int kSTagArtistName = 6;

    /**
     * Clears the field "sTagArtistName".
     *
     * The field will be set to its default value. The hasSTagArtistName()
     * method will return false.
     */
    inline void clearSTagArtistName();

    /**
     * Checks whether the field "sTagArtistName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagArtistName()). Otherwise it will return false.
     */
    inline bool hasSTagArtistName () const;

    /**
     * Returns the value of the member "sTagArtistName".
     *
     * Artist of a tagged song
     *
     * @return The value of the field "sTagArtistName"
     */
    inline const ::std::string& getSTagArtistName () const;

    /**
     * Retrieves the value of the field "sTagArtistName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagArtistName".
     */
    inline ::std::string& getSTagArtistNameMutable ();

    /**
     * Sets the value of the member "sTagArtistName".
     *
     * Artist of a tagged song
     *
     * @param sTagArtistName The value which will be set
     */
    inline void setSTagArtistName (const ::std::string& sTagArtistName_);

    /**
     * Sets the value of the member "sTagArtistName".
     *
     * Artist of a tagged song
     *
     * @param sTagArtistName The value which will be set
     */
    inline void setSTagArtistName (const char* sTagArtistName_);

    /**
     * Sets the value of the member "sTagArtistName".
     *
     * Artist of a tagged song
     *
     * @param sTagArtistName The value which will be set
     */
    inline void setSTagArtistName (const char* value, size_t size);

    // API of field "sTagChannelName"

    static const int kSTagChannelName = 7;

    /**
     * Clears the field "sTagChannelName".
     *
     * The field will be set to its default value. The hasSTagChannelName()
     * method will return false.
     */
    inline void clearSTagChannelName();

    /**
     * Checks whether the field "sTagChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagChannelName()). Otherwise it will return false.
     */
    inline bool hasSTagChannelName () const;

    /**
     * Returns the value of the member "sTagChannelName".
     *
     * Name of the channel that was playing the tagged track
     *
     * @return The value of the field "sTagChannelName"
     */
    inline const ::std::string& getSTagChannelName () const;

    /**
     * Retrieves the value of the field "sTagChannelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagChannelName".
     */
    inline ::std::string& getSTagChannelNameMutable ();

    /**
     * Sets the value of the member "sTagChannelName".
     *
     * Name of the channel that was playing the tagged track
     *
     * @param sTagChannelName The value which will be set
     */
    inline void setSTagChannelName (const ::std::string& sTagChannelName_);

    /**
     * Sets the value of the member "sTagChannelName".
     *
     * Name of the channel that was playing the tagged track
     *
     * @param sTagChannelName The value which will be set
     */
    inline void setSTagChannelName (const char* sTagChannelName_);

    /**
     * Sets the value of the member "sTagChannelName".
     *
     * Name of the channel that was playing the tagged track
     *
     * @param sTagChannelName The value which will be set
     */
    inline void setSTagChannelName (const char* value, size_t size);

    // API of field "sTagChannelNumber"

    static const int kSTagChannelNumber = 8;

    /**
     * Clears the field "sTagChannelNumber".
     *
     * The field will be set to its default value. The hasSTagChannelNumber()
     * method will return false.
     */
    inline void clearSTagChannelNumber();

    /**
     * Checks whether the field "sTagChannelNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagChannelNumber()). Otherwise it will return false.
     */
    inline bool hasSTagChannelNumber () const;

    /**
     * Returns the value of the member "sTagChannelNumber".
     *
     * Number of the channel that was playing the tagged song
     *
     * @return The value of the field "sTagChannelNumber"
     */
    inline const ::std::string& getSTagChannelNumber () const;

    /**
     * Retrieves the value of the field "sTagChannelNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagChannelNumber".
     */
    inline ::std::string& getSTagChannelNumberMutable ();

    /**
     * Sets the value of the member "sTagChannelNumber".
     *
     * Number of the channel that was playing the tagged song
     *
     * @param sTagChannelNumber The value which will be set
     */
    inline void setSTagChannelNumber (const ::std::string& sTagChannelNumber_);

    /**
     * Sets the value of the member "sTagChannelNumber".
     *
     * Number of the channel that was playing the tagged song
     *
     * @param sTagChannelNumber The value which will be set
     */
    inline void setSTagChannelNumber (const char* sTagChannelNumber_);

    /**
     * Sets the value of the member "sTagChannelNumber".
     *
     * Number of the channel that was playing the tagged song
     *
     * @param sTagChannelNumber The value which will be set
     */
    inline void setSTagChannelNumber (const char* value, size_t size);

    // API of field "sTagGenre"

    static const int kSTagGenre = 9;

    /**
     * Clears the field "sTagGenre".
     *
     * The field will be set to its default value. The hasSTagGenre()
     * method will return false.
     */
    inline void clearSTagGenre();

    /**
     * Checks whether the field "sTagGenre" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagGenre()). Otherwise it will return false.
     */
    inline bool hasSTagGenre () const;

    /**
     * Returns the value of the member "sTagGenre".
     *
     * Genre of a tagged song
     *
     * @return The value of the field "sTagGenre"
     */
    inline const ::std::string& getSTagGenre () const;

    /**
     * Retrieves the value of the field "sTagGenre" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagGenre".
     */
    inline ::std::string& getSTagGenreMutable ();

    /**
     * Sets the value of the member "sTagGenre".
     *
     * Genre of a tagged song
     *
     * @param sTagGenre The value which will be set
     */
    inline void setSTagGenre (const ::std::string& sTagGenre_);

    /**
     * Sets the value of the member "sTagGenre".
     *
     * Genre of a tagged song
     *
     * @param sTagGenre The value which will be set
     */
    inline void setSTagGenre (const char* sTagGenre_);

    /**
     * Sets the value of the member "sTagGenre".
     *
     * Genre of a tagged song
     *
     * @param sTagGenre The value which will be set
     */
    inline void setSTagGenre (const char* value, size_t size);

    // API of field "sTagTimeStamp"

    static const int kSTagTimeStamp = 10;

    /**
     * Clears the field "sTagTimeStamp".
     *
     * The field will be set to its default value. The hasSTagTimeStamp()
     * method will return false.
     */
    inline void clearSTagTimeStamp();

    /**
     * Checks whether the field "sTagTimeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagTimeStamp()). Otherwise it will return false.
     */
    inline bool hasSTagTimeStamp () const;

    /**
     * Returns the value of the member "sTagTimeStamp".
     *
     *
     *
     * @return The value of the field "sTagTimeStamp"
     */
    inline const ::std::string& getSTagTimeStamp () const;

    /**
     * Retrieves the value of the field "sTagTimeStamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagTimeStamp".
     */
    inline ::std::string& getSTagTimeStampMutable ();

    /**
     * Sets the value of the member "sTagTimeStamp".
     *
     *
     *
     * @param sTagTimeStamp The value which will be set
     */
    inline void setSTagTimeStamp (const ::std::string& sTagTimeStamp_);

    /**
     * Sets the value of the member "sTagTimeStamp".
     *
     *
     *
     * @param sTagTimeStamp The value which will be set
     */
    inline void setSTagTimeStamp (const char* sTagTimeStamp_);

    /**
     * Sets the value of the member "sTagTimeStamp".
     *
     *
     *
     * @param sTagTimeStamp The value which will be set
     */
    inline void setSTagTimeStamp (const char* value, size_t size);

    // API of field "sTagTrackName"

    static const int kSTagTrackName = 11;

    /**
     * Clears the field "sTagTrackName".
     *
     * The field will be set to its default value. The hasSTagTrackName()
     * method will return false.
     */
    inline void clearSTagTrackName();

    /**
     * Checks whether the field "sTagTrackName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagTrackName()). Otherwise it will return false.
     */
    inline bool hasSTagTrackName () const;

    /**
     * Returns the value of the member "sTagTrackName".
     *
     * Title of the track
     *
     * @return The value of the field "sTagTrackName"
     */
    inline const ::std::string& getSTagTrackName () const;

    /**
     * Retrieves the value of the field "sTagTrackName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagTrackName".
     */
    inline ::std::string& getSTagTrackNameMutable ();

    /**
     * Sets the value of the member "sTagTrackName".
     *
     * Title of the track
     *
     * @param sTagTrackName The value which will be set
     */
    inline void setSTagTrackName (const ::std::string& sTagTrackName_);

    /**
     * Sets the value of the member "sTagTrackName".
     *
     * Title of the track
     *
     * @param sTagTrackName The value which will be set
     */
    inline void setSTagTrackName (const char* sTagTrackName_);

    /**
     * Sets the value of the member "sTagTrackName".
     *
     * Title of the track
     *
     * @param sTagTrackName The value which will be set
     */
    inline void setSTagTrackName (const char* value, size_t size);

    // API of field "u32TagSongID"

    static const int kU32TagSongID = 12;

    /**
     * Clears the field "u32TagSongID".
     *
     * The field will be set to its default value. The hasU32TagSongID()
     * method will return false.
     */
    inline void clearU32TagSongID();

    /**
     * Checks whether the field "u32TagSongID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TagSongID()). Otherwise it will return false.
     */
    inline bool hasU32TagSongID () const;

    /**
     * Returns the value of the member "u32TagSongID".
     *
     * Song Identifier, such as the iTunes Song ID
     *
     * @return The value of the field "u32TagSongID"
     */
    inline uint32 getU32TagSongID () const;

    /**
     * Sets the value of the member "u32TagSongID".
     *
     * Song Identifier, such as the iTunes Song ID
     *
     * @param u32TagSongID The value which will be set
     */
    inline void setU32TagSongID (uint32 u32TagSongID_);

    // API of field "u8AmbiguousTag"

    static const int kU8AmbiguousTag = 13;

    /**
     * Clears the field "u8AmbiguousTag".
     *
     * The field will be set to its default value. The hasU8AmbiguousTag()
     * method will return false.
     */
    inline void clearU8AmbiguousTag();

    /**
     * Checks whether the field "u8AmbiguousTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AmbiguousTag()). Otherwise it will return false.
     */
    inline bool hasU8AmbiguousTag () const;

    /**
     * Returns the value of the member "u8AmbiguousTag".
     *
     *
     *
     * @return The value of the field "u8AmbiguousTag"
     */
    inline uint8 getU8AmbiguousTag () const;

    /**
     * Sets the value of the member "u8AmbiguousTag".
     *
     *
     *
     * @param u8AmbiguousTag The value which will be set
     */
    inline void setU8AmbiguousTag (uint8 u8AmbiguousTag_);

    // API of field "u8ButtonPressed"

    static const int kU8ButtonPressed = 14;

    /**
     * Clears the field "u8ButtonPressed".
     *
     * The field will be set to its default value. The hasU8ButtonPressed()
     * method will return false.
     */
    inline void clearU8ButtonPressed();

    /**
     * Checks whether the field "u8ButtonPressed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ButtonPressed()). Otherwise it will return false.
     */
    inline bool hasU8ButtonPressed () const;

    /**
     * Returns the value of the member "u8ButtonPressed".
     *
     *
     *
     * @return The value of the field "u8ButtonPressed"
     */
    inline uint8 getU8ButtonPressed () const;

    /**
     * Sets the value of the member "u8ButtonPressed".
     *
     *
     *
     * @param u8ButtonPressed The value which will be set
     */
    inline void setU8ButtonPressed (uint8 u8ButtonPressed_);

    // API of field "u8TagProgramNumber"

    static const int kU8TagProgramNumber = 15;

    /**
     * Clears the field "u8TagProgramNumber".
     *
     * The field will be set to its default value. The hasU8TagProgramNumber()
     * method will return false.
     */
    inline void clearU8TagProgramNumber();

    /**
     * Checks whether the field "u8TagProgramNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TagProgramNumber()). Otherwise it will return false.
     */
    inline bool hasU8TagProgramNumber () const;

    /**
     * Returns the value of the member "u8TagProgramNumber".
     *
     *
     *
     * @return The value of the field "u8TagProgramNumber"
     */
    inline uint8 getU8TagProgramNumber () const;

    /**
     * Sets the value of the member "u8TagProgramNumber".
     *
     *
     *
     * @param u8TagProgramNumber The value which will be set
     */
    inline void setU8TagProgramNumber (uint8 u8TagProgramNumber_);

    // API of field "u8TagStorefrontID"

    static const int kU8TagStorefrontID = 16;

    /**
     * Clears the field "u8TagStorefrontID".
     *
     * The field will be set to its default value. The hasU8TagStorefrontID()
     * method will return false.
     */
    inline void clearU8TagStorefrontID();

    /**
     * Checks whether the field "u8TagStorefrontID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TagStorefrontID()). Otherwise it will return false.
     */
    inline bool hasU8TagStorefrontID () const;

    /**
     * Returns the value of the member "u8TagStorefrontID".
     *
     *
     *
     * @return The value of the field "u8TagStorefrontID"
     */
    inline uint8 getU8TagStorefrontID () const;

    /**
     * Sets the value of the member "u8TagStorefrontID".
     *
     *
     *
     * @param u8TagStorefrontID The value which will be set
     */
    inline void setU8TagStorefrontID (uint8 u8TagStorefrontID_);

    static const T_MPlayTagTransferItem_1 &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_oUnknownData ();

    inline void clear_has_oUnknownData ();

    inline void set_has_sPodCastFeedURL ();

    inline void clear_has_sPodCastFeedURL ();

    inline void set_has_sStationURL ();

    inline void clear_has_sStationURL ();

    inline void set_has_sStationURLFrequency ();

    inline void clear_has_sStationURLFrequency ();

    inline void set_has_sTagAffiliateID ();

    inline void clear_has_sTagAffiliateID ();

    inline void set_has_sTagAlbum ();

    inline void clear_has_sTagAlbum ();

    inline void set_has_sTagArtistName ();

    inline void clear_has_sTagArtistName ();

    inline void set_has_sTagChannelName ();

    inline void clear_has_sTagChannelName ();

    inline void set_has_sTagChannelNumber ();

    inline void clear_has_sTagChannelNumber ();

    inline void set_has_sTagGenre ();

    inline void clear_has_sTagGenre ();

    inline void set_has_sTagTimeStamp ();

    inline void clear_has_sTagTimeStamp ();

    inline void set_has_sTagTrackName ();

    inline void clear_has_sTagTrackName ();

    inline void set_has_u32TagSongID ();

    inline void clear_has_u32TagSongID ();

    inline void set_has_u8AmbiguousTag ();

    inline void clear_has_u8AmbiguousTag ();

    inline void set_has_u8ButtonPressed ();

    inline void clear_has_u8ButtonPressed ();

    inline void set_has_u8TagProgramNumber ();

    inline void clear_has_u8TagProgramNumber ();

    inline void set_has_u8TagStorefrontID ();

    inline void clear_has_u8TagStorefrontID ();

    uint32 _has_bits_[ (17 + 31) / 32];

    ::fi_basetypes::T_ShortStream _oUnknownData;

    ::std::string _sPodCastFeedURL;

    ::std::string _sStationURL;

    ::std::string _sStationURLFrequency;

    ::std::string _sTagAffiliateID;

    ::std::string _sTagAlbum;

    ::std::string _sTagArtistName;

    ::std::string _sTagChannelName;

    ::std::string _sTagChannelNumber;

    ::std::string _sTagGenre;

    ::std::string _sTagTimeStamp;

    ::std::string _sTagTrackName;

    uint32 _u32TagSongID;

    uint8 _u8AmbiguousTag;

    uint8 _u8ButtonPressed;

    uint8 _u8TagProgramNumber;

    uint8 _u8TagStorefrontID;

};

/**
 * TagTrackName, TagArtistName, TagChannelNumber, TagChannelName, TagAffiliateID, TagURL, TagSongID
 */
class T_MPlayTagTransferItem_2 {
public:

    /**
     * Default constructor
     */
    inline  T_MPlayTagTransferItem_2 ();

    /**
     * Copy constructor
     */
    inline  T_MPlayTagTransferItem_2 (const T_MPlayTagTransferItem_2 &rhs);

    /**
     * All fields constructor
     */
    inline  T_MPlayTagTransferItem_2 (const ::fi_basetypes::T_ShortStream& oUnknownData_, const ::std::string& sPodCastFeedURL_, const ::std::string& sStationURL_, const ::std::string& sStationURLFrequency_, const ::std::string& sTagAffiliateID_, const ::std::string& sTagAlbum_, const ::std::string& sTagArtistName_, const ::std::string& sTagChannelName_, const ::std::string& sTagChannelNumber_, const ::std::string& sTagGenre_, const ::std::string& sTagTimeStamp_, const ::std::string& sTagTrackName_, uint32 u32TagSongID_, uint32 u32TagStorefrontID_, uint8 u8AmbiguousTag_, uint8 u8ButtonPressed_, uint8 u8TagProgramNumber_);

    /**
     * Destructor
     */
    inline  ~T_MPlayTagTransferItem_2();

    /**
     * Assignment operator
     */
    inline T_MPlayTagTransferItem_2& operator = (const T_MPlayTagTransferItem_2& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MPlayTagTransferItem_2& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MPlayTagTransferItem_2& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MPlayTagTransferItem_2& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MPlayTagTransferItem_2& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oUnknownData"

    static const int kOUnknownData = 0;

    /**
     * Clears the field "oUnknownData".
     *
     * The field will be set to its default value. The hasOUnknownData()
     * method will return false.
     */
    inline void clearOUnknownData();

    /**
     * Checks whether the field "oUnknownData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOUnknownData()). Otherwise it will return false.
     */
    inline bool hasOUnknownData () const;

    /**
     * Returns the value of the member "oUnknownData".
     *
     *
     *
     * @return The value of the field "oUnknownData"
     */
    inline const ::fi_basetypes::T_ShortStream& getOUnknownData () const;

    /**
     * Retrieves the value of the field "oUnknownData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oUnknownData".
     */
    inline ::fi_basetypes::T_ShortStream& getOUnknownDataMutable ();

    /**
     * Sets the value of the member "oUnknownData".
     *
     *
     *
     * @param oUnknownData The value which will be set
     */
    inline void setOUnknownData (const ::fi_basetypes::T_ShortStream& oUnknownData_);

    // API of field "sPodCastFeedURL"

    static const int kSPodCastFeedURL = 1;

    /**
     * Clears the field "sPodCastFeedURL".
     *
     * The field will be set to its default value. The hasSPodCastFeedURL()
     * method will return false.
     */
    inline void clearSPodCastFeedURL();

    /**
     * Checks whether the field "sPodCastFeedURL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPodCastFeedURL()). Otherwise it will return false.
     */
    inline bool hasSPodCastFeedURL () const;

    /**
     * Returns the value of the member "sPodCastFeedURL".
     *
     * The PodCastFeedURL encoded as a String. For some implementations, such as the iPod, that encode this data as an integer, the decimal representation of the integer value shall be rendered as a String.
     *
     * @return The value of the field "sPodCastFeedURL"
     */
    inline const ::std::string& getSPodCastFeedURL () const;

    /**
     * Retrieves the value of the field "sPodCastFeedURL" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPodCastFeedURL".
     */
    inline ::std::string& getSPodCastFeedURLMutable ();

    /**
     * Sets the value of the member "sPodCastFeedURL".
     *
     * The PodCastFeedURL encoded as a String. For some implementations, such as the iPod, that encode this data as an integer, the decimal representation of the integer value shall be rendered as a String.
     *
     * @param sPodCastFeedURL The value which will be set
     */
    inline void setSPodCastFeedURL (const ::std::string& sPodCastFeedURL_);

    /**
     * Sets the value of the member "sPodCastFeedURL".
     *
     * The PodCastFeedURL encoded as a String. For some implementations, such as the iPod, that encode this data as an integer, the decimal representation of the integer value shall be rendered as a String.
     *
     * @param sPodCastFeedURL The value which will be set
     */
    inline void setSPodCastFeedURL (const char* sPodCastFeedURL_);

    /**
     * Sets the value of the member "sPodCastFeedURL".
     *
     * The PodCastFeedURL encoded as a String. For some implementations, such as the iPod, that encode this data as an integer, the decimal representation of the integer value shall be rendered as a String.
     *
     * @param sPodCastFeedURL The value which will be set
     */
    inline void setSPodCastFeedURL (const char* value, size_t size);

    // API of field "sStationURL"

    static const int kSStationURL = 2;

    /**
     * Clears the field "sStationURL".
     *
     * The field will be set to its default value. The hasSStationURL()
     * method will return false.
     */
    inline void clearSStationURL();

    /**
     * Checks whether the field "sStationURL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSStationURL()). Otherwise it will return false.
     */
    inline bool hasSStationURL () const;

    /**
     * Returns the value of the member "sStationURL".
     *
     * URL related to the station upon which the content was tagged.
     *
     * @return The value of the field "sStationURL"
     */
    inline const ::std::string& getSStationURL () const;

    /**
     * Retrieves the value of the field "sStationURL" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sStationURL".
     */
    inline ::std::string& getSStationURLMutable ();

    /**
     * Sets the value of the member "sStationURL".
     *
     * URL related to the station upon which the content was tagged.
     *
     * @param sStationURL The value which will be set
     */
    inline void setSStationURL (const ::std::string& sStationURL_);

    /**
     * Sets the value of the member "sStationURL".
     *
     * URL related to the station upon which the content was tagged.
     *
     * @param sStationURL The value which will be set
     */
    inline void setSStationURL (const char* sStationURL_);

    /**
     * Sets the value of the member "sStationURL".
     *
     * URL related to the station upon which the content was tagged.
     *
     * @param sStationURL The value which will be set
     */
    inline void setSStationURL (const char* value, size_t size);

    // API of field "sStationURLFrequency"

    static const int kSStationURLFrequency = 3;

    /**
     * Clears the field "sStationURLFrequency".
     *
     * The field will be set to its default value. The hasSStationURLFrequency()
     * method will return false.
     */
    inline void clearSStationURLFrequency();

    /**
     * Checks whether the field "sStationURLFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSStationURLFrequency()). Otherwise it will return false.
     */
    inline bool hasSStationURLFrequency () const;

    /**
     * Returns the value of the member "sStationURLFrequency".
     *
     * This is how frequently the customer portable device is supposed to be checking for updates of new podcast releases.
     *
     * @return The value of the field "sStationURLFrequency"
     */
    inline const ::std::string& getSStationURLFrequency () const;

    /**
     * Retrieves the value of the field "sStationURLFrequency" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sStationURLFrequency".
     */
    inline ::std::string& getSStationURLFrequencyMutable ();

    /**
     * Sets the value of the member "sStationURLFrequency".
     *
     * This is how frequently the customer portable device is supposed to be checking for updates of new podcast releases.
     *
     * @param sStationURLFrequency The value which will be set
     */
    inline void setSStationURLFrequency (const ::std::string& sStationURLFrequency_);

    /**
     * Sets the value of the member "sStationURLFrequency".
     *
     * This is how frequently the customer portable device is supposed to be checking for updates of new podcast releases.
     *
     * @param sStationURLFrequency The value which will be set
     */
    inline void setSStationURLFrequency (const char* sStationURLFrequency_);

    /**
     * Sets the value of the member "sStationURLFrequency".
     *
     * This is how frequently the customer portable device is supposed to be checking for updates of new podcast releases.
     *
     * @param sStationURLFrequency The value which will be set
     */
    inline void setSStationURLFrequency (const char* value, size_t size);

    // API of field "sTagAffiliateID"

    static const int kSTagAffiliateID = 4;

    /**
     * Clears the field "sTagAffiliateID".
     *
     * The field will be set to its default value. The hasSTagAffiliateID()
     * method will return false.
     */
    inline void clearSTagAffiliateID();

    /**
     * Checks whether the field "sTagAffiliateID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagAffiliateID()). Otherwise it will return false.
     */
    inline bool hasSTagAffiliateID () const;

    /**
     * Returns the value of the member "sTagAffiliateID".
     *
     * Product affiliate ID
     *
     * @return The value of the field "sTagAffiliateID"
     */
    inline const ::std::string& getSTagAffiliateID () const;

    /**
     * Retrieves the value of the field "sTagAffiliateID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagAffiliateID".
     */
    inline ::std::string& getSTagAffiliateIDMutable ();

    /**
     * Sets the value of the member "sTagAffiliateID".
     *
     * Product affiliate ID
     *
     * @param sTagAffiliateID The value which will be set
     */
    inline void setSTagAffiliateID (const ::std::string& sTagAffiliateID_);

    /**
     * Sets the value of the member "sTagAffiliateID".
     *
     * Product affiliate ID
     *
     * @param sTagAffiliateID The value which will be set
     */
    inline void setSTagAffiliateID (const char* sTagAffiliateID_);

    /**
     * Sets the value of the member "sTagAffiliateID".
     *
     * Product affiliate ID
     *
     * @param sTagAffiliateID The value which will be set
     */
    inline void setSTagAffiliateID (const char* value, size_t size);

    // API of field "sTagAlbum"

    static const int kSTagAlbum = 5;

    /**
     * Clears the field "sTagAlbum".
     *
     * The field will be set to its default value. The hasSTagAlbum()
     * method will return false.
     */
    inline void clearSTagAlbum();

    /**
     * Checks whether the field "sTagAlbum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagAlbum()). Otherwise it will return false.
     */
    inline bool hasSTagAlbum () const;

    /**
     * Returns the value of the member "sTagAlbum".
     *
     * Album of a tagged song
     *
     * @return The value of the field "sTagAlbum"
     */
    inline const ::std::string& getSTagAlbum () const;

    /**
     * Retrieves the value of the field "sTagAlbum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagAlbum".
     */
    inline ::std::string& getSTagAlbumMutable ();

    /**
     * Sets the value of the member "sTagAlbum".
     *
     * Album of a tagged song
     *
     * @param sTagAlbum The value which will be set
     */
    inline void setSTagAlbum (const ::std::string& sTagAlbum_);

    /**
     * Sets the value of the member "sTagAlbum".
     *
     * Album of a tagged song
     *
     * @param sTagAlbum The value which will be set
     */
    inline void setSTagAlbum (const char* sTagAlbum_);

    /**
     * Sets the value of the member "sTagAlbum".
     *
     * Album of a tagged song
     *
     * @param sTagAlbum The value which will be set
     */
    inline void setSTagAlbum (const char* value, size_t size);

    // API of field "sTagArtistName"

    static const int kSTagArtistName = 6;

    /**
     * Clears the field "sTagArtistName".
     *
     * The field will be set to its default value. The hasSTagArtistName()
     * method will return false.
     */
    inline void clearSTagArtistName();

    /**
     * Checks whether the field "sTagArtistName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagArtistName()). Otherwise it will return false.
     */
    inline bool hasSTagArtistName () const;

    /**
     * Returns the value of the member "sTagArtistName".
     *
     * Artist of a tagged song
     *
     * @return The value of the field "sTagArtistName"
     */
    inline const ::std::string& getSTagArtistName () const;

    /**
     * Retrieves the value of the field "sTagArtistName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagArtistName".
     */
    inline ::std::string& getSTagArtistNameMutable ();

    /**
     * Sets the value of the member "sTagArtistName".
     *
     * Artist of a tagged song
     *
     * @param sTagArtistName The value which will be set
     */
    inline void setSTagArtistName (const ::std::string& sTagArtistName_);

    /**
     * Sets the value of the member "sTagArtistName".
     *
     * Artist of a tagged song
     *
     * @param sTagArtistName The value which will be set
     */
    inline void setSTagArtistName (const char* sTagArtistName_);

    /**
     * Sets the value of the member "sTagArtistName".
     *
     * Artist of a tagged song
     *
     * @param sTagArtistName The value which will be set
     */
    inline void setSTagArtistName (const char* value, size_t size);

    // API of field "sTagChannelName"

    static const int kSTagChannelName = 7;

    /**
     * Clears the field "sTagChannelName".
     *
     * The field will be set to its default value. The hasSTagChannelName()
     * method will return false.
     */
    inline void clearSTagChannelName();

    /**
     * Checks whether the field "sTagChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagChannelName()). Otherwise it will return false.
     */
    inline bool hasSTagChannelName () const;

    /**
     * Returns the value of the member "sTagChannelName".
     *
     * Name of the channel that was playing the tagged track
     *
     * @return The value of the field "sTagChannelName"
     */
    inline const ::std::string& getSTagChannelName () const;

    /**
     * Retrieves the value of the field "sTagChannelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagChannelName".
     */
    inline ::std::string& getSTagChannelNameMutable ();

    /**
     * Sets the value of the member "sTagChannelName".
     *
     * Name of the channel that was playing the tagged track
     *
     * @param sTagChannelName The value which will be set
     */
    inline void setSTagChannelName (const ::std::string& sTagChannelName_);

    /**
     * Sets the value of the member "sTagChannelName".
     *
     * Name of the channel that was playing the tagged track
     *
     * @param sTagChannelName The value which will be set
     */
    inline void setSTagChannelName (const char* sTagChannelName_);

    /**
     * Sets the value of the member "sTagChannelName".
     *
     * Name of the channel that was playing the tagged track
     *
     * @param sTagChannelName The value which will be set
     */
    inline void setSTagChannelName (const char* value, size_t size);

    // API of field "sTagChannelNumber"

    static const int kSTagChannelNumber = 8;

    /**
     * Clears the field "sTagChannelNumber".
     *
     * The field will be set to its default value. The hasSTagChannelNumber()
     * method will return false.
     */
    inline void clearSTagChannelNumber();

    /**
     * Checks whether the field "sTagChannelNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagChannelNumber()). Otherwise it will return false.
     */
    inline bool hasSTagChannelNumber () const;

    /**
     * Returns the value of the member "sTagChannelNumber".
     *
     * Number of the channel that was playing the tagged song
     *
     * @return The value of the field "sTagChannelNumber"
     */
    inline const ::std::string& getSTagChannelNumber () const;

    /**
     * Retrieves the value of the field "sTagChannelNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagChannelNumber".
     */
    inline ::std::string& getSTagChannelNumberMutable ();

    /**
     * Sets the value of the member "sTagChannelNumber".
     *
     * Number of the channel that was playing the tagged song
     *
     * @param sTagChannelNumber The value which will be set
     */
    inline void setSTagChannelNumber (const ::std::string& sTagChannelNumber_);

    /**
     * Sets the value of the member "sTagChannelNumber".
     *
     * Number of the channel that was playing the tagged song
     *
     * @param sTagChannelNumber The value which will be set
     */
    inline void setSTagChannelNumber (const char* sTagChannelNumber_);

    /**
     * Sets the value of the member "sTagChannelNumber".
     *
     * Number of the channel that was playing the tagged song
     *
     * @param sTagChannelNumber The value which will be set
     */
    inline void setSTagChannelNumber (const char* value, size_t size);

    // API of field "sTagGenre"

    static const int kSTagGenre = 9;

    /**
     * Clears the field "sTagGenre".
     *
     * The field will be set to its default value. The hasSTagGenre()
     * method will return false.
     */
    inline void clearSTagGenre();

    /**
     * Checks whether the field "sTagGenre" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagGenre()). Otherwise it will return false.
     */
    inline bool hasSTagGenre () const;

    /**
     * Returns the value of the member "sTagGenre".
     *
     * Genre of a tagged song
     *
     * @return The value of the field "sTagGenre"
     */
    inline const ::std::string& getSTagGenre () const;

    /**
     * Retrieves the value of the field "sTagGenre" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagGenre".
     */
    inline ::std::string& getSTagGenreMutable ();

    /**
     * Sets the value of the member "sTagGenre".
     *
     * Genre of a tagged song
     *
     * @param sTagGenre The value which will be set
     */
    inline void setSTagGenre (const ::std::string& sTagGenre_);

    /**
     * Sets the value of the member "sTagGenre".
     *
     * Genre of a tagged song
     *
     * @param sTagGenre The value which will be set
     */
    inline void setSTagGenre (const char* sTagGenre_);

    /**
     * Sets the value of the member "sTagGenre".
     *
     * Genre of a tagged song
     *
     * @param sTagGenre The value which will be set
     */
    inline void setSTagGenre (const char* value, size_t size);

    // API of field "sTagTimeStamp"

    static const int kSTagTimeStamp = 10;

    /**
     * Clears the field "sTagTimeStamp".
     *
     * The field will be set to its default value. The hasSTagTimeStamp()
     * method will return false.
     */
    inline void clearSTagTimeStamp();

    /**
     * Checks whether the field "sTagTimeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagTimeStamp()). Otherwise it will return false.
     */
    inline bool hasSTagTimeStamp () const;

    /**
     * Returns the value of the member "sTagTimeStamp".
     *
     *
     *
     * @return The value of the field "sTagTimeStamp"
     */
    inline const ::std::string& getSTagTimeStamp () const;

    /**
     * Retrieves the value of the field "sTagTimeStamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagTimeStamp".
     */
    inline ::std::string& getSTagTimeStampMutable ();

    /**
     * Sets the value of the member "sTagTimeStamp".
     *
     *
     *
     * @param sTagTimeStamp The value which will be set
     */
    inline void setSTagTimeStamp (const ::std::string& sTagTimeStamp_);

    /**
     * Sets the value of the member "sTagTimeStamp".
     *
     *
     *
     * @param sTagTimeStamp The value which will be set
     */
    inline void setSTagTimeStamp (const char* sTagTimeStamp_);

    /**
     * Sets the value of the member "sTagTimeStamp".
     *
     *
     *
     * @param sTagTimeStamp The value which will be set
     */
    inline void setSTagTimeStamp (const char* value, size_t size);

    // API of field "sTagTrackName"

    static const int kSTagTrackName = 11;

    /**
     * Clears the field "sTagTrackName".
     *
     * The field will be set to its default value. The hasSTagTrackName()
     * method will return false.
     */
    inline void clearSTagTrackName();

    /**
     * Checks whether the field "sTagTrackName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagTrackName()). Otherwise it will return false.
     */
    inline bool hasSTagTrackName () const;

    /**
     * Returns the value of the member "sTagTrackName".
     *
     * Title of the track
     *
     * @return The value of the field "sTagTrackName"
     */
    inline const ::std::string& getSTagTrackName () const;

    /**
     * Retrieves the value of the field "sTagTrackName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagTrackName".
     */
    inline ::std::string& getSTagTrackNameMutable ();

    /**
     * Sets the value of the member "sTagTrackName".
     *
     * Title of the track
     *
     * @param sTagTrackName The value which will be set
     */
    inline void setSTagTrackName (const ::std::string& sTagTrackName_);

    /**
     * Sets the value of the member "sTagTrackName".
     *
     * Title of the track
     *
     * @param sTagTrackName The value which will be set
     */
    inline void setSTagTrackName (const char* sTagTrackName_);

    /**
     * Sets the value of the member "sTagTrackName".
     *
     * Title of the track
     *
     * @param sTagTrackName The value which will be set
     */
    inline void setSTagTrackName (const char* value, size_t size);

    // API of field "u32TagSongID"

    static const int kU32TagSongID = 12;

    /**
     * Clears the field "u32TagSongID".
     *
     * The field will be set to its default value. The hasU32TagSongID()
     * method will return false.
     */
    inline void clearU32TagSongID();

    /**
     * Checks whether the field "u32TagSongID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TagSongID()). Otherwise it will return false.
     */
    inline bool hasU32TagSongID () const;

    /**
     * Returns the value of the member "u32TagSongID".
     *
     * Song Identifier, such as the iTunes Song ID
     *
     * @return The value of the field "u32TagSongID"
     */
    inline uint32 getU32TagSongID () const;

    /**
     * Sets the value of the member "u32TagSongID".
     *
     * Song Identifier, such as the iTunes Song ID
     *
     * @param u32TagSongID The value which will be set
     */
    inline void setU32TagSongID (uint32 u32TagSongID_);

    // API of field "u32TagStorefrontID"

    static const int kU32TagStorefrontID = 13;

    /**
     * Clears the field "u32TagStorefrontID".
     *
     * The field will be set to its default value. The hasU32TagStorefrontID()
     * method will return false.
     */
    inline void clearU32TagStorefrontID();

    /**
     * Checks whether the field "u32TagStorefrontID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TagStorefrontID()). Otherwise it will return false.
     */
    inline bool hasU32TagStorefrontID () const;

    /**
     * Returns the value of the member "u32TagStorefrontID".
     *
     *
     *
     * @return The value of the field "u32TagStorefrontID"
     */
    inline uint32 getU32TagStorefrontID () const;

    /**
     * Sets the value of the member "u32TagStorefrontID".
     *
     *
     *
     * @param u32TagStorefrontID The value which will be set
     */
    inline void setU32TagStorefrontID (uint32 u32TagStorefrontID_);

    // API of field "u8AmbiguousTag"

    static const int kU8AmbiguousTag = 14;

    /**
     * Clears the field "u8AmbiguousTag".
     *
     * The field will be set to its default value. The hasU8AmbiguousTag()
     * method will return false.
     */
    inline void clearU8AmbiguousTag();

    /**
     * Checks whether the field "u8AmbiguousTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AmbiguousTag()). Otherwise it will return false.
     */
    inline bool hasU8AmbiguousTag () const;

    /**
     * Returns the value of the member "u8AmbiguousTag".
     *
     *
     *
     * @return The value of the field "u8AmbiguousTag"
     */
    inline uint8 getU8AmbiguousTag () const;

    /**
     * Sets the value of the member "u8AmbiguousTag".
     *
     *
     *
     * @param u8AmbiguousTag The value which will be set
     */
    inline void setU8AmbiguousTag (uint8 u8AmbiguousTag_);

    // API of field "u8ButtonPressed"

    static const int kU8ButtonPressed = 15;

    /**
     * Clears the field "u8ButtonPressed".
     *
     * The field will be set to its default value. The hasU8ButtonPressed()
     * method will return false.
     */
    inline void clearU8ButtonPressed();

    /**
     * Checks whether the field "u8ButtonPressed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ButtonPressed()). Otherwise it will return false.
     */
    inline bool hasU8ButtonPressed () const;

    /**
     * Returns the value of the member "u8ButtonPressed".
     *
     *
     *
     * @return The value of the field "u8ButtonPressed"
     */
    inline uint8 getU8ButtonPressed () const;

    /**
     * Sets the value of the member "u8ButtonPressed".
     *
     *
     *
     * @param u8ButtonPressed The value which will be set
     */
    inline void setU8ButtonPressed (uint8 u8ButtonPressed_);

    // API of field "u8TagProgramNumber"

    static const int kU8TagProgramNumber = 16;

    /**
     * Clears the field "u8TagProgramNumber".
     *
     * The field will be set to its default value. The hasU8TagProgramNumber()
     * method will return false.
     */
    inline void clearU8TagProgramNumber();

    /**
     * Checks whether the field "u8TagProgramNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TagProgramNumber()). Otherwise it will return false.
     */
    inline bool hasU8TagProgramNumber () const;

    /**
     * Returns the value of the member "u8TagProgramNumber".
     *
     *
     *
     * @return The value of the field "u8TagProgramNumber"
     */
    inline uint8 getU8TagProgramNumber () const;

    /**
     * Sets the value of the member "u8TagProgramNumber".
     *
     *
     *
     * @param u8TagProgramNumber The value which will be set
     */
    inline void setU8TagProgramNumber (uint8 u8TagProgramNumber_);

    static const T_MPlayTagTransferItem_2 &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_oUnknownData ();

    inline void clear_has_oUnknownData ();

    inline void set_has_sPodCastFeedURL ();

    inline void clear_has_sPodCastFeedURL ();

    inline void set_has_sStationURL ();

    inline void clear_has_sStationURL ();

    inline void set_has_sStationURLFrequency ();

    inline void clear_has_sStationURLFrequency ();

    inline void set_has_sTagAffiliateID ();

    inline void clear_has_sTagAffiliateID ();

    inline void set_has_sTagAlbum ();

    inline void clear_has_sTagAlbum ();

    inline void set_has_sTagArtistName ();

    inline void clear_has_sTagArtistName ();

    inline void set_has_sTagChannelName ();

    inline void clear_has_sTagChannelName ();

    inline void set_has_sTagChannelNumber ();

    inline void clear_has_sTagChannelNumber ();

    inline void set_has_sTagGenre ();

    inline void clear_has_sTagGenre ();

    inline void set_has_sTagTimeStamp ();

    inline void clear_has_sTagTimeStamp ();

    inline void set_has_sTagTrackName ();

    inline void clear_has_sTagTrackName ();

    inline void set_has_u32TagSongID ();

    inline void clear_has_u32TagSongID ();

    inline void set_has_u32TagStorefrontID ();

    inline void clear_has_u32TagStorefrontID ();

    inline void set_has_u8AmbiguousTag ();

    inline void clear_has_u8AmbiguousTag ();

    inline void set_has_u8ButtonPressed ();

    inline void clear_has_u8ButtonPressed ();

    inline void set_has_u8TagProgramNumber ();

    inline void clear_has_u8TagProgramNumber ();

    uint32 _has_bits_[ (17 + 31) / 32];

    ::fi_basetypes::T_ShortStream _oUnknownData;

    ::std::string _sPodCastFeedURL;

    ::std::string _sStationURL;

    ::std::string _sStationURLFrequency;

    ::std::string _sTagAffiliateID;

    ::std::string _sTagAlbum;

    ::std::string _sTagArtistName;

    ::std::string _sTagChannelName;

    ::std::string _sTagChannelNumber;

    ::std::string _sTagGenre;

    ::std::string _sTagTimeStamp;

    ::std::string _sTagTrackName;

    uint32 _u32TagSongID;

    uint32 _u32TagStorefrontID;

    uint8 _u8AmbiguousTag;

    uint8 _u8ButtonPressed;

    uint8 _u8TagProgramNumber;

};

class T_MPlayUntransferredTagStreamItem {
public:

    /**
     * Default constructor
     */
    inline  T_MPlayUntransferredTagStreamItem ();

    /**
     * Copy constructor
     */
    inline  T_MPlayUntransferredTagStreamItem (const T_MPlayUntransferredTagStreamItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MPlayUntransferredTagStreamItem (const ::std::string& sTagArtistName_, const ::std::string& sTagTrackName_, uint32 u32TagSongID_);

    /**
     * Destructor
     */
    inline  ~T_MPlayUntransferredTagStreamItem();

    /**
     * Assignment operator
     */
    inline T_MPlayUntransferredTagStreamItem& operator = (const T_MPlayUntransferredTagStreamItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MPlayUntransferredTagStreamItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MPlayUntransferredTagStreamItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MPlayUntransferredTagStreamItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MPlayUntransferredTagStreamItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sTagArtistName"

    static const int kSTagArtistName = 0;

    /**
     * Clears the field "sTagArtistName".
     *
     * The field will be set to its default value. The hasSTagArtistName()
     * method will return false.
     */
    inline void clearSTagArtistName();

    /**
     * Checks whether the field "sTagArtistName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagArtistName()). Otherwise it will return false.
     */
    inline bool hasSTagArtistName () const;

    /**
     * Returns the value of the member "sTagArtistName".
     *
     * Artist of a tagged song
     *
     * @return The value of the field "sTagArtistName"
     */
    inline const ::std::string& getSTagArtistName () const;

    /**
     * Retrieves the value of the field "sTagArtistName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagArtistName".
     */
    inline ::std::string& getSTagArtistNameMutable ();

    /**
     * Sets the value of the member "sTagArtistName".
     *
     * Artist of a tagged song
     *
     * @param sTagArtistName The value which will be set
     */
    inline void setSTagArtistName (const ::std::string& sTagArtistName_);

    /**
     * Sets the value of the member "sTagArtistName".
     *
     * Artist of a tagged song
     *
     * @param sTagArtistName The value which will be set
     */
    inline void setSTagArtistName (const char* sTagArtistName_);

    /**
     * Sets the value of the member "sTagArtistName".
     *
     * Artist of a tagged song
     *
     * @param sTagArtistName The value which will be set
     */
    inline void setSTagArtistName (const char* value, size_t size);

    // API of field "sTagTrackName"

    static const int kSTagTrackName = 1;

    /**
     * Clears the field "sTagTrackName".
     *
     * The field will be set to its default value. The hasSTagTrackName()
     * method will return false.
     */
    inline void clearSTagTrackName();

    /**
     * Checks whether the field "sTagTrackName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTagTrackName()). Otherwise it will return false.
     */
    inline bool hasSTagTrackName () const;

    /**
     * Returns the value of the member "sTagTrackName".
     *
     * Title of the track
     *
     * @return The value of the field "sTagTrackName"
     */
    inline const ::std::string& getSTagTrackName () const;

    /**
     * Retrieves the value of the field "sTagTrackName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTagTrackName".
     */
    inline ::std::string& getSTagTrackNameMutable ();

    /**
     * Sets the value of the member "sTagTrackName".
     *
     * Title of the track
     *
     * @param sTagTrackName The value which will be set
     */
    inline void setSTagTrackName (const ::std::string& sTagTrackName_);

    /**
     * Sets the value of the member "sTagTrackName".
     *
     * Title of the track
     *
     * @param sTagTrackName The value which will be set
     */
    inline void setSTagTrackName (const char* sTagTrackName_);

    /**
     * Sets the value of the member "sTagTrackName".
     *
     * Title of the track
     *
     * @param sTagTrackName The value which will be set
     */
    inline void setSTagTrackName (const char* value, size_t size);

    // API of field "u32TagSongID"

    static const int kU32TagSongID = 2;

    /**
     * Clears the field "u32TagSongID".
     *
     * The field will be set to its default value. The hasU32TagSongID()
     * method will return false.
     */
    inline void clearU32TagSongID();

    /**
     * Checks whether the field "u32TagSongID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TagSongID()). Otherwise it will return false.
     */
    inline bool hasU32TagSongID () const;

    /**
     * Returns the value of the member "u32TagSongID".
     *
     * Song Identifier, such as the iTunes Song ID
     *
     * @return The value of the field "u32TagSongID"
     */
    inline uint32 getU32TagSongID () const;

    /**
     * Sets the value of the member "u32TagSongID".
     *
     * Song Identifier, such as the iTunes Song ID
     *
     * @param u32TagSongID The value which will be set
     */
    inline void setU32TagSongID (uint32 u32TagSongID_);

    static const T_MPlayUntransferredTagStreamItem &getDefaultInstance();

private:

    inline void set_has_sTagArtistName ();

    inline void clear_has_sTagArtistName ();

    inline void set_has_sTagTrackName ();

    inline void clear_has_sTagTrackName ();

    inline void set_has_u32TagSongID ();

    inline void clear_has_u32TagSongID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sTagArtistName;

    ::std::string _sTagTrackName;

    uint32 _u32TagSongID;

};

/**
 * MOST-specific version of strings, allowing for UTF-8 or UTF-16 encoding; thus incorporating parameter indicating encoding.
 */
class T_SearchString {
public:

    /**
     * Default constructor
     */
    inline  T_SearchString ();

    /**
     * Copy constructor
     */
    inline  T_SearchString (const T_SearchString &rhs);

    /**
     * All fields constructor
     */
    inline  T_SearchString (const ::std::string& sText_, uint8 u8Encoding_);

    /**
     * Destructor
     */
    inline  ~T_SearchString();

    /**
     * Assignment operator
     */
    inline T_SearchString& operator = (const T_SearchString& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SearchString& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SearchString& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SearchString& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SearchString& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sText"

    static const int kSText = 0;

    /**
     * Clears the field "sText".
     *
     * The field will be set to its default value. The hasSText()
     * method will return false.
     */
    inline void clearSText();

    /**
     * Checks whether the field "sText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSText()). Otherwise it will return false.
     */
    inline bool hasSText () const;

    /**
     * Returns the value of the member "sText".
     *
     *
     *
     * @return The value of the field "sText"
     */
    inline const ::std::string& getSText () const;

    /**
     * Retrieves the value of the field "sText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sText".
     */
    inline ::std::string& getSTextMutable ();

    /**
     * Sets the value of the member "sText".
     *
     *
     *
     * @param sText The value which will be set
     */
    inline void setSText (const ::std::string& sText_);

    /**
     * Sets the value of the member "sText".
     *
     *
     *
     * @param sText The value which will be set
     */
    inline void setSText (const char* sText_);

    /**
     * Sets the value of the member "sText".
     *
     *
     *
     * @param sText The value which will be set
     */
    inline void setSText (const char* value, size_t size);

    // API of field "u8Encoding"

    static const int kU8Encoding = 1;

    /**
     * Clears the field "u8Encoding".
     *
     * The field will be set to its default value. The hasU8Encoding()
     * method will return false.
     */
    inline void clearU8Encoding();

    /**
     * Checks whether the field "u8Encoding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Encoding()). Otherwise it will return false.
     */
    inline bool hasU8Encoding () const;

    /**
     * Returns the value of the member "u8Encoding".
     *
     *
     *
     * @return The value of the field "u8Encoding"
     */
    inline uint8 getU8Encoding () const;

    /**
     * Sets the value of the member "u8Encoding".
     *
     *
     *
     * @param u8Encoding The value which will be set
     */
    inline void setU8Encoding (uint8 u8Encoding_);

    static const T_SearchString &getDefaultInstance();

private:

    inline void set_has_sText ();

    inline void clear_has_sText ();

    inline void set_has_u8Encoding ();

    inline void clear_has_u8Encoding ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sText;

    uint8 _u8Encoding;

};

inline  T_MInternalDVDLangSetting::T_MInternalDVDLangSetting ()  :
    _u16AudioLanguage (0u),
    _u16MenuLanguage (0u),
    _u16SubtitleLanguage (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MInternalDVDLangSetting::T_MInternalDVDLangSetting (const T_MInternalDVDLangSetting &rhs)  :
    _u16AudioLanguage (0u),
    _u16MenuLanguage (0u),
    _u16SubtitleLanguage (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MInternalDVDLangSetting::T_MInternalDVDLangSetting (uint16 u16AudioLanguage_, uint16 u16MenuLanguage_, uint16 u16SubtitleLanguage_)  :
    _u16AudioLanguage (u16AudioLanguage_),
    _u16MenuLanguage (u16MenuLanguage_),
    _u16SubtitleLanguage (u16SubtitleLanguage_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MInternalDVDLangSetting::~T_MInternalDVDLangSetting() {
}

inline T_MInternalDVDLangSetting& T_MInternalDVDLangSetting::operator = (const T_MInternalDVDLangSetting& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16AudioLanguage()) {
            setU16AudioLanguage(rhs.getU16AudioLanguage());
        } else {
            clearU16AudioLanguage();
        }
        if (rhs.hasU16MenuLanguage()) {
            setU16MenuLanguage(rhs.getU16MenuLanguage());
        } else {
            clearU16MenuLanguage();
        }
        if (rhs.hasU16SubtitleLanguage()) {
            setU16SubtitleLanguage(rhs.getU16SubtitleLanguage());
        } else {
            clearU16SubtitleLanguage();
        }
    }
    return *this;
}

inline bool T_MInternalDVDLangSetting::operator == (const T_MInternalDVDLangSetting& rhs) const {
    return (((!hasU16AudioLanguage() && !rhs.hasU16AudioLanguage()) || getU16AudioLanguage() == rhs.getU16AudioLanguage()) &&
        ((!hasU16MenuLanguage() && !rhs.hasU16MenuLanguage()) || getU16MenuLanguage() == rhs.getU16MenuLanguage()) &&
        ((!hasU16SubtitleLanguage() && !rhs.hasU16SubtitleLanguage()) || getU16SubtitleLanguage() == rhs.getU16SubtitleLanguage()));
}

inline bool T_MInternalDVDLangSetting::operator != (const T_MInternalDVDLangSetting& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MInternalDVDLangSetting::operator < (const T_MInternalDVDLangSetting& rhs) const {
    if (hasU16AudioLanguage() || rhs.hasU16AudioLanguage()) {
        if (getU16AudioLanguage() < rhs.getU16AudioLanguage()) return true;
        if (getU16AudioLanguage() > rhs.getU16AudioLanguage()) return false;
    }
    if (hasU16MenuLanguage() || rhs.hasU16MenuLanguage()) {
        if (getU16MenuLanguage() < rhs.getU16MenuLanguage()) return true;
        if (getU16MenuLanguage() > rhs.getU16MenuLanguage()) return false;
    }
    if (hasU16SubtitleLanguage() || rhs.hasU16SubtitleLanguage()) {
        if (getU16SubtitleLanguage() < rhs.getU16SubtitleLanguage()) return true;
        if (getU16SubtitleLanguage() > rhs.getU16SubtitleLanguage()) return false;
    }
    return false;
}

inline bool T_MInternalDVDLangSetting::operator > (const T_MInternalDVDLangSetting& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MInternalDVDLangSetting::clear() {
    clearU16AudioLanguage();
    clearU16MenuLanguage();
    clearU16SubtitleLanguage();
}

inline void T_MInternalDVDLangSetting::clearU16AudioLanguage() {
    if (hasU16AudioLanguage()) {
         clear_has_u16AudioLanguage();
        _u16AudioLanguage = 0u;
     }
}

inline bool T_MInternalDVDLangSetting::hasU16AudioLanguage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_MInternalDVDLangSetting::getU16AudioLanguage () const {
    return _u16AudioLanguage;
}

inline void T_MInternalDVDLangSetting::setU16AudioLanguage (uint16 u16AudioLanguage_) {
    set_has_u16AudioLanguage();
    this->_u16AudioLanguage = u16AudioLanguage_;
}

inline void T_MInternalDVDLangSetting::clearU16MenuLanguage() {
    if (hasU16MenuLanguage()) {
         clear_has_u16MenuLanguage();
        _u16MenuLanguage = 0u;
     }
}

inline bool T_MInternalDVDLangSetting::hasU16MenuLanguage () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_MInternalDVDLangSetting::getU16MenuLanguage () const {
    return _u16MenuLanguage;
}

inline void T_MInternalDVDLangSetting::setU16MenuLanguage (uint16 u16MenuLanguage_) {
    set_has_u16MenuLanguage();
    this->_u16MenuLanguage = u16MenuLanguage_;
}

inline void T_MInternalDVDLangSetting::clearU16SubtitleLanguage() {
    if (hasU16SubtitleLanguage()) {
         clear_has_u16SubtitleLanguage();
        _u16SubtitleLanguage = 0u;
     }
}

inline bool T_MInternalDVDLangSetting::hasU16SubtitleLanguage () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_MInternalDVDLangSetting::getU16SubtitleLanguage () const {
    return _u16SubtitleLanguage;
}

inline void T_MInternalDVDLangSetting::setU16SubtitleLanguage (uint16 u16SubtitleLanguage_) {
    set_has_u16SubtitleLanguage();
    this->_u16SubtitleLanguage = u16SubtitleLanguage_;
}

inline void T_MInternalDVDLangSetting::set_has_u16AudioLanguage () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MInternalDVDLangSetting::clear_has_u16AudioLanguage () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MInternalDVDLangSetting::set_has_u16MenuLanguage () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MInternalDVDLangSetting::clear_has_u16MenuLanguage () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MInternalDVDLangSetting::set_has_u16SubtitleLanguage () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MInternalDVDLangSetting::clear_has_u16SubtitleLanguage () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_MPlayDeviceInfoItem::T_MPlayDeviceInfoItem ()  :
    _e8DiscType (::MPlay_fi_types::T_e8_MDiscType__e8AUDIO_CD_DISC),
    _e8AvailabilityReason (::MPlay_fi_types::T_e8_MPlayAvailabilityReason__e8AR_NEW_MEDIA),
    _e8ConnectionState (::MPlay_fi_types::T_e8_MPlayConnectionState__e8CS_ATTACHED),
    _e8ConnectionType (::MPlay_fi_types::T_e8_MPlayConnectionType__e8DCT_BLUETOOTH),
    _e8DeviceControlSupport (::MPlay_fi_types::T_e8_MPlayDeviceControlSupport__e8DCS_BROWSING),
    _e8DeviceIndexedState (::MPlay_fi_types::T_e8_MPlayDeviceIndexedState__e8IDS_COMPLETE),
    _e8DeviceState (::MPlay_fi_types::T_e8_MPlayDeviceStatus__e8DS_COMMUNICATION_ERROR),
    _e8DeviceType (::MPlay_fi_types::T_e8_MPlayDeviceType__e8DTY_BLUETOOTH),
    _e8DisconnectReason (::MPlay_fi_types::T_e8_MPlayDisconnectReason__e8DR_AUTOMATIC),
    _e8FileSystemType (::MPlay_fi_types::T_e8_MPlayFileSystemType__e8FSTY_EXFAT),
    _bDeviceActiveSource (false),
    _bDeviceConnected (false),
    _bIsNowPlayingListAvailable (false),
    _bRepeatSupported (false),
    _bScanSupported (false),
    _bShuffleSupported (false),
    _sDeviceName (),
    _sDeviceSerialNumber (),
    _sDeviceSysPath (),
    _sDeviceVersion (),
    _sLastPlayedFile (),
    _sMountPoint (),
    _u32FreeSize (0u),
    _u32NumberOfFiles (0u),
    _u32NumberOfImageFiles (0u),
    _u32NumberOfVideoFiles (0u),
    _u32PartitionNumber (0u),
    _u32TotalSize (0u),
    _u8DeviceTag (0u),
    _DeviceDBViewStatus (::MPlay_fi_types::T_e_MPlayDeviceDBViewStatus__DB_VIEWS_DONT_CARE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MPlayDeviceInfoItem::T_MPlayDeviceInfoItem (const T_MPlayDeviceInfoItem &rhs)  :
    _e8DiscType (::MPlay_fi_types::T_e8_MDiscType__e8AUDIO_CD_DISC),
    _e8AvailabilityReason (::MPlay_fi_types::T_e8_MPlayAvailabilityReason__e8AR_NEW_MEDIA),
    _e8ConnectionState (::MPlay_fi_types::T_e8_MPlayConnectionState__e8CS_ATTACHED),
    _e8ConnectionType (::MPlay_fi_types::T_e8_MPlayConnectionType__e8DCT_BLUETOOTH),
    _e8DeviceControlSupport (::MPlay_fi_types::T_e8_MPlayDeviceControlSupport__e8DCS_BROWSING),
    _e8DeviceIndexedState (::MPlay_fi_types::T_e8_MPlayDeviceIndexedState__e8IDS_COMPLETE),
    _e8DeviceState (::MPlay_fi_types::T_e8_MPlayDeviceStatus__e8DS_COMMUNICATION_ERROR),
    _e8DeviceType (::MPlay_fi_types::T_e8_MPlayDeviceType__e8DTY_BLUETOOTH),
    _e8DisconnectReason (::MPlay_fi_types::T_e8_MPlayDisconnectReason__e8DR_AUTOMATIC),
    _e8FileSystemType (::MPlay_fi_types::T_e8_MPlayFileSystemType__e8FSTY_EXFAT),
    _bDeviceActiveSource (false),
    _bDeviceConnected (false),
    _bIsNowPlayingListAvailable (false),
    _bRepeatSupported (false),
    _bScanSupported (false),
    _bShuffleSupported (false),
    _sDeviceName (),
    _sDeviceSerialNumber (),
    _sDeviceSysPath (),
    _sDeviceVersion (),
    _sLastPlayedFile (),
    _sMountPoint (),
    _u32FreeSize (0u),
    _u32NumberOfFiles (0u),
    _u32NumberOfImageFiles (0u),
    _u32NumberOfVideoFiles (0u),
    _u32PartitionNumber (0u),
    _u32TotalSize (0u),
    _u8DeviceTag (0u),
    _DeviceDBViewStatus (::MPlay_fi_types::T_e_MPlayDeviceDBViewStatus__DB_VIEWS_DONT_CARE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MPlayDeviceInfoItem::T_MPlayDeviceInfoItem (T_e8_MDiscType e8DiscType_, T_e8_MPlayAvailabilityReason e8AvailabilityReason_, T_e8_MPlayConnectionState e8ConnectionState_, T_e8_MPlayConnectionType e8ConnectionType_, T_e8_MPlayDeviceControlSupport e8DeviceControlSupport_, T_e8_MPlayDeviceIndexedState e8DeviceIndexedState_, T_e8_MPlayDeviceStatus e8DeviceState_, T_e8_MPlayDeviceType e8DeviceType_, T_e8_MPlayDisconnectReason e8DisconnectReason_, T_e8_MPlayFileSystemType e8FileSystemType_, bool bDeviceActiveSource_, bool bDeviceConnected_, bool bIsNowPlayingListAvailable_, bool bRepeatSupported_, bool bScanSupported_, bool bShuffleSupported_, const ::std::string& sDeviceName_, const ::std::string& sDeviceSerialNumber_, const ::std::string& sDeviceSysPath_, const ::std::string& sDeviceVersion_, const ::std::string& sLastPlayedFile_, const ::std::string& sMountPoint_, uint32 u32FreeSize_, uint32 u32NumberOfFiles_, uint32 u32NumberOfImageFiles_, uint32 u32NumberOfVideoFiles_, uint32 u32PartitionNumber_, uint32 u32TotalSize_, uint8 u8DeviceTag_, T_e_MPlayDeviceDBViewStatus DeviceDBViewStatus_)  :
    _e8DiscType (e8DiscType_),
    _e8AvailabilityReason (e8AvailabilityReason_),
    _e8ConnectionState (e8ConnectionState_),
    _e8ConnectionType (e8ConnectionType_),
    _e8DeviceControlSupport (e8DeviceControlSupport_),
    _e8DeviceIndexedState (e8DeviceIndexedState_),
    _e8DeviceState (e8DeviceState_),
    _e8DeviceType (e8DeviceType_),
    _e8DisconnectReason (e8DisconnectReason_),
    _e8FileSystemType (e8FileSystemType_),
    _bDeviceActiveSource (bDeviceActiveSource_),
    _bDeviceConnected (bDeviceConnected_),
    _bIsNowPlayingListAvailable (bIsNowPlayingListAvailable_),
    _bRepeatSupported (bRepeatSupported_),
    _bScanSupported (bScanSupported_),
    _bShuffleSupported (bShuffleSupported_),
    _sDeviceName (sDeviceName_),
    _sDeviceSerialNumber (sDeviceSerialNumber_),
    _sDeviceSysPath (sDeviceSysPath_),
    _sDeviceVersion (sDeviceVersion_),
    _sLastPlayedFile (sLastPlayedFile_),
    _sMountPoint (sMountPoint_),
    _u32FreeSize (u32FreeSize_),
    _u32NumberOfFiles (u32NumberOfFiles_),
    _u32NumberOfImageFiles (u32NumberOfImageFiles_),
    _u32NumberOfVideoFiles (u32NumberOfVideoFiles_),
    _u32PartitionNumber (u32PartitionNumber_),
    _u32TotalSize (u32TotalSize_),
    _u8DeviceTag (u8DeviceTag_),
    _DeviceDBViewStatus (DeviceDBViewStatus_)
{
    #ifndef NDEBUG
    if (!(T_e8_MDiscType_IsValid(e8DiscType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DiscType_, "T_e8_MDiscType", "e8DiscType", "T_MPlayDeviceInfoItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayAvailabilityReason_IsValid(e8AvailabilityReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AvailabilityReason_, "T_e8_MPlayAvailabilityReason", "e8AvailabilityReason", "T_MPlayDeviceInfoItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayConnectionState_IsValid(e8ConnectionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConnectionState_, "T_e8_MPlayConnectionState", "e8ConnectionState", "T_MPlayDeviceInfoItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayConnectionType_IsValid(e8ConnectionType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConnectionType_, "T_e8_MPlayConnectionType", "e8ConnectionType", "T_MPlayDeviceInfoItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceControlSupport_IsValid(e8DeviceControlSupport_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceControlSupport_, "T_e8_MPlayDeviceControlSupport", "e8DeviceControlSupport", "T_MPlayDeviceInfoItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceIndexedState_IsValid(e8DeviceIndexedState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceIndexedState_, "T_e8_MPlayDeviceIndexedState", "e8DeviceIndexedState", "T_MPlayDeviceInfoItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceStatus_IsValid(e8DeviceState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceState_, "T_e8_MPlayDeviceStatus", "e8DeviceState", "T_MPlayDeviceInfoItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceType_IsValid(e8DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceType_, "T_e8_MPlayDeviceType", "e8DeviceType", "T_MPlayDeviceInfoItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayDisconnectReason_IsValid(e8DisconnectReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DisconnectReason_, "T_e8_MPlayDisconnectReason", "e8DisconnectReason", "T_MPlayDeviceInfoItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileSystemType_IsValid(e8FileSystemType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileSystemType_, "T_e8_MPlayFileSystemType", "e8FileSystemType", "T_MPlayDeviceInfoItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceSysPath_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastPlayedFile_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e_MPlayDeviceDBViewStatus_IsValid(DeviceDBViewStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceDBViewStatus_, "T_e_MPlayDeviceDBViewStatus", "DeviceDBViewStatus", "T_MPlayDeviceInfoItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MPlayDeviceInfoItem::~T_MPlayDeviceInfoItem() {
}

inline T_MPlayDeviceInfoItem& T_MPlayDeviceInfoItem::operator = (const T_MPlayDeviceInfoItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8DiscType()) {
            setE8DiscType(rhs.getE8DiscType());
        } else {
            clearE8DiscType();
        }
        if (rhs.hasE8AvailabilityReason()) {
            setE8AvailabilityReason(rhs.getE8AvailabilityReason());
        } else {
            clearE8AvailabilityReason();
        }
        if (rhs.hasE8ConnectionState()) {
            setE8ConnectionState(rhs.getE8ConnectionState());
        } else {
            clearE8ConnectionState();
        }
        if (rhs.hasE8ConnectionType()) {
            setE8ConnectionType(rhs.getE8ConnectionType());
        } else {
            clearE8ConnectionType();
        }
        if (rhs.hasE8DeviceControlSupport()) {
            setE8DeviceControlSupport(rhs.getE8DeviceControlSupport());
        } else {
            clearE8DeviceControlSupport();
        }
        if (rhs.hasE8DeviceIndexedState()) {
            setE8DeviceIndexedState(rhs.getE8DeviceIndexedState());
        } else {
            clearE8DeviceIndexedState();
        }
        if (rhs.hasE8DeviceState()) {
            setE8DeviceState(rhs.getE8DeviceState());
        } else {
            clearE8DeviceState();
        }
        if (rhs.hasE8DeviceType()) {
            setE8DeviceType(rhs.getE8DeviceType());
        } else {
            clearE8DeviceType();
        }
        if (rhs.hasE8DisconnectReason()) {
            setE8DisconnectReason(rhs.getE8DisconnectReason());
        } else {
            clearE8DisconnectReason();
        }
        if (rhs.hasE8FileSystemType()) {
            setE8FileSystemType(rhs.getE8FileSystemType());
        } else {
            clearE8FileSystemType();
        }
        if (rhs.hasBDeviceActiveSource()) {
            setBDeviceActiveSource(rhs.getBDeviceActiveSource());
        } else {
            clearBDeviceActiveSource();
        }
        if (rhs.hasBDeviceConnected()) {
            setBDeviceConnected(rhs.getBDeviceConnected());
        } else {
            clearBDeviceConnected();
        }
        if (rhs.hasBIsNowPlayingListAvailable()) {
            setBIsNowPlayingListAvailable(rhs.getBIsNowPlayingListAvailable());
        } else {
            clearBIsNowPlayingListAvailable();
        }
        if (rhs.hasBRepeatSupported()) {
            setBRepeatSupported(rhs.getBRepeatSupported());
        } else {
            clearBRepeatSupported();
        }
        if (rhs.hasBScanSupported()) {
            setBScanSupported(rhs.getBScanSupported());
        } else {
            clearBScanSupported();
        }
        if (rhs.hasBShuffleSupported()) {
            setBShuffleSupported(rhs.getBShuffleSupported());
        } else {
            clearBShuffleSupported();
        }
        if (rhs.hasSDeviceName()) {
            setSDeviceName(rhs.getSDeviceName());
        } else {
            clearSDeviceName();
        }
        if (rhs.hasSDeviceSerialNumber()) {
            setSDeviceSerialNumber(rhs.getSDeviceSerialNumber());
        } else {
            clearSDeviceSerialNumber();
        }
        if (rhs.hasSDeviceSysPath()) {
            setSDeviceSysPath(rhs.getSDeviceSysPath());
        } else {
            clearSDeviceSysPath();
        }
        if (rhs.hasSDeviceVersion()) {
            setSDeviceVersion(rhs.getSDeviceVersion());
        } else {
            clearSDeviceVersion();
        }
        if (rhs.hasSLastPlayedFile()) {
            setSLastPlayedFile(rhs.getSLastPlayedFile());
        } else {
            clearSLastPlayedFile();
        }
        if (rhs.hasSMountPoint()) {
            setSMountPoint(rhs.getSMountPoint());
        } else {
            clearSMountPoint();
        }
        if (rhs.hasU32FreeSize()) {
            setU32FreeSize(rhs.getU32FreeSize());
        } else {
            clearU32FreeSize();
        }
        if (rhs.hasU32NumberOfFiles()) {
            setU32NumberOfFiles(rhs.getU32NumberOfFiles());
        } else {
            clearU32NumberOfFiles();
        }
        if (rhs.hasU32NumberOfImageFiles()) {
            setU32NumberOfImageFiles(rhs.getU32NumberOfImageFiles());
        } else {
            clearU32NumberOfImageFiles();
        }
        if (rhs.hasU32NumberOfVideoFiles()) {
            setU32NumberOfVideoFiles(rhs.getU32NumberOfVideoFiles());
        } else {
            clearU32NumberOfVideoFiles();
        }
        if (rhs.hasU32PartitionNumber()) {
            setU32PartitionNumber(rhs.getU32PartitionNumber());
        } else {
            clearU32PartitionNumber();
        }
        if (rhs.hasU32TotalSize()) {
            setU32TotalSize(rhs.getU32TotalSize());
        } else {
            clearU32TotalSize();
        }
        if (rhs.hasU8DeviceTag()) {
            setU8DeviceTag(rhs.getU8DeviceTag());
        } else {
            clearU8DeviceTag();
        }
        if (rhs.hasDeviceDBViewStatus()) {
            setDeviceDBViewStatus(rhs.getDeviceDBViewStatus());
        } else {
            clearDeviceDBViewStatus();
        }
    }
    return *this;
}

inline bool T_MPlayDeviceInfoItem::operator == (const T_MPlayDeviceInfoItem& rhs) const {
    return (((!hasE8DiscType() && !rhs.hasE8DiscType()) || getE8DiscType() == rhs.getE8DiscType()) &&
        ((!hasE8AvailabilityReason() && !rhs.hasE8AvailabilityReason()) || getE8AvailabilityReason() == rhs.getE8AvailabilityReason()) &&
        ((!hasE8ConnectionState() && !rhs.hasE8ConnectionState()) || getE8ConnectionState() == rhs.getE8ConnectionState()) &&
        ((!hasE8ConnectionType() && !rhs.hasE8ConnectionType()) || getE8ConnectionType() == rhs.getE8ConnectionType()) &&
        ((!hasE8DeviceControlSupport() && !rhs.hasE8DeviceControlSupport()) || getE8DeviceControlSupport() == rhs.getE8DeviceControlSupport()) &&
        ((!hasE8DeviceIndexedState() && !rhs.hasE8DeviceIndexedState()) || getE8DeviceIndexedState() == rhs.getE8DeviceIndexedState()) &&
        ((!hasE8DeviceState() && !rhs.hasE8DeviceState()) || getE8DeviceState() == rhs.getE8DeviceState()) &&
        ((!hasE8DeviceType() && !rhs.hasE8DeviceType()) || getE8DeviceType() == rhs.getE8DeviceType()) &&
        ((!hasE8DisconnectReason() && !rhs.hasE8DisconnectReason()) || getE8DisconnectReason() == rhs.getE8DisconnectReason()) &&
        ((!hasE8FileSystemType() && !rhs.hasE8FileSystemType()) || getE8FileSystemType() == rhs.getE8FileSystemType()) &&
        ((!hasBDeviceActiveSource() && !rhs.hasBDeviceActiveSource()) || getBDeviceActiveSource() == rhs.getBDeviceActiveSource()) &&
        ((!hasBDeviceConnected() && !rhs.hasBDeviceConnected()) || getBDeviceConnected() == rhs.getBDeviceConnected()) &&
        ((!hasBIsNowPlayingListAvailable() && !rhs.hasBIsNowPlayingListAvailable()) || getBIsNowPlayingListAvailable() == rhs.getBIsNowPlayingListAvailable()) &&
        ((!hasBRepeatSupported() && !rhs.hasBRepeatSupported()) || getBRepeatSupported() == rhs.getBRepeatSupported()) &&
        ((!hasBScanSupported() && !rhs.hasBScanSupported()) || getBScanSupported() == rhs.getBScanSupported()) &&
        ((!hasBShuffleSupported() && !rhs.hasBShuffleSupported()) || getBShuffleSupported() == rhs.getBShuffleSupported()) &&
        ((!hasSDeviceName() && !rhs.hasSDeviceName()) || getSDeviceName() == rhs.getSDeviceName()) &&
        ((!hasSDeviceSerialNumber() && !rhs.hasSDeviceSerialNumber()) || getSDeviceSerialNumber() == rhs.getSDeviceSerialNumber()) &&
        ((!hasSDeviceSysPath() && !rhs.hasSDeviceSysPath()) || getSDeviceSysPath() == rhs.getSDeviceSysPath()) &&
        ((!hasSDeviceVersion() && !rhs.hasSDeviceVersion()) || getSDeviceVersion() == rhs.getSDeviceVersion()) &&
        ((!hasSLastPlayedFile() && !rhs.hasSLastPlayedFile()) || getSLastPlayedFile() == rhs.getSLastPlayedFile()) &&
        ((!hasSMountPoint() && !rhs.hasSMountPoint()) || getSMountPoint() == rhs.getSMountPoint()) &&
        ((!hasU32FreeSize() && !rhs.hasU32FreeSize()) || getU32FreeSize() == rhs.getU32FreeSize()) &&
        ((!hasU32NumberOfFiles() && !rhs.hasU32NumberOfFiles()) || getU32NumberOfFiles() == rhs.getU32NumberOfFiles()) &&
        ((!hasU32NumberOfImageFiles() && !rhs.hasU32NumberOfImageFiles()) || getU32NumberOfImageFiles() == rhs.getU32NumberOfImageFiles()) &&
        ((!hasU32NumberOfVideoFiles() && !rhs.hasU32NumberOfVideoFiles()) || getU32NumberOfVideoFiles() == rhs.getU32NumberOfVideoFiles()) &&
        ((!hasU32PartitionNumber() && !rhs.hasU32PartitionNumber()) || getU32PartitionNumber() == rhs.getU32PartitionNumber()) &&
        ((!hasU32TotalSize() && !rhs.hasU32TotalSize()) || getU32TotalSize() == rhs.getU32TotalSize()) &&
        ((!hasU8DeviceTag() && !rhs.hasU8DeviceTag()) || getU8DeviceTag() == rhs.getU8DeviceTag()) &&
        ((!hasDeviceDBViewStatus() && !rhs.hasDeviceDBViewStatus()) || getDeviceDBViewStatus() == rhs.getDeviceDBViewStatus()));
}

inline bool T_MPlayDeviceInfoItem::operator != (const T_MPlayDeviceInfoItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MPlayDeviceInfoItem::operator < (const T_MPlayDeviceInfoItem& rhs) const {
    if (hasE8DiscType() || rhs.hasE8DiscType()) {
        if ((uint32)getE8DiscType() < (uint32)rhs.getE8DiscType()) return true;
        if ((uint32)getE8DiscType() > (uint32)rhs.getE8DiscType()) return false;
    }
    if (hasE8AvailabilityReason() || rhs.hasE8AvailabilityReason()) {
        if ((uint32)getE8AvailabilityReason() < (uint32)rhs.getE8AvailabilityReason()) return true;
        if ((uint32)getE8AvailabilityReason() > (uint32)rhs.getE8AvailabilityReason()) return false;
    }
    if (hasE8ConnectionState() || rhs.hasE8ConnectionState()) {
        if ((uint32)getE8ConnectionState() < (uint32)rhs.getE8ConnectionState()) return true;
        if ((uint32)getE8ConnectionState() > (uint32)rhs.getE8ConnectionState()) return false;
    }
    if (hasE8ConnectionType() || rhs.hasE8ConnectionType()) {
        if ((uint32)getE8ConnectionType() < (uint32)rhs.getE8ConnectionType()) return true;
        if ((uint32)getE8ConnectionType() > (uint32)rhs.getE8ConnectionType()) return false;
    }
    if (hasE8DeviceControlSupport() || rhs.hasE8DeviceControlSupport()) {
        if ((uint32)getE8DeviceControlSupport() < (uint32)rhs.getE8DeviceControlSupport()) return true;
        if ((uint32)getE8DeviceControlSupport() > (uint32)rhs.getE8DeviceControlSupport()) return false;
    }
    if (hasE8DeviceIndexedState() || rhs.hasE8DeviceIndexedState()) {
        if ((uint32)getE8DeviceIndexedState() < (uint32)rhs.getE8DeviceIndexedState()) return true;
        if ((uint32)getE8DeviceIndexedState() > (uint32)rhs.getE8DeviceIndexedState()) return false;
    }
    if (hasE8DeviceState() || rhs.hasE8DeviceState()) {
        if ((uint32)getE8DeviceState() < (uint32)rhs.getE8DeviceState()) return true;
        if ((uint32)getE8DeviceState() > (uint32)rhs.getE8DeviceState()) return false;
    }
    if (hasE8DeviceType() || rhs.hasE8DeviceType()) {
        if ((uint32)getE8DeviceType() < (uint32)rhs.getE8DeviceType()) return true;
        if ((uint32)getE8DeviceType() > (uint32)rhs.getE8DeviceType()) return false;
    }
    if (hasE8DisconnectReason() || rhs.hasE8DisconnectReason()) {
        if ((uint32)getE8DisconnectReason() < (uint32)rhs.getE8DisconnectReason()) return true;
        if ((uint32)getE8DisconnectReason() > (uint32)rhs.getE8DisconnectReason()) return false;
    }
    if (hasE8FileSystemType() || rhs.hasE8FileSystemType()) {
        if ((uint32)getE8FileSystemType() < (uint32)rhs.getE8FileSystemType()) return true;
        if ((uint32)getE8FileSystemType() > (uint32)rhs.getE8FileSystemType()) return false;
    }
    if (hasBDeviceActiveSource() || rhs.hasBDeviceActiveSource()) {
        if (getBDeviceActiveSource() < rhs.getBDeviceActiveSource()) return true;
        if (getBDeviceActiveSource() > rhs.getBDeviceActiveSource()) return false;
    }
    if (hasBDeviceConnected() || rhs.hasBDeviceConnected()) {
        if (getBDeviceConnected() < rhs.getBDeviceConnected()) return true;
        if (getBDeviceConnected() > rhs.getBDeviceConnected()) return false;
    }
    if (hasBIsNowPlayingListAvailable() || rhs.hasBIsNowPlayingListAvailable()) {
        if (getBIsNowPlayingListAvailable() < rhs.getBIsNowPlayingListAvailable()) return true;
        if (getBIsNowPlayingListAvailable() > rhs.getBIsNowPlayingListAvailable()) return false;
    }
    if (hasBRepeatSupported() || rhs.hasBRepeatSupported()) {
        if (getBRepeatSupported() < rhs.getBRepeatSupported()) return true;
        if (getBRepeatSupported() > rhs.getBRepeatSupported()) return false;
    }
    if (hasBScanSupported() || rhs.hasBScanSupported()) {
        if (getBScanSupported() < rhs.getBScanSupported()) return true;
        if (getBScanSupported() > rhs.getBScanSupported()) return false;
    }
    if (hasBShuffleSupported() || rhs.hasBShuffleSupported()) {
        if (getBShuffleSupported() < rhs.getBShuffleSupported()) return true;
        if (getBShuffleSupported() > rhs.getBShuffleSupported()) return false;
    }
    if (hasSDeviceName() || rhs.hasSDeviceName()) {
        if (getSDeviceName() < rhs.getSDeviceName()) return true;
        if (getSDeviceName() > rhs.getSDeviceName()) return false;
    }
    if (hasSDeviceSerialNumber() || rhs.hasSDeviceSerialNumber()) {
        if (getSDeviceSerialNumber() < rhs.getSDeviceSerialNumber()) return true;
        if (getSDeviceSerialNumber() > rhs.getSDeviceSerialNumber()) return false;
    }
    if (hasSDeviceSysPath() || rhs.hasSDeviceSysPath()) {
        if (getSDeviceSysPath() < rhs.getSDeviceSysPath()) return true;
        if (getSDeviceSysPath() > rhs.getSDeviceSysPath()) return false;
    }
    if (hasSDeviceVersion() || rhs.hasSDeviceVersion()) {
        if (getSDeviceVersion() < rhs.getSDeviceVersion()) return true;
        if (getSDeviceVersion() > rhs.getSDeviceVersion()) return false;
    }
    if (hasSLastPlayedFile() || rhs.hasSLastPlayedFile()) {
        if (getSLastPlayedFile() < rhs.getSLastPlayedFile()) return true;
        if (getSLastPlayedFile() > rhs.getSLastPlayedFile()) return false;
    }
    if (hasSMountPoint() || rhs.hasSMountPoint()) {
        if (getSMountPoint() < rhs.getSMountPoint()) return true;
        if (getSMountPoint() > rhs.getSMountPoint()) return false;
    }
    if (hasU32FreeSize() || rhs.hasU32FreeSize()) {
        if (getU32FreeSize() < rhs.getU32FreeSize()) return true;
        if (getU32FreeSize() > rhs.getU32FreeSize()) return false;
    }
    if (hasU32NumberOfFiles() || rhs.hasU32NumberOfFiles()) {
        if (getU32NumberOfFiles() < rhs.getU32NumberOfFiles()) return true;
        if (getU32NumberOfFiles() > rhs.getU32NumberOfFiles()) return false;
    }
    if (hasU32NumberOfImageFiles() || rhs.hasU32NumberOfImageFiles()) {
        if (getU32NumberOfImageFiles() < rhs.getU32NumberOfImageFiles()) return true;
        if (getU32NumberOfImageFiles() > rhs.getU32NumberOfImageFiles()) return false;
    }
    if (hasU32NumberOfVideoFiles() || rhs.hasU32NumberOfVideoFiles()) {
        if (getU32NumberOfVideoFiles() < rhs.getU32NumberOfVideoFiles()) return true;
        if (getU32NumberOfVideoFiles() > rhs.getU32NumberOfVideoFiles()) return false;
    }
    if (hasU32PartitionNumber() || rhs.hasU32PartitionNumber()) {
        if (getU32PartitionNumber() < rhs.getU32PartitionNumber()) return true;
        if (getU32PartitionNumber() > rhs.getU32PartitionNumber()) return false;
    }
    if (hasU32TotalSize() || rhs.hasU32TotalSize()) {
        if (getU32TotalSize() < rhs.getU32TotalSize()) return true;
        if (getU32TotalSize() > rhs.getU32TotalSize()) return false;
    }
    if (hasU8DeviceTag() || rhs.hasU8DeviceTag()) {
        if (getU8DeviceTag() < rhs.getU8DeviceTag()) return true;
        if (getU8DeviceTag() > rhs.getU8DeviceTag()) return false;
    }
    if (hasDeviceDBViewStatus() || rhs.hasDeviceDBViewStatus()) {
        if ((uint32)getDeviceDBViewStatus() < (uint32)rhs.getDeviceDBViewStatus()) return true;
        if ((uint32)getDeviceDBViewStatus() > (uint32)rhs.getDeviceDBViewStatus()) return false;
    }
    return false;
}

inline bool T_MPlayDeviceInfoItem::operator > (const T_MPlayDeviceInfoItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MPlayDeviceInfoItem::clear() {
    clearE8DiscType();
    clearE8AvailabilityReason();
    clearE8ConnectionState();
    clearE8ConnectionType();
    clearE8DeviceControlSupport();
    clearE8DeviceIndexedState();
    clearE8DeviceState();
    clearE8DeviceType();
    clearE8DisconnectReason();
    clearE8FileSystemType();
    clearBDeviceActiveSource();
    clearBDeviceConnected();
    clearBIsNowPlayingListAvailable();
    clearBRepeatSupported();
    clearBScanSupported();
    clearBShuffleSupported();
    clearSDeviceName();
    clearSDeviceSerialNumber();
    clearSDeviceSysPath();
    clearSDeviceVersion();
    clearSLastPlayedFile();
    clearSMountPoint();
    clearU32FreeSize();
    clearU32NumberOfFiles();
    clearU32NumberOfImageFiles();
    clearU32NumberOfVideoFiles();
    clearU32PartitionNumber();
    clearU32TotalSize();
    clearU8DeviceTag();
    clearDeviceDBViewStatus();
}

inline void T_MPlayDeviceInfoItem::clearE8DiscType() {
    if (hasE8DiscType()) {
         clear_has_e8DiscType();
        _e8DiscType = ::MPlay_fi_types::T_e8_MDiscType__e8AUDIO_CD_DISC;
     }
}

inline bool T_MPlayDeviceInfoItem::hasE8DiscType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_MDiscType T_MPlayDeviceInfoItem::getE8DiscType () const {
    return _e8DiscType;
}

inline void T_MPlayDeviceInfoItem::setE8DiscType (T_e8_MDiscType e8DiscType_) {
    #ifndef NDEBUG
    if (!(T_e8_MDiscType_IsValid(e8DiscType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DiscType_, "T_e8_MDiscType", "e8DiscType", "T_MPlayDeviceInfoItem");
    }
    #endif
    set_has_e8DiscType();
    this->_e8DiscType = e8DiscType_;
}

inline void T_MPlayDeviceInfoItem::clearE8AvailabilityReason() {
    if (hasE8AvailabilityReason()) {
         clear_has_e8AvailabilityReason();
        _e8AvailabilityReason = ::MPlay_fi_types::T_e8_MPlayAvailabilityReason__e8AR_NEW_MEDIA;
     }
}

inline bool T_MPlayDeviceInfoItem::hasE8AvailabilityReason () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_MPlayAvailabilityReason T_MPlayDeviceInfoItem::getE8AvailabilityReason () const {
    return _e8AvailabilityReason;
}

inline void T_MPlayDeviceInfoItem::setE8AvailabilityReason (T_e8_MPlayAvailabilityReason e8AvailabilityReason_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayAvailabilityReason_IsValid(e8AvailabilityReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AvailabilityReason_, "T_e8_MPlayAvailabilityReason", "e8AvailabilityReason", "T_MPlayDeviceInfoItem");
    }
    #endif
    set_has_e8AvailabilityReason();
    this->_e8AvailabilityReason = e8AvailabilityReason_;
}

inline void T_MPlayDeviceInfoItem::clearE8ConnectionState() {
    if (hasE8ConnectionState()) {
         clear_has_e8ConnectionState();
        _e8ConnectionState = ::MPlay_fi_types::T_e8_MPlayConnectionState__e8CS_ATTACHED;
     }
}

inline bool T_MPlayDeviceInfoItem::hasE8ConnectionState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_MPlayConnectionState T_MPlayDeviceInfoItem::getE8ConnectionState () const {
    return _e8ConnectionState;
}

inline void T_MPlayDeviceInfoItem::setE8ConnectionState (T_e8_MPlayConnectionState e8ConnectionState_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayConnectionState_IsValid(e8ConnectionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConnectionState_, "T_e8_MPlayConnectionState", "e8ConnectionState", "T_MPlayDeviceInfoItem");
    }
    #endif
    set_has_e8ConnectionState();
    this->_e8ConnectionState = e8ConnectionState_;
}

inline void T_MPlayDeviceInfoItem::clearE8ConnectionType() {
    if (hasE8ConnectionType()) {
         clear_has_e8ConnectionType();
        _e8ConnectionType = ::MPlay_fi_types::T_e8_MPlayConnectionType__e8DCT_BLUETOOTH;
     }
}

inline bool T_MPlayDeviceInfoItem::hasE8ConnectionType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_MPlayConnectionType T_MPlayDeviceInfoItem::getE8ConnectionType () const {
    return _e8ConnectionType;
}

inline void T_MPlayDeviceInfoItem::setE8ConnectionType (T_e8_MPlayConnectionType e8ConnectionType_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayConnectionType_IsValid(e8ConnectionType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConnectionType_, "T_e8_MPlayConnectionType", "e8ConnectionType", "T_MPlayDeviceInfoItem");
    }
    #endif
    set_has_e8ConnectionType();
    this->_e8ConnectionType = e8ConnectionType_;
}

inline void T_MPlayDeviceInfoItem::clearE8DeviceControlSupport() {
    if (hasE8DeviceControlSupport()) {
         clear_has_e8DeviceControlSupport();
        _e8DeviceControlSupport = ::MPlay_fi_types::T_e8_MPlayDeviceControlSupport__e8DCS_BROWSING;
     }
}

inline bool T_MPlayDeviceInfoItem::hasE8DeviceControlSupport () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_MPlayDeviceControlSupport T_MPlayDeviceInfoItem::getE8DeviceControlSupport () const {
    return _e8DeviceControlSupport;
}

inline void T_MPlayDeviceInfoItem::setE8DeviceControlSupport (T_e8_MPlayDeviceControlSupport e8DeviceControlSupport_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceControlSupport_IsValid(e8DeviceControlSupport_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceControlSupport_, "T_e8_MPlayDeviceControlSupport", "e8DeviceControlSupport", "T_MPlayDeviceInfoItem");
    }
    #endif
    set_has_e8DeviceControlSupport();
    this->_e8DeviceControlSupport = e8DeviceControlSupport_;
}

inline void T_MPlayDeviceInfoItem::clearE8DeviceIndexedState() {
    if (hasE8DeviceIndexedState()) {
         clear_has_e8DeviceIndexedState();
        _e8DeviceIndexedState = ::MPlay_fi_types::T_e8_MPlayDeviceIndexedState__e8IDS_COMPLETE;
     }
}

inline bool T_MPlayDeviceInfoItem::hasE8DeviceIndexedState () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_MPlayDeviceIndexedState T_MPlayDeviceInfoItem::getE8DeviceIndexedState () const {
    return _e8DeviceIndexedState;
}

inline void T_MPlayDeviceInfoItem::setE8DeviceIndexedState (T_e8_MPlayDeviceIndexedState e8DeviceIndexedState_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceIndexedState_IsValid(e8DeviceIndexedState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceIndexedState_, "T_e8_MPlayDeviceIndexedState", "e8DeviceIndexedState", "T_MPlayDeviceInfoItem");
    }
    #endif
    set_has_e8DeviceIndexedState();
    this->_e8DeviceIndexedState = e8DeviceIndexedState_;
}

inline void T_MPlayDeviceInfoItem::clearE8DeviceState() {
    if (hasE8DeviceState()) {
         clear_has_e8DeviceState();
        _e8DeviceState = ::MPlay_fi_types::T_e8_MPlayDeviceStatus__e8DS_COMMUNICATION_ERROR;
     }
}

inline bool T_MPlayDeviceInfoItem::hasE8DeviceState () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_MPlayDeviceStatus T_MPlayDeviceInfoItem::getE8DeviceState () const {
    return _e8DeviceState;
}

inline void T_MPlayDeviceInfoItem::setE8DeviceState (T_e8_MPlayDeviceStatus e8DeviceState_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceStatus_IsValid(e8DeviceState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceState_, "T_e8_MPlayDeviceStatus", "e8DeviceState", "T_MPlayDeviceInfoItem");
    }
    #endif
    set_has_e8DeviceState();
    this->_e8DeviceState = e8DeviceState_;
}

inline void T_MPlayDeviceInfoItem::clearE8DeviceType() {
    if (hasE8DeviceType()) {
         clear_has_e8DeviceType();
        _e8DeviceType = ::MPlay_fi_types::T_e8_MPlayDeviceType__e8DTY_BLUETOOTH;
     }
}

inline bool T_MPlayDeviceInfoItem::hasE8DeviceType () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline T_e8_MPlayDeviceType T_MPlayDeviceInfoItem::getE8DeviceType () const {
    return _e8DeviceType;
}

inline void T_MPlayDeviceInfoItem::setE8DeviceType (T_e8_MPlayDeviceType e8DeviceType_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceType_IsValid(e8DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceType_, "T_e8_MPlayDeviceType", "e8DeviceType", "T_MPlayDeviceInfoItem");
    }
    #endif
    set_has_e8DeviceType();
    this->_e8DeviceType = e8DeviceType_;
}

inline void T_MPlayDeviceInfoItem::clearE8DisconnectReason() {
    if (hasE8DisconnectReason()) {
         clear_has_e8DisconnectReason();
        _e8DisconnectReason = ::MPlay_fi_types::T_e8_MPlayDisconnectReason__e8DR_AUTOMATIC;
     }
}

inline bool T_MPlayDeviceInfoItem::hasE8DisconnectReason () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline T_e8_MPlayDisconnectReason T_MPlayDeviceInfoItem::getE8DisconnectReason () const {
    return _e8DisconnectReason;
}

inline void T_MPlayDeviceInfoItem::setE8DisconnectReason (T_e8_MPlayDisconnectReason e8DisconnectReason_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayDisconnectReason_IsValid(e8DisconnectReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DisconnectReason_, "T_e8_MPlayDisconnectReason", "e8DisconnectReason", "T_MPlayDeviceInfoItem");
    }
    #endif
    set_has_e8DisconnectReason();
    this->_e8DisconnectReason = e8DisconnectReason_;
}

inline void T_MPlayDeviceInfoItem::clearE8FileSystemType() {
    if (hasE8FileSystemType()) {
         clear_has_e8FileSystemType();
        _e8FileSystemType = ::MPlay_fi_types::T_e8_MPlayFileSystemType__e8FSTY_EXFAT;
     }
}

inline bool T_MPlayDeviceInfoItem::hasE8FileSystemType () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline T_e8_MPlayFileSystemType T_MPlayDeviceInfoItem::getE8FileSystemType () const {
    return _e8FileSystemType;
}

inline void T_MPlayDeviceInfoItem::setE8FileSystemType (T_e8_MPlayFileSystemType e8FileSystemType_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileSystemType_IsValid(e8FileSystemType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileSystemType_, "T_e8_MPlayFileSystemType", "e8FileSystemType", "T_MPlayDeviceInfoItem");
    }
    #endif
    set_has_e8FileSystemType();
    this->_e8FileSystemType = e8FileSystemType_;
}

inline void T_MPlayDeviceInfoItem::clearBDeviceActiveSource() {
    if (hasBDeviceActiveSource()) {
         clear_has_bDeviceActiveSource();
        _bDeviceActiveSource = false;
     }
}

inline bool T_MPlayDeviceInfoItem::hasBDeviceActiveSource () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool T_MPlayDeviceInfoItem::getBDeviceActiveSource () const {
    return _bDeviceActiveSource;
}

inline void T_MPlayDeviceInfoItem::setBDeviceActiveSource (bool bDeviceActiveSource_) {
    set_has_bDeviceActiveSource();
    this->_bDeviceActiveSource = bDeviceActiveSource_;
}

inline void T_MPlayDeviceInfoItem::clearBDeviceConnected() {
    if (hasBDeviceConnected()) {
         clear_has_bDeviceConnected();
        _bDeviceConnected = false;
     }
}

inline bool T_MPlayDeviceInfoItem::hasBDeviceConnected () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline bool T_MPlayDeviceInfoItem::getBDeviceConnected () const {
    return _bDeviceConnected;
}

inline void T_MPlayDeviceInfoItem::setBDeviceConnected (bool bDeviceConnected_) {
    set_has_bDeviceConnected();
    this->_bDeviceConnected = bDeviceConnected_;
}

inline void T_MPlayDeviceInfoItem::clearBIsNowPlayingListAvailable() {
    if (hasBIsNowPlayingListAvailable()) {
         clear_has_bIsNowPlayingListAvailable();
        _bIsNowPlayingListAvailable = false;
     }
}

inline bool T_MPlayDeviceInfoItem::hasBIsNowPlayingListAvailable () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline bool T_MPlayDeviceInfoItem::getBIsNowPlayingListAvailable () const {
    return _bIsNowPlayingListAvailable;
}

inline void T_MPlayDeviceInfoItem::setBIsNowPlayingListAvailable (bool bIsNowPlayingListAvailable_) {
    set_has_bIsNowPlayingListAvailable();
    this->_bIsNowPlayingListAvailable = bIsNowPlayingListAvailable_;
}

inline void T_MPlayDeviceInfoItem::clearBRepeatSupported() {
    if (hasBRepeatSupported()) {
         clear_has_bRepeatSupported();
        _bRepeatSupported = false;
     }
}

inline bool T_MPlayDeviceInfoItem::hasBRepeatSupported () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline bool T_MPlayDeviceInfoItem::getBRepeatSupported () const {
    return _bRepeatSupported;
}

inline void T_MPlayDeviceInfoItem::setBRepeatSupported (bool bRepeatSupported_) {
    set_has_bRepeatSupported();
    this->_bRepeatSupported = bRepeatSupported_;
}

inline void T_MPlayDeviceInfoItem::clearBScanSupported() {
    if (hasBScanSupported()) {
         clear_has_bScanSupported();
        _bScanSupported = false;
     }
}

inline bool T_MPlayDeviceInfoItem::hasBScanSupported () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline bool T_MPlayDeviceInfoItem::getBScanSupported () const {
    return _bScanSupported;
}

inline void T_MPlayDeviceInfoItem::setBScanSupported (bool bScanSupported_) {
    set_has_bScanSupported();
    this->_bScanSupported = bScanSupported_;
}

inline void T_MPlayDeviceInfoItem::clearBShuffleSupported() {
    if (hasBShuffleSupported()) {
         clear_has_bShuffleSupported();
        _bShuffleSupported = false;
     }
}

inline bool T_MPlayDeviceInfoItem::hasBShuffleSupported () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline bool T_MPlayDeviceInfoItem::getBShuffleSupported () const {
    return _bShuffleSupported;
}

inline void T_MPlayDeviceInfoItem::setBShuffleSupported (bool bShuffleSupported_) {
    set_has_bShuffleSupported();
    this->_bShuffleSupported = bShuffleSupported_;
}

inline void T_MPlayDeviceInfoItem::clearSDeviceName() {
    if (hasSDeviceName()) {
         clear_has_sDeviceName();
        _sDeviceName.clear();
     }
}

inline bool T_MPlayDeviceInfoItem::hasSDeviceName () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline const ::std::string& T_MPlayDeviceInfoItem::getSDeviceName () const {
    return _sDeviceName;
}

inline ::std::string& T_MPlayDeviceInfoItem::getSDeviceNameMutable () {
    set_has_sDeviceName();
    return _sDeviceName;
}

inline void T_MPlayDeviceInfoItem::setSDeviceName (const ::std::string& sDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceName();
    this->_sDeviceName = sDeviceName_;
}

inline void T_MPlayDeviceInfoItem::setSDeviceName (const char* sDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceName();
    this->_sDeviceName.assign(sDeviceName_);
}

inline void T_MPlayDeviceInfoItem::setSDeviceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceName();
    this->_sDeviceName.assign(value, size);
}

inline void T_MPlayDeviceInfoItem::clearSDeviceSerialNumber() {
    if (hasSDeviceSerialNumber()) {
         clear_has_sDeviceSerialNumber();
        _sDeviceSerialNumber.clear();
     }
}

inline bool T_MPlayDeviceInfoItem::hasSDeviceSerialNumber () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline const ::std::string& T_MPlayDeviceInfoItem::getSDeviceSerialNumber () const {
    return _sDeviceSerialNumber;
}

inline ::std::string& T_MPlayDeviceInfoItem::getSDeviceSerialNumberMutable () {
    set_has_sDeviceSerialNumber();
    return _sDeviceSerialNumber;
}

inline void T_MPlayDeviceInfoItem::setSDeviceSerialNumber (const ::std::string& sDeviceSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceSerialNumber();
    this->_sDeviceSerialNumber = sDeviceSerialNumber_;
}

inline void T_MPlayDeviceInfoItem::setSDeviceSerialNumber (const char* sDeviceSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceSerialNumber();
    this->_sDeviceSerialNumber.assign(sDeviceSerialNumber_);
}

inline void T_MPlayDeviceInfoItem::setSDeviceSerialNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceSerialNumber();
    this->_sDeviceSerialNumber.assign(value, size);
}

inline void T_MPlayDeviceInfoItem::clearSDeviceSysPath() {
    if (hasSDeviceSysPath()) {
         clear_has_sDeviceSysPath();
        _sDeviceSysPath.clear();
     }
}

inline bool T_MPlayDeviceInfoItem::hasSDeviceSysPath () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline const ::std::string& T_MPlayDeviceInfoItem::getSDeviceSysPath () const {
    return _sDeviceSysPath;
}

inline ::std::string& T_MPlayDeviceInfoItem::getSDeviceSysPathMutable () {
    set_has_sDeviceSysPath();
    return _sDeviceSysPath;
}

inline void T_MPlayDeviceInfoItem::setSDeviceSysPath (const ::std::string& sDeviceSysPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceSysPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceSysPath();
    this->_sDeviceSysPath = sDeviceSysPath_;
}

inline void T_MPlayDeviceInfoItem::setSDeviceSysPath (const char* sDeviceSysPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceSysPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceSysPath();
    this->_sDeviceSysPath.assign(sDeviceSysPath_);
}

inline void T_MPlayDeviceInfoItem::setSDeviceSysPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceSysPath();
    this->_sDeviceSysPath.assign(value, size);
}

inline void T_MPlayDeviceInfoItem::clearSDeviceVersion() {
    if (hasSDeviceVersion()) {
         clear_has_sDeviceVersion();
        _sDeviceVersion.clear();
     }
}

inline bool T_MPlayDeviceInfoItem::hasSDeviceVersion () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline const ::std::string& T_MPlayDeviceInfoItem::getSDeviceVersion () const {
    return _sDeviceVersion;
}

inline ::std::string& T_MPlayDeviceInfoItem::getSDeviceVersionMutable () {
    set_has_sDeviceVersion();
    return _sDeviceVersion;
}

inline void T_MPlayDeviceInfoItem::setSDeviceVersion (const ::std::string& sDeviceVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceVersion();
    this->_sDeviceVersion = sDeviceVersion_;
}

inline void T_MPlayDeviceInfoItem::setSDeviceVersion (const char* sDeviceVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceVersion();
    this->_sDeviceVersion.assign(sDeviceVersion_);
}

inline void T_MPlayDeviceInfoItem::setSDeviceVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceVersion();
    this->_sDeviceVersion.assign(value, size);
}

inline void T_MPlayDeviceInfoItem::clearSLastPlayedFile() {
    if (hasSLastPlayedFile()) {
         clear_has_sLastPlayedFile();
        _sLastPlayedFile.clear();
     }
}

inline bool T_MPlayDeviceInfoItem::hasSLastPlayedFile () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline const ::std::string& T_MPlayDeviceInfoItem::getSLastPlayedFile () const {
    return _sLastPlayedFile;
}

inline ::std::string& T_MPlayDeviceInfoItem::getSLastPlayedFileMutable () {
    set_has_sLastPlayedFile();
    return _sLastPlayedFile;
}

inline void T_MPlayDeviceInfoItem::setSLastPlayedFile (const ::std::string& sLastPlayedFile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastPlayedFile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLastPlayedFile();
    this->_sLastPlayedFile = sLastPlayedFile_;
}

inline void T_MPlayDeviceInfoItem::setSLastPlayedFile (const char* sLastPlayedFile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastPlayedFile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLastPlayedFile();
    this->_sLastPlayedFile.assign(sLastPlayedFile_);
}

inline void T_MPlayDeviceInfoItem::setSLastPlayedFile (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLastPlayedFile();
    this->_sLastPlayedFile.assign(value, size);
}

inline void T_MPlayDeviceInfoItem::clearSMountPoint() {
    if (hasSMountPoint()) {
         clear_has_sMountPoint();
        _sMountPoint.clear();
     }
}

inline bool T_MPlayDeviceInfoItem::hasSMountPoint () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline const ::std::string& T_MPlayDeviceInfoItem::getSMountPoint () const {
    return _sMountPoint;
}

inline ::std::string& T_MPlayDeviceInfoItem::getSMountPointMutable () {
    set_has_sMountPoint();
    return _sMountPoint;
}

inline void T_MPlayDeviceInfoItem::setSMountPoint (const ::std::string& sMountPoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMountPoint();
    this->_sMountPoint = sMountPoint_;
}

inline void T_MPlayDeviceInfoItem::setSMountPoint (const char* sMountPoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMountPoint();
    this->_sMountPoint.assign(sMountPoint_);
}

inline void T_MPlayDeviceInfoItem::setSMountPoint (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMountPoint();
    this->_sMountPoint.assign(value, size);
}

inline void T_MPlayDeviceInfoItem::clearU32FreeSize() {
    if (hasU32FreeSize()) {
         clear_has_u32FreeSize();
        _u32FreeSize = 0u;
     }
}

inline bool T_MPlayDeviceInfoItem::hasU32FreeSize () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline uint32 T_MPlayDeviceInfoItem::getU32FreeSize () const {
    return _u32FreeSize;
}

inline void T_MPlayDeviceInfoItem::setU32FreeSize (uint32 u32FreeSize_) {
    set_has_u32FreeSize();
    this->_u32FreeSize = u32FreeSize_;
}

inline void T_MPlayDeviceInfoItem::clearU32NumberOfFiles() {
    if (hasU32NumberOfFiles()) {
         clear_has_u32NumberOfFiles();
        _u32NumberOfFiles = 0u;
     }
}

inline bool T_MPlayDeviceInfoItem::hasU32NumberOfFiles () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline uint32 T_MPlayDeviceInfoItem::getU32NumberOfFiles () const {
    return _u32NumberOfFiles;
}

inline void T_MPlayDeviceInfoItem::setU32NumberOfFiles (uint32 u32NumberOfFiles_) {
    set_has_u32NumberOfFiles();
    this->_u32NumberOfFiles = u32NumberOfFiles_;
}

inline void T_MPlayDeviceInfoItem::clearU32NumberOfImageFiles() {
    if (hasU32NumberOfImageFiles()) {
         clear_has_u32NumberOfImageFiles();
        _u32NumberOfImageFiles = 0u;
     }
}

inline bool T_MPlayDeviceInfoItem::hasU32NumberOfImageFiles () const {
    return (_has_bits_[0] & (1u << 24)) > 0;
}

inline uint32 T_MPlayDeviceInfoItem::getU32NumberOfImageFiles () const {
    return _u32NumberOfImageFiles;
}

inline void T_MPlayDeviceInfoItem::setU32NumberOfImageFiles (uint32 u32NumberOfImageFiles_) {
    set_has_u32NumberOfImageFiles();
    this->_u32NumberOfImageFiles = u32NumberOfImageFiles_;
}

inline void T_MPlayDeviceInfoItem::clearU32NumberOfVideoFiles() {
    if (hasU32NumberOfVideoFiles()) {
         clear_has_u32NumberOfVideoFiles();
        _u32NumberOfVideoFiles = 0u;
     }
}

inline bool T_MPlayDeviceInfoItem::hasU32NumberOfVideoFiles () const {
    return (_has_bits_[0] & (1u << 25)) > 0;
}

inline uint32 T_MPlayDeviceInfoItem::getU32NumberOfVideoFiles () const {
    return _u32NumberOfVideoFiles;
}

inline void T_MPlayDeviceInfoItem::setU32NumberOfVideoFiles (uint32 u32NumberOfVideoFiles_) {
    set_has_u32NumberOfVideoFiles();
    this->_u32NumberOfVideoFiles = u32NumberOfVideoFiles_;
}

inline void T_MPlayDeviceInfoItem::clearU32PartitionNumber() {
    if (hasU32PartitionNumber()) {
         clear_has_u32PartitionNumber();
        _u32PartitionNumber = 0u;
     }
}

inline bool T_MPlayDeviceInfoItem::hasU32PartitionNumber () const {
    return (_has_bits_[0] & (1u << 26)) > 0;
}

inline uint32 T_MPlayDeviceInfoItem::getU32PartitionNumber () const {
    return _u32PartitionNumber;
}

inline void T_MPlayDeviceInfoItem::setU32PartitionNumber (uint32 u32PartitionNumber_) {
    set_has_u32PartitionNumber();
    this->_u32PartitionNumber = u32PartitionNumber_;
}

inline void T_MPlayDeviceInfoItem::clearU32TotalSize() {
    if (hasU32TotalSize()) {
         clear_has_u32TotalSize();
        _u32TotalSize = 0u;
     }
}

inline bool T_MPlayDeviceInfoItem::hasU32TotalSize () const {
    return (_has_bits_[0] & (1u << 27)) > 0;
}

inline uint32 T_MPlayDeviceInfoItem::getU32TotalSize () const {
    return _u32TotalSize;
}

inline void T_MPlayDeviceInfoItem::setU32TotalSize (uint32 u32TotalSize_) {
    set_has_u32TotalSize();
    this->_u32TotalSize = u32TotalSize_;
}

inline void T_MPlayDeviceInfoItem::clearU8DeviceTag() {
    if (hasU8DeviceTag()) {
         clear_has_u8DeviceTag();
        _u8DeviceTag = 0u;
     }
}

inline bool T_MPlayDeviceInfoItem::hasU8DeviceTag () const {
    return (_has_bits_[0] & (1u << 28)) > 0;
}

inline uint8 T_MPlayDeviceInfoItem::getU8DeviceTag () const {
    return _u8DeviceTag;
}

inline void T_MPlayDeviceInfoItem::setU8DeviceTag (uint8 u8DeviceTag_) {
    set_has_u8DeviceTag();
    this->_u8DeviceTag = u8DeviceTag_;
}

inline void T_MPlayDeviceInfoItem::clearDeviceDBViewStatus() {
    if (hasDeviceDBViewStatus()) {
         clear_has_DeviceDBViewStatus();
        _DeviceDBViewStatus = ::MPlay_fi_types::T_e_MPlayDeviceDBViewStatus__DB_VIEWS_DONT_CARE;
     }
}

inline bool T_MPlayDeviceInfoItem::hasDeviceDBViewStatus () const {
    return (_has_bits_[0] & (1u << 29)) > 0;
}

inline T_e_MPlayDeviceDBViewStatus T_MPlayDeviceInfoItem::getDeviceDBViewStatus () const {
    return _DeviceDBViewStatus;
}

inline void T_MPlayDeviceInfoItem::setDeviceDBViewStatus (T_e_MPlayDeviceDBViewStatus DeviceDBViewStatus_) {
    #ifndef NDEBUG
    if (!(T_e_MPlayDeviceDBViewStatus_IsValid(DeviceDBViewStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceDBViewStatus_, "T_e_MPlayDeviceDBViewStatus", "DeviceDBViewStatus", "T_MPlayDeviceInfoItem");
    }
    #endif
    set_has_DeviceDBViewStatus();
    this->_DeviceDBViewStatus = DeviceDBViewStatus_;
}

inline void T_MPlayDeviceInfoItem::set_has_e8DiscType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MPlayDeviceInfoItem::clear_has_e8DiscType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MPlayDeviceInfoItem::set_has_e8AvailabilityReason () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MPlayDeviceInfoItem::clear_has_e8AvailabilityReason () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MPlayDeviceInfoItem::set_has_e8ConnectionState () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MPlayDeviceInfoItem::clear_has_e8ConnectionState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MPlayDeviceInfoItem::set_has_e8ConnectionType () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MPlayDeviceInfoItem::clear_has_e8ConnectionType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MPlayDeviceInfoItem::set_has_e8DeviceControlSupport () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MPlayDeviceInfoItem::clear_has_e8DeviceControlSupport () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MPlayDeviceInfoItem::set_has_e8DeviceIndexedState () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MPlayDeviceInfoItem::clear_has_e8DeviceIndexedState () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_MPlayDeviceInfoItem::set_has_e8DeviceState () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_MPlayDeviceInfoItem::clear_has_e8DeviceState () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_MPlayDeviceInfoItem::set_has_e8DeviceType () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_MPlayDeviceInfoItem::clear_has_e8DeviceType () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_MPlayDeviceInfoItem::set_has_e8DisconnectReason () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_MPlayDeviceInfoItem::clear_has_e8DisconnectReason () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_MPlayDeviceInfoItem::set_has_e8FileSystemType () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_MPlayDeviceInfoItem::clear_has_e8FileSystemType () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_MPlayDeviceInfoItem::set_has_bDeviceActiveSource () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_MPlayDeviceInfoItem::clear_has_bDeviceActiveSource () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_MPlayDeviceInfoItem::set_has_bDeviceConnected () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_MPlayDeviceInfoItem::clear_has_bDeviceConnected () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_MPlayDeviceInfoItem::set_has_bIsNowPlayingListAvailable () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_MPlayDeviceInfoItem::clear_has_bIsNowPlayingListAvailable () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_MPlayDeviceInfoItem::set_has_bRepeatSupported () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_MPlayDeviceInfoItem::clear_has_bRepeatSupported () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_MPlayDeviceInfoItem::set_has_bScanSupported () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_MPlayDeviceInfoItem::clear_has_bScanSupported () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_MPlayDeviceInfoItem::set_has_bShuffleSupported () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_MPlayDeviceInfoItem::clear_has_bShuffleSupported () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_MPlayDeviceInfoItem::set_has_sDeviceName () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_MPlayDeviceInfoItem::clear_has_sDeviceName () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_MPlayDeviceInfoItem::set_has_sDeviceSerialNumber () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_MPlayDeviceInfoItem::clear_has_sDeviceSerialNumber () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_MPlayDeviceInfoItem::set_has_sDeviceSysPath () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_MPlayDeviceInfoItem::clear_has_sDeviceSysPath () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_MPlayDeviceInfoItem::set_has_sDeviceVersion () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_MPlayDeviceInfoItem::clear_has_sDeviceVersion () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_MPlayDeviceInfoItem::set_has_sLastPlayedFile () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_MPlayDeviceInfoItem::clear_has_sLastPlayedFile () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_MPlayDeviceInfoItem::set_has_sMountPoint () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_MPlayDeviceInfoItem::clear_has_sMountPoint () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_MPlayDeviceInfoItem::set_has_u32FreeSize () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_MPlayDeviceInfoItem::clear_has_u32FreeSize () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_MPlayDeviceInfoItem::set_has_u32NumberOfFiles () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_MPlayDeviceInfoItem::clear_has_u32NumberOfFiles () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline void T_MPlayDeviceInfoItem::set_has_u32NumberOfImageFiles () {
    _has_bits_[0] |= 1u << 24;
}

inline void T_MPlayDeviceInfoItem::clear_has_u32NumberOfImageFiles () {
    _has_bits_[0] &= ~ (1u << 24);
}

inline void T_MPlayDeviceInfoItem::set_has_u32NumberOfVideoFiles () {
    _has_bits_[0] |= 1u << 25;
}

inline void T_MPlayDeviceInfoItem::clear_has_u32NumberOfVideoFiles () {
    _has_bits_[0] &= ~ (1u << 25);
}

inline void T_MPlayDeviceInfoItem::set_has_u32PartitionNumber () {
    _has_bits_[0] |= 1u << 26;
}

inline void T_MPlayDeviceInfoItem::clear_has_u32PartitionNumber () {
    _has_bits_[0] &= ~ (1u << 26);
}

inline void T_MPlayDeviceInfoItem::set_has_u32TotalSize () {
    _has_bits_[0] |= 1u << 27;
}

inline void T_MPlayDeviceInfoItem::clear_has_u32TotalSize () {
    _has_bits_[0] &= ~ (1u << 27);
}

inline void T_MPlayDeviceInfoItem::set_has_u8DeviceTag () {
    _has_bits_[0] |= 1u << 28;
}

inline void T_MPlayDeviceInfoItem::clear_has_u8DeviceTag () {
    _has_bits_[0] &= ~ (1u << 28);
}

inline void T_MPlayDeviceInfoItem::set_has_DeviceDBViewStatus () {
    _has_bits_[0] |= 1u << 29;
}

inline void T_MPlayDeviceInfoItem::clear_has_DeviceDBViewStatus () {
    _has_bits_[0] &= ~ (1u << 29);
}

inline  T_MPlayFileListItem::T_MPlayFileListItem ()  :
    _e8FileFormat (::MPlay_fi_types::T_e8_MPlayFileFormat__e8FFT_3G2),
    _e8FileType (::MPlay_fi_types::T_e8_MPlayFileType__e8FT_AUDIO),
    _e8PlayableStatus (::MPlay_fi_types::T_e8_MPlayPlayableStatus__e8FP_DRM_PROTECTED),
    _bIsPlaying (false),
    _bReadOnlyFlag (false),
    _sFilename (),
    _u32Tag (0u),
    _u8TrackNumber (0u),
    _sDateTime (),
    _u32TotalPlaytime (0u),
    _u64FileSize (0u),
    _sCoverArt (),
    _Tag (0u),
    _ParentTag (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MPlayFileListItem::T_MPlayFileListItem (const T_MPlayFileListItem &rhs)  :
    _e8FileFormat (::MPlay_fi_types::T_e8_MPlayFileFormat__e8FFT_3G2),
    _e8FileType (::MPlay_fi_types::T_e8_MPlayFileType__e8FT_AUDIO),
    _e8PlayableStatus (::MPlay_fi_types::T_e8_MPlayPlayableStatus__e8FP_DRM_PROTECTED),
    _bIsPlaying (false),
    _bReadOnlyFlag (false),
    _sFilename (),
    _u32Tag (0u),
    _u8TrackNumber (0u),
    _sDateTime (),
    _u32TotalPlaytime (0u),
    _u64FileSize (0u),
    _sCoverArt (),
    _Tag (0u),
    _ParentTag (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MPlayFileListItem::T_MPlayFileListItem (T_e8_MPlayFileFormat e8FileFormat_, T_e8_MPlayFileType e8FileType_, T_e8_MPlayPlayableStatus e8PlayableStatus_, bool bIsPlaying_, bool bReadOnlyFlag_, const ::std::string& sFilename_, uint32 u32Tag_, uint8 u8TrackNumber_, const ::std::string& sDateTime_, uint32 u32TotalPlaytime_, uint64 u64FileSize_, const ::std::string& sCoverArt_, uint64 Tag_, uint64 ParentTag_)  :
    _e8FileFormat (e8FileFormat_),
    _e8FileType (e8FileType_),
    _e8PlayableStatus (e8PlayableStatus_),
    _bIsPlaying (bIsPlaying_),
    _bReadOnlyFlag (bReadOnlyFlag_),
    _sFilename (sFilename_),
    _u32Tag (u32Tag_),
    _u8TrackNumber (u8TrackNumber_),
    _sDateTime (sDateTime_),
    _u32TotalPlaytime (u32TotalPlaytime_),
    _u64FileSize (u64FileSize_),
    _sCoverArt (sCoverArt_),
    _Tag (Tag_),
    _ParentTag (ParentTag_)
{
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileFormat_IsValid(e8FileFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileFormat_, "T_e8_MPlayFileFormat", "e8FileFormat", "T_MPlayFileListItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileType_IsValid(e8FileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileType_, "T_e8_MPlayFileType", "e8FileType", "T_MPlayFileListItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayPlayableStatus_IsValid(e8PlayableStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PlayableStatus_, "T_e8_MPlayPlayableStatus", "e8PlayableStatus", "T_MPlayFileListItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFilename_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDateTime_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCoverArt_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MPlayFileListItem::~T_MPlayFileListItem() {
}

inline T_MPlayFileListItem& T_MPlayFileListItem::operator = (const T_MPlayFileListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8FileFormat()) {
            setE8FileFormat(rhs.getE8FileFormat());
        } else {
            clearE8FileFormat();
        }
        if (rhs.hasE8FileType()) {
            setE8FileType(rhs.getE8FileType());
        } else {
            clearE8FileType();
        }
        if (rhs.hasE8PlayableStatus()) {
            setE8PlayableStatus(rhs.getE8PlayableStatus());
        } else {
            clearE8PlayableStatus();
        }
        if (rhs.hasBIsPlaying()) {
            setBIsPlaying(rhs.getBIsPlaying());
        } else {
            clearBIsPlaying();
        }
        if (rhs.hasBReadOnlyFlag()) {
            setBReadOnlyFlag(rhs.getBReadOnlyFlag());
        } else {
            clearBReadOnlyFlag();
        }
        if (rhs.hasSFilename()) {
            setSFilename(rhs.getSFilename());
        } else {
            clearSFilename();
        }
        if (rhs.hasU32Tag()) {
            setU32Tag(rhs.getU32Tag());
        } else {
            clearU32Tag();
        }
        if (rhs.hasU8TrackNumber()) {
            setU8TrackNumber(rhs.getU8TrackNumber());
        } else {
            clearU8TrackNumber();
        }
        if (rhs.hasSDateTime()) {
            setSDateTime(rhs.getSDateTime());
        } else {
            clearSDateTime();
        }
        if (rhs.hasU32TotalPlaytime()) {
            setU32TotalPlaytime(rhs.getU32TotalPlaytime());
        } else {
            clearU32TotalPlaytime();
        }
        if (rhs.hasU64FileSize()) {
            setU64FileSize(rhs.getU64FileSize());
        } else {
            clearU64FileSize();
        }
        if (rhs.hasSCoverArt()) {
            setSCoverArt(rhs.getSCoverArt());
        } else {
            clearSCoverArt();
        }
        if (rhs.hasTag()) {
            setTag(rhs.getTag());
        } else {
            clearTag();
        }
        if (rhs.hasParentTag()) {
            setParentTag(rhs.getParentTag());
        } else {
            clearParentTag();
        }
    }
    return *this;
}

inline bool T_MPlayFileListItem::operator == (const T_MPlayFileListItem& rhs) const {
    return (((!hasE8FileFormat() && !rhs.hasE8FileFormat()) || getE8FileFormat() == rhs.getE8FileFormat()) &&
        ((!hasE8FileType() && !rhs.hasE8FileType()) || getE8FileType() == rhs.getE8FileType()) &&
        ((!hasE8PlayableStatus() && !rhs.hasE8PlayableStatus()) || getE8PlayableStatus() == rhs.getE8PlayableStatus()) &&
        ((!hasBIsPlaying() && !rhs.hasBIsPlaying()) || getBIsPlaying() == rhs.getBIsPlaying()) &&
        ((!hasBReadOnlyFlag() && !rhs.hasBReadOnlyFlag()) || getBReadOnlyFlag() == rhs.getBReadOnlyFlag()) &&
        ((!hasSFilename() && !rhs.hasSFilename()) || getSFilename() == rhs.getSFilename()) &&
        ((!hasU32Tag() && !rhs.hasU32Tag()) || getU32Tag() == rhs.getU32Tag()) &&
        ((!hasU8TrackNumber() && !rhs.hasU8TrackNumber()) || getU8TrackNumber() == rhs.getU8TrackNumber()) &&
        ((!hasSDateTime() && !rhs.hasSDateTime()) || getSDateTime() == rhs.getSDateTime()) &&
        ((!hasU32TotalPlaytime() && !rhs.hasU32TotalPlaytime()) || getU32TotalPlaytime() == rhs.getU32TotalPlaytime()) &&
        ((!hasU64FileSize() && !rhs.hasU64FileSize()) || getU64FileSize() == rhs.getU64FileSize()) &&
        ((!hasSCoverArt() && !rhs.hasSCoverArt()) || getSCoverArt() == rhs.getSCoverArt()) &&
        ((!hasTag() && !rhs.hasTag()) || getTag() == rhs.getTag()) &&
        ((!hasParentTag() && !rhs.hasParentTag()) || getParentTag() == rhs.getParentTag()));
}

inline bool T_MPlayFileListItem::operator != (const T_MPlayFileListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MPlayFileListItem::operator < (const T_MPlayFileListItem& rhs) const {
    if (hasE8FileFormat() || rhs.hasE8FileFormat()) {
        if ((uint32)getE8FileFormat() < (uint32)rhs.getE8FileFormat()) return true;
        if ((uint32)getE8FileFormat() > (uint32)rhs.getE8FileFormat()) return false;
    }
    if (hasE8FileType() || rhs.hasE8FileType()) {
        if ((uint32)getE8FileType() < (uint32)rhs.getE8FileType()) return true;
        if ((uint32)getE8FileType() > (uint32)rhs.getE8FileType()) return false;
    }
    if (hasE8PlayableStatus() || rhs.hasE8PlayableStatus()) {
        if ((uint32)getE8PlayableStatus() < (uint32)rhs.getE8PlayableStatus()) return true;
        if ((uint32)getE8PlayableStatus() > (uint32)rhs.getE8PlayableStatus()) return false;
    }
    if (hasBIsPlaying() || rhs.hasBIsPlaying()) {
        if (getBIsPlaying() < rhs.getBIsPlaying()) return true;
        if (getBIsPlaying() > rhs.getBIsPlaying()) return false;
    }
    if (hasBReadOnlyFlag() || rhs.hasBReadOnlyFlag()) {
        if (getBReadOnlyFlag() < rhs.getBReadOnlyFlag()) return true;
        if (getBReadOnlyFlag() > rhs.getBReadOnlyFlag()) return false;
    }
    if (hasSFilename() || rhs.hasSFilename()) {
        if (getSFilename() < rhs.getSFilename()) return true;
        if (getSFilename() > rhs.getSFilename()) return false;
    }
    if (hasU32Tag() || rhs.hasU32Tag()) {
        if (getU32Tag() < rhs.getU32Tag()) return true;
        if (getU32Tag() > rhs.getU32Tag()) return false;
    }
    if (hasU8TrackNumber() || rhs.hasU8TrackNumber()) {
        if (getU8TrackNumber() < rhs.getU8TrackNumber()) return true;
        if (getU8TrackNumber() > rhs.getU8TrackNumber()) return false;
    }
    if (hasSDateTime() || rhs.hasSDateTime()) {
        if (getSDateTime() < rhs.getSDateTime()) return true;
        if (getSDateTime() > rhs.getSDateTime()) return false;
    }
    if (hasU32TotalPlaytime() || rhs.hasU32TotalPlaytime()) {
        if (getU32TotalPlaytime() < rhs.getU32TotalPlaytime()) return true;
        if (getU32TotalPlaytime() > rhs.getU32TotalPlaytime()) return false;
    }
    if (hasU64FileSize() || rhs.hasU64FileSize()) {
        if (getU64FileSize() < rhs.getU64FileSize()) return true;
        if (getU64FileSize() > rhs.getU64FileSize()) return false;
    }
    if (hasSCoverArt() || rhs.hasSCoverArt()) {
        if (getSCoverArt() < rhs.getSCoverArt()) return true;
        if (getSCoverArt() > rhs.getSCoverArt()) return false;
    }
    if (hasTag() || rhs.hasTag()) {
        if (getTag() < rhs.getTag()) return true;
        if (getTag() > rhs.getTag()) return false;
    }
    if (hasParentTag() || rhs.hasParentTag()) {
        if (getParentTag() < rhs.getParentTag()) return true;
        if (getParentTag() > rhs.getParentTag()) return false;
    }
    return false;
}

inline bool T_MPlayFileListItem::operator > (const T_MPlayFileListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MPlayFileListItem::clear() {
    clearE8FileFormat();
    clearE8FileType();
    clearE8PlayableStatus();
    clearBIsPlaying();
    clearBReadOnlyFlag();
    clearSFilename();
    clearU32Tag();
    clearU8TrackNumber();
    clearSDateTime();
    clearU32TotalPlaytime();
    clearU64FileSize();
    clearSCoverArt();
    clearTag();
    clearParentTag();
}

inline void T_MPlayFileListItem::clearE8FileFormat() {
    if (hasE8FileFormat()) {
         clear_has_e8FileFormat();
        _e8FileFormat = ::MPlay_fi_types::T_e8_MPlayFileFormat__e8FFT_3G2;
     }
}

inline bool T_MPlayFileListItem::hasE8FileFormat () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_MPlayFileFormat T_MPlayFileListItem::getE8FileFormat () const {
    return _e8FileFormat;
}

inline void T_MPlayFileListItem::setE8FileFormat (T_e8_MPlayFileFormat e8FileFormat_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileFormat_IsValid(e8FileFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileFormat_, "T_e8_MPlayFileFormat", "e8FileFormat", "T_MPlayFileListItem");
    }
    #endif
    set_has_e8FileFormat();
    this->_e8FileFormat = e8FileFormat_;
}

inline void T_MPlayFileListItem::clearE8FileType() {
    if (hasE8FileType()) {
         clear_has_e8FileType();
        _e8FileType = ::MPlay_fi_types::T_e8_MPlayFileType__e8FT_AUDIO;
     }
}

inline bool T_MPlayFileListItem::hasE8FileType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_MPlayFileType T_MPlayFileListItem::getE8FileType () const {
    return _e8FileType;
}

inline void T_MPlayFileListItem::setE8FileType (T_e8_MPlayFileType e8FileType_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileType_IsValid(e8FileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileType_, "T_e8_MPlayFileType", "e8FileType", "T_MPlayFileListItem");
    }
    #endif
    set_has_e8FileType();
    this->_e8FileType = e8FileType_;
}

inline void T_MPlayFileListItem::clearE8PlayableStatus() {
    if (hasE8PlayableStatus()) {
         clear_has_e8PlayableStatus();
        _e8PlayableStatus = ::MPlay_fi_types::T_e8_MPlayPlayableStatus__e8FP_DRM_PROTECTED;
     }
}

inline bool T_MPlayFileListItem::hasE8PlayableStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_MPlayPlayableStatus T_MPlayFileListItem::getE8PlayableStatus () const {
    return _e8PlayableStatus;
}

inline void T_MPlayFileListItem::setE8PlayableStatus (T_e8_MPlayPlayableStatus e8PlayableStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayPlayableStatus_IsValid(e8PlayableStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PlayableStatus_, "T_e8_MPlayPlayableStatus", "e8PlayableStatus", "T_MPlayFileListItem");
    }
    #endif
    set_has_e8PlayableStatus();
    this->_e8PlayableStatus = e8PlayableStatus_;
}

inline void T_MPlayFileListItem::clearBIsPlaying() {
    if (hasBIsPlaying()) {
         clear_has_bIsPlaying();
        _bIsPlaying = false;
     }
}

inline bool T_MPlayFileListItem::hasBIsPlaying () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_MPlayFileListItem::getBIsPlaying () const {
    return _bIsPlaying;
}

inline void T_MPlayFileListItem::setBIsPlaying (bool bIsPlaying_) {
    set_has_bIsPlaying();
    this->_bIsPlaying = bIsPlaying_;
}

inline void T_MPlayFileListItem::clearBReadOnlyFlag() {
    if (hasBReadOnlyFlag()) {
         clear_has_bReadOnlyFlag();
        _bReadOnlyFlag = false;
     }
}

inline bool T_MPlayFileListItem::hasBReadOnlyFlag () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_MPlayFileListItem::getBReadOnlyFlag () const {
    return _bReadOnlyFlag;
}

inline void T_MPlayFileListItem::setBReadOnlyFlag (bool bReadOnlyFlag_) {
    set_has_bReadOnlyFlag();
    this->_bReadOnlyFlag = bReadOnlyFlag_;
}

inline void T_MPlayFileListItem::clearSFilename() {
    if (hasSFilename()) {
         clear_has_sFilename();
        _sFilename.clear();
     }
}

inline bool T_MPlayFileListItem::hasSFilename () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_MPlayFileListItem::getSFilename () const {
    return _sFilename;
}

inline ::std::string& T_MPlayFileListItem::getSFilenameMutable () {
    set_has_sFilename();
    return _sFilename;
}

inline void T_MPlayFileListItem::setSFilename (const ::std::string& sFilename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFilename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFilename();
    this->_sFilename = sFilename_;
}

inline void T_MPlayFileListItem::setSFilename (const char* sFilename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFilename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFilename();
    this->_sFilename.assign(sFilename_);
}

inline void T_MPlayFileListItem::setSFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFilename();
    this->_sFilename.assign(value, size);
}

inline void T_MPlayFileListItem::clearU32Tag() {
    if (hasU32Tag()) {
         clear_has_u32Tag();
        _u32Tag = 0u;
     }
}

inline bool T_MPlayFileListItem::hasU32Tag () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 T_MPlayFileListItem::getU32Tag () const {
    return _u32Tag;
}

inline void T_MPlayFileListItem::setU32Tag (uint32 u32Tag_) {
    set_has_u32Tag();
    this->_u32Tag = u32Tag_;
}

inline void T_MPlayFileListItem::clearU8TrackNumber() {
    if (hasU8TrackNumber()) {
         clear_has_u8TrackNumber();
        _u8TrackNumber = 0u;
     }
}

inline bool T_MPlayFileListItem::hasU8TrackNumber () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_MPlayFileListItem::getU8TrackNumber () const {
    return _u8TrackNumber;
}

inline void T_MPlayFileListItem::setU8TrackNumber (uint8 u8TrackNumber_) {
    set_has_u8TrackNumber();
    this->_u8TrackNumber = u8TrackNumber_;
}

inline void T_MPlayFileListItem::clearSDateTime() {
    if (hasSDateTime()) {
         clear_has_sDateTime();
        _sDateTime.clear();
     }
}

inline bool T_MPlayFileListItem::hasSDateTime () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_MPlayFileListItem::getSDateTime () const {
    return _sDateTime;
}

inline ::std::string& T_MPlayFileListItem::getSDateTimeMutable () {
    set_has_sDateTime();
    return _sDateTime;
}

inline void T_MPlayFileListItem::setSDateTime (const ::std::string& sDateTime_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDateTime_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDateTime();
    this->_sDateTime = sDateTime_;
}

inline void T_MPlayFileListItem::setSDateTime (const char* sDateTime_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDateTime_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDateTime();
    this->_sDateTime.assign(sDateTime_);
}

inline void T_MPlayFileListItem::setSDateTime (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDateTime();
    this->_sDateTime.assign(value, size);
}

inline void T_MPlayFileListItem::clearU32TotalPlaytime() {
    if (hasU32TotalPlaytime()) {
         clear_has_u32TotalPlaytime();
        _u32TotalPlaytime = 0u;
     }
}

inline bool T_MPlayFileListItem::hasU32TotalPlaytime () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint32 T_MPlayFileListItem::getU32TotalPlaytime () const {
    return _u32TotalPlaytime;
}

inline void T_MPlayFileListItem::setU32TotalPlaytime (uint32 u32TotalPlaytime_) {
    set_has_u32TotalPlaytime();
    this->_u32TotalPlaytime = u32TotalPlaytime_;
}

inline void T_MPlayFileListItem::clearU64FileSize() {
    if (hasU64FileSize()) {
         clear_has_u64FileSize();
        _u64FileSize = 0u;
     }
}

inline bool T_MPlayFileListItem::hasU64FileSize () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint64 T_MPlayFileListItem::getU64FileSize () const {
    return _u64FileSize;
}

inline void T_MPlayFileListItem::setU64FileSize (uint64 u64FileSize_) {
    set_has_u64FileSize();
    this->_u64FileSize = u64FileSize_;
}

inline void T_MPlayFileListItem::clearSCoverArt() {
    if (hasSCoverArt()) {
         clear_has_sCoverArt();
        _sCoverArt.clear();
     }
}

inline bool T_MPlayFileListItem::hasSCoverArt () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_MPlayFileListItem::getSCoverArt () const {
    return _sCoverArt;
}

inline ::std::string& T_MPlayFileListItem::getSCoverArtMutable () {
    set_has_sCoverArt();
    return _sCoverArt;
}

inline void T_MPlayFileListItem::setSCoverArt (const ::std::string& sCoverArt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCoverArt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCoverArt();
    this->_sCoverArt = sCoverArt_;
}

inline void T_MPlayFileListItem::setSCoverArt (const char* sCoverArt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCoverArt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCoverArt();
    this->_sCoverArt.assign(sCoverArt_);
}

inline void T_MPlayFileListItem::setSCoverArt (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCoverArt();
    this->_sCoverArt.assign(value, size);
}

inline void T_MPlayFileListItem::clearTag() {
    if (hasTag()) {
         clear_has_Tag();
        _Tag = 0u;
     }
}

inline bool T_MPlayFileListItem::hasTag () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint64 T_MPlayFileListItem::getTag () const {
    return _Tag;
}

inline void T_MPlayFileListItem::setTag (uint64 Tag_) {
    set_has_Tag();
    this->_Tag = Tag_;
}

inline void T_MPlayFileListItem::clearParentTag() {
    if (hasParentTag()) {
         clear_has_ParentTag();
        _ParentTag = 0u;
     }
}

inline bool T_MPlayFileListItem::hasParentTag () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint64 T_MPlayFileListItem::getParentTag () const {
    return _ParentTag;
}

inline void T_MPlayFileListItem::setParentTag (uint64 ParentTag_) {
    set_has_ParentTag();
    this->_ParentTag = ParentTag_;
}

inline void T_MPlayFileListItem::set_has_e8FileFormat () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MPlayFileListItem::clear_has_e8FileFormat () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MPlayFileListItem::set_has_e8FileType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MPlayFileListItem::clear_has_e8FileType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MPlayFileListItem::set_has_e8PlayableStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MPlayFileListItem::clear_has_e8PlayableStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MPlayFileListItem::set_has_bIsPlaying () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MPlayFileListItem::clear_has_bIsPlaying () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MPlayFileListItem::set_has_bReadOnlyFlag () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MPlayFileListItem::clear_has_bReadOnlyFlag () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MPlayFileListItem::set_has_sFilename () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MPlayFileListItem::clear_has_sFilename () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_MPlayFileListItem::set_has_u32Tag () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_MPlayFileListItem::clear_has_u32Tag () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_MPlayFileListItem::set_has_u8TrackNumber () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_MPlayFileListItem::clear_has_u8TrackNumber () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_MPlayFileListItem::set_has_sDateTime () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_MPlayFileListItem::clear_has_sDateTime () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_MPlayFileListItem::set_has_u32TotalPlaytime () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_MPlayFileListItem::clear_has_u32TotalPlaytime () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_MPlayFileListItem::set_has_u64FileSize () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_MPlayFileListItem::clear_has_u64FileSize () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_MPlayFileListItem::set_has_sCoverArt () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_MPlayFileListItem::clear_has_sCoverArt () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_MPlayFileListItem::set_has_Tag () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_MPlayFileListItem::clear_has_Tag () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_MPlayFileListItem::set_has_ParentTag () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_MPlayFileListItem::clear_has_ParentTag () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline  T_MPlayImageObjectItem::T_MPlayImageObjectItem ()  :
    _e8FileFormat (::MPlay_fi_types::T_e8_MPlayFileFormat__e8FFT_3G2),
    _e8FileType (::MPlay_fi_types::T_e8_MPlayFileType__e8FT_AUDIO),
    _sDateTime (),
    _sDimension (),
    _sFolderTitle (),
    _sImageFile (),
    _sImageSize (),
    _sImageTitle (),
    _sMountPoint (),
    _sPath (),
    _sResolution (),
    _u32NumberOfImages (0u),
    _u32Tag (0u),
    _u8DeviceTag (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MPlayImageObjectItem::T_MPlayImageObjectItem (const T_MPlayImageObjectItem &rhs)  :
    _e8FileFormat (::MPlay_fi_types::T_e8_MPlayFileFormat__e8FFT_3G2),
    _e8FileType (::MPlay_fi_types::T_e8_MPlayFileType__e8FT_AUDIO),
    _sDateTime (),
    _sDimension (),
    _sFolderTitle (),
    _sImageFile (),
    _sImageSize (),
    _sImageTitle (),
    _sMountPoint (),
    _sPath (),
    _sResolution (),
    _u32NumberOfImages (0u),
    _u32Tag (0u),
    _u8DeviceTag (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MPlayImageObjectItem::T_MPlayImageObjectItem (T_e8_MPlayFileFormat e8FileFormat_, T_e8_MPlayFileType e8FileType_, const ::std::string& sDateTime_, const ::std::string& sDimension_, const ::std::string& sFolderTitle_, const ::std::string& sImageFile_, const ::std::string& sImageSize_, const ::std::string& sImageTitle_, const ::std::string& sMountPoint_, const ::std::string& sPath_, const ::std::string& sResolution_, uint32 u32NumberOfImages_, uint32 u32Tag_, uint8 u8DeviceTag_)  :
    _e8FileFormat (e8FileFormat_),
    _e8FileType (e8FileType_),
    _sDateTime (sDateTime_),
    _sDimension (sDimension_),
    _sFolderTitle (sFolderTitle_),
    _sImageFile (sImageFile_),
    _sImageSize (sImageSize_),
    _sImageTitle (sImageTitle_),
    _sMountPoint (sMountPoint_),
    _sPath (sPath_),
    _sResolution (sResolution_),
    _u32NumberOfImages (u32NumberOfImages_),
    _u32Tag (u32Tag_),
    _u8DeviceTag (u8DeviceTag_)
{
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileFormat_IsValid(e8FileFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileFormat_, "T_e8_MPlayFileFormat", "e8FileFormat", "T_MPlayImageObjectItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileType_IsValid(e8FileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileType_, "T_e8_MPlayFileType", "e8FileType", "T_MPlayImageObjectItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDateTime_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDimension_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFolderTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sImageFile_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sImageSize_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sImageTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPath_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sResolution_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MPlayImageObjectItem::~T_MPlayImageObjectItem() {
}

inline T_MPlayImageObjectItem& T_MPlayImageObjectItem::operator = (const T_MPlayImageObjectItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8FileFormat()) {
            setE8FileFormat(rhs.getE8FileFormat());
        } else {
            clearE8FileFormat();
        }
        if (rhs.hasE8FileType()) {
            setE8FileType(rhs.getE8FileType());
        } else {
            clearE8FileType();
        }
        if (rhs.hasSDateTime()) {
            setSDateTime(rhs.getSDateTime());
        } else {
            clearSDateTime();
        }
        if (rhs.hasSDimension()) {
            setSDimension(rhs.getSDimension());
        } else {
            clearSDimension();
        }
        if (rhs.hasSFolderTitle()) {
            setSFolderTitle(rhs.getSFolderTitle());
        } else {
            clearSFolderTitle();
        }
        if (rhs.hasSImageFile()) {
            setSImageFile(rhs.getSImageFile());
        } else {
            clearSImageFile();
        }
        if (rhs.hasSImageSize()) {
            setSImageSize(rhs.getSImageSize());
        } else {
            clearSImageSize();
        }
        if (rhs.hasSImageTitle()) {
            setSImageTitle(rhs.getSImageTitle());
        } else {
            clearSImageTitle();
        }
        if (rhs.hasSMountPoint()) {
            setSMountPoint(rhs.getSMountPoint());
        } else {
            clearSMountPoint();
        }
        if (rhs.hasSPath()) {
            setSPath(rhs.getSPath());
        } else {
            clearSPath();
        }
        if (rhs.hasSResolution()) {
            setSResolution(rhs.getSResolution());
        } else {
            clearSResolution();
        }
        if (rhs.hasU32NumberOfImages()) {
            setU32NumberOfImages(rhs.getU32NumberOfImages());
        } else {
            clearU32NumberOfImages();
        }
        if (rhs.hasU32Tag()) {
            setU32Tag(rhs.getU32Tag());
        } else {
            clearU32Tag();
        }
        if (rhs.hasU8DeviceTag()) {
            setU8DeviceTag(rhs.getU8DeviceTag());
        } else {
            clearU8DeviceTag();
        }
    }
    return *this;
}

inline bool T_MPlayImageObjectItem::operator == (const T_MPlayImageObjectItem& rhs) const {
    return (((!hasE8FileFormat() && !rhs.hasE8FileFormat()) || getE8FileFormat() == rhs.getE8FileFormat()) &&
        ((!hasE8FileType() && !rhs.hasE8FileType()) || getE8FileType() == rhs.getE8FileType()) &&
        ((!hasSDateTime() && !rhs.hasSDateTime()) || getSDateTime() == rhs.getSDateTime()) &&
        ((!hasSDimension() && !rhs.hasSDimension()) || getSDimension() == rhs.getSDimension()) &&
        ((!hasSFolderTitle() && !rhs.hasSFolderTitle()) || getSFolderTitle() == rhs.getSFolderTitle()) &&
        ((!hasSImageFile() && !rhs.hasSImageFile()) || getSImageFile() == rhs.getSImageFile()) &&
        ((!hasSImageSize() && !rhs.hasSImageSize()) || getSImageSize() == rhs.getSImageSize()) &&
        ((!hasSImageTitle() && !rhs.hasSImageTitle()) || getSImageTitle() == rhs.getSImageTitle()) &&
        ((!hasSMountPoint() && !rhs.hasSMountPoint()) || getSMountPoint() == rhs.getSMountPoint()) &&
        ((!hasSPath() && !rhs.hasSPath()) || getSPath() == rhs.getSPath()) &&
        ((!hasSResolution() && !rhs.hasSResolution()) || getSResolution() == rhs.getSResolution()) &&
        ((!hasU32NumberOfImages() && !rhs.hasU32NumberOfImages()) || getU32NumberOfImages() == rhs.getU32NumberOfImages()) &&
        ((!hasU32Tag() && !rhs.hasU32Tag()) || getU32Tag() == rhs.getU32Tag()) &&
        ((!hasU8DeviceTag() && !rhs.hasU8DeviceTag()) || getU8DeviceTag() == rhs.getU8DeviceTag()));
}

inline bool T_MPlayImageObjectItem::operator != (const T_MPlayImageObjectItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MPlayImageObjectItem::operator < (const T_MPlayImageObjectItem& rhs) const {
    if (hasE8FileFormat() || rhs.hasE8FileFormat()) {
        if ((uint32)getE8FileFormat() < (uint32)rhs.getE8FileFormat()) return true;
        if ((uint32)getE8FileFormat() > (uint32)rhs.getE8FileFormat()) return false;
    }
    if (hasE8FileType() || rhs.hasE8FileType()) {
        if ((uint32)getE8FileType() < (uint32)rhs.getE8FileType()) return true;
        if ((uint32)getE8FileType() > (uint32)rhs.getE8FileType()) return false;
    }
    if (hasSDateTime() || rhs.hasSDateTime()) {
        if (getSDateTime() < rhs.getSDateTime()) return true;
        if (getSDateTime() > rhs.getSDateTime()) return false;
    }
    if (hasSDimension() || rhs.hasSDimension()) {
        if (getSDimension() < rhs.getSDimension()) return true;
        if (getSDimension() > rhs.getSDimension()) return false;
    }
    if (hasSFolderTitle() || rhs.hasSFolderTitle()) {
        if (getSFolderTitle() < rhs.getSFolderTitle()) return true;
        if (getSFolderTitle() > rhs.getSFolderTitle()) return false;
    }
    if (hasSImageFile() || rhs.hasSImageFile()) {
        if (getSImageFile() < rhs.getSImageFile()) return true;
        if (getSImageFile() > rhs.getSImageFile()) return false;
    }
    if (hasSImageSize() || rhs.hasSImageSize()) {
        if (getSImageSize() < rhs.getSImageSize()) return true;
        if (getSImageSize() > rhs.getSImageSize()) return false;
    }
    if (hasSImageTitle() || rhs.hasSImageTitle()) {
        if (getSImageTitle() < rhs.getSImageTitle()) return true;
        if (getSImageTitle() > rhs.getSImageTitle()) return false;
    }
    if (hasSMountPoint() || rhs.hasSMountPoint()) {
        if (getSMountPoint() < rhs.getSMountPoint()) return true;
        if (getSMountPoint() > rhs.getSMountPoint()) return false;
    }
    if (hasSPath() || rhs.hasSPath()) {
        if (getSPath() < rhs.getSPath()) return true;
        if (getSPath() > rhs.getSPath()) return false;
    }
    if (hasSResolution() || rhs.hasSResolution()) {
        if (getSResolution() < rhs.getSResolution()) return true;
        if (getSResolution() > rhs.getSResolution()) return false;
    }
    if (hasU32NumberOfImages() || rhs.hasU32NumberOfImages()) {
        if (getU32NumberOfImages() < rhs.getU32NumberOfImages()) return true;
        if (getU32NumberOfImages() > rhs.getU32NumberOfImages()) return false;
    }
    if (hasU32Tag() || rhs.hasU32Tag()) {
        if (getU32Tag() < rhs.getU32Tag()) return true;
        if (getU32Tag() > rhs.getU32Tag()) return false;
    }
    if (hasU8DeviceTag() || rhs.hasU8DeviceTag()) {
        if (getU8DeviceTag() < rhs.getU8DeviceTag()) return true;
        if (getU8DeviceTag() > rhs.getU8DeviceTag()) return false;
    }
    return false;
}

inline bool T_MPlayImageObjectItem::operator > (const T_MPlayImageObjectItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MPlayImageObjectItem::clear() {
    clearE8FileFormat();
    clearE8FileType();
    clearSDateTime();
    clearSDimension();
    clearSFolderTitle();
    clearSImageFile();
    clearSImageSize();
    clearSImageTitle();
    clearSMountPoint();
    clearSPath();
    clearSResolution();
    clearU32NumberOfImages();
    clearU32Tag();
    clearU8DeviceTag();
}

inline void T_MPlayImageObjectItem::clearE8FileFormat() {
    if (hasE8FileFormat()) {
         clear_has_e8FileFormat();
        _e8FileFormat = ::MPlay_fi_types::T_e8_MPlayFileFormat__e8FFT_3G2;
     }
}

inline bool T_MPlayImageObjectItem::hasE8FileFormat () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_MPlayFileFormat T_MPlayImageObjectItem::getE8FileFormat () const {
    return _e8FileFormat;
}

inline void T_MPlayImageObjectItem::setE8FileFormat (T_e8_MPlayFileFormat e8FileFormat_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileFormat_IsValid(e8FileFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileFormat_, "T_e8_MPlayFileFormat", "e8FileFormat", "T_MPlayImageObjectItem");
    }
    #endif
    set_has_e8FileFormat();
    this->_e8FileFormat = e8FileFormat_;
}

inline void T_MPlayImageObjectItem::clearE8FileType() {
    if (hasE8FileType()) {
         clear_has_e8FileType();
        _e8FileType = ::MPlay_fi_types::T_e8_MPlayFileType__e8FT_AUDIO;
     }
}

inline bool T_MPlayImageObjectItem::hasE8FileType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_MPlayFileType T_MPlayImageObjectItem::getE8FileType () const {
    return _e8FileType;
}

inline void T_MPlayImageObjectItem::setE8FileType (T_e8_MPlayFileType e8FileType_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileType_IsValid(e8FileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileType_, "T_e8_MPlayFileType", "e8FileType", "T_MPlayImageObjectItem");
    }
    #endif
    set_has_e8FileType();
    this->_e8FileType = e8FileType_;
}

inline void T_MPlayImageObjectItem::clearSDateTime() {
    if (hasSDateTime()) {
         clear_has_sDateTime();
        _sDateTime.clear();
     }
}

inline bool T_MPlayImageObjectItem::hasSDateTime () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_MPlayImageObjectItem::getSDateTime () const {
    return _sDateTime;
}

inline ::std::string& T_MPlayImageObjectItem::getSDateTimeMutable () {
    set_has_sDateTime();
    return _sDateTime;
}

inline void T_MPlayImageObjectItem::setSDateTime (const ::std::string& sDateTime_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDateTime_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDateTime();
    this->_sDateTime = sDateTime_;
}

inline void T_MPlayImageObjectItem::setSDateTime (const char* sDateTime_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDateTime_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDateTime();
    this->_sDateTime.assign(sDateTime_);
}

inline void T_MPlayImageObjectItem::setSDateTime (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDateTime();
    this->_sDateTime.assign(value, size);
}

inline void T_MPlayImageObjectItem::clearSDimension() {
    if (hasSDimension()) {
         clear_has_sDimension();
        _sDimension.clear();
     }
}

inline bool T_MPlayImageObjectItem::hasSDimension () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_MPlayImageObjectItem::getSDimension () const {
    return _sDimension;
}

inline ::std::string& T_MPlayImageObjectItem::getSDimensionMutable () {
    set_has_sDimension();
    return _sDimension;
}

inline void T_MPlayImageObjectItem::setSDimension (const ::std::string& sDimension_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDimension_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDimension();
    this->_sDimension = sDimension_;
}

inline void T_MPlayImageObjectItem::setSDimension (const char* sDimension_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDimension_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDimension();
    this->_sDimension.assign(sDimension_);
}

inline void T_MPlayImageObjectItem::setSDimension (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDimension();
    this->_sDimension.assign(value, size);
}

inline void T_MPlayImageObjectItem::clearSFolderTitle() {
    if (hasSFolderTitle()) {
         clear_has_sFolderTitle();
        _sFolderTitle.clear();
     }
}

inline bool T_MPlayImageObjectItem::hasSFolderTitle () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_MPlayImageObjectItem::getSFolderTitle () const {
    return _sFolderTitle;
}

inline ::std::string& T_MPlayImageObjectItem::getSFolderTitleMutable () {
    set_has_sFolderTitle();
    return _sFolderTitle;
}

inline void T_MPlayImageObjectItem::setSFolderTitle (const ::std::string& sFolderTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFolderTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFolderTitle();
    this->_sFolderTitle = sFolderTitle_;
}

inline void T_MPlayImageObjectItem::setSFolderTitle (const char* sFolderTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFolderTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFolderTitle();
    this->_sFolderTitle.assign(sFolderTitle_);
}

inline void T_MPlayImageObjectItem::setSFolderTitle (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFolderTitle();
    this->_sFolderTitle.assign(value, size);
}

inline void T_MPlayImageObjectItem::clearSImageFile() {
    if (hasSImageFile()) {
         clear_has_sImageFile();
        _sImageFile.clear();
     }
}

inline bool T_MPlayImageObjectItem::hasSImageFile () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_MPlayImageObjectItem::getSImageFile () const {
    return _sImageFile;
}

inline ::std::string& T_MPlayImageObjectItem::getSImageFileMutable () {
    set_has_sImageFile();
    return _sImageFile;
}

inline void T_MPlayImageObjectItem::setSImageFile (const ::std::string& sImageFile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sImageFile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sImageFile();
    this->_sImageFile = sImageFile_;
}

inline void T_MPlayImageObjectItem::setSImageFile (const char* sImageFile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sImageFile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sImageFile();
    this->_sImageFile.assign(sImageFile_);
}

inline void T_MPlayImageObjectItem::setSImageFile (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sImageFile();
    this->_sImageFile.assign(value, size);
}

inline void T_MPlayImageObjectItem::clearSImageSize() {
    if (hasSImageSize()) {
         clear_has_sImageSize();
        _sImageSize.clear();
     }
}

inline bool T_MPlayImageObjectItem::hasSImageSize () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_MPlayImageObjectItem::getSImageSize () const {
    return _sImageSize;
}

inline ::std::string& T_MPlayImageObjectItem::getSImageSizeMutable () {
    set_has_sImageSize();
    return _sImageSize;
}

inline void T_MPlayImageObjectItem::setSImageSize (const ::std::string& sImageSize_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sImageSize_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sImageSize();
    this->_sImageSize = sImageSize_;
}

inline void T_MPlayImageObjectItem::setSImageSize (const char* sImageSize_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sImageSize_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sImageSize();
    this->_sImageSize.assign(sImageSize_);
}

inline void T_MPlayImageObjectItem::setSImageSize (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sImageSize();
    this->_sImageSize.assign(value, size);
}

inline void T_MPlayImageObjectItem::clearSImageTitle() {
    if (hasSImageTitle()) {
         clear_has_sImageTitle();
        _sImageTitle.clear();
     }
}

inline bool T_MPlayImageObjectItem::hasSImageTitle () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_MPlayImageObjectItem::getSImageTitle () const {
    return _sImageTitle;
}

inline ::std::string& T_MPlayImageObjectItem::getSImageTitleMutable () {
    set_has_sImageTitle();
    return _sImageTitle;
}

inline void T_MPlayImageObjectItem::setSImageTitle (const ::std::string& sImageTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sImageTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sImageTitle();
    this->_sImageTitle = sImageTitle_;
}

inline void T_MPlayImageObjectItem::setSImageTitle (const char* sImageTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sImageTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sImageTitle();
    this->_sImageTitle.assign(sImageTitle_);
}

inline void T_MPlayImageObjectItem::setSImageTitle (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sImageTitle();
    this->_sImageTitle.assign(value, size);
}

inline void T_MPlayImageObjectItem::clearSMountPoint() {
    if (hasSMountPoint()) {
         clear_has_sMountPoint();
        _sMountPoint.clear();
     }
}

inline bool T_MPlayImageObjectItem::hasSMountPoint () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_MPlayImageObjectItem::getSMountPoint () const {
    return _sMountPoint;
}

inline ::std::string& T_MPlayImageObjectItem::getSMountPointMutable () {
    set_has_sMountPoint();
    return _sMountPoint;
}

inline void T_MPlayImageObjectItem::setSMountPoint (const ::std::string& sMountPoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMountPoint();
    this->_sMountPoint = sMountPoint_;
}

inline void T_MPlayImageObjectItem::setSMountPoint (const char* sMountPoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMountPoint();
    this->_sMountPoint.assign(sMountPoint_);
}

inline void T_MPlayImageObjectItem::setSMountPoint (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMountPoint();
    this->_sMountPoint.assign(value, size);
}

inline void T_MPlayImageObjectItem::clearSPath() {
    if (hasSPath()) {
         clear_has_sPath();
        _sPath.clear();
     }
}

inline bool T_MPlayImageObjectItem::hasSPath () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_MPlayImageObjectItem::getSPath () const {
    return _sPath;
}

inline ::std::string& T_MPlayImageObjectItem::getSPathMutable () {
    set_has_sPath();
    return _sPath;
}

inline void T_MPlayImageObjectItem::setSPath (const ::std::string& sPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPath();
    this->_sPath = sPath_;
}

inline void T_MPlayImageObjectItem::setSPath (const char* sPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPath();
    this->_sPath.assign(sPath_);
}

inline void T_MPlayImageObjectItem::setSPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPath();
    this->_sPath.assign(value, size);
}

inline void T_MPlayImageObjectItem::clearSResolution() {
    if (hasSResolution()) {
         clear_has_sResolution();
        _sResolution.clear();
     }
}

inline bool T_MPlayImageObjectItem::hasSResolution () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_MPlayImageObjectItem::getSResolution () const {
    return _sResolution;
}

inline ::std::string& T_MPlayImageObjectItem::getSResolutionMutable () {
    set_has_sResolution();
    return _sResolution;
}

inline void T_MPlayImageObjectItem::setSResolution (const ::std::string& sResolution_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sResolution_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sResolution();
    this->_sResolution = sResolution_;
}

inline void T_MPlayImageObjectItem::setSResolution (const char* sResolution_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sResolution_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sResolution();
    this->_sResolution.assign(sResolution_);
}

inline void T_MPlayImageObjectItem::setSResolution (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sResolution();
    this->_sResolution.assign(value, size);
}

inline void T_MPlayImageObjectItem::clearU32NumberOfImages() {
    if (hasU32NumberOfImages()) {
         clear_has_u32NumberOfImages();
        _u32NumberOfImages = 0u;
     }
}

inline bool T_MPlayImageObjectItem::hasU32NumberOfImages () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint32 T_MPlayImageObjectItem::getU32NumberOfImages () const {
    return _u32NumberOfImages;
}

inline void T_MPlayImageObjectItem::setU32NumberOfImages (uint32 u32NumberOfImages_) {
    set_has_u32NumberOfImages();
    this->_u32NumberOfImages = u32NumberOfImages_;
}

inline void T_MPlayImageObjectItem::clearU32Tag() {
    if (hasU32Tag()) {
         clear_has_u32Tag();
        _u32Tag = 0u;
     }
}

inline bool T_MPlayImageObjectItem::hasU32Tag () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint32 T_MPlayImageObjectItem::getU32Tag () const {
    return _u32Tag;
}

inline void T_MPlayImageObjectItem::setU32Tag (uint32 u32Tag_) {
    set_has_u32Tag();
    this->_u32Tag = u32Tag_;
}

inline void T_MPlayImageObjectItem::clearU8DeviceTag() {
    if (hasU8DeviceTag()) {
         clear_has_u8DeviceTag();
        _u8DeviceTag = 0u;
     }
}

inline bool T_MPlayImageObjectItem::hasU8DeviceTag () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint8 T_MPlayImageObjectItem::getU8DeviceTag () const {
    return _u8DeviceTag;
}

inline void T_MPlayImageObjectItem::setU8DeviceTag (uint8 u8DeviceTag_) {
    set_has_u8DeviceTag();
    this->_u8DeviceTag = u8DeviceTag_;
}

inline void T_MPlayImageObjectItem::set_has_e8FileFormat () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MPlayImageObjectItem::clear_has_e8FileFormat () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MPlayImageObjectItem::set_has_e8FileType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MPlayImageObjectItem::clear_has_e8FileType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MPlayImageObjectItem::set_has_sDateTime () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MPlayImageObjectItem::clear_has_sDateTime () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MPlayImageObjectItem::set_has_sDimension () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MPlayImageObjectItem::clear_has_sDimension () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MPlayImageObjectItem::set_has_sFolderTitle () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MPlayImageObjectItem::clear_has_sFolderTitle () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MPlayImageObjectItem::set_has_sImageFile () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MPlayImageObjectItem::clear_has_sImageFile () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_MPlayImageObjectItem::set_has_sImageSize () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_MPlayImageObjectItem::clear_has_sImageSize () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_MPlayImageObjectItem::set_has_sImageTitle () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_MPlayImageObjectItem::clear_has_sImageTitle () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_MPlayImageObjectItem::set_has_sMountPoint () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_MPlayImageObjectItem::clear_has_sMountPoint () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_MPlayImageObjectItem::set_has_sPath () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_MPlayImageObjectItem::clear_has_sPath () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_MPlayImageObjectItem::set_has_sResolution () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_MPlayImageObjectItem::clear_has_sResolution () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_MPlayImageObjectItem::set_has_u32NumberOfImages () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_MPlayImageObjectItem::clear_has_u32NumberOfImages () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_MPlayImageObjectItem::set_has_u32Tag () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_MPlayImageObjectItem::clear_has_u32Tag () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_MPlayImageObjectItem::set_has_u8DeviceTag () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_MPlayImageObjectItem::clear_has_u8DeviceTag () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline  T_MPlayIndexingStateResultItem::T_MPlayIndexingStateResultItem ()  :
    _e8DeviceIndexedState (::MPlay_fi_types::T_e8_MPlayDeviceIndexedState__e8IDS_COMPLETE),
    _u8DeviceTag (0u),
    _u8IndexingPercentComplete (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MPlayIndexingStateResultItem::T_MPlayIndexingStateResultItem (const T_MPlayIndexingStateResultItem &rhs)  :
    _e8DeviceIndexedState (::MPlay_fi_types::T_e8_MPlayDeviceIndexedState__e8IDS_COMPLETE),
    _u8DeviceTag (0u),
    _u8IndexingPercentComplete (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MPlayIndexingStateResultItem::T_MPlayIndexingStateResultItem (T_e8_MPlayDeviceIndexedState e8DeviceIndexedState_, uint8 u8DeviceTag_, uint8 u8IndexingPercentComplete_)  :
    _e8DeviceIndexedState (e8DeviceIndexedState_),
    _u8DeviceTag (u8DeviceTag_),
    _u8IndexingPercentComplete (u8IndexingPercentComplete_)
{
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceIndexedState_IsValid(e8DeviceIndexedState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceIndexedState_, "T_e8_MPlayDeviceIndexedState", "e8DeviceIndexedState", "T_MPlayIndexingStateResultItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MPlayIndexingStateResultItem::~T_MPlayIndexingStateResultItem() {
}

inline T_MPlayIndexingStateResultItem& T_MPlayIndexingStateResultItem::operator = (const T_MPlayIndexingStateResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8DeviceIndexedState()) {
            setE8DeviceIndexedState(rhs.getE8DeviceIndexedState());
        } else {
            clearE8DeviceIndexedState();
        }
        if (rhs.hasU8DeviceTag()) {
            setU8DeviceTag(rhs.getU8DeviceTag());
        } else {
            clearU8DeviceTag();
        }
        if (rhs.hasU8IndexingPercentComplete()) {
            setU8IndexingPercentComplete(rhs.getU8IndexingPercentComplete());
        } else {
            clearU8IndexingPercentComplete();
        }
    }
    return *this;
}

inline bool T_MPlayIndexingStateResultItem::operator == (const T_MPlayIndexingStateResultItem& rhs) const {
    return (((!hasE8DeviceIndexedState() && !rhs.hasE8DeviceIndexedState()) || getE8DeviceIndexedState() == rhs.getE8DeviceIndexedState()) &&
        ((!hasU8DeviceTag() && !rhs.hasU8DeviceTag()) || getU8DeviceTag() == rhs.getU8DeviceTag()) &&
        ((!hasU8IndexingPercentComplete() && !rhs.hasU8IndexingPercentComplete()) || getU8IndexingPercentComplete() == rhs.getU8IndexingPercentComplete()));
}

inline bool T_MPlayIndexingStateResultItem::operator != (const T_MPlayIndexingStateResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MPlayIndexingStateResultItem::operator < (const T_MPlayIndexingStateResultItem& rhs) const {
    if (hasE8DeviceIndexedState() || rhs.hasE8DeviceIndexedState()) {
        if ((uint32)getE8DeviceIndexedState() < (uint32)rhs.getE8DeviceIndexedState()) return true;
        if ((uint32)getE8DeviceIndexedState() > (uint32)rhs.getE8DeviceIndexedState()) return false;
    }
    if (hasU8DeviceTag() || rhs.hasU8DeviceTag()) {
        if (getU8DeviceTag() < rhs.getU8DeviceTag()) return true;
        if (getU8DeviceTag() > rhs.getU8DeviceTag()) return false;
    }
    if (hasU8IndexingPercentComplete() || rhs.hasU8IndexingPercentComplete()) {
        if (getU8IndexingPercentComplete() < rhs.getU8IndexingPercentComplete()) return true;
        if (getU8IndexingPercentComplete() > rhs.getU8IndexingPercentComplete()) return false;
    }
    return false;
}

inline bool T_MPlayIndexingStateResultItem::operator > (const T_MPlayIndexingStateResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MPlayIndexingStateResultItem::clear() {
    clearE8DeviceIndexedState();
    clearU8DeviceTag();
    clearU8IndexingPercentComplete();
}

inline void T_MPlayIndexingStateResultItem::clearE8DeviceIndexedState() {
    if (hasE8DeviceIndexedState()) {
         clear_has_e8DeviceIndexedState();
        _e8DeviceIndexedState = ::MPlay_fi_types::T_e8_MPlayDeviceIndexedState__e8IDS_COMPLETE;
     }
}

inline bool T_MPlayIndexingStateResultItem::hasE8DeviceIndexedState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_MPlayDeviceIndexedState T_MPlayIndexingStateResultItem::getE8DeviceIndexedState () const {
    return _e8DeviceIndexedState;
}

inline void T_MPlayIndexingStateResultItem::setE8DeviceIndexedState (T_e8_MPlayDeviceIndexedState e8DeviceIndexedState_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceIndexedState_IsValid(e8DeviceIndexedState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceIndexedState_, "T_e8_MPlayDeviceIndexedState", "e8DeviceIndexedState", "T_MPlayIndexingStateResultItem");
    }
    #endif
    set_has_e8DeviceIndexedState();
    this->_e8DeviceIndexedState = e8DeviceIndexedState_;
}

inline void T_MPlayIndexingStateResultItem::clearU8DeviceTag() {
    if (hasU8DeviceTag()) {
         clear_has_u8DeviceTag();
        _u8DeviceTag = 0u;
     }
}

inline bool T_MPlayIndexingStateResultItem::hasU8DeviceTag () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_MPlayIndexingStateResultItem::getU8DeviceTag () const {
    return _u8DeviceTag;
}

inline void T_MPlayIndexingStateResultItem::setU8DeviceTag (uint8 u8DeviceTag_) {
    set_has_u8DeviceTag();
    this->_u8DeviceTag = u8DeviceTag_;
}

inline void T_MPlayIndexingStateResultItem::clearU8IndexingPercentComplete() {
    if (hasU8IndexingPercentComplete()) {
         clear_has_u8IndexingPercentComplete();
        _u8IndexingPercentComplete = 0u;
     }
}

inline bool T_MPlayIndexingStateResultItem::hasU8IndexingPercentComplete () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_MPlayIndexingStateResultItem::getU8IndexingPercentComplete () const {
    return _u8IndexingPercentComplete;
}

inline void T_MPlayIndexingStateResultItem::setU8IndexingPercentComplete (uint8 u8IndexingPercentComplete_) {
    set_has_u8IndexingPercentComplete();
    this->_u8IndexingPercentComplete = u8IndexingPercentComplete_;
}

inline void T_MPlayIndexingStateResultItem::set_has_e8DeviceIndexedState () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MPlayIndexingStateResultItem::clear_has_e8DeviceIndexedState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MPlayIndexingStateResultItem::set_has_u8DeviceTag () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MPlayIndexingStateResultItem::clear_has_u8DeviceTag () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MPlayIndexingStateResultItem::set_has_u8IndexingPercentComplete () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MPlayIndexingStateResultItem::clear_has_u8IndexingPercentComplete () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_MPlayMediaObject::T_MPlayMediaObject ()  :
    _e8AudioChannelFormat (::MPlay_fi_types::T_e8_MPlayAudioChannelFormat__e8ACF_MONO),
    _e8CategoryType (::MPlay_fi_types::T_e8_MPlayCategoryType__e8CTY_ALBUM),
    _e8DeviceType (::MPlay_fi_types::T_e8_MPlayDeviceType__e8DTY_BLUETOOTH),
    _e8FileFormat (::MPlay_fi_types::T_e8_MPlayFileFormat__e8FFT_3G2),
    _e8MediaType (::MPlay_fi_types::T_e8_MPlayMediaType__e8MRY_AUDIO_STREAM),
    _e8PlayableStatus (::MPlay_fi_types::T_e8_MPlayPlayableStatus__e8FP_DRM_PROTECTED),
    _bIsPlaying (false),
    _bVBR (false),
    _sAlbumArt (),
    _sDateTime (),
    _sDeviceVersion (),
    _sFilename (),
    _sMetaDataField1 (),
    _sMetaDataField2 (),
    _sMetaDataField3 (),
    _sMetaDataField4 (),
    _sYomiMetaDataTitle (),
    _sYomiMetaDataArtist (),
    _sYomiMetaDataAlbum (),
    _sResolution (),
    _u16ExtendedTrackNumber (0u),
    _u32BitRate (0u),
    _u32MetaDataTag1 (0u),
    _u32MetaDataTag2 (0u),
    _u32MetaDataTag3 (0u),
    _u32MetaDataTag4 (0u),
    _u32SampleRate (0u),
    _u32Tag (0u),
    _u32TotalPlaytime (0u),
    _u32Year (0u),
    _u32YearID (0u),
    _u64FileSize (0u),
    _u8DeviceTag (0u),
    _u8TrackNumber (0u),
    _bIsFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MPlayMediaObject::T_MPlayMediaObject (const T_MPlayMediaObject &rhs)  :
    _e8AudioChannelFormat (::MPlay_fi_types::T_e8_MPlayAudioChannelFormat__e8ACF_MONO),
    _e8CategoryType (::MPlay_fi_types::T_e8_MPlayCategoryType__e8CTY_ALBUM),
    _e8DeviceType (::MPlay_fi_types::T_e8_MPlayDeviceType__e8DTY_BLUETOOTH),
    _e8FileFormat (::MPlay_fi_types::T_e8_MPlayFileFormat__e8FFT_3G2),
    _e8MediaType (::MPlay_fi_types::T_e8_MPlayMediaType__e8MRY_AUDIO_STREAM),
    _e8PlayableStatus (::MPlay_fi_types::T_e8_MPlayPlayableStatus__e8FP_DRM_PROTECTED),
    _bIsPlaying (false),
    _bVBR (false),
    _sAlbumArt (),
    _sDateTime (),
    _sDeviceVersion (),
    _sFilename (),
    _sMetaDataField1 (),
    _sMetaDataField2 (),
    _sMetaDataField3 (),
    _sMetaDataField4 (),
    _sYomiMetaDataTitle (),
    _sYomiMetaDataArtist (),
    _sYomiMetaDataAlbum (),
    _sResolution (),
    _u16ExtendedTrackNumber (0u),
    _u32BitRate (0u),
    _u32MetaDataTag1 (0u),
    _u32MetaDataTag2 (0u),
    _u32MetaDataTag3 (0u),
    _u32MetaDataTag4 (0u),
    _u32SampleRate (0u),
    _u32Tag (0u),
    _u32TotalPlaytime (0u),
    _u32Year (0u),
    _u32YearID (0u),
    _u64FileSize (0u),
    _u8DeviceTag (0u),
    _u8TrackNumber (0u),
    _bIsFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MPlayMediaObject::T_MPlayMediaObject (T_e8_MPlayAudioChannelFormat e8AudioChannelFormat_, T_e8_MPlayCategoryType e8CategoryType_, T_e8_MPlayDeviceType e8DeviceType_, T_e8_MPlayFileFormat e8FileFormat_, T_e8_MPlayMediaType e8MediaType_, T_e8_MPlayPlayableStatus e8PlayableStatus_, bool bIsPlaying_, bool bVBR_, const ::std::string& sAlbumArt_, const ::std::string& sDateTime_, const ::std::string& sDeviceVersion_, const ::std::string& sFilename_, const ::std::string& sMetaDataField1_, const ::std::string& sMetaDataField2_, const ::std::string& sMetaDataField3_, const ::std::string& sMetaDataField4_, const ::std::string& sYomiMetaDataTitle_, const ::std::string& sYomiMetaDataArtist_, const ::std::string& sYomiMetaDataAlbum_, const ::std::string& sResolution_, uint16 u16ExtendedTrackNumber_, uint32 u32BitRate_, uint32 u32MetaDataTag1_, uint32 u32MetaDataTag2_, uint32 u32MetaDataTag3_, uint32 u32MetaDataTag4_, uint32 u32SampleRate_, uint32 u32Tag_, uint32 u32TotalPlaytime_, uint32 u32Year_, uint32 u32YearID_, uint64 u64FileSize_, uint8 u8DeviceTag_, uint8 u8TrackNumber_, bool bIsFavorite_)  :
    _e8AudioChannelFormat (e8AudioChannelFormat_),
    _e8CategoryType (e8CategoryType_),
    _e8DeviceType (e8DeviceType_),
    _e8FileFormat (e8FileFormat_),
    _e8MediaType (e8MediaType_),
    _e8PlayableStatus (e8PlayableStatus_),
    _bIsPlaying (bIsPlaying_),
    _bVBR (bVBR_),
    _sAlbumArt (sAlbumArt_),
    _sDateTime (sDateTime_),
    _sDeviceVersion (sDeviceVersion_),
    _sFilename (sFilename_),
    _sMetaDataField1 (sMetaDataField1_),
    _sMetaDataField2 (sMetaDataField2_),
    _sMetaDataField3 (sMetaDataField3_),
    _sMetaDataField4 (sMetaDataField4_),
    _sYomiMetaDataTitle (sYomiMetaDataTitle_),
    _sYomiMetaDataArtist (sYomiMetaDataArtist_),
    _sYomiMetaDataAlbum (sYomiMetaDataAlbum_),
    _sResolution (sResolution_),
    _u16ExtendedTrackNumber (u16ExtendedTrackNumber_),
    _u32BitRate (u32BitRate_),
    _u32MetaDataTag1 (u32MetaDataTag1_),
    _u32MetaDataTag2 (u32MetaDataTag2_),
    _u32MetaDataTag3 (u32MetaDataTag3_),
    _u32MetaDataTag4 (u32MetaDataTag4_),
    _u32SampleRate (u32SampleRate_),
    _u32Tag (u32Tag_),
    _u32TotalPlaytime (u32TotalPlaytime_),
    _u32Year (u32Year_),
    _u32YearID (u32YearID_),
    _u64FileSize (u64FileSize_),
    _u8DeviceTag (u8DeviceTag_),
    _u8TrackNumber (u8TrackNumber_),
    _bIsFavorite (bIsFavorite_)
{
    #ifndef NDEBUG
    if (!(T_e8_MPlayAudioChannelFormat_IsValid(e8AudioChannelFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AudioChannelFormat_, "T_e8_MPlayAudioChannelFormat", "e8AudioChannelFormat", "T_MPlayMediaObject");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayCategoryType_IsValid(e8CategoryType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CategoryType_, "T_e8_MPlayCategoryType", "e8CategoryType", "T_MPlayMediaObject");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceType_IsValid(e8DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceType_, "T_e8_MPlayDeviceType", "e8DeviceType", "T_MPlayMediaObject");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileFormat_IsValid(e8FileFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileFormat_, "T_e8_MPlayFileFormat", "e8FileFormat", "T_MPlayMediaObject");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayMediaType_IsValid(e8MediaType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MediaType_, "T_e8_MPlayMediaType", "e8MediaType", "T_MPlayMediaObject");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayPlayableStatus_IsValid(e8PlayableStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PlayableStatus_, "T_e8_MPlayPlayableStatus", "e8PlayableStatus", "T_MPlayMediaObject");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbumArt_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDateTime_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFilename_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField2_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField3_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField4_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataArtist_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sResolution_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MPlayMediaObject::~T_MPlayMediaObject() {
}

inline T_MPlayMediaObject& T_MPlayMediaObject::operator = (const T_MPlayMediaObject& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8AudioChannelFormat()) {
            setE8AudioChannelFormat(rhs.getE8AudioChannelFormat());
        } else {
            clearE8AudioChannelFormat();
        }
        if (rhs.hasE8CategoryType()) {
            setE8CategoryType(rhs.getE8CategoryType());
        } else {
            clearE8CategoryType();
        }
        if (rhs.hasE8DeviceType()) {
            setE8DeviceType(rhs.getE8DeviceType());
        } else {
            clearE8DeviceType();
        }
        if (rhs.hasE8FileFormat()) {
            setE8FileFormat(rhs.getE8FileFormat());
        } else {
            clearE8FileFormat();
        }
        if (rhs.hasE8MediaType()) {
            setE8MediaType(rhs.getE8MediaType());
        } else {
            clearE8MediaType();
        }
        if (rhs.hasE8PlayableStatus()) {
            setE8PlayableStatus(rhs.getE8PlayableStatus());
        } else {
            clearE8PlayableStatus();
        }
        if (rhs.hasBIsPlaying()) {
            setBIsPlaying(rhs.getBIsPlaying());
        } else {
            clearBIsPlaying();
        }
        if (rhs.hasBVBR()) {
            setBVBR(rhs.getBVBR());
        } else {
            clearBVBR();
        }
        if (rhs.hasSAlbumArt()) {
            setSAlbumArt(rhs.getSAlbumArt());
        } else {
            clearSAlbumArt();
        }
        if (rhs.hasSDateTime()) {
            setSDateTime(rhs.getSDateTime());
        } else {
            clearSDateTime();
        }
        if (rhs.hasSDeviceVersion()) {
            setSDeviceVersion(rhs.getSDeviceVersion());
        } else {
            clearSDeviceVersion();
        }
        if (rhs.hasSFilename()) {
            setSFilename(rhs.getSFilename());
        } else {
            clearSFilename();
        }
        if (rhs.hasSMetaDataField1()) {
            setSMetaDataField1(rhs.getSMetaDataField1());
        } else {
            clearSMetaDataField1();
        }
        if (rhs.hasSMetaDataField2()) {
            setSMetaDataField2(rhs.getSMetaDataField2());
        } else {
            clearSMetaDataField2();
        }
        if (rhs.hasSMetaDataField3()) {
            setSMetaDataField3(rhs.getSMetaDataField3());
        } else {
            clearSMetaDataField3();
        }
        if (rhs.hasSMetaDataField4()) {
            setSMetaDataField4(rhs.getSMetaDataField4());
        } else {
            clearSMetaDataField4();
        }
        if (rhs.hasSYomiMetaDataTitle()) {
            setSYomiMetaDataTitle(rhs.getSYomiMetaDataTitle());
        } else {
            clearSYomiMetaDataTitle();
        }
        if (rhs.hasSYomiMetaDataArtist()) {
            setSYomiMetaDataArtist(rhs.getSYomiMetaDataArtist());
        } else {
            clearSYomiMetaDataArtist();
        }
        if (rhs.hasSYomiMetaDataAlbum()) {
            setSYomiMetaDataAlbum(rhs.getSYomiMetaDataAlbum());
        } else {
            clearSYomiMetaDataAlbum();
        }
        if (rhs.hasSResolution()) {
            setSResolution(rhs.getSResolution());
        } else {
            clearSResolution();
        }
        if (rhs.hasU16ExtendedTrackNumber()) {
            setU16ExtendedTrackNumber(rhs.getU16ExtendedTrackNumber());
        } else {
            clearU16ExtendedTrackNumber();
        }
        if (rhs.hasU32BitRate()) {
            setU32BitRate(rhs.getU32BitRate());
        } else {
            clearU32BitRate();
        }
        if (rhs.hasU32MetaDataTag1()) {
            setU32MetaDataTag1(rhs.getU32MetaDataTag1());
        } else {
            clearU32MetaDataTag1();
        }
        if (rhs.hasU32MetaDataTag2()) {
            setU32MetaDataTag2(rhs.getU32MetaDataTag2());
        } else {
            clearU32MetaDataTag2();
        }
        if (rhs.hasU32MetaDataTag3()) {
            setU32MetaDataTag3(rhs.getU32MetaDataTag3());
        } else {
            clearU32MetaDataTag3();
        }
        if (rhs.hasU32MetaDataTag4()) {
            setU32MetaDataTag4(rhs.getU32MetaDataTag4());
        } else {
            clearU32MetaDataTag4();
        }
        if (rhs.hasU32SampleRate()) {
            setU32SampleRate(rhs.getU32SampleRate());
        } else {
            clearU32SampleRate();
        }
        if (rhs.hasU32Tag()) {
            setU32Tag(rhs.getU32Tag());
        } else {
            clearU32Tag();
        }
        if (rhs.hasU32TotalPlaytime()) {
            setU32TotalPlaytime(rhs.getU32TotalPlaytime());
        } else {
            clearU32TotalPlaytime();
        }
        if (rhs.hasU32Year()) {
            setU32Year(rhs.getU32Year());
        } else {
            clearU32Year();
        }
        if (rhs.hasU32YearID()) {
            setU32YearID(rhs.getU32YearID());
        } else {
            clearU32YearID();
        }
        if (rhs.hasU64FileSize()) {
            setU64FileSize(rhs.getU64FileSize());
        } else {
            clearU64FileSize();
        }
        if (rhs.hasU8DeviceTag()) {
            setU8DeviceTag(rhs.getU8DeviceTag());
        } else {
            clearU8DeviceTag();
        }
        if (rhs.hasU8TrackNumber()) {
            setU8TrackNumber(rhs.getU8TrackNumber());
        } else {
            clearU8TrackNumber();
        }
        if (rhs.hasBIsFavorite()) {
            setBIsFavorite(rhs.getBIsFavorite());
        } else {
            clearBIsFavorite();
        }
    }
    return *this;
}

inline bool T_MPlayMediaObject::operator == (const T_MPlayMediaObject& rhs) const {
    return (((!hasE8AudioChannelFormat() && !rhs.hasE8AudioChannelFormat()) || getE8AudioChannelFormat() == rhs.getE8AudioChannelFormat()) &&
        ((!hasE8CategoryType() && !rhs.hasE8CategoryType()) || getE8CategoryType() == rhs.getE8CategoryType()) &&
        ((!hasE8DeviceType() && !rhs.hasE8DeviceType()) || getE8DeviceType() == rhs.getE8DeviceType()) &&
        ((!hasE8FileFormat() && !rhs.hasE8FileFormat()) || getE8FileFormat() == rhs.getE8FileFormat()) &&
        ((!hasE8MediaType() && !rhs.hasE8MediaType()) || getE8MediaType() == rhs.getE8MediaType()) &&
        ((!hasE8PlayableStatus() && !rhs.hasE8PlayableStatus()) || getE8PlayableStatus() == rhs.getE8PlayableStatus()) &&
        ((!hasBIsPlaying() && !rhs.hasBIsPlaying()) || getBIsPlaying() == rhs.getBIsPlaying()) &&
        ((!hasBVBR() && !rhs.hasBVBR()) || getBVBR() == rhs.getBVBR()) &&
        ((!hasSAlbumArt() && !rhs.hasSAlbumArt()) || getSAlbumArt() == rhs.getSAlbumArt()) &&
        ((!hasSDateTime() && !rhs.hasSDateTime()) || getSDateTime() == rhs.getSDateTime()) &&
        ((!hasSDeviceVersion() && !rhs.hasSDeviceVersion()) || getSDeviceVersion() == rhs.getSDeviceVersion()) &&
        ((!hasSFilename() && !rhs.hasSFilename()) || getSFilename() == rhs.getSFilename()) &&
        ((!hasSMetaDataField1() && !rhs.hasSMetaDataField1()) || getSMetaDataField1() == rhs.getSMetaDataField1()) &&
        ((!hasSMetaDataField2() && !rhs.hasSMetaDataField2()) || getSMetaDataField2() == rhs.getSMetaDataField2()) &&
        ((!hasSMetaDataField3() && !rhs.hasSMetaDataField3()) || getSMetaDataField3() == rhs.getSMetaDataField3()) &&
        ((!hasSMetaDataField4() && !rhs.hasSMetaDataField4()) || getSMetaDataField4() == rhs.getSMetaDataField4()) &&
        ((!hasSYomiMetaDataTitle() && !rhs.hasSYomiMetaDataTitle()) || getSYomiMetaDataTitle() == rhs.getSYomiMetaDataTitle()) &&
        ((!hasSYomiMetaDataArtist() && !rhs.hasSYomiMetaDataArtist()) || getSYomiMetaDataArtist() == rhs.getSYomiMetaDataArtist()) &&
        ((!hasSYomiMetaDataAlbum() && !rhs.hasSYomiMetaDataAlbum()) || getSYomiMetaDataAlbum() == rhs.getSYomiMetaDataAlbum()) &&
        ((!hasSResolution() && !rhs.hasSResolution()) || getSResolution() == rhs.getSResolution()) &&
        ((!hasU16ExtendedTrackNumber() && !rhs.hasU16ExtendedTrackNumber()) || getU16ExtendedTrackNumber() == rhs.getU16ExtendedTrackNumber()) &&
        ((!hasU32BitRate() && !rhs.hasU32BitRate()) || getU32BitRate() == rhs.getU32BitRate()) &&
        ((!hasU32MetaDataTag1() && !rhs.hasU32MetaDataTag1()) || getU32MetaDataTag1() == rhs.getU32MetaDataTag1()) &&
        ((!hasU32MetaDataTag2() && !rhs.hasU32MetaDataTag2()) || getU32MetaDataTag2() == rhs.getU32MetaDataTag2()) &&
        ((!hasU32MetaDataTag3() && !rhs.hasU32MetaDataTag3()) || getU32MetaDataTag3() == rhs.getU32MetaDataTag3()) &&
        ((!hasU32MetaDataTag4() && !rhs.hasU32MetaDataTag4()) || getU32MetaDataTag4() == rhs.getU32MetaDataTag4()) &&
        ((!hasU32SampleRate() && !rhs.hasU32SampleRate()) || getU32SampleRate() == rhs.getU32SampleRate()) &&
        ((!hasU32Tag() && !rhs.hasU32Tag()) || getU32Tag() == rhs.getU32Tag()) &&
        ((!hasU32TotalPlaytime() && !rhs.hasU32TotalPlaytime()) || getU32TotalPlaytime() == rhs.getU32TotalPlaytime()) &&
        ((!hasU32Year() && !rhs.hasU32Year()) || getU32Year() == rhs.getU32Year()) &&
        ((!hasU32YearID() && !rhs.hasU32YearID()) || getU32YearID() == rhs.getU32YearID()) &&
        ((!hasU64FileSize() && !rhs.hasU64FileSize()) || getU64FileSize() == rhs.getU64FileSize()) &&
        ((!hasU8DeviceTag() && !rhs.hasU8DeviceTag()) || getU8DeviceTag() == rhs.getU8DeviceTag()) &&
        ((!hasU8TrackNumber() && !rhs.hasU8TrackNumber()) || getU8TrackNumber() == rhs.getU8TrackNumber()) &&
        ((!hasBIsFavorite() && !rhs.hasBIsFavorite()) || getBIsFavorite() == rhs.getBIsFavorite()));
}

inline bool T_MPlayMediaObject::operator != (const T_MPlayMediaObject& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MPlayMediaObject::operator < (const T_MPlayMediaObject& rhs) const {
    if (hasE8AudioChannelFormat() || rhs.hasE8AudioChannelFormat()) {
        if ((uint32)getE8AudioChannelFormat() < (uint32)rhs.getE8AudioChannelFormat()) return true;
        if ((uint32)getE8AudioChannelFormat() > (uint32)rhs.getE8AudioChannelFormat()) return false;
    }
    if (hasE8CategoryType() || rhs.hasE8CategoryType()) {
        if ((uint32)getE8CategoryType() < (uint32)rhs.getE8CategoryType()) return true;
        if ((uint32)getE8CategoryType() > (uint32)rhs.getE8CategoryType()) return false;
    }
    if (hasE8DeviceType() || rhs.hasE8DeviceType()) {
        if ((uint32)getE8DeviceType() < (uint32)rhs.getE8DeviceType()) return true;
        if ((uint32)getE8DeviceType() > (uint32)rhs.getE8DeviceType()) return false;
    }
    if (hasE8FileFormat() || rhs.hasE8FileFormat()) {
        if ((uint32)getE8FileFormat() < (uint32)rhs.getE8FileFormat()) return true;
        if ((uint32)getE8FileFormat() > (uint32)rhs.getE8FileFormat()) return false;
    }
    if (hasE8MediaType() || rhs.hasE8MediaType()) {
        if ((uint32)getE8MediaType() < (uint32)rhs.getE8MediaType()) return true;
        if ((uint32)getE8MediaType() > (uint32)rhs.getE8MediaType()) return false;
    }
    if (hasE8PlayableStatus() || rhs.hasE8PlayableStatus()) {
        if ((uint32)getE8PlayableStatus() < (uint32)rhs.getE8PlayableStatus()) return true;
        if ((uint32)getE8PlayableStatus() > (uint32)rhs.getE8PlayableStatus()) return false;
    }
    if (hasBIsPlaying() || rhs.hasBIsPlaying()) {
        if (getBIsPlaying() < rhs.getBIsPlaying()) return true;
        if (getBIsPlaying() > rhs.getBIsPlaying()) return false;
    }
    if (hasBVBR() || rhs.hasBVBR()) {
        if (getBVBR() < rhs.getBVBR()) return true;
        if (getBVBR() > rhs.getBVBR()) return false;
    }
    if (hasSAlbumArt() || rhs.hasSAlbumArt()) {
        if (getSAlbumArt() < rhs.getSAlbumArt()) return true;
        if (getSAlbumArt() > rhs.getSAlbumArt()) return false;
    }
    if (hasSDateTime() || rhs.hasSDateTime()) {
        if (getSDateTime() < rhs.getSDateTime()) return true;
        if (getSDateTime() > rhs.getSDateTime()) return false;
    }
    if (hasSDeviceVersion() || rhs.hasSDeviceVersion()) {
        if (getSDeviceVersion() < rhs.getSDeviceVersion()) return true;
        if (getSDeviceVersion() > rhs.getSDeviceVersion()) return false;
    }
    if (hasSFilename() || rhs.hasSFilename()) {
        if (getSFilename() < rhs.getSFilename()) return true;
        if (getSFilename() > rhs.getSFilename()) return false;
    }
    if (hasSMetaDataField1() || rhs.hasSMetaDataField1()) {
        if (getSMetaDataField1() < rhs.getSMetaDataField1()) return true;
        if (getSMetaDataField1() > rhs.getSMetaDataField1()) return false;
    }
    if (hasSMetaDataField2() || rhs.hasSMetaDataField2()) {
        if (getSMetaDataField2() < rhs.getSMetaDataField2()) return true;
        if (getSMetaDataField2() > rhs.getSMetaDataField2()) return false;
    }
    if (hasSMetaDataField3() || rhs.hasSMetaDataField3()) {
        if (getSMetaDataField3() < rhs.getSMetaDataField3()) return true;
        if (getSMetaDataField3() > rhs.getSMetaDataField3()) return false;
    }
    if (hasSMetaDataField4() || rhs.hasSMetaDataField4()) {
        if (getSMetaDataField4() < rhs.getSMetaDataField4()) return true;
        if (getSMetaDataField4() > rhs.getSMetaDataField4()) return false;
    }
    if (hasSYomiMetaDataTitle() || rhs.hasSYomiMetaDataTitle()) {
        if (getSYomiMetaDataTitle() < rhs.getSYomiMetaDataTitle()) return true;
        if (getSYomiMetaDataTitle() > rhs.getSYomiMetaDataTitle()) return false;
    }
    if (hasSYomiMetaDataArtist() || rhs.hasSYomiMetaDataArtist()) {
        if (getSYomiMetaDataArtist() < rhs.getSYomiMetaDataArtist()) return true;
        if (getSYomiMetaDataArtist() > rhs.getSYomiMetaDataArtist()) return false;
    }
    if (hasSYomiMetaDataAlbum() || rhs.hasSYomiMetaDataAlbum()) {
        if (getSYomiMetaDataAlbum() < rhs.getSYomiMetaDataAlbum()) return true;
        if (getSYomiMetaDataAlbum() > rhs.getSYomiMetaDataAlbum()) return false;
    }
    if (hasSResolution() || rhs.hasSResolution()) {
        if (getSResolution() < rhs.getSResolution()) return true;
        if (getSResolution() > rhs.getSResolution()) return false;
    }
    if (hasU16ExtendedTrackNumber() || rhs.hasU16ExtendedTrackNumber()) {
        if (getU16ExtendedTrackNumber() < rhs.getU16ExtendedTrackNumber()) return true;
        if (getU16ExtendedTrackNumber() > rhs.getU16ExtendedTrackNumber()) return false;
    }
    if (hasU32BitRate() || rhs.hasU32BitRate()) {
        if (getU32BitRate() < rhs.getU32BitRate()) return true;
        if (getU32BitRate() > rhs.getU32BitRate()) return false;
    }
    if (hasU32MetaDataTag1() || rhs.hasU32MetaDataTag1()) {
        if (getU32MetaDataTag1() < rhs.getU32MetaDataTag1()) return true;
        if (getU32MetaDataTag1() > rhs.getU32MetaDataTag1()) return false;
    }
    if (hasU32MetaDataTag2() || rhs.hasU32MetaDataTag2()) {
        if (getU32MetaDataTag2() < rhs.getU32MetaDataTag2()) return true;
        if (getU32MetaDataTag2() > rhs.getU32MetaDataTag2()) return false;
    }
    if (hasU32MetaDataTag3() || rhs.hasU32MetaDataTag3()) {
        if (getU32MetaDataTag3() < rhs.getU32MetaDataTag3()) return true;
        if (getU32MetaDataTag3() > rhs.getU32MetaDataTag3()) return false;
    }
    if (hasU32MetaDataTag4() || rhs.hasU32MetaDataTag4()) {
        if (getU32MetaDataTag4() < rhs.getU32MetaDataTag4()) return true;
        if (getU32MetaDataTag4() > rhs.getU32MetaDataTag4()) return false;
    }
    if (hasU32SampleRate() || rhs.hasU32SampleRate()) {
        if (getU32SampleRate() < rhs.getU32SampleRate()) return true;
        if (getU32SampleRate() > rhs.getU32SampleRate()) return false;
    }
    if (hasU32Tag() || rhs.hasU32Tag()) {
        if (getU32Tag() < rhs.getU32Tag()) return true;
        if (getU32Tag() > rhs.getU32Tag()) return false;
    }
    if (hasU32TotalPlaytime() || rhs.hasU32TotalPlaytime()) {
        if (getU32TotalPlaytime() < rhs.getU32TotalPlaytime()) return true;
        if (getU32TotalPlaytime() > rhs.getU32TotalPlaytime()) return false;
    }
    if (hasU32Year() || rhs.hasU32Year()) {
        if (getU32Year() < rhs.getU32Year()) return true;
        if (getU32Year() > rhs.getU32Year()) return false;
    }
    if (hasU32YearID() || rhs.hasU32YearID()) {
        if (getU32YearID() < rhs.getU32YearID()) return true;
        if (getU32YearID() > rhs.getU32YearID()) return false;
    }
    if (hasU64FileSize() || rhs.hasU64FileSize()) {
        if (getU64FileSize() < rhs.getU64FileSize()) return true;
        if (getU64FileSize() > rhs.getU64FileSize()) return false;
    }
    if (hasU8DeviceTag() || rhs.hasU8DeviceTag()) {
        if (getU8DeviceTag() < rhs.getU8DeviceTag()) return true;
        if (getU8DeviceTag() > rhs.getU8DeviceTag()) return false;
    }
    if (hasU8TrackNumber() || rhs.hasU8TrackNumber()) {
        if (getU8TrackNumber() < rhs.getU8TrackNumber()) return true;
        if (getU8TrackNumber() > rhs.getU8TrackNumber()) return false;
    }
    if (hasBIsFavorite() || rhs.hasBIsFavorite()) {
        if (getBIsFavorite() < rhs.getBIsFavorite()) return true;
        if (getBIsFavorite() > rhs.getBIsFavorite()) return false;
    }
    return false;
}

inline bool T_MPlayMediaObject::operator > (const T_MPlayMediaObject& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MPlayMediaObject::clear() {
    clearE8AudioChannelFormat();
    clearE8CategoryType();
    clearE8DeviceType();
    clearE8FileFormat();
    clearE8MediaType();
    clearE8PlayableStatus();
    clearBIsPlaying();
    clearBVBR();
    clearSAlbumArt();
    clearSDateTime();
    clearSDeviceVersion();
    clearSFilename();
    clearSMetaDataField1();
    clearSMetaDataField2();
    clearSMetaDataField3();
    clearSMetaDataField4();
    clearSYomiMetaDataTitle();
    clearSYomiMetaDataArtist();
    clearSYomiMetaDataAlbum();
    clearSResolution();
    clearU16ExtendedTrackNumber();
    clearU32BitRate();
    clearU32MetaDataTag1();
    clearU32MetaDataTag2();
    clearU32MetaDataTag3();
    clearU32MetaDataTag4();
    clearU32SampleRate();
    clearU32Tag();
    clearU32TotalPlaytime();
    clearU32Year();
    clearU32YearID();
    clearU64FileSize();
    clearU8DeviceTag();
    clearU8TrackNumber();
    clearBIsFavorite();
}

inline void T_MPlayMediaObject::clearE8AudioChannelFormat() {
    if (hasE8AudioChannelFormat()) {
         clear_has_e8AudioChannelFormat();
        _e8AudioChannelFormat = ::MPlay_fi_types::T_e8_MPlayAudioChannelFormat__e8ACF_MONO;
     }
}

inline bool T_MPlayMediaObject::hasE8AudioChannelFormat () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_MPlayAudioChannelFormat T_MPlayMediaObject::getE8AudioChannelFormat () const {
    return _e8AudioChannelFormat;
}

inline void T_MPlayMediaObject::setE8AudioChannelFormat (T_e8_MPlayAudioChannelFormat e8AudioChannelFormat_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayAudioChannelFormat_IsValid(e8AudioChannelFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AudioChannelFormat_, "T_e8_MPlayAudioChannelFormat", "e8AudioChannelFormat", "T_MPlayMediaObject");
    }
    #endif
    set_has_e8AudioChannelFormat();
    this->_e8AudioChannelFormat = e8AudioChannelFormat_;
}

inline void T_MPlayMediaObject::clearE8CategoryType() {
    if (hasE8CategoryType()) {
         clear_has_e8CategoryType();
        _e8CategoryType = ::MPlay_fi_types::T_e8_MPlayCategoryType__e8CTY_ALBUM;
     }
}

inline bool T_MPlayMediaObject::hasE8CategoryType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_MPlayCategoryType T_MPlayMediaObject::getE8CategoryType () const {
    return _e8CategoryType;
}

inline void T_MPlayMediaObject::setE8CategoryType (T_e8_MPlayCategoryType e8CategoryType_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayCategoryType_IsValid(e8CategoryType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CategoryType_, "T_e8_MPlayCategoryType", "e8CategoryType", "T_MPlayMediaObject");
    }
    #endif
    set_has_e8CategoryType();
    this->_e8CategoryType = e8CategoryType_;
}

inline void T_MPlayMediaObject::clearE8DeviceType() {
    if (hasE8DeviceType()) {
         clear_has_e8DeviceType();
        _e8DeviceType = ::MPlay_fi_types::T_e8_MPlayDeviceType__e8DTY_BLUETOOTH;
     }
}

inline bool T_MPlayMediaObject::hasE8DeviceType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_MPlayDeviceType T_MPlayMediaObject::getE8DeviceType () const {
    return _e8DeviceType;
}

inline void T_MPlayMediaObject::setE8DeviceType (T_e8_MPlayDeviceType e8DeviceType_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceType_IsValid(e8DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceType_, "T_e8_MPlayDeviceType", "e8DeviceType", "T_MPlayMediaObject");
    }
    #endif
    set_has_e8DeviceType();
    this->_e8DeviceType = e8DeviceType_;
}

inline void T_MPlayMediaObject::clearE8FileFormat() {
    if (hasE8FileFormat()) {
         clear_has_e8FileFormat();
        _e8FileFormat = ::MPlay_fi_types::T_e8_MPlayFileFormat__e8FFT_3G2;
     }
}

inline bool T_MPlayMediaObject::hasE8FileFormat () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_MPlayFileFormat T_MPlayMediaObject::getE8FileFormat () const {
    return _e8FileFormat;
}

inline void T_MPlayMediaObject::setE8FileFormat (T_e8_MPlayFileFormat e8FileFormat_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileFormat_IsValid(e8FileFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileFormat_, "T_e8_MPlayFileFormat", "e8FileFormat", "T_MPlayMediaObject");
    }
    #endif
    set_has_e8FileFormat();
    this->_e8FileFormat = e8FileFormat_;
}

inline void T_MPlayMediaObject::clearE8MediaType() {
    if (hasE8MediaType()) {
         clear_has_e8MediaType();
        _e8MediaType = ::MPlay_fi_types::T_e8_MPlayMediaType__e8MRY_AUDIO_STREAM;
     }
}

inline bool T_MPlayMediaObject::hasE8MediaType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_MPlayMediaType T_MPlayMediaObject::getE8MediaType () const {
    return _e8MediaType;
}

inline void T_MPlayMediaObject::setE8MediaType (T_e8_MPlayMediaType e8MediaType_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayMediaType_IsValid(e8MediaType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MediaType_, "T_e8_MPlayMediaType", "e8MediaType", "T_MPlayMediaObject");
    }
    #endif
    set_has_e8MediaType();
    this->_e8MediaType = e8MediaType_;
}

inline void T_MPlayMediaObject::clearE8PlayableStatus() {
    if (hasE8PlayableStatus()) {
         clear_has_e8PlayableStatus();
        _e8PlayableStatus = ::MPlay_fi_types::T_e8_MPlayPlayableStatus__e8FP_DRM_PROTECTED;
     }
}

inline bool T_MPlayMediaObject::hasE8PlayableStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_MPlayPlayableStatus T_MPlayMediaObject::getE8PlayableStatus () const {
    return _e8PlayableStatus;
}

inline void T_MPlayMediaObject::setE8PlayableStatus (T_e8_MPlayPlayableStatus e8PlayableStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayPlayableStatus_IsValid(e8PlayableStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PlayableStatus_, "T_e8_MPlayPlayableStatus", "e8PlayableStatus", "T_MPlayMediaObject");
    }
    #endif
    set_has_e8PlayableStatus();
    this->_e8PlayableStatus = e8PlayableStatus_;
}

inline void T_MPlayMediaObject::clearBIsPlaying() {
    if (hasBIsPlaying()) {
         clear_has_bIsPlaying();
        _bIsPlaying = false;
     }
}

inline bool T_MPlayMediaObject::hasBIsPlaying () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_MPlayMediaObject::getBIsPlaying () const {
    return _bIsPlaying;
}

inline void T_MPlayMediaObject::setBIsPlaying (bool bIsPlaying_) {
    set_has_bIsPlaying();
    this->_bIsPlaying = bIsPlaying_;
}

inline void T_MPlayMediaObject::clearBVBR() {
    if (hasBVBR()) {
         clear_has_bVBR();
        _bVBR = false;
     }
}

inline bool T_MPlayMediaObject::hasBVBR () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_MPlayMediaObject::getBVBR () const {
    return _bVBR;
}

inline void T_MPlayMediaObject::setBVBR (bool bVBR_) {
    set_has_bVBR();
    this->_bVBR = bVBR_;
}

inline void T_MPlayMediaObject::clearSAlbumArt() {
    if (hasSAlbumArt()) {
         clear_has_sAlbumArt();
        _sAlbumArt.clear();
     }
}

inline bool T_MPlayMediaObject::hasSAlbumArt () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_MPlayMediaObject::getSAlbumArt () const {
    return _sAlbumArt;
}

inline ::std::string& T_MPlayMediaObject::getSAlbumArtMutable () {
    set_has_sAlbumArt();
    return _sAlbumArt;
}

inline void T_MPlayMediaObject::setSAlbumArt (const ::std::string& sAlbumArt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbumArt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbumArt();
    this->_sAlbumArt = sAlbumArt_;
}

inline void T_MPlayMediaObject::setSAlbumArt (const char* sAlbumArt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbumArt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbumArt();
    this->_sAlbumArt.assign(sAlbumArt_);
}

inline void T_MPlayMediaObject::setSAlbumArt (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbumArt();
    this->_sAlbumArt.assign(value, size);
}

inline void T_MPlayMediaObject::clearSDateTime() {
    if (hasSDateTime()) {
         clear_has_sDateTime();
        _sDateTime.clear();
     }
}

inline bool T_MPlayMediaObject::hasSDateTime () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_MPlayMediaObject::getSDateTime () const {
    return _sDateTime;
}

inline ::std::string& T_MPlayMediaObject::getSDateTimeMutable () {
    set_has_sDateTime();
    return _sDateTime;
}

inline void T_MPlayMediaObject::setSDateTime (const ::std::string& sDateTime_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDateTime_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDateTime();
    this->_sDateTime = sDateTime_;
}

inline void T_MPlayMediaObject::setSDateTime (const char* sDateTime_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDateTime_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDateTime();
    this->_sDateTime.assign(sDateTime_);
}

inline void T_MPlayMediaObject::setSDateTime (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDateTime();
    this->_sDateTime.assign(value, size);
}

inline void T_MPlayMediaObject::clearSDeviceVersion() {
    if (hasSDeviceVersion()) {
         clear_has_sDeviceVersion();
        _sDeviceVersion.clear();
     }
}

inline bool T_MPlayMediaObject::hasSDeviceVersion () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_MPlayMediaObject::getSDeviceVersion () const {
    return _sDeviceVersion;
}

inline ::std::string& T_MPlayMediaObject::getSDeviceVersionMutable () {
    set_has_sDeviceVersion();
    return _sDeviceVersion;
}

inline void T_MPlayMediaObject::setSDeviceVersion (const ::std::string& sDeviceVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceVersion();
    this->_sDeviceVersion = sDeviceVersion_;
}

inline void T_MPlayMediaObject::setSDeviceVersion (const char* sDeviceVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceVersion();
    this->_sDeviceVersion.assign(sDeviceVersion_);
}

inline void T_MPlayMediaObject::setSDeviceVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceVersion();
    this->_sDeviceVersion.assign(value, size);
}

inline void T_MPlayMediaObject::clearSFilename() {
    if (hasSFilename()) {
         clear_has_sFilename();
        _sFilename.clear();
     }
}

inline bool T_MPlayMediaObject::hasSFilename () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_MPlayMediaObject::getSFilename () const {
    return _sFilename;
}

inline ::std::string& T_MPlayMediaObject::getSFilenameMutable () {
    set_has_sFilename();
    return _sFilename;
}

inline void T_MPlayMediaObject::setSFilename (const ::std::string& sFilename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFilename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFilename();
    this->_sFilename = sFilename_;
}

inline void T_MPlayMediaObject::setSFilename (const char* sFilename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFilename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFilename();
    this->_sFilename.assign(sFilename_);
}

inline void T_MPlayMediaObject::setSFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFilename();
    this->_sFilename.assign(value, size);
}

inline void T_MPlayMediaObject::clearSMetaDataField1() {
    if (hasSMetaDataField1()) {
         clear_has_sMetaDataField1();
        _sMetaDataField1.clear();
     }
}

inline bool T_MPlayMediaObject::hasSMetaDataField1 () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::string& T_MPlayMediaObject::getSMetaDataField1 () const {
    return _sMetaDataField1;
}

inline ::std::string& T_MPlayMediaObject::getSMetaDataField1Mutable () {
    set_has_sMetaDataField1();
    return _sMetaDataField1;
}

inline void T_MPlayMediaObject::setSMetaDataField1 (const ::std::string& sMetaDataField1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField1();
    this->_sMetaDataField1 = sMetaDataField1_;
}

inline void T_MPlayMediaObject::setSMetaDataField1 (const char* sMetaDataField1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField1();
    this->_sMetaDataField1.assign(sMetaDataField1_);
}

inline void T_MPlayMediaObject::setSMetaDataField1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField1();
    this->_sMetaDataField1.assign(value, size);
}

inline void T_MPlayMediaObject::clearSMetaDataField2() {
    if (hasSMetaDataField2()) {
         clear_has_sMetaDataField2();
        _sMetaDataField2.clear();
     }
}

inline bool T_MPlayMediaObject::hasSMetaDataField2 () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline const ::std::string& T_MPlayMediaObject::getSMetaDataField2 () const {
    return _sMetaDataField2;
}

inline ::std::string& T_MPlayMediaObject::getSMetaDataField2Mutable () {
    set_has_sMetaDataField2();
    return _sMetaDataField2;
}

inline void T_MPlayMediaObject::setSMetaDataField2 (const ::std::string& sMetaDataField2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField2();
    this->_sMetaDataField2 = sMetaDataField2_;
}

inline void T_MPlayMediaObject::setSMetaDataField2 (const char* sMetaDataField2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField2();
    this->_sMetaDataField2.assign(sMetaDataField2_);
}

inline void T_MPlayMediaObject::setSMetaDataField2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField2();
    this->_sMetaDataField2.assign(value, size);
}

inline void T_MPlayMediaObject::clearSMetaDataField3() {
    if (hasSMetaDataField3()) {
         clear_has_sMetaDataField3();
        _sMetaDataField3.clear();
     }
}

inline bool T_MPlayMediaObject::hasSMetaDataField3 () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const ::std::string& T_MPlayMediaObject::getSMetaDataField3 () const {
    return _sMetaDataField3;
}

inline ::std::string& T_MPlayMediaObject::getSMetaDataField3Mutable () {
    set_has_sMetaDataField3();
    return _sMetaDataField3;
}

inline void T_MPlayMediaObject::setSMetaDataField3 (const ::std::string& sMetaDataField3_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField3_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField3();
    this->_sMetaDataField3 = sMetaDataField3_;
}

inline void T_MPlayMediaObject::setSMetaDataField3 (const char* sMetaDataField3_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField3_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField3();
    this->_sMetaDataField3.assign(sMetaDataField3_);
}

inline void T_MPlayMediaObject::setSMetaDataField3 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField3();
    this->_sMetaDataField3.assign(value, size);
}

inline void T_MPlayMediaObject::clearSMetaDataField4() {
    if (hasSMetaDataField4()) {
         clear_has_sMetaDataField4();
        _sMetaDataField4.clear();
     }
}

inline bool T_MPlayMediaObject::hasSMetaDataField4 () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline const ::std::string& T_MPlayMediaObject::getSMetaDataField4 () const {
    return _sMetaDataField4;
}

inline ::std::string& T_MPlayMediaObject::getSMetaDataField4Mutable () {
    set_has_sMetaDataField4();
    return _sMetaDataField4;
}

inline void T_MPlayMediaObject::setSMetaDataField4 (const ::std::string& sMetaDataField4_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField4_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField4();
    this->_sMetaDataField4 = sMetaDataField4_;
}

inline void T_MPlayMediaObject::setSMetaDataField4 (const char* sMetaDataField4_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField4_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField4();
    this->_sMetaDataField4.assign(sMetaDataField4_);
}

inline void T_MPlayMediaObject::setSMetaDataField4 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField4();
    this->_sMetaDataField4.assign(value, size);
}

inline void T_MPlayMediaObject::clearSYomiMetaDataTitle() {
    if (hasSYomiMetaDataTitle()) {
         clear_has_sYomiMetaDataTitle();
        _sYomiMetaDataTitle.clear();
     }
}

inline bool T_MPlayMediaObject::hasSYomiMetaDataTitle () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline const ::std::string& T_MPlayMediaObject::getSYomiMetaDataTitle () const {
    return _sYomiMetaDataTitle;
}

inline ::std::string& T_MPlayMediaObject::getSYomiMetaDataTitleMutable () {
    set_has_sYomiMetaDataTitle();
    return _sYomiMetaDataTitle;
}

inline void T_MPlayMediaObject::setSYomiMetaDataTitle (const ::std::string& sYomiMetaDataTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataTitle();
    this->_sYomiMetaDataTitle = sYomiMetaDataTitle_;
}

inline void T_MPlayMediaObject::setSYomiMetaDataTitle (const char* sYomiMetaDataTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataTitle();
    this->_sYomiMetaDataTitle.assign(sYomiMetaDataTitle_);
}

inline void T_MPlayMediaObject::setSYomiMetaDataTitle (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataTitle();
    this->_sYomiMetaDataTitle.assign(value, size);
}

inline void T_MPlayMediaObject::clearSYomiMetaDataArtist() {
    if (hasSYomiMetaDataArtist()) {
         clear_has_sYomiMetaDataArtist();
        _sYomiMetaDataArtist.clear();
     }
}

inline bool T_MPlayMediaObject::hasSYomiMetaDataArtist () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline const ::std::string& T_MPlayMediaObject::getSYomiMetaDataArtist () const {
    return _sYomiMetaDataArtist;
}

inline ::std::string& T_MPlayMediaObject::getSYomiMetaDataArtistMutable () {
    set_has_sYomiMetaDataArtist();
    return _sYomiMetaDataArtist;
}

inline void T_MPlayMediaObject::setSYomiMetaDataArtist (const ::std::string& sYomiMetaDataArtist_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataArtist_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataArtist();
    this->_sYomiMetaDataArtist = sYomiMetaDataArtist_;
}

inline void T_MPlayMediaObject::setSYomiMetaDataArtist (const char* sYomiMetaDataArtist_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataArtist_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataArtist();
    this->_sYomiMetaDataArtist.assign(sYomiMetaDataArtist_);
}

inline void T_MPlayMediaObject::setSYomiMetaDataArtist (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataArtist();
    this->_sYomiMetaDataArtist.assign(value, size);
}

inline void T_MPlayMediaObject::clearSYomiMetaDataAlbum() {
    if (hasSYomiMetaDataAlbum()) {
         clear_has_sYomiMetaDataAlbum();
        _sYomiMetaDataAlbum.clear();
     }
}

inline bool T_MPlayMediaObject::hasSYomiMetaDataAlbum () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline const ::std::string& T_MPlayMediaObject::getSYomiMetaDataAlbum () const {
    return _sYomiMetaDataAlbum;
}

inline ::std::string& T_MPlayMediaObject::getSYomiMetaDataAlbumMutable () {
    set_has_sYomiMetaDataAlbum();
    return _sYomiMetaDataAlbum;
}

inline void T_MPlayMediaObject::setSYomiMetaDataAlbum (const ::std::string& sYomiMetaDataAlbum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataAlbum();
    this->_sYomiMetaDataAlbum = sYomiMetaDataAlbum_;
}

inline void T_MPlayMediaObject::setSYomiMetaDataAlbum (const char* sYomiMetaDataAlbum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataAlbum();
    this->_sYomiMetaDataAlbum.assign(sYomiMetaDataAlbum_);
}

inline void T_MPlayMediaObject::setSYomiMetaDataAlbum (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataAlbum();
    this->_sYomiMetaDataAlbum.assign(value, size);
}

inline void T_MPlayMediaObject::clearSResolution() {
    if (hasSResolution()) {
         clear_has_sResolution();
        _sResolution.clear();
     }
}

inline bool T_MPlayMediaObject::hasSResolution () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline const ::std::string& T_MPlayMediaObject::getSResolution () const {
    return _sResolution;
}

inline ::std::string& T_MPlayMediaObject::getSResolutionMutable () {
    set_has_sResolution();
    return _sResolution;
}

inline void T_MPlayMediaObject::setSResolution (const ::std::string& sResolution_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sResolution_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sResolution();
    this->_sResolution = sResolution_;
}

inline void T_MPlayMediaObject::setSResolution (const char* sResolution_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sResolution_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sResolution();
    this->_sResolution.assign(sResolution_);
}

inline void T_MPlayMediaObject::setSResolution (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sResolution();
    this->_sResolution.assign(value, size);
}

inline void T_MPlayMediaObject::clearU16ExtendedTrackNumber() {
    if (hasU16ExtendedTrackNumber()) {
         clear_has_u16ExtendedTrackNumber();
        _u16ExtendedTrackNumber = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU16ExtendedTrackNumber () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline uint16 T_MPlayMediaObject::getU16ExtendedTrackNumber () const {
    return _u16ExtendedTrackNumber;
}

inline void T_MPlayMediaObject::setU16ExtendedTrackNumber (uint16 u16ExtendedTrackNumber_) {
    set_has_u16ExtendedTrackNumber();
    this->_u16ExtendedTrackNumber = u16ExtendedTrackNumber_;
}

inline void T_MPlayMediaObject::clearU32BitRate() {
    if (hasU32BitRate()) {
         clear_has_u32BitRate();
        _u32BitRate = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU32BitRate () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline uint32 T_MPlayMediaObject::getU32BitRate () const {
    return _u32BitRate;
}

inline void T_MPlayMediaObject::setU32BitRate (uint32 u32BitRate_) {
    set_has_u32BitRate();
    this->_u32BitRate = u32BitRate_;
}

inline void T_MPlayMediaObject::clearU32MetaDataTag1() {
    if (hasU32MetaDataTag1()) {
         clear_has_u32MetaDataTag1();
        _u32MetaDataTag1 = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU32MetaDataTag1 () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline uint32 T_MPlayMediaObject::getU32MetaDataTag1 () const {
    return _u32MetaDataTag1;
}

inline void T_MPlayMediaObject::setU32MetaDataTag1 (uint32 u32MetaDataTag1_) {
    set_has_u32MetaDataTag1();
    this->_u32MetaDataTag1 = u32MetaDataTag1_;
}

inline void T_MPlayMediaObject::clearU32MetaDataTag2() {
    if (hasU32MetaDataTag2()) {
         clear_has_u32MetaDataTag2();
        _u32MetaDataTag2 = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU32MetaDataTag2 () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline uint32 T_MPlayMediaObject::getU32MetaDataTag2 () const {
    return _u32MetaDataTag2;
}

inline void T_MPlayMediaObject::setU32MetaDataTag2 (uint32 u32MetaDataTag2_) {
    set_has_u32MetaDataTag2();
    this->_u32MetaDataTag2 = u32MetaDataTag2_;
}

inline void T_MPlayMediaObject::clearU32MetaDataTag3() {
    if (hasU32MetaDataTag3()) {
         clear_has_u32MetaDataTag3();
        _u32MetaDataTag3 = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU32MetaDataTag3 () const {
    return (_has_bits_[0] & (1u << 24)) > 0;
}

inline uint32 T_MPlayMediaObject::getU32MetaDataTag3 () const {
    return _u32MetaDataTag3;
}

inline void T_MPlayMediaObject::setU32MetaDataTag3 (uint32 u32MetaDataTag3_) {
    set_has_u32MetaDataTag3();
    this->_u32MetaDataTag3 = u32MetaDataTag3_;
}

inline void T_MPlayMediaObject::clearU32MetaDataTag4() {
    if (hasU32MetaDataTag4()) {
         clear_has_u32MetaDataTag4();
        _u32MetaDataTag4 = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU32MetaDataTag4 () const {
    return (_has_bits_[0] & (1u << 25)) > 0;
}

inline uint32 T_MPlayMediaObject::getU32MetaDataTag4 () const {
    return _u32MetaDataTag4;
}

inline void T_MPlayMediaObject::setU32MetaDataTag4 (uint32 u32MetaDataTag4_) {
    set_has_u32MetaDataTag4();
    this->_u32MetaDataTag4 = u32MetaDataTag4_;
}

inline void T_MPlayMediaObject::clearU32SampleRate() {
    if (hasU32SampleRate()) {
         clear_has_u32SampleRate();
        _u32SampleRate = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU32SampleRate () const {
    return (_has_bits_[0] & (1u << 26)) > 0;
}

inline uint32 T_MPlayMediaObject::getU32SampleRate () const {
    return _u32SampleRate;
}

inline void T_MPlayMediaObject::setU32SampleRate (uint32 u32SampleRate_) {
    set_has_u32SampleRate();
    this->_u32SampleRate = u32SampleRate_;
}

inline void T_MPlayMediaObject::clearU32Tag() {
    if (hasU32Tag()) {
         clear_has_u32Tag();
        _u32Tag = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU32Tag () const {
    return (_has_bits_[0] & (1u << 27)) > 0;
}

inline uint32 T_MPlayMediaObject::getU32Tag () const {
    return _u32Tag;
}

inline void T_MPlayMediaObject::setU32Tag (uint32 u32Tag_) {
    set_has_u32Tag();
    this->_u32Tag = u32Tag_;
}

inline void T_MPlayMediaObject::clearU32TotalPlaytime() {
    if (hasU32TotalPlaytime()) {
         clear_has_u32TotalPlaytime();
        _u32TotalPlaytime = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU32TotalPlaytime () const {
    return (_has_bits_[0] & (1u << 28)) > 0;
}

inline uint32 T_MPlayMediaObject::getU32TotalPlaytime () const {
    return _u32TotalPlaytime;
}

inline void T_MPlayMediaObject::setU32TotalPlaytime (uint32 u32TotalPlaytime_) {
    set_has_u32TotalPlaytime();
    this->_u32TotalPlaytime = u32TotalPlaytime_;
}

inline void T_MPlayMediaObject::clearU32Year() {
    if (hasU32Year()) {
         clear_has_u32Year();
        _u32Year = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU32Year () const {
    return (_has_bits_[0] & (1u << 29)) > 0;
}

inline uint32 T_MPlayMediaObject::getU32Year () const {
    return _u32Year;
}

inline void T_MPlayMediaObject::setU32Year (uint32 u32Year_) {
    set_has_u32Year();
    this->_u32Year = u32Year_;
}

inline void T_MPlayMediaObject::clearU32YearID() {
    if (hasU32YearID()) {
         clear_has_u32YearID();
        _u32YearID = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU32YearID () const {
    return (_has_bits_[0] & (1u << 30)) > 0;
}

inline uint32 T_MPlayMediaObject::getU32YearID () const {
    return _u32YearID;
}

inline void T_MPlayMediaObject::setU32YearID (uint32 u32YearID_) {
    set_has_u32YearID();
    this->_u32YearID = u32YearID_;
}

inline void T_MPlayMediaObject::clearU64FileSize() {
    if (hasU64FileSize()) {
         clear_has_u64FileSize();
        _u64FileSize = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU64FileSize () const {
    return (_has_bits_[0] & (1u << 31)) > 0;
}

inline uint64 T_MPlayMediaObject::getU64FileSize () const {
    return _u64FileSize;
}

inline void T_MPlayMediaObject::setU64FileSize (uint64 u64FileSize_) {
    set_has_u64FileSize();
    this->_u64FileSize = u64FileSize_;
}

inline void T_MPlayMediaObject::clearU8DeviceTag() {
    if (hasU8DeviceTag()) {
         clear_has_u8DeviceTag();
        _u8DeviceTag = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU8DeviceTag () const {
    return (_has_bits_[1] & (1u << 0)) > 0;
}

inline uint8 T_MPlayMediaObject::getU8DeviceTag () const {
    return _u8DeviceTag;
}

inline void T_MPlayMediaObject::setU8DeviceTag (uint8 u8DeviceTag_) {
    set_has_u8DeviceTag();
    this->_u8DeviceTag = u8DeviceTag_;
}

inline void T_MPlayMediaObject::clearU8TrackNumber() {
    if (hasU8TrackNumber()) {
         clear_has_u8TrackNumber();
        _u8TrackNumber = 0u;
     }
}

inline bool T_MPlayMediaObject::hasU8TrackNumber () const {
    return (_has_bits_[1] & (1u << 1)) > 0;
}

inline uint8 T_MPlayMediaObject::getU8TrackNumber () const {
    return _u8TrackNumber;
}

inline void T_MPlayMediaObject::setU8TrackNumber (uint8 u8TrackNumber_) {
    set_has_u8TrackNumber();
    this->_u8TrackNumber = u8TrackNumber_;
}

inline void T_MPlayMediaObject::clearBIsFavorite() {
    if (hasBIsFavorite()) {
         clear_has_bIsFavorite();
        _bIsFavorite = false;
     }
}

inline bool T_MPlayMediaObject::hasBIsFavorite () const {
    return (_has_bits_[1] & (1u << 2)) > 0;
}

inline bool T_MPlayMediaObject::getBIsFavorite () const {
    return _bIsFavorite;
}

inline void T_MPlayMediaObject::setBIsFavorite (bool bIsFavorite_) {
    set_has_bIsFavorite();
    this->_bIsFavorite = bIsFavorite_;
}

inline void T_MPlayMediaObject::set_has_e8AudioChannelFormat () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MPlayMediaObject::clear_has_e8AudioChannelFormat () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MPlayMediaObject::set_has_e8CategoryType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MPlayMediaObject::clear_has_e8CategoryType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MPlayMediaObject::set_has_e8DeviceType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MPlayMediaObject::clear_has_e8DeviceType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MPlayMediaObject::set_has_e8FileFormat () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MPlayMediaObject::clear_has_e8FileFormat () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MPlayMediaObject::set_has_e8MediaType () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MPlayMediaObject::clear_has_e8MediaType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MPlayMediaObject::set_has_e8PlayableStatus () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MPlayMediaObject::clear_has_e8PlayableStatus () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_MPlayMediaObject::set_has_bIsPlaying () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_MPlayMediaObject::clear_has_bIsPlaying () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_MPlayMediaObject::set_has_bVBR () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_MPlayMediaObject::clear_has_bVBR () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_MPlayMediaObject::set_has_sAlbumArt () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_MPlayMediaObject::clear_has_sAlbumArt () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_MPlayMediaObject::set_has_sDateTime () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_MPlayMediaObject::clear_has_sDateTime () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_MPlayMediaObject::set_has_sDeviceVersion () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_MPlayMediaObject::clear_has_sDeviceVersion () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_MPlayMediaObject::set_has_sFilename () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_MPlayMediaObject::clear_has_sFilename () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_MPlayMediaObject::set_has_sMetaDataField1 () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_MPlayMediaObject::clear_has_sMetaDataField1 () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_MPlayMediaObject::set_has_sMetaDataField2 () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_MPlayMediaObject::clear_has_sMetaDataField2 () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_MPlayMediaObject::set_has_sMetaDataField3 () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_MPlayMediaObject::clear_has_sMetaDataField3 () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_MPlayMediaObject::set_has_sMetaDataField4 () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_MPlayMediaObject::clear_has_sMetaDataField4 () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_MPlayMediaObject::set_has_sYomiMetaDataTitle () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_MPlayMediaObject::clear_has_sYomiMetaDataTitle () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_MPlayMediaObject::set_has_sYomiMetaDataArtist () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_MPlayMediaObject::clear_has_sYomiMetaDataArtist () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_MPlayMediaObject::set_has_sYomiMetaDataAlbum () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_MPlayMediaObject::clear_has_sYomiMetaDataAlbum () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_MPlayMediaObject::set_has_sResolution () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_MPlayMediaObject::clear_has_sResolution () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_MPlayMediaObject::set_has_u16ExtendedTrackNumber () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_MPlayMediaObject::clear_has_u16ExtendedTrackNumber () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_MPlayMediaObject::set_has_u32BitRate () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_MPlayMediaObject::clear_has_u32BitRate () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_MPlayMediaObject::set_has_u32MetaDataTag1 () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_MPlayMediaObject::clear_has_u32MetaDataTag1 () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_MPlayMediaObject::set_has_u32MetaDataTag2 () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_MPlayMediaObject::clear_has_u32MetaDataTag2 () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline void T_MPlayMediaObject::set_has_u32MetaDataTag3 () {
    _has_bits_[0] |= 1u << 24;
}

inline void T_MPlayMediaObject::clear_has_u32MetaDataTag3 () {
    _has_bits_[0] &= ~ (1u << 24);
}

inline void T_MPlayMediaObject::set_has_u32MetaDataTag4 () {
    _has_bits_[0] |= 1u << 25;
}

inline void T_MPlayMediaObject::clear_has_u32MetaDataTag4 () {
    _has_bits_[0] &= ~ (1u << 25);
}

inline void T_MPlayMediaObject::set_has_u32SampleRate () {
    _has_bits_[0] |= 1u << 26;
}

inline void T_MPlayMediaObject::clear_has_u32SampleRate () {
    _has_bits_[0] &= ~ (1u << 26);
}

inline void T_MPlayMediaObject::set_has_u32Tag () {
    _has_bits_[0] |= 1u << 27;
}

inline void T_MPlayMediaObject::clear_has_u32Tag () {
    _has_bits_[0] &= ~ (1u << 27);
}

inline void T_MPlayMediaObject::set_has_u32TotalPlaytime () {
    _has_bits_[0] |= 1u << 28;
}

inline void T_MPlayMediaObject::clear_has_u32TotalPlaytime () {
    _has_bits_[0] &= ~ (1u << 28);
}

inline void T_MPlayMediaObject::set_has_u32Year () {
    _has_bits_[0] |= 1u << 29;
}

inline void T_MPlayMediaObject::clear_has_u32Year () {
    _has_bits_[0] &= ~ (1u << 29);
}

inline void T_MPlayMediaObject::set_has_u32YearID () {
    _has_bits_[0] |= 1u << 30;
}

inline void T_MPlayMediaObject::clear_has_u32YearID () {
    _has_bits_[0] &= ~ (1u << 30);
}

inline void T_MPlayMediaObject::set_has_u64FileSize () {
    _has_bits_[0] |= 1u << 31;
}

inline void T_MPlayMediaObject::clear_has_u64FileSize () {
    _has_bits_[0] &= ~ (1u << 31);
}

inline void T_MPlayMediaObject::set_has_u8DeviceTag () {
    _has_bits_[1] |= 1u << 0;
}

inline void T_MPlayMediaObject::clear_has_u8DeviceTag () {
    _has_bits_[1] &= ~ (1u << 0);
}

inline void T_MPlayMediaObject::set_has_u8TrackNumber () {
    _has_bits_[1] |= 1u << 1;
}

inline void T_MPlayMediaObject::clear_has_u8TrackNumber () {
    _has_bits_[1] &= ~ (1u << 1);
}

inline void T_MPlayMediaObject::set_has_bIsFavorite () {
    _has_bits_[1] |= 1u << 2;
}

inline void T_MPlayMediaObject::clear_has_bIsFavorite () {
    _has_bits_[1] &= ~ (1u << 2);
}

inline  T_MPlayMediaObjectsItem::T_MPlayMediaObjectsItem ()  :
    _e8CategoryType (::MPlay_fi_types::T_e8_MPlayCategoryType__e8CTY_ALBUM),
    _e8DeviceType (::MPlay_fi_types::T_e8_MPlayDeviceType__e8DTY_BLUETOOTH),
    _e8FileFormat (::MPlay_fi_types::T_e8_MPlayFileFormat__e8FFT_3G2),
    _e8MediaType (::MPlay_fi_types::T_e8_MPlayMediaType__e8MRY_AUDIO_STREAM),
    _e8PlayableStatus (::MPlay_fi_types::T_e8_MPlayPlayableStatus__e8FP_DRM_PROTECTED),
    _oThumbnailData (),
    _bIsPlaying (false),
    _bReadOnlyFlag (false),
    _sAlbumArt (),
    _sCoverArt (),
    _sDateTime (),
    _sDeviceVersion (),
    _sFilename (),
    _sMetaDataField1 (),
    _sMetaDataField2 (),
    _sMetaDataField3 (),
    _sMetaDataField4 (),
    _u32MetaDataTag1 (0u),
    _u32MetaDataTag2 (0u),
    _u32MetaDataTag3 (0u),
    _u32MetaDataTag4 (0u),
    _sYomiMetaDataTitle (),
    _sYomiMetaDataArtist (),
    _sYomiMetaDataAlbum (),
    _u32Tag (0u),
    _u32TotalPlaytime (0u),
    _u32Year (0u),
    _u32YearID (0u),
    _u64FileSize (0u),
    _u8DeviceTag (0u),
    _u8TrackNumber (0u),
    _bIsFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MPlayMediaObjectsItem::T_MPlayMediaObjectsItem (const T_MPlayMediaObjectsItem &rhs)  :
    _e8CategoryType (::MPlay_fi_types::T_e8_MPlayCategoryType__e8CTY_ALBUM),
    _e8DeviceType (::MPlay_fi_types::T_e8_MPlayDeviceType__e8DTY_BLUETOOTH),
    _e8FileFormat (::MPlay_fi_types::T_e8_MPlayFileFormat__e8FFT_3G2),
    _e8MediaType (::MPlay_fi_types::T_e8_MPlayMediaType__e8MRY_AUDIO_STREAM),
    _e8PlayableStatus (::MPlay_fi_types::T_e8_MPlayPlayableStatus__e8FP_DRM_PROTECTED),
    _oThumbnailData (),
    _bIsPlaying (false),
    _bReadOnlyFlag (false),
    _sAlbumArt (),
    _sCoverArt (),
    _sDateTime (),
    _sDeviceVersion (),
    _sFilename (),
    _sMetaDataField1 (),
    _sMetaDataField2 (),
    _sMetaDataField3 (),
    _sMetaDataField4 (),
    _u32MetaDataTag1 (0u),
    _u32MetaDataTag2 (0u),
    _u32MetaDataTag3 (0u),
    _u32MetaDataTag4 (0u),
    _sYomiMetaDataTitle (),
    _sYomiMetaDataArtist (),
    _sYomiMetaDataAlbum (),
    _u32Tag (0u),
    _u32TotalPlaytime (0u),
    _u32Year (0u),
    _u32YearID (0u),
    _u64FileSize (0u),
    _u8DeviceTag (0u),
    _u8TrackNumber (0u),
    _bIsFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MPlayMediaObjectsItem::T_MPlayMediaObjectsItem (T_e8_MPlayCategoryType e8CategoryType_, T_e8_MPlayDeviceType e8DeviceType_, T_e8_MPlayFileFormat e8FileFormat_, T_e8_MPlayMediaType e8MediaType_, T_e8_MPlayPlayableStatus e8PlayableStatus_, const T_MPlayImageData& oThumbnailData_, bool bIsPlaying_, bool bReadOnlyFlag_, const ::std::string& sAlbumArt_, const ::std::string& sCoverArt_, const ::std::string& sDateTime_, const ::std::string& sDeviceVersion_, const ::std::string& sFilename_, const ::std::string& sMetaDataField1_, const ::std::string& sMetaDataField2_, const ::std::string& sMetaDataField3_, const ::std::string& sMetaDataField4_, uint32 u32MetaDataTag1_, uint32 u32MetaDataTag2_, uint32 u32MetaDataTag3_, uint32 u32MetaDataTag4_, const ::std::string& sYomiMetaDataTitle_, const ::std::string& sYomiMetaDataArtist_, const ::std::string& sYomiMetaDataAlbum_, uint32 u32Tag_, uint32 u32TotalPlaytime_, uint32 u32Year_, uint32 u32YearID_, uint64 u64FileSize_, uint8 u8DeviceTag_, uint8 u8TrackNumber_, bool bIsFavorite_)  :
    _e8CategoryType (e8CategoryType_),
    _e8DeviceType (e8DeviceType_),
    _e8FileFormat (e8FileFormat_),
    _e8MediaType (e8MediaType_),
    _e8PlayableStatus (e8PlayableStatus_),
    _oThumbnailData (oThumbnailData_),
    _bIsPlaying (bIsPlaying_),
    _bReadOnlyFlag (bReadOnlyFlag_),
    _sAlbumArt (sAlbumArt_),
    _sCoverArt (sCoverArt_),
    _sDateTime (sDateTime_),
    _sDeviceVersion (sDeviceVersion_),
    _sFilename (sFilename_),
    _sMetaDataField1 (sMetaDataField1_),
    _sMetaDataField2 (sMetaDataField2_),
    _sMetaDataField3 (sMetaDataField3_),
    _sMetaDataField4 (sMetaDataField4_),
    _u32MetaDataTag1 (u32MetaDataTag1_),
    _u32MetaDataTag2 (u32MetaDataTag2_),
    _u32MetaDataTag3 (u32MetaDataTag3_),
    _u32MetaDataTag4 (u32MetaDataTag4_),
    _sYomiMetaDataTitle (sYomiMetaDataTitle_),
    _sYomiMetaDataArtist (sYomiMetaDataArtist_),
    _sYomiMetaDataAlbum (sYomiMetaDataAlbum_),
    _u32Tag (u32Tag_),
    _u32TotalPlaytime (u32TotalPlaytime_),
    _u32Year (u32Year_),
    _u32YearID (u32YearID_),
    _u64FileSize (u64FileSize_),
    _u8DeviceTag (u8DeviceTag_),
    _u8TrackNumber (u8TrackNumber_),
    _bIsFavorite (bIsFavorite_)
{
    #ifndef NDEBUG
    if (!(T_e8_MPlayCategoryType_IsValid(e8CategoryType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CategoryType_, "T_e8_MPlayCategoryType", "e8CategoryType", "T_MPlayMediaObjectsItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceType_IsValid(e8DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceType_, "T_e8_MPlayDeviceType", "e8DeviceType", "T_MPlayMediaObjectsItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileFormat_IsValid(e8FileFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileFormat_, "T_e8_MPlayFileFormat", "e8FileFormat", "T_MPlayMediaObjectsItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayMediaType_IsValid(e8MediaType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MediaType_, "T_e8_MPlayMediaType", "e8MediaType", "T_MPlayMediaObjectsItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MPlayPlayableStatus_IsValid(e8PlayableStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PlayableStatus_, "T_e8_MPlayPlayableStatus", "e8PlayableStatus", "T_MPlayMediaObjectsItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbumArt_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCoverArt_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDateTime_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFilename_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField2_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField3_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField4_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataArtist_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MPlayMediaObjectsItem::~T_MPlayMediaObjectsItem() {
}

inline T_MPlayMediaObjectsItem& T_MPlayMediaObjectsItem::operator = (const T_MPlayMediaObjectsItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8CategoryType()) {
            setE8CategoryType(rhs.getE8CategoryType());
        } else {
            clearE8CategoryType();
        }
        if (rhs.hasE8DeviceType()) {
            setE8DeviceType(rhs.getE8DeviceType());
        } else {
            clearE8DeviceType();
        }
        if (rhs.hasE8FileFormat()) {
            setE8FileFormat(rhs.getE8FileFormat());
        } else {
            clearE8FileFormat();
        }
        if (rhs.hasE8MediaType()) {
            setE8MediaType(rhs.getE8MediaType());
        } else {
            clearE8MediaType();
        }
        if (rhs.hasE8PlayableStatus()) {
            setE8PlayableStatus(rhs.getE8PlayableStatus());
        } else {
            clearE8PlayableStatus();
        }
        if (rhs.hasOThumbnailData()) {
            setOThumbnailData(rhs.getOThumbnailData());
        } else {
            clearOThumbnailData();
        }
        if (rhs.hasBIsPlaying()) {
            setBIsPlaying(rhs.getBIsPlaying());
        } else {
            clearBIsPlaying();
        }
        if (rhs.hasBReadOnlyFlag()) {
            setBReadOnlyFlag(rhs.getBReadOnlyFlag());
        } else {
            clearBReadOnlyFlag();
        }
        if (rhs.hasSAlbumArt()) {
            setSAlbumArt(rhs.getSAlbumArt());
        } else {
            clearSAlbumArt();
        }
        if (rhs.hasSCoverArt()) {
            setSCoverArt(rhs.getSCoverArt());
        } else {
            clearSCoverArt();
        }
        if (rhs.hasSDateTime()) {
            setSDateTime(rhs.getSDateTime());
        } else {
            clearSDateTime();
        }
        if (rhs.hasSDeviceVersion()) {
            setSDeviceVersion(rhs.getSDeviceVersion());
        } else {
            clearSDeviceVersion();
        }
        if (rhs.hasSFilename()) {
            setSFilename(rhs.getSFilename());
        } else {
            clearSFilename();
        }
        if (rhs.hasSMetaDataField1()) {
            setSMetaDataField1(rhs.getSMetaDataField1());
        } else {
            clearSMetaDataField1();
        }
        if (rhs.hasSMetaDataField2()) {
            setSMetaDataField2(rhs.getSMetaDataField2());
        } else {
            clearSMetaDataField2();
        }
        if (rhs.hasSMetaDataField3()) {
            setSMetaDataField3(rhs.getSMetaDataField3());
        } else {
            clearSMetaDataField3();
        }
        if (rhs.hasSMetaDataField4()) {
            setSMetaDataField4(rhs.getSMetaDataField4());
        } else {
            clearSMetaDataField4();
        }
        if (rhs.hasU32MetaDataTag1()) {
            setU32MetaDataTag1(rhs.getU32MetaDataTag1());
        } else {
            clearU32MetaDataTag1();
        }
        if (rhs.hasU32MetaDataTag2()) {
            setU32MetaDataTag2(rhs.getU32MetaDataTag2());
        } else {
            clearU32MetaDataTag2();
        }
        if (rhs.hasU32MetaDataTag3()) {
            setU32MetaDataTag3(rhs.getU32MetaDataTag3());
        } else {
            clearU32MetaDataTag3();
        }
        if (rhs.hasU32MetaDataTag4()) {
            setU32MetaDataTag4(rhs.getU32MetaDataTag4());
        } else {
            clearU32MetaDataTag4();
        }
        if (rhs.hasSYomiMetaDataTitle()) {
            setSYomiMetaDataTitle(rhs.getSYomiMetaDataTitle());
        } else {
            clearSYomiMetaDataTitle();
        }
        if (rhs.hasSYomiMetaDataArtist()) {
            setSYomiMetaDataArtist(rhs.getSYomiMetaDataArtist());
        } else {
            clearSYomiMetaDataArtist();
        }
        if (rhs.hasSYomiMetaDataAlbum()) {
            setSYomiMetaDataAlbum(rhs.getSYomiMetaDataAlbum());
        } else {
            clearSYomiMetaDataAlbum();
        }
        if (rhs.hasU32Tag()) {
            setU32Tag(rhs.getU32Tag());
        } else {
            clearU32Tag();
        }
        if (rhs.hasU32TotalPlaytime()) {
            setU32TotalPlaytime(rhs.getU32TotalPlaytime());
        } else {
            clearU32TotalPlaytime();
        }
        if (rhs.hasU32Year()) {
            setU32Year(rhs.getU32Year());
        } else {
            clearU32Year();
        }
        if (rhs.hasU32YearID()) {
            setU32YearID(rhs.getU32YearID());
        } else {
            clearU32YearID();
        }
        if (rhs.hasU64FileSize()) {
            setU64FileSize(rhs.getU64FileSize());
        } else {
            clearU64FileSize();
        }
        if (rhs.hasU8DeviceTag()) {
            setU8DeviceTag(rhs.getU8DeviceTag());
        } else {
            clearU8DeviceTag();
        }
        if (rhs.hasU8TrackNumber()) {
            setU8TrackNumber(rhs.getU8TrackNumber());
        } else {
            clearU8TrackNumber();
        }
        if (rhs.hasBIsFavorite()) {
            setBIsFavorite(rhs.getBIsFavorite());
        } else {
            clearBIsFavorite();
        }
    }
    return *this;
}

inline bool T_MPlayMediaObjectsItem::operator == (const T_MPlayMediaObjectsItem& rhs) const {
    return (((!hasE8CategoryType() && !rhs.hasE8CategoryType()) || getE8CategoryType() == rhs.getE8CategoryType()) &&
        ((!hasE8DeviceType() && !rhs.hasE8DeviceType()) || getE8DeviceType() == rhs.getE8DeviceType()) &&
        ((!hasE8FileFormat() && !rhs.hasE8FileFormat()) || getE8FileFormat() == rhs.getE8FileFormat()) &&
        ((!hasE8MediaType() && !rhs.hasE8MediaType()) || getE8MediaType() == rhs.getE8MediaType()) &&
        ((!hasE8PlayableStatus() && !rhs.hasE8PlayableStatus()) || getE8PlayableStatus() == rhs.getE8PlayableStatus()) &&
        ((!hasOThumbnailData() && !rhs.hasOThumbnailData()) || getOThumbnailData() == rhs.getOThumbnailData()) &&
        ((!hasBIsPlaying() && !rhs.hasBIsPlaying()) || getBIsPlaying() == rhs.getBIsPlaying()) &&
        ((!hasBReadOnlyFlag() && !rhs.hasBReadOnlyFlag()) || getBReadOnlyFlag() == rhs.getBReadOnlyFlag()) &&
        ((!hasSAlbumArt() && !rhs.hasSAlbumArt()) || getSAlbumArt() == rhs.getSAlbumArt()) &&
        ((!hasSCoverArt() && !rhs.hasSCoverArt()) || getSCoverArt() == rhs.getSCoverArt()) &&
        ((!hasSDateTime() && !rhs.hasSDateTime()) || getSDateTime() == rhs.getSDateTime()) &&
        ((!hasSDeviceVersion() && !rhs.hasSDeviceVersion()) || getSDeviceVersion() == rhs.getSDeviceVersion()) &&
        ((!hasSFilename() && !rhs.hasSFilename()) || getSFilename() == rhs.getSFilename()) &&
        ((!hasSMetaDataField1() && !rhs.hasSMetaDataField1()) || getSMetaDataField1() == rhs.getSMetaDataField1()) &&
        ((!hasSMetaDataField2() && !rhs.hasSMetaDataField2()) || getSMetaDataField2() == rhs.getSMetaDataField2()) &&
        ((!hasSMetaDataField3() && !rhs.hasSMetaDataField3()) || getSMetaDataField3() == rhs.getSMetaDataField3()) &&
        ((!hasSMetaDataField4() && !rhs.hasSMetaDataField4()) || getSMetaDataField4() == rhs.getSMetaDataField4()) &&
        ((!hasU32MetaDataTag1() && !rhs.hasU32MetaDataTag1()) || getU32MetaDataTag1() == rhs.getU32MetaDataTag1()) &&
        ((!hasU32MetaDataTag2() && !rhs.hasU32MetaDataTag2()) || getU32MetaDataTag2() == rhs.getU32MetaDataTag2()) &&
        ((!hasU32MetaDataTag3() && !rhs.hasU32MetaDataTag3()) || getU32MetaDataTag3() == rhs.getU32MetaDataTag3()) &&
        ((!hasU32MetaDataTag4() && !rhs.hasU32MetaDataTag4()) || getU32MetaDataTag4() == rhs.getU32MetaDataTag4()) &&
        ((!hasSYomiMetaDataTitle() && !rhs.hasSYomiMetaDataTitle()) || getSYomiMetaDataTitle() == rhs.getSYomiMetaDataTitle()) &&
        ((!hasSYomiMetaDataArtist() && !rhs.hasSYomiMetaDataArtist()) || getSYomiMetaDataArtist() == rhs.getSYomiMetaDataArtist()) &&
        ((!hasSYomiMetaDataAlbum() && !rhs.hasSYomiMetaDataAlbum()) || getSYomiMetaDataAlbum() == rhs.getSYomiMetaDataAlbum()) &&
        ((!hasU32Tag() && !rhs.hasU32Tag()) || getU32Tag() == rhs.getU32Tag()) &&
        ((!hasU32TotalPlaytime() && !rhs.hasU32TotalPlaytime()) || getU32TotalPlaytime() == rhs.getU32TotalPlaytime()) &&
        ((!hasU32Year() && !rhs.hasU32Year()) || getU32Year() == rhs.getU32Year()) &&
        ((!hasU32YearID() && !rhs.hasU32YearID()) || getU32YearID() == rhs.getU32YearID()) &&
        ((!hasU64FileSize() && !rhs.hasU64FileSize()) || getU64FileSize() == rhs.getU64FileSize()) &&
        ((!hasU8DeviceTag() && !rhs.hasU8DeviceTag()) || getU8DeviceTag() == rhs.getU8DeviceTag()) &&
        ((!hasU8TrackNumber() && !rhs.hasU8TrackNumber()) || getU8TrackNumber() == rhs.getU8TrackNumber()) &&
        ((!hasBIsFavorite() && !rhs.hasBIsFavorite()) || getBIsFavorite() == rhs.getBIsFavorite()));
}

inline bool T_MPlayMediaObjectsItem::operator != (const T_MPlayMediaObjectsItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MPlayMediaObjectsItem::operator < (const T_MPlayMediaObjectsItem& rhs) const {
    if (hasE8CategoryType() || rhs.hasE8CategoryType()) {
        if ((uint32)getE8CategoryType() < (uint32)rhs.getE8CategoryType()) return true;
        if ((uint32)getE8CategoryType() > (uint32)rhs.getE8CategoryType()) return false;
    }
    if (hasE8DeviceType() || rhs.hasE8DeviceType()) {
        if ((uint32)getE8DeviceType() < (uint32)rhs.getE8DeviceType()) return true;
        if ((uint32)getE8DeviceType() > (uint32)rhs.getE8DeviceType()) return false;
    }
    if (hasE8FileFormat() || rhs.hasE8FileFormat()) {
        if ((uint32)getE8FileFormat() < (uint32)rhs.getE8FileFormat()) return true;
        if ((uint32)getE8FileFormat() > (uint32)rhs.getE8FileFormat()) return false;
    }
    if (hasE8MediaType() || rhs.hasE8MediaType()) {
        if ((uint32)getE8MediaType() < (uint32)rhs.getE8MediaType()) return true;
        if ((uint32)getE8MediaType() > (uint32)rhs.getE8MediaType()) return false;
    }
    if (hasE8PlayableStatus() || rhs.hasE8PlayableStatus()) {
        if ((uint32)getE8PlayableStatus() < (uint32)rhs.getE8PlayableStatus()) return true;
        if ((uint32)getE8PlayableStatus() > (uint32)rhs.getE8PlayableStatus()) return false;
    }
    if (hasOThumbnailData() || rhs.hasOThumbnailData()) {
        if (getOThumbnailData() < rhs.getOThumbnailData()) return true;
        if (getOThumbnailData() > rhs.getOThumbnailData()) return false;
    }
    if (hasBIsPlaying() || rhs.hasBIsPlaying()) {
        if (getBIsPlaying() < rhs.getBIsPlaying()) return true;
        if (getBIsPlaying() > rhs.getBIsPlaying()) return false;
    }
    if (hasBReadOnlyFlag() || rhs.hasBReadOnlyFlag()) {
        if (getBReadOnlyFlag() < rhs.getBReadOnlyFlag()) return true;
        if (getBReadOnlyFlag() > rhs.getBReadOnlyFlag()) return false;
    }
    if (hasSAlbumArt() || rhs.hasSAlbumArt()) {
        if (getSAlbumArt() < rhs.getSAlbumArt()) return true;
        if (getSAlbumArt() > rhs.getSAlbumArt()) return false;
    }
    if (hasSCoverArt() || rhs.hasSCoverArt()) {
        if (getSCoverArt() < rhs.getSCoverArt()) return true;
        if (getSCoverArt() > rhs.getSCoverArt()) return false;
    }
    if (hasSDateTime() || rhs.hasSDateTime()) {
        if (getSDateTime() < rhs.getSDateTime()) return true;
        if (getSDateTime() > rhs.getSDateTime()) return false;
    }
    if (hasSDeviceVersion() || rhs.hasSDeviceVersion()) {
        if (getSDeviceVersion() < rhs.getSDeviceVersion()) return true;
        if (getSDeviceVersion() > rhs.getSDeviceVersion()) return false;
    }
    if (hasSFilename() || rhs.hasSFilename()) {
        if (getSFilename() < rhs.getSFilename()) return true;
        if (getSFilename() > rhs.getSFilename()) return false;
    }
    if (hasSMetaDataField1() || rhs.hasSMetaDataField1()) {
        if (getSMetaDataField1() < rhs.getSMetaDataField1()) return true;
        if (getSMetaDataField1() > rhs.getSMetaDataField1()) return false;
    }
    if (hasSMetaDataField2() || rhs.hasSMetaDataField2()) {
        if (getSMetaDataField2() < rhs.getSMetaDataField2()) return true;
        if (getSMetaDataField2() > rhs.getSMetaDataField2()) return false;
    }
    if (hasSMetaDataField3() || rhs.hasSMetaDataField3()) {
        if (getSMetaDataField3() < rhs.getSMetaDataField3()) return true;
        if (getSMetaDataField3() > rhs.getSMetaDataField3()) return false;
    }
    if (hasSMetaDataField4() || rhs.hasSMetaDataField4()) {
        if (getSMetaDataField4() < rhs.getSMetaDataField4()) return true;
        if (getSMetaDataField4() > rhs.getSMetaDataField4()) return false;
    }
    if (hasU32MetaDataTag1() || rhs.hasU32MetaDataTag1()) {
        if (getU32MetaDataTag1() < rhs.getU32MetaDataTag1()) return true;
        if (getU32MetaDataTag1() > rhs.getU32MetaDataTag1()) return false;
    }
    if (hasU32MetaDataTag2() || rhs.hasU32MetaDataTag2()) {
        if (getU32MetaDataTag2() < rhs.getU32MetaDataTag2()) return true;
        if (getU32MetaDataTag2() > rhs.getU32MetaDataTag2()) return false;
    }
    if (hasU32MetaDataTag3() || rhs.hasU32MetaDataTag3()) {
        if (getU32MetaDataTag3() < rhs.getU32MetaDataTag3()) return true;
        if (getU32MetaDataTag3() > rhs.getU32MetaDataTag3()) return false;
    }
    if (hasU32MetaDataTag4() || rhs.hasU32MetaDataTag4()) {
        if (getU32MetaDataTag4() < rhs.getU32MetaDataTag4()) return true;
        if (getU32MetaDataTag4() > rhs.getU32MetaDataTag4()) return false;
    }
    if (hasSYomiMetaDataTitle() || rhs.hasSYomiMetaDataTitle()) {
        if (getSYomiMetaDataTitle() < rhs.getSYomiMetaDataTitle()) return true;
        if (getSYomiMetaDataTitle() > rhs.getSYomiMetaDataTitle()) return false;
    }
    if (hasSYomiMetaDataArtist() || rhs.hasSYomiMetaDataArtist()) {
        if (getSYomiMetaDataArtist() < rhs.getSYomiMetaDataArtist()) return true;
        if (getSYomiMetaDataArtist() > rhs.getSYomiMetaDataArtist()) return false;
    }
    if (hasSYomiMetaDataAlbum() || rhs.hasSYomiMetaDataAlbum()) {
        if (getSYomiMetaDataAlbum() < rhs.getSYomiMetaDataAlbum()) return true;
        if (getSYomiMetaDataAlbum() > rhs.getSYomiMetaDataAlbum()) return false;
    }
    if (hasU32Tag() || rhs.hasU32Tag()) {
        if (getU32Tag() < rhs.getU32Tag()) return true;
        if (getU32Tag() > rhs.getU32Tag()) return false;
    }
    if (hasU32TotalPlaytime() || rhs.hasU32TotalPlaytime()) {
        if (getU32TotalPlaytime() < rhs.getU32TotalPlaytime()) return true;
        if (getU32TotalPlaytime() > rhs.getU32TotalPlaytime()) return false;
    }
    if (hasU32Year() || rhs.hasU32Year()) {
        if (getU32Year() < rhs.getU32Year()) return true;
        if (getU32Year() > rhs.getU32Year()) return false;
    }
    if (hasU32YearID() || rhs.hasU32YearID()) {
        if (getU32YearID() < rhs.getU32YearID()) return true;
        if (getU32YearID() > rhs.getU32YearID()) return false;
    }
    if (hasU64FileSize() || rhs.hasU64FileSize()) {
        if (getU64FileSize() < rhs.getU64FileSize()) return true;
        if (getU64FileSize() > rhs.getU64FileSize()) return false;
    }
    if (hasU8DeviceTag() || rhs.hasU8DeviceTag()) {
        if (getU8DeviceTag() < rhs.getU8DeviceTag()) return true;
        if (getU8DeviceTag() > rhs.getU8DeviceTag()) return false;
    }
    if (hasU8TrackNumber() || rhs.hasU8TrackNumber()) {
        if (getU8TrackNumber() < rhs.getU8TrackNumber()) return true;
        if (getU8TrackNumber() > rhs.getU8TrackNumber()) return false;
    }
    if (hasBIsFavorite() || rhs.hasBIsFavorite()) {
        if (getBIsFavorite() < rhs.getBIsFavorite()) return true;
        if (getBIsFavorite() > rhs.getBIsFavorite()) return false;
    }
    return false;
}

inline bool T_MPlayMediaObjectsItem::operator > (const T_MPlayMediaObjectsItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MPlayMediaObjectsItem::clear() {
    clearE8CategoryType();
    clearE8DeviceType();
    clearE8FileFormat();
    clearE8MediaType();
    clearE8PlayableStatus();
    clearOThumbnailData();
    clearBIsPlaying();
    clearBReadOnlyFlag();
    clearSAlbumArt();
    clearSCoverArt();
    clearSDateTime();
    clearSDeviceVersion();
    clearSFilename();
    clearSMetaDataField1();
    clearSMetaDataField2();
    clearSMetaDataField3();
    clearSMetaDataField4();
    clearU32MetaDataTag1();
    clearU32MetaDataTag2();
    clearU32MetaDataTag3();
    clearU32MetaDataTag4();
    clearSYomiMetaDataTitle();
    clearSYomiMetaDataArtist();
    clearSYomiMetaDataAlbum();
    clearU32Tag();
    clearU32TotalPlaytime();
    clearU32Year();
    clearU32YearID();
    clearU64FileSize();
    clearU8DeviceTag();
    clearU8TrackNumber();
    clearBIsFavorite();
}

inline void T_MPlayMediaObjectsItem::clearE8CategoryType() {
    if (hasE8CategoryType()) {
         clear_has_e8CategoryType();
        _e8CategoryType = ::MPlay_fi_types::T_e8_MPlayCategoryType__e8CTY_ALBUM;
     }
}

inline bool T_MPlayMediaObjectsItem::hasE8CategoryType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_MPlayCategoryType T_MPlayMediaObjectsItem::getE8CategoryType () const {
    return _e8CategoryType;
}

inline void T_MPlayMediaObjectsItem::setE8CategoryType (T_e8_MPlayCategoryType e8CategoryType_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayCategoryType_IsValid(e8CategoryType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CategoryType_, "T_e8_MPlayCategoryType", "e8CategoryType", "T_MPlayMediaObjectsItem");
    }
    #endif
    set_has_e8CategoryType();
    this->_e8CategoryType = e8CategoryType_;
}

inline void T_MPlayMediaObjectsItem::clearE8DeviceType() {
    if (hasE8DeviceType()) {
         clear_has_e8DeviceType();
        _e8DeviceType = ::MPlay_fi_types::T_e8_MPlayDeviceType__e8DTY_BLUETOOTH;
     }
}

inline bool T_MPlayMediaObjectsItem::hasE8DeviceType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_MPlayDeviceType T_MPlayMediaObjectsItem::getE8DeviceType () const {
    return _e8DeviceType;
}

inline void T_MPlayMediaObjectsItem::setE8DeviceType (T_e8_MPlayDeviceType e8DeviceType_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceType_IsValid(e8DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceType_, "T_e8_MPlayDeviceType", "e8DeviceType", "T_MPlayMediaObjectsItem");
    }
    #endif
    set_has_e8DeviceType();
    this->_e8DeviceType = e8DeviceType_;
}

inline void T_MPlayMediaObjectsItem::clearE8FileFormat() {
    if (hasE8FileFormat()) {
         clear_has_e8FileFormat();
        _e8FileFormat = ::MPlay_fi_types::T_e8_MPlayFileFormat__e8FFT_3G2;
     }
}

inline bool T_MPlayMediaObjectsItem::hasE8FileFormat () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_MPlayFileFormat T_MPlayMediaObjectsItem::getE8FileFormat () const {
    return _e8FileFormat;
}

inline void T_MPlayMediaObjectsItem::setE8FileFormat (T_e8_MPlayFileFormat e8FileFormat_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayFileFormat_IsValid(e8FileFormat_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FileFormat_, "T_e8_MPlayFileFormat", "e8FileFormat", "T_MPlayMediaObjectsItem");
    }
    #endif
    set_has_e8FileFormat();
    this->_e8FileFormat = e8FileFormat_;
}

inline void T_MPlayMediaObjectsItem::clearE8MediaType() {
    if (hasE8MediaType()) {
         clear_has_e8MediaType();
        _e8MediaType = ::MPlay_fi_types::T_e8_MPlayMediaType__e8MRY_AUDIO_STREAM;
     }
}

inline bool T_MPlayMediaObjectsItem::hasE8MediaType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_MPlayMediaType T_MPlayMediaObjectsItem::getE8MediaType () const {
    return _e8MediaType;
}

inline void T_MPlayMediaObjectsItem::setE8MediaType (T_e8_MPlayMediaType e8MediaType_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayMediaType_IsValid(e8MediaType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MediaType_, "T_e8_MPlayMediaType", "e8MediaType", "T_MPlayMediaObjectsItem");
    }
    #endif
    set_has_e8MediaType();
    this->_e8MediaType = e8MediaType_;
}

inline void T_MPlayMediaObjectsItem::clearE8PlayableStatus() {
    if (hasE8PlayableStatus()) {
         clear_has_e8PlayableStatus();
        _e8PlayableStatus = ::MPlay_fi_types::T_e8_MPlayPlayableStatus__e8FP_DRM_PROTECTED;
     }
}

inline bool T_MPlayMediaObjectsItem::hasE8PlayableStatus () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_MPlayPlayableStatus T_MPlayMediaObjectsItem::getE8PlayableStatus () const {
    return _e8PlayableStatus;
}

inline void T_MPlayMediaObjectsItem::setE8PlayableStatus (T_e8_MPlayPlayableStatus e8PlayableStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayPlayableStatus_IsValid(e8PlayableStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PlayableStatus_, "T_e8_MPlayPlayableStatus", "e8PlayableStatus", "T_MPlayMediaObjectsItem");
    }
    #endif
    set_has_e8PlayableStatus();
    this->_e8PlayableStatus = e8PlayableStatus_;
}

inline void T_MPlayMediaObjectsItem::clearOThumbnailData() {
    if (hasOThumbnailData()) {
         clear_has_oThumbnailData();
        _oThumbnailData.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasOThumbnailData () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_MPlayImageData& T_MPlayMediaObjectsItem::getOThumbnailData () const {
    return _oThumbnailData;
}

inline T_MPlayImageData& T_MPlayMediaObjectsItem::getOThumbnailDataMutable () {
    set_has_oThumbnailData();
    return _oThumbnailData;
}

inline void T_MPlayMediaObjectsItem::setOThumbnailData (const T_MPlayImageData& oThumbnailData_) {
    set_has_oThumbnailData();
    this->_oThumbnailData = oThumbnailData_;
}

inline void T_MPlayMediaObjectsItem::clearBIsPlaying() {
    if (hasBIsPlaying()) {
         clear_has_bIsPlaying();
        _bIsPlaying = false;
     }
}

inline bool T_MPlayMediaObjectsItem::hasBIsPlaying () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_MPlayMediaObjectsItem::getBIsPlaying () const {
    return _bIsPlaying;
}

inline void T_MPlayMediaObjectsItem::setBIsPlaying (bool bIsPlaying_) {
    set_has_bIsPlaying();
    this->_bIsPlaying = bIsPlaying_;
}

inline void T_MPlayMediaObjectsItem::clearBReadOnlyFlag() {
    if (hasBReadOnlyFlag()) {
         clear_has_bReadOnlyFlag();
        _bReadOnlyFlag = false;
     }
}

inline bool T_MPlayMediaObjectsItem::hasBReadOnlyFlag () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_MPlayMediaObjectsItem::getBReadOnlyFlag () const {
    return _bReadOnlyFlag;
}

inline void T_MPlayMediaObjectsItem::setBReadOnlyFlag (bool bReadOnlyFlag_) {
    set_has_bReadOnlyFlag();
    this->_bReadOnlyFlag = bReadOnlyFlag_;
}

inline void T_MPlayMediaObjectsItem::clearSAlbumArt() {
    if (hasSAlbumArt()) {
         clear_has_sAlbumArt();
        _sAlbumArt.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasSAlbumArt () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_MPlayMediaObjectsItem::getSAlbumArt () const {
    return _sAlbumArt;
}

inline ::std::string& T_MPlayMediaObjectsItem::getSAlbumArtMutable () {
    set_has_sAlbumArt();
    return _sAlbumArt;
}

inline void T_MPlayMediaObjectsItem::setSAlbumArt (const ::std::string& sAlbumArt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbumArt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbumArt();
    this->_sAlbumArt = sAlbumArt_;
}

inline void T_MPlayMediaObjectsItem::setSAlbumArt (const char* sAlbumArt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbumArt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbumArt();
    this->_sAlbumArt.assign(sAlbumArt_);
}

inline void T_MPlayMediaObjectsItem::setSAlbumArt (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbumArt();
    this->_sAlbumArt.assign(value, size);
}

inline void T_MPlayMediaObjectsItem::clearSCoverArt() {
    if (hasSCoverArt()) {
         clear_has_sCoverArt();
        _sCoverArt.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasSCoverArt () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_MPlayMediaObjectsItem::getSCoverArt () const {
    return _sCoverArt;
}

inline ::std::string& T_MPlayMediaObjectsItem::getSCoverArtMutable () {
    set_has_sCoverArt();
    return _sCoverArt;
}

inline void T_MPlayMediaObjectsItem::setSCoverArt (const ::std::string& sCoverArt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCoverArt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCoverArt();
    this->_sCoverArt = sCoverArt_;
}

inline void T_MPlayMediaObjectsItem::setSCoverArt (const char* sCoverArt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCoverArt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCoverArt();
    this->_sCoverArt.assign(sCoverArt_);
}

inline void T_MPlayMediaObjectsItem::setSCoverArt (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCoverArt();
    this->_sCoverArt.assign(value, size);
}

inline void T_MPlayMediaObjectsItem::clearSDateTime() {
    if (hasSDateTime()) {
         clear_has_sDateTime();
        _sDateTime.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasSDateTime () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_MPlayMediaObjectsItem::getSDateTime () const {
    return _sDateTime;
}

inline ::std::string& T_MPlayMediaObjectsItem::getSDateTimeMutable () {
    set_has_sDateTime();
    return _sDateTime;
}

inline void T_MPlayMediaObjectsItem::setSDateTime (const ::std::string& sDateTime_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDateTime_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDateTime();
    this->_sDateTime = sDateTime_;
}

inline void T_MPlayMediaObjectsItem::setSDateTime (const char* sDateTime_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDateTime_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDateTime();
    this->_sDateTime.assign(sDateTime_);
}

inline void T_MPlayMediaObjectsItem::setSDateTime (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDateTime();
    this->_sDateTime.assign(value, size);
}

inline void T_MPlayMediaObjectsItem::clearSDeviceVersion() {
    if (hasSDeviceVersion()) {
         clear_has_sDeviceVersion();
        _sDeviceVersion.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasSDeviceVersion () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_MPlayMediaObjectsItem::getSDeviceVersion () const {
    return _sDeviceVersion;
}

inline ::std::string& T_MPlayMediaObjectsItem::getSDeviceVersionMutable () {
    set_has_sDeviceVersion();
    return _sDeviceVersion;
}

inline void T_MPlayMediaObjectsItem::setSDeviceVersion (const ::std::string& sDeviceVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceVersion();
    this->_sDeviceVersion = sDeviceVersion_;
}

inline void T_MPlayMediaObjectsItem::setSDeviceVersion (const char* sDeviceVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceVersion();
    this->_sDeviceVersion.assign(sDeviceVersion_);
}

inline void T_MPlayMediaObjectsItem::setSDeviceVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceVersion();
    this->_sDeviceVersion.assign(value, size);
}

inline void T_MPlayMediaObjectsItem::clearSFilename() {
    if (hasSFilename()) {
         clear_has_sFilename();
        _sFilename.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasSFilename () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::string& T_MPlayMediaObjectsItem::getSFilename () const {
    return _sFilename;
}

inline ::std::string& T_MPlayMediaObjectsItem::getSFilenameMutable () {
    set_has_sFilename();
    return _sFilename;
}

inline void T_MPlayMediaObjectsItem::setSFilename (const ::std::string& sFilename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFilename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFilename();
    this->_sFilename = sFilename_;
}

inline void T_MPlayMediaObjectsItem::setSFilename (const char* sFilename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFilename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFilename();
    this->_sFilename.assign(sFilename_);
}

inline void T_MPlayMediaObjectsItem::setSFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFilename();
    this->_sFilename.assign(value, size);
}

inline void T_MPlayMediaObjectsItem::clearSMetaDataField1() {
    if (hasSMetaDataField1()) {
         clear_has_sMetaDataField1();
        _sMetaDataField1.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasSMetaDataField1 () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline const ::std::string& T_MPlayMediaObjectsItem::getSMetaDataField1 () const {
    return _sMetaDataField1;
}

inline ::std::string& T_MPlayMediaObjectsItem::getSMetaDataField1Mutable () {
    set_has_sMetaDataField1();
    return _sMetaDataField1;
}

inline void T_MPlayMediaObjectsItem::setSMetaDataField1 (const ::std::string& sMetaDataField1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField1();
    this->_sMetaDataField1 = sMetaDataField1_;
}

inline void T_MPlayMediaObjectsItem::setSMetaDataField1 (const char* sMetaDataField1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField1();
    this->_sMetaDataField1.assign(sMetaDataField1_);
}

inline void T_MPlayMediaObjectsItem::setSMetaDataField1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField1();
    this->_sMetaDataField1.assign(value, size);
}

inline void T_MPlayMediaObjectsItem::clearSMetaDataField2() {
    if (hasSMetaDataField2()) {
         clear_has_sMetaDataField2();
        _sMetaDataField2.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasSMetaDataField2 () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const ::std::string& T_MPlayMediaObjectsItem::getSMetaDataField2 () const {
    return _sMetaDataField2;
}

inline ::std::string& T_MPlayMediaObjectsItem::getSMetaDataField2Mutable () {
    set_has_sMetaDataField2();
    return _sMetaDataField2;
}

inline void T_MPlayMediaObjectsItem::setSMetaDataField2 (const ::std::string& sMetaDataField2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField2();
    this->_sMetaDataField2 = sMetaDataField2_;
}

inline void T_MPlayMediaObjectsItem::setSMetaDataField2 (const char* sMetaDataField2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField2();
    this->_sMetaDataField2.assign(sMetaDataField2_);
}

inline void T_MPlayMediaObjectsItem::setSMetaDataField2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField2();
    this->_sMetaDataField2.assign(value, size);
}

inline void T_MPlayMediaObjectsItem::clearSMetaDataField3() {
    if (hasSMetaDataField3()) {
         clear_has_sMetaDataField3();
        _sMetaDataField3.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasSMetaDataField3 () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline const ::std::string& T_MPlayMediaObjectsItem::getSMetaDataField3 () const {
    return _sMetaDataField3;
}

inline ::std::string& T_MPlayMediaObjectsItem::getSMetaDataField3Mutable () {
    set_has_sMetaDataField3();
    return _sMetaDataField3;
}

inline void T_MPlayMediaObjectsItem::setSMetaDataField3 (const ::std::string& sMetaDataField3_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField3_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField3();
    this->_sMetaDataField3 = sMetaDataField3_;
}

inline void T_MPlayMediaObjectsItem::setSMetaDataField3 (const char* sMetaDataField3_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField3_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField3();
    this->_sMetaDataField3.assign(sMetaDataField3_);
}

inline void T_MPlayMediaObjectsItem::setSMetaDataField3 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField3();
    this->_sMetaDataField3.assign(value, size);
}

inline void T_MPlayMediaObjectsItem::clearSMetaDataField4() {
    if (hasSMetaDataField4()) {
         clear_has_sMetaDataField4();
        _sMetaDataField4.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasSMetaDataField4 () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline const ::std::string& T_MPlayMediaObjectsItem::getSMetaDataField4 () const {
    return _sMetaDataField4;
}

inline ::std::string& T_MPlayMediaObjectsItem::getSMetaDataField4Mutable () {
    set_has_sMetaDataField4();
    return _sMetaDataField4;
}

inline void T_MPlayMediaObjectsItem::setSMetaDataField4 (const ::std::string& sMetaDataField4_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField4_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField4();
    this->_sMetaDataField4 = sMetaDataField4_;
}

inline void T_MPlayMediaObjectsItem::setSMetaDataField4 (const char* sMetaDataField4_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMetaDataField4_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField4();
    this->_sMetaDataField4.assign(sMetaDataField4_);
}

inline void T_MPlayMediaObjectsItem::setSMetaDataField4 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMetaDataField4();
    this->_sMetaDataField4.assign(value, size);
}

inline void T_MPlayMediaObjectsItem::clearU32MetaDataTag1() {
    if (hasU32MetaDataTag1()) {
         clear_has_u32MetaDataTag1();
        _u32MetaDataTag1 = 0u;
     }
}

inline bool T_MPlayMediaObjectsItem::hasU32MetaDataTag1 () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline uint32 T_MPlayMediaObjectsItem::getU32MetaDataTag1 () const {
    return _u32MetaDataTag1;
}

inline void T_MPlayMediaObjectsItem::setU32MetaDataTag1 (uint32 u32MetaDataTag1_) {
    set_has_u32MetaDataTag1();
    this->_u32MetaDataTag1 = u32MetaDataTag1_;
}

inline void T_MPlayMediaObjectsItem::clearU32MetaDataTag2() {
    if (hasU32MetaDataTag2()) {
         clear_has_u32MetaDataTag2();
        _u32MetaDataTag2 = 0u;
     }
}

inline bool T_MPlayMediaObjectsItem::hasU32MetaDataTag2 () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline uint32 T_MPlayMediaObjectsItem::getU32MetaDataTag2 () const {
    return _u32MetaDataTag2;
}

inline void T_MPlayMediaObjectsItem::setU32MetaDataTag2 (uint32 u32MetaDataTag2_) {
    set_has_u32MetaDataTag2();
    this->_u32MetaDataTag2 = u32MetaDataTag2_;
}

inline void T_MPlayMediaObjectsItem::clearU32MetaDataTag3() {
    if (hasU32MetaDataTag3()) {
         clear_has_u32MetaDataTag3();
        _u32MetaDataTag3 = 0u;
     }
}

inline bool T_MPlayMediaObjectsItem::hasU32MetaDataTag3 () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline uint32 T_MPlayMediaObjectsItem::getU32MetaDataTag3 () const {
    return _u32MetaDataTag3;
}

inline void T_MPlayMediaObjectsItem::setU32MetaDataTag3 (uint32 u32MetaDataTag3_) {
    set_has_u32MetaDataTag3();
    this->_u32MetaDataTag3 = u32MetaDataTag3_;
}

inline void T_MPlayMediaObjectsItem::clearU32MetaDataTag4() {
    if (hasU32MetaDataTag4()) {
         clear_has_u32MetaDataTag4();
        _u32MetaDataTag4 = 0u;
     }
}

inline bool T_MPlayMediaObjectsItem::hasU32MetaDataTag4 () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline uint32 T_MPlayMediaObjectsItem::getU32MetaDataTag4 () const {
    return _u32MetaDataTag4;
}

inline void T_MPlayMediaObjectsItem::setU32MetaDataTag4 (uint32 u32MetaDataTag4_) {
    set_has_u32MetaDataTag4();
    this->_u32MetaDataTag4 = u32MetaDataTag4_;
}

inline void T_MPlayMediaObjectsItem::clearSYomiMetaDataTitle() {
    if (hasSYomiMetaDataTitle()) {
         clear_has_sYomiMetaDataTitle();
        _sYomiMetaDataTitle.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasSYomiMetaDataTitle () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline const ::std::string& T_MPlayMediaObjectsItem::getSYomiMetaDataTitle () const {
    return _sYomiMetaDataTitle;
}

inline ::std::string& T_MPlayMediaObjectsItem::getSYomiMetaDataTitleMutable () {
    set_has_sYomiMetaDataTitle();
    return _sYomiMetaDataTitle;
}

inline void T_MPlayMediaObjectsItem::setSYomiMetaDataTitle (const ::std::string& sYomiMetaDataTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataTitle();
    this->_sYomiMetaDataTitle = sYomiMetaDataTitle_;
}

inline void T_MPlayMediaObjectsItem::setSYomiMetaDataTitle (const char* sYomiMetaDataTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataTitle();
    this->_sYomiMetaDataTitle.assign(sYomiMetaDataTitle_);
}

inline void T_MPlayMediaObjectsItem::setSYomiMetaDataTitle (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataTitle();
    this->_sYomiMetaDataTitle.assign(value, size);
}

inline void T_MPlayMediaObjectsItem::clearSYomiMetaDataArtist() {
    if (hasSYomiMetaDataArtist()) {
         clear_has_sYomiMetaDataArtist();
        _sYomiMetaDataArtist.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasSYomiMetaDataArtist () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline const ::std::string& T_MPlayMediaObjectsItem::getSYomiMetaDataArtist () const {
    return _sYomiMetaDataArtist;
}

inline ::std::string& T_MPlayMediaObjectsItem::getSYomiMetaDataArtistMutable () {
    set_has_sYomiMetaDataArtist();
    return _sYomiMetaDataArtist;
}

inline void T_MPlayMediaObjectsItem::setSYomiMetaDataArtist (const ::std::string& sYomiMetaDataArtist_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataArtist_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataArtist();
    this->_sYomiMetaDataArtist = sYomiMetaDataArtist_;
}

inline void T_MPlayMediaObjectsItem::setSYomiMetaDataArtist (const char* sYomiMetaDataArtist_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataArtist_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataArtist();
    this->_sYomiMetaDataArtist.assign(sYomiMetaDataArtist_);
}

inline void T_MPlayMediaObjectsItem::setSYomiMetaDataArtist (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataArtist();
    this->_sYomiMetaDataArtist.assign(value, size);
}

inline void T_MPlayMediaObjectsItem::clearSYomiMetaDataAlbum() {
    if (hasSYomiMetaDataAlbum()) {
         clear_has_sYomiMetaDataAlbum();
        _sYomiMetaDataAlbum.clear();
     }
}

inline bool T_MPlayMediaObjectsItem::hasSYomiMetaDataAlbum () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline const ::std::string& T_MPlayMediaObjectsItem::getSYomiMetaDataAlbum () const {
    return _sYomiMetaDataAlbum;
}

inline ::std::string& T_MPlayMediaObjectsItem::getSYomiMetaDataAlbumMutable () {
    set_has_sYomiMetaDataAlbum();
    return _sYomiMetaDataAlbum;
}

inline void T_MPlayMediaObjectsItem::setSYomiMetaDataAlbum (const ::std::string& sYomiMetaDataAlbum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataAlbum();
    this->_sYomiMetaDataAlbum = sYomiMetaDataAlbum_;
}

inline void T_MPlayMediaObjectsItem::setSYomiMetaDataAlbum (const char* sYomiMetaDataAlbum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sYomiMetaDataAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataAlbum();
    this->_sYomiMetaDataAlbum.assign(sYomiMetaDataAlbum_);
}

inline void T_MPlayMediaObjectsItem::setSYomiMetaDataAlbum (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sYomiMetaDataAlbum();
    this->_sYomiMetaDataAlbum.assign(value, size);
}

inline void T_MPlayMediaObjectsItem::clearU32Tag() {
    if (hasU32Tag()) {
         clear_has_u32Tag();
        _u32Tag = 0u;
     }
}

inline bool T_MPlayMediaObjectsItem::hasU32Tag () const {
    return (_has_bits_[0] & (1u << 24)) > 0;
}

inline uint32 T_MPlayMediaObjectsItem::getU32Tag () const {
    return _u32Tag;
}

inline void T_MPlayMediaObjectsItem::setU32Tag (uint32 u32Tag_) {
    set_has_u32Tag();
    this->_u32Tag = u32Tag_;
}

inline void T_MPlayMediaObjectsItem::clearU32TotalPlaytime() {
    if (hasU32TotalPlaytime()) {
         clear_has_u32TotalPlaytime();
        _u32TotalPlaytime = 0u;
     }
}

inline bool T_MPlayMediaObjectsItem::hasU32TotalPlaytime () const {
    return (_has_bits_[0] & (1u << 25)) > 0;
}

inline uint32 T_MPlayMediaObjectsItem::getU32TotalPlaytime () const {
    return _u32TotalPlaytime;
}

inline void T_MPlayMediaObjectsItem::setU32TotalPlaytime (uint32 u32TotalPlaytime_) {
    set_has_u32TotalPlaytime();
    this->_u32TotalPlaytime = u32TotalPlaytime_;
}

inline void T_MPlayMediaObjectsItem::clearU32Year() {
    if (hasU32Year()) {
         clear_has_u32Year();
        _u32Year = 0u;
     }
}

inline bool T_MPlayMediaObjectsItem::hasU32Year () const {
    return (_has_bits_[0] & (1u << 26)) > 0;
}

inline uint32 T_MPlayMediaObjectsItem::getU32Year () const {
    return _u32Year;
}

inline void T_MPlayMediaObjectsItem::setU32Year (uint32 u32Year_) {
    set_has_u32Year();
    this->_u32Year = u32Year_;
}

inline void T_MPlayMediaObjectsItem::clearU32YearID() {
    if (hasU32YearID()) {
         clear_has_u32YearID();
        _u32YearID = 0u;
     }
}

inline bool T_MPlayMediaObjectsItem::hasU32YearID () const {
    return (_has_bits_[0] & (1u << 27)) > 0;
}

inline uint32 T_MPlayMediaObjectsItem::getU32YearID () const {
    return _u32YearID;
}

inline void T_MPlayMediaObjectsItem::setU32YearID (uint32 u32YearID_) {
    set_has_u32YearID();
    this->_u32YearID = u32YearID_;
}

inline void T_MPlayMediaObjectsItem::clearU64FileSize() {
    if (hasU64FileSize()) {
         clear_has_u64FileSize();
        _u64FileSize = 0u;
     }
}

inline bool T_MPlayMediaObjectsItem::hasU64FileSize () const {
    return (_has_bits_[0] & (1u << 28)) > 0;
}

inline uint64 T_MPlayMediaObjectsItem::getU64FileSize () const {
    return _u64FileSize;
}

inline void T_MPlayMediaObjectsItem::setU64FileSize (uint64 u64FileSize_) {
    set_has_u64FileSize();
    this->_u64FileSize = u64FileSize_;
}

inline void T_MPlayMediaObjectsItem::clearU8DeviceTag() {
    if (hasU8DeviceTag()) {
         clear_has_u8DeviceTag();
        _u8DeviceTag = 0u;
     }
}

inline bool T_MPlayMediaObjectsItem::hasU8DeviceTag () const {
    return (_has_bits_[0] & (1u << 29)) > 0;
}

inline uint8 T_MPlayMediaObjectsItem::getU8DeviceTag () const {
    return _u8DeviceTag;
}

inline void T_MPlayMediaObjectsItem::setU8DeviceTag (uint8 u8DeviceTag_) {
    set_has_u8DeviceTag();
    this->_u8DeviceTag = u8DeviceTag_;
}

inline void T_MPlayMediaObjectsItem::clearU8TrackNumber() {
    if (hasU8TrackNumber()) {
         clear_has_u8TrackNumber();
        _u8TrackNumber = 0u;
     }
}

inline bool T_MPlayMediaObjectsItem::hasU8TrackNumber () const {
    return (_has_bits_[0] & (1u << 30)) > 0;
}

inline uint8 T_MPlayMediaObjectsItem::getU8TrackNumber () const {
    return _u8TrackNumber;
}

inline void T_MPlayMediaObjectsItem::setU8TrackNumber (uint8 u8TrackNumber_) {
    set_has_u8TrackNumber();
    this->_u8TrackNumber = u8TrackNumber_;
}

inline void T_MPlayMediaObjectsItem::clearBIsFavorite() {
    if (hasBIsFavorite()) {
         clear_has_bIsFavorite();
        _bIsFavorite = false;
     }
}

inline bool T_MPlayMediaObjectsItem::hasBIsFavorite () const {
    return (_has_bits_[0] & (1u << 31)) > 0;
}

inline bool T_MPlayMediaObjectsItem::getBIsFavorite () const {
    return _bIsFavorite;
}

inline void T_MPlayMediaObjectsItem::setBIsFavorite (bool bIsFavorite_) {
    set_has_bIsFavorite();
    this->_bIsFavorite = bIsFavorite_;
}

inline void T_MPlayMediaObjectsItem::set_has_e8CategoryType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MPlayMediaObjectsItem::clear_has_e8CategoryType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MPlayMediaObjectsItem::set_has_e8DeviceType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MPlayMediaObjectsItem::clear_has_e8DeviceType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MPlayMediaObjectsItem::set_has_e8FileFormat () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MPlayMediaObjectsItem::clear_has_e8FileFormat () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MPlayMediaObjectsItem::set_has_e8MediaType () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MPlayMediaObjectsItem::clear_has_e8MediaType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MPlayMediaObjectsItem::set_has_e8PlayableStatus () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MPlayMediaObjectsItem::clear_has_e8PlayableStatus () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MPlayMediaObjectsItem::set_has_oThumbnailData () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MPlayMediaObjectsItem::clear_has_oThumbnailData () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_MPlayMediaObjectsItem::set_has_bIsPlaying () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_MPlayMediaObjectsItem::clear_has_bIsPlaying () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_MPlayMediaObjectsItem::set_has_bReadOnlyFlag () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_MPlayMediaObjectsItem::clear_has_bReadOnlyFlag () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_MPlayMediaObjectsItem::set_has_sAlbumArt () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_MPlayMediaObjectsItem::clear_has_sAlbumArt () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_MPlayMediaObjectsItem::set_has_sCoverArt () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_MPlayMediaObjectsItem::clear_has_sCoverArt () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_MPlayMediaObjectsItem::set_has_sDateTime () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_MPlayMediaObjectsItem::clear_has_sDateTime () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_MPlayMediaObjectsItem::set_has_sDeviceVersion () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_MPlayMediaObjectsItem::clear_has_sDeviceVersion () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_MPlayMediaObjectsItem::set_has_sFilename () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_MPlayMediaObjectsItem::clear_has_sFilename () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_MPlayMediaObjectsItem::set_has_sMetaDataField1 () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_MPlayMediaObjectsItem::clear_has_sMetaDataField1 () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_MPlayMediaObjectsItem::set_has_sMetaDataField2 () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_MPlayMediaObjectsItem::clear_has_sMetaDataField2 () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_MPlayMediaObjectsItem::set_has_sMetaDataField3 () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_MPlayMediaObjectsItem::clear_has_sMetaDataField3 () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_MPlayMediaObjectsItem::set_has_sMetaDataField4 () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_MPlayMediaObjectsItem::clear_has_sMetaDataField4 () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_MPlayMediaObjectsItem::set_has_u32MetaDataTag1 () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_MPlayMediaObjectsItem::clear_has_u32MetaDataTag1 () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_MPlayMediaObjectsItem::set_has_u32MetaDataTag2 () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_MPlayMediaObjectsItem::clear_has_u32MetaDataTag2 () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_MPlayMediaObjectsItem::set_has_u32MetaDataTag3 () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_MPlayMediaObjectsItem::clear_has_u32MetaDataTag3 () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_MPlayMediaObjectsItem::set_has_u32MetaDataTag4 () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_MPlayMediaObjectsItem::clear_has_u32MetaDataTag4 () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_MPlayMediaObjectsItem::set_has_sYomiMetaDataTitle () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_MPlayMediaObjectsItem::clear_has_sYomiMetaDataTitle () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_MPlayMediaObjectsItem::set_has_sYomiMetaDataArtist () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_MPlayMediaObjectsItem::clear_has_sYomiMetaDataArtist () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_MPlayMediaObjectsItem::set_has_sYomiMetaDataAlbum () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_MPlayMediaObjectsItem::clear_has_sYomiMetaDataAlbum () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline void T_MPlayMediaObjectsItem::set_has_u32Tag () {
    _has_bits_[0] |= 1u << 24;
}

inline void T_MPlayMediaObjectsItem::clear_has_u32Tag () {
    _has_bits_[0] &= ~ (1u << 24);
}

inline void T_MPlayMediaObjectsItem::set_has_u32TotalPlaytime () {
    _has_bits_[0] |= 1u << 25;
}

inline void T_MPlayMediaObjectsItem::clear_has_u32TotalPlaytime () {
    _has_bits_[0] &= ~ (1u << 25);
}

inline void T_MPlayMediaObjectsItem::set_has_u32Year () {
    _has_bits_[0] |= 1u << 26;
}

inline void T_MPlayMediaObjectsItem::clear_has_u32Year () {
    _has_bits_[0] &= ~ (1u << 26);
}

inline void T_MPlayMediaObjectsItem::set_has_u32YearID () {
    _has_bits_[0] |= 1u << 27;
}

inline void T_MPlayMediaObjectsItem::clear_has_u32YearID () {
    _has_bits_[0] &= ~ (1u << 27);
}

inline void T_MPlayMediaObjectsItem::set_has_u64FileSize () {
    _has_bits_[0] |= 1u << 28;
}

inline void T_MPlayMediaObjectsItem::clear_has_u64FileSize () {
    _has_bits_[0] &= ~ (1u << 28);
}

inline void T_MPlayMediaObjectsItem::set_has_u8DeviceTag () {
    _has_bits_[0] |= 1u << 29;
}

inline void T_MPlayMediaObjectsItem::clear_has_u8DeviceTag () {
    _has_bits_[0] &= ~ (1u << 29);
}

inline void T_MPlayMediaObjectsItem::set_has_u8TrackNumber () {
    _has_bits_[0] |= 1u << 30;
}

inline void T_MPlayMediaObjectsItem::clear_has_u8TrackNumber () {
    _has_bits_[0] &= ~ (1u << 30);
}

inline void T_MPlayMediaObjectsItem::set_has_bIsFavorite () {
    _has_bits_[0] |= 1u << 31;
}

inline void T_MPlayMediaObjectsItem::clear_has_bIsFavorite () {
    _has_bits_[0] &= ~ (1u << 31);
}

inline  T_PermissionByTag::T_PermissionByTag ()  :
    _bReadOnlyFlag (false),
    _MediaObjectTag (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PermissionByTag::T_PermissionByTag (const T_PermissionByTag &rhs)  :
    _bReadOnlyFlag (false),
    _MediaObjectTag (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PermissionByTag::T_PermissionByTag (bool bReadOnlyFlag_, uint32 MediaObjectTag_)  :
    _bReadOnlyFlag (bReadOnlyFlag_),
    _MediaObjectTag (MediaObjectTag_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PermissionByTag::~T_PermissionByTag() {
}

inline T_PermissionByTag& T_PermissionByTag::operator = (const T_PermissionByTag& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBReadOnlyFlag()) {
            setBReadOnlyFlag(rhs.getBReadOnlyFlag());
        } else {
            clearBReadOnlyFlag();
        }
        if (rhs.hasMediaObjectTag()) {
            setMediaObjectTag(rhs.getMediaObjectTag());
        } else {
            clearMediaObjectTag();
        }
    }
    return *this;
}

inline bool T_PermissionByTag::operator == (const T_PermissionByTag& rhs) const {
    return (((!hasBReadOnlyFlag() && !rhs.hasBReadOnlyFlag()) || getBReadOnlyFlag() == rhs.getBReadOnlyFlag()) &&
        ((!hasMediaObjectTag() && !rhs.hasMediaObjectTag()) || getMediaObjectTag() == rhs.getMediaObjectTag()));
}

inline bool T_PermissionByTag::operator != (const T_PermissionByTag& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PermissionByTag::operator < (const T_PermissionByTag& rhs) const {
    if (hasBReadOnlyFlag() || rhs.hasBReadOnlyFlag()) {
        if (getBReadOnlyFlag() < rhs.getBReadOnlyFlag()) return true;
        if (getBReadOnlyFlag() > rhs.getBReadOnlyFlag()) return false;
    }
    if (hasMediaObjectTag() || rhs.hasMediaObjectTag()) {
        if (getMediaObjectTag() < rhs.getMediaObjectTag()) return true;
        if (getMediaObjectTag() > rhs.getMediaObjectTag()) return false;
    }
    return false;
}

inline bool T_PermissionByTag::operator > (const T_PermissionByTag& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PermissionByTag::clear() {
    clearBReadOnlyFlag();
    clearMediaObjectTag();
}

inline void T_PermissionByTag::clearBReadOnlyFlag() {
    if (hasBReadOnlyFlag()) {
         clear_has_bReadOnlyFlag();
        _bReadOnlyFlag = false;
     }
}

inline bool T_PermissionByTag::hasBReadOnlyFlag () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_PermissionByTag::getBReadOnlyFlag () const {
    return _bReadOnlyFlag;
}

inline void T_PermissionByTag::setBReadOnlyFlag (bool bReadOnlyFlag_) {
    set_has_bReadOnlyFlag();
    this->_bReadOnlyFlag = bReadOnlyFlag_;
}

inline void T_PermissionByTag::clearMediaObjectTag() {
    if (hasMediaObjectTag()) {
         clear_has_MediaObjectTag();
        _MediaObjectTag = 0u;
     }
}

inline bool T_PermissionByTag::hasMediaObjectTag () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_PermissionByTag::getMediaObjectTag () const {
    return _MediaObjectTag;
}

inline void T_PermissionByTag::setMediaObjectTag (uint32 MediaObjectTag_) {
    set_has_MediaObjectTag();
    this->_MediaObjectTag = MediaObjectTag_;
}

inline void T_PermissionByTag::set_has_bReadOnlyFlag () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PermissionByTag::clear_has_bReadOnlyFlag () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PermissionByTag::set_has_MediaObjectTag () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PermissionByTag::clear_has_MediaObjectTag () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_MPlayRippingStateResultItem::T_MPlayRippingStateResultItem ()  :
    _e8DeviceRippingState (::MPlay_fi_types::T_e8_MPlayDeviceRippingState__e8RS_COMPLETE),
    _u8DeviceTag (0u),
    _u8RippingPercentComplete (0u),
    _TotalTracksInCD (0u),
    _CurrentRippedTrackIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MPlayRippingStateResultItem::T_MPlayRippingStateResultItem (const T_MPlayRippingStateResultItem &rhs)  :
    _e8DeviceRippingState (::MPlay_fi_types::T_e8_MPlayDeviceRippingState__e8RS_COMPLETE),
    _u8DeviceTag (0u),
    _u8RippingPercentComplete (0u),
    _TotalTracksInCD (0u),
    _CurrentRippedTrackIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MPlayRippingStateResultItem::T_MPlayRippingStateResultItem (T_e8_MPlayDeviceRippingState e8DeviceRippingState_, uint8 u8DeviceTag_, uint8 u8RippingPercentComplete_, uint8 TotalTracksInCD_, uint8 CurrentRippedTrackIndex_)  :
    _e8DeviceRippingState (e8DeviceRippingState_),
    _u8DeviceTag (u8DeviceTag_),
    _u8RippingPercentComplete (u8RippingPercentComplete_),
    _TotalTracksInCD (TotalTracksInCD_),
    _CurrentRippedTrackIndex (CurrentRippedTrackIndex_)
{
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceRippingState_IsValid(e8DeviceRippingState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceRippingState_, "T_e8_MPlayDeviceRippingState", "e8DeviceRippingState", "T_MPlayRippingStateResultItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MPlayRippingStateResultItem::~T_MPlayRippingStateResultItem() {
}

inline T_MPlayRippingStateResultItem& T_MPlayRippingStateResultItem::operator = (const T_MPlayRippingStateResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8DeviceRippingState()) {
            setE8DeviceRippingState(rhs.getE8DeviceRippingState());
        } else {
            clearE8DeviceRippingState();
        }
        if (rhs.hasU8DeviceTag()) {
            setU8DeviceTag(rhs.getU8DeviceTag());
        } else {
            clearU8DeviceTag();
        }
        if (rhs.hasU8RippingPercentComplete()) {
            setU8RippingPercentComplete(rhs.getU8RippingPercentComplete());
        } else {
            clearU8RippingPercentComplete();
        }
        if (rhs.hasTotalTracksInCD()) {
            setTotalTracksInCD(rhs.getTotalTracksInCD());
        } else {
            clearTotalTracksInCD();
        }
        if (rhs.hasCurrentRippedTrackIndex()) {
            setCurrentRippedTrackIndex(rhs.getCurrentRippedTrackIndex());
        } else {
            clearCurrentRippedTrackIndex();
        }
    }
    return *this;
}

inline bool T_MPlayRippingStateResultItem::operator == (const T_MPlayRippingStateResultItem& rhs) const {
    return (((!hasE8DeviceRippingState() && !rhs.hasE8DeviceRippingState()) || getE8DeviceRippingState() == rhs.getE8DeviceRippingState()) &&
        ((!hasU8DeviceTag() && !rhs.hasU8DeviceTag()) || getU8DeviceTag() == rhs.getU8DeviceTag()) &&
        ((!hasU8RippingPercentComplete() && !rhs.hasU8RippingPercentComplete()) || getU8RippingPercentComplete() == rhs.getU8RippingPercentComplete()) &&
        ((!hasTotalTracksInCD() && !rhs.hasTotalTracksInCD()) || getTotalTracksInCD() == rhs.getTotalTracksInCD()) &&
        ((!hasCurrentRippedTrackIndex() && !rhs.hasCurrentRippedTrackIndex()) || getCurrentRippedTrackIndex() == rhs.getCurrentRippedTrackIndex()));
}

inline bool T_MPlayRippingStateResultItem::operator != (const T_MPlayRippingStateResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MPlayRippingStateResultItem::operator < (const T_MPlayRippingStateResultItem& rhs) const {
    if (hasE8DeviceRippingState() || rhs.hasE8DeviceRippingState()) {
        if ((uint32)getE8DeviceRippingState() < (uint32)rhs.getE8DeviceRippingState()) return true;
        if ((uint32)getE8DeviceRippingState() > (uint32)rhs.getE8DeviceRippingState()) return false;
    }
    if (hasU8DeviceTag() || rhs.hasU8DeviceTag()) {
        if (getU8DeviceTag() < rhs.getU8DeviceTag()) return true;
        if (getU8DeviceTag() > rhs.getU8DeviceTag()) return false;
    }
    if (hasU8RippingPercentComplete() || rhs.hasU8RippingPercentComplete()) {
        if (getU8RippingPercentComplete() < rhs.getU8RippingPercentComplete()) return true;
        if (getU8RippingPercentComplete() > rhs.getU8RippingPercentComplete()) return false;
    }
    if (hasTotalTracksInCD() || rhs.hasTotalTracksInCD()) {
        if (getTotalTracksInCD() < rhs.getTotalTracksInCD()) return true;
        if (getTotalTracksInCD() > rhs.getTotalTracksInCD()) return false;
    }
    if (hasCurrentRippedTrackIndex() || rhs.hasCurrentRippedTrackIndex()) {
        if (getCurrentRippedTrackIndex() < rhs.getCurrentRippedTrackIndex()) return true;
        if (getCurrentRippedTrackIndex() > rhs.getCurrentRippedTrackIndex()) return false;
    }
    return false;
}

inline bool T_MPlayRippingStateResultItem::operator > (const T_MPlayRippingStateResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MPlayRippingStateResultItem::clear() {
    clearE8DeviceRippingState();
    clearU8DeviceTag();
    clearU8RippingPercentComplete();
    clearTotalTracksInCD();
    clearCurrentRippedTrackIndex();
}

inline void T_MPlayRippingStateResultItem::clearE8DeviceRippingState() {
    if (hasE8DeviceRippingState()) {
         clear_has_e8DeviceRippingState();
        _e8DeviceRippingState = ::MPlay_fi_types::T_e8_MPlayDeviceRippingState__e8RS_COMPLETE;
     }
}

inline bool T_MPlayRippingStateResultItem::hasE8DeviceRippingState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_MPlayDeviceRippingState T_MPlayRippingStateResultItem::getE8DeviceRippingState () const {
    return _e8DeviceRippingState;
}

inline void T_MPlayRippingStateResultItem::setE8DeviceRippingState (T_e8_MPlayDeviceRippingState e8DeviceRippingState_) {
    #ifndef NDEBUG
    if (!(T_e8_MPlayDeviceRippingState_IsValid(e8DeviceRippingState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceRippingState_, "T_e8_MPlayDeviceRippingState", "e8DeviceRippingState", "T_MPlayRippingStateResultItem");
    }
    #endif
    set_has_e8DeviceRippingState();
    this->_e8DeviceRippingState = e8DeviceRippingState_;
}

inline void T_MPlayRippingStateResultItem::clearU8DeviceTag() {
    if (hasU8DeviceTag()) {
         clear_has_u8DeviceTag();
        _u8DeviceTag = 0u;
     }
}

inline bool T_MPlayRippingStateResultItem::hasU8DeviceTag () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_MPlayRippingStateResultItem::getU8DeviceTag () const {
    return _u8DeviceTag;
}

inline void T_MPlayRippingStateResultItem::setU8DeviceTag (uint8 u8DeviceTag_) {
    set_has_u8DeviceTag();
    this->_u8DeviceTag = u8DeviceTag_;
}

inline void T_MPlayRippingStateResultItem::clearU8RippingPercentComplete() {
    if (hasU8RippingPercentComplete()) {
         clear_has_u8RippingPercentComplete();
        _u8RippingPercentComplete = 0u;
     }
}

inline bool T_MPlayRippingStateResultItem::hasU8RippingPercentComplete () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_MPlayRippingStateResultItem::getU8RippingPercentComplete () const {
    return _u8RippingPercentComplete;
}

inline void T_MPlayRippingStateResultItem::setU8RippingPercentComplete (uint8 u8RippingPercentComplete_) {
    set_has_u8RippingPercentComplete();
    this->_u8RippingPercentComplete = u8RippingPercentComplete_;
}

inline void T_MPlayRippingStateResultItem::clearTotalTracksInCD() {
    if (hasTotalTracksInCD()) {
         clear_has_TotalTracksInCD();
        _TotalTracksInCD = 0u;
     }
}

inline bool T_MPlayRippingStateResultItem::hasTotalTracksInCD () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_MPlayRippingStateResultItem::getTotalTracksInCD () const {
    return _TotalTracksInCD;
}

inline void T_MPlayRippingStateResultItem::setTotalTracksInCD (uint8 TotalTracksInCD_) {
    set_has_TotalTracksInCD();
    this->_TotalTracksInCD = TotalTracksInCD_;
}

inline void T_MPlayRippingStateResultItem::clearCurrentRippedTrackIndex() {
    if (hasCurrentRippedTrackIndex()) {
         clear_has_CurrentRippedTrackIndex();
        _CurrentRippedTrackIndex = 0u;
     }
}

inline bool T_MPlayRippingStateResultItem::hasCurrentRippedTrackIndex () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_MPlayRippingStateResultItem::getCurrentRippedTrackIndex () const {
    return _CurrentRippedTrackIndex;
}

inline void T_MPlayRippingStateResultItem::setCurrentRippedTrackIndex (uint8 CurrentRippedTrackIndex_) {
    set_has_CurrentRippedTrackIndex();
    this->_CurrentRippedTrackIndex = CurrentRippedTrackIndex_;
}

inline void T_MPlayRippingStateResultItem::set_has_e8DeviceRippingState () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MPlayRippingStateResultItem::clear_has_e8DeviceRippingState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MPlayRippingStateResultItem::set_has_u8DeviceTag () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MPlayRippingStateResultItem::clear_has_u8DeviceTag () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MPlayRippingStateResultItem::set_has_u8RippingPercentComplete () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MPlayRippingStateResultItem::clear_has_u8RippingPercentComplete () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MPlayRippingStateResultItem::set_has_TotalTracksInCD () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MPlayRippingStateResultItem::clear_has_TotalTracksInCD () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MPlayRippingStateResultItem::set_has_CurrentRippedTrackIndex () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MPlayRippingStateResultItem::clear_has_CurrentRippedTrackIndex () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_MPlaySearchKeyboardListItem::T_MPlaySearchKeyboardListItem ()  :
    _bLetterAvailable (false),
    _sSearchKeyboardLetter (),
    _u32LetterEndIndex (0u),
    _u32LetterStartIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MPlaySearchKeyboardListItem::T_MPlaySearchKeyboardListItem (const T_MPlaySearchKeyboardListItem &rhs)  :
    _bLetterAvailable (false),
    _sSearchKeyboardLetter (),
    _u32LetterEndIndex (0u),
    _u32LetterStartIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MPlaySearchKeyboardListItem::T_MPlaySearchKeyboardListItem (bool bLetterAvailable_, const ::std::string& sSearchKeyboardLetter_, uint32 u32LetterEndIndex_, uint32 u32LetterStartIndex_)  :
    _bLetterAvailable (bLetterAvailable_),
    _sSearchKeyboardLetter (sSearchKeyboardLetter_),
    _u32LetterEndIndex (u32LetterEndIndex_),
    _u32LetterStartIndex (u32LetterStartIndex_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSearchKeyboardLetter_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MPlaySearchKeyboardListItem::~T_MPlaySearchKeyboardListItem() {
}

inline T_MPlaySearchKeyboardListItem& T_MPlaySearchKeyboardListItem::operator = (const T_MPlaySearchKeyboardListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBLetterAvailable()) {
            setBLetterAvailable(rhs.getBLetterAvailable());
        } else {
            clearBLetterAvailable();
        }
        if (rhs.hasSSearchKeyboardLetter()) {
            setSSearchKeyboardLetter(rhs.getSSearchKeyboardLetter());
        } else {
            clearSSearchKeyboardLetter();
        }
        if (rhs.hasU32LetterEndIndex()) {
            setU32LetterEndIndex(rhs.getU32LetterEndIndex());
        } else {
            clearU32LetterEndIndex();
        }
        if (rhs.hasU32LetterStartIndex()) {
            setU32LetterStartIndex(rhs.getU32LetterStartIndex());
        } else {
            clearU32LetterStartIndex();
        }
    }
    return *this;
}

inline bool T_MPlaySearchKeyboardListItem::operator == (const T_MPlaySearchKeyboardListItem& rhs) const {
    return (((!hasBLetterAvailable() && !rhs.hasBLetterAvailable()) || getBLetterAvailable() == rhs.getBLetterAvailable()) &&
        ((!hasSSearchKeyboardLetter() && !rhs.hasSSearchKeyboardLetter()) || getSSearchKeyboardLetter() == rhs.getSSearchKeyboardLetter()) &&
        ((!hasU32LetterEndIndex() && !rhs.hasU32LetterEndIndex()) || getU32LetterEndIndex() == rhs.getU32LetterEndIndex()) &&
        ((!hasU32LetterStartIndex() && !rhs.hasU32LetterStartIndex()) || getU32LetterStartIndex() == rhs.getU32LetterStartIndex()));
}

inline bool T_MPlaySearchKeyboardListItem::operator != (const T_MPlaySearchKeyboardListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MPlaySearchKeyboardListItem::operator < (const T_MPlaySearchKeyboardListItem& rhs) const {
    if (hasBLetterAvailable() || rhs.hasBLetterAvailable()) {
        if (getBLetterAvailable() < rhs.getBLetterAvailable()) return true;
        if (getBLetterAvailable() > rhs.getBLetterAvailable()) return false;
    }
    if (hasSSearchKeyboardLetter() || rhs.hasSSearchKeyboardLetter()) {
        if (getSSearchKeyboardLetter() < rhs.getSSearchKeyboardLetter()) return true;
        if (getSSearchKeyboardLetter() > rhs.getSSearchKeyboardLetter()) return false;
    }
    if (hasU32LetterEndIndex() || rhs.hasU32LetterEndIndex()) {
        if (getU32LetterEndIndex() < rhs.getU32LetterEndIndex()) return true;
        if (getU32LetterEndIndex() > rhs.getU32LetterEndIndex()) return false;
    }
    if (hasU32LetterStartIndex() || rhs.hasU32LetterStartIndex()) {
        if (getU32LetterStartIndex() < rhs.getU32LetterStartIndex()) return true;
        if (getU32LetterStartIndex() > rhs.getU32LetterStartIndex()) return false;
    }
    return false;
}

inline bool T_MPlaySearchKeyboardListItem::operator > (const T_MPlaySearchKeyboardListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MPlaySearchKeyboardListItem::clear() {
    clearBLetterAvailable();
    clearSSearchKeyboardLetter();
    clearU32LetterEndIndex();
    clearU32LetterStartIndex();
}

inline void T_MPlaySearchKeyboardListItem::clearBLetterAvailable() {
    if (hasBLetterAvailable()) {
         clear_has_bLetterAvailable();
        _bLetterAvailable = false;
     }
}

inline bool T_MPlaySearchKeyboardListItem::hasBLetterAvailable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_MPlaySearchKeyboardListItem::getBLetterAvailable () const {
    return _bLetterAvailable;
}

inline void T_MPlaySearchKeyboardListItem::setBLetterAvailable (bool bLetterAvailable_) {
    set_has_bLetterAvailable();
    this->_bLetterAvailable = bLetterAvailable_;
}

inline void T_MPlaySearchKeyboardListItem::clearSSearchKeyboardLetter() {
    if (hasSSearchKeyboardLetter()) {
         clear_has_sSearchKeyboardLetter();
        _sSearchKeyboardLetter.clear();
     }
}

inline bool T_MPlaySearchKeyboardListItem::hasSSearchKeyboardLetter () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_MPlaySearchKeyboardListItem::getSSearchKeyboardLetter () const {
    return _sSearchKeyboardLetter;
}

inline ::std::string& T_MPlaySearchKeyboardListItem::getSSearchKeyboardLetterMutable () {
    set_has_sSearchKeyboardLetter();
    return _sSearchKeyboardLetter;
}

inline void T_MPlaySearchKeyboardListItem::setSSearchKeyboardLetter (const ::std::string& sSearchKeyboardLetter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSearchKeyboardLetter_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sSearchKeyboardLetter();
    this->_sSearchKeyboardLetter = sSearchKeyboardLetter_;
}

inline void T_MPlaySearchKeyboardListItem::setSSearchKeyboardLetter (const char* sSearchKeyboardLetter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSearchKeyboardLetter_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sSearchKeyboardLetter();
    this->_sSearchKeyboardLetter.assign(sSearchKeyboardLetter_);
}

inline void T_MPlaySearchKeyboardListItem::setSSearchKeyboardLetter (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sSearchKeyboardLetter();
    this->_sSearchKeyboardLetter.assign(value, size);
}

inline void T_MPlaySearchKeyboardListItem::clearU32LetterEndIndex() {
    if (hasU32LetterEndIndex()) {
         clear_has_u32LetterEndIndex();
        _u32LetterEndIndex = 0u;
     }
}

inline bool T_MPlaySearchKeyboardListItem::hasU32LetterEndIndex () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_MPlaySearchKeyboardListItem::getU32LetterEndIndex () const {
    return _u32LetterEndIndex;
}

inline void T_MPlaySearchKeyboardListItem::setU32LetterEndIndex (uint32 u32LetterEndIndex_) {
    set_has_u32LetterEndIndex();
    this->_u32LetterEndIndex = u32LetterEndIndex_;
}

inline void T_MPlaySearchKeyboardListItem::clearU32LetterStartIndex() {
    if (hasU32LetterStartIndex()) {
         clear_has_u32LetterStartIndex();
        _u32LetterStartIndex = 0u;
     }
}

inline bool T_MPlaySearchKeyboardListItem::hasU32LetterStartIndex () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_MPlaySearchKeyboardListItem::getU32LetterStartIndex () const {
    return _u32LetterStartIndex;
}

inline void T_MPlaySearchKeyboardListItem::setU32LetterStartIndex (uint32 u32LetterStartIndex_) {
    set_has_u32LetterStartIndex();
    this->_u32LetterStartIndex = u32LetterStartIndex_;
}

inline void T_MPlaySearchKeyboardListItem::set_has_bLetterAvailable () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MPlaySearchKeyboardListItem::clear_has_bLetterAvailable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MPlaySearchKeyboardListItem::set_has_sSearchKeyboardLetter () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MPlaySearchKeyboardListItem::clear_has_sSearchKeyboardLetter () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MPlaySearchKeyboardListItem::set_has_u32LetterEndIndex () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MPlaySearchKeyboardListItem::clear_has_u32LetterEndIndex () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MPlaySearchKeyboardListItem::set_has_u32LetterStartIndex () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MPlaySearchKeyboardListItem::clear_has_u32LetterStartIndex () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_MPlayTagTransferItem_1::T_MPlayTagTransferItem_1 ()  :
    _oUnknownData (),
    _sPodCastFeedURL (),
    _sStationURL (),
    _sStationURLFrequency (),
    _sTagAffiliateID (),
    _sTagAlbum (),
    _sTagArtistName (),
    _sTagChannelName (),
    _sTagChannelNumber (),
    _sTagGenre (),
    _sTagTimeStamp (),
    _sTagTrackName (),
    _u32TagSongID (0u),
    _u8AmbiguousTag (0u),
    _u8ButtonPressed (0u),
    _u8TagProgramNumber (0u),
    _u8TagStorefrontID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MPlayTagTransferItem_1::T_MPlayTagTransferItem_1 (const T_MPlayTagTransferItem_1 &rhs)  :
    _oUnknownData (),
    _sPodCastFeedURL (),
    _sStationURL (),
    _sStationURLFrequency (),
    _sTagAffiliateID (),
    _sTagAlbum (),
    _sTagArtistName (),
    _sTagChannelName (),
    _sTagChannelNumber (),
    _sTagGenre (),
    _sTagTimeStamp (),
    _sTagTrackName (),
    _u32TagSongID (0u),
    _u8AmbiguousTag (0u),
    _u8ButtonPressed (0u),
    _u8TagProgramNumber (0u),
    _u8TagStorefrontID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MPlayTagTransferItem_1::T_MPlayTagTransferItem_1 (const ::fi_basetypes::T_ShortStream& oUnknownData_, const ::std::string& sPodCastFeedURL_, const ::std::string& sStationURL_, const ::std::string& sStationURLFrequency_, const ::std::string& sTagAffiliateID_, const ::std::string& sTagAlbum_, const ::std::string& sTagArtistName_, const ::std::string& sTagChannelName_, const ::std::string& sTagChannelNumber_, const ::std::string& sTagGenre_, const ::std::string& sTagTimeStamp_, const ::std::string& sTagTrackName_, uint32 u32TagSongID_, uint8 u8AmbiguousTag_, uint8 u8ButtonPressed_, uint8 u8TagProgramNumber_, uint8 u8TagStorefrontID_)  :
    _oUnknownData (oUnknownData_),
    _sPodCastFeedURL (sPodCastFeedURL_),
    _sStationURL (sStationURL_),
    _sStationURLFrequency (sStationURLFrequency_),
    _sTagAffiliateID (sTagAffiliateID_),
    _sTagAlbum (sTagAlbum_),
    _sTagArtistName (sTagArtistName_),
    _sTagChannelName (sTagChannelName_),
    _sTagChannelNumber (sTagChannelNumber_),
    _sTagGenre (sTagGenre_),
    _sTagTimeStamp (sTagTimeStamp_),
    _sTagTrackName (sTagTrackName_),
    _u32TagSongID (u32TagSongID_),
    _u8AmbiguousTag (u8AmbiguousTag_),
    _u8ButtonPressed (u8ButtonPressed_),
    _u8TagProgramNumber (u8TagProgramNumber_),
    _u8TagStorefrontID (u8TagStorefrontID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPodCastFeedURL_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationURL_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationURLFrequency_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagAffiliateID_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagChannelNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagGenre_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTimeStamp_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MPlayTagTransferItem_1::~T_MPlayTagTransferItem_1() {
}

inline T_MPlayTagTransferItem_1& T_MPlayTagTransferItem_1::operator = (const T_MPlayTagTransferItem_1& rhs) {
    if( this != &rhs ) {
        if (rhs.hasOUnknownData()) {
            setOUnknownData(rhs.getOUnknownData());
        } else {
            clearOUnknownData();
        }
        if (rhs.hasSPodCastFeedURL()) {
            setSPodCastFeedURL(rhs.getSPodCastFeedURL());
        } else {
            clearSPodCastFeedURL();
        }
        if (rhs.hasSStationURL()) {
            setSStationURL(rhs.getSStationURL());
        } else {
            clearSStationURL();
        }
        if (rhs.hasSStationURLFrequency()) {
            setSStationURLFrequency(rhs.getSStationURLFrequency());
        } else {
            clearSStationURLFrequency();
        }
        if (rhs.hasSTagAffiliateID()) {
            setSTagAffiliateID(rhs.getSTagAffiliateID());
        } else {
            clearSTagAffiliateID();
        }
        if (rhs.hasSTagAlbum()) {
            setSTagAlbum(rhs.getSTagAlbum());
        } else {
            clearSTagAlbum();
        }
        if (rhs.hasSTagArtistName()) {
            setSTagArtistName(rhs.getSTagArtistName());
        } else {
            clearSTagArtistName();
        }
        if (rhs.hasSTagChannelName()) {
            setSTagChannelName(rhs.getSTagChannelName());
        } else {
            clearSTagChannelName();
        }
        if (rhs.hasSTagChannelNumber()) {
            setSTagChannelNumber(rhs.getSTagChannelNumber());
        } else {
            clearSTagChannelNumber();
        }
        if (rhs.hasSTagGenre()) {
            setSTagGenre(rhs.getSTagGenre());
        } else {
            clearSTagGenre();
        }
        if (rhs.hasSTagTimeStamp()) {
            setSTagTimeStamp(rhs.getSTagTimeStamp());
        } else {
            clearSTagTimeStamp();
        }
        if (rhs.hasSTagTrackName()) {
            setSTagTrackName(rhs.getSTagTrackName());
        } else {
            clearSTagTrackName();
        }
        if (rhs.hasU32TagSongID()) {
            setU32TagSongID(rhs.getU32TagSongID());
        } else {
            clearU32TagSongID();
        }
        if (rhs.hasU8AmbiguousTag()) {
            setU8AmbiguousTag(rhs.getU8AmbiguousTag());
        } else {
            clearU8AmbiguousTag();
        }
        if (rhs.hasU8ButtonPressed()) {
            setU8ButtonPressed(rhs.getU8ButtonPressed());
        } else {
            clearU8ButtonPressed();
        }
        if (rhs.hasU8TagProgramNumber()) {
            setU8TagProgramNumber(rhs.getU8TagProgramNumber());
        } else {
            clearU8TagProgramNumber();
        }
        if (rhs.hasU8TagStorefrontID()) {
            setU8TagStorefrontID(rhs.getU8TagStorefrontID());
        } else {
            clearU8TagStorefrontID();
        }
    }
    return *this;
}

inline bool T_MPlayTagTransferItem_1::operator == (const T_MPlayTagTransferItem_1& rhs) const {
    return (((!hasOUnknownData() && !rhs.hasOUnknownData()) || getOUnknownData() == rhs.getOUnknownData()) &&
        ((!hasSPodCastFeedURL() && !rhs.hasSPodCastFeedURL()) || getSPodCastFeedURL() == rhs.getSPodCastFeedURL()) &&
        ((!hasSStationURL() && !rhs.hasSStationURL()) || getSStationURL() == rhs.getSStationURL()) &&
        ((!hasSStationURLFrequency() && !rhs.hasSStationURLFrequency()) || getSStationURLFrequency() == rhs.getSStationURLFrequency()) &&
        ((!hasSTagAffiliateID() && !rhs.hasSTagAffiliateID()) || getSTagAffiliateID() == rhs.getSTagAffiliateID()) &&
        ((!hasSTagAlbum() && !rhs.hasSTagAlbum()) || getSTagAlbum() == rhs.getSTagAlbum()) &&
        ((!hasSTagArtistName() && !rhs.hasSTagArtistName()) || getSTagArtistName() == rhs.getSTagArtistName()) &&
        ((!hasSTagChannelName() && !rhs.hasSTagChannelName()) || getSTagChannelName() == rhs.getSTagChannelName()) &&
        ((!hasSTagChannelNumber() && !rhs.hasSTagChannelNumber()) || getSTagChannelNumber() == rhs.getSTagChannelNumber()) &&
        ((!hasSTagGenre() && !rhs.hasSTagGenre()) || getSTagGenre() == rhs.getSTagGenre()) &&
        ((!hasSTagTimeStamp() && !rhs.hasSTagTimeStamp()) || getSTagTimeStamp() == rhs.getSTagTimeStamp()) &&
        ((!hasSTagTrackName() && !rhs.hasSTagTrackName()) || getSTagTrackName() == rhs.getSTagTrackName()) &&
        ((!hasU32TagSongID() && !rhs.hasU32TagSongID()) || getU32TagSongID() == rhs.getU32TagSongID()) &&
        ((!hasU8AmbiguousTag() && !rhs.hasU8AmbiguousTag()) || getU8AmbiguousTag() == rhs.getU8AmbiguousTag()) &&
        ((!hasU8ButtonPressed() && !rhs.hasU8ButtonPressed()) || getU8ButtonPressed() == rhs.getU8ButtonPressed()) &&
        ((!hasU8TagProgramNumber() && !rhs.hasU8TagProgramNumber()) || getU8TagProgramNumber() == rhs.getU8TagProgramNumber()) &&
        ((!hasU8TagStorefrontID() && !rhs.hasU8TagStorefrontID()) || getU8TagStorefrontID() == rhs.getU8TagStorefrontID()));
}

inline bool T_MPlayTagTransferItem_1::operator != (const T_MPlayTagTransferItem_1& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MPlayTagTransferItem_1::operator < (const T_MPlayTagTransferItem_1& rhs) const {
    if (hasOUnknownData() || rhs.hasOUnknownData()) {
        if (getOUnknownData() < rhs.getOUnknownData()) return true;
        if (getOUnknownData() > rhs.getOUnknownData()) return false;
    }
    if (hasSPodCastFeedURL() || rhs.hasSPodCastFeedURL()) {
        if (getSPodCastFeedURL() < rhs.getSPodCastFeedURL()) return true;
        if (getSPodCastFeedURL() > rhs.getSPodCastFeedURL()) return false;
    }
    if (hasSStationURL() || rhs.hasSStationURL()) {
        if (getSStationURL() < rhs.getSStationURL()) return true;
        if (getSStationURL() > rhs.getSStationURL()) return false;
    }
    if (hasSStationURLFrequency() || rhs.hasSStationURLFrequency()) {
        if (getSStationURLFrequency() < rhs.getSStationURLFrequency()) return true;
        if (getSStationURLFrequency() > rhs.getSStationURLFrequency()) return false;
    }
    if (hasSTagAffiliateID() || rhs.hasSTagAffiliateID()) {
        if (getSTagAffiliateID() < rhs.getSTagAffiliateID()) return true;
        if (getSTagAffiliateID() > rhs.getSTagAffiliateID()) return false;
    }
    if (hasSTagAlbum() || rhs.hasSTagAlbum()) {
        if (getSTagAlbum() < rhs.getSTagAlbum()) return true;
        if (getSTagAlbum() > rhs.getSTagAlbum()) return false;
    }
    if (hasSTagArtistName() || rhs.hasSTagArtistName()) {
        if (getSTagArtistName() < rhs.getSTagArtistName()) return true;
        if (getSTagArtistName() > rhs.getSTagArtistName()) return false;
    }
    if (hasSTagChannelName() || rhs.hasSTagChannelName()) {
        if (getSTagChannelName() < rhs.getSTagChannelName()) return true;
        if (getSTagChannelName() > rhs.getSTagChannelName()) return false;
    }
    if (hasSTagChannelNumber() || rhs.hasSTagChannelNumber()) {
        if (getSTagChannelNumber() < rhs.getSTagChannelNumber()) return true;
        if (getSTagChannelNumber() > rhs.getSTagChannelNumber()) return false;
    }
    if (hasSTagGenre() || rhs.hasSTagGenre()) {
        if (getSTagGenre() < rhs.getSTagGenre()) return true;
        if (getSTagGenre() > rhs.getSTagGenre()) return false;
    }
    if (hasSTagTimeStamp() || rhs.hasSTagTimeStamp()) {
        if (getSTagTimeStamp() < rhs.getSTagTimeStamp()) return true;
        if (getSTagTimeStamp() > rhs.getSTagTimeStamp()) return false;
    }
    if (hasSTagTrackName() || rhs.hasSTagTrackName()) {
        if (getSTagTrackName() < rhs.getSTagTrackName()) return true;
        if (getSTagTrackName() > rhs.getSTagTrackName()) return false;
    }
    if (hasU32TagSongID() || rhs.hasU32TagSongID()) {
        if (getU32TagSongID() < rhs.getU32TagSongID()) return true;
        if (getU32TagSongID() > rhs.getU32TagSongID()) return false;
    }
    if (hasU8AmbiguousTag() || rhs.hasU8AmbiguousTag()) {
        if (getU8AmbiguousTag() < rhs.getU8AmbiguousTag()) return true;
        if (getU8AmbiguousTag() > rhs.getU8AmbiguousTag()) return false;
    }
    if (hasU8ButtonPressed() || rhs.hasU8ButtonPressed()) {
        if (getU8ButtonPressed() < rhs.getU8ButtonPressed()) return true;
        if (getU8ButtonPressed() > rhs.getU8ButtonPressed()) return false;
    }
    if (hasU8TagProgramNumber() || rhs.hasU8TagProgramNumber()) {
        if (getU8TagProgramNumber() < rhs.getU8TagProgramNumber()) return true;
        if (getU8TagProgramNumber() > rhs.getU8TagProgramNumber()) return false;
    }
    if (hasU8TagStorefrontID() || rhs.hasU8TagStorefrontID()) {
        if (getU8TagStorefrontID() < rhs.getU8TagStorefrontID()) return true;
        if (getU8TagStorefrontID() > rhs.getU8TagStorefrontID()) return false;
    }
    return false;
}

inline bool T_MPlayTagTransferItem_1::operator > (const T_MPlayTagTransferItem_1& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MPlayTagTransferItem_1::clear() {
    clearOUnknownData();
    clearSPodCastFeedURL();
    clearSStationURL();
    clearSStationURLFrequency();
    clearSTagAffiliateID();
    clearSTagAlbum();
    clearSTagArtistName();
    clearSTagChannelName();
    clearSTagChannelNumber();
    clearSTagGenre();
    clearSTagTimeStamp();
    clearSTagTrackName();
    clearU32TagSongID();
    clearU8AmbiguousTag();
    clearU8ButtonPressed();
    clearU8TagProgramNumber();
    clearU8TagStorefrontID();
}

inline void T_MPlayTagTransferItem_1::clearOUnknownData() {
    if (hasOUnknownData()) {
         clear_has_oUnknownData();
        _oUnknownData.clear();
     }
}

inline bool T_MPlayTagTransferItem_1::hasOUnknownData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes::T_ShortStream& T_MPlayTagTransferItem_1::getOUnknownData () const {
    return _oUnknownData;
}

inline ::fi_basetypes::T_ShortStream& T_MPlayTagTransferItem_1::getOUnknownDataMutable () {
    set_has_oUnknownData();
    return _oUnknownData;
}

inline void T_MPlayTagTransferItem_1::setOUnknownData (const ::fi_basetypes::T_ShortStream& oUnknownData_) {
    set_has_oUnknownData();
    this->_oUnknownData = oUnknownData_;
}

inline void T_MPlayTagTransferItem_1::clearSPodCastFeedURL() {
    if (hasSPodCastFeedURL()) {
         clear_has_sPodCastFeedURL();
        _sPodCastFeedURL.clear();
     }
}

inline bool T_MPlayTagTransferItem_1::hasSPodCastFeedURL () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_1::getSPodCastFeedURL () const {
    return _sPodCastFeedURL;
}

inline ::std::string& T_MPlayTagTransferItem_1::getSPodCastFeedURLMutable () {
    set_has_sPodCastFeedURL();
    return _sPodCastFeedURL;
}

inline void T_MPlayTagTransferItem_1::setSPodCastFeedURL (const ::std::string& sPodCastFeedURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPodCastFeedURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPodCastFeedURL();
    this->_sPodCastFeedURL = sPodCastFeedURL_;
}

inline void T_MPlayTagTransferItem_1::setSPodCastFeedURL (const char* sPodCastFeedURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPodCastFeedURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPodCastFeedURL();
    this->_sPodCastFeedURL.assign(sPodCastFeedURL_);
}

inline void T_MPlayTagTransferItem_1::setSPodCastFeedURL (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPodCastFeedURL();
    this->_sPodCastFeedURL.assign(value, size);
}

inline void T_MPlayTagTransferItem_1::clearSStationURL() {
    if (hasSStationURL()) {
         clear_has_sStationURL();
        _sStationURL.clear();
     }
}

inline bool T_MPlayTagTransferItem_1::hasSStationURL () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_1::getSStationURL () const {
    return _sStationURL;
}

inline ::std::string& T_MPlayTagTransferItem_1::getSStationURLMutable () {
    set_has_sStationURL();
    return _sStationURL;
}

inline void T_MPlayTagTransferItem_1::setSStationURL (const ::std::string& sStationURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationURL();
    this->_sStationURL = sStationURL_;
}

inline void T_MPlayTagTransferItem_1::setSStationURL (const char* sStationURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationURL();
    this->_sStationURL.assign(sStationURL_);
}

inline void T_MPlayTagTransferItem_1::setSStationURL (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationURL();
    this->_sStationURL.assign(value, size);
}

inline void T_MPlayTagTransferItem_1::clearSStationURLFrequency() {
    if (hasSStationURLFrequency()) {
         clear_has_sStationURLFrequency();
        _sStationURLFrequency.clear();
     }
}

inline bool T_MPlayTagTransferItem_1::hasSStationURLFrequency () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_1::getSStationURLFrequency () const {
    return _sStationURLFrequency;
}

inline ::std::string& T_MPlayTagTransferItem_1::getSStationURLFrequencyMutable () {
    set_has_sStationURLFrequency();
    return _sStationURLFrequency;
}

inline void T_MPlayTagTransferItem_1::setSStationURLFrequency (const ::std::string& sStationURLFrequency_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationURLFrequency_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationURLFrequency();
    this->_sStationURLFrequency = sStationURLFrequency_;
}

inline void T_MPlayTagTransferItem_1::setSStationURLFrequency (const char* sStationURLFrequency_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationURLFrequency_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationURLFrequency();
    this->_sStationURLFrequency.assign(sStationURLFrequency_);
}

inline void T_MPlayTagTransferItem_1::setSStationURLFrequency (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationURLFrequency();
    this->_sStationURLFrequency.assign(value, size);
}

inline void T_MPlayTagTransferItem_1::clearSTagAffiliateID() {
    if (hasSTagAffiliateID()) {
         clear_has_sTagAffiliateID();
        _sTagAffiliateID.clear();
     }
}

inline bool T_MPlayTagTransferItem_1::hasSTagAffiliateID () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_1::getSTagAffiliateID () const {
    return _sTagAffiliateID;
}

inline ::std::string& T_MPlayTagTransferItem_1::getSTagAffiliateIDMutable () {
    set_has_sTagAffiliateID();
    return _sTagAffiliateID;
}

inline void T_MPlayTagTransferItem_1::setSTagAffiliateID (const ::std::string& sTagAffiliateID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagAffiliateID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagAffiliateID();
    this->_sTagAffiliateID = sTagAffiliateID_;
}

inline void T_MPlayTagTransferItem_1::setSTagAffiliateID (const char* sTagAffiliateID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagAffiliateID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagAffiliateID();
    this->_sTagAffiliateID.assign(sTagAffiliateID_);
}

inline void T_MPlayTagTransferItem_1::setSTagAffiliateID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagAffiliateID();
    this->_sTagAffiliateID.assign(value, size);
}

inline void T_MPlayTagTransferItem_1::clearSTagAlbum() {
    if (hasSTagAlbum()) {
         clear_has_sTagAlbum();
        _sTagAlbum.clear();
     }
}

inline bool T_MPlayTagTransferItem_1::hasSTagAlbum () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_1::getSTagAlbum () const {
    return _sTagAlbum;
}

inline ::std::string& T_MPlayTagTransferItem_1::getSTagAlbumMutable () {
    set_has_sTagAlbum();
    return _sTagAlbum;
}

inline void T_MPlayTagTransferItem_1::setSTagAlbum (const ::std::string& sTagAlbum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagAlbum();
    this->_sTagAlbum = sTagAlbum_;
}

inline void T_MPlayTagTransferItem_1::setSTagAlbum (const char* sTagAlbum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagAlbum();
    this->_sTagAlbum.assign(sTagAlbum_);
}

inline void T_MPlayTagTransferItem_1::setSTagAlbum (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagAlbum();
    this->_sTagAlbum.assign(value, size);
}

inline void T_MPlayTagTransferItem_1::clearSTagArtistName() {
    if (hasSTagArtistName()) {
         clear_has_sTagArtistName();
        _sTagArtistName.clear();
     }
}

inline bool T_MPlayTagTransferItem_1::hasSTagArtistName () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_1::getSTagArtistName () const {
    return _sTagArtistName;
}

inline ::std::string& T_MPlayTagTransferItem_1::getSTagArtistNameMutable () {
    set_has_sTagArtistName();
    return _sTagArtistName;
}

inline void T_MPlayTagTransferItem_1::setSTagArtistName (const ::std::string& sTagArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagArtistName();
    this->_sTagArtistName = sTagArtistName_;
}

inline void T_MPlayTagTransferItem_1::setSTagArtistName (const char* sTagArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagArtistName();
    this->_sTagArtistName.assign(sTagArtistName_);
}

inline void T_MPlayTagTransferItem_1::setSTagArtistName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagArtistName();
    this->_sTagArtistName.assign(value, size);
}

inline void T_MPlayTagTransferItem_1::clearSTagChannelName() {
    if (hasSTagChannelName()) {
         clear_has_sTagChannelName();
        _sTagChannelName.clear();
     }
}

inline bool T_MPlayTagTransferItem_1::hasSTagChannelName () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_1::getSTagChannelName () const {
    return _sTagChannelName;
}

inline ::std::string& T_MPlayTagTransferItem_1::getSTagChannelNameMutable () {
    set_has_sTagChannelName();
    return _sTagChannelName;
}

inline void T_MPlayTagTransferItem_1::setSTagChannelName (const ::std::string& sTagChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagChannelName();
    this->_sTagChannelName = sTagChannelName_;
}

inline void T_MPlayTagTransferItem_1::setSTagChannelName (const char* sTagChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagChannelName();
    this->_sTagChannelName.assign(sTagChannelName_);
}

inline void T_MPlayTagTransferItem_1::setSTagChannelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagChannelName();
    this->_sTagChannelName.assign(value, size);
}

inline void T_MPlayTagTransferItem_1::clearSTagChannelNumber() {
    if (hasSTagChannelNumber()) {
         clear_has_sTagChannelNumber();
        _sTagChannelNumber.clear();
     }
}

inline bool T_MPlayTagTransferItem_1::hasSTagChannelNumber () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_1::getSTagChannelNumber () const {
    return _sTagChannelNumber;
}

inline ::std::string& T_MPlayTagTransferItem_1::getSTagChannelNumberMutable () {
    set_has_sTagChannelNumber();
    return _sTagChannelNumber;
}

inline void T_MPlayTagTransferItem_1::setSTagChannelNumber (const ::std::string& sTagChannelNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagChannelNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagChannelNumber();
    this->_sTagChannelNumber = sTagChannelNumber_;
}

inline void T_MPlayTagTransferItem_1::setSTagChannelNumber (const char* sTagChannelNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagChannelNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagChannelNumber();
    this->_sTagChannelNumber.assign(sTagChannelNumber_);
}

inline void T_MPlayTagTransferItem_1::setSTagChannelNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagChannelNumber();
    this->_sTagChannelNumber.assign(value, size);
}

inline void T_MPlayTagTransferItem_1::clearSTagGenre() {
    if (hasSTagGenre()) {
         clear_has_sTagGenre();
        _sTagGenre.clear();
     }
}

inline bool T_MPlayTagTransferItem_1::hasSTagGenre () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_1::getSTagGenre () const {
    return _sTagGenre;
}

inline ::std::string& T_MPlayTagTransferItem_1::getSTagGenreMutable () {
    set_has_sTagGenre();
    return _sTagGenre;
}

inline void T_MPlayTagTransferItem_1::setSTagGenre (const ::std::string& sTagGenre_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagGenre_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagGenre();
    this->_sTagGenre = sTagGenre_;
}

inline void T_MPlayTagTransferItem_1::setSTagGenre (const char* sTagGenre_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagGenre_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagGenre();
    this->_sTagGenre.assign(sTagGenre_);
}

inline void T_MPlayTagTransferItem_1::setSTagGenre (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagGenre();
    this->_sTagGenre.assign(value, size);
}

inline void T_MPlayTagTransferItem_1::clearSTagTimeStamp() {
    if (hasSTagTimeStamp()) {
         clear_has_sTagTimeStamp();
        _sTagTimeStamp.clear();
     }
}

inline bool T_MPlayTagTransferItem_1::hasSTagTimeStamp () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_1::getSTagTimeStamp () const {
    return _sTagTimeStamp;
}

inline ::std::string& T_MPlayTagTransferItem_1::getSTagTimeStampMutable () {
    set_has_sTagTimeStamp();
    return _sTagTimeStamp;
}

inline void T_MPlayTagTransferItem_1::setSTagTimeStamp (const ::std::string& sTagTimeStamp_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTimeStamp_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTimeStamp();
    this->_sTagTimeStamp = sTagTimeStamp_;
}

inline void T_MPlayTagTransferItem_1::setSTagTimeStamp (const char* sTagTimeStamp_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTimeStamp_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTimeStamp();
    this->_sTagTimeStamp.assign(sTagTimeStamp_);
}

inline void T_MPlayTagTransferItem_1::setSTagTimeStamp (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTimeStamp();
    this->_sTagTimeStamp.assign(value, size);
}

inline void T_MPlayTagTransferItem_1::clearSTagTrackName() {
    if (hasSTagTrackName()) {
         clear_has_sTagTrackName();
        _sTagTrackName.clear();
     }
}

inline bool T_MPlayTagTransferItem_1::hasSTagTrackName () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_1::getSTagTrackName () const {
    return _sTagTrackName;
}

inline ::std::string& T_MPlayTagTransferItem_1::getSTagTrackNameMutable () {
    set_has_sTagTrackName();
    return _sTagTrackName;
}

inline void T_MPlayTagTransferItem_1::setSTagTrackName (const ::std::string& sTagTrackName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTrackName();
    this->_sTagTrackName = sTagTrackName_;
}

inline void T_MPlayTagTransferItem_1::setSTagTrackName (const char* sTagTrackName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTrackName();
    this->_sTagTrackName.assign(sTagTrackName_);
}

inline void T_MPlayTagTransferItem_1::setSTagTrackName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTrackName();
    this->_sTagTrackName.assign(value, size);
}

inline void T_MPlayTagTransferItem_1::clearU32TagSongID() {
    if (hasU32TagSongID()) {
         clear_has_u32TagSongID();
        _u32TagSongID = 0u;
     }
}

inline bool T_MPlayTagTransferItem_1::hasU32TagSongID () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint32 T_MPlayTagTransferItem_1::getU32TagSongID () const {
    return _u32TagSongID;
}

inline void T_MPlayTagTransferItem_1::setU32TagSongID (uint32 u32TagSongID_) {
    set_has_u32TagSongID();
    this->_u32TagSongID = u32TagSongID_;
}

inline void T_MPlayTagTransferItem_1::clearU8AmbiguousTag() {
    if (hasU8AmbiguousTag()) {
         clear_has_u8AmbiguousTag();
        _u8AmbiguousTag = 0u;
     }
}

inline bool T_MPlayTagTransferItem_1::hasU8AmbiguousTag () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint8 T_MPlayTagTransferItem_1::getU8AmbiguousTag () const {
    return _u8AmbiguousTag;
}

inline void T_MPlayTagTransferItem_1::setU8AmbiguousTag (uint8 u8AmbiguousTag_) {
    set_has_u8AmbiguousTag();
    this->_u8AmbiguousTag = u8AmbiguousTag_;
}

inline void T_MPlayTagTransferItem_1::clearU8ButtonPressed() {
    if (hasU8ButtonPressed()) {
         clear_has_u8ButtonPressed();
        _u8ButtonPressed = 0u;
     }
}

inline bool T_MPlayTagTransferItem_1::hasU8ButtonPressed () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint8 T_MPlayTagTransferItem_1::getU8ButtonPressed () const {
    return _u8ButtonPressed;
}

inline void T_MPlayTagTransferItem_1::setU8ButtonPressed (uint8 u8ButtonPressed_) {
    set_has_u8ButtonPressed();
    this->_u8ButtonPressed = u8ButtonPressed_;
}

inline void T_MPlayTagTransferItem_1::clearU8TagProgramNumber() {
    if (hasU8TagProgramNumber()) {
         clear_has_u8TagProgramNumber();
        _u8TagProgramNumber = 0u;
     }
}

inline bool T_MPlayTagTransferItem_1::hasU8TagProgramNumber () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint8 T_MPlayTagTransferItem_1::getU8TagProgramNumber () const {
    return _u8TagProgramNumber;
}

inline void T_MPlayTagTransferItem_1::setU8TagProgramNumber (uint8 u8TagProgramNumber_) {
    set_has_u8TagProgramNumber();
    this->_u8TagProgramNumber = u8TagProgramNumber_;
}

inline void T_MPlayTagTransferItem_1::clearU8TagStorefrontID() {
    if (hasU8TagStorefrontID()) {
         clear_has_u8TagStorefrontID();
        _u8TagStorefrontID = 0u;
     }
}

inline bool T_MPlayTagTransferItem_1::hasU8TagStorefrontID () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline uint8 T_MPlayTagTransferItem_1::getU8TagStorefrontID () const {
    return _u8TagStorefrontID;
}

inline void T_MPlayTagTransferItem_1::setU8TagStorefrontID (uint8 u8TagStorefrontID_) {
    set_has_u8TagStorefrontID();
    this->_u8TagStorefrontID = u8TagStorefrontID_;
}

inline void T_MPlayTagTransferItem_1::set_has_oUnknownData () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MPlayTagTransferItem_1::clear_has_oUnknownData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MPlayTagTransferItem_1::set_has_sPodCastFeedURL () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MPlayTagTransferItem_1::clear_has_sPodCastFeedURL () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MPlayTagTransferItem_1::set_has_sStationURL () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MPlayTagTransferItem_1::clear_has_sStationURL () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MPlayTagTransferItem_1::set_has_sStationURLFrequency () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MPlayTagTransferItem_1::clear_has_sStationURLFrequency () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MPlayTagTransferItem_1::set_has_sTagAffiliateID () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MPlayTagTransferItem_1::clear_has_sTagAffiliateID () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MPlayTagTransferItem_1::set_has_sTagAlbum () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MPlayTagTransferItem_1::clear_has_sTagAlbum () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_MPlayTagTransferItem_1::set_has_sTagArtistName () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_MPlayTagTransferItem_1::clear_has_sTagArtistName () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_MPlayTagTransferItem_1::set_has_sTagChannelName () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_MPlayTagTransferItem_1::clear_has_sTagChannelName () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_MPlayTagTransferItem_1::set_has_sTagChannelNumber () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_MPlayTagTransferItem_1::clear_has_sTagChannelNumber () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_MPlayTagTransferItem_1::set_has_sTagGenre () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_MPlayTagTransferItem_1::clear_has_sTagGenre () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_MPlayTagTransferItem_1::set_has_sTagTimeStamp () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_MPlayTagTransferItem_1::clear_has_sTagTimeStamp () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_MPlayTagTransferItem_1::set_has_sTagTrackName () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_MPlayTagTransferItem_1::clear_has_sTagTrackName () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_MPlayTagTransferItem_1::set_has_u32TagSongID () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_MPlayTagTransferItem_1::clear_has_u32TagSongID () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_MPlayTagTransferItem_1::set_has_u8AmbiguousTag () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_MPlayTagTransferItem_1::clear_has_u8AmbiguousTag () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_MPlayTagTransferItem_1::set_has_u8ButtonPressed () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_MPlayTagTransferItem_1::clear_has_u8ButtonPressed () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_MPlayTagTransferItem_1::set_has_u8TagProgramNumber () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_MPlayTagTransferItem_1::clear_has_u8TagProgramNumber () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_MPlayTagTransferItem_1::set_has_u8TagStorefrontID () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_MPlayTagTransferItem_1::clear_has_u8TagStorefrontID () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline  T_MPlayTagTransferItem_2::T_MPlayTagTransferItem_2 ()  :
    _oUnknownData (),
    _sPodCastFeedURL (),
    _sStationURL (),
    _sStationURLFrequency (),
    _sTagAffiliateID (),
    _sTagAlbum (),
    _sTagArtistName (),
    _sTagChannelName (),
    _sTagChannelNumber (),
    _sTagGenre (),
    _sTagTimeStamp (),
    _sTagTrackName (),
    _u32TagSongID (0u),
    _u32TagStorefrontID (0u),
    _u8AmbiguousTag (0u),
    _u8ButtonPressed (0u),
    _u8TagProgramNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MPlayTagTransferItem_2::T_MPlayTagTransferItem_2 (const T_MPlayTagTransferItem_2 &rhs)  :
    _oUnknownData (),
    _sPodCastFeedURL (),
    _sStationURL (),
    _sStationURLFrequency (),
    _sTagAffiliateID (),
    _sTagAlbum (),
    _sTagArtistName (),
    _sTagChannelName (),
    _sTagChannelNumber (),
    _sTagGenre (),
    _sTagTimeStamp (),
    _sTagTrackName (),
    _u32TagSongID (0u),
    _u32TagStorefrontID (0u),
    _u8AmbiguousTag (0u),
    _u8ButtonPressed (0u),
    _u8TagProgramNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MPlayTagTransferItem_2::T_MPlayTagTransferItem_2 (const ::fi_basetypes::T_ShortStream& oUnknownData_, const ::std::string& sPodCastFeedURL_, const ::std::string& sStationURL_, const ::std::string& sStationURLFrequency_, const ::std::string& sTagAffiliateID_, const ::std::string& sTagAlbum_, const ::std::string& sTagArtistName_, const ::std::string& sTagChannelName_, const ::std::string& sTagChannelNumber_, const ::std::string& sTagGenre_, const ::std::string& sTagTimeStamp_, const ::std::string& sTagTrackName_, uint32 u32TagSongID_, uint32 u32TagStorefrontID_, uint8 u8AmbiguousTag_, uint8 u8ButtonPressed_, uint8 u8TagProgramNumber_)  :
    _oUnknownData (oUnknownData_),
    _sPodCastFeedURL (sPodCastFeedURL_),
    _sStationURL (sStationURL_),
    _sStationURLFrequency (sStationURLFrequency_),
    _sTagAffiliateID (sTagAffiliateID_),
    _sTagAlbum (sTagAlbum_),
    _sTagArtistName (sTagArtistName_),
    _sTagChannelName (sTagChannelName_),
    _sTagChannelNumber (sTagChannelNumber_),
    _sTagGenre (sTagGenre_),
    _sTagTimeStamp (sTagTimeStamp_),
    _sTagTrackName (sTagTrackName_),
    _u32TagSongID (u32TagSongID_),
    _u32TagStorefrontID (u32TagStorefrontID_),
    _u8AmbiguousTag (u8AmbiguousTag_),
    _u8ButtonPressed (u8ButtonPressed_),
    _u8TagProgramNumber (u8TagProgramNumber_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPodCastFeedURL_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationURL_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationURLFrequency_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagAffiliateID_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagChannelNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagGenre_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTimeStamp_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MPlayTagTransferItem_2::~T_MPlayTagTransferItem_2() {
}

inline T_MPlayTagTransferItem_2& T_MPlayTagTransferItem_2::operator = (const T_MPlayTagTransferItem_2& rhs) {
    if( this != &rhs ) {
        if (rhs.hasOUnknownData()) {
            setOUnknownData(rhs.getOUnknownData());
        } else {
            clearOUnknownData();
        }
        if (rhs.hasSPodCastFeedURL()) {
            setSPodCastFeedURL(rhs.getSPodCastFeedURL());
        } else {
            clearSPodCastFeedURL();
        }
        if (rhs.hasSStationURL()) {
            setSStationURL(rhs.getSStationURL());
        } else {
            clearSStationURL();
        }
        if (rhs.hasSStationURLFrequency()) {
            setSStationURLFrequency(rhs.getSStationURLFrequency());
        } else {
            clearSStationURLFrequency();
        }
        if (rhs.hasSTagAffiliateID()) {
            setSTagAffiliateID(rhs.getSTagAffiliateID());
        } else {
            clearSTagAffiliateID();
        }
        if (rhs.hasSTagAlbum()) {
            setSTagAlbum(rhs.getSTagAlbum());
        } else {
            clearSTagAlbum();
        }
        if (rhs.hasSTagArtistName()) {
            setSTagArtistName(rhs.getSTagArtistName());
        } else {
            clearSTagArtistName();
        }
        if (rhs.hasSTagChannelName()) {
            setSTagChannelName(rhs.getSTagChannelName());
        } else {
            clearSTagChannelName();
        }
        if (rhs.hasSTagChannelNumber()) {
            setSTagChannelNumber(rhs.getSTagChannelNumber());
        } else {
            clearSTagChannelNumber();
        }
        if (rhs.hasSTagGenre()) {
            setSTagGenre(rhs.getSTagGenre());
        } else {
            clearSTagGenre();
        }
        if (rhs.hasSTagTimeStamp()) {
            setSTagTimeStamp(rhs.getSTagTimeStamp());
        } else {
            clearSTagTimeStamp();
        }
        if (rhs.hasSTagTrackName()) {
            setSTagTrackName(rhs.getSTagTrackName());
        } else {
            clearSTagTrackName();
        }
        if (rhs.hasU32TagSongID()) {
            setU32TagSongID(rhs.getU32TagSongID());
        } else {
            clearU32TagSongID();
        }
        if (rhs.hasU32TagStorefrontID()) {
            setU32TagStorefrontID(rhs.getU32TagStorefrontID());
        } else {
            clearU32TagStorefrontID();
        }
        if (rhs.hasU8AmbiguousTag()) {
            setU8AmbiguousTag(rhs.getU8AmbiguousTag());
        } else {
            clearU8AmbiguousTag();
        }
        if (rhs.hasU8ButtonPressed()) {
            setU8ButtonPressed(rhs.getU8ButtonPressed());
        } else {
            clearU8ButtonPressed();
        }
        if (rhs.hasU8TagProgramNumber()) {
            setU8TagProgramNumber(rhs.getU8TagProgramNumber());
        } else {
            clearU8TagProgramNumber();
        }
    }
    return *this;
}

inline bool T_MPlayTagTransferItem_2::operator == (const T_MPlayTagTransferItem_2& rhs) const {
    return (((!hasOUnknownData() && !rhs.hasOUnknownData()) || getOUnknownData() == rhs.getOUnknownData()) &&
        ((!hasSPodCastFeedURL() && !rhs.hasSPodCastFeedURL()) || getSPodCastFeedURL() == rhs.getSPodCastFeedURL()) &&
        ((!hasSStationURL() && !rhs.hasSStationURL()) || getSStationURL() == rhs.getSStationURL()) &&
        ((!hasSStationURLFrequency() && !rhs.hasSStationURLFrequency()) || getSStationURLFrequency() == rhs.getSStationURLFrequency()) &&
        ((!hasSTagAffiliateID() && !rhs.hasSTagAffiliateID()) || getSTagAffiliateID() == rhs.getSTagAffiliateID()) &&
        ((!hasSTagAlbum() && !rhs.hasSTagAlbum()) || getSTagAlbum() == rhs.getSTagAlbum()) &&
        ((!hasSTagArtistName() && !rhs.hasSTagArtistName()) || getSTagArtistName() == rhs.getSTagArtistName()) &&
        ((!hasSTagChannelName() && !rhs.hasSTagChannelName()) || getSTagChannelName() == rhs.getSTagChannelName()) &&
        ((!hasSTagChannelNumber() && !rhs.hasSTagChannelNumber()) || getSTagChannelNumber() == rhs.getSTagChannelNumber()) &&
        ((!hasSTagGenre() && !rhs.hasSTagGenre()) || getSTagGenre() == rhs.getSTagGenre()) &&
        ((!hasSTagTimeStamp() && !rhs.hasSTagTimeStamp()) || getSTagTimeStamp() == rhs.getSTagTimeStamp()) &&
        ((!hasSTagTrackName() && !rhs.hasSTagTrackName()) || getSTagTrackName() == rhs.getSTagTrackName()) &&
        ((!hasU32TagSongID() && !rhs.hasU32TagSongID()) || getU32TagSongID() == rhs.getU32TagSongID()) &&
        ((!hasU32TagStorefrontID() && !rhs.hasU32TagStorefrontID()) || getU32TagStorefrontID() == rhs.getU32TagStorefrontID()) &&
        ((!hasU8AmbiguousTag() && !rhs.hasU8AmbiguousTag()) || getU8AmbiguousTag() == rhs.getU8AmbiguousTag()) &&
        ((!hasU8ButtonPressed() && !rhs.hasU8ButtonPressed()) || getU8ButtonPressed() == rhs.getU8ButtonPressed()) &&
        ((!hasU8TagProgramNumber() && !rhs.hasU8TagProgramNumber()) || getU8TagProgramNumber() == rhs.getU8TagProgramNumber()));
}

inline bool T_MPlayTagTransferItem_2::operator != (const T_MPlayTagTransferItem_2& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MPlayTagTransferItem_2::operator < (const T_MPlayTagTransferItem_2& rhs) const {
    if (hasOUnknownData() || rhs.hasOUnknownData()) {
        if (getOUnknownData() < rhs.getOUnknownData()) return true;
        if (getOUnknownData() > rhs.getOUnknownData()) return false;
    }
    if (hasSPodCastFeedURL() || rhs.hasSPodCastFeedURL()) {
        if (getSPodCastFeedURL() < rhs.getSPodCastFeedURL()) return true;
        if (getSPodCastFeedURL() > rhs.getSPodCastFeedURL()) return false;
    }
    if (hasSStationURL() || rhs.hasSStationURL()) {
        if (getSStationURL() < rhs.getSStationURL()) return true;
        if (getSStationURL() > rhs.getSStationURL()) return false;
    }
    if (hasSStationURLFrequency() || rhs.hasSStationURLFrequency()) {
        if (getSStationURLFrequency() < rhs.getSStationURLFrequency()) return true;
        if (getSStationURLFrequency() > rhs.getSStationURLFrequency()) return false;
    }
    if (hasSTagAffiliateID() || rhs.hasSTagAffiliateID()) {
        if (getSTagAffiliateID() < rhs.getSTagAffiliateID()) return true;
        if (getSTagAffiliateID() > rhs.getSTagAffiliateID()) return false;
    }
    if (hasSTagAlbum() || rhs.hasSTagAlbum()) {
        if (getSTagAlbum() < rhs.getSTagAlbum()) return true;
        if (getSTagAlbum() > rhs.getSTagAlbum()) return false;
    }
    if (hasSTagArtistName() || rhs.hasSTagArtistName()) {
        if (getSTagArtistName() < rhs.getSTagArtistName()) return true;
        if (getSTagArtistName() > rhs.getSTagArtistName()) return false;
    }
    if (hasSTagChannelName() || rhs.hasSTagChannelName()) {
        if (getSTagChannelName() < rhs.getSTagChannelName()) return true;
        if (getSTagChannelName() > rhs.getSTagChannelName()) return false;
    }
    if (hasSTagChannelNumber() || rhs.hasSTagChannelNumber()) {
        if (getSTagChannelNumber() < rhs.getSTagChannelNumber()) return true;
        if (getSTagChannelNumber() > rhs.getSTagChannelNumber()) return false;
    }
    if (hasSTagGenre() || rhs.hasSTagGenre()) {
        if (getSTagGenre() < rhs.getSTagGenre()) return true;
        if (getSTagGenre() > rhs.getSTagGenre()) return false;
    }
    if (hasSTagTimeStamp() || rhs.hasSTagTimeStamp()) {
        if (getSTagTimeStamp() < rhs.getSTagTimeStamp()) return true;
        if (getSTagTimeStamp() > rhs.getSTagTimeStamp()) return false;
    }
    if (hasSTagTrackName() || rhs.hasSTagTrackName()) {
        if (getSTagTrackName() < rhs.getSTagTrackName()) return true;
        if (getSTagTrackName() > rhs.getSTagTrackName()) return false;
    }
    if (hasU32TagSongID() || rhs.hasU32TagSongID()) {
        if (getU32TagSongID() < rhs.getU32TagSongID()) return true;
        if (getU32TagSongID() > rhs.getU32TagSongID()) return false;
    }
    if (hasU32TagStorefrontID() || rhs.hasU32TagStorefrontID()) {
        if (getU32TagStorefrontID() < rhs.getU32TagStorefrontID()) return true;
        if (getU32TagStorefrontID() > rhs.getU32TagStorefrontID()) return false;
    }
    if (hasU8AmbiguousTag() || rhs.hasU8AmbiguousTag()) {
        if (getU8AmbiguousTag() < rhs.getU8AmbiguousTag()) return true;
        if (getU8AmbiguousTag() > rhs.getU8AmbiguousTag()) return false;
    }
    if (hasU8ButtonPressed() || rhs.hasU8ButtonPressed()) {
        if (getU8ButtonPressed() < rhs.getU8ButtonPressed()) return true;
        if (getU8ButtonPressed() > rhs.getU8ButtonPressed()) return false;
    }
    if (hasU8TagProgramNumber() || rhs.hasU8TagProgramNumber()) {
        if (getU8TagProgramNumber() < rhs.getU8TagProgramNumber()) return true;
        if (getU8TagProgramNumber() > rhs.getU8TagProgramNumber()) return false;
    }
    return false;
}

inline bool T_MPlayTagTransferItem_2::operator > (const T_MPlayTagTransferItem_2& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MPlayTagTransferItem_2::clear() {
    clearOUnknownData();
    clearSPodCastFeedURL();
    clearSStationURL();
    clearSStationURLFrequency();
    clearSTagAffiliateID();
    clearSTagAlbum();
    clearSTagArtistName();
    clearSTagChannelName();
    clearSTagChannelNumber();
    clearSTagGenre();
    clearSTagTimeStamp();
    clearSTagTrackName();
    clearU32TagSongID();
    clearU32TagStorefrontID();
    clearU8AmbiguousTag();
    clearU8ButtonPressed();
    clearU8TagProgramNumber();
}

inline void T_MPlayTagTransferItem_2::clearOUnknownData() {
    if (hasOUnknownData()) {
         clear_has_oUnknownData();
        _oUnknownData.clear();
     }
}

inline bool T_MPlayTagTransferItem_2::hasOUnknownData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes::T_ShortStream& T_MPlayTagTransferItem_2::getOUnknownData () const {
    return _oUnknownData;
}

inline ::fi_basetypes::T_ShortStream& T_MPlayTagTransferItem_2::getOUnknownDataMutable () {
    set_has_oUnknownData();
    return _oUnknownData;
}

inline void T_MPlayTagTransferItem_2::setOUnknownData (const ::fi_basetypes::T_ShortStream& oUnknownData_) {
    set_has_oUnknownData();
    this->_oUnknownData = oUnknownData_;
}

inline void T_MPlayTagTransferItem_2::clearSPodCastFeedURL() {
    if (hasSPodCastFeedURL()) {
         clear_has_sPodCastFeedURL();
        _sPodCastFeedURL.clear();
     }
}

inline bool T_MPlayTagTransferItem_2::hasSPodCastFeedURL () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_2::getSPodCastFeedURL () const {
    return _sPodCastFeedURL;
}

inline ::std::string& T_MPlayTagTransferItem_2::getSPodCastFeedURLMutable () {
    set_has_sPodCastFeedURL();
    return _sPodCastFeedURL;
}

inline void T_MPlayTagTransferItem_2::setSPodCastFeedURL (const ::std::string& sPodCastFeedURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPodCastFeedURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPodCastFeedURL();
    this->_sPodCastFeedURL = sPodCastFeedURL_;
}

inline void T_MPlayTagTransferItem_2::setSPodCastFeedURL (const char* sPodCastFeedURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPodCastFeedURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPodCastFeedURL();
    this->_sPodCastFeedURL.assign(sPodCastFeedURL_);
}

inline void T_MPlayTagTransferItem_2::setSPodCastFeedURL (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPodCastFeedURL();
    this->_sPodCastFeedURL.assign(value, size);
}

inline void T_MPlayTagTransferItem_2::clearSStationURL() {
    if (hasSStationURL()) {
         clear_has_sStationURL();
        _sStationURL.clear();
     }
}

inline bool T_MPlayTagTransferItem_2::hasSStationURL () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_2::getSStationURL () const {
    return _sStationURL;
}

inline ::std::string& T_MPlayTagTransferItem_2::getSStationURLMutable () {
    set_has_sStationURL();
    return _sStationURL;
}

inline void T_MPlayTagTransferItem_2::setSStationURL (const ::std::string& sStationURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationURL();
    this->_sStationURL = sStationURL_;
}

inline void T_MPlayTagTransferItem_2::setSStationURL (const char* sStationURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationURL();
    this->_sStationURL.assign(sStationURL_);
}

inline void T_MPlayTagTransferItem_2::setSStationURL (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationURL();
    this->_sStationURL.assign(value, size);
}

inline void T_MPlayTagTransferItem_2::clearSStationURLFrequency() {
    if (hasSStationURLFrequency()) {
         clear_has_sStationURLFrequency();
        _sStationURLFrequency.clear();
     }
}

inline bool T_MPlayTagTransferItem_2::hasSStationURLFrequency () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_2::getSStationURLFrequency () const {
    return _sStationURLFrequency;
}

inline ::std::string& T_MPlayTagTransferItem_2::getSStationURLFrequencyMutable () {
    set_has_sStationURLFrequency();
    return _sStationURLFrequency;
}

inline void T_MPlayTagTransferItem_2::setSStationURLFrequency (const ::std::string& sStationURLFrequency_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationURLFrequency_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationURLFrequency();
    this->_sStationURLFrequency = sStationURLFrequency_;
}

inline void T_MPlayTagTransferItem_2::setSStationURLFrequency (const char* sStationURLFrequency_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationURLFrequency_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationURLFrequency();
    this->_sStationURLFrequency.assign(sStationURLFrequency_);
}

inline void T_MPlayTagTransferItem_2::setSStationURLFrequency (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationURLFrequency();
    this->_sStationURLFrequency.assign(value, size);
}

inline void T_MPlayTagTransferItem_2::clearSTagAffiliateID() {
    if (hasSTagAffiliateID()) {
         clear_has_sTagAffiliateID();
        _sTagAffiliateID.clear();
     }
}

inline bool T_MPlayTagTransferItem_2::hasSTagAffiliateID () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_2::getSTagAffiliateID () const {
    return _sTagAffiliateID;
}

inline ::std::string& T_MPlayTagTransferItem_2::getSTagAffiliateIDMutable () {
    set_has_sTagAffiliateID();
    return _sTagAffiliateID;
}

inline void T_MPlayTagTransferItem_2::setSTagAffiliateID (const ::std::string& sTagAffiliateID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagAffiliateID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagAffiliateID();
    this->_sTagAffiliateID = sTagAffiliateID_;
}

inline void T_MPlayTagTransferItem_2::setSTagAffiliateID (const char* sTagAffiliateID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagAffiliateID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagAffiliateID();
    this->_sTagAffiliateID.assign(sTagAffiliateID_);
}

inline void T_MPlayTagTransferItem_2::setSTagAffiliateID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagAffiliateID();
    this->_sTagAffiliateID.assign(value, size);
}

inline void T_MPlayTagTransferItem_2::clearSTagAlbum() {
    if (hasSTagAlbum()) {
         clear_has_sTagAlbum();
        _sTagAlbum.clear();
     }
}

inline bool T_MPlayTagTransferItem_2::hasSTagAlbum () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_2::getSTagAlbum () const {
    return _sTagAlbum;
}

inline ::std::string& T_MPlayTagTransferItem_2::getSTagAlbumMutable () {
    set_has_sTagAlbum();
    return _sTagAlbum;
}

inline void T_MPlayTagTransferItem_2::setSTagAlbum (const ::std::string& sTagAlbum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagAlbum();
    this->_sTagAlbum = sTagAlbum_;
}

inline void T_MPlayTagTransferItem_2::setSTagAlbum (const char* sTagAlbum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagAlbum();
    this->_sTagAlbum.assign(sTagAlbum_);
}

inline void T_MPlayTagTransferItem_2::setSTagAlbum (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagAlbum();
    this->_sTagAlbum.assign(value, size);
}

inline void T_MPlayTagTransferItem_2::clearSTagArtistName() {
    if (hasSTagArtistName()) {
         clear_has_sTagArtistName();
        _sTagArtistName.clear();
     }
}

inline bool T_MPlayTagTransferItem_2::hasSTagArtistName () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_2::getSTagArtistName () const {
    return _sTagArtistName;
}

inline ::std::string& T_MPlayTagTransferItem_2::getSTagArtistNameMutable () {
    set_has_sTagArtistName();
    return _sTagArtistName;
}

inline void T_MPlayTagTransferItem_2::setSTagArtistName (const ::std::string& sTagArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagArtistName();
    this->_sTagArtistName = sTagArtistName_;
}

inline void T_MPlayTagTransferItem_2::setSTagArtistName (const char* sTagArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagArtistName();
    this->_sTagArtistName.assign(sTagArtistName_);
}

inline void T_MPlayTagTransferItem_2::setSTagArtistName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagArtistName();
    this->_sTagArtistName.assign(value, size);
}

inline void T_MPlayTagTransferItem_2::clearSTagChannelName() {
    if (hasSTagChannelName()) {
         clear_has_sTagChannelName();
        _sTagChannelName.clear();
     }
}

inline bool T_MPlayTagTransferItem_2::hasSTagChannelName () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_2::getSTagChannelName () const {
    return _sTagChannelName;
}

inline ::std::string& T_MPlayTagTransferItem_2::getSTagChannelNameMutable () {
    set_has_sTagChannelName();
    return _sTagChannelName;
}

inline void T_MPlayTagTransferItem_2::setSTagChannelName (const ::std::string& sTagChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagChannelName();
    this->_sTagChannelName = sTagChannelName_;
}

inline void T_MPlayTagTransferItem_2::setSTagChannelName (const char* sTagChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagChannelName();
    this->_sTagChannelName.assign(sTagChannelName_);
}

inline void T_MPlayTagTransferItem_2::setSTagChannelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagChannelName();
    this->_sTagChannelName.assign(value, size);
}

inline void T_MPlayTagTransferItem_2::clearSTagChannelNumber() {
    if (hasSTagChannelNumber()) {
         clear_has_sTagChannelNumber();
        _sTagChannelNumber.clear();
     }
}

inline bool T_MPlayTagTransferItem_2::hasSTagChannelNumber () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_2::getSTagChannelNumber () const {
    return _sTagChannelNumber;
}

inline ::std::string& T_MPlayTagTransferItem_2::getSTagChannelNumberMutable () {
    set_has_sTagChannelNumber();
    return _sTagChannelNumber;
}

inline void T_MPlayTagTransferItem_2::setSTagChannelNumber (const ::std::string& sTagChannelNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagChannelNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagChannelNumber();
    this->_sTagChannelNumber = sTagChannelNumber_;
}

inline void T_MPlayTagTransferItem_2::setSTagChannelNumber (const char* sTagChannelNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagChannelNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagChannelNumber();
    this->_sTagChannelNumber.assign(sTagChannelNumber_);
}

inline void T_MPlayTagTransferItem_2::setSTagChannelNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagChannelNumber();
    this->_sTagChannelNumber.assign(value, size);
}

inline void T_MPlayTagTransferItem_2::clearSTagGenre() {
    if (hasSTagGenre()) {
         clear_has_sTagGenre();
        _sTagGenre.clear();
     }
}

inline bool T_MPlayTagTransferItem_2::hasSTagGenre () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_2::getSTagGenre () const {
    return _sTagGenre;
}

inline ::std::string& T_MPlayTagTransferItem_2::getSTagGenreMutable () {
    set_has_sTagGenre();
    return _sTagGenre;
}

inline void T_MPlayTagTransferItem_2::setSTagGenre (const ::std::string& sTagGenre_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagGenre_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagGenre();
    this->_sTagGenre = sTagGenre_;
}

inline void T_MPlayTagTransferItem_2::setSTagGenre (const char* sTagGenre_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagGenre_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagGenre();
    this->_sTagGenre.assign(sTagGenre_);
}

inline void T_MPlayTagTransferItem_2::setSTagGenre (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagGenre();
    this->_sTagGenre.assign(value, size);
}

inline void T_MPlayTagTransferItem_2::clearSTagTimeStamp() {
    if (hasSTagTimeStamp()) {
         clear_has_sTagTimeStamp();
        _sTagTimeStamp.clear();
     }
}

inline bool T_MPlayTagTransferItem_2::hasSTagTimeStamp () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_2::getSTagTimeStamp () const {
    return _sTagTimeStamp;
}

inline ::std::string& T_MPlayTagTransferItem_2::getSTagTimeStampMutable () {
    set_has_sTagTimeStamp();
    return _sTagTimeStamp;
}

inline void T_MPlayTagTransferItem_2::setSTagTimeStamp (const ::std::string& sTagTimeStamp_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTimeStamp_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTimeStamp();
    this->_sTagTimeStamp = sTagTimeStamp_;
}

inline void T_MPlayTagTransferItem_2::setSTagTimeStamp (const char* sTagTimeStamp_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTimeStamp_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTimeStamp();
    this->_sTagTimeStamp.assign(sTagTimeStamp_);
}

inline void T_MPlayTagTransferItem_2::setSTagTimeStamp (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTimeStamp();
    this->_sTagTimeStamp.assign(value, size);
}

inline void T_MPlayTagTransferItem_2::clearSTagTrackName() {
    if (hasSTagTrackName()) {
         clear_has_sTagTrackName();
        _sTagTrackName.clear();
     }
}

inline bool T_MPlayTagTransferItem_2::hasSTagTrackName () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_MPlayTagTransferItem_2::getSTagTrackName () const {
    return _sTagTrackName;
}

inline ::std::string& T_MPlayTagTransferItem_2::getSTagTrackNameMutable () {
    set_has_sTagTrackName();
    return _sTagTrackName;
}

inline void T_MPlayTagTransferItem_2::setSTagTrackName (const ::std::string& sTagTrackName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTrackName();
    this->_sTagTrackName = sTagTrackName_;
}

inline void T_MPlayTagTransferItem_2::setSTagTrackName (const char* sTagTrackName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTrackName();
    this->_sTagTrackName.assign(sTagTrackName_);
}

inline void T_MPlayTagTransferItem_2::setSTagTrackName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTrackName();
    this->_sTagTrackName.assign(value, size);
}

inline void T_MPlayTagTransferItem_2::clearU32TagSongID() {
    if (hasU32TagSongID()) {
         clear_has_u32TagSongID();
        _u32TagSongID = 0u;
     }
}

inline bool T_MPlayTagTransferItem_2::hasU32TagSongID () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint32 T_MPlayTagTransferItem_2::getU32TagSongID () const {
    return _u32TagSongID;
}

inline void T_MPlayTagTransferItem_2::setU32TagSongID (uint32 u32TagSongID_) {
    set_has_u32TagSongID();
    this->_u32TagSongID = u32TagSongID_;
}

inline void T_MPlayTagTransferItem_2::clearU32TagStorefrontID() {
    if (hasU32TagStorefrontID()) {
         clear_has_u32TagStorefrontID();
        _u32TagStorefrontID = 0u;
     }
}

inline bool T_MPlayTagTransferItem_2::hasU32TagStorefrontID () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint32 T_MPlayTagTransferItem_2::getU32TagStorefrontID () const {
    return _u32TagStorefrontID;
}

inline void T_MPlayTagTransferItem_2::setU32TagStorefrontID (uint32 u32TagStorefrontID_) {
    set_has_u32TagStorefrontID();
    this->_u32TagStorefrontID = u32TagStorefrontID_;
}

inline void T_MPlayTagTransferItem_2::clearU8AmbiguousTag() {
    if (hasU8AmbiguousTag()) {
         clear_has_u8AmbiguousTag();
        _u8AmbiguousTag = 0u;
     }
}

inline bool T_MPlayTagTransferItem_2::hasU8AmbiguousTag () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint8 T_MPlayTagTransferItem_2::getU8AmbiguousTag () const {
    return _u8AmbiguousTag;
}

inline void T_MPlayTagTransferItem_2::setU8AmbiguousTag (uint8 u8AmbiguousTag_) {
    set_has_u8AmbiguousTag();
    this->_u8AmbiguousTag = u8AmbiguousTag_;
}

inline void T_MPlayTagTransferItem_2::clearU8ButtonPressed() {
    if (hasU8ButtonPressed()) {
         clear_has_u8ButtonPressed();
        _u8ButtonPressed = 0u;
     }
}

inline bool T_MPlayTagTransferItem_2::hasU8ButtonPressed () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint8 T_MPlayTagTransferItem_2::getU8ButtonPressed () const {
    return _u8ButtonPressed;
}

inline void T_MPlayTagTransferItem_2::setU8ButtonPressed (uint8 u8ButtonPressed_) {
    set_has_u8ButtonPressed();
    this->_u8ButtonPressed = u8ButtonPressed_;
}

inline void T_MPlayTagTransferItem_2::clearU8TagProgramNumber() {
    if (hasU8TagProgramNumber()) {
         clear_has_u8TagProgramNumber();
        _u8TagProgramNumber = 0u;
     }
}

inline bool T_MPlayTagTransferItem_2::hasU8TagProgramNumber () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline uint8 T_MPlayTagTransferItem_2::getU8TagProgramNumber () const {
    return _u8TagProgramNumber;
}

inline void T_MPlayTagTransferItem_2::setU8TagProgramNumber (uint8 u8TagProgramNumber_) {
    set_has_u8TagProgramNumber();
    this->_u8TagProgramNumber = u8TagProgramNumber_;
}

inline void T_MPlayTagTransferItem_2::set_has_oUnknownData () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MPlayTagTransferItem_2::clear_has_oUnknownData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MPlayTagTransferItem_2::set_has_sPodCastFeedURL () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MPlayTagTransferItem_2::clear_has_sPodCastFeedURL () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MPlayTagTransferItem_2::set_has_sStationURL () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MPlayTagTransferItem_2::clear_has_sStationURL () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MPlayTagTransferItem_2::set_has_sStationURLFrequency () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MPlayTagTransferItem_2::clear_has_sStationURLFrequency () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MPlayTagTransferItem_2::set_has_sTagAffiliateID () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MPlayTagTransferItem_2::clear_has_sTagAffiliateID () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MPlayTagTransferItem_2::set_has_sTagAlbum () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MPlayTagTransferItem_2::clear_has_sTagAlbum () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_MPlayTagTransferItem_2::set_has_sTagArtistName () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_MPlayTagTransferItem_2::clear_has_sTagArtistName () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_MPlayTagTransferItem_2::set_has_sTagChannelName () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_MPlayTagTransferItem_2::clear_has_sTagChannelName () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_MPlayTagTransferItem_2::set_has_sTagChannelNumber () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_MPlayTagTransferItem_2::clear_has_sTagChannelNumber () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_MPlayTagTransferItem_2::set_has_sTagGenre () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_MPlayTagTransferItem_2::clear_has_sTagGenre () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_MPlayTagTransferItem_2::set_has_sTagTimeStamp () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_MPlayTagTransferItem_2::clear_has_sTagTimeStamp () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_MPlayTagTransferItem_2::set_has_sTagTrackName () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_MPlayTagTransferItem_2::clear_has_sTagTrackName () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_MPlayTagTransferItem_2::set_has_u32TagSongID () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_MPlayTagTransferItem_2::clear_has_u32TagSongID () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_MPlayTagTransferItem_2::set_has_u32TagStorefrontID () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_MPlayTagTransferItem_2::clear_has_u32TagStorefrontID () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_MPlayTagTransferItem_2::set_has_u8AmbiguousTag () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_MPlayTagTransferItem_2::clear_has_u8AmbiguousTag () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_MPlayTagTransferItem_2::set_has_u8ButtonPressed () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_MPlayTagTransferItem_2::clear_has_u8ButtonPressed () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_MPlayTagTransferItem_2::set_has_u8TagProgramNumber () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_MPlayTagTransferItem_2::clear_has_u8TagProgramNumber () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline  T_MPlayUntransferredTagStreamItem::T_MPlayUntransferredTagStreamItem ()  :
    _sTagArtistName (),
    _sTagTrackName (),
    _u32TagSongID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MPlayUntransferredTagStreamItem::T_MPlayUntransferredTagStreamItem (const T_MPlayUntransferredTagStreamItem &rhs)  :
    _sTagArtistName (),
    _sTagTrackName (),
    _u32TagSongID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MPlayUntransferredTagStreamItem::T_MPlayUntransferredTagStreamItem (const ::std::string& sTagArtistName_, const ::std::string& sTagTrackName_, uint32 u32TagSongID_)  :
    _sTagArtistName (sTagArtistName_),
    _sTagTrackName (sTagTrackName_),
    _u32TagSongID (u32TagSongID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MPlayUntransferredTagStreamItem::~T_MPlayUntransferredTagStreamItem() {
}

inline T_MPlayUntransferredTagStreamItem& T_MPlayUntransferredTagStreamItem::operator = (const T_MPlayUntransferredTagStreamItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSTagArtistName()) {
            setSTagArtistName(rhs.getSTagArtistName());
        } else {
            clearSTagArtistName();
        }
        if (rhs.hasSTagTrackName()) {
            setSTagTrackName(rhs.getSTagTrackName());
        } else {
            clearSTagTrackName();
        }
        if (rhs.hasU32TagSongID()) {
            setU32TagSongID(rhs.getU32TagSongID());
        } else {
            clearU32TagSongID();
        }
    }
    return *this;
}

inline bool T_MPlayUntransferredTagStreamItem::operator == (const T_MPlayUntransferredTagStreamItem& rhs) const {
    return (((!hasSTagArtistName() && !rhs.hasSTagArtistName()) || getSTagArtistName() == rhs.getSTagArtistName()) &&
        ((!hasSTagTrackName() && !rhs.hasSTagTrackName()) || getSTagTrackName() == rhs.getSTagTrackName()) &&
        ((!hasU32TagSongID() && !rhs.hasU32TagSongID()) || getU32TagSongID() == rhs.getU32TagSongID()));
}

inline bool T_MPlayUntransferredTagStreamItem::operator != (const T_MPlayUntransferredTagStreamItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MPlayUntransferredTagStreamItem::operator < (const T_MPlayUntransferredTagStreamItem& rhs) const {
    if (hasSTagArtistName() || rhs.hasSTagArtistName()) {
        if (getSTagArtistName() < rhs.getSTagArtistName()) return true;
        if (getSTagArtistName() > rhs.getSTagArtistName()) return false;
    }
    if (hasSTagTrackName() || rhs.hasSTagTrackName()) {
        if (getSTagTrackName() < rhs.getSTagTrackName()) return true;
        if (getSTagTrackName() > rhs.getSTagTrackName()) return false;
    }
    if (hasU32TagSongID() || rhs.hasU32TagSongID()) {
        if (getU32TagSongID() < rhs.getU32TagSongID()) return true;
        if (getU32TagSongID() > rhs.getU32TagSongID()) return false;
    }
    return false;
}

inline bool T_MPlayUntransferredTagStreamItem::operator > (const T_MPlayUntransferredTagStreamItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MPlayUntransferredTagStreamItem::clear() {
    clearSTagArtistName();
    clearSTagTrackName();
    clearU32TagSongID();
}

inline void T_MPlayUntransferredTagStreamItem::clearSTagArtistName() {
    if (hasSTagArtistName()) {
         clear_has_sTagArtistName();
        _sTagArtistName.clear();
     }
}

inline bool T_MPlayUntransferredTagStreamItem::hasSTagArtistName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_MPlayUntransferredTagStreamItem::getSTagArtistName () const {
    return _sTagArtistName;
}

inline ::std::string& T_MPlayUntransferredTagStreamItem::getSTagArtistNameMutable () {
    set_has_sTagArtistName();
    return _sTagArtistName;
}

inline void T_MPlayUntransferredTagStreamItem::setSTagArtistName (const ::std::string& sTagArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagArtistName();
    this->_sTagArtistName = sTagArtistName_;
}

inline void T_MPlayUntransferredTagStreamItem::setSTagArtistName (const char* sTagArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagArtistName();
    this->_sTagArtistName.assign(sTagArtistName_);
}

inline void T_MPlayUntransferredTagStreamItem::setSTagArtistName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagArtistName();
    this->_sTagArtistName.assign(value, size);
}

inline void T_MPlayUntransferredTagStreamItem::clearSTagTrackName() {
    if (hasSTagTrackName()) {
         clear_has_sTagTrackName();
        _sTagTrackName.clear();
     }
}

inline bool T_MPlayUntransferredTagStreamItem::hasSTagTrackName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_MPlayUntransferredTagStreamItem::getSTagTrackName () const {
    return _sTagTrackName;
}

inline ::std::string& T_MPlayUntransferredTagStreamItem::getSTagTrackNameMutable () {
    set_has_sTagTrackName();
    return _sTagTrackName;
}

inline void T_MPlayUntransferredTagStreamItem::setSTagTrackName (const ::std::string& sTagTrackName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTrackName();
    this->_sTagTrackName = sTagTrackName_;
}

inline void T_MPlayUntransferredTagStreamItem::setSTagTrackName (const char* sTagTrackName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTagTrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTrackName();
    this->_sTagTrackName.assign(sTagTrackName_);
}

inline void T_MPlayUntransferredTagStreamItem::setSTagTrackName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTagTrackName();
    this->_sTagTrackName.assign(value, size);
}

inline void T_MPlayUntransferredTagStreamItem::clearU32TagSongID() {
    if (hasU32TagSongID()) {
         clear_has_u32TagSongID();
        _u32TagSongID = 0u;
     }
}

inline bool T_MPlayUntransferredTagStreamItem::hasU32TagSongID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_MPlayUntransferredTagStreamItem::getU32TagSongID () const {
    return _u32TagSongID;
}

inline void T_MPlayUntransferredTagStreamItem::setU32TagSongID (uint32 u32TagSongID_) {
    set_has_u32TagSongID();
    this->_u32TagSongID = u32TagSongID_;
}

inline void T_MPlayUntransferredTagStreamItem::set_has_sTagArtistName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MPlayUntransferredTagStreamItem::clear_has_sTagArtistName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MPlayUntransferredTagStreamItem::set_has_sTagTrackName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MPlayUntransferredTagStreamItem::clear_has_sTagTrackName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MPlayUntransferredTagStreamItem::set_has_u32TagSongID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MPlayUntransferredTagStreamItem::clear_has_u32TagSongID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SearchString::T_SearchString ()  :
    _sText (),
    _u8Encoding (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SearchString::T_SearchString (const T_SearchString &rhs)  :
    _sText (),
    _u8Encoding (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SearchString::T_SearchString (const ::std::string& sText_, uint8 u8Encoding_)  :
    _sText (sText_),
    _u8Encoding (u8Encoding_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SearchString::~T_SearchString() {
}

inline T_SearchString& T_SearchString::operator = (const T_SearchString& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSText()) {
            setSText(rhs.getSText());
        } else {
            clearSText();
        }
        if (rhs.hasU8Encoding()) {
            setU8Encoding(rhs.getU8Encoding());
        } else {
            clearU8Encoding();
        }
    }
    return *this;
}

inline bool T_SearchString::operator == (const T_SearchString& rhs) const {
    return (((!hasSText() && !rhs.hasSText()) || getSText() == rhs.getSText()) &&
        ((!hasU8Encoding() && !rhs.hasU8Encoding()) || getU8Encoding() == rhs.getU8Encoding()));
}

inline bool T_SearchString::operator != (const T_SearchString& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SearchString::operator < (const T_SearchString& rhs) const {
    if (hasSText() || rhs.hasSText()) {
        if (getSText() < rhs.getSText()) return true;
        if (getSText() > rhs.getSText()) return false;
    }
    if (hasU8Encoding() || rhs.hasU8Encoding()) {
        if (getU8Encoding() < rhs.getU8Encoding()) return true;
        if (getU8Encoding() > rhs.getU8Encoding()) return false;
    }
    return false;
}

inline bool T_SearchString::operator > (const T_SearchString& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SearchString::clear() {
    clearSText();
    clearU8Encoding();
}

inline void T_SearchString::clearSText() {
    if (hasSText()) {
         clear_has_sText();
        _sText.clear();
     }
}

inline bool T_SearchString::hasSText () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_SearchString::getSText () const {
    return _sText;
}

inline ::std::string& T_SearchString::getSTextMutable () {
    set_has_sText();
    return _sText;
}

inline void T_SearchString::setSText (const ::std::string& sText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText();
    this->_sText = sText_;
}

inline void T_SearchString::setSText (const char* sText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText();
    this->_sText.assign(sText_);
}

inline void T_SearchString::setSText (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText();
    this->_sText.assign(value, size);
}

inline void T_SearchString::clearU8Encoding() {
    if (hasU8Encoding()) {
         clear_has_u8Encoding();
        _u8Encoding = 0u;
     }
}

inline bool T_SearchString::hasU8Encoding () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_SearchString::getU8Encoding () const {
    return _u8Encoding;
}

inline void T_SearchString::setU8Encoding (uint8 u8Encoding_) {
    set_has_u8Encoding();
    this->_u8Encoding = u8Encoding_;
}

inline void T_SearchString::set_has_sText () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SearchString::clear_has_sText () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SearchString::set_has_u8Encoding () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SearchString::clear_has_u8Encoding () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace MPlay_fi_types

#endif // MPLAY_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
