/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "mplay_devicemanager_fiCca.h"
#include "mplay_devicemanager_fiJson.h"
#include "mplay_devicemanager_fiProxy.h"
#include "mplay_devicemanager_fi_types.h"
#include "mplay_devicemanager_fi_typesConst.h"
#include "mplay_shared_fi_typesConst.h"
#include <string>
#include <vector>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace mplay_devicemanager_fi {

/*static*/ ::asf::core::Logger Mplay_devicemanager_fiProxy::_logger ("/mplay_devicemanager_fi/Mplay_devicemanager_fiProxy");


class Mplay_devicemanager_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Mplay_devicemanager_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Mplay_devicemanager_fiProxy> proxy = ::boost::static_pointer_cast<Mplay_devicemanager_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_DevManagerMountCDROMInternal: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerMountCDROMInternalResult);
                                setActAndLogResult(message, "DevManagerMountCDROMInternal", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerMountCDROMInternalCallbackIF*) _callback)->onDevManagerMountCDROMInternalResult (proxy, ::boost::static_pointer_cast<DevManagerMountCDROMInternalResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerMountCDROMInternalError);
                                setActAndLogError(message, "DevManagerMountCDROMInternal", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerMountCDROMInternalCallbackIF*) _callback)->onDevManagerMountCDROMInternalError (proxy, ::boost::static_pointer_cast<DevManagerMountCDROMInternalError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerEjectOpticalDisc: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerEjectOpticalDiscResult);
                                setActAndLogResult(message, "DevManagerEjectOpticalDisc", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerEjectOpticalDiscCallbackIF*) _callback)->onDevManagerEjectOpticalDiscResult (proxy, ::boost::static_pointer_cast<DevManagerEjectOpticalDiscResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerEjectOpticalDiscError);
                                setActAndLogError(message, "DevManagerEjectOpticalDisc", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerEjectOpticalDiscCallbackIF*) _callback)->onDevManagerEjectOpticalDiscError (proxy, ::boost::static_pointer_cast<DevManagerEjectOpticalDiscError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerAddTelematicsBox: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerAddTelematicsBoxResult);
                                setActAndLogResult(message, "DevManagerAddTelematicsBox", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerAddTelematicsBoxCallbackIF*) _callback)->onDevManagerAddTelematicsBoxResult (proxy, ::boost::static_pointer_cast<DevManagerAddTelematicsBoxResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerAddTelematicsBoxError);
                                setActAndLogError(message, "DevManagerAddTelematicsBox", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerAddTelematicsBoxCallbackIF*) _callback)->onDevManagerAddTelematicsBoxError (proxy, ::boost::static_pointer_cast<DevManagerAddTelematicsBoxError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerSetConfigurationValue: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerSetConfigurationValueResult);
                                setActAndLogResult(message, "DevManagerSetConfigurationValue", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerSetConfigurationValueCallbackIF*) _callback)->onDevManagerSetConfigurationValueResult (proxy, ::boost::static_pointer_cast<DevManagerSetConfigurationValueResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerSetConfigurationValueError);
                                setActAndLogError(message, "DevManagerSetConfigurationValue", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerSetConfigurationValueCallbackIF*) _callback)->onDevManagerSetConfigurationValueError (proxy, ::boost::static_pointer_cast<DevManagerSetConfigurationValueError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerGetConfigurationValue: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerGetConfigurationValueResult);
                                setActAndLogResult(message, "DevManagerGetConfigurationValue", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerGetConfigurationValueCallbackIF*) _callback)->onDevManagerGetConfigurationValueResult (proxy, ::boost::static_pointer_cast<DevManagerGetConfigurationValueResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerGetConfigurationValueError);
                                setActAndLogError(message, "DevManagerGetConfigurationValue", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerGetConfigurationValueCallbackIF*) _callback)->onDevManagerGetConfigurationValueError (proxy, ::boost::static_pointer_cast<DevManagerGetConfigurationValueError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerAddExternalHub: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerAddExternalHubResult);
                                setActAndLogResult(message, "DevManagerAddExternalHub", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerAddExternalHubCallbackIF*) _callback)->onDevManagerAddExternalHubResult (proxy, ::boost::static_pointer_cast<DevManagerAddExternalHubResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerAddExternalHubError);
                                setActAndLogError(message, "DevManagerAddExternalHub", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerAddExternalHubCallbackIF*) _callback)->onDevManagerAddExternalHubError (proxy, ::boost::static_pointer_cast<DevManagerAddExternalHubError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerGetDevProperties: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerGetDevPropertiesResult);
                                setActAndLogResult(message, "DevManagerGetDevProperties", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerGetDevPropertiesCallbackIF*) _callback)->onDevManagerGetDevPropertiesResult (proxy, ::boost::static_pointer_cast<DevManagerGetDevPropertiesResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerGetDevPropertiesError);
                                setActAndLogError(message, "DevManagerGetDevProperties", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerGetDevPropertiesCallbackIF*) _callback)->onDevManagerGetDevPropertiesError (proxy, ::boost::static_pointer_cast<DevManagerGetDevPropertiesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerGetAllConnectedDevices: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerGetAllConnectedDevicesResult);
                                setActAndLogResult(message, "DevManagerGetAllConnectedDevices", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerGetAllConnectedDevicesCallbackIF*) _callback)->onDevManagerGetAllConnectedDevicesResult (proxy, ::boost::static_pointer_cast<DevManagerGetAllConnectedDevicesResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerGetAllConnectedDevicesError);
                                setActAndLogError(message, "DevManagerGetAllConnectedDevices", reinterpret_cast<act_t>(this), _logger);
                                ((DevManagerGetAllConnectedDevicesCallbackIF*) _callback)->onDevManagerGetAllConnectedDevicesError (proxy, ::boost::static_pointer_cast<DevManagerGetAllConnectedDevicesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerNotifyConnection: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerNotifyConnectionStatus);
                                setActAndLogStatus(message, "DevManagerNotifyConnection", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DevManagerNotifyConnectionStatus> payload = ::boost::static_pointer_cast<DevManagerNotifyConnectionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DevManagerNotifyConnectionStatus >& refNullableStatus = proxy->_devManagerNotifyConnection;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DevManagerNotifyConnectionCallbackIF*) _callback)->onDevManagerNotifyConnectionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DevManagerNotifyConnectionCallbackIF*) _callback)->onDevManagerNotifyConnectionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerNotifyConnectionError);
                                setActAndLogError(message, "DevManagerNotifyConnection", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DevManagerNotifyConnectionCallbackIF*) _callback)->onDevManagerNotifyConnectionError(proxy, ::boost::static_pointer_cast<DevManagerNotifyConnectionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerNotifySDCard: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerNotifySDCardStatus);
                                setActAndLogStatus(message, "DevManagerNotifySDCard", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DevManagerNotifySDCardStatus> payload = ::boost::static_pointer_cast<DevManagerNotifySDCardStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DevManagerNotifySDCardStatus >& refNullableStatus = proxy->_devManagerNotifySDCard;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DevManagerNotifySDCardCallbackIF*) _callback)->onDevManagerNotifySDCardStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DevManagerNotifySDCardCallbackIF*) _callback)->onDevManagerNotifySDCardStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerNotifySDCardError);
                                setActAndLogError(message, "DevManagerNotifySDCard", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DevManagerNotifySDCardCallbackIF*) _callback)->onDevManagerNotifySDCardError(proxy, ::boost::static_pointer_cast<DevManagerNotifySDCardError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerOverTempCD: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerOverTempCDStatus);
                                setActAndLogStatus(message, "DevManagerOverTempCD", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DevManagerOverTempCDStatus> payload = ::boost::static_pointer_cast<DevManagerOverTempCDStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DevManagerOverTempCDStatus >& refNullableStatus = proxy->_devManagerOverTempCD;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DevManagerOverTempCDCallbackIF*) _callback)->onDevManagerOverTempCDStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DevManagerOverTempCDCallbackIF*) _callback)->onDevManagerOverTempCDStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerOverTempCDError);
                                setActAndLogError(message, "DevManagerOverTempCD", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DevManagerOverTempCDCallbackIF*) _callback)->onDevManagerOverTempCDError(proxy, ::boost::static_pointer_cast<DevManagerOverTempCDError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerTelematicsBoxAlive: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerTelematicsBoxAliveStatus);
                                setActAndLogStatus(message, "DevManagerTelematicsBoxAlive", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DevManagerTelematicsBoxAliveStatus> payload = ::boost::static_pointer_cast<DevManagerTelematicsBoxAliveStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DevManagerTelematicsBoxAliveStatus >& refNullableStatus = proxy->_devManagerTelematicsBoxAlive;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DevManagerTelematicsBoxAliveCallbackIF*) _callback)->onDevManagerTelematicsBoxAliveStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DevManagerTelematicsBoxAliveCallbackIF*) _callback)->onDevManagerTelematicsBoxAliveStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerTelematicsBoxAliveError);
                                setActAndLogError(message, "DevManagerTelematicsBoxAlive", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DevManagerTelematicsBoxAliveCallbackIF*) _callback)->onDevManagerTelematicsBoxAliveError(proxy, ::boost::static_pointer_cast<DevManagerTelematicsBoxAliveError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerNotifySlotStateOpticalDisc: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerNotifySlotStateOpticalDiscStatus);
                                setActAndLogStatus(message, "DevManagerNotifySlotStateOpticalDisc", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DevManagerNotifySlotStateOpticalDiscStatus> payload = ::boost::static_pointer_cast<DevManagerNotifySlotStateOpticalDiscStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DevManagerNotifySlotStateOpticalDiscStatus >& refNullableStatus = proxy->_devManagerNotifySlotStateOpticalDisc;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DevManagerNotifySlotStateOpticalDiscCallbackIF*) _callback)->onDevManagerNotifySlotStateOpticalDiscStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DevManagerNotifySlotStateOpticalDiscCallbackIF*) _callback)->onDevManagerNotifySlotStateOpticalDiscStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerNotifySlotStateOpticalDiscError);
                                setActAndLogError(message, "DevManagerNotifySlotStateOpticalDisc", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DevManagerNotifySlotStateOpticalDiscCallbackIF*) _callback)->onDevManagerNotifySlotStateOpticalDiscError(proxy, ::boost::static_pointer_cast<DevManagerNotifySlotStateOpticalDiscError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerNotifyCDInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerNotifyCDInfoStatus);
                                setActAndLogStatus(message, "DevManagerNotifyCDInfo", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DevManagerNotifyCDInfoStatus> payload = ::boost::static_pointer_cast<DevManagerNotifyCDInfoStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DevManagerNotifyCDInfoStatus >& refNullableStatus = proxy->_devManagerNotifyCDInfo;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DevManagerNotifyCDInfoCallbackIF*) _callback)->onDevManagerNotifyCDInfoStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DevManagerNotifyCDInfoCallbackIF*) _callback)->onDevManagerNotifyCDInfoStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerNotifyCDInfoError);
                                setActAndLogError(message, "DevManagerNotifyCDInfo", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DevManagerNotifyCDInfoCallbackIF*) _callback)->onDevManagerNotifyCDInfoError(proxy, ::boost::static_pointer_cast<DevManagerNotifyCDInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevManagerDVDDriveInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerDVDDriveInfoStatus);
                                setActAndLogStatus(message, "DevManagerDVDDriveInfo", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DevManagerDVDDriveInfoStatus> payload = ::boost::static_pointer_cast<DevManagerDVDDriveInfoStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DevManagerDVDDriveInfoStatus >& refNullableStatus = proxy->_devManagerDVDDriveInfo;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DevManagerDVDDriveInfoCallbackIF*) _callback)->onDevManagerDVDDriveInfoStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DevManagerDVDDriveInfoCallbackIF*) _callback)->onDevManagerDVDDriveInfoStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerDVDDriveInfoError);
                                setActAndLogError(message, "DevManagerDVDDriveInfo", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DevManagerDVDDriveInfoCallbackIF*) _callback)->onDevManagerDVDDriveInfoError(proxy, ::boost::static_pointer_cast<DevManagerDVDDriveInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Mplay_devicemanager_fiProxy> proxy = ::boost::static_pointer_cast<Mplay_devicemanager_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_DevManagerMountCDROMInternal: {
                ::boost::shared_ptr< DevManagerMountCDROMInternalError > payload (new DevManagerMountCDROMInternalError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerMountCDROMInternal", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DevManagerMountCDROMInternalCallbackIF*) _callback)->onDevManagerMountCDROMInternalError (proxy, payload);
                return true;
            }
            case FID_DevManagerEjectOpticalDisc: {
                ::boost::shared_ptr< DevManagerEjectOpticalDiscError > payload (new DevManagerEjectOpticalDiscError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerEjectOpticalDisc", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DevManagerEjectOpticalDiscCallbackIF*) _callback)->onDevManagerEjectOpticalDiscError (proxy, payload);
                return true;
            }
            case FID_DevManagerAddTelematicsBox: {
                ::boost::shared_ptr< DevManagerAddTelematicsBoxError > payload (new DevManagerAddTelematicsBoxError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerAddTelematicsBox", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DevManagerAddTelematicsBoxCallbackIF*) _callback)->onDevManagerAddTelematicsBoxError (proxy, payload);
                return true;
            }
            case FID_DevManagerSetConfigurationValue: {
                ::boost::shared_ptr< DevManagerSetConfigurationValueError > payload (new DevManagerSetConfigurationValueError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerSetConfigurationValue", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DevManagerSetConfigurationValueCallbackIF*) _callback)->onDevManagerSetConfigurationValueError (proxy, payload);
                return true;
            }
            case FID_DevManagerGetConfigurationValue: {
                ::boost::shared_ptr< DevManagerGetConfigurationValueError > payload (new DevManagerGetConfigurationValueError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerGetConfigurationValue", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DevManagerGetConfigurationValueCallbackIF*) _callback)->onDevManagerGetConfigurationValueError (proxy, payload);
                return true;
            }
            case FID_DevManagerAddExternalHub: {
                ::boost::shared_ptr< DevManagerAddExternalHubError > payload (new DevManagerAddExternalHubError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerAddExternalHub", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DevManagerAddExternalHubCallbackIF*) _callback)->onDevManagerAddExternalHubError (proxy, payload);
                return true;
            }
            case FID_DevManagerGetDevProperties: {
                ::boost::shared_ptr< DevManagerGetDevPropertiesError > payload (new DevManagerGetDevPropertiesError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerGetDevProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DevManagerGetDevPropertiesCallbackIF*) _callback)->onDevManagerGetDevPropertiesError (proxy, payload);
                return true;
            }
            case FID_DevManagerGetAllConnectedDevices: {
                ::boost::shared_ptr< DevManagerGetAllConnectedDevicesError > payload (new DevManagerGetAllConnectedDevicesError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerGetAllConnectedDevices", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DevManagerGetAllConnectedDevicesCallbackIF*) _callback)->onDevManagerGetAllConnectedDevicesError (proxy, payload);
                return true;
            }
            case FID_DevManagerNotifyConnection: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DevManagerNotifyConnectionError > payload (new DevManagerNotifyConnectionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerNotifyConnection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DevManagerNotifyConnectionCallbackIF*) _callback)->onDevManagerNotifyConnectionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DevManagerNotifySDCard: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DevManagerNotifySDCardError > payload (new DevManagerNotifySDCardError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerNotifySDCard", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DevManagerNotifySDCardCallbackIF*) _callback)->onDevManagerNotifySDCardError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DevManagerOverTempCD: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DevManagerOverTempCDError > payload (new DevManagerOverTempCDError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerOverTempCD", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DevManagerOverTempCDCallbackIF*) _callback)->onDevManagerOverTempCDError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DevManagerTelematicsBoxAlive: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DevManagerTelematicsBoxAliveError > payload (new DevManagerTelematicsBoxAliveError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerTelematicsBoxAlive", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DevManagerTelematicsBoxAliveCallbackIF*) _callback)->onDevManagerTelematicsBoxAliveError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DevManagerNotifySlotStateOpticalDisc: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DevManagerNotifySlotStateOpticalDiscError > payload (new DevManagerNotifySlotStateOpticalDiscError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerNotifySlotStateOpticalDisc", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DevManagerNotifySlotStateOpticalDiscCallbackIF*) _callback)->onDevManagerNotifySlotStateOpticalDiscError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DevManagerNotifyCDInfo: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DevManagerNotifyCDInfoError > payload (new DevManagerNotifyCDInfoError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerNotifyCDInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DevManagerNotifyCDInfoCallbackIF*) _callback)->onDevManagerNotifyCDInfoError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DevManagerDVDDriveInfo: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DevManagerDVDDriveInfoError > payload (new DevManagerDVDDriveInfoError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevManagerDVDDriveInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DevManagerDVDDriveInfoCallbackIF*) _callback)->onDevManagerDVDDriveInfoError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Mplay_devicemanager_fiProxyCallback::_logger (Mplay_devicemanager_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Mplay_devicemanager_fiProxy > Mplay_devicemanager_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Mplay_devicemanager_fiProxy >  proxyNew(new Mplay_devicemanager_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Mplay_devicemanager_fiProxy > Mplay_devicemanager_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Mplay_devicemanager_fiProxy >  proxyNew(new Mplay_devicemanager_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Mplay_devicemanager_fiProxy > Mplay_devicemanager_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Mplay_devicemanager_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Mplay_devicemanager_fiProxy >  proxyNew(new Mplay_devicemanager_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Mplay_devicemanager_fiProxy::Mplay_devicemanager_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Mplay_devicemanager_fiProxy::~Mplay_devicemanager_fiProxy()
{
    LOG_INFO ("Entering ~Mplay_devicemanager_fiProxy");
    sendRelUpRegAll ();
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerMountCDROMInternalStart(DevManagerMountCDROMInternalCallbackIF& cb, bool mount, const ::std::string& blockDevice) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DevManagerMountCDROMInternal);
        ::boost::shared_ptr< DevManagerMountCDROMInternalStart > payload (new DevManagerMountCDROMInternalStart());
        payload->setMount(mount);
        payload->setBlockDevice(blockDevice);
        CCA_MESSAGE(ccaMessage,header,DevManagerMountCDROMInternalStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DevManagerMountCDROMInternal", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerMountCDROMInternal);
        ::boost::shared_ptr< DevManagerMountCDROMInternalError > payload (new DevManagerMountCDROMInternalError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerMountCDROMInternalError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DevManagerMountCDROMInternal", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerEjectOpticalDiscStart(DevManagerEjectOpticalDiscCallbackIF& cb, ::mplay_shared_fi_types::T_e8_EjectParmType eCmdParam) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DevManagerEjectOpticalDisc);
        ::boost::shared_ptr< DevManagerEjectOpticalDiscStart > payload (new DevManagerEjectOpticalDiscStart());
        payload->setECmdParam(eCmdParam);
        CCA_MESSAGE(ccaMessage,header,DevManagerEjectOpticalDiscStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DevManagerEjectOpticalDisc", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerEjectOpticalDisc);
        ::boost::shared_ptr< DevManagerEjectOpticalDiscError > payload (new DevManagerEjectOpticalDiscError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerEjectOpticalDiscError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DevManagerEjectOpticalDisc", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerAddTelematicsBoxStart(DevManagerAddTelematicsBoxCallbackIF& cb, uint32 vendorID, uint32 productID, uint32 uSBPortNo, ::mplay_devicemanager_fi_types::T_e8_DVM_DeviceSpeedUsb speedInfo, bool add) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DevManagerAddTelematicsBox);
        ::boost::shared_ptr< DevManagerAddTelematicsBoxStart > payload (new DevManagerAddTelematicsBoxStart());
        payload->setVendorID(vendorID);
        payload->setProductID(productID);
        payload->setUSBPortNo(uSBPortNo);
        payload->setSpeedInfo(speedInfo);
        payload->setAdd(add);
        CCA_MESSAGE(ccaMessage,header,DevManagerAddTelematicsBoxStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DevManagerAddTelematicsBox", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerAddTelematicsBox);
        ::boost::shared_ptr< DevManagerAddTelematicsBoxError > payload (new DevManagerAddTelematicsBoxError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerAddTelematicsBoxError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DevManagerAddTelematicsBox", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerSetConfigurationValueStart(DevManagerSetConfigurationValueCallbackIF& cb, const ::std::string& configurationParam, uint16 value, ::mplay_devicemanager_fi_types::T_e8_SettingsMode settingsMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DevManagerSetConfigurationValue);
        ::boost::shared_ptr< DevManagerSetConfigurationValueStart > payload (new DevManagerSetConfigurationValueStart());
        payload->setConfigurationParam(configurationParam);
        payload->setValue(value);
        payload->setSettingsMode(settingsMode);
        CCA_MESSAGE(ccaMessage,header,DevManagerSetConfigurationValueStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DevManagerSetConfigurationValue", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerSetConfigurationValue);
        ::boost::shared_ptr< DevManagerSetConfigurationValueError > payload (new DevManagerSetConfigurationValueError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerSetConfigurationValueError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DevManagerSetConfigurationValue", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerGetConfigurationValueStart(DevManagerGetConfigurationValueCallbackIF& cb, const ::std::string& configurationParam) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DevManagerGetConfigurationValue);
        ::boost::shared_ptr< DevManagerGetConfigurationValueStart > payload (new DevManagerGetConfigurationValueStart());
        payload->setConfigurationParam(configurationParam);
        CCA_MESSAGE(ccaMessage,header,DevManagerGetConfigurationValueStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DevManagerGetConfigurationValue", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerGetConfigurationValue);
        ::boost::shared_ptr< DevManagerGetConfigurationValueError > payload (new DevManagerGetConfigurationValueError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerGetConfigurationValueError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DevManagerGetConfigurationValue", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerAddExternalHubStart(DevManagerAddExternalHubCallbackIF& cb, uint32 vendorID, uint32 productID, uint32 uSBPortNo, bool add) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DevManagerAddExternalHub);
        ::boost::shared_ptr< DevManagerAddExternalHubStart > payload (new DevManagerAddExternalHubStart());
        payload->setVendorID(vendorID);
        payload->setProductID(productID);
        payload->setUSBPortNo(uSBPortNo);
        payload->setAdd(add);
        CCA_MESSAGE(ccaMessage,header,DevManagerAddExternalHubStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DevManagerAddExternalHub", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerAddExternalHub);
        ::boost::shared_ptr< DevManagerAddExternalHubError > payload (new DevManagerAddExternalHubError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerAddExternalHubError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DevManagerAddExternalHub", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerGetDevPropertiesStart(DevManagerGetDevPropertiesCallbackIF& cb, const ::std::string& deviceSerialNo) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DevManagerGetDevProperties);
        ::boost::shared_ptr< DevManagerGetDevPropertiesStart > payload (new DevManagerGetDevPropertiesStart());
        payload->setDeviceSerialNo(deviceSerialNo);
        CCA_MESSAGE(ccaMessage,header,DevManagerGetDevPropertiesStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DevManagerGetDevProperties", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerGetDevProperties);
        ::boost::shared_ptr< DevManagerGetDevPropertiesError > payload (new DevManagerGetDevPropertiesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerGetDevPropertiesError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DevManagerGetDevProperties", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerGetAllConnectedDevicesStart(DevManagerGetAllConnectedDevicesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DevManagerGetAllConnectedDevices);
        ::boost::shared_ptr< DevManagerGetAllConnectedDevicesStart > payload (new DevManagerGetAllConnectedDevicesStart());
        CCA_MESSAGE(ccaMessage,header,DevManagerGetAllConnectedDevicesStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DevManagerGetAllConnectedDevices", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerGetAllConnectedDevices);
        ::boost::shared_ptr< DevManagerGetAllConnectedDevicesError > payload (new DevManagerGetAllConnectedDevicesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerGetAllConnectedDevicesError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DevManagerGetAllConnectedDevices", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerNotifyConnectionUpReg(DevManagerNotifyConnectionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DevManagerNotifyConnection);
        ::boost::shared_ptr< DevManagerNotifyConnectionUpReg > payload (new DevManagerNotifyConnectionUpReg());
        CCA_MESSAGE(ccaMessage,header,DevManagerNotifyConnectionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DevManagerNotifyConnectionRelUpReg > payloadRelUpRegHeap (new DevManagerNotifyConnectionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DevManagerNotifyConnection, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerNotifyConnectionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DevManagerNotifyConnection, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DevManagerNotifyConnection", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DevManagerNotifyConnection", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDevManagerNotifyConnection()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DevManagerNotifyConnection, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DevManagerNotifyConnectionStatus > payloadLoopback (new DevManagerNotifyConnectionStatus(getDevManagerNotifyConnection()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DevManagerNotifyConnectionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerNotifyConnection);
        ::boost::shared_ptr< DevManagerNotifyConnectionError > payload (new DevManagerNotifyConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerNotifyConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DevManagerNotifyConnection", &cb);
    }
}

bool Mplay_devicemanager_fiProxy::sendDevManagerNotifyConnectionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DevManagerNotifyConnection,"DevManagerNotifyConnection");
}

void Mplay_devicemanager_fiProxy::sendDevManagerNotifyConnectionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DevManagerNotifyConnection);
}

const DevManagerNotifyConnectionStatus& Mplay_devicemanager_fiProxy::getDevManagerNotifyConnection() const {
    return _devManagerNotifyConnection.get();
}

bool Mplay_devicemanager_fiProxy::hasDevManagerNotifyConnection() const {
    return _devManagerNotifyConnection.hasValue();
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerNotifyConnectionGet(DevManagerNotifyConnectionCallbackIF& cb, const ::std::vector< ::mplay_devicemanager_fi_types::T_DevManager_DeviceProperty >& devicetype) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DevManagerNotifyConnection);
        ::boost::shared_ptr< DevManagerNotifyConnectionGet > payload (new DevManagerNotifyConnectionGet());
        payload->setDevicetype(devicetype);
        CCA_MESSAGE(ccaMessage,header,DevManagerNotifyConnectionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DevManagerNotifyConnection", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerNotifyConnection);
        ::boost::shared_ptr< DevManagerNotifyConnectionError > payload (new DevManagerNotifyConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerNotifyConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DevManagerNotifyConnection", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerNotifySDCardUpReg(DevManagerNotifySDCardCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DevManagerNotifySDCard);
        ::boost::shared_ptr< DevManagerNotifySDCardUpReg > payload (new DevManagerNotifySDCardUpReg());
        CCA_MESSAGE(ccaMessage,header,DevManagerNotifySDCardUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DevManagerNotifySDCardRelUpReg > payloadRelUpRegHeap (new DevManagerNotifySDCardRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DevManagerNotifySDCard, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerNotifySDCardRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DevManagerNotifySDCard, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DevManagerNotifySDCard", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DevManagerNotifySDCard", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDevManagerNotifySDCard()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DevManagerNotifySDCard, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DevManagerNotifySDCardStatus > payloadLoopback (new DevManagerNotifySDCardStatus(getDevManagerNotifySDCard()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DevManagerNotifySDCardStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerNotifySDCard);
        ::boost::shared_ptr< DevManagerNotifySDCardError > payload (new DevManagerNotifySDCardError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerNotifySDCardError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DevManagerNotifySDCard", &cb);
    }
}

bool Mplay_devicemanager_fiProxy::sendDevManagerNotifySDCardRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DevManagerNotifySDCard,"DevManagerNotifySDCard");
}

void Mplay_devicemanager_fiProxy::sendDevManagerNotifySDCardRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DevManagerNotifySDCard);
}

const DevManagerNotifySDCardStatus& Mplay_devicemanager_fiProxy::getDevManagerNotifySDCard() const {
    return _devManagerNotifySDCard.get();
}

bool Mplay_devicemanager_fiProxy::hasDevManagerNotifySDCard() const {
    return _devManagerNotifySDCard.hasValue();
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerNotifySDCardGet(DevManagerNotifySDCardCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DevManagerNotifySDCard);
        ::boost::shared_ptr< DevManagerNotifySDCardGet > payload (new DevManagerNotifySDCardGet());
        CCA_MESSAGE(ccaMessage,header,DevManagerNotifySDCardGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DevManagerNotifySDCard", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerNotifySDCard);
        ::boost::shared_ptr< DevManagerNotifySDCardError > payload (new DevManagerNotifySDCardError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerNotifySDCardError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DevManagerNotifySDCard", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerOverTempCDUpReg(DevManagerOverTempCDCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DevManagerOverTempCD);
        ::boost::shared_ptr< DevManagerOverTempCDUpReg > payload (new DevManagerOverTempCDUpReg());
        CCA_MESSAGE(ccaMessage,header,DevManagerOverTempCDUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DevManagerOverTempCDRelUpReg > payloadRelUpRegHeap (new DevManagerOverTempCDRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DevManagerOverTempCD, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerOverTempCDRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DevManagerOverTempCD, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DevManagerOverTempCD", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DevManagerOverTempCD", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDevManagerOverTempCD()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DevManagerOverTempCD, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DevManagerOverTempCDStatus > payloadLoopback (new DevManagerOverTempCDStatus(getDevManagerOverTempCD()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DevManagerOverTempCDStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerOverTempCD);
        ::boost::shared_ptr< DevManagerOverTempCDError > payload (new DevManagerOverTempCDError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerOverTempCDError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DevManagerOverTempCD", &cb);
    }
}

bool Mplay_devicemanager_fiProxy::sendDevManagerOverTempCDRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DevManagerOverTempCD,"DevManagerOverTempCD");
}

void Mplay_devicemanager_fiProxy::sendDevManagerOverTempCDRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DevManagerOverTempCD);
}

const DevManagerOverTempCDStatus& Mplay_devicemanager_fiProxy::getDevManagerOverTempCD() const {
    return _devManagerOverTempCD.get();
}

bool Mplay_devicemanager_fiProxy::hasDevManagerOverTempCD() const {
    return _devManagerOverTempCD.hasValue();
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerOverTempCDGet(DevManagerOverTempCDCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DevManagerOverTempCD);
        ::boost::shared_ptr< DevManagerOverTempCDGet > payload (new DevManagerOverTempCDGet());
        CCA_MESSAGE(ccaMessage,header,DevManagerOverTempCDGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DevManagerOverTempCD", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerOverTempCD);
        ::boost::shared_ptr< DevManagerOverTempCDError > payload (new DevManagerOverTempCDError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerOverTempCDError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DevManagerOverTempCD", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerOverTempCDSet(DevManagerOverTempCDCallbackIF& cb, bool overTemperature) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DevManagerOverTempCD);
        ::boost::shared_ptr< DevManagerOverTempCDSet > payload (new DevManagerOverTempCDSet());
        payload->setOverTemperature(overTemperature);
        CCA_MESSAGE(ccaMessage,header,DevManagerOverTempCDSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DevManagerOverTempCD", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerOverTempCD);
        ::boost::shared_ptr< DevManagerOverTempCDError > payload (new DevManagerOverTempCDError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerOverTempCDError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DevManagerOverTempCD", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerTelematicsBoxAliveUpReg(DevManagerTelematicsBoxAliveCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DevManagerTelematicsBoxAlive);
        ::boost::shared_ptr< DevManagerTelematicsBoxAliveUpReg > payload (new DevManagerTelematicsBoxAliveUpReg());
        CCA_MESSAGE(ccaMessage,header,DevManagerTelematicsBoxAliveUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DevManagerTelematicsBoxAliveRelUpReg > payloadRelUpRegHeap (new DevManagerTelematicsBoxAliveRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DevManagerTelematicsBoxAlive, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerTelematicsBoxAliveRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DevManagerTelematicsBoxAlive, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DevManagerTelematicsBoxAlive", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DevManagerTelematicsBoxAlive", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDevManagerTelematicsBoxAlive()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DevManagerTelematicsBoxAlive, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DevManagerTelematicsBoxAliveStatus > payloadLoopback (new DevManagerTelematicsBoxAliveStatus(getDevManagerTelematicsBoxAlive()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DevManagerTelematicsBoxAliveStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerTelematicsBoxAlive);
        ::boost::shared_ptr< DevManagerTelematicsBoxAliveError > payload (new DevManagerTelematicsBoxAliveError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerTelematicsBoxAliveError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DevManagerTelematicsBoxAlive", &cb);
    }
}

bool Mplay_devicemanager_fiProxy::sendDevManagerTelematicsBoxAliveRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DevManagerTelematicsBoxAlive,"DevManagerTelematicsBoxAlive");
}

void Mplay_devicemanager_fiProxy::sendDevManagerTelematicsBoxAliveRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DevManagerTelematicsBoxAlive);
}

const DevManagerTelematicsBoxAliveStatus& Mplay_devicemanager_fiProxy::getDevManagerTelematicsBoxAlive() const {
    return _devManagerTelematicsBoxAlive.get();
}

bool Mplay_devicemanager_fiProxy::hasDevManagerTelematicsBoxAlive() const {
    return _devManagerTelematicsBoxAlive.hasValue();
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerTelematicsBoxAliveGet(DevManagerTelematicsBoxAliveCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DevManagerTelematicsBoxAlive);
        ::boost::shared_ptr< DevManagerTelematicsBoxAliveGet > payload (new DevManagerTelematicsBoxAliveGet());
        CCA_MESSAGE(ccaMessage,header,DevManagerTelematicsBoxAliveGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DevManagerTelematicsBoxAlive", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerTelematicsBoxAlive);
        ::boost::shared_ptr< DevManagerTelematicsBoxAliveError > payload (new DevManagerTelematicsBoxAliveError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerTelematicsBoxAliveError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DevManagerTelematicsBoxAlive", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerTelematicsBoxAliveSet(DevManagerTelematicsBoxAliveCallbackIF& cb, bool bTAConnectionStatus, uint32 timoutBeforeSendingITC) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DevManagerTelematicsBoxAlive);
        ::boost::shared_ptr< DevManagerTelematicsBoxAliveSet > payload (new DevManagerTelematicsBoxAliveSet());
        payload->setBTAConnectionStatus(bTAConnectionStatus);
        payload->setTimoutBeforeSendingITC(timoutBeforeSendingITC);
        CCA_MESSAGE(ccaMessage,header,DevManagerTelematicsBoxAliveSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DevManagerTelematicsBoxAlive", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerTelematicsBoxAlive);
        ::boost::shared_ptr< DevManagerTelematicsBoxAliveError > payload (new DevManagerTelematicsBoxAliveError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerTelematicsBoxAliveError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DevManagerTelematicsBoxAlive", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerNotifySlotStateOpticalDiscUpReg(DevManagerNotifySlotStateOpticalDiscCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DevManagerNotifySlotStateOpticalDisc);
        ::boost::shared_ptr< DevManagerNotifySlotStateOpticalDiscUpReg > payload (new DevManagerNotifySlotStateOpticalDiscUpReg());
        CCA_MESSAGE(ccaMessage,header,DevManagerNotifySlotStateOpticalDiscUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DevManagerNotifySlotStateOpticalDiscRelUpReg > payloadRelUpRegHeap (new DevManagerNotifySlotStateOpticalDiscRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DevManagerNotifySlotStateOpticalDisc, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerNotifySlotStateOpticalDiscRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DevManagerNotifySlotStateOpticalDisc, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DevManagerNotifySlotStateOpticalDisc", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DevManagerNotifySlotStateOpticalDisc", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDevManagerNotifySlotStateOpticalDisc()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DevManagerNotifySlotStateOpticalDisc, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DevManagerNotifySlotStateOpticalDiscStatus > payloadLoopback (new DevManagerNotifySlotStateOpticalDiscStatus(getDevManagerNotifySlotStateOpticalDisc()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DevManagerNotifySlotStateOpticalDiscStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerNotifySlotStateOpticalDisc);
        ::boost::shared_ptr< DevManagerNotifySlotStateOpticalDiscError > payload (new DevManagerNotifySlotStateOpticalDiscError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerNotifySlotStateOpticalDiscError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DevManagerNotifySlotStateOpticalDisc", &cb);
    }
}

bool Mplay_devicemanager_fiProxy::sendDevManagerNotifySlotStateOpticalDiscRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DevManagerNotifySlotStateOpticalDisc,"DevManagerNotifySlotStateOpticalDisc");
}

void Mplay_devicemanager_fiProxy::sendDevManagerNotifySlotStateOpticalDiscRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DevManagerNotifySlotStateOpticalDisc);
}

const DevManagerNotifySlotStateOpticalDiscStatus& Mplay_devicemanager_fiProxy::getDevManagerNotifySlotStateOpticalDisc() const {
    return _devManagerNotifySlotStateOpticalDisc.get();
}

bool Mplay_devicemanager_fiProxy::hasDevManagerNotifySlotStateOpticalDisc() const {
    return _devManagerNotifySlotStateOpticalDisc.hasValue();
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerNotifySlotStateOpticalDiscGet(DevManagerNotifySlotStateOpticalDiscCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DevManagerNotifySlotStateOpticalDisc);
        ::boost::shared_ptr< DevManagerNotifySlotStateOpticalDiscGet > payload (new DevManagerNotifySlotStateOpticalDiscGet());
        CCA_MESSAGE(ccaMessage,header,DevManagerNotifySlotStateOpticalDiscGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DevManagerNotifySlotStateOpticalDisc", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerNotifySlotStateOpticalDisc);
        ::boost::shared_ptr< DevManagerNotifySlotStateOpticalDiscError > payload (new DevManagerNotifySlotStateOpticalDiscError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerNotifySlotStateOpticalDiscError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DevManagerNotifySlotStateOpticalDisc", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerNotifyCDInfoUpReg(DevManagerNotifyCDInfoCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DevManagerNotifyCDInfo);
        ::boost::shared_ptr< DevManagerNotifyCDInfoUpReg > payload (new DevManagerNotifyCDInfoUpReg());
        CCA_MESSAGE(ccaMessage,header,DevManagerNotifyCDInfoUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DevManagerNotifyCDInfoRelUpReg > payloadRelUpRegHeap (new DevManagerNotifyCDInfoRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DevManagerNotifyCDInfo, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerNotifyCDInfoRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DevManagerNotifyCDInfo, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DevManagerNotifyCDInfo", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DevManagerNotifyCDInfo", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDevManagerNotifyCDInfo()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DevManagerNotifyCDInfo, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DevManagerNotifyCDInfoStatus > payloadLoopback (new DevManagerNotifyCDInfoStatus(getDevManagerNotifyCDInfo()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DevManagerNotifyCDInfoStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerNotifyCDInfo);
        ::boost::shared_ptr< DevManagerNotifyCDInfoError > payload (new DevManagerNotifyCDInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerNotifyCDInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DevManagerNotifyCDInfo", &cb);
    }
}

bool Mplay_devicemanager_fiProxy::sendDevManagerNotifyCDInfoRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DevManagerNotifyCDInfo,"DevManagerNotifyCDInfo");
}

void Mplay_devicemanager_fiProxy::sendDevManagerNotifyCDInfoRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DevManagerNotifyCDInfo);
}

const DevManagerNotifyCDInfoStatus& Mplay_devicemanager_fiProxy::getDevManagerNotifyCDInfo() const {
    return _devManagerNotifyCDInfo.get();
}

bool Mplay_devicemanager_fiProxy::hasDevManagerNotifyCDInfo() const {
    return _devManagerNotifyCDInfo.hasValue();
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerNotifyCDInfoGet(DevManagerNotifyCDInfoCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DevManagerNotifyCDInfo);
        ::boost::shared_ptr< DevManagerNotifyCDInfoGet > payload (new DevManagerNotifyCDInfoGet());
        CCA_MESSAGE(ccaMessage,header,DevManagerNotifyCDInfoGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DevManagerNotifyCDInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerNotifyCDInfo);
        ::boost::shared_ptr< DevManagerNotifyCDInfoError > payload (new DevManagerNotifyCDInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerNotifyCDInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DevManagerNotifyCDInfo", &cb);
    }
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerDVDDriveInfoUpReg(DevManagerDVDDriveInfoCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DevManagerDVDDriveInfo);
        ::boost::shared_ptr< DevManagerDVDDriveInfoUpReg > payload (new DevManagerDVDDriveInfoUpReg());
        CCA_MESSAGE(ccaMessage,header,DevManagerDVDDriveInfoUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DevManagerDVDDriveInfoRelUpReg > payloadRelUpRegHeap (new DevManagerDVDDriveInfoRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DevManagerDVDDriveInfo, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mplay_devicemanager_fi::DevManagerDVDDriveInfoRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DevManagerDVDDriveInfo, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DevManagerDVDDriveInfo", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DevManagerDVDDriveInfo", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDevManagerDVDDriveInfo()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DevManagerDVDDriveInfo, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DevManagerDVDDriveInfoStatus > payloadLoopback (new DevManagerDVDDriveInfoStatus(getDevManagerDVDDriveInfo()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DevManagerDVDDriveInfoStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerDVDDriveInfo);
        ::boost::shared_ptr< DevManagerDVDDriveInfoError > payload (new DevManagerDVDDriveInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerDVDDriveInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DevManagerDVDDriveInfo", &cb);
    }
}

bool Mplay_devicemanager_fiProxy::sendDevManagerDVDDriveInfoRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DevManagerDVDDriveInfo,"DevManagerDVDDriveInfo");
}

void Mplay_devicemanager_fiProxy::sendDevManagerDVDDriveInfoRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DevManagerDVDDriveInfo);
}

const DevManagerDVDDriveInfoStatus& Mplay_devicemanager_fiProxy::getDevManagerDVDDriveInfo() const {
    return _devManagerDVDDriveInfo.get();
}

bool Mplay_devicemanager_fiProxy::hasDevManagerDVDDriveInfo() const {
    return _devManagerDVDDriveInfo.hasValue();
}

act_t Mplay_devicemanager_fiProxy::sendDevManagerDVDDriveInfoSet(DevManagerDVDDriveInfoCallbackIF& cb, ::mplay_devicemanager_fi_types::T_e8_MDVDDiscType e8DVDDiscType, ::mplay_devicemanager_fi_types::T_e8_MDVDDriveMode e8DVDDriveMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DevManagerDVDDriveInfo);
        ::boost::shared_ptr< DevManagerDVDDriveInfoSet > payload (new DevManagerDVDDriveInfoSet());
        payload->setE8DVDDiscType(e8DVDDiscType);
        payload->setE8DVDDriveMode(e8DVDDriveMode);
        CCA_MESSAGE(ccaMessage,header,DevManagerDVDDriveInfoSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DevManagerDVDDriveInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevManagerDVDDriveInfo);
        ::boost::shared_ptr< DevManagerDVDDriveInfoError > payload (new DevManagerDVDDriveInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevManagerDVDDriveInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DevManagerDVDDriveInfo", &cb);
    }
}


void Mplay_devicemanager_fiProxy::clearAllProperties ()
{
    _devManagerNotifyConnection = ::asf::core::nullable<DevManagerNotifyConnectionStatus>();
    _devManagerNotifySDCard = ::asf::core::nullable<DevManagerNotifySDCardStatus>();
    _devManagerOverTempCD = ::asf::core::nullable<DevManagerOverTempCDStatus>();
    _devManagerTelematicsBoxAlive = ::asf::core::nullable<DevManagerTelematicsBoxAliveStatus>();
    _devManagerNotifySlotStateOpticalDisc = ::asf::core::nullable<DevManagerNotifySlotStateOpticalDiscStatus>();
    _devManagerNotifyCDInfo = ::asf::core::nullable<DevManagerNotifyCDInfoStatus>();
    _devManagerDVDDriveInfo = ::asf::core::nullable<DevManagerDVDDriveInfoStatus>();
}

void Mplay_devicemanager_fiProxy::sendRelUpRegAll()
{
    sendDevManagerNotifyConnectionRelUpRegAll();
    sendDevManagerNotifySDCardRelUpRegAll();
    sendDevManagerOverTempCDRelUpRegAll();
    sendDevManagerTelematicsBoxAliveRelUpRegAll();
    sendDevManagerNotifySlotStateOpticalDiscRelUpRegAll();
    sendDevManagerNotifyCDInfoRelUpRegAll();
    sendDevManagerDVDDriveInfoRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Mplay_devicemanager_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Mplay_devicemanager_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace mplay_devicemanager_fi
