/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "midw_smartphoneint_fi_types.h"
#include "midw_smartphoneint_fi_typesCca.h"
#include "midw_smartphoneint_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::midw_smartphoneint_fi_types::T_ProjectionCapability& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEnUSBPortType();
    out << (uint8) in.getEnDeviceType();
    out << (uint8) in.getEnCarplayProjection();
    out << (uint8) in.getEnAndroidProjection();
    out << (uint8) in.getEnMirrorlinkProjection();
    out << (uint8) in.getEnMySPINProjection();
    out << (uint8) in.getEnCarlifeProjection();
    out << (uint8) in.getEnOnCarProjection();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_ProjectionCapability& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o0;
    in >> o0;
    out.setEnUSBPortType((::midw_smartphoneint_fi_types::T_e8_USBPortType)o0);
    uint8 o1;
    in >> o1;
    out.setEnDeviceType((::midw_smartphoneint_fi_types::T_e8_DeviceType)o1);
    uint8 o2;
    in >> o2;
    out.setEnCarplayProjection((::midw_smartphoneint_fi_types::T_e8_SupportInfo)o2);
    uint8 o3;
    in >> o3;
    out.setEnAndroidProjection((::midw_smartphoneint_fi_types::T_e8_SupportInfo)o3);
    uint8 o4;
    in >> o4;
    out.setEnMirrorlinkProjection((::midw_smartphoneint_fi_types::T_e8_SupportInfo)o4);
    uint8 o5;
    in >> o5;
    out.setEnMySPINProjection((::midw_smartphoneint_fi_types::T_e8_SupportInfo)o5);
    uint8 o6;
    in >> o6;
    out.setEnCarlifeProjection((::midw_smartphoneint_fi_types::T_e8_SupportInfo)o6);
    uint8 o7;
    in >> o7;
    out.setEnOnCarProjection((::midw_smartphoneint_fi_types::T_e8_SupportInfo)o7);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_DeviceSelectionInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEnDeviceSelectionState();
    out << (uint8) in.getEnDeviceSelectionErrorType();
    out << (uint8) in.getEnDeviceSelectionProgressState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_DeviceSelectionInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o8;
    in >> o8;
    out.setEnDeviceSelectionState((::midw_smartphoneint_fi_types::T_e8_DeviceSelectionState)o8);
    uint8 o9;
    in >> o9;
    out.setEnDeviceSelectionErrorType((::midw_smartphoneint_fi_types::T_e8_DeviceSelectionErrorType)o9);
    uint8 o10;
    in >> o10;
    out.setEnDeviceSelectionProgressState((::midw_smartphoneint_fi_types::T_e8_DeviceSelectionProgressState)o10);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_DeviceDetails& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32DeviceHandle();
    out << in.getSzDeviceName();
    out << (uint8) in.getEnDeviceCategory();
    out << in.getSzDeviceModelName();
    out << in.getSzDeviceManufacturerName();
    out << (uint8) in.getEnDeviceConnectionStatus();
    out << (uint8) in.getEnDeviceConnectionType();
    serializeCca(in.getRVersionInfo(), out, majorVersion);
    out << (uint8) in.getEnDeviceUsageEnabled();
    out << (uint8) in.getBSelectedDevice();
    out << (uint8) in.getBDAPSupport();
    serializeCca(in.getRProjectionCapability(), out, majorVersion);
    out << in.getSzBTAddress();
    serializeCca(in.getRDeviceSelectionInfo(), out, majorVersion);
    out << in.getSzSerialNumber();
    out << (uint8) in.getEnUserAuthorizationStatus();
    out << (uint8) in.getEnSessionTransportType();
    out << in.getU32VendorID();
    out << in.getU32ProductID();
    out << in.getSzSystemPath();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_DeviceDetails& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o11;
    in >> o11;
    out.setU32DeviceHandle(o11);
    ::std::string o12;
    in >> o12;
    out.setSzDeviceName(o12);
    uint8 o13;
    in >> o13;
    out.setEnDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o13);
    ::std::string o14;
    in >> o14;
    out.setSzDeviceModelName(o14);
    ::std::string o15;
    in >> o15;
    out.setSzDeviceManufacturerName(o15);
    uint8 o16;
    in >> o16;
    out.setEnDeviceConnectionStatus((::midw_smartphoneint_fi_types::T_e8_DeviceConnectionStatus)o16);
    uint8 o17;
    in >> o17;
    out.setEnDeviceConnectionType((::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType)o17);
    deserializeCca(in, out.getRVersionInfoMutable(), majorVersion);
    uint8 o18;
    in >> o18;
    out.setEnDeviceUsageEnabled((::midw_smartphoneint_fi_types::T_e8_EnabledInfo)o18);
    bool o19;
    in >> o19;
    out.setBSelectedDevice(o19);
    bool o20;
    in >> o20;
    out.setBDAPSupport(o20);
    deserializeCca(in, out.getRProjectionCapabilityMutable(), majorVersion);
    ::std::string o21;
    in >> o21;
    out.setSzBTAddress(o21);
    deserializeCca(in, out.getRDeviceSelectionInfoMutable(), majorVersion);
    ::std::string o22;
    in >> o22;
    out.setSzSerialNumber(o22);
    uint8 o23;
    in >> o23;
    out.setEnUserAuthorizationStatus((::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus)o23);
    uint8 o24;
    in >> o24;
    out.setEnSessionTransportType((::midw_smartphoneint_fi_types::T_e8_SessionTransportType)o24);
    uint32 o25;
    in >> o25;
    out.setU32VendorID(o25);
    uint32 o26;
    in >> o26;
    out.setU32ProductID(o26);
    ::std::string o27;
    in >> o27;
    out.setSzSystemPath(o27);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_AppDetails& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32AppHandle();
    out << in.getSzAppName();
    out << (uint8) in.getEnAppStatus();
    out << in.getSzAppVariant();
    out << in.getSzAppProviderName();
    out << in.getSzAppProviderURL();
    out << in.getSzAppDescription();
    {
        uint32 o28 = static_cast<uint32>(in.getAppAllowedProfiles().size());
        out << o28;
        ::std::vector< ::std::string >::const_iterator o29;
        for (o29 = in.getAppAllowedProfiles().begin(); o29 != in.getAppAllowedProfiles().end(); ++o29) {
            out << (*o29);
        }
    }
    out << in.getSzAppCertificateURL();
    out << (uint32) in.getEnAppCategory();
    out << (uint16) in.getEnTrustLevel();
    out << (uint8) in.getE8AppCertificationInfo();
    serializeCca(in.getRAppDisplayInfo(), out, majorVersion);
    serializeCca(in.getRAppAudioInfo(), out, majorVersion);
    serializeCca(in.getRAppRemotingInfo(), out, majorVersion);
    out << in.getU16NumAppIcons();
    {
        uint32 o30 = static_cast<uint32>(in.getAppIconList().size());
        out << o30;
        ::std::vector< ::midw_smartphoneint_fi_types::T_IconAttributes >::const_iterator o31;
        for (o31 = in.getAppIconList().begin(); o31 != in.getAppIconList().end(); ++o31) {
            serializeCca((*o31), out, majorVersion);
        }
    }
    out << (uint8) in.getE8AppCertificationEntity();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_AppDetails& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o32;
    in >> o32;
    out.setU32AppHandle(o32);
    ::std::string o33;
    in >> o33;
    out.setSzAppName(o33);
    uint8 o34;
    in >> o34;
    out.setEnAppStatus((::midw_smartphoneint_fi_types::T_e8_AppStatus)o34);
    ::std::string o35;
    in >> o35;
    out.setSzAppVariant(o35);
    ::std::string o36;
    in >> o36;
    out.setSzAppProviderName(o36);
    ::std::string o37;
    in >> o37;
    out.setSzAppProviderURL(o37);
    ::std::string o38;
    in >> o38;
    out.setSzAppDescription(o38);
    {
        uint32 o39;
        in >> o39;
        out.getAppAllowedProfilesMutable().clear ();
        out.getAppAllowedProfilesMutable().reserve (o39);
        for (uint32 o40 = 0; o40 < o39; o40++) {
            ::std::string o41;
            in >> o41;
            out.getAppAllowedProfilesMutable().push_back (o41);

        }
    }
    ::std::string o42;
    in >> o42;
    out.setSzAppCertificateURL(o42);
    uint32 o43;
    in >> o43;
    out.setEnAppCategory((::midw_smartphoneint_fi_types::T_e32_AppCategory)o43);
    uint16 o44;
    in >> o44;
    out.setEnTrustLevel((::midw_smartphoneint_fi_types::T_e16_TrustLevel)o44);
    uint8 o45;
    in >> o45;
    out.setE8AppCertificationInfo((::midw_smartphoneint_fi_types::T_e8_AppCertificationInfo)o45);
    deserializeCca(in, out.getRAppDisplayInfoMutable(), majorVersion);
    deserializeCca(in, out.getRAppAudioInfoMutable(), majorVersion);
    deserializeCca(in, out.getRAppRemotingInfoMutable(), majorVersion);
    uint16 o46;
    in >> o46;
    out.setU16NumAppIcons(o46);
    {
        uint32 o47;
        in >> o47;
        out.getAppIconListMutable().clear ();
        out.getAppIconListMutable().reserve (o47);
        for (uint32 o48 = 0; o48 < o47; o48++) {
            ::midw_smartphoneint_fi_types::T_IconAttributes o49;
            deserializeCca(in, o49, majorVersion);
            out.getAppIconListMutable().push_back (o49);
        }
    }
    uint8 o50;
    in >> o50;
    out.setE8AppCertificationEntity((::midw_smartphoneint_fi_types::T_e8_AppCertificationEntity)o50);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_AppRemotingInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSzRemotingProtocolID();
    out << in.getSzRemotingFormat();
    out << in.getSzRemotingDirection();
    out << in.getU32RemotingAudioIPL();
    out << in.getU32RemotingAudioMPL();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_AppRemotingInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o51;
    in >> o51;
    out.setSzRemotingProtocolID(o51);
    ::std::string o52;
    in >> o52;
    out.setSzRemotingFormat(o52);
    ::std::string o53;
    in >> o53;
    out.setSzRemotingDirection(o53);
    uint32 o54;
    in >> o54;
    out.setU32RemotingAudioIPL(o54);
    uint32 o55;
    in >> o55;
    out.setU32RemotingAudioMPL(o55);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_AppDisplayInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint32) in.getEnAppDisplayCategory();
    out << (uint16) in.getEnTrustLevel();
    out << in.getU32AppDisplayRules();
    out << in.getSzAppDisplayOrientation();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_AppDisplayInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o56;
    in >> o56;
    out.setEnAppDisplayCategory((::midw_smartphoneint_fi_types::T_e32_AppDisplayCategory)o56);
    uint16 o57;
    in >> o57;
    out.setEnTrustLevel((::midw_smartphoneint_fi_types::T_e16_TrustLevel)o57);
    uint32 o58;
    in >> o58;
    out.setU32AppDisplayRules(o58);
    ::std::string o59;
    in >> o59;
    out.setSzAppDisplayOrientation(o59);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_AppAudioInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSzAppAudioType();
    out << (uint32) in.getEnAppAudioCategory();
    out << (uint16) in.getEnTrustLevel();
    out << in.getU32AppAudioRules();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_AppAudioInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o60;
    in >> o60;
    out.setSzAppAudioType(o60);
    uint32 o61;
    in >> o61;
    out.setEnAppAudioCategory((::midw_smartphoneint_fi_types::T_e32_AppAudioCategory)o61);
    uint16 o62;
    in >> o62;
    out.setEnTrustLevel((::midw_smartphoneint_fi_types::T_e16_TrustLevel)o62);
    uint32 o63;
    in >> o63;
    out.setU32AppAudioRules(o63);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_VersionInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSzMinorVersion();
    out << in.getSzMajorVersion();
    out << in.getSzPatchVersion();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_VersionInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o64;
    in >> o64;
    out.setSzMinorVersion(o64);
    ::std::string o65;
    in >> o65;
    out.setSzMajorVersion(o65);
    ::std::string o66;
    in >> o66;
    out.setSzPatchVersion(o66);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_EAPAppInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSzAppName();
    out << in.getSzProtocol();
    out << in.getSzBundleID();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_EAPAppInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o67;
    in >> o67;
    out.setSzAppName(o67);
    ::std::string o68;
    in >> o68;
    out.setSzProtocol(o68);
    ::std::string o69;
    in >> o69;
    out.setSzBundleID(o69);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_IconAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32IconWidth();
    out << in.getU32IconHeight();
    out << in.getU32IconDepth();
    out << (uint8) in.getEnIconMimeType();
    out << in.getSzIconURL();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_IconAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o70;
    in >> o70;
    out.setU32IconWidth(o70);
    uint32 o71;
    in >> o71;
    out.setU32IconHeight(o71);
    uint32 o72;
    in >> o72;
    out.setU32IconDepth(o72);
    uint8 o73;
    in >> o73;
    out.setEnIconMimeType((::midw_smartphoneint_fi_types::T_e8_IconMimeType)o73);
    ::std::string o74;
    in >> o74;
    out.setSzIconURL(o74);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_TouchData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16TouchDescriptors();
    {
        uint32 o75 = static_cast<uint32>(in.getTouchInfoList().size());
        out << o75;
        ::std::vector< ::midw_smartphoneint_fi_types::T_TouchInfo >::const_iterator o76;
        for (o76 = in.getTouchInfoList().begin(); o76 != in.getTouchInfoList().end(); ++o76) {
            {
                uint32 o77 = static_cast<uint32>((*o76).size());
                out << o77;
                ::std::vector< ::midw_smartphoneint_fi_types::T_TouchCoordinates >::const_iterator o78;
                for (o78 = (*o76).begin(); o78 != (*o76).end(); ++o78) {
                    serializeCca((*o78), out, majorVersion);
                }
            }
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_TouchData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o79;
    in >> o79;
    out.setU16TouchDescriptors(o79);
    {
        uint32 o80;
        in >> o80;
        out.getTouchInfoListMutable().clear ();
        out.getTouchInfoListMutable().reserve (o80);
        for (uint32 o81 = 0; o81 < o80; o81++) {
            ::midw_smartphoneint_fi_types::T_TouchInfo o82;
            {
                uint32 o83;
                in >> o83;
                o82.clear ();
                o82.reserve (o83);
                for (uint32 o84 = 0; o84 < o83; o84++) {
                    ::midw_smartphoneint_fi_types::T_TouchCoordinates o85;
                    deserializeCca(in, o85, majorVersion);
                    o82.push_back (o85);
                }
            }
            out.getTouchInfoListMutable().push_back (o82);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_TouchCoordinates& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEnTouchMode();
    out << in.getU16XCoordinate();
    out << in.getU16YCoordinate();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_TouchCoordinates& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o86;
    in >> o86;
    out.setEnTouchMode((::midw_smartphoneint_fi_types::T_e8_TouchMode)o86);
    uint16 o87;
    in >> o87;
    out.setU16XCoordinate(o87);
    uint16 o88;
    in >> o88;
    out.setU16YCoordinate(o88);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_VideoAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEnOrientationMode();
    serializeCca(in.getRScreenAttributes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_VideoAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o89;
    in >> o89;
    out.setEnOrientationMode((::midw_smartphoneint_fi_types::T_e8_OrientationMode)o89);
    deserializeCca(in, out.getRScreenAttributesMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_NotificationEnable& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32AppHandle();
    out << (uint8) in.getEnEnabledInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_NotificationEnable& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o90;
    in >> o90;
    out.setU32AppHandle(o90);
    uint8 o91;
    in >> o91;
    out.setEnEnabledInfo((::midw_smartphoneint_fi_types::T_e8_EnabledInfo)o91);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_NotificationData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16NotificationID();
    out << in.getSzNotificationTitle();
    out << in.getSzNotificationBody();
    out << in.getU16NotificationIconCount();
    {
        uint32 o92 = static_cast<uint32>(in.getNotificationIconList().size());
        out << o92;
        ::std::vector< ::midw_smartphoneint_fi_types::T_IconAttributes >::const_iterator o93;
        for (o93 = in.getNotificationIconList().begin(); o93 != in.getNotificationIconList().end(); ++o93) {
            serializeCca((*o93), out, majorVersion);
        }
    }
    out << in.getU16NotificationAppID();
    {
        uint32 o94 = static_cast<uint32>(in.getNotificationActionList().size());
        out << o94;
        ::std::vector< ::midw_smartphoneint_fi_types::T_NotificationAction >::const_iterator o95;
        for (o95 = in.getNotificationActionList().begin(); o95 != in.getNotificationActionList().end(); ++o95) {
            serializeCca((*o95), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_NotificationData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o96;
    in >> o96;
    out.setU16NotificationID(o96);
    ::std::string o97;
    in >> o97;
    out.setSzNotificationTitle(o97);
    ::std::string o98;
    in >> o98;
    out.setSzNotificationBody(o98);
    uint16 o99;
    in >> o99;
    out.setU16NotificationIconCount(o99);
    {
        uint32 o100;
        in >> o100;
        out.getNotificationIconListMutable().clear ();
        out.getNotificationIconListMutable().reserve (o100);
        for (uint32 o101 = 0; o101 < o100; o101++) {
            ::midw_smartphoneint_fi_types::T_IconAttributes o102;
            deserializeCca(in, o102, majorVersion);
            out.getNotificationIconListMutable().push_back (o102);
        }
    }
    uint16 o103;
    in >> o103;
    out.setU16NotificationAppID(o103);
    {
        uint32 o104;
        in >> o104;
        out.getNotificationActionListMutable().clear ();
        out.getNotificationActionListMutable().reserve (o104);
        for (uint32 o105 = 0; o105 < o104; o105++) {
            ::midw_smartphoneint_fi_types::T_NotificationAction o106;
            deserializeCca(in, o106, majorVersion);
            out.getNotificationActionListMutable().push_back (o106);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_NotificationAction& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16NotificationActionID();
    out << in.getSzNotificationActionName();
    out << in.getU16NotificationActionIconCount();
    {
        uint32 o107 = static_cast<uint32>(in.getNotificationActionIconList().size());
        out << o107;
        ::std::vector< ::midw_smartphoneint_fi_types::T_IconAttributes >::const_iterator o108;
        for (o108 = in.getNotificationActionIconList().begin(); o108 != in.getNotificationActionIconList().end(); ++o108) {
            serializeCca((*o108), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_NotificationAction& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o109;
    in >> o109;
    out.setU16NotificationActionID(o109);
    ::std::string o110;
    in >> o110;
    out.setSzNotificationActionName(o110);
    uint16 o111;
    in >> o111;
    out.setU16NotificationActionIconCount(o111);
    {
        uint32 o112;
        in >> o112;
        out.getNotificationActionIconListMutable().clear ();
        out.getNotificationActionIconListMutable().reserve (o112);
        for (uint32 o113 = 0; o113 < o112; o113++) {
            ::midw_smartphoneint_fi_types::T_IconAttributes o114;
            deserializeCca(in, o114, majorVersion);
            out.getNotificationActionIconListMutable().push_back (o114);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_ScreenAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16ScreenHeight();
    out << in.getU16ScreenWidth();
    out << (uint8) in.getEnScreenAspectRatio();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_ScreenAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o115;
    in >> o115;
    out.setU16ScreenHeight(o115);
    uint16 o116;
    in >> o116;
    out.setU16ScreenWidth(o116);
    uint8 o117;
    in >> o117;
    out.setEnScreenAspectRatio((::midw_smartphoneint_fi_types::T_e8_ScreenAspectRatio)o117);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_ClientCapabilities& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRKeyCapabilities(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_ClientCapabilities& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRKeyCapabilitiesMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_XDeviceKeys& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSzName();
    out << (uint8) in.getBMandatory();
    out << (uint32) in.getE32SymbolValue();
    {
        uint32 o118 = static_cast<uint32>(in.getIconList().size());
        out << o118;
        ::std::vector< ::midw_smartphoneint_fi_types::T_IconAttributes >::const_iterator o119;
        for (o119 = in.getIconList().begin(); o119 != in.getIconList().end(); ++o119) {
            serializeCca((*o119), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_XDeviceKeys& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o120;
    in >> o120;
    out.setSzName(o120);
    bool o121;
    in >> o121;
    out.setBMandatory(o121);
    uint32 o122;
    in >> o122;
    out.setE32SymbolValue((::midw_smartphoneint_fi_types::T_e32_KeyCode)o122);
    {
        uint32 o123;
        in >> o123;
        out.getIconListMutable().clear ();
        out.getIconListMutable().reserve (o123);
        for (uint32 o124 = 0; o124 < o123; o124++) {
            ::midw_smartphoneint_fi_types::T_IconAttributes o125;
            deserializeCca(in, o125, majorVersion);
            out.getIconListMutable().push_back (o125);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_KeyCapabilities& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32KnobKeySupport();
    out << in.getU32DeviceKeySupport();
    out << in.getU32MultimediaKeySupport();
    out << in.getU32MiscKeySupport();
    out << in.getU32PointerTouchSupport();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_KeyCapabilities& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o126;
    in >> o126;
    out.setU32KnobKeySupport(o126);
    uint32 o127;
    in >> o127;
    out.setU32DeviceKeySupport(o127);
    uint32 o128;
    in >> o128;
    out.setU32MultimediaKeySupport(o128);
    uint32 o129;
    in >> o129;
    out.setU32MiscKeySupport(o129);
    uint32 o130;
    in >> o130;
    out.setU32PointerTouchSupport(o130);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_AudioCapabilities& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16BTHFPSupport();
    out << in.getU16BTA2DPSupport();
    out << in.getU16RTPInSupport();
    out << in.getU16RTPOutSupport();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_AudioCapabilities& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o131;
    in >> o131;
    out.setU16BTHFPSupport(o131);
    uint16 o132;
    in >> o132;
    out.setU16BTA2DPSupport(o132);
    uint16 o133;
    in >> o133;
    out.setU16RTPInSupport(o133);
    uint16 o134;
    in >> o134;
    out.setU16RTPOutSupport(o134);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_DisplayCapabilities& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16FrameBufferConfiguration();
    out << in.getU16PixelFormat();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_DisplayCapabilities& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o135;
    in >> o135;
    out.setU16FrameBufferConfiguration(o135);
    uint16 o136;
    in >> o136;
    out.setU16PixelFormat(o136);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_ApplicationMediaMetaData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getAppName();
    out << in.getTitle();
    out << in.getArtist();
    out << in.getAlbum();
    out << in.getAlbumArtist();
    out << in.getGenre();
    out << in.getComposer();
    out << in.getTrackNumber();
    out << in.getAlbumTrackCount();
    out << in.getAlbumDiscNumber();
    out << in.getAlbumDiscCount();
    out << in.getChapterCount();
    out << in.getU32QueueIndex();
    out << in.getU32QueueCount();
    out << in.getImageMIMEType();
    out << in.getImageSize();
    out << in.getImageUrl();
    {
        uint32 o137 = static_cast<uint32>(in.getOImageData().size());
        out << o137;
        ::std::vector< uint8 >::const_iterator o138;
        for (o138 = in.getOImageData().begin(); o138 != in.getOImageData().end(); ++o138) {
            out << (*o138);
        }
    }
    out << (uint8) in.getPlayBackState();
    out << (uint8) in.getShuffleState();
    out << (uint8) in.getRepeatState();
    out << (uint8) in.getMediaType();
    out << (uint8) in.getITunesRadioAd();
    out << in.getITunesRadioStationName();
    out << in.getMediaRating();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_ApplicationMediaMetaData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o139;
    in >> o139;
    out.setAppName(o139);
    ::std::string o140;
    in >> o140;
    out.setTitle(o140);
    ::std::string o141;
    in >> o141;
    out.setArtist(o141);
    ::std::string o142;
    in >> o142;
    out.setAlbum(o142);
    ::std::string o143;
    in >> o143;
    out.setAlbumArtist(o143);
    ::std::string o144;
    in >> o144;
    out.setGenre(o144);
    ::std::string o145;
    in >> o145;
    out.setComposer(o145);
    uint32 o146;
    in >> o146;
    out.setTrackNumber(o146);
    uint32 o147;
    in >> o147;
    out.setAlbumTrackCount(o147);
    uint32 o148;
    in >> o148;
    out.setAlbumDiscNumber(o148);
    uint32 o149;
    in >> o149;
    out.setAlbumDiscCount(o149);
    uint32 o150;
    in >> o150;
    out.setChapterCount(o150);
    uint32 o151;
    in >> o151;
    out.setU32QueueIndex(o151);
    uint32 o152;
    in >> o152;
    out.setU32QueueCount(o152);
    ::std::string o153;
    in >> o153;
    out.setImageMIMEType(o153);
    uint32 o154;
    in >> o154;
    out.setImageSize(o154);
    ::std::string o155;
    in >> o155;
    out.setImageUrl(o155);
    {
        uint32 o156;
        in >> o156;
        out.getOImageDataMutable().clear ();
        out.getOImageDataMutable().reserve (o156);
        for (uint32 o157 = 0; o157 < o156; o157++) {
            uint8 o158;
            in >> o158;
            out.getOImageDataMutable().push_back(o158);
        }
    }
    uint8 o159;
    in >> o159;
    out.setPlayBackState((::midw_smartphoneint_fi_types::T_e8_PlayBackState)o159);
    uint8 o160;
    in >> o160;
    out.setShuffleState((::midw_smartphoneint_fi_types::T_e8_PlayBackShuffleState)o160);
    uint8 o161;
    in >> o161;
    out.setRepeatState((::midw_smartphoneint_fi_types::T_e8_PlayBackRepeatState)o161);
    uint8 o162;
    in >> o162;
    out.setMediaType((::midw_smartphoneint_fi_types::T_e8_PlayBackMediaType)o162);
    bool o163;
    in >> o163;
    out.setITunesRadioAd(o163);
    ::std::string o164;
    in >> o164;
    out.setITunesRadioStationName(o164);
    uint8 o165;
    in >> o165;
    out.setMediaRating(o165);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallMetadata& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getPhoneNumber();
    out << in.getDisplayName();
    out << (uint8) in.getCallState();
    out << (uint8) in.getCallDirection();
    out << in.getCallDuration();
    out << in.getCallerLabel();
    out << (uint8) in.getConferencedCall();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallMetadata& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o166;
    in >> o166;
    out.setPhoneNumber(o166);
    ::std::string o167;
    in >> o167;
    out.setDisplayName(o167);
    uint8 o168;
    in >> o168;
    out.setCallState((::midw_smartphoneint_fi_types::T_e8_PhoneCallState)o168);
    uint8 o169;
    in >> o169;
    out.setCallDirection((::midw_smartphoneint_fi_types::T_e8_PhoneCallDirection)o169);
    uint32 o170;
    in >> o170;
    out.setCallDuration(o170);
    ::std::string o171;
    in >> o171;
    out.setCallerLabel(o171);
    bool o172;
    in >> o172;
    out.setConferencedCall(o172);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallExtendedMetadata& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getPhoneNumber();
    out << in.getDisplayName();
    out << in.getSCallUUID();
    out << (uint8) in.getCallStateDisconnectReason();
    out << (uint8) in.getCallState();
    out << (uint8) in.getCallDirection();
    out << in.getCallerLabel();
    out << (uint8) in.getConferencedCall();
    out << in.getU64StartTimeStamp();
    serializeCca(in.getCallProgress(), out, majorVersion);
    serializeCca(in.getCallProgressRefFromDevice(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallExtendedMetadata& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o173;
    in >> o173;
    out.setPhoneNumber(o173);
    ::std::string o174;
    in >> o174;
    out.setDisplayName(o174);
    ::std::string o175;
    in >> o175;
    out.setSCallUUID(o175);
    uint8 o176;
    in >> o176;
    out.setCallStateDisconnectReason((::midw_smartphoneint_fi_types::T_e8_CallStateUpdateDisconnectReason)o176);
    uint8 o177;
    in >> o177;
    out.setCallState((::midw_smartphoneint_fi_types::T_e8_PhoneCallState)o177);
    uint8 o178;
    in >> o178;
    out.setCallDirection((::midw_smartphoneint_fi_types::T_e8_PhoneCallDirection)o178);
    ::std::string o179;
    in >> o179;
    out.setCallerLabel(o179);
    bool o180;
    in >> o180;
    out.setConferencedCall(o180);
    uint64 o181;
    in >> o181;
    out.setU64StartTimeStamp(o181);
    deserializeCca(in, out.getCallProgressMutable(), majorVersion);
    deserializeCca(in, out.getCallProgressRefFromDeviceMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_Time& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Hour();
    out << in.getU8Minute();
    out << in.getU8Second();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_Time& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o182;
    in >> o182;
    out.setU8Hour(o182);
    uint8 o183;
    in >> o183;
    out.setU8Minute(o183);
    uint8 o184;
    in >> o184;
    out.setU8Second(o184);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_AccessoryDisplayContext& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getDisplayContext();
    out << (uint8) in.getDisplayFlag();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_AccessoryDisplayContext& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o185;
    in >> o185;
    out.setDisplayContext((::midw_smartphoneint_fi_types::T_e8_DisplayContext)o185);
    bool o186;
    in >> o186;
    out.setDisplayFlag(o186);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_DisplayConstraint& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getTransferType();
    out << (uint8) in.getTransferPriority();
    out << (uint8) in.getTakeConstraint();
    out << (uint8) in.getBorrowConstraint();
    out << in.getBorrowId();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_DisplayConstraint& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o187;
    in >> o187;
    out.setTransferType((::midw_smartphoneint_fi_types::T_e8_ResourceTransferType)o187);
    uint8 o188;
    in >> o188;
    out.setTransferPriority((::midw_smartphoneint_fi_types::T_e8_ResourceTransferPriority)o188);
    uint8 o189;
    in >> o189;
    out.setTakeConstraint((::midw_smartphoneint_fi_types::T_e8_ResourceTransferConstraint)o189);
    uint8 o190;
    in >> o190;
    out.setBorrowConstraint((::midw_smartphoneint_fi_types::T_e8_ResourceTransferConstraint)o190);
    ::std::string o191;
    in >> o191;
    out.setBorrowId(o191);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_DisplayLayerAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEnDeviceCategory();
    out << in.getU16TouchLayerID();
    out << in.getU16TouchSurfaceID();
    out << in.getU16VideoLayerID();
    out << in.getU16VideoSurfaceID();
    out << in.getU16LayerWidth();
    out << in.getU16LayerHeight();
    out << in.getU16LayerWidthInMM();
    out << in.getU16LayerHeightInMM();
    out << in.getSzPixelAspectRatio();
    out << in.getU16DPI();
    out << (uint8) in.getEnDisplayTouchType();
    out << in.getU16PriorityIndex();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_DisplayLayerAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o192;
    in >> o192;
    out.setEnDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o192);
    uint16 o193;
    in >> o193;
    out.setU16TouchLayerID(o193);
    uint16 o194;
    in >> o194;
    out.setU16TouchSurfaceID(o194);
    uint16 o195;
    in >> o195;
    out.setU16VideoLayerID(o195);
    uint16 o196;
    in >> o196;
    out.setU16VideoSurfaceID(o196);
    uint16 o197;
    in >> o197;
    out.setU16LayerWidth(o197);
    uint16 o198;
    in >> o198;
    out.setU16LayerHeight(o198);
    uint16 o199;
    in >> o199;
    out.setU16LayerWidthInMM(o199);
    uint16 o200;
    in >> o200;
    out.setU16LayerHeightInMM(o200);
    ::std::string o201;
    in >> o201;
    out.setSzPixelAspectRatio(o201);
    uint16 o202;
    in >> o202;
    out.setU16DPI(o202);
    uint8 o203;
    in >> o203;
    out.setEnDisplayTouchType((::midw_smartphoneint_fi_types::T_e8_DisplayTouchType)o203);
    uint16 o204;
    in >> o204;
    out.setU16PriorityIndex(o204);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_DisplayAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16ScreenHeight();
    out << in.getU16ScreenWidth();
    out << in.getU16ScreenHeightMm();
    out << in.getU16ScreenWidthMm();
    out << (uint8) in.getEnDisplayType();
    {
        uint32 o205 = static_cast<uint32>(in.getDisplayLayerAttributes().size());
        out << o205;
        ::std::vector< ::midw_smartphoneint_fi_types::T_DisplayLayerAttributes >::const_iterator o206;
        for (o206 = in.getDisplayLayerAttributes().begin(); o206 != in.getDisplayLayerAttributes().end(); ++o206) {
            serializeCca((*o206), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_DisplayAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o207;
    in >> o207;
    out.setU16ScreenHeight(o207);
    uint16 o208;
    in >> o208;
    out.setU16ScreenWidth(o208);
    uint16 o209;
    in >> o209;
    out.setU16ScreenHeightMm(o209);
    uint16 o210;
    in >> o210;
    out.setU16ScreenWidthMm(o210);
    uint8 o211;
    in >> o211;
    out.setEnDisplayType((::midw_smartphoneint_fi_types::T_e8_DisplayType)o211);
    {
        uint32 o212;
        in >> o212;
        out.getDisplayLayerAttributesMutable().clear ();
        out.getDisplayLayerAttributesMutable().reserve (o212);
        for (uint32 o213 = 0; o213 < o212; o213++) {
            ::midw_smartphoneint_fi_types::T_DisplayLayerAttributes o214;
            deserializeCca(in, o214, majorVersion);
            out.getDisplayLayerAttributesMutable().push_back (o214);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_AccessoryAudioContext& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getAudioContext();
    out << (uint8) in.getAudioFlag();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_AccessoryAudioContext& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o215;
    in >> o215;
    out.setAudioContext((::midw_smartphoneint_fi_types::T_e8_AudioContext)o215);
    bool o216;
    in >> o216;
    out.setAudioFlag(o216);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_DeviceAuthInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceType();
    out << (uint8) in.getUserAuthorizationStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_DeviceAuthInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o217;
    in >> o217;
    out.setDeviceHandle(o217);
    uint8 o218;
    in >> o218;
    out.setDeviceType((::midw_smartphoneint_fi_types::T_e8_DeviceType)o218);
    uint8 o219;
    in >> o219;
    out.setUserAuthorizationStatus((::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus)o219);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_FeatureRestriction& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getFeatureLockout();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_FeatureRestriction& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o220;
    in >> o220;
    out.setFeatureLockout(o220);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_WiFiAPCredentials& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSSID();
    out << in.getPassPhrase();
    out << in.getChannelNo();
    out << (uint8) in.getSecurityType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_WiFiAPCredentials& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o221;
    in >> o221;
    out.setSSID(o221);
    ::std::string o222;
    in >> o222;
    out.setPassPhrase(o222);
    uint16 o223;
    in >> o223;
    out.setChannelNo(o223);
    uint8 o224;
    in >> o224;
    out.setSecurityType((::midw_smartphoneint_fi_types::T_e8_WiFiSecurityType)o224);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_OEMICONDetails& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getOEMIconName();
    out << in.getOEMIconpath();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_OEMICONDetails& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o225;
    in >> o225;
    out.setOEMIconName(o225);
    ::std::string o226;
    in >> o226;
    out.setOEMIconpath(o226);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBRouteGuidanceDisplayComponentIDsAvailable();
    {
        uint32 o227 = static_cast<uint32>(in.getE8RouteGuidanceDisplayComponentIDs().size());
        out << o227;
        ::std::vector< ::midw_smartphoneint_fi_types::T_e8_ComponentID >::const_iterator o228;
        for (o228 = in.getE8RouteGuidanceDisplayComponentIDs().begin(); o228 != in.getE8RouteGuidanceDisplayComponentIDs().end(); ++o228) {
            out << (uint8) (*o228);
        }
    }
    out << (uint8) in.getBRouteGuidanceStateAvailable();
    out << (uint8) in.getE8RouteGuidanceState();
    out << (uint8) in.getBManeuverStateAvailable();
    out << (uint8) in.getE8ManeuverState();
    out << (uint8) in.getBCurrentRoadNameAvailable();
    out << in.getSzCurrentRoadName();
    out << (uint8) in.getBDestinationNameAvailable();
    out << in.getSzDestinationName();
    out << (uint8) in.getBEstimatedTimeOfArrivalAvailable();
    out << in.getU64EstimatedTimeOfArrival();
    out << (uint8) in.getBTimeRemainingToDestinationAvailable();
    out << in.getU64TimeRemainingToDestination();
    out << (uint8) in.getBDistanceRemainingAvailable();
    out << in.getU32DistanceRemaining();
    out << (uint8) in.getBDistanceRemainingDisplayStrAvailable();
    out << in.getSzDistanceRemainingDisplayStr();
    out << (uint8) in.getBDistanceRemainingDisplayUnitsAvailable();
    out << (uint8) in.getE8DistanceRemainingDisplayUnits();
    out << (uint8) in.getBDistanceToNextManeuverAvailable();
    out << in.getU32DistanceToNextManeuver();
    out << (uint8) in.getBDistanceToNextManeuverDisplayStrAvailable();
    out << in.getSzDistanceToNextManeuverDisplayStr();
    out << (uint8) in.getBDistanceToNextManeuverDisplayUnitsAvailable();
    out << (uint8) in.getE8DistanceToNextManeuverDisplayUnits();
    out << (uint8) in.getBRouteGuidanceManeuverCurrentListAvailable();
    {
        uint32 o229 = static_cast<uint32>(in.getU16RouteGuidanceManeuverCurrentList().size());
        out << o229;
        ::std::vector< uint16 >::const_iterator o230;
        for (o230 = in.getU16RouteGuidanceManeuverCurrentList().begin(); o230 != in.getU16RouteGuidanceManeuverCurrentList().end(); ++o230) {
            out << (*o230);
        }
    }
    out << (uint8) in.getBRouteGuidanceManeuverCountAvailable();
    out << in.getU16RouteGuidanceManeuverCount();
    out << (uint8) in.getBRouteGuidanceVisibleInAppAvailable();
    out << (uint8) in.getBIsRouteGuidanceVisibleInApp();
    out << (uint8) in.getBSourceNameAvailable();
    out << in.getSourceName();
    out << (uint8) in.getBSourceSupportsRouteGuidanceAvailable();
    out << (uint8) in.getSourceSupportsRouteGuidance();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o231;
    in >> o231;
    out.setBRouteGuidanceDisplayComponentIDsAvailable(o231);
    {
        uint32 o232;
        in >> o232;
        out.getE8RouteGuidanceDisplayComponentIDsMutable().clear ();
        out.getE8RouteGuidanceDisplayComponentIDsMutable().reserve (o232);
        for (uint32 o233 = 0; o233 < o232; o233++) {
            uint8 o234;
            in >> o234;
            out.getE8RouteGuidanceDisplayComponentIDsMutable().push_back((::midw_smartphoneint_fi_types::T_e8_ComponentID) o234);
        }
    }
    bool o235;
    in >> o235;
    out.setBRouteGuidanceStateAvailable(o235);
    uint8 o236;
    in >> o236;
    out.setE8RouteGuidanceState((::midw_smartphoneint_fi_types::T_e8_DiPoRouteGuidanceState)o236);
    bool o237;
    in >> o237;
    out.setBManeuverStateAvailable(o237);
    uint8 o238;
    in >> o238;
    out.setE8ManeuverState((::midw_smartphoneint_fi_types::T_e8_DiPoManeuverState)o238);
    bool o239;
    in >> o239;
    out.setBCurrentRoadNameAvailable(o239);
    ::std::string o240;
    in >> o240;
    out.setSzCurrentRoadName(o240);
    bool o241;
    in >> o241;
    out.setBDestinationNameAvailable(o241);
    ::std::string o242;
    in >> o242;
    out.setSzDestinationName(o242);
    bool o243;
    in >> o243;
    out.setBEstimatedTimeOfArrivalAvailable(o243);
    uint64 o244;
    in >> o244;
    out.setU64EstimatedTimeOfArrival(o244);
    bool o245;
    in >> o245;
    out.setBTimeRemainingToDestinationAvailable(o245);
    uint64 o246;
    in >> o246;
    out.setU64TimeRemainingToDestination(o246);
    bool o247;
    in >> o247;
    out.setBDistanceRemainingAvailable(o247);
    uint32 o248;
    in >> o248;
    out.setU32DistanceRemaining(o248);
    bool o249;
    in >> o249;
    out.setBDistanceRemainingDisplayStrAvailable(o249);
    ::std::string o250;
    in >> o250;
    out.setSzDistanceRemainingDisplayStr(o250);
    bool o251;
    in >> o251;
    out.setBDistanceRemainingDisplayUnitsAvailable(o251);
    uint8 o252;
    in >> o252;
    out.setE8DistanceRemainingDisplayUnits((::midw_smartphoneint_fi_types::T_e8_DistanceUnits)o252);
    bool o253;
    in >> o253;
    out.setBDistanceToNextManeuverAvailable(o253);
    uint32 o254;
    in >> o254;
    out.setU32DistanceToNextManeuver(o254);
    bool o255;
    in >> o255;
    out.setBDistanceToNextManeuverDisplayStrAvailable(o255);
    ::std::string o256;
    in >> o256;
    out.setSzDistanceToNextManeuverDisplayStr(o256);
    bool o257;
    in >> o257;
    out.setBDistanceToNextManeuverDisplayUnitsAvailable(o257);
    uint8 o258;
    in >> o258;
    out.setE8DistanceToNextManeuverDisplayUnits((::midw_smartphoneint_fi_types::T_e8_DistanceUnits)o258);
    bool o259;
    in >> o259;
    out.setBRouteGuidanceManeuverCurrentListAvailable(o259);
    {
        uint32 o260;
        in >> o260;
        out.getU16RouteGuidanceManeuverCurrentListMutable().clear ();
        out.getU16RouteGuidanceManeuverCurrentListMutable().reserve (o260);
        for (uint32 o261 = 0; o261 < o260; o261++) {
            uint16 o262;
            in >> o262;
            out.getU16RouteGuidanceManeuverCurrentListMutable().push_back(o262);
        }
    }
    bool o263;
    in >> o263;
    out.setBRouteGuidanceManeuverCountAvailable(o263);
    uint16 o264;
    in >> o264;
    out.setU16RouteGuidanceManeuverCount(o264);
    bool o265;
    in >> o265;
    out.setBRouteGuidanceVisibleInAppAvailable(o265);
    bool o266;
    in >> o266;
    out.setBIsRouteGuidanceVisibleInApp(o266);
    bool o267;
    in >> o267;
    out.setBSourceNameAvailable(o267);
    ::std::string o268;
    in >> o268;
    out.setSourceName(o268);
    bool o269;
    in >> o269;
    out.setBSourceSupportsRouteGuidanceAvailable(o269);
    bool o270;
    in >> o270;
    out.setSourceSupportsRouteGuidance(o270);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceManeuverUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBRouteGuidanceDisplayComponentIDsAvailable();
    {
        uint32 o271 = static_cast<uint32>(in.getRouteGuidanceDisplayComponentIDs().size());
        out << o271;
        ::std::vector< ::midw_smartphoneint_fi_types::T_e8_ComponentID >::const_iterator o272;
        for (o272 = in.getRouteGuidanceDisplayComponentIDs().begin(); o272 != in.getRouteGuidanceDisplayComponentIDs().end(); ++o272) {
            out << (uint8) (*o272);
        }
    }
    out << (uint8) in.getBIndexAvailable();
    out << in.getU16Index();
    out << (uint8) in.getBManeuverDescriptionAvailable();
    out << in.getSzManeuverDescription();
    out << (uint8) in.getBManeuverTypeAvailable();
    out << (uint8) in.getE8ManeuverType();
    out << (uint8) in.getBAfterManeuverRoadNameAvailable();
    out << in.getSzAfterManeuverRoadName();
    out << (uint8) in.getBDistanceBetweenManeuverAvailable();
    out << in.getU32DistanceBetweenManeuver();
    out << (uint8) in.getBDistanceBetweenManeuverDisplayStrAvailable();
    out << in.getSzDistanceBetweenManeuverDisplayStr();
    out << (uint8) in.getBDistanceBetweenManeuverDisplayUnitsAvailable();
    out << (uint8) in.getE8DistanceBetweenManeuverDisplayUnits();
    out << (uint8) in.getBDrivingSideAvailable();
    out << (uint8) in.getE8DrivingSide();
    out << (uint8) in.getBJunctionTypeAvailable();
    out << (uint8) in.getE8JunctionType();
    out << (uint8) in.getBJunctionElementAngleAvailable();
    {
        uint32 o273 = static_cast<uint32>(in.getS16JunctionElementAngleList().size());
        out << o273;
        ::std::vector< int16 >::const_iterator o274;
        for (o274 = in.getS16JunctionElementAngleList().begin(); o274 != in.getS16JunctionElementAngleList().end(); ++o274) {
            out << (*o274);
        }
    }
    out << (uint8) in.getBJunctionElementExitAngleAvailable();
    out << in.getS16JunctionElementExitAngle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceManeuverUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o275;
    in >> o275;
    out.setBRouteGuidanceDisplayComponentIDsAvailable(o275);
    {
        uint32 o276;
        in >> o276;
        out.getRouteGuidanceDisplayComponentIDsMutable().clear ();
        out.getRouteGuidanceDisplayComponentIDsMutable().reserve (o276);
        for (uint32 o277 = 0; o277 < o276; o277++) {
            uint8 o278;
            in >> o278;
            out.getRouteGuidanceDisplayComponentIDsMutable().push_back((::midw_smartphoneint_fi_types::T_e8_ComponentID) o278);
        }
    }
    bool o279;
    in >> o279;
    out.setBIndexAvailable(o279);
    uint16 o280;
    in >> o280;
    out.setU16Index(o280);
    bool o281;
    in >> o281;
    out.setBManeuverDescriptionAvailable(o281);
    ::std::string o282;
    in >> o282;
    out.setSzManeuverDescription(o282);
    bool o283;
    in >> o283;
    out.setBManeuverTypeAvailable(o283);
    uint8 o284;
    in >> o284;
    out.setE8ManeuverType((::midw_smartphoneint_fi_types::T_e8_DiPoManeuverType)o284);
    bool o285;
    in >> o285;
    out.setBAfterManeuverRoadNameAvailable(o285);
    ::std::string o286;
    in >> o286;
    out.setSzAfterManeuverRoadName(o286);
    bool o287;
    in >> o287;
    out.setBDistanceBetweenManeuverAvailable(o287);
    uint32 o288;
    in >> o288;
    out.setU32DistanceBetweenManeuver(o288);
    bool o289;
    in >> o289;
    out.setBDistanceBetweenManeuverDisplayStrAvailable(o289);
    ::std::string o290;
    in >> o290;
    out.setSzDistanceBetweenManeuverDisplayStr(o290);
    bool o291;
    in >> o291;
    out.setBDistanceBetweenManeuverDisplayUnitsAvailable(o291);
    uint8 o292;
    in >> o292;
    out.setE8DistanceBetweenManeuverDisplayUnits((::midw_smartphoneint_fi_types::T_e8_DistanceUnits)o292);
    bool o293;
    in >> o293;
    out.setBDrivingSideAvailable(o293);
    uint8 o294;
    in >> o294;
    out.setE8DrivingSide((::midw_smartphoneint_fi_types::T_e8_DiPoDrivingSide)o294);
    bool o295;
    in >> o295;
    out.setBJunctionTypeAvailable(o295);
    uint8 o296;
    in >> o296;
    out.setE8JunctionType((::midw_smartphoneint_fi_types::T_e8_DiPoJunctionType)o296);
    bool o297;
    in >> o297;
    out.setBJunctionElementAngleAvailable(o297);
    {
        uint32 o298;
        in >> o298;
        out.getS16JunctionElementAngleListMutable().clear ();
        out.getS16JunctionElementAngleListMutable().reserve (o298);
        for (uint32 o299 = 0; o299 < o298; o299++) {
            int16 o300;
            in >> o300;
            out.getS16JunctionElementAngleListMutable().push_back(o300);
        }
    }
    bool o301;
    in >> o301;
    out.setBJunctionElementExitAngleAvailable(o301);
    int16 o302;
    in >> o302;
    out.setS16JunctionElementExitAngle(o302);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_DiPORouteGuidanceUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8RouteGuidanceState();
    out << (uint8) in.getE8ManeuverState();
    out << in.getSzCurrentRoadName();
    out << in.getSzDestinationName();
    out << in.getU64EstimatedTimeOfArrival();
    out << in.getU64TimeRemainingToDestination();
    out << in.getU32DistanceRemaining();
    out << in.getSzDistanceRemainingDisplayStr();
    out << (uint8) in.getE8DistanceRemainingDisplayUnits();
    out << in.getU32DistanceToNextManeuver();
    out << in.getSzDistanceToNextManeuverDisplayStr();
    out << (uint8) in.getE8DistanceToNextManeuverDisplayUnits();
    {
        uint32 o303 = static_cast<uint32>(in.getU16RouteGuidanceManeuverCurrentList().size());
        out << o303;
        ::std::vector< uint16 >::const_iterator o304;
        for (o304 = in.getU16RouteGuidanceManeuverCurrentList().begin(); o304 != in.getU16RouteGuidanceManeuverCurrentList().end(); ++o304) {
            out << (*o304);
        }
    }
    out << in.getU16RouteGuidanceManeuverCount();
    out << (uint8) in.getBIsRouteGuidanceVisibleInApp();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_DiPORouteGuidanceUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o305;
    in >> o305;
    out.setE8RouteGuidanceState((::midw_smartphoneint_fi_types::T_e8_DiPoRouteGuidanceState)o305);
    uint8 o306;
    in >> o306;
    out.setE8ManeuverState((::midw_smartphoneint_fi_types::T_e8_DiPoManeuverState)o306);
    ::std::string o307;
    in >> o307;
    out.setSzCurrentRoadName(o307);
    ::std::string o308;
    in >> o308;
    out.setSzDestinationName(o308);
    uint64 o309;
    in >> o309;
    out.setU64EstimatedTimeOfArrival(o309);
    uint64 o310;
    in >> o310;
    out.setU64TimeRemainingToDestination(o310);
    uint32 o311;
    in >> o311;
    out.setU32DistanceRemaining(o311);
    ::std::string o312;
    in >> o312;
    out.setSzDistanceRemainingDisplayStr(o312);
    uint8 o313;
    in >> o313;
    out.setE8DistanceRemainingDisplayUnits((::midw_smartphoneint_fi_types::T_e8_DistanceUnits)o313);
    uint32 o314;
    in >> o314;
    out.setU32DistanceToNextManeuver(o314);
    ::std::string o315;
    in >> o315;
    out.setSzDistanceToNextManeuverDisplayStr(o315);
    uint8 o316;
    in >> o316;
    out.setE8DistanceToNextManeuverDisplayUnits((::midw_smartphoneint_fi_types::T_e8_DistanceUnits)o316);
    {
        uint32 o317;
        in >> o317;
        out.getU16RouteGuidanceManeuverCurrentListMutable().clear ();
        out.getU16RouteGuidanceManeuverCurrentListMutable().reserve (o317);
        for (uint32 o318 = 0; o318 < o317; o318++) {
            uint16 o319;
            in >> o319;
            out.getU16RouteGuidanceManeuverCurrentListMutable().push_back(o319);
        }
    }
    uint16 o320;
    in >> o320;
    out.setU16RouteGuidanceManeuverCount(o320);
    bool o321;
    in >> o321;
    out.setBIsRouteGuidanceVisibleInApp(o321);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_DiPORouteGuidanceManeuverUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16Index();
    out << in.getSzManeuverDescription();
    out << (uint8) in.getE8ManeuverType();
    out << in.getSzAfterManeuverRoadName();
    out << in.getU32DistanceBetweenManeuver();
    out << in.getSzDistanceBetweenManeuverDisplayStr();
    out << (uint8) in.getE8DistanceBetweenManeuverDisplayUnits();
    out << (uint8) in.getE8DrivingSide();
    out << (uint8) in.getE8JunctionType();
    out << in.getS16JunctionElementAngle();
    out << in.getS16JunctionElementExitAngle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_DiPORouteGuidanceManeuverUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o322;
    in >> o322;
    out.setU16Index(o322);
    ::std::string o323;
    in >> o323;
    out.setSzManeuverDescription(o323);
    uint8 o324;
    in >> o324;
    out.setE8ManeuverType((::midw_smartphoneint_fi_types::T_e8_DiPoManeuverType)o324);
    ::std::string o325;
    in >> o325;
    out.setSzAfterManeuverRoadName(o325);
    uint32 o326;
    in >> o326;
    out.setU32DistanceBetweenManeuver(o326);
    ::std::string o327;
    in >> o327;
    out.setSzDistanceBetweenManeuverDisplayStr(o327);
    uint8 o328;
    in >> o328;
    out.setE8DistanceBetweenManeuverDisplayUnits((::midw_smartphoneint_fi_types::T_e8_DistanceUnits)o328);
    uint8 o329;
    in >> o329;
    out.setE8DrivingSide((::midw_smartphoneint_fi_types::T_e8_DiPoDrivingSide)o329);
    uint8 o330;
    in >> o330;
    out.setE8JunctionType((::midw_smartphoneint_fi_types::T_e8_DiPoJunctionType)o330);
    int16 o331;
    in >> o331;
    out.setS16JunctionElementAngle(o331);
    int16 o332;
    in >> o332;
    out.setS16JunctionElementExitAngle(o332);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_CarPlayTBTUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getDiPoRouteGuidanceUpdate(), out, majorVersion);
    out << (uint8) in.getIsDiPoRouteGuidanceUpdateValid();
    serializeCca(in.getDiPoRouteGuidanceManeuverUpdate(), out, majorVersion);
    out << (uint8) in.getIsDiPoRouteGuidanceManeuverUpdateValid();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_CarPlayTBTUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getDiPoRouteGuidanceUpdateMutable(), majorVersion);
    bool o333;
    in >> o333;
    out.setIsDiPoRouteGuidanceUpdateValid(o333);
    deserializeCca(in, out.getDiPoRouteGuidanceManeuverUpdateMutable(), majorVersion);
    bool o334;
    in >> o334;
    out.setIsDiPoRouteGuidanceManeuverUpdateValid(o334);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_AAutoNavigationNextTurnData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getRoadName();
    out << (uint8) in.getTurnSide();
    out << (uint8) in.getNextTurnEvent();
    {
        uint32 o335 = static_cast<uint32>(in.getImage().size());
        out << o335;
        ::std::vector< uint8 >::const_iterator o336;
        for (o336 = in.getImage().begin(); o336 != in.getImage().end(); ++o336) {
            out << (*o336);
        }
    }
    out << in.getTurnAngle();
    out << in.getTurnNumber();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_AAutoNavigationNextTurnData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o337;
    in >> o337;
    out.setRoadName(o337);
    uint8 o338;
    in >> o338;
    out.setTurnSide((::midw_smartphoneint_fi_types::T_e8_AAutoTurnSide)o338);
    uint8 o339;
    in >> o339;
    out.setNextTurnEvent((::midw_smartphoneint_fi_types::T_e8_AAutoNextTurnEvent)o339);
    {
        uint32 o340;
        in >> o340;
        out.getImageMutable().clear ();
        out.getImageMutable().reserve (o340);
        for (uint32 o341 = 0; o341 < o340; o341++) {
            uint8 o342;
            in >> o342;
            out.getImageMutable().push_back(o342);
        }
    }
    int32 o343;
    in >> o343;
    out.setTurnAngle(o343);
    int32 o344;
    in >> o344;
    out.setTurnNumber(o344);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_AAutoNavigationNextTurnDistanceData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDistanceInMeters();
    out << in.getTimeInSec();
    out << in.getDistanceToManeuver();
    out << (uint8) in.getManeuverDistanceUnits();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_AAutoNavigationNextTurnDistanceData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    int32 o345;
    in >> o345;
    out.setDistanceInMeters(o345);
    int32 o346;
    in >> o346;
    out.setTimeInSec(o346);
    int32 o347;
    in >> o347;
    out.setDistanceToManeuver(o347);
    uint8 o348;
    in >> o348;
    out.setManeuverDistanceUnits((::midw_smartphoneint_fi_types::T_e8_DistanceUnits)o348);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_AAutoTBTUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getAAutoNavigationNextTurnData(), out, majorVersion);
    out << (uint8) in.getIsAAutoNavigationNextTurnDataValid();
    serializeCca(in.getAAutoNavigationNextTurnDistanceData(), out, majorVersion);
    out << (uint8) in.getIsAAutoNavigationNextTurnDistanceDataValid();
    out << (uint8) in.getAAutoNavigationStatus();
    out << (uint8) in.getIsAAutoNavigationStatusValid();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_AAutoTBTUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getAAutoNavigationNextTurnDataMutable(), majorVersion);
    bool o349;
    in >> o349;
    out.setIsAAutoNavigationNextTurnDataValid(o349);
    deserializeCca(in, out.getAAutoNavigationNextTurnDistanceDataMutable(), majorVersion);
    bool o350;
    in >> o350;
    out.setIsAAutoNavigationNextTurnDistanceDataValid(o350);
    uint8 o351;
    in >> o351;
    out.setAAutoNavigationStatus((::midw_smartphoneint_fi_types::T_e8_AAutoNavigationAppState)o351);
    bool o352;
    in >> o352;
    out.setIsAAutoNavigationStatusValid(o352);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_CarlifeNaviNextTurnInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBDCLNavigationAppState();
    out << (uint8) in.getBDCLNaviTurnType();
    out << in.getRoadName();
    out << in.getTotalDistance();
    out << in.getRemainDistance();
    {
        uint32 o353 = static_cast<uint32>(in.getTurnIconData().size());
        out << o353;
        ::std::vector< uint8 >::const_iterator o354;
        for (o354 = in.getTurnIconData().begin(); o354 != in.getTurnIconData().end(); ++o354) {
            out << (*o354);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_CarlifeNaviNextTurnInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o355;
    in >> o355;
    out.setBDCLNavigationAppState((::midw_smartphoneint_fi_types::T_e8_BDCLNavigationAppState)o355);
    uint8 o356;
    in >> o356;
    out.setBDCLNaviTurnType((::midw_smartphoneint_fi_types::T_e8_BDCLNextTurnType)o356);
    ::std::string o357;
    in >> o357;
    out.setRoadName(o357);
    uint32 o358;
    in >> o358;
    out.setTotalDistance(o358);
    uint32 o359;
    in >> o359;
    out.setRemainDistance(o359);
    {
        uint32 o360;
        in >> o360;
        out.getTurnIconDataMutable().clear ();
        out.getTurnIconDataMutable().reserve (o360);
        for (uint32 o361 = 0; o361 < o360; o361++) {
            uint8 o362;
            in >> o362;
            out.getTurnIconDataMutable().push_back(o362);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_CarlifeNaviAssistantGuideInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBDCLAssistantGuideAppState();
    out << (uint8) in.getAssistantType();
    out << (uint8) in.getTrafficSignType();
    out << in.getTotalDistance();
    out << in.getRemainDistance();
    out << in.getCameraSpeed();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_CarlifeNaviAssistantGuideInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o363;
    in >> o363;
    out.setBDCLAssistantGuideAppState((::midw_smartphoneint_fi_types::T_e8_BDCLNavigationAppState)o363);
    uint8 o364;
    in >> o364;
    out.setAssistantType((::midw_smartphoneint_fi_types::T_e8_BDCLAssistantType)o364);
    uint8 o365;
    in >> o365;
    out.setTrafficSignType((::midw_smartphoneint_fi_types::T_e8_BDCLTrafficSignType)o365);
    uint32 o366;
    in >> o366;
    out.setTotalDistance(o366);
    uint32 o367;
    in >> o367;
    out.setRemainDistance(o367);
    uint32 o368;
    in >> o368;
    out.setCameraSpeed(o368);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_BDCLTBTUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getCarlifeNaviNextTurnInfo(), out, majorVersion);
    out << (uint8) in.getIsCarlifeNaviNextTurnInfoValid();
    serializeCca(in.getCarlifeNaviAssistantGuideInfo(), out, majorVersion);
    out << (uint8) in.getIsCarlifeNaviAssistantGuideInfoValid();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_BDCLTBTUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getCarlifeNaviNextTurnInfoMutable(), majorVersion);
    bool o369;
    in >> o369;
    out.setIsCarlifeNaviNextTurnInfoValid(o369);
    deserializeCca(in, out.getCarlifeNaviAssistantGuideInfoMutable(), majorVersion);
    bool o370;
    in >> o370;
    out.setIsCarlifeNaviAssistantGuideInfoValid(o370);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_ProjectionVideoAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16UIResolutionHeight();
    out << in.getU16UIResolutionWidth();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_ProjectionVideoAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o371;
    in >> o371;
    out.setU16UIResolutionHeight(o371);
    uint16 o372;
    in >> o372;
    out.setU16UIResolutionWidth(o372);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_MLTBTUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getMLNavigationInfoUpdate(), out, majorVersion);
    out << (uint8) in.getIsMLNavigationInfoUpdateValid();
    serializeCca(in.getMLNavigationNextManeuverUpdate(), out, majorVersion);
    out << (uint8) in.getIsMLNavigationNextManeuverUpdateValid();
    serializeCca(in.getMLSpeedLimitUpdate(), out, majorVersion);
    out << (uint8) in.getIsMLSpeedLimitUpdateValid();
    serializeCca(in.getMLNavigationNextDistanceUpdate(), out, majorVersion);
    out << (uint8) in.getIsMLNavigationNextDistanceUpdateValid();
    serializeCca(in.getMLNavigationLaneGuidanceUpdate(), out, majorVersion);
    out << (uint8) in.getIsMLNavigationLaneGuidanceUpdateValid();
    serializeCca(in.getMLNavigationTripInfoUpdate(), out, majorVersion);
    out << (uint8) in.getIsMLNavigationTripInfoUpdateValid();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_MLTBTUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getMLNavigationInfoUpdateMutable(), majorVersion);
    bool o373;
    in >> o373;
    out.setIsMLNavigationInfoUpdateValid(o373);
    deserializeCca(in, out.getMLNavigationNextManeuverUpdateMutable(), majorVersion);
    bool o374;
    in >> o374;
    out.setIsMLNavigationNextManeuverUpdateValid(o374);
    deserializeCca(in, out.getMLSpeedLimitUpdateMutable(), majorVersion);
    bool o375;
    in >> o375;
    out.setIsMLSpeedLimitUpdateValid(o375);
    deserializeCca(in, out.getMLNavigationNextDistanceUpdateMutable(), majorVersion);
    bool o376;
    in >> o376;
    out.setIsMLNavigationNextDistanceUpdateValid(o376);
    deserializeCca(in, out.getMLNavigationLaneGuidanceUpdateMutable(), majorVersion);
    bool o377;
    in >> o377;
    out.setIsMLNavigationLaneGuidanceUpdateValid(o377);
    deserializeCca(in, out.getMLNavigationTripInfoUpdateMutable(), majorVersion);
    bool o378;
    in >> o378;
    out.setIsMLNavigationTripInfoUpdateValid(o378);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_MLNavigationInfoUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getNavAppName();
    out << (uint8) in.getGuidanceState();
    out << (uint32) in.getGuidanceActive();
    out << (uint8) in.getMetricSystem();
    out << (uint8) in.getRightDriving();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_MLNavigationInfoUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o379;
    in >> o379;
    out.setNavAppName(o379);
    uint8 o380;
    in >> o380;
    out.setGuidanceState((::midw_smartphoneint_fi_types::T_e8_MLGuidanceState)o380);
    uint32 o381;
    in >> o381;
    out.setGuidanceActive((::midw_smartphoneint_fi_types::T_e8_MLGuidanceActive)o381);
    bool o382;
    in >> o382;
    out.setMetricSystem(o382);
    bool o383;
    in >> o383;
    out.setRightDriving(o383);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_MLNavigationNextManeuverUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint32) in.getNextDirection();
    out << in.getNextManeuverIndex();
    out << in.getNextAngle();
    {
        uint32 o384 = static_cast<uint32>(in.getNextSideStreetAngles_1().size());
        out << o384;
        ::std::vector< uint32 >::const_iterator o385;
        for (o385 = in.getNextSideStreetAngles_1().begin(); o385 != in.getNextSideStreetAngles_1().end(); ++o385) {
            out << (*o385);
        }
    }
    {
        uint32 o386 = static_cast<uint32>(in.getNextSideStreetAngles_2().size());
        out << o386;
        ::std::vector< uint32 >::const_iterator o387;
        for (o387 = in.getNextSideStreetAngles_2().begin(); o387 != in.getNextSideStreetAngles_2().end(); ++o387) {
            out << (*o387);
        }
    }
    {
        uint32 o388 = static_cast<uint32>(in.getNextSideStreetAngles_3().size());
        out << o388;
        ::std::vector< uint32 >::const_iterator o389;
        for (o389 = in.getNextSideStreetAngles_3().begin(); o389 != in.getNextSideStreetAngles_3().end(); ++o389) {
            out << (*o389);
        }
    }
    out << in.getNextStreetName();
    out << in.getCurrentStreetName();
    out << in.getNumOfSideStreetAngles_1();
    out << in.getNumOfSideStreetAngles_2();
    out << in.getNumOfSideStreetAngles_3();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_MLNavigationNextManeuverUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o390;
    in >> o390;
    out.setNextDirection((::midw_smartphoneint_fi_types::T_e8_MLNextDirection)o390);
    uint32 o391;
    in >> o391;
    out.setNextManeuverIndex(o391);
    uint32 o392;
    in >> o392;
    out.setNextAngle(o392);
    {
        uint32 o393;
        in >> o393;
        out.getNextSideStreetAngles_1Mutable().clear ();
        out.getNextSideStreetAngles_1Mutable().reserve (o393);
        for (uint32 o394 = 0; o394 < o393; o394++) {
            uint32 o395;
            in >> o395;
            out.getNextSideStreetAngles_1Mutable().push_back(o395);
        }
    }
    {
        uint32 o396;
        in >> o396;
        out.getNextSideStreetAngles_2Mutable().clear ();
        out.getNextSideStreetAngles_2Mutable().reserve (o396);
        for (uint32 o397 = 0; o397 < o396; o397++) {
            uint32 o398;
            in >> o398;
            out.getNextSideStreetAngles_2Mutable().push_back(o398);
        }
    }
    {
        uint32 o399;
        in >> o399;
        out.getNextSideStreetAngles_3Mutable().clear ();
        out.getNextSideStreetAngles_3Mutable().reserve (o399);
        for (uint32 o400 = 0; o400 < o399; o400++) {
            uint32 o401;
            in >> o401;
            out.getNextSideStreetAngles_3Mutable().push_back(o401);
        }
    }
    ::std::string o402;
    in >> o402;
    out.setNextStreetName(o402);
    ::std::string o403;
    in >> o403;
    out.setCurrentStreetName(o403);
    uint32 o404;
    in >> o404;
    out.setNumOfSideStreetAngles_1(o404);
    uint32 o405;
    in >> o405;
    out.setNumOfSideStreetAngles_2(o405);
    uint32 o406;
    in >> o406;
    out.setNumOfSideStreetAngles_3(o406);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_MLSpeedLimitUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getCurrentSpeedLimit();
    out << in.getNextSpeedLimit();
    out << in.getDistance();
    out << (uint8) in.getDistanceUnit();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_MLSpeedLimitUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o407;
    in >> o407;
    out.setCurrentSpeedLimit(o407);
    uint32 o408;
    in >> o408;
    out.setNextSpeedLimit(o408);
    uint32 o409;
    in >> o409;
    out.setDistance(o409);
    uint8 o410;
    in >> o410;
    out.setDistanceUnit((::midw_smartphoneint_fi_types::T_e8_DistanceUnit)o410);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_MLNavigationNextDistanceUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDistance();
    out << (uint8) in.getDistanceUnit();
    out << in.getTime();
    out << in.getPercentage();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_MLNavigationNextDistanceUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o411;
    in >> o411;
    out.setDistance(o411);
    uint8 o412;
    in >> o412;
    out.setDistanceUnit((::midw_smartphoneint_fi_types::T_e8_DistanceUnit)o412);
    uint64 o413;
    in >> o413;
    out.setTime(o413);
    uint32 o414;
    in >> o414;
    out.setPercentage(o414);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_MLNavigationLaneGuidanceUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o415 = static_cast<uint32>(in.getNextLaneGuidances().size());
        out << o415;
        ::std::vector< uint32 >::const_iterator o416;
        for (o416 = in.getNextLaneGuidances().begin(); o416 != in.getNextLaneGuidances().end(); ++o416) {
            out << (*o416);
        }
    }
    out << in.getNumOfLaneGuidances();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_MLNavigationLaneGuidanceUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o417;
        in >> o417;
        out.getNextLaneGuidancesMutable().clear ();
        out.getNextLaneGuidancesMutable().reserve (o417);
        for (uint32 o418 = 0; o418 < o417; o418++) {
            uint32 o419;
            in >> o419;
            out.getNextLaneGuidancesMutable().push_back(o419);
        }
    }
    uint32 o420;
    in >> o420;
    out.setNumOfLaneGuidances(o420);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_MLNavigationTripInfoUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDestination();
    out << in.getDistance();
    out << (uint8) in.getDistanceUnit();
    out << in.getRemainingTravelTime();
    out << in.getRemainingTrafficTime();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_MLNavigationTripInfoUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o421;
    in >> o421;
    out.setDestination(o421);
    uint32 o422;
    in >> o422;
    out.setDistance(o422);
    uint8 o423;
    in >> o423;
    out.setDistanceUnit((::midw_smartphoneint_fi_types::T_e8_DistanceUnit)o423);
    uint64 o424;
    in >> o424;
    out.setRemainingTravelTime(o424);
    uint64 o425;
    in >> o425;
    out.setRemainingTrafficTime(o425);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_AmbientColourData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getFRed();
    out << in.getFGreen();
    out << in.getFBlue();
    out << in.getFAlpha();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_AmbientColourData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    float o426;
    in >> o426;
    out.setFRed(o426);
    float o427;
    in >> o427;
    out.setFGreen(o427);
    float o428;
    in >> o428;
    out.setFBlue(o428);
    float o429;
    in >> o429;
    out.setFAlpha(o429);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_RouteGuidanceDisplayComponent& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getComponentID();
    out << in.getDisplayName();
    out << in.getU16MaxCurrentRoadNameLength();
    out << in.getU16MaxDestinationNameLength();
    out << in.getU16MaxAfterManeuverRoadNameLength();
    out << in.getU16MaxManeuverDescriptionLength();
    out << in.getU16MaxGuidanceManeuverCapacity();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_RouteGuidanceDisplayComponent& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o430;
    in >> o430;
    out.setComponentID((::midw_smartphoneint_fi_types::T_e8_ComponentID)o430);
    ::std::string o431;
    in >> o431;
    out.setDisplayName(o431);
    uint16 o432;
    in >> o432;
    out.setU16MaxCurrentRoadNameLength(o432);
    uint16 o433;
    in >> o433;
    out.setU16MaxDestinationNameLength(o433);
    uint16 o434;
    in >> o434;
    out.setU16MaxAfterManeuverRoadNameLength(o434);
    uint16 o435;
    in >> o435;
    out.setU16MaxManeuverDescriptionLength(o435);
    uint16 o436;
    in >> o436;
    out.setU16MaxGuidanceManeuverCapacity(o436);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_KeyInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint32) in.getKeyCode();
    out << (uint32) in.getKeyType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_KeyInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o437;
    in >> o437;
    out.setKeyCode((::midw_smartphoneint_fi_types::T_e32_KeyCode)o437);
    uint32 o438;
    in >> o438;
    out.setKeyType((::midw_smartphoneint_fi_types::T_e32_KeyType)o438);
}

void serializeCca(const ::midw_smartphoneint_fi_types::T_TechnologyKeyConfig& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEnDeviceCategory();
    {
        uint32 o439 = static_cast<uint32>(in.getKeyInfo().size());
        out << o439;
        ::std::vector< ::midw_smartphoneint_fi_types::T_KeyInfo >::const_iterator o440;
        for (o440 = in.getKeyInfo().begin(); o440 != in.getKeyInfo().end(); ++o440) {
            serializeCca((*o440), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi_types::T_TechnologyKeyConfig& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o441;
    in >> o441;
    out.setEnDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o441);
    {
        uint32 o442;
        in >> o442;
        out.getKeyInfoMutable().clear ();
        out.getKeyInfoMutable().reserve (o442);
        for (uint32 o443 = 0; o443 < o442; o443++) {
            ::midw_smartphoneint_fi_types::T_KeyInfo o444;
            deserializeCca(in, o444, majorVersion);
            out.getKeyInfoMutable().push_back (o444);
        }
    }
}

