#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MIDW_SMARTPHONEINT_FI_TYPES_H
#define MIDW_SMARTPHONEINT_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "midw_smartphoneint_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types midw_smartphoneint_fi_types
 */

namespace midw_smartphoneint_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_ProjectionCapability;

class T_DeviceSelectionInfo;

class T_VersionInfo;

class T_DeviceDetails;

class T_AppDisplayInfo;

class T_AppAudioInfo;

class T_AppRemotingInfo;

class T_IconAttributes;

class T_AppDetails;

class T_EAPAppInfo;

class T_TouchCoordinates;

class T_TouchData;

class T_ScreenAttributes;

class T_VideoAttributes;

class T_NotificationEnable;

class T_NotificationAction;

class T_NotificationData;

class T_KeyCapabilities;

class T_ClientCapabilities;

class T_XDeviceKeys;

class T_AudioCapabilities;

class T_DisplayCapabilities;

class T_ApplicationMediaMetaData;

class T_ApplicationPhoneCallMetadata;

class T_Time;

class T_ApplicationPhoneCallExtendedMetadata;

class T_AccessoryDisplayContext;

class T_DisplayConstraint;

class T_DisplayLayerAttributes;

class T_DisplayAttributes;

class T_AccessoryAudioContext;

class T_DeviceAuthInfo;

class T_FeatureRestriction;

class T_WiFiAPCredentials;

class T_OEMICONDetails;

class T_CarPlayRouteGuidanceUpdate;

class T_CarPlayRouteGuidanceManeuverUpdate;

class T_DiPORouteGuidanceUpdate;

class T_DiPORouteGuidanceManeuverUpdate;

class T_CarPlayTBTUpdate;

class T_AAutoNavigationNextTurnData;

class T_AAutoNavigationNextTurnDistanceData;

class T_AAutoTBTUpdate;

class T_CarlifeNaviNextTurnInfo;

class T_CarlifeNaviAssistantGuideInfo;

class T_BDCLTBTUpdate;

class T_ProjectionVideoAttributes;

class T_MLNavigationInfoUpdate;

class T_MLNavigationNextManeuverUpdate;

class T_MLSpeedLimitUpdate;

class T_MLNavigationNextDistanceUpdate;

class T_MLNavigationLaneGuidanceUpdate;

class T_MLNavigationTripInfoUpdate;

class T_MLTBTUpdate;

class T_AmbientColourData;

class T_RouteGuidanceDisplayComponent;

class T_KeyInfo;

class T_TechnologyKeyConfig;

// type definitions
/**
 * If the meaning of "T_TouchInfo" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TouchCoordinates > T_TouchInfo;


/**
 * This structure provides the projection capability of connected smartphones
 */
class T_ProjectionCapability {
public:

    /**
     * Default constructor
     */
    inline  T_ProjectionCapability ();

    /**
     * Copy constructor
     */
    inline  T_ProjectionCapability (const T_ProjectionCapability &rhs);

    /**
     * All fields constructor
     */
    inline  T_ProjectionCapability (T_e8_USBPortType enUSBPortType_, T_e8_DeviceType enDeviceType_, T_e8_SupportInfo enCarplayProjection_, T_e8_SupportInfo enAndroidProjection_, T_e8_SupportInfo enMirrorlinkProjection_, T_e8_SupportInfo enMySPINProjection_, T_e8_SupportInfo enCarlifeProjection_, T_e8_SupportInfo enOnCarProjection_);

    /**
     * Destructor
     */
    inline  ~T_ProjectionCapability();

    /**
     * Assignment operator
     */
    inline T_ProjectionCapability& operator = (const T_ProjectionCapability& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ProjectionCapability& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ProjectionCapability& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ProjectionCapability& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ProjectionCapability& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enUSBPortType"

    static const int kEnUSBPortType = 0;

    /**
     * Clears the field "enUSBPortType".
     *
     * The field will be set to its default value. The hasEnUSBPortType()
     * method will return false.
     */
    inline void clearEnUSBPortType();

    /**
     * Checks whether the field "enUSBPortType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnUSBPortType()). Otherwise it will return false.
     */
    inline bool hasEnUSBPortType () const;

    /**
     * Returns the value of the member "enUSBPortType".
     *
     * Indicates the type of USB port device is connected to. Can be used to determine if device is connected to OTG capable port.
     *
     * @return The value of the field "enUSBPortType"
     */
    inline T_e8_USBPortType getEnUSBPortType () const;

    /**
     * Sets the value of the member "enUSBPortType".
     *
     * Indicates the type of USB port device is connected to. Can be used to determine if device is connected to OTG capable port.
     *
     * @param enUSBPortType The value which will be set
     */
    inline void setEnUSBPortType (T_e8_USBPortType enUSBPortType_);

    // API of field "enDeviceType"

    static const int kEnDeviceType = 1;

    /**
     * Clears the field "enDeviceType".
     *
     * The field will be set to its default value. The hasEnDeviceType()
     * method will return false.
     */
    inline void clearEnDeviceType();

    /**
     * Checks whether the field "enDeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDeviceType()). Otherwise it will return false.
     */
    inline bool hasEnDeviceType () const;

    /**
     * Returns the value of the member "enDeviceType".
     *
     * Identifies the Device Type(Android/Apple device).
     *
     * @return The value of the field "enDeviceType"
     */
    inline T_e8_DeviceType getEnDeviceType () const;

    /**
     * Sets the value of the member "enDeviceType".
     *
     * Identifies the Device Type(Android/Apple device).
     *
     * @param enDeviceType The value which will be set
     */
    inline void setEnDeviceType (T_e8_DeviceType enDeviceType_);

    // API of field "enCarplayProjection"

    static const int kEnCarplayProjection = 2;

    /**
     * Clears the field "enCarplayProjection".
     *
     * The field will be set to its default value. The hasEnCarplayProjection()
     * method will return false.
     */
    inline void clearEnCarplayProjection();

    /**
     * Checks whether the field "enCarplayProjection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnCarplayProjection()). Otherwise it will return false.
     */
    inline bool hasEnCarplayProjection () const;

    /**
     * Returns the value of the member "enCarplayProjection".
     *
     * Identifies if the device supports Carplay. Value will be set to SPI_SUPPORT_NOT_KNOWN if the capability cannot be determined
     *
     * @return The value of the field "enCarplayProjection"
     */
    inline T_e8_SupportInfo getEnCarplayProjection () const;

    /**
     * Sets the value of the member "enCarplayProjection".
     *
     * Identifies if the device supports Carplay. Value will be set to SPI_SUPPORT_NOT_KNOWN if the capability cannot be determined
     *
     * @param enCarplayProjection The value which will be set
     */
    inline void setEnCarplayProjection (T_e8_SupportInfo enCarplayProjection_);

    // API of field "enAndroidProjection"

    static const int kEnAndroidProjection = 3;

    /**
     * Clears the field "enAndroidProjection".
     *
     * The field will be set to its default value. The hasEnAndroidProjection()
     * method will return false.
     */
    inline void clearEnAndroidProjection();

    /**
     * Checks whether the field "enAndroidProjection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnAndroidProjection()). Otherwise it will return false.
     */
    inline bool hasEnAndroidProjection () const;

    /**
     * Returns the value of the member "enAndroidProjection".
     *
     * Identifies if the device supports Android Auto. Value will be set to SPI_SUPPORT_NOT_KNOWN if the capability cannot be determined
     *
     * @return The value of the field "enAndroidProjection"
     */
    inline T_e8_SupportInfo getEnAndroidProjection () const;

    /**
     * Sets the value of the member "enAndroidProjection".
     *
     * Identifies if the device supports Android Auto. Value will be set to SPI_SUPPORT_NOT_KNOWN if the capability cannot be determined
     *
     * @param enAndroidProjection The value which will be set
     */
    inline void setEnAndroidProjection (T_e8_SupportInfo enAndroidProjection_);

    // API of field "enMirrorlinkProjection"

    static const int kEnMirrorlinkProjection = 4;

    /**
     * Clears the field "enMirrorlinkProjection".
     *
     * The field will be set to its default value. The hasEnMirrorlinkProjection()
     * method will return false.
     */
    inline void clearEnMirrorlinkProjection();

    /**
     * Checks whether the field "enMirrorlinkProjection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnMirrorlinkProjection()). Otherwise it will return false.
     */
    inline bool hasEnMirrorlinkProjection () const;

    /**
     * Returns the value of the member "enMirrorlinkProjection".
     *
     * Identifies if the device supports Mirrorlink. Value will be set to SPI_SUPPORT_NOT_KNOWN if the capability cannot be determined
     *
     * @return The value of the field "enMirrorlinkProjection"
     */
    inline T_e8_SupportInfo getEnMirrorlinkProjection () const;

    /**
     * Sets the value of the member "enMirrorlinkProjection".
     *
     * Identifies if the device supports Mirrorlink. Value will be set to SPI_SUPPORT_NOT_KNOWN if the capability cannot be determined
     *
     * @param enMirrorlinkProjection The value which will be set
     */
    inline void setEnMirrorlinkProjection (T_e8_SupportInfo enMirrorlinkProjection_);

    // API of field "enMySPINProjection"

    static const int kEnMySPINProjection = 5;

    /**
     * Clears the field "enMySPINProjection".
     *
     * The field will be set to its default value. The hasEnMySPINProjection()
     * method will return false.
     */
    inline void clearEnMySPINProjection();

    /**
     * Checks whether the field "enMySPINProjection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnMySPINProjection()). Otherwise it will return false.
     */
    inline bool hasEnMySPINProjection () const;

    /**
     * Returns the value of the member "enMySPINProjection".
     *
     * Identifies if the device supports mySPIN. Value will be set to SPI_SUPPORT_NOT_KNOWN if the capability cannot be determined
     *
     * @return The value of the field "enMySPINProjection"
     */
    inline T_e8_SupportInfo getEnMySPINProjection () const;

    /**
     * Sets the value of the member "enMySPINProjection".
     *
     * Identifies if the device supports mySPIN. Value will be set to SPI_SUPPORT_NOT_KNOWN if the capability cannot be determined
     *
     * @param enMySPINProjection The value which will be set
     */
    inline void setEnMySPINProjection (T_e8_SupportInfo enMySPINProjection_);

    // API of field "enCarlifeProjection"

    static const int kEnCarlifeProjection = 6;

    /**
     * Clears the field "enCarlifeProjection".
     *
     * The field will be set to its default value. The hasEnCarlifeProjection()
     * method will return false.
     */
    inline void clearEnCarlifeProjection();

    /**
     * Checks whether the field "enCarlifeProjection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnCarlifeProjection()). Otherwise it will return false.
     */
    inline bool hasEnCarlifeProjection () const;

    /**
     * Returns the value of the member "enCarlifeProjection".
     *
     * Identifies if the device supports carlife. Value will be set to SPI_SUPPORT_NOT_KNOWN if the capability cannot be determined
     *
     * @return The value of the field "enCarlifeProjection"
     */
    inline T_e8_SupportInfo getEnCarlifeProjection () const;

    /**
     * Sets the value of the member "enCarlifeProjection".
     *
     * Identifies if the device supports carlife. Value will be set to SPI_SUPPORT_NOT_KNOWN if the capability cannot be determined
     *
     * @param enCarlifeProjection The value which will be set
     */
    inline void setEnCarlifeProjection (T_e8_SupportInfo enCarlifeProjection_);

    // API of field "enOnCarProjection"

    static const int kEnOnCarProjection = 7;

    /**
     * Clears the field "enOnCarProjection".
     *
     * The field will be set to its default value. The hasEnOnCarProjection()
     * method will return false.
     */
    inline void clearEnOnCarProjection();

    /**
     * Checks whether the field "enOnCarProjection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnOnCarProjection()). Otherwise it will return false.
     */
    inline bool hasEnOnCarProjection () const;

    /**
     * Returns the value of the member "enOnCarProjection".
     *
     * Identifies if the device supports oncar. Value will be set to SPI_SUPPORT_NOT_KNOWN if the capability cannot be determined
     *
     * @return The value of the field "enOnCarProjection"
     */
    inline T_e8_SupportInfo getEnOnCarProjection () const;

    /**
     * Sets the value of the member "enOnCarProjection".
     *
     * Identifies if the device supports oncar. Value will be set to SPI_SUPPORT_NOT_KNOWN if the capability cannot be determined
     *
     * @param enOnCarProjection The value which will be set
     */
    inline void setEnOnCarProjection (T_e8_SupportInfo enOnCarProjection_);

    static const T_ProjectionCapability &getDefaultInstance();

private:

    inline void set_has_enUSBPortType ();

    inline void clear_has_enUSBPortType ();

    inline void set_has_enDeviceType ();

    inline void clear_has_enDeviceType ();

    inline void set_has_enCarplayProjection ();

    inline void clear_has_enCarplayProjection ();

    inline void set_has_enAndroidProjection ();

    inline void clear_has_enAndroidProjection ();

    inline void set_has_enMirrorlinkProjection ();

    inline void clear_has_enMirrorlinkProjection ();

    inline void set_has_enMySPINProjection ();

    inline void clear_has_enMySPINProjection ();

    inline void set_has_enCarlifeProjection ();

    inline void clear_has_enCarlifeProjection ();

    inline void set_has_enOnCarProjection ();

    inline void clear_has_enOnCarProjection ();

    uint32 _has_bits_[ (8 + 31) / 32];

    T_e8_USBPortType _enUSBPortType;

    T_e8_DeviceType _enDeviceType;

    T_e8_SupportInfo _enCarplayProjection;

    T_e8_SupportInfo _enAndroidProjection;

    T_e8_SupportInfo _enMirrorlinkProjection;

    T_e8_SupportInfo _enMySPINProjection;

    T_e8_SupportInfo _enCarlifeProjection;

    T_e8_SupportInfo _enOnCarProjection;

};

/**
 * This structure provides the projection capability of connected smartphones
 */
class T_DeviceSelectionInfo {
public:

    /**
     * Default constructor
     */
    inline  T_DeviceSelectionInfo ();

    /**
     * Copy constructor
     */
    inline  T_DeviceSelectionInfo (const T_DeviceSelectionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_DeviceSelectionInfo (T_e8_DeviceSelectionState enDeviceSelectionState_, T_e8_DeviceSelectionErrorType enDeviceSelectionErrorType_, T_e8_DeviceSelectionProgressState enDeviceSelectionProgressState_);

    /**
     * Destructor
     */
    inline  ~T_DeviceSelectionInfo();

    /**
     * Assignment operator
     */
    inline T_DeviceSelectionInfo& operator = (const T_DeviceSelectionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DeviceSelectionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DeviceSelectionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DeviceSelectionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DeviceSelectionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enDeviceSelectionState"

    static const int kEnDeviceSelectionState = 0;

    /**
     * Clears the field "enDeviceSelectionState".
     *
     * The field will be set to its default value. The hasEnDeviceSelectionState()
     * method will return false.
     */
    inline void clearEnDeviceSelectionState();

    /**
     * Checks whether the field "enDeviceSelectionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDeviceSelectionState()). Otherwise it will return false.
     */
    inline bool hasEnDeviceSelectionState () const;

    /**
     * Returns the value of the member "enDeviceSelectionState".
     *
     * Indicates the current device selection state
     *
     * @return The value of the field "enDeviceSelectionState"
     */
    inline T_e8_DeviceSelectionState getEnDeviceSelectionState () const;

    /**
     * Sets the value of the member "enDeviceSelectionState".
     *
     * Indicates the current device selection state
     *
     * @param enDeviceSelectionState The value which will be set
     */
    inline void setEnDeviceSelectionState (T_e8_DeviceSelectionState enDeviceSelectionState_);

    // API of field "enDeviceSelectionErrorType"

    static const int kEnDeviceSelectionErrorType = 1;

    /**
     * Clears the field "enDeviceSelectionErrorType".
     *
     * The field will be set to its default value. The hasEnDeviceSelectionErrorType()
     * method will return false.
     */
    inline void clearEnDeviceSelectionErrorType();

    /**
     * Checks whether the field "enDeviceSelectionErrorType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDeviceSelectionErrorType()). Otherwise it will return false.
     */
    inline bool hasEnDeviceSelectionErrorType () const;

    /**
     * Returns the value of the member "enDeviceSelectionErrorType".
     *
     * Indicates the selection error type.
     *
     * @return The value of the field "enDeviceSelectionErrorType"
     */
    inline T_e8_DeviceSelectionErrorType getEnDeviceSelectionErrorType () const;

    /**
     * Sets the value of the member "enDeviceSelectionErrorType".
     *
     * Indicates the selection error type.
     *
     * @param enDeviceSelectionErrorType The value which will be set
     */
    inline void setEnDeviceSelectionErrorType (T_e8_DeviceSelectionErrorType enDeviceSelectionErrorType_);

    // API of field "enDeviceSelectionProgressState"

    static const int kEnDeviceSelectionProgressState = 2;

    /**
     * Clears the field "enDeviceSelectionProgressState".
     *
     * The field will be set to its default value. The hasEnDeviceSelectionProgressState()
     * method will return false.
     */
    inline void clearEnDeviceSelectionProgressState();

    /**
     * Checks whether the field "enDeviceSelectionProgressState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDeviceSelectionProgressState()). Otherwise it will return false.
     */
    inline bool hasEnDeviceSelectionProgressState () const;

    /**
     * Returns the value of the member "enDeviceSelectionProgressState".
     *
     * Indicates addition( Sub states) information  when device selection is in progress( i.e when enDeviceSelectionState is in DEVICE_SELECTION_INPROGRESS)
     *
     * @return The value of the field "enDeviceSelectionProgressState"
     */
    inline T_e8_DeviceSelectionProgressState getEnDeviceSelectionProgressState () const;

    /**
     * Sets the value of the member "enDeviceSelectionProgressState".
     *
     * Indicates addition( Sub states) information  when device selection is in progress( i.e when enDeviceSelectionState is in DEVICE_SELECTION_INPROGRESS)
     *
     * @param enDeviceSelectionProgressState The value which will be set
     */
    inline void setEnDeviceSelectionProgressState (T_e8_DeviceSelectionProgressState enDeviceSelectionProgressState_);

    static const T_DeviceSelectionInfo &getDefaultInstance();

private:

    inline void set_has_enDeviceSelectionState ();

    inline void clear_has_enDeviceSelectionState ();

    inline void set_has_enDeviceSelectionErrorType ();

    inline void clear_has_enDeviceSelectionErrorType ();

    inline void set_has_enDeviceSelectionProgressState ();

    inline void clear_has_enDeviceSelectionProgressState ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_DeviceSelectionState _enDeviceSelectionState;

    T_e8_DeviceSelectionErrorType _enDeviceSelectionErrorType;

    T_e8_DeviceSelectionProgressState _enDeviceSelectionProgressState;

};

/**
 * This structure provides the Mirror Link version information
 */
class T_VersionInfo {
public:

    /**
     * Default constructor
     */
    inline  T_VersionInfo ();

    /**
     * Copy constructor
     */
    inline  T_VersionInfo (const T_VersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_VersionInfo (const ::std::string& szMinorVersion_, const ::std::string& szMajorVersion_, const ::std::string& szPatchVersion_);

    /**
     * Destructor
     */
    inline  ~T_VersionInfo();

    /**
     * Assignment operator
     */
    inline T_VersionInfo& operator = (const T_VersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_VersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_VersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_VersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_VersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szMinorVersion"

    static const int kSzMinorVersion = 0;

    /**
     * Clears the field "szMinorVersion".
     *
     * The field will be set to its default value. The hasSzMinorVersion()
     * method will return false.
     */
    inline void clearSzMinorVersion();

    /**
     * Checks whether the field "szMinorVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzMinorVersion()). Otherwise it will return false.
     */
    inline bool hasSzMinorVersion () const;

    /**
     * Returns the value of the member "szMinorVersion".
     *
     * Indicates the Major Version
     *
     * @return The value of the field "szMinorVersion"
     */
    inline const ::std::string& getSzMinorVersion () const;

    /**
     * Retrieves the value of the field "szMinorVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szMinorVersion".
     */
    inline ::std::string& getSzMinorVersionMutable ();

    /**
     * Sets the value of the member "szMinorVersion".
     *
     * Indicates the Major Version
     *
     * @param szMinorVersion The value which will be set
     */
    inline void setSzMinorVersion (const ::std::string& szMinorVersion_);

    /**
     * Sets the value of the member "szMinorVersion".
     *
     * Indicates the Major Version
     *
     * @param szMinorVersion The value which will be set
     */
    inline void setSzMinorVersion (const char* szMinorVersion_);

    /**
     * Sets the value of the member "szMinorVersion".
     *
     * Indicates the Major Version
     *
     * @param szMinorVersion The value which will be set
     */
    inline void setSzMinorVersion (const char* value, size_t size);

    // API of field "szMajorVersion"

    static const int kSzMajorVersion = 1;

    /**
     * Clears the field "szMajorVersion".
     *
     * The field will be set to its default value. The hasSzMajorVersion()
     * method will return false.
     */
    inline void clearSzMajorVersion();

    /**
     * Checks whether the field "szMajorVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzMajorVersion()). Otherwise it will return false.
     */
    inline bool hasSzMajorVersion () const;

    /**
     * Returns the value of the member "szMajorVersion".
     *
     * Indicates the Minor Version
     *
     * @return The value of the field "szMajorVersion"
     */
    inline const ::std::string& getSzMajorVersion () const;

    /**
     * Retrieves the value of the field "szMajorVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szMajorVersion".
     */
    inline ::std::string& getSzMajorVersionMutable ();

    /**
     * Sets the value of the member "szMajorVersion".
     *
     * Indicates the Minor Version
     *
     * @param szMajorVersion The value which will be set
     */
    inline void setSzMajorVersion (const ::std::string& szMajorVersion_);

    /**
     * Sets the value of the member "szMajorVersion".
     *
     * Indicates the Minor Version
     *
     * @param szMajorVersion The value which will be set
     */
    inline void setSzMajorVersion (const char* szMajorVersion_);

    /**
     * Sets the value of the member "szMajorVersion".
     *
     * Indicates the Minor Version
     *
     * @param szMajorVersion The value which will be set
     */
    inline void setSzMajorVersion (const char* value, size_t size);

    // API of field "szPatchVersion"

    static const int kSzPatchVersion = 2;

    /**
     * Clears the field "szPatchVersion".
     *
     * The field will be set to its default value. The hasSzPatchVersion()
     * method will return false.
     */
    inline void clearSzPatchVersion();

    /**
     * Checks whether the field "szPatchVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzPatchVersion()). Otherwise it will return false.
     */
    inline bool hasSzPatchVersion () const;

    /**
     * Returns the value of the member "szPatchVersion".
     *
     * Indicates the Patch Version (Set to NULL if not available)
     *
     * @return The value of the field "szPatchVersion"
     */
    inline const ::std::string& getSzPatchVersion () const;

    /**
     * Retrieves the value of the field "szPatchVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szPatchVersion".
     */
    inline ::std::string& getSzPatchVersionMutable ();

    /**
     * Sets the value of the member "szPatchVersion".
     *
     * Indicates the Patch Version (Set to NULL if not available)
     *
     * @param szPatchVersion The value which will be set
     */
    inline void setSzPatchVersion (const ::std::string& szPatchVersion_);

    /**
     * Sets the value of the member "szPatchVersion".
     *
     * Indicates the Patch Version (Set to NULL if not available)
     *
     * @param szPatchVersion The value which will be set
     */
    inline void setSzPatchVersion (const char* szPatchVersion_);

    /**
     * Sets the value of the member "szPatchVersion".
     *
     * Indicates the Patch Version (Set to NULL if not available)
     *
     * @param szPatchVersion The value which will be set
     */
    inline void setSzPatchVersion (const char* value, size_t size);

    static const T_VersionInfo &getDefaultInstance();

private:

    inline void set_has_szMinorVersion ();

    inline void clear_has_szMinorVersion ();

    inline void set_has_szMajorVersion ();

    inline void clear_has_szMajorVersion ();

    inline void set_has_szPatchVersion ();

    inline void clear_has_szPatchVersion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _szMinorVersion;

    ::std::string _szMajorVersion;

    ::std::string _szPatchVersion;

};

/**
 * This structure provides the attributes of connected device
 */
class T_DeviceDetails {
public:

    /**
     * Default constructor
     */
    inline  T_DeviceDetails ();

    /**
     * Copy constructor
     */
    inline  T_DeviceDetails (const T_DeviceDetails &rhs);

    /**
     * All fields constructor
     */
    inline  T_DeviceDetails (uint32 u32DeviceHandle_, const ::std::string& szDeviceName_, T_e8_DeviceCategory enDeviceCategory_, const ::std::string& szDeviceModelName_, const ::std::string& szDeviceManufacturerName_, T_e8_DeviceConnectionStatus enDeviceConnectionStatus_, T_e8_DeviceConnectionType enDeviceConnectionType_, const T_VersionInfo& rVersionInfo_, T_e8_EnabledInfo enDeviceUsageEnabled_, bool bSelectedDevice_, bool bDAPSupport_, const T_ProjectionCapability& rProjectionCapability_, const ::std::string& szBTAddress_, const T_DeviceSelectionInfo& rDeviceSelectionInfo_, const ::std::string& szSerialNumber_, T_e8_UserAuthorizationStatus enUserAuthorizationStatus_, T_e8_SessionTransportType enSessionTransportType_, uint32 u32VendorID_, uint32 u32ProductID_, const ::std::string& szSystemPath_);

    /**
     * Destructor
     */
    inline  ~T_DeviceDetails();

    /**
     * Assignment operator
     */
    inline T_DeviceDetails& operator = (const T_DeviceDetails& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DeviceDetails& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DeviceDetails& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DeviceDetails& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DeviceDetails& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32DeviceHandle"

    static const int kU32DeviceHandle = 0;

    /**
     * Clears the field "u32DeviceHandle".
     *
     * The field will be set to its default value. The hasU32DeviceHandle()
     * method will return false.
     */
    inline void clearU32DeviceHandle();

    /**
     * Checks whether the field "u32DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU32DeviceHandle () const;

    /**
     * Returns the value of the member "u32DeviceHandle".
     *
     * Provides the information of Unique device identifier
     *
     * @return The value of the field "u32DeviceHandle"
     */
    inline uint32 getU32DeviceHandle () const;

    /**
     * Sets the value of the member "u32DeviceHandle".
     *
     * Provides the information of Unique device identifier
     *
     * @param u32DeviceHandle The value which will be set
     */
    inline void setU32DeviceHandle (uint32 u32DeviceHandle_);

    // API of field "szDeviceName"

    static const int kSzDeviceName = 1;

    /**
     * Clears the field "szDeviceName".
     *
     * The field will be set to its default value. The hasSzDeviceName()
     * method will return false.
     */
    inline void clearSzDeviceName();

    /**
     * Checks whether the field "szDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceName()). Otherwise it will return false.
     */
    inline bool hasSzDeviceName () const;

    /**
     * Returns the value of the member "szDeviceName".
     *
     * Provides the information of Name of the Device
     *
     * @return The value of the field "szDeviceName"
     */
    inline const ::std::string& getSzDeviceName () const;

    /**
     * Retrieves the value of the field "szDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceName".
     */
    inline ::std::string& getSzDeviceNameMutable ();

    /**
     * Sets the value of the member "szDeviceName".
     *
     * Provides the information of Name of the Device
     *
     * @param szDeviceName The value which will be set
     */
    inline void setSzDeviceName (const ::std::string& szDeviceName_);

    /**
     * Sets the value of the member "szDeviceName".
     *
     * Provides the information of Name of the Device
     *
     * @param szDeviceName The value which will be set
     */
    inline void setSzDeviceName (const char* szDeviceName_);

    /**
     * Sets the value of the member "szDeviceName".
     *
     * Provides the information of Name of the Device
     *
     * @param szDeviceName The value which will be set
     */
    inline void setSzDeviceName (const char* value, size_t size);

    // API of field "enDeviceCategory"

    static const int kEnDeviceCategory = 2;

    /**
     * Clears the field "enDeviceCategory".
     *
     * The field will be set to its default value. The hasEnDeviceCategory()
     * method will return false.
     */
    inline void clearEnDeviceCategory();

    /**
     * Checks whether the field "enDeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasEnDeviceCategory () const;

    /**
     * Returns the value of the member "enDeviceCategory".
     *
     * Provides the information of SPI technology used by the device in current session if active else will contain the last used projection technology
     *
     * @return The value of the field "enDeviceCategory"
     */
    inline T_e8_DeviceCategory getEnDeviceCategory () const;

    /**
     * Sets the value of the member "enDeviceCategory".
     *
     * Provides the information of SPI technology used by the device in current session if active else will contain the last used projection technology
     *
     * @param enDeviceCategory The value which will be set
     */
    inline void setEnDeviceCategory (T_e8_DeviceCategory enDeviceCategory_);

    // API of field "szDeviceModelName"

    static const int kSzDeviceModelName = 3;

    /**
     * Clears the field "szDeviceModelName".
     *
     * The field will be set to its default value. The hasSzDeviceModelName()
     * method will return false.
     */
    inline void clearSzDeviceModelName();

    /**
     * Checks whether the field "szDeviceModelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceModelName()). Otherwise it will return false.
     */
    inline bool hasSzDeviceModelName () const;

    /**
     * Returns the value of the member "szDeviceModelName".
     *
     * Provides the Model Name of the Device.
     *
     * @return The value of the field "szDeviceModelName"
     */
    inline const ::std::string& getSzDeviceModelName () const;

    /**
     * Retrieves the value of the field "szDeviceModelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceModelName".
     */
    inline ::std::string& getSzDeviceModelNameMutable ();

    /**
     * Sets the value of the member "szDeviceModelName".
     *
     * Provides the Model Name of the Device.
     *
     * @param szDeviceModelName The value which will be set
     */
    inline void setSzDeviceModelName (const ::std::string& szDeviceModelName_);

    /**
     * Sets the value of the member "szDeviceModelName".
     *
     * Provides the Model Name of the Device.
     *
     * @param szDeviceModelName The value which will be set
     */
    inline void setSzDeviceModelName (const char* szDeviceModelName_);

    /**
     * Sets the value of the member "szDeviceModelName".
     *
     * Provides the Model Name of the Device.
     *
     * @param szDeviceModelName The value which will be set
     */
    inline void setSzDeviceModelName (const char* value, size_t size);

    // API of field "szDeviceManufacturerName"

    static const int kSzDeviceManufacturerName = 4;

    /**
     * Clears the field "szDeviceManufacturerName".
     *
     * The field will be set to its default value. The hasSzDeviceManufacturerName()
     * method will return false.
     */
    inline void clearSzDeviceManufacturerName();

    /**
     * Checks whether the field "szDeviceManufacturerName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceManufacturerName()). Otherwise it will return false.
     */
    inline bool hasSzDeviceManufacturerName () const;

    /**
     * Returns the value of the member "szDeviceManufacturerName".
     *
     * Provides the Manufacturer Name of the Device
     *
     * @return The value of the field "szDeviceManufacturerName"
     */
    inline const ::std::string& getSzDeviceManufacturerName () const;

    /**
     * Retrieves the value of the field "szDeviceManufacturerName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceManufacturerName".
     */
    inline ::std::string& getSzDeviceManufacturerNameMutable ();

    /**
     * Sets the value of the member "szDeviceManufacturerName".
     *
     * Provides the Manufacturer Name of the Device
     *
     * @param szDeviceManufacturerName The value which will be set
     */
    inline void setSzDeviceManufacturerName (const ::std::string& szDeviceManufacturerName_);

    /**
     * Sets the value of the member "szDeviceManufacturerName".
     *
     * Provides the Manufacturer Name of the Device
     *
     * @param szDeviceManufacturerName The value which will be set
     */
    inline void setSzDeviceManufacturerName (const char* szDeviceManufacturerName_);

    /**
     * Sets the value of the member "szDeviceManufacturerName".
     *
     * Provides the Manufacturer Name of the Device
     *
     * @param szDeviceManufacturerName The value which will be set
     */
    inline void setSzDeviceManufacturerName (const char* value, size_t size);

    // API of field "enDeviceConnectionStatus"

    static const int kEnDeviceConnectionStatus = 5;

    /**
     * Clears the field "enDeviceConnectionStatus".
     *
     * The field will be set to its default value. The hasEnDeviceConnectionStatus()
     * method will return false.
     */
    inline void clearEnDeviceConnectionStatus();

    /**
     * Checks whether the field "enDeviceConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDeviceConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasEnDeviceConnectionStatus () const;

    /**
     * Returns the value of the member "enDeviceConnectionStatus".
     *
     * Provides the information of Connection Status of the devices
     *
     * @return The value of the field "enDeviceConnectionStatus"
     */
    inline T_e8_DeviceConnectionStatus getEnDeviceConnectionStatus () const;

    /**
     * Sets the value of the member "enDeviceConnectionStatus".
     *
     * Provides the information of Connection Status of the devices
     *
     * @param enDeviceConnectionStatus The value which will be set
     */
    inline void setEnDeviceConnectionStatus (T_e8_DeviceConnectionStatus enDeviceConnectionStatus_);

    // API of field "enDeviceConnectionType"

    static const int kEnDeviceConnectionType = 6;

    /**
     * Clears the field "enDeviceConnectionType".
     *
     * The field will be set to its default value. The hasEnDeviceConnectionType()
     * method will return false.
     */
    inline void clearEnDeviceConnectionType();

    /**
     * Checks whether the field "enDeviceConnectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDeviceConnectionType()). Otherwise it will return false.
     */
    inline bool hasEnDeviceConnectionType () const;

    /**
     * Returns the value of the member "enDeviceConnectionType".
     *
     * Provides the information of Connection Type of the device
     *
     * @return The value of the field "enDeviceConnectionType"
     */
    inline T_e8_DeviceConnectionType getEnDeviceConnectionType () const;

    /**
     * Sets the value of the member "enDeviceConnectionType".
     *
     * Provides the information of Connection Type of the device
     *
     * @param enDeviceConnectionType The value which will be set
     */
    inline void setEnDeviceConnectionType (T_e8_DeviceConnectionType enDeviceConnectionType_);

    // API of field "rVersionInfo"

    static const int kRVersionInfo = 7;

    /**
     * Clears the field "rVersionInfo".
     *
     * The field will be set to its default value. The hasRVersionInfo()
     * method will return false.
     */
    inline void clearRVersionInfo();

    /**
     * Checks whether the field "rVersionInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRVersionInfo()). Otherwise it will return false.
     */
    inline bool hasRVersionInfo () const;

    /**
     * Returns the value of the member "rVersionInfo".
     *
     * Contains version based on the Device Category (MirrorLink/iPodOut)
     *
     * @return The value of the field "rVersionInfo"
     */
    inline const T_VersionInfo& getRVersionInfo () const;

    /**
     * Retrieves the value of the field "rVersionInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rVersionInfo".
     */
    inline T_VersionInfo& getRVersionInfoMutable ();

    /**
     * Sets the value of the member "rVersionInfo".
     *
     * Contains version based on the Device Category (MirrorLink/iPodOut)
     *
     * @param rVersionInfo The value which will be set
     */
    inline void setRVersionInfo (const T_VersionInfo& rVersionInfo_);

    // API of field "enDeviceUsageEnabled"

    static const int kEnDeviceUsageEnabled = 8;

    /**
     * Clears the field "enDeviceUsageEnabled".
     *
     * The field will be set to its default value. The hasEnDeviceUsageEnabled()
     * method will return false.
     */
    inline void clearEnDeviceUsageEnabled();

    /**
     * Checks whether the field "enDeviceUsageEnabled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDeviceUsageEnabled()). Otherwise it will return false.
     */
    inline bool hasEnDeviceUsageEnabled () const;

    /**
     * Returns the value of the member "enDeviceUsageEnabled".
     *
     * Device can be used for projection only if this value is set for either Enabled or confirmation required. If the the value is set for disabled the technology cannot be projected.
     *
     * @return The value of the field "enDeviceUsageEnabled"
     */
    inline T_e8_EnabledInfo getEnDeviceUsageEnabled () const;

    /**
     * Sets the value of the member "enDeviceUsageEnabled".
     *
     * Device can be used for projection only if this value is set for either Enabled or confirmation required. If the the value is set for disabled the technology cannot be projected.
     *
     * @param enDeviceUsageEnabled The value which will be set
     */
    inline void setEnDeviceUsageEnabled (T_e8_EnabledInfo enDeviceUsageEnabled_);

    // API of field "bSelectedDevice"

    static const int kBSelectedDevice = 9;

    /**
     * Clears the field "bSelectedDevice".
     *
     * The field will be set to its default value. The hasBSelectedDevice()
     * method will return false.
     */
    inline void clearBSelectedDevice();

    /**
     * Checks whether the field "bSelectedDevice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSelectedDevice()). Otherwise it will return false.
     */
    inline bool hasBSelectedDevice () const;

    /**
     * Returns the value of the member "bSelectedDevice".
     *
     * This value is set to TRUE if a device is automatically selected to initiate a session, FALSE otherwise. Specifically used in case of startup.
     *
     * @return The value of the field "bSelectedDevice"
     */
    inline bool getBSelectedDevice () const;

    /**
     * Sets the value of the member "bSelectedDevice".
     *
     * This value is set to TRUE if a device is automatically selected to initiate a session, FALSE otherwise. Specifically used in case of startup.
     *
     * @param bSelectedDevice The value which will be set
     */
    inline void setBSelectedDevice (bool bSelectedDevice_);

    // API of field "bDAPSupport"

    static const int kBDAPSupport = 10;

    /**
     * Clears the field "bDAPSupport".
     *
     * The field will be set to its default value. The hasBDAPSupport()
     * method will return false.
     */
    inline void clearBDAPSupport();

    /**
     * Checks whether the field "bDAPSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDAPSupport()). Otherwise it will return false.
     */
    inline bool hasBDAPSupport () const;

    /**
     * Returns the value of the member "bDAPSupport".
     *
     * Set to TRUE if device sup-ports DAP, FALSE otherwise.
     *
     * @return The value of the field "bDAPSupport"
     */
    inline bool getBDAPSupport () const;

    /**
     * Sets the value of the member "bDAPSupport".
     *
     * Set to TRUE if device sup-ports DAP, FALSE otherwise.
     *
     * @param bDAPSupport The value which will be set
     */
    inline void setBDAPSupport (bool bDAPSupport_);

    // API of field "rProjectionCapability"

    static const int kRProjectionCapability = 11;

    /**
     * Clears the field "rProjectionCapability".
     *
     * The field will be set to its default value. The hasRProjectionCapability()
     * method will return false.
     */
    inline void clearRProjectionCapability();

    /**
     * Checks whether the field "rProjectionCapability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRProjectionCapability()). Otherwise it will return false.
     */
    inline bool hasRProjectionCapability () const;

    /**
     * Returns the value of the member "rProjectionCapability".
     *
     * Structure containing the device's smart phone integration capability capability
     *
     * @return The value of the field "rProjectionCapability"
     */
    inline const T_ProjectionCapability& getRProjectionCapability () const;

    /**
     * Retrieves the value of the field "rProjectionCapability" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rProjectionCapability".
     */
    inline T_ProjectionCapability& getRProjectionCapabilityMutable ();

    /**
     * Sets the value of the member "rProjectionCapability".
     *
     * Structure containing the device's smart phone integration capability capability
     *
     * @param rProjectionCapability The value which will be set
     */
    inline void setRProjectionCapability (const T_ProjectionCapability& rProjectionCapability_);

    // API of field "szBTAddress"

    static const int kSzBTAddress = 12;

    /**
     * Clears the field "szBTAddress".
     *
     * The field will be set to its default value. The hasSzBTAddress()
     * method will return false.
     */
    inline void clearSzBTAddress();

    /**
     * Checks whether the field "szBTAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzBTAddress()). Otherwise it will return false.
     */
    inline bool hasSzBTAddress () const;

    /**
     * Returns the value of the member "szBTAddress".
     *
     * Bluetooth address of the device, Set to NULL if not available.
     *
     * @return The value of the field "szBTAddress"
     */
    inline const ::std::string& getSzBTAddress () const;

    /**
     * Retrieves the value of the field "szBTAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szBTAddress".
     */
    inline ::std::string& getSzBTAddressMutable ();

    /**
     * Sets the value of the member "szBTAddress".
     *
     * Bluetooth address of the device, Set to NULL if not available.
     *
     * @param szBTAddress The value which will be set
     */
    inline void setSzBTAddress (const ::std::string& szBTAddress_);

    /**
     * Sets the value of the member "szBTAddress".
     *
     * Bluetooth address of the device, Set to NULL if not available.
     *
     * @param szBTAddress The value which will be set
     */
    inline void setSzBTAddress (const char* szBTAddress_);

    /**
     * Sets the value of the member "szBTAddress".
     *
     * Bluetooth address of the device, Set to NULL if not available.
     *
     * @param szBTAddress The value which will be set
     */
    inline void setSzBTAddress (const char* value, size_t size);

    // API of field "rDeviceSelectionInfo"

    static const int kRDeviceSelectionInfo = 13;

    /**
     * Clears the field "rDeviceSelectionInfo".
     *
     * The field will be set to its default value. The hasRDeviceSelectionInfo()
     * method will return false.
     */
    inline void clearRDeviceSelectionInfo();

    /**
     * Checks whether the field "rDeviceSelectionInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRDeviceSelectionInfo()). Otherwise it will return false.
     */
    inline bool hasRDeviceSelectionInfo () const;

    /**
     * Returns the value of the member "rDeviceSelectionInfo".
     *
     * Provides the device selection state of the device. Can be used to determine if a device selection is in progress or if the device selection is complete
     *
     * @return The value of the field "rDeviceSelectionInfo"
     */
    inline const T_DeviceSelectionInfo& getRDeviceSelectionInfo () const;

    /**
     * Retrieves the value of the field "rDeviceSelectionInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rDeviceSelectionInfo".
     */
    inline T_DeviceSelectionInfo& getRDeviceSelectionInfoMutable ();

    /**
     * Sets the value of the member "rDeviceSelectionInfo".
     *
     * Provides the device selection state of the device. Can be used to determine if a device selection is in progress or if the device selection is complete
     *
     * @param rDeviceSelectionInfo The value which will be set
     */
    inline void setRDeviceSelectionInfo (const T_DeviceSelectionInfo& rDeviceSelectionInfo_);

    // API of field "szSerialNumber"

    static const int kSzSerialNumber = 14;

    /**
     * Clears the field "szSerialNumber".
     *
     * The field will be set to its default value. The hasSzSerialNumber()
     * method will return false.
     */
    inline void clearSzSerialNumber();

    /**
     * Checks whether the field "szSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSzSerialNumber () const;

    /**
     * Returns the value of the member "szSerialNumber".
     *
     * Serial number of the device, Set to NULL if not available.
     *
     * @return The value of the field "szSerialNumber"
     */
    inline const ::std::string& getSzSerialNumber () const;

    /**
     * Retrieves the value of the field "szSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szSerialNumber".
     */
    inline ::std::string& getSzSerialNumberMutable ();

    /**
     * Sets the value of the member "szSerialNumber".
     *
     * Serial number of the device, Set to NULL if not available.
     *
     * @param szSerialNumber The value which will be set
     */
    inline void setSzSerialNumber (const ::std::string& szSerialNumber_);

    /**
     * Sets the value of the member "szSerialNumber".
     *
     * Serial number of the device, Set to NULL if not available.
     *
     * @param szSerialNumber The value which will be set
     */
    inline void setSzSerialNumber (const char* szSerialNumber_);

    /**
     * Sets the value of the member "szSerialNumber".
     *
     * Serial number of the device, Set to NULL if not available.
     *
     * @param szSerialNumber The value which will be set
     */
    inline void setSzSerialNumber (const char* value, size_t size);

    // API of field "enUserAuthorizationStatus"

    static const int kEnUserAuthorizationStatus = 15;

    /**
     * Clears the field "enUserAuthorizationStatus".
     *
     * The field will be set to its default value. The hasEnUserAuthorizationStatus()
     * method will return false.
     */
    inline void clearEnUserAuthorizationStatus();

    /**
     * Checks whether the field "enUserAuthorizationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnUserAuthorizationStatus()). Otherwise it will return false.
     */
    inline bool hasEnUserAuthorizationStatus () const;

    /**
     * Returns the value of the member "enUserAuthorizationStatus".
     *
     * Provides current authorization status for the device. Populated as USER_AUTH_UNKNOWN for a new device or for a device to which legal disclaimer is not yet accepted by User
     *
     * @return The value of the field "enUserAuthorizationStatus"
     */
    inline T_e8_UserAuthorizationStatus getEnUserAuthorizationStatus () const;

    /**
     * Sets the value of the member "enUserAuthorizationStatus".
     *
     * Provides current authorization status for the device. Populated as USER_AUTH_UNKNOWN for a new device or for a device to which legal disclaimer is not yet accepted by User
     *
     * @param enUserAuthorizationStatus The value which will be set
     */
    inline void setEnUserAuthorizationStatus (T_e8_UserAuthorizationStatus enUserAuthorizationStatus_);

    // API of field "enSessionTransportType"

    static const int kEnSessionTransportType = 16;

    /**
     * Clears the field "enSessionTransportType".
     *
     * The field will be set to its default value. The hasEnSessionTransportType()
     * method will return false.
     */
    inline void clearEnSessionTransportType();

    /**
     * Checks whether the field "enSessionTransportType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnSessionTransportType()). Otherwise it will return false.
     */
    inline bool hasEnSessionTransportType () const;

    /**
     * Returns the value of the member "enSessionTransportType".
     *
     * Provides the transport details on which SPI session is established (USB/WIFI). For Carplay, this information is known only after session starts. This field will be used for technologies that support more than one transport (USB, WiFi) for SPI session
     *
     * @return The value of the field "enSessionTransportType"
     */
    inline T_e8_SessionTransportType getEnSessionTransportType () const;

    /**
     * Sets the value of the member "enSessionTransportType".
     *
     * Provides the transport details on which SPI session is established (USB/WIFI). For Carplay, this information is known only after session starts. This field will be used for technologies that support more than one transport (USB, WiFi) for SPI session
     *
     * @param enSessionTransportType The value which will be set
     */
    inline void setEnSessionTransportType (T_e8_SessionTransportType enSessionTransportType_);

    // API of field "u32VendorID"

    static const int kU32VendorID = 17;

    /**
     * Clears the field "u32VendorID".
     *
     * The field will be set to its default value. The hasU32VendorID()
     * method will return false.
     */
    inline void clearU32VendorID();

    /**
     * Checks whether the field "u32VendorID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32VendorID()). Otherwise it will return false.
     */
    inline bool hasU32VendorID () const;

    /**
     * Returns the value of the member "u32VendorID".
     *
     * Provides info about Vendor ID.
     *
     * @return The value of the field "u32VendorID"
     */
    inline uint32 getU32VendorID () const;

    /**
     * Sets the value of the member "u32VendorID".
     *
     * Provides info about Vendor ID.
     *
     * @param u32VendorID The value which will be set
     */
    inline void setU32VendorID (uint32 u32VendorID_);

    // API of field "u32ProductID"

    static const int kU32ProductID = 18;

    /**
     * Clears the field "u32ProductID".
     *
     * The field will be set to its default value. The hasU32ProductID()
     * method will return false.
     */
    inline void clearU32ProductID();

    /**
     * Checks whether the field "u32ProductID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ProductID()). Otherwise it will return false.
     */
    inline bool hasU32ProductID () const;

    /**
     * Returns the value of the member "u32ProductID".
     *
     * Provides info about Product ID.
     *
     * @return The value of the field "u32ProductID"
     */
    inline uint32 getU32ProductID () const;

    /**
     * Sets the value of the member "u32ProductID".
     *
     * Provides info about Product ID.
     *
     * @param u32ProductID The value which will be set
     */
    inline void setU32ProductID (uint32 u32ProductID_);

    // API of field "szSystemPath"

    static const int kSzSystemPath = 19;

    /**
     * Clears the field "szSystemPath".
     *
     * The field will be set to its default value. The hasSzSystemPath()
     * method will return false.
     */
    inline void clearSzSystemPath();

    /**
     * Checks whether the field "szSystemPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzSystemPath()). Otherwise it will return false.
     */
    inline bool hasSzSystemPath () const;

    /**
     * Returns the value of the member "szSystemPath".
     *
     * System path of the device, Set to NULL if not available.
     *
     * @return The value of the field "szSystemPath"
     */
    inline const ::std::string& getSzSystemPath () const;

    /**
     * Retrieves the value of the field "szSystemPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szSystemPath".
     */
    inline ::std::string& getSzSystemPathMutable ();

    /**
     * Sets the value of the member "szSystemPath".
     *
     * System path of the device, Set to NULL if not available.
     *
     * @param szSystemPath The value which will be set
     */
    inline void setSzSystemPath (const ::std::string& szSystemPath_);

    /**
     * Sets the value of the member "szSystemPath".
     *
     * System path of the device, Set to NULL if not available.
     *
     * @param szSystemPath The value which will be set
     */
    inline void setSzSystemPath (const char* szSystemPath_);

    /**
     * Sets the value of the member "szSystemPath".
     *
     * System path of the device, Set to NULL if not available.
     *
     * @param szSystemPath The value which will be set
     */
    inline void setSzSystemPath (const char* value, size_t size);

    static const T_DeviceDetails &getDefaultInstance();

private:

    inline void set_has_u32DeviceHandle ();

    inline void clear_has_u32DeviceHandle ();

    inline void set_has_szDeviceName ();

    inline void clear_has_szDeviceName ();

    inline void set_has_enDeviceCategory ();

    inline void clear_has_enDeviceCategory ();

    inline void set_has_szDeviceModelName ();

    inline void clear_has_szDeviceModelName ();

    inline void set_has_szDeviceManufacturerName ();

    inline void clear_has_szDeviceManufacturerName ();

    inline void set_has_enDeviceConnectionStatus ();

    inline void clear_has_enDeviceConnectionStatus ();

    inline void set_has_enDeviceConnectionType ();

    inline void clear_has_enDeviceConnectionType ();

    inline void set_has_rVersionInfo ();

    inline void clear_has_rVersionInfo ();

    inline void set_has_enDeviceUsageEnabled ();

    inline void clear_has_enDeviceUsageEnabled ();

    inline void set_has_bSelectedDevice ();

    inline void clear_has_bSelectedDevice ();

    inline void set_has_bDAPSupport ();

    inline void clear_has_bDAPSupport ();

    inline void set_has_rProjectionCapability ();

    inline void clear_has_rProjectionCapability ();

    inline void set_has_szBTAddress ();

    inline void clear_has_szBTAddress ();

    inline void set_has_rDeviceSelectionInfo ();

    inline void clear_has_rDeviceSelectionInfo ();

    inline void set_has_szSerialNumber ();

    inline void clear_has_szSerialNumber ();

    inline void set_has_enUserAuthorizationStatus ();

    inline void clear_has_enUserAuthorizationStatus ();

    inline void set_has_enSessionTransportType ();

    inline void clear_has_enSessionTransportType ();

    inline void set_has_u32VendorID ();

    inline void clear_has_u32VendorID ();

    inline void set_has_u32ProductID ();

    inline void clear_has_u32ProductID ();

    inline void set_has_szSystemPath ();

    inline void clear_has_szSystemPath ();

    uint32 _has_bits_[ (20 + 31) / 32];

    uint32 _u32DeviceHandle;

    ::std::string _szDeviceName;

    T_e8_DeviceCategory _enDeviceCategory;

    ::std::string _szDeviceModelName;

    ::std::string _szDeviceManufacturerName;

    T_e8_DeviceConnectionStatus _enDeviceConnectionStatus;

    T_e8_DeviceConnectionType _enDeviceConnectionType;

    T_VersionInfo _rVersionInfo;

    T_e8_EnabledInfo _enDeviceUsageEnabled;

    bool _bSelectedDevice;

    bool _bDAPSupport;

    T_ProjectionCapability _rProjectionCapability;

    ::std::string _szBTAddress;

    T_DeviceSelectionInfo _rDeviceSelectionInfo;

    ::std::string _szSerialNumber;

    T_e8_UserAuthorizationStatus _enUserAuthorizationStatus;

    T_e8_SessionTransportType _enSessionTransportType;

    uint32 _u32VendorID;

    uint32 _u32ProductID;

    ::std::string _szSystemPath;

};

/**
 * This structure provides Application Display Information
 */
class T_AppDisplayInfo {
public:

    /**
     * Default constructor
     */
    inline  T_AppDisplayInfo ();

    /**
     * Copy constructor
     */
    inline  T_AppDisplayInfo (const T_AppDisplayInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_AppDisplayInfo (T_e32_AppDisplayCategory enAppDisplayCategory_, T_e16_TrustLevel enTrustLevel_, uint32 u32AppDisplayRules_, const ::std::string& szAppDisplayOrientation_);

    /**
     * Destructor
     */
    inline  ~T_AppDisplayInfo();

    /**
     * Assignment operator
     */
    inline T_AppDisplayInfo& operator = (const T_AppDisplayInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AppDisplayInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AppDisplayInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AppDisplayInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AppDisplayInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enAppDisplayCategory"

    static const int kEnAppDisplayCategory = 0;

    /**
     * Clears the field "enAppDisplayCategory".
     *
     * The field will be set to its default value. The hasEnAppDisplayCategory()
     * method will return false.
     */
    inline void clearEnAppDisplayCategory();

    /**
     * Checks whether the field "enAppDisplayCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnAppDisplayCategory()). Otherwise it will return false.
     */
    inline bool hasEnAppDisplayCategory () const;

    /**
     * Returns the value of the member "enAppDisplayCategory".
     *
     * Indicates the Application Display Content Category
     *
     * @return The value of the field "enAppDisplayCategory"
     */
    inline T_e32_AppDisplayCategory getEnAppDisplayCategory () const;

    /**
     * Sets the value of the member "enAppDisplayCategory".
     *
     * Indicates the Application Display Content Category
     *
     * @param enAppDisplayCategory The value which will be set
     */
    inline void setEnAppDisplayCategory (T_e32_AppDisplayCategory enAppDisplayCategory_);

    // API of field "enTrustLevel"

    static const int kEnTrustLevel = 1;

    /**
     * Clears the field "enTrustLevel".
     *
     * The field will be set to its default value. The hasEnTrustLevel()
     * method will return false.
     */
    inline void clearEnTrustLevel();

    /**
     * Checks whether the field "enTrustLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnTrustLevel()). Otherwise it will return false.
     */
    inline bool hasEnTrustLevel () const;

    /**
     * Returns the value of the member "enTrustLevel".
     *
     * Indicates the Application Display Content Trust Level
     *
     * @return The value of the field "enTrustLevel"
     */
    inline T_e16_TrustLevel getEnTrustLevel () const;

    /**
     * Sets the value of the member "enTrustLevel".
     *
     * Indicates the Application Display Content Trust Level
     *
     * @param enTrustLevel The value which will be set
     */
    inline void setEnTrustLevel (T_e16_TrustLevel enTrustLevel_);

    // API of field "u32AppDisplayRules"

    static const int kU32AppDisplayRules = 2;

    /**
     * Clears the field "u32AppDisplayRules".
     *
     * The field will be set to its default value. The hasU32AppDisplayRules()
     * method will return false.
     */
    inline void clearU32AppDisplayRules();

    /**
     * Checks whether the field "u32AppDisplayRules" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AppDisplayRules()). Otherwise it will return false.
     */
    inline bool hasU32AppDisplayRules () const;

    /**
     * Returns the value of the member "u32AppDisplayRules".
     *
     * Indicates the Application Display Content Rules
     *
     * @return The value of the field "u32AppDisplayRules"
     */
    inline uint32 getU32AppDisplayRules () const;

    /**
     * Sets the value of the member "u32AppDisplayRules".
     *
     * Indicates the Application Display Content Rules
     *
     * @param u32AppDisplayRules The value which will be set
     */
    inline void setU32AppDisplayRules (uint32 u32AppDisplayRules_);

    // API of field "szAppDisplayOrientation"

    static const int kSzAppDisplayOrientation = 3;

    /**
     * Clears the field "szAppDisplayOrientation".
     *
     * The field will be set to its default value. The hasSzAppDisplayOrientation()
     * method will return false.
     */
    inline void clearSzAppDisplayOrientation();

    /**
     * Checks whether the field "szAppDisplayOrientation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppDisplayOrientation()). Otherwise it will return false.
     */
    inline bool hasSzAppDisplayOrientation () const;

    /**
     * Returns the value of the member "szAppDisplayOrientation".
     *
     * Indicates the Application Display Content Orientation
     *
     * @return The value of the field "szAppDisplayOrientation"
     */
    inline const ::std::string& getSzAppDisplayOrientation () const;

    /**
     * Retrieves the value of the field "szAppDisplayOrientation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppDisplayOrientation".
     */
    inline ::std::string& getSzAppDisplayOrientationMutable ();

    /**
     * Sets the value of the member "szAppDisplayOrientation".
     *
     * Indicates the Application Display Content Orientation
     *
     * @param szAppDisplayOrientation The value which will be set
     */
    inline void setSzAppDisplayOrientation (const ::std::string& szAppDisplayOrientation_);

    /**
     * Sets the value of the member "szAppDisplayOrientation".
     *
     * Indicates the Application Display Content Orientation
     *
     * @param szAppDisplayOrientation The value which will be set
     */
    inline void setSzAppDisplayOrientation (const char* szAppDisplayOrientation_);

    /**
     * Sets the value of the member "szAppDisplayOrientation".
     *
     * Indicates the Application Display Content Orientation
     *
     * @param szAppDisplayOrientation The value which will be set
     */
    inline void setSzAppDisplayOrientation (const char* value, size_t size);

    static const T_AppDisplayInfo &getDefaultInstance();

private:

    inline void set_has_enAppDisplayCategory ();

    inline void clear_has_enAppDisplayCategory ();

    inline void set_has_enTrustLevel ();

    inline void clear_has_enTrustLevel ();

    inline void set_has_u32AppDisplayRules ();

    inline void clear_has_u32AppDisplayRules ();

    inline void set_has_szAppDisplayOrientation ();

    inline void clear_has_szAppDisplayOrientation ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e32_AppDisplayCategory _enAppDisplayCategory;

    T_e16_TrustLevel _enTrustLevel;

    uint32 _u32AppDisplayRules;

    ::std::string _szAppDisplayOrientation;

};

/**
 * This structure provides Application Audio Information
 */
class T_AppAudioInfo {
public:

    /**
     * Default constructor
     */
    inline  T_AppAudioInfo ();

    /**
     * Copy constructor
     */
    inline  T_AppAudioInfo (const T_AppAudioInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_AppAudioInfo (const ::std::string& szAppAudioType_, T_e32_AppAudioCategory enAppAudioCategory_, T_e16_TrustLevel enTrustLevel_, uint32 u32AppAudioRules_);

    /**
     * Destructor
     */
    inline  ~T_AppAudioInfo();

    /**
     * Assignment operator
     */
    inline T_AppAudioInfo& operator = (const T_AppAudioInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AppAudioInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AppAudioInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AppAudioInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AppAudioInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szAppAudioType"

    static const int kSzAppAudioType = 0;

    /**
     * Clears the field "szAppAudioType".
     *
     * The field will be set to its default value. The hasSzAppAudioType()
     * method will return false.
     */
    inline void clearSzAppAudioType();

    /**
     * Checks whether the field "szAppAudioType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppAudioType()). Otherwise it will return false.
     */
    inline bool hasSzAppAudioType () const;

    /**
     * Returns the value of the member "szAppAudioType".
     *
     * Indicates the Application Audio Content Type
     *
     * @return The value of the field "szAppAudioType"
     */
    inline const ::std::string& getSzAppAudioType () const;

    /**
     * Retrieves the value of the field "szAppAudioType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppAudioType".
     */
    inline ::std::string& getSzAppAudioTypeMutable ();

    /**
     * Sets the value of the member "szAppAudioType".
     *
     * Indicates the Application Audio Content Type
     *
     * @param szAppAudioType The value which will be set
     */
    inline void setSzAppAudioType (const ::std::string& szAppAudioType_);

    /**
     * Sets the value of the member "szAppAudioType".
     *
     * Indicates the Application Audio Content Type
     *
     * @param szAppAudioType The value which will be set
     */
    inline void setSzAppAudioType (const char* szAppAudioType_);

    /**
     * Sets the value of the member "szAppAudioType".
     *
     * Indicates the Application Audio Content Type
     *
     * @param szAppAudioType The value which will be set
     */
    inline void setSzAppAudioType (const char* value, size_t size);

    // API of field "enAppAudioCategory"

    static const int kEnAppAudioCategory = 1;

    /**
     * Clears the field "enAppAudioCategory".
     *
     * The field will be set to its default value. The hasEnAppAudioCategory()
     * method will return false.
     */
    inline void clearEnAppAudioCategory();

    /**
     * Checks whether the field "enAppAudioCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnAppAudioCategory()). Otherwise it will return false.
     */
    inline bool hasEnAppAudioCategory () const;

    /**
     * Returns the value of the member "enAppAudioCategory".
     *
     * Indicates the Application Audio Content Category
     *
     * @return The value of the field "enAppAudioCategory"
     */
    inline T_e32_AppAudioCategory getEnAppAudioCategory () const;

    /**
     * Sets the value of the member "enAppAudioCategory".
     *
     * Indicates the Application Audio Content Category
     *
     * @param enAppAudioCategory The value which will be set
     */
    inline void setEnAppAudioCategory (T_e32_AppAudioCategory enAppAudioCategory_);

    // API of field "enTrustLevel"

    static const int kEnTrustLevel = 2;

    /**
     * Clears the field "enTrustLevel".
     *
     * The field will be set to its default value. The hasEnTrustLevel()
     * method will return false.
     */
    inline void clearEnTrustLevel();

    /**
     * Checks whether the field "enTrustLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnTrustLevel()). Otherwise it will return false.
     */
    inline bool hasEnTrustLevel () const;

    /**
     * Returns the value of the member "enTrustLevel".
     *
     * Indicates the Application Display Content Trust Level
     *
     * @return The value of the field "enTrustLevel"
     */
    inline T_e16_TrustLevel getEnTrustLevel () const;

    /**
     * Sets the value of the member "enTrustLevel".
     *
     * Indicates the Application Display Content Trust Level
     *
     * @param enTrustLevel The value which will be set
     */
    inline void setEnTrustLevel (T_e16_TrustLevel enTrustLevel_);

    // API of field "u32AppAudioRules"

    static const int kU32AppAudioRules = 3;

    /**
     * Clears the field "u32AppAudioRules".
     *
     * The field will be set to its default value. The hasU32AppAudioRules()
     * method will return false.
     */
    inline void clearU32AppAudioRules();

    /**
     * Checks whether the field "u32AppAudioRules" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AppAudioRules()). Otherwise it will return false.
     */
    inline bool hasU32AppAudioRules () const;

    /**
     * Returns the value of the member "u32AppAudioRules".
     *
     * Indicates the Application Audio Content Rules
     *
     * @return The value of the field "u32AppAudioRules"
     */
    inline uint32 getU32AppAudioRules () const;

    /**
     * Sets the value of the member "u32AppAudioRules".
     *
     * Indicates the Application Audio Content Rules
     *
     * @param u32AppAudioRules The value which will be set
     */
    inline void setU32AppAudioRules (uint32 u32AppAudioRules_);

    static const T_AppAudioInfo &getDefaultInstance();

private:

    inline void set_has_szAppAudioType ();

    inline void clear_has_szAppAudioType ();

    inline void set_has_enAppAudioCategory ();

    inline void clear_has_enAppAudioCategory ();

    inline void set_has_enTrustLevel ();

    inline void clear_has_enTrustLevel ();

    inline void set_has_u32AppAudioRules ();

    inline void clear_has_u32AppAudioRules ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _szAppAudioType;

    T_e32_AppAudioCategory _enAppAudioCategory;

    T_e16_TrustLevel _enTrustLevel;

    uint32 _u32AppAudioRules;

};

/**
 * This structure provides information about the Remoting Info used to interact with the application after it is launched
 */
class T_AppRemotingInfo {
public:

    /**
     * Default constructor
     */
    inline  T_AppRemotingInfo ();

    /**
     * Copy constructor
     */
    inline  T_AppRemotingInfo (const T_AppRemotingInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_AppRemotingInfo (const ::std::string& szRemotingProtocolID_, const ::std::string& szRemotingFormat_, const ::std::string& szRemotingDirection_, uint32 u32RemotingAudioIPL_, uint32 u32RemotingAudioMPL_);

    /**
     * Destructor
     */
    inline  ~T_AppRemotingInfo();

    /**
     * Assignment operator
     */
    inline T_AppRemotingInfo& operator = (const T_AppRemotingInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AppRemotingInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AppRemotingInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AppRemotingInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AppRemotingInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szRemotingProtocolID"

    static const int kSzRemotingProtocolID = 0;

    /**
     * Clears the field "szRemotingProtocolID".
     *
     * The field will be set to its default value. The hasSzRemotingProtocolID()
     * method will return false.
     */
    inline void clearSzRemotingProtocolID();

    /**
     * Checks whether the field "szRemotingProtocolID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzRemotingProtocolID()). Otherwise it will return false.
     */
    inline bool hasSzRemotingProtocolID () const;

    /**
     * Returns the value of the member "szRemotingProtocolID".
     *
     * Indicates Protocol Identifier of the Remoting protocol that will be used to access the application
     *
     * @return The value of the field "szRemotingProtocolID"
     */
    inline const ::std::string& getSzRemotingProtocolID () const;

    /**
     * Retrieves the value of the field "szRemotingProtocolID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szRemotingProtocolID".
     */
    inline ::std::string& getSzRemotingProtocolIDMutable ();

    /**
     * Sets the value of the member "szRemotingProtocolID".
     *
     * Indicates Protocol Identifier of the Remoting protocol that will be used to access the application
     *
     * @param szRemotingProtocolID The value which will be set
     */
    inline void setSzRemotingProtocolID (const ::std::string& szRemotingProtocolID_);

    /**
     * Sets the value of the member "szRemotingProtocolID".
     *
     * Indicates Protocol Identifier of the Remoting protocol that will be used to access the application
     *
     * @param szRemotingProtocolID The value which will be set
     */
    inline void setSzRemotingProtocolID (const char* szRemotingProtocolID_);

    /**
     * Sets the value of the member "szRemotingProtocolID".
     *
     * Indicates Protocol Identifier of the Remoting protocol that will be used to access the application
     *
     * @param szRemotingProtocolID The value which will be set
     */
    inline void setSzRemotingProtocolID (const char* value, size_t size);

    // API of field "szRemotingFormat"

    static const int kSzRemotingFormat = 1;

    /**
     * Clears the field "szRemotingFormat".
     *
     * The field will be set to its default value. The hasSzRemotingFormat()
     * method will return false.
     */
    inline void clearSzRemotingFormat();

    /**
     * Checks whether the field "szRemotingFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzRemotingFormat()). Otherwise it will return false.
     */
    inline bool hasSzRemotingFormat () const;

    /**
     * Returns the value of the member "szRemotingFormat".
     *
     * Indicates Format of the data being transferred using the Remoting Protocol
     *
     * @return The value of the field "szRemotingFormat"
     */
    inline const ::std::string& getSzRemotingFormat () const;

    /**
     * Retrieves the value of the field "szRemotingFormat" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szRemotingFormat".
     */
    inline ::std::string& getSzRemotingFormatMutable ();

    /**
     * Sets the value of the member "szRemotingFormat".
     *
     * Indicates Format of the data being transferred using the Remoting Protocol
     *
     * @param szRemotingFormat The value which will be set
     */
    inline void setSzRemotingFormat (const ::std::string& szRemotingFormat_);

    /**
     * Sets the value of the member "szRemotingFormat".
     *
     * Indicates Format of the data being transferred using the Remoting Protocol
     *
     * @param szRemotingFormat The value which will be set
     */
    inline void setSzRemotingFormat (const char* szRemotingFormat_);

    /**
     * Sets the value of the member "szRemotingFormat".
     *
     * Indicates Format of the data being transferred using the Remoting Protocol
     *
     * @param szRemotingFormat The value which will be set
     */
    inline void setSzRemotingFormat (const char* value, size_t size);

    // API of field "szRemotingDirection"

    static const int kSzRemotingDirection = 2;

    /**
     * Clears the field "szRemotingDirection".
     *
     * The field will be set to its default value. The hasSzRemotingDirection()
     * method will return false.
     */
    inline void clearSzRemotingDirection();

    /**
     * Checks whether the field "szRemotingDirection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzRemotingDirection()). Otherwise it will return false.
     */
    inline bool hasSzRemotingDirection () const;

    /**
     * Returns the value of the member "szRemotingDirection".
     *
     * Indicates Direction of the content stream
     *
     * @return The value of the field "szRemotingDirection"
     */
    inline const ::std::string& getSzRemotingDirection () const;

    /**
     * Retrieves the value of the field "szRemotingDirection" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szRemotingDirection".
     */
    inline ::std::string& getSzRemotingDirectionMutable ();

    /**
     * Sets the value of the member "szRemotingDirection".
     *
     * Indicates Direction of the content stream
     *
     * @param szRemotingDirection The value which will be set
     */
    inline void setSzRemotingDirection (const ::std::string& szRemotingDirection_);

    /**
     * Sets the value of the member "szRemotingDirection".
     *
     * Indicates Direction of the content stream
     *
     * @param szRemotingDirection The value which will be set
     */
    inline void setSzRemotingDirection (const char* szRemotingDirection_);

    /**
     * Sets the value of the member "szRemotingDirection".
     *
     * Indicates Direction of the content stream
     *
     * @param szRemotingDirection The value which will be set
     */
    inline void setSzRemotingDirection (const char* value, size_t size);

    // API of field "u32RemotingAudioIPL"

    static const int kU32RemotingAudioIPL = 3;

    /**
     * Clears the field "u32RemotingAudioIPL".
     *
     * The field will be set to its default value. The hasU32RemotingAudioIPL()
     * method will return false.
     */
    inline void clearU32RemotingAudioIPL();

    /**
     * Checks whether the field "u32RemotingAudioIPL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32RemotingAudioIPL()). Otherwise it will return false.
     */
    inline bool hasU32RemotingAudioIPL () const;

    /**
     * Returns the value of the member "u32RemotingAudioIPL".
     *
     * Indicates Audio Initial Playback Latency
     *
     * @return The value of the field "u32RemotingAudioIPL"
     */
    inline uint32 getU32RemotingAudioIPL () const;

    /**
     * Sets the value of the member "u32RemotingAudioIPL".
     *
     * Indicates Audio Initial Playback Latency
     *
     * @param u32RemotingAudioIPL The value which will be set
     */
    inline void setU32RemotingAudioIPL (uint32 u32RemotingAudioIPL_);

    // API of field "u32RemotingAudioMPL"

    static const int kU32RemotingAudioMPL = 4;

    /**
     * Clears the field "u32RemotingAudioMPL".
     *
     * The field will be set to its default value. The hasU32RemotingAudioMPL()
     * method will return false.
     */
    inline void clearU32RemotingAudioMPL();

    /**
     * Checks whether the field "u32RemotingAudioMPL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32RemotingAudioMPL()). Otherwise it will return false.
     */
    inline bool hasU32RemotingAudioMPL () const;

    /**
     * Returns the value of the member "u32RemotingAudioMPL".
     *
     * Indicates Audio Maximum Playback Latency
     *
     * @return The value of the field "u32RemotingAudioMPL"
     */
    inline uint32 getU32RemotingAudioMPL () const;

    /**
     * Sets the value of the member "u32RemotingAudioMPL".
     *
     * Indicates Audio Maximum Playback Latency
     *
     * @param u32RemotingAudioMPL The value which will be set
     */
    inline void setU32RemotingAudioMPL (uint32 u32RemotingAudioMPL_);

    static const T_AppRemotingInfo &getDefaultInstance();

private:

    inline void set_has_szRemotingProtocolID ();

    inline void clear_has_szRemotingProtocolID ();

    inline void set_has_szRemotingFormat ();

    inline void clear_has_szRemotingFormat ();

    inline void set_has_szRemotingDirection ();

    inline void clear_has_szRemotingDirection ();

    inline void set_has_u32RemotingAudioIPL ();

    inline void clear_has_u32RemotingAudioIPL ();

    inline void set_has_u32RemotingAudioMPL ();

    inline void clear_has_u32RemotingAudioMPL ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _szRemotingProtocolID;

    ::std::string _szRemotingFormat;

    ::std::string _szRemotingDirection;

    uint32 _u32RemotingAudioIPL;

    uint32 _u32RemotingAudioMPL;

};

/**
 * This structure contains Icon attributes.
 */
class T_IconAttributes {
public:

    /**
     * Default constructor
     */
    inline  T_IconAttributes ();

    /**
     * Copy constructor
     */
    inline  T_IconAttributes (const T_IconAttributes &rhs);

    /**
     * All fields constructor
     */
    inline  T_IconAttributes (uint32 u32IconWidth_, uint32 u32IconHeight_, uint32 u32IconDepth_, T_e8_IconMimeType enIconMimeType_, const ::std::string& szIconURL_);

    /**
     * Destructor
     */
    inline  ~T_IconAttributes();

    /**
     * Assignment operator
     */
    inline T_IconAttributes& operator = (const T_IconAttributes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_IconAttributes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_IconAttributes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_IconAttributes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_IconAttributes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32IconWidth"

    static const int kU32IconWidth = 0;

    /**
     * Clears the field "u32IconWidth".
     *
     * The field will be set to its default value. The hasU32IconWidth()
     * method will return false.
     */
    inline void clearU32IconWidth();

    /**
     * Checks whether the field "u32IconWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32IconWidth()). Otherwise it will return false.
     */
    inline bool hasU32IconWidth () const;

    /**
     * Returns the value of the member "u32IconWidth".
     *
     * Indicates Width of the icon
     *
     * @return The value of the field "u32IconWidth"
     */
    inline uint32 getU32IconWidth () const;

    /**
     * Sets the value of the member "u32IconWidth".
     *
     * Indicates Width of the icon
     *
     * @param u32IconWidth The value which will be set
     */
    inline void setU32IconWidth (uint32 u32IconWidth_);

    // API of field "u32IconHeight"

    static const int kU32IconHeight = 1;

    /**
     * Clears the field "u32IconHeight".
     *
     * The field will be set to its default value. The hasU32IconHeight()
     * method will return false.
     */
    inline void clearU32IconHeight();

    /**
     * Checks whether the field "u32IconHeight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32IconHeight()). Otherwise it will return false.
     */
    inline bool hasU32IconHeight () const;

    /**
     * Returns the value of the member "u32IconHeight".
     *
     * Indicates Height of the icon
     *
     * @return The value of the field "u32IconHeight"
     */
    inline uint32 getU32IconHeight () const;

    /**
     * Sets the value of the member "u32IconHeight".
     *
     * Indicates Height of the icon
     *
     * @param u32IconHeight The value which will be set
     */
    inline void setU32IconHeight (uint32 u32IconHeight_);

    // API of field "u32IconDepth"

    static const int kU32IconDepth = 2;

    /**
     * Clears the field "u32IconDepth".
     *
     * The field will be set to its default value. The hasU32IconDepth()
     * method will return false.
     */
    inline void clearU32IconDepth();

    /**
     * Checks whether the field "u32IconDepth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32IconDepth()). Otherwise it will return false.
     */
    inline bool hasU32IconDepth () const;

    /**
     * Returns the value of the member "u32IconDepth".
     *
     * Indicates Depth of the icon
     *
     * @return The value of the field "u32IconDepth"
     */
    inline uint32 getU32IconDepth () const;

    /**
     * Sets the value of the member "u32IconDepth".
     *
     * Indicates Depth of the icon
     *
     * @param u32IconDepth The value which will be set
     */
    inline void setU32IconDepth (uint32 u32IconDepth_);

    // API of field "enIconMimeType"

    static const int kEnIconMimeType = 3;

    /**
     * Clears the field "enIconMimeType".
     *
     * The field will be set to its default value. The hasEnIconMimeType()
     * method will return false.
     */
    inline void clearEnIconMimeType();

    /**
     * Checks whether the field "enIconMimeType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnIconMimeType()). Otherwise it will return false.
     */
    inline bool hasEnIconMimeType () const;

    /**
     * Returns the value of the member "enIconMimeType".
     *
     * Indicates Mime Type of the icon
     *
     * @return The value of the field "enIconMimeType"
     */
    inline T_e8_IconMimeType getEnIconMimeType () const;

    /**
     * Sets the value of the member "enIconMimeType".
     *
     * Indicates Mime Type of the icon
     *
     * @param enIconMimeType The value which will be set
     */
    inline void setEnIconMimeType (T_e8_IconMimeType enIconMimeType_);

    // API of field "szIconURL"

    static const int kSzIconURL = 4;

    /**
     * Clears the field "szIconURL".
     *
     * The field will be set to its default value. The hasSzIconURL()
     * method will return false.
     */
    inline void clearSzIconURL();

    /**
     * Checks whether the field "szIconURL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzIconURL()). Otherwise it will return false.
     */
    inline bool hasSzIconURL () const;

    /**
     * Returns the value of the member "szIconURL".
     *
     * Indicates URL of the icon. Data for the icon can be retrieved via GetApplicationIcon Interface
     *
     * @return The value of the field "szIconURL"
     */
    inline const ::std::string& getSzIconURL () const;

    /**
     * Retrieves the value of the field "szIconURL" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szIconURL".
     */
    inline ::std::string& getSzIconURLMutable ();

    /**
     * Sets the value of the member "szIconURL".
     *
     * Indicates URL of the icon. Data for the icon can be retrieved via GetApplicationIcon Interface
     *
     * @param szIconURL The value which will be set
     */
    inline void setSzIconURL (const ::std::string& szIconURL_);

    /**
     * Sets the value of the member "szIconURL".
     *
     * Indicates URL of the icon. Data for the icon can be retrieved via GetApplicationIcon Interface
     *
     * @param szIconURL The value which will be set
     */
    inline void setSzIconURL (const char* szIconURL_);

    /**
     * Sets the value of the member "szIconURL".
     *
     * Indicates URL of the icon. Data for the icon can be retrieved via GetApplicationIcon Interface
     *
     * @param szIconURL The value which will be set
     */
    inline void setSzIconURL (const char* value, size_t size);

    static const T_IconAttributes &getDefaultInstance();

private:

    inline void set_has_u32IconWidth ();

    inline void clear_has_u32IconWidth ();

    inline void set_has_u32IconHeight ();

    inline void clear_has_u32IconHeight ();

    inline void set_has_u32IconDepth ();

    inline void clear_has_u32IconDepth ();

    inline void set_has_enIconMimeType ();

    inline void clear_has_enIconMimeType ();

    inline void set_has_szIconURL ();

    inline void clear_has_szIconURL ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _u32IconWidth;

    uint32 _u32IconHeight;

    uint32 _u32IconDepth;

    T_e8_IconMimeType _enIconMimeType;

    ::std::string _szIconURL;

};

/**
 * This structure provides detailed application information
 */
class T_AppDetails {
public:

    /**
     * Default constructor
     */
    inline  T_AppDetails ();

    /**
     * Copy constructor
     */
    inline  T_AppDetails (const T_AppDetails &rhs);

    /**
     * All fields constructor
     */
    inline  T_AppDetails (uint32 u32AppHandle_, const ::std::string& szAppName_, T_e8_AppStatus enAppStatus_, const ::std::string& szAppVariant_, const ::std::string& szAppProviderName_, const ::std::string& szAppProviderURL_, const ::std::string& szAppDescription_, const ::std::vector< ::std::string >& AppAllowedProfiles_, const ::std::string& szAppCertificateURL_, T_e32_AppCategory enAppCategory_, T_e16_TrustLevel enTrustLevel_, T_e8_AppCertificationInfo e8AppCertificationInfo_, const T_AppDisplayInfo& rAppDisplayInfo_, const T_AppAudioInfo& rAppAudioInfo_, const T_AppRemotingInfo& rAppRemotingInfo_, uint16 u16NumAppIcons_, const ::std::vector< T_IconAttributes >& AppIconList_, T_e8_AppCertificationEntity e8AppCertificationEntity_);

    /**
     * Destructor
     */
    inline  ~T_AppDetails();

    /**
     * Assignment operator
     */
    inline T_AppDetails& operator = (const T_AppDetails& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AppDetails& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AppDetails& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AppDetails& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AppDetails& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32AppHandle"

    static const int kU32AppHandle = 0;

    /**
     * Clears the field "u32AppHandle".
     *
     * The field will be set to its default value. The hasU32AppHandle()
     * method will return false.
     */
    inline void clearU32AppHandle();

    /**
     * Checks whether the field "u32AppHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AppHandle()). Otherwise it will return false.
     */
    inline bool hasU32AppHandle () const;

    /**
     * Returns the value of the member "u32AppHandle".
     *
     * Indicates the Unique application identifier on the device
     *
     * @return The value of the field "u32AppHandle"
     */
    inline uint32 getU32AppHandle () const;

    /**
     * Sets the value of the member "u32AppHandle".
     *
     * Indicates the Unique application identifier on the device
     *
     * @param u32AppHandle The value which will be set
     */
    inline void setU32AppHandle (uint32 u32AppHandle_);

    // API of field "szAppName"

    static const int kSzAppName = 1;

    /**
     * Clears the field "szAppName".
     *
     * The field will be set to its default value. The hasSzAppName()
     * method will return false.
     */
    inline void clearSzAppName();

    /**
     * Checks whether the field "szAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppName()). Otherwise it will return false.
     */
    inline bool hasSzAppName () const;

    /**
     * Returns the value of the member "szAppName".
     *
     * Indicates the Name of the application
     *
     * @return The value of the field "szAppName"
     */
    inline const ::std::string& getSzAppName () const;

    /**
     * Retrieves the value of the field "szAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppName".
     */
    inline ::std::string& getSzAppNameMutable ();

    /**
     * Sets the value of the member "szAppName".
     *
     * Indicates the Name of the application
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const ::std::string& szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * Indicates the Name of the application
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * Indicates the Name of the application
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* value, size_t size);

    // API of field "enAppStatus"

    static const int kEnAppStatus = 2;

    /**
     * Clears the field "enAppStatus".
     *
     * The field will be set to its default value. The hasEnAppStatus()
     * method will return false.
     */
    inline void clearEnAppStatus();

    /**
     * Checks whether the field "enAppStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnAppStatus()). Otherwise it will return false.
     */
    inline bool hasEnAppStatus () const;

    /**
     * Returns the value of the member "enAppStatus".
     *
     * Indicates the Status of the application
     *
     * @return The value of the field "enAppStatus"
     */
    inline T_e8_AppStatus getEnAppStatus () const;

    /**
     * Sets the value of the member "enAppStatus".
     *
     * Indicates the Status of the application
     *
     * @param enAppStatus The value which will be set
     */
    inline void setEnAppStatus (T_e8_AppStatus enAppStatus_);

    // API of field "szAppVariant"

    static const int kSzAppVariant = 3;

    /**
     * Clears the field "szAppVariant".
     *
     * The field will be set to its default value. The hasSzAppVariant()
     * method will return false.
     */
    inline void clearSzAppVariant();

    /**
     * Checks whether the field "szAppVariant" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppVariant()). Otherwise it will return false.
     */
    inline bool hasSzAppVariant () const;

    /**
     * Returns the value of the member "szAppVariant".
     *
     * Indicates the Application Variant
     *
     * @return The value of the field "szAppVariant"
     */
    inline const ::std::string& getSzAppVariant () const;

    /**
     * Retrieves the value of the field "szAppVariant" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppVariant".
     */
    inline ::std::string& getSzAppVariantMutable ();

    /**
     * Sets the value of the member "szAppVariant".
     *
     * Indicates the Application Variant
     *
     * @param szAppVariant The value which will be set
     */
    inline void setSzAppVariant (const ::std::string& szAppVariant_);

    /**
     * Sets the value of the member "szAppVariant".
     *
     * Indicates the Application Variant
     *
     * @param szAppVariant The value which will be set
     */
    inline void setSzAppVariant (const char* szAppVariant_);

    /**
     * Sets the value of the member "szAppVariant".
     *
     * Indicates the Application Variant
     *
     * @param szAppVariant The value which will be set
     */
    inline void setSzAppVariant (const char* value, size_t size);

    // API of field "szAppProviderName"

    static const int kSzAppProviderName = 4;

    /**
     * Clears the field "szAppProviderName".
     *
     * The field will be set to its default value. The hasSzAppProviderName()
     * method will return false.
     */
    inline void clearSzAppProviderName();

    /**
     * Checks whether the field "szAppProviderName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppProviderName()). Otherwise it will return false.
     */
    inline bool hasSzAppProviderName () const;

    /**
     * Returns the value of the member "szAppProviderName".
     *
     * Indicates the Application Provider Name
     *
     * @return The value of the field "szAppProviderName"
     */
    inline const ::std::string& getSzAppProviderName () const;

    /**
     * Retrieves the value of the field "szAppProviderName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppProviderName".
     */
    inline ::std::string& getSzAppProviderNameMutable ();

    /**
     * Sets the value of the member "szAppProviderName".
     *
     * Indicates the Application Provider Name
     *
     * @param szAppProviderName The value which will be set
     */
    inline void setSzAppProviderName (const ::std::string& szAppProviderName_);

    /**
     * Sets the value of the member "szAppProviderName".
     *
     * Indicates the Application Provider Name
     *
     * @param szAppProviderName The value which will be set
     */
    inline void setSzAppProviderName (const char* szAppProviderName_);

    /**
     * Sets the value of the member "szAppProviderName".
     *
     * Indicates the Application Provider Name
     *
     * @param szAppProviderName The value which will be set
     */
    inline void setSzAppProviderName (const char* value, size_t size);

    // API of field "szAppProviderURL"

    static const int kSzAppProviderURL = 5;

    /**
     * Clears the field "szAppProviderURL".
     *
     * The field will be set to its default value. The hasSzAppProviderURL()
     * method will return false.
     */
    inline void clearSzAppProviderURL();

    /**
     * Checks whether the field "szAppProviderURL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppProviderURL()). Otherwise it will return false.
     */
    inline bool hasSzAppProviderURL () const;

    /**
     * Returns the value of the member "szAppProviderURL".
     *
     * Indicates the Application Provider URL
     *
     * @return The value of the field "szAppProviderURL"
     */
    inline const ::std::string& getSzAppProviderURL () const;

    /**
     * Retrieves the value of the field "szAppProviderURL" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppProviderURL".
     */
    inline ::std::string& getSzAppProviderURLMutable ();

    /**
     * Sets the value of the member "szAppProviderURL".
     *
     * Indicates the Application Provider URL
     *
     * @param szAppProviderURL The value which will be set
     */
    inline void setSzAppProviderURL (const ::std::string& szAppProviderURL_);

    /**
     * Sets the value of the member "szAppProviderURL".
     *
     * Indicates the Application Provider URL
     *
     * @param szAppProviderURL The value which will be set
     */
    inline void setSzAppProviderURL (const char* szAppProviderURL_);

    /**
     * Sets the value of the member "szAppProviderURL".
     *
     * Indicates the Application Provider URL
     *
     * @param szAppProviderURL The value which will be set
     */
    inline void setSzAppProviderURL (const char* value, size_t size);

    // API of field "szAppDescription"

    static const int kSzAppDescription = 6;

    /**
     * Clears the field "szAppDescription".
     *
     * The field will be set to its default value. The hasSzAppDescription()
     * method will return false.
     */
    inline void clearSzAppDescription();

    /**
     * Checks whether the field "szAppDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppDescription()). Otherwise it will return false.
     */
    inline bool hasSzAppDescription () const;

    /**
     * Returns the value of the member "szAppDescription".
     *
     * Indicates the Application Description
     *
     * @return The value of the field "szAppDescription"
     */
    inline const ::std::string& getSzAppDescription () const;

    /**
     * Retrieves the value of the field "szAppDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppDescription".
     */
    inline ::std::string& getSzAppDescriptionMutable ();

    /**
     * Sets the value of the member "szAppDescription".
     *
     * Indicates the Application Description
     *
     * @param szAppDescription The value which will be set
     */
    inline void setSzAppDescription (const ::std::string& szAppDescription_);

    /**
     * Sets the value of the member "szAppDescription".
     *
     * Indicates the Application Description
     *
     * @param szAppDescription The value which will be set
     */
    inline void setSzAppDescription (const char* szAppDescription_);

    /**
     * Sets the value of the member "szAppDescription".
     *
     * Indicates the Application Description
     *
     * @param szAppDescription The value which will be set
     */
    inline void setSzAppDescription (const char* value, size_t size);

    // API of field "AppAllowedProfiles"

    static const int kAppAllowedProfiles = 7;

    /**
     * Clears the field "AppAllowedProfiles".
     *
     * The field will be set to its default value. The hasAppAllowedProfiles()
     * method will return false.
     */
    inline void clearAppAllowedProfiles();

    /**
     * Checks whether the field "AppAllowedProfiles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppAllowedProfiles()). Otherwise it will return false.
     */
    inline bool hasAppAllowedProfiles () const;

    /**
     * Returns the value of the member "AppAllowedProfiles".
     *
     * Indicates the Allowed Profiles for the application
     *
     * @return The value of the field "AppAllowedProfiles"
     */
    inline const ::std::vector< ::std::string >& getAppAllowedProfiles () const;

    /**
     * Retrieves the value of the field "AppAllowedProfiles" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AppAllowedProfiles".
     */
    inline ::std::vector< ::std::string >& getAppAllowedProfilesMutable ();

    /**
     * Sets the value of the member "AppAllowedProfiles".
     *
     * Indicates the Allowed Profiles for the application
     *
     * @param AppAllowedProfiles The value which will be set
     */
    inline void setAppAllowedProfiles (const ::std::vector< ::std::string >& AppAllowedProfiles_);

    // API of field "szAppCertificateURL"

    static const int kSzAppCertificateURL = 8;

    /**
     * Clears the field "szAppCertificateURL".
     *
     * The field will be set to its default value. The hasSzAppCertificateURL()
     * method will return false.
     */
    inline void clearSzAppCertificateURL();

    /**
     * Checks whether the field "szAppCertificateURL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppCertificateURL()). Otherwise it will return false.
     */
    inline bool hasSzAppCertificateURL () const;

    /**
     * Returns the value of the member "szAppCertificateURL".
     *
     * Indicates the URL of application certificate
     *
     * @return The value of the field "szAppCertificateURL"
     */
    inline const ::std::string& getSzAppCertificateURL () const;

    /**
     * Retrieves the value of the field "szAppCertificateURL" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppCertificateURL".
     */
    inline ::std::string& getSzAppCertificateURLMutable ();

    /**
     * Sets the value of the member "szAppCertificateURL".
     *
     * Indicates the URL of application certificate
     *
     * @param szAppCertificateURL The value which will be set
     */
    inline void setSzAppCertificateURL (const ::std::string& szAppCertificateURL_);

    /**
     * Sets the value of the member "szAppCertificateURL".
     *
     * Indicates the URL of application certificate
     *
     * @param szAppCertificateURL The value which will be set
     */
    inline void setSzAppCertificateURL (const char* szAppCertificateURL_);

    /**
     * Sets the value of the member "szAppCertificateURL".
     *
     * Indicates the URL of application certificate
     *
     * @param szAppCertificateURL The value which will be set
     */
    inline void setSzAppCertificateURL (const char* value, size_t size);

    // API of field "enAppCategory"

    static const int kEnAppCategory = 9;

    /**
     * Clears the field "enAppCategory".
     *
     * The field will be set to its default value. The hasEnAppCategory()
     * method will return false.
     */
    inline void clearEnAppCategory();

    /**
     * Checks whether the field "enAppCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnAppCategory()). Otherwise it will return false.
     */
    inline bool hasEnAppCategory () const;

    /**
     * Returns the value of the member "enAppCategory".
     *
     * Indicates the Application Category
     *
     * @return The value of the field "enAppCategory"
     */
    inline T_e32_AppCategory getEnAppCategory () const;

    /**
     * Sets the value of the member "enAppCategory".
     *
     * Indicates the Application Category
     *
     * @param enAppCategory The value which will be set
     */
    inline void setEnAppCategory (T_e32_AppCategory enAppCategory_);

    // API of field "enTrustLevel"

    static const int kEnTrustLevel = 10;

    /**
     * Clears the field "enTrustLevel".
     *
     * The field will be set to its default value. The hasEnTrustLevel()
     * method will return false.
     */
    inline void clearEnTrustLevel();

    /**
     * Checks whether the field "enTrustLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnTrustLevel()). Otherwise it will return false.
     */
    inline bool hasEnTrustLevel () const;

    /**
     * Returns the value of the member "enTrustLevel".
     *
     * Indicates the Application Trust Level
     *
     * @return The value of the field "enTrustLevel"
     */
    inline T_e16_TrustLevel getEnTrustLevel () const;

    /**
     * Sets the value of the member "enTrustLevel".
     *
     * Indicates the Application Trust Level
     *
     * @param enTrustLevel The value which will be set
     */
    inline void setEnTrustLevel (T_e16_TrustLevel enTrustLevel_);

    // API of field "e8AppCertificationInfo"

    static const int kE8AppCertificationInfo = 11;

    /**
     * Clears the field "e8AppCertificationInfo".
     *
     * The field will be set to its default value. The hasE8AppCertificationInfo()
     * method will return false.
     */
    inline void clearE8AppCertificationInfo();

    /**
     * Checks whether the field "e8AppCertificationInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AppCertificationInfo()). Otherwise it will return false.
     */
    inline bool hasE8AppCertificationInfo () const;

    /**
     * Returns the value of the member "e8AppCertificationInfo".
     *
     * Indicates the Application Certification type to use in park or drive mode
     *
     * @return The value of the field "e8AppCertificationInfo"
     */
    inline T_e8_AppCertificationInfo getE8AppCertificationInfo () const;

    /**
     * Sets the value of the member "e8AppCertificationInfo".
     *
     * Indicates the Application Certification type to use in park or drive mode
     *
     * @param e8AppCertificationInfo The value which will be set
     */
    inline void setE8AppCertificationInfo (T_e8_AppCertificationInfo e8AppCertificationInfo_);

    // API of field "rAppDisplayInfo"

    static const int kRAppDisplayInfo = 12;

    /**
     * Clears the field "rAppDisplayInfo".
     *
     * The field will be set to its default value. The hasRAppDisplayInfo()
     * method will return false.
     */
    inline void clearRAppDisplayInfo();

    /**
     * Checks whether the field "rAppDisplayInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRAppDisplayInfo()). Otherwise it will return false.
     */
    inline bool hasRAppDisplayInfo () const;

    /**
     * Returns the value of the member "rAppDisplayInfo".
     *
     * Indicates the Application Display Information
     *
     * @return The value of the field "rAppDisplayInfo"
     */
    inline const T_AppDisplayInfo& getRAppDisplayInfo () const;

    /**
     * Retrieves the value of the field "rAppDisplayInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rAppDisplayInfo".
     */
    inline T_AppDisplayInfo& getRAppDisplayInfoMutable ();

    /**
     * Sets the value of the member "rAppDisplayInfo".
     *
     * Indicates the Application Display Information
     *
     * @param rAppDisplayInfo The value which will be set
     */
    inline void setRAppDisplayInfo (const T_AppDisplayInfo& rAppDisplayInfo_);

    // API of field "rAppAudioInfo"

    static const int kRAppAudioInfo = 13;

    /**
     * Clears the field "rAppAudioInfo".
     *
     * The field will be set to its default value. The hasRAppAudioInfo()
     * method will return false.
     */
    inline void clearRAppAudioInfo();

    /**
     * Checks whether the field "rAppAudioInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRAppAudioInfo()). Otherwise it will return false.
     */
    inline bool hasRAppAudioInfo () const;

    /**
     * Returns the value of the member "rAppAudioInfo".
     *
     * Indicates the Application Audio Information
     *
     * @return The value of the field "rAppAudioInfo"
     */
    inline const T_AppAudioInfo& getRAppAudioInfo () const;

    /**
     * Retrieves the value of the field "rAppAudioInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rAppAudioInfo".
     */
    inline T_AppAudioInfo& getRAppAudioInfoMutable ();

    /**
     * Sets the value of the member "rAppAudioInfo".
     *
     * Indicates the Application Audio Information
     *
     * @param rAppAudioInfo The value which will be set
     */
    inline void setRAppAudioInfo (const T_AppAudioInfo& rAppAudioInfo_);

    // API of field "rAppRemotingInfo"

    static const int kRAppRemotingInfo = 14;

    /**
     * Clears the field "rAppRemotingInfo".
     *
     * The field will be set to its default value. The hasRAppRemotingInfo()
     * method will return false.
     */
    inline void clearRAppRemotingInfo();

    /**
     * Checks whether the field "rAppRemotingInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRAppRemotingInfo()). Otherwise it will return false.
     */
    inline bool hasRAppRemotingInfo () const;

    /**
     * Returns the value of the member "rAppRemotingInfo".
     *
     * Indicates the Application Remoting Information
     *
     * @return The value of the field "rAppRemotingInfo"
     */
    inline const T_AppRemotingInfo& getRAppRemotingInfo () const;

    /**
     * Retrieves the value of the field "rAppRemotingInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rAppRemotingInfo".
     */
    inline T_AppRemotingInfo& getRAppRemotingInfoMutable ();

    /**
     * Sets the value of the member "rAppRemotingInfo".
     *
     * Indicates the Application Remoting Information
     *
     * @param rAppRemotingInfo The value which will be set
     */
    inline void setRAppRemotingInfo (const T_AppRemotingInfo& rAppRemotingInfo_);

    // API of field "u16NumAppIcons"

    static const int kU16NumAppIcons = 15;

    /**
     * Clears the field "u16NumAppIcons".
     *
     * The field will be set to its default value. The hasU16NumAppIcons()
     * method will return false.
     */
    inline void clearU16NumAppIcons();

    /**
     * Checks whether the field "u16NumAppIcons" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NumAppIcons()). Otherwise it will return false.
     */
    inline bool hasU16NumAppIcons () const;

    /**
     * Returns the value of the member "u16NumAppIcons".
     *
     * Indicates the Number of Application Icons
     *
     * @return The value of the field "u16NumAppIcons"
     */
    inline uint16 getU16NumAppIcons () const;

    /**
     * Sets the value of the member "u16NumAppIcons".
     *
     * Indicates the Number of Application Icons
     *
     * @param u16NumAppIcons The value which will be set
     */
    inline void setU16NumAppIcons (uint16 u16NumAppIcons_);

    // API of field "AppIconList"

    static const int kAppIconList = 16;

    /**
     * Clears the field "AppIconList".
     *
     * The field will be set to its default value. The hasAppIconList()
     * method will return false.
     */
    inline void clearAppIconList();

    /**
     * Checks whether the field "AppIconList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppIconList()). Otherwise it will return false.
     */
    inline bool hasAppIconList () const;

    /**
     * Returns the value of the member "AppIconList".
     *
     * Indicates the Application Icon Details
     *
     * @return The value of the field "AppIconList"
     */
    inline const ::std::vector< T_IconAttributes >& getAppIconList () const;

    /**
     * Retrieves the value of the field "AppIconList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AppIconList".
     */
    inline ::std::vector< T_IconAttributes >& getAppIconListMutable ();

    /**
     * Sets the value of the member "AppIconList".
     *
     * Indicates the Application Icon Details
     *
     * @param AppIconList The value which will be set
     */
    inline void setAppIconList (const ::std::vector< T_IconAttributes >& AppIconList_);

    // API of field "e8AppCertificationEntity"

    static const int kE8AppCertificationEntity = 17;

    /**
     * Clears the field "e8AppCertificationEntity".
     *
     * The field will be set to its default value. The hasE8AppCertificationEntity()
     * method will return false.
     */
    inline void clearE8AppCertificationEntity();

    /**
     * Checks whether the field "e8AppCertificationEntity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AppCertificationEntity()). Otherwise it will return false.
     */
    inline bool hasE8AppCertificationEntity () const;

    /**
     * Returns the value of the member "e8AppCertificationEntity".
     *
     * Indicates the Application is certified by CCC or CCC Member(OEM)
     *
     * @return The value of the field "e8AppCertificationEntity"
     */
    inline T_e8_AppCertificationEntity getE8AppCertificationEntity () const;

    /**
     * Sets the value of the member "e8AppCertificationEntity".
     *
     * Indicates the Application is certified by CCC or CCC Member(OEM)
     *
     * @param e8AppCertificationEntity The value which will be set
     */
    inline void setE8AppCertificationEntity (T_e8_AppCertificationEntity e8AppCertificationEntity_);

    static const T_AppDetails &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    static const ::std::vector< T_IconAttributes >& getT_IconAttributesList_DefaultInstance ();

    inline void set_has_u32AppHandle ();

    inline void clear_has_u32AppHandle ();

    inline void set_has_szAppName ();

    inline void clear_has_szAppName ();

    inline void set_has_enAppStatus ();

    inline void clear_has_enAppStatus ();

    inline void set_has_szAppVariant ();

    inline void clear_has_szAppVariant ();

    inline void set_has_szAppProviderName ();

    inline void clear_has_szAppProviderName ();

    inline void set_has_szAppProviderURL ();

    inline void clear_has_szAppProviderURL ();

    inline void set_has_szAppDescription ();

    inline void clear_has_szAppDescription ();

    inline void set_has_AppAllowedProfiles ();

    inline void clear_has_AppAllowedProfiles ();

    inline void set_has_szAppCertificateURL ();

    inline void clear_has_szAppCertificateURL ();

    inline void set_has_enAppCategory ();

    inline void clear_has_enAppCategory ();

    inline void set_has_enTrustLevel ();

    inline void clear_has_enTrustLevel ();

    inline void set_has_e8AppCertificationInfo ();

    inline void clear_has_e8AppCertificationInfo ();

    inline void set_has_rAppDisplayInfo ();

    inline void clear_has_rAppDisplayInfo ();

    inline void set_has_rAppAudioInfo ();

    inline void clear_has_rAppAudioInfo ();

    inline void set_has_rAppRemotingInfo ();

    inline void clear_has_rAppRemotingInfo ();

    inline void set_has_u16NumAppIcons ();

    inline void clear_has_u16NumAppIcons ();

    inline void set_has_AppIconList ();

    inline void clear_has_AppIconList ();

    inline void set_has_e8AppCertificationEntity ();

    inline void clear_has_e8AppCertificationEntity ();

    uint32 _has_bits_[ (18 + 31) / 32];

    uint32 _u32AppHandle;

    ::std::string _szAppName;

    T_e8_AppStatus _enAppStatus;

    ::std::string _szAppVariant;

    ::std::string _szAppProviderName;

    ::std::string _szAppProviderURL;

    ::std::string _szAppDescription;

    ::std::vector< ::std::string > _AppAllowedProfiles;

    ::std::string _szAppCertificateURL;

    T_e32_AppCategory _enAppCategory;

    T_e16_TrustLevel _enTrustLevel;

    T_e8_AppCertificationInfo _e8AppCertificationInfo;

    T_AppDisplayInfo _rAppDisplayInfo;

    T_AppAudioInfo _rAppAudioInfo;

    T_AppRemotingInfo _rAppRemotingInfo;

    uint16 _u16NumAppIcons;

    ::std::vector< T_IconAttributes > _AppIconList;

    T_e8_AppCertificationEntity _e8AppCertificationEntity;

};

/**
 * This structure provides the EAP App information
 */
class T_EAPAppInfo {
public:

    /**
     * Default constructor
     */
    inline  T_EAPAppInfo ();

    /**
     * Copy constructor
     */
    inline  T_EAPAppInfo (const T_EAPAppInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_EAPAppInfo (const ::std::string& szAppName_, const ::std::string& szProtocol_, const ::std::string& szBundleID_);

    /**
     * Destructor
     */
    inline  ~T_EAPAppInfo();

    /**
     * Assignment operator
     */
    inline T_EAPAppInfo& operator = (const T_EAPAppInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_EAPAppInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_EAPAppInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_EAPAppInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_EAPAppInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szAppName"

    static const int kSzAppName = 0;

    /**
     * Clears the field "szAppName".
     *
     * The field will be set to its default value. The hasSzAppName()
     * method will return false.
     */
    inline void clearSzAppName();

    /**
     * Checks whether the field "szAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppName()). Otherwise it will return false.
     */
    inline bool hasSzAppName () const;

    /**
     * Returns the value of the member "szAppName".
     *
     * App Name
     *
     * @return The value of the field "szAppName"
     */
    inline const ::std::string& getSzAppName () const;

    /**
     * Retrieves the value of the field "szAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppName".
     */
    inline ::std::string& getSzAppNameMutable ();

    /**
     * Sets the value of the member "szAppName".
     *
     * App Name
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const ::std::string& szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * App Name
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * App Name
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* value, size_t size);

    // API of field "szProtocol"

    static const int kSzProtocol = 1;

    /**
     * Clears the field "szProtocol".
     *
     * The field will be set to its default value. The hasSzProtocol()
     * method will return false.
     */
    inline void clearSzProtocol();

    /**
     * Checks whether the field "szProtocol" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzProtocol()). Otherwise it will return false.
     */
    inline bool hasSzProtocol () const;

    /**
     * Returns the value of the member "szProtocol".
     *
     * App Protocol Name
     *
     * @return The value of the field "szProtocol"
     */
    inline const ::std::string& getSzProtocol () const;

    /**
     * Retrieves the value of the field "szProtocol" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szProtocol".
     */
    inline ::std::string& getSzProtocolMutable ();

    /**
     * Sets the value of the member "szProtocol".
     *
     * App Protocol Name
     *
     * @param szProtocol The value which will be set
     */
    inline void setSzProtocol (const ::std::string& szProtocol_);

    /**
     * Sets the value of the member "szProtocol".
     *
     * App Protocol Name
     *
     * @param szProtocol The value which will be set
     */
    inline void setSzProtocol (const char* szProtocol_);

    /**
     * Sets the value of the member "szProtocol".
     *
     * App Protocol Name
     *
     * @param szProtocol The value which will be set
     */
    inline void setSzProtocol (const char* value, size_t size);

    // API of field "szBundleID"

    static const int kSzBundleID = 2;

    /**
     * Clears the field "szBundleID".
     *
     * The field will be set to its default value. The hasSzBundleID()
     * method will return false.
     */
    inline void clearSzBundleID();

    /**
     * Checks whether the field "szBundleID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzBundleID()). Otherwise it will return false.
     */
    inline bool hasSzBundleID () const;

    /**
     * Returns the value of the member "szBundleID".
     *
     * App Bundle ID.
     *
     * @return The value of the field "szBundleID"
     */
    inline const ::std::string& getSzBundleID () const;

    /**
     * Retrieves the value of the field "szBundleID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szBundleID".
     */
    inline ::std::string& getSzBundleIDMutable ();

    /**
     * Sets the value of the member "szBundleID".
     *
     * App Bundle ID.
     *
     * @param szBundleID The value which will be set
     */
    inline void setSzBundleID (const ::std::string& szBundleID_);

    /**
     * Sets the value of the member "szBundleID".
     *
     * App Bundle ID.
     *
     * @param szBundleID The value which will be set
     */
    inline void setSzBundleID (const char* szBundleID_);

    /**
     * Sets the value of the member "szBundleID".
     *
     * App Bundle ID.
     *
     * @param szBundleID The value which will be set
     */
    inline void setSzBundleID (const char* value, size_t size);

    static const T_EAPAppInfo &getDefaultInstance();

private:

    inline void set_has_szAppName ();

    inline void clear_has_szAppName ();

    inline void set_has_szProtocol ();

    inline void clear_has_szProtocol ();

    inline void set_has_szBundleID ();

    inline void clear_has_szBundleID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _szAppName;

    ::std::string _szProtocol;

    ::std::string _szBundleID;

};

/**
 * This structure identifies the X and Y Co-ordinates
 */
class T_TouchCoordinates {
public:

    /**
     * Default constructor
     */
    inline  T_TouchCoordinates ();

    /**
     * Copy constructor
     */
    inline  T_TouchCoordinates (const T_TouchCoordinates &rhs);

    /**
     * All fields constructor
     */
    inline  T_TouchCoordinates (T_e8_TouchMode enTouchMode_, uint16 u16XCoordinate_, uint16 u16YCoordinate_);

    /**
     * Destructor
     */
    inline  ~T_TouchCoordinates();

    /**
     * Assignment operator
     */
    inline T_TouchCoordinates& operator = (const T_TouchCoordinates& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TouchCoordinates& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TouchCoordinates& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TouchCoordinates& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TouchCoordinates& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enTouchMode"

    static const int kEnTouchMode = 0;

    /**
     * Clears the field "enTouchMode".
     *
     * The field will be set to its default value. The hasEnTouchMode()
     * method will return false.
     */
    inline void clearEnTouchMode();

    /**
     * Checks whether the field "enTouchMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnTouchMode()). Otherwise it will return false.
     */
    inline bool hasEnTouchMode () const;

    /**
     * Returns the value of the member "enTouchMode".
     *
     * Information for Touch Mode
     *
     * @return The value of the field "enTouchMode"
     */
    inline T_e8_TouchMode getEnTouchMode () const;

    /**
     * Sets the value of the member "enTouchMode".
     *
     * Information for Touch Mode
     *
     * @param enTouchMode The value which will be set
     */
    inline void setEnTouchMode (T_e8_TouchMode enTouchMode_);

    // API of field "u16XCoordinate"

    static const int kU16XCoordinate = 1;

    /**
     * Clears the field "u16XCoordinate".
     *
     * The field will be set to its default value. The hasU16XCoordinate()
     * method will return false.
     */
    inline void clearU16XCoordinate();

    /**
     * Checks whether the field "u16XCoordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16XCoordinate()). Otherwise it will return false.
     */
    inline bool hasU16XCoordinate () const;

    /**
     * Returns the value of the member "u16XCoordinate".
     *
     * Information for X Co-ordinate value
     *
     * @return The value of the field "u16XCoordinate"
     */
    inline uint16 getU16XCoordinate () const;

    /**
     * Sets the value of the member "u16XCoordinate".
     *
     * Information for X Co-ordinate value
     *
     * @param u16XCoordinate The value which will be set
     */
    inline void setU16XCoordinate (uint16 u16XCoordinate_);

    // API of field "u16YCoordinate"

    static const int kU16YCoordinate = 2;

    /**
     * Clears the field "u16YCoordinate".
     *
     * The field will be set to its default value. The hasU16YCoordinate()
     * method will return false.
     */
    inline void clearU16YCoordinate();

    /**
     * Checks whether the field "u16YCoordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16YCoordinate()). Otherwise it will return false.
     */
    inline bool hasU16YCoordinate () const;

    /**
     * Returns the value of the member "u16YCoordinate".
     *
     * Information for Y Co-ordinate value
     *
     * @return The value of the field "u16YCoordinate"
     */
    inline uint16 getU16YCoordinate () const;

    /**
     * Sets the value of the member "u16YCoordinate".
     *
     * Information for Y Co-ordinate value
     *
     * @param u16YCoordinate The value which will be set
     */
    inline void setU16YCoordinate (uint16 u16YCoordinate_);

    static const T_TouchCoordinates &getDefaultInstance();

private:

    inline void set_has_enTouchMode ();

    inline void clear_has_enTouchMode ();

    inline void set_has_u16XCoordinate ();

    inline void clear_has_u16XCoordinate ();

    inline void set_has_u16YCoordinate ();

    inline void clear_has_u16YCoordinate ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_TouchMode _enTouchMode;

    uint16 _u16XCoordinate;

    uint16 _u16YCoordinate;

};

/**
 * This structure identifies Single/Multi-Touch information
 */
class T_TouchData {
public:

    /**
     * Default constructor
     */
    inline  T_TouchData ();

    /**
     * Copy constructor
     */
    inline  T_TouchData (const T_TouchData &rhs);

    /**
     * All fields constructor
     */
    inline  T_TouchData (uint16 u16TouchDescriptors_, const ::std::vector< T_TouchInfo >& TouchInfoList_);

    /**
     * Destructor
     */
    inline  ~T_TouchData();

    /**
     * Assignment operator
     */
    inline T_TouchData& operator = (const T_TouchData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TouchData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TouchData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TouchData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TouchData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16TouchDescriptors"

    static const int kU16TouchDescriptors = 0;

    /**
     * Clears the field "u16TouchDescriptors".
     *
     * The field will be set to its default value. The hasU16TouchDescriptors()
     * method will return false.
     */
    inline void clearU16TouchDescriptors();

    /**
     * Checks whether the field "u16TouchDescriptors" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16TouchDescriptors()). Otherwise it will return false.
     */
    inline bool hasU16TouchDescriptors () const;

    /**
     * Returns the value of the member "u16TouchDescriptors".
     *
     * Indicates Number of Touch Descriptors. In case of Single touch this value is 1
     *
     * @return The value of the field "u16TouchDescriptors"
     */
    inline uint16 getU16TouchDescriptors () const;

    /**
     * Sets the value of the member "u16TouchDescriptors".
     *
     * Indicates Number of Touch Descriptors. In case of Single touch this value is 1
     *
     * @param u16TouchDescriptors The value which will be set
     */
    inline void setU16TouchDescriptors (uint16 u16TouchDescriptors_);

    // API of field "TouchInfoList"

    static const int kTouchInfoList = 1;

    /**
     * Clears the field "TouchInfoList".
     *
     * The field will be set to its default value. The hasTouchInfoList()
     * method will return false.
     */
    inline void clearTouchInfoList();

    /**
     * Checks whether the field "TouchInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTouchInfoList()). Otherwise it will return false.
     */
    inline bool hasTouchInfoList () const;

    /**
     * Returns the value of the member "TouchInfoList".
     *
     * Indicates Touch Information. In case of Single touch list has only one entry
     *
     * @return The value of the field "TouchInfoList"
     */
    inline const ::std::vector< T_TouchInfo >& getTouchInfoList () const;

    /**
     * Retrieves the value of the field "TouchInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TouchInfoList".
     */
    inline ::std::vector< T_TouchInfo >& getTouchInfoListMutable ();

    /**
     * Sets the value of the member "TouchInfoList".
     *
     * Indicates Touch Information. In case of Single touch list has only one entry
     *
     * @param TouchInfoList The value which will be set
     */
    inline void setTouchInfoList (const ::std::vector< T_TouchInfo >& TouchInfoList_);

    static const T_TouchData &getDefaultInstance();

private:

    static const ::std::vector< T_TouchInfo >& getT_TouchInfoList_DefaultInstance ();

    inline void set_has_u16TouchDescriptors ();

    inline void clear_has_u16TouchDescriptors ();

    inline void set_has_TouchInfoList ();

    inline void clear_has_TouchInfoList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16TouchDescriptors;

    ::std::vector< T_TouchInfo > _TouchInfoList;

};

/**
 * This structure provides screen attributes
 */
class T_ScreenAttributes {
public:

    /**
     * Default constructor
     */
    inline  T_ScreenAttributes ();

    /**
     * Copy constructor
     */
    inline  T_ScreenAttributes (const T_ScreenAttributes &rhs);

    /**
     * All fields constructor
     */
    inline  T_ScreenAttributes (uint16 u16ScreenHeight_, uint16 u16ScreenWidth_, T_e8_ScreenAspectRatio enScreenAspectRatio_);

    /**
     * Destructor
     */
    inline  ~T_ScreenAttributes();

    /**
     * Assignment operator
     */
    inline T_ScreenAttributes& operator = (const T_ScreenAttributes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ScreenAttributes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ScreenAttributes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ScreenAttributes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ScreenAttributes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ScreenHeight"

    static const int kU16ScreenHeight = 0;

    /**
     * Clears the field "u16ScreenHeight".
     *
     * The field will be set to its default value. The hasU16ScreenHeight()
     * method will return false.
     */
    inline void clearU16ScreenHeight();

    /**
     * Checks whether the field "u16ScreenHeight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ScreenHeight()). Otherwise it will return false.
     */
    inline bool hasU16ScreenHeight () const;

    /**
     * Returns the value of the member "u16ScreenHeight".
     *
     * Information for Height of the screen
     *
     * @return The value of the field "u16ScreenHeight"
     */
    inline uint16 getU16ScreenHeight () const;

    /**
     * Sets the value of the member "u16ScreenHeight".
     *
     * Information for Height of the screen
     *
     * @param u16ScreenHeight The value which will be set
     */
    inline void setU16ScreenHeight (uint16 u16ScreenHeight_);

    // API of field "u16ScreenWidth"

    static const int kU16ScreenWidth = 1;

    /**
     * Clears the field "u16ScreenWidth".
     *
     * The field will be set to its default value. The hasU16ScreenWidth()
     * method will return false.
     */
    inline void clearU16ScreenWidth();

    /**
     * Checks whether the field "u16ScreenWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ScreenWidth()). Otherwise it will return false.
     */
    inline bool hasU16ScreenWidth () const;

    /**
     * Returns the value of the member "u16ScreenWidth".
     *
     * Information for Width of the screen
     *
     * @return The value of the field "u16ScreenWidth"
     */
    inline uint16 getU16ScreenWidth () const;

    /**
     * Sets the value of the member "u16ScreenWidth".
     *
     * Information for Width of the screen
     *
     * @param u16ScreenWidth The value which will be set
     */
    inline void setU16ScreenWidth (uint16 u16ScreenWidth_);

    // API of field "enScreenAspectRatio"

    static const int kEnScreenAspectRatio = 2;

    /**
     * Clears the field "enScreenAspectRatio".
     *
     * The field will be set to its default value. The hasEnScreenAspectRatio()
     * method will return false.
     */
    inline void clearEnScreenAspectRatio();

    /**
     * Checks whether the field "enScreenAspectRatio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnScreenAspectRatio()). Otherwise it will return false.
     */
    inline bool hasEnScreenAspectRatio () const;

    /**
     * Returns the value of the member "enScreenAspectRatio".
     *
     * Information for Aspect Ratio
     *
     * @return The value of the field "enScreenAspectRatio"
     */
    inline T_e8_ScreenAspectRatio getEnScreenAspectRatio () const;

    /**
     * Sets the value of the member "enScreenAspectRatio".
     *
     * Information for Aspect Ratio
     *
     * @param enScreenAspectRatio The value which will be set
     */
    inline void setEnScreenAspectRatio (T_e8_ScreenAspectRatio enScreenAspectRatio_);

    static const T_ScreenAttributes &getDefaultInstance();

private:

    inline void set_has_u16ScreenHeight ();

    inline void clear_has_u16ScreenHeight ();

    inline void set_has_u16ScreenWidth ();

    inline void clear_has_u16ScreenWidth ();

    inline void set_has_enScreenAspectRatio ();

    inline void clear_has_enScreenAspectRatio ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16ScreenHeight;

    uint16 _u16ScreenWidth;

    T_e8_ScreenAspectRatio _enScreenAspectRatio;

};

/**
 * This structure identifies the attributes associated with Video
 */
class T_VideoAttributes {
public:

    /**
     * Default constructor
     */
    inline  T_VideoAttributes ();

    /**
     * Copy constructor
     */
    inline  T_VideoAttributes (const T_VideoAttributes &rhs);

    /**
     * All fields constructor
     */
    inline  T_VideoAttributes (T_e8_OrientationMode enOrientationMode_, const T_ScreenAttributes& rScreenAttributes_);

    /**
     * Destructor
     */
    inline  ~T_VideoAttributes();

    /**
     * Assignment operator
     */
    inline T_VideoAttributes& operator = (const T_VideoAttributes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_VideoAttributes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_VideoAttributes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_VideoAttributes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_VideoAttributes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enOrientationMode"

    static const int kEnOrientationMode = 0;

    /**
     * Clears the field "enOrientationMode".
     *
     * The field will be set to its default value. The hasEnOrientationMode()
     * method will return false.
     */
    inline void clearEnOrientationMode();

    /**
     * Checks whether the field "enOrientationMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnOrientationMode()). Otherwise it will return false.
     */
    inline bool hasEnOrientationMode () const;

    /**
     * Returns the value of the member "enOrientationMode".
     *
     * Information for Orientation Mode
     *
     * @return The value of the field "enOrientationMode"
     */
    inline T_e8_OrientationMode getEnOrientationMode () const;

    /**
     * Sets the value of the member "enOrientationMode".
     *
     * Information for Orientation Mode
     *
     * @param enOrientationMode The value which will be set
     */
    inline void setEnOrientationMode (T_e8_OrientationMode enOrientationMode_);

    // API of field "rScreenAttributes"

    static const int kRScreenAttributes = 1;

    /**
     * Clears the field "rScreenAttributes".
     *
     * The field will be set to its default value. The hasRScreenAttributes()
     * method will return false.
     */
    inline void clearRScreenAttributes();

    /**
     * Checks whether the field "rScreenAttributes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRScreenAttributes()). Otherwise it will return false.
     */
    inline bool hasRScreenAttributes () const;

    /**
     * Returns the value of the member "rScreenAttributes".
     *
     * Information for Screen size of the CE device
     *
     * @return The value of the field "rScreenAttributes"
     */
    inline const T_ScreenAttributes& getRScreenAttributes () const;

    /**
     * Retrieves the value of the field "rScreenAttributes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rScreenAttributes".
     */
    inline T_ScreenAttributes& getRScreenAttributesMutable ();

    /**
     * Sets the value of the member "rScreenAttributes".
     *
     * Information for Screen size of the CE device
     *
     * @param rScreenAttributes The value which will be set
     */
    inline void setRScreenAttributes (const T_ScreenAttributes& rScreenAttributes_);

    static const T_VideoAttributes &getDefaultInstance();

private:

    inline void set_has_enOrientationMode ();

    inline void clear_has_enOrientationMode ();

    inline void set_has_rScreenAttributes ();

    inline void clear_has_rScreenAttributes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_OrientationMode _enOrientationMode;

    T_ScreenAttributes _rScreenAttributes;

};

/**
 * This structure identifies the application IDs for which notification has to be enabled / disabled
 */
class T_NotificationEnable {
public:

    /**
     * Default constructor
     */
    inline  T_NotificationEnable ();

    /**
     * Copy constructor
     */
    inline  T_NotificationEnable (const T_NotificationEnable &rhs);

    /**
     * All fields constructor
     */
    inline  T_NotificationEnable (uint32 u32AppHandle_, T_e8_EnabledInfo enEnabledInfo_);

    /**
     * Destructor
     */
    inline  ~T_NotificationEnable();

    /**
     * Assignment operator
     */
    inline T_NotificationEnable& operator = (const T_NotificationEnable& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_NotificationEnable& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_NotificationEnable& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_NotificationEnable& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_NotificationEnable& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32AppHandle"

    static const int kU32AppHandle = 0;

    /**
     * Clears the field "u32AppHandle".
     *
     * The field will be set to its default value. The hasU32AppHandle()
     * method will return false.
     */
    inline void clearU32AppHandle();

    /**
     * Checks whether the field "u32AppHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AppHandle()). Otherwise it will return false.
     */
    inline bool hasU32AppHandle () const;

    /**
     * Returns the value of the member "u32AppHandle".
     *
     * Information the Unique Application Identifier
     *
     * @return The value of the field "u32AppHandle"
     */
    inline uint32 getU32AppHandle () const;

    /**
     * Sets the value of the member "u32AppHandle".
     *
     * Information the Unique Application Identifier
     *
     * @param u32AppHandle The value which will be set
     */
    inline void setU32AppHandle (uint32 u32AppHandle_);

    // API of field "enEnabledInfo"

    static const int kEnEnabledInfo = 1;

    /**
     * Clears the field "enEnabledInfo".
     *
     * The field will be set to its default value. The hasEnEnabledInfo()
     * method will return false.
     */
    inline void clearEnEnabledInfo();

    /**
     * Checks whether the field "enEnabledInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnEnabledInfo()). Otherwise it will return false.
     */
    inline bool hasEnEnabledInfo () const;

    /**
     * Returns the value of the member "enEnabledInfo".
     *
     * Information the Enable/Disable Info
     *
     * @return The value of the field "enEnabledInfo"
     */
    inline T_e8_EnabledInfo getEnEnabledInfo () const;

    /**
     * Sets the value of the member "enEnabledInfo".
     *
     * Information the Enable/Disable Info
     *
     * @param enEnabledInfo The value which will be set
     */
    inline void setEnEnabledInfo (T_e8_EnabledInfo enEnabledInfo_);

    static const T_NotificationEnable &getDefaultInstance();

private:

    inline void set_has_u32AppHandle ();

    inline void clear_has_u32AppHandle ();

    inline void set_has_enEnabledInfo ();

    inline void clear_has_enEnabledInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32AppHandle;

    T_e8_EnabledInfo _enEnabledInfo;

};

/**
 * This structure provides Notification Action details
 */
class T_NotificationAction {
public:

    /**
     * Default constructor
     */
    inline  T_NotificationAction ();

    /**
     * Copy constructor
     */
    inline  T_NotificationAction (const T_NotificationAction &rhs);

    /**
     * All fields constructor
     */
    inline  T_NotificationAction (uint16 u16NotificationActionID_, const ::std::string& szNotificationActionName_, uint16 u16NotificationActionIconCount_, const ::std::vector< T_IconAttributes >& NotificationActionIconList_);

    /**
     * Destructor
     */
    inline  ~T_NotificationAction();

    /**
     * Assignment operator
     */
    inline T_NotificationAction& operator = (const T_NotificationAction& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_NotificationAction& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_NotificationAction& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_NotificationAction& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_NotificationAction& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16NotificationActionID"

    static const int kU16NotificationActionID = 0;

    /**
     * Clears the field "u16NotificationActionID".
     *
     * The field will be set to its default value. The hasU16NotificationActionID()
     * method will return false.
     */
    inline void clearU16NotificationActionID();

    /**
     * Checks whether the field "u16NotificationActionID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NotificationActionID()). Otherwise it will return false.
     */
    inline bool hasU16NotificationActionID () const;

    /**
     * Returns the value of the member "u16NotificationActionID".
     *
     * Indicates the Notification action Identifier
     *
     * @return The value of the field "u16NotificationActionID"
     */
    inline uint16 getU16NotificationActionID () const;

    /**
     * Sets the value of the member "u16NotificationActionID".
     *
     * Indicates the Notification action Identifier
     *
     * @param u16NotificationActionID The value which will be set
     */
    inline void setU16NotificationActionID (uint16 u16NotificationActionID_);

    // API of field "szNotificationActionName"

    static const int kSzNotificationActionName = 1;

    /**
     * Clears the field "szNotificationActionName".
     *
     * The field will be set to its default value. The hasSzNotificationActionName()
     * method will return false.
     */
    inline void clearSzNotificationActionName();

    /**
     * Checks whether the field "szNotificationActionName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzNotificationActionName()). Otherwise it will return false.
     */
    inline bool hasSzNotificationActionName () const;

    /**
     * Returns the value of the member "szNotificationActionName".
     *
     * Indicates the Notification action Name
     *
     * @return The value of the field "szNotificationActionName"
     */
    inline const ::std::string& getSzNotificationActionName () const;

    /**
     * Retrieves the value of the field "szNotificationActionName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szNotificationActionName".
     */
    inline ::std::string& getSzNotificationActionNameMutable ();

    /**
     * Sets the value of the member "szNotificationActionName".
     *
     * Indicates the Notification action Name
     *
     * @param szNotificationActionName The value which will be set
     */
    inline void setSzNotificationActionName (const ::std::string& szNotificationActionName_);

    /**
     * Sets the value of the member "szNotificationActionName".
     *
     * Indicates the Notification action Name
     *
     * @param szNotificationActionName The value which will be set
     */
    inline void setSzNotificationActionName (const char* szNotificationActionName_);

    /**
     * Sets the value of the member "szNotificationActionName".
     *
     * Indicates the Notification action Name
     *
     * @param szNotificationActionName The value which will be set
     */
    inline void setSzNotificationActionName (const char* value, size_t size);

    // API of field "u16NotificationActionIconCount"

    static const int kU16NotificationActionIconCount = 2;

    /**
     * Clears the field "u16NotificationActionIconCount".
     *
     * The field will be set to its default value. The hasU16NotificationActionIconCount()
     * method will return false.
     */
    inline void clearU16NotificationActionIconCount();

    /**
     * Checks whether the field "u16NotificationActionIconCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NotificationActionIconCount()). Otherwise it will return false.
     */
    inline bool hasU16NotificationActionIconCount () const;

    /**
     * Returns the value of the member "u16NotificationActionIconCount".
     *
     * Indicates the Number of Notification Action Icons
     *
     * @return The value of the field "u16NotificationActionIconCount"
     */
    inline uint16 getU16NotificationActionIconCount () const;

    /**
     * Sets the value of the member "u16NotificationActionIconCount".
     *
     * Indicates the Number of Notification Action Icons
     *
     * @param u16NotificationActionIconCount The value which will be set
     */
    inline void setU16NotificationActionIconCount (uint16 u16NotificationActionIconCount_);

    // API of field "NotificationActionIconList"

    static const int kNotificationActionIconList = 3;

    /**
     * Clears the field "NotificationActionIconList".
     *
     * The field will be set to its default value. The hasNotificationActionIconList()
     * method will return false.
     */
    inline void clearNotificationActionIconList();

    /**
     * Checks whether the field "NotificationActionIconList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotificationActionIconList()). Otherwise it will return false.
     */
    inline bool hasNotificationActionIconList () const;

    /**
     * Returns the value of the member "NotificationActionIconList".
     *
     * Indicates the Details of Notification action icons
     *
     * @return The value of the field "NotificationActionIconList"
     */
    inline const ::std::vector< T_IconAttributes >& getNotificationActionIconList () const;

    /**
     * Retrieves the value of the field "NotificationActionIconList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NotificationActionIconList".
     */
    inline ::std::vector< T_IconAttributes >& getNotificationActionIconListMutable ();

    /**
     * Sets the value of the member "NotificationActionIconList".
     *
     * Indicates the Details of Notification action icons
     *
     * @param NotificationActionIconList The value which will be set
     */
    inline void setNotificationActionIconList (const ::std::vector< T_IconAttributes >& NotificationActionIconList_);

    static const T_NotificationAction &getDefaultInstance();

private:

    static const ::std::vector< T_IconAttributes >& getT_IconAttributesList_DefaultInstance ();

    inline void set_has_u16NotificationActionID ();

    inline void clear_has_u16NotificationActionID ();

    inline void set_has_szNotificationActionName ();

    inline void clear_has_szNotificationActionName ();

    inline void set_has_u16NotificationActionIconCount ();

    inline void clear_has_u16NotificationActionIconCount ();

    inline void set_has_NotificationActionIconList ();

    inline void clear_has_NotificationActionIconList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _u16NotificationActionID;

    ::std::string _szNotificationActionName;

    uint16 _u16NotificationActionIconCount;

    ::std::vector< T_IconAttributes > _NotificationActionIconList;

};

/**
 * This structure provides detailed information for a Notification Event
 */
class T_NotificationData {
public:

    /**
     * Default constructor
     */
    inline  T_NotificationData ();

    /**
     * Copy constructor
     */
    inline  T_NotificationData (const T_NotificationData &rhs);

    /**
     * All fields constructor
     */
    inline  T_NotificationData (uint16 u16NotificationID_, const ::std::string& szNotificationTitle_, const ::std::string& szNotificationBody_, uint16 u16NotificationIconCount_, const ::std::vector< T_IconAttributes >& NotificationIconList_, uint16 u16NotificationAppID_, const ::std::vector< T_NotificationAction >& NotificationActionList_);

    /**
     * Destructor
     */
    inline  ~T_NotificationData();

    /**
     * Assignment operator
     */
    inline T_NotificationData& operator = (const T_NotificationData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_NotificationData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_NotificationData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_NotificationData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_NotificationData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16NotificationID"

    static const int kU16NotificationID = 0;

    /**
     * Clears the field "u16NotificationID".
     *
     * The field will be set to its default value. The hasU16NotificationID()
     * method will return false.
     */
    inline void clearU16NotificationID();

    /**
     * Checks whether the field "u16NotificationID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NotificationID()). Otherwise it will return false.
     */
    inline bool hasU16NotificationID () const;

    /**
     * Returns the value of the member "u16NotificationID".
     *
     * Indicates the Notification Event ID
     *
     * @return The value of the field "u16NotificationID"
     */
    inline uint16 getU16NotificationID () const;

    /**
     * Sets the value of the member "u16NotificationID".
     *
     * Indicates the Notification Event ID
     *
     * @param u16NotificationID The value which will be set
     */
    inline void setU16NotificationID (uint16 u16NotificationID_);

    // API of field "szNotificationTitle"

    static const int kSzNotificationTitle = 1;

    /**
     * Clears the field "szNotificationTitle".
     *
     * The field will be set to its default value. The hasSzNotificationTitle()
     * method will return false.
     */
    inline void clearSzNotificationTitle();

    /**
     * Checks whether the field "szNotificationTitle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzNotificationTitle()). Otherwise it will return false.
     */
    inline bool hasSzNotificationTitle () const;

    /**
     * Returns the value of the member "szNotificationTitle".
     *
     * Indicates the Title of the notification
     *
     * @return The value of the field "szNotificationTitle"
     */
    inline const ::std::string& getSzNotificationTitle () const;

    /**
     * Retrieves the value of the field "szNotificationTitle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szNotificationTitle".
     */
    inline ::std::string& getSzNotificationTitleMutable ();

    /**
     * Sets the value of the member "szNotificationTitle".
     *
     * Indicates the Title of the notification
     *
     * @param szNotificationTitle The value which will be set
     */
    inline void setSzNotificationTitle (const ::std::string& szNotificationTitle_);

    /**
     * Sets the value of the member "szNotificationTitle".
     *
     * Indicates the Title of the notification
     *
     * @param szNotificationTitle The value which will be set
     */
    inline void setSzNotificationTitle (const char* szNotificationTitle_);

    /**
     * Sets the value of the member "szNotificationTitle".
     *
     * Indicates the Title of the notification
     *
     * @param szNotificationTitle The value which will be set
     */
    inline void setSzNotificationTitle (const char* value, size_t size);

    // API of field "szNotificationBody"

    static const int kSzNotificationBody = 2;

    /**
     * Clears the field "szNotificationBody".
     *
     * The field will be set to its default value. The hasSzNotificationBody()
     * method will return false.
     */
    inline void clearSzNotificationBody();

    /**
     * Checks whether the field "szNotificationBody" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzNotificationBody()). Otherwise it will return false.
     */
    inline bool hasSzNotificationBody () const;

    /**
     * Returns the value of the member "szNotificationBody".
     *
     * Indicates the Body of the notification
     *
     * @return The value of the field "szNotificationBody"
     */
    inline const ::std::string& getSzNotificationBody () const;

    /**
     * Retrieves the value of the field "szNotificationBody" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szNotificationBody".
     */
    inline ::std::string& getSzNotificationBodyMutable ();

    /**
     * Sets the value of the member "szNotificationBody".
     *
     * Indicates the Body of the notification
     *
     * @param szNotificationBody The value which will be set
     */
    inline void setSzNotificationBody (const ::std::string& szNotificationBody_);

    /**
     * Sets the value of the member "szNotificationBody".
     *
     * Indicates the Body of the notification
     *
     * @param szNotificationBody The value which will be set
     */
    inline void setSzNotificationBody (const char* szNotificationBody_);

    /**
     * Sets the value of the member "szNotificationBody".
     *
     * Indicates the Body of the notification
     *
     * @param szNotificationBody The value which will be set
     */
    inline void setSzNotificationBody (const char* value, size_t size);

    // API of field "u16NotificationIconCount"

    static const int kU16NotificationIconCount = 3;

    /**
     * Clears the field "u16NotificationIconCount".
     *
     * The field will be set to its default value. The hasU16NotificationIconCount()
     * method will return false.
     */
    inline void clearU16NotificationIconCount();

    /**
     * Checks whether the field "u16NotificationIconCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NotificationIconCount()). Otherwise it will return false.
     */
    inline bool hasU16NotificationIconCount () const;

    /**
     * Returns the value of the member "u16NotificationIconCount".
     *
     * Indicates the Number of Notification Icons
     *
     * @return The value of the field "u16NotificationIconCount"
     */
    inline uint16 getU16NotificationIconCount () const;

    /**
     * Sets the value of the member "u16NotificationIconCount".
     *
     * Indicates the Number of Notification Icons
     *
     * @param u16NotificationIconCount The value which will be set
     */
    inline void setU16NotificationIconCount (uint16 u16NotificationIconCount_);

    // API of field "NotificationIconList"

    static const int kNotificationIconList = 4;

    /**
     * Clears the field "NotificationIconList".
     *
     * The field will be set to its default value. The hasNotificationIconList()
     * method will return false.
     */
    inline void clearNotificationIconList();

    /**
     * Checks whether the field "NotificationIconList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotificationIconList()). Otherwise it will return false.
     */
    inline bool hasNotificationIconList () const;

    /**
     * Returns the value of the member "NotificationIconList".
     *
     * Information the Details of Notification icons
     *
     * @return The value of the field "NotificationIconList"
     */
    inline const ::std::vector< T_IconAttributes >& getNotificationIconList () const;

    /**
     * Retrieves the value of the field "NotificationIconList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NotificationIconList".
     */
    inline ::std::vector< T_IconAttributes >& getNotificationIconListMutable ();

    /**
     * Sets the value of the member "NotificationIconList".
     *
     * Information the Details of Notification icons
     *
     * @param NotificationIconList The value which will be set
     */
    inline void setNotificationIconList (const ::std::vector< T_IconAttributes >& NotificationIconList_);

    // API of field "u16NotificationAppID"

    static const int kU16NotificationAppID = 5;

    /**
     * Clears the field "u16NotificationAppID".
     *
     * The field will be set to its default value. The hasU16NotificationAppID()
     * method will return false.
     */
    inline void clearU16NotificationAppID();

    /**
     * Checks whether the field "u16NotificationAppID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NotificationAppID()). Otherwise it will return false.
     */
    inline bool hasU16NotificationAppID () const;

    /**
     * Returns the value of the member "u16NotificationAppID".
     *
     * Indicates the Application ID of the notification
     *
     * @return The value of the field "u16NotificationAppID"
     */
    inline uint16 getU16NotificationAppID () const;

    /**
     * Sets the value of the member "u16NotificationAppID".
     *
     * Indicates the Application ID of the notification
     *
     * @param u16NotificationAppID The value which will be set
     */
    inline void setU16NotificationAppID (uint16 u16NotificationAppID_);

    // API of field "NotificationActionList"

    static const int kNotificationActionList = 6;

    /**
     * Clears the field "NotificationActionList".
     *
     * The field will be set to its default value. The hasNotificationActionList()
     * method will return false.
     */
    inline void clearNotificationActionList();

    /**
     * Checks whether the field "NotificationActionList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotificationActionList()). Otherwise it will return false.
     */
    inline bool hasNotificationActionList () const;

    /**
     * Returns the value of the member "NotificationActionList".
     *
     * Indicates the Details of Notification Actions
     *
     * @return The value of the field "NotificationActionList"
     */
    inline const ::std::vector< T_NotificationAction >& getNotificationActionList () const;

    /**
     * Retrieves the value of the field "NotificationActionList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NotificationActionList".
     */
    inline ::std::vector< T_NotificationAction >& getNotificationActionListMutable ();

    /**
     * Sets the value of the member "NotificationActionList".
     *
     * Indicates the Details of Notification Actions
     *
     * @param NotificationActionList The value which will be set
     */
    inline void setNotificationActionList (const ::std::vector< T_NotificationAction >& NotificationActionList_);

    static const T_NotificationData &getDefaultInstance();

private:

    static const ::std::vector< T_IconAttributes >& getT_IconAttributesList_DefaultInstance ();

    static const ::std::vector< T_NotificationAction >& getT_NotificationActionList_DefaultInstance ();

    inline void set_has_u16NotificationID ();

    inline void clear_has_u16NotificationID ();

    inline void set_has_szNotificationTitle ();

    inline void clear_has_szNotificationTitle ();

    inline void set_has_szNotificationBody ();

    inline void clear_has_szNotificationBody ();

    inline void set_has_u16NotificationIconCount ();

    inline void clear_has_u16NotificationIconCount ();

    inline void set_has_NotificationIconList ();

    inline void clear_has_NotificationIconList ();

    inline void set_has_u16NotificationAppID ();

    inline void clear_has_u16NotificationAppID ();

    inline void set_has_NotificationActionList ();

    inline void clear_has_NotificationActionList ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint16 _u16NotificationID;

    ::std::string _szNotificationTitle;

    ::std::string _szNotificationBody;

    uint16 _u16NotificationIconCount;

    ::std::vector< T_IconAttributes > _NotificationIconList;

    uint16 _u16NotificationAppID;

    ::std::vector< T_NotificationAction > _NotificationActionList;

};

/**
 * This structure contains Key Capabilities
 */
class T_KeyCapabilities {
public:

    /**
     * Default constructor
     */
    inline  T_KeyCapabilities ();

    /**
     * Copy constructor
     */
    inline  T_KeyCapabilities (const T_KeyCapabilities &rhs);

    /**
     * All fields constructor
     */
    inline  T_KeyCapabilities (uint32 u32KnobKeySupport_, uint32 u32DeviceKeySupport_, uint32 u32MultimediaKeySupport_, uint32 u32MiscKeySupport_, uint32 u32PointerTouchSupport_);

    /**
     * Destructor
     */
    inline  ~T_KeyCapabilities();

    /**
     * Assignment operator
     */
    inline T_KeyCapabilities& operator = (const T_KeyCapabilities& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_KeyCapabilities& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_KeyCapabilities& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_KeyCapabilities& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_KeyCapabilities& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32KnobKeySupport"

    static const int kU32KnobKeySupport = 0;

    /**
     * Clears the field "u32KnobKeySupport".
     *
     * The field will be set to its default value. The hasU32KnobKeySupport()
     * method will return false.
     */
    inline void clearU32KnobKeySupport();

    /**
     * Checks whether the field "u32KnobKeySupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32KnobKeySupport()). Otherwise it will return false.
     */
    inline bool hasU32KnobKeySupport () const;

    /**
     * Returns the value of the member "u32KnobKeySupport".
     *
     * Informs the Knob keys supported. Totally 4 knobs are support in FI.
     * Actual number of Knob supported should checked in SPI service.
     * Each bit in 4 bytes( i.e 0xFFFFFFFF) indicates individual knob keys as mentioned below
     * KnobKeySupportNone	   = 0x00000000,
     * KnobKeySupport1ShiftX  = 0x00000001,
     * KnobKeySupport1ShiftY  = 0x00000002,
     * KnobKeySupport1ShiftXY = 0x00000004,
     * KnobKeySupport1PushZ   = 0x00000008,
     * KnobKeySupport1PullZ   = 0x00000010,
     * KnobKeySupport1RotateX = 0x00000020,
     * KnobKeySupport1RotateY = 0x00000040,
     * KnobKeySupport1RotateZ = 0x00000080,
     * KnobKeySupport2ShiftX  = 0x00000100,
     * KnobKeySupport2ShiftY  = 0x00000200,
     * KnobKeySupport2ShiftXY = 0x00000400,
     * KnobKeySupport2PushZ   = 0x00000800,
     * KnobKeySupport2PullZ   = 0x00001000,
     * KnobKeySupport2RotateX = 0x00002000,
     * KnobKeySupport2RotateY = 0x00004000,
     * KnobKeySupport2RotateZ = 0x00008000,
     * KnobKeySupport3ShiftX  = 0x00010000,
     * KnobKeySupport3ShiftY  = 0x00020000,
     * KnobKeySupport3ShiftXY = 0x00040000,
     * KnobKeySupport3PushZ   = 0x00080000,
     * KnobKeySupport3PullZ   = 0x00100000,
     * KnobKeySupport3RotateX = 0x00200000,
     * KnobKeySupport3RotateY = 0x00400000,
     * KnobKeySupport3RotateZ = 0x00800000,
     * KnobKeySupport4ShiftX  = 0x01000000,
     * KnobKeySupport4ShiftY  = 0x02000000,
     * KnobKeySupport4ShiftXY = 0x04000000,
     * KnobKeySupport4PushZ   = 0x08000000,
     * KnobKeySupport4PullZ   = 0x10000000,
     * KnobKeySupport4RotateX = 0x20000000,
     * KnobKeySupport4RotateY = 0x40000000,
     * KnobKeySupport4RotateZ = 0x80000000
     *
     * @return The value of the field "u32KnobKeySupport"
     */
    inline uint32 getU32KnobKeySupport () const;

    /**
     * Sets the value of the member "u32KnobKeySupport".
     *
     * Informs the Knob keys supported. Totally 4 knobs are support in FI.
     * Actual number of Knob supported should checked in SPI service.
     * Each bit in 4 bytes( i.e 0xFFFFFFFF) indicates individual knob keys as mentioned below
     * KnobKeySupportNone	   = 0x00000000,
     * KnobKeySupport1ShiftX  = 0x00000001,
     * KnobKeySupport1ShiftY  = 0x00000002,
     * KnobKeySupport1ShiftXY = 0x00000004,
     * KnobKeySupport1PushZ   = 0x00000008,
     * KnobKeySupport1PullZ   = 0x00000010,
     * KnobKeySupport1RotateX = 0x00000020,
     * KnobKeySupport1RotateY = 0x00000040,
     * KnobKeySupport1RotateZ = 0x00000080,
     * KnobKeySupport2ShiftX  = 0x00000100,
     * KnobKeySupport2ShiftY  = 0x00000200,
     * KnobKeySupport2ShiftXY = 0x00000400,
     * KnobKeySupport2PushZ   = 0x00000800,
     * KnobKeySupport2PullZ   = 0x00001000,
     * KnobKeySupport2RotateX = 0x00002000,
     * KnobKeySupport2RotateY = 0x00004000,
     * KnobKeySupport2RotateZ = 0x00008000,
     * KnobKeySupport3ShiftX  = 0x00010000,
     * KnobKeySupport3ShiftY  = 0x00020000,
     * KnobKeySupport3ShiftXY = 0x00040000,
     * KnobKeySupport3PushZ   = 0x00080000,
     * KnobKeySupport3PullZ   = 0x00100000,
     * KnobKeySupport3RotateX = 0x00200000,
     * KnobKeySupport3RotateY = 0x00400000,
     * KnobKeySupport3RotateZ = 0x00800000,
     * KnobKeySupport4ShiftX  = 0x01000000,
     * KnobKeySupport4ShiftY  = 0x02000000,
     * KnobKeySupport4ShiftXY = 0x04000000,
     * KnobKeySupport4PushZ   = 0x08000000,
     * KnobKeySupport4PullZ   = 0x10000000,
     * KnobKeySupport4RotateX = 0x20000000,
     * KnobKeySupport4RotateY = 0x40000000,
     * KnobKeySupport4RotateZ = 0x80000000
     *
     * @param u32KnobKeySupport The value which will be set
     */
    inline void setU32KnobKeySupport (uint32 u32KnobKeySupport_);

    // API of field "u32DeviceKeySupport"

    static const int kU32DeviceKeySupport = 1;

    /**
     * Clears the field "u32DeviceKeySupport".
     *
     * The field will be set to its default value. The hasU32DeviceKeySupport()
     * method will return false.
     */
    inline void clearU32DeviceKeySupport();

    /**
     * Checks whether the field "u32DeviceKeySupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DeviceKeySupport()). Otherwise it will return false.
     */
    inline bool hasU32DeviceKeySupport () const;

    /**
     * Returns the value of the member "u32DeviceKeySupport".
     *
     * Informs the Device keys supported.
     * Each bit in 4 bytes( i.e 0xFFFFFFFF) indicates individual Device keys as mentioned below
     * DeviceKeySupportNone	    = 0x00000000,
     * DeviceKeySupportPhoneCall   = 0x00000001,
     * DeviceKeySupportPhoneEnd    = 0x00000002,
     * DeviceKeySupportSoftLeft    = 0x00000004,
     * DeviceKeySupportSoftMiddle  = 0x00000008,
     * DeviceKeySupportSoftRight   = 0x00000010,
     * DeviceKeySupportApplication = 0x00000020,
     * DeviceKeySupportOk          = 0x00000040,
     * DeviceKeySupportDelete      = 0x00000080,
     * DeviceKeySupportZoomIn      = 0x00000100,
     * DeviceKeySupportZoomOut     = 0x00000200,
     * DeviceKeySupportClear       = 0x00000400,
     * DeviceKeySupportForward     = 0x00000800,
     * DeviceKeySupportBackward    = 0x00001000,
     * DeviceKeySupportHome        = 0x00002000,
     * DeviceKeySupportSearch      = 0x00004000,
     * DeviceKeySupportMenu        = 0x00008000,
     * DeviceKeySupportALL         = 0x0000ffff
     *
     * @return The value of the field "u32DeviceKeySupport"
     */
    inline uint32 getU32DeviceKeySupport () const;

    /**
     * Sets the value of the member "u32DeviceKeySupport".
     *
     * Informs the Device keys supported.
     * Each bit in 4 bytes( i.e 0xFFFFFFFF) indicates individual Device keys as mentioned below
     * DeviceKeySupportNone	    = 0x00000000,
     * DeviceKeySupportPhoneCall   = 0x00000001,
     * DeviceKeySupportPhoneEnd    = 0x00000002,
     * DeviceKeySupportSoftLeft    = 0x00000004,
     * DeviceKeySupportSoftMiddle  = 0x00000008,
     * DeviceKeySupportSoftRight   = 0x00000010,
     * DeviceKeySupportApplication = 0x00000020,
     * DeviceKeySupportOk          = 0x00000040,
     * DeviceKeySupportDelete      = 0x00000080,
     * DeviceKeySupportZoomIn      = 0x00000100,
     * DeviceKeySupportZoomOut     = 0x00000200,
     * DeviceKeySupportClear       = 0x00000400,
     * DeviceKeySupportForward     = 0x00000800,
     * DeviceKeySupportBackward    = 0x00001000,
     * DeviceKeySupportHome        = 0x00002000,
     * DeviceKeySupportSearch      = 0x00004000,
     * DeviceKeySupportMenu        = 0x00008000,
     * DeviceKeySupportALL         = 0x0000ffff
     *
     * @param u32DeviceKeySupport The value which will be set
     */
    inline void setU32DeviceKeySupport (uint32 u32DeviceKeySupport_);

    // API of field "u32MultimediaKeySupport"

    static const int kU32MultimediaKeySupport = 2;

    /**
     * Clears the field "u32MultimediaKeySupport".
     *
     * The field will be set to its default value. The hasU32MultimediaKeySupport()
     * method will return false.
     */
    inline void clearU32MultimediaKeySupport();

    /**
     * Checks whether the field "u32MultimediaKeySupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MultimediaKeySupport()). Otherwise it will return false.
     */
    inline bool hasU32MultimediaKeySupport () const;

    /**
     * Returns the value of the member "u32MultimediaKeySupport".
     *
     * Informs the Multimedia keys supported.
     * Each bit in 4 bytes( i.e 0xFFFFFFFF) indicates individual Multimedia keys as mentioned below
     * MultimediaKeySupportNone	 = 0x00000000,
     * MultimediaKeySupportPlay     = 0x00000001,
     * MultimediaKeySupportPause    = 0x00000002,
     * MultimediaKeySupportStop     = 0x00000004,
     * MultimediaKeySupportForward  = 0x00000008,
     * MultimediaKeySupportRewind   = 0x00000010,
     * MultimediaKeySupportNext     = 0x00000020,
     * MultimediaKeySupportPrevious = 0x00000040,
     * MultimediaKeySupportMute     = 0x00000080,
     * MultimediaKeySupportUnmute   = 0x00000100,
     * MultimediaKeySupportPhoto    = 0x00000200
     *
     * @return The value of the field "u32MultimediaKeySupport"
     */
    inline uint32 getU32MultimediaKeySupport () const;

    /**
     * Sets the value of the member "u32MultimediaKeySupport".
     *
     * Informs the Multimedia keys supported.
     * Each bit in 4 bytes( i.e 0xFFFFFFFF) indicates individual Multimedia keys as mentioned below
     * MultimediaKeySupportNone	 = 0x00000000,
     * MultimediaKeySupportPlay     = 0x00000001,
     * MultimediaKeySupportPause    = 0x00000002,
     * MultimediaKeySupportStop     = 0x00000004,
     * MultimediaKeySupportForward  = 0x00000008,
     * MultimediaKeySupportRewind   = 0x00000010,
     * MultimediaKeySupportNext     = 0x00000020,
     * MultimediaKeySupportPrevious = 0x00000040,
     * MultimediaKeySupportMute     = 0x00000080,
     * MultimediaKeySupportUnmute   = 0x00000100,
     * MultimediaKeySupportPhoto    = 0x00000200
     *
     * @param u32MultimediaKeySupport The value which will be set
     */
    inline void setU32MultimediaKeySupport (uint32 u32MultimediaKeySupport_);

    // API of field "u32MiscKeySupport"

    static const int kU32MiscKeySupport = 3;

    /**
     * Clears the field "u32MiscKeySupport".
     *
     * The field will be set to its default value. The hasU32MiscKeySupport()
     * method will return false.
     */
    inline void clearU32MiscKeySupport();

    /**
     * Checks whether the field "u32MiscKeySupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MiscKeySupport()). Otherwise it will return false.
     */
    inline bool hasU32MiscKeySupport () const;

    /**
     * Returns the value of the member "u32MiscKeySupport".
     *
     * Informs the ITU, Virtual keyboard and Function keys supported.
     * Each bit in 4 bytes( i.e 0xFFFFFFFF) indicates individual Misc keys as mentioned below
     * MiscKeySupportNone	                 = 0x00000000,
     * MiscKeySupportITU                    = 0x00000001,
     * MiscKeySupportVirtualKeyboardTrigger = 0x00000002,
     * MiscKeySupportKeyEventListing        = 0x00000004,
     * MiscKeySupportEventMapping           = 0x00000008,
     * MiscKeySupportFunctionKey0           = 0x00000100,
     * MiscKeySupportFunctionKey1           = 0x00000200,
     * MiscKeySupportFunctionKey2           = 0x00000400,
     * MiscKeySupportFunctionKey3           = 0x00000800,
     * MiscKeySupportFunctionKey4           = 0x00001000,
     * MiscKeySupportFunctionKey5           = 0x00002000,
     * MiscKeySupportFunctionKey6           = 0x00004000,
     * MiscKeySupportFunctionKey7           = 0x00008000
     *
     * @return The value of the field "u32MiscKeySupport"
     */
    inline uint32 getU32MiscKeySupport () const;

    /**
     * Sets the value of the member "u32MiscKeySupport".
     *
     * Informs the ITU, Virtual keyboard and Function keys supported.
     * Each bit in 4 bytes( i.e 0xFFFFFFFF) indicates individual Misc keys as mentioned below
     * MiscKeySupportNone	                 = 0x00000000,
     * MiscKeySupportITU                    = 0x00000001,
     * MiscKeySupportVirtualKeyboardTrigger = 0x00000002,
     * MiscKeySupportKeyEventListing        = 0x00000004,
     * MiscKeySupportEventMapping           = 0x00000008,
     * MiscKeySupportFunctionKey0           = 0x00000100,
     * MiscKeySupportFunctionKey1           = 0x00000200,
     * MiscKeySupportFunctionKey2           = 0x00000400,
     * MiscKeySupportFunctionKey3           = 0x00000800,
     * MiscKeySupportFunctionKey4           = 0x00001000,
     * MiscKeySupportFunctionKey5           = 0x00002000,
     * MiscKeySupportFunctionKey6           = 0x00004000,
     * MiscKeySupportFunctionKey7           = 0x00008000
     *
     * @param u32MiscKeySupport The value which will be set
     */
    inline void setU32MiscKeySupport (uint32 u32MiscKeySupport_);

    // API of field "u32PointerTouchSupport"

    static const int kU32PointerTouchSupport = 4;

    /**
     * Clears the field "u32PointerTouchSupport".
     *
     * The field will be set to its default value. The hasU32PointerTouchSupport()
     * method will return false.
     */
    inline void clearU32PointerTouchSupport();

    /**
     * Checks whether the field "u32PointerTouchSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PointerTouchSupport()). Otherwise it will return false.
     */
    inline bool hasU32PointerTouchSupport () const;

    /**
     * Returns the value of the member "u32PointerTouchSupport".
     *
     * Informs the Pointer and touch event supported.
     * Each bit in 4 bytes( i.e 0xFFFFFFFF) indicates individual events as mentioned below.
     * PointerSupportPointerEvents               = 0x00000001,
     * PointerSupportTouchEvents                 = 0x00000002,
     * PointerSupportPointerButton1              = 0x00000100,
     * PointerSupportPointerButton2              = 0x00000200,
     * PointerSupportPointerButton3              = 0x00000400,
     * PointerSupportPointerButton4              = 0x00000800,
     * PointerSupportPointerButton5              = 0x00001000,
     * PointerSupportPointerButton6              = 0x00002000,
     * PointerSupportPointerButton7              = 0x00004000,
     * PointerSupportPointerButton8              = 0x00008000,
     * PointerSupportPointerButtonMASK           = 0x0000FF00,
     * PointerSupportTouchCount1                 = 0x00000000,
     * PointerSupportTouchCount2                 = 0x00010000,
     * PointerSupportTouchCount3                 = 0x00020000,
     * PointerSupportTouchCount4                 = 0x00030000,
     * PointerSupportTouchCount5                 = 0x00040000,
     * PointerSupportTouchCount6                 = 0x00050000,
     * PointerSupportTouchCount7                 = 0x00060000,
     * PointerSupportTouchCount8                 = 0x00070000,
     * PointerSupportTouchCount9                 = 0x00080000,
     * PointerSupportTouchCount10                = 0x00090000,
     * PointerSupportTouchCountMASK              = 0x00FF0000
     *
     * For example:
     * A. If HMI supports pointer events(single touch), it can set PointerSupportPointerButtonMASK along with PointerSupportPointerEvents.
     * => (PointerSupportPointerEvents | PointerSupportPointerButtonMASK)
     * B. If HMI supports multi touch (two touch events), it should set the fields PointerSupportTouchCount1 and PointerSupportTouchCount2
     * along with PointerSupportTouchEvents.
     * => (PointerSupportPointerEvents |PointerSupportTouchEvents | PointerSupportPointerButtonMASK | PointerSupportTouchCount1 | PointerSupportTouchCount2).
     *
     * @return The value of the field "u32PointerTouchSupport"
     */
    inline uint32 getU32PointerTouchSupport () const;

    /**
     * Sets the value of the member "u32PointerTouchSupport".
     *
     * Informs the Pointer and touch event supported.
     * Each bit in 4 bytes( i.e 0xFFFFFFFF) indicates individual events as mentioned below.
     * PointerSupportPointerEvents               = 0x00000001,
     * PointerSupportTouchEvents                 = 0x00000002,
     * PointerSupportPointerButton1              = 0x00000100,
     * PointerSupportPointerButton2              = 0x00000200,
     * PointerSupportPointerButton3              = 0x00000400,
     * PointerSupportPointerButton4              = 0x00000800,
     * PointerSupportPointerButton5              = 0x00001000,
     * PointerSupportPointerButton6              = 0x00002000,
     * PointerSupportPointerButton7              = 0x00004000,
     * PointerSupportPointerButton8              = 0x00008000,
     * PointerSupportPointerButtonMASK           = 0x0000FF00,
     * PointerSupportTouchCount1                 = 0x00000000,
     * PointerSupportTouchCount2                 = 0x00010000,
     * PointerSupportTouchCount3                 = 0x00020000,
     * PointerSupportTouchCount4                 = 0x00030000,
     * PointerSupportTouchCount5                 = 0x00040000,
     * PointerSupportTouchCount6                 = 0x00050000,
     * PointerSupportTouchCount7                 = 0x00060000,
     * PointerSupportTouchCount8                 = 0x00070000,
     * PointerSupportTouchCount9                 = 0x00080000,
     * PointerSupportTouchCount10                = 0x00090000,
     * PointerSupportTouchCountMASK              = 0x00FF0000
     *
     * For example:
     * A. If HMI supports pointer events(single touch), it can set PointerSupportPointerButtonMASK along with PointerSupportPointerEvents.
     * => (PointerSupportPointerEvents | PointerSupportPointerButtonMASK)
     * B. If HMI supports multi touch (two touch events), it should set the fields PointerSupportTouchCount1 and PointerSupportTouchCount2
     * along with PointerSupportTouchEvents.
     * => (PointerSupportPointerEvents |PointerSupportTouchEvents | PointerSupportPointerButtonMASK | PointerSupportTouchCount1 | PointerSupportTouchCount2).
     *
     * @param u32PointerTouchSupport The value which will be set
     */
    inline void setU32PointerTouchSupport (uint32 u32PointerTouchSupport_);

    static const T_KeyCapabilities &getDefaultInstance();

private:

    inline void set_has_u32KnobKeySupport ();

    inline void clear_has_u32KnobKeySupport ();

    inline void set_has_u32DeviceKeySupport ();

    inline void clear_has_u32DeviceKeySupport ();

    inline void set_has_u32MultimediaKeySupport ();

    inline void clear_has_u32MultimediaKeySupport ();

    inline void set_has_u32MiscKeySupport ();

    inline void clear_has_u32MiscKeySupport ();

    inline void set_has_u32PointerTouchSupport ();

    inline void clear_has_u32PointerTouchSupport ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _u32KnobKeySupport;

    uint32 _u32DeviceKeySupport;

    uint32 _u32MultimediaKeySupport;

    uint32 _u32MiscKeySupport;

    uint32 _u32PointerTouchSupport;

};

/**
 * This structure contains capabilities of the client
 */
class T_ClientCapabilities {
public:

    /**
     * Default constructor
     */
    inline  T_ClientCapabilities ();

    /**
     * Copy constructor
     */
    inline  T_ClientCapabilities (const T_ClientCapabilities &rhs);

    /**
     * All fields constructor
     */
    inline  T_ClientCapabilities (const T_KeyCapabilities& rKeyCapabilities_);

    /**
     * Destructor
     */
    inline  ~T_ClientCapabilities();

    /**
     * Assignment operator
     */
    inline T_ClientCapabilities& operator = (const T_ClientCapabilities& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ClientCapabilities& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ClientCapabilities& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ClientCapabilities& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ClientCapabilities& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rKeyCapabilities"

    static const int kRKeyCapabilities = 0;

    /**
     * Clears the field "rKeyCapabilities".
     *
     * The field will be set to its default value. The hasRKeyCapabilities()
     * method will return false.
     */
    inline void clearRKeyCapabilities();

    /**
     * Checks whether the field "rKeyCapabilities" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRKeyCapabilities()). Otherwise it will return false.
     */
    inline bool hasRKeyCapabilities () const;

    /**
     * Returns the value of the member "rKeyCapabilities".
     *
     * Provides Key Capabilities
     *
     * @return The value of the field "rKeyCapabilities"
     */
    inline const T_KeyCapabilities& getRKeyCapabilities () const;

    /**
     * Retrieves the value of the field "rKeyCapabilities" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rKeyCapabilities".
     */
    inline T_KeyCapabilities& getRKeyCapabilitiesMutable ();

    /**
     * Sets the value of the member "rKeyCapabilities".
     *
     * Provides Key Capabilities
     *
     * @param rKeyCapabilities The value which will be set
     */
    inline void setRKeyCapabilities (const T_KeyCapabilities& rKeyCapabilities_);

    static const T_ClientCapabilities &getDefaultInstance();

private:

    inline void set_has_rKeyCapabilities ();

    inline void clear_has_rKeyCapabilities ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_KeyCapabilities _rKeyCapabilities;

};

/**
 * This structure provides detailed information of X_DeviceKeys supported by server.
 * This can include keys as such as X11, ITU, knob, device, multimedia and function keys as defined in
 * CCC-TS-010. From more details about X_devicekeys refer CCC-TS-030
 */
class T_XDeviceKeys {
public:

    /**
     * Default constructor
     */
    inline  T_XDeviceKeys ();

    /**
     * Copy constructor
     */
    inline  T_XDeviceKeys (const T_XDeviceKeys &rhs);

    /**
     * All fields constructor
     */
    inline  T_XDeviceKeys (const ::std::string& szName_, bool bMandatory_, T_e32_KeyCode e32SymbolValue_, const ::std::vector< T_IconAttributes >& IconList_);

    /**
     * Destructor
     */
    inline  ~T_XDeviceKeys();

    /**
     * Assignment operator
     */
    inline T_XDeviceKeys& operator = (const T_XDeviceKeys& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_XDeviceKeys& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_XDeviceKeys& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_XDeviceKeys& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_XDeviceKeys& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szName"

    static const int kSzName = 0;

    /**
     * Clears the field "szName".
     *
     * The field will be set to its default value. The hasSzName()
     * method will return false.
     */
    inline void clearSzName();

    /**
     * Checks whether the field "szName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzName()). Otherwise it will return false.
     */
    inline bool hasSzName () const;

    /**
     * Returns the value of the member "szName".
     *
     * Name of the key. It can be used, if icon is not available or shown
     *
     * @return The value of the field "szName"
     */
    inline const ::std::string& getSzName () const;

    /**
     * Retrieves the value of the field "szName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szName".
     */
    inline ::std::string& getSzNameMutable ();

    /**
     * Sets the value of the member "szName".
     *
     * Name of the key. It can be used, if icon is not available or shown
     *
     * @param szName The value which will be set
     */
    inline void setSzName (const ::std::string& szName_);

    /**
     * Sets the value of the member "szName".
     *
     * Name of the key. It can be used, if icon is not available or shown
     *
     * @param szName The value which will be set
     */
    inline void setSzName (const char* szName_);

    /**
     * Sets the value of the member "szName".
     *
     * Name of the key. It can be used, if icon is not available or shown
     *
     * @param szName The value which will be set
     */
    inline void setSzName (const char* value, size_t size);

    // API of field "bMandatory"

    static const int kBMandatory = 1;

    /**
     * Clears the field "bMandatory".
     *
     * The field will be set to its default value. The hasBMandatory()
     * method will return false.
     */
    inline void clearBMandatory();

    /**
     * Checks whether the field "bMandatory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMandatory()). Otherwise it will return false.
     */
    inline bool hasBMandatory () const;

    /**
     * Returns the value of the member "bMandatory".
     *
     * Indicates whether HU support is mandatory.
     * Default value will be FALSE(0).
     *
     * @return The value of the field "bMandatory"
     */
    inline bool getBMandatory () const;

    /**
     * Sets the value of the member "bMandatory".
     *
     * Indicates whether HU support is mandatory.
     * Default value will be FALSE(0).
     *
     * @param bMandatory The value which will be set
     */
    inline void setBMandatory (bool bMandatory_);

    // API of field "e32SymbolValue"

    static const int kE32SymbolValue = 2;

    /**
     * Clears the field "e32SymbolValue".
     *
     * The field will be set to its default value. The hasE32SymbolValue()
     * method will return false.
     */
    inline void clearE32SymbolValue();

    /**
     * Checks whether the field "e32SymbolValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE32SymbolValue()). Otherwise it will return false.
     */
    inline bool hasE32SymbolValue () const;

    /**
     * Returns the value of the member "e32SymbolValue".
     *
     * SPI receives symbol value as per CCC spec CCC-TS-010 (appendix B).
     * SPI will convert this to T_e32_KeyCode, so that HMI can use the same key code when requesting through send key events.
     *
     * @return The value of the field "e32SymbolValue"
     */
    inline T_e32_KeyCode getE32SymbolValue () const;

    /**
     * Sets the value of the member "e32SymbolValue".
     *
     * SPI receives symbol value as per CCC spec CCC-TS-010 (appendix B).
     * SPI will convert this to T_e32_KeyCode, so that HMI can use the same key code when requesting through send key events.
     *
     * @param e32SymbolValue The value which will be set
     */
    inline void setE32SymbolValue (T_e32_KeyCode e32SymbolValue_);

    // API of field "IconList"

    static const int kIconList = 3;

    /**
     * Clears the field "IconList".
     *
     * The field will be set to its default value. The hasIconList()
     * method will return false.
     */
    inline void clearIconList();

    /**
     * Checks whether the field "IconList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIconList()). Otherwise it will return false.
     */
    inline bool hasIconList () const;

    /**
     * Returns the value of the member "IconList".
     *
     * Information the Details of Key icons
     *
     * @return The value of the field "IconList"
     */
    inline const ::std::vector< T_IconAttributes >& getIconList () const;

    /**
     * Retrieves the value of the field "IconList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IconList".
     */
    inline ::std::vector< T_IconAttributes >& getIconListMutable ();

    /**
     * Sets the value of the member "IconList".
     *
     * Information the Details of Key icons
     *
     * @param IconList The value which will be set
     */
    inline void setIconList (const ::std::vector< T_IconAttributes >& IconList_);

    static const T_XDeviceKeys &getDefaultInstance();

private:

    static const ::std::vector< T_IconAttributes >& getT_IconAttributesList_DefaultInstance ();

    inline void set_has_szName ();

    inline void clear_has_szName ();

    inline void set_has_bMandatory ();

    inline void clear_has_bMandatory ();

    inline void set_has_e32SymbolValue ();

    inline void clear_has_e32SymbolValue ();

    inline void set_has_IconList ();

    inline void clear_has_IconList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _szName;

    bool _bMandatory;

    T_e32_KeyCode _e32SymbolValue;

    ::std::vector< T_IconAttributes > _IconList;

};

/**
 * This structure contains Audio Capabilities
 */
class T_AudioCapabilities {
public:

    /**
     * Default constructor
     */
    inline  T_AudioCapabilities ();

    /**
     * Copy constructor
     */
    inline  T_AudioCapabilities (const T_AudioCapabilities &rhs);

    /**
     * All fields constructor
     */
    inline  T_AudioCapabilities (uint16 u16BTHFPSupport_, uint16 u16BTA2DPSupport_, uint16 u16RTPInSupport_, uint16 u16RTPOutSupport_);

    /**
     * Destructor
     */
    inline  ~T_AudioCapabilities();

    /**
     * Assignment operator
     */
    inline T_AudioCapabilities& operator = (const T_AudioCapabilities& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AudioCapabilities& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AudioCapabilities& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AudioCapabilities& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AudioCapabilities& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16BTHFPSupport"

    static const int kU16BTHFPSupport = 0;

    /**
     * Clears the field "u16BTHFPSupport".
     *
     * The field will be set to its default value. The hasU16BTHFPSupport()
     * method will return false.
     */
    inline void clearU16BTHFPSupport();

    /**
     * Checks whether the field "u16BTHFPSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16BTHFPSupport()). Otherwise it will return false.
     */
    inline bool hasU16BTHFPSupport () const;

    /**
     * Returns the value of the member "u16BTHFPSupport".
     *
     * Contains Bluetooth HFP support information
     *
     * @return The value of the field "u16BTHFPSupport"
     */
    inline uint16 getU16BTHFPSupport () const;

    /**
     * Sets the value of the member "u16BTHFPSupport".
     *
     * Contains Bluetooth HFP support information
     *
     * @param u16BTHFPSupport The value which will be set
     */
    inline void setU16BTHFPSupport (uint16 u16BTHFPSupport_);

    // API of field "u16BTA2DPSupport"

    static const int kU16BTA2DPSupport = 1;

    /**
     * Clears the field "u16BTA2DPSupport".
     *
     * The field will be set to its default value. The hasU16BTA2DPSupport()
     * method will return false.
     */
    inline void clearU16BTA2DPSupport();

    /**
     * Checks whether the field "u16BTA2DPSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16BTA2DPSupport()). Otherwise it will return false.
     */
    inline bool hasU16BTA2DPSupport () const;

    /**
     * Returns the value of the member "u16BTA2DPSupport".
     *
     * Contains Bluetooth A2DP support information
     *
     * @return The value of the field "u16BTA2DPSupport"
     */
    inline uint16 getU16BTA2DPSupport () const;

    /**
     * Sets the value of the member "u16BTA2DPSupport".
     *
     * Contains Bluetooth A2DP support information
     *
     * @param u16BTA2DPSupport The value which will be set
     */
    inline void setU16BTA2DPSupport (uint16 u16BTA2DPSupport_);

    // API of field "u16RTPInSupport"

    static const int kU16RTPInSupport = 2;

    /**
     * Clears the field "u16RTPInSupport".
     *
     * The field will be set to its default value. The hasU16RTPInSupport()
     * method will return false.
     */
    inline void clearU16RTPInSupport();

    /**
     * Checks whether the field "u16RTPInSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RTPInSupport()). Otherwise it will return false.
     */
    inline bool hasU16RTPInSupport () const;

    /**
     * Returns the value of the member "u16RTPInSupport".
     *
     * Contains RTPIn support information
     *
     * @return The value of the field "u16RTPInSupport"
     */
    inline uint16 getU16RTPInSupport () const;

    /**
     * Sets the value of the member "u16RTPInSupport".
     *
     * Contains RTPIn support information
     *
     * @param u16RTPInSupport The value which will be set
     */
    inline void setU16RTPInSupport (uint16 u16RTPInSupport_);

    // API of field "u16RTPOutSupport"

    static const int kU16RTPOutSupport = 3;

    /**
     * Clears the field "u16RTPOutSupport".
     *
     * The field will be set to its default value. The hasU16RTPOutSupport()
     * method will return false.
     */
    inline void clearU16RTPOutSupport();

    /**
     * Checks whether the field "u16RTPOutSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RTPOutSupport()). Otherwise it will return false.
     */
    inline bool hasU16RTPOutSupport () const;

    /**
     * Returns the value of the member "u16RTPOutSupport".
     *
     * Contains RTPOut support information
     *
     * @return The value of the field "u16RTPOutSupport"
     */
    inline uint16 getU16RTPOutSupport () const;

    /**
     * Sets the value of the member "u16RTPOutSupport".
     *
     * Contains RTPOut support information
     *
     * @param u16RTPOutSupport The value which will be set
     */
    inline void setU16RTPOutSupport (uint16 u16RTPOutSupport_);

    static const T_AudioCapabilities &getDefaultInstance();

private:

    inline void set_has_u16BTHFPSupport ();

    inline void clear_has_u16BTHFPSupport ();

    inline void set_has_u16BTA2DPSupport ();

    inline void clear_has_u16BTA2DPSupport ();

    inline void set_has_u16RTPInSupport ();

    inline void clear_has_u16RTPInSupport ();

    inline void set_has_u16RTPOutSupport ();

    inline void clear_has_u16RTPOutSupport ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _u16BTHFPSupport;

    uint16 _u16BTA2DPSupport;

    uint16 _u16RTPInSupport;

    uint16 _u16RTPOutSupport;

};

/**
 * This structure contains Display Capabilities
 */
class T_DisplayCapabilities {
public:

    /**
     * Default constructor
     */
    inline  T_DisplayCapabilities ();

    /**
     * Copy constructor
     */
    inline  T_DisplayCapabilities (const T_DisplayCapabilities &rhs);

    /**
     * All fields constructor
     */
    inline  T_DisplayCapabilities (uint16 u16FrameBufferConfiguration_, uint16 u16PixelFormat_);

    /**
     * Destructor
     */
    inline  ~T_DisplayCapabilities();

    /**
     * Assignment operator
     */
    inline T_DisplayCapabilities& operator = (const T_DisplayCapabilities& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DisplayCapabilities& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DisplayCapabilities& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DisplayCapabilities& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DisplayCapabilities& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16FrameBufferConfiguration"

    static const int kU16FrameBufferConfiguration = 0;

    /**
     * Clears the field "u16FrameBufferConfiguration".
     *
     * The field will be set to its default value. The hasU16FrameBufferConfiguration()
     * method will return false.
     */
    inline void clearU16FrameBufferConfiguration();

    /**
     * Checks whether the field "u16FrameBufferConfiguration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FrameBufferConfiguration()). Otherwise it will return false.
     */
    inline bool hasU16FrameBufferConfiguration () const;

    /**
     * Returns the value of the member "u16FrameBufferConfiguration".
     *
     * Indicates the Supported Frame Buffer configuration data
     *
     * @return The value of the field "u16FrameBufferConfiguration"
     */
    inline uint16 getU16FrameBufferConfiguration () const;

    /**
     * Sets the value of the member "u16FrameBufferConfiguration".
     *
     * Indicates the Supported Frame Buffer configuration data
     *
     * @param u16FrameBufferConfiguration The value which will be set
     */
    inline void setU16FrameBufferConfiguration (uint16 u16FrameBufferConfiguration_);

    // API of field "u16PixelFormat"

    static const int kU16PixelFormat = 1;

    /**
     * Clears the field "u16PixelFormat".
     *
     * The field will be set to its default value. The hasU16PixelFormat()
     * method will return false.
     */
    inline void clearU16PixelFormat();

    /**
     * Checks whether the field "u16PixelFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PixelFormat()). Otherwise it will return false.
     */
    inline bool hasU16PixelFormat () const;

    /**
     * Returns the value of the member "u16PixelFormat".
     *
     * Indicates the Supported Pixel Formats
     *
     * @return The value of the field "u16PixelFormat"
     */
    inline uint16 getU16PixelFormat () const;

    /**
     * Sets the value of the member "u16PixelFormat".
     *
     * Indicates the Supported Pixel Formats
     *
     * @param u16PixelFormat The value which will be set
     */
    inline void setU16PixelFormat (uint16 u16PixelFormat_);

    static const T_DisplayCapabilities &getDefaultInstance();

private:

    inline void set_has_u16FrameBufferConfiguration ();

    inline void clear_has_u16FrameBufferConfiguration ();

    inline void set_has_u16PixelFormat ();

    inline void clear_has_u16PixelFormat ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16FrameBufferConfiguration;

    uint16 _u16PixelFormat;

};

/**
 * This structure contains application specific metadata information
 */
class T_ApplicationMediaMetaData {
public:

    /**
     * Default constructor
     */
    inline  T_ApplicationMediaMetaData ();

    /**
     * Copy constructor
     */
    inline  T_ApplicationMediaMetaData (const T_ApplicationMediaMetaData &rhs);

    /**
     * All fields constructor
     */
    inline  T_ApplicationMediaMetaData (const ::std::string& AppName_, const ::std::string& Title_, const ::std::string& Artist_, const ::std::string& Album_, const ::std::string& AlbumArtist_, const ::std::string& Genre_, const ::std::string& Composer_, uint32 TrackNumber_, uint32 AlbumTrackCount_, uint32 AlbumDiscNumber_, uint32 AlbumDiscCount_, uint32 ChapterCount_, uint32 u32QueueIndex_, uint32 u32QueueCount_, const ::std::string& ImageMIMEType_, uint32 ImageSize_, const ::std::string& ImageUrl_, const ::std::vector< uint8 >& oImageData_, T_e8_PlayBackState PlayBackState_, T_e8_PlayBackShuffleState ShuffleState_, T_e8_PlayBackRepeatState RepeatState_, T_e8_PlayBackMediaType MediaType_, bool iTunesRadioAd_, const ::std::string& iTunesRadioStationName_, uint8 MediaRating_);

    /**
     * Destructor
     */
    inline  ~T_ApplicationMediaMetaData();

    /**
     * Assignment operator
     */
    inline T_ApplicationMediaMetaData& operator = (const T_ApplicationMediaMetaData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ApplicationMediaMetaData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ApplicationMediaMetaData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ApplicationMediaMetaData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ApplicationMediaMetaData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AppName"

    static const int kAppName = 0;

    /**
     * Clears the field "AppName".
     *
     * The field will be set to its default value. The hasAppName()
     * method will return false.
     */
    inline void clearAppName();

    /**
     * Checks whether the field "AppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppName()). Otherwise it will return false.
     */
    inline bool hasAppName () const;

    /**
     * Returns the value of the member "AppName".
     *
     * Name of now playing application.  Set to NULL, zero length string, if not valid.
     *
     * @return The value of the field "AppName"
     */
    inline const ::std::string& getAppName () const;

    /**
     * Retrieves the value of the field "AppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AppName".
     */
    inline ::std::string& getAppNameMutable ();

    /**
     * Sets the value of the member "AppName".
     *
     * Name of now playing application.  Set to NULL, zero length string, if not valid.
     *
     * @param AppName The value which will be set
     */
    inline void setAppName (const ::std::string& AppName_);

    /**
     * Sets the value of the member "AppName".
     *
     * Name of now playing application.  Set to NULL, zero length string, if not valid.
     *
     * @param AppName The value which will be set
     */
    inline void setAppName (const char* AppName_);

    /**
     * Sets the value of the member "AppName".
     *
     * Name of now playing application.  Set to NULL, zero length string, if not valid.
     *
     * @param AppName The value which will be set
     */
    inline void setAppName (const char* value, size_t size);

    // API of field "Title"

    static const int kTitle = 1;

    /**
     * Clears the field "Title".
     *
     * The field will be set to its default value. The hasTitle()
     * method will return false.
     */
    inline void clearTitle();

    /**
     * Checks whether the field "Title" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTitle()). Otherwise it will return false.
     */
    inline bool hasTitle () const;

    /**
     * Returns the value of the member "Title".
     *
     * Title of the currently active song. Set to NULL, zero length string, if not valid.
     *
     * @return The value of the field "Title"
     */
    inline const ::std::string& getTitle () const;

    /**
     * Retrieves the value of the field "Title" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Title".
     */
    inline ::std::string& getTitleMutable ();

    /**
     * Sets the value of the member "Title".
     *
     * Title of the currently active song. Set to NULL, zero length string, if not valid.
     *
     * @param Title The value which will be set
     */
    inline void setTitle (const ::std::string& Title_);

    /**
     * Sets the value of the member "Title".
     *
     * Title of the currently active song. Set to NULL, zero length string, if not valid.
     *
     * @param Title The value which will be set
     */
    inline void setTitle (const char* Title_);

    /**
     * Sets the value of the member "Title".
     *
     * Title of the currently active song. Set to NULL, zero length string, if not valid.
     *
     * @param Title The value which will be set
     */
    inline void setTitle (const char* value, size_t size);

    // API of field "Artist"

    static const int kArtist = 2;

    /**
     * Clears the field "Artist".
     *
     * The field will be set to its default value. The hasArtist()
     * method will return false.
     */
    inline void clearArtist();

    /**
     * Checks whether the field "Artist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArtist()). Otherwise it will return false.
     */
    inline bool hasArtist () const;

    /**
     * Returns the value of the member "Artist".
     *
     * Name of the artist associated with currently active application (audio/ video). Set to NULL, zero length string, if not valid.
     *
     * @return The value of the field "Artist"
     */
    inline const ::std::string& getArtist () const;

    /**
     * Retrieves the value of the field "Artist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Artist".
     */
    inline ::std::string& getArtistMutable ();

    /**
     * Sets the value of the member "Artist".
     *
     * Name of the artist associated with currently active application (audio/ video). Set to NULL, zero length string, if not valid.
     *
     * @param Artist The value which will be set
     */
    inline void setArtist (const ::std::string& Artist_);

    /**
     * Sets the value of the member "Artist".
     *
     * Name of the artist associated with currently active application (audio/ video). Set to NULL, zero length string, if not valid.
     *
     * @param Artist The value which will be set
     */
    inline void setArtist (const char* Artist_);

    /**
     * Sets the value of the member "Artist".
     *
     * Name of the artist associated with currently active application (audio/ video). Set to NULL, zero length string, if not valid.
     *
     * @param Artist The value which will be set
     */
    inline void setArtist (const char* value, size_t size);

    // API of field "Album"

    static const int kAlbum = 3;

    /**
     * Clears the field "Album".
     *
     * The field will be set to its default value. The hasAlbum()
     * method will return false.
     */
    inline void clearAlbum();

    /**
     * Checks whether the field "Album" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlbum()). Otherwise it will return false.
     */
    inline bool hasAlbum () const;

    /**
     * Returns the value of the member "Album".
     *
     * Name of the album associated with the currently active application audio/video content. Set to NULL if not valid
     *
     * @return The value of the field "Album"
     */
    inline const ::std::string& getAlbum () const;

    /**
     * Retrieves the value of the field "Album" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Album".
     */
    inline ::std::string& getAlbumMutable ();

    /**
     * Sets the value of the member "Album".
     *
     * Name of the album associated with the currently active application audio/video content. Set to NULL if not valid
     *
     * @param Album The value which will be set
     */
    inline void setAlbum (const ::std::string& Album_);

    /**
     * Sets the value of the member "Album".
     *
     * Name of the album associated with the currently active application audio/video content. Set to NULL if not valid
     *
     * @param Album The value which will be set
     */
    inline void setAlbum (const char* Album_);

    /**
     * Sets the value of the member "Album".
     *
     * Name of the album associated with the currently active application audio/video content. Set to NULL if not valid
     *
     * @param Album The value which will be set
     */
    inline void setAlbum (const char* value, size_t size);

    // API of field "AlbumArtist"

    static const int kAlbumArtist = 4;

    /**
     * Clears the field "AlbumArtist".
     *
     * The field will be set to its default value. The hasAlbumArtist()
     * method will return false.
     */
    inline void clearAlbumArtist();

    /**
     * Checks whether the field "AlbumArtist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlbumArtist()). Otherwise it will return false.
     */
    inline bool hasAlbumArtist () const;

    /**
     * Returns the value of the member "AlbumArtist".
     *
     * Name of Album Artist of now playing song.  Set to NULL, zero length string, if not valid.
     *
     * @return The value of the field "AlbumArtist"
     */
    inline const ::std::string& getAlbumArtist () const;

    /**
     * Retrieves the value of the field "AlbumArtist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlbumArtist".
     */
    inline ::std::string& getAlbumArtistMutable ();

    /**
     * Sets the value of the member "AlbumArtist".
     *
     * Name of Album Artist of now playing song.  Set to NULL, zero length string, if not valid.
     *
     * @param AlbumArtist The value which will be set
     */
    inline void setAlbumArtist (const ::std::string& AlbumArtist_);

    /**
     * Sets the value of the member "AlbumArtist".
     *
     * Name of Album Artist of now playing song.  Set to NULL, zero length string, if not valid.
     *
     * @param AlbumArtist The value which will be set
     */
    inline void setAlbumArtist (const char* AlbumArtist_);

    /**
     * Sets the value of the member "AlbumArtist".
     *
     * Name of Album Artist of now playing song.  Set to NULL, zero length string, if not valid.
     *
     * @param AlbumArtist The value which will be set
     */
    inline void setAlbumArtist (const char* value, size_t size);

    // API of field "Genre"

    static const int kGenre = 5;

    /**
     * Clears the field "Genre".
     *
     * The field will be set to its default value. The hasGenre()
     * method will return false.
     */
    inline void clearGenre();

    /**
     * Checks whether the field "Genre" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGenre()). Otherwise it will return false.
     */
    inline bool hasGenre () const;

    /**
     * Returns the value of the member "Genre".
     *
     * Genre associated with currently active application audio/ video content. Set to NULL if not valid
     *
     * @return The value of the field "Genre"
     */
    inline const ::std::string& getGenre () const;

    /**
     * Retrieves the value of the field "Genre" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Genre".
     */
    inline ::std::string& getGenreMutable ();

    /**
     * Sets the value of the member "Genre".
     *
     * Genre associated with currently active application audio/ video content. Set to NULL if not valid
     *
     * @param Genre The value which will be set
     */
    inline void setGenre (const ::std::string& Genre_);

    /**
     * Sets the value of the member "Genre".
     *
     * Genre associated with currently active application audio/ video content. Set to NULL if not valid
     *
     * @param Genre The value which will be set
     */
    inline void setGenre (const char* Genre_);

    /**
     * Sets the value of the member "Genre".
     *
     * Genre associated with currently active application audio/ video content. Set to NULL if not valid
     *
     * @param Genre The value which will be set
     */
    inline void setGenre (const char* value, size_t size);

    // API of field "Composer"

    static const int kComposer = 6;

    /**
     * Clears the field "Composer".
     *
     * The field will be set to its default value. The hasComposer()
     * method will return false.
     */
    inline void clearComposer();

    /**
     * Checks whether the field "Composer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setComposer()). Otherwise it will return false.
     */
    inline bool hasComposer () const;

    /**
     * Returns the value of the member "Composer".
     *
     * Name of the composer. Set to NULL, if not available.
     *
     * @return The value of the field "Composer"
     */
    inline const ::std::string& getComposer () const;

    /**
     * Retrieves the value of the field "Composer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Composer".
     */
    inline ::std::string& getComposerMutable ();

    /**
     * Sets the value of the member "Composer".
     *
     * Name of the composer. Set to NULL, if not available.
     *
     * @param Composer The value which will be set
     */
    inline void setComposer (const ::std::string& Composer_);

    /**
     * Sets the value of the member "Composer".
     *
     * Name of the composer. Set to NULL, if not available.
     *
     * @param Composer The value which will be set
     */
    inline void setComposer (const char* Composer_);

    /**
     * Sets the value of the member "Composer".
     *
     * Name of the composer. Set to NULL, if not available.
     *
     * @param Composer The value which will be set
     */
    inline void setComposer (const char* value, size_t size);

    // API of field "TrackNumber"

    static const int kTrackNumber = 7;

    /**
     * Clears the field "TrackNumber".
     *
     * The field will be set to its default value. The hasTrackNumber()
     * method will return false.
     */
    inline void clearTrackNumber();

    /**
     * Checks whether the field "TrackNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrackNumber()). Otherwise it will return false.
     */
    inline bool hasTrackNumber () const;

    /**
     * Returns the value of the member "TrackNumber".
     *
     * Track number of the currently playing Album. Set to 0xFFFFFFFF, if not valid.
     *
     * @return The value of the field "TrackNumber"
     */
    inline uint32 getTrackNumber () const;

    /**
     * Sets the value of the member "TrackNumber".
     *
     * Track number of the currently playing Album. Set to 0xFFFFFFFF, if not valid.
     *
     * @param TrackNumber The value which will be set
     */
    inline void setTrackNumber (uint32 TrackNumber_);

    // API of field "AlbumTrackCount"

    static const int kAlbumTrackCount = 8;

    /**
     * Clears the field "AlbumTrackCount".
     *
     * The field will be set to its default value. The hasAlbumTrackCount()
     * method will return false.
     */
    inline void clearAlbumTrackCount();

    /**
     * Checks whether the field "AlbumTrackCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlbumTrackCount()). Otherwise it will return false.
     */
    inline bool hasAlbumTrackCount () const;

    /**
     * Returns the value of the member "AlbumTrackCount".
     *
     * Indicates Album Track count. Set to 0xFFFFFFFF, if not valid.
     *
     * @return The value of the field "AlbumTrackCount"
     */
    inline uint32 getAlbumTrackCount () const;

    /**
     * Sets the value of the member "AlbumTrackCount".
     *
     * Indicates Album Track count. Set to 0xFFFFFFFF, if not valid.
     *
     * @param AlbumTrackCount The value which will be set
     */
    inline void setAlbumTrackCount (uint32 AlbumTrackCount_);

    // API of field "AlbumDiscNumber"

    static const int kAlbumDiscNumber = 9;

    /**
     * Clears the field "AlbumDiscNumber".
     *
     * The field will be set to its default value. The hasAlbumDiscNumber()
     * method will return false.
     */
    inline void clearAlbumDiscNumber();

    /**
     * Checks whether the field "AlbumDiscNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlbumDiscNumber()). Otherwise it will return false.
     */
    inline bool hasAlbumDiscNumber () const;

    /**
     * Returns the value of the member "AlbumDiscNumber".
     *
     * Indicates Album DiscNumber that is currently playing. Set to 0xFFFFFFFF, if not valid.
     *
     * @return The value of the field "AlbumDiscNumber"
     */
    inline uint32 getAlbumDiscNumber () const;

    /**
     * Sets the value of the member "AlbumDiscNumber".
     *
     * Indicates Album DiscNumber that is currently playing. Set to 0xFFFFFFFF, if not valid.
     *
     * @param AlbumDiscNumber The value which will be set
     */
    inline void setAlbumDiscNumber (uint32 AlbumDiscNumber_);

    // API of field "AlbumDiscCount"

    static const int kAlbumDiscCount = 10;

    /**
     * Clears the field "AlbumDiscCount".
     *
     * The field will be set to its default value. The hasAlbumDiscCount()
     * method will return false.
     */
    inline void clearAlbumDiscCount();

    /**
     * Checks whether the field "AlbumDiscCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlbumDiscCount()). Otherwise it will return false.
     */
    inline bool hasAlbumDiscCount () const;

    /**
     * Returns the value of the member "AlbumDiscCount".
     *
     * Indicates Album Disc count. Set to 0xFFFFFFFF, if not valid.
     *
     * @return The value of the field "AlbumDiscCount"
     */
    inline uint32 getAlbumDiscCount () const;

    /**
     * Sets the value of the member "AlbumDiscCount".
     *
     * Indicates Album Disc count. Set to 0xFFFFFFFF, if not valid.
     *
     * @param AlbumDiscCount The value which will be set
     */
    inline void setAlbumDiscCount (uint32 AlbumDiscCount_);

    // API of field "ChapterCount"

    static const int kChapterCount = 11;

    /**
     * Clears the field "ChapterCount".
     *
     * The field will be set to its default value. The hasChapterCount()
     * method will return false.
     */
    inline void clearChapterCount();

    /**
     * Checks whether the field "ChapterCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChapterCount()). Otherwise it will return false.
     */
    inline bool hasChapterCount () const;

    /**
     * Returns the value of the member "ChapterCount".
     *
     * Indicates chapter count of audio book. Set to 0xFFFFFFFF, if not valid.
     *
     * @return The value of the field "ChapterCount"
     */
    inline uint32 getChapterCount () const;

    /**
     * Sets the value of the member "ChapterCount".
     *
     * Indicates chapter count of audio book. Set to 0xFFFFFFFF, if not valid.
     *
     * @param ChapterCount The value which will be set
     */
    inline void setChapterCount (uint32 ChapterCount_);

    // API of field "u32QueueIndex"

    static const int kU32QueueIndex = 12;

    /**
     * Clears the field "u32QueueIndex".
     *
     * The field will be set to its default value. The hasU32QueueIndex()
     * method will return false.
     */
    inline void clearU32QueueIndex();

    /**
     * Checks whether the field "u32QueueIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32QueueIndex()). Otherwise it will return false.
     */
    inline bool hasU32QueueIndex () const;

    /**
     * Returns the value of the member "u32QueueIndex".
     *
     * current playing list track number. Set to 0xFFFFFFFF, if not valid.
     *
     * @return The value of the field "u32QueueIndex"
     */
    inline uint32 getU32QueueIndex () const;

    /**
     * Sets the value of the member "u32QueueIndex".
     *
     * current playing list track number. Set to 0xFFFFFFFF, if not valid.
     *
     * @param u32QueueIndex The value which will be set
     */
    inline void setU32QueueIndex (uint32 u32QueueIndex_);

    // API of field "u32QueueCount"

    static const int kU32QueueCount = 13;

    /**
     * Clears the field "u32QueueCount".
     *
     * The field will be set to its default value. The hasU32QueueCount()
     * method will return false.
     */
    inline void clearU32QueueCount();

    /**
     * Checks whether the field "u32QueueCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32QueueCount()). Otherwise it will return false.
     */
    inline bool hasU32QueueCount () const;

    /**
     * Returns the value of the member "u32QueueCount".
     *
     * current playing list track count. Set to 0xFFFFFFFF, if not valid.
     *
     * @return The value of the field "u32QueueCount"
     */
    inline uint32 getU32QueueCount () const;

    /**
     * Sets the value of the member "u32QueueCount".
     *
     * current playing list track count. Set to 0xFFFFFFFF, if not valid.
     *
     * @param u32QueueCount The value which will be set
     */
    inline void setU32QueueCount (uint32 u32QueueCount_);

    // API of field "ImageMIMEType"

    static const int kImageMIMEType = 14;

    /**
     * Clears the field "ImageMIMEType".
     *
     * The field will be set to its default value. The hasImageMIMEType()
     * method will return false.
     */
    inline void clearImageMIMEType();

    /**
     * Checks whether the field "ImageMIMEType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageMIMEType()). Otherwise it will return false.
     */
    inline bool hasImageMIMEType () const;

    /**
     * Returns the value of the member "ImageMIMEType".
     *
     * MIME type of the image pointed by ImageUrl. Set to NULL, zero length string, if ImageUrl is NULL
     *
     * @return The value of the field "ImageMIMEType"
     */
    inline const ::std::string& getImageMIMEType () const;

    /**
     * Retrieves the value of the field "ImageMIMEType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ImageMIMEType".
     */
    inline ::std::string& getImageMIMETypeMutable ();

    /**
     * Sets the value of the member "ImageMIMEType".
     *
     * MIME type of the image pointed by ImageUrl. Set to NULL, zero length string, if ImageUrl is NULL
     *
     * @param ImageMIMEType The value which will be set
     */
    inline void setImageMIMEType (const ::std::string& ImageMIMEType_);

    /**
     * Sets the value of the member "ImageMIMEType".
     *
     * MIME type of the image pointed by ImageUrl. Set to NULL, zero length string, if ImageUrl is NULL
     *
     * @param ImageMIMEType The value which will be set
     */
    inline void setImageMIMEType (const char* ImageMIMEType_);

    /**
     * Sets the value of the member "ImageMIMEType".
     *
     * MIME type of the image pointed by ImageUrl. Set to NULL, zero length string, if ImageUrl is NULL
     *
     * @param ImageMIMEType The value which will be set
     */
    inline void setImageMIMEType (const char* value, size_t size);

    // API of field "ImageSize"

    static const int kImageSize = 15;

    /**
     * Clears the field "ImageSize".
     *
     * The field will be set to its default value. The hasImageSize()
     * method will return false.
     */
    inline void clearImageSize();

    /**
     * Checks whether the field "ImageSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageSize()). Otherwise it will return false.
     */
    inline bool hasImageSize () const;

    /**
     * Returns the value of the member "ImageSize".
     *
     * Image size in bytes. Set to 0, if no image data available.
     *
     * @return The value of the field "ImageSize"
     */
    inline uint32 getImageSize () const;

    /**
     * Sets the value of the member "ImageSize".
     *
     * Image size in bytes. Set to 0, if no image data available.
     *
     * @param ImageSize The value which will be set
     */
    inline void setImageSize (uint32 ImageSize_);

    // API of field "ImageUrl"

    static const int kImageUrl = 16;

    /**
     * Clears the field "ImageUrl".
     *
     * The field will be set to its default value. The hasImageUrl()
     * method will return false.
     */
    inline void clearImageUrl();

    /**
     * Checks whether the field "ImageUrl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageUrl()). Otherwise it will return false.
     */
    inline bool hasImageUrl () const;

    /**
     * Returns the value of the member "ImageUrl".
     *
     * Scope: CarPlay
     * URL for image data associated with an application. Actual Image should be got from GetMediaObjectAlbumArt
     *
     * @return The value of the field "ImageUrl"
     */
    inline const ::std::string& getImageUrl () const;

    /**
     * Retrieves the value of the field "ImageUrl" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ImageUrl".
     */
    inline ::std::string& getImageUrlMutable ();

    /**
     * Sets the value of the member "ImageUrl".
     *
     * Scope: CarPlay
     * URL for image data associated with an application. Actual Image should be got from GetMediaObjectAlbumArt
     *
     * @param ImageUrl The value which will be set
     */
    inline void setImageUrl (const ::std::string& ImageUrl_);

    /**
     * Sets the value of the member "ImageUrl".
     *
     * Scope: CarPlay
     * URL for image data associated with an application. Actual Image should be got from GetMediaObjectAlbumArt
     *
     * @param ImageUrl The value which will be set
     */
    inline void setImageUrl (const char* ImageUrl_);

    /**
     * Sets the value of the member "ImageUrl".
     *
     * Scope: CarPlay
     * URL for image data associated with an application. Actual Image should be got from GetMediaObjectAlbumArt
     *
     * @param ImageUrl The value which will be set
     */
    inline void setImageUrl (const char* value, size_t size);

    // API of field "oImageData"

    static const int kOImageData = 17;

    /**
     * Clears the field "oImageData".
     *
     * The field will be set to its default value. The hasOImageData()
     * method will return false.
     */
    inline void clearOImageData();

    /**
     * Checks whether the field "oImageData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOImageData()). Otherwise it will return false.
     */
    inline bool hasOImageData () const;

    /**
     * Returns the value of the member "oImageData".
     *
     * Scope: AAP If unavailable the list will be empty, else Image of Album.
     *
     * @return The value of the field "oImageData"
     */
    inline const ::std::vector< uint8 >& getOImageData () const;

    /**
     * Retrieves the value of the field "oImageData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oImageData".
     */
    inline ::std::vector< uint8 >& getOImageDataMutable ();

    /**
     * Sets the value of the member "oImageData".
     *
     * Scope: AAP If unavailable the list will be empty, else Image of Album.
     *
     * @param oImageData The value which will be set
     */
    inline void setOImageData (const ::std::vector< uint8 >& oImageData_);

    // API of field "PlayBackState"

    static const int kPlayBackState = 18;

    /**
     * Clears the field "PlayBackState".
     *
     * The field will be set to its default value. The hasPlayBackState()
     * method will return false.
     */
    inline void clearPlayBackState();

    /**
     * Checks whether the field "PlayBackState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPlayBackState()). Otherwise it will return false.
     */
    inline bool hasPlayBackState () const;

    /**
     * Returns the value of the member "PlayBackState".
     *
     * Current Playback state of the song - STOPPED, PLAYING, PAUSED, SEEKFORWARD or SEEKBACKWARD, NOT_AVAILABLE.
     * All the above mentioned status may or may  not be available from the device e.g SeekForward and SeekBackward is not available in AAP.
     *
     * @return The value of the field "PlayBackState"
     */
    inline T_e8_PlayBackState getPlayBackState () const;

    /**
     * Sets the value of the member "PlayBackState".
     *
     * Current Playback state of the song - STOPPED, PLAYING, PAUSED, SEEKFORWARD or SEEKBACKWARD, NOT_AVAILABLE.
     * All the above mentioned status may or may  not be available from the device e.g SeekForward and SeekBackward is not available in AAP.
     *
     * @param PlayBackState The value which will be set
     */
    inline void setPlayBackState (T_e8_PlayBackState PlayBackState_);

    // API of field "ShuffleState"

    static const int kShuffleState = 19;

    /**
     * Clears the field "ShuffleState".
     *
     * The field will be set to its default value. The hasShuffleState()
     * method will return false.
     */
    inline void clearShuffleState();

    /**
     * Checks whether the field "ShuffleState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShuffleState()). Otherwise it will return false.
     */
    inline bool hasShuffleState () const;

    /**
     * Returns the value of the member "ShuffleState".
     *
     * Shuffle state whether it is ON or OFF. In some technology we can also get specific status like it is ON but for Album or songs.
     *
     * @return The value of the field "ShuffleState"
     */
    inline T_e8_PlayBackShuffleState getShuffleState () const;

    /**
     * Sets the value of the member "ShuffleState".
     *
     * Shuffle state whether it is ON or OFF. In some technology we can also get specific status like it is ON but for Album or songs.
     *
     * @param ShuffleState The value which will be set
     */
    inline void setShuffleState (T_e8_PlayBackShuffleState ShuffleState_);

    // API of field "RepeatState"

    static const int kRepeatState = 20;

    /**
     * Clears the field "RepeatState".
     *
     * The field will be set to its default value. The hasRepeatState()
     * method will return false.
     */
    inline void clearRepeatState();

    /**
     * Checks whether the field "RepeatState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRepeatState()). Otherwise it will return false.
     */
    inline bool hasRepeatState () const;

    /**
     * Returns the value of the member "RepeatState".
     *
     * Repeat state of the song
     *
     * @return The value of the field "RepeatState"
     */
    inline T_e8_PlayBackRepeatState getRepeatState () const;

    /**
     * Sets the value of the member "RepeatState".
     *
     * Repeat state of the song
     *
     * @param RepeatState The value which will be set
     */
    inline void setRepeatState (T_e8_PlayBackRepeatState RepeatState_);

    // API of field "MediaType"

    static const int kMediaType = 21;

    /**
     * Clears the field "MediaType".
     *
     * The field will be set to its default value. The hasMediaType()
     * method will return false.
     */
    inline void clearMediaType();

    /**
     * Checks whether the field "MediaType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaType()). Otherwise it will return false.
     */
    inline bool hasMediaType () const;

    /**
     * Returns the value of the member "MediaType".
     *
     * Current playing media type. Note it is possible that this information may not be available for all the technology.
     *
     * @return The value of the field "MediaType"
     */
    inline T_e8_PlayBackMediaType getMediaType () const;

    /**
     * Sets the value of the member "MediaType".
     *
     * Current playing media type. Note it is possible that this information may not be available for all the technology.
     *
     * @param MediaType The value which will be set
     */
    inline void setMediaType (T_e8_PlayBackMediaType MediaType_);

    // API of field "iTunesRadioAd"

    static const int kITunesRadioAd = 22;

    /**
     * Clears the field "iTunesRadioAd".
     *
     * The field will be set to its default value. The hasITunesRadioAd()
     * method will return false.
     */
    inline void clearITunesRadioAd();

    /**
     * Checks whether the field "iTunesRadioAd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setITunesRadioAd()). Otherwise it will return false.
     */
    inline bool hasITunesRadioAd () const;

    /**
     * Returns the value of the member "iTunesRadioAd".
     *
     * Now playing an iTunes ad. It is applicable only for CarPlay, default value will be false.
     *
     * @return The value of the field "iTunesRadioAd"
     */
    inline bool getITunesRadioAd () const;

    /**
     * Sets the value of the member "iTunesRadioAd".
     *
     * Now playing an iTunes ad. It is applicable only for CarPlay, default value will be false.
     *
     * @param iTunesRadioAd The value which will be set
     */
    inline void setITunesRadioAd (bool iTunesRadioAd_);

    // API of field "iTunesRadioStationName"

    static const int kITunesRadioStationName = 23;

    /**
     * Clears the field "iTunesRadioStationName".
     *
     * The field will be set to its default value. The hasITunesRadioStationName()
     * method will return false.
     */
    inline void clearITunesRadioStationName();

    /**
     * Checks whether the field "iTunesRadioStationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setITunesRadioStationName()). Otherwise it will return false.
     */
    inline bool hasITunesRadioStationName () const;

    /**
     * Returns the value of the member "iTunesRadioStationName".
     *
     * Name of the now playing iTunes Radio station name. It is applicable only for CarPlay.
     * Set to NULL, zero length string, if iTunesRadioStationName is NULL
     *
     * @return The value of the field "iTunesRadioStationName"
     */
    inline const ::std::string& getITunesRadioStationName () const;

    /**
     * Retrieves the value of the field "iTunesRadioStationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "iTunesRadioStationName".
     */
    inline ::std::string& getITunesRadioStationNameMutable ();

    /**
     * Sets the value of the member "iTunesRadioStationName".
     *
     * Name of the now playing iTunes Radio station name. It is applicable only for CarPlay.
     * Set to NULL, zero length string, if iTunesRadioStationName is NULL
     *
     * @param iTunesRadioStationName The value which will be set
     */
    inline void setITunesRadioStationName (const ::std::string& iTunesRadioStationName_);

    /**
     * Sets the value of the member "iTunesRadioStationName".
     *
     * Name of the now playing iTunes Radio station name. It is applicable only for CarPlay.
     * Set to NULL, zero length string, if iTunesRadioStationName is NULL
     *
     * @param iTunesRadioStationName The value which will be set
     */
    inline void setITunesRadioStationName (const char* iTunesRadioStationName_);

    /**
     * Sets the value of the member "iTunesRadioStationName".
     *
     * Name of the now playing iTunes Radio station name. It is applicable only for CarPlay.
     * Set to NULL, zero length string, if iTunesRadioStationName is NULL
     *
     * @param iTunesRadioStationName The value which will be set
     */
    inline void setITunesRadioStationName (const char* value, size_t size);

    // API of field "MediaRating"

    static const int kMediaRating = 24;

    /**
     * Clears the field "MediaRating".
     *
     * The field will be set to its default value. The hasMediaRating()
     * method will return false.
     */
    inline void clearMediaRating();

    /**
     * Checks whether the field "MediaRating" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaRating()). Otherwise it will return false.
     */
    inline bool hasMediaRating () const;

    /**
     * Returns the value of the member "MediaRating".
     *
     * Indicates what is media rating. It is can 0...5. Set to 0xFF, if not valid.
     *
     * @return The value of the field "MediaRating"
     */
    inline uint8 getMediaRating () const;

    /**
     * Sets the value of the member "MediaRating".
     *
     * Indicates what is media rating. It is can 0...5. Set to 0xFF, if not valid.
     *
     * @param MediaRating The value which will be set
     */
    inline void setMediaRating (uint8 MediaRating_);

    static const T_ApplicationMediaMetaData &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_AppName ();

    inline void clear_has_AppName ();

    inline void set_has_Title ();

    inline void clear_has_Title ();

    inline void set_has_Artist ();

    inline void clear_has_Artist ();

    inline void set_has_Album ();

    inline void clear_has_Album ();

    inline void set_has_AlbumArtist ();

    inline void clear_has_AlbumArtist ();

    inline void set_has_Genre ();

    inline void clear_has_Genre ();

    inline void set_has_Composer ();

    inline void clear_has_Composer ();

    inline void set_has_TrackNumber ();

    inline void clear_has_TrackNumber ();

    inline void set_has_AlbumTrackCount ();

    inline void clear_has_AlbumTrackCount ();

    inline void set_has_AlbumDiscNumber ();

    inline void clear_has_AlbumDiscNumber ();

    inline void set_has_AlbumDiscCount ();

    inline void clear_has_AlbumDiscCount ();

    inline void set_has_ChapterCount ();

    inline void clear_has_ChapterCount ();

    inline void set_has_u32QueueIndex ();

    inline void clear_has_u32QueueIndex ();

    inline void set_has_u32QueueCount ();

    inline void clear_has_u32QueueCount ();

    inline void set_has_ImageMIMEType ();

    inline void clear_has_ImageMIMEType ();

    inline void set_has_ImageSize ();

    inline void clear_has_ImageSize ();

    inline void set_has_ImageUrl ();

    inline void clear_has_ImageUrl ();

    inline void set_has_oImageData ();

    inline void clear_has_oImageData ();

    inline void set_has_PlayBackState ();

    inline void clear_has_PlayBackState ();

    inline void set_has_ShuffleState ();

    inline void clear_has_ShuffleState ();

    inline void set_has_RepeatState ();

    inline void clear_has_RepeatState ();

    inline void set_has_MediaType ();

    inline void clear_has_MediaType ();

    inline void set_has_iTunesRadioAd ();

    inline void clear_has_iTunesRadioAd ();

    inline void set_has_iTunesRadioStationName ();

    inline void clear_has_iTunesRadioStationName ();

    inline void set_has_MediaRating ();

    inline void clear_has_MediaRating ();

    uint32 _has_bits_[ (25 + 31) / 32];

    ::std::string _AppName;

    ::std::string _Title;

    ::std::string _Artist;

    ::std::string _Album;

    ::std::string _AlbumArtist;

    ::std::string _Genre;

    ::std::string _Composer;

    uint32 _TrackNumber;

    uint32 _AlbumTrackCount;

    uint32 _AlbumDiscNumber;

    uint32 _AlbumDiscCount;

    uint32 _ChapterCount;

    uint32 _u32QueueIndex;

    uint32 _u32QueueCount;

    ::std::string _ImageMIMEType;

    uint32 _ImageSize;

    ::std::string _ImageUrl;

    ::std::vector< uint8 > _oImageData;

    T_e8_PlayBackState _PlayBackState;

    T_e8_PlayBackShuffleState _ShuffleState;

    T_e8_PlayBackRepeatState _RepeatState;

    T_e8_PlayBackMediaType _MediaType;

    bool _iTunesRadioAd;

    ::std::string _iTunesRadioStationName;

    uint8 _MediaRating;

};

/**
 * This structure contains Phone call specific metadata information
 */
class T_ApplicationPhoneCallMetadata {
public:

    /**
     * Default constructor
     */
    inline  T_ApplicationPhoneCallMetadata ();

    /**
     * Copy constructor
     */
    inline  T_ApplicationPhoneCallMetadata (const T_ApplicationPhoneCallMetadata &rhs);

    /**
     * All fields constructor
     */
    inline  T_ApplicationPhoneCallMetadata (const ::std::string& PhoneNumber_, const ::std::string& DisplayName_, T_e8_PhoneCallState CallState_, T_e8_PhoneCallDirection CallDirection_, uint32 CallDuration_, const ::std::string& CallerLabel_, bool ConferencedCall_);

    /**
     * Destructor
     */
    inline  ~T_ApplicationPhoneCallMetadata();

    /**
     * Assignment operator
     */
    inline T_ApplicationPhoneCallMetadata& operator = (const T_ApplicationPhoneCallMetadata& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ApplicationPhoneCallMetadata& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ApplicationPhoneCallMetadata& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ApplicationPhoneCallMetadata& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ApplicationPhoneCallMetadata& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneNumber"

    static const int kPhoneNumber = 0;

    /**
     * Clears the field "PhoneNumber".
     *
     * The field will be set to its default value. The hasPhoneNumber()
     * method will return false.
     */
    inline void clearPhoneNumber();

    /**
     * Checks whether the field "PhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasPhoneNumber () const;

    /**
     * Returns the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @return The value of the field "PhoneNumber"
     */
    inline const ::std::string& getPhoneNumber () const;

    /**
     * Retrieves the value of the field "PhoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneNumber".
     */
    inline ::std::string& getPhoneNumberMutable ();

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (const ::std::string& PhoneNumber_);

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (const char* PhoneNumber_);

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (const char* value, size_t size);

    // API of field "DisplayName"

    static const int kDisplayName = 1;

    /**
     * Clears the field "DisplayName".
     *
     * The field will be set to its default value. The hasDisplayName()
     * method will return false.
     */
    inline void clearDisplayName();

    /**
     * Checks whether the field "DisplayName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayName()). Otherwise it will return false.
     */
    inline bool hasDisplayName () const;

    /**
     * Returns the value of the member "DisplayName".
     *
     * Name of the caller in the Phone contacts. Set to Null if not available
     *
     * @return The value of the field "DisplayName"
     */
    inline const ::std::string& getDisplayName () const;

    /**
     * Retrieves the value of the field "DisplayName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayName".
     */
    inline ::std::string& getDisplayNameMutable ();

    /**
     * Sets the value of the member "DisplayName".
     *
     * Name of the caller in the Phone contacts. Set to Null if not available
     *
     * @param DisplayName The value which will be set
     */
    inline void setDisplayName (const ::std::string& DisplayName_);

    /**
     * Sets the value of the member "DisplayName".
     *
     * Name of the caller in the Phone contacts. Set to Null if not available
     *
     * @param DisplayName The value which will be set
     */
    inline void setDisplayName (const char* DisplayName_);

    /**
     * Sets the value of the member "DisplayName".
     *
     * Name of the caller in the Phone contacts. Set to Null if not available
     *
     * @param DisplayName The value which will be set
     */
    inline void setDisplayName (const char* value, size_t size);

    // API of field "CallState"

    static const int kCallState = 2;

    /**
     * Clears the field "CallState".
     *
     * The field will be set to its default value. The hasCallState()
     * method will return false.
     */
    inline void clearCallState();

    /**
     * Checks whether the field "CallState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallState()). Otherwise it will return false.
     */
    inline bool hasCallState () const;

    /**
     * Returns the value of the member "CallState".
     *
     * Identifies the state of the call
     *
     * @return The value of the field "CallState"
     */
    inline T_e8_PhoneCallState getCallState () const;

    /**
     * Sets the value of the member "CallState".
     *
     * Identifies the state of the call
     *
     * @param CallState The value which will be set
     */
    inline void setCallState (T_e8_PhoneCallState CallState_);

    // API of field "CallDirection"

    static const int kCallDirection = 3;

    /**
     * Clears the field "CallDirection".
     *
     * The field will be set to its default value. The hasCallDirection()
     * method will return false.
     */
    inline void clearCallDirection();

    /**
     * Checks whether the field "CallDirection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallDirection()). Otherwise it will return false.
     */
    inline bool hasCallDirection () const;

    /**
     * Returns the value of the member "CallDirection".
     *
     * Incoming or outgoing call
     *
     * @return The value of the field "CallDirection"
     */
    inline T_e8_PhoneCallDirection getCallDirection () const;

    /**
     * Sets the value of the member "CallDirection".
     *
     * Incoming or outgoing call
     *
     * @param CallDirection The value which will be set
     */
    inline void setCallDirection (T_e8_PhoneCallDirection CallDirection_);

    // API of field "CallDuration"

    static const int kCallDuration = 4;

    /**
     * Clears the field "CallDuration".
     *
     * The field will be set to its default value. The hasCallDuration()
     * method will return false.
     */
    inline void clearCallDuration();

    /**
     * Checks whether the field "CallDuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallDuration()). Otherwise it will return false.
     */
    inline bool hasCallDuration () const;

    /**
     * Returns the value of the member "CallDuration".
     *
     * In secs. 0xFFFFFFFF if data is not available
     *
     * @return The value of the field "CallDuration"
     */
    inline uint32 getCallDuration () const;

    /**
     * Sets the value of the member "CallDuration".
     *
     * In secs. 0xFFFFFFFF if data is not available
     *
     * @param CallDuration The value which will be set
     */
    inline void setCallDuration (uint32 CallDuration_);

    // API of field "CallerLabel"

    static const int kCallerLabel = 5;

    /**
     * Clears the field "CallerLabel".
     *
     * The field will be set to its default value. The hasCallerLabel()
     * method will return false.
     */
    inline void clearCallerLabel();

    /**
     * Checks whether the field "CallerLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallerLabel()). Otherwise it will return false.
     */
    inline bool hasCallerLabel () const;

    /**
     * Returns the value of the member "CallerLabel".
     *
     * If caller label is in contacts, than mobile, work or home would be populated. Set to Null if not available
     *
     * @return The value of the field "CallerLabel"
     */
    inline const ::std::string& getCallerLabel () const;

    /**
     * Retrieves the value of the field "CallerLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CallerLabel".
     */
    inline ::std::string& getCallerLabelMutable ();

    /**
     * Sets the value of the member "CallerLabel".
     *
     * If caller label is in contacts, than mobile, work or home would be populated. Set to Null if not available
     *
     * @param CallerLabel The value which will be set
     */
    inline void setCallerLabel (const ::std::string& CallerLabel_);

    /**
     * Sets the value of the member "CallerLabel".
     *
     * If caller label is in contacts, than mobile, work or home would be populated. Set to Null if not available
     *
     * @param CallerLabel The value which will be set
     */
    inline void setCallerLabel (const char* CallerLabel_);

    /**
     * Sets the value of the member "CallerLabel".
     *
     * If caller label is in contacts, than mobile, work or home would be populated. Set to Null if not available
     *
     * @param CallerLabel The value which will be set
     */
    inline void setCallerLabel (const char* value, size_t size);

    // API of field "ConferencedCall"

    static const int kConferencedCall = 6;

    /**
     * Clears the field "ConferencedCall".
     *
     * The field will be set to its default value. The hasConferencedCall()
     * method will return false.
     */
    inline void clearConferencedCall();

    /**
     * Checks whether the field "ConferencedCall" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConferencedCall()). Otherwise it will return false.
     */
    inline bool hasConferencedCall () const;

    /**
     * Returns the value of the member "ConferencedCall".
     *
     * True indicates this call is part of conference call.
     *
     * @return The value of the field "ConferencedCall"
     */
    inline bool getConferencedCall () const;

    /**
     * Sets the value of the member "ConferencedCall".
     *
     * True indicates this call is part of conference call.
     *
     * @param ConferencedCall The value which will be set
     */
    inline void setConferencedCall (bool ConferencedCall_);

    static const T_ApplicationPhoneCallMetadata &getDefaultInstance();

private:

    inline void set_has_PhoneNumber ();

    inline void clear_has_PhoneNumber ();

    inline void set_has_DisplayName ();

    inline void clear_has_DisplayName ();

    inline void set_has_CallState ();

    inline void clear_has_CallState ();

    inline void set_has_CallDirection ();

    inline void clear_has_CallDirection ();

    inline void set_has_CallDuration ();

    inline void clear_has_CallDuration ();

    inline void set_has_CallerLabel ();

    inline void clear_has_CallerLabel ();

    inline void set_has_ConferencedCall ();

    inline void clear_has_ConferencedCall ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::std::string _PhoneNumber;

    ::std::string _DisplayName;

    T_e8_PhoneCallState _CallState;

    T_e8_PhoneCallDirection _CallDirection;

    uint32 _CallDuration;

    ::std::string _CallerLabel;

    bool _ConferencedCall;

};

/**
 * This structure contains application specific metadata information
 */
class T_Time {
public:

    /**
     * Default constructor
     */
    inline  T_Time ();

    /**
     * Copy constructor
     */
    inline  T_Time (const T_Time &rhs);

    /**
     * All fields constructor
     */
    inline  T_Time (uint8 u8Hour_, uint8 u8Minute_, uint8 u8Second_);

    /**
     * Destructor
     */
    inline  ~T_Time();

    /**
     * Assignment operator
     */
    inline T_Time& operator = (const T_Time& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Time& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Time& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Time& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Time& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Hour"

    static const int kU8Hour = 0;

    /**
     * Clears the field "u8Hour".
     *
     * The field will be set to its default value. The hasU8Hour()
     * method will return false.
     */
    inline void clearU8Hour();

    /**
     * Checks whether the field "u8Hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hour()). Otherwise it will return false.
     */
    inline bool hasU8Hour () const;

    /**
     * Returns the value of the member "u8Hour".
     *
     * Hour Component of Time
     *
     * @return The value of the field "u8Hour"
     */
    inline uint8 getU8Hour () const;

    /**
     * Sets the value of the member "u8Hour".
     *
     * Hour Component of Time
     *
     * @param u8Hour The value which will be set
     */
    inline void setU8Hour (uint8 u8Hour_);

    // API of field "u8Minute"

    static const int kU8Minute = 1;

    /**
     * Clears the field "u8Minute".
     *
     * The field will be set to its default value. The hasU8Minute()
     * method will return false.
     */
    inline void clearU8Minute();

    /**
     * Checks whether the field "u8Minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minute()). Otherwise it will return false.
     */
    inline bool hasU8Minute () const;

    /**
     * Returns the value of the member "u8Minute".
     *
     * Minute Component of Time
     *
     * @return The value of the field "u8Minute"
     */
    inline uint8 getU8Minute () const;

    /**
     * Sets the value of the member "u8Minute".
     *
     * Minute Component of Time
     *
     * @param u8Minute The value which will be set
     */
    inline void setU8Minute (uint8 u8Minute_);

    // API of field "u8Second"

    static const int kU8Second = 2;

    /**
     * Clears the field "u8Second".
     *
     * The field will be set to its default value. The hasU8Second()
     * method will return false.
     */
    inline void clearU8Second();

    /**
     * Checks whether the field "u8Second" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Second()). Otherwise it will return false.
     */
    inline bool hasU8Second () const;

    /**
     * Returns the value of the member "u8Second".
     *
     * Seconds Component of Time
     *
     * @return The value of the field "u8Second"
     */
    inline uint8 getU8Second () const;

    /**
     * Sets the value of the member "u8Second".
     *
     * Seconds Component of Time
     *
     * @param u8Second The value which will be set
     */
    inline void setU8Second (uint8 u8Second_);

    static const T_Time &getDefaultInstance();

private:

    inline void set_has_u8Hour ();

    inline void clear_has_u8Hour ();

    inline void set_has_u8Minute ();

    inline void clear_has_u8Minute ();

    inline void set_has_u8Second ();

    inline void clear_has_u8Second ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8Hour;

    uint8 _u8Minute;

    uint8 _u8Second;

};

/**
 * This structure contains Phone call specific metadata information
 */
class T_ApplicationPhoneCallExtendedMetadata {
public:

    /**
     * Default constructor
     */
    inline  T_ApplicationPhoneCallExtendedMetadata ();

    /**
     * Copy constructor
     */
    inline  T_ApplicationPhoneCallExtendedMetadata (const T_ApplicationPhoneCallExtendedMetadata &rhs);

    /**
     * All fields constructor
     */
    inline  T_ApplicationPhoneCallExtendedMetadata (const ::std::string& PhoneNumber_, const ::std::string& DisplayName_, const ::std::string& sCallUUID_, T_e8_CallStateUpdateDisconnectReason CallStateDisconnectReason_, T_e8_PhoneCallState CallState_, T_e8_PhoneCallDirection CallDirection_, const ::std::string& CallerLabel_, bool ConferencedCall_, uint64 u64StartTimeStamp_, const T_Time& CallProgress_, const T_Time& CallProgressRefFromDevice_);

    /**
     * Destructor
     */
    inline  ~T_ApplicationPhoneCallExtendedMetadata();

    /**
     * Assignment operator
     */
    inline T_ApplicationPhoneCallExtendedMetadata& operator = (const T_ApplicationPhoneCallExtendedMetadata& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ApplicationPhoneCallExtendedMetadata& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ApplicationPhoneCallExtendedMetadata& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ApplicationPhoneCallExtendedMetadata& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ApplicationPhoneCallExtendedMetadata& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneNumber"

    static const int kPhoneNumber = 0;

    /**
     * Clears the field "PhoneNumber".
     *
     * The field will be set to its default value. The hasPhoneNumber()
     * method will return false.
     */
    inline void clearPhoneNumber();

    /**
     * Checks whether the field "PhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasPhoneNumber () const;

    /**
     * Returns the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @return The value of the field "PhoneNumber"
     */
    inline const ::std::string& getPhoneNumber () const;

    /**
     * Retrieves the value of the field "PhoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneNumber".
     */
    inline ::std::string& getPhoneNumberMutable ();

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (const ::std::string& PhoneNumber_);

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (const char* PhoneNumber_);

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (const char* value, size_t size);

    // API of field "DisplayName"

    static const int kDisplayName = 1;

    /**
     * Clears the field "DisplayName".
     *
     * The field will be set to its default value. The hasDisplayName()
     * method will return false.
     */
    inline void clearDisplayName();

    /**
     * Checks whether the field "DisplayName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayName()). Otherwise it will return false.
     */
    inline bool hasDisplayName () const;

    /**
     * Returns the value of the member "DisplayName".
     *
     * Name of the caller in the Phone contacts. Set to Null if not available
     *
     * @return The value of the field "DisplayName"
     */
    inline const ::std::string& getDisplayName () const;

    /**
     * Retrieves the value of the field "DisplayName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayName".
     */
    inline ::std::string& getDisplayNameMutable ();

    /**
     * Sets the value of the member "DisplayName".
     *
     * Name of the caller in the Phone contacts. Set to Null if not available
     *
     * @param DisplayName The value which will be set
     */
    inline void setDisplayName (const ::std::string& DisplayName_);

    /**
     * Sets the value of the member "DisplayName".
     *
     * Name of the caller in the Phone contacts. Set to Null if not available
     *
     * @param DisplayName The value which will be set
     */
    inline void setDisplayName (const char* DisplayName_);

    /**
     * Sets the value of the member "DisplayName".
     *
     * Name of the caller in the Phone contacts. Set to Null if not available
     *
     * @param DisplayName The value which will be set
     */
    inline void setDisplayName (const char* value, size_t size);

    // API of field "sCallUUID"

    static const int kSCallUUID = 2;

    /**
     * Clears the field "sCallUUID".
     *
     * The field will be set to its default value. The hasSCallUUID()
     * method will return false.
     */
    inline void clearSCallUUID();

    /**
     * Checks whether the field "sCallUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCallUUID()). Otherwise it will return false.
     */
    inline bool hasSCallUUID () const;

    /**
     * Returns the value of the member "sCallUUID".
     *
     *
     *
     * @return The value of the field "sCallUUID"
     */
    inline const ::std::string& getSCallUUID () const;

    /**
     * Retrieves the value of the field "sCallUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCallUUID".
     */
    inline ::std::string& getSCallUUIDMutable ();

    /**
     * Sets the value of the member "sCallUUID".
     *
     *
     *
     * @param sCallUUID The value which will be set
     */
    inline void setSCallUUID (const ::std::string& sCallUUID_);

    /**
     * Sets the value of the member "sCallUUID".
     *
     *
     *
     * @param sCallUUID The value which will be set
     */
    inline void setSCallUUID (const char* sCallUUID_);

    /**
     * Sets the value of the member "sCallUUID".
     *
     *
     *
     * @param sCallUUID The value which will be set
     */
    inline void setSCallUUID (const char* value, size_t size);

    // API of field "CallStateDisconnectReason"

    static const int kCallStateDisconnectReason = 3;

    /**
     * Clears the field "CallStateDisconnectReason".
     *
     * The field will be set to its default value. The hasCallStateDisconnectReason()
     * method will return false.
     */
    inline void clearCallStateDisconnectReason();

    /**
     * Checks whether the field "CallStateDisconnectReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallStateDisconnectReason()). Otherwise it will return false.
     */
    inline bool hasCallStateDisconnectReason () const;

    /**
     * Returns the value of the member "CallStateDisconnectReason".
     *
     * Call disconnect reason
     *
     * @return The value of the field "CallStateDisconnectReason"
     */
    inline T_e8_CallStateUpdateDisconnectReason getCallStateDisconnectReason () const;

    /**
     * Sets the value of the member "CallStateDisconnectReason".
     *
     * Call disconnect reason
     *
     * @param CallStateDisconnectReason The value which will be set
     */
    inline void setCallStateDisconnectReason (T_e8_CallStateUpdateDisconnectReason CallStateDisconnectReason_);

    // API of field "CallState"

    static const int kCallState = 4;

    /**
     * Clears the field "CallState".
     *
     * The field will be set to its default value. The hasCallState()
     * method will return false.
     */
    inline void clearCallState();

    /**
     * Checks whether the field "CallState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallState()). Otherwise it will return false.
     */
    inline bool hasCallState () const;

    /**
     * Returns the value of the member "CallState".
     *
     * Identifies the state of the call
     *
     * @return The value of the field "CallState"
     */
    inline T_e8_PhoneCallState getCallState () const;

    /**
     * Sets the value of the member "CallState".
     *
     * Identifies the state of the call
     *
     * @param CallState The value which will be set
     */
    inline void setCallState (T_e8_PhoneCallState CallState_);

    // API of field "CallDirection"

    static const int kCallDirection = 5;

    /**
     * Clears the field "CallDirection".
     *
     * The field will be set to its default value. The hasCallDirection()
     * method will return false.
     */
    inline void clearCallDirection();

    /**
     * Checks whether the field "CallDirection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallDirection()). Otherwise it will return false.
     */
    inline bool hasCallDirection () const;

    /**
     * Returns the value of the member "CallDirection".
     *
     * Incoming or outgoing call
     *
     * @return The value of the field "CallDirection"
     */
    inline T_e8_PhoneCallDirection getCallDirection () const;

    /**
     * Sets the value of the member "CallDirection".
     *
     * Incoming or outgoing call
     *
     * @param CallDirection The value which will be set
     */
    inline void setCallDirection (T_e8_PhoneCallDirection CallDirection_);

    // API of field "CallerLabel"

    static const int kCallerLabel = 6;

    /**
     * Clears the field "CallerLabel".
     *
     * The field will be set to its default value. The hasCallerLabel()
     * method will return false.
     */
    inline void clearCallerLabel();

    /**
     * Checks whether the field "CallerLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallerLabel()). Otherwise it will return false.
     */
    inline bool hasCallerLabel () const;

    /**
     * Returns the value of the member "CallerLabel".
     *
     * If caller label is in contacts, than mobile, work or home would be populated. Set to Null if not available
     *
     * @return The value of the field "CallerLabel"
     */
    inline const ::std::string& getCallerLabel () const;

    /**
     * Retrieves the value of the field "CallerLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CallerLabel".
     */
    inline ::std::string& getCallerLabelMutable ();

    /**
     * Sets the value of the member "CallerLabel".
     *
     * If caller label is in contacts, than mobile, work or home would be populated. Set to Null if not available
     *
     * @param CallerLabel The value which will be set
     */
    inline void setCallerLabel (const ::std::string& CallerLabel_);

    /**
     * Sets the value of the member "CallerLabel".
     *
     * If caller label is in contacts, than mobile, work or home would be populated. Set to Null if not available
     *
     * @param CallerLabel The value which will be set
     */
    inline void setCallerLabel (const char* CallerLabel_);

    /**
     * Sets the value of the member "CallerLabel".
     *
     * If caller label is in contacts, than mobile, work or home would be populated. Set to Null if not available
     *
     * @param CallerLabel The value which will be set
     */
    inline void setCallerLabel (const char* value, size_t size);

    // API of field "ConferencedCall"

    static const int kConferencedCall = 7;

    /**
     * Clears the field "ConferencedCall".
     *
     * The field will be set to its default value. The hasConferencedCall()
     * method will return false.
     */
    inline void clearConferencedCall();

    /**
     * Checks whether the field "ConferencedCall" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConferencedCall()). Otherwise it will return false.
     */
    inline bool hasConferencedCall () const;

    /**
     * Returns the value of the member "ConferencedCall".
     *
     * True indicates this call is part of conference call.
     *
     * @return The value of the field "ConferencedCall"
     */
    inline bool getConferencedCall () const;

    /**
     * Sets the value of the member "ConferencedCall".
     *
     * True indicates this call is part of conference call.
     *
     * @param ConferencedCall The value which will be set
     */
    inline void setConferencedCall (bool ConferencedCall_);

    // API of field "u64StartTimeStamp"

    static const int kU64StartTimeStamp = 8;

    /**
     * Clears the field "u64StartTimeStamp".
     *
     * The field will be set to its default value. The hasU64StartTimeStamp()
     * method will return false.
     */
    inline void clearU64StartTimeStamp();

    /**
     * Checks whether the field "u64StartTimeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64StartTimeStamp()). Otherwise it will return false.
     */
    inline bool hasU64StartTimeStamp () const;

    /**
     * Returns the value of the member "u64StartTimeStamp".
     *
     * Start Timestamp of call in seconds since reference date (Jan 1, 1970, GMT). This value is received from device
     *
     * @return The value of the field "u64StartTimeStamp"
     */
    inline uint64 getU64StartTimeStamp () const;

    /**
     * Sets the value of the member "u64StartTimeStamp".
     *
     * Start Timestamp of call in seconds since reference date (Jan 1, 1970, GMT). This value is received from device
     *
     * @param u64StartTimeStamp The value which will be set
     */
    inline void setU64StartTimeStamp (uint64 u64StartTimeStamp_);

    // API of field "CallProgress"

    static const int kCallProgress = 9;

    /**
     * Clears the field "CallProgress".
     *
     * The field will be set to its default value. The hasCallProgress()
     * method will return false.
     */
    inline void clearCallProgress();

    /**
     * Checks whether the field "CallProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallProgress()). Otherwise it will return false.
     */
    inline bool hasCallProgress () const;

    /**
     * Returns the value of the member "CallProgress".
     *
     * Object that provides call progress information. Value gets incremented for every sec, until call is ended.
     * Call progress calculation started from Phone Call state ACTIVE until DISCONNECTED or call is terminated.
     *
     * @return The value of the field "CallProgress"
     */
    inline const T_Time& getCallProgress () const;

    /**
     * Retrieves the value of the field "CallProgress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CallProgress".
     */
    inline T_Time& getCallProgressMutable ();

    /**
     * Sets the value of the member "CallProgress".
     *
     * Object that provides call progress information. Value gets incremented for every sec, until call is ended.
     * Call progress calculation started from Phone Call state ACTIVE until DISCONNECTED or call is terminated.
     *
     * @param CallProgress The value which will be set
     */
    inline void setCallProgress (const T_Time& CallProgress_);

    // API of field "CallProgressRefFromDevice"

    static const int kCallProgressRefFromDevice = 10;

    /**
     * Clears the field "CallProgressRefFromDevice".
     *
     * The field will be set to its default value. The hasCallProgressRefFromDevice()
     * method will return false.
     */
    inline void clearCallProgressRefFromDevice();

    /**
     * Checks whether the field "CallProgressRefFromDevice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallProgressRefFromDevice()). Otherwise it will return false.
     */
    inline bool hasCallProgressRefFromDevice () const;

    /**
     * Returns the value of the member "CallProgressRefFromDevice".
     *
     * Object that provides call progress information.
     * It is the time where already some duration of call was elapsed before connecting device to the HU or session was activated
     * Call progress calculation is based on u64StartTimeStamp and is incremented every second until the call is ended.
     * i.e this duration includes -> (CallProgress + some duration of call that was active before the device was connected to HU).
     *
     * Example: If a call was running on device for 5 mins 15 seconds before it was connected to HU, then the CallProgress and
     * CallProgressRefFromDevice will be as follows
     * InitialValue                      After 1 second from inital value                        After 2 secondsfrom initialvalue
     * CallProgress                   0 hour: 0 Minute:  0 Second       0 hour: 0 Minute:  1 Second                             0 hour: 0 Minute:  2 Second
     * CallProgressRefFromDevice      0 hour: 5 Minute: 15 Second       0 hour: 5 Minute: 16 Second                             0 hour: 5 Minute: 17 Second
     * NOTE: IF THE TIME ON THE PHONE AND ON THE ACCESSORY ARE DIFFERENT, THEN CallProgressRefFromDevice WILL BE INACCURATE.
     * THIS CAN TYPICALLY HAPPEN WHEN AUTOMATIC TIME UPDATE IS DISABLED ON DEVICE OR HEAD UNIT
     *
     * @return The value of the field "CallProgressRefFromDevice"
     */
    inline const T_Time& getCallProgressRefFromDevice () const;

    /**
     * Retrieves the value of the field "CallProgressRefFromDevice" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CallProgressRefFromDevice".
     */
    inline T_Time& getCallProgressRefFromDeviceMutable ();

    /**
     * Sets the value of the member "CallProgressRefFromDevice".
     *
     * Object that provides call progress information.
     * It is the time where already some duration of call was elapsed before connecting device to the HU or session was activated
     * Call progress calculation is based on u64StartTimeStamp and is incremented every second until the call is ended.
     * i.e this duration includes -> (CallProgress + some duration of call that was active before the device was connected to HU).
     *
     * Example: If a call was running on device for 5 mins 15 seconds before it was connected to HU, then the CallProgress and
     * CallProgressRefFromDevice will be as follows
     * InitialValue                      After 1 second from inital value                        After 2 secondsfrom initialvalue
     * CallProgress                   0 hour: 0 Minute:  0 Second       0 hour: 0 Minute:  1 Second                             0 hour: 0 Minute:  2 Second
     * CallProgressRefFromDevice      0 hour: 5 Minute: 15 Second       0 hour: 5 Minute: 16 Second                             0 hour: 5 Minute: 17 Second
     * NOTE: IF THE TIME ON THE PHONE AND ON THE ACCESSORY ARE DIFFERENT, THEN CallProgressRefFromDevice WILL BE INACCURATE.
     * THIS CAN TYPICALLY HAPPEN WHEN AUTOMATIC TIME UPDATE IS DISABLED ON DEVICE OR HEAD UNIT
     *
     * @param CallProgressRefFromDevice The value which will be set
     */
    inline void setCallProgressRefFromDevice (const T_Time& CallProgressRefFromDevice_);

    static const T_ApplicationPhoneCallExtendedMetadata &getDefaultInstance();

private:

    inline void set_has_PhoneNumber ();

    inline void clear_has_PhoneNumber ();

    inline void set_has_DisplayName ();

    inline void clear_has_DisplayName ();

    inline void set_has_sCallUUID ();

    inline void clear_has_sCallUUID ();

    inline void set_has_CallStateDisconnectReason ();

    inline void clear_has_CallStateDisconnectReason ();

    inline void set_has_CallState ();

    inline void clear_has_CallState ();

    inline void set_has_CallDirection ();

    inline void clear_has_CallDirection ();

    inline void set_has_CallerLabel ();

    inline void clear_has_CallerLabel ();

    inline void set_has_ConferencedCall ();

    inline void clear_has_ConferencedCall ();

    inline void set_has_u64StartTimeStamp ();

    inline void clear_has_u64StartTimeStamp ();

    inline void set_has_CallProgress ();

    inline void clear_has_CallProgress ();

    inline void set_has_CallProgressRefFromDevice ();

    inline void clear_has_CallProgressRefFromDevice ();

    uint32 _has_bits_[ (11 + 31) / 32];

    ::std::string _PhoneNumber;

    ::std::string _DisplayName;

    ::std::string _sCallUUID;

    T_e8_CallStateUpdateDisconnectReason _CallStateDisconnectReason;

    T_e8_PhoneCallState _CallState;

    T_e8_PhoneCallDirection _CallDirection;

    ::std::string _CallerLabel;

    bool _ConferencedCall;

    uint64 _u64StartTimeStamp;

    T_Time _CallProgress;

    T_Time _CallProgressRefFromDevice;

};

/**
 * Accessory display context request grouping.
 */
class T_AccessoryDisplayContext {
public:

    /**
     * Default constructor
     */
    inline  T_AccessoryDisplayContext ();

    /**
     * Copy constructor
     */
    inline  T_AccessoryDisplayContext (const T_AccessoryDisplayContext &rhs);

    /**
     * All fields constructor
     */
    inline  T_AccessoryDisplayContext (T_e8_DisplayContext DisplayContext_, bool DisplayFlag_);

    /**
     * Destructor
     */
    inline  ~T_AccessoryDisplayContext();

    /**
     * Assignment operator
     */
    inline T_AccessoryDisplayContext& operator = (const T_AccessoryDisplayContext& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AccessoryDisplayContext& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AccessoryDisplayContext& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AccessoryDisplayContext& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AccessoryDisplayContext& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DisplayContext"

    static const int kDisplayContext = 0;

    /**
     * Clears the field "DisplayContext".
     *
     * The field will be set to its default value. The hasDisplayContext()
     * method will return false.
     */
    inline void clearDisplayContext();

    /**
     * Checks whether the field "DisplayContext" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayContext()). Otherwise it will return false.
     */
    inline bool hasDisplayContext () const;

    /**
     * Returns the value of the member "DisplayContext".
     *
     * Display context info.
     *
     * @return The value of the field "DisplayContext"
     */
    inline T_e8_DisplayContext getDisplayContext () const;

    /**
     * Sets the value of the member "DisplayContext".
     *
     * Display context info.
     *
     * @param DisplayContext The value which will be set
     */
    inline void setDisplayContext (T_e8_DisplayContext DisplayContext_);

    // API of field "DisplayFlag"

    static const int kDisplayFlag = 1;

    /**
     * Clears the field "DisplayFlag".
     *
     * The field will be set to its default value. The hasDisplayFlag()
     * method will return false.
     */
    inline void clearDisplayFlag();

    /**
     * Checks whether the field "DisplayFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayFlag()). Otherwise it will return false.
     */
    inline bool hasDisplayFlag () const;

    /**
     * Returns the value of the member "DisplayFlag".
     *
     * Display flag. 1=To display HMI, 0= To display SPI.
     *
     * @return The value of the field "DisplayFlag"
     */
    inline bool getDisplayFlag () const;

    /**
     * Sets the value of the member "DisplayFlag".
     *
     * Display flag. 1=To display HMI, 0= To display SPI.
     *
     * @param DisplayFlag The value which will be set
     */
    inline void setDisplayFlag (bool DisplayFlag_);

    static const T_AccessoryDisplayContext &getDefaultInstance();

private:

    inline void set_has_DisplayContext ();

    inline void clear_has_DisplayContext ();

    inline void set_has_DisplayFlag ();

    inline void clear_has_DisplayFlag ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_DisplayContext _DisplayContext;

    bool _DisplayFlag;

};

/**
 * Structure to hold the resource ownership request.
 */
class T_DisplayConstraint {
public:

    /**
     * Default constructor
     */
    inline  T_DisplayConstraint ();

    /**
     * Copy constructor
     */
    inline  T_DisplayConstraint (const T_DisplayConstraint &rhs);

    /**
     * All fields constructor
     */
    inline  T_DisplayConstraint (T_e8_ResourceTransferType TransferType_, T_e8_ResourceTransferPriority TransferPriority_, T_e8_ResourceTransferConstraint TakeConstraint_, T_e8_ResourceTransferConstraint BorrowConstraint_, const ::std::string& BorrowId_);

    /**
     * Destructor
     */
    inline  ~T_DisplayConstraint();

    /**
     * Assignment operator
     */
    inline T_DisplayConstraint& operator = (const T_DisplayConstraint& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DisplayConstraint& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DisplayConstraint& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DisplayConstraint& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DisplayConstraint& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TransferType"

    static const int kTransferType = 0;

    /**
     * Clears the field "TransferType".
     *
     * The field will be set to its default value. The hasTransferType()
     * method will return false.
     */
    inline void clearTransferType();

    /**
     * Checks whether the field "TransferType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransferType()). Otherwise it will return false.
     */
    inline bool hasTransferType () const;

    /**
     * Returns the value of the member "TransferType".
     *
     * Resource transfer type
     *
     * @return The value of the field "TransferType"
     */
    inline T_e8_ResourceTransferType getTransferType () const;

    /**
     * Sets the value of the member "TransferType".
     *
     * Resource transfer type
     *
     * @param TransferType The value which will be set
     */
    inline void setTransferType (T_e8_ResourceTransferType TransferType_);

    // API of field "TransferPriority"

    static const int kTransferPriority = 1;

    /**
     * Clears the field "TransferPriority".
     *
     * The field will be set to its default value. The hasTransferPriority()
     * method will return false.
     */
    inline void clearTransferPriority();

    /**
     * Checks whether the field "TransferPriority" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransferPriority()). Otherwise it will return false.
     */
    inline bool hasTransferPriority () const;

    /**
     * Returns the value of the member "TransferPriority".
     *
     * Resource transfer priority.
     *
     * @return The value of the field "TransferPriority"
     */
    inline T_e8_ResourceTransferPriority getTransferPriority () const;

    /**
     * Sets the value of the member "TransferPriority".
     *
     * Resource transfer priority.
     *
     * @param TransferPriority The value which will be set
     */
    inline void setTransferPriority (T_e8_ResourceTransferPriority TransferPriority_);

    // API of field "TakeConstraint"

    static const int kTakeConstraint = 2;

    /**
     * Clears the field "TakeConstraint".
     *
     * The field will be set to its default value. The hasTakeConstraint()
     * method will return false.
     */
    inline void clearTakeConstraint();

    /**
     * Checks whether the field "TakeConstraint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTakeConstraint()). Otherwise it will return false.
     */
    inline bool hasTakeConstraint () const;

    /**
     * Returns the value of the member "TakeConstraint".
     *
     * Resource transfer type
     *
     * @return The value of the field "TakeConstraint"
     */
    inline T_e8_ResourceTransferConstraint getTakeConstraint () const;

    /**
     * Sets the value of the member "TakeConstraint".
     *
     * Resource transfer type
     *
     * @param TakeConstraint The value which will be set
     */
    inline void setTakeConstraint (T_e8_ResourceTransferConstraint TakeConstraint_);

    // API of field "BorrowConstraint"

    static const int kBorrowConstraint = 3;

    /**
     * Clears the field "BorrowConstraint".
     *
     * The field will be set to its default value. The hasBorrowConstraint()
     * method will return false.
     */
    inline void clearBorrowConstraint();

    /**
     * Checks whether the field "BorrowConstraint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBorrowConstraint()). Otherwise it will return false.
     */
    inline bool hasBorrowConstraint () const;

    /**
     * Returns the value of the member "BorrowConstraint".
     *
     * Resource transfer priority.
     *
     * @return The value of the field "BorrowConstraint"
     */
    inline T_e8_ResourceTransferConstraint getBorrowConstraint () const;

    /**
     * Sets the value of the member "BorrowConstraint".
     *
     * Resource transfer priority.
     *
     * @param BorrowConstraint The value which will be set
     */
    inline void setBorrowConstraint (T_e8_ResourceTransferConstraint BorrowConstraint_);

    // API of field "BorrowId"

    static const int kBorrowId = 4;

    /**
     * Clears the field "BorrowId".
     *
     * The field will be set to its default value. The hasBorrowId()
     * method will return false.
     */
    inline void clearBorrowId();

    /**
     * Checks whether the field "BorrowId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBorrowId()). Otherwise it will return false.
     */
    inline bool hasBorrowId () const;

    /**
     * Returns the value of the member "BorrowId".
     *
     * Borrow Identifier for Transfer Type Borrow and Unborrow. Identifies the borrow which is removed by unborrow.
     * Should be set as blank for Transfer Type - Take / Untake.
     * Currently supported only for CarPlay.
     *
     * @return The value of the field "BorrowId"
     */
    inline const ::std::string& getBorrowId () const;

    /**
     * Retrieves the value of the field "BorrowId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BorrowId".
     */
    inline ::std::string& getBorrowIdMutable ();

    /**
     * Sets the value of the member "BorrowId".
     *
     * Borrow Identifier for Transfer Type Borrow and Unborrow. Identifies the borrow which is removed by unborrow.
     * Should be set as blank for Transfer Type - Take / Untake.
     * Currently supported only for CarPlay.
     *
     * @param BorrowId The value which will be set
     */
    inline void setBorrowId (const ::std::string& BorrowId_);

    /**
     * Sets the value of the member "BorrowId".
     *
     * Borrow Identifier for Transfer Type Borrow and Unborrow. Identifies the borrow which is removed by unborrow.
     * Should be set as blank for Transfer Type - Take / Untake.
     * Currently supported only for CarPlay.
     *
     * @param BorrowId The value which will be set
     */
    inline void setBorrowId (const char* BorrowId_);

    /**
     * Sets the value of the member "BorrowId".
     *
     * Borrow Identifier for Transfer Type Borrow and Unborrow. Identifies the borrow which is removed by unborrow.
     * Should be set as blank for Transfer Type - Take / Untake.
     * Currently supported only for CarPlay.
     *
     * @param BorrowId The value which will be set
     */
    inline void setBorrowId (const char* value, size_t size);

    static const T_DisplayConstraint &getDefaultInstance();

private:

    inline void set_has_TransferType ();

    inline void clear_has_TransferType ();

    inline void set_has_TransferPriority ();

    inline void clear_has_TransferPriority ();

    inline void set_has_TakeConstraint ();

    inline void clear_has_TakeConstraint ();

    inline void set_has_BorrowConstraint ();

    inline void clear_has_BorrowConstraint ();

    inline void set_has_BorrowId ();

    inline void clear_has_BorrowId ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_ResourceTransferType _TransferType;

    T_e8_ResourceTransferPriority _TransferPriority;

    T_e8_ResourceTransferConstraint _TakeConstraint;

    T_e8_ResourceTransferConstraint _BorrowConstraint;

    ::std::string _BorrowId;

};

/**
 * This structure provides information about display layer and surface area for different SPI technologies
 */
class T_DisplayLayerAttributes {
public:

    /**
     * Default constructor
     */
    inline  T_DisplayLayerAttributes ();

    /**
     * Copy constructor
     */
    inline  T_DisplayLayerAttributes (const T_DisplayLayerAttributes &rhs);

    /**
     * All fields constructor
     */
    inline  T_DisplayLayerAttributes (T_e8_DeviceCategory enDeviceCategory_, uint16 u16TouchLayerID_, uint16 u16TouchSurfaceID_, uint16 u16VideoLayerID_, uint16 u16VideoSurfaceID_, uint16 u16LayerWidth_, uint16 u16LayerHeight_, uint16 u16LayerWidthInMM_, uint16 u16LayerHeightInMM_, const ::std::string& szPixelAspectRatio_, uint16 u16DPI_, T_e8_DisplayTouchType enDisplayTouchType_, uint16 u16PriorityIndex_);

    /**
     * Destructor
     */
    inline  ~T_DisplayLayerAttributes();

    /**
     * Assignment operator
     */
    inline T_DisplayLayerAttributes& operator = (const T_DisplayLayerAttributes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DisplayLayerAttributes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DisplayLayerAttributes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DisplayLayerAttributes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DisplayLayerAttributes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enDeviceCategory"

    static const int kEnDeviceCategory = 0;

    /**
     * Clears the field "enDeviceCategory".
     *
     * The field will be set to its default value. The hasEnDeviceCategory()
     * method will return false.
     */
    inline void clearEnDeviceCategory();

    /**
     * Checks whether the field "enDeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasEnDeviceCategory () const;

    /**
     * Returns the value of the member "enDeviceCategory".
     *
     * Provides the type of technology that needs to used for setting the parameters.
     * If this value is unknown all the other parameters in this structure will be ignored.
     *
     * @return The value of the field "enDeviceCategory"
     */
    inline T_e8_DeviceCategory getEnDeviceCategory () const;

    /**
     * Sets the value of the member "enDeviceCategory".
     *
     * Provides the type of technology that needs to used for setting the parameters.
     * If this value is unknown all the other parameters in this structure will be ignored.
     *
     * @param enDeviceCategory The value which will be set
     */
    inline void setEnDeviceCategory (T_e8_DeviceCategory enDeviceCategory_);

    // API of field "u16TouchLayerID"

    static const int kU16TouchLayerID = 1;

    /**
     * Clears the field "u16TouchLayerID".
     *
     * The field will be set to its default value. The hasU16TouchLayerID()
     * method will return false.
     */
    inline void clearU16TouchLayerID();

    /**
     * Checks whether the field "u16TouchLayerID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16TouchLayerID()). Otherwise it will return false.
     */
    inline bool hasU16TouchLayerID () const;

    /**
     * Returns the value of the member "u16TouchLayerID".
     *
     * Indicates the Touch Layer that needs to be used for the SPI technology(enDeviceCategory)
     *
     * @return The value of the field "u16TouchLayerID"
     */
    inline uint16 getU16TouchLayerID () const;

    /**
     * Sets the value of the member "u16TouchLayerID".
     *
     * Indicates the Touch Layer that needs to be used for the SPI technology(enDeviceCategory)
     *
     * @param u16TouchLayerID The value which will be set
     */
    inline void setU16TouchLayerID (uint16 u16TouchLayerID_);

    // API of field "u16TouchSurfaceID"

    static const int kU16TouchSurfaceID = 2;

    /**
     * Clears the field "u16TouchSurfaceID".
     *
     * The field will be set to its default value. The hasU16TouchSurfaceID()
     * method will return false.
     */
    inline void clearU16TouchSurfaceID();

    /**
     * Checks whether the field "u16TouchSurfaceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16TouchSurfaceID()). Otherwise it will return false.
     */
    inline bool hasU16TouchSurfaceID () const;

    /**
     * Returns the value of the member "u16TouchSurfaceID".
     *
     * Indicates the Touch Surface that needs to be used for the SPI technology(enDeviceCategory)
     *
     * @return The value of the field "u16TouchSurfaceID"
     */
    inline uint16 getU16TouchSurfaceID () const;

    /**
     * Sets the value of the member "u16TouchSurfaceID".
     *
     * Indicates the Touch Surface that needs to be used for the SPI technology(enDeviceCategory)
     *
     * @param u16TouchSurfaceID The value which will be set
     */
    inline void setU16TouchSurfaceID (uint16 u16TouchSurfaceID_);

    // API of field "u16VideoLayerID"

    static const int kU16VideoLayerID = 3;

    /**
     * Clears the field "u16VideoLayerID".
     *
     * The field will be set to its default value. The hasU16VideoLayerID()
     * method will return false.
     */
    inline void clearU16VideoLayerID();

    /**
     * Checks whether the field "u16VideoLayerID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16VideoLayerID()). Otherwise it will return false.
     */
    inline bool hasU16VideoLayerID () const;

    /**
     * Returns the value of the member "u16VideoLayerID".
     *
     * Indicates the Video Layer that needs to be used for the SPI technology(enDeviceCategory)
     *
     * @return The value of the field "u16VideoLayerID"
     */
    inline uint16 getU16VideoLayerID () const;

    /**
     * Sets the value of the member "u16VideoLayerID".
     *
     * Indicates the Video Layer that needs to be used for the SPI technology(enDeviceCategory)
     *
     * @param u16VideoLayerID The value which will be set
     */
    inline void setU16VideoLayerID (uint16 u16VideoLayerID_);

    // API of field "u16VideoSurfaceID"

    static const int kU16VideoSurfaceID = 4;

    /**
     * Clears the field "u16VideoSurfaceID".
     *
     * The field will be set to its default value. The hasU16VideoSurfaceID()
     * method will return false.
     */
    inline void clearU16VideoSurfaceID();

    /**
     * Checks whether the field "u16VideoSurfaceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16VideoSurfaceID()). Otherwise it will return false.
     */
    inline bool hasU16VideoSurfaceID () const;

    /**
     * Returns the value of the member "u16VideoSurfaceID".
     *
     * Indicates the Video Surface that needs to be used for the SPI technology(enDeviceCategory)
     *
     * @return The value of the field "u16VideoSurfaceID"
     */
    inline uint16 getU16VideoSurfaceID () const;

    /**
     * Sets the value of the member "u16VideoSurfaceID".
     *
     * Indicates the Video Surface that needs to be used for the SPI technology(enDeviceCategory)
     *
     * @param u16VideoSurfaceID The value which will be set
     */
    inline void setU16VideoSurfaceID (uint16 u16VideoSurfaceID_);

    // API of field "u16LayerWidth"

    static const int kU16LayerWidth = 5;

    /**
     * Clears the field "u16LayerWidth".
     *
     * The field will be set to its default value. The hasU16LayerWidth()
     * method will return false.
     */
    inline void clearU16LayerWidth();

    /**
     * Checks whether the field "u16LayerWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LayerWidth()). Otherwise it will return false.
     */
    inline bool hasU16LayerWidth () const;

    /**
     * Returns the value of the member "u16LayerWidth".
     *
     * Indicates the Width for SPI technology(enDeviceCategory) that will be used for displaying the content. Units in pixels
     *
     * @return The value of the field "u16LayerWidth"
     */
    inline uint16 getU16LayerWidth () const;

    /**
     * Sets the value of the member "u16LayerWidth".
     *
     * Indicates the Width for SPI technology(enDeviceCategory) that will be used for displaying the content. Units in pixels
     *
     * @param u16LayerWidth The value which will be set
     */
    inline void setU16LayerWidth (uint16 u16LayerWidth_);

    // API of field "u16LayerHeight"

    static const int kU16LayerHeight = 6;

    /**
     * Clears the field "u16LayerHeight".
     *
     * The field will be set to its default value. The hasU16LayerHeight()
     * method will return false.
     */
    inline void clearU16LayerHeight();

    /**
     * Checks whether the field "u16LayerHeight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LayerHeight()). Otherwise it will return false.
     */
    inline bool hasU16LayerHeight () const;

    /**
     * Returns the value of the member "u16LayerHeight".
     *
     * Indicates the Height for SPI technology(enDeviceCategory) that will be used for displaying the content. Units in pixels
     *
     * @return The value of the field "u16LayerHeight"
     */
    inline uint16 getU16LayerHeight () const;

    /**
     * Sets the value of the member "u16LayerHeight".
     *
     * Indicates the Height for SPI technology(enDeviceCategory) that will be used for displaying the content. Units in pixels
     *
     * @param u16LayerHeight The value which will be set
     */
    inline void setU16LayerHeight (uint16 u16LayerHeight_);

    // API of field "u16LayerWidthInMM"

    static const int kU16LayerWidthInMM = 7;

    /**
     * Clears the field "u16LayerWidthInMM".
     *
     * The field will be set to its default value. The hasU16LayerWidthInMM()
     * method will return false.
     */
    inline void clearU16LayerWidthInMM();

    /**
     * Checks whether the field "u16LayerWidthInMM" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LayerWidthInMM()). Otherwise it will return false.
     */
    inline bool hasU16LayerWidthInMM () const;

    /**
     * Returns the value of the member "u16LayerWidthInMM".
     *
     * Indicates the Width for SPI technology(enDeviceCategory) that will be used for displaying the content. Units in millimeter
     *
     * @return The value of the field "u16LayerWidthInMM"
     */
    inline uint16 getU16LayerWidthInMM () const;

    /**
     * Sets the value of the member "u16LayerWidthInMM".
     *
     * Indicates the Width for SPI technology(enDeviceCategory) that will be used for displaying the content. Units in millimeter
     *
     * @param u16LayerWidthInMM The value which will be set
     */
    inline void setU16LayerWidthInMM (uint16 u16LayerWidthInMM_);

    // API of field "u16LayerHeightInMM"

    static const int kU16LayerHeightInMM = 8;

    /**
     * Clears the field "u16LayerHeightInMM".
     *
     * The field will be set to its default value. The hasU16LayerHeightInMM()
     * method will return false.
     */
    inline void clearU16LayerHeightInMM();

    /**
     * Checks whether the field "u16LayerHeightInMM" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LayerHeightInMM()). Otherwise it will return false.
     */
    inline bool hasU16LayerHeightInMM () const;

    /**
     * Returns the value of the member "u16LayerHeightInMM".
     *
     * Indicates the Height for SPI technology(enDeviceCategory) that will be used for displaying the content. Units in millimeters
     *
     * @return The value of the field "u16LayerHeightInMM"
     */
    inline uint16 getU16LayerHeightInMM () const;

    /**
     * Sets the value of the member "u16LayerHeightInMM".
     *
     * Indicates the Height for SPI technology(enDeviceCategory) that will be used for displaying the content. Units in millimeters
     *
     * @param u16LayerHeightInMM The value which will be set
     */
    inline void setU16LayerHeightInMM (uint16 u16LayerHeightInMM_);

    // API of field "szPixelAspectRatio"

    static const int kSzPixelAspectRatio = 9;

    /**
     * Clears the field "szPixelAspectRatio".
     *
     * The field will be set to its default value. The hasSzPixelAspectRatio()
     * method will return false.
     */
    inline void clearSzPixelAspectRatio();

    /**
     * Checks whether the field "szPixelAspectRatio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzPixelAspectRatio()). Otherwise it will return false.
     */
    inline bool hasSzPixelAspectRatio () const;

    /**
     * Returns the value of the member "szPixelAspectRatio".
     *
     * Information pixel aspect ratio of the screen
     *
     * @return The value of the field "szPixelAspectRatio"
     */
    inline const ::std::string& getSzPixelAspectRatio () const;

    /**
     * Retrieves the value of the field "szPixelAspectRatio" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szPixelAspectRatio".
     */
    inline ::std::string& getSzPixelAspectRatioMutable ();

    /**
     * Sets the value of the member "szPixelAspectRatio".
     *
     * Information pixel aspect ratio of the screen
     *
     * @param szPixelAspectRatio The value which will be set
     */
    inline void setSzPixelAspectRatio (const ::std::string& szPixelAspectRatio_);

    /**
     * Sets the value of the member "szPixelAspectRatio".
     *
     * Information pixel aspect ratio of the screen
     *
     * @param szPixelAspectRatio The value which will be set
     */
    inline void setSzPixelAspectRatio (const char* szPixelAspectRatio_);

    /**
     * Sets the value of the member "szPixelAspectRatio".
     *
     * Information pixel aspect ratio of the screen
     *
     * @param szPixelAspectRatio The value which will be set
     */
    inline void setSzPixelAspectRatio (const char* value, size_t size);

    // API of field "u16DPI"

    static const int kU16DPI = 10;

    /**
     * Clears the field "u16DPI".
     *
     * The field will be set to its default value. The hasU16DPI()
     * method will return false.
     */
    inline void clearU16DPI();

    /**
     * Checks whether the field "u16DPI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16DPI()). Otherwise it will return false.
     */
    inline bool hasU16DPI () const;

    /**
     * Returns the value of the member "u16DPI".
     *
     * Dots per Inch - resolution value
     *
     * @return The value of the field "u16DPI"
     */
    inline uint16 getU16DPI () const;

    /**
     * Sets the value of the member "u16DPI".
     *
     * Dots per Inch - resolution value
     *
     * @param u16DPI The value which will be set
     */
    inline void setU16DPI (uint16 u16DPI_);

    // API of field "enDisplayTouchType"

    static const int kEnDisplayTouchType = 11;

    /**
     * Clears the field "enDisplayTouchType".
     *
     * The field will be set to its default value. The hasEnDisplayTouchType()
     * method will return false.
     */
    inline void clearEnDisplayTouchType();

    /**
     * Checks whether the field "enDisplayTouchType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDisplayTouchType()). Otherwise it will return false.
     */
    inline bool hasEnDisplayTouchType () const;

    /**
     * Returns the value of the member "enDisplayTouchType".
     *
     * Information about kind of display touch supported
     *
     * @return The value of the field "enDisplayTouchType"
     */
    inline T_e8_DisplayTouchType getEnDisplayTouchType () const;

    /**
     * Sets the value of the member "enDisplayTouchType".
     *
     * Information about kind of display touch supported
     *
     * @param enDisplayTouchType The value which will be set
     */
    inline void setEnDisplayTouchType (T_e8_DisplayTouchType enDisplayTouchType_);

    // API of field "u16PriorityIndex"

    static const int kU16PriorityIndex = 12;

    /**
     * Clears the field "u16PriorityIndex".
     *
     * The field will be set to its default value. The hasU16PriorityIndex()
     * method will return false.
     */
    inline void clearU16PriorityIndex();

    /**
     * Checks whether the field "u16PriorityIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PriorityIndex()). Otherwise it will return false.
     */
    inline bool hasU16PriorityIndex () const;

    /**
     * Returns the value of the member "u16PriorityIndex".
     *
     * Used to determine the priority for this set of display attributes when more than one set of disaplay attributes are supported for a DeviceCategory. Lower the number, higher the priority.
     * This field is currently used only for Andorid Auto. For other technologies, the DisplayAttributes with lowest priority index(0) will be considered if multiple display attributes are set by HMI
     *
     * @return The value of the field "u16PriorityIndex"
     */
    inline uint16 getU16PriorityIndex () const;

    /**
     * Sets the value of the member "u16PriorityIndex".
     *
     * Used to determine the priority for this set of display attributes when more than one set of disaplay attributes are supported for a DeviceCategory. Lower the number, higher the priority.
     * This field is currently used only for Andorid Auto. For other technologies, the DisplayAttributes with lowest priority index(0) will be considered if multiple display attributes are set by HMI
     *
     * @param u16PriorityIndex The value which will be set
     */
    inline void setU16PriorityIndex (uint16 u16PriorityIndex_);

    static const T_DisplayLayerAttributes &getDefaultInstance();

private:

    inline void set_has_enDeviceCategory ();

    inline void clear_has_enDeviceCategory ();

    inline void set_has_u16TouchLayerID ();

    inline void clear_has_u16TouchLayerID ();

    inline void set_has_u16TouchSurfaceID ();

    inline void clear_has_u16TouchSurfaceID ();

    inline void set_has_u16VideoLayerID ();

    inline void clear_has_u16VideoLayerID ();

    inline void set_has_u16VideoSurfaceID ();

    inline void clear_has_u16VideoSurfaceID ();

    inline void set_has_u16LayerWidth ();

    inline void clear_has_u16LayerWidth ();

    inline void set_has_u16LayerHeight ();

    inline void clear_has_u16LayerHeight ();

    inline void set_has_u16LayerWidthInMM ();

    inline void clear_has_u16LayerWidthInMM ();

    inline void set_has_u16LayerHeightInMM ();

    inline void clear_has_u16LayerHeightInMM ();

    inline void set_has_szPixelAspectRatio ();

    inline void clear_has_szPixelAspectRatio ();

    inline void set_has_u16DPI ();

    inline void clear_has_u16DPI ();

    inline void set_has_enDisplayTouchType ();

    inline void clear_has_enDisplayTouchType ();

    inline void set_has_u16PriorityIndex ();

    inline void clear_has_u16PriorityIndex ();

    uint32 _has_bits_[ (13 + 31) / 32];

    T_e8_DeviceCategory _enDeviceCategory;

    uint16 _u16TouchLayerID;

    uint16 _u16TouchSurfaceID;

    uint16 _u16VideoLayerID;

    uint16 _u16VideoSurfaceID;

    uint16 _u16LayerWidth;

    uint16 _u16LayerHeight;

    uint16 _u16LayerWidthInMM;

    uint16 _u16LayerHeightInMM;

    ::std::string _szPixelAspectRatio;

    uint16 _u16DPI;

    T_e8_DisplayTouchType _enDisplayTouchType;

    uint16 _u16PriorityIndex;

};

/**
 * This structure provides Display attributes
 */
class T_DisplayAttributes {
public:

    /**
     * Default constructor
     */
    inline  T_DisplayAttributes ();

    /**
     * Copy constructor
     */
    inline  T_DisplayAttributes (const T_DisplayAttributes &rhs);

    /**
     * All fields constructor
     */
    inline  T_DisplayAttributes (uint16 u16ScreenHeight_, uint16 u16ScreenWidth_, uint16 u16ScreenHeightMm_, uint16 u16ScreenWidthMm_, T_e8_DisplayType enDisplayType_, const ::std::vector< T_DisplayLayerAttributes >& DisplayLayerAttributes_);

    /**
     * Destructor
     */
    inline  ~T_DisplayAttributes();

    /**
     * Assignment operator
     */
    inline T_DisplayAttributes& operator = (const T_DisplayAttributes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DisplayAttributes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DisplayAttributes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DisplayAttributes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DisplayAttributes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ScreenHeight"

    static const int kU16ScreenHeight = 0;

    /**
     * Clears the field "u16ScreenHeight".
     *
     * The field will be set to its default value. The hasU16ScreenHeight()
     * method will return false.
     */
    inline void clearU16ScreenHeight();

    /**
     * Checks whether the field "u16ScreenHeight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ScreenHeight()). Otherwise it will return false.
     */
    inline bool hasU16ScreenHeight () const;

    /**
     * Returns the value of the member "u16ScreenHeight".
     *
     * Information for physical Height in pixels of the screen
     *
     * @return The value of the field "u16ScreenHeight"
     */
    inline uint16 getU16ScreenHeight () const;

    /**
     * Sets the value of the member "u16ScreenHeight".
     *
     * Information for physical Height in pixels of the screen
     *
     * @param u16ScreenHeight The value which will be set
     */
    inline void setU16ScreenHeight (uint16 u16ScreenHeight_);

    // API of field "u16ScreenWidth"

    static const int kU16ScreenWidth = 1;

    /**
     * Clears the field "u16ScreenWidth".
     *
     * The field will be set to its default value. The hasU16ScreenWidth()
     * method will return false.
     */
    inline void clearU16ScreenWidth();

    /**
     * Checks whether the field "u16ScreenWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ScreenWidth()). Otherwise it will return false.
     */
    inline bool hasU16ScreenWidth () const;

    /**
     * Returns the value of the member "u16ScreenWidth".
     *
     * Information for physical width in pixels of the screen
     *
     * @return The value of the field "u16ScreenWidth"
     */
    inline uint16 getU16ScreenWidth () const;

    /**
     * Sets the value of the member "u16ScreenWidth".
     *
     * Information for physical width in pixels of the screen
     *
     * @param u16ScreenWidth The value which will be set
     */
    inline void setU16ScreenWidth (uint16 u16ScreenWidth_);

    // API of field "u16ScreenHeightMm"

    static const int kU16ScreenHeightMm = 2;

    /**
     * Clears the field "u16ScreenHeightMm".
     *
     * The field will be set to its default value. The hasU16ScreenHeightMm()
     * method will return false.
     */
    inline void clearU16ScreenHeightMm();

    /**
     * Checks whether the field "u16ScreenHeightMm" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ScreenHeightMm()). Otherwise it will return false.
     */
    inline bool hasU16ScreenHeightMm () const;

    /**
     * Returns the value of the member "u16ScreenHeightMm".
     *
     * Information for physical Height in millimeter of the screen
     *
     * @return The value of the field "u16ScreenHeightMm"
     */
    inline uint16 getU16ScreenHeightMm () const;

    /**
     * Sets the value of the member "u16ScreenHeightMm".
     *
     * Information for physical Height in millimeter of the screen
     *
     * @param u16ScreenHeightMm The value which will be set
     */
    inline void setU16ScreenHeightMm (uint16 u16ScreenHeightMm_);

    // API of field "u16ScreenWidthMm"

    static const int kU16ScreenWidthMm = 3;

    /**
     * Clears the field "u16ScreenWidthMm".
     *
     * The field will be set to its default value. The hasU16ScreenWidthMm()
     * method will return false.
     */
    inline void clearU16ScreenWidthMm();

    /**
     * Checks whether the field "u16ScreenWidthMm" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ScreenWidthMm()). Otherwise it will return false.
     */
    inline bool hasU16ScreenWidthMm () const;

    /**
     * Returns the value of the member "u16ScreenWidthMm".
     *
     * Information for physical width in millimeter of the screen
     *
     * @return The value of the field "u16ScreenWidthMm"
     */
    inline uint16 getU16ScreenWidthMm () const;

    /**
     * Sets the value of the member "u16ScreenWidthMm".
     *
     * Information for physical width in millimeter of the screen
     *
     * @param u16ScreenWidthMm The value which will be set
     */
    inline void setU16ScreenWidthMm (uint16 u16ScreenWidthMm_);

    // API of field "enDisplayType"

    static const int kEnDisplayType = 4;

    /**
     * Clears the field "enDisplayType".
     *
     * The field will be set to its default value. The hasEnDisplayType()
     * method will return false.
     */
    inline void clearEnDisplayType();

    /**
     * Checks whether the field "enDisplayType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDisplayType()). Otherwise it will return false.
     */
    inline bool hasEnDisplayType () const;

    /**
     * Returns the value of the member "enDisplayType".
     *
     * Information about kind of display
     *
     * @return The value of the field "enDisplayType"
     */
    inline T_e8_DisplayType getEnDisplayType () const;

    /**
     * Sets the value of the member "enDisplayType".
     *
     * Information about kind of display
     *
     * @param enDisplayType The value which will be set
     */
    inline void setEnDisplayType (T_e8_DisplayType enDisplayType_);

    // API of field "DisplayLayerAttributes"

    static const int kDisplayLayerAttributes = 5;

    /**
     * Clears the field "DisplayLayerAttributes".
     *
     * The field will be set to its default value. The hasDisplayLayerAttributes()
     * method will return false.
     */
    inline void clearDisplayLayerAttributes();

    /**
     * Checks whether the field "DisplayLayerAttributes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayLayerAttributes()). Otherwise it will return false.
     */
    inline bool hasDisplayLayerAttributes () const;

    /**
     * Returns the value of the member "DisplayLayerAttributes".
     *
     * Information for setting different display layer parameters
     *
     * @return The value of the field "DisplayLayerAttributes"
     */
    inline const ::std::vector< T_DisplayLayerAttributes >& getDisplayLayerAttributes () const;

    /**
     * Retrieves the value of the field "DisplayLayerAttributes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayLayerAttributes".
     */
    inline ::std::vector< T_DisplayLayerAttributes >& getDisplayLayerAttributesMutable ();

    /**
     * Sets the value of the member "DisplayLayerAttributes".
     *
     * Information for setting different display layer parameters
     *
     * @param DisplayLayerAttributes The value which will be set
     */
    inline void setDisplayLayerAttributes (const ::std::vector< T_DisplayLayerAttributes >& DisplayLayerAttributes_);

    static const T_DisplayAttributes &getDefaultInstance();

private:

    static const ::std::vector< T_DisplayLayerAttributes >& getT_DisplayLayerAttributesList_DefaultInstance ();

    inline void set_has_u16ScreenHeight ();

    inline void clear_has_u16ScreenHeight ();

    inline void set_has_u16ScreenWidth ();

    inline void clear_has_u16ScreenWidth ();

    inline void set_has_u16ScreenHeightMm ();

    inline void clear_has_u16ScreenHeightMm ();

    inline void set_has_u16ScreenWidthMm ();

    inline void clear_has_u16ScreenWidthMm ();

    inline void set_has_enDisplayType ();

    inline void clear_has_enDisplayType ();

    inline void set_has_DisplayLayerAttributes ();

    inline void clear_has_DisplayLayerAttributes ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint16 _u16ScreenHeight;

    uint16 _u16ScreenWidth;

    uint16 _u16ScreenHeightMm;

    uint16 _u16ScreenWidthMm;

    T_e8_DisplayType _enDisplayType;

    ::std::vector< T_DisplayLayerAttributes > _DisplayLayerAttributes;

};

/**
 * This structure provides information about the current accessory audio contexts.
 */
class T_AccessoryAudioContext {
public:

    /**
     * Default constructor
     */
    inline  T_AccessoryAudioContext ();

    /**
     * Copy constructor
     */
    inline  T_AccessoryAudioContext (const T_AccessoryAudioContext &rhs);

    /**
     * All fields constructor
     */
    inline  T_AccessoryAudioContext (T_e8_AudioContext AudioContext_, bool AudioFlag_);

    /**
     * Destructor
     */
    inline  ~T_AccessoryAudioContext();

    /**
     * Assignment operator
     */
    inline T_AccessoryAudioContext& operator = (const T_AccessoryAudioContext& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AccessoryAudioContext& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AccessoryAudioContext& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AccessoryAudioContext& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AccessoryAudioContext& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudioContext"

    static const int kAudioContext = 0;

    /**
     * Clears the field "AudioContext".
     *
     * The field will be set to its default value. The hasAudioContext()
     * method will return false.
     */
    inline void clearAudioContext();

    /**
     * Checks whether the field "AudioContext" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioContext()). Otherwise it will return false.
     */
    inline bool hasAudioContext () const;

    /**
     * Returns the value of the member "AudioContext".
     *
     * Audio context info.
     *
     * @return The value of the field "AudioContext"
     */
    inline T_e8_AudioContext getAudioContext () const;

    /**
     * Sets the value of the member "AudioContext".
     *
     * Audio context info.
     *
     * @param AudioContext The value which will be set
     */
    inline void setAudioContext (T_e8_AudioContext AudioContext_);

    // API of field "AudioFlag"

    static const int kAudioFlag = 1;

    /**
     * Clears the field "AudioFlag".
     *
     * The field will be set to its default value. The hasAudioFlag()
     * method will return false.
     */
    inline void clearAudioFlag();

    /**
     * Checks whether the field "AudioFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioFlag()). Otherwise it will return false.
     */
    inline bool hasAudioFlag () const;

    /**
     * Returns the value of the member "AudioFlag".
     *
     * TRUE - Accessory uses Audio resource, FALSE - Accessory does not use Audio resource.
     *
     * @return The value of the field "AudioFlag"
     */
    inline bool getAudioFlag () const;

    /**
     * Sets the value of the member "AudioFlag".
     *
     * TRUE - Accessory uses Audio resource, FALSE - Accessory does not use Audio resource.
     *
     * @param AudioFlag The value which will be set
     */
    inline void setAudioFlag (bool AudioFlag_);

    static const T_AccessoryAudioContext &getDefaultInstance();

private:

    inline void set_has_AudioContext ();

    inline void clear_has_AudioContext ();

    inline void set_has_AudioFlag ();

    inline void clear_has_AudioFlag ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_AudioContext _AudioContext;

    bool _AudioFlag;

};

/**
 * This structure provides information for authorization of devices.
 */
class T_DeviceAuthInfo {
public:

    /**
     * Default constructor
     */
    inline  T_DeviceAuthInfo ();

    /**
     * Copy constructor
     */
    inline  T_DeviceAuthInfo (const T_DeviceAuthInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_DeviceAuthInfo (uint32 DeviceHandle_, T_e8_DeviceType DeviceType_, T_e8_UserAuthorizationStatus UserAuthorizationStatus_);

    /**
     * Destructor
     */
    inline  ~T_DeviceAuthInfo();

    /**
     * Assignment operator
     */
    inline T_DeviceAuthInfo& operator = (const T_DeviceAuthInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DeviceAuthInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DeviceAuthInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DeviceAuthInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DeviceAuthInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceType"

    static const int kDeviceType = 1;

    /**
     * Clears the field "DeviceType".
     *
     * The field will be set to its default value. The hasDeviceType()
     * method will return false.
     */
    inline void clearDeviceType();

    /**
     * Checks whether the field "DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceType()). Otherwise it will return false.
     */
    inline bool hasDeviceType () const;

    /**
     * Returns the value of the member "DeviceType".
     *
     * Identifies the Device Type(Android/Apple device).
     *
     * @return The value of the field "DeviceType"
     */
    inline T_e8_DeviceType getDeviceType () const;

    /**
     * Sets the value of the member "DeviceType".
     *
     * Identifies the Device Type(Android/Apple device).
     *
     * @param DeviceType The value which will be set
     */
    inline void setDeviceType (T_e8_DeviceType DeviceType_);

    // API of field "UserAuthorizationStatus"

    static const int kUserAuthorizationStatus = 2;

    /**
     * Clears the field "UserAuthorizationStatus".
     *
     * The field will be set to its default value. The hasUserAuthorizationStatus()
     * method will return false.
     */
    inline void clearUserAuthorizationStatus();

    /**
     * Checks whether the field "UserAuthorizationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserAuthorizationStatus()). Otherwise it will return false.
     */
    inline bool hasUserAuthorizationStatus () const;

    /**
     * Returns the value of the member "UserAuthorizationStatus".
     *
     * Identifies the user authorization state.
     *
     * @return The value of the field "UserAuthorizationStatus"
     */
    inline T_e8_UserAuthorizationStatus getUserAuthorizationStatus () const;

    /**
     * Sets the value of the member "UserAuthorizationStatus".
     *
     * Identifies the user authorization state.
     *
     * @param UserAuthorizationStatus The value which will be set
     */
    inline void setUserAuthorizationStatus (T_e8_UserAuthorizationStatus UserAuthorizationStatus_);

    static const T_DeviceAuthInfo &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceType ();

    inline void clear_has_DeviceType ();

    inline void set_has_UserAuthorizationStatus ();

    inline void clear_has_UserAuthorizationStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    T_e8_DeviceType _DeviceType;

    T_e8_UserAuthorizationStatus _UserAuthorizationStatus;

};

/**
 * This structure provides information about the projection feature restriction.
 */
class T_FeatureRestriction {
public:

    /**
     * Default constructor
     */
    inline  T_FeatureRestriction ();

    /**
     * Copy constructor
     */
    inline  T_FeatureRestriction (const T_FeatureRestriction &rhs);

    /**
     * All fields constructor
     */
    inline  T_FeatureRestriction (uint8 FeatureLockout_);

    /**
     * Destructor
     */
    inline  ~T_FeatureRestriction();

    /**
     * Assignment operator
     */
    inline T_FeatureRestriction& operator = (const T_FeatureRestriction& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FeatureRestriction& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FeatureRestriction& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FeatureRestriction& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FeatureRestriction& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FeatureLockout"

    static const int kFeatureLockout = 0;

    /**
     * Clears the field "FeatureLockout".
     *
     * The field will be set to its default value. The hasFeatureLockout()
     * method will return false.
     */
    inline void clearFeatureLockout();

    /**
     * Checks whether the field "FeatureLockout" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFeatureLockout()). Otherwise it will return false.
     */
    inline bool hasFeatureLockout () const;

    /**
     * Returns the value of the member "FeatureLockout".
     *
     * Restrictions for CarPlay
     * 0th bit - SoftKeyboard
     * (Value 0 - SoftKeyboard not restricted, Value 1 - SoftKeyboard restricted)
     * 1st bit - SoftPhoneKeyPad
     * (Value 0 - SoftPhoneKeyPad not restricted, Value 1 - SoftPhoneKeyPad restricted)
     * 2nd bit - NonMusicLists
     * (Value 0 - NonMusicLists not restricted, Value 1 - NonMusicLists restricted)
     * 3rd bit - MusicLists
     * (Value 0 - MusicLists not restricted, Value 1 - MusicLists restricted)
     * 4th bit - JapanMaps
     * (Value 0 - JapanMaps not restricted, Value 1 - JapanMaps restricted)
     *
     * Restrictions for Android Auto
     * 0th bit - VideoPlayback
     * (Value 0 - VideoPlayback not restricted, Value 1 - VideoPlayback restricted)
     * 1st bit - TextInput
     * (Value 0 - TextInput not restricted, Value 1 - TextInput restricted)
     * 2nd bit - VoiceInput
     * (Value 0 - VoiceInput not restricted, Value 1 - VoiceInput restricted)
     * 3rd bit - SetUpAndConfiguration
     * (Value 0 - SetUpAndConfiguration not restricted, Value 1 - SetUpAndConfiguration restricted)
     * 4th bit - MessageLength
     * (Value 0 - Do not limit display message length, Value 1 - Limit display message length)
     *
     * @return The value of the field "FeatureLockout"
     */
    inline uint8 getFeatureLockout () const;

    /**
     * Sets the value of the member "FeatureLockout".
     *
     * Restrictions for CarPlay
     * 0th bit - SoftKeyboard
     * (Value 0 - SoftKeyboard not restricted, Value 1 - SoftKeyboard restricted)
     * 1st bit - SoftPhoneKeyPad
     * (Value 0 - SoftPhoneKeyPad not restricted, Value 1 - SoftPhoneKeyPad restricted)
     * 2nd bit - NonMusicLists
     * (Value 0 - NonMusicLists not restricted, Value 1 - NonMusicLists restricted)
     * 3rd bit - MusicLists
     * (Value 0 - MusicLists not restricted, Value 1 - MusicLists restricted)
     * 4th bit - JapanMaps
     * (Value 0 - JapanMaps not restricted, Value 1 - JapanMaps restricted)
     *
     * Restrictions for Android Auto
     * 0th bit - VideoPlayback
     * (Value 0 - VideoPlayback not restricted, Value 1 - VideoPlayback restricted)
     * 1st bit - TextInput
     * (Value 0 - TextInput not restricted, Value 1 - TextInput restricted)
     * 2nd bit - VoiceInput
     * (Value 0 - VoiceInput not restricted, Value 1 - VoiceInput restricted)
     * 3rd bit - SetUpAndConfiguration
     * (Value 0 - SetUpAndConfiguration not restricted, Value 1 - SetUpAndConfiguration restricted)
     * 4th bit - MessageLength
     * (Value 0 - Do not limit display message length, Value 1 - Limit display message length)
     *
     * @param FeatureLockout The value which will be set
     */
    inline void setFeatureLockout (uint8 FeatureLockout_);

    static const T_FeatureRestriction &getDefaultInstance();

private:

    inline void set_has_FeatureLockout ();

    inline void clear_has_FeatureLockout ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _FeatureLockout;

};

/**
 * This structure provides Wi-Fi AP credentials.
 */
class T_WiFiAPCredentials {
public:

    /**
     * Default constructor
     */
    inline  T_WiFiAPCredentials ();

    /**
     * Copy constructor
     */
    inline  T_WiFiAPCredentials (const T_WiFiAPCredentials &rhs);

    /**
     * All fields constructor
     */
    inline  T_WiFiAPCredentials (const ::std::string& SSID_, const ::std::string& PassPhrase_, uint16 ChannelNo_, T_e8_WiFiSecurityType SecurityType_);

    /**
     * Destructor
     */
    inline  ~T_WiFiAPCredentials();

    /**
     * Assignment operator
     */
    inline T_WiFiAPCredentials& operator = (const T_WiFiAPCredentials& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_WiFiAPCredentials& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_WiFiAPCredentials& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_WiFiAPCredentials& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_WiFiAPCredentials& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SSID"

    static const int kSSID = 0;

    /**
     * Clears the field "SSID".
     *
     * The field will be set to its default value. The hasSSID()
     * method will return false.
     */
    inline void clearSSID();

    /**
     * Checks whether the field "SSID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSID()). Otherwise it will return false.
     */
    inline bool hasSSID () const;

    /**
     * Returns the value of the member "SSID".
     *
     * Indicates the SSID of the Access Point.
     *
     * @return The value of the field "SSID"
     */
    inline const ::std::string& getSSID () const;

    /**
     * Retrieves the value of the field "SSID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SSID".
     */
    inline ::std::string& getSSIDMutable ();

    /**
     * Sets the value of the member "SSID".
     *
     * Indicates the SSID of the Access Point.
     *
     * @param SSID The value which will be set
     */
    inline void setSSID (const ::std::string& SSID_);

    /**
     * Sets the value of the member "SSID".
     *
     * Indicates the SSID of the Access Point.
     *
     * @param SSID The value which will be set
     */
    inline void setSSID (const char* SSID_);

    /**
     * Sets the value of the member "SSID".
     *
     * Indicates the SSID of the Access Point.
     *
     * @param SSID The value which will be set
     */
    inline void setSSID (const char* value, size_t size);

    // API of field "PassPhrase"

    static const int kPassPhrase = 1;

    /**
     * Clears the field "PassPhrase".
     *
     * The field will be set to its default value. The hasPassPhrase()
     * method will return false.
     */
    inline void clearPassPhrase();

    /**
     * Checks whether the field "PassPhrase" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPassPhrase()). Otherwise it will return false.
     */
    inline bool hasPassPhrase () const;

    /**
     * Returns the value of the member "PassPhrase".
     *
     * Indicates the PassPhrase of the Access Point. It is required, if secutity type is not None.
     *
     * @return The value of the field "PassPhrase"
     */
    inline const ::std::string& getPassPhrase () const;

    /**
     * Retrieves the value of the field "PassPhrase" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PassPhrase".
     */
    inline ::std::string& getPassPhraseMutable ();

    /**
     * Sets the value of the member "PassPhrase".
     *
     * Indicates the PassPhrase of the Access Point. It is required, if secutity type is not None.
     *
     * @param PassPhrase The value which will be set
     */
    inline void setPassPhrase (const ::std::string& PassPhrase_);

    /**
     * Sets the value of the member "PassPhrase".
     *
     * Indicates the PassPhrase of the Access Point. It is required, if secutity type is not None.
     *
     * @param PassPhrase The value which will be set
     */
    inline void setPassPhrase (const char* PassPhrase_);

    /**
     * Sets the value of the member "PassPhrase".
     *
     * Indicates the PassPhrase of the Access Point. It is required, if secutity type is not None.
     *
     * @param PassPhrase The value which will be set
     */
    inline void setPassPhrase (const char* value, size_t size);

    // API of field "ChannelNo"

    static const int kChannelNo = 2;

    /**
     * Clears the field "ChannelNo".
     *
     * The field will be set to its default value. The hasChannelNo()
     * method will return false.
     */
    inline void clearChannelNo();

    /**
     * Checks whether the field "ChannelNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelNo()). Otherwise it will return false.
     */
    inline bool hasChannelNo () const;

    /**
     * Returns the value of the member "ChannelNo".
     *
     * Indicates the Channel number on which access point is active.
     *
     * @return The value of the field "ChannelNo"
     */
    inline uint16 getChannelNo () const;

    /**
     * Sets the value of the member "ChannelNo".
     *
     * Indicates the Channel number on which access point is active.
     *
     * @param ChannelNo The value which will be set
     */
    inline void setChannelNo (uint16 ChannelNo_);

    // API of field "SecurityType"

    static const int kSecurityType = 3;

    /**
     * Clears the field "SecurityType".
     *
     * The field will be set to its default value. The hasSecurityType()
     * method will return false.
     */
    inline void clearSecurityType();

    /**
     * Checks whether the field "SecurityType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecurityType()). Otherwise it will return false.
     */
    inline bool hasSecurityType () const;

    /**
     * Returns the value of the member "SecurityType".
     *
     * Indicates the Security Type of the Access Point
     *
     * @return The value of the field "SecurityType"
     */
    inline T_e8_WiFiSecurityType getSecurityType () const;

    /**
     * Sets the value of the member "SecurityType".
     *
     * Indicates the Security Type of the Access Point
     *
     * @param SecurityType The value which will be set
     */
    inline void setSecurityType (T_e8_WiFiSecurityType SecurityType_);

    static const T_WiFiAPCredentials &getDefaultInstance();

private:

    inline void set_has_SSID ();

    inline void clear_has_SSID ();

    inline void set_has_PassPhrase ();

    inline void clear_has_PassPhrase ();

    inline void set_has_ChannelNo ();

    inline void clear_has_ChannelNo ();

    inline void set_has_SecurityType ();

    inline void clear_has_SecurityType ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _SSID;

    ::std::string _PassPhrase;

    uint16 _ChannelNo;

    T_e8_WiFiSecurityType _SecurityType;

};

/**
 * This structure provides OEMICON Details
 */
class T_OEMICONDetails {
public:

    /**
     * Default constructor
     */
    inline  T_OEMICONDetails ();

    /**
     * Copy constructor
     */
    inline  T_OEMICONDetails (const T_OEMICONDetails &rhs);

    /**
     * All fields constructor
     */
    inline  T_OEMICONDetails (const ::std::string& OEMIconName_, const ::std::string& OEMIconpath_);

    /**
     * Destructor
     */
    inline  ~T_OEMICONDetails();

    /**
     * Assignment operator
     */
    inline T_OEMICONDetails& operator = (const T_OEMICONDetails& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_OEMICONDetails& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_OEMICONDetails& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_OEMICONDetails& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_OEMICONDetails& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OEMIconName"

    static const int kOEMIconName = 0;

    /**
     * Clears the field "OEMIconName".
     *
     * The field will be set to its default value. The hasOEMIconName()
     * method will return false.
     */
    inline void clearOEMIconName();

    /**
     * Checks whether the field "OEMIconName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOEMIconName()). Otherwise it will return false.
     */
    inline bool hasOEMIconName () const;

    /**
     * Returns the value of the member "OEMIconName".
     *
     * OEMICOM Name. If not provided, it will be Empty String
     *
     * @return The value of the field "OEMIconName"
     */
    inline const ::std::string& getOEMIconName () const;

    /**
     * Retrieves the value of the field "OEMIconName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OEMIconName".
     */
    inline ::std::string& getOEMIconNameMutable ();

    /**
     * Sets the value of the member "OEMIconName".
     *
     * OEMICOM Name. If not provided, it will be Empty String
     *
     * @param OEMIconName The value which will be set
     */
    inline void setOEMIconName (const ::std::string& OEMIconName_);

    /**
     * Sets the value of the member "OEMIconName".
     *
     * OEMICOM Name. If not provided, it will be Empty String
     *
     * @param OEMIconName The value which will be set
     */
    inline void setOEMIconName (const char* OEMIconName_);

    /**
     * Sets the value of the member "OEMIconName".
     *
     * OEMICOM Name. If not provided, it will be Empty String
     *
     * @param OEMIconName The value which will be set
     */
    inline void setOEMIconName (const char* value, size_t size);

    // API of field "OEMIconpath"

    static const int kOEMIconpath = 1;

    /**
     * Clears the field "OEMIconpath".
     *
     * The field will be set to its default value. The hasOEMIconpath()
     * method will return false.
     */
    inline void clearOEMIconpath();

    /**
     * Checks whether the field "OEMIconpath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOEMIconpath()). Otherwise it will return false.
     */
    inline bool hasOEMIconpath () const;

    /**
     * Returns the value of the member "OEMIconpath".
     *
     * Param provides the path of the OEMICON image. If not provided, it will be Empty Path
     *
     * @return The value of the field "OEMIconpath"
     */
    inline const ::std::string& getOEMIconpath () const;

    /**
     * Retrieves the value of the field "OEMIconpath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OEMIconpath".
     */
    inline ::std::string& getOEMIconpathMutable ();

    /**
     * Sets the value of the member "OEMIconpath".
     *
     * Param provides the path of the OEMICON image. If not provided, it will be Empty Path
     *
     * @param OEMIconpath The value which will be set
     */
    inline void setOEMIconpath (const ::std::string& OEMIconpath_);

    /**
     * Sets the value of the member "OEMIconpath".
     *
     * Param provides the path of the OEMICON image. If not provided, it will be Empty Path
     *
     * @param OEMIconpath The value which will be set
     */
    inline void setOEMIconpath (const char* OEMIconpath_);

    /**
     * Sets the value of the member "OEMIconpath".
     *
     * Param provides the path of the OEMICON image. If not provided, it will be Empty Path
     *
     * @param OEMIconpath The value which will be set
     */
    inline void setOEMIconpath (const char* value, size_t size);

    static const T_OEMICONDetails &getDefaultInstance();

private:

    inline void set_has_OEMIconName ();

    inline void clear_has_OEMIconName ();

    inline void set_has_OEMIconpath ();

    inline void clear_has_OEMIconpath ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _OEMIconName;

    ::std::string _OEMIconpath;

};

/**
 * Structure contains RouteGuidance Update.
 */
class T_CarPlayRouteGuidanceUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_CarPlayRouteGuidanceUpdate ();

    /**
     * Copy constructor
     */
    inline  T_CarPlayRouteGuidanceUpdate (const T_CarPlayRouteGuidanceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_CarPlayRouteGuidanceUpdate (bool bRouteGuidanceDisplayComponentIDsAvailable_, const ::std::vector< T_e8_ComponentID >& e8RouteGuidanceDisplayComponentIDs_, bool bRouteGuidanceStateAvailable_, T_e8_DiPoRouteGuidanceState e8RouteGuidanceState_, bool bManeuverStateAvailable_, T_e8_DiPoManeuverState e8ManeuverState_, bool bCurrentRoadNameAvailable_, const ::std::string& szCurrentRoadName_, bool bDestinationNameAvailable_, const ::std::string& szDestinationName_, bool bEstimatedTimeOfArrivalAvailable_, uint64 u64EstimatedTimeOfArrival_, bool bTimeRemainingToDestinationAvailable_, uint64 u64TimeRemainingToDestination_, bool bDistanceRemainingAvailable_, uint32 u32DistanceRemaining_, bool bDistanceRemainingDisplayStrAvailable_, const ::std::string& szDistanceRemainingDisplayStr_, bool bDistanceRemainingDisplayUnitsAvailable_, T_e8_DistanceUnits e8DistanceRemainingDisplayUnits_, bool bDistanceToNextManeuverAvailable_, uint32 u32DistanceToNextManeuver_, bool bDistanceToNextManeuverDisplayStrAvailable_, const ::std::string& szDistanceToNextManeuverDisplayStr_, bool bDistanceToNextManeuverDisplayUnitsAvailable_, T_e8_DistanceUnits e8DistanceToNextManeuverDisplayUnits_, bool bRouteGuidanceManeuverCurrentListAvailable_, const ::std::vector< uint16 >& u16RouteGuidanceManeuverCurrentList_, bool bRouteGuidanceManeuverCountAvailable_, uint16 u16RouteGuidanceManeuverCount_, bool bRouteGuidanceVisibleInAppAvailable_, bool bIsRouteGuidanceVisibleInApp_, bool bSourceNameAvailable_, const ::std::string& SourceName_, bool bSourceSupportsRouteGuidanceAvailable_, bool SourceSupportsRouteGuidance_);

    /**
     * Destructor
     */
    inline  ~T_CarPlayRouteGuidanceUpdate();

    /**
     * Assignment operator
     */
    inline T_CarPlayRouteGuidanceUpdate& operator = (const T_CarPlayRouteGuidanceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CarPlayRouteGuidanceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CarPlayRouteGuidanceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CarPlayRouteGuidanceUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CarPlayRouteGuidanceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bRouteGuidanceDisplayComponentIDsAvailable"

    static const int kBRouteGuidanceDisplayComponentIDsAvailable = 0;

    /**
     * Clears the field "bRouteGuidanceDisplayComponentIDsAvailable".
     *
     * The field will be set to its default value. The hasBRouteGuidanceDisplayComponentIDsAvailable()
     * method will return false.
     */
    inline void clearBRouteGuidanceDisplayComponentIDsAvailable();

    /**
     * Checks whether the field "bRouteGuidanceDisplayComponentIDsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRouteGuidanceDisplayComponentIDsAvailable()). Otherwise it will return false.
     */
    inline bool hasBRouteGuidanceDisplayComponentIDsAvailable () const;

    /**
     * Returns the value of the member "bRouteGuidanceDisplayComponentIDsAvailable".
     *
     * Availability of e8RouteGuidanceDisplayComponentIDs parameter
     *
     * @return The value of the field "bRouteGuidanceDisplayComponentIDsAvailable"
     */
    inline bool getBRouteGuidanceDisplayComponentIDsAvailable () const;

    /**
     * Sets the value of the member "bRouteGuidanceDisplayComponentIDsAvailable".
     *
     * Availability of e8RouteGuidanceDisplayComponentIDs parameter
     *
     * @param bRouteGuidanceDisplayComponentIDsAvailable The value which will be set
     */
    inline void setBRouteGuidanceDisplayComponentIDsAvailable (bool bRouteGuidanceDisplayComponentIDsAvailable_);

    // API of field "e8RouteGuidanceDisplayComponentIDs"

    static const int kE8RouteGuidanceDisplayComponentIDs = 1;

    /**
     * Clears the field "e8RouteGuidanceDisplayComponentIDs".
     *
     * The field will be set to its default value. The hasE8RouteGuidanceDisplayComponentIDs()
     * method will return false.
     */
    inline void clearE8RouteGuidanceDisplayComponentIDs();

    /**
     * Checks whether the field "e8RouteGuidanceDisplayComponentIDs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RouteGuidanceDisplayComponentIDs()). Otherwise it will return false.
     */
    inline bool hasE8RouteGuidanceDisplayComponentIDs () const;

    /**
     * Returns the value of the member "e8RouteGuidanceDisplayComponentIDs".
     *
     * If none specified(i.e bRouteGuidanceDisplayComponentIDsAvailable is false or list is empty), it means the update applies to all components.
     * If more than one are specified, update is applied to all specified components.
     *
     * @return The value of the field "e8RouteGuidanceDisplayComponentIDs"
     */
    inline const ::std::vector< T_e8_ComponentID >& getE8RouteGuidanceDisplayComponentIDs () const;

    /**
     * Retrieves the value of the field "e8RouteGuidanceDisplayComponentIDs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "e8RouteGuidanceDisplayComponentIDs".
     */
    inline ::std::vector< T_e8_ComponentID >& getE8RouteGuidanceDisplayComponentIDsMutable ();

    /**
     * Sets the value of the member "e8RouteGuidanceDisplayComponentIDs".
     *
     * If none specified(i.e bRouteGuidanceDisplayComponentIDsAvailable is false or list is empty), it means the update applies to all components.
     * If more than one are specified, update is applied to all specified components.
     *
     * @param e8RouteGuidanceDisplayComponentIDs The value which will be set
     */
    inline void setE8RouteGuidanceDisplayComponentIDs (const ::std::vector< T_e8_ComponentID >& e8RouteGuidanceDisplayComponentIDs_);

    // API of field "bRouteGuidanceStateAvailable"

    static const int kBRouteGuidanceStateAvailable = 2;

    /**
     * Clears the field "bRouteGuidanceStateAvailable".
     *
     * The field will be set to its default value. The hasBRouteGuidanceStateAvailable()
     * method will return false.
     */
    inline void clearBRouteGuidanceStateAvailable();

    /**
     * Checks whether the field "bRouteGuidanceStateAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRouteGuidanceStateAvailable()). Otherwise it will return false.
     */
    inline bool hasBRouteGuidanceStateAvailable () const;

    /**
     * Returns the value of the member "bRouteGuidanceStateAvailable".
     *
     * Availability of e8RouteGuidanceState parameter
     *
     * @return The value of the field "bRouteGuidanceStateAvailable"
     */
    inline bool getBRouteGuidanceStateAvailable () const;

    /**
     * Sets the value of the member "bRouteGuidanceStateAvailable".
     *
     * Availability of e8RouteGuidanceState parameter
     *
     * @param bRouteGuidanceStateAvailable The value which will be set
     */
    inline void setBRouteGuidanceStateAvailable (bool bRouteGuidanceStateAvailable_);

    // API of field "e8RouteGuidanceState"

    static const int kE8RouteGuidanceState = 3;

    /**
     * Clears the field "e8RouteGuidanceState".
     *
     * The field will be set to its default value. The hasE8RouteGuidanceState()
     * method will return false.
     */
    inline void clearE8RouteGuidanceState();

    /**
     * Checks whether the field "e8RouteGuidanceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RouteGuidanceState()). Otherwise it will return false.
     */
    inline bool hasE8RouteGuidanceState () const;

    /**
     * Returns the value of the member "e8RouteGuidanceState".
     *
     * Indicates current RouteGuidance state which is one of the route guidance state enum.
     *
     * @return The value of the field "e8RouteGuidanceState"
     */
    inline T_e8_DiPoRouteGuidanceState getE8RouteGuidanceState () const;

    /**
     * Sets the value of the member "e8RouteGuidanceState".
     *
     * Indicates current RouteGuidance state which is one of the route guidance state enum.
     *
     * @param e8RouteGuidanceState The value which will be set
     */
    inline void setE8RouteGuidanceState (T_e8_DiPoRouteGuidanceState e8RouteGuidanceState_);

    // API of field "bManeuverStateAvailable"

    static const int kBManeuverStateAvailable = 4;

    /**
     * Clears the field "bManeuverStateAvailable".
     *
     * The field will be set to its default value. The hasBManeuverStateAvailable()
     * method will return false.
     */
    inline void clearBManeuverStateAvailable();

    /**
     * Checks whether the field "bManeuverStateAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBManeuverStateAvailable()). Otherwise it will return false.
     */
    inline bool hasBManeuverStateAvailable () const;

    /**
     * Returns the value of the member "bManeuverStateAvailable".
     *
     * Availability of e8ManeuverState parameter
     *
     * @return The value of the field "bManeuverStateAvailable"
     */
    inline bool getBManeuverStateAvailable () const;

    /**
     * Sets the value of the member "bManeuverStateAvailable".
     *
     * Availability of e8ManeuverState parameter
     *
     * @param bManeuverStateAvailable The value which will be set
     */
    inline void setBManeuverStateAvailable (bool bManeuverStateAvailable_);

    // API of field "e8ManeuverState"

    static const int kE8ManeuverState = 5;

    /**
     * Clears the field "e8ManeuverState".
     *
     * The field will be set to its default value. The hasE8ManeuverState()
     * method will return false.
     */
    inline void clearE8ManeuverState();

    /**
     * Checks whether the field "e8ManeuverState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ManeuverState()). Otherwise it will return false.
     */
    inline bool hasE8ManeuverState () const;

    /**
     * Returns the value of the member "e8ManeuverState".
     *
     * ManeuverState; see T_e8_DiPoManeuverState for more details .
     *
     * @return The value of the field "e8ManeuverState"
     */
    inline T_e8_DiPoManeuverState getE8ManeuverState () const;

    /**
     * Sets the value of the member "e8ManeuverState".
     *
     * ManeuverState; see T_e8_DiPoManeuverState for more details .
     *
     * @param e8ManeuverState The value which will be set
     */
    inline void setE8ManeuverState (T_e8_DiPoManeuverState e8ManeuverState_);

    // API of field "bCurrentRoadNameAvailable"

    static const int kBCurrentRoadNameAvailable = 6;

    /**
     * Clears the field "bCurrentRoadNameAvailable".
     *
     * The field will be set to its default value. The hasBCurrentRoadNameAvailable()
     * method will return false.
     */
    inline void clearBCurrentRoadNameAvailable();

    /**
     * Checks whether the field "bCurrentRoadNameAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCurrentRoadNameAvailable()). Otherwise it will return false.
     */
    inline bool hasBCurrentRoadNameAvailable () const;

    /**
     * Returns the value of the member "bCurrentRoadNameAvailable".
     *
     * Availability of szCurrentRoadName parameter
     *
     * @return The value of the field "bCurrentRoadNameAvailable"
     */
    inline bool getBCurrentRoadNameAvailable () const;

    /**
     * Sets the value of the member "bCurrentRoadNameAvailable".
     *
     * Availability of szCurrentRoadName parameter
     *
     * @param bCurrentRoadNameAvailable The value which will be set
     */
    inline void setBCurrentRoadNameAvailable (bool bCurrentRoadNameAvailable_);

    // API of field "szCurrentRoadName"

    static const int kSzCurrentRoadName = 7;

    /**
     * Clears the field "szCurrentRoadName".
     *
     * The field will be set to its default value. The hasSzCurrentRoadName()
     * method will return false.
     */
    inline void clearSzCurrentRoadName();

    /**
     * Checks whether the field "szCurrentRoadName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzCurrentRoadName()). Otherwise it will return false.
     */
    inline bool hasSzCurrentRoadName () const;

    /**
     * Returns the value of the member "szCurrentRoadName".
     *
     * The name of the current road.
     *
     * @return The value of the field "szCurrentRoadName"
     */
    inline const ::std::string& getSzCurrentRoadName () const;

    /**
     * Retrieves the value of the field "szCurrentRoadName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szCurrentRoadName".
     */
    inline ::std::string& getSzCurrentRoadNameMutable ();

    /**
     * Sets the value of the member "szCurrentRoadName".
     *
     * The name of the current road.
     *
     * @param szCurrentRoadName The value which will be set
     */
    inline void setSzCurrentRoadName (const ::std::string& szCurrentRoadName_);

    /**
     * Sets the value of the member "szCurrentRoadName".
     *
     * The name of the current road.
     *
     * @param szCurrentRoadName The value which will be set
     */
    inline void setSzCurrentRoadName (const char* szCurrentRoadName_);

    /**
     * Sets the value of the member "szCurrentRoadName".
     *
     * The name of the current road.
     *
     * @param szCurrentRoadName The value which will be set
     */
    inline void setSzCurrentRoadName (const char* value, size_t size);

    // API of field "bDestinationNameAvailable"

    static const int kBDestinationNameAvailable = 8;

    /**
     * Clears the field "bDestinationNameAvailable".
     *
     * The field will be set to its default value. The hasBDestinationNameAvailable()
     * method will return false.
     */
    inline void clearBDestinationNameAvailable();

    /**
     * Checks whether the field "bDestinationNameAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDestinationNameAvailable()). Otherwise it will return false.
     */
    inline bool hasBDestinationNameAvailable () const;

    /**
     * Returns the value of the member "bDestinationNameAvailable".
     *
     * Availability of szDestinationName parameter
     *
     * @return The value of the field "bDestinationNameAvailable"
     */
    inline bool getBDestinationNameAvailable () const;

    /**
     * Sets the value of the member "bDestinationNameAvailable".
     *
     * Availability of szDestinationName parameter
     *
     * @param bDestinationNameAvailable The value which will be set
     */
    inline void setBDestinationNameAvailable (bool bDestinationNameAvailable_);

    // API of field "szDestinationName"

    static const int kSzDestinationName = 9;

    /**
     * Clears the field "szDestinationName".
     *
     * The field will be set to its default value. The hasSzDestinationName()
     * method will return false.
     */
    inline void clearSzDestinationName();

    /**
     * Checks whether the field "szDestinationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDestinationName()). Otherwise it will return false.
     */
    inline bool hasSzDestinationName () const;

    /**
     * Returns the value of the member "szDestinationName".
     *
     * The name of the Destination.
     *
     * @return The value of the field "szDestinationName"
     */
    inline const ::std::string& getSzDestinationName () const;

    /**
     * Retrieves the value of the field "szDestinationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDestinationName".
     */
    inline ::std::string& getSzDestinationNameMutable ();

    /**
     * Sets the value of the member "szDestinationName".
     *
     * The name of the Destination.
     *
     * @param szDestinationName The value which will be set
     */
    inline void setSzDestinationName (const ::std::string& szDestinationName_);

    /**
     * Sets the value of the member "szDestinationName".
     *
     * The name of the Destination.
     *
     * @param szDestinationName The value which will be set
     */
    inline void setSzDestinationName (const char* szDestinationName_);

    /**
     * Sets the value of the member "szDestinationName".
     *
     * The name of the Destination.
     *
     * @param szDestinationName The value which will be set
     */
    inline void setSzDestinationName (const char* value, size_t size);

    // API of field "bEstimatedTimeOfArrivalAvailable"

    static const int kBEstimatedTimeOfArrivalAvailable = 10;

    /**
     * Clears the field "bEstimatedTimeOfArrivalAvailable".
     *
     * The field will be set to its default value. The hasBEstimatedTimeOfArrivalAvailable()
     * method will return false.
     */
    inline void clearBEstimatedTimeOfArrivalAvailable();

    /**
     * Checks whether the field "bEstimatedTimeOfArrivalAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEstimatedTimeOfArrivalAvailable()). Otherwise it will return false.
     */
    inline bool hasBEstimatedTimeOfArrivalAvailable () const;

    /**
     * Returns the value of the member "bEstimatedTimeOfArrivalAvailable".
     *
     * Availability of u64EstimatedTimeOfArrival parameter
     *
     * @return The value of the field "bEstimatedTimeOfArrivalAvailable"
     */
    inline bool getBEstimatedTimeOfArrivalAvailable () const;

    /**
     * Sets the value of the member "bEstimatedTimeOfArrivalAvailable".
     *
     * Availability of u64EstimatedTimeOfArrival parameter
     *
     * @param bEstimatedTimeOfArrivalAvailable The value which will be set
     */
    inline void setBEstimatedTimeOfArrivalAvailable (bool bEstimatedTimeOfArrivalAvailable_);

    // API of field "u64EstimatedTimeOfArrival"

    static const int kU64EstimatedTimeOfArrival = 11;

    /**
     * Clears the field "u64EstimatedTimeOfArrival".
     *
     * The field will be set to its default value. The hasU64EstimatedTimeOfArrival()
     * method will return false.
     */
    inline void clearU64EstimatedTimeOfArrival();

    /**
     * Checks whether the field "u64EstimatedTimeOfArrival" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64EstimatedTimeOfArrival()). Otherwise it will return false.
     */
    inline bool hasU64EstimatedTimeOfArrival () const;

    /**
     * Returns the value of the member "u64EstimatedTimeOfArrival".
     *
     * Number of seconds from reference date (i.e Jan 1, 1970 GMT, epoc time).
     * Client should use do the adjustment for the local time and display as per the field available e.g HH/MM/Sec dd/MM/year or only MM or only secs.
     *
     * @return The value of the field "u64EstimatedTimeOfArrival"
     */
    inline uint64 getU64EstimatedTimeOfArrival () const;

    /**
     * Sets the value of the member "u64EstimatedTimeOfArrival".
     *
     * Number of seconds from reference date (i.e Jan 1, 1970 GMT, epoc time).
     * Client should use do the adjustment for the local time and display as per the field available e.g HH/MM/Sec dd/MM/year or only MM or only secs.
     *
     * @param u64EstimatedTimeOfArrival The value which will be set
     */
    inline void setU64EstimatedTimeOfArrival (uint64 u64EstimatedTimeOfArrival_);

    // API of field "bTimeRemainingToDestinationAvailable"

    static const int kBTimeRemainingToDestinationAvailable = 12;

    /**
     * Clears the field "bTimeRemainingToDestinationAvailable".
     *
     * The field will be set to its default value. The hasBTimeRemainingToDestinationAvailable()
     * method will return false.
     */
    inline void clearBTimeRemainingToDestinationAvailable();

    /**
     * Checks whether the field "bTimeRemainingToDestinationAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTimeRemainingToDestinationAvailable()). Otherwise it will return false.
     */
    inline bool hasBTimeRemainingToDestinationAvailable () const;

    /**
     * Returns the value of the member "bTimeRemainingToDestinationAvailable".
     *
     * Availability of u64TimeRemainingToDestination parameter
     *
     * @return The value of the field "bTimeRemainingToDestinationAvailable"
     */
    inline bool getBTimeRemainingToDestinationAvailable () const;

    /**
     * Sets the value of the member "bTimeRemainingToDestinationAvailable".
     *
     * Availability of u64TimeRemainingToDestination parameter
     *
     * @param bTimeRemainingToDestinationAvailable The value which will be set
     */
    inline void setBTimeRemainingToDestinationAvailable (bool bTimeRemainingToDestinationAvailable_);

    // API of field "u64TimeRemainingToDestination"

    static const int kU64TimeRemainingToDestination = 13;

    /**
     * Clears the field "u64TimeRemainingToDestination".
     *
     * The field will be set to its default value. The hasU64TimeRemainingToDestination()
     * method will return false.
     */
    inline void clearU64TimeRemainingToDestination();

    /**
     * Checks whether the field "u64TimeRemainingToDestination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64TimeRemainingToDestination()). Otherwise it will return false.
     */
    inline bool hasU64TimeRemainingToDestination () const;

    /**
     * Returns the value of the member "u64TimeRemainingToDestination".
     *
     * Number of seconds to Destination.
     *
     * @return The value of the field "u64TimeRemainingToDestination"
     */
    inline uint64 getU64TimeRemainingToDestination () const;

    /**
     * Sets the value of the member "u64TimeRemainingToDestination".
     *
     * Number of seconds to Destination.
     *
     * @param u64TimeRemainingToDestination The value which will be set
     */
    inline void setU64TimeRemainingToDestination (uint64 u64TimeRemainingToDestination_);

    // API of field "bDistanceRemainingAvailable"

    static const int kBDistanceRemainingAvailable = 14;

    /**
     * Clears the field "bDistanceRemainingAvailable".
     *
     * The field will be set to its default value. The hasBDistanceRemainingAvailable()
     * method will return false.
     */
    inline void clearBDistanceRemainingAvailable();

    /**
     * Checks whether the field "bDistanceRemainingAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceRemainingAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceRemainingAvailable () const;

    /**
     * Returns the value of the member "bDistanceRemainingAvailable".
     *
     * Availability of u32DistanceRemaining parameter
     *
     * @return The value of the field "bDistanceRemainingAvailable"
     */
    inline bool getBDistanceRemainingAvailable () const;

    /**
     * Sets the value of the member "bDistanceRemainingAvailable".
     *
     * Availability of u32DistanceRemaining parameter
     *
     * @param bDistanceRemainingAvailable The value which will be set
     */
    inline void setBDistanceRemainingAvailable (bool bDistanceRemainingAvailable_);

    // API of field "u32DistanceRemaining"

    static const int kU32DistanceRemaining = 15;

    /**
     * Clears the field "u32DistanceRemaining".
     *
     * The field will be set to its default value. The hasU32DistanceRemaining()
     * method will return false.
     */
    inline void clearU32DistanceRemaining();

    /**
     * Checks whether the field "u32DistanceRemaining" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DistanceRemaining()). Otherwise it will return false.
     */
    inline bool hasU32DistanceRemaining () const;

    /**
     * Returns the value of the member "u32DistanceRemaining".
     *
     * Meters to end of trip. This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @return The value of the field "u32DistanceRemaining"
     */
    inline uint32 getU32DistanceRemaining () const;

    /**
     * Sets the value of the member "u32DistanceRemaining".
     *
     * Meters to end of trip. This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @param u32DistanceRemaining The value which will be set
     */
    inline void setU32DistanceRemaining (uint32 u32DistanceRemaining_);

    // API of field "bDistanceRemainingDisplayStrAvailable"

    static const int kBDistanceRemainingDisplayStrAvailable = 16;

    /**
     * Clears the field "bDistanceRemainingDisplayStrAvailable".
     *
     * The field will be set to its default value. The hasBDistanceRemainingDisplayStrAvailable()
     * method will return false.
     */
    inline void clearBDistanceRemainingDisplayStrAvailable();

    /**
     * Checks whether the field "bDistanceRemainingDisplayStrAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceRemainingDisplayStrAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceRemainingDisplayStrAvailable () const;

    /**
     * Returns the value of the member "bDistanceRemainingDisplayStrAvailable".
     *
     * Availability of szDistanceRemainingDisplayStr parameter
     *
     * @return The value of the field "bDistanceRemainingDisplayStrAvailable"
     */
    inline bool getBDistanceRemainingDisplayStrAvailable () const;

    /**
     * Sets the value of the member "bDistanceRemainingDisplayStrAvailable".
     *
     * Availability of szDistanceRemainingDisplayStr parameter
     *
     * @param bDistanceRemainingDisplayStrAvailable The value which will be set
     */
    inline void setBDistanceRemainingDisplayStrAvailable (bool bDistanceRemainingDisplayStrAvailable_);

    // API of field "szDistanceRemainingDisplayStr"

    static const int kSzDistanceRemainingDisplayStr = 17;

    /**
     * Clears the field "szDistanceRemainingDisplayStr".
     *
     * The field will be set to its default value. The hasSzDistanceRemainingDisplayStr()
     * method will return false.
     */
    inline void clearSzDistanceRemainingDisplayStr();

    /**
     * Checks whether the field "szDistanceRemainingDisplayStr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDistanceRemainingDisplayStr()). Otherwise it will return false.
     */
    inline bool hasSzDistanceRemainingDisplayStr () const;

    /**
     * Returns the value of the member "szDistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @return The value of the field "szDistanceRemainingDisplayStr"
     */
    inline const ::std::string& getSzDistanceRemainingDisplayStr () const;

    /**
     * Retrieves the value of the field "szDistanceRemainingDisplayStr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDistanceRemainingDisplayStr".
     */
    inline ::std::string& getSzDistanceRemainingDisplayStrMutable ();

    /**
     * Sets the value of the member "szDistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceRemainingDisplayStr The value which will be set
     */
    inline void setSzDistanceRemainingDisplayStr (const ::std::string& szDistanceRemainingDisplayStr_);

    /**
     * Sets the value of the member "szDistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceRemainingDisplayStr The value which will be set
     */
    inline void setSzDistanceRemainingDisplayStr (const char* szDistanceRemainingDisplayStr_);

    /**
     * Sets the value of the member "szDistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceRemainingDisplayStr The value which will be set
     */
    inline void setSzDistanceRemainingDisplayStr (const char* value, size_t size);

    // API of field "bDistanceRemainingDisplayUnitsAvailable"

    static const int kBDistanceRemainingDisplayUnitsAvailable = 18;

    /**
     * Clears the field "bDistanceRemainingDisplayUnitsAvailable".
     *
     * The field will be set to its default value. The hasBDistanceRemainingDisplayUnitsAvailable()
     * method will return false.
     */
    inline void clearBDistanceRemainingDisplayUnitsAvailable();

    /**
     * Checks whether the field "bDistanceRemainingDisplayUnitsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceRemainingDisplayUnitsAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceRemainingDisplayUnitsAvailable () const;

    /**
     * Returns the value of the member "bDistanceRemainingDisplayUnitsAvailable".
     *
     * Availability of e8DistanceRemainingDisplayUnits parameter
     *
     * @return The value of the field "bDistanceRemainingDisplayUnitsAvailable"
     */
    inline bool getBDistanceRemainingDisplayUnitsAvailable () const;

    /**
     * Sets the value of the member "bDistanceRemainingDisplayUnitsAvailable".
     *
     * Availability of e8DistanceRemainingDisplayUnits parameter
     *
     * @param bDistanceRemainingDisplayUnitsAvailable The value which will be set
     */
    inline void setBDistanceRemainingDisplayUnitsAvailable (bool bDistanceRemainingDisplayUnitsAvailable_);

    // API of field "e8DistanceRemainingDisplayUnits"

    static const int kE8DistanceRemainingDisplayUnits = 19;

    /**
     * Clears the field "e8DistanceRemainingDisplayUnits".
     *
     * The field will be set to its default value. The hasE8DistanceRemainingDisplayUnits()
     * method will return false.
     */
    inline void clearE8DistanceRemainingDisplayUnits();

    /**
     * Checks whether the field "e8DistanceRemainingDisplayUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceRemainingDisplayUnits()). Otherwise it will return false.
     */
    inline bool hasE8DistanceRemainingDisplayUnits () const;

    /**
     * Returns the value of the member "e8DistanceRemainingDisplayUnits".
     *
     * Units that must accompany DistanceRemainingDisplaystr when displayed to the user.
     *
     * @return The value of the field "e8DistanceRemainingDisplayUnits"
     */
    inline T_e8_DistanceUnits getE8DistanceRemainingDisplayUnits () const;

    /**
     * Sets the value of the member "e8DistanceRemainingDisplayUnits".
     *
     * Units that must accompany DistanceRemainingDisplaystr when displayed to the user.
     *
     * @param e8DistanceRemainingDisplayUnits The value which will be set
     */
    inline void setE8DistanceRemainingDisplayUnits (T_e8_DistanceUnits e8DistanceRemainingDisplayUnits_);

    // API of field "bDistanceToNextManeuverAvailable"

    static const int kBDistanceToNextManeuverAvailable = 20;

    /**
     * Clears the field "bDistanceToNextManeuverAvailable".
     *
     * The field will be set to its default value. The hasBDistanceToNextManeuverAvailable()
     * method will return false.
     */
    inline void clearBDistanceToNextManeuverAvailable();

    /**
     * Checks whether the field "bDistanceToNextManeuverAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceToNextManeuverAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceToNextManeuverAvailable () const;

    /**
     * Returns the value of the member "bDistanceToNextManeuverAvailable".
     *
     * Availability of u32DistanceToNextManeuver parameter
     *
     * @return The value of the field "bDistanceToNextManeuverAvailable"
     */
    inline bool getBDistanceToNextManeuverAvailable () const;

    /**
     * Sets the value of the member "bDistanceToNextManeuverAvailable".
     *
     * Availability of u32DistanceToNextManeuver parameter
     *
     * @param bDistanceToNextManeuverAvailable The value which will be set
     */
    inline void setBDistanceToNextManeuverAvailable (bool bDistanceToNextManeuverAvailable_);

    // API of field "u32DistanceToNextManeuver"

    static const int kU32DistanceToNextManeuver = 21;

    /**
     * Clears the field "u32DistanceToNextManeuver".
     *
     * The field will be set to its default value. The hasU32DistanceToNextManeuver()
     * method will return false.
     */
    inline void clearU32DistanceToNextManeuver();

    /**
     * Checks whether the field "u32DistanceToNextManeuver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DistanceToNextManeuver()). Otherwise it will return false.
     */
    inline bool hasU32DistanceToNextManeuver () const;

    /**
     * Returns the value of the member "u32DistanceToNextManeuver".
     *
     * Meters to next maneuver. This value must not be displayed to the user in text. It is only to be used for generating graphics,e.g. countdown bars.
     *
     * @return The value of the field "u32DistanceToNextManeuver"
     */
    inline uint32 getU32DistanceToNextManeuver () const;

    /**
     * Sets the value of the member "u32DistanceToNextManeuver".
     *
     * Meters to next maneuver. This value must not be displayed to the user in text. It is only to be used for generating graphics,e.g. countdown bars.
     *
     * @param u32DistanceToNextManeuver The value which will be set
     */
    inline void setU32DistanceToNextManeuver (uint32 u32DistanceToNextManeuver_);

    // API of field "bDistanceToNextManeuverDisplayStrAvailable"

    static const int kBDistanceToNextManeuverDisplayStrAvailable = 22;

    /**
     * Clears the field "bDistanceToNextManeuverDisplayStrAvailable".
     *
     * The field will be set to its default value. The hasBDistanceToNextManeuverDisplayStrAvailable()
     * method will return false.
     */
    inline void clearBDistanceToNextManeuverDisplayStrAvailable();

    /**
     * Checks whether the field "bDistanceToNextManeuverDisplayStrAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceToNextManeuverDisplayStrAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceToNextManeuverDisplayStrAvailable () const;

    /**
     * Returns the value of the member "bDistanceToNextManeuverDisplayStrAvailable".
     *
     * Availability of szDistanceToNextManeuverDisplayStr parameter
     *
     * @return The value of the field "bDistanceToNextManeuverDisplayStrAvailable"
     */
    inline bool getBDistanceToNextManeuverDisplayStrAvailable () const;

    /**
     * Sets the value of the member "bDistanceToNextManeuverDisplayStrAvailable".
     *
     * Availability of szDistanceToNextManeuverDisplayStr parameter
     *
     * @param bDistanceToNextManeuverDisplayStrAvailable The value which will be set
     */
    inline void setBDistanceToNextManeuverDisplayStrAvailable (bool bDistanceToNextManeuverDisplayStrAvailable_);

    // API of field "szDistanceToNextManeuverDisplayStr"

    static const int kSzDistanceToNextManeuverDisplayStr = 23;

    /**
     * Clears the field "szDistanceToNextManeuverDisplayStr".
     *
     * The field will be set to its default value. The hasSzDistanceToNextManeuverDisplayStr()
     * method will return false.
     */
    inline void clearSzDistanceToNextManeuverDisplayStr();

    /**
     * Checks whether the field "szDistanceToNextManeuverDisplayStr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDistanceToNextManeuverDisplayStr()). Otherwise it will return false.
     */
    inline bool hasSzDistanceToNextManeuverDisplayStr () const;

    /**
     * Returns the value of the member "szDistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @return The value of the field "szDistanceToNextManeuverDisplayStr"
     */
    inline const ::std::string& getSzDistanceToNextManeuverDisplayStr () const;

    /**
     * Retrieves the value of the field "szDistanceToNextManeuverDisplayStr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDistanceToNextManeuverDisplayStr".
     */
    inline ::std::string& getSzDistanceToNextManeuverDisplayStrMutable ();

    /**
     * Sets the value of the member "szDistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @param szDistanceToNextManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceToNextManeuverDisplayStr (const ::std::string& szDistanceToNextManeuverDisplayStr_);

    /**
     * Sets the value of the member "szDistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @param szDistanceToNextManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceToNextManeuverDisplayStr (const char* szDistanceToNextManeuverDisplayStr_);

    /**
     * Sets the value of the member "szDistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @param szDistanceToNextManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceToNextManeuverDisplayStr (const char* value, size_t size);

    // API of field "bDistanceToNextManeuverDisplayUnitsAvailable"

    static const int kBDistanceToNextManeuverDisplayUnitsAvailable = 24;

    /**
     * Clears the field "bDistanceToNextManeuverDisplayUnitsAvailable".
     *
     * The field will be set to its default value. The hasBDistanceToNextManeuverDisplayUnitsAvailable()
     * method will return false.
     */
    inline void clearBDistanceToNextManeuverDisplayUnitsAvailable();

    /**
     * Checks whether the field "bDistanceToNextManeuverDisplayUnitsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceToNextManeuverDisplayUnitsAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceToNextManeuverDisplayUnitsAvailable () const;

    /**
     * Returns the value of the member "bDistanceToNextManeuverDisplayUnitsAvailable".
     *
     * Availability of e8DistanceToNextManeuverDisplayUnits parameter
     *
     * @return The value of the field "bDistanceToNextManeuverDisplayUnitsAvailable"
     */
    inline bool getBDistanceToNextManeuverDisplayUnitsAvailable () const;

    /**
     * Sets the value of the member "bDistanceToNextManeuverDisplayUnitsAvailable".
     *
     * Availability of e8DistanceToNextManeuverDisplayUnits parameter
     *
     * @param bDistanceToNextManeuverDisplayUnitsAvailable The value which will be set
     */
    inline void setBDistanceToNextManeuverDisplayUnitsAvailable (bool bDistanceToNextManeuverDisplayUnitsAvailable_);

    // API of field "e8DistanceToNextManeuverDisplayUnits"

    static const int kE8DistanceToNextManeuverDisplayUnits = 25;

    /**
     * Clears the field "e8DistanceToNextManeuverDisplayUnits".
     *
     * The field will be set to its default value. The hasE8DistanceToNextManeuverDisplayUnits()
     * method will return false.
     */
    inline void clearE8DistanceToNextManeuverDisplayUnits();

    /**
     * Checks whether the field "e8DistanceToNextManeuverDisplayUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceToNextManeuverDisplayUnits()). Otherwise it will return false.
     */
    inline bool hasE8DistanceToNextManeuverDisplayUnits () const;

    /**
     * Returns the value of the member "e8DistanceToNextManeuverDisplayUnits".
     *
     * Units that must accompany DistanceToNextManeuverDisplayStr when displayed to the user.
     *
     * @return The value of the field "e8DistanceToNextManeuverDisplayUnits"
     */
    inline T_e8_DistanceUnits getE8DistanceToNextManeuverDisplayUnits () const;

    /**
     * Sets the value of the member "e8DistanceToNextManeuverDisplayUnits".
     *
     * Units that must accompany DistanceToNextManeuverDisplayStr when displayed to the user.
     *
     * @param e8DistanceToNextManeuverDisplayUnits The value which will be set
     */
    inline void setE8DistanceToNextManeuverDisplayUnits (T_e8_DistanceUnits e8DistanceToNextManeuverDisplayUnits_);

    // API of field "bRouteGuidanceManeuverCurrentListAvailable"

    static const int kBRouteGuidanceManeuverCurrentListAvailable = 26;

    /**
     * Clears the field "bRouteGuidanceManeuverCurrentListAvailable".
     *
     * The field will be set to its default value. The hasBRouteGuidanceManeuverCurrentListAvailable()
     * method will return false.
     */
    inline void clearBRouteGuidanceManeuverCurrentListAvailable();

    /**
     * Checks whether the field "bRouteGuidanceManeuverCurrentListAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRouteGuidanceManeuverCurrentListAvailable()). Otherwise it will return false.
     */
    inline bool hasBRouteGuidanceManeuverCurrentListAvailable () const;

    /**
     * Returns the value of the member "bRouteGuidanceManeuverCurrentListAvailable".
     *
     * Availability of u16RouteGuidanceManeuverCurrentList parameter
     *
     * @return The value of the field "bRouteGuidanceManeuverCurrentListAvailable"
     */
    inline bool getBRouteGuidanceManeuverCurrentListAvailable () const;

    /**
     * Sets the value of the member "bRouteGuidanceManeuverCurrentListAvailable".
     *
     * Availability of u16RouteGuidanceManeuverCurrentList parameter
     *
     * @param bRouteGuidanceManeuverCurrentListAvailable The value which will be set
     */
    inline void setBRouteGuidanceManeuverCurrentListAvailable (bool bRouteGuidanceManeuverCurrentListAvailable_);

    // API of field "u16RouteGuidanceManeuverCurrentList"

    static const int kU16RouteGuidanceManeuverCurrentList = 27;

    /**
     * Clears the field "u16RouteGuidanceManeuverCurrentList".
     *
     * The field will be set to its default value. The hasU16RouteGuidanceManeuverCurrentList()
     * method will return false.
     */
    inline void clearU16RouteGuidanceManeuverCurrentList();

    /**
     * Checks whether the field "u16RouteGuidanceManeuverCurrentList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RouteGuidanceManeuverCurrentList()). Otherwise it will return false.
     */
    inline bool hasU16RouteGuidanceManeuverCurrentList () const;

    /**
     * Returns the value of the member "u16RouteGuidanceManeuverCurrentList".
     *
     * Indices of next upcoming maneuvers in the RouteGuidance maneuver list. Multiple manuvers that occur very close together
     * can be grouped into an ordered list of indices with this parameter. Normally there would only be one entry for the current
     * upcoming maneuver. If more than one item is present in RouteGuidanceManeuverCurrent-List the maneuvers should be
     * executed in quick succession and can be displayed next to one another on the display.
     *
     * @return The value of the field "u16RouteGuidanceManeuverCurrentList"
     */
    inline const ::std::vector< uint16 >& getU16RouteGuidanceManeuverCurrentList () const;

    /**
     * Retrieves the value of the field "u16RouteGuidanceManeuverCurrentList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u16RouteGuidanceManeuverCurrentList".
     */
    inline ::std::vector< uint16 >& getU16RouteGuidanceManeuverCurrentListMutable ();

    /**
     * Sets the value of the member "u16RouteGuidanceManeuverCurrentList".
     *
     * Indices of next upcoming maneuvers in the RouteGuidance maneuver list. Multiple manuvers that occur very close together
     * can be grouped into an ordered list of indices with this parameter. Normally there would only be one entry for the current
     * upcoming maneuver. If more than one item is present in RouteGuidanceManeuverCurrent-List the maneuvers should be
     * executed in quick succession and can be displayed next to one another on the display.
     *
     * @param u16RouteGuidanceManeuverCurrentList The value which will be set
     */
    inline void setU16RouteGuidanceManeuverCurrentList (const ::std::vector< uint16 >& u16RouteGuidanceManeuverCurrentList_);

    // API of field "bRouteGuidanceManeuverCountAvailable"

    static const int kBRouteGuidanceManeuverCountAvailable = 28;

    /**
     * Clears the field "bRouteGuidanceManeuverCountAvailable".
     *
     * The field will be set to its default value. The hasBRouteGuidanceManeuverCountAvailable()
     * method will return false.
     */
    inline void clearBRouteGuidanceManeuverCountAvailable();

    /**
     * Checks whether the field "bRouteGuidanceManeuverCountAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRouteGuidanceManeuverCountAvailable()). Otherwise it will return false.
     */
    inline bool hasBRouteGuidanceManeuverCountAvailable () const;

    /**
     * Returns the value of the member "bRouteGuidanceManeuverCountAvailable".
     *
     * Availability of u16RouteGuidanceManeuverCount parameter
     *
     * @return The value of the field "bRouteGuidanceManeuverCountAvailable"
     */
    inline bool getBRouteGuidanceManeuverCountAvailable () const;

    /**
     * Sets the value of the member "bRouteGuidanceManeuverCountAvailable".
     *
     * Availability of u16RouteGuidanceManeuverCount parameter
     *
     * @param bRouteGuidanceManeuverCountAvailable The value which will be set
     */
    inline void setBRouteGuidanceManeuverCountAvailable (bool bRouteGuidanceManeuverCountAvailable_);

    // API of field "u16RouteGuidanceManeuverCount"

    static const int kU16RouteGuidanceManeuverCount = 29;

    /**
     * Clears the field "u16RouteGuidanceManeuverCount".
     *
     * The field will be set to its default value. The hasU16RouteGuidanceManeuverCount()
     * method will return false.
     */
    inline void clearU16RouteGuidanceManeuverCount();

    /**
     * Checks whether the field "u16RouteGuidanceManeuverCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RouteGuidanceManeuverCount()). Otherwise it will return false.
     */
    inline bool hasU16RouteGuidanceManeuverCount () const;

    /**
     * Returns the value of the member "u16RouteGuidanceManeuverCount".
     *
     * Total number of maneuvers in the RouteGuidance maneuver list. It is length of u16RouteGuidanceManeuverCurrentList.
     *
     * @return The value of the field "u16RouteGuidanceManeuverCount"
     */
    inline uint16 getU16RouteGuidanceManeuverCount () const;

    /**
     * Sets the value of the member "u16RouteGuidanceManeuverCount".
     *
     * Total number of maneuvers in the RouteGuidance maneuver list. It is length of u16RouteGuidanceManeuverCurrentList.
     *
     * @param u16RouteGuidanceManeuverCount The value which will be set
     */
    inline void setU16RouteGuidanceManeuverCount (uint16 u16RouteGuidanceManeuverCount_);

    // API of field "bRouteGuidanceVisibleInAppAvailable"

    static const int kBRouteGuidanceVisibleInAppAvailable = 30;

    /**
     * Clears the field "bRouteGuidanceVisibleInAppAvailable".
     *
     * The field will be set to its default value. The hasBRouteGuidanceVisibleInAppAvailable()
     * method will return false.
     */
    inline void clearBRouteGuidanceVisibleInAppAvailable();

    /**
     * Checks whether the field "bRouteGuidanceVisibleInAppAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRouteGuidanceVisibleInAppAvailable()). Otherwise it will return false.
     */
    inline bool hasBRouteGuidanceVisibleInAppAvailable () const;

    /**
     * Returns the value of the member "bRouteGuidanceVisibleInAppAvailable".
     *
     * Availability of bIsRouteGuidanceVisibleInApp parameter
     *
     * @return The value of the field "bRouteGuidanceVisibleInAppAvailable"
     */
    inline bool getBRouteGuidanceVisibleInAppAvailable () const;

    /**
     * Sets the value of the member "bRouteGuidanceVisibleInAppAvailable".
     *
     * Availability of bIsRouteGuidanceVisibleInApp parameter
     *
     * @param bRouteGuidanceVisibleInAppAvailable The value which will be set
     */
    inline void setBRouteGuidanceVisibleInAppAvailable (bool bRouteGuidanceVisibleInAppAvailable_);

    // API of field "bIsRouteGuidanceVisibleInApp"

    static const int kBIsRouteGuidanceVisibleInApp = 31;

    /**
     * Clears the field "bIsRouteGuidanceVisibleInApp".
     *
     * The field will be set to its default value. The hasBIsRouteGuidanceVisibleInApp()
     * method will return false.
     */
    inline void clearBIsRouteGuidanceVisibleInApp();

    /**
     * Checks whether the field "bIsRouteGuidanceVisibleInApp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsRouteGuidanceVisibleInApp()). Otherwise it will return false.
     */
    inline bool hasBIsRouteGuidanceVisibleInApp () const;

    /**
     * Returns the value of the member "bIsRouteGuidanceVisibleInApp".
     *
     * Whether Route guidance is visible in the navigation app
     *
     * @return The value of the field "bIsRouteGuidanceVisibleInApp"
     */
    inline bool getBIsRouteGuidanceVisibleInApp () const;

    /**
     * Sets the value of the member "bIsRouteGuidanceVisibleInApp".
     *
     * Whether Route guidance is visible in the navigation app
     *
     * @param bIsRouteGuidanceVisibleInApp The value which will be set
     */
    inline void setBIsRouteGuidanceVisibleInApp (bool bIsRouteGuidanceVisibleInApp_);

    // API of field "bSourceNameAvailable"

    static const int kBSourceNameAvailable = 32;

    /**
     * Clears the field "bSourceNameAvailable".
     *
     * The field will be set to its default value. The hasBSourceNameAvailable()
     * method will return false.
     */
    inline void clearBSourceNameAvailable();

    /**
     * Checks whether the field "bSourceNameAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSourceNameAvailable()). Otherwise it will return false.
     */
    inline bool hasBSourceNameAvailable () const;

    /**
     * Returns the value of the member "bSourceNameAvailable".
     *
     * Availability of SourceName parameter
     *
     * @return The value of the field "bSourceNameAvailable"
     */
    inline bool getBSourceNameAvailable () const;

    /**
     * Sets the value of the member "bSourceNameAvailable".
     *
     * Availability of SourceName parameter
     *
     * @param bSourceNameAvailable The value which will be set
     */
    inline void setBSourceNameAvailable (bool bSourceNameAvailable_);

    // API of field "SourceName"

    static const int kSourceName = 33;

    /**
     * Clears the field "SourceName".
     *
     * The field will be set to its default value. The hasSourceName()
     * method will return false.
     */
    inline void clearSourceName();

    /**
     * Checks whether the field "SourceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceName()). Otherwise it will return false.
     */
    inline bool hasSourceName () const;

    /**
     * Returns the value of the member "SourceName".
     *
     * Name of application providing turn-by-turn information in Carplay, for display purposes only. Do not use for basing any behaviour change decisions.
     *
     * @return The value of the field "SourceName"
     */
    inline const ::std::string& getSourceName () const;

    /**
     * Retrieves the value of the field "SourceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SourceName".
     */
    inline ::std::string& getSourceNameMutable ();

    /**
     * Sets the value of the member "SourceName".
     *
     * Name of application providing turn-by-turn information in Carplay, for display purposes only. Do not use for basing any behaviour change decisions.
     *
     * @param SourceName The value which will be set
     */
    inline void setSourceName (const ::std::string& SourceName_);

    /**
     * Sets the value of the member "SourceName".
     *
     * Name of application providing turn-by-turn information in Carplay, for display purposes only. Do not use for basing any behaviour change decisions.
     *
     * @param SourceName The value which will be set
     */
    inline void setSourceName (const char* SourceName_);

    /**
     * Sets the value of the member "SourceName".
     *
     * Name of application providing turn-by-turn information in Carplay, for display purposes only. Do not use for basing any behaviour change decisions.
     *
     * @param SourceName The value which will be set
     */
    inline void setSourceName (const char* value, size_t size);

    // API of field "bSourceSupportsRouteGuidanceAvailable"

    static const int kBSourceSupportsRouteGuidanceAvailable = 34;

    /**
     * Clears the field "bSourceSupportsRouteGuidanceAvailable".
     *
     * The field will be set to its default value. The hasBSourceSupportsRouteGuidanceAvailable()
     * method will return false.
     */
    inline void clearBSourceSupportsRouteGuidanceAvailable();

    /**
     * Checks whether the field "bSourceSupportsRouteGuidanceAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSourceSupportsRouteGuidanceAvailable()). Otherwise it will return false.
     */
    inline bool hasBSourceSupportsRouteGuidanceAvailable () const;

    /**
     * Returns the value of the member "bSourceSupportsRouteGuidanceAvailable".
     *
     * Availability of SourceName parameter
     *
     * @return The value of the field "bSourceSupportsRouteGuidanceAvailable"
     */
    inline bool getBSourceSupportsRouteGuidanceAvailable () const;

    /**
     * Sets the value of the member "bSourceSupportsRouteGuidanceAvailable".
     *
     * Availability of SourceName parameter
     *
     * @param bSourceSupportsRouteGuidanceAvailable The value which will be set
     */
    inline void setBSourceSupportsRouteGuidanceAvailable (bool bSourceSupportsRouteGuidanceAvailable_);

    // API of field "SourceSupportsRouteGuidance"

    static const int kSourceSupportsRouteGuidance = 35;

    /**
     * Clears the field "SourceSupportsRouteGuidance".
     *
     * The field will be set to its default value. The hasSourceSupportsRouteGuidance()
     * method will return false.
     */
    inline void clearSourceSupportsRouteGuidance();

    /**
     * Checks whether the field "SourceSupportsRouteGuidance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceSupportsRouteGuidance()). Otherwise it will return false.
     */
    inline bool hasSourceSupportsRouteGuidance () const;

    /**
     * Returns the value of the member "SourceSupportsRouteGuidance".
     *
     * Whether application providing turn-by-turn information in Carplay can populate RouteGuidanceManeuverInformation or parameters 0-15 in RouteGuidance.
     *
     * @return The value of the field "SourceSupportsRouteGuidance"
     */
    inline bool getSourceSupportsRouteGuidance () const;

    /**
     * Sets the value of the member "SourceSupportsRouteGuidance".
     *
     * Whether application providing turn-by-turn information in Carplay can populate RouteGuidanceManeuverInformation or parameters 0-15 in RouteGuidance.
     *
     * @param SourceSupportsRouteGuidance The value which will be set
     */
    inline void setSourceSupportsRouteGuidance (bool SourceSupportsRouteGuidance_);

    static const T_CarPlayRouteGuidanceUpdate &getDefaultInstance();

private:

    static const ::std::vector< T_e8_ComponentID >& getT_e8_ComponentIDList_DefaultInstance ();

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_bRouteGuidanceDisplayComponentIDsAvailable ();

    inline void clear_has_bRouteGuidanceDisplayComponentIDsAvailable ();

    inline void set_has_e8RouteGuidanceDisplayComponentIDs ();

    inline void clear_has_e8RouteGuidanceDisplayComponentIDs ();

    inline void set_has_bRouteGuidanceStateAvailable ();

    inline void clear_has_bRouteGuidanceStateAvailable ();

    inline void set_has_e8RouteGuidanceState ();

    inline void clear_has_e8RouteGuidanceState ();

    inline void set_has_bManeuverStateAvailable ();

    inline void clear_has_bManeuverStateAvailable ();

    inline void set_has_e8ManeuverState ();

    inline void clear_has_e8ManeuverState ();

    inline void set_has_bCurrentRoadNameAvailable ();

    inline void clear_has_bCurrentRoadNameAvailable ();

    inline void set_has_szCurrentRoadName ();

    inline void clear_has_szCurrentRoadName ();

    inline void set_has_bDestinationNameAvailable ();

    inline void clear_has_bDestinationNameAvailable ();

    inline void set_has_szDestinationName ();

    inline void clear_has_szDestinationName ();

    inline void set_has_bEstimatedTimeOfArrivalAvailable ();

    inline void clear_has_bEstimatedTimeOfArrivalAvailable ();

    inline void set_has_u64EstimatedTimeOfArrival ();

    inline void clear_has_u64EstimatedTimeOfArrival ();

    inline void set_has_bTimeRemainingToDestinationAvailable ();

    inline void clear_has_bTimeRemainingToDestinationAvailable ();

    inline void set_has_u64TimeRemainingToDestination ();

    inline void clear_has_u64TimeRemainingToDestination ();

    inline void set_has_bDistanceRemainingAvailable ();

    inline void clear_has_bDistanceRemainingAvailable ();

    inline void set_has_u32DistanceRemaining ();

    inline void clear_has_u32DistanceRemaining ();

    inline void set_has_bDistanceRemainingDisplayStrAvailable ();

    inline void clear_has_bDistanceRemainingDisplayStrAvailable ();

    inline void set_has_szDistanceRemainingDisplayStr ();

    inline void clear_has_szDistanceRemainingDisplayStr ();

    inline void set_has_bDistanceRemainingDisplayUnitsAvailable ();

    inline void clear_has_bDistanceRemainingDisplayUnitsAvailable ();

    inline void set_has_e8DistanceRemainingDisplayUnits ();

    inline void clear_has_e8DistanceRemainingDisplayUnits ();

    inline void set_has_bDistanceToNextManeuverAvailable ();

    inline void clear_has_bDistanceToNextManeuverAvailable ();

    inline void set_has_u32DistanceToNextManeuver ();

    inline void clear_has_u32DistanceToNextManeuver ();

    inline void set_has_bDistanceToNextManeuverDisplayStrAvailable ();

    inline void clear_has_bDistanceToNextManeuverDisplayStrAvailable ();

    inline void set_has_szDistanceToNextManeuverDisplayStr ();

    inline void clear_has_szDistanceToNextManeuverDisplayStr ();

    inline void set_has_bDistanceToNextManeuverDisplayUnitsAvailable ();

    inline void clear_has_bDistanceToNextManeuverDisplayUnitsAvailable ();

    inline void set_has_e8DistanceToNextManeuverDisplayUnits ();

    inline void clear_has_e8DistanceToNextManeuverDisplayUnits ();

    inline void set_has_bRouteGuidanceManeuverCurrentListAvailable ();

    inline void clear_has_bRouteGuidanceManeuverCurrentListAvailable ();

    inline void set_has_u16RouteGuidanceManeuverCurrentList ();

    inline void clear_has_u16RouteGuidanceManeuverCurrentList ();

    inline void set_has_bRouteGuidanceManeuverCountAvailable ();

    inline void clear_has_bRouteGuidanceManeuverCountAvailable ();

    inline void set_has_u16RouteGuidanceManeuverCount ();

    inline void clear_has_u16RouteGuidanceManeuverCount ();

    inline void set_has_bRouteGuidanceVisibleInAppAvailable ();

    inline void clear_has_bRouteGuidanceVisibleInAppAvailable ();

    inline void set_has_bIsRouteGuidanceVisibleInApp ();

    inline void clear_has_bIsRouteGuidanceVisibleInApp ();

    inline void set_has_bSourceNameAvailable ();

    inline void clear_has_bSourceNameAvailable ();

    inline void set_has_SourceName ();

    inline void clear_has_SourceName ();

    inline void set_has_bSourceSupportsRouteGuidanceAvailable ();

    inline void clear_has_bSourceSupportsRouteGuidanceAvailable ();

    inline void set_has_SourceSupportsRouteGuidance ();

    inline void clear_has_SourceSupportsRouteGuidance ();

    uint32 _has_bits_[ (36 + 31) / 32];

    bool _bRouteGuidanceDisplayComponentIDsAvailable;

    ::std::vector< T_e8_ComponentID > _e8RouteGuidanceDisplayComponentIDs;

    bool _bRouteGuidanceStateAvailable;

    T_e8_DiPoRouteGuidanceState _e8RouteGuidanceState;

    bool _bManeuverStateAvailable;

    T_e8_DiPoManeuverState _e8ManeuverState;

    bool _bCurrentRoadNameAvailable;

    ::std::string _szCurrentRoadName;

    bool _bDestinationNameAvailable;

    ::std::string _szDestinationName;

    bool _bEstimatedTimeOfArrivalAvailable;

    uint64 _u64EstimatedTimeOfArrival;

    bool _bTimeRemainingToDestinationAvailable;

    uint64 _u64TimeRemainingToDestination;

    bool _bDistanceRemainingAvailable;

    uint32 _u32DistanceRemaining;

    bool _bDistanceRemainingDisplayStrAvailable;

    ::std::string _szDistanceRemainingDisplayStr;

    bool _bDistanceRemainingDisplayUnitsAvailable;

    T_e8_DistanceUnits _e8DistanceRemainingDisplayUnits;

    bool _bDistanceToNextManeuverAvailable;

    uint32 _u32DistanceToNextManeuver;

    bool _bDistanceToNextManeuverDisplayStrAvailable;

    ::std::string _szDistanceToNextManeuverDisplayStr;

    bool _bDistanceToNextManeuverDisplayUnitsAvailable;

    T_e8_DistanceUnits _e8DistanceToNextManeuverDisplayUnits;

    bool _bRouteGuidanceManeuverCurrentListAvailable;

    ::std::vector< uint16 > _u16RouteGuidanceManeuverCurrentList;

    bool _bRouteGuidanceManeuverCountAvailable;

    uint16 _u16RouteGuidanceManeuverCount;

    bool _bRouteGuidanceVisibleInAppAvailable;

    bool _bIsRouteGuidanceVisibleInApp;

    bool _bSourceNameAvailable;

    ::std::string _SourceName;

    bool _bSourceSupportsRouteGuidanceAvailable;

    bool _SourceSupportsRouteGuidance;

};

/**
 * Property contains RouteGuidanceManeuver Update.
 */
class T_CarPlayRouteGuidanceManeuverUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_CarPlayRouteGuidanceManeuverUpdate ();

    /**
     * Copy constructor
     */
    inline  T_CarPlayRouteGuidanceManeuverUpdate (const T_CarPlayRouteGuidanceManeuverUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_CarPlayRouteGuidanceManeuverUpdate (bool bRouteGuidanceDisplayComponentIDsAvailable_, const ::std::vector< T_e8_ComponentID >& RouteGuidanceDisplayComponentIDs_, bool bIndexAvailable_, uint16 u16Index_, bool bManeuverDescriptionAvailable_, const ::std::string& szManeuverDescription_, bool bManeuverTypeAvailable_, T_e8_DiPoManeuverType e8ManeuverType_, bool bAfterManeuverRoadNameAvailable_, const ::std::string& szAfterManeuverRoadName_, bool bDistanceBetweenManeuverAvailable_, uint32 u32DistanceBetweenManeuver_, bool bDistanceBetweenManeuverDisplayStrAvailable_, const ::std::string& szDistanceBetweenManeuverDisplayStr_, bool bDistanceBetweenManeuverDisplayUnitsAvailable_, T_e8_DistanceUnits e8DistanceBetweenManeuverDisplayUnits_, bool bDrivingSideAvailable_, T_e8_DiPoDrivingSide e8DrivingSide_, bool bJunctionTypeAvailable_, T_e8_DiPoJunctionType e8JunctionType_, bool bJunctionElementAngleAvailable_, const ::std::vector< int16 >& s16JunctionElementAngleList_, bool bJunctionElementExitAngleAvailable_, int16 s16JunctionElementExitAngle_);

    /**
     * Destructor
     */
    inline  ~T_CarPlayRouteGuidanceManeuverUpdate();

    /**
     * Assignment operator
     */
    inline T_CarPlayRouteGuidanceManeuverUpdate& operator = (const T_CarPlayRouteGuidanceManeuverUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CarPlayRouteGuidanceManeuverUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CarPlayRouteGuidanceManeuverUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CarPlayRouteGuidanceManeuverUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CarPlayRouteGuidanceManeuverUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bRouteGuidanceDisplayComponentIDsAvailable"

    static const int kBRouteGuidanceDisplayComponentIDsAvailable = 0;

    /**
     * Clears the field "bRouteGuidanceDisplayComponentIDsAvailable".
     *
     * The field will be set to its default value. The hasBRouteGuidanceDisplayComponentIDsAvailable()
     * method will return false.
     */
    inline void clearBRouteGuidanceDisplayComponentIDsAvailable();

    /**
     * Checks whether the field "bRouteGuidanceDisplayComponentIDsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRouteGuidanceDisplayComponentIDsAvailable()). Otherwise it will return false.
     */
    inline bool hasBRouteGuidanceDisplayComponentIDsAvailable () const;

    /**
     * Returns the value of the member "bRouteGuidanceDisplayComponentIDsAvailable".
     *
     * Availability of RouteGuidanceDisplayComponentIDs parameter
     *
     * @return The value of the field "bRouteGuidanceDisplayComponentIDsAvailable"
     */
    inline bool getBRouteGuidanceDisplayComponentIDsAvailable () const;

    /**
     * Sets the value of the member "bRouteGuidanceDisplayComponentIDsAvailable".
     *
     * Availability of RouteGuidanceDisplayComponentIDs parameter
     *
     * @param bRouteGuidanceDisplayComponentIDsAvailable The value which will be set
     */
    inline void setBRouteGuidanceDisplayComponentIDsAvailable (bool bRouteGuidanceDisplayComponentIDsAvailable_);

    // API of field "RouteGuidanceDisplayComponentIDs"

    static const int kRouteGuidanceDisplayComponentIDs = 1;

    /**
     * Clears the field "RouteGuidanceDisplayComponentIDs".
     *
     * The field will be set to its default value. The hasRouteGuidanceDisplayComponentIDs()
     * method will return false.
     */
    inline void clearRouteGuidanceDisplayComponentIDs();

    /**
     * Checks whether the field "RouteGuidanceDisplayComponentIDs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceDisplayComponentIDs()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceDisplayComponentIDs () const;

    /**
     * Returns the value of the member "RouteGuidanceDisplayComponentIDs".
     *
     * If none specified( i.e either bRouteGuidanceDisplayComponentIDsAvailable is false or list is empty, it means the update applies to all components. If more than one are specified, update is applied to all specified components
     *
     * @return The value of the field "RouteGuidanceDisplayComponentIDs"
     */
    inline const ::std::vector< T_e8_ComponentID >& getRouteGuidanceDisplayComponentIDs () const;

    /**
     * Retrieves the value of the field "RouteGuidanceDisplayComponentIDs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RouteGuidanceDisplayComponentIDs".
     */
    inline ::std::vector< T_e8_ComponentID >& getRouteGuidanceDisplayComponentIDsMutable ();

    /**
     * Sets the value of the member "RouteGuidanceDisplayComponentIDs".
     *
     * If none specified( i.e either bRouteGuidanceDisplayComponentIDsAvailable is false or list is empty, it means the update applies to all components. If more than one are specified, update is applied to all specified components
     *
     * @param RouteGuidanceDisplayComponentIDs The value which will be set
     */
    inline void setRouteGuidanceDisplayComponentIDs (const ::std::vector< T_e8_ComponentID >& RouteGuidanceDisplayComponentIDs_);

    // API of field "bIndexAvailable"

    static const int kBIndexAvailable = 2;

    /**
     * Clears the field "bIndexAvailable".
     *
     * The field will be set to its default value. The hasBIndexAvailable()
     * method will return false.
     */
    inline void clearBIndexAvailable();

    /**
     * Checks whether the field "bIndexAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIndexAvailable()). Otherwise it will return false.
     */
    inline bool hasBIndexAvailable () const;

    /**
     * Returns the value of the member "bIndexAvailable".
     *
     * Availability of u16Index parameter
     *
     * @return The value of the field "bIndexAvailable"
     */
    inline bool getBIndexAvailable () const;

    /**
     * Sets the value of the member "bIndexAvailable".
     *
     * Availability of u16Index parameter
     *
     * @param bIndexAvailable The value which will be set
     */
    inline void setBIndexAvailable (bool bIndexAvailable_);

    // API of field "u16Index"

    static const int kU16Index = 3;

    /**
     * Clears the field "u16Index".
     *
     * The field will be set to its default value. The hasU16Index()
     * method will return false.
     */
    inline void clearU16Index();

    /**
     * Checks whether the field "u16Index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Index()). Otherwise it will return false.
     */
    inline bool hasU16Index () const;

    /**
     * Returns the value of the member "u16Index".
     *
     * Specifies which item in the list is being updated
     *
     * @return The value of the field "u16Index"
     */
    inline uint16 getU16Index () const;

    /**
     * Sets the value of the member "u16Index".
     *
     * Specifies which item in the list is being updated
     *
     * @param u16Index The value which will be set
     */
    inline void setU16Index (uint16 u16Index_);

    // API of field "bManeuverDescriptionAvailable"

    static const int kBManeuverDescriptionAvailable = 4;

    /**
     * Clears the field "bManeuverDescriptionAvailable".
     *
     * The field will be set to its default value. The hasBManeuverDescriptionAvailable()
     * method will return false.
     */
    inline void clearBManeuverDescriptionAvailable();

    /**
     * Checks whether the field "bManeuverDescriptionAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBManeuverDescriptionAvailable()). Otherwise it will return false.
     */
    inline bool hasBManeuverDescriptionAvailable () const;

    /**
     * Returns the value of the member "bManeuverDescriptionAvailable".
     *
     * Availability of szManeuverDescription parameter
     *
     * @return The value of the field "bManeuverDescriptionAvailable"
     */
    inline bool getBManeuverDescriptionAvailable () const;

    /**
     * Sets the value of the member "bManeuverDescriptionAvailable".
     *
     * Availability of szManeuverDescription parameter
     *
     * @param bManeuverDescriptionAvailable The value which will be set
     */
    inline void setBManeuverDescriptionAvailable (bool bManeuverDescriptionAvailable_);

    // API of field "szManeuverDescription"

    static const int kSzManeuverDescription = 5;

    /**
     * Clears the field "szManeuverDescription".
     *
     * The field will be set to its default value. The hasSzManeuverDescription()
     * method will return false.
     */
    inline void clearSzManeuverDescription();

    /**
     * Checks whether the field "szManeuverDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzManeuverDescription()). Otherwise it will return false.
     */
    inline bool hasSzManeuverDescription () const;

    /**
     * Returns the value of the member "szManeuverDescription".
     *
     * ManeuverDescription
     *
     * @return The value of the field "szManeuverDescription"
     */
    inline const ::std::string& getSzManeuverDescription () const;

    /**
     * Retrieves the value of the field "szManeuverDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szManeuverDescription".
     */
    inline ::std::string& getSzManeuverDescriptionMutable ();

    /**
     * Sets the value of the member "szManeuverDescription".
     *
     * ManeuverDescription
     *
     * @param szManeuverDescription The value which will be set
     */
    inline void setSzManeuverDescription (const ::std::string& szManeuverDescription_);

    /**
     * Sets the value of the member "szManeuverDescription".
     *
     * ManeuverDescription
     *
     * @param szManeuverDescription The value which will be set
     */
    inline void setSzManeuverDescription (const char* szManeuverDescription_);

    /**
     * Sets the value of the member "szManeuverDescription".
     *
     * ManeuverDescription
     *
     * @param szManeuverDescription The value which will be set
     */
    inline void setSzManeuverDescription (const char* value, size_t size);

    // API of field "bManeuverTypeAvailable"

    static const int kBManeuverTypeAvailable = 6;

    /**
     * Clears the field "bManeuverTypeAvailable".
     *
     * The field will be set to its default value. The hasBManeuverTypeAvailable()
     * method will return false.
     */
    inline void clearBManeuverTypeAvailable();

    /**
     * Checks whether the field "bManeuverTypeAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBManeuverTypeAvailable()). Otherwise it will return false.
     */
    inline bool hasBManeuverTypeAvailable () const;

    /**
     * Returns the value of the member "bManeuverTypeAvailable".
     *
     * Availability of e8ManeuverType parameter
     *
     * @return The value of the field "bManeuverTypeAvailable"
     */
    inline bool getBManeuverTypeAvailable () const;

    /**
     * Sets the value of the member "bManeuverTypeAvailable".
     *
     * Availability of e8ManeuverType parameter
     *
     * @param bManeuverTypeAvailable The value which will be set
     */
    inline void setBManeuverTypeAvailable (bool bManeuverTypeAvailable_);

    // API of field "e8ManeuverType"

    static const int kE8ManeuverType = 7;

    /**
     * Clears the field "e8ManeuverType".
     *
     * The field will be set to its default value. The hasE8ManeuverType()
     * method will return false.
     */
    inline void clearE8ManeuverType();

    /**
     * Checks whether the field "e8ManeuverType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ManeuverType()). Otherwise it will return false.
     */
    inline bool hasE8ManeuverType () const;

    /**
     * Returns the value of the member "e8ManeuverType".
     *
     * ManeuverType enum
     *
     * @return The value of the field "e8ManeuverType"
     */
    inline T_e8_DiPoManeuverType getE8ManeuverType () const;

    /**
     * Sets the value of the member "e8ManeuverType".
     *
     * ManeuverType enum
     *
     * @param e8ManeuverType The value which will be set
     */
    inline void setE8ManeuverType (T_e8_DiPoManeuverType e8ManeuverType_);

    // API of field "bAfterManeuverRoadNameAvailable"

    static const int kBAfterManeuverRoadNameAvailable = 8;

    /**
     * Clears the field "bAfterManeuverRoadNameAvailable".
     *
     * The field will be set to its default value. The hasBAfterManeuverRoadNameAvailable()
     * method will return false.
     */
    inline void clearBAfterManeuverRoadNameAvailable();

    /**
     * Checks whether the field "bAfterManeuverRoadNameAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAfterManeuverRoadNameAvailable()). Otherwise it will return false.
     */
    inline bool hasBAfterManeuverRoadNameAvailable () const;

    /**
     * Returns the value of the member "bAfterManeuverRoadNameAvailable".
     *
     * Availability of szAfterManeuverRoadName parameter
     *
     * @return The value of the field "bAfterManeuverRoadNameAvailable"
     */
    inline bool getBAfterManeuverRoadNameAvailable () const;

    /**
     * Sets the value of the member "bAfterManeuverRoadNameAvailable".
     *
     * Availability of szAfterManeuverRoadName parameter
     *
     * @param bAfterManeuverRoadNameAvailable The value which will be set
     */
    inline void setBAfterManeuverRoadNameAvailable (bool bAfterManeuverRoadNameAvailable_);

    // API of field "szAfterManeuverRoadName"

    static const int kSzAfterManeuverRoadName = 9;

    /**
     * Clears the field "szAfterManeuverRoadName".
     *
     * The field will be set to its default value. The hasSzAfterManeuverRoadName()
     * method will return false.
     */
    inline void clearSzAfterManeuverRoadName();

    /**
     * Checks whether the field "szAfterManeuverRoadName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAfterManeuverRoadName()). Otherwise it will return false.
     */
    inline bool hasSzAfterManeuverRoadName () const;

    /**
     * Returns the value of the member "szAfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed succesfull.
     *
     * @return The value of the field "szAfterManeuverRoadName"
     */
    inline const ::std::string& getSzAfterManeuverRoadName () const;

    /**
     * Retrieves the value of the field "szAfterManeuverRoadName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAfterManeuverRoadName".
     */
    inline ::std::string& getSzAfterManeuverRoadNameMutable ();

    /**
     * Sets the value of the member "szAfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed succesfull.
     *
     * @param szAfterManeuverRoadName The value which will be set
     */
    inline void setSzAfterManeuverRoadName (const ::std::string& szAfterManeuverRoadName_);

    /**
     * Sets the value of the member "szAfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed succesfull.
     *
     * @param szAfterManeuverRoadName The value which will be set
     */
    inline void setSzAfterManeuverRoadName (const char* szAfterManeuverRoadName_);

    /**
     * Sets the value of the member "szAfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed succesfull.
     *
     * @param szAfterManeuverRoadName The value which will be set
     */
    inline void setSzAfterManeuverRoadName (const char* value, size_t size);

    // API of field "bDistanceBetweenManeuverAvailable"

    static const int kBDistanceBetweenManeuverAvailable = 10;

    /**
     * Clears the field "bDistanceBetweenManeuverAvailable".
     *
     * The field will be set to its default value. The hasBDistanceBetweenManeuverAvailable()
     * method will return false.
     */
    inline void clearBDistanceBetweenManeuverAvailable();

    /**
     * Checks whether the field "bDistanceBetweenManeuverAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceBetweenManeuverAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceBetweenManeuverAvailable () const;

    /**
     * Returns the value of the member "bDistanceBetweenManeuverAvailable".
     *
     * Availability of u32DistanceBetweenManeuver parameter
     *
     * @return The value of the field "bDistanceBetweenManeuverAvailable"
     */
    inline bool getBDistanceBetweenManeuverAvailable () const;

    /**
     * Sets the value of the member "bDistanceBetweenManeuverAvailable".
     *
     * Availability of u32DistanceBetweenManeuver parameter
     *
     * @param bDistanceBetweenManeuverAvailable The value which will be set
     */
    inline void setBDistanceBetweenManeuverAvailable (bool bDistanceBetweenManeuverAvailable_);

    // API of field "u32DistanceBetweenManeuver"

    static const int kU32DistanceBetweenManeuver = 11;

    /**
     * Clears the field "u32DistanceBetweenManeuver".
     *
     * The field will be set to its default value. The hasU32DistanceBetweenManeuver()
     * method will return false.
     */
    inline void clearU32DistanceBetweenManeuver();

    /**
     * Checks whether the field "u32DistanceBetweenManeuver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DistanceBetweenManeuver()). Otherwise it will return false.
     */
    inline bool hasU32DistanceBetweenManeuver () const;

    /**
     * Returns the value of the member "u32DistanceBetweenManeuver".
     *
     * Meters between previous maneuver to this maneuver.This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @return The value of the field "u32DistanceBetweenManeuver"
     */
    inline uint32 getU32DistanceBetweenManeuver () const;

    /**
     * Sets the value of the member "u32DistanceBetweenManeuver".
     *
     * Meters between previous maneuver to this maneuver.This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @param u32DistanceBetweenManeuver The value which will be set
     */
    inline void setU32DistanceBetweenManeuver (uint32 u32DistanceBetweenManeuver_);

    // API of field "bDistanceBetweenManeuverDisplayStrAvailable"

    static const int kBDistanceBetweenManeuverDisplayStrAvailable = 12;

    /**
     * Clears the field "bDistanceBetweenManeuverDisplayStrAvailable".
     *
     * The field will be set to its default value. The hasBDistanceBetweenManeuverDisplayStrAvailable()
     * method will return false.
     */
    inline void clearBDistanceBetweenManeuverDisplayStrAvailable();

    /**
     * Checks whether the field "bDistanceBetweenManeuverDisplayStrAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceBetweenManeuverDisplayStrAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceBetweenManeuverDisplayStrAvailable () const;

    /**
     * Returns the value of the member "bDistanceBetweenManeuverDisplayStrAvailable".
     *
     * Availability of szDistanceBetweenManeuverDisplayStr parameter
     *
     * @return The value of the field "bDistanceBetweenManeuverDisplayStrAvailable"
     */
    inline bool getBDistanceBetweenManeuverDisplayStrAvailable () const;

    /**
     * Sets the value of the member "bDistanceBetweenManeuverDisplayStrAvailable".
     *
     * Availability of szDistanceBetweenManeuverDisplayStr parameter
     *
     * @param bDistanceBetweenManeuverDisplayStrAvailable The value which will be set
     */
    inline void setBDistanceBetweenManeuverDisplayStrAvailable (bool bDistanceBetweenManeuverDisplayStrAvailable_);

    // API of field "szDistanceBetweenManeuverDisplayStr"

    static const int kSzDistanceBetweenManeuverDisplayStr = 13;

    /**
     * Clears the field "szDistanceBetweenManeuverDisplayStr".
     *
     * The field will be set to its default value. The hasSzDistanceBetweenManeuverDisplayStr()
     * method will return false.
     */
    inline void clearSzDistanceBetweenManeuverDisplayStr();

    /**
     * Checks whether the field "szDistanceBetweenManeuverDisplayStr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDistanceBetweenManeuverDisplayStr()). Otherwise it will return false.
     */
    inline bool hasSzDistanceBetweenManeuverDisplayStr () const;

    /**
     * Returns the value of the member "szDistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @return The value of the field "szDistanceBetweenManeuverDisplayStr"
     */
    inline const ::std::string& getSzDistanceBetweenManeuverDisplayStr () const;

    /**
     * Retrieves the value of the field "szDistanceBetweenManeuverDisplayStr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDistanceBetweenManeuverDisplayStr".
     */
    inline ::std::string& getSzDistanceBetweenManeuverDisplayStrMutable ();

    /**
     * Sets the value of the member "szDistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceBetweenManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceBetweenManeuverDisplayStr (const ::std::string& szDistanceBetweenManeuverDisplayStr_);

    /**
     * Sets the value of the member "szDistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceBetweenManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceBetweenManeuverDisplayStr (const char* szDistanceBetweenManeuverDisplayStr_);

    /**
     * Sets the value of the member "szDistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceBetweenManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceBetweenManeuverDisplayStr (const char* value, size_t size);

    // API of field "bDistanceBetweenManeuverDisplayUnitsAvailable"

    static const int kBDistanceBetweenManeuverDisplayUnitsAvailable = 14;

    /**
     * Clears the field "bDistanceBetweenManeuverDisplayUnitsAvailable".
     *
     * The field will be set to its default value. The hasBDistanceBetweenManeuverDisplayUnitsAvailable()
     * method will return false.
     */
    inline void clearBDistanceBetweenManeuverDisplayUnitsAvailable();

    /**
     * Checks whether the field "bDistanceBetweenManeuverDisplayUnitsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceBetweenManeuverDisplayUnitsAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceBetweenManeuverDisplayUnitsAvailable () const;

    /**
     * Returns the value of the member "bDistanceBetweenManeuverDisplayUnitsAvailable".
     *
     * Availability of e8DistanceBetweenManeuverDisplayUnits parameter
     *
     * @return The value of the field "bDistanceBetweenManeuverDisplayUnitsAvailable"
     */
    inline bool getBDistanceBetweenManeuverDisplayUnitsAvailable () const;

    /**
     * Sets the value of the member "bDistanceBetweenManeuverDisplayUnitsAvailable".
     *
     * Availability of e8DistanceBetweenManeuverDisplayUnits parameter
     *
     * @param bDistanceBetweenManeuverDisplayUnitsAvailable The value which will be set
     */
    inline void setBDistanceBetweenManeuverDisplayUnitsAvailable (bool bDistanceBetweenManeuverDisplayUnitsAvailable_);

    // API of field "e8DistanceBetweenManeuverDisplayUnits"

    static const int kE8DistanceBetweenManeuverDisplayUnits = 15;

    /**
     * Clears the field "e8DistanceBetweenManeuverDisplayUnits".
     *
     * The field will be set to its default value. The hasE8DistanceBetweenManeuverDisplayUnits()
     * method will return false.
     */
    inline void clearE8DistanceBetweenManeuverDisplayUnits();

    /**
     * Checks whether the field "e8DistanceBetweenManeuverDisplayUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceBetweenManeuverDisplayUnits()). Otherwise it will return false.
     */
    inline bool hasE8DistanceBetweenManeuverDisplayUnits () const;

    /**
     * Returns the value of the member "e8DistanceBetweenManeuverDisplayUnits".
     *
     * Units that must accompany DistanceBetweenManeuver-DisplayStr when displayed to the user.
     *
     * @return The value of the field "e8DistanceBetweenManeuverDisplayUnits"
     */
    inline T_e8_DistanceUnits getE8DistanceBetweenManeuverDisplayUnits () const;

    /**
     * Sets the value of the member "e8DistanceBetweenManeuverDisplayUnits".
     *
     * Units that must accompany DistanceBetweenManeuver-DisplayStr when displayed to the user.
     *
     * @param e8DistanceBetweenManeuverDisplayUnits The value which will be set
     */
    inline void setE8DistanceBetweenManeuverDisplayUnits (T_e8_DistanceUnits e8DistanceBetweenManeuverDisplayUnits_);

    // API of field "bDrivingSideAvailable"

    static const int kBDrivingSideAvailable = 16;

    /**
     * Clears the field "bDrivingSideAvailable".
     *
     * The field will be set to its default value. The hasBDrivingSideAvailable()
     * method will return false.
     */
    inline void clearBDrivingSideAvailable();

    /**
     * Checks whether the field "bDrivingSideAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDrivingSideAvailable()). Otherwise it will return false.
     */
    inline bool hasBDrivingSideAvailable () const;

    /**
     * Returns the value of the member "bDrivingSideAvailable".
     *
     * Availability of e8DrivingSide parameter
     *
     * @return The value of the field "bDrivingSideAvailable"
     */
    inline bool getBDrivingSideAvailable () const;

    /**
     * Sets the value of the member "bDrivingSideAvailable".
     *
     * Availability of e8DrivingSide parameter
     *
     * @param bDrivingSideAvailable The value which will be set
     */
    inline void setBDrivingSideAvailable (bool bDrivingSideAvailable_);

    // API of field "e8DrivingSide"

    static const int kE8DrivingSide = 17;

    /**
     * Clears the field "e8DrivingSide".
     *
     * The field will be set to its default value. The hasE8DrivingSide()
     * method will return false.
     */
    inline void clearE8DrivingSide();

    /**
     * Checks whether the field "e8DrivingSide" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DrivingSide()). Otherwise it will return false.
     */
    inline bool hasE8DrivingSide () const;

    /**
     * Returns the value of the member "e8DrivingSide".
     *
     * Whether cars should drive on right or left side of the road. For roundabout, specifies the direction of traffic around the roundabout.
     *
     * @return The value of the field "e8DrivingSide"
     */
    inline T_e8_DiPoDrivingSide getE8DrivingSide () const;

    /**
     * Sets the value of the member "e8DrivingSide".
     *
     * Whether cars should drive on right or left side of the road. For roundabout, specifies the direction of traffic around the roundabout.
     *
     * @param e8DrivingSide The value which will be set
     */
    inline void setE8DrivingSide (T_e8_DiPoDrivingSide e8DrivingSide_);

    // API of field "bJunctionTypeAvailable"

    static const int kBJunctionTypeAvailable = 18;

    /**
     * Clears the field "bJunctionTypeAvailable".
     *
     * The field will be set to its default value. The hasBJunctionTypeAvailable()
     * method will return false.
     */
    inline void clearBJunctionTypeAvailable();

    /**
     * Checks whether the field "bJunctionTypeAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBJunctionTypeAvailable()). Otherwise it will return false.
     */
    inline bool hasBJunctionTypeAvailable () const;

    /**
     * Returns the value of the member "bJunctionTypeAvailable".
     *
     * Availability of e8JunctionType parameter
     *
     * @return The value of the field "bJunctionTypeAvailable"
     */
    inline bool getBJunctionTypeAvailable () const;

    /**
     * Sets the value of the member "bJunctionTypeAvailable".
     *
     * Availability of e8JunctionType parameter
     *
     * @param bJunctionTypeAvailable The value which will be set
     */
    inline void setBJunctionTypeAvailable (bool bJunctionTypeAvailable_);

    // API of field "e8JunctionType"

    static const int kE8JunctionType = 19;

    /**
     * Clears the field "e8JunctionType".
     *
     * The field will be set to its default value. The hasE8JunctionType()
     * method will return false.
     */
    inline void clearE8JunctionType();

    /**
     * Checks whether the field "e8JunctionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8JunctionType()). Otherwise it will return false.
     */
    inline bool hasE8JunctionType () const;

    /**
     * Returns the value of the member "e8JunctionType".
     *
     * JunctionType enum
     *
     * @return The value of the field "e8JunctionType"
     */
    inline T_e8_DiPoJunctionType getE8JunctionType () const;

    /**
     * Sets the value of the member "e8JunctionType".
     *
     * JunctionType enum
     *
     * @param e8JunctionType The value which will be set
     */
    inline void setE8JunctionType (T_e8_DiPoJunctionType e8JunctionType_);

    // API of field "bJunctionElementAngleAvailable"

    static const int kBJunctionElementAngleAvailable = 20;

    /**
     * Clears the field "bJunctionElementAngleAvailable".
     *
     * The field will be set to its default value. The hasBJunctionElementAngleAvailable()
     * method will return false.
     */
    inline void clearBJunctionElementAngleAvailable();

    /**
     * Checks whether the field "bJunctionElementAngleAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBJunctionElementAngleAvailable()). Otherwise it will return false.
     */
    inline bool hasBJunctionElementAngleAvailable () const;

    /**
     * Returns the value of the member "bJunctionElementAngleAvailable".
     *
     * Availability of s16JunctionElementAngle parameter
     *
     * @return The value of the field "bJunctionElementAngleAvailable"
     */
    inline bool getBJunctionElementAngleAvailable () const;

    /**
     * Sets the value of the member "bJunctionElementAngleAvailable".
     *
     * Availability of s16JunctionElementAngle parameter
     *
     * @param bJunctionElementAngleAvailable The value which will be set
     */
    inline void setBJunctionElementAngleAvailable (bool bJunctionElementAngleAvailable_);

    // API of field "s16JunctionElementAngleList"

    static const int kS16JunctionElementAngleList = 21;

    /**
     * Clears the field "s16JunctionElementAngleList".
     *
     * The field will be set to its default value. The hasS16JunctionElementAngleList()
     * method will return false.
     */
    inline void clearS16JunctionElementAngleList();

    /**
     * Checks whether the field "s16JunctionElementAngleList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16JunctionElementAngleList()). Otherwise it will return false.
     */
    inline bool hasS16JunctionElementAngleList () const;

    /**
     * Returns the value of the member "s16JunctionElementAngleList".
     *
     * Angle of a junction element (+/- 180). Accessory must show all junction elements together. An entry junction element is implied at angle 180.
     *
     * @return The value of the field "s16JunctionElementAngleList"
     */
    inline const ::std::vector< int16 >& getS16JunctionElementAngleList () const;

    /**
     * Retrieves the value of the field "s16JunctionElementAngleList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "s16JunctionElementAngleList".
     */
    inline ::std::vector< int16 >& getS16JunctionElementAngleListMutable ();

    /**
     * Sets the value of the member "s16JunctionElementAngleList".
     *
     * Angle of a junction element (+/- 180). Accessory must show all junction elements together. An entry junction element is implied at angle 180.
     *
     * @param s16JunctionElementAngleList The value which will be set
     */
    inline void setS16JunctionElementAngleList (const ::std::vector< int16 >& s16JunctionElementAngleList_);

    // API of field "bJunctionElementExitAngleAvailable"

    static const int kBJunctionElementExitAngleAvailable = 22;

    /**
     * Clears the field "bJunctionElementExitAngleAvailable".
     *
     * The field will be set to its default value. The hasBJunctionElementExitAngleAvailable()
     * method will return false.
     */
    inline void clearBJunctionElementExitAngleAvailable();

    /**
     * Checks whether the field "bJunctionElementExitAngleAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBJunctionElementExitAngleAvailable()). Otherwise it will return false.
     */
    inline bool hasBJunctionElementExitAngleAvailable () const;

    /**
     * Returns the value of the member "bJunctionElementExitAngleAvailable".
     *
     * Availability of s16JunctionElementExitAngle parameter
     *
     * @return The value of the field "bJunctionElementExitAngleAvailable"
     */
    inline bool getBJunctionElementExitAngleAvailable () const;

    /**
     * Sets the value of the member "bJunctionElementExitAngleAvailable".
     *
     * Availability of s16JunctionElementExitAngle parameter
     *
     * @param bJunctionElementExitAngleAvailable The value which will be set
     */
    inline void setBJunctionElementExitAngleAvailable (bool bJunctionElementExitAngleAvailable_);

    // API of field "s16JunctionElementExitAngle"

    static const int kS16JunctionElementExitAngle = 23;

    /**
     * Clears the field "s16JunctionElementExitAngle".
     *
     * The field will be set to its default value. The hasS16JunctionElementExitAngle()
     * method will return false.
     */
    inline void clearS16JunctionElementExitAngle();

    /**
     * Checks whether the field "s16JunctionElementExitAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16JunctionElementExitAngle()). Otherwise it will return false.
     */
    inline bool hasS16JunctionElementExitAngle () const;

    /**
     * Returns the value of the member "s16JunctionElementExitAngle".
     *
     * Angle of an exit junction element (+/- 180). Junction element describing the road used to exit the junction, or exit of the manuever. Accessory must show all junction elements together.An entry junction element is implied at angle 180.
     *
     * @return The value of the field "s16JunctionElementExitAngle"
     */
    inline int16 getS16JunctionElementExitAngle () const;

    /**
     * Sets the value of the member "s16JunctionElementExitAngle".
     *
     * Angle of an exit junction element (+/- 180). Junction element describing the road used to exit the junction, or exit of the manuever. Accessory must show all junction elements together.An entry junction element is implied at angle 180.
     *
     * @param s16JunctionElementExitAngle The value which will be set
     */
    inline void setS16JunctionElementExitAngle (int16 s16JunctionElementExitAngle_);

    static const T_CarPlayRouteGuidanceManeuverUpdate &getDefaultInstance();

private:

    static const ::std::vector< T_e8_ComponentID >& getT_e8_ComponentIDList_DefaultInstance ();

    static const ::std::vector< int16 >& getInt16List_DefaultInstance ();

    inline void set_has_bRouteGuidanceDisplayComponentIDsAvailable ();

    inline void clear_has_bRouteGuidanceDisplayComponentIDsAvailable ();

    inline void set_has_RouteGuidanceDisplayComponentIDs ();

    inline void clear_has_RouteGuidanceDisplayComponentIDs ();

    inline void set_has_bIndexAvailable ();

    inline void clear_has_bIndexAvailable ();

    inline void set_has_u16Index ();

    inline void clear_has_u16Index ();

    inline void set_has_bManeuverDescriptionAvailable ();

    inline void clear_has_bManeuverDescriptionAvailable ();

    inline void set_has_szManeuverDescription ();

    inline void clear_has_szManeuverDescription ();

    inline void set_has_bManeuverTypeAvailable ();

    inline void clear_has_bManeuverTypeAvailable ();

    inline void set_has_e8ManeuverType ();

    inline void clear_has_e8ManeuverType ();

    inline void set_has_bAfterManeuverRoadNameAvailable ();

    inline void clear_has_bAfterManeuverRoadNameAvailable ();

    inline void set_has_szAfterManeuverRoadName ();

    inline void clear_has_szAfterManeuverRoadName ();

    inline void set_has_bDistanceBetweenManeuverAvailable ();

    inline void clear_has_bDistanceBetweenManeuverAvailable ();

    inline void set_has_u32DistanceBetweenManeuver ();

    inline void clear_has_u32DistanceBetweenManeuver ();

    inline void set_has_bDistanceBetweenManeuverDisplayStrAvailable ();

    inline void clear_has_bDistanceBetweenManeuverDisplayStrAvailable ();

    inline void set_has_szDistanceBetweenManeuverDisplayStr ();

    inline void clear_has_szDistanceBetweenManeuverDisplayStr ();

    inline void set_has_bDistanceBetweenManeuverDisplayUnitsAvailable ();

    inline void clear_has_bDistanceBetweenManeuverDisplayUnitsAvailable ();

    inline void set_has_e8DistanceBetweenManeuverDisplayUnits ();

    inline void clear_has_e8DistanceBetweenManeuverDisplayUnits ();

    inline void set_has_bDrivingSideAvailable ();

    inline void clear_has_bDrivingSideAvailable ();

    inline void set_has_e8DrivingSide ();

    inline void clear_has_e8DrivingSide ();

    inline void set_has_bJunctionTypeAvailable ();

    inline void clear_has_bJunctionTypeAvailable ();

    inline void set_has_e8JunctionType ();

    inline void clear_has_e8JunctionType ();

    inline void set_has_bJunctionElementAngleAvailable ();

    inline void clear_has_bJunctionElementAngleAvailable ();

    inline void set_has_s16JunctionElementAngleList ();

    inline void clear_has_s16JunctionElementAngleList ();

    inline void set_has_bJunctionElementExitAngleAvailable ();

    inline void clear_has_bJunctionElementExitAngleAvailable ();

    inline void set_has_s16JunctionElementExitAngle ();

    inline void clear_has_s16JunctionElementExitAngle ();

    uint32 _has_bits_[ (24 + 31) / 32];

    bool _bRouteGuidanceDisplayComponentIDsAvailable;

    ::std::vector< T_e8_ComponentID > _RouteGuidanceDisplayComponentIDs;

    bool _bIndexAvailable;

    uint16 _u16Index;

    bool _bManeuverDescriptionAvailable;

    ::std::string _szManeuverDescription;

    bool _bManeuverTypeAvailable;

    T_e8_DiPoManeuverType _e8ManeuverType;

    bool _bAfterManeuverRoadNameAvailable;

    ::std::string _szAfterManeuverRoadName;

    bool _bDistanceBetweenManeuverAvailable;

    uint32 _u32DistanceBetweenManeuver;

    bool _bDistanceBetweenManeuverDisplayStrAvailable;

    ::std::string _szDistanceBetweenManeuverDisplayStr;

    bool _bDistanceBetweenManeuverDisplayUnitsAvailable;

    T_e8_DistanceUnits _e8DistanceBetweenManeuverDisplayUnits;

    bool _bDrivingSideAvailable;

    T_e8_DiPoDrivingSide _e8DrivingSide;

    bool _bJunctionTypeAvailable;

    T_e8_DiPoJunctionType _e8JunctionType;

    bool _bJunctionElementAngleAvailable;

    ::std::vector< int16 > _s16JunctionElementAngleList;

    bool _bJunctionElementExitAngleAvailable;

    int16 _s16JunctionElementExitAngle;

};

/**
 * Structure contains RouteGuidance Update.
 */
class T_DiPORouteGuidanceUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_DiPORouteGuidanceUpdate ();

    /**
     * Copy constructor
     */
    inline  T_DiPORouteGuidanceUpdate (const T_DiPORouteGuidanceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_DiPORouteGuidanceUpdate (T_e8_DiPoRouteGuidanceState e8RouteGuidanceState_, T_e8_DiPoManeuverState e8ManeuverState_, const ::std::string& szCurrentRoadName_, const ::std::string& szDestinationName_, uint64 u64EstimatedTimeOfArrival_, uint64 u64TimeRemainingToDestination_, uint32 u32DistanceRemaining_, const ::std::string& szDistanceRemainingDisplayStr_, T_e8_DistanceUnits e8DistanceRemainingDisplayUnits_, uint32 u32DistanceToNextManeuver_, const ::std::string& szDistanceToNextManeuverDisplayStr_, T_e8_DistanceUnits e8DistanceToNextManeuverDisplayUnits_, const ::std::vector< uint16 >& u16RouteGuidanceManeuverCurrentList_, uint16 u16RouteGuidanceManeuverCount_, bool bIsRouteGuidanceVisibleInApp_);

    /**
     * Destructor
     */
    inline  ~T_DiPORouteGuidanceUpdate();

    /**
     * Assignment operator
     */
    inline T_DiPORouteGuidanceUpdate& operator = (const T_DiPORouteGuidanceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DiPORouteGuidanceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DiPORouteGuidanceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DiPORouteGuidanceUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DiPORouteGuidanceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8RouteGuidanceState"

    static const int kE8RouteGuidanceState = 0;

    /**
     * Clears the field "e8RouteGuidanceState".
     *
     * The field will be set to its default value. The hasE8RouteGuidanceState()
     * method will return false.
     */
    inline void clearE8RouteGuidanceState();

    /**
     * Checks whether the field "e8RouteGuidanceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RouteGuidanceState()). Otherwise it will return false.
     */
    inline bool hasE8RouteGuidanceState () const;

    /**
     * Returns the value of the member "e8RouteGuidanceState".
     *
     * Indicates current RouteGuidance state which is one of the route guidance state enum.
     *
     * @return The value of the field "e8RouteGuidanceState"
     */
    inline T_e8_DiPoRouteGuidanceState getE8RouteGuidanceState () const;

    /**
     * Sets the value of the member "e8RouteGuidanceState".
     *
     * Indicates current RouteGuidance state which is one of the route guidance state enum.
     *
     * @param e8RouteGuidanceState The value which will be set
     */
    inline void setE8RouteGuidanceState (T_e8_DiPoRouteGuidanceState e8RouteGuidanceState_);

    // API of field "e8ManeuverState"

    static const int kE8ManeuverState = 1;

    /**
     * Clears the field "e8ManeuverState".
     *
     * The field will be set to its default value. The hasE8ManeuverState()
     * method will return false.
     */
    inline void clearE8ManeuverState();

    /**
     * Checks whether the field "e8ManeuverState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ManeuverState()). Otherwise it will return false.
     */
    inline bool hasE8ManeuverState () const;

    /**
     * Returns the value of the member "e8ManeuverState".
     *
     * ManeuverState enum.
     *
     * @return The value of the field "e8ManeuverState"
     */
    inline T_e8_DiPoManeuverState getE8ManeuverState () const;

    /**
     * Sets the value of the member "e8ManeuverState".
     *
     * ManeuverState enum.
     *
     * @param e8ManeuverState The value which will be set
     */
    inline void setE8ManeuverState (T_e8_DiPoManeuverState e8ManeuverState_);

    // API of field "szCurrentRoadName"

    static const int kSzCurrentRoadName = 2;

    /**
     * Clears the field "szCurrentRoadName".
     *
     * The field will be set to its default value. The hasSzCurrentRoadName()
     * method will return false.
     */
    inline void clearSzCurrentRoadName();

    /**
     * Checks whether the field "szCurrentRoadName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzCurrentRoadName()). Otherwise it will return false.
     */
    inline bool hasSzCurrentRoadName () const;

    /**
     * Returns the value of the member "szCurrentRoadName".
     *
     * The name of the current road.
     *
     * @return The value of the field "szCurrentRoadName"
     */
    inline const ::std::string& getSzCurrentRoadName () const;

    /**
     * Retrieves the value of the field "szCurrentRoadName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szCurrentRoadName".
     */
    inline ::std::string& getSzCurrentRoadNameMutable ();

    /**
     * Sets the value of the member "szCurrentRoadName".
     *
     * The name of the current road.
     *
     * @param szCurrentRoadName The value which will be set
     */
    inline void setSzCurrentRoadName (const ::std::string& szCurrentRoadName_);

    /**
     * Sets the value of the member "szCurrentRoadName".
     *
     * The name of the current road.
     *
     * @param szCurrentRoadName The value which will be set
     */
    inline void setSzCurrentRoadName (const char* szCurrentRoadName_);

    /**
     * Sets the value of the member "szCurrentRoadName".
     *
     * The name of the current road.
     *
     * @param szCurrentRoadName The value which will be set
     */
    inline void setSzCurrentRoadName (const char* value, size_t size);

    // API of field "szDestinationName"

    static const int kSzDestinationName = 3;

    /**
     * Clears the field "szDestinationName".
     *
     * The field will be set to its default value. The hasSzDestinationName()
     * method will return false.
     */
    inline void clearSzDestinationName();

    /**
     * Checks whether the field "szDestinationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDestinationName()). Otherwise it will return false.
     */
    inline bool hasSzDestinationName () const;

    /**
     * Returns the value of the member "szDestinationName".
     *
     * The name of the Destination.
     *
     * @return The value of the field "szDestinationName"
     */
    inline const ::std::string& getSzDestinationName () const;

    /**
     * Retrieves the value of the field "szDestinationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDestinationName".
     */
    inline ::std::string& getSzDestinationNameMutable ();

    /**
     * Sets the value of the member "szDestinationName".
     *
     * The name of the Destination.
     *
     * @param szDestinationName The value which will be set
     */
    inline void setSzDestinationName (const ::std::string& szDestinationName_);

    /**
     * Sets the value of the member "szDestinationName".
     *
     * The name of the Destination.
     *
     * @param szDestinationName The value which will be set
     */
    inline void setSzDestinationName (const char* szDestinationName_);

    /**
     * Sets the value of the member "szDestinationName".
     *
     * The name of the Destination.
     *
     * @param szDestinationName The value which will be set
     */
    inline void setSzDestinationName (const char* value, size_t size);

    // API of field "u64EstimatedTimeOfArrival"

    static const int kU64EstimatedTimeOfArrival = 4;

    /**
     * Clears the field "u64EstimatedTimeOfArrival".
     *
     * The field will be set to its default value. The hasU64EstimatedTimeOfArrival()
     * method will return false.
     */
    inline void clearU64EstimatedTimeOfArrival();

    /**
     * Checks whether the field "u64EstimatedTimeOfArrival" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64EstimatedTimeOfArrival()). Otherwise it will return false.
     */
    inline bool hasU64EstimatedTimeOfArrival () const;

    /**
     * Returns the value of the member "u64EstimatedTimeOfArrival".
     *
     * Number of seconds from reference date (Jan 1, 1970 GMT).Similar to DeviceTimeUpdate, Accessory should use DeviceTimeUpdate and use the TimeZoneOfisetMinutes and DaylightSavingsOffsetMinutes information to apply the adjustment necessary for local time.
     *
     * @return The value of the field "u64EstimatedTimeOfArrival"
     */
    inline uint64 getU64EstimatedTimeOfArrival () const;

    /**
     * Sets the value of the member "u64EstimatedTimeOfArrival".
     *
     * Number of seconds from reference date (Jan 1, 1970 GMT).Similar to DeviceTimeUpdate, Accessory should use DeviceTimeUpdate and use the TimeZoneOfisetMinutes and DaylightSavingsOffsetMinutes information to apply the adjustment necessary for local time.
     *
     * @param u64EstimatedTimeOfArrival The value which will be set
     */
    inline void setU64EstimatedTimeOfArrival (uint64 u64EstimatedTimeOfArrival_);

    // API of field "u64TimeRemainingToDestination"

    static const int kU64TimeRemainingToDestination = 5;

    /**
     * Clears the field "u64TimeRemainingToDestination".
     *
     * The field will be set to its default value. The hasU64TimeRemainingToDestination()
     * method will return false.
     */
    inline void clearU64TimeRemainingToDestination();

    /**
     * Checks whether the field "u64TimeRemainingToDestination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64TimeRemainingToDestination()). Otherwise it will return false.
     */
    inline bool hasU64TimeRemainingToDestination () const;

    /**
     * Returns the value of the member "u64TimeRemainingToDestination".
     *
     * Number of seconds to Destination.
     *
     * @return The value of the field "u64TimeRemainingToDestination"
     */
    inline uint64 getU64TimeRemainingToDestination () const;

    /**
     * Sets the value of the member "u64TimeRemainingToDestination".
     *
     * Number of seconds to Destination.
     *
     * @param u64TimeRemainingToDestination The value which will be set
     */
    inline void setU64TimeRemainingToDestination (uint64 u64TimeRemainingToDestination_);

    // API of field "u32DistanceRemaining"

    static const int kU32DistanceRemaining = 6;

    /**
     * Clears the field "u32DistanceRemaining".
     *
     * The field will be set to its default value. The hasU32DistanceRemaining()
     * method will return false.
     */
    inline void clearU32DistanceRemaining();

    /**
     * Checks whether the field "u32DistanceRemaining" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DistanceRemaining()). Otherwise it will return false.
     */
    inline bool hasU32DistanceRemaining () const;

    /**
     * Returns the value of the member "u32DistanceRemaining".
     *
     * Meters to end of trip. This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @return The value of the field "u32DistanceRemaining"
     */
    inline uint32 getU32DistanceRemaining () const;

    /**
     * Sets the value of the member "u32DistanceRemaining".
     *
     * Meters to end of trip. This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @param u32DistanceRemaining The value which will be set
     */
    inline void setU32DistanceRemaining (uint32 u32DistanceRemaining_);

    // API of field "szDistanceRemainingDisplayStr"

    static const int kSzDistanceRemainingDisplayStr = 7;

    /**
     * Clears the field "szDistanceRemainingDisplayStr".
     *
     * The field will be set to its default value. The hasSzDistanceRemainingDisplayStr()
     * method will return false.
     */
    inline void clearSzDistanceRemainingDisplayStr();

    /**
     * Checks whether the field "szDistanceRemainingDisplayStr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDistanceRemainingDisplayStr()). Otherwise it will return false.
     */
    inline bool hasSzDistanceRemainingDisplayStr () const;

    /**
     * Returns the value of the member "szDistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @return The value of the field "szDistanceRemainingDisplayStr"
     */
    inline const ::std::string& getSzDistanceRemainingDisplayStr () const;

    /**
     * Retrieves the value of the field "szDistanceRemainingDisplayStr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDistanceRemainingDisplayStr".
     */
    inline ::std::string& getSzDistanceRemainingDisplayStrMutable ();

    /**
     * Sets the value of the member "szDistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceRemainingDisplayStr The value which will be set
     */
    inline void setSzDistanceRemainingDisplayStr (const ::std::string& szDistanceRemainingDisplayStr_);

    /**
     * Sets the value of the member "szDistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceRemainingDisplayStr The value which will be set
     */
    inline void setSzDistanceRemainingDisplayStr (const char* szDistanceRemainingDisplayStr_);

    /**
     * Sets the value of the member "szDistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceRemainingDisplayStr The value which will be set
     */
    inline void setSzDistanceRemainingDisplayStr (const char* value, size_t size);

    // API of field "e8DistanceRemainingDisplayUnits"

    static const int kE8DistanceRemainingDisplayUnits = 8;

    /**
     * Clears the field "e8DistanceRemainingDisplayUnits".
     *
     * The field will be set to its default value. The hasE8DistanceRemainingDisplayUnits()
     * method will return false.
     */
    inline void clearE8DistanceRemainingDisplayUnits();

    /**
     * Checks whether the field "e8DistanceRemainingDisplayUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceRemainingDisplayUnits()). Otherwise it will return false.
     */
    inline bool hasE8DistanceRemainingDisplayUnits () const;

    /**
     * Returns the value of the member "e8DistanceRemainingDisplayUnits".
     *
     * Units that must accompany DistanceRemainingDisplaystr when displayed to the user.
     *
     * @return The value of the field "e8DistanceRemainingDisplayUnits"
     */
    inline T_e8_DistanceUnits getE8DistanceRemainingDisplayUnits () const;

    /**
     * Sets the value of the member "e8DistanceRemainingDisplayUnits".
     *
     * Units that must accompany DistanceRemainingDisplaystr when displayed to the user.
     *
     * @param e8DistanceRemainingDisplayUnits The value which will be set
     */
    inline void setE8DistanceRemainingDisplayUnits (T_e8_DistanceUnits e8DistanceRemainingDisplayUnits_);

    // API of field "u32DistanceToNextManeuver"

    static const int kU32DistanceToNextManeuver = 9;

    /**
     * Clears the field "u32DistanceToNextManeuver".
     *
     * The field will be set to its default value. The hasU32DistanceToNextManeuver()
     * method will return false.
     */
    inline void clearU32DistanceToNextManeuver();

    /**
     * Checks whether the field "u32DistanceToNextManeuver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DistanceToNextManeuver()). Otherwise it will return false.
     */
    inline bool hasU32DistanceToNextManeuver () const;

    /**
     * Returns the value of the member "u32DistanceToNextManeuver".
     *
     * Meters to next maneuver. This value must not be displayed to the user in text. It is only to be used for generating graphics,e.g. countdown bars.
     *
     * @return The value of the field "u32DistanceToNextManeuver"
     */
    inline uint32 getU32DistanceToNextManeuver () const;

    /**
     * Sets the value of the member "u32DistanceToNextManeuver".
     *
     * Meters to next maneuver. This value must not be displayed to the user in text. It is only to be used for generating graphics,e.g. countdown bars.
     *
     * @param u32DistanceToNextManeuver The value which will be set
     */
    inline void setU32DistanceToNextManeuver (uint32 u32DistanceToNextManeuver_);

    // API of field "szDistanceToNextManeuverDisplayStr"

    static const int kSzDistanceToNextManeuverDisplayStr = 10;

    /**
     * Clears the field "szDistanceToNextManeuverDisplayStr".
     *
     * The field will be set to its default value. The hasSzDistanceToNextManeuverDisplayStr()
     * method will return false.
     */
    inline void clearSzDistanceToNextManeuverDisplayStr();

    /**
     * Checks whether the field "szDistanceToNextManeuverDisplayStr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDistanceToNextManeuverDisplayStr()). Otherwise it will return false.
     */
    inline bool hasSzDistanceToNextManeuverDisplayStr () const;

    /**
     * Returns the value of the member "szDistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @return The value of the field "szDistanceToNextManeuverDisplayStr"
     */
    inline const ::std::string& getSzDistanceToNextManeuverDisplayStr () const;

    /**
     * Retrieves the value of the field "szDistanceToNextManeuverDisplayStr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDistanceToNextManeuverDisplayStr".
     */
    inline ::std::string& getSzDistanceToNextManeuverDisplayStrMutable ();

    /**
     * Sets the value of the member "szDistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @param szDistanceToNextManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceToNextManeuverDisplayStr (const ::std::string& szDistanceToNextManeuverDisplayStr_);

    /**
     * Sets the value of the member "szDistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @param szDistanceToNextManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceToNextManeuverDisplayStr (const char* szDistanceToNextManeuverDisplayStr_);

    /**
     * Sets the value of the member "szDistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @param szDistanceToNextManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceToNextManeuverDisplayStr (const char* value, size_t size);

    // API of field "e8DistanceToNextManeuverDisplayUnits"

    static const int kE8DistanceToNextManeuverDisplayUnits = 11;

    /**
     * Clears the field "e8DistanceToNextManeuverDisplayUnits".
     *
     * The field will be set to its default value. The hasE8DistanceToNextManeuverDisplayUnits()
     * method will return false.
     */
    inline void clearE8DistanceToNextManeuverDisplayUnits();

    /**
     * Checks whether the field "e8DistanceToNextManeuverDisplayUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceToNextManeuverDisplayUnits()). Otherwise it will return false.
     */
    inline bool hasE8DistanceToNextManeuverDisplayUnits () const;

    /**
     * Returns the value of the member "e8DistanceToNextManeuverDisplayUnits".
     *
     * Units that must accompany DistanceToNextManeuverDisplayStr when displayed to the user.
     *
     * @return The value of the field "e8DistanceToNextManeuverDisplayUnits"
     */
    inline T_e8_DistanceUnits getE8DistanceToNextManeuverDisplayUnits () const;

    /**
     * Sets the value of the member "e8DistanceToNextManeuverDisplayUnits".
     *
     * Units that must accompany DistanceToNextManeuverDisplayStr when displayed to the user.
     *
     * @param e8DistanceToNextManeuverDisplayUnits The value which will be set
     */
    inline void setE8DistanceToNextManeuverDisplayUnits (T_e8_DistanceUnits e8DistanceToNextManeuverDisplayUnits_);

    // API of field "u16RouteGuidanceManeuverCurrentList"

    static const int kU16RouteGuidanceManeuverCurrentList = 12;

    /**
     * Clears the field "u16RouteGuidanceManeuverCurrentList".
     *
     * The field will be set to its default value. The hasU16RouteGuidanceManeuverCurrentList()
     * method will return false.
     */
    inline void clearU16RouteGuidanceManeuverCurrentList();

    /**
     * Checks whether the field "u16RouteGuidanceManeuverCurrentList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RouteGuidanceManeuverCurrentList()). Otherwise it will return false.
     */
    inline bool hasU16RouteGuidanceManeuverCurrentList () const;

    /**
     * Returns the value of the member "u16RouteGuidanceManeuverCurrentList".
     *
     * Indices of next upcoming maneuvers in the RouteGuidance maneuver list. Multiple manuvers that occur very close together
     * can be grouped into an ordered list of indices with this parameter. Normally there would only be one entry for the current
     * upcoming maneuver. If more than one item is present in RouteGuidanceManeuverCurrent-List the maneuvers should be
     * executed in quick succession and can be displayed next to one another on the display.
     *
     * @return The value of the field "u16RouteGuidanceManeuverCurrentList"
     */
    inline const ::std::vector< uint16 >& getU16RouteGuidanceManeuverCurrentList () const;

    /**
     * Retrieves the value of the field "u16RouteGuidanceManeuverCurrentList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u16RouteGuidanceManeuverCurrentList".
     */
    inline ::std::vector< uint16 >& getU16RouteGuidanceManeuverCurrentListMutable ();

    /**
     * Sets the value of the member "u16RouteGuidanceManeuverCurrentList".
     *
     * Indices of next upcoming maneuvers in the RouteGuidance maneuver list. Multiple manuvers that occur very close together
     * can be grouped into an ordered list of indices with this parameter. Normally there would only be one entry for the current
     * upcoming maneuver. If more than one item is present in RouteGuidanceManeuverCurrent-List the maneuvers should be
     * executed in quick succession and can be displayed next to one another on the display.
     *
     * @param u16RouteGuidanceManeuverCurrentList The value which will be set
     */
    inline void setU16RouteGuidanceManeuverCurrentList (const ::std::vector< uint16 >& u16RouteGuidanceManeuverCurrentList_);

    // API of field "u16RouteGuidanceManeuverCount"

    static const int kU16RouteGuidanceManeuverCount = 13;

    /**
     * Clears the field "u16RouteGuidanceManeuverCount".
     *
     * The field will be set to its default value. The hasU16RouteGuidanceManeuverCount()
     * method will return false.
     */
    inline void clearU16RouteGuidanceManeuverCount();

    /**
     * Checks whether the field "u16RouteGuidanceManeuverCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RouteGuidanceManeuverCount()). Otherwise it will return false.
     */
    inline bool hasU16RouteGuidanceManeuverCount () const;

    /**
     * Returns the value of the member "u16RouteGuidanceManeuverCount".
     *
     * Total number of maneuvers in the RouteGuidance maneuver list. It is length of u16RouteGuidanceManeuverCurrentList.
     *
     * @return The value of the field "u16RouteGuidanceManeuverCount"
     */
    inline uint16 getU16RouteGuidanceManeuverCount () const;

    /**
     * Sets the value of the member "u16RouteGuidanceManeuverCount".
     *
     * Total number of maneuvers in the RouteGuidance maneuver list. It is length of u16RouteGuidanceManeuverCurrentList.
     *
     * @param u16RouteGuidanceManeuverCount The value which will be set
     */
    inline void setU16RouteGuidanceManeuverCount (uint16 u16RouteGuidanceManeuverCount_);

    // API of field "bIsRouteGuidanceVisibleInApp"

    static const int kBIsRouteGuidanceVisibleInApp = 14;

    /**
     * Clears the field "bIsRouteGuidanceVisibleInApp".
     *
     * The field will be set to its default value. The hasBIsRouteGuidanceVisibleInApp()
     * method will return false.
     */
    inline void clearBIsRouteGuidanceVisibleInApp();

    /**
     * Checks whether the field "bIsRouteGuidanceVisibleInApp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsRouteGuidanceVisibleInApp()). Otherwise it will return false.
     */
    inline bool hasBIsRouteGuidanceVisibleInApp () const;

    /**
     * Returns the value of the member "bIsRouteGuidanceVisibleInApp".
     *
     * Whether Route guidance is visible in the navigation app.
     *
     * @return The value of the field "bIsRouteGuidanceVisibleInApp"
     */
    inline bool getBIsRouteGuidanceVisibleInApp () const;

    /**
     * Sets the value of the member "bIsRouteGuidanceVisibleInApp".
     *
     * Whether Route guidance is visible in the navigation app.
     *
     * @param bIsRouteGuidanceVisibleInApp The value which will be set
     */
    inline void setBIsRouteGuidanceVisibleInApp (bool bIsRouteGuidanceVisibleInApp_);

    static const T_DiPORouteGuidanceUpdate &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_e8RouteGuidanceState ();

    inline void clear_has_e8RouteGuidanceState ();

    inline void set_has_e8ManeuverState ();

    inline void clear_has_e8ManeuverState ();

    inline void set_has_szCurrentRoadName ();

    inline void clear_has_szCurrentRoadName ();

    inline void set_has_szDestinationName ();

    inline void clear_has_szDestinationName ();

    inline void set_has_u64EstimatedTimeOfArrival ();

    inline void clear_has_u64EstimatedTimeOfArrival ();

    inline void set_has_u64TimeRemainingToDestination ();

    inline void clear_has_u64TimeRemainingToDestination ();

    inline void set_has_u32DistanceRemaining ();

    inline void clear_has_u32DistanceRemaining ();

    inline void set_has_szDistanceRemainingDisplayStr ();

    inline void clear_has_szDistanceRemainingDisplayStr ();

    inline void set_has_e8DistanceRemainingDisplayUnits ();

    inline void clear_has_e8DistanceRemainingDisplayUnits ();

    inline void set_has_u32DistanceToNextManeuver ();

    inline void clear_has_u32DistanceToNextManeuver ();

    inline void set_has_szDistanceToNextManeuverDisplayStr ();

    inline void clear_has_szDistanceToNextManeuverDisplayStr ();

    inline void set_has_e8DistanceToNextManeuverDisplayUnits ();

    inline void clear_has_e8DistanceToNextManeuverDisplayUnits ();

    inline void set_has_u16RouteGuidanceManeuverCurrentList ();

    inline void clear_has_u16RouteGuidanceManeuverCurrentList ();

    inline void set_has_u16RouteGuidanceManeuverCount ();

    inline void clear_has_u16RouteGuidanceManeuverCount ();

    inline void set_has_bIsRouteGuidanceVisibleInApp ();

    inline void clear_has_bIsRouteGuidanceVisibleInApp ();

    uint32 _has_bits_[ (15 + 31) / 32];

    T_e8_DiPoRouteGuidanceState _e8RouteGuidanceState;

    T_e8_DiPoManeuverState _e8ManeuverState;

    ::std::string _szCurrentRoadName;

    ::std::string _szDestinationName;

    uint64 _u64EstimatedTimeOfArrival;

    uint64 _u64TimeRemainingToDestination;

    uint32 _u32DistanceRemaining;

    ::std::string _szDistanceRemainingDisplayStr;

    T_e8_DistanceUnits _e8DistanceRemainingDisplayUnits;

    uint32 _u32DistanceToNextManeuver;

    ::std::string _szDistanceToNextManeuverDisplayStr;

    T_e8_DistanceUnits _e8DistanceToNextManeuverDisplayUnits;

    ::std::vector< uint16 > _u16RouteGuidanceManeuverCurrentList;

    uint16 _u16RouteGuidanceManeuverCount;

    bool _bIsRouteGuidanceVisibleInApp;

};

/**
 * Property contains RouteGuidanceManeuver Update.
 */
class T_DiPORouteGuidanceManeuverUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_DiPORouteGuidanceManeuverUpdate ();

    /**
     * Copy constructor
     */
    inline  T_DiPORouteGuidanceManeuverUpdate (const T_DiPORouteGuidanceManeuverUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_DiPORouteGuidanceManeuverUpdate (uint16 u16Index_, const ::std::string& szManeuverDescription_, T_e8_DiPoManeuverType e8ManeuverType_, const ::std::string& szAfterManeuverRoadName_, uint32 u32DistanceBetweenManeuver_, const ::std::string& szDistanceBetweenManeuverDisplayStr_, T_e8_DistanceUnits e8DistanceBetweenManeuverDisplayUnits_, T_e8_DiPoDrivingSide e8DrivingSide_, T_e8_DiPoJunctionType e8JunctionType_, int16 s16JunctionElementAngle_, int16 s16JunctionElementExitAngle_);

    /**
     * Destructor
     */
    inline  ~T_DiPORouteGuidanceManeuverUpdate();

    /**
     * Assignment operator
     */
    inline T_DiPORouteGuidanceManeuverUpdate& operator = (const T_DiPORouteGuidanceManeuverUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DiPORouteGuidanceManeuverUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DiPORouteGuidanceManeuverUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DiPORouteGuidanceManeuverUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DiPORouteGuidanceManeuverUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16Index"

    static const int kU16Index = 0;

    /**
     * Clears the field "u16Index".
     *
     * The field will be set to its default value. The hasU16Index()
     * method will return false.
     */
    inline void clearU16Index();

    /**
     * Checks whether the field "u16Index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Index()). Otherwise it will return false.
     */
    inline bool hasU16Index () const;

    /**
     * Returns the value of the member "u16Index".
     *
     * Specifies which item in the list is being updated.
     *
     * @return The value of the field "u16Index"
     */
    inline uint16 getU16Index () const;

    /**
     * Sets the value of the member "u16Index".
     *
     * Specifies which item in the list is being updated.
     *
     * @param u16Index The value which will be set
     */
    inline void setU16Index (uint16 u16Index_);

    // API of field "szManeuverDescription"

    static const int kSzManeuverDescription = 1;

    /**
     * Clears the field "szManeuverDescription".
     *
     * The field will be set to its default value. The hasSzManeuverDescription()
     * method will return false.
     */
    inline void clearSzManeuverDescription();

    /**
     * Checks whether the field "szManeuverDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzManeuverDescription()). Otherwise it will return false.
     */
    inline bool hasSzManeuverDescription () const;

    /**
     * Returns the value of the member "szManeuverDescription".
     *
     * ManeuverDescription
     *
     * @return The value of the field "szManeuverDescription"
     */
    inline const ::std::string& getSzManeuverDescription () const;

    /**
     * Retrieves the value of the field "szManeuverDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szManeuverDescription".
     */
    inline ::std::string& getSzManeuverDescriptionMutable ();

    /**
     * Sets the value of the member "szManeuverDescription".
     *
     * ManeuverDescription
     *
     * @param szManeuverDescription The value which will be set
     */
    inline void setSzManeuverDescription (const ::std::string& szManeuverDescription_);

    /**
     * Sets the value of the member "szManeuverDescription".
     *
     * ManeuverDescription
     *
     * @param szManeuverDescription The value which will be set
     */
    inline void setSzManeuverDescription (const char* szManeuverDescription_);

    /**
     * Sets the value of the member "szManeuverDescription".
     *
     * ManeuverDescription
     *
     * @param szManeuverDescription The value which will be set
     */
    inline void setSzManeuverDescription (const char* value, size_t size);

    // API of field "e8ManeuverType"

    static const int kE8ManeuverType = 2;

    /**
     * Clears the field "e8ManeuverType".
     *
     * The field will be set to its default value. The hasE8ManeuverType()
     * method will return false.
     */
    inline void clearE8ManeuverType();

    /**
     * Checks whether the field "e8ManeuverType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ManeuverType()). Otherwise it will return false.
     */
    inline bool hasE8ManeuverType () const;

    /**
     * Returns the value of the member "e8ManeuverType".
     *
     * ManeuverType enum.
     *
     * @return The value of the field "e8ManeuverType"
     */
    inline T_e8_DiPoManeuverType getE8ManeuverType () const;

    /**
     * Sets the value of the member "e8ManeuverType".
     *
     * ManeuverType enum.
     *
     * @param e8ManeuverType The value which will be set
     */
    inline void setE8ManeuverType (T_e8_DiPoManeuverType e8ManeuverType_);

    // API of field "szAfterManeuverRoadName"

    static const int kSzAfterManeuverRoadName = 3;

    /**
     * Clears the field "szAfterManeuverRoadName".
     *
     * The field will be set to its default value. The hasSzAfterManeuverRoadName()
     * method will return false.
     */
    inline void clearSzAfterManeuverRoadName();

    /**
     * Checks whether the field "szAfterManeuverRoadName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAfterManeuverRoadName()). Otherwise it will return false.
     */
    inline bool hasSzAfterManeuverRoadName () const;

    /**
     * Returns the value of the member "szAfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed succesfull.
     *
     * @return The value of the field "szAfterManeuverRoadName"
     */
    inline const ::std::string& getSzAfterManeuverRoadName () const;

    /**
     * Retrieves the value of the field "szAfterManeuverRoadName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAfterManeuverRoadName".
     */
    inline ::std::string& getSzAfterManeuverRoadNameMutable ();

    /**
     * Sets the value of the member "szAfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed succesfull.
     *
     * @param szAfterManeuverRoadName The value which will be set
     */
    inline void setSzAfterManeuverRoadName (const ::std::string& szAfterManeuverRoadName_);

    /**
     * Sets the value of the member "szAfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed succesfull.
     *
     * @param szAfterManeuverRoadName The value which will be set
     */
    inline void setSzAfterManeuverRoadName (const char* szAfterManeuverRoadName_);

    /**
     * Sets the value of the member "szAfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed succesfull.
     *
     * @param szAfterManeuverRoadName The value which will be set
     */
    inline void setSzAfterManeuverRoadName (const char* value, size_t size);

    // API of field "u32DistanceBetweenManeuver"

    static const int kU32DistanceBetweenManeuver = 4;

    /**
     * Clears the field "u32DistanceBetweenManeuver".
     *
     * The field will be set to its default value. The hasU32DistanceBetweenManeuver()
     * method will return false.
     */
    inline void clearU32DistanceBetweenManeuver();

    /**
     * Checks whether the field "u32DistanceBetweenManeuver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DistanceBetweenManeuver()). Otherwise it will return false.
     */
    inline bool hasU32DistanceBetweenManeuver () const;

    /**
     * Returns the value of the member "u32DistanceBetweenManeuver".
     *
     * Meters between previous maneuver to this maneuver.This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @return The value of the field "u32DistanceBetweenManeuver"
     */
    inline uint32 getU32DistanceBetweenManeuver () const;

    /**
     * Sets the value of the member "u32DistanceBetweenManeuver".
     *
     * Meters between previous maneuver to this maneuver.This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @param u32DistanceBetweenManeuver The value which will be set
     */
    inline void setU32DistanceBetweenManeuver (uint32 u32DistanceBetweenManeuver_);

    // API of field "szDistanceBetweenManeuverDisplayStr"

    static const int kSzDistanceBetweenManeuverDisplayStr = 5;

    /**
     * Clears the field "szDistanceBetweenManeuverDisplayStr".
     *
     * The field will be set to its default value. The hasSzDistanceBetweenManeuverDisplayStr()
     * method will return false.
     */
    inline void clearSzDistanceBetweenManeuverDisplayStr();

    /**
     * Checks whether the field "szDistanceBetweenManeuverDisplayStr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDistanceBetweenManeuverDisplayStr()). Otherwise it will return false.
     */
    inline bool hasSzDistanceBetweenManeuverDisplayStr () const;

    /**
     * Returns the value of the member "szDistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @return The value of the field "szDistanceBetweenManeuverDisplayStr"
     */
    inline const ::std::string& getSzDistanceBetweenManeuverDisplayStr () const;

    /**
     * Retrieves the value of the field "szDistanceBetweenManeuverDisplayStr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDistanceBetweenManeuverDisplayStr".
     */
    inline ::std::string& getSzDistanceBetweenManeuverDisplayStrMutable ();

    /**
     * Sets the value of the member "szDistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceBetweenManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceBetweenManeuverDisplayStr (const ::std::string& szDistanceBetweenManeuverDisplayStr_);

    /**
     * Sets the value of the member "szDistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceBetweenManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceBetweenManeuverDisplayStr (const char* szDistanceBetweenManeuverDisplayStr_);

    /**
     * Sets the value of the member "szDistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceBetweenManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceBetweenManeuverDisplayStr (const char* value, size_t size);

    // API of field "e8DistanceBetweenManeuverDisplayUnits"

    static const int kE8DistanceBetweenManeuverDisplayUnits = 6;

    /**
     * Clears the field "e8DistanceBetweenManeuverDisplayUnits".
     *
     * The field will be set to its default value. The hasE8DistanceBetweenManeuverDisplayUnits()
     * method will return false.
     */
    inline void clearE8DistanceBetweenManeuverDisplayUnits();

    /**
     * Checks whether the field "e8DistanceBetweenManeuverDisplayUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceBetweenManeuverDisplayUnits()). Otherwise it will return false.
     */
    inline bool hasE8DistanceBetweenManeuverDisplayUnits () const;

    /**
     * Returns the value of the member "e8DistanceBetweenManeuverDisplayUnits".
     *
     * Units that must accompany DistanceBetweenManeuver-DisplayStr when displayed to the user.
     *
     * @return The value of the field "e8DistanceBetweenManeuverDisplayUnits"
     */
    inline T_e8_DistanceUnits getE8DistanceBetweenManeuverDisplayUnits () const;

    /**
     * Sets the value of the member "e8DistanceBetweenManeuverDisplayUnits".
     *
     * Units that must accompany DistanceBetweenManeuver-DisplayStr when displayed to the user.
     *
     * @param e8DistanceBetweenManeuverDisplayUnits The value which will be set
     */
    inline void setE8DistanceBetweenManeuverDisplayUnits (T_e8_DistanceUnits e8DistanceBetweenManeuverDisplayUnits_);

    // API of field "e8DrivingSide"

    static const int kE8DrivingSide = 7;

    /**
     * Clears the field "e8DrivingSide".
     *
     * The field will be set to its default value. The hasE8DrivingSide()
     * method will return false.
     */
    inline void clearE8DrivingSide();

    /**
     * Checks whether the field "e8DrivingSide" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DrivingSide()). Otherwise it will return false.
     */
    inline bool hasE8DrivingSide () const;

    /**
     * Returns the value of the member "e8DrivingSide".
     *
     * Whether cars should drive on right or left side of the road.For roundabout, specifies the direction of traffic around the roundabout.
     *
     * @return The value of the field "e8DrivingSide"
     */
    inline T_e8_DiPoDrivingSide getE8DrivingSide () const;

    /**
     * Sets the value of the member "e8DrivingSide".
     *
     * Whether cars should drive on right or left side of the road.For roundabout, specifies the direction of traffic around the roundabout.
     *
     * @param e8DrivingSide The value which will be set
     */
    inline void setE8DrivingSide (T_e8_DiPoDrivingSide e8DrivingSide_);

    // API of field "e8JunctionType"

    static const int kE8JunctionType = 8;

    /**
     * Clears the field "e8JunctionType".
     *
     * The field will be set to its default value. The hasE8JunctionType()
     * method will return false.
     */
    inline void clearE8JunctionType();

    /**
     * Checks whether the field "e8JunctionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8JunctionType()). Otherwise it will return false.
     */
    inline bool hasE8JunctionType () const;

    /**
     * Returns the value of the member "e8JunctionType".
     *
     * JunctionType enum.
     *
     * @return The value of the field "e8JunctionType"
     */
    inline T_e8_DiPoJunctionType getE8JunctionType () const;

    /**
     * Sets the value of the member "e8JunctionType".
     *
     * JunctionType enum.
     *
     * @param e8JunctionType The value which will be set
     */
    inline void setE8JunctionType (T_e8_DiPoJunctionType e8JunctionType_);

    // API of field "s16JunctionElementAngle"

    static const int kS16JunctionElementAngle = 9;

    /**
     * Clears the field "s16JunctionElementAngle".
     *
     * The field will be set to its default value. The hasS16JunctionElementAngle()
     * method will return false.
     */
    inline void clearS16JunctionElementAngle();

    /**
     * Checks whether the field "s16JunctionElementAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16JunctionElementAngle()). Otherwise it will return false.
     */
    inline bool hasS16JunctionElementAngle () const;

    /**
     * Returns the value of the member "s16JunctionElementAngle".
     *
     * Angle of a junction element (+/- 180). Accessory must show all junction elements together. An entry junction element is implied at angle 180.
     *
     * @return The value of the field "s16JunctionElementAngle"
     */
    inline int16 getS16JunctionElementAngle () const;

    /**
     * Sets the value of the member "s16JunctionElementAngle".
     *
     * Angle of a junction element (+/- 180). Accessory must show all junction elements together. An entry junction element is implied at angle 180.
     *
     * @param s16JunctionElementAngle The value which will be set
     */
    inline void setS16JunctionElementAngle (int16 s16JunctionElementAngle_);

    // API of field "s16JunctionElementExitAngle"

    static const int kS16JunctionElementExitAngle = 10;

    /**
     * Clears the field "s16JunctionElementExitAngle".
     *
     * The field will be set to its default value. The hasS16JunctionElementExitAngle()
     * method will return false.
     */
    inline void clearS16JunctionElementExitAngle();

    /**
     * Checks whether the field "s16JunctionElementExitAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16JunctionElementExitAngle()). Otherwise it will return false.
     */
    inline bool hasS16JunctionElementExitAngle () const;

    /**
     * Returns the value of the member "s16JunctionElementExitAngle".
     *
     * Angle of an exit junction element (+/- 180). Junction element describing the road used to exit the junction, or exit of the manuever. Accessory must show all junction elements together.An entry junction element is implied at angle 180.
     *
     * @return The value of the field "s16JunctionElementExitAngle"
     */
    inline int16 getS16JunctionElementExitAngle () const;

    /**
     * Sets the value of the member "s16JunctionElementExitAngle".
     *
     * Angle of an exit junction element (+/- 180). Junction element describing the road used to exit the junction, or exit of the manuever. Accessory must show all junction elements together.An entry junction element is implied at angle 180.
     *
     * @param s16JunctionElementExitAngle The value which will be set
     */
    inline void setS16JunctionElementExitAngle (int16 s16JunctionElementExitAngle_);

    static const T_DiPORouteGuidanceManeuverUpdate &getDefaultInstance();

private:

    inline void set_has_u16Index ();

    inline void clear_has_u16Index ();

    inline void set_has_szManeuverDescription ();

    inline void clear_has_szManeuverDescription ();

    inline void set_has_e8ManeuverType ();

    inline void clear_has_e8ManeuverType ();

    inline void set_has_szAfterManeuverRoadName ();

    inline void clear_has_szAfterManeuverRoadName ();

    inline void set_has_u32DistanceBetweenManeuver ();

    inline void clear_has_u32DistanceBetweenManeuver ();

    inline void set_has_szDistanceBetweenManeuverDisplayStr ();

    inline void clear_has_szDistanceBetweenManeuverDisplayStr ();

    inline void set_has_e8DistanceBetweenManeuverDisplayUnits ();

    inline void clear_has_e8DistanceBetweenManeuverDisplayUnits ();

    inline void set_has_e8DrivingSide ();

    inline void clear_has_e8DrivingSide ();

    inline void set_has_e8JunctionType ();

    inline void clear_has_e8JunctionType ();

    inline void set_has_s16JunctionElementAngle ();

    inline void clear_has_s16JunctionElementAngle ();

    inline void set_has_s16JunctionElementExitAngle ();

    inline void clear_has_s16JunctionElementExitAngle ();

    uint32 _has_bits_[ (11 + 31) / 32];

    uint16 _u16Index;

    ::std::string _szManeuverDescription;

    T_e8_DiPoManeuverType _e8ManeuverType;

    ::std::string _szAfterManeuverRoadName;

    uint32 _u32DistanceBetweenManeuver;

    ::std::string _szDistanceBetweenManeuverDisplayStr;

    T_e8_DistanceUnits _e8DistanceBetweenManeuverDisplayUnits;

    T_e8_DiPoDrivingSide _e8DrivingSide;

    T_e8_DiPoJunctionType _e8JunctionType;

    int16 _s16JunctionElementAngle;

    int16 _s16JunctionElementExitAngle;

};

/**
 * Skeleton of T_CarPlayTBTUpdate.
 */
class T_CarPlayTBTUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_CarPlayTBTUpdate ();

    /**
     * Copy constructor
     */
    inline  T_CarPlayTBTUpdate (const T_CarPlayTBTUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_CarPlayTBTUpdate (const T_DiPORouteGuidanceUpdate& DiPoRouteGuidanceUpdate_, bool isDiPoRouteGuidanceUpdateValid_, const T_DiPORouteGuidanceManeuverUpdate& DiPoRouteGuidanceManeuverUpdate_, bool isDiPoRouteGuidanceManeuverUpdateValid_);

    /**
     * Destructor
     */
    inline  ~T_CarPlayTBTUpdate();

    /**
     * Assignment operator
     */
    inline T_CarPlayTBTUpdate& operator = (const T_CarPlayTBTUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CarPlayTBTUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CarPlayTBTUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CarPlayTBTUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CarPlayTBTUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DiPoRouteGuidanceUpdate"

    static const int kDiPoRouteGuidanceUpdate = 0;

    /**
     * Clears the field "DiPoRouteGuidanceUpdate".
     *
     * The field will be set to its default value. The hasDiPoRouteGuidanceUpdate()
     * method will return false.
     */
    inline void clearDiPoRouteGuidanceUpdate();

    /**
     * Checks whether the field "DiPoRouteGuidanceUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiPoRouteGuidanceUpdate()). Otherwise it will return false.
     */
    inline bool hasDiPoRouteGuidanceUpdate () const;

    /**
     * Returns the value of the member "DiPoRouteGuidanceUpdate".
     *
     * Structure Containing DiPORouteGuidance info.
     *
     * @return The value of the field "DiPoRouteGuidanceUpdate"
     */
    inline const T_DiPORouteGuidanceUpdate& getDiPoRouteGuidanceUpdate () const;

    /**
     * Retrieves the value of the field "DiPoRouteGuidanceUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DiPoRouteGuidanceUpdate".
     */
    inline T_DiPORouteGuidanceUpdate& getDiPoRouteGuidanceUpdateMutable ();

    /**
     * Sets the value of the member "DiPoRouteGuidanceUpdate".
     *
     * Structure Containing DiPORouteGuidance info.
     *
     * @param DiPoRouteGuidanceUpdate The value which will be set
     */
    inline void setDiPoRouteGuidanceUpdate (const T_DiPORouteGuidanceUpdate& DiPoRouteGuidanceUpdate_);

    // API of field "isDiPoRouteGuidanceUpdateValid"

    static const int kIsDiPoRouteGuidanceUpdateValid = 1;

    /**
     * Clears the field "isDiPoRouteGuidanceUpdateValid".
     *
     * The field will be set to its default value. The hasIsDiPoRouteGuidanceUpdateValid()
     * method will return false.
     */
    inline void clearIsDiPoRouteGuidanceUpdateValid();

    /**
     * Checks whether the field "isDiPoRouteGuidanceUpdateValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsDiPoRouteGuidanceUpdateValid()). Otherwise it will return false.
     */
    inline bool hasIsDiPoRouteGuidanceUpdateValid () const;

    /**
     * Returns the value of the member "isDiPoRouteGuidanceUpdateValid".
     *
     * Client must use DiPoRouteGuidanceUpdate only if it is true.
     *
     * @return The value of the field "isDiPoRouteGuidanceUpdateValid"
     */
    inline bool getIsDiPoRouteGuidanceUpdateValid () const;

    /**
     * Sets the value of the member "isDiPoRouteGuidanceUpdateValid".
     *
     * Client must use DiPoRouteGuidanceUpdate only if it is true.
     *
     * @param isDiPoRouteGuidanceUpdateValid The value which will be set
     */
    inline void setIsDiPoRouteGuidanceUpdateValid (bool isDiPoRouteGuidanceUpdateValid_);

    // API of field "DiPoRouteGuidanceManeuverUpdate"

    static const int kDiPoRouteGuidanceManeuverUpdate = 2;

    /**
     * Clears the field "DiPoRouteGuidanceManeuverUpdate".
     *
     * The field will be set to its default value. The hasDiPoRouteGuidanceManeuverUpdate()
     * method will return false.
     */
    inline void clearDiPoRouteGuidanceManeuverUpdate();

    /**
     * Checks whether the field "DiPoRouteGuidanceManeuverUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiPoRouteGuidanceManeuverUpdate()). Otherwise it will return false.
     */
    inline bool hasDiPoRouteGuidanceManeuverUpdate () const;

    /**
     * Returns the value of the member "DiPoRouteGuidanceManeuverUpdate".
     *
     * Structure Containing DiPORouteGuidanceManeuver info.
     *
     * @return The value of the field "DiPoRouteGuidanceManeuverUpdate"
     */
    inline const T_DiPORouteGuidanceManeuverUpdate& getDiPoRouteGuidanceManeuverUpdate () const;

    /**
     * Retrieves the value of the field "DiPoRouteGuidanceManeuverUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DiPoRouteGuidanceManeuverUpdate".
     */
    inline T_DiPORouteGuidanceManeuverUpdate& getDiPoRouteGuidanceManeuverUpdateMutable ();

    /**
     * Sets the value of the member "DiPoRouteGuidanceManeuverUpdate".
     *
     * Structure Containing DiPORouteGuidanceManeuver info.
     *
     * @param DiPoRouteGuidanceManeuverUpdate The value which will be set
     */
    inline void setDiPoRouteGuidanceManeuverUpdate (const T_DiPORouteGuidanceManeuverUpdate& DiPoRouteGuidanceManeuverUpdate_);

    // API of field "isDiPoRouteGuidanceManeuverUpdateValid"

    static const int kIsDiPoRouteGuidanceManeuverUpdateValid = 3;

    /**
     * Clears the field "isDiPoRouteGuidanceManeuverUpdateValid".
     *
     * The field will be set to its default value. The hasIsDiPoRouteGuidanceManeuverUpdateValid()
     * method will return false.
     */
    inline void clearIsDiPoRouteGuidanceManeuverUpdateValid();

    /**
     * Checks whether the field "isDiPoRouteGuidanceManeuverUpdateValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsDiPoRouteGuidanceManeuverUpdateValid()). Otherwise it will return false.
     */
    inline bool hasIsDiPoRouteGuidanceManeuverUpdateValid () const;

    /**
     * Returns the value of the member "isDiPoRouteGuidanceManeuverUpdateValid".
     *
     * Client must use DiPoRouteGuidanceManeuverUpdate only if it is true.
     *
     * @return The value of the field "isDiPoRouteGuidanceManeuverUpdateValid"
     */
    inline bool getIsDiPoRouteGuidanceManeuverUpdateValid () const;

    /**
     * Sets the value of the member "isDiPoRouteGuidanceManeuverUpdateValid".
     *
     * Client must use DiPoRouteGuidanceManeuverUpdate only if it is true.
     *
     * @param isDiPoRouteGuidanceManeuverUpdateValid The value which will be set
     */
    inline void setIsDiPoRouteGuidanceManeuverUpdateValid (bool isDiPoRouteGuidanceManeuverUpdateValid_);

    static const T_CarPlayTBTUpdate &getDefaultInstance();

private:

    inline void set_has_DiPoRouteGuidanceUpdate ();

    inline void clear_has_DiPoRouteGuidanceUpdate ();

    inline void set_has_isDiPoRouteGuidanceUpdateValid ();

    inline void clear_has_isDiPoRouteGuidanceUpdateValid ();

    inline void set_has_DiPoRouteGuidanceManeuverUpdate ();

    inline void clear_has_DiPoRouteGuidanceManeuverUpdate ();

    inline void set_has_isDiPoRouteGuidanceManeuverUpdateValid ();

    inline void clear_has_isDiPoRouteGuidanceManeuverUpdateValid ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_DiPORouteGuidanceUpdate _DiPoRouteGuidanceUpdate;

    bool _isDiPoRouteGuidanceUpdateValid;

    T_DiPORouteGuidanceManeuverUpdate _DiPoRouteGuidanceManeuverUpdate;

    bool _isDiPoRouteGuidanceManeuverUpdateValid;

};

/**
 * Scope: AAP
 * Updates Turn-By-Turn Projection Navigation Information to the client.
 */
class T_AAutoNavigationNextTurnData {
public:

    /**
     * Default constructor
     */
    inline  T_AAutoNavigationNextTurnData ();

    /**
     * Copy constructor
     */
    inline  T_AAutoNavigationNextTurnData (const T_AAutoNavigationNextTurnData &rhs);

    /**
     * All fields constructor
     */
    inline  T_AAutoNavigationNextTurnData (const ::std::string& RoadName_, T_e8_AAutoTurnSide TurnSide_, T_e8_AAutoNextTurnEvent NextTurnEvent_, const ::std::vector< uint8 >& Image_, int32 TurnAngle_, int32 TurnNumber_);

    /**
     * Destructor
     */
    inline  ~T_AAutoNavigationNextTurnData();

    /**
     * Assignment operator
     */
    inline T_AAutoNavigationNextTurnData& operator = (const T_AAutoNavigationNextTurnData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AAutoNavigationNextTurnData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AAutoNavigationNextTurnData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AAutoNavigationNextTurnData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AAutoNavigationNextTurnData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RoadName"

    static const int kRoadName = 0;

    /**
     * Clears the field "RoadName".
     *
     * The field will be set to its default value. The hasRoadName()
     * method will return false.
     */
    inline void clearRoadName();

    /**
     * Checks whether the field "RoadName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoadName()). Otherwise it will return false.
     */
    inline bool hasRoadName () const;

    /**
     * Returns the value of the member "RoadName".
     *
     * Identifies name of the Road.
     *
     * @return The value of the field "RoadName"
     */
    inline const ::std::string& getRoadName () const;

    /**
     * Retrieves the value of the field "RoadName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RoadName".
     */
    inline ::std::string& getRoadNameMutable ();

    /**
     * Sets the value of the member "RoadName".
     *
     * Identifies name of the Road.
     *
     * @param RoadName The value which will be set
     */
    inline void setRoadName (const ::std::string& RoadName_);

    /**
     * Sets the value of the member "RoadName".
     *
     * Identifies name of the Road.
     *
     * @param RoadName The value which will be set
     */
    inline void setRoadName (const char* RoadName_);

    /**
     * Sets the value of the member "RoadName".
     *
     * Identifies name of the Road.
     *
     * @param RoadName The value which will be set
     */
    inline void setRoadName (const char* value, size_t size);

    // API of field "TurnSide"

    static const int kTurnSide = 1;

    /**
     * Clears the field "TurnSide".
     *
     * The field will be set to its default value. The hasTurnSide()
     * method will return false.
     */
    inline void clearTurnSide();

    /**
     * Checks whether the field "TurnSide" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTurnSide()). Otherwise it will return false.
     */
    inline bool hasTurnSide () const;

    /**
     * Returns the value of the member "TurnSide".
     *
     * Indicates the turn direction
     *
     * @return The value of the field "TurnSide"
     */
    inline T_e8_AAutoTurnSide getTurnSide () const;

    /**
     * Sets the value of the member "TurnSide".
     *
     * Indicates the turn direction
     *
     * @param TurnSide The value which will be set
     */
    inline void setTurnSide (T_e8_AAutoTurnSide TurnSide_);

    // API of field "NextTurnEvent"

    static const int kNextTurnEvent = 2;

    /**
     * Clears the field "NextTurnEvent".
     *
     * The field will be set to its default value. The hasNextTurnEvent()
     * method will return false.
     */
    inline void clearNextTurnEvent();

    /**
     * Checks whether the field "NextTurnEvent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextTurnEvent()). Otherwise it will return false.
     */
    inline bool hasNextTurnEvent () const;

    /**
     * Returns the value of the member "NextTurnEvent".
     *
     * Indicates the turn baseType
     *
     * @return The value of the field "NextTurnEvent"
     */
    inline T_e8_AAutoNextTurnEvent getNextTurnEvent () const;

    /**
     * Sets the value of the member "NextTurnEvent".
     *
     * Indicates the turn baseType
     *
     * @param NextTurnEvent The value which will be set
     */
    inline void setNextTurnEvent (T_e8_AAutoNextTurnEvent NextTurnEvent_);

    // API of field "Image"

    static const int kImage = 3;

    /**
     * Clears the field "Image".
     *
     * The field will be set to its default value. The hasImage()
     * method will return false.
     */
    inline void clearImage();

    /**
     * Checks whether the field "Image" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImage()). Otherwise it will return false.
     */
    inline bool hasImage () const;

    /**
     * Returns the value of the member "Image".
     *
     * Icon image in PNG format for TBT event.
     *
     * @return The value of the field "Image"
     */
    inline const ::std::vector< uint8 >& getImage () const;

    /**
     * Retrieves the value of the field "Image" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Image".
     */
    inline ::std::vector< uint8 >& getImageMutable ();

    /**
     * Sets the value of the member "Image".
     *
     * Icon image in PNG format for TBT event.
     *
     * @param Image The value which will be set
     */
    inline void setImage (const ::std::vector< uint8 >& Image_);

    // API of field "TurnAngle"

    static const int kTurnAngle = 4;

    /**
     * Clears the field "TurnAngle".
     *
     * The field will be set to its default value. The hasTurnAngle()
     * method will return false.
     */
    inline void clearTurnAngle();

    /**
     * Checks whether the field "TurnAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTurnAngle()). Otherwise it will return false.
     */
    inline bool hasTurnAngle () const;

    /**
     * Returns the value of the member "TurnAngle".
     *
     * Indicates turn angle in degrees between the roundabout entry and exit (0..359).
     * Only used for turn event type ROUNDABOUT_ENTER_AND_EXIT, -1 otherwise.
     *
     * @return The value of the field "TurnAngle"
     */
    inline int32 getTurnAngle () const;

    /**
     * Sets the value of the member "TurnAngle".
     *
     * Indicates turn angle in degrees between the roundabout entry and exit (0..359).
     * Only used for turn event type ROUNDABOUT_ENTER_AND_EXIT, -1 otherwise.
     *
     * @param TurnAngle The value which will be set
     */
    inline void setTurnAngle (int32 TurnAngle_);

    // API of field "TurnNumber"

    static const int kTurnNumber = 5;

    /**
     * Clears the field "TurnNumber".
     *
     * The field will be set to its default value. The hasTurnNumber()
     * method will return false.
     */
    inline void clearTurnNumber();

    /**
     * Checks whether the field "TurnNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTurnNumber()). Otherwise it will return false.
     */
    inline bool hasTurnNumber () const;

    /**
     * Returns the value of the member "TurnNumber".
     *
     * Indicates turn number, counting around from the roundabout entry to the exit.
     * Only used for turn event type ROUNDABOUT_ENTER_AND_EXIT, -1 otherwise.
     *
     * @return The value of the field "TurnNumber"
     */
    inline int32 getTurnNumber () const;

    /**
     * Sets the value of the member "TurnNumber".
     *
     * Indicates turn number, counting around from the roundabout entry to the exit.
     * Only used for turn event type ROUNDABOUT_ENTER_AND_EXIT, -1 otherwise.
     *
     * @param TurnNumber The value which will be set
     */
    inline void setTurnNumber (int32 TurnNumber_);

    static const T_AAutoNavigationNextTurnData &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_RoadName ();

    inline void clear_has_RoadName ();

    inline void set_has_TurnSide ();

    inline void clear_has_TurnSide ();

    inline void set_has_NextTurnEvent ();

    inline void clear_has_NextTurnEvent ();

    inline void set_has_Image ();

    inline void clear_has_Image ();

    inline void set_has_TurnAngle ();

    inline void clear_has_TurnAngle ();

    inline void set_has_TurnNumber ();

    inline void clear_has_TurnNumber ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::std::string _RoadName;

    T_e8_AAutoTurnSide _TurnSide;

    T_e8_AAutoNextTurnEvent _NextTurnEvent;

    ::std::vector< uint8 > _Image;

    int32 _TurnAngle;

    int32 _TurnNumber;

};

/**
 * Scope: AAP
 * Interface to update the Projection Navigation Next Turn Distance Data to the clients.
 */
class T_AAutoNavigationNextTurnDistanceData {
public:

    /**
     * Default constructor
     */
    inline  T_AAutoNavigationNextTurnDistanceData ();

    /**
     * Copy constructor
     */
    inline  T_AAutoNavigationNextTurnDistanceData (const T_AAutoNavigationNextTurnDistanceData &rhs);

    /**
     * All fields constructor
     */
    inline  T_AAutoNavigationNextTurnDistanceData (int32 DistanceInMeters_, int32 TimeInSec_, int32 DistanceToManeuver_, T_e8_DistanceUnits ManeuverDistanceUnits_);

    /**
     * Destructor
     */
    inline  ~T_AAutoNavigationNextTurnDistanceData();

    /**
     * Assignment operator
     */
    inline T_AAutoNavigationNextTurnDistanceData& operator = (const T_AAutoNavigationNextTurnDistanceData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AAutoNavigationNextTurnDistanceData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AAutoNavigationNextTurnDistanceData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AAutoNavigationNextTurnDistanceData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AAutoNavigationNextTurnDistanceData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DistanceInMeters"

    static const int kDistanceInMeters = 0;

    /**
     * Clears the field "DistanceInMeters".
     *
     * The field will be set to its default value. The hasDistanceInMeters()
     * method will return false.
     */
    inline void clearDistanceInMeters();

    /**
     * Checks whether the field "DistanceInMeters" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceInMeters()). Otherwise it will return false.
     */
    inline bool hasDistanceInMeters () const;

    /**
     * Returns the value of the member "DistanceInMeters".
     *
     * Indicates Distance to next turn event, in meters.
     *
     * @return The value of the field "DistanceInMeters"
     */
    inline int32 getDistanceInMeters () const;

    /**
     * Sets the value of the member "DistanceInMeters".
     *
     * Indicates Distance to next turn event, in meters.
     *
     * @param DistanceInMeters The value which will be set
     */
    inline void setDistanceInMeters (int32 DistanceInMeters_);

    // API of field "TimeInSec"

    static const int kTimeInSec = 1;

    /**
     * Clears the field "TimeInSec".
     *
     * The field will be set to its default value. The hasTimeInSec()
     * method will return false.
     */
    inline void clearTimeInSec();

    /**
     * Checks whether the field "TimeInSec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeInSec()). Otherwise it will return false.
     */
    inline bool hasTimeInSec () const;

    /**
     * Returns the value of the member "TimeInSec".
     *
     * Indicates Time to next turn event, in seconds.
     *
     * @return The value of the field "TimeInSec"
     */
    inline int32 getTimeInSec () const;

    /**
     * Sets the value of the member "TimeInSec".
     *
     * Indicates Time to next turn event, in seconds.
     *
     * @param TimeInSec The value which will be set
     */
    inline void setTimeInSec (int32 TimeInSec_);

    // API of field "DistanceToManeuver"

    static const int kDistanceToManeuver = 2;

    /**
     * Clears the field "DistanceToManeuver".
     *
     * The field will be set to its default value. The hasDistanceToManeuver()
     * method will return false.
     */
    inline void clearDistanceToManeuver();

    /**
     * Checks whether the field "DistanceToManeuver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceToManeuver()). Otherwise it will return false.
     */
    inline bool hasDistanceToManeuver () const;

    /**
     * Returns the value of the member "DistanceToManeuver".
     *
     * Indicates the distance to a next turn which is rounded off and converted to units specified by DistanceToManeuver.
     *
     * @return The value of the field "DistanceToManeuver"
     */
    inline int32 getDistanceToManeuver () const;

    /**
     * Sets the value of the member "DistanceToManeuver".
     *
     * Indicates the distance to a next turn which is rounded off and converted to units specified by DistanceToManeuver.
     *
     * @param DistanceToManeuver The value which will be set
     */
    inline void setDistanceToManeuver (int32 DistanceToManeuver_);

    // API of field "ManeuverDistanceUnits"

    static const int kManeuverDistanceUnits = 3;

    /**
     * Clears the field "ManeuverDistanceUnits".
     *
     * The field will be set to its default value. The hasManeuverDistanceUnits()
     * method will return false.
     */
    inline void clearManeuverDistanceUnits();

    /**
     * Checks whether the field "ManeuverDistanceUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManeuverDistanceUnits()). Otherwise it will return false.
     */
    inline bool hasManeuverDistanceUnits () const;

    /**
     * Returns the value of the member "ManeuverDistanceUnits".
     *
     * Indicates Distance in various units.It can be in meters,kilometers,miles,feet and yards.
     *
     * @return The value of the field "ManeuverDistanceUnits"
     */
    inline T_e8_DistanceUnits getManeuverDistanceUnits () const;

    /**
     * Sets the value of the member "ManeuverDistanceUnits".
     *
     * Indicates Distance in various units.It can be in meters,kilometers,miles,feet and yards.
     *
     * @param ManeuverDistanceUnits The value which will be set
     */
    inline void setManeuverDistanceUnits (T_e8_DistanceUnits ManeuverDistanceUnits_);

    static const T_AAutoNavigationNextTurnDistanceData &getDefaultInstance();

private:

    inline void set_has_DistanceInMeters ();

    inline void clear_has_DistanceInMeters ();

    inline void set_has_TimeInSec ();

    inline void clear_has_TimeInSec ();

    inline void set_has_DistanceToManeuver ();

    inline void clear_has_DistanceToManeuver ();

    inline void set_has_ManeuverDistanceUnits ();

    inline void clear_has_ManeuverDistanceUnits ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _DistanceInMeters;

    int32 _TimeInSec;

    int32 _DistanceToManeuver;

    T_e8_DistanceUnits _ManeuverDistanceUnits;

};

/**
 * Skeleton of T_AAutoTBTUpdate
 */
class T_AAutoTBTUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_AAutoTBTUpdate ();

    /**
     * Copy constructor
     */
    inline  T_AAutoTBTUpdate (const T_AAutoTBTUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_AAutoTBTUpdate (const T_AAutoNavigationNextTurnData& AAutoNavigationNextTurnData_, bool isAAutoNavigationNextTurnDataValid_, const T_AAutoNavigationNextTurnDistanceData& AAutoNavigationNextTurnDistanceData_, bool isAAutoNavigationNextTurnDistanceDataValid_, T_e8_AAutoNavigationAppState AAutoNavigationStatus_, bool isAAutoNavigationStatusValid_);

    /**
     * Destructor
     */
    inline  ~T_AAutoTBTUpdate();

    /**
     * Assignment operator
     */
    inline T_AAutoTBTUpdate& operator = (const T_AAutoTBTUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AAutoTBTUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AAutoTBTUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AAutoTBTUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AAutoTBTUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AAutoNavigationNextTurnData"

    static const int kAAutoNavigationNextTurnData = 0;

    /**
     * Clears the field "AAutoNavigationNextTurnData".
     *
     * The field will be set to its default value. The hasAAutoNavigationNextTurnData()
     * method will return false.
     */
    inline void clearAAutoNavigationNextTurnData();

    /**
     * Checks whether the field "AAutoNavigationNextTurnData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAAutoNavigationNextTurnData()). Otherwise it will return false.
     */
    inline bool hasAAutoNavigationNextTurnData () const;

    /**
     * Returns the value of the member "AAutoNavigationNextTurnData".
     *
     * Structure Containing NavigationNextTurnData info.
     *
     * @return The value of the field "AAutoNavigationNextTurnData"
     */
    inline const T_AAutoNavigationNextTurnData& getAAutoNavigationNextTurnData () const;

    /**
     * Retrieves the value of the field "AAutoNavigationNextTurnData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AAutoNavigationNextTurnData".
     */
    inline T_AAutoNavigationNextTurnData& getAAutoNavigationNextTurnDataMutable ();

    /**
     * Sets the value of the member "AAutoNavigationNextTurnData".
     *
     * Structure Containing NavigationNextTurnData info.
     *
     * @param AAutoNavigationNextTurnData The value which will be set
     */
    inline void setAAutoNavigationNextTurnData (const T_AAutoNavigationNextTurnData& AAutoNavigationNextTurnData_);

    // API of field "isAAutoNavigationNextTurnDataValid"

    static const int kIsAAutoNavigationNextTurnDataValid = 1;

    /**
     * Clears the field "isAAutoNavigationNextTurnDataValid".
     *
     * The field will be set to its default value. The hasIsAAutoNavigationNextTurnDataValid()
     * method will return false.
     */
    inline void clearIsAAutoNavigationNextTurnDataValid();

    /**
     * Checks whether the field "isAAutoNavigationNextTurnDataValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsAAutoNavigationNextTurnDataValid()). Otherwise it will return false.
     */
    inline bool hasIsAAutoNavigationNextTurnDataValid () const;

    /**
     * Returns the value of the member "isAAutoNavigationNextTurnDataValid".
     *
     * Client must use AAutoNavigationNextTurnData only if it is true.
     *
     * @return The value of the field "isAAutoNavigationNextTurnDataValid"
     */
    inline bool getIsAAutoNavigationNextTurnDataValid () const;

    /**
     * Sets the value of the member "isAAutoNavigationNextTurnDataValid".
     *
     * Client must use AAutoNavigationNextTurnData only if it is true.
     *
     * @param isAAutoNavigationNextTurnDataValid The value which will be set
     */
    inline void setIsAAutoNavigationNextTurnDataValid (bool isAAutoNavigationNextTurnDataValid_);

    // API of field "AAutoNavigationNextTurnDistanceData"

    static const int kAAutoNavigationNextTurnDistanceData = 2;

    /**
     * Clears the field "AAutoNavigationNextTurnDistanceData".
     *
     * The field will be set to its default value. The hasAAutoNavigationNextTurnDistanceData()
     * method will return false.
     */
    inline void clearAAutoNavigationNextTurnDistanceData();

    /**
     * Checks whether the field "AAutoNavigationNextTurnDistanceData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAAutoNavigationNextTurnDistanceData()). Otherwise it will return false.
     */
    inline bool hasAAutoNavigationNextTurnDistanceData () const;

    /**
     * Returns the value of the member "AAutoNavigationNextTurnDistanceData".
     *
     * Structure Containing NavigationNextTurnDistanceData info.
     *
     * @return The value of the field "AAutoNavigationNextTurnDistanceData"
     */
    inline const T_AAutoNavigationNextTurnDistanceData& getAAutoNavigationNextTurnDistanceData () const;

    /**
     * Retrieves the value of the field "AAutoNavigationNextTurnDistanceData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AAutoNavigationNextTurnDistanceData".
     */
    inline T_AAutoNavigationNextTurnDistanceData& getAAutoNavigationNextTurnDistanceDataMutable ();

    /**
     * Sets the value of the member "AAutoNavigationNextTurnDistanceData".
     *
     * Structure Containing NavigationNextTurnDistanceData info.
     *
     * @param AAutoNavigationNextTurnDistanceData The value which will be set
     */
    inline void setAAutoNavigationNextTurnDistanceData (const T_AAutoNavigationNextTurnDistanceData& AAutoNavigationNextTurnDistanceData_);

    // API of field "isAAutoNavigationNextTurnDistanceDataValid"

    static const int kIsAAutoNavigationNextTurnDistanceDataValid = 3;

    /**
     * Clears the field "isAAutoNavigationNextTurnDistanceDataValid".
     *
     * The field will be set to its default value. The hasIsAAutoNavigationNextTurnDistanceDataValid()
     * method will return false.
     */
    inline void clearIsAAutoNavigationNextTurnDistanceDataValid();

    /**
     * Checks whether the field "isAAutoNavigationNextTurnDistanceDataValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsAAutoNavigationNextTurnDistanceDataValid()). Otherwise it will return false.
     */
    inline bool hasIsAAutoNavigationNextTurnDistanceDataValid () const;

    /**
     * Returns the value of the member "isAAutoNavigationNextTurnDistanceDataValid".
     *
     * Client must use AAutoNavigationNextTurnDistanceData only if it is true.
     *
     * @return The value of the field "isAAutoNavigationNextTurnDistanceDataValid"
     */
    inline bool getIsAAutoNavigationNextTurnDistanceDataValid () const;

    /**
     * Sets the value of the member "isAAutoNavigationNextTurnDistanceDataValid".
     *
     * Client must use AAutoNavigationNextTurnDistanceData only if it is true.
     *
     * @param isAAutoNavigationNextTurnDistanceDataValid The value which will be set
     */
    inline void setIsAAutoNavigationNextTurnDistanceDataValid (bool isAAutoNavigationNextTurnDistanceDataValid_);

    // API of field "AAutoNavigationStatus"

    static const int kAAutoNavigationStatus = 4;

    /**
     * Clears the field "AAutoNavigationStatus".
     *
     * The field will be set to its default value. The hasAAutoNavigationStatus()
     * method will return false.
     */
    inline void clearAAutoNavigationStatus();

    /**
     * Checks whether the field "AAutoNavigationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAAutoNavigationStatus()). Otherwise it will return false.
     */
    inline bool hasAAutoNavigationStatus () const;

    /**
     * Returns the value of the member "AAutoNavigationStatus".
     *
     * Structure Containing AAutoNavigationStatusInfo info.
     *
     * @return The value of the field "AAutoNavigationStatus"
     */
    inline T_e8_AAutoNavigationAppState getAAutoNavigationStatus () const;

    /**
     * Sets the value of the member "AAutoNavigationStatus".
     *
     * Structure Containing AAutoNavigationStatusInfo info.
     *
     * @param AAutoNavigationStatus The value which will be set
     */
    inline void setAAutoNavigationStatus (T_e8_AAutoNavigationAppState AAutoNavigationStatus_);

    // API of field "isAAutoNavigationStatusValid"

    static const int kIsAAutoNavigationStatusValid = 5;

    /**
     * Clears the field "isAAutoNavigationStatusValid".
     *
     * The field will be set to its default value. The hasIsAAutoNavigationStatusValid()
     * method will return false.
     */
    inline void clearIsAAutoNavigationStatusValid();

    /**
     * Checks whether the field "isAAutoNavigationStatusValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsAAutoNavigationStatusValid()). Otherwise it will return false.
     */
    inline bool hasIsAAutoNavigationStatusValid () const;

    /**
     * Returns the value of the member "isAAutoNavigationStatusValid".
     *
     * Client must use AAutoNavigationStatusInfo only if it is true.
     *
     * @return The value of the field "isAAutoNavigationStatusValid"
     */
    inline bool getIsAAutoNavigationStatusValid () const;

    /**
     * Sets the value of the member "isAAutoNavigationStatusValid".
     *
     * Client must use AAutoNavigationStatusInfo only if it is true.
     *
     * @param isAAutoNavigationStatusValid The value which will be set
     */
    inline void setIsAAutoNavigationStatusValid (bool isAAutoNavigationStatusValid_);

    static const T_AAutoTBTUpdate &getDefaultInstance();

private:

    inline void set_has_AAutoNavigationNextTurnData ();

    inline void clear_has_AAutoNavigationNextTurnData ();

    inline void set_has_isAAutoNavigationNextTurnDataValid ();

    inline void clear_has_isAAutoNavigationNextTurnDataValid ();

    inline void set_has_AAutoNavigationNextTurnDistanceData ();

    inline void clear_has_AAutoNavigationNextTurnDistanceData ();

    inline void set_has_isAAutoNavigationNextTurnDistanceDataValid ();

    inline void clear_has_isAAutoNavigationNextTurnDistanceDataValid ();

    inline void set_has_AAutoNavigationStatus ();

    inline void clear_has_AAutoNavigationStatus ();

    inline void set_has_isAAutoNavigationStatusValid ();

    inline void clear_has_isAAutoNavigationStatusValid ();

    uint32 _has_bits_[ (6 + 31) / 32];

    T_AAutoNavigationNextTurnData _AAutoNavigationNextTurnData;

    bool _isAAutoNavigationNextTurnDataValid;

    T_AAutoNavigationNextTurnDistanceData _AAutoNavigationNextTurnDistanceData;

    bool _isAAutoNavigationNextTurnDistanceDataValid;

    T_e8_AAutoNavigationAppState _AAutoNavigationStatus;

    bool _isAAutoNavigationStatusValid;

};

/**
 * Scope: BDCL
 * Updates Turn-By-Turn Projection Navigation Information to the client.
 */
class T_CarlifeNaviNextTurnInfo {
public:

    /**
     * Default constructor
     */
    inline  T_CarlifeNaviNextTurnInfo ();

    /**
     * Copy constructor
     */
    inline  T_CarlifeNaviNextTurnInfo (const T_CarlifeNaviNextTurnInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_CarlifeNaviNextTurnInfo (T_e8_BDCLNavigationAppState BDCLNavigationAppState_, T_e8_BDCLNextTurnType BDCLNaviTurnType_, const ::std::string& RoadName_, uint32 TotalDistance_, uint32 RemainDistance_, const ::std::vector< uint8 >& TurnIconData_);

    /**
     * Destructor
     */
    inline  ~T_CarlifeNaviNextTurnInfo();

    /**
     * Assignment operator
     */
    inline T_CarlifeNaviNextTurnInfo& operator = (const T_CarlifeNaviNextTurnInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CarlifeNaviNextTurnInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CarlifeNaviNextTurnInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CarlifeNaviNextTurnInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CarlifeNaviNextTurnInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BDCLNavigationAppState"

    static const int kBDCLNavigationAppState = 0;

    /**
     * Clears the field "BDCLNavigationAppState".
     *
     * The field will be set to its default value. The hasBDCLNavigationAppState()
     * method will return false.
     */
    inline void clearBDCLNavigationAppState();

    /**
     * Checks whether the field "BDCLNavigationAppState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDCLNavigationAppState()). Otherwise it will return false.
     */
    inline bool hasBDCLNavigationAppState () const;

    /**
     * Returns the value of the member "BDCLNavigationAppState".
     *
     * Baidu Carlife Projection Navigation Status Information.
     *
     * @return The value of the field "BDCLNavigationAppState"
     */
    inline T_e8_BDCLNavigationAppState getBDCLNavigationAppState () const;

    /**
     * Sets the value of the member "BDCLNavigationAppState".
     *
     * Baidu Carlife Projection Navigation Status Information.
     *
     * @param BDCLNavigationAppState The value which will be set
     */
    inline void setBDCLNavigationAppState (T_e8_BDCLNavigationAppState BDCLNavigationAppState_);

    // API of field "BDCLNaviTurnType"

    static const int kBDCLNaviTurnType = 1;

    /**
     * Clears the field "BDCLNaviTurnType".
     *
     * The field will be set to its default value. The hasBDCLNaviTurnType()
     * method will return false.
     */
    inline void clearBDCLNaviTurnType();

    /**
     * Checks whether the field "BDCLNaviTurnType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDCLNaviTurnType()). Otherwise it will return false.
     */
    inline bool hasBDCLNaviTurnType () const;

    /**
     * Returns the value of the member "BDCLNaviTurnType".
     *
     * Indicates the turn direction
     *
     * @return The value of the field "BDCLNaviTurnType"
     */
    inline T_e8_BDCLNextTurnType getBDCLNaviTurnType () const;

    /**
     * Sets the value of the member "BDCLNaviTurnType".
     *
     * Indicates the turn direction
     *
     * @param BDCLNaviTurnType The value which will be set
     */
    inline void setBDCLNaviTurnType (T_e8_BDCLNextTurnType BDCLNaviTurnType_);

    // API of field "RoadName"

    static const int kRoadName = 2;

    /**
     * Clears the field "RoadName".
     *
     * The field will be set to its default value. The hasRoadName()
     * method will return false.
     */
    inline void clearRoadName();

    /**
     * Checks whether the field "RoadName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoadName()). Otherwise it will return false.
     */
    inline bool hasRoadName () const;

    /**
     * Returns the value of the member "RoadName".
     *
     * Indicates the next turn road name
     *
     * @return The value of the field "RoadName"
     */
    inline const ::std::string& getRoadName () const;

    /**
     * Retrieves the value of the field "RoadName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RoadName".
     */
    inline ::std::string& getRoadNameMutable ();

    /**
     * Sets the value of the member "RoadName".
     *
     * Indicates the next turn road name
     *
     * @param RoadName The value which will be set
     */
    inline void setRoadName (const ::std::string& RoadName_);

    /**
     * Sets the value of the member "RoadName".
     *
     * Indicates the next turn road name
     *
     * @param RoadName The value which will be set
     */
    inline void setRoadName (const char* RoadName_);

    /**
     * Sets the value of the member "RoadName".
     *
     * Indicates the next turn road name
     *
     * @param RoadName The value which will be set
     */
    inline void setRoadName (const char* value, size_t size);

    // API of field "TotalDistance"

    static const int kTotalDistance = 3;

    /**
     * Clears the field "TotalDistance".
     *
     * The field will be set to its default value. The hasTotalDistance()
     * method will return false.
     */
    inline void clearTotalDistance();

    /**
     * Checks whether the field "TotalDistance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTotalDistance()). Otherwise it will return false.
     */
    inline bool hasTotalDistance () const;

    /**
     * Returns the value of the member "TotalDistance".
     *
     * Total Distance to next turn, in meters.
     *
     * @return The value of the field "TotalDistance"
     */
    inline uint32 getTotalDistance () const;

    /**
     * Sets the value of the member "TotalDistance".
     *
     * Total Distance to next turn, in meters.
     *
     * @param TotalDistance The value which will be set
     */
    inline void setTotalDistance (uint32 TotalDistance_);

    // API of field "RemainDistance"

    static const int kRemainDistance = 4;

    /**
     * Clears the field "RemainDistance".
     *
     * The field will be set to its default value. The hasRemainDistance()
     * method will return false.
     */
    inline void clearRemainDistance();

    /**
     * Checks whether the field "RemainDistance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemainDistance()). Otherwise it will return false.
     */
    inline bool hasRemainDistance () const;

    /**
     * Returns the value of the member "RemainDistance".
     *
     * Remaining distance to next turn, in meters.
     *
     * @return The value of the field "RemainDistance"
     */
    inline uint32 getRemainDistance () const;

    /**
     * Sets the value of the member "RemainDistance".
     *
     * Remaining distance to next turn, in meters.
     *
     * @param RemainDistance The value which will be set
     */
    inline void setRemainDistance (uint32 RemainDistance_);

    // API of field "TurnIconData"

    static const int kTurnIconData = 5;

    /**
     * Clears the field "TurnIconData".
     *
     * The field will be set to its default value. The hasTurnIconData()
     * method will return false.
     */
    inline void clearTurnIconData();

    /**
     * Checks whether the field "TurnIconData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTurnIconData()). Otherwise it will return false.
     */
    inline bool hasTurnIconData () const;

    /**
     * Returns the value of the member "TurnIconData".
     *
     * Image data in bmp format. If its size is zero, Image data is invalid.
     *
     * @return The value of the field "TurnIconData"
     */
    inline const ::std::vector< uint8 >& getTurnIconData () const;

    /**
     * Retrieves the value of the field "TurnIconData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TurnIconData".
     */
    inline ::std::vector< uint8 >& getTurnIconDataMutable ();

    /**
     * Sets the value of the member "TurnIconData".
     *
     * Image data in bmp format. If its size is zero, Image data is invalid.
     *
     * @param TurnIconData The value which will be set
     */
    inline void setTurnIconData (const ::std::vector< uint8 >& TurnIconData_);

    static const T_CarlifeNaviNextTurnInfo &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_BDCLNavigationAppState ();

    inline void clear_has_BDCLNavigationAppState ();

    inline void set_has_BDCLNaviTurnType ();

    inline void clear_has_BDCLNaviTurnType ();

    inline void set_has_RoadName ();

    inline void clear_has_RoadName ();

    inline void set_has_TotalDistance ();

    inline void clear_has_TotalDistance ();

    inline void set_has_RemainDistance ();

    inline void clear_has_RemainDistance ();

    inline void set_has_TurnIconData ();

    inline void clear_has_TurnIconData ();

    uint32 _has_bits_[ (6 + 31) / 32];

    T_e8_BDCLNavigationAppState _BDCLNavigationAppState;

    T_e8_BDCLNextTurnType _BDCLNaviTurnType;

    ::std::string _RoadName;

    uint32 _TotalDistance;

    uint32 _RemainDistance;

    ::std::vector< uint8 > _TurnIconData;

};

/**
 * Scope: BDCL
 * Updates Turn-By-Turn Projection Navigation Information to the client.
 */
class T_CarlifeNaviAssistantGuideInfo {
public:

    /**
     * Default constructor
     */
    inline  T_CarlifeNaviAssistantGuideInfo ();

    /**
     * Copy constructor
     */
    inline  T_CarlifeNaviAssistantGuideInfo (const T_CarlifeNaviAssistantGuideInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_CarlifeNaviAssistantGuideInfo (T_e8_BDCLNavigationAppState BDCLAssistantGuideAppState_, T_e8_BDCLAssistantType AssistantType_, T_e8_BDCLTrafficSignType TrafficSignType_, uint32 TotalDistance_, uint32 RemainDistance_, uint32 CameraSpeed_);

    /**
     * Destructor
     */
    inline  ~T_CarlifeNaviAssistantGuideInfo();

    /**
     * Assignment operator
     */
    inline T_CarlifeNaviAssistantGuideInfo& operator = (const T_CarlifeNaviAssistantGuideInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CarlifeNaviAssistantGuideInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CarlifeNaviAssistantGuideInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CarlifeNaviAssistantGuideInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CarlifeNaviAssistantGuideInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BDCLAssistantGuideAppState"

    static const int kBDCLAssistantGuideAppState = 0;

    /**
     * Clears the field "BDCLAssistantGuideAppState".
     *
     * The field will be set to its default value. The hasBDCLAssistantGuideAppState()
     * method will return false.
     */
    inline void clearBDCLAssistantGuideAppState();

    /**
     * Checks whether the field "BDCLAssistantGuideAppState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDCLAssistantGuideAppState()). Otherwise it will return false.
     */
    inline bool hasBDCLAssistantGuideAppState () const;

    /**
     * Returns the value of the member "BDCLAssistantGuideAppState".
     *
     * Baidu Carlife Projection Navigation Status Information.
     *
     * @return The value of the field "BDCLAssistantGuideAppState"
     */
    inline T_e8_BDCLNavigationAppState getBDCLAssistantGuideAppState () const;

    /**
     * Sets the value of the member "BDCLAssistantGuideAppState".
     *
     * Baidu Carlife Projection Navigation Status Information.
     *
     * @param BDCLAssistantGuideAppState The value which will be set
     */
    inline void setBDCLAssistantGuideAppState (T_e8_BDCLNavigationAppState BDCLAssistantGuideAppState_);

    // API of field "AssistantType"

    static const int kAssistantType = 1;

    /**
     * Clears the field "AssistantType".
     *
     * The field will be set to its default value. The hasAssistantType()
     * method will return false.
     */
    inline void clearAssistantType();

    /**
     * Checks whether the field "AssistantType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAssistantType()). Otherwise it will return false.
     */
    inline bool hasAssistantType () const;

    /**
     * Returns the value of the member "AssistantType".
     *
     * Assistant navigation prompt type, it is an enumerated value.
     *
     * @return The value of the field "AssistantType"
     */
    inline T_e8_BDCLAssistantType getAssistantType () const;

    /**
     * Sets the value of the member "AssistantType".
     *
     * Assistant navigation prompt type, it is an enumerated value.
     *
     * @param AssistantType The value which will be set
     */
    inline void setAssistantType (T_e8_BDCLAssistantType AssistantType_);

    // API of field "TrafficSignType"

    static const int kTrafficSignType = 2;

    /**
     * Clears the field "TrafficSignType".
     *
     * The field will be set to its default value. The hasTrafficSignType()
     * method will return false.
     */
    inline void clearTrafficSignType();

    /**
     * Checks whether the field "TrafficSignType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrafficSignType()). Otherwise it will return false.
     */
    inline bool hasTrafficSignType () const;

    /**
     * Returns the value of the member "TrafficSignType".
     *
     * Traffic sign prompt, it is an enumerated value. When AssistantType is BDCL_ASSISTANT_TYPE_TRAFFICSIGN, this type will be valid.(reserved field, not adopted temporarily, default value as 0)
     *
     * @return The value of the field "TrafficSignType"
     */
    inline T_e8_BDCLTrafficSignType getTrafficSignType () const;

    /**
     * Sets the value of the member "TrafficSignType".
     *
     * Traffic sign prompt, it is an enumerated value. When AssistantType is BDCL_ASSISTANT_TYPE_TRAFFICSIGN, this type will be valid.(reserved field, not adopted temporarily, default value as 0)
     *
     * @param TrafficSignType The value which will be set
     */
    inline void setTrafficSignType (T_e8_BDCLTrafficSignType TrafficSignType_);

    // API of field "TotalDistance"

    static const int kTotalDistance = 3;

    /**
     * Clears the field "TotalDistance".
     *
     * The field will be set to its default value. The hasTotalDistance()
     * method will return false.
     */
    inline void clearTotalDistance();

    /**
     * Checks whether the field "TotalDistance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTotalDistance()). Otherwise it will return false.
     */
    inline bool hasTotalDistance () const;

    /**
     * Returns the value of the member "TotalDistance".
     *
     * Total distance to next navigation prompt, in meters.
     *
     * @return The value of the field "TotalDistance"
     */
    inline uint32 getTotalDistance () const;

    /**
     * Sets the value of the member "TotalDistance".
     *
     * Total distance to next navigation prompt, in meters.
     *
     * @param TotalDistance The value which will be set
     */
    inline void setTotalDistance (uint32 TotalDistance_);

    // API of field "RemainDistance"

    static const int kRemainDistance = 4;

    /**
     * Clears the field "RemainDistance".
     *
     * The field will be set to its default value. The hasRemainDistance()
     * method will return false.
     */
    inline void clearRemainDistance();

    /**
     * Checks whether the field "RemainDistance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemainDistance()). Otherwise it will return false.
     */
    inline bool hasRemainDistance () const;

    /**
     * Returns the value of the member "RemainDistance".
     *
     * Remain distance to next prompt, in meters.
     *
     * @return The value of the field "RemainDistance"
     */
    inline uint32 getRemainDistance () const;

    /**
     * Sets the value of the member "RemainDistance".
     *
     * Remain distance to next prompt, in meters.
     *
     * @param RemainDistance The value which will be set
     */
    inline void setRemainDistance (uint32 RemainDistance_);

    // API of field "CameraSpeed"

    static const int kCameraSpeed = 5;

    /**
     * Clears the field "CameraSpeed".
     *
     * The field will be set to its default value. The hasCameraSpeed()
     * method will return false.
     */
    inline void clearCameraSpeed();

    /**
     * Checks whether the field "CameraSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCameraSpeed()). Otherwise it will return false.
     */
    inline bool hasCameraSpeed () const;

    /**
     * Returns the value of the member "CameraSpeed".
     *
     * Speed-test camera's limit speed value, in meters per second, only valid when AssistantType is BDCL_ASSISTANT_TYPE_SPEEDCAMERA.
     *
     * @return The value of the field "CameraSpeed"
     */
    inline uint32 getCameraSpeed () const;

    /**
     * Sets the value of the member "CameraSpeed".
     *
     * Speed-test camera's limit speed value, in meters per second, only valid when AssistantType is BDCL_ASSISTANT_TYPE_SPEEDCAMERA.
     *
     * @param CameraSpeed The value which will be set
     */
    inline void setCameraSpeed (uint32 CameraSpeed_);

    static const T_CarlifeNaviAssistantGuideInfo &getDefaultInstance();

private:

    inline void set_has_BDCLAssistantGuideAppState ();

    inline void clear_has_BDCLAssistantGuideAppState ();

    inline void set_has_AssistantType ();

    inline void clear_has_AssistantType ();

    inline void set_has_TrafficSignType ();

    inline void clear_has_TrafficSignType ();

    inline void set_has_TotalDistance ();

    inline void clear_has_TotalDistance ();

    inline void set_has_RemainDistance ();

    inline void clear_has_RemainDistance ();

    inline void set_has_CameraSpeed ();

    inline void clear_has_CameraSpeed ();

    uint32 _has_bits_[ (6 + 31) / 32];

    T_e8_BDCLNavigationAppState _BDCLAssistantGuideAppState;

    T_e8_BDCLAssistantType _AssistantType;

    T_e8_BDCLTrafficSignType _TrafficSignType;

    uint32 _TotalDistance;

    uint32 _RemainDistance;

    uint32 _CameraSpeed;

};

/**
 * Skeleton of T_BDCLTBTUpdate
 */
class T_BDCLTBTUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_BDCLTBTUpdate ();

    /**
     * Copy constructor
     */
    inline  T_BDCLTBTUpdate (const T_BDCLTBTUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_BDCLTBTUpdate (const T_CarlifeNaviNextTurnInfo& CarlifeNaviNextTurnInfo_, bool isCarlifeNaviNextTurnInfoValid_, const T_CarlifeNaviAssistantGuideInfo& CarlifeNaviAssistantGuideInfo_, bool isCarlifeNaviAssistantGuideInfoValid_);

    /**
     * Destructor
     */
    inline  ~T_BDCLTBTUpdate();

    /**
     * Assignment operator
     */
    inline T_BDCLTBTUpdate& operator = (const T_BDCLTBTUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BDCLTBTUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BDCLTBTUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BDCLTBTUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BDCLTBTUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CarlifeNaviNextTurnInfo"

    static const int kCarlifeNaviNextTurnInfo = 0;

    /**
     * Clears the field "CarlifeNaviNextTurnInfo".
     *
     * The field will be set to its default value. The hasCarlifeNaviNextTurnInfo()
     * method will return false.
     */
    inline void clearCarlifeNaviNextTurnInfo();

    /**
     * Checks whether the field "CarlifeNaviNextTurnInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarlifeNaviNextTurnInfo()). Otherwise it will return false.
     */
    inline bool hasCarlifeNaviNextTurnInfo () const;

    /**
     * Returns the value of the member "CarlifeNaviNextTurnInfo".
     *
     * Structure Containing CarlifeNaviNextTurnInfo info.
     *
     * @return The value of the field "CarlifeNaviNextTurnInfo"
     */
    inline const T_CarlifeNaviNextTurnInfo& getCarlifeNaviNextTurnInfo () const;

    /**
     * Retrieves the value of the field "CarlifeNaviNextTurnInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CarlifeNaviNextTurnInfo".
     */
    inline T_CarlifeNaviNextTurnInfo& getCarlifeNaviNextTurnInfoMutable ();

    /**
     * Sets the value of the member "CarlifeNaviNextTurnInfo".
     *
     * Structure Containing CarlifeNaviNextTurnInfo info.
     *
     * @param CarlifeNaviNextTurnInfo The value which will be set
     */
    inline void setCarlifeNaviNextTurnInfo (const T_CarlifeNaviNextTurnInfo& CarlifeNaviNextTurnInfo_);

    // API of field "isCarlifeNaviNextTurnInfoValid"

    static const int kIsCarlifeNaviNextTurnInfoValid = 1;

    /**
     * Clears the field "isCarlifeNaviNextTurnInfoValid".
     *
     * The field will be set to its default value. The hasIsCarlifeNaviNextTurnInfoValid()
     * method will return false.
     */
    inline void clearIsCarlifeNaviNextTurnInfoValid();

    /**
     * Checks whether the field "isCarlifeNaviNextTurnInfoValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsCarlifeNaviNextTurnInfoValid()). Otherwise it will return false.
     */
    inline bool hasIsCarlifeNaviNextTurnInfoValid () const;

    /**
     * Returns the value of the member "isCarlifeNaviNextTurnInfoValid".
     *
     * Client must use CarlifeNaviNextTurnInfo only if it is true.
     *
     * @return The value of the field "isCarlifeNaviNextTurnInfoValid"
     */
    inline bool getIsCarlifeNaviNextTurnInfoValid () const;

    /**
     * Sets the value of the member "isCarlifeNaviNextTurnInfoValid".
     *
     * Client must use CarlifeNaviNextTurnInfo only if it is true.
     *
     * @param isCarlifeNaviNextTurnInfoValid The value which will be set
     */
    inline void setIsCarlifeNaviNextTurnInfoValid (bool isCarlifeNaviNextTurnInfoValid_);

    // API of field "CarlifeNaviAssistantGuideInfo"

    static const int kCarlifeNaviAssistantGuideInfo = 2;

    /**
     * Clears the field "CarlifeNaviAssistantGuideInfo".
     *
     * The field will be set to its default value. The hasCarlifeNaviAssistantGuideInfo()
     * method will return false.
     */
    inline void clearCarlifeNaviAssistantGuideInfo();

    /**
     * Checks whether the field "CarlifeNaviAssistantGuideInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarlifeNaviAssistantGuideInfo()). Otherwise it will return false.
     */
    inline bool hasCarlifeNaviAssistantGuideInfo () const;

    /**
     * Returns the value of the member "CarlifeNaviAssistantGuideInfo".
     *
     * Structure Containing CarlifeAssistantGuideInfo info.
     *
     * @return The value of the field "CarlifeNaviAssistantGuideInfo"
     */
    inline const T_CarlifeNaviAssistantGuideInfo& getCarlifeNaviAssistantGuideInfo () const;

    /**
     * Retrieves the value of the field "CarlifeNaviAssistantGuideInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CarlifeNaviAssistantGuideInfo".
     */
    inline T_CarlifeNaviAssistantGuideInfo& getCarlifeNaviAssistantGuideInfoMutable ();

    /**
     * Sets the value of the member "CarlifeNaviAssistantGuideInfo".
     *
     * Structure Containing CarlifeAssistantGuideInfo info.
     *
     * @param CarlifeNaviAssistantGuideInfo The value which will be set
     */
    inline void setCarlifeNaviAssistantGuideInfo (const T_CarlifeNaviAssistantGuideInfo& CarlifeNaviAssistantGuideInfo_);

    // API of field "isCarlifeNaviAssistantGuideInfoValid"

    static const int kIsCarlifeNaviAssistantGuideInfoValid = 3;

    /**
     * Clears the field "isCarlifeNaviAssistantGuideInfoValid".
     *
     * The field will be set to its default value. The hasIsCarlifeNaviAssistantGuideInfoValid()
     * method will return false.
     */
    inline void clearIsCarlifeNaviAssistantGuideInfoValid();

    /**
     * Checks whether the field "isCarlifeNaviAssistantGuideInfoValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsCarlifeNaviAssistantGuideInfoValid()). Otherwise it will return false.
     */
    inline bool hasIsCarlifeNaviAssistantGuideInfoValid () const;

    /**
     * Returns the value of the member "isCarlifeNaviAssistantGuideInfoValid".
     *
     * Client must use CarlifeNaviAssistantGuideInfo only if it is true.
     *
     * @return The value of the field "isCarlifeNaviAssistantGuideInfoValid"
     */
    inline bool getIsCarlifeNaviAssistantGuideInfoValid () const;

    /**
     * Sets the value of the member "isCarlifeNaviAssistantGuideInfoValid".
     *
     * Client must use CarlifeNaviAssistantGuideInfo only if it is true.
     *
     * @param isCarlifeNaviAssistantGuideInfoValid The value which will be set
     */
    inline void setIsCarlifeNaviAssistantGuideInfoValid (bool isCarlifeNaviAssistantGuideInfoValid_);

    static const T_BDCLTBTUpdate &getDefaultInstance();

private:

    inline void set_has_CarlifeNaviNextTurnInfo ();

    inline void clear_has_CarlifeNaviNextTurnInfo ();

    inline void set_has_isCarlifeNaviNextTurnInfoValid ();

    inline void clear_has_isCarlifeNaviNextTurnInfoValid ();

    inline void set_has_CarlifeNaviAssistantGuideInfo ();

    inline void clear_has_CarlifeNaviAssistantGuideInfo ();

    inline void set_has_isCarlifeNaviAssistantGuideInfoValid ();

    inline void clear_has_isCarlifeNaviAssistantGuideInfoValid ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_CarlifeNaviNextTurnInfo _CarlifeNaviNextTurnInfo;

    bool _isCarlifeNaviNextTurnInfoValid;

    T_CarlifeNaviAssistantGuideInfo _CarlifeNaviAssistantGuideInfo;

    bool _isCarlifeNaviAssistantGuideInfoValid;

};

/**
 * This structure provides projection video attributes
 */
class T_ProjectionVideoAttributes {
public:

    /**
     * Default constructor
     */
    inline  T_ProjectionVideoAttributes ();

    /**
     * Copy constructor
     */
    inline  T_ProjectionVideoAttributes (const T_ProjectionVideoAttributes &rhs);

    /**
     * All fields constructor
     */
    inline  T_ProjectionVideoAttributes (uint16 u16UIResolutionHeight_, uint16 u16UIResolutionWidth_);

    /**
     * Destructor
     */
    inline  ~T_ProjectionVideoAttributes();

    /**
     * Assignment operator
     */
    inline T_ProjectionVideoAttributes& operator = (const T_ProjectionVideoAttributes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ProjectionVideoAttributes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ProjectionVideoAttributes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ProjectionVideoAttributes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ProjectionVideoAttributes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16UIResolutionHeight"

    static const int kU16UIResolutionHeight = 0;

    /**
     * Clears the field "u16UIResolutionHeight".
     *
     * The field will be set to its default value. The hasU16UIResolutionHeight()
     * method will return false.
     */
    inline void clearU16UIResolutionHeight();

    /**
     * Checks whether the field "u16UIResolutionHeight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UIResolutionHeight()). Otherwise it will return false.
     */
    inline bool hasU16UIResolutionHeight () const;

    /**
     * Returns the value of the member "u16UIResolutionHeight".
     *
     * Information about the Height of the screen (in pixels) in which projection UI is being rendered
     *
     * @return The value of the field "u16UIResolutionHeight"
     */
    inline uint16 getU16UIResolutionHeight () const;

    /**
     * Sets the value of the member "u16UIResolutionHeight".
     *
     * Information about the Height of the screen (in pixels) in which projection UI is being rendered
     *
     * @param u16UIResolutionHeight The value which will be set
     */
    inline void setU16UIResolutionHeight (uint16 u16UIResolutionHeight_);

    // API of field "u16UIResolutionWidth"

    static const int kU16UIResolutionWidth = 1;

    /**
     * Clears the field "u16UIResolutionWidth".
     *
     * The field will be set to its default value. The hasU16UIResolutionWidth()
     * method will return false.
     */
    inline void clearU16UIResolutionWidth();

    /**
     * Checks whether the field "u16UIResolutionWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UIResolutionWidth()). Otherwise it will return false.
     */
    inline bool hasU16UIResolutionWidth () const;

    /**
     * Returns the value of the member "u16UIResolutionWidth".
     *
     * Information about the Height of the screen (in pixels) in which projection UI is being rendered
     *
     * @return The value of the field "u16UIResolutionWidth"
     */
    inline uint16 getU16UIResolutionWidth () const;

    /**
     * Sets the value of the member "u16UIResolutionWidth".
     *
     * Information about the Height of the screen (in pixels) in which projection UI is being rendered
     *
     * @param u16UIResolutionWidth The value which will be set
     */
    inline void setU16UIResolutionWidth (uint16 u16UIResolutionWidth_);

    static const T_ProjectionVideoAttributes &getDefaultInstance();

private:

    inline void set_has_u16UIResolutionHeight ();

    inline void clear_has_u16UIResolutionHeight ();

    inline void set_has_u16UIResolutionWidth ();

    inline void clear_has_u16UIResolutionWidth ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16UIResolutionHeight;

    uint16 _u16UIResolutionWidth;

};

/**
 * Skeleton of T_MLNavigationInfoUpdate.
 */
class T_MLNavigationInfoUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_MLNavigationInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  T_MLNavigationInfoUpdate (const T_MLNavigationInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_MLNavigationInfoUpdate (const ::std::string& NavAppName_, T_e8_MLGuidanceState GuidanceState_, T_e8_MLGuidanceActive GuidanceActive_, bool MetricSystem_, bool RightDriving_);

    /**
     * Destructor
     */
    inline  ~T_MLNavigationInfoUpdate();

    /**
     * Assignment operator
     */
    inline T_MLNavigationInfoUpdate& operator = (const T_MLNavigationInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MLNavigationInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MLNavigationInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MLNavigationInfoUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MLNavigationInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NavAppName"

    static const int kNavAppName = 0;

    /**
     * Clears the field "NavAppName".
     *
     * The field will be set to its default value. The hasNavAppName()
     * method will return false.
     */
    inline void clearNavAppName();

    /**
     * Checks whether the field "NavAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNavAppName()). Otherwise it will return false.
     */
    inline bool hasNavAppName () const;

    /**
     * Returns the value of the member "NavAppName".
     *
     * Application Name of Navigation App
     *
     * @return The value of the field "NavAppName"
     */
    inline const ::std::string& getNavAppName () const;

    /**
     * Retrieves the value of the field "NavAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NavAppName".
     */
    inline ::std::string& getNavAppNameMutable ();

    /**
     * Sets the value of the member "NavAppName".
     *
     * Application Name of Navigation App
     *
     * @param NavAppName The value which will be set
     */
    inline void setNavAppName (const ::std::string& NavAppName_);

    /**
     * Sets the value of the member "NavAppName".
     *
     * Application Name of Navigation App
     *
     * @param NavAppName The value which will be set
     */
    inline void setNavAppName (const char* NavAppName_);

    /**
     * Sets the value of the member "NavAppName".
     *
     * Application Name of Navigation App
     *
     * @param NavAppName The value which will be set
     */
    inline void setNavAppName (const char* value, size_t size);

    // API of field "GuidanceState"

    static const int kGuidanceState = 1;

    /**
     * Clears the field "GuidanceState".
     *
     * The field will be set to its default value. The hasGuidanceState()
     * method will return false.
     */
    inline void clearGuidanceState();

    /**
     * Checks whether the field "GuidanceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGuidanceState()). Otherwise it will return false.
     */
    inline bool hasGuidanceState () const;

    /**
     * Returns the value of the member "GuidanceState".
     *
     * Informs Navigation route guidance possible statuses.
     *
     * @return The value of the field "GuidanceState"
     */
    inline T_e8_MLGuidanceState getGuidanceState () const;

    /**
     * Sets the value of the member "GuidanceState".
     *
     * Informs Navigation route guidance possible statuses.
     *
     * @param GuidanceState The value which will be set
     */
    inline void setGuidanceState (T_e8_MLGuidanceState GuidanceState_);

    // API of field "GuidanceActive"

    static const int kGuidanceActive = 2;

    /**
     * Clears the field "GuidanceActive".
     *
     * The field will be set to its default value. The hasGuidanceActive()
     * method will return false.
     */
    inline void clearGuidanceActive();

    /**
     * Checks whether the field "GuidanceActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGuidanceActive()). Otherwise it will return false.
     */
    inline bool hasGuidanceActive () const;

    /**
     * Returns the value of the member "GuidanceActive".
     *
     * Informs Navigation route guidance active possible statuses.
     *
     * @return The value of the field "GuidanceActive"
     */
    inline T_e8_MLGuidanceActive getGuidanceActive () const;

    /**
     * Sets the value of the member "GuidanceActive".
     *
     * Informs Navigation route guidance active possible statuses.
     *
     * @param GuidanceActive The value which will be set
     */
    inline void setGuidanceActive (T_e8_MLGuidanceActive GuidanceActive_);

    // API of field "MetricSystem"

    static const int kMetricSystem = 3;

    /**
     * Clears the field "MetricSystem".
     *
     * The field will be set to its default value. The hasMetricSystem()
     * method will return false.
     */
    inline void clearMetricSystem();

    /**
     * Checks whether the field "MetricSystem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMetricSystem()). Otherwise it will return false.
     */
    inline bool hasMetricSystem () const;

    /**
     * Returns the value of the member "MetricSystem".
     *
     * Value defines, whether all distance and speed values are represented in metric (true) or non-metric (false) system.
     *
     * @return The value of the field "MetricSystem"
     */
    inline bool getMetricSystem () const;

    /**
     * Sets the value of the member "MetricSystem".
     *
     * Value defines, whether all distance and speed values are represented in metric (true) or non-metric (false) system.
     *
     * @param MetricSystem The value which will be set
     */
    inline void setMetricSystem (bool MetricSystem_);

    // API of field "RightDriving"

    static const int kRightDriving = 4;

    /**
     * Clears the field "RightDriving".
     *
     * The field will be set to its default value. The hasRightDriving()
     * method will return false.
     */
    inline void clearRightDriving();

    /**
     * Checks whether the field "RightDriving" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRightDriving()). Otherwise it will return false.
     */
    inline bool hasRightDriving () const;

    /**
     * Returns the value of the member "RightDriving".
     *
     * Value defines, whether vehicles are driving on the right side of the road (true) or the left side of the road (false).
     *
     * @return The value of the field "RightDriving"
     */
    inline bool getRightDriving () const;

    /**
     * Sets the value of the member "RightDriving".
     *
     * Value defines, whether vehicles are driving on the right side of the road (true) or the left side of the road (false).
     *
     * @param RightDriving The value which will be set
     */
    inline void setRightDriving (bool RightDriving_);

    static const T_MLNavigationInfoUpdate &getDefaultInstance();

private:

    inline void set_has_NavAppName ();

    inline void clear_has_NavAppName ();

    inline void set_has_GuidanceState ();

    inline void clear_has_GuidanceState ();

    inline void set_has_GuidanceActive ();

    inline void clear_has_GuidanceActive ();

    inline void set_has_MetricSystem ();

    inline void clear_has_MetricSystem ();

    inline void set_has_RightDriving ();

    inline void clear_has_RightDriving ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _NavAppName;

    T_e8_MLGuidanceState _GuidanceState;

    T_e8_MLGuidanceActive _GuidanceActive;

    bool _MetricSystem;

    bool _RightDriving;

};

/**
 * Skeleton of T_MLNavigationNextManeuverUpdate.
 */
class T_MLNavigationNextManeuverUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_MLNavigationNextManeuverUpdate ();

    /**
     * Copy constructor
     */
    inline  T_MLNavigationNextManeuverUpdate (const T_MLNavigationNextManeuverUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_MLNavigationNextManeuverUpdate (T_e8_MLNextDirection NextDirection_, uint32 NextManeuverIndex_, uint32 NextAngle_, const ::std::vector< uint32 >& NextSideStreetAngles_1_, const ::std::vector< uint32 >& NextSideStreetAngles_2_, const ::std::vector< uint32 >& NextSideStreetAngles_3_, const ::std::string& NextStreetName_, const ::std::string& CurrentStreetName_, uint32 NumOfSideStreetAngles_1_, uint32 NumOfSideStreetAngles_2_, uint32 NumOfSideStreetAngles_3_);

    /**
     * Destructor
     */
    inline  ~T_MLNavigationNextManeuverUpdate();

    /**
     * Assignment operator
     */
    inline T_MLNavigationNextManeuverUpdate& operator = (const T_MLNavigationNextManeuverUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MLNavigationNextManeuverUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MLNavigationNextManeuverUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MLNavigationNextManeuverUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MLNavigationNextManeuverUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NextDirection"

    static const int kNextDirection = 0;

    /**
     * Clears the field "NextDirection".
     *
     * The field will be set to its default value. The hasNextDirection()
     * method will return false.
     */
    inline void clearNextDirection();

    /**
     * Checks whether the field "NextDirection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextDirection()). Otherwise it will return false.
     */
    inline bool hasNextDirection () const;

    /**
     * Returns the value of the member "NextDirection".
     *
     * Informs about Next maneuver direction.
     *
     * @return The value of the field "NextDirection"
     */
    inline T_e8_MLNextDirection getNextDirection () const;

    /**
     * Sets the value of the member "NextDirection".
     *
     * Informs about Next maneuver direction.
     *
     * @param NextDirection The value which will be set
     */
    inline void setNextDirection (T_e8_MLNextDirection NextDirection_);

    // API of field "NextManeuverIndex"

    static const int kNextManeuverIndex = 1;

    /**
     * Clears the field "NextManeuverIndex".
     *
     * The field will be set to its default value. The hasNextManeuverIndex()
     * method will return false.
     */
    inline void clearNextManeuverIndex();

    /**
     * Checks whether the field "NextManeuverIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextManeuverIndex()). Otherwise it will return false.
     */
    inline bool hasNextManeuverIndex () const;

    /**
     * Returns the value of the member "NextManeuverIndex".
     *
     * Details selected guidance instances; used in case nextDirection has one of the following values:
     * - ROUNDABOUT_RIGHT_KNOWN_EXIT_NUMBER (mandatory), indicating the known exit number.
     * - ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER (mandatory), indicating the known exit number.
     * - INTERMEDIATE_DESTINATION to INTERMEDIATE_DESTINATION_ON_THE_LEFT (optional), indicating the specific intermediate destination.
     * Value shall be >0.
     *
     * @return The value of the field "NextManeuverIndex"
     */
    inline uint32 getNextManeuverIndex () const;

    /**
     * Sets the value of the member "NextManeuverIndex".
     *
     * Details selected guidance instances; used in case nextDirection has one of the following values:
     * - ROUNDABOUT_RIGHT_KNOWN_EXIT_NUMBER (mandatory), indicating the known exit number.
     * - ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER (mandatory), indicating the known exit number.
     * - INTERMEDIATE_DESTINATION to INTERMEDIATE_DESTINATION_ON_THE_LEFT (optional), indicating the specific intermediate destination.
     * Value shall be >0.
     *
     * @param NextManeuverIndex The value which will be set
     */
    inline void setNextManeuverIndex (uint32 NextManeuverIndex_);

    // API of field "NextAngle"

    static const int kNextAngle = 2;

    /**
     * Clears the field "NextAngle".
     *
     * The field will be set to its default value. The hasNextAngle()
     * method will return false.
     */
    inline void clearNextAngle();

    /**
     * Checks whether the field "NextAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextAngle()). Otherwise it will return false.
     */
    inline bool hasNextAngle () const;

    /**
     * Returns the value of the member "NextAngle".
     *
     * Represents the clock-wise (turn) angle; used in case nextDirection has one of the following values:
     * - TURN_STRAIGHT to HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT (optional)
     * - COMPASS (mandatory)
     * - DIRECTION_TO_DESTINATION (mandatory)
     * - ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER to ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER (mandatory)
     * A value of -1 shall be used, if an angle is not available. @unit degrees, @range [0 .. 360]
     *
     * @return The value of the field "NextAngle"
     */
    inline uint32 getNextAngle () const;

    /**
     * Sets the value of the member "NextAngle".
     *
     * Represents the clock-wise (turn) angle; used in case nextDirection has one of the following values:
     * - TURN_STRAIGHT to HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT (optional)
     * - COMPASS (mandatory)
     * - DIRECTION_TO_DESTINATION (mandatory)
     * - ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER to ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER (mandatory)
     * A value of -1 shall be used, if an angle is not available. @unit degrees, @range [0 .. 360]
     *
     * @param NextAngle The value which will be set
     */
    inline void setNextAngle (uint32 NextAngle_);

    // API of field "NextSideStreetAngles_1"

    static const int kNextSideStreetAngles_1 = 3;

    /**
     * Clears the field "NextSideStreetAngles_1".
     *
     * The field will be set to its default value. The hasNextSideStreetAngles_1()
     * method will return false.
     */
    inline void clearNextSideStreetAngles_1();

    /**
     * Checks whether the field "NextSideStreetAngles_1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextSideStreetAngles_1()). Otherwise it will return false.
     */
    inline bool hasNextSideStreetAngles_1 () const;

    /**
     * Returns the value of the member "NextSideStreetAngles_1".
     *
     * Array of side streets clock-wise angles at different turn positions; used in case nextDirection has one of the following values:
     * - TURN_STRAIGHT to HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT (optional)
     * - ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER to ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER (optional)
     * The number of items will be defined in maxSideStreetAngles_1.
     * @unit, @range [0 .. 360]
     *
     * @return The value of the field "NextSideStreetAngles_1"
     */
    inline const ::std::vector< uint32 >& getNextSideStreetAngles_1 () const;

    /**
     * Retrieves the value of the field "NextSideStreetAngles_1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NextSideStreetAngles_1".
     */
    inline ::std::vector< uint32 >& getNextSideStreetAngles_1Mutable ();

    /**
     * Sets the value of the member "NextSideStreetAngles_1".
     *
     * Array of side streets clock-wise angles at different turn positions; used in case nextDirection has one of the following values:
     * - TURN_STRAIGHT to HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT (optional)
     * - ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER to ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER (optional)
     * The number of items will be defined in maxSideStreetAngles_1.
     * @unit, @range [0 .. 360]
     *
     * @param NextSideStreetAngles_1 The value which will be set
     */
    inline void setNextSideStreetAngles_1 (const ::std::vector< uint32 >& NextSideStreetAngles_1_);

    // API of field "NextSideStreetAngles_2"

    static const int kNextSideStreetAngles_2 = 4;

    /**
     * Clears the field "NextSideStreetAngles_2".
     *
     * The field will be set to its default value. The hasNextSideStreetAngles_2()
     * method will return false.
     */
    inline void clearNextSideStreetAngles_2();

    /**
     * Checks whether the field "NextSideStreetAngles_2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextSideStreetAngles_2()). Otherwise it will return false.
     */
    inline bool hasNextSideStreetAngles_2 () const;

    /**
     * Returns the value of the member "NextSideStreetAngles_2".
     *
     * Array of side streets clock-wise angles at different turn positions; used in case nextDirection has one of the following values:
     * - TURN_STRAIGHT to HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT (optional)
     * - ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER to ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER (optional)
     * The number of items will be defined in maxSideStreetAngles_2.
     * @unit, @range [0 .. 360]
     *
     * @return The value of the field "NextSideStreetAngles_2"
     */
    inline const ::std::vector< uint32 >& getNextSideStreetAngles_2 () const;

    /**
     * Retrieves the value of the field "NextSideStreetAngles_2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NextSideStreetAngles_2".
     */
    inline ::std::vector< uint32 >& getNextSideStreetAngles_2Mutable ();

    /**
     * Sets the value of the member "NextSideStreetAngles_2".
     *
     * Array of side streets clock-wise angles at different turn positions; used in case nextDirection has one of the following values:
     * - TURN_STRAIGHT to HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT (optional)
     * - ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER to ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER (optional)
     * The number of items will be defined in maxSideStreetAngles_2.
     * @unit, @range [0 .. 360]
     *
     * @param NextSideStreetAngles_2 The value which will be set
     */
    inline void setNextSideStreetAngles_2 (const ::std::vector< uint32 >& NextSideStreetAngles_2_);

    // API of field "NextSideStreetAngles_3"

    static const int kNextSideStreetAngles_3 = 5;

    /**
     * Clears the field "NextSideStreetAngles_3".
     *
     * The field will be set to its default value. The hasNextSideStreetAngles_3()
     * method will return false.
     */
    inline void clearNextSideStreetAngles_3();

    /**
     * Checks whether the field "NextSideStreetAngles_3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextSideStreetAngles_3()). Otherwise it will return false.
     */
    inline bool hasNextSideStreetAngles_3 () const;

    /**
     * Returns the value of the member "NextSideStreetAngles_3".
     *
     * Array of side streets clock-wise angles at different turn positions; used in case nextDirection has one of the following values:
     * - TURN_STRAIGHT to HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT (optional)
     * - ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER to ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER (optional)
     * The number of items will be defined in maxSideStreetAngles_3.
     * @unit, @range [0 .. 360]
     *
     * @return The value of the field "NextSideStreetAngles_3"
     */
    inline const ::std::vector< uint32 >& getNextSideStreetAngles_3 () const;

    /**
     * Retrieves the value of the field "NextSideStreetAngles_3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NextSideStreetAngles_3".
     */
    inline ::std::vector< uint32 >& getNextSideStreetAngles_3Mutable ();

    /**
     * Sets the value of the member "NextSideStreetAngles_3".
     *
     * Array of side streets clock-wise angles at different turn positions; used in case nextDirection has one of the following values:
     * - TURN_STRAIGHT to HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT (optional)
     * - ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER to ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER (optional)
     * The number of items will be defined in maxSideStreetAngles_3.
     * @unit, @range [0 .. 360]
     *
     * @param NextSideStreetAngles_3 The value which will be set
     */
    inline void setNextSideStreetAngles_3 (const ::std::vector< uint32 >& NextSideStreetAngles_3_);

    // API of field "NextStreetName"

    static const int kNextStreetName = 6;

    /**
     * Clears the field "NextStreetName".
     *
     * The field will be set to its default value. The hasNextStreetName()
     * method will return false.
     */
    inline void clearNextStreetName();

    /**
     * Checks whether the field "NextStreetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextStreetName()). Otherwise it will return false.
     */
    inline bool hasNextStreetName () const;

    /**
     * Returns the value of the member "NextStreetName".
     *
     * Street name, where the next maneuver will happen.
     *
     * @return The value of the field "NextStreetName"
     */
    inline const ::std::string& getNextStreetName () const;

    /**
     * Retrieves the value of the field "NextStreetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NextStreetName".
     */
    inline ::std::string& getNextStreetNameMutable ();

    /**
     * Sets the value of the member "NextStreetName".
     *
     * Street name, where the next maneuver will happen.
     *
     * @param NextStreetName The value which will be set
     */
    inline void setNextStreetName (const ::std::string& NextStreetName_);

    /**
     * Sets the value of the member "NextStreetName".
     *
     * Street name, where the next maneuver will happen.
     *
     * @param NextStreetName The value which will be set
     */
    inline void setNextStreetName (const char* NextStreetName_);

    /**
     * Sets the value of the member "NextStreetName".
     *
     * Street name, where the next maneuver will happen.
     *
     * @param NextStreetName The value which will be set
     */
    inline void setNextStreetName (const char* value, size_t size);

    // API of field "CurrentStreetName"

    static const int kCurrentStreetName = 7;

    /**
     * Clears the field "CurrentStreetName".
     *
     * The field will be set to its default value. The hasCurrentStreetName()
     * method will return false.
     */
    inline void clearCurrentStreetName();

    /**
     * Checks whether the field "CurrentStreetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentStreetName()). Otherwise it will return false.
     */
    inline bool hasCurrentStreetName () const;

    /**
     * Returns the value of the member "CurrentStreetName".
     *
     * Street name, where the current maneuver will happen.
     *
     * @return The value of the field "CurrentStreetName"
     */
    inline const ::std::string& getCurrentStreetName () const;

    /**
     * Retrieves the value of the field "CurrentStreetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CurrentStreetName".
     */
    inline ::std::string& getCurrentStreetNameMutable ();

    /**
     * Sets the value of the member "CurrentStreetName".
     *
     * Street name, where the current maneuver will happen.
     *
     * @param CurrentStreetName The value which will be set
     */
    inline void setCurrentStreetName (const ::std::string& CurrentStreetName_);

    /**
     * Sets the value of the member "CurrentStreetName".
     *
     * Street name, where the current maneuver will happen.
     *
     * @param CurrentStreetName The value which will be set
     */
    inline void setCurrentStreetName (const char* CurrentStreetName_);

    /**
     * Sets the value of the member "CurrentStreetName".
     *
     * Street name, where the current maneuver will happen.
     *
     * @param CurrentStreetName The value which will be set
     */
    inline void setCurrentStreetName (const char* value, size_t size);

    // API of field "NumOfSideStreetAngles_1"

    static const int kNumOfSideStreetAngles_1 = 8;

    /**
     * Clears the field "NumOfSideStreetAngles_1".
     *
     * The field will be set to its default value. The hasNumOfSideStreetAngles_1()
     * method will return false.
     */
    inline void clearNumOfSideStreetAngles_1();

    /**
     * Checks whether the field "NumOfSideStreetAngles_1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumOfSideStreetAngles_1()). Otherwise it will return false.
     */
    inline bool hasNumOfSideStreetAngles_1 () const;

    /**
     * Returns the value of the member "NumOfSideStreetAngles_1".
     *
     * size of nextSideStreetAngles_1
     *
     * @return The value of the field "NumOfSideStreetAngles_1"
     */
    inline uint32 getNumOfSideStreetAngles_1 () const;

    /**
     * Sets the value of the member "NumOfSideStreetAngles_1".
     *
     * size of nextSideStreetAngles_1
     *
     * @param NumOfSideStreetAngles_1 The value which will be set
     */
    inline void setNumOfSideStreetAngles_1 (uint32 NumOfSideStreetAngles_1_);

    // API of field "NumOfSideStreetAngles_2"

    static const int kNumOfSideStreetAngles_2 = 9;

    /**
     * Clears the field "NumOfSideStreetAngles_2".
     *
     * The field will be set to its default value. The hasNumOfSideStreetAngles_2()
     * method will return false.
     */
    inline void clearNumOfSideStreetAngles_2();

    /**
     * Checks whether the field "NumOfSideStreetAngles_2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumOfSideStreetAngles_2()). Otherwise it will return false.
     */
    inline bool hasNumOfSideStreetAngles_2 () const;

    /**
     * Returns the value of the member "NumOfSideStreetAngles_2".
     *
     * size of nextSideStreetAngles_2
     *
     * @return The value of the field "NumOfSideStreetAngles_2"
     */
    inline uint32 getNumOfSideStreetAngles_2 () const;

    /**
     * Sets the value of the member "NumOfSideStreetAngles_2".
     *
     * size of nextSideStreetAngles_2
     *
     * @param NumOfSideStreetAngles_2 The value which will be set
     */
    inline void setNumOfSideStreetAngles_2 (uint32 NumOfSideStreetAngles_2_);

    // API of field "NumOfSideStreetAngles_3"

    static const int kNumOfSideStreetAngles_3 = 10;

    /**
     * Clears the field "NumOfSideStreetAngles_3".
     *
     * The field will be set to its default value. The hasNumOfSideStreetAngles_3()
     * method will return false.
     */
    inline void clearNumOfSideStreetAngles_3();

    /**
     * Checks whether the field "NumOfSideStreetAngles_3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumOfSideStreetAngles_3()). Otherwise it will return false.
     */
    inline bool hasNumOfSideStreetAngles_3 () const;

    /**
     * Returns the value of the member "NumOfSideStreetAngles_3".
     *
     * size of nextSideStreetAngles_3
     *
     * @return The value of the field "NumOfSideStreetAngles_3"
     */
    inline uint32 getNumOfSideStreetAngles_3 () const;

    /**
     * Sets the value of the member "NumOfSideStreetAngles_3".
     *
     * size of nextSideStreetAngles_3
     *
     * @param NumOfSideStreetAngles_3 The value which will be set
     */
    inline void setNumOfSideStreetAngles_3 (uint32 NumOfSideStreetAngles_3_);

    static const T_MLNavigationNextManeuverUpdate &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_NextDirection ();

    inline void clear_has_NextDirection ();

    inline void set_has_NextManeuverIndex ();

    inline void clear_has_NextManeuverIndex ();

    inline void set_has_NextAngle ();

    inline void clear_has_NextAngle ();

    inline void set_has_NextSideStreetAngles_1 ();

    inline void clear_has_NextSideStreetAngles_1 ();

    inline void set_has_NextSideStreetAngles_2 ();

    inline void clear_has_NextSideStreetAngles_2 ();

    inline void set_has_NextSideStreetAngles_3 ();

    inline void clear_has_NextSideStreetAngles_3 ();

    inline void set_has_NextStreetName ();

    inline void clear_has_NextStreetName ();

    inline void set_has_CurrentStreetName ();

    inline void clear_has_CurrentStreetName ();

    inline void set_has_NumOfSideStreetAngles_1 ();

    inline void clear_has_NumOfSideStreetAngles_1 ();

    inline void set_has_NumOfSideStreetAngles_2 ();

    inline void clear_has_NumOfSideStreetAngles_2 ();

    inline void set_has_NumOfSideStreetAngles_3 ();

    inline void clear_has_NumOfSideStreetAngles_3 ();

    uint32 _has_bits_[ (11 + 31) / 32];

    T_e8_MLNextDirection _NextDirection;

    uint32 _NextManeuverIndex;

    uint32 _NextAngle;

    ::std::vector< uint32 > _NextSideStreetAngles_1;

    ::std::vector< uint32 > _NextSideStreetAngles_2;

    ::std::vector< uint32 > _NextSideStreetAngles_3;

    ::std::string _NextStreetName;

    ::std::string _CurrentStreetName;

    uint32 _NumOfSideStreetAngles_1;

    uint32 _NumOfSideStreetAngles_2;

    uint32 _NumOfSideStreetAngles_3;

};

/**
 * Skeleton of T_MLSpeedLimitUpdate.
 */
class T_MLSpeedLimitUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_MLSpeedLimitUpdate ();

    /**
     * Copy constructor
     */
    inline  T_MLSpeedLimitUpdate (const T_MLSpeedLimitUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_MLSpeedLimitUpdate (uint32 CurrentSpeedLimit_, uint32 NextSpeedLimit_, uint32 Distance_, T_e8_DistanceUnit DistanceUnit_);

    /**
     * Destructor
     */
    inline  ~T_MLSpeedLimitUpdate();

    /**
     * Assignment operator
     */
    inline T_MLSpeedLimitUpdate& operator = (const T_MLSpeedLimitUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MLSpeedLimitUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MLSpeedLimitUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MLSpeedLimitUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MLSpeedLimitUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CurrentSpeedLimit"

    static const int kCurrentSpeedLimit = 0;

    /**
     * Clears the field "CurrentSpeedLimit".
     *
     * The field will be set to its default value. The hasCurrentSpeedLimit()
     * method will return false.
     */
    inline void clearCurrentSpeedLimit();

    /**
     * Checks whether the field "CurrentSpeedLimit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentSpeedLimit()). Otherwise it will return false.
     */
    inline bool hasCurrentSpeedLimit () const;

    /**
     * Returns the value of the member "CurrentSpeedLimit".
     *
     * Current speed limit.
     *
     * @return The value of the field "CurrentSpeedLimit"
     */
    inline uint32 getCurrentSpeedLimit () const;

    /**
     * Sets the value of the member "CurrentSpeedLimit".
     *
     * Current speed limit.
     *
     * @param CurrentSpeedLimit The value which will be set
     */
    inline void setCurrentSpeedLimit (uint32 CurrentSpeedLimit_);

    // API of field "NextSpeedLimit"

    static const int kNextSpeedLimit = 1;

    /**
     * Clears the field "NextSpeedLimit".
     *
     * The field will be set to its default value. The hasNextSpeedLimit()
     * method will return false.
     */
    inline void clearNextSpeedLimit();

    /**
     * Checks whether the field "NextSpeedLimit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextSpeedLimit()). Otherwise it will return false.
     */
    inline bool hasNextSpeedLimit () const;

    /**
     * Returns the value of the member "NextSpeedLimit".
     *
     * next speed limit.
     *
     * @return The value of the field "NextSpeedLimit"
     */
    inline uint32 getNextSpeedLimit () const;

    /**
     * Sets the value of the member "NextSpeedLimit".
     *
     * next speed limit.
     *
     * @param NextSpeedLimit The value which will be set
     */
    inline void setNextSpeedLimit (uint32 NextSpeedLimit_);

    // API of field "Distance"

    static const int kDistance = 2;

    /**
     * Clears the field "Distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "Distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "Distance".
     *
     * Distance, to when the next speed limit will become effective.
     *
     * @return The value of the field "Distance"
     */
    inline uint32 getDistance () const;

    /**
     * Sets the value of the member "Distance".
     *
     * Distance, to when the next speed limit will become effective.
     *
     * @param Distance The value which will be set
     */
    inline void setDistance (uint32 Distance_);

    // API of field "DistanceUnit"

    static const int kDistanceUnit = 3;

    /**
     * Clears the field "DistanceUnit".
     *
     * The field will be set to its default value. The hasDistanceUnit()
     * method will return false.
     */
    inline void clearDistanceUnit();

    /**
     * Checks whether the field "DistanceUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceUnit()). Otherwise it will return false.
     */
    inline bool hasDistanceUnit () const;

    /**
     * Returns the value of the member "DistanceUnit".
     *
     * Distance, to when the next speed limit will become effective.
     *
     * @return The value of the field "DistanceUnit"
     */
    inline T_e8_DistanceUnit getDistanceUnit () const;

    /**
     * Sets the value of the member "DistanceUnit".
     *
     * Distance, to when the next speed limit will become effective.
     *
     * @param DistanceUnit The value which will be set
     */
    inline void setDistanceUnit (T_e8_DistanceUnit DistanceUnit_);

    static const T_MLSpeedLimitUpdate &getDefaultInstance();

private:

    inline void set_has_CurrentSpeedLimit ();

    inline void clear_has_CurrentSpeedLimit ();

    inline void set_has_NextSpeedLimit ();

    inline void clear_has_NextSpeedLimit ();

    inline void set_has_Distance ();

    inline void clear_has_Distance ();

    inline void set_has_DistanceUnit ();

    inline void clear_has_DistanceUnit ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _CurrentSpeedLimit;

    uint32 _NextSpeedLimit;

    uint32 _Distance;

    T_e8_DistanceUnit _DistanceUnit;

};

/**
 * Skeleton of T_MLNavigationNextDistanceUpdate.
 */
class T_MLNavigationNextDistanceUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_MLNavigationNextDistanceUpdate ();

    /**
     * Copy constructor
     */
    inline  T_MLNavigationNextDistanceUpdate (const T_MLNavigationNextDistanceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_MLNavigationNextDistanceUpdate (uint32 Distance_, T_e8_DistanceUnit DistanceUnit_, uint64 Time_, uint32 Percentage_);

    /**
     * Destructor
     */
    inline  ~T_MLNavigationNextDistanceUpdate();

    /**
     * Assignment operator
     */
    inline T_MLNavigationNextDistanceUpdate& operator = (const T_MLNavigationNextDistanceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MLNavigationNextDistanceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MLNavigationNextDistanceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MLNavigationNextDistanceUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MLNavigationNextDistanceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Distance"

    static const int kDistance = 0;

    /**
     * Clears the field "Distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "Distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "Distance".
     *
     * Distance to next navigation direction.
     *
     * @return The value of the field "Distance"
     */
    inline uint32 getDistance () const;

    /**
     * Sets the value of the member "Distance".
     *
     * Distance to next navigation direction.
     *
     * @param Distance The value which will be set
     */
    inline void setDistance (uint32 Distance_);

    // API of field "DistanceUnit"

    static const int kDistanceUnit = 1;

    /**
     * Clears the field "DistanceUnit".
     *
     * The field will be set to its default value. The hasDistanceUnit()
     * method will return false.
     */
    inline void clearDistanceUnit();

    /**
     * Checks whether the field "DistanceUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceUnit()). Otherwise it will return false.
     */
    inline bool hasDistanceUnit () const;

    /**
     * Returns the value of the member "DistanceUnit".
     *
     * Distance, to when the next speed limit will become effective.
     *
     * @return The value of the field "DistanceUnit"
     */
    inline T_e8_DistanceUnit getDistanceUnit () const;

    /**
     * Sets the value of the member "DistanceUnit".
     *
     * Distance, to when the next speed limit will become effective.
     *
     * @param DistanceUnit The value which will be set
     */
    inline void setDistanceUnit (T_e8_DistanceUnit DistanceUnit_);

    // API of field "Time"

    static const int kTime = 2;

    /**
     * Clears the field "Time".
     *
     * The field will be set to its default value. The hasTime()
     * method will return false.
     */
    inline void clearTime();

    /**
     * Checks whether the field "Time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTime()). Otherwise it will return false.
     */
    inline bool hasTime () const;

    /**
     * Returns the value of the member "Time".
     *
     * Time to next maneuver.
     *
     * @return The value of the field "Time"
     */
    inline uint64 getTime () const;

    /**
     * Sets the value of the member "Time".
     *
     * Time to next maneuver.
     *
     * @param Time The value which will be set
     */
    inline void setTime (uint64 Time_);

    // API of field "Percentage"

    static const int kPercentage = 3;

    /**
     * Clears the field "Percentage".
     *
     * The field will be set to its default value. The hasPercentage()
     * method will return false.
     */
    inline void clearPercentage();

    /**
     * Checks whether the field "Percentage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPercentage()). Otherwise it will return false.
     */
    inline bool hasPercentage () const;

    /**
     * Returns the value of the member "Percentage".
     *
     * Percentage already traveled to the next navigation direction.
     *
     * @return The value of the field "Percentage"
     */
    inline uint32 getPercentage () const;

    /**
     * Sets the value of the member "Percentage".
     *
     * Percentage already traveled to the next navigation direction.
     *
     * @param Percentage The value which will be set
     */
    inline void setPercentage (uint32 Percentage_);

    static const T_MLNavigationNextDistanceUpdate &getDefaultInstance();

private:

    inline void set_has_Distance ();

    inline void clear_has_Distance ();

    inline void set_has_DistanceUnit ();

    inline void clear_has_DistanceUnit ();

    inline void set_has_Time ();

    inline void clear_has_Time ();

    inline void set_has_Percentage ();

    inline void clear_has_Percentage ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _Distance;

    T_e8_DistanceUnit _DistanceUnit;

    uint64 _Time;

    uint32 _Percentage;

};

/**
 * Optional field, Skeleton of T_MLNavigationLaneGuidanceUpdate.
 */
class T_MLNavigationLaneGuidanceUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_MLNavigationLaneGuidanceUpdate ();

    /**
     * Copy constructor
     */
    inline  T_MLNavigationLaneGuidanceUpdate (const T_MLNavigationLaneGuidanceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_MLNavigationLaneGuidanceUpdate (const ::std::vector< uint32 >& NextLaneGuidances_, uint32 NumOfLaneGuidances_);

    /**
     * Destructor
     */
    inline  ~T_MLNavigationLaneGuidanceUpdate();

    /**
     * Assignment operator
     */
    inline T_MLNavigationLaneGuidanceUpdate& operator = (const T_MLNavigationLaneGuidanceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MLNavigationLaneGuidanceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MLNavigationLaneGuidanceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MLNavigationLaneGuidanceUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MLNavigationLaneGuidanceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NextLaneGuidances"

    static const int kNextLaneGuidances = 0;

    /**
     * Clears the field "NextLaneGuidances".
     *
     * The field will be set to its default value. The hasNextLaneGuidances()
     * method will return false.
     */
    inline void clearNextLaneGuidances();

    /**
     * Checks whether the field "NextLaneGuidances" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextLaneGuidances()). Otherwise it will return false.
     */
    inline bool hasNextLaneGuidances () const;

    /**
     * Returns the value of the member "NextLaneGuidances".
     *
     * Lane guidance information.
     *
     * @return The value of the field "NextLaneGuidances"
     */
    inline const ::std::vector< uint32 >& getNextLaneGuidances () const;

    /**
     * Retrieves the value of the field "NextLaneGuidances" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NextLaneGuidances".
     */
    inline ::std::vector< uint32 >& getNextLaneGuidancesMutable ();

    /**
     * Sets the value of the member "NextLaneGuidances".
     *
     * Lane guidance information.
     *
     * @param NextLaneGuidances The value which will be set
     */
    inline void setNextLaneGuidances (const ::std::vector< uint32 >& NextLaneGuidances_);

    // API of field "NumOfLaneGuidances"

    static const int kNumOfLaneGuidances = 1;

    /**
     * Clears the field "NumOfLaneGuidances".
     *
     * The field will be set to its default value. The hasNumOfLaneGuidances()
     * method will return false.
     */
    inline void clearNumOfLaneGuidances();

    /**
     * Checks whether the field "NumOfLaneGuidances" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumOfLaneGuidances()). Otherwise it will return false.
     */
    inline bool hasNumOfLaneGuidances () const;

    /**
     * Returns the value of the member "NumOfLaneGuidances".
     *
     * size of NextLaneGuidances
     *
     * @return The value of the field "NumOfLaneGuidances"
     */
    inline uint32 getNumOfLaneGuidances () const;

    /**
     * Sets the value of the member "NumOfLaneGuidances".
     *
     * size of NextLaneGuidances
     *
     * @param NumOfLaneGuidances The value which will be set
     */
    inline void setNumOfLaneGuidances (uint32 NumOfLaneGuidances_);

    static const T_MLNavigationLaneGuidanceUpdate &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_NextLaneGuidances ();

    inline void clear_has_NextLaneGuidances ();

    inline void set_has_NumOfLaneGuidances ();

    inline void clear_has_NumOfLaneGuidances ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< uint32 > _NextLaneGuidances;

    uint32 _NumOfLaneGuidances;

};

/**
 * Skeleton of T_MLNavigationTripInfoUpdate.
 */
class T_MLNavigationTripInfoUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_MLNavigationTripInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  T_MLNavigationTripInfoUpdate (const T_MLNavigationTripInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_MLNavigationTripInfoUpdate (const ::std::string& Destination_, uint32 Distance_, T_e8_DistanceUnit DistanceUnit_, uint64 RemainingTravelTime_, uint64 RemainingTrafficTime_);

    /**
     * Destructor
     */
    inline  ~T_MLNavigationTripInfoUpdate();

    /**
     * Assignment operator
     */
    inline T_MLNavigationTripInfoUpdate& operator = (const T_MLNavigationTripInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MLNavigationTripInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MLNavigationTripInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MLNavigationTripInfoUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MLNavigationTripInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Destination"

    static const int kDestination = 0;

    /**
     * Clears the field "Destination".
     *
     * The field will be set to its default value. The hasDestination()
     * method will return false.
     */
    inline void clearDestination();

    /**
     * Checks whether the field "Destination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestination()). Otherwise it will return false.
     */
    inline bool hasDestination () const;

    /**
     * Returns the value of the member "Destination".
     *
     * Name of destination.
     *
     * @return The value of the field "Destination"
     */
    inline const ::std::string& getDestination () const;

    /**
     * Retrieves the value of the field "Destination" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Destination".
     */
    inline ::std::string& getDestinationMutable ();

    /**
     * Sets the value of the member "Destination".
     *
     * Name of destination.
     *
     * @param Destination The value which will be set
     */
    inline void setDestination (const ::std::string& Destination_);

    /**
     * Sets the value of the member "Destination".
     *
     * Name of destination.
     *
     * @param Destination The value which will be set
     */
    inline void setDestination (const char* Destination_);

    /**
     * Sets the value of the member "Destination".
     *
     * Name of destination.
     *
     * @param Destination The value which will be set
     */
    inline void setDestination (const char* value, size_t size);

    // API of field "Distance"

    static const int kDistance = 1;

    /**
     * Clears the field "Distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "Distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "Distance".
     *
     * Distance to next navigation direction.
     *
     * @return The value of the field "Distance"
     */
    inline uint32 getDistance () const;

    /**
     * Sets the value of the member "Distance".
     *
     * Distance to next navigation direction.
     *
     * @param Distance The value which will be set
     */
    inline void setDistance (uint32 Distance_);

    // API of field "DistanceUnit"

    static const int kDistanceUnit = 2;

    /**
     * Clears the field "DistanceUnit".
     *
     * The field will be set to its default value. The hasDistanceUnit()
     * method will return false.
     */
    inline void clearDistanceUnit();

    /**
     * Checks whether the field "DistanceUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceUnit()). Otherwise it will return false.
     */
    inline bool hasDistanceUnit () const;

    /**
     * Returns the value of the member "DistanceUnit".
     *
     * Distance, to when the next speed limit will become effective.
     *
     * @return The value of the field "DistanceUnit"
     */
    inline T_e8_DistanceUnit getDistanceUnit () const;

    /**
     * Sets the value of the member "DistanceUnit".
     *
     * Distance, to when the next speed limit will become effective.
     *
     * @param DistanceUnit The value which will be set
     */
    inline void setDistanceUnit (T_e8_DistanceUnit DistanceUnit_);

    // API of field "RemainingTravelTime"

    static const int kRemainingTravelTime = 3;

    /**
     * Clears the field "RemainingTravelTime".
     *
     * The field will be set to its default value. The hasRemainingTravelTime()
     * method will return false.
     */
    inline void clearRemainingTravelTime();

    /**
     * Checks whether the field "RemainingTravelTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemainingTravelTime()). Otherwise it will return false.
     */
    inline bool hasRemainingTravelTime () const;

    /**
     * Returns the value of the member "RemainingTravelTime".
     *
     * Remaining travel time to destiunation.
     *
     * @return The value of the field "RemainingTravelTime"
     */
    inline uint64 getRemainingTravelTime () const;

    /**
     * Sets the value of the member "RemainingTravelTime".
     *
     * Remaining travel time to destiunation.
     *
     * @param RemainingTravelTime The value which will be set
     */
    inline void setRemainingTravelTime (uint64 RemainingTravelTime_);

    // API of field "RemainingTrafficTime"

    static const int kRemainingTrafficTime = 4;

    /**
     * Clears the field "RemainingTrafficTime".
     *
     * The field will be set to its default value. The hasRemainingTrafficTime()
     * method will return false.
     */
    inline void clearRemainingTrafficTime();

    /**
     * Checks whether the field "RemainingTrafficTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemainingTrafficTime()). Otherwise it will return false.
     */
    inline bool hasRemainingTrafficTime () const;

    /**
     * Returns the value of the member "RemainingTrafficTime".
     *
     * Estimated time spend in traffic.
     *
     * @return The value of the field "RemainingTrafficTime"
     */
    inline uint64 getRemainingTrafficTime () const;

    /**
     * Sets the value of the member "RemainingTrafficTime".
     *
     * Estimated time spend in traffic.
     *
     * @param RemainingTrafficTime The value which will be set
     */
    inline void setRemainingTrafficTime (uint64 RemainingTrafficTime_);

    static const T_MLNavigationTripInfoUpdate &getDefaultInstance();

private:

    inline void set_has_Destination ();

    inline void clear_has_Destination ();

    inline void set_has_Distance ();

    inline void clear_has_Distance ();

    inline void set_has_DistanceUnit ();

    inline void clear_has_DistanceUnit ();

    inline void set_has_RemainingTravelTime ();

    inline void clear_has_RemainingTravelTime ();

    inline void set_has_RemainingTrafficTime ();

    inline void clear_has_RemainingTrafficTime ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _Destination;

    uint32 _Distance;

    T_e8_DistanceUnit _DistanceUnit;

    uint64 _RemainingTravelTime;

    uint64 _RemainingTrafficTime;

};

/**
 * Skeleton of T_MLTBTUpdate. T_MLTBTUpdate defines data objects for the Navigation Meta data service to be carried over the SBP.
 * By receiving this data, the MirrorLink Client (i.e. car) can provide variety navigation information to driver and passenger through instrument cluster display panel, HUD, etc.
 */
class T_MLTBTUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_MLTBTUpdate ();

    /**
     * Copy constructor
     */
    inline  T_MLTBTUpdate (const T_MLTBTUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_MLTBTUpdate (const T_MLNavigationInfoUpdate& MLNavigationInfoUpdate_, bool isMLNavigationInfoUpdateValid_, const T_MLNavigationNextManeuverUpdate& MLNavigationNextManeuverUpdate_, bool isMLNavigationNextManeuverUpdateValid_, const T_MLSpeedLimitUpdate& MLSpeedLimitUpdate_, bool isMLSpeedLimitUpdateValid_, const T_MLNavigationNextDistanceUpdate& MLNavigationNextDistanceUpdate_, bool isMLNavigationNextDistanceUpdateValid_, const T_MLNavigationLaneGuidanceUpdate& MLNavigationLaneGuidanceUpdate_, bool isMLNavigationLaneGuidanceUpdateValid_, const T_MLNavigationTripInfoUpdate& MLNavigationTripInfoUpdate_, bool isMLNavigationTripInfoUpdateValid_);

    /**
     * Destructor
     */
    inline  ~T_MLTBTUpdate();

    /**
     * Assignment operator
     */
    inline T_MLTBTUpdate& operator = (const T_MLTBTUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MLTBTUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MLTBTUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MLTBTUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MLTBTUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MLNavigationInfoUpdate"

    static const int kMLNavigationInfoUpdate = 0;

    /**
     * Clears the field "MLNavigationInfoUpdate".
     *
     * The field will be set to its default value. The hasMLNavigationInfoUpdate()
     * method will return false.
     */
    inline void clearMLNavigationInfoUpdate();

    /**
     * Checks whether the field "MLNavigationInfoUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMLNavigationInfoUpdate()). Otherwise it will return false.
     */
    inline bool hasMLNavigationInfoUpdate () const;

    /**
     * Returns the value of the member "MLNavigationInfoUpdate".
     *
     * Structure Containing MLNavigationInfoUpdate info.
     *
     * @return The value of the field "MLNavigationInfoUpdate"
     */
    inline const T_MLNavigationInfoUpdate& getMLNavigationInfoUpdate () const;

    /**
     * Retrieves the value of the field "MLNavigationInfoUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MLNavigationInfoUpdate".
     */
    inline T_MLNavigationInfoUpdate& getMLNavigationInfoUpdateMutable ();

    /**
     * Sets the value of the member "MLNavigationInfoUpdate".
     *
     * Structure Containing MLNavigationInfoUpdate info.
     *
     * @param MLNavigationInfoUpdate The value which will be set
     */
    inline void setMLNavigationInfoUpdate (const T_MLNavigationInfoUpdate& MLNavigationInfoUpdate_);

    // API of field "isMLNavigationInfoUpdateValid"

    static const int kIsMLNavigationInfoUpdateValid = 1;

    /**
     * Clears the field "isMLNavigationInfoUpdateValid".
     *
     * The field will be set to its default value. The hasIsMLNavigationInfoUpdateValid()
     * method will return false.
     */
    inline void clearIsMLNavigationInfoUpdateValid();

    /**
     * Checks whether the field "isMLNavigationInfoUpdateValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMLNavigationInfoUpdateValid()). Otherwise it will return false.
     */
    inline bool hasIsMLNavigationInfoUpdateValid () const;

    /**
     * Returns the value of the member "isMLNavigationInfoUpdateValid".
     *
     * Client must use MLNavigationInfoUpdate only if it is true.
     *
     * @return The value of the field "isMLNavigationInfoUpdateValid"
     */
    inline bool getIsMLNavigationInfoUpdateValid () const;

    /**
     * Sets the value of the member "isMLNavigationInfoUpdateValid".
     *
     * Client must use MLNavigationInfoUpdate only if it is true.
     *
     * @param isMLNavigationInfoUpdateValid The value which will be set
     */
    inline void setIsMLNavigationInfoUpdateValid (bool isMLNavigationInfoUpdateValid_);

    // API of field "MLNavigationNextManeuverUpdate"

    static const int kMLNavigationNextManeuverUpdate = 2;

    /**
     * Clears the field "MLNavigationNextManeuverUpdate".
     *
     * The field will be set to its default value. The hasMLNavigationNextManeuverUpdate()
     * method will return false.
     */
    inline void clearMLNavigationNextManeuverUpdate();

    /**
     * Checks whether the field "MLNavigationNextManeuverUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMLNavigationNextManeuverUpdate()). Otherwise it will return false.
     */
    inline bool hasMLNavigationNextManeuverUpdate () const;

    /**
     * Returns the value of the member "MLNavigationNextManeuverUpdate".
     *
     * Structure Containing MLNavigationNextManeuverUpdate info.
     *
     * @return The value of the field "MLNavigationNextManeuverUpdate"
     */
    inline const T_MLNavigationNextManeuverUpdate& getMLNavigationNextManeuverUpdate () const;

    /**
     * Retrieves the value of the field "MLNavigationNextManeuverUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MLNavigationNextManeuverUpdate".
     */
    inline T_MLNavigationNextManeuverUpdate& getMLNavigationNextManeuverUpdateMutable ();

    /**
     * Sets the value of the member "MLNavigationNextManeuverUpdate".
     *
     * Structure Containing MLNavigationNextManeuverUpdate info.
     *
     * @param MLNavigationNextManeuverUpdate The value which will be set
     */
    inline void setMLNavigationNextManeuverUpdate (const T_MLNavigationNextManeuverUpdate& MLNavigationNextManeuverUpdate_);

    // API of field "isMLNavigationNextManeuverUpdateValid"

    static const int kIsMLNavigationNextManeuverUpdateValid = 3;

    /**
     * Clears the field "isMLNavigationNextManeuverUpdateValid".
     *
     * The field will be set to its default value. The hasIsMLNavigationNextManeuverUpdateValid()
     * method will return false.
     */
    inline void clearIsMLNavigationNextManeuverUpdateValid();

    /**
     * Checks whether the field "isMLNavigationNextManeuverUpdateValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMLNavigationNextManeuverUpdateValid()). Otherwise it will return false.
     */
    inline bool hasIsMLNavigationNextManeuverUpdateValid () const;

    /**
     * Returns the value of the member "isMLNavigationNextManeuverUpdateValid".
     *
     * Client must use MLNavigationNextManeuverUpdate only if it is true.
     *
     * @return The value of the field "isMLNavigationNextManeuverUpdateValid"
     */
    inline bool getIsMLNavigationNextManeuverUpdateValid () const;

    /**
     * Sets the value of the member "isMLNavigationNextManeuverUpdateValid".
     *
     * Client must use MLNavigationNextManeuverUpdate only if it is true.
     *
     * @param isMLNavigationNextManeuverUpdateValid The value which will be set
     */
    inline void setIsMLNavigationNextManeuverUpdateValid (bool isMLNavigationNextManeuverUpdateValid_);

    // API of field "MLSpeedLimitUpdate"

    static const int kMLSpeedLimitUpdate = 4;

    /**
     * Clears the field "MLSpeedLimitUpdate".
     *
     * The field will be set to its default value. The hasMLSpeedLimitUpdate()
     * method will return false.
     */
    inline void clearMLSpeedLimitUpdate();

    /**
     * Checks whether the field "MLSpeedLimitUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMLSpeedLimitUpdate()). Otherwise it will return false.
     */
    inline bool hasMLSpeedLimitUpdate () const;

    /**
     * Returns the value of the member "MLSpeedLimitUpdate".
     *
     * Structure Containing MLSpeedLimitUpdate info.
     *
     * @return The value of the field "MLSpeedLimitUpdate"
     */
    inline const T_MLSpeedLimitUpdate& getMLSpeedLimitUpdate () const;

    /**
     * Retrieves the value of the field "MLSpeedLimitUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MLSpeedLimitUpdate".
     */
    inline T_MLSpeedLimitUpdate& getMLSpeedLimitUpdateMutable ();

    /**
     * Sets the value of the member "MLSpeedLimitUpdate".
     *
     * Structure Containing MLSpeedLimitUpdate info.
     *
     * @param MLSpeedLimitUpdate The value which will be set
     */
    inline void setMLSpeedLimitUpdate (const T_MLSpeedLimitUpdate& MLSpeedLimitUpdate_);

    // API of field "isMLSpeedLimitUpdateValid"

    static const int kIsMLSpeedLimitUpdateValid = 5;

    /**
     * Clears the field "isMLSpeedLimitUpdateValid".
     *
     * The field will be set to its default value. The hasIsMLSpeedLimitUpdateValid()
     * method will return false.
     */
    inline void clearIsMLSpeedLimitUpdateValid();

    /**
     * Checks whether the field "isMLSpeedLimitUpdateValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMLSpeedLimitUpdateValid()). Otherwise it will return false.
     */
    inline bool hasIsMLSpeedLimitUpdateValid () const;

    /**
     * Returns the value of the member "isMLSpeedLimitUpdateValid".
     *
     * Client must use MLSpeedLimitUpdate only if it is true.
     *
     * @return The value of the field "isMLSpeedLimitUpdateValid"
     */
    inline bool getIsMLSpeedLimitUpdateValid () const;

    /**
     * Sets the value of the member "isMLSpeedLimitUpdateValid".
     *
     * Client must use MLSpeedLimitUpdate only if it is true.
     *
     * @param isMLSpeedLimitUpdateValid The value which will be set
     */
    inline void setIsMLSpeedLimitUpdateValid (bool isMLSpeedLimitUpdateValid_);

    // API of field "MLNavigationNextDistanceUpdate"

    static const int kMLNavigationNextDistanceUpdate = 6;

    /**
     * Clears the field "MLNavigationNextDistanceUpdate".
     *
     * The field will be set to its default value. The hasMLNavigationNextDistanceUpdate()
     * method will return false.
     */
    inline void clearMLNavigationNextDistanceUpdate();

    /**
     * Checks whether the field "MLNavigationNextDistanceUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMLNavigationNextDistanceUpdate()). Otherwise it will return false.
     */
    inline bool hasMLNavigationNextDistanceUpdate () const;

    /**
     * Returns the value of the member "MLNavigationNextDistanceUpdate".
     *
     * Structure Containing MLNavigationNextDistanceUpdate info.
     *
     * @return The value of the field "MLNavigationNextDistanceUpdate"
     */
    inline const T_MLNavigationNextDistanceUpdate& getMLNavigationNextDistanceUpdate () const;

    /**
     * Retrieves the value of the field "MLNavigationNextDistanceUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MLNavigationNextDistanceUpdate".
     */
    inline T_MLNavigationNextDistanceUpdate& getMLNavigationNextDistanceUpdateMutable ();

    /**
     * Sets the value of the member "MLNavigationNextDistanceUpdate".
     *
     * Structure Containing MLNavigationNextDistanceUpdate info.
     *
     * @param MLNavigationNextDistanceUpdate The value which will be set
     */
    inline void setMLNavigationNextDistanceUpdate (const T_MLNavigationNextDistanceUpdate& MLNavigationNextDistanceUpdate_);

    // API of field "isMLNavigationNextDistanceUpdateValid"

    static const int kIsMLNavigationNextDistanceUpdateValid = 7;

    /**
     * Clears the field "isMLNavigationNextDistanceUpdateValid".
     *
     * The field will be set to its default value. The hasIsMLNavigationNextDistanceUpdateValid()
     * method will return false.
     */
    inline void clearIsMLNavigationNextDistanceUpdateValid();

    /**
     * Checks whether the field "isMLNavigationNextDistanceUpdateValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMLNavigationNextDistanceUpdateValid()). Otherwise it will return false.
     */
    inline bool hasIsMLNavigationNextDistanceUpdateValid () const;

    /**
     * Returns the value of the member "isMLNavigationNextDistanceUpdateValid".
     *
     * Client must use MLNavigationNextDistanceUpdate only if it is true.
     *
     * @return The value of the field "isMLNavigationNextDistanceUpdateValid"
     */
    inline bool getIsMLNavigationNextDistanceUpdateValid () const;

    /**
     * Sets the value of the member "isMLNavigationNextDistanceUpdateValid".
     *
     * Client must use MLNavigationNextDistanceUpdate only if it is true.
     *
     * @param isMLNavigationNextDistanceUpdateValid The value which will be set
     */
    inline void setIsMLNavigationNextDistanceUpdateValid (bool isMLNavigationNextDistanceUpdateValid_);

    // API of field "MLNavigationLaneGuidanceUpdate"

    static const int kMLNavigationLaneGuidanceUpdate = 8;

    /**
     * Clears the field "MLNavigationLaneGuidanceUpdate".
     *
     * The field will be set to its default value. The hasMLNavigationLaneGuidanceUpdate()
     * method will return false.
     */
    inline void clearMLNavigationLaneGuidanceUpdate();

    /**
     * Checks whether the field "MLNavigationLaneGuidanceUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMLNavigationLaneGuidanceUpdate()). Otherwise it will return false.
     */
    inline bool hasMLNavigationLaneGuidanceUpdate () const;

    /**
     * Returns the value of the member "MLNavigationLaneGuidanceUpdate".
     *
     * Structure Containing MLNavigationLaneGuidanceUpdate info.
     *
     * @return The value of the field "MLNavigationLaneGuidanceUpdate"
     */
    inline const T_MLNavigationLaneGuidanceUpdate& getMLNavigationLaneGuidanceUpdate () const;

    /**
     * Retrieves the value of the field "MLNavigationLaneGuidanceUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MLNavigationLaneGuidanceUpdate".
     */
    inline T_MLNavigationLaneGuidanceUpdate& getMLNavigationLaneGuidanceUpdateMutable ();

    /**
     * Sets the value of the member "MLNavigationLaneGuidanceUpdate".
     *
     * Structure Containing MLNavigationLaneGuidanceUpdate info.
     *
     * @param MLNavigationLaneGuidanceUpdate The value which will be set
     */
    inline void setMLNavigationLaneGuidanceUpdate (const T_MLNavigationLaneGuidanceUpdate& MLNavigationLaneGuidanceUpdate_);

    // API of field "isMLNavigationLaneGuidanceUpdateValid"

    static const int kIsMLNavigationLaneGuidanceUpdateValid = 9;

    /**
     * Clears the field "isMLNavigationLaneGuidanceUpdateValid".
     *
     * The field will be set to its default value. The hasIsMLNavigationLaneGuidanceUpdateValid()
     * method will return false.
     */
    inline void clearIsMLNavigationLaneGuidanceUpdateValid();

    /**
     * Checks whether the field "isMLNavigationLaneGuidanceUpdateValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMLNavigationLaneGuidanceUpdateValid()). Otherwise it will return false.
     */
    inline bool hasIsMLNavigationLaneGuidanceUpdateValid () const;

    /**
     * Returns the value of the member "isMLNavigationLaneGuidanceUpdateValid".
     *
     * Client must use MLNavigationLaneGuidanceUpdate only if it is true.
     *
     * @return The value of the field "isMLNavigationLaneGuidanceUpdateValid"
     */
    inline bool getIsMLNavigationLaneGuidanceUpdateValid () const;

    /**
     * Sets the value of the member "isMLNavigationLaneGuidanceUpdateValid".
     *
     * Client must use MLNavigationLaneGuidanceUpdate only if it is true.
     *
     * @param isMLNavigationLaneGuidanceUpdateValid The value which will be set
     */
    inline void setIsMLNavigationLaneGuidanceUpdateValid (bool isMLNavigationLaneGuidanceUpdateValid_);

    // API of field "MLNavigationTripInfoUpdate"

    static const int kMLNavigationTripInfoUpdate = 10;

    /**
     * Clears the field "MLNavigationTripInfoUpdate".
     *
     * The field will be set to its default value. The hasMLNavigationTripInfoUpdate()
     * method will return false.
     */
    inline void clearMLNavigationTripInfoUpdate();

    /**
     * Checks whether the field "MLNavigationTripInfoUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMLNavigationTripInfoUpdate()). Otherwise it will return false.
     */
    inline bool hasMLNavigationTripInfoUpdate () const;

    /**
     * Returns the value of the member "MLNavigationTripInfoUpdate".
     *
     * Structure Containing MLNavigationLaneGuidanceUpdate info.
     *
     * @return The value of the field "MLNavigationTripInfoUpdate"
     */
    inline const T_MLNavigationTripInfoUpdate& getMLNavigationTripInfoUpdate () const;

    /**
     * Retrieves the value of the field "MLNavigationTripInfoUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MLNavigationTripInfoUpdate".
     */
    inline T_MLNavigationTripInfoUpdate& getMLNavigationTripInfoUpdateMutable ();

    /**
     * Sets the value of the member "MLNavigationTripInfoUpdate".
     *
     * Structure Containing MLNavigationLaneGuidanceUpdate info.
     *
     * @param MLNavigationTripInfoUpdate The value which will be set
     */
    inline void setMLNavigationTripInfoUpdate (const T_MLNavigationTripInfoUpdate& MLNavigationTripInfoUpdate_);

    // API of field "isMLNavigationTripInfoUpdateValid"

    static const int kIsMLNavigationTripInfoUpdateValid = 11;

    /**
     * Clears the field "isMLNavigationTripInfoUpdateValid".
     *
     * The field will be set to its default value. The hasIsMLNavigationTripInfoUpdateValid()
     * method will return false.
     */
    inline void clearIsMLNavigationTripInfoUpdateValid();

    /**
     * Checks whether the field "isMLNavigationTripInfoUpdateValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMLNavigationTripInfoUpdateValid()). Otherwise it will return false.
     */
    inline bool hasIsMLNavigationTripInfoUpdateValid () const;

    /**
     * Returns the value of the member "isMLNavigationTripInfoUpdateValid".
     *
     * Client must use MLNavigationLaneGuidanceUpdate only if it is true.
     *
     * @return The value of the field "isMLNavigationTripInfoUpdateValid"
     */
    inline bool getIsMLNavigationTripInfoUpdateValid () const;

    /**
     * Sets the value of the member "isMLNavigationTripInfoUpdateValid".
     *
     * Client must use MLNavigationLaneGuidanceUpdate only if it is true.
     *
     * @param isMLNavigationTripInfoUpdateValid The value which will be set
     */
    inline void setIsMLNavigationTripInfoUpdateValid (bool isMLNavigationTripInfoUpdateValid_);

    static const T_MLTBTUpdate &getDefaultInstance();

private:

    inline void set_has_MLNavigationInfoUpdate ();

    inline void clear_has_MLNavigationInfoUpdate ();

    inline void set_has_isMLNavigationInfoUpdateValid ();

    inline void clear_has_isMLNavigationInfoUpdateValid ();

    inline void set_has_MLNavigationNextManeuverUpdate ();

    inline void clear_has_MLNavigationNextManeuverUpdate ();

    inline void set_has_isMLNavigationNextManeuverUpdateValid ();

    inline void clear_has_isMLNavigationNextManeuverUpdateValid ();

    inline void set_has_MLSpeedLimitUpdate ();

    inline void clear_has_MLSpeedLimitUpdate ();

    inline void set_has_isMLSpeedLimitUpdateValid ();

    inline void clear_has_isMLSpeedLimitUpdateValid ();

    inline void set_has_MLNavigationNextDistanceUpdate ();

    inline void clear_has_MLNavigationNextDistanceUpdate ();

    inline void set_has_isMLNavigationNextDistanceUpdateValid ();

    inline void clear_has_isMLNavigationNextDistanceUpdateValid ();

    inline void set_has_MLNavigationLaneGuidanceUpdate ();

    inline void clear_has_MLNavigationLaneGuidanceUpdate ();

    inline void set_has_isMLNavigationLaneGuidanceUpdateValid ();

    inline void clear_has_isMLNavigationLaneGuidanceUpdateValid ();

    inline void set_has_MLNavigationTripInfoUpdate ();

    inline void clear_has_MLNavigationTripInfoUpdate ();

    inline void set_has_isMLNavigationTripInfoUpdateValid ();

    inline void clear_has_isMLNavigationTripInfoUpdateValid ();

    uint32 _has_bits_[ (12 + 31) / 32];

    T_MLNavigationInfoUpdate _MLNavigationInfoUpdate;

    bool _isMLNavigationInfoUpdateValid;

    T_MLNavigationNextManeuverUpdate _MLNavigationNextManeuverUpdate;

    bool _isMLNavigationNextManeuverUpdateValid;

    T_MLSpeedLimitUpdate _MLSpeedLimitUpdate;

    bool _isMLSpeedLimitUpdateValid;

    T_MLNavigationNextDistanceUpdate _MLNavigationNextDistanceUpdate;

    bool _isMLNavigationNextDistanceUpdateValid;

    T_MLNavigationLaneGuidanceUpdate _MLNavigationLaneGuidanceUpdate;

    bool _isMLNavigationLaneGuidanceUpdateValid;

    T_MLNavigationTripInfoUpdate _MLNavigationTripInfoUpdate;

    bool _isMLNavigationTripInfoUpdateValid;

};

/**
 * This structure contains Ambient Colour Data details like Red,Green,Blue,Alpha etc.
 */
class T_AmbientColourData {
public:

    /**
     * Default constructor
     */
    inline  T_AmbientColourData ();

    /**
     * Copy constructor
     */
    inline  T_AmbientColourData (const T_AmbientColourData &rhs);

    /**
     * All fields constructor
     */
    inline  T_AmbientColourData (float fRed_, float fGreen_, float fBlue_, float fAlpha_);

    /**
     * Destructor
     */
    inline  ~T_AmbientColourData();

    /**
     * Assignment operator
     */
    inline T_AmbientColourData& operator = (const T_AmbientColourData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AmbientColourData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AmbientColourData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AmbientColourData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AmbientColourData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "fRed"

    static const int kFRed = 0;

    /**
     * Clears the field "fRed".
     *
     * The field will be set to its default value. The hasFRed()
     * method will return false.
     */
    inline void clearFRed();

    /**
     * Checks whether the field "fRed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFRed()). Otherwise it will return false.
     */
    inline bool hasFRed () const;

    /**
     * Returns the value of the member "fRed".
     *
     * Indicates Red colour. Valid data range for Red is 0.0f to 1.0f
     *
     * @return The value of the field "fRed"
     */
    inline float getFRed () const;

    /**
     * Sets the value of the member "fRed".
     *
     * Indicates Red colour. Valid data range for Red is 0.0f to 1.0f
     *
     * @param fRed The value which will be set
     */
    inline void setFRed (float fRed_);

    // API of field "fGreen"

    static const int kFGreen = 1;

    /**
     * Clears the field "fGreen".
     *
     * The field will be set to its default value. The hasFGreen()
     * method will return false.
     */
    inline void clearFGreen();

    /**
     * Checks whether the field "fGreen" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFGreen()). Otherwise it will return false.
     */
    inline bool hasFGreen () const;

    /**
     * Returns the value of the member "fGreen".
     *
     * Indicates Green colour. Valid data range for Green is 0.0f to 1.0f
     *
     * @return The value of the field "fGreen"
     */
    inline float getFGreen () const;

    /**
     * Sets the value of the member "fGreen".
     *
     * Indicates Green colour. Valid data range for Green is 0.0f to 1.0f
     *
     * @param fGreen The value which will be set
     */
    inline void setFGreen (float fGreen_);

    // API of field "fBlue"

    static const int kFBlue = 2;

    /**
     * Clears the field "fBlue".
     *
     * The field will be set to its default value. The hasFBlue()
     * method will return false.
     */
    inline void clearFBlue();

    /**
     * Checks whether the field "fBlue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFBlue()). Otherwise it will return false.
     */
    inline bool hasFBlue () const;

    /**
     * Returns the value of the member "fBlue".
     *
     * Indicates Blue colour. Valid data range for Green is 0.0f to 1.0f
     *
     * @return The value of the field "fBlue"
     */
    inline float getFBlue () const;

    /**
     * Sets the value of the member "fBlue".
     *
     * Indicates Blue colour. Valid data range for Green is 0.0f to 1.0f
     *
     * @param fBlue The value which will be set
     */
    inline void setFBlue (float fBlue_);

    // API of field "fAlpha"

    static const int kFAlpha = 3;

    /**
     * Clears the field "fAlpha".
     *
     * The field will be set to its default value. The hasFAlpha()
     * method will return false.
     */
    inline void clearFAlpha();

    /**
     * Checks whether the field "fAlpha" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFAlpha()). Otherwise it will return false.
     */
    inline bool hasFAlpha () const;

    /**
     * Returns the value of the member "fAlpha".
     *
     * Indicates Alpha colour. Valid data range for Green is 0.0f to 1.0f
     *
     * @return The value of the field "fAlpha"
     */
    inline float getFAlpha () const;

    /**
     * Sets the value of the member "fAlpha".
     *
     * Indicates Alpha colour. Valid data range for Green is 0.0f to 1.0f
     *
     * @param fAlpha The value which will be set
     */
    inline void setFAlpha (float fAlpha_);

    static const T_AmbientColourData &getDefaultInstance();

private:

    inline void set_has_fRed ();

    inline void clear_has_fRed ();

    inline void set_has_fGreen ();

    inline void clear_has_fGreen ();

    inline void set_has_fBlue ();

    inline void clear_has_fBlue ();

    inline void set_has_fAlpha ();

    inline void clear_has_fAlpha ();

    uint32 _has_bits_[ (4 + 31) / 32];

    float _fRed;

    float _fGreen;

    float _fBlue;

    float _fAlpha;

};

/**
 * This holds info for configuring the display capabilities for displaying TurnbyTurn Information
 */
class T_RouteGuidanceDisplayComponent {
public:

    /**
     * Default constructor
     */
    inline  T_RouteGuidanceDisplayComponent ();

    /**
     * Copy constructor
     */
    inline  T_RouteGuidanceDisplayComponent (const T_RouteGuidanceDisplayComponent &rhs);

    /**
     * All fields constructor
     */
    inline  T_RouteGuidanceDisplayComponent (T_e8_ComponentID ComponentID_, const ::std::string& DisplayName_, uint16 u16MaxCurrentRoadNameLength_, uint16 u16MaxDestinationNameLength_, uint16 u16MaxAfterManeuverRoadNameLength_, uint16 u16MaxManeuverDescriptionLength_, uint16 u16MaxGuidanceManeuverCapacity_);

    /**
     * Destructor
     */
    inline  ~T_RouteGuidanceDisplayComponent();

    /**
     * Assignment operator
     */
    inline T_RouteGuidanceDisplayComponent& operator = (const T_RouteGuidanceDisplayComponent& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_RouteGuidanceDisplayComponent& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_RouteGuidanceDisplayComponent& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_RouteGuidanceDisplayComponent& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_RouteGuidanceDisplayComponent& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ComponentID"

    static const int kComponentID = 0;

    /**
     * Clears the field "ComponentID".
     *
     * The field will be set to its default value. The hasComponentID()
     * method will return false.
     */
    inline void clearComponentID();

    /**
     * Checks whether the field "ComponentID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setComponentID()). Otherwise it will return false.
     */
    inline bool hasComponentID () const;

    /**
     * Returns the value of the member "ComponentID".
     *
     * Unique display component identifier
     *
     * @return The value of the field "ComponentID"
     */
    inline T_e8_ComponentID getComponentID () const;

    /**
     * Sets the value of the member "ComponentID".
     *
     * Unique display component identifier
     *
     * @param ComponentID The value which will be set
     */
    inline void setComponentID (T_e8_ComponentID ComponentID_);

    // API of field "DisplayName"

    static const int kDisplayName = 1;

    /**
     * Clears the field "DisplayName".
     *
     * The field will be set to its default value. The hasDisplayName()
     * method will return false.
     */
    inline void clearDisplayName();

    /**
     * Checks whether the field "DisplayName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayName()). Otherwise it will return false.
     */
    inline bool hasDisplayName () const;

    /**
     * Returns the value of the member "DisplayName".
     *
     * Display component name
     *
     * @return The value of the field "DisplayName"
     */
    inline const ::std::string& getDisplayName () const;

    /**
     * Retrieves the value of the field "DisplayName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayName".
     */
    inline ::std::string& getDisplayNameMutable ();

    /**
     * Sets the value of the member "DisplayName".
     *
     * Display component name
     *
     * @param DisplayName The value which will be set
     */
    inline void setDisplayName (const ::std::string& DisplayName_);

    /**
     * Sets the value of the member "DisplayName".
     *
     * Display component name
     *
     * @param DisplayName The value which will be set
     */
    inline void setDisplayName (const char* DisplayName_);

    /**
     * Sets the value of the member "DisplayName".
     *
     * Display component name
     *
     * @param DisplayName The value which will be set
     */
    inline void setDisplayName (const char* value, size_t size);

    // API of field "u16MaxCurrentRoadNameLength"

    static const int kU16MaxCurrentRoadNameLength = 2;

    /**
     * Clears the field "u16MaxCurrentRoadNameLength".
     *
     * The field will be set to its default value. The hasU16MaxCurrentRoadNameLength()
     * method will return false.
     */
    inline void clearU16MaxCurrentRoadNameLength();

    /**
     * Checks whether the field "u16MaxCurrentRoadNameLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MaxCurrentRoadNameLength()). Otherwise it will return false.
     */
    inline bool hasU16MaxCurrentRoadNameLength () const;

    /**
     * Returns the value of the member "u16MaxCurrentRoadNameLength".
     *
     * How many of the widest character in the font used to display CurrentRoadName can be shown to the user. Must be included if CurrentRoadName information is displayed to the user.
     *
     * @return The value of the field "u16MaxCurrentRoadNameLength"
     */
    inline uint16 getU16MaxCurrentRoadNameLength () const;

    /**
     * Sets the value of the member "u16MaxCurrentRoadNameLength".
     *
     * How many of the widest character in the font used to display CurrentRoadName can be shown to the user. Must be included if CurrentRoadName information is displayed to the user.
     *
     * @param u16MaxCurrentRoadNameLength The value which will be set
     */
    inline void setU16MaxCurrentRoadNameLength (uint16 u16MaxCurrentRoadNameLength_);

    // API of field "u16MaxDestinationNameLength"

    static const int kU16MaxDestinationNameLength = 3;

    /**
     * Clears the field "u16MaxDestinationNameLength".
     *
     * The field will be set to its default value. The hasU16MaxDestinationNameLength()
     * method will return false.
     */
    inline void clearU16MaxDestinationNameLength();

    /**
     * Checks whether the field "u16MaxDestinationNameLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MaxDestinationNameLength()). Otherwise it will return false.
     */
    inline bool hasU16MaxDestinationNameLength () const;

    /**
     * Returns the value of the member "u16MaxDestinationNameLength".
     *
     * How many of the widest character in the font used to display DestinationName can be shown to the user. Must be included if DestinationName information is displayed to the user.
     *
     * @return The value of the field "u16MaxDestinationNameLength"
     */
    inline uint16 getU16MaxDestinationNameLength () const;

    /**
     * Sets the value of the member "u16MaxDestinationNameLength".
     *
     * How many of the widest character in the font used to display DestinationName can be shown to the user. Must be included if DestinationName information is displayed to the user.
     *
     * @param u16MaxDestinationNameLength The value which will be set
     */
    inline void setU16MaxDestinationNameLength (uint16 u16MaxDestinationNameLength_);

    // API of field "u16MaxAfterManeuverRoadNameLength"

    static const int kU16MaxAfterManeuverRoadNameLength = 4;

    /**
     * Clears the field "u16MaxAfterManeuverRoadNameLength".
     *
     * The field will be set to its default value. The hasU16MaxAfterManeuverRoadNameLength()
     * method will return false.
     */
    inline void clearU16MaxAfterManeuverRoadNameLength();

    /**
     * Checks whether the field "u16MaxAfterManeuverRoadNameLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MaxAfterManeuverRoadNameLength()). Otherwise it will return false.
     */
    inline bool hasU16MaxAfterManeuverRoadNameLength () const;

    /**
     * Returns the value of the member "u16MaxAfterManeuverRoadNameLength".
     *
     * How many of the widest character in the font used to display AfterManeuverRoadName can be shown to the user. Must be included if AfterManeuverRoadName information is displayed to the user.
     *
     * @return The value of the field "u16MaxAfterManeuverRoadNameLength"
     */
    inline uint16 getU16MaxAfterManeuverRoadNameLength () const;

    /**
     * Sets the value of the member "u16MaxAfterManeuverRoadNameLength".
     *
     * How many of the widest character in the font used to display AfterManeuverRoadName can be shown to the user. Must be included if AfterManeuverRoadName information is displayed to the user.
     *
     * @param u16MaxAfterManeuverRoadNameLength The value which will be set
     */
    inline void setU16MaxAfterManeuverRoadNameLength (uint16 u16MaxAfterManeuverRoadNameLength_);

    // API of field "u16MaxManeuverDescriptionLength"

    static const int kU16MaxManeuverDescriptionLength = 5;

    /**
     * Clears the field "u16MaxManeuverDescriptionLength".
     *
     * The field will be set to its default value. The hasU16MaxManeuverDescriptionLength()
     * method will return false.
     */
    inline void clearU16MaxManeuverDescriptionLength();

    /**
     * Checks whether the field "u16MaxManeuverDescriptionLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MaxManeuverDescriptionLength()). Otherwise it will return false.
     */
    inline bool hasU16MaxManeuverDescriptionLength () const;

    /**
     * Returns the value of the member "u16MaxManeuverDescriptionLength".
     *
     * How many of the widest character in the font used to display ManeuverDescription can be shown to the user. Must be included if ManeuverDescription information is displayed to the user.
     *
     * @return The value of the field "u16MaxManeuverDescriptionLength"
     */
    inline uint16 getU16MaxManeuverDescriptionLength () const;

    /**
     * Sets the value of the member "u16MaxManeuverDescriptionLength".
     *
     * How many of the widest character in the font used to display ManeuverDescription can be shown to the user. Must be included if ManeuverDescription information is displayed to the user.
     *
     * @param u16MaxManeuverDescriptionLength The value which will be set
     */
    inline void setU16MaxManeuverDescriptionLength (uint16 u16MaxManeuverDescriptionLength_);

    // API of field "u16MaxGuidanceManeuverCapacity"

    static const int kU16MaxGuidanceManeuverCapacity = 6;

    /**
     * Clears the field "u16MaxGuidanceManeuverCapacity".
     *
     * The field will be set to its default value. The hasU16MaxGuidanceManeuverCapacity()
     * method will return false.
     */
    inline void clearU16MaxGuidanceManeuverCapacity();

    /**
     * Checks whether the field "u16MaxGuidanceManeuverCapacity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MaxGuidanceManeuverCapacity()). Otherwise it will return false.
     */
    inline bool hasU16MaxGuidanceManeuverCapacity () const;

    /**
     * Returns the value of the member "u16MaxGuidanceManeuverCapacity".
     *
     * Number of Maneuvers the accessory can handle (ie. store and/or display) at once.
     * Configuring more than 1, will lead to increase in maneuver list i.e u16RouteGuidanceManeuverCurrentList.
     * Client can use this if they have a requirement to list all the maneuver list from source to destination. otherwise value 1 is good.
     *
     * @return The value of the field "u16MaxGuidanceManeuverCapacity"
     */
    inline uint16 getU16MaxGuidanceManeuverCapacity () const;

    /**
     * Sets the value of the member "u16MaxGuidanceManeuverCapacity".
     *
     * Number of Maneuvers the accessory can handle (ie. store and/or display) at once.
     * Configuring more than 1, will lead to increase in maneuver list i.e u16RouteGuidanceManeuverCurrentList.
     * Client can use this if they have a requirement to list all the maneuver list from source to destination. otherwise value 1 is good.
     *
     * @param u16MaxGuidanceManeuverCapacity The value which will be set
     */
    inline void setU16MaxGuidanceManeuverCapacity (uint16 u16MaxGuidanceManeuverCapacity_);

    static const T_RouteGuidanceDisplayComponent &getDefaultInstance();

private:

    inline void set_has_ComponentID ();

    inline void clear_has_ComponentID ();

    inline void set_has_DisplayName ();

    inline void clear_has_DisplayName ();

    inline void set_has_u16MaxCurrentRoadNameLength ();

    inline void clear_has_u16MaxCurrentRoadNameLength ();

    inline void set_has_u16MaxDestinationNameLength ();

    inline void clear_has_u16MaxDestinationNameLength ();

    inline void set_has_u16MaxAfterManeuverRoadNameLength ();

    inline void clear_has_u16MaxAfterManeuverRoadNameLength ();

    inline void set_has_u16MaxManeuverDescriptionLength ();

    inline void clear_has_u16MaxManeuverDescriptionLength ();

    inline void set_has_u16MaxGuidanceManeuverCapacity ();

    inline void clear_has_u16MaxGuidanceManeuverCapacity ();

    uint32 _has_bits_[ (7 + 31) / 32];

    T_e8_ComponentID _ComponentID;

    ::std::string _DisplayName;

    uint16 _u16MaxCurrentRoadNameLength;

    uint16 _u16MaxDestinationNameLength;

    uint16 _u16MaxAfterManeuverRoadNameLength;

    uint16 _u16MaxManeuverDescriptionLength;

    uint16 _u16MaxGuidanceManeuverCapacity;

};

/**
 * This structure holds the information about the key being registered with SPI: T_e32_KeyCode and T_e32_KeyType.
 */
class T_KeyInfo {
public:

    /**
     * Default constructor
     */
    inline  T_KeyInfo ();

    /**
     * Copy constructor
     */
    inline  T_KeyInfo (const T_KeyInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_KeyInfo (T_e32_KeyCode KeyCode_, T_e32_KeyType KeyType_);

    /**
     * Destructor
     */
    inline  ~T_KeyInfo();

    /**
     * Assignment operator
     */
    inline T_KeyInfo& operator = (const T_KeyInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_KeyInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_KeyInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_KeyInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_KeyInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "KeyCode"

    static const int kKeyCode = 0;

    /**
     * Clears the field "KeyCode".
     *
     * The field will be set to its default value. The hasKeyCode()
     * method will return false.
     */
    inline void clearKeyCode();

    /**
     * Checks whether the field "KeyCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyCode()). Otherwise it will return false.
     */
    inline bool hasKeyCode () const;

    /**
     * Returns the value of the member "KeyCode".
     *
     * Keycode
     *
     * @return The value of the field "KeyCode"
     */
    inline T_e32_KeyCode getKeyCode () const;

    /**
     * Sets the value of the member "KeyCode".
     *
     * Keycode
     *
     * @param KeyCode The value which will be set
     */
    inline void setKeyCode (T_e32_KeyCode KeyCode_);

    // API of field "KeyType"

    static const int kKeyType = 1;

    /**
     * Clears the field "KeyType".
     *
     * The field will be set to its default value. The hasKeyType()
     * method will return false.
     */
    inline void clearKeyType();

    /**
     * Checks whether the field "KeyType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyType()). Otherwise it will return false.
     */
    inline bool hasKeyType () const;

    /**
     * Returns the value of the member "KeyType".
     *
     * Type of key
     *
     * @return The value of the field "KeyType"
     */
    inline T_e32_KeyType getKeyType () const;

    /**
     * Sets the value of the member "KeyType".
     *
     * Type of key
     *
     * @param KeyType The value which will be set
     */
    inline void setKeyType (T_e32_KeyType KeyType_);

    static const T_KeyInfo &getDefaultInstance();

private:

    inline void set_has_KeyCode ();

    inline void clear_has_KeyCode ();

    inline void set_has_KeyType ();

    inline void clear_has_KeyType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e32_KeyCode _KeyCode;

    T_e32_KeyType _KeyType;

};

/**
 * This structure contains info about Keys supported.
 * The list of supported keys is for a particular technology indicated by device category.
 */
class T_TechnologyKeyConfig {
public:

    /**
     * Default constructor
     */
    inline  T_TechnologyKeyConfig ();

    /**
     * Copy constructor
     */
    inline  T_TechnologyKeyConfig (const T_TechnologyKeyConfig &rhs);

    /**
     * All fields constructor
     */
    inline  T_TechnologyKeyConfig (T_e8_DeviceCategory enDeviceCategory_, const ::std::vector< T_KeyInfo >& KeyInfo_);

    /**
     * Destructor
     */
    inline  ~T_TechnologyKeyConfig();

    /**
     * Assignment operator
     */
    inline T_TechnologyKeyConfig& operator = (const T_TechnologyKeyConfig& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TechnologyKeyConfig& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TechnologyKeyConfig& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TechnologyKeyConfig& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TechnologyKeyConfig& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enDeviceCategory"

    static const int kEnDeviceCategory = 0;

    /**
     * Clears the field "enDeviceCategory".
     *
     * The field will be set to its default value. The hasEnDeviceCategory()
     * method will return false.
     */
    inline void clearEnDeviceCategory();

    /**
     * Checks whether the field "enDeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasEnDeviceCategory () const;

    /**
     * Returns the value of the member "enDeviceCategory".
     *
     * Device Category
     *
     * @return The value of the field "enDeviceCategory"
     */
    inline T_e8_DeviceCategory getEnDeviceCategory () const;

    /**
     * Sets the value of the member "enDeviceCategory".
     *
     * Device Category
     *
     * @param enDeviceCategory The value which will be set
     */
    inline void setEnDeviceCategory (T_e8_DeviceCategory enDeviceCategory_);

    // API of field "KeyInfo"

    static const int kKeyInfo = 1;

    /**
     * Clears the field "KeyInfo".
     *
     * The field will be set to its default value. The hasKeyInfo()
     * method will return false.
     */
    inline void clearKeyInfo();

    /**
     * Checks whether the field "KeyInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyInfo()). Otherwise it will return false.
     */
    inline bool hasKeyInfo () const;

    /**
     * Returns the value of the member "KeyInfo".
     *
     * List of KeyCodes supported
     *
     * @return The value of the field "KeyInfo"
     */
    inline const ::std::vector< T_KeyInfo >& getKeyInfo () const;

    /**
     * Retrieves the value of the field "KeyInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "KeyInfo".
     */
    inline ::std::vector< T_KeyInfo >& getKeyInfoMutable ();

    /**
     * Sets the value of the member "KeyInfo".
     *
     * List of KeyCodes supported
     *
     * @param KeyInfo The value which will be set
     */
    inline void setKeyInfo (const ::std::vector< T_KeyInfo >& KeyInfo_);

    static const T_TechnologyKeyConfig &getDefaultInstance();

private:

    static const ::std::vector< T_KeyInfo >& getT_KeyInfoList_DefaultInstance ();

    inline void set_has_enDeviceCategory ();

    inline void clear_has_enDeviceCategory ();

    inline void set_has_KeyInfo ();

    inline void clear_has_KeyInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_DeviceCategory _enDeviceCategory;

    ::std::vector< T_KeyInfo > _KeyInfo;

};

inline  T_ProjectionCapability::T_ProjectionCapability ()  :
    _enUSBPortType (::midw_smartphoneint_fi_types::T_e8_USBPortType__PORT_TYPE_NOT_KNOWN),
    _enDeviceType (::midw_smartphoneint_fi_types::T_e8_DeviceType__DEVICE_TYPE_UNKNOWN),
    _enCarplayProjection (::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN),
    _enAndroidProjection (::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN),
    _enMirrorlinkProjection (::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN),
    _enMySPINProjection (::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN),
    _enCarlifeProjection (::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN),
    _enOnCarProjection (::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ProjectionCapability::T_ProjectionCapability (const T_ProjectionCapability &rhs)  :
    _enUSBPortType (::midw_smartphoneint_fi_types::T_e8_USBPortType__PORT_TYPE_NOT_KNOWN),
    _enDeviceType (::midw_smartphoneint_fi_types::T_e8_DeviceType__DEVICE_TYPE_UNKNOWN),
    _enCarplayProjection (::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN),
    _enAndroidProjection (::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN),
    _enMirrorlinkProjection (::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN),
    _enMySPINProjection (::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN),
    _enCarlifeProjection (::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN),
    _enOnCarProjection (::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ProjectionCapability::T_ProjectionCapability (T_e8_USBPortType enUSBPortType_, T_e8_DeviceType enDeviceType_, T_e8_SupportInfo enCarplayProjection_, T_e8_SupportInfo enAndroidProjection_, T_e8_SupportInfo enMirrorlinkProjection_, T_e8_SupportInfo enMySPINProjection_, T_e8_SupportInfo enCarlifeProjection_, T_e8_SupportInfo enOnCarProjection_)  :
    _enUSBPortType (enUSBPortType_),
    _enDeviceType (enDeviceType_),
    _enCarplayProjection (enCarplayProjection_),
    _enAndroidProjection (enAndroidProjection_),
    _enMirrorlinkProjection (enMirrorlinkProjection_),
    _enMySPINProjection (enMySPINProjection_),
    _enCarlifeProjection (enCarlifeProjection_),
    _enOnCarProjection (enOnCarProjection_)
{
    #ifndef NDEBUG
    if (!(T_e8_USBPortType_IsValid(enUSBPortType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUSBPortType_, "T_e8_USBPortType", "enUSBPortType", "T_ProjectionCapability");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_DeviceType_IsValid(enDeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceType_, "T_e8_DeviceType", "enDeviceType", "T_ProjectionCapability");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SupportInfo_IsValid(enCarplayProjection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enCarplayProjection_, "T_e8_SupportInfo", "enCarplayProjection", "T_ProjectionCapability");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SupportInfo_IsValid(enAndroidProjection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enAndroidProjection_, "T_e8_SupportInfo", "enAndroidProjection", "T_ProjectionCapability");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SupportInfo_IsValid(enMirrorlinkProjection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enMirrorlinkProjection_, "T_e8_SupportInfo", "enMirrorlinkProjection", "T_ProjectionCapability");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SupportInfo_IsValid(enMySPINProjection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enMySPINProjection_, "T_e8_SupportInfo", "enMySPINProjection", "T_ProjectionCapability");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SupportInfo_IsValid(enCarlifeProjection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enCarlifeProjection_, "T_e8_SupportInfo", "enCarlifeProjection", "T_ProjectionCapability");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SupportInfo_IsValid(enOnCarProjection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enOnCarProjection_, "T_e8_SupportInfo", "enOnCarProjection", "T_ProjectionCapability");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ProjectionCapability::~T_ProjectionCapability() {
}

inline T_ProjectionCapability& T_ProjectionCapability::operator = (const T_ProjectionCapability& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnUSBPortType()) {
            setEnUSBPortType(rhs.getEnUSBPortType());
        } else {
            clearEnUSBPortType();
        }
        if (rhs.hasEnDeviceType()) {
            setEnDeviceType(rhs.getEnDeviceType());
        } else {
            clearEnDeviceType();
        }
        if (rhs.hasEnCarplayProjection()) {
            setEnCarplayProjection(rhs.getEnCarplayProjection());
        } else {
            clearEnCarplayProjection();
        }
        if (rhs.hasEnAndroidProjection()) {
            setEnAndroidProjection(rhs.getEnAndroidProjection());
        } else {
            clearEnAndroidProjection();
        }
        if (rhs.hasEnMirrorlinkProjection()) {
            setEnMirrorlinkProjection(rhs.getEnMirrorlinkProjection());
        } else {
            clearEnMirrorlinkProjection();
        }
        if (rhs.hasEnMySPINProjection()) {
            setEnMySPINProjection(rhs.getEnMySPINProjection());
        } else {
            clearEnMySPINProjection();
        }
        if (rhs.hasEnCarlifeProjection()) {
            setEnCarlifeProjection(rhs.getEnCarlifeProjection());
        } else {
            clearEnCarlifeProjection();
        }
        if (rhs.hasEnOnCarProjection()) {
            setEnOnCarProjection(rhs.getEnOnCarProjection());
        } else {
            clearEnOnCarProjection();
        }
    }
    return *this;
}

inline bool T_ProjectionCapability::operator == (const T_ProjectionCapability& rhs) const {
    return (((!hasEnUSBPortType() && !rhs.hasEnUSBPortType()) || getEnUSBPortType() == rhs.getEnUSBPortType()) &&
        ((!hasEnDeviceType() && !rhs.hasEnDeviceType()) || getEnDeviceType() == rhs.getEnDeviceType()) &&
        ((!hasEnCarplayProjection() && !rhs.hasEnCarplayProjection()) || getEnCarplayProjection() == rhs.getEnCarplayProjection()) &&
        ((!hasEnAndroidProjection() && !rhs.hasEnAndroidProjection()) || getEnAndroidProjection() == rhs.getEnAndroidProjection()) &&
        ((!hasEnMirrorlinkProjection() && !rhs.hasEnMirrorlinkProjection()) || getEnMirrorlinkProjection() == rhs.getEnMirrorlinkProjection()) &&
        ((!hasEnMySPINProjection() && !rhs.hasEnMySPINProjection()) || getEnMySPINProjection() == rhs.getEnMySPINProjection()) &&
        ((!hasEnCarlifeProjection() && !rhs.hasEnCarlifeProjection()) || getEnCarlifeProjection() == rhs.getEnCarlifeProjection()) &&
        ((!hasEnOnCarProjection() && !rhs.hasEnOnCarProjection()) || getEnOnCarProjection() == rhs.getEnOnCarProjection()));
}

inline bool T_ProjectionCapability::operator != (const T_ProjectionCapability& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ProjectionCapability::operator < (const T_ProjectionCapability& rhs) const {
    if (hasEnUSBPortType() || rhs.hasEnUSBPortType()) {
        if ((uint32)getEnUSBPortType() < (uint32)rhs.getEnUSBPortType()) return true;
        if ((uint32)getEnUSBPortType() > (uint32)rhs.getEnUSBPortType()) return false;
    }
    if (hasEnDeviceType() || rhs.hasEnDeviceType()) {
        if ((uint32)getEnDeviceType() < (uint32)rhs.getEnDeviceType()) return true;
        if ((uint32)getEnDeviceType() > (uint32)rhs.getEnDeviceType()) return false;
    }
    if (hasEnCarplayProjection() || rhs.hasEnCarplayProjection()) {
        if ((uint32)getEnCarplayProjection() < (uint32)rhs.getEnCarplayProjection()) return true;
        if ((uint32)getEnCarplayProjection() > (uint32)rhs.getEnCarplayProjection()) return false;
    }
    if (hasEnAndroidProjection() || rhs.hasEnAndroidProjection()) {
        if ((uint32)getEnAndroidProjection() < (uint32)rhs.getEnAndroidProjection()) return true;
        if ((uint32)getEnAndroidProjection() > (uint32)rhs.getEnAndroidProjection()) return false;
    }
    if (hasEnMirrorlinkProjection() || rhs.hasEnMirrorlinkProjection()) {
        if ((uint32)getEnMirrorlinkProjection() < (uint32)rhs.getEnMirrorlinkProjection()) return true;
        if ((uint32)getEnMirrorlinkProjection() > (uint32)rhs.getEnMirrorlinkProjection()) return false;
    }
    if (hasEnMySPINProjection() || rhs.hasEnMySPINProjection()) {
        if ((uint32)getEnMySPINProjection() < (uint32)rhs.getEnMySPINProjection()) return true;
        if ((uint32)getEnMySPINProjection() > (uint32)rhs.getEnMySPINProjection()) return false;
    }
    if (hasEnCarlifeProjection() || rhs.hasEnCarlifeProjection()) {
        if ((uint32)getEnCarlifeProjection() < (uint32)rhs.getEnCarlifeProjection()) return true;
        if ((uint32)getEnCarlifeProjection() > (uint32)rhs.getEnCarlifeProjection()) return false;
    }
    if (hasEnOnCarProjection() || rhs.hasEnOnCarProjection()) {
        if ((uint32)getEnOnCarProjection() < (uint32)rhs.getEnOnCarProjection()) return true;
        if ((uint32)getEnOnCarProjection() > (uint32)rhs.getEnOnCarProjection()) return false;
    }
    return false;
}

inline bool T_ProjectionCapability::operator > (const T_ProjectionCapability& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ProjectionCapability::clear() {
    clearEnUSBPortType();
    clearEnDeviceType();
    clearEnCarplayProjection();
    clearEnAndroidProjection();
    clearEnMirrorlinkProjection();
    clearEnMySPINProjection();
    clearEnCarlifeProjection();
    clearEnOnCarProjection();
}

inline void T_ProjectionCapability::clearEnUSBPortType() {
    if (hasEnUSBPortType()) {
         clear_has_enUSBPortType();
        _enUSBPortType = ::midw_smartphoneint_fi_types::T_e8_USBPortType__PORT_TYPE_NOT_KNOWN;
     }
}

inline bool T_ProjectionCapability::hasEnUSBPortType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_USBPortType T_ProjectionCapability::getEnUSBPortType () const {
    return _enUSBPortType;
}

inline void T_ProjectionCapability::setEnUSBPortType (T_e8_USBPortType enUSBPortType_) {
    #ifndef NDEBUG
    if (!(T_e8_USBPortType_IsValid(enUSBPortType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUSBPortType_, "T_e8_USBPortType", "enUSBPortType", "T_ProjectionCapability");
    }
    #endif
    set_has_enUSBPortType();
    this->_enUSBPortType = enUSBPortType_;
}

inline void T_ProjectionCapability::clearEnDeviceType() {
    if (hasEnDeviceType()) {
         clear_has_enDeviceType();
        _enDeviceType = ::midw_smartphoneint_fi_types::T_e8_DeviceType__DEVICE_TYPE_UNKNOWN;
     }
}

inline bool T_ProjectionCapability::hasEnDeviceType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_DeviceType T_ProjectionCapability::getEnDeviceType () const {
    return _enDeviceType;
}

inline void T_ProjectionCapability::setEnDeviceType (T_e8_DeviceType enDeviceType_) {
    #ifndef NDEBUG
    if (!(T_e8_DeviceType_IsValid(enDeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceType_, "T_e8_DeviceType", "enDeviceType", "T_ProjectionCapability");
    }
    #endif
    set_has_enDeviceType();
    this->_enDeviceType = enDeviceType_;
}

inline void T_ProjectionCapability::clearEnCarplayProjection() {
    if (hasEnCarplayProjection()) {
         clear_has_enCarplayProjection();
        _enCarplayProjection = ::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN;
     }
}

inline bool T_ProjectionCapability::hasEnCarplayProjection () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_SupportInfo T_ProjectionCapability::getEnCarplayProjection () const {
    return _enCarplayProjection;
}

inline void T_ProjectionCapability::setEnCarplayProjection (T_e8_SupportInfo enCarplayProjection_) {
    #ifndef NDEBUG
    if (!(T_e8_SupportInfo_IsValid(enCarplayProjection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enCarplayProjection_, "T_e8_SupportInfo", "enCarplayProjection", "T_ProjectionCapability");
    }
    #endif
    set_has_enCarplayProjection();
    this->_enCarplayProjection = enCarplayProjection_;
}

inline void T_ProjectionCapability::clearEnAndroidProjection() {
    if (hasEnAndroidProjection()) {
         clear_has_enAndroidProjection();
        _enAndroidProjection = ::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN;
     }
}

inline bool T_ProjectionCapability::hasEnAndroidProjection () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_SupportInfo T_ProjectionCapability::getEnAndroidProjection () const {
    return _enAndroidProjection;
}

inline void T_ProjectionCapability::setEnAndroidProjection (T_e8_SupportInfo enAndroidProjection_) {
    #ifndef NDEBUG
    if (!(T_e8_SupportInfo_IsValid(enAndroidProjection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enAndroidProjection_, "T_e8_SupportInfo", "enAndroidProjection", "T_ProjectionCapability");
    }
    #endif
    set_has_enAndroidProjection();
    this->_enAndroidProjection = enAndroidProjection_;
}

inline void T_ProjectionCapability::clearEnMirrorlinkProjection() {
    if (hasEnMirrorlinkProjection()) {
         clear_has_enMirrorlinkProjection();
        _enMirrorlinkProjection = ::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN;
     }
}

inline bool T_ProjectionCapability::hasEnMirrorlinkProjection () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_SupportInfo T_ProjectionCapability::getEnMirrorlinkProjection () const {
    return _enMirrorlinkProjection;
}

inline void T_ProjectionCapability::setEnMirrorlinkProjection (T_e8_SupportInfo enMirrorlinkProjection_) {
    #ifndef NDEBUG
    if (!(T_e8_SupportInfo_IsValid(enMirrorlinkProjection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enMirrorlinkProjection_, "T_e8_SupportInfo", "enMirrorlinkProjection", "T_ProjectionCapability");
    }
    #endif
    set_has_enMirrorlinkProjection();
    this->_enMirrorlinkProjection = enMirrorlinkProjection_;
}

inline void T_ProjectionCapability::clearEnMySPINProjection() {
    if (hasEnMySPINProjection()) {
         clear_has_enMySPINProjection();
        _enMySPINProjection = ::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN;
     }
}

inline bool T_ProjectionCapability::hasEnMySPINProjection () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_SupportInfo T_ProjectionCapability::getEnMySPINProjection () const {
    return _enMySPINProjection;
}

inline void T_ProjectionCapability::setEnMySPINProjection (T_e8_SupportInfo enMySPINProjection_) {
    #ifndef NDEBUG
    if (!(T_e8_SupportInfo_IsValid(enMySPINProjection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enMySPINProjection_, "T_e8_SupportInfo", "enMySPINProjection", "T_ProjectionCapability");
    }
    #endif
    set_has_enMySPINProjection();
    this->_enMySPINProjection = enMySPINProjection_;
}

inline void T_ProjectionCapability::clearEnCarlifeProjection() {
    if (hasEnCarlifeProjection()) {
         clear_has_enCarlifeProjection();
        _enCarlifeProjection = ::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN;
     }
}

inline bool T_ProjectionCapability::hasEnCarlifeProjection () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_SupportInfo T_ProjectionCapability::getEnCarlifeProjection () const {
    return _enCarlifeProjection;
}

inline void T_ProjectionCapability::setEnCarlifeProjection (T_e8_SupportInfo enCarlifeProjection_) {
    #ifndef NDEBUG
    if (!(T_e8_SupportInfo_IsValid(enCarlifeProjection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enCarlifeProjection_, "T_e8_SupportInfo", "enCarlifeProjection", "T_ProjectionCapability");
    }
    #endif
    set_has_enCarlifeProjection();
    this->_enCarlifeProjection = enCarlifeProjection_;
}

inline void T_ProjectionCapability::clearEnOnCarProjection() {
    if (hasEnOnCarProjection()) {
         clear_has_enOnCarProjection();
        _enOnCarProjection = ::midw_smartphoneint_fi_types::T_e8_SupportInfo__SUPPORT_NOT_KNOWN;
     }
}

inline bool T_ProjectionCapability::hasEnOnCarProjection () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline T_e8_SupportInfo T_ProjectionCapability::getEnOnCarProjection () const {
    return _enOnCarProjection;
}

inline void T_ProjectionCapability::setEnOnCarProjection (T_e8_SupportInfo enOnCarProjection_) {
    #ifndef NDEBUG
    if (!(T_e8_SupportInfo_IsValid(enOnCarProjection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enOnCarProjection_, "T_e8_SupportInfo", "enOnCarProjection", "T_ProjectionCapability");
    }
    #endif
    set_has_enOnCarProjection();
    this->_enOnCarProjection = enOnCarProjection_;
}

inline void T_ProjectionCapability::set_has_enUSBPortType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ProjectionCapability::clear_has_enUSBPortType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ProjectionCapability::set_has_enDeviceType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ProjectionCapability::clear_has_enDeviceType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ProjectionCapability::set_has_enCarplayProjection () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ProjectionCapability::clear_has_enCarplayProjection () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_ProjectionCapability::set_has_enAndroidProjection () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_ProjectionCapability::clear_has_enAndroidProjection () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_ProjectionCapability::set_has_enMirrorlinkProjection () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_ProjectionCapability::clear_has_enMirrorlinkProjection () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_ProjectionCapability::set_has_enMySPINProjection () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_ProjectionCapability::clear_has_enMySPINProjection () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_ProjectionCapability::set_has_enCarlifeProjection () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_ProjectionCapability::clear_has_enCarlifeProjection () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_ProjectionCapability::set_has_enOnCarProjection () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_ProjectionCapability::clear_has_enOnCarProjection () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_DeviceSelectionInfo::T_DeviceSelectionInfo ()  :
    _enDeviceSelectionState (::midw_smartphoneint_fi_types::T_e8_DeviceSelectionState__DEVICE_NOT_SELECTED),
    _enDeviceSelectionErrorType (::midw_smartphoneint_fi_types::T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_ERROR_NONE),
    _enDeviceSelectionProgressState (::midw_smartphoneint_fi_types::T_e8_DeviceSelectionProgressState__NOT_APPLICABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DeviceSelectionInfo::T_DeviceSelectionInfo (const T_DeviceSelectionInfo &rhs)  :
    _enDeviceSelectionState (::midw_smartphoneint_fi_types::T_e8_DeviceSelectionState__DEVICE_NOT_SELECTED),
    _enDeviceSelectionErrorType (::midw_smartphoneint_fi_types::T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_ERROR_NONE),
    _enDeviceSelectionProgressState (::midw_smartphoneint_fi_types::T_e8_DeviceSelectionProgressState__NOT_APPLICABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DeviceSelectionInfo::T_DeviceSelectionInfo (T_e8_DeviceSelectionState enDeviceSelectionState_, T_e8_DeviceSelectionErrorType enDeviceSelectionErrorType_, T_e8_DeviceSelectionProgressState enDeviceSelectionProgressState_)  :
    _enDeviceSelectionState (enDeviceSelectionState_),
    _enDeviceSelectionErrorType (enDeviceSelectionErrorType_),
    _enDeviceSelectionProgressState (enDeviceSelectionProgressState_)
{
    #ifndef NDEBUG
    if (!(T_e8_DeviceSelectionState_IsValid(enDeviceSelectionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceSelectionState_, "T_e8_DeviceSelectionState", "enDeviceSelectionState", "T_DeviceSelectionInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_DeviceSelectionErrorType_IsValid(enDeviceSelectionErrorType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceSelectionErrorType_, "T_e8_DeviceSelectionErrorType", "enDeviceSelectionErrorType", "T_DeviceSelectionInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_DeviceSelectionProgressState_IsValid(enDeviceSelectionProgressState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceSelectionProgressState_, "T_e8_DeviceSelectionProgressState", "enDeviceSelectionProgressState", "T_DeviceSelectionInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DeviceSelectionInfo::~T_DeviceSelectionInfo() {
}

inline T_DeviceSelectionInfo& T_DeviceSelectionInfo::operator = (const T_DeviceSelectionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnDeviceSelectionState()) {
            setEnDeviceSelectionState(rhs.getEnDeviceSelectionState());
        } else {
            clearEnDeviceSelectionState();
        }
        if (rhs.hasEnDeviceSelectionErrorType()) {
            setEnDeviceSelectionErrorType(rhs.getEnDeviceSelectionErrorType());
        } else {
            clearEnDeviceSelectionErrorType();
        }
        if (rhs.hasEnDeviceSelectionProgressState()) {
            setEnDeviceSelectionProgressState(rhs.getEnDeviceSelectionProgressState());
        } else {
            clearEnDeviceSelectionProgressState();
        }
    }
    return *this;
}

inline bool T_DeviceSelectionInfo::operator == (const T_DeviceSelectionInfo& rhs) const {
    return (((!hasEnDeviceSelectionState() && !rhs.hasEnDeviceSelectionState()) || getEnDeviceSelectionState() == rhs.getEnDeviceSelectionState()) &&
        ((!hasEnDeviceSelectionErrorType() && !rhs.hasEnDeviceSelectionErrorType()) || getEnDeviceSelectionErrorType() == rhs.getEnDeviceSelectionErrorType()) &&
        ((!hasEnDeviceSelectionProgressState() && !rhs.hasEnDeviceSelectionProgressState()) || getEnDeviceSelectionProgressState() == rhs.getEnDeviceSelectionProgressState()));
}

inline bool T_DeviceSelectionInfo::operator != (const T_DeviceSelectionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DeviceSelectionInfo::operator < (const T_DeviceSelectionInfo& rhs) const {
    if (hasEnDeviceSelectionState() || rhs.hasEnDeviceSelectionState()) {
        if ((uint32)getEnDeviceSelectionState() < (uint32)rhs.getEnDeviceSelectionState()) return true;
        if ((uint32)getEnDeviceSelectionState() > (uint32)rhs.getEnDeviceSelectionState()) return false;
    }
    if (hasEnDeviceSelectionErrorType() || rhs.hasEnDeviceSelectionErrorType()) {
        if ((uint32)getEnDeviceSelectionErrorType() < (uint32)rhs.getEnDeviceSelectionErrorType()) return true;
        if ((uint32)getEnDeviceSelectionErrorType() > (uint32)rhs.getEnDeviceSelectionErrorType()) return false;
    }
    if (hasEnDeviceSelectionProgressState() || rhs.hasEnDeviceSelectionProgressState()) {
        if ((uint32)getEnDeviceSelectionProgressState() < (uint32)rhs.getEnDeviceSelectionProgressState()) return true;
        if ((uint32)getEnDeviceSelectionProgressState() > (uint32)rhs.getEnDeviceSelectionProgressState()) return false;
    }
    return false;
}

inline bool T_DeviceSelectionInfo::operator > (const T_DeviceSelectionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DeviceSelectionInfo::clear() {
    clearEnDeviceSelectionState();
    clearEnDeviceSelectionErrorType();
    clearEnDeviceSelectionProgressState();
}

inline void T_DeviceSelectionInfo::clearEnDeviceSelectionState() {
    if (hasEnDeviceSelectionState()) {
         clear_has_enDeviceSelectionState();
        _enDeviceSelectionState = ::midw_smartphoneint_fi_types::T_e8_DeviceSelectionState__DEVICE_NOT_SELECTED;
     }
}

inline bool T_DeviceSelectionInfo::hasEnDeviceSelectionState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_DeviceSelectionState T_DeviceSelectionInfo::getEnDeviceSelectionState () const {
    return _enDeviceSelectionState;
}

inline void T_DeviceSelectionInfo::setEnDeviceSelectionState (T_e8_DeviceSelectionState enDeviceSelectionState_) {
    #ifndef NDEBUG
    if (!(T_e8_DeviceSelectionState_IsValid(enDeviceSelectionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceSelectionState_, "T_e8_DeviceSelectionState", "enDeviceSelectionState", "T_DeviceSelectionInfo");
    }
    #endif
    set_has_enDeviceSelectionState();
    this->_enDeviceSelectionState = enDeviceSelectionState_;
}

inline void T_DeviceSelectionInfo::clearEnDeviceSelectionErrorType() {
    if (hasEnDeviceSelectionErrorType()) {
         clear_has_enDeviceSelectionErrorType();
        _enDeviceSelectionErrorType = ::midw_smartphoneint_fi_types::T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_ERROR_NONE;
     }
}

inline bool T_DeviceSelectionInfo::hasEnDeviceSelectionErrorType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_DeviceSelectionErrorType T_DeviceSelectionInfo::getEnDeviceSelectionErrorType () const {
    return _enDeviceSelectionErrorType;
}

inline void T_DeviceSelectionInfo::setEnDeviceSelectionErrorType (T_e8_DeviceSelectionErrorType enDeviceSelectionErrorType_) {
    #ifndef NDEBUG
    if (!(T_e8_DeviceSelectionErrorType_IsValid(enDeviceSelectionErrorType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceSelectionErrorType_, "T_e8_DeviceSelectionErrorType", "enDeviceSelectionErrorType", "T_DeviceSelectionInfo");
    }
    #endif
    set_has_enDeviceSelectionErrorType();
    this->_enDeviceSelectionErrorType = enDeviceSelectionErrorType_;
}

inline void T_DeviceSelectionInfo::clearEnDeviceSelectionProgressState() {
    if (hasEnDeviceSelectionProgressState()) {
         clear_has_enDeviceSelectionProgressState();
        _enDeviceSelectionProgressState = ::midw_smartphoneint_fi_types::T_e8_DeviceSelectionProgressState__NOT_APPLICABLE;
     }
}

inline bool T_DeviceSelectionInfo::hasEnDeviceSelectionProgressState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_DeviceSelectionProgressState T_DeviceSelectionInfo::getEnDeviceSelectionProgressState () const {
    return _enDeviceSelectionProgressState;
}

inline void T_DeviceSelectionInfo::setEnDeviceSelectionProgressState (T_e8_DeviceSelectionProgressState enDeviceSelectionProgressState_) {
    #ifndef NDEBUG
    if (!(T_e8_DeviceSelectionProgressState_IsValid(enDeviceSelectionProgressState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceSelectionProgressState_, "T_e8_DeviceSelectionProgressState", "enDeviceSelectionProgressState", "T_DeviceSelectionInfo");
    }
    #endif
    set_has_enDeviceSelectionProgressState();
    this->_enDeviceSelectionProgressState = enDeviceSelectionProgressState_;
}

inline void T_DeviceSelectionInfo::set_has_enDeviceSelectionState () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DeviceSelectionInfo::clear_has_enDeviceSelectionState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DeviceSelectionInfo::set_has_enDeviceSelectionErrorType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DeviceSelectionInfo::clear_has_enDeviceSelectionErrorType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DeviceSelectionInfo::set_has_enDeviceSelectionProgressState () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DeviceSelectionInfo::clear_has_enDeviceSelectionProgressState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_VersionInfo::T_VersionInfo ()  :
    _szMinorVersion (),
    _szMajorVersion (),
    _szPatchVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_VersionInfo::T_VersionInfo (const T_VersionInfo &rhs)  :
    _szMinorVersion (),
    _szMajorVersion (),
    _szPatchVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_VersionInfo::T_VersionInfo (const ::std::string& szMinorVersion_, const ::std::string& szMajorVersion_, const ::std::string& szPatchVersion_)  :
    _szMinorVersion (szMinorVersion_),
    _szMajorVersion (szMajorVersion_),
    _szPatchVersion (szPatchVersion_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szMinorVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szMajorVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szPatchVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_VersionInfo::~T_VersionInfo() {
}

inline T_VersionInfo& T_VersionInfo::operator = (const T_VersionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSzMinorVersion()) {
            setSzMinorVersion(rhs.getSzMinorVersion());
        } else {
            clearSzMinorVersion();
        }
        if (rhs.hasSzMajorVersion()) {
            setSzMajorVersion(rhs.getSzMajorVersion());
        } else {
            clearSzMajorVersion();
        }
        if (rhs.hasSzPatchVersion()) {
            setSzPatchVersion(rhs.getSzPatchVersion());
        } else {
            clearSzPatchVersion();
        }
    }
    return *this;
}

inline bool T_VersionInfo::operator == (const T_VersionInfo& rhs) const {
    return (((!hasSzMinorVersion() && !rhs.hasSzMinorVersion()) || getSzMinorVersion() == rhs.getSzMinorVersion()) &&
        ((!hasSzMajorVersion() && !rhs.hasSzMajorVersion()) || getSzMajorVersion() == rhs.getSzMajorVersion()) &&
        ((!hasSzPatchVersion() && !rhs.hasSzPatchVersion()) || getSzPatchVersion() == rhs.getSzPatchVersion()));
}

inline bool T_VersionInfo::operator != (const T_VersionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_VersionInfo::operator < (const T_VersionInfo& rhs) const {
    if (hasSzMinorVersion() || rhs.hasSzMinorVersion()) {
        if (getSzMinorVersion() < rhs.getSzMinorVersion()) return true;
        if (getSzMinorVersion() > rhs.getSzMinorVersion()) return false;
    }
    if (hasSzMajorVersion() || rhs.hasSzMajorVersion()) {
        if (getSzMajorVersion() < rhs.getSzMajorVersion()) return true;
        if (getSzMajorVersion() > rhs.getSzMajorVersion()) return false;
    }
    if (hasSzPatchVersion() || rhs.hasSzPatchVersion()) {
        if (getSzPatchVersion() < rhs.getSzPatchVersion()) return true;
        if (getSzPatchVersion() > rhs.getSzPatchVersion()) return false;
    }
    return false;
}

inline bool T_VersionInfo::operator > (const T_VersionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_VersionInfo::clear() {
    clearSzMinorVersion();
    clearSzMajorVersion();
    clearSzPatchVersion();
}

inline void T_VersionInfo::clearSzMinorVersion() {
    if (hasSzMinorVersion()) {
         clear_has_szMinorVersion();
        _szMinorVersion.clear();
     }
}

inline bool T_VersionInfo::hasSzMinorVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_VersionInfo::getSzMinorVersion () const {
    return _szMinorVersion;
}

inline ::std::string& T_VersionInfo::getSzMinorVersionMutable () {
    set_has_szMinorVersion();
    return _szMinorVersion;
}

inline void T_VersionInfo::setSzMinorVersion (const ::std::string& szMinorVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szMinorVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szMinorVersion();
    this->_szMinorVersion = szMinorVersion_;
}

inline void T_VersionInfo::setSzMinorVersion (const char* szMinorVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szMinorVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szMinorVersion();
    this->_szMinorVersion.assign(szMinorVersion_);
}

inline void T_VersionInfo::setSzMinorVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szMinorVersion();
    this->_szMinorVersion.assign(value, size);
}

inline void T_VersionInfo::clearSzMajorVersion() {
    if (hasSzMajorVersion()) {
         clear_has_szMajorVersion();
        _szMajorVersion.clear();
     }
}

inline bool T_VersionInfo::hasSzMajorVersion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_VersionInfo::getSzMajorVersion () const {
    return _szMajorVersion;
}

inline ::std::string& T_VersionInfo::getSzMajorVersionMutable () {
    set_has_szMajorVersion();
    return _szMajorVersion;
}

inline void T_VersionInfo::setSzMajorVersion (const ::std::string& szMajorVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szMajorVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szMajorVersion();
    this->_szMajorVersion = szMajorVersion_;
}

inline void T_VersionInfo::setSzMajorVersion (const char* szMajorVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szMajorVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szMajorVersion();
    this->_szMajorVersion.assign(szMajorVersion_);
}

inline void T_VersionInfo::setSzMajorVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szMajorVersion();
    this->_szMajorVersion.assign(value, size);
}

inline void T_VersionInfo::clearSzPatchVersion() {
    if (hasSzPatchVersion()) {
         clear_has_szPatchVersion();
        _szPatchVersion.clear();
     }
}

inline bool T_VersionInfo::hasSzPatchVersion () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_VersionInfo::getSzPatchVersion () const {
    return _szPatchVersion;
}

inline ::std::string& T_VersionInfo::getSzPatchVersionMutable () {
    set_has_szPatchVersion();
    return _szPatchVersion;
}

inline void T_VersionInfo::setSzPatchVersion (const ::std::string& szPatchVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szPatchVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szPatchVersion();
    this->_szPatchVersion = szPatchVersion_;
}

inline void T_VersionInfo::setSzPatchVersion (const char* szPatchVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szPatchVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szPatchVersion();
    this->_szPatchVersion.assign(szPatchVersion_);
}

inline void T_VersionInfo::setSzPatchVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szPatchVersion();
    this->_szPatchVersion.assign(value, size);
}

inline void T_VersionInfo::set_has_szMinorVersion () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_VersionInfo::clear_has_szMinorVersion () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_VersionInfo::set_has_szMajorVersion () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_VersionInfo::clear_has_szMajorVersion () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_VersionInfo::set_has_szPatchVersion () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_VersionInfo::clear_has_szPatchVersion () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_DeviceDetails::T_DeviceDetails ()  :
    _u32DeviceHandle (0u),
    _szDeviceName (),
    _enDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_UNKNOWN),
    _szDeviceModelName (),
    _szDeviceManufacturerName (),
    _enDeviceConnectionStatus (::midw_smartphoneint_fi_types::T_e8_DeviceConnectionStatus__DEV_NOT_CONNECTED),
    _enDeviceConnectionType (::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType__UNKNOWN_CONNECTION),
    _rVersionInfo (),
    _enDeviceUsageEnabled (::midw_smartphoneint_fi_types::T_e8_EnabledInfo__USAGE_DISABLED),
    _bSelectedDevice (false),
    _bDAPSupport (false),
    _rProjectionCapability (),
    _szBTAddress (),
    _rDeviceSelectionInfo (),
    _szSerialNumber (),
    _enUserAuthorizationStatus (::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus__USER_AUTH_UNKNOWN),
    _enSessionTransportType (::midw_smartphoneint_fi_types::T_e8_SessionTransportType__SESSION_TRANSPORT_UNKNOWN),
    _u32VendorID (0u),
    _u32ProductID (0u),
    _szSystemPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DeviceDetails::T_DeviceDetails (const T_DeviceDetails &rhs)  :
    _u32DeviceHandle (0u),
    _szDeviceName (),
    _enDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_UNKNOWN),
    _szDeviceModelName (),
    _szDeviceManufacturerName (),
    _enDeviceConnectionStatus (::midw_smartphoneint_fi_types::T_e8_DeviceConnectionStatus__DEV_NOT_CONNECTED),
    _enDeviceConnectionType (::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType__UNKNOWN_CONNECTION),
    _rVersionInfo (),
    _enDeviceUsageEnabled (::midw_smartphoneint_fi_types::T_e8_EnabledInfo__USAGE_DISABLED),
    _bSelectedDevice (false),
    _bDAPSupport (false),
    _rProjectionCapability (),
    _szBTAddress (),
    _rDeviceSelectionInfo (),
    _szSerialNumber (),
    _enUserAuthorizationStatus (::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus__USER_AUTH_UNKNOWN),
    _enSessionTransportType (::midw_smartphoneint_fi_types::T_e8_SessionTransportType__SESSION_TRANSPORT_UNKNOWN),
    _u32VendorID (0u),
    _u32ProductID (0u),
    _szSystemPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DeviceDetails::T_DeviceDetails (uint32 u32DeviceHandle_, const ::std::string& szDeviceName_, T_e8_DeviceCategory enDeviceCategory_, const ::std::string& szDeviceModelName_, const ::std::string& szDeviceManufacturerName_, T_e8_DeviceConnectionStatus enDeviceConnectionStatus_, T_e8_DeviceConnectionType enDeviceConnectionType_, const T_VersionInfo& rVersionInfo_, T_e8_EnabledInfo enDeviceUsageEnabled_, bool bSelectedDevice_, bool bDAPSupport_, const T_ProjectionCapability& rProjectionCapability_, const ::std::string& szBTAddress_, const T_DeviceSelectionInfo& rDeviceSelectionInfo_, const ::std::string& szSerialNumber_, T_e8_UserAuthorizationStatus enUserAuthorizationStatus_, T_e8_SessionTransportType enSessionTransportType_, uint32 u32VendorID_, uint32 u32ProductID_, const ::std::string& szSystemPath_)  :
    _u32DeviceHandle (u32DeviceHandle_),
    _szDeviceName (szDeviceName_),
    _enDeviceCategory (enDeviceCategory_),
    _szDeviceModelName (szDeviceModelName_),
    _szDeviceManufacturerName (szDeviceManufacturerName_),
    _enDeviceConnectionStatus (enDeviceConnectionStatus_),
    _enDeviceConnectionType (enDeviceConnectionType_),
    _rVersionInfo (rVersionInfo_),
    _enDeviceUsageEnabled (enDeviceUsageEnabled_),
    _bSelectedDevice (bSelectedDevice_),
    _bDAPSupport (bDAPSupport_),
    _rProjectionCapability (rProjectionCapability_),
    _szBTAddress (szBTAddress_),
    _rDeviceSelectionInfo (rDeviceSelectionInfo_),
    _szSerialNumber (szSerialNumber_),
    _enUserAuthorizationStatus (enUserAuthorizationStatus_),
    _enSessionTransportType (enSessionTransportType_),
    _u32VendorID (u32VendorID_),
    _u32ProductID (u32ProductID_),
    _szSystemPath (szSystemPath_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_DeviceCategory_IsValid(enDeviceCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceCategory_, "T_e8_DeviceCategory", "enDeviceCategory", "T_DeviceDetails");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceModelName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceManufacturerName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_DeviceConnectionStatus_IsValid(enDeviceConnectionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceConnectionStatus_, "T_e8_DeviceConnectionStatus", "enDeviceConnectionStatus", "T_DeviceDetails");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_DeviceConnectionType_IsValid(enDeviceConnectionType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceConnectionType_, "T_e8_DeviceConnectionType", "enDeviceConnectionType", "T_DeviceDetails");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_EnabledInfo_IsValid(enDeviceUsageEnabled_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceUsageEnabled_, "T_e8_EnabledInfo", "enDeviceUsageEnabled", "T_DeviceDetails");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szBTAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_UserAuthorizationStatus_IsValid(enUserAuthorizationStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUserAuthorizationStatus_, "T_e8_UserAuthorizationStatus", "enUserAuthorizationStatus", "T_DeviceDetails");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SessionTransportType_IsValid(enSessionTransportType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enSessionTransportType_, "T_e8_SessionTransportType", "enSessionTransportType", "T_DeviceDetails");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szSystemPath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DeviceDetails::~T_DeviceDetails() {
}

inline T_DeviceDetails& T_DeviceDetails::operator = (const T_DeviceDetails& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32DeviceHandle()) {
            setU32DeviceHandle(rhs.getU32DeviceHandle());
        } else {
            clearU32DeviceHandle();
        }
        if (rhs.hasSzDeviceName()) {
            setSzDeviceName(rhs.getSzDeviceName());
        } else {
            clearSzDeviceName();
        }
        if (rhs.hasEnDeviceCategory()) {
            setEnDeviceCategory(rhs.getEnDeviceCategory());
        } else {
            clearEnDeviceCategory();
        }
        if (rhs.hasSzDeviceModelName()) {
            setSzDeviceModelName(rhs.getSzDeviceModelName());
        } else {
            clearSzDeviceModelName();
        }
        if (rhs.hasSzDeviceManufacturerName()) {
            setSzDeviceManufacturerName(rhs.getSzDeviceManufacturerName());
        } else {
            clearSzDeviceManufacturerName();
        }
        if (rhs.hasEnDeviceConnectionStatus()) {
            setEnDeviceConnectionStatus(rhs.getEnDeviceConnectionStatus());
        } else {
            clearEnDeviceConnectionStatus();
        }
        if (rhs.hasEnDeviceConnectionType()) {
            setEnDeviceConnectionType(rhs.getEnDeviceConnectionType());
        } else {
            clearEnDeviceConnectionType();
        }
        if (rhs.hasRVersionInfo()) {
            setRVersionInfo(rhs.getRVersionInfo());
        } else {
            clearRVersionInfo();
        }
        if (rhs.hasEnDeviceUsageEnabled()) {
            setEnDeviceUsageEnabled(rhs.getEnDeviceUsageEnabled());
        } else {
            clearEnDeviceUsageEnabled();
        }
        if (rhs.hasBSelectedDevice()) {
            setBSelectedDevice(rhs.getBSelectedDevice());
        } else {
            clearBSelectedDevice();
        }
        if (rhs.hasBDAPSupport()) {
            setBDAPSupport(rhs.getBDAPSupport());
        } else {
            clearBDAPSupport();
        }
        if (rhs.hasRProjectionCapability()) {
            setRProjectionCapability(rhs.getRProjectionCapability());
        } else {
            clearRProjectionCapability();
        }
        if (rhs.hasSzBTAddress()) {
            setSzBTAddress(rhs.getSzBTAddress());
        } else {
            clearSzBTAddress();
        }
        if (rhs.hasRDeviceSelectionInfo()) {
            setRDeviceSelectionInfo(rhs.getRDeviceSelectionInfo());
        } else {
            clearRDeviceSelectionInfo();
        }
        if (rhs.hasSzSerialNumber()) {
            setSzSerialNumber(rhs.getSzSerialNumber());
        } else {
            clearSzSerialNumber();
        }
        if (rhs.hasEnUserAuthorizationStatus()) {
            setEnUserAuthorizationStatus(rhs.getEnUserAuthorizationStatus());
        } else {
            clearEnUserAuthorizationStatus();
        }
        if (rhs.hasEnSessionTransportType()) {
            setEnSessionTransportType(rhs.getEnSessionTransportType());
        } else {
            clearEnSessionTransportType();
        }
        if (rhs.hasU32VendorID()) {
            setU32VendorID(rhs.getU32VendorID());
        } else {
            clearU32VendorID();
        }
        if (rhs.hasU32ProductID()) {
            setU32ProductID(rhs.getU32ProductID());
        } else {
            clearU32ProductID();
        }
        if (rhs.hasSzSystemPath()) {
            setSzSystemPath(rhs.getSzSystemPath());
        } else {
            clearSzSystemPath();
        }
    }
    return *this;
}

inline bool T_DeviceDetails::operator == (const T_DeviceDetails& rhs) const {
    return (((!hasU32DeviceHandle() && !rhs.hasU32DeviceHandle()) || getU32DeviceHandle() == rhs.getU32DeviceHandle()) &&
        ((!hasSzDeviceName() && !rhs.hasSzDeviceName()) || getSzDeviceName() == rhs.getSzDeviceName()) &&
        ((!hasEnDeviceCategory() && !rhs.hasEnDeviceCategory()) || getEnDeviceCategory() == rhs.getEnDeviceCategory()) &&
        ((!hasSzDeviceModelName() && !rhs.hasSzDeviceModelName()) || getSzDeviceModelName() == rhs.getSzDeviceModelName()) &&
        ((!hasSzDeviceManufacturerName() && !rhs.hasSzDeviceManufacturerName()) || getSzDeviceManufacturerName() == rhs.getSzDeviceManufacturerName()) &&
        ((!hasEnDeviceConnectionStatus() && !rhs.hasEnDeviceConnectionStatus()) || getEnDeviceConnectionStatus() == rhs.getEnDeviceConnectionStatus()) &&
        ((!hasEnDeviceConnectionType() && !rhs.hasEnDeviceConnectionType()) || getEnDeviceConnectionType() == rhs.getEnDeviceConnectionType()) &&
        ((!hasRVersionInfo() && !rhs.hasRVersionInfo()) || getRVersionInfo() == rhs.getRVersionInfo()) &&
        ((!hasEnDeviceUsageEnabled() && !rhs.hasEnDeviceUsageEnabled()) || getEnDeviceUsageEnabled() == rhs.getEnDeviceUsageEnabled()) &&
        ((!hasBSelectedDevice() && !rhs.hasBSelectedDevice()) || getBSelectedDevice() == rhs.getBSelectedDevice()) &&
        ((!hasBDAPSupport() && !rhs.hasBDAPSupport()) || getBDAPSupport() == rhs.getBDAPSupport()) &&
        ((!hasRProjectionCapability() && !rhs.hasRProjectionCapability()) || getRProjectionCapability() == rhs.getRProjectionCapability()) &&
        ((!hasSzBTAddress() && !rhs.hasSzBTAddress()) || getSzBTAddress() == rhs.getSzBTAddress()) &&
        ((!hasRDeviceSelectionInfo() && !rhs.hasRDeviceSelectionInfo()) || getRDeviceSelectionInfo() == rhs.getRDeviceSelectionInfo()) &&
        ((!hasSzSerialNumber() && !rhs.hasSzSerialNumber()) || getSzSerialNumber() == rhs.getSzSerialNumber()) &&
        ((!hasEnUserAuthorizationStatus() && !rhs.hasEnUserAuthorizationStatus()) || getEnUserAuthorizationStatus() == rhs.getEnUserAuthorizationStatus()) &&
        ((!hasEnSessionTransportType() && !rhs.hasEnSessionTransportType()) || getEnSessionTransportType() == rhs.getEnSessionTransportType()) &&
        ((!hasU32VendorID() && !rhs.hasU32VendorID()) || getU32VendorID() == rhs.getU32VendorID()) &&
        ((!hasU32ProductID() && !rhs.hasU32ProductID()) || getU32ProductID() == rhs.getU32ProductID()) &&
        ((!hasSzSystemPath() && !rhs.hasSzSystemPath()) || getSzSystemPath() == rhs.getSzSystemPath()));
}

inline bool T_DeviceDetails::operator != (const T_DeviceDetails& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DeviceDetails::operator < (const T_DeviceDetails& rhs) const {
    if (hasU32DeviceHandle() || rhs.hasU32DeviceHandle()) {
        if (getU32DeviceHandle() < rhs.getU32DeviceHandle()) return true;
        if (getU32DeviceHandle() > rhs.getU32DeviceHandle()) return false;
    }
    if (hasSzDeviceName() || rhs.hasSzDeviceName()) {
        if (getSzDeviceName() < rhs.getSzDeviceName()) return true;
        if (getSzDeviceName() > rhs.getSzDeviceName()) return false;
    }
    if (hasEnDeviceCategory() || rhs.hasEnDeviceCategory()) {
        if ((uint32)getEnDeviceCategory() < (uint32)rhs.getEnDeviceCategory()) return true;
        if ((uint32)getEnDeviceCategory() > (uint32)rhs.getEnDeviceCategory()) return false;
    }
    if (hasSzDeviceModelName() || rhs.hasSzDeviceModelName()) {
        if (getSzDeviceModelName() < rhs.getSzDeviceModelName()) return true;
        if (getSzDeviceModelName() > rhs.getSzDeviceModelName()) return false;
    }
    if (hasSzDeviceManufacturerName() || rhs.hasSzDeviceManufacturerName()) {
        if (getSzDeviceManufacturerName() < rhs.getSzDeviceManufacturerName()) return true;
        if (getSzDeviceManufacturerName() > rhs.getSzDeviceManufacturerName()) return false;
    }
    if (hasEnDeviceConnectionStatus() || rhs.hasEnDeviceConnectionStatus()) {
        if ((uint32)getEnDeviceConnectionStatus() < (uint32)rhs.getEnDeviceConnectionStatus()) return true;
        if ((uint32)getEnDeviceConnectionStatus() > (uint32)rhs.getEnDeviceConnectionStatus()) return false;
    }
    if (hasEnDeviceConnectionType() || rhs.hasEnDeviceConnectionType()) {
        if ((uint32)getEnDeviceConnectionType() < (uint32)rhs.getEnDeviceConnectionType()) return true;
        if ((uint32)getEnDeviceConnectionType() > (uint32)rhs.getEnDeviceConnectionType()) return false;
    }
    if (hasRVersionInfo() || rhs.hasRVersionInfo()) {
        if (getRVersionInfo() < rhs.getRVersionInfo()) return true;
        if (getRVersionInfo() > rhs.getRVersionInfo()) return false;
    }
    if (hasEnDeviceUsageEnabled() || rhs.hasEnDeviceUsageEnabled()) {
        if ((uint32)getEnDeviceUsageEnabled() < (uint32)rhs.getEnDeviceUsageEnabled()) return true;
        if ((uint32)getEnDeviceUsageEnabled() > (uint32)rhs.getEnDeviceUsageEnabled()) return false;
    }
    if (hasBSelectedDevice() || rhs.hasBSelectedDevice()) {
        if (getBSelectedDevice() < rhs.getBSelectedDevice()) return true;
        if (getBSelectedDevice() > rhs.getBSelectedDevice()) return false;
    }
    if (hasBDAPSupport() || rhs.hasBDAPSupport()) {
        if (getBDAPSupport() < rhs.getBDAPSupport()) return true;
        if (getBDAPSupport() > rhs.getBDAPSupport()) return false;
    }
    if (hasRProjectionCapability() || rhs.hasRProjectionCapability()) {
        if (getRProjectionCapability() < rhs.getRProjectionCapability()) return true;
        if (getRProjectionCapability() > rhs.getRProjectionCapability()) return false;
    }
    if (hasSzBTAddress() || rhs.hasSzBTAddress()) {
        if (getSzBTAddress() < rhs.getSzBTAddress()) return true;
        if (getSzBTAddress() > rhs.getSzBTAddress()) return false;
    }
    if (hasRDeviceSelectionInfo() || rhs.hasRDeviceSelectionInfo()) {
        if (getRDeviceSelectionInfo() < rhs.getRDeviceSelectionInfo()) return true;
        if (getRDeviceSelectionInfo() > rhs.getRDeviceSelectionInfo()) return false;
    }
    if (hasSzSerialNumber() || rhs.hasSzSerialNumber()) {
        if (getSzSerialNumber() < rhs.getSzSerialNumber()) return true;
        if (getSzSerialNumber() > rhs.getSzSerialNumber()) return false;
    }
    if (hasEnUserAuthorizationStatus() || rhs.hasEnUserAuthorizationStatus()) {
        if ((uint32)getEnUserAuthorizationStatus() < (uint32)rhs.getEnUserAuthorizationStatus()) return true;
        if ((uint32)getEnUserAuthorizationStatus() > (uint32)rhs.getEnUserAuthorizationStatus()) return false;
    }
    if (hasEnSessionTransportType() || rhs.hasEnSessionTransportType()) {
        if ((uint32)getEnSessionTransportType() < (uint32)rhs.getEnSessionTransportType()) return true;
        if ((uint32)getEnSessionTransportType() > (uint32)rhs.getEnSessionTransportType()) return false;
    }
    if (hasU32VendorID() || rhs.hasU32VendorID()) {
        if (getU32VendorID() < rhs.getU32VendorID()) return true;
        if (getU32VendorID() > rhs.getU32VendorID()) return false;
    }
    if (hasU32ProductID() || rhs.hasU32ProductID()) {
        if (getU32ProductID() < rhs.getU32ProductID()) return true;
        if (getU32ProductID() > rhs.getU32ProductID()) return false;
    }
    if (hasSzSystemPath() || rhs.hasSzSystemPath()) {
        if (getSzSystemPath() < rhs.getSzSystemPath()) return true;
        if (getSzSystemPath() > rhs.getSzSystemPath()) return false;
    }
    return false;
}

inline bool T_DeviceDetails::operator > (const T_DeviceDetails& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DeviceDetails::clear() {
    clearU32DeviceHandle();
    clearSzDeviceName();
    clearEnDeviceCategory();
    clearSzDeviceModelName();
    clearSzDeviceManufacturerName();
    clearEnDeviceConnectionStatus();
    clearEnDeviceConnectionType();
    clearRVersionInfo();
    clearEnDeviceUsageEnabled();
    clearBSelectedDevice();
    clearBDAPSupport();
    clearRProjectionCapability();
    clearSzBTAddress();
    clearRDeviceSelectionInfo();
    clearSzSerialNumber();
    clearEnUserAuthorizationStatus();
    clearEnSessionTransportType();
    clearU32VendorID();
    clearU32ProductID();
    clearSzSystemPath();
}

inline void T_DeviceDetails::clearU32DeviceHandle() {
    if (hasU32DeviceHandle()) {
         clear_has_u32DeviceHandle();
        _u32DeviceHandle = 0u;
     }
}

inline bool T_DeviceDetails::hasU32DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_DeviceDetails::getU32DeviceHandle () const {
    return _u32DeviceHandle;
}

inline void T_DeviceDetails::setU32DeviceHandle (uint32 u32DeviceHandle_) {
    set_has_u32DeviceHandle();
    this->_u32DeviceHandle = u32DeviceHandle_;
}

inline void T_DeviceDetails::clearSzDeviceName() {
    if (hasSzDeviceName()) {
         clear_has_szDeviceName();
        _szDeviceName.clear();
     }
}

inline bool T_DeviceDetails::hasSzDeviceName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_DeviceDetails::getSzDeviceName () const {
    return _szDeviceName;
}

inline ::std::string& T_DeviceDetails::getSzDeviceNameMutable () {
    set_has_szDeviceName();
    return _szDeviceName;
}

inline void T_DeviceDetails::setSzDeviceName (const ::std::string& szDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceName();
    this->_szDeviceName = szDeviceName_;
}

inline void T_DeviceDetails::setSzDeviceName (const char* szDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceName();
    this->_szDeviceName.assign(szDeviceName_);
}

inline void T_DeviceDetails::setSzDeviceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceName();
    this->_szDeviceName.assign(value, size);
}

inline void T_DeviceDetails::clearEnDeviceCategory() {
    if (hasEnDeviceCategory()) {
         clear_has_enDeviceCategory();
        _enDeviceCategory = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_UNKNOWN;
     }
}

inline bool T_DeviceDetails::hasEnDeviceCategory () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_DeviceCategory T_DeviceDetails::getEnDeviceCategory () const {
    return _enDeviceCategory;
}

inline void T_DeviceDetails::setEnDeviceCategory (T_e8_DeviceCategory enDeviceCategory_) {
    #ifndef NDEBUG
    if (!(T_e8_DeviceCategory_IsValid(enDeviceCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceCategory_, "T_e8_DeviceCategory", "enDeviceCategory", "T_DeviceDetails");
    }
    #endif
    set_has_enDeviceCategory();
    this->_enDeviceCategory = enDeviceCategory_;
}

inline void T_DeviceDetails::clearSzDeviceModelName() {
    if (hasSzDeviceModelName()) {
         clear_has_szDeviceModelName();
        _szDeviceModelName.clear();
     }
}

inline bool T_DeviceDetails::hasSzDeviceModelName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_DeviceDetails::getSzDeviceModelName () const {
    return _szDeviceModelName;
}

inline ::std::string& T_DeviceDetails::getSzDeviceModelNameMutable () {
    set_has_szDeviceModelName();
    return _szDeviceModelName;
}

inline void T_DeviceDetails::setSzDeviceModelName (const ::std::string& szDeviceModelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceModelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceModelName();
    this->_szDeviceModelName = szDeviceModelName_;
}

inline void T_DeviceDetails::setSzDeviceModelName (const char* szDeviceModelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceModelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceModelName();
    this->_szDeviceModelName.assign(szDeviceModelName_);
}

inline void T_DeviceDetails::setSzDeviceModelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceModelName();
    this->_szDeviceModelName.assign(value, size);
}

inline void T_DeviceDetails::clearSzDeviceManufacturerName() {
    if (hasSzDeviceManufacturerName()) {
         clear_has_szDeviceManufacturerName();
        _szDeviceManufacturerName.clear();
     }
}

inline bool T_DeviceDetails::hasSzDeviceManufacturerName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_DeviceDetails::getSzDeviceManufacturerName () const {
    return _szDeviceManufacturerName;
}

inline ::std::string& T_DeviceDetails::getSzDeviceManufacturerNameMutable () {
    set_has_szDeviceManufacturerName();
    return _szDeviceManufacturerName;
}

inline void T_DeviceDetails::setSzDeviceManufacturerName (const ::std::string& szDeviceManufacturerName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceManufacturerName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceManufacturerName();
    this->_szDeviceManufacturerName = szDeviceManufacturerName_;
}

inline void T_DeviceDetails::setSzDeviceManufacturerName (const char* szDeviceManufacturerName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceManufacturerName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceManufacturerName();
    this->_szDeviceManufacturerName.assign(szDeviceManufacturerName_);
}

inline void T_DeviceDetails::setSzDeviceManufacturerName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceManufacturerName();
    this->_szDeviceManufacturerName.assign(value, size);
}

inline void T_DeviceDetails::clearEnDeviceConnectionStatus() {
    if (hasEnDeviceConnectionStatus()) {
         clear_has_enDeviceConnectionStatus();
        _enDeviceConnectionStatus = ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionStatus__DEV_NOT_CONNECTED;
     }
}

inline bool T_DeviceDetails::hasEnDeviceConnectionStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_DeviceConnectionStatus T_DeviceDetails::getEnDeviceConnectionStatus () const {
    return _enDeviceConnectionStatus;
}

inline void T_DeviceDetails::setEnDeviceConnectionStatus (T_e8_DeviceConnectionStatus enDeviceConnectionStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_DeviceConnectionStatus_IsValid(enDeviceConnectionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceConnectionStatus_, "T_e8_DeviceConnectionStatus", "enDeviceConnectionStatus", "T_DeviceDetails");
    }
    #endif
    set_has_enDeviceConnectionStatus();
    this->_enDeviceConnectionStatus = enDeviceConnectionStatus_;
}

inline void T_DeviceDetails::clearEnDeviceConnectionType() {
    if (hasEnDeviceConnectionType()) {
         clear_has_enDeviceConnectionType();
        _enDeviceConnectionType = ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType__UNKNOWN_CONNECTION;
     }
}

inline bool T_DeviceDetails::hasEnDeviceConnectionType () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_DeviceConnectionType T_DeviceDetails::getEnDeviceConnectionType () const {
    return _enDeviceConnectionType;
}

inline void T_DeviceDetails::setEnDeviceConnectionType (T_e8_DeviceConnectionType enDeviceConnectionType_) {
    #ifndef NDEBUG
    if (!(T_e8_DeviceConnectionType_IsValid(enDeviceConnectionType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceConnectionType_, "T_e8_DeviceConnectionType", "enDeviceConnectionType", "T_DeviceDetails");
    }
    #endif
    set_has_enDeviceConnectionType();
    this->_enDeviceConnectionType = enDeviceConnectionType_;
}

inline void T_DeviceDetails::clearRVersionInfo() {
    if (hasRVersionInfo()) {
         clear_has_rVersionInfo();
        _rVersionInfo.clear();
     }
}

inline bool T_DeviceDetails::hasRVersionInfo () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const T_VersionInfo& T_DeviceDetails::getRVersionInfo () const {
    return _rVersionInfo;
}

inline T_VersionInfo& T_DeviceDetails::getRVersionInfoMutable () {
    set_has_rVersionInfo();
    return _rVersionInfo;
}

inline void T_DeviceDetails::setRVersionInfo (const T_VersionInfo& rVersionInfo_) {
    set_has_rVersionInfo();
    this->_rVersionInfo = rVersionInfo_;
}

inline void T_DeviceDetails::clearEnDeviceUsageEnabled() {
    if (hasEnDeviceUsageEnabled()) {
         clear_has_enDeviceUsageEnabled();
        _enDeviceUsageEnabled = ::midw_smartphoneint_fi_types::T_e8_EnabledInfo__USAGE_DISABLED;
     }
}

inline bool T_DeviceDetails::hasEnDeviceUsageEnabled () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline T_e8_EnabledInfo T_DeviceDetails::getEnDeviceUsageEnabled () const {
    return _enDeviceUsageEnabled;
}

inline void T_DeviceDetails::setEnDeviceUsageEnabled (T_e8_EnabledInfo enDeviceUsageEnabled_) {
    #ifndef NDEBUG
    if (!(T_e8_EnabledInfo_IsValid(enDeviceUsageEnabled_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enDeviceUsageEnabled_, "T_e8_EnabledInfo", "enDeviceUsageEnabled", "T_DeviceDetails");
    }
    #endif
    set_has_enDeviceUsageEnabled();
    this->_enDeviceUsageEnabled = enDeviceUsageEnabled_;
}

inline void T_DeviceDetails::clearBSelectedDevice() {
    if (hasBSelectedDevice()) {
         clear_has_bSelectedDevice();
        _bSelectedDevice = false;
     }
}

inline bool T_DeviceDetails::hasBSelectedDevice () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool T_DeviceDetails::getBSelectedDevice () const {
    return _bSelectedDevice;
}

inline void T_DeviceDetails::setBSelectedDevice (bool bSelectedDevice_) {
    set_has_bSelectedDevice();
    this->_bSelectedDevice = bSelectedDevice_;
}

inline void T_DeviceDetails::clearBDAPSupport() {
    if (hasBDAPSupport()) {
         clear_has_bDAPSupport();
        _bDAPSupport = false;
     }
}

inline bool T_DeviceDetails::hasBDAPSupport () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool T_DeviceDetails::getBDAPSupport () const {
    return _bDAPSupport;
}

inline void T_DeviceDetails::setBDAPSupport (bool bDAPSupport_) {
    set_has_bDAPSupport();
    this->_bDAPSupport = bDAPSupport_;
}

inline void T_DeviceDetails::clearRProjectionCapability() {
    if (hasRProjectionCapability()) {
         clear_has_rProjectionCapability();
        _rProjectionCapability.clear();
     }
}

inline bool T_DeviceDetails::hasRProjectionCapability () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const T_ProjectionCapability& T_DeviceDetails::getRProjectionCapability () const {
    return _rProjectionCapability;
}

inline T_ProjectionCapability& T_DeviceDetails::getRProjectionCapabilityMutable () {
    set_has_rProjectionCapability();
    return _rProjectionCapability;
}

inline void T_DeviceDetails::setRProjectionCapability (const T_ProjectionCapability& rProjectionCapability_) {
    set_has_rProjectionCapability();
    this->_rProjectionCapability = rProjectionCapability_;
}

inline void T_DeviceDetails::clearSzBTAddress() {
    if (hasSzBTAddress()) {
         clear_has_szBTAddress();
        _szBTAddress.clear();
     }
}

inline bool T_DeviceDetails::hasSzBTAddress () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::string& T_DeviceDetails::getSzBTAddress () const {
    return _szBTAddress;
}

inline ::std::string& T_DeviceDetails::getSzBTAddressMutable () {
    set_has_szBTAddress();
    return _szBTAddress;
}

inline void T_DeviceDetails::setSzBTAddress (const ::std::string& szBTAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szBTAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szBTAddress();
    this->_szBTAddress = szBTAddress_;
}

inline void T_DeviceDetails::setSzBTAddress (const char* szBTAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szBTAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szBTAddress();
    this->_szBTAddress.assign(szBTAddress_);
}

inline void T_DeviceDetails::setSzBTAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szBTAddress();
    this->_szBTAddress.assign(value, size);
}

inline void T_DeviceDetails::clearRDeviceSelectionInfo() {
    if (hasRDeviceSelectionInfo()) {
         clear_has_rDeviceSelectionInfo();
        _rDeviceSelectionInfo.clear();
     }
}

inline bool T_DeviceDetails::hasRDeviceSelectionInfo () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline const T_DeviceSelectionInfo& T_DeviceDetails::getRDeviceSelectionInfo () const {
    return _rDeviceSelectionInfo;
}

inline T_DeviceSelectionInfo& T_DeviceDetails::getRDeviceSelectionInfoMutable () {
    set_has_rDeviceSelectionInfo();
    return _rDeviceSelectionInfo;
}

inline void T_DeviceDetails::setRDeviceSelectionInfo (const T_DeviceSelectionInfo& rDeviceSelectionInfo_) {
    set_has_rDeviceSelectionInfo();
    this->_rDeviceSelectionInfo = rDeviceSelectionInfo_;
}

inline void T_DeviceDetails::clearSzSerialNumber() {
    if (hasSzSerialNumber()) {
         clear_has_szSerialNumber();
        _szSerialNumber.clear();
     }
}

inline bool T_DeviceDetails::hasSzSerialNumber () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const ::std::string& T_DeviceDetails::getSzSerialNumber () const {
    return _szSerialNumber;
}

inline ::std::string& T_DeviceDetails::getSzSerialNumberMutable () {
    set_has_szSerialNumber();
    return _szSerialNumber;
}

inline void T_DeviceDetails::setSzSerialNumber (const ::std::string& szSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szSerialNumber();
    this->_szSerialNumber = szSerialNumber_;
}

inline void T_DeviceDetails::setSzSerialNumber (const char* szSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szSerialNumber();
    this->_szSerialNumber.assign(szSerialNumber_);
}

inline void T_DeviceDetails::setSzSerialNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szSerialNumber();
    this->_szSerialNumber.assign(value, size);
}

inline void T_DeviceDetails::clearEnUserAuthorizationStatus() {
    if (hasEnUserAuthorizationStatus()) {
         clear_has_enUserAuthorizationStatus();
        _enUserAuthorizationStatus = ::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus__USER_AUTH_UNKNOWN;
     }
}

inline bool T_DeviceDetails::hasEnUserAuthorizationStatus () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline T_e8_UserAuthorizationStatus T_DeviceDetails::getEnUserAuthorizationStatus () const {
    return _enUserAuthorizationStatus;
}

inline void T_DeviceDetails::setEnUserAuthorizationStatus (T_e8_UserAuthorizationStatus enUserAuthorizationStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_UserAuthorizationStatus_IsValid(enUserAuthorizationStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enUserAuthorizationStatus_, "T_e8_UserAuthorizationStatus", "enUserAuthorizationStatus", "T_DeviceDetails");
    }
    #endif
    set_has_enUserAuthorizationStatus();
    this->_enUserAuthorizationStatus = enUserAuthorizationStatus_;
}

inline void T_DeviceDetails::clearEnSessionTransportType() {
    if (hasEnSessionTransportType()) {
         clear_has_enSessionTransportType();
        _enSessionTransportType = ::midw_smartphoneint_fi_types::T_e8_SessionTransportType__SESSION_TRANSPORT_UNKNOWN;
     }
}

inline bool T_DeviceDetails::hasEnSessionTransportType () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline T_e8_SessionTransportType T_DeviceDetails::getEnSessionTransportType () const {
    return _enSessionTransportType;
}

inline void T_DeviceDetails::setEnSessionTransportType (T_e8_SessionTransportType enSessionTransportType_) {
    #ifndef NDEBUG
    if (!(T_e8_SessionTransportType_IsValid(enSessionTransportType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enSessionTransportType_, "T_e8_SessionTransportType", "enSessionTransportType", "T_DeviceDetails");
    }
    #endif
    set_has_enSessionTransportType();
    this->_enSessionTransportType = enSessionTransportType_;
}

inline void T_DeviceDetails::clearU32VendorID() {
    if (hasU32VendorID()) {
         clear_has_u32VendorID();
        _u32VendorID = 0u;
     }
}

inline bool T_DeviceDetails::hasU32VendorID () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline uint32 T_DeviceDetails::getU32VendorID () const {
    return _u32VendorID;
}

inline void T_DeviceDetails::setU32VendorID (uint32 u32VendorID_) {
    set_has_u32VendorID();
    this->_u32VendorID = u32VendorID_;
}

inline void T_DeviceDetails::clearU32ProductID() {
    if (hasU32ProductID()) {
         clear_has_u32ProductID();
        _u32ProductID = 0u;
     }
}

inline bool T_DeviceDetails::hasU32ProductID () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline uint32 T_DeviceDetails::getU32ProductID () const {
    return _u32ProductID;
}

inline void T_DeviceDetails::setU32ProductID (uint32 u32ProductID_) {
    set_has_u32ProductID();
    this->_u32ProductID = u32ProductID_;
}

inline void T_DeviceDetails::clearSzSystemPath() {
    if (hasSzSystemPath()) {
         clear_has_szSystemPath();
        _szSystemPath.clear();
     }
}

inline bool T_DeviceDetails::hasSzSystemPath () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline const ::std::string& T_DeviceDetails::getSzSystemPath () const {
    return _szSystemPath;
}

inline ::std::string& T_DeviceDetails::getSzSystemPathMutable () {
    set_has_szSystemPath();
    return _szSystemPath;
}

inline void T_DeviceDetails::setSzSystemPath (const ::std::string& szSystemPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szSystemPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szSystemPath();
    this->_szSystemPath = szSystemPath_;
}

inline void T_DeviceDetails::setSzSystemPath (const char* szSystemPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szSystemPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szSystemPath();
    this->_szSystemPath.assign(szSystemPath_);
}

inline void T_DeviceDetails::setSzSystemPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szSystemPath();
    this->_szSystemPath.assign(value, size);
}

inline void T_DeviceDetails::set_has_u32DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DeviceDetails::clear_has_u32DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DeviceDetails::set_has_szDeviceName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DeviceDetails::clear_has_szDeviceName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DeviceDetails::set_has_enDeviceCategory () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DeviceDetails::clear_has_enDeviceCategory () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DeviceDetails::set_has_szDeviceModelName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DeviceDetails::clear_has_szDeviceModelName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DeviceDetails::set_has_szDeviceManufacturerName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DeviceDetails::clear_has_szDeviceManufacturerName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DeviceDetails::set_has_enDeviceConnectionStatus () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DeviceDetails::clear_has_enDeviceConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DeviceDetails::set_has_enDeviceConnectionType () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DeviceDetails::clear_has_enDeviceConnectionType () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DeviceDetails::set_has_rVersionInfo () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DeviceDetails::clear_has_rVersionInfo () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DeviceDetails::set_has_enDeviceUsageEnabled () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DeviceDetails::clear_has_enDeviceUsageEnabled () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_DeviceDetails::set_has_bSelectedDevice () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_DeviceDetails::clear_has_bSelectedDevice () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_DeviceDetails::set_has_bDAPSupport () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_DeviceDetails::clear_has_bDAPSupport () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_DeviceDetails::set_has_rProjectionCapability () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_DeviceDetails::clear_has_rProjectionCapability () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_DeviceDetails::set_has_szBTAddress () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_DeviceDetails::clear_has_szBTAddress () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_DeviceDetails::set_has_rDeviceSelectionInfo () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_DeviceDetails::clear_has_rDeviceSelectionInfo () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_DeviceDetails::set_has_szSerialNumber () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_DeviceDetails::clear_has_szSerialNumber () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_DeviceDetails::set_has_enUserAuthorizationStatus () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_DeviceDetails::clear_has_enUserAuthorizationStatus () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_DeviceDetails::set_has_enSessionTransportType () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_DeviceDetails::clear_has_enSessionTransportType () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_DeviceDetails::set_has_u32VendorID () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_DeviceDetails::clear_has_u32VendorID () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_DeviceDetails::set_has_u32ProductID () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_DeviceDetails::clear_has_u32ProductID () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_DeviceDetails::set_has_szSystemPath () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_DeviceDetails::clear_has_szSystemPath () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline  T_AppDisplayInfo::T_AppDisplayInfo ()  :
    _enAppDisplayCategory (::midw_smartphoneint_fi_types::T_e32_AppDisplayCategory__Content_Text),
    _enTrustLevel (::midw_smartphoneint_fi_types::T_e16_TrustLevel__Unknown),
    _u32AppDisplayRules (0u),
    _szAppDisplayOrientation ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AppDisplayInfo::T_AppDisplayInfo (const T_AppDisplayInfo &rhs)  :
    _enAppDisplayCategory (::midw_smartphoneint_fi_types::T_e32_AppDisplayCategory__Content_Text),
    _enTrustLevel (::midw_smartphoneint_fi_types::T_e16_TrustLevel__Unknown),
    _u32AppDisplayRules (0u),
    _szAppDisplayOrientation ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AppDisplayInfo::T_AppDisplayInfo (T_e32_AppDisplayCategory enAppDisplayCategory_, T_e16_TrustLevel enTrustLevel_, uint32 u32AppDisplayRules_, const ::std::string& szAppDisplayOrientation_)  :
    _enAppDisplayCategory (enAppDisplayCategory_),
    _enTrustLevel (enTrustLevel_),
    _u32AppDisplayRules (u32AppDisplayRules_),
    _szAppDisplayOrientation (szAppDisplayOrientation_)
{
    #ifndef NDEBUG
    if (!(T_e32_AppDisplayCategory_IsValid(enAppDisplayCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enAppDisplayCategory_, "T_e32_AppDisplayCategory", "enAppDisplayCategory", "T_AppDisplayInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e16_TrustLevel_IsValid(enTrustLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTrustLevel_, "T_e16_TrustLevel", "enTrustLevel", "T_AppDisplayInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppDisplayOrientation_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AppDisplayInfo::~T_AppDisplayInfo() {
}

inline T_AppDisplayInfo& T_AppDisplayInfo::operator = (const T_AppDisplayInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnAppDisplayCategory()) {
            setEnAppDisplayCategory(rhs.getEnAppDisplayCategory());
        } else {
            clearEnAppDisplayCategory();
        }
        if (rhs.hasEnTrustLevel()) {
            setEnTrustLevel(rhs.getEnTrustLevel());
        } else {
            clearEnTrustLevel();
        }
        if (rhs.hasU32AppDisplayRules()) {
            setU32AppDisplayRules(rhs.getU32AppDisplayRules());
        } else {
            clearU32AppDisplayRules();
        }
        if (rhs.hasSzAppDisplayOrientation()) {
            setSzAppDisplayOrientation(rhs.getSzAppDisplayOrientation());
        } else {
            clearSzAppDisplayOrientation();
        }
    }
    return *this;
}

inline bool T_AppDisplayInfo::operator == (const T_AppDisplayInfo& rhs) const {
    return (((!hasEnAppDisplayCategory() && !rhs.hasEnAppDisplayCategory()) || getEnAppDisplayCategory() == rhs.getEnAppDisplayCategory()) &&
        ((!hasEnTrustLevel() && !rhs.hasEnTrustLevel()) || getEnTrustLevel() == rhs.getEnTrustLevel()) &&
        ((!hasU32AppDisplayRules() && !rhs.hasU32AppDisplayRules()) || getU32AppDisplayRules() == rhs.getU32AppDisplayRules()) &&
        ((!hasSzAppDisplayOrientation() && !rhs.hasSzAppDisplayOrientation()) || getSzAppDisplayOrientation() == rhs.getSzAppDisplayOrientation()));
}

inline bool T_AppDisplayInfo::operator != (const T_AppDisplayInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AppDisplayInfo::operator < (const T_AppDisplayInfo& rhs) const {
    if (hasEnAppDisplayCategory() || rhs.hasEnAppDisplayCategory()) {
        if ((uint32)getEnAppDisplayCategory() < (uint32)rhs.getEnAppDisplayCategory()) return true;
        if ((uint32)getEnAppDisplayCategory() > (uint32)rhs.getEnAppDisplayCategory()) return false;
    }
    if (hasEnTrustLevel() || rhs.hasEnTrustLevel()) {
        if ((uint32)getEnTrustLevel() < (uint32)rhs.getEnTrustLevel()) return true;
        if ((uint32)getEnTrustLevel() > (uint32)rhs.getEnTrustLevel()) return false;
    }
    if (hasU32AppDisplayRules() || rhs.hasU32AppDisplayRules()) {
        if (getU32AppDisplayRules() < rhs.getU32AppDisplayRules()) return true;
        if (getU32AppDisplayRules() > rhs.getU32AppDisplayRules()) return false;
    }
    if (hasSzAppDisplayOrientation() || rhs.hasSzAppDisplayOrientation()) {
        if (getSzAppDisplayOrientation() < rhs.getSzAppDisplayOrientation()) return true;
        if (getSzAppDisplayOrientation() > rhs.getSzAppDisplayOrientation()) return false;
    }
    return false;
}

inline bool T_AppDisplayInfo::operator > (const T_AppDisplayInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AppDisplayInfo::clear() {
    clearEnAppDisplayCategory();
    clearEnTrustLevel();
    clearU32AppDisplayRules();
    clearSzAppDisplayOrientation();
}

inline void T_AppDisplayInfo::clearEnAppDisplayCategory() {
    if (hasEnAppDisplayCategory()) {
         clear_has_enAppDisplayCategory();
        _enAppDisplayCategory = ::midw_smartphoneint_fi_types::T_e32_AppDisplayCategory__Content_Text;
     }
}

inline bool T_AppDisplayInfo::hasEnAppDisplayCategory () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e32_AppDisplayCategory T_AppDisplayInfo::getEnAppDisplayCategory () const {
    return _enAppDisplayCategory;
}

inline void T_AppDisplayInfo::setEnAppDisplayCategory (T_e32_AppDisplayCategory enAppDisplayCategory_) {
    #ifndef NDEBUG
    if (!(T_e32_AppDisplayCategory_IsValid(enAppDisplayCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enAppDisplayCategory_, "T_e32_AppDisplayCategory", "enAppDisplayCategory", "T_AppDisplayInfo");
    }
    #endif
    set_has_enAppDisplayCategory();
    this->_enAppDisplayCategory = enAppDisplayCategory_;
}

inline void T_AppDisplayInfo::clearEnTrustLevel() {
    if (hasEnTrustLevel()) {
         clear_has_enTrustLevel();
        _enTrustLevel = ::midw_smartphoneint_fi_types::T_e16_TrustLevel__Unknown;
     }
}

inline bool T_AppDisplayInfo::hasEnTrustLevel () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e16_TrustLevel T_AppDisplayInfo::getEnTrustLevel () const {
    return _enTrustLevel;
}

inline void T_AppDisplayInfo::setEnTrustLevel (T_e16_TrustLevel enTrustLevel_) {
    #ifndef NDEBUG
    if (!(T_e16_TrustLevel_IsValid(enTrustLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTrustLevel_, "T_e16_TrustLevel", "enTrustLevel", "T_AppDisplayInfo");
    }
    #endif
    set_has_enTrustLevel();
    this->_enTrustLevel = enTrustLevel_;
}

inline void T_AppDisplayInfo::clearU32AppDisplayRules() {
    if (hasU32AppDisplayRules()) {
         clear_has_u32AppDisplayRules();
        _u32AppDisplayRules = 0u;
     }
}

inline bool T_AppDisplayInfo::hasU32AppDisplayRules () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_AppDisplayInfo::getU32AppDisplayRules () const {
    return _u32AppDisplayRules;
}

inline void T_AppDisplayInfo::setU32AppDisplayRules (uint32 u32AppDisplayRules_) {
    set_has_u32AppDisplayRules();
    this->_u32AppDisplayRules = u32AppDisplayRules_;
}

inline void T_AppDisplayInfo::clearSzAppDisplayOrientation() {
    if (hasSzAppDisplayOrientation()) {
         clear_has_szAppDisplayOrientation();
        _szAppDisplayOrientation.clear();
     }
}

inline bool T_AppDisplayInfo::hasSzAppDisplayOrientation () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_AppDisplayInfo::getSzAppDisplayOrientation () const {
    return _szAppDisplayOrientation;
}

inline ::std::string& T_AppDisplayInfo::getSzAppDisplayOrientationMutable () {
    set_has_szAppDisplayOrientation();
    return _szAppDisplayOrientation;
}

inline void T_AppDisplayInfo::setSzAppDisplayOrientation (const ::std::string& szAppDisplayOrientation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppDisplayOrientation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppDisplayOrientation();
    this->_szAppDisplayOrientation = szAppDisplayOrientation_;
}

inline void T_AppDisplayInfo::setSzAppDisplayOrientation (const char* szAppDisplayOrientation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppDisplayOrientation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppDisplayOrientation();
    this->_szAppDisplayOrientation.assign(szAppDisplayOrientation_);
}

inline void T_AppDisplayInfo::setSzAppDisplayOrientation (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppDisplayOrientation();
    this->_szAppDisplayOrientation.assign(value, size);
}

inline void T_AppDisplayInfo::set_has_enAppDisplayCategory () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AppDisplayInfo::clear_has_enAppDisplayCategory () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AppDisplayInfo::set_has_enTrustLevel () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AppDisplayInfo::clear_has_enTrustLevel () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AppDisplayInfo::set_has_u32AppDisplayRules () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AppDisplayInfo::clear_has_u32AppDisplayRules () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AppDisplayInfo::set_has_szAppDisplayOrientation () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AppDisplayInfo::clear_has_szAppDisplayOrientation () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_AppAudioInfo::T_AppAudioInfo ()  :
    _szAppAudioType (),
    _enAppAudioCategory (::midw_smartphoneint_fi_types::T_e32_AppAudioCategory__Phone_Audio),
    _enTrustLevel (::midw_smartphoneint_fi_types::T_e16_TrustLevel__Unknown),
    _u32AppAudioRules (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AppAudioInfo::T_AppAudioInfo (const T_AppAudioInfo &rhs)  :
    _szAppAudioType (),
    _enAppAudioCategory (::midw_smartphoneint_fi_types::T_e32_AppAudioCategory__Phone_Audio),
    _enTrustLevel (::midw_smartphoneint_fi_types::T_e16_TrustLevel__Unknown),
    _u32AppAudioRules (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AppAudioInfo::T_AppAudioInfo (const ::std::string& szAppAudioType_, T_e32_AppAudioCategory enAppAudioCategory_, T_e16_TrustLevel enTrustLevel_, uint32 u32AppAudioRules_)  :
    _szAppAudioType (szAppAudioType_),
    _enAppAudioCategory (enAppAudioCategory_),
    _enTrustLevel (enTrustLevel_),
    _u32AppAudioRules (u32AppAudioRules_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppAudioType_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e32_AppAudioCategory_IsValid(enAppAudioCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enAppAudioCategory_, "T_e32_AppAudioCategory", "enAppAudioCategory", "T_AppAudioInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e16_TrustLevel_IsValid(enTrustLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTrustLevel_, "T_e16_TrustLevel", "enTrustLevel", "T_AppAudioInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AppAudioInfo::~T_AppAudioInfo() {
}

inline T_AppAudioInfo& T_AppAudioInfo::operator = (const T_AppAudioInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSzAppAudioType()) {
            setSzAppAudioType(rhs.getSzAppAudioType());
        } else {
            clearSzAppAudioType();
        }
        if (rhs.hasEnAppAudioCategory()) {
            setEnAppAudioCategory(rhs.getEnAppAudioCategory());
        } else {
            clearEnAppAudioCategory();
        }
        if (rhs.hasEnTrustLevel()) {
            setEnTrustLevel(rhs.getEnTrustLevel());
        } else {
            clearEnTrustLevel();
        }
        if (rhs.hasU32AppAudioRules()) {
            setU32AppAudioRules(rhs.getU32AppAudioRules());
        } else {
            clearU32AppAudioRules();
        }
    }
    return *this;
}

inline bool T_AppAudioInfo::operator == (const T_AppAudioInfo& rhs) const {
    return (((!hasSzAppAudioType() && !rhs.hasSzAppAudioType()) || getSzAppAudioType() == rhs.getSzAppAudioType()) &&
        ((!hasEnAppAudioCategory() && !rhs.hasEnAppAudioCategory()) || getEnAppAudioCategory() == rhs.getEnAppAudioCategory()) &&
        ((!hasEnTrustLevel() && !rhs.hasEnTrustLevel()) || getEnTrustLevel() == rhs.getEnTrustLevel()) &&
        ((!hasU32AppAudioRules() && !rhs.hasU32AppAudioRules()) || getU32AppAudioRules() == rhs.getU32AppAudioRules()));
}

inline bool T_AppAudioInfo::operator != (const T_AppAudioInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AppAudioInfo::operator < (const T_AppAudioInfo& rhs) const {
    if (hasSzAppAudioType() || rhs.hasSzAppAudioType()) {
        if (getSzAppAudioType() < rhs.getSzAppAudioType()) return true;
        if (getSzAppAudioType() > rhs.getSzAppAudioType()) return false;
    }
    if (hasEnAppAudioCategory() || rhs.hasEnAppAudioCategory()) {
        if ((uint32)getEnAppAudioCategory() < (uint32)rhs.getEnAppAudioCategory()) return true;
        if ((uint32)getEnAppAudioCategory() > (uint32)rhs.getEnAppAudioCategory()) return false;
    }
    if (hasEnTrustLevel() || rhs.hasEnTrustLevel()) {
        if ((uint32)getEnTrustLevel() < (uint32)rhs.getEnTrustLevel()) return true;
        if ((uint32)getEnTrustLevel() > (uint32)rhs.getEnTrustLevel()) return false;
    }
    if (hasU32AppAudioRules() || rhs.hasU32AppAudioRules()) {
        if (getU32AppAudioRules() < rhs.getU32AppAudioRules()) return true;
        if (getU32AppAudioRules() > rhs.getU32AppAudioRules()) return false;
    }
    return false;
}

inline bool T_AppAudioInfo::operator > (const T_AppAudioInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AppAudioInfo::clear() {
    clearSzAppAudioType();
    clearEnAppAudioCategory();
    clearEnTrustLevel();
    clearU32AppAudioRules();
}

inline void T_AppAudioInfo::clearSzAppAudioType() {
    if (hasSzAppAudioType()) {
         clear_has_szAppAudioType();
        _szAppAudioType.clear();
     }
}

inline bool T_AppAudioInfo::hasSzAppAudioType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_AppAudioInfo::getSzAppAudioType () const {
    return _szAppAudioType;
}

inline ::std::string& T_AppAudioInfo::getSzAppAudioTypeMutable () {
    set_has_szAppAudioType();
    return _szAppAudioType;
}

inline void T_AppAudioInfo::setSzAppAudioType (const ::std::string& szAppAudioType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppAudioType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppAudioType();
    this->_szAppAudioType = szAppAudioType_;
}

inline void T_AppAudioInfo::setSzAppAudioType (const char* szAppAudioType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppAudioType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppAudioType();
    this->_szAppAudioType.assign(szAppAudioType_);
}

inline void T_AppAudioInfo::setSzAppAudioType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppAudioType();
    this->_szAppAudioType.assign(value, size);
}

inline void T_AppAudioInfo::clearEnAppAudioCategory() {
    if (hasEnAppAudioCategory()) {
         clear_has_enAppAudioCategory();
        _enAppAudioCategory = ::midw_smartphoneint_fi_types::T_e32_AppAudioCategory__Phone_Audio;
     }
}

inline bool T_AppAudioInfo::hasEnAppAudioCategory () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e32_AppAudioCategory T_AppAudioInfo::getEnAppAudioCategory () const {
    return _enAppAudioCategory;
}

inline void T_AppAudioInfo::setEnAppAudioCategory (T_e32_AppAudioCategory enAppAudioCategory_) {
    #ifndef NDEBUG
    if (!(T_e32_AppAudioCategory_IsValid(enAppAudioCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enAppAudioCategory_, "T_e32_AppAudioCategory", "enAppAudioCategory", "T_AppAudioInfo");
    }
    #endif
    set_has_enAppAudioCategory();
    this->_enAppAudioCategory = enAppAudioCategory_;
}

inline void T_AppAudioInfo::clearEnTrustLevel() {
    if (hasEnTrustLevel()) {
         clear_has_enTrustLevel();
        _enTrustLevel = ::midw_smartphoneint_fi_types::T_e16_TrustLevel__Unknown;
     }
}

inline bool T_AppAudioInfo::hasEnTrustLevel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e16_TrustLevel T_AppAudioInfo::getEnTrustLevel () const {
    return _enTrustLevel;
}

inline void T_AppAudioInfo::setEnTrustLevel (T_e16_TrustLevel enTrustLevel_) {
    #ifndef NDEBUG
    if (!(T_e16_TrustLevel_IsValid(enTrustLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTrustLevel_, "T_e16_TrustLevel", "enTrustLevel", "T_AppAudioInfo");
    }
    #endif
    set_has_enTrustLevel();
    this->_enTrustLevel = enTrustLevel_;
}

inline void T_AppAudioInfo::clearU32AppAudioRules() {
    if (hasU32AppAudioRules()) {
         clear_has_u32AppAudioRules();
        _u32AppAudioRules = 0u;
     }
}

inline bool T_AppAudioInfo::hasU32AppAudioRules () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_AppAudioInfo::getU32AppAudioRules () const {
    return _u32AppAudioRules;
}

inline void T_AppAudioInfo::setU32AppAudioRules (uint32 u32AppAudioRules_) {
    set_has_u32AppAudioRules();
    this->_u32AppAudioRules = u32AppAudioRules_;
}

inline void T_AppAudioInfo::set_has_szAppAudioType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AppAudioInfo::clear_has_szAppAudioType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AppAudioInfo::set_has_enAppAudioCategory () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AppAudioInfo::clear_has_enAppAudioCategory () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AppAudioInfo::set_has_enTrustLevel () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AppAudioInfo::clear_has_enTrustLevel () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AppAudioInfo::set_has_u32AppAudioRules () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AppAudioInfo::clear_has_u32AppAudioRules () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_AppRemotingInfo::T_AppRemotingInfo ()  :
    _szRemotingProtocolID (),
    _szRemotingFormat (),
    _szRemotingDirection (),
    _u32RemotingAudioIPL (0u),
    _u32RemotingAudioMPL (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AppRemotingInfo::T_AppRemotingInfo (const T_AppRemotingInfo &rhs)  :
    _szRemotingProtocolID (),
    _szRemotingFormat (),
    _szRemotingDirection (),
    _u32RemotingAudioIPL (0u),
    _u32RemotingAudioMPL (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AppRemotingInfo::T_AppRemotingInfo (const ::std::string& szRemotingProtocolID_, const ::std::string& szRemotingFormat_, const ::std::string& szRemotingDirection_, uint32 u32RemotingAudioIPL_, uint32 u32RemotingAudioMPL_)  :
    _szRemotingProtocolID (szRemotingProtocolID_),
    _szRemotingFormat (szRemotingFormat_),
    _szRemotingDirection (szRemotingDirection_),
    _u32RemotingAudioIPL (u32RemotingAudioIPL_),
    _u32RemotingAudioMPL (u32RemotingAudioMPL_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szRemotingProtocolID_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szRemotingFormat_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szRemotingDirection_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AppRemotingInfo::~T_AppRemotingInfo() {
}

inline T_AppRemotingInfo& T_AppRemotingInfo::operator = (const T_AppRemotingInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSzRemotingProtocolID()) {
            setSzRemotingProtocolID(rhs.getSzRemotingProtocolID());
        } else {
            clearSzRemotingProtocolID();
        }
        if (rhs.hasSzRemotingFormat()) {
            setSzRemotingFormat(rhs.getSzRemotingFormat());
        } else {
            clearSzRemotingFormat();
        }
        if (rhs.hasSzRemotingDirection()) {
            setSzRemotingDirection(rhs.getSzRemotingDirection());
        } else {
            clearSzRemotingDirection();
        }
        if (rhs.hasU32RemotingAudioIPL()) {
            setU32RemotingAudioIPL(rhs.getU32RemotingAudioIPL());
        } else {
            clearU32RemotingAudioIPL();
        }
        if (rhs.hasU32RemotingAudioMPL()) {
            setU32RemotingAudioMPL(rhs.getU32RemotingAudioMPL());
        } else {
            clearU32RemotingAudioMPL();
        }
    }
    return *this;
}

inline bool T_AppRemotingInfo::operator == (const T_AppRemotingInfo& rhs) const {
    return (((!hasSzRemotingProtocolID() && !rhs.hasSzRemotingProtocolID()) || getSzRemotingProtocolID() == rhs.getSzRemotingProtocolID()) &&
        ((!hasSzRemotingFormat() && !rhs.hasSzRemotingFormat()) || getSzRemotingFormat() == rhs.getSzRemotingFormat()) &&
        ((!hasSzRemotingDirection() && !rhs.hasSzRemotingDirection()) || getSzRemotingDirection() == rhs.getSzRemotingDirection()) &&
        ((!hasU32RemotingAudioIPL() && !rhs.hasU32RemotingAudioIPL()) || getU32RemotingAudioIPL() == rhs.getU32RemotingAudioIPL()) &&
        ((!hasU32RemotingAudioMPL() && !rhs.hasU32RemotingAudioMPL()) || getU32RemotingAudioMPL() == rhs.getU32RemotingAudioMPL()));
}

inline bool T_AppRemotingInfo::operator != (const T_AppRemotingInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AppRemotingInfo::operator < (const T_AppRemotingInfo& rhs) const {
    if (hasSzRemotingProtocolID() || rhs.hasSzRemotingProtocolID()) {
        if (getSzRemotingProtocolID() < rhs.getSzRemotingProtocolID()) return true;
        if (getSzRemotingProtocolID() > rhs.getSzRemotingProtocolID()) return false;
    }
    if (hasSzRemotingFormat() || rhs.hasSzRemotingFormat()) {
        if (getSzRemotingFormat() < rhs.getSzRemotingFormat()) return true;
        if (getSzRemotingFormat() > rhs.getSzRemotingFormat()) return false;
    }
    if (hasSzRemotingDirection() || rhs.hasSzRemotingDirection()) {
        if (getSzRemotingDirection() < rhs.getSzRemotingDirection()) return true;
        if (getSzRemotingDirection() > rhs.getSzRemotingDirection()) return false;
    }
    if (hasU32RemotingAudioIPL() || rhs.hasU32RemotingAudioIPL()) {
        if (getU32RemotingAudioIPL() < rhs.getU32RemotingAudioIPL()) return true;
        if (getU32RemotingAudioIPL() > rhs.getU32RemotingAudioIPL()) return false;
    }
    if (hasU32RemotingAudioMPL() || rhs.hasU32RemotingAudioMPL()) {
        if (getU32RemotingAudioMPL() < rhs.getU32RemotingAudioMPL()) return true;
        if (getU32RemotingAudioMPL() > rhs.getU32RemotingAudioMPL()) return false;
    }
    return false;
}

inline bool T_AppRemotingInfo::operator > (const T_AppRemotingInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AppRemotingInfo::clear() {
    clearSzRemotingProtocolID();
    clearSzRemotingFormat();
    clearSzRemotingDirection();
    clearU32RemotingAudioIPL();
    clearU32RemotingAudioMPL();
}

inline void T_AppRemotingInfo::clearSzRemotingProtocolID() {
    if (hasSzRemotingProtocolID()) {
         clear_has_szRemotingProtocolID();
        _szRemotingProtocolID.clear();
     }
}

inline bool T_AppRemotingInfo::hasSzRemotingProtocolID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_AppRemotingInfo::getSzRemotingProtocolID () const {
    return _szRemotingProtocolID;
}

inline ::std::string& T_AppRemotingInfo::getSzRemotingProtocolIDMutable () {
    set_has_szRemotingProtocolID();
    return _szRemotingProtocolID;
}

inline void T_AppRemotingInfo::setSzRemotingProtocolID (const ::std::string& szRemotingProtocolID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szRemotingProtocolID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szRemotingProtocolID();
    this->_szRemotingProtocolID = szRemotingProtocolID_;
}

inline void T_AppRemotingInfo::setSzRemotingProtocolID (const char* szRemotingProtocolID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szRemotingProtocolID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szRemotingProtocolID();
    this->_szRemotingProtocolID.assign(szRemotingProtocolID_);
}

inline void T_AppRemotingInfo::setSzRemotingProtocolID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szRemotingProtocolID();
    this->_szRemotingProtocolID.assign(value, size);
}

inline void T_AppRemotingInfo::clearSzRemotingFormat() {
    if (hasSzRemotingFormat()) {
         clear_has_szRemotingFormat();
        _szRemotingFormat.clear();
     }
}

inline bool T_AppRemotingInfo::hasSzRemotingFormat () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_AppRemotingInfo::getSzRemotingFormat () const {
    return _szRemotingFormat;
}

inline ::std::string& T_AppRemotingInfo::getSzRemotingFormatMutable () {
    set_has_szRemotingFormat();
    return _szRemotingFormat;
}

inline void T_AppRemotingInfo::setSzRemotingFormat (const ::std::string& szRemotingFormat_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szRemotingFormat_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szRemotingFormat();
    this->_szRemotingFormat = szRemotingFormat_;
}

inline void T_AppRemotingInfo::setSzRemotingFormat (const char* szRemotingFormat_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szRemotingFormat_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szRemotingFormat();
    this->_szRemotingFormat.assign(szRemotingFormat_);
}

inline void T_AppRemotingInfo::setSzRemotingFormat (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szRemotingFormat();
    this->_szRemotingFormat.assign(value, size);
}

inline void T_AppRemotingInfo::clearSzRemotingDirection() {
    if (hasSzRemotingDirection()) {
         clear_has_szRemotingDirection();
        _szRemotingDirection.clear();
     }
}

inline bool T_AppRemotingInfo::hasSzRemotingDirection () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_AppRemotingInfo::getSzRemotingDirection () const {
    return _szRemotingDirection;
}

inline ::std::string& T_AppRemotingInfo::getSzRemotingDirectionMutable () {
    set_has_szRemotingDirection();
    return _szRemotingDirection;
}

inline void T_AppRemotingInfo::setSzRemotingDirection (const ::std::string& szRemotingDirection_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szRemotingDirection_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szRemotingDirection();
    this->_szRemotingDirection = szRemotingDirection_;
}

inline void T_AppRemotingInfo::setSzRemotingDirection (const char* szRemotingDirection_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szRemotingDirection_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szRemotingDirection();
    this->_szRemotingDirection.assign(szRemotingDirection_);
}

inline void T_AppRemotingInfo::setSzRemotingDirection (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szRemotingDirection();
    this->_szRemotingDirection.assign(value, size);
}

inline void T_AppRemotingInfo::clearU32RemotingAudioIPL() {
    if (hasU32RemotingAudioIPL()) {
         clear_has_u32RemotingAudioIPL();
        _u32RemotingAudioIPL = 0u;
     }
}

inline bool T_AppRemotingInfo::hasU32RemotingAudioIPL () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_AppRemotingInfo::getU32RemotingAudioIPL () const {
    return _u32RemotingAudioIPL;
}

inline void T_AppRemotingInfo::setU32RemotingAudioIPL (uint32 u32RemotingAudioIPL_) {
    set_has_u32RemotingAudioIPL();
    this->_u32RemotingAudioIPL = u32RemotingAudioIPL_;
}

inline void T_AppRemotingInfo::clearU32RemotingAudioMPL() {
    if (hasU32RemotingAudioMPL()) {
         clear_has_u32RemotingAudioMPL();
        _u32RemotingAudioMPL = 0u;
     }
}

inline bool T_AppRemotingInfo::hasU32RemotingAudioMPL () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_AppRemotingInfo::getU32RemotingAudioMPL () const {
    return _u32RemotingAudioMPL;
}

inline void T_AppRemotingInfo::setU32RemotingAudioMPL (uint32 u32RemotingAudioMPL_) {
    set_has_u32RemotingAudioMPL();
    this->_u32RemotingAudioMPL = u32RemotingAudioMPL_;
}

inline void T_AppRemotingInfo::set_has_szRemotingProtocolID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AppRemotingInfo::clear_has_szRemotingProtocolID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AppRemotingInfo::set_has_szRemotingFormat () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AppRemotingInfo::clear_has_szRemotingFormat () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AppRemotingInfo::set_has_szRemotingDirection () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AppRemotingInfo::clear_has_szRemotingDirection () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AppRemotingInfo::set_has_u32RemotingAudioIPL () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AppRemotingInfo::clear_has_u32RemotingAudioIPL () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_AppRemotingInfo::set_has_u32RemotingAudioMPL () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_AppRemotingInfo::clear_has_u32RemotingAudioMPL () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_IconAttributes::T_IconAttributes ()  :
    _u32IconWidth (0u),
    _u32IconHeight (0u),
    _u32IconDepth (0u),
    _enIconMimeType (::midw_smartphoneint_fi_types::T_e8_IconMimeType__ICON_INVALID),
    _szIconURL ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_IconAttributes::T_IconAttributes (const T_IconAttributes &rhs)  :
    _u32IconWidth (0u),
    _u32IconHeight (0u),
    _u32IconDepth (0u),
    _enIconMimeType (::midw_smartphoneint_fi_types::T_e8_IconMimeType__ICON_INVALID),
    _szIconURL ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_IconAttributes::T_IconAttributes (uint32 u32IconWidth_, uint32 u32IconHeight_, uint32 u32IconDepth_, T_e8_IconMimeType enIconMimeType_, const ::std::string& szIconURL_)  :
    _u32IconWidth (u32IconWidth_),
    _u32IconHeight (u32IconHeight_),
    _u32IconDepth (u32IconDepth_),
    _enIconMimeType (enIconMimeType_),
    _szIconURL (szIconURL_)
{
    #ifndef NDEBUG
    if (!(T_e8_IconMimeType_IsValid(enIconMimeType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enIconMimeType_, "T_e8_IconMimeType", "enIconMimeType", "T_IconAttributes");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szIconURL_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_IconAttributes::~T_IconAttributes() {
}

inline T_IconAttributes& T_IconAttributes::operator = (const T_IconAttributes& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32IconWidth()) {
            setU32IconWidth(rhs.getU32IconWidth());
        } else {
            clearU32IconWidth();
        }
        if (rhs.hasU32IconHeight()) {
            setU32IconHeight(rhs.getU32IconHeight());
        } else {
            clearU32IconHeight();
        }
        if (rhs.hasU32IconDepth()) {
            setU32IconDepth(rhs.getU32IconDepth());
        } else {
            clearU32IconDepth();
        }
        if (rhs.hasEnIconMimeType()) {
            setEnIconMimeType(rhs.getEnIconMimeType());
        } else {
            clearEnIconMimeType();
        }
        if (rhs.hasSzIconURL()) {
            setSzIconURL(rhs.getSzIconURL());
        } else {
            clearSzIconURL();
        }
    }
    return *this;
}

inline bool T_IconAttributes::operator == (const T_IconAttributes& rhs) const {
    return (((!hasU32IconWidth() && !rhs.hasU32IconWidth()) || getU32IconWidth() == rhs.getU32IconWidth()) &&
        ((!hasU32IconHeight() && !rhs.hasU32IconHeight()) || getU32IconHeight() == rhs.getU32IconHeight()) &&
        ((!hasU32IconDepth() && !rhs.hasU32IconDepth()) || getU32IconDepth() == rhs.getU32IconDepth()) &&
        ((!hasEnIconMimeType() && !rhs.hasEnIconMimeType()) || getEnIconMimeType() == rhs.getEnIconMimeType()) &&
        ((!hasSzIconURL() && !rhs.hasSzIconURL()) || getSzIconURL() == rhs.getSzIconURL()));
}

inline bool T_IconAttributes::operator != (const T_IconAttributes& rhs) const {
    return ! (*this == rhs);
}

inline bool T_IconAttributes::operator < (const T_IconAttributes& rhs) const {
    if (hasU32IconWidth() || rhs.hasU32IconWidth()) {
        if (getU32IconWidth() < rhs.getU32IconWidth()) return true;
        if (getU32IconWidth() > rhs.getU32IconWidth()) return false;
    }
    if (hasU32IconHeight() || rhs.hasU32IconHeight()) {
        if (getU32IconHeight() < rhs.getU32IconHeight()) return true;
        if (getU32IconHeight() > rhs.getU32IconHeight()) return false;
    }
    if (hasU32IconDepth() || rhs.hasU32IconDepth()) {
        if (getU32IconDepth() < rhs.getU32IconDepth()) return true;
        if (getU32IconDepth() > rhs.getU32IconDepth()) return false;
    }
    if (hasEnIconMimeType() || rhs.hasEnIconMimeType()) {
        if ((uint32)getEnIconMimeType() < (uint32)rhs.getEnIconMimeType()) return true;
        if ((uint32)getEnIconMimeType() > (uint32)rhs.getEnIconMimeType()) return false;
    }
    if (hasSzIconURL() || rhs.hasSzIconURL()) {
        if (getSzIconURL() < rhs.getSzIconURL()) return true;
        if (getSzIconURL() > rhs.getSzIconURL()) return false;
    }
    return false;
}

inline bool T_IconAttributes::operator > (const T_IconAttributes& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_IconAttributes::clear() {
    clearU32IconWidth();
    clearU32IconHeight();
    clearU32IconDepth();
    clearEnIconMimeType();
    clearSzIconURL();
}

inline void T_IconAttributes::clearU32IconWidth() {
    if (hasU32IconWidth()) {
         clear_has_u32IconWidth();
        _u32IconWidth = 0u;
     }
}

inline bool T_IconAttributes::hasU32IconWidth () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_IconAttributes::getU32IconWidth () const {
    return _u32IconWidth;
}

inline void T_IconAttributes::setU32IconWidth (uint32 u32IconWidth_) {
    set_has_u32IconWidth();
    this->_u32IconWidth = u32IconWidth_;
}

inline void T_IconAttributes::clearU32IconHeight() {
    if (hasU32IconHeight()) {
         clear_has_u32IconHeight();
        _u32IconHeight = 0u;
     }
}

inline bool T_IconAttributes::hasU32IconHeight () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_IconAttributes::getU32IconHeight () const {
    return _u32IconHeight;
}

inline void T_IconAttributes::setU32IconHeight (uint32 u32IconHeight_) {
    set_has_u32IconHeight();
    this->_u32IconHeight = u32IconHeight_;
}

inline void T_IconAttributes::clearU32IconDepth() {
    if (hasU32IconDepth()) {
         clear_has_u32IconDepth();
        _u32IconDepth = 0u;
     }
}

inline bool T_IconAttributes::hasU32IconDepth () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_IconAttributes::getU32IconDepth () const {
    return _u32IconDepth;
}

inline void T_IconAttributes::setU32IconDepth (uint32 u32IconDepth_) {
    set_has_u32IconDepth();
    this->_u32IconDepth = u32IconDepth_;
}

inline void T_IconAttributes::clearEnIconMimeType() {
    if (hasEnIconMimeType()) {
         clear_has_enIconMimeType();
        _enIconMimeType = ::midw_smartphoneint_fi_types::T_e8_IconMimeType__ICON_INVALID;
     }
}

inline bool T_IconAttributes::hasEnIconMimeType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_IconMimeType T_IconAttributes::getEnIconMimeType () const {
    return _enIconMimeType;
}

inline void T_IconAttributes::setEnIconMimeType (T_e8_IconMimeType enIconMimeType_) {
    #ifndef NDEBUG
    if (!(T_e8_IconMimeType_IsValid(enIconMimeType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enIconMimeType_, "T_e8_IconMimeType", "enIconMimeType", "T_IconAttributes");
    }
    #endif
    set_has_enIconMimeType();
    this->_enIconMimeType = enIconMimeType_;
}

inline void T_IconAttributes::clearSzIconURL() {
    if (hasSzIconURL()) {
         clear_has_szIconURL();
        _szIconURL.clear();
     }
}

inline bool T_IconAttributes::hasSzIconURL () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_IconAttributes::getSzIconURL () const {
    return _szIconURL;
}

inline ::std::string& T_IconAttributes::getSzIconURLMutable () {
    set_has_szIconURL();
    return _szIconURL;
}

inline void T_IconAttributes::setSzIconURL (const ::std::string& szIconURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szIconURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szIconURL();
    this->_szIconURL = szIconURL_;
}

inline void T_IconAttributes::setSzIconURL (const char* szIconURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szIconURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szIconURL();
    this->_szIconURL.assign(szIconURL_);
}

inline void T_IconAttributes::setSzIconURL (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szIconURL();
    this->_szIconURL.assign(value, size);
}

inline void T_IconAttributes::set_has_u32IconWidth () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_IconAttributes::clear_has_u32IconWidth () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_IconAttributes::set_has_u32IconHeight () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_IconAttributes::clear_has_u32IconHeight () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_IconAttributes::set_has_u32IconDepth () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_IconAttributes::clear_has_u32IconDepth () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_IconAttributes::set_has_enIconMimeType () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_IconAttributes::clear_has_enIconMimeType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_IconAttributes::set_has_szIconURL () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_IconAttributes::clear_has_szIconURL () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_AppDetails::T_AppDetails ()  :
    _u32AppHandle (0u),
    _szAppName (),
    _enAppStatus (::midw_smartphoneint_fi_types::T_e8_AppStatus__FOREGROUND),
    _szAppVariant (),
    _szAppProviderName (),
    _szAppProviderURL (),
    _szAppDescription (),
    _AppAllowedProfiles (),
    _szAppCertificateURL (),
    _enAppCategory (::midw_smartphoneint_fi_types::T_e32_AppCategory__App_Unknown),
    _enTrustLevel (::midw_smartphoneint_fi_types::T_e16_TrustLevel__Unknown),
    _e8AppCertificationInfo (::midw_smartphoneint_fi_types::T_e8_AppCertificationInfo__NOT_CERTIFIED),
    _rAppDisplayInfo (),
    _rAppAudioInfo (),
    _rAppRemotingInfo (),
    _u16NumAppIcons (0u),
    _AppIconList (),
    _e8AppCertificationEntity (::midw_smartphoneint_fi_types::T_e8_AppCertificationEntity__NOT_CERTIFIED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AppDetails::T_AppDetails (const T_AppDetails &rhs)  :
    _u32AppHandle (0u),
    _szAppName (),
    _enAppStatus (::midw_smartphoneint_fi_types::T_e8_AppStatus__FOREGROUND),
    _szAppVariant (),
    _szAppProviderName (),
    _szAppProviderURL (),
    _szAppDescription (),
    _AppAllowedProfiles (),
    _szAppCertificateURL (),
    _enAppCategory (::midw_smartphoneint_fi_types::T_e32_AppCategory__App_Unknown),
    _enTrustLevel (::midw_smartphoneint_fi_types::T_e16_TrustLevel__Unknown),
    _e8AppCertificationInfo (::midw_smartphoneint_fi_types::T_e8_AppCertificationInfo__NOT_CERTIFIED),
    _rAppDisplayInfo (),
    _rAppAudioInfo (),
    _rAppRemotingInfo (),
    _u16NumAppIcons (0u),
    _AppIconList (),
    _e8AppCertificationEntity (::midw_smartphoneint_fi_types::T_e8_AppCertificationEntity__NOT_CERTIFIED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AppDetails::T_AppDetails (uint32 u32AppHandle_, const ::std::string& szAppName_, T_e8_AppStatus enAppStatus_, const ::std::string& szAppVariant_, const ::std::string& szAppProviderName_, const ::std::string& szAppProviderURL_, const ::std::string& szAppDescription_, const ::std::vector< ::std::string >& AppAllowedProfiles_, const ::std::string& szAppCertificateURL_, T_e32_AppCategory enAppCategory_, T_e16_TrustLevel enTrustLevel_, T_e8_AppCertificationInfo e8AppCertificationInfo_, const T_AppDisplayInfo& rAppDisplayInfo_, const T_AppAudioInfo& rAppAudioInfo_, const T_AppRemotingInfo& rAppRemotingInfo_, uint16 u16NumAppIcons_, const ::std::vector< T_IconAttributes >& AppIconList_, T_e8_AppCertificationEntity e8AppCertificationEntity_)  :
    _u32AppHandle (u32AppHandle_),
    _szAppName (szAppName_),
    _enAppStatus (enAppStatus_),
    _szAppVariant (szAppVariant_),
    _szAppProviderName (szAppProviderName_),
    _szAppProviderURL (szAppProviderURL_),
    _szAppDescription (szAppDescription_),
    _AppAllowedProfiles (AppAllowedProfiles_),
    _szAppCertificateURL (szAppCertificateURL_),
    _enAppCategory (enAppCategory_),
    _enTrustLevel (enTrustLevel_),
    _e8AppCertificationInfo (e8AppCertificationInfo_),
    _rAppDisplayInfo (rAppDisplayInfo_),
    _rAppAudioInfo (rAppAudioInfo_),
    _rAppRemotingInfo (rAppRemotingInfo_),
    _u16NumAppIcons (u16NumAppIcons_),
    _AppIconList (AppIconList_),
    _e8AppCertificationEntity (e8AppCertificationEntity_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_AppStatus_IsValid(enAppStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enAppStatus_, "T_e8_AppStatus", "enAppStatus", "T_AppDetails");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppVariant_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppProviderName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppProviderURL_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppCertificateURL_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e32_AppCategory_IsValid(enAppCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enAppCategory_, "T_e32_AppCategory", "enAppCategory", "T_AppDetails");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e16_TrustLevel_IsValid(enTrustLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTrustLevel_, "T_e16_TrustLevel", "enTrustLevel", "T_AppDetails");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AppCertificationInfo_IsValid(e8AppCertificationInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AppCertificationInfo_, "T_e8_AppCertificationInfo", "e8AppCertificationInfo", "T_AppDetails");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AppCertificationEntity_IsValid(e8AppCertificationEntity_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AppCertificationEntity_, "T_e8_AppCertificationEntity", "e8AppCertificationEntity", "T_AppDetails");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AppDetails::~T_AppDetails() {
}

inline T_AppDetails& T_AppDetails::operator = (const T_AppDetails& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32AppHandle()) {
            setU32AppHandle(rhs.getU32AppHandle());
        } else {
            clearU32AppHandle();
        }
        if (rhs.hasSzAppName()) {
            setSzAppName(rhs.getSzAppName());
        } else {
            clearSzAppName();
        }
        if (rhs.hasEnAppStatus()) {
            setEnAppStatus(rhs.getEnAppStatus());
        } else {
            clearEnAppStatus();
        }
        if (rhs.hasSzAppVariant()) {
            setSzAppVariant(rhs.getSzAppVariant());
        } else {
            clearSzAppVariant();
        }
        if (rhs.hasSzAppProviderName()) {
            setSzAppProviderName(rhs.getSzAppProviderName());
        } else {
            clearSzAppProviderName();
        }
        if (rhs.hasSzAppProviderURL()) {
            setSzAppProviderURL(rhs.getSzAppProviderURL());
        } else {
            clearSzAppProviderURL();
        }
        if (rhs.hasSzAppDescription()) {
            setSzAppDescription(rhs.getSzAppDescription());
        } else {
            clearSzAppDescription();
        }
        if (rhs.hasAppAllowedProfiles()) {
            setAppAllowedProfiles(rhs.getAppAllowedProfiles());
        } else {
            clearAppAllowedProfiles();
        }
        if (rhs.hasSzAppCertificateURL()) {
            setSzAppCertificateURL(rhs.getSzAppCertificateURL());
        } else {
            clearSzAppCertificateURL();
        }
        if (rhs.hasEnAppCategory()) {
            setEnAppCategory(rhs.getEnAppCategory());
        } else {
            clearEnAppCategory();
        }
        if (rhs.hasEnTrustLevel()) {
            setEnTrustLevel(rhs.getEnTrustLevel());
        } else {
            clearEnTrustLevel();
        }
        if (rhs.hasE8AppCertificationInfo()) {
            setE8AppCertificationInfo(rhs.getE8AppCertificationInfo());
        } else {
            clearE8AppCertificationInfo();
        }
        if (rhs.hasRAppDisplayInfo()) {
            setRAppDisplayInfo(rhs.getRAppDisplayInfo());
        } else {
            clearRAppDisplayInfo();
        }
        if (rhs.hasRAppAudioInfo()) {
            setRAppAudioInfo(rhs.getRAppAudioInfo());
        } else {
            clearRAppAudioInfo();
        }
        if (rhs.hasRAppRemotingInfo()) {
            setRAppRemotingInfo(rhs.getRAppRemotingInfo());
        } else {
            clearRAppRemotingInfo();
        }
        if (rhs.hasU16NumAppIcons()) {
            setU16NumAppIcons(rhs.getU16NumAppIcons());
        } else {
            clearU16NumAppIcons();
        }
        if (rhs.hasAppIconList()) {
            setAppIconList(rhs.getAppIconList());
        } else {
            clearAppIconList();
        }
        if (rhs.hasE8AppCertificationEntity()) {
            setE8AppCertificationEntity(rhs.getE8AppCertificationEntity());
        } else {
            clearE8AppCertificationEntity();
        }
    }
    return *this;
}

inline bool T_AppDetails::operator == (const T_AppDetails& rhs) const {
    return (((!hasU32AppHandle() && !rhs.hasU32AppHandle()) || getU32AppHandle() == rhs.getU32AppHandle()) &&
        ((!hasSzAppName() && !rhs.hasSzAppName()) || getSzAppName() == rhs.getSzAppName()) &&
        ((!hasEnAppStatus() && !rhs.hasEnAppStatus()) || getEnAppStatus() == rhs.getEnAppStatus()) &&
        ((!hasSzAppVariant() && !rhs.hasSzAppVariant()) || getSzAppVariant() == rhs.getSzAppVariant()) &&
        ((!hasSzAppProviderName() && !rhs.hasSzAppProviderName()) || getSzAppProviderName() == rhs.getSzAppProviderName()) &&
        ((!hasSzAppProviderURL() && !rhs.hasSzAppProviderURL()) || getSzAppProviderURL() == rhs.getSzAppProviderURL()) &&
        ((!hasSzAppDescription() && !rhs.hasSzAppDescription()) || getSzAppDescription() == rhs.getSzAppDescription()) &&
        ((!hasAppAllowedProfiles() && !rhs.hasAppAllowedProfiles()) || getAppAllowedProfiles() == rhs.getAppAllowedProfiles()) &&
        ((!hasSzAppCertificateURL() && !rhs.hasSzAppCertificateURL()) || getSzAppCertificateURL() == rhs.getSzAppCertificateURL()) &&
        ((!hasEnAppCategory() && !rhs.hasEnAppCategory()) || getEnAppCategory() == rhs.getEnAppCategory()) &&
        ((!hasEnTrustLevel() && !rhs.hasEnTrustLevel()) || getEnTrustLevel() == rhs.getEnTrustLevel()) &&
        ((!hasE8AppCertificationInfo() && !rhs.hasE8AppCertificationInfo()) || getE8AppCertificationInfo() == rhs.getE8AppCertificationInfo()) &&
        ((!hasRAppDisplayInfo() && !rhs.hasRAppDisplayInfo()) || getRAppDisplayInfo() == rhs.getRAppDisplayInfo()) &&
        ((!hasRAppAudioInfo() && !rhs.hasRAppAudioInfo()) || getRAppAudioInfo() == rhs.getRAppAudioInfo()) &&
        ((!hasRAppRemotingInfo() && !rhs.hasRAppRemotingInfo()) || getRAppRemotingInfo() == rhs.getRAppRemotingInfo()) &&
        ((!hasU16NumAppIcons() && !rhs.hasU16NumAppIcons()) || getU16NumAppIcons() == rhs.getU16NumAppIcons()) &&
        ((!hasAppIconList() && !rhs.hasAppIconList()) || getAppIconList() == rhs.getAppIconList()) &&
        ((!hasE8AppCertificationEntity() && !rhs.hasE8AppCertificationEntity()) || getE8AppCertificationEntity() == rhs.getE8AppCertificationEntity()));
}

inline bool T_AppDetails::operator != (const T_AppDetails& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AppDetails::operator < (const T_AppDetails& rhs) const {
    if (hasU32AppHandle() || rhs.hasU32AppHandle()) {
        if (getU32AppHandle() < rhs.getU32AppHandle()) return true;
        if (getU32AppHandle() > rhs.getU32AppHandle()) return false;
    }
    if (hasSzAppName() || rhs.hasSzAppName()) {
        if (getSzAppName() < rhs.getSzAppName()) return true;
        if (getSzAppName() > rhs.getSzAppName()) return false;
    }
    if (hasEnAppStatus() || rhs.hasEnAppStatus()) {
        if ((uint32)getEnAppStatus() < (uint32)rhs.getEnAppStatus()) return true;
        if ((uint32)getEnAppStatus() > (uint32)rhs.getEnAppStatus()) return false;
    }
    if (hasSzAppVariant() || rhs.hasSzAppVariant()) {
        if (getSzAppVariant() < rhs.getSzAppVariant()) return true;
        if (getSzAppVariant() > rhs.getSzAppVariant()) return false;
    }
    if (hasSzAppProviderName() || rhs.hasSzAppProviderName()) {
        if (getSzAppProviderName() < rhs.getSzAppProviderName()) return true;
        if (getSzAppProviderName() > rhs.getSzAppProviderName()) return false;
    }
    if (hasSzAppProviderURL() || rhs.hasSzAppProviderURL()) {
        if (getSzAppProviderURL() < rhs.getSzAppProviderURL()) return true;
        if (getSzAppProviderURL() > rhs.getSzAppProviderURL()) return false;
    }
    if (hasSzAppDescription() || rhs.hasSzAppDescription()) {
        if (getSzAppDescription() < rhs.getSzAppDescription()) return true;
        if (getSzAppDescription() > rhs.getSzAppDescription()) return false;
    }
    if (hasAppAllowedProfiles() || rhs.hasAppAllowedProfiles()) {
        if (getAppAllowedProfiles() < rhs.getAppAllowedProfiles()) return true;
        if (getAppAllowedProfiles() > rhs.getAppAllowedProfiles()) return false;
    }
    if (hasSzAppCertificateURL() || rhs.hasSzAppCertificateURL()) {
        if (getSzAppCertificateURL() < rhs.getSzAppCertificateURL()) return true;
        if (getSzAppCertificateURL() > rhs.getSzAppCertificateURL()) return false;
    }
    if (hasEnAppCategory() || rhs.hasEnAppCategory()) {
        if ((uint32)getEnAppCategory() < (uint32)rhs.getEnAppCategory()) return true;
        if ((uint32)getEnAppCategory() > (uint32)rhs.getEnAppCategory()) return false;
    }
    if (hasEnTrustLevel() || rhs.hasEnTrustLevel()) {
        if ((uint32)getEnTrustLevel() < (uint32)rhs.getEnTrustLevel()) return true;
        if ((uint32)getEnTrustLevel() > (uint32)rhs.getEnTrustLevel()) return false;
    }
    if (hasE8AppCertificationInfo() || rhs.hasE8AppCertificationInfo()) {
        if ((uint32)getE8AppCertificationInfo() < (uint32)rhs.getE8AppCertificationInfo()) return true;
        if ((uint32)getE8AppCertificationInfo() > (uint32)rhs.getE8AppCertificationInfo()) return false;
    }
    if (hasRAppDisplayInfo() || rhs.hasRAppDisplayInfo()) {
        if (getRAppDisplayInfo() < rhs.getRAppDisplayInfo()) return true;
        if (getRAppDisplayInfo() > rhs.getRAppDisplayInfo()) return false;
    }
    if (hasRAppAudioInfo() || rhs.hasRAppAudioInfo()) {
        if (getRAppAudioInfo() < rhs.getRAppAudioInfo()) return true;
        if (getRAppAudioInfo() > rhs.getRAppAudioInfo()) return false;
    }
    if (hasRAppRemotingInfo() || rhs.hasRAppRemotingInfo()) {
        if (getRAppRemotingInfo() < rhs.getRAppRemotingInfo()) return true;
        if (getRAppRemotingInfo() > rhs.getRAppRemotingInfo()) return false;
    }
    if (hasU16NumAppIcons() || rhs.hasU16NumAppIcons()) {
        if (getU16NumAppIcons() < rhs.getU16NumAppIcons()) return true;
        if (getU16NumAppIcons() > rhs.getU16NumAppIcons()) return false;
    }
    if (hasAppIconList() || rhs.hasAppIconList()) {
        if (getAppIconList() < rhs.getAppIconList()) return true;
        if (getAppIconList() > rhs.getAppIconList()) return false;
    }
    if (hasE8AppCertificationEntity() || rhs.hasE8AppCertificationEntity()) {
        if ((uint32)getE8AppCertificationEntity() < (uint32)rhs.getE8AppCertificationEntity()) return true;
        if ((uint32)getE8AppCertificationEntity() > (uint32)rhs.getE8AppCertificationEntity()) return false;
    }
    return false;
}

inline bool T_AppDetails::operator > (const T_AppDetails& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AppDetails::clear() {
    clearU32AppHandle();
    clearSzAppName();
    clearEnAppStatus();
    clearSzAppVariant();
    clearSzAppProviderName();
    clearSzAppProviderURL();
    clearSzAppDescription();
    clearAppAllowedProfiles();
    clearSzAppCertificateURL();
    clearEnAppCategory();
    clearEnTrustLevel();
    clearE8AppCertificationInfo();
    clearRAppDisplayInfo();
    clearRAppAudioInfo();
    clearRAppRemotingInfo();
    clearU16NumAppIcons();
    clearAppIconList();
    clearE8AppCertificationEntity();
}

inline void T_AppDetails::clearU32AppHandle() {
    if (hasU32AppHandle()) {
         clear_has_u32AppHandle();
        _u32AppHandle = 0u;
     }
}

inline bool T_AppDetails::hasU32AppHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_AppDetails::getU32AppHandle () const {
    return _u32AppHandle;
}

inline void T_AppDetails::setU32AppHandle (uint32 u32AppHandle_) {
    set_has_u32AppHandle();
    this->_u32AppHandle = u32AppHandle_;
}

inline void T_AppDetails::clearSzAppName() {
    if (hasSzAppName()) {
         clear_has_szAppName();
        _szAppName.clear();
     }
}

inline bool T_AppDetails::hasSzAppName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_AppDetails::getSzAppName () const {
    return _szAppName;
}

inline ::std::string& T_AppDetails::getSzAppNameMutable () {
    set_has_szAppName();
    return _szAppName;
}

inline void T_AppDetails::setSzAppName (const ::std::string& szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName = szAppName_;
}

inline void T_AppDetails::setSzAppName (const char* szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(szAppName_);
}

inline void T_AppDetails::setSzAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(value, size);
}

inline void T_AppDetails::clearEnAppStatus() {
    if (hasEnAppStatus()) {
         clear_has_enAppStatus();
        _enAppStatus = ::midw_smartphoneint_fi_types::T_e8_AppStatus__FOREGROUND;
     }
}

inline bool T_AppDetails::hasEnAppStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_AppStatus T_AppDetails::getEnAppStatus () const {
    return _enAppStatus;
}

inline void T_AppDetails::setEnAppStatus (T_e8_AppStatus enAppStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_AppStatus_IsValid(enAppStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enAppStatus_, "T_e8_AppStatus", "enAppStatus", "T_AppDetails");
    }
    #endif
    set_has_enAppStatus();
    this->_enAppStatus = enAppStatus_;
}

inline void T_AppDetails::clearSzAppVariant() {
    if (hasSzAppVariant()) {
         clear_has_szAppVariant();
        _szAppVariant.clear();
     }
}

inline bool T_AppDetails::hasSzAppVariant () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_AppDetails::getSzAppVariant () const {
    return _szAppVariant;
}

inline ::std::string& T_AppDetails::getSzAppVariantMutable () {
    set_has_szAppVariant();
    return _szAppVariant;
}

inline void T_AppDetails::setSzAppVariant (const ::std::string& szAppVariant_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppVariant_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppVariant();
    this->_szAppVariant = szAppVariant_;
}

inline void T_AppDetails::setSzAppVariant (const char* szAppVariant_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppVariant_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppVariant();
    this->_szAppVariant.assign(szAppVariant_);
}

inline void T_AppDetails::setSzAppVariant (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppVariant();
    this->_szAppVariant.assign(value, size);
}

inline void T_AppDetails::clearSzAppProviderName() {
    if (hasSzAppProviderName()) {
         clear_has_szAppProviderName();
        _szAppProviderName.clear();
     }
}

inline bool T_AppDetails::hasSzAppProviderName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_AppDetails::getSzAppProviderName () const {
    return _szAppProviderName;
}

inline ::std::string& T_AppDetails::getSzAppProviderNameMutable () {
    set_has_szAppProviderName();
    return _szAppProviderName;
}

inline void T_AppDetails::setSzAppProviderName (const ::std::string& szAppProviderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppProviderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppProviderName();
    this->_szAppProviderName = szAppProviderName_;
}

inline void T_AppDetails::setSzAppProviderName (const char* szAppProviderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppProviderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppProviderName();
    this->_szAppProviderName.assign(szAppProviderName_);
}

inline void T_AppDetails::setSzAppProviderName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppProviderName();
    this->_szAppProviderName.assign(value, size);
}

inline void T_AppDetails::clearSzAppProviderURL() {
    if (hasSzAppProviderURL()) {
         clear_has_szAppProviderURL();
        _szAppProviderURL.clear();
     }
}

inline bool T_AppDetails::hasSzAppProviderURL () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_AppDetails::getSzAppProviderURL () const {
    return _szAppProviderURL;
}

inline ::std::string& T_AppDetails::getSzAppProviderURLMutable () {
    set_has_szAppProviderURL();
    return _szAppProviderURL;
}

inline void T_AppDetails::setSzAppProviderURL (const ::std::string& szAppProviderURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppProviderURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppProviderURL();
    this->_szAppProviderURL = szAppProviderURL_;
}

inline void T_AppDetails::setSzAppProviderURL (const char* szAppProviderURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppProviderURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppProviderURL();
    this->_szAppProviderURL.assign(szAppProviderURL_);
}

inline void T_AppDetails::setSzAppProviderURL (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppProviderURL();
    this->_szAppProviderURL.assign(value, size);
}

inline void T_AppDetails::clearSzAppDescription() {
    if (hasSzAppDescription()) {
         clear_has_szAppDescription();
        _szAppDescription.clear();
     }
}

inline bool T_AppDetails::hasSzAppDescription () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_AppDetails::getSzAppDescription () const {
    return _szAppDescription;
}

inline ::std::string& T_AppDetails::getSzAppDescriptionMutable () {
    set_has_szAppDescription();
    return _szAppDescription;
}

inline void T_AppDetails::setSzAppDescription (const ::std::string& szAppDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppDescription();
    this->_szAppDescription = szAppDescription_;
}

inline void T_AppDetails::setSzAppDescription (const char* szAppDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppDescription();
    this->_szAppDescription.assign(szAppDescription_);
}

inline void T_AppDetails::setSzAppDescription (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppDescription();
    this->_szAppDescription.assign(value, size);
}

inline void T_AppDetails::clearAppAllowedProfiles() {
    if (hasAppAllowedProfiles()) {
         clear_has_AppAllowedProfiles();
        _AppAllowedProfiles.clear();
     }
}

inline bool T_AppDetails::hasAppAllowedProfiles () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::vector< ::std::string >& T_AppDetails::getAppAllowedProfiles () const {
    return _AppAllowedProfiles;
}

inline ::std::vector< ::std::string >& T_AppDetails::getAppAllowedProfilesMutable () {
    set_has_AppAllowedProfiles();
    return _AppAllowedProfiles;
}

inline void T_AppDetails::setAppAllowedProfiles (const ::std::vector< ::std::string >& AppAllowedProfiles_) {
    set_has_AppAllowedProfiles();
    this->_AppAllowedProfiles = AppAllowedProfiles_;
}

inline void T_AppDetails::clearSzAppCertificateURL() {
    if (hasSzAppCertificateURL()) {
         clear_has_szAppCertificateURL();
        _szAppCertificateURL.clear();
     }
}

inline bool T_AppDetails::hasSzAppCertificateURL () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_AppDetails::getSzAppCertificateURL () const {
    return _szAppCertificateURL;
}

inline ::std::string& T_AppDetails::getSzAppCertificateURLMutable () {
    set_has_szAppCertificateURL();
    return _szAppCertificateURL;
}

inline void T_AppDetails::setSzAppCertificateURL (const ::std::string& szAppCertificateURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppCertificateURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppCertificateURL();
    this->_szAppCertificateURL = szAppCertificateURL_;
}

inline void T_AppDetails::setSzAppCertificateURL (const char* szAppCertificateURL_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppCertificateURL_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppCertificateURL();
    this->_szAppCertificateURL.assign(szAppCertificateURL_);
}

inline void T_AppDetails::setSzAppCertificateURL (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppCertificateURL();
    this->_szAppCertificateURL.assign(value, size);
}

inline void T_AppDetails::clearEnAppCategory() {
    if (hasEnAppCategory()) {
         clear_has_enAppCategory();
        _enAppCategory = ::midw_smartphoneint_fi_types::T_e32_AppCategory__App_Unknown;
     }
}

inline bool T_AppDetails::hasEnAppCategory () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline T_e32_AppCategory T_AppDetails::getEnAppCategory () const {
    return _enAppCategory;
}

inline void T_AppDetails::setEnAppCategory (T_e32_AppCategory enAppCategory_) {
    #ifndef NDEBUG
    if (!(T_e32_AppCategory_IsValid(enAppCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enAppCategory_, "T_e32_AppCategory", "enAppCategory", "T_AppDetails");
    }
    #endif
    set_has_enAppCategory();
    this->_enAppCategory = enAppCategory_;
}

inline void T_AppDetails::clearEnTrustLevel() {
    if (hasEnTrustLevel()) {
         clear_has_enTrustLevel();
        _enTrustLevel = ::midw_smartphoneint_fi_types::T_e16_TrustLevel__Unknown;
     }
}

inline bool T_AppDetails::hasEnTrustLevel () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline T_e16_TrustLevel T_AppDetails::getEnTrustLevel () const {
    return _enTrustLevel;
}

inline void T_AppDetails::setEnTrustLevel (T_e16_TrustLevel enTrustLevel_) {
    #ifndef NDEBUG
    if (!(T_e16_TrustLevel_IsValid(enTrustLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTrustLevel_, "T_e16_TrustLevel", "enTrustLevel", "T_AppDetails");
    }
    #endif
    set_has_enTrustLevel();
    this->_enTrustLevel = enTrustLevel_;
}

inline void T_AppDetails::clearE8AppCertificationInfo() {
    if (hasE8AppCertificationInfo()) {
         clear_has_e8AppCertificationInfo();
        _e8AppCertificationInfo = ::midw_smartphoneint_fi_types::T_e8_AppCertificationInfo__NOT_CERTIFIED;
     }
}

inline bool T_AppDetails::hasE8AppCertificationInfo () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline T_e8_AppCertificationInfo T_AppDetails::getE8AppCertificationInfo () const {
    return _e8AppCertificationInfo;
}

inline void T_AppDetails::setE8AppCertificationInfo (T_e8_AppCertificationInfo e8AppCertificationInfo_) {
    #ifndef NDEBUG
    if (!(T_e8_AppCertificationInfo_IsValid(e8AppCertificationInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AppCertificationInfo_, "T_e8_AppCertificationInfo", "e8AppCertificationInfo", "T_AppDetails");
    }
    #endif
    set_has_e8AppCertificationInfo();
    this->_e8AppCertificationInfo = e8AppCertificationInfo_;
}

inline void T_AppDetails::clearRAppDisplayInfo() {
    if (hasRAppDisplayInfo()) {
         clear_has_rAppDisplayInfo();
        _rAppDisplayInfo.clear();
     }
}

inline bool T_AppDetails::hasRAppDisplayInfo () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const T_AppDisplayInfo& T_AppDetails::getRAppDisplayInfo () const {
    return _rAppDisplayInfo;
}

inline T_AppDisplayInfo& T_AppDetails::getRAppDisplayInfoMutable () {
    set_has_rAppDisplayInfo();
    return _rAppDisplayInfo;
}

inline void T_AppDetails::setRAppDisplayInfo (const T_AppDisplayInfo& rAppDisplayInfo_) {
    set_has_rAppDisplayInfo();
    this->_rAppDisplayInfo = rAppDisplayInfo_;
}

inline void T_AppDetails::clearRAppAudioInfo() {
    if (hasRAppAudioInfo()) {
         clear_has_rAppAudioInfo();
        _rAppAudioInfo.clear();
     }
}

inline bool T_AppDetails::hasRAppAudioInfo () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline const T_AppAudioInfo& T_AppDetails::getRAppAudioInfo () const {
    return _rAppAudioInfo;
}

inline T_AppAudioInfo& T_AppDetails::getRAppAudioInfoMutable () {
    set_has_rAppAudioInfo();
    return _rAppAudioInfo;
}

inline void T_AppDetails::setRAppAudioInfo (const T_AppAudioInfo& rAppAudioInfo_) {
    set_has_rAppAudioInfo();
    this->_rAppAudioInfo = rAppAudioInfo_;
}

inline void T_AppDetails::clearRAppRemotingInfo() {
    if (hasRAppRemotingInfo()) {
         clear_has_rAppRemotingInfo();
        _rAppRemotingInfo.clear();
     }
}

inline bool T_AppDetails::hasRAppRemotingInfo () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const T_AppRemotingInfo& T_AppDetails::getRAppRemotingInfo () const {
    return _rAppRemotingInfo;
}

inline T_AppRemotingInfo& T_AppDetails::getRAppRemotingInfoMutable () {
    set_has_rAppRemotingInfo();
    return _rAppRemotingInfo;
}

inline void T_AppDetails::setRAppRemotingInfo (const T_AppRemotingInfo& rAppRemotingInfo_) {
    set_has_rAppRemotingInfo();
    this->_rAppRemotingInfo = rAppRemotingInfo_;
}

inline void T_AppDetails::clearU16NumAppIcons() {
    if (hasU16NumAppIcons()) {
         clear_has_u16NumAppIcons();
        _u16NumAppIcons = 0u;
     }
}

inline bool T_AppDetails::hasU16NumAppIcons () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint16 T_AppDetails::getU16NumAppIcons () const {
    return _u16NumAppIcons;
}

inline void T_AppDetails::setU16NumAppIcons (uint16 u16NumAppIcons_) {
    set_has_u16NumAppIcons();
    this->_u16NumAppIcons = u16NumAppIcons_;
}

inline void T_AppDetails::clearAppIconList() {
    if (hasAppIconList()) {
         clear_has_AppIconList();
        _AppIconList.clear();
     }
}

inline bool T_AppDetails::hasAppIconList () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline const ::std::vector< T_IconAttributes >& T_AppDetails::getAppIconList () const {
    return _AppIconList;
}

inline ::std::vector< T_IconAttributes >& T_AppDetails::getAppIconListMutable () {
    set_has_AppIconList();
    return _AppIconList;
}

inline void T_AppDetails::setAppIconList (const ::std::vector< T_IconAttributes >& AppIconList_) {
    set_has_AppIconList();
    this->_AppIconList = AppIconList_;
}

inline void T_AppDetails::clearE8AppCertificationEntity() {
    if (hasE8AppCertificationEntity()) {
         clear_has_e8AppCertificationEntity();
        _e8AppCertificationEntity = ::midw_smartphoneint_fi_types::T_e8_AppCertificationEntity__NOT_CERTIFIED;
     }
}

inline bool T_AppDetails::hasE8AppCertificationEntity () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline T_e8_AppCertificationEntity T_AppDetails::getE8AppCertificationEntity () const {
    return _e8AppCertificationEntity;
}

inline void T_AppDetails::setE8AppCertificationEntity (T_e8_AppCertificationEntity e8AppCertificationEntity_) {
    #ifndef NDEBUG
    if (!(T_e8_AppCertificationEntity_IsValid(e8AppCertificationEntity_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AppCertificationEntity_, "T_e8_AppCertificationEntity", "e8AppCertificationEntity", "T_AppDetails");
    }
    #endif
    set_has_e8AppCertificationEntity();
    this->_e8AppCertificationEntity = e8AppCertificationEntity_;
}

inline void T_AppDetails::set_has_u32AppHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AppDetails::clear_has_u32AppHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AppDetails::set_has_szAppName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AppDetails::clear_has_szAppName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AppDetails::set_has_enAppStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AppDetails::clear_has_enAppStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AppDetails::set_has_szAppVariant () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AppDetails::clear_has_szAppVariant () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_AppDetails::set_has_szAppProviderName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_AppDetails::clear_has_szAppProviderName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_AppDetails::set_has_szAppProviderURL () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_AppDetails::clear_has_szAppProviderURL () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_AppDetails::set_has_szAppDescription () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_AppDetails::clear_has_szAppDescription () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_AppDetails::set_has_AppAllowedProfiles () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_AppDetails::clear_has_AppAllowedProfiles () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_AppDetails::set_has_szAppCertificateURL () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_AppDetails::clear_has_szAppCertificateURL () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_AppDetails::set_has_enAppCategory () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_AppDetails::clear_has_enAppCategory () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_AppDetails::set_has_enTrustLevel () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_AppDetails::clear_has_enTrustLevel () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_AppDetails::set_has_e8AppCertificationInfo () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_AppDetails::clear_has_e8AppCertificationInfo () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_AppDetails::set_has_rAppDisplayInfo () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_AppDetails::clear_has_rAppDisplayInfo () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_AppDetails::set_has_rAppAudioInfo () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_AppDetails::clear_has_rAppAudioInfo () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_AppDetails::set_has_rAppRemotingInfo () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_AppDetails::clear_has_rAppRemotingInfo () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_AppDetails::set_has_u16NumAppIcons () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_AppDetails::clear_has_u16NumAppIcons () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_AppDetails::set_has_AppIconList () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_AppDetails::clear_has_AppIconList () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_AppDetails::set_has_e8AppCertificationEntity () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_AppDetails::clear_has_e8AppCertificationEntity () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline  T_EAPAppInfo::T_EAPAppInfo ()  :
    _szAppName (),
    _szProtocol (),
    _szBundleID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_EAPAppInfo::T_EAPAppInfo (const T_EAPAppInfo &rhs)  :
    _szAppName (),
    _szProtocol (),
    _szBundleID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_EAPAppInfo::T_EAPAppInfo (const ::std::string& szAppName_, const ::std::string& szProtocol_, const ::std::string& szBundleID_)  :
    _szAppName (szAppName_),
    _szProtocol (szProtocol_),
    _szBundleID (szBundleID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szProtocol_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szBundleID_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_EAPAppInfo::~T_EAPAppInfo() {
}

inline T_EAPAppInfo& T_EAPAppInfo::operator = (const T_EAPAppInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSzAppName()) {
            setSzAppName(rhs.getSzAppName());
        } else {
            clearSzAppName();
        }
        if (rhs.hasSzProtocol()) {
            setSzProtocol(rhs.getSzProtocol());
        } else {
            clearSzProtocol();
        }
        if (rhs.hasSzBundleID()) {
            setSzBundleID(rhs.getSzBundleID());
        } else {
            clearSzBundleID();
        }
    }
    return *this;
}

inline bool T_EAPAppInfo::operator == (const T_EAPAppInfo& rhs) const {
    return (((!hasSzAppName() && !rhs.hasSzAppName()) || getSzAppName() == rhs.getSzAppName()) &&
        ((!hasSzProtocol() && !rhs.hasSzProtocol()) || getSzProtocol() == rhs.getSzProtocol()) &&
        ((!hasSzBundleID() && !rhs.hasSzBundleID()) || getSzBundleID() == rhs.getSzBundleID()));
}

inline bool T_EAPAppInfo::operator != (const T_EAPAppInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_EAPAppInfo::operator < (const T_EAPAppInfo& rhs) const {
    if (hasSzAppName() || rhs.hasSzAppName()) {
        if (getSzAppName() < rhs.getSzAppName()) return true;
        if (getSzAppName() > rhs.getSzAppName()) return false;
    }
    if (hasSzProtocol() || rhs.hasSzProtocol()) {
        if (getSzProtocol() < rhs.getSzProtocol()) return true;
        if (getSzProtocol() > rhs.getSzProtocol()) return false;
    }
    if (hasSzBundleID() || rhs.hasSzBundleID()) {
        if (getSzBundleID() < rhs.getSzBundleID()) return true;
        if (getSzBundleID() > rhs.getSzBundleID()) return false;
    }
    return false;
}

inline bool T_EAPAppInfo::operator > (const T_EAPAppInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_EAPAppInfo::clear() {
    clearSzAppName();
    clearSzProtocol();
    clearSzBundleID();
}

inline void T_EAPAppInfo::clearSzAppName() {
    if (hasSzAppName()) {
         clear_has_szAppName();
        _szAppName.clear();
     }
}

inline bool T_EAPAppInfo::hasSzAppName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_EAPAppInfo::getSzAppName () const {
    return _szAppName;
}

inline ::std::string& T_EAPAppInfo::getSzAppNameMutable () {
    set_has_szAppName();
    return _szAppName;
}

inline void T_EAPAppInfo::setSzAppName (const ::std::string& szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName = szAppName_;
}

inline void T_EAPAppInfo::setSzAppName (const char* szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(szAppName_);
}

inline void T_EAPAppInfo::setSzAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(value, size);
}

inline void T_EAPAppInfo::clearSzProtocol() {
    if (hasSzProtocol()) {
         clear_has_szProtocol();
        _szProtocol.clear();
     }
}

inline bool T_EAPAppInfo::hasSzProtocol () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_EAPAppInfo::getSzProtocol () const {
    return _szProtocol;
}

inline ::std::string& T_EAPAppInfo::getSzProtocolMutable () {
    set_has_szProtocol();
    return _szProtocol;
}

inline void T_EAPAppInfo::setSzProtocol (const ::std::string& szProtocol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szProtocol_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szProtocol();
    this->_szProtocol = szProtocol_;
}

inline void T_EAPAppInfo::setSzProtocol (const char* szProtocol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szProtocol_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szProtocol();
    this->_szProtocol.assign(szProtocol_);
}

inline void T_EAPAppInfo::setSzProtocol (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szProtocol();
    this->_szProtocol.assign(value, size);
}

inline void T_EAPAppInfo::clearSzBundleID() {
    if (hasSzBundleID()) {
         clear_has_szBundleID();
        _szBundleID.clear();
     }
}

inline bool T_EAPAppInfo::hasSzBundleID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_EAPAppInfo::getSzBundleID () const {
    return _szBundleID;
}

inline ::std::string& T_EAPAppInfo::getSzBundleIDMutable () {
    set_has_szBundleID();
    return _szBundleID;
}

inline void T_EAPAppInfo::setSzBundleID (const ::std::string& szBundleID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szBundleID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szBundleID();
    this->_szBundleID = szBundleID_;
}

inline void T_EAPAppInfo::setSzBundleID (const char* szBundleID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szBundleID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szBundleID();
    this->_szBundleID.assign(szBundleID_);
}

inline void T_EAPAppInfo::setSzBundleID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szBundleID();
    this->_szBundleID.assign(value, size);
}

inline void T_EAPAppInfo::set_has_szAppName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_EAPAppInfo::clear_has_szAppName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_EAPAppInfo::set_has_szProtocol () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_EAPAppInfo::clear_has_szProtocol () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_EAPAppInfo::set_has_szBundleID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_EAPAppInfo::clear_has_szBundleID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TouchCoordinates::T_TouchCoordinates ()  :
    _enTouchMode (::midw_smartphoneint_fi_types::T_e8_TouchMode__TOUCH_RELEASE),
    _u16XCoordinate (0u),
    _u16YCoordinate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TouchCoordinates::T_TouchCoordinates (const T_TouchCoordinates &rhs)  :
    _enTouchMode (::midw_smartphoneint_fi_types::T_e8_TouchMode__TOUCH_RELEASE),
    _u16XCoordinate (0u),
    _u16YCoordinate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TouchCoordinates::T_TouchCoordinates (T_e8_TouchMode enTouchMode_, uint16 u16XCoordinate_, uint16 u16YCoordinate_)  :
    _enTouchMode (enTouchMode_),
    _u16XCoordinate (u16XCoordinate_),
    _u16YCoordinate (u16YCoordinate_)
{
    #ifndef NDEBUG
    if (!(T_e8_TouchMode_IsValid(enTouchMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTouchMode_, "T_e8_TouchMode", "enTouchMode", "T_TouchCoordinates");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TouchCoordinates::~T_TouchCoordinates() {
}

inline T_TouchCoordinates& T_TouchCoordinates::operator = (const T_TouchCoordinates& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnTouchMode()) {
            setEnTouchMode(rhs.getEnTouchMode());
        } else {
            clearEnTouchMode();
        }
        if (rhs.hasU16XCoordinate()) {
            setU16XCoordinate(rhs.getU16XCoordinate());
        } else {
            clearU16XCoordinate();
        }
        if (rhs.hasU16YCoordinate()) {
            setU16YCoordinate(rhs.getU16YCoordinate());
        } else {
            clearU16YCoordinate();
        }
    }
    return *this;
}

inline bool T_TouchCoordinates::operator == (const T_TouchCoordinates& rhs) const {
    return (((!hasEnTouchMode() && !rhs.hasEnTouchMode()) || getEnTouchMode() == rhs.getEnTouchMode()) &&
        ((!hasU16XCoordinate() && !rhs.hasU16XCoordinate()) || getU16XCoordinate() == rhs.getU16XCoordinate()) &&
        ((!hasU16YCoordinate() && !rhs.hasU16YCoordinate()) || getU16YCoordinate() == rhs.getU16YCoordinate()));
}

inline bool T_TouchCoordinates::operator != (const T_TouchCoordinates& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TouchCoordinates::operator < (const T_TouchCoordinates& rhs) const {
    if (hasEnTouchMode() || rhs.hasEnTouchMode()) {
        if ((uint32)getEnTouchMode() < (uint32)rhs.getEnTouchMode()) return true;
        if ((uint32)getEnTouchMode() > (uint32)rhs.getEnTouchMode()) return false;
    }
    if (hasU16XCoordinate() || rhs.hasU16XCoordinate()) {
        if (getU16XCoordinate() < rhs.getU16XCoordinate()) return true;
        if (getU16XCoordinate() > rhs.getU16XCoordinate()) return false;
    }
    if (hasU16YCoordinate() || rhs.hasU16YCoordinate()) {
        if (getU16YCoordinate() < rhs.getU16YCoordinate()) return true;
        if (getU16YCoordinate() > rhs.getU16YCoordinate()) return false;
    }
    return false;
}

inline bool T_TouchCoordinates::operator > (const T_TouchCoordinates& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TouchCoordinates::clear() {
    clearEnTouchMode();
    clearU16XCoordinate();
    clearU16YCoordinate();
}

inline void T_TouchCoordinates::clearEnTouchMode() {
    if (hasEnTouchMode()) {
         clear_has_enTouchMode();
        _enTouchMode = ::midw_smartphoneint_fi_types::T_e8_TouchMode__TOUCH_RELEASE;
     }
}

inline bool T_TouchCoordinates::hasEnTouchMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TouchMode T_TouchCoordinates::getEnTouchMode () const {
    return _enTouchMode;
}

inline void T_TouchCoordinates::setEnTouchMode (T_e8_TouchMode enTouchMode_) {
    #ifndef NDEBUG
    if (!(T_e8_TouchMode_IsValid(enTouchMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enTouchMode_, "T_e8_TouchMode", "enTouchMode", "T_TouchCoordinates");
    }
    #endif
    set_has_enTouchMode();
    this->_enTouchMode = enTouchMode_;
}

inline void T_TouchCoordinates::clearU16XCoordinate() {
    if (hasU16XCoordinate()) {
         clear_has_u16XCoordinate();
        _u16XCoordinate = 0u;
     }
}

inline bool T_TouchCoordinates::hasU16XCoordinate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_TouchCoordinates::getU16XCoordinate () const {
    return _u16XCoordinate;
}

inline void T_TouchCoordinates::setU16XCoordinate (uint16 u16XCoordinate_) {
    set_has_u16XCoordinate();
    this->_u16XCoordinate = u16XCoordinate_;
}

inline void T_TouchCoordinates::clearU16YCoordinate() {
    if (hasU16YCoordinate()) {
         clear_has_u16YCoordinate();
        _u16YCoordinate = 0u;
     }
}

inline bool T_TouchCoordinates::hasU16YCoordinate () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_TouchCoordinates::getU16YCoordinate () const {
    return _u16YCoordinate;
}

inline void T_TouchCoordinates::setU16YCoordinate (uint16 u16YCoordinate_) {
    set_has_u16YCoordinate();
    this->_u16YCoordinate = u16YCoordinate_;
}

inline void T_TouchCoordinates::set_has_enTouchMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TouchCoordinates::clear_has_enTouchMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TouchCoordinates::set_has_u16XCoordinate () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TouchCoordinates::clear_has_u16XCoordinate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TouchCoordinates::set_has_u16YCoordinate () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TouchCoordinates::clear_has_u16YCoordinate () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TouchData::T_TouchData ()  :
    _u16TouchDescriptors (0u),
    _TouchInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TouchData::T_TouchData (const T_TouchData &rhs)  :
    _u16TouchDescriptors (0u),
    _TouchInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TouchData::T_TouchData (uint16 u16TouchDescriptors_, const ::std::vector< T_TouchInfo >& TouchInfoList_)  :
    _u16TouchDescriptors (u16TouchDescriptors_),
    _TouchInfoList (TouchInfoList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TouchData::~T_TouchData() {
}

inline T_TouchData& T_TouchData::operator = (const T_TouchData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16TouchDescriptors()) {
            setU16TouchDescriptors(rhs.getU16TouchDescriptors());
        } else {
            clearU16TouchDescriptors();
        }
        if (rhs.hasTouchInfoList()) {
            setTouchInfoList(rhs.getTouchInfoList());
        } else {
            clearTouchInfoList();
        }
    }
    return *this;
}

inline bool T_TouchData::operator == (const T_TouchData& rhs) const {
    return (((!hasU16TouchDescriptors() && !rhs.hasU16TouchDescriptors()) || getU16TouchDescriptors() == rhs.getU16TouchDescriptors()) &&
        ((!hasTouchInfoList() && !rhs.hasTouchInfoList()) || getTouchInfoList() == rhs.getTouchInfoList()));
}

inline bool T_TouchData::operator != (const T_TouchData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TouchData::operator < (const T_TouchData& rhs) const {
    if (hasU16TouchDescriptors() || rhs.hasU16TouchDescriptors()) {
        if (getU16TouchDescriptors() < rhs.getU16TouchDescriptors()) return true;
        if (getU16TouchDescriptors() > rhs.getU16TouchDescriptors()) return false;
    }
    if (hasTouchInfoList() || rhs.hasTouchInfoList()) {
        if (getTouchInfoList() < rhs.getTouchInfoList()) return true;
        if (getTouchInfoList() > rhs.getTouchInfoList()) return false;
    }
    return false;
}

inline bool T_TouchData::operator > (const T_TouchData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TouchData::clear() {
    clearU16TouchDescriptors();
    clearTouchInfoList();
}

inline void T_TouchData::clearU16TouchDescriptors() {
    if (hasU16TouchDescriptors()) {
         clear_has_u16TouchDescriptors();
        _u16TouchDescriptors = 0u;
     }
}

inline bool T_TouchData::hasU16TouchDescriptors () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_TouchData::getU16TouchDescriptors () const {
    return _u16TouchDescriptors;
}

inline void T_TouchData::setU16TouchDescriptors (uint16 u16TouchDescriptors_) {
    set_has_u16TouchDescriptors();
    this->_u16TouchDescriptors = u16TouchDescriptors_;
}

inline void T_TouchData::clearTouchInfoList() {
    if (hasTouchInfoList()) {
         clear_has_TouchInfoList();
        _TouchInfoList.clear();
     }
}

inline bool T_TouchData::hasTouchInfoList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_TouchInfo >& T_TouchData::getTouchInfoList () const {
    return _TouchInfoList;
}

inline ::std::vector< T_TouchInfo >& T_TouchData::getTouchInfoListMutable () {
    set_has_TouchInfoList();
    return _TouchInfoList;
}

inline void T_TouchData::setTouchInfoList (const ::std::vector< T_TouchInfo >& TouchInfoList_) {
    set_has_TouchInfoList();
    this->_TouchInfoList = TouchInfoList_;
}

inline void T_TouchData::set_has_u16TouchDescriptors () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TouchData::clear_has_u16TouchDescriptors () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TouchData::set_has_TouchInfoList () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TouchData::clear_has_TouchInfoList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_ScreenAttributes::T_ScreenAttributes ()  :
    _u16ScreenHeight (0u),
    _u16ScreenWidth (0u),
    _enScreenAspectRatio (::midw_smartphoneint_fi_types::T_e8_ScreenAspectRatio__ASPECT_UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ScreenAttributes::T_ScreenAttributes (const T_ScreenAttributes &rhs)  :
    _u16ScreenHeight (0u),
    _u16ScreenWidth (0u),
    _enScreenAspectRatio (::midw_smartphoneint_fi_types::T_e8_ScreenAspectRatio__ASPECT_UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ScreenAttributes::T_ScreenAttributes (uint16 u16ScreenHeight_, uint16 u16ScreenWidth_, T_e8_ScreenAspectRatio enScreenAspectRatio_)  :
    _u16ScreenHeight (u16ScreenHeight_),
    _u16ScreenWidth (u16ScreenWidth_),
    _enScreenAspectRatio (enScreenAspectRatio_)
{
    #ifndef NDEBUG
    if (!(T_e8_ScreenAspectRatio_IsValid(enScreenAspectRatio_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enScreenAspectRatio_, "T_e8_ScreenAspectRatio", "enScreenAspectRatio", "T_ScreenAttributes");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ScreenAttributes::~T_ScreenAttributes() {
}

inline T_ScreenAttributes& T_ScreenAttributes::operator = (const T_ScreenAttributes& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16ScreenHeight()) {
            setU16ScreenHeight(rhs.getU16ScreenHeight());
        } else {
            clearU16ScreenHeight();
        }
        if (rhs.hasU16ScreenWidth()) {
            setU16ScreenWidth(rhs.getU16ScreenWidth());
        } else {
            clearU16ScreenWidth();
        }
        if (rhs.hasEnScreenAspectRatio()) {
            setEnScreenAspectRatio(rhs.getEnScreenAspectRatio());
        } else {
            clearEnScreenAspectRatio();
        }
    }
    return *this;
}

inline bool T_ScreenAttributes::operator == (const T_ScreenAttributes& rhs) const {
    return (((!hasU16ScreenHeight() && !rhs.hasU16ScreenHeight()) || getU16ScreenHeight() == rhs.getU16ScreenHeight()) &&
        ((!hasU16ScreenWidth() && !rhs.hasU16ScreenWidth()) || getU16ScreenWidth() == rhs.getU16ScreenWidth()) &&
        ((!hasEnScreenAspectRatio() && !rhs.hasEnScreenAspectRatio()) || getEnScreenAspectRatio() == rhs.getEnScreenAspectRatio()));
}

inline bool T_ScreenAttributes::operator != (const T_ScreenAttributes& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ScreenAttributes::operator < (const T_ScreenAttributes& rhs) const {
    if (hasU16ScreenHeight() || rhs.hasU16ScreenHeight()) {
        if (getU16ScreenHeight() < rhs.getU16ScreenHeight()) return true;
        if (getU16ScreenHeight() > rhs.getU16ScreenHeight()) return false;
    }
    if (hasU16ScreenWidth() || rhs.hasU16ScreenWidth()) {
        if (getU16ScreenWidth() < rhs.getU16ScreenWidth()) return true;
        if (getU16ScreenWidth() > rhs.getU16ScreenWidth()) return false;
    }
    if (hasEnScreenAspectRatio() || rhs.hasEnScreenAspectRatio()) {
        if ((uint32)getEnScreenAspectRatio() < (uint32)rhs.getEnScreenAspectRatio()) return true;
        if ((uint32)getEnScreenAspectRatio() > (uint32)rhs.getEnScreenAspectRatio()) return false;
    }
    return false;
}

inline bool T_ScreenAttributes::operator > (const T_ScreenAttributes& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ScreenAttributes::clear() {
    clearU16ScreenHeight();
    clearU16ScreenWidth();
    clearEnScreenAspectRatio();
}

inline void T_ScreenAttributes::clearU16ScreenHeight() {
    if (hasU16ScreenHeight()) {
         clear_has_u16ScreenHeight();
        _u16ScreenHeight = 0u;
     }
}

inline bool T_ScreenAttributes::hasU16ScreenHeight () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_ScreenAttributes::getU16ScreenHeight () const {
    return _u16ScreenHeight;
}

inline void T_ScreenAttributes::setU16ScreenHeight (uint16 u16ScreenHeight_) {
    set_has_u16ScreenHeight();
    this->_u16ScreenHeight = u16ScreenHeight_;
}

inline void T_ScreenAttributes::clearU16ScreenWidth() {
    if (hasU16ScreenWidth()) {
         clear_has_u16ScreenWidth();
        _u16ScreenWidth = 0u;
     }
}

inline bool T_ScreenAttributes::hasU16ScreenWidth () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_ScreenAttributes::getU16ScreenWidth () const {
    return _u16ScreenWidth;
}

inline void T_ScreenAttributes::setU16ScreenWidth (uint16 u16ScreenWidth_) {
    set_has_u16ScreenWidth();
    this->_u16ScreenWidth = u16ScreenWidth_;
}

inline void T_ScreenAttributes::clearEnScreenAspectRatio() {
    if (hasEnScreenAspectRatio()) {
         clear_has_enScreenAspectRatio();
        _enScreenAspectRatio = ::midw_smartphoneint_fi_types::T_e8_ScreenAspectRatio__ASPECT_UNKNOWN;
     }
}

inline bool T_ScreenAttributes::hasEnScreenAspectRatio () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_ScreenAspectRatio T_ScreenAttributes::getEnScreenAspectRatio () const {
    return _enScreenAspectRatio;
}

inline void T_ScreenAttributes::setEnScreenAspectRatio (T_e8_ScreenAspectRatio enScreenAspectRatio_) {
    #ifndef NDEBUG
    if (!(T_e8_ScreenAspectRatio_IsValid(enScreenAspectRatio_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enScreenAspectRatio_, "T_e8_ScreenAspectRatio", "enScreenAspectRatio", "T_ScreenAttributes");
    }
    #endif
    set_has_enScreenAspectRatio();
    this->_enScreenAspectRatio = enScreenAspectRatio_;
}

inline void T_ScreenAttributes::set_has_u16ScreenHeight () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ScreenAttributes::clear_has_u16ScreenHeight () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ScreenAttributes::set_has_u16ScreenWidth () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ScreenAttributes::clear_has_u16ScreenWidth () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ScreenAttributes::set_has_enScreenAspectRatio () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ScreenAttributes::clear_has_enScreenAspectRatio () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_VideoAttributes::T_VideoAttributes ()  :
    _enOrientationMode (::midw_smartphoneint_fi_types::T_e8_OrientationMode__INVALID_MODE),
    _rScreenAttributes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_VideoAttributes::T_VideoAttributes (const T_VideoAttributes &rhs)  :
    _enOrientationMode (::midw_smartphoneint_fi_types::T_e8_OrientationMode__INVALID_MODE),
    _rScreenAttributes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_VideoAttributes::T_VideoAttributes (T_e8_OrientationMode enOrientationMode_, const T_ScreenAttributes& rScreenAttributes_)  :
    _enOrientationMode (enOrientationMode_),
    _rScreenAttributes (rScreenAttributes_)
{
    #ifndef NDEBUG
    if (!(T_e8_OrientationMode_IsValid(enOrientationMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enOrientationMode_, "T_e8_OrientationMode", "enOrientationMode", "T_VideoAttributes");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_VideoAttributes::~T_VideoAttributes() {
}

inline T_VideoAttributes& T_VideoAttributes::operator = (const T_VideoAttributes& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnOrientationMode()) {
            setEnOrientationMode(rhs.getEnOrientationMode());
        } else {
            clearEnOrientationMode();
        }
        if (rhs.hasRScreenAttributes()) {
            setRScreenAttributes(rhs.getRScreenAttributes());
        } else {
            clearRScreenAttributes();
        }
    }
    return *this;
}

inline bool T_VideoAttributes::operator == (const T_VideoAttributes& rhs) const {
    return (((!hasEnOrientationMode() && !rhs.hasEnOrientationMode()) || getEnOrientationMode() == rhs.getEnOrientationMode()) &&
        ((!hasRScreenAttributes() && !rhs.hasRScreenAttributes()) || getRScreenAttributes() == rhs.getRScreenAttributes()));
}

inline bool T_VideoAttributes::operator != (const T_VideoAttributes& rhs) const {
    return ! (*this == rhs);
}

inline bool T_VideoAttributes::operator < (const T_VideoAttributes& rhs) const {
    if (hasEnOrientationMode() || rhs.hasEnOrientationMode()) {
        if ((uint32)getEnOrientationMode() < (uint32)rhs.getEnOrientationMode()) return true;
        if ((uint32)getEnOrientationMode() > (uint32)rhs.getEnOrientationMode()) return false;
    }
    if (hasRScreenAttributes() || rhs.hasRScreenAttributes()) {
        if (getRScreenAttributes() < rhs.getRScreenAttributes()) return true;
        if (getRScreenAttributes() > rhs.getRScreenAttributes()) return false;
    }
    return false;
}

inline bool T_VideoAttributes::operator > (const T_VideoAttributes& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_VideoAttributes::clear() {
    clearEnOrientationMode();
    clearRScreenAttributes();
}

inline void T_VideoAttributes::clearEnOrientationMode() {
    if (hasEnOrientationMode()) {
         clear_has_enOrientationMode();
        _enOrientationMode = ::midw_smartphoneint_fi_types::T_e8_OrientationMode__INVALID_MODE;
     }
}

inline bool T_VideoAttributes::hasEnOrientationMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_OrientationMode T_VideoAttributes::getEnOrientationMode () const {
    return _enOrientationMode;
}

inline void T_VideoAttributes::setEnOrientationMode (T_e8_OrientationMode enOrientationMode_) {
    #ifndef NDEBUG
    if (!(T_e8_OrientationMode_IsValid(enOrientationMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enOrientationMode_, "T_e8_OrientationMode", "enOrientationMode", "T_VideoAttributes");
    }
    #endif
    set_has_enOrientationMode();
    this->_enOrientationMode = enOrientationMode_;
}

inline void T_VideoAttributes::clearRScreenAttributes() {
    if (hasRScreenAttributes()) {
         clear_has_rScreenAttributes();
        _rScreenAttributes.clear();
     }
}

inline bool T_VideoAttributes::hasRScreenAttributes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_ScreenAttributes& T_VideoAttributes::getRScreenAttributes () const {
    return _rScreenAttributes;
}

inline T_ScreenAttributes& T_VideoAttributes::getRScreenAttributesMutable () {
    set_has_rScreenAttributes();
    return _rScreenAttributes;
}

inline void T_VideoAttributes::setRScreenAttributes (const T_ScreenAttributes& rScreenAttributes_) {
    set_has_rScreenAttributes();
    this->_rScreenAttributes = rScreenAttributes_;
}

inline void T_VideoAttributes::set_has_enOrientationMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_VideoAttributes::clear_has_enOrientationMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_VideoAttributes::set_has_rScreenAttributes () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_VideoAttributes::clear_has_rScreenAttributes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_NotificationEnable::T_NotificationEnable ()  :
    _u32AppHandle (0u),
    _enEnabledInfo (::midw_smartphoneint_fi_types::T_e8_EnabledInfo__USAGE_DISABLED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_NotificationEnable::T_NotificationEnable (const T_NotificationEnable &rhs)  :
    _u32AppHandle (0u),
    _enEnabledInfo (::midw_smartphoneint_fi_types::T_e8_EnabledInfo__USAGE_DISABLED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_NotificationEnable::T_NotificationEnable (uint32 u32AppHandle_, T_e8_EnabledInfo enEnabledInfo_)  :
    _u32AppHandle (u32AppHandle_),
    _enEnabledInfo (enEnabledInfo_)
{
    #ifndef NDEBUG
    if (!(T_e8_EnabledInfo_IsValid(enEnabledInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enEnabledInfo_, "T_e8_EnabledInfo", "enEnabledInfo", "T_NotificationEnable");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_NotificationEnable::~T_NotificationEnable() {
}

inline T_NotificationEnable& T_NotificationEnable::operator = (const T_NotificationEnable& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32AppHandle()) {
            setU32AppHandle(rhs.getU32AppHandle());
        } else {
            clearU32AppHandle();
        }
        if (rhs.hasEnEnabledInfo()) {
            setEnEnabledInfo(rhs.getEnEnabledInfo());
        } else {
            clearEnEnabledInfo();
        }
    }
    return *this;
}

inline bool T_NotificationEnable::operator == (const T_NotificationEnable& rhs) const {
    return (((!hasU32AppHandle() && !rhs.hasU32AppHandle()) || getU32AppHandle() == rhs.getU32AppHandle()) &&
        ((!hasEnEnabledInfo() && !rhs.hasEnEnabledInfo()) || getEnEnabledInfo() == rhs.getEnEnabledInfo()));
}

inline bool T_NotificationEnable::operator != (const T_NotificationEnable& rhs) const {
    return ! (*this == rhs);
}

inline bool T_NotificationEnable::operator < (const T_NotificationEnable& rhs) const {
    if (hasU32AppHandle() || rhs.hasU32AppHandle()) {
        if (getU32AppHandle() < rhs.getU32AppHandle()) return true;
        if (getU32AppHandle() > rhs.getU32AppHandle()) return false;
    }
    if (hasEnEnabledInfo() || rhs.hasEnEnabledInfo()) {
        if ((uint32)getEnEnabledInfo() < (uint32)rhs.getEnEnabledInfo()) return true;
        if ((uint32)getEnEnabledInfo() > (uint32)rhs.getEnEnabledInfo()) return false;
    }
    return false;
}

inline bool T_NotificationEnable::operator > (const T_NotificationEnable& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_NotificationEnable::clear() {
    clearU32AppHandle();
    clearEnEnabledInfo();
}

inline void T_NotificationEnable::clearU32AppHandle() {
    if (hasU32AppHandle()) {
         clear_has_u32AppHandle();
        _u32AppHandle = 0u;
     }
}

inline bool T_NotificationEnable::hasU32AppHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_NotificationEnable::getU32AppHandle () const {
    return _u32AppHandle;
}

inline void T_NotificationEnable::setU32AppHandle (uint32 u32AppHandle_) {
    set_has_u32AppHandle();
    this->_u32AppHandle = u32AppHandle_;
}

inline void T_NotificationEnable::clearEnEnabledInfo() {
    if (hasEnEnabledInfo()) {
         clear_has_enEnabledInfo();
        _enEnabledInfo = ::midw_smartphoneint_fi_types::T_e8_EnabledInfo__USAGE_DISABLED;
     }
}

inline bool T_NotificationEnable::hasEnEnabledInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_EnabledInfo T_NotificationEnable::getEnEnabledInfo () const {
    return _enEnabledInfo;
}

inline void T_NotificationEnable::setEnEnabledInfo (T_e8_EnabledInfo enEnabledInfo_) {
    #ifndef NDEBUG
    if (!(T_e8_EnabledInfo_IsValid(enEnabledInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enEnabledInfo_, "T_e8_EnabledInfo", "enEnabledInfo", "T_NotificationEnable");
    }
    #endif
    set_has_enEnabledInfo();
    this->_enEnabledInfo = enEnabledInfo_;
}

inline void T_NotificationEnable::set_has_u32AppHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_NotificationEnable::clear_has_u32AppHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_NotificationEnable::set_has_enEnabledInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_NotificationEnable::clear_has_enEnabledInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_NotificationAction::T_NotificationAction ()  :
    _u16NotificationActionID (0u),
    _szNotificationActionName (),
    _u16NotificationActionIconCount (0u),
    _NotificationActionIconList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_NotificationAction::T_NotificationAction (const T_NotificationAction &rhs)  :
    _u16NotificationActionID (0u),
    _szNotificationActionName (),
    _u16NotificationActionIconCount (0u),
    _NotificationActionIconList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_NotificationAction::T_NotificationAction (uint16 u16NotificationActionID_, const ::std::string& szNotificationActionName_, uint16 u16NotificationActionIconCount_, const ::std::vector< T_IconAttributes >& NotificationActionIconList_)  :
    _u16NotificationActionID (u16NotificationActionID_),
    _szNotificationActionName (szNotificationActionName_),
    _u16NotificationActionIconCount (u16NotificationActionIconCount_),
    _NotificationActionIconList (NotificationActionIconList_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szNotificationActionName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_NotificationAction::~T_NotificationAction() {
}

inline T_NotificationAction& T_NotificationAction::operator = (const T_NotificationAction& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16NotificationActionID()) {
            setU16NotificationActionID(rhs.getU16NotificationActionID());
        } else {
            clearU16NotificationActionID();
        }
        if (rhs.hasSzNotificationActionName()) {
            setSzNotificationActionName(rhs.getSzNotificationActionName());
        } else {
            clearSzNotificationActionName();
        }
        if (rhs.hasU16NotificationActionIconCount()) {
            setU16NotificationActionIconCount(rhs.getU16NotificationActionIconCount());
        } else {
            clearU16NotificationActionIconCount();
        }
        if (rhs.hasNotificationActionIconList()) {
            setNotificationActionIconList(rhs.getNotificationActionIconList());
        } else {
            clearNotificationActionIconList();
        }
    }
    return *this;
}

inline bool T_NotificationAction::operator == (const T_NotificationAction& rhs) const {
    return (((!hasU16NotificationActionID() && !rhs.hasU16NotificationActionID()) || getU16NotificationActionID() == rhs.getU16NotificationActionID()) &&
        ((!hasSzNotificationActionName() && !rhs.hasSzNotificationActionName()) || getSzNotificationActionName() == rhs.getSzNotificationActionName()) &&
        ((!hasU16NotificationActionIconCount() && !rhs.hasU16NotificationActionIconCount()) || getU16NotificationActionIconCount() == rhs.getU16NotificationActionIconCount()) &&
        ((!hasNotificationActionIconList() && !rhs.hasNotificationActionIconList()) || getNotificationActionIconList() == rhs.getNotificationActionIconList()));
}

inline bool T_NotificationAction::operator != (const T_NotificationAction& rhs) const {
    return ! (*this == rhs);
}

inline bool T_NotificationAction::operator < (const T_NotificationAction& rhs) const {
    if (hasU16NotificationActionID() || rhs.hasU16NotificationActionID()) {
        if (getU16NotificationActionID() < rhs.getU16NotificationActionID()) return true;
        if (getU16NotificationActionID() > rhs.getU16NotificationActionID()) return false;
    }
    if (hasSzNotificationActionName() || rhs.hasSzNotificationActionName()) {
        if (getSzNotificationActionName() < rhs.getSzNotificationActionName()) return true;
        if (getSzNotificationActionName() > rhs.getSzNotificationActionName()) return false;
    }
    if (hasU16NotificationActionIconCount() || rhs.hasU16NotificationActionIconCount()) {
        if (getU16NotificationActionIconCount() < rhs.getU16NotificationActionIconCount()) return true;
        if (getU16NotificationActionIconCount() > rhs.getU16NotificationActionIconCount()) return false;
    }
    if (hasNotificationActionIconList() || rhs.hasNotificationActionIconList()) {
        if (getNotificationActionIconList() < rhs.getNotificationActionIconList()) return true;
        if (getNotificationActionIconList() > rhs.getNotificationActionIconList()) return false;
    }
    return false;
}

inline bool T_NotificationAction::operator > (const T_NotificationAction& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_NotificationAction::clear() {
    clearU16NotificationActionID();
    clearSzNotificationActionName();
    clearU16NotificationActionIconCount();
    clearNotificationActionIconList();
}

inline void T_NotificationAction::clearU16NotificationActionID() {
    if (hasU16NotificationActionID()) {
         clear_has_u16NotificationActionID();
        _u16NotificationActionID = 0u;
     }
}

inline bool T_NotificationAction::hasU16NotificationActionID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_NotificationAction::getU16NotificationActionID () const {
    return _u16NotificationActionID;
}

inline void T_NotificationAction::setU16NotificationActionID (uint16 u16NotificationActionID_) {
    set_has_u16NotificationActionID();
    this->_u16NotificationActionID = u16NotificationActionID_;
}

inline void T_NotificationAction::clearSzNotificationActionName() {
    if (hasSzNotificationActionName()) {
         clear_has_szNotificationActionName();
        _szNotificationActionName.clear();
     }
}

inline bool T_NotificationAction::hasSzNotificationActionName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_NotificationAction::getSzNotificationActionName () const {
    return _szNotificationActionName;
}

inline ::std::string& T_NotificationAction::getSzNotificationActionNameMutable () {
    set_has_szNotificationActionName();
    return _szNotificationActionName;
}

inline void T_NotificationAction::setSzNotificationActionName (const ::std::string& szNotificationActionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szNotificationActionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szNotificationActionName();
    this->_szNotificationActionName = szNotificationActionName_;
}

inline void T_NotificationAction::setSzNotificationActionName (const char* szNotificationActionName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szNotificationActionName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szNotificationActionName();
    this->_szNotificationActionName.assign(szNotificationActionName_);
}

inline void T_NotificationAction::setSzNotificationActionName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szNotificationActionName();
    this->_szNotificationActionName.assign(value, size);
}

inline void T_NotificationAction::clearU16NotificationActionIconCount() {
    if (hasU16NotificationActionIconCount()) {
         clear_has_u16NotificationActionIconCount();
        _u16NotificationActionIconCount = 0u;
     }
}

inline bool T_NotificationAction::hasU16NotificationActionIconCount () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_NotificationAction::getU16NotificationActionIconCount () const {
    return _u16NotificationActionIconCount;
}

inline void T_NotificationAction::setU16NotificationActionIconCount (uint16 u16NotificationActionIconCount_) {
    set_has_u16NotificationActionIconCount();
    this->_u16NotificationActionIconCount = u16NotificationActionIconCount_;
}

inline void T_NotificationAction::clearNotificationActionIconList() {
    if (hasNotificationActionIconList()) {
         clear_has_NotificationActionIconList();
        _NotificationActionIconList.clear();
     }
}

inline bool T_NotificationAction::hasNotificationActionIconList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< T_IconAttributes >& T_NotificationAction::getNotificationActionIconList () const {
    return _NotificationActionIconList;
}

inline ::std::vector< T_IconAttributes >& T_NotificationAction::getNotificationActionIconListMutable () {
    set_has_NotificationActionIconList();
    return _NotificationActionIconList;
}

inline void T_NotificationAction::setNotificationActionIconList (const ::std::vector< T_IconAttributes >& NotificationActionIconList_) {
    set_has_NotificationActionIconList();
    this->_NotificationActionIconList = NotificationActionIconList_;
}

inline void T_NotificationAction::set_has_u16NotificationActionID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_NotificationAction::clear_has_u16NotificationActionID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_NotificationAction::set_has_szNotificationActionName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_NotificationAction::clear_has_szNotificationActionName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_NotificationAction::set_has_u16NotificationActionIconCount () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_NotificationAction::clear_has_u16NotificationActionIconCount () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_NotificationAction::set_has_NotificationActionIconList () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_NotificationAction::clear_has_NotificationActionIconList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_NotificationData::T_NotificationData ()  :
    _u16NotificationID (0u),
    _szNotificationTitle (),
    _szNotificationBody (),
    _u16NotificationIconCount (0u),
    _NotificationIconList (),
    _u16NotificationAppID (0u),
    _NotificationActionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_NotificationData::T_NotificationData (const T_NotificationData &rhs)  :
    _u16NotificationID (0u),
    _szNotificationTitle (),
    _szNotificationBody (),
    _u16NotificationIconCount (0u),
    _NotificationIconList (),
    _u16NotificationAppID (0u),
    _NotificationActionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_NotificationData::T_NotificationData (uint16 u16NotificationID_, const ::std::string& szNotificationTitle_, const ::std::string& szNotificationBody_, uint16 u16NotificationIconCount_, const ::std::vector< T_IconAttributes >& NotificationIconList_, uint16 u16NotificationAppID_, const ::std::vector< T_NotificationAction >& NotificationActionList_)  :
    _u16NotificationID (u16NotificationID_),
    _szNotificationTitle (szNotificationTitle_),
    _szNotificationBody (szNotificationBody_),
    _u16NotificationIconCount (u16NotificationIconCount_),
    _NotificationIconList (NotificationIconList_),
    _u16NotificationAppID (u16NotificationAppID_),
    _NotificationActionList (NotificationActionList_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szNotificationTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szNotificationBody_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_NotificationData::~T_NotificationData() {
}

inline T_NotificationData& T_NotificationData::operator = (const T_NotificationData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16NotificationID()) {
            setU16NotificationID(rhs.getU16NotificationID());
        } else {
            clearU16NotificationID();
        }
        if (rhs.hasSzNotificationTitle()) {
            setSzNotificationTitle(rhs.getSzNotificationTitle());
        } else {
            clearSzNotificationTitle();
        }
        if (rhs.hasSzNotificationBody()) {
            setSzNotificationBody(rhs.getSzNotificationBody());
        } else {
            clearSzNotificationBody();
        }
        if (rhs.hasU16NotificationIconCount()) {
            setU16NotificationIconCount(rhs.getU16NotificationIconCount());
        } else {
            clearU16NotificationIconCount();
        }
        if (rhs.hasNotificationIconList()) {
            setNotificationIconList(rhs.getNotificationIconList());
        } else {
            clearNotificationIconList();
        }
        if (rhs.hasU16NotificationAppID()) {
            setU16NotificationAppID(rhs.getU16NotificationAppID());
        } else {
            clearU16NotificationAppID();
        }
        if (rhs.hasNotificationActionList()) {
            setNotificationActionList(rhs.getNotificationActionList());
        } else {
            clearNotificationActionList();
        }
    }
    return *this;
}

inline bool T_NotificationData::operator == (const T_NotificationData& rhs) const {
    return (((!hasU16NotificationID() && !rhs.hasU16NotificationID()) || getU16NotificationID() == rhs.getU16NotificationID()) &&
        ((!hasSzNotificationTitle() && !rhs.hasSzNotificationTitle()) || getSzNotificationTitle() == rhs.getSzNotificationTitle()) &&
        ((!hasSzNotificationBody() && !rhs.hasSzNotificationBody()) || getSzNotificationBody() == rhs.getSzNotificationBody()) &&
        ((!hasU16NotificationIconCount() && !rhs.hasU16NotificationIconCount()) || getU16NotificationIconCount() == rhs.getU16NotificationIconCount()) &&
        ((!hasNotificationIconList() && !rhs.hasNotificationIconList()) || getNotificationIconList() == rhs.getNotificationIconList()) &&
        ((!hasU16NotificationAppID() && !rhs.hasU16NotificationAppID()) || getU16NotificationAppID() == rhs.getU16NotificationAppID()) &&
        ((!hasNotificationActionList() && !rhs.hasNotificationActionList()) || getNotificationActionList() == rhs.getNotificationActionList()));
}

inline bool T_NotificationData::operator != (const T_NotificationData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_NotificationData::operator < (const T_NotificationData& rhs) const {
    if (hasU16NotificationID() || rhs.hasU16NotificationID()) {
        if (getU16NotificationID() < rhs.getU16NotificationID()) return true;
        if (getU16NotificationID() > rhs.getU16NotificationID()) return false;
    }
    if (hasSzNotificationTitle() || rhs.hasSzNotificationTitle()) {
        if (getSzNotificationTitle() < rhs.getSzNotificationTitle()) return true;
        if (getSzNotificationTitle() > rhs.getSzNotificationTitle()) return false;
    }
    if (hasSzNotificationBody() || rhs.hasSzNotificationBody()) {
        if (getSzNotificationBody() < rhs.getSzNotificationBody()) return true;
        if (getSzNotificationBody() > rhs.getSzNotificationBody()) return false;
    }
    if (hasU16NotificationIconCount() || rhs.hasU16NotificationIconCount()) {
        if (getU16NotificationIconCount() < rhs.getU16NotificationIconCount()) return true;
        if (getU16NotificationIconCount() > rhs.getU16NotificationIconCount()) return false;
    }
    if (hasNotificationIconList() || rhs.hasNotificationIconList()) {
        if (getNotificationIconList() < rhs.getNotificationIconList()) return true;
        if (getNotificationIconList() > rhs.getNotificationIconList()) return false;
    }
    if (hasU16NotificationAppID() || rhs.hasU16NotificationAppID()) {
        if (getU16NotificationAppID() < rhs.getU16NotificationAppID()) return true;
        if (getU16NotificationAppID() > rhs.getU16NotificationAppID()) return false;
    }
    if (hasNotificationActionList() || rhs.hasNotificationActionList()) {
        if (getNotificationActionList() < rhs.getNotificationActionList()) return true;
        if (getNotificationActionList() > rhs.getNotificationActionList()) return false;
    }
    return false;
}

inline bool T_NotificationData::operator > (const T_NotificationData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_NotificationData::clear() {
    clearU16NotificationID();
    clearSzNotificationTitle();
    clearSzNotificationBody();
    clearU16NotificationIconCount();
    clearNotificationIconList();
    clearU16NotificationAppID();
    clearNotificationActionList();
}

inline void T_NotificationData::clearU16NotificationID() {
    if (hasU16NotificationID()) {
         clear_has_u16NotificationID();
        _u16NotificationID = 0u;
     }
}

inline bool T_NotificationData::hasU16NotificationID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_NotificationData::getU16NotificationID () const {
    return _u16NotificationID;
}

inline void T_NotificationData::setU16NotificationID (uint16 u16NotificationID_) {
    set_has_u16NotificationID();
    this->_u16NotificationID = u16NotificationID_;
}

inline void T_NotificationData::clearSzNotificationTitle() {
    if (hasSzNotificationTitle()) {
         clear_has_szNotificationTitle();
        _szNotificationTitle.clear();
     }
}

inline bool T_NotificationData::hasSzNotificationTitle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_NotificationData::getSzNotificationTitle () const {
    return _szNotificationTitle;
}

inline ::std::string& T_NotificationData::getSzNotificationTitleMutable () {
    set_has_szNotificationTitle();
    return _szNotificationTitle;
}

inline void T_NotificationData::setSzNotificationTitle (const ::std::string& szNotificationTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szNotificationTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szNotificationTitle();
    this->_szNotificationTitle = szNotificationTitle_;
}

inline void T_NotificationData::setSzNotificationTitle (const char* szNotificationTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szNotificationTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szNotificationTitle();
    this->_szNotificationTitle.assign(szNotificationTitle_);
}

inline void T_NotificationData::setSzNotificationTitle (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szNotificationTitle();
    this->_szNotificationTitle.assign(value, size);
}

inline void T_NotificationData::clearSzNotificationBody() {
    if (hasSzNotificationBody()) {
         clear_has_szNotificationBody();
        _szNotificationBody.clear();
     }
}

inline bool T_NotificationData::hasSzNotificationBody () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_NotificationData::getSzNotificationBody () const {
    return _szNotificationBody;
}

inline ::std::string& T_NotificationData::getSzNotificationBodyMutable () {
    set_has_szNotificationBody();
    return _szNotificationBody;
}

inline void T_NotificationData::setSzNotificationBody (const ::std::string& szNotificationBody_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szNotificationBody_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szNotificationBody();
    this->_szNotificationBody = szNotificationBody_;
}

inline void T_NotificationData::setSzNotificationBody (const char* szNotificationBody_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szNotificationBody_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szNotificationBody();
    this->_szNotificationBody.assign(szNotificationBody_);
}

inline void T_NotificationData::setSzNotificationBody (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szNotificationBody();
    this->_szNotificationBody.assign(value, size);
}

inline void T_NotificationData::clearU16NotificationIconCount() {
    if (hasU16NotificationIconCount()) {
         clear_has_u16NotificationIconCount();
        _u16NotificationIconCount = 0u;
     }
}

inline bool T_NotificationData::hasU16NotificationIconCount () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_NotificationData::getU16NotificationIconCount () const {
    return _u16NotificationIconCount;
}

inline void T_NotificationData::setU16NotificationIconCount (uint16 u16NotificationIconCount_) {
    set_has_u16NotificationIconCount();
    this->_u16NotificationIconCount = u16NotificationIconCount_;
}

inline void T_NotificationData::clearNotificationIconList() {
    if (hasNotificationIconList()) {
         clear_has_NotificationIconList();
        _NotificationIconList.clear();
     }
}

inline bool T_NotificationData::hasNotificationIconList () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::vector< T_IconAttributes >& T_NotificationData::getNotificationIconList () const {
    return _NotificationIconList;
}

inline ::std::vector< T_IconAttributes >& T_NotificationData::getNotificationIconListMutable () {
    set_has_NotificationIconList();
    return _NotificationIconList;
}

inline void T_NotificationData::setNotificationIconList (const ::std::vector< T_IconAttributes >& NotificationIconList_) {
    set_has_NotificationIconList();
    this->_NotificationIconList = NotificationIconList_;
}

inline void T_NotificationData::clearU16NotificationAppID() {
    if (hasU16NotificationAppID()) {
         clear_has_u16NotificationAppID();
        _u16NotificationAppID = 0u;
     }
}

inline bool T_NotificationData::hasU16NotificationAppID () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 T_NotificationData::getU16NotificationAppID () const {
    return _u16NotificationAppID;
}

inline void T_NotificationData::setU16NotificationAppID (uint16 u16NotificationAppID_) {
    set_has_u16NotificationAppID();
    this->_u16NotificationAppID = u16NotificationAppID_;
}

inline void T_NotificationData::clearNotificationActionList() {
    if (hasNotificationActionList()) {
         clear_has_NotificationActionList();
        _NotificationActionList.clear();
     }
}

inline bool T_NotificationData::hasNotificationActionList () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::vector< T_NotificationAction >& T_NotificationData::getNotificationActionList () const {
    return _NotificationActionList;
}

inline ::std::vector< T_NotificationAction >& T_NotificationData::getNotificationActionListMutable () {
    set_has_NotificationActionList();
    return _NotificationActionList;
}

inline void T_NotificationData::setNotificationActionList (const ::std::vector< T_NotificationAction >& NotificationActionList_) {
    set_has_NotificationActionList();
    this->_NotificationActionList = NotificationActionList_;
}

inline void T_NotificationData::set_has_u16NotificationID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_NotificationData::clear_has_u16NotificationID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_NotificationData::set_has_szNotificationTitle () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_NotificationData::clear_has_szNotificationTitle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_NotificationData::set_has_szNotificationBody () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_NotificationData::clear_has_szNotificationBody () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_NotificationData::set_has_u16NotificationIconCount () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_NotificationData::clear_has_u16NotificationIconCount () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_NotificationData::set_has_NotificationIconList () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_NotificationData::clear_has_NotificationIconList () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_NotificationData::set_has_u16NotificationAppID () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_NotificationData::clear_has_u16NotificationAppID () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_NotificationData::set_has_NotificationActionList () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_NotificationData::clear_has_NotificationActionList () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_KeyCapabilities::T_KeyCapabilities ()  :
    _u32KnobKeySupport (0u),
    _u32DeviceKeySupport (0u),
    _u32MultimediaKeySupport (0u),
    _u32MiscKeySupport (0u),
    _u32PointerTouchSupport (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_KeyCapabilities::T_KeyCapabilities (const T_KeyCapabilities &rhs)  :
    _u32KnobKeySupport (0u),
    _u32DeviceKeySupport (0u),
    _u32MultimediaKeySupport (0u),
    _u32MiscKeySupport (0u),
    _u32PointerTouchSupport (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_KeyCapabilities::T_KeyCapabilities (uint32 u32KnobKeySupport_, uint32 u32DeviceKeySupport_, uint32 u32MultimediaKeySupport_, uint32 u32MiscKeySupport_, uint32 u32PointerTouchSupport_)  :
    _u32KnobKeySupport (u32KnobKeySupport_),
    _u32DeviceKeySupport (u32DeviceKeySupport_),
    _u32MultimediaKeySupport (u32MultimediaKeySupport_),
    _u32MiscKeySupport (u32MiscKeySupport_),
    _u32PointerTouchSupport (u32PointerTouchSupport_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_KeyCapabilities::~T_KeyCapabilities() {
}

inline T_KeyCapabilities& T_KeyCapabilities::operator = (const T_KeyCapabilities& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32KnobKeySupport()) {
            setU32KnobKeySupport(rhs.getU32KnobKeySupport());
        } else {
            clearU32KnobKeySupport();
        }
        if (rhs.hasU32DeviceKeySupport()) {
            setU32DeviceKeySupport(rhs.getU32DeviceKeySupport());
        } else {
            clearU32DeviceKeySupport();
        }
        if (rhs.hasU32MultimediaKeySupport()) {
            setU32MultimediaKeySupport(rhs.getU32MultimediaKeySupport());
        } else {
            clearU32MultimediaKeySupport();
        }
        if (rhs.hasU32MiscKeySupport()) {
            setU32MiscKeySupport(rhs.getU32MiscKeySupport());
        } else {
            clearU32MiscKeySupport();
        }
        if (rhs.hasU32PointerTouchSupport()) {
            setU32PointerTouchSupport(rhs.getU32PointerTouchSupport());
        } else {
            clearU32PointerTouchSupport();
        }
    }
    return *this;
}

inline bool T_KeyCapabilities::operator == (const T_KeyCapabilities& rhs) const {
    return (((!hasU32KnobKeySupport() && !rhs.hasU32KnobKeySupport()) || getU32KnobKeySupport() == rhs.getU32KnobKeySupport()) &&
        ((!hasU32DeviceKeySupport() && !rhs.hasU32DeviceKeySupport()) || getU32DeviceKeySupport() == rhs.getU32DeviceKeySupport()) &&
        ((!hasU32MultimediaKeySupport() && !rhs.hasU32MultimediaKeySupport()) || getU32MultimediaKeySupport() == rhs.getU32MultimediaKeySupport()) &&
        ((!hasU32MiscKeySupport() && !rhs.hasU32MiscKeySupport()) || getU32MiscKeySupport() == rhs.getU32MiscKeySupport()) &&
        ((!hasU32PointerTouchSupport() && !rhs.hasU32PointerTouchSupport()) || getU32PointerTouchSupport() == rhs.getU32PointerTouchSupport()));
}

inline bool T_KeyCapabilities::operator != (const T_KeyCapabilities& rhs) const {
    return ! (*this == rhs);
}

inline bool T_KeyCapabilities::operator < (const T_KeyCapabilities& rhs) const {
    if (hasU32KnobKeySupport() || rhs.hasU32KnobKeySupport()) {
        if (getU32KnobKeySupport() < rhs.getU32KnobKeySupport()) return true;
        if (getU32KnobKeySupport() > rhs.getU32KnobKeySupport()) return false;
    }
    if (hasU32DeviceKeySupport() || rhs.hasU32DeviceKeySupport()) {
        if (getU32DeviceKeySupport() < rhs.getU32DeviceKeySupport()) return true;
        if (getU32DeviceKeySupport() > rhs.getU32DeviceKeySupport()) return false;
    }
    if (hasU32MultimediaKeySupport() || rhs.hasU32MultimediaKeySupport()) {
        if (getU32MultimediaKeySupport() < rhs.getU32MultimediaKeySupport()) return true;
        if (getU32MultimediaKeySupport() > rhs.getU32MultimediaKeySupport()) return false;
    }
    if (hasU32MiscKeySupport() || rhs.hasU32MiscKeySupport()) {
        if (getU32MiscKeySupport() < rhs.getU32MiscKeySupport()) return true;
        if (getU32MiscKeySupport() > rhs.getU32MiscKeySupport()) return false;
    }
    if (hasU32PointerTouchSupport() || rhs.hasU32PointerTouchSupport()) {
        if (getU32PointerTouchSupport() < rhs.getU32PointerTouchSupport()) return true;
        if (getU32PointerTouchSupport() > rhs.getU32PointerTouchSupport()) return false;
    }
    return false;
}

inline bool T_KeyCapabilities::operator > (const T_KeyCapabilities& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_KeyCapabilities::clear() {
    clearU32KnobKeySupport();
    clearU32DeviceKeySupport();
    clearU32MultimediaKeySupport();
    clearU32MiscKeySupport();
    clearU32PointerTouchSupport();
}

inline void T_KeyCapabilities::clearU32KnobKeySupport() {
    if (hasU32KnobKeySupport()) {
         clear_has_u32KnobKeySupport();
        _u32KnobKeySupport = 0u;
     }
}

inline bool T_KeyCapabilities::hasU32KnobKeySupport () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_KeyCapabilities::getU32KnobKeySupport () const {
    return _u32KnobKeySupport;
}

inline void T_KeyCapabilities::setU32KnobKeySupport (uint32 u32KnobKeySupport_) {
    set_has_u32KnobKeySupport();
    this->_u32KnobKeySupport = u32KnobKeySupport_;
}

inline void T_KeyCapabilities::clearU32DeviceKeySupport() {
    if (hasU32DeviceKeySupport()) {
         clear_has_u32DeviceKeySupport();
        _u32DeviceKeySupport = 0u;
     }
}

inline bool T_KeyCapabilities::hasU32DeviceKeySupport () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_KeyCapabilities::getU32DeviceKeySupport () const {
    return _u32DeviceKeySupport;
}

inline void T_KeyCapabilities::setU32DeviceKeySupport (uint32 u32DeviceKeySupport_) {
    set_has_u32DeviceKeySupport();
    this->_u32DeviceKeySupport = u32DeviceKeySupport_;
}

inline void T_KeyCapabilities::clearU32MultimediaKeySupport() {
    if (hasU32MultimediaKeySupport()) {
         clear_has_u32MultimediaKeySupport();
        _u32MultimediaKeySupport = 0u;
     }
}

inline bool T_KeyCapabilities::hasU32MultimediaKeySupport () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_KeyCapabilities::getU32MultimediaKeySupport () const {
    return _u32MultimediaKeySupport;
}

inline void T_KeyCapabilities::setU32MultimediaKeySupport (uint32 u32MultimediaKeySupport_) {
    set_has_u32MultimediaKeySupport();
    this->_u32MultimediaKeySupport = u32MultimediaKeySupport_;
}

inline void T_KeyCapabilities::clearU32MiscKeySupport() {
    if (hasU32MiscKeySupport()) {
         clear_has_u32MiscKeySupport();
        _u32MiscKeySupport = 0u;
     }
}

inline bool T_KeyCapabilities::hasU32MiscKeySupport () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_KeyCapabilities::getU32MiscKeySupport () const {
    return _u32MiscKeySupport;
}

inline void T_KeyCapabilities::setU32MiscKeySupport (uint32 u32MiscKeySupport_) {
    set_has_u32MiscKeySupport();
    this->_u32MiscKeySupport = u32MiscKeySupport_;
}

inline void T_KeyCapabilities::clearU32PointerTouchSupport() {
    if (hasU32PointerTouchSupport()) {
         clear_has_u32PointerTouchSupport();
        _u32PointerTouchSupport = 0u;
     }
}

inline bool T_KeyCapabilities::hasU32PointerTouchSupport () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_KeyCapabilities::getU32PointerTouchSupport () const {
    return _u32PointerTouchSupport;
}

inline void T_KeyCapabilities::setU32PointerTouchSupport (uint32 u32PointerTouchSupport_) {
    set_has_u32PointerTouchSupport();
    this->_u32PointerTouchSupport = u32PointerTouchSupport_;
}

inline void T_KeyCapabilities::set_has_u32KnobKeySupport () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_KeyCapabilities::clear_has_u32KnobKeySupport () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_KeyCapabilities::set_has_u32DeviceKeySupport () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_KeyCapabilities::clear_has_u32DeviceKeySupport () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_KeyCapabilities::set_has_u32MultimediaKeySupport () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_KeyCapabilities::clear_has_u32MultimediaKeySupport () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_KeyCapabilities::set_has_u32MiscKeySupport () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_KeyCapabilities::clear_has_u32MiscKeySupport () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_KeyCapabilities::set_has_u32PointerTouchSupport () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_KeyCapabilities::clear_has_u32PointerTouchSupport () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_ClientCapabilities::T_ClientCapabilities ()  :
    _rKeyCapabilities ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ClientCapabilities::T_ClientCapabilities (const T_ClientCapabilities &rhs)  :
    _rKeyCapabilities ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ClientCapabilities::T_ClientCapabilities (const T_KeyCapabilities& rKeyCapabilities_)  :
    _rKeyCapabilities (rKeyCapabilities_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ClientCapabilities::~T_ClientCapabilities() {
}

inline T_ClientCapabilities& T_ClientCapabilities::operator = (const T_ClientCapabilities& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRKeyCapabilities()) {
            setRKeyCapabilities(rhs.getRKeyCapabilities());
        } else {
            clearRKeyCapabilities();
        }
    }
    return *this;
}

inline bool T_ClientCapabilities::operator == (const T_ClientCapabilities& rhs) const {
    return (((!hasRKeyCapabilities() && !rhs.hasRKeyCapabilities()) || getRKeyCapabilities() == rhs.getRKeyCapabilities()));
}

inline bool T_ClientCapabilities::operator != (const T_ClientCapabilities& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ClientCapabilities::operator < (const T_ClientCapabilities& rhs) const {
    if (hasRKeyCapabilities() || rhs.hasRKeyCapabilities()) {
        if (getRKeyCapabilities() < rhs.getRKeyCapabilities()) return true;
        if (getRKeyCapabilities() > rhs.getRKeyCapabilities()) return false;
    }
    return false;
}

inline bool T_ClientCapabilities::operator > (const T_ClientCapabilities& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ClientCapabilities::clear() {
    clearRKeyCapabilities();
}

inline void T_ClientCapabilities::clearRKeyCapabilities() {
    if (hasRKeyCapabilities()) {
         clear_has_rKeyCapabilities();
        _rKeyCapabilities.clear();
     }
}

inline bool T_ClientCapabilities::hasRKeyCapabilities () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_KeyCapabilities& T_ClientCapabilities::getRKeyCapabilities () const {
    return _rKeyCapabilities;
}

inline T_KeyCapabilities& T_ClientCapabilities::getRKeyCapabilitiesMutable () {
    set_has_rKeyCapabilities();
    return _rKeyCapabilities;
}

inline void T_ClientCapabilities::setRKeyCapabilities (const T_KeyCapabilities& rKeyCapabilities_) {
    set_has_rKeyCapabilities();
    this->_rKeyCapabilities = rKeyCapabilities_;
}

inline void T_ClientCapabilities::set_has_rKeyCapabilities () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ClientCapabilities::clear_has_rKeyCapabilities () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_XDeviceKeys::T_XDeviceKeys ()  :
    _szName (),
    _bMandatory (false),
    _e32SymbolValue (::midw_smartphoneint_fi_types::T_e32_KeyCode__ITU_KEY_0),
    _IconList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_XDeviceKeys::T_XDeviceKeys (const T_XDeviceKeys &rhs)  :
    _szName (),
    _bMandatory (false),
    _e32SymbolValue (::midw_smartphoneint_fi_types::T_e32_KeyCode__ITU_KEY_0),
    _IconList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_XDeviceKeys::T_XDeviceKeys (const ::std::string& szName_, bool bMandatory_, T_e32_KeyCode e32SymbolValue_, const ::std::vector< T_IconAttributes >& IconList_)  :
    _szName (szName_),
    _bMandatory (bMandatory_),
    _e32SymbolValue (e32SymbolValue_),
    _IconList (IconList_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e32_KeyCode_IsValid(e32SymbolValue_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e32SymbolValue_, "T_e32_KeyCode", "e32SymbolValue", "T_XDeviceKeys");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_XDeviceKeys::~T_XDeviceKeys() {
}

inline T_XDeviceKeys& T_XDeviceKeys::operator = (const T_XDeviceKeys& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSzName()) {
            setSzName(rhs.getSzName());
        } else {
            clearSzName();
        }
        if (rhs.hasBMandatory()) {
            setBMandatory(rhs.getBMandatory());
        } else {
            clearBMandatory();
        }
        if (rhs.hasE32SymbolValue()) {
            setE32SymbolValue(rhs.getE32SymbolValue());
        } else {
            clearE32SymbolValue();
        }
        if (rhs.hasIconList()) {
            setIconList(rhs.getIconList());
        } else {
            clearIconList();
        }
    }
    return *this;
}

inline bool T_XDeviceKeys::operator == (const T_XDeviceKeys& rhs) const {
    return (((!hasSzName() && !rhs.hasSzName()) || getSzName() == rhs.getSzName()) &&
        ((!hasBMandatory() && !rhs.hasBMandatory()) || getBMandatory() == rhs.getBMandatory()) &&
        ((!hasE32SymbolValue() && !rhs.hasE32SymbolValue()) || getE32SymbolValue() == rhs.getE32SymbolValue()) &&
        ((!hasIconList() && !rhs.hasIconList()) || getIconList() == rhs.getIconList()));
}

inline bool T_XDeviceKeys::operator != (const T_XDeviceKeys& rhs) const {
    return ! (*this == rhs);
}

inline bool T_XDeviceKeys::operator < (const T_XDeviceKeys& rhs) const {
    if (hasSzName() || rhs.hasSzName()) {
        if (getSzName() < rhs.getSzName()) return true;
        if (getSzName() > rhs.getSzName()) return false;
    }
    if (hasBMandatory() || rhs.hasBMandatory()) {
        if (getBMandatory() < rhs.getBMandatory()) return true;
        if (getBMandatory() > rhs.getBMandatory()) return false;
    }
    if (hasE32SymbolValue() || rhs.hasE32SymbolValue()) {
        if ((uint32)getE32SymbolValue() < (uint32)rhs.getE32SymbolValue()) return true;
        if ((uint32)getE32SymbolValue() > (uint32)rhs.getE32SymbolValue()) return false;
    }
    if (hasIconList() || rhs.hasIconList()) {
        if (getIconList() < rhs.getIconList()) return true;
        if (getIconList() > rhs.getIconList()) return false;
    }
    return false;
}

inline bool T_XDeviceKeys::operator > (const T_XDeviceKeys& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_XDeviceKeys::clear() {
    clearSzName();
    clearBMandatory();
    clearE32SymbolValue();
    clearIconList();
}

inline void T_XDeviceKeys::clearSzName() {
    if (hasSzName()) {
         clear_has_szName();
        _szName.clear();
     }
}

inline bool T_XDeviceKeys::hasSzName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_XDeviceKeys::getSzName () const {
    return _szName;
}

inline ::std::string& T_XDeviceKeys::getSzNameMutable () {
    set_has_szName();
    return _szName;
}

inline void T_XDeviceKeys::setSzName (const ::std::string& szName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szName();
    this->_szName = szName_;
}

inline void T_XDeviceKeys::setSzName (const char* szName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szName();
    this->_szName.assign(szName_);
}

inline void T_XDeviceKeys::setSzName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szName();
    this->_szName.assign(value, size);
}

inline void T_XDeviceKeys::clearBMandatory() {
    if (hasBMandatory()) {
         clear_has_bMandatory();
        _bMandatory = false;
     }
}

inline bool T_XDeviceKeys::hasBMandatory () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_XDeviceKeys::getBMandatory () const {
    return _bMandatory;
}

inline void T_XDeviceKeys::setBMandatory (bool bMandatory_) {
    set_has_bMandatory();
    this->_bMandatory = bMandatory_;
}

inline void T_XDeviceKeys::clearE32SymbolValue() {
    if (hasE32SymbolValue()) {
         clear_has_e32SymbolValue();
        _e32SymbolValue = ::midw_smartphoneint_fi_types::T_e32_KeyCode__ITU_KEY_0;
     }
}

inline bool T_XDeviceKeys::hasE32SymbolValue () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e32_KeyCode T_XDeviceKeys::getE32SymbolValue () const {
    return _e32SymbolValue;
}

inline void T_XDeviceKeys::setE32SymbolValue (T_e32_KeyCode e32SymbolValue_) {
    #ifndef NDEBUG
    if (!(T_e32_KeyCode_IsValid(e32SymbolValue_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e32SymbolValue_, "T_e32_KeyCode", "e32SymbolValue", "T_XDeviceKeys");
    }
    #endif
    set_has_e32SymbolValue();
    this->_e32SymbolValue = e32SymbolValue_;
}

inline void T_XDeviceKeys::clearIconList() {
    if (hasIconList()) {
         clear_has_IconList();
        _IconList.clear();
     }
}

inline bool T_XDeviceKeys::hasIconList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< T_IconAttributes >& T_XDeviceKeys::getIconList () const {
    return _IconList;
}

inline ::std::vector< T_IconAttributes >& T_XDeviceKeys::getIconListMutable () {
    set_has_IconList();
    return _IconList;
}

inline void T_XDeviceKeys::setIconList (const ::std::vector< T_IconAttributes >& IconList_) {
    set_has_IconList();
    this->_IconList = IconList_;
}

inline void T_XDeviceKeys::set_has_szName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_XDeviceKeys::clear_has_szName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_XDeviceKeys::set_has_bMandatory () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_XDeviceKeys::clear_has_bMandatory () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_XDeviceKeys::set_has_e32SymbolValue () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_XDeviceKeys::clear_has_e32SymbolValue () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_XDeviceKeys::set_has_IconList () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_XDeviceKeys::clear_has_IconList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_AudioCapabilities::T_AudioCapabilities ()  :
    _u16BTHFPSupport (0u),
    _u16BTA2DPSupport (0u),
    _u16RTPInSupport (0u),
    _u16RTPOutSupport (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AudioCapabilities::T_AudioCapabilities (const T_AudioCapabilities &rhs)  :
    _u16BTHFPSupport (0u),
    _u16BTA2DPSupport (0u),
    _u16RTPInSupport (0u),
    _u16RTPOutSupport (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AudioCapabilities::T_AudioCapabilities (uint16 u16BTHFPSupport_, uint16 u16BTA2DPSupport_, uint16 u16RTPInSupport_, uint16 u16RTPOutSupport_)  :
    _u16BTHFPSupport (u16BTHFPSupport_),
    _u16BTA2DPSupport (u16BTA2DPSupport_),
    _u16RTPInSupport (u16RTPInSupport_),
    _u16RTPOutSupport (u16RTPOutSupport_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AudioCapabilities::~T_AudioCapabilities() {
}

inline T_AudioCapabilities& T_AudioCapabilities::operator = (const T_AudioCapabilities& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16BTHFPSupport()) {
            setU16BTHFPSupport(rhs.getU16BTHFPSupport());
        } else {
            clearU16BTHFPSupport();
        }
        if (rhs.hasU16BTA2DPSupport()) {
            setU16BTA2DPSupport(rhs.getU16BTA2DPSupport());
        } else {
            clearU16BTA2DPSupport();
        }
        if (rhs.hasU16RTPInSupport()) {
            setU16RTPInSupport(rhs.getU16RTPInSupport());
        } else {
            clearU16RTPInSupport();
        }
        if (rhs.hasU16RTPOutSupport()) {
            setU16RTPOutSupport(rhs.getU16RTPOutSupport());
        } else {
            clearU16RTPOutSupport();
        }
    }
    return *this;
}

inline bool T_AudioCapabilities::operator == (const T_AudioCapabilities& rhs) const {
    return (((!hasU16BTHFPSupport() && !rhs.hasU16BTHFPSupport()) || getU16BTHFPSupport() == rhs.getU16BTHFPSupport()) &&
        ((!hasU16BTA2DPSupport() && !rhs.hasU16BTA2DPSupport()) || getU16BTA2DPSupport() == rhs.getU16BTA2DPSupport()) &&
        ((!hasU16RTPInSupport() && !rhs.hasU16RTPInSupport()) || getU16RTPInSupport() == rhs.getU16RTPInSupport()) &&
        ((!hasU16RTPOutSupport() && !rhs.hasU16RTPOutSupport()) || getU16RTPOutSupport() == rhs.getU16RTPOutSupport()));
}

inline bool T_AudioCapabilities::operator != (const T_AudioCapabilities& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AudioCapabilities::operator < (const T_AudioCapabilities& rhs) const {
    if (hasU16BTHFPSupport() || rhs.hasU16BTHFPSupport()) {
        if (getU16BTHFPSupport() < rhs.getU16BTHFPSupport()) return true;
        if (getU16BTHFPSupport() > rhs.getU16BTHFPSupport()) return false;
    }
    if (hasU16BTA2DPSupport() || rhs.hasU16BTA2DPSupport()) {
        if (getU16BTA2DPSupport() < rhs.getU16BTA2DPSupport()) return true;
        if (getU16BTA2DPSupport() > rhs.getU16BTA2DPSupport()) return false;
    }
    if (hasU16RTPInSupport() || rhs.hasU16RTPInSupport()) {
        if (getU16RTPInSupport() < rhs.getU16RTPInSupport()) return true;
        if (getU16RTPInSupport() > rhs.getU16RTPInSupport()) return false;
    }
    if (hasU16RTPOutSupport() || rhs.hasU16RTPOutSupport()) {
        if (getU16RTPOutSupport() < rhs.getU16RTPOutSupport()) return true;
        if (getU16RTPOutSupport() > rhs.getU16RTPOutSupport()) return false;
    }
    return false;
}

inline bool T_AudioCapabilities::operator > (const T_AudioCapabilities& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AudioCapabilities::clear() {
    clearU16BTHFPSupport();
    clearU16BTA2DPSupport();
    clearU16RTPInSupport();
    clearU16RTPOutSupport();
}

inline void T_AudioCapabilities::clearU16BTHFPSupport() {
    if (hasU16BTHFPSupport()) {
         clear_has_u16BTHFPSupport();
        _u16BTHFPSupport = 0u;
     }
}

inline bool T_AudioCapabilities::hasU16BTHFPSupport () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_AudioCapabilities::getU16BTHFPSupport () const {
    return _u16BTHFPSupport;
}

inline void T_AudioCapabilities::setU16BTHFPSupport (uint16 u16BTHFPSupport_) {
    set_has_u16BTHFPSupport();
    this->_u16BTHFPSupport = u16BTHFPSupport_;
}

inline void T_AudioCapabilities::clearU16BTA2DPSupport() {
    if (hasU16BTA2DPSupport()) {
         clear_has_u16BTA2DPSupport();
        _u16BTA2DPSupport = 0u;
     }
}

inline bool T_AudioCapabilities::hasU16BTA2DPSupport () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_AudioCapabilities::getU16BTA2DPSupport () const {
    return _u16BTA2DPSupport;
}

inline void T_AudioCapabilities::setU16BTA2DPSupport (uint16 u16BTA2DPSupport_) {
    set_has_u16BTA2DPSupport();
    this->_u16BTA2DPSupport = u16BTA2DPSupport_;
}

inline void T_AudioCapabilities::clearU16RTPInSupport() {
    if (hasU16RTPInSupport()) {
         clear_has_u16RTPInSupport();
        _u16RTPInSupport = 0u;
     }
}

inline bool T_AudioCapabilities::hasU16RTPInSupport () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_AudioCapabilities::getU16RTPInSupport () const {
    return _u16RTPInSupport;
}

inline void T_AudioCapabilities::setU16RTPInSupport (uint16 u16RTPInSupport_) {
    set_has_u16RTPInSupport();
    this->_u16RTPInSupport = u16RTPInSupport_;
}

inline void T_AudioCapabilities::clearU16RTPOutSupport() {
    if (hasU16RTPOutSupport()) {
         clear_has_u16RTPOutSupport();
        _u16RTPOutSupport = 0u;
     }
}

inline bool T_AudioCapabilities::hasU16RTPOutSupport () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_AudioCapabilities::getU16RTPOutSupport () const {
    return _u16RTPOutSupport;
}

inline void T_AudioCapabilities::setU16RTPOutSupport (uint16 u16RTPOutSupport_) {
    set_has_u16RTPOutSupport();
    this->_u16RTPOutSupport = u16RTPOutSupport_;
}

inline void T_AudioCapabilities::set_has_u16BTHFPSupport () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AudioCapabilities::clear_has_u16BTHFPSupport () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AudioCapabilities::set_has_u16BTA2DPSupport () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AudioCapabilities::clear_has_u16BTA2DPSupport () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AudioCapabilities::set_has_u16RTPInSupport () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AudioCapabilities::clear_has_u16RTPInSupport () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AudioCapabilities::set_has_u16RTPOutSupport () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AudioCapabilities::clear_has_u16RTPOutSupport () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_DisplayCapabilities::T_DisplayCapabilities ()  :
    _u16FrameBufferConfiguration (0u),
    _u16PixelFormat (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DisplayCapabilities::T_DisplayCapabilities (const T_DisplayCapabilities &rhs)  :
    _u16FrameBufferConfiguration (0u),
    _u16PixelFormat (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DisplayCapabilities::T_DisplayCapabilities (uint16 u16FrameBufferConfiguration_, uint16 u16PixelFormat_)  :
    _u16FrameBufferConfiguration (u16FrameBufferConfiguration_),
    _u16PixelFormat (u16PixelFormat_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DisplayCapabilities::~T_DisplayCapabilities() {
}

inline T_DisplayCapabilities& T_DisplayCapabilities::operator = (const T_DisplayCapabilities& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16FrameBufferConfiguration()) {
            setU16FrameBufferConfiguration(rhs.getU16FrameBufferConfiguration());
        } else {
            clearU16FrameBufferConfiguration();
        }
        if (rhs.hasU16PixelFormat()) {
            setU16PixelFormat(rhs.getU16PixelFormat());
        } else {
            clearU16PixelFormat();
        }
    }
    return *this;
}

inline bool T_DisplayCapabilities::operator == (const T_DisplayCapabilities& rhs) const {
    return (((!hasU16FrameBufferConfiguration() && !rhs.hasU16FrameBufferConfiguration()) || getU16FrameBufferConfiguration() == rhs.getU16FrameBufferConfiguration()) &&
        ((!hasU16PixelFormat() && !rhs.hasU16PixelFormat()) || getU16PixelFormat() == rhs.getU16PixelFormat()));
}

inline bool T_DisplayCapabilities::operator != (const T_DisplayCapabilities& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DisplayCapabilities::operator < (const T_DisplayCapabilities& rhs) const {
    if (hasU16FrameBufferConfiguration() || rhs.hasU16FrameBufferConfiguration()) {
        if (getU16FrameBufferConfiguration() < rhs.getU16FrameBufferConfiguration()) return true;
        if (getU16FrameBufferConfiguration() > rhs.getU16FrameBufferConfiguration()) return false;
    }
    if (hasU16PixelFormat() || rhs.hasU16PixelFormat()) {
        if (getU16PixelFormat() < rhs.getU16PixelFormat()) return true;
        if (getU16PixelFormat() > rhs.getU16PixelFormat()) return false;
    }
    return false;
}

inline bool T_DisplayCapabilities::operator > (const T_DisplayCapabilities& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DisplayCapabilities::clear() {
    clearU16FrameBufferConfiguration();
    clearU16PixelFormat();
}

inline void T_DisplayCapabilities::clearU16FrameBufferConfiguration() {
    if (hasU16FrameBufferConfiguration()) {
         clear_has_u16FrameBufferConfiguration();
        _u16FrameBufferConfiguration = 0u;
     }
}

inline bool T_DisplayCapabilities::hasU16FrameBufferConfiguration () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_DisplayCapabilities::getU16FrameBufferConfiguration () const {
    return _u16FrameBufferConfiguration;
}

inline void T_DisplayCapabilities::setU16FrameBufferConfiguration (uint16 u16FrameBufferConfiguration_) {
    set_has_u16FrameBufferConfiguration();
    this->_u16FrameBufferConfiguration = u16FrameBufferConfiguration_;
}

inline void T_DisplayCapabilities::clearU16PixelFormat() {
    if (hasU16PixelFormat()) {
         clear_has_u16PixelFormat();
        _u16PixelFormat = 0u;
     }
}

inline bool T_DisplayCapabilities::hasU16PixelFormat () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_DisplayCapabilities::getU16PixelFormat () const {
    return _u16PixelFormat;
}

inline void T_DisplayCapabilities::setU16PixelFormat (uint16 u16PixelFormat_) {
    set_has_u16PixelFormat();
    this->_u16PixelFormat = u16PixelFormat_;
}

inline void T_DisplayCapabilities::set_has_u16FrameBufferConfiguration () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DisplayCapabilities::clear_has_u16FrameBufferConfiguration () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DisplayCapabilities