/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "midw_smartphoneint_fi.h"
#include "midw_smartphoneint_fiCca.h"
#include "midw_smartphoneint_fi_types.h"
#include "midw_smartphoneint_fi_typesCca.h"
#include "midw_smartphoneint_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::midw_smartphoneint_fi::DeviceStatusInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceConnectionType();
    out << (uint8) in.getDeviceStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DeviceStatusInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o0;
    in >> o0;
    out.setDeviceHandle(o0);
    uint8 o1;
    in >> o1;
    out.setDeviceConnectionType((::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType)o1);
    uint8 o2;
    in >> o2;
    out.setDeviceStatus((::midw_smartphoneint_fi_types::T_e8_DeviceStatusInfo)o2);
}

void serializeCca(const ::midw_smartphoneint_fi::AppStatusInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceConnectionType();
    out << (uint8) in.getAppStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::AppStatusInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o3;
    in >> o3;
    out.setDeviceHandle(o3);
    uint8 o4;
    in >> o4;
    out.setDeviceConnectionType((::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType)o4);
    uint8 o5;
    in >> o5;
    out.setAppStatus((::midw_smartphoneint_fi_types::T_e8_AppStatusInfo)o5);
}

void serializeCca(const ::midw_smartphoneint_fi::DAPStatusInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceConnectionType();
    out << (uint8) in.getDAPStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DAPStatusInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o6;
    in >> o6;
    out.setDeviceHandle(o6);
    uint8 o7;
    in >> o7;
    out.setDeviceConnectionType((::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType)o7);
    uint8 o8;
    in >> o8;
    out.setDAPStatus((::midw_smartphoneint_fi_types::T_e8_DAPStatus)o8);
}

void serializeCca(const ::midw_smartphoneint_fi::NotificationInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getAppHandle();
    serializeCca(in.getNotificationData(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::NotificationInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o9;
    in >> o9;
    out.setDeviceHandle(o9);
    uint32 o10;
    in >> o10;
    out.setAppHandle(o10);
    deserializeCca(in, out.getNotificationDataMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::ApplicationMediaMetaDataStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getMetaDataValid();
    serializeCca(in.getApplicationMediaMetaData(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::ApplicationMediaMetaDataStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o11;
    in >> o11;
    out.setDeviceHandle(o11);
    bool o12;
    in >> o12;
    out.setMetaDataValid(o12);
    deserializeCca(in, out.getApplicationMediaMetaDataMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::DeviceDisplayContextStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDisplayFlag();
    out << (uint8) in.getDisplayContextReason();
    out << (uint8) in.getDisplayPermanentEntity();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DeviceDisplayContextStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o13;
    in >> o13;
    out.setDeviceHandle(o13);
    bool o14;
    in >> o14;
    out.setDisplayFlag(o14);
    uint8 o15;
    in >> o15;
    out.setDisplayContextReason((::midw_smartphoneint_fi_types::T_e8_DisplayContextReason)o15);
    uint8 o16;
    in >> o16;
    out.setDisplayPermanentEntity((::midw_smartphoneint_fi_types::T_e8_Entity)o16);
}

void serializeCca(const ::midw_smartphoneint_fi::ApplicationPhoneDataStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getPhoneDataValid();
    {
        uint32 o17 = static_cast<uint32>(in.getPhoneCallMetadata().size());
        out << o17;
        ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallMetadata >::const_iterator o18;
        for (o18 = in.getPhoneCallMetadata().begin(); o18 != in.getPhoneCallMetadata().end(); ++o18) {
            serializeCca((*o18), out, majorVersion);
        }
    }
    out << (uint8) in.getSignalStrength();
    out << (uint8) in.getRegistrationStatus();
    out << (uint8) in.getAirPlaneModeStatus();
    out << (uint8) in.getMute();
    out << in.getCarrierName();
    out << in.getBatteryChargeLevel();
    out << (uint8) in.getBatteryChargingState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::ApplicationPhoneDataStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o19;
    in >> o19;
    out.setDeviceHandle(o19);
    bool o20;
    in >> o20;
    out.setPhoneDataValid(o20);
    {
        uint32 o21;
        in >> o21;
        out.getPhoneCallMetadataMutable().clear ();
        out.getPhoneCallMetadataMutable().reserve (o21);
        for (uint32 o22 = 0; o22 < o21; o22++) {
            ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallMetadata o23;
            deserializeCca(in, o23, majorVersion);
            out.getPhoneCallMetadataMutable().push_back (o23);
        }
    }
    uint8 o24;
    in >> o24;
    out.setSignalStrength((::midw_smartphoneint_fi_types::T_e8_PhoneSignalStrength)o24);
    uint8 o25;
    in >> o25;
    out.setRegistrationStatus((::midw_smartphoneint_fi_types::T_e8_PhoneRegistrationStatus)o25);
    uint8 o26;
    in >> o26;
    out.setAirPlaneModeStatus((::midw_smartphoneint_fi_types::T_e8_PhoneAirPlaneModeStatus)o26);
    uint8 o27;
    in >> o27;
    out.setMute((::midw_smartphoneint_fi_types::T_e8_Mute)o27);
    ::std::string o28;
    in >> o28;
    out.setCarrierName(o28);
    uint8 o29;
    in >> o29;
    out.setBatteryChargeLevel(o29);
    uint8 o30;
    in >> o30;
    out.setBatteryChargingState((::midw_smartphoneint_fi_types::T_e8_BatteryChargingState)o30);
}

void serializeCca(const ::midw_smartphoneint_fi::BluetoothDeviceStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBluetoothDeviceHandle();
    out << in.getProjectionDeviceHandle();
    out << in.getConnectedProfiles();
    out << (uint8) in.getBTChangeInfo();
    out << (uint8) in.getSameDevice();
    out << (uint8) in.getCallActiveStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::BluetoothDeviceStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o31;
    in >> o31;
    out.setBluetoothDeviceHandle(o31);
    uint32 o32;
    in >> o32;
    out.setProjectionDeviceHandle(o32);
    uint8 o33;
    in >> o33;
    out.setConnectedProfiles(o33);
    uint8 o34;
    in >> o34;
    out.setBTChangeInfo((::midw_smartphoneint_fi_types::T_e8_BTChangeInfo)o34);
    bool o35;
    in >> o35;
    out.setSameDevice(o35);
    bool o36;
    in >> o36;
    out.setCallActiveStatus(o36);
}

void serializeCca(const ::midw_smartphoneint_fi::DeviceAudioContextStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getAudioFlag();
    out << (uint8) in.getAudioContext();
    out << (uint8) in.getAudioPermanentEntity();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DeviceAudioContextStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o37;
    in >> o37;
    out.setDeviceHandle(o37);
    bool o38;
    in >> o38;
    out.setAudioFlag(o38);
    uint8 o39;
    in >> o39;
    out.setAudioContext((::midw_smartphoneint_fi_types::T_e8_AudioContext)o39);
    uint8 o40;
    in >> o40;
    out.setAudioPermanentEntity((::midw_smartphoneint_fi_types::T_e8_Entity)o40);
}

void serializeCca(const ::midw_smartphoneint_fi::DiPOAppStatusInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getAppStateSpeech();
    out << (uint8) in.getAppStatePhone();
    out << (uint8) in.getAppStateNavigation();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DiPOAppStatusInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o41;
    in >> o41;
    out.setAppStateSpeech((::midw_smartphoneint_fi_types::T_e8_SpeechAppState)o41);
    uint8 o42;
    in >> o42;
    out.setAppStatePhone((::midw_smartphoneint_fi_types::T_e8_PhoneAppState)o42);
    uint8 o43;
    in >> o43;
    out.setAppStateNavigation((::midw_smartphoneint_fi_types::T_e8_NavigationAppState)o43);
}

void serializeCca(const ::midw_smartphoneint_fi::SessionStatusInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << (uint8) in.getSessionStatus();
    out << (uint8) in.getHandsetInteractionStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SessionStatusInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o44;
    in >> o44;
    out.setDeviceHandle(o44);
    uint8 o45;
    in >> o45;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o45);
    uint8 o46;
    in >> o46;
    out.setSessionStatus((::midw_smartphoneint_fi_types::T_e8_SessionStatus)o46);
    uint8 o47;
    in >> o47;
    out.setHandsetInteractionStatus((::midw_smartphoneint_fi_types::T_e8_HandsetInteraction)o47);
}

void serializeCca(const ::midw_smartphoneint_fi::BTPairingRequiredStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSDevBTAddr();
    out << (uint8) in.getBPairingReqd();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::BTPairingRequiredStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o48;
    in >> o48;
    out.setSDevBTAddr(o48);
    bool o49;
    in >> o49;
    out.setBPairingReqd(o49);
}

void serializeCca(const ::midw_smartphoneint_fi::MLServerKeyCapabilitiesStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getValidityOfData();
    out << in.getNumXDeviceKeys();
    {
        uint32 o50 = static_cast<uint32>(in.getXDeviceKeysList().size());
        out << o50;
        ::std::vector< ::midw_smartphoneint_fi_types::T_XDeviceKeys >::const_iterator o51;
        for (o51 = in.getXDeviceKeysList().begin(); o51 != in.getXDeviceKeysList().end(); ++o51) {
            serializeCca((*o51), out, majorVersion);
        }
    }
    serializeCca(in.getRKeyCapabilities(), out, majorVersion);
    out << (uint8) in.getVoiceRecognitionSupportInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::MLServerKeyCapabilitiesStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o52;
    in >> o52;
    out.setDeviceHandle(o52);
    uint16 o53;
    in >> o53;
    out.setValidityOfData(o53);
    uint16 o54;
    in >> o54;
    out.setNumXDeviceKeys(o54);
    {
        uint32 o55;
        in >> o55;
        out.getXDeviceKeysListMutable().clear ();
        out.getXDeviceKeysListMutable().reserve (o55);
        for (uint32 o56 = 0; o56 < o55; o56++) {
            ::midw_smartphoneint_fi_types::T_XDeviceKeys o57;
            deserializeCca(in, o57, majorVersion);
            out.getXDeviceKeysListMutable().push_back (o57);
        }
    }
    deserializeCca(in, out.getRKeyCapabilitiesMutable(), majorVersion);
    uint8 o58;
    in >> o58;
    out.setVoiceRecognitionSupportInfo((::midw_smartphoneint_fi_types::T_e8_SupportInfo)o58);
}

void serializeCca(const ::midw_smartphoneint_fi::DialStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getTelephoneNumber();
    out << in.getDisplayContent();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DialStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o59;
    in >> o59;
    out.setDeviceHandle(o59);
    ::std::string o60;
    in >> o60;
    out.setTelephoneNumber(o60);
    ::std::string o61;
    in >> o61;
    out.setDisplayContent(o61);
}

void serializeCca(const ::midw_smartphoneint_fi::DialSet& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getPhoneCallState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DialSet& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o62;
    in >> o62;
    out.setDeviceHandle(o62);
    uint8 o63;
    in >> o63;
    out.setPhoneCallState((::midw_smartphoneint_fi_types::T_e8_PhoneCallState)o63);
}

void serializeCca(const ::midw_smartphoneint_fi::MediaPlayBackTimeStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getTotalPlayTime();
    out << in.getElapsedPlayTime();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::MediaPlayBackTimeStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o64;
    in >> o64;
    out.setDeviceHandle(o64);
    uint32 o65;
    in >> o65;
    out.setTotalPlayTime(o65);
    uint32 o66;
    in >> o66;
    out.setElapsedPlayTime(o66);
}

void serializeCca(const ::midw_smartphoneint_fi::ProjectionDeviceAuthorizationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getNumDevices();
    {
        uint32 o67 = static_cast<uint32>(in.getDeviceAuthInfoList().size());
        out << o67;
        ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceAuthInfo >::const_iterator o68;
        for (o68 = in.getDeviceAuthInfoList().begin(); o68 != in.getDeviceAuthInfoList().end(); ++o68) {
            serializeCca((*o68), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::ProjectionDeviceAuthorizationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o69;
    in >> o69;
    out.setNumDevices(o69);
    {
        uint32 o70;
        in >> o70;
        out.getDeviceAuthInfoListMutable().clear ();
        out.getDeviceAuthInfoListMutable().reserve (o70);
        for (uint32 o71 = 0; o71 < o70; o71++) {
            ::midw_smartphoneint_fi_types::T_DeviceAuthInfo o72;
            deserializeCca(in, o72, majorVersion);
            out.getDeviceAuthInfoListMutable().push_back (o72);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::ProjectionDeviceAuthorizationSet& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getUserAuthorizationStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::ProjectionDeviceAuthorizationSet& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o73;
    in >> o73;
    out.setDeviceHandle(o73);
    uint8 o74;
    in >> o74;
    out.setUserAuthorizationStatus((::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus)o74);
}

void serializeCca(const ::midw_smartphoneint_fi::NavigationStatusInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << (uint8) in.getNavigationStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::NavigationStatusInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o75;
    in >> o75;
    out.setDeviceHandle(o75);
    uint8 o76;
    in >> o76;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o76);
    uint8 o77;
    in >> o77;
    out.setNavigationStatus((::midw_smartphoneint_fi_types::T_e8_NavigationAppState)o77);
}

void serializeCca(const ::midw_smartphoneint_fi::NavigationNextTurnDataStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << in.getRoadName();
    out << (uint8) in.getTurnSide();
    out << (uint8) in.getNextTurnEvent();
    out << in.getImage();
    out << in.getTurnAngle();
    out << in.getTurnNumber();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::NavigationNextTurnDataStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o78;
    in >> o78;
    out.setDeviceHandle(o78);
    uint8 o79;
    in >> o79;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o79);
    ::std::string o80;
    in >> o80;
    out.setRoadName(o80);
    uint8 o81;
    in >> o81;
    out.setTurnSide((::midw_smartphoneint_fi_types::T_e8_TurnSide)o81);
    uint8 o82;
    in >> o82;
    out.setNextTurnEvent((::midw_smartphoneint_fi_types::T_e8_NextTurnEvent)o82);
    ::std::string o83;
    in >> o83;
    out.setImage(o83);
    int32 o84;
    in >> o84;
    out.setTurnAngle(o84);
    int32 o85;
    in >> o85;
    out.setTurnNumber(o85);
}

void serializeCca(const ::midw_smartphoneint_fi::NavigationNextTurnDistanceDataStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << in.getDistanceInMeters();
    out << in.getTimeInSec();
    out << in.getDistanceToManeuver();
    out << (uint8) in.getManeuverDistanceUnits();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::NavigationNextTurnDistanceDataStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o86;
    in >> o86;
    out.setDeviceHandle(o86);
    uint8 o87;
    in >> o87;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o87);
    int32 o88;
    in >> o88;
    out.setDistanceInMeters(o88);
    int32 o89;
    in >> o89;
    out.setTimeInSec(o89);
    int32 o90;
    in >> o90;
    out.setDistanceToManeuver(o90);
    uint8 o91;
    in >> o91;
    out.setManeuverDistanceUnits((::midw_smartphoneint_fi_types::T_e8_ManeuverDistanceUnits)o91);
}

void serializeCca(const ::midw_smartphoneint_fi::AAPNotificationEventStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << in.getAAPNotificationId();
    out << in.getNotificationText();
    {
        uint32 o92 = static_cast<uint32>(in.getNotificationIcon().size());
        out << o92;
        ::std::vector< uint8 >::const_iterator o93;
        for (o93 = in.getNotificationIcon().begin(); o93 != in.getNotificationIcon().end(); ++o93) {
            out << (*o93);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::AAPNotificationEventStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o94;
    in >> o94;
    out.setDeviceHandle(o94);
    uint8 o95;
    in >> o95;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o95);
    ::std::string o96;
    in >> o96;
    out.setAAPNotificationId(o96);
    ::std::string o97;
    in >> o97;
    out.setNotificationText(o97);
    {
        uint32 o98;
        in >> o98;
        out.getNotificationIconMutable().clear ();
        out.getNotificationIconMutable().reserve (o98);
        for (uint32 o99 = 0; o99 < o98; o99++) {
            uint8 o100;
            in >> o100;
            out.getNotificationIconMutable().push_back(o100);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::AAPNotificationEventSet& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getAAPNotificationId();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::AAPNotificationEventSet& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o101;
    in >> o101;
    out.setAAPNotificationId(o101);
}

void serializeCca(const ::midw_smartphoneint_fi::MySPINBluetoothVoiceRecInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getBTVoiceRecRequest();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::MySPINBluetoothVoiceRecInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o102;
    in >> o102;
    out.setDeviceHandle(o102);
    uint8 o103;
    in >> o103;
    out.setBTVoiceRecRequest((::midw_smartphoneint_fi_types::T_e8_BTVoiceRecRequest)o103);
}

void serializeCca(const ::midw_smartphoneint_fi::MySPINBluetoothVoiceRecInfoSet& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getBTVoiceRecReqResponse();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::MySPINBluetoothVoiceRecInfoSet& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o104;
    in >> o104;
    out.setDeviceHandle(o104);
    uint8 o105;
    in >> o105;
    out.setBTVoiceRecReqResponse((::midw_smartphoneint_fi_types::T_e8_BTVoiceRecRequestResponse)o105);
}

void serializeCca(const ::midw_smartphoneint_fi::TechnologySelectionStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getSelectedTechnology();
    out << (uint8) in.getDeviceType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::TechnologySelectionStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o106;
    in >> o106;
    out.setDeviceHandle(o106);
    uint8 o107;
    in >> o107;
    out.setSelectedTechnology((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o107);
    uint8 o108;
    in >> o108;
    out.setDeviceType((::midw_smartphoneint_fi_types::T_e8_DeviceType)o108);
}

void serializeCca(const ::midw_smartphoneint_fi::TechnologySelectionSet& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getSelectedTechnology();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::TechnologySelectionSet& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o109;
    in >> o109;
    out.setDeviceHandle(o109);
    uint8 o110;
    in >> o110;
    out.setSelectedTechnology((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o110);
}

void serializeCca(const ::midw_smartphoneint_fi::WiFiCredentialsStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getAccessoryWiFiAPCredentials(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::WiFiCredentialsStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getAccessoryWiFiAPCredentialsMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::TurnByTurnInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    serializeCca(in.getCarPlayTBTUpdate(), out, majorVersion);
    serializeCca(in.getAAutoTBTUpdate(), out, majorVersion);
    serializeCca(in.getBDCLTBTUpdate(), out, majorVersion);
    serializeCca(in.getMLTBTUpdate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::TurnByTurnInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o111;
    in >> o111;
    out.setDeviceHandle(o111);
    uint8 o112;
    in >> o112;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o112);
    deserializeCca(in, out.getCarPlayTBTUpdateMutable(), majorVersion);
    deserializeCca(in, out.getAAutoTBTUpdateMutable(), majorVersion);
    deserializeCca(in, out.getBDCLTBTUpdateMutable(), majorVersion);
    deserializeCca(in, out.getMLTBTUpdateMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::ProjectedVideoInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getProjectedVideoAttributes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::ProjectedVideoInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o113;
    in >> o113;
    out.setDeviceHandle(o113);
    deserializeCca(in, out.getProjectedVideoAttributesMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::DeviceLockStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << (uint8) in.getBDeviceLockStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DeviceLockStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o114;
    in >> o114;
    out.setDeviceHandle(o114);
    uint8 o115;
    in >> o115;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o115);
    bool o116;
    in >> o116;
    out.setBDeviceLockStatus(o116);
}

void serializeCca(const ::midw_smartphoneint_fi::RelativelyActiveMediaAppStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getMediaAppHandle();
    out << (uint8) in.getMediaAppCategory();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::RelativelyActiveMediaAppStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o117;
    in >> o117;
    out.setMediaAppHandle(o117);
    uint8 o118;
    in >> o118;
    out.setMediaAppCategory((::midw_smartphoneint_fi_types::T_e8Media_AppCategory)o118);
}

void serializeCca(const ::midw_smartphoneint_fi::CarplayRouteGuidanceUpdateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getDeviceUSBSerialNumber();
    serializeCca(in.getRouteGuidanceUpdate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::CarplayRouteGuidanceUpdateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o119;
    in >> o119;
    out.setDeviceHandle(o119);
    ::std::string o120;
    in >> o120;
    out.setDeviceUSBSerialNumber(o120);
    deserializeCca(in, out.getRouteGuidanceUpdateMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::CarplayRouteGuidanceManeuverUpdateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getDeviceUSBSerialNumber();
    serializeCca(in.getRouteGuidanceManeuverUpdate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::CarplayRouteGuidanceManeuverUpdateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o121;
    in >> o121;
    out.setDeviceHandle(o121);
    ::std::string o122;
    in >> o122;
    out.setDeviceUSBSerialNumber(o122);
    deserializeCca(in, out.getRouteGuidanceManeuverUpdateMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::AAutoTurnByTurnInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getAAutoTBTUpdate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::AAutoTurnByTurnInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o123;
    in >> o123;
    out.setDeviceHandle(o123);
    deserializeCca(in, out.getAAutoTBTUpdateMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::BDCLTurnByTurnInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getBDCLTBTUpdate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::BDCLTurnByTurnInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o124;
    in >> o124;
    out.setDeviceHandle(o124);
    deserializeCca(in, out.getBDCLTBTUpdateMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::MLTurnByTurnInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getMLTBTUpdate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::MLTurnByTurnInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o125;
    in >> o125;
    out.setDeviceHandle(o125);
    deserializeCca(in, out.getMLTBTUpdateMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::ApplicationPhoneCallDataStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    {
        uint32 o126 = static_cast<uint32>(in.getPhoneCallExtendedMetadata().size());
        out << o126;
        ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallExtendedMetadata >::const_iterator o127;
        for (o127 = in.getPhoneCallExtendedMetadata().begin(); o127 != in.getPhoneCallExtendedMetadata().end(); ++o127) {
            serializeCca((*o127), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::ApplicationPhoneCallDataStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o128;
    in >> o128;
    out.setDeviceHandle(o128);
    {
        uint32 o129;
        in >> o129;
        out.getPhoneCallExtendedMetadataMutable().clear ();
        out.getPhoneCallExtendedMetadataMutable().reserve (o129);
        for (uint32 o130 = 0; o130 < o129; o130++) {
            ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallExtendedMetadata o131;
            deserializeCca(in, o131, majorVersion);
            out.getPhoneCallExtendedMetadataMutable().push_back (o131);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::GetDeviceInfoListResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getNumDevices();
    {
        uint32 o132 = static_cast<uint32>(in.getDeviceInfoList().size());
        out << o132;
        ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceDetails >::const_iterator o133;
        for (o133 = in.getDeviceInfoList().begin(); o133 != in.getDeviceInfoList().end(); ++o133) {
            serializeCca((*o133), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetDeviceInfoListResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o134;
    in >> o134;
    out.setNumDevices(o134);
    {
        uint32 o135;
        in >> o135;
        out.getDeviceInfoListMutable().clear ();
        out.getDeviceInfoListMutable().reserve (o135);
        for (uint32 o136 = 0; o136 < o135; o136++) {
            ::midw_smartphoneint_fi_types::T_DeviceDetails o137;
            deserializeCca(in, o137, majorVersion);
            out.getDeviceInfoListMutable().push_back (o137);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::SelectDeviceStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceConnectionType();
    out << (uint8) in.getDeviceConnectionReq();
    out << (uint8) in.getDAPUsage();
    out << (uint8) in.getCDBUsage();
    out << (uint8) in.getDeviceCategory();
    out << (uint8) in.getSelectionType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SelectDeviceStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o138;
    in >> o138;
    out.setDeviceHandle(o138);
    uint8 o139;
    in >> o139;
    out.setDeviceConnectionType((::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType)o139);
    uint8 o140;
    in >> o140;
    out.setDeviceConnectionReq((::midw_smartphoneint_fi_types::T_e8_DeviceConnectionReq)o140);
    uint8 o141;
    in >> o141;
    out.setDAPUsage((::midw_smartphoneint_fi_types::T_e8_EnabledInfo)o141);
    uint8 o142;
    in >> o142;
    out.setCDBUsage((::midw_smartphoneint_fi_types::T_e8_EnabledInfo)o142);
    uint8 o143;
    in >> o143;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o143);
    uint8 o144;
    in >> o144;
    out.setSelectionType((::midw_smartphoneint_fi_types::T_e8_SelectionType)o144);
}

void serializeCca(const ::midw_smartphoneint_fi::SelectDeviceResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceConnectionType();
    out << (uint8) in.getDeviceConnectionReq();
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
    out << (uint8) in.getBTPairingRequired();
    out << (uint8) in.getDeviceCategory();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SelectDeviceResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o145;
    in >> o145;
    out.setDeviceHandle(o145);
    uint8 o146;
    in >> o146;
    out.setDeviceConnectionType((::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType)o146);
    uint8 o147;
    in >> o147;
    out.setDeviceConnectionReq((::midw_smartphoneint_fi_types::T_e8_DeviceConnectionReq)o147);
    uint8 o148;
    in >> o148;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o148);
    uint8 o149;
    in >> o149;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o149);
    bool o150;
    in >> o150;
    out.setBTPairingRequired(o150);
    uint8 o151;
    in >> o151;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o151);
}

void serializeCca(const ::midw_smartphoneint_fi::LaunchAppStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << in.getAppHandle();
    out << (uint8) in.getDiPOAppType();
    out << in.getTelephoneNumber();
    out << (uint8) in.getEcnrSetting();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::LaunchAppStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o152;
    in >> o152;
    out.setDeviceHandle(o152);
    uint8 o153;
    in >> o153;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o153);
    uint32 o154;
    in >> o154;
    out.setAppHandle(o154);
    uint8 o155;
    in >> o155;
    out.setDiPOAppType((::midw_smartphoneint_fi_types::T_e8_DiPOAppType)o155);
    ::std::string o156;
    in >> o156;
    out.setTelephoneNumber(o156);
    uint8 o157;
    in >> o157;
    out.setEcnrSetting((::midw_smartphoneint_fi_types::T_e8_EcnrSetting)o157);
}

void serializeCca(const ::midw_smartphoneint_fi::LaunchAppResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getAppHandle();
    out << (uint8) in.getDiPOAppType();
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::LaunchAppResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o158;
    in >> o158;
    out.setDeviceHandle(o158);
    uint32 o159;
    in >> o159;
    out.setAppHandle(o159);
    uint8 o160;
    in >> o160;
    out.setDiPOAppType((::midw_smartphoneint_fi_types::T_e8_DiPOAppType)o160);
    uint8 o161;
    in >> o161;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o161);
    uint8 o162;
    in >> o162;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o162);
}

void serializeCca(const ::midw_smartphoneint_fi::TerminateAppStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getAppHandle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::TerminateAppStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o163;
    in >> o163;
    out.setDeviceHandle(o163);
    uint32 o164;
    in >> o164;
    out.setAppHandle(o164);
}

void serializeCca(const ::midw_smartphoneint_fi::TerminateAppResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getAppHandle();
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::TerminateAppResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o165;
    in >> o165;
    out.setDeviceHandle(o165);
    uint32 o166;
    in >> o166;
    out.setAppHandle(o166);
    uint8 o167;
    in >> o167;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o167);
    uint8 o168;
    in >> o168;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o168);
}

void serializeCca(const ::midw_smartphoneint_fi::GetAppListStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetAppListStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o169;
    in >> o169;
    out.setDeviceHandle(o169);
}

void serializeCca(const ::midw_smartphoneint_fi::GetAppListResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getNumAppDetailsList();
    {
        uint32 o170 = static_cast<uint32>(in.getAppDetailsList().size());
        out << o170;
        ::std::vector< ::midw_smartphoneint_fi_types::T_AppDetails >::const_iterator o171;
        for (o171 = in.getAppDetailsList().begin(); o171 != in.getAppDetailsList().end(); ++o171) {
            serializeCca((*o171), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetAppListResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o172;
    in >> o172;
    out.setDeviceHandle(o172);
    uint16 o173;
    in >> o173;
    out.setNumAppDetailsList(o173);
    {
        uint32 o174;
        in >> o174;
        out.getAppDetailsListMutable().clear ();
        out.getAppDetailsListMutable().reserve (o174);
        for (uint32 o175 = 0; o175 < o174; o175++) {
            ::midw_smartphoneint_fi_types::T_AppDetails o176;
            deserializeCca(in, o176, majorVersion);
            out.getAppDetailsListMutable().push_back (o176);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::GetAppIconDataStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getAppIconURL();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetAppIconDataStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o177;
    in >> o177;
    out.setAppIconURL(o177);
}

void serializeCca(const ::midw_smartphoneint_fi::GetAppIconDataResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getIconMimeType();
    {
        uint32 o178 = static_cast<uint32>(in.getAppIconData().size());
        out << o178;
        ::std::vector< uint8 >::const_iterator o179;
        for (o179 = in.getAppIconData().begin(); o179 != in.getAppIconData().end(); ++o179) {
            out << (*o179);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetAppIconDataResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o180;
    in >> o180;
    out.setIconMimeType(o180);
    {
        uint32 o181;
        in >> o181;
        out.getAppIconDataMutable().clear ();
        out.getAppIconDataMutable().reserve (o181);
        for (uint32 o182 = 0; o182 < o181; o182++) {
            uint8 o183;
            in >> o183;
            out.getAppIconDataMutable().push_back(o183);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::SetAppIconAttributesStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getAppHandle();
    serializeCca(in.getIconAttributes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetAppIconAttributesStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o184;
    in >> o184;
    out.setDeviceHandle(o184);
    uint32 o185;
    in >> o185;
    out.setAppHandle(o185);
    deserializeCca(in, out.getIconAttributesMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::SetAppIconAttributesResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetAppIconAttributesResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o186;
    in >> o186;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o186);
    uint8 o187;
    in >> o187;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o187);
}

void serializeCca(const ::midw_smartphoneint_fi::SetDeviceUsagePreferenceStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << (uint8) in.getEnabledInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetDeviceUsagePreferenceStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o188;
    in >> o188;
    out.setDeviceHandle(o188);
    uint8 o189;
    in >> o189;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o189);
    uint8 o190;
    in >> o190;
    out.setEnabledInfo((::midw_smartphoneint_fi_types::T_e8_EnabledInfo)o190);
}

void serializeCca(const ::midw_smartphoneint_fi::SetDeviceUsagePreferenceResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetDeviceUsagePreferenceResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o191;
    in >> o191;
    out.setDeviceHandle(o191);
    uint8 o192;
    in >> o192;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o192);
    uint8 o193;
    in >> o193;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o193);
}

void serializeCca(const ::midw_smartphoneint_fi::SetMLNotificationEnabledInfoStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getNumNotificationEnableList();
    {
        uint32 o194 = static_cast<uint32>(in.getNotificationEnableList().size());
        out << o194;
        ::std::vector< ::midw_smartphoneint_fi_types::T_NotificationEnable >::const_iterator o195;
        for (o195 = in.getNotificationEnableList().begin(); o195 != in.getNotificationEnableList().end(); ++o195) {
            serializeCca((*o195), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetMLNotificationEnabledInfoStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o196;
    in >> o196;
    out.setDeviceHandle(o196);
    uint16 o197;
    in >> o197;
    out.setNumNotificationEnableList(o197);
    {
        uint32 o198;
        in >> o198;
        out.getNotificationEnableListMutable().clear ();
        out.getNotificationEnableListMutable().reserve (o198);
        for (uint32 o199 = 0; o199 < o198; o199++) {
            ::midw_smartphoneint_fi_types::T_NotificationEnable o200;
            deserializeCca(in, o200, majorVersion);
            out.getNotificationEnableListMutable().push_back (o200);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::SetMLNotificationEnabledInfoResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetMLNotificationEnabledInfoResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o201;
    in >> o201;
    out.setDeviceHandle(o201);
    uint8 o202;
    in >> o202;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o202);
    uint8 o203;
    in >> o203;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o203);
}

void serializeCca(const ::midw_smartphoneint_fi::InvokeNotificationActionStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getAppHandle();
    out << in.getNotificationID();
    out << in.getNotificationActionID();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::InvokeNotificationActionStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o204;
    in >> o204;
    out.setDeviceHandle(o204);
    uint32 o205;
    in >> o205;
    out.setAppHandle(o205);
    uint16 o206;
    in >> o206;
    out.setNotificationID(o206);
    uint16 o207;
    in >> o207;
    out.setNotificationActionID(o207);
}

void serializeCca(const ::midw_smartphoneint_fi::InvokeNotificationActionResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::InvokeNotificationActionResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o208;
    in >> o208;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o208);
    uint8 o209;
    in >> o209;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o209);
}

void serializeCca(const ::midw_smartphoneint_fi::GetVideoSettingsStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetVideoSettingsStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o210;
    in >> o210;
    out.setDeviceHandle(o210);
}

void serializeCca(const ::midw_smartphoneint_fi::GetVideoSettingsResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getVideoAttributes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetVideoSettingsResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o211;
    in >> o211;
    out.setDeviceHandle(o211);
    deserializeCca(in, out.getVideoAttributesMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::SetOrientationModeStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getOrientationMode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetOrientationModeStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o212;
    in >> o212;
    out.setDeviceHandle(o212);
    uint8 o213;
    in >> o213;
    out.setOrientationMode((::midw_smartphoneint_fi_types::T_e8_OrientationMode)o213);
}

void serializeCca(const ::midw_smartphoneint_fi::SetOrientationModeResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetOrientationModeResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o214;
    in >> o214;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o214);
    uint8 o215;
    in >> o215;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o215);
}

void serializeCca(const ::midw_smartphoneint_fi::SetScreenSizeStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getScreenAttributes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetScreenSizeStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getScreenAttributesMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::SetScreenSizeResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetScreenSizeResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o216;
    in >> o216;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o216);
    uint8 o217;
    in >> o217;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o217);
}

void serializeCca(const ::midw_smartphoneint_fi::SetVideoBlockingModeStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getBlockingMode();
    out << (uint8) in.getVideoBlockingReason();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetVideoBlockingModeStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o218;
    in >> o218;
    out.setDeviceHandle(o218);
    uint8 o219;
    in >> o219;
    out.setBlockingMode((::midw_smartphoneint_fi_types::T_e8_BlockingMode)o219);
    uint8 o220;
    in >> o220;
    out.setVideoBlockingReason((::midw_smartphoneint_fi_types::T_e8_VideoBlockingReason)o220);
}

void serializeCca(const ::midw_smartphoneint_fi::SetVideoBlockingModeResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetVideoBlockingModeResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o221;
    in >> o221;
    out.setDeviceHandle(o221);
    uint8 o222;
    in >> o222;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o222);
    uint8 o223;
    in >> o223;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o223);
}

void serializeCca(const ::midw_smartphoneint_fi::SetAudioBlockingModeStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getGlobalMuteEnable();
    out << (uint8) in.getMediaAudioBlockingEnable();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetAudioBlockingModeStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o224;
    in >> o224;
    out.setGlobalMuteEnable(o224);
    bool o225;
    in >> o225;
    out.setMediaAudioBlockingEnable(o225);
}

void serializeCca(const ::midw_smartphoneint_fi::SetAudioBlockingModeResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetAudioBlockingModeResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o226;
    in >> o226;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o226);
    uint8 o227;
    in >> o227;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o227);
}

void serializeCca(const ::midw_smartphoneint_fi::SetVehicleConfigurationStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getVehicleConfiguration();
    out << (uint8) in.getSetConfiguration();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetVehicleConfigurationStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o228;
    in >> o228;
    out.setVehicleConfiguration((::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration)o228);
    bool o229;
    in >> o229;
    out.setSetConfiguration(o229);
}

void serializeCca(const ::midw_smartphoneint_fi::SetVehicleConfigurationResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetVehicleConfigurationResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o230;
    in >> o230;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o230);
    uint8 o231;
    in >> o231;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o231);
}

void serializeCca(const ::midw_smartphoneint_fi::SendTouchEventStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getTouchData(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SendTouchEventStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o232;
    in >> o232;
    out.setDeviceHandle(o232);
    deserializeCca(in, out.getTouchDataMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::SendTouchEventResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SendTouchEventResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o233;
    in >> o233;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o233);
    uint8 o234;
    in >> o234;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o234);
}

void serializeCca(const ::midw_smartphoneint_fi::SendKeyEventStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getKeyMode();
    out << (uint32) in.getKeyCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SendKeyEventStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o235;
    in >> o235;
    out.setDeviceHandle(o235);
    uint8 o236;
    in >> o236;
    out.setKeyMode((::midw_smartphoneint_fi_types::T_e8_KeyMode)o236);
    uint32 o237;
    in >> o237;
    out.setKeyCode((::midw_smartphoneint_fi_types::T_e32_KeyCode)o237);
}

void serializeCca(const ::midw_smartphoneint_fi::SendKeyEventResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SendKeyEventResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o238;
    in >> o238;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o238);
    uint8 o239;
    in >> o239;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o239);
}

void serializeCca(const ::midw_smartphoneint_fi::SetClientCapabilitiesStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getClientCapabilities(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetClientCapabilitiesStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getClientCapabilitiesMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::SetClientCapabilitiesResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetClientCapabilitiesResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o240;
    in >> o240;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o240);
    uint8 o241;
    in >> o241;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o241);
}

void serializeCca(const ::midw_smartphoneint_fi::AccessoryDisplayContextStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDisplayFlag();
    out << (uint8) in.getDisplayContext();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::AccessoryDisplayContextStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o242;
    in >> o242;
    out.setDeviceHandle(o242);
    bool o243;
    in >> o243;
    out.setDisplayFlag(o243);
    uint8 o244;
    in >> o244;
    out.setDisplayContext((::midw_smartphoneint_fi_types::T_e8_DisplayContext)o244);
}

void serializeCca(const ::midw_smartphoneint_fi::AccessoryDisplayContextResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::AccessoryDisplayContextResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o245;
    in >> o245;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o245);
    uint8 o246;
    in >> o246;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o246);
}

void serializeCca(const ::midw_smartphoneint_fi::GetDeviceUsagePreferenceStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetDeviceUsagePreferenceStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o247;
    in >> o247;
    out.setDeviceHandle(o247);
    uint8 o248;
    in >> o248;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o248);
}

void serializeCca(const ::midw_smartphoneint_fi::GetDeviceUsagePreferenceResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << (uint8) in.getEnabledInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetDeviceUsagePreferenceResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o249;
    in >> o249;
    out.setDeviceHandle(o249);
    uint8 o250;
    in >> o250;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o250);
    uint8 o251;
    in >> o251;
    out.setEnabledInfo((::midw_smartphoneint_fi_types::T_e8_EnabledInfo)o251);
}

void serializeCca(const ::midw_smartphoneint_fi::SetVehicleBTAddressStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBTAddress();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetVehicleBTAddressStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o252;
    in >> o252;
    out.setBTAddress(o252);
}

void serializeCca(const ::midw_smartphoneint_fi::SetVehicleBTAddressResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetVehicleBTAddressResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o253;
    in >> o253;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o253);
    uint8 o254;
    in >> o254;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o254);
}

void serializeCca(const ::midw_smartphoneint_fi::InvokeBluetoothDeviceActionStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBluetoothDeviceHandle();
    out << in.getProjectionDeviceHandle();
    out << (uint8) in.getBTChangeInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::InvokeBluetoothDeviceActionStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o255;
    in >> o255;
    out.setBluetoothDeviceHandle(o255);
    uint32 o256;
    in >> o256;
    out.setProjectionDeviceHandle(o256);
    uint8 o257;
    in >> o257;
    out.setBTChangeInfo((::midw_smartphoneint_fi_types::T_e8_BTChangeInfo)o257);
}

void serializeCca(const ::midw_smartphoneint_fi::InvokeBluetoothDeviceActionResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::InvokeBluetoothDeviceActionResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o258;
    in >> o258;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o258);
    uint8 o259;
    in >> o259;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o259);
}

void serializeCca(const ::midw_smartphoneint_fi::AccessoryAudioContextStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getAudioFlag();
    out << (uint8) in.getAudioContext();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::AccessoryAudioContextStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o260;
    in >> o260;
    out.setDeviceHandle(o260);
    bool o261;
    in >> o261;
    out.setAudioFlag(o261);
    uint8 o262;
    in >> o262;
    out.setAudioContext((::midw_smartphoneint_fi_types::T_e8_AudioContext)o262);
}

void serializeCca(const ::midw_smartphoneint_fi::AccessoryAudioContextResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::AccessoryAudioContextResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o263;
    in >> o263;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o263);
    uint8 o264;
    in >> o264;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o264);
}

void serializeCca(const ::midw_smartphoneint_fi::AccessoryAppStateStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getAppStateSpeech();
    out << (uint8) in.getAppStatePhone();
    out << (uint8) in.getAppStateNavigation();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::AccessoryAppStateStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o265;
    in >> o265;
    out.setAppStateSpeech((::midw_smartphoneint_fi_types::T_e8_SpeechAppState)o265);
    uint8 o266;
    in >> o266;
    out.setAppStatePhone((::midw_smartphoneint_fi_types::T_e8_PhoneAppState)o266);
    uint8 o267;
    in >> o267;
    out.setAppStateNavigation((::midw_smartphoneint_fi_types::T_e8_NavigationAppState)o267);
}

void serializeCca(const ::midw_smartphoneint_fi::AccessoryAppStateResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::AccessoryAppStateResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o268;
    in >> o268;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o268);
    uint8 o269;
    in >> o269;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o269);
}

void serializeCca(const ::midw_smartphoneint_fi::SetRegionStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getRegion();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetRegionStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o270;
    in >> o270;
    out.setRegion((::midw_smartphoneint_fi_types::T_e8_Region)o270);
}

void serializeCca(const ::midw_smartphoneint_fi::SetRegionResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetRegionResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o271;
    in >> o271;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o271);
    uint8 o272;
    in >> o272;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o272);
}

void serializeCca(const ::midw_smartphoneint_fi::DiPORoleSwitchRequiredStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceTag();
    out << in.getUSBSerialNumber();
    out << (uint8) in.getDeviceCarplayCapability();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DiPORoleSwitchRequiredStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o273;
    in >> o273;
    out.setU8DeviceTag(o273);
    ::std::string o274;
    in >> o274;
    out.setUSBSerialNumber(o274);
    bool o275;
    in >> o275;
    out.setDeviceCarplayCapability(o275);
}

void serializeCca(const ::midw_smartphoneint_fi::DiPORoleSwitchRequiredResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceTag();
    out << (uint8) in.getE8DiPOSwitchReqResponse();
    out << in.getUSBSerialNumber();
    serializeCca(in.getREAPAppInfo(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DiPORoleSwitchRequiredResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o276;
    in >> o276;
    out.setU8DeviceTag(o276);
    uint8 o277;
    in >> o277;
    out.setE8DiPOSwitchReqResponse((::midw_smartphoneint_fi_types::T_e8_DiPOSwitchReqResponse)o277);
    ::std::string o278;
    in >> o278;
    out.setUSBSerialNumber(o278);
    deserializeCca(in, out.getREAPAppInfoMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::SetAccessoryDisplayContextStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getDisplayContextInfo(), out, majorVersion);
    serializeCca(in.getDisplayConstraintInfo(), out, majorVersion);
    out << (uint8) in.getContextResponsibility();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetAccessoryDisplayContextStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o279;
    in >> o279;
    out.setDeviceHandle(o279);
    deserializeCca(in, out.getDisplayContextInfoMutable(), majorVersion);
    deserializeCca(in, out.getDisplayConstraintInfoMutable(), majorVersion);
    uint8 o280;
    in >> o280;
    out.setContextResponsibility((::midw_smartphoneint_fi_types::T_e8_DisplayInfo)o280);
}

void serializeCca(const ::midw_smartphoneint_fi::SetAccessoryDisplayContextResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetAccessoryDisplayContextResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o281;
    in >> o281;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o281);
    uint8 o282;
    in >> o282;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o282);
}

void serializeCca(const ::midw_smartphoneint_fi::GetKeyIconDataStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getKeyIconURL();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetKeyIconDataStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o283;
    in >> o283;
    out.setDeviceHandle(o283);
    ::std::string o284;
    in >> o284;
    out.setKeyIconURL(o284);
}

void serializeCca(const ::midw_smartphoneint_fi::GetKeyIconDataResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    {
        uint32 o285 = static_cast<uint32>(in.getKeyIconData().size());
        out << o285;
        ::std::vector< uint8 >::const_iterator o286;
        for (o286 = in.getKeyIconData().begin(); o286 != in.getKeyIconData().end(); ++o286) {
            out << (*o286);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetKeyIconDataResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o287;
    in >> o287;
    out.setDeviceHandle(o287);
    {
        uint32 o288;
        in >> o288;
        out.getKeyIconDataMutable().clear ();
        out.getKeyIconDataMutable().reserve (o288);
        for (uint32 o289 = 0; o289 < o288; o289++) {
            uint8 o290;
            in >> o290;
            out.getKeyIconDataMutable().push_back(o290);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::SetDisplayAttributesStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getDisplayAttributes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetDisplayAttributesStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getDisplayAttributesMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::SetDisplayAttributesResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetDisplayAttributesResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o291;
    in >> o291;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o291);
    uint8 o292;
    in >> o292;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o292);
}

void serializeCca(const ::midw_smartphoneint_fi::RotaryControllerEventStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getControllerDeltaCounts();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::RotaryControllerEventStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o293;
    in >> o293;
    out.setDeviceHandle(o293);
    int8 o294;
    in >> o294;
    out.setControllerDeltaCounts(o294);
}

void serializeCca(const ::midw_smartphoneint_fi::RotaryControllerEventResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::RotaryControllerEventResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o295;
    in >> o295;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o295);
    uint8 o296;
    in >> o296;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o296);
}

void serializeCca(const ::midw_smartphoneint_fi::SetAccessoryAudioContextStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    {
        uint32 o297 = static_cast<uint32>(in.getAudioContextInfo().size());
        out << o297;
        ::std::vector< ::midw_smartphoneint_fi_types::T_AccessoryAudioContext >::const_iterator o298;
        for (o298 = in.getAudioContextInfo().begin(); o298 != in.getAudioContextInfo().end(); ++o298) {
            serializeCca((*o298), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetAccessoryAudioContextStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o299;
    in >> o299;
    out.setDeviceHandle(o299);
    {
        uint32 o300;
        in >> o300;
        out.getAudioContextInfoMutable().clear ();
        out.getAudioContextInfoMutable().reserve (o300);
        for (uint32 o301 = 0; o301 < o300; o301++) {
            ::midw_smartphoneint_fi_types::T_AccessoryAudioContext o302;
            deserializeCca(in, o302, majorVersion);
            out.getAudioContextInfoMutable().push_back (o302);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::SetAccessoryAudioContextResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetAccessoryAudioContextResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o303;
    in >> o303;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o303);
    uint8 o304;
    in >> o304;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o304);
}

void serializeCca(const ::midw_smartphoneint_fi::SetVehicleMovementStateStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getParkBrakeInfo();
    out << (uint8) in.getGearInfo();
    out << (uint8) in.getVehicleState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetVehicleMovementStateStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o305;
    in >> o305;
    out.setParkBrakeInfo((::midw_smartphoneint_fi_types::T_e8_ParkBrake)o305);
    uint8 o306;
    in >> o306;
    out.setGearInfo((::midw_smartphoneint_fi_types::T_e8_GearState)o306);
    uint8 o307;
    in >> o307;
    out.setVehicleState((::midw_smartphoneint_fi_types::T_e8_VehicleState)o307);
}

void serializeCca(const ::midw_smartphoneint_fi::SetVehicleMovementStateResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetVehicleMovementStateResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o308;
    in >> o308;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o308);
    uint8 o309;
    in >> o309;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o309);
}

void serializeCca(const ::midw_smartphoneint_fi::SetFeatureRestrictionsStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getDeviceCategory();
    serializeCca(in.getParkModeRestrictionInfo(), out, majorVersion);
    serializeCca(in.getDriveModeRestrictionInfo(), out, majorVersion);
    out << in.getGeneralRestrictionInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetFeatureRestrictionsStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o310;
    in >> o310;
    out.setDeviceCategory((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o310);
    deserializeCca(in, out.getParkModeRestrictionInfoMutable(), majorVersion);
    deserializeCca(in, out.getDriveModeRestrictionInfoMutable(), majorVersion);
    uint16 o311;
    in >> o311;
    out.setGeneralRestrictionInfo(o311);
}

void serializeCca(const ::midw_smartphoneint_fi::SetFeatureRestrictionsResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetFeatureRestrictionsResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o312;
    in >> o312;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o312);
    uint8 o313;
    in >> o313;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o313);
}

void serializeCca(const ::midw_smartphoneint_fi::VehicleMechanicalSpeedStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getVehicleSpeed();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::VehicleMechanicalSpeedStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    int32 o314;
    in >> o314;
    out.setVehicleSpeed(o314);
}

void serializeCca(const ::midw_smartphoneint_fi::VehicleMechanicalSpeedResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::VehicleMechanicalSpeedResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o315;
    in >> o315;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o315);
    uint8 o316;
    in >> o316;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o316);
}

void serializeCca(const ::midw_smartphoneint_fi::SetVehicleManufacturerInformationStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getVehicleMake();
    out << in.getVehicleModel();
    out << in.getVehicleModelYear();
    out << in.getVehicleHUSwVersion();
    out << in.getVehicleHUHwVersion();
    out << in.getVehicleHUMake();
    out << in.getVehicleHUModel();
    out << in.getVehicleHUSwBuild();
    out << (uint8) in.getDriverSideInfo();
    out << (uint8) in.getIsNativeNavSupported();
    serializeCca(in.getOEMICONDetails(), out, majorVersion);
    out << (uint8) in.getIsRotaryCtrlSupported();
    out << (uint8) in.getFidelityType();
    out << in.getSupportedSPITechnologiesInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetVehicleManufacturerInformationStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o317;
    in >> o317;
    out.setVehicleMake(o317);
    ::std::string o318;
    in >> o318;
    out.setVehicleModel(o318);
    ::std::string o319;
    in >> o319;
    out.setVehicleModelYear(o319);
    ::std::string o320;
    in >> o320;
    out.setVehicleHUSwVersion(o320);
    ::std::string o321;
    in >> o321;
    out.setVehicleHUHwVersion(o321);
    ::std::string o322;
    in >> o322;
    out.setVehicleHUMake(o322);
    ::std::string o323;
    in >> o323;
    out.setVehicleHUModel(o323);
    ::std::string o324;
    in >> o324;
    out.setVehicleHUSwBuild(o324);
    uint8 o325;
    in >> o325;
    out.setDriverSideInfo((::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration)o325);
    bool o326;
    in >> o326;
    out.setIsNativeNavSupported(o326);
    deserializeCca(in, out.getOEMICONDetailsMutable(), majorVersion);
    bool o327;
    in >> o327;
    out.setIsRotaryCtrlSupported(o327);
    uint8 o328;
    in >> o328;
    out.setFidelityType((::midw_smartphoneint_fi_types::T_e8_FidelityType)o328);
    uint16 o329;
    in >> o329;
    out.setSupportedSPITechnologiesInfo(o329);
}

void serializeCca(const ::midw_smartphoneint_fi::SetVehicleManufacturerInformationResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetVehicleManufacturerInformationResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o330;
    in >> o330;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o330);
    uint8 o331;
    in >> o331;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o331);
}

void serializeCca(const ::midw_smartphoneint_fi::SetEnvironmentDataStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getOutsideTemperature();
    out << (uint8) in.getValidTemperature();
    out << in.getBarometricPressure();
    out << (uint8) in.getValidPressure();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetEnvironmentDataStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    double o332;
    in >> o332;
    out.setOutsideTemperature(o332);
    bool o333;
    in >> o333;
    out.setValidTemperature(o333);
    double o334;
    in >> o334;
    out.setBarometricPressure(o334);
    bool o335;
    in >> o335;
    out.setValidPressure(o335);
}

void serializeCca(const ::midw_smartphoneint_fi::SetEnvironmentDataResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetEnvironmentDataResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o336;
    in >> o336;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o336);
    uint8 o337;
    in >> o337;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o337);
}

void serializeCca(const ::midw_smartphoneint_fi::GetMediaObjectAlbumArtStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getSAlbumArt();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetMediaObjectAlbumArtStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o338;
    in >> o338;
    out.setDeviceHandle(o338);
    ::std::string o339;
    in >> o339;
    out.setSAlbumArt(o339);
}

void serializeCca(const ::midw_smartphoneint_fi::GetMediaObjectAlbumArtResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o340 = static_cast<uint32>(in.getOImageData().size());
        out << o340;
        ::std::vector< uint8 >::const_iterator o341;
        for (o341 = in.getOImageData().begin(); o341 != in.getOImageData().end(); ++o341) {
            out << (*o341);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetMediaObjectAlbumArtResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o342;
        in >> o342;
        out.getOImageDataMutable().clear ();
        out.getOImageDataMutable().reserve (o342);
        for (uint32 o343 = 0; o343 < o342; o343++) {
            uint8 o344;
            in >> o344;
            out.getOImageDataMutable().push_back(o344);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::SetTechnologyPreferenceStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getNumofPreferences();
    {
        uint32 o345 = static_cast<uint32>(in.getPreferenceOrderList().size());
        out << o345;
        ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >::const_iterator o346;
        for (o346 = in.getPreferenceOrderList().begin(); o346 != in.getPreferenceOrderList().end(); ++o346) {
            out << (uint8) (*o346);
        }
    }
    out << (uint8) in.getDeviceType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetTechnologyPreferenceStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o347;
    in >> o347;
    out.setDeviceHandle(o347);
    uint16 o348;
    in >> o348;
    out.setNumofPreferences(o348);
    {
        uint32 o349;
        in >> o349;
        out.getPreferenceOrderListMutable().clear ();
        out.getPreferenceOrderListMutable().reserve (o349);
        for (uint32 o350 = 0; o350 < o349; o350++) {
            uint8 o351;
            in >> o351;
            out.getPreferenceOrderListMutable().push_back((::midw_smartphoneint_fi_types::T_e8_DeviceCategory) o351);
        }
    }
    uint8 o352;
    in >> o352;
    out.setDeviceType((::midw_smartphoneint_fi_types::T_e8_DeviceType)o352);
}

void serializeCca(const ::midw_smartphoneint_fi::SetTechnologyPreferenceResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetTechnologyPreferenceResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o353;
    in >> o353;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o353);
}

void serializeCca(const ::midw_smartphoneint_fi::GetTechnologyPreferenceStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetTechnologyPreferenceStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o354;
    in >> o354;
    out.setDeviceHandle(o354);
    uint8 o355;
    in >> o355;
    out.setDeviceType((::midw_smartphoneint_fi_types::T_e8_DeviceType)o355);
}

void serializeCca(const ::midw_smartphoneint_fi::GetTechnologyPreferenceResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getNumofPreferences();
    {
        uint32 o356 = static_cast<uint32>(in.getPreferenceOrderList().size());
        out << o356;
        ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >::const_iterator o357;
        for (o357 = in.getPreferenceOrderList().begin(); o357 != in.getPreferenceOrderList().end(); ++o357) {
            out << (uint8) (*o357);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetTechnologyPreferenceResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o358;
    in >> o358;
    out.setNumofPreferences(o358);
    {
        uint32 o359;
        in >> o359;
        out.getPreferenceOrderListMutable().clear ();
        out.getPreferenceOrderListMutable().reserve (o359);
        for (uint32 o360 = 0; o360 < o359; o360++) {
            uint8 o361;
            in >> o361;
            out.getPreferenceOrderListMutable().push_back((::midw_smartphoneint_fi_types::T_e8_DeviceCategory) o361);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::SetDeviceSelectionModeStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getDeviceSelectionMode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetDeviceSelectionModeStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o362;
    in >> o362;
    out.setDeviceSelectionMode((::midw_smartphoneint_fi_types::T_e8_DeviceSelectionMode)o362);
}

void serializeCca(const ::midw_smartphoneint_fi::SetDeviceSelectionModeResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetDeviceSelectionModeResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o363;
    in >> o363;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o363);
}

void serializeCca(const ::midw_smartphoneint_fi::GetSPIVersionInfoResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSPIVersion();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetSPIVersionInfoResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o364;
    in >> o364;
    out.setSPIVersion(o364);
}

void serializeCca(const ::midw_smartphoneint_fi::InitiateWirelessDiscoveryStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBTMACAddress();
    out << (uint8) in.getTechnology();
    out << (uint8) in.getIsKnownDevice();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::InitiateWirelessDiscoveryStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o365;
    in >> o365;
    out.setBTMACAddress(o365);
    uint8 o366;
    in >> o366;
    out.setTechnology((::midw_smartphoneint_fi_types::T_e8_DeviceCategory)o366);
    bool o367;
    in >> o367;
    out.setIsKnownDevice(o367);
}

void serializeCca(const ::midw_smartphoneint_fi::InitiateWirelessDiscoveryResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::InitiateWirelessDiscoveryResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o368;
    in >> o368;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o368);
}

void serializeCca(const ::midw_smartphoneint_fi::DeleteDeviceStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o369 = static_cast<uint32>(in.getDeviceList().size());
        out << o369;
        ::std::vector< uint32 >::const_iterator o370;
        for (o370 = in.getDeviceList().begin(); o370 != in.getDeviceList().end(); ++o370) {
            out << (*o370);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DeleteDeviceStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o371;
        in >> o371;
        out.getDeviceListMutable().clear ();
        out.getDeviceListMutable().reserve (o371);
        for (uint32 o372 = 0; o372 < o371; o372++) {
            uint32 o373;
            in >> o373;
            out.getDeviceListMutable().push_back(o373);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::DeleteDeviceResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o374 = static_cast<uint32>(in.getDeviceList().size());
        out << o374;
        ::std::vector< uint32 >::const_iterator o375;
        for (o375 = in.getDeviceList().begin(); o375 != in.getDeviceList().end(); ++o375) {
            out << (*o375);
        }
    }
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DeleteDeviceResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o376;
        in >> o376;
        out.getDeviceListMutable().clear ();
        out.getDeviceListMutable().reserve (o376);
        for (uint32 o377 = 0; o377 < o376; o377++) {
            uint32 o378;
            in >> o378;
            out.getDeviceListMutable().push_back(o378);
        }
    }
    uint8 o379;
    in >> o379;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o379);
}

void serializeCca(const ::midw_smartphoneint_fi::GetWiFiCredentialsStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBTMACAddress();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetWiFiCredentialsStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o380;
    in >> o380;
    out.setBTMACAddress(o380);
}

void serializeCca(const ::midw_smartphoneint_fi::GetWiFiCredentialsResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBTMACAddress();
    out << (uint8) in.getErrorCode();
    serializeCca(in.getAccessoryWiFiAPCredentials(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetWiFiCredentialsResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o381;
    in >> o381;
    out.setBTMACAddress(o381);
    uint8 o382;
    in >> o382;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o382);
    deserializeCca(in, out.getAccessoryWiFiAPCredentialsMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::SetETCStatusStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getETCStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetETCStatusStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o383;
    in >> o383;
    out.setETCStatus(o383);
}

void serializeCca(const ::midw_smartphoneint_fi::SetETCStatusResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetETCStatusResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o384;
    in >> o384;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o384);
}

void serializeCca(const ::midw_smartphoneint_fi::DistanceToEmptyTankStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDistanceToEmptyTank();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DistanceToEmptyTankStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    int32 o385;
    in >> o385;
    out.setDistanceToEmptyTank(o385);
}

void serializeCca(const ::midw_smartphoneint_fi::DistanceToEmptyTankResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::DistanceToEmptyTankResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o386;
    in >> o386;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o386);
    uint8 o387;
    in >> o387;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o387);
}

void serializeCca(const ::midw_smartphoneint_fi::SendLanguageSettingStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (int32) in.getLanguageSetting();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SendLanguageSettingStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    int32 o388;
    in >> o388;
    out.setLanguageSetting((::midw_smartphoneint_fi_types::T_e32_Language)o388);
}

void serializeCca(const ::midw_smartphoneint_fi::SendLanguageSettingResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SendLanguageSettingResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o389;
    in >> o389;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o389);
    uint8 o390;
    in >> o390;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o390);
}

void serializeCca(const ::midw_smartphoneint_fi::SendVehiclePowerModeStateStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getVehiclePowerModeState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SendVehiclePowerModeStateStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o391;
    in >> o391;
    out.setVehiclePowerModeState((::midw_smartphoneint_fi_types::T_e8_VehiclePowerModeState)o391);
}

void serializeCca(const ::midw_smartphoneint_fi::SendVehiclePowerModeStateResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SendVehiclePowerModeStateResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o392;
    in >> o392;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o392);
    uint8 o393;
    in >> o393;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o393);
}

void serializeCca(const ::midw_smartphoneint_fi::SendAmbientColourStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getAmbientColourData(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SendAmbientColourStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getAmbientColourDataMutable(), majorVersion);
}

void serializeCca(const ::midw_smartphoneint_fi::SendAmbientColourResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SendAmbientColourResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o394;
    in >> o394;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o394);
    uint8 o395;
    in >> o395;
    out.setErrorCode((::midw_smartphoneint_fi_types::T_e8_ErrorType)o395);
}

void serializeCca(const ::midw_smartphoneint_fi::RegisterRouteGuidanceDisplayConfigurationStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o396 = static_cast<uint32>(in.getRouteGuidanceDisplayComponents().size());
        out << o396;
        ::std::vector< ::midw_smartphoneint_fi_types::T_RouteGuidanceDisplayComponent >::const_iterator o397;
        for (o397 = in.getRouteGuidanceDisplayComponents().begin(); o397 != in.getRouteGuidanceDisplayComponents().end(); ++o397) {
            serializeCca((*o397), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::RegisterRouteGuidanceDisplayConfigurationStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o398;
        in >> o398;
        out.getRouteGuidanceDisplayComponentsMutable().clear ();
        out.getRouteGuidanceDisplayComponentsMutable().reserve (o398);
        for (uint32 o399 = 0; o399 < o398; o399++) {
            ::midw_smartphoneint_fi_types::T_RouteGuidanceDisplayComponent o400;
            deserializeCca(in, o400, majorVersion);
            out.getRouteGuidanceDisplayComponentsMutable().push_back (o400);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::RegisterRouteGuidanceDisplayConfigurationResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::RegisterRouteGuidanceDisplayConfigurationResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o401;
    in >> o401;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o401);
}

void serializeCca(const ::midw_smartphoneint_fi::StartRouteGuidanceUpdatesStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o402 = static_cast<uint32>(in.getRoutGuidanceComponentID().size());
        out << o402;
        ::std::vector< ::midw_smartphoneint_fi_types::T_e8_ComponentID >::const_iterator o403;
        for (o403 = in.getRoutGuidanceComponentID().begin(); o403 != in.getRoutGuidanceComponentID().end(); ++o403) {
            out << (uint8) (*o403);
        }
    }
    out << (uint8) in.getSourceName();
    out << (uint8) in.getSourceSupportsRouteGuidance();
    out << (uint8) in.getNeedAutoStartStopTBTUpdates();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::StartRouteGuidanceUpdatesStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o404;
        in >> o404;
        out.getRoutGuidanceComponentIDMutable().clear ();
        out.getRoutGuidanceComponentIDMutable().reserve (o404);
        for (uint32 o405 = 0; o405 < o404; o405++) {
            uint8 o406;
            in >> o406;
            out.getRoutGuidanceComponentIDMutable().push_back((::midw_smartphoneint_fi_types::T_e8_ComponentID) o406);
        }
    }
    bool o407;
    in >> o407;
    out.setSourceName(o407);
    bool o408;
    in >> o408;
    out.setSourceSupportsRouteGuidance(o408);
    bool o409;
    in >> o409;
    out.setNeedAutoStartStopTBTUpdates(o409);
}

void serializeCca(const ::midw_smartphoneint_fi::StartRouteGuidanceUpdatesResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::StartRouteGuidanceUpdatesResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o410;
    in >> o410;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o410);
}

void serializeCca(const ::midw_smartphoneint_fi::StopRouteGuidanceUpdatesStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o411 = static_cast<uint32>(in.getRoutGuidanceComponentID().size());
        out << o411;
        ::std::vector< ::midw_smartphoneint_fi_types::T_e8_ComponentID >::const_iterator o412;
        for (o412 = in.getRoutGuidanceComponentID().begin(); o412 != in.getRoutGuidanceComponentID().end(); ++o412) {
            out << (uint8) (*o412);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::StopRouteGuidanceUpdatesStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o413;
        in >> o413;
        out.getRoutGuidanceComponentIDMutable().clear ();
        out.getRoutGuidanceComponentIDMutable().reserve (o413);
        for (uint32 o414 = 0; o414 < o413; o414++) {
            uint8 o415;
            in >> o415;
            out.getRoutGuidanceComponentIDMutable().push_back((::midw_smartphoneint_fi_types::T_e8_ComponentID) o415);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::StopRouteGuidanceUpdatesResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::StopRouteGuidanceUpdatesResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o416;
    in >> o416;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o416);
}

void serializeCca(const ::midw_smartphoneint_fi::GetDeviceListStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetDeviceListStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o417;
    in >> o417;
    out.setDeviceHandle(o417);
}

void serializeCca(const ::midw_smartphoneint_fi::GetDeviceListResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getNumDevices();
    {
        uint32 o418 = static_cast<uint32>(in.getDeviceInfoList().size());
        out << o418;
        ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceDetails >::const_iterator o419;
        for (o419 = in.getDeviceInfoList().begin(); o419 != in.getDeviceInfoList().end(); ++o419) {
            serializeCca((*o419), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::GetDeviceListResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o420;
    in >> o420;
    out.setNumDevices(o420);
    {
        uint32 o421;
        in >> o421;
        out.getDeviceInfoListMutable().clear ();
        out.getDeviceInfoListMutable().reserve (o421);
        for (uint32 o422 = 0; o422 < o421; o422++) {
            ::midw_smartphoneint_fi_types::T_DeviceDetails o423;
            deserializeCca(in, o423, majorVersion);
            out.getDeviceInfoListMutable().push_back (o423);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::SetClientStateStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getClientState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetClientStateStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o424;
    in >> o424;
    out.setClientState((::midw_smartphoneint_fi_types::T_e8_ClientState)o424);
}

void serializeCca(const ::midw_smartphoneint_fi::SetClientStateResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::SetClientStateResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o425;
    in >> o425;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o425);
}

void serializeCca(const ::midw_smartphoneint_fi::RegisterKeyCodesStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o426 = static_cast<uint32>(in.getSupportedKeys().size());
        out << o426;
        ::std::vector< ::midw_smartphoneint_fi_types::T_TechnologyKeyConfig >::const_iterator o427;
        for (o427 = in.getSupportedKeys().begin(); o427 != in.getSupportedKeys().end(); ++o427) {
            serializeCca((*o427), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::RegisterKeyCodesStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o428;
        in >> o428;
        out.getSupportedKeysMutable().clear ();
        out.getSupportedKeysMutable().reserve (o428);
        for (uint32 o429 = 0; o429 < o428; o429++) {
            ::midw_smartphoneint_fi_types::T_TechnologyKeyConfig o430;
            deserializeCca(in, o430, majorVersion);
            out.getSupportedKeysMutable().push_back (o430);
        }
    }
}

void serializeCca(const ::midw_smartphoneint_fi::RegisterKeyCodesResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    {
        uint32 o431 = static_cast<uint32>(in.getUnSupportedKeys().size());
        out << o431;
        ::std::vector< ::midw_smartphoneint_fi_types::T_TechnologyKeyConfig >::const_iterator o432;
        for (o432 = in.getUnSupportedKeys().begin(); o432 != in.getUnSupportedKeys().end(); ++o432) {
            serializeCca((*o432), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_smartphoneint_fi::RegisterKeyCodesResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o433;
    in >> o433;
    out.setResponseCode((::midw_smartphoneint_fi_types::T_e8_ResponseCode)o433);
    {
        uint32 o434;
        in >> o434;
        out.getUnSupportedKeysMutable().clear ();
        out.getUnSupportedKeysMutable().reserve (o434);
        for (uint32 o435 = 0; o435 < o434; o435++) {
            ::midw_smartphoneint_fi_types::T_TechnologyKeyConfig o436;
            deserializeCca(in, o436, majorVersion);
            out.getUnSupportedKeysMutable().push_back (o436);
        }
    }
}

