#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MIDW_SMARTPHONEINT_FI_H
#define MIDW_SMARTPHONEINT_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "midw_smartphoneint_fi_types.h"
#include "midw_smartphoneint_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'midw_smartphoneint_fi'
 *
 * Fullname: Smart Phone Integration (SPI) Application Functional Interface
 *
 * Version: $Revision:   4.2  $
 *
 * Author: Dhiraj Asopa (RBEI/ECO21)
 *
 * Date: $Date:  DEC 06 2017   $
 *
 * Department: RBEI/ECO
 *
 * Title: midw_smartphoneint_fi
 *
 * <b>Description of 'midw_smartphoneint_fi':</b>
 *
 * ..
 */

namespace midw_smartphoneint_fi {

static const int SERVICE_ID = 269;

static const int FID_DeviceStatusInfo = 1;

static const int FID_AppStatusInfo = 2;

static const int FID_DAPStatusInfo = 3;

static const int FID_NotificationInfo = 4;

static const int FID_ApplicationMediaMetaData = 5;

static const int FID_DeviceDisplayContext = 6;

static const int FID_ApplicationPhoneData = 7;

static const int FID_BluetoothDeviceStatus = 8;

static const int FID_DeviceAudioContext = 9;

static const int FID_DiPOAppStatusInfo = 10;

static const int FID_SessionStatusInfo = 11;

static const int FID_BTPairingRequired = 12;

static const int FID_MLServerKeyCapabilities = 13;

static const int FID_Dial = 14;

static const int FID_MediaPlayBackTime = 15;

static const int FID_ProjectionDeviceAuthorization = 4112;

static const int FID_NavigationStatusInfo = 4113;

static const int FID_NavigationNextTurnData = 4114;

static const int FID_NavigationNextTurnDistanceData = 4115;

static const int FID_AAPNotificationEvent = 4116;

static const int FID_mySPINBluetoothVoiceRecInfo = 4117;

static const int FID_TechnologySelection = 4118;

static const int FID_WiFiCredentials = 4119;

static const int FID_TurnByTurnInfo = 4120;

static const int FID_ProjectedVideoInfo = 4121;

static const int FID_DeviceLockStatus = 4122;

static const int FID_RelativelyActiveMediaApp = 4123;

static const int FID_CarplayRouteGuidanceUpdate = 4124;

static const int FID_CarplayRouteGuidanceManeuverUpdate = 4125;

static const int FID_AAutoTurnByTurnInfo = 4126;

static const int FID_BDCLTurnByTurnInfo = 4127;

static const int FID_MLTurnByTurnInfo = 4128;

static const int FID_ApplicationPhoneCallData = 4129;

static const int FID_GetDeviceInfoList = 16;

static const int FID_SelectDevice = 17;

static const int FID_LaunchApp = 18;

static const int FID_TerminateApp = 19;

static const int FID_GetAppList = 20;

static const int FID_GetAppIconData = 21;

static const int FID_SetAppIconAttributes = 22;

static const int FID_SetDeviceUsagePreference = 23;

static const int FID_SetMLNotificationEnabledInfo = 24;

static const int FID_InvokeNotificationAction = 25;

static const int FID_GetVideoSettings = 26;

static const int FID_SetOrientationMode = 27;

static const int FID_SetScreenSize = 28;

static const int FID_SetVideoBlockingMode = 29;

static const int FID_SetAudioBlockingMode = 30;

static const int FID_SetVehicleConfiguration = 31;

static const int FID_SendTouchEvent = 32;

static const int FID_SendKeyEvent = 33;

static const int FID_SetClientCapabilities = 35;

static const int FID_AccessoryDisplayContext = 36;

static const int FID_GetDeviceUsagePreference = 38;

static const int FID_SetVehicleBTAddress = 39;

static const int FID_InvokeBluetoothDeviceAction = 41;

static const int FID_AccessoryAudioContext = 42;

static const int FID_AccessoryAppState = 43;

static const int FID_SetRegion = 44;

static const int FID_DiPORoleSwitchRequired = 45;

static const int FID_SetAccessoryDisplayContext = 46;

static const int FID_GetKeyIconData = 47;

static const int FID_SetDisplayAttributes = 48;

static const int FID_RotaryControllerEvent = 49;

static const int FID_SetAccessoryAudioContext = 50;

static const int FID_SetVehicleMovementState = 51;

static const int FID_SetFeatureRestrictions = 52;

static const int FID_VehicleMechanicalSpeed = 53;

static const int FID_SetVehicleManufacturerInformation = 54;

static const int FID_SetEnvironmentData = 55;

static const int FID_GetMediaObjectAlbumArt = 56;

static const int FID_SetTechnologyPreference = 57;

static const int FID_GetTechnologyPreference = 58;

static const int FID_SetDeviceSelectionMode = 59;

static const int FID_GetSPIVersionInfo = 60;

static const int FID_InitiateWirelessDiscovery = 61;

static const int FID_DeleteDevice = 62;

static const int FID_GetWiFiCredentials = 63;

static const int FID_SetETCStatus = 64;

static const int FID_DistanceToEmptyTank = 65;

static const int FID_SendLanguageSetting = 66;

static const int FID_SendVehiclePowerModeState = 67;

static const int FID_SendAmbientColour = 68;

static const int FID_RegisterRouteGuidanceDisplayConfiguration = 69;

static const int FID_StartRouteGuidanceUpdates = 70;

static const int FID_StopRouteGuidanceUpdates = 71;

static const int FID_GetDeviceList = 72;

static const int FID_SetClientState = 73;

static const int FID_RegisterKeyCodes = 80;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class DeviceStatusInfoStatus;

class AppStatusInfoStatus;

class DAPStatusInfoStatus;

class NotificationInfoStatus;

class ApplicationMediaMetaDataStatus;

class DeviceDisplayContextStatus;

class ApplicationPhoneDataStatus;

class BluetoothDeviceStatusStatus;

class DeviceAudioContextStatus;

class DiPOAppStatusInfoStatus;

class SessionStatusInfoStatus;

class BTPairingRequiredStatus;

class MLServerKeyCapabilitiesStatus;

class DialStatus;

class DialSet;

class MediaPlayBackTimeStatus;

class ProjectionDeviceAuthorizationStatus;

class ProjectionDeviceAuthorizationSet;

class NavigationStatusInfoStatus;

class NavigationNextTurnDataStatus;

class NavigationNextTurnDistanceDataStatus;

class AAPNotificationEventStatus;

class AAPNotificationEventSet;

class MySPINBluetoothVoiceRecInfoStatus;

class MySPINBluetoothVoiceRecInfoSet;

class TechnologySelectionStatus;

class TechnologySelectionSet;

class WiFiCredentialsStatus;

class TurnByTurnInfoStatus;

class ProjectedVideoInfoStatus;

class DeviceLockStatusStatus;

class RelativelyActiveMediaAppStatus;

class CarplayRouteGuidanceUpdateStatus;

class CarplayRouteGuidanceManeuverUpdateStatus;

class AAutoTurnByTurnInfoStatus;

class BDCLTurnByTurnInfoStatus;

class MLTurnByTurnInfoStatus;

class ApplicationPhoneCallDataStatus;

class GetDeviceInfoListResult;

class SelectDeviceStart;

class SelectDeviceResult;

class LaunchAppStart;

class LaunchAppResult;

class TerminateAppStart;

class TerminateAppResult;

class GetAppListStart;

class GetAppListResult;

class GetAppIconDataStart;

class GetAppIconDataResult;

class SetAppIconAttributesStart;

class SetAppIconAttributesResult;

class SetDeviceUsagePreferenceStart;

class SetDeviceUsagePreferenceResult;

class SetMLNotificationEnabledInfoStart;

class SetMLNotificationEnabledInfoResult;

class InvokeNotificationActionStart;

class InvokeNotificationActionResult;

class GetVideoSettingsStart;

class GetVideoSettingsResult;

class SetOrientationModeStart;

class SetOrientationModeResult;

class SetScreenSizeStart;

class SetScreenSizeResult;

class SetVideoBlockingModeStart;

class SetVideoBlockingModeResult;

class SetAudioBlockingModeStart;

class SetAudioBlockingModeResult;

class SetVehicleConfigurationStart;

class SetVehicleConfigurationResult;

class SendTouchEventStart;

class SendTouchEventResult;

class SendKeyEventStart;

class SendKeyEventResult;

class SetClientCapabilitiesStart;

class SetClientCapabilitiesResult;

class AccessoryDisplayContextStart;

class AccessoryDisplayContextResult;

class GetDeviceUsagePreferenceStart;

class GetDeviceUsagePreferenceResult;

class SetVehicleBTAddressStart;

class SetVehicleBTAddressResult;

class InvokeBluetoothDeviceActionStart;

class InvokeBluetoothDeviceActionResult;

class AccessoryAudioContextStart;

class AccessoryAudioContextResult;

class AccessoryAppStateStart;

class AccessoryAppStateResult;

class SetRegionStart;

class SetRegionResult;

class DiPORoleSwitchRequiredStart;

class DiPORoleSwitchRequiredResult;

class SetAccessoryDisplayContextStart;

class SetAccessoryDisplayContextResult;

class GetKeyIconDataStart;

class GetKeyIconDataResult;

class SetDisplayAttributesStart;

class SetDisplayAttributesResult;

class RotaryControllerEventStart;

class RotaryControllerEventResult;

class SetAccessoryAudioContextStart;

class SetAccessoryAudioContextResult;

class SetVehicleMovementStateStart;

class SetVehicleMovementStateResult;

class SetFeatureRestrictionsStart;

class SetFeatureRestrictionsResult;

class VehicleMechanicalSpeedStart;

class VehicleMechanicalSpeedResult;

class SetVehicleManufacturerInformationStart;

class SetVehicleManufacturerInformationResult;

class SetEnvironmentDataStart;

class SetEnvironmentDataResult;

class GetMediaObjectAlbumArtStart;

class GetMediaObjectAlbumArtResult;

class SetTechnologyPreferenceStart;

class SetTechnologyPreferenceResult;

class GetTechnologyPreferenceStart;

class GetTechnologyPreferenceResult;

class SetDeviceSelectionModeStart;

class SetDeviceSelectionModeResult;

class GetSPIVersionInfoResult;

class InitiateWirelessDiscoveryStart;

class InitiateWirelessDiscoveryResult;

class DeleteDeviceStart;

class DeleteDeviceResult;

class GetWiFiCredentialsStart;

class GetWiFiCredentialsResult;

class SetETCStatusStart;

class SetETCStatusResult;

class DistanceToEmptyTankStart;

class DistanceToEmptyTankResult;

class SendLanguageSettingStart;

class SendLanguageSettingResult;

class SendVehiclePowerModeStateStart;

class SendVehiclePowerModeStateResult;

class SendAmbientColourStart;

class SendAmbientColourResult;

class RegisterRouteGuidanceDisplayConfigurationStart;

class RegisterRouteGuidanceDisplayConfigurationResult;

class StartRouteGuidanceUpdatesStart;

class StartRouteGuidanceUpdatesResult;

class StopRouteGuidanceUpdatesStart;

class StopRouteGuidanceUpdatesResult;

class GetDeviceListStart;

class GetDeviceListResult;

class SetClientStateStart;

class SetClientStateResult;

class RegisterKeyCodesStart;

class RegisterKeyCodesResult;

// type definitions
/**
 * The upreg message of the property "DeviceStatusInfo"
 * It notifies the client upon device list change. The client can retrieve the detailed information of the device via the methods provided.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceStatusInfoUpReg;

/**
 * The relUpReg message of the property "DeviceStatusInfo"
 * It notifies the client upon device list change. The client can retrieve the detailed information of the device via the methods provided.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceStatusInfoRelUpReg;

/**
 * The error message of 'DeviceStatusInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusInfoError;

/**
 * The upreg message of the property "AppStatusInfo"
 * It notifies the client upon application list change of a Mirror Link device.
 * The client can retrieve the detailed information of the applications via the methods provided.
 * If a Mirror Link device is disconnected, Device Handle is set to 0xFFFF and DeviceConnectionType is set to UNKNOWN_CONNECTION.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppStatusInfoUpReg;

/**
 * The relUpReg message of the property "AppStatusInfo"
 * It notifies the client upon application list change of a Mirror Link device.
 * The client can retrieve the detailed information of the applications via the methods provided.
 * If a Mirror Link device is disconnected, Device Handle is set to 0xFFFF and DeviceConnectionType is set to UNKNOWN_CONNECTION.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppStatusInfoRelUpReg;

/**
 * The error message of 'AppStatusInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError AppStatusInfoError;

/**
 * The upreg message of the property "DAPStatusInfo"
 * Scope: Only for ML
 * It notifies the client about DAP authentication progress information for a Mirror Link device.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DAPStatusInfoUpReg;

/**
 * The relUpReg message of the property "DAPStatusInfo"
 * Scope: Only for ML
 * It notifies the client about DAP authentication progress information for a Mirror Link device.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DAPStatusInfoRelUpReg;

/**
 * The error message of 'DAPStatusInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError DAPStatusInfoError;

/**
 * The upreg message of the property "NotificationInfo"
 * Interface to provide Notification Information received from the Mirror Link server (only for Mirror Link devices).
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NotificationInfoUpReg;

/**
 * The relUpReg message of the property "NotificationInfo"
 * Interface to provide Notification Information received from the Mirror Link server (only for Mirror Link devices).
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NotificationInfoRelUpReg;

/**
 * The error message of 'NotificationInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError NotificationInfoError;

/**
 * The upreg message of the property "ApplicationMediaMetaData"
 * Scope : CarPlay, AAP, Carlife
 * Interface to notify media application metadata to the client.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ApplicationMediaMetaDataUpReg;

/**
 * The relUpReg message of the property "ApplicationMediaMetaData"
 * Scope : CarPlay, AAP, Carlife
 * Interface to notify media application metadata to the client.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ApplicationMediaMetaDataRelUpReg;

/**
 * The error message of 'ApplicationMediaMetaData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError ApplicationMediaMetaDataError;

/**
 * The upreg message of the property "DeviceDisplayContext"
 * This interface is used by native HMI and the Mirror Link/DiPO/Android Auto device to inform each other regarding the current display context. This interface is bidirectional. The parameter field will be used by HMI to inform SPI and the result field will be used by SPI to inform HMI.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceDisplayContextUpReg;

/**
 * The relUpReg message of the property "DeviceDisplayContext"
 * This interface is used by native HMI and the Mirror Link/DiPO/Android Auto device to inform each other regarding the current display context. This interface is bidirectional. The parameter field will be used by HMI to inform SPI and the result field will be used by SPI to inform HMI.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceDisplayContextRelUpReg;

/**
 * The error message of 'DeviceDisplayContext'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceDisplayContextError;

/**
 * The upreg message of the property "ApplicationPhoneData"
 * Scope : CarPlay
 * Interface to notify Phone application data like, call status, signal strength to the client.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ApplicationPhoneDataUpReg;

/**
 * The relUpReg message of the property "ApplicationPhoneData"
 * Scope : CarPlay
 * Interface to notify Phone application data like, call status, signal strength to the client.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ApplicationPhoneDataRelUpReg;

/**
 * The error message of 'ApplicationPhoneData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError ApplicationPhoneDataError;

/**
 * The upreg message of the property "BluetoothDeviceStatus"
 * Used to notify HMI when there is a device switch operation being performed between a BT and a Projection device, as a result of user action or due to device selection strategy applied by Bluetooth/SPI service.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothDeviceStatusUpReg;

/**
 * The relUpReg message of the property "BluetoothDeviceStatus"
 * Used to notify HMI when there is a device switch operation being performed between a BT and a Projection device, as a result of user action or due to device selection strategy applied by Bluetooth/SPI service.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothDeviceStatusRelUpReg;

/**
 * The error message of 'BluetoothDeviceStatus'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError BluetoothDeviceStatusError;

/**
 * The upreg message of the property "DeviceAudioContext"
 * Used to notify HMI when there is a Audio context change in the device.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceAudioContextUpReg;

/**
 * The relUpReg message of the property "DeviceAudioContext"
 * Used to notify HMI when there is a Audio context change in the device.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceAudioContextRelUpReg;

/**
 * The error message of 'DeviceAudioContext'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceAudioContextError;

/**
 * The upreg message of the property "DiPOAppStatusInfo"
 * It notifies the client upon DiPO device app state change. The client should check the status for all the specified Apps.currently 3 app states are specified.
 * According to Apple more App states are expected in future versions.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOAppStatusInfoUpReg;

/**
 * The relUpReg message of the property "DiPOAppStatusInfo"
 * It notifies the client upon DiPO device app state change. The client should check the status for all the specified Apps.currently 3 app states are specified.
 * According to Apple more App states are expected in future versions.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOAppStatusInfoRelUpReg;

/**
 * The error message of 'DiPOAppStatusInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOAppStatusInfoError;

/**
 * The upreg message of the property "SessionStatusInfo"
 * Scope: ML, CarPlay, AAP and MySPIN
 * It notifies the client about Session status information for a projected device.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SessionStatusInfoUpReg;

/**
 * The relUpReg message of the property "SessionStatusInfo"
 * Scope: ML, CarPlay, AAP and MySPIN
 * It notifies the client about Session status information for a projected device.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SessionStatusInfoRelUpReg;

/**
 * The error message of 'SessionStatusInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SessionStatusInfoError;

/**
 * The upreg message of the property "BTPairingRequired"
 * Used to notify the client if BT pairing has to be initiated.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTPairingRequiredUpReg;

/**
 * The relUpReg message of the property "BTPairingRequired"
 * Used to notify the client if BT pairing has to be initiated.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTPairingRequiredRelUpReg;

/**
 * The error message of 'BTPairingRequired'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError BTPairingRequiredError;

/**
 * The upreg message of the property "MLServerKeyCapabilities"
 * Interface to notify Server Key Capabilities to Clients.
 * Applicable only for MirrorLink device.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MLServerKeyCapabilitiesUpReg;

/**
 * The relUpReg message of the property "MLServerKeyCapabilities"
 * Interface to notify Server Key Capabilities to Clients.
 * Applicable only for MirrorLink device.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MLServerKeyCapabilitiesRelUpReg;

/**
 * The error message of 'MLServerKeyCapabilities'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError MLServerKeyCapabilitiesError;

/**
 * The upreg message of the property "Dial"
 * This interface is used by the client to inform HMI to start an outgoing call with the provided details(TelephoneNumber and DisplayInfo).
 * Currently this API is used only for MySpin technology.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DialUpReg;

/**
 * The relUpReg message of the property "Dial"
 * This interface is used by the client to inform HMI to start an outgoing call with the provided details(TelephoneNumber and DisplayInfo).
 * Currently this API is used only for MySpin technology.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DialRelUpReg;

/**
 * The error message of 'Dial'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError DialError;

/**
 * The upreg message of the property "MediaPlayBackTime"
 * Scope : CarPlay, AAP, Carlife
 * Interface to notify playback time of the current playing media song.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayBackTimeUpReg;

/**
 * The relUpReg message of the property "MediaPlayBackTime"
 * Scope : CarPlay, AAP, Carlife
 * Interface to notify playback time of the current playing media song.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaPlayBackTimeRelUpReg;

/**
 * The error message of 'MediaPlayBackTime'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaPlayBackTimeError;

/**
 * The upreg message of the property "ProjectionDeviceAuthorization"
 * Used to notify client about authorization status of projection device. Also used to change the authorization state of a device after user consent action.
 * If usage preference of projection is Enabled, client has to authorize the projection device without user consent.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProjectionDeviceAuthorizationUpReg;

/**
 * The relUpReg message of the property "ProjectionDeviceAuthorization"
 * Used to notify client about authorization status of projection device. Also used to change the authorization state of a device after user consent action.
 * If usage preference of projection is Enabled, client has to authorize the projection device without user consent.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProjectionDeviceAuthorizationRelUpReg;

/**
 * The error message of 'ProjectionDeviceAuthorization'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError ProjectionDeviceAuthorizationError;

/**
 * The upreg message of the property "NavigationStatusInfo"
 * Scope: AAP
 * Interface to update the Projection Navigation status Information(ACTIVE, INACTIVE, UNAVAILABLE) to the client.
 * -- This property is deprecated instead use TurnByTurnInfo.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NavigationStatusInfoUpReg;

/**
 * The relUpReg message of the property "NavigationStatusInfo"
 * Scope: AAP
 * Interface to update the Projection Navigation status Information(ACTIVE, INACTIVE, UNAVAILABLE) to the client.
 * -- This property is deprecated instead use TurnByTurnInfo.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NavigationStatusInfoRelUpReg;

/**
 * The error message of 'NavigationStatusInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError NavigationStatusInfoError;

/**
 * The upreg message of the property "NavigationNextTurnData"
 * Scope: AAP
 * Updates Turn-By-Turn Projection Navigation Information to the client.
 * -- This property is deprecated instead use TurnByTurnInfo.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NavigationNextTurnDataUpReg;

/**
 * The relUpReg message of the property "NavigationNextTurnData"
 * Scope: AAP
 * Updates Turn-By-Turn Projection Navigation Information to the client.
 * -- This property is deprecated instead use TurnByTurnInfo.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NavigationNextTurnDataRelUpReg;

/**
 * The error message of 'NavigationNextTurnData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError NavigationNextTurnDataError;

/**
 * The upreg message of the property "NavigationNextTurnDistanceData"
 * Scope: AAP
 * Interface to update the Projection Navigation Next Turn Distance Data to the clients.
 * -- This property is deprecated instead use TurnByTurnInfo.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NavigationNextTurnDistanceDataUpReg;

/**
 * The relUpReg message of the property "NavigationNextTurnDistanceData"
 * Scope: AAP
 * Interface to update the Projection Navigation Next Turn Distance Data to the clients.
 * -- This property is deprecated instead use TurnByTurnInfo.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NavigationNextTurnDistanceDataRelUpReg;

/**
 * The error message of 'NavigationNextTurnDistanceData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError NavigationNextTurnDistanceDataError;

/**
 * The upreg message of the property "AAPNotificationEvent"
 * Scope: AAP
 * Interface to provide details of the notification received from the projection device
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AAPNotificationEventUpReg;

/**
 * The relUpReg message of the property "AAPNotificationEvent"
 * Scope: AAP
 * Interface to provide details of the notification received from the projection device
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AAPNotificationEventRelUpReg;

/**
 * The error message of 'AAPNotificationEvent'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError AAPNotificationEventError;

/**
 * The upreg message of the property "mySPINBluetoothVoiceRecInfo"
 * This interface is used for mySPIN VR for Android Phones to inform HMI
 * a) If Bluetooth VR session can be started based on BT Match Status
 * b) The current request to process w.r.t BT Voice Recognition
 *
 * HMI should use this interface to set the response w.r.t the request made by SPI.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MySPINBluetoothVoiceRecInfoUpReg;

/**
 * The relUpReg message of the property "mySPINBluetoothVoiceRecInfo"
 * This interface is used for mySPIN VR for Android Phones to inform HMI
 * a) If Bluetooth VR session can be started based on BT Match Status
 * b) The current request to process w.r.t BT Voice Recognition
 *
 * HMI should use this interface to set the response w.r.t the request made by SPI.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MySPINBluetoothVoiceRecInfoRelUpReg;

/**
 * The error message of 'mySPINBluetoothVoiceRecInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError MySPINBluetoothVoiceRecInfoError;

/**
 * The upreg message of the property "TechnologySelection"
 * Used to notify client about device connection when the device usage preference setting is USER_CONF_REQD.
 * The client can choose the required technology for selection
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TechnologySelectionUpReg;

/**
 * The relUpReg message of the property "TechnologySelection"
 * Used to notify client about device connection when the device usage preference setting is USER_CONF_REQD.
 * The client can choose the required technology for selection
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TechnologySelectionRelUpReg;

/**
 * The error message of 'TechnologySelection'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError TechnologySelectionError;

/**
 * The get message of the property "WiFiCredentials"
 * Scope: Carplay over wireless for now.
 * Interface to get the WiFi Credentials of the Access Point.
 * Provide WiFi credentials to the requested client
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WiFiCredentialsGet;

/**
 * The upreg message of the property "WiFiCredentials"
 * Scope: Carplay over wireless for now.
 * Interface to get the WiFi Credentials of the Access Point.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WiFiCredentialsUpReg;

/**
 * The relUpReg message of the property "WiFiCredentials"
 * Scope: Carplay over wireless for now.
 * Interface to get the WiFi Credentials of the Access Point.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WiFiCredentialsRelUpReg;

/**
 * The error message of 'WiFiCredentials'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError WiFiCredentialsError;

/**
 * The upreg message of the property "TurnByTurnInfo"
 * Obsolete:
 * Instead use CarplayRouteGuidanceUpdate, AAutoTurnByTurnInfo, BDCLTurnByTurnInfo and MLTurnByTurnInfo respectively for CarPlay, Androidauto, Baidu, Mirrorlink
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TurnByTurnInfoUpReg;

/**
 * The relUpReg message of the property "TurnByTurnInfo"
 * Obsolete:
 * Instead use CarplayRouteGuidanceUpdate, AAutoTurnByTurnInfo, BDCLTurnByTurnInfo and MLTurnByTurnInfo respectively for CarPlay, Androidauto, Baidu, Mirrorlink
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TurnByTurnInfoRelUpReg;

/**
 * The error message of 'TurnByTurnInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError TurnByTurnInfoError;

/**
 * The upreg message of the property "ProjectedVideoInfo"
 * Scope: AAP, Carlife
 * Provides information about the attributes of the video about to be rendered on the display once projection technology has chosen a display resolution. This information can be
 * used by HMI to position/ rescale the video as per the UI requirements.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProjectedVideoInfoUpReg;

/**
 * The relUpReg message of the property "ProjectedVideoInfo"
 * Scope: AAP, Carlife
 * Provides information about the attributes of the video about to be rendered on the display once projection technology has chosen a display resolution. This information can be
 * used by HMI to position/ rescale the video as per the UI requirements.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProjectedVideoInfoRelUpReg;

/**
 * The error message of 'ProjectedVideoInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError ProjectedVideoInfoError;

/**
 * The upreg message of the property "DeviceLockStatus"
 * Used to notify the HMI if Mobile Device has Enabled/Disabled Device Lock.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceLockStatusUpReg;

/**
 * The relUpReg message of the property "DeviceLockStatus"
 * Used to notify the HMI if Mobile Device has Enabled/Disabled Device Lock.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceLockStatusRelUpReg;

/**
 * The error message of 'DeviceLockStatus'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceLockStatusError;

/**
 * The upreg message of the property "RelativelyActiveMediaApp"
 * Scope: MirrorLink.
 * Used to notify the HMI regarding the relatively active media app among online music(APP_MEDIA_MUSIC)/online radio(APP_MEDIA)/VIDEO/GAMING/IMAGE
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RelativelyActiveMediaAppUpReg;

/**
 * The relUpReg message of the property "RelativelyActiveMediaApp"
 * Scope: MirrorLink.
 * Used to notify the HMI regarding the relatively active media app among online music(APP_MEDIA_MUSIC)/online radio(APP_MEDIA)/VIDEO/GAMING/IMAGE
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RelativelyActiveMediaAppRelUpReg;

/**
 * The error message of 'RelativelyActiveMediaApp'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError RelativelyActiveMediaAppError;

/**
 * The upreg message of the property "CarplayRouteGuidanceUpdate"
 * Updates Carplay Turn-By-Turn Route Guidance update to the client.
 * The client have to cache the data and display the updated data by checking the available flag.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CarplayRouteGuidanceUpdateUpReg;

/**
 * The relUpReg message of the property "CarplayRouteGuidanceUpdate"
 * Updates Carplay Turn-By-Turn Route Guidance update to the client.
 * The client have to cache the data and display the updated data by checking the available flag.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CarplayRouteGuidanceUpdateRelUpReg;

/**
 * The error message of 'CarplayRouteGuidanceUpdate'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError CarplayRouteGuidanceUpdateError;

/**
 * The upreg message of the property "CarplayRouteGuidanceManeuverUpdate"
 * Updates Carplay Turn-By-Turn Route Guidance Maneuver update to the client.
 * The client have to cache the data and display the updated data by checking the available flag.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CarplayRouteGuidanceManeuverUpdateUpReg;

/**
 * The relUpReg message of the property "CarplayRouteGuidanceManeuverUpdate"
 * Updates Carplay Turn-By-Turn Route Guidance Maneuver update to the client.
 * The client have to cache the data and display the updated data by checking the available flag.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CarplayRouteGuidanceManeuverUpdateRelUpReg;

/**
 * The error message of 'CarplayRouteGuidanceManeuverUpdate'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError CarplayRouteGuidanceManeuverUpdateError;

/**
 * The upreg message of the property "AAutoTurnByTurnInfo"
 * Updates Android Auto Turn-By-Turn Projection Navigation Information to the client.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AAutoTurnByTurnInfoUpReg;

/**
 * The relUpReg message of the property "AAutoTurnByTurnInfo"
 * Updates Android Auto Turn-By-Turn Projection Navigation Information to the client.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AAutoTurnByTurnInfoRelUpReg;

/**
 * The error message of 'AAutoTurnByTurnInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError AAutoTurnByTurnInfoError;

/**
 * The upreg message of the property "BDCLTurnByTurnInfo"
 * Updates Baidu Carlife Turn-By-Turn Projection Navigation Information to the client.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BDCLTurnByTurnInfoUpReg;

/**
 * The relUpReg message of the property "BDCLTurnByTurnInfo"
 * Updates Baidu Carlife Turn-By-Turn Projection Navigation Information to the client.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BDCLTurnByTurnInfoRelUpReg;

/**
 * The error message of 'BDCLTurnByTurnInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError BDCLTurnByTurnInfoError;

/**
 * The upreg message of the property "MLTurnByTurnInfo"
 * Updates Mirrorlink Turn-By-Turn Projection Navigation Information to the client.
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MLTurnByTurnInfoUpReg;

/**
 * The relUpReg message of the property "MLTurnByTurnInfo"
 * Updates Mirrorlink Turn-By-Turn Projection Navigation Information to the client.
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MLTurnByTurnInfoRelUpReg;

/**
 * The error message of 'MLTurnByTurnInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError MLTurnByTurnInfoError;

/**
 * The upreg message of the property "ApplicationPhoneCallData"
 * Scope : CarPlay
 * Interface to notify Phonecall data like phone number, call progress in secs, call direction, etc
 * The caller is added to the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ApplicationPhoneCallDataUpReg;

/**
 * The relUpReg message of the property "ApplicationPhoneCallData"
 * Scope : CarPlay
 * Interface to notify Phonecall data like phone number, call progress in secs, call direction, etc
 * The caller is removed from the list of registered clients whenever SPI Service receives this opcode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ApplicationPhoneCallDataRelUpReg;

/**
 * The error message of 'ApplicationPhoneCallData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError ApplicationPhoneCallDataError;

/**
 * The start message of the method "GetDeviceInfoList"
 * It provides a list of connected devices and device history with the information for each device.
 * This method is deprecated instead use GetDeviceList.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetDeviceInfoListStart;

/**
 * The abort error message of the method "GetDeviceInfoList"
 * It provides a list of connected devices and device history with the information for each device.
 * This method is deprecated instead use GetDeviceList.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDeviceInfoListAbortError;

/**
 * The error message of 'GetDeviceInfoList'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDeviceInfoListError;

/**
 * The abort error message of the method "SelectDevice"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * It provides a mechanism to select a device from SPI device List to establish a session.
 */
typedef ::asf::cca::CcaTypes::DefaultError SelectDeviceAbortError;

/**
 * The error message of 'SelectDevice'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SelectDeviceError;

/**
 * The abort error message of the method "LaunchApp"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * It launches a remote application from the selected device
 */
typedef ::asf::cca::CcaTypes::DefaultError LaunchAppAbortError;

/**
 * The error message of 'LaunchApp'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError LaunchAppError;

/**
 * The abort error message of the method "TerminateApp"
 * Scope: Only for ML
 * It terminates the remote application running on the Mirror Link device.
 */
typedef ::asf::cca::CcaTypes::DefaultError TerminateAppAbortError;

/**
 * The error message of 'TerminateApp'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError TerminateAppError;

/**
 * The abort error message of the method "GetAppList"
 * Scope: Only for ML
 * It retrieves list of supported applications for the Device Handle provided.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAppListAbortError;

/**
 * The error message of 'GetAppList'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAppListError;

/**
 * The abort error message of the method "GetAppIconData"
 * Scope: Only for ML
 * It retrieves icon data referenced by the icon URL provided in the application list.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAppIconDataAbortError;

/**
 * The error message of 'GetAppIconData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAppIconDataError;

/**
 * The abort error message of the method "SetAppIconAttributes"
 * Scope: Only for ML
 * It sets application icon attributes for retrieval of application icons for a Mirror Link device.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAppIconAttributesAbortError;

/**
 * The error message of 'SetAppIconAttributes'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAppIconAttributesError;

/**
 * The abort error message of the method "SetDeviceUsagePreference"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * Interface to set the preference for the usage of the connected device.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDeviceUsagePreferenceAbortError;

/**
 * The error message of 'SetDeviceUsagePreference'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDeviceUsagePreferenceError;

/**
 * The abort error message of the method "SetMLNotificationEnabledInfo"
 * Scope: Only for ML
 * Interface to set the device notification preference for applications.
 * If notification for all the applications has to be:
 * Enabled - Set NumNotificationEnableList to 0xFF and NotificationEnableList should be empty.
 * Disabled - Set NumNotificationEnableList to 0x00 and NotificationEnableList should be empty.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetMLNotificationEnabledInfoAbortError;

/**
 * The error message of 'SetMLNotificationEnabledInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetMLNotificationEnabledInfoError;

/**
 * The abort error message of the method "InvokeNotificationAction"
 * Scope: Only ML
 * Interface to invoke the respective action for the received Notification Event.
 */
typedef ::asf::cca::CcaTypes::DefaultError InvokeNotificationActionAbortError;

/**
 * The error message of 'InvokeNotificationAction'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError InvokeNotificationActionError;

/**
 * The abort error message of the method "GetVideoSettings"
 * It provides current Video Settings.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetVideoSettingsAbortError;

/**
 * The error message of 'GetVideoSettings'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetVideoSettingsError;

/**
 * The abort error message of the method "SetOrientationMode"
 * Interface to set the orientation mode of the projected display.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetOrientationModeAbortError;

/**
 * The error message of 'SetOrientationMode'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetOrientationModeError;

/**
 * The abort error message of the method "SetScreenSize"
 * Interface to set the screen size of Head Unit.
 * -- This method is deprecated instead use SetDisplayAttributes.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetScreenSizeAbortError;

/**
 * The error message of 'SetScreenSize'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetScreenSizeError;

/**
 * The abort error message of the method "SetVideoBlockingMode"
 * Scope: Only for ML, for other technologies use SetAccessoryDisplayContext
 * Interface to set the display blocking mode.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVideoBlockingModeAbortError;

/**
 * The error message of 'SetVideoBlockingMode'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVideoBlockingModeError;

/**
 * The abort error message of the method "SetAudioBlockingMode"
 * Scope: Only for ML
 * Interface to set the audio blocking mode.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAudioBlockingModeAbortError;

/**
 * The error message of 'SetAudioBlockingMode'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAudioBlockingModeError;

/**
 * The abort error message of the method "SetVehicleConfiguration"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * Interface to set the Vehicle configurations.
 * Use method SetVehicleMovementState to provide Park/Drive Mode Info.
 * The Drive or park mode information is deprecated from T_e8_Vehicle_Configuration.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVehicleConfigurationAbortError;

/**
 * The error message of 'SetVehicleConfiguration'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVehicleConfigurationError;

/**
 * The abort error message of the method "SendTouchEvent"
 * Interface to set the Touch or Pointer events.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendTouchEventAbortError;

/**
 * The error message of 'SendTouchEvent'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendTouchEventError;

/**
 * The abort error message of the method "SendKeyEvent"
 * Interface to set the Touch or Pointer events.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendKeyEventAbortError;

/**
 * The error message of 'SendKeyEvent'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendKeyEventError;

/**
 * The abort error message of the method "SetClientCapabilities"
 * Scope : only for ML
 * Interface to set client capabilities.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetClientCapabilitiesAbortError;

/**
 * The error message of 'SetClientCapabilities'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetClientCapabilitiesError;

/**
 * The abort error message of the method "AccessoryDisplayContext"
 * This interface is used by the client to inform the DiPO device about its current display context.
 * --This method is deprecated, instead use SetAccessoryDisplayContext
 */
typedef ::asf::cca::CcaTypes::DefaultError AccessoryDisplayContextAbortError;

/**
 * The error message of 'AccessoryDisplayContext'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError AccessoryDisplayContextError;

/**
 * The abort error message of the method "GetDeviceUsagePreference"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * Interface to get the preference for the usage of the connected devices device during startup.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDeviceUsagePreferenceAbortError;

/**
 * The error message of 'GetDeviceUsagePreference'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDeviceUsagePreferenceError;

/**
 * The abort error message of the method "SetVehicleBTAddress"
 * Interface to set the vehicle Bluetooth address.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVehicleBTAddressAbortError;

/**
 * The error message of 'SetVehicleBTAddress'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVehicleBTAddressError;

/**
 * The abort error message of the method "InvokeBluetoothDeviceAction"
 * Interface to inform SPI about user's selected action for a device switch operation between a BT and a Projection device.
 */
typedef ::asf::cca::CcaTypes::DefaultError InvokeBluetoothDeviceActionAbortError;

/**
 * The error message of 'InvokeBluetoothDeviceAction'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError InvokeBluetoothDeviceActionError;

/**
 * The abort error message of the method "AccessoryAudioContext"
 * This interface is used by the client to inform the DiPO device about its current Audio context.
 * This interface is deprecated. Use SetAccessoryAudioContext to provide Audio context information.
 */
typedef ::asf::cca::CcaTypes::DefaultError AccessoryAudioContextAbortError;

/**
 * The error message of 'AccessoryAudioContext'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError AccessoryAudioContextError;

/**
 * The abort error message of the method "AccessoryAppState"
 * Scope: Dipo- for speech, Phone and Navigation states, AAP - only Navigation state
 * This interface is used by the client to inform to the connected device about the HU application states
 */
typedef ::asf::cca::CcaTypes::DefaultError AccessoryAppStateAbortError;

/**
 * The error message of 'AccessoryAppState'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError AccessoryAppStateError;

/**
 * The abort error message of the method "SetRegion"
 * Interface to inform SPI about which region guidelines should be followed to check the application
 * certification.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetRegionAbortError;

/**
 * The error message of 'SetRegion'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetRegionError;

/**
 * The abort error message of the method "DiPORoleSwitchRequired"
 * Scope : Carplay, Carlife, Myspin
 * Interface to check whether an automatic role switch is required for the currently connected apple device.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORoleSwitchRequiredAbortError;

/**
 * The error message of 'DiPORoleSwitchRequired'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORoleSwitchRequiredError;

/**
 * The abort error message of the method "SetAccessoryDisplayContext"
 * Scope : ML, carPlay, AAP, MySPIN, Carlife.
 * This interface is used by the client to inform the projection device about Head Units current display context. And whenever Head Unit wants to request for the display resource.
 * The video resource management can either be done by HMI(SPI's client) or by SPI service. Normally it is SPI service responsibility.
 * If for what ever reason, HMI have to do video resource  management, then HMI should populate parameter "DisplayConstraintInfo"
 * Otherwise, if it is SPI service responsibility, HMI should populate parameter "DisplayContextInfo".
 * HMI should populate parameter "ContextResponsibility", based on which SPI service will know whether it is SPI or HMI responsibility.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAccessoryDisplayContextAbortError;

/**
 * The error message of 'SetAccessoryDisplayContext'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAccessoryDisplayContextError;

/**
 * The abort error message of the method "GetKeyIconData"
 * Scope : Only for ML
 * It retrieves key icon data referenced by the icon URL provided in the XDeviceKeysList.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetKeyIconDataAbortError;

/**
 * The error message of 'GetKeyIconData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetKeyIconDataError;

/**
 * The abort error message of the method "SetDisplayAttributes"
 * Scope : ML, carPlay, AAP, MySPIN, Carlife.
 * Interface to set the different display attributes of the HU. Normally these setting can also be read by SPI through KDS/diagnosis.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDisplayAttributesAbortError;

/**
 * The error message of 'SetDisplayAttributes'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDisplayAttributesError;

/**
 * The abort error message of the method "RotaryControllerEvent"
 * Interface to send Rotary Controller Events when any projection session is active.
 * It should be called with nonzero controller Delta Counts which indicate a movement of the rotary controller by the user.
 */
typedef ::asf::cca::CcaTypes::DefaultError RotaryControllerEventAbortError;

/**
 * The error message of 'RotaryControllerEvent'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError RotaryControllerEventError;

/**
 * The abort error message of the method "SetAccessoryAudioContext"
 * Scope : ML, carPlay, AAP, MySPIN, Carlife.
 * This interface is used by the HU to inform the projection device about its current Audio context.
 * If projection session is not active set the DeviceHandle to 0xFFFFFFFF.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAccessoryAudioContextAbortError;

/**
 * The error message of 'SetAccessoryAudioContext'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAccessoryAudioContextError;

/**
 * The abort error message of the method "SetVehicleMovementState"
 * This interface is used by the HU to inform the projection device about vehicle movement state.
 * Client should provide this information irrespective of projection session state.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVehicleMovementStateAbortError;

/**
 * The error message of 'SetVehicleMovementState'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVehicleMovementStateError;

/**
 * The abort error message of the method "SetFeatureRestrictions"
 * This interface is used by the HU to inform the projection device the feature restrictions to be applied when vehicle is in Park/Drive Mode.
 * Client should set the restrictions as soon as SPI service is up and running.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFeatureRestrictionsAbortError;

/**
 * The error message of 'SetFeatureRestrictions'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFeatureRestrictionsError;

/**
 * The abort error message of the method "VehicleMechanicalSpeed"
 * Scope: AAP, CarPlay, Carlife.
 * This interface is used by the client to update the vehicle mechanical speed that is derived from non GPS sources(i.e from wheels).
 * This data needs to be sent only when device is selected and speed data is changed, SPI will take care of sending the data at the required rate to the devices.
 */
typedef ::asf::cca::CcaTypes::DefaultError VehicleMechanicalSpeedAbortError;

/**
 * The error message of 'VehicleMechanicalSpeed'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError VehicleMechanicalSpeedError;

/**
 * The abort error message of the method "SetVehicleManufacturerInformation"
 * This interface is used by the client to update the various vehicle information.
 * Please note some information are mandatory that needs to be provided by the client.
 * Client should populate this information as soon as SPI service is available.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVehicleManufacturerInformationAbortError;

/**
 * The error message of 'SetVehicleManufacturerInformation'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVehicleManufacturerInformationError;

/**
 * The abort error message of the method "SetEnvironmentData"
 * Scope : AAP
 * This method is used to update the Outside Temperature and the Barometric Pressure to the Phone.
 * HMI needs to update this when SPI process becomes active and whenever there is a change either in Temperature or Pressure.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetEnvironmentDataAbortError;

/**
 * The error message of 'SetEnvironmentData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetEnvironmentDataError;

/**
 * The abort error message of the method "GetMediaObjectAlbumArt"
 * Scope : Only for CarPlay.
 * For AAP, Carlife : It is populated as part of Applicationmetadata itself
 *
 * The GetMediaObjectAlbumArt method is called to retrieve the album art
 * image, if it exists, for a particular media object. The image is returned
 * in a MIME-typed image format and size of image will be as informed in Applicationmetadata.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetMediaObjectAlbumArtAbortError;

/**
 * The error message of 'GetMediaObjectAlbumArt'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetMediaObjectAlbumArtError;

/**
 * The abort error message of the method "SetTechnologyPreference"
 * Scope: ML, Android Auto, Carlife.
 * This method is valid only if AutoSelect is enabled in SPI service (through policy), if it is not enabled this preference will not have any impact.
 * This interface can be used to set the SPI technology preference for the Mobile devices for successive connections,
 * if the device supports more than one SPI technology like Mirrorlink, Android Auto.
 * Based on this information, SPI service will decide(only if Auto select is enabled in SPI policy)to switch the device to particular technology and auto select, when the phone is connected to HMI. If preference order list is empty, than Android Auto will be first technology of preference.
 * Currently only first item in the list "PreferenceOrderList" is considered, if the selection fails than by default other technology would be preferred e.g If AAP is first preferred technology, if it fails than Mirror Link would be select.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetTechnologyPreferenceAbortError;

/**
 * The error message of 'SetTechnologyPreference'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetTechnologyPreferenceError;

/**
 * The abort error message of the method "GetTechnologyPreference"
 * Scope: ML, Android Auto, Carlife.
 * Interface to get the SPI technology preference last set. Can be used on start up to restore settings.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTechnologyPreferenceAbortError;

/**
 * The error message of 'GetTechnologyPreference'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTechnologyPreferenceError;

/**
 * The abort error message of the method "SetDeviceSelectionMode"
 * Interface to set the Device selection mode. Can be used to switch device between automatic and manual modes.
 * The selection mode will be applicable on successive device connections.
 * This value will be persistently stored by service.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDeviceSelectionModeAbortError;

/**
 * The error message of 'SetDeviceSelectionMode'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDeviceSelectionModeError;

/**
 * The start message of the method "GetSPIVersionInfo"
 * Interface to get the SPI Version Info.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetSPIVersionInfoStart;

/**
 * The abort error message of the method "GetSPIVersionInfo"
 * Interface to get the SPI Version Info.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetSPIVersionInfoAbortError;

/**
 * The error message of 'GetSPIVersionInfo'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetSPIVersionInfoError;

/**
 * The abort error message of the method "InitiateWirelessDiscovery"
 * Scope: Carplay over wireless for now.
 * Interface to initiate SPI wireless device discovery.
 * This is used to estbalish wireless session, if a valid device is available.
 */
typedef ::asf::cca::CcaTypes::DefaultError InitiateWirelessDiscoveryAbortError;

/**
 * The error message of 'InitiateWirelessDiscovery'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError InitiateWirelessDiscoveryError;

/**
 * The abort error message of the method "DeleteDevice"
 * Interface to delete device permanently from SPI device list
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteDeviceAbortError;

/**
 * The error message of 'DeleteDevice'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteDeviceError;

/**
 * The abort error message of the method "GetWiFiCredentials"
 * Interface to get the WiFi Credentials for Wireless.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetWiFiCredentialsAbortError;

/**
 * The error message of 'GetWiFiCredentials'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetWiFiCredentialsError;

/**
 * The abort error message of the method "SetETCStatus"
 * Scope: CarPlay and AAP
 * Interface to set the Electronic Toll Collection (ETC) enabling status.
 * If the ETC feature is enabled (in the head unit restrictions), this method can be used to enable or disable the status while CarPlay session is active.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetETCStatusAbortError;

/**
 * The error message of 'SetETCStatus'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetETCStatusError;

/**
 * The abort error message of the method "DistanceToEmptyTank"
 * Scope: MirrorLink.
 * DistanceToEmptyTank Interface determines the distance that can be travelled by the vehicle with
 * the amount of fuel left in the vehicle. Suppose a vehicle travels 60km with one litre of fuel present
 * and now the vehicle is left with 3 litres of fuel in the tank then the DistanceToEmptyTank  is 180km.
 * This interface is used by the client to update the distance to empty tank that is derived from vehicle CAN interface.
 * This data needs to be sent only when device is selected and DistanceToEmptyTank data is changed, SPI will take care of
 * sending the data at the required rate to the devices.
 * Valid Data Range(DistanceToEmptyTank) - 0 to 0x7FFFFFFF i.e;2,147,483,647 km
 * If DistanceToEmptyTank = 0xFFFFFFFF, then it is invalid data
 */
typedef ::asf::cca::CcaTypes::DefaultError DistanceToEmptyTankAbortError;

/**
 * The error message of 'DistanceToEmptyTank'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError DistanceToEmptyTankError;

/**
 * The abort error message of the method "SendLanguageSetting"
 * Scope: MirrorLink.
 * Interface to send the system language information.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendLanguageSettingAbortError;

/**
 * The error message of 'SendLanguageSetting'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendLanguageSettingError;

/**
 * The abort error message of the method "SendVehiclePowerModeState"
 * Scope: MirrorLink.
 * VehiclePowerMode Interface determines the position of the ignition switch. It represents vehicle power mode state.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendVehiclePowerModeStateAbortError;

/**
 * The error message of 'SendVehiclePowerModeState'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendVehiclePowerModeStateError;

/**
 * The abort error message of the method "SendAmbientColour"
 * Scope: MirrorLink.
 * It is used to send ambient colour details of the HU like Red, Green, Blue, Alpha etc. for a Mirror Link device.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendAmbientColourAbortError;

/**
 * The error message of 'SendAmbientColour'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendAmbientColourError;

/**
 * The abort error message of the method "RegisterRouteGuidanceDisplayConfiguration"
 * Scope: CarPlay
 * This interface is to register various display components for projecting route guidance on multiple displays.
 * Based on the different componentID and its pararmeters device is provides updates accordingly.
 * Hence, clients to check what is the widest charater length that is possible to display before register for the devices.
 * Information from this method will be used to inform device on RouteGuidanceDisplayComponent in iAP2 identification.
 * Note: ID's allocated are of static ID, which means clients should take care of having non overlapping IDs
 */
typedef ::asf::cca::CcaTypes::DefaultError RegisterRouteGuidanceDisplayConfigurationAbortError;

/**
 * The error message of 'RegisterRouteGuidanceDisplayConfiguration'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError RegisterRouteGuidanceDisplayConfigurationError;

/**
 * The abort error message of the method "StartRouteGuidanceUpdates"
 * Scope: CarPlay
 * StartRouteGuidanceUpdate must be sent when accessory is ready to display navigation route guidance.
 * To get updates for RouteGuidance, client should register for properties CarplayRouteGuidanceUpdate and CarplayRouteGuidanceManeuverUpdate
 */
typedef ::asf::cca::CcaTypes::DefaultError StartRouteGuidanceUpdatesAbortError;

/**
 * The error message of 'StartRouteGuidanceUpdates'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError StartRouteGuidanceUpdatesError;

/**
 * The abort error message of the method "StopRouteGuidanceUpdates"
 * Scope: CarPlay
 * StopRouteGuidanceUpdate must be sent when navigation route guidance is not being displayed by the accessory.
 */
typedef ::asf::cca::CcaTypes::DefaultError StopRouteGuidanceUpdatesAbortError;

/**
 * The error message of 'StopRouteGuidanceUpdates'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError StopRouteGuidanceUpdatesError;

/**
 * The abort error message of the method "GetDeviceList"
 * It provides a list of connected devices and device history with the information for each device.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDeviceListAbortError;

/**
 * The error message of 'GetDeviceList'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDeviceListError;

/**
 * The abort error message of the method "SetClientState"
 * Scope: For all technologies
 * This method is used as a sync to know if HMI service is available and updated all the various current states e.g RVC to SPI core.
 * Based on this state, SPI service will start various other opearation e.g Device selection
 * If there are muiltiple clients( e.g HMI/Meter) in the system, Master client should consolidate the information from various clients and should inform through this method overall state to SPI service.
 * Important: As this is a synchorization mechanism, in order avoid critical issues(e.g devices are not getting identified) if this particular information is missing, SPI core will start timer x after SPI service is started.
 * If Client have NOT set the INITIALIZED state within timer x, SPI service will continue this operation e.g device selection.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetClientStateAbortError;

/**
 * The error message of 'SetClientState'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetClientStateError;

/**
 * The abort error message of the method "RegisterKeyCodes"
 * scope: CarPlay and AndroidAuto. For Mirrorlink, use SetClientCapabilities to register keys.
 * Currently for other technologies i.e. BDCL, MysPIN, OnCar it is not needed to register keys in advance.
 * RegisterKeyCodes method registers supported hard(physical keys e.g SWC keys) and soft keys( e.g Touch controls).
 * Publishing supported keys during session establishment is mandated by AA and CP spec.
 * The parameter is a list of struct T_TechnologyKeyConfig. Clients has to fill the list with device category and list of keys supported for that category.
 * Please see document "SPI_Supported_Keys.xlsx" for technology location at docushare
 * https://hi-dms.de.bosch.com/docushare/dsweb/ServicesLib/URL-19781/View
 *
 * Important points:
 * 1) SPI will be supporting multiple clients for registering keycodes.
 * 2) SPI will merge the keycodes sent by different clients, i.e. if client 1 sends m keys and client 2 sends n keys, SPI will maintain m+n keys.
 * 3) SPI will clear datapool for keycodes during all kinds of defset. It is expected that Clients needs to register keycodes again after defset,
 * otherwise default keys would be sent to phone.
 * 4) Clients(atleast one client in multiple client system) have to indicate that whether client is having any keys or not.
 * Otherwise default keys would be populated.
 * 5) If clients want to indicate that no key is supported for a specified device category,
 * they need to call registerkeycode with an empty keycode list for that device category.
 * 6) Any keys that are published and not demonstrable during certification process leads to certification issues. Hence, client to check and populate based on the requirements
 */
typedef ::asf::cca::CcaTypes::DefaultError RegisterKeyCodesAbortError;

/**
 * The error message of 'RegisterKeyCodes'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError RegisterKeyCodesError;


/**
 * The status message of the property "DeviceStatusInfo"
 * It notifies the client upon device list change. The client can retrieve the detailed information of the device via the methods provided.
 */
class DeviceStatusInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusInfoStatus (const DeviceStatusInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusInfoStatus (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType DeviceConnectionType_, ::midw_smartphoneint_fi_types::T_e8_DeviceStatusInfo DeviceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusInfoStatus();

    /**
     * Assignment operator
     */
    inline DeviceStatusInfoStatus& operator = (const DeviceStatusInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceConnectionType"

    static const int kDeviceConnectionType = 1;

    /**
     * Clears the field "DeviceConnectionType".
     *
     * The field will be set to its default value. The hasDeviceConnectionType()
     * method will return false.
     */
    inline void clearDeviceConnectionType();

    /**
     * Checks whether the field "DeviceConnectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceConnectionType()). Otherwise it will return false.
     */
    inline bool hasDeviceConnectionType () const;

    /**
     * Returns the value of the member "DeviceConnectionType".
     *
     * Identifies the Connection Type.
     *
     * @return The value of the field "DeviceConnectionType"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType getDeviceConnectionType () const;

    /**
     * Sets the value of the member "DeviceConnectionType".
     *
     * Identifies the Connection Type.
     *
     * @param DeviceConnectionType The value which will be set
     */
    inline void setDeviceConnectionType (::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType DeviceConnectionType_);

    // API of field "DeviceStatus"

    static const int kDeviceStatus = 2;

    /**
     * Clears the field "DeviceStatus".
     *
     * The field will be set to its default value. The hasDeviceStatus()
     * method will return false.
     */
    inline void clearDeviceStatus();

    /**
     * Checks whether the field "DeviceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatus()). Otherwise it will return false.
     */
    inline bool hasDeviceStatus () const;

    /**
     * Returns the value of the member "DeviceStatus".
     *
     * Provides Device Status Information.
     *
     * @return The value of the field "DeviceStatus"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceStatusInfo getDeviceStatus () const;

    /**
     * Sets the value of the member "DeviceStatus".
     *
     * Provides Device Status Information.
     *
     * @param DeviceStatus The value which will be set
     */
    inline void setDeviceStatus (::midw_smartphoneint_fi_types::T_e8_DeviceStatusInfo DeviceStatus_);

    static const DeviceStatusInfoStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceConnectionType ();

    inline void clear_has_DeviceConnectionType ();

    inline void set_has_DeviceStatus ();

    inline void clear_has_DeviceStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType _DeviceConnectionType;

    ::midw_smartphoneint_fi_types::T_e8_DeviceStatusInfo _DeviceStatus;

};

/**
 * The status message of the property "AppStatusInfo"
 * It notifies the client upon application list change of a Mirror Link device.
 * The client can retrieve the detailed information of the applications via the methods provided.
 * If a Mirror Link device is disconnected, Device Handle is set to 0xFFFF and DeviceConnectionType is set to UNKNOWN_CONNECTION.
 */
class AppStatusInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AppStatusInfoStatus ();

    /**
     * Copy constructor
     */
    inline  AppStatusInfoStatus (const AppStatusInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AppStatusInfoStatus (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType DeviceConnectionType_, ::midw_smartphoneint_fi_types::T_e8_AppStatusInfo AppStatus_);

    /**
     * Destructor
     */
    inline virtual  ~AppStatusInfoStatus();

    /**
     * Assignment operator
     */
    inline AppStatusInfoStatus& operator = (const AppStatusInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AppStatusInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AppStatusInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AppStatusInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AppStatusInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceConnectionType"

    static const int kDeviceConnectionType = 1;

    /**
     * Clears the field "DeviceConnectionType".
     *
     * The field will be set to its default value. The hasDeviceConnectionType()
     * method will return false.
     */
    inline void clearDeviceConnectionType();

    /**
     * Checks whether the field "DeviceConnectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceConnectionType()). Otherwise it will return false.
     */
    inline bool hasDeviceConnectionType () const;

    /**
     * Returns the value of the member "DeviceConnectionType".
     *
     * Identifies the Connection Type.
     *
     * @return The value of the field "DeviceConnectionType"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType getDeviceConnectionType () const;

    /**
     * Sets the value of the member "DeviceConnectionType".
     *
     * Identifies the Connection Type.
     *
     * @param DeviceConnectionType The value which will be set
     */
    inline void setDeviceConnectionType (::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType DeviceConnectionType_);

    // API of field "AppStatus"

    static const int kAppStatus = 2;

    /**
     * Clears the field "AppStatus".
     *
     * The field will be set to its default value. The hasAppStatus()
     * method will return false.
     */
    inline void clearAppStatus();

    /**
     * Checks whether the field "AppStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppStatus()). Otherwise it will return false.
     */
    inline bool hasAppStatus () const;

    /**
     * Returns the value of the member "AppStatus".
     *
     * Provides Application Status Information.
     *
     * @return The value of the field "AppStatus"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_AppStatusInfo getAppStatus () const;

    /**
     * Sets the value of the member "AppStatus".
     *
     * Provides Application Status Information.
     *
     * @param AppStatus The value which will be set
     */
    inline void setAppStatus (::midw_smartphoneint_fi_types::T_e8_AppStatusInfo AppStatus_);

    static const AppStatusInfoStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceConnectionType ();

    inline void clear_has_DeviceConnectionType ();

    inline void set_has_AppStatus ();

    inline void clear_has_AppStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType _DeviceConnectionType;

    ::midw_smartphoneint_fi_types::T_e8_AppStatusInfo _AppStatus;

};

/**
 * The status message of the property "DAPStatusInfo"
 * Scope: Only for ML
 * It notifies the client about DAP authentication progress information for a Mirror Link device.
 */
class DAPStatusInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DAPStatusInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DAPStatusInfoStatus (const DAPStatusInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DAPStatusInfoStatus (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType DeviceConnectionType_, ::midw_smartphoneint_fi_types::T_e8_DAPStatus DAPStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DAPStatusInfoStatus();

    /**
     * Assignment operator
     */
    inline DAPStatusInfoStatus& operator = (const DAPStatusInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DAPStatusInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DAPStatusInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DAPStatusInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DAPStatusInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceConnectionType"

    static const int kDeviceConnectionType = 1;

    /**
     * Clears the field "DeviceConnectionType".
     *
     * The field will be set to its default value. The hasDeviceConnectionType()
     * method will return false.
     */
    inline void clearDeviceConnectionType();

    /**
     * Checks whether the field "DeviceConnectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceConnectionType()). Otherwise it will return false.
     */
    inline bool hasDeviceConnectionType () const;

    /**
     * Returns the value of the member "DeviceConnectionType".
     *
     * Identifies the Connection Type.
     *
     * @return The value of the field "DeviceConnectionType"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType getDeviceConnectionType () const;

    /**
     * Sets the value of the member "DeviceConnectionType".
     *
     * Identifies the Connection Type.
     *
     * @param DeviceConnectionType The value which will be set
     */
    inline void setDeviceConnectionType (::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType DeviceConnectionType_);

    // API of field "DAPStatus"

    static const int kDAPStatus = 2;

    /**
     * Clears the field "DAPStatus".
     *
     * The field will be set to its default value. The hasDAPStatus()
     * method will return false.
     */
    inline void clearDAPStatus();

    /**
     * Checks whether the field "DAPStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDAPStatus()). Otherwise it will return false.
     */
    inline bool hasDAPStatus () const;

    /**
     * Returns the value of the member "DAPStatus".
     *
     * DAP Authentication Progress Status.
     *
     * @return The value of the field "DAPStatus"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DAPStatus getDAPStatus () const;

    /**
     * Sets the value of the member "DAPStatus".
     *
     * DAP Authentication Progress Status.
     *
     * @param DAPStatus The value which will be set
     */
    inline void setDAPStatus (::midw_smartphoneint_fi_types::T_e8_DAPStatus DAPStatus_);

    static const DAPStatusInfoStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceConnectionType ();

    inline void clear_has_DeviceConnectionType ();

    inline void set_has_DAPStatus ();

    inline void clear_has_DAPStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType _DeviceConnectionType;

    ::midw_smartphoneint_fi_types::T_e8_DAPStatus _DAPStatus;

};

/**
 * The status message of the property "NotificationInfo"
 * Interface to provide Notification Information received from the Mirror Link server (only for Mirror Link devices).
 */
class NotificationInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NotificationInfoStatus ();

    /**
     * Copy constructor
     */
    inline  NotificationInfoStatus (const NotificationInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NotificationInfoStatus (uint32 DeviceHandle_, uint32 AppHandle_, const ::midw_smartphoneint_fi_types::T_NotificationData& NotificationData_);

    /**
     * Destructor
     */
    inline virtual  ~NotificationInfoStatus();

    /**
     * Assignment operator
     */
    inline NotificationInfoStatus& operator = (const NotificationInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NotificationInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NotificationInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NotificationInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NotificationInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Provides the information of Unique device identifier.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Provides the information of Unique device identifier.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "AppHandle"

    static const int kAppHandle = 1;

    /**
     * Clears the field "AppHandle".
     *
     * The field will be set to its default value. The hasAppHandle()
     * method will return false.
     */
    inline void clearAppHandle();

    /**
     * Checks whether the field "AppHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppHandle()). Otherwise it will return false.
     */
    inline bool hasAppHandle () const;

    /**
     * Returns the value of the member "AppHandle".
     *
     * Handle uniquely identifies an application on the device.
     *
     * @return The value of the field "AppHandle"
     */
    inline uint32 getAppHandle () const;

    /**
     * Sets the value of the member "AppHandle".
     *
     * Handle uniquely identifies an application on the device.
     *
     * @param AppHandle The value which will be set
     */
    inline void setAppHandle (uint32 AppHandle_);

    // API of field "NotificationData"

    static const int kNotificationData = 2;

    /**
     * Clears the field "NotificationData".
     *
     * The field will be set to its default value. The hasNotificationData()
     * method will return false.
     */
    inline void clearNotificationData();

    /**
     * Checks whether the field "NotificationData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotificationData()). Otherwise it will return false.
     */
    inline bool hasNotificationData () const;

    /**
     * Returns the value of the member "NotificationData".
     *
     * Provides notification event details.
     *
     * @return The value of the field "NotificationData"
     */
    inline const ::midw_smartphoneint_fi_types::T_NotificationData& getNotificationData () const;

    /**
     * Retrieves the value of the field "NotificationData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NotificationData".
     */
    inline ::midw_smartphoneint_fi_types::T_NotificationData& getNotificationDataMutable ();

    /**
     * Sets the value of the member "NotificationData".
     *
     * Provides notification event details.
     *
     * @param NotificationData The value which will be set
     */
    inline void setNotificationData (const ::midw_smartphoneint_fi_types::T_NotificationData& NotificationData_);

    static const NotificationInfoStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_AppHandle ();

    inline void clear_has_AppHandle ();

    inline void set_has_NotificationData ();

    inline void clear_has_NotificationData ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    uint32 _AppHandle;

    ::midw_smartphoneint_fi_types::T_NotificationData _NotificationData;

};

/**
 * The status message of the property "ApplicationMediaMetaData"
 * Scope : CarPlay, AAP, Carlife
 * Interface to notify media application metadata to the client.
 */
class ApplicationMediaMetaDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ApplicationMediaMetaDataStatus ();

    /**
     * Copy constructor
     */
    inline  ApplicationMediaMetaDataStatus (const ApplicationMediaMetaDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ApplicationMediaMetaDataStatus (uint32 DeviceHandle_, bool MetaDataValid_, const ::midw_smartphoneint_fi_types::T_ApplicationMediaMetaData& ApplicationMediaMetaData_);

    /**
     * Destructor
     */
    inline virtual  ~ApplicationMediaMetaDataStatus();

    /**
     * Assignment operator
     */
    inline ApplicationMediaMetaDataStatus& operator = (const ApplicationMediaMetaDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ApplicationMediaMetaDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ApplicationMediaMetaDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ApplicationMediaMetaDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ApplicationMediaMetaDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "MetaDataValid"

    static const int kMetaDataValid = 1;

    /**
     * Clears the field "MetaDataValid".
     *
     * The field will be set to its default value. The hasMetaDataValid()
     * method will return false.
     */
    inline void clearMetaDataValid();

    /**
     * Checks whether the field "MetaDataValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMetaDataValid()). Otherwise it will return false.
     */
    inline bool hasMetaDataValid () const;

    /**
     * Returns the value of the member "MetaDataValid".
     *
     * Validity of the metadata. HMI to check this value, only if it is true process the ApplicationMetaData
     *
     * @return The value of the field "MetaDataValid"
     */
    inline bool getMetaDataValid () const;

    /**
     * Sets the value of the member "MetaDataValid".
     *
     * Validity of the metadata. HMI to check this value, only if it is true process the ApplicationMetaData
     *
     * @param MetaDataValid The value which will be set
     */
    inline void setMetaDataValid (bool MetaDataValid_);

    // API of field "ApplicationMediaMetaData"

    static const int kApplicationMediaMetaData = 2;

    /**
     * Clears the field "ApplicationMediaMetaData".
     *
     * The field will be set to its default value. The hasApplicationMediaMetaData()
     * method will return false.
     */
    inline void clearApplicationMediaMetaData();

    /**
     * Checks whether the field "ApplicationMediaMetaData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setApplicationMediaMetaData()). Otherwise it will return false.
     */
    inline bool hasApplicationMediaMetaData () const;

    /**
     * Returns the value of the member "ApplicationMediaMetaData".
     *
     * Contains the complete media metadata information.
     *
     * @return The value of the field "ApplicationMediaMetaData"
     */
    inline const ::midw_smartphoneint_fi_types::T_ApplicationMediaMetaData& getApplicationMediaMetaData () const;

    /**
     * Retrieves the value of the field "ApplicationMediaMetaData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ApplicationMediaMetaData".
     */
    inline ::midw_smartphoneint_fi_types::T_ApplicationMediaMetaData& getApplicationMediaMetaDataMutable ();

    /**
     * Sets the value of the member "ApplicationMediaMetaData".
     *
     * Contains the complete media metadata information.
     *
     * @param ApplicationMediaMetaData The value which will be set
     */
    inline void setApplicationMediaMetaData (const ::midw_smartphoneint_fi_types::T_ApplicationMediaMetaData& ApplicationMediaMetaData_);

    static const ApplicationMediaMetaDataStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_MetaDataValid ();

    inline void clear_has_MetaDataValid ();

    inline void set_has_ApplicationMediaMetaData ();

    inline void clear_has_ApplicationMediaMetaData ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    bool _MetaDataValid;

    ::midw_smartphoneint_fi_types::T_ApplicationMediaMetaData _ApplicationMediaMetaData;

};

/**
 * The status message of the property "DeviceDisplayContext"
 * This interface is used by native HMI and the Mirror Link/DiPO/Android Auto device to inform each other regarding the current display context. This interface is bidirectional. The parameter field will be used by HMI to inform SPI and the result field will be used by SPI to inform HMI.
 */
class DeviceDisplayContextStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceDisplayContextStatus ();

    /**
     * Copy constructor
     */
    inline  DeviceDisplayContextStatus (const DeviceDisplayContextStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceDisplayContextStatus (uint32 DeviceHandle_, bool DisplayFlag_, ::midw_smartphoneint_fi_types::T_e8_DisplayContextReason DisplayContextReason_, ::midw_smartphoneint_fi_types::T_e8_Entity DisplayPermanentEntity_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceDisplayContextStatus();

    /**
     * Assignment operator
     */
    inline DeviceDisplayContextStatus& operator = (const DeviceDisplayContextStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceDisplayContextStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceDisplayContextStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceDisplayContextStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceDisplayContextStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DisplayFlag"

    static const int kDisplayFlag = 1;

    /**
     * Clears the field "DisplayFlag".
     *
     * The field will be set to its default value. The hasDisplayFlag()
     * method will return false.
     */
    inline void clearDisplayFlag();

    /**
     * Checks whether the field "DisplayFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayFlag()). Otherwise it will return false.
     */
    inline bool hasDisplayFlag () const;

    /**
     * Returns the value of the member "DisplayFlag".
     *
     * TRUE - Start SPI Display Projection(Native screen to  Projection)  , FALSE - Stop SPI Display Projection( Projection to Native screen).
     *
     * @return The value of the field "DisplayFlag"
     */
    inline bool getDisplayFlag () const;

    /**
     * Sets the value of the member "DisplayFlag".
     *
     * TRUE - Start SPI Display Projection(Native screen to  Projection)  , FALSE - Stop SPI Display Projection( Projection to Native screen).
     *
     * @param DisplayFlag The value which will be set
     */
    inline void setDisplayFlag (bool DisplayFlag_);

    // API of field "DisplayContextReason"

    static const int kDisplayContextReason = 2;

    /**
     * Clears the field "DisplayContextReason".
     *
     * The field will be set to its default value. The hasDisplayContextReason()
     * method will return false.
     */
    inline void clearDisplayContextReason();

    /**
     * Checks whether the field "DisplayContextReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayContextReason()). Otherwise it will return false.
     */
    inline bool hasDisplayContextReason () const;

    /**
     * Returns the value of the member "DisplayContextReason".
     *
     * Provides reason for display context update.
     *
     * @return The value of the field "DisplayContextReason"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DisplayContextReason getDisplayContextReason () const;

    /**
     * Sets the value of the member "DisplayContextReason".
     *
     * Provides reason for display context update.
     *
     * @param DisplayContextReason The value which will be set
     */
    inline void setDisplayContextReason (::midw_smartphoneint_fi_types::T_e8_DisplayContextReason DisplayContextReason_);

    // API of field "DisplayPermanentEntity"

    static const int kDisplayPermanentEntity = 3;

    /**
     * Clears the field "DisplayPermanentEntity".
     *
     * The field will be set to its default value. The hasDisplayPermanentEntity()
     * method will return false.
     */
    inline void clearDisplayPermanentEntity();

    /**
     * Checks whether the field "DisplayPermanentEntity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayPermanentEntity()). Otherwise it will return false.
     */
    inline bool hasDisplayPermanentEntity () const;

    /**
     * Returns the value of the member "DisplayPermanentEntity".
     *
     * Identifies the permanent owner of the display resource.
     *
     * @return The value of the field "DisplayPermanentEntity"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_Entity getDisplayPermanentEntity () const;

    /**
     * Sets the value of the member "DisplayPermanentEntity".
     *
     * Identifies the permanent owner of the display resource.
     *
     * @param DisplayPermanentEntity The value which will be set
     */
    inline void setDisplayPermanentEntity (::midw_smartphoneint_fi_types::T_e8_Entity DisplayPermanentEntity_);

    static const DeviceDisplayContextStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DisplayFlag ();

    inline void clear_has_DisplayFlag ();

    inline void set_has_DisplayContextReason ();

    inline void clear_has_DisplayContextReason ();

    inline void set_has_DisplayPermanentEntity ();

    inline void clear_has_DisplayPermanentEntity ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _DeviceHandle;

    bool _DisplayFlag;

    ::midw_smartphoneint_fi_types::T_e8_DisplayContextReason _DisplayContextReason;

    ::midw_smartphoneint_fi_types::T_e8_Entity _DisplayPermanentEntity;

};

/**
 * The status message of the property "ApplicationPhoneData"
 * Scope : CarPlay
 * Interface to notify Phone application data like, call status, signal strength to the client.
 */
class ApplicationPhoneDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ApplicationPhoneDataStatus ();

    /**
     * Copy constructor
     */
    inline  ApplicationPhoneDataStatus (const ApplicationPhoneDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ApplicationPhoneDataStatus (uint32 DeviceHandle_, bool PhoneDataValid_, const ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallMetadata >& PhoneCallMetadata_, ::midw_smartphoneint_fi_types::T_e8_PhoneSignalStrength SignalStrength_, ::midw_smartphoneint_fi_types::T_e8_PhoneRegistrationStatus RegistrationStatus_, ::midw_smartphoneint_fi_types::T_e8_PhoneAirPlaneModeStatus AirPlaneModeStatus_, ::midw_smartphoneint_fi_types::T_e8_Mute Mute_, const ::std::string& CarrierName_, uint8 BatteryChargeLevel_, ::midw_smartphoneint_fi_types::T_e8_BatteryChargingState BatteryChargingState_);

    /**
     * Destructor
     */
    inline virtual  ~ApplicationPhoneDataStatus();

    /**
     * Assignment operator
     */
    inline ApplicationPhoneDataStatus& operator = (const ApplicationPhoneDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ApplicationPhoneDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ApplicationPhoneDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ApplicationPhoneDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ApplicationPhoneDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "PhoneDataValid"

    static const int kPhoneDataValid = 1;

    /**
     * Clears the field "PhoneDataValid".
     *
     * The field will be set to its default value. The hasPhoneDataValid()
     * method will return false.
     */
    inline void clearPhoneDataValid();

    /**
     * Checks whether the field "PhoneDataValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneDataValid()). Otherwise it will return false.
     */
    inline bool hasPhoneDataValid () const;

    /**
     * Returns the value of the member "PhoneDataValid".
     *
     * Validity of the Phone data. HMI to check this value, only if it is true, process the ApplicationPhoneData
     *
     * @return The value of the field "PhoneDataValid"
     */
    inline bool getPhoneDataValid () const;

    /**
     * Sets the value of the member "PhoneDataValid".
     *
     * Validity of the Phone data. HMI to check this value, only if it is true, process the ApplicationPhoneData
     *
     * @param PhoneDataValid The value which will be set
     */
    inline void setPhoneDataValid (bool PhoneDataValid_);

    // API of field "PhoneCallMetadata"

    static const int kPhoneCallMetadata = 2;

    /**
     * Clears the field "PhoneCallMetadata".
     *
     * The field will be set to its default value. The hasPhoneCallMetadata()
     * method will return false.
     */
    inline void clearPhoneCallMetadata();

    /**
     * Checks whether the field "PhoneCallMetadata" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneCallMetadata()). Otherwise it will return false.
     */
    inline bool hasPhoneCallMetadata () const;

    /**
     * Returns the value of the member "PhoneCallMetadata".
     *
     * Contains the Phone call status like call state, caller name, caller ID.
     * This struture is Obsolote; please use ApplicationPhoneCallData property
     *
     * @return The value of the field "PhoneCallMetadata"
     */
    inline const ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallMetadata >& getPhoneCallMetadata () const;

    /**
     * Retrieves the value of the field "PhoneCallMetadata" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneCallMetadata".
     */
    inline ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallMetadata >& getPhoneCallMetadataMutable ();

    /**
     * Sets the value of the member "PhoneCallMetadata".
     *
     * Contains the Phone call status like call state, caller name, caller ID.
     * This struture is Obsolote; please use ApplicationPhoneCallData property
     *
     * @param PhoneCallMetadata The value which will be set
     */
    inline void setPhoneCallMetadata (const ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallMetadata >& PhoneCallMetadata_);

    // API of field "SignalStrength"

    static const int kSignalStrength = 3;

    /**
     * Clears the field "SignalStrength".
     *
     * The field will be set to its default value. The hasSignalStrength()
     * method will return false.
     */
    inline void clearSignalStrength();

    /**
     * Checks whether the field "SignalStrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSignalStrength()). Otherwise it will return false.
     */
    inline bool hasSignalStrength () const;

    /**
     * Returns the value of the member "SignalStrength".
     *
     * Signal Strength on the Phone.
     *
     * @return The value of the field "SignalStrength"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_PhoneSignalStrength getSignalStrength () const;

    /**
     * Sets the value of the member "SignalStrength".
     *
     * Signal Strength on the Phone.
     *
     * @param SignalStrength The value which will be set
     */
    inline void setSignalStrength (::midw_smartphoneint_fi_types::T_e8_PhoneSignalStrength SignalStrength_);

    // API of field "RegistrationStatus"

    static const int kRegistrationStatus = 4;

    /**
     * Clears the field "RegistrationStatus".
     *
     * The field will be set to its default value. The hasRegistrationStatus()
     * method will return false.
     */
    inline void clearRegistrationStatus();

    /**
     * Checks whether the field "RegistrationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegistrationStatus()). Otherwise it will return false.
     */
    inline bool hasRegistrationStatus () const;

    /**
     * Returns the value of the member "RegistrationStatus".
     *
     * Registration status of the phone connection
     *
     * @return The value of the field "RegistrationStatus"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_PhoneRegistrationStatus getRegistrationStatus () const;

    /**
     * Sets the value of the member "RegistrationStatus".
     *
     * Registration status of the phone connection
     *
     * @param RegistrationStatus The value which will be set
     */
    inline void setRegistrationStatus (::midw_smartphoneint_fi_types::T_e8_PhoneRegistrationStatus RegistrationStatus_);

    // API of field "AirPlaneModeStatus"

    static const int kAirPlaneModeStatus = 5;

    /**
     * Clears the field "AirPlaneModeStatus".
     *
     * The field will be set to its default value. The hasAirPlaneModeStatus()
     * method will return false.
     */
    inline void clearAirPlaneModeStatus();

    /**
     * Checks whether the field "AirPlaneModeStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAirPlaneModeStatus()). Otherwise it will return false.
     */
    inline bool hasAirPlaneModeStatus () const;

    /**
     * Returns the value of the member "AirPlaneModeStatus".
     *
     * AirPlane Mode status on the phone
     *
     * @return The value of the field "AirPlaneModeStatus"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_PhoneAirPlaneModeStatus getAirPlaneModeStatus () const;

    /**
     * Sets the value of the member "AirPlaneModeStatus".
     *
     * AirPlane Mode status on the phone
     *
     * @param AirPlaneModeStatus The value which will be set
     */
    inline void setAirPlaneModeStatus (::midw_smartphoneint_fi_types::T_e8_PhoneAirPlaneModeStatus AirPlaneModeStatus_);

    // API of field "Mute"

    static const int kMute = 6;

    /**
     * Clears the field "Mute".
     *
     * The field will be set to its default value. The hasMute()
     * method will return false.
     */
    inline void clearMute();

    /**
     * Checks whether the field "Mute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMute()). Otherwise it will return false.
     */
    inline bool hasMute () const;

    /**
     * Returns the value of the member "Mute".
     *
     * Mute status of the call.
     *
     * @return The value of the field "Mute"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_Mute getMute () const;

    /**
     * Sets the value of the member "Mute".
     *
     * Mute status of the call.
     *
     * @param Mute The value which will be set
     */
    inline void setMute (::midw_smartphoneint_fi_types::T_e8_Mute Mute_);

    // API of field "CarrierName"

    static const int kCarrierName = 7;

    /**
     * Clears the field "CarrierName".
     *
     * The field will be set to its default value. The hasCarrierName()
     * method will return false.
     */
    inline void clearCarrierName();

    /**
     * Checks whether the field "CarrierName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarrierName()). Otherwise it will return false.
     */
    inline bool hasCarrierName () const;

    /**
     * Returns the value of the member "CarrierName".
     *
     * Carrier Name on the phone. Set to NULL, zero length string, if not valid.
     *
     * @return The value of the field "CarrierName"
     */
    inline const ::std::string& getCarrierName () const;

    /**
     * Retrieves the value of the field "CarrierName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CarrierName".
     */
    inline ::std::string& getCarrierNameMutable ();

    /**
     * Sets the value of the member "CarrierName".
     *
     * Carrier Name on the phone. Set to NULL, zero length string, if not valid.
     *
     * @param CarrierName The value which will be set
     */
    inline void setCarrierName (const ::std::string& CarrierName_);

    /**
     * Sets the value of the member "CarrierName".
     *
     * Carrier Name on the phone. Set to NULL, zero length string, if not valid.
     *
     * @param CarrierName The value which will be set
     */
    inline void setCarrierName (const char* CarrierName_);

    /**
     * Sets the value of the member "CarrierName".
     *
     * Carrier Name on the phone. Set to NULL, zero length string, if not valid.
     *
     * @param CarrierName The value which will be set
     */
    inline void setCarrierName (const char* value, size_t size);

    // API of field "BatteryChargeLevel"

    static const int kBatteryChargeLevel = 8;

    /**
     * Clears the field "BatteryChargeLevel".
     *
     * The field will be set to its default value. The hasBatteryChargeLevel()
     * method will return false.
     */
    inline void clearBatteryChargeLevel();

    /**
     * Checks whether the field "BatteryChargeLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBatteryChargeLevel()). Otherwise it will return false.
     */
    inline bool hasBatteryChargeLevel () const;

    /**
     * Returns the value of the member "BatteryChargeLevel".
     *
     * Battery charge level. If it is not available, it will be set to 0XFF.
     *
     * @return The value of the field "BatteryChargeLevel"
     */
    inline uint8 getBatteryChargeLevel () const;

    /**
     * Sets the value of the member "BatteryChargeLevel".
     *
     * Battery charge level. If it is not available, it will be set to 0XFF.
     *
     * @param BatteryChargeLevel The value which will be set
     */
    inline void setBatteryChargeLevel (uint8 BatteryChargeLevel_);

    // API of field "BatteryChargingState"

    static const int kBatteryChargingState = 9;

    /**
     * Clears the field "BatteryChargingState".
     *
     * The field will be set to its default value. The hasBatteryChargingState()
     * method will return false.
     */
    inline void clearBatteryChargingState();

    /**
     * Checks whether the field "BatteryChargingState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBatteryChargingState()). Otherwise it will return false.
     */
    inline bool hasBatteryChargingState () const;

    /**
     * Returns the value of the member "BatteryChargingState".
     *
     * Battery charging state. If it is not available, it will be set to UNKNOWN
     *
     * @return The value of the field "BatteryChargingState"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_BatteryChargingState getBatteryChargingState () const;

    /**
     * Sets the value of the member "BatteryChargingState".
     *
     * Battery charging state. If it is not available, it will be set to UNKNOWN
     *
     * @param BatteryChargingState The value which will be set
     */
    inline void setBatteryChargingState (::midw_smartphoneint_fi_types::T_e8_BatteryChargingState BatteryChargingState_);

    static const ApplicationPhoneDataStatus &getDefaultInstance();

private:

    static const ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallMetadata >& getT_ApplicationPhoneCallMetadataList_DefaultInstance ();

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_PhoneDataValid ();

    inline void clear_has_PhoneDataValid ();

    inline void set_has_PhoneCallMetadata ();

    inline void clear_has_PhoneCallMetadata ();

    inline void set_has_SignalStrength ();

    inline void clear_has_SignalStrength ();

    inline void set_has_RegistrationStatus ();

    inline void clear_has_RegistrationStatus ();

    inline void set_has_AirPlaneModeStatus ();

    inline void clear_has_AirPlaneModeStatus ();

    inline void set_has_Mute ();

    inline void clear_has_Mute ();

    inline void set_has_CarrierName ();

    inline void clear_has_CarrierName ();

    inline void set_has_BatteryChargeLevel ();

    inline void clear_has_BatteryChargeLevel ();

    inline void set_has_BatteryChargingState ();

    inline void clear_has_BatteryChargingState ();

    uint32 _has_bits_[ (10 + 31) / 32];

    uint32 _DeviceHandle;

    bool _PhoneDataValid;

    ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallMetadata > _PhoneCallMetadata;

    ::midw_smartphoneint_fi_types::T_e8_PhoneSignalStrength _SignalStrength;

    ::midw_smartphoneint_fi_types::T_e8_PhoneRegistrationStatus _RegistrationStatus;

    ::midw_smartphoneint_fi_types::T_e8_PhoneAirPlaneModeStatus _AirPlaneModeStatus;

    ::midw_smartphoneint_fi_types::T_e8_Mute _Mute;

    ::std::string _CarrierName;

    uint8 _BatteryChargeLevel;

    ::midw_smartphoneint_fi_types::T_e8_BatteryChargingState _BatteryChargingState;

};

/**
 * The status message of the property "BluetoothDeviceStatus"
 * Used to notify HMI when there is a device switch operation being performed between a BT and a Projection device, as a result of user action or due to device selection strategy applied by Bluetooth/SPI service.
 */
class BluetoothDeviceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BluetoothDeviceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  BluetoothDeviceStatusStatus (const BluetoothDeviceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BluetoothDeviceStatusStatus (uint32 BluetoothDeviceHandle_, uint32 ProjectionDeviceHandle_, uint8 ConnectedProfiles_, ::midw_smartphoneint_fi_types::T_e8_BTChangeInfo BTChangeInfo_, bool SameDevice_, bool CallActiveStatus_);

    /**
     * Destructor
     */
    inline virtual  ~BluetoothDeviceStatusStatus();

    /**
     * Assignment operator
     */
    inline BluetoothDeviceStatusStatus& operator = (const BluetoothDeviceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothDeviceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothDeviceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothDeviceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothDeviceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BluetoothDeviceHandle"

    static const int kBluetoothDeviceHandle = 0;

    /**
     * Clears the field "BluetoothDeviceHandle".
     *
     * The field will be set to its default value. The hasBluetoothDeviceHandle()
     * method will return false.
     */
    inline void clearBluetoothDeviceHandle();

    /**
     * Checks whether the field "BluetoothDeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBluetoothDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasBluetoothDeviceHandle () const;

    /**
     * Returns the value of the member "BluetoothDeviceHandle".
     *
     * Identifies a BT device from BT Settings device list.
     *
     * @return The value of the field "BluetoothDeviceHandle"
     */
    inline uint32 getBluetoothDeviceHandle () const;

    /**
     * Sets the value of the member "BluetoothDeviceHandle".
     *
     * Identifies a BT device from BT Settings device list.
     *
     * @param BluetoothDeviceHandle The value which will be set
     */
    inline void setBluetoothDeviceHandle (uint32 BluetoothDeviceHandle_);

    // API of field "ProjectionDeviceHandle"

    static const int kProjectionDeviceHandle = 1;

    /**
     * Clears the field "ProjectionDeviceHandle".
     *
     * The field will be set to its default value. The hasProjectionDeviceHandle()
     * method will return false.
     */
    inline void clearProjectionDeviceHandle();

    /**
     * Checks whether the field "ProjectionDeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProjectionDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasProjectionDeviceHandle () const;

    /**
     * Returns the value of the member "ProjectionDeviceHandle".
     *
     * Identifies a Projection device from SPI device list.
     *
     * @return The value of the field "ProjectionDeviceHandle"
     */
    inline uint32 getProjectionDeviceHandle () const;

    /**
     * Sets the value of the member "ProjectionDeviceHandle".
     *
     * Identifies a Projection device from SPI device list.
     *
     * @param ProjectionDeviceHandle The value which will be set
     */
    inline void setProjectionDeviceHandle (uint32 ProjectionDeviceHandle_);

    // API of field "ConnectedProfiles"

    static const int kConnectedProfiles = 2;

    /**
     * Clears the field "ConnectedProfiles".
     *
     * The field will be set to its default value. The hasConnectedProfiles()
     * method will return false.
     */
    inline void clearConnectedProfiles();

    /**
     * Checks whether the field "ConnectedProfiles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectedProfiles()). Otherwise it will return false.
     */
    inline bool hasConnectedProfiles () const;

    /**
     * Returns the value of the member "ConnectedProfiles".
     *
     * Scope : MySPIN.
     * Provides info about different active profiles (A2DP, HFP) over which the BT device is connected.
     * 0th bit - HFP
     * (Value 0 - HFP profile is not active, Value 1 - HFP profile is active)
     * 1st bit - A2DP
     * (Value 0 - A2DP profile is not active, Value 1 - A2DP profile is active)
     * 0xFF  - When information is not available.
     *
     * @return The value of the field "ConnectedProfiles"
     */
    inline uint8 getConnectedProfiles () const;

    /**
     * Sets the value of the member "ConnectedProfiles".
     *
     * Scope : MySPIN.
     * Provides info about different active profiles (A2DP, HFP) over which the BT device is connected.
     * 0th bit - HFP
     * (Value 0 - HFP profile is not active, Value 1 - HFP profile is active)
     * 1st bit - A2DP
     * (Value 0 - A2DP profile is not active, Value 1 - A2DP profile is active)
     * 0xFF  - When information is not available.
     *
     * @param ConnectedProfiles The value which will be set
     */
    inline void setConnectedProfiles (uint8 ConnectedProfiles_);

    // API of field "BTChangeInfo"

    static const int kBTChangeInfo = 3;

    /**
     * Clears the field "BTChangeInfo".
     *
     * The field will be set to its default value. The hasBTChangeInfo()
     * method will return false.
     */
    inline void clearBTChangeInfo();

    /**
     * Checks whether the field "BTChangeInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTChangeInfo()). Otherwise it will return false.
     */
    inline bool hasBTChangeInfo () const;

    /**
     * Returns the value of the member "BTChangeInfo".
     *
     * Identifies the BT device change type i.e. indicates the current action being performed.
     *
     * @return The value of the field "BTChangeInfo"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_BTChangeInfo getBTChangeInfo () const;

    /**
     * Sets the value of the member "BTChangeInfo".
     *
     * Identifies the BT device change type i.e. indicates the current action being performed.
     *
     * @param BTChangeInfo The value which will be set
     */
    inline void setBTChangeInfo (::midw_smartphoneint_fi_types::T_e8_BTChangeInfo BTChangeInfo_);

    // API of field "SameDevice"

    static const int kSameDevice = 4;

    /**
     * Clears the field "SameDevice".
     *
     * The field will be set to its default value. The hasSameDevice()
     * method will return false.
     */
    inline void clearSameDevice();

    /**
     * Checks whether the field "SameDevice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSameDevice()). Otherwise it will return false.
     */
    inline bool hasSameDevice () const;

    /**
     * Returns the value of the member "SameDevice".
     *
     * Identifies whether BT device and Projection device are same or different devices.
     * If TRUE - indicates they are the same.
     * If FALSE - indicates they are different devices.
     *
     * @return The value of the field "SameDevice"
     */
    inline bool getSameDevice () const;

    /**
     * Sets the value of the member "SameDevice".
     *
     * Identifies whether BT device and Projection device are same or different devices.
     * If TRUE - indicates they are the same.
     * If FALSE - indicates they are different devices.
     *
     * @param SameDevice The value which will be set
     */
    inline void setSameDevice (bool SameDevice_);

    // API of field "CallActiveStatus"

    static const int kCallActiveStatus = 5;

    /**
     * Clears the field "CallActiveStatus".
     *
     * The field will be set to its default value. The hasCallActiveStatus()
     * method will return false.
     */
    inline void clearCallActiveStatus();

    /**
     * Checks whether the field "CallActiveStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallActiveStatus()). Otherwise it will return false.
     */
    inline bool hasCallActiveStatus () const;

    /**
     * Returns the value of the member "CallActiveStatus".
     *
     * Identifies if a call is currently active on the active Bluetooth device.
     *
     * @return The value of the field "CallActiveStatus"
     */
    inline bool getCallActiveStatus () const;

    /**
     * Sets the value of the member "CallActiveStatus".
     *
     * Identifies if a call is currently active on the active Bluetooth device.
     *
     * @param CallActiveStatus The value which will be set
     */
    inline void setCallActiveStatus (bool CallActiveStatus_);

    static const BluetoothDeviceStatusStatus &getDefaultInstance();

private:

    inline void set_has_BluetoothDeviceHandle ();

    inline void clear_has_BluetoothDeviceHandle ();

    inline void set_has_ProjectionDeviceHandle ();

    inline void clear_has_ProjectionDeviceHandle ();

    inline void set_has_ConnectedProfiles ();

    inline void clear_has_ConnectedProfiles ();

    inline void set_has_BTChangeInfo ();

    inline void clear_has_BTChangeInfo ();

    inline void set_has_SameDevice ();

    inline void clear_has_SameDevice ();

    inline void set_has_CallActiveStatus ();

    inline void clear_has_CallActiveStatus ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint32 _BluetoothDeviceHandle;

    uint32 _ProjectionDeviceHandle;

    uint8 _ConnectedProfiles;

    ::midw_smartphoneint_fi_types::T_e8_BTChangeInfo _BTChangeInfo;

    bool _SameDevice;

    bool _CallActiveStatus;

};

/**
 * The status message of the property "DeviceAudioContext"
 * Used to notify HMI when there is a Audio context change in the device.
 */
class DeviceAudioContextStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceAudioContextStatus ();

    /**
     * Copy constructor
     */
    inline  DeviceAudioContextStatus (const DeviceAudioContextStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceAudioContextStatus (uint32 DeviceHandle_, bool AudioFlag_, ::midw_smartphoneint_fi_types::T_e8_AudioContext AudioContext_, ::midw_smartphoneint_fi_types::T_e8_Entity AudioPermanentEntity_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceAudioContextStatus();

    /**
     * Assignment operator
     */
    inline DeviceAudioContextStatus& operator = (const DeviceAudioContextStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceAudioContextStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceAudioContextStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceAudioContextStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceAudioContextStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "AudioFlag"

    static const int kAudioFlag = 1;

    /**
     * Clears the field "AudioFlag".
     *
     * The field will be set to its default value. The hasAudioFlag()
     * method will return false.
     */
    inline void clearAudioFlag();

    /**
     * Checks whether the field "AudioFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioFlag()). Otherwise it will return false.
     */
    inline bool hasAudioFlag () const;

    /**
     * Returns the value of the member "AudioFlag".
     *
     * TRUE - Device requires audio resource, FALSE - Accessory can take the Audio resource.
     *
     * @return The value of the field "AudioFlag"
     */
    inline bool getAudioFlag () const;

    /**
     * Sets the value of the member "AudioFlag".
     *
     * TRUE - Device requires audio resource, FALSE - Accessory can take the Audio resource.
     *
     * @param AudioFlag The value which will be set
     */
    inline void setAudioFlag (bool AudioFlag_);

    // API of field "AudioContext"

    static const int kAudioContext = 2;

    /**
     * Clears the field "AudioContext".
     *
     * The field will be set to its default value. The hasAudioContext()
     * method will return false.
     */
    inline void clearAudioContext();

    /**
     * Checks whether the field "AudioContext" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioContext()). Otherwise it will return false.
     */
    inline bool hasAudioContext () const;

    /**
     * Returns the value of the member "AudioContext".
     *
     * Provides Audio context of the projected device.
     *
     * @return The value of the field "AudioContext"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_AudioContext getAudioContext () const;

    /**
     * Sets the value of the member "AudioContext".
     *
     * Provides Audio context of the projected device.
     *
     * @param AudioContext The value which will be set
     */
    inline void setAudioContext (::midw_smartphoneint_fi_types::T_e8_AudioContext AudioContext_);

    // API of field "AudioPermanentEntity"

    static const int kAudioPermanentEntity = 3;

    /**
     * Clears the field "AudioPermanentEntity".
     *
     * The field will be set to its default value. The hasAudioPermanentEntity()
     * method will return false.
     */
    inline void clearAudioPermanentEntity();

    /**
     * Checks whether the field "AudioPermanentEntity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioPermanentEntity()). Otherwise it will return false.
     */
    inline bool hasAudioPermanentEntity () const;

    /**
     * Returns the value of the member "AudioPermanentEntity".
     *
     * Identifies the permanent owner of the audio resource.
     *
     * @return The value of the field "AudioPermanentEntity"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_Entity getAudioPermanentEntity () const;

    /**
     * Sets the value of the member "AudioPermanentEntity".
     *
     * Identifies the permanent owner of the audio resource.
     *
     * @param AudioPermanentEntity The value which will be set
     */
    inline void setAudioPermanentEntity (::midw_smartphoneint_fi_types::T_e8_Entity AudioPermanentEntity_);

    static const DeviceAudioContextStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_AudioFlag ();

    inline void clear_has_AudioFlag ();

    inline void set_has_AudioContext ();

    inline void clear_has_AudioContext ();

    inline void set_has_AudioPermanentEntity ();

    inline void clear_has_AudioPermanentEntity ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _DeviceHandle;

    bool _AudioFlag;

    ::midw_smartphoneint_fi_types::T_e8_AudioContext _AudioContext;

    ::midw_smartphoneint_fi_types::T_e8_Entity _AudioPermanentEntity;

};

/**
 * The status message of the property "DiPOAppStatusInfo"
 * It notifies the client upon DiPO device app state change. The client should check the status for all the specified Apps.currently 3 app states are specified.
 * According to Apple more App states are expected in future versions.
 */
class DiPOAppStatusInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOAppStatusInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOAppStatusInfoStatus (const DiPOAppStatusInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOAppStatusInfoStatus (::midw_smartphoneint_fi_types::T_e8_SpeechAppState AppStateSpeech_, ::midw_smartphoneint_fi_types::T_e8_PhoneAppState AppStatePhone_, ::midw_smartphoneint_fi_types::T_e8_NavigationAppState AppStateNavigation_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOAppStatusInfoStatus();

    /**
     * Assignment operator
     */
    inline DiPOAppStatusInfoStatus& operator = (const DiPOAppStatusInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOAppStatusInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOAppStatusInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOAppStatusInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOAppStatusInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AppStateSpeech"

    static const int kAppStateSpeech = 0;

    /**
     * Clears the field "AppStateSpeech".
     *
     * The field will be set to its default value. The hasAppStateSpeech()
     * method will return false.
     */
    inline void clearAppStateSpeech();

    /**
     * Checks whether the field "AppStateSpeech" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppStateSpeech()). Otherwise it will return false.
     */
    inline bool hasAppStateSpeech () const;

    /**
     * Returns the value of the member "AppStateSpeech".
     *
     * specifies the different speech operation.
     * SPI_APP_STATE_SPEECH_UNKNOWN = No speech session active.Hence no app state for speech
     * SPI_APP_STATE_SPEECH_END = The state is send to inform that an already active speech state is terminated.
     * SPI_APP_STATE_SPEECH_SPEAKING = The app device is speaking to the user.
     * SPI_APP_STATE_SPEECH_RECOGNISING = The device is recording audio to recognise speech from the user.
     *
     * @return The value of the field "AppStateSpeech"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_SpeechAppState getAppStateSpeech () const;

    /**
     * Sets the value of the member "AppStateSpeech".
     *
     * specifies the different speech operation.
     * SPI_APP_STATE_SPEECH_UNKNOWN = No speech session active.Hence no app state for speech
     * SPI_APP_STATE_SPEECH_END = The state is send to inform that an already active speech state is terminated.
     * SPI_APP_STATE_SPEECH_SPEAKING = The app device is speaking to the user.
     * SPI_APP_STATE_SPEECH_RECOGNISING = The device is recording audio to recognise speech from the user.
     *
     * @param AppStateSpeech The value which will be set
     */
    inline void setAppStateSpeech (::midw_smartphoneint_fi_types::T_e8_SpeechAppState AppStateSpeech_);

    // API of field "AppStatePhone"

    static const int kAppStatePhone = 1;

    /**
     * Clears the field "AppStatePhone".
     *
     * The field will be set to its default value. The hasAppStatePhone()
     * method will return false.
     */
    inline void clearAppStatePhone();

    /**
     * Checks whether the field "AppStatePhone" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppStatePhone()). Otherwise it will return false.
     */
    inline bool hasAppStatePhone () const;

    /**
     * Returns the value of the member "AppStatePhone".
     *
     * specifies the different Phone State.
     * SPI_APP_STATE_PHONE_UNKNOWN = No phone call is active.Hence no app state for phone
     * SPI_APP_STATE_PHONE_ACTIVE = Phone call is active.
     * SPI_APP_STATE_PHONE_NOTACTIVE = The state is send to inform that an already active phone call has ended. ie,an app state change from active to not active.
     *
     * @return The value of the field "AppStatePhone"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_PhoneAppState getAppStatePhone () const;

    /**
     * Sets the value of the member "AppStatePhone".
     *
     * specifies the different Phone State.
     * SPI_APP_STATE_PHONE_UNKNOWN = No phone call is active.Hence no app state for phone
     * SPI_APP_STATE_PHONE_ACTIVE = Phone call is active.
     * SPI_APP_STATE_PHONE_NOTACTIVE = The state is send to inform that an already active phone call has ended. ie,an app state change from active to not active.
     *
     * @param AppStatePhone The value which will be set
     */
    inline void setAppStatePhone (::midw_smartphoneint_fi_types::T_e8_PhoneAppState AppStatePhone_);

    // API of field "AppStateNavigation"

    static const int kAppStateNavigation = 2;

    /**
     * Clears the field "AppStateNavigation".
     *
     * The field will be set to its default value. The hasAppStateNavigation()
     * method will return false.
     */
    inline void clearAppStateNavigation();

    /**
     * Checks whether the field "AppStateNavigation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppStateNavigation()). Otherwise it will return false.
     */
    inline bool hasAppStateNavigation () const;

    /**
     * Returns the value of the member "AppStateNavigation".
     *
     * specifies the different Navigation App State.
     * SPI_APP_STATE_NAV_UNKNOWN = No navigation APP is active.Hence no app state for navigation
     * SPI_APP_STATE_NAV_ACTIVE = Navigation APP is active.
     * SPI_APP_STATE_NAV_NOTACTIVE = The state is send to inform that an already active TBT navigation has ended. ie,an app state change from active to not active.
     *
     * @return The value of the field "AppStateNavigation"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_NavigationAppState getAppStateNavigation () const;

    /**
     * Sets the value of the member "AppStateNavigation".
     *
     * specifies the different Navigation App State.
     * SPI_APP_STATE_NAV_UNKNOWN = No navigation APP is active.Hence no app state for navigation
     * SPI_APP_STATE_NAV_ACTIVE = Navigation APP is active.
     * SPI_APP_STATE_NAV_NOTACTIVE = The state is send to inform that an already active TBT navigation has ended. ie,an app state change from active to not active.
     *
     * @param AppStateNavigation The value which will be set
     */
    inline void setAppStateNavigation (::midw_smartphoneint_fi_types::T_e8_NavigationAppState AppStateNavigation_);

    static const DiPOAppStatusInfoStatus &getDefaultInstance();

private:

    inline void set_has_AppStateSpeech ();

    inline void clear_has_AppStateSpeech ();

    inline void set_has_AppStatePhone ();

    inline void clear_has_AppStatePhone ();

    inline void set_has_AppStateNavigation ();

    inline void clear_has_AppStateNavigation ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_SpeechAppState _AppStateSpeech;

    ::midw_smartphoneint_fi_types::T_e8_PhoneAppState _AppStatePhone;

    ::midw_smartphoneint_fi_types::T_e8_NavigationAppState _AppStateNavigation;

};

/**
 * The status message of the property "SessionStatusInfo"
 * Scope: ML, CarPlay, AAP and MySPIN
 * It notifies the client about Session status information for a projected device.
 */
class SessionStatusInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SessionStatusInfoStatus ();

    /**
     * Copy constructor
     */
    inline  SessionStatusInfoStatus (const SessionStatusInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SessionStatusInfoStatus (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_, ::midw_smartphoneint_fi_types::T_e8_SessionStatus SessionStatus_, ::midw_smartphoneint_fi_types::T_e8_HandsetInteraction HandsetInteractionStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SessionStatusInfoStatus();

    /**
     * Assignment operator
     */
    inline SessionStatusInfoStatus& operator = (const SessionStatusInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SessionStatusInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SessionStatusInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SessionStatusInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SessionStatusInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 1;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Identifies the Device Category.
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Identifies the Device Category.
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    // API of field "SessionStatus"

    static const int kSessionStatus = 2;

    /**
     * Clears the field "SessionStatus".
     *
     * The field will be set to its default value. The hasSessionStatus()
     * method will return false.
     */
    inline void clearSessionStatus();

    /**
     * Checks whether the field "SessionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionStatus()). Otherwise it will return false.
     */
    inline bool hasSessionStatus () const;

    /**
     * Returns the value of the member "SessionStatus".
     *
     * Session status information.
     *
     * @return The value of the field "SessionStatus"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_SessionStatus getSessionStatus () const;

    /**
     * Sets the value of the member "SessionStatus".
     *
     * Session status information.
     *
     * @param SessionStatus The value which will be set
     */
    inline void setSessionStatus (::midw_smartphoneint_fi_types::T_e8_SessionStatus SessionStatus_);

    // API of field "HandsetInteractionStatus"

    static const int kHandsetInteractionStatus = 3;

    /**
     * Clears the field "HandsetInteractionStatus".
     *
     * The field will be set to its default value. The hasHandsetInteractionStatus()
     * method will return false.
     */
    inline void clearHandsetInteractionStatus();

    /**
     * Checks whether the field "HandsetInteractionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHandsetInteractionStatus()). Otherwise it will return false.
     */
    inline bool hasHandsetInteractionStatus () const;

    /**
     * Returns the value of the member "HandsetInteractionStatus".
     *
     * Scope : AAP
     * When the Android Auto device is connected for the first time to the vehicle, there are certain messages or action that can seen or should be done on the Phone display.
     * This parameter can be used to show some useful pop on HMI screen for the user.
     *
     * @return The value of the field "HandsetInteractionStatus"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_HandsetInteraction getHandsetInteractionStatus () const;

    /**
     * Sets the value of the member "HandsetInteractionStatus".
     *
     * Scope : AAP
     * When the Android Auto device is connected for the first time to the vehicle, there are certain messages or action that can seen or should be done on the Phone display.
     * This parameter can be used to show some useful pop on HMI screen for the user.
     *
     * @param HandsetInteractionStatus The value which will be set
     */
    inline void setHandsetInteractionStatus (::midw_smartphoneint_fi_types::T_e8_HandsetInteraction HandsetInteractionStatus_);

    static const SessionStatusInfoStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    inline void set_has_SessionStatus ();

    inline void clear_has_SessionStatus ();

    inline void set_has_HandsetInteractionStatus ();

    inline void clear_has_HandsetInteractionStatus ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

    ::midw_smartphoneint_fi_types::T_e8_SessionStatus _SessionStatus;

    ::midw_smartphoneint_fi_types::T_e8_HandsetInteraction _HandsetInteractionStatus;

};

/**
 * The status message of the property "BTPairingRequired"
 * Used to notify the client if BT pairing has to be initiated.
 */
class BTPairingRequiredStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BTPairingRequiredStatus ();

    /**
     * Copy constructor
     */
    inline  BTPairingRequiredStatus (const BTPairingRequiredStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BTPairingRequiredStatus (const ::std::string& sDevBTAddr_, bool bPairingReqd_);

    /**
     * Destructor
     */
    inline virtual  ~BTPairingRequiredStatus();

    /**
     * Assignment operator
     */
    inline BTPairingRequiredStatus& operator = (const BTPairingRequiredStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BTPairingRequiredStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BTPairingRequiredStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BTPairingRequiredStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BTPairingRequiredStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDevBTAddr"

    static const int kSDevBTAddr = 0;

    /**
     * Clears the field "sDevBTAddr".
     *
     * The field will be set to its default value. The hasSDevBTAddr()
     * method will return false.
     */
    inline void clearSDevBTAddr();

    /**
     * Checks whether the field "sDevBTAddr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDevBTAddr()). Otherwise it will return false.
     */
    inline bool hasSDevBTAddr () const;

    /**
     * Returns the value of the member "sDevBTAddr".
     *
     * BT address of the device for which pairing has to be initiated. Introduced for future use if client has to trigger BT pairing for a particular device. Set to NULL at start-up.
     *
     * @return The value of the field "sDevBTAddr"
     */
    inline const ::std::string& getSDevBTAddr () const;

    /**
     * Retrieves the value of the field "sDevBTAddr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDevBTAddr".
     */
    inline ::std::string& getSDevBTAddrMutable ();

    /**
     * Sets the value of the member "sDevBTAddr".
     *
     * BT address of the device for which pairing has to be initiated. Introduced for future use if client has to trigger BT pairing for a particular device. Set to NULL at start-up.
     *
     * @param sDevBTAddr The value which will be set
     */
    inline void setSDevBTAddr (const ::std::string& sDevBTAddr_);

    /**
     * Sets the value of the member "sDevBTAddr".
     *
     * BT address of the device for which pairing has to be initiated. Introduced for future use if client has to trigger BT pairing for a particular device. Set to NULL at start-up.
     *
     * @param sDevBTAddr The value which will be set
     */
    inline void setSDevBTAddr (const char* sDevBTAddr_);

    /**
     * Sets the value of the member "sDevBTAddr".
     *
     * BT address of the device for which pairing has to be initiated. Introduced for future use if client has to trigger BT pairing for a particular device. Set to NULL at start-up.
     *
     * @param sDevBTAddr The value which will be set
     */
    inline void setSDevBTAddr (const char* value, size_t size);

    // API of field "bPairingReqd"

    static const int kBPairingReqd = 1;

    /**
     * Clears the field "bPairingReqd".
     *
     * The field will be set to its default value. The hasBPairingReqd()
     * method will return false.
     */
    inline void clearBPairingReqd();

    /**
     * Checks whether the field "bPairingReqd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPairingReqd()). Otherwise it will return false.
     */
    inline bool hasBPairingReqd () const;

    /**
     * Returns the value of the member "bPairingReqd".
     *
     * Set to TRUE if HMI has to initiate BT pairing. Will  be set to FALSE at start-up during registration.
     *
     * @return The value of the field "bPairingReqd"
     */
    inline bool getBPairingReqd () const;

    /**
     * Sets the value of the member "bPairingReqd".
     *
     * Set to TRUE if HMI has to initiate BT pairing. Will  be set to FALSE at start-up during registration.
     *
     * @param bPairingReqd The value which will be set
     */
    inline void setBPairingReqd (bool bPairingReqd_);

    static const BTPairingRequiredStatus &getDefaultInstance();

private:

    inline void set_has_sDevBTAddr ();

    inline void clear_has_sDevBTAddr ();

    inline void set_has_bPairingReqd ();

    inline void clear_has_bPairingReqd ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sDevBTAddr;

    bool _bPairingReqd;

};

/**
 * The status message of the property "MLServerKeyCapabilities"
 * Interface to notify Server Key Capabilities to Clients.
 * Applicable only for MirrorLink device.
 */
class MLServerKeyCapabilitiesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MLServerKeyCapabilitiesStatus ();

    /**
     * Copy constructor
     */
    inline  MLServerKeyCapabilitiesStatus (const MLServerKeyCapabilitiesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MLServerKeyCapabilitiesStatus (uint32 DeviceHandle_, uint16 ValidityOfData_, uint16 NumXDeviceKeys_, const ::std::vector< ::midw_smartphoneint_fi_types::T_XDeviceKeys >& XDeviceKeysList_, const ::midw_smartphoneint_fi_types::T_KeyCapabilities& rKeyCapabilities_, ::midw_smartphoneint_fi_types::T_e8_SupportInfo VoiceRecognitionSupportInfo_);

    /**
     * Destructor
     */
    inline virtual  ~MLServerKeyCapabilitiesStatus();

    /**
     * Assignment operator
     */
    inline MLServerKeyCapabilitiesStatus& operator = (const MLServerKeyCapabilitiesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MLServerKeyCapabilitiesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MLServerKeyCapabilitiesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MLServerKeyCapabilitiesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MLServerKeyCapabilitiesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "ValidityOfData"

    static const int kValidityOfData = 1;

    /**
     * Clears the field "ValidityOfData".
     *
     * The field will be set to its default value. The hasValidityOfData()
     * method will return false.
     */
    inline void clearValidityOfData();

    /**
     * Checks whether the field "ValidityOfData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValidityOfData()). Otherwise it will return false.
     */
    inline bool hasValidityOfData () const;

    /**
     * Returns the value of the member "ValidityOfData".
     *
     * This gives the validity of the parameters received with this update except the DeviceHandle.
     * It is provided as a bitwise OR of the parameters supported.
     * 0x0000 => None of the parameters are valid.
     * 0x0001 => NumXDeviceKeys is valid.
     * 0x0002 => XDeviceKeysList is valid.
     * 0x0004 => rKeyCapabilities is valid.
     * 0x0008 => VoiceRecognitionSupportInfo is valid.
     * For eg. If rKeyCapabilities and VoiceRecognitionSupportInfo paramters are valid, this value will be set to 0x000C.
     * In this case, HMI should ignore the values received for NumXDeviceKeys and XDeviceKeysList.
     *
     * @return The value of the field "ValidityOfData"
     */
    inline uint16 getValidityOfData () const;

    /**
     * Sets the value of the member "ValidityOfData".
     *
     * This gives the validity of the parameters received with this update except the DeviceHandle.
     * It is provided as a bitwise OR of the parameters supported.
     * 0x0000 => None of the parameters are valid.
     * 0x0001 => NumXDeviceKeys is valid.
     * 0x0002 => XDeviceKeysList is valid.
     * 0x0004 => rKeyCapabilities is valid.
     * 0x0008 => VoiceRecognitionSupportInfo is valid.
     * For eg. If rKeyCapabilities and VoiceRecognitionSupportInfo paramters are valid, this value will be set to 0x000C.
     * In this case, HMI should ignore the values received for NumXDeviceKeys and XDeviceKeysList.
     *
     * @param ValidityOfData The value which will be set
     */
    inline void setValidityOfData (uint16 ValidityOfData_);

    // API of field "NumXDeviceKeys"

    static const int kNumXDeviceKeys = 2;

    /**
     * Clears the field "NumXDeviceKeys".
     *
     * The field will be set to its default value. The hasNumXDeviceKeys()
     * method will return false.
     */
    inline void clearNumXDeviceKeys();

    /**
     * Checks whether the field "NumXDeviceKeys" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumXDeviceKeys()). Otherwise it will return false.
     */
    inline bool hasNumXDeviceKeys () const;

    /**
     * Returns the value of the member "NumXDeviceKeys".
     *
     * Total number of records in XDeviceKeysList.This field is valid only if 0x0001 set with ValidityOfData.
     *
     * @return The value of the field "NumXDeviceKeys"
     */
    inline uint16 getNumXDeviceKeys () const;

    /**
     * Sets the value of the member "NumXDeviceKeys".
     *
     * Total number of records in XDeviceKeysList.This field is valid only if 0x0001 set with ValidityOfData.
     *
     * @param NumXDeviceKeys The value which will be set
     */
    inline void setNumXDeviceKeys (uint16 NumXDeviceKeys_);

    // API of field "XDeviceKeysList"

    static const int kXDeviceKeysList = 3;

    /**
     * Clears the field "XDeviceKeysList".
     *
     * The field will be set to its default value. The hasXDeviceKeysList()
     * method will return false.
     */
    inline void clearXDeviceKeysList();

    /**
     * Checks whether the field "XDeviceKeysList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXDeviceKeysList()). Otherwise it will return false.
     */
    inline bool hasXDeviceKeysList () const;

    /**
     * Returns the value of the member "XDeviceKeysList".
     *
     * Provides List of supported XDeviceKeys along with their details.
     * This field is valid only if 0x0002 set with ValidityOfData.
     *
     * @return The value of the field "XDeviceKeysList"
     */
    inline const ::std::vector< ::midw_smartphoneint_fi_types::T_XDeviceKeys >& getXDeviceKeysList () const;

    /**
     * Retrieves the value of the field "XDeviceKeysList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "XDeviceKeysList".
     */
    inline ::std::vector< ::midw_smartphoneint_fi_types::T_XDeviceKeys >& getXDeviceKeysListMutable ();

    /**
     * Sets the value of the member "XDeviceKeysList".
     *
     * Provides List of supported XDeviceKeys along with their details.
     * This field is valid only if 0x0002 set with ValidityOfData.
     *
     * @param XDeviceKeysList The value which will be set
     */
    inline void setXDeviceKeysList (const ::std::vector< ::midw_smartphoneint_fi_types::T_XDeviceKeys >& XDeviceKeysList_);

    // API of field "rKeyCapabilities"

    static const int kRKeyCapabilities = 4;

    /**
     * Clears the field "rKeyCapabilities".
     *
     * The field will be set to its default value. The hasRKeyCapabilities()
     * method will return false.
     */
    inline void clearRKeyCapabilities();

    /**
     * Checks whether the field "rKeyCapabilities" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRKeyCapabilities()). Otherwise it will return false.
     */
    inline bool hasRKeyCapabilities () const;

    /**
     * Returns the value of the member "rKeyCapabilities".
     *
     * Provides Key Capabilities.Note:This field should be used instead of DeviceInfoList.
     * This field is valid only if 0x0004 set with ValidityOfData.
     *
     * @return The value of the field "rKeyCapabilities"
     */
    inline const ::midw_smartphoneint_fi_types::T_KeyCapabilities& getRKeyCapabilities () const;

    /**
     * Retrieves the value of the field "rKeyCapabilities" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rKeyCapabilities".
     */
    inline ::midw_smartphoneint_fi_types::T_KeyCapabilities& getRKeyCapabilitiesMutable ();

    /**
     * Sets the value of the member "rKeyCapabilities".
     *
     * Provides Key Capabilities.Note:This field should be used instead of DeviceInfoList.
     * This field is valid only if 0x0004 set with ValidityOfData.
     *
     * @param rKeyCapabilities The value which will be set
     */
    inline void setRKeyCapabilities (const ::midw_smartphoneint_fi_types::T_KeyCapabilities& rKeyCapabilities_);

    // API of field "VoiceRecognitionSupportInfo"

    static const int kVoiceRecognitionSupportInfo = 5;

    /**
     * Clears the field "VoiceRecognitionSupportInfo".
     *
     * The field will be set to its default value. The hasVoiceRecognitionSupportInfo()
     * method will return false.
     */
    inline void clearVoiceRecognitionSupportInfo();

    /**
     * Checks whether the field "VoiceRecognitionSupportInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceRecognitionSupportInfo()). Otherwise it will return false.
     */
    inline bool hasVoiceRecognitionSupportInfo () const;

    /**
     * Returns the value of the member "VoiceRecognitionSupportInfo".
     *
     * Provides voice recognition support of the ML device.
     * This field is valid only if 0x0008 set with ValidityOfData.
     *
     * @return The value of the field "VoiceRecognitionSupportInfo"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_SupportInfo getVoiceRecognitionSupportInfo () const;

    /**
     * Sets the value of the member "VoiceRecognitionSupportInfo".
     *
     * Provides voice recognition support of the ML device.
     * This field is valid only if 0x0008 set with ValidityOfData.
     *
     * @param VoiceRecognitionSupportInfo The value which will be set
     */
    inline void setVoiceRecognitionSupportInfo (::midw_smartphoneint_fi_types::T_e8_SupportInfo VoiceRecognitionSupportInfo_);

    static const MLServerKeyCapabilitiesStatus &getDefaultInstance();

private:

    static const ::std::vector< ::midw_smartphoneint_fi_types::T_XDeviceKeys >& getT_XDeviceKeysList_DefaultInstance ();

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_ValidityOfData ();

    inline void clear_has_ValidityOfData ();

    inline void set_has_NumXDeviceKeys ();

    inline void clear_has_NumXDeviceKeys ();

    inline void set_has_XDeviceKeysList ();

    inline void clear_has_XDeviceKeysList ();

    inline void set_has_rKeyCapabilities ();

    inline void clear_has_rKeyCapabilities ();

    inline void set_has_VoiceRecognitionSupportInfo ();

    inline void clear_has_VoiceRecognitionSupportInfo ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint32 _DeviceHandle;

    uint16 _ValidityOfData;

    uint16 _NumXDeviceKeys;

    ::std::vector< ::midw_smartphoneint_fi_types::T_XDeviceKeys > _XDeviceKeysList;

    ::midw_smartphoneint_fi_types::T_KeyCapabilities _rKeyCapabilities;

    ::midw_smartphoneint_fi_types::T_e8_SupportInfo _VoiceRecognitionSupportInfo;

};

/**
 * The status message of the property "Dial"
 * This interface is used by the client to inform HMI to start an outgoing call with the provided details(TelephoneNumber and DisplayInfo).
 * Currently this API is used only for MySpin technology.
 */
class DialStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DialStatus ();

    /**
     * Copy constructor
     */
    inline  DialStatus (const DialStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DialStatus (uint32 DeviceHandle_, const ::std::string& TelephoneNumber_, const ::std::string& DisplayContent_);

    /**
     * Destructor
     */
    inline virtual  ~DialStatus();

    /**
     * Assignment operator
     */
    inline DialStatus& operator = (const DialStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DialStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DialStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DialStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DialStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "TelephoneNumber"

    static const int kTelephoneNumber = 1;

    /**
     * Clears the field "TelephoneNumber".
     *
     * The field will be set to its default value. The hasTelephoneNumber()
     * method will return false.
     */
    inline void clearTelephoneNumber();

    /**
     * Checks whether the field "TelephoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTelephoneNumber()). Otherwise it will return false.
     */
    inline bool hasTelephoneNumber () const;

    /**
     * Returns the value of the member "TelephoneNumber".
     *
     * Phone number to be dialled for outgoing call.
     *
     * @return The value of the field "TelephoneNumber"
     */
    inline const ::std::string& getTelephoneNumber () const;

    /**
     * Retrieves the value of the field "TelephoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TelephoneNumber".
     */
    inline ::std::string& getTelephoneNumberMutable ();

    /**
     * Sets the value of the member "TelephoneNumber".
     *
     * Phone number to be dialled for outgoing call.
     *
     * @param TelephoneNumber The value which will be set
     */
    inline void setTelephoneNumber (const ::std::string& TelephoneNumber_);

    /**
     * Sets the value of the member "TelephoneNumber".
     *
     * Phone number to be dialled for outgoing call.
     *
     * @param TelephoneNumber The value which will be set
     */
    inline void setTelephoneNumber (const char* TelephoneNumber_);

    /**
     * Sets the value of the member "TelephoneNumber".
     *
     * Phone number to be dialled for outgoing call.
     *
     * @param TelephoneNumber The value which will be set
     */
    inline void setTelephoneNumber (const char* value, size_t size);

    // API of field "DisplayContent"

    static const int kDisplayContent = 2;

    /**
     * Clears the field "DisplayContent".
     *
     * The field will be set to its default value. The hasDisplayContent()
     * method will return false.
     */
    inline void clearDisplayContent();

    /**
     * Checks whether the field "DisplayContent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayContent()). Otherwise it will return false.
     */
    inline bool hasDisplayContent () const;

    /**
     * Returns the value of the member "DisplayContent".
     *
     * Info to be displayed in HMI(Caller Name or other information related to the Caller).
     * This will be NULL if outgoing call is made from DialPad.
     *
     * @return The value of the field "DisplayContent"
     */
    inline const ::std::string& getDisplayContent () const;

    /**
     * Retrieves the value of the field "DisplayContent" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayContent".
     */
    inline ::std::string& getDisplayContentMutable ();

    /**
     * Sets the value of the member "DisplayContent".
     *
     * Info to be displayed in HMI(Caller Name or other information related to the Caller).
     * This will be NULL if outgoing call is made from DialPad.
     *
     * @param DisplayContent The value which will be set
     */
    inline void setDisplayContent (const ::std::string& DisplayContent_);

    /**
     * Sets the value of the member "DisplayContent".
     *
     * Info to be displayed in HMI(Caller Name or other information related to the Caller).
     * This will be NULL if outgoing call is made from DialPad.
     *
     * @param DisplayContent The value which will be set
     */
    inline void setDisplayContent (const char* DisplayContent_);

    /**
     * Sets the value of the member "DisplayContent".
     *
     * Info to be displayed in HMI(Caller Name or other information related to the Caller).
     * This will be NULL if outgoing call is made from DialPad.
     *
     * @param DisplayContent The value which will be set
     */
    inline void setDisplayContent (const char* value, size_t size);

    static const DialStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_TelephoneNumber ();

    inline void clear_has_TelephoneNumber ();

    inline void set_has_DisplayContent ();

    inline void clear_has_DisplayContent ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::std::string _TelephoneNumber;

    ::std::string _DisplayContent;

};

/**
 * The set message of the property "Dial"
 * This interface is used by the client to inform HMI to start an outgoing call with the provided details(TelephoneNumber and DisplayInfo).
 * Currently this API is used only for MySpin technology.
 * Caller has to set the phone call status initiated by the client
 */
class DialSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DialSet ();

    /**
     * Copy constructor
     */
    inline  DialSet (const DialSet &rhs);

    /**
     * All fields constructor
     */
    inline  DialSet (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_PhoneCallState PhoneCallState_);

    /**
     * Destructor
     */
    inline virtual  ~DialSet();

    /**
     * Assignment operator
     */
    inline DialSet& operator = (const DialSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DialSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DialSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DialSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DialSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "PhoneCallState"

    static const int kPhoneCallState = 1;

    /**
     * Clears the field "PhoneCallState".
     *
     * The field will be set to its default value. The hasPhoneCallState()
     * method will return false.
     */
    inline void clearPhoneCallState();

    /**
     * Checks whether the field "PhoneCallState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneCallState()). Otherwise it will return false.
     */
    inline bool hasPhoneCallState () const;

    /**
     * Returns the value of the member "PhoneCallState".
     *
     * Identifies the Phone Call State.
     *
     * @return The value of the field "PhoneCallState"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_PhoneCallState getPhoneCallState () const;

    /**
     * Sets the value of the member "PhoneCallState".
     *
     * Identifies the Phone Call State.
     *
     * @param PhoneCallState The value which will be set
     */
    inline void setPhoneCallState (::midw_smartphoneint_fi_types::T_e8_PhoneCallState PhoneCallState_);

    static const DialSet &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_PhoneCallState ();

    inline void clear_has_PhoneCallState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_PhoneCallState _PhoneCallState;

};

/**
 * The status message of the property "MediaPlayBackTime"
 * Scope : CarPlay, AAP, Carlife
 * Interface to notify playback time of the current playing media song.
 */
class MediaPlayBackTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaPlayBackTimeStatus ();

    /**
     * Copy constructor
     */
    inline  MediaPlayBackTimeStatus (const MediaPlayBackTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MediaPlayBackTimeStatus (uint32 DeviceHandle_, uint32 TotalPlayTime_, uint32 ElapsedPlayTime_);

    /**
     * Destructor
     */
    inline virtual  ~MediaPlayBackTimeStatus();

    /**
     * Assignment operator
     */
    inline MediaPlayBackTimeStatus& operator = (const MediaPlayBackTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaPlayBackTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaPlayBackTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaPlayBackTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaPlayBackTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "TotalPlayTime"

    static const int kTotalPlayTime = 1;

    /**
     * Clears the field "TotalPlayTime".
     *
     * The field will be set to its default value. The hasTotalPlayTime()
     * method will return false.
     */
    inline void clearTotalPlayTime();

    /**
     * Checks whether the field "TotalPlayTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTotalPlayTime()). Otherwise it will return false.
     */
    inline bool hasTotalPlayTime () const;

    /**
     * Returns the value of the member "TotalPlayTime".
     *
     * Total play time of the media object in seconds. Set to 0xFFFFFFFF, if not valid.
     * Carlife: This field is not populate as current spec is not supporting it.
     *
     * @return The value of the field "TotalPlayTime"
     */
    inline uint32 getTotalPlayTime () const;

    /**
     * Sets the value of the member "TotalPlayTime".
     *
     * Total play time of the media object in seconds. Set to 0xFFFFFFFF, if not valid.
     * Carlife: This field is not populate as current spec is not supporting it.
     *
     * @param TotalPlayTime The value which will be set
     */
    inline void setTotalPlayTime (uint32 TotalPlayTime_);

    // API of field "ElapsedPlayTime"

    static const int kElapsedPlayTime = 2;

    /**
     * Clears the field "ElapsedPlayTime".
     *
     * The field will be set to its default value. The hasElapsedPlayTime()
     * method will return false.
     */
    inline void clearElapsedPlayTime();

    /**
     * Checks whether the field "ElapsedPlayTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElapsedPlayTime()). Otherwise it will return false.
     */
    inline bool hasElapsedPlayTime () const;

    /**
     * Returns the value of the member "ElapsedPlayTime".
     *
     * Elapsed play time of the media object in seconds. Set to 0xFFFFFFFF, if not valid.
     *
     * @return The value of the field "ElapsedPlayTime"
     */
    inline uint32 getElapsedPlayTime () const;

    /**
     * Sets the value of the member "ElapsedPlayTime".
     *
     * Elapsed play time of the media object in seconds. Set to 0xFFFFFFFF, if not valid.
     *
     * @param ElapsedPlayTime The value which will be set
     */
    inline void setElapsedPlayTime (uint32 ElapsedPlayTime_);

    static const MediaPlayBackTimeStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_TotalPlayTime ();

    inline void clear_has_TotalPlayTime ();

    inline void set_has_ElapsedPlayTime ();

    inline void clear_has_ElapsedPlayTime ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    uint32 _TotalPlayTime;

    uint32 _ElapsedPlayTime;

};

/**
 * The status message of the property "ProjectionDeviceAuthorization"
 * Used to notify client about authorization status of projection device. Also used to change the authorization state of a device after user consent action.
 * If usage preference of projection is Enabled, client has to authorize the projection device without user consent.
 * Updates the authorization status only for devices which require user authorization.
 * If device is disconnected before user consent, device would be removed from this list.
 */
class ProjectionDeviceAuthorizationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProjectionDeviceAuthorizationStatus ();

    /**
     * Copy constructor
     */
    inline  ProjectionDeviceAuthorizationStatus (const ProjectionDeviceAuthorizationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ProjectionDeviceAuthorizationStatus (uint16 NumDevices_, const ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceAuthInfo >& DeviceAuthInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~ProjectionDeviceAuthorizationStatus();

    /**
     * Assignment operator
     */
    inline ProjectionDeviceAuthorizationStatus& operator = (const ProjectionDeviceAuthorizationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProjectionDeviceAuthorizationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProjectionDeviceAuthorizationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProjectionDeviceAuthorizationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProjectionDeviceAuthorizationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NumDevices"

    static const int kNumDevices = 0;

    /**
     * Clears the field "NumDevices".
     *
     * The field will be set to its default value. The hasNumDevices()
     * method will return false.
     */
    inline void clearNumDevices();

    /**
     * Checks whether the field "NumDevices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumDevices()). Otherwise it will return false.
     */
    inline bool hasNumDevices () const;

    /**
     * Returns the value of the member "NumDevices".
     *
     * Total number of devices for which the deice authorization information is provided.
     *
     * @return The value of the field "NumDevices"
     */
    inline uint16 getNumDevices () const;

    /**
     * Sets the value of the member "NumDevices".
     *
     * Total number of devices for which the deice authorization information is provided.
     *
     * @param NumDevices The value which will be set
     */
    inline void setNumDevices (uint16 NumDevices_);

    // API of field "DeviceAuthInfoList"

    static const int kDeviceAuthInfoList = 1;

    /**
     * Clears the field "DeviceAuthInfoList".
     *
     * The field will be set to its default value. The hasDeviceAuthInfoList()
     * method will return false.
     */
    inline void clearDeviceAuthInfoList();

    /**
     * Checks whether the field "DeviceAuthInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceAuthInfoList()). Otherwise it will return false.
     */
    inline bool hasDeviceAuthInfoList () const;

    /**
     * Returns the value of the member "DeviceAuthInfoList".
     *
     * List of DeviceAuthInfo records. List will be empty if no devices require authorization.
     *
     * @return The value of the field "DeviceAuthInfoList"
     */
    inline const ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceAuthInfo >& getDeviceAuthInfoList () const;

    /**
     * Retrieves the value of the field "DeviceAuthInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceAuthInfoList".
     */
    inline ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceAuthInfo >& getDeviceAuthInfoListMutable ();

    /**
     * Sets the value of the member "DeviceAuthInfoList".
     *
     * List of DeviceAuthInfo records. List will be empty if no devices require authorization.
     *
     * @param DeviceAuthInfoList The value which will be set
     */
    inline void setDeviceAuthInfoList (const ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceAuthInfo >& DeviceAuthInfoList_);

    static const ProjectionDeviceAuthorizationStatus &getDefaultInstance();

private:

    static const ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceAuthInfo >& getT_DeviceAuthInfoList_DefaultInstance ();

    inline void set_has_NumDevices ();

    inline void clear_has_NumDevices ();

    inline void set_has_DeviceAuthInfoList ();

    inline void clear_has_DeviceAuthInfoList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _NumDevices;

    ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceAuthInfo > _DeviceAuthInfoList;

};

/**
 * The set message of the property "ProjectionDeviceAuthorization"
 * Used to notify client about authorization status of projection device. Also used to change the authorization state of a device after user consent action.
 * If usage preference of projection is Enabled, client has to authorize the projection device without user consent.
 * Used to change the authorization state of a device, starts projection session after user consent
 */
class ProjectionDeviceAuthorizationSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProjectionDeviceAuthorizationSet ();

    /**
     * Copy constructor
     */
    inline  ProjectionDeviceAuthorizationSet (const ProjectionDeviceAuthorizationSet &rhs);

    /**
     * All fields constructor
     */
    inline  ProjectionDeviceAuthorizationSet (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus UserAuthorizationStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ProjectionDeviceAuthorizationSet();

    /**
     * Assignment operator
     */
    inline ProjectionDeviceAuthorizationSet& operator = (const ProjectionDeviceAuthorizationSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProjectionDeviceAuthorizationSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProjectionDeviceAuthorizationSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProjectionDeviceAuthorizationSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProjectionDeviceAuthorizationSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "UserAuthorizationStatus"

    static const int kUserAuthorizationStatus = 1;

    /**
     * Clears the field "UserAuthorizationStatus".
     *
     * The field will be set to its default value. The hasUserAuthorizationStatus()
     * method will return false.
     */
    inline void clearUserAuthorizationStatus();

    /**
     * Checks whether the field "UserAuthorizationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserAuthorizationStatus()). Otherwise it will return false.
     */
    inline bool hasUserAuthorizationStatus () const;

    /**
     * Returns the value of the member "UserAuthorizationStatus".
     *
     * Identifies the user authorization state.
     *
     * @return The value of the field "UserAuthorizationStatus"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus getUserAuthorizationStatus () const;

    /**
     * Sets the value of the member "UserAuthorizationStatus".
     *
     * Identifies the user authorization state.
     *
     * @param UserAuthorizationStatus The value which will be set
     */
    inline void setUserAuthorizationStatus (::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus UserAuthorizationStatus_);

    static const ProjectionDeviceAuthorizationSet &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_UserAuthorizationStatus ();

    inline void clear_has_UserAuthorizationStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus _UserAuthorizationStatus;

};

/**
 * The status message of the property "NavigationStatusInfo"
 * Scope: AAP
 * Interface to update the Projection Navigation status Information(ACTIVE, INACTIVE, UNAVAILABLE) to the client.
 * -- This property is deprecated instead use TurnByTurnInfo.
 */
class NavigationStatusInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavigationStatusInfoStatus ();

    /**
     * Copy constructor
     */
    inline  NavigationStatusInfoStatus (const NavigationStatusInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NavigationStatusInfoStatus (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_, ::midw_smartphoneint_fi_types::T_e8_NavigationAppState NavigationStatus_);

    /**
     * Destructor
     */
    inline virtual  ~NavigationStatusInfoStatus();

    /**
     * Assignment operator
     */
    inline NavigationStatusInfoStatus& operator = (const NavigationStatusInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavigationStatusInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavigationStatusInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavigationStatusInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavigationStatusInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the projection Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the projection Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 1;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Identifies the Device Category.
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Identifies the Device Category.
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    // API of field "NavigationStatus"

    static const int kNavigationStatus = 2;

    /**
     * Clears the field "NavigationStatus".
     *
     * The field will be set to its default value. The hasNavigationStatus()
     * method will return false.
     */
    inline void clearNavigationStatus();

    /**
     * Checks whether the field "NavigationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNavigationStatus()). Otherwise it will return false.
     */
    inline bool hasNavigationStatus () const;

    /**
     * Returns the value of the member "NavigationStatus".
     *
     * Projection Navigation Status Information.
     *
     * @return The value of the field "NavigationStatus"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_NavigationAppState getNavigationStatus () const;

    /**
     * Sets the value of the member "NavigationStatus".
     *
     * Projection Navigation Status Information.
     *
     * @param NavigationStatus The value which will be set
     */
    inline void setNavigationStatus (::midw_smartphoneint_fi_types::T_e8_NavigationAppState NavigationStatus_);

    static const NavigationStatusInfoStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    inline void set_has_NavigationStatus ();

    inline void clear_has_NavigationStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

    ::midw_smartphoneint_fi_types::T_e8_NavigationAppState _NavigationStatus;

};

/**
 * The status message of the property "NavigationNextTurnData"
 * Scope: AAP
 * Updates Turn-By-Turn Projection Navigation Information to the client.
 * -- This property is deprecated instead use TurnByTurnInfo.
 */
class NavigationNextTurnDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavigationNextTurnDataStatus ();

    /**
     * Copy constructor
     */
    inline  NavigationNextTurnDataStatus (const NavigationNextTurnDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NavigationNextTurnDataStatus (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_, const ::std::string& RoadName_, ::midw_smartphoneint_fi_types::T_e8_TurnSide TurnSide_, ::midw_smartphoneint_fi_types::T_e8_NextTurnEvent NextTurnEvent_, const ::std::string& Image_, int32 TurnAngle_, int32 TurnNumber_);

    /**
     * Destructor
     */
    inline virtual  ~NavigationNextTurnDataStatus();

    /**
     * Assignment operator
     */
    inline NavigationNextTurnDataStatus& operator = (const NavigationNextTurnDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavigationNextTurnDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavigationNextTurnDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavigationNextTurnDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavigationNextTurnDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the projection Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the projection Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 1;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Identifies the Device Category.
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Identifies the Device Category.
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    // API of field "RoadName"

    static const int kRoadName = 2;

    /**
     * Clears the field "RoadName".
     *
     * The field will be set to its default value. The hasRoadName()
     * method will return false.
     */
    inline void clearRoadName();

    /**
     * Checks whether the field "RoadName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoadName()). Otherwise it will return false.
     */
    inline bool hasRoadName () const;

    /**
     * Returns the value of the member "RoadName".
     *
     * Identifies name of the Road.
     *
     * @return The value of the field "RoadName"
     */
    inline const ::std::string& getRoadName () const;

    /**
     * Retrieves the value of the field "RoadName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RoadName".
     */
    inline ::std::string& getRoadNameMutable ();

    /**
     * Sets the value of the member "RoadName".
     *
     * Identifies name of the Road.
     *
     * @param RoadName The value which will be set
     */
    inline void setRoadName (const ::std::string& RoadName_);

    /**
     * Sets the value of the member "RoadName".
     *
     * Identifies name of the Road.
     *
     * @param RoadName The value which will be set
     */
    inline void setRoadName (const char* RoadName_);

    /**
     * Sets the value of the member "RoadName".
     *
     * Identifies name of the Road.
     *
     * @param RoadName The value which will be set
     */
    inline void setRoadName (const char* value, size_t size);

    // API of field "TurnSide"

    static const int kTurnSide = 3;

    /**
     * Clears the field "TurnSide".
     *
     * The field will be set to its default value. The hasTurnSide()
     * method will return false.
     */
    inline void clearTurnSide();

    /**
     * Checks whether the field "TurnSide" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTurnSide()). Otherwise it will return false.
     */
    inline bool hasTurnSide () const;

    /**
     * Returns the value of the member "TurnSide".
     *
     * Indicates the turn direction
     *
     * @return The value of the field "TurnSide"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_TurnSide getTurnSide () const;

    /**
     * Sets the value of the member "TurnSide".
     *
     * Indicates the turn direction
     *
     * @param TurnSide The value which will be set
     */
    inline void setTurnSide (::midw_smartphoneint_fi_types::T_e8_TurnSide TurnSide_);

    // API of field "NextTurnEvent"

    static const int kNextTurnEvent = 4;

    /**
     * Clears the field "NextTurnEvent".
     *
     * The field will be set to its default value. The hasNextTurnEvent()
     * method will return false.
     */
    inline void clearNextTurnEvent();

    /**
     * Checks whether the field "NextTurnEvent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextTurnEvent()). Otherwise it will return false.
     */
    inline bool hasNextTurnEvent () const;

    /**
     * Returns the value of the member "NextTurnEvent".
     *
     * Indicates the turn type
     *
     * @return The value of the field "NextTurnEvent"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_NextTurnEvent getNextTurnEvent () const;

    /**
     * Sets the value of the member "NextTurnEvent".
     *
     * Indicates the turn type
     *
     * @param NextTurnEvent The value which will be set
     */
    inline void setNextTurnEvent (::midw_smartphoneint_fi_types::T_e8_NextTurnEvent NextTurnEvent_);

    // API of field "Image"

    static const int kImage = 5;

    /**
     * Clears the field "Image".
     *
     * The field will be set to its default value. The hasImage()
     * method will return false.
     */
    inline void clearImage();

    /**
     * Checks whether the field "Image" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImage()). Otherwise it will return false.
     */
    inline bool hasImage () const;

    /**
     * Returns the value of the member "Image".
     *
     * Icon image in PNG format for TBT event.
     * Set to NULL if Icon is not available.
     *
     * @return The value of the field "Image"
     */
    inline const ::std::string& getImage () const;

    /**
     * Retrieves the value of the field "Image" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Image".
     */
    inline ::std::string& getImageMutable ();

    /**
     * Sets the value of the member "Image".
     *
     * Icon image in PNG format for TBT event.
     * Set to NULL if Icon is not available.
     *
     * @param Image The value which will be set
     */
    inline void setImage (const ::std::string& Image_);

    /**
     * Sets the value of the member "Image".
     *
     * Icon image in PNG format for TBT event.
     * Set to NULL if Icon is not available.
     *
     * @param Image The value which will be set
     */
    inline void setImage (const char* Image_);

    /**
     * Sets the value of the member "Image".
     *
     * Icon image in PNG format for TBT event.
     * Set to NULL if Icon is not available.
     *
     * @param Image The value which will be set
     */
    inline void setImage (const char* value, size_t size);

    // API of field "TurnAngle"

    static const int kTurnAngle = 6;

    /**
     * Clears the field "TurnAngle".
     *
     * The field will be set to its default value. The hasTurnAngle()
     * method will return false.
     */
    inline void clearTurnAngle();

    /**
     * Checks whether the field "TurnAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTurnAngle()). Otherwise it will return false.
     */
    inline bool hasTurnAngle () const;

    /**
     * Returns the value of the member "TurnAngle".
     *
     * Indicates turn angle in degrees between the roundabout entry and exit (0..359).
     * Only used for turn event type ROUNDABOUT_ENTER_AND_EXIT, -1 otherwise.
     *
     * @return The value of the field "TurnAngle"
     */
    inline int32 getTurnAngle () const;

    /**
     * Sets the value of the member "TurnAngle".
     *
     * Indicates turn angle in degrees between the roundabout entry and exit (0..359).
     * Only used for turn event type ROUNDABOUT_ENTER_AND_EXIT, -1 otherwise.
     *
     * @param TurnAngle The value which will be set
     */
    inline void setTurnAngle (int32 TurnAngle_);

    // API of field "TurnNumber"

    static const int kTurnNumber = 7;

    /**
     * Clears the field "TurnNumber".
     *
     * The field will be set to its default value. The hasTurnNumber()
     * method will return false.
     */
    inline void clearTurnNumber();

    /**
     * Checks whether the field "TurnNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTurnNumber()). Otherwise it will return false.
     */
    inline bool hasTurnNumber () const;

    /**
     * Returns the value of the member "TurnNumber".
     *
     * Indicates turn number, counting around from the roundabout entry to the exit.
     * Only used for turn event type ROUNDABOUT_ENTER_AND_EXIT, -1 otherwise.
     *
     * @return The value of the field "TurnNumber"
     */
    inline int32 getTurnNumber () const;

    /**
     * Sets the value of the member "TurnNumber".
     *
     * Indicates turn number, counting around from the roundabout entry to the exit.
     * Only used for turn event type ROUNDABOUT_ENTER_AND_EXIT, -1 otherwise.
     *
     * @param TurnNumber The value which will be set
     */
    inline void setTurnNumber (int32 TurnNumber_);

    static const NavigationNextTurnDataStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    inline void set_has_RoadName ();

    inline void clear_has_RoadName ();

    inline void set_has_TurnSide ();

    inline void clear_has_TurnSide ();

    inline void set_has_NextTurnEvent ();

    inline void clear_has_NextTurnEvent ();

    inline void set_has_Image ();

    inline void clear_has_Image ();

    inline void set_has_TurnAngle ();

    inline void clear_has_TurnAngle ();

    inline void set_has_TurnNumber ();

    inline void clear_has_TurnNumber ();

    uint32 _has_bits_[ (8 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

    ::std::string _RoadName;

    ::midw_smartphoneint_fi_types::T_e8_TurnSide _TurnSide;

    ::midw_smartphoneint_fi_types::T_e8_NextTurnEvent _NextTurnEvent;

    ::std::string _Image;

    int32 _TurnAngle;

    int32 _TurnNumber;

};

/**
 * The status message of the property "NavigationNextTurnDistanceData"
 * Scope: AAP
 * Interface to update the Projection Navigation Next Turn Distance Data to the clients.
 * -- This property is deprecated instead use TurnByTurnInfo.
 */
class NavigationNextTurnDistanceDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavigationNextTurnDistanceDataStatus ();

    /**
     * Copy constructor
     */
    inline  NavigationNextTurnDistanceDataStatus (const NavigationNextTurnDistanceDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NavigationNextTurnDistanceDataStatus (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_, int32 DistanceInMeters_, int32 TimeInSec_, int32 DistanceToManeuver_, ::midw_smartphoneint_fi_types::T_e8_ManeuverDistanceUnits ManeuverDistanceUnits_);

    /**
     * Destructor
     */
    inline virtual  ~NavigationNextTurnDistanceDataStatus();

    /**
     * Assignment operator
     */
    inline NavigationNextTurnDistanceDataStatus& operator = (const NavigationNextTurnDistanceDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavigationNextTurnDistanceDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavigationNextTurnDistanceDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavigationNextTurnDistanceDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavigationNextTurnDistanceDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the projection Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the projection Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 1;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Identifies the Device Category.
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Identifies the Device Category.
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    // API of field "DistanceInMeters"

    static const int kDistanceInMeters = 2;

    /**
     * Clears the field "DistanceInMeters".
     *
     * The field will be set to its default value. The hasDistanceInMeters()
     * method will return false.
     */
    inline void clearDistanceInMeters();

    /**
     * Checks whether the field "DistanceInMeters" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceInMeters()). Otherwise it will return false.
     */
    inline bool hasDistanceInMeters () const;

    /**
     * Returns the value of the member "DistanceInMeters".
     *
     * Indicates Distance to next turn event, in meters.
     *
     * @return The value of the field "DistanceInMeters"
     */
    inline int32 getDistanceInMeters () const;

    /**
     * Sets the value of the member "DistanceInMeters".
     *
     * Indicates Distance to next turn event, in meters.
     *
     * @param DistanceInMeters The value which will be set
     */
    inline void setDistanceInMeters (int32 DistanceInMeters_);

    // API of field "TimeInSec"

    static const int kTimeInSec = 3;

    /**
     * Clears the field "TimeInSec".
     *
     * The field will be set to its default value. The hasTimeInSec()
     * method will return false.
     */
    inline void clearTimeInSec();

    /**
     * Checks whether the field "TimeInSec" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeInSec()). Otherwise it will return false.
     */
    inline bool hasTimeInSec () const;

    /**
     * Returns the value of the member "TimeInSec".
     *
     * Indicates Time to next turn event, in seconds.
     *
     * @return The value of the field "TimeInSec"
     */
    inline int32 getTimeInSec () const;

    /**
     * Sets the value of the member "TimeInSec".
     *
     * Indicates Time to next turn event, in seconds.
     *
     * @param TimeInSec The value which will be set
     */
    inline void setTimeInSec (int32 TimeInSec_);

    // API of field "DistanceToManeuver"

    static const int kDistanceToManeuver = 4;

    /**
     * Clears the field "DistanceToManeuver".
     *
     * The field will be set to its default value. The hasDistanceToManeuver()
     * method will return false.
     */
    inline void clearDistanceToManeuver();

    /**
     * Checks whether the field "DistanceToManeuver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceToManeuver()). Otherwise it will return false.
     */
    inline bool hasDistanceToManeuver () const;

    /**
     * Returns the value of the member "DistanceToManeuver".
     *
     * Indicates the distance to a next turn which is rounded off and converted to units specified by DistanceToManeuver.
     *
     * @return The value of the field "DistanceToManeuver"
     */
    inline int32 getDistanceToManeuver () const;

    /**
     * Sets the value of the member "DistanceToManeuver".
     *
     * Indicates the distance to a next turn which is rounded off and converted to units specified by DistanceToManeuver.
     *
     * @param DistanceToManeuver The value which will be set
     */
    inline void setDistanceToManeuver (int32 DistanceToManeuver_);

    // API of field "ManeuverDistanceUnits"

    static const int kManeuverDistanceUnits = 5;

    /**
     * Clears the field "ManeuverDistanceUnits".
     *
     * The field will be set to its default value. The hasManeuverDistanceUnits()
     * method will return false.
     */
    inline void clearManeuverDistanceUnits();

    /**
     * Checks whether the field "ManeuverDistanceUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManeuverDistanceUnits()). Otherwise it will return false.
     */
    inline bool hasManeuverDistanceUnits () const;

    /**
     * Returns the value of the member "ManeuverDistanceUnits".
     *
     * Indicates Distance in various units.It can be in meters,kilometers,miles,feet and yards
     *
     * @return The value of the field "ManeuverDistanceUnits"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ManeuverDistanceUnits getManeuverDistanceUnits () const;

    /**
     * Sets the value of the member "ManeuverDistanceUnits".
     *
     * Indicates Distance in various units.It can be in meters,kilometers,miles,feet and yards
     *
     * @param ManeuverDistanceUnits The value which will be set
     */
    inline void setManeuverDistanceUnits (::midw_smartphoneint_fi_types::T_e8_ManeuverDistanceUnits ManeuverDistanceUnits_);

    static const NavigationNextTurnDistanceDataStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    inline void set_has_DistanceInMeters ();

    inline void clear_has_DistanceInMeters ();

    inline void set_has_TimeInSec ();

    inline void clear_has_TimeInSec ();

    inline void set_has_DistanceToManeuver ();

    inline void clear_has_DistanceToManeuver ();

    inline void set_has_ManeuverDistanceUnits ();

    inline void clear_has_ManeuverDistanceUnits ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

    int32 _DistanceInMeters;

    int32 _TimeInSec;

    int32 _DistanceToManeuver;

    ::midw_smartphoneint_fi_types::T_e8_ManeuverDistanceUnits _ManeuverDistanceUnits;

};

/**
 * The status message of the property "AAPNotificationEvent"
 * Scope: AAP
 * Interface to provide details of the notification received from the projection device
 */
class AAPNotificationEventStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AAPNotificationEventStatus ();

    /**
     * Copy constructor
     */
    inline  AAPNotificationEventStatus (const AAPNotificationEventStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AAPNotificationEventStatus (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_, const ::std::string& AAPNotificationId_, const ::std::string& NotificationText_, const ::std::vector< uint8 >& NotificationIcon_);

    /**
     * Destructor
     */
    inline virtual  ~AAPNotificationEventStatus();

    /**
     * Assignment operator
     */
    inline AAPNotificationEventStatus& operator = (const AAPNotificationEventStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AAPNotificationEventStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AAPNotificationEventStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AAPNotificationEventStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AAPNotificationEventStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the projection Device.The id of the notification that was acknowledged
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the projection Device.The id of the notification that was acknowledged
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 1;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Identifies the Device Category.
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Identifies the Device Category.
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    // API of field "AAPNotificationId"

    static const int kAAPNotificationId = 2;

    /**
     * Clears the field "AAPNotificationId".
     *
     * The field will be set to its default value. The hasAAPNotificationId()
     * method will return false.
     */
    inline void clearAAPNotificationId();

    /**
     * Checks whether the field "AAPNotificationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAAPNotificationId()). Otherwise it will return false.
     */
    inline bool hasAAPNotificationId () const;

    /**
     * Returns the value of the member "AAPNotificationId".
     *
     * Unique identifier for this notification. Set to NULL if Identifier is not available.
     * If Identifier field is set to NULL, acknowledgement for this notification is not required.
     *
     * @return The value of the field "AAPNotificationId"
     */
    inline const ::std::string& getAAPNotificationId () const;

    /**
     * Retrieves the value of the field "AAPNotificationId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AAPNotificationId".
     */
    inline ::std::string& getAAPNotificationIdMutable ();

    /**
     * Sets the value of the member "AAPNotificationId".
     *
     * Unique identifier for this notification. Set to NULL if Identifier is not available.
     * If Identifier field is set to NULL, acknowledgement for this notification is not required.
     *
     * @param AAPNotificationId The value which will be set
     */
    inline void setAAPNotificationId (const ::std::string& AAPNotificationId_);

    /**
     * Sets the value of the member "AAPNotificationId".
     *
     * Unique identifier for this notification. Set to NULL if Identifier is not available.
     * If Identifier field is set to NULL, acknowledgement for this notification is not required.
     *
     * @param AAPNotificationId The value which will be set
     */
    inline void setAAPNotificationId (const char* AAPNotificationId_);

    /**
     * Sets the value of the member "AAPNotificationId".
     *
     * Unique identifier for this notification. Set to NULL if Identifier is not available.
     * If Identifier field is set to NULL, acknowledgement for this notification is not required.
     *
     * @param AAPNotificationId The value which will be set
     */
    inline void setAAPNotificationId (const char* value, size_t size);

    // API of field "NotificationText"

    static const int kNotificationText = 3;

    /**
     * Clears the field "NotificationText".
     *
     * The field will be set to its default value. The hasNotificationText()
     * method will return false.
     */
    inline void clearNotificationText();

    /**
     * Checks whether the field "NotificationText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotificationText()). Otherwise it will return false.
     */
    inline bool hasNotificationText () const;

    /**
     * Returns the value of the member "NotificationText".
     *
     * Text of this notification to be displayed. Set to NULL if Notification Text is not available.
     *
     * @return The value of the field "NotificationText"
     */
    inline const ::std::string& getNotificationText () const;

    /**
     * Retrieves the value of the field "NotificationText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NotificationText".
     */
    inline ::std::string& getNotificationTextMutable ();

    /**
     * Sets the value of the member "NotificationText".
     *
     * Text of this notification to be displayed. Set to NULL if Notification Text is not available.
     *
     * @param NotificationText The value which will be set
     */
    inline void setNotificationText (const ::std::string& NotificationText_);

    /**
     * Sets the value of the member "NotificationText".
     *
     * Text of this notification to be displayed. Set to NULL if Notification Text is not available.
     *
     * @param NotificationText The value which will be set
     */
    inline void setNotificationText (const char* NotificationText_);

    /**
     * Sets the value of the member "NotificationText".
     *
     * Text of this notification to be displayed. Set to NULL if Notification Text is not available.
     *
     * @param NotificationText The value which will be set
     */
    inline void setNotificationText (const char* value, size_t size);

    // API of field "NotificationIcon"

    static const int kNotificationIcon = 4;

    /**
     * Clears the field "NotificationIcon".
     *
     * The field will be set to its default value. The hasNotificationIcon()
     * method will return false.
     */
    inline void clearNotificationIcon();

    /**
     * Checks whether the field "NotificationIcon" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotificationIcon()). Otherwise it will return false.
     */
    inline bool hasNotificationIcon () const;

    /**
     * Returns the value of the member "NotificationIcon".
     *
     * Byte Data Stream from the icon image file. Icon of this notification to be displayed.
     * Set to NULL if Notification Icon is not available.
     *
     * @return The value of the field "NotificationIcon"
     */
    inline const ::std::vector< uint8 >& getNotificationIcon () const;

    /**
     * Retrieves the value of the field "NotificationIcon" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NotificationIcon".
     */
    inline ::std::vector< uint8 >& getNotificationIconMutable ();

    /**
     * Sets the value of the member "NotificationIcon".
     *
     * Byte Data Stream from the icon image file. Icon of this notification to be displayed.
     * Set to NULL if Notification Icon is not available.
     *
     * @param NotificationIcon The value which will be set
     */
    inline void setNotificationIcon (const ::std::vector< uint8 >& NotificationIcon_);

    static const AAPNotificationEventStatus &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    inline void set_has_AAPNotificationId ();

    inline void clear_has_AAPNotificationId ();

    inline void set_has_NotificationText ();

    inline void clear_has_NotificationText ();

    inline void set_has_NotificationIcon ();

    inline void clear_has_NotificationIcon ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

    ::std::string _AAPNotificationId;

    ::std::string _NotificationText;

    ::std::vector< uint8 > _NotificationIcon;

};

/**
 * The set message of the property "AAPNotificationEvent"
 * Scope: AAP
 * Interface to provide details of the notification received from the projection device
 * Caller has to acknowledge the notification received from the projection device
 */
class AAPNotificationEventSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AAPNotificationEventSet ();

    /**
     * Copy constructor
     */
    inline  AAPNotificationEventSet (const AAPNotificationEventSet &rhs);

    /**
     * All fields constructor
     */
    inline  AAPNotificationEventSet (const ::std::string& AAPNotificationId_);

    /**
     * Destructor
     */
    inline virtual  ~AAPNotificationEventSet();

    /**
     * Assignment operator
     */
    inline AAPNotificationEventSet& operator = (const AAPNotificationEventSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AAPNotificationEventSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AAPNotificationEventSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AAPNotificationEventSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AAPNotificationEventSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AAPNotificationId"

    static const int kAAPNotificationId = 0;

    /**
     * Clears the field "AAPNotificationId".
     *
     * The field will be set to its default value. The hasAAPNotificationId()
     * method will return false.
     */
    inline void clearAAPNotificationId();

    /**
     * Checks whether the field "AAPNotificationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAAPNotificationId()). Otherwise it will return false.
     */
    inline bool hasAAPNotificationId () const;

    /**
     * Returns the value of the member "AAPNotificationId".
     *
     * Unique identifier of the notification that was acknowledged.
     *
     * @return The value of the field "AAPNotificationId"
     */
    inline const ::std::string& getAAPNotificationId () const;

    /**
     * Retrieves the value of the field "AAPNotificationId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AAPNotificationId".
     */
    inline ::std::string& getAAPNotificationIdMutable ();

    /**
     * Sets the value of the member "AAPNotificationId".
     *
     * Unique identifier of the notification that was acknowledged.
     *
     * @param AAPNotificationId The value which will be set
     */
    inline void setAAPNotificationId (const ::std::string& AAPNotificationId_);

    /**
     * Sets the value of the member "AAPNotificationId".
     *
     * Unique identifier of the notification that was acknowledged.
     *
     * @param AAPNotificationId The value which will be set
     */
    inline void setAAPNotificationId (const char* AAPNotificationId_);

    /**
     * Sets the value of the member "AAPNotificationId".
     *
     * Unique identifier of the notification that was acknowledged.
     *
     * @param AAPNotificationId The value which will be set
     */
    inline void setAAPNotificationId (const char* value, size_t size);

    static const AAPNotificationEventSet &getDefaultInstance();

private:

    inline void set_has_AAPNotificationId ();

    inline void clear_has_AAPNotificationId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _AAPNotificationId;

};

/**
 * The status message of the property "mySPINBluetoothVoiceRecInfo"
 * This interface is used for mySPIN VR for Android Phones to inform HMI
 * a) If Bluetooth VR session can be started based on BT Match Status
 * b) The current request to process w.r.t BT Voice Recognition
 *
 * HMI should use this interface to set the response w.r.t the request made by SPI.
 */
class MySPINBluetoothVoiceRecInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MySPINBluetoothVoiceRecInfoStatus ();

    /**
     * Copy constructor
     */
    inline  MySPINBluetoothVoiceRecInfoStatus (const MySPINBluetoothVoiceRecInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MySPINBluetoothVoiceRecInfoStatus (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_BTVoiceRecRequest BTVoiceRecRequest_);

    /**
     * Destructor
     */
    inline virtual  ~MySPINBluetoothVoiceRecInfoStatus();

    /**
     * Assignment operator
     */
    inline MySPINBluetoothVoiceRecInfoStatus& operator = (const MySPINBluetoothVoiceRecInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MySPINBluetoothVoiceRecInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MySPINBluetoothVoiceRecInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MySPINBluetoothVoiceRecInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MySPINBluetoothVoiceRecInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "BTVoiceRecRequest"

    static const int kBTVoiceRecRequest = 1;

    /**
     * Clears the field "BTVoiceRecRequest".
     *
     * The field will be set to its default value. The hasBTVoiceRecRequest()
     * method will return false.
     */
    inline void clearBTVoiceRecRequest();

    /**
     * Checks whether the field "BTVoiceRecRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTVoiceRecRequest()). Otherwise it will return false.
     */
    inline bool hasBTVoiceRecRequest () const;

    /**
     * Returns the value of the member "BTVoiceRecRequest".
     *
     * Request Info for BT VR session.
     *
     * @return The value of the field "BTVoiceRecRequest"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_BTVoiceRecRequest getBTVoiceRecRequest () const;

    /**
     * Sets the value of the member "BTVoiceRecRequest".
     *
     * Request Info for BT VR session.
     *
     * @param BTVoiceRecRequest The value which will be set
     */
    inline void setBTVoiceRecRequest (::midw_smartphoneint_fi_types::T_e8_BTVoiceRecRequest BTVoiceRecRequest_);

    static const MySPINBluetoothVoiceRecInfoStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_BTVoiceRecRequest ();

    inline void clear_has_BTVoiceRecRequest ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_BTVoiceRecRequest _BTVoiceRecRequest;

};

/**
 * The set message of the property "mySPINBluetoothVoiceRecInfo"
 * This interface is used for mySPIN VR for Android Phones to inform HMI
 * a) If Bluetooth VR session can be started based on BT Match Status
 * b) The current request to process w.r.t BT Voice Recognition
 *
 * HMI should use this interface to set the response w.r.t the request made by SPI.
 * Caller has to set the response to the request made for the BT VR session
 */
class MySPINBluetoothVoiceRecInfoSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MySPINBluetoothVoiceRecInfoSet ();

    /**
     * Copy constructor
     */
    inline  MySPINBluetoothVoiceRecInfoSet (const MySPINBluetoothVoiceRecInfoSet &rhs);

    /**
     * All fields constructor
     */
    inline  MySPINBluetoothVoiceRecInfoSet (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_BTVoiceRecRequestResponse BTVoiceRecReqResponse_);

    /**
     * Destructor
     */
    inline virtual  ~MySPINBluetoothVoiceRecInfoSet();

    /**
     * Assignment operator
     */
    inline MySPINBluetoothVoiceRecInfoSet& operator = (const MySPINBluetoothVoiceRecInfoSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MySPINBluetoothVoiceRecInfoSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MySPINBluetoothVoiceRecInfoSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MySPINBluetoothVoiceRecInfoSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MySPINBluetoothVoiceRecInfoSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "BTVoiceRecReqResponse"

    static const int kBTVoiceRecReqResponse = 1;

    /**
     * Clears the field "BTVoiceRecReqResponse".
     *
     * The field will be set to its default value. The hasBTVoiceRecReqResponse()
     * method will return false.
     */
    inline void clearBTVoiceRecReqResponse();

    /**
     * Checks whether the field "BTVoiceRecReqResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTVoiceRecReqResponse()). Otherwise it will return false.
     */
    inline bool hasBTVoiceRecReqResponse () const;

    /**
     * Returns the value of the member "BTVoiceRecReqResponse".
     *
     * Identifies the response to the request made.
     *
     * @return The value of the field "BTVoiceRecReqResponse"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_BTVoiceRecRequestResponse getBTVoiceRecReqResponse () const;

    /**
     * Sets the value of the member "BTVoiceRecReqResponse".
     *
     * Identifies the response to the request made.
     *
     * @param BTVoiceRecReqResponse The value which will be set
     */
    inline void setBTVoiceRecReqResponse (::midw_smartphoneint_fi_types::T_e8_BTVoiceRecRequestResponse BTVoiceRecReqResponse_);

    static const MySPINBluetoothVoiceRecInfoSet &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_BTVoiceRecReqResponse ();

    inline void clear_has_BTVoiceRecReqResponse ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_BTVoiceRecRequestResponse _BTVoiceRecReqResponse;

};

/**
 * The status message of the property "TechnologySelection"
 * Used to notify client about device connection when the device usage preference setting is USER_CONF_REQD.
 * The client can choose the required technology for selection
 * Updates the authorization status only for devices which require user authorization.
 * If device is disconnected before user consent, device would be removed from this list.
 */
class TechnologySelectionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TechnologySelectionStatus ();

    /**
     * Copy constructor
     */
    inline  TechnologySelectionStatus (const TechnologySelectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TechnologySelectionStatus (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory SelectedTechnology_, ::midw_smartphoneint_fi_types::T_e8_DeviceType DeviceType_);

    /**
     * Destructor
     */
    inline virtual  ~TechnologySelectionStatus();

    /**
     * Assignment operator
     */
    inline TechnologySelectionStatus& operator = (const TechnologySelectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TechnologySelectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TechnologySelectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TechnologySelectionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TechnologySelectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "SelectedTechnology"

    static const int kSelectedTechnology = 1;

    /**
     * Clears the field "SelectedTechnology".
     *
     * The field will be set to its default value. The hasSelectedTechnology()
     * method will return false.
     */
    inline void clearSelectedTechnology();

    /**
     * Checks whether the field "SelectedTechnology" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelectedTechnology()). Otherwise it will return false.
     */
    inline bool hasSelectedTechnology () const;

    /**
     * Returns the value of the member "SelectedTechnology".
     *
     * Indicates current preference. Set to DEV_TYPE_UNKNOWN if no preference is set
     *
     * @return The value of the field "SelectedTechnology"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getSelectedTechnology () const;

    /**
     * Sets the value of the member "SelectedTechnology".
     *
     * Indicates current preference. Set to DEV_TYPE_UNKNOWN if no preference is set
     *
     * @param SelectedTechnology The value which will be set
     */
    inline void setSelectedTechnology (::midw_smartphoneint_fi_types::T_e8_DeviceCategory SelectedTechnology_);

    // API of field "DeviceType"

    static const int kDeviceType = 2;

    /**
     * Clears the field "DeviceType".
     *
     * The field will be set to its default value. The hasDeviceType()
     * method will return false.
     */
    inline void clearDeviceType();

    /**
     * Checks whether the field "DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceType()). Otherwise it will return false.
     */
    inline bool hasDeviceType () const;

    /**
     * Returns the value of the member "DeviceType".
     *
     * Identifies the Device Type(Android/Apple device).
     *
     * @return The value of the field "DeviceType"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceType getDeviceType () const;

    /**
     * Sets the value of the member "DeviceType".
     *
     * Identifies the Device Type(Android/Apple device).
     *
     * @param DeviceType The value which will be set
     */
    inline void setDeviceType (::midw_smartphoneint_fi_types::T_e8_DeviceType DeviceType_);

    static const TechnologySelectionStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_SelectedTechnology ();

    inline void clear_has_SelectedTechnology ();

    inline void set_has_DeviceType ();

    inline void clear_has_DeviceType ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _SelectedTechnology;

    ::midw_smartphoneint_fi_types::T_e8_DeviceType _DeviceType;

};

/**
 * The set message of the property "TechnologySelection"
 * Used to notify client about device connection when the device usage preference setting is USER_CONF_REQD.
 * The client can choose the required technology for selection
 * Can be used by client to set the required technology for device selection. This will automatically trigger device selection
 * with the set device technology
 */
class TechnologySelectionSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TechnologySelectionSet ();

    /**
     * Copy constructor
     */
    inline  TechnologySelectionSet (const TechnologySelectionSet &rhs);

    /**
     * All fields constructor
     */
    inline  TechnologySelectionSet (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory SelectedTechnology_);

    /**
     * Destructor
     */
    inline virtual  ~TechnologySelectionSet();

    /**
     * Assignment operator
     */
    inline TechnologySelectionSet& operator = (const TechnologySelectionSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TechnologySelectionSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TechnologySelectionSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TechnologySelectionSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TechnologySelectionSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "SelectedTechnology"

    static const int kSelectedTechnology = 1;

    /**
     * Clears the field "SelectedTechnology".
     *
     * The field will be set to its default value. The hasSelectedTechnology()
     * method will return false.
     */
    inline void clearSelectedTechnology();

    /**
     * Checks whether the field "SelectedTechnology" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelectedTechnology()). Otherwise it will return false.
     */
    inline bool hasSelectedTechnology () const;

    /**
     * Returns the value of the member "SelectedTechnology".
     *
     * Technology client wishes to select, Can be set to DEV_TYPE_DEFAULT if device will not be used for any technology
     *
     * @return The value of the field "SelectedTechnology"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getSelectedTechnology () const;

    /**
     * Sets the value of the member "SelectedTechnology".
     *
     * Technology client wishes to select, Can be set to DEV_TYPE_DEFAULT if device will not be used for any technology
     *
     * @param SelectedTechnology The value which will be set
     */
    inline void setSelectedTechnology (::midw_smartphoneint_fi_types::T_e8_DeviceCategory SelectedTechnology_);

    static const TechnologySelectionSet &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_SelectedTechnology ();

    inline void clear_has_SelectedTechnology ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _SelectedTechnology;

};

/**
 * The status message of the property "WiFiCredentials"
 * Scope: Carplay over wireless for now.
 * Interface to get the WiFi Credentials of the Access Point.
 */
class WiFiCredentialsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WiFiCredentialsStatus ();

    /**
     * Copy constructor
     */
    inline  WiFiCredentialsStatus (const WiFiCredentialsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WiFiCredentialsStatus (const ::midw_smartphoneint_fi_types::T_WiFiAPCredentials& AccessoryWiFiAPCredentials_);

    /**
     * Destructor
     */
    inline virtual  ~WiFiCredentialsStatus();

    /**
     * Assignment operator
     */
    inline WiFiCredentialsStatus& operator = (const WiFiCredentialsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WiFiCredentialsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WiFiCredentialsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WiFiCredentialsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WiFiCredentialsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AccessoryWiFiAPCredentials"

    static const int kAccessoryWiFiAPCredentials = 0;

    /**
     * Clears the field "AccessoryWiFiAPCredentials".
     *
     * The field will be set to its default value. The hasAccessoryWiFiAPCredentials()
     * method will return false.
     */
    inline void clearAccessoryWiFiAPCredentials();

    /**
     * Checks whether the field "AccessoryWiFiAPCredentials" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccessoryWiFiAPCredentials()). Otherwise it will return false.
     */
    inline bool hasAccessoryWiFiAPCredentials () const;

    /**
     * Returns the value of the member "AccessoryWiFiAPCredentials".
     *
     * Active SPI Wi-Fi Access Point credentials of Accessory.
     *
     * @return The value of the field "AccessoryWiFiAPCredentials"
     */
    inline const ::midw_smartphoneint_fi_types::T_WiFiAPCredentials& getAccessoryWiFiAPCredentials () const;

    /**
     * Retrieves the value of the field "AccessoryWiFiAPCredentials" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AccessoryWiFiAPCredentials".
     */
    inline ::midw_smartphoneint_fi_types::T_WiFiAPCredentials& getAccessoryWiFiAPCredentialsMutable ();

    /**
     * Sets the value of the member "AccessoryWiFiAPCredentials".
     *
     * Active SPI Wi-Fi Access Point credentials of Accessory.
     *
     * @param AccessoryWiFiAPCredentials The value which will be set
     */
    inline void setAccessoryWiFiAPCredentials (const ::midw_smartphoneint_fi_types::T_WiFiAPCredentials& AccessoryWiFiAPCredentials_);

    static const WiFiCredentialsStatus &getDefaultInstance();

private:

    inline void set_has_AccessoryWiFiAPCredentials ();

    inline void clear_has_AccessoryWiFiAPCredentials ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_WiFiAPCredentials _AccessoryWiFiAPCredentials;

};

/**
 * The status message of the property "TurnByTurnInfo"
 * Obsolete:
 * Instead use CarplayRouteGuidanceUpdate, AAutoTurnByTurnInfo, BDCLTurnByTurnInfo and MLTurnByTurnInfo respectively for CarPlay, Androidauto, Baidu, Mirrorlink
 */
class TurnByTurnInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TurnByTurnInfoStatus ();

    /**
     * Copy constructor
     */
    inline  TurnByTurnInfoStatus (const TurnByTurnInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TurnByTurnInfoStatus (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_, const ::midw_smartphoneint_fi_types::T_CarPlayTBTUpdate& CarPlayTBTUpdate_, const ::midw_smartphoneint_fi_types::T_AAutoTBTUpdate& AAutoTBTUpdate_, const ::midw_smartphoneint_fi_types::T_BDCLTBTUpdate& BDCLTBTUpdate_, const ::midw_smartphoneint_fi_types::T_MLTBTUpdate& MLTBTUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~TurnByTurnInfoStatus();

    /**
     * Assignment operator
     */
    inline TurnByTurnInfoStatus& operator = (const TurnByTurnInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TurnByTurnInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TurnByTurnInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TurnByTurnInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TurnByTurnInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 1;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Device category Information. Informs TBT update is for which technology.
     * - If DeviceCategory is DEV_TYPE_DIPO, HMI should refer to CarPlayTBTUpdate
     * - If DeviceCategory is DEV_TYPE_ANDROIDAUTO, HMI should refer to AAutoTBTUpdate
     * - If DeviceCategory is DEV_TYPE_CARLIFE, HMI should refer to BDCLTBTUpdate
     * - If DeviceCategory is DEV_TYPE_MIRRORLINK, HMI should refer to MLTBTUpdate
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Device category Information. Informs TBT update is for which technology.
     * - If DeviceCategory is DEV_TYPE_DIPO, HMI should refer to CarPlayTBTUpdate
     * - If DeviceCategory is DEV_TYPE_ANDROIDAUTO, HMI should refer to AAutoTBTUpdate
     * - If DeviceCategory is DEV_TYPE_CARLIFE, HMI should refer to BDCLTBTUpdate
     * - If DeviceCategory is DEV_TYPE_MIRRORLINK, HMI should refer to MLTBTUpdate
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    // API of field "CarPlayTBTUpdate"

    static const int kCarPlayTBTUpdate = 2;

    /**
     * Clears the field "CarPlayTBTUpdate".
     *
     * The field will be set to its default value. The hasCarPlayTBTUpdate()
     * method will return false.
     */
    inline void clearCarPlayTBTUpdate();

    /**
     * Checks whether the field "CarPlayTBTUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarPlayTBTUpdate()). Otherwise it will return false.
     */
    inline bool hasCarPlayTBTUpdate () const;

    /**
     * Returns the value of the member "CarPlayTBTUpdate".
     *
     * Structure Conatining CarPlay TBT info. This structure has two members that contain the TBT info: DiPoRouteGuidanceUpdate and DiPoRouteGuidanceManeuverUpdate. Please check the validity flag before using these members.
     *
     * @return The value of the field "CarPlayTBTUpdate"
     */
    inline const ::midw_smartphoneint_fi_types::T_CarPlayTBTUpdate& getCarPlayTBTUpdate () const;

    /**
     * Retrieves the value of the field "CarPlayTBTUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CarPlayTBTUpdate".
     */
    inline ::midw_smartphoneint_fi_types::T_CarPlayTBTUpdate& getCarPlayTBTUpdateMutable ();

    /**
     * Sets the value of the member "CarPlayTBTUpdate".
     *
     * Structure Conatining CarPlay TBT info. This structure has two members that contain the TBT info: DiPoRouteGuidanceUpdate and DiPoRouteGuidanceManeuverUpdate. Please check the validity flag before using these members.
     *
     * @param CarPlayTBTUpdate The value which will be set
     */
    inline void setCarPlayTBTUpdate (const ::midw_smartphoneint_fi_types::T_CarPlayTBTUpdate& CarPlayTBTUpdate_);

    // API of field "AAutoTBTUpdate"

    static const int kAAutoTBTUpdate = 3;

    /**
     * Clears the field "AAutoTBTUpdate".
     *
     * The field will be set to its default value. The hasAAutoTBTUpdate()
     * method will return false.
     */
    inline void clearAAutoTBTUpdate();

    /**
     * Checks whether the field "AAutoTBTUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAAutoTBTUpdate()). Otherwise it will return false.
     */
    inline bool hasAAutoTBTUpdate () const;

    /**
     * Returns the value of the member "AAutoTBTUpdate".
     *
     * Structure Conatining Android Auto TBT info. This structure has three members that contain the TBT info: NavigationNextTurnData, NavigationNextTurnDistanceData and AAutoNavigationStatusInfo. Please check the validity flag before using these members.
     *
     * @return The value of the field "AAutoTBTUpdate"
     */
    inline const ::midw_smartphoneint_fi_types::T_AAutoTBTUpdate& getAAutoTBTUpdate () const;

    /**
     * Retrieves the value of the field "AAutoTBTUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AAutoTBTUpdate".
     */
    inline ::midw_smartphoneint_fi_types::T_AAutoTBTUpdate& getAAutoTBTUpdateMutable ();

    /**
     * Sets the value of the member "AAutoTBTUpdate".
     *
     * Structure Conatining Android Auto TBT info. This structure has three members that contain the TBT info: NavigationNextTurnData, NavigationNextTurnDistanceData and AAutoNavigationStatusInfo. Please check the validity flag before using these members.
     *
     * @param AAutoTBTUpdate The value which will be set
     */
    inline void setAAutoTBTUpdate (const ::midw_smartphoneint_fi_types::T_AAutoTBTUpdate& AAutoTBTUpdate_);

    // API of field "BDCLTBTUpdate"

    static const int kBDCLTBTUpdate = 4;

    /**
     * Clears the field "BDCLTBTUpdate".
     *
     * The field will be set to its default value. The hasBDCLTBTUpdate()
     * method will return false.
     */
    inline void clearBDCLTBTUpdate();

    /**
     * Checks whether the field "BDCLTBTUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDCLTBTUpdate()). Otherwise it will return false.
     */
    inline bool hasBDCLTBTUpdate () const;

    /**
     * Returns the value of the member "BDCLTBTUpdate".
     *
     * Structure Conatining Baidu Carlfie TBT info. This structure has two members that contain the TBT info: CarlifeNaviNextTurnInfo and CarlifeAssistantGuideInfo. Please check the validity flag before using these members.
     *
     * @return The value of the field "BDCLTBTUpdate"
     */
    inline const ::midw_smartphoneint_fi_types::T_BDCLTBTUpdate& getBDCLTBTUpdate () const;

    /**
     * Retrieves the value of the field "BDCLTBTUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BDCLTBTUpdate".
     */
    inline ::midw_smartphoneint_fi_types::T_BDCLTBTUpdate& getBDCLTBTUpdateMutable ();

    /**
     * Sets the value of the member "BDCLTBTUpdate".
     *
     * Structure Conatining Baidu Carlfie TBT info. This structure has two members that contain the TBT info: CarlifeNaviNextTurnInfo and CarlifeAssistantGuideInfo. Please check the validity flag before using these members.
     *
     * @param BDCLTBTUpdate The value which will be set
     */
    inline void setBDCLTBTUpdate (const ::midw_smartphoneint_fi_types::T_BDCLTBTUpdate& BDCLTBTUpdate_);

    // API of field "MLTBTUpdate"

    static const int kMLTBTUpdate = 5;

    /**
     * Clears the field "MLTBTUpdate".
     *
     * The field will be set to its default value. The hasMLTBTUpdate()
     * method will return false.
     */
    inline void clearMLTBTUpdate();

    /**
     * Checks whether the field "MLTBTUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMLTBTUpdate()). Otherwise it will return false.
     */
    inline bool hasMLTBTUpdate () const;

    /**
     * Returns the value of the member "MLTBTUpdate".
     *
     * Structure Containing ML TBT info. This structure has six members. Please check the validity flag before using these members. Please look for T_MLTBTUpdate to get further details.
     *
     * @return The value of the field "MLTBTUpdate"
     */
    inline const ::midw_smartphoneint_fi_types::T_MLTBTUpdate& getMLTBTUpdate () const;

    /**
     * Retrieves the value of the field "MLTBTUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MLTBTUpdate".
     */
    inline ::midw_smartphoneint_fi_types::T_MLTBTUpdate& getMLTBTUpdateMutable ();

    /**
     * Sets the value of the member "MLTBTUpdate".
     *
     * Structure Containing ML TBT info. This structure has six members. Please check the validity flag before using these members. Please look for T_MLTBTUpdate to get further details.
     *
     * @param MLTBTUpdate The value which will be set
     */
    inline void setMLTBTUpdate (const ::midw_smartphoneint_fi_types::T_MLTBTUpdate& MLTBTUpdate_);

    static const TurnByTurnInfoStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    inline void set_has_CarPlayTBTUpdate ();

    inline void clear_has_CarPlayTBTUpdate ();

    inline void set_has_AAutoTBTUpdate ();

    inline void clear_has_AAutoTBTUpdate ();

    inline void set_has_BDCLTBTUpdate ();

    inline void clear_has_BDCLTBTUpdate ();

    inline void set_has_MLTBTUpdate ();

    inline void clear_has_MLTBTUpdate ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

    ::midw_smartphoneint_fi_types::T_CarPlayTBTUpdate _CarPlayTBTUpdate;

    ::midw_smartphoneint_fi_types::T_AAutoTBTUpdate _AAutoTBTUpdate;

    ::midw_smartphoneint_fi_types::T_BDCLTBTUpdate _BDCLTBTUpdate;

    ::midw_smartphoneint_fi_types::T_MLTBTUpdate _MLTBTUpdate;

};

/**
 * The status message of the property "ProjectedVideoInfo"
 * Scope: AAP, Carlife
 * Provides information about the attributes of the video about to be rendered on the display once projection technology has chosen a display resolution. This information can be
 * used by HMI to position/ rescale the video as per the UI requirements.
 */
class ProjectedVideoInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProjectedVideoInfoStatus ();

    /**
     * Copy constructor
     */
    inline  ProjectedVideoInfoStatus (const ProjectedVideoInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ProjectedVideoInfoStatus (uint32 DeviceHandle_, const ::midw_smartphoneint_fi_types::T_ProjectionVideoAttributes& ProjectedVideoAttributes_);

    /**
     * Destructor
     */
    inline virtual  ~ProjectedVideoInfoStatus();

    /**
     * Assignment operator
     */
    inline ProjectedVideoInfoStatus& operator = (const ProjectedVideoInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProjectedVideoInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProjectedVideoInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProjectedVideoInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProjectedVideoInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device rendering the video.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device rendering the video.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "ProjectedVideoAttributes"

    static const int kProjectedVideoAttributes = 1;

    /**
     * Clears the field "ProjectedVideoAttributes".
     *
     * The field will be set to its default value. The hasProjectedVideoAttributes()
     * method will return false.
     */
    inline void clearProjectedVideoAttributes();

    /**
     * Checks whether the field "ProjectedVideoAttributes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProjectedVideoAttributes()). Otherwise it will return false.
     */
    inline bool hasProjectedVideoAttributes () const;

    /**
     * Returns the value of the member "ProjectedVideoAttributes".
     *
     * Structure provides information about the video rendered on the display.
     *
     * @return The value of the field "ProjectedVideoAttributes"
     */
    inline const ::midw_smartphoneint_fi_types::T_ProjectionVideoAttributes& getProjectedVideoAttributes () const;

    /**
     * Retrieves the value of the field "ProjectedVideoAttributes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ProjectedVideoAttributes".
     */
    inline ::midw_smartphoneint_fi_types::T_ProjectionVideoAttributes& getProjectedVideoAttributesMutable ();

    /**
     * Sets the value of the member "ProjectedVideoAttributes".
     *
     * Structure provides information about the video rendered on the display.
     *
     * @param ProjectedVideoAttributes The value which will be set
     */
    inline void setProjectedVideoAttributes (const ::midw_smartphoneint_fi_types::T_ProjectionVideoAttributes& ProjectedVideoAttributes_);

    static const ProjectedVideoInfoStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_ProjectedVideoAttributes ();

    inline void clear_has_ProjectedVideoAttributes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_ProjectionVideoAttributes _ProjectedVideoAttributes;

};

/**
 * The status message of the property "DeviceLockStatus"
 * Used to notify the HMI if Mobile Device has Enabled/Disabled Device Lock.
 */
class DeviceLockStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceLockStatusStatus ();

    /**
     * Copy constructor
     */
    inline  DeviceLockStatusStatus (const DeviceLockStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceLockStatusStatus (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_, bool bDeviceLockStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceLockStatusStatus();

    /**
     * Assignment operator
     */
    inline DeviceLockStatusStatus& operator = (const DeviceLockStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceLockStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceLockStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceLockStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceLockStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 1;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Identifies the Device Category.
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Identifies the Device Category.
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    // API of field "bDeviceLockStatus"

    static const int kBDeviceLockStatus = 2;

    /**
     * Clears the field "bDeviceLockStatus".
     *
     * The field will be set to its default value. The hasBDeviceLockStatus()
     * method will return false.
     */
    inline void clearBDeviceLockStatus();

    /**
     * Checks whether the field "bDeviceLockStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDeviceLockStatus()). Otherwise it will return false.
     */
    inline bool hasBDeviceLockStatus () const;

    /**
     * Returns the value of the member "bDeviceLockStatus".
     *
     * Set to TRUE/FALSE if Mobile Device Enables/Disables its device lock status.
     *
     * @return The value of the field "bDeviceLockStatus"
     */
    inline bool getBDeviceLockStatus () const;

    /**
     * Sets the value of the member "bDeviceLockStatus".
     *
     * Set to TRUE/FALSE if Mobile Device Enables/Disables its device lock status.
     *
     * @param bDeviceLockStatus The value which will be set
     */
    inline void setBDeviceLockStatus (bool bDeviceLockStatus_);

    static const DeviceLockStatusStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    inline void set_has_bDeviceLockStatus ();

    inline void clear_has_bDeviceLockStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

    bool _bDeviceLockStatus;

};

/**
 * The status message of the property "RelativelyActiveMediaApp"
 * Scope: MirrorLink.
 * Used to notify the HMI regarding the relatively active media app among online music(APP_MEDIA_MUSIC)/online radio(APP_MEDIA)/VIDEO/GAMING/IMAGE
 */
class RelativelyActiveMediaAppStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RelativelyActiveMediaAppStatus ();

    /**
     * Copy constructor
     */
    inline  RelativelyActiveMediaAppStatus (const RelativelyActiveMediaAppStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RelativelyActiveMediaAppStatus (uint32 MediaAppHandle_, ::midw_smartphoneint_fi_types::T_e8Media_AppCategory MediaAppCategory_);

    /**
     * Destructor
     */
    inline virtual  ~RelativelyActiveMediaAppStatus();

    /**
     * Assignment operator
     */
    inline RelativelyActiveMediaAppStatus& operator = (const RelativelyActiveMediaAppStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RelativelyActiveMediaAppStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RelativelyActiveMediaAppStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RelativelyActiveMediaAppStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RelativelyActiveMediaAppStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaAppHandle"

    static const int kMediaAppHandle = 0;

    /**
     * Clears the field "MediaAppHandle".
     *
     * The field will be set to its default value. The hasMediaAppHandle()
     * method will return false.
     */
    inline void clearMediaAppHandle();

    /**
     * Checks whether the field "MediaAppHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaAppHandle()). Otherwise it will return false.
     */
    inline bool hasMediaAppHandle () const;

    /**
     * Returns the value of the member "MediaAppHandle".
     *
     * Handle uniquely identifies an application on the device.
     *
     * @return The value of the field "MediaAppHandle"
     */
    inline uint32 getMediaAppHandle () const;

    /**
     * Sets the value of the member "MediaAppHandle".
     *
     * Handle uniquely identifies an application on the device.
     *
     * @param MediaAppHandle The value which will be set
     */
    inline void setMediaAppHandle (uint32 MediaAppHandle_);

    // API of field "MediaAppCategory"

    static const int kMediaAppCategory = 1;

    /**
     * Clears the field "MediaAppCategory".
     *
     * The field will be set to its default value. The hasMediaAppCategory()
     * method will return false.
     */
    inline void clearMediaAppCategory();

    /**
     * Checks whether the field "MediaAppCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaAppCategory()). Otherwise it will return false.
     */
    inline bool hasMediaAppCategory () const;

    /**
     * Returns the value of the member "MediaAppCategory".
     *
     * Identifies the app Category.
     *
     * @return The value of the field "MediaAppCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8Media_AppCategory getMediaAppCategory () const;

    /**
     * Sets the value of the member "MediaAppCategory".
     *
     * Identifies the app Category.
     *
     * @param MediaAppCategory The value which will be set
     */
    inline void setMediaAppCategory (::midw_smartphoneint_fi_types::T_e8Media_AppCategory MediaAppCategory_);

    static const RelativelyActiveMediaAppStatus &getDefaultInstance();

private:

    inline void set_has_MediaAppHandle ();

    inline void clear_has_MediaAppHandle ();

    inline void set_has_MediaAppCategory ();

    inline void clear_has_MediaAppCategory ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _MediaAppHandle;

    ::midw_smartphoneint_fi_types::T_e8Media_AppCategory _MediaAppCategory;

};

/**
 * The status message of the property "CarplayRouteGuidanceUpdate"
 * Updates Carplay Turn-By-Turn Route Guidance update to the client.
 * The client have to cache the data and display the updated data by checking the available flag.
 */
class CarplayRouteGuidanceUpdateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CarplayRouteGuidanceUpdateStatus ();

    /**
     * Copy constructor
     */
    inline  CarplayRouteGuidanceUpdateStatus (const CarplayRouteGuidanceUpdateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CarplayRouteGuidanceUpdateStatus (uint32 DeviceHandle_, const ::std::string& DeviceUSBSerialNumber_, const ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceUpdate& RouteGuidanceUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~CarplayRouteGuidanceUpdateStatus();

    /**
     * Assignment operator
     */
    inline CarplayRouteGuidanceUpdateStatus& operator = (const CarplayRouteGuidanceUpdateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CarplayRouteGuidanceUpdateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CarplayRouteGuidanceUpdateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CarplayRouteGuidanceUpdateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CarplayRouteGuidanceUpdateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the CarPlay device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the CarPlay device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceUSBSerialNumber"

    static const int kDeviceUSBSerialNumber = 1;

    /**
     * Clears the field "DeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearDeviceUSBSerialNumber();

    /**
     * Checks whether the field "DeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "DeviceUSBSerialNumber".
     *
     * USB serial Number of the CarPlay device.
     *
     * @return The value of the field "DeviceUSBSerialNumber"
     */
    inline const ::std::string& getDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "DeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceUSBSerialNumber".
     */
    inline ::std::string& getDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "DeviceUSBSerialNumber".
     *
     * USB serial Number of the CarPlay device.
     *
     * @param DeviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const ::std::string& DeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "DeviceUSBSerialNumber".
     *
     * USB serial Number of the CarPlay device.
     *
     * @param DeviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* DeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "DeviceUSBSerialNumber".
     *
     * USB serial Number of the CarPlay device.
     *
     * @param DeviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "RouteGuidanceUpdate"

    static const int kRouteGuidanceUpdate = 2;

    /**
     * Clears the field "RouteGuidanceUpdate".
     *
     * The field will be set to its default value. The hasRouteGuidanceUpdate()
     * method will return false.
     */
    inline void clearRouteGuidanceUpdate();

    /**
     * Checks whether the field "RouteGuidanceUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceUpdate()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceUpdate () const;

    /**
     * Returns the value of the member "RouteGuidanceUpdate".
     *
     * Structure containing RouteGuidanceUpdate from the CarPlay device.
     * Note:
     * 1) This is an update. So, information can be sent for all structrue paramater together or individually and the client should keep a cache of the information and update as the information arrives.
     * To know which parameter is updated, validity flag to be used.
     * 2) when RouteGuidanceState is No Route Set, all the cache data to be deleted.
     *
     * @return The value of the field "RouteGuidanceUpdate"
     */
    inline const ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceUpdate& getRouteGuidanceUpdate () const;

    /**
     * Retrieves the value of the field "RouteGuidanceUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RouteGuidanceUpdate".
     */
    inline ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceUpdate& getRouteGuidanceUpdateMutable ();

    /**
     * Sets the value of the member "RouteGuidanceUpdate".
     *
     * Structure containing RouteGuidanceUpdate from the CarPlay device.
     * Note:
     * 1) This is an update. So, information can be sent for all structrue paramater together or individually and the client should keep a cache of the information and update as the information arrives.
     * To know which parameter is updated, validity flag to be used.
     * 2) when RouteGuidanceState is No Route Set, all the cache data to be deleted.
     *
     * @param RouteGuidanceUpdate The value which will be set
     */
    inline void setRouteGuidanceUpdate (const ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceUpdate& RouteGuidanceUpdate_);

    static const CarplayRouteGuidanceUpdateStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceUSBSerialNumber ();

    inline void clear_has_DeviceUSBSerialNumber ();

    inline void set_has_RouteGuidanceUpdate ();

    inline void clear_has_RouteGuidanceUpdate ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::std::string _DeviceUSBSerialNumber;

    ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceUpdate _RouteGuidanceUpdate;

};

/**
 * The status message of the property "CarplayRouteGuidanceManeuverUpdate"
 * Updates Carplay Turn-By-Turn Route Guidance Maneuver update to the client.
 * The client have to cache the data and display the updated data by checking the available flag.
 */
class CarplayRouteGuidanceManeuverUpdateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CarplayRouteGuidanceManeuverUpdateStatus ();

    /**
     * Copy constructor
     */
    inline  CarplayRouteGuidanceManeuverUpdateStatus (const CarplayRouteGuidanceManeuverUpdateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CarplayRouteGuidanceManeuverUpdateStatus (uint32 DeviceHandle_, const ::std::string& DeviceUSBSerialNumber_, const ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceManeuverUpdate& RouteGuidanceManeuverUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~CarplayRouteGuidanceManeuverUpdateStatus();

    /**
     * Assignment operator
     */
    inline CarplayRouteGuidanceManeuverUpdateStatus& operator = (const CarplayRouteGuidanceManeuverUpdateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CarplayRouteGuidanceManeuverUpdateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CarplayRouteGuidanceManeuverUpdateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CarplayRouteGuidanceManeuverUpdateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CarplayRouteGuidanceManeuverUpdateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceUSBSerialNumber"

    static const int kDeviceUSBSerialNumber = 1;

    /**
     * Clears the field "DeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearDeviceUSBSerialNumber();

    /**
     * Checks whether the field "DeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "DeviceUSBSerialNumber".
     *
     * USB serial Number of the CarPlay device.
     *
     * @return The value of the field "DeviceUSBSerialNumber"
     */
    inline const ::std::string& getDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "DeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceUSBSerialNumber".
     */
    inline ::std::string& getDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "DeviceUSBSerialNumber".
     *
     * USB serial Number of the CarPlay device.
     *
     * @param DeviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const ::std::string& DeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "DeviceUSBSerialNumber".
     *
     * USB serial Number of the CarPlay device.
     *
     * @param DeviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* DeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "DeviceUSBSerialNumber".
     *
     * USB serial Number of the CarPlay device.
     *
     * @param DeviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "RouteGuidanceManeuverUpdate"

    static const int kRouteGuidanceManeuverUpdate = 2;

    /**
     * Clears the field "RouteGuidanceManeuverUpdate".
     *
     * The field will be set to its default value. The hasRouteGuidanceManeuverUpdate()
     * method will return false.
     */
    inline void clearRouteGuidanceManeuverUpdate();

    /**
     * Checks whether the field "RouteGuidanceManeuverUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceManeuverUpdate()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceManeuverUpdate () const;

    /**
     * Returns the value of the member "RouteGuidanceManeuverUpdate".
     *
     * Structure conatining RouteGuidanceManeuverUpdate from the CarPlay device.
     *
     * Notes:
     * 1) If a RouteGuidanceManeuverUpdate message is received with an index matching a maneuver already
     * stored on the accessory, the stored maneuver must be removed and replaced by the information in that
     * RouteGuidanceManeuverUpdate message.
     *
     * 2) Each message contains one RouteGuidance maneuver item in the RouteGuidance maneuver list. Index
     * specifies which item in the list is being updated. If the index specifies an entry outside of the
     * MaxGuidanceManeuverStorageCapacity, the oldest entry should be deleted and the new entry should be added.
     * The set of junction elements describe the junction where the maneuver needs to take place. The entry junction
     * element is implied at angle 180 and is not included as a JunctionElementAngle. Multiple junction elements for
     * a maneuver must be shown together. Junction elements may not be provided for a maneuver and should be used to
     * supplement the ManeuverType when present.
     *
     * @return The value of the field "RouteGuidanceManeuverUpdate"
     */
    inline const ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceManeuverUpdate& getRouteGuidanceManeuverUpdate () const;

    /**
     * Retrieves the value of the field "RouteGuidanceManeuverUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RouteGuidanceManeuverUpdate".
     */
    inline ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceManeuverUpdate& getRouteGuidanceManeuverUpdateMutable ();

    /**
     * Sets the value of the member "RouteGuidanceManeuverUpdate".
     *
     * Structure conatining RouteGuidanceManeuverUpdate from the CarPlay device.
     *
     * Notes:
     * 1) If a RouteGuidanceManeuverUpdate message is received with an index matching a maneuver already
     * stored on the accessory, the stored maneuver must be removed and replaced by the information in that
     * RouteGuidanceManeuverUpdate message.
     *
     * 2) Each message contains one RouteGuidance maneuver item in the RouteGuidance maneuver list. Index
     * specifies which item in the list is being updated. If the index specifies an entry outside of the
     * MaxGuidanceManeuverStorageCapacity, the oldest entry should be deleted and the new entry should be added.
     * The set of junction elements describe the junction where the maneuver needs to take place. The entry junction
     * element is implied at angle 180 and is not included as a JunctionElementAngle. Multiple junction elements for
     * a maneuver must be shown together. Junction elements may not be provided for a maneuver and should be used to
     * supplement the ManeuverType when present.
     *
     * @param RouteGuidanceManeuverUpdate The value which will be set
     */
    inline void setRouteGuidanceManeuverUpdate (const ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceManeuverUpdate& RouteGuidanceManeuverUpdate_);

    static const CarplayRouteGuidanceManeuverUpdateStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceUSBSerialNumber ();

    inline void clear_has_DeviceUSBSerialNumber ();

    inline void set_has_RouteGuidanceManeuverUpdate ();

    inline void clear_has_RouteGuidanceManeuverUpdate ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::std::string _DeviceUSBSerialNumber;

    ::midw_smartphoneint_fi_types::T_CarPlayRouteGuidanceManeuverUpdate _RouteGuidanceManeuverUpdate;

};

/**
 * The status message of the property "AAutoTurnByTurnInfo"
 * Updates Android Auto Turn-By-Turn Projection Navigation Information to the client.
 */
class AAutoTurnByTurnInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AAutoTurnByTurnInfoStatus ();

    /**
     * Copy constructor
     */
    inline  AAutoTurnByTurnInfoStatus (const AAutoTurnByTurnInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AAutoTurnByTurnInfoStatus (uint32 DeviceHandle_, const ::midw_smartphoneint_fi_types::T_AAutoTBTUpdate& AAutoTBTUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~AAutoTurnByTurnInfoStatus();

    /**
     * Assignment operator
     */
    inline AAutoTurnByTurnInfoStatus& operator = (const AAutoTurnByTurnInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AAutoTurnByTurnInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AAutoTurnByTurnInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AAutoTurnByTurnInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AAutoTurnByTurnInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "AAutoTBTUpdate"

    static const int kAAutoTBTUpdate = 1;

    /**
     * Clears the field "AAutoTBTUpdate".
     *
     * The field will be set to its default value. The hasAAutoTBTUpdate()
     * method will return false.
     */
    inline void clearAAutoTBTUpdate();

    /**
     * Checks whether the field "AAutoTBTUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAAutoTBTUpdate()). Otherwise it will return false.
     */
    inline bool hasAAutoTBTUpdate () const;

    /**
     * Returns the value of the member "AAutoTBTUpdate".
     *
     * Structure Conatining Android Auto TBT info. This structure has three members that contain the TBT info: NavigationNextTurnData, NavigationNextTurnDistanceData and AAutoNavigationStatusInfo. Please check the validity flag before using these members.
     *
     * @return The value of the field "AAutoTBTUpdate"
     */
    inline const ::midw_smartphoneint_fi_types::T_AAutoTBTUpdate& getAAutoTBTUpdate () const;

    /**
     * Retrieves the value of the field "AAutoTBTUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AAutoTBTUpdate".
     */
    inline ::midw_smartphoneint_fi_types::T_AAutoTBTUpdate& getAAutoTBTUpdateMutable ();

    /**
     * Sets the value of the member "AAutoTBTUpdate".
     *
     * Structure Conatining Android Auto TBT info. This structure has three members that contain the TBT info: NavigationNextTurnData, NavigationNextTurnDistanceData and AAutoNavigationStatusInfo. Please check the validity flag before using these members.
     *
     * @param AAutoTBTUpdate The value which will be set
     */
    inline void setAAutoTBTUpdate (const ::midw_smartphoneint_fi_types::T_AAutoTBTUpdate& AAutoTBTUpdate_);

    static const AAutoTurnByTurnInfoStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_AAutoTBTUpdate ();

    inline void clear_has_AAutoTBTUpdate ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_AAutoTBTUpdate _AAutoTBTUpdate;

};

/**
 * The status message of the property "BDCLTurnByTurnInfo"
 * Updates Baidu Carlife Turn-By-Turn Projection Navigation Information to the client.
 */
class BDCLTurnByTurnInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BDCLTurnByTurnInfoStatus ();

    /**
     * Copy constructor
     */
    inline  BDCLTurnByTurnInfoStatus (const BDCLTurnByTurnInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BDCLTurnByTurnInfoStatus (uint32 DeviceHandle_, const ::midw_smartphoneint_fi_types::T_BDCLTBTUpdate& BDCLTBTUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~BDCLTurnByTurnInfoStatus();

    /**
     * Assignment operator
     */
    inline BDCLTurnByTurnInfoStatus& operator = (const BDCLTurnByTurnInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BDCLTurnByTurnInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BDCLTurnByTurnInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BDCLTurnByTurnInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BDCLTurnByTurnInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "BDCLTBTUpdate"

    static const int kBDCLTBTUpdate = 1;

    /**
     * Clears the field "BDCLTBTUpdate".
     *
     * The field will be set to its default value. The hasBDCLTBTUpdate()
     * method will return false.
     */
    inline void clearBDCLTBTUpdate();

    /**
     * Checks whether the field "BDCLTBTUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDCLTBTUpdate()). Otherwise it will return false.
     */
    inline bool hasBDCLTBTUpdate () const;

    /**
     * Returns the value of the member "BDCLTBTUpdate".
     *
     * Structure Conatining Baidu Carlfie TBT info. This structure has two members that contain the TBT info: CarlifeNaviNextTurnInfo and CarlifeAssistantGuideInfo. Please check the validity flag before using these members.
     *
     * @return The value of the field "BDCLTBTUpdate"
     */
    inline const ::midw_smartphoneint_fi_types::T_BDCLTBTUpdate& getBDCLTBTUpdate () const;

    /**
     * Retrieves the value of the field "BDCLTBTUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BDCLTBTUpdate".
     */
    inline ::midw_smartphoneint_fi_types::T_BDCLTBTUpdate& getBDCLTBTUpdateMutable ();

    /**
     * Sets the value of the member "BDCLTBTUpdate".
     *
     * Structure Conatining Baidu Carlfie TBT info. This structure has two members that contain the TBT info: CarlifeNaviNextTurnInfo and CarlifeAssistantGuideInfo. Please check the validity flag before using these members.
     *
     * @param BDCLTBTUpdate The value which will be set
     */
    inline void setBDCLTBTUpdate (const ::midw_smartphoneint_fi_types::T_BDCLTBTUpdate& BDCLTBTUpdate_);

    static const BDCLTurnByTurnInfoStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_BDCLTBTUpdate ();

    inline void clear_has_BDCLTBTUpdate ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_BDCLTBTUpdate _BDCLTBTUpdate;

};

/**
 * The status message of the property "MLTurnByTurnInfo"
 * Updates Mirrorlink Turn-By-Turn Projection Navigation Information to the client.
 */
class MLTurnByTurnInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MLTurnByTurnInfoStatus ();

    /**
     * Copy constructor
     */
    inline  MLTurnByTurnInfoStatus (const MLTurnByTurnInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MLTurnByTurnInfoStatus (uint32 DeviceHandle_, const ::midw_smartphoneint_fi_types::T_MLTBTUpdate& MLTBTUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~MLTurnByTurnInfoStatus();

    /**
     * Assignment operator
     */
    inline MLTurnByTurnInfoStatus& operator = (const MLTurnByTurnInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MLTurnByTurnInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MLTurnByTurnInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MLTurnByTurnInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MLTurnByTurnInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "MLTBTUpdate"

    static const int kMLTBTUpdate = 1;

    /**
     * Clears the field "MLTBTUpdate".
     *
     * The field will be set to its default value. The hasMLTBTUpdate()
     * method will return false.
     */
    inline void clearMLTBTUpdate();

    /**
     * Checks whether the field "MLTBTUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMLTBTUpdate()). Otherwise it will return false.
     */
    inline bool hasMLTBTUpdate () const;

    /**
     * Returns the value of the member "MLTBTUpdate".
     *
     * Structure Containing ML TBT info. This structure has six members. Please check the validity flag before using these members. Please look for T_MLTBTUpdate to get further details.
     *
     * @return The value of the field "MLTBTUpdate"
     */
    inline const ::midw_smartphoneint_fi_types::T_MLTBTUpdate& getMLTBTUpdate () const;

    /**
     * Retrieves the value of the field "MLTBTUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MLTBTUpdate".
     */
    inline ::midw_smartphoneint_fi_types::T_MLTBTUpdate& getMLTBTUpdateMutable ();

    /**
     * Sets the value of the member "MLTBTUpdate".
     *
     * Structure Containing ML TBT info. This structure has six members. Please check the validity flag before using these members. Please look for T_MLTBTUpdate to get further details.
     *
     * @param MLTBTUpdate The value which will be set
     */
    inline void setMLTBTUpdate (const ::midw_smartphoneint_fi_types::T_MLTBTUpdate& MLTBTUpdate_);

    static const MLTurnByTurnInfoStatus &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_MLTBTUpdate ();

    inline void clear_has_MLTBTUpdate ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_MLTBTUpdate _MLTBTUpdate;

};

/**
 * The status message of the property "ApplicationPhoneCallData"
 * Scope : CarPlay
 * Interface to notify Phonecall data like phone number, call progress in secs, call direction, etc
 */
class ApplicationPhoneCallDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ApplicationPhoneCallDataStatus ();

    /**
     * Copy constructor
     */
    inline  ApplicationPhoneCallDataStatus (const ApplicationPhoneCallDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ApplicationPhoneCallDataStatus (uint32 DeviceHandle_, const ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallExtendedMetadata >& PhoneCallExtendedMetadata_);

    /**
     * Destructor
     */
    inline virtual  ~ApplicationPhoneCallDataStatus();

    /**
     * Assignment operator
     */
    inline ApplicationPhoneCallDataStatus& operator = (const ApplicationPhoneCallDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ApplicationPhoneCallDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ApplicationPhoneCallDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ApplicationPhoneCallDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ApplicationPhoneCallDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "PhoneCallExtendedMetadata"

    static const int kPhoneCallExtendedMetadata = 1;

    /**
     * Clears the field "PhoneCallExtendedMetadata".
     *
     * The field will be set to its default value. The hasPhoneCallExtendedMetadata()
     * method will return false.
     */
    inline void clearPhoneCallExtendedMetadata();

    /**
     * Checks whether the field "PhoneCallExtendedMetadata" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneCallExtendedMetadata()). Otherwise it will return false.
     */
    inline bool hasPhoneCallExtendedMetadata () const;

    /**
     * Returns the value of the member "PhoneCallExtendedMetadata".
     *
     * Contains the Phone call status like call state, caller name, caller ID, call progress in secs
     *
     * @return The value of the field "PhoneCallExtendedMetadata"
     */
    inline const ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallExtendedMetadata >& getPhoneCallExtendedMetadata () const;

    /**
     * Retrieves the value of the field "PhoneCallExtendedMetadata" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneCallExtendedMetadata".
     */
    inline ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallExtendedMetadata >& getPhoneCallExtendedMetadataMutable ();

    /**
     * Sets the value of the member "PhoneCallExtendedMetadata".
     *
     * Contains the Phone call status like call state, caller name, caller ID, call progress in secs
     *
     * @param PhoneCallExtendedMetadata The value which will be set
     */
    inline void setPhoneCallExtendedMetadata (const ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallExtendedMetadata >& PhoneCallExtendedMetadata_);

    static const ApplicationPhoneCallDataStatus &getDefaultInstance();

private:

    static const ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallExtendedMetadata >& getT_ApplicationPhoneCallExtendedMetadataList_DefaultInstance ();

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_PhoneCallExtendedMetadata ();

    inline void clear_has_PhoneCallExtendedMetadata ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallExtendedMetadata > _PhoneCallExtendedMetadata;

};

/**
 * The result message of the method "GetDeviceInfoList"
 * It provides a list of connected devices and device history with the information for each device.
 * This method is deprecated instead use GetDeviceList.
 */
class GetDeviceInfoListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDeviceInfoListResult ();

    /**
     * Copy constructor
     */
    inline  GetDeviceInfoListResult (const GetDeviceInfoListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetDeviceInfoListResult (uint16 NumDevices_, const ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceDetails >& DeviceInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~GetDeviceInfoListResult();

    /**
     * Assignment operator
     */
    inline GetDeviceInfoListResult& operator = (const GetDeviceInfoListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDeviceInfoListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDeviceInfoListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDeviceInfoListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDeviceInfoListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NumDevices"

    static const int kNumDevices = 0;

    /**
     * Clears the field "NumDevices".
     *
     * The field will be set to its default value. The hasNumDevices()
     * method will return false.
     */
    inline void clearNumDevices();

    /**
     * Checks whether the field "NumDevices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumDevices()). Otherwise it will return false.
     */
    inline bool hasNumDevices () const;

    /**
     * Returns the value of the member "NumDevices".
     *
     * Total number of devices for which the information is provided.
     *
     * @return The value of the field "NumDevices"
     */
    inline uint16 getNumDevices () const;

    /**
     * Sets the value of the member "NumDevices".
     *
     * Total number of devices for which the information is provided.
     *
     * @param NumDevices The value which will be set
     */
    inline void setNumDevices (uint16 NumDevices_);

    // API of field "DeviceInfoList"

    static const int kDeviceInfoList = 1;

    /**
     * Clears the field "DeviceInfoList".
     *
     * The field will be set to its default value. The hasDeviceInfoList()
     * method will return false.
     */
    inline void clearDeviceInfoList();

    /**
     * Checks whether the field "DeviceInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceInfoList()). Otherwise it will return false.
     */
    inline bool hasDeviceInfoList () const;

    /**
     * Returns the value of the member "DeviceInfoList".
     *
     * List of DeviceDetails records. In case of error, Number of devices will be set to 0xFFFF and List will be empty.
     *
     * @return The value of the field "DeviceInfoList"
     */
    inline const ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceDetails >& getDeviceInfoList () const;

    /**
     * Retrieves the value of the field "DeviceInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceInfoList".
     */
    inline ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceDetails >& getDeviceInfoListMutable ();

    /**
     * Sets the value of the member "DeviceInfoList".
     *
     * List of DeviceDetails records. In case of error, Number of devices will be set to 0xFFFF and List will be empty.
     *
     * @param DeviceInfoList The value which will be set
     */
    inline void setDeviceInfoList (const ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceDetails >& DeviceInfoList_);

    static const GetDeviceInfoListResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceDetails >& getT_DeviceDetailsList_DefaultInstance ();

    inline void set_has_NumDevices ();

    inline void clear_has_NumDevices ();

    inline void set_has_DeviceInfoList ();

    inline void clear_has_DeviceInfoList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _NumDevices;

    ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceDetails > _DeviceInfoList;

};

/**
 * The start message of the method "SelectDevice"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * It provides a mechanism to select a device from SPI device List to establish a session.
 */
class SelectDeviceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectDeviceStart ();

    /**
     * Copy constructor
     */
    inline  SelectDeviceStart (const SelectDeviceStart &rhs);

    /**
     * All fields constructor
     */
    inline  SelectDeviceStart (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType DeviceConnectionType_, ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionReq DeviceConnectionReq_, ::midw_smartphoneint_fi_types::T_e8_EnabledInfo DAPUsage_, ::midw_smartphoneint_fi_types::T_e8_EnabledInfo CDBUsage_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_, ::midw_smartphoneint_fi_types::T_e8_SelectionType SelectionType_);

    /**
     * Destructor
     */
    inline virtual  ~SelectDeviceStart();

    /**
     * Assignment operator
     */
    inline SelectDeviceStart& operator = (const SelectDeviceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectDeviceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectDeviceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectDeviceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectDeviceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceConnectionType"

    static const int kDeviceConnectionType = 1;

    /**
     * Clears the field "DeviceConnectionType".
     *
     * The field will be set to its default value. The hasDeviceConnectionType()
     * method will return false.
     */
    inline void clearDeviceConnectionType();

    /**
     * Checks whether the field "DeviceConnectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceConnectionType()). Otherwise it will return false.
     */
    inline bool hasDeviceConnectionType () const;

    /**
     * Returns the value of the member "DeviceConnectionType".
     *
     * Identifies the Connection Type.
     *
     * @return The value of the field "DeviceConnectionType"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType getDeviceConnectionType () const;

    /**
     * Sets the value of the member "DeviceConnectionType".
     *
     * Identifies the Connection Type.
     *
     * @param DeviceConnectionType The value which will be set
     */
    inline void setDeviceConnectionType (::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType DeviceConnectionType_);

    // API of field "DeviceConnectionReq"

    static const int kDeviceConnectionReq = 2;

    /**
     * Clears the field "DeviceConnectionReq".
     *
     * The field will be set to its default value. The hasDeviceConnectionReq()
     * method will return false.
     */
    inline void clearDeviceConnectionReq();

    /**
     * Checks whether the field "DeviceConnectionReq" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceConnectionReq()). Otherwise it will return false.
     */
    inline bool hasDeviceConnectionReq () const;

    /**
     * Returns the value of the member "DeviceConnectionReq".
     *
     * Identifies the Connection Request.
     *
     * @return The value of the field "DeviceConnectionReq"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionReq getDeviceConnectionReq () const;

    /**
     * Sets the value of the member "DeviceConnectionReq".
     *
     * Identifies the Connection Request.
     *
     * @param DeviceConnectionReq The value which will be set
     */
    inline void setDeviceConnectionReq (::midw_smartphoneint_fi_types::T_e8_DeviceConnectionReq DeviceConnectionReq_);

    // API of field "DAPUsage"

    static const int kDAPUsage = 3;

    /**
     * Clears the field "DAPUsage".
     *
     * The field will be set to its default value. The hasDAPUsage()
     * method will return false.
     */
    inline void clearDAPUsage();

    /**
     * Checks whether the field "DAPUsage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDAPUsage()). Otherwise it will return false.
     */
    inline bool hasDAPUsage () const;

    /**
     * Returns the value of the member "DAPUsage".
     *
     * Scope: Only for ML
     * Identifies Usage of DAP for the selected Mirror Link device. This value is not considered for de-selection of device.
     *
     * @return The value of the field "DAPUsage"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_EnabledInfo getDAPUsage () const;

    /**
     * Sets the value of the member "DAPUsage".
     *
     * Scope: Only for ML
     * Identifies Usage of DAP for the selected Mirror Link device. This value is not considered for de-selection of device.
     *
     * @param DAPUsage The value which will be set
     */
    inline void setDAPUsage (::midw_smartphoneint_fi_types::T_e8_EnabledInfo DAPUsage_);

    // API of field "CDBUsage"

    static const int kCDBUsage = 4;

    /**
     * Clears the field "CDBUsage".
     *
     * The field will be set to its default value. The hasCDBUsage()
     * method will return false.
     */
    inline void clearCDBUsage();

    /**
     * Checks whether the field "CDBUsage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCDBUsage()). Otherwise it will return false.
     */
    inline bool hasCDBUsage () const;

    /**
     * Returns the value of the member "CDBUsage".
     *
     * Scope: Only for ML
     * Identifies Usage of CDB for the selected Mirror Link device. This value is not considered for de-selection of device.
     *
     * @return The value of the field "CDBUsage"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_EnabledInfo getCDBUsage () const;

    /**
     * Sets the value of the member "CDBUsage".
     *
     * Scope: Only for ML
     * Identifies Usage of CDB for the selected Mirror Link device. This value is not considered for de-selection of device.
     *
     * @param CDBUsage The value which will be set
     */
    inline void setCDBUsage (::midw_smartphoneint_fi_types::T_e8_EnabledInfo CDBUsage_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 5;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Device category Information. Informs the technology to which device has to be activated/selected.
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Device category Information. Informs the technology to which device has to be activated/selected.
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    // API of field "SelectionType"

    static const int kSelectionType = 6;

    /**
     * Clears the field "SelectionType".
     *
     * The field will be set to its default value. The hasSelectionType()
     * method will return false.
     */
    inline void clearSelectionType();

    /**
     * Checks whether the field "SelectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelectionType()). Otherwise it will return false.
     */
    inline bool hasSelectionType () const;

    /**
     * Returns the value of the member "SelectionType".
     *
     * Informs if the device selection/ deselection is done based on user action or was internally triggered by HMI
     *
     * @return The value of the field "SelectionType"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_SelectionType getSelectionType () const;

    /**
     * Sets the value of the member "SelectionType".
     *
     * Informs if the device selection/ deselection is done based on user action or was internally triggered by HMI
     *
     * @param SelectionType The value which will be set
     */
    inline void setSelectionType (::midw_smartphoneint_fi_types::T_e8_SelectionType SelectionType_);

    static const SelectDeviceStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceConnectionType ();

    inline void clear_has_DeviceConnectionType ();

    inline void set_has_DeviceConnectionReq ();

    inline void clear_has_DeviceConnectionReq ();

    inline void set_has_DAPUsage ();

    inline void clear_has_DAPUsage ();

    inline void set_has_CDBUsage ();

    inline void clear_has_CDBUsage ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    inline void set_has_SelectionType ();

    inline void clear_has_SelectionType ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType _DeviceConnectionType;

    ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionReq _DeviceConnectionReq;

    ::midw_smartphoneint_fi_types::T_e8_EnabledInfo _DAPUsage;

    ::midw_smartphoneint_fi_types::T_e8_EnabledInfo _CDBUsage;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

    ::midw_smartphoneint_fi_types::T_e8_SelectionType _SelectionType;

};

/**
 * The result message of the method "SelectDevice"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * It provides a mechanism to select a device from SPI device List to establish a session.
 */
class SelectDeviceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectDeviceResult ();

    /**
     * Copy constructor
     */
    inline  SelectDeviceResult (const SelectDeviceResult &rhs);

    /**
     * All fields constructor
     */
    inline  SelectDeviceResult (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType DeviceConnectionType_, ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionReq DeviceConnectionReq_, ::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_, bool BTPairingRequired_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    /**
     * Destructor
     */
    inline virtual  ~SelectDeviceResult();

    /**
     * Assignment operator
     */
    inline SelectDeviceResult& operator = (const SelectDeviceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectDeviceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectDeviceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectDeviceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectDeviceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceConnectionType"

    static const int kDeviceConnectionType = 1;

    /**
     * Clears the field "DeviceConnectionType".
     *
     * The field will be set to its default value. The hasDeviceConnectionType()
     * method will return false.
     */
    inline void clearDeviceConnectionType();

    /**
     * Checks whether the field "DeviceConnectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceConnectionType()). Otherwise it will return false.
     */
    inline bool hasDeviceConnectionType () const;

    /**
     * Returns the value of the member "DeviceConnectionType".
     *
     * Identifies the Connection Type.
     *
     * @return The value of the field "DeviceConnectionType"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType getDeviceConnectionType () const;

    /**
     * Sets the value of the member "DeviceConnectionType".
     *
     * Identifies the Connection Type.
     *
     * @param DeviceConnectionType The value which will be set
     */
    inline void setDeviceConnectionType (::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType DeviceConnectionType_);

    // API of field "DeviceConnectionReq"

    static const int kDeviceConnectionReq = 2;

    /**
     * Clears the field "DeviceConnectionReq".
     *
     * The field will be set to its default value. The hasDeviceConnectionReq()
     * method will return false.
     */
    inline void clearDeviceConnectionReq();

    /**
     * Checks whether the field "DeviceConnectionReq" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceConnectionReq()). Otherwise it will return false.
     */
    inline bool hasDeviceConnectionReq () const;

    /**
     * Returns the value of the member "DeviceConnectionReq".
     *
     * Identifies the Connection Request.
     *
     * @return The value of the field "DeviceConnectionReq"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionReq getDeviceConnectionReq () const;

    /**
     * Sets the value of the member "DeviceConnectionReq".
     *
     * Identifies the Connection Request.
     *
     * @param DeviceConnectionReq The value which will be set
     */
    inline void setDeviceConnectionReq (::midw_smartphoneint_fi_types::T_e8_DeviceConnectionReq DeviceConnectionReq_);

    // API of field "ResponseCode"

    static const int kResponseCode = 3;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 4;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    // API of field "BTPairingRequired"

    static const int kBTPairingRequired = 5;

    /**
     * Clears the field "BTPairingRequired".
     *
     * The field will be set to its default value. The hasBTPairingRequired()
     * method will return false.
     */
    inline void clearBTPairingRequired();

    /**
     * Checks whether the field "BTPairingRequired" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTPairingRequired()). Otherwise it will return false.
     */
    inline bool hasBTPairingRequired () const;

    /**
     * Returns the value of the member "BTPairingRequired".
     *
     * Identifies the Connection Request.
     *
     * @return The value of the field "BTPairingRequired"
     */
    inline bool getBTPairingRequired () const;

    /**
     * Sets the value of the member "BTPairingRequired".
     *
     * Identifies the Connection Request.
     *
     * @param BTPairingRequired The value which will be set
     */
    inline void setBTPairingRequired (bool BTPairingRequired_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 6;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Indicates the SPI technology to which the device has switched to
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Indicates the SPI technology to which the device has switched to
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    static const SelectDeviceResult &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceConnectionType ();

    inline void clear_has_DeviceConnectionType ();

    inline void set_has_DeviceConnectionReq ();

    inline void clear_has_DeviceConnectionReq ();

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    inline void set_has_BTPairingRequired ();

    inline void clear_has_BTPairingRequired ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType _DeviceConnectionType;

    ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionReq _DeviceConnectionReq;

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

    bool _BTPairingRequired;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

};

/**
 * The start message of the method "LaunchApp"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * It launches a remote application from the selected device
 */
class LaunchAppStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LaunchAppStart ();

    /**
     * Copy constructor
     */
    inline  LaunchAppStart (const LaunchAppStart &rhs);

    /**
     * All fields constructor
     */
    inline  LaunchAppStart (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_, uint32 AppHandle_, ::midw_smartphoneint_fi_types::T_e8_DiPOAppType DiPOAppType_, const ::std::string& TelephoneNumber_, ::midw_smartphoneint_fi_types::T_e8_EcnrSetting EcnrSetting_);

    /**
     * Destructor
     */
    inline virtual  ~LaunchAppStart();

    /**
     * Assignment operator
     */
    inline LaunchAppStart& operator = (const LaunchAppStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LaunchAppStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LaunchAppStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LaunchAppStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LaunchAppStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 1;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Device Type Information.
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Device Type Information.
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    // API of field "AppHandle"

    static const int kAppHandle = 2;

    /**
     * Clears the field "AppHandle".
     *
     * The field will be set to its default value. The hasAppHandle()
     * method will return false.
     */
    inline void clearAppHandle();

    /**
     * Checks whether the field "AppHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppHandle()). Otherwise it will return false.
     */
    inline bool hasAppHandle () const;

    /**
     * Returns the value of the member "AppHandle".
     *
     * Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     *
     * @return The value of the field "AppHandle"
     */
    inline uint32 getAppHandle () const;

    /**
     * Sets the value of the member "AppHandle".
     *
     * Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     *
     * @param AppHandle The value which will be set
     */
    inline void setAppHandle (uint32 AppHandle_);

    // API of field "DiPOAppType"

    static const int kDiPOAppType = 3;

    /**
     * Clears the field "DiPOAppType".
     *
     * The field will be set to its default value. The hasDiPOAppType()
     * method will return false.
     */
    inline void clearDiPOAppType();

    /**
     * Checks whether the field "DiPOAppType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiPOAppType()). Otherwise it will return false.
     */
    inline bool hasDiPOAppType () const;

    /**
     * Returns the value of the member "DiPOAppType".
     *
     * Identifies the application to be launched on a DiPO device. This value will be set to NOT_USED if DeviceCategory = DEV_TYPE_MIRRORLINK.
     *
     * @return The value of the field "DiPOAppType"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DiPOAppType getDiPOAppType () const;

    /**
     * Sets the value of the member "DiPOAppType".
     *
     * Identifies the application to be launched on a DiPO device. This value will be set to NOT_USED if DeviceCategory = DEV_TYPE_MIRRORLINK.
     *
     * @param DiPOAppType The value which will be set
     */
    inline void setDiPOAppType (::midw_smartphoneint_fi_types::T_e8_DiPOAppType DiPOAppType_);

    // API of field "TelephoneNumber"

    static const int kTelephoneNumber = 4;

    /**
     * Clears the field "TelephoneNumber".
     *
     * The field will be set to its default value. The hasTelephoneNumber()
     * method will return false.
     */
    inline void clearTelephoneNumber();

    /**
     * Checks whether the field "TelephoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTelephoneNumber()). Otherwise it will return false.
     */
    inline bool hasTelephoneNumber () const;

    /**
     * Returns the value of the member "TelephoneNumber".
     *
     * Number to be dialed if the DiPO application to be launched is a phone application. If not valid to be used, this will be set to NULL, zero length string. Will not be used if DeviceCategory = DEV_TYPE_MIRRORLINK.
     *
     * @return The value of the field "TelephoneNumber"
     */
    inline const ::std::string& getTelephoneNumber () const;

    /**
     * Retrieves the value of the field "TelephoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TelephoneNumber".
     */
    inline ::std::string& getTelephoneNumberMutable ();

    /**
     * Sets the value of the member "TelephoneNumber".
     *
     * Number to be dialed if the DiPO application to be launched is a phone application. If not valid to be used, this will be set to NULL, zero length string. Will not be used if DeviceCategory = DEV_TYPE_MIRRORLINK.
     *
     * @param TelephoneNumber The value which will be set
     */
    inline void setTelephoneNumber (const ::std::string& TelephoneNumber_);

    /**
     * Sets the value of the member "TelephoneNumber".
     *
     * Number to be dialed if the DiPO application to be launched is a phone application. If not valid to be used, this will be set to NULL, zero length string. Will not be used if DeviceCategory = DEV_TYPE_MIRRORLINK.
     *
     * @param TelephoneNumber The value which will be set
     */
    inline void setTelephoneNumber (const char* TelephoneNumber_);

    /**
     * Sets the value of the member "TelephoneNumber".
     *
     * Number to be dialed if the DiPO application to be launched is a phone application. If not valid to be used, this will be set to NULL, zero length string. Will not be used if DeviceCategory = DEV_TYPE_MIRRORLINK.
     *
     * @param TelephoneNumber The value which will be set
     */
    inline void setTelephoneNumber (const char* value, size_t size);

    // API of field "EcnrSetting"

    static const int kEcnrSetting = 5;

    /**
     * Clears the field "EcnrSetting".
     *
     * The field will be set to its default value. The hasEcnrSetting()
     * method will return false.
     */
    inline void clearEcnrSetting();

    /**
     * Checks whether the field "EcnrSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcnrSetting()). Otherwise it will return false.
     */
    inline bool hasEcnrSetting () const;

    /**
     * Returns the value of the member "EcnrSetting".
     *
     * Sets voice or server echo cancellation and noise reduction settings if the DiPO application to be launched is a phone application. If not valid to be used, this will be set to ECNR_NOCHANGE.
     *
     * @return The value of the field "EcnrSetting"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_EcnrSetting getEcnrSetting () const;

    /**
     * Sets the value of the member "EcnrSetting".
     *
     * Sets voice or server echo cancellation and noise reduction settings if the DiPO application to be launched is a phone application. If not valid to be used, this will be set to ECNR_NOCHANGE.
     *
     * @param EcnrSetting The value which will be set
     */
    inline void setEcnrSetting (::midw_smartphoneint_fi_types::T_e8_EcnrSetting EcnrSetting_);

    static const LaunchAppStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    inline void set_has_AppHandle ();

    inline void clear_has_AppHandle ();

    inline void set_has_DiPOAppType ();

    inline void clear_has_DiPOAppType ();

    inline void set_has_TelephoneNumber ();

    inline void clear_has_TelephoneNumber ();

    inline void set_has_EcnrSetting ();

    inline void clear_has_EcnrSetting ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

    uint32 _AppHandle;

    ::midw_smartphoneint_fi_types::T_e8_DiPOAppType _DiPOAppType;

    ::std::string _TelephoneNumber;

    ::midw_smartphoneint_fi_types::T_e8_EcnrSetting _EcnrSetting;

};

/**
 * The result message of the method "LaunchApp"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * It launches a remote application from the selected device
 */
class LaunchAppResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LaunchAppResult ();

    /**
     * Copy constructor
     */
    inline  LaunchAppResult (const LaunchAppResult &rhs);

    /**
     * All fields constructor
     */
    inline  LaunchAppResult (uint32 DeviceHandle_, uint32 AppHandle_, ::midw_smartphoneint_fi_types::T_e8_DiPOAppType DiPOAppType_, ::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~LaunchAppResult();

    /**
     * Assignment operator
     */
    inline LaunchAppResult& operator = (const LaunchAppResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LaunchAppResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LaunchAppResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LaunchAppResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LaunchAppResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "AppHandle"

    static const int kAppHandle = 1;

    /**
     * Clears the field "AppHandle".
     *
     * The field will be set to its default value. The hasAppHandle()
     * method will return false.
     */
    inline void clearAppHandle();

    /**
     * Checks whether the field "AppHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppHandle()). Otherwise it will return false.
     */
    inline bool hasAppHandle () const;

    /**
     * Returns the value of the member "AppHandle".
     *
     * Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     *
     * @return The value of the field "AppHandle"
     */
    inline uint32 getAppHandle () const;

    /**
     * Sets the value of the member "AppHandle".
     *
     * Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     *
     * @param AppHandle The value which will be set
     */
    inline void setAppHandle (uint32 AppHandle_);

    // API of field "DiPOAppType"

    static const int kDiPOAppType = 2;

    /**
     * Clears the field "DiPOAppType".
     *
     * The field will be set to its default value. The hasDiPOAppType()
     * method will return false.
     */
    inline void clearDiPOAppType();

    /**
     * Checks whether the field "DiPOAppType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiPOAppType()). Otherwise it will return false.
     */
    inline bool hasDiPOAppType () const;

    /**
     * Returns the value of the member "DiPOAppType".
     *
     * Identifies the application to be launched on a DiPO device. This value will be set to NOT_USED if DeviceCategory = DEV_TYPE_MIRRORLINK.
     *
     * @return The value of the field "DiPOAppType"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DiPOAppType getDiPOAppType () const;

    /**
     * Sets the value of the member "DiPOAppType".
     *
     * Identifies the application to be launched on a DiPO device. This value will be set to NOT_USED if DeviceCategory = DEV_TYPE_MIRRORLINK.
     *
     * @param DiPOAppType The value which will be set
     */
    inline void setDiPOAppType (::midw_smartphoneint_fi_types::T_e8_DiPOAppType DiPOAppType_);

    // API of field "ResponseCode"

    static const int kResponseCode = 3;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 4;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const LaunchAppResult &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_AppHandle ();

    inline void clear_has_AppHandle ();

    inline void set_has_DiPOAppType ();

    inline void clear_has_DiPOAppType ();

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _DeviceHandle;

    uint32 _AppHandle;

    ::midw_smartphoneint_fi_types::T_e8_DiPOAppType _DiPOAppType;

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "TerminateApp"
 * Scope: Only for ML
 * It terminates the remote application running on the Mirror Link device.
 */
class TerminateAppStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TerminateAppStart ();

    /**
     * Copy constructor
     */
    inline  TerminateAppStart (const TerminateAppStart &rhs);

    /**
     * All fields constructor
     */
    inline  TerminateAppStart (uint32 DeviceHandle_, uint32 AppHandle_);

    /**
     * Destructor
     */
    inline virtual  ~TerminateAppStart();

    /**
     * Assignment operator
     */
    inline TerminateAppStart& operator = (const TerminateAppStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TerminateAppStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TerminateAppStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TerminateAppStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TerminateAppStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "AppHandle"

    static const int kAppHandle = 1;

    /**
     * Clears the field "AppHandle".
     *
     * The field will be set to its default value. The hasAppHandle()
     * method will return false.
     */
    inline void clearAppHandle();

    /**
     * Checks whether the field "AppHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppHandle()). Otherwise it will return false.
     */
    inline bool hasAppHandle () const;

    /**
     * Returns the value of the member "AppHandle".
     *
     * Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     *
     * @return The value of the field "AppHandle"
     */
    inline uint32 getAppHandle () const;

    /**
     * Sets the value of the member "AppHandle".
     *
     * Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     *
     * @param AppHandle The value which will be set
     */
    inline void setAppHandle (uint32 AppHandle_);

    static const TerminateAppStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_AppHandle ();

    inline void clear_has_AppHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    uint32 _AppHandle;

};

/**
 * The result message of the method "TerminateApp"
 * Scope: Only for ML
 * It terminates the remote application running on the Mirror Link device.
 */
class TerminateAppResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TerminateAppResult ();

    /**
     * Copy constructor
     */
    inline  TerminateAppResult (const TerminateAppResult &rhs);

    /**
     * All fields constructor
     */
    inline  TerminateAppResult (uint32 DeviceHandle_, uint32 AppHandle_, ::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~TerminateAppResult();

    /**
     * Assignment operator
     */
    inline TerminateAppResult& operator = (const TerminateAppResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TerminateAppResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TerminateAppResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TerminateAppResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TerminateAppResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "AppHandle"

    static const int kAppHandle = 1;

    /**
     * Clears the field "AppHandle".
     *
     * The field will be set to its default value. The hasAppHandle()
     * method will return false.
     */
    inline void clearAppHandle();

    /**
     * Checks whether the field "AppHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppHandle()). Otherwise it will return false.
     */
    inline bool hasAppHandle () const;

    /**
     * Returns the value of the member "AppHandle".
     *
     * Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     * This value will be 0xFFFFFFFF for DiPO home screen.
     *
     * @return The value of the field "AppHandle"
     */
    inline uint32 getAppHandle () const;

    /**
     * Sets the value of the member "AppHandle".
     *
     * Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     * This value will be 0xFFFFFFFF for DiPO home screen.
     *
     * @param AppHandle The value which will be set
     */
    inline void setAppHandle (uint32 AppHandle_);

    // API of field "ResponseCode"

    static const int kResponseCode = 2;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 3;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const TerminateAppResult &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_AppHandle ();

    inline void clear_has_AppHandle ();

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _DeviceHandle;

    uint32 _AppHandle;

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "GetAppList"
 * Scope: Only for ML
 * It retrieves list of supported applications for the Device Handle provided.
 */
class GetAppListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAppListStart ();

    /**
     * Copy constructor
     */
    inline  GetAppListStart (const GetAppListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetAppListStart (uint32 DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetAppListStart();

    /**
     * Assignment operator
     */
    inline GetAppListStart& operator = (const GetAppListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAppListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAppListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAppListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAppListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    static const GetAppListStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _DeviceHandle;

};

/**
 * The result message of the method "GetAppList"
 * Scope: Only for ML
 * It retrieves list of supported applications for the Device Handle provided.
 */
class GetAppListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAppListResult ();

    /**
     * Copy constructor
     */
    inline  GetAppListResult (const GetAppListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetAppListResult (uint32 DeviceHandle_, uint16 NumAppDetailsList_, const ::std::vector< ::midw_smartphoneint_fi_types::T_AppDetails >& AppDetailsList_);

    /**
     * Destructor
     */
    inline virtual  ~GetAppListResult();

    /**
     * Assignment operator
     */
    inline GetAppListResult& operator = (const GetAppListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAppListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAppListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAppListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAppListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "NumAppDetailsList"

    static const int kNumAppDetailsList = 1;

    /**
     * Clears the field "NumAppDetailsList".
     *
     * The field will be set to its default value. The hasNumAppDetailsList()
     * method will return false.
     */
    inline void clearNumAppDetailsList();

    /**
     * Checks whether the field "NumAppDetailsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumAppDetailsList()). Otherwise it will return false.
     */
    inline bool hasNumAppDetailsList () const;

    /**
     * Returns the value of the member "NumAppDetailsList".
     *
     * Total number of records in AppDetailsList.
     *
     * @return The value of the field "NumAppDetailsList"
     */
    inline uint16 getNumAppDetailsList () const;

    /**
     * Sets the value of the member "NumAppDetailsList".
     *
     * Total number of records in AppDetailsList.
     *
     * @param NumAppDetailsList The value which will be set
     */
    inline void setNumAppDetailsList (uint16 NumAppDetailsList_);

    // API of field "AppDetailsList"

    static const int kAppDetailsList = 2;

    /**
     * Clears the field "AppDetailsList".
     *
     * The field will be set to its default value. The hasAppDetailsList()
     * method will return false.
     */
    inline void clearAppDetailsList();

    /**
     * Checks whether the field "AppDetailsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppDetailsList()). Otherwise it will return false.
     */
    inline bool hasAppDetailsList () const;

    /**
     * Returns the value of the member "AppDetailsList".
     *
     * List of AppInfo records. In case of error, NumAppDetailsList will be set to 0xFFFF and AppDetailsList will be empty.
     *
     * @return The value of the field "AppDetailsList"
     */
    inline const ::std::vector< ::midw_smartphoneint_fi_types::T_AppDetails >& getAppDetailsList () const;

    /**
     * Retrieves the value of the field "AppDetailsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AppDetailsList".
     */
    inline ::std::vector< ::midw_smartphoneint_fi_types::T_AppDetails >& getAppDetailsListMutable ();

    /**
     * Sets the value of the member "AppDetailsList".
     *
     * List of AppInfo records. In case of error, NumAppDetailsList will be set to 0xFFFF and AppDetailsList will be empty.
     *
     * @param AppDetailsList The value which will be set
     */
    inline void setAppDetailsList (const ::std::vector< ::midw_smartphoneint_fi_types::T_AppDetails >& AppDetailsList_);

    static const GetAppListResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_smartphoneint_fi_types::T_AppDetails >& getT_AppDetailsList_DefaultInstance ();

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_NumAppDetailsList ();

    inline void clear_has_NumAppDetailsList ();

    inline void set_has_AppDetailsList ();

    inline void clear_has_AppDetailsList ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    uint16 _NumAppDetailsList;

    ::std::vector< ::midw_smartphoneint_fi_types::T_AppDetails > _AppDetailsList;

};

/**
 * The start message of the method "GetAppIconData"
 * Scope: Only for ML
 * It retrieves icon data referenced by the icon URL provided in the application list.
 */
class GetAppIconDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAppIconDataStart ();

    /**
     * Copy constructor
     */
    inline  GetAppIconDataStart (const GetAppIconDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetAppIconDataStart (const ::std::string& AppIconURL_);

    /**
     * Destructor
     */
    inline virtual  ~GetAppIconDataStart();

    /**
     * Assignment operator
     */
    inline GetAppIconDataStart& operator = (const GetAppIconDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAppIconDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAppIconDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAppIconDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAppIconDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AppIconURL"

    static const int kAppIconURL = 0;

    /**
     * Clears the field "AppIconURL".
     *
     * The field will be set to its default value. The hasAppIconURL()
     * method will return false.
     */
    inline void clearAppIconURL();

    /**
     * Checks whether the field "AppIconURL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppIconURL()). Otherwise it will return false.
     */
    inline bool hasAppIconURL () const;

    /**
     * Returns the value of the member "AppIconURL".
     *
     * Application Icon URL for which the icon data is required.
     *
     * @return The value of the field "AppIconURL"
     */
    inline const ::std::string& getAppIconURL () const;

    /**
     * Retrieves the value of the field "AppIconURL" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AppIconURL".
     */
    inline ::std::string& getAppIconURLMutable ();

    /**
     * Sets the value of the member "AppIconURL".
     *
     * Application Icon URL for which the icon data is required.
     *
     * @param AppIconURL The value which will be set
     */
    inline void setAppIconURL (const ::std::string& AppIconURL_);

    /**
     * Sets the value of the member "AppIconURL".
     *
     * Application Icon URL for which the icon data is required.
     *
     * @param AppIconURL The value which will be set
     */
    inline void setAppIconURL (const char* AppIconURL_);

    /**
     * Sets the value of the member "AppIconURL".
     *
     * Application Icon URL for which the icon data is required.
     *
     * @param AppIconURL The value which will be set
     */
    inline void setAppIconURL (const char* value, size_t size);

    static const GetAppIconDataStart &getDefaultInstance();

private:

    inline void set_has_AppIconURL ();

    inline void clear_has_AppIconURL ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _AppIconURL;

};

/**
 * The result message of the method "GetAppIconData"
 * Scope: Only for ML
 * It retrieves icon data referenced by the icon URL provided in the application list.
 */
class GetAppIconDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAppIconDataResult ();

    /**
     * Copy constructor
     */
    inline  GetAppIconDataResult (const GetAppIconDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetAppIconDataResult (const ::std::string& IconMimeType_, const ::std::vector< uint8 >& AppIconData_);

    /**
     * Destructor
     */
    inline virtual  ~GetAppIconDataResult();

    /**
     * Assignment operator
     */
    inline GetAppIconDataResult& operator = (const GetAppIconDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAppIconDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAppIconDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAppIconDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAppIconDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IconMimeType"

    static const int kIconMimeType = 0;

    /**
     * Clears the field "IconMimeType".
     *
     * The field will be set to its default value. The hasIconMimeType()
     * method will return false.
     */
    inline void clearIconMimeType();

    /**
     * Checks whether the field "IconMimeType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIconMimeType()). Otherwise it will return false.
     */
    inline bool hasIconMimeType () const;

    /**
     * Returns the value of the member "IconMimeType".
     *
     * Mime Type of the icon pointed by AppIconURL. If image is not available then this parameter would be set to NULL (zero length string).
     *
     * @return The value of the field "IconMimeType"
     */
    inline const ::std::string& getIconMimeType () const;

    /**
     * Retrieves the value of the field "IconMimeType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IconMimeType".
     */
    inline ::std::string& getIconMimeTypeMutable ();

    /**
     * Sets the value of the member "IconMimeType".
     *
     * Mime Type of the icon pointed by AppIconURL. If image is not available then this parameter would be set to NULL (zero length string).
     *
     * @param IconMimeType The value which will be set
     */
    inline void setIconMimeType (const ::std::string& IconMimeType_);

    /**
     * Sets the value of the member "IconMimeType".
     *
     * Mime Type of the icon pointed by AppIconURL. If image is not available then this parameter would be set to NULL (zero length string).
     *
     * @param IconMimeType The value which will be set
     */
    inline void setIconMimeType (const char* IconMimeType_);

    /**
     * Sets the value of the member "IconMimeType".
     *
     * Mime Type of the icon pointed by AppIconURL. If image is not available then this parameter would be set to NULL (zero length string).
     *
     * @param IconMimeType The value which will be set
     */
    inline void setIconMimeType (const char* value, size_t size);

    // API of field "AppIconData"

    static const int kAppIconData = 1;

    /**
     * Clears the field "AppIconData".
     *
     * The field will be set to its default value. The hasAppIconData()
     * method will return false.
     */
    inline void clearAppIconData();

    /**
     * Checks whether the field "AppIconData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppIconData()). Otherwise it will return false.
     */
    inline bool hasAppIconData () const;

    /**
     * Returns the value of the member "AppIconData".
     *
     * Byte Data Stream from the icon image file. Format of the file is defined by IconMimeType parameter.
     *
     * @return The value of the field "AppIconData"
     */
    inline const ::std::vector< uint8 >& getAppIconData () const;

    /**
     * Retrieves the value of the field "AppIconData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AppIconData".
     */
    inline ::std::vector< uint8 >& getAppIconDataMutable ();

    /**
     * Sets the value of the member "AppIconData".
     *
     * Byte Data Stream from the icon image file. Format of the file is defined by IconMimeType parameter.
     *
     * @param AppIconData The value which will be set
     */
    inline void setAppIconData (const ::std::vector< uint8 >& AppIconData_);

    static const GetAppIconDataResult &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_IconMimeType ();

    inline void clear_has_IconMimeType ();

    inline void set_has_AppIconData ();

    inline void clear_has_AppIconData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _IconMimeType;

    ::std::vector< uint8 > _AppIconData;

};

/**
 * The start message of the method "SetAppIconAttributes"
 * Scope: Only for ML
 * It sets application icon attributes for retrieval of application icons for a Mirror Link device.
 */
class SetAppIconAttributesStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAppIconAttributesStart ();

    /**
     * Copy constructor
     */
    inline  SetAppIconAttributesStart (const SetAppIconAttributesStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetAppIconAttributesStart (uint32 DeviceHandle_, uint32 AppHandle_, const ::midw_smartphoneint_fi_types::T_IconAttributes& IconAttributes_);

    /**
     * Destructor
     */
    inline virtual  ~SetAppIconAttributesStart();

    /**
     * Assignment operator
     */
    inline SetAppIconAttributesStart& operator = (const SetAppIconAttributesStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAppIconAttributesStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAppIconAttributesStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAppIconAttributesStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAppIconAttributesStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Handle uniquely identifies a device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Handle uniquely identifies a device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "AppHandle"

    static const int kAppHandle = 1;

    /**
     * Clears the field "AppHandle".
     *
     * The field will be set to its default value. The hasAppHandle()
     * method will return false.
     */
    inline void clearAppHandle();

    /**
     * Checks whether the field "AppHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppHandle()). Otherwise it will return false.
     */
    inline bool hasAppHandle () const;

    /**
     * Returns the value of the member "AppHandle".
     *
     * Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     *
     * @return The value of the field "AppHandle"
     */
    inline uint32 getAppHandle () const;

    /**
     * Sets the value of the member "AppHandle".
     *
     * Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     *
     * @param AppHandle The value which will be set
     */
    inline void setAppHandle (uint32 AppHandle_);

    // API of field "IconAttributes"

    static const int kIconAttributes = 2;

    /**
     * Clears the field "IconAttributes".
     *
     * The field will be set to its default value. The hasIconAttributes()
     * method will return false.
     */
    inline void clearIconAttributes();

    /**
     * Checks whether the field "IconAttributes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIconAttributes()). Otherwise it will return false.
     */
    inline bool hasIconAttributes () const;

    /**
     * Returns the value of the member "IconAttributes".
     *
     * Provides the Icon details.
     *
     * @return The value of the field "IconAttributes"
     */
    inline const ::midw_smartphoneint_fi_types::T_IconAttributes& getIconAttributes () const;

    /**
     * Retrieves the value of the field "IconAttributes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IconAttributes".
     */
    inline ::midw_smartphoneint_fi_types::T_IconAttributes& getIconAttributesMutable ();

    /**
     * Sets the value of the member "IconAttributes".
     *
     * Provides the Icon details.
     *
     * @param IconAttributes The value which will be set
     */
    inline void setIconAttributes (const ::midw_smartphoneint_fi_types::T_IconAttributes& IconAttributes_);

    static const SetAppIconAttributesStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_AppHandle ();

    inline void clear_has_AppHandle ();

    inline void set_has_IconAttributes ();

    inline void clear_has_IconAttributes ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    uint32 _AppHandle;

    ::midw_smartphoneint_fi_types::T_IconAttributes _IconAttributes;

};

/**
 * The result message of the method "SetAppIconAttributes"
 * Scope: Only for ML
 * It sets application icon attributes for retrieval of application icons for a Mirror Link device.
 */
class SetAppIconAttributesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAppIconAttributesResult ();

    /**
     * Copy constructor
     */
    inline  SetAppIconAttributesResult (const SetAppIconAttributesResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetAppIconAttributesResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetAppIconAttributesResult();

    /**
     * Assignment operator
     */
    inline SetAppIconAttributesResult& operator = (const SetAppIconAttributesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAppIconAttributesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAppIconAttributesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAppIconAttributesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAppIconAttributesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetAppIconAttributesResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetDeviceUsagePreference"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * Interface to set the preference for the usage of the connected device.
 */
class SetDeviceUsagePreferenceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDeviceUsagePreferenceStart ();

    /**
     * Copy constructor
     */
    inline  SetDeviceUsagePreferenceStart (const SetDeviceUsagePreferenceStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetDeviceUsagePreferenceStart (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_, ::midw_smartphoneint_fi_types::T_e8_EnabledInfo EnabledInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SetDeviceUsagePreferenceStart();

    /**
     * Assignment operator
     */
    inline SetDeviceUsagePreferenceStart& operator = (const SetDeviceUsagePreferenceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDeviceUsagePreferenceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDeviceUsagePreferenceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDeviceUsagePreferenceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDeviceUsagePreferenceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function sets the overall preference usage for Mirror Link/DiPO/Android Auto.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function sets the overall preference usage for Mirror Link/DiPO/Android Auto.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 1;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Provides Device Type Information.
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Provides Device Type Information.
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    // API of field "EnabledInfo"

    static const int kEnabledInfo = 2;

    /**
     * Clears the field "EnabledInfo".
     *
     * The field will be set to its default value. The hasEnabledInfo()
     * method will return false.
     */
    inline void clearEnabledInfo();

    /**
     * Checks whether the field "EnabledInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnabledInfo()). Otherwise it will return false.
     */
    inline bool hasEnabledInfo () const;

    /**
     * Returns the value of the member "EnabledInfo".
     *
     * Provides Enable Information.
     *
     * @return The value of the field "EnabledInfo"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_EnabledInfo getEnabledInfo () const;

    /**
     * Sets the value of the member "EnabledInfo".
     *
     * Provides Enable Information.
     *
     * @param EnabledInfo The value which will be set
     */
    inline void setEnabledInfo (::midw_smartphoneint_fi_types::T_e8_EnabledInfo EnabledInfo_);

    static const SetDeviceUsagePreferenceStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    inline void set_has_EnabledInfo ();

    inline void clear_has_EnabledInfo ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

    ::midw_smartphoneint_fi_types::T_e8_EnabledInfo _EnabledInfo;

};

/**
 * The result message of the method "SetDeviceUsagePreference"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * Interface to set the preference for the usage of the connected device.
 */
class SetDeviceUsagePreferenceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDeviceUsagePreferenceResult ();

    /**
     * Copy constructor
     */
    inline  SetDeviceUsagePreferenceResult (const SetDeviceUsagePreferenceResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetDeviceUsagePreferenceResult (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetDeviceUsagePreferenceResult();

    /**
     * Assignment operator
     */
    inline SetDeviceUsagePreferenceResult& operator = (const SetDeviceUsagePreferenceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDeviceUsagePreferenceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDeviceUsagePreferenceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDeviceUsagePreferenceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDeviceUsagePreferenceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device for the SetDeviceUsagePreference was requested.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device for the SetDeviceUsagePreference was requested.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "ResponseCode"

    static const int kResponseCode = 1;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 2;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetDeviceUsagePreferenceResult &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetMLNotificationEnabledInfo"
 * Scope: Only for ML
 * Interface to set the device notification preference for applications.
 * If notification for all the applications has to be:
 * Enabled - Set NumNotificationEnableList to 0xFF and NotificationEnableList should be empty.
 * Disabled - Set NumNotificationEnableList to 0x00 and NotificationEnableList should be empty.
 */
class SetMLNotificationEnabledInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMLNotificationEnabledInfoStart ();

    /**
     * Copy constructor
     */
    inline  SetMLNotificationEnabledInfoStart (const SetMLNotificationEnabledInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetMLNotificationEnabledInfoStart (uint32 DeviceHandle_, uint16 NumNotificationEnableList_, const ::std::vector< ::midw_smartphoneint_fi_types::T_NotificationEnable >& NotificationEnableList_);

    /**
     * Destructor
     */
    inline virtual  ~SetMLNotificationEnabledInfoStart();

    /**
     * Assignment operator
     */
    inline SetMLNotificationEnabledInfoStart& operator = (const SetMLNotificationEnabledInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMLNotificationEnabledInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMLNotificationEnabledInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMLNotificationEnabledInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMLNotificationEnabledInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Handle uniquely identifies a device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Handle uniquely identifies a device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "NumNotificationEnableList"

    static const int kNumNotificationEnableList = 1;

    /**
     * Clears the field "NumNotificationEnableList".
     *
     * The field will be set to its default value. The hasNumNotificationEnableList()
     * method will return false.
     */
    inline void clearNumNotificationEnableList();

    /**
     * Checks whether the field "NumNotificationEnableList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumNotificationEnableList()). Otherwise it will return false.
     */
    inline bool hasNumNotificationEnableList () const;

    /**
     * Returns the value of the member "NumNotificationEnableList".
     *
     * Total number of records in NotificationEnableList.
     *
     * @return The value of the field "NumNotificationEnableList"
     */
    inline uint16 getNumNotificationEnableList () const;

    /**
     * Sets the value of the member "NumNotificationEnableList".
     *
     * Total number of records in NotificationEnableList.
     *
     * @param NumNotificationEnableList The value which will be set
     */
    inline void setNumNotificationEnableList (uint16 NumNotificationEnableList_);

    // API of field "NotificationEnableList"

    static const int kNotificationEnableList = 2;

    /**
     * Clears the field "NotificationEnableList".
     *
     * The field will be set to its default value. The hasNotificationEnableList()
     * method will return false.
     */
    inline void clearNotificationEnableList();

    /**
     * Checks whether the field "NotificationEnableList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotificationEnableList()). Otherwise it will return false.
     */
    inline bool hasNotificationEnableList () const;

    /**
     * Returns the value of the member "NotificationEnableList".
     *
     * List of NotificationEnable records.
     *
     * @return The value of the field "NotificationEnableList"
     */
    inline const ::std::vector< ::midw_smartphoneint_fi_types::T_NotificationEnable >& getNotificationEnableList () const;

    /**
     * Retrieves the value of the field "NotificationEnableList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NotificationEnableList".
     */
    inline ::std::vector< ::midw_smartphoneint_fi_types::T_NotificationEnable >& getNotificationEnableListMutable ();

    /**
     * Sets the value of the member "NotificationEnableList".
     *
     * List of NotificationEnable records.
     *
     * @param NotificationEnableList The value which will be set
     */
    inline void setNotificationEnableList (const ::std::vector< ::midw_smartphoneint_fi_types::T_NotificationEnable >& NotificationEnableList_);

    static const SetMLNotificationEnabledInfoStart &getDefaultInstance();

private:

    static const ::std::vector< ::midw_smartphoneint_fi_types::T_NotificationEnable >& getT_NotificationEnableList_DefaultInstance ();

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_NumNotificationEnableList ();

    inline void clear_has_NumNotificationEnableList ();

    inline void set_has_NotificationEnableList ();

    inline void clear_has_NotificationEnableList ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    uint16 _NumNotificationEnableList;

    ::std::vector< ::midw_smartphoneint_fi_types::T_NotificationEnable > _NotificationEnableList;

};

/**
 * The result message of the method "SetMLNotificationEnabledInfo"
 * Scope: Only for ML
 * Interface to set the device notification preference for applications.
 * If notification for all the applications has to be:
 * Enabled - Set NumNotificationEnableList to 0xFF and NotificationEnableList should be empty.
 * Disabled - Set NumNotificationEnableList to 0x00 and NotificationEnableList should be empty.
 */
class SetMLNotificationEnabledInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMLNotificationEnabledInfoResult ();

    /**
     * Copy constructor
     */
    inline  SetMLNotificationEnabledInfoResult (const SetMLNotificationEnabledInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetMLNotificationEnabledInfoResult (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetMLNotificationEnabledInfoResult();

    /**
     * Assignment operator
     */
    inline SetMLNotificationEnabledInfoResult& operator = (const SetMLNotificationEnabledInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMLNotificationEnabledInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMLNotificationEnabledInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMLNotificationEnabledInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMLNotificationEnabledInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Handle uniquely identifies a device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Handle uniquely identifies a device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "ResponseCode"

    static const int kResponseCode = 1;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 2;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetMLNotificationEnabledInfoResult &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "InvokeNotificationAction"
 * Scope: Only ML
 * Interface to invoke the respective action for the received Notification Event.
 */
class InvokeNotificationActionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InvokeNotificationActionStart ();

    /**
     * Copy constructor
     */
    inline  InvokeNotificationActionStart (const InvokeNotificationActionStart &rhs);

    /**
     * All fields constructor
     */
    inline  InvokeNotificationActionStart (uint32 DeviceHandle_, uint32 AppHandle_, uint16 NotificationID_, uint16 NotificationActionID_);

    /**
     * Destructor
     */
    inline virtual  ~InvokeNotificationActionStart();

    /**
     * Assignment operator
     */
    inline InvokeNotificationActionStart& operator = (const InvokeNotificationActionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InvokeNotificationActionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InvokeNotificationActionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InvokeNotificationActionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InvokeNotificationActionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Handle uniquely identifies a device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Handle uniquely identifies a device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "AppHandle"

    static const int kAppHandle = 1;

    /**
     * Clears the field "AppHandle".
     *
     * The field will be set to its default value. The hasAppHandle()
     * method will return false.
     */
    inline void clearAppHandle();

    /**
     * Checks whether the field "AppHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppHandle()). Otherwise it will return false.
     */
    inline bool hasAppHandle () const;

    /**
     * Returns the value of the member "AppHandle".
     *
     * Handle uniquely identifies an application on the device.
     *
     * @return The value of the field "AppHandle"
     */
    inline uint32 getAppHandle () const;

    /**
     * Sets the value of the member "AppHandle".
     *
     * Handle uniquely identifies an application on the device.
     *
     * @param AppHandle The value which will be set
     */
    inline void setAppHandle (uint32 AppHandle_);

    // API of field "NotificationID"

    static const int kNotificationID = 2;

    /**
     * Clears the field "NotificationID".
     *
     * The field will be set to its default value. The hasNotificationID()
     * method will return false.
     */
    inline void clearNotificationID();

    /**
     * Checks whether the field "NotificationID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotificationID()). Otherwise it will return false.
     */
    inline bool hasNotificationID () const;

    /**
     * Returns the value of the member "NotificationID".
     *
     * Notification Identifier.
     *
     * @return The value of the field "NotificationID"
     */
    inline uint16 getNotificationID () const;

    /**
     * Sets the value of the member "NotificationID".
     *
     * Notification Identifier.
     *
     * @param NotificationID The value which will be set
     */
    inline void setNotificationID (uint16 NotificationID_);

    // API of field "NotificationActionID"

    static const int kNotificationActionID = 3;

    /**
     * Clears the field "NotificationActionID".
     *
     * The field will be set to its default value. The hasNotificationActionID()
     * method will return false.
     */
    inline void clearNotificationActionID();

    /**
     * Checks whether the field "NotificationActionID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotificationActionID()). Otherwise it will return false.
     */
    inline bool hasNotificationActionID () const;

    /**
     * Returns the value of the member "NotificationActionID".
     *
     * Notification action Identifier.
     *
     * @return The value of the field "NotificationActionID"
     */
    inline uint16 getNotificationActionID () const;

    /**
     * Sets the value of the member "NotificationActionID".
     *
     * Notification action Identifier.
     *
     * @param NotificationActionID The value which will be set
     */
    inline void setNotificationActionID (uint16 NotificationActionID_);

    static const InvokeNotificationActionStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_AppHandle ();

    inline void clear_has_AppHandle ();

    inline void set_has_NotificationID ();

    inline void clear_has_NotificationID ();

    inline void set_has_NotificationActionID ();

    inline void clear_has_NotificationActionID ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _DeviceHandle;

    uint32 _AppHandle;

    uint16 _NotificationID;

    uint16 _NotificationActionID;

};

/**
 * The result message of the method "InvokeNotificationAction"
 * Scope: Only ML
 * Interface to invoke the respective action for the received Notification Event.
 */
class InvokeNotificationActionResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InvokeNotificationActionResult ();

    /**
     * Copy constructor
     */
    inline  InvokeNotificationActionResult (const InvokeNotificationActionResult &rhs);

    /**
     * All fields constructor
     */
    inline  InvokeNotificationActionResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~InvokeNotificationActionResult();

    /**
     * Assignment operator
     */
    inline InvokeNotificationActionResult& operator = (const InvokeNotificationActionResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InvokeNotificationActionResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InvokeNotificationActionResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InvokeNotificationActionResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InvokeNotificationActionResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const InvokeNotificationActionResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "GetVideoSettings"
 * It provides current Video Settings.
 */
class GetVideoSettingsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetVideoSettingsStart ();

    /**
     * Copy constructor
     */
    inline  GetVideoSettingsStart (const GetVideoSettingsStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetVideoSettingsStart (uint32 DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetVideoSettingsStart();

    /**
     * Assignment operator
     */
    inline GetVideoSettingsStart& operator = (const GetVideoSettingsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetVideoSettingsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetVideoSettingsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetVideoSettingsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetVideoSettingsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    static const GetVideoSettingsStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _DeviceHandle;

};

/**
 * The result message of the method "GetVideoSettings"
 * It provides current Video Settings.
 */
class GetVideoSettingsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetVideoSettingsResult ();

    /**
     * Copy constructor
     */
    inline  GetVideoSettingsResult (const GetVideoSettingsResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetVideoSettingsResult (uint32 DeviceHandle_, const ::midw_smartphoneint_fi_types::T_VideoAttributes& VideoAttributes_);

    /**
     * Destructor
     */
    inline virtual  ~GetVideoSettingsResult();

    /**
     * Assignment operator
     */
    inline GetVideoSettingsResult& operator = (const GetVideoSettingsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetVideoSettingsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetVideoSettingsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetVideoSettingsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetVideoSettingsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "VideoAttributes"

    static const int kVideoAttributes = 1;

    /**
     * Clears the field "VideoAttributes".
     *
     * The field will be set to its default value. The hasVideoAttributes()
     * method will return false.
     */
    inline void clearVideoAttributes();

    /**
     * Checks whether the field "VideoAttributes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVideoAttributes()). Otherwise it will return false.
     */
    inline bool hasVideoAttributes () const;

    /**
     * Returns the value of the member "VideoAttributes".
     *
     * Provides current Video settings. In case of error in retrieving the attributes, corresponding values will be set to INVALID.
     *
     * @return The value of the field "VideoAttributes"
     */
    inline const ::midw_smartphoneint_fi_types::T_VideoAttributes& getVideoAttributes () const;

    /**
     * Retrieves the value of the field "VideoAttributes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VideoAttributes".
     */
    inline ::midw_smartphoneint_fi_types::T_VideoAttributes& getVideoAttributesMutable ();

    /**
     * Sets the value of the member "VideoAttributes".
     *
     * Provides current Video settings. In case of error in retrieving the attributes, corresponding values will be set to INVALID.
     *
     * @param VideoAttributes The value which will be set
     */
    inline void setVideoAttributes (const ::midw_smartphoneint_fi_types::T_VideoAttributes& VideoAttributes_);

    static const GetVideoSettingsResult &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_VideoAttributes ();

    inline void clear_has_VideoAttributes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_VideoAttributes _VideoAttributes;

};

/**
 * The start message of the method "SetOrientationMode"
 * Interface to set the orientation mode of the projected display.
 */
class SetOrientationModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetOrientationModeStart ();

    /**
     * Copy constructor
     */
    inline  SetOrientationModeStart (const SetOrientationModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetOrientationModeStart (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_OrientationMode OrientationMode_);

    /**
     * Destructor
     */
    inline virtual  ~SetOrientationModeStart();

    /**
     * Assignment operator
     */
    inline SetOrientationModeStart& operator = (const SetOrientationModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetOrientationModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetOrientationModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetOrientationModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetOrientationModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "OrientationMode"

    static const int kOrientationMode = 1;

    /**
     * Clears the field "OrientationMode".
     *
     * The field will be set to its default value. The hasOrientationMode()
     * method will return false.
     */
    inline void clearOrientationMode();

    /**
     * Checks whether the field "OrientationMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOrientationMode()). Otherwise it will return false.
     */
    inline bool hasOrientationMode () const;

    /**
     * Returns the value of the member "OrientationMode".
     *
     * Orientation Mode Value.
     *
     * @return The value of the field "OrientationMode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_OrientationMode getOrientationMode () const;

    /**
     * Sets the value of the member "OrientationMode".
     *
     * Orientation Mode Value.
     *
     * @param OrientationMode The value which will be set
     */
    inline void setOrientationMode (::midw_smartphoneint_fi_types::T_e8_OrientationMode OrientationMode_);

    static const SetOrientationModeStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_OrientationMode ();

    inline void clear_has_OrientationMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_OrientationMode _OrientationMode;

};

/**
 * The result message of the method "SetOrientationMode"
 * Interface to set the orientation mode of the projected display.
 */
class SetOrientationModeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetOrientationModeResult ();

    /**
     * Copy constructor
     */
    inline  SetOrientationModeResult (const SetOrientationModeResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetOrientationModeResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetOrientationModeResult();

    /**
     * Assignment operator
     */
    inline SetOrientationModeResult& operator = (const SetOrientationModeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetOrientationModeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetOrientationModeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetOrientationModeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetOrientationModeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetOrientationModeResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetScreenSize"
 * Interface to set the screen size of Head Unit.
 * -- This method is deprecated instead use SetDisplayAttributes.
 */
class SetScreenSizeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetScreenSizeStart ();

    /**
     * Copy constructor
     */
    inline  SetScreenSizeStart (const SetScreenSizeStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetScreenSizeStart (const ::midw_smartphoneint_fi_types::T_ScreenAttributes& ScreenAttributes_);

    /**
     * Destructor
     */
    inline virtual  ~SetScreenSizeStart();

    /**
     * Assignment operator
     */
    inline SetScreenSizeStart& operator = (const SetScreenSizeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetScreenSizeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetScreenSizeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetScreenSizeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetScreenSizeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ScreenAttributes"

    static const int kScreenAttributes = 0;

    /**
     * Clears the field "ScreenAttributes".
     *
     * The field will be set to its default value. The hasScreenAttributes()
     * method will return false.
     */
    inline void clearScreenAttributes();

    /**
     * Checks whether the field "ScreenAttributes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScreenAttributes()). Otherwise it will return false.
     */
    inline bool hasScreenAttributes () const;

    /**
     * Returns the value of the member "ScreenAttributes".
     *
     * Screen Setting attributes.
     *
     * @return The value of the field "ScreenAttributes"
     */
    inline const ::midw_smartphoneint_fi_types::T_ScreenAttributes& getScreenAttributes () const;

    /**
     * Retrieves the value of the field "ScreenAttributes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ScreenAttributes".
     */
    inline ::midw_smartphoneint_fi_types::T_ScreenAttributes& getScreenAttributesMutable ();

    /**
     * Sets the value of the member "ScreenAttributes".
     *
     * Screen Setting attributes.
     *
     * @param ScreenAttributes The value which will be set
     */
    inline void setScreenAttributes (const ::midw_smartphoneint_fi_types::T_ScreenAttributes& ScreenAttributes_);

    static const SetScreenSizeStart &getDefaultInstance();

private:

    inline void set_has_ScreenAttributes ();

    inline void clear_has_ScreenAttributes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_ScreenAttributes _ScreenAttributes;

};

/**
 * The result message of the method "SetScreenSize"
 * Interface to set the screen size of Head Unit.
 * -- This method is deprecated instead use SetDisplayAttributes.
 */
class SetScreenSizeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetScreenSizeResult ();

    /**
     * Copy constructor
     */
    inline  SetScreenSizeResult (const SetScreenSizeResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetScreenSizeResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetScreenSizeResult();

    /**
     * Assignment operator
     */
    inline SetScreenSizeResult& operator = (const SetScreenSizeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetScreenSizeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetScreenSizeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetScreenSizeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetScreenSizeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     * If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     * If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetScreenSizeResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetVideoBlockingMode"
 * Scope: Only for ML, for other technologies use SetAccessoryDisplayContext
 * Interface to set the display blocking mode.
 */
class SetVideoBlockingModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVideoBlockingModeStart ();

    /**
     * Copy constructor
     */
    inline  SetVideoBlockingModeStart (const SetVideoBlockingModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetVideoBlockingModeStart (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_BlockingMode BlockingMode_, ::midw_smartphoneint_fi_types::T_e8_VideoBlockingReason VideoBlockingReason_);

    /**
     * Destructor
     */
    inline virtual  ~SetVideoBlockingModeStart();

    /**
     * Assignment operator
     */
    inline SetVideoBlockingModeStart& operator = (const SetVideoBlockingModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVideoBlockingModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVideoBlockingModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVideoBlockingModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVideoBlockingModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "BlockingMode"

    static const int kBlockingMode = 1;

    /**
     * Clears the field "BlockingMode".
     *
     * The field will be set to its default value. The hasBlockingMode()
     * method will return false.
     */
    inline void clearBlockingMode();

    /**
     * Checks whether the field "BlockingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBlockingMode()). Otherwise it will return false.
     */
    inline bool hasBlockingMode () const;

    /**
     * Returns the value of the member "BlockingMode".
     *
     * Identifies the Blocking Mode.
     *
     * @return The value of the field "BlockingMode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_BlockingMode getBlockingMode () const;

    /**
     * Sets the value of the member "BlockingMode".
     *
     * Identifies the Blocking Mode.
     *
     * @param BlockingMode The value which will be set
     */
    inline void setBlockingMode (::midw_smartphoneint_fi_types::T_e8_BlockingMode BlockingMode_);

    // API of field "VideoBlockingReason"

    static const int kVideoBlockingReason = 2;

    /**
     * Clears the field "VideoBlockingReason".
     *
     * The field will be set to its default value. The hasVideoBlockingReason()
     * method will return false.
     */
    inline void clearVideoBlockingReason();

    /**
     * Checks whether the field "VideoBlockingReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVideoBlockingReason()). Otherwise it will return false.
     */
    inline bool hasVideoBlockingReason () const;

    /**
     * Returns the value of the member "VideoBlockingReason".
     *
     * Identifies the reason for Video Blocking
     *
     * @return The value of the field "VideoBlockingReason"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_VideoBlockingReason getVideoBlockingReason () const;

    /**
     * Sets the value of the member "VideoBlockingReason".
     *
     * Identifies the reason for Video Blocking
     *
     * @param VideoBlockingReason The value which will be set
     */
    inline void setVideoBlockingReason (::midw_smartphoneint_fi_types::T_e8_VideoBlockingReason VideoBlockingReason_);

    static const SetVideoBlockingModeStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_BlockingMode ();

    inline void clear_has_BlockingMode ();

    inline void set_has_VideoBlockingReason ();

    inline void clear_has_VideoBlockingReason ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_BlockingMode _BlockingMode;

    ::midw_smartphoneint_fi_types::T_e8_VideoBlockingReason _VideoBlockingReason;

};

/**
 * The result message of the method "SetVideoBlockingMode"
 * Scope: Only for ML, for other technologies use SetAccessoryDisplayContext
 * Interface to set the display blocking mode.
 */
class SetVideoBlockingModeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVideoBlockingModeResult ();

    /**
     * Copy constructor
     */
    inline  SetVideoBlockingModeResult (const SetVideoBlockingModeResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetVideoBlockingModeResult (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetVideoBlockingModeResult();

    /**
     * Assignment operator
     */
    inline SetVideoBlockingModeResult& operator = (const SetVideoBlockingModeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVideoBlockingModeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVideoBlockingModeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVideoBlockingModeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVideoBlockingModeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "ResponseCode"

    static const int kResponseCode = 1;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 2;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetVideoBlockingModeResult &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetAudioBlockingMode"
 * Scope: Only for ML
 * Interface to set the audio blocking mode.
 */
class SetAudioBlockingModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAudioBlockingModeStart ();

    /**
     * Copy constructor
     */
    inline  SetAudioBlockingModeStart (const SetAudioBlockingModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetAudioBlockingModeStart (bool GlobalMuteEnable_, bool MediaAudioBlockingEnable_);

    /**
     * Destructor
     */
    inline virtual  ~SetAudioBlockingModeStart();

    /**
     * Assignment operator
     */
    inline SetAudioBlockingModeStart& operator = (const SetAudioBlockingModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAudioBlockingModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAudioBlockingModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAudioBlockingModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAudioBlockingModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GlobalMuteEnable"

    static const int kGlobalMuteEnable = 0;

    /**
     * Clears the field "GlobalMuteEnable".
     *
     * The field will be set to its default value. The hasGlobalMuteEnable()
     * method will return false.
     */
    inline void clearGlobalMuteEnable();

    /**
     * Checks whether the field "GlobalMuteEnable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlobalMuteEnable()). Otherwise it will return false.
     */
    inline bool hasGlobalMuteEnable () const;

    /**
     * Returns the value of the member "GlobalMuteEnable".
     *
     * Identifies whether Global mute is enabled or not
     *
     * @return The value of the field "GlobalMuteEnable"
     */
    inline bool getGlobalMuteEnable () const;

    /**
     * Sets the value of the member "GlobalMuteEnable".
     *
     * Identifies whether Global mute is enabled or not
     *
     * @param GlobalMuteEnable The value which will be set
     */
    inline void setGlobalMuteEnable (bool GlobalMuteEnable_);

    // API of field "MediaAudioBlockingEnable"

    static const int kMediaAudioBlockingEnable = 1;

    /**
     * Clears the field "MediaAudioBlockingEnable".
     *
     * The field will be set to its default value. The hasMediaAudioBlockingEnable()
     * method will return false.
     */
    inline void clearMediaAudioBlockingEnable();

    /**
     * Checks whether the field "MediaAudioBlockingEnable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaAudioBlockingEnable()). Otherwise it will return false.
     */
    inline bool hasMediaAudioBlockingEnable () const;

    /**
     * Returns the value of the member "MediaAudioBlockingEnable".
     *
     * Identifies whether Media Audio Blocking is enabled or not
     *
     * @return The value of the field "MediaAudioBlockingEnable"
     */
    inline bool getMediaAudioBlockingEnable () const;

    /**
     * Sets the value of the member "MediaAudioBlockingEnable".
     *
     * Identifies whether Media Audio Blocking is enabled or not
     *
     * @param MediaAudioBlockingEnable The value which will be set
     */
    inline void setMediaAudioBlockingEnable (bool MediaAudioBlockingEnable_);

    static const SetAudioBlockingModeStart &getDefaultInstance();

private:

    inline void set_has_GlobalMuteEnable ();

    inline void clear_has_GlobalMuteEnable ();

    inline void set_has_MediaAudioBlockingEnable ();

    inline void clear_has_MediaAudioBlockingEnable ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _GlobalMuteEnable;

    bool _MediaAudioBlockingEnable;

};

/**
 * The result message of the method "SetAudioBlockingMode"
 * Scope: Only for ML
 * Interface to set the audio blocking mode.
 */
class SetAudioBlockingModeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAudioBlockingModeResult ();

    /**
     * Copy constructor
     */
    inline  SetAudioBlockingModeResult (const SetAudioBlockingModeResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetAudioBlockingModeResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetAudioBlockingModeResult();

    /**
     * Assignment operator
     */
    inline SetAudioBlockingModeResult& operator = (const SetAudioBlockingModeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAudioBlockingModeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAudioBlockingModeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAudioBlockingModeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAudioBlockingModeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetAudioBlockingModeResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetVehicleConfiguration"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * Interface to set the Vehicle configurations.
 * Use method SetVehicleMovementState to provide Park/Drive Mode Info.
 * The Drive or park mode information is deprecated from T_e8_Vehicle_Configuration.
 */
class SetVehicleConfigurationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVehicleConfigurationStart ();

    /**
     * Copy constructor
     */
    inline  SetVehicleConfigurationStart (const SetVehicleConfigurationStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetVehicleConfigurationStart (::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration VehicleConfiguration_, bool SetConfiguration_);

    /**
     * Destructor
     */
    inline virtual  ~SetVehicleConfigurationStart();

    /**
     * Assignment operator
     */
    inline SetVehicleConfigurationStart& operator = (const SetVehicleConfigurationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVehicleConfigurationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVehicleConfigurationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVehicleConfigurationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVehicleConfigurationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VehicleConfiguration"

    static const int kVehicleConfiguration = 0;

    /**
     * Clears the field "VehicleConfiguration".
     *
     * The field will be set to its default value. The hasVehicleConfiguration()
     * method will return false.
     */
    inline void clearVehicleConfiguration();

    /**
     * Checks whether the field "VehicleConfiguration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleConfiguration()). Otherwise it will return false.
     */
    inline bool hasVehicleConfiguration () const;

    /**
     * Returns the value of the member "VehicleConfiguration".
     *
     * Identifies the Vehicle configuration.It contains DAY or NIGHT MODE, and Right/left hand drive.
     * currently all these parameters are enabled by default.
     *
     * @return The value of the field "VehicleConfiguration"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration getVehicleConfiguration () const;

    /**
     * Sets the value of the member "VehicleConfiguration".
     *
     * Identifies the Vehicle configuration.It contains DAY or NIGHT MODE, and Right/left hand drive.
     * currently all these parameters are enabled by default.
     *
     * @param VehicleConfiguration The value which will be set
     */
    inline void setVehicleConfiguration (::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration VehicleConfiguration_);

    // API of field "SetConfiguration"

    static const int kSetConfiguration = 1;

    /**
     * Clears the field "SetConfiguration".
     *
     * The field will be set to its default value. The hasSetConfiguration()
     * method will return false.
     */
    inline void clearSetConfiguration();

    /**
     * Checks whether the field "SetConfiguration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSetConfiguration()). Otherwise it will return false.
     */
    inline bool hasSetConfiguration () const;

    /**
     * Returns the value of the member "SetConfiguration".
     *
     * Identifies whether to enable/disable vehicle configuration.
     * For currently supported configurations it is unused.
     *
     * @return The value of the field "SetConfiguration"
     */
    inline bool getSetConfiguration () const;

    /**
     * Sets the value of the member "SetConfiguration".
     *
     * Identifies whether to enable/disable vehicle configuration.
     * For currently supported configurations it is unused.
     *
     * @param SetConfiguration The value which will be set
     */
    inline void setSetConfiguration (bool SetConfiguration_);

    static const SetVehicleConfigurationStart &getDefaultInstance();

private:

    inline void set_has_VehicleConfiguration ();

    inline void clear_has_VehicleConfiguration ();

    inline void set_has_SetConfiguration ();

    inline void clear_has_SetConfiguration ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration _VehicleConfiguration;

    bool _SetConfiguration;

};

/**
 * The result message of the method "SetVehicleConfiguration"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * Interface to set the Vehicle configurations.
 * Use method SetVehicleMovementState to provide Park/Drive Mode Info.
 * The Drive or park mode information is deprecated from T_e8_Vehicle_Configuration.
 */
class SetVehicleConfigurationResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVehicleConfigurationResult ();

    /**
     * Copy constructor
     */
    inline  SetVehicleConfigurationResult (const SetVehicleConfigurationResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetVehicleConfigurationResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetVehicleConfigurationResult();

    /**
     * Assignment operator
     */
    inline SetVehicleConfigurationResult& operator = (const SetVehicleConfigurationResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVehicleConfigurationResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVehicleConfigurationResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVehicleConfigurationResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVehicleConfigurationResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetVehicleConfigurationResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SendTouchEvent"
 * Interface to set the Touch or Pointer events.
 */
class SendTouchEventStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendTouchEventStart ();

    /**
     * Copy constructor
     */
    inline  SendTouchEventStart (const SendTouchEventStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendTouchEventStart (uint32 DeviceHandle_, const ::midw_smartphoneint_fi_types::T_TouchData& TouchData_);

    /**
     * Destructor
     */
    inline virtual  ~SendTouchEventStart();

    /**
     * Assignment operator
     */
    inline SendTouchEventStart& operator = (const SendTouchEventStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendTouchEventStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendTouchEventStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendTouchEventStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendTouchEventStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "TouchData"

    static const int kTouchData = 1;

    /**
     * Clears the field "TouchData".
     *
     * The field will be set to its default value. The hasTouchData()
     * method will return false.
     */
    inline void clearTouchData();

    /**
     * Checks whether the field "TouchData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTouchData()). Otherwise it will return false.
     */
    inline bool hasTouchData () const;

    /**
     * Returns the value of the member "TouchData".
     *
     * Contains Touch information.
     *
     * @return The value of the field "TouchData"
     */
    inline const ::midw_smartphoneint_fi_types::T_TouchData& getTouchData () const;

    /**
     * Retrieves the value of the field "TouchData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TouchData".
     */
    inline ::midw_smartphoneint_fi_types::T_TouchData& getTouchDataMutable ();

    /**
     * Sets the value of the member "TouchData".
     *
     * Contains Touch information.
     *
     * @param TouchData The value which will be set
     */
    inline void setTouchData (const ::midw_smartphoneint_fi_types::T_TouchData& TouchData_);

    static const SendTouchEventStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_TouchData ();

    inline void clear_has_TouchData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_TouchData _TouchData;

};

/**
 * The result message of the method "SendTouchEvent"
 * Interface to set the Touch or Pointer events.
 */
class SendTouchEventResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendTouchEventResult ();

    /**
     * Copy constructor
     */
    inline  SendTouchEventResult (const SendTouchEventResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendTouchEventResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SendTouchEventResult();

    /**
     * Assignment operator
     */
    inline SendTouchEventResult& operator = (const SendTouchEventResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendTouchEventResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendTouchEventResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendTouchEventResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendTouchEventResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SendTouchEventResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SendKeyEvent"
 * Interface to set the Touch or Pointer events.
 */
class SendKeyEventStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendKeyEventStart ();

    /**
     * Copy constructor
     */
    inline  SendKeyEventStart (const SendKeyEventStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendKeyEventStart (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_KeyMode KeyMode_, ::midw_smartphoneint_fi_types::T_e32_KeyCode KeyCode_);

    /**
     * Destructor
     */
    inline virtual  ~SendKeyEventStart();

    /**
     * Assignment operator
     */
    inline SendKeyEventStart& operator = (const SendKeyEventStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendKeyEventStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendKeyEventStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendKeyEventStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendKeyEventStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "KeyMode"

    static const int kKeyMode = 1;

    /**
     * Clears the field "KeyMode".
     *
     * The field will be set to its default value. The hasKeyMode()
     * method will return false.
     */
    inline void clearKeyMode();

    /**
     * Checks whether the field "KeyMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyMode()). Otherwise it will return false.
     */
    inline bool hasKeyMode () const;

    /**
     * Returns the value of the member "KeyMode".
     *
     * Key Mode Value.
     *
     * @return The value of the field "KeyMode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_KeyMode getKeyMode () const;

    /**
     * Sets the value of the member "KeyMode".
     *
     * Key Mode Value.
     *
     * @param KeyMode The value which will be set
     */
    inline void setKeyMode (::midw_smartphoneint_fi_types::T_e8_KeyMode KeyMode_);

    // API of field "KeyCode"

    static const int kKeyCode = 2;

    /**
     * Clears the field "KeyCode".
     *
     * The field will be set to its default value. The hasKeyCode()
     * method will return false.
     */
    inline void clearKeyCode();

    /**
     * Checks whether the field "KeyCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyCode()). Otherwise it will return false.
     */
    inline bool hasKeyCode () const;

    /**
     * Returns the value of the member "KeyCode".
     *
     * Key Code Value.
     *
     * @return The value of the field "KeyCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e32_KeyCode getKeyCode () const;

    /**
     * Sets the value of the member "KeyCode".
     *
     * Key Code Value.
     *
     * @param KeyCode The value which will be set
     */
    inline void setKeyCode (::midw_smartphoneint_fi_types::T_e32_KeyCode KeyCode_);

    static const SendKeyEventStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_KeyMode ();

    inline void clear_has_KeyMode ();

    inline void set_has_KeyCode ();

    inline void clear_has_KeyCode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_KeyMode _KeyMode;

    ::midw_smartphoneint_fi_types::T_e32_KeyCode _KeyCode;

};

/**
 * The result message of the method "SendKeyEvent"
 * Interface to set the Touch or Pointer events.
 */
class SendKeyEventResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendKeyEventResult ();

    /**
     * Copy constructor
     */
    inline  SendKeyEventResult (const SendKeyEventResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendKeyEventResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SendKeyEventResult();

    /**
     * Assignment operator
     */
    inline SendKeyEventResult& operator = (const SendKeyEventResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendKeyEventResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendKeyEventResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendKeyEventResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendKeyEventResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SendKeyEventResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetClientCapabilities"
 * Scope : only for ML
 * Interface to set client capabilities.
 */
class SetClientCapabilitiesStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetClientCapabilitiesStart ();

    /**
     * Copy constructor
     */
    inline  SetClientCapabilitiesStart (const SetClientCapabilitiesStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetClientCapabilitiesStart (const ::midw_smartphoneint_fi_types::T_ClientCapabilities& ClientCapabilities_);

    /**
     * Destructor
     */
    inline virtual  ~SetClientCapabilitiesStart();

    /**
     * Assignment operator
     */
    inline SetClientCapabilitiesStart& operator = (const SetClientCapabilitiesStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetClientCapabilitiesStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetClientCapabilitiesStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetClientCapabilitiesStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetClientCapabilitiesStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ClientCapabilities"

    static const int kClientCapabilities = 0;

    /**
     * Clears the field "ClientCapabilities".
     *
     * The field will be set to its default value. The hasClientCapabilities()
     * method will return false.
     */
    inline void clearClientCapabilities();

    /**
     * Checks whether the field "ClientCapabilities" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientCapabilities()). Otherwise it will return false.
     */
    inline bool hasClientCapabilities () const;

    /**
     * Returns the value of the member "ClientCapabilities".
     *
     * Capabilities of the client.
     *
     * @return The value of the field "ClientCapabilities"
     */
    inline const ::midw_smartphoneint_fi_types::T_ClientCapabilities& getClientCapabilities () const;

    /**
     * Retrieves the value of the field "ClientCapabilities" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ClientCapabilities".
     */
    inline ::midw_smartphoneint_fi_types::T_ClientCapabilities& getClientCapabilitiesMutable ();

    /**
     * Sets the value of the member "ClientCapabilities".
     *
     * Capabilities of the client.
     *
     * @param ClientCapabilities The value which will be set
     */
    inline void setClientCapabilities (const ::midw_smartphoneint_fi_types::T_ClientCapabilities& ClientCapabilities_);

    static const SetClientCapabilitiesStart &getDefaultInstance();

private:

    inline void set_has_ClientCapabilities ();

    inline void clear_has_ClientCapabilities ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_ClientCapabilities _ClientCapabilities;

};

/**
 * The result message of the method "SetClientCapabilities"
 * Scope : only for ML
 * Interface to set client capabilities.
 */
class SetClientCapabilitiesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetClientCapabilitiesResult ();

    /**
     * Copy constructor
     */
    inline  SetClientCapabilitiesResult (const SetClientCapabilitiesResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetClientCapabilitiesResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetClientCapabilitiesResult();

    /**
     * Assignment operator
     */
    inline SetClientCapabilitiesResult& operator = (const SetClientCapabilitiesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetClientCapabilitiesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetClientCapabilitiesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetClientCapabilitiesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetClientCapabilitiesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetClientCapabilitiesResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "AccessoryDisplayContext"
 * This interface is used by the client to inform the DiPO device about its current display context.
 * --This method is deprecated, instead use SetAccessoryDisplayContext
 */
class AccessoryDisplayContextStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AccessoryDisplayContextStart ();

    /**
     * Copy constructor
     */
    inline  AccessoryDisplayContextStart (const AccessoryDisplayContextStart &rhs);

    /**
     * All fields constructor
     */
    inline  AccessoryDisplayContextStart (uint32 DeviceHandle_, bool DisplayFlag_, ::midw_smartphoneint_fi_types::T_e8_DisplayContext DisplayContext_);

    /**
     * Destructor
     */
    inline virtual  ~AccessoryDisplayContextStart();

    /**
     * Assignment operator
     */
    inline AccessoryDisplayContextStart& operator = (const AccessoryDisplayContextStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccessoryDisplayContextStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccessoryDisplayContextStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccessoryDisplayContextStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccessoryDisplayContextStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DisplayFlag"

    static const int kDisplayFlag = 1;

    /**
     * Clears the field "DisplayFlag".
     *
     * The field will be set to its default value. The hasDisplayFlag()
     * method will return false.
     */
    inline void clearDisplayFlag();

    /**
     * Checks whether the field "DisplayFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayFlag()). Otherwise it will return false.
     */
    inline bool hasDisplayFlag () const;

    /**
     * Returns the value of the member "DisplayFlag".
     *
     * TRUE - Start Native display Projection( Projection screen to Native screen), FALSE - Stop Native Display Projection(Native screen to Projection screen ) .
     *
     * @return The value of the field "DisplayFlag"
     */
    inline bool getDisplayFlag () const;

    /**
     * Sets the value of the member "DisplayFlag".
     *
     * TRUE - Start Native display Projection( Projection screen to Native screen), FALSE - Stop Native Display Projection(Native screen to Projection screen ) .
     *
     * @param DisplayFlag The value which will be set
     */
    inline void setDisplayFlag (bool DisplayFlag_);

    // API of field "DisplayContext"

    static const int kDisplayContext = 2;

    /**
     * Clears the field "DisplayContext".
     *
     * The field will be set to its default value. The hasDisplayContext()
     * method will return false.
     */
    inline void clearDisplayContext();

    /**
     * Checks whether the field "DisplayContext" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayContext()). Otherwise it will return false.
     */
    inline bool hasDisplayContext () const;

    /**
     * Returns the value of the member "DisplayContext".
     *
     * Display context of the client (e.g. HMI).
     *
     * @return The value of the field "DisplayContext"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DisplayContext getDisplayContext () const;

    /**
     * Sets the value of the member "DisplayContext".
     *
     * Display context of the client (e.g. HMI).
     *
     * @param DisplayContext The value which will be set
     */
    inline void setDisplayContext (::midw_smartphoneint_fi_types::T_e8_DisplayContext DisplayContext_);

    static const AccessoryDisplayContextStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DisplayFlag ();

    inline void clear_has_DisplayFlag ();

    inline void set_has_DisplayContext ();

    inline void clear_has_DisplayContext ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    bool _DisplayFlag;

    ::midw_smartphoneint_fi_types::T_e8_DisplayContext _DisplayContext;

};

/**
 * The result message of the method "AccessoryDisplayContext"
 * This interface is used by the client to inform the DiPO device about its current display context.
 * --This method is deprecated, instead use SetAccessoryDisplayContext
 */
class AccessoryDisplayContextResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AccessoryDisplayContextResult ();

    /**
     * Copy constructor
     */
    inline  AccessoryDisplayContextResult (const AccessoryDisplayContextResult &rhs);

    /**
     * All fields constructor
     */
    inline  AccessoryDisplayContextResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~AccessoryDisplayContextResult();

    /**
     * Assignment operator
     */
    inline AccessoryDisplayContextResult& operator = (const AccessoryDisplayContextResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccessoryDisplayContextResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccessoryDisplayContextResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccessoryDisplayContextResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccessoryDisplayContextResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const AccessoryDisplayContextResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "GetDeviceUsagePreference"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * Interface to get the preference for the usage of the connected devices device during startup.
 */
class GetDeviceUsagePreferenceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDeviceUsagePreferenceStart ();

    /**
     * Copy constructor
     */
    inline  GetDeviceUsagePreferenceStart (const GetDeviceUsagePreferenceStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetDeviceUsagePreferenceStart (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    /**
     * Destructor
     */
    inline virtual  ~GetDeviceUsagePreferenceStart();

    /**
     * Assignment operator
     */
    inline GetDeviceUsagePreferenceStart& operator = (const GetDeviceUsagePreferenceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDeviceUsagePreferenceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDeviceUsagePreferenceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDeviceUsagePreferenceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDeviceUsagePreferenceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function gets the overall preference usage for Mirror Link/DiPO.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function gets the overall preference usage for Mirror Link/DiPO.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 1;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Provides Device Type Information.
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Provides Device Type Information.
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    static const GetDeviceUsagePreferenceStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

};

/**
 * The result message of the method "GetDeviceUsagePreference"
 * Scope: ML, Carplay, Android Auto, Myspin and Carlife
 * Interface to get the preference for the usage of the connected devices device during startup.
 */
class GetDeviceUsagePreferenceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDeviceUsagePreferenceResult ();

    /**
     * Copy constructor
     */
    inline  GetDeviceUsagePreferenceResult (const GetDeviceUsagePreferenceResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetDeviceUsagePreferenceResult (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_, ::midw_smartphoneint_fi_types::T_e8_EnabledInfo EnabledInfo_);

    /**
     * Destructor
     */
    inline virtual  ~GetDeviceUsagePreferenceResult();

    /**
     * Assignment operator
     */
    inline GetDeviceUsagePreferenceResult& operator = (const GetDeviceUsagePreferenceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDeviceUsagePreferenceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDeviceUsagePreferenceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDeviceUsagePreferenceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDeviceUsagePreferenceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function gets the overall preference usage for Mirror Link/DiPO.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function gets the overall preference usage for Mirror Link/DiPO.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 1;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Provides Device Type Information.
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Provides Device Type Information.
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    // API of field "EnabledInfo"

    static const int kEnabledInfo = 2;

    /**
     * Clears the field "EnabledInfo".
     *
     * The field will be set to its default value. The hasEnabledInfo()
     * method will return false.
     */
    inline void clearEnabledInfo();

    /**
     * Checks whether the field "EnabledInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnabledInfo()). Otherwise it will return false.
     */
    inline bool hasEnabledInfo () const;

    /**
     * Returns the value of the member "EnabledInfo".
     *
     * Provides Enable Information.
     *
     * @return The value of the field "EnabledInfo"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_EnabledInfo getEnabledInfo () const;

    /**
     * Sets the value of the member "EnabledInfo".
     *
     * Provides Enable Information.
     *
     * @param EnabledInfo The value which will be set
     */
    inline void setEnabledInfo (::midw_smartphoneint_fi_types::T_e8_EnabledInfo EnabledInfo_);

    static const GetDeviceUsagePreferenceResult &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    inline void set_has_EnabledInfo ();

    inline void clear_has_EnabledInfo ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

    ::midw_smartphoneint_fi_types::T_e8_EnabledInfo _EnabledInfo;

};

/**
 * The start message of the method "SetVehicleBTAddress"
 * Interface to set the vehicle Bluetooth address.
 */
class SetVehicleBTAddressStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVehicleBTAddressStart ();

    /**
     * Copy constructor
     */
    inline  SetVehicleBTAddressStart (const SetVehicleBTAddressStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetVehicleBTAddressStart (const ::std::string& BTAddress_);

    /**
     * Destructor
     */
    inline virtual  ~SetVehicleBTAddressStart();

    /**
     * Assignment operator
     */
    inline SetVehicleBTAddressStart& operator = (const SetVehicleBTAddressStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVehicleBTAddressStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVehicleBTAddressStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVehicleBTAddressStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVehicleBTAddressStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BTAddress"

    static const int kBTAddress = 0;

    /**
     * Clears the field "BTAddress".
     *
     * The field will be set to its default value. The hasBTAddress()
     * method will return false.
     */
    inline void clearBTAddress();

    /**
     * Checks whether the field "BTAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTAddress()). Otherwise it will return false.
     */
    inline bool hasBTAddress () const;

    /**
     * Returns the value of the member "BTAddress".
     *
     * Identifies Vehicle BT Address. It is represented by 12 hexadecimal characters.
     *
     * @return The value of the field "BTAddress"
     */
    inline const ::std::string& getBTAddress () const;

    /**
     * Retrieves the value of the field "BTAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BTAddress".
     */
    inline ::std::string& getBTAddressMutable ();

    /**
     * Sets the value of the member "BTAddress".
     *
     * Identifies Vehicle BT Address. It is represented by 12 hexadecimal characters.
     *
     * @param BTAddress The value which will be set
     */
    inline void setBTAddress (const ::std::string& BTAddress_);

    /**
     * Sets the value of the member "BTAddress".
     *
     * Identifies Vehicle BT Address. It is represented by 12 hexadecimal characters.
     *
     * @param BTAddress The value which will be set
     */
    inline void setBTAddress (const char* BTAddress_);

    /**
     * Sets the value of the member "BTAddress".
     *
     * Identifies Vehicle BT Address. It is represented by 12 hexadecimal characters.
     *
     * @param BTAddress The value which will be set
     */
    inline void setBTAddress (const char* value, size_t size);

    static const SetVehicleBTAddressStart &getDefaultInstance();

private:

    inline void set_has_BTAddress ();

    inline void clear_has_BTAddress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _BTAddress;

};

/**
 * The result message of the method "SetVehicleBTAddress"
 * Interface to set the vehicle Bluetooth address.
 */
class SetVehicleBTAddressResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVehicleBTAddressResult ();

    /**
     * Copy constructor
     */
    inline  SetVehicleBTAddressResult (const SetVehicleBTAddressResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetVehicleBTAddressResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetVehicleBTAddressResult();

    /**
     * Assignment operator
     */
    inline SetVehicleBTAddressResult& operator = (const SetVehicleBTAddressResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVehicleBTAddressResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVehicleBTAddressResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVehicleBTAddressResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVehicleBTAddressResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetVehicleBTAddressResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "InvokeBluetoothDeviceAction"
 * Interface to inform SPI about user's selected action for a device switch operation between a BT and a Projection device.
 */
class InvokeBluetoothDeviceActionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InvokeBluetoothDeviceActionStart ();

    /**
     * Copy constructor
     */
    inline  InvokeBluetoothDeviceActionStart (const InvokeBluetoothDeviceActionStart &rhs);

    /**
     * All fields constructor
     */
    inline  InvokeBluetoothDeviceActionStart (uint32 BluetoothDeviceHandle_, uint32 ProjectionDeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_BTChangeInfo BTChangeInfo_);

    /**
     * Destructor
     */
    inline virtual  ~InvokeBluetoothDeviceActionStart();

    /**
     * Assignment operator
     */
    inline InvokeBluetoothDeviceActionStart& operator = (const InvokeBluetoothDeviceActionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InvokeBluetoothDeviceActionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InvokeBluetoothDeviceActionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InvokeBluetoothDeviceActionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InvokeBluetoothDeviceActionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BluetoothDeviceHandle"

    static const int kBluetoothDeviceHandle = 0;

    /**
     * Clears the field "BluetoothDeviceHandle".
     *
     * The field will be set to its default value. The hasBluetoothDeviceHandle()
     * method will return false.
     */
    inline void clearBluetoothDeviceHandle();

    /**
     * Checks whether the field "BluetoothDeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBluetoothDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasBluetoothDeviceHandle () const;

    /**
     * Returns the value of the member "BluetoothDeviceHandle".
     *
     * Identifies a BT device from BT Settings device list.
     *
     * @return The value of the field "BluetoothDeviceHandle"
     */
    inline uint32 getBluetoothDeviceHandle () const;

    /**
     * Sets the value of the member "BluetoothDeviceHandle".
     *
     * Identifies a BT device from BT Settings device list.
     *
     * @param BluetoothDeviceHandle The value which will be set
     */
    inline void setBluetoothDeviceHandle (uint32 BluetoothDeviceHandle_);

    // API of field "ProjectionDeviceHandle"

    static const int kProjectionDeviceHandle = 1;

    /**
     * Clears the field "ProjectionDeviceHandle".
     *
     * The field will be set to its default value. The hasProjectionDeviceHandle()
     * method will return false.
     */
    inline void clearProjectionDeviceHandle();

    /**
     * Checks whether the field "ProjectionDeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProjectionDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasProjectionDeviceHandle () const;

    /**
     * Returns the value of the member "ProjectionDeviceHandle".
     *
     * Identifies a Projection device from SPI device list.
     *
     * @return The value of the field "ProjectionDeviceHandle"
     */
    inline uint32 getProjectionDeviceHandle () const;

    /**
     * Sets the value of the member "ProjectionDeviceHandle".
     *
     * Identifies a Projection device from SPI device list.
     *
     * @param ProjectionDeviceHandle The value which will be set
     */
    inline void setProjectionDeviceHandle (uint32 ProjectionDeviceHandle_);

    // API of field "BTChangeInfo"

    static const int kBTChangeInfo = 2;

    /**
     * Clears the field "BTChangeInfo".
     *
     * The field will be set to its default value. The hasBTChangeInfo()
     * method will return false.
     */
    inline void clearBTChangeInfo();

    /**
     * Checks whether the field "BTChangeInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTChangeInfo()). Otherwise it will return false.
     */
    inline bool hasBTChangeInfo () const;

    /**
     * Returns the value of the member "BTChangeInfo".
     *
     * Identifies the user selected BT device change.
     *
     * @return The value of the field "BTChangeInfo"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_BTChangeInfo getBTChangeInfo () const;

    /**
     * Sets the value of the member "BTChangeInfo".
     *
     * Identifies the user selected BT device change.
     *
     * @param BTChangeInfo The value which will be set
     */
    inline void setBTChangeInfo (::midw_smartphoneint_fi_types::T_e8_BTChangeInfo BTChangeInfo_);

    static const InvokeBluetoothDeviceActionStart &getDefaultInstance();

private:

    inline void set_has_BluetoothDeviceHandle ();

    inline void clear_has_BluetoothDeviceHandle ();

    inline void set_has_ProjectionDeviceHandle ();

    inline void clear_has_ProjectionDeviceHandle ();

    inline void set_has_BTChangeInfo ();

    inline void clear_has_BTChangeInfo ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _BluetoothDeviceHandle;

    uint32 _ProjectionDeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_BTChangeInfo _BTChangeInfo;

};

/**
 * The result message of the method "InvokeBluetoothDeviceAction"
 * Interface to inform SPI about user's selected action for a device switch operation between a BT and a Projection device.
 */
class InvokeBluetoothDeviceActionResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InvokeBluetoothDeviceActionResult ();

    /**
     * Copy constructor
     */
    inline  InvokeBluetoothDeviceActionResult (const InvokeBluetoothDeviceActionResult &rhs);

    /**
     * All fields constructor
     */
    inline  InvokeBluetoothDeviceActionResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~InvokeBluetoothDeviceActionResult();

    /**
     * Assignment operator
     */
    inline InvokeBluetoothDeviceActionResult& operator = (const InvokeBluetoothDeviceActionResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InvokeBluetoothDeviceActionResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InvokeBluetoothDeviceActionResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InvokeBluetoothDeviceActionResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InvokeBluetoothDeviceActionResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const InvokeBluetoothDeviceActionResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "AccessoryAudioContext"
 * This interface is used by the client to inform the DiPO device about its current Audio context.
 * This interface is deprecated. Use SetAccessoryAudioContext to provide Audio context information.
 */
class AccessoryAudioContextStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AccessoryAudioContextStart ();

    /**
     * Copy constructor
     */
    inline  AccessoryAudioContextStart (const AccessoryAudioContextStart &rhs);

    /**
     * All fields constructor
     */
    inline  AccessoryAudioContextStart (uint32 DeviceHandle_, bool AudioFlag_, ::midw_smartphoneint_fi_types::T_e8_AudioContext AudioContext_);

    /**
     * Destructor
     */
    inline virtual  ~AccessoryAudioContextStart();

    /**
     * Assignment operator
     */
    inline AccessoryAudioContextStart& operator = (const AccessoryAudioContextStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccessoryAudioContextStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccessoryAudioContextStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccessoryAudioContextStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccessoryAudioContextStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "AudioFlag"

    static const int kAudioFlag = 1;

    /**
     * Clears the field "AudioFlag".
     *
     * The field will be set to its default value. The hasAudioFlag()
     * method will return false.
     */
    inline void clearAudioFlag();

    /**
     * Checks whether the field "AudioFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioFlag()). Otherwise it will return false.
     */
    inline bool hasAudioFlag () const;

    /**
     * Returns the value of the member "AudioFlag".
     *
     * TRUE - Accessory wants Audio resource, FALSE - Phone can take Audio resource.
     *
     * @return The value of the field "AudioFlag"
     */
    inline bool getAudioFlag () const;

    /**
     * Sets the value of the member "AudioFlag".
     *
     * TRUE - Accessory wants Audio resource, FALSE - Phone can take Audio resource.
     *
     * @param AudioFlag The value which will be set
     */
    inline void setAudioFlag (bool AudioFlag_);

    // API of field "AudioContext"

    static const int kAudioContext = 2;

    /**
     * Clears the field "AudioContext".
     *
     * The field will be set to its default value. The hasAudioContext()
     * method will return false.
     */
    inline void clearAudioContext();

    /**
     * Checks whether the field "AudioContext" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioContext()). Otherwise it will return false.
     */
    inline bool hasAudioContext () const;

    /**
     * Returns the value of the member "AudioContext".
     *
     * Audio context of the client (e.g. HMI).
     *
     * @return The value of the field "AudioContext"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_AudioContext getAudioContext () const;

    /**
     * Sets the value of the member "AudioContext".
     *
     * Audio context of the client (e.g. HMI).
     *
     * @param AudioContext The value which will be set
     */
    inline void setAudioContext (::midw_smartphoneint_fi_types::T_e8_AudioContext AudioContext_);

    static const AccessoryAudioContextStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_AudioFlag ();

    inline void clear_has_AudioFlag ();

    inline void set_has_AudioContext ();

    inline void clear_has_AudioContext ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _DeviceHandle;

    bool _AudioFlag;

    ::midw_smartphoneint_fi_types::T_e8_AudioContext _AudioContext;

};

/**
 * The result message of the method "AccessoryAudioContext"
 * This interface is used by the client to inform the DiPO device about its current Audio context.
 * This interface is deprecated. Use SetAccessoryAudioContext to provide Audio context information.
 */
class AccessoryAudioContextResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AccessoryAudioContextResult ();

    /**
     * Copy constructor
     */
    inline  AccessoryAudioContextResult (const AccessoryAudioContextResult &rhs);

    /**
     * All fields constructor
     */
    inline  AccessoryAudioContextResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~AccessoryAudioContextResult();

    /**
     * Assignment operator
     */
    inline AccessoryAudioContextResult& operator = (const AccessoryAudioContextResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccessoryAudioContextResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccessoryAudioContextResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccessoryAudioContextResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccessoryAudioContextResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const AccessoryAudioContextResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "AccessoryAppState"
 * Scope: Dipo- for speech, Phone and Navigation states, AAP - only Navigation state
 * This interface is used by the client to inform to the connected device about the HU application states
 */
class AccessoryAppStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AccessoryAppStateStart ();

    /**
     * Copy constructor
     */
    inline  AccessoryAppStateStart (const AccessoryAppStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  AccessoryAppStateStart (::midw_smartphoneint_fi_types::T_e8_SpeechAppState AppStateSpeech_, ::midw_smartphoneint_fi_types::T_e8_PhoneAppState AppStatePhone_, ::midw_smartphoneint_fi_types::T_e8_NavigationAppState AppStateNavigation_);

    /**
     * Destructor
     */
    inline virtual  ~AccessoryAppStateStart();

    /**
     * Assignment operator
     */
    inline AccessoryAppStateStart& operator = (const AccessoryAppStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccessoryAppStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccessoryAppStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccessoryAppStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccessoryAppStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AppStateSpeech"

    static const int kAppStateSpeech = 0;

    /**
     * Clears the field "AppStateSpeech".
     *
     * The field will be set to its default value. The hasAppStateSpeech()
     * method will return false.
     */
    inline void clearAppStateSpeech();

    /**
     * Checks whether the field "AppStateSpeech" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppStateSpeech()). Otherwise it will return false.
     */
    inline bool hasAppStateSpeech () const;

    /**
     * Returns the value of the member "AppStateSpeech".
     *
     * specifies the different speech operation.
     * SPI_APP_STATE_SPEECH_NA = No speech session active.Hence no app state for speech
     * SPI_APP_STATE_SPEECH_NONE = The state is send to inform that an already active speech state is terminated.
     * SPI_APP_STATE_SPEECH_SPEAKING = The app device is speaking to the user.
     * SPI_APP_STATE_SPEECH_RECOGNISING = The device is recording audio to recognise speech from the user.
     *
     * @return The value of the field "AppStateSpeech"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_SpeechAppState getAppStateSpeech () const;

    /**
     * Sets the value of the member "AppStateSpeech".
     *
     * specifies the different speech operation.
     * SPI_APP_STATE_SPEECH_NA = No speech session active.Hence no app state for speech
     * SPI_APP_STATE_SPEECH_NONE = The state is send to inform that an already active speech state is terminated.
     * SPI_APP_STATE_SPEECH_SPEAKING = The app device is speaking to the user.
     * SPI_APP_STATE_SPEECH_RECOGNISING = The device is recording audio to recognise speech from the user.
     *
     * @param AppStateSpeech The value which will be set
     */
    inline void setAppStateSpeech (::midw_smartphoneint_fi_types::T_e8_SpeechAppState AppStateSpeech_);

    // API of field "AppStatePhone"

    static const int kAppStatePhone = 1;

    /**
     * Clears the field "AppStatePhone".
     *
     * The field will be set to its default value. The hasAppStatePhone()
     * method will return false.
     */
    inline void clearAppStatePhone();

    /**
     * Checks whether the field "AppStatePhone" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppStatePhone()). Otherwise it will return false.
     */
    inline bool hasAppStatePhone () const;

    /**
     * Returns the value of the member "AppStatePhone".
     *
     * specifies the different Phone State.
     * SPI_APP_STATE_PHONE_NA = No phone call is active.Hence no app state for phone
     * SPI_APP_STATE_PHONE_ACTIVE = Phone call is active.
     * SPI_APP_STATE_PHONE_NOTACTIVE = The state is send to inform that an already active phone call has ended. ie,an app state change from active to not active.
     *
     * @return The value of the field "AppStatePhone"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_PhoneAppState getAppStatePhone () const;

    /**
     * Sets the value of the member "AppStatePhone".
     *
     * specifies the different Phone State.
     * SPI_APP_STATE_PHONE_NA = No phone call is active.Hence no app state for phone
     * SPI_APP_STATE_PHONE_ACTIVE = Phone call is active.
     * SPI_APP_STATE_PHONE_NOTACTIVE = The state is send to inform that an already active phone call has ended. ie,an app state change from active to not active.
     *
     * @param AppStatePhone The value which will be set
     */
    inline void setAppStatePhone (::midw_smartphoneint_fi_types::T_e8_PhoneAppState AppStatePhone_);

    // API of field "AppStateNavigation"

    static const int kAppStateNavigation = 2;

    /**
     * Clears the field "AppStateNavigation".
     *
     * The field will be set to its default value. The hasAppStateNavigation()
     * method will return false.
     */
    inline void clearAppStateNavigation();

    /**
     * Checks whether the field "AppStateNavigation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppStateNavigation()). Otherwise it will return false.
     */
    inline bool hasAppStateNavigation () const;

    /**
     * Returns the value of the member "AppStateNavigation".
     *
     * specifies the different Navigation App State.
     * SPI_APP_STATE_NAV_NA = No navigation APP is active.Hence no app state for navigation
     * SPI_APP_STATE_NAV_ACTIVE = Navigation APP is active.
     * SPI_APP_STATE_NAV_NOTACTIVE = The state is send to inform that an already active TBT navigation has ended. ie,an app state change from active to not active.
     *
     * @return The value of the field "AppStateNavigation"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_NavigationAppState getAppStateNavigation () const;

    /**
     * Sets the value of the member "AppStateNavigation".
     *
     * specifies the different Navigation App State.
     * SPI_APP_STATE_NAV_NA = No navigation APP is active.Hence no app state for navigation
     * SPI_APP_STATE_NAV_ACTIVE = Navigation APP is active.
     * SPI_APP_STATE_NAV_NOTACTIVE = The state is send to inform that an already active TBT navigation has ended. ie,an app state change from active to not active.
     *
     * @param AppStateNavigation The value which will be set
     */
    inline void setAppStateNavigation (::midw_smartphoneint_fi_types::T_e8_NavigationAppState AppStateNavigation_);

    static const AccessoryAppStateStart &getDefaultInstance();

private:

    inline void set_has_AppStateSpeech ();

    inline void clear_has_AppStateSpeech ();

    inline void set_has_AppStatePhone ();

    inline void clear_has_AppStatePhone ();

    inline void set_has_AppStateNavigation ();

    inline void clear_has_AppStateNavigation ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_SpeechAppState _AppStateSpeech;

    ::midw_smartphoneint_fi_types::T_e8_PhoneAppState _AppStatePhone;

    ::midw_smartphoneint_fi_types::T_e8_NavigationAppState _AppStateNavigation;

};

/**
 * The result message of the method "AccessoryAppState"
 * Scope: Dipo- for speech, Phone and Navigation states, AAP - only Navigation state
 * This interface is used by the client to inform to the connected device about the HU application states
 */
class AccessoryAppStateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AccessoryAppStateResult ();

    /**
     * Copy constructor
     */
    inline  AccessoryAppStateResult (const AccessoryAppStateResult &rhs);

    /**
     * All fields constructor
     */
    inline  AccessoryAppStateResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~AccessoryAppStateResult();

    /**
     * Assignment operator
     */
    inline AccessoryAppStateResult& operator = (const AccessoryAppStateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccessoryAppStateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccessoryAppStateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccessoryAppStateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccessoryAppStateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const AccessoryAppStateResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetRegion"
 * Interface to inform SPI about which region guidelines should be followed to check the application
 * certification.
 */
class SetRegionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRegionStart ();

    /**
     * Copy constructor
     */
    inline  SetRegionStart (const SetRegionStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetRegionStart (::midw_smartphoneint_fi_types::T_e8_Region Region_);

    /**
     * Destructor
     */
    inline virtual  ~SetRegionStart();

    /**
     * Assignment operator
     */
    inline SetRegionStart& operator = (const SetRegionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRegionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRegionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRegionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRegionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Region"

    static const int kRegion = 0;

    /**
     * Clears the field "Region".
     *
     * The field will be set to its default value. The hasRegion()
     * method will return false.
     */
    inline void clearRegion();

    /**
     * Checks whether the field "Region" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegion()). Otherwise it will return false.
     */
    inline bool hasRegion () const;

    /**
     * Returns the value of the member "Region".
     *
     * Identifies the vehicle region.
     *
     * @return The value of the field "Region"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_Region getRegion () const;

    /**
     * Sets the value of the member "Region".
     *
     * Identifies the vehicle region.
     *
     * @param Region The value which will be set
     */
    inline void setRegion (::midw_smartphoneint_fi_types::T_e8_Region Region_);

    static const SetRegionStart &getDefaultInstance();

private:

    inline void set_has_Region ();

    inline void clear_has_Region ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_Region _Region;

};

/**
 * The result message of the method "SetRegion"
 * Interface to inform SPI about which region guidelines should be followed to check the application
 * certification.
 */
class SetRegionResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRegionResult ();

    /**
     * Copy constructor
     */
    inline  SetRegionResult (const SetRegionResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetRegionResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetRegionResult();

    /**
     * Assignment operator
     */
    inline SetRegionResult& operator = (const SetRegionResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRegionResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRegionResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRegionResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRegionResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetRegionResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "DiPORoleSwitchRequired"
 * Scope : Carplay, Carlife, Myspin
 * Interface to check whether an automatic role switch is required for the currently connected apple device.
 */
class DiPORoleSwitchRequiredStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORoleSwitchRequiredStart ();

    /**
     * Copy constructor
     */
    inline  DiPORoleSwitchRequiredStart (const DiPORoleSwitchRequiredStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORoleSwitchRequiredStart (uint8 u8DeviceTag_, const ::std::string& USBSerialNumber_, bool DeviceCarplayCapability_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORoleSwitchRequiredStart();

    /**
     * Assignment operator
     */
    inline DiPORoleSwitchRequiredStart& operator = (const DiPORoleSwitchRequiredStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORoleSwitchRequiredStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORoleSwitchRequiredStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORoleSwitchRequiredStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORoleSwitchRequiredStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "USBSerialNumber"

    static const int kUSBSerialNumber = 1;

    /**
     * Clears the field "USBSerialNumber".
     *
     * The field will be set to its default value. The hasUSBSerialNumber()
     * method will return false.
     */
    inline void clearUSBSerialNumber();

    /**
     * Checks whether the field "USBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasUSBSerialNumber () const;

    /**
     * Returns the value of the member "USBSerialNumber".
     *
     * USB Serial Number of the device.
     *
     * @return The value of the field "USBSerialNumber"
     */
    inline const ::std::string& getUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "USBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "USBSerialNumber".
     */
    inline ::std::string& getUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "USBSerialNumber".
     *
     * USB Serial Number of the device.
     *
     * @param USBSerialNumber The value which will be set
     */
    inline void setUSBSerialNumber (const ::std::string& USBSerialNumber_);

    /**
     * Sets the value of the member "USBSerialNumber".
     *
     * USB Serial Number of the device.
     *
     * @param USBSerialNumber The value which will be set
     */
    inline void setUSBSerialNumber (const char* USBSerialNumber_);

    /**
     * Sets the value of the member "USBSerialNumber".
     *
     * USB Serial Number of the device.
     *
     * @param USBSerialNumber The value which will be set
     */
    inline void setUSBSerialNumber (const char* value, size_t size);

    // API of field "DeviceCarplayCapability"

    static const int kDeviceCarplayCapability = 2;

    /**
     * Clears the field "DeviceCarplayCapability".
     *
     * The field will be set to its default value. The hasDeviceCarplayCapability()
     * method will return false.
     */
    inline void clearDeviceCarplayCapability();

    /**
     * Checks whether the field "DeviceCarplayCapability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCarplayCapability()). Otherwise it will return false.
     */
    inline bool hasDeviceCarplayCapability () const;

    /**
     * Returns the value of the member "DeviceCarplayCapability".
     *
     * Whether currently connected apple device is capable of carPlay.
     *
     * @return The value of the field "DeviceCarplayCapability"
     */
    inline bool getDeviceCarplayCapability () const;

    /**
     * Sets the value of the member "DeviceCarplayCapability".
     *
     * Whether currently connected apple device is capable of carPlay.
     *
     * @param DeviceCarplayCapability The value which will be set
     */
    inline void setDeviceCarplayCapability (bool DeviceCarplayCapability_);

    static const DiPORoleSwitchRequiredStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_USBSerialNumber ();

    inline void clear_has_USBSerialNumber ();

    inline void set_has_DeviceCarplayCapability ();

    inline void clear_has_DeviceCarplayCapability ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceTag;

    ::std::string _USBSerialNumber;

    bool _DeviceCarplayCapability;

};

/**
 * The result message of the method "DiPORoleSwitchRequired"
 * Scope : Carplay, Carlife, Myspin
 * Interface to check whether an automatic role switch is required for the currently connected apple device.
 */
class DiPORoleSwitchRequiredResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORoleSwitchRequiredResult ();

    /**
     * Copy constructor
     */
    inline  DiPORoleSwitchRequiredResult (const DiPORoleSwitchRequiredResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORoleSwitchRequiredResult (uint8 u8DeviceTag_, ::midw_smartphoneint_fi_types::T_e8_DiPOSwitchReqResponse e8DiPOSwitchReqResponse_, const ::std::string& USBSerialNumber_, const ::midw_smartphoneint_fi_types::T_EAPAppInfo& rEAPAppInfo_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORoleSwitchRequiredResult();

    /**
     * Assignment operator
     */
    inline DiPORoleSwitchRequiredResult& operator = (const DiPORoleSwitchRequiredResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORoleSwitchRequiredResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORoleSwitchRequiredResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORoleSwitchRequiredResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORoleSwitchRequiredResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "e8DiPOSwitchReqResponse"

    static const int kE8DiPOSwitchReqResponse = 1;

    /**
     * Clears the field "e8DiPOSwitchReqResponse".
     *
     * The field will be set to its default value. The hasE8DiPOSwitchReqResponse()
     * method will return false.
     */
    inline void clearE8DiPOSwitchReqResponse();

    /**
     * Checks whether the field "e8DiPOSwitchReqResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiPOSwitchReqResponse()). Otherwise it will return false.
     */
    inline bool hasE8DiPOSwitchReqResponse () const;

    /**
     * Returns the value of the member "e8DiPOSwitchReqResponse".
     *
     * Response whether role switch is required or not
     *
     * @return The value of the field "e8DiPOSwitchReqResponse"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DiPOSwitchReqResponse getE8DiPOSwitchReqResponse () const;

    /**
     * Sets the value of the member "e8DiPOSwitchReqResponse".
     *
     * Response whether role switch is required or not
     *
     * @param e8DiPOSwitchReqResponse The value which will be set
     */
    inline void setE8DiPOSwitchReqResponse (::midw_smartphoneint_fi_types::T_e8_DiPOSwitchReqResponse e8DiPOSwitchReqResponse_);

    // API of field "USBSerialNumber"

    static const int kUSBSerialNumber = 2;

    /**
     * Clears the field "USBSerialNumber".
     *
     * The field will be set to its default value. The hasUSBSerialNumber()
     * method will return false.
     */
    inline void clearUSBSerialNumber();

    /**
     * Checks whether the field "USBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasUSBSerialNumber () const;

    /**
     * Returns the value of the member "USBSerialNumber".
     *
     * USB Serial Number of the device.
     *
     * @return The value of the field "USBSerialNumber"
     */
    inline const ::std::string& getUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "USBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "USBSerialNumber".
     */
    inline ::std::string& getUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "USBSerialNumber".
     *
     * USB Serial Number of the device.
     *
     * @param USBSerialNumber The value which will be set
     */
    inline void setUSBSerialNumber (const ::std::string& USBSerialNumber_);

    /**
     * Sets the value of the member "USBSerialNumber".
     *
     * USB Serial Number of the device.
     *
     * @param USBSerialNumber The value which will be set
     */
    inline void setUSBSerialNumber (const char* USBSerialNumber_);

    /**
     * Sets the value of the member "USBSerialNumber".
     *
     * USB Serial Number of the device.
     *
     * @param USBSerialNumber The value which will be set
     */
    inline void setUSBSerialNumber (const char* value, size_t size);

    // API of field "rEAPAppInfo"

    static const int kREAPAppInfo = 3;

    /**
     * Clears the field "rEAPAppInfo".
     *
     * The field will be set to its default value. The hasREAPAppInfo()
     * method will return false.
     */
    inline void clearREAPAppInfo();

    /**
     * Checks whether the field "rEAPAppInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setREAPAppInfo()). Otherwise it will return false.
     */
    inline bool hasREAPAppInfo () const;

    /**
     * Returns the value of the member "rEAPAppInfo".
     *
     * This information to be populated for projection technology based on EAP( e.g Carlife, Myspin), i.e when e8DiPOSwitchReqResponse = e8DIPO_ROLE_SWITCH_REQUIRED_FOR_NATIVE_TRANSPORT.
     * Client to use this information to populate in EAP details in Identificationinformation.
     *
     * @return The value of the field "rEAPAppInfo"
     */
    inline const ::midw_smartphoneint_fi_types::T_EAPAppInfo& getREAPAppInfo () const;

    /**
     * Retrieves the value of the field "rEAPAppInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rEAPAppInfo".
     */
    inline ::midw_smartphoneint_fi_types::T_EAPAppInfo& getREAPAppInfoMutable ();

    /**
     * Sets the value of the member "rEAPAppInfo".
     *
     * This information to be populated for projection technology based on EAP( e.g Carlife, Myspin), i.e when e8DiPOSwitchReqResponse = e8DIPO_ROLE_SWITCH_REQUIRED_FOR_NATIVE_TRANSPORT.
     * Client to use this information to populate in EAP details in Identificationinformation.
     *
     * @param rEAPAppInfo The value which will be set
     */
    inline void setREAPAppInfo (const ::midw_smartphoneint_fi_types::T_EAPAppInfo& rEAPAppInfo_);

    static const DiPORoleSwitchRequiredResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_e8DiPOSwitchReqResponse ();

    inline void clear_has_e8DiPOSwitchReqResponse ();

    inline void set_has_USBSerialNumber ();

    inline void clear_has_USBSerialNumber ();

    inline void set_has_rEAPAppInfo ();

    inline void clear_has_rEAPAppInfo ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _u8DeviceTag;

    ::midw_smartphoneint_fi_types::T_e8_DiPOSwitchReqResponse _e8DiPOSwitchReqResponse;

    ::std::string _USBSerialNumber;

    ::midw_smartphoneint_fi_types::T_EAPAppInfo _rEAPAppInfo;

};

/**
 * The start message of the method "SetAccessoryDisplayContext"
 * Scope : ML, carPlay, AAP, MySPIN, Carlife.
 * This interface is used by the client to inform the projection device about Head Units current display context. And whenever Head Unit wants to request for the display resource.
 * The video resource management can either be done by HMI(SPI's client) or by SPI service. Normally it is SPI service responsibility.
 * If for what ever reason, HMI have to do video resource  management, then HMI should populate parameter "DisplayConstraintInfo"
 * Otherwise, if it is SPI service responsibility, HMI should populate parameter "DisplayContextInfo".
 * HMI should populate parameter "ContextResponsibility", based on which SPI service will know whether it is SPI or HMI responsibility.
 */
class SetAccessoryDisplayContextStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAccessoryDisplayContextStart ();

    /**
     * Copy constructor
     */
    inline  SetAccessoryDisplayContextStart (const SetAccessoryDisplayContextStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetAccessoryDisplayContextStart (uint32 DeviceHandle_, const ::midw_smartphoneint_fi_types::T_AccessoryDisplayContext& DisplayContextInfo_, const ::midw_smartphoneint_fi_types::T_DisplayConstraint& DisplayConstraintInfo_, ::midw_smartphoneint_fi_types::T_e8_DisplayInfo ContextResponsibility_);

    /**
     * Destructor
     */
    inline virtual  ~SetAccessoryDisplayContextStart();

    /**
     * Assignment operator
     */
    inline SetAccessoryDisplayContextStart& operator = (const SetAccessoryDisplayContextStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAccessoryDisplayContextStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAccessoryDisplayContextStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAccessoryDisplayContextStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAccessoryDisplayContextStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DisplayContextInfo"

    static const int kDisplayContextInfo = 1;

    /**
     * Clears the field "DisplayContextInfo".
     *
     * The field will be set to its default value. The hasDisplayContextInfo()
     * method will return false.
     */
    inline void clearDisplayContextInfo();

    /**
     * Checks whether the field "DisplayContextInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayContextInfo()). Otherwise it will return false.
     */
    inline bool hasDisplayContextInfo () const;

    /**
     * Returns the value of the member "DisplayContextInfo".
     *
     * Display context info. This information should be populated by HMI, if handling video resource management is SPI responsibility.
     *
     * @return The value of the field "DisplayContextInfo"
     */
    inline const ::midw_smartphoneint_fi_types::T_AccessoryDisplayContext& getDisplayContextInfo () const;

    /**
     * Retrieves the value of the field "DisplayContextInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayContextInfo".
     */
    inline ::midw_smartphoneint_fi_types::T_AccessoryDisplayContext& getDisplayContextInfoMutable ();

    /**
     * Sets the value of the member "DisplayContextInfo".
     *
     * Display context info. This information should be populated by HMI, if handling video resource management is SPI responsibility.
     *
     * @param DisplayContextInfo The value which will be set
     */
    inline void setDisplayContextInfo (const ::midw_smartphoneint_fi_types::T_AccessoryDisplayContext& DisplayContextInfo_);

    // API of field "DisplayConstraintInfo"

    static const int kDisplayConstraintInfo = 2;

    /**
     * Clears the field "DisplayConstraintInfo".
     *
     * The field will be set to its default value. The hasDisplayConstraintInfo()
     * method will return false.
     */
    inline void clearDisplayConstraintInfo();

    /**
     * Checks whether the field "DisplayConstraintInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayConstraintInfo()). Otherwise it will return false.
     */
    inline bool hasDisplayConstraintInfo () const;

    /**
     * Returns the value of the member "DisplayConstraintInfo".
     *
     * Display Resource ownership info. This information should be populated by HMI, if handling video resource management is HMI responsibility.
     * For carPlay devices: The information will be directly forwarded to Phone without any interpretation.
     * For Android devices: There are two possible cases for using this.
     * 1) When HMI needs or return the display resource. This can be informed to SPI by populating below parameter, other parameters to be populated to NA
     * HMI request for display resource (Projection device to HMI) : 										                                     DisplayConstraintInfo.TransferType = TRANSFER_TYPE_TAKE or TRANSFER_TYPE_BORROW
     * HMI releases the display resource ( HMI to projection device) : DisplayConstraintInfo.TransferType = TRANSFER_TYPE_UNTAKE or TRANSFER_TYPE_UNBORROW
     * 2) HMI should always update the below parameter based on its current display context. This information will be used by SPI to take a decision whenever
     * Phone request for display. If Take/Borrow constraint set by HMI is TRANSFER_CONSTRAINT_NEVER. SPI service will deny the display resource.
     * Otherwise if Take/Borrow constraint is TRANSFER_CONSTRAINT_ANYTIME or TRANSFER_CONSTRAINT_USERINITIATED, SPI service will grant the display to projection device.
     * DisplayConstraintInfo.TransferType = TAKE/BORROW (TAKE/BORROW- HU needs display), UNTAKE - No effect from SPI side, HMI should do launch app. UNBORROW: SPI will release resource to Android device
     * DisplayConstraintInfo.TransferPriority = TRANSFER_PRIORITY_NA
     * DisplayConstraintInfo.TakeConstraint =  TRANSFER_CONSTRAINT_ANYTIME/TRANSFER_CONSTRAINT_USERINITIATED/TRANSFER_CONSTRAINT_NEVER
     * DisplayConstraintInfo.BorrowConstraint = TRANSFER_CONSTRAINT_ANYTIME/TRANSFER_CONSTRAINT_USERINITIATED/TRANSFER_CONSTRAINT_NEVER
     *
     * @return The value of the field "DisplayConstraintInfo"
     */
    inline const ::midw_smartphoneint_fi_types::T_DisplayConstraint& getDisplayConstraintInfo () const;

    /**
     * Retrieves the value of the field "DisplayConstraintInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayConstraintInfo".
     */
    inline ::midw_smartphoneint_fi_types::T_DisplayConstraint& getDisplayConstraintInfoMutable ();

    /**
     * Sets the value of the member "DisplayConstraintInfo".
     *
     * Display Resource ownership info. This information should be populated by HMI, if handling video resource management is HMI responsibility.
     * For carPlay devices: The information will be directly forwarded to Phone without any interpretation.
     * For Android devices: There are two possible cases for using this.
     * 1) When HMI needs or return the display resource. This can be informed to SPI by populating below parameter, other parameters to be populated to NA
     * HMI request for display resource (Projection device to HMI) : 										                                     DisplayConstraintInfo.TransferType = TRANSFER_TYPE_TAKE or TRANSFER_TYPE_BORROW
     * HMI releases the display resource ( HMI to projection device) : DisplayConstraintInfo.TransferType = TRANSFER_TYPE_UNTAKE or TRANSFER_TYPE_UNBORROW
     * 2) HMI should always update the below parameter based on its current display context. This information will be used by SPI to take a decision whenever
     * Phone request for display. If Take/Borrow constraint set by HMI is TRANSFER_CONSTRAINT_NEVER. SPI service will deny the display resource.
     * Otherwise if Take/Borrow constraint is TRANSFER_CONSTRAINT_ANYTIME or TRANSFER_CONSTRAINT_USERINITIATED, SPI service will grant the display to projection device.
     * DisplayConstraintInfo.TransferType = TAKE/BORROW (TAKE/BORROW- HU needs display), UNTAKE - No effect from SPI side, HMI should do launch app. UNBORROW: SPI will release resource to Android device
     * DisplayConstraintInfo.TransferPriority = TRANSFER_PRIORITY_NA
     * DisplayConstraintInfo.TakeConstraint =  TRANSFER_CONSTRAINT_ANYTIME/TRANSFER_CONSTRAINT_USERINITIATED/TRANSFER_CONSTRAINT_NEVER
     * DisplayConstraintInfo.BorrowConstraint = TRANSFER_CONSTRAINT_ANYTIME/TRANSFER_CONSTRAINT_USERINITIATED/TRANSFER_CONSTRAINT_NEVER
     *
     * @param DisplayConstraintInfo The value which will be set
     */
    inline void setDisplayConstraintInfo (const ::midw_smartphoneint_fi_types::T_DisplayConstraint& DisplayConstraintInfo_);

    // API of field "ContextResponsibility"

    static const int kContextResponsibility = 3;

    /**
     * Clears the field "ContextResponsibility".
     *
     * The field will be set to its default value. The hasContextResponsibility()
     * method will return false.
     */
    inline void clearContextResponsibility();

    /**
     * Checks whether the field "ContextResponsibility" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContextResponsibility()). Otherwise it will return false.
     */
    inline bool hasContextResponsibility () const;

    /**
     * Returns the value of the member "ContextResponsibility".
     *
     * Identify the responsible component to handle the context mapping, .
     *
     * @return The value of the field "ContextResponsibility"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DisplayInfo getContextResponsibility () const;

    /**
     * Sets the value of the member "ContextResponsibility".
     *
     * Identify the responsible component to handle the context mapping, .
     *
     * @param ContextResponsibility The value which will be set
     */
    inline void setContextResponsibility (::midw_smartphoneint_fi_types::T_e8_DisplayInfo ContextResponsibility_);

    static const SetAccessoryDisplayContextStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DisplayContextInfo ();

    inline void clear_has_DisplayContextInfo ();

    inline void set_has_DisplayConstraintInfo ();

    inline void clear_has_DisplayConstraintInfo ();

    inline void set_has_ContextResponsibility ();

    inline void clear_has_ContextResponsibility ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_AccessoryDisplayContext _DisplayContextInfo;

    ::midw_smartphoneint_fi_types::T_DisplayConstraint _DisplayConstraintInfo;

    ::midw_smartphoneint_fi_types::T_e8_DisplayInfo _ContextResponsibility;

};

/**
 * The result message of the method "SetAccessoryDisplayContext"
 * Scope : ML, carPlay, AAP, MySPIN, Carlife.
 * This interface is used by the client to inform the projection device about Head Units current display context. And whenever Head Unit wants to request for the display resource.
 * The video resource management can either be done by HMI(SPI's client) or by SPI service. Normally it is SPI service responsibility.
 * If for what ever reason, HMI have to do video resource  management, then HMI should populate parameter "DisplayConstraintInfo"
 * Otherwise, if it is SPI service responsibility, HMI should populate parameter "DisplayContextInfo".
 * HMI should populate parameter "ContextResponsibility", based on which SPI service will know whether it is SPI or HMI responsibility.
 */
class SetAccessoryDisplayContextResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAccessoryDisplayContextResult ();

    /**
     * Copy constructor
     */
    inline  SetAccessoryDisplayContextResult (const SetAccessoryDisplayContextResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetAccessoryDisplayContextResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetAccessoryDisplayContextResult();

    /**
     * Assignment operator
     */
    inline SetAccessoryDisplayContextResult& operator = (const SetAccessoryDisplayContextResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAccessoryDisplayContextResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAccessoryDisplayContextResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAccessoryDisplayContextResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAccessoryDisplayContextResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetAccessoryDisplayContextResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "GetKeyIconData"
 * Scope : Only for ML
 * It retrieves key icon data referenced by the icon URL provided in the XDeviceKeysList.
 */
class GetKeyIconDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetKeyIconDataStart ();

    /**
     * Copy constructor
     */
    inline  GetKeyIconDataStart (const GetKeyIconDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetKeyIconDataStart (uint32 DeviceHandle_, const ::std::string& KeyIconURL_);

    /**
     * Destructor
     */
    inline virtual  ~GetKeyIconDataStart();

    /**
     * Assignment operator
     */
    inline GetKeyIconDataStart& operator = (const GetKeyIconDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetKeyIconDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetKeyIconDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetKeyIconDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetKeyIconDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "KeyIconURL"

    static const int kKeyIconURL = 1;

    /**
     * Clears the field "KeyIconURL".
     *
     * The field will be set to its default value. The hasKeyIconURL()
     * method will return false.
     */
    inline void clearKeyIconURL();

    /**
     * Checks whether the field "KeyIconURL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyIconURL()). Otherwise it will return false.
     */
    inline bool hasKeyIconURL () const;

    /**
     * Returns the value of the member "KeyIconURL".
     *
     * Key Icon URL for which the icon data is required.
     *
     * @return The value of the field "KeyIconURL"
     */
    inline const ::std::string& getKeyIconURL () const;

    /**
     * Retrieves the value of the field "KeyIconURL" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "KeyIconURL".
     */
    inline ::std::string& getKeyIconURLMutable ();

    /**
     * Sets the value of the member "KeyIconURL".
     *
     * Key Icon URL for which the icon data is required.
     *
     * @param KeyIconURL The value which will be set
     */
    inline void setKeyIconURL (const ::std::string& KeyIconURL_);

    /**
     * Sets the value of the member "KeyIconURL".
     *
     * Key Icon URL for which the icon data is required.
     *
     * @param KeyIconURL The value which will be set
     */
    inline void setKeyIconURL (const char* KeyIconURL_);

    /**
     * Sets the value of the member "KeyIconURL".
     *
     * Key Icon URL for which the icon data is required.
     *
     * @param KeyIconURL The value which will be set
     */
    inline void setKeyIconURL (const char* value, size_t size);

    static const GetKeyIconDataStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_KeyIconURL ();

    inline void clear_has_KeyIconURL ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::std::string _KeyIconURL;

};

/**
 * The result message of the method "GetKeyIconData"
 * Scope : Only for ML
 * It retrieves key icon data referenced by the icon URL provided in the XDeviceKeysList.
 */
class GetKeyIconDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetKeyIconDataResult ();

    /**
     * Copy constructor
     */
    inline  GetKeyIconDataResult (const GetKeyIconDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetKeyIconDataResult (uint32 DeviceHandle_, const ::std::vector< uint8 >& KeyIconData_);

    /**
     * Destructor
     */
    inline virtual  ~GetKeyIconDataResult();

    /**
     * Assignment operator
     */
    inline GetKeyIconDataResult& operator = (const GetKeyIconDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetKeyIconDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetKeyIconDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetKeyIconDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetKeyIconDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Uniquely identifies the target Device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "KeyIconData"

    static const int kKeyIconData = 1;

    /**
     * Clears the field "KeyIconData".
     *
     * The field will be set to its default value. The hasKeyIconData()
     * method will return false.
     */
    inline void clearKeyIconData();

    /**
     * Checks whether the field "KeyIconData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyIconData()). Otherwise it will return false.
     */
    inline bool hasKeyIconData () const;

    /**
     * Returns the value of the member "KeyIconData".
     *
     * Byte Data Stream from the icon image file. Format of the file is defined by IconMimeType parameter.
     *
     * @return The value of the field "KeyIconData"
     */
    inline const ::std::vector< uint8 >& getKeyIconData () const;

    /**
     * Retrieves the value of the field "KeyIconData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "KeyIconData".
     */
    inline ::std::vector< uint8 >& getKeyIconDataMutable ();

    /**
     * Sets the value of the member "KeyIconData".
     *
     * Byte Data Stream from the icon image file. Format of the file is defined by IconMimeType parameter.
     *
     * @param KeyIconData The value which will be set
     */
    inline void setKeyIconData (const ::std::vector< uint8 >& KeyIconData_);

    static const GetKeyIconDataResult &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_KeyIconData ();

    inline void clear_has_KeyIconData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::std::vector< uint8 > _KeyIconData;

};

/**
 * The start message of the method "SetDisplayAttributes"
 * Scope : ML, carPlay, AAP, MySPIN, Carlife.
 * Interface to set the different display attributes of the HU. Normally these setting can also be read by SPI through KDS/diagnosis.
 */
class SetDisplayAttributesStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDisplayAttributesStart ();

    /**
     * Copy constructor
     */
    inline  SetDisplayAttributesStart (const SetDisplayAttributesStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetDisplayAttributesStart (const ::midw_smartphoneint_fi_types::T_DisplayAttributes& DisplayAttributes_);

    /**
     * Destructor
     */
    inline virtual  ~SetDisplayAttributesStart();

    /**
     * Assignment operator
     */
    inline SetDisplayAttributesStart& operator = (const SetDisplayAttributesStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDisplayAttributesStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDisplayAttributesStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDisplayAttributesStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDisplayAttributesStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DisplayAttributes"

    static const int kDisplayAttributes = 0;

    /**
     * Clears the field "DisplayAttributes".
     *
     * The field will be set to its default value. The hasDisplayAttributes()
     * method will return false.
     */
    inline void clearDisplayAttributes();

    /**
     * Checks whether the field "DisplayAttributes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayAttributes()). Otherwise it will return false.
     */
    inline bool hasDisplayAttributes () const;

    /**
     * Returns the value of the member "DisplayAttributes".
     *
     * Method to initiates setting the display attributes.
     *
     * @return The value of the field "DisplayAttributes"
     */
    inline const ::midw_smartphoneint_fi_types::T_DisplayAttributes& getDisplayAttributes () const;

    /**
     * Retrieves the value of the field "DisplayAttributes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayAttributes".
     */
    inline ::midw_smartphoneint_fi_types::T_DisplayAttributes& getDisplayAttributesMutable ();

    /**
     * Sets the value of the member "DisplayAttributes".
     *
     * Method to initiates setting the display attributes.
     *
     * @param DisplayAttributes The value which will be set
     */
    inline void setDisplayAttributes (const ::midw_smartphoneint_fi_types::T_DisplayAttributes& DisplayAttributes_);

    static const SetDisplayAttributesStart &getDefaultInstance();

private:

    inline void set_has_DisplayAttributes ();

    inline void clear_has_DisplayAttributes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_DisplayAttributes _DisplayAttributes;

};

/**
 * The result message of the method "SetDisplayAttributes"
 * Scope : ML, carPlay, AAP, MySPIN, Carlife.
 * Interface to set the different display attributes of the HU. Normally these setting can also be read by SPI through KDS/diagnosis.
 */
class SetDisplayAttributesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDisplayAttributesResult ();

    /**
     * Copy constructor
     */
    inline  SetDisplayAttributesResult (const SetDisplayAttributesResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetDisplayAttributesResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetDisplayAttributesResult();

    /**
     * Assignment operator
     */
    inline SetDisplayAttributesResult& operator = (const SetDisplayAttributesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDisplayAttributesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDisplayAttributesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDisplayAttributesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDisplayAttributesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetDisplayAttributesResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "RotaryControllerEvent"
 * Interface to send Rotary Controller Events when any projection session is active.
 * It should be called with nonzero controller Delta Counts which indicate a movement of the rotary controller by the user.
 */
class RotaryControllerEventStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RotaryControllerEventStart ();

    /**
     * Copy constructor
     */
    inline  RotaryControllerEventStart (const RotaryControllerEventStart &rhs);

    /**
     * All fields constructor
     */
    inline  RotaryControllerEventStart (uint32 DeviceHandle_, int8 ControllerDeltaCounts_);

    /**
     * Destructor
     */
    inline virtual  ~RotaryControllerEventStart();

    /**
     * Assignment operator
     */
    inline RotaryControllerEventStart& operator = (const RotaryControllerEventStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RotaryControllerEventStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RotaryControllerEventStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RotaryControllerEventStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RotaryControllerEventStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "ControllerDeltaCounts"

    static const int kControllerDeltaCounts = 1;

    /**
     * Clears the field "ControllerDeltaCounts".
     *
     * The field will be set to its default value. The hasControllerDeltaCounts()
     * method will return false.
     */
    inline void clearControllerDeltaCounts();

    /**
     * Checks whether the field "ControllerDeltaCounts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setControllerDeltaCounts()). Otherwise it will return false.
     */
    inline bool hasControllerDeltaCounts () const;

    /**
     * Returns the value of the member "ControllerDeltaCounts".
     *
     * Change in controller value counts from the last received faceplate input.
     * The value is +127 (CW)/-128 (CCW) delta counts which have been accumulated since the last time the change in this controller was reported
     *
     * @return The value of the field "ControllerDeltaCounts"
     */
    inline int8 getControllerDeltaCounts () const;

    /**
     * Sets the value of the member "ControllerDeltaCounts".
     *
     * Change in controller value counts from the last received faceplate input.
     * The value is +127 (CW)/-128 (CCW) delta counts which have been accumulated since the last time the change in this controller was reported
     *
     * @param ControllerDeltaCounts The value which will be set
     */
    inline void setControllerDeltaCounts (int8 ControllerDeltaCounts_);

    static const RotaryControllerEventStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_ControllerDeltaCounts ();

    inline void clear_has_ControllerDeltaCounts ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    int8 _ControllerDeltaCounts;

};

/**
 * The result message of the method "RotaryControllerEvent"
 * Interface to send Rotary Controller Events when any projection session is active.
 * It should be called with nonzero controller Delta Counts which indicate a movement of the rotary controller by the user.
 */
class RotaryControllerEventResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RotaryControllerEventResult ();

    /**
     * Copy constructor
     */
    inline  RotaryControllerEventResult (const RotaryControllerEventResult &rhs);

    /**
     * All fields constructor
     */
    inline  RotaryControllerEventResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~RotaryControllerEventResult();

    /**
     * Assignment operator
     */
    inline RotaryControllerEventResult& operator = (const RotaryControllerEventResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RotaryControllerEventResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RotaryControllerEventResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RotaryControllerEventResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RotaryControllerEventResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const RotaryControllerEventResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetAccessoryAudioContext"
 * Scope : ML, carPlay, AAP, MySPIN, Carlife.
 * This interface is used by the HU to inform the projection device about its current Audio context.
 * If projection session is not active set the DeviceHandle to 0xFFFFFFFF.
 */
class SetAccessoryAudioContextStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAccessoryAudioContextStart ();

    /**
     * Copy constructor
     */
    inline  SetAccessoryAudioContextStart (const SetAccessoryAudioContextStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetAccessoryAudioContextStart (uint32 DeviceHandle_, const ::std::vector< ::midw_smartphoneint_fi_types::T_AccessoryAudioContext >& AudioContextInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SetAccessoryAudioContextStart();

    /**
     * Assignment operator
     */
    inline SetAccessoryAudioContextStart& operator = (const SetAccessoryAudioContextStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAccessoryAudioContextStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAccessoryAudioContextStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAccessoryAudioContextStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAccessoryAudioContextStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "AudioContextInfo"

    static const int kAudioContextInfo = 1;

    /**
     * Clears the field "AudioContextInfo".
     *
     * The field will be set to its default value. The hasAudioContextInfo()
     * method will return false.
     */
    inline void clearAudioContextInfo();

    /**
     * Checks whether the field "AudioContextInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioContextInfo()). Otherwise it will return false.
     */
    inline bool hasAudioContextInfo () const;

    /**
     * Returns the value of the member "AudioContextInfo".
     *
     * Provides a list of active audio channels at any instance
     *
     * @return The value of the field "AudioContextInfo"
     */
    inline const ::std::vector< ::midw_smartphoneint_fi_types::T_AccessoryAudioContext >& getAudioContextInfo () const;

    /**
     * Retrieves the value of the field "AudioContextInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudioContextInfo".
     */
    inline ::std::vector< ::midw_smartphoneint_fi_types::T_AccessoryAudioContext >& getAudioContextInfoMutable ();

    /**
     * Sets the value of the member "AudioContextInfo".
     *
     * Provides a list of active audio channels at any instance
     *
     * @param AudioContextInfo The value which will be set
     */
    inline void setAudioContextInfo (const ::std::vector< ::midw_smartphoneint_fi_types::T_AccessoryAudioContext >& AudioContextInfo_);

    static const SetAccessoryAudioContextStart &getDefaultInstance();

private:

    static const ::std::vector< ::midw_smartphoneint_fi_types::T_AccessoryAudioContext >& getT_AccessoryAudioContextList_DefaultInstance ();

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_AudioContextInfo ();

    inline void clear_has_AudioContextInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::std::vector< ::midw_smartphoneint_fi_types::T_AccessoryAudioContext > _AudioContextInfo;

};

/**
 * The result message of the method "SetAccessoryAudioContext"
 * Scope : ML, carPlay, AAP, MySPIN, Carlife.
 * This interface is used by the HU to inform the projection device about its current Audio context.
 * If projection session is not active set the DeviceHandle to 0xFFFFFFFF.
 */
class SetAccessoryAudioContextResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAccessoryAudioContextResult ();

    /**
     * Copy constructor
     */
    inline  SetAccessoryAudioContextResult (const SetAccessoryAudioContextResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetAccessoryAudioContextResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetAccessoryAudioContextResult();

    /**
     * Assignment operator
     */
    inline SetAccessoryAudioContextResult& operator = (const SetAccessoryAudioContextResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAccessoryAudioContextResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAccessoryAudioContextResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAccessoryAudioContextResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAccessoryAudioContextResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetAccessoryAudioContextResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetVehicleMovementState"
 * This interface is used by the HU to inform the projection device about vehicle movement state.
 * Client should provide this information irrespective of projection session state.
 */
class SetVehicleMovementStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVehicleMovementStateStart ();

    /**
     * Copy constructor
     */
    inline  SetVehicleMovementStateStart (const SetVehicleMovementStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetVehicleMovementStateStart (::midw_smartphoneint_fi_types::T_e8_ParkBrake ParkBrakeInfo_, ::midw_smartphoneint_fi_types::T_e8_GearState GearInfo_, ::midw_smartphoneint_fi_types::T_e8_VehicleState VehicleState_);

    /**
     * Destructor
     */
    inline virtual  ~SetVehicleMovementStateStart();

    /**
     * Assignment operator
     */
    inline SetVehicleMovementStateStart& operator = (const SetVehicleMovementStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVehicleMovementStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVehicleMovementStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVehicleMovementStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVehicleMovementStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ParkBrakeInfo"

    static const int kParkBrakeInfo = 0;

    /**
     * Clears the field "ParkBrakeInfo".
     *
     * The field will be set to its default value. The hasParkBrakeInfo()
     * method will return false.
     */
    inline void clearParkBrakeInfo();

    /**
     * Checks whether the field "ParkBrakeInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParkBrakeInfo()). Otherwise it will return false.
     */
    inline bool hasParkBrakeInfo () const;

    /**
     * Returns the value of the member "ParkBrakeInfo".
     *
     * Provides vehicle Handbrake is applied or not. This information will be sent directly to phone.
     *
     * @return The value of the field "ParkBrakeInfo"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ParkBrake getParkBrakeInfo () const;

    /**
     * Sets the value of the member "ParkBrakeInfo".
     *
     * Provides vehicle Handbrake is applied or not. This information will be sent directly to phone.
     *
     * @param ParkBrakeInfo The value which will be set
     */
    inline void setParkBrakeInfo (::midw_smartphoneint_fi_types::T_e8_ParkBrake ParkBrakeInfo_);

    // API of field "GearInfo"

    static const int kGearInfo = 1;

    /**
     * Clears the field "GearInfo".
     *
     * The field will be set to its default value. The hasGearInfo()
     * method will return false.
     */
    inline void clearGearInfo();

    /**
     * Checks whether the field "GearInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGearInfo()). Otherwise it will return false.
     */
    inline bool hasGearInfo () const;

    /**
     * Returns the value of the member "GearInfo".
     *
     * Provides Vehicle Gear status. This information will be sent directly to phone.
     *
     * @return The value of the field "GearInfo"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_GearState getGearInfo () const;

    /**
     * Sets the value of the member "GearInfo".
     *
     * Provides Vehicle Gear status. This information will be sent directly to phone.
     *
     * @param GearInfo The value which will be set
     */
    inline void setGearInfo (::midw_smartphoneint_fi_types::T_e8_GearState GearInfo_);

    // API of field "VehicleState"

    static const int kVehicleState = 2;

    /**
     * Clears the field "VehicleState".
     *
     * The field will be set to its default value. The hasVehicleState()
     * method will return false.
     */
    inline void clearVehicleState();

    /**
     * Checks whether the field "VehicleState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleState()). Otherwise it will return false.
     */
    inline bool hasVehicleState () const;

    /**
     * Returns the value of the member "VehicleState".
     *
     * Provides Vehicle State(Park/Drive).
     * This information will be used by SPI to enable or disable the Phone usage restriction, when in drive or park mode.
     * E.g If projects wants to enable restriction in drive and only after crossing x speed. Then, HMI can send vehicle is in drive after crossing the x speed, so that the restriction is applied only after x speed, not just when vehicle is in drive mode.
     * The kind of restriction that will be applied when in drive or park mode can be set through method SetFeatureRestrictions.
     *
     * @return The value of the field "VehicleState"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_VehicleState getVehicleState () const;

    /**
     * Sets the value of the member "VehicleState".
     *
     * Provides Vehicle State(Park/Drive).
     * This information will be used by SPI to enable or disable the Phone usage restriction, when in drive or park mode.
     * E.g If projects wants to enable restriction in drive and only after crossing x speed. Then, HMI can send vehicle is in drive after crossing the x speed, so that the restriction is applied only after x speed, not just when vehicle is in drive mode.
     * The kind of restriction that will be applied when in drive or park mode can be set through method SetFeatureRestrictions.
     *
     * @param VehicleState The value which will be set
     */
    inline void setVehicleState (::midw_smartphoneint_fi_types::T_e8_VehicleState VehicleState_);

    static const SetVehicleMovementStateStart &getDefaultInstance();

private:

    inline void set_has_ParkBrakeInfo ();

    inline void clear_has_ParkBrakeInfo ();

    inline void set_has_GearInfo ();

    inline void clear_has_GearInfo ();

    inline void set_has_VehicleState ();

    inline void clear_has_VehicleState ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ParkBrake _ParkBrakeInfo;

    ::midw_smartphoneint_fi_types::T_e8_GearState _GearInfo;

    ::midw_smartphoneint_fi_types::T_e8_VehicleState _VehicleState;

};

/**
 * The result message of the method "SetVehicleMovementState"
 * This interface is used by the HU to inform the projection device about vehicle movement state.
 * Client should provide this information irrespective of projection session state.
 */
class SetVehicleMovementStateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVehicleMovementStateResult ();

    /**
     * Copy constructor
     */
    inline  SetVehicleMovementStateResult (const SetVehicleMovementStateResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetVehicleMovementStateResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetVehicleMovementStateResult();

    /**
     * Assignment operator
     */
    inline SetVehicleMovementStateResult& operator = (const SetVehicleMovementStateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVehicleMovementStateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVehicleMovementStateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVehicleMovementStateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVehicleMovementStateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetVehicleMovementStateResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetFeatureRestrictions"
 * This interface is used by the HU to inform the projection device the feature restrictions to be applied when vehicle is in Park/Drive Mode.
 * Client should set the restrictions as soon as SPI service is up and running.
 */
class SetFeatureRestrictionsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFeatureRestrictionsStart ();

    /**
     * Copy constructor
     */
    inline  SetFeatureRestrictionsStart (const SetFeatureRestrictionsStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetFeatureRestrictionsStart (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_, const ::midw_smartphoneint_fi_types::T_FeatureRestriction& ParkModeRestrictionInfo_, const ::midw_smartphoneint_fi_types::T_FeatureRestriction& DriveModeRestrictionInfo_, uint16 GeneralRestrictionInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SetFeatureRestrictionsStart();

    /**
     * Assignment operator
     */
    inline SetFeatureRestrictionsStart& operator = (const SetFeatureRestrictionsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFeatureRestrictionsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFeatureRestrictionsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFeatureRestrictionsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFeatureRestrictionsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceCategory"

    static const int kDeviceCategory = 0;

    /**
     * Clears the field "DeviceCategory".
     *
     * The field will be set to its default value. The hasDeviceCategory()
     * method will return false.
     */
    inline void clearDeviceCategory();

    /**
     * Checks whether the field "DeviceCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceCategory()). Otherwise it will return false.
     */
    inline bool hasDeviceCategory () const;

    /**
     * Returns the value of the member "DeviceCategory".
     *
     * Projection technology for which feature restrictions has to be applied.
     *
     * @return The value of the field "DeviceCategory"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getDeviceCategory () const;

    /**
     * Sets the value of the member "DeviceCategory".
     *
     * Projection technology for which feature restrictions has to be applied.
     *
     * @param DeviceCategory The value which will be set
     */
    inline void setDeviceCategory (::midw_smartphoneint_fi_types::T_e8_DeviceCategory DeviceCategory_);

    // API of field "ParkModeRestrictionInfo"

    static const int kParkModeRestrictionInfo = 1;

    /**
     * Clears the field "ParkModeRestrictionInfo".
     *
     * The field will be set to its default value. The hasParkModeRestrictionInfo()
     * method will return false.
     */
    inline void clearParkModeRestrictionInfo();

    /**
     * Checks whether the field "ParkModeRestrictionInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParkModeRestrictionInfo()). Otherwise it will return false.
     */
    inline bool hasParkModeRestrictionInfo () const;

    /**
     * Returns the value of the member "ParkModeRestrictionInfo".
     *
     * This parameter says what features to be restricted when vehicle is in Park Mode.
     * This parameter is applicable for Android audio only. Restriction for carplay in park mode is not applicable.
     * And also for Mirror Link restriction is not possible through this interface, it is only based on the apps certification.
     *
     * @return The value of the field "ParkModeRestrictionInfo"
     */
    inline const ::midw_smartphoneint_fi_types::T_FeatureRestriction& getParkModeRestrictionInfo () const;

    /**
     * Retrieves the value of the field "ParkModeRestrictionInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ParkModeRestrictionInfo".
     */
    inline ::midw_smartphoneint_fi_types::T_FeatureRestriction& getParkModeRestrictionInfoMutable ();

    /**
     * Sets the value of the member "ParkModeRestrictionInfo".
     *
     * This parameter says what features to be restricted when vehicle is in Park Mode.
     * This parameter is applicable for Android audio only. Restriction for carplay in park mode is not applicable.
     * And also for Mirror Link restriction is not possible through this interface, it is only based on the apps certification.
     *
     * @param ParkModeRestrictionInfo The value which will be set
     */
    inline void setParkModeRestrictionInfo (const ::midw_smartphoneint_fi_types::T_FeatureRestriction& ParkModeRestrictionInfo_);

    // API of field "DriveModeRestrictionInfo"

    static const int kDriveModeRestrictionInfo = 2;

    /**
     * Clears the field "DriveModeRestrictionInfo".
     *
     * The field will be set to its default value. The hasDriveModeRestrictionInfo()
     * method will return false.
     */
    inline void clearDriveModeRestrictionInfo();

    /**
     * Checks whether the field "DriveModeRestrictionInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriveModeRestrictionInfo()). Otherwise it will return false.
     */
    inline bool hasDriveModeRestrictionInfo () const;

    /**
     * Returns the value of the member "DriveModeRestrictionInfo".
     *
     * This parameter says what features to be restricted when vehicle is in Drive Mode.
     * For Mirror Link restriction is not possible through this interface, it is only based on the apps certification.
     * For CarPlay and Android Auto, it is based on the parameter value, see types "T_FeatureRestriction" for more info on what feature can be enabled or disable.
     *
     * @return The value of the field "DriveModeRestrictionInfo"
     */
    inline const ::midw_smartphoneint_fi_types::T_FeatureRestriction& getDriveModeRestrictionInfo () const;

    /**
     * Retrieves the value of the field "DriveModeRestrictionInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DriveModeRestrictionInfo".
     */
    inline ::midw_smartphoneint_fi_types::T_FeatureRestriction& getDriveModeRestrictionInfoMutable ();

    /**
     * Sets the value of the member "DriveModeRestrictionInfo".
     *
     * This parameter says what features to be restricted when vehicle is in Drive Mode.
     * For Mirror Link restriction is not possible through this interface, it is only based on the apps certification.
     * For CarPlay and Android Auto, it is based on the parameter value, see types "T_FeatureRestriction" for more info on what feature can be enabled or disable.
     *
     * @param DriveModeRestrictionInfo The value which will be set
     */
    inline void setDriveModeRestrictionInfo (const ::midw_smartphoneint_fi_types::T_FeatureRestriction& DriveModeRestrictionInfo_);

    // API of field "GeneralRestrictionInfo"

    static const int kGeneralRestrictionInfo = 3;

    /**
     * Clears the field "GeneralRestrictionInfo".
     *
     * The field will be set to its default value. The hasGeneralRestrictionInfo()
     * method will return false.
     */
    inline void clearGeneralRestrictionInfo();

    /**
     * Checks whether the field "GeneralRestrictionInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeneralRestrictionInfo()). Otherwise it will return false.
     */
    inline bool hasGeneralRestrictionInfo () const;

    /**
     * Returns the value of the member "GeneralRestrictionInfo".
     *
     * This parameter says what features are to set as a part of general restrictions irrespective of gear status.
     * Values are in little endian format.
     *
     * Restrictions for AAP
     * 0 bit - Hide battery level(If the bit = true , battery level will not be displayed; if bit = false, battery level( is displayed)
     * 1 bit - Hide clock(If the bit = true , clock will not be displayed; if bit = false, clock is displayed)
     * 2 bit - Hide phone signal(If the bit = true , phone signal will not be displayed; if bit = false, phone signal is displayed)
     * 3 bit - BT limitation mode bit(If the bit = true , the bt pairing will be delayed until AOC is accepted; if bit = false ,the pairing is done without delay)
     * 4 Bit - ETC Feature - (If bit = 1, ETC(Electronic Toll Collection) Feature Enabled. Else If bit = 0 , ETC Feature is Disabled.)
     * All the other bits are not defined.
     *
     * Restrictions for CP
     * 0 bit - ETC feature  - (If bit = 1, ETC(Electronic Toll Collection) Feature Enabled. Else If bit = 0 , ETC Feature is Disabled.)
     * All the other bits are not defined.
     *
     * @return The value of the field "GeneralRestrictionInfo"
     */
    inline uint16 getGeneralRestrictionInfo () const;

    /**
     * Sets the value of the member "GeneralRestrictionInfo".
     *
     * This parameter says what features are to set as a part of general restrictions irrespective of gear status.
     * Values are in little endian format.
     *
     * Restrictions for AAP
     * 0 bit - Hide battery level(If the bit = true , battery level will not be displayed; if bit = false, battery level( is displayed)
     * 1 bit - Hide clock(If the bit = true , clock will not be displayed; if bit = false, clock is displayed)
     * 2 bit - Hide phone signal(If the bit = true , phone signal will not be displayed; if bit = false, phone signal is displayed)
     * 3 bit - BT limitation mode bit(If the bit = true , the bt pairing will be delayed until AOC is accepted; if bit = false ,the pairing is done without delay)
     * 4 Bit - ETC Feature - (If bit = 1, ETC(Electronic Toll Collection) Feature Enabled. Else If bit = 0 , ETC Feature is Disabled.)
     * All the other bits are not defined.
     *
     * Restrictions for CP
     * 0 bit - ETC feature  - (If bit = 1, ETC(Electronic Toll Collection) Feature Enabled. Else If bit = 0 , ETC Feature is Disabled.)
     * All the other bits are not defined.
     *
     * @param GeneralRestrictionInfo The value which will be set
     */
    inline void setGeneralRestrictionInfo (uint16 GeneralRestrictionInfo_);

    static const SetFeatureRestrictionsStart &getDefaultInstance();

private:

    inline void set_has_DeviceCategory ();

    inline void clear_has_DeviceCategory ();

    inline void set_has_ParkModeRestrictionInfo ();

    inline void clear_has_ParkModeRestrictionInfo ();

    inline void set_has_DriveModeRestrictionInfo ();

    inline void clear_has_DriveModeRestrictionInfo ();

    inline void set_has_GeneralRestrictionInfo ();

    inline void clear_has_GeneralRestrictionInfo ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _DeviceCategory;

    ::midw_smartphoneint_fi_types::T_FeatureRestriction _ParkModeRestrictionInfo;

    ::midw_smartphoneint_fi_types::T_FeatureRestriction _DriveModeRestrictionInfo;

    uint16 _GeneralRestrictionInfo;

};

/**
 * The result message of the method "SetFeatureRestrictions"
 * This interface is used by the HU to inform the projection device the feature restrictions to be applied when vehicle is in Park/Drive Mode.
 * Client should set the restrictions as soon as SPI service is up and running.
 */
class SetFeatureRestrictionsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFeatureRestrictionsResult ();

    /**
     * Copy constructor
     */
    inline  SetFeatureRestrictionsResult (const SetFeatureRestrictionsResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetFeatureRestrictionsResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetFeatureRestrictionsResult();

    /**
     * Assignment operator
     */
    inline SetFeatureRestrictionsResult& operator = (const SetFeatureRestrictionsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFeatureRestrictionsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFeatureRestrictionsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFeatureRestrictionsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFeatureRestrictionsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetFeatureRestrictionsResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "VehicleMechanicalSpeed"
 * Scope: AAP, CarPlay, Carlife.
 * This interface is used by the client to update the vehicle mechanical speed that is derived from non GPS sources(i.e from wheels).
 * This data needs to be sent only when device is selected and speed data is changed, SPI will take care of sending the data at the required rate to the devices.
 */
class VehicleMechanicalSpeedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleMechanicalSpeedStart ();

    /**
     * Copy constructor
     */
    inline  VehicleMechanicalSpeedStart (const VehicleMechanicalSpeedStart &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleMechanicalSpeedStart (int32 VehicleSpeed_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleMechanicalSpeedStart();

    /**
     * Assignment operator
     */
    inline VehicleMechanicalSpeedStart& operator = (const VehicleMechanicalSpeedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleMechanicalSpeedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleMechanicalSpeedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleMechanicalSpeedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleMechanicalSpeedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VehicleSpeed"

    static const int kVehicleSpeed = 0;

    /**
     * Clears the field "VehicleSpeed".
     *
     * The field will be set to its default value. The hasVehicleSpeed()
     * method will return false.
     */
    inline void clearVehicleSpeed();

    /**
     * Checks whether the field "VehicleSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleSpeed()). Otherwise it will return false.
     */
    inline bool hasVehicleSpeed () const;

    /**
     * Returns the value of the member "VehicleSpeed".
     *
     * Vehicle speed in cm(centimeters)/sec.
     *
     * @return The value of the field "VehicleSpeed"
     */
    inline int32 getVehicleSpeed () const;

    /**
     * Sets the value of the member "VehicleSpeed".
     *
     * Vehicle speed in cm(centimeters)/sec.
     *
     * @param VehicleSpeed The value which will be set
     */
    inline void setVehicleSpeed (int32 VehicleSpeed_);

    static const VehicleMechanicalSpeedStart &getDefaultInstance();

private:

    inline void set_has_VehicleSpeed ();

    inline void clear_has_VehicleSpeed ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _VehicleSpeed;

};

/**
 * The result message of the method "VehicleMechanicalSpeed"
 * Scope: AAP, CarPlay, Carlife.
 * This interface is used by the client to update the vehicle mechanical speed that is derived from non GPS sources(i.e from wheels).
 * This data needs to be sent only when device is selected and speed data is changed, SPI will take care of sending the data at the required rate to the devices.
 */
class VehicleMechanicalSpeedResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleMechanicalSpeedResult ();

    /**
     * Copy constructor
     */
    inline  VehicleMechanicalSpeedResult (const VehicleMechanicalSpeedResult &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleMechanicalSpeedResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleMechanicalSpeedResult();

    /**
     * Assignment operator
     */
    inline VehicleMechanicalSpeedResult& operator = (const VehicleMechanicalSpeedResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleMechanicalSpeedResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleMechanicalSpeedResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleMechanicalSpeedResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleMechanicalSpeedResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const VehicleMechanicalSpeedResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetVehicleManufacturerInformation"
 * This interface is used by the client to update the various vehicle information.
 * Please note some information are mandatory that needs to be provided by the client.
 * Client should populate this information as soon as SPI service is available.
 */
class SetVehicleManufacturerInformationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVehicleManufacturerInformationStart ();

    /**
     * Copy constructor
     */
    inline  SetVehicleManufacturerInformationStart (const SetVehicleManufacturerInformationStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetVehicleManufacturerInformationStart (const ::std::string& VehicleMake_, const ::std::string& VehicleModel_, const ::std::string& VehicleModelYear_, const ::std::string& VehicleHUSwVersion_, const ::std::string& VehicleHUHwVersion_, const ::std::string& VehicleHUMake_, const ::std::string& VehicleHUModel_, const ::std::string& VehicleHUSwBuild_, ::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration DriverSideInfo_, bool isNativeNavSupported_, const ::midw_smartphoneint_fi_types::T_OEMICONDetails& OEMICONDetails_, bool isRotaryCtrlSupported_, ::midw_smartphoneint_fi_types::T_e8_FidelityType FidelityType_, uint16 SupportedSPITechnologiesInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SetVehicleManufacturerInformationStart();

    /**
     * Assignment operator
     */
    inline SetVehicleManufacturerInformationStart& operator = (const SetVehicleManufacturerInformationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVehicleManufacturerInformationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVehicleManufacturerInformationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVehicleManufacturerInformationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVehicleManufacturerInformationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VehicleMake"

    static const int kVehicleMake = 0;

    /**
     * Clears the field "VehicleMake".
     *
     * The field will be set to its default value. The hasVehicleMake()
     * method will return false.
     */
    inline void clearVehicleMake();

    /**
     * Checks whether the field "VehicleMake" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleMake()). Otherwise it will return false.
     */
    inline bool hasVehicleMake () const;

    /**
     * Returns the value of the member "VehicleMake".
     *
     * Its Mandatory. Vehicle manufacture name.
     *
     * @return The value of the field "VehicleMake"
     */
    inline const ::std::string& getVehicleMake () const;

    /**
     * Retrieves the value of the field "VehicleMake" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VehicleMake".
     */
    inline ::std::string& getVehicleMakeMutable ();

    /**
     * Sets the value of the member "VehicleMake".
     *
     * Its Mandatory. Vehicle manufacture name.
     *
     * @param VehicleMake The value which will be set
     */
    inline void setVehicleMake (const ::std::string& VehicleMake_);

    /**
     * Sets the value of the member "VehicleMake".
     *
     * Its Mandatory. Vehicle manufacture name.
     *
     * @param VehicleMake The value which will be set
     */
    inline void setVehicleMake (const char* VehicleMake_);

    /**
     * Sets the value of the member "VehicleMake".
     *
     * Its Mandatory. Vehicle manufacture name.
     *
     * @param VehicleMake The value which will be set
     */
    inline void setVehicleMake (const char* value, size_t size);

    // API of field "VehicleModel"

    static const int kVehicleModel = 1;

    /**
     * Clears the field "VehicleModel".
     *
     * The field will be set to its default value. The hasVehicleModel()
     * method will return false.
     */
    inline void clearVehicleModel();

    /**
     * Checks whether the field "VehicleModel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleModel()). Otherwise it will return false.
     */
    inline bool hasVehicleModel () const;

    /**
     * Returns the value of the member "VehicleModel".
     *
     * Its Mandatory. Vehicle model, it changes based on vehicle variant
     *
     * @return The value of the field "VehicleModel"
     */
    inline const ::std::string& getVehicleModel () const;

    /**
     * Retrieves the value of the field "VehicleModel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VehicleModel".
     */
    inline ::std::string& getVehicleModelMutable ();

    /**
     * Sets the value of the member "VehicleModel".
     *
     * Its Mandatory. Vehicle model, it changes based on vehicle variant
     *
     * @param VehicleModel The value which will be set
     */
    inline void setVehicleModel (const ::std::string& VehicleModel_);

    /**
     * Sets the value of the member "VehicleModel".
     *
     * Its Mandatory. Vehicle model, it changes based on vehicle variant
     *
     * @param VehicleModel The value which will be set
     */
    inline void setVehicleModel (const char* VehicleModel_);

    /**
     * Sets the value of the member "VehicleModel".
     *
     * Its Mandatory. Vehicle model, it changes based on vehicle variant
     *
     * @param VehicleModel The value which will be set
     */
    inline void setVehicleModel (const char* value, size_t size);

    // API of field "VehicleModelYear"

    static const int kVehicleModelYear = 2;

    /**
     * Clears the field "VehicleModelYear".
     *
     * The field will be set to its default value. The hasVehicleModelYear()
     * method will return false.
     */
    inline void clearVehicleModelYear();

    /**
     * Checks whether the field "VehicleModelYear" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleModelYear()). Otherwise it will return false.
     */
    inline bool hasVehicleModelYear () const;

    /**
     * Returns the value of the member "VehicleModelYear".
     *
     * Its Mandatory. Vehicle mode1 year, it is distinct from year of manufacturer
     *
     * @return The value of the field "VehicleModelYear"
     */
    inline const ::std::string& getVehicleModelYear () const;

    /**
     * Retrieves the value of the field "VehicleModelYear" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VehicleModelYear".
     */
    inline ::std::string& getVehicleModelYearMutable ();

    /**
     * Sets the value of the member "VehicleModelYear".
     *
     * Its Mandatory. Vehicle mode1 year, it is distinct from year of manufacturer
     *
     * @param VehicleModelYear The value which will be set
     */
    inline void setVehicleModelYear (const ::std::string& VehicleModelYear_);

    /**
     * Sets the value of the member "VehicleModelYear".
     *
     * Its Mandatory. Vehicle mode1 year, it is distinct from year of manufacturer
     *
     * @param VehicleModelYear The value which will be set
     */
    inline void setVehicleModelYear (const char* VehicleModelYear_);

    /**
     * Sets the value of the member "VehicleModelYear".
     *
     * Its Mandatory. Vehicle mode1 year, it is distinct from year of manufacturer
     *
     * @param VehicleModelYear The value which will be set
     */
    inline void setVehicleModelYear (const char* value, size_t size);

    // API of field "VehicleHUSwVersion"

    static const int kVehicleHUSwVersion = 3;

    /**
     * Clears the field "VehicleHUSwVersion".
     *
     * The field will be set to its default value. The hasVehicleHUSwVersion()
     * method will return false.
     */
    inline void clearVehicleHUSwVersion();

    /**
     * Checks whether the field "VehicleHUSwVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleHUSwVersion()). Otherwise it will return false.
     */
    inline bool hasVehicleHUSwVersion () const;

    /**
     * Returns the value of the member "VehicleHUSwVersion".
     *
     * Its Mandatory.  Vehicle Head Unit software version
     *
     * @return The value of the field "VehicleHUSwVersion"
     */
    inline const ::std::string& getVehicleHUSwVersion () const;

    /**
     * Retrieves the value of the field "VehicleHUSwVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VehicleHUSwVersion".
     */
    inline ::std::string& getVehicleHUSwVersionMutable ();

    /**
     * Sets the value of the member "VehicleHUSwVersion".
     *
     * Its Mandatory.  Vehicle Head Unit software version
     *
     * @param VehicleHUSwVersion The value which will be set
     */
    inline void setVehicleHUSwVersion (const ::std::string& VehicleHUSwVersion_);

    /**
     * Sets the value of the member "VehicleHUSwVersion".
     *
     * Its Mandatory.  Vehicle Head Unit software version
     *
     * @param VehicleHUSwVersion The value which will be set
     */
    inline void setVehicleHUSwVersion (const char* VehicleHUSwVersion_);

    /**
     * Sets the value of the member "VehicleHUSwVersion".
     *
     * Its Mandatory.  Vehicle Head Unit software version
     *
     * @param VehicleHUSwVersion The value which will be set
     */
    inline void setVehicleHUSwVersion (const char* value, size_t size);

    // API of field "VehicleHUHwVersion"

    static const int kVehicleHUHwVersion = 4;

    /**
     * Clears the field "VehicleHUHwVersion".
     *
     * The field will be set to its default value. The hasVehicleHUHwVersion()
     * method will return false.
     */
    inline void clearVehicleHUHwVersion();

    /**
     * Checks whether the field "VehicleHUHwVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleHUHwVersion()). Otherwise it will return false.
     */
    inline bool hasVehicleHUHwVersion () const;

    /**
     * Returns the value of the member "VehicleHUHwVersion".
     *
     * Its Optional.  Vehicle Head Unit Hardware version
     *
     * @return The value of the field "VehicleHUHwVersion"
     */
    inline const ::std::string& getVehicleHUHwVersion () const;

    /**
     * Retrieves the value of the field "VehicleHUHwVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VehicleHUHwVersion".
     */
    inline ::std::string& getVehicleHUHwVersionMutable ();

    /**
     * Sets the value of the member "VehicleHUHwVersion".
     *
     * Its Optional.  Vehicle Head Unit Hardware version
     *
     * @param VehicleHUHwVersion The value which will be set
     */
    inline void setVehicleHUHwVersion (const ::std::string& VehicleHUHwVersion_);

    /**
     * Sets the value of the member "VehicleHUHwVersion".
     *
     * Its Optional.  Vehicle Head Unit Hardware version
     *
     * @param VehicleHUHwVersion The value which will be set
     */
    inline void setVehicleHUHwVersion (const char* VehicleHUHwVersion_);

    /**
     * Sets the value of the member "VehicleHUHwVersion".
     *
     * Its Optional.  Vehicle Head Unit Hardware version
     *
     * @param VehicleHUHwVersion The value which will be set
     */
    inline void setVehicleHUHwVersion (const char* value, size_t size);

    // API of field "VehicleHUMake"

    static const int kVehicleHUMake = 5;

    /**
     * Clears the field "VehicleHUMake".
     *
     * The field will be set to its default value. The hasVehicleHUMake()
     * method will return false.
     */
    inline void clearVehicleHUMake();

    /**
     * Checks whether the field "VehicleHUMake" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleHUMake()). Otherwise it will return false.
     */
    inline bool hasVehicleHUMake () const;

    /**
     * Returns the value of the member "VehicleHUMake".
     *
     * Vehicle's Head Unit Manufacture name.
     *
     * @return The value of the field "VehicleHUMake"
     */
    inline const ::std::string& getVehicleHUMake () const;

    /**
     * Retrieves the value of the field "VehicleHUMake" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VehicleHUMake".
     */
    inline ::std::string& getVehicleHUMakeMutable ();

    /**
     * Sets the value of the member "VehicleHUMake".
     *
     * Vehicle's Head Unit Manufacture name.
     *
     * @param VehicleHUMake The value which will be set
     */
    inline void setVehicleHUMake (const ::std::string& VehicleHUMake_);

    /**
     * Sets the value of the member "VehicleHUMake".
     *
     * Vehicle's Head Unit Manufacture name.
     *
     * @param VehicleHUMake The value which will be set
     */
    inline void setVehicleHUMake (const char* VehicleHUMake_);

    /**
     * Sets the value of the member "VehicleHUMake".
     *
     * Vehicle's Head Unit Manufacture name.
     *
     * @param VehicleHUMake The value which will be set
     */
    inline void setVehicleHUMake (const char* value, size_t size);

    // API of field "VehicleHUModel"

    static const int kVehicleHUModel = 6;

    /**
     * Clears the field "VehicleHUModel".
     *
     * The field will be set to its default value. The hasVehicleHUModel()
     * method will return false.
     */
    inline void clearVehicleHUModel();

    /**
     * Checks whether the field "VehicleHUModel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleHUModel()). Otherwise it will return false.
     */
    inline bool hasVehicleHUModel () const;

    /**
     * Returns the value of the member "VehicleHUModel".
     *
     * Vehicle's Head Unit Model name.
     *
     * @return The value of the field "VehicleHUModel"
     */
    inline const ::std::string& getVehicleHUModel () const;

    /**
     * Retrieves the value of the field "VehicleHUModel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VehicleHUModel".
     */
    inline ::std::string& getVehicleHUModelMutable ();

    /**
     * Sets the value of the member "VehicleHUModel".
     *
     * Vehicle's Head Unit Model name.
     *
     * @param VehicleHUModel The value which will be set
     */
    inline void setVehicleHUModel (const ::std::string& VehicleHUModel_);

    /**
     * Sets the value of the member "VehicleHUModel".
     *
     * Vehicle's Head Unit Model name.
     *
     * @param VehicleHUModel The value which will be set
     */
    inline void setVehicleHUModel (const char* VehicleHUModel_);

    /**
     * Sets the value of the member "VehicleHUModel".
     *
     * Vehicle's Head Unit Model name.
     *
     * @param VehicleHUModel The value which will be set
     */
    inline void setVehicleHUModel (const char* value, size_t size);

    // API of field "VehicleHUSwBuild"

    static const int kVehicleHUSwBuild = 7;

    /**
     * Clears the field "VehicleHUSwBuild".
     *
     * The field will be set to its default value. The hasVehicleHUSwBuild()
     * method will return false.
     */
    inline void clearVehicleHUSwBuild();

    /**
     * Checks whether the field "VehicleHUSwBuild" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleHUSwBuild()). Otherwise it will return false.
     */
    inline bool hasVehicleHUSwBuild () const;

    /**
     * Returns the value of the member "VehicleHUSwBuild".
     *
     * Vehicle's Head Unit software build
     *
     * @return The value of the field "VehicleHUSwBuild"
     */
    inline const ::std::string& getVehicleHUSwBuild () const;

    /**
     * Retrieves the value of the field "VehicleHUSwBuild" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VehicleHUSwBuild".
     */
    inline ::std::string& getVehicleHUSwBuildMutable ();

    /**
     * Sets the value of the member "VehicleHUSwBuild".
     *
     * Vehicle's Head Unit software build
     *
     * @param VehicleHUSwBuild The value which will be set
     */
    inline void setVehicleHUSwBuild (const ::std::string& VehicleHUSwBuild_);

    /**
     * Sets the value of the member "VehicleHUSwBuild".
     *
     * Vehicle's Head Unit software build
     *
     * @param VehicleHUSwBuild The value which will be set
     */
    inline void setVehicleHUSwBuild (const char* VehicleHUSwBuild_);

    /**
     * Sets the value of the member "VehicleHUSwBuild".
     *
     * Vehicle's Head Unit software build
     *
     * @param VehicleHUSwBuild The value which will be set
     */
    inline void setVehicleHUSwBuild (const char* value, size_t size);

    // API of field "DriverSideInfo"

    static const int kDriverSideInfo = 8;

    /**
     * Clears the field "DriverSideInfo".
     *
     * The field will be set to its default value. The hasDriverSideInfo()
     * method will return false.
     */
    inline void clearDriverSideInfo();

    /**
     * Checks whether the field "DriverSideInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriverSideInfo()). Otherwise it will return false.
     */
    inline bool hasDriverSideInfo () const;

    /**
     * Returns the value of the member "DriverSideInfo".
     *
     * Vehicle's Driver Side Information
     *
     * @return The value of the field "DriverSideInfo"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration getDriverSideInfo () const;

    /**
     * Sets the value of the member "DriverSideInfo".
     *
     * Vehicle's Driver Side Information
     *
     * @param DriverSideInfo The value which will be set
     */
    inline void setDriverSideInfo (::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration DriverSideInfo_);

    // API of field "isNativeNavSupported"

    static const int kIsNativeNavSupported = 9;

    /**
     * Clears the field "isNativeNavSupported".
     *
     * The field will be set to its default value. The hasIsNativeNavSupported()
     * method will return false.
     */
    inline void clearIsNativeNavSupported();

    /**
     * Checks whether the field "isNativeNavSupported" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsNativeNavSupported()). Otherwise it will return false.
     */
    inline bool hasIsNativeNavSupported () const;

    /**
     * Returns the value of the member "isNativeNavSupported".
     *
     * Native Navigation Enabled Information
     *
     * @return The value of the field "isNativeNavSupported"
     */
    inline bool getIsNativeNavSupported () const;

    /**
     * Sets the value of the member "isNativeNavSupported".
     *
     * Native Navigation Enabled Information
     *
     * @param isNativeNavSupported The value which will be set
     */
    inline void setIsNativeNavSupported (bool isNativeNavSupported_);

    // API of field "OEMICONDetails"

    static const int kOEMICONDetails = 10;

    /**
     * Clears the field "OEMICONDetails".
     *
     * The field will be set to its default value. The hasOEMICONDetails()
     * method will return false.
     */
    inline void clearOEMICONDetails();

    /**
     * Checks whether the field "OEMICONDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOEMICONDetails()). Otherwise it will return false.
     */
    inline bool hasOEMICONDetails () const;

    /**
     * Returns the value of the member "OEMICONDetails".
     *
     * OEMICON Information
     *
     * @return The value of the field "OEMICONDetails"
     */
    inline const ::midw_smartphoneint_fi_types::T_OEMICONDetails& getOEMICONDetails () const;

    /**
     * Retrieves the value of the field "OEMICONDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OEMICONDetails".
     */
    inline ::midw_smartphoneint_fi_types::T_OEMICONDetails& getOEMICONDetailsMutable ();

    /**
     * Sets the value of the member "OEMICONDetails".
     *
     * OEMICON Information
     *
     * @param OEMICONDetails The value which will be set
     */
    inline void setOEMICONDetails (const ::midw_smartphoneint_fi_types::T_OEMICONDetails& OEMICONDetails_);

    // API of field "isRotaryCtrlSupported"

    static const int kIsRotaryCtrlSupported = 11;

    /**
     * Clears the field "isRotaryCtrlSupported".
     *
     * The field will be set to its default value. The hasIsRotaryCtrlSupported()
     * method will return false.
     */
    inline void clearIsRotaryCtrlSupported();

    /**
     * Checks whether the field "isRotaryCtrlSupported" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsRotaryCtrlSupported()). Otherwise it will return false.
     */
    inline bool hasIsRotaryCtrlSupported () const;

    /**
     * Returns the value of the member "isRotaryCtrlSupported".
     *
     * Rotary Control Supported Information
     *
     * @return The value of the field "isRotaryCtrlSupported"
     */
    inline bool getIsRotaryCtrlSupported () const;

    /**
     * Sets the value of the member "isRotaryCtrlSupported".
     *
     * Rotary Control Supported Information
     *
     * @param isRotaryCtrlSupported The value which will be set
     */
    inline void setIsRotaryCtrlSupported (bool isRotaryCtrlSupported_);

    // API of field "FidelityType"

    static const int kFidelityType = 12;

    /**
     * Clears the field "FidelityType".
     *
     * The field will be set to its default value. The hasFidelityType()
     * method will return false.
     */
    inline void clearFidelityType();

    /**
     * Checks whether the field "FidelityType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFidelityType()). Otherwise it will return false.
     */
    inline bool hasFidelityType () const;

    /**
     * Returns the value of the member "FidelityType".
     *
     * Information about HIGH Fidelity / LOW Fidelity
     *
     * @return The value of the field "FidelityType"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_FidelityType getFidelityType () const;

    /**
     * Sets the value of the member "FidelityType".
     *
     * Information about HIGH Fidelity / LOW Fidelity
     *
     * @param FidelityType The value which will be set
     */
    inline void setFidelityType (::midw_smartphoneint_fi_types::T_e8_FidelityType FidelityType_);

    // API of field "SupportedSPITechnologiesInfo"

    static const int kSupportedSPITechnologiesInfo = 13;

    /**
     * Clears the field "SupportedSPITechnologiesInfo".
     *
     * The field will be set to its default value. The hasSupportedSPITechnologiesInfo()
     * method will return false.
     */
    inline void clearSupportedSPITechnologiesInfo();

    /**
     * Checks whether the field "SupportedSPITechnologiesInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupportedSPITechnologiesInfo()). Otherwise it will return false.
     */
    inline bool hasSupportedSPITechnologiesInfo () const;

    /**
     * Returns the value of the member "SupportedSPITechnologiesInfo".
     *
     * SPI Features Enabled - Values representing Technologies - BitWise Operation
     * MirrorLink = 1,CARPLAY=2,AndroidAuto=4, MySpIn=8,CARPLAYWIRELESS=16,AAPWIRELESS=32,CARLIFE = 64
     * For Example: If MirrorLink, Carplay and AndroidAuto to be Enabled - then set this field to 7 (that is mirrorlink -1, carplay-2 and androidauto - 4)
     *
     * @return The value of the field "SupportedSPITechnologiesInfo"
     */
    inline uint16 getSupportedSPITechnologiesInfo () const;

    /**
     * Sets the value of the member "SupportedSPITechnologiesInfo".
     *
     * SPI Features Enabled - Values representing Technologies - BitWise Operation
     * MirrorLink = 1,CARPLAY=2,AndroidAuto=4, MySpIn=8,CARPLAYWIRELESS=16,AAPWIRELESS=32,CARLIFE = 64
     * For Example: If MirrorLink, Carplay and AndroidAuto to be Enabled - then set this field to 7 (that is mirrorlink -1, carplay-2 and androidauto - 4)
     *
     * @param SupportedSPITechnologiesInfo The value which will be set
     */
    inline void setSupportedSPITechnologiesInfo (uint16 SupportedSPITechnologiesInfo_);

    static const SetVehicleManufacturerInformationStart &getDefaultInstance();

private:

    inline void set_has_VehicleMake ();

    inline void clear_has_VehicleMake ();

    inline void set_has_VehicleModel ();

    inline void clear_has_VehicleModel ();

    inline void set_has_VehicleModelYear ();

    inline void clear_has_VehicleModelYear ();

    inline void set_has_VehicleHUSwVersion ();

    inline void clear_has_VehicleHUSwVersion ();

    inline void set_has_VehicleHUHwVersion ();

    inline void clear_has_VehicleHUHwVersion ();

    inline void set_has_VehicleHUMake ();

    inline void clear_has_VehicleHUMake ();

    inline void set_has_VehicleHUModel ();

    inline void clear_has_VehicleHUModel ();

    inline void set_has_VehicleHUSwBuild ();

    inline void clear_has_VehicleHUSwBuild ();

    inline void set_has_DriverSideInfo ();

    inline void clear_has_DriverSideInfo ();

    inline void set_has_isNativeNavSupported ();

    inline void clear_has_isNativeNavSupported ();

    inline void set_has_OEMICONDetails ();

    inline void clear_has_OEMICONDetails ();

    inline void set_has_isRotaryCtrlSupported ();

    inline void clear_has_isRotaryCtrlSupported ();

    inline void set_has_FidelityType ();

    inline void clear_has_FidelityType ();

    inline void set_has_SupportedSPITechnologiesInfo ();

    inline void clear_has_SupportedSPITechnologiesInfo ();

    uint32 _has_bits_[ (14 + 31) / 32];

    ::std::string _VehicleMake;

    ::std::string _VehicleModel;

    ::std::string _VehicleModelYear;

    ::std::string _VehicleHUSwVersion;

    ::std::string _VehicleHUHwVersion;

    ::std::string _VehicleHUMake;

    ::std::string _VehicleHUModel;

    ::std::string _VehicleHUSwBuild;

    ::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration _DriverSideInfo;

    bool _isNativeNavSupported;

    ::midw_smartphoneint_fi_types::T_OEMICONDetails _OEMICONDetails;

    bool _isRotaryCtrlSupported;

    ::midw_smartphoneint_fi_types::T_e8_FidelityType _FidelityType;

    uint16 _SupportedSPITechnologiesInfo;

};

/**
 * The result message of the method "SetVehicleManufacturerInformation"
 * This interface is used by the client to update the various vehicle information.
 * Please note some information are mandatory that needs to be provided by the client.
 * Client should populate this information as soon as SPI service is available.
 */
class SetVehicleManufacturerInformationResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVehicleManufacturerInformationResult ();

    /**
     * Copy constructor
     */
    inline  SetVehicleManufacturerInformationResult (const SetVehicleManufacturerInformationResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetVehicleManufacturerInformationResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetVehicleManufacturerInformationResult();

    /**
     * Assignment operator
     */
    inline SetVehicleManufacturerInformationResult& operator = (const SetVehicleManufacturerInformationResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVehicleManufacturerInformationResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVehicleManufacturerInformationResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVehicleManufacturerInformationResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVehicleManufacturerInformationResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetVehicleManufacturerInformationResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SetEnvironmentData"
 * Scope : AAP
 * This method is used to update the Outside Temperature and the Barometric Pressure to the Phone.
 * HMI needs to update this when SPI process becomes active and whenever there is a change either in Temperature or Pressure.
 */
class SetEnvironmentDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetEnvironmentDataStart ();

    /**
     * Copy constructor
     */
    inline  SetEnvironmentDataStart (const SetEnvironmentDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetEnvironmentDataStart (double OutsideTemperature_, bool ValidTemperature_, double BarometricPressure_, bool ValidPressure_);

    /**
     * Destructor
     */
    inline virtual  ~SetEnvironmentDataStart();

    /**
     * Assignment operator
     */
    inline SetEnvironmentDataStart& operator = (const SetEnvironmentDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetEnvironmentDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetEnvironmentDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetEnvironmentDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetEnvironmentDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OutsideTemperature"

    static const int kOutsideTemperature = 0;

    /**
     * Clears the field "OutsideTemperature".
     *
     * The field will be set to its default value. The hasOutsideTemperature()
     * method will return false.
     */
    inline void clearOutsideTemperature();

    /**
     * Checks whether the field "OutsideTemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOutsideTemperature()). Otherwise it will return false.
     */
    inline bool hasOutsideTemperature () const;

    /**
     * Returns the value of the member "OutsideTemperature".
     *
     * Outside Temperature value in Degree Celcius.
     *
     * @return The value of the field "OutsideTemperature"
     */
    inline double getOutsideTemperature () const;

    /**
     * Sets the value of the member "OutsideTemperature".
     *
     * Outside Temperature value in Degree Celcius.
     *
     * @param OutsideTemperature The value which will be set
     */
    inline void setOutsideTemperature (double OutsideTemperature_);

    // API of field "ValidTemperature"

    static const int kValidTemperature = 1;

    /**
     * Clears the field "ValidTemperature".
     *
     * The field will be set to its default value. The hasValidTemperature()
     * method will return false.
     */
    inline void clearValidTemperature();

    /**
     * Checks whether the field "ValidTemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValidTemperature()). Otherwise it will return false.
     */
    inline bool hasValidTemperature () const;

    /**
     * Returns the value of the member "ValidTemperature".
     *
     * TRUE  - Valid temperature update.
     * FALSE - Invalid temperature update.
     *
     * @return The value of the field "ValidTemperature"
     */
    inline bool getValidTemperature () const;

    /**
     * Sets the value of the member "ValidTemperature".
     *
     * TRUE  - Valid temperature update.
     * FALSE - Invalid temperature update.
     *
     * @param ValidTemperature The value which will be set
     */
    inline void setValidTemperature (bool ValidTemperature_);

    // API of field "BarometricPressure"

    static const int kBarometricPressure = 2;

    /**
     * Clears the field "BarometricPressure".
     *
     * The field will be set to its default value. The hasBarometricPressure()
     * method will return false.
     */
    inline void clearBarometricPressure();

    /**
     * Checks whether the field "BarometricPressure" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBarometricPressure()). Otherwise it will return false.
     */
    inline bool hasBarometricPressure () const;

    /**
     * Returns the value of the member "BarometricPressure".
     *
     * Barometric Pressure value in kPA.
     *
     * @return The value of the field "BarometricPressure"
     */
    inline double getBarometricPressure () const;

    /**
     * Sets the value of the member "BarometricPressure".
     *
     * Barometric Pressure value in kPA.
     *
     * @param BarometricPressure The value which will be set
     */
    inline void setBarometricPressure (double BarometricPressure_);

    // API of field "ValidPressure"

    static const int kValidPressure = 3;

    /**
     * Clears the field "ValidPressure".
     *
     * The field will be set to its default value. The hasValidPressure()
     * method will return false.
     */
    inline void clearValidPressure();

    /**
     * Checks whether the field "ValidPressure" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValidPressure()). Otherwise it will return false.
     */
    inline bool hasValidPressure () const;

    /**
     * Returns the value of the member "ValidPressure".
     *
     * TRUE  - Valid pressure update.
     * FALSE - Invalid pressure update.
     *
     * @return The value of the field "ValidPressure"
     */
    inline bool getValidPressure () const;

    /**
     * Sets the value of the member "ValidPressure".
     *
     * TRUE  - Valid pressure update.
     * FALSE - Invalid pressure update.
     *
     * @param ValidPressure The value which will be set
     */
    inline void setValidPressure (bool ValidPressure_);

    static const SetEnvironmentDataStart &getDefaultInstance();

private:

    inline void set_has_OutsideTemperature ();

    inline void clear_has_OutsideTemperature ();

    inline void set_has_ValidTemperature ();

    inline void clear_has_ValidTemperature ();

    inline void set_has_BarometricPressure ();

    inline void clear_has_BarometricPressure ();

    inline void set_has_ValidPressure ();

    inline void clear_has_ValidPressure ();

    uint32 _has_bits_[ (4 + 31) / 32];

    double _OutsideTemperature;

    bool _ValidTemperature;

    double _BarometricPressure;

    bool _ValidPressure;

};

/**
 * The result message of the method "SetEnvironmentData"
 * Scope : AAP
 * This method is used to update the Outside Temperature and the Barometric Pressure to the Phone.
 * HMI needs to update this when SPI process becomes active and whenever there is a change either in Temperature or Pressure.
 */
class SetEnvironmentDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetEnvironmentDataResult ();

    /**
     * Copy constructor
     */
    inline  SetEnvironmentDataResult (const SetEnvironmentDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetEnvironmentDataResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetEnvironmentDataResult();

    /**
     * Assignment operator
     */
    inline SetEnvironmentDataResult& operator = (const SetEnvironmentDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetEnvironmentDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetEnvironmentDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetEnvironmentDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetEnvironmentDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SetEnvironmentDataResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "GetMediaObjectAlbumArt"
 * Scope : Only for CarPlay.
 * For AAP, Carlife : It is populated as part of Applicationmetadata itself
 *
 * The GetMediaObjectAlbumArt method is called to retrieve the album art
 * image, if it exists, for a particular media object. The image is returned
 * in a MIME-typed image format and size of image will be as informed in Applicationmetadata.
 */
class GetMediaObjectAlbumArtStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMediaObjectAlbumArtStart ();

    /**
     * Copy constructor
     */
    inline  GetMediaObjectAlbumArtStart (const GetMediaObjectAlbumArtStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetMediaObjectAlbumArtStart (uint32 DeviceHandle_, const ::std::string& sAlbumArt_);

    /**
     * Destructor
     */
    inline virtual  ~GetMediaObjectAlbumArtStart();

    /**
     * Assignment operator
     */
    inline GetMediaObjectAlbumArtStart& operator = (const GetMediaObjectAlbumArtStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMediaObjectAlbumArtStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMediaObjectAlbumArtStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMediaObjectAlbumArtStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMediaObjectAlbumArtStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "sAlbumArt"

    static const int kSAlbumArt = 1;

    /**
     * Clears the field "sAlbumArt".
     *
     * The field will be set to its default value. The hasSAlbumArt()
     * method will return false.
     */
    inline void clearSAlbumArt();

    /**
     * Checks whether the field "sAlbumArt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAlbumArt()). Otherwise it will return false.
     */
    inline bool hasSAlbumArt () const;

    /**
     * Returns the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @return The value of the field "sAlbumArt"
     */
    inline const ::std::string& getSAlbumArt () const;

    /**
     * Retrieves the value of the field "sAlbumArt" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAlbumArt".
     */
    inline ::std::string& getSAlbumArtMutable ();

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const ::std::string& sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* value, size_t size);

    static const GetMediaObjectAlbumArtStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_sAlbumArt ();

    inline void clear_has_sAlbumArt ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::std::string _sAlbumArt;

};

/**
 * The result message of the method "GetMediaObjectAlbumArt"
 * Scope : Only for CarPlay.
 * For AAP, Carlife : It is populated as part of Applicationmetadata itself
 *
 * The GetMediaObjectAlbumArt method is called to retrieve the album art
 * image, if it exists, for a particular media object. The image is returned
 * in a MIME-typed image format and size of image will be as informed in Applicationmetadata.
 */
class GetMediaObjectAlbumArtResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMediaObjectAlbumArtResult ();

    /**
     * Copy constructor
     */
    inline  GetMediaObjectAlbumArtResult (const GetMediaObjectAlbumArtResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetMediaObjectAlbumArtResult (const ::std::vector< uint8 >& oImageData_);

    /**
     * Destructor
     */
    inline virtual  ~GetMediaObjectAlbumArtResult();

    /**
     * Assignment operator
     */
    inline GetMediaObjectAlbumArtResult& operator = (const GetMediaObjectAlbumArtResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMediaObjectAlbumArtResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMediaObjectAlbumArtResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMediaObjectAlbumArtResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMediaObjectAlbumArtResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oImageData"

    static const int kOImageData = 0;

    /**
     * Clears the field "oImageData".
     *
     * The field will be set to its default value. The hasOImageData()
     * method will return false.
     */
    inline void clearOImageData();

    /**
     * Checks whether the field "oImageData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOImageData()). Otherwise it will return false.
     */
    inline bool hasOImageData () const;

    /**
     * Returns the value of the member "oImageData".
     *
     * Image of Album.
     *
     * @return The value of the field "oImageData"
     */
    inline const ::std::vector< uint8 >& getOImageData () const;

    /**
     * Retrieves the value of the field "oImageData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oImageData".
     */
    inline ::std::vector< uint8 >& getOImageDataMutable ();

    /**
     * Sets the value of the member "oImageData".
     *
     * Image of Album.
     *
     * @param oImageData The value which will be set
     */
    inline void setOImageData (const ::std::vector< uint8 >& oImageData_);

    static const GetMediaObjectAlbumArtResult &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_oImageData ();

    inline void clear_has_oImageData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _oImageData;

};

/**
 * The start message of the method "SetTechnologyPreference"
 * Scope: ML, Android Auto, Carlife.
 * This method is valid only if AutoSelect is enabled in SPI service (through policy), if it is not enabled this preference will not have any impact.
 * This interface can be used to set the SPI technology preference for the Mobile devices for successive connections,
 * if the device supports more than one SPI technology like Mirrorlink, Android Auto.
 * Based on this information, SPI service will decide(only if Auto select is enabled in SPI policy)to switch the device to particular technology and auto select, when the phone is connected to HMI. If preference order list is empty, than Android Auto will be first technology of preference.
 * Currently only first item in the list "PreferenceOrderList" is considered, if the selection fails than by default other technology would be preferred e.g If AAP is first preferred technology, if it fails than Mirror Link would be select.
 */
class SetTechnologyPreferenceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetTechnologyPreferenceStart ();

    /**
     * Copy constructor
     */
    inline  SetTechnologyPreferenceStart (const SetTechnologyPreferenceStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetTechnologyPreferenceStart (uint32 DeviceHandle_, uint16 NumofPreferences_, const ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >& PreferenceOrderList_, ::midw_smartphoneint_fi_types::T_e8_DeviceType DeviceType_);

    /**
     * Destructor
     */
    inline virtual  ~SetTechnologyPreferenceStart();

    /**
     * Assignment operator
     */
    inline SetTechnologyPreferenceStart& operator = (const SetTechnologyPreferenceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetTechnologyPreferenceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetTechnologyPreferenceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetTechnologyPreferenceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetTechnologyPreferenceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function sets the overall preference for new SPI devices, there will not be any technology preference changes for known devices.
     * If the value is other the 0xFFFFFFFF, then that particular device technology preference would be changed.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function sets the overall preference for new SPI devices, there will not be any technology preference changes for known devices.
     * If the value is other the 0xFFFFFFFF, then that particular device technology preference would be changed.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "NumofPreferences"

    static const int kNumofPreferences = 1;

    /**
     * Clears the field "NumofPreferences".
     *
     * The field will be set to its default value. The hasNumofPreferences()
     * method will return false.
     */
    inline void clearNumofPreferences();

    /**
     * Checks whether the field "NumofPreferences" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumofPreferences()). Otherwise it will return false.
     */
    inline bool hasNumofPreferences () const;

    /**
     * Returns the value of the member "NumofPreferences".
     *
     * Total number of preference in PreferenceOrderList. Deprecreated.
     *
     * @return The value of the field "NumofPreferences"
     */
    inline uint16 getNumofPreferences () const;

    /**
     * Sets the value of the member "NumofPreferences".
     *
     * Total number of preference in PreferenceOrderList. Deprecreated.
     *
     * @param NumofPreferences The value which will be set
     */
    inline void setNumofPreferences (uint16 NumofPreferences_);

    // API of field "PreferenceOrderList"

    static const int kPreferenceOrderList = 2;

    /**
     * Clears the field "PreferenceOrderList".
     *
     * The field will be set to its default value. The hasPreferenceOrderList()
     * method will return false.
     */
    inline void clearPreferenceOrderList();

    /**
     * Checks whether the field "PreferenceOrderList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPreferenceOrderList()). Otherwise it will return false.
     */
    inline bool hasPreferenceOrderList () const;

    /**
     * Returns the value of the member "PreferenceOrderList".
     *
     * List of the SPI technologies in the preferred order. Only Top of list would be considered.
     *
     * @return The value of the field "PreferenceOrderList"
     */
    inline const ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >& getPreferenceOrderList () const;

    /**
     * Retrieves the value of the field "PreferenceOrderList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PreferenceOrderList".
     */
    inline ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >& getPreferenceOrderListMutable ();

    /**
     * Sets the value of the member "PreferenceOrderList".
     *
     * List of the SPI technologies in the preferred order. Only Top of list would be considered.
     *
     * @param PreferenceOrderList The value which will be set
     */
    inline void setPreferenceOrderList (const ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >& PreferenceOrderList_);

    // API of field "DeviceType"

    static const int kDeviceType = 3;

    /**
     * Clears the field "DeviceType".
     *
     * The field will be set to its default value. The hasDeviceType()
     * method will return false.
     */
    inline void clearDeviceType();

    /**
     * Checks whether the field "DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceType()). Otherwise it will return false.
     */
    inline bool hasDeviceType () const;

    /**
     * Returns the value of the member "DeviceType".
     *
     * Device Type indicates the Smartphone platform(Apple, Android) type on which preference to be set
     * If the device handle is 0xFFFFFFF(overall setting), DeviceType must be  populated as AppleDevice/AndroidDevice. DeviceType unknown is ignored.
     * If the device handle is populated with a specific device ID(Per device setting), DeviceType is ignored.
     *
     * @return The value of the field "DeviceType"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceType getDeviceType () const;

    /**
     * Sets the value of the member "DeviceType".
     *
     * Device Type indicates the Smartphone platform(Apple, Android) type on which preference to be set
     * If the device handle is 0xFFFFFFF(overall setting), DeviceType must be  populated as AppleDevice/AndroidDevice. DeviceType unknown is ignored.
     * If the device handle is populated with a specific device ID(Per device setting), DeviceType is ignored.
     *
     * @param DeviceType The value which will be set
     */
    inline void setDeviceType (::midw_smartphoneint_fi_types::T_e8_DeviceType DeviceType_);

    static const SetTechnologyPreferenceStart &getDefaultInstance();

private:

    static const ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >& getT_e8_DeviceCategoryList_DefaultInstance ();

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_NumofPreferences ();

    inline void clear_has_NumofPreferences ();

    inline void set_has_PreferenceOrderList ();

    inline void clear_has_PreferenceOrderList ();

    inline void set_has_DeviceType ();

    inline void clear_has_DeviceType ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _DeviceHandle;

    uint16 _NumofPreferences;

    ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory > _PreferenceOrderList;

    ::midw_smartphoneint_fi_types::T_e8_DeviceType _DeviceType;

};

/**
 * The result message of the method "SetTechnologyPreference"
 * Scope: ML, Android Auto, Carlife.
 * This method is valid only if AutoSelect is enabled in SPI service (through policy), if it is not enabled this preference will not have any impact.
 * This interface can be used to set the SPI technology preference for the Mobile devices for successive connections,
 * if the device supports more than one SPI technology like Mirrorlink, Android Auto.
 * Based on this information, SPI service will decide(only if Auto select is enabled in SPI policy)to switch the device to particular technology and auto select, when the phone is connected to HMI. If preference order list is empty, than Android Auto will be first technology of preference.
 * Currently only first item in the list "PreferenceOrderList" is considered, if the selection fails than by default other technology would be preferred e.g If AAP is first preferred technology, if it fails than Mirror Link would be select.
 */
class SetTechnologyPreferenceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetTechnologyPreferenceResult ();

    /**
     * Copy constructor
     */
    inline  SetTechnologyPreferenceResult (const SetTechnologyPreferenceResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetTechnologyPreferenceResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetTechnologyPreferenceResult();

    /**
     * Assignment operator
     */
    inline SetTechnologyPreferenceResult& operator = (const SetTechnologyPreferenceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetTechnologyPreferenceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetTechnologyPreferenceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetTechnologyPreferenceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetTechnologyPreferenceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    static const SetTechnologyPreferenceResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

};

/**
 * The start message of the method "GetTechnologyPreference"
 * Scope: ML, Android Auto, Carlife.
 * Interface to get the SPI technology preference last set. Can be used on start up to restore settings.
 */
class GetTechnologyPreferenceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTechnologyPreferenceStart ();

    /**
     * Copy constructor
     */
    inline  GetTechnologyPreferenceStart (const GetTechnologyPreferenceStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetTechnologyPreferenceStart (uint32 DeviceHandle_, ::midw_smartphoneint_fi_types::T_e8_DeviceType DeviceType_);

    /**
     * Destructor
     */
    inline virtual  ~GetTechnologyPreferenceStart();

    /**
     * Assignment operator
     */
    inline GetTechnologyPreferenceStart& operator = (const GetTechnologyPreferenceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTechnologyPreferenceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTechnologyPreferenceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTechnologyPreferenceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTechnologyPreferenceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceHandle"

    static const int kDeviceHandle = 0;

    /**
     * Clears the field "DeviceHandle".
     *
     * The field will be set to its default value. The hasDeviceHandle()
     * method will return false.
     */
    inline void clearDeviceHandle();

    /**
     * Checks whether the field "DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasDeviceHandle () const;

    /**
     * Returns the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function gets the overall preference for new SPI devices, there will not be any technology preference changes for known devices.
     * If the value is other the 0xFFFFFFFF, then that particular device technology preference would be returned.
     *
     * @return The value of the field "DeviceHandle"
     */
    inline uint32 getDeviceHandle () const;

    /**
     * Sets the value of the member "DeviceHandle".
     *
     * Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function gets the overall preference for new SPI devices, there will not be any technology preference changes for known devices.
     * If the value is other the 0xFFFFFFFF, then that particular device technology preference would be returned.
     *
     * @param DeviceHandle The value which will be set
     */
    inline void setDeviceHandle (uint32 DeviceHandle_);

    // API of field "DeviceType"

    static const int kDeviceType = 1;

    /**
     * Clears the field "DeviceType".
     *
     * The field will be set to its default value. The hasDeviceType()
     * method will return false.
     */
    inline void clearDeviceType();

    /**
     * Checks whether the field "DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceType()). Otherwise it will return false.
     */
    inline bool hasDeviceType () const;

    /**
     * Returns the value of the member "DeviceType".
     *
     * Device Type indicates the Smartphone platform(Apple, Android) type on which preference to be returned.
     * If the device handle is 0xFFFFFFF(overall setting), DeviceType must be  populated as AppleDevice/AndroidDevice. DeviceType unknown is ignored.
     * If the device handle is populated with a specific device ID(Per device setting), DeviceType is ignored.
     *
     * @return The value of the field "DeviceType"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceType getDeviceType () const;

    /**
     * Sets the value of the member "DeviceType".
     *
     * Device Type indicates the Smartphone platform(Apple, Android) type on which preference to be returned.
     * If the device handle is 0xFFFFFFF(overall setting), DeviceType must be  populated as AppleDevice/AndroidDevice. DeviceType unknown is ignored.
     * If the device handle is populated with a specific device ID(Per device setting), DeviceType is ignored.
     *
     * @param DeviceType The value which will be set
     */
    inline void setDeviceType (::midw_smartphoneint_fi_types::T_e8_DeviceType DeviceType_);

    static const GetTechnologyPreferenceStart &getDefaultInstance();

private:

    inline void set_has_DeviceHandle ();

    inline void clear_has_DeviceHandle ();

    inline void set_has_DeviceType ();

    inline void clear_has_DeviceType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DeviceHandle;

    ::midw_smartphoneint_fi_types::T_e8_DeviceType _DeviceType;

};

/**
 * The result message of the method "GetTechnologyPreference"
 * Scope: ML, Android Auto, Carlife.
 * Interface to get the SPI technology preference last set. Can be used on start up to restore settings.
 */
class GetTechnologyPreferenceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTechnologyPreferenceResult ();

    /**
     * Copy constructor
     */
    inline  GetTechnologyPreferenceResult (const GetTechnologyPreferenceResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetTechnologyPreferenceResult (uint16 NumofPreferences_, const ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >& PreferenceOrderList_);

    /**
     * Destructor
     */
    inline virtual  ~GetTechnologyPreferenceResult();

    /**
     * Assignment operator
     */
    inline GetTechnologyPreferenceResult& operator = (const GetTechnologyPreferenceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTechnologyPreferenceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTechnologyPreferenceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTechnologyPreferenceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTechnologyPreferenceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NumofPreferences"

    static const int kNumofPreferences = 0;

    /**
     * Clears the field "NumofPreferences".
     *
     * The field will be set to its default value. The hasNumofPreferences()
     * method will return false.
     */
    inline void clearNumofPreferences();

    /**
     * Checks whether the field "NumofPreferences" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumofPreferences()). Otherwise it will return false.
     */
    inline bool hasNumofPreferences () const;

    /**
     * Returns the value of the member "NumofPreferences".
     *
     * Total number of preference in PreferenceOrderList. Deprecreated.
     *
     * @return The value of the field "NumofPreferences"
     */
    inline uint16 getNumofPreferences () const;

    /**
     * Sets the value of the member "NumofPreferences".
     *
     * Total number of preference in PreferenceOrderList. Deprecreated.
     *
     * @param NumofPreferences The value which will be set
     */
    inline void setNumofPreferences (uint16 NumofPreferences_);

    // API of field "PreferenceOrderList"

    static const int kPreferenceOrderList = 1;

    /**
     * Clears the field "PreferenceOrderList".
     *
     * The field will be set to its default value. The hasPreferenceOrderList()
     * method will return false.
     */
    inline void clearPreferenceOrderList();

    /**
     * Checks whether the field "PreferenceOrderList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPreferenceOrderList()). Otherwise it will return false.
     */
    inline bool hasPreferenceOrderList () const;

    /**
     * Returns the value of the member "PreferenceOrderList".
     *
     * Ordered list of the SPI technologies in the preferred order. if preference is only for a single technology then
     * the list can contain single entry for that particular SPI technology.
     *
     * @return The value of the field "PreferenceOrderList"
     */
    inline const ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >& getPreferenceOrderList () const;

    /**
     * Retrieves the value of the field "PreferenceOrderList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PreferenceOrderList".
     */
    inline ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >& getPreferenceOrderListMutable ();

    /**
     * Sets the value of the member "PreferenceOrderList".
     *
     * Ordered list of the SPI technologies in the preferred order. if preference is only for a single technology then
     * the list can contain single entry for that particular SPI technology.
     *
     * @param PreferenceOrderList The value which will be set
     */
    inline void setPreferenceOrderList (const ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >& PreferenceOrderList_);

    static const GetTechnologyPreferenceResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >& getT_e8_DeviceCategoryList_DefaultInstance ();

    inline void set_has_NumofPreferences ();

    inline void clear_has_NumofPreferences ();

    inline void set_has_PreferenceOrderList ();

    inline void clear_has_PreferenceOrderList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _NumofPreferences;

    ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory > _PreferenceOrderList;

};

/**
 * The start message of the method "SetDeviceSelectionMode"
 * Interface to set the Device selection mode. Can be used to switch device between automatic and manual modes.
 * The selection mode will be applicable on successive device connections.
 * This value will be persistently stored by service.
 */
class SetDeviceSelectionModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDeviceSelectionModeStart ();

    /**
     * Copy constructor
     */
    inline  SetDeviceSelectionModeStart (const SetDeviceSelectionModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetDeviceSelectionModeStart (::midw_smartphoneint_fi_types::T_e8_DeviceSelectionMode DeviceSelectionMode_);

    /**
     * Destructor
     */
    inline virtual  ~SetDeviceSelectionModeStart();

    /**
     * Assignment operator
     */
    inline SetDeviceSelectionModeStart& operator = (const SetDeviceSelectionModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDeviceSelectionModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDeviceSelectionModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDeviceSelectionModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDeviceSelectionModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceSelectionMode"

    static const int kDeviceSelectionMode = 0;

    /**
     * Clears the field "DeviceSelectionMode".
     *
     * The field will be set to its default value. The hasDeviceSelectionMode()
     * method will return false.
     */
    inline void clearDeviceSelectionMode();

    /**
     * Checks whether the field "DeviceSelectionMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceSelectionMode()). Otherwise it will return false.
     */
    inline bool hasDeviceSelectionMode () const;

    /**
     * Returns the value of the member "DeviceSelectionMode".
     *
     * Determines the selection mode to be set
     *
     * @return The value of the field "DeviceSelectionMode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceSelectionMode getDeviceSelectionMode () const;

    /**
     * Sets the value of the member "DeviceSelectionMode".
     *
     * Determines the selection mode to be set
     *
     * @param DeviceSelectionMode The value which will be set
     */
    inline void setDeviceSelectionMode (::midw_smartphoneint_fi_types::T_e8_DeviceSelectionMode DeviceSelectionMode_);

    static const SetDeviceSelectionModeStart &getDefaultInstance();

private:

    inline void set_has_DeviceSelectionMode ();

    inline void clear_has_DeviceSelectionMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_DeviceSelectionMode _DeviceSelectionMode;

};

/**
 * The result message of the method "SetDeviceSelectionMode"
 * Interface to set the Device selection mode. Can be used to switch device between automatic and manual modes.
 * The selection mode will be applicable on successive device connections.
 * This value will be persistently stored by service.
 */
class SetDeviceSelectionModeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDeviceSelectionModeResult ();

    /**
     * Copy constructor
     */
    inline  SetDeviceSelectionModeResult (const SetDeviceSelectionModeResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetDeviceSelectionModeResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetDeviceSelectionModeResult();

    /**
     * Assignment operator
     */
    inline SetDeviceSelectionModeResult& operator = (const SetDeviceSelectionModeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDeviceSelectionModeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDeviceSelectionModeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDeviceSelectionModeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDeviceSelectionModeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    static const SetDeviceSelectionModeResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

};

/**
 * The result message of the method "GetSPIVersionInfo"
 * Interface to get the SPI Version Info.
 */
class GetSPIVersionInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetSPIVersionInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetSPIVersionInfoResult (const GetSPIVersionInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetSPIVersionInfoResult (const ::std::string& SPIVersion_);

    /**
     * Destructor
     */
    inline virtual  ~GetSPIVersionInfoResult();

    /**
     * Assignment operator
     */
    inline GetSPIVersionInfoResult& operator = (const GetSPIVersionInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSPIVersionInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSPIVersionInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSPIVersionInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSPIVersionInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SPIVersion"

    static const int kSPIVersion = 0;

    /**
     * Clears the field "SPIVersion".
     *
     * The field will be set to its default value. The hasSPIVersion()
     * method will return false.
     */
    inline void clearSPIVersion();

    /**
     * Checks whether the field "SPIVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPIVersion()). Otherwise it will return false.
     */
    inline bool hasSPIVersion () const;

    /**
     * Returns the value of the member "SPIVersion".
     *
     * Provides SPI Version from the operation.
     *
     * @return The value of the field "SPIVersion"
     */
    inline const ::std::string& getSPIVersion () const;

    /**
     * Retrieves the value of the field "SPIVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SPIVersion".
     */
    inline ::std::string& getSPIVersionMutable ();

    /**
     * Sets the value of the member "SPIVersion".
     *
     * Provides SPI Version from the operation.
     *
     * @param SPIVersion The value which will be set
     */
    inline void setSPIVersion (const ::std::string& SPIVersion_);

    /**
     * Sets the value of the member "SPIVersion".
     *
     * Provides SPI Version from the operation.
     *
     * @param SPIVersion The value which will be set
     */
    inline void setSPIVersion (const char* SPIVersion_);

    /**
     * Sets the value of the member "SPIVersion".
     *
     * Provides SPI Version from the operation.
     *
     * @param SPIVersion The value which will be set
     */
    inline void setSPIVersion (const char* value, size_t size);

    static const GetSPIVersionInfoResult &getDefaultInstance();

private:

    inline void set_has_SPIVersion ();

    inline void clear_has_SPIVersion ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _SPIVersion;

};

/**
 * The start message of the method "InitiateWirelessDiscovery"
 * Scope: Carplay over wireless for now.
 * Interface to initiate SPI wireless device discovery.
 * This is used to estbalish wireless session, if a valid device is available.
 */
class InitiateWirelessDiscoveryStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InitiateWirelessDiscoveryStart ();

    /**
     * Copy constructor
     */
    inline  InitiateWirelessDiscoveryStart (const InitiateWirelessDiscoveryStart &rhs);

    /**
     * All fields constructor
     */
    inline  InitiateWirelessDiscoveryStart (const ::std::string& BTMACAddress_, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory Technology_, bool isKnownDevice_);

    /**
     * Destructor
     */
    inline virtual  ~InitiateWirelessDiscoveryStart();

    /**
     * Assignment operator
     */
    inline InitiateWirelessDiscoveryStart& operator = (const InitiateWirelessDiscoveryStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InitiateWirelessDiscoveryStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InitiateWirelessDiscoveryStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InitiateWirelessDiscoveryStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InitiateWirelessDiscoveryStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BTMACAddress"

    static const int kBTMACAddress = 0;

    /**
     * Clears the field "BTMACAddress".
     *
     * The field will be set to its default value. The hasBTMACAddress()
     * method will return false.
     */
    inline void clearBTMACAddress();

    /**
     * Checks whether the field "BTMACAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTMACAddress()). Otherwise it will return false.
     */
    inline bool hasBTMACAddress () const;

    /**
     * Returns the value of the member "BTMACAddress".
     *
     * Unique ID of the device for which Bluetooth discovery should be started.
     *
     * @return The value of the field "BTMACAddress"
     */
    inline const ::std::string& getBTMACAddress () const;

    /**
     * Retrieves the value of the field "BTMACAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BTMACAddress".
     */
    inline ::std::string& getBTMACAddressMutable ();

    /**
     * Sets the value of the member "BTMACAddress".
     *
     * Unique ID of the device for which Bluetooth discovery should be started.
     *
     * @param BTMACAddress The value which will be set
     */
    inline void setBTMACAddress (const ::std::string& BTMACAddress_);

    /**
     * Sets the value of the member "BTMACAddress".
     *
     * Unique ID of the device for which Bluetooth discovery should be started.
     *
     * @param BTMACAddress The value which will be set
     */
    inline void setBTMACAddress (const char* BTMACAddress_);

    /**
     * Sets the value of the member "BTMACAddress".
     *
     * Unique ID of the device for which Bluetooth discovery should be started.
     *
     * @param BTMACAddress The value which will be set
     */
    inline void setBTMACAddress (const char* value, size_t size);

    // API of field "Technology"

    static const int kTechnology = 1;

    /**
     * Clears the field "Technology".
     *
     * The field will be set to its default value. The hasTechnology()
     * method will return false.
     */
    inline void clearTechnology();

    /**
     * Checks whether the field "Technology" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTechnology()). Otherwise it will return false.
     */
    inline bool hasTechnology () const;

    /**
     * Returns the value of the member "Technology".
     *
     * Determines the SPI Technology for which wireless discovey to be initiated.
     *
     * @return The value of the field "Technology"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_DeviceCategory getTechnology () const;

    /**
     * Sets the value of the member "Technology".
     *
     * Determines the SPI Technology for which wireless discovey to be initiated.
     *
     * @param Technology The value which will be set
     */
    inline void setTechnology (::midw_smartphoneint_fi_types::T_e8_DeviceCategory Technology_);

    // API of field "isKnownDevice"

    static const int kIsKnownDevice = 2;

    /**
     * Clears the field "isKnownDevice".
     *
     * The field will be set to its default value. The hasIsKnownDevice()
     * method will return false.
     */
    inline void clearIsKnownDevice();

    /**
     * Checks whether the field "isKnownDevice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsKnownDevice()). Otherwise it will return false.
     */
    inline bool hasIsKnownDevice () const;

    /**
     * Returns the value of the member "isKnownDevice".
     *
     * Determines whether this request is for fresh device or known device.
     * TRUE - for known device.
     * FALSE - for fresh device.
     *
     * @return The value of the field "isKnownDevice"
     */
    inline bool getIsKnownDevice () const;

    /**
     * Sets the value of the member "isKnownDevice".
     *
     * Determines whether this request is for fresh device or known device.
     * TRUE - for known device.
     * FALSE - for fresh device.
     *
     * @param isKnownDevice The value which will be set
     */
    inline void setIsKnownDevice (bool isKnownDevice_);

    static const InitiateWirelessDiscoveryStart &getDefaultInstance();

private:

    inline void set_has_BTMACAddress ();

    inline void clear_has_BTMACAddress ();

    inline void set_has_Technology ();

    inline void clear_has_Technology ();

    inline void set_has_isKnownDevice ();

    inline void clear_has_isKnownDevice ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _BTMACAddress;

    ::midw_smartphoneint_fi_types::T_e8_DeviceCategory _Technology;

    bool _isKnownDevice;

};

/**
 * The result message of the method "InitiateWirelessDiscovery"
 * Scope: Carplay over wireless for now.
 * Interface to initiate SPI wireless device discovery.
 * This is used to estbalish wireless session, if a valid device is available.
 */
class InitiateWirelessDiscoveryResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InitiateWirelessDiscoveryResult ();

    /**
     * Copy constructor
     */
    inline  InitiateWirelessDiscoveryResult (const InitiateWirelessDiscoveryResult &rhs);

    /**
     * All fields constructor
     */
    inline  InitiateWirelessDiscoveryResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    /**
     * Destructor
     */
    inline virtual  ~InitiateWirelessDiscoveryResult();

    /**
     * Assignment operator
     */
    inline InitiateWirelessDiscoveryResult& operator = (const InitiateWirelessDiscoveryResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InitiateWirelessDiscoveryResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InitiateWirelessDiscoveryResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InitiateWirelessDiscoveryResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InitiateWirelessDiscoveryResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result of the operation
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result of the operation
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    static const InitiateWirelessDiscoveryResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

};

/**
 * The start message of the method "DeleteDevice"
 * Interface to delete device permanently from SPI device list
 */
class DeleteDeviceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteDeviceStart ();

    /**
     * Copy constructor
     */
    inline  DeleteDeviceStart (const DeleteDeviceStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteDeviceStart (const ::std::vector< uint32 >& DeviceList_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteDeviceStart();

    /**
     * Assignment operator
     */
    inline DeleteDeviceStart& operator = (const DeleteDeviceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteDeviceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteDeviceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteDeviceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteDeviceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceList"

    static const int kDeviceList = 0;

    /**
     * Clears the field "DeviceList".
     *
     * The field will be set to its default value. The hasDeviceList()
     * method will return false.
     */
    inline void clearDeviceList();

    /**
     * Checks whether the field "DeviceList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceList()). Otherwise it will return false.
     */
    inline bool hasDeviceList () const;

    /**
     * Returns the value of the member "DeviceList".
     *
     * List of device handles to be deleted.
     *
     * @return The value of the field "DeviceList"
     */
    inline const ::std::vector< uint32 >& getDeviceList () const;

    /**
     * Retrieves the value of the field "DeviceList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceList".
     */
    inline ::std::vector< uint32 >& getDeviceListMutable ();

    /**
     * Sets the value of the member "DeviceList".
     *
     * List of device handles to be deleted.
     *
     * @param DeviceList The value which will be set
     */
    inline void setDeviceList (const ::std::vector< uint32 >& DeviceList_);

    static const DeleteDeviceStart &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_DeviceList ();

    inline void clear_has_DeviceList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint32 > _DeviceList;

};

/**
 * The result message of the method "DeleteDevice"
 * Interface to delete device permanently from SPI device list
 */
class DeleteDeviceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteDeviceResult ();

    /**
     * Copy constructor
     */
    inline  DeleteDeviceResult (const DeleteDeviceResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteDeviceResult (const ::std::vector< uint32 >& DeviceList_, ::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteDeviceResult();

    /**
     * Assignment operator
     */
    inline DeleteDeviceResult& operator = (const DeleteDeviceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteDeviceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteDeviceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteDeviceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteDeviceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceList"

    static const int kDeviceList = 0;

    /**
     * Clears the field "DeviceList".
     *
     * The field will be set to its default value. The hasDeviceList()
     * method will return false.
     */
    inline void clearDeviceList();

    /**
     * Checks whether the field "DeviceList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceList()). Otherwise it will return false.
     */
    inline bool hasDeviceList () const;

    /**
     * Returns the value of the member "DeviceList".
     *
     * List of devicehandles for which deletion failed. List will be empty if all devices were successfully deleted
     * Deletion can fail for devices which are selected or in the process of selection/deselection
     *
     * @return The value of the field "DeviceList"
     */
    inline const ::std::vector< uint32 >& getDeviceList () const;

    /**
     * Retrieves the value of the field "DeviceList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceList".
     */
    inline ::std::vector< uint32 >& getDeviceListMutable ();

    /**
     * Sets the value of the member "DeviceList".
     *
     * List of devicehandles for which deletion failed. List will be empty if all devices were successfully deleted
     * Deletion can fail for devices which are selected or in the process of selection/deselection
     *
     * @param DeviceList The value which will be set
     */
    inline void setDeviceList (const ::std::vector< uint32 >& DeviceList_);

    // API of field "ResponseCode"

    static const int kResponseCode = 1;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result of the operation. SUCCESS if all devices were sucessfully deleted.
     * else DeviceList will contain the list of devices that were not deleted
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result of the operation. SUCCESS if all devices were sucessfully deleted.
     * else DeviceList will contain the list of devices that were not deleted
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    static const DeleteDeviceResult &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_DeviceList ();

    inline void clear_has_DeviceList ();

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< uint32 > _DeviceList;

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

};

/**
 * The start message of the method "GetWiFiCredentials"
 * Interface to get the WiFi Credentials for Wireless.
 */
class GetWiFiCredentialsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetWiFiCredentialsStart ();

    /**
     * Copy constructor
     */
    inline  GetWiFiCredentialsStart (const GetWiFiCredentialsStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetWiFiCredentialsStart (const ::std::string& BTMACAddress_);

    /**
     * Destructor
     */
    inline virtual  ~GetWiFiCredentialsStart();

    /**
     * Assignment operator
     */
    inline GetWiFiCredentialsStart& operator = (const GetWiFiCredentialsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWiFiCredentialsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWiFiCredentialsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWiFiCredentialsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWiFiCredentialsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BTMACAddress"

    static const int kBTMACAddress = 0;

    /**
     * Clears the field "BTMACAddress".
     *
     * The field will be set to its default value. The hasBTMACAddress()
     * method will return false.
     */
    inline void clearBTMACAddress();

    /**
     * Checks whether the field "BTMACAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTMACAddress()). Otherwise it will return false.
     */
    inline bool hasBTMACAddress () const;

    /**
     * Returns the value of the member "BTMACAddress".
     *
     * BT MAC Address of the device requested for Wi-Fi credentials.
     *
     * @return The value of the field "BTMACAddress"
     */
    inline const ::std::string& getBTMACAddress () const;

    /**
     * Retrieves the value of the field "BTMACAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BTMACAddress".
     */
    inline ::std::string& getBTMACAddressMutable ();

    /**
     * Sets the value of the member "BTMACAddress".
     *
     * BT MAC Address of the device requested for Wi-Fi credentials.
     *
     * @param BTMACAddress The value which will be set
     */
    inline void setBTMACAddress (const ::std::string& BTMACAddress_);

    /**
     * Sets the value of the member "BTMACAddress".
     *
     * BT MAC Address of the device requested for Wi-Fi credentials.
     *
     * @param BTMACAddress The value which will be set
     */
    inline void setBTMACAddress (const char* BTMACAddress_);

    /**
     * Sets the value of the member "BTMACAddress".
     *
     * BT MAC Address of the device requested for Wi-Fi credentials.
     *
     * @param BTMACAddress The value which will be set
     */
    inline void setBTMACAddress (const char* value, size_t size);

    static const GetWiFiCredentialsStart &getDefaultInstance();

private:

    inline void set_has_BTMACAddress ();

    inline void clear_has_BTMACAddress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _BTMACAddress;

};

/**
 * The result message of the method "GetWiFiCredentials"
 * Interface to get the WiFi Credentials for Wireless.
 */
class GetWiFiCredentialsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetWiFiCredentialsResult ();

    /**
     * Copy constructor
     */
    inline  GetWiFiCredentialsResult (const GetWiFiCredentialsResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetWiFiCredentialsResult (const ::std::string& BTMACAddress_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_, const ::midw_smartphoneint_fi_types::T_WiFiAPCredentials& AccessoryWiFiAPCredentials_);

    /**
     * Destructor
     */
    inline virtual  ~GetWiFiCredentialsResult();

    /**
     * Assignment operator
     */
    inline GetWiFiCredentialsResult& operator = (const GetWiFiCredentialsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWiFiCredentialsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWiFiCredentialsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWiFiCredentialsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWiFiCredentialsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BTMACAddress"

    static const int kBTMACAddress = 0;

    /**
     * Clears the field "BTMACAddress".
     *
     * The field will be set to its default value. The hasBTMACAddress()
     * method will return false.
     */
    inline void clearBTMACAddress();

    /**
     * Checks whether the field "BTMACAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTMACAddress()). Otherwise it will return false.
     */
    inline bool hasBTMACAddress () const;

    /**
     * Returns the value of the member "BTMACAddress".
     *
     * BT MAC Address of the device requested for Wi-Fi credentials.
     *
     * @return The value of the field "BTMACAddress"
     */
    inline const ::std::string& getBTMACAddress () const;

    /**
     * Retrieves the value of the field "BTMACAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BTMACAddress".
     */
    inline ::std::string& getBTMACAddressMutable ();

    /**
     * Sets the value of the member "BTMACAddress".
     *
     * BT MAC Address of the device requested for Wi-Fi credentials.
     *
     * @param BTMACAddress The value which will be set
     */
    inline void setBTMACAddress (const ::std::string& BTMACAddress_);

    /**
     * Sets the value of the member "BTMACAddress".
     *
     * BT MAC Address of the device requested for Wi-Fi credentials.
     *
     * @param BTMACAddress The value which will be set
     */
    inline void setBTMACAddress (const char* BTMACAddress_);

    /**
     * Sets the value of the member "BTMACAddress".
     *
     * BT MAC Address of the device requested for Wi-Fi credentials.
     *
     * @param BTMACAddress The value which will be set
     */
    inline void setBTMACAddress (const char* value, size_t size);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code. It set to NO_ERROR for successful operation.
     * In case user rejects, it shall be set to OPERATION_REJECTED.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code. It set to NO_ERROR for successful operation.
     * In case user rejects, it shall be set to OPERATION_REJECTED.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    // API of field "AccessoryWiFiAPCredentials"

    static const int kAccessoryWiFiAPCredentials = 2;

    /**
     * Clears the field "AccessoryWiFiAPCredentials".
     *
     * The field will be set to its default value. The hasAccessoryWiFiAPCredentials()
     * method will return false.
     */
    inline void clearAccessoryWiFiAPCredentials();

    /**
     * Checks whether the field "AccessoryWiFiAPCredentials" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccessoryWiFiAPCredentials()). Otherwise it will return false.
     */
    inline bool hasAccessoryWiFiAPCredentials () const;

    /**
     * Returns the value of the member "AccessoryWiFiAPCredentials".
     *
     * Active SPI Wi-Fi Access Point credentials of Accessory.
     * Empty credentials will be provided, in case if User doesn't allow to provide credentials or
     * SPI Technology access point is not available.
     *
     * @return The value of the field "AccessoryWiFiAPCredentials"
     */
    inline const ::midw_smartphoneint_fi_types::T_WiFiAPCredentials& getAccessoryWiFiAPCredentials () const;

    /**
     * Retrieves the value of the field "AccessoryWiFiAPCredentials" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AccessoryWiFiAPCredentials".
     */
    inline ::midw_smartphoneint_fi_types::T_WiFiAPCredentials& getAccessoryWiFiAPCredentialsMutable ();

    /**
     * Sets the value of the member "AccessoryWiFiAPCredentials".
     *
     * Active SPI Wi-Fi Access Point credentials of Accessory.
     * Empty credentials will be provided, in case if User doesn't allow to provide credentials or
     * SPI Technology access point is not available.
     *
     * @param AccessoryWiFiAPCredentials The value which will be set
     */
    inline void setAccessoryWiFiAPCredentials (const ::midw_smartphoneint_fi_types::T_WiFiAPCredentials& AccessoryWiFiAPCredentials_);

    static const GetWiFiCredentialsResult &getDefaultInstance();

private:

    inline void set_has_BTMACAddress ();

    inline void clear_has_BTMACAddress ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    inline void set_has_AccessoryWiFiAPCredentials ();

    inline void clear_has_AccessoryWiFiAPCredentials ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _BTMACAddress;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

    ::midw_smartphoneint_fi_types::T_WiFiAPCredentials _AccessoryWiFiAPCredentials;

};

/**
 * The start message of the method "SetETCStatus"
 * Scope: CarPlay and AAP
 * Interface to set the Electronic Toll Collection (ETC) enabling status.
 * If the ETC feature is enabled (in the head unit restrictions), this method can be used to enable or disable the status while CarPlay session is active.
 */
class SetETCStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetETCStatusStart ();

    /**
     * Copy constructor
     */
    inline  SetETCStatusStart (const SetETCStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetETCStatusStart (bool ETCStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SetETCStatusStart();

    /**
     * Assignment operator
     */
    inline SetETCStatusStart& operator = (const SetETCStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetETCStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetETCStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetETCStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetETCStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ETCStatus"

    static const int kETCStatus = 0;

    /**
     * Clears the field "ETCStatus".
     *
     * The field will be set to its default value. The hasETCStatus()
     * method will return false.
     */
    inline void clearETCStatus();

    /**
     * Checks whether the field "ETCStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setETCStatus()). Otherwise it will return false.
     */
    inline bool hasETCStatus () const;

    /**
     * Returns the value of the member "ETCStatus".
     *
     * Identifies whether to enable/disable the ETC (Electronic Toll Collection) icon.
     * True: Enable ETC. False: Disable ETC.
     *
     * @return The value of the field "ETCStatus"
     */
    inline bool getETCStatus () const;

    /**
     * Sets the value of the member "ETCStatus".
     *
     * Identifies whether to enable/disable the ETC (Electronic Toll Collection) icon.
     * True: Enable ETC. False: Disable ETC.
     *
     * @param ETCStatus The value which will be set
     */
    inline void setETCStatus (bool ETCStatus_);

    static const SetETCStatusStart &getDefaultInstance();

private:

    inline void set_has_ETCStatus ();

    inline void clear_has_ETCStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _ETCStatus;

};

/**
 * The result message of the method "SetETCStatus"
 * Scope: CarPlay and AAP
 * Interface to set the Electronic Toll Collection (ETC) enabling status.
 * If the ETC feature is enabled (in the head unit restrictions), this method can be used to enable or disable the status while CarPlay session is active.
 */
class SetETCStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetETCStatusResult ();

    /**
     * Copy constructor
     */
    inline  SetETCStatusResult (const SetETCStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetETCStatusResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    /**
     * Destructor
     */
    inline virtual  ~SetETCStatusResult();

    /**
     * Assignment operator
     */
    inline SetETCStatusResult& operator = (const SetETCStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetETCStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetETCStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetETCStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetETCStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides the result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides the result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    static const SetETCStatusResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

};

/**
 * The start message of the method "DistanceToEmptyTank"
 * Scope: MirrorLink.
 * DistanceToEmptyTank Interface determines the distance that can be travelled by the vehicle with
 * the amount of fuel left in the vehicle. Suppose a vehicle travels 60km with one litre of fuel present
 * and now the vehicle is left with 3 litres of fuel in the tank then the DistanceToEmptyTank  is 180km.
 * This interface is used by the client to update the distance to empty tank that is derived from vehicle CAN interface.
 * This data needs to be sent only when device is selected and DistanceToEmptyTank data is changed, SPI will take care of
 * sending the data at the required rate to the devices.
 * Valid Data Range(DistanceToEmptyTank) - 0 to 0x7FFFFFFF i.e;2,147,483,647 km
 * If DistanceToEmptyTank = 0xFFFFFFFF, then it is invalid data
 */
class DistanceToEmptyTankStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DistanceToEmptyTankStart ();

    /**
     * Copy constructor
     */
    inline  DistanceToEmptyTankStart (const DistanceToEmptyTankStart &rhs);

    /**
     * All fields constructor
     */
    inline  DistanceToEmptyTankStart (int32 DistanceToEmptyTank_);

    /**
     * Destructor
     */
    inline virtual  ~DistanceToEmptyTankStart();

    /**
     * Assignment operator
     */
    inline DistanceToEmptyTankStart& operator = (const DistanceToEmptyTankStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DistanceToEmptyTankStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DistanceToEmptyTankStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DistanceToEmptyTankStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DistanceToEmptyTankStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DistanceToEmptyTank"

    static const int kDistanceToEmptyTank = 0;

    /**
     * Clears the field "DistanceToEmptyTank".
     *
     * The field will be set to its default value. The hasDistanceToEmptyTank()
     * method will return false.
     */
    inline void clearDistanceToEmptyTank();

    /**
     * Checks whether the field "DistanceToEmptyTank" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceToEmptyTank()). Otherwise it will return false.
     */
    inline bool hasDistanceToEmptyTank () const;

    /**
     * Returns the value of the member "DistanceToEmptyTank".
     *
     * DistanceToEmptyTank in km.
     *
     * @return The value of the field "DistanceToEmptyTank"
     */
    inline int32 getDistanceToEmptyTank () const;

    /**
     * Sets the value of the member "DistanceToEmptyTank".
     *
     * DistanceToEmptyTank in km.
     *
     * @param DistanceToEmptyTank The value which will be set
     */
    inline void setDistanceToEmptyTank (int32 DistanceToEmptyTank_);

    static const DistanceToEmptyTankStart &getDefaultInstance();

private:

    inline void set_has_DistanceToEmptyTank ();

    inline void clear_has_DistanceToEmptyTank ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _DistanceToEmptyTank;

};

/**
 * The result message of the method "DistanceToEmptyTank"
 * Scope: MirrorLink.
 * DistanceToEmptyTank Interface determines the distance that can be travelled by the vehicle with
 * the amount of fuel left in the vehicle. Suppose a vehicle travels 60km with one litre of fuel present
 * and now the vehicle is left with 3 litres of fuel in the tank then the DistanceToEmptyTank  is 180km.
 * This interface is used by the client to update the distance to empty tank that is derived from vehicle CAN interface.
 * This data needs to be sent only when device is selected and DistanceToEmptyTank data is changed, SPI will take care of
 * sending the data at the required rate to the devices.
 * Valid Data Range(DistanceToEmptyTank) - 0 to 0x7FFFFFFF i.e;2,147,483,647 km
 * If DistanceToEmptyTank = 0xFFFFFFFF, then it is invalid data
 */
class DistanceToEmptyTankResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DistanceToEmptyTankResult ();

    /**
     * Copy constructor
     */
    inline  DistanceToEmptyTankResult (const DistanceToEmptyTankResult &rhs);

    /**
     * All fields constructor
     */
    inline  DistanceToEmptyTankResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~DistanceToEmptyTankResult();

    /**
     * Assignment operator
     */
    inline DistanceToEmptyTankResult& operator = (const DistanceToEmptyTankResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DistanceToEmptyTankResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DistanceToEmptyTankResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DistanceToEmptyTankResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DistanceToEmptyTankResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation. If the response code is FAILURE, reason can be got from parameter "ErrorCode"
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const DistanceToEmptyTankResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SendLanguageSetting"
 * Scope: MirrorLink.
 * Interface to send the system language information.
 */
class SendLanguageSettingStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendLanguageSettingStart ();

    /**
     * Copy constructor
     */
    inline  SendLanguageSettingStart (const SendLanguageSettingStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendLanguageSettingStart (::midw_smartphoneint_fi_types::T_e32_Language LanguageSetting_);

    /**
     * Destructor
     */
    inline virtual  ~SendLanguageSettingStart();

    /**
     * Assignment operator
     */
    inline SendLanguageSettingStart& operator = (const SendLanguageSettingStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendLanguageSettingStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendLanguageSettingStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendLanguageSettingStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendLanguageSettingStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LanguageSetting"

    static const int kLanguageSetting = 0;

    /**
     * Clears the field "LanguageSetting".
     *
     * The field will be set to its default value. The hasLanguageSetting()
     * method will return false.
     */
    inline void clearLanguageSetting();

    /**
     * Checks whether the field "LanguageSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageSetting()). Otherwise it will return false.
     */
    inline bool hasLanguageSetting () const;

    /**
     * Returns the value of the member "LanguageSetting".
     *
     * LanguageSetting Value.
     *
     * @return The value of the field "LanguageSetting"
     */
    inline ::midw_smartphoneint_fi_types::T_e32_Language getLanguageSetting () const;

    /**
     * Sets the value of the member "LanguageSetting".
     *
     * LanguageSetting Value.
     *
     * @param LanguageSetting The value which will be set
     */
    inline void setLanguageSetting (::midw_smartphoneint_fi_types::T_e32_Language LanguageSetting_);

    static const SendLanguageSettingStart &getDefaultInstance();

private:

    inline void set_has_LanguageSetting ();

    inline void clear_has_LanguageSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e32_Language _LanguageSetting;

};

/**
 * The result message of the method "SendLanguageSetting"
 * Scope: MirrorLink.
 * Interface to send the system language information.
 */
class SendLanguageSettingResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendLanguageSettingResult ();

    /**
     * Copy constructor
     */
    inline  SendLanguageSettingResult (const SendLanguageSettingResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendLanguageSettingResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SendLanguageSettingResult();

    /**
     * Assignment operator
     */
    inline SendLanguageSettingResult& operator = (const SendLanguageSettingResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendLanguageSettingResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendLanguageSettingResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendLanguageSettingResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendLanguageSettingResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SendLanguageSettingResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SendVehiclePowerModeState"
 * Scope: MirrorLink.
 * VehiclePowerMode Interface determines the position of the ignition switch. It represents vehicle power mode state.
 */
class SendVehiclePowerModeStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendVehiclePowerModeStateStart ();

    /**
     * Copy constructor
     */
    inline  SendVehiclePowerModeStateStart (const SendVehiclePowerModeStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendVehiclePowerModeStateStart (::midw_smartphoneint_fi_types::T_e8_VehiclePowerModeState VehiclePowerModeState_);

    /**
     * Destructor
     */
    inline virtual  ~SendVehiclePowerModeStateStart();

    /**
     * Assignment operator
     */
    inline SendVehiclePowerModeStateStart& operator = (const SendVehiclePowerModeStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendVehiclePowerModeStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendVehiclePowerModeStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendVehiclePowerModeStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendVehiclePowerModeStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VehiclePowerModeState"

    static const int kVehiclePowerModeState = 0;

    /**
     * Clears the field "VehiclePowerModeState".
     *
     * The field will be set to its default value. The hasVehiclePowerModeState()
     * method will return false.
     */
    inline void clearVehiclePowerModeState();

    /**
     * Checks whether the field "VehiclePowerModeState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehiclePowerModeState()). Otherwise it will return false.
     */
    inline bool hasVehiclePowerModeState () const;

    /**
     * Returns the value of the member "VehiclePowerModeState".
     *
     * Provides VehiclePowerMode State Information.
     *
     * @return The value of the field "VehiclePowerModeState"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_VehiclePowerModeState getVehiclePowerModeState () const;

    /**
     * Sets the value of the member "VehiclePowerModeState".
     *
     * Provides VehiclePowerMode State Information.
     *
     * @param VehiclePowerModeState The value which will be set
     */
    inline void setVehiclePowerModeState (::midw_smartphoneint_fi_types::T_e8_VehiclePowerModeState VehiclePowerModeState_);

    static const SendVehiclePowerModeStateStart &getDefaultInstance();

private:

    inline void set_has_VehiclePowerModeState ();

    inline void clear_has_VehiclePowerModeState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_VehiclePowerModeState _VehiclePowerModeState;

};

/**
 * The result message of the method "SendVehiclePowerModeState"
 * Scope: MirrorLink.
 * VehiclePowerMode Interface determines the position of the ignition switch. It represents vehicle power mode state.
 */
class SendVehiclePowerModeStateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendVehiclePowerModeStateResult ();

    /**
     * Copy constructor
     */
    inline  SendVehiclePowerModeStateResult (const SendVehiclePowerModeStateResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendVehiclePowerModeStateResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SendVehiclePowerModeStateResult();

    /**
     * Assignment operator
     */
    inline SendVehiclePowerModeStateResult& operator = (const SendVehiclePowerModeStateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendVehiclePowerModeStateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendVehiclePowerModeStateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendVehiclePowerModeStateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendVehiclePowerModeStateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ErrorType getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Provides the Error Code in case ResponseCode==FAILURE. Set to NO_ERROR for successful operation.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    static const SendVehiclePowerModeStateResult &getDefaultInstance();

private:

    inline void set_has_ResponseCode ();

    inline void clear_has_ResponseCode ();

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_e8_ResponseCode _ResponseCode;

    ::midw_smartphoneint_fi_types::T_e8_ErrorType _ErrorCode;

};

/**
 * The start message of the method "SendAmbientColour"
 * Scope: MirrorLink.
 * It is used to send ambient colour details of the HU like Red, Green, Blue, Alpha etc. for a Mirror Link device.
 */
class SendAmbientColourStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendAmbientColourStart ();

    /**
     * Copy constructor
     */
    inline  SendAmbientColourStart (const SendAmbientColourStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendAmbientColourStart (const ::midw_smartphoneint_fi_types::T_AmbientColourData& AmbientColourData_);

    /**
     * Destructor
     */
    inline virtual  ~SendAmbientColourStart();

    /**
     * Assignment operator
     */
    inline SendAmbientColourStart& operator = (const SendAmbientColourStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendAmbientColourStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendAmbientColourStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendAmbientColourStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendAmbientColourStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AmbientColourData"

    static const int kAmbientColourData = 0;

    /**
     * Clears the field "AmbientColourData".
     *
     * The field will be set to its default value. The hasAmbientColourData()
     * method will return false.
     */
    inline void clearAmbientColourData();

    /**
     * Checks whether the field "AmbientColourData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmbientColourData()). Otherwise it will return false.
     */
    inline bool hasAmbientColourData () const;

    /**
     * Returns the value of the member "AmbientColourData".
     *
     * Provides the AmbientColour details.
     *
     * @return The value of the field "AmbientColourData"
     */
    inline const ::midw_smartphoneint_fi_types::T_AmbientColourData& getAmbientColourData () const;

    /**
     * Retrieves the value of the field "AmbientColourData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AmbientColourData".
     */
    inline ::midw_smartphoneint_fi_types::T_AmbientColourData& getAmbientColourDataMutable ();

    /**
     * Sets the value of the member "AmbientColourData".
     *
     * Provides the AmbientColour details.
     *
     * @param AmbientColourData The value which will be set
     */
    inline void setAmbientColourData (const ::midw_smartphoneint_fi_types::T_AmbientColourData& AmbientColourData_);

    static const SendAmbientColourStart &getDefaultInstance();

private:

    inline void set_has_AmbientColourData ();

    inline void clear_has_AmbientColourData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_smartphoneint_fi_types::T_AmbientColourData _AmbientColourData;

};

/**
 * The result message of the method "SendAmbientColour"
 * Scope: MirrorLink.
 * It is used to send ambient colour details of the HU like Red, Green, Blue, Alpha etc. for a Mirror Link device.
 */
class SendAmbientColourResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendAmbientColourResult ();

    /**
     * Copy constructor
     */
    inline  SendAmbientColourResult (const SendAmbientColourResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendAmbientColourResult (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_, ::midw_smartphoneint_fi_types::T_e8_ErrorType ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~SendAmbientColourResult();

    /**
     * Assignment operator
     */
    inline SendAmbientColourResult& operator = (const SendAmbientColourResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendAmbientColourResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendAmbientColourResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendAmbientColourResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendAmbientColourResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResponseCode"

    static const int kResponseCode = 0;

    /**
     * Clears the field "ResponseCode".
     *
     * The field will be set to its default value. The hasResponseCode()
     * method will return false.
     */
    inline void clearResponseCode();

    /**
     * Checks whether the field "ResponseCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseCode()). Otherwise it will return false.
     */
    inline bool hasResponseCode () const;

    /**
     * Returns the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @return The value of the field "ResponseCode"
     */
    inline ::midw_smartphoneint_fi_types::T_e8_ResponseCode getResponseCode () const;

    /**
     * Sets the value of the member "ResponseCode".
     *
     * Provides result from the operation.
     *
     * @param ResponseCode The value which will be set
     */
    inline void setResponseCode (::midw_smartphoneint_fi_types::T_e8_ResponseCode ResponseCode_);

    // API of field "ErrorCode"

    static const int kErrorCode = 1;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter me