/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "midw_ext_dabtuner_fi_types.h"
#include "midw_ext_dabtuner_fi_typesCca.h"
#include "midw_ext_dabtuner_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_Label& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSLabel();
    out << in.getSLabelShort();
    out << in.getU16LabelMask();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_Label& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o0;
    in >> o0;
    out.setSLabel(o0);
    ::std::string o1;
    in >> o1;
    out.setSLabelShort(o1);
    uint16 o2;
    in >> o2;
    out.setU16LabelMask(o2);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_b8_DAB_MTC_SetMode& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getDAB_SERVICELINKING_FM()) {
        bitmask |= (1 << 0);
    }
    if (in.getFM_SERVICELINKING_DAB()) {
        bitmask |= (1 << 1);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_b8_DAB_MTC_SetMode& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o3;
    in >> o3;
    uint8 bitmask(o3);

    if (bitmask & (1 << 0)) {
        out.setDAB_SERVICELINKING_FM (true);
    }
    if (bitmask & (1 << 1)) {
        out.setFM_SERVICELINKING_DAB (true);
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_b16_DAB_AnnouncementType& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 bitmask = 0;
    if (in.getDAB_ANNOTYPE_ALARM()) {
        bitmask |= (1 << 0);
    }
    if (in.getDAB_ANNOTYPE_TA()) {
        bitmask |= (1 << 1);
    }
    if (in.getDAB_ANNOTYPE_TRANSPORT()) {
        bitmask |= (1 << 2);
    }
    if (in.getDAB_ANNOTYPE_WARNING()) {
        bitmask |= (1 << 3);
    }
    if (in.getDAB_ANNOTYPE_NEWS()) {
        bitmask |= (1 << 4);
    }
    if (in.getDAB_ANNOTYPE_WEATHER()) {
        bitmask |= (1 << 5);
    }
    if (in.getDAB_ANNOTYPE_EVENT()) {
        bitmask |= (1 << 6);
    }
    if (in.getDAB_ANNOTYPE_SPECIALEVENT()) {
        bitmask |= (1 << 7);
    }
    if (in.getDAB_ANNOTYPE_PROGRAMME()) {
        bitmask |= (1 << 8);
    }
    if (in.getDAB_ANNOTYPE_SPORTS()) {
        bitmask |= (1 << 9);
    }
    if (in.getDAB_ANNOTYPE_FINANCE()) {
        bitmask |= (1 << 10);
    }
    if (in.getDAB_ANNOTYPE_b11_reserved()) {
        bitmask |= (1 << 11);
    }
    if (in.getDAB_ANNOTYPE_b12_reserved()) {
        bitmask |= (1 << 12);
    }
    if (in.getDAB_ANNOTYPE_b13_reserved()) {
        bitmask |= (1 << 13);
    }
    if (in.getDAB_ANNOTYPE_b14_reserved()) {
        bitmask |= (1 << 14);
    }
    if (in.getDAB_ANNOTYPE_b15_reserved()) {
        bitmask |= (1 << 15);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_b16_DAB_AnnouncementType& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o4;
    in >> o4;
    uint16 bitmask(o4);

    if (bitmask & (1 << 0)) {
        out.setDAB_ANNOTYPE_ALARM (true);
    }
    if (bitmask & (1 << 1)) {
        out.setDAB_ANNOTYPE_TA (true);
    }
    if (bitmask & (1 << 2)) {
        out.setDAB_ANNOTYPE_TRANSPORT (true);
    }
    if (bitmask & (1 << 3)) {
        out.setDAB_ANNOTYPE_WARNING (true);
    }
    if (bitmask & (1 << 4)) {
        out.setDAB_ANNOTYPE_NEWS (true);
    }
    if (bitmask & (1 << 5)) {
        out.setDAB_ANNOTYPE_WEATHER (true);
    }
    if (bitmask & (1 << 6)) {
        out.setDAB_ANNOTYPE_EVENT (true);
    }
    if (bitmask & (1 << 7)) {
        out.setDAB_ANNOTYPE_SPECIALEVENT (true);
    }
    if (bitmask & (1 << 8)) {
        out.setDAB_ANNOTYPE_PROGRAMME (true);
    }
    if (bitmask & (1 << 9)) {
        out.setDAB_ANNOTYPE_SPORTS (true);
    }
    if (bitmask & (1 << 10)) {
        out.setDAB_ANNOTYPE_FINANCE (true);
    }
    if (bitmask & (1 << 11)) {
        out.setDAB_ANNOTYPE_b11_reserved (true);
    }
    if (bitmask & (1 << 12)) {
        out.setDAB_ANNOTYPE_b12_reserved (true);
    }
    if (bitmask & (1 << 13)) {
        out.setDAB_ANNOTYPE_b13_reserved (true);
    }
    if (bitmask & (1 << 14)) {
        out.setDAB_ANNOTYPE_b14_reserved (true);
    }
    if (bitmask & (1 << 15)) {
        out.setDAB_ANNOTYPE_b15_reserved (true);
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_Frequency& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32Frequency();
    out << in.getSFreqLabel();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_Frequency& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o5;
    in >> o5;
    out.setU32Frequency(o5);
    ::std::string o6;
    in >> o6;
    out.setSFreqLabel(o6);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_b16_DAB_TunerStatusFlags& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 bitmask = 0;
    if (in.getDAB_TUNERSTATUSFLAGS_SYNC()) {
        bitmask |= (1 << 0);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_ENS_VALID()) {
        bitmask |= (1 << 1);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID()) {
        bitmask |= (1 << 2);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID()) {
        bitmask |= (1 << 3);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_MUTE()) {
        bitmask |= (1 << 4);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_TUNING()) {
        bitmask |= (1 << 5);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_b6_reserved()) {
        bitmask |= (1 << 6);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_b7_reserved()) {
        bitmask |= (1 << 7);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_LEARN()) {
        bitmask |= (1 << 8);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_b9_reserved()) {
        bitmask |= (1 << 9);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_b10_reserved()) {
        bitmask |= (1 << 10);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_b11_reserved()) {
        bitmask |= (1 << 11);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_b12_reserved()) {
        bitmask |= (1 << 12);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_b13_reserved()) {
        bitmask |= (1 << 13);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_b14_reserved()) {
        bitmask |= (1 << 14);
    }
    if (in.getDAB_TUNERSTATUSFLAGS_b15_reserved()) {
        bitmask |= (1 << 15);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_b16_DAB_TunerStatusFlags& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o7;
    in >> o7;
    uint16 bitmask(o7);

    if (bitmask & (1 << 0)) {
        out.setDAB_TUNERSTATUSFLAGS_SYNC (true);
    }
    if (bitmask & (1 << 1)) {
        out.setDAB_TUNERSTATUSFLAGS_ENS_VALID (true);
    }
    if (bitmask & (1 << 2)) {
        out.setDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID (true);
    }
    if (bitmask & (1 << 3)) {
        out.setDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID (true);
    }
    if (bitmask & (1 << 4)) {
        out.setDAB_TUNERSTATUSFLAGS_MUTE (true);
    }
    if (bitmask & (1 << 5)) {
        out.setDAB_TUNERSTATUSFLAGS_TUNING (true);
    }
    if (bitmask & (1 << 6)) {
        out.setDAB_TUNERSTATUSFLAGS_b6_reserved (true);
    }
    if (bitmask & (1 << 7)) {
        out.setDAB_TUNERSTATUSFLAGS_b7_reserved (true);
    }
    if (bitmask & (1 << 8)) {
        out.setDAB_TUNERSTATUSFLAGS_LEARN (true);
    }
    if (bitmask & (1 << 9)) {
        out.setDAB_TUNERSTATUSFLAGS_b9_reserved (true);
    }
    if (bitmask & (1 << 10)) {
        out.setDAB_TUNERSTATUSFLAGS_b10_reserved (true);
    }
    if (bitmask & (1 << 11)) {
        out.setDAB_TUNERSTATUSFLAGS_b11_reserved (true);
    }
    if (bitmask & (1 << 12)) {
        out.setDAB_TUNERSTATUSFLAGS_b12_reserved (true);
    }
    if (bitmask & (1 << 13)) {
        out.setDAB_TUNERSTATUSFLAGS_b13_reserved (true);
    }
    if (bitmask & (1 << 14)) {
        out.setDAB_TUNERSTATUSFLAGS_b14_reserved (true);
    }
    if (bitmask & (1 << 15)) {
        out.setDAB_TUNERSTATUSFLAGS_b15_reserved (true);
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_TunerStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8TunerActivityType();
    serializeCca(in.getFreqTuned(), out, majorVersion);
    out << in.getSFrequencyTable();
    serializeCca(in.getB16Flags(), out, majorVersion);
    out << in.getU8SignalQuality();
    out << in.getU8AudioQuality();
    out << in.getU32CurrentEnsembleId();
    out << in.getU32CurrentServiceId();
    out << in.getU16CurrentSCIDI();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_TunerStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o8;
    in >> o8;
    out.setE8TunerActivityType((::midw_ext_dabtuner_fi_types::T_e8_DAB_TunerActivityType)o8);
    deserializeCca(in, out.getFreqTunedMutable(), majorVersion);
    ::std::string o9;
    in >> o9;
    out.setSFrequencyTable(o9);
    deserializeCca(in, out.getB16FlagsMutable(), majorVersion);
    uint8 o10;
    in >> o10;
    out.setU8SignalQuality(o10);
    uint8 o11;
    in >> o11;
    out.setU8AudioQuality(o11);
    uint32 o12;
    in >> o12;
    out.setU32CurrentEnsembleId(o12);
    uint32 o13;
    in >> o13;
    out.setU32CurrentServiceId(o13);
    uint16 o14;
    in >> o14;
    out.setU16CurrentSCIDI(o14);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_RadioText& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSRadioTextData();
    out << (uint8) in.getBValid();
    out << in.getU8CharSet();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_RadioText& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o15;
    in >> o15;
    out.setSRadioTextData(o15);
    bool o16;
    in >> o16;
    out.setBValid(o16);
    uint8 o17;
    in >> o17;
    out.setU8CharSet(o17);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_RadioTextPlus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8ContentType();
    serializeCca(in.getContent(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_RadioTextPlus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o18;
    in >> o18;
    out.setU8ContentType(o18);
    deserializeCca(in, out.getContentMutable(), majorVersion);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_EnsembleInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32EnsembleId();
    serializeCca(in.getEnsembleLabel(), out, majorVersion);
    out << in.getU32Frequency();
    out << in.getU8NumberOfAudioServices();
    out << in.getU8NumberOfDataServices();
    out << in.getU8NumberOfAudioServiceComponents();
    out << in.getU8NumberOfDataServiceComponents();
    out << in.getU8ReceptionQuality();
    out << in.getU8NumberOfEnsembles();
    out << in.getU8ListElementId();
    out << (uint8) in.getBReception();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_EnsembleInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o19;
    in >> o19;
    out.setU32EnsembleId(o19);
    deserializeCca(in, out.getEnsembleLabelMutable(), majorVersion);
    uint32 o20;
    in >> o20;
    out.setU32Frequency(o20);
    uint8 o21;
    in >> o21;
    out.setU8NumberOfAudioServices(o21);
    uint8 o22;
    in >> o22;
    out.setU8NumberOfDataServices(o22);
    uint8 o23;
    in >> o23;
    out.setU8NumberOfAudioServiceComponents(o23);
    uint8 o24;
    in >> o24;
    out.setU8NumberOfDataServiceComponents(o24);
    uint8 o25;
    in >> o25;
    out.setU8ReceptionQuality(o25);
    uint8 o26;
    in >> o26;
    out.setU8NumberOfEnsembles(o26);
    uint8 o27;
    in >> o27;
    out.setU8ListElementId(o27);
    bool o28;
    in >> o28;
    out.setBReception(o28);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_b8_DAB_ServiceInfoFlags& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT()) {
        bitmask |= (1 << 0);
    }
    if (in.getDAB_SERVICEINFO_TMC_COMPONENT()) {
        bitmask |= (1 << 1);
    }
    if (in.getDAB_SERVICEINFO_DRC()) {
        bitmask |= (1 << 2);
    }
    if (in.getDAB_SERVICEINFO_b3_reserved()) {
        bitmask |= (1 << 3);
    }
    if (in.getDAB_SERVICEINFO_b4_reserved()) {
        bitmask |= (1 << 4);
    }
    if (in.getDAB_SERVICEINFO_b5_reserved()) {
        bitmask |= (1 << 5);
    }
    if (in.getDAB_SERVICEINFO_b6_reserved()) {
        bitmask |= (1 << 6);
    }
    if (in.getDAB_SERVICEINFO_b7_reserved()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_b8_DAB_ServiceInfoFlags& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o29;
    in >> o29;
    uint8 bitmask(o29);

    if (bitmask & (1 << 0)) {
        out.setDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT (true);
    }
    if (bitmask & (1 << 1)) {
        out.setDAB_SERVICEINFO_TMC_COMPONENT (true);
    }
    if (bitmask & (1 << 2)) {
        out.setDAB_SERVICEINFO_DRC (true);
    }
    if (bitmask & (1 << 3)) {
        out.setDAB_SERVICEINFO_b3_reserved (true);
    }
    if (bitmask & (1 << 4)) {
        out.setDAB_SERVICEINFO_b4_reserved (true);
    }
    if (bitmask & (1 << 5)) {
        out.setDAB_SERVICEINFO_b5_reserved (true);
    }
    if (bitmask & (1 << 6)) {
        out.setDAB_SERVICEINFO_b6_reserved (true);
    }
    if (bitmask & (1 << 7)) {
        out.setDAB_SERVICEINFO_b7_reserved (true);
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_ServiceInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32ServId();
    serializeCca(in.getServiceLabel(), out, majorVersion);
    out << (uint8) in.getE8ServiceType();
    out << in.getU8NumberOfAudioComponents();
    out << in.getU8NumberOfDataComponents();
    serializeCca(in.getB16AvailableAnnoTypesMask(), out, majorVersion);
    out << in.getU8SampleRate();
    out << in.getU16BitRate();
    out << in.getSAudioMode();
    out << in.getSAdvancedAudioCodec();
    out << in.getSAudioCodec();
    serializeCca(in.getB8Flags(), out, majorVersion);
    out << in.getU8PresetListElementID();
    out << in.getU16ServiceIndex();
    out << in.getU8PTYCode();
    out << (uint8) in.getE8EncodingType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_ServiceInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o30;
    in >> o30;
    out.setU32ServId(o30);
    deserializeCca(in, out.getServiceLabelMutable(), majorVersion);
    uint8 o31;
    in >> o31;
    out.setE8ServiceType((::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceType)o31);
    uint8 o32;
    in >> o32;
    out.setU8NumberOfAudioComponents(o32);
    uint8 o33;
    in >> o33;
    out.setU8NumberOfDataComponents(o33);
    deserializeCca(in, out.getB16AvailableAnnoTypesMaskMutable(), majorVersion);
    uint8 o34;
    in >> o34;
    out.setU8SampleRate(o34);
    uint16 o35;
    in >> o35;
    out.setU16BitRate(o35);
    ::std::string o36;
    in >> o36;
    out.setSAudioMode(o36);
    ::std::string o37;
    in >> o37;
    out.setSAdvancedAudioCodec(o37);
    ::std::string o38;
    in >> o38;
    out.setSAudioCodec(o38);
    deserializeCca(in, out.getB8FlagsMutable(), majorVersion);
    uint8 o39;
    in >> o39;
    out.setU8PresetListElementID(o39);
    uint16 o40;
    in >> o40;
    out.setU16ServiceIndex(o40);
    uint8 o41;
    in >> o41;
    out.setU8PTYCode(o41);
    uint8 o42;
    in >> o42;
    out.setE8EncodingType((::midw_ext_dabtuner_fi_types::T_e8_DAB_Encoding)o42);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_ChannelInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32ServId();
    out << (uint8) in.getEnState();
    serializeCca(in.getServiceLabel(), out, majorVersion);
    out << in.getU8NumberOfAudioComponents();
    serializeCca(in.getB16AvailableAnnoTypesMask(), out, majorVersion);
    out << in.getU8PresetListElementID();
    out << (uint8) in.getBComponentMode();
    out << (uint8) in.getBFmServiceFollowActive();
    out << in.getU16FrozenListElementID();
    serializeCca(in.getRRadioText(), out, majorVersion);
    out << in.getU8NumberOfDLPElements();
    {
        uint32 o43 = static_cast<uint32>(in.getDLPlusList().size());
        out << o43;
        ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_RadioTextPlus >::const_iterator o44;
        for (o44 = in.getDLPlusList().begin(); o44 != in.getDLPlusList().end(); ++o44) {
            serializeCca((*o44), out, majorVersion);
        }
    }
    out << (uint8) in.getBMuted();
    out << (uint8) in.getBAFAvailable();
    out << in.getSLogoLink();
    out << in.getU8ScidsValue();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_ChannelInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o45;
    in >> o45;
    out.setU32ServId(o45);
    uint8 o46;
    in >> o46;
    out.setEnState((::midw_ext_dabtuner_fi_types::T_e8_DAB_ChannelInfoState)o46);
    deserializeCca(in, out.getServiceLabelMutable(), majorVersion);
    uint8 o47;
    in >> o47;
    out.setU8NumberOfAudioComponents(o47);
    deserializeCca(in, out.getB16AvailableAnnoTypesMaskMutable(), majorVersion);
    uint8 o48;
    in >> o48;
    out.setU8PresetListElementID(o48);
    bool o49;
    in >> o49;
    out.setBComponentMode(o49);
    bool o50;
    in >> o50;
    out.setBFmServiceFollowActive(o50);
    uint16 o51;
    in >> o51;
    out.setU16FrozenListElementID(o51);
    deserializeCca(in, out.getRRadioTextMutable(), majorVersion);
    uint8 o52;
    in >> o52;
    out.setU8NumberOfDLPElements(o52);
    {
        uint32 o53;
        in >> o53;
        out.getDLPlusListMutable().clear ();
        out.getDLPlusListMutable().reserve (o53);
        for (uint32 o54 = 0; o54 < o53; o54++) {
            ::midw_ext_dabtuner_fi_types::T_DAB_RadioTextPlus o55;
            deserializeCca(in, o55, majorVersion);
            out.getDLPlusListMutable().push_back (o55);
        }
    }
    bool o56;
    in >> o56;
    out.setBMuted(o56);
    bool o57;
    in >> o57;
    out.setBAFAvailable(o57);
    ::std::string o58;
    in >> o58;
    out.setSLogoLink(o58);
    uint8 o59;
    in >> o59;
    out.setU8ScidsValue(o59);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_ComponentInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8ComponentId();
    serializeCca(in.getComponentLabel(), out, majorVersion);
    out << in.getU16SCIDI();
    out << in.getU8Subchannel();
    out << in.getU8SCIDS();
    out << (uint8) in.getE8ComponentType();
    out << (uint8) in.getE8ServiceType();
    out << (uint8) in.getE8TMIdType();
    out << in.getU8AudioDataServiceComponentType();
    out << in.getU16ComponentIndex();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_ComponentInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o60;
    in >> o60;
    out.setU8ComponentId(o60);
    deserializeCca(in, out.getComponentLabelMutable(), majorVersion);
    uint16 o61;
    in >> o61;
    out.setU16SCIDI(o61);
    uint8 o62;
    in >> o62;
    out.setU8Subchannel(o62);
    uint8 o63;
    in >> o63;
    out.setU8SCIDS(o63);
    uint8 o64;
    in >> o64;
    out.setE8ComponentType((::midw_ext_dabtuner_fi_types::T_e8_DAB_ComponentType)o64);
    uint8 o65;
    in >> o65;
    out.setE8ServiceType((::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceType)o65);
    uint8 o66;
    in >> o66;
    out.setE8TMIdType((::midw_ext_dabtuner_fi_types::T_e8_DAB_TMIdType)o66);
    uint8 o67;
    in >> o67;
    out.setU8AudioDataServiceComponentType(o67);
    uint16 o68;
    in >> o68;
    out.setU16ComponentIndex(o68);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_AnnoConfig& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getAnnoConfigTypes(), out, majorVersion);
    out << (uint8) in.getBEnable();
    out << (uint8) in.getAnnoConfigSource();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_AnnoConfig& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getAnnoConfigTypesMutable(), majorVersion);
    bool o69;
    in >> o69;
    out.setBEnable(o69);
    uint8 o70;
    in >> o70;
    out.setAnnoConfigSource((::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource)o70);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_AnnoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getAnnoConfigTypes(), out, majorVersion);
    out << (uint8) in.getAnnoConfigSource();
    serializeCca(in.getAnnoSupportedTypes(), out, majorVersion);
    serializeCca(in.getAnnoActiveTypes(), out, majorVersion);
    out << (uint8) in.getAnnoActiveSource();
    out << (uint8) in.getAnnoActiveState();
    out << (uint8) in.getAnnoSelectState();
    serializeCca(in.getAnnoSelectedTypes(), out, majorVersion);
    serializeCca(in.getAnnoServiceLabel(), out, majorVersion);
    {
        uint32 o71 = static_cast<uint32>(in.getAnnouncementList().size());
        out << o71;
        ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_AnnoElement >::const_iterator o72;
        for (o72 = in.getAnnouncementList().begin(); o72 != in.getAnnouncementList().end(); ++o72) {
            serializeCca((*o72), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_AnnoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getAnnoConfigTypesMutable(), majorVersion);
    uint8 o73;
    in >> o73;
    out.setAnnoConfigSource((::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource)o73);
    deserializeCca(in, out.getAnnoSupportedTypesMutable(), majorVersion);
    deserializeCca(in, out.getAnnoActiveTypesMutable(), majorVersion);
    uint8 o74;
    in >> o74;
    out.setAnnoActiveSource((::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource)o74);
    uint8 o75;
    in >> o75;
    out.setAnnoActiveState((::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementStatus)o75);
    uint8 o76;
    in >> o76;
    out.setAnnoSelectState((::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSelectState)o76);
    deserializeCca(in, out.getAnnoSelectedTypesMutable(), majorVersion);
    deserializeCca(in, out.getAnnoServiceLabelMutable(), majorVersion);
    {
        uint32 o77;
        in >> o77;
        out.getAnnouncementListMutable().clear ();
        out.getAnnouncementListMutable().reserve (o77);
        for (uint32 o78 = 0; o78 < o77; o78++) {
            ::midw_ext_dabtuner_fi_types::T_DAB_AnnoElement o79;
            deserializeCca(in, o79, majorVersion);
            out.getAnnouncementListMutable().push_back (o79);
        }
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_AnnoElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16AnnoType();
    out << (uint8) in.getAnnoState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_AnnoElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o80;
    in >> o80;
    out.setU16AnnoType(o80);
    uint8 o81;
    in >> o81;
    out.setAnnoState((::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementStatus)o81);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_ADRMsg& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16FktID();
    {
        uint32 o82 = static_cast<uint32>(in.getMsgData().size());
        out << o82;
        ::std::vector< uint8 >::const_iterator o83;
        for (o83 = in.getMsgData().begin(); o83 != in.getMsgData().end(); ++o83) {
            out << (*o83);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_ADRMsg& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o84;
    in >> o84;
    out.setU16FktID(o84);
    {
        uint32 o85;
        in >> o85;
        out.getMsgDataMutable().clear ();
        out.getMsgDataMutable().reserve (o85);
        for (uint32 o86 = 0; o86 < o85; o86++) {
            uint8 o87;
            in >> o87;
            out.getMsgDataMutable().push_back(o87);
        }
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_LogoElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32ServiceID();
    out << in.getSLogoLink();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_LogoElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o88;
    in >> o88;
    out.setU32ServiceID(o88);
    ::std::string o89;
    in >> o89;
    out.setSLogoLink(o89);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_ContentID& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32ServiceID();
    out << in.getU8Scid();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_ContentID& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o90;
    in >> o90;
    out.setU32ServiceID(o90);
    uint8 o91;
    in >> o91;
    out.setU8Scid(o91);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_TuneParam& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8TuneType();
    out << in.getU32Value();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_TuneParam& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o92;
    in >> o92;
    out.setE8TuneType((::midw_ext_dabtuner_fi_types::T_e8_DAB_TuneType)o92);
    uint32 o93;
    in >> o93;
    out.setU32Value(o93);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_LearnParam& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8LearnType();
    out << (uint8) in.getBRollback();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_LearnParam& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o94;
    in >> o94;
    out.setE8LearnType((::midw_ext_dabtuner_fi_types::T_e8_DAB_LearnType)o94);
    bool o95;
    in >> o95;
    out.setBRollback(o95);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_b32_DAB_SetupMask& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 bitmask = 0;
    if (in.getDAB_SETUPOPERATIONMASK_b0_reserved()) {
        bitmask |= (1 << 0);
    }
    if (in.getDAB_SETUPOPERATIONMASK_b1_reserved()) {
        bitmask |= (1 << 1);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_b32_DAB_SetupMask& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o96;
    in >> o96;
    uint32 bitmask(o96);

    if (bitmask & (1 << 0)) {
        out.setDAB_SETUPOPERATIONMASK_b0_reserved (true);
    }
    if (bitmask & (1 << 1)) {
        out.setDAB_SETUPOPERATIONMASK_b1_reserved (true);
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_b32_DAB_SetupFlags& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 bitmask = 0;
    if (in.getDAB_SETUPOPERATION_SWITCHON_b0_reserved()) {
        bitmask |= (1 << 0);
    }
    if (in.getDAB_SETUPOPERATION_SWITCHON_b1_reserved()) {
        bitmask |= (1 << 1);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_b32_DAB_SetupFlags& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o97;
    in >> o97;
    uint32 bitmask(o97);

    if (bitmask & (1 << 0)) {
        out.setDAB_SETUPOPERATION_SWITCHON_b0_reserved (true);
    }
    if (bitmask & (1 << 1)) {
        out.setDAB_SETUPOPERATION_SWITCHON_b1_reserved (true);
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_b8_DAB_LinkingSetupMask& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getDAB_SETUPLINKING_TH_NONE()) {
        bitmask |= (1 << 0);
    }
    if (in.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH()) {
        bitmask |= (1 << 1);
    }
    if (in.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH()) {
        bitmask |= (1 << 2);
    }
    if (in.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME()) {
        bitmask |= (1 << 3);
    }
    if (in.getDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY()) {
        bitmask |= (1 << 4);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_b8_DAB_LinkingSetupMask& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o98;
    in >> o98;
    uint8 bitmask(o98);

    if (bitmask & (1 << 0)) {
        out.setDAB_SETUPLINKING_TH_NONE (true);
    }
    if (bitmask & (1 << 1)) {
        out.setDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH (true);
    }
    if (bitmask & (1 << 2)) {
        out.setDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH (true);
    }
    if (bitmask & (1 << 3)) {
        out.setDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME (true);
    }
    if (bitmask & (1 << 4)) {
        out.setDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY (true);
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_b8_DAB_ExtServFollowingFlags& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION()) {
        bitmask |= (1 << 0);
    }
    if (in.getDAB_EXTSERVFOLLOWING_SWITCH_DONE()) {
        bitmask |= (1 << 1);
    }
    if (in.getDAB_EXTSERVFOLLOWING_SWITCH_REJECTED()) {
        bitmask |= (1 << 2);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_b8_DAB_ExtServFollowingFlags& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o99;
    in >> o99;
    uint8 bitmask(o99);

    if (bitmask & (1 << 0)) {
        out.setDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION (true);
    }
    if (bitmask & (1 << 1)) {
        out.setDAB_EXTSERVFOLLOWING_SWITCH_DONE (true);
    }
    if (bitmask & (1 << 2)) {
        out.setDAB_EXTSERVFOLLOWING_SWITCH_REJECTED (true);
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_PresetListElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8PresetElementID();
    out << in.getU32ServiceID();
    serializeCca(in.getServiceLabel(), out, majorVersion);
    out << in.getU32Frequency();
    out << in.getU8Scid();
    serializeCca(in.getComponentLabel(), out, majorVersion);
    out << in.getU32EnsembleId();
    serializeCca(in.getEnsembleLabel(), out, majorVersion);
    out << in.getSLogoLink();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_PresetListElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o100;
    in >> o100;
    out.setU8PresetElementID(o100);
    uint32 o101;
    in >> o101;
    out.setU32ServiceID(o101);
    deserializeCca(in, out.getServiceLabelMutable(), majorVersion);
    uint32 o102;
    in >> o102;
    out.setU32Frequency(o102);
    uint8 o103;
    in >> o103;
    out.setU8Scid(o103);
    deserializeCca(in, out.getComponentLabelMutable(), majorVersion);
    uint32 o104;
    in >> o104;
    out.setU32EnsembleId(o104);
    deserializeCca(in, out.getEnsembleLabelMutable(), majorVersion);
    ::std::string o105;
    in >> o105;
    out.setSLogoLink(o105);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_ChnListElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16ListElementID();
    out << in.getU32DABId();
    out << in.getU8CompScids();
    serializeCca(in.getLabel(), out, majorVersion);
    serializeCca(in.getEnsembleLabel(), out, majorVersion);
    out << in.getSFreqLabel();
    out << in.getU8PresetListElemId();
    out << in.getU8PTY();
    out << in.getU16ASU();
    out << (uint8) in.getBReception();
    out << in.getU8NumberOfComponents();
    out << in.getU8ServiceLinkMode();
    out << in.getSLogoLink();
    out << in.getBEPGSupport();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_ChnListElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o106;
    in >> o106;
    out.setU16ListElementID(o106);
    uint32 o107;
    in >> o107;
    out.setU32DABId(o107);
    uint8 o108;
    in >> o108;
    out.setU8CompScids(o108);
    deserializeCca(in, out.getLabelMutable(), majorVersion);
    deserializeCca(in, out.getEnsembleLabelMutable(), majorVersion);
    ::std::string o109;
    in >> o109;
    out.setSFreqLabel(o109);
    uint8 o110;
    in >> o110;
    out.setU8PresetListElemId(o110);
    uint8 o111;
    in >> o111;
    out.setU8PTY(o111);
    uint16 o112;
    in >> o112;
    out.setU16ASU(o112);
    bool o113;
    in >> o113;
    out.setBReception(o113);
    uint8 o114;
    in >> o114;
    out.setU8NumberOfComponents(o114);
    uint8 o115;
    in >> o115;
    out.setU8ServiceLinkMode(o115);
    ::std::string o116;
    in >> o116;
    out.setSLogoLink(o116);
    uint8 o117;
    in >> o117;
    out.setBEPGSupport(o117);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_ListElementAvailInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16ListElementID();
    out << (uint8) in.getBAvailable();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_ListElementAvailInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o118;
    in >> o118;
    out.setU16ListElementID(o118);
    bool o119;
    in >> o119;
    out.setBAvailable(o119);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_TIIListElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8MainId();
    out << in.getU8SubId();
    out << in.getU32Latitude();
    out << in.getU32Longitude();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_TIIListElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o120;
    in >> o120;
    out.setU8MainId(o120);
    uint8 o121;
    in >> o121;
    out.setU8SubId(o121);
    uint32 o122;
    in >> o122;
    out.setU32Latitude(o122);
    uint32 o123;
    in >> o123;
    out.setU32Longitude(o123);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_b8_DAB_TestMode_Flags& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getDAB_TESTMODE_FLAGS_AUDIOSOURCE()) {
        bitmask |= (1 << 0);
    }
    if (in.getDAB_TESTMODE_FLAGS_SFINT()) {
        bitmask |= (1 << 1);
    }
    if (in.getDAB_TESTMODE_FLAGS_b2_reserved()) {
        bitmask |= (1 << 2);
    }
    if (in.getDAB_TESTMODE_FLAGS_b3_reserved()) {
        bitmask |= (1 << 3);
    }
    if (in.getDAB_TESTMODE_FLAGS_b4_reserved()) {
        bitmask |= (1 << 4);
    }
    if (in.getDAB_TESTMODE_FLAGS_b5_reserved()) {
        bitmask |= (1 << 5);
    }
    if (in.getDAB_TESTMODE_FLAGS_b6_reserved()) {
        bitmask |= (1 << 6);
    }
    if (in.getDAB_TESTMODE_FLAGS_b7_reserved()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_b8_DAB_TestMode_Flags& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o124;
    in >> o124;
    uint8 bitmask(o124);

    if (bitmask & (1 << 0)) {
        out.setDAB_TESTMODE_FLAGS_AUDIOSOURCE (true);
    }
    if (bitmask & (1 << 1)) {
        out.setDAB_TESTMODE_FLAGS_SFINT (true);
    }
    if (bitmask & (1 << 2)) {
        out.setDAB_TESTMODE_FLAGS_b2_reserved (true);
    }
    if (bitmask & (1 << 3)) {
        out.setDAB_TESTMODE_FLAGS_b3_reserved (true);
    }
    if (bitmask & (1 << 4)) {
        out.setDAB_TESTMODE_FLAGS_b4_reserved (true);
    }
    if (bitmask & (1 << 5)) {
        out.setDAB_TESTMODE_FLAGS_b5_reserved (true);
    }
    if (bitmask & (1 << 6)) {
        out.setDAB_TESTMODE_FLAGS_b6_reserved (true);
    }
    if (bitmask & (1 << 7)) {
        out.setDAB_TESTMODE_FLAGS_b7_reserved (true);
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_b8_DAB_ALT_FM_Valid_Flags& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getDAB_FM_ALT_FM_PI_VALID_FLAG()) {
        bitmask |= (1 << 0);
    }
    if (in.getDAB_FM_ALT_FM_FREQ_VALID_FLAG()) {
        bitmask |= (1 << 1);
    }
    if (in.getDAB_FM_ALT_FM_QUALITY_VALID_FLAG()) {
        bitmask |= (1 << 2);
    }
    if (in.getDAB_TESTMODE_FLAGS_b3_reserved()) {
        bitmask |= (1 << 3);
    }
    if (in.getDAB_TESTMODE_FLAGS_b4_reserved()) {
        bitmask |= (1 << 4);
    }
    if (in.getDAB_TESTMODE_FLAGS_b5_reserved()) {
        bitmask |= (1 << 5);
    }
    if (in.getDAB_TESTMODE_FLAGS_b6_reserved()) {
        bitmask |= (1 << 6);
    }
    if (in.getDAB_TESTMODE_FLAGS_b7_reserved()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_b8_DAB_ALT_FM_Valid_Flags& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o125;
    in >> o125;
    uint8 bitmask(o125);

    if (bitmask & (1 << 0)) {
        out.setDAB_FM_ALT_FM_PI_VALID_FLAG (true);
    }
    if (bitmask & (1 << 1)) {
        out.setDAB_FM_ALT_FM_FREQ_VALID_FLAG (true);
    }
    if (bitmask & (1 << 2)) {
        out.setDAB_FM_ALT_FM_QUALITY_VALID_FLAG (true);
    }
    if (bitmask & (1 << 3)) {
        out.setDAB_TESTMODE_FLAGS_b3_reserved (true);
    }
    if (bitmask & (1 << 4)) {
        out.setDAB_TESTMODE_FLAGS_b4_reserved (true);
    }
    if (bitmask & (1 << 5)) {
        out.setDAB_TESTMODE_FLAGS_b5_reserved (true);
    }
    if (bitmask & (1 << 6)) {
        out.setDAB_TESTMODE_FLAGS_b6_reserved (true);
    }
    if (bitmask & (1 << 7)) {
        out.setDAB_TESTMODE_FLAGS_b7_reserved (true);
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_TestModeData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32CurrentServID();
    out << in.getU32MSCBER();
    out << in.getU32FICBER();
    out << in.getU32NETBER();
    out << in.getU8RSFEC();
    out << in.getU8DABMode();
    out << in.getU8ProtectionLevel();
    out << in.getU8ConcealmentLevel();
    out << (uint8) in.getE8ServiceLinkingMode();
    serializeCca(in.getB8ValidFMValues(), out, majorVersion);
    out << in.getU16AltFMPI();
    out << in.getU32AltFMFrequency();
    out << in.getU8AltFMQuality();
    serializeCca(in.getB8Flags(), out, majorVersion);
    out << in.getS8FieldStrength();
    out << in.getU16TotalNumberLinks();
    out << in.getU8ECC();
    out << in.getU16CountryLabel();
    out << in.getU16ActivatedLink();
    {
        uint32 o126 = static_cast<uint32>(in.getLinkList().size());
        out << o126;
        ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_LinkListElem >::const_iterator o127;
        for (o127 = in.getLinkList().begin(); o127 != in.getLinkList().end(); ++o127) {
            serializeCca((*o127), out, majorVersion);
        }
    }
    {
        uint32 o128 = static_cast<uint32>(in.getDAB_DMB_AltFreqInfo().size());
        out << o128;
        ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_AltFreqInfo >::const_iterator o129;
        for (o129 = in.getDAB_DMB_AltFreqInfo().begin(); o129 != in.getDAB_DMB_AltFreqInfo().end(); ++o129) {
            serializeCca((*o129), out, majorVersion);
        }
    }
    out << (uint8) in.getBSync();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_TestModeData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o130;
    in >> o130;
    out.setU32CurrentServID(o130);
    uint32 o131;
    in >> o131;
    out.setU32MSCBER(o131);
    uint32 o132;
    in >> o132;
    out.setU32FICBER(o132);
    uint32 o133;
    in >> o133;
    out.setU32NETBER(o133);
    uint8 o134;
    in >> o134;
    out.setU8RSFEC(o134);
    uint8 o135;
    in >> o135;
    out.setU8DABMode(o135);
    uint8 o136;
    in >> o136;
    out.setU8ProtectionLevel(o136);
    uint8 o137;
    in >> o137;
    out.setU8ConcealmentLevel(o137);
    uint8 o138;
    in >> o138;
    out.setE8ServiceLinkingMode((::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceLinkingMode)o138);
    deserializeCca(in, out.getB8ValidFMValuesMutable(), majorVersion);
    uint16 o139;
    in >> o139;
    out.setU16AltFMPI(o139);
    uint32 o140;
    in >> o140;
    out.setU32AltFMFrequency(o140);
    uint8 o141;
    in >> o141;
    out.setU8AltFMQuality(o141);
    deserializeCca(in, out.getB8FlagsMutable(), majorVersion);
    int8 o142;
    in >> o142;
    out.setS8FieldStrength(o142);
    uint16 o143;
    in >> o143;
    out.setU16TotalNumberLinks(o143);
    uint8 o144;
    in >> o144;
    out.setU8ECC(o144);
    uint16 o145;
    in >> o145;
    out.setU16CountryLabel(o145);
    uint16 o146;
    in >> o146;
    out.setU16ActivatedLink(o146);
    {
        uint32 o147;
        in >> o147;
        out.getLinkListMutable().clear ();
        out.getLinkListMutable().reserve (o147);
        for (uint32 o148 = 0; o148 < o147; o148++) {
            ::midw_ext_dabtuner_fi_types::T_DAB_LinkListElem o149;
            deserializeCca(in, o149, majorVersion);
            out.getLinkListMutable().push_back (o149);
        }
    }
    {
        uint32 o150;
        in >> o150;
        out.getDAB_DMB_AltFreqInfoMutable().clear ();
        out.getDAB_DMB_AltFreqInfoMutable().reserve (o150);
        for (uint32 o151 = 0; o151 < o150; o151++) {
            ::midw_ext_dabtuner_fi_types::T_DAB_AltFreqInfo o152;
            deserializeCca(in, o152, majorVersion);
            out.getDAB_DMB_AltFreqInfoMutable().push_back (o152);
        }
    }
    bool o153;
    in >> o153;
    out.setBSync(o153);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_BG_TestModeData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32BgFrequency();
    out << in.getU32BgCurrentEnsID();
    out << in.getU32BgFICBER();
    serializeCca(in.getB16BgFlags(), out, majorVersion);
    out << in.getSBgDabMode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_BG_TestModeData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o154;
    in >> o154;
    out.setU32BgFrequency(o154);
    uint32 o155;
    in >> o155;
    out.setU32BgCurrentEnsID(o155);
    uint32 o156;
    in >> o156;
    out.setU32BgFICBER(o156);
    deserializeCca(in, out.getB16BgFlagsMutable(), majorVersion);
    ::std::string o157;
    in >> o157;
    out.setSBgDabMode(o157);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_Time& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32DabSec();
    out << in.getU32DabMin();
    out << in.getU32DabHour();
    out << in.getU32DabMday();
    out << in.getU32DabMon();
    out << in.getU32DabYear();
    out << in.getU32DabWday();
    out << in.getU32DabYday();
    out << in.getU32DabUtcOff();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_Time& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o158;
    in >> o158;
    out.setU32DabSec(o158);
    uint32 o159;
    in >> o159;
    out.setU32DabMin(o159);
    uint32 o160;
    in >> o160;
    out.setU32DabHour(o160);
    uint32 o161;
    in >> o161;
    out.setU32DabMday(o161);
    uint32 o162;
    in >> o162;
    out.setU32DabMon(o162);
    uint32 o163;
    in >> o163;
    out.setU32DabYear(o163);
    uint32 o164;
    in >> o164;
    out.setU32DabWday(o164);
    uint32 o165;
    in >> o165;
    out.setU32DabYday(o165);
    uint32 o166;
    in >> o166;
    out.setU32DabUtcOff(o166);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_TMC_TPEG_TestModeData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32NumTmcServices();
    out << in.getU32NumTpegServices();
    out << in.getU32RcvTmcMsgs();
    out << in.getU32RcvTpegMsgs();
    serializeCca(in.getDabTime(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_TMC_TPEG_TestModeData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o167;
    in >> o167;
    out.setU32NumTmcServices(o167);
    uint32 o168;
    in >> o168;
    out.setU32NumTpegServices(o168);
    uint32 o169;
    in >> o169;
    out.setU32RcvTmcMsgs(o169);
    uint32 o170;
    in >> o170;
    out.setU32RcvTpegMsgs(o170);
    deserializeCca(in, out.getDabTimeMutable(), majorVersion);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_LinkListElem& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8LinkType();
    out << in.getSFreqLabel();
    out << in.getU32ID();
    out << in.getU32EnsembleId();
    out << in.getU8Quality();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_LinkListElem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o171;
    in >> o171;
    out.setE8LinkType((::midw_ext_dabtuner_fi_types::T_e8_DAB_LinkType)o171);
    ::std::string o172;
    in >> o172;
    out.setSFreqLabel(o172);
    uint32 o173;
    in >> o173;
    out.setU32ID(o173);
    uint32 o174;
    in >> o174;
    out.setU32EnsembleId(o174);
    uint8 o175;
    in >> o175;
    out.setU8Quality(o175);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_AltFreqInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32Frequency();
    out << in.getS8FieldStrength();
    out << in.getU8Quality();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_AltFreqInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o176;
    in >> o176;
    out.setU32Frequency(o176);
    int8 o177;
    in >> o177;
    out.setS8FieldStrength(o177);
    uint8 o178;
    in >> o178;
    out.setU8Quality(o178);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_RdbId& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Cc();
    out << in.getU8Ltn();
    out << in.getU8Bsa();
    out << in.getU16Bsa();
    out << in.getU8Sid();
    out << (uint8) in.getBEncrypted();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_RdbId& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o179;
    in >> o179;
    out.setU8Cc(o179);
    uint8 o180;
    in >> o180;
    out.setU8Ltn(o180);
    uint8 o181;
    in >> o181;
    out.setU8Bsa(o181);
    uint16 o182;
    in >> o182;
    out.setU16Bsa(o182);
    uint8 o183;
    in >> o183;
    out.setU8Sid(o183);
    bool o184;
    in >> o184;
    out.setBEncrypted(o184);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_TmcData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8TmcData1();
    out << in.getU8TmcData2();
    out << in.getU8TmcData3();
    out << in.getU8TmcData4();
    out << in.getU8TmcData5();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_TmcData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o185;
    in >> o185;
    out.setU8TmcData1(o185);
    uint8 o186;
    in >> o186;
    out.setU8TmcData2(o186);
    uint8 o187;
    in >> o187;
    out.setU8TmcData3(o187);
    uint8 o188;
    in >> o188;
    out.setU8TmcData4(o188);
    uint8 o189;
    in >> o189;
    out.setU8TmcData5(o189);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_Encryption& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBEncrypted();
    out << in.getU8EncId();
    out << in.getU8TestBits();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_Encryption& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o190;
    in >> o190;
    out.setBEncrypted(o190);
    uint8 o191;
    in >> o191;
    out.setU8EncId(o191);
    uint8 o192;
    in >> o192;
    out.setU8TestBits(o192);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_MsgSource& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getDabMediumTypeId();
    out << in.getU8Number();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_MsgSource& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o193;
    in >> o193;
    out.setDabMediumTypeId((::midw_ext_dabtuner_fi_types::T_e8_DAB_TmcMediumType)o193);
    uint8 o194;
    in >> o194;
    out.setU8Number(o194);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_TmcInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRdbId(), out, majorVersion);
    out << in.getS16Ecc();
    out << in.getU16Aid();
    {
        uint32 o195 = static_cast<uint32>(in.getTmcData().size());
        out << o195;
        ::std::vector< uint8 >::const_iterator o196;
        for (o196 = in.getTmcData().begin(); o196 != in.getTmcData().end(); ++o196) {
            out << (*o196);
        }
    }
    out << in.getU16ProgramId();
    serializeCca(in.getDabEncryption(), out, majorVersion);
    serializeCca(in.getDabMsgSource(), out, majorVersion);
    out << in.getSProgramServiceName();
    out << in.getSServiceProviderName();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_TmcInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRdbIdMutable(), majorVersion);
    int16 o197;
    in >> o197;
    out.setS16Ecc(o197);
    uint16 o198;
    in >> o198;
    out.setU16Aid(o198);
    {
        uint32 o199;
        in >> o199;
        out.getTmcDataMutable().clear ();
        out.getTmcDataMutable().reserve (o199);
        for (uint32 o200 = 0; o200 < o199; o200++) {
            uint8 o201;
            in >> o201;
            out.getTmcDataMutable().push_back(o201);
        }
    }
    uint16 o202;
    in >> o202;
    out.setU16ProgramId(o202);
    deserializeCca(in, out.getDabEncryptionMutable(), majorVersion);
    deserializeCca(in, out.getDabMsgSourceMutable(), majorVersion);
    ::std::string o203;
    in >> o203;
    out.setSProgramServiceName(o203);
    ::std::string o204;
    in >> o204;
    out.setSServiceProviderName(o204);
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_EnsembleTmcInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32EnsembleId();
    out << in.getU8Quality();
    out << in.getU8NumberOfRdbIds();
    {
        uint32 o205 = static_cast<uint32>(in.getRdbIdList().size());
        out << o205;
        ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_RdbId >::const_iterator o206;
        for (o206 = in.getRdbIdList().begin(); o206 != in.getRdbIdList().end(); ++o206) {
            serializeCca((*o206), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_EnsembleTmcInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o207;
    in >> o207;
    out.setU32EnsembleId(o207);
    uint8 o208;
    in >> o208;
    out.setU8Quality(o208);
    uint8 o209;
    in >> o209;
    out.setU8NumberOfRdbIds(o209);
    {
        uint32 o210;
        in >> o210;
        out.getRdbIdListMutable().clear ();
        out.getRdbIdListMutable().reserve (o210);
        for (uint32 o211 = 0; o211 < o210; o211++) {
            ::midw_ext_dabtuner_fi_types::T_DAB_RdbId o212;
            deserializeCca(in, o212, majorVersion);
            out.getRdbIdListMutable().push_back (o212);
        }
    }
}

void serializeCca(const ::midw_ext_dabtuner_fi_types::T_DAB_TpegUriChannel& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSTpegUriChn();
    out << (uint16) in.getDabUriSelectState();
    out << (uint8) in.getBActive();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_ext_dabtuner_fi_types::T_DAB_TpegUriChannel& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o213;
    in >> o213;
    out.setSTpegUriChn(o213);
    uint16 o214;
    in >> o214;
    out.setDabUriSelectState((::midw_ext_dabtuner_fi_types::T_e8_DAB_UriSelectState)o214);
    bool o215;
    in >> o215;
    out.setBActive(o215);
}

