/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "midw_diagnostics_fi_typesConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * Types midw_diagnostics_fi_types
 */

using namespace ::asf::stream::json;

namespace midw_diagnostics_fi_types {

bool T_DiagProtocol_Parse (const char *str, size_t length, T_DiagProtocol &value)
{
    static stringEntry entries[] = {
        {3,"UDS", 0U},
        {5,"GMLAN", 1U},
        {7,"UNKNOWN", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_DiagProtocol_Name (T_DiagProtocol value)
{
    static const char* enumerationLiterals[] = {
        "UDS",
        "GMLAN",
        "Unknown",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_DiagProtocol_IsValid (T_DiagProtocol value)
{
    switch (value) {
    case T_DiagProtocol__Unknown:
    case T_DiagProtocol__UDS:
    case T_DiagProtocol__GMLAN:
        return true;
    default:
        return false;
    }
}

bool T_e8_Store_Parse (const char *str, size_t length, T_e8_Store &value)
{
    static stringEntry entries[] = {
        {8,"VOLATILE", 0U},
        {9,"UNDEFINED", 255U},
        {10,"PERSISTENT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_Store_Name (T_e8_Store value)
{
    static const char* enumerationLiterals[] = {
        "Volatile",
        "Persistent",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_Store_IsValid (T_e8_Store value)
{
    switch (value) {
    case T_e8_Store__Undefined:
    case T_e8_Store__Volatile:
    case T_e8_Store__Persistent:
        return true;
    default:
        return false;
    }
}

bool T_e8_RouteCalculationCommand_Parse (const char *str, size_t length, T_e8_RouteCalculationCommand &value)
{
    static stringEntry entries[] = {
        {9,"UNDEFINED", 255U},
        {13,"CALCULATEONLY", 1U},
        {14,"SETDESTINATION", 3U},
        {16,"ABORTCALCULATION", 127U},
        {18,"SETCURRENTPOSITION", 2U},
        {24,"SETPOSITIONSANDCALCULATE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_RouteCalculationCommand_Name (T_e8_RouteCalculationCommand value)
{
    static const char* enumerationLiterals[] = {
        "SetPositionsAndCalculate",
        "CalculateOnly",
        "SetCurrentPosition",
        "SetDestination",
        "AbortCalculation",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        127U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_RouteCalculationCommand_IsValid (T_e8_RouteCalculationCommand value)
{
    switch (value) {
    case T_e8_RouteCalculationCommand__Undefined:
    case T_e8_RouteCalculationCommand__SetPositionsAndCalculate:
    case T_e8_RouteCalculationCommand__CalculateOnly:
    case T_e8_RouteCalculationCommand__SetCurrentPosition:
    case T_e8_RouteCalculationCommand__SetDestination:
    case T_e8_RouteCalculationCommand__AbortCalculation:
        return true;
    default:
        return false;
    }
}

bool T_e8_RouteCalculationStatus_Parse (const char *str, size_t length, T_e8_RouteCalculationStatus &value)
{
    static stringEntry entries[] = {
        {9,"UNDEFINED", 255U},
        {17,"CALCULATIONFAILED", 1U},
        {17,"DESTINATIONNOTSET", 3U},
        {19,"CALCULATIONCOMPLETE", 0U},
        {21,"CURRENTPOSITIONNOTSET", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_RouteCalculationStatus_Name (T_e8_RouteCalculationStatus value)
{
    static const char* enumerationLiterals[] = {
        "CalculationComplete",
        "CalculationFailed",
        "CurrentPositionNotSet",
        "DestinationNotSet",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_RouteCalculationStatus_IsValid (T_e8_RouteCalculationStatus value)
{
    switch (value) {
    case T_e8_RouteCalculationStatus__Undefined:
    case T_e8_RouteCalculationStatus__CalculationComplete:
    case T_e8_RouteCalculationStatus__CalculationFailed:
    case T_e8_RouteCalculationStatus__CurrentPositionNotSet:
    case T_e8_RouteCalculationStatus__DestinationNotSet:
        return true;
    default:
        return false;
    }
}

bool T_e8_Language_Parse (const char *str, size_t length, T_e8_Language &value)
{
    static stringEntry entries[] = {
        {5,"CZECH", 19U},
        {5,"DUTCH", 2U},
        {5,"GREEK", 16U},
        {6,"DANISH", 10U},
        {6,"FRENCH", 4U},
        {6,"GERMAN", 1U},
        {6,"POLISH", 18U},
        {7,"CHINESE", 20U},
        {7,"FINNISH", 14U},
        {7,"ITALIAN", 7U},
        {7,"SPANISH", 5U},
        {7,"SWEDISH", 9U},
        {7,"TURKISH", 17U},
        {8,"JAPANESE", 6U},
        {9,"NORWEGIAN", 15U},
        {9,"PORTUGESE", 11U},
        {9,"UNDEFINED", 255U},
        {13,"ENGLISHMETRIC", 3U},
        {15,"ENGLISHIMPERIAL", 12U},
        {16,"ENGLISHMETRICUSA", 8U},
        {18,"ENGLISHIMPERIALUSA", 13U},
    };

    return lookupInStringEntryTable (str, length, entries, 21, (unsigned int&) value);
}

const char* T_e8_Language_Name (T_e8_Language value)
{
    static const char* enumerationLiterals[] = {
        "German",
        "Dutch",
        "EnglishMetric",
        "French",
        "Spanish",
        "Japanese",
        "Italian",
        "EnglishMetricUSA",
        "Swedish",
        "Danish",
        "Portugese",
        "EnglishImperial",
        "EnglishImperialUSA",
        "Finnish",
        "Norwegian",
        "Greek",
        "Turkish",
        "Polish",
        "Czech",
        "Chinese",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 21, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_Language_IsValid (T_e8_Language value)
{
    switch (value) {
    case T_e8_Language__Undefined:
    case T_e8_Language__German:
    case T_e8_Language__Dutch:
    case T_e8_Language__EnglishMetric:
    case T_e8_Language__French:
    case T_e8_Language__Spanish:
    case T_e8_Language__Japanese:
    case T_e8_Language__Italian:
    case T_e8_Language__EnglishMetricUSA:
    case T_e8_Language__Swedish:
    case T_e8_Language__Danish:
    case T_e8_Language__Portugese:
    case T_e8_Language__EnglishImperial:
    case T_e8_Language__EnglishImperialUSA:
    case T_e8_Language__Finnish:
    case T_e8_Language__Norwegian:
    case T_e8_Language__Greek:
    case T_e8_Language__Turkish:
    case T_e8_Language__Polish:
    case T_e8_Language__Czech:
    case T_e8_Language__Chinese:
        return true;
    default:
        return false;
    }
}

bool T_e8_Country_Parse (const char *str, size_t length, T_e8_Country &value)
{
    static stringEntry entries[] = {
        {3,"USA", 1U},
        {5,"ITALY", 39U},
        {5,"JAPAN", 81U},
        {5,"SPAIN", 34U},
        {6,"FRANCE", 33U},
        {6,"SWEDEN", 46U},
        {7,"BELGIUM", 32U},
        {7,"DENMARK", 45U},
        {7,"GERMANY", 49U},
        {8,"PORTUGAL", 51U},
        {9,"UNDEFINED", 255U},
        {10,"LUXEMBOURG", 52U},
        {11,"NETHERLANDS", 31U},
        {11,"SWITZERLAND", 41U},
        {12,"GREATBRITAIN", 44U},
    };

    return lookupInStringEntryTable (str, length, entries, 15, (unsigned int&) value);
}

const char* T_e8_Country_Name (T_e8_Country value)
{
    static const char* enumerationLiterals[] = {
        "USA",
        "Netherlands",
        "Belgium",
        "France",
        "Spain",
        "Italy",
        "Switzerland",
        "GreatBritain",
        "Denmark",
        "Sweden",
        "Germany",
        "Portugal",
        "Luxembourg",
        "Japan",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        1U,
        31U,
        32U,
        33U,
        34U,
        39U,
        41U,
        44U,
        45U,
        46U,
        49U,
        51U,
        52U,
        81U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 15, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_Country_IsValid (T_e8_Country value)
{
    switch (value) {
    case T_e8_Country__Undefined:
    case T_e8_Country__USA:
    case T_e8_Country__Netherlands:
    case T_e8_Country__Belgium:
    case T_e8_Country__France:
    case T_e8_Country__Spain:
    case T_e8_Country__Italy:
    case T_e8_Country__Switzerland:
    case T_e8_Country__GreatBritain:
    case T_e8_Country__Denmark:
    case T_e8_Country__Sweden:
    case T_e8_Country__Germany:
    case T_e8_Country__Portugal:
    case T_e8_Country__Luxembourg:
    case T_e8_Country__Japan:
        return true;
    default:
        return false;
    }
}

bool T_e8_LanguageSubsystem_Parse (const char *str, size_t length, T_e8_LanguageSubsystem &value)
{
    static stringEntry entries[] = {
        {3,"HMI", 0U},
        {3,"SDS", 1U},
        {9,"UNDEFINED", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_LanguageSubsystem_Name (T_e8_LanguageSubsystem value)
{
    static const char* enumerationLiterals[] = {
        "HMI",
        "SDS",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_LanguageSubsystem_IsValid (T_e8_LanguageSubsystem value)
{
    switch (value) {
    case T_e8_LanguageSubsystem__Undefined:
    case T_e8_LanguageSubsystem__HMI:
    case T_e8_LanguageSubsystem__SDS:
        return true;
    default:
        return false;
    }
}

bool T_e8_TestScreens_Parse (const char *str, size_t length, T_e8_TestScreens &value)
{
    static stringEntry entries[] = {
        {6,"RGB_OK", 17U},
        {7,"LATTICE", 81U},
        {7,"RGB_NOK", 16U},
        {8,"COLOURED", 6U},
        {8,"PLAINRED", 3U},
        {8,"SCREEN_7", 7U},
        {8,"SCREEN_8", 8U},
        {8,"SCREEN_9", 9U},
        {9,"PLAINBLUE", 5U},
        {9,"UNDEFINED", 255U},
        {10,"PLAINBLACK", 2U},
        {10,"PLAINGREEN", 4U},
        {10,"PLAINWHITE", 1U},
        {11,"RGB_REPDARK", 18U},
        {11,"TEFSPECIAL1", 146U},
        {11,"TEFSPECIAL2", 147U},
        {12,"NOTESTSCREEN", 0U},
        {13,"DIAGNOSISMASK", 10U},
        {16,"COLOURGRADIATION", 80U},
        {19,"LEFTBLACKRIGHTWHITE", 97U},
        {19,"LEFTWHITERIGHTBLACK", 96U},
        {19,"PIXELWISECHESSBOARD", 98U},
    };

    return lookupInStringEntryTable (str, length, entries, 22, (unsigned int&) value);
}

const char* T_e8_TestScreens_Name (T_e8_TestScreens value)
{
    static const char* enumerationLiterals[] = {
        "NoTestScreen",
        "PlainWhite",
        "PlainBlack",
        "PlainRed",
        "PlainGreen",
        "PlainBlue",
        "Coloured",
        "Screen_7",
        "Screen_8",
        "Screen_9",
        "DiagnosisMask",
        "RGB_Nok",
        "RGB_Ok",
        "RGB_repdark",
        "ColourGradiation",
        "Lattice",
        "LeftWhiteRightBlack",
        "LeftBlackRightWhite",
        "PixelwiseChessboard",
        "TEFSpecial1",
        "TEFSpecial2",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        16U,
        17U,
        18U,
        80U,
        81U,
        96U,
        97U,
        98U,
        146U,
        147U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 22, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TestScreens_IsValid (T_e8_TestScreens value)
{
    switch (value) {
    case T_e8_TestScreens__Undefined:
    case T_e8_TestScreens__NoTestScreen:
    case T_e8_TestScreens__PlainWhite:
    case T_e8_TestScreens__PlainBlack:
    case T_e8_TestScreens__PlainRed:
    case T_e8_TestScreens__PlainGreen:
    case T_e8_TestScreens__PlainBlue:
    case T_e8_TestScreens__Coloured:
    case T_e8_TestScreens__Screen_7:
    case T_e8_TestScreens__Screen_8:
    case T_e8_TestScreens__Screen_9:
    case T_e8_TestScreens__DiagnosisMask:
    case T_e8_TestScreens__ColourGradiation:
    case T_e8_TestScreens__Lattice:
    case T_e8_TestScreens__LeftWhiteRightBlack:
    case T_e8_TestScreens__LeftBlackRightWhite:
    case T_e8_TestScreens__PixelwiseChessboard:
    case T_e8_TestScreens__TEFSpecial1:
    case T_e8_TestScreens__TEFSpecial2:
    case T_e8_TestScreens__RGB_Nok:
    case T_e8_TestScreens__RGB_Ok:
    case T_e8_TestScreens__RGB_repdark:
        return true;
    default:
        return false;
    }
}

bool T_e8_TroubleCodeType_Parse (const char *str, size_t length, T_e8_TroubleCodeType &value)
{
    static stringEntry entries[] = {
        {3,"DTC", 0U},
        {3,"ITC", 1U},
        {9,"UNDEFINED", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_TroubleCodeType_Name (T_e8_TroubleCodeType value)
{
    static const char* enumerationLiterals[] = {
        "DTC",
        "ITC",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TroubleCodeType_IsValid (T_e8_TroubleCodeType value)
{
    switch (value) {
    case T_e8_TroubleCodeType__Undefined:
    case T_e8_TroubleCodeType__DTC:
    case T_e8_TroubleCodeType__ITC:
        return true;
    default:
        return false;
    }
}

bool T_e8_TestRoutines_Parse (const char *str, size_t length, T_e8_TestRoutines &value)
{
    static stringEntry entries[] = {
        {8,"CDIFTEST", 0U},
        {8,"GYROTEST", 7U},
        {9,"DVDIFTEST", 1U},
        {9,"UNDEFINED", 255U},
        {10,"FMSEEKTEST", 6U},
        {11,"SPEAKERTEST", 10U},
        {11,"TWEETERTEST", 9U},
        {14,"GPSANTENNATEST", 8U},
        {15,"CDREADTESTSHORT", 2U},
        {16,"DVDREADTESTSHORT", 3U},
        {16,"ONDEMANDSELFTEST", 11U},
        {19,"CDREADTESTINTENSIVE", 4U},
        {20,"DVDREADTESTINTENSIVE", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 13, (unsigned int&) value);
}

const char* T_e8_TestRoutines_Name (T_e8_TestRoutines value)
{
    static const char* enumerationLiterals[] = {
        "CDIFTest",
        "DVDIFTest",
        "CDReadTestShort",
        "DVDReadTestShort",
        "CDReadTestIntensive",
        "DVDReadTestIntensive",
        "FMSeekTest",
        "GyroTest",
        "GPSAntennaTest",
        "TweeterTest",
        "SpeakerTest",
        "OnDemandSelfTest",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 13, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TestRoutines_IsValid (T_e8_TestRoutines value)
{
    switch (value) {
    case T_e8_TestRoutines__Undefined:
    case T_e8_TestRoutines__CDIFTest:
    case T_e8_TestRoutines__DVDIFTest:
    case T_e8_TestRoutines__CDReadTestShort:
    case T_e8_TestRoutines__DVDReadTestShort:
    case T_e8_TestRoutines__CDReadTestIntensive:
    case T_e8_TestRoutines__DVDReadTestIntensive:
    case T_e8_TestRoutines__FMSeekTest:
    case T_e8_TestRoutines__GyroTest:
    case T_e8_TestRoutines__GPSAntennaTest:
    case T_e8_TestRoutines__TweeterTest:
    case T_e8_TestRoutines__SpeakerTest:
    case T_e8_TestRoutines__OnDemandSelfTest:
        return true;
    default:
        return false;
    }
}

bool T_e8_DefaultSettingsCategories_Parse (const char *str, size_t length, T_e8_DefaultSettingsCategories &value)
{
    static stringEntry entries[] = {
        {4,"AMFM", 0U},
        {5,"CDAUX", 1U},
        {6,"NAVMAP", 2U},
        {9,"UNDEFINED", 255U},
        {13,"VOLUMEDISPLAY", 4U},
        {17,"DESTINATIONMEMORY", 3U},
        {21,"RESTORE_RADIO_SETTING", 7U},
        {22,"CLEAR_ALL_PRIVATE_DATA", 6U},
        {23,"RESTORE_VEHICLE_SETTING", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 9, (unsigned int&) value);
}

const char* T_e8_DefaultSettingsCategories_Name (T_e8_DefaultSettingsCategories value)
{
    static const char* enumerationLiterals[] = {
        "AMFM",
        "CDAUX",
        "NAVMAP",
        "DestinationMemory",
        "VolumeDisplay",
        "RESTORE_VEHICLE_SETTING",
        "CLEAR_ALL_PRIVATE_DATA",
        "RESTORE_RADIO_SETTING",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 9, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_DefaultSettingsCategories_IsValid (T_e8_DefaultSettingsCategories value)
{
    switch (value) {
    case T_e8_DefaultSettingsCategories__Undefined:
    case T_e8_DefaultSettingsCategories__AMFM:
    case T_e8_DefaultSettingsCategories__CDAUX:
    case T_e8_DefaultSettingsCategories__NAVMAP:
    case T_e8_DefaultSettingsCategories__DestinationMemory:
    case T_e8_DefaultSettingsCategories__VolumeDisplay:
    case T_e8_DefaultSettingsCategories__RESTORE_VEHICLE_SETTING:
    case T_e8_DefaultSettingsCategories__CLEAR_ALL_PRIVATE_DATA:
    case T_e8_DefaultSettingsCategories__RESTORE_RADIO_SETTING:
        return true;
    default:
        return false;
    }
}

bool T_e8_TroubleCodeStatus_Parse (const char *str, size_t length, T_e8_TroubleCodeStatus &value)
{
    static stringEntry entries[] = {
        {6,"ACTIVE", 1U},
        {8,"INACTIVE", 0U},
        {9,"UNDEFINED", 255U},
        {9,"WASACTIVE", 4U},
        {11,"NOTCOMPLETE", 2U},
        {17,"ACTIVENOTCOMPLETE", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_TroubleCodeStatus_Name (T_e8_TroubleCodeStatus value)
{
    static const char* enumerationLiterals[] = {
        "InActive",
        "Active",
        "NotComplete",
        "ActiveNotComplete",
        "WasActive",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TroubleCodeStatus_IsValid (T_e8_TroubleCodeStatus value)
{
    switch (value) {
    case T_e8_TroubleCodeStatus__Undefined:
    case T_e8_TroubleCodeStatus__InActive:
    case T_e8_TroubleCodeStatus__Active:
    case T_e8_TroubleCodeStatus__NotComplete:
    case T_e8_TroubleCodeStatus__ActiveNotComplete:
    case T_e8_TroubleCodeStatus__WasActive:
        return true;
    default:
        return false;
    }
}

bool T_e16_Language_Parse (const char *str, size_t length, T_e16_Language &value)
{
    static stringEntry entries[] = {
        {4,"THAI", 24U},
        {5,"CZECH", 20U},
        {5,"DUTCH", 6U},
        {6,"DANISH", 2U},
        {6,"FRENCH", 7U},
        {6,"GERMAN", 5U},
        {6,"POLISH", 19U},
        {7,"CHINESE", 26U},
        {7,"ENGLISH", 4U},
        {7,"FINNISH", 3U},
        {7,"ITALIAN", 8U},
        {7,"RUSSIAN", 18U},
        {7,"SPANISH", 9U},
        {7,"SWEDISH", 1U},
        {7,"TURKISH", 17U},
        {8,"JAPANESE", 14U},
        {9,"HUNGARIAN", 16U},
        {9,"NORWEGIAN", 21U},
        {9,"TAIWANESE", 27U},
        {9,"UNDEFINED", 65535U},
        {9,"USENGLISH", 11U},
        {10,"PORTUGUESE", 10U},
        {12,"LATINSPANISH", 22U},
        {14,"CANADIANFRENCH", 12U},
        {16,"PORTUGUESEBRAZIL", 13U},
        {17,"AUSTRALIANENGLISH", 23U},
        {18,"ASIAPACIFICENGLISH", 25U},
        {22,"ENGLISHWITHNUMBERCODES", 15U},
    };

    return lookupInStringEntryTable (str, length, entries, 28, (unsigned int&) value);
}

const char* T_e16_Language_Name (T_e16_Language value)
{
    static const char* enumerationLiterals[] = {
        "Swedish",
        "Danish",
        "Finnish",
        "English",
        "German",
        "Dutch",
        "French",
        "Italian",
        "Spanish",
        "Portuguese",
        "USEnglish",
        "CanadianFrench",
        "PortugueseBrazil",
        "Japanese",
        "EnglishWithNumberCodes",
        "Hungarian",
        "Turkish",
        "Russian",
        "Polish",
        "Czech",
        "Norwegian",
        "LatinSpanish",
        "AustralianEnglish",
        "Thai",
        "AsiaPacificEnglish",
        "Chinese",
        "Taiwanese",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        27U,
        65535U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 28, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e16_Language_IsValid (T_e16_Language value)
{
    switch (value) {
    case T_e16_Language__Undefined:
    case T_e16_Language__Swedish:
    case T_e16_Language__Danish:
    case T_e16_Language__Finnish:
    case T_e16_Language__English:
    case T_e16_Language__German:
    case T_e16_Language__Dutch:
    case T_e16_Language__French:
    case T_e16_Language__Italian:
    case T_e16_Language__Spanish:
    case T_e16_Language__Portuguese:
    case T_e16_Language__USEnglish:
    case T_e16_Language__CanadianFrench:
    case T_e16_Language__PortugueseBrazil:
    case T_e16_Language__Japanese:
    case T_e16_Language__EnglishWithNumberCodes:
    case T_e16_Language__Hungarian:
    case T_e16_Language__Turkish:
    case T_e16_Language__Russian:
    case T_e16_Language__Polish:
    case T_e16_Language__Czech:
    case T_e16_Language__Norwegian:
    case T_e16_Language__LatinSpanish:
    case T_e16_Language__AustralianEnglish:
    case T_e16_Language__Thai:
    case T_e16_Language__AsiaPacificEnglish:
    case T_e16_Language__Chinese:
    case T_e16_Language__Taiwanese:
        return true;
    default:
        return false;
    }
}

bool T_e16_SpeedLock_Parse (const char *str, size_t length, T_e16_SpeedLock &value)
{
    static stringEntry entries[] = {
        {6,"ACTIVE", 2U},
        {8,"INACTIVE", 1U},
        {9,"UNDEFINED", 65535U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e16_SpeedLock_Name (T_e16_SpeedLock value)
{
    static const char* enumerationLiterals[] = {
        "Inactive",
        "Active",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        65535U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e16_SpeedLock_IsValid (T_e16_SpeedLock value)
{
    switch (value) {
    case T_e16_SpeedLock__Undefined:
    case T_e16_SpeedLock__Inactive:
    case T_e16_SpeedLock__Active:
        return true;
    default:
        return false;
    }
}

bool T_e8_DefSetMode_Parse (const char *str, size_t length, T_e8_DefSetMode &value)
{
    static stringEntry entries[] = {
        {12,"DEFSET_START", 7U},
        {14,"DEFSET_SRC_GET", 4U},
        {15,"DEFSET_COMPLETE", 8U},
        {16,"DEFSET_SRC_UPREG", 2U},
        {17,"DEFSET_SRC_CODING", 5U},
        {18,"DEFSET_SRC_NOT_DEF", 255U},
        {18,"DEFSET_SRC_SET_OEM", 9U},
        {18,"DEFSET_SRC_SET_TEF", 1U},
        {19,"DEFSET_SRC_RELUPREG", 3U},
        {19,"DEFSET_SRC_SET_USER", 0U},
        {22,"DEFSET_SRC_CALIBRATION", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 11, (unsigned int&) value);
}

const char* T_e8_DefSetMode_Name (T_e8_DefSetMode value)
{
    static const char* enumerationLiterals[] = {
        "DEFSET_SRC_SET_USER",
        "DEFSET_SRC_SET_TEF",
        "DEFSET_SRC_UPREG",
        "DEFSET_SRC_RELUPREG",
        "DEFSET_SRC_GET",
        "DEFSET_SRC_CODING",
        "DEFSET_SRC_CALIBRATION",
        "DEFSET_START",
        "DEFSET_COMPLETE",
        "DEFSET_SRC_SET_OEM",
        "DEFSET_SRC_NOT_DEF",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 11, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_DefSetMode_IsValid (T_e8_DefSetMode value)
{
    switch (value) {
    case T_e8_DefSetMode__DEFSET_SRC_NOT_DEF:
    case T_e8_DefSetMode__DEFSET_SRC_SET_USER:
    case T_e8_DefSetMode__DEFSET_SRC_SET_TEF:
    case T_e8_DefSetMode__DEFSET_SRC_UPREG:
    case T_e8_DefSetMode__DEFSET_SRC_RELUPREG:
    case T_e8_DefSetMode__DEFSET_SRC_GET:
    case T_e8_DefSetMode__DEFSET_SRC_CODING:
    case T_e8_DefSetMode__DEFSET_SRC_CALIBRATION:
    case T_e8_DefSetMode__DEFSET_START:
    case T_e8_DefSetMode__DEFSET_COMPLETE:
    case T_e8_DefSetMode__DEFSET_SRC_SET_OEM:
        return true;
    default:
        return false;
    }
}

bool T_e8_DefSetServiceStatus_Parse (const char *str, size_t length, T_e8_DefSetServiceStatus &value)
{
    static stringEntry entries[] = {
        {19,"DEFSET_STATE_FAILED", 1U},
        {22,"DEFSET_STATE_CONFIRMED", 0U},
        {22,"DEFSET_STATE_UNDEFINED", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DefSetServiceStatus_Name (T_e8_DefSetServiceStatus value)
{
    static const char* enumerationLiterals[] = {
        "DEFSET_STATE_CONFIRMED",
        "DEFSET_STATE_FAILED",
        "DEFSET_STATE_UNDEFINED",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_DefSetServiceStatus_IsValid (T_e8_DefSetServiceStatus value)
{
    switch (value) {
    case T_e8_DefSetServiceStatus__DEFSET_STATE_UNDEFINED:
    case T_e8_DefSetServiceStatus__DEFSET_STATE_CONFIRMED:
    case T_e8_DefSetServiceStatus__DEFSET_STATE_FAILED:
        return true;
    default:
        return false;
    }
}

bool T_e8_DefSetGroups_Parse (const char *str, size_t length, T_e8_DefSetGroups &value)
{
    static stringEntry entries[] = {
        {16,"DEFSET_GROUP_ALL", 31U},
        {19,"DEFSET_GROUP__RADIO", 6U},
        {22,"DEFSET_GROUP_UNDEFIEND", 255U},
        {25,"DEFSET_GROUP__MAINTENANCE", 13U},
        {27,"DEFSET_GROUP__OFFICE__CLOCK", 14U},
        {30,"DEFSET_GROUP__HMI_OUTLINE__TTS", 17U},
        {31,"DEFSET_GROUP__INFOTAINMENT__CDC", 12U},
        {31,"DEFSET_GROUP__INFOTAINMENT__MP3", 11U},
        {32,"DEFSET_GROUP__HMI_OUTLINE__COLOR", 30U},
        {33,"DEFSET_GROUP__INFOTAINMENT__AUDIO", 9U},
        {34,"DEFSET_GROUP__HMI_OUTLINE__DIMMING", 20U},
        {35,"DEFSET_GROUP__HMI_OUTLINE__LANGUAGE", 16U},
        {36,"DEFSET_GROUP__INFOTAINMENT__AUDIO_CD", 10U},
        {37,"DEFSET_GROUP__NAVIGATION__MAP_DISPLAY", 4U},
        {40,"DEFSET_GROUP__NAVIGATION__ROUTE_GUIDANCE", 3U},
        {41,"DEFSET_GROUP__SYSTEM_AND_POWER_MANAGEMENT", 21U},
        {43,"DEFSET_GROUP__NAVIGATION__ROUTE_CALCULATION", 1U},
        {44,"DEFSET_GROUP__HMI_OUTLINE__VOICE_RECOGNITION", 18U},
        {44,"DEFSET_GROUP__NAVIGATION__DESTINATION_MEMORY", 0U},
        {45,"DEFSET_GROUP__DEVELOPMENT_AND_TEST_MODE__MAUS", 22U},
        {45,"DEFSET_GROUP__HMI_OUTLINE__DISPLAY_ADJUSTMENT", 19U},
        {47,"DEFSET_GROUP__NAVIGATION__PRESENTATION_FUNCTION", 5U},
        {47,"DEFSET_GROUP__NAVIGATION__TURN_BY_TURN_GUIDANCE", 25U},
        {48,"DEFSET_GROUP__INFOTAINMENT__SOURCE_HANDLING__AUX", 8U},
        {49,"DEFSET_GROUP__HMI_OUTLINE__USER_OPERATION_SERVICE", 15U},
        {54,"DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__MAP_INFORMATION", 29U},
        {56,"DEFSET_GROUP__INFOTAINMENT__SOURCE_HANDLING__LAST_SOURCE", 7U},
        {59,"DEFSET_GROUP__NAVIGATION__ROUTE_CALUCULATION__ROUTE_OPTIONS", 24U},
        {61,"DEFSET_GROUP__NAVIGATION__ROUTE_CALUCULATION__ROUTE_CRITRERIA", 23U},
        {63,"DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__MAP_DISPLAY_MANIPULATION", 28U},
        {63,"DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__ORIENTATION_AND_CLIPPING", 27U},
        {63,"DEFSET_GROUP__NAVIGATION__ROUTE_AND_TRAFFIC_MESSAGE_INFORMATION", 2U},
        {68,"DEFSET_GROUP__NAVIGATION__TURN_BY_TURN_GUIDANCE__GRAPHIC_DRIVING_REC", 26U},
    };

    return lookupInStringEntryTable (str, length, entries, 33, (unsigned int&) value);
}

const char* T_e8_DefSetGroups_Name (T_e8_DefSetGroups value)
{
    static const char* enumerationLiterals[] = {
        "DEFSET_GROUP__NAVIGATION__DESTINATION_MEMORY",
        "DEFSET_GROUP__NAVIGATION__ROUTE_CALCULATION",
        "DEFSET_GROUP__NAVIGATION__ROUTE_AND_TRAFFIC_MESSAGE_INFORMATION",
        "DEFSET_GROUP__NAVIGATION__ROUTE_GUIDANCE",
        "DEFSET_GROUP__NAVIGATION__MAP_DISPLAY",
        "DEFSET_GROUP__NAVIGATION__PRESENTATION_FUNCTION",
        "DEFSET_GROUP__RADIO",
        "DEFSET_GROUP__INFOTAINMENT__SOURCE_HANDLING__LAST_SOURCE",
        "DEFSET_GROUP__INFOTAINMENT__SOURCE_HANDLING__AUX",
        "DEFSET_GROUP__INFOTAINMENT__AUDIO",
        "DEFSET_GROUP__INFOTAINMENT__AUDIO_CD",
        "DEFSET_GROUP__INFOTAINMENT__MP3",
        "DEFSET_GROUP__INFOTAINMENT__CDC",
        "DEFSET_GROUP__MAINTENANCE",
        "DEFSET_GROUP__OFFICE__CLOCK",
        "DEFSET_GROUP__HMI_OUTLINE__USER_OPERATION_SERVICE",
        "DEFSET_GROUP__HMI_OUTLINE__LANGUAGE",
        "DEFSET_GROUP__HMI_OUTLINE__TTS",
        "DEFSET_GROUP__HMI_OUTLINE__VOICE_RECOGNITION",
        "DEFSET_GROUP__HMI_OUTLINE__DISPLAY_ADJUSTMENT",
        "DEFSET_GROUP__HMI_OUTLINE__DIMMING",
        "DEFSET_GROUP__SYSTEM_AND_POWER_MANAGEMENT",
        "DEFSET_GROUP__DEVELOPMENT_AND_TEST_MODE__MAUS",
        "DEFSET_GROUP__NAVIGATION__ROUTE_CALUCULATION__ROUTE_CRITRERIA",
        "DEFSET_GROUP__NAVIGATION__ROUTE_CALUCULATION__ROUTE_OPTIONS",
        "DEFSET_GROUP__NAVIGATION__TURN_BY_TURN_GUIDANCE",
        "DEFSET_GROUP__NAVIGATION__TURN_BY_TURN_GUIDANCE__GRAPHIC_DRIVING_REC",
        "DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__ORIENTATION_AND_CLIPPING",
        "DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__MAP_DISPLAY_MANIPULATION",
        "DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__MAP_INFORMATION",
        "DEFSET_GROUP__HMI_OUTLINE__COLOR",
        "DEFSET_GROUP_ALL",
        "DEFSET_GROUP_UNDEFIEND",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        27U,
        28U,
        29U,
        30U,
        31U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 33, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_DefSetGroups_IsValid (T_e8_DefSetGroups value)
{
    switch (value) {
    case T_e8_DefSetGroups__DEFSET_GROUP_UNDEFIEND:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__DESTINATION_MEMORY:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__ROUTE_CALCULATION:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__ROUTE_AND_TRAFFIC_MESSAGE_INFORMATION:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__ROUTE_GUIDANCE:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__MAP_DISPLAY:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__PRESENTATION_FUNCTION:
    case T_e8_DefSetGroups__DEFSET_GROUP__RADIO:
    case T_e8_DefSetGroups__DEFSET_GROUP__INFOTAINMENT__SOURCE_HANDLING__LAST_SOURCE:
    case T_e8_DefSetGroups__DEFSET_GROUP__INFOTAINMENT__SOURCE_HANDLING__AUX:
    case T_e8_DefSetGroups__DEFSET_GROUP__INFOTAINMENT__AUDIO:
    case T_e8_DefSetGroups__DEFSET_GROUP__INFOTAINMENT__AUDIO_CD:
    case T_e8_DefSetGroups__DEFSET_GROUP__INFOTAINMENT__MP3:
    case T_e8_DefSetGroups__DEFSET_GROUP__INFOTAINMENT__CDC:
    case T_e8_DefSetGroups__DEFSET_GROUP__MAINTENANCE:
    case T_e8_DefSetGroups__DEFSET_GROUP__OFFICE__CLOCK:
    case T_e8_DefSetGroups__DEFSET_GROUP__HMI_OUTLINE__USER_OPERATION_SERVICE:
    case T_e8_DefSetGroups__DEFSET_GROUP__HMI_OUTLINE__LANGUAGE:
    case T_e8_DefSetGroups__DEFSET_GROUP__HMI_OUTLINE__TTS:
    case T_e8_DefSetGroups__DEFSET_GROUP__HMI_OUTLINE__VOICE_RECOGNITION:
    case T_e8_DefSetGroups__DEFSET_GROUP__HMI_OUTLINE__DISPLAY_ADJUSTMENT:
    case T_e8_DefSetGroups__DEFSET_GROUP__HMI_OUTLINE__DIMMING:
    case T_e8_DefSetGroups__DEFSET_GROUP__SYSTEM_AND_POWER_MANAGEMENT:
    case T_e8_DefSetGroups__DEFSET_GROUP__DEVELOPMENT_AND_TEST_MODE__MAUS:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__ROUTE_CALUCULATION__ROUTE_CRITRERIA:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__ROUTE_CALUCULATION__ROUTE_OPTIONS:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__TURN_BY_TURN_GUIDANCE:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__TURN_BY_TURN_GUIDANCE__GRAPHIC_DRIVING_REC:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__ORIENTATION_AND_CLIPPING:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__MAP_DISPLAY_MANIPULATION:
    case T_e8_DefSetGroups__DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__MAP_INFORMATION:
    case T_e8_DefSetGroups__DEFSET_GROUP__HMI_OUTLINE__COLOR:
    case T_e8_DefSetGroups__DEFSET_GROUP_ALL:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiagMausSetup_Parse (const char *str, size_t length, T_e8_DiagMausSetup &value)
{
    static stringEntry entries[] = {
        {19,"MAUS_STATE_RESERVED", 0U},
        {20,"MAUS_STATE_UNDEFINED", 255U},
        {27,"MAUS_STATE_ENABLE_TIME_SLOT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DiagMausSetup_Name (T_e8_DiagMausSetup value)
{
    static const char* enumerationLiterals[] = {
        "MAUS_STATE_RESERVED",
        "MAUS_STATE_ENABLE_TIME_SLOT",
        "MAUS_STATE_UNDEFINED",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_DiagMausSetup_IsValid (T_e8_DiagMausSetup value)
{
    switch (value) {
    case T_e8_DiagMausSetup__MAUS_STATE_UNDEFINED:
    case T_e8_DiagMausSetup__MAUS_STATE_RESERVED:
    case T_e8_DiagMausSetup__MAUS_STATE_ENABLE_TIME_SLOT:
        return true;
    default:
        return false;
    }
}

bool T_e8_SimulatedKeys_Parse (const char *str, size_t length, T_e8_SimulatedKeys &value)
{
    static stringEntry entries[] = {
        {15,"KEY_CODE_NAVKEY", 7U},
        {18,"KEY_CODE_SOFTKEY_1", 1U},
        {18,"KEY_CODE_SOFTKEY_2", 2U},
        {18,"KEY_CODE_SOFTKEY_3", 3U},
        {18,"KEY_CODE_SOFTKEY_4", 4U},
        {18,"KEY_CODE_SOFTKEY_5", 5U},
        {18,"KEY_CODE_SOFTKEY_6", 6U},
        {21,"KEY_CODE_ROTARY_RIGHT", 8U},
        {26,"KEY_CODE_SOFTKEY_UNDEFINED", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 9, (unsigned int&) value);
}

const char* T_e8_SimulatedKeys_Name (T_e8_SimulatedKeys value)
{
    static const char* enumerationLiterals[] = {
        "KEY_CODE_SOFTKEY_1",
        "KEY_CODE_SOFTKEY_2",
        "KEY_CODE_SOFTKEY_3",
        "KEY_CODE_SOFTKEY_4",
        "KEY_CODE_SOFTKEY_5",
        "KEY_CODE_SOFTKEY_6",
        "KEY_CODE_NAVKEY",
        "KEY_CODE_ROTARY_RIGHT",
        "KEY_CODE_SOFTKEY_UNDEFINED",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 9, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_SimulatedKeys_IsValid (T_e8_SimulatedKeys value)
{
    switch (value) {
    case T_e8_SimulatedKeys__KEY_CODE_SOFTKEY_UNDEFINED:
    case T_e8_SimulatedKeys__KEY_CODE_SOFTKEY_1:
    case T_e8_SimulatedKeys__KEY_CODE_SOFTKEY_2:
    case T_e8_SimulatedKeys__KEY_CODE_SOFTKEY_3:
    case T_e8_SimulatedKeys__KEY_CODE_SOFTKEY_4:
    case T_e8_SimulatedKeys__KEY_CODE_SOFTKEY_5:
    case T_e8_SimulatedKeys__KEY_CODE_SOFTKEY_6:
    case T_e8_SimulatedKeys__KEY_CODE_NAVKEY:
    case T_e8_SimulatedKeys__KEY_CODE_ROTARY_RIGHT:
        return true;
    default:
        return false;
    }
}

bool T_e8_RCtrlSource_Parse (const char *str, size_t length, T_e8_RCtrlSource &value)
{
    static stringEntry entries[] = {
        {13,"RCTRL_SRC_HMI", 0U},
        {13,"RCTRL_SRC_TEF", 1U},
        {17,"RCTRL_SRC_UNKNOWN", 255U},
        {18,"RCTRL_SRC_CUSTOMER", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_RCtrlSource_Name (T_e8_RCtrlSource value)
{
    static const char* enumerationLiterals[] = {
        "RCTRL_SRC_HMI",
        "RCTRL_SRC_TEF",
        "RCTRL_SRC_CUSTOMER",
        "RCTRL_SRC_UNKNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_RCtrlSource_IsValid (T_e8_RCtrlSource value)
{
    switch (value) {
    case T_e8_RCtrlSource__RCTRL_SRC_UNKNOWN:
    case T_e8_RCtrlSource__RCTRL_SRC_HMI:
    case T_e8_RCtrlSource__RCTRL_SRC_TEF:
    case T_e8_RCtrlSource__RCTRL_SRC_CUSTOMER:
        return true;
    default:
        return false;
    }
}

bool T_e8_RCtrlCommand_Parse (const char *str, size_t length, T_e8_RCtrlCommand &value)
{
    static stringEntry entries[] = {
        {18,"RCTRL_CMD_ACTIVATE", 1U},
        {20,"RCTRL_CMD_DEACTIVATE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_RCtrlCommand_Name (T_e8_RCtrlCommand value)
{
    static const char* enumerationLiterals[] = {
        "RCTRL_CMD_DEACTIVATE",
        "RCTRL_CMD_ACTIVATE",
    };

    if (T_e8_RCtrlCommand_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RCtrlCommand_IsValid (T_e8_RCtrlCommand value)
{
    switch (value) {
    case T_e8_RCtrlCommand__RCTRL_CMD_DEACTIVATE:
    case T_e8_RCtrlCommand__RCTRL_CMD_ACTIVATE:
        return true;
    default:
        return false;
    }
}

bool T_e8_RCtrlSignal_Parse (const char *str, size_t length, T_e8_RCtrlSignal &value)
{
    static stringEntry entries[] = {
        {13,"RCTRL_SIG_ALL", 255U},
        {22,"RCTRL_SIG_AM_FREQUENCY", 1U},
        {22,"RCTRL_SIG_AUDIO_SOURCE", 2U},
        {22,"RCTRL_SIG_AUDIO_VOLUME", 3U},
        {22,"RCTRL_SIG_FM_FREQUENCY", 0U},
        {33,"RCTRL_SIG_AUDIO_FADER_AND_BALANCE", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_RCtrlSignal_Name (T_e8_RCtrlSignal value)
{
    static const char* enumerationLiterals[] = {
        "RCTRL_SIG_FM_FREQUENCY",
        "RCTRL_SIG_AM_FREQUENCY",
        "RCTRL_SIG_AUDIO_SOURCE",
        "RCTRL_SIG_AUDIO_VOLUME",
        "RCTRL_SIG_AUDIO_FADER_AND_BALANCE",
        "RCTRL_SIG_ALL",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_RCtrlSignal_IsValid (T_e8_RCtrlSignal value)
{
    switch (value) {
    case T_e8_RCtrlSignal__RCTRL_SIG_ALL:
    case T_e8_RCtrlSignal__RCTRL_SIG_FM_FREQUENCY:
    case T_e8_RCtrlSignal__RCTRL_SIG_AM_FREQUENCY:
    case T_e8_RCtrlSignal__RCTRL_SIG_AUDIO_SOURCE:
    case T_e8_RCtrlSignal__RCTRL_SIG_AUDIO_VOLUME:
    case T_e8_RCtrlSignal__RCTRL_SIG_AUDIO_FADER_AND_BALANCE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiagRVCSignal_Parse (const char *str, size_t length, T_e8_DiagRVCSignal &value)
{
    static stringEntry entries[] = {
        {19,"EXT_VIDEO_SIGNAL_ON", 0U},
        {20,"EXT_VIDEO_SIGNAL_OFF", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DiagRVCSignal_Name (T_e8_DiagRVCSignal value)
{
    static const char* enumerationLiterals[] = {
        "EXT_VIDEO_SIGNAL_ON",
        "EXT_VIDEO_SIGNAL_OFF",
    };

    if (T_e8_DiagRVCSignal_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiagRVCSignal_IsValid (T_e8_DiagRVCSignal value)
{
    switch (value) {
    case T_e8_DiagRVCSignal__EXT_VIDEO_SIGNAL_ON:
    case T_e8_DiagRVCSignal__EXT_VIDEO_SIGNAL_OFF:
        return true;
    default:
        return false;
    }
}

bool T_e8_CalibrationTable_Parse (const char *str, size_t length, T_e8_CalibrationTable &value)
{
    static stringEntry entries[] = {
        {26,"CALIBRATION_TABLE_ID_BRAND", 7U},
        {27,"CALIBRATION_TABLE_ID_SYSTEM", 2U},
        {28,"CALIBRATION_TABLE_ID_COUNTRY", 8U},
        {30,"CALIBRATION_TABLE_ID_BLUETOOTH", 4U},
        {36,"CALIBRATION_TABLE_ID_NAVIGATION_ICON", 6U},
        {37,"CALIBRATION_TABLE_ID_HAND_FREE_TUNING", 10U},
        {38,"CALIBRATION_TABLE_ID_DISPLAY_INTERFACE", 3U},
        {38,"CALIBRATION_TABLE_ID_NAVIGATION_SYSTEM", 5U},
        {39,"CALIBRATION_TABLE_ID_REAR_VISION_CAMERA", 11U},
        {39,"CALIBRATION_TABLE_ID_SPEECH_RECOGNITION", 9U},
    };

    return lookupInStringEntryTable (str, length, entries, 10, (unsigned int&) value);
}

const char* T_e8_CalibrationTable_Name (T_e8_CalibrationTable value)
{
    static const char* enumerationLiterals[] = {
        "CALIBRATION_TABLE_ID_SYSTEM",
        "CALIBRATION_TABLE_ID_DISPLAY_INTERFACE",
        "CALIBRATION_TABLE_ID_BLUETOOTH",
        "CALIBRATION_TABLE_ID_NAVIGATION_SYSTEM",
        "CALIBRATION_TABLE_ID_NAVIGATION_ICON",
        "CALIBRATION_TABLE_ID_BRAND",
        "CALIBRATION_TABLE_ID_COUNTRY",
        "CALIBRATION_TABLE_ID_SPEECH_RECOGNITION",
        "CALIBRATION_TABLE_ID_HAND_FREE_TUNING",
        "CALIBRATION_TABLE_ID_REAR_VISION_CAMERA",
    };

    if (T_e8_CalibrationTable_IsValid(value))
        return enumerationLiterals[value - 2U];
    else
        return NULL;
}

bool T_e8_CalibrationTable_IsValid (T_e8_CalibrationTable value)
{
    switch (value) {
    case T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM:
    case T_e8_CalibrationTable__CALIBRATION_TABLE_ID_DISPLAY_INTERFACE:
    case T_e8_CalibrationTable__CALIBRATION_TABLE_ID_BLUETOOTH:
    case T_e8_CalibrationTable__CALIBRATION_TABLE_ID_NAVIGATION_SYSTEM:
    case T_e8_CalibrationTable__CALIBRATION_TABLE_ID_NAVIGATION_ICON:
    case T_e8_CalibrationTable__CALIBRATION_TABLE_ID_BRAND:
    case T_e8_CalibrationTable__CALIBRATION_TABLE_ID_COUNTRY:
    case T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SPEECH_RECOGNITION:
    case T_e8_CalibrationTable__CALIBRATION_TABLE_ID_HAND_FREE_TUNING:
    case T_e8_CalibrationTable__CALIBRATION_TABLE_ID_REAR_VISION_CAMERA:
        return true;
    default:
        return false;
    }
}

bool T_e8_CalibrationTimeStampMonth_Parse (const char *str, size_t length, T_e8_CalibrationTimeStampMonth &value)
{
    static stringEntry entries[] = {
        {3,"MAY", 5U},
        {4,"JULY", 7U},
        {4,"JUNE", 6U},
        {5,"APRIL", 4U},
        {5,"MARCH", 3U},
        {6,"AUGUST", 8U},
        {7,"JANUARY", 1U},
        {7,"OCTOBER", 10U},
        {7,"UNKNOWN", 0U},
        {8,"DECEMBER", 12U},
        {8,"FEBRUARY", 2U},
        {8,"NOVEMBER", 11U},
        {9,"SEPTEMBER", 9U},
    };

    return lookupInStringEntryTable (str, length, entries, 13, (unsigned int&) value);
}

const char* T_e8_CalibrationTimeStampMonth_Name (T_e8_CalibrationTimeStampMonth value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "January",
        "February",
        "March",
        "April",
        "May",
        "June",
        "July",
        "August",
        "September",
        "October",
        "November",
        "December",
    };

    if (T_e8_CalibrationTimeStampMonth_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_CalibrationTimeStampMonth_IsValid (T_e8_CalibrationTimeStampMonth value)
{
    switch (value) {
    case T_e8_CalibrationTimeStampMonth__Unknown:
    case T_e8_CalibrationTimeStampMonth__January:
    case T_e8_CalibrationTimeStampMonth__February:
    case T_e8_CalibrationTimeStampMonth__March:
    case T_e8_CalibrationTimeStampMonth__April:
    case T_e8_CalibrationTimeStampMonth__May:
    case T_e8_CalibrationTimeStampMonth__June:
    case T_e8_CalibrationTimeStampMonth__July:
    case T_e8_CalibrationTimeStampMonth__August:
    case T_e8_CalibrationTimeStampMonth__September:
    case T_e8_CalibrationTimeStampMonth__October:
    case T_e8_CalibrationTimeStampMonth__November:
    case T_e8_CalibrationTimeStampMonth__December:
        return true;
    default:
        return false;
    }
}

bool T_e8_CalibrationParameterSize_Parse (const char *str, size_t length, T_e8_CalibrationParameterSize &value)
{
    static stringEntry entries[] = {
        {20,"CALIBRATION_SIZE_BIT", 0U},
        {21,"CALIBRATION_SIZE_BYTE", 1U},
        {21,"CALIBRATION_SIZE_WORD", 2U},
        {22,"CALIBRATION_SIZE_DWORD", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_CalibrationParameterSize_Name (T_e8_CalibrationParameterSize value)
{
    static const char* enumerationLiterals[] = {
        "CALIBRATION_SIZE_BIT",
        "CALIBRATION_SIZE_BYTE",
        "CALIBRATION_SIZE_WORD",
        "CALIBRATION_SIZE_DWORD",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        4U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_CalibrationParameterSize_IsValid (T_e8_CalibrationParameterSize value)
{
    switch (value) {
    case T_e8_CalibrationParameterSize__CALIBRATION_SIZE_BIT:
    case T_e8_CalibrationParameterSize__CALIBRATION_SIZE_BYTE:
    case T_e8_CalibrationParameterSize__CALIBRATION_SIZE_WORD:
    case T_e8_CalibrationParameterSize__CALIBRATION_SIZE_DWORD:
        return true;
    default:
        return false;
    }
}

bool T_e8_KdsViaUsbUpdateStatus_Parse (const char *str, size_t length, T_e8_KdsViaUsbUpdateStatus &value)
{
    static stringEntry entries[] = {
        {9,"UNDEFINED", 255U},
        {18,"CONFIGUPDATEFAILED", 2U},
        {19,"CONFIGUPDATESUCCESS", 1U},
        {22,"CONFIGUPDATEINPROGRESS", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_KdsViaUsbUpdateStatus_Name (T_e8_KdsViaUsbUpdateStatus value)
{
    static const char* enumerationLiterals[] = {
        "ConfigUpdateInProgress",
        "ConfigUpdateSuccess",
        "ConfigUpdateFailed",
        "Undefined",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_KdsViaUsbUpdateStatus_IsValid (T_e8_KdsViaUsbUpdateStatus value)
{
    switch (value) {
    case T_e8_KdsViaUsbUpdateStatus__Undefined:
    case T_e8_KdsViaUsbUpdateStatus__ConfigUpdateInProgress:
    case T_e8_KdsViaUsbUpdateStatus__ConfigUpdateSuccess:
    case T_e8_KdsViaUsbUpdateStatus__ConfigUpdateFailed:
        return true;
    default:
        return false;
    }
}

bool T_AntiTheftStatus_Parse (const char *str, size_t length, T_AntiTheftStatus &value)
{
    static stringEntry entries[] = {
        {7,"INVALID", 255U},
        {9,"HU_LOCKED", 1U},
        {11,"HU_UNLOCKED", 0U},
        {11,"VID_MISSING", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_AntiTheftStatus_Name (T_AntiTheftStatus value)
{
    static const char* enumerationLiterals[] = {
        "HU_UNLOCKED",
        "HU_LOCKED",
        "VID_MISSING",
        "INVALID",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_AntiTheftStatus_IsValid (T_AntiTheftStatus value)
{
    switch (value) {
    case T_AntiTheftStatus__HU_UNLOCKED:
    case T_AntiTheftStatus__HU_LOCKED:
    case T_AntiTheftStatus__VID_MISSING:
    case T_AntiTheftStatus__INVALID:
        return true;
    default:
        return false;
    }
}

} // namespace midw_diagnostics_fi_types
