/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "Midw_Diagnostics_FICca.h"
#include "Midw_Diagnostics_FIJson.h"
#include "Midw_Diagnostics_FIProxy.h"
#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "midw_diagnostics_fi_types.h"
#include "midw_diagnostics_fi_typesConst.h"
#include <string>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace Midw_Diagnostics_FI {

/*static*/ ::asf::core::Logger Midw_Diagnostics_FIProxy::_logger ("/Midw_Diagnostics_FI/Midw_Diagnostics_FIProxy");


class Midw_Diagnostics_FIProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Midw_Diagnostics_FIProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Midw_Diagnostics_FIProxy> proxy = ::boost::static_pointer_cast<Midw_Diagnostics_FIProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_TestMessage: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::TestMessageResult);
                                setActAndLogResult(message, "TestMessage", reinterpret_cast<act_t>(this), _logger);
                                ((TestMessageCallbackIF*) _callback)->onTestMessageResult (proxy, ::boost::static_pointer_cast<TestMessageResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::TestMessageError);
                                setActAndLogError(message, "TestMessage", reinterpret_cast<act_t>(this), _logger);
                                ((TestMessageCallbackIF*) _callback)->onTestMessageError (proxy, ::boost::static_pointer_cast<TestMessageError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DiagRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::DiagRequestResult);
                                setActAndLogResult(message, "DiagRequest", reinterpret_cast<act_t>(this), _logger);
                                ((DiagRequestCallbackIF*) _callback)->onDiagRequestResult (proxy, ::boost::static_pointer_cast<DiagRequestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::DiagRequestError);
                                setActAndLogError(message, "DiagRequest", reinterpret_cast<act_t>(this), _logger);
                                ((DiagRequestCallbackIF*) _callback)->onDiagRequestError (proxy, ::boost::static_pointer_cast<DiagRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ReadDiagLog: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::ReadDiagLogResult);
                                setActAndLogResult(message, "ReadDiagLog", reinterpret_cast<act_t>(this), _logger);
                                ((ReadDiagLogCallbackIF*) _callback)->onReadDiagLogResult (proxy, ::boost::static_pointer_cast<ReadDiagLogResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::ReadDiagLogError);
                                setActAndLogError(message, "ReadDiagLog", reinterpret_cast<act_t>(this), _logger);
                                ((ReadDiagLogCallbackIF*) _callback)->onReadDiagLogError (proxy, ::boost::static_pointer_cast<ReadDiagLogError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ClearDiagLog: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::ClearDiagLogResult);
                                setActAndLogResult(message, "ClearDiagLog", reinterpret_cast<act_t>(this), _logger);
                                ((ClearDiagLogCallbackIF*) _callback)->onClearDiagLogResult (proxy, ::boost::static_pointer_cast<ClearDiagLogResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::ClearDiagLogError);
                                setActAndLogError(message, "ClearDiagLog", reinterpret_cast<act_t>(this), _logger);
                                ((ClearDiagLogCallbackIF*) _callback)->onClearDiagLogError (proxy, ::boost::static_pointer_cast<ClearDiagLogError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StartDiagnosticTest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::StartDiagnosticTestResult);
                                setActAndLogResult(message, "StartDiagnosticTest", reinterpret_cast<act_t>(this), _logger);
                                ((StartDiagnosticTestCallbackIF*) _callback)->onStartDiagnosticTestResult (proxy, ::boost::static_pointer_cast<StartDiagnosticTestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::StartDiagnosticTestError);
                                setActAndLogError(message, "StartDiagnosticTest", reinterpret_cast<act_t>(this), _logger);
                                ((StartDiagnosticTestCallbackIF*) _callback)->onStartDiagnosticTestError (proxy, ::boost::static_pointer_cast<StartDiagnosticTestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetDefaultSettings: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetDefaultSettingsResult);
                                setActAndLogResult(message, "SetDefaultSettings", reinterpret_cast<act_t>(this), _logger);
                                ((SetDefaultSettingsCallbackIF*) _callback)->onSetDefaultSettingsResult (proxy, ::boost::static_pointer_cast<SetDefaultSettingsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetDefaultSettingsError);
                                setActAndLogError(message, "SetDefaultSettings", reinterpret_cast<act_t>(this), _logger);
                                ((SetDefaultSettingsCallbackIF*) _callback)->onSetDefaultSettingsError (proxy, ::boost::static_pointer_cast<SetDefaultSettingsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EnableTimeSlot: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::EnableTimeSlotResult);
                                setActAndLogResult(message, "EnableTimeSlot", reinterpret_cast<act_t>(this), _logger);
                                ((EnableTimeSlotCallbackIF*) _callback)->onEnableTimeSlotResult (proxy, ::boost::static_pointer_cast<EnableTimeSlotResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::EnableTimeSlotError);
                                setActAndLogError(message, "EnableTimeSlot", reinterpret_cast<act_t>(this), _logger);
                                ((EnableTimeSlotCallbackIF*) _callback)->onEnableTimeSlotError (proxy, ::boost::static_pointer_cast<EnableTimeSlotError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StopDiagnosticTest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::StopDiagnosticTestResult);
                                setActAndLogResult(message, "StopDiagnosticTest", reinterpret_cast<act_t>(this), _logger);
                                ((StopDiagnosticTestCallbackIF*) _callback)->onStopDiagnosticTestResult (proxy, ::boost::static_pointer_cast<StopDiagnosticTestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::StopDiagnosticTestError);
                                setActAndLogError(message, "StopDiagnosticTest", reinterpret_cast<act_t>(this), _logger);
                                ((StopDiagnosticTestCallbackIF*) _callback)->onStopDiagnosticTestError (proxy, ::boost::static_pointer_cast<StopDiagnosticTestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetFactorySettings: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetFactorySettingsResult);
                                setActAndLogResult(message, "SetFactorySettings", reinterpret_cast<act_t>(this), _logger);
                                ((SetFactorySettingsCallbackIF*) _callback)->onSetFactorySettingsResult (proxy, ::boost::static_pointer_cast<SetFactorySettingsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetFactorySettingsError);
                                setActAndLogError(message, "SetFactorySettings", reinterpret_cast<act_t>(this), _logger);
                                ((SetFactorySettingsCallbackIF*) _callback)->onSetFactorySettingsError (proxy, ::boost::static_pointer_cast<SetFactorySettingsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetResetToSupplierDefaultConfig: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetResetToSupplierDefaultConfigResult);
                                setActAndLogResult(message, "SetResetToSupplierDefaultConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetResetToSupplierDefaultConfigCallbackIF*) _callback)->onSetResetToSupplierDefaultConfigResult (proxy, ::boost::static_pointer_cast<SetResetToSupplierDefaultConfigResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetResetToSupplierDefaultConfigError);
                                setActAndLogError(message, "SetResetToSupplierDefaultConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetResetToSupplierDefaultConfigCallbackIF*) _callback)->onSetResetToSupplierDefaultConfigError (proxy, ::boost::static_pointer_cast<SetResetToSupplierDefaultConfigError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetRunTimeSourceData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetRunTimeSourceDataResult);
                                setActAndLogResult(message, "SetRunTimeSourceData", reinterpret_cast<act_t>(this), _logger);
                                ((SetRunTimeSourceDataCallbackIF*) _callback)->onSetRunTimeSourceDataResult (proxy, ::boost::static_pointer_cast<SetRunTimeSourceDataResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetRunTimeSourceDataError);
                                setActAndLogError(message, "SetRunTimeSourceData", reinterpret_cast<act_t>(this), _logger);
                                ((SetRunTimeSourceDataCallbackIF*) _callback)->onSetRunTimeSourceDataError (proxy, ::boost::static_pointer_cast<SetRunTimeSourceDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetFactorySettingsNew: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetFactorySettingsNewResult);
                                setActAndLogResult(message, "SetFactorySettingsNew", reinterpret_cast<act_t>(this), _logger);
                                ((SetFactorySettingsNewCallbackIF*) _callback)->onSetFactorySettingsNewResult (proxy, ::boost::static_pointer_cast<SetFactorySettingsNewResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetFactorySettingsNewError);
                                setActAndLogError(message, "SetFactorySettingsNew", reinterpret_cast<act_t>(this), _logger);
                                ((SetFactorySettingsNewCallbackIF*) _callback)->onSetFactorySettingsNewError (proxy, ::boost::static_pointer_cast<SetFactorySettingsNewError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StartCalibrationSession: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::StartCalibrationSessionResult);
                                setActAndLogResult(message, "StartCalibrationSession", reinterpret_cast<act_t>(this), _logger);
                                ((StartCalibrationSessionCallbackIF*) _callback)->onStartCalibrationSessionResult (proxy, ::boost::static_pointer_cast<StartCalibrationSessionResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::StartCalibrationSessionError);
                                setActAndLogError(message, "StartCalibrationSession", reinterpret_cast<act_t>(this), _logger);
                                ((StartCalibrationSessionCallbackIF*) _callback)->onStartCalibrationSessionError (proxy, ::boost::static_pointer_cast<StartCalibrationSessionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StopCalibrationSession: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::StopCalibrationSessionResult);
                                setActAndLogResult(message, "StopCalibrationSession", reinterpret_cast<act_t>(this), _logger);
                                ((StopCalibrationSessionCallbackIF*) _callback)->onStopCalibrationSessionResult (proxy, ::boost::static_pointer_cast<StopCalibrationSessionResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::StopCalibrationSessionError);
                                setActAndLogError(message, "StopCalibrationSession", reinterpret_cast<act_t>(this), _logger);
                                ((StopCalibrationSessionCallbackIF*) _callback)->onStopCalibrationSessionError (proxy, ::boost::static_pointer_cast<StopCalibrationSessionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StartRouteCalculation: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::StartRouteCalculationStatus);
                                setActAndLogStatus(message, "StartRouteCalculation", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<StartRouteCalculationStatus> payload = ::boost::static_pointer_cast<StartRouteCalculationStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< StartRouteCalculationStatus >& refNullableStatus = proxy->_startRouteCalculation;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((StartRouteCalculationCallbackIF*) _callback)->onStartRouteCalculationStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((StartRouteCalculationCallbackIF*) _callback)->onStartRouteCalculationStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::StartRouteCalculationError);
                                setActAndLogError(message, "StartRouteCalculation", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((StartRouteCalculationCallbackIF*) _callback)->onStartRouteCalculationError(proxy, ::boost::static_pointer_cast<StartRouteCalculationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RouteCalculationResult: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::RouteCalculationResultStatus);
                                setActAndLogStatus(message, "RouteCalculationResult", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RouteCalculationResultStatus> payload = ::boost::static_pointer_cast<RouteCalculationResultStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RouteCalculationResultStatus >& refNullableStatus = proxy->_routeCalculationResult;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RouteCalculationResultCallbackIF*) _callback)->onRouteCalculationResultStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RouteCalculationResultCallbackIF*) _callback)->onRouteCalculationResultStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::RouteCalculationResultError);
                                setActAndLogError(message, "RouteCalculationResult", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RouteCalculationResultCallbackIF*) _callback)->onRouteCalculationResultError(proxy, ::boost::static_pointer_cast<RouteCalculationResultError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetLocaleStart: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetLocaleStartStatus);
                                setActAndLogStatus(message, "SetLocaleStart", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SetLocaleStartStatus> payload = ::boost::static_pointer_cast<SetLocaleStartStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SetLocaleStartStatus >& refNullableStatus = proxy->_setLocaleStart;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SetLocaleStartCallbackIF*) _callback)->onSetLocaleStartStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SetLocaleStartCallbackIF*) _callback)->onSetLocaleStartStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetLocaleStartError);
                                setActAndLogError(message, "SetLocaleStart", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SetLocaleStartCallbackIF*) _callback)->onSetLocaleStartError(proxy, ::boost::static_pointer_cast<SetLocaleStartError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetLocaleResult: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetLocaleResultStatus);
                                setActAndLogStatus(message, "SetLocaleResult", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SetLocaleResultStatus> payload = ::boost::static_pointer_cast<SetLocaleResultStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SetLocaleResultStatus >& refNullableStatus = proxy->_setLocaleResult;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SetLocaleResultCallbackIF*) _callback)->onSetLocaleResultStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SetLocaleResultCallbackIF*) _callback)->onSetLocaleResultStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetLocaleResultError);
                                setActAndLogError(message, "SetLocaleResult", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SetLocaleResultCallbackIF*) _callback)->onSetLocaleResultError(proxy, ::boost::static_pointer_cast<SetLocaleResultError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetLocale: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::GetLocaleStatus);
                                setActAndLogStatus(message, "GetLocale", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GetLocaleStatus> payload = ::boost::static_pointer_cast<GetLocaleStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GetLocaleStatus >& refNullableStatus = proxy->_getLocale;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GetLocaleCallbackIF*) _callback)->onGetLocaleStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GetLocaleCallbackIF*) _callback)->onGetLocaleStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::GetLocaleError);
                                setActAndLogError(message, "GetLocale", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GetLocaleCallbackIF*) _callback)->onGetLocaleError(proxy, ::boost::static_pointer_cast<GetLocaleError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetDisplay: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetDisplayStatus);
                                setActAndLogStatus(message, "SetDisplay", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SetDisplayStatus> payload = ::boost::static_pointer_cast<SetDisplayStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SetDisplayStatus >& refNullableStatus = proxy->_setDisplay;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SetDisplayCallbackIF*) _callback)->onSetDisplayStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SetDisplayCallbackIF*) _callback)->onSetDisplayStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetDisplayError);
                                setActAndLogError(message, "SetDisplay", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SetDisplayCallbackIF*) _callback)->onSetDisplayError(proxy, ::boost::static_pointer_cast<SetDisplayError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ConfigUpdateViaUSB: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::ConfigUpdateViaUSBStatus);
                                setActAndLogStatus(message, "ConfigUpdateViaUSB", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ConfigUpdateViaUSBStatus> payload = ::boost::static_pointer_cast<ConfigUpdateViaUSBStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ConfigUpdateViaUSBStatus >& refNullableStatus = proxy->_configUpdateViaUSB;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ConfigUpdateViaUSBCallbackIF*) _callback)->onConfigUpdateViaUSBStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::ConfigUpdateViaUSBError);
                                setActAndLogError(message, "ConfigUpdateViaUSB", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((ConfigUpdateViaUSBCallbackIF*) _callback)->onConfigUpdateViaUSBError(proxy, ::boost::static_pointer_cast<ConfigUpdateViaUSBError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AntiTheftStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::AntiTheftStatusStatus);
                                setActAndLogStatus(message, "AntiTheftStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AntiTheftStatusStatus> payload = ::boost::static_pointer_cast<AntiTheftStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AntiTheftStatusStatus >& refNullableStatus = proxy->_antiTheftStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AntiTheftStatusCallbackIF*) _callback)->onAntiTheftStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AntiTheftStatusCallbackIF*) _callback)->onAntiTheftStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::AntiTheftStatusError);
                                setActAndLogError(message, "AntiTheftStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AntiTheftStatusCallbackIF*) _callback)->onAntiTheftStatusError(proxy, ::boost::static_pointer_cast<AntiTheftStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AntiTheftUnlockHMI: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::AntiTheftUnlockHMIStatus);
                                setActAndLogStatus(message, "AntiTheftUnlockHMI", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AntiTheftUnlockHMIStatus> payload = ::boost::static_pointer_cast<AntiTheftUnlockHMIStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AntiTheftUnlockHMIStatus >& refNullableStatus = proxy->_antiTheftUnlockHMI;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AntiTheftUnlockHMICallbackIF*) _callback)->onAntiTheftUnlockHMIStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AntiTheftUnlockHMICallbackIF*) _callback)->onAntiTheftUnlockHMIStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::AntiTheftUnlockHMIError);
                                setActAndLogError(message, "AntiTheftUnlockHMI", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AntiTheftUnlockHMICallbackIF*) _callback)->onAntiTheftUnlockHMIError(proxy, ::boost::static_pointer_cast<AntiTheftUnlockHMIError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AntiTheftUnlockHU: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::AntiTheftUnlockHUStatus);
                                setActAndLogStatus(message, "AntiTheftUnlockHU", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AntiTheftUnlockHUStatus> payload = ::boost::static_pointer_cast<AntiTheftUnlockHUStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AntiTheftUnlockHUStatus >& refNullableStatus = proxy->_antiTheftUnlockHU;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AntiTheftUnlockHUCallbackIF*) _callback)->onAntiTheftUnlockHUStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AntiTheftUnlockHUCallbackIF*) _callback)->onAntiTheftUnlockHUStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::AntiTheftUnlockHUError);
                                setActAndLogError(message, "AntiTheftUnlockHU", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AntiTheftUnlockHUCallbackIF*) _callback)->onAntiTheftUnlockHUError(proxy, ::boost::static_pointer_cast<AntiTheftUnlockHUError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ClearDestinationMemory: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::ClearDestinationMemoryStatus);
                                setActAndLogStatus(message, "ClearDestinationMemory", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ClearDestinationMemoryStatus> payload = ::boost::static_pointer_cast<ClearDestinationMemoryStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ClearDestinationMemoryStatus >& refNullableStatus = proxy->_clearDestinationMemory;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ClearDestinationMemoryCallbackIF*) _callback)->onClearDestinationMemoryStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ClearDestinationMemoryCallbackIF*) _callback)->onClearDestinationMemoryStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::ClearDestinationMemoryError);
                                setActAndLogError(message, "ClearDestinationMemory", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ClearDestinationMemoryCallbackIF*) _callback)->onClearDestinationMemoryError(proxy, ::boost::static_pointer_cast<ClearDestinationMemoryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetDestinationMemorySize: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::GetDestinationMemorySizeStatus);
                                setActAndLogStatus(message, "GetDestinationMemorySize", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GetDestinationMemorySizeStatus> payload = ::boost::static_pointer_cast<GetDestinationMemorySizeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GetDestinationMemorySizeStatus >& refNullableStatus = proxy->_getDestinationMemorySize;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GetDestinationMemorySizeCallbackIF*) _callback)->onGetDestinationMemorySizeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GetDestinationMemorySizeCallbackIF*) _callback)->onGetDestinationMemorySizeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::GetDestinationMemorySizeError);
                                setActAndLogError(message, "GetDestinationMemorySize", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GetDestinationMemorySizeCallbackIF*) _callback)->onGetDestinationMemorySizeError(proxy, ::boost::static_pointer_cast<GetDestinationMemorySizeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SimulateKeyPress: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SimulateKeyPressStatus);
                                setActAndLogStatus(message, "SimulateKeyPress", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SimulateKeyPressStatus> payload = ::boost::static_pointer_cast<SimulateKeyPressStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SimulateKeyPressStatus >& refNullableStatus = proxy->_simulateKeyPress;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SimulateKeyPressCallbackIF*) _callback)->onSimulateKeyPressStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SimulateKeyPressCallbackIF*) _callback)->onSimulateKeyPressStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SimulateKeyPressError);
                                setActAndLogError(message, "SimulateKeyPress", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SimulateKeyPressCallbackIF*) _callback)->onSimulateKeyPressError(proxy, ::boost::static_pointer_cast<SimulateKeyPressError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ResetSecurity: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::ResetSecurityStatus);
                                setActAndLogStatus(message, "ResetSecurity", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ResetSecurityStatus> payload = ::boost::static_pointer_cast<ResetSecurityStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ResetSecurityStatus >& refNullableStatus = proxy->_resetSecurity;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ResetSecurityCallbackIF*) _callback)->onResetSecurityStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ResetSecurityCallbackIF*) _callback)->onResetSecurityStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::ResetSecurityError);
                                setActAndLogError(message, "ResetSecurity", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ResetSecurityCallbackIF*) _callback)->onResetSecurityError(proxy, ::boost::static_pointer_cast<ResetSecurityError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Language: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::LanguageStatus);
                                setActAndLogStatus(message, "Language", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<LanguageStatus> payload = ::boost::static_pointer_cast<LanguageStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< LanguageStatus >& refNullableStatus = proxy->_language;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((LanguageCallbackIF*) _callback)->onLanguageStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((LanguageCallbackIF*) _callback)->onLanguageStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::LanguageError);
                                setActAndLogError(message, "Language", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((LanguageCallbackIF*) _callback)->onLanguageError(proxy, ::boost::static_pointer_cast<LanguageError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SpeedLock: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SpeedLockStatus);
                                setActAndLogStatus(message, "SpeedLock", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SpeedLockStatus> payload = ::boost::static_pointer_cast<SpeedLockStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SpeedLockStatus >& refNullableStatus = proxy->_speedLock;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SpeedLockCallbackIF*) _callback)->onSpeedLockStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SpeedLockCallbackIF*) _callback)->onSpeedLockStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SpeedLockError);
                                setActAndLogError(message, "SpeedLock", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SpeedLockCallbackIF*) _callback)->onSpeedLockError(proxy, ::boost::static_pointer_cast<SpeedLockError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SpdLock: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SpdLockStatus);
                                setActAndLogStatus(message, "SpdLock", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SpdLockStatus> payload = ::boost::static_pointer_cast<SpdLockStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SpdLockStatus >& refNullableStatus = proxy->_spdLock;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SpdLockCallbackIF*) _callback)->onSpdLockStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SpdLockCallbackIF*) _callback)->onSpdLockStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SpdLockError);
                                setActAndLogError(message, "SpdLock", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SpdLockCallbackIF*) _callback)->onSpdLockError(proxy, ::boost::static_pointer_cast<SpdLockError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetRVCSignal: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetRVCSignalStatus);
                                setActAndLogStatus(message, "SetRVCSignal", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SetRVCSignalStatus> payload = ::boost::static_pointer_cast<SetRVCSignalStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SetRVCSignalStatus >& refNullableStatus = proxy->_setRVCSignal;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SetRVCSignalCallbackIF*) _callback)->onSetRVCSignalStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SetRVCSignalCallbackIF*) _callback)->onSetRVCSignalStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetRVCSignalError);
                                setActAndLogError(message, "SetRVCSignal", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SetRVCSignalCallbackIF*) _callback)->onSetRVCSignalError(proxy, ::boost::static_pointer_cast<SetRVCSignalError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RVCSignalStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::RVCSignalStatusStatus);
                                setActAndLogStatus(message, "RVCSignalStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RVCSignalStatusStatus> payload = ::boost::static_pointer_cast<RVCSignalStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RVCSignalStatusStatus >& refNullableStatus = proxy->_rVCSignalStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RVCSignalStatusCallbackIF*) _callback)->onRVCSignalStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RVCSignalStatusCallbackIF*) _callback)->onRVCSignalStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::RVCSignalStatusError);
                                setActAndLogError(message, "RVCSignalStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RVCSignalStatusCallbackIF*) _callback)->onRVCSignalStatusError(proxy, ::boost::static_pointer_cast<RVCSignalStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_KdsEntry: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::KdsEntryStatus);
                                setActAndLogStatus(message, "KdsEntry", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<KdsEntryStatus> payload = ::boost::static_pointer_cast<KdsEntryStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::boost::shared_ptr<KdsEntryRelUpReg> relUpRegPara = ::boost::static_pointer_cast<KdsEntryRelUpReg>(_message->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        Midw_Diagnostics_FIProxy::KdsEntryMap& refStatusMap = proxy->_kdsEntryMap;
                                        Midw_Diagnostics_FIProxy::KdsEntryMap::iterator it = refStatusMap.find(*relUpRegPara);
                                        if (it == refStatusMap.end()) {
                                            ((KdsEntryCallbackIF*) _callback)->onKdsEntryStatus(proxy, payload);
                                            refStatusMap[*relUpRegPara] = *payload.get();
                                        }
                                        else if (message.isLoopBack() == false || (*it).second == *payload.get()) {
                                            ((KdsEntryCallbackIF*) _callback)->onKdsEntryStatus(proxy, payload);
                                            (*it).second = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((KdsEntryCallbackIF*) _callback)->onKdsEntryStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::KdsEntryError);
                                setActAndLogError(message, "KdsEntry", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((KdsEntryCallbackIF*) _callback)->onKdsEntryError(proxy, ::boost::static_pointer_cast<KdsEntryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DiagConfigItem: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::DiagConfigItemStatus);
                                setActAndLogStatus(message, "DiagConfigItem", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DiagConfigItemStatus> payload = ::boost::static_pointer_cast<DiagConfigItemStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::boost::shared_ptr<DiagConfigItemRelUpReg> relUpRegPara = ::boost::static_pointer_cast<DiagConfigItemRelUpReg>(_message->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        Midw_Diagnostics_FIProxy::DiagConfigItemMap& refStatusMap = proxy->_diagConfigItemMap;
                                        Midw_Diagnostics_FIProxy::DiagConfigItemMap::iterator it = refStatusMap.find(*relUpRegPara);
                                        if (it == refStatusMap.end()) {
                                            ((DiagConfigItemCallbackIF*) _callback)->onDiagConfigItemStatus(proxy, payload);
                                            refStatusMap[*relUpRegPara] = *payload.get();
                                        }
                                        else if (message.isLoopBack() == false || (*it).second == *payload.get()) {
                                            ((DiagConfigItemCallbackIF*) _callback)->onDiagConfigItemStatus(proxy, payload);
                                            (*it).second = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DiagConfigItemCallbackIF*) _callback)->onDiagConfigItemStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::DiagConfigItemError);
                                setActAndLogError(message, "DiagConfigItem", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DiagConfigItemCallbackIF*) _callback)->onDiagConfigItemError(proxy, ::boost::static_pointer_cast<DiagConfigItemError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetFactorySettingsStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetFactorySettingsStatusStatus);
                                setActAndLogStatus(message, "SetFactorySettingsStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SetFactorySettingsStatusStatus> payload = ::boost::static_pointer_cast<SetFactorySettingsStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SetFactorySettingsStatusStatus >& refNullableStatus = proxy->_setFactorySettingsStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SetFactorySettingsStatusCallbackIF*) _callback)->onSetFactorySettingsStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SetFactorySettingsStatusCallbackIF*) _callback)->onSetFactorySettingsStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::SetFactorySettingsStatusError);
                                setActAndLogError(message, "SetFactorySettingsStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SetFactorySettingsStatusCallbackIF*) _callback)->onSetFactorySettingsStatusError(proxy, ::boost::static_pointer_cast<SetFactorySettingsStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RemoteControl: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::RemoteControlStatus);
                                setActAndLogStatus(message, "RemoteControl", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RemoteControlStatus> payload = ::boost::static_pointer_cast<RemoteControlStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RemoteControlStatus >& refNullableStatus = proxy->_remoteControl;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RemoteControlCallbackIF*) _callback)->onRemoteControlStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RemoteControlCallbackIF*) _callback)->onRemoteControlStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::RemoteControlError);
                                setActAndLogError(message, "RemoteControl", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RemoteControlCallbackIF*) _callback)->onRemoteControlError(proxy, ::boost::static_pointer_cast<RemoteControlError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CISswUpdateProcess: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::CISswUpdateProcessStatus);
                                setActAndLogStatus(message, "CISswUpdateProcess", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CISswUpdateProcessStatus> payload = ::boost::static_pointer_cast<CISswUpdateProcessStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CISswUpdateProcessStatus >& refNullableStatus = proxy->_cISswUpdateProcess;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CISswUpdateProcessCallbackIF*) _callback)->onCISswUpdateProcessStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CISswUpdateProcessCallbackIF*) _callback)->onCISswUpdateProcessStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::CISswUpdateProcessError);
                                setActAndLogError(message, "CISswUpdateProcess", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CISswUpdateProcessCallbackIF*) _callback)->onCISswUpdateProcessError(proxy, ::boost::static_pointer_cast<CISswUpdateProcessError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CISswUpdateStage2Process: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::CISswUpdateStage2ProcessStatus);
                                setActAndLogStatus(message, "CISswUpdateStage2Process", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CISswUpdateStage2ProcessStatus> payload = ::boost::static_pointer_cast<CISswUpdateStage2ProcessStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CISswUpdateStage2ProcessStatus >& refNullableStatus = proxy->_cISswUpdateStage2Process;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CISswUpdateStage2ProcessCallbackIF*) _callback)->onCISswUpdateStage2ProcessStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CISswUpdateStage2ProcessCallbackIF*) _callback)->onCISswUpdateStage2ProcessStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::CISswUpdateStage2ProcessError);
                                setActAndLogError(message, "CISswUpdateStage2Process", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CISswUpdateStage2ProcessCallbackIF*) _callback)->onCISswUpdateStage2ProcessError(proxy, ::boost::static_pointer_cast<CISswUpdateStage2ProcessError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CalibrationParameter: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::CalibrationParameterStatus);
                                setActAndLogStatus(message, "CalibrationParameter", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CalibrationParameterStatus> payload = ::boost::static_pointer_cast<CalibrationParameterStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CalibrationParameterStatus >& refNullableStatus = proxy->_calibrationParameter;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CalibrationParameterCallbackIF*) _callback)->onCalibrationParameterStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CalibrationParameterCallbackIF*) _callback)->onCalibrationParameterStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::CalibrationParameterError);
                                setActAndLogError(message, "CalibrationParameter", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CalibrationParameterCallbackIF*) _callback)->onCalibrationParameterError(proxy, ::boost::static_pointer_cast<CalibrationParameterError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PartNumber: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::PartNumberStatus);
                                setActAndLogStatus(message, "PartNumber", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<PartNumberStatus> payload = ::boost::static_pointer_cast<PartNumberStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< PartNumberStatus >& refNullableStatus = proxy->_partNumber;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((PartNumberCallbackIF*) _callback)->onPartNumberStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PartNumberCallbackIF*) _callback)->onPartNumberStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::Midw_Diagnostics_FI::PartNumberError);
                                setActAndLogError(message, "PartNumber", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PartNumberCallbackIF*) _callback)->onPartNumberError(proxy, ::boost::static_pointer_cast<PartNumberError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Midw_Diagnostics_FIProxy> proxy = ::boost::static_pointer_cast<Midw_Diagnostics_FIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_TestMessage: {
                ::boost::shared_ptr< TestMessageError > payload (new TestMessageError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TestMessage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((TestMessageCallbackIF*) _callback)->onTestMessageError (proxy, payload);
                return true;
            }
            case FID_DiagRequest: {
                ::boost::shared_ptr< DiagRequestError > payload (new DiagRequestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DiagRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DiagRequestCallbackIF*) _callback)->onDiagRequestError (proxy, payload);
                return true;
            }
            case FID_ReadDiagLog: {
                ::boost::shared_ptr< ReadDiagLogError > payload (new ReadDiagLogError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReadDiagLog", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ReadDiagLogCallbackIF*) _callback)->onReadDiagLogError (proxy, payload);
                return true;
            }
            case FID_ClearDiagLog: {
                ::boost::shared_ptr< ClearDiagLogError > payload (new ClearDiagLogError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClearDiagLog", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ClearDiagLogCallbackIF*) _callback)->onClearDiagLogError (proxy, payload);
                return true;
            }
            case FID_StartDiagnosticTest: {
                ::boost::shared_ptr< StartDiagnosticTestError > payload (new StartDiagnosticTestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartDiagnosticTest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((StartDiagnosticTestCallbackIF*) _callback)->onStartDiagnosticTestError (proxy, payload);
                return true;
            }
            case FID_SetDefaultSettings: {
                ::boost::shared_ptr< SetDefaultSettingsError > payload (new SetDefaultSettingsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetDefaultSettings", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetDefaultSettingsCallbackIF*) _callback)->onSetDefaultSettingsError (proxy, payload);
                return true;
            }
            case FID_EnableTimeSlot: {
                ::boost::shared_ptr< EnableTimeSlotError > payload (new EnableTimeSlotError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EnableTimeSlot", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((EnableTimeSlotCallbackIF*) _callback)->onEnableTimeSlotError (proxy, payload);
                return true;
            }
            case FID_StopDiagnosticTest: {
                ::boost::shared_ptr< StopDiagnosticTestError > payload (new StopDiagnosticTestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopDiagnosticTest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((StopDiagnosticTestCallbackIF*) _callback)->onStopDiagnosticTestError (proxy, payload);
                return true;
            }
            case FID_SetFactorySettings: {
                ::boost::shared_ptr< SetFactorySettingsError > payload (new SetFactorySettingsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFactorySettings", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetFactorySettingsCallbackIF*) _callback)->onSetFactorySettingsError (proxy, payload);
                return true;
            }
            case FID_SetResetToSupplierDefaultConfig: {
                ::boost::shared_ptr< SetResetToSupplierDefaultConfigError > payload (new SetResetToSupplierDefaultConfigError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetResetToSupplierDefaultConfig", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetResetToSupplierDefaultConfigCallbackIF*) _callback)->onSetResetToSupplierDefaultConfigError (proxy, payload);
                return true;
            }
            case FID_SetRunTimeSourceData: {
                ::boost::shared_ptr< SetRunTimeSourceDataError > payload (new SetRunTimeSourceDataError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRunTimeSourceData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetRunTimeSourceDataCallbackIF*) _callback)->onSetRunTimeSourceDataError (proxy, payload);
                return true;
            }
            case FID_SetFactorySettingsNew: {
                ::boost::shared_ptr< SetFactorySettingsNewError > payload (new SetFactorySettingsNewError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFactorySettingsNew", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetFactorySettingsNewCallbackIF*) _callback)->onSetFactorySettingsNewError (proxy, payload);
                return true;
            }
            case FID_StartCalibrationSession: {
                ::boost::shared_ptr< StartCalibrationSessionError > payload (new StartCalibrationSessionError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartCalibrationSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((StartCalibrationSessionCallbackIF*) _callback)->onStartCalibrationSessionError (proxy, payload);
                return true;
            }
            case FID_StopCalibrationSession: {
                ::boost::shared_ptr< StopCalibrationSessionError > payload (new StopCalibrationSessionError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopCalibrationSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((StopCalibrationSessionCallbackIF*) _callback)->onStopCalibrationSessionError (proxy, payload);
                return true;
            }
            case FID_StartRouteCalculation: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< StartRouteCalculationError > payload (new StartRouteCalculationError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartRouteCalculation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((StartRouteCalculationCallbackIF*) _callback)->onStartRouteCalculationError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RouteCalculationResult: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RouteCalculationResultError > payload (new RouteCalculationResultError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RouteCalculationResult", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RouteCalculationResultCallbackIF*) _callback)->onRouteCalculationResultError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SetLocaleStart: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SetLocaleStartError > payload (new SetLocaleStartError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocaleStart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SetLocaleStartCallbackIF*) _callback)->onSetLocaleStartError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SetLocaleResult: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SetLocaleResultError > payload (new SetLocaleResultError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocaleResult", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SetLocaleResultCallbackIF*) _callback)->onSetLocaleResultError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_GetLocale: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< GetLocaleError > payload (new GetLocaleError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetLocale", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GetLocaleCallbackIF*) _callback)->onGetLocaleError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SetDisplay: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SetDisplayError > payload (new SetDisplayError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetDisplay", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SetDisplayCallbackIF*) _callback)->onSetDisplayError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ConfigUpdateViaUSB: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< ConfigUpdateViaUSBError > payload (new ConfigUpdateViaUSBError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ConfigUpdateViaUSB", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ConfigUpdateViaUSBCallbackIF*) _callback)->onConfigUpdateViaUSBError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AntiTheftStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AntiTheftStatusError > payload (new AntiTheftStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AntiTheftStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AntiTheftStatusCallbackIF*) _callback)->onAntiTheftStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AntiTheftUnlockHMI: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AntiTheftUnlockHMIError > payload (new AntiTheftUnlockHMIError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AntiTheftUnlockHMI", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AntiTheftUnlockHMICallbackIF*) _callback)->onAntiTheftUnlockHMIError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AntiTheftUnlockHU: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AntiTheftUnlockHUError > payload (new AntiTheftUnlockHUError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AntiTheftUnlockHU", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AntiTheftUnlockHUCallbackIF*) _callback)->onAntiTheftUnlockHUError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ClearDestinationMemory: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ClearDestinationMemoryError > payload (new ClearDestinationMemoryError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClearDestinationMemory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ClearDestinationMemoryCallbackIF*) _callback)->onClearDestinationMemoryError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_GetDestinationMemorySize: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< GetDestinationMemorySizeError > payload (new GetDestinationMemorySizeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetDestinationMemorySize", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GetDestinationMemorySizeCallbackIF*) _callback)->onGetDestinationMemorySizeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SimulateKeyPress: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SimulateKeyPressError > payload (new SimulateKeyPressError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SimulateKeyPress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SimulateKeyPressCallbackIF*) _callback)->onSimulateKeyPressError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ResetSecurity: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ResetSecurityError > payload (new ResetSecurityError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResetSecurity", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ResetSecurityCallbackIF*) _callback)->onResetSecurityError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Language: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< LanguageError > payload (new LanguageError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Language", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((LanguageCallbackIF*) _callback)->onLanguageError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SpeedLock: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SpeedLockError > payload (new SpeedLockError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SpeedLock", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SpeedLockCallbackIF*) _callback)->onSpeedLockError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SpdLock: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SpdLockError > payload (new SpdLockError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SpdLock", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SpdLockCallbackIF*) _callback)->onSpdLockError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SetRVCSignal: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SetRVCSignalError > payload (new SetRVCSignalError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRVCSignal", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SetRVCSignalCallbackIF*) _callback)->onSetRVCSignalError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RVCSignalStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RVCSignalStatusError > payload (new RVCSignalStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RVCSignalStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RVCSignalStatusCallbackIF*) _callback)->onRVCSignalStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_KdsEntry: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< KdsEntryError > payload (new KdsEntryError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "KdsEntry", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((KdsEntryCallbackIF*) _callback)->onKdsEntryError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DiagConfigItem: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DiagConfigItemError > payload (new DiagConfigItemError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DiagConfigItem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DiagConfigItemCallbackIF*) _callback)->onDiagConfigItemError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SetFactorySettingsStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SetFactorySettingsStatusError > payload (new SetFactorySettingsStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFactorySettingsStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SetFactorySettingsStatusCallbackIF*) _callback)->onSetFactorySettingsStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RemoteControl: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RemoteControlError > payload (new RemoteControlError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoteControl", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RemoteControlCallbackIF*) _callback)->onRemoteControlError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CISswUpdateProcess: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< CISswUpdateProcessError > payload (new CISswUpdateProcessError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CISswUpdateProcess", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CISswUpdateProcessCallbackIF*) _callback)->onCISswUpdateProcessError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CISswUpdateStage2Process: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< CISswUpdateStage2ProcessError > payload (new CISswUpdateStage2ProcessError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CISswUpdateStage2Process", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CISswUpdateStage2ProcessCallbackIF*) _callback)->onCISswUpdateStage2ProcessError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CalibrationParameter: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< CalibrationParameterError > payload (new CalibrationParameterError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CalibrationParameter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CalibrationParameterCallbackIF*) _callback)->onCalibrationParameterError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_PartNumber: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< PartNumberError > payload (new PartNumberError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PartNumber", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((PartNumberCallbackIF*) _callback)->onPartNumberError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Midw_Diagnostics_FIProxyCallback::_logger (Midw_Diagnostics_FIProxy::_logger);

/*static*/ ::boost::shared_ptr< Midw_Diagnostics_FIProxy > Midw_Diagnostics_FIProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Midw_Diagnostics_FIProxy >  proxyNew(new Midw_Diagnostics_FIProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Midw_Diagnostics_FIProxy > Midw_Diagnostics_FIProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Midw_Diagnostics_FIProxy >  proxyNew(new Midw_Diagnostics_FIProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Midw_Diagnostics_FIProxy > Midw_Diagnostics_FIProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Midw_Diagnostics_FIProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Midw_Diagnostics_FIProxy >  proxyNew(new Midw_Diagnostics_FIProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Midw_Diagnostics_FIProxy::Midw_Diagnostics_FIProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Midw_Diagnostics_FIProxy::~Midw_Diagnostics_FIProxy()
{
    LOG_INFO ("Entering ~Midw_Diagnostics_FIProxy");
    sendRelUpRegAll ();
}

act_t Midw_Diagnostics_FIProxy::sendTestMessageStart(TestMessageCallbackIF& cb, uint8 protocolId, const ::midw_diagnostics_fi_types::T_MessageBuffer& messageBuffer) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_TestMessage);
        ::boost::shared_ptr< TestMessageStart > payload (new TestMessageStart());
        payload->setProtocolId(protocolId);
        payload->setMessageBuffer(messageBuffer);
        CCA_MESSAGE(ccaMessage,header,TestMessageStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "TestMessage", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TestMessage);
        ::boost::shared_ptr< TestMessageError > payload (new TestMessageError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TestMessageError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "TestMessage", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendDiagRequestStart(DiagRequestCallbackIF& cb, ::midw_diagnostics_fi_types::T_DiagProtocol protID, const ::midw_diagnostics_fi_types::T_DiagData& diagData, uint32 cookie) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DiagRequest);
        ::boost::shared_ptr< DiagRequestStart > payload (new DiagRequestStart());
        payload->setProtID(protID);
        payload->setDiagData(diagData);
        payload->setCookie(cookie);
        CCA_MESSAGE(ccaMessage,header,DiagRequestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DiagRequest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DiagRequest);
        ::boost::shared_ptr< DiagRequestError > payload (new DiagRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DiagRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DiagRequest", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendReadDiagLogStart(ReadDiagLogCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_TroubleCodeType troubleCodes) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ReadDiagLog);
        ::boost::shared_ptr< ReadDiagLogStart > payload (new ReadDiagLogStart());
        payload->setTroubleCodes(troubleCodes);
        CCA_MESSAGE(ccaMessage,header,ReadDiagLogStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ReadDiagLog", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ReadDiagLog);
        ::boost::shared_ptr< ReadDiagLogError > payload (new ReadDiagLogError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ReadDiagLogError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ReadDiagLog", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendClearDiagLogStart(ClearDiagLogCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_TroubleCodeType troubleCodes) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ClearDiagLog);
        ::boost::shared_ptr< ClearDiagLogStart > payload (new ClearDiagLogStart());
        payload->setTroubleCodes(troubleCodes);
        CCA_MESSAGE(ccaMessage,header,ClearDiagLogStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ClearDiagLog", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ClearDiagLog);
        ::boost::shared_ptr< ClearDiagLogError > payload (new ClearDiagLogError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ClearDiagLogError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ClearDiagLog", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendStartDiagnosticTestStart(StartDiagnosticTestCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_TestRoutines testRoutine) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_StartDiagnosticTest);
        ::boost::shared_ptr< StartDiagnosticTestStart > payload (new StartDiagnosticTestStart());
        payload->setTestRoutine(testRoutine);
        CCA_MESSAGE(ccaMessage,header,StartDiagnosticTestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "StartDiagnosticTest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartDiagnosticTest);
        ::boost::shared_ptr< StartDiagnosticTestError > payload (new StartDiagnosticTestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartDiagnosticTestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "StartDiagnosticTest", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSetDefaultSettingsStart(SetDefaultSettingsCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories settingsCategory) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetDefaultSettings);
        ::boost::shared_ptr< SetDefaultSettingsStart > payload (new SetDefaultSettingsStart());
        payload->setSettingsCategory(settingsCategory);
        CCA_MESSAGE(ccaMessage,header,SetDefaultSettingsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetDefaultSettings", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetDefaultSettings);
        ::boost::shared_ptr< SetDefaultSettingsError > payload (new SetDefaultSettingsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetDefaultSettingsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetDefaultSettings", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendEnableTimeSlotStart(EnableTimeSlotCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_DiagMausSetup mausSetup) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_EnableTimeSlot);
        ::boost::shared_ptr< EnableTimeSlotStart > payload (new EnableTimeSlotStart());
        payload->setMausSetup(mausSetup);
        CCA_MESSAGE(ccaMessage,header,EnableTimeSlotStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "EnableTimeSlot", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EnableTimeSlot);
        ::boost::shared_ptr< EnableTimeSlotError > payload (new EnableTimeSlotError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EnableTimeSlotError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "EnableTimeSlot", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendStopDiagnosticTestStart(StopDiagnosticTestCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_TestRoutines testRoutine) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_StopDiagnosticTest);
        ::boost::shared_ptr< StopDiagnosticTestStart > payload (new StopDiagnosticTestStart());
        payload->setTestRoutine(testRoutine);
        CCA_MESSAGE(ccaMessage,header,StopDiagnosticTestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "StopDiagnosticTest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StopDiagnosticTest);
        ::boost::shared_ptr< StopDiagnosticTestError > payload (new StopDiagnosticTestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StopDiagnosticTestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "StopDiagnosticTest", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSetFactorySettingsStart(SetFactorySettingsCallbackIF& cb, uint8 defSetStateGroup, ::midw_diagnostics_fi_types::T_e8_DefSetMode defSetStateMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetFactorySettings);
        ::boost::shared_ptr< SetFactorySettingsStart > payload (new SetFactorySettingsStart());
        payload->setDefSetStateGroup(defSetStateGroup);
        payload->setDefSetStateMode(defSetStateMode);
        CCA_MESSAGE(ccaMessage,header,SetFactorySettingsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetFactorySettings", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetFactorySettings);
        ::boost::shared_ptr< SetFactorySettingsError > payload (new SetFactorySettingsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetFactorySettingsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetFactorySettings", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSetResetToSupplierDefaultConfigStart(SetResetToSupplierDefaultConfigCallbackIF& cb, uint8 resetSupplierConfig) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetResetToSupplierDefaultConfig);
        ::boost::shared_ptr< SetResetToSupplierDefaultConfigStart > payload (new SetResetToSupplierDefaultConfigStart());
        payload->setResetSupplierConfig(resetSupplierConfig);
        CCA_MESSAGE(ccaMessage,header,SetResetToSupplierDefaultConfigStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetResetToSupplierDefaultConfig", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetResetToSupplierDefaultConfig);
        ::boost::shared_ptr< SetResetToSupplierDefaultConfigError > payload (new SetResetToSupplierDefaultConfigError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetResetToSupplierDefaultConfigError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetResetToSupplierDefaultConfig", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSetRunTimeSourceDataStart(SetRunTimeSourceDataCallbackIF& cb, uint16 runTimeSourceAppID, uint32 runTimeSourceAppData) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetRunTimeSourceData);
        ::boost::shared_ptr< SetRunTimeSourceDataStart > payload (new SetRunTimeSourceDataStart());
        payload->setRunTimeSourceAppID(runTimeSourceAppID);
        payload->setRunTimeSourceAppData(runTimeSourceAppData);
        CCA_MESSAGE(ccaMessage,header,SetRunTimeSourceDataStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetRunTimeSourceData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetRunTimeSourceData);
        ::boost::shared_ptr< SetRunTimeSourceDataError > payload (new SetRunTimeSourceDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetRunTimeSourceDataError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetRunTimeSourceData", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSetFactorySettingsNewStart(SetFactorySettingsNewCallbackIF& cb, uint8 defSetStateGroup, ::midw_diagnostics_fi_types::T_e8_DefSetMode defSetStateMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetFactorySettingsNew);
        ::boost::shared_ptr< SetFactorySettingsNewStart > payload (new SetFactorySettingsNewStart());
        payload->setDefSetStateGroup(defSetStateGroup);
        payload->setDefSetStateMode(defSetStateMode);
        CCA_MESSAGE(ccaMessage,header,SetFactorySettingsNewStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetFactorySettingsNew", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetFactorySettingsNew);
        ::boost::shared_ptr< SetFactorySettingsNewError > payload (new SetFactorySettingsNewError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetFactorySettingsNewError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetFactorySettingsNew", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendStartCalibrationSessionStart(StartCalibrationSessionCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_CalibrationTable table) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_StartCalibrationSession);
        ::boost::shared_ptr< StartCalibrationSessionStart > payload (new StartCalibrationSessionStart());
        payload->setTable(table);
        CCA_MESSAGE(ccaMessage,header,StartCalibrationSessionStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "StartCalibrationSession", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartCalibrationSession);
        ::boost::shared_ptr< StartCalibrationSessionError > payload (new StartCalibrationSessionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartCalibrationSessionError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "StartCalibrationSession", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendStopCalibrationSessionStart(StopCalibrationSessionCallbackIF& cb, uint32 sessionHandle, const ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& timeStamp) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_StopCalibrationSession);
        ::boost::shared_ptr< StopCalibrationSessionStart > payload (new StopCalibrationSessionStart());
        payload->setSessionHandle(sessionHandle);
        payload->setTimeStamp(timeStamp);
        CCA_MESSAGE(ccaMessage,header,StopCalibrationSessionStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "StopCalibrationSession", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StopCalibrationSession);
        ::boost::shared_ptr< StopCalibrationSessionError > payload (new StopCalibrationSessionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StopCalibrationSessionError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "StopCalibrationSession", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendStartRouteCalculationUpReg(StartRouteCalculationCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_StartRouteCalculation);
        ::boost::shared_ptr< StartRouteCalculationUpReg > payload (new StartRouteCalculationUpReg());
        CCA_MESSAGE(ccaMessage,header,StartRouteCalculationUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< StartRouteCalculationRelUpReg > payloadRelUpRegHeap (new StartRouteCalculationRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_StartRouteCalculation, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::StartRouteCalculationRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_StartRouteCalculation, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "StartRouteCalculation", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "StartRouteCalculation", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasStartRouteCalculation()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_StartRouteCalculation, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< StartRouteCalculationStatus > payloadLoopback (new StartRouteCalculationStatus(getStartRouteCalculation()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,StartRouteCalculationStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartRouteCalculation);
        ::boost::shared_ptr< StartRouteCalculationError > payload (new StartRouteCalculationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartRouteCalculationError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "StartRouteCalculation", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendStartRouteCalculationRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_StartRouteCalculation,"StartRouteCalculation");
}

void Midw_Diagnostics_FIProxy::sendStartRouteCalculationRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_StartRouteCalculation);
}

const StartRouteCalculationStatus& Midw_Diagnostics_FIProxy::getStartRouteCalculation() const {
    return _startRouteCalculation.get();
}

bool Midw_Diagnostics_FIProxy::hasStartRouteCalculation() const {
    return _startRouteCalculation.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendStartRouteCalculationSet(StartRouteCalculationCallbackIF& cb, bool calculationStarted) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_StartRouteCalculation);
        ::boost::shared_ptr< StartRouteCalculationSet > payload (new StartRouteCalculationSet());
        payload->setCalculationStarted(calculationStarted);
        CCA_MESSAGE(ccaMessage,header,StartRouteCalculationSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "StartRouteCalculation", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartRouteCalculation);
        ::boost::shared_ptr< StartRouteCalculationError > payload (new StartRouteCalculationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartRouteCalculationError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "StartRouteCalculation", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendRouteCalculationResultUpReg(RouteCalculationResultCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RouteCalculationResult);
        ::boost::shared_ptr< RouteCalculationResultUpReg > payload (new RouteCalculationResultUpReg());
        CCA_MESSAGE(ccaMessage,header,RouteCalculationResultUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RouteCalculationResultRelUpReg > payloadRelUpRegHeap (new RouteCalculationResultRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RouteCalculationResult, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::RouteCalculationResultRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RouteCalculationResult, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RouteCalculationResult", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RouteCalculationResult", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRouteCalculationResult()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RouteCalculationResult, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RouteCalculationResultStatus > payloadLoopback (new RouteCalculationResultStatus(getRouteCalculationResult()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RouteCalculationResultStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RouteCalculationResult);
        ::boost::shared_ptr< RouteCalculationResultError > payload (new RouteCalculationResultError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RouteCalculationResultError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RouteCalculationResult", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendRouteCalculationResultRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RouteCalculationResult,"RouteCalculationResult");
}

void Midw_Diagnostics_FIProxy::sendRouteCalculationResultRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RouteCalculationResult);
}

const RouteCalculationResultStatus& Midw_Diagnostics_FIProxy::getRouteCalculationResult() const {
    return _routeCalculationResult.get();
}

bool Midw_Diagnostics_FIProxy::hasRouteCalculationResult() const {
    return _routeCalculationResult.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendRouteCalculationResultSet(RouteCalculationResultCallbackIF& cb, const ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& calculationResult) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_RouteCalculationResult);
        ::boost::shared_ptr< RouteCalculationResultSet > payload (new RouteCalculationResultSet());
        payload->setCalculationResult(calculationResult);
        CCA_MESSAGE(ccaMessage,header,RouteCalculationResultSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "RouteCalculationResult", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RouteCalculationResult);
        ::boost::shared_ptr< RouteCalculationResultError > payload (new RouteCalculationResultError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RouteCalculationResultError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "RouteCalculationResult", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSetLocaleStartUpReg(SetLocaleStartCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SetLocaleStart);
        ::boost::shared_ptr< SetLocaleStartUpReg > payload (new SetLocaleStartUpReg());
        CCA_MESSAGE(ccaMessage,header,SetLocaleStartUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SetLocaleStartRelUpReg > payloadRelUpRegHeap (new SetLocaleStartRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SetLocaleStart, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::SetLocaleStartRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SetLocaleStart, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SetLocaleStart", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SetLocaleStart", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSetLocaleStart()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SetLocaleStart, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SetLocaleStartStatus > payloadLoopback (new SetLocaleStartStatus(getSetLocaleStart()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SetLocaleStartStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetLocaleStart);
        ::boost::shared_ptr< SetLocaleStartError > payload (new SetLocaleStartError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetLocaleStartError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SetLocaleStart", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendSetLocaleStartRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SetLocaleStart,"SetLocaleStart");
}

void Midw_Diagnostics_FIProxy::sendSetLocaleStartRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SetLocaleStart);
}

const SetLocaleStartStatus& Midw_Diagnostics_FIProxy::getSetLocaleStart() const {
    return _setLocaleStart.get();
}

bool Midw_Diagnostics_FIProxy::hasSetLocaleStart() const {
    return _setLocaleStart.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendSetLocaleStartSet(SetLocaleStartCallbackIF& cb, bool localeSwitched) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SetLocaleStart);
        ::boost::shared_ptr< SetLocaleStartSet > payload (new SetLocaleStartSet());
        payload->setLocaleSwitched(localeSwitched);
        CCA_MESSAGE(ccaMessage,header,SetLocaleStartSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SetLocaleStart", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetLocaleStart);
        ::boost::shared_ptr< SetLocaleStartError > payload (new SetLocaleStartError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetLocaleStartError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SetLocaleStart", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSetLocaleResultUpReg(SetLocaleResultCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SetLocaleResult);
        ::boost::shared_ptr< SetLocaleResultUpReg > payload (new SetLocaleResultUpReg());
        CCA_MESSAGE(ccaMessage,header,SetLocaleResultUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SetLocaleResultRelUpReg > payloadRelUpRegHeap (new SetLocaleResultRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SetLocaleResult, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::SetLocaleResultRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SetLocaleResult, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SetLocaleResult", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SetLocaleResult", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSetLocaleResult()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SetLocaleResult, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SetLocaleResultStatus > payloadLoopback (new SetLocaleResultStatus(getSetLocaleResult()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SetLocaleResultStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetLocaleResult);
        ::boost::shared_ptr< SetLocaleResultError > payload (new SetLocaleResultError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetLocaleResultError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SetLocaleResult", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendSetLocaleResultRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SetLocaleResult,"SetLocaleResult");
}

void Midw_Diagnostics_FIProxy::sendSetLocaleResultRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SetLocaleResult);
}

const SetLocaleResultStatus& Midw_Diagnostics_FIProxy::getSetLocaleResult() const {
    return _setLocaleResult.get();
}

bool Midw_Diagnostics_FIProxy::hasSetLocaleResult() const {
    return _setLocaleResult.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendSetLocaleResultSet(SetLocaleResultCallbackIF& cb, const ::midw_diagnostics_fi_types::T_CountryLanguageResult& countryLanguageResult) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SetLocaleResult);
        ::boost::shared_ptr< SetLocaleResultSet > payload (new SetLocaleResultSet());
        payload->setCountryLanguageResult(countryLanguageResult);
        CCA_MESSAGE(ccaMessage,header,SetLocaleResultSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SetLocaleResult", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetLocaleResult);
        ::boost::shared_ptr< SetLocaleResultError > payload (new SetLocaleResultError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetLocaleResultError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SetLocaleResult", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendGetLocaleUpReg(GetLocaleCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_GetLocale);
        ::boost::shared_ptr< GetLocaleUpReg > payload (new GetLocaleUpReg());
        CCA_MESSAGE(ccaMessage,header,GetLocaleUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GetLocaleRelUpReg > payloadRelUpRegHeap (new GetLocaleRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_GetLocale, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::GetLocaleRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_GetLocale, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "GetLocale", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "GetLocale", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGetLocale()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_GetLocale, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GetLocaleStatus > payloadLoopback (new GetLocaleStatus(getGetLocale()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GetLocaleStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetLocale);
        ::boost::shared_ptr< GetLocaleError > payload (new GetLocaleError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetLocaleError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "GetLocale", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendGetLocaleRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_GetLocale,"GetLocale");
}

void Midw_Diagnostics_FIProxy::sendGetLocaleRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_GetLocale);
}

const GetLocaleStatus& Midw_Diagnostics_FIProxy::getGetLocale() const {
    return _getLocale.get();
}

bool Midw_Diagnostics_FIProxy::hasGetLocale() const {
    return _getLocale.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendGetLocaleSet(GetLocaleCallbackIF& cb, const ::midw_diagnostics_fi_types::T_CountryLanguage& countryLanguage) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_GetLocale);
        ::boost::shared_ptr< GetLocaleSet > payload (new GetLocaleSet());
        payload->setCountryLanguage(countryLanguage);
        CCA_MESSAGE(ccaMessage,header,GetLocaleSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "GetLocale", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetLocale);
        ::boost::shared_ptr< GetLocaleError > payload (new GetLocaleError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetLocaleError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "GetLocale", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSetDisplayUpReg(SetDisplayCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SetDisplay);
        ::boost::shared_ptr< SetDisplayUpReg > payload (new SetDisplayUpReg());
        CCA_MESSAGE(ccaMessage,header,SetDisplayUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SetDisplayRelUpReg > payloadRelUpRegHeap (new SetDisplayRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SetDisplay, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::SetDisplayRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SetDisplay, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SetDisplay", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SetDisplay", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSetDisplay()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SetDisplay, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SetDisplayStatus > payloadLoopback (new SetDisplayStatus(getSetDisplay()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SetDisplayStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetDisplay);
        ::boost::shared_ptr< SetDisplayError > payload (new SetDisplayError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetDisplayError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SetDisplay", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendSetDisplayRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SetDisplay,"SetDisplay");
}

void Midw_Diagnostics_FIProxy::sendSetDisplayRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SetDisplay);
}

const SetDisplayStatus& Midw_Diagnostics_FIProxy::getSetDisplay() const {
    return _setDisplay.get();
}

bool Midw_Diagnostics_FIProxy::hasSetDisplay() const {
    return _setDisplay.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendSetDisplaySet(SetDisplayCallbackIF& cb, bool displayTestSuccess) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SetDisplay);
        ::boost::shared_ptr< SetDisplaySet > payload (new SetDisplaySet());
        payload->setDisplayTestSuccess(displayTestSuccess);
        CCA_MESSAGE(ccaMessage,header,SetDisplaySet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SetDisplay", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetDisplay);
        ::boost::shared_ptr< SetDisplayError > payload (new SetDisplayError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetDisplayError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SetDisplay", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendConfigUpdateViaUSBUpReg(ConfigUpdateViaUSBCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ConfigUpdateViaUSB);
        ::boost::shared_ptr< ConfigUpdateViaUSBUpReg > payload (new ConfigUpdateViaUSBUpReg());
        CCA_MESSAGE(ccaMessage,header,ConfigUpdateViaUSBUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ConfigUpdateViaUSBRelUpReg > payloadRelUpRegHeap (new ConfigUpdateViaUSBRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ConfigUpdateViaUSB, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::ConfigUpdateViaUSBRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ConfigUpdateViaUSB, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ConfigUpdateViaUSB", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ConfigUpdateViaUSB", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasConfigUpdateViaUSB()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ConfigUpdateViaUSB, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ConfigUpdateViaUSBStatus > payloadLoopback (new ConfigUpdateViaUSBStatus(getConfigUpdateViaUSB()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ConfigUpdateViaUSBStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ConfigUpdateViaUSB);
        ::boost::shared_ptr< ConfigUpdateViaUSBError > payload (new ConfigUpdateViaUSBError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ConfigUpdateViaUSBError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ConfigUpdateViaUSB", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendConfigUpdateViaUSBRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ConfigUpdateViaUSB,"ConfigUpdateViaUSB");
}

void Midw_Diagnostics_FIProxy::sendConfigUpdateViaUSBRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ConfigUpdateViaUSB);
}

const ConfigUpdateViaUSBStatus& Midw_Diagnostics_FIProxy::getConfigUpdateViaUSB() const {
    return _configUpdateViaUSB.get();
}

bool Midw_Diagnostics_FIProxy::hasConfigUpdateViaUSB() const {
    return _configUpdateViaUSB.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendAntiTheftStatusUpReg(AntiTheftStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AntiTheftStatus);
        ::boost::shared_ptr< AntiTheftStatusUpReg > payload (new AntiTheftStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,AntiTheftStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AntiTheftStatusRelUpReg > payloadRelUpRegHeap (new AntiTheftStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AntiTheftStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::AntiTheftStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AntiTheftStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AntiTheftStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AntiTheftStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAntiTheftStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AntiTheftStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AntiTheftStatusStatus > payloadLoopback (new AntiTheftStatusStatus(getAntiTheftStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AntiTheftStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AntiTheftStatus);
        ::boost::shared_ptr< AntiTheftStatusError > payload (new AntiTheftStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AntiTheftStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AntiTheftStatus", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendAntiTheftStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AntiTheftStatus,"AntiTheftStatus");
}

void Midw_Diagnostics_FIProxy::sendAntiTheftStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AntiTheftStatus);
}

const AntiTheftStatusStatus& Midw_Diagnostics_FIProxy::getAntiTheftStatus() const {
    return _antiTheftStatus.get();
}

bool Midw_Diagnostics_FIProxy::hasAntiTheftStatus() const {
    return _antiTheftStatus.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendAntiTheftStatusSet(AntiTheftStatusCallbackIF& cb, ::midw_diagnostics_fi_types::T_AntiTheftStatus antiTheftStatus) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_AntiTheftStatus);
        ::boost::shared_ptr< AntiTheftStatusSet > payload (new AntiTheftStatusSet());
        payload->setAntiTheftStatus(antiTheftStatus);
        CCA_MESSAGE(ccaMessage,header,AntiTheftStatusSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "AntiTheftStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AntiTheftStatus);
        ::boost::shared_ptr< AntiTheftStatusError > payload (new AntiTheftStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AntiTheftStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "AntiTheftStatus", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendAntiTheftUnlockHMIUpReg(AntiTheftUnlockHMICallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AntiTheftUnlockHMI);
        ::boost::shared_ptr< AntiTheftUnlockHMIUpReg > payload (new AntiTheftUnlockHMIUpReg());
        CCA_MESSAGE(ccaMessage,header,AntiTheftUnlockHMIUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AntiTheftUnlockHMIRelUpReg > payloadRelUpRegHeap (new AntiTheftUnlockHMIRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AntiTheftUnlockHMI, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::AntiTheftUnlockHMIRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AntiTheftUnlockHMI, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AntiTheftUnlockHMI", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AntiTheftUnlockHMI", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAntiTheftUnlockHMI()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AntiTheftUnlockHMI, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AntiTheftUnlockHMIStatus > payloadLoopback (new AntiTheftUnlockHMIStatus(getAntiTheftUnlockHMI()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AntiTheftUnlockHMIStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AntiTheftUnlockHMI);
        ::boost::shared_ptr< AntiTheftUnlockHMIError > payload (new AntiTheftUnlockHMIError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AntiTheftUnlockHMIError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AntiTheftUnlockHMI", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendAntiTheftUnlockHMIRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AntiTheftUnlockHMI,"AntiTheftUnlockHMI");
}

void Midw_Diagnostics_FIProxy::sendAntiTheftUnlockHMIRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AntiTheftUnlockHMI);
}

const AntiTheftUnlockHMIStatus& Midw_Diagnostics_FIProxy::getAntiTheftUnlockHMI() const {
    return _antiTheftUnlockHMI.get();
}

bool Midw_Diagnostics_FIProxy::hasAntiTheftUnlockHMI() const {
    return _antiTheftUnlockHMI.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendAntiTheftUnlockHMISet(AntiTheftUnlockHMICallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_AntiTheftUnlockHMI);
        ::boost::shared_ptr< AntiTheftUnlockHMISet > payload (new AntiTheftUnlockHMISet());
        CCA_MESSAGE(ccaMessage,header,AntiTheftUnlockHMISet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "AntiTheftUnlockHMI", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AntiTheftUnlockHMI);
        ::boost::shared_ptr< AntiTheftUnlockHMIError > payload (new AntiTheftUnlockHMIError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AntiTheftUnlockHMIError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "AntiTheftUnlockHMI", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendAntiTheftUnlockHUUpReg(AntiTheftUnlockHUCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AntiTheftUnlockHU);
        ::boost::shared_ptr< AntiTheftUnlockHUUpReg > payload (new AntiTheftUnlockHUUpReg());
        CCA_MESSAGE(ccaMessage,header,AntiTheftUnlockHUUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AntiTheftUnlockHURelUpReg > payloadRelUpRegHeap (new AntiTheftUnlockHURelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AntiTheftUnlockHU, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::AntiTheftUnlockHURelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AntiTheftUnlockHU, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AntiTheftUnlockHU", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AntiTheftUnlockHU", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAntiTheftUnlockHU()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AntiTheftUnlockHU, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AntiTheftUnlockHUStatus > payloadLoopback (new AntiTheftUnlockHUStatus(getAntiTheftUnlockHU()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AntiTheftUnlockHUStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AntiTheftUnlockHU);
        ::boost::shared_ptr< AntiTheftUnlockHUError > payload (new AntiTheftUnlockHUError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AntiTheftUnlockHUError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AntiTheftUnlockHU", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendAntiTheftUnlockHURelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AntiTheftUnlockHU,"AntiTheftUnlockHU");
}

void Midw_Diagnostics_FIProxy::sendAntiTheftUnlockHURelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AntiTheftUnlockHU);
}

const AntiTheftUnlockHUStatus& Midw_Diagnostics_FIProxy::getAntiTheftUnlockHU() const {
    return _antiTheftUnlockHU.get();
}

bool Midw_Diagnostics_FIProxy::hasAntiTheftUnlockHU() const {
    return _antiTheftUnlockHU.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendAntiTheftUnlockHUSet(AntiTheftUnlockHUCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_AntiTheftUnlockHU);
        ::boost::shared_ptr< AntiTheftUnlockHUSet > payload (new AntiTheftUnlockHUSet());
        CCA_MESSAGE(ccaMessage,header,AntiTheftUnlockHUSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "AntiTheftUnlockHU", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AntiTheftUnlockHU);
        ::boost::shared_ptr< AntiTheftUnlockHUError > payload (new AntiTheftUnlockHUError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AntiTheftUnlockHUError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "AntiTheftUnlockHU", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendClearDestinationMemoryUpReg(ClearDestinationMemoryCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ClearDestinationMemory);
        ::boost::shared_ptr< ClearDestinationMemoryUpReg > payload (new ClearDestinationMemoryUpReg());
        CCA_MESSAGE(ccaMessage,header,ClearDestinationMemoryUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ClearDestinationMemoryRelUpReg > payloadRelUpRegHeap (new ClearDestinationMemoryRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ClearDestinationMemory, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::ClearDestinationMemoryRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ClearDestinationMemory, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ClearDestinationMemory", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ClearDestinationMemory", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasClearDestinationMemory()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ClearDestinationMemory, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ClearDestinationMemoryStatus > payloadLoopback (new ClearDestinationMemoryStatus(getClearDestinationMemory()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ClearDestinationMemoryStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ClearDestinationMemory);
        ::boost::shared_ptr< ClearDestinationMemoryError > payload (new ClearDestinationMemoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ClearDestinationMemoryError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ClearDestinationMemory", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendClearDestinationMemoryRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ClearDestinationMemory,"ClearDestinationMemory");
}

void Midw_Diagnostics_FIProxy::sendClearDestinationMemoryRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ClearDestinationMemory);
}

const ClearDestinationMemoryStatus& Midw_Diagnostics_FIProxy::getClearDestinationMemory() const {
    return _clearDestinationMemory.get();
}

bool Midw_Diagnostics_FIProxy::hasClearDestinationMemory() const {
    return _clearDestinationMemory.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendClearDestinationMemorySet(ClearDestinationMemoryCallbackIF& cb, bool clearMemorySuccess) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ClearDestinationMemory);
        ::boost::shared_ptr< ClearDestinationMemorySet > payload (new ClearDestinationMemorySet());
        payload->setClearMemorySuccess(clearMemorySuccess);
        CCA_MESSAGE(ccaMessage,header,ClearDestinationMemorySet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ClearDestinationMemory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ClearDestinationMemory);
        ::boost::shared_ptr< ClearDestinationMemoryError > payload (new ClearDestinationMemoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ClearDestinationMemoryError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ClearDestinationMemory", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendGetDestinationMemorySizeUpReg(GetDestinationMemorySizeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_GetDestinationMemorySize);
        ::boost::shared_ptr< GetDestinationMemorySizeUpReg > payload (new GetDestinationMemorySizeUpReg());
        CCA_MESSAGE(ccaMessage,header,GetDestinationMemorySizeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GetDestinationMemorySizeRelUpReg > payloadRelUpRegHeap (new GetDestinationMemorySizeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_GetDestinationMemorySize, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::GetDestinationMemorySizeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_GetDestinationMemorySize, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "GetDestinationMemorySize", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "GetDestinationMemorySize", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGetDestinationMemorySize()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_GetDestinationMemorySize, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GetDestinationMemorySizeStatus > payloadLoopback (new GetDestinationMemorySizeStatus(getGetDestinationMemorySize()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GetDestinationMemorySizeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetDestinationMemorySize);
        ::boost::shared_ptr< GetDestinationMemorySizeError > payload (new GetDestinationMemorySizeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetDestinationMemorySizeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "GetDestinationMemorySize", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendGetDestinationMemorySizeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_GetDestinationMemorySize,"GetDestinationMemorySize");
}

void Midw_Diagnostics_FIProxy::sendGetDestinationMemorySizeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_GetDestinationMemorySize);
}

const GetDestinationMemorySizeStatus& Midw_Diagnostics_FIProxy::getGetDestinationMemorySize() const {
    return _getDestinationMemorySize.get();
}

bool Midw_Diagnostics_FIProxy::hasGetDestinationMemorySize() const {
    return _getDestinationMemorySize.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendGetDestinationMemorySizeSet(GetDestinationMemorySizeCallbackIF& cb, uint16 recordCount) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_GetDestinationMemorySize);
        ::boost::shared_ptr< GetDestinationMemorySizeSet > payload (new GetDestinationMemorySizeSet());
        payload->setRecordCount(recordCount);
        CCA_MESSAGE(ccaMessage,header,GetDestinationMemorySizeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "GetDestinationMemorySize", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetDestinationMemorySize);
        ::boost::shared_ptr< GetDestinationMemorySizeError > payload (new GetDestinationMemorySizeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetDestinationMemorySizeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "GetDestinationMemorySize", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSimulateKeyPressUpReg(SimulateKeyPressCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SimulateKeyPress);
        ::boost::shared_ptr< SimulateKeyPressUpReg > payload (new SimulateKeyPressUpReg());
        CCA_MESSAGE(ccaMessage,header,SimulateKeyPressUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SimulateKeyPressRelUpReg > payloadRelUpRegHeap (new SimulateKeyPressRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SimulateKeyPress, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::SimulateKeyPressRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SimulateKeyPress, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SimulateKeyPress", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SimulateKeyPress", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSimulateKeyPress()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SimulateKeyPress, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SimulateKeyPressStatus > payloadLoopback (new SimulateKeyPressStatus(getSimulateKeyPress()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SimulateKeyPressStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SimulateKeyPress);
        ::boost::shared_ptr< SimulateKeyPressError > payload (new SimulateKeyPressError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SimulateKeyPressError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SimulateKeyPress", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendSimulateKeyPressRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SimulateKeyPress,"SimulateKeyPress");
}

void Midw_Diagnostics_FIProxy::sendSimulateKeyPressRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SimulateKeyPress);
}

const SimulateKeyPressStatus& Midw_Diagnostics_FIProxy::getSimulateKeyPress() const {
    return _simulateKeyPress.get();
}

bool Midw_Diagnostics_FIProxy::hasSimulateKeyPress() const {
    return _simulateKeyPress.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendSimulateKeyPressSet(SimulateKeyPressCallbackIF& cb, bool keyPressSuccess) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SimulateKeyPress);
        ::boost::shared_ptr< SimulateKeyPressSet > payload (new SimulateKeyPressSet());
        payload->setKeyPressSuccess(keyPressSuccess);
        CCA_MESSAGE(ccaMessage,header,SimulateKeyPressSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SimulateKeyPress", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SimulateKeyPress);
        ::boost::shared_ptr< SimulateKeyPressError > payload (new SimulateKeyPressError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SimulateKeyPressError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SimulateKeyPress", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendResetSecurityUpReg(ResetSecurityCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ResetSecurity);
        ::boost::shared_ptr< ResetSecurityUpReg > payload (new ResetSecurityUpReg());
        CCA_MESSAGE(ccaMessage,header,ResetSecurityUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ResetSecurityRelUpReg > payloadRelUpRegHeap (new ResetSecurityRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ResetSecurity, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::ResetSecurityRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ResetSecurity, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ResetSecurity", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ResetSecurity", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasResetSecurity()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ResetSecurity, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ResetSecurityStatus > payloadLoopback (new ResetSecurityStatus(getResetSecurity()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ResetSecurityStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetSecurity);
        ::boost::shared_ptr< ResetSecurityError > payload (new ResetSecurityError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetSecurityError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ResetSecurity", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendResetSecurityRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ResetSecurity,"ResetSecurity");
}

void Midw_Diagnostics_FIProxy::sendResetSecurityRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ResetSecurity);
}

const ResetSecurityStatus& Midw_Diagnostics_FIProxy::getResetSecurity() const {
    return _resetSecurity.get();
}

bool Midw_Diagnostics_FIProxy::hasResetSecurity() const {
    return _resetSecurity.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendResetSecuritySet(ResetSecurityCallbackIF& cb, bool resetSuccess) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ResetSecurity);
        ::boost::shared_ptr< ResetSecuritySet > payload (new ResetSecuritySet());
        payload->setResetSuccess(resetSuccess);
        CCA_MESSAGE(ccaMessage,header,ResetSecuritySet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ResetSecurity", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetSecurity);
        ::boost::shared_ptr< ResetSecurityError > payload (new ResetSecurityError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetSecurityError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ResetSecurity", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendLanguageUpReg(LanguageCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Language);
        ::boost::shared_ptr< LanguageUpReg > payload (new LanguageUpReg());
        CCA_MESSAGE(ccaMessage,header,LanguageUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< LanguageRelUpReg > payloadRelUpRegHeap (new LanguageRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Language, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::LanguageRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Language, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Language", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Language", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasLanguage()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Language, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< LanguageStatus > payloadLoopback (new LanguageStatus(getLanguage()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,LanguageStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Language);
        ::boost::shared_ptr< LanguageError > payload (new LanguageError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LanguageError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Language", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendLanguageRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Language,"Language");
}

void Midw_Diagnostics_FIProxy::sendLanguageRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Language);
}

const LanguageStatus& Midw_Diagnostics_FIProxy::getLanguage() const {
    return _language.get();
}

bool Midw_Diagnostics_FIProxy::hasLanguage() const {
    return _language.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendLanguageGet(LanguageCallbackIF& cb, ::midw_diagnostics_fi_types::T_e16_Language language) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Language);
        ::boost::shared_ptr< LanguageGet > payload (new LanguageGet());
        payload->setLanguage(language);
        CCA_MESSAGE(ccaMessage,header,LanguageGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Language", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Language);
        ::boost::shared_ptr< LanguageError > payload (new LanguageError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LanguageError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Language", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSpeedLockUpReg(SpeedLockCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SpeedLock);
        ::boost::shared_ptr< SpeedLockUpReg > payload (new SpeedLockUpReg());
        CCA_MESSAGE(ccaMessage,header,SpeedLockUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SpeedLockRelUpReg > payloadRelUpRegHeap (new SpeedLockRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SpeedLock, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::SpeedLockRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SpeedLock, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SpeedLock", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SpeedLock", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSpeedLock()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SpeedLock, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SpeedLockStatus > payloadLoopback (new SpeedLockStatus(getSpeedLock()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SpeedLockStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SpeedLock);
        ::boost::shared_ptr< SpeedLockError > payload (new SpeedLockError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SpeedLockError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SpeedLock", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendSpeedLockRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SpeedLock,"SpeedLock");
}

void Midw_Diagnostics_FIProxy::sendSpeedLockRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SpeedLock);
}

const SpeedLockStatus& Midw_Diagnostics_FIProxy::getSpeedLock() const {
    return _speedLock.get();
}

bool Midw_Diagnostics_FIProxy::hasSpeedLock() const {
    return _speedLock.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendSpeedLockGet(SpeedLockCallbackIF& cb, ::midw_diagnostics_fi_types::T_e16_SpeedLock speedLock) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SpeedLock);
        ::boost::shared_ptr< SpeedLockGet > payload (new SpeedLockGet());
        payload->setSpeedLock(speedLock);
        CCA_MESSAGE(ccaMessage,header,SpeedLockGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SpeedLock", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SpeedLock);
        ::boost::shared_ptr< SpeedLockError > payload (new SpeedLockError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SpeedLockError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SpeedLock", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSpdLockUpReg(SpdLockCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SpdLock);
        ::boost::shared_ptr< SpdLockUpReg > payload (new SpdLockUpReg());
        CCA_MESSAGE(ccaMessage,header,SpdLockUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SpdLockRelUpReg > payloadRelUpRegHeap (new SpdLockRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SpdLock, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::SpdLockRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SpdLock, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SpdLock", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SpdLock", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSpdLock()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SpdLock, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SpdLockStatus > payloadLoopback (new SpdLockStatus(getSpdLock()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SpdLockStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SpdLock);
        ::boost::shared_ptr< SpdLockError > payload (new SpdLockError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SpdLockError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SpdLock", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendSpdLockRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SpdLock,"SpdLock");
}

void Midw_Diagnostics_FIProxy::sendSpdLockRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SpdLock);
}

const SpdLockStatus& Midw_Diagnostics_FIProxy::getSpdLock() const {
    return _spdLock.get();
}

bool Midw_Diagnostics_FIProxy::hasSpdLock() const {
    return _spdLock.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendSpdLockSet(SpdLockCallbackIF& cb, ::midw_diagnostics_fi_types::T_e16_SpeedLock speedLock) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SpdLock);
        ::boost::shared_ptr< SpdLockSet > payload (new SpdLockSet());
        payload->setSpeedLock(speedLock);
        CCA_MESSAGE(ccaMessage,header,SpdLockSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SpdLock", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SpdLock);
        ::boost::shared_ptr< SpdLockError > payload (new SpdLockError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SpdLockError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SpdLock", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSetRVCSignalUpReg(SetRVCSignalCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SetRVCSignal);
        ::boost::shared_ptr< SetRVCSignalUpReg > payload (new SetRVCSignalUpReg());
        CCA_MESSAGE(ccaMessage,header,SetRVCSignalUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SetRVCSignalRelUpReg > payloadRelUpRegHeap (new SetRVCSignalRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SetRVCSignal, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::SetRVCSignalRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SetRVCSignal, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SetRVCSignal", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SetRVCSignal", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSetRVCSignal()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SetRVCSignal, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SetRVCSignalStatus > payloadLoopback (new SetRVCSignalStatus(getSetRVCSignal()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SetRVCSignalStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetRVCSignal);
        ::boost::shared_ptr< SetRVCSignalError > payload (new SetRVCSignalError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetRVCSignalError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SetRVCSignal", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendSetRVCSignalRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SetRVCSignal,"SetRVCSignal");
}

void Midw_Diagnostics_FIProxy::sendSetRVCSignalRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SetRVCSignal);
}

const SetRVCSignalStatus& Midw_Diagnostics_FIProxy::getSetRVCSignal() const {
    return _setRVCSignal.get();
}

bool Midw_Diagnostics_FIProxy::hasSetRVCSignal() const {
    return _setRVCSignal.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendSetRVCSignalGet(SetRVCSignalCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal signalStatus) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SetRVCSignal);
        ::boost::shared_ptr< SetRVCSignalGet > payload (new SetRVCSignalGet());
        payload->setSignalStatus(signalStatus);
        CCA_MESSAGE(ccaMessage,header,SetRVCSignalGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SetRVCSignal", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetRVCSignal);
        ::boost::shared_ptr< SetRVCSignalError > payload (new SetRVCSignalError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetRVCSignalError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SetRVCSignal", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSetRVCSignalSet(SetRVCSignalCallbackIF& cb, bool statusChanged) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SetRVCSignal);
        ::boost::shared_ptr< SetRVCSignalSet > payload (new SetRVCSignalSet());
        payload->setStatusChanged(statusChanged);
        CCA_MESSAGE(ccaMessage,header,SetRVCSignalSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SetRVCSignal", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetRVCSignal);
        ::boost::shared_ptr< SetRVCSignalError > payload (new SetRVCSignalError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetRVCSignalError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SetRVCSignal", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendRVCSignalStatusUpReg(RVCSignalStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RVCSignalStatus);
        ::boost::shared_ptr< RVCSignalStatusUpReg > payload (new RVCSignalStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,RVCSignalStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RVCSignalStatusRelUpReg > payloadRelUpRegHeap (new RVCSignalStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RVCSignalStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::RVCSignalStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RVCSignalStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RVCSignalStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RVCSignalStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRVCSignalStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RVCSignalStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RVCSignalStatusStatus > payloadLoopback (new RVCSignalStatusStatus(getRVCSignalStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RVCSignalStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RVCSignalStatus);
        ::boost::shared_ptr< RVCSignalStatusError > payload (new RVCSignalStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RVCSignalStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RVCSignalStatus", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendRVCSignalStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RVCSignalStatus,"RVCSignalStatus");
}

void Midw_Diagnostics_FIProxy::sendRVCSignalStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RVCSignalStatus);
}

const RVCSignalStatusStatus& Midw_Diagnostics_FIProxy::getRVCSignalStatus() const {
    return _rVCSignalStatus.get();
}

bool Midw_Diagnostics_FIProxy::hasRVCSignalStatus() const {
    return _rVCSignalStatus.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendRVCSignalStatusSet(RVCSignalStatusCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal signalStatus) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_RVCSignalStatus);
        ::boost::shared_ptr< RVCSignalStatusSet > payload (new RVCSignalStatusSet());
        payload->setSignalStatus(signalStatus);
        CCA_MESSAGE(ccaMessage,header,RVCSignalStatusSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "RVCSignalStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RVCSignalStatus);
        ::boost::shared_ptr< RVCSignalStatusError > payload (new RVCSignalStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RVCSignalStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "RVCSignalStatus", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendKdsEntryUpReg(KdsEntryCallbackIF& cb, uint32 kdsEntry) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_KdsEntry);
        ::boost::shared_ptr< KdsEntryUpReg > payload (new KdsEntryUpReg());
        payload->setKdsEntry(kdsEntry);
        CCA_MESSAGE(ccaMessage,header,KdsEntryUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< KdsEntryRelUpReg > payloadRelUpRegHeap (new KdsEntryRelUpReg());
        payloadRelUpRegHeap->setKdsEntry(kdsEntry);
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_KdsEntry, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::KdsEntryRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_KdsEntry, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "KdsEntry", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "KdsEntry", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasKdsEntry(kdsEntry)) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_KdsEntry, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< KdsEntryStatus > payloadLoopback (new KdsEntryStatus(getKdsEntry(kdsEntry)));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,KdsEntryStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_KdsEntry);
        ::boost::shared_ptr< KdsEntryError > payload (new KdsEntryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,KdsEntryError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "KdsEntry", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendKdsEntryRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_KdsEntry,"KdsEntry");
}

void Midw_Diagnostics_FIProxy::sendKdsEntryRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_KdsEntry);
}

const KdsEntryStatus& Midw_Diagnostics_FIProxy::getKdsEntry(uint32 kdsEntry) const {
    KdsEntryRelUpReg payload(kdsEntry);
    KdsEntryMap::const_iterator it = _kdsEntryMap.find(payload);
    if (it != _kdsEntryMap.end()) {
        return it->second;
    } else {
        std::string s;
        serializeJson (payload,s);
        LOG_FATAL("get%s(): No status object available which belongs to the passed parameter: %s", "KdsEntry", s.c_str());
    }
}

bool Midw_Diagnostics_FIProxy::hasKdsEntry(uint32 kdsEntry) const {
    KdsEntryMap::const_iterator it = _kdsEntryMap.find(KdsEntryRelUpReg(kdsEntry));
    return ( it != _kdsEntryMap.end() );
}

act_t Midw_Diagnostics_FIProxy::sendKdsEntryGet(KdsEntryCallbackIF& cb, uint32 kdsEntry) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_KdsEntry);
        ::boost::shared_ptr< KdsEntryGet > payload (new KdsEntryGet());
        payload->setKdsEntry(kdsEntry);
        CCA_MESSAGE(ccaMessage,header,KdsEntryGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "KdsEntry", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_KdsEntry);
        ::boost::shared_ptr< KdsEntryError > payload (new KdsEntryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,KdsEntryError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "KdsEntry", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendKdsEntrySet(KdsEntryCallbackIF& cb, uint32 kdsEntry, const ::midw_diagnostics_fi_types::T_KDSItemList& kdsDataList) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_KdsEntry);
        ::boost::shared_ptr< KdsEntrySet > payload (new KdsEntrySet());
        payload->setKdsEntry(kdsEntry);
        payload->setKdsDataList(kdsDataList);
        CCA_MESSAGE(ccaMessage,header,KdsEntrySet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "KdsEntry", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_KdsEntry);
        ::boost::shared_ptr< KdsEntryError > payload (new KdsEntryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,KdsEntryError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "KdsEntry", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendDiagConfigItemUpReg(DiagConfigItemCallbackIF& cb, uint32 configItem) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DiagConfigItem);
        ::boost::shared_ptr< DiagConfigItemUpReg > payload (new DiagConfigItemUpReg());
        payload->setConfigItem(configItem);
        CCA_MESSAGE(ccaMessage,header,DiagConfigItemUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DiagConfigItemRelUpReg > payloadRelUpRegHeap (new DiagConfigItemRelUpReg());
        payloadRelUpRegHeap->setConfigItem(configItem);
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DiagConfigItem, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::DiagConfigItemRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DiagConfigItem, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DiagConfigItem", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DiagConfigItem", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDiagConfigItem(configItem)) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DiagConfigItem, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DiagConfigItemStatus > payloadLoopback (new DiagConfigItemStatus(getDiagConfigItem(configItem)));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DiagConfigItemStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DiagConfigItem);
        ::boost::shared_ptr< DiagConfigItemError > payload (new DiagConfigItemError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DiagConfigItemError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DiagConfigItem", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendDiagConfigItemRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DiagConfigItem,"DiagConfigItem");
}

void Midw_Diagnostics_FIProxy::sendDiagConfigItemRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DiagConfigItem);
}

const DiagConfigItemStatus& Midw_Diagnostics_FIProxy::getDiagConfigItem(uint32 configItem) const {
    DiagConfigItemRelUpReg payload(configItem);
    DiagConfigItemMap::const_iterator it = _diagConfigItemMap.find(payload);
    if (it != _diagConfigItemMap.end()) {
        return it->second;
    } else {
        std::string s;
        serializeJson (payload,s);
        LOG_FATAL("get%s(): No status object available which belongs to the passed parameter: %s", "DiagConfigItem", s.c_str());
    }
}

bool Midw_Diagnostics_FIProxy::hasDiagConfigItem(uint32 configItem) const {
    DiagConfigItemMap::const_iterator it = _diagConfigItemMap.find(DiagConfigItemRelUpReg(configItem));
    return ( it != _diagConfigItemMap.end() );
}

act_t Midw_Diagnostics_FIProxy::sendDiagConfigItemGet(DiagConfigItemCallbackIF& cb, uint32 configItem) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DiagConfigItem);
        ::boost::shared_ptr< DiagConfigItemGet > payload (new DiagConfigItemGet());
        payload->setConfigItem(configItem);
        CCA_MESSAGE(ccaMessage,header,DiagConfigItemGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DiagConfigItem", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DiagConfigItem);
        ::boost::shared_ptr< DiagConfigItemError > payload (new DiagConfigItemError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DiagConfigItemError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DiagConfigItem", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendDiagConfigItemSet(DiagConfigItemCallbackIF& cb, uint32 configItem, const ::midw_diagnostics_fi_types::T_ConfigItemList& configItemContent) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DiagConfigItem);
        ::boost::shared_ptr< DiagConfigItemSet > payload (new DiagConfigItemSet());
        payload->setConfigItem(configItem);
        payload->setConfigItemContent(configItemContent);
        CCA_MESSAGE(ccaMessage,header,DiagConfigItemSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DiagConfigItem", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DiagConfigItem);
        ::boost::shared_ptr< DiagConfigItemError > payload (new DiagConfigItemError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DiagConfigItemError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DiagConfigItem", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSetFactorySettingsStatusUpReg(SetFactorySettingsStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SetFactorySettingsStatus);
        ::boost::shared_ptr< SetFactorySettingsStatusUpReg > payload (new SetFactorySettingsStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,SetFactorySettingsStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SetFactorySettingsStatusRelUpReg > payloadRelUpRegHeap (new SetFactorySettingsStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SetFactorySettingsStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::SetFactorySettingsStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SetFactorySettingsStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SetFactorySettingsStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SetFactorySettingsStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSetFactorySettingsStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SetFactorySettingsStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SetFactorySettingsStatusStatus > payloadLoopback (new SetFactorySettingsStatusStatus(getSetFactorySettingsStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SetFactorySettingsStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetFactorySettingsStatus);
        ::boost::shared_ptr< SetFactorySettingsStatusError > payload (new SetFactorySettingsStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetFactorySettingsStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SetFactorySettingsStatus", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendSetFactorySettingsStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SetFactorySettingsStatus,"SetFactorySettingsStatus");
}

void Midw_Diagnostics_FIProxy::sendSetFactorySettingsStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SetFactorySettingsStatus);
}

const SetFactorySettingsStatusStatus& Midw_Diagnostics_FIProxy::getSetFactorySettingsStatus() const {
    return _setFactorySettingsStatus.get();
}

bool Midw_Diagnostics_FIProxy::hasSetFactorySettingsStatus() const {
    return _setFactorySettingsStatus.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendSetFactorySettingsStatusGet(SetFactorySettingsStatusCallbackIF& cb, uint8 defSetStateGroup, ::midw_diagnostics_fi_types::T_e8_DefSetMode defSetStateMode, bool defSetStateSuccessful, uint16 defSetStateFirstDifferentParameterId) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SetFactorySettingsStatus);
        ::boost::shared_ptr< SetFactorySettingsStatusGet > payload (new SetFactorySettingsStatusGet());
        payload->setDefSetStateGroup(defSetStateGroup);
        payload->setDefSetStateMode(defSetStateMode);
        payload->setDefSetStateSuccessful(defSetStateSuccessful);
        payload->setDefSetStateFirstDifferentParameterId(defSetStateFirstDifferentParameterId);
        CCA_MESSAGE(ccaMessage,header,SetFactorySettingsStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SetFactorySettingsStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetFactorySettingsStatus);
        ::boost::shared_ptr< SetFactorySettingsStatusError > payload (new SetFactorySettingsStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetFactorySettingsStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SetFactorySettingsStatus", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendSetFactorySettingsStatusSet(SetFactorySettingsStatusCallbackIF& cb, uint8 defSetStateGroup, ::midw_diagnostics_fi_types::T_e8_DefSetMode defSetStateMode, bool defSetStateSuccessful, uint16 defSetStateFirstDifferentParameterId) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SetFactorySettingsStatus);
        ::boost::shared_ptr< SetFactorySettingsStatusSet > payload (new SetFactorySettingsStatusSet());
        payload->setDefSetStateGroup(defSetStateGroup);
        payload->setDefSetStateMode(defSetStateMode);
        payload->setDefSetStateSuccessful(defSetStateSuccessful);
        payload->setDefSetStateFirstDifferentParameterId(defSetStateFirstDifferentParameterId);
        CCA_MESSAGE(ccaMessage,header,SetFactorySettingsStatusSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SetFactorySettingsStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetFactorySettingsStatus);
        ::boost::shared_ptr< SetFactorySettingsStatusError > payload (new SetFactorySettingsStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetFactorySettingsStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SetFactorySettingsStatus", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendRemoteControlUpReg(RemoteControlCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RemoteControl);
        ::boost::shared_ptr< RemoteControlUpReg > payload (new RemoteControlUpReg());
        CCA_MESSAGE(ccaMessage,header,RemoteControlUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RemoteControlRelUpReg > payloadRelUpRegHeap (new RemoteControlRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RemoteControl, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::RemoteControlRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RemoteControl, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RemoteControl", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RemoteControl", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRemoteControl()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RemoteControl, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RemoteControlStatus > payloadLoopback (new RemoteControlStatus(getRemoteControl()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RemoteControlStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RemoteControl);
        ::boost::shared_ptr< RemoteControlError > payload (new RemoteControlError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RemoteControlError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RemoteControl", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendRemoteControlRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RemoteControl,"RemoteControl");
}

void Midw_Diagnostics_FIProxy::sendRemoteControlRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RemoteControl);
}

const RemoteControlStatus& Midw_Diagnostics_FIProxy::getRemoteControl() const {
    return _remoteControl.get();
}

bool Midw_Diagnostics_FIProxy::hasRemoteControl() const {
    return _remoteControl.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendRemoteControlGet(RemoteControlCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_RCtrlSource src, ::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd, ::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RemoteControl);
        ::boost::shared_ptr< RemoteControlGet > payload (new RemoteControlGet());
        payload->setSrc(src);
        payload->setCmd(cmd);
        payload->setSignal(signal);
        CCA_MESSAGE(ccaMessage,header,RemoteControlGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RemoteControl", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RemoteControl);
        ::boost::shared_ptr< RemoteControlError > payload (new RemoteControlError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RemoteControlError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RemoteControl", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendRemoteControlSet(RemoteControlCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_RCtrlSource src, ::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd, ::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal, bool status) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_RemoteControl);
        ::boost::shared_ptr< RemoteControlSet > payload (new RemoteControlSet());
        payload->setSrc(src);
        payload->setCmd(cmd);
        payload->setSignal(signal);
        payload->setStatus(status);
        CCA_MESSAGE(ccaMessage,header,RemoteControlSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "RemoteControl", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RemoteControl);
        ::boost::shared_ptr< RemoteControlError > payload (new RemoteControlError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RemoteControlError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "RemoteControl", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendCISswUpdateProcessUpReg(CISswUpdateProcessCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CISswUpdateProcess);
        ::boost::shared_ptr< CISswUpdateProcessUpReg > payload (new CISswUpdateProcessUpReg());
        CCA_MESSAGE(ccaMessage,header,CISswUpdateProcessUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CISswUpdateProcessRelUpReg > payloadRelUpRegHeap (new CISswUpdateProcessRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CISswUpdateProcess, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::CISswUpdateProcessRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CISswUpdateProcess, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CISswUpdateProcess", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CISswUpdateProcess", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCISswUpdateProcess()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CISswUpdateProcess, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CISswUpdateProcessStatus > payloadLoopback (new CISswUpdateProcessStatus(getCISswUpdateProcess()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CISswUpdateProcessStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CISswUpdateProcess);
        ::boost::shared_ptr< CISswUpdateProcessError > payload (new CISswUpdateProcessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CISswUpdateProcessError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CISswUpdateProcess", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendCISswUpdateProcessRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CISswUpdateProcess,"CISswUpdateProcess");
}

void Midw_Diagnostics_FIProxy::sendCISswUpdateProcessRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CISswUpdateProcess);
}

const CISswUpdateProcessStatus& Midw_Diagnostics_FIProxy::getCISswUpdateProcess() const {
    return _cISswUpdateProcess.get();
}

bool Midw_Diagnostics_FIProxy::hasCISswUpdateProcess() const {
    return _cISswUpdateProcess.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendCISswUpdateProcessSet(CISswUpdateProcessCallbackIF& cb, bool status) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_CISswUpdateProcess);
        ::boost::shared_ptr< CISswUpdateProcessSet > payload (new CISswUpdateProcessSet());
        payload->setStatus(status);
        CCA_MESSAGE(ccaMessage,header,CISswUpdateProcessSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "CISswUpdateProcess", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CISswUpdateProcess);
        ::boost::shared_ptr< CISswUpdateProcessError > payload (new CISswUpdateProcessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CISswUpdateProcessError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "CISswUpdateProcess", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendCISswUpdateStage2ProcessUpReg(CISswUpdateStage2ProcessCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CISswUpdateStage2Process);
        ::boost::shared_ptr< CISswUpdateStage2ProcessUpReg > payload (new CISswUpdateStage2ProcessUpReg());
        CCA_MESSAGE(ccaMessage,header,CISswUpdateStage2ProcessUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CISswUpdateStage2ProcessRelUpReg > payloadRelUpRegHeap (new CISswUpdateStage2ProcessRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CISswUpdateStage2Process, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::CISswUpdateStage2ProcessRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CISswUpdateStage2Process, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CISswUpdateStage2Process", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CISswUpdateStage2Process", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCISswUpdateStage2Process()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CISswUpdateStage2Process, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CISswUpdateStage2ProcessStatus > payloadLoopback (new CISswUpdateStage2ProcessStatus(getCISswUpdateStage2Process()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CISswUpdateStage2ProcessStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CISswUpdateStage2Process);
        ::boost::shared_ptr< CISswUpdateStage2ProcessError > payload (new CISswUpdateStage2ProcessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CISswUpdateStage2ProcessError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CISswUpdateStage2Process", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendCISswUpdateStage2ProcessRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CISswUpdateStage2Process,"CISswUpdateStage2Process");
}

void Midw_Diagnostics_FIProxy::sendCISswUpdateStage2ProcessRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CISswUpdateStage2Process);
}

const CISswUpdateStage2ProcessStatus& Midw_Diagnostics_FIProxy::getCISswUpdateStage2Process() const {
    return _cISswUpdateStage2Process.get();
}

bool Midw_Diagnostics_FIProxy::hasCISswUpdateStage2Process() const {
    return _cISswUpdateStage2Process.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendCISswUpdateStage2ProcessSet(CISswUpdateStage2ProcessCallbackIF& cb, bool status) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_CISswUpdateStage2Process);
        ::boost::shared_ptr< CISswUpdateStage2ProcessSet > payload (new CISswUpdateStage2ProcessSet());
        payload->setStatus(status);
        CCA_MESSAGE(ccaMessage,header,CISswUpdateStage2ProcessSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "CISswUpdateStage2Process", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CISswUpdateStage2Process);
        ::boost::shared_ptr< CISswUpdateStage2ProcessError > payload (new CISswUpdateStage2ProcessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CISswUpdateStage2ProcessError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "CISswUpdateStage2Process", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendCalibrationParameterUpReg(CalibrationParameterCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CalibrationParameter);
        ::boost::shared_ptr< CalibrationParameterUpReg > payload (new CalibrationParameterUpReg());
        CCA_MESSAGE(ccaMessage,header,CalibrationParameterUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CalibrationParameterRelUpReg > payloadRelUpRegHeap (new CalibrationParameterRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CalibrationParameter, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::CalibrationParameterRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CalibrationParameter, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CalibrationParameter", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CalibrationParameter", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCalibrationParameter()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CalibrationParameter, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CalibrationParameterStatus > payloadLoopback (new CalibrationParameterStatus(getCalibrationParameter()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CalibrationParameterStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CalibrationParameter);
        ::boost::shared_ptr< CalibrationParameterError > payload (new CalibrationParameterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CalibrationParameterError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CalibrationParameter", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendCalibrationParameterRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CalibrationParameter,"CalibrationParameter");
}

void Midw_Diagnostics_FIProxy::sendCalibrationParameterRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CalibrationParameter);
}

const CalibrationParameterStatus& Midw_Diagnostics_FIProxy::getCalibrationParameter() const {
    return _calibrationParameter.get();
}

bool Midw_Diagnostics_FIProxy::hasCalibrationParameter() const {
    return _calibrationParameter.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendCalibrationParameterGet(CalibrationParameterCallbackIF& cb, uint32 sessionHandle, const ::std::string& name) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_CalibrationParameter);
        ::boost::shared_ptr< CalibrationParameterGet > payload (new CalibrationParameterGet());
        payload->setSessionHandle(sessionHandle);
        payload->setName(name);
        CCA_MESSAGE(ccaMessage,header,CalibrationParameterGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "CalibrationParameter", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CalibrationParameter);
        ::boost::shared_ptr< CalibrationParameterError > payload (new CalibrationParameterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CalibrationParameterError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "CalibrationParameter", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendCalibrationParameterSet(CalibrationParameterCallbackIF& cb, uint32 sessionHandle, const ::std::string& name, const ::midw_diagnostics_fi_types::T_CalibrationValue& value) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_CalibrationParameter);
        ::boost::shared_ptr< CalibrationParameterSet > payload (new CalibrationParameterSet());
        payload->setSessionHandle(sessionHandle);
        payload->setName(name);
        payload->setValue(value);
        CCA_MESSAGE(ccaMessage,header,CalibrationParameterSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "CalibrationParameter", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CalibrationParameter);
        ::boost::shared_ptr< CalibrationParameterError > payload (new CalibrationParameterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CalibrationParameterError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "CalibrationParameter", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendPartNumberUpReg(PartNumberCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_PartNumber);
        ::boost::shared_ptr< PartNumberUpReg > payload (new PartNumberUpReg());
        CCA_MESSAGE(ccaMessage,header,PartNumberUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< PartNumberRelUpReg > payloadRelUpRegHeap (new PartNumberRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_PartNumber, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::Midw_Diagnostics_FI::PartNumberRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_PartNumber, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "PartNumber", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "PartNumber", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasPartNumber()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_PartNumber, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< PartNumberStatus > payloadLoopback (new PartNumberStatus(getPartNumber()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,PartNumberStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PartNumber);
        ::boost::shared_ptr< PartNumberError > payload (new PartNumberError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PartNumberError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "PartNumber", &cb);
    }
}

bool Midw_Diagnostics_FIProxy::sendPartNumberRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_PartNumber,"PartNumber");
}

void Midw_Diagnostics_FIProxy::sendPartNumberRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_PartNumber);
}

const PartNumberStatus& Midw_Diagnostics_FIProxy::getPartNumber() const {
    return _partNumber.get();
}

bool Midw_Diagnostics_FIProxy::hasPartNumber() const {
    return _partNumber.hasValue();
}

act_t Midw_Diagnostics_FIProxy::sendPartNumberGet(PartNumberCallbackIF& cb, uint8 dataIdentifier) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_PartNumber);
        ::boost::shared_ptr< PartNumberGet > payload (new PartNumberGet());
        payload->setDataIdentifier(dataIdentifier);
        CCA_MESSAGE(ccaMessage,header,PartNumberGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "PartNumber", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PartNumber);
        ::boost::shared_ptr< PartNumberError > payload (new PartNumberError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PartNumberError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "PartNumber", &cb);
    }
}

act_t Midw_Diagnostics_FIProxy::sendPartNumberSet(PartNumberCallbackIF& cb, uint8 dataIdentifier, uint32 partNumber, const ::midw_diagnostics_fi_types::T_AlphaCode& alphaCode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_PartNumber);
        ::boost::shared_ptr< PartNumberSet > payload (new PartNumberSet());
        payload->setDataIdentifier(dataIdentifier);
        payload->setPartNumber(partNumber);
        payload->setAlphaCode(alphaCode);
        CCA_MESSAGE(ccaMessage,header,PartNumberSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "PartNumber", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PartNumber);
        ::boost::shared_ptr< PartNumberError > payload (new PartNumberError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PartNumberError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "PartNumber", &cb);
    }
}


void Midw_Diagnostics_FIProxy::clearAllProperties ()
{
    _startRouteCalculation = ::asf::core::nullable<StartRouteCalculationStatus>();
    _routeCalculationResult = ::asf::core::nullable<RouteCalculationResultStatus>();
    _setLocaleStart = ::asf::core::nullable<SetLocaleStartStatus>();
    _setLocaleResult = ::asf::core::nullable<SetLocaleResultStatus>();
    _getLocale = ::asf::core::nullable<GetLocaleStatus>();
    _setDisplay = ::asf::core::nullable<SetDisplayStatus>();
    _configUpdateViaUSB = ::asf::core::nullable<ConfigUpdateViaUSBStatus>();
    _antiTheftStatus = ::asf::core::nullable<AntiTheftStatusStatus>();
    _antiTheftUnlockHMI = ::asf::core::nullable<AntiTheftUnlockHMIStatus>();
    _antiTheftUnlockHU = ::asf::core::nullable<AntiTheftUnlockHUStatus>();
    _clearDestinationMemory = ::asf::core::nullable<ClearDestinationMemoryStatus>();
    _getDestinationMemorySize = ::asf::core::nullable<GetDestinationMemorySizeStatus>();
    _simulateKeyPress = ::asf::core::nullable<SimulateKeyPressStatus>();
    _resetSecurity = ::asf::core::nullable<ResetSecurityStatus>();
    _language = ::asf::core::nullable<LanguageStatus>();
    _speedLock = ::asf::core::nullable<SpeedLockStatus>();
    _spdLock = ::asf::core::nullable<SpdLockStatus>();
    _setRVCSignal = ::asf::core::nullable<SetRVCSignalStatus>();
    _rVCSignalStatus = ::asf::core::nullable<RVCSignalStatusStatus>();
    _kdsEntryMap.clear();
    _diagConfigItemMap.clear();
    _setFactorySettingsStatus = ::asf::core::nullable<SetFactorySettingsStatusStatus>();
    _remoteControl = ::asf::core::nullable<RemoteControlStatus>();
    _cISswUpdateProcess = ::asf::core::nullable<CISswUpdateProcessStatus>();
    _cISswUpdateStage2Process = ::asf::core::nullable<CISswUpdateStage2ProcessStatus>();
    _calibrationParameter = ::asf::core::nullable<CalibrationParameterStatus>();
    _partNumber = ::asf::core::nullable<PartNumberStatus>();
}

void Midw_Diagnostics_FIProxy::sendRelUpRegAll()
{
    sendStartRouteCalculationRelUpRegAll();
    sendRouteCalculationResultRelUpRegAll();
    sendSetLocaleStartRelUpRegAll();
    sendSetLocaleResultRelUpRegAll();
    sendGetLocaleRelUpRegAll();
    sendSetDisplayRelUpRegAll();
    sendConfigUpdateViaUSBRelUpRegAll();
    sendAntiTheftStatusRelUpRegAll();
    sendAntiTheftUnlockHMIRelUpRegAll();
    sendAntiTheftUnlockHURelUpRegAll();
    sendClearDestinationMemoryRelUpRegAll();
    sendGetDestinationMemorySizeRelUpRegAll();
    sendSimulateKeyPressRelUpRegAll();
    sendResetSecurityRelUpRegAll();
    sendLanguageRelUpRegAll();
    sendSpeedLockRelUpRegAll();
    sendSpdLockRelUpRegAll();
    sendSetRVCSignalRelUpRegAll();
    sendRVCSignalStatusRelUpRegAll();
    sendKdsEntryRelUpRegAll();
    sendDiagConfigItemRelUpRegAll();
    sendSetFactorySettingsStatusRelUpRegAll();
    sendRemoteControlRelUpRegAll();
    sendCISswUpdateProcessRelUpRegAll();
    sendCISswUpdateStage2ProcessRelUpRegAll();
    sendCalibrationParameterRelUpRegAll();
    sendPartNumberRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Midw_Diagnostics_FIProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Midw_Diagnostics_FIProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace Midw_Diagnostics_FI
