/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "Midw_Diagnostics_FI.h"
#include "Midw_Diagnostics_FIJson.h"
#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "midw_diagnostics_fi_types.h"
#include "midw_diagnostics_fi_typesConst.h"
#include "midw_diagnostics_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "TestMessageStart"

void serializeJson (const ::Midw_Diagnostics_FI::TestMessageStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProtocolId()) {
        yajl_gen_string(g, (const unsigned char*)  "ProtocolId" , 10);
        yajl_gen_integer(g, (long long)value.getProtocolId());
    }
    if (!isSparse || value.hasMessageBuffer()) {
        yajl_gen_string(g, (const unsigned char*)  "MessageBuffer" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o1 = value.getMessageBuffer();
        {
            ::std::vector< uint8 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::TestMessageStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TestMessageResult"

void serializeJson (const ::Midw_Diagnostics_FI::TestMessageResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProtocolId()) {
        yajl_gen_string(g, (const unsigned char*)  "ProtocolId" , 10);
        yajl_gen_integer(g, (long long)value.getProtocolId());
    }
    if (!isSparse || value.hasMessageBuffer()) {
        yajl_gen_string(g, (const unsigned char*)  "MessageBuffer" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o3 = value.getMessageBuffer();
        {
            ::std::vector< uint8 >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                yajl_gen_integer(g, (long long)(*o2));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::TestMessageResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiagRequestStart"

void serializeJson (const ::Midw_Diagnostics_FI::DiagRequestStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProtID()) {
        yajl_gen_string(g, (const unsigned char*)  "protID" , 6);
        const char* s = ::midw_diagnostics_fi_types::T_DiagProtocol_Name(value.getProtID());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getProtID());
    }
    if (!isSparse || value.hasDiagData()) {
        yajl_gen_string(g, (const unsigned char*)  "diagData" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o5 = value.getDiagData();
        {
            ::std::vector< uint8 >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                yajl_gen_integer(g, (long long)(*o4));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasCookie()) {
        yajl_gen_string(g, (const unsigned char*)  "cookie" , 6);
        yajl_gen_integer(g, (long long)value.getCookie());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::DiagRequestStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiagRequestResult"

void serializeJson (const ::Midw_Diagnostics_FI::DiagRequestResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProtID()) {
        yajl_gen_string(g, (const unsigned char*)  "protID" , 6);
        const char* s = ::midw_diagnostics_fi_types::T_DiagProtocol_Name(value.getProtID());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getProtID());
    }
    if (!isSparse || value.hasDiagData()) {
        yajl_gen_string(g, (const unsigned char*)  "diagData" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o7 = value.getDiagData();
        {
            ::std::vector< uint8 >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                yajl_gen_integer(g, (long long)(*o6));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasCookie()) {
        yajl_gen_string(g, (const unsigned char*)  "cookie" , 6);
        yajl_gen_integer(g, (long long)value.getCookie());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::DiagRequestResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartRouteCalculationStatus"

void serializeJson (const ::Midw_Diagnostics_FI::StartRouteCalculationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRouteDetails()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteDetails" , 12);
        serializeJson(value.getRouteDetails(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::StartRouteCalculationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartRouteCalculationSet"

void serializeJson (const ::Midw_Diagnostics_FI::StartRouteCalculationSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCalculationStarted()) {
        yajl_gen_string(g, (const unsigned char*)  "CalculationStarted" , 18);
        yajl_gen_bool(g, (bool)value.getCalculationStarted());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::StartRouteCalculationSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RouteCalculationResultStatus"

void serializeJson (const ::Midw_Diagnostics_FI::RouteCalculationResultStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCalculationResultRequested()) {
        yajl_gen_string(g, (const unsigned char*)  "CalculationResultRequested" , 26);
        yajl_gen_bool(g, (bool)value.getCalculationResultRequested());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::RouteCalculationResultStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RouteCalculationResultSet"

void serializeJson (const ::Midw_Diagnostics_FI::RouteCalculationResultSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCalculationResult()) {
        yajl_gen_string(g, (const unsigned char*)  "CalculationResult" , 17);
        serializeJson(value.getCalculationResult(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::RouteCalculationResultSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetLocaleStartStatus"

void serializeJson (const ::Midw_Diagnostics_FI::SetLocaleStartStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCountryLanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "CountryLanguage" , 15);
        serializeJson(value.getCountryLanguage(), g, options);
    }
    if (!isSparse || value.hasStore()) {
        yajl_gen_string(g, (const unsigned char*)  "Store" , 5);
        const char* s = ::midw_diagnostics_fi_types::T_e8_Store_Name(value.getStore());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStore());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetLocaleStartStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetLocaleStartSet"

void serializeJson (const ::Midw_Diagnostics_FI::SetLocaleStartSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocaleSwitched()) {
        yajl_gen_string(g, (const unsigned char*)  "LocaleSwitched" , 14);
        yajl_gen_bool(g, (bool)value.getLocaleSwitched());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetLocaleStartSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetLocaleResultStatus"

void serializeJson (const ::Midw_Diagnostics_FI::SetLocaleResultStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSetLocaleResultRequested()) {
        yajl_gen_string(g, (const unsigned char*)  "SetLocaleResultRequested" , 24);
        yajl_gen_bool(g, (bool)value.getSetLocaleResultRequested());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetLocaleResultStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetLocaleResultSet"

void serializeJson (const ::Midw_Diagnostics_FI::SetLocaleResultSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCountryLanguageResult()) {
        yajl_gen_string(g, (const unsigned char*)  "CountryLanguageResult" , 21);
        serializeJson(value.getCountryLanguageResult(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetLocaleResultSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetLocaleStatus"

void serializeJson (const ::Midw_Diagnostics_FI::GetLocaleStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGetLocaleRequested()) {
        yajl_gen_string(g, (const unsigned char*)  "GetLocaleRequested" , 18);
        yajl_gen_bool(g, (bool)value.getGetLocaleRequested());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::GetLocaleStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetLocaleSet"

void serializeJson (const ::Midw_Diagnostics_FI::GetLocaleSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCountryLanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "CountryLanguage" , 15);
        serializeJson(value.getCountryLanguage(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::GetLocaleSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDisplayStatus"

void serializeJson (const ::Midw_Diagnostics_FI::SetDisplayStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDisplayData()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayData" , 11);
        serializeJson(value.getDisplayData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetDisplayStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDisplaySet"

void serializeJson (const ::Midw_Diagnostics_FI::SetDisplaySet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDisplayTestSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayTestSuccess" , 18);
        yajl_gen_bool(g, (bool)value.getDisplayTestSuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetDisplaySet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConfigUpdateViaUSBStatus"

void serializeJson (const ::Midw_Diagnostics_FI::ConfigUpdateViaUSBStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfigUpdateStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ConfigUpdateStatus" , 18);
        const char* s = ::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus_Name(value.getConfigUpdateStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getConfigUpdateStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::ConfigUpdateViaUSBStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AntiTheftStatusSet"

void serializeJson (const ::Midw_Diagnostics_FI::AntiTheftStatusSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAntiTheftStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "AntiTheftStatus" , 15);
        const char* s = ::midw_diagnostics_fi_types::T_AntiTheftStatus_Name(value.getAntiTheftStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAntiTheftStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::AntiTheftStatusSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AntiTheftUnlockHMIStatus"

void serializeJson (const ::Midw_Diagnostics_FI::AntiTheftUnlockHMIStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVIDWriteStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "VIDWriteStatus" , 14);
        yajl_gen_bool(g, (bool)value.getVIDWriteStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::AntiTheftUnlockHMIStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AntiTheftUnlockHUStatus"

void serializeJson (const ::Midw_Diagnostics_FI::AntiTheftUnlockHUStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPINValidationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "PINValidationStatus" , 19);
        yajl_gen_bool(g, (bool)value.getPINValidationStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::AntiTheftUnlockHUStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClearDestinationMemoryStatus"

void serializeJson (const ::Midw_Diagnostics_FI::ClearDestinationMemoryStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClearMemory()) {
        yajl_gen_string(g, (const unsigned char*)  "ClearMemory" , 11);
        yajl_gen_bool(g, (bool)value.getClearMemory());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::ClearDestinationMemoryStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClearDestinationMemorySet"

void serializeJson (const ::Midw_Diagnostics_FI::ClearDestinationMemorySet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClearMemorySuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "ClearMemorySuccess" , 18);
        yajl_gen_bool(g, (bool)value.getClearMemorySuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::ClearDestinationMemorySet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDestinationMemorySizeStatus"

void serializeJson (const ::Midw_Diagnostics_FI::GetDestinationMemorySizeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGetMemorySize()) {
        yajl_gen_string(g, (const unsigned char*)  "GetMemorySize" , 13);
        yajl_gen_bool(g, (bool)value.getGetMemorySize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::GetDestinationMemorySizeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDestinationMemorySizeSet"

void serializeJson (const ::Midw_Diagnostics_FI::GetDestinationMemorySizeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRecordCount()) {
        yajl_gen_string(g, (const unsigned char*)  "RecordCount" , 11);
        yajl_gen_integer(g, (long long)value.getRecordCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::GetDestinationMemorySizeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimulateKeyPressStatus"

void serializeJson (const ::Midw_Diagnostics_FI::SimulateKeyPressStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKeyCommand()) {
        yajl_gen_string(g, (const unsigned char*)  "KeyCommand" , 10);
        const char* s = ::midw_diagnostics_fi_types::T_e8_SimulatedKeys_Name(value.getKeyCommand());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getKeyCommand());
    }
    if (!isSparse || value.hasEncoderSteps()) {
        yajl_gen_string(g, (const unsigned char*)  "EncoderSteps" , 12);
        yajl_gen_integer(g, (long long)value.getEncoderSteps());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SimulateKeyPressStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimulateKeyPressSet"

void serializeJson (const ::Midw_Diagnostics_FI::SimulateKeyPressSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKeyPressSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "KeyPressSuccess" , 15);
        yajl_gen_bool(g, (bool)value.getKeyPressSuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SimulateKeyPressSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResetSecurityStatus"

void serializeJson (const ::Midw_Diagnostics_FI::ResetSecurityStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasReset()) {
        yajl_gen_string(g, (const unsigned char*)  "Reset" , 5);
        yajl_gen_bool(g, (bool)value.getReset());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::ResetSecurityStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResetSecuritySet"

void serializeJson (const ::Midw_Diagnostics_FI::ResetSecuritySet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResetSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "ResetSuccess" , 12);
        yajl_gen_bool(g, (bool)value.getResetSuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::ResetSecuritySet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LanguageGet"

void serializeJson (const ::Midw_Diagnostics_FI::LanguageGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "Language" , 8);
        const char* s = ::midw_diagnostics_fi_types::T_e16_Language_Name(value.getLanguage());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLanguage());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::LanguageGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpeedLockStatus"

void serializeJson (const ::Midw_Diagnostics_FI::SpeedLockStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSpeedLockStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SpeedLockStatus" , 15);
        const char* s = ::midw_diagnostics_fi_types::T_e16_SpeedLock_Name(value.getSpeedLockStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSpeedLockStatus());
    }
    if (!isSparse || value.hasSpeedLockThreshold()) {
        yajl_gen_string(g, (const unsigned char*)  "SpeedLockThreshold" , 18);
        yajl_gen_integer(g, (long long)value.getSpeedLockThreshold());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SpeedLockStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpeedLockGet"

void serializeJson (const ::Midw_Diagnostics_FI::SpeedLockGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSpeedLock()) {
        yajl_gen_string(g, (const unsigned char*)  "SpeedLock" , 9);
        const char* s = ::midw_diagnostics_fi_types::T_e16_SpeedLock_Name(value.getSpeedLock());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSpeedLock());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SpeedLockGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpdLockStatus"

void serializeJson (const ::Midw_Diagnostics_FI::SpdLockStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSpeedLockStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SpeedLockStatus" , 15);
        yajl_gen_bool(g, (bool)value.getSpeedLockStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SpdLockStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpdLockSet"

void serializeJson (const ::Midw_Diagnostics_FI::SpdLockSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSpeedLock()) {
        yajl_gen_string(g, (const unsigned char*)  "SpeedLock" , 9);
        const char* s = ::midw_diagnostics_fi_types::T_e16_SpeedLock_Name(value.getSpeedLock());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSpeedLock());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SpdLockSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRVCSignalStatus"

void serializeJson (const ::Midw_Diagnostics_FI::SetRVCSignalStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSignalStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SignalStatus" , 12);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal_Name(value.getSignalStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSignalStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetRVCSignalStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRVCSignalSet"

void serializeJson (const ::Midw_Diagnostics_FI::SetRVCSignalSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatusChanged()) {
        yajl_gen_string(g, (const unsigned char*)  "StatusChanged" , 13);
        yajl_gen_bool(g, (bool)value.getStatusChanged());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetRVCSignalSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRVCSignalGet"

void serializeJson (const ::Midw_Diagnostics_FI::SetRVCSignalGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSignalStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SignalStatus" , 12);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal_Name(value.getSignalStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSignalStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetRVCSignalGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RVCSignalStatusStatus"

void serializeJson (const ::Midw_Diagnostics_FI::RVCSignalStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequestStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "RequestStatus" , 13);
        yajl_gen_bool(g, (bool)value.getRequestStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::RVCSignalStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RVCSignalStatusSet"

void serializeJson (const ::Midw_Diagnostics_FI::RVCSignalStatusSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSignalStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SignalStatus" , 12);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal_Name(value.getSignalStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSignalStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::RVCSignalStatusSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KdsEntryStatus"

void serializeJson (const ::Midw_Diagnostics_FI::KdsEntryStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKdsEntry()) {
        yajl_gen_string(g, (const unsigned char*)  "KdsEntry" , 8);
        yajl_gen_integer(g, (long long)value.getKdsEntry());
    }
    if (!isSparse || value.hasKdsDataList()) {
        yajl_gen_string(g, (const unsigned char*)  "KdsDataList" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o9 = value.getKdsDataList();
        {
            ::std::vector< uint8 >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                yajl_gen_integer(g, (long long)(*o8));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::KdsEntryStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KdsEntrySet"

void serializeJson (const ::Midw_Diagnostics_FI::KdsEntrySet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKdsEntry()) {
        yajl_gen_string(g, (const unsigned char*)  "KdsEntry" , 8);
        yajl_gen_integer(g, (long long)value.getKdsEntry());
    }
    if (!isSparse || value.hasKdsDataList()) {
        yajl_gen_string(g, (const unsigned char*)  "KdsDataList" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o11 = value.getKdsDataList();
        {
            ::std::vector< uint8 >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                yajl_gen_integer(g, (long long)(*o10));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::KdsEntrySet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KdsEntryGet"

void serializeJson (const ::Midw_Diagnostics_FI::KdsEntryGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKdsEntry()) {
        yajl_gen_string(g, (const unsigned char*)  "KdsEntry" , 8);
        yajl_gen_integer(g, (long long)value.getKdsEntry());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::KdsEntryGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KdsEntryUpReg"

void serializeJson (const ::Midw_Diagnostics_FI::KdsEntryUpReg& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKdsEntry()) {
        yajl_gen_string(g, (const unsigned char*)  "KdsEntry" , 8);
        yajl_gen_integer(g, (long long)value.getKdsEntry());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::KdsEntryUpReg& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "KdsEntryRelUpReg"

void serializeJson (const ::Midw_Diagnostics_FI::KdsEntryRelUpReg& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKdsEntry()) {
        yajl_gen_string(g, (const unsigned char*)  "KdsEntry" , 8);
        yajl_gen_integer(g, (long long)value.getKdsEntry());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::KdsEntryRelUpReg& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiagConfigItemStatus"

void serializeJson (const ::Midw_Diagnostics_FI::DiagConfigItemStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfigItem()) {
        yajl_gen_string(g, (const unsigned char*)  "ConfigItem" , 10);
        yajl_gen_integer(g, (long long)value.getConfigItem());
    }
    if (!isSparse || value.hasConfigItemValid()) {
        yajl_gen_string(g, (const unsigned char*)  "ConfigItemValid" , 15);
        yajl_gen_bool(g, (bool)value.getConfigItemValid());
    }
    if (!isSparse || value.hasConfigItemContent()) {
        yajl_gen_string(g, (const unsigned char*)  "ConfigItemContent" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o13 = value.getConfigItemContent();
        {
            ::std::vector< uint8 >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                yajl_gen_integer(g, (long long)(*o12));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::DiagConfigItemStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiagConfigItemSet"

void serializeJson (const ::Midw_Diagnostics_FI::DiagConfigItemSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfigItem()) {
        yajl_gen_string(g, (const unsigned char*)  "ConfigItem" , 10);
        yajl_gen_integer(g, (long long)value.getConfigItem());
    }
    if (!isSparse || value.hasConfigItemContent()) {
        yajl_gen_string(g, (const unsigned char*)  "ConfigItemContent" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o15 = value.getConfigItemContent();
        {
            ::std::vector< uint8 >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                yajl_gen_integer(g, (long long)(*o14));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::DiagConfigItemSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiagConfigItemGet"

void serializeJson (const ::Midw_Diagnostics_FI::DiagConfigItemGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfigItem()) {
        yajl_gen_string(g, (const unsigned char*)  "ConfigItem" , 10);
        yajl_gen_integer(g, (long long)value.getConfigItem());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::DiagConfigItemGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiagConfigItemUpReg"

void serializeJson (const ::Midw_Diagnostics_FI::DiagConfigItemUpReg& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfigItem()) {
        yajl_gen_string(g, (const unsigned char*)  "ConfigItem" , 10);
        yajl_gen_integer(g, (long long)value.getConfigItem());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::DiagConfigItemUpReg& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiagConfigItemRelUpReg"

void serializeJson (const ::Midw_Diagnostics_FI::DiagConfigItemRelUpReg& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfigItem()) {
        yajl_gen_string(g, (const unsigned char*)  "ConfigItem" , 10);
        yajl_gen_integer(g, (long long)value.getConfigItem());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::DiagConfigItemRelUpReg& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReadDiagLogStart"

void serializeJson (const ::Midw_Diagnostics_FI::ReadDiagLogStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTroubleCodes()) {
        yajl_gen_string(g, (const unsigned char*)  "TroubleCodes" , 12);
        const char* s = ::midw_diagnostics_fi_types::T_e8_TroubleCodeType_Name(value.getTroubleCodes());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTroubleCodes());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::ReadDiagLogStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReadDiagLogResult"

void serializeJson (const ::Midw_Diagnostics_FI::ReadDiagLogResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTroubleCodes()) {
        yajl_gen_string(g, (const unsigned char*)  "TroubleCodes" , 12);
        const char* s = ::midw_diagnostics_fi_types::T_e8_TroubleCodeType_Name(value.getTroubleCodes());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTroubleCodes());
    }
    if (!isSparse || value.hasTroubleCodeList()) {
        yajl_gen_string(g, (const unsigned char*)  "TroubleCodeList" , 15);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_diagnostics_fi_types::T_TroubleCode >& o17 = value.getTroubleCodeList();
        {
            ::std::vector< ::midw_diagnostics_fi_types::T_TroubleCode >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                serializeJson((*o16), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::ReadDiagLogResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClearDiagLogStart"

void serializeJson (const ::Midw_Diagnostics_FI::ClearDiagLogStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTroubleCodes()) {
        yajl_gen_string(g, (const unsigned char*)  "TroubleCodes" , 12);
        const char* s = ::midw_diagnostics_fi_types::T_e8_TroubleCodeType_Name(value.getTroubleCodes());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTroubleCodes());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::ClearDiagLogStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClearDiagLogResult"

void serializeJson (const ::Midw_Diagnostics_FI::ClearDiagLogResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTroubleCodes()) {
        yajl_gen_string(g, (const unsigned char*)  "TroubleCodes" , 12);
        const char* s = ::midw_diagnostics_fi_types::T_e8_TroubleCodeType_Name(value.getTroubleCodes());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTroubleCodes());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::ClearDiagLogResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartDiagnosticTestStart"

void serializeJson (const ::Midw_Diagnostics_FI::StartDiagnosticTestStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTestRoutine()) {
        yajl_gen_string(g, (const unsigned char*)  "TestRoutine" , 11);
        const char* s = ::midw_diagnostics_fi_types::T_e8_TestRoutines_Name(value.getTestRoutine());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTestRoutine());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::StartDiagnosticTestStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartDiagnosticTestResult"

void serializeJson (const ::Midw_Diagnostics_FI::StartDiagnosticTestResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTestRoutine()) {
        yajl_gen_string(g, (const unsigned char*)  "TestRoutine" , 11);
        const char* s = ::midw_diagnostics_fi_types::T_e8_TestRoutines_Name(value.getTestRoutine());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTestRoutine());
    }
    if (!isSparse || value.hasSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "Success" , 7);
        yajl_gen_bool(g, (bool)value.getSuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::StartDiagnosticTestResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDefaultSettingsStart"

void serializeJson (const ::Midw_Diagnostics_FI::SetDefaultSettingsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSettingsCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "SettingsCategory" , 16);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories_Name(value.getSettingsCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSettingsCategory());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetDefaultSettingsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDefaultSettingsResult"

void serializeJson (const ::Midw_Diagnostics_FI::SetDefaultSettingsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSettingsSuccessful()) {
        yajl_gen_string(g, (const unsigned char*)  "SettingsSuccessful" , 18);
        yajl_gen_bool(g, (bool)value.getSettingsSuccessful());
    }
    if (!isSparse || value.hasSettingsCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "SettingsCategory" , 16);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories_Name(value.getSettingsCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSettingsCategory());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetDefaultSettingsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnableTimeSlotStart"

void serializeJson (const ::Midw_Diagnostics_FI::EnableTimeSlotStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMausSetup()) {
        yajl_gen_string(g, (const unsigned char*)  "MausSetup" , 9);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DiagMausSetup_Name(value.getMausSetup());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMausSetup());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::EnableTimeSlotStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnableTimeSlotResult"

void serializeJson (const ::Midw_Diagnostics_FI::EnableTimeSlotResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEnableSuccessful()) {
        yajl_gen_string(g, (const unsigned char*)  "EnableSuccessful" , 16);
        yajl_gen_bool(g, (bool)value.getEnableSuccessful());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::EnableTimeSlotResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopDiagnosticTestStart"

void serializeJson (const ::Midw_Diagnostics_FI::StopDiagnosticTestStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTestRoutine()) {
        yajl_gen_string(g, (const unsigned char*)  "TestRoutine" , 11);
        const char* s = ::midw_diagnostics_fi_types::T_e8_TestRoutines_Name(value.getTestRoutine());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTestRoutine());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::StopDiagnosticTestStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopDiagnosticTestResult"

void serializeJson (const ::Midw_Diagnostics_FI::StopDiagnosticTestResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTestRoutine()) {
        yajl_gen_string(g, (const unsigned char*)  "TestRoutine" , 11);
        const char* s = ::midw_diagnostics_fi_types::T_e8_TestRoutines_Name(value.getTestRoutine());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTestRoutine());
    }
    if (!isSparse || value.hasSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "Success" , 7);
        yajl_gen_bool(g, (bool)value.getSuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::StopDiagnosticTestResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFactorySettingsStatusStatus"

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefSetStateGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateGroup" , 16);
        yajl_gen_integer(g, (long long)value.getDefSetStateGroup());
    }
    if (!isSparse || value.hasDefSetStateMode()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateMode" , 15);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DefSetMode_Name(value.getDefSetStateMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateMode());
    }
    if (!isSparse || value.hasDefSetStateSuccessful()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateSuccessful" , 21);
        yajl_gen_bool(g, (bool)value.getDefSetStateSuccessful());
    }
    if (!isSparse || value.hasDefSetStateFirstDifferentParameterId()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateFirstDifferentParameterId" , 36);
        yajl_gen_integer(g, (long long)value.getDefSetStateFirstDifferentParameterId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFactorySettingsStatusSet"

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsStatusSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefSetStateGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateGroup" , 16);
        yajl_gen_integer(g, (long long)value.getDefSetStateGroup());
    }
    if (!isSparse || value.hasDefSetStateMode()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateMode" , 15);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DefSetMode_Name(value.getDefSetStateMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateMode());
    }
    if (!isSparse || value.hasDefSetStateSuccessful()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateSuccessful" , 21);
        yajl_gen_bool(g, (bool)value.getDefSetStateSuccessful());
    }
    if (!isSparse || value.hasDefSetStateFirstDifferentParameterId()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateFirstDifferentParameterId" , 36);
        yajl_gen_integer(g, (long long)value.getDefSetStateFirstDifferentParameterId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsStatusSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFactorySettingsStatusGet"

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsStatusGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefSetStateGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateGroup" , 16);
        yajl_gen_integer(g, (long long)value.getDefSetStateGroup());
    }
    if (!isSparse || value.hasDefSetStateMode()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateMode" , 15);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DefSetMode_Name(value.getDefSetStateMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateMode());
    }
    if (!isSparse || value.hasDefSetStateSuccessful()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateSuccessful" , 21);
        yajl_gen_bool(g, (bool)value.getDefSetStateSuccessful());
    }
    if (!isSparse || value.hasDefSetStateFirstDifferentParameterId()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateFirstDifferentParameterId" , 36);
        yajl_gen_integer(g, (long long)value.getDefSetStateFirstDifferentParameterId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsStatusGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RemoteControlStatus"

void serializeJson (const ::Midw_Diagnostics_FI::RemoteControlStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSrc()) {
        yajl_gen_string(g, (const unsigned char*)  "src" , 3);
        const char* s = ::midw_diagnostics_fi_types::T_e8_RCtrlSource_Name(value.getSrc());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSrc());
    }
    if (!isSparse || value.hasCmd()) {
        yajl_gen_string(g, (const unsigned char*)  "cmd" , 3);
        const char* s = ::midw_diagnostics_fi_types::T_e8_RCtrlCommand_Name(value.getCmd());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCmd());
    }
    if (!isSparse || value.hasSignal()) {
        yajl_gen_string(g, (const unsigned char*)  "signal" , 6);
        const char* s = ::midw_diagnostics_fi_types::T_e8_RCtrlSignal_Name(value.getSignal());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSignal());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::RemoteControlStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RemoteControlSet"

void serializeJson (const ::Midw_Diagnostics_FI::RemoteControlSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSrc()) {
        yajl_gen_string(g, (const unsigned char*)  "src" , 3);
        const char* s = ::midw_diagnostics_fi_types::T_e8_RCtrlSource_Name(value.getSrc());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSrc());
    }
    if (!isSparse || value.hasCmd()) {
        yajl_gen_string(g, (const unsigned char*)  "cmd" , 3);
        const char* s = ::midw_diagnostics_fi_types::T_e8_RCtrlCommand_Name(value.getCmd());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCmd());
    }
    if (!isSparse || value.hasSignal()) {
        yajl_gen_string(g, (const unsigned char*)  "signal" , 6);
        const char* s = ::midw_diagnostics_fi_types::T_e8_RCtrlSignal_Name(value.getSignal());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSignal());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::RemoteControlSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RemoteControlGet"

void serializeJson (const ::Midw_Diagnostics_FI::RemoteControlGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSrc()) {
        yajl_gen_string(g, (const unsigned char*)  "src" , 3);
        const char* s = ::midw_diagnostics_fi_types::T_e8_RCtrlSource_Name(value.getSrc());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSrc());
    }
    if (!isSparse || value.hasCmd()) {
        yajl_gen_string(g, (const unsigned char*)  "cmd" , 3);
        const char* s = ::midw_diagnostics_fi_types::T_e8_RCtrlCommand_Name(value.getCmd());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCmd());
    }
    if (!isSparse || value.hasSignal()) {
        yajl_gen_string(g, (const unsigned char*)  "signal" , 6);
        const char* s = ::midw_diagnostics_fi_types::T_e8_RCtrlSignal_Name(value.getSignal());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSignal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::RemoteControlGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CISswUpdateProcessStatus"

void serializeJson (const ::Midw_Diagnostics_FI::CISswUpdateProcessStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::CISswUpdateProcessStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CISswUpdateProcessSet"

void serializeJson (const ::Midw_Diagnostics_FI::CISswUpdateProcessSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::CISswUpdateProcessSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CISswUpdateStage2ProcessStatus"

void serializeJson (const ::Midw_Diagnostics_FI::CISswUpdateStage2ProcessStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::CISswUpdateStage2ProcessStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CISswUpdateStage2ProcessSet"

void serializeJson (const ::Midw_Diagnostics_FI::CISswUpdateStage2ProcessSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::CISswUpdateStage2ProcessSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFactorySettingsStart"

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefSetStateGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateGroup" , 16);
        yajl_gen_integer(g, (long long)value.getDefSetStateGroup());
    }
    if (!isSparse || value.hasDefSetStateMode()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateMode" , 15);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DefSetMode_Name(value.getDefSetStateMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFactorySettingsResult"

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefSetStateGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateGroup" , 16);
        yajl_gen_integer(g, (long long)value.getDefSetStateGroup());
    }
    if (!isSparse || value.hasDefSetServiceStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetServiceStatus" , 19);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus_Name(value.getDefSetServiceStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetServiceStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetResetToSupplierDefaultConfigStart"

void serializeJson (const ::Midw_Diagnostics_FI::SetResetToSupplierDefaultConfigStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResetSupplierConfig()) {
        yajl_gen_string(g, (const unsigned char*)  "ResetSupplierConfig" , 19);
        yajl_gen_integer(g, (long long)value.getResetSupplierConfig());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetResetToSupplierDefaultConfigStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetResetToSupplierDefaultConfigResult"

void serializeJson (const ::Midw_Diagnostics_FI::SetResetToSupplierDefaultConfigResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefResetServiceStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "DefResetServiceStatus" , 21);
        yajl_gen_bool(g, (bool)value.getDefResetServiceStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetResetToSupplierDefaultConfigResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRunTimeSourceDataStart"

void serializeJson (const ::Midw_Diagnostics_FI::SetRunTimeSourceDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRunTimeSourceAppID()) {
        yajl_gen_string(g, (const unsigned char*)  "RunTimeSourceAppID" , 18);
        yajl_gen_integer(g, (long long)value.getRunTimeSourceAppID());
    }
    if (!isSparse || value.hasRunTimeSourceAppData()) {
        yajl_gen_string(g, (const unsigned char*)  "RunTimeSourceAppData" , 20);
        yajl_gen_integer(g, (long long)value.getRunTimeSourceAppData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetRunTimeSourceDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRunTimeSourceDataResult"

void serializeJson (const ::Midw_Diagnostics_FI::SetRunTimeSourceDataResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRunTimeSourceDiagResp()) {
        yajl_gen_string(g, (const unsigned char*)  "RunTimeSourceDiagResp" , 21);
        yajl_gen_bool(g, (bool)value.getRunTimeSourceDiagResp());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetRunTimeSourceDataResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFactorySettingsNewStart"

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsNewStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefSetStateGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateGroup" , 16);
        yajl_gen_integer(g, (long long)value.getDefSetStateGroup());
    }
    if (!isSparse || value.hasDefSetStateMode()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateMode" , 15);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DefSetMode_Name(value.getDefSetStateMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsNewStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFactorySettingsNewResult"

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsNewResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefSetStateGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateGroup" , 16);
        yajl_gen_integer(g, (long long)value.getDefSetStateGroup());
    }
    if (!isSparse || value.hasDefSetStateMode()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateMode" , 15);
        const char* s = ::midw_diagnostics_fi_types::T_e8_DefSetMode_Name(value.getDefSetStateMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateMode());
    }
    if (!isSparse || value.hasDefSetStateSuccessful()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateSuccessful" , 21);
        yajl_gen_bool(g, (bool)value.getDefSetStateSuccessful());
    }
    if (!isSparse || value.hasDefSetStateFirstDifferentParameterId()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateFirstDifferentParameterId" , 36);
        yajl_gen_integer(g, (long long)value.getDefSetStateFirstDifferentParameterId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::SetFactorySettingsNewResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartCalibrationSessionStart"

void serializeJson (const ::Midw_Diagnostics_FI::StartCalibrationSessionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTable()) {
        yajl_gen_string(g, (const unsigned char*)  "Table" , 5);
        const char* s = ::midw_diagnostics_fi_types::T_e8_CalibrationTable_Name(value.getTable());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTable());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::StartCalibrationSessionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartCalibrationSessionResult"

void serializeJson (const ::Midw_Diagnostics_FI::StartCalibrationSessionResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTable()) {
        yajl_gen_string(g, (const unsigned char*)  "Table" , 5);
        const char* s = ::midw_diagnostics_fi_types::T_e8_CalibrationTable_Name(value.getTable());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTable());
    }
    if (!isSparse || value.hasSessionHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "SessionHandle" , 13);
        yajl_gen_integer(g, (long long)value.getSessionHandle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::StartCalibrationSessionResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopCalibrationSessionStart"

void serializeJson (const ::Midw_Diagnostics_FI::StopCalibrationSessionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSessionHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "SessionHandle" , 13);
        yajl_gen_integer(g, (long long)value.getSessionHandle());
    }
    if (!isSparse || value.hasTimeStamp()) {
        yajl_gen_string(g, (const unsigned char*)  "TimeStamp" , 9);
        serializeJson(value.getTimeStamp(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::StopCalibrationSessionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopCalibrationSessionResult"

void serializeJson (const ::Midw_Diagnostics_FI::StopCalibrationSessionResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTable()) {
        yajl_gen_string(g, (const unsigned char*)  "Table" , 5);
        const char* s = ::midw_diagnostics_fi_types::T_e8_CalibrationTable_Name(value.getTable());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTable());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::StopCalibrationSessionResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CalibrationParameterStatus"

void serializeJson (const ::Midw_Diagnostics_FI::CalibrationParameterStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTable()) {
        yajl_gen_string(g, (const unsigned char*)  "Table" , 5);
        const char* s = ::midw_diagnostics_fi_types::T_e8_CalibrationTable_Name(value.getTable());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTable());
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "Name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasValue()) {
        yajl_gen_string(g, (const unsigned char*)  "Value" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o19 = value.getValue();
        {
            ::std::vector< uint8 >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                yajl_gen_integer(g, (long long)(*o18));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasElementSize()) {
        yajl_gen_string(g, (const unsigned char*)  "ElementSize" , 11);
        const char* s = ::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize_Name(value.getElementSize());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getElementSize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::CalibrationParameterStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CalibrationParameterSet"

void serializeJson (const ::Midw_Diagnostics_FI::CalibrationParameterSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSessionHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "SessionHandle" , 13);
        yajl_gen_integer(g, (long long)value.getSessionHandle());
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "Name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasValue()) {
        yajl_gen_string(g, (const unsigned char*)  "Value" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o21 = value.getValue();
        {
            ::std::vector< uint8 >::const_iterator o20;
            for (o20 = o21.begin(); o20 != o21.end(); ++o20) {
                yajl_gen_integer(g, (long long)(*o20));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::CalibrationParameterSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CalibrationParameterGet"

void serializeJson (const ::Midw_Diagnostics_FI::CalibrationParameterGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSessionHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "SessionHandle" , 13);
        yajl_gen_integer(g, (long long)value.getSessionHandle());
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "Name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::CalibrationParameterGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PartNumberStatus"

void serializeJson (const ::Midw_Diagnostics_FI::PartNumberStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDataIdentifier()) {
        yajl_gen_string(g, (const unsigned char*)  "DataIdentifier" , 14);
        yajl_gen_integer(g, (long long)value.getDataIdentifier());
    }
    if (!isSparse || value.hasPartNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "PartNumber" , 10);
        yajl_gen_integer(g, (long long)value.getPartNumber());
    }
    if (!isSparse || value.hasAlphaCode()) {
        yajl_gen_string(g, (const unsigned char*)  "AlphaCode" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o23 = value.getAlphaCode();
        {
            ::std::vector< uint8 >::const_iterator o22;
            for (o22 = o23.begin(); o22 != o23.end(); ++o22) {
                yajl_gen_integer(g, (long long)(*o22));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::PartNumberStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PartNumberSet"

void serializeJson (const ::Midw_Diagnostics_FI::PartNumberSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDataIdentifier()) {
        yajl_gen_string(g, (const unsigned char*)  "DataIdentifier" , 14);
        yajl_gen_integer(g, (long long)value.getDataIdentifier());
    }
    if (!isSparse || value.hasPartNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "PartNumber" , 10);
        yajl_gen_integer(g, (long long)value.getPartNumber());
    }
    if (!isSparse || value.hasAlphaCode()) {
        yajl_gen_string(g, (const unsigned char*)  "AlphaCode" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o25 = value.getAlphaCode();
        {
            ::std::vector< uint8 >::const_iterator o24;
            for (o24 = o25.begin(); o24 != o25.end(); ++o24) {
                yajl_gen_integer(g, (long long)(*o24));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::PartNumberSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PartNumberGet"

void serializeJson (const ::Midw_Diagnostics_FI::PartNumberGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDataIdentifier()) {
        yajl_gen_string(g, (const unsigned char*)  "DataIdentifier" , 14);
        yajl_gen_integer(g, (long long)value.getDataIdentifier());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Midw_Diagnostics_FI::PartNumberGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::TestMessageStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::TestMessageResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::DiagRequestStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::DiagRequestResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::StartRouteCalculationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::StartRouteCalculationSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::RouteCalculationResultStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::RouteCalculationResultSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetLocaleStartStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetLocaleStartSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetLocaleResultStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetLocaleResultSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::GetLocaleStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::GetLocaleSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetDisplayStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetDisplaySet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::ConfigUpdateViaUSBStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::AntiTheftStatusSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::AntiTheftUnlockHMIStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::AntiTheftUnlockHUStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::ClearDestinationMemoryStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::ClearDestinationMemorySet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::GetDestinationMemorySizeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::GetDestinationMemorySizeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SimulateKeyPressStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SimulateKeyPressSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::ResetSecurityStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::ResetSecuritySet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::LanguageGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SpeedLockStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SpeedLockGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SpdLockStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SpdLockSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetRVCSignalStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetRVCSignalSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetRVCSignalGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::RVCSignalStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::RVCSignalStatusSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::KdsEntryStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::KdsEntrySet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::KdsEntryGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::KdsEntryUpReg& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::KdsEntryRelUpReg& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::DiagConfigItemStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::DiagConfigItemSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::DiagConfigItemGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::DiagConfigItemUpReg& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::DiagConfigItemRelUpReg& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::ReadDiagLogStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::ReadDiagLogResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::ClearDiagLogStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::ClearDiagLogResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::StartDiagnosticTestStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::StartDiagnosticTestResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetDefaultSettingsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetDefaultSettingsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::EnableTimeSlotStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::EnableTimeSlotResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::StopDiagnosticTestStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::StopDiagnosticTestResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetFactorySettingsStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetFactorySettingsStatusSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetFactorySettingsStatusGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::RemoteControlStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::RemoteControlSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::RemoteControlGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::CISswUpdateProcessStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::CISswUpdateProcessSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::CISswUpdateStage2ProcessStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::CISswUpdateStage2ProcessSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetFactorySettingsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetFactorySettingsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetResetToSupplierDefaultConfigStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetResetToSupplierDefaultConfigResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetRunTimeSourceDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetRunTimeSourceDataResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetFactorySettingsNewStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::SetFactorySettingsNewResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::StartCalibrationSessionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::StartCalibrationSessionResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::StopCalibrationSessionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::StopCalibrationSessionResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::CalibrationParameterStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::CalibrationParameterSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::CalibrationParameterGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::PartNumberStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::PartNumberSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI
using namespace ::asf::stream::json;

namespace Midw_Diagnostics_FI {

std::ostream& operator<<(std::ostream& o, const ::Midw_Diagnostics_FI::PartNumberGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Midw_Diagnostics_FI

