#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MIDW_DIAGNOSTICS_FI_H
#define MIDW_DIAGNOSTICS_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "midw_diagnostics_fi_types.h"
#include "midw_diagnostics_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'Midw_Diagnostics_FI'
 *
 * Fullname: Middleware Diagnostics Application Functional Interface
 *
 * Version: v$Revision:   1.1.0.0  $
 *
 * Author: Mike Barber, Michael Gibron
 *
 * Date: $Date:   Apr 08 2015 10:26:00  $
 *
 * Department:
 *
 * Title: Midw_Diagnostics_FI
 *
 * <b>Description of 'Midw_Diagnostics_FI':</b>
 *
 * ..
 */

namespace Midw_Diagnostics_FI {

static const int SERVICE_ID = 279;

static const int FID_TestMessage = 1;

static const int FID_DiagRequest = 512;

static const int FID_StartRouteCalculation = 2;

static const int FID_RouteCalculationResult = 3;

static const int FID_SetLocaleStart = 6;

static const int FID_SetLocaleResult = 7;

static const int FID_GetLocale = 8;

static const int FID_SetDisplay = 9;

static const int FID_ConfigUpdateViaUSB = 48;

static const int FID_AntiTheftStatus = 30;

static const int FID_AntiTheftUnlockHMI = 28;

static const int FID_AntiTheftUnlockHU = 27;

static const int FID_ClearDestinationMemory = 17;

static const int FID_GetDestinationMemorySize = 18;

static const int FID_SimulateKeyPress = 19;

static const int FID_ResetSecurity = 21;

static const int FID_Language = 25;

static const int FID_SpeedLock = 29;

static const int FID_SpdLock = 34;

static const int FID_SetRVCSignal = 31;

static const int FID_RVCSignalStatus = 33;

static const int FID_KdsEntry = 96;

static const int FID_DiagConfigItem = 97;

static const int FID_ReadDiagLog = 10;

static const int FID_ClearDiagLog = 11;

static const int FID_StartDiagnosticTest = 12;

static const int FID_SetDefaultSettings = 13;

static const int FID_EnableTimeSlot = 16;

static const int FID_StopDiagnosticTest = 20;

static const int FID_SetFactorySettingsStatus = 14;

static const int FID_RemoteControl = 32;

static const int FID_CISswUpdateProcess = 49;

static const int FID_CISswUpdateStage2Process = 50;

static const int FID_SetFactorySettings = 15;

static const int FID_SetResetToSupplierDefaultConfig = 47;

static const int FID_SetRunTimeSourceData = 46;

static const int FID_SetFactorySettingsNew = 128;

static const int FID_StartCalibrationSession = 256;

static const int FID_StopCalibrationSession = 257;

static const int FID_CalibrationParameter = 258;

static const int FID_PartNumber = 259;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 3;

static const int VERSION_PATCH = 0;

// forward declarations
class TestMessageStart;

class TestMessageResult;

class DiagRequestStart;

class DiagRequestResult;

class StartRouteCalculationStatus;

class StartRouteCalculationSet;

class RouteCalculationResultStatus;

class RouteCalculationResultSet;

class SetLocaleStartStatus;

class SetLocaleStartSet;

class SetLocaleResultStatus;

class SetLocaleResultSet;

class GetLocaleStatus;

class GetLocaleSet;

class SetDisplayStatus;

class SetDisplaySet;

class ConfigUpdateViaUSBStatus;

class AntiTheftStatusSet;

class AntiTheftUnlockHMIStatus;

class AntiTheftUnlockHUStatus;

class ClearDestinationMemoryStatus;

class ClearDestinationMemorySet;

class GetDestinationMemorySizeStatus;

class GetDestinationMemorySizeSet;

class SimulateKeyPressStatus;

class SimulateKeyPressSet;

class ResetSecurityStatus;

class ResetSecuritySet;

class LanguageGet;

class SpeedLockStatus;

class SpeedLockGet;

class SpdLockStatus;

class SpdLockSet;

class SetRVCSignalStatus;

class SetRVCSignalSet;

class SetRVCSignalGet;

class RVCSignalStatusStatus;

class RVCSignalStatusSet;

class KdsEntryStatus;

class KdsEntrySet;

class KdsEntryGet;

class KdsEntryUpReg;

class KdsEntryRelUpReg;

class DiagConfigItemStatus;

class DiagConfigItemSet;

class DiagConfigItemGet;

class DiagConfigItemUpReg;

class DiagConfigItemRelUpReg;

class ReadDiagLogStart;

class ReadDiagLogResult;

class ClearDiagLogStart;

class ClearDiagLogResult;

class StartDiagnosticTestStart;

class StartDiagnosticTestResult;

class SetDefaultSettingsStart;

class SetDefaultSettingsResult;

class EnableTimeSlotStart;

class EnableTimeSlotResult;

class StopDiagnosticTestStart;

class StopDiagnosticTestResult;

class SetFactorySettingsStatusStatus;

class SetFactorySettingsStatusSet;

class SetFactorySettingsStatusGet;

class RemoteControlStatus;

class RemoteControlSet;

class RemoteControlGet;

class CISswUpdateProcessStatus;

class CISswUpdateProcessSet;

class CISswUpdateStage2ProcessStatus;

class CISswUpdateStage2ProcessSet;

class SetFactorySettingsStart;

class SetFactorySettingsResult;

class SetResetToSupplierDefaultConfigStart;

class SetResetToSupplierDefaultConfigResult;

class SetRunTimeSourceDataStart;

class SetRunTimeSourceDataResult;

class SetFactorySettingsNewStart;

class SetFactorySettingsNewResult;

class StartCalibrationSessionStart;

class StartCalibrationSessionResult;

class StopCalibrationSessionStart;

class StopCalibrationSessionResult;

class CalibrationParameterStatus;

class CalibrationParameterSet;

class CalibrationParameterGet;

class PartNumberStatus;

class PartNumberSet;

class PartNumberGet;

// type definitions
/**
 * The abort error message of the method "TestMessage"
 * The "TestMessage" provides functionality to interprete messages sent by test applications via CCA. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_TESTMESSAGE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = variable
 */
typedef ::asf::cca::CcaTypes::DefaultError TestMessageAbortError;

/**
 * The error message of 'TestMessage'
 */
typedef ::asf::cca::CcaTypes::DefaultError TestMessageError;

/**
 * The abort error message of the method "DiagRequest"
 * Diagnosis request to be executed. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_DIAGREQUEST, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = variable
 */
typedef ::asf::cca::CcaTypes::DefaultError DiagRequestAbortError;

/**
 * The error message of 'DiagRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiagRequestError;

/**
 * The upreg message of the property "StartRouteCalculation"
 * The route calculation can be started via this property. The client has to register for the property. The route calculation is started via the status message. The start of the route calculation is confirmed via  the set message. The result of the route calculation can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STARTROUTECALCULATION, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartRouteCalculationUpReg;

/**
 * The relUpReg message of the property "StartRouteCalculation"
 * The route calculation can be started via this property. The client has to register for the property. The route calculation is started via the status message. The start of the route calculation is confirmed via  the set message. The result of the route calculation can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STARTROUTECALCULATION, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartRouteCalculationRelUpReg;

/**
 * The error message of 'StartRouteCalculation'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartRouteCalculationError;

/**
 * The upreg message of the property "RouteCalculationResult"
 * The result of the route calculation is handled via this property. The result is passed via the set message. The route calculation is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ROUTECALCULATIONRESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RouteCalculationResultUpReg;

/**
 * The relUpReg message of the property "RouteCalculationResult"
 * The result of the route calculation is handled via this property. The result is passed via the set message. The route calculation is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ROUTECALCULATIONRESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RouteCalculationResultRelUpReg;

/**
 * The error message of 'RouteCalculationResult'
 */
typedef ::asf::cca::CcaTypes::DefaultError RouteCalculationResultError;

/**
 * The upreg message of the property "SetLocaleStart"
 * The locale (country and language) can be set via this property. The client has to register for the property. The locale is set via the status message. The start of the locale switch is confirmed via  the set message. The result of the locale switch can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALESTART, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetLocaleStartUpReg;

/**
 * The relUpReg message of the property "SetLocaleStart"
 * The locale (country and language) can be set via this property. The client has to register for the property. The locale is set via the status message. The start of the locale switch is confirmed via  the set message. The result of the locale switch can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALESTART, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetLocaleStartRelUpReg;

/**
 * The error message of 'SetLocaleStart'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetLocaleStartError;

/**
 * The upreg message of the property "SetLocaleResult"
 * The result of the locale (country and language) switch is handled via this property. The result is passed via the set message. The switch of the locale is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALERESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetLocaleResultUpReg;

/**
 * The relUpReg message of the property "SetLocaleResult"
 * The result of the locale (country and language) switch is handled via this property. The result is passed via the set message. The switch of the locale is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALERESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetLocaleResultRelUpReg;

/**
 * The error message of 'SetLocaleResult'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetLocaleResultError;

/**
 * The upreg message of the property "GetLocale"
 * The locale (country and language) can be obtained via this property. The client has to register for the property. The locale is passed to the HMI via the status message.  The result for the get operation is received via set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETLOCALE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetLocaleUpReg;

/**
 * The relUpReg message of the property "GetLocale"
 * The locale (country and language) can be obtained via this property. The client has to register for the property. The locale is passed to the HMI via the status message.  The result for the get operation is received via set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETLOCALE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetLocaleRelUpReg;

/**
 * The error message of 'GetLocale'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetLocaleError;

/**
 * The upreg message of the property "SetDisplay"
 * The test pictures and the diagnostics screen can be set via this property. The client has to register for the property. The display to be used is passed to the HMI via the Status message. The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETDISPLAY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetDisplayUpReg;

/**
 * The relUpReg message of the property "SetDisplay"
 * The test pictures and the diagnostics screen can be set via this property. The client has to register for the property. The display to be used is passed to the HMI via the Status message. The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETDISPLAY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetDisplayRelUpReg;

/**
 * The error message of 'SetDisplay'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDisplayError;

/**
 * The upreg message of the property "ConfigUpdateViaUSB"
 * HMI support to show the status of configuration update through USB- Config update start status, when config file found for the particular variant- Upon config items write, trigger for hash calculation
 * - Show config update success or failure message - Display Restart the system message, if config hash is successful otherwise display update config once again message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConfigUpdateViaUSBUpReg;

/**
 * The relUpReg message of the property "ConfigUpdateViaUSB"
 * HMI support to show the status of configuration update through USB- Config update start status, when config file found for the particular variant- Upon config items write, trigger for hash calculation
 * - Show config update success or failure message - Display Restart the system message, if config hash is successful otherwise display update config once again message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConfigUpdateViaUSBRelUpReg;

/**
 * The error message of 'ConfigUpdateViaUSB'
 */
typedef ::asf::cca::CcaTypes::DefaultError ConfigUpdateViaUSBError;

/**
 * The status message of the property "AntiTheftStatus"
 * Get status of Anti theft status. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFTSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AntiTheftStatusStatus;

/**
 * The upreg message of the property "AntiTheftStatus"
 * Get status of Anti theft status. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFTSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AntiTheftStatusUpReg;

/**
 * The relUpReg message of the property "AntiTheftStatus"
 * Get status of Anti theft status. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFTSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AntiTheftStatusRelUpReg;

/**
 * The error message of 'AntiTheftStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError AntiTheftStatusError;

/**
 * The set message of the property "AntiTheftUnlockHMI"
 * Unlock HMI if VID write success in Antitheft sequence.. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHMI, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AntiTheftUnlockHMISet;

/**
 * The upreg message of the property "AntiTheftUnlockHMI"
 * Unlock HMI if VID write success in Antitheft sequence.. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHMI, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AntiTheftUnlockHMIUpReg;

/**
 * The relUpReg message of the property "AntiTheftUnlockHMI"
 * Unlock HMI if VID write success in Antitheft sequence.. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHMI, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AntiTheftUnlockHMIRelUpReg;

/**
 * The error message of 'AntiTheftUnlockHMI'
 */
typedef ::asf::cca::CcaTypes::DefaultError AntiTheftUnlockHMIError;

/**
 * The set message of the property "AntiTheftUnlockHU"
 * Unlock HU if PIN Validation success in Antitheft sequence. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHU, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AntiTheftUnlockHUSet;

/**
 * The upreg message of the property "AntiTheftUnlockHU"
 * Unlock HU if PIN Validation success in Antitheft sequence. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHU, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AntiTheftUnlockHUUpReg;

/**
 * The relUpReg message of the property "AntiTheftUnlockHU"
 * Unlock HU if PIN Validation success in Antitheft sequence. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHU, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AntiTheftUnlockHURelUpReg;

/**
 * The error message of 'AntiTheftUnlockHU'
 */
typedef ::asf::cca::CcaTypes::DefaultError AntiTheftUnlockHUError;

/**
 * The upreg message of the property "ClearDestinationMemory"
 * Destination memory can be erased using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_CLEARDESTINATIONMEMORY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearDestinationMemoryUpReg;

/**
 * The relUpReg message of the property "ClearDestinationMemory"
 * Destination memory can be erased using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_CLEARDESTINATIONMEMORY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearDestinationMemoryRelUpReg;

/**
 * The error message of 'ClearDestinationMemory'
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearDestinationMemoryError;

/**
 * The upreg message of the property "GetDestinationMemorySize"
 * The current size of the destination memory can be obtained using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETDESTINATIONMEMORYSIZE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetDestinationMemorySizeUpReg;

/**
 * The relUpReg message of the property "GetDestinationMemorySize"
 * The current size of the destination memory can be obtained using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETDESTINATIONMEMORYSIZE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetDestinationMemorySizeRelUpReg;

/**
 * The error message of 'GetDestinationMemorySize'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDestinationMemorySizeError;

/**
 * The upreg message of the property "SimulateKeyPress"
 * Instructs the HMI to simulate a key press. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SIMULATEKEYPRESS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SimulateKeyPressUpReg;

/**
 * The relUpReg message of the property "SimulateKeyPress"
 * Instructs the HMI to simulate a key press. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SIMULATEKEYPRESS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SimulateKeyPressRelUpReg;

/**
 * The error message of 'SimulateKeyPress'
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulateKeyPressError;

/**
 * The upreg message of the property "ResetSecurity"
 * Instructs the HMI to perform a security reset. E.g. reset the number of unsuccessful password entries. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RESETSECURITY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetSecurityUpReg;

/**
 * The relUpReg message of the property "ResetSecurity"
 * Instructs the HMI to perform a security reset. E.g. reset the number of unsuccessful password entries. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RESETSECURITY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetSecurityRelUpReg;

/**
 * The error message of 'ResetSecurity'
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetSecurityError;

/**
 * The status message of the property "Language"
 * Vehicle type. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_LANGUAGE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LanguageStatus;

/**
 * The upreg message of the property "Language"
 * Vehicle type. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_LANGUAGE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LanguageUpReg;

/**
 * The relUpReg message of the property "Language"
 * Vehicle type. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_LANGUAGE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LanguageRelUpReg;

/**
 * The error message of 'Language'
 */
typedef ::asf::cca::CcaTypes::DefaultError LanguageError;

/**
 * The upreg message of the property "SpeedLock"
 * Get Speed Lock value and Threshold from Diagnosis. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
 * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedLockUpReg;

/**
 * The relUpReg message of the property "SpeedLock"
 * Get Speed Lock value and Threshold from Diagnosis. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
 * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedLockRelUpReg;

/**
 * The error message of 'SpeedLock'
 */
typedef ::asf::cca::CcaTypes::DefaultError SpeedLockError;

/**
 * The upreg message of the property "SpdLock"
 * Activate Speed Lock via HMI where FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
 * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpdLockUpReg;

/**
 * The relUpReg message of the property "SpdLock"
 * Activate Speed Lock via HMI where FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
 * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpdLockRelUpReg;

/**
 * The error message of 'SpdLock'
 */
typedef ::asf::cca::CcaTypes::DefaultError SpdLockError;

/**
 * The upreg message of the property "SetRVCSignal"
 * Set RVC Video Signal on or off. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETRVCSIGNAL, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetRVCSignalUpReg;

/**
 * The relUpReg message of the property "SetRVCSignal"
 * Set RVC Video Signal on or off. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETRVCSIGNAL, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetRVCSignalRelUpReg;

/**
 * The error message of 'SetRVCSignal'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetRVCSignalError;

/**
 * The upreg message of the property "RVCSignalStatus"
 * Interrogate status of RVC Video Signal. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RVCSIGNALSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCSignalStatusUpReg;

/**
 * The relUpReg message of the property "RVCSignalStatus"
 * Interrogate status of RVC Video Signal. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RVCSIGNALSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCSignalStatusRelUpReg;

/**
 * The error message of 'RVCSignalStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError RVCSignalStatusError;

/**
 * The error message of 'KdsEntry'
 */
typedef ::asf::cca::CcaTypes::DefaultError KdsEntryError;

/**
 * The error message of 'DiagConfigItem'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiagConfigItemError;

/**
 * The abort error message of the method "ReadDiagLog"
 * This method provides functionality for the HMI to read the DTC and ITC from VD_DiagLog. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_READDIAGLOG, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultError ReadDiagLogAbortError;

/**
 * The error message of 'ReadDiagLog'
 */
typedef ::asf::cca::CcaTypes::DefaultError ReadDiagLogError;

/**
 * The abort error message of the method "ClearDiagLog"
 * This method provides functionality for the HMI to clear all DTCs in VD_DiagLog. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_CLEARDIAGLOG, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearDiagLogAbortError;

/**
 * The error message of 'ClearDiagLog'
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearDiagLogError;

/**
 * The abort error message of the method "StartDiagnosticTest"
 * The "Start Test" provides functionality to start the defined test routines. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STARTDIAGNOSTICTEST, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultError StartDiagnosticTestAbortError;

/**
 * The error message of 'StartDiagnosticTest'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartDiagnosticTestError;

/**
 * The abort error message of the method "SetDefaultSettings"
 * This method sets default settings for a specified category. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETDEFAULTSETTINGS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDefaultSettingsAbortError;

/**
 * The error message of 'SetDefaultSettings'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDefaultSettingsError;

/**
 * The abort error message of the method "EnableTimeSlot"
 * Enables the MAUS setup time slot. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ENABLETIMESLOT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultError EnableTimeSlotAbortError;

/**
 * The error message of 'EnableTimeSlot'
 */
typedef ::asf::cca::CcaTypes::DefaultError EnableTimeSlotError;

/**
 * The abort error message of the method "StopDiagnosticTest"
 * Provides functionality to stop the specified test routine. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STOPDIAGNOSTICTEST, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
typedef ::asf::cca::CcaTypes::DefaultError StopDiagnosticTestAbortError;

/**
 * The error message of 'StopDiagnosticTest'
 */
typedef ::asf::cca::CcaTypes::DefaultError StopDiagnosticTestError;

/**
 * The upreg message of the property "SetFactorySettingsStatus"
 * This property gives information about the actual DefSetState, it is TRUE if all parameters are in Default State.
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS_STATUS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>the Identifier for "DefSetStateFirstDifferentParameterId" will be found in the Doors "/Ford HS-LSRNS Dev/System Specification/Parameter Dictionary" Document</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetFactorySettingsStatusUpReg;

/**
 * The relUpReg message of the property "SetFactorySettingsStatus"
 * This property gives information about the actual DefSetState, it is TRUE if all parameters are in Default State.
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS_STATUS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>the Identifier for "DefSetStateFirstDifferentParameterId" will be found in the Doors "/Ford HS-LSRNS Dev/System Specification/Parameter Dictionary" Document</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetFactorySettingsStatusRelUpReg;

/**
 * The error message of 'SetFactorySettingsStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFactorySettingsStatusError;

/**
 * The upreg message of the property "RemoteControl"
 * Remote control for customer diagnostics using the UDS protocol
 * Client (HMI) registers for the remote control property
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RemoteControlUpReg;

/**
 * The relUpReg message of the property "RemoteControl"
 * Remote control for customer diagnostics using the UDS protocol
 * Client (HMI) unregisters for the remote control property
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RemoteControlRelUpReg;

/**
 * The error message of 'RemoteControl'
 */
typedef ::asf::cca::CcaTypes::DefaultError RemoteControlError;

/**
 * The upreg message of the property "CISswUpdateProcess"
 * CIS SW update progress to HMI for customer diagnostics using the UDS protocol
 * Client (HMI) registers for the remote control property
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CISswUpdateProcessUpReg;

/**
 * The relUpReg message of the property "CISswUpdateProcess"
 * CIS SW update progress to HMI for customer diagnostics using the UDS protocol
 * Client (HMI) unregisters for the remote control property
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CISswUpdateProcessRelUpReg;

/**
 * The error message of 'CISswUpdateProcess'
 */
typedef ::asf::cca::CcaTypes::DefaultError CISswUpdateProcessError;

/**
 * The upreg message of the property "CISswUpdateStage2Process"
 * CIS SW update stage2 progress to HMI for customer diagnostics using the UDS protocol
 * Client (HMI) registers for the remote control property
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CISswUpdateStage2ProcessUpReg;

/**
 * The relUpReg message of the property "CISswUpdateStage2Process"
 * CIS SW update stage2 progress to HMI for customer diagnostics using the UDS protocol
 * Client (HMI) unregisters for the remote control property
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CISswUpdateStage2ProcessRelUpReg;

/**
 * The error message of 'CISswUpdateStage2Process'
 */
typedef ::asf::cca::CcaTypes::DefaultError CISswUpdateStage2ProcessError;

/**
 * The abort error message of the method "SetFactorySettings"
 * This function request the component to set all Variables (depending on USER or TEF) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetFactorySettings MessageResult must be send immediately.
 * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFactorySettingsAbortError;

/**
 * The error message of 'SetFactorySettings'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFactorySettingsError;

/**
 * The abort error message of the method "SetResetToSupplierDefaultConfig"
 * This function request the component to set all Variables (depending on USER or TEF) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetResetToSupplierDefaultConfigStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetResetToSupplierDefaultConfig MessageResult must be send immediately.
 * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetResetToSupplierDefaultConfigAbortError;

/**
 * The error message of 'SetResetToSupplierDefaultConfig'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetResetToSupplierDefaultConfigError;

/**
 * The abort error message of the method "SetRunTimeSourceData"
 * This function request the component to set all Variables (depending on USER or TEF) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetRunTimeSourceData" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetRunTimeSourceData MessageResult must be send immediately.
 * The commponent must accept a new request if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independent of that it has to confirm the new request.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetRunTimeSourceDataAbortError;

/**
 * The error message of 'SetRunTimeSourceData'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetRunTimeSourceDataError;

/**
 * The abort error message of the method "SetFactorySettingsNew"
 * This function request the component to set all Variables (depending on USER, TEF or OEM) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetFactorySettings MessageResult must be send immediately.
 * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFactorySettingsNewAbortError;

/**
 * The error message of 'SetFactorySettingsNew'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFactorySettingsNewError;

/**
 * The abort error message of the method "StartCalibrationSession"
 * Starts a calibration Session for the given table.
 * <p>E.g. SYSTEM, BLUETOOTH, BRAND,...</p>
 * <p>Internally the Diagnosis component loads the table from the EOLLib to a RAM buffer.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError StartCalibrationSessionAbortError;

/**
 * The error message of 'StartCalibrationSession'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartCalibrationSessionError;

/**
 * The abort error message of the method "StopCalibrationSession"
 * Stops a calibration Session for the given table.
 * <p>E.g. SYSTEM, BLUETOOTH, BRAND,...</p>
 * <p>Internally the Diagnosis component saves the table from the RAM buffer to the EOLLib. After this all components are notified about a SystemSet concerning the calibration table.</p>
 * <p>If an error is detected while writing to the EOLLib or executing the SystemSet, an Error Message is returned.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError StopCalibrationSessionAbortError;

/**
 * The error message of 'StopCalibrationSession'
 */
typedef ::asf::cca::CcaTypes::DefaultError StopCalibrationSessionError;

/**
 * The upreg message of the property "CalibrationParameter"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CalibrationParameterUpReg;

/**
 * The relUpReg message of the property "CalibrationParameter"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CalibrationParameterRelUpReg;

/**
 * The error message of 'CalibrationParameter'
 */
typedef ::asf::cca::CcaTypes::DefaultError CalibrationParameterError;

/**
 * The upreg message of the property "PartNumber"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PartNumberUpReg;

/**
 * The relUpReg message of the property "PartNumber"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PartNumberRelUpReg;

/**
 * The error message of 'PartNumber'
 */
typedef ::asf::cca::CcaTypes::DefaultError PartNumberError;


/**
 * The start message of the method "TestMessage"
 * The "TestMessage" provides functionality to interprete messages sent by test applications via CCA. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_TESTMESSAGE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = variable
 */
class TestMessageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TestMessageStart ();

    /**
     * Copy constructor
     */
    inline  TestMessageStart (const TestMessageStart &rhs);

    /**
     * All fields constructor
     */
    inline  TestMessageStart (uint8 ProtocolId_, const ::midw_diagnostics_fi_types::T_MessageBuffer& MessageBuffer_);

    /**
     * Destructor
     */
    inline virtual  ~TestMessageStart();

    /**
     * Assignment operator
     */
    inline TestMessageStart& operator = (const TestMessageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TestMessageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TestMessageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TestMessageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TestMessageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ProtocolId"

    static const int kProtocolId = 0;

    /**
     * Clears the field "ProtocolId".
     *
     * The field will be set to its default value. The hasProtocolId()
     * method will return false.
     */
    inline void clearProtocolId();

    /**
     * Checks whether the field "ProtocolId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProtocolId()). Otherwise it will return false.
     */
    inline bool hasProtocolId () const;

    /**
     * Returns the value of the member "ProtocolId".
     *
     * Select the Protocol Id (MCNET,UDS).
     *
     * @return The value of the field "ProtocolId"
     */
    inline uint8 getProtocolId () const;

    /**
     * Sets the value of the member "ProtocolId".
     *
     * Select the Protocol Id (MCNET,UDS).
     *
     * @param ProtocolId The value which will be set
     */
    inline void setProtocolId (uint8 ProtocolId_);

    // API of field "MessageBuffer"

    static const int kMessageBuffer = 1;

    /**
     * Clears the field "MessageBuffer".
     *
     * The field will be set to its default value. The hasMessageBuffer()
     * method will return false.
     */
    inline void clearMessageBuffer();

    /**
     * Checks whether the field "MessageBuffer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessageBuffer()). Otherwise it will return false.
     */
    inline bool hasMessageBuffer () const;

    /**
     * Returns the value of the member "MessageBuffer".
     *
     * Contains MCNET or KWP/UDS test message.
     *
     * @return The value of the field "MessageBuffer"
     */
    inline const ::midw_diagnostics_fi_types::T_MessageBuffer& getMessageBuffer () const;

    /**
     * Retrieves the value of the field "MessageBuffer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MessageBuffer".
     */
    inline ::midw_diagnostics_fi_types::T_MessageBuffer& getMessageBufferMutable ();

    /**
     * Sets the value of the member "MessageBuffer".
     *
     * Contains MCNET or KWP/UDS test message.
     *
     * @param MessageBuffer The value which will be set
     */
    inline void setMessageBuffer (const ::midw_diagnostics_fi_types::T_MessageBuffer& MessageBuffer_);

    static const TestMessageStart &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_ProtocolId ();

    inline void clear_has_ProtocolId ();

    inline void set_has_MessageBuffer ();

    inline void clear_has_MessageBuffer ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ProtocolId;

    ::midw_diagnostics_fi_types::T_MessageBuffer _MessageBuffer;

};

/**
 * The result message of the method "TestMessage"
 * The "TestMessage" provides functionality to interprete messages sent by test applications via CCA. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_TESTMESSAGE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = variable
 */
class TestMessageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TestMessageResult ();

    /**
     * Copy constructor
     */
    inline  TestMessageResult (const TestMessageResult &rhs);

    /**
     * All fields constructor
     */
    inline  TestMessageResult (uint8 ProtocolId_, const ::midw_diagnostics_fi_types::T_MessageBuffer& MessageBuffer_);

    /**
     * Destructor
     */
    inline virtual  ~TestMessageResult();

    /**
     * Assignment operator
     */
    inline TestMessageResult& operator = (const TestMessageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TestMessageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TestMessageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TestMessageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TestMessageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ProtocolId"

    static const int kProtocolId = 0;

    /**
     * Clears the field "ProtocolId".
     *
     * The field will be set to its default value. The hasProtocolId()
     * method will return false.
     */
    inline void clearProtocolId();

    /**
     * Checks whether the field "ProtocolId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProtocolId()). Otherwise it will return false.
     */
    inline bool hasProtocolId () const;

    /**
     * Returns the value of the member "ProtocolId".
     *
     * Select the Protocol Id (MCNET,UDS).
     *
     * @return The value of the field "ProtocolId"
     */
    inline uint8 getProtocolId () const;

    /**
     * Sets the value of the member "ProtocolId".
     *
     * Select the Protocol Id (MCNET,UDS).
     *
     * @param ProtocolId The value which will be set
     */
    inline void setProtocolId (uint8 ProtocolId_);

    // API of field "MessageBuffer"

    static const int kMessageBuffer = 1;

    /**
     * Clears the field "MessageBuffer".
     *
     * The field will be set to its default value. The hasMessageBuffer()
     * method will return false.
     */
    inline void clearMessageBuffer();

    /**
     * Checks whether the field "MessageBuffer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessageBuffer()). Otherwise it will return false.
     */
    inline bool hasMessageBuffer () const;

    /**
     * Returns the value of the member "MessageBuffer".
     *
     * Contains MCNET or KWP/UDS test message.
     *
     * @return The value of the field "MessageBuffer"
     */
    inline const ::midw_diagnostics_fi_types::T_MessageBuffer& getMessageBuffer () const;

    /**
     * Retrieves the value of the field "MessageBuffer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MessageBuffer".
     */
    inline ::midw_diagnostics_fi_types::T_MessageBuffer& getMessageBufferMutable ();

    /**
     * Sets the value of the member "MessageBuffer".
     *
     * Contains MCNET or KWP/UDS test message.
     *
     * @param MessageBuffer The value which will be set
     */
    inline void setMessageBuffer (const ::midw_diagnostics_fi_types::T_MessageBuffer& MessageBuffer_);

    static const TestMessageResult &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_ProtocolId ();

    inline void clear_has_ProtocolId ();

    inline void set_has_MessageBuffer ();

    inline void clear_has_MessageBuffer ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ProtocolId;

    ::midw_diagnostics_fi_types::T_MessageBuffer _MessageBuffer;

};

/**
 * The start message of the method "DiagRequest"
 * Diagnosis request to be executed. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_DIAGREQUEST, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = variable
 */
class DiagRequestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagRequestStart ();

    /**
     * Copy constructor
     */
    inline  DiagRequestStart (const DiagRequestStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiagRequestStart (::midw_diagnostics_fi_types::T_DiagProtocol protID_, const ::midw_diagnostics_fi_types::T_DiagData& diagData_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~DiagRequestStart();

    /**
     * Assignment operator
     */
    inline DiagRequestStart& operator = (const DiagRequestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagRequestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagRequestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagRequestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagRequestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "protID"

    static const int kProtID = 0;

    /**
     * Clears the field "protID".
     *
     * The field will be set to its default value. The hasProtID()
     * method will return false.
     */
    inline void clearProtID();

    /**
     * Checks whether the field "protID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProtID()). Otherwise it will return false.
     */
    inline bool hasProtID () const;

    /**
     * Returns the value of the member "protID".
     *
     * Specifies the diagnosis protocol used for the diagnosis request (e.g. UDS, GMLAN,...).
     *
     * @return The value of the field "protID"
     */
    inline ::midw_diagnostics_fi_types::T_DiagProtocol getProtID () const;

    /**
     * Sets the value of the member "protID".
     *
     * Specifies the diagnosis protocol used for the diagnosis request (e.g. UDS, GMLAN,...).
     *
     * @param protID The value which will be set
     */
    inline void setProtID (::midw_diagnostics_fi_types::T_DiagProtocol protID_);

    // API of field "diagData"

    static const int kDiagData = 1;

    /**
     * Clears the field "diagData".
     *
     * The field will be set to its default value. The hasDiagData()
     * method will return false.
     */
    inline void clearDiagData();

    /**
     * Checks whether the field "diagData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiagData()). Otherwise it will return false.
     */
    inline bool hasDiagData () const;

    /**
     * Returns the value of the member "diagData".
     *
     * Contains data of the diagnosis request.
     *
     * @return The value of the field "diagData"
     */
    inline const ::midw_diagnostics_fi_types::T_DiagData& getDiagData () const;

    /**
     * Retrieves the value of the field "diagData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "diagData".
     */
    inline ::midw_diagnostics_fi_types::T_DiagData& getDiagDataMutable ();

    /**
     * Sets the value of the member "diagData".
     *
     * Contains data of the diagnosis request.
     *
     * @param diagData The value which will be set
     */
    inline void setDiagData (const ::midw_diagnostics_fi_types::T_DiagData& diagData_);

    // API of field "cookie"

    static const int kCookie = 2;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * Cookie that is generated by the sender. It is not changed by diagnosis application and is send back with the response.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * Cookie that is generated by the sender. It is not changed by diagnosis application and is send back with the response.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const DiagRequestStart &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_protID ();

    inline void clear_has_protID ();

    inline void set_has_diagData ();

    inline void clear_has_diagData ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::midw_diagnostics_fi_types::T_DiagProtocol _protID;

    ::midw_diagnostics_fi_types::T_DiagData _diagData;

    uint32 _cookie;

};

/**
 * The result message of the method "DiagRequest"
 * Diagnosis request to be executed. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_DIAGREQUEST, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = variable
 */
class DiagRequestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagRequestResult ();

    /**
     * Copy constructor
     */
    inline  DiagRequestResult (const DiagRequestResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiagRequestResult (::midw_diagnostics_fi_types::T_DiagProtocol protID_, const ::midw_diagnostics_fi_types::T_DiagData& diagData_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~DiagRequestResult();

    /**
     * Assignment operator
     */
    inline DiagRequestResult& operator = (const DiagRequestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagRequestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagRequestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagRequestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagRequestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "protID"

    static const int kProtID = 0;

    /**
     * Clears the field "protID".
     *
     * The field will be set to its default value. The hasProtID()
     * method will return false.
     */
    inline void clearProtID();

    /**
     * Checks whether the field "protID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProtID()). Otherwise it will return false.
     */
    inline bool hasProtID () const;

    /**
     * Returns the value of the member "protID".
     *
     * Specifies the diagnosis protocol used for the diagnosis response (e.g. UDS, GMLAN,...).
     *
     * @return The value of the field "protID"
     */
    inline ::midw_diagnostics_fi_types::T_DiagProtocol getProtID () const;

    /**
     * Sets the value of the member "protID".
     *
     * Specifies the diagnosis protocol used for the diagnosis response (e.g. UDS, GMLAN,...).
     *
     * @param protID The value which will be set
     */
    inline void setProtID (::midw_diagnostics_fi_types::T_DiagProtocol protID_);

    // API of field "diagData"

    static const int kDiagData = 1;

    /**
     * Clears the field "diagData".
     *
     * The field will be set to its default value. The hasDiagData()
     * method will return false.
     */
    inline void clearDiagData();

    /**
     * Checks whether the field "diagData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiagData()). Otherwise it will return false.
     */
    inline bool hasDiagData () const;

    /**
     * Returns the value of the member "diagData".
     *
     * Contains data of the diagnosis response.
     *
     * @return The value of the field "diagData"
     */
    inline const ::midw_diagnostics_fi_types::T_DiagData& getDiagData () const;

    /**
     * Retrieves the value of the field "diagData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "diagData".
     */
    inline ::midw_diagnostics_fi_types::T_DiagData& getDiagDataMutable ();

    /**
     * Sets the value of the member "diagData".
     *
     * Contains data of the diagnosis response.
     *
     * @param diagData The value which will be set
     */
    inline void setDiagData (const ::midw_diagnostics_fi_types::T_DiagData& diagData_);

    // API of field "cookie"

    static const int kCookie = 2;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * Cookie that is generated by the sender. It is not changed by diagnosis application and is send back with the response.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * Cookie that is generated by the sender. It is not changed by diagnosis application and is send back with the response.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const DiagRequestResult &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_protID ();

    inline void clear_has_protID ();

    inline void set_has_diagData ();

    inline void clear_has_diagData ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::midw_diagnostics_fi_types::T_DiagProtocol _protID;

    ::midw_diagnostics_fi_types::T_DiagData _diagData;

    uint32 _cookie;

};

/**
 * The status message of the property "StartRouteCalculation"
 * The route calculation can be started via this property. The client has to register for the property. The route calculation is started via the status message. The start of the route calculation is confirmed via  the set message. The result of the route calculation can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STARTROUTECALCULATION, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class StartRouteCalculationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartRouteCalculationStatus ();

    /**
     * Copy constructor
     */
    inline  StartRouteCalculationStatus (const StartRouteCalculationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StartRouteCalculationStatus (const ::midw_diagnostics_fi_types::T_RouteCalculationStartParameter& RouteDetails_);

    /**
     * Destructor
     */
    inline virtual  ~StartRouteCalculationStatus();

    /**
     * Assignment operator
     */
    inline StartRouteCalculationStatus& operator = (const StartRouteCalculationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartRouteCalculationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartRouteCalculationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartRouteCalculationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartRouteCalculationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RouteDetails"

    static const int kRouteDetails = 0;

    /**
     * Clears the field "RouteDetails".
     *
     * The field will be set to its default value. The hasRouteDetails()
     * method will return false.
     */
    inline void clearRouteDetails();

    /**
     * Checks whether the field "RouteDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteDetails()). Otherwise it will return false.
     */
    inline bool hasRouteDetails () const;

    /**
     * Returns the value of the member "RouteDetails".
     *
     * Pass the parameters for the route calculation from FC diagnosis to HMI.
     *
     * @return The value of the field "RouteDetails"
     */
    inline const ::midw_diagnostics_fi_types::T_RouteCalculationStartParameter& getRouteDetails () const;

    /**
     * Retrieves the value of the field "RouteDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RouteDetails".
     */
    inline ::midw_diagnostics_fi_types::T_RouteCalculationStartParameter& getRouteDetailsMutable ();

    /**
     * Sets the value of the member "RouteDetails".
     *
     * Pass the parameters for the route calculation from FC diagnosis to HMI.
     *
     * @param RouteDetails The value which will be set
     */
    inline void setRouteDetails (const ::midw_diagnostics_fi_types::T_RouteCalculationStartParameter& RouteDetails_);

    static const StartRouteCalculationStatus &getDefaultInstance();

private:

    inline void set_has_RouteDetails ();

    inline void clear_has_RouteDetails ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_RouteCalculationStartParameter _RouteDetails;

};

/**
 * The set message of the property "StartRouteCalculation"
 * The route calculation can be started via this property. The client has to register for the property. The route calculation is started via the status message. The start of the route calculation is confirmed via  the set message. The result of the route calculation can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STARTROUTECALCULATION, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class StartRouteCalculationSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartRouteCalculationSet ();

    /**
     * Copy constructor
     */
    inline  StartRouteCalculationSet (const StartRouteCalculationSet &rhs);

    /**
     * All fields constructor
     */
    inline  StartRouteCalculationSet (bool CalculationStarted_);

    /**
     * Destructor
     */
    inline virtual  ~StartRouteCalculationSet();

    /**
     * Assignment operator
     */
    inline StartRouteCalculationSet& operator = (const StartRouteCalculationSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartRouteCalculationSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartRouteCalculationSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartRouteCalculationSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartRouteCalculationSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CalculationStarted"

    static const int kCalculationStarted = 0;

    /**
     * Clears the field "CalculationStarted".
     *
     * The field will be set to its default value. The hasCalculationStarted()
     * method will return false.
     */
    inline void clearCalculationStarted();

    /**
     * Checks whether the field "CalculationStarted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCalculationStarted()). Otherwise it will return false.
     */
    inline bool hasCalculationStarted () const;

    /**
     * Returns the value of the member "CalculationStarted".
     *
     * Pass the confirmation of the route calculation start to FC diagnosis.
     *
     * @return The value of the field "CalculationStarted"
     */
    inline bool getCalculationStarted () const;

    /**
     * Sets the value of the member "CalculationStarted".
     *
     * Pass the confirmation of the route calculation start to FC diagnosis.
     *
     * @param CalculationStarted The value which will be set
     */
    inline void setCalculationStarted (bool CalculationStarted_);

    static const StartRouteCalculationSet &getDefaultInstance();

private:

    inline void set_has_CalculationStarted ();

    inline void clear_has_CalculationStarted ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _CalculationStarted;

};

/**
 * The status message of the property "RouteCalculationResult"
 * The result of the route calculation is handled via this property. The result is passed via the set message. The route calculation is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ROUTECALCULATIONRESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class RouteCalculationResultStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RouteCalculationResultStatus ();

    /**
     * Copy constructor
     */
    inline  RouteCalculationResultStatus (const RouteCalculationResultStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RouteCalculationResultStatus (bool CalculationResultRequested_);

    /**
     * Destructor
     */
    inline virtual  ~RouteCalculationResultStatus();

    /**
     * Assignment operator
     */
    inline RouteCalculationResultStatus& operator = (const RouteCalculationResultStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RouteCalculationResultStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RouteCalculationResultStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RouteCalculationResultStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RouteCalculationResultStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CalculationResultRequested"

    static const int kCalculationResultRequested = 0;

    /**
     * Clears the field "CalculationResultRequested".
     *
     * The field will be set to its default value. The hasCalculationResultRequested()
     * method will return false.
     */
    inline void clearCalculationResultRequested();

    /**
     * Checks whether the field "CalculationResultRequested" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCalculationResultRequested()). Otherwise it will return false.
     */
    inline bool hasCalculationResultRequested () const;

    /**
     * Returns the value of the member "CalculationResultRequested".
     *
     * Route Calculation result requested .
     *
     * @return The value of the field "CalculationResultRequested"
     */
    inline bool getCalculationResultRequested () const;

    /**
     * Sets the value of the member "CalculationResultRequested".
     *
     * Route Calculation result requested .
     *
     * @param CalculationResultRequested The value which will be set
     */
    inline void setCalculationResultRequested (bool CalculationResultRequested_);

    static const RouteCalculationResultStatus &getDefaultInstance();

private:

    inline void set_has_CalculationResultRequested ();

    inline void clear_has_CalculationResultRequested ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _CalculationResultRequested;

};

/**
 * The set message of the property "RouteCalculationResult"
 * The result of the route calculation is handled via this property. The result is passed via the set message. The route calculation is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ROUTECALCULATIONRESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class RouteCalculationResultSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RouteCalculationResultSet ();

    /**
     * Copy constructor
     */
    inline  RouteCalculationResultSet (const RouteCalculationResultSet &rhs);

    /**
     * All fields constructor
     */
    inline  RouteCalculationResultSet (const ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& CalculationResult_);

    /**
     * Destructor
     */
    inline virtual  ~RouteCalculationResultSet();

    /**
     * Assignment operator
     */
    inline RouteCalculationResultSet& operator = (const RouteCalculationResultSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RouteCalculationResultSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RouteCalculationResultSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RouteCalculationResultSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RouteCalculationResultSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CalculationResult"

    static const int kCalculationResult = 0;

    /**
     * Clears the field "CalculationResult".
     *
     * The field will be set to its default value. The hasCalculationResult()
     * method will return false.
     */
    inline void clearCalculationResult();

    /**
     * Checks whether the field "CalculationResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCalculationResult()). Otherwise it will return false.
     */
    inline bool hasCalculationResult () const;

    /**
     * Returns the value of the member "CalculationResult".
     *
     * Return result of route calculation, length of route and time to destination.
     *
     * @return The value of the field "CalculationResult"
     */
    inline const ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& getCalculationResult () const;

    /**
     * Retrieves the value of the field "CalculationResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CalculationResult".
     */
    inline ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& getCalculationResultMutable ();

    /**
     * Sets the value of the member "CalculationResult".
     *
     * Return result of route calculation, length of route and time to destination.
     *
     * @param CalculationResult The value which will be set
     */
    inline void setCalculationResult (const ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& CalculationResult_);

    static const RouteCalculationResultSet &getDefaultInstance();

private:

    inline void set_has_CalculationResult ();

    inline void clear_has_CalculationResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter _CalculationResult;

};

/**
 * The status message of the property "SetLocaleStart"
 * The locale (country and language) can be set via this property. The client has to register for the property. The locale is set via the status message. The start of the locale switch is confirmed via  the set message. The result of the locale switch can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALESTART, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SetLocaleStartStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLocaleStartStatus ();

    /**
     * Copy constructor
     */
    inline  SetLocaleStartStatus (const SetLocaleStartStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SetLocaleStartStatus (const ::midw_diagnostics_fi_types::T_CountryLanguage& CountryLanguage_, ::midw_diagnostics_fi_types::T_e8_Store Store_);

    /**
     * Destructor
     */
    inline virtual  ~SetLocaleStartStatus();

    /**
     * Assignment operator
     */
    inline SetLocaleStartStatus& operator = (const SetLocaleStartStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLocaleStartStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLocaleStartStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLocaleStartStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLocaleStartStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CountryLanguage"

    static const int kCountryLanguage = 0;

    /**
     * Clears the field "CountryLanguage".
     *
     * The field will be set to its default value. The hasCountryLanguage()
     * method will return false.
     */
    inline void clearCountryLanguage();

    /**
     * Checks whether the field "CountryLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryLanguage()). Otherwise it will return false.
     */
    inline bool hasCountryLanguage () const;

    /**
     * Returns the value of the member "CountryLanguage".
     *
     * Pass new locale from FC diagnosis to HMI .
     *
     * @return The value of the field "CountryLanguage"
     */
    inline const ::midw_diagnostics_fi_types::T_CountryLanguage& getCountryLanguage () const;

    /**
     * Retrieves the value of the field "CountryLanguage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CountryLanguage".
     */
    inline ::midw_diagnostics_fi_types::T_CountryLanguage& getCountryLanguageMutable ();

    /**
     * Sets the value of the member "CountryLanguage".
     *
     * Pass new locale from FC diagnosis to HMI .
     *
     * @param CountryLanguage The value which will be set
     */
    inline void setCountryLanguage (const ::midw_diagnostics_fi_types::T_CountryLanguage& CountryLanguage_);

    // API of field "Store"

    static const int kStore = 1;

    /**
     * Clears the field "Store".
     *
     * The field will be set to its default value. The hasStore()
     * method will return false.
     */
    inline void clearStore();

    /**
     * Checks whether the field "Store" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStore()). Otherwise it will return false.
     */
    inline bool hasStore () const;

    /**
     * Returns the value of the member "Store".
     *
     * Store the new value persistently or restore the previous value.
     *
     * @return The value of the field "Store"
     */
    inline ::midw_diagnostics_fi_types::T_e8_Store getStore () const;

    /**
     * Sets the value of the member "Store".
     *
     * Store the new value persistently or restore the previous value.
     *
     * @param Store The value which will be set
     */
    inline void setStore (::midw_diagnostics_fi_types::T_e8_Store Store_);

    static const SetLocaleStartStatus &getDefaultInstance();

private:

    inline void set_has_CountryLanguage ();

    inline void clear_has_CountryLanguage ();

    inline void set_has_Store ();

    inline void clear_has_Store ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diagnostics_fi_types::T_CountryLanguage _CountryLanguage;

    ::midw_diagnostics_fi_types::T_e8_Store _Store;

};

/**
 * The set message of the property "SetLocaleStart"
 * The locale (country and language) can be set via this property. The client has to register for the property. The locale is set via the status message. The start of the locale switch is confirmed via  the set message. The result of the locale switch can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALESTART, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SetLocaleStartSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLocaleStartSet ();

    /**
     * Copy constructor
     */
    inline  SetLocaleStartSet (const SetLocaleStartSet &rhs);

    /**
     * All fields constructor
     */
    inline  SetLocaleStartSet (bool LocaleSwitched_);

    /**
     * Destructor
     */
    inline virtual  ~SetLocaleStartSet();

    /**
     * Assignment operator
     */
    inline SetLocaleStartSet& operator = (const SetLocaleStartSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLocaleStartSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLocaleStartSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLocaleStartSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLocaleStartSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LocaleSwitched"

    static const int kLocaleSwitched = 0;

    /**
     * Clears the field "LocaleSwitched".
     *
     * The field will be set to its default value. The hasLocaleSwitched()
     * method will return false.
     */
    inline void clearLocaleSwitched();

    /**
     * Checks whether the field "LocaleSwitched" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocaleSwitched()). Otherwise it will return false.
     */
    inline bool hasLocaleSwitched () const;

    /**
     * Returns the value of the member "LocaleSwitched".
     *
     * Pass the confirmation of the locale switch start to FC diagnosis.
     *
     * @return The value of the field "LocaleSwitched"
     */
    inline bool getLocaleSwitched () const;

    /**
     * Sets the value of the member "LocaleSwitched".
     *
     * Pass the confirmation of the locale switch start to FC diagnosis.
     *
     * @param LocaleSwitched The value which will be set
     */
    inline void setLocaleSwitched (bool LocaleSwitched_);

    static const SetLocaleStartSet &getDefaultInstance();

private:

    inline void set_has_LocaleSwitched ();

    inline void clear_has_LocaleSwitched ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _LocaleSwitched;

};

/**
 * The status message of the property "SetLocaleResult"
 * The result of the locale (country and language) switch is handled via this property. The result is passed via the set message. The switch of the locale is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALERESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SetLocaleResultStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLocaleResultStatus ();

    /**
     * Copy constructor
     */
    inline  SetLocaleResultStatus (const SetLocaleResultStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SetLocaleResultStatus (bool SetLocaleResultRequested_);

    /**
     * Destructor
     */
    inline virtual  ~SetLocaleResultStatus();

    /**
     * Assignment operator
     */
    inline SetLocaleResultStatus& operator = (const SetLocaleResultStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLocaleResultStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLocaleResultStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLocaleResultStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLocaleResultStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SetLocaleResultRequested"

    static const int kSetLocaleResultRequested = 0;

    /**
     * Clears the field "SetLocaleResultRequested".
     *
     * The field will be set to its default value. The hasSetLocaleResultRequested()
     * method will return false.
     */
    inline void clearSetLocaleResultRequested();

    /**
     * Checks whether the field "SetLocaleResultRequested" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSetLocaleResultRequested()). Otherwise it will return false.
     */
    inline bool hasSetLocaleResultRequested () const;

    /**
     * Returns the value of the member "SetLocaleResultRequested".
     *
     * Request the SetLocale results.
     *
     * @return The value of the field "SetLocaleResultRequested"
     */
    inline bool getSetLocaleResultRequested () const;

    /**
     * Sets the value of the member "SetLocaleResultRequested".
     *
     * Request the SetLocale results.
     *
     * @param SetLocaleResultRequested The value which will be set
     */
    inline void setSetLocaleResultRequested (bool SetLocaleResultRequested_);

    static const SetLocaleResultStatus &getDefaultInstance();

private:

    inline void set_has_SetLocaleResultRequested ();

    inline void clear_has_SetLocaleResultRequested ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _SetLocaleResultRequested;

};

/**
 * The set message of the property "SetLocaleResult"
 * The result of the locale (country and language) switch is handled via this property. The result is passed via the set message. The switch of the locale is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALERESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SetLocaleResultSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLocaleResultSet ();

    /**
     * Copy constructor
     */
    inline  SetLocaleResultSet (const SetLocaleResultSet &rhs);

    /**
     * All fields constructor
     */
    inline  SetLocaleResultSet (const ::midw_diagnostics_fi_types::T_CountryLanguageResult& CountryLanguageResult_);

    /**
     * Destructor
     */
    inline virtual  ~SetLocaleResultSet();

    /**
     * Assignment operator
     */
    inline SetLocaleResultSet& operator = (const SetLocaleResultSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLocaleResultSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLocaleResultSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLocaleResultSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLocaleResultSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CountryLanguageResult"

    static const int kCountryLanguageResult = 0;

    /**
     * Clears the field "CountryLanguageResult".
     *
     * The field will be set to its default value. The hasCountryLanguageResult()
     * method will return false.
     */
    inline void clearCountryLanguageResult();

    /**
     * Checks whether the field "CountryLanguageResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryLanguageResult()). Otherwise it will return false.
     */
    inline bool hasCountryLanguageResult () const;

    /**
     * Returns the value of the member "CountryLanguageResult".
     *
     * Returns result of locale switch and the locales currently set.
     *
     * @return The value of the field "CountryLanguageResult"
     */
    inline const ::midw_diagnostics_fi_types::T_CountryLanguageResult& getCountryLanguageResult () const;

    /**
     * Retrieves the value of the field "CountryLanguageResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CountryLanguageResult".
     */
    inline ::midw_diagnostics_fi_types::T_CountryLanguageResult& getCountryLanguageResultMutable ();

    /**
     * Sets the value of the member "CountryLanguageResult".
     *
     * Returns result of locale switch and the locales currently set.
     *
     * @param CountryLanguageResult The value which will be set
     */
    inline void setCountryLanguageResult (const ::midw_diagnostics_fi_types::T_CountryLanguageResult& CountryLanguageResult_);

    static const SetLocaleResultSet &getDefaultInstance();

private:

    inline void set_has_CountryLanguageResult ();

    inline void clear_has_CountryLanguageResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_CountryLanguageResult _CountryLanguageResult;

};

/**
 * The status message of the property "GetLocale"
 * The locale (country and language) can be obtained via this property. The client has to register for the property. The locale is passed to the HMI via the status message.  The result for the get operation is received via set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETLOCALE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class GetLocaleStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetLocaleStatus ();

    /**
     * Copy constructor
     */
    inline  GetLocaleStatus (const GetLocaleStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GetLocaleStatus (bool GetLocaleRequested_);

    /**
     * Destructor
     */
    inline virtual  ~GetLocaleStatus();

    /**
     * Assignment operator
     */
    inline GetLocaleStatus& operator = (const GetLocaleStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetLocaleStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetLocaleStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetLocaleStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetLocaleStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GetLocaleRequested"

    static const int kGetLocaleRequested = 0;

    /**
     * Clears the field "GetLocaleRequested".
     *
     * The field will be set to its default value. The hasGetLocaleRequested()
     * method will return false.
     */
    inline void clearGetLocaleRequested();

    /**
     * Checks whether the field "GetLocaleRequested" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGetLocaleRequested()). Otherwise it will return false.
     */
    inline bool hasGetLocaleRequested () const;

    /**
     * Returns the value of the member "GetLocaleRequested".
     *
     * Request the current locale settings.
     *
     * @return The value of the field "GetLocaleRequested"
     */
    inline bool getGetLocaleRequested () const;

    /**
     * Sets the value of the member "GetLocaleRequested".
     *
     * Request the current locale settings.
     *
     * @param GetLocaleRequested The value which will be set
     */
    inline void setGetLocaleRequested (bool GetLocaleRequested_);

    static const GetLocaleStatus &getDefaultInstance();

private:

    inline void set_has_GetLocaleRequested ();

    inline void clear_has_GetLocaleRequested ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _GetLocaleRequested;

};

/**
 * The set message of the property "GetLocale"
 * The locale (country and language) can be obtained via this property. The client has to register for the property. The locale is passed to the HMI via the status message.  The result for the get operation is received via set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETLOCALE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class GetLocaleSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetLocaleSet ();

    /**
     * Copy constructor
     */
    inline  GetLocaleSet (const GetLocaleSet &rhs);

    /**
     * All fields constructor
     */
    inline  GetLocaleSet (const ::midw_diagnostics_fi_types::T_CountryLanguage& CountryLanguage_);

    /**
     * Destructor
     */
    inline virtual  ~GetLocaleSet();

    /**
     * Assignment operator
     */
    inline GetLocaleSet& operator = (const GetLocaleSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetLocaleSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetLocaleSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetLocaleSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetLocaleSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CountryLanguage"

    static const int kCountryLanguage = 0;

    /**
     * Clears the field "CountryLanguage".
     *
     * The field will be set to its default value. The hasCountryLanguage()
     * method will return false.
     */
    inline void clearCountryLanguage();

    /**
     * Checks whether the field "CountryLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryLanguage()). Otherwise it will return false.
     */
    inline bool hasCountryLanguage () const;

    /**
     * Returns the value of the member "CountryLanguage".
     *
     * Pass  the locale to FC diagnosis.
     *
     * @return The value of the field "CountryLanguage"
     */
    inline const ::midw_diagnostics_fi_types::T_CountryLanguage& getCountryLanguage () const;

    /**
     * Retrieves the value of the field "CountryLanguage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CountryLanguage".
     */
    inline ::midw_diagnostics_fi_types::T_CountryLanguage& getCountryLanguageMutable ();

    /**
     * Sets the value of the member "CountryLanguage".
     *
     * Pass  the locale to FC diagnosis.
     *
     * @param CountryLanguage The value which will be set
     */
    inline void setCountryLanguage (const ::midw_diagnostics_fi_types::T_CountryLanguage& CountryLanguage_);

    static const GetLocaleSet &getDefaultInstance();

private:

    inline void set_has_CountryLanguage ();

    inline void clear_has_CountryLanguage ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_CountryLanguage _CountryLanguage;

};

/**
 * The status message of the property "SetDisplay"
 * The test pictures and the diagnostics screen can be set via this property. The client has to register for the property. The display to be used is passed to the HMI via the Status message. The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETDISPLAY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SetDisplayStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDisplayStatus ();

    /**
     * Copy constructor
     */
    inline  SetDisplayStatus (const SetDisplayStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SetDisplayStatus (const ::midw_diagnostics_fi_types::T_DisplayData& DisplayData_);

    /**
     * Destructor
     */
    inline virtual  ~SetDisplayStatus();

    /**
     * Assignment operator
     */
    inline SetDisplayStatus& operator = (const SetDisplayStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDisplayStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDisplayStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDisplayStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDisplayStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DisplayData"

    static const int kDisplayData = 0;

    /**
     * Clears the field "DisplayData".
     *
     * The field will be set to its default value. The hasDisplayData()
     * method will return false.
     */
    inline void clearDisplayData();

    /**
     * Checks whether the field "DisplayData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayData()). Otherwise it will return false.
     */
    inline bool hasDisplayData () const;

    /**
     * Returns the value of the member "DisplayData".
     *
     * Pass  the screen test and text details to the HMI.
     *
     * @return The value of the field "DisplayData"
     */
    inline const ::midw_diagnostics_fi_types::T_DisplayData& getDisplayData () const;

    /**
     * Retrieves the value of the field "DisplayData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayData".
     */
    inline ::midw_diagnostics_fi_types::T_DisplayData& getDisplayDataMutable ();

    /**
     * Sets the value of the member "DisplayData".
     *
     * Pass  the screen test and text details to the HMI.
     *
     * @param DisplayData The value which will be set
     */
    inline void setDisplayData (const ::midw_diagnostics_fi_types::T_DisplayData& DisplayData_);

    static const SetDisplayStatus &getDefaultInstance();

private:

    inline void set_has_DisplayData ();

    inline void clear_has_DisplayData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_DisplayData _DisplayData;

};

/**
 * The set message of the property "SetDisplay"
 * The test pictures and the diagnostics screen can be set via this property. The client has to register for the property. The display to be used is passed to the HMI via the Status message. The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETDISPLAY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SetDisplaySet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDisplaySet ();

    /**
     * Copy constructor
     */
    inline  SetDisplaySet (const SetDisplaySet &rhs);

    /**
     * All fields constructor
     */
    inline  SetDisplaySet (bool DisplayTestSuccess_);

    /**
     * Destructor
     */
    inline virtual  ~SetDisplaySet();

    /**
     * Assignment operator
     */
    inline SetDisplaySet& operator = (const SetDisplaySet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDisplaySet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDisplaySet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDisplaySet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDisplaySet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DisplayTestSuccess"

    static const int kDisplayTestSuccess = 0;

    /**
     * Clears the field "DisplayTestSuccess".
     *
     * The field will be set to its default value. The hasDisplayTestSuccess()
     * method will return false.
     */
    inline void clearDisplayTestSuccess();

    /**
     * Checks whether the field "DisplayTestSuccess" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayTestSuccess()). Otherwise it will return false.
     */
    inline bool hasDisplayTestSuccess () const;

    /**
     * Returns the value of the member "DisplayTestSuccess".
     *
     * Result of displaying test screen.
     *
     * @return The value of the field "DisplayTestSuccess"
     */
    inline bool getDisplayTestSuccess () const;

    /**
     * Sets the value of the member "DisplayTestSuccess".
     *
     * Result of displaying test screen.
     *
     * @param DisplayTestSuccess The value which will be set
     */
    inline void setDisplayTestSuccess (bool DisplayTestSuccess_);

    static const SetDisplaySet &getDefaultInstance();

private:

    inline void set_has_DisplayTestSuccess ();

    inline void clear_has_DisplayTestSuccess ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _DisplayTestSuccess;

};

/**
 * The status message of the property "ConfigUpdateViaUSB"
 * HMI support to show the status of configuration update through USB- Config update start status, when config file found for the particular variant- Upon config items write, trigger for hash calculation
 * - Show config update success or failure message - Display Restart the system message, if config hash is successful otherwise display update config once again message.
 * Set the current status of the config update via - Config update started - Hash success or failure status
 */
class ConfigUpdateViaUSBStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConfigUpdateViaUSBStatus ();

    /**
     * Copy constructor
     */
    inline  ConfigUpdateViaUSBStatus (const ConfigUpdateViaUSBStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ConfigUpdateViaUSBStatus (::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus ConfigUpdateStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ConfigUpdateViaUSBStatus();

    /**
     * Assignment operator
     */
    inline ConfigUpdateViaUSBStatus& operator = (const ConfigUpdateViaUSBStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConfigUpdateViaUSBStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConfigUpdateViaUSBStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConfigUpdateViaUSBStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConfigUpdateViaUSBStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConfigUpdateStatus"

    static const int kConfigUpdateStatus = 0;

    /**
     * Clears the field "ConfigUpdateStatus".
     *
     * The field will be set to its default value. The hasConfigUpdateStatus()
     * method will return false.
     */
    inline void clearConfigUpdateStatus();

    /**
     * Checks whether the field "ConfigUpdateStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigUpdateStatus()). Otherwise it will return false.
     */
    inline bool hasConfigUpdateStatus () const;

    /**
     * Returns the value of the member "ConfigUpdateStatus".
     *
     * Indicates config update status to HMI(config file found in dynamic partition and hash comparison status to HMI(success or failure))
     *
     * @return The value of the field "ConfigUpdateStatus"
     */
    inline ::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus getConfigUpdateStatus () const;

    /**
     * Sets the value of the member "ConfigUpdateStatus".
     *
     * Indicates config update status to HMI(config file found in dynamic partition and hash comparison status to HMI(success or failure))
     *
     * @param ConfigUpdateStatus The value which will be set
     */
    inline void setConfigUpdateStatus (::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus ConfigUpdateStatus_);

    static const ConfigUpdateViaUSBStatus &getDefaultInstance();

private:

    inline void set_has_ConfigUpdateStatus ();

    inline void clear_has_ConfigUpdateStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus _ConfigUpdateStatus;

};

/**
 * The set message of the property "AntiTheftStatus"
 * Get status of Anti theft status. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFTSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class AntiTheftStatusSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AntiTheftStatusSet ();

    /**
     * Copy constructor
     */
    inline  AntiTheftStatusSet (const AntiTheftStatusSet &rhs);

    /**
     * All fields constructor
     */
    inline  AntiTheftStatusSet (::midw_diagnostics_fi_types::T_AntiTheftStatus AntiTheftStatus_);

    /**
     * Destructor
     */
    inline virtual  ~AntiTheftStatusSet();

    /**
     * Assignment operator
     */
    inline AntiTheftStatusSet& operator = (const AntiTheftStatusSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AntiTheftStatusSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AntiTheftStatusSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AntiTheftStatusSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AntiTheftStatusSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AntiTheftStatus"

    static const int kAntiTheftStatus = 0;

    /**
     * Clears the field "AntiTheftStatus".
     *
     * The field will be set to its default value. The hasAntiTheftStatus()
     * method will return false.
     */
    inline void clearAntiTheftStatus();

    /**
     * Checks whether the field "AntiTheftStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAntiTheftStatus()). Otherwise it will return false.
     */
    inline bool hasAntiTheftStatus () const;

    /**
     * Returns the value of the member "AntiTheftStatus".
     *
     * Get status of Antitheft.
     *
     * @return The value of the field "AntiTheftStatus"
     */
    inline ::midw_diagnostics_fi_types::T_AntiTheftStatus getAntiTheftStatus () const;

    /**
     * Sets the value of the member "AntiTheftStatus".
     *
     * Get status of Antitheft.
     *
     * @param AntiTheftStatus The value which will be set
     */
    inline void setAntiTheftStatus (::midw_diagnostics_fi_types::T_AntiTheftStatus AntiTheftStatus_);

    static const AntiTheftStatusSet &getDefaultInstance();

private:

    inline void set_has_AntiTheftStatus ();

    inline void clear_has_AntiTheftStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_AntiTheftStatus _AntiTheftStatus;

};

/**
 * The status message of the property "AntiTheftUnlockHMI"
 * Unlock HMI if VID write success in Antitheft sequence.. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHMI, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class AntiTheftUnlockHMIStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AntiTheftUnlockHMIStatus ();

    /**
     * Copy constructor
     */
    inline  AntiTheftUnlockHMIStatus (const AntiTheftUnlockHMIStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AntiTheftUnlockHMIStatus (bool VIDWriteStatus_);

    /**
     * Destructor
     */
    inline virtual  ~AntiTheftUnlockHMIStatus();

    /**
     * Assignment operator
     */
    inline AntiTheftUnlockHMIStatus& operator = (const AntiTheftUnlockHMIStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AntiTheftUnlockHMIStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AntiTheftUnlockHMIStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AntiTheftUnlockHMIStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AntiTheftUnlockHMIStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VIDWriteStatus"

    static const int kVIDWriteStatus = 0;

    /**
     * Clears the field "VIDWriteStatus".
     *
     * The field will be set to its default value. The hasVIDWriteStatus()
     * method will return false.
     */
    inline void clearVIDWriteStatus();

    /**
     * Checks whether the field "VIDWriteStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVIDWriteStatus()). Otherwise it will return false.
     */
    inline bool hasVIDWriteStatus () const;

    /**
     * Returns the value of the member "VIDWriteStatus".
     *
     * VID Write status.
     *
     * @return The value of the field "VIDWriteStatus"
     */
    inline bool getVIDWriteStatus () const;

    /**
     * Sets the value of the member "VIDWriteStatus".
     *
     * VID Write status.
     *
     * @param VIDWriteStatus The value which will be set
     */
    inline void setVIDWriteStatus (bool VIDWriteStatus_);

    static const AntiTheftUnlockHMIStatus &getDefaultInstance();

private:

    inline void set_has_VIDWriteStatus ();

    inline void clear_has_VIDWriteStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _VIDWriteStatus;

};

/**
 * The status message of the property "AntiTheftUnlockHU"
 * Unlock HU if PIN Validation success in Antitheft sequence. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHU, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class AntiTheftUnlockHUStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AntiTheftUnlockHUStatus ();

    /**
     * Copy constructor
     */
    inline  AntiTheftUnlockHUStatus (const AntiTheftUnlockHUStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AntiTheftUnlockHUStatus (bool PINValidationStatus_);

    /**
     * Destructor
     */
    inline virtual  ~AntiTheftUnlockHUStatus();

    /**
     * Assignment operator
     */
    inline AntiTheftUnlockHUStatus& operator = (const AntiTheftUnlockHUStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AntiTheftUnlockHUStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AntiTheftUnlockHUStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AntiTheftUnlockHUStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AntiTheftUnlockHUStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PINValidationStatus"

    static const int kPINValidationStatus = 0;

    /**
     * Clears the field "PINValidationStatus".
     *
     * The field will be set to its default value. The hasPINValidationStatus()
     * method will return false.
     */
    inline void clearPINValidationStatus();

    /**
     * Checks whether the field "PINValidationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPINValidationStatus()). Otherwise it will return false.
     */
    inline bool hasPINValidationStatus () const;

    /**
     * Returns the value of the member "PINValidationStatus".
     *
     * PIN validation status.
     *
     * @return The value of the field "PINValidationStatus"
     */
    inline bool getPINValidationStatus () const;

    /**
     * Sets the value of the member "PINValidationStatus".
     *
     * PIN validation status.
     *
     * @param PINValidationStatus The value which will be set
     */
    inline void setPINValidationStatus (bool PINValidationStatus_);

    static const AntiTheftUnlockHUStatus &getDefaultInstance();

private:

    inline void set_has_PINValidationStatus ();

    inline void clear_has_PINValidationStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _PINValidationStatus;

};

/**
 * The status message of the property "ClearDestinationMemory"
 * Destination memory can be erased using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_CLEARDESTINATIONMEMORY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class ClearDestinationMemoryStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearDestinationMemoryStatus ();

    /**
     * Copy constructor
     */
    inline  ClearDestinationMemoryStatus (const ClearDestinationMemoryStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ClearDestinationMemoryStatus (bool ClearMemory_);

    /**
     * Destructor
     */
    inline virtual  ~ClearDestinationMemoryStatus();

    /**
     * Assignment operator
     */
    inline ClearDestinationMemoryStatus& operator = (const ClearDestinationMemoryStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearDestinationMemoryStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearDestinationMemoryStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearDestinationMemoryStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearDestinationMemoryStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ClearMemory"

    static const int kClearMemory = 0;

    /**
     * Clears the field "ClearMemory".
     *
     * The field will be set to its default value. The hasClearMemory()
     * method will return false.
     */
    inline void clearClearMemory();

    /**
     * Checks whether the field "ClearMemory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClearMemory()). Otherwise it will return false.
     */
    inline bool hasClearMemory () const;

    /**
     * Returns the value of the member "ClearMemory".
     *
     * Command to clear the memory.
     *
     * @return The value of the field "ClearMemory"
     */
    inline bool getClearMemory () const;

    /**
     * Sets the value of the member "ClearMemory".
     *
     * Command to clear the memory.
     *
     * @param ClearMemory The value which will be set
     */
    inline void setClearMemory (bool ClearMemory_);

    static const ClearDestinationMemoryStatus &getDefaultInstance();

private:

    inline void set_has_ClearMemory ();

    inline void clear_has_ClearMemory ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _ClearMemory;

};

/**
 * The set message of the property "ClearDestinationMemory"
 * Destination memory can be erased using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_CLEARDESTINATIONMEMORY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class ClearDestinationMemorySet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearDestinationMemorySet ();

    /**
     * Copy constructor
     */
    inline  ClearDestinationMemorySet (const ClearDestinationMemorySet &rhs);

    /**
     * All fields constructor
     */
    inline  ClearDestinationMemorySet (bool ClearMemorySuccess_);

    /**
     * Destructor
     */
    inline virtual  ~ClearDestinationMemorySet();

    /**
     * Assignment operator
     */
    inline ClearDestinationMemorySet& operator = (const ClearDestinationMemorySet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearDestinationMemorySet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearDestinationMemorySet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearDestinationMemorySet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearDestinationMemorySet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ClearMemorySuccess"

    static const int kClearMemorySuccess = 0;

    /**
     * Clears the field "ClearMemorySuccess".
     *
     * The field will be set to its default value. The hasClearMemorySuccess()
     * method will return false.
     */
    inline void clearClearMemorySuccess();

    /**
     * Checks whether the field "ClearMemorySuccess" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClearMemorySuccess()). Otherwise it will return false.
     */
    inline bool hasClearMemorySuccess () const;

    /**
     * Returns the value of the member "ClearMemorySuccess".
     *
     * Result of clear operation.
     *
     * @return The value of the field "ClearMemorySuccess"
     */
    inline bool getClearMemorySuccess () const;

    /**
     * Sets the value of the member "ClearMemorySuccess".
     *
     * Result of clear operation.
     *
     * @param ClearMemorySuccess The value which will be set
     */
    inline void setClearMemorySuccess (bool ClearMemorySuccess_);

    static const ClearDestinationMemorySet &getDefaultInstance();

private:

    inline void set_has_ClearMemorySuccess ();

    inline void clear_has_ClearMemorySuccess ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _ClearMemorySuccess;

};

/**
 * The status message of the property "GetDestinationMemorySize"
 * The current size of the destination memory can be obtained using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETDESTINATIONMEMORYSIZE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class GetDestinationMemorySizeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDestinationMemorySizeStatus ();

    /**
     * Copy constructor
     */
    inline  GetDestinationMemorySizeStatus (const GetDestinationMemorySizeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GetDestinationMemorySizeStatus (bool GetMemorySize_);

    /**
     * Destructor
     */
    inline virtual  ~GetDestinationMemorySizeStatus();

    /**
     * Assignment operator
     */
    inline GetDestinationMemorySizeStatus& operator = (const GetDestinationMemorySizeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDestinationMemorySizeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDestinationMemorySizeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDestinationMemorySizeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDestinationMemorySizeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GetMemorySize"

    static const int kGetMemorySize = 0;

    /**
     * Clears the field "GetMemorySize".
     *
     * The field will be set to its default value. The hasGetMemorySize()
     * method will return false.
     */
    inline void clearGetMemorySize();

    /**
     * Checks whether the field "GetMemorySize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGetMemorySize()). Otherwise it will return false.
     */
    inline bool hasGetMemorySize () const;

    /**
     * Returns the value of the member "GetMemorySize".
     *
     * Command to get the memory size.
     *
     * @return The value of the field "GetMemorySize"
     */
    inline bool getGetMemorySize () const;

    /**
     * Sets the value of the member "GetMemorySize".
     *
     * Command to get the memory size.
     *
     * @param GetMemorySize The value which will be set
     */
    inline void setGetMemorySize (bool GetMemorySize_);

    static const GetDestinationMemorySizeStatus &getDefaultInstance();

private:

    inline void set_has_GetMemorySize ();

    inline void clear_has_GetMemorySize ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _GetMemorySize;

};

/**
 * The set message of the property "GetDestinationMemorySize"
 * The current size of the destination memory can be obtained using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETDESTINATIONMEMORYSIZE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class GetDestinationMemorySizeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDestinationMemorySizeSet ();

    /**
     * Copy constructor
     */
    inline  GetDestinationMemorySizeSet (const GetDestinationMemorySizeSet &rhs);

    /**
     * All fields constructor
     */
    inline  GetDestinationMemorySizeSet (uint16 RecordCount_);

    /**
     * Destructor
     */
    inline virtual  ~GetDestinationMemorySizeSet();

    /**
     * Assignment operator
     */
    inline GetDestinationMemorySizeSet& operator = (const GetDestinationMemorySizeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDestinationMemorySizeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDestinationMemorySizeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDestinationMemorySizeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDestinationMemorySizeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RecordCount"

    static const int kRecordCount = 0;

    /**
     * Clears the field "RecordCount".
     *
     * The field will be set to its default value. The hasRecordCount()
     * method will return false.
     */
    inline void clearRecordCount();

    /**
     * Checks whether the field "RecordCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecordCount()). Otherwise it will return false.
     */
    inline bool hasRecordCount () const;

    /**
     * Returns the value of the member "RecordCount".
     *
     * No of records in the destination memory.
     *
     * @return The value of the field "RecordCount"
     */
    inline uint16 getRecordCount () const;

    /**
     * Sets the value of the member "RecordCount".
     *
     * No of records in the destination memory.
     *
     * @param RecordCount The value which will be set
     */
    inline void setRecordCount (uint16 RecordCount_);

    static const GetDestinationMemorySizeSet &getDefaultInstance();

private:

    inline void set_has_RecordCount ();

    inline void clear_has_RecordCount ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _RecordCount;

};

/**
 * The status message of the property "SimulateKeyPress"
 * Instructs the HMI to simulate a key press. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SIMULATEKEYPRESS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SimulateKeyPressStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimulateKeyPressStatus ();

    /**
     * Copy constructor
     */
    inline  SimulateKeyPressStatus (const SimulateKeyPressStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SimulateKeyPressStatus (::midw_diagnostics_fi_types::T_e8_SimulatedKeys KeyCommand_, int8 EncoderSteps_);

    /**
     * Destructor
     */
    inline virtual  ~SimulateKeyPressStatus();

    /**
     * Assignment operator
     */
    inline SimulateKeyPressStatus& operator = (const SimulateKeyPressStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimulateKeyPressStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimulateKeyPressStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimulateKeyPressStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimulateKeyPressStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "KeyCommand"

    static const int kKeyCommand = 0;

    /**
     * Clears the field "KeyCommand".
     *
     * The field will be set to its default value. The hasKeyCommand()
     * method will return false.
     */
    inline void clearKeyCommand();

    /**
     * Checks whether the field "KeyCommand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyCommand()). Otherwise it will return false.
     */
    inline bool hasKeyCommand () const;

    /**
     * Returns the value of the member "KeyCommand".
     *
     * The key code.
     *
     * @return The value of the field "KeyCommand"
     */
    inline ::midw_diagnostics_fi_types::T_e8_SimulatedKeys getKeyCommand () const;

    /**
     * Sets the value of the member "KeyCommand".
     *
     * The key code.
     *
     * @param KeyCommand The value which will be set
     */
    inline void setKeyCommand (::midw_diagnostics_fi_types::T_e8_SimulatedKeys KeyCommand_);

    // API of field "EncoderSteps"

    static const int kEncoderSteps = 1;

    /**
     * Clears the field "EncoderSteps".
     *
     * The field will be set to its default value. The hasEncoderSteps()
     * method will return false.
     */
    inline void clearEncoderSteps();

    /**
     * Checks whether the field "EncoderSteps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncoderSteps()). Otherwise it will return false.
     */
    inline bool hasEncoderSteps () const;

    /**
     * Returns the value of the member "EncoderSteps".
     *
     * The amount to turn a switch. + to th eright, - to the left.
     *
     * @return The value of the field "EncoderSteps"
     */
    inline int8 getEncoderSteps () const;

    /**
     * Sets the value of the member "EncoderSteps".
     *
     * The amount to turn a switch. + to th eright, - to the left.
     *
     * @param EncoderSteps The value which will be set
     */
    inline void setEncoderSteps (int8 EncoderSteps_);

    static const SimulateKeyPressStatus &getDefaultInstance();

private:

    inline void set_has_KeyCommand ();

    inline void clear_has_KeyCommand ();

    inline void set_has_EncoderSteps ();

    inline void clear_has_EncoderSteps ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_SimulatedKeys _KeyCommand;

    int8 _EncoderSteps;

};

/**
 * The set message of the property "SimulateKeyPress"
 * Instructs the HMI to simulate a key press. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SIMULATEKEYPRESS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SimulateKeyPressSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimulateKeyPressSet ();

    /**
     * Copy constructor
     */
    inline  SimulateKeyPressSet (const SimulateKeyPressSet &rhs);

    /**
     * All fields constructor
     */
    inline  SimulateKeyPressSet (bool KeyPressSuccess_);

    /**
     * Destructor
     */
    inline virtual  ~SimulateKeyPressSet();

    /**
     * Assignment operator
     */
    inline SimulateKeyPressSet& operator = (const SimulateKeyPressSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimulateKeyPressSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimulateKeyPressSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimulateKeyPressSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimulateKeyPressSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "KeyPressSuccess"

    static const int kKeyPressSuccess = 0;

    /**
     * Clears the field "KeyPressSuccess".
     *
     * The field will be set to its default value. The hasKeyPressSuccess()
     * method will return false.
     */
    inline void clearKeyPressSuccess();

    /**
     * Checks whether the field "KeyPressSuccess" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyPressSuccess()). Otherwise it will return false.
     */
    inline bool hasKeyPressSuccess () const;

    /**
     * Returns the value of the member "KeyPressSuccess".
     *
     * Indicates success or failure of key press.
     *
     * @return The value of the field "KeyPressSuccess"
     */
    inline bool getKeyPressSuccess () const;

    /**
     * Sets the value of the member "KeyPressSuccess".
     *
     * Indicates success or failure of key press.
     *
     * @param KeyPressSuccess The value which will be set
     */
    inline void setKeyPressSuccess (bool KeyPressSuccess_);

    static const SimulateKeyPressSet &getDefaultInstance();

private:

    inline void set_has_KeyPressSuccess ();

    inline void clear_has_KeyPressSuccess ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _KeyPressSuccess;

};

/**
 * The status message of the property "ResetSecurity"
 * Instructs the HMI to perform a security reset. E.g. reset the number of unsuccessful password entries. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RESETSECURITY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class ResetSecurityStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetSecurityStatus ();

    /**
     * Copy constructor
     */
    inline  ResetSecurityStatus (const ResetSecurityStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ResetSecurityStatus (bool Reset_);

    /**
     * Destructor
     */
    inline virtual  ~ResetSecurityStatus();

    /**
     * Assignment operator
     */
    inline ResetSecurityStatus& operator = (const ResetSecurityStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetSecurityStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetSecurityStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetSecurityStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetSecurityStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Reset"

    static const int kReset = 0;

    /**
     * Clears the field "Reset".
     *
     * The field will be set to its default value. The hasReset()
     * method will return false.
     */
    inline void clearReset();

    /**
     * Checks whether the field "Reset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReset()). Otherwise it will return false.
     */
    inline bool hasReset () const;

    /**
     * Returns the value of the member "Reset".
     *
     * When set to true activates a reset.
     *
     * @return The value of the field "Reset"
     */
    inline bool getReset () const;

    /**
     * Sets the value of the member "Reset".
     *
     * When set to true activates a reset.
     *
     * @param Reset The value which will be set
     */
    inline void setReset (bool Reset_);

    static const ResetSecurityStatus &getDefaultInstance();

private:

    inline void set_has_Reset ();

    inline void clear_has_Reset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Reset;

};

/**
 * The set message of the property "ResetSecurity"
 * Instructs the HMI to perform a security reset. E.g. reset the number of unsuccessful password entries. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RESETSECURITY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class ResetSecuritySet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetSecuritySet ();

    /**
     * Copy constructor
     */
    inline  ResetSecuritySet (const ResetSecuritySet &rhs);

    /**
     * All fields constructor
     */
    inline  ResetSecuritySet (bool ResetSuccess_);

    /**
     * Destructor
     */
    inline virtual  ~ResetSecuritySet();

    /**
     * Assignment operator
     */
    inline ResetSecuritySet& operator = (const ResetSecuritySet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetSecuritySet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetSecuritySet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetSecuritySet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetSecuritySet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResetSuccess"

    static const int kResetSuccess = 0;

    /**
     * Clears the field "ResetSuccess".
     *
     * The field will be set to its default value. The hasResetSuccess()
     * method will return false.
     */
    inline void clearResetSuccess();

    /**
     * Checks whether the field "ResetSuccess" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResetSuccess()). Otherwise it will return false.
     */
    inline bool hasResetSuccess () const;

    /**
     * Returns the value of the member "ResetSuccess".
     *
     * Indicates success or failure of security reset.
     *
     * @return The value of the field "ResetSuccess"
     */
    inline bool getResetSuccess () const;

    /**
     * Sets the value of the member "ResetSuccess".
     *
     * Indicates success or failure of security reset.
     *
     * @param ResetSuccess The value which will be set
     */
    inline void setResetSuccess (bool ResetSuccess_);

    static const ResetSecuritySet &getDefaultInstance();

private:

    inline void set_has_ResetSuccess ();

    inline void clear_has_ResetSuccess ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _ResetSuccess;

};

/**
 * The get message of the property "Language"
 * Vehicle type. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_LANGUAGE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class LanguageGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LanguageGet ();

    /**
     * Copy constructor
     */
    inline  LanguageGet (const LanguageGet &rhs);

    /**
     * All fields constructor
     */
    inline  LanguageGet (::midw_diagnostics_fi_types::T_e16_Language Language_);

    /**
     * Destructor
     */
    inline virtual  ~LanguageGet();

    /**
     * Assignment operator
     */
    inline LanguageGet& operator = (const LanguageGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LanguageGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LanguageGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LanguageGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LanguageGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Language"

    static const int kLanguage = 0;

    /**
     * Clears the field "Language".
     *
     * The field will be set to its default value. The hasLanguage()
     * method will return false.
     */
    inline void clearLanguage();

    /**
     * Checks whether the field "Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguage()). Otherwise it will return false.
     */
    inline bool hasLanguage () const;

    /**
     * Returns the value of the member "Language".
     *
     * Language
     *
     * @return The value of the field "Language"
     */
    inline ::midw_diagnostics_fi_types::T_e16_Language getLanguage () const;

    /**
     * Sets the value of the member "Language".
     *
     * Language
     *
     * @param Language The value which will be set
     */
    inline void setLanguage (::midw_diagnostics_fi_types::T_e16_Language Language_);

    static const LanguageGet &getDefaultInstance();

private:

    inline void set_has_Language ();

    inline void clear_has_Language ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e16_Language _Language;

};

/**
 * The status message of the property "SpeedLock"
 * Get Speed Lock value and Threshold from Diagnosis. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
 * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SpeedLockStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedLockStatus ();

    /**
     * Copy constructor
     */
    inline  SpeedLockStatus (const SpeedLockStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedLockStatus (::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLockStatus_, uint8 SpeedLockThreshold_);

    /**
     * Destructor
     */
    inline virtual  ~SpeedLockStatus();

    /**
     * Assignment operator
     */
    inline SpeedLockStatus& operator = (const SpeedLockStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedLockStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedLockStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedLockStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedLockStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SpeedLockStatus"

    static const int kSpeedLockStatus = 0;

    /**
     * Clears the field "SpeedLockStatus".
     *
     * The field will be set to its default value. The hasSpeedLockStatus()
     * method will return false.
     */
    inline void clearSpeedLockStatus();

    /**
     * Checks whether the field "SpeedLockStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedLockStatus()). Otherwise it will return false.
     */
    inline bool hasSpeedLockStatus () const;

    /**
     * Returns the value of the member "SpeedLockStatus".
     *
     * Speed Lock Status
     *
     * @return The value of the field "SpeedLockStatus"
     */
    inline ::midw_diagnostics_fi_types::T_e16_SpeedLock getSpeedLockStatus () const;

    /**
     * Sets the value of the member "SpeedLockStatus".
     *
     * Speed Lock Status
     *
     * @param SpeedLockStatus The value which will be set
     */
    inline void setSpeedLockStatus (::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLockStatus_);

    // API of field "SpeedLockThreshold"

    static const int kSpeedLockThreshold = 1;

    /**
     * Clears the field "SpeedLockThreshold".
     *
     * The field will be set to its default value. The hasSpeedLockThreshold()
     * method will return false.
     */
    inline void clearSpeedLockThreshold();

    /**
     * Checks whether the field "SpeedLockThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedLockThreshold()). Otherwise it will return false.
     */
    inline bool hasSpeedLockThreshold () const;

    /**
     * Returns the value of the member "SpeedLockThreshold".
     *
     * Speed Lock Threshold value
     *
     * @return The value of the field "SpeedLockThreshold"
     */
    inline uint8 getSpeedLockThreshold () const;

    /**
     * Sets the value of the member "SpeedLockThreshold".
     *
     * Speed Lock Threshold value
     *
     * @param SpeedLockThreshold The value which will be set
     */
    inline void setSpeedLockThreshold (uint8 SpeedLockThreshold_);

    static const SpeedLockStatus &getDefaultInstance();

private:

    inline void set_has_SpeedLockStatus ();

    inline void clear_has_SpeedLockStatus ();

    inline void set_has_SpeedLockThreshold ();

    inline void clear_has_SpeedLockThreshold ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e16_SpeedLock _SpeedLockStatus;

    uint8 _SpeedLockThreshold;

};

/**
 * The get message of the property "SpeedLock"
 * Get Speed Lock value and Threshold from Diagnosis. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
 * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SpeedLockGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedLockGet ();

    /**
     * Copy constructor
     */
    inline  SpeedLockGet (const SpeedLockGet &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedLockGet (::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLock_);

    /**
     * Destructor
     */
    inline virtual  ~SpeedLockGet();

    /**
     * Assignment operator
     */
    inline SpeedLockGet& operator = (const SpeedLockGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedLockGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedLockGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedLockGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedLockGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SpeedLock"

    static const int kSpeedLock = 0;

    /**
     * Clears the field "SpeedLock".
     *
     * The field will be set to its default value. The hasSpeedLock()
     * method will return false.
     */
    inline void clearSpeedLock();

    /**
     * Checks whether the field "SpeedLock" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedLock()). Otherwise it will return false.
     */
    inline bool hasSpeedLock () const;

    /**
     * Returns the value of the member "SpeedLock".
     *
     * Speed Lock
     *
     * @return The value of the field "SpeedLock"
     */
    inline ::midw_diagnostics_fi_types::T_e16_SpeedLock getSpeedLock () const;

    /**
     * Sets the value of the member "SpeedLock".
     *
     * Speed Lock
     *
     * @param SpeedLock The value which will be set
     */
    inline void setSpeedLock (::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLock_);

    static const SpeedLockGet &getDefaultInstance();

private:

    inline void set_has_SpeedLock ();

    inline void clear_has_SpeedLock ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e16_SpeedLock _SpeedLock;

};

/**
 * The status message of the property "SpdLock"
 * Activate Speed Lock via HMI where FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
 * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SpdLockStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpdLockStatus ();

    /**
     * Copy constructor
     */
    inline  SpdLockStatus (const SpdLockStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SpdLockStatus (bool SpeedLockStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SpdLockStatus();

    /**
     * Assignment operator
     */
    inline SpdLockStatus& operator = (const SpdLockStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpdLockStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpdLockStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpdLockStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpdLockStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SpeedLockStatus"

    static const int kSpeedLockStatus = 0;

    /**
     * Clears the field "SpeedLockStatus".
     *
     * The field will be set to its default value. The hasSpeedLockStatus()
     * method will return false.
     */
    inline void clearSpeedLockStatus();

    /**
     * Checks whether the field "SpeedLockStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedLockStatus()). Otherwise it will return false.
     */
    inline bool hasSpeedLockStatus () const;

    /**
     * Returns the value of the member "SpeedLockStatus".
     *
     * Set to true if the Speed Lock is activated via HMI
     *
     * @return The value of the field "SpeedLockStatus"
     */
    inline bool getSpeedLockStatus () const;

    /**
     * Sets the value of the member "SpeedLockStatus".
     *
     * Set to true if the Speed Lock is activated via HMI
     *
     * @param SpeedLockStatus The value which will be set
     */
    inline void setSpeedLockStatus (bool SpeedLockStatus_);

    static const SpdLockStatus &getDefaultInstance();

private:

    inline void set_has_SpeedLockStatus ();

    inline void clear_has_SpeedLockStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _SpeedLockStatus;

};

/**
 * The set message of the property "SpdLock"
 * Activate Speed Lock via HMI where FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
 * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SpdLockSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpdLockSet ();

    /**
     * Copy constructor
     */
    inline  SpdLockSet (const SpdLockSet &rhs);

    /**
     * All fields constructor
     */
    inline  SpdLockSet (::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLock_);

    /**
     * Destructor
     */
    inline virtual  ~SpdLockSet();

    /**
     * Assignment operator
     */
    inline SpdLockSet& operator = (const SpdLockSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpdLockSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpdLockSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpdLockSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpdLockSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SpeedLock"

    static const int kSpeedLock = 0;

    /**
     * Clears the field "SpeedLock".
     *
     * The field will be set to its default value. The hasSpeedLock()
     * method will return false.
     */
    inline void clearSpeedLock();

    /**
     * Checks whether the field "SpeedLock" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedLock()). Otherwise it will return false.
     */
    inline bool hasSpeedLock () const;

    /**
     * Returns the value of the member "SpeedLock".
     *
     * Speed lock Req Data from HMI
     *
     * @return The value of the field "SpeedLock"
     */
    inline ::midw_diagnostics_fi_types::T_e16_SpeedLock getSpeedLock () const;

    /**
     * Sets the value of the member "SpeedLock".
     *
     * Speed lock Req Data from HMI
     *
     * @param SpeedLock The value which will be set
     */
    inline void setSpeedLock (::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLock_);

    static const SpdLockSet &getDefaultInstance();

private:

    inline void set_has_SpeedLock ();

    inline void clear_has_SpeedLock ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e16_SpeedLock _SpeedLock;

};

/**
 * The status message of the property "SetRVCSignal"
 * Set RVC Video Signal on or off. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETRVCSIGNAL, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SetRVCSignalStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRVCSignalStatus ();

    /**
     * Copy constructor
     */
    inline  SetRVCSignalStatus (const SetRVCSignalStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SetRVCSignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SignalStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SetRVCSignalStatus();

    /**
     * Assignment operator
     */
    inline SetRVCSignalStatus& operator = (const SetRVCSignalStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRVCSignalStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRVCSignalStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRVCSignalStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRVCSignalStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SignalStatus"

    static const int kSignalStatus = 0;

    /**
     * Clears the field "SignalStatus".
     *
     * The field will be set to its default value. The hasSignalStatus()
     * method will return false.
     */
    inline void clearSignalStatus();

    /**
     * Checks whether the field "SignalStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSignalStatus()). Otherwise it will return false.
     */
    inline bool hasSignalStatus () const;

    /**
     * Returns the value of the member "SignalStatus".
     *
     * Status of External Video signal to be set
     *
     * @return The value of the field "SignalStatus"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal getSignalStatus () const;

    /**
     * Sets the value of the member "SignalStatus".
     *
     * Status of External Video signal to be set
     *
     * @param SignalStatus The value which will be set
     */
    inline void setSignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SignalStatus_);

    static const SetRVCSignalStatus &getDefaultInstance();

private:

    inline void set_has_SignalStatus ();

    inline void clear_has_SignalStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal _SignalStatus;

};

/**
 * The set message of the property "SetRVCSignal"
 * Set RVC Video Signal on or off. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETRVCSIGNAL, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SetRVCSignalSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRVCSignalSet ();

    /**
     * Copy constructor
     */
    inline  SetRVCSignalSet (const SetRVCSignalSet &rhs);

    /**
     * All fields constructor
     */
    inline  SetRVCSignalSet (bool StatusChanged_);

    /**
     * Destructor
     */
    inline virtual  ~SetRVCSignalSet();

    /**
     * Assignment operator
     */
    inline SetRVCSignalSet& operator = (const SetRVCSignalSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRVCSignalSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRVCSignalSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRVCSignalSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRVCSignalSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusChanged"

    static const int kStatusChanged = 0;

    /**
     * Clears the field "StatusChanged".
     *
     * The field will be set to its default value. The hasStatusChanged()
     * method will return false.
     */
    inline void clearStatusChanged();

    /**
     * Checks whether the field "StatusChanged" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusChanged()). Otherwise it will return false.
     */
    inline bool hasStatusChanged () const;

    /**
     * Returns the value of the member "StatusChanged".
     *
     * Indicates status change successfully carried out
     *
     * @return The value of the field "StatusChanged"
     */
    inline bool getStatusChanged () const;

    /**
     * Sets the value of the member "StatusChanged".
     *
     * Indicates status change successfully carried out
     *
     * @param StatusChanged The value which will be set
     */
    inline void setStatusChanged (bool StatusChanged_);

    static const SetRVCSignalSet &getDefaultInstance();

private:

    inline void set_has_StatusChanged ();

    inline void clear_has_StatusChanged ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _StatusChanged;

};

/**
 * The get message of the property "SetRVCSignal"
 * Set RVC Video Signal on or off. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETRVCSIGNAL, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SetRVCSignalGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRVCSignalGet ();

    /**
     * Copy constructor
     */
    inline  SetRVCSignalGet (const SetRVCSignalGet &rhs);

    /**
     * All fields constructor
     */
    inline  SetRVCSignalGet (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SignalStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SetRVCSignalGet();

    /**
     * Assignment operator
     */
    inline SetRVCSignalGet& operator = (const SetRVCSignalGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRVCSignalGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRVCSignalGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRVCSignalGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRVCSignalGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SignalStatus"

    static const int kSignalStatus = 0;

    /**
     * Clears the field "SignalStatus".
     *
     * The field will be set to its default value. The hasSignalStatus()
     * method will return false.
     */
    inline void clearSignalStatus();

    /**
     * Checks whether the field "SignalStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSignalStatus()). Otherwise it will return false.
     */
    inline bool hasSignalStatus () const;

    /**
     * Returns the value of the member "SignalStatus".
     *
     * Status of External Video signal to be set
     *
     * @return The value of the field "SignalStatus"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal getSignalStatus () const;

    /**
     * Sets the value of the member "SignalStatus".
     *
     * Status of External Video signal to be set
     *
     * @param SignalStatus The value which will be set
     */
    inline void setSignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SignalStatus_);

    static const SetRVCSignalGet &getDefaultInstance();

private:

    inline void set_has_SignalStatus ();

    inline void clear_has_SignalStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal _SignalStatus;

};

/**
 * The status message of the property "RVCSignalStatus"
 * Interrogate status of RVC Video Signal. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RVCSIGNALSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class RVCSignalStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RVCSignalStatusStatus ();

    /**
     * Copy constructor
     */
    inline  RVCSignalStatusStatus (const RVCSignalStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RVCSignalStatusStatus (bool RequestStatus_);

    /**
     * Destructor
     */
    inline virtual  ~RVCSignalStatusStatus();

    /**
     * Assignment operator
     */
    inline RVCSignalStatusStatus& operator = (const RVCSignalStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RVCSignalStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RVCSignalStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RVCSignalStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RVCSignalStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RequestStatus"

    static const int kRequestStatus = 0;

    /**
     * Clears the field "RequestStatus".
     *
     * The field will be set to its default value. The hasRequestStatus()
     * method will return false.
     */
    inline void clearRequestStatus();

    /**
     * Checks whether the field "RequestStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestStatus()). Otherwise it will return false.
     */
    inline bool hasRequestStatus () const;

    /**
     * Returns the value of the member "RequestStatus".
     *
     * True indicates that the signal status should be "Set"
     *
     * @return The value of the field "RequestStatus"
     */
    inline bool getRequestStatus () const;

    /**
     * Sets the value of the member "RequestStatus".
     *
     * True indicates that the signal status should be "Set"
     *
     * @param RequestStatus The value which will be set
     */
    inline void setRequestStatus (bool RequestStatus_);

    static const RVCSignalStatusStatus &getDefaultInstance();

private:

    inline void set_has_RequestStatus ();

    inline void clear_has_RequestStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RequestStatus;

};

/**
 * The set message of the property "RVCSignalStatus"
 * Interrogate status of RVC Video Signal. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RVCSIGNALSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class RVCSignalStatusSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RVCSignalStatusSet ();

    /**
     * Copy constructor
     */
    inline  RVCSignalStatusSet (const RVCSignalStatusSet &rhs);

    /**
     * All fields constructor
     */
    inline  RVCSignalStatusSet (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SignalStatus_);

    /**
     * Destructor
     */
    inline virtual  ~RVCSignalStatusSet();

    /**
     * Assignment operator
     */
    inline RVCSignalStatusSet& operator = (const RVCSignalStatusSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RVCSignalStatusSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RVCSignalStatusSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RVCSignalStatusSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RVCSignalStatusSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SignalStatus"

    static const int kSignalStatus = 0;

    /**
     * Clears the field "SignalStatus".
     *
     * The field will be set to its default value. The hasSignalStatus()
     * method will return false.
     */
    inline void clearSignalStatus();

    /**
     * Checks whether the field "SignalStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSignalStatus()). Otherwise it will return false.
     */
    inline bool hasSignalStatus () const;

    /**
     * Returns the value of the member "SignalStatus".
     *
     * Status of External Video signal
     *
     * @return The value of the field "SignalStatus"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal getSignalStatus () const;

    /**
     * Sets the value of the member "SignalStatus".
     *
     * Status of External Video signal
     *
     * @param SignalStatus The value which will be set
     */
    inline void setSignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SignalStatus_);

    static const RVCSignalStatusSet &getDefaultInstance();

private:

    inline void set_has_SignalStatus ();

    inline void clear_has_SignalStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal _SignalStatus;

};

/**
 * The status message of the property "KdsEntry"
 * This property allowed to read a KDS entry.
 * FUNCID = 0x60, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class KdsEntryStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KdsEntryStatus ();

    /**
     * Copy constructor
     */
    inline  KdsEntryStatus (const KdsEntryStatus &rhs);

    /**
     * All fields constructor
     */
    inline  KdsEntryStatus (uint32 KdsEntry_, const ::midw_diagnostics_fi_types::T_KDSItemList& KdsDataList_);

    /**
     * Destructor
     */
    inline virtual  ~KdsEntryStatus();

    /**
     * Assignment operator
     */
    inline KdsEntryStatus& operator = (const KdsEntryStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KdsEntryStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KdsEntryStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KdsEntryStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KdsEntryStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "KdsEntry"

    static const int kKdsEntry = 0;

    /**
     * Clears the field "KdsEntry".
     *
     * The field will be set to its default value. The hasKdsEntry()
     * method will return false.
     */
    inline void clearKdsEntry();

    /**
     * Checks whether the field "KdsEntry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKdsEntry()). Otherwise it will return false.
     */
    inline bool hasKdsEntry () const;

    /**
     * Returns the value of the member "KdsEntry".
     *
     * KDS entry which is send.
     *
     * @return The value of the field "KdsEntry"
     */
    inline uint32 getKdsEntry () const;

    /**
     * Sets the value of the member "KdsEntry".
     *
     * KDS entry which is send.
     *
     * @param KdsEntry The value which will be set
     */
    inline void setKdsEntry (uint32 KdsEntry_);

    // API of field "KdsDataList"

    static const int kKdsDataList = 1;

    /**
     * Clears the field "KdsDataList".
     *
     * The field will be set to its default value. The hasKdsDataList()
     * method will return false.
     */
    inline void clearKdsDataList();

    /**
     * Checks whether the field "KdsDataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKdsDataList()). Otherwise it will return false.
     */
    inline bool hasKdsDataList () const;

    /**
     * Returns the value of the member "KdsDataList".
     *
     * Data of KDS entry.
     *
     * @return The value of the field "KdsDataList"
     */
    inline const ::midw_diagnostics_fi_types::T_KDSItemList& getKdsDataList () const;

    /**
     * Retrieves the value of the field "KdsDataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "KdsDataList".
     */
    inline ::midw_diagnostics_fi_types::T_KDSItemList& getKdsDataListMutable ();

    /**
     * Sets the value of the member "KdsDataList".
     *
     * Data of KDS entry.
     *
     * @param KdsDataList The value which will be set
     */
    inline void setKdsDataList (const ::midw_diagnostics_fi_types::T_KDSItemList& KdsDataList_);

    static const KdsEntryStatus &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_KdsEntry ();

    inline void clear_has_KdsEntry ();

    inline void set_has_KdsDataList ();

    inline void clear_has_KdsDataList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _KdsEntry;

    ::midw_diagnostics_fi_types::T_KDSItemList _KdsDataList;

};

/**
 * The set message of the property "KdsEntry"
 * This property allowed to read a KDS entry.
 * FUNCID = 0x60, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class KdsEntrySet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KdsEntrySet ();

    /**
     * Copy constructor
     */
    inline  KdsEntrySet (const KdsEntrySet &rhs);

    /**
     * All fields constructor
     */
    inline  KdsEntrySet (uint32 KdsEntry_, const ::midw_diagnostics_fi_types::T_KDSItemList& KdsDataList_);

    /**
     * Destructor
     */
    inline virtual  ~KdsEntrySet();

    /**
     * Assignment operator
     */
    inline KdsEntrySet& operator = (const KdsEntrySet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KdsEntrySet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KdsEntrySet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KdsEntrySet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KdsEntrySet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "KdsEntry"

    static const int kKdsEntry = 0;

    /**
     * Clears the field "KdsEntry".
     *
     * The field will be set to its default value. The hasKdsEntry()
     * method will return false.
     */
    inline void clearKdsEntry();

    /**
     * Checks whether the field "KdsEntry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKdsEntry()). Otherwise it will return false.
     */
    inline bool hasKdsEntry () const;

    /**
     * Returns the value of the member "KdsEntry".
     *
     * KDS entry which shall be written (diagnosis will check if the sending application is allowed to write the given KDS key).
     *
     * @return The value of the field "KdsEntry"
     */
    inline uint32 getKdsEntry () const;

    /**
     * Sets the value of the member "KdsEntry".
     *
     * KDS entry which shall be written (diagnosis will check if the sending application is allowed to write the given KDS key).
     *
     * @param KdsEntry The value which will be set
     */
    inline void setKdsEntry (uint32 KdsEntry_);

    // API of field "KdsDataList"

    static const int kKdsDataList = 1;

    /**
     * Clears the field "KdsDataList".
     *
     * The field will be set to its default value. The hasKdsDataList()
     * method will return false.
     */
    inline void clearKdsDataList();

    /**
     * Checks whether the field "KdsDataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKdsDataList()). Otherwise it will return false.
     */
    inline bool hasKdsDataList () const;

    /**
     * Returns the value of the member "KdsDataList".
     *
     * Data of KDS entry.
     *
     * @return The value of the field "KdsDataList"
     */
    inline const ::midw_diagnostics_fi_types::T_KDSItemList& getKdsDataList () const;

    /**
     * Retrieves the value of the field "KdsDataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "KdsDataList".
     */
    inline ::midw_diagnostics_fi_types::T_KDSItemList& getKdsDataListMutable ();

    /**
     * Sets the value of the member "KdsDataList".
     *
     * Data of KDS entry.
     *
     * @param KdsDataList The value which will be set
     */
    inline void setKdsDataList (const ::midw_diagnostics_fi_types::T_KDSItemList& KdsDataList_);

    static const KdsEntrySet &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_KdsEntry ();

    inline void clear_has_KdsEntry ();

    inline void set_has_KdsDataList ();

    inline void clear_has_KdsDataList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _KdsEntry;

    ::midw_diagnostics_fi_types::T_KDSItemList _KdsDataList;

};

/**
 * The get message of the property "KdsEntry"
 * This property allowed to read a KDS entry.
 * FUNCID = 0x60, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class KdsEntryGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KdsEntryGet ();

    /**
     * Copy constructor
     */
    inline  KdsEntryGet (const KdsEntryGet &rhs);

    /**
     * All fields constructor
     */
    inline  KdsEntryGet (uint32 KdsEntry_);

    /**
     * Destructor
     */
    inline virtual  ~KdsEntryGet();

    /**
     * Assignment operator
     */
    inline KdsEntryGet& operator = (const KdsEntryGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KdsEntryGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KdsEntryGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KdsEntryGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KdsEntryGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "KdsEntry"

    static const int kKdsEntry = 0;

    /**
     * Clears the field "KdsEntry".
     *
     * The field will be set to its default value. The hasKdsEntry()
     * method will return false.
     */
    inline void clearKdsEntry();

    /**
     * Checks whether the field "KdsEntry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKdsEntry()). Otherwise it will return false.
     */
    inline bool hasKdsEntry () const;

    /**
     * Returns the value of the member "KdsEntry".
     *
     * KDS entry which has to be read.
     *
     * @return The value of the field "KdsEntry"
     */
    inline uint32 getKdsEntry () const;

    /**
     * Sets the value of the member "KdsEntry".
     *
     * KDS entry which has to be read.
     *
     * @param KdsEntry The value which will be set
     */
    inline void setKdsEntry (uint32 KdsEntry_);

    static const KdsEntryGet &getDefaultInstance();

private:

    inline void set_has_KdsEntry ();

    inline void clear_has_KdsEntry ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _KdsEntry;

};

/**
 * The upreg message of the property "KdsEntry"
 * This property allowed to read a KDS entry.
 * FUNCID = 0x60, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class KdsEntryUpReg  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KdsEntryUpReg ();

    /**
     * Copy constructor
     */
    inline  KdsEntryUpReg (const KdsEntryUpReg &rhs);

    /**
     * All fields constructor
     */
    inline  KdsEntryUpReg (uint32 KdsEntry_);

    /**
     * Destructor
     */
    inline virtual  ~KdsEntryUpReg();

    /**
     * Assignment operator
     */
    inline KdsEntryUpReg& operator = (const KdsEntryUpReg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KdsEntryUpReg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KdsEntryUpReg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KdsEntryUpReg& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KdsEntryUpReg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "KdsEntry"

    static const int kKdsEntry = 0;

    /**
     * Clears the field "KdsEntry".
     *
     * The field will be set to its default value. The hasKdsEntry()
     * method will return false.
     */
    inline void clearKdsEntry();

    /**
     * Checks whether the field "KdsEntry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKdsEntry()). Otherwise it will return false.
     */
    inline bool hasKdsEntry () const;

    /**
     * Returns the value of the member "KdsEntry".
     *
     * KDS entry for which has to be registered.
     *
     * @return The value of the field "KdsEntry"
     */
    inline uint32 getKdsEntry () const;

    /**
     * Sets the value of the member "KdsEntry".
     *
     * KDS entry for which has to be registered.
     *
     * @param KdsEntry The value which will be set
     */
    inline void setKdsEntry (uint32 KdsEntry_);

    static const KdsEntryUpReg &getDefaultInstance();

private:

    inline void set_has_KdsEntry ();

    inline void clear_has_KdsEntry ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _KdsEntry;

};

/**
 * The relUpReg message of the property "KdsEntry"
 * This property allowed to read a KDS entry.
 * FUNCID = 0x60, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class KdsEntryRelUpReg  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KdsEntryRelUpReg ();

    /**
     * Copy constructor
     */
    inline  KdsEntryRelUpReg (const KdsEntryRelUpReg &rhs);

    /**
     * All fields constructor
     */
    inline  KdsEntryRelUpReg (uint32 KdsEntry_);

    /**
     * Destructor
     */
    inline virtual  ~KdsEntryRelUpReg();

    /**
     * Assignment operator
     */
    inline KdsEntryRelUpReg& operator = (const KdsEntryRelUpReg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KdsEntryRelUpReg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KdsEntryRelUpReg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KdsEntryRelUpReg& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KdsEntryRelUpReg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "KdsEntry"

    static const int kKdsEntry = 0;

    /**
     * Clears the field "KdsEntry".
     *
     * The field will be set to its default value. The hasKdsEntry()
     * method will return false.
     */
    inline void clearKdsEntry();

    /**
     * Checks whether the field "KdsEntry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKdsEntry()). Otherwise it will return false.
     */
    inline bool hasKdsEntry () const;

    /**
     * Returns the value of the member "KdsEntry".
     *
     * KDS entry for which has to be unregistered.
     *
     * @return The value of the field "KdsEntry"
     */
    inline uint32 getKdsEntry () const;

    /**
     * Sets the value of the member "KdsEntry".
     *
     * KDS entry for which has to be unregistered.
     *
     * @param KdsEntry The value which will be set
     */
    inline void setKdsEntry (uint32 KdsEntry_);

    static const KdsEntryRelUpReg &getDefaultInstance();

private:

    inline void set_has_KdsEntry ();

    inline void clear_has_KdsEntry ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _KdsEntry;

};

/**
 * The status message of the property "DiagConfigItem"
 * This property allowed to read diagnosis internal configuration items. Thereby it doesn't matter if they are in KDS, Registry, RAM or GPIO.
 * FUNCID = 0x61, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class DiagConfigItemStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagConfigItemStatus ();

    /**
     * Copy constructor
     */
    inline  DiagConfigItemStatus (const DiagConfigItemStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiagConfigItemStatus (uint32 ConfigItem_, bool ConfigItemValid_, const ::midw_diagnostics_fi_types::T_ConfigItemList& ConfigItemContent_);

    /**
     * Destructor
     */
    inline virtual  ~DiagConfigItemStatus();

    /**
     * Assignment operator
     */
    inline DiagConfigItemStatus& operator = (const DiagConfigItemStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagConfigItemStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagConfigItemStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagConfigItemStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagConfigItemStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConfigItem"

    static const int kConfigItem = 0;

    /**
     * Clears the field "ConfigItem".
     *
     * The field will be set to its default value. The hasConfigItem()
     * method will return false.
     */
    inline void clearConfigItem();

    /**
     * Checks whether the field "ConfigItem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigItem()). Otherwise it will return false.
     */
    inline bool hasConfigItem () const;

    /**
     * Returns the value of the member "ConfigItem".
     *
     * Changed Config Item.
     *
     * @return The value of the field "ConfigItem"
     */
    inline uint32 getConfigItem () const;

    /**
     * Sets the value of the member "ConfigItem".
     *
     * Changed Config Item.
     *
     * @param ConfigItem The value which will be set
     */
    inline void setConfigItem (uint32 ConfigItem_);

    // API of field "ConfigItemValid"

    static const int kConfigItemValid = 1;

    /**
     * Clears the field "ConfigItemValid".
     *
     * The field will be set to its default value. The hasConfigItemValid()
     * method will return false.
     */
    inline void clearConfigItemValid();

    /**
     * Checks whether the field "ConfigItemValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigItemValid()). Otherwise it will return false.
     */
    inline bool hasConfigItemValid () const;

    /**
     * Returns the value of the member "ConfigItemValid".
     *
     * Validity of Config Item.
     *
     * @return The value of the field "ConfigItemValid"
     */
    inline bool getConfigItemValid () const;

    /**
     * Sets the value of the member "ConfigItemValid".
     *
     * Validity of Config Item.
     *
     * @param ConfigItemValid The value which will be set
     */
    inline void setConfigItemValid (bool ConfigItemValid_);

    // API of field "ConfigItemContent"

    static const int kConfigItemContent = 2;

    /**
     * Clears the field "ConfigItemContent".
     *
     * The field will be set to its default value. The hasConfigItemContent()
     * method will return false.
     */
    inline void clearConfigItemContent();

    /**
     * Checks whether the field "ConfigItemContent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigItemContent()). Otherwise it will return false.
     */
    inline bool hasConfigItemContent () const;

    /**
     * Returns the value of the member "ConfigItemContent".
     *
     * New data of ConfigItem entry.
     *
     * @return The value of the field "ConfigItemContent"
     */
    inline const ::midw_diagnostics_fi_types::T_ConfigItemList& getConfigItemContent () const;

    /**
     * Retrieves the value of the field "ConfigItemContent" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ConfigItemContent".
     */
    inline ::midw_diagnostics_fi_types::T_ConfigItemList& getConfigItemContentMutable ();

    /**
     * Sets the value of the member "ConfigItemContent".
     *
     * New data of ConfigItem entry.
     *
     * @param ConfigItemContent The value which will be set
     */
    inline void setConfigItemContent (const ::midw_diagnostics_fi_types::T_ConfigItemList& ConfigItemContent_);

    static const DiagConfigItemStatus &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_ConfigItem ();

    inline void clear_has_ConfigItem ();

    inline void set_has_ConfigItemValid ();

    inline void clear_has_ConfigItemValid ();

    inline void set_has_ConfigItemContent ();

    inline void clear_has_ConfigItemContent ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _ConfigItem;

    bool _ConfigItemValid;

    ::midw_diagnostics_fi_types::T_ConfigItemList _ConfigItemContent;

};

/**
 * The set message of the property "DiagConfigItem"
 * This property allowed to read diagnosis internal configuration items. Thereby it doesn't matter if they are in KDS, Registry, RAM or GPIO.
 * FUNCID = 0x61, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class DiagConfigItemSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagConfigItemSet ();

    /**
     * Copy constructor
     */
    inline  DiagConfigItemSet (const DiagConfigItemSet &rhs);

    /**
     * All fields constructor
     */
    inline  DiagConfigItemSet (uint32 ConfigItem_, const ::midw_diagnostics_fi_types::T_ConfigItemList& ConfigItemContent_);

    /**
     * Destructor
     */
    inline virtual  ~DiagConfigItemSet();

    /**
     * Assignment operator
     */
    inline DiagConfigItemSet& operator = (const DiagConfigItemSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagConfigItemSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagConfigItemSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagConfigItemSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagConfigItemSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConfigItem"

    static const int kConfigItem = 0;

    /**
     * Clears the field "ConfigItem".
     *
     * The field will be set to its default value. The hasConfigItem()
     * method will return false.
     */
    inline void clearConfigItem();

    /**
     * Checks whether the field "ConfigItem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigItem()). Otherwise it will return false.
     */
    inline bool hasConfigItem () const;

    /**
     * Returns the value of the member "ConfigItem".
     *
     * Changed Config Item.
     *
     * @return The value of the field "ConfigItem"
     */
    inline uint32 getConfigItem () const;

    /**
     * Sets the value of the member "ConfigItem".
     *
     * Changed Config Item.
     *
     * @param ConfigItem The value which will be set
     */
    inline void setConfigItem (uint32 ConfigItem_);

    // API of field "ConfigItemContent"

    static const int kConfigItemContent = 1;

    /**
     * Clears the field "ConfigItemContent".
     *
     * The field will be set to its default value. The hasConfigItemContent()
     * method will return false.
     */
    inline void clearConfigItemContent();

    /**
     * Checks whether the field "ConfigItemContent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigItemContent()). Otherwise it will return false.
     */
    inline bool hasConfigItemContent () const;

    /**
     * Returns the value of the member "ConfigItemContent".
     *
     * New data of ConfigItem entry.
     *
     * @return The value of the field "ConfigItemContent"
     */
    inline const ::midw_diagnostics_fi_types::T_ConfigItemList& getConfigItemContent () const;

    /**
     * Retrieves the value of the field "ConfigItemContent" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ConfigItemContent".
     */
    inline ::midw_diagnostics_fi_types::T_ConfigItemList& getConfigItemContentMutable ();

    /**
     * Sets the value of the member "ConfigItemContent".
     *
     * New data of ConfigItem entry.
     *
     * @param ConfigItemContent The value which will be set
     */
    inline void setConfigItemContent (const ::midw_diagnostics_fi_types::T_ConfigItemList& ConfigItemContent_);

    static const DiagConfigItemSet &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_ConfigItem ();

    inline void clear_has_ConfigItem ();

    inline void set_has_ConfigItemContent ();

    inline void clear_has_ConfigItemContent ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ConfigItem;

    ::midw_diagnostics_fi_types::T_ConfigItemList _ConfigItemContent;

};

/**
 * The get message of the property "DiagConfigItem"
 * This property allowed to read diagnosis internal configuration items. Thereby it doesn't matter if they are in KDS, Registry, RAM or GPIO.
 * FUNCID = 0x61, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class DiagConfigItemGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagConfigItemGet ();

    /**
     * Copy constructor
     */
    inline  DiagConfigItemGet (const DiagConfigItemGet &rhs);

    /**
     * All fields constructor
     */
    inline  DiagConfigItemGet (uint32 ConfigItem_);

    /**
     * Destructor
     */
    inline virtual  ~DiagConfigItemGet();

    /**
     * Assignment operator
     */
    inline DiagConfigItemGet& operator = (const DiagConfigItemGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagConfigItemGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagConfigItemGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagConfigItemGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagConfigItemGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConfigItem"

    static const int kConfigItem = 0;

    /**
     * Clears the field "ConfigItem".
     *
     * The field will be set to its default value. The hasConfigItem()
     * method will return false.
     */
    inline void clearConfigItem();

    /**
     * Checks whether the field "ConfigItem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigItem()). Otherwise it will return false.
     */
    inline bool hasConfigItem () const;

    /**
     * Returns the value of the member "ConfigItem".
     *
     * Entry which has to be read.
     *
     * @return The value of the field "ConfigItem"
     */
    inline uint32 getConfigItem () const;

    /**
     * Sets the value of the member "ConfigItem".
     *
     * Entry which has to be read.
     *
     * @param ConfigItem The value which will be set
     */
    inline void setConfigItem (uint32 ConfigItem_);

    static const DiagConfigItemGet &getDefaultInstance();

private:

    inline void set_has_ConfigItem ();

    inline void clear_has_ConfigItem ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ConfigItem;

};

/**
 * The upreg message of the property "DiagConfigItem"
 * This property allowed to read diagnosis internal configuration items. Thereby it doesn't matter if they are in KDS, Registry, RAM or GPIO.
 * FUNCID = 0x61, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class DiagConfigItemUpReg  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagConfigItemUpReg ();

    /**
     * Copy constructor
     */
    inline  DiagConfigItemUpReg (const DiagConfigItemUpReg &rhs);

    /**
     * All fields constructor
     */
    inline  DiagConfigItemUpReg (uint32 ConfigItem_);

    /**
     * Destructor
     */
    inline virtual  ~DiagConfigItemUpReg();

    /**
     * Assignment operator
     */
    inline DiagConfigItemUpReg& operator = (const DiagConfigItemUpReg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagConfigItemUpReg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagConfigItemUpReg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagConfigItemUpReg& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagConfigItemUpReg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConfigItem"

    static const int kConfigItem = 0;

    /**
     * Clears the field "ConfigItem".
     *
     * The field will be set to its default value. The hasConfigItem()
     * method will return false.
     */
    inline void clearConfigItem();

    /**
     * Checks whether the field "ConfigItem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigItem()). Otherwise it will return false.
     */
    inline bool hasConfigItem () const;

    /**
     * Returns the value of the member "ConfigItem".
     *
     * Entry for which has to be registered.
     *
     * @return The value of the field "ConfigItem"
     */
    inline uint32 getConfigItem () const;

    /**
     * Sets the value of the member "ConfigItem".
     *
     * Entry for which has to be registered.
     *
     * @param ConfigItem The value which will be set
     */
    inline void setConfigItem (uint32 ConfigItem_);

    static const DiagConfigItemUpReg &getDefaultInstance();

private:

    inline void set_has_ConfigItem ();

    inline void clear_has_ConfigItem ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ConfigItem;

};

/**
 * The relUpReg message of the property "DiagConfigItem"
 * This property allowed to read diagnosis internal configuration items. Thereby it doesn't matter if they are in KDS, Registry, RAM or GPIO.
 * FUNCID = 0x61, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class DiagConfigItemRelUpReg  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagConfigItemRelUpReg ();

    /**
     * Copy constructor
     */
    inline  DiagConfigItemRelUpReg (const DiagConfigItemRelUpReg &rhs);

    /**
     * All fields constructor
     */
    inline  DiagConfigItemRelUpReg (uint32 ConfigItem_);

    /**
     * Destructor
     */
    inline virtual  ~DiagConfigItemRelUpReg();

    /**
     * Assignment operator
     */
    inline DiagConfigItemRelUpReg& operator = (const DiagConfigItemRelUpReg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagConfigItemRelUpReg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagConfigItemRelUpReg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagConfigItemRelUpReg& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagConfigItemRelUpReg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConfigItem"

    static const int kConfigItem = 0;

    /**
     * Clears the field "ConfigItem".
     *
     * The field will be set to its default value. The hasConfigItem()
     * method will return false.
     */
    inline void clearConfigItem();

    /**
     * Checks whether the field "ConfigItem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigItem()). Otherwise it will return false.
     */
    inline bool hasConfigItem () const;

    /**
     * Returns the value of the member "ConfigItem".
     *
     * Entry for which has to be registered.
     *
     * @return The value of the field "ConfigItem"
     */
    inline uint32 getConfigItem () const;

    /**
     * Sets the value of the member "ConfigItem".
     *
     * Entry for which has to be registered.
     *
     * @param ConfigItem The value which will be set
     */
    inline void setConfigItem (uint32 ConfigItem_);

    static const DiagConfigItemRelUpReg &getDefaultInstance();

private:

    inline void set_has_ConfigItem ();

    inline void clear_has_ConfigItem ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ConfigItem;

};

/**
 * The start message of the method "ReadDiagLog"
 * This method provides functionality for the HMI to read the DTC and ITC from VD_DiagLog. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_READDIAGLOG, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class ReadDiagLogStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReadDiagLogStart ();

    /**
     * Copy constructor
     */
    inline  ReadDiagLogStart (const ReadDiagLogStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReadDiagLogStart (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_);

    /**
     * Destructor
     */
    inline virtual  ~ReadDiagLogStart();

    /**
     * Assignment operator
     */
    inline ReadDiagLogStart& operator = (const ReadDiagLogStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadDiagLogStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadDiagLogStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadDiagLogStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadDiagLogStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TroubleCodes"

    static const int kTroubleCodes = 0;

    /**
     * Clears the field "TroubleCodes".
     *
     * The field will be set to its default value. The hasTroubleCodes()
     * method will return false.
     */
    inline void clearTroubleCodes();

    /**
     * Checks whether the field "TroubleCodes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTroubleCodes()). Otherwise it will return false.
     */
    inline bool hasTroubleCodes () const;

    /**
     * Returns the value of the member "TroubleCodes".
     *
     * Select the type of Trouble Codes to read (DTC or ITC).
     *
     * @return The value of the field "TroubleCodes"
     */
    inline ::midw_diagnostics_fi_types::T_e8_TroubleCodeType getTroubleCodes () const;

    /**
     * Sets the value of the member "TroubleCodes".
     *
     * Select the type of Trouble Codes to read (DTC or ITC).
     *
     * @param TroubleCodes The value which will be set
     */
    inline void setTroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_);

    static const ReadDiagLogStart &getDefaultInstance();

private:

    inline void set_has_TroubleCodes ();

    inline void clear_has_TroubleCodes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_TroubleCodeType _TroubleCodes;

};

/**
 * The result message of the method "ReadDiagLog"
 * This method provides functionality for the HMI to read the DTC and ITC from VD_DiagLog. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_READDIAGLOG, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class ReadDiagLogResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReadDiagLogResult ();

    /**
     * Copy constructor
     */
    inline  ReadDiagLogResult (const ReadDiagLogResult &rhs);

    /**
     * All fields constructor
     */
    inline  ReadDiagLogResult (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_, const ::midw_diagnostics_fi_types::T_TroubleCodeList& TroubleCodeList_);

    /**
     * Destructor
     */
    inline virtual  ~ReadDiagLogResult();

    /**
     * Assignment operator
     */
    inline ReadDiagLogResult& operator = (const ReadDiagLogResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadDiagLogResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadDiagLogResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadDiagLogResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadDiagLogResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TroubleCodes"

    static const int kTroubleCodes = 0;

    /**
     * Clears the field "TroubleCodes".
     *
     * The field will be set to its default value. The hasTroubleCodes()
     * method will return false.
     */
    inline void clearTroubleCodes();

    /**
     * Checks whether the field "TroubleCodes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTroubleCodes()). Otherwise it will return false.
     */
    inline bool hasTroubleCodes () const;

    /**
     * Returns the value of the member "TroubleCodes".
     *
     * Trouble Codes read (DTC or ITC).
     *
     * @return The value of the field "TroubleCodes"
     */
    inline ::midw_diagnostics_fi_types::T_e8_TroubleCodeType getTroubleCodes () const;

    /**
     * Sets the value of the member "TroubleCodes".
     *
     * Trouble Codes read (DTC or ITC).
     *
     * @param TroubleCodes The value which will be set
     */
    inline void setTroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_);

    // API of field "TroubleCodeList"

    static const int kTroubleCodeList = 1;

    /**
     * Clears the field "TroubleCodeList".
     *
     * The field will be set to its default value. The hasTroubleCodeList()
     * method will return false.
     */
    inline void clearTroubleCodeList();

    /**
     * Checks whether the field "TroubleCodeList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTroubleCodeList()). Otherwise it will return false.
     */
    inline bool hasTroubleCodeList () const;

    /**
     * Returns the value of the member "TroubleCodeList".
     *
     * Contains list of DTC or ITC.
     *
     * @return The value of the field "TroubleCodeList"
     */
    inline const ::midw_diagnostics_fi_types::T_TroubleCodeList& getTroubleCodeList () const;

    /**
     * Retrieves the value of the field "TroubleCodeList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TroubleCodeList".
     */
    inline ::midw_diagnostics_fi_types::T_TroubleCodeList& getTroubleCodeListMutable ();

    /**
     * Sets the value of the member "TroubleCodeList".
     *
     * Contains list of DTC or ITC.
     *
     * @param TroubleCodeList The value which will be set
     */
    inline void setTroubleCodeList (const ::midw_diagnostics_fi_types::T_TroubleCodeList& TroubleCodeList_);

    static const ReadDiagLogResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diagnostics_fi_types::T_TroubleCode >& getT_TroubleCodeList_DefaultInstance ();

    inline void set_has_TroubleCodes ();

    inline void clear_has_TroubleCodes ();

    inline void set_has_TroubleCodeList ();

    inline void clear_has_TroubleCodeList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_TroubleCodeType _TroubleCodes;

    ::midw_diagnostics_fi_types::T_TroubleCodeList _TroubleCodeList;

};

/**
 * The start message of the method "ClearDiagLog"
 * This method provides functionality for the HMI to clear all DTCs in VD_DiagLog. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_CLEARDIAGLOG, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class ClearDiagLogStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearDiagLogStart ();

    /**
     * Copy constructor
     */
    inline  ClearDiagLogStart (const ClearDiagLogStart &rhs);

    /**
     * All fields constructor
     */
    inline  ClearDiagLogStart (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_);

    /**
     * Destructor
     */
    inline virtual  ~ClearDiagLogStart();

    /**
     * Assignment operator
     */
    inline ClearDiagLogStart& operator = (const ClearDiagLogStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearDiagLogStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearDiagLogStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearDiagLogStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearDiagLogStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TroubleCodes"

    static const int kTroubleCodes = 0;

    /**
     * Clears the field "TroubleCodes".
     *
     * The field will be set to its default value. The hasTroubleCodes()
     * method will return false.
     */
    inline void clearTroubleCodes();

    /**
     * Checks whether the field "TroubleCodes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTroubleCodes()). Otherwise it will return false.
     */
    inline bool hasTroubleCodes () const;

    /**
     * Returns the value of the member "TroubleCodes".
     *
     * Select the type of Trouble Codes to clear.  DTC (customer only) or ITC (customer and production).
     *
     * @return The value of the field "TroubleCodes"
     */
    inline ::midw_diagnostics_fi_types::T_e8_TroubleCodeType getTroubleCodes () const;

    /**
     * Sets the value of the member "TroubleCodes".
     *
     * Select the type of Trouble Codes to clear.  DTC (customer only) or ITC (customer and production).
     *
     * @param TroubleCodes The value which will be set
     */
    inline void setTroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_);

    static const ClearDiagLogStart &getDefaultInstance();

private:

    inline void set_has_TroubleCodes ();

    inline void clear_has_TroubleCodes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_TroubleCodeType _TroubleCodes;

};

/**
 * The result message of the method "ClearDiagLog"
 * This method provides functionality for the HMI to clear all DTCs in VD_DiagLog. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_CLEARDIAGLOG, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class ClearDiagLogResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearDiagLogResult ();

    /**
     * Copy constructor
     */
    inline  ClearDiagLogResult (const ClearDiagLogResult &rhs);

    /**
     * All fields constructor
     */
    inline  ClearDiagLogResult (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_);

    /**
     * Destructor
     */
    inline virtual  ~ClearDiagLogResult();

    /**
     * Assignment operator
     */
    inline ClearDiagLogResult& operator = (const ClearDiagLogResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearDiagLogResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearDiagLogResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearDiagLogResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearDiagLogResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TroubleCodes"

    static const int kTroubleCodes = 0;

    /**
     * Clears the field "TroubleCodes".
     *
     * The field will be set to its default value. The hasTroubleCodes()
     * method will return false.
     */
    inline void clearTroubleCodes();

    /**
     * Checks whether the field "TroubleCodes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTroubleCodes()). Otherwise it will return false.
     */
    inline bool hasTroubleCodes () const;

    /**
     * Returns the value of the member "TroubleCodes".
     *
     * Trouble Codes cleared  DTC (customer only) or ITC (customer and production).
     *
     * @return The value of the field "TroubleCodes"
     */
    inline ::midw_diagnostics_fi_types::T_e8_TroubleCodeType getTroubleCodes () const;

    /**
     * Sets the value of the member "TroubleCodes".
     *
     * Trouble Codes cleared  DTC (customer only) or ITC (customer and production).
     *
     * @param TroubleCodes The value which will be set
     */
    inline void setTroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_);

    static const ClearDiagLogResult &getDefaultInstance();

private:

    inline void set_has_TroubleCodes ();

    inline void clear_has_TroubleCodes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_TroubleCodeType _TroubleCodes;

};

/**
 * The start message of the method "StartDiagnosticTest"
 * The "Start Test" provides functionality to start the defined test routines. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STARTDIAGNOSTICTEST, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class StartDiagnosticTestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartDiagnosticTestStart ();

    /**
     * Copy constructor
     */
    inline  StartDiagnosticTestStart (const StartDiagnosticTestStart &rhs);

    /**
     * All fields constructor
     */
    inline  StartDiagnosticTestStart (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_);

    /**
     * Destructor
     */
    inline virtual  ~StartDiagnosticTestStart();

    /**
     * Assignment operator
     */
    inline StartDiagnosticTestStart& operator = (const StartDiagnosticTestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartDiagnosticTestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartDiagnosticTestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartDiagnosticTestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartDiagnosticTestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TestRoutine"

    static const int kTestRoutine = 0;

    /**
     * Clears the field "TestRoutine".
     *
     * The field will be set to its default value. The hasTestRoutine()
     * method will return false.
     */
    inline void clearTestRoutine();

    /**
     * Checks whether the field "TestRoutine" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestRoutine()). Otherwise it will return false.
     */
    inline bool hasTestRoutine () const;

    /**
     * Returns the value of the member "TestRoutine".
     *
     * Select the test  to run.
     *
     * @return The value of the field "TestRoutine"
     */
    inline ::midw_diagnostics_fi_types::T_e8_TestRoutines getTestRoutine () const;

    /**
     * Sets the value of the member "TestRoutine".
     *
     * Select the test  to run.
     *
     * @param TestRoutine The value which will be set
     */
    inline void setTestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_);

    static const StartDiagnosticTestStart &getDefaultInstance();

private:

    inline void set_has_TestRoutine ();

    inline void clear_has_TestRoutine ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_TestRoutines _TestRoutine;

};

/**
 * The result message of the method "StartDiagnosticTest"
 * The "Start Test" provides functionality to start the defined test routines. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STARTDIAGNOSTICTEST, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class StartDiagnosticTestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartDiagnosticTestResult ();

    /**
     * Copy constructor
     */
    inline  StartDiagnosticTestResult (const StartDiagnosticTestResult &rhs);

    /**
     * All fields constructor
     */
    inline  StartDiagnosticTestResult (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_, bool Success_);

    /**
     * Destructor
     */
    inline virtual  ~StartDiagnosticTestResult();

    /**
     * Assignment operator
     */
    inline StartDiagnosticTestResult& operator = (const StartDiagnosticTestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartDiagnosticTestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartDiagnosticTestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartDiagnosticTestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartDiagnosticTestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TestRoutine"

    static const int kTestRoutine = 0;

    /**
     * Clears the field "TestRoutine".
     *
     * The field will be set to its default value. The hasTestRoutine()
     * method will return false.
     */
    inline void clearTestRoutine();

    /**
     * Checks whether the field "TestRoutine" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestRoutine()). Otherwise it will return false.
     */
    inline bool hasTestRoutine () const;

    /**
     * Returns the value of the member "TestRoutine".
     *
     * Last test run.
     *
     * @return The value of the field "TestRoutine"
     */
    inline ::midw_diagnostics_fi_types::T_e8_TestRoutines getTestRoutine () const;

    /**
     * Sets the value of the member "TestRoutine".
     *
     * Last test run.
     *
     * @param TestRoutine The value which will be set
     */
    inline void setTestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_);

    // API of field "Success"

    static const int kSuccess = 1;

    /**
     * Clears the field "Success".
     *
     * The field will be set to its default value. The hasSuccess()
     * method will return false.
     */
    inline void clearSuccess();

    /**
     * Checks whether the field "Success" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuccess()). Otherwise it will return false.
     */
    inline bool hasSuccess () const;

    /**
     * Returns the value of the member "Success".
     *
     * Result of last test.
     *
     * @return The value of the field "Success"
     */
    inline bool getSuccess () const;

    /**
     * Sets the value of the member "Success".
     *
     * Result of last test.
     *
     * @param Success The value which will be set
     */
    inline void setSuccess (bool Success_);

    static const StartDiagnosticTestResult &getDefaultInstance();

private:

    inline void set_has_TestRoutine ();

    inline void clear_has_TestRoutine ();

    inline void set_has_Success ();

    inline void clear_has_Success ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_TestRoutines _TestRoutine;

    bool _Success;

};

/**
 * The start message of the method "SetDefaultSettings"
 * This method sets default settings for a specified category. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETDEFAULTSETTINGS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SetDefaultSettingsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDefaultSettingsStart ();

    /**
     * Copy constructor
     */
    inline  SetDefaultSettingsStart (const SetDefaultSettingsStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetDefaultSettingsStart (::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories SettingsCategory_);

    /**
     * Destructor
     */
    inline virtual  ~SetDefaultSettingsStart();

    /**
     * Assignment operator
     */
    inline SetDefaultSettingsStart& operator = (const SetDefaultSettingsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDefaultSettingsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDefaultSettingsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDefaultSettingsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDefaultSettingsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SettingsCategory"

    static const int kSettingsCategory = 0;

    /**
     * Clears the field "SettingsCategory".
     *
     * The field will be set to its default value. The hasSettingsCategory()
     * method will return false.
     */
    inline void clearSettingsCategory();

    /**
     * Checks whether the field "SettingsCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSettingsCategory()). Otherwise it will return false.
     */
    inline bool hasSettingsCategory () const;

    /**
     * Returns the value of the member "SettingsCategory".
     *
     * Category to set default settings for.
     *
     * @return The value of the field "SettingsCategory"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories getSettingsCategory () const;

    /**
     * Sets the value of the member "SettingsCategory".
     *
     * Category to set default settings for.
     *
     * @param SettingsCategory The value which will be set
     */
    inline void setSettingsCategory (::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories SettingsCategory_);

    static const SetDefaultSettingsStart &getDefaultInstance();

private:

    inline void set_has_SettingsCategory ();

    inline void clear_has_SettingsCategory ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories _SettingsCategory;

};

/**
 * The result message of the method "SetDefaultSettings"
 * This method sets default settings for a specified category. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETDEFAULTSETTINGS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class SetDefaultSettingsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDefaultSettingsResult ();

    /**
     * Copy constructor
     */
    inline  SetDefaultSettingsResult (const SetDefaultSettingsResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetDefaultSettingsResult (bool SettingsSuccessful_, ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories SettingsCategory_);

    /**
     * Destructor
     */
    inline virtual  ~SetDefaultSettingsResult();

    /**
     * Assignment operator
     */
    inline SetDefaultSettingsResult& operator = (const SetDefaultSettingsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDefaultSettingsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDefaultSettingsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDefaultSettingsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDefaultSettingsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SettingsSuccessful"

    static const int kSettingsSuccessful = 0;

    /**
     * Clears the field "SettingsSuccessful".
     *
     * The field will be set to its default value. The hasSettingsSuccessful()
     * method will return false.
     */
    inline void clearSettingsSuccessful();

    /**
     * Checks whether the field "SettingsSuccessful" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSettingsSuccessful()). Otherwise it will return false.
     */
    inline bool hasSettingsSuccessful () const;

    /**
     * Returns the value of the member "SettingsSuccessful".
     *
     * Result of operation.
     *
     * @return The value of the field "SettingsSuccessful"
     */
    inline bool getSettingsSuccessful () const;

    /**
     * Sets the value of the member "SettingsSuccessful".
     *
     * Result of operation.
     *
     * @param SettingsSuccessful The value which will be set
     */
    inline void setSettingsSuccessful (bool SettingsSuccessful_);

    // API of field "SettingsCategory"

    static const int kSettingsCategory = 1;

    /**
     * Clears the field "SettingsCategory".
     *
     * The field will be set to its default value. The hasSettingsCategory()
     * method will return false.
     */
    inline void clearSettingsCategory();

    /**
     * Checks whether the field "SettingsCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSettingsCategory()). Otherwise it will return false.
     */
    inline bool hasSettingsCategory () const;

    /**
     * Returns the value of the member "SettingsCategory".
     *
     * Category to set default settings for.
     *
     * @return The value of the field "SettingsCategory"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories getSettingsCategory () const;

    /**
     * Sets the value of the member "SettingsCategory".
     *
     * Category to set default settings for.
     *
     * @param SettingsCategory The value which will be set
     */
    inline void setSettingsCategory (::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories SettingsCategory_);

    static const SetDefaultSettingsResult &getDefaultInstance();

private:

    inline void set_has_SettingsSuccessful ();

    inline void clear_has_SettingsSuccessful ();

    inline void set_has_SettingsCategory ();

    inline void clear_has_SettingsCategory ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _SettingsSuccessful;

    ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories _SettingsCategory;

};

/**
 * The start message of the method "EnableTimeSlot"
 * Enables the MAUS setup time slot. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ENABLETIMESLOT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class EnableTimeSlotStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnableTimeSlotStart ();

    /**
     * Copy constructor
     */
    inline  EnableTimeSlotStart (const EnableTimeSlotStart &rhs);

    /**
     * All fields constructor
     */
    inline  EnableTimeSlotStart (::midw_diagnostics_fi_types::T_e8_DiagMausSetup MausSetup_);

    /**
     * Destructor
     */
    inline virtual  ~EnableTimeSlotStart();

    /**
     * Assignment operator
     */
    inline EnableTimeSlotStart& operator = (const EnableTimeSlotStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnableTimeSlotStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnableTimeSlotStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnableTimeSlotStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnableTimeSlotStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MausSetup"

    static const int kMausSetup = 0;

    /**
     * Clears the field "MausSetup".
     *
     * The field will be set to its default value. The hasMausSetup()
     * method will return false.
     */
    inline void clearMausSetup();

    /**
     * Checks whether the field "MausSetup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMausSetup()). Otherwise it will return false.
     */
    inline bool hasMausSetup () const;

    /**
     * Returns the value of the member "MausSetup".
     *
     * Enables the MAUS Setup time slot
     *
     * @return The value of the field "MausSetup"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DiagMausSetup getMausSetup () const;

    /**
     * Sets the value of the member "MausSetup".
     *
     * Enables the MAUS Setup time slot
     *
     * @param MausSetup The value which will be set
     */
    inline void setMausSetup (::midw_diagnostics_fi_types::T_e8_DiagMausSetup MausSetup_);

    static const EnableTimeSlotStart &getDefaultInstance();

private:

    inline void set_has_MausSetup ();

    inline void clear_has_MausSetup ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_DiagMausSetup _MausSetup;

};

/**
 * The result message of the method "EnableTimeSlot"
 * Enables the MAUS setup time slot. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ENABLETIMESLOT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class EnableTimeSlotResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnableTimeSlotResult ();

    /**
     * Copy constructor
     */
    inline  EnableTimeSlotResult (const EnableTimeSlotResult &rhs);

    /**
     * All fields constructor
     */
    inline  EnableTimeSlotResult (bool EnableSuccessful_);

    /**
     * Destructor
     */
    inline virtual  ~EnableTimeSlotResult();

    /**
     * Assignment operator
     */
    inline EnableTimeSlotResult& operator = (const EnableTimeSlotResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnableTimeSlotResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnableTimeSlotResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnableTimeSlotResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnableTimeSlotResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EnableSuccessful"

    static const int kEnableSuccessful = 0;

    /**
     * Clears the field "EnableSuccessful".
     *
     * The field will be set to its default value. The hasEnableSuccessful()
     * method will return false.
     */
    inline void clearEnableSuccessful();

    /**
     * Checks whether the field "EnableSuccessful" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnableSuccessful()). Otherwise it will return false.
     */
    inline bool hasEnableSuccessful () const;

    /**
     * Returns the value of the member "EnableSuccessful".
     *
     * Result of operation.
     *
     * @return The value of the field "EnableSuccessful"
     */
    inline bool getEnableSuccessful () const;

    /**
     * Sets the value of the member "EnableSuccessful".
     *
     * Result of operation.
     *
     * @param EnableSuccessful The value which will be set
     */
    inline void setEnableSuccessful (bool EnableSuccessful_);

    static const EnableTimeSlotResult &getDefaultInstance();

private:

    inline void set_has_EnableSuccessful ();

    inline void clear_has_EnableSuccessful ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _EnableSuccessful;

};

/**
 * The start message of the method "StopDiagnosticTest"
 * Provides functionality to stop the specified test routine. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STOPDIAGNOSTICTEST, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class StopDiagnosticTestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopDiagnosticTestStart ();

    /**
     * Copy constructor
     */
    inline  StopDiagnosticTestStart (const StopDiagnosticTestStart &rhs);

    /**
     * All fields constructor
     */
    inline  StopDiagnosticTestStart (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_);

    /**
     * Destructor
     */
    inline virtual  ~StopDiagnosticTestStart();

    /**
     * Assignment operator
     */
    inline StopDiagnosticTestStart& operator = (const StopDiagnosticTestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopDiagnosticTestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopDiagnosticTestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopDiagnosticTestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopDiagnosticTestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TestRoutine"

    static const int kTestRoutine = 0;

    /**
     * Clears the field "TestRoutine".
     *
     * The field will be set to its default value. The hasTestRoutine()
     * method will return false.
     */
    inline void clearTestRoutine();

    /**
     * Checks whether the field "TestRoutine" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestRoutine()). Otherwise it will return false.
     */
    inline bool hasTestRoutine () const;

    /**
     * Returns the value of the member "TestRoutine".
     *
     * Select the test  to stop.
     *
     * @return The value of the field "TestRoutine"
     */
    inline ::midw_diagnostics_fi_types::T_e8_TestRoutines getTestRoutine () const;

    /**
     * Sets the value of the member "TestRoutine".
     *
     * Select the test  to stop.
     *
     * @param TestRoutine The value which will be set
     */
    inline void setTestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_);

    static const StopDiagnosticTestStart &getDefaultInstance();

private:

    inline void set_has_TestRoutine ();

    inline void clear_has_TestRoutine ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_TestRoutines _TestRoutine;

};

/**
 * The result message of the method "StopDiagnosticTest"
 * Provides functionality to stop the specified test routine. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STOPDIAGNOSTICTEST, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
 */
class StopDiagnosticTestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopDiagnosticTestResult ();

    /**
     * Copy constructor
     */
    inline  StopDiagnosticTestResult (const StopDiagnosticTestResult &rhs);

    /**
     * All fields constructor
     */
    inline  StopDiagnosticTestResult (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_, bool Success_);

    /**
     * Destructor
     */
    inline virtual  ~StopDiagnosticTestResult();

    /**
     * Assignment operator
     */
    inline StopDiagnosticTestResult& operator = (const StopDiagnosticTestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopDiagnosticTestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopDiagnosticTestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopDiagnosticTestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopDiagnosticTestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TestRoutine"

    static const int kTestRoutine = 0;

    /**
     * Clears the field "TestRoutine".
     *
     * The field will be set to its default value. The hasTestRoutine()
     * method will return false.
     */
    inline void clearTestRoutine();

    /**
     * Checks whether the field "TestRoutine" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestRoutine()). Otherwise it will return false.
     */
    inline bool hasTestRoutine () const;

    /**
     * Returns the value of the member "TestRoutine".
     *
     * Test stoppped.
     *
     * @return The value of the field "TestRoutine"
     */
    inline ::midw_diagnostics_fi_types::T_e8_TestRoutines getTestRoutine () const;

    /**
     * Sets the value of the member "TestRoutine".
     *
     * Test stoppped.
     *
     * @param TestRoutine The value which will be set
     */
    inline void setTestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_);

    // API of field "Success"

    static const int kSuccess = 1;

    /**
     * Clears the field "Success".
     *
     * The field will be set to its default value. The hasSuccess()
     * method will return false.
     */
    inline void clearSuccess();

    /**
     * Checks whether the field "Success" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuccess()). Otherwise it will return false.
     */
    inline bool hasSuccess () const;

    /**
     * Returns the value of the member "Success".
     *
     * Test successfully stopped.
     *
     * @return The value of the field "Success"
     */
    inline bool getSuccess () const;

    /**
     * Sets the value of the member "Success".
     *
     * Test successfully stopped.
     *
     * @param Success The value which will be set
     */
    inline void setSuccess (bool Success_);

    static const StopDiagnosticTestResult &getDefaultInstance();

private:

    inline void set_has_TestRoutine ();

    inline void clear_has_TestRoutine ();

    inline void set_has_Success ();

    inline void clear_has_Success ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_TestRoutines _TestRoutine;

    bool _Success;

};

/**
 * The status message of the property "SetFactorySettingsStatus"
 * This property gives information about the actual DefSetState, it is TRUE if all parameters are in Default State.
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS_STATUS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>the Identifier for "DefSetStateFirstDifferentParameterId" will be found in the Doors "/Ford HS-LSRNS Dev/System Specification/Parameter Dictionary" Document</p>
 */
class SetFactorySettingsStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsStatusStatus (const SetFactorySettingsStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsStatusStatus (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_, bool DefSetStateSuccessful_, uint16 DefSetStateFirstDifferentParameterId_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsStatusStatus();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsStatusStatus& operator = (const SetFactorySettingsStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     * <p>E.g. DEFSET_GROUP__RADIO</p>
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline uint8 getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     * <p>E.g. DEFSET_GROUP__RADIO</p>
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (uint8 DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, UPREG, RELUPREG</p>
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, UPREG, RELUPREG</p>
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_);

    // API of field "DefSetStateSuccessful"

    static const int kDefSetStateSuccessful = 2;

    /**
     * Clears the field "DefSetStateSuccessful".
     *
     * The field will be set to its default value. The hasDefSetStateSuccessful()
     * method will return false.
     */
    inline void clearDefSetStateSuccessful();

    /**
     * Checks whether the field "DefSetStateSuccessful" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateSuccessful()). Otherwise it will return false.
     */
    inline bool hasDefSetStateSuccessful () const;

    /**
     * Returns the value of the member "DefSetStateSuccessful".
     *
     * DefSet State True means: all parameter have their default state.
     * <p>Should be TRUE in case of UPREG and RELUPREG</p>
     *
     * @return The value of the field "DefSetStateSuccessful"
     */
    inline bool getDefSetStateSuccessful () const;

    /**
     * Sets the value of the member "DefSetStateSuccessful".
     *
     * DefSet State True means: all parameter have their default state.
     * <p>Should be TRUE in case of UPREG and RELUPREG</p>
     *
     * @param DefSetStateSuccessful The value which will be set
     */
    inline void setDefSetStateSuccessful (bool DefSetStateSuccessful_);

    // API of field "DefSetStateFirstDifferentParameterId"

    static const int kDefSetStateFirstDifferentParameterId = 3;

    /**
     * Clears the field "DefSetStateFirstDifferentParameterId".
     *
     * The field will be set to its default value. The hasDefSetStateFirstDifferentParameterId()
     * method will return false.
     */
    inline void clearDefSetStateFirstDifferentParameterId();

    /**
     * Checks whether the field "DefSetStateFirstDifferentParameterId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateFirstDifferentParameterId()). Otherwise it will return false.
     */
    inline bool hasDefSetStateFirstDifferentParameterId () const;

    /**
     * Returns the value of the member "DefSetStateFirstDifferentParameterId".
     *
     * <p>identifier  of an Value which is different to the default value.</p>
     * <p>E.g Def-27 default=CLEAR, current=NOTCLEAR => Id = 27.</p>
     * <p>If Successful== TRUE the Id = 0.</p>
     *
     * @return The value of the field "DefSetStateFirstDifferentParameterId"
     */
    inline uint16 getDefSetStateFirstDifferentParameterId () const;

    /**
     * Sets the value of the member "DefSetStateFirstDifferentParameterId".
     *
     * <p>identifier  of an Value which is different to the default value.</p>
     * <p>E.g Def-27 default=CLEAR, current=NOTCLEAR => Id = 27.</p>
     * <p>If Successful== TRUE the Id = 0.</p>
     *
     * @param DefSetStateFirstDifferentParameterId The value which will be set
     */
    inline void setDefSetStateFirstDifferentParameterId (uint16 DefSetStateFirstDifferentParameterId_);

    static const SetFactorySettingsStatusStatus &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    inline void set_has_DefSetStateSuccessful ();

    inline void clear_has_DefSetStateSuccessful ();

    inline void set_has_DefSetStateFirstDifferentParameterId ();

    inline void clear_has_DefSetStateFirstDifferentParameterId ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _DefSetStateGroup;

    ::midw_diagnostics_fi_types::T_e8_DefSetMode _DefSetStateMode;

    bool _DefSetStateSuccessful;

    uint16 _DefSetStateFirstDifferentParameterId;

};

/**
 * The set message of the property "SetFactorySettingsStatus"
 * This property gives information about the actual DefSetState, it is TRUE if all parameters are in Default State.
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS_STATUS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>the Identifier for "DefSetStateFirstDifferentParameterId" will be found in the Doors "/Ford HS-LSRNS Dev/System Specification/Parameter Dictionary" Document</p>
 * Request the current DefSet State
 */
class SetFactorySettingsStatusSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsStatusSet ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsStatusSet (const SetFactorySettingsStatusSet &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsStatusSet (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_, bool DefSetStateSuccessful_, uint16 DefSetStateFirstDifferentParameterId_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsStatusSet();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsStatusSet& operator = (const SetFactorySettingsStatusSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsStatusSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsStatusSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsStatusSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsStatusSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     * <p>E.g. DEFSET_GROUP__RADIO</p>
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline uint8 getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     * <p>E.g. DEFSET_GROUP__RADIO</p>
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (uint8 DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, UPREG, RELUPREG</p>
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, UPREG, RELUPREG</p>
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_);

    // API of field "DefSetStateSuccessful"

    static const int kDefSetStateSuccessful = 2;

    /**
     * Clears the field "DefSetStateSuccessful".
     *
     * The field will be set to its default value. The hasDefSetStateSuccessful()
     * method will return false.
     */
    inline void clearDefSetStateSuccessful();

    /**
     * Checks whether the field "DefSetStateSuccessful" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateSuccessful()). Otherwise it will return false.
     */
    inline bool hasDefSetStateSuccessful () const;

    /**
     * Returns the value of the member "DefSetStateSuccessful".
     *
     * DefSet State True means: all parameter have their default state.
     * <p>only relevant for components who act as a CLIENT, else always TRUE</p>
     *
     * @return The value of the field "DefSetStateSuccessful"
     */
    inline bool getDefSetStateSuccessful () const;

    /**
     * Sets the value of the member "DefSetStateSuccessful".
     *
     * DefSet State True means: all parameter have their default state.
     * <p>only relevant for components who act as a CLIENT, else always TRUE</p>
     *
     * @param DefSetStateSuccessful The value which will be set
     */
    inline void setDefSetStateSuccessful (bool DefSetStateSuccessful_);

    // API of field "DefSetStateFirstDifferentParameterId"

    static const int kDefSetStateFirstDifferentParameterId = 3;

    /**
     * Clears the field "DefSetStateFirstDifferentParameterId".
     *
     * The field will be set to its default value. The hasDefSetStateFirstDifferentParameterId()
     * method will return false.
     */
    inline void clearDefSetStateFirstDifferentParameterId();

    /**
     * Checks whether the field "DefSetStateFirstDifferentParameterId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateFirstDifferentParameterId()). Otherwise it will return false.
     */
    inline bool hasDefSetStateFirstDifferentParameterId () const;

    /**
     * Returns the value of the member "DefSetStateFirstDifferentParameterId".
     *
     * <p>identifier of an Value which is different to the default value.</p>
     * <p>E.g Def-27 default=CLEAR, current=NOTCLEAR => Id = 27.</p>
     * <p>If Successful== TRUE the Id = 0.</p>
     * <p>only relevant for components who act as a CLIENT, else always 0</p>
     *
     * @return The value of the field "DefSetStateFirstDifferentParameterId"
     */
    inline uint16 getDefSetStateFirstDifferentParameterId () const;

    /**
     * Sets the value of the member "DefSetStateFirstDifferentParameterId".
     *
     * <p>identifier of an Value which is different to the default value.</p>
     * <p>E.g Def-27 default=CLEAR, current=NOTCLEAR => Id = 27.</p>
     * <p>If Successful== TRUE the Id = 0.</p>
     * <p>only relevant for components who act as a CLIENT, else always 0</p>
     *
     * @param DefSetStateFirstDifferentParameterId The value which will be set
     */
    inline void setDefSetStateFirstDifferentParameterId (uint16 DefSetStateFirstDifferentParameterId_);

    static const SetFactorySettingsStatusSet &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    inline void set_has_DefSetStateSuccessful ();

    inline void clear_has_DefSetStateSuccessful ();

    inline void set_has_DefSetStateFirstDifferentParameterId ();

    inline void clear_has_DefSetStateFirstDifferentParameterId ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _DefSetStateGroup;

    ::midw_diagnostics_fi_types::T_e8_DefSetMode _DefSetStateMode;

    bool _DefSetStateSuccessful;

    uint16 _DefSetStateFirstDifferentParameterId;

};

/**
 * The get message of the property "SetFactorySettingsStatus"
 * This property gives information about the actual DefSetState, it is TRUE if all parameters are in Default State.
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS_STATUS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>the Identifier for "DefSetStateFirstDifferentParameterId" will be found in the Doors "/Ford HS-LSRNS Dev/System Specification/Parameter Dictionary" Document</p>
 * Request the current DefSet State
 */
class SetFactorySettingsStatusGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsStatusGet ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsStatusGet (const SetFactorySettingsStatusGet &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsStatusGet (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_, bool DefSetStateSuccessful_, uint16 DefSetStateFirstDifferentParameterId_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsStatusGet();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsStatusGet& operator = (const SetFactorySettingsStatusGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsStatusGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsStatusGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsStatusGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsStatusGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     * <p>E.g. DEFSET_GROUP__RADIO</p>
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline uint8 getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     * <p>E.g. DEFSET_GROUP__RADIO</p>
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (uint8 DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, UPREG, RELUPREG</p>
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, UPREG, RELUPREG</p>
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_);

    // API of field "DefSetStateSuccessful"

    static const int kDefSetStateSuccessful = 2;

    /**
     * Clears the field "DefSetStateSuccessful".
     *
     * The field will be set to its default value. The hasDefSetStateSuccessful()
     * method will return false.
     */
    inline void clearDefSetStateSuccessful();

    /**
     * Checks whether the field "DefSetStateSuccessful" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateSuccessful()). Otherwise it will return false.
     */
    inline bool hasDefSetStateSuccessful () const;

    /**
     * Returns the value of the member "DefSetStateSuccessful".
     *
     * DefSet State True means: all parameter have their default state.
     * <p>only relevant for components who act as a CLIENT, else always TRUE</p>
     *
     * @return The value of the field "DefSetStateSuccessful"
     */
    inline bool getDefSetStateSuccessful () const;

    /**
     * Sets the value of the member "DefSetStateSuccessful".
     *
     * DefSet State True means: all parameter have their default state.
     * <p>only relevant for components who act as a CLIENT, else always TRUE</p>
     *
     * @param DefSetStateSuccessful The value which will be set
     */
    inline void setDefSetStateSuccessful (bool DefSetStateSuccessful_);

    // API of field "DefSetStateFirstDifferentParameterId"

    static const int kDefSetStateFirstDifferentParameterId = 3;

    /**
     * Clears the field "DefSetStateFirstDifferentParameterId".
     *
     * The field will be set to its default value. The hasDefSetStateFirstDifferentParameterId()
     * method will return false.
     */
    inline void clearDefSetStateFirstDifferentParameterId();

    /**
     * Checks whether the field "DefSetStateFirstDifferentParameterId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateFirstDifferentParameterId()). Otherwise it will return false.
     */
    inline bool hasDefSetStateFirstDifferentParameterId () const;

    /**
     * Returns the value of the member "DefSetStateFirstDifferentParameterId".
     *
     * <p>identifier of an Value which is different to the default value.</p>
     * <p>E.g Def-27 default=CLEAR, current=NOTCLEAR => Id = 27.</p>
     * <p>If Successful== TRUE the Id = 0.</p>
     * <p>only relevant for components who act as a CLIENT, else always 0</p>
     *
     * @return The value of the field "DefSetStateFirstDifferentParameterId"
     */
    inline uint16 getDefSetStateFirstDifferentParameterId () const;

    /**
     * Sets the value of the member "DefSetStateFirstDifferentParameterId".
     *
     * <p>identifier of an Value which is different to the default value.</p>
     * <p>E.g Def-27 default=CLEAR, current=NOTCLEAR => Id = 27.</p>
     * <p>If Successful== TRUE the Id = 0.</p>
     * <p>only relevant for components who act as a CLIENT, else always 0</p>
     *
     * @param DefSetStateFirstDifferentParameterId The value which will be set
     */
    inline void setDefSetStateFirstDifferentParameterId (uint16 DefSetStateFirstDifferentParameterId_);

    static const SetFactorySettingsStatusGet &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    inline void set_has_DefSetStateSuccessful ();

    inline void clear_has_DefSetStateSuccessful ();

    inline void set_has_DefSetStateFirstDifferentParameterId ();

    inline void clear_has_DefSetStateFirstDifferentParameterId ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _DefSetStateGroup;

    ::midw_diagnostics_fi_types::T_e8_DefSetMode _DefSetStateMode;

    bool _DefSetStateSuccessful;

    uint16 _DefSetStateFirstDifferentParameterId;

};

/**
 * The status message of the property "RemoteControl"
 * Remote control for customer diagnostics using the UDS protocol
 * Notification about the current remote control state of the specified ioctrl signal
 */
class RemoteControlStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteControlStatus ();

    /**
     * Copy constructor
     */
    inline  RemoteControlStatus (const RemoteControlStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteControlStatus (::midw_diagnostics_fi_types::T_e8_RCtrlSource src_, ::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd_, ::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal_, bool status_);

    /**
     * Destructor
     */
    inline virtual  ~RemoteControlStatus();

    /**
     * Assignment operator
     */
    inline RemoteControlStatus& operator = (const RemoteControlStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteControlStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteControlStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteControlStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteControlStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "src"

    static const int kSrc = 0;

    /**
     * Clears the field "src".
     *
     * The field will be set to its default value. The hasSrc()
     * method will return false.
     */
    inline void clearSrc();

    /**
     * Checks whether the field "src" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSrc()). Otherwise it will return false.
     */
    inline bool hasSrc () const;

    /**
     * Returns the value of the member "src".
     *
     * Identifies the remote controller (could be HMI, TEF or Customer)
     *
     * @return The value of the field "src"
     */
    inline ::midw_diagnostics_fi_types::T_e8_RCtrlSource getSrc () const;

    /**
     * Sets the value of the member "src".
     *
     * Identifies the remote controller (could be HMI, TEF or Customer)
     *
     * @param src The value which will be set
     */
    inline void setSrc (::midw_diagnostics_fi_types::T_e8_RCtrlSource src_);

    // API of field "cmd"

    static const int kCmd = 1;

    /**
     * Clears the field "cmd".
     *
     * The field will be set to its default value. The hasCmd()
     * method will return false.
     */
    inline void clearCmd();

    /**
     * Checks whether the field "cmd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCmd()). Otherwise it will return false.
     */
    inline bool hasCmd () const;

    /**
     * Returns the value of the member "cmd".
     *
     * Identifies the command to be performed (activate, deactivate, set to default,...)
     *
     * @return The value of the field "cmd"
     */
    inline ::midw_diagnostics_fi_types::T_e8_RCtrlCommand getCmd () const;

    /**
     * Sets the value of the member "cmd".
     *
     * Identifies the command to be performed (activate, deactivate, set to default,...)
     *
     * @param cmd The value which will be set
     */
    inline void setCmd (::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd_);

    // API of field "signal"

    static const int kSignal = 2;

    /**
     * Clears the field "signal".
     *
     * The field will be set to its default value. The hasSignal()
     * method will return false.
     */
    inline void clearSignal();

    /**
     * Checks whether the field "signal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSignal()). Otherwise it will return false.
     */
    inline bool hasSignal () const;

    /**
     * Returns the value of the member "signal".
     *
     * Identifies the signal for that the remote control state shall be modified
     *
     * @return The value of the field "signal"
     */
    inline ::midw_diagnostics_fi_types::T_e8_RCtrlSignal getSignal () const;

    /**
     * Sets the value of the member "signal".
     *
     * Identifies the signal for that the remote control state shall be modified
     *
     * @param signal The value which will be set
     */
    inline void setSignal (::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal_);

    // API of field "status"

    static const int kStatus = 3;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * Identifies the signal for that the remote control state shall be modified
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * Identifies the signal for that the remote control state shall be modified
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const RemoteControlStatus &getDefaultInstance();

private:

    inline void set_has_src ();

    inline void clear_has_src ();

    inline void set_has_cmd ();

    inline void clear_has_cmd ();

    inline void set_has_signal ();

    inline void clear_has_signal ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_RCtrlSource _src;

    ::midw_diagnostics_fi_types::T_e8_RCtrlCommand _cmd;

    ::midw_diagnostics_fi_types::T_e8_RCtrlSignal _signal;

    bool _status;

};

/**
 * The set message of the property "RemoteControl"
 * Remote control for customer diagnostics using the UDS protocol
 * Set the current remote control state for the specified ioctrl signal
 */
class RemoteControlSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteControlSet ();

    /**
     * Copy constructor
     */
    inline  RemoteControlSet (const RemoteControlSet &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteControlSet (::midw_diagnostics_fi_types::T_e8_RCtrlSource src_, ::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd_, ::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal_, bool status_);

    /**
     * Destructor
     */
    inline virtual  ~RemoteControlSet();

    /**
     * Assignment operator
     */
    inline RemoteControlSet& operator = (const RemoteControlSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteControlSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteControlSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteControlSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteControlSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "src"

    static const int kSrc = 0;

    /**
     * Clears the field "src".
     *
     * The field will be set to its default value. The hasSrc()
     * method will return false.
     */
    inline void clearSrc();

    /**
     * Checks whether the field "src" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSrc()). Otherwise it will return false.
     */
    inline bool hasSrc () const;

    /**
     * Returns the value of the member "src".
     *
     * Identifies the remote controller (could be HMI, TEF or Customer)
     *
     * @return The value of the field "src"
     */
    inline ::midw_diagnostics_fi_types::T_e8_RCtrlSource getSrc () const;

    /**
     * Sets the value of the member "src".
     *
     * Identifies the remote controller (could be HMI, TEF or Customer)
     *
     * @param src The value which will be set
     */
    inline void setSrc (::midw_diagnostics_fi_types::T_e8_RCtrlSource src_);

    // API of field "cmd"

    static const int kCmd = 1;

    /**
     * Clears the field "cmd".
     *
     * The field will be set to its default value. The hasCmd()
     * method will return false.
     */
    inline void clearCmd();

    /**
     * Checks whether the field "cmd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCmd()). Otherwise it will return false.
     */
    inline bool hasCmd () const;

    /**
     * Returns the value of the member "cmd".
     *
     * Identifies the command to be performed (activate, deactivate, set to default,...)
     *
     * @return The value of the field "cmd"
     */
    inline ::midw_diagnostics_fi_types::T_e8_RCtrlCommand getCmd () const;

    /**
     * Sets the value of the member "cmd".
     *
     * Identifies the command to be performed (activate, deactivate, set to default,...)
     *
     * @param cmd The value which will be set
     */
    inline void setCmd (::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd_);

    // API of field "signal"

    static const int kSignal = 2;

    /**
     * Clears the field "signal".
     *
     * The field will be set to its default value. The hasSignal()
     * method will return false.
     */
    inline void clearSignal();

    /**
     * Checks whether the field "signal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSignal()). Otherwise it will return false.
     */
    inline bool hasSignal () const;

    /**
     * Returns the value of the member "signal".
     *
     * Identifies the signal for that the remote control state shall be modified
     *
     * @return The value of the field "signal"
     */
    inline ::midw_diagnostics_fi_types::T_e8_RCtrlSignal getSignal () const;

    /**
     * Sets the value of the member "signal".
     *
     * Identifies the signal for that the remote control state shall be modified
     *
     * @param signal The value which will be set
     */
    inline void setSignal (::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal_);

    // API of field "status"

    static const int kStatus = 3;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * Identifies the signal for that the remote control state shall be modified
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * Identifies the signal for that the remote control state shall be modified
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const RemoteControlSet &getDefaultInstance();

private:

    inline void set_has_src ();

    inline void clear_has_src ();

    inline void set_has_cmd ();

    inline void clear_has_cmd ();

    inline void set_has_signal ();

    inline void clear_has_signal ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_RCtrlSource _src;

    ::midw_diagnostics_fi_types::T_e8_RCtrlCommand _cmd;

    ::midw_diagnostics_fi_types::T_e8_RCtrlSignal _signal;

    bool _status;

};

/**
 * The get message of the property "RemoteControl"
 * Remote control for customer diagnostics using the UDS protocol
 * Request the current remote control state for the specified ioctrl signal
 */
class RemoteControlGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteControlGet ();

    /**
     * Copy constructor
     */
    inline  RemoteControlGet (const RemoteControlGet &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteControlGet (::midw_diagnostics_fi_types::T_e8_RCtrlSource src_, ::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd_, ::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal_);

    /**
     * Destructor
     */
    inline virtual  ~RemoteControlGet();

    /**
     * Assignment operator
     */
    inline RemoteControlGet& operator = (const RemoteControlGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteControlGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteControlGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteControlGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteControlGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "src"

    static const int kSrc = 0;

    /**
     * Clears the field "src".
     *
     * The field will be set to its default value. The hasSrc()
     * method will return false.
     */
    inline void clearSrc();

    /**
     * Checks whether the field "src" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSrc()). Otherwise it will return false.
     */
    inline bool hasSrc () const;

    /**
     * Returns the value of the member "src".
     *
     * Identifies the remote controller (could be HMI, TEF or Customer)
     *
     * @return The value of the field "src"
     */
    inline ::midw_diagnostics_fi_types::T_e8_RCtrlSource getSrc () const;

    /**
     * Sets the value of the member "src".
     *
     * Identifies the remote controller (could be HMI, TEF or Customer)
     *
     * @param src The value which will be set
     */
    inline void setSrc (::midw_diagnostics_fi_types::T_e8_RCtrlSource src_);

    // API of field "cmd"

    static const int kCmd = 1;

    /**
     * Clears the field "cmd".
     *
     * The field will be set to its default value. The hasCmd()
     * method will return false.
     */
    inline void clearCmd();

    /**
     * Checks whether the field "cmd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCmd()). Otherwise it will return false.
     */
    inline bool hasCmd () const;

    /**
     * Returns the value of the member "cmd".
     *
     * Identifies the information to be retrieved (is activated, is deactivated, was set to default,...)
     *
     * @return The value of the field "cmd"
     */
    inline ::midw_diagnostics_fi_types::T_e8_RCtrlCommand getCmd () const;

    /**
     * Sets the value of the member "cmd".
     *
     * Identifies the information to be retrieved (is activated, is deactivated, was set to default,...)
     *
     * @param cmd The value which will be set
     */
    inline void setCmd (::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd_);

    // API of field "signal"

    static const int kSignal = 2;

    /**
     * Clears the field "signal".
     *
     * The field will be set to its default value. The hasSignal()
     * method will return false.
     */
    inline void clearSignal();

    /**
     * Checks whether the field "signal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSignal()). Otherwise it will return false.
     */
    inline bool hasSignal () const;

    /**
     * Returns the value of the member "signal".
     *
     * Identifies the signal we want to get information about
     *
     * @return The value of the field "signal"
     */
    inline ::midw_diagnostics_fi_types::T_e8_RCtrlSignal getSignal () const;

    /**
     * Sets the value of the member "signal".
     *
     * Identifies the signal we want to get information about
     *
     * @param signal The value which will be set
     */
    inline void setSignal (::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal_);

    static const RemoteControlGet &getDefaultInstance();

private:

    inline void set_has_src ();

    inline void clear_has_src ();

    inline void set_has_cmd ();

    inline void clear_has_cmd ();

    inline void set_has_signal ();

    inline void clear_has_signal ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_RCtrlSource _src;

    ::midw_diagnostics_fi_types::T_e8_RCtrlCommand _cmd;

    ::midw_diagnostics_fi_types::T_e8_RCtrlSignal _signal;

};

/**
 * The status message of the property "CISswUpdateProcess"
 * CIS SW update progress to HMI for customer diagnostics using the UDS protocol
 * Notification about the current CIS SW update state of the specified routine signal
 */
class CISswUpdateProcessStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CISswUpdateProcessStatus ();

    /**
     * Copy constructor
     */
    inline  CISswUpdateProcessStatus (const CISswUpdateProcessStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CISswUpdateProcessStatus (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~CISswUpdateProcessStatus();

    /**
     * Assignment operator
     */
    inline CISswUpdateProcessStatus& operator = (const CISswUpdateProcessStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CISswUpdateProcessStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CISswUpdateProcessStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CISswUpdateProcessStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CISswUpdateProcessStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * Identifies the signal for that the CIS update state shall be modified
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * Identifies the signal for that the CIS update state shall be modified
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const CISswUpdateProcessStatus &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * The set message of the property "CISswUpdateProcess"
 * CIS SW update progress to HMI for customer diagnostics using the UDS protocol
 * Set the current CIS SW update state for the specified routine signal
 */
class CISswUpdateProcessSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CISswUpdateProcessSet ();

    /**
     * Copy constructor
     */
    inline  CISswUpdateProcessSet (const CISswUpdateProcessSet &rhs);

    /**
     * All fields constructor
     */
    inline  CISswUpdateProcessSet (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~CISswUpdateProcessSet();

    /**
     * Assignment operator
     */
    inline CISswUpdateProcessSet& operator = (const CISswUpdateProcessSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CISswUpdateProcessSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CISswUpdateProcessSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CISswUpdateProcessSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CISswUpdateProcessSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * Identifies the signal for that the CIS SW update state shall be modified
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * Identifies the signal for that the CIS SW update state shall be modified
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const CISswUpdateProcessSet &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * The status message of the property "CISswUpdateStage2Process"
 * CIS SW update stage2 progress to HMI for customer diagnostics using the UDS protocol
 * Notification about the current CIS SW update stage2 state of the specified routine signal
 */
class CISswUpdateStage2ProcessStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CISswUpdateStage2ProcessStatus ();

    /**
     * Copy constructor
     */
    inline  CISswUpdateStage2ProcessStatus (const CISswUpdateStage2ProcessStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CISswUpdateStage2ProcessStatus (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~CISswUpdateStage2ProcessStatus();

    /**
     * Assignment operator
     */
    inline CISswUpdateStage2ProcessStatus& operator = (const CISswUpdateStage2ProcessStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CISswUpdateStage2ProcessStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CISswUpdateStage2ProcessStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CISswUpdateStage2ProcessStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CISswUpdateStage2ProcessStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * Identifies the signal for that the CIS update stage2 state shall be modified
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * Identifies the signal for that the CIS update stage2 state shall be modified
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const CISswUpdateStage2ProcessStatus &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * The set message of the property "CISswUpdateStage2Process"
 * CIS SW update stage2 progress to HMI for customer diagnostics using the UDS protocol
 * Set the current CIS SW update stage2 state for the specified routine signal
 */
class CISswUpdateStage2ProcessSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CISswUpdateStage2ProcessSet ();

    /**
     * Copy constructor
     */
    inline  CISswUpdateStage2ProcessSet (const CISswUpdateStage2ProcessSet &rhs);

    /**
     * All fields constructor
     */
    inline  CISswUpdateStage2ProcessSet (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~CISswUpdateStage2ProcessSet();

    /**
     * Assignment operator
     */
    inline CISswUpdateStage2ProcessSet& operator = (const CISswUpdateStage2ProcessSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CISswUpdateStage2ProcessSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CISswUpdateStage2ProcessSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CISswUpdateStage2ProcessSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CISswUpdateStage2ProcessSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * Identifies the signal for that the CIS SW update stage2 state shall be modified
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * Identifies the signal for that the CIS SW update stage2 state shall be modified
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const CISswUpdateStage2ProcessSet &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * The start message of the method "SetFactorySettings"
 * This function request the component to set all Variables (depending on USER or TEF) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetFactorySettings MessageResult must be send immediately.
 * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
 */
class SetFactorySettingsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsStart ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsStart (const SetFactorySettingsStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsStart (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsStart();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsStart& operator = (const SetFactorySettingsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline uint8 getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (uint8 DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * TEF or USER
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * TEF or USER
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_);

    static const SetFactorySettingsStart &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _DefSetStateGroup;

    ::midw_diagnostics_fi_types::T_e8_DefSetMode _DefSetStateMode;

};

/**
 * The result message of the method "SetFactorySettings"
 * This function request the component to set all Variables (depending on USER or TEF) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetFactorySettings MessageResult must be send immediately.
 * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
 */
class SetFactorySettingsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsResult ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsResult (const SetFactorySettingsResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsResult (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus DefSetServiceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsResult();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsResult& operator = (const SetFactorySettingsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline uint8 getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (uint8 DefSetStateGroup_);

    // API of field "DefSetServiceStatus"

    static const int kDefSetServiceStatus = 1;

    /**
     * Clears the field "DefSetServiceStatus".
     *
     * The field will be set to its default value. The hasDefSetServiceStatus()
     * method will return false.
     */
    inline void clearDefSetServiceStatus();

    /**
     * Checks whether the field "DefSetServiceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetServiceStatus()). Otherwise it will return false.
     */
    inline bool hasDefSetServiceStatus () const;

    /**
     * Returns the value of the member "DefSetServiceStatus".
     *
     * Confirmation that the message is received in middleware component
     *
     * @return The value of the field "DefSetServiceStatus"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus getDefSetServiceStatus () const;

    /**
     * Sets the value of the member "DefSetServiceStatus".
     *
     * Confirmation that the message is received in middleware component
     *
     * @param DefSetServiceStatus The value which will be set
     */
    inline void setDefSetServiceStatus (::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus DefSetServiceStatus_);

    static const SetFactorySettingsResult &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetServiceStatus ();

    inline void clear_has_DefSetServiceStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _DefSetStateGroup;

    ::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus _DefSetServiceStatus;

};

/**
 * The start message of the method "SetResetToSupplierDefaultConfig"
 * This function request the component to set all Variables (depending on USER or TEF) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetResetToSupplierDefaultConfigStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetResetToSupplierDefaultConfig MessageResult must be send immediately.
 * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
 */
class SetResetToSupplierDefaultConfigStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetResetToSupplierDefaultConfigStart ();

    /**
     * Copy constructor
     */
    inline  SetResetToSupplierDefaultConfigStart (const SetResetToSupplierDefaultConfigStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetResetToSupplierDefaultConfigStart (uint8 ResetSupplierConfig_);

    /**
     * Destructor
     */
    inline virtual  ~SetResetToSupplierDefaultConfigStart();

    /**
     * Assignment operator
     */
    inline SetResetToSupplierDefaultConfigStart& operator = (const SetResetToSupplierDefaultConfigStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetResetToSupplierDefaultConfigStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetResetToSupplierDefaultConfigStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetResetToSupplierDefaultConfigStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetResetToSupplierDefaultConfigStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResetSupplierConfig"

    static const int kResetSupplierConfig = 0;

    /**
     * Clears the field "ResetSupplierConfig".
     *
     * The field will be set to its default value. The hasResetSupplierConfig()
     * method will return false.
     */
    inline void clearResetSupplierConfig();

    /**
     * Checks whether the field "ResetSupplierConfig" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResetSupplierConfig()). Otherwise it will return false.
     */
    inline bool hasResetSupplierConfig () const;

    /**
     * Returns the value of the member "ResetSupplierConfig".
     *
     * Identifier of the Supplier Default Config.
     *
     * @return The value of the field "ResetSupplierConfig"
     */
    inline uint8 getResetSupplierConfig () const;

    /**
     * Sets the value of the member "ResetSupplierConfig".
     *
     * Identifier of the Supplier Default Config.
     *
     * @param ResetSupplierConfig The value which will be set
     */
    inline void setResetSupplierConfig (uint8 ResetSupplierConfig_);

    static const SetResetToSupplierDefaultConfigStart &getDefaultInstance();

private:

    inline void set_has_ResetSupplierConfig ();

    inline void clear_has_ResetSupplierConfig ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ResetSupplierConfig;

};

/**
 * The result message of the method "SetResetToSupplierDefaultConfig"
 * This function request the component to set all Variables (depending on USER or TEF) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetResetToSupplierDefaultConfigStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetResetToSupplierDefaultConfig MessageResult must be send immediately.
 * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
 */
class SetResetToSupplierDefaultConfigResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetResetToSupplierDefaultConfigResult ();

    /**
     * Copy constructor
     */
    inline  SetResetToSupplierDefaultConfigResult (const SetResetToSupplierDefaultConfigResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetResetToSupplierDefaultConfigResult (bool DefResetServiceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SetResetToSupplierDefaultConfigResult();

    /**
     * Assignment operator
     */
    inline SetResetToSupplierDefaultConfigResult& operator = (const SetResetToSupplierDefaultConfigResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetResetToSupplierDefaultConfigResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetResetToSupplierDefaultConfigResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetResetToSupplierDefaultConfigResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetResetToSupplierDefaultConfigResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefResetServiceStatus"

    static const int kDefResetServiceStatus = 0;

    /**
     * Clears the field "DefResetServiceStatus".
     *
     * The field will be set to its default value. The hasDefResetServiceStatus()
     * method will return false.
     */
    inline void clearDefResetServiceStatus();

    /**
     * Checks whether the field "DefResetServiceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefResetServiceStatus()). Otherwise it will return false.
     */
    inline bool hasDefResetServiceStatus () const;

    /**
     * Returns the value of the member "DefResetServiceStatus".
     *
     * Confirmation that the message is received in middleware component
     *
     * @return The value of the field "DefResetServiceStatus"
     */
    inline bool getDefResetServiceStatus () const;

    /**
     * Sets the value of the member "DefResetServiceStatus".
     *
     * Confirmation that the message is received in middleware component
     *
     * @param DefResetServiceStatus The value which will be set
     */
    inline void setDefResetServiceStatus (bool DefResetServiceStatus_);

    static const SetResetToSupplierDefaultConfigResult &getDefaultInstance();

private:

    inline void set_has_DefResetServiceStatus ();

    inline void clear_has_DefResetServiceStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _DefResetServiceStatus;

};

/**
 * The start message of the method "SetRunTimeSourceData"
 * This function request the component to set all Variables (depending on USER or TEF) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetRunTimeSourceData" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetRunTimeSourceData MessageResult must be send immediately.
 * The commponent must accept a new request if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independent of that it has to confirm the new request.
 */
class SetRunTimeSourceDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRunTimeSourceDataStart ();

    /**
     * Copy constructor
     */
    inline  SetRunTimeSourceDataStart (const SetRunTimeSourceDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetRunTimeSourceDataStart (uint16 RunTimeSourceAppID_, uint32 RunTimeSourceAppData_);

    /**
     * Destructor
     */
    inline virtual  ~SetRunTimeSourceDataStart();

    /**
     * Assignment operator
     */
    inline SetRunTimeSourceDataStart& operator = (const SetRunTimeSourceDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRunTimeSourceDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRunTimeSourceDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRunTimeSourceDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRunTimeSourceDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RunTimeSourceAppID"

    static const int kRunTimeSourceAppID = 0;

    /**
     * Clears the field "RunTimeSourceAppID".
     *
     * The field will be set to its default value. The hasRunTimeSourceAppID()
     * method will return false.
     */
    inline void clearRunTimeSourceAppID();

    /**
     * Checks whether the field "RunTimeSourceAppID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRunTimeSourceAppID()). Otherwise it will return false.
     */
    inline bool hasRunTimeSourceAppID () const;

    /**
     * Returns the value of the member "RunTimeSourceAppID".
     *
     * Identifier of the RunTime Source Application CCA Id.
     *
     * @return The value of the field "RunTimeSourceAppID"
     */
    inline uint16 getRunTimeSourceAppID () const;

    /**
     * Sets the value of the member "RunTimeSourceAppID".
     *
     * Identifier of the RunTime Source Application CCA Id.
     *
     * @param RunTimeSourceAppID The value which will be set
     */
    inline void setRunTimeSourceAppID (uint16 RunTimeSourceAppID_);

    // API of field "RunTimeSourceAppData"

    static const int kRunTimeSourceAppData = 1;

    /**
     * Clears the field "RunTimeSourceAppData".
     *
     * The field will be set to its default value. The hasRunTimeSourceAppData()
     * method will return false.
     */
    inline void clearRunTimeSourceAppData();

    /**
     * Checks whether the field "RunTimeSourceAppData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRunTimeSourceAppData()). Otherwise it will return false.
     */
    inline bool hasRunTimeSourceAppData () const;

    /**
     * Returns the value of the member "RunTimeSourceAppData".
     *
     * Identifier of the RunTime Source App Data.
     *
     * @return The value of the field "RunTimeSourceAppData"
     */
    inline uint32 getRunTimeSourceAppData () const;

    /**
     * Sets the value of the member "RunTimeSourceAppData".
     *
     * Identifier of the RunTime Source App Data.
     *
     * @param RunTimeSourceAppData The value which will be set
     */
    inline void setRunTimeSourceAppData (uint32 RunTimeSourceAppData_);

    static const SetRunTimeSourceDataStart &getDefaultInstance();

private:

    inline void set_has_RunTimeSourceAppID ();

    inline void clear_has_RunTimeSourceAppID ();

    inline void set_has_RunTimeSourceAppData ();

    inline void clear_has_RunTimeSourceAppData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _RunTimeSourceAppID;

    uint32 _RunTimeSourceAppData;

};

/**
 * The result message of the method "SetRunTimeSourceData"
 * This function request the component to set all Variables (depending on USER or TEF) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetRunTimeSourceData" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetRunTimeSourceData MessageResult must be send immediately.
 * The commponent must accept a new request if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independent of that it has to confirm the new request.
 */
class SetRunTimeSourceDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRunTimeSourceDataResult ();

    /**
     * Copy constructor
     */
    inline  SetRunTimeSourceDataResult (const SetRunTimeSourceDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetRunTimeSourceDataResult (bool RunTimeSourceDiagResp_);

    /**
     * Destructor
     */
    inline virtual  ~SetRunTimeSourceDataResult();

    /**
     * Assignment operator
     */
    inline SetRunTimeSourceDataResult& operator = (const SetRunTimeSourceDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRunTimeSourceDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRunTimeSourceDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRunTimeSourceDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRunTimeSourceDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RunTimeSourceDiagResp"

    static const int kRunTimeSourceDiagResp = 0;

    /**
     * Clears the field "RunTimeSourceDiagResp".
     *
     * The field will be set to its default value. The hasRunTimeSourceDiagResp()
     * method will return false.
     */
    inline void clearRunTimeSourceDiagResp();

    /**
     * Checks whether the field "RunTimeSourceDiagResp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRunTimeSourceDiagResp()). Otherwise it will return false.
     */
    inline bool hasRunTimeSourceDiagResp () const;

    /**
     * Returns the value of the member "RunTimeSourceDiagResp".
     *
     * Confirmation that the message is received in middleware component
     *
     * @return The value of the field "RunTimeSourceDiagResp"
     */
    inline bool getRunTimeSourceDiagResp () const;

    /**
     * Sets the value of the member "RunTimeSourceDiagResp".
     *
     * Confirmation that the message is received in middleware component
     *
     * @param RunTimeSourceDiagResp The value which will be set
     */
    inline void setRunTimeSourceDiagResp (bool RunTimeSourceDiagResp_);

    static const SetRunTimeSourceDataResult &getDefaultInstance();

private:

    inline void set_has_RunTimeSourceDiagResp ();

    inline void clear_has_RunTimeSourceDiagResp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RunTimeSourceDiagResp;

};

/**
 * The start message of the method "SetFactorySettingsNew"
 * This function request the component to set all Variables (depending on USER, TEF or OEM) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetFactorySettings MessageResult must be send immediately.
 * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
 */
class SetFactorySettingsNewStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsNewStart ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsNewStart (const SetFactorySettingsNewStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsNewStart (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsNewStart();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsNewStart& operator = (const SetFactorySettingsNewStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsNewStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsNewStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsNewStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsNewStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline uint8 getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (uint8 DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, OEM, GET</p>
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, OEM, GET</p>
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_);

    static const SetFactorySettingsNewStart &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _DefSetStateGroup;

    ::midw_diagnostics_fi_types::T_e8_DefSetMode _DefSetStateMode;

};

/**
 * The result message of the method "SetFactorySettingsNew"
 * This function request the component to set all Variables (depending on USER, TEF or OEM) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
 * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
 * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetFactorySettings MessageResult must be send immediately.
 * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
 */
class SetFactorySettingsNewResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsNewResult ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsNewResult (const SetFactorySettingsNewResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsNewResult (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_, bool DefSetStateSuccessful_, uint16 DefSetStateFirstDifferentParameterId_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsNewResult();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsNewResult& operator = (const SetFactorySettingsNewResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsNewResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsNewResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsNewResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsNewResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     * <p>E.g. DEFSET_GROUP__RADIO</p>
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline uint8 getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     * <p>E.g. DEFSET_GROUP__RADIO</p>
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (uint8 DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, OEM, GET</p>
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, OEM, GET</p>
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_);

    // API of field "DefSetStateSuccessful"

    static const int kDefSetStateSuccessful = 2;

    /**
     * Clears the field "DefSetStateSuccessful".
     *
     * The field will be set to its default value. The hasDefSetStateSuccessful()
     * method will return false.
     */
    inline void clearDefSetStateSuccessful();

    /**
     * Checks whether the field "DefSetStateSuccessful" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateSuccessful()). Otherwise it will return false.
     */
    inline bool hasDefSetStateSuccessful () const;

    /**
     * Returns the value of the member "DefSetStateSuccessful".
     *
     * DefSet State True means: all parameter have their default state.
     *
     * @return The value of the field "DefSetStateSuccessful"
     */
    inline bool getDefSetStateSuccessful () const;

    /**
     * Sets the value of the member "DefSetStateSuccessful".
     *
     * DefSet State True means: all parameter have their default state.
     *
     * @param DefSetStateSuccessful The value which will be set
     */
    inline void setDefSetStateSuccessful (bool DefSetStateSuccessful_);

    // API of field "DefSetStateFirstDifferentParameterId"

    static const int kDefSetStateFirstDifferentParameterId = 3;

    /**
     * Clears the field "DefSetStateFirstDifferentParameterId".
     *
     * The field will be set to its default value. The hasDefSetStateFirstDifferentParameterId()
     * method will return false.
     */
    inline void clearDefSetStateFirstDifferentParameterId();

    /**
     * Checks whether the field "DefSetStateFirstDifferentParameterId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateFirstDifferentParameterId()). Otherwise it will return false.
     */
    inline bool hasDefSetStateFirstDifferentParameterId () const;

    /**
     * Returns the value of the member "DefSetStateFirstDifferentParameterId".
     *
     * <p>identifier  of an Value which is different to the default value.</p>
     * <p>E.g Def-27 default=CLEAR, current=NOTCLEAR => Id = 27.</p>
     * <p>If Successful== TRUE the Id = 0.</p>
     * <p>some sepperated Errorcode are supported</p>
     * 0xFFFE: can't answer now timer will be restarted (25seconds)
     * 0xFFFF: defset not possible. e.g. DVD missing, will be handled as OK
     *
     * @return The value of the field "DefSetStateFirstDifferentParameterId"
     */
    inline uint16 getDefSetStateFirstDifferentParameterId () const;

    /**
     * Sets the value of the member "DefSetStateFirstDifferentParameterId".
     *
     * <p>identifier  of an Value which is different to the default value.</p>
     * <p>E.g Def-27 default=CLEAR, current=NOTCLEAR => Id = 27.</p>
     * <p>If Successful== TRUE the Id = 0.</p>
     * <p>some sepperated Errorcode are supported</p>
     * 0xFFFE: can't answer now timer will be restarted (25seconds)
     * 0xFFFF: defset not possible. e.g. DVD missing, will be handled as OK
     *
     * @param DefSetStateFirstDifferentParameterId The value which will be set
     */
    inline void setDefSetStateFirstDifferentParameterId (uint16 DefSetStateFirstDifferentParameterId_);

    static const SetFactorySettingsNewResult &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    inline void set_has_DefSetStateSuccessful ();

    inline void clear_has_DefSetStateSuccessful ();

    inline void set_has_DefSetStateFirstDifferentParameterId ();

    inline void clear_has_DefSetStateFirstDifferentParameterId ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _DefSetStateGroup;

    ::midw_diagnostics_fi_types::T_e8_DefSetMode _DefSetStateMode;

    bool _DefSetStateSuccessful;

    uint16 _DefSetStateFirstDifferentParameterId;

};

/**
 * The start message of the method "StartCalibrationSession"
 * Starts a calibration Session for the given table.
 * <p>E.g. SYSTEM, BLUETOOTH, BRAND,...</p>
 * <p>Internally the Diagnosis component loads the table from the EOLLib to a RAM buffer.</p>
 */
class StartCalibrationSessionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartCalibrationSessionStart ();

    /**
     * Copy constructor
     */
    inline  StartCalibrationSessionStart (const StartCalibrationSessionStart &rhs);

    /**
     * All fields constructor
     */
    inline  StartCalibrationSessionStart (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_);

    /**
     * Destructor
     */
    inline virtual  ~StartCalibrationSessionStart();

    /**
     * Assignment operator
     */
    inline StartCalibrationSessionStart& operator = (const StartCalibrationSessionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartCalibrationSessionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartCalibrationSessionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartCalibrationSessionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartCalibrationSessionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Table"

    static const int kTable = 0;

    /**
     * Clears the field "Table".
     *
     * The field will be set to its default value. The hasTable()
     * method will return false.
     */
    inline void clearTable();

    /**
     * Checks whether the field "Table" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTable()). Otherwise it will return false.
     */
    inline bool hasTable () const;

    /**
     * Returns the value of the member "Table".
     *
     * The calibration table according to GIS-344 for which parameters will be changed.
     *
     * @return The value of the field "Table"
     */
    inline ::midw_diagnostics_fi_types::T_e8_CalibrationTable getTable () const;

    /**
     * Sets the value of the member "Table".
     *
     * The calibration table according to GIS-344 for which parameters will be changed.
     *
     * @param Table The value which will be set
     */
    inline void setTable (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_);

    static const StartCalibrationSessionStart &getDefaultInstance();

private:

    inline void set_has_Table ();

    inline void clear_has_Table ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_CalibrationTable _Table;

};

/**
 * The result message of the method "StartCalibrationSession"
 * Starts a calibration Session for the given table.
 * <p>E.g. SYSTEM, BLUETOOTH, BRAND,...</p>
 * <p>Internally the Diagnosis component loads the table from the EOLLib to a RAM buffer.</p>
 */
class StartCalibrationSessionResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartCalibrationSessionResult ();

    /**
     * Copy constructor
     */
    inline  StartCalibrationSessionResult (const StartCalibrationSessionResult &rhs);

    /**
     * All fields constructor
     */
    inline  StartCalibrationSessionResult (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_, uint32 SessionHandle_);

    /**
     * Destructor
     */
    inline virtual  ~StartCalibrationSessionResult();

    /**
     * Assignment operator
     */
    inline StartCalibrationSessionResult& operator = (const StartCalibrationSessionResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartCalibrationSessionResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartCalibrationSessionResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartCalibrationSessionResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartCalibrationSessionResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Table"

    static const int kTable = 0;

    /**
     * Clears the field "Table".
     *
     * The field will be set to its default value. The hasTable()
     * method will return false.
     */
    inline void clearTable();

    /**
     * Checks whether the field "Table" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTable()). Otherwise it will return false.
     */
    inline bool hasTable () const;

    /**
     * Returns the value of the member "Table".
     *
     * Current calibration table.
     *
     * @return The value of the field "Table"
     */
    inline ::midw_diagnostics_fi_types::T_e8_CalibrationTable getTable () const;

    /**
     * Sets the value of the member "Table".
     *
     * Current calibration table.
     *
     * @param Table The value which will be set
     */
    inline void setTable (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_);

    // API of field "SessionHandle"

    static const int kSessionHandle = 1;

    /**
     * Clears the field "SessionHandle".
     *
     * The field will be set to its default value. The hasSessionHandle()
     * method will return false.
     */
    inline void clearSessionHandle();

    /**
     * Checks whether the field "SessionHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionHandle()). Otherwise it will return false.
     */
    inline bool hasSessionHandle () const;

    /**
     * Returns the value of the member "SessionHandle".
     *
     * Handle to the session for all subsequent operations.
     *
     * @return The value of the field "SessionHandle"
     */
    inline uint32 getSessionHandle () const;

    /**
     * Sets the value of the member "SessionHandle".
     *
     * Handle to the session for all subsequent operations.
     *
     * @param SessionHandle The value which will be set
     */
    inline void setSessionHandle (uint32 SessionHandle_);

    static const StartCalibrationSessionResult &getDefaultInstance();

private:

    inline void set_has_Table ();

    inline void clear_has_Table ();

    inline void set_has_SessionHandle ();

    inline void clear_has_SessionHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_CalibrationTable _Table;

    uint32 _SessionHandle;

};

/**
 * The start message of the method "StopCalibrationSession"
 * Stops a calibration Session for the given table.
 * <p>E.g. SYSTEM, BLUETOOTH, BRAND,...</p>
 * <p>Internally the Diagnosis component saves the table from the RAM buffer to the EOLLib. After this all components are notified about a SystemSet concerning the calibration table.</p>
 * <p>If an error is detected while writing to the EOLLib or executing the SystemSet, an Error Message is returned.</p>
 */
class StopCalibrationSessionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopCalibrationSessionStart ();

    /**
     * Copy constructor
     */
    inline  StopCalibrationSessionStart (const StopCalibrationSessionStart &rhs);

    /**
     * All fields constructor
     */
    inline  StopCalibrationSessionStart (uint32 SessionHandle_, const ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& TimeStamp_);

    /**
     * Destructor
     */
    inline virtual  ~StopCalibrationSessionStart();

    /**
     * Assignment operator
     */
    inline StopCalibrationSessionStart& operator = (const StopCalibrationSessionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopCalibrationSessionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopCalibrationSessionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopCalibrationSessionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopCalibrationSessionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SessionHandle"

    static const int kSessionHandle = 0;

    /**
     * Clears the field "SessionHandle".
     *
     * The field will be set to its default value. The hasSessionHandle()
     * method will return false.
     */
    inline void clearSessionHandle();

    /**
     * Checks whether the field "SessionHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionHandle()). Otherwise it will return false.
     */
    inline bool hasSessionHandle () const;

    /**
     * Returns the value of the member "SessionHandle".
     *
     * Handle to the session for all pending operations.
     *
     * @return The value of the field "SessionHandle"
     */
    inline uint32 getSessionHandle () const;

    /**
     * Sets the value of the member "SessionHandle".
     *
     * Handle to the session for all pending operations.
     *
     * @param SessionHandle The value which will be set
     */
    inline void setSessionHandle (uint32 SessionHandle_);

    // API of field "TimeStamp"

    static const int kTimeStamp = 1;

    /**
     * Clears the field "TimeStamp".
     *
     * The field will be set to its default value. The hasTimeStamp()
     * method will return false.
     */
    inline void clearTimeStamp();

    /**
     * Checks whether the field "TimeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeStamp()). Otherwise it will return false.
     */
    inline bool hasTimeStamp () const;

    /**
     * Returns the value of the member "TimeStamp".
     *
     * Timestamp of last interaction. This is only saved if there was at least one Set operation on
     * the CalibrationParameter property.
     *
     * @return The value of the field "TimeStamp"
     */
    inline const ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& getTimeStamp () const;

    /**
     * Retrieves the value of the field "TimeStamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TimeStamp".
     */
    inline ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& getTimeStampMutable ();

    /**
     * Sets the value of the member "TimeStamp".
     *
     * Timestamp of last interaction. This is only saved if there was at least one Set operation on
     * the CalibrationParameter property.
     *
     * @param TimeStamp The value which will be set
     */
    inline void setTimeStamp (const ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& TimeStamp_);

    static const StopCalibrationSessionStart &getDefaultInstance();

private:

    inline void set_has_SessionHandle ();

    inline void clear_has_SessionHandle ();

    inline void set_has_TimeStamp ();

    inline void clear_has_TimeStamp ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _SessionHandle;

    ::midw_diagnostics_fi_types::T_CalibrationTimeStamp _TimeStamp;

};

/**
 * The result message of the method "StopCalibrationSession"
 * Stops a calibration Session for the given table.
 * <p>E.g. SYSTEM, BLUETOOTH, BRAND,...</p>
 * <p>Internally the Diagnosis component saves the table from the RAM buffer to the EOLLib. After this all components are notified about a SystemSet concerning the calibration table.</p>
 * <p>If an error is detected while writing to the EOLLib or executing the SystemSet, an Error Message is returned.</p>
 */
class StopCalibrationSessionResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopCalibrationSessionResult ();

    /**
     * Copy constructor
     */
    inline  StopCalibrationSessionResult (const StopCalibrationSessionResult &rhs);

    /**
     * All fields constructor
     */
    inline  StopCalibrationSessionResult (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_);

    /**
     * Destructor
     */
    inline virtual  ~StopCalibrationSessionResult();

    /**
     * Assignment operator
     */
    inline StopCalibrationSessionResult& operator = (const StopCalibrationSessionResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopCalibrationSessionResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopCalibrationSessionResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopCalibrationSessionResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopCalibrationSessionResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Table"

    static const int kTable = 0;

    /**
     * Clears the field "Table".
     *
     * The field will be set to its default value. The hasTable()
     * method will return false.
     */
    inline void clearTable();

    /**
     * Checks whether the field "Table" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTable()). Otherwise it will return false.
     */
    inline bool hasTable () const;

    /**
     * Returns the value of the member "Table".
     *
     * The calibration table for which parameters were changed and the SystemSet was executed.
     *
     * @return The value of the field "Table"
     */
    inline ::midw_diagnostics_fi_types::T_e8_CalibrationTable getTable () const;

    /**
     * Sets the value of the member "Table".
     *
     * The calibration table for which parameters were changed and the SystemSet was executed.
     *
     * @param Table The value which will be set
     */
    inline void setTable (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_);

    static const StopCalibrationSessionResult &getDefaultInstance();

private:

    inline void set_has_Table ();

    inline void clear_has_Table ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_CalibrationTable _Table;

};

/**
 * The status message of the property "CalibrationParameter"
 */
class CalibrationParameterStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CalibrationParameterStatus ();

    /**
     * Copy constructor
     */
    inline  CalibrationParameterStatus (const CalibrationParameterStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CalibrationParameterStatus (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_, const ::std::string& Name_, const ::midw_diagnostics_fi_types::T_CalibrationValue& Value_, ::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize ElementSize_);

    /**
     * Destructor
     */
    inline virtual  ~CalibrationParameterStatus();

    /**
     * Assignment operator
     */
    inline CalibrationParameterStatus& operator = (const CalibrationParameterStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CalibrationParameterStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CalibrationParameterStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CalibrationParameterStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CalibrationParameterStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Table"

    static const int kTable = 0;

    /**
     * Clears the field "Table".
     *
     * The field will be set to its default value. The hasTable()
     * method will return false.
     */
    inline void clearTable();

    /**
     * Checks whether the field "Table" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTable()). Otherwise it will return false.
     */
    inline bool hasTable () const;

    /**
     * Returns the value of the member "Table".
     *
     * The calibration table according to GIS-344.
     *
     * @return The value of the field "Table"
     */
    inline ::midw_diagnostics_fi_types::T_e8_CalibrationTable getTable () const;

    /**
     * Sets the value of the member "Table".
     *
     * The calibration table according to GIS-344.
     *
     * @param Table The value which will be set
     */
    inline void setTable (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_);

    // API of field "Name"

    static const int kName = 1;

    /**
     * Clears the field "Name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "Name".
     *
     * Name of the calibration parameter.
     *
     * @return The value of the field "Name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "Name".
     *
     * Name of the calibration parameter.
     *
     * @param Name The value which will be set
     */
    inline void setName (const ::std::string& Name_);

    /**
     * Sets the value of the member "Name".
     *
     * Name of the calibration parameter.
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* Name_);

    /**
     * Sets the value of the member "Name".
     *
     * Name of the calibration parameter.
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "Value"

    static const int kValue = 2;

    /**
     * Clears the field "Value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "Value".
     *
     * Value of the calibration parameter packed into a byte array.
     *
     * @return The value of the field "Value"
     */
    inline const ::midw_diagnostics_fi_types::T_CalibrationValue& getValue () const;

    /**
     * Retrieves the value of the field "Value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Value".
     */
    inline ::midw_diagnostics_fi_types::T_CalibrationValue& getValueMutable ();

    /**
     * Sets the value of the member "Value".
     *
     * Value of the calibration parameter packed into a byte array.
     *
     * @param Value The value which will be set
     */
    inline void setValue (const ::midw_diagnostics_fi_types::T_CalibrationValue& Value_);

    // API of field "ElementSize"

    static const int kElementSize = 3;

    /**
     * Clears the field "ElementSize".
     *
     * The field will be set to its default value. The hasElementSize()
     * method will return false.
     */
    inline void clearElementSize();

    /**
     * Checks whether the field "ElementSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElementSize()). Otherwise it will return false.
     */
    inline bool hasElementSize () const;

    /**
     * Returns the value of the member "ElementSize".
     *
     * Size of the calibration parameter elements inside the byte array.
     *
     * @return The value of the field "ElementSize"
     */
    inline ::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize getElementSize () const;

    /**
     * Sets the value of the member "ElementSize".
     *
     * Size of the calibration parameter elements inside the byte array.
     *
     * @param ElementSize The value which will be set
     */
    inline void setElementSize (::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize ElementSize_);

    static const CalibrationParameterStatus &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_Table ();

    inline void clear_has_Table ();

    inline void set_has_Name ();

    inline void clear_has_Name ();

    inline void set_has_Value ();

    inline void clear_has_Value ();

    inline void set_has_ElementSize ();

    inline void clear_has_ElementSize ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::midw_diagnostics_fi_types::T_e8_CalibrationTable _Table;

    ::std::string _Name;

    ::midw_diagnostics_fi_types::T_CalibrationValue _Value;

    ::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize _ElementSize;

};

/**
 * The set message of the property "CalibrationParameter"
 */
class CalibrationParameterSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CalibrationParameterSet ();

    /**
     * Copy constructor
     */
    inline  CalibrationParameterSet (const CalibrationParameterSet &rhs);

    /**
     * All fields constructor
     */
    inline  CalibrationParameterSet (uint32 SessionHandle_, const ::std::string& Name_, const ::midw_diagnostics_fi_types::T_CalibrationValue& Value_);

    /**
     * Destructor
     */
    inline virtual  ~CalibrationParameterSet();

    /**
     * Assignment operator
     */
    inline CalibrationParameterSet& operator = (const CalibrationParameterSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CalibrationParameterSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CalibrationParameterSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CalibrationParameterSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CalibrationParameterSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SessionHandle"

    static const int kSessionHandle = 0;

    /**
     * Clears the field "SessionHandle".
     *
     * The field will be set to its default value. The hasSessionHandle()
     * method will return false.
     */
    inline void clearSessionHandle();

    /**
     * Checks whether the field "SessionHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionHandle()). Otherwise it will return false.
     */
    inline bool hasSessionHandle () const;

    /**
     * Returns the value of the member "SessionHandle".
     *
     * Handle to the calibration table for which a session was started.
     *
     * @return The value of the field "SessionHandle"
     */
    inline uint32 getSessionHandle () const;

    /**
     * Sets the value of the member "SessionHandle".
     *
     * Handle to the calibration table for which a session was started.
     *
     * @param SessionHandle The value which will be set
     */
    inline void setSessionHandle (uint32 SessionHandle_);

    // API of field "Name"

    static const int kName = 1;

    /**
     * Clears the field "Name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "Name".
     *
     * Name of the calibration parameter.
     *
     * @return The value of the field "Name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "Name".
     *
     * Name of the calibration parameter.
     *
     * @param Name The value which will be set
     */
    inline void setName (const ::std::string& Name_);

    /**
     * Sets the value of the member "Name".
     *
     * Name of the calibration parameter.
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* Name_);

    /**
     * Sets the value of the member "Name".
     *
     * Name of the calibration parameter.
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "Value"

    static const int kValue = 2;

    /**
     * Clears the field "Value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "Value".
     *
     * Value of the calibration parameter packed into a byte array.
     *
     * @return The value of the field "Value"
     */
    inline const ::midw_diagnostics_fi_types::T_CalibrationValue& getValue () const;

    /**
     * Retrieves the value of the field "Value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Value".
     */
    inline ::midw_diagnostics_fi_types::T_CalibrationValue& getValueMutable ();

    /**
     * Sets the value of the member "Value".
     *
     * Value of the calibration parameter packed into a byte array.
     *
     * @param Value The value which will be set
     */
    inline void setValue (const ::midw_diagnostics_fi_types::T_CalibrationValue& Value_);

    static const CalibrationParameterSet &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_SessionHandle ();

    inline void clear_has_SessionHandle ();

    inline void set_has_Name ();

    inline void clear_has_Name ();

    inline void set_has_Value ();

    inline void clear_has_Value ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _SessionHandle;

    ::std::string _Name;

    ::midw_diagnostics_fi_types::T_CalibrationValue _Value;

};

/**
 * The get message of the property "CalibrationParameter"
 */
class CalibrationParameterGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CalibrationParameterGet ();

    /**
     * Copy constructor
     */
    inline  CalibrationParameterGet (const CalibrationParameterGet &rhs);

    /**
     * All fields constructor
     */
    inline  CalibrationParameterGet (uint32 SessionHandle_, const ::std::string& Name_);

    /**
     * Destructor
     */
    inline virtual  ~CalibrationParameterGet();

    /**
     * Assignment operator
     */
    inline CalibrationParameterGet& operator = (const CalibrationParameterGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CalibrationParameterGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CalibrationParameterGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CalibrationParameterGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CalibrationParameterGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SessionHandle"

    static const int kSessionHandle = 0;

    /**
     * Clears the field "SessionHandle".
     *
     * The field will be set to its default value. The hasSessionHandle()
     * method will return false.
     */
    inline void clearSessionHandle();

    /**
     * Checks whether the field "SessionHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSessionHandle()). Otherwise it will return false.
     */
    inline bool hasSessionHandle () const;

    /**
     * Returns the value of the member "SessionHandle".
     *
     * Handle to the calibration table for which a session was started.
     *
     * @return The value of the field "SessionHandle"
     */
    inline uint32 getSessionHandle () const;

    /**
     * Sets the value of the member "SessionHandle".
     *
     * Handle to the calibration table for which a session was started.
     *
     * @param SessionHandle The value which will be set
     */
    inline void setSessionHandle (uint32 SessionHandle_);

    // API of field "Name"

    static const int kName = 1;

    /**
     * Clears the field "Name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "Name".
     *
     * Name of the calibration parameter.
     *
     * @return The value of the field "Name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "Name".
     *
     * Name of the calibration parameter.
     *
     * @param Name The value which will be set
     */
    inline void setName (const ::std::string& Name_);

    /**
     * Sets the value of the member "Name".
     *
     * Name of the calibration parameter.
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* Name_);

    /**
     * Sets the value of the member "Name".
     *
     * Name of the calibration parameter.
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const CalibrationParameterGet &getDefaultInstance();

private:

    inline void set_has_SessionHandle ();

    inline void clear_has_SessionHandle ();

    inline void set_has_Name ();

    inline void clear_has_Name ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _SessionHandle;

    ::std::string _Name;

};

/**
 * The status message of the property "PartNumber"
 */
class PartNumberStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PartNumberStatus ();

    /**
     * Copy constructor
     */
    inline  PartNumberStatus (const PartNumberStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PartNumberStatus (uint8 DataIdentifier_, uint32 PartNumber_, const ::midw_diagnostics_fi_types::T_AlphaCode& AlphaCode_);

    /**
     * Destructor
     */
    inline virtual  ~PartNumberStatus();

    /**
     * Assignment operator
     */
    inline PartNumberStatus& operator = (const PartNumberStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PartNumberStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PartNumberStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PartNumberStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PartNumberStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataIdentifier"

    static const int kDataIdentifier = 0;

    /**
     * Clears the field "DataIdentifier".
     *
     * The field will be set to its default value. The hasDataIdentifier()
     * method will return false.
     */
    inline void clearDataIdentifier();

    /**
     * Checks whether the field "DataIdentifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataIdentifier()). Otherwise it will return false.
     */
    inline bool hasDataIdentifier () const;

    /**
     * Returns the value of the member "DataIdentifier".
     *
     * The DID according to GM's Diagnostic Specification for which a Part Number was requested.
     *
     * @return The value of the field "DataIdentifier"
     */
    inline uint8 getDataIdentifier () const;

    /**
     * Sets the value of the member "DataIdentifier".
     *
     * The DID according to GM's Diagnostic Specification for which a Part Number was requested.
     *
     * @param DataIdentifier The value which will be set
     */
    inline void setDataIdentifier (uint8 DataIdentifier_);

    // API of field "PartNumber"

    static const int kPartNumber = 1;

    /**
     * Clears the field "PartNumber".
     *
     * The field will be set to its default value. The hasPartNumber()
     * method will return false.
     */
    inline void clearPartNumber();

    /**
     * Checks whether the field "PartNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPartNumber()). Otherwise it will return false.
     */
    inline bool hasPartNumber () const;

    /**
     * Returns the value of the member "PartNumber".
     *
     * The 32-bit value of the Part Number.
     *
     * @return The value of the field "PartNumber"
     */
    inline uint32 getPartNumber () const;

    /**
     * Sets the value of the member "PartNumber".
     *
     * The 32-bit value of the Part Number.
     *
     * @param PartNumber The value which will be set
     */
    inline void setPartNumber (uint32 PartNumber_);

    // API of field "AlphaCode"

    static const int kAlphaCode = 2;

    /**
     * Clears the field "AlphaCode".
     *
     * The field will be set to its default value. The hasAlphaCode()
     * method will return false.
     */
    inline void clearAlphaCode();

    /**
     * Checks whether the field "AlphaCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlphaCode()). Otherwise it will return false.
     */
    inline bool hasAlphaCode () const;

    /**
     * Returns the value of the member "AlphaCode".
     *
     * The two-letter Alpha Code of the Part Number
     *
     * @return The value of the field "AlphaCode"
     */
    inline const ::midw_diagnostics_fi_types::T_AlphaCode& getAlphaCode () const;

    /**
     * Retrieves the value of the field "AlphaCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlphaCode".
     */
    inline ::midw_diagnostics_fi_types::T_AlphaCode& getAlphaCodeMutable ();

    /**
     * Sets the value of the member "AlphaCode".
     *
     * The two-letter Alpha Code of the Part Number
     *
     * @param AlphaCode The value which will be set
     */
    inline void setAlphaCode (const ::midw_diagnostics_fi_types::T_AlphaCode& AlphaCode_);

    static const PartNumberStatus &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_DataIdentifier ();

    inline void clear_has_DataIdentifier ();

    inline void set_has_PartNumber ();

    inline void clear_has_PartNumber ();

    inline void set_has_AlphaCode ();

    inline void clear_has_AlphaCode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _DataIdentifier;

    uint32 _PartNumber;

    ::midw_diagnostics_fi_types::T_AlphaCode _AlphaCode;

};

/**
 * The set message of the property "PartNumber"
 */
class PartNumberSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PartNumberSet ();

    /**
     * Copy constructor
     */
    inline  PartNumberSet (const PartNumberSet &rhs);

    /**
     * All fields constructor
     */
    inline  PartNumberSet (uint8 DataIdentifier_, uint32 PartNumber_, const ::midw_diagnostics_fi_types::T_AlphaCode& AlphaCode_);

    /**
     * Destructor
     */
    inline virtual  ~PartNumberSet();

    /**
     * Assignment operator
     */
    inline PartNumberSet& operator = (const PartNumberSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PartNumberSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PartNumberSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PartNumberSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PartNumberSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataIdentifier"

    static const int kDataIdentifier = 0;

    /**
     * Clears the field "DataIdentifier".
     *
     * The field will be set to its default value. The hasDataIdentifier()
     * method will return false.
     */
    inline void clearDataIdentifier();

    /**
     * Checks whether the field "DataIdentifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataIdentifier()). Otherwise it will return false.
     */
    inline bool hasDataIdentifier () const;

    /**
     * Returns the value of the member "DataIdentifier".
     *
     * The DID according to GM's Diagnostic Specification for which a Part Number is requested.
     *
     * @return The value of the field "DataIdentifier"
     */
    inline uint8 getDataIdentifier () const;

    /**
     * Sets the value of the member "DataIdentifier".
     *
     * The DID according to GM's Diagnostic Specification for which a Part Number is requested.
     *
     * @param DataIdentifier The value which will be set
     */
    inline void setDataIdentifier (uint8 DataIdentifier_);

    // API of field "PartNumber"

    static const int kPartNumber = 1;

    /**
     * Clears the field "PartNumber".
     *
     * The field will be set to its default value. The hasPartNumber()
     * method will return false.
     */
    inline void clearPartNumber();

    /**
     * Checks whether the field "PartNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPartNumber()). Otherwise it will return false.
     */
    inline bool hasPartNumber () const;

    /**
     * Returns the value of the member "PartNumber".
     *
     * The 32-bit value of the Part Number.
     *
     * @return The value of the field "PartNumber"
     */
    inline uint32 getPartNumber () const;

    /**
     * Sets the value of the member "PartNumber".
     *
     * The 32-bit value of the Part Number.
     *
     * @param PartNumber The value which will be set
     */
    inline void setPartNumber (uint32 PartNumber_);

    // API of field "AlphaCode"

    static const int kAlphaCode = 2;

    /**
     * Clears the field "AlphaCode".
     *
     * The field will be set to its default value. The hasAlphaCode()
     * method will return false.
     */
    inline void clearAlphaCode();

    /**
     * Checks whether the field "AlphaCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlphaCode()). Otherwise it will return false.
     */
    inline bool hasAlphaCode () const;

    /**
     * Returns the value of the member "AlphaCode".
     *
     * The two-letter Alpha Code of the Part Number
     *
     * @return The value of the field "AlphaCode"
     */
    inline const ::midw_diagnostics_fi_types::T_AlphaCode& getAlphaCode () const;

    /**
     * Retrieves the value of the field "AlphaCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlphaCode".
     */
    inline ::midw_diagnostics_fi_types::T_AlphaCode& getAlphaCodeMutable ();

    /**
     * Sets the value of the member "AlphaCode".
     *
     * The two-letter Alpha Code of the Part Number
     *
     * @param AlphaCode The value which will be set
     */
    inline void setAlphaCode (const ::midw_diagnostics_fi_types::T_AlphaCode& AlphaCode_);

    static const PartNumberSet &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_DataIdentifier ();

    inline void clear_has_DataIdentifier ();

    inline void set_has_PartNumber ();

    inline void clear_has_PartNumber ();

    inline void set_has_AlphaCode ();

    inline void clear_has_AlphaCode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _DataIdentifier;

    uint32 _PartNumber;

    ::midw_diagnostics_fi_types::T_AlphaCode _AlphaCode;

};

/**
 * The get message of the property "PartNumber"
 */
class PartNumberGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PartNumberGet ();

    /**
     * Copy constructor
     */
    inline  PartNumberGet (const PartNumberGet &rhs);

    /**
     * All fields constructor
     */
    inline  PartNumberGet (uint8 DataIdentifier_);

    /**
     * Destructor
     */
    inline virtual  ~PartNumberGet();

    /**
     * Assignment operator
     */
    inline PartNumberGet& operator = (const PartNumberGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PartNumberGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PartNumberGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PartNumberGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PartNumberGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataIdentifier"

    static const int kDataIdentifier = 0;

    /**
     * Clears the field "DataIdentifier".
     *
     * The field will be set to its default value. The hasDataIdentifier()
     * method will return false.
     */
    inline void clearDataIdentifier();

    /**
     * Checks whether the field "DataIdentifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataIdentifier()). Otherwise it will return false.
     */
    inline bool hasDataIdentifier () const;

    /**
     * Returns the value of the member "DataIdentifier".
     *
     * The DID according to GM's Diagnostic Specification for which a Part Number is requested.
     *
     * @return The value of the field "DataIdentifier"
     */
    inline uint8 getDataIdentifier () const;

    /**
     * Sets the value of the member "DataIdentifier".
     *
     * The DID according to GM's Diagnostic Specification for which a Part Number is requested.
     *
     * @param DataIdentifier The value which will be set
     */
    inline void setDataIdentifier (uint8 DataIdentifier_);

    static const PartNumberGet &getDefaultInstance();

private:

    inline void set_has_DataIdentifier ();

    inline void clear_has_DataIdentifier ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DataIdentifier;

};

inline  TestMessageStart::TestMessageStart ()  :
    _ProtocolId (0u),
    _MessageBuffer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TestMessageStart::TestMessageStart (const TestMessageStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ProtocolId (0u),
    _MessageBuffer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TestMessageStart::TestMessageStart (uint8 ProtocolId_, const ::midw_diagnostics_fi_types::T_MessageBuffer& MessageBuffer_)  :
    _ProtocolId (ProtocolId_),
    _MessageBuffer (MessageBuffer_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TestMessageStart::~TestMessageStart() {
}

inline TestMessageStart& TestMessageStart::operator = (const TestMessageStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProtocolId()) {
            setProtocolId(rhs.getProtocolId());
        } else {
            clearProtocolId();
        }
        if (rhs.hasMessageBuffer()) {
            setMessageBuffer(rhs.getMessageBuffer());
        } else {
            clearMessageBuffer();
        }
    }
    return *this;
}

inline bool TestMessageStart::operator == (const TestMessageStart& rhs) const {
    return (((!hasProtocolId() && !rhs.hasProtocolId()) || getProtocolId() == rhs.getProtocolId()) &&
        ((!hasMessageBuffer() && !rhs.hasMessageBuffer()) || getMessageBuffer() == rhs.getMessageBuffer()));
}

inline bool TestMessageStart::operator != (const TestMessageStart& rhs) const {
    return ! (*this == rhs);
}

inline bool TestMessageStart::operator < (const TestMessageStart& rhs) const {
    if (hasProtocolId() || rhs.hasProtocolId()) {
        if (getProtocolId() < rhs.getProtocolId()) return true;
        if (getProtocolId() > rhs.getProtocolId()) return false;
    }
    if (hasMessageBuffer() || rhs.hasMessageBuffer()) {
        if (getMessageBuffer() < rhs.getMessageBuffer()) return true;
        if (getMessageBuffer() > rhs.getMessageBuffer()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TestMessageStart::clone() {
    return new TestMessageStart(*this);
}

inline bool TestMessageStart::operator > (const TestMessageStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TestMessageStart::clear() {
    clearProtocolId();
    clearMessageBuffer();
}

inline void TestMessageStart::clearProtocolId() {
    if (hasProtocolId()) {
         clear_has_ProtocolId();
        _ProtocolId = 0u;
     }
}

inline bool TestMessageStart::hasProtocolId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 TestMessageStart::getProtocolId () const {
    return _ProtocolId;
}

inline void TestMessageStart::setProtocolId (uint8 ProtocolId_) {
    set_has_ProtocolId();
    this->_ProtocolId = ProtocolId_;
}

inline void TestMessageStart::clearMessageBuffer() {
    if (hasMessageBuffer()) {
         clear_has_MessageBuffer();
        _MessageBuffer.clear();
     }
}

inline bool TestMessageStart::hasMessageBuffer () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_MessageBuffer& TestMessageStart::getMessageBuffer () const {
    return _MessageBuffer;
}

inline ::midw_diagnostics_fi_types::T_MessageBuffer& TestMessageStart::getMessageBufferMutable () {
    set_has_MessageBuffer();
    return _MessageBuffer;
}

inline void TestMessageStart::setMessageBuffer (const ::midw_diagnostics_fi_types::T_MessageBuffer& MessageBuffer_) {
    set_has_MessageBuffer();
    this->_MessageBuffer = MessageBuffer_;
}

inline void TestMessageStart::set_has_ProtocolId () {
    _has_bits_[0] |= 1u << 0;
}

inline void TestMessageStart::clear_has_ProtocolId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TestMessageStart::set_has_MessageBuffer () {
    _has_bits_[0] |= 1u << 1;
}

inline void TestMessageStart::clear_has_MessageBuffer () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  TestMessageResult::TestMessageResult ()  :
    _ProtocolId (0u),
    _MessageBuffer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TestMessageResult::TestMessageResult (const TestMessageResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ProtocolId (0u),
    _MessageBuffer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TestMessageResult::TestMessageResult (uint8 ProtocolId_, const ::midw_diagnostics_fi_types::T_MessageBuffer& MessageBuffer_)  :
    _ProtocolId (ProtocolId_),
    _MessageBuffer (MessageBuffer_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TestMessageResult::~TestMessageResult() {
}

inline TestMessageResult& TestMessageResult::operator = (const TestMessageResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProtocolId()) {
            setProtocolId(rhs.getProtocolId());
        } else {
            clearProtocolId();
        }
        if (rhs.hasMessageBuffer()) {
            setMessageBuffer(rhs.getMessageBuffer());
        } else {
            clearMessageBuffer();
        }
    }
    return *this;
}

inline bool TestMessageResult::operator == (const TestMessageResult& rhs) const {
    return (((!hasProtocolId() && !rhs.hasProtocolId()) || getProtocolId() == rhs.getProtocolId()) &&
        ((!hasMessageBuffer() && !rhs.hasMessageBuffer()) || getMessageBuffer() == rhs.getMessageBuffer()));
}

inline bool TestMessageResult::operator != (const TestMessageResult& rhs) const {
    return ! (*this == rhs);
}

inline bool TestMessageResult::operator < (const TestMessageResult& rhs) const {
    if (hasProtocolId() || rhs.hasProtocolId()) {
        if (getProtocolId() < rhs.getProtocolId()) return true;
        if (getProtocolId() > rhs.getProtocolId()) return false;
    }
    if (hasMessageBuffer() || rhs.hasMessageBuffer()) {
        if (getMessageBuffer() < rhs.getMessageBuffer()) return true;
        if (getMessageBuffer() > rhs.getMessageBuffer()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TestMessageResult::clone() {
    return new TestMessageResult(*this);
}

inline bool TestMessageResult::operator > (const TestMessageResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TestMessageResult::clear() {
    clearProtocolId();
    clearMessageBuffer();
}

inline void TestMessageResult::clearProtocolId() {
    if (hasProtocolId()) {
         clear_has_ProtocolId();
        _ProtocolId = 0u;
     }
}

inline bool TestMessageResult::hasProtocolId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 TestMessageResult::getProtocolId () const {
    return _ProtocolId;
}

inline void TestMessageResult::setProtocolId (uint8 ProtocolId_) {
    set_has_ProtocolId();
    this->_ProtocolId = ProtocolId_;
}

inline void TestMessageResult::clearMessageBuffer() {
    if (hasMessageBuffer()) {
         clear_has_MessageBuffer();
        _MessageBuffer.clear();
     }
}

inline bool TestMessageResult::hasMessageBuffer () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_MessageBuffer& TestMessageResult::getMessageBuffer () const {
    return _MessageBuffer;
}

inline ::midw_diagnostics_fi_types::T_MessageBuffer& TestMessageResult::getMessageBufferMutable () {
    set_has_MessageBuffer();
    return _MessageBuffer;
}

inline void TestMessageResult::setMessageBuffer (const ::midw_diagnostics_fi_types::T_MessageBuffer& MessageBuffer_) {
    set_has_MessageBuffer();
    this->_MessageBuffer = MessageBuffer_;
}

inline void TestMessageResult::set_has_ProtocolId () {
    _has_bits_[0] |= 1u << 0;
}

inline void TestMessageResult::clear_has_ProtocolId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TestMessageResult::set_has_MessageBuffer () {
    _has_bits_[0] |= 1u << 1;
}

inline void TestMessageResult::clear_has_MessageBuffer () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DiagRequestStart::DiagRequestStart ()  :
    _protID (::midw_diagnostics_fi_types::T_DiagProtocol__Unknown),
    _diagData (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiagRequestStart::DiagRequestStart (const DiagRequestStart &rhs)  :
    ::asf::core::Payload(rhs),
    _protID (::midw_diagnostics_fi_types::T_DiagProtocol__Unknown),
    _diagData (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiagRequestStart::DiagRequestStart (::midw_diagnostics_fi_types::T_DiagProtocol protID_, const ::midw_diagnostics_fi_types::T_DiagData& diagData_, uint32 cookie_)  :
    _protID (protID_),
    _diagData (diagData_),
    _cookie (cookie_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_DiagProtocol_IsValid(protID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", protID_, "T_DiagProtocol", "protID", "DiagRequestStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiagRequestStart::~DiagRequestStart() {
}

inline DiagRequestStart& DiagRequestStart::operator = (const DiagRequestStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProtID()) {
            setProtID(rhs.getProtID());
        } else {
            clearProtID();
        }
        if (rhs.hasDiagData()) {
            setDiagData(rhs.getDiagData());
        } else {
            clearDiagData();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool DiagRequestStart::operator == (const DiagRequestStart& rhs) const {
    return (((!hasProtID() && !rhs.hasProtID()) || getProtID() == rhs.getProtID()) &&
        ((!hasDiagData() && !rhs.hasDiagData()) || getDiagData() == rhs.getDiagData()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool DiagRequestStart::operator != (const DiagRequestStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DiagRequestStart::operator < (const DiagRequestStart& rhs) const {
    if (hasProtID() || rhs.hasProtID()) {
        if ((uint32)getProtID() < (uint32)rhs.getProtID()) return true;
        if ((uint32)getProtID() > (uint32)rhs.getProtID()) return false;
    }
    if (hasDiagData() || rhs.hasDiagData()) {
        if (getDiagData() < rhs.getDiagData()) return true;
        if (getDiagData() > rhs.getDiagData()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiagRequestStart::clone() {
    return new DiagRequestStart(*this);
}

inline bool DiagRequestStart::operator > (const DiagRequestStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiagRequestStart::clear() {
    clearProtID();
    clearDiagData();
    clearCookie();
}

inline void DiagRequestStart::clearProtID() {
    if (hasProtID()) {
         clear_has_protID();
        _protID = ::midw_diagnostics_fi_types::T_DiagProtocol__Unknown;
     }
}

inline bool DiagRequestStart::hasProtID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_DiagProtocol DiagRequestStart::getProtID () const {
    return _protID;
}

inline void DiagRequestStart::setProtID (::midw_diagnostics_fi_types::T_DiagProtocol protID_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_DiagProtocol_IsValid(protID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", protID_, "T_DiagProtocol", "protID", "DiagRequestStart");
    }
    #endif
    set_has_protID();
    this->_protID = protID_;
}

inline void DiagRequestStart::clearDiagData() {
    if (hasDiagData()) {
         clear_has_diagData();
        _diagData.clear();
     }
}

inline bool DiagRequestStart::hasDiagData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_DiagData& DiagRequestStart::getDiagData () const {
    return _diagData;
}

inline ::midw_diagnostics_fi_types::T_DiagData& DiagRequestStart::getDiagDataMutable () {
    set_has_diagData();
    return _diagData;
}

inline void DiagRequestStart::setDiagData (const ::midw_diagnostics_fi_types::T_DiagData& diagData_) {
    set_has_diagData();
    this->_diagData = diagData_;
}

inline void DiagRequestStart::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool DiagRequestStart::hasCookie () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 DiagRequestStart::getCookie () const {
    return _cookie;
}

inline void DiagRequestStart::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void DiagRequestStart::set_has_protID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiagRequestStart::clear_has_protID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiagRequestStart::set_has_diagData () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiagRequestStart::clear_has_diagData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiagRequestStart::set_has_cookie () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiagRequestStart::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DiagRequestResult::DiagRequestResult ()  :
    _protID (::midw_diagnostics_fi_types::T_DiagProtocol__Unknown),
    _diagData (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiagRequestResult::DiagRequestResult (const DiagRequestResult &rhs)  :
    ::asf::core::Payload(rhs),
    _protID (::midw_diagnostics_fi_types::T_DiagProtocol__Unknown),
    _diagData (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiagRequestResult::DiagRequestResult (::midw_diagnostics_fi_types::T_DiagProtocol protID_, const ::midw_diagnostics_fi_types::T_DiagData& diagData_, uint32 cookie_)  :
    _protID (protID_),
    _diagData (diagData_),
    _cookie (cookie_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_DiagProtocol_IsValid(protID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", protID_, "T_DiagProtocol", "protID", "DiagRequestResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiagRequestResult::~DiagRequestResult() {
}

inline DiagRequestResult& DiagRequestResult::operator = (const DiagRequestResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProtID()) {
            setProtID(rhs.getProtID());
        } else {
            clearProtID();
        }
        if (rhs.hasDiagData()) {
            setDiagData(rhs.getDiagData());
        } else {
            clearDiagData();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool DiagRequestResult::operator == (const DiagRequestResult& rhs) const {
    return (((!hasProtID() && !rhs.hasProtID()) || getProtID() == rhs.getProtID()) &&
        ((!hasDiagData() && !rhs.hasDiagData()) || getDiagData() == rhs.getDiagData()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool DiagRequestResult::operator != (const DiagRequestResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DiagRequestResult::operator < (const DiagRequestResult& rhs) const {
    if (hasProtID() || rhs.hasProtID()) {
        if ((uint32)getProtID() < (uint32)rhs.getProtID()) return true;
        if ((uint32)getProtID() > (uint32)rhs.getProtID()) return false;
    }
    if (hasDiagData() || rhs.hasDiagData()) {
        if (getDiagData() < rhs.getDiagData()) return true;
        if (getDiagData() > rhs.getDiagData()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiagRequestResult::clone() {
    return new DiagRequestResult(*this);
}

inline bool DiagRequestResult::operator > (const DiagRequestResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiagRequestResult::clear() {
    clearProtID();
    clearDiagData();
    clearCookie();
}

inline void DiagRequestResult::clearProtID() {
    if (hasProtID()) {
         clear_has_protID();
        _protID = ::midw_diagnostics_fi_types::T_DiagProtocol__Unknown;
     }
}

inline bool DiagRequestResult::hasProtID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_DiagProtocol DiagRequestResult::getProtID () const {
    return _protID;
}

inline void DiagRequestResult::setProtID (::midw_diagnostics_fi_types::T_DiagProtocol protID_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_DiagProtocol_IsValid(protID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", protID_, "T_DiagProtocol", "protID", "DiagRequestResult");
    }
    #endif
    set_has_protID();
    this->_protID = protID_;
}

inline void DiagRequestResult::clearDiagData() {
    if (hasDiagData()) {
         clear_has_diagData();
        _diagData.clear();
     }
}

inline bool DiagRequestResult::hasDiagData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_DiagData& DiagRequestResult::getDiagData () const {
    return _diagData;
}

inline ::midw_diagnostics_fi_types::T_DiagData& DiagRequestResult::getDiagDataMutable () {
    set_has_diagData();
    return _diagData;
}

inline void DiagRequestResult::setDiagData (const ::midw_diagnostics_fi_types::T_DiagData& diagData_) {
    set_has_diagData();
    this->_diagData = diagData_;
}

inline void DiagRequestResult::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool DiagRequestResult::hasCookie () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 DiagRequestResult::getCookie () const {
    return _cookie;
}

inline void DiagRequestResult::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void DiagRequestResult::set_has_protID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiagRequestResult::clear_has_protID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiagRequestResult::set_has_diagData () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiagRequestResult::clear_has_diagData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiagRequestResult::set_has_cookie () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiagRequestResult::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  StartRouteCalculationStatus::StartRouteCalculationStatus ()  :
    _RouteDetails ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartRouteCalculationStatus::StartRouteCalculationStatus (const StartRouteCalculationStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _RouteDetails ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartRouteCalculationStatus::StartRouteCalculationStatus (const ::midw_diagnostics_fi_types::T_RouteCalculationStartParameter& RouteDetails_)  :
    _RouteDetails (RouteDetails_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartRouteCalculationStatus::~StartRouteCalculationStatus() {
}

inline StartRouteCalculationStatus& StartRouteCalculationStatus::operator = (const StartRouteCalculationStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRouteDetails()) {
            setRouteDetails(rhs.getRouteDetails());
        } else {
            clearRouteDetails();
        }
    }
    return *this;
}

inline bool StartRouteCalculationStatus::operator == (const StartRouteCalculationStatus& rhs) const {
    return (((!hasRouteDetails() && !rhs.hasRouteDetails()) || getRouteDetails() == rhs.getRouteDetails()));
}

inline bool StartRouteCalculationStatus::operator != (const StartRouteCalculationStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool StartRouteCalculationStatus::operator < (const StartRouteCalculationStatus& rhs) const {
    if (hasRouteDetails() || rhs.hasRouteDetails()) {
        if (getRouteDetails() < rhs.getRouteDetails()) return true;
        if (getRouteDetails() > rhs.getRouteDetails()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartRouteCalculationStatus::clone() {
    return new StartRouteCalculationStatus(*this);
}

inline bool StartRouteCalculationStatus::operator > (const StartRouteCalculationStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartRouteCalculationStatus::clear() {
    clearRouteDetails();
}

inline void StartRouteCalculationStatus::clearRouteDetails() {
    if (hasRouteDetails()) {
         clear_has_RouteDetails();
        _RouteDetails.clear();
     }
}

inline bool StartRouteCalculationStatus::hasRouteDetails () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_RouteCalculationStartParameter& StartRouteCalculationStatus::getRouteDetails () const {
    return _RouteDetails;
}

inline ::midw_diagnostics_fi_types::T_RouteCalculationStartParameter& StartRouteCalculationStatus::getRouteDetailsMutable () {
    set_has_RouteDetails();
    return _RouteDetails;
}

inline void StartRouteCalculationStatus::setRouteDetails (const ::midw_diagnostics_fi_types::T_RouteCalculationStartParameter& RouteDetails_) {
    set_has_RouteDetails();
    this->_RouteDetails = RouteDetails_;
}

inline void StartRouteCalculationStatus::set_has_RouteDetails () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartRouteCalculationStatus::clear_has_RouteDetails () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartRouteCalculationSet::StartRouteCalculationSet ()  :
    _CalculationStarted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartRouteCalculationSet::StartRouteCalculationSet (const StartRouteCalculationSet &rhs)  :
    ::asf::core::Payload(rhs),
    _CalculationStarted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartRouteCalculationSet::StartRouteCalculationSet (bool CalculationStarted_)  :
    _CalculationStarted (CalculationStarted_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartRouteCalculationSet::~StartRouteCalculationSet() {
}

inline StartRouteCalculationSet& StartRouteCalculationSet::operator = (const StartRouteCalculationSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCalculationStarted()) {
            setCalculationStarted(rhs.getCalculationStarted());
        } else {
            clearCalculationStarted();
        }
    }
    return *this;
}

inline bool StartRouteCalculationSet::operator == (const StartRouteCalculationSet& rhs) const {
    return (((!hasCalculationStarted() && !rhs.hasCalculationStarted()) || getCalculationStarted() == rhs.getCalculationStarted()));
}

inline bool StartRouteCalculationSet::operator != (const StartRouteCalculationSet& rhs) const {
    return ! (*this == rhs);
}

inline bool StartRouteCalculationSet::operator < (const StartRouteCalculationSet& rhs) const {
    if (hasCalculationStarted() || rhs.hasCalculationStarted()) {
        if (getCalculationStarted() < rhs.getCalculationStarted()) return true;
        if (getCalculationStarted() > rhs.getCalculationStarted()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartRouteCalculationSet::clone() {
    return new StartRouteCalculationSet(*this);
}

inline bool StartRouteCalculationSet::operator > (const StartRouteCalculationSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartRouteCalculationSet::clear() {
    clearCalculationStarted();
}

inline void StartRouteCalculationSet::clearCalculationStarted() {
    if (hasCalculationStarted()) {
         clear_has_CalculationStarted();
        _CalculationStarted = false;
     }
}

inline bool StartRouteCalculationSet::hasCalculationStarted () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool StartRouteCalculationSet::getCalculationStarted () const {
    return _CalculationStarted;
}

inline void StartRouteCalculationSet::setCalculationStarted (bool CalculationStarted_) {
    set_has_CalculationStarted();
    this->_CalculationStarted = CalculationStarted_;
}

inline void StartRouteCalculationSet::set_has_CalculationStarted () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartRouteCalculationSet::clear_has_CalculationStarted () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RouteCalculationResultStatus::RouteCalculationResultStatus ()  :
    _CalculationResultRequested (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RouteCalculationResultStatus::RouteCalculationResultStatus (const RouteCalculationResultStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _CalculationResultRequested (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RouteCalculationResultStatus::RouteCalculationResultStatus (bool CalculationResultRequested_)  :
    _CalculationResultRequested (CalculationResultRequested_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RouteCalculationResultStatus::~RouteCalculationResultStatus() {
}

inline RouteCalculationResultStatus& RouteCalculationResultStatus::operator = (const RouteCalculationResultStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCalculationResultRequested()) {
            setCalculationResultRequested(rhs.getCalculationResultRequested());
        } else {
            clearCalculationResultRequested();
        }
    }
    return *this;
}

inline bool RouteCalculationResultStatus::operator == (const RouteCalculationResultStatus& rhs) const {
    return (((!hasCalculationResultRequested() && !rhs.hasCalculationResultRequested()) || getCalculationResultRequested() == rhs.getCalculationResultRequested()));
}

inline bool RouteCalculationResultStatus::operator != (const RouteCalculationResultStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool RouteCalculationResultStatus::operator < (const RouteCalculationResultStatus& rhs) const {
    if (hasCalculationResultRequested() || rhs.hasCalculationResultRequested()) {
        if (getCalculationResultRequested() < rhs.getCalculationResultRequested()) return true;
        if (getCalculationResultRequested() > rhs.getCalculationResultRequested()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RouteCalculationResultStatus::clone() {
    return new RouteCalculationResultStatus(*this);
}

inline bool RouteCalculationResultStatus::operator > (const RouteCalculationResultStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RouteCalculationResultStatus::clear() {
    clearCalculationResultRequested();
}

inline void RouteCalculationResultStatus::clearCalculationResultRequested() {
    if (hasCalculationResultRequested()) {
         clear_has_CalculationResultRequested();
        _CalculationResultRequested = false;
     }
}

inline bool RouteCalculationResultStatus::hasCalculationResultRequested () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RouteCalculationResultStatus::getCalculationResultRequested () const {
    return _CalculationResultRequested;
}

inline void RouteCalculationResultStatus::setCalculationResultRequested (bool CalculationResultRequested_) {
    set_has_CalculationResultRequested();
    this->_CalculationResultRequested = CalculationResultRequested_;
}

inline void RouteCalculationResultStatus::set_has_CalculationResultRequested () {
    _has_bits_[0] |= 1u << 0;
}

inline void RouteCalculationResultStatus::clear_has_CalculationResultRequested () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RouteCalculationResultSet::RouteCalculationResultSet ()  :
    _CalculationResult ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RouteCalculationResultSet::RouteCalculationResultSet (const RouteCalculationResultSet &rhs)  :
    ::asf::core::Payload(rhs),
    _CalculationResult ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RouteCalculationResultSet::RouteCalculationResultSet (const ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& CalculationResult_)  :
    _CalculationResult (CalculationResult_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RouteCalculationResultSet::~RouteCalculationResultSet() {
}

inline RouteCalculationResultSet& RouteCalculationResultSet::operator = (const RouteCalculationResultSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCalculationResult()) {
            setCalculationResult(rhs.getCalculationResult());
        } else {
            clearCalculationResult();
        }
    }
    return *this;
}

inline bool RouteCalculationResultSet::operator == (const RouteCalculationResultSet& rhs) const {
    return (((!hasCalculationResult() && !rhs.hasCalculationResult()) || getCalculationResult() == rhs.getCalculationResult()));
}

inline bool RouteCalculationResultSet::operator != (const RouteCalculationResultSet& rhs) const {
    return ! (*this == rhs);
}

inline bool RouteCalculationResultSet::operator < (const RouteCalculationResultSet& rhs) const {
    if (hasCalculationResult() || rhs.hasCalculationResult()) {
        if (getCalculationResult() < rhs.getCalculationResult()) return true;
        if (getCalculationResult() > rhs.getCalculationResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RouteCalculationResultSet::clone() {
    return new RouteCalculationResultSet(*this);
}

inline bool RouteCalculationResultSet::operator > (const RouteCalculationResultSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RouteCalculationResultSet::clear() {
    clearCalculationResult();
}

inline void RouteCalculationResultSet::clearCalculationResult() {
    if (hasCalculationResult()) {
         clear_has_CalculationResult();
        _CalculationResult.clear();
     }
}

inline bool RouteCalculationResultSet::hasCalculationResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& RouteCalculationResultSet::getCalculationResult () const {
    return _CalculationResult;
}

inline ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& RouteCalculationResultSet::getCalculationResultMutable () {
    set_has_CalculationResult();
    return _CalculationResult;
}

inline void RouteCalculationResultSet::setCalculationResult (const ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& CalculationResult_) {
    set_has_CalculationResult();
    this->_CalculationResult = CalculationResult_;
}

inline void RouteCalculationResultSet::set_has_CalculationResult () {
    _has_bits_[0] |= 1u << 0;
}

inline void RouteCalculationResultSet::clear_has_CalculationResult () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetLocaleStartStatus::SetLocaleStartStatus ()  :
    _CountryLanguage (),
    _Store (::midw_diagnostics_fi_types::T_e8_Store__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetLocaleStartStatus::SetLocaleStartStatus (const SetLocaleStartStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _CountryLanguage (),
    _Store (::midw_diagnostics_fi_types::T_e8_Store__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetLocaleStartStatus::SetLocaleStartStatus (const ::midw_diagnostics_fi_types::T_CountryLanguage& CountryLanguage_, ::midw_diagnostics_fi_types::T_e8_Store Store_)  :
    _CountryLanguage (CountryLanguage_),
    _Store (Store_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_Store_IsValid(Store_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Store_, "T_e8_Store", "Store", "SetLocaleStartStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetLocaleStartStatus::~SetLocaleStartStatus() {
}

inline SetLocaleStartStatus& SetLocaleStartStatus::operator = (const SetLocaleStartStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCountryLanguage()) {
            setCountryLanguage(rhs.getCountryLanguage());
        } else {
            clearCountryLanguage();
        }
        if (rhs.hasStore()) {
            setStore(rhs.getStore());
        } else {
            clearStore();
        }
    }
    return *this;
}

inline bool SetLocaleStartStatus::operator == (const SetLocaleStartStatus& rhs) const {
    return (((!hasCountryLanguage() && !rhs.hasCountryLanguage()) || getCountryLanguage() == rhs.getCountryLanguage()) &&
        ((!hasStore() && !rhs.hasStore()) || getStore() == rhs.getStore()));
}

inline bool SetLocaleStartStatus::operator != (const SetLocaleStartStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SetLocaleStartStatus::operator < (const SetLocaleStartStatus& rhs) const {
    if (hasCountryLanguage() || rhs.hasCountryLanguage()) {
        if (getCountryLanguage() < rhs.getCountryLanguage()) return true;
        if (getCountryLanguage() > rhs.getCountryLanguage()) return false;
    }
    if (hasStore() || rhs.hasStore()) {
        if ((uint32)getStore() < (uint32)rhs.getStore()) return true;
        if ((uint32)getStore() > (uint32)rhs.getStore()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetLocaleStartStatus::clone() {
    return new SetLocaleStartStatus(*this);
}

inline bool SetLocaleStartStatus::operator > (const SetLocaleStartStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetLocaleStartStatus::clear() {
    clearCountryLanguage();
    clearStore();
}

inline void SetLocaleStartStatus::clearCountryLanguage() {
    if (hasCountryLanguage()) {
         clear_has_CountryLanguage();
        _CountryLanguage.clear();
     }
}

inline bool SetLocaleStartStatus::hasCountryLanguage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_CountryLanguage& SetLocaleStartStatus::getCountryLanguage () const {
    return _CountryLanguage;
}

inline ::midw_diagnostics_fi_types::T_CountryLanguage& SetLocaleStartStatus::getCountryLanguageMutable () {
    set_has_CountryLanguage();
    return _CountryLanguage;
}

inline void SetLocaleStartStatus::setCountryLanguage (const ::midw_diagnostics_fi_types::T_CountryLanguage& CountryLanguage_) {
    set_has_CountryLanguage();
    this->_CountryLanguage = CountryLanguage_;
}

inline void SetLocaleStartStatus::clearStore() {
    if (hasStore()) {
         clear_has_Store();
        _Store = ::midw_diagnostics_fi_types::T_e8_Store__Undefined;
     }
}

inline bool SetLocaleStartStatus::hasStore () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_Store SetLocaleStartStatus::getStore () const {
    return _Store;
}

inline void SetLocaleStartStatus::setStore (::midw_diagnostics_fi_types::T_e8_Store Store_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_Store_IsValid(Store_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Store_, "T_e8_Store", "Store", "SetLocaleStartStatus");
    }
    #endif
    set_has_Store();
    this->_Store = Store_;
}

inline void SetLocaleStartStatus::set_has_CountryLanguage () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetLocaleStartStatus::clear_has_CountryLanguage () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetLocaleStartStatus::set_has_Store () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetLocaleStartStatus::clear_has_Store () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetLocaleStartSet::SetLocaleStartSet ()  :
    _LocaleSwitched (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetLocaleStartSet::SetLocaleStartSet (const SetLocaleStartSet &rhs)  :
    ::asf::core::Payload(rhs),
    _LocaleSwitched (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetLocaleStartSet::SetLocaleStartSet (bool LocaleSwitched_)  :
    _LocaleSwitched (LocaleSwitched_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetLocaleStartSet::~SetLocaleStartSet() {
}

inline SetLocaleStartSet& SetLocaleStartSet::operator = (const SetLocaleStartSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLocaleSwitched()) {
            setLocaleSwitched(rhs.getLocaleSwitched());
        } else {
            clearLocaleSwitched();
        }
    }
    return *this;
}

inline bool SetLocaleStartSet::operator == (const SetLocaleStartSet& rhs) const {
    return (((!hasLocaleSwitched() && !rhs.hasLocaleSwitched()) || getLocaleSwitched() == rhs.getLocaleSwitched()));
}

inline bool SetLocaleStartSet::operator != (const SetLocaleStartSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SetLocaleStartSet::operator < (const SetLocaleStartSet& rhs) const {
    if (hasLocaleSwitched() || rhs.hasLocaleSwitched()) {
        if (getLocaleSwitched() < rhs.getLocaleSwitched()) return true;
        if (getLocaleSwitched() > rhs.getLocaleSwitched()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetLocaleStartSet::clone() {
    return new SetLocaleStartSet(*this);
}

inline bool SetLocaleStartSet::operator > (const SetLocaleStartSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetLocaleStartSet::clear() {
    clearLocaleSwitched();
}

inline void SetLocaleStartSet::clearLocaleSwitched() {
    if (hasLocaleSwitched()) {
         clear_has_LocaleSwitched();
        _LocaleSwitched = false;
     }
}

inline bool SetLocaleStartSet::hasLocaleSwitched () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetLocaleStartSet::getLocaleSwitched () const {
    return _LocaleSwitched;
}

inline void SetLocaleStartSet::setLocaleSwitched (bool LocaleSwitched_) {
    set_has_LocaleSwitched();
    this->_LocaleSwitched = LocaleSwitched_;
}

inline void SetLocaleStartSet::set_has_LocaleSwitched () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetLocaleStartSet::clear_has_LocaleSwitched () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetLocaleResultStatus::SetLocaleResultStatus ()  :
    _SetLocaleResultRequested (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetLocaleResultStatus::SetLocaleResultStatus (const SetLocaleResultStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _SetLocaleResultRequested (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetLocaleResultStatus::SetLocaleResultStatus (bool SetLocaleResultRequested_)  :
    _SetLocaleResultRequested (SetLocaleResultRequested_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetLocaleResultStatus::~SetLocaleResultStatus() {
}

inline SetLocaleResultStatus& SetLocaleResultStatus::operator = (const SetLocaleResultStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSetLocaleResultRequested()) {
            setSetLocaleResultRequested(rhs.getSetLocaleResultRequested());
        } else {
            clearSetLocaleResultRequested();
        }
    }
    return *this;
}

inline bool SetLocaleResultStatus::operator == (const SetLocaleResultStatus& rhs) const {
    return (((!hasSetLocaleResultRequested() && !rhs.hasSetLocaleResultRequested()) || getSetLocaleResultRequested() == rhs.getSetLocaleResultRequested()));
}

inline bool SetLocaleResultStatus::operator != (const SetLocaleResultStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SetLocaleResultStatus::operator < (const SetLocaleResultStatus& rhs) const {
    if (hasSetLocaleResultRequested() || rhs.hasSetLocaleResultRequested()) {
        if (getSetLocaleResultRequested() < rhs.getSetLocaleResultRequested()) return true;
        if (getSetLocaleResultRequested() > rhs.getSetLocaleResultRequested()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetLocaleResultStatus::clone() {
    return new SetLocaleResultStatus(*this);
}

inline bool SetLocaleResultStatus::operator > (const SetLocaleResultStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetLocaleResultStatus::clear() {
    clearSetLocaleResultRequested();
}

inline void SetLocaleResultStatus::clearSetLocaleResultRequested() {
    if (hasSetLocaleResultRequested()) {
         clear_has_SetLocaleResultRequested();
        _SetLocaleResultRequested = false;
     }
}

inline bool SetLocaleResultStatus::hasSetLocaleResultRequested () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetLocaleResultStatus::getSetLocaleResultRequested () const {
    return _SetLocaleResultRequested;
}

inline void SetLocaleResultStatus::setSetLocaleResultRequested (bool SetLocaleResultRequested_) {
    set_has_SetLocaleResultRequested();
    this->_SetLocaleResultRequested = SetLocaleResultRequested_;
}

inline void SetLocaleResultStatus::set_has_SetLocaleResultRequested () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetLocaleResultStatus::clear_has_SetLocaleResultRequested () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetLocaleResultSet::SetLocaleResultSet ()  :
    _CountryLanguageResult ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetLocaleResultSet::SetLocaleResultSet (const SetLocaleResultSet &rhs)  :
    ::asf::core::Payload(rhs),
    _CountryLanguageResult ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetLocaleResultSet::SetLocaleResultSet (const ::midw_diagnostics_fi_types::T_CountryLanguageResult& CountryLanguageResult_)  :
    _CountryLanguageResult (CountryLanguageResult_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetLocaleResultSet::~SetLocaleResultSet() {
}

inline SetLocaleResultSet& SetLocaleResultSet::operator = (const SetLocaleResultSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCountryLanguageResult()) {
            setCountryLanguageResult(rhs.getCountryLanguageResult());
        } else {
            clearCountryLanguageResult();
        }
    }
    return *this;
}

inline bool SetLocaleResultSet::operator == (const SetLocaleResultSet& rhs) const {
    return (((!hasCountryLanguageResult() && !rhs.hasCountryLanguageResult()) || getCountryLanguageResult() == rhs.getCountryLanguageResult()));
}

inline bool SetLocaleResultSet::operator != (const SetLocaleResultSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SetLocaleResultSet::operator < (const SetLocaleResultSet& rhs) const {
    if (hasCountryLanguageResult() || rhs.hasCountryLanguageResult()) {
        if (getCountryLanguageResult() < rhs.getCountryLanguageResult()) return true;
        if (getCountryLanguageResult() > rhs.getCountryLanguageResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetLocaleResultSet::clone() {
    return new SetLocaleResultSet(*this);
}

inline bool SetLocaleResultSet::operator > (const SetLocaleResultSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetLocaleResultSet::clear() {
    clearCountryLanguageResult();
}

inline void SetLocaleResultSet::clearCountryLanguageResult() {
    if (hasCountryLanguageResult()) {
         clear_has_CountryLanguageResult();
        _CountryLanguageResult.clear();
     }
}

inline bool SetLocaleResultSet::hasCountryLanguageResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_CountryLanguageResult& SetLocaleResultSet::getCountryLanguageResult () const {
    return _CountryLanguageResult;
}

inline ::midw_diagnostics_fi_types::T_CountryLanguageResult& SetLocaleResultSet::getCountryLanguageResultMutable () {
    set_has_CountryLanguageResult();
    return _CountryLanguageResult;
}

inline void SetLocaleResultSet::setCountryLanguageResult (const ::midw_diagnostics_fi_types::T_CountryLanguageResult& CountryLanguageResult_) {
    set_has_CountryLanguageResult();
    this->_CountryLanguageResult = CountryLanguageResult_;
}

inline void SetLocaleResultSet::set_has_CountryLanguageResult () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetLocaleResultSet::clear_has_CountryLanguageResult () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetLocaleStatus::GetLocaleStatus ()  :
    _GetLocaleRequested (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetLocaleStatus::GetLocaleStatus (const GetLocaleStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _GetLocaleRequested (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetLocaleStatus::GetLocaleStatus (bool GetLocaleRequested_)  :
    _GetLocaleRequested (GetLocaleRequested_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetLocaleStatus::~GetLocaleStatus() {
}

inline GetLocaleStatus& GetLocaleStatus::operator = (const GetLocaleStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGetLocaleRequested()) {
            setGetLocaleRequested(rhs.getGetLocaleRequested());
        } else {
            clearGetLocaleRequested();
        }
    }
    return *this;
}

inline bool GetLocaleStatus::operator == (const GetLocaleStatus& rhs) const {
    return (((!hasGetLocaleRequested() && !rhs.hasGetLocaleRequested()) || getGetLocaleRequested() == rhs.getGetLocaleRequested()));
}

inline bool GetLocaleStatus::operator != (const GetLocaleStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool GetLocaleStatus::operator < (const GetLocaleStatus& rhs) const {
    if (hasGetLocaleRequested() || rhs.hasGetLocaleRequested()) {
        if (getGetLocaleRequested() < rhs.getGetLocaleRequested()) return true;
        if (getGetLocaleRequested() > rhs.getGetLocaleRequested()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetLocaleStatus::clone() {
    return new GetLocaleStatus(*this);
}

inline bool GetLocaleStatus::operator > (const GetLocaleStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetLocaleStatus::clear() {
    clearGetLocaleRequested();
}

inline void GetLocaleStatus::clearGetLocaleRequested() {
    if (hasGetLocaleRequested()) {
         clear_has_GetLocaleRequested();
        _GetLocaleRequested = false;
     }
}

inline bool GetLocaleStatus::hasGetLocaleRequested () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool GetLocaleStatus::getGetLocaleRequested () const {
    return _GetLocaleRequested;
}

inline void GetLocaleStatus::setGetLocaleRequested (bool GetLocaleRequested_) {
    set_has_GetLocaleRequested();
    this->_GetLocaleRequested = GetLocaleRequested_;
}

inline void GetLocaleStatus::set_has_GetLocaleRequested () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetLocaleStatus::clear_has_GetLocaleRequested () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetLocaleSet::GetLocaleSet ()  :
    _CountryLanguage ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetLocaleSet::GetLocaleSet (const GetLocaleSet &rhs)  :
    ::asf::core::Payload(rhs),
    _CountryLanguage ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetLocaleSet::GetLocaleSet (const ::midw_diagnostics_fi_types::T_CountryLanguage& CountryLanguage_)  :
    _CountryLanguage (CountryLanguage_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetLocaleSet::~GetLocaleSet() {
}

inline GetLocaleSet& GetLocaleSet::operator = (const GetLocaleSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCountryLanguage()) {
            setCountryLanguage(rhs.getCountryLanguage());
        } else {
            clearCountryLanguage();
        }
    }
    return *this;
}

inline bool GetLocaleSet::operator == (const GetLocaleSet& rhs) const {
    return (((!hasCountryLanguage() && !rhs.hasCountryLanguage()) || getCountryLanguage() == rhs.getCountryLanguage()));
}

inline bool GetLocaleSet::operator != (const GetLocaleSet& rhs) const {
    return ! (*this == rhs);
}

inline bool GetLocaleSet::operator < (const GetLocaleSet& rhs) const {
    if (hasCountryLanguage() || rhs.hasCountryLanguage()) {
        if (getCountryLanguage() < rhs.getCountryLanguage()) return true;
        if (getCountryLanguage() > rhs.getCountryLanguage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetLocaleSet::clone() {
    return new GetLocaleSet(*this);
}

inline bool GetLocaleSet::operator > (const GetLocaleSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetLocaleSet::clear() {
    clearCountryLanguage();
}

inline void GetLocaleSet::clearCountryLanguage() {
    if (hasCountryLanguage()) {
         clear_has_CountryLanguage();
        _CountryLanguage.clear();
     }
}

inline bool GetLocaleSet::hasCountryLanguage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_CountryLanguage& GetLocaleSet::getCountryLanguage () const {
    return _CountryLanguage;
}

inline ::midw_diagnostics_fi_types::T_CountryLanguage& GetLocaleSet::getCountryLanguageMutable () {
    set_has_CountryLanguage();
    return _CountryLanguage;
}

inline void GetLocaleSet::setCountryLanguage (const ::midw_diagnostics_fi_types::T_CountryLanguage& CountryLanguage_) {
    set_has_CountryLanguage();
    this->_CountryLanguage = CountryLanguage_;
}

inline void GetLocaleSet::set_has_CountryLanguage () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetLocaleSet::clear_has_CountryLanguage () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetDisplayStatus::SetDisplayStatus ()  :
    _DisplayData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetDisplayStatus::SetDisplayStatus (const SetDisplayStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DisplayData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetDisplayStatus::SetDisplayStatus (const ::midw_diagnostics_fi_types::T_DisplayData& DisplayData_)  :
    _DisplayData (DisplayData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetDisplayStatus::~SetDisplayStatus() {
}

inline SetDisplayStatus& SetDisplayStatus::operator = (const SetDisplayStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDisplayData()) {
            setDisplayData(rhs.getDisplayData());
        } else {
            clearDisplayData();
        }
    }
    return *this;
}

inline bool SetDisplayStatus::operator == (const SetDisplayStatus& rhs) const {
    return (((!hasDisplayData() && !rhs.hasDisplayData()) || getDisplayData() == rhs.getDisplayData()));
}

inline bool SetDisplayStatus::operator != (const SetDisplayStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SetDisplayStatus::operator < (const SetDisplayStatus& rhs) const {
    if (hasDisplayData() || rhs.hasDisplayData()) {
        if (getDisplayData() < rhs.getDisplayData()) return true;
        if (getDisplayData() > rhs.getDisplayData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetDisplayStatus::clone() {
    return new SetDisplayStatus(*this);
}

inline bool SetDisplayStatus::operator > (const SetDisplayStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetDisplayStatus::clear() {
    clearDisplayData();
}

inline void SetDisplayStatus::clearDisplayData() {
    if (hasDisplayData()) {
         clear_has_DisplayData();
        _DisplayData.clear();
     }
}

inline bool SetDisplayStatus::hasDisplayData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_DisplayData& SetDisplayStatus::getDisplayData () const {
    return _DisplayData;
}

inline ::midw_diagnostics_fi_types::T_DisplayData& SetDisplayStatus::getDisplayDataMutable () {
    set_has_DisplayData();
    return _DisplayData;
}

inline void SetDisplayStatus::setDisplayData (const ::midw_diagnostics_fi_types::T_DisplayData& DisplayData_) {
    set_has_DisplayData();
    this->_DisplayData = DisplayData_;
}

inline void SetDisplayStatus::set_has_DisplayData () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetDisplayStatus::clear_has_DisplayData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetDisplaySet::SetDisplaySet ()  :
    _DisplayTestSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetDisplaySet::SetDisplaySet (const SetDisplaySet &rhs)  :
    ::asf::core::Payload(rhs),
    _DisplayTestSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetDisplaySet::SetDisplaySet (bool DisplayTestSuccess_)  :
    _DisplayTestSuccess (DisplayTestSuccess_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetDisplaySet::~SetDisplaySet() {
}

inline SetDisplaySet& SetDisplaySet::operator = (const SetDisplaySet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDisplayTestSuccess()) {
            setDisplayTestSuccess(rhs.getDisplayTestSuccess());
        } else {
            clearDisplayTestSuccess();
        }
    }
    return *this;
}

inline bool SetDisplaySet::operator == (const SetDisplaySet& rhs) const {
    return (((!hasDisplayTestSuccess() && !rhs.hasDisplayTestSuccess()) || getDisplayTestSuccess() == rhs.getDisplayTestSuccess()));
}

inline bool SetDisplaySet::operator != (const SetDisplaySet& rhs) const {
    return ! (*this == rhs);
}

inline bool SetDisplaySet::operator < (const SetDisplaySet& rhs) const {
    if (hasDisplayTestSuccess() || rhs.hasDisplayTestSuccess()) {
        if (getDisplayTestSuccess() < rhs.getDisplayTestSuccess()) return true;
        if (getDisplayTestSuccess() > rhs.getDisplayTestSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetDisplaySet::clone() {
    return new SetDisplaySet(*this);
}

inline bool SetDisplaySet::operator > (const SetDisplaySet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetDisplaySet::clear() {
    clearDisplayTestSuccess();
}

inline void SetDisplaySet::clearDisplayTestSuccess() {
    if (hasDisplayTestSuccess()) {
         clear_has_DisplayTestSuccess();
        _DisplayTestSuccess = false;
     }
}

inline bool SetDisplaySet::hasDisplayTestSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetDisplaySet::getDisplayTestSuccess () const {
    return _DisplayTestSuccess;
}

inline void SetDisplaySet::setDisplayTestSuccess (bool DisplayTestSuccess_) {
    set_has_DisplayTestSuccess();
    this->_DisplayTestSuccess = DisplayTestSuccess_;
}

inline void SetDisplaySet::set_has_DisplayTestSuccess () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetDisplaySet::clear_has_DisplayTestSuccess () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConfigUpdateViaUSBStatus::ConfigUpdateViaUSBStatus ()  :
    _ConfigUpdateStatus (::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConfigUpdateViaUSBStatus::ConfigUpdateViaUSBStatus (const ConfigUpdateViaUSBStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ConfigUpdateStatus (::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConfigUpdateViaUSBStatus::ConfigUpdateViaUSBStatus (::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus ConfigUpdateStatus_)  :
    _ConfigUpdateStatus (ConfigUpdateStatus_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus_IsValid(ConfigUpdateStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ConfigUpdateStatus_, "T_e8_KdsViaUsbUpdateStatus", "ConfigUpdateStatus", "ConfigUpdateViaUSBStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConfigUpdateViaUSBStatus::~ConfigUpdateViaUSBStatus() {
}

inline ConfigUpdateViaUSBStatus& ConfigUpdateViaUSBStatus::operator = (const ConfigUpdateViaUSBStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfigUpdateStatus()) {
            setConfigUpdateStatus(rhs.getConfigUpdateStatus());
        } else {
            clearConfigUpdateStatus();
        }
    }
    return *this;
}

inline bool ConfigUpdateViaUSBStatus::operator == (const ConfigUpdateViaUSBStatus& rhs) const {
    return (((!hasConfigUpdateStatus() && !rhs.hasConfigUpdateStatus()) || getConfigUpdateStatus() == rhs.getConfigUpdateStatus()));
}

inline bool ConfigUpdateViaUSBStatus::operator != (const ConfigUpdateViaUSBStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ConfigUpdateViaUSBStatus::operator < (const ConfigUpdateViaUSBStatus& rhs) const {
    if (hasConfigUpdateStatus() || rhs.hasConfigUpdateStatus()) {
        if ((uint32)getConfigUpdateStatus() < (uint32)rhs.getConfigUpdateStatus()) return true;
        if ((uint32)getConfigUpdateStatus() > (uint32)rhs.getConfigUpdateStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConfigUpdateViaUSBStatus::clone() {
    return new ConfigUpdateViaUSBStatus(*this);
}

inline bool ConfigUpdateViaUSBStatus::operator > (const ConfigUpdateViaUSBStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConfigUpdateViaUSBStatus::clear() {
    clearConfigUpdateStatus();
}

inline void ConfigUpdateViaUSBStatus::clearConfigUpdateStatus() {
    if (hasConfigUpdateStatus()) {
         clear_has_ConfigUpdateStatus();
        _ConfigUpdateStatus = ::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus__Undefined;
     }
}

inline bool ConfigUpdateViaUSBStatus::hasConfigUpdateStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus ConfigUpdateViaUSBStatus::getConfigUpdateStatus () const {
    return _ConfigUpdateStatus;
}

inline void ConfigUpdateViaUSBStatus::setConfigUpdateStatus (::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus ConfigUpdateStatus_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_KdsViaUsbUpdateStatus_IsValid(ConfigUpdateStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ConfigUpdateStatus_, "T_e8_KdsViaUsbUpdateStatus", "ConfigUpdateStatus", "ConfigUpdateViaUSBStatus");
    }
    #endif
    set_has_ConfigUpdateStatus();
    this->_ConfigUpdateStatus = ConfigUpdateStatus_;
}

inline void ConfigUpdateViaUSBStatus::set_has_ConfigUpdateStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConfigUpdateViaUSBStatus::clear_has_ConfigUpdateStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AntiTheftStatusSet::AntiTheftStatusSet ()  :
    _AntiTheftStatus (::midw_diagnostics_fi_types::T_AntiTheftStatus__HU_UNLOCKED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AntiTheftStatusSet::AntiTheftStatusSet (const AntiTheftStatusSet &rhs)  :
    ::asf::core::Payload(rhs),
    _AntiTheftStatus (::midw_diagnostics_fi_types::T_AntiTheftStatus__HU_UNLOCKED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AntiTheftStatusSet::AntiTheftStatusSet (::midw_diagnostics_fi_types::T_AntiTheftStatus AntiTheftStatus_)  :
    _AntiTheftStatus (AntiTheftStatus_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_AntiTheftStatus_IsValid(AntiTheftStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AntiTheftStatus_, "T_AntiTheftStatus", "AntiTheftStatus", "AntiTheftStatusSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AntiTheftStatusSet::~AntiTheftStatusSet() {
}

inline AntiTheftStatusSet& AntiTheftStatusSet::operator = (const AntiTheftStatusSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAntiTheftStatus()) {
            setAntiTheftStatus(rhs.getAntiTheftStatus());
        } else {
            clearAntiTheftStatus();
        }
    }
    return *this;
}

inline bool AntiTheftStatusSet::operator == (const AntiTheftStatusSet& rhs) const {
    return (((!hasAntiTheftStatus() && !rhs.hasAntiTheftStatus()) || getAntiTheftStatus() == rhs.getAntiTheftStatus()));
}

inline bool AntiTheftStatusSet::operator != (const AntiTheftStatusSet& rhs) const {
    return ! (*this == rhs);
}

inline bool AntiTheftStatusSet::operator < (const AntiTheftStatusSet& rhs) const {
    if (hasAntiTheftStatus() || rhs.hasAntiTheftStatus()) {
        if ((uint32)getAntiTheftStatus() < (uint32)rhs.getAntiTheftStatus()) return true;
        if ((uint32)getAntiTheftStatus() > (uint32)rhs.getAntiTheftStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AntiTheftStatusSet::clone() {
    return new AntiTheftStatusSet(*this);
}

inline bool AntiTheftStatusSet::operator > (const AntiTheftStatusSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AntiTheftStatusSet::clear() {
    clearAntiTheftStatus();
}

inline void AntiTheftStatusSet::clearAntiTheftStatus() {
    if (hasAntiTheftStatus()) {
         clear_has_AntiTheftStatus();
        _AntiTheftStatus = ::midw_diagnostics_fi_types::T_AntiTheftStatus__HU_UNLOCKED;
     }
}

inline bool AntiTheftStatusSet::hasAntiTheftStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_AntiTheftStatus AntiTheftStatusSet::getAntiTheftStatus () const {
    return _AntiTheftStatus;
}

inline void AntiTheftStatusSet::setAntiTheftStatus (::midw_diagnostics_fi_types::T_AntiTheftStatus AntiTheftStatus_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_AntiTheftStatus_IsValid(AntiTheftStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AntiTheftStatus_, "T_AntiTheftStatus", "AntiTheftStatus", "AntiTheftStatusSet");
    }
    #endif
    set_has_AntiTheftStatus();
    this->_AntiTheftStatus = AntiTheftStatus_;
}

inline void AntiTheftStatusSet::set_has_AntiTheftStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void AntiTheftStatusSet::clear_has_AntiTheftStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AntiTheftUnlockHMIStatus::AntiTheftUnlockHMIStatus ()  :
    _VIDWriteStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AntiTheftUnlockHMIStatus::AntiTheftUnlockHMIStatus (const AntiTheftUnlockHMIStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _VIDWriteStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AntiTheftUnlockHMIStatus::AntiTheftUnlockHMIStatus (bool VIDWriteStatus_)  :
    _VIDWriteStatus (VIDWriteStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AntiTheftUnlockHMIStatus::~AntiTheftUnlockHMIStatus() {
}

inline AntiTheftUnlockHMIStatus& AntiTheftUnlockHMIStatus::operator = (const AntiTheftUnlockHMIStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVIDWriteStatus()) {
            setVIDWriteStatus(rhs.getVIDWriteStatus());
        } else {
            clearVIDWriteStatus();
        }
    }
    return *this;
}

inline bool AntiTheftUnlockHMIStatus::operator == (const AntiTheftUnlockHMIStatus& rhs) const {
    return (((!hasVIDWriteStatus() && !rhs.hasVIDWriteStatus()) || getVIDWriteStatus() == rhs.getVIDWriteStatus()));
}

inline bool AntiTheftUnlockHMIStatus::operator != (const AntiTheftUnlockHMIStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AntiTheftUnlockHMIStatus::operator < (const AntiTheftUnlockHMIStatus& rhs) const {
    if (hasVIDWriteStatus() || rhs.hasVIDWriteStatus()) {
        if (getVIDWriteStatus() < rhs.getVIDWriteStatus()) return true;
        if (getVIDWriteStatus() > rhs.getVIDWriteStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AntiTheftUnlockHMIStatus::clone() {
    return new AntiTheftUnlockHMIStatus(*this);
}

inline bool AntiTheftUnlockHMIStatus::operator > (const AntiTheftUnlockHMIStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AntiTheftUnlockHMIStatus::clear() {
    clearVIDWriteStatus();
}

inline void AntiTheftUnlockHMIStatus::clearVIDWriteStatus() {
    if (hasVIDWriteStatus()) {
         clear_has_VIDWriteStatus();
        _VIDWriteStatus = false;
     }
}

inline bool AntiTheftUnlockHMIStatus::hasVIDWriteStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AntiTheftUnlockHMIStatus::getVIDWriteStatus () const {
    return _VIDWriteStatus;
}

inline void AntiTheftUnlockHMIStatus::setVIDWriteStatus (bool VIDWriteStatus_) {
    set_has_VIDWriteStatus();
    this->_VIDWriteStatus = VIDWriteStatus_;
}

inline void AntiTheftUnlockHMIStatus::set_has_VIDWriteStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void AntiTheftUnlockHMIStatus::clear_has_VIDWriteStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AntiTheftUnlockHUStatus::AntiTheftUnlockHUStatus ()  :
    _PINValidationStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AntiTheftUnlockHUStatus::AntiTheftUnlockHUStatus (const AntiTheftUnlockHUStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _PINValidationStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AntiTheftUnlockHUStatus::AntiTheftUnlockHUStatus (bool PINValidationStatus_)  :
    _PINValidationStatus (PINValidationStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AntiTheftUnlockHUStatus::~AntiTheftUnlockHUStatus() {
}

inline AntiTheftUnlockHUStatus& AntiTheftUnlockHUStatus::operator = (const AntiTheftUnlockHUStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPINValidationStatus()) {
            setPINValidationStatus(rhs.getPINValidationStatus());
        } else {
            clearPINValidationStatus();
        }
    }
    return *this;
}

inline bool AntiTheftUnlockHUStatus::operator == (const AntiTheftUnlockHUStatus& rhs) const {
    return (((!hasPINValidationStatus() && !rhs.hasPINValidationStatus()) || getPINValidationStatus() == rhs.getPINValidationStatus()));
}

inline bool AntiTheftUnlockHUStatus::operator != (const AntiTheftUnlockHUStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AntiTheftUnlockHUStatus::operator < (const AntiTheftUnlockHUStatus& rhs) const {
    if (hasPINValidationStatus() || rhs.hasPINValidationStatus()) {
        if (getPINValidationStatus() < rhs.getPINValidationStatus()) return true;
        if (getPINValidationStatus() > rhs.getPINValidationStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AntiTheftUnlockHUStatus::clone() {
    return new AntiTheftUnlockHUStatus(*this);
}

inline bool AntiTheftUnlockHUStatus::operator > (const AntiTheftUnlockHUStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AntiTheftUnlockHUStatus::clear() {
    clearPINValidationStatus();
}

inline void AntiTheftUnlockHUStatus::clearPINValidationStatus() {
    if (hasPINValidationStatus()) {
         clear_has_PINValidationStatus();
        _PINValidationStatus = false;
     }
}

inline bool AntiTheftUnlockHUStatus::hasPINValidationStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AntiTheftUnlockHUStatus::getPINValidationStatus () const {
    return _PINValidationStatus;
}

inline void AntiTheftUnlockHUStatus::setPINValidationStatus (bool PINValidationStatus_) {
    set_has_PINValidationStatus();
    this->_PINValidationStatus = PINValidationStatus_;
}

inline void AntiTheftUnlockHUStatus::set_has_PINValidationStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void AntiTheftUnlockHUStatus::clear_has_PINValidationStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ClearDestinationMemoryStatus::ClearDestinationMemoryStatus ()  :
    _ClearMemory (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClearDestinationMemoryStatus::ClearDestinationMemoryStatus (const ClearDestinationMemoryStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ClearMemory (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClearDestinationMemoryStatus::ClearDestinationMemoryStatus (bool ClearMemory_)  :
    _ClearMemory (ClearMemory_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClearDestinationMemoryStatus::~ClearDestinationMemoryStatus() {
}

inline ClearDestinationMemoryStatus& ClearDestinationMemoryStatus::operator = (const ClearDestinationMemoryStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClearMemory()) {
            setClearMemory(rhs.getClearMemory());
        } else {
            clearClearMemory();
        }
    }
    return *this;
}

inline bool ClearDestinationMemoryStatus::operator == (const ClearDestinationMemoryStatus& rhs) const {
    return (((!hasClearMemory() && !rhs.hasClearMemory()) || getClearMemory() == rhs.getClearMemory()));
}

inline bool ClearDestinationMemoryStatus::operator != (const ClearDestinationMemoryStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ClearDestinationMemoryStatus::operator < (const ClearDestinationMemoryStatus& rhs) const {
    if (hasClearMemory() || rhs.hasClearMemory()) {
        if (getClearMemory() < rhs.getClearMemory()) return true;
        if (getClearMemory() > rhs.getClearMemory()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClearDestinationMemoryStatus::clone() {
    return new ClearDestinationMemoryStatus(*this);
}

inline bool ClearDestinationMemoryStatus::operator > (const ClearDestinationMemoryStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClearDestinationMemoryStatus::clear() {
    clearClearMemory();
}

inline void ClearDestinationMemoryStatus::clearClearMemory() {
    if (hasClearMemory()) {
         clear_has_ClearMemory();
        _ClearMemory = false;
     }
}

inline bool ClearDestinationMemoryStatus::hasClearMemory () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ClearDestinationMemoryStatus::getClearMemory () const {
    return _ClearMemory;
}

inline void ClearDestinationMemoryStatus::setClearMemory (bool ClearMemory_) {
    set_has_ClearMemory();
    this->_ClearMemory = ClearMemory_;
}

inline void ClearDestinationMemoryStatus::set_has_ClearMemory () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClearDestinationMemoryStatus::clear_has_ClearMemory () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ClearDestinationMemorySet::ClearDestinationMemorySet ()  :
    _ClearMemorySuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClearDestinationMemorySet::ClearDestinationMemorySet (const ClearDestinationMemorySet &rhs)  :
    ::asf::core::Payload(rhs),
    _ClearMemorySuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClearDestinationMemorySet::ClearDestinationMemorySet (bool ClearMemorySuccess_)  :
    _ClearMemorySuccess (ClearMemorySuccess_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClearDestinationMemorySet::~ClearDestinationMemorySet() {
}

inline ClearDestinationMemorySet& ClearDestinationMemorySet::operator = (const ClearDestinationMemorySet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClearMemorySuccess()) {
            setClearMemorySuccess(rhs.getClearMemorySuccess());
        } else {
            clearClearMemorySuccess();
        }
    }
    return *this;
}

inline bool ClearDestinationMemorySet::operator == (const ClearDestinationMemorySet& rhs) const {
    return (((!hasClearMemorySuccess() && !rhs.hasClearMemorySuccess()) || getClearMemorySuccess() == rhs.getClearMemorySuccess()));
}

inline bool ClearDestinationMemorySet::operator != (const ClearDestinationMemorySet& rhs) const {
    return ! (*this == rhs);
}

inline bool ClearDestinationMemorySet::operator < (const ClearDestinationMemorySet& rhs) const {
    if (hasClearMemorySuccess() || rhs.hasClearMemorySuccess()) {
        if (getClearMemorySuccess() < rhs.getClearMemorySuccess()) return true;
        if (getClearMemorySuccess() > rhs.getClearMemorySuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClearDestinationMemorySet::clone() {
    return new ClearDestinationMemorySet(*this);
}

inline bool ClearDestinationMemorySet::operator > (const ClearDestinationMemorySet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClearDestinationMemorySet::clear() {
    clearClearMemorySuccess();
}

inline void ClearDestinationMemorySet::clearClearMemorySuccess() {
    if (hasClearMemorySuccess()) {
         clear_has_ClearMemorySuccess();
        _ClearMemorySuccess = false;
     }
}

inline bool ClearDestinationMemorySet::hasClearMemorySuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ClearDestinationMemorySet::getClearMemorySuccess () const {
    return _ClearMemorySuccess;
}

inline void ClearDestinationMemorySet::setClearMemorySuccess (bool ClearMemorySuccess_) {
    set_has_ClearMemorySuccess();
    this->_ClearMemorySuccess = ClearMemorySuccess_;
}

inline void ClearDestinationMemorySet::set_has_ClearMemorySuccess () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClearDestinationMemorySet::clear_has_ClearMemorySuccess () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetDestinationMemorySizeStatus::GetDestinationMemorySizeStatus ()  :
    _GetMemorySize (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetDestinationMemorySizeStatus::GetDestinationMemorySizeStatus (const GetDestinationMemorySizeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _GetMemorySize (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetDestinationMemorySizeStatus::GetDestinationMemorySizeStatus (bool GetMemorySize_)  :
    _GetMemorySize (GetMemorySize_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetDestinationMemorySizeStatus::~GetDestinationMemorySizeStatus() {
}

inline GetDestinationMemorySizeStatus& GetDestinationMemorySizeStatus::operator = (const GetDestinationMemorySizeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGetMemorySize()) {
            setGetMemorySize(rhs.getGetMemorySize());
        } else {
            clearGetMemorySize();
        }
    }
    return *this;
}

inline bool GetDestinationMemorySizeStatus::operator == (const GetDestinationMemorySizeStatus& rhs) const {
    return (((!hasGetMemorySize() && !rhs.hasGetMemorySize()) || getGetMemorySize() == rhs.getGetMemorySize()));
}

inline bool GetDestinationMemorySizeStatus::operator != (const GetDestinationMemorySizeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDestinationMemorySizeStatus::operator < (const GetDestinationMemorySizeStatus& rhs) const {
    if (hasGetMemorySize() || rhs.hasGetMemorySize()) {
        if (getGetMemorySize() < rhs.getGetMemorySize()) return true;
        if (getGetMemorySize() > rhs.getGetMemorySize()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetDestinationMemorySizeStatus::clone() {
    return new GetDestinationMemorySizeStatus(*this);
}

inline bool GetDestinationMemorySizeStatus::operator > (const GetDestinationMemorySizeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetDestinationMemorySizeStatus::clear() {
    clearGetMemorySize();
}

inline void GetDestinationMemorySizeStatus::clearGetMemorySize() {
    if (hasGetMemorySize()) {
         clear_has_GetMemorySize();
        _GetMemorySize = false;
     }
}

inline bool GetDestinationMemorySizeStatus::hasGetMemorySize () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool GetDestinationMemorySizeStatus::getGetMemorySize () const {
    return _GetMemorySize;
}

inline void GetDestinationMemorySizeStatus::setGetMemorySize (bool GetMemorySize_) {
    set_has_GetMemorySize();
    this->_GetMemorySize = GetMemorySize_;
}

inline void GetDestinationMemorySizeStatus::set_has_GetMemorySize () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetDestinationMemorySizeStatus::clear_has_GetMemorySize () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetDestinationMemorySizeSet::GetDestinationMemorySizeSet ()  :
    _RecordCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetDestinationMemorySizeSet::GetDestinationMemorySizeSet (const GetDestinationMemorySizeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _RecordCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetDestinationMemorySizeSet::GetDestinationMemorySizeSet (uint16 RecordCount_)  :
    _RecordCount (RecordCount_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetDestinationMemorySizeSet::~GetDestinationMemorySizeSet() {
}

inline GetDestinationMemorySizeSet& GetDestinationMemorySizeSet::operator = (const GetDestinationMemorySizeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRecordCount()) {
            setRecordCount(rhs.getRecordCount());
        } else {
            clearRecordCount();
        }
    }
    return *this;
}

inline bool GetDestinationMemorySizeSet::operator == (const GetDestinationMemorySizeSet& rhs) const {
    return (((!hasRecordCount() && !rhs.hasRecordCount()) || getRecordCount() == rhs.getRecordCount()));
}

inline bool GetDestinationMemorySizeSet::operator != (const GetDestinationMemorySizeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDestinationMemorySizeSet::operator < (const GetDestinationMemorySizeSet& rhs) const {
    if (hasRecordCount() || rhs.hasRecordCount()) {
        if (getRecordCount() < rhs.getRecordCount()) return true;
        if (getRecordCount() > rhs.getRecordCount()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetDestinationMemorySizeSet::clone() {
    return new GetDestinationMemorySizeSet(*this);
}

inline bool GetDestinationMemorySizeSet::operator > (const GetDestinationMemorySizeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetDestinationMemorySizeSet::clear() {
    clearRecordCount();
}

inline void GetDestinationMemorySizeSet::clearRecordCount() {
    if (hasRecordCount()) {
         clear_has_RecordCount();
        _RecordCount = 0u;
     }
}

inline bool GetDestinationMemorySizeSet::hasRecordCount () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 GetDestinationMemorySizeSet::getRecordCount () const {
    return _RecordCount;
}

inline void GetDestinationMemorySizeSet::setRecordCount (uint16 RecordCount_) {
    set_has_RecordCount();
    this->_RecordCount = RecordCount_;
}

inline void GetDestinationMemorySizeSet::set_has_RecordCount () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetDestinationMemorySizeSet::clear_has_RecordCount () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SimulateKeyPressStatus::SimulateKeyPressStatus ()  :
    _KeyCommand (::midw_diagnostics_fi_types::T_e8_SimulatedKeys__KEY_CODE_SOFTKEY_UNDEFINED),
    _EncoderSteps (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimulateKeyPressStatus::SimulateKeyPressStatus (const SimulateKeyPressStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _KeyCommand (::midw_diagnostics_fi_types::T_e8_SimulatedKeys__KEY_CODE_SOFTKEY_UNDEFINED),
    _EncoderSteps (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimulateKeyPressStatus::SimulateKeyPressStatus (::midw_diagnostics_fi_types::T_e8_SimulatedKeys KeyCommand_, int8 EncoderSteps_)  :
    _KeyCommand (KeyCommand_),
    _EncoderSteps (EncoderSteps_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_SimulatedKeys_IsValid(KeyCommand_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", KeyCommand_, "T_e8_SimulatedKeys", "KeyCommand", "SimulateKeyPressStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimulateKeyPressStatus::~SimulateKeyPressStatus() {
}

inline SimulateKeyPressStatus& SimulateKeyPressStatus::operator = (const SimulateKeyPressStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKeyCommand()) {
            setKeyCommand(rhs.getKeyCommand());
        } else {
            clearKeyCommand();
        }
        if (rhs.hasEncoderSteps()) {
            setEncoderSteps(rhs.getEncoderSteps());
        } else {
            clearEncoderSteps();
        }
    }
    return *this;
}

inline bool SimulateKeyPressStatus::operator == (const SimulateKeyPressStatus& rhs) const {
    return (((!hasKeyCommand() && !rhs.hasKeyCommand()) || getKeyCommand() == rhs.getKeyCommand()) &&
        ((!hasEncoderSteps() && !rhs.hasEncoderSteps()) || getEncoderSteps() == rhs.getEncoderSteps()));
}

inline bool SimulateKeyPressStatus::operator != (const SimulateKeyPressStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SimulateKeyPressStatus::operator < (const SimulateKeyPressStatus& rhs) const {
    if (hasKeyCommand() || rhs.hasKeyCommand()) {
        if ((uint32)getKeyCommand() < (uint32)rhs.getKeyCommand()) return true;
        if ((uint32)getKeyCommand() > (uint32)rhs.getKeyCommand()) return false;
    }
    if (hasEncoderSteps() || rhs.hasEncoderSteps()) {
        if (getEncoderSteps() < rhs.getEncoderSteps()) return true;
        if (getEncoderSteps() > rhs.getEncoderSteps()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimulateKeyPressStatus::clone() {
    return new SimulateKeyPressStatus(*this);
}

inline bool SimulateKeyPressStatus::operator > (const SimulateKeyPressStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimulateKeyPressStatus::clear() {
    clearKeyCommand();
    clearEncoderSteps();
}

inline void SimulateKeyPressStatus::clearKeyCommand() {
    if (hasKeyCommand()) {
         clear_has_KeyCommand();
        _KeyCommand = ::midw_diagnostics_fi_types::T_e8_SimulatedKeys__KEY_CODE_SOFTKEY_UNDEFINED;
     }
}

inline bool SimulateKeyPressStatus::hasKeyCommand () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_SimulatedKeys SimulateKeyPressStatus::getKeyCommand () const {
    return _KeyCommand;
}

inline void SimulateKeyPressStatus::setKeyCommand (::midw_diagnostics_fi_types::T_e8_SimulatedKeys KeyCommand_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_SimulatedKeys_IsValid(KeyCommand_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", KeyCommand_, "T_e8_SimulatedKeys", "KeyCommand", "SimulateKeyPressStatus");
    }
    #endif
    set_has_KeyCommand();
    this->_KeyCommand = KeyCommand_;
}

inline void SimulateKeyPressStatus::clearEncoderSteps() {
    if (hasEncoderSteps()) {
         clear_has_EncoderSteps();
        _EncoderSteps = 0;
     }
}

inline bool SimulateKeyPressStatus::hasEncoderSteps () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int8 SimulateKeyPressStatus::getEncoderSteps () const {
    return _EncoderSteps;
}

inline void SimulateKeyPressStatus::setEncoderSteps (int8 EncoderSteps_) {
    set_has_EncoderSteps();
    this->_EncoderSteps = EncoderSteps_;
}

inline void SimulateKeyPressStatus::set_has_KeyCommand () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimulateKeyPressStatus::clear_has_KeyCommand () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimulateKeyPressStatus::set_has_EncoderSteps () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimulateKeyPressStatus::clear_has_EncoderSteps () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SimulateKeyPressSet::SimulateKeyPressSet ()  :
    _KeyPressSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimulateKeyPressSet::SimulateKeyPressSet (const SimulateKeyPressSet &rhs)  :
    ::asf::core::Payload(rhs),
    _KeyPressSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimulateKeyPressSet::SimulateKeyPressSet (bool KeyPressSuccess_)  :
    _KeyPressSuccess (KeyPressSuccess_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimulateKeyPressSet::~SimulateKeyPressSet() {
}

inline SimulateKeyPressSet& SimulateKeyPressSet::operator = (const SimulateKeyPressSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKeyPressSuccess()) {
            setKeyPressSuccess(rhs.getKeyPressSuccess());
        } else {
            clearKeyPressSuccess();
        }
    }
    return *this;
}

inline bool SimulateKeyPressSet::operator == (const SimulateKeyPressSet& rhs) const {
    return (((!hasKeyPressSuccess() && !rhs.hasKeyPressSuccess()) || getKeyPressSuccess() == rhs.getKeyPressSuccess()));
}

inline bool SimulateKeyPressSet::operator != (const SimulateKeyPressSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SimulateKeyPressSet::operator < (const SimulateKeyPressSet& rhs) const {
    if (hasKeyPressSuccess() || rhs.hasKeyPressSuccess()) {
        if (getKeyPressSuccess() < rhs.getKeyPressSuccess()) return true;
        if (getKeyPressSuccess() > rhs.getKeyPressSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimulateKeyPressSet::clone() {
    return new SimulateKeyPressSet(*this);
}

inline bool SimulateKeyPressSet::operator > (const SimulateKeyPressSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimulateKeyPressSet::clear() {
    clearKeyPressSuccess();
}

inline void SimulateKeyPressSet::clearKeyPressSuccess() {
    if (hasKeyPressSuccess()) {
         clear_has_KeyPressSuccess();
        _KeyPressSuccess = false;
     }
}

inline bool SimulateKeyPressSet::hasKeyPressSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SimulateKeyPressSet::getKeyPressSuccess () const {
    return _KeyPressSuccess;
}

inline void SimulateKeyPressSet::setKeyPressSuccess (bool KeyPressSuccess_) {
    set_has_KeyPressSuccess();
    this->_KeyPressSuccess = KeyPressSuccess_;
}

inline void SimulateKeyPressSet::set_has_KeyPressSuccess () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimulateKeyPressSet::clear_has_KeyPressSuccess () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ResetSecurityStatus::ResetSecurityStatus ()  :
    _Reset (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ResetSecurityStatus::ResetSecurityStatus (const ResetSecurityStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Reset (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ResetSecurityStatus::ResetSecurityStatus (bool Reset_)  :
    _Reset (Reset_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ResetSecurityStatus::~ResetSecurityStatus() {
}

inline ResetSecurityStatus& ResetSecurityStatus::operator = (const ResetSecurityStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasReset()) {
            setReset(rhs.getReset());
        } else {
            clearReset();
        }
    }
    return *this;
}

inline bool ResetSecurityStatus::operator == (const ResetSecurityStatus& rhs) const {
    return (((!hasReset() && !rhs.hasReset()) || getReset() == rhs.getReset()));
}

inline bool ResetSecurityStatus::operator != (const ResetSecurityStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ResetSecurityStatus::operator < (const ResetSecurityStatus& rhs) const {
    if (hasReset() || rhs.hasReset()) {
        if (getReset() < rhs.getReset()) return true;
        if (getReset() > rhs.getReset()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ResetSecurityStatus::clone() {
    return new ResetSecurityStatus(*this);
}

inline bool ResetSecurityStatus::operator > (const ResetSecurityStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ResetSecurityStatus::clear() {
    clearReset();
}

inline void ResetSecurityStatus::clearReset() {
    if (hasReset()) {
         clear_has_Reset();
        _Reset = false;
     }
}

inline bool ResetSecurityStatus::hasReset () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ResetSecurityStatus::getReset () const {
    return _Reset;
}

inline void ResetSecurityStatus::setReset (bool Reset_) {
    set_has_Reset();
    this->_Reset = Reset_;
}

inline void ResetSecurityStatus::set_has_Reset () {
    _has_bits_[0] |= 1u << 0;
}

inline void ResetSecurityStatus::clear_has_Reset () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ResetSecuritySet::ResetSecuritySet ()  :
    _ResetSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ResetSecuritySet::ResetSecuritySet (const ResetSecuritySet &rhs)  :
    ::asf::core::Payload(rhs),
    _ResetSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ResetSecuritySet::ResetSecuritySet (bool ResetSuccess_)  :
    _ResetSuccess (ResetSuccess_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ResetSecuritySet::~ResetSecuritySet() {
}

inline ResetSecuritySet& ResetSecuritySet::operator = (const ResetSecuritySet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResetSuccess()) {
            setResetSuccess(rhs.getResetSuccess());
        } else {
            clearResetSuccess();
        }
    }
    return *this;
}

inline bool ResetSecuritySet::operator == (const ResetSecuritySet& rhs) const {
    return (((!hasResetSuccess() && !rhs.hasResetSuccess()) || getResetSuccess() == rhs.getResetSuccess()));
}

inline bool ResetSecuritySet::operator != (const ResetSecuritySet& rhs) const {
    return ! (*this == rhs);
}

inline bool ResetSecuritySet::operator < (const ResetSecuritySet& rhs) const {
    if (hasResetSuccess() || rhs.hasResetSuccess()) {
        if (getResetSuccess() < rhs.getResetSuccess()) return true;
        if (getResetSuccess() > rhs.getResetSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ResetSecuritySet::clone() {
    return new ResetSecuritySet(*this);
}

inline bool ResetSecuritySet::operator > (const ResetSecuritySet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ResetSecuritySet::clear() {
    clearResetSuccess();
}

inline void ResetSecuritySet::clearResetSuccess() {
    if (hasResetSuccess()) {
         clear_has_ResetSuccess();
        _ResetSuccess = false;
     }
}

inline bool ResetSecuritySet::hasResetSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ResetSecuritySet::getResetSuccess () const {
    return _ResetSuccess;
}

inline void ResetSecuritySet::setResetSuccess (bool ResetSuccess_) {
    set_has_ResetSuccess();
    this->_ResetSuccess = ResetSuccess_;
}

inline void ResetSecuritySet::set_has_ResetSuccess () {
    _has_bits_[0] |= 1u << 0;
}

inline void ResetSecuritySet::clear_has_ResetSuccess () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LanguageGet::LanguageGet ()  :
    _Language (::midw_diagnostics_fi_types::T_e16_Language__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LanguageGet::LanguageGet (const LanguageGet &rhs)  :
    ::asf::core::Payload(rhs),
    _Language (::midw_diagnostics_fi_types::T_e16_Language__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LanguageGet::LanguageGet (::midw_diagnostics_fi_types::T_e16_Language Language_)  :
    _Language (Language_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e16_Language_IsValid(Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Language_, "T_e16_Language", "Language", "LanguageGet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LanguageGet::~LanguageGet() {
}

inline LanguageGet& LanguageGet::operator = (const LanguageGet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLanguage()) {
            setLanguage(rhs.getLanguage());
        } else {
            clearLanguage();
        }
    }
    return *this;
}

inline bool LanguageGet::operator == (const LanguageGet& rhs) const {
    return (((!hasLanguage() && !rhs.hasLanguage()) || getLanguage() == rhs.getLanguage()));
}

inline bool LanguageGet::operator != (const LanguageGet& rhs) const {
    return ! (*this == rhs);
}

inline bool LanguageGet::operator < (const LanguageGet& rhs) const {
    if (hasLanguage() || rhs.hasLanguage()) {
        if ((uint32)getLanguage() < (uint32)rhs.getLanguage()) return true;
        if ((uint32)getLanguage() > (uint32)rhs.getLanguage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LanguageGet::clone() {
    return new LanguageGet(*this);
}

inline bool LanguageGet::operator > (const LanguageGet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LanguageGet::clear() {
    clearLanguage();
}

inline void LanguageGet::clearLanguage() {
    if (hasLanguage()) {
         clear_has_Language();
        _Language = ::midw_diagnostics_fi_types::T_e16_Language__Undefined;
     }
}

inline bool LanguageGet::hasLanguage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e16_Language LanguageGet::getLanguage () const {
    return _Language;
}

inline void LanguageGet::setLanguage (::midw_diagnostics_fi_types::T_e16_Language Language_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e16_Language_IsValid(Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Language_, "T_e16_Language", "Language", "LanguageGet");
    }
    #endif
    set_has_Language();
    this->_Language = Language_;
}

inline void LanguageGet::set_has_Language () {
    _has_bits_[0] |= 1u << 0;
}

inline void LanguageGet::clear_has_Language () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SpeedLockStatus::SpeedLockStatus ()  :
    _SpeedLockStatus (::midw_diagnostics_fi_types::T_e16_SpeedLock__Undefined),
    _SpeedLockThreshold (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeedLockStatus::SpeedLockStatus (const SpeedLockStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _SpeedLockStatus (::midw_diagnostics_fi_types::T_e16_SpeedLock__Undefined),
    _SpeedLockThreshold (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeedLockStatus::SpeedLockStatus (::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLockStatus_, uint8 SpeedLockThreshold_)  :
    _SpeedLockStatus (SpeedLockStatus_),
    _SpeedLockThreshold (SpeedLockThreshold_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e16_SpeedLock_IsValid(SpeedLockStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SpeedLockStatus_, "T_e16_SpeedLock", "SpeedLockStatus", "SpeedLockStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpeedLockStatus::~SpeedLockStatus() {
}

inline SpeedLockStatus& SpeedLockStatus::operator = (const SpeedLockStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSpeedLockStatus()) {
            setSpeedLockStatus(rhs.getSpeedLockStatus());
        } else {
            clearSpeedLockStatus();
        }
        if (rhs.hasSpeedLockThreshold()) {
            setSpeedLockThreshold(rhs.getSpeedLockThreshold());
        } else {
            clearSpeedLockThreshold();
        }
    }
    return *this;
}

inline bool SpeedLockStatus::operator == (const SpeedLockStatus& rhs) const {
    return (((!hasSpeedLockStatus() && !rhs.hasSpeedLockStatus()) || getSpeedLockStatus() == rhs.getSpeedLockStatus()) &&
        ((!hasSpeedLockThreshold() && !rhs.hasSpeedLockThreshold()) || getSpeedLockThreshold() == rhs.getSpeedLockThreshold()));
}

inline bool SpeedLockStatus::operator != (const SpeedLockStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeedLockStatus::operator < (const SpeedLockStatus& rhs) const {
    if (hasSpeedLockStatus() || rhs.hasSpeedLockStatus()) {
        if ((uint32)getSpeedLockStatus() < (uint32)rhs.getSpeedLockStatus()) return true;
        if ((uint32)getSpeedLockStatus() > (uint32)rhs.getSpeedLockStatus()) return false;
    }
    if (hasSpeedLockThreshold() || rhs.hasSpeedLockThreshold()) {
        if (getSpeedLockThreshold() < rhs.getSpeedLockThreshold()) return true;
        if (getSpeedLockThreshold() > rhs.getSpeedLockThreshold()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpeedLockStatus::clone() {
    return new SpeedLockStatus(*this);
}

inline bool SpeedLockStatus::operator > (const SpeedLockStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeedLockStatus::clear() {
    clearSpeedLockStatus();
    clearSpeedLockThreshold();
}

inline void SpeedLockStatus::clearSpeedLockStatus() {
    if (hasSpeedLockStatus()) {
         clear_has_SpeedLockStatus();
        _SpeedLockStatus = ::midw_diagnostics_fi_types::T_e16_SpeedLock__Undefined;
     }
}

inline bool SpeedLockStatus::hasSpeedLockStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLockStatus::getSpeedLockStatus () const {
    return _SpeedLockStatus;
}

inline void SpeedLockStatus::setSpeedLockStatus (::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLockStatus_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e16_SpeedLock_IsValid(SpeedLockStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SpeedLockStatus_, "T_e16_SpeedLock", "SpeedLockStatus", "SpeedLockStatus");
    }
    #endif
    set_has_SpeedLockStatus();
    this->_SpeedLockStatus = SpeedLockStatus_;
}

inline void SpeedLockStatus::clearSpeedLockThreshold() {
    if (hasSpeedLockThreshold()) {
         clear_has_SpeedLockThreshold();
        _SpeedLockThreshold = 0u;
     }
}

inline bool SpeedLockStatus::hasSpeedLockThreshold () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 SpeedLockStatus::getSpeedLockThreshold () const {
    return _SpeedLockThreshold;
}

inline void SpeedLockStatus::setSpeedLockThreshold (uint8 SpeedLockThreshold_) {
    set_has_SpeedLockThreshold();
    this->_SpeedLockThreshold = SpeedLockThreshold_;
}

inline void SpeedLockStatus::set_has_SpeedLockStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpeedLockStatus::clear_has_SpeedLockStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SpeedLockStatus::set_has_SpeedLockThreshold () {
    _has_bits_[0] |= 1u << 1;
}

inline void SpeedLockStatus::clear_has_SpeedLockThreshold () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SpeedLockGet::SpeedLockGet ()  :
    _SpeedLock (::midw_diagnostics_fi_types::T_e16_SpeedLock__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeedLockGet::SpeedLockGet (const SpeedLockGet &rhs)  :
    ::asf::core::Payload(rhs),
    _SpeedLock (::midw_diagnostics_fi_types::T_e16_SpeedLock__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeedLockGet::SpeedLockGet (::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLock_)  :
    _SpeedLock (SpeedLock_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e16_SpeedLock_IsValid(SpeedLock_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SpeedLock_, "T_e16_SpeedLock", "SpeedLock", "SpeedLockGet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpeedLockGet::~SpeedLockGet() {
}

inline SpeedLockGet& SpeedLockGet::operator = (const SpeedLockGet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSpeedLock()) {
            setSpeedLock(rhs.getSpeedLock());
        } else {
            clearSpeedLock();
        }
    }
    return *this;
}

inline bool SpeedLockGet::operator == (const SpeedLockGet& rhs) const {
    return (((!hasSpeedLock() && !rhs.hasSpeedLock()) || getSpeedLock() == rhs.getSpeedLock()));
}

inline bool SpeedLockGet::operator != (const SpeedLockGet& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeedLockGet::operator < (const SpeedLockGet& rhs) const {
    if (hasSpeedLock() || rhs.hasSpeedLock()) {
        if ((uint32)getSpeedLock() < (uint32)rhs.getSpeedLock()) return true;
        if ((uint32)getSpeedLock() > (uint32)rhs.getSpeedLock()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpeedLockGet::clone() {
    return new SpeedLockGet(*this);
}

inline bool SpeedLockGet::operator > (const SpeedLockGet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeedLockGet::clear() {
    clearSpeedLock();
}

inline void SpeedLockGet::clearSpeedLock() {
    if (hasSpeedLock()) {
         clear_has_SpeedLock();
        _SpeedLock = ::midw_diagnostics_fi_types::T_e16_SpeedLock__Undefined;
     }
}

inline bool SpeedLockGet::hasSpeedLock () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLockGet::getSpeedLock () const {
    return _SpeedLock;
}

inline void SpeedLockGet::setSpeedLock (::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLock_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e16_SpeedLock_IsValid(SpeedLock_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SpeedLock_, "T_e16_SpeedLock", "SpeedLock", "SpeedLockGet");
    }
    #endif
    set_has_SpeedLock();
    this->_SpeedLock = SpeedLock_;
}

inline void SpeedLockGet::set_has_SpeedLock () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpeedLockGet::clear_has_SpeedLock () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SpdLockStatus::SpdLockStatus ()  :
    _SpeedLockStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpdLockStatus::SpdLockStatus (const SpdLockStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _SpeedLockStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpdLockStatus::SpdLockStatus (bool SpeedLockStatus_)  :
    _SpeedLockStatus (SpeedLockStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpdLockStatus::~SpdLockStatus() {
}

inline SpdLockStatus& SpdLockStatus::operator = (const SpdLockStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSpeedLockStatus()) {
            setSpeedLockStatus(rhs.getSpeedLockStatus());
        } else {
            clearSpeedLockStatus();
        }
    }
    return *this;
}

inline bool SpdLockStatus::operator == (const SpdLockStatus& rhs) const {
    return (((!hasSpeedLockStatus() && !rhs.hasSpeedLockStatus()) || getSpeedLockStatus() == rhs.getSpeedLockStatus()));
}

inline bool SpdLockStatus::operator != (const SpdLockStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SpdLockStatus::operator < (const SpdLockStatus& rhs) const {
    if (hasSpeedLockStatus() || rhs.hasSpeedLockStatus()) {
        if (getSpeedLockStatus() < rhs.getSpeedLockStatus()) return true;
        if (getSpeedLockStatus() > rhs.getSpeedLockStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpdLockStatus::clone() {
    return new SpdLockStatus(*this);
}

inline bool SpdLockStatus::operator > (const SpdLockStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpdLockStatus::clear() {
    clearSpeedLockStatus();
}

inline void SpdLockStatus::clearSpeedLockStatus() {
    if (hasSpeedLockStatus()) {
         clear_has_SpeedLockStatus();
        _SpeedLockStatus = false;
     }
}

inline bool SpdLockStatus::hasSpeedLockStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SpdLockStatus::getSpeedLockStatus () const {
    return _SpeedLockStatus;
}

inline void SpdLockStatus::setSpeedLockStatus (bool SpeedLockStatus_) {
    set_has_SpeedLockStatus();
    this->_SpeedLockStatus = SpeedLockStatus_;
}

inline void SpdLockStatus::set_has_SpeedLockStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpdLockStatus::clear_has_SpeedLockStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SpdLockSet::SpdLockSet ()  :
    _SpeedLock (::midw_diagnostics_fi_types::T_e16_SpeedLock__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpdLockSet::SpdLockSet (const SpdLockSet &rhs)  :
    ::asf::core::Payload(rhs),
    _SpeedLock (::midw_diagnostics_fi_types::T_e16_SpeedLock__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpdLockSet::SpdLockSet (::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLock_)  :
    _SpeedLock (SpeedLock_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e16_SpeedLock_IsValid(SpeedLock_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SpeedLock_, "T_e16_SpeedLock", "SpeedLock", "SpdLockSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpdLockSet::~SpdLockSet() {
}

inline SpdLockSet& SpdLockSet::operator = (const SpdLockSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSpeedLock()) {
            setSpeedLock(rhs.getSpeedLock());
        } else {
            clearSpeedLock();
        }
    }
    return *this;
}

inline bool SpdLockSet::operator == (const SpdLockSet& rhs) const {
    return (((!hasSpeedLock() && !rhs.hasSpeedLock()) || getSpeedLock() == rhs.getSpeedLock()));
}

inline bool SpdLockSet::operator != (const SpdLockSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SpdLockSet::operator < (const SpdLockSet& rhs) const {
    if (hasSpeedLock() || rhs.hasSpeedLock()) {
        if ((uint32)getSpeedLock() < (uint32)rhs.getSpeedLock()) return true;
        if ((uint32)getSpeedLock() > (uint32)rhs.getSpeedLock()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpdLockSet::clone() {
    return new SpdLockSet(*this);
}

inline bool SpdLockSet::operator > (const SpdLockSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpdLockSet::clear() {
    clearSpeedLock();
}

inline void SpdLockSet::clearSpeedLock() {
    if (hasSpeedLock()) {
         clear_has_SpeedLock();
        _SpeedLock = ::midw_diagnostics_fi_types::T_e16_SpeedLock__Undefined;
     }
}

inline bool SpdLockSet::hasSpeedLock () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e16_SpeedLock SpdLockSet::getSpeedLock () const {
    return _SpeedLock;
}

inline void SpdLockSet::setSpeedLock (::midw_diagnostics_fi_types::T_e16_SpeedLock SpeedLock_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e16_SpeedLock_IsValid(SpeedLock_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SpeedLock_, "T_e16_SpeedLock", "SpeedLock", "SpdLockSet");
    }
    #endif
    set_has_SpeedLock();
    this->_SpeedLock = SpeedLock_;
}

inline void SpdLockSet::set_has_SpeedLock () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpdLockSet::clear_has_SpeedLock () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetRVCSignalStatus::SetRVCSignalStatus ()  :
    _SignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal__EXT_VIDEO_SIGNAL_ON)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetRVCSignalStatus::SetRVCSignalStatus (const SetRVCSignalStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _SignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal__EXT_VIDEO_SIGNAL_ON)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetRVCSignalStatus::SetRVCSignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SignalStatus_)  :
    _SignalStatus (SignalStatus_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DiagRVCSignal_IsValid(SignalStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SignalStatus_, "T_e8_DiagRVCSignal", "SignalStatus", "SetRVCSignalStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetRVCSignalStatus::~SetRVCSignalStatus() {
}

inline SetRVCSignalStatus& SetRVCSignalStatus::operator = (const SetRVCSignalStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSignalStatus()) {
            setSignalStatus(rhs.getSignalStatus());
        } else {
            clearSignalStatus();
        }
    }
    return *this;
}

inline bool SetRVCSignalStatus::operator == (const SetRVCSignalStatus& rhs) const {
    return (((!hasSignalStatus() && !rhs.hasSignalStatus()) || getSignalStatus() == rhs.getSignalStatus()));
}

inline bool SetRVCSignalStatus::operator != (const SetRVCSignalStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SetRVCSignalStatus::operator < (const SetRVCSignalStatus& rhs) const {
    if (hasSignalStatus() || rhs.hasSignalStatus()) {
        if ((uint32)getSignalStatus() < (uint32)rhs.getSignalStatus()) return true;
        if ((uint32)getSignalStatus() > (uint32)rhs.getSignalStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetRVCSignalStatus::clone() {
    return new SetRVCSignalStatus(*this);
}

inline bool SetRVCSignalStatus::operator > (const SetRVCSignalStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetRVCSignalStatus::clear() {
    clearSignalStatus();
}

inline void SetRVCSignalStatus::clearSignalStatus() {
    if (hasSignalStatus()) {
         clear_has_SignalStatus();
        _SignalStatus = ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal__EXT_VIDEO_SIGNAL_ON;
     }
}

inline bool SetRVCSignalStatus::hasSignalStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SetRVCSignalStatus::getSignalStatus () const {
    return _SignalStatus;
}

inline void SetRVCSignalStatus::setSignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SignalStatus_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DiagRVCSignal_IsValid(SignalStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SignalStatus_, "T_e8_DiagRVCSignal", "SignalStatus", "SetRVCSignalStatus");
    }
    #endif
    set_has_SignalStatus();
    this->_SignalStatus = SignalStatus_;
}

inline void SetRVCSignalStatus::set_has_SignalStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetRVCSignalStatus::clear_has_SignalStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetRVCSignalSet::SetRVCSignalSet ()  :
    _StatusChanged (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetRVCSignalSet::SetRVCSignalSet (const SetRVCSignalSet &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusChanged (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetRVCSignalSet::SetRVCSignalSet (bool StatusChanged_)  :
    _StatusChanged (StatusChanged_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetRVCSignalSet::~SetRVCSignalSet() {
}

inline SetRVCSignalSet& SetRVCSignalSet::operator = (const SetRVCSignalSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusChanged()) {
            setStatusChanged(rhs.getStatusChanged());
        } else {
            clearStatusChanged();
        }
    }
    return *this;
}

inline bool SetRVCSignalSet::operator == (const SetRVCSignalSet& rhs) const {
    return (((!hasStatusChanged() && !rhs.hasStatusChanged()) || getStatusChanged() == rhs.getStatusChanged()));
}

inline bool SetRVCSignalSet::operator != (const SetRVCSignalSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SetRVCSignalSet::operator < (const SetRVCSignalSet& rhs) const {
    if (hasStatusChanged() || rhs.hasStatusChanged()) {
        if (getStatusChanged() < rhs.getStatusChanged()) return true;
        if (getStatusChanged() > rhs.getStatusChanged()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetRVCSignalSet::clone() {
    return new SetRVCSignalSet(*this);
}

inline bool SetRVCSignalSet::operator > (const SetRVCSignalSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetRVCSignalSet::clear() {
    clearStatusChanged();
}

inline void SetRVCSignalSet::clearStatusChanged() {
    if (hasStatusChanged()) {
         clear_has_StatusChanged();
        _StatusChanged = false;
     }
}

inline bool SetRVCSignalSet::hasStatusChanged () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetRVCSignalSet::getStatusChanged () const {
    return _StatusChanged;
}

inline void SetRVCSignalSet::setStatusChanged (bool StatusChanged_) {
    set_has_StatusChanged();
    this->_StatusChanged = StatusChanged_;
}

inline void SetRVCSignalSet::set_has_StatusChanged () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetRVCSignalSet::clear_has_StatusChanged () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetRVCSignalGet::SetRVCSignalGet ()  :
    _SignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal__EXT_VIDEO_SIGNAL_ON)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetRVCSignalGet::SetRVCSignalGet (const SetRVCSignalGet &rhs)  :
    ::asf::core::Payload(rhs),
    _SignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal__EXT_VIDEO_SIGNAL_ON)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetRVCSignalGet::SetRVCSignalGet (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SignalStatus_)  :
    _SignalStatus (SignalStatus_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DiagRVCSignal_IsValid(SignalStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SignalStatus_, "T_e8_DiagRVCSignal", "SignalStatus", "SetRVCSignalGet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetRVCSignalGet::~SetRVCSignalGet() {
}

inline SetRVCSignalGet& SetRVCSignalGet::operator = (const SetRVCSignalGet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSignalStatus()) {
            setSignalStatus(rhs.getSignalStatus());
        } else {
            clearSignalStatus();
        }
    }
    return *this;
}

inline bool SetRVCSignalGet::operator == (const SetRVCSignalGet& rhs) const {
    return (((!hasSignalStatus() && !rhs.hasSignalStatus()) || getSignalStatus() == rhs.getSignalStatus()));
}

inline bool SetRVCSignalGet::operator != (const SetRVCSignalGet& rhs) const {
    return ! (*this == rhs);
}

inline bool SetRVCSignalGet::operator < (const SetRVCSignalGet& rhs) const {
    if (hasSignalStatus() || rhs.hasSignalStatus()) {
        if ((uint32)getSignalStatus() < (uint32)rhs.getSignalStatus()) return true;
        if ((uint32)getSignalStatus() > (uint32)rhs.getSignalStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetRVCSignalGet::clone() {
    return new SetRVCSignalGet(*this);
}

inline bool SetRVCSignalGet::operator > (const SetRVCSignalGet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetRVCSignalGet::clear() {
    clearSignalStatus();
}

inline void SetRVCSignalGet::clearSignalStatus() {
    if (hasSignalStatus()) {
         clear_has_SignalStatus();
        _SignalStatus = ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal__EXT_VIDEO_SIGNAL_ON;
     }
}

inline bool SetRVCSignalGet::hasSignalStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SetRVCSignalGet::getSignalStatus () const {
    return _SignalStatus;
}

inline void SetRVCSignalGet::setSignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SignalStatus_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DiagRVCSignal_IsValid(SignalStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SignalStatus_, "T_e8_DiagRVCSignal", "SignalStatus", "SetRVCSignalGet");
    }
    #endif
    set_has_SignalStatus();
    this->_SignalStatus = SignalStatus_;
}

inline void SetRVCSignalGet::set_has_SignalStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetRVCSignalGet::clear_has_SignalStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RVCSignalStatusStatus::RVCSignalStatusStatus ()  :
    _RequestStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RVCSignalStatusStatus::RVCSignalStatusStatus (const RVCSignalStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _RequestStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RVCSignalStatusStatus::RVCSignalStatusStatus (bool RequestStatus_)  :
    _RequestStatus (RequestStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RVCSignalStatusStatus::~RVCSignalStatusStatus() {
}

inline RVCSignalStatusStatus& RVCSignalStatusStatus::operator = (const RVCSignalStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequestStatus()) {
            setRequestStatus(rhs.getRequestStatus());
        } else {
            clearRequestStatus();
        }
    }
    return *this;
}

inline bool RVCSignalStatusStatus::operator == (const RVCSignalStatusStatus& rhs) const {
    return (((!hasRequestStatus() && !rhs.hasRequestStatus()) || getRequestStatus() == rhs.getRequestStatus()));
}

inline bool RVCSignalStatusStatus::operator != (const RVCSignalStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool RVCSignalStatusStatus::operator < (const RVCSignalStatusStatus& rhs) const {
    if (hasRequestStatus() || rhs.hasRequestStatus()) {
        if (getRequestStatus() < rhs.getRequestStatus()) return true;
        if (getRequestStatus() > rhs.getRequestStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RVCSignalStatusStatus::clone() {
    return new RVCSignalStatusStatus(*this);
}

inline bool RVCSignalStatusStatus::operator > (const RVCSignalStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RVCSignalStatusStatus::clear() {
    clearRequestStatus();
}

inline void RVCSignalStatusStatus::clearRequestStatus() {
    if (hasRequestStatus()) {
         clear_has_RequestStatus();
        _RequestStatus = false;
     }
}

inline bool RVCSignalStatusStatus::hasRequestStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RVCSignalStatusStatus::getRequestStatus () const {
    return _RequestStatus;
}

inline void RVCSignalStatusStatus::setRequestStatus (bool RequestStatus_) {
    set_has_RequestStatus();
    this->_RequestStatus = RequestStatus_;
}

inline void RVCSignalStatusStatus::set_has_RequestStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void RVCSignalStatusStatus::clear_has_RequestStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RVCSignalStatusSet::RVCSignalStatusSet ()  :
    _SignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal__EXT_VIDEO_SIGNAL_ON)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RVCSignalStatusSet::RVCSignalStatusSet (const RVCSignalStatusSet &rhs)  :
    ::asf::core::Payload(rhs),
    _SignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal__EXT_VIDEO_SIGNAL_ON)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RVCSignalStatusSet::RVCSignalStatusSet (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SignalStatus_)  :
    _SignalStatus (SignalStatus_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DiagRVCSignal_IsValid(SignalStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SignalStatus_, "T_e8_DiagRVCSignal", "SignalStatus", "RVCSignalStatusSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RVCSignalStatusSet::~RVCSignalStatusSet() {
}

inline RVCSignalStatusSet& RVCSignalStatusSet::operator = (const RVCSignalStatusSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSignalStatus()) {
            setSignalStatus(rhs.getSignalStatus());
        } else {
            clearSignalStatus();
        }
    }
    return *this;
}

inline bool RVCSignalStatusSet::operator == (const RVCSignalStatusSet& rhs) const {
    return (((!hasSignalStatus() && !rhs.hasSignalStatus()) || getSignalStatus() == rhs.getSignalStatus()));
}

inline bool RVCSignalStatusSet::operator != (const RVCSignalStatusSet& rhs) const {
    return ! (*this == rhs);
}

inline bool RVCSignalStatusSet::operator < (const RVCSignalStatusSet& rhs) const {
    if (hasSignalStatus() || rhs.hasSignalStatus()) {
        if ((uint32)getSignalStatus() < (uint32)rhs.getSignalStatus()) return true;
        if ((uint32)getSignalStatus() > (uint32)rhs.getSignalStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RVCSignalStatusSet::clone() {
    return new RVCSignalStatusSet(*this);
}

inline bool RVCSignalStatusSet::operator > (const RVCSignalStatusSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RVCSignalStatusSet::clear() {
    clearSignalStatus();
}

inline void RVCSignalStatusSet::clearSignalStatus() {
    if (hasSignalStatus()) {
         clear_has_SignalStatus();
        _SignalStatus = ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal__EXT_VIDEO_SIGNAL_ON;
     }
}

inline bool RVCSignalStatusSet::hasSignalStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal RVCSignalStatusSet::getSignalStatus () const {
    return _SignalStatus;
}

inline void RVCSignalStatusSet::setSignalStatus (::midw_diagnostics_fi_types::T_e8_DiagRVCSignal SignalStatus_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DiagRVCSignal_IsValid(SignalStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SignalStatus_, "T_e8_DiagRVCSignal", "SignalStatus", "RVCSignalStatusSet");
    }
    #endif
    set_has_SignalStatus();
    this->_SignalStatus = SignalStatus_;
}

inline void RVCSignalStatusSet::set_has_SignalStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void RVCSignalStatusSet::clear_has_SignalStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  KdsEntryStatus::KdsEntryStatus ()  :
    _KdsEntry (0u),
    _KdsDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KdsEntryStatus::KdsEntryStatus (const KdsEntryStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _KdsEntry (0u),
    _KdsDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KdsEntryStatus::KdsEntryStatus (uint32 KdsEntry_, const ::midw_diagnostics_fi_types::T_KDSItemList& KdsDataList_)  :
    _KdsEntry (KdsEntry_),
    _KdsDataList (KdsDataList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KdsEntryStatus::~KdsEntryStatus() {
}

inline KdsEntryStatus& KdsEntryStatus::operator = (const KdsEntryStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKdsEntry()) {
            setKdsEntry(rhs.getKdsEntry());
        } else {
            clearKdsEntry();
        }
        if (rhs.hasKdsDataList()) {
            setKdsDataList(rhs.getKdsDataList());
        } else {
            clearKdsDataList();
        }
    }
    return *this;
}

inline bool KdsEntryStatus::operator == (const KdsEntryStatus& rhs) const {
    return (((!hasKdsEntry() && !rhs.hasKdsEntry()) || getKdsEntry() == rhs.getKdsEntry()) &&
        ((!hasKdsDataList() && !rhs.hasKdsDataList()) || getKdsDataList() == rhs.getKdsDataList()));
}

inline bool KdsEntryStatus::operator != (const KdsEntryStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool KdsEntryStatus::operator < (const KdsEntryStatus& rhs) const {
    if (hasKdsEntry() || rhs.hasKdsEntry()) {
        if (getKdsEntry() < rhs.getKdsEntry()) return true;
        if (getKdsEntry() > rhs.getKdsEntry()) return false;
    }
    if (hasKdsDataList() || rhs.hasKdsDataList()) {
        if (getKdsDataList() < rhs.getKdsDataList()) return true;
        if (getKdsDataList() > rhs.getKdsDataList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KdsEntryStatus::clone() {
    return new KdsEntryStatus(*this);
}

inline bool KdsEntryStatus::operator > (const KdsEntryStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KdsEntryStatus::clear() {
    clearKdsEntry();
    clearKdsDataList();
}

inline void KdsEntryStatus::clearKdsEntry() {
    if (hasKdsEntry()) {
         clear_has_KdsEntry();
        _KdsEntry = 0u;
     }
}

inline bool KdsEntryStatus::hasKdsEntry () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 KdsEntryStatus::getKdsEntry () const {
    return _KdsEntry;
}

inline void KdsEntryStatus::setKdsEntry (uint32 KdsEntry_) {
    set_has_KdsEntry();
    this->_KdsEntry = KdsEntry_;
}

inline void KdsEntryStatus::clearKdsDataList() {
    if (hasKdsDataList()) {
         clear_has_KdsDataList();
        _KdsDataList.clear();
     }
}

inline bool KdsEntryStatus::hasKdsDataList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_KDSItemList& KdsEntryStatus::getKdsDataList () const {
    return _KdsDataList;
}

inline ::midw_diagnostics_fi_types::T_KDSItemList& KdsEntryStatus::getKdsDataListMutable () {
    set_has_KdsDataList();
    return _KdsDataList;
}

inline void KdsEntryStatus::setKdsDataList (const ::midw_diagnostics_fi_types::T_KDSItemList& KdsDataList_) {
    set_has_KdsDataList();
    this->_KdsDataList = KdsDataList_;
}

inline void KdsEntryStatus::set_has_KdsEntry () {
    _has_bits_[0] |= 1u << 0;
}

inline void KdsEntryStatus::clear_has_KdsEntry () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void KdsEntryStatus::set_has_KdsDataList () {
    _has_bits_[0] |= 1u << 1;
}

inline void KdsEntryStatus::clear_has_KdsDataList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  KdsEntrySet::KdsEntrySet ()  :
    _KdsEntry (0u),
    _KdsDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KdsEntrySet::KdsEntrySet (const KdsEntrySet &rhs)  :
    ::asf::core::Payload(rhs),
    _KdsEntry (0u),
    _KdsDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KdsEntrySet::KdsEntrySet (uint32 KdsEntry_, const ::midw_diagnostics_fi_types::T_KDSItemList& KdsDataList_)  :
    _KdsEntry (KdsEntry_),
    _KdsDataList (KdsDataList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KdsEntrySet::~KdsEntrySet() {
}

inline KdsEntrySet& KdsEntrySet::operator = (const KdsEntrySet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKdsEntry()) {
            setKdsEntry(rhs.getKdsEntry());
        } else {
            clearKdsEntry();
        }
        if (rhs.hasKdsDataList()) {
            setKdsDataList(rhs.getKdsDataList());
        } else {
            clearKdsDataList();
        }
    }
    return *this;
}

inline bool KdsEntrySet::operator == (const KdsEntrySet& rhs) const {
    return (((!hasKdsEntry() && !rhs.hasKdsEntry()) || getKdsEntry() == rhs.getKdsEntry()) &&
        ((!hasKdsDataList() && !rhs.hasKdsDataList()) || getKdsDataList() == rhs.getKdsDataList()));
}

inline bool KdsEntrySet::operator != (const KdsEntrySet& rhs) const {
    return ! (*this == rhs);
}

inline bool KdsEntrySet::operator < (const KdsEntrySet& rhs) const {
    if (hasKdsEntry() || rhs.hasKdsEntry()) {
        if (getKdsEntry() < rhs.getKdsEntry()) return true;
        if (getKdsEntry() > rhs.getKdsEntry()) return false;
    }
    if (hasKdsDataList() || rhs.hasKdsDataList()) {
        if (getKdsDataList() < rhs.getKdsDataList()) return true;
        if (getKdsDataList() > rhs.getKdsDataList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KdsEntrySet::clone() {
    return new KdsEntrySet(*this);
}

inline bool KdsEntrySet::operator > (const KdsEntrySet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KdsEntrySet::clear() {
    clearKdsEntry();
    clearKdsDataList();
}

inline void KdsEntrySet::clearKdsEntry() {
    if (hasKdsEntry()) {
         clear_has_KdsEntry();
        _KdsEntry = 0u;
     }
}

inline bool KdsEntrySet::hasKdsEntry () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 KdsEntrySet::getKdsEntry () const {
    return _KdsEntry;
}

inline void KdsEntrySet::setKdsEntry (uint32 KdsEntry_) {
    set_has_KdsEntry();
    this->_KdsEntry = KdsEntry_;
}

inline void KdsEntrySet::clearKdsDataList() {
    if (hasKdsDataList()) {
         clear_has_KdsDataList();
        _KdsDataList.clear();
     }
}

inline bool KdsEntrySet::hasKdsDataList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_KDSItemList& KdsEntrySet::getKdsDataList () const {
    return _KdsDataList;
}

inline ::midw_diagnostics_fi_types::T_KDSItemList& KdsEntrySet::getKdsDataListMutable () {
    set_has_KdsDataList();
    return _KdsDataList;
}

inline void KdsEntrySet::setKdsDataList (const ::midw_diagnostics_fi_types::T_KDSItemList& KdsDataList_) {
    set_has_KdsDataList();
    this->_KdsDataList = KdsDataList_;
}

inline void KdsEntrySet::set_has_KdsEntry () {
    _has_bits_[0] |= 1u << 0;
}

inline void KdsEntrySet::clear_has_KdsEntry () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void KdsEntrySet::set_has_KdsDataList () {
    _has_bits_[0] |= 1u << 1;
}

inline void KdsEntrySet::clear_has_KdsDataList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  KdsEntryGet::KdsEntryGet ()  :
    _KdsEntry (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KdsEntryGet::KdsEntryGet (const KdsEntryGet &rhs)  :
    ::asf::core::Payload(rhs),
    _KdsEntry (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KdsEntryGet::KdsEntryGet (uint32 KdsEntry_)  :
    _KdsEntry (KdsEntry_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KdsEntryGet::~KdsEntryGet() {
}

inline KdsEntryGet& KdsEntryGet::operator = (const KdsEntryGet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKdsEntry()) {
            setKdsEntry(rhs.getKdsEntry());
        } else {
            clearKdsEntry();
        }
    }
    return *this;
}

inline bool KdsEntryGet::operator == (const KdsEntryGet& rhs) const {
    return (((!hasKdsEntry() && !rhs.hasKdsEntry()) || getKdsEntry() == rhs.getKdsEntry()));
}

inline bool KdsEntryGet::operator != (const KdsEntryGet& rhs) const {
    return ! (*this == rhs);
}

inline bool KdsEntryGet::operator < (const KdsEntryGet& rhs) const {
    if (hasKdsEntry() || rhs.hasKdsEntry()) {
        if (getKdsEntry() < rhs.getKdsEntry()) return true;
        if (getKdsEntry() > rhs.getKdsEntry()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KdsEntryGet::clone() {
    return new KdsEntryGet(*this);
}

inline bool KdsEntryGet::operator > (const KdsEntryGet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KdsEntryGet::clear() {
    clearKdsEntry();
}

inline void KdsEntryGet::clearKdsEntry() {
    if (hasKdsEntry()) {
         clear_has_KdsEntry();
        _KdsEntry = 0u;
     }
}

inline bool KdsEntryGet::hasKdsEntry () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 KdsEntryGet::getKdsEntry () const {
    return _KdsEntry;
}

inline void KdsEntryGet::setKdsEntry (uint32 KdsEntry_) {
    set_has_KdsEntry();
    this->_KdsEntry = KdsEntry_;
}

inline void KdsEntryGet::set_has_KdsEntry () {
    _has_bits_[0] |= 1u << 0;
}

inline void KdsEntryGet::clear_has_KdsEntry () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  KdsEntryUpReg::KdsEntryUpReg ()  :
    _KdsEntry (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KdsEntryUpReg::KdsEntryUpReg (const KdsEntryUpReg &rhs)  :
    ::asf::core::Payload(rhs),
    _KdsEntry (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KdsEntryUpReg::KdsEntryUpReg (uint32 KdsEntry_)  :
    _KdsEntry (KdsEntry_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KdsEntryUpReg::~KdsEntryUpReg() {
}

inline KdsEntryUpReg& KdsEntryUpReg::operator = (const KdsEntryUpReg& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKdsEntry()) {
            setKdsEntry(rhs.getKdsEntry());
        } else {
            clearKdsEntry();
        }
    }
    return *this;
}

inline bool KdsEntryUpReg::operator == (const KdsEntryUpReg& rhs) const {
    return (((!hasKdsEntry() && !rhs.hasKdsEntry()) || getKdsEntry() == rhs.getKdsEntry()));
}

inline bool KdsEntryUpReg::operator != (const KdsEntryUpReg& rhs) const {
    return ! (*this == rhs);
}

inline bool KdsEntryUpReg::operator < (const KdsEntryUpReg& rhs) const {
    if (hasKdsEntry() || rhs.hasKdsEntry()) {
        if (getKdsEntry() < rhs.getKdsEntry()) return true;
        if (getKdsEntry() > rhs.getKdsEntry()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KdsEntryUpReg::clone() {
    return new KdsEntryUpReg(*this);
}

inline bool KdsEntryUpReg::operator > (const KdsEntryUpReg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KdsEntryUpReg::clear() {
    clearKdsEntry();
}

inline void KdsEntryUpReg::clearKdsEntry() {
    if (hasKdsEntry()) {
         clear_has_KdsEntry();
        _KdsEntry = 0u;
     }
}

inline bool KdsEntryUpReg::hasKdsEntry () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 KdsEntryUpReg::getKdsEntry () const {
    return _KdsEntry;
}

inline void KdsEntryUpReg::setKdsEntry (uint32 KdsEntry_) {
    set_has_KdsEntry();
    this->_KdsEntry = KdsEntry_;
}

inline void KdsEntryUpReg::set_has_KdsEntry () {
    _has_bits_[0] |= 1u << 0;
}

inline void KdsEntryUpReg::clear_has_KdsEntry () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  KdsEntryRelUpReg::KdsEntryRelUpReg ()  :
    _KdsEntry (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KdsEntryRelUpReg::KdsEntryRelUpReg (const KdsEntryRelUpReg &rhs)  :
    ::asf::core::Payload(rhs),
    _KdsEntry (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KdsEntryRelUpReg::KdsEntryRelUpReg (uint32 KdsEntry_)  :
    _KdsEntry (KdsEntry_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KdsEntryRelUpReg::~KdsEntryRelUpReg() {
}

inline KdsEntryRelUpReg& KdsEntryRelUpReg::operator = (const KdsEntryRelUpReg& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKdsEntry()) {
            setKdsEntry(rhs.getKdsEntry());
        } else {
            clearKdsEntry();
        }
    }
    return *this;
}

inline bool KdsEntryRelUpReg::operator == (const KdsEntryRelUpReg& rhs) const {
    return (((!hasKdsEntry() && !rhs.hasKdsEntry()) || getKdsEntry() == rhs.getKdsEntry()));
}

inline bool KdsEntryRelUpReg::operator != (const KdsEntryRelUpReg& rhs) const {
    return ! (*this == rhs);
}

inline bool KdsEntryRelUpReg::operator < (const KdsEntryRelUpReg& rhs) const {
    if (hasKdsEntry() || rhs.hasKdsEntry()) {
        if (getKdsEntry() < rhs.getKdsEntry()) return true;
        if (getKdsEntry() > rhs.getKdsEntry()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KdsEntryRelUpReg::clone() {
    return new KdsEntryRelUpReg(*this);
}

inline bool KdsEntryRelUpReg::operator > (const KdsEntryRelUpReg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KdsEntryRelUpReg::clear() {
    clearKdsEntry();
}

inline void KdsEntryRelUpReg::clearKdsEntry() {
    if (hasKdsEntry()) {
         clear_has_KdsEntry();
        _KdsEntry = 0u;
     }
}

inline bool KdsEntryRelUpReg::hasKdsEntry () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 KdsEntryRelUpReg::getKdsEntry () const {
    return _KdsEntry;
}

inline void KdsEntryRelUpReg::setKdsEntry (uint32 KdsEntry_) {
    set_has_KdsEntry();
    this->_KdsEntry = KdsEntry_;
}

inline void KdsEntryRelUpReg::set_has_KdsEntry () {
    _has_bits_[0] |= 1u << 0;
}

inline void KdsEntryRelUpReg::clear_has_KdsEntry () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiagConfigItemStatus::DiagConfigItemStatus ()  :
    _ConfigItem (0u),
    _ConfigItemValid (false),
    _ConfigItemContent ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiagConfigItemStatus::DiagConfigItemStatus (const DiagConfigItemStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ConfigItem (0u),
    _ConfigItemValid (false),
    _ConfigItemContent ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiagConfigItemStatus::DiagConfigItemStatus (uint32 ConfigItem_, bool ConfigItemValid_, const ::midw_diagnostics_fi_types::T_ConfigItemList& ConfigItemContent_)  :
    _ConfigItem (ConfigItem_),
    _ConfigItemValid (ConfigItemValid_),
    _ConfigItemContent (ConfigItemContent_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiagConfigItemStatus::~DiagConfigItemStatus() {
}

inline DiagConfigItemStatus& DiagConfigItemStatus::operator = (const DiagConfigItemStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfigItem()) {
            setConfigItem(rhs.getConfigItem());
        } else {
            clearConfigItem();
        }
        if (rhs.hasConfigItemValid()) {
            setConfigItemValid(rhs.getConfigItemValid());
        } else {
            clearConfigItemValid();
        }
        if (rhs.hasConfigItemContent()) {
            setConfigItemContent(rhs.getConfigItemContent());
        } else {
            clearConfigItemContent();
        }
    }
    return *this;
}

inline bool DiagConfigItemStatus::operator == (const DiagConfigItemStatus& rhs) const {
    return (((!hasConfigItem() && !rhs.hasConfigItem()) || getConfigItem() == rhs.getConfigItem()) &&
        ((!hasConfigItemValid() && !rhs.hasConfigItemValid()) || getConfigItemValid() == rhs.getConfigItemValid()) &&
        ((!hasConfigItemContent() && !rhs.hasConfigItemContent()) || getConfigItemContent() == rhs.getConfigItemContent()));
}

inline bool DiagConfigItemStatus::operator != (const DiagConfigItemStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiagConfigItemStatus::operator < (const DiagConfigItemStatus& rhs) const {
    if (hasConfigItem() || rhs.hasConfigItem()) {
        if (getConfigItem() < rhs.getConfigItem()) return true;
        if (getConfigItem() > rhs.getConfigItem()) return false;
    }
    if (hasConfigItemValid() || rhs.hasConfigItemValid()) {
        if (getConfigItemValid() < rhs.getConfigItemValid()) return true;
        if (getConfigItemValid() > rhs.getConfigItemValid()) return false;
    }
    if (hasConfigItemContent() || rhs.hasConfigItemContent()) {
        if (getConfigItemContent() < rhs.getConfigItemContent()) return true;
        if (getConfigItemContent() > rhs.getConfigItemContent()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiagConfigItemStatus::clone() {
    return new DiagConfigItemStatus(*this);
}

inline bool DiagConfigItemStatus::operator > (const DiagConfigItemStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiagConfigItemStatus::clear() {
    clearConfigItem();
    clearConfigItemValid();
    clearConfigItemContent();
}

inline void DiagConfigItemStatus::clearConfigItem() {
    if (hasConfigItem()) {
         clear_has_ConfigItem();
        _ConfigItem = 0u;
     }
}

inline bool DiagConfigItemStatus::hasConfigItem () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DiagConfigItemStatus::getConfigItem () const {
    return _ConfigItem;
}

inline void DiagConfigItemStatus::setConfigItem (uint32 ConfigItem_) {
    set_has_ConfigItem();
    this->_ConfigItem = ConfigItem_;
}

inline void DiagConfigItemStatus::clearConfigItemValid() {
    if (hasConfigItemValid()) {
         clear_has_ConfigItemValid();
        _ConfigItemValid = false;
     }
}

inline bool DiagConfigItemStatus::hasConfigItemValid () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool DiagConfigItemStatus::getConfigItemValid () const {
    return _ConfigItemValid;
}

inline void DiagConfigItemStatus::setConfigItemValid (bool ConfigItemValid_) {
    set_has_ConfigItemValid();
    this->_ConfigItemValid = ConfigItemValid_;
}

inline void DiagConfigItemStatus::clearConfigItemContent() {
    if (hasConfigItemContent()) {
         clear_has_ConfigItemContent();
        _ConfigItemContent.clear();
     }
}

inline bool DiagConfigItemStatus::hasConfigItemContent () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_ConfigItemList& DiagConfigItemStatus::getConfigItemContent () const {
    return _ConfigItemContent;
}

inline ::midw_diagnostics_fi_types::T_ConfigItemList& DiagConfigItemStatus::getConfigItemContentMutable () {
    set_has_ConfigItemContent();
    return _ConfigItemContent;
}

inline void DiagConfigItemStatus::setConfigItemContent (const ::midw_diagnostics_fi_types::T_ConfigItemList& ConfigItemContent_) {
    set_has_ConfigItemContent();
    this->_ConfigItemContent = ConfigItemContent_;
}

inline void DiagConfigItemStatus::set_has_ConfigItem () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiagConfigItemStatus::clear_has_ConfigItem () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiagConfigItemStatus::set_has_ConfigItemValid () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiagConfigItemStatus::clear_has_ConfigItemValid () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiagConfigItemStatus::set_has_ConfigItemContent () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiagConfigItemStatus::clear_has_ConfigItemContent () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DiagConfigItemSet::DiagConfigItemSet ()  :
    _ConfigItem (0u),
    _ConfigItemContent ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiagConfigItemSet::DiagConfigItemSet (const DiagConfigItemSet &rhs)  :
    ::asf::core::Payload(rhs),
    _ConfigItem (0u),
    _ConfigItemContent ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiagConfigItemSet::DiagConfigItemSet (uint32 ConfigItem_, const ::midw_diagnostics_fi_types::T_ConfigItemList& ConfigItemContent_)  :
    _ConfigItem (ConfigItem_),
    _ConfigItemContent (ConfigItemContent_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiagConfigItemSet::~DiagConfigItemSet() {
}

inline DiagConfigItemSet& DiagConfigItemSet::operator = (const DiagConfigItemSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfigItem()) {
            setConfigItem(rhs.getConfigItem());
        } else {
            clearConfigItem();
        }
        if (rhs.hasConfigItemContent()) {
            setConfigItemContent(rhs.getConfigItemContent());
        } else {
            clearConfigItemContent();
        }
    }
    return *this;
}

inline bool DiagConfigItemSet::operator == (const DiagConfigItemSet& rhs) const {
    return (((!hasConfigItem() && !rhs.hasConfigItem()) || getConfigItem() == rhs.getConfigItem()) &&
        ((!hasConfigItemContent() && !rhs.hasConfigItemContent()) || getConfigItemContent() == rhs.getConfigItemContent()));
}

inline bool DiagConfigItemSet::operator != (const DiagConfigItemSet& rhs) const {
    return ! (*this == rhs);
}

inline bool DiagConfigItemSet::operator < (const DiagConfigItemSet& rhs) const {
    if (hasConfigItem() || rhs.hasConfigItem()) {
        if (getConfigItem() < rhs.getConfigItem()) return true;
        if (getConfigItem() > rhs.getConfigItem()) return false;
    }
    if (hasConfigItemContent() || rhs.hasConfigItemContent()) {
        if (getConfigItemContent() < rhs.getConfigItemContent()) return true;
        if (getConfigItemContent() > rhs.getConfigItemContent()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiagConfigItemSet::clone() {
    return new DiagConfigItemSet(*this);
}

inline bool DiagConfigItemSet::operator > (const DiagConfigItemSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiagConfigItemSet::clear() {
    clearConfigItem();
    clearConfigItemContent();
}

inline void DiagConfigItemSet::clearConfigItem() {
    if (hasConfigItem()) {
         clear_has_ConfigItem();
        _ConfigItem = 0u;
     }
}

inline bool DiagConfigItemSet::hasConfigItem () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DiagConfigItemSet::getConfigItem () const {
    return _ConfigItem;
}

inline void DiagConfigItemSet::setConfigItem (uint32 ConfigItem_) {
    set_has_ConfigItem();
    this->_ConfigItem = ConfigItem_;
}

inline void DiagConfigItemSet::clearConfigItemContent() {
    if (hasConfigItemContent()) {
         clear_has_ConfigItemContent();
        _ConfigItemContent.clear();
     }
}

inline bool DiagConfigItemSet::hasConfigItemContent () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_ConfigItemList& DiagConfigItemSet::getConfigItemContent () const {
    return _ConfigItemContent;
}

inline ::midw_diagnostics_fi_types::T_ConfigItemList& DiagConfigItemSet::getConfigItemContentMutable () {
    set_has_ConfigItemContent();
    return _ConfigItemContent;
}

inline void DiagConfigItemSet::setConfigItemContent (const ::midw_diagnostics_fi_types::T_ConfigItemList& ConfigItemContent_) {
    set_has_ConfigItemContent();
    this->_ConfigItemContent = ConfigItemContent_;
}

inline void DiagConfigItemSet::set_has_ConfigItem () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiagConfigItemSet::clear_has_ConfigItem () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiagConfigItemSet::set_has_ConfigItemContent () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiagConfigItemSet::clear_has_ConfigItemContent () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DiagConfigItemGet::DiagConfigItemGet ()  :
    _ConfigItem (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiagConfigItemGet::DiagConfigItemGet (const DiagConfigItemGet &rhs)  :
    ::asf::core::Payload(rhs),
    _ConfigItem (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiagConfigItemGet::DiagConfigItemGet (uint32 ConfigItem_)  :
    _ConfigItem (ConfigItem_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiagConfigItemGet::~DiagConfigItemGet() {
}

inline DiagConfigItemGet& DiagConfigItemGet::operator = (const DiagConfigItemGet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfigItem()) {
            setConfigItem(rhs.getConfigItem());
        } else {
            clearConfigItem();
        }
    }
    return *this;
}

inline bool DiagConfigItemGet::operator == (const DiagConfigItemGet& rhs) const {
    return (((!hasConfigItem() && !rhs.hasConfigItem()) || getConfigItem() == rhs.getConfigItem()));
}

inline bool DiagConfigItemGet::operator != (const DiagConfigItemGet& rhs) const {
    return ! (*this == rhs);
}

inline bool DiagConfigItemGet::operator < (const DiagConfigItemGet& rhs) const {
    if (hasConfigItem() || rhs.hasConfigItem()) {
        if (getConfigItem() < rhs.getConfigItem()) return true;
        if (getConfigItem() > rhs.getConfigItem()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiagConfigItemGet::clone() {
    return new DiagConfigItemGet(*this);
}

inline bool DiagConfigItemGet::operator > (const DiagConfigItemGet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiagConfigItemGet::clear() {
    clearConfigItem();
}

inline void DiagConfigItemGet::clearConfigItem() {
    if (hasConfigItem()) {
         clear_has_ConfigItem();
        _ConfigItem = 0u;
     }
}

inline bool DiagConfigItemGet::hasConfigItem () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DiagConfigItemGet::getConfigItem () const {
    return _ConfigItem;
}

inline void DiagConfigItemGet::setConfigItem (uint32 ConfigItem_) {
    set_has_ConfigItem();
    this->_ConfigItem = ConfigItem_;
}

inline void DiagConfigItemGet::set_has_ConfigItem () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiagConfigItemGet::clear_has_ConfigItem () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiagConfigItemUpReg::DiagConfigItemUpReg ()  :
    _ConfigItem (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiagConfigItemUpReg::DiagConfigItemUpReg (const DiagConfigItemUpReg &rhs)  :
    ::asf::core::Payload(rhs),
    _ConfigItem (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiagConfigItemUpReg::DiagConfigItemUpReg (uint32 ConfigItem_)  :
    _ConfigItem (ConfigItem_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiagConfigItemUpReg::~DiagConfigItemUpReg() {
}

inline DiagConfigItemUpReg& DiagConfigItemUpReg::operator = (const DiagConfigItemUpReg& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfigItem()) {
            setConfigItem(rhs.getConfigItem());
        } else {
            clearConfigItem();
        }
    }
    return *this;
}

inline bool DiagConfigItemUpReg::operator == (const DiagConfigItemUpReg& rhs) const {
    return (((!hasConfigItem() && !rhs.hasConfigItem()) || getConfigItem() == rhs.getConfigItem()));
}

inline bool DiagConfigItemUpReg::operator != (const DiagConfigItemUpReg& rhs) const {
    return ! (*this == rhs);
}

inline bool DiagConfigItemUpReg::operator < (const DiagConfigItemUpReg& rhs) const {
    if (hasConfigItem() || rhs.hasConfigItem()) {
        if (getConfigItem() < rhs.getConfigItem()) return true;
        if (getConfigItem() > rhs.getConfigItem()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiagConfigItemUpReg::clone() {
    return new DiagConfigItemUpReg(*this);
}

inline bool DiagConfigItemUpReg::operator > (const DiagConfigItemUpReg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiagConfigItemUpReg::clear() {
    clearConfigItem();
}

inline void DiagConfigItemUpReg::clearConfigItem() {
    if (hasConfigItem()) {
         clear_has_ConfigItem();
        _ConfigItem = 0u;
     }
}

inline bool DiagConfigItemUpReg::hasConfigItem () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DiagConfigItemUpReg::getConfigItem () const {
    return _ConfigItem;
}

inline void DiagConfigItemUpReg::setConfigItem (uint32 ConfigItem_) {
    set_has_ConfigItem();
    this->_ConfigItem = ConfigItem_;
}

inline void DiagConfigItemUpReg::set_has_ConfigItem () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiagConfigItemUpReg::clear_has_ConfigItem () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiagConfigItemRelUpReg::DiagConfigItemRelUpReg ()  :
    _ConfigItem (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiagConfigItemRelUpReg::DiagConfigItemRelUpReg (const DiagConfigItemRelUpReg &rhs)  :
    ::asf::core::Payload(rhs),
    _ConfigItem (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiagConfigItemRelUpReg::DiagConfigItemRelUpReg (uint32 ConfigItem_)  :
    _ConfigItem (ConfigItem_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiagConfigItemRelUpReg::~DiagConfigItemRelUpReg() {
}

inline DiagConfigItemRelUpReg& DiagConfigItemRelUpReg::operator = (const DiagConfigItemRelUpReg& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfigItem()) {
            setConfigItem(rhs.getConfigItem());
        } else {
            clearConfigItem();
        }
    }
    return *this;
}

inline bool DiagConfigItemRelUpReg::operator == (const DiagConfigItemRelUpReg& rhs) const {
    return (((!hasConfigItem() && !rhs.hasConfigItem()) || getConfigItem() == rhs.getConfigItem()));
}

inline bool DiagConfigItemRelUpReg::operator != (const DiagConfigItemRelUpReg& rhs) const {
    return ! (*this == rhs);
}

inline bool DiagConfigItemRelUpReg::operator < (const DiagConfigItemRelUpReg& rhs) const {
    if (hasConfigItem() || rhs.hasConfigItem()) {
        if (getConfigItem() < rhs.getConfigItem()) return true;
        if (getConfigItem() > rhs.getConfigItem()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiagConfigItemRelUpReg::clone() {
    return new DiagConfigItemRelUpReg(*this);
}

inline bool DiagConfigItemRelUpReg::operator > (const DiagConfigItemRelUpReg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiagConfigItemRelUpReg::clear() {
    clearConfigItem();
}

inline void DiagConfigItemRelUpReg::clearConfigItem() {
    if (hasConfigItem()) {
         clear_has_ConfigItem();
        _ConfigItem = 0u;
     }
}

inline bool DiagConfigItemRelUpReg::hasConfigItem () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DiagConfigItemRelUpReg::getConfigItem () const {
    return _ConfigItem;
}

inline void DiagConfigItemRelUpReg::setConfigItem (uint32 ConfigItem_) {
    set_has_ConfigItem();
    this->_ConfigItem = ConfigItem_;
}

inline void DiagConfigItemRelUpReg::set_has_ConfigItem () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiagConfigItemRelUpReg::clear_has_ConfigItem () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReadDiagLogStart::ReadDiagLogStart ()  :
    _TroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReadDiagLogStart::ReadDiagLogStart (const ReadDiagLogStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReadDiagLogStart::ReadDiagLogStart (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_)  :
    _TroubleCodes (TroubleCodes_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TroubleCodeType_IsValid(TroubleCodes_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TroubleCodes_, "T_e8_TroubleCodeType", "TroubleCodes", "ReadDiagLogStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReadDiagLogStart::~ReadDiagLogStart() {
}

inline ReadDiagLogStart& ReadDiagLogStart::operator = (const ReadDiagLogStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTroubleCodes()) {
            setTroubleCodes(rhs.getTroubleCodes());
        } else {
            clearTroubleCodes();
        }
    }
    return *this;
}

inline bool ReadDiagLogStart::operator == (const ReadDiagLogStart& rhs) const {
    return (((!hasTroubleCodes() && !rhs.hasTroubleCodes()) || getTroubleCodes() == rhs.getTroubleCodes()));
}

inline bool ReadDiagLogStart::operator != (const ReadDiagLogStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ReadDiagLogStart::operator < (const ReadDiagLogStart& rhs) const {
    if (hasTroubleCodes() || rhs.hasTroubleCodes()) {
        if ((uint32)getTroubleCodes() < (uint32)rhs.getTroubleCodes()) return true;
        if ((uint32)getTroubleCodes() > (uint32)rhs.getTroubleCodes()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReadDiagLogStart::clone() {
    return new ReadDiagLogStart(*this);
}

inline bool ReadDiagLogStart::operator > (const ReadDiagLogStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReadDiagLogStart::clear() {
    clearTroubleCodes();
}

inline void ReadDiagLogStart::clearTroubleCodes() {
    if (hasTroubleCodes()) {
         clear_has_TroubleCodes();
        _TroubleCodes = ::midw_diagnostics_fi_types::T_e8_TroubleCodeType__Undefined;
     }
}

inline bool ReadDiagLogStart::hasTroubleCodes () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_TroubleCodeType ReadDiagLogStart::getTroubleCodes () const {
    return _TroubleCodes;
}

inline void ReadDiagLogStart::setTroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TroubleCodeType_IsValid(TroubleCodes_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TroubleCodes_, "T_e8_TroubleCodeType", "TroubleCodes", "ReadDiagLogStart");
    }
    #endif
    set_has_TroubleCodes();
    this->_TroubleCodes = TroubleCodes_;
}

inline void ReadDiagLogStart::set_has_TroubleCodes () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReadDiagLogStart::clear_has_TroubleCodes () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReadDiagLogResult::ReadDiagLogResult ()  :
    _TroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType__Undefined),
    _TroubleCodeList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReadDiagLogResult::ReadDiagLogResult (const ReadDiagLogResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType__Undefined),
    _TroubleCodeList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReadDiagLogResult::ReadDiagLogResult (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_, const ::midw_diagnostics_fi_types::T_TroubleCodeList& TroubleCodeList_)  :
    _TroubleCodes (TroubleCodes_),
    _TroubleCodeList (TroubleCodeList_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TroubleCodeType_IsValid(TroubleCodes_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TroubleCodes_, "T_e8_TroubleCodeType", "TroubleCodes", "ReadDiagLogResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReadDiagLogResult::~ReadDiagLogResult() {
}

inline ReadDiagLogResult& ReadDiagLogResult::operator = (const ReadDiagLogResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTroubleCodes()) {
            setTroubleCodes(rhs.getTroubleCodes());
        } else {
            clearTroubleCodes();
        }
        if (rhs.hasTroubleCodeList()) {
            setTroubleCodeList(rhs.getTroubleCodeList());
        } else {
            clearTroubleCodeList();
        }
    }
    return *this;
}

inline bool ReadDiagLogResult::operator == (const ReadDiagLogResult& rhs) const {
    return (((!hasTroubleCodes() && !rhs.hasTroubleCodes()) || getTroubleCodes() == rhs.getTroubleCodes()) &&
        ((!hasTroubleCodeList() && !rhs.hasTroubleCodeList()) || getTroubleCodeList() == rhs.getTroubleCodeList()));
}

inline bool ReadDiagLogResult::operator != (const ReadDiagLogResult& rhs) const {
    return ! (*this == rhs);
}

inline bool ReadDiagLogResult::operator < (const ReadDiagLogResult& rhs) const {
    if (hasTroubleCodes() || rhs.hasTroubleCodes()) {
        if ((uint32)getTroubleCodes() < (uint32)rhs.getTroubleCodes()) return true;
        if ((uint32)getTroubleCodes() > (uint32)rhs.getTroubleCodes()) return false;
    }
    if (hasTroubleCodeList() || rhs.hasTroubleCodeList()) {
        if (getTroubleCodeList() < rhs.getTroubleCodeList()) return true;
        if (getTroubleCodeList() > rhs.getTroubleCodeList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReadDiagLogResult::clone() {
    return new ReadDiagLogResult(*this);
}

inline bool ReadDiagLogResult::operator > (const ReadDiagLogResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReadDiagLogResult::clear() {
    clearTroubleCodes();
    clearTroubleCodeList();
}

inline void ReadDiagLogResult::clearTroubleCodes() {
    if (hasTroubleCodes()) {
         clear_has_TroubleCodes();
        _TroubleCodes = ::midw_diagnostics_fi_types::T_e8_TroubleCodeType__Undefined;
     }
}

inline bool ReadDiagLogResult::hasTroubleCodes () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_TroubleCodeType ReadDiagLogResult::getTroubleCodes () const {
    return _TroubleCodes;
}

inline void ReadDiagLogResult::setTroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TroubleCodeType_IsValid(TroubleCodes_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TroubleCodes_, "T_e8_TroubleCodeType", "TroubleCodes", "ReadDiagLogResult");
    }
    #endif
    set_has_TroubleCodes();
    this->_TroubleCodes = TroubleCodes_;
}

inline void ReadDiagLogResult::clearTroubleCodeList() {
    if (hasTroubleCodeList()) {
         clear_has_TroubleCodeList();
        _TroubleCodeList.clear();
     }
}

inline bool ReadDiagLogResult::hasTroubleCodeList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_TroubleCodeList& ReadDiagLogResult::getTroubleCodeList () const {
    return _TroubleCodeList;
}

inline ::midw_diagnostics_fi_types::T_TroubleCodeList& ReadDiagLogResult::getTroubleCodeListMutable () {
    set_has_TroubleCodeList();
    return _TroubleCodeList;
}

inline void ReadDiagLogResult::setTroubleCodeList (const ::midw_diagnostics_fi_types::T_TroubleCodeList& TroubleCodeList_) {
    set_has_TroubleCodeList();
    this->_TroubleCodeList = TroubleCodeList_;
}

inline void ReadDiagLogResult::set_has_TroubleCodes () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReadDiagLogResult::clear_has_TroubleCodes () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReadDiagLogResult::set_has_TroubleCodeList () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReadDiagLogResult::clear_has_TroubleCodeList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ClearDiagLogStart::ClearDiagLogStart ()  :
    _TroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClearDiagLogStart::ClearDiagLogStart (const ClearDiagLogStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClearDiagLogStart::ClearDiagLogStart (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_)  :
    _TroubleCodes (TroubleCodes_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TroubleCodeType_IsValid(TroubleCodes_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TroubleCodes_, "T_e8_TroubleCodeType", "TroubleCodes", "ClearDiagLogStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClearDiagLogStart::~ClearDiagLogStart() {
}

inline ClearDiagLogStart& ClearDiagLogStart::operator = (const ClearDiagLogStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTroubleCodes()) {
            setTroubleCodes(rhs.getTroubleCodes());
        } else {
            clearTroubleCodes();
        }
    }
    return *this;
}

inline bool ClearDiagLogStart::operator == (const ClearDiagLogStart& rhs) const {
    return (((!hasTroubleCodes() && !rhs.hasTroubleCodes()) || getTroubleCodes() == rhs.getTroubleCodes()));
}

inline bool ClearDiagLogStart::operator != (const ClearDiagLogStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ClearDiagLogStart::operator < (const ClearDiagLogStart& rhs) const {
    if (hasTroubleCodes() || rhs.hasTroubleCodes()) {
        if ((uint32)getTroubleCodes() < (uint32)rhs.getTroubleCodes()) return true;
        if ((uint32)getTroubleCodes() > (uint32)rhs.getTroubleCodes()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClearDiagLogStart::clone() {
    return new ClearDiagLogStart(*this);
}

inline bool ClearDiagLogStart::operator > (const ClearDiagLogStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClearDiagLogStart::clear() {
    clearTroubleCodes();
}

inline void ClearDiagLogStart::clearTroubleCodes() {
    if (hasTroubleCodes()) {
         clear_has_TroubleCodes();
        _TroubleCodes = ::midw_diagnostics_fi_types::T_e8_TroubleCodeType__Undefined;
     }
}

inline bool ClearDiagLogStart::hasTroubleCodes () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_TroubleCodeType ClearDiagLogStart::getTroubleCodes () const {
    return _TroubleCodes;
}

inline void ClearDiagLogStart::setTroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TroubleCodeType_IsValid(TroubleCodes_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TroubleCodes_, "T_e8_TroubleCodeType", "TroubleCodes", "ClearDiagLogStart");
    }
    #endif
    set_has_TroubleCodes();
    this->_TroubleCodes = TroubleCodes_;
}

inline void ClearDiagLogStart::set_has_TroubleCodes () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClearDiagLogStart::clear_has_TroubleCodes () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ClearDiagLogResult::ClearDiagLogResult ()  :
    _TroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClearDiagLogResult::ClearDiagLogResult (const ClearDiagLogResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClearDiagLogResult::ClearDiagLogResult (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_)  :
    _TroubleCodes (TroubleCodes_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TroubleCodeType_IsValid(TroubleCodes_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TroubleCodes_, "T_e8_TroubleCodeType", "TroubleCodes", "ClearDiagLogResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClearDiagLogResult::~ClearDiagLogResult() {
}

inline ClearDiagLogResult& ClearDiagLogResult::operator = (const ClearDiagLogResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTroubleCodes()) {
            setTroubleCodes(rhs.getTroubleCodes());
        } else {
            clearTroubleCodes();
        }
    }
    return *this;
}

inline bool ClearDiagLogResult::operator == (const ClearDiagLogResult& rhs) const {
    return (((!hasTroubleCodes() && !rhs.hasTroubleCodes()) || getTroubleCodes() == rhs.getTroubleCodes()));
}

inline bool ClearDiagLogResult::operator != (const ClearDiagLogResult& rhs) const {
    return ! (*this == rhs);
}

inline bool ClearDiagLogResult::operator < (const ClearDiagLogResult& rhs) const {
    if (hasTroubleCodes() || rhs.hasTroubleCodes()) {
        if ((uint32)getTroubleCodes() < (uint32)rhs.getTroubleCodes()) return true;
        if ((uint32)getTroubleCodes() > (uint32)rhs.getTroubleCodes()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClearDiagLogResult::clone() {
    return new ClearDiagLogResult(*this);
}

inline bool ClearDiagLogResult::operator > (const ClearDiagLogResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClearDiagLogResult::clear() {
    clearTroubleCodes();
}

inline void ClearDiagLogResult::clearTroubleCodes() {
    if (hasTroubleCodes()) {
         clear_has_TroubleCodes();
        _TroubleCodes = ::midw_diagnostics_fi_types::T_e8_TroubleCodeType__Undefined;
     }
}

inline bool ClearDiagLogResult::hasTroubleCodes () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_TroubleCodeType ClearDiagLogResult::getTroubleCodes () const {
    return _TroubleCodes;
}

inline void ClearDiagLogResult::setTroubleCodes (::midw_diagnostics_fi_types::T_e8_TroubleCodeType TroubleCodes_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TroubleCodeType_IsValid(TroubleCodes_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TroubleCodes_, "T_e8_TroubleCodeType", "TroubleCodes", "ClearDiagLogResult");
    }
    #endif
    set_has_TroubleCodes();
    this->_TroubleCodes = TroubleCodes_;
}

inline void ClearDiagLogResult::set_has_TroubleCodes () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClearDiagLogResult::clear_has_TroubleCodes () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartDiagnosticTestStart::StartDiagnosticTestStart ()  :
    _TestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartDiagnosticTestStart::StartDiagnosticTestStart (const StartDiagnosticTestStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartDiagnosticTestStart::StartDiagnosticTestStart (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_)  :
    _TestRoutine (TestRoutine_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TestRoutines_IsValid(TestRoutine_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TestRoutine_, "T_e8_TestRoutines", "TestRoutine", "StartDiagnosticTestStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartDiagnosticTestStart::~StartDiagnosticTestStart() {
}

inline StartDiagnosticTestStart& StartDiagnosticTestStart::operator = (const StartDiagnosticTestStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTestRoutine()) {
            setTestRoutine(rhs.getTestRoutine());
        } else {
            clearTestRoutine();
        }
    }
    return *this;
}

inline bool StartDiagnosticTestStart::operator == (const StartDiagnosticTestStart& rhs) const {
    return (((!hasTestRoutine() && !rhs.hasTestRoutine()) || getTestRoutine() == rhs.getTestRoutine()));
}

inline bool StartDiagnosticTestStart::operator != (const StartDiagnosticTestStart& rhs) const {
    return ! (*this == rhs);
}

inline bool StartDiagnosticTestStart::operator < (const StartDiagnosticTestStart& rhs) const {
    if (hasTestRoutine() || rhs.hasTestRoutine()) {
        if ((uint32)getTestRoutine() < (uint32)rhs.getTestRoutine()) return true;
        if ((uint32)getTestRoutine() > (uint32)rhs.getTestRoutine()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartDiagnosticTestStart::clone() {
    return new StartDiagnosticTestStart(*this);
}

inline bool StartDiagnosticTestStart::operator > (const StartDiagnosticTestStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartDiagnosticTestStart::clear() {
    clearTestRoutine();
}

inline void StartDiagnosticTestStart::clearTestRoutine() {
    if (hasTestRoutine()) {
         clear_has_TestRoutine();
        _TestRoutine = ::midw_diagnostics_fi_types::T_e8_TestRoutines__Undefined;
     }
}

inline bool StartDiagnosticTestStart::hasTestRoutine () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_TestRoutines StartDiagnosticTestStart::getTestRoutine () const {
    return _TestRoutine;
}

inline void StartDiagnosticTestStart::setTestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TestRoutines_IsValid(TestRoutine_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TestRoutine_, "T_e8_TestRoutines", "TestRoutine", "StartDiagnosticTestStart");
    }
    #endif
    set_has_TestRoutine();
    this->_TestRoutine = TestRoutine_;
}

inline void StartDiagnosticTestStart::set_has_TestRoutine () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartDiagnosticTestStart::clear_has_TestRoutine () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartDiagnosticTestResult::StartDiagnosticTestResult ()  :
    _TestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines__Undefined),
    _Success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartDiagnosticTestResult::StartDiagnosticTestResult (const StartDiagnosticTestResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines__Undefined),
    _Success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartDiagnosticTestResult::StartDiagnosticTestResult (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_, bool Success_)  :
    _TestRoutine (TestRoutine_),
    _Success (Success_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TestRoutines_IsValid(TestRoutine_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TestRoutine_, "T_e8_TestRoutines", "TestRoutine", "StartDiagnosticTestResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartDiagnosticTestResult::~StartDiagnosticTestResult() {
}

inline StartDiagnosticTestResult& StartDiagnosticTestResult::operator = (const StartDiagnosticTestResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTestRoutine()) {
            setTestRoutine(rhs.getTestRoutine());
        } else {
            clearTestRoutine();
        }
        if (rhs.hasSuccess()) {
            setSuccess(rhs.getSuccess());
        } else {
            clearSuccess();
        }
    }
    return *this;
}

inline bool StartDiagnosticTestResult::operator == (const StartDiagnosticTestResult& rhs) const {
    return (((!hasTestRoutine() && !rhs.hasTestRoutine()) || getTestRoutine() == rhs.getTestRoutine()) &&
        ((!hasSuccess() && !rhs.hasSuccess()) || getSuccess() == rhs.getSuccess()));
}

inline bool StartDiagnosticTestResult::operator != (const StartDiagnosticTestResult& rhs) const {
    return ! (*this == rhs);
}

inline bool StartDiagnosticTestResult::operator < (const StartDiagnosticTestResult& rhs) const {
    if (hasTestRoutine() || rhs.hasTestRoutine()) {
        if ((uint32)getTestRoutine() < (uint32)rhs.getTestRoutine()) return true;
        if ((uint32)getTestRoutine() > (uint32)rhs.getTestRoutine()) return false;
    }
    if (hasSuccess() || rhs.hasSuccess()) {
        if (getSuccess() < rhs.getSuccess()) return true;
        if (getSuccess() > rhs.getSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartDiagnosticTestResult::clone() {
    return new StartDiagnosticTestResult(*this);
}

inline bool StartDiagnosticTestResult::operator > (const StartDiagnosticTestResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartDiagnosticTestResult::clear() {
    clearTestRoutine();
    clearSuccess();
}

inline void StartDiagnosticTestResult::clearTestRoutine() {
    if (hasTestRoutine()) {
         clear_has_TestRoutine();
        _TestRoutine = ::midw_diagnostics_fi_types::T_e8_TestRoutines__Undefined;
     }
}

inline bool StartDiagnosticTestResult::hasTestRoutine () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_TestRoutines StartDiagnosticTestResult::getTestRoutine () const {
    return _TestRoutine;
}

inline void StartDiagnosticTestResult::setTestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TestRoutines_IsValid(TestRoutine_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TestRoutine_, "T_e8_TestRoutines", "TestRoutine", "StartDiagnosticTestResult");
    }
    #endif
    set_has_TestRoutine();
    this->_TestRoutine = TestRoutine_;
}

inline void StartDiagnosticTestResult::clearSuccess() {
    if (hasSuccess()) {
         clear_has_Success();
        _Success = false;
     }
}

inline bool StartDiagnosticTestResult::hasSuccess () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool StartDiagnosticTestResult::getSuccess () const {
    return _Success;
}

inline void StartDiagnosticTestResult::setSuccess (bool Success_) {
    set_has_Success();
    this->_Success = Success_;
}

inline void StartDiagnosticTestResult::set_has_TestRoutine () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartDiagnosticTestResult::clear_has_TestRoutine () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartDiagnosticTestResult::set_has_Success () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartDiagnosticTestResult::clear_has_Success () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetDefaultSettingsStart::SetDefaultSettingsStart ()  :
    _SettingsCategory (::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetDefaultSettingsStart::SetDefaultSettingsStart (const SetDefaultSettingsStart &rhs)  :
    ::asf::core::Payload(rhs),
    _SettingsCategory (::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetDefaultSettingsStart::SetDefaultSettingsStart (::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories SettingsCategory_)  :
    _SettingsCategory (SettingsCategory_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories_IsValid(SettingsCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SettingsCategory_, "T_e8_DefaultSettingsCategories", "SettingsCategory", "SetDefaultSettingsStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetDefaultSettingsStart::~SetDefaultSettingsStart() {
}

inline SetDefaultSettingsStart& SetDefaultSettingsStart::operator = (const SetDefaultSettingsStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSettingsCategory()) {
            setSettingsCategory(rhs.getSettingsCategory());
        } else {
            clearSettingsCategory();
        }
    }
    return *this;
}

inline bool SetDefaultSettingsStart::operator == (const SetDefaultSettingsStart& rhs) const {
    return (((!hasSettingsCategory() && !rhs.hasSettingsCategory()) || getSettingsCategory() == rhs.getSettingsCategory()));
}

inline bool SetDefaultSettingsStart::operator != (const SetDefaultSettingsStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetDefaultSettingsStart::operator < (const SetDefaultSettingsStart& rhs) const {
    if (hasSettingsCategory() || rhs.hasSettingsCategory()) {
        if ((uint32)getSettingsCategory() < (uint32)rhs.getSettingsCategory()) return true;
        if ((uint32)getSettingsCategory() > (uint32)rhs.getSettingsCategory()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetDefaultSettingsStart::clone() {
    return new SetDefaultSettingsStart(*this);
}

inline bool SetDefaultSettingsStart::operator > (const SetDefaultSettingsStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetDefaultSettingsStart::clear() {
    clearSettingsCategory();
}

inline void SetDefaultSettingsStart::clearSettingsCategory() {
    if (hasSettingsCategory()) {
         clear_has_SettingsCategory();
        _SettingsCategory = ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories__Undefined;
     }
}

inline bool SetDefaultSettingsStart::hasSettingsCategory () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories SetDefaultSettingsStart::getSettingsCategory () const {
    return _SettingsCategory;
}

inline void SetDefaultSettingsStart::setSettingsCategory (::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories SettingsCategory_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories_IsValid(SettingsCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SettingsCategory_, "T_e8_DefaultSettingsCategories", "SettingsCategory", "SetDefaultSettingsStart");
    }
    #endif
    set_has_SettingsCategory();
    this->_SettingsCategory = SettingsCategory_;
}

inline void SetDefaultSettingsStart::set_has_SettingsCategory () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetDefaultSettingsStart::clear_has_SettingsCategory () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetDefaultSettingsResult::SetDefaultSettingsResult ()  :
    _SettingsSuccessful (false),
    _SettingsCategory (::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetDefaultSettingsResult::SetDefaultSettingsResult (const SetDefaultSettingsResult &rhs)  :
    ::asf::core::Payload(rhs),
    _SettingsSuccessful (false),
    _SettingsCategory (::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetDefaultSettingsResult::SetDefaultSettingsResult (bool SettingsSuccessful_, ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories SettingsCategory_)  :
    _SettingsSuccessful (SettingsSuccessful_),
    _SettingsCategory (SettingsCategory_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories_IsValid(SettingsCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SettingsCategory_, "T_e8_DefaultSettingsCategories", "SettingsCategory", "SetDefaultSettingsResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetDefaultSettingsResult::~SetDefaultSettingsResult() {
}

inline SetDefaultSettingsResult& SetDefaultSettingsResult::operator = (const SetDefaultSettingsResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSettingsSuccessful()) {
            setSettingsSuccessful(rhs.getSettingsSuccessful());
        } else {
            clearSettingsSuccessful();
        }
        if (rhs.hasSettingsCategory()) {
            setSettingsCategory(rhs.getSettingsCategory());
        } else {
            clearSettingsCategory();
        }
    }
    return *this;
}

inline bool SetDefaultSettingsResult::operator == (const SetDefaultSettingsResult& rhs) const {
    return (((!hasSettingsSuccessful() && !rhs.hasSettingsSuccessful()) || getSettingsSuccessful() == rhs.getSettingsSuccessful()) &&
        ((!hasSettingsCategory() && !rhs.hasSettingsCategory()) || getSettingsCategory() == rhs.getSettingsCategory()));
}

inline bool SetDefaultSettingsResult::operator != (const SetDefaultSettingsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetDefaultSettingsResult::operator < (const SetDefaultSettingsResult& rhs) const {
    if (hasSettingsSuccessful() || rhs.hasSettingsSuccessful()) {
        if (getSettingsSuccessful() < rhs.getSettingsSuccessful()) return true;
        if (getSettingsSuccessful() > rhs.getSettingsSuccessful()) return false;
    }
    if (hasSettingsCategory() || rhs.hasSettingsCategory()) {
        if ((uint32)getSettingsCategory() < (uint32)rhs.getSettingsCategory()) return true;
        if ((uint32)getSettingsCategory() > (uint32)rhs.getSettingsCategory()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetDefaultSettingsResult::clone() {
    return new SetDefaultSettingsResult(*this);
}

inline bool SetDefaultSettingsResult::operator > (const SetDefaultSettingsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetDefaultSettingsResult::clear() {
    clearSettingsSuccessful();
    clearSettingsCategory();
}

inline void SetDefaultSettingsResult::clearSettingsSuccessful() {
    if (hasSettingsSuccessful()) {
         clear_has_SettingsSuccessful();
        _SettingsSuccessful = false;
     }
}

inline bool SetDefaultSettingsResult::hasSettingsSuccessful () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetDefaultSettingsResult::getSettingsSuccessful () const {
    return _SettingsSuccessful;
}

inline void SetDefaultSettingsResult::setSettingsSuccessful (bool SettingsSuccessful_) {
    set_has_SettingsSuccessful();
    this->_SettingsSuccessful = SettingsSuccessful_;
}

inline void SetDefaultSettingsResult::clearSettingsCategory() {
    if (hasSettingsCategory()) {
         clear_has_SettingsCategory();
        _SettingsCategory = ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories__Undefined;
     }
}

inline bool SetDefaultSettingsResult::hasSettingsCategory () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories SetDefaultSettingsResult::getSettingsCategory () const {
    return _SettingsCategory;
}

inline void SetDefaultSettingsResult::setSettingsCategory (::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories SettingsCategory_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories_IsValid(SettingsCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SettingsCategory_, "T_e8_DefaultSettingsCategories", "SettingsCategory", "SetDefaultSettingsResult");
    }
    #endif
    set_has_SettingsCategory();
    this->_SettingsCategory = SettingsCategory_;
}

inline void SetDefaultSettingsResult::set_has_SettingsSuccessful () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetDefaultSettingsResult::clear_has_SettingsSuccessful () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetDefaultSettingsResult::set_has_SettingsCategory () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetDefaultSettingsResult::clear_has_SettingsCategory () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EnableTimeSlotStart::EnableTimeSlotStart ()  :
    _MausSetup (::midw_diagnostics_fi_types::T_e8_DiagMausSetup__MAUS_STATE_UNDEFINED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EnableTimeSlotStart::EnableTimeSlotStart (const EnableTimeSlotStart &rhs)  :
    ::asf::core::Payload(rhs),
    _MausSetup (::midw_diagnostics_fi_types::T_e8_DiagMausSetup__MAUS_STATE_UNDEFINED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EnableTimeSlotStart::EnableTimeSlotStart (::midw_diagnostics_fi_types::T_e8_DiagMausSetup MausSetup_)  :
    _MausSetup (MausSetup_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DiagMausSetup_IsValid(MausSetup_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MausSetup_, "T_e8_DiagMausSetup", "MausSetup", "EnableTimeSlotStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EnableTimeSlotStart::~EnableTimeSlotStart() {
}

inline EnableTimeSlotStart& EnableTimeSlotStart::operator = (const EnableTimeSlotStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMausSetup()) {
            setMausSetup(rhs.getMausSetup());
        } else {
            clearMausSetup();
        }
    }
    return *this;
}

inline bool EnableTimeSlotStart::operator == (const EnableTimeSlotStart& rhs) const {
    return (((!hasMausSetup() && !rhs.hasMausSetup()) || getMausSetup() == rhs.getMausSetup()));
}

inline bool EnableTimeSlotStart::operator != (const EnableTimeSlotStart& rhs) const {
    return ! (*this == rhs);
}

inline bool EnableTimeSlotStart::operator < (const EnableTimeSlotStart& rhs) const {
    if (hasMausSetup() || rhs.hasMausSetup()) {
        if ((uint32)getMausSetup() < (uint32)rhs.getMausSetup()) return true;
        if ((uint32)getMausSetup() > (uint32)rhs.getMausSetup()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EnableTimeSlotStart::clone() {
    return new EnableTimeSlotStart(*this);
}

inline bool EnableTimeSlotStart::operator > (const EnableTimeSlotStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EnableTimeSlotStart::clear() {
    clearMausSetup();
}

inline void EnableTimeSlotStart::clearMausSetup() {
    if (hasMausSetup()) {
         clear_has_MausSetup();
        _MausSetup = ::midw_diagnostics_fi_types::T_e8_DiagMausSetup__MAUS_STATE_UNDEFINED;
     }
}

inline bool EnableTimeSlotStart::hasMausSetup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DiagMausSetup EnableTimeSlotStart::getMausSetup () const {
    return _MausSetup;
}

inline void EnableTimeSlotStart::setMausSetup (::midw_diagnostics_fi_types::T_e8_DiagMausSetup MausSetup_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DiagMausSetup_IsValid(MausSetup_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MausSetup_, "T_e8_DiagMausSetup", "MausSetup", "EnableTimeSlotStart");
    }
    #endif
    set_has_MausSetup();
    this->_MausSetup = MausSetup_;
}

inline void EnableTimeSlotStart::set_has_MausSetup () {
    _has_bits_[0] |= 1u << 0;
}

inline void EnableTimeSlotStart::clear_has_MausSetup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EnableTimeSlotResult::EnableTimeSlotResult ()  :
    _EnableSuccessful (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EnableTimeSlotResult::EnableTimeSlotResult (const EnableTimeSlotResult &rhs)  :
    ::asf::core::Payload(rhs),
    _EnableSuccessful (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EnableTimeSlotResult::EnableTimeSlotResult (bool EnableSuccessful_)  :
    _EnableSuccessful (EnableSuccessful_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EnableTimeSlotResult::~EnableTimeSlotResult() {
}

inline EnableTimeSlotResult& EnableTimeSlotResult::operator = (const EnableTimeSlotResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnableSuccessful()) {
            setEnableSuccessful(rhs.getEnableSuccessful());
        } else {
            clearEnableSuccessful();
        }
    }
    return *this;
}

inline bool EnableTimeSlotResult::operator == (const EnableTimeSlotResult& rhs) const {
    return (((!hasEnableSuccessful() && !rhs.hasEnableSuccessful()) || getEnableSuccessful() == rhs.getEnableSuccessful()));
}

inline bool EnableTimeSlotResult::operator != (const EnableTimeSlotResult& rhs) const {
    return ! (*this == rhs);
}

inline bool EnableTimeSlotResult::operator < (const EnableTimeSlotResult& rhs) const {
    if (hasEnableSuccessful() || rhs.hasEnableSuccessful()) {
        if (getEnableSuccessful() < rhs.getEnableSuccessful()) return true;
        if (getEnableSuccessful() > rhs.getEnableSuccessful()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EnableTimeSlotResult::clone() {
    return new EnableTimeSlotResult(*this);
}

inline bool EnableTimeSlotResult::operator > (const EnableTimeSlotResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EnableTimeSlotResult::clear() {
    clearEnableSuccessful();
}

inline void EnableTimeSlotResult::clearEnableSuccessful() {
    if (hasEnableSuccessful()) {
         clear_has_EnableSuccessful();
        _EnableSuccessful = false;
     }
}

inline bool EnableTimeSlotResult::hasEnableSuccessful () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool EnableTimeSlotResult::getEnableSuccessful () const {
    return _EnableSuccessful;
}

inline void EnableTimeSlotResult::setEnableSuccessful (bool EnableSuccessful_) {
    set_has_EnableSuccessful();
    this->_EnableSuccessful = EnableSuccessful_;
}

inline void EnableTimeSlotResult::set_has_EnableSuccessful () {
    _has_bits_[0] |= 1u << 0;
}

inline void EnableTimeSlotResult::clear_has_EnableSuccessful () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StopDiagnosticTestStart::StopDiagnosticTestStart ()  :
    _TestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopDiagnosticTestStart::StopDiagnosticTestStart (const StopDiagnosticTestStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopDiagnosticTestStart::StopDiagnosticTestStart (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_)  :
    _TestRoutine (TestRoutine_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TestRoutines_IsValid(TestRoutine_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TestRoutine_, "T_e8_TestRoutines", "TestRoutine", "StopDiagnosticTestStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StopDiagnosticTestStart::~StopDiagnosticTestStart() {
}

inline StopDiagnosticTestStart& StopDiagnosticTestStart::operator = (const StopDiagnosticTestStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTestRoutine()) {
            setTestRoutine(rhs.getTestRoutine());
        } else {
            clearTestRoutine();
        }
    }
    return *this;
}

inline bool StopDiagnosticTestStart::operator == (const StopDiagnosticTestStart& rhs) const {
    return (((!hasTestRoutine() && !rhs.hasTestRoutine()) || getTestRoutine() == rhs.getTestRoutine()));
}

inline bool StopDiagnosticTestStart::operator != (const StopDiagnosticTestStart& rhs) const {
    return ! (*this == rhs);
}

inline bool StopDiagnosticTestStart::operator < (const StopDiagnosticTestStart& rhs) const {
    if (hasTestRoutine() || rhs.hasTestRoutine()) {
        if ((uint32)getTestRoutine() < (uint32)rhs.getTestRoutine()) return true;
        if ((uint32)getTestRoutine() > (uint32)rhs.getTestRoutine()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StopDiagnosticTestStart::clone() {
    return new StopDiagnosticTestStart(*this);
}

inline bool StopDiagnosticTestStart::operator > (const StopDiagnosticTestStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopDiagnosticTestStart::clear() {
    clearTestRoutine();
}

inline void StopDiagnosticTestStart::clearTestRoutine() {
    if (hasTestRoutine()) {
         clear_has_TestRoutine();
        _TestRoutine = ::midw_diagnostics_fi_types::T_e8_TestRoutines__Undefined;
     }
}

inline bool StopDiagnosticTestStart::hasTestRoutine () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_TestRoutines StopDiagnosticTestStart::getTestRoutine () const {
    return _TestRoutine;
}

inline void StopDiagnosticTestStart::setTestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TestRoutines_IsValid(TestRoutine_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TestRoutine_, "T_e8_TestRoutines", "TestRoutine", "StopDiagnosticTestStart");
    }
    #endif
    set_has_TestRoutine();
    this->_TestRoutine = TestRoutine_;
}

inline void StopDiagnosticTestStart::set_has_TestRoutine () {
    _has_bits_[0] |= 1u << 0;
}

inline void StopDiagnosticTestStart::clear_has_TestRoutine () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StopDiagnosticTestResult::StopDiagnosticTestResult ()  :
    _TestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines__Undefined),
    _Success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopDiagnosticTestResult::StopDiagnosticTestResult (const StopDiagnosticTestResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines__Undefined),
    _Success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopDiagnosticTestResult::StopDiagnosticTestResult (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_, bool Success_)  :
    _TestRoutine (TestRoutine_),
    _Success (Success_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TestRoutines_IsValid(TestRoutine_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TestRoutine_, "T_e8_TestRoutines", "TestRoutine", "StopDiagnosticTestResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StopDiagnosticTestResult::~StopDiagnosticTestResult() {
}

inline StopDiagnosticTestResult& StopDiagnosticTestResult::operator = (const StopDiagnosticTestResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTestRoutine()) {
            setTestRoutine(rhs.getTestRoutine());
        } else {
            clearTestRoutine();
        }
        if (rhs.hasSuccess()) {
            setSuccess(rhs.getSuccess());
        } else {
            clearSuccess();
        }
    }
    return *this;
}

inline bool StopDiagnosticTestResult::operator == (const StopDiagnosticTestResult& rhs) const {
    return (((!hasTestRoutine() && !rhs.hasTestRoutine()) || getTestRoutine() == rhs.getTestRoutine()) &&
        ((!hasSuccess() && !rhs.hasSuccess()) || getSuccess() == rhs.getSuccess()));
}

inline bool StopDiagnosticTestResult::operator != (const StopDiagnosticTestResult& rhs) const {
    return ! (*this == rhs);
}

inline bool StopDiagnosticTestResult::operator < (const StopDiagnosticTestResult& rhs) const {
    if (hasTestRoutine() || rhs.hasTestRoutine()) {
        if ((uint32)getTestRoutine() < (uint32)rhs.getTestRoutine()) return true;
        if ((uint32)getTestRoutine() > (uint32)rhs.getTestRoutine()) return false;
    }
    if (hasSuccess() || rhs.hasSuccess()) {
        if (getSuccess() < rhs.getSuccess()) return true;
        if (getSuccess() > rhs.getSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StopDiagnosticTestResult::clone() {
    return new StopDiagnosticTestResult(*this);
}

inline bool StopDiagnosticTestResult::operator > (const StopDiagnosticTestResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopDiagnosticTestResult::clear() {
    clearTestRoutine();
    clearSuccess();
}

inline void StopDiagnosticTestResult::clearTestRoutine() {
    if (hasTestRoutine()) {
         clear_has_TestRoutine();
        _TestRoutine = ::midw_diagnostics_fi_types::T_e8_TestRoutines__Undefined;
     }
}

inline bool StopDiagnosticTestResult::hasTestRoutine () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_TestRoutines StopDiagnosticTestResult::getTestRoutine () const {
    return _TestRoutine;
}

inline void StopDiagnosticTestResult::setTestRoutine (::midw_diagnostics_fi_types::T_e8_TestRoutines TestRoutine_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_TestRoutines_IsValid(TestRoutine_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TestRoutine_, "T_e8_TestRoutines", "TestRoutine", "StopDiagnosticTestResult");
    }
    #endif
    set_has_TestRoutine();
    this->_TestRoutine = TestRoutine_;
}

inline void StopDiagnosticTestResult::clearSuccess() {
    if (hasSuccess()) {
         clear_has_Success();
        _Success = false;
     }
}

inline bool StopDiagnosticTestResult::hasSuccess () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool StopDiagnosticTestResult::getSuccess () const {
    return _Success;
}

inline void StopDiagnosticTestResult::setSuccess (bool Success_) {
    set_has_Success();
    this->_Success = Success_;
}

inline void StopDiagnosticTestResult::set_has_TestRoutine () {
    _has_bits_[0] |= 1u << 0;
}

inline void StopDiagnosticTestResult::clear_has_TestRoutine () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StopDiagnosticTestResult::set_has_Success () {
    _has_bits_[0] |= 1u << 1;
}

inline void StopDiagnosticTestResult::clear_has_Success () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetFactorySettingsStatusStatus::SetFactorySettingsStatusStatus ()  :
    _DefSetStateGroup (0u),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF),
    _DefSetStateSuccessful (false),
    _DefSetStateFirstDifferentParameterId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFactorySettingsStatusStatus::SetFactorySettingsStatusStatus (const SetFactorySettingsStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetStateGroup (0u),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF),
    _DefSetStateSuccessful (false),
    _DefSetStateFirstDifferentParameterId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFactorySettingsStatusStatus::SetFactorySettingsStatusStatus (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_, bool DefSetStateSuccessful_, uint16 DefSetStateFirstDifferentParameterId_)  :
    _DefSetStateGroup (DefSetStateGroup_),
    _DefSetStateMode (DefSetStateMode_),
    _DefSetStateSuccessful (DefSetStateSuccessful_),
    _DefSetStateFirstDifferentParameterId (DefSetStateFirstDifferentParameterId_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFactorySettingsStatusStatus::~SetFactorySettingsStatusStatus() {
}

inline SetFactorySettingsStatusStatus& SetFactorySettingsStatusStatus::operator = (const SetFactorySettingsStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetStateGroup()) {
            setDefSetStateGroup(rhs.getDefSetStateGroup());
        } else {
            clearDefSetStateGroup();
        }
        if (rhs.hasDefSetStateMode()) {
            setDefSetStateMode(rhs.getDefSetStateMode());
        } else {
            clearDefSetStateMode();
        }
        if (rhs.hasDefSetStateSuccessful()) {
            setDefSetStateSuccessful(rhs.getDefSetStateSuccessful());
        } else {
            clearDefSetStateSuccessful();
        }
        if (rhs.hasDefSetStateFirstDifferentParameterId()) {
            setDefSetStateFirstDifferentParameterId(rhs.getDefSetStateFirstDifferentParameterId());
        } else {
            clearDefSetStateFirstDifferentParameterId();
        }
    }
    return *this;
}

inline bool SetFactorySettingsStatusStatus::operator == (const SetFactorySettingsStatusStatus& rhs) const {
    return (((!hasDefSetStateGroup() && !rhs.hasDefSetStateGroup()) || getDefSetStateGroup() == rhs.getDefSetStateGroup()) &&
        ((!hasDefSetStateMode() && !rhs.hasDefSetStateMode()) || getDefSetStateMode() == rhs.getDefSetStateMode()) &&
        ((!hasDefSetStateSuccessful() && !rhs.hasDefSetStateSuccessful()) || getDefSetStateSuccessful() == rhs.getDefSetStateSuccessful()) &&
        ((!hasDefSetStateFirstDifferentParameterId() && !rhs.hasDefSetStateFirstDifferentParameterId()) || getDefSetStateFirstDifferentParameterId() == rhs.getDefSetStateFirstDifferentParameterId()));
}

inline bool SetFactorySettingsStatusStatus::operator != (const SetFactorySettingsStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFactorySettingsStatusStatus::operator < (const SetFactorySettingsStatusStatus& rhs) const {
    if (hasDefSetStateGroup() || rhs.hasDefSetStateGroup()) {
        if (getDefSetStateGroup() < rhs.getDefSetStateGroup()) return true;
        if (getDefSetStateGroup() > rhs.getDefSetStateGroup()) return false;
    }
    if (hasDefSetStateMode() || rhs.hasDefSetStateMode()) {
        if ((uint32)getDefSetStateMode() < (uint32)rhs.getDefSetStateMode()) return true;
        if ((uint32)getDefSetStateMode() > (uint32)rhs.getDefSetStateMode()) return false;
    }
    if (hasDefSetStateSuccessful() || rhs.hasDefSetStateSuccessful()) {
        if (getDefSetStateSuccessful() < rhs.getDefSetStateSuccessful()) return true;
        if (getDefSetStateSuccessful() > rhs.getDefSetStateSuccessful()) return false;
    }
    if (hasDefSetStateFirstDifferentParameterId() || rhs.hasDefSetStateFirstDifferentParameterId()) {
        if (getDefSetStateFirstDifferentParameterId() < rhs.getDefSetStateFirstDifferentParameterId()) return true;
        if (getDefSetStateFirstDifferentParameterId() > rhs.getDefSetStateFirstDifferentParameterId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFactorySettingsStatusStatus::clone() {
    return new SetFactorySettingsStatusStatus(*this);
}

inline bool SetFactorySettingsStatusStatus::operator > (const SetFactorySettingsStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFactorySettingsStatusStatus::clear() {
    clearDefSetStateGroup();
    clearDefSetStateMode();
    clearDefSetStateSuccessful();
    clearDefSetStateFirstDifferentParameterId();
}

inline void SetFactorySettingsStatusStatus::clearDefSetStateGroup() {
    if (hasDefSetStateGroup()) {
         clear_has_DefSetStateGroup();
        _DefSetStateGroup = 0u;
     }
}

inline bool SetFactorySettingsStatusStatus::hasDefSetStateGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetFactorySettingsStatusStatus::getDefSetStateGroup () const {
    return _DefSetStateGroup;
}

inline void SetFactorySettingsStatusStatus::setDefSetStateGroup (uint8 DefSetStateGroup_) {
    set_has_DefSetStateGroup();
    this->_DefSetStateGroup = DefSetStateGroup_;
}

inline void SetFactorySettingsStatusStatus::clearDefSetStateMode() {
    if (hasDefSetStateMode()) {
         clear_has_DefSetStateMode();
        _DefSetStateMode = ::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF;
     }
}

inline bool SetFactorySettingsStatusStatus::hasDefSetStateMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DefSetMode SetFactorySettingsStatusStatus::getDefSetStateMode () const {
    return _DefSetStateMode;
}

inline void SetFactorySettingsStatusStatus::setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsStatusStatus");
    }
    #endif
    set_has_DefSetStateMode();
    this->_DefSetStateMode = DefSetStateMode_;
}

inline void SetFactorySettingsStatusStatus::clearDefSetStateSuccessful() {
    if (hasDefSetStateSuccessful()) {
         clear_has_DefSetStateSuccessful();
        _DefSetStateSuccessful = false;
     }
}

inline bool SetFactorySettingsStatusStatus::hasDefSetStateSuccessful () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool SetFactorySettingsStatusStatus::getDefSetStateSuccessful () const {
    return _DefSetStateSuccessful;
}

inline void SetFactorySettingsStatusStatus::setDefSetStateSuccessful (bool DefSetStateSuccessful_) {
    set_has_DefSetStateSuccessful();
    this->_DefSetStateSuccessful = DefSetStateSuccessful_;
}

inline void SetFactorySettingsStatusStatus::clearDefSetStateFirstDifferentParameterId() {
    if (hasDefSetStateFirstDifferentParameterId()) {
         clear_has_DefSetStateFirstDifferentParameterId();
        _DefSetStateFirstDifferentParameterId = 0u;
     }
}

inline bool SetFactorySettingsStatusStatus::hasDefSetStateFirstDifferentParameterId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 SetFactorySettingsStatusStatus::getDefSetStateFirstDifferentParameterId () const {
    return _DefSetStateFirstDifferentParameterId;
}

inline void SetFactorySettingsStatusStatus::setDefSetStateFirstDifferentParameterId (uint16 DefSetStateFirstDifferentParameterId_) {
    set_has_DefSetStateFirstDifferentParameterId();
    this->_DefSetStateFirstDifferentParameterId = DefSetStateFirstDifferentParameterId_;
}

inline void SetFactorySettingsStatusStatus::set_has_DefSetStateGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFactorySettingsStatusStatus::clear_has_DefSetStateGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetFactorySettingsStatusStatus::set_has_DefSetStateMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetFactorySettingsStatusStatus::clear_has_DefSetStateMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetFactorySettingsStatusStatus::set_has_DefSetStateSuccessful () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetFactorySettingsStatusStatus::clear_has_DefSetStateSuccessful () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SetFactorySettingsStatusStatus::set_has_DefSetStateFirstDifferentParameterId () {
    _has_bits_[0] |= 1u << 3;
}

inline void SetFactorySettingsStatusStatus::clear_has_DefSetStateFirstDifferentParameterId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SetFactorySettingsStatusSet::SetFactorySettingsStatusSet ()  :
    _DefSetStateGroup (0u),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF),
    _DefSetStateSuccessful (false),
    _DefSetStateFirstDifferentParameterId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFactorySettingsStatusSet::SetFactorySettingsStatusSet (const SetFactorySettingsStatusSet &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetStateGroup (0u),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF),
    _DefSetStateSuccessful (false),
    _DefSetStateFirstDifferentParameterId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFactorySettingsStatusSet::SetFactorySettingsStatusSet (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_, bool DefSetStateSuccessful_, uint16 DefSetStateFirstDifferentParameterId_)  :
    _DefSetStateGroup (DefSetStateGroup_),
    _DefSetStateMode (DefSetStateMode_),
    _DefSetStateSuccessful (DefSetStateSuccessful_),
    _DefSetStateFirstDifferentParameterId (DefSetStateFirstDifferentParameterId_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsStatusSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFactorySettingsStatusSet::~SetFactorySettingsStatusSet() {
}

inline SetFactorySettingsStatusSet& SetFactorySettingsStatusSet::operator = (const SetFactorySettingsStatusSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetStateGroup()) {
            setDefSetStateGroup(rhs.getDefSetStateGroup());
        } else {
            clearDefSetStateGroup();
        }
        if (rhs.hasDefSetStateMode()) {
            setDefSetStateMode(rhs.getDefSetStateMode());
        } else {
            clearDefSetStateMode();
        }
        if (rhs.hasDefSetStateSuccessful()) {
            setDefSetStateSuccessful(rhs.getDefSetStateSuccessful());
        } else {
            clearDefSetStateSuccessful();
        }
        if (rhs.hasDefSetStateFirstDifferentParameterId()) {
            setDefSetStateFirstDifferentParameterId(rhs.getDefSetStateFirstDifferentParameterId());
        } else {
            clearDefSetStateFirstDifferentParameterId();
        }
    }
    return *this;
}

inline bool SetFactorySettingsStatusSet::operator == (const SetFactorySettingsStatusSet& rhs) const {
    return (((!hasDefSetStateGroup() && !rhs.hasDefSetStateGroup()) || getDefSetStateGroup() == rhs.getDefSetStateGroup()) &&
        ((!hasDefSetStateMode() && !rhs.hasDefSetStateMode()) || getDefSetStateMode() == rhs.getDefSetStateMode()) &&
        ((!hasDefSetStateSuccessful() && !rhs.hasDefSetStateSuccessful()) || getDefSetStateSuccessful() == rhs.getDefSetStateSuccessful()) &&
        ((!hasDefSetStateFirstDifferentParameterId() && !rhs.hasDefSetStateFirstDifferentParameterId()) || getDefSetStateFirstDifferentParameterId() == rhs.getDefSetStateFirstDifferentParameterId()));
}

inline bool SetFactorySettingsStatusSet::operator != (const SetFactorySettingsStatusSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFactorySettingsStatusSet::operator < (const SetFactorySettingsStatusSet& rhs) const {
    if (hasDefSetStateGroup() || rhs.hasDefSetStateGroup()) {
        if (getDefSetStateGroup() < rhs.getDefSetStateGroup()) return true;
        if (getDefSetStateGroup() > rhs.getDefSetStateGroup()) return false;
    }
    if (hasDefSetStateMode() || rhs.hasDefSetStateMode()) {
        if ((uint32)getDefSetStateMode() < (uint32)rhs.getDefSetStateMode()) return true;
        if ((uint32)getDefSetStateMode() > (uint32)rhs.getDefSetStateMode()) return false;
    }
    if (hasDefSetStateSuccessful() || rhs.hasDefSetStateSuccessful()) {
        if (getDefSetStateSuccessful() < rhs.getDefSetStateSuccessful()) return true;
        if (getDefSetStateSuccessful() > rhs.getDefSetStateSuccessful()) return false;
    }
    if (hasDefSetStateFirstDifferentParameterId() || rhs.hasDefSetStateFirstDifferentParameterId()) {
        if (getDefSetStateFirstDifferentParameterId() < rhs.getDefSetStateFirstDifferentParameterId()) return true;
        if (getDefSetStateFirstDifferentParameterId() > rhs.getDefSetStateFirstDifferentParameterId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFactorySettingsStatusSet::clone() {
    return new SetFactorySettingsStatusSet(*this);
}

inline bool SetFactorySettingsStatusSet::operator > (const SetFactorySettingsStatusSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFactorySettingsStatusSet::clear() {
    clearDefSetStateGroup();
    clearDefSetStateMode();
    clearDefSetStateSuccessful();
    clearDefSetStateFirstDifferentParameterId();
}

inline void SetFactorySettingsStatusSet::clearDefSetStateGroup() {
    if (hasDefSetStateGroup()) {
         clear_has_DefSetStateGroup();
        _DefSetStateGroup = 0u;
     }
}

inline bool SetFactorySettingsStatusSet::hasDefSetStateGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetFactorySettingsStatusSet::getDefSetStateGroup () const {
    return _DefSetStateGroup;
}

inline void SetFactorySettingsStatusSet::setDefSetStateGroup (uint8 DefSetStateGroup_) {
    set_has_DefSetStateGroup();
    this->_DefSetStateGroup = DefSetStateGroup_;
}

inline void SetFactorySettingsStatusSet::clearDefSetStateMode() {
    if (hasDefSetStateMode()) {
         clear_has_DefSetStateMode();
        _DefSetStateMode = ::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF;
     }
}

inline bool SetFactorySettingsStatusSet::hasDefSetStateMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DefSetMode SetFactorySettingsStatusSet::getDefSetStateMode () const {
    return _DefSetStateMode;
}

inline void SetFactorySettingsStatusSet::setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsStatusSet");
    }
    #endif
    set_has_DefSetStateMode();
    this->_DefSetStateMode = DefSetStateMode_;
}

inline void SetFactorySettingsStatusSet::clearDefSetStateSuccessful() {
    if (hasDefSetStateSuccessful()) {
         clear_has_DefSetStateSuccessful();
        _DefSetStateSuccessful = false;
     }
}

inline bool SetFactorySettingsStatusSet::hasDefSetStateSuccessful () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool SetFactorySettingsStatusSet::getDefSetStateSuccessful () const {
    return _DefSetStateSuccessful;
}

inline void SetFactorySettingsStatusSet::setDefSetStateSuccessful (bool DefSetStateSuccessful_) {
    set_has_DefSetStateSuccessful();
    this->_DefSetStateSuccessful = DefSetStateSuccessful_;
}

inline void SetFactorySettingsStatusSet::clearDefSetStateFirstDifferentParameterId() {
    if (hasDefSetStateFirstDifferentParameterId()) {
         clear_has_DefSetStateFirstDifferentParameterId();
        _DefSetStateFirstDifferentParameterId = 0u;
     }
}

inline bool SetFactorySettingsStatusSet::hasDefSetStateFirstDifferentParameterId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 SetFactorySettingsStatusSet::getDefSetStateFirstDifferentParameterId () const {
    return _DefSetStateFirstDifferentParameterId;
}

inline void SetFactorySettingsStatusSet::setDefSetStateFirstDifferentParameterId (uint16 DefSetStateFirstDifferentParameterId_) {
    set_has_DefSetStateFirstDifferentParameterId();
    this->_DefSetStateFirstDifferentParameterId = DefSetStateFirstDifferentParameterId_;
}

inline void SetFactorySettingsStatusSet::set_has_DefSetStateGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFactorySettingsStatusSet::clear_has_DefSetStateGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetFactorySettingsStatusSet::set_has_DefSetStateMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetFactorySettingsStatusSet::clear_has_DefSetStateMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetFactorySettingsStatusSet::set_has_DefSetStateSuccessful () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetFactorySettingsStatusSet::clear_has_DefSetStateSuccessful () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SetFactorySettingsStatusSet::set_has_DefSetStateFirstDifferentParameterId () {
    _has_bits_[0] |= 1u << 3;
}

inline void SetFactorySettingsStatusSet::clear_has_DefSetStateFirstDifferentParameterId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SetFactorySettingsStatusGet::SetFactorySettingsStatusGet ()  :
    _DefSetStateGroup (0u),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF),
    _DefSetStateSuccessful (false),
    _DefSetStateFirstDifferentParameterId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFactorySettingsStatusGet::SetFactorySettingsStatusGet (const SetFactorySettingsStatusGet &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetStateGroup (0u),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF),
    _DefSetStateSuccessful (false),
    _DefSetStateFirstDifferentParameterId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFactorySettingsStatusGet::SetFactorySettingsStatusGet (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_, bool DefSetStateSuccessful_, uint16 DefSetStateFirstDifferentParameterId_)  :
    _DefSetStateGroup (DefSetStateGroup_),
    _DefSetStateMode (DefSetStateMode_),
    _DefSetStateSuccessful (DefSetStateSuccessful_),
    _DefSetStateFirstDifferentParameterId (DefSetStateFirstDifferentParameterId_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsStatusGet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFactorySettingsStatusGet::~SetFactorySettingsStatusGet() {
}

inline SetFactorySettingsStatusGet& SetFactorySettingsStatusGet::operator = (const SetFactorySettingsStatusGet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetStateGroup()) {
            setDefSetStateGroup(rhs.getDefSetStateGroup());
        } else {
            clearDefSetStateGroup();
        }
        if (rhs.hasDefSetStateMode()) {
            setDefSetStateMode(rhs.getDefSetStateMode());
        } else {
            clearDefSetStateMode();
        }
        if (rhs.hasDefSetStateSuccessful()) {
            setDefSetStateSuccessful(rhs.getDefSetStateSuccessful());
        } else {
            clearDefSetStateSuccessful();
        }
        if (rhs.hasDefSetStateFirstDifferentParameterId()) {
            setDefSetStateFirstDifferentParameterId(rhs.getDefSetStateFirstDifferentParameterId());
        } else {
            clearDefSetStateFirstDifferentParameterId();
        }
    }
    return *this;
}

inline bool SetFactorySettingsStatusGet::operator == (const SetFactorySettingsStatusGet& rhs) const {
    return (((!hasDefSetStateGroup() && !rhs.hasDefSetStateGroup()) || getDefSetStateGroup() == rhs.getDefSetStateGroup()) &&
        ((!hasDefSetStateMode() && !rhs.hasDefSetStateMode()) || getDefSetStateMode() == rhs.getDefSetStateMode()) &&
        ((!hasDefSetStateSuccessful() && !rhs.hasDefSetStateSuccessful()) || getDefSetStateSuccessful() == rhs.getDefSetStateSuccessful()) &&
        ((!hasDefSetStateFirstDifferentParameterId() && !rhs.hasDefSetStateFirstDifferentParameterId()) || getDefSetStateFirstDifferentParameterId() == rhs.getDefSetStateFirstDifferentParameterId()));
}

inline bool SetFactorySettingsStatusGet::operator != (const SetFactorySettingsStatusGet& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFactorySettingsStatusGet::operator < (const SetFactorySettingsStatusGet& rhs) const {
    if (hasDefSetStateGroup() || rhs.hasDefSetStateGroup()) {
        if (getDefSetStateGroup() < rhs.getDefSetStateGroup()) return true;
        if (getDefSetStateGroup() > rhs.getDefSetStateGroup()) return false;
    }
    if (hasDefSetStateMode() || rhs.hasDefSetStateMode()) {
        if ((uint32)getDefSetStateMode() < (uint32)rhs.getDefSetStateMode()) return true;
        if ((uint32)getDefSetStateMode() > (uint32)rhs.getDefSetStateMode()) return false;
    }
    if (hasDefSetStateSuccessful() || rhs.hasDefSetStateSuccessful()) {
        if (getDefSetStateSuccessful() < rhs.getDefSetStateSuccessful()) return true;
        if (getDefSetStateSuccessful() > rhs.getDefSetStateSuccessful()) return false;
    }
    if (hasDefSetStateFirstDifferentParameterId() || rhs.hasDefSetStateFirstDifferentParameterId()) {
        if (getDefSetStateFirstDifferentParameterId() < rhs.getDefSetStateFirstDifferentParameterId()) return true;
        if (getDefSetStateFirstDifferentParameterId() > rhs.getDefSetStateFirstDifferentParameterId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFactorySettingsStatusGet::clone() {
    return new SetFactorySettingsStatusGet(*this);
}

inline bool SetFactorySettingsStatusGet::operator > (const SetFactorySettingsStatusGet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFactorySettingsStatusGet::clear() {
    clearDefSetStateGroup();
    clearDefSetStateMode();
    clearDefSetStateSuccessful();
    clearDefSetStateFirstDifferentParameterId();
}

inline void SetFactorySettingsStatusGet::clearDefSetStateGroup() {
    if (hasDefSetStateGroup()) {
         clear_has_DefSetStateGroup();
        _DefSetStateGroup = 0u;
     }
}

inline bool SetFactorySettingsStatusGet::hasDefSetStateGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetFactorySettingsStatusGet::getDefSetStateGroup () const {
    return _DefSetStateGroup;
}

inline void SetFactorySettingsStatusGet::setDefSetStateGroup (uint8 DefSetStateGroup_) {
    set_has_DefSetStateGroup();
    this->_DefSetStateGroup = DefSetStateGroup_;
}

inline void SetFactorySettingsStatusGet::clearDefSetStateMode() {
    if (hasDefSetStateMode()) {
         clear_has_DefSetStateMode();
        _DefSetStateMode = ::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF;
     }
}

inline bool SetFactorySettingsStatusGet::hasDefSetStateMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DefSetMode SetFactorySettingsStatusGet::getDefSetStateMode () const {
    return _DefSetStateMode;
}

inline void SetFactorySettingsStatusGet::setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsStatusGet");
    }
    #endif
    set_has_DefSetStateMode();
    this->_DefSetStateMode = DefSetStateMode_;
}

inline void SetFactorySettingsStatusGet::clearDefSetStateSuccessful() {
    if (hasDefSetStateSuccessful()) {
         clear_has_DefSetStateSuccessful();
        _DefSetStateSuccessful = false;
     }
}

inline bool SetFactorySettingsStatusGet::hasDefSetStateSuccessful () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool SetFactorySettingsStatusGet::getDefSetStateSuccessful () const {
    return _DefSetStateSuccessful;
}

inline void SetFactorySettingsStatusGet::setDefSetStateSuccessful (bool DefSetStateSuccessful_) {
    set_has_DefSetStateSuccessful();
    this->_DefSetStateSuccessful = DefSetStateSuccessful_;
}

inline void SetFactorySettingsStatusGet::clearDefSetStateFirstDifferentParameterId() {
    if (hasDefSetStateFirstDifferentParameterId()) {
         clear_has_DefSetStateFirstDifferentParameterId();
        _DefSetStateFirstDifferentParameterId = 0u;
     }
}

inline bool SetFactorySettingsStatusGet::hasDefSetStateFirstDifferentParameterId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 SetFactorySettingsStatusGet::getDefSetStateFirstDifferentParameterId () const {
    return _DefSetStateFirstDifferentParameterId;
}

inline void SetFactorySettingsStatusGet::setDefSetStateFirstDifferentParameterId (uint16 DefSetStateFirstDifferentParameterId_) {
    set_has_DefSetStateFirstDifferentParameterId();
    this->_DefSetStateFirstDifferentParameterId = DefSetStateFirstDifferentParameterId_;
}

inline void SetFactorySettingsStatusGet::set_has_DefSetStateGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFactorySettingsStatusGet::clear_has_DefSetStateGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetFactorySettingsStatusGet::set_has_DefSetStateMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetFactorySettingsStatusGet::clear_has_DefSetStateMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetFactorySettingsStatusGet::set_has_DefSetStateSuccessful () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetFactorySettingsStatusGet::clear_has_DefSetStateSuccessful () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SetFactorySettingsStatusGet::set_has_DefSetStateFirstDifferentParameterId () {
    _has_bits_[0] |= 1u << 3;
}

inline void SetFactorySettingsStatusGet::clear_has_DefSetStateFirstDifferentParameterId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  RemoteControlStatus::RemoteControlStatus ()  :
    _src (::midw_diagnostics_fi_types::T_e8_RCtrlSource__RCTRL_SRC_UNKNOWN),
    _cmd (::midw_diagnostics_fi_types::T_e8_RCtrlCommand__RCTRL_CMD_DEACTIVATE),
    _signal (::midw_diagnostics_fi_types::T_e8_RCtrlSignal__RCTRL_SIG_ALL),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteControlStatus::RemoteControlStatus (const RemoteControlStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _src (::midw_diagnostics_fi_types::T_e8_RCtrlSource__RCTRL_SRC_UNKNOWN),
    _cmd (::midw_diagnostics_fi_types::T_e8_RCtrlCommand__RCTRL_CMD_DEACTIVATE),
    _signal (::midw_diagnostics_fi_types::T_e8_RCtrlSignal__RCTRL_SIG_ALL),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteControlStatus::RemoteControlStatus (::midw_diagnostics_fi_types::T_e8_RCtrlSource src_, ::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd_, ::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal_, bool status_)  :
    _src (src_),
    _cmd (cmd_),
    _signal (signal_),
    _status (status_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlSource_IsValid(src_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", src_, "T_e8_RCtrlSource", "src", "RemoteControlStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlCommand_IsValid(cmd_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", cmd_, "T_e8_RCtrlCommand", "cmd", "RemoteControlStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlSignal_IsValid(signal_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", signal_, "T_e8_RCtrlSignal", "signal", "RemoteControlStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteControlStatus::~RemoteControlStatus() {
}

inline RemoteControlStatus& RemoteControlStatus::operator = (const RemoteControlStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSrc()) {
            setSrc(rhs.getSrc());
        } else {
            clearSrc();
        }
        if (rhs.hasCmd()) {
            setCmd(rhs.getCmd());
        } else {
            clearCmd();
        }
        if (rhs.hasSignal()) {
            setSignal(rhs.getSignal());
        } else {
            clearSignal();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool RemoteControlStatus::operator == (const RemoteControlStatus& rhs) const {
    return (((!hasSrc() && !rhs.hasSrc()) || getSrc() == rhs.getSrc()) &&
        ((!hasCmd() && !rhs.hasCmd()) || getCmd() == rhs.getCmd()) &&
        ((!hasSignal() && !rhs.hasSignal()) || getSignal() == rhs.getSignal()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool RemoteControlStatus::operator != (const RemoteControlStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteControlStatus::operator < (const RemoteControlStatus& rhs) const {
    if (hasSrc() || rhs.hasSrc()) {
        if ((uint32)getSrc() < (uint32)rhs.getSrc()) return true;
        if ((uint32)getSrc() > (uint32)rhs.getSrc()) return false;
    }
    if (hasCmd() || rhs.hasCmd()) {
        if ((uint32)getCmd() < (uint32)rhs.getCmd()) return true;
        if ((uint32)getCmd() > (uint32)rhs.getCmd()) return false;
    }
    if (hasSignal() || rhs.hasSignal()) {
        if ((uint32)getSignal() < (uint32)rhs.getSignal()) return true;
        if ((uint32)getSignal() > (uint32)rhs.getSignal()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoteControlStatus::clone() {
    return new RemoteControlStatus(*this);
}

inline bool RemoteControlStatus::operator > (const RemoteControlStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteControlStatus::clear() {
    clearSrc();
    clearCmd();
    clearSignal();
    clearStatus();
}

inline void RemoteControlStatus::clearSrc() {
    if (hasSrc()) {
         clear_has_src();
        _src = ::midw_diagnostics_fi_types::T_e8_RCtrlSource__RCTRL_SRC_UNKNOWN;
     }
}

inline bool RemoteControlStatus::hasSrc () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_RCtrlSource RemoteControlStatus::getSrc () const {
    return _src;
}

inline void RemoteControlStatus::setSrc (::midw_diagnostics_fi_types::T_e8_RCtrlSource src_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlSource_IsValid(src_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", src_, "T_e8_RCtrlSource", "src", "RemoteControlStatus");
    }
    #endif
    set_has_src();
    this->_src = src_;
}

inline void RemoteControlStatus::clearCmd() {
    if (hasCmd()) {
         clear_has_cmd();
        _cmd = ::midw_diagnostics_fi_types::T_e8_RCtrlCommand__RCTRL_CMD_DEACTIVATE;
     }
}

inline bool RemoteControlStatus::hasCmd () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_RCtrlCommand RemoteControlStatus::getCmd () const {
    return _cmd;
}

inline void RemoteControlStatus::setCmd (::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlCommand_IsValid(cmd_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", cmd_, "T_e8_RCtrlCommand", "cmd", "RemoteControlStatus");
    }
    #endif
    set_has_cmd();
    this->_cmd = cmd_;
}

inline void RemoteControlStatus::clearSignal() {
    if (hasSignal()) {
         clear_has_signal();
        _signal = ::midw_diagnostics_fi_types::T_e8_RCtrlSignal__RCTRL_SIG_ALL;
     }
}

inline bool RemoteControlStatus::hasSignal () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_RCtrlSignal RemoteControlStatus::getSignal () const {
    return _signal;
}

inline void RemoteControlStatus::setSignal (::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlSignal_IsValid(signal_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", signal_, "T_e8_RCtrlSignal", "signal", "RemoteControlStatus");
    }
    #endif
    set_has_signal();
    this->_signal = signal_;
}

inline void RemoteControlStatus::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool RemoteControlStatus::hasStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool RemoteControlStatus::getStatus () const {
    return _status;
}

inline void RemoteControlStatus::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void RemoteControlStatus::set_has_src () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteControlStatus::clear_has_src () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteControlStatus::set_has_cmd () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteControlStatus::clear_has_cmd () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RemoteControlStatus::set_has_signal () {
    _has_bits_[0] |= 1u << 2;
}

inline void RemoteControlStatus::clear_has_signal () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RemoteControlStatus::set_has_status () {
    _has_bits_[0] |= 1u << 3;
}

inline void RemoteControlStatus::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  RemoteControlSet::RemoteControlSet ()  :
    _src (::midw_diagnostics_fi_types::T_e8_RCtrlSource__RCTRL_SRC_UNKNOWN),
    _cmd (::midw_diagnostics_fi_types::T_e8_RCtrlCommand__RCTRL_CMD_DEACTIVATE),
    _signal (::midw_diagnostics_fi_types::T_e8_RCtrlSignal__RCTRL_SIG_ALL),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteControlSet::RemoteControlSet (const RemoteControlSet &rhs)  :
    ::asf::core::Payload(rhs),
    _src (::midw_diagnostics_fi_types::T_e8_RCtrlSource__RCTRL_SRC_UNKNOWN),
    _cmd (::midw_diagnostics_fi_types::T_e8_RCtrlCommand__RCTRL_CMD_DEACTIVATE),
    _signal (::midw_diagnostics_fi_types::T_e8_RCtrlSignal__RCTRL_SIG_ALL),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteControlSet::RemoteControlSet (::midw_diagnostics_fi_types::T_e8_RCtrlSource src_, ::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd_, ::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal_, bool status_)  :
    _src (src_),
    _cmd (cmd_),
    _signal (signal_),
    _status (status_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlSource_IsValid(src_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", src_, "T_e8_RCtrlSource", "src", "RemoteControlSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlCommand_IsValid(cmd_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", cmd_, "T_e8_RCtrlCommand", "cmd", "RemoteControlSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlSignal_IsValid(signal_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", signal_, "T_e8_RCtrlSignal", "signal", "RemoteControlSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteControlSet::~RemoteControlSet() {
}

inline RemoteControlSet& RemoteControlSet::operator = (const RemoteControlSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSrc()) {
            setSrc(rhs.getSrc());
        } else {
            clearSrc();
        }
        if (rhs.hasCmd()) {
            setCmd(rhs.getCmd());
        } else {
            clearCmd();
        }
        if (rhs.hasSignal()) {
            setSignal(rhs.getSignal());
        } else {
            clearSignal();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool RemoteControlSet::operator == (const RemoteControlSet& rhs) const {
    return (((!hasSrc() && !rhs.hasSrc()) || getSrc() == rhs.getSrc()) &&
        ((!hasCmd() && !rhs.hasCmd()) || getCmd() == rhs.getCmd()) &&
        ((!hasSignal() && !rhs.hasSignal()) || getSignal() == rhs.getSignal()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool RemoteControlSet::operator != (const RemoteControlSet& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteControlSet::operator < (const RemoteControlSet& rhs) const {
    if (hasSrc() || rhs.hasSrc()) {
        if ((uint32)getSrc() < (uint32)rhs.getSrc()) return true;
        if ((uint32)getSrc() > (uint32)rhs.getSrc()) return false;
    }
    if (hasCmd() || rhs.hasCmd()) {
        if ((uint32)getCmd() < (uint32)rhs.getCmd()) return true;
        if ((uint32)getCmd() > (uint32)rhs.getCmd()) return false;
    }
    if (hasSignal() || rhs.hasSignal()) {
        if ((uint32)getSignal() < (uint32)rhs.getSignal()) return true;
        if ((uint32)getSignal() > (uint32)rhs.getSignal()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoteControlSet::clone() {
    return new RemoteControlSet(*this);
}

inline bool RemoteControlSet::operator > (const RemoteControlSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteControlSet::clear() {
    clearSrc();
    clearCmd();
    clearSignal();
    clearStatus();
}

inline void RemoteControlSet::clearSrc() {
    if (hasSrc()) {
         clear_has_src();
        _src = ::midw_diagnostics_fi_types::T_e8_RCtrlSource__RCTRL_SRC_UNKNOWN;
     }
}

inline bool RemoteControlSet::hasSrc () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_RCtrlSource RemoteControlSet::getSrc () const {
    return _src;
}

inline void RemoteControlSet::setSrc (::midw_diagnostics_fi_types::T_e8_RCtrlSource src_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlSource_IsValid(src_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", src_, "T_e8_RCtrlSource", "src", "RemoteControlSet");
    }
    #endif
    set_has_src();
    this->_src = src_;
}

inline void RemoteControlSet::clearCmd() {
    if (hasCmd()) {
         clear_has_cmd();
        _cmd = ::midw_diagnostics_fi_types::T_e8_RCtrlCommand__RCTRL_CMD_DEACTIVATE;
     }
}

inline bool RemoteControlSet::hasCmd () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_RCtrlCommand RemoteControlSet::getCmd () const {
    return _cmd;
}

inline void RemoteControlSet::setCmd (::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlCommand_IsValid(cmd_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", cmd_, "T_e8_RCtrlCommand", "cmd", "RemoteControlSet");
    }
    #endif
    set_has_cmd();
    this->_cmd = cmd_;
}

inline void RemoteControlSet::clearSignal() {
    if (hasSignal()) {
         clear_has_signal();
        _signal = ::midw_diagnostics_fi_types::T_e8_RCtrlSignal__RCTRL_SIG_ALL;
     }
}

inline bool RemoteControlSet::hasSignal () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_RCtrlSignal RemoteControlSet::getSignal () const {
    return _signal;
}

inline void RemoteControlSet::setSignal (::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlSignal_IsValid(signal_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", signal_, "T_e8_RCtrlSignal", "signal", "RemoteControlSet");
    }
    #endif
    set_has_signal();
    this->_signal = signal_;
}

inline void RemoteControlSet::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool RemoteControlSet::hasStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool RemoteControlSet::getStatus () const {
    return _status;
}

inline void RemoteControlSet::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void RemoteControlSet::set_has_src () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteControlSet::clear_has_src () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteControlSet::set_has_cmd () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteControlSet::clear_has_cmd () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RemoteControlSet::set_has_signal () {
    _has_bits_[0] |= 1u << 2;
}

inline void RemoteControlSet::clear_has_signal () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RemoteControlSet::set_has_status () {
    _has_bits_[0] |= 1u << 3;
}

inline void RemoteControlSet::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  RemoteControlGet::RemoteControlGet ()  :
    _src (::midw_diagnostics_fi_types::T_e8_RCtrlSource__RCTRL_SRC_UNKNOWN),
    _cmd (::midw_diagnostics_fi_types::T_e8_RCtrlCommand__RCTRL_CMD_DEACTIVATE),
    _signal (::midw_diagnostics_fi_types::T_e8_RCtrlSignal__RCTRL_SIG_ALL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteControlGet::RemoteControlGet (const RemoteControlGet &rhs)  :
    ::asf::core::Payload(rhs),
    _src (::midw_diagnostics_fi_types::T_e8_RCtrlSource__RCTRL_SRC_UNKNOWN),
    _cmd (::midw_diagnostics_fi_types::T_e8_RCtrlCommand__RCTRL_CMD_DEACTIVATE),
    _signal (::midw_diagnostics_fi_types::T_e8_RCtrlSignal__RCTRL_SIG_ALL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteControlGet::RemoteControlGet (::midw_diagnostics_fi_types::T_e8_RCtrlSource src_, ::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd_, ::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal_)  :
    _src (src_),
    _cmd (cmd_),
    _signal (signal_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlSource_IsValid(src_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", src_, "T_e8_RCtrlSource", "src", "RemoteControlGet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlCommand_IsValid(cmd_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", cmd_, "T_e8_RCtrlCommand", "cmd", "RemoteControlGet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlSignal_IsValid(signal_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", signal_, "T_e8_RCtrlSignal", "signal", "RemoteControlGet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteControlGet::~RemoteControlGet() {
}

inline RemoteControlGet& RemoteControlGet::operator = (const RemoteControlGet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSrc()) {
            setSrc(rhs.getSrc());
        } else {
            clearSrc();
        }
        if (rhs.hasCmd()) {
            setCmd(rhs.getCmd());
        } else {
            clearCmd();
        }
        if (rhs.hasSignal()) {
            setSignal(rhs.getSignal());
        } else {
            clearSignal();
        }
    }
    return *this;
}

inline bool RemoteControlGet::operator == (const RemoteControlGet& rhs) const {
    return (((!hasSrc() && !rhs.hasSrc()) || getSrc() == rhs.getSrc()) &&
        ((!hasCmd() && !rhs.hasCmd()) || getCmd() == rhs.getCmd()) &&
        ((!hasSignal() && !rhs.hasSignal()) || getSignal() == rhs.getSignal()));
}

inline bool RemoteControlGet::operator != (const RemoteControlGet& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteControlGet::operator < (const RemoteControlGet& rhs) const {
    if (hasSrc() || rhs.hasSrc()) {
        if ((uint32)getSrc() < (uint32)rhs.getSrc()) return true;
        if ((uint32)getSrc() > (uint32)rhs.getSrc()) return false;
    }
    if (hasCmd() || rhs.hasCmd()) {
        if ((uint32)getCmd() < (uint32)rhs.getCmd()) return true;
        if ((uint32)getCmd() > (uint32)rhs.getCmd()) return false;
    }
    if (hasSignal() || rhs.hasSignal()) {
        if ((uint32)getSignal() < (uint32)rhs.getSignal()) return true;
        if ((uint32)getSignal() > (uint32)rhs.getSignal()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoteControlGet::clone() {
    return new RemoteControlGet(*this);
}

inline bool RemoteControlGet::operator > (const RemoteControlGet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteControlGet::clear() {
    clearSrc();
    clearCmd();
    clearSignal();
}

inline void RemoteControlGet::clearSrc() {
    if (hasSrc()) {
         clear_has_src();
        _src = ::midw_diagnostics_fi_types::T_e8_RCtrlSource__RCTRL_SRC_UNKNOWN;
     }
}

inline bool RemoteControlGet::hasSrc () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_RCtrlSource RemoteControlGet::getSrc () const {
    return _src;
}

inline void RemoteControlGet::setSrc (::midw_diagnostics_fi_types::T_e8_RCtrlSource src_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlSource_IsValid(src_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", src_, "T_e8_RCtrlSource", "src", "RemoteControlGet");
    }
    #endif
    set_has_src();
    this->_src = src_;
}

inline void RemoteControlGet::clearCmd() {
    if (hasCmd()) {
         clear_has_cmd();
        _cmd = ::midw_diagnostics_fi_types::T_e8_RCtrlCommand__RCTRL_CMD_DEACTIVATE;
     }
}

inline bool RemoteControlGet::hasCmd () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_RCtrlCommand RemoteControlGet::getCmd () const {
    return _cmd;
}

inline void RemoteControlGet::setCmd (::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlCommand_IsValid(cmd_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", cmd_, "T_e8_RCtrlCommand", "cmd", "RemoteControlGet");
    }
    #endif
    set_has_cmd();
    this->_cmd = cmd_;
}

inline void RemoteControlGet::clearSignal() {
    if (hasSignal()) {
         clear_has_signal();
        _signal = ::midw_diagnostics_fi_types::T_e8_RCtrlSignal__RCTRL_SIG_ALL;
     }
}

inline bool RemoteControlGet::hasSignal () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_RCtrlSignal RemoteControlGet::getSignal () const {
    return _signal;
}

inline void RemoteControlGet::setSignal (::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_RCtrlSignal_IsValid(signal_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", signal_, "T_e8_RCtrlSignal", "signal", "RemoteControlGet");
    }
    #endif
    set_has_signal();
    this->_signal = signal_;
}

inline void RemoteControlGet::set_has_src () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteControlGet::clear_has_src () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteControlGet::set_has_cmd () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteControlGet::clear_has_cmd () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RemoteControlGet::set_has_signal () {
    _has_bits_[0] |= 1u << 2;
}

inline void RemoteControlGet::clear_has_signal () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  CISswUpdateProcessStatus::CISswUpdateProcessStatus ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CISswUpdateProcessStatus::CISswUpdateProcessStatus (const CISswUpdateProcessStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CISswUpdateProcessStatus::CISswUpdateProcessStatus (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CISswUpdateProcessStatus::~CISswUpdateProcessStatus() {
}

inline CISswUpdateProcessStatus& CISswUpdateProcessStatus::operator = (const CISswUpdateProcessStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool CISswUpdateProcessStatus::operator == (const CISswUpdateProcessStatus& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool CISswUpdateProcessStatus::operator != (const CISswUpdateProcessStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool CISswUpdateProcessStatus::operator < (const CISswUpdateProcessStatus& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CISswUpdateProcessStatus::clone() {
    return new CISswUpdateProcessStatus(*this);
}

inline bool CISswUpdateProcessStatus::operator > (const CISswUpdateProcessStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CISswUpdateProcessStatus::clear() {
    clearStatus();
}

inline void CISswUpdateProcessStatus::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool CISswUpdateProcessStatus::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool CISswUpdateProcessStatus::getStatus () const {
    return _status;
}

inline void CISswUpdateProcessStatus::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void CISswUpdateProcessStatus::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void CISswUpdateProcessStatus::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CISswUpdateProcessSet::CISswUpdateProcessSet ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CISswUpdateProcessSet::CISswUpdateProcessSet (const CISswUpdateProcessSet &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CISswUpdateProcessSet::CISswUpdateProcessSet (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CISswUpdateProcessSet::~CISswUpdateProcessSet() {
}

inline CISswUpdateProcessSet& CISswUpdateProcessSet::operator = (const CISswUpdateProcessSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool CISswUpdateProcessSet::operator == (const CISswUpdateProcessSet& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool CISswUpdateProcessSet::operator != (const CISswUpdateProcessSet& rhs) const {
    return ! (*this == rhs);
}

inline bool CISswUpdateProcessSet::operator < (const CISswUpdateProcessSet& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CISswUpdateProcessSet::clone() {
    return new CISswUpdateProcessSet(*this);
}

inline bool CISswUpdateProcessSet::operator > (const CISswUpdateProcessSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CISswUpdateProcessSet::clear() {
    clearStatus();
}

inline void CISswUpdateProcessSet::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool CISswUpdateProcessSet::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool CISswUpdateProcessSet::getStatus () const {
    return _status;
}

inline void CISswUpdateProcessSet::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void CISswUpdateProcessSet::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void CISswUpdateProcessSet::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CISswUpdateStage2ProcessStatus::CISswUpdateStage2ProcessStatus ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CISswUpdateStage2ProcessStatus::CISswUpdateStage2ProcessStatus (const CISswUpdateStage2ProcessStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CISswUpdateStage2ProcessStatus::CISswUpdateStage2ProcessStatus (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CISswUpdateStage2ProcessStatus::~CISswUpdateStage2ProcessStatus() {
}

inline CISswUpdateStage2ProcessStatus& CISswUpdateStage2ProcessStatus::operator = (const CISswUpdateStage2ProcessStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool CISswUpdateStage2ProcessStatus::operator == (const CISswUpdateStage2ProcessStatus& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool CISswUpdateStage2ProcessStatus::operator != (const CISswUpdateStage2ProcessStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool CISswUpdateStage2ProcessStatus::operator < (const CISswUpdateStage2ProcessStatus& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CISswUpdateStage2ProcessStatus::clone() {
    return new CISswUpdateStage2ProcessStatus(*this);
}

inline bool CISswUpdateStage2ProcessStatus::operator > (const CISswUpdateStage2ProcessStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CISswUpdateStage2ProcessStatus::clear() {
    clearStatus();
}

inline void CISswUpdateStage2ProcessStatus::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool CISswUpdateStage2ProcessStatus::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool CISswUpdateStage2ProcessStatus::getStatus () const {
    return _status;
}

inline void CISswUpdateStage2ProcessStatus::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void CISswUpdateStage2ProcessStatus::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void CISswUpdateStage2ProcessStatus::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CISswUpdateStage2ProcessSet::CISswUpdateStage2ProcessSet ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CISswUpdateStage2ProcessSet::CISswUpdateStage2ProcessSet (const CISswUpdateStage2ProcessSet &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CISswUpdateStage2ProcessSet::CISswUpdateStage2ProcessSet (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CISswUpdateStage2ProcessSet::~CISswUpdateStage2ProcessSet() {
}

inline CISswUpdateStage2ProcessSet& CISswUpdateStage2ProcessSet::operator = (const CISswUpdateStage2ProcessSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool CISswUpdateStage2ProcessSet::operator == (const CISswUpdateStage2ProcessSet& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool CISswUpdateStage2ProcessSet::operator != (const CISswUpdateStage2ProcessSet& rhs) const {
    return ! (*this == rhs);
}

inline bool CISswUpdateStage2ProcessSet::operator < (const CISswUpdateStage2ProcessSet& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CISswUpdateStage2ProcessSet::clone() {
    return new CISswUpdateStage2ProcessSet(*this);
}

inline bool CISswUpdateStage2ProcessSet::operator > (const CISswUpdateStage2ProcessSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CISswUpdateStage2ProcessSet::clear() {
    clearStatus();
}

inline void CISswUpdateStage2ProcessSet::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool CISswUpdateStage2ProcessSet::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool CISswUpdateStage2ProcessSet::getStatus () const {
    return _status;
}

inline void CISswUpdateStage2ProcessSet::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void CISswUpdateStage2ProcessSet::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void CISswUpdateStage2ProcessSet::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetFactorySettingsStart::SetFactorySettingsStart ()  :
    _DefSetStateGroup (0u),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFactorySettingsStart::SetFactorySettingsStart (const SetFactorySettingsStart &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetStateGroup (0u),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFactorySettingsStart::SetFactorySettingsStart (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_)  :
    _DefSetStateGroup (DefSetStateGroup_),
    _DefSetStateMode (DefSetStateMode_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFactorySettingsStart::~SetFactorySettingsStart() {
}

inline SetFactorySettingsStart& SetFactorySettingsStart::operator = (const SetFactorySettingsStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetStateGroup()) {
            setDefSetStateGroup(rhs.getDefSetStateGroup());
        } else {
            clearDefSetStateGroup();
        }
        if (rhs.hasDefSetStateMode()) {
            setDefSetStateMode(rhs.getDefSetStateMode());
        } else {
            clearDefSetStateMode();
        }
    }
    return *this;
}

inline bool SetFactorySettingsStart::operator == (const SetFactorySettingsStart& rhs) const {
    return (((!hasDefSetStateGroup() && !rhs.hasDefSetStateGroup()) || getDefSetStateGroup() == rhs.getDefSetStateGroup()) &&
        ((!hasDefSetStateMode() && !rhs.hasDefSetStateMode()) || getDefSetStateMode() == rhs.getDefSetStateMode()));
}

inline bool SetFactorySettingsStart::operator != (const SetFactorySettingsStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFactorySettingsStart::operator < (const SetFactorySettingsStart& rhs) const {
    if (hasDefSetStateGroup() || rhs.hasDefSetStateGroup()) {
        if (getDefSetStateGroup() < rhs.getDefSetStateGroup()) return true;
        if (getDefSetStateGroup() > rhs.getDefSetStateGroup()) return false;
    }
    if (hasDefSetStateMode() || rhs.hasDefSetStateMode()) {
        if ((uint32)getDefSetStateMode() < (uint32)rhs.getDefSetStateMode()) return true;
        if ((uint32)getDefSetStateMode() > (uint32)rhs.getDefSetStateMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFactorySettingsStart::clone() {
    return new SetFactorySettingsStart(*this);
}

inline bool SetFactorySettingsStart::operator > (const SetFactorySettingsStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFactorySettingsStart::clear() {
    clearDefSetStateGroup();
    clearDefSetStateMode();
}

inline void SetFactorySettingsStart::clearDefSetStateGroup() {
    if (hasDefSetStateGroup()) {
         clear_has_DefSetStateGroup();
        _DefSetStateGroup = 0u;
     }
}

inline bool SetFactorySettingsStart::hasDefSetStateGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetFactorySettingsStart::getDefSetStateGroup () const {
    return _DefSetStateGroup;
}

inline void SetFactorySettingsStart::setDefSetStateGroup (uint8 DefSetStateGroup_) {
    set_has_DefSetStateGroup();
    this->_DefSetStateGroup = DefSetStateGroup_;
}

inline void SetFactorySettingsStart::clearDefSetStateMode() {
    if (hasDefSetStateMode()) {
         clear_has_DefSetStateMode();
        _DefSetStateMode = ::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF;
     }
}

inline bool SetFactorySettingsStart::hasDefSetStateMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DefSetMode SetFactorySettingsStart::getDefSetStateMode () const {
    return _DefSetStateMode;
}

inline void SetFactorySettingsStart::setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsStart");
    }
    #endif
    set_has_DefSetStateMode();
    this->_DefSetStateMode = DefSetStateMode_;
}

inline void SetFactorySettingsStart::set_has_DefSetStateGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFactorySettingsStart::clear_has_DefSetStateGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetFactorySettingsStart::set_has_DefSetStateMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetFactorySettingsStart::clear_has_DefSetStateMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetFactorySettingsResult::SetFactorySettingsResult ()  :
    _DefSetStateGroup (0u),
    _DefSetServiceStatus (::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus__DEFSET_STATE_UNDEFINED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFactorySettingsResult::SetFactorySettingsResult (const SetFactorySettingsResult &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetStateGroup (0u),
    _DefSetServiceStatus (::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus__DEFSET_STATE_UNDEFINED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFactorySettingsResult::SetFactorySettingsResult (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus DefSetServiceStatus_)  :
    _DefSetStateGroup (DefSetStateGroup_),
    _DefSetServiceStatus (DefSetServiceStatus_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus_IsValid(DefSetServiceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetServiceStatus_, "T_e8_DefSetServiceStatus", "DefSetServiceStatus", "SetFactorySettingsResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFactorySettingsResult::~SetFactorySettingsResult() {
}

inline SetFactorySettingsResult& SetFactorySettingsResult::operator = (const SetFactorySettingsResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetStateGroup()) {
            setDefSetStateGroup(rhs.getDefSetStateGroup());
        } else {
            clearDefSetStateGroup();
        }
        if (rhs.hasDefSetServiceStatus()) {
            setDefSetServiceStatus(rhs.getDefSetServiceStatus());
        } else {
            clearDefSetServiceStatus();
        }
    }
    return *this;
}

inline bool SetFactorySettingsResult::operator == (const SetFactorySettingsResult& rhs) const {
    return (((!hasDefSetStateGroup() && !rhs.hasDefSetStateGroup()) || getDefSetStateGroup() == rhs.getDefSetStateGroup()) &&
        ((!hasDefSetServiceStatus() && !rhs.hasDefSetServiceStatus()) || getDefSetServiceStatus() == rhs.getDefSetServiceStatus()));
}

inline bool SetFactorySettingsResult::operator != (const SetFactorySettingsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFactorySettingsResult::operator < (const SetFactorySettingsResult& rhs) const {
    if (hasDefSetStateGroup() || rhs.hasDefSetStateGroup()) {
        if (getDefSetStateGroup() < rhs.getDefSetStateGroup()) return true;
        if (getDefSetStateGroup() > rhs.getDefSetStateGroup()) return false;
    }
    if (hasDefSetServiceStatus() || rhs.hasDefSetServiceStatus()) {
        if ((uint32)getDefSetServiceStatus() < (uint32)rhs.getDefSetServiceStatus()) return true;
        if ((uint32)getDefSetServiceStatus() > (uint32)rhs.getDefSetServiceStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFactorySettingsResult::clone() {
    return new SetFactorySettingsResult(*this);
}

inline bool SetFactorySettingsResult::operator > (const SetFactorySettingsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFactorySettingsResult::clear() {
    clearDefSetStateGroup();
    clearDefSetServiceStatus();
}

inline void SetFactorySettingsResult::clearDefSetStateGroup() {
    if (hasDefSetStateGroup()) {
         clear_has_DefSetStateGroup();
        _DefSetStateGroup = 0u;
     }
}

inline bool SetFactorySettingsResult::hasDefSetStateGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetFactorySettingsResult::getDefSetStateGroup () const {
    return _DefSetStateGroup;
}

inline void SetFactorySettingsResult::setDefSetStateGroup (uint8 DefSetStateGroup_) {
    set_has_DefSetStateGroup();
    this->_DefSetStateGroup = DefSetStateGroup_;
}

inline void SetFactorySettingsResult::clearDefSetServiceStatus() {
    if (hasDefSetServiceStatus()) {
         clear_has_DefSetServiceStatus();
        _DefSetServiceStatus = ::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus__DEFSET_STATE_UNDEFINED;
     }
}

inline bool SetFactorySettingsResult::hasDefSetServiceStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus SetFactorySettingsResult::getDefSetServiceStatus () const {
    return _DefSetServiceStatus;
}

inline void SetFactorySettingsResult::setDefSetServiceStatus (::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus DefSetServiceStatus_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetServiceStatus_IsValid(DefSetServiceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetServiceStatus_, "T_e8_DefSetServiceStatus", "DefSetServiceStatus", "SetFactorySettingsResult");
    }
    #endif
    set_has_DefSetServiceStatus();
    this->_DefSetServiceStatus = DefSetServiceStatus_;
}

inline void SetFactorySettingsResult::set_has_DefSetStateGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFactorySettingsResult::clear_has_DefSetStateGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetFactorySettingsResult::set_has_DefSetServiceStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetFactorySettingsResult::clear_has_DefSetServiceStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetResetToSupplierDefaultConfigStart::SetResetToSupplierDefaultConfigStart ()  :
    _ResetSupplierConfig (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetResetToSupplierDefaultConfigStart::SetResetToSupplierDefaultConfigStart (const SetResetToSupplierDefaultConfigStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ResetSupplierConfig (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetResetToSupplierDefaultConfigStart::SetResetToSupplierDefaultConfigStart (uint8 ResetSupplierConfig_)  :
    _ResetSupplierConfig (ResetSupplierConfig_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetResetToSupplierDefaultConfigStart::~SetResetToSupplierDefaultConfigStart() {
}

inline SetResetToSupplierDefaultConfigStart& SetResetToSupplierDefaultConfigStart::operator = (const SetResetToSupplierDefaultConfigStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResetSupplierConfig()) {
            setResetSupplierConfig(rhs.getResetSupplierConfig());
        } else {
            clearResetSupplierConfig();
        }
    }
    return *this;
}

inline bool SetResetToSupplierDefaultConfigStart::operator == (const SetResetToSupplierDefaultConfigStart& rhs) const {
    return (((!hasResetSupplierConfig() && !rhs.hasResetSupplierConfig()) || getResetSupplierConfig() == rhs.getResetSupplierConfig()));
}

inline bool SetResetToSupplierDefaultConfigStart::operator != (const SetResetToSupplierDefaultConfigStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetResetToSupplierDefaultConfigStart::operator < (const SetResetToSupplierDefaultConfigStart& rhs) const {
    if (hasResetSupplierConfig() || rhs.hasResetSupplierConfig()) {
        if (getResetSupplierConfig() < rhs.getResetSupplierConfig()) return true;
        if (getResetSupplierConfig() > rhs.getResetSupplierConfig()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetResetToSupplierDefaultConfigStart::clone() {
    return new SetResetToSupplierDefaultConfigStart(*this);
}

inline bool SetResetToSupplierDefaultConfigStart::operator > (const SetResetToSupplierDefaultConfigStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetResetToSupplierDefaultConfigStart::clear() {
    clearResetSupplierConfig();
}

inline void SetResetToSupplierDefaultConfigStart::clearResetSupplierConfig() {
    if (hasResetSupplierConfig()) {
         clear_has_ResetSupplierConfig();
        _ResetSupplierConfig = 0u;
     }
}

inline bool SetResetToSupplierDefaultConfigStart::hasResetSupplierConfig () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetResetToSupplierDefaultConfigStart::getResetSupplierConfig () const {
    return _ResetSupplierConfig;
}

inline void SetResetToSupplierDefaultConfigStart::setResetSupplierConfig (uint8 ResetSupplierConfig_) {
    set_has_ResetSupplierConfig();
    this->_ResetSupplierConfig = ResetSupplierConfig_;
}

inline void SetResetToSupplierDefaultConfigStart::set_has_ResetSupplierConfig () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetResetToSupplierDefaultConfigStart::clear_has_ResetSupplierConfig () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetResetToSupplierDefaultConfigResult::SetResetToSupplierDefaultConfigResult ()  :
    _DefResetServiceStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetResetToSupplierDefaultConfigResult::SetResetToSupplierDefaultConfigResult (const SetResetToSupplierDefaultConfigResult &rhs)  :
    ::asf::core::Payload(rhs),
    _DefResetServiceStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetResetToSupplierDefaultConfigResult::SetResetToSupplierDefaultConfigResult (bool DefResetServiceStatus_)  :
    _DefResetServiceStatus (DefResetServiceStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetResetToSupplierDefaultConfigResult::~SetResetToSupplierDefaultConfigResult() {
}

inline SetResetToSupplierDefaultConfigResult& SetResetToSupplierDefaultConfigResult::operator = (const SetResetToSupplierDefaultConfigResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefResetServiceStatus()) {
            setDefResetServiceStatus(rhs.getDefResetServiceStatus());
        } else {
            clearDefResetServiceStatus();
        }
    }
    return *this;
}

inline bool SetResetToSupplierDefaultConfigResult::operator == (const SetResetToSupplierDefaultConfigResult& rhs) const {
    return (((!hasDefResetServiceStatus() && !rhs.hasDefResetServiceStatus()) || getDefResetServiceStatus() == rhs.getDefResetServiceStatus()));
}

inline bool SetResetToSupplierDefaultConfigResult::operator != (const SetResetToSupplierDefaultConfigResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetResetToSupplierDefaultConfigResult::operator < (const SetResetToSupplierDefaultConfigResult& rhs) const {
    if (hasDefResetServiceStatus() || rhs.hasDefResetServiceStatus()) {
        if (getDefResetServiceStatus() < rhs.getDefResetServiceStatus()) return true;
        if (getDefResetServiceStatus() > rhs.getDefResetServiceStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetResetToSupplierDefaultConfigResult::clone() {
    return new SetResetToSupplierDefaultConfigResult(*this);
}

inline bool SetResetToSupplierDefaultConfigResult::operator > (const SetResetToSupplierDefaultConfigResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetResetToSupplierDefaultConfigResult::clear() {
    clearDefResetServiceStatus();
}

inline void SetResetToSupplierDefaultConfigResult::clearDefResetServiceStatus() {
    if (hasDefResetServiceStatus()) {
         clear_has_DefResetServiceStatus();
        _DefResetServiceStatus = false;
     }
}

inline bool SetResetToSupplierDefaultConfigResult::hasDefResetServiceStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetResetToSupplierDefaultConfigResult::getDefResetServiceStatus () const {
    return _DefResetServiceStatus;
}

inline void SetResetToSupplierDefaultConfigResult::setDefResetServiceStatus (bool DefResetServiceStatus_) {
    set_has_DefResetServiceStatus();
    this->_DefResetServiceStatus = DefResetServiceStatus_;
}

inline void SetResetToSupplierDefaultConfigResult::set_has_DefResetServiceStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetResetToSupplierDefaultConfigResult::clear_has_DefResetServiceStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetRunTimeSourceDataStart::SetRunTimeSourceDataStart ()  :
    _RunTimeSourceAppID (0u),
    _RunTimeSourceAppData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetRunTimeSourceDataStart::SetRunTimeSourceDataStart (const SetRunTimeSourceDataStart &rhs)  :
    ::asf::core::Payload(rhs),
    _RunTimeSourceAppID (0u),
    _RunTimeSourceAppData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetRunTimeSourceDataStart::SetRunTimeSourceDataStart (uint16 RunTimeSourceAppID_, uint32 RunTimeSourceAppData_)  :
    _RunTimeSourceAppID (RunTimeSourceAppID_),
    _RunTimeSourceAppData (RunTimeSourceAppData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetRunTimeSourceDataStart::~SetRunTimeSourceDataStart() {
}

inline SetRunTimeSourceDataStart& SetRunTimeSourceDataStart::operator = (const SetRunTimeSourceDataStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRunTimeSourceAppID()) {
            setRunTimeSourceAppID(rhs.getRunTimeSourceAppID());
        } else {
            clearRunTimeSourceAppID();
        }
        if (rhs.hasRunTimeSourceAppData()) {
            setRunTimeSourceAppData(rhs.getRunTimeSourceAppData());
        } else {
            clearRunTimeSourceAppData();
        }
    }
    return *this;
}

inline bool SetRunTimeSourceDataStart::operator == (const SetRunTimeSourceDataStart& rhs) const {
    return (((!hasRunTimeSourceAppID() && !rhs.hasRunTimeSourceAppID()) || getRunTimeSourceAppID() == rhs.getRunTimeSourceAppID()) &&
        ((!hasRunTimeSourceAppData() && !rhs.hasRunTimeSourceAppData()) || getRunTimeSourceAppData() == rhs.getRunTimeSourceAppData()));
}

inline bool SetRunTimeSourceDataStart::operator != (const SetRunTimeSourceDataStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetRunTimeSourceDataStart::operator < (const SetRunTimeSourceDataStart& rhs) const {
    if (hasRunTimeSourceAppID() || rhs.hasRunTimeSourceAppID()) {
        if (getRunTimeSourceAppID() < rhs.getRunTimeSourceAppID()) return true;
        if (getRunTimeSourceAppID() > rhs.getRunTimeSourceAppID()) return false;
    }
    if (hasRunTimeSourceAppData() || rhs.hasRunTimeSourceAppData()) {
        if (getRunTimeSourceAppData() < rhs.getRunTimeSourceAppData()) return true;
        if (getRunTimeSourceAppData() > rhs.getRunTimeSourceAppData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetRunTimeSourceDataStart::clone() {
    return new SetRunTimeSourceDataStart(*this);
}

inline bool SetRunTimeSourceDataStart::operator > (const SetRunTimeSourceDataStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetRunTimeSourceDataStart::clear() {
    clearRunTimeSourceAppID();
    clearRunTimeSourceAppData();
}

inline void SetRunTimeSourceDataStart::clearRunTimeSourceAppID() {
    if (hasRunTimeSourceAppID()) {
         clear_has_RunTimeSourceAppID();
        _RunTimeSourceAppID = 0u;
     }
}

inline bool SetRunTimeSourceDataStart::hasRunTimeSourceAppID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetRunTimeSourceDataStart::getRunTimeSourceAppID () const {
    return _RunTimeSourceAppID;
}

inline void SetRunTimeSourceDataStart::setRunTimeSourceAppID (uint16 RunTimeSourceAppID_) {
    set_has_RunTimeSourceAppID();
    this->_RunTimeSourceAppID = RunTimeSourceAppID_;
}

inline void SetRunTimeSourceDataStart::clearRunTimeSourceAppData() {
    if (hasRunTimeSourceAppData()) {
         clear_has_RunTimeSourceAppData();
        _RunTimeSourceAppData = 0u;
     }
}

inline bool SetRunTimeSourceDataStart::hasRunTimeSourceAppData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 SetRunTimeSourceDataStart::getRunTimeSourceAppData () const {
    return _RunTimeSourceAppData;
}

inline void SetRunTimeSourceDataStart::setRunTimeSourceAppData (uint32 RunTimeSourceAppData_) {
    set_has_RunTimeSourceAppData();
    this->_RunTimeSourceAppData = RunTimeSourceAppData_;
}

inline void SetRunTimeSourceDataStart::set_has_RunTimeSourceAppID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetRunTimeSourceDataStart::clear_has_RunTimeSourceAppID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetRunTimeSourceDataStart::set_has_RunTimeSourceAppData () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetRunTimeSourceDataStart::clear_has_RunTimeSourceAppData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetRunTimeSourceDataResult::SetRunTimeSourceDataResult ()  :
    _RunTimeSourceDiagResp (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetRunTimeSourceDataResult::SetRunTimeSourceDataResult (const SetRunTimeSourceDataResult &rhs)  :
    ::asf::core::Payload(rhs),
    _RunTimeSourceDiagResp (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetRunTimeSourceDataResult::SetRunTimeSourceDataResult (bool RunTimeSourceDiagResp_)  :
    _RunTimeSourceDiagResp (RunTimeSourceDiagResp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetRunTimeSourceDataResult::~SetRunTimeSourceDataResult() {
}

inline SetRunTimeSourceDataResult& SetRunTimeSourceDataResult::operator = (const SetRunTimeSourceDataResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRunTimeSourceDiagResp()) {
            setRunTimeSourceDiagResp(rhs.getRunTimeSourceDiagResp());
        } else {
            clearRunTimeSourceDiagResp();
        }
    }
    return *this;
}

inline bool SetRunTimeSourceDataResult::operator == (const SetRunTimeSourceDataResult& rhs) const {
    return (((!hasRunTimeSourceDiagResp() && !rhs.hasRunTimeSourceDiagResp()) || getRunTimeSourceDiagResp() == rhs.getRunTimeSourceDiagResp()));
}

inline bool SetRunTimeSourceDataResult::operator != (const SetRunTimeSourceDataResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetRunTimeSourceDataResult::operator < (const SetRunTimeSourceDataResult& rhs) const {
    if (hasRunTimeSourceDiagResp() || rhs.hasRunTimeSourceDiagResp()) {
        if (getRunTimeSourceDiagResp() < rhs.getRunTimeSourceDiagResp()) return true;
        if (getRunTimeSourceDiagResp() > rhs.getRunTimeSourceDiagResp()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetRunTimeSourceDataResult::clone() {
    return new SetRunTimeSourceDataResult(*this);
}

inline bool SetRunTimeSourceDataResult::operator > (const SetRunTimeSourceDataResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetRunTimeSourceDataResult::clear() {
    clearRunTimeSourceDiagResp();
}

inline void SetRunTimeSourceDataResult::clearRunTimeSourceDiagResp() {
    if (hasRunTimeSourceDiagResp()) {
         clear_has_RunTimeSourceDiagResp();
        _RunTimeSourceDiagResp = false;
     }
}

inline bool SetRunTimeSourceDataResult::hasRunTimeSourceDiagResp () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetRunTimeSourceDataResult::getRunTimeSourceDiagResp () const {
    return _RunTimeSourceDiagResp;
}

inline void SetRunTimeSourceDataResult::setRunTimeSourceDiagResp (bool RunTimeSourceDiagResp_) {
    set_has_RunTimeSourceDiagResp();
    this->_RunTimeSourceDiagResp = RunTimeSourceDiagResp_;
}

inline void SetRunTimeSourceDataResult::set_has_RunTimeSourceDiagResp () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetRunTimeSourceDataResult::clear_has_RunTimeSourceDiagResp () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetFactorySettingsNewStart::SetFactorySettingsNewStart ()  :
    _DefSetStateGroup (0u),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFactorySettingsNewStart::SetFactorySettingsNewStart (const SetFactorySettingsNewStart &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetStateGroup (0u),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFactorySettingsNewStart::SetFactorySettingsNewStart (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_)  :
    _DefSetStateGroup (DefSetStateGroup_),
    _DefSetStateMode (DefSetStateMode_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsNewStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFactorySettingsNewStart::~SetFactorySettingsNewStart() {
}

inline SetFactorySettingsNewStart& SetFactorySettingsNewStart::operator = (const SetFactorySettingsNewStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetStateGroup()) {
            setDefSetStateGroup(rhs.getDefSetStateGroup());
        } else {
            clearDefSetStateGroup();
        }
        if (rhs.hasDefSetStateMode()) {
            setDefSetStateMode(rhs.getDefSetStateMode());
        } else {
            clearDefSetStateMode();
        }
    }
    return *this;
}

inline bool SetFactorySettingsNewStart::operator == (const SetFactorySettingsNewStart& rhs) const {
    return (((!hasDefSetStateGroup() && !rhs.hasDefSetStateGroup()) || getDefSetStateGroup() == rhs.getDefSetStateGroup()) &&
        ((!hasDefSetStateMode() && !rhs.hasDefSetStateMode()) || getDefSetStateMode() == rhs.getDefSetStateMode()));
}

inline bool SetFactorySettingsNewStart::operator != (const SetFactorySettingsNewStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFactorySettingsNewStart::operator < (const SetFactorySettingsNewStart& rhs) const {
    if (hasDefSetStateGroup() || rhs.hasDefSetStateGroup()) {
        if (getDefSetStateGroup() < rhs.getDefSetStateGroup()) return true;
        if (getDefSetStateGroup() > rhs.getDefSetStateGroup()) return false;
    }
    if (hasDefSetStateMode() || rhs.hasDefSetStateMode()) {
        if ((uint32)getDefSetStateMode() < (uint32)rhs.getDefSetStateMode()) return true;
        if ((uint32)getDefSetStateMode() > (uint32)rhs.getDefSetStateMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFactorySettingsNewStart::clone() {
    return new SetFactorySettingsNewStart(*this);
}

inline bool SetFactorySettingsNewStart::operator > (const SetFactorySettingsNewStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFactorySettingsNewStart::clear() {
    clearDefSetStateGroup();
    clearDefSetStateMode();
}

inline void SetFactorySettingsNewStart::clearDefSetStateGroup() {
    if (hasDefSetStateGroup()) {
         clear_has_DefSetStateGroup();
        _DefSetStateGroup = 0u;
     }
}

inline bool SetFactorySettingsNewStart::hasDefSetStateGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetFactorySettingsNewStart::getDefSetStateGroup () const {
    return _DefSetStateGroup;
}

inline void SetFactorySettingsNewStart::setDefSetStateGroup (uint8 DefSetStateGroup_) {
    set_has_DefSetStateGroup();
    this->_DefSetStateGroup = DefSetStateGroup_;
}

inline void SetFactorySettingsNewStart::clearDefSetStateMode() {
    if (hasDefSetStateMode()) {
         clear_has_DefSetStateMode();
        _DefSetStateMode = ::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF;
     }
}

inline bool SetFactorySettingsNewStart::hasDefSetStateMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DefSetMode SetFactorySettingsNewStart::getDefSetStateMode () const {
    return _DefSetStateMode;
}

inline void SetFactorySettingsNewStart::setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsNewStart");
    }
    #endif
    set_has_DefSetStateMode();
    this->_DefSetStateMode = DefSetStateMode_;
}

inline void SetFactorySettingsNewStart::set_has_DefSetStateGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFactorySettingsNewStart::clear_has_DefSetStateGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetFactorySettingsNewStart::set_has_DefSetStateMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetFactorySettingsNewStart::clear_has_DefSetStateMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetFactorySettingsNewResult::SetFactorySettingsNewResult ()  :
    _DefSetStateGroup (0u),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF),
    _DefSetStateSuccessful (false),
    _DefSetStateFirstDifferentParameterId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFactorySettingsNewResult::SetFactorySettingsNewResult (const SetFactorySettingsNewResult &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetStateGroup (0u),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF),
    _DefSetStateSuccessful (false),
    _DefSetStateFirstDifferentParameterId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFactorySettingsNewResult::SetFactorySettingsNewResult (uint8 DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_, bool DefSetStateSuccessful_, uint16 DefSetStateFirstDifferentParameterId_)  :
    _DefSetStateGroup (DefSetStateGroup_),
    _DefSetStateMode (DefSetStateMode_),
    _DefSetStateSuccessful (DefSetStateSuccessful_),
    _DefSetStateFirstDifferentParameterId (DefSetStateFirstDifferentParameterId_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsNewResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFactorySettingsNewResult::~SetFactorySettingsNewResult() {
}

inline SetFactorySettingsNewResult& SetFactorySettingsNewResult::operator = (const SetFactorySettingsNewResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetStateGroup()) {
            setDefSetStateGroup(rhs.getDefSetStateGroup());
        } else {
            clearDefSetStateGroup();
        }
        if (rhs.hasDefSetStateMode()) {
            setDefSetStateMode(rhs.getDefSetStateMode());
        } else {
            clearDefSetStateMode();
        }
        if (rhs.hasDefSetStateSuccessful()) {
            setDefSetStateSuccessful(rhs.getDefSetStateSuccessful());
        } else {
            clearDefSetStateSuccessful();
        }
        if (rhs.hasDefSetStateFirstDifferentParameterId()) {
            setDefSetStateFirstDifferentParameterId(rhs.getDefSetStateFirstDifferentParameterId());
        } else {
            clearDefSetStateFirstDifferentParameterId();
        }
    }
    return *this;
}

inline bool SetFactorySettingsNewResult::operator == (const SetFactorySettingsNewResult& rhs) const {
    return (((!hasDefSetStateGroup() && !rhs.hasDefSetStateGroup()) || getDefSetStateGroup() == rhs.getDefSetStateGroup()) &&
        ((!hasDefSetStateMode() && !rhs.hasDefSetStateMode()) || getDefSetStateMode() == rhs.getDefSetStateMode()) &&
        ((!hasDefSetStateSuccessful() && !rhs.hasDefSetStateSuccessful()) || getDefSetStateSuccessful() == rhs.getDefSetStateSuccessful()) &&
        ((!hasDefSetStateFirstDifferentParameterId() && !rhs.hasDefSetStateFirstDifferentParameterId()) || getDefSetStateFirstDifferentParameterId() == rhs.getDefSetStateFirstDifferentParameterId()));
}

inline bool SetFactorySettingsNewResult::operator != (const SetFactorySettingsNewResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFactorySettingsNewResult::operator < (const SetFactorySettingsNewResult& rhs) const {
    if (hasDefSetStateGroup() || rhs.hasDefSetStateGroup()) {
        if (getDefSetStateGroup() < rhs.getDefSetStateGroup()) return true;
        if (getDefSetStateGroup() > rhs.getDefSetStateGroup()) return false;
    }
    if (hasDefSetStateMode() || rhs.hasDefSetStateMode()) {
        if ((uint32)getDefSetStateMode() < (uint32)rhs.getDefSetStateMode()) return true;
        if ((uint32)getDefSetStateMode() > (uint32)rhs.getDefSetStateMode()) return false;
    }
    if (hasDefSetStateSuccessful() || rhs.hasDefSetStateSuccessful()) {
        if (getDefSetStateSuccessful() < rhs.getDefSetStateSuccessful()) return true;
        if (getDefSetStateSuccessful() > rhs.getDefSetStateSuccessful()) return false;
    }
    if (hasDefSetStateFirstDifferentParameterId() || rhs.hasDefSetStateFirstDifferentParameterId()) {
        if (getDefSetStateFirstDifferentParameterId() < rhs.getDefSetStateFirstDifferentParameterId()) return true;
        if (getDefSetStateFirstDifferentParameterId() > rhs.getDefSetStateFirstDifferentParameterId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFactorySettingsNewResult::clone() {
    return new SetFactorySettingsNewResult(*this);
}

inline bool SetFactorySettingsNewResult::operator > (const SetFactorySettingsNewResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFactorySettingsNewResult::clear() {
    clearDefSetStateGroup();
    clearDefSetStateMode();
    clearDefSetStateSuccessful();
    clearDefSetStateFirstDifferentParameterId();
}

inline void SetFactorySettingsNewResult::clearDefSetStateGroup() {
    if (hasDefSetStateGroup()) {
         clear_has_DefSetStateGroup();
        _DefSetStateGroup = 0u;
     }
}

inline bool SetFactorySettingsNewResult::hasDefSetStateGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetFactorySettingsNewResult::getDefSetStateGroup () const {
    return _DefSetStateGroup;
}

inline void SetFactorySettingsNewResult::setDefSetStateGroup (uint8 DefSetStateGroup_) {
    set_has_DefSetStateGroup();
    this->_DefSetStateGroup = DefSetStateGroup_;
}

inline void SetFactorySettingsNewResult::clearDefSetStateMode() {
    if (hasDefSetStateMode()) {
         clear_has_DefSetStateMode();
        _DefSetStateMode = ::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF;
     }
}

inline bool SetFactorySettingsNewResult::hasDefSetStateMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DefSetMode SetFactorySettingsNewResult::getDefSetStateMode () const {
    return _DefSetStateMode;
}

inline void SetFactorySettingsNewResult::setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsNewResult");
    }
    #endif
    set_has_DefSetStateMode();
    this->_DefSetStateMode = DefSetStateMode_;
}

inline void SetFactorySettingsNewResult::clearDefSetStateSuccessful() {
    if (hasDefSetStateSuccessful()) {
         clear_has_DefSetStateSuccessful();
        _DefSetStateSuccessful = false;
     }
}

inline bool SetFactorySettingsNewResult::hasDefSetStateSuccessful () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool SetFactorySettingsNewResult::getDefSetStateSuccessful () const {
    return _DefSetStateSuccessful;
}

inline void SetFactorySettingsNewResult::setDefSetStateSuccessful (bool DefSetStateSuccessful_) {
    set_has_DefSetStateSuccessful();
    this->_DefSetStateSuccessful = DefSetStateSuccessful_;
}

inline void SetFactorySettingsNewResult::clearDefSetStateFirstDifferentParameterId() {
    if (hasDefSetStateFirstDifferentParameterId()) {
         clear_has_DefSetStateFirstDifferentParameterId();
        _DefSetStateFirstDifferentParameterId = 0u;
     }
}

inline bool SetFactorySettingsNewResult::hasDefSetStateFirstDifferentParameterId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 SetFactorySettingsNewResult::getDefSetStateFirstDifferentParameterId () const {
    return _DefSetStateFirstDifferentParameterId;
}

inline void SetFactorySettingsNewResult::setDefSetStateFirstDifferentParameterId (uint16 DefSetStateFirstDifferentParameterId_) {
    set_has_DefSetStateFirstDifferentParameterId();
    this->_DefSetStateFirstDifferentParameterId = DefSetStateFirstDifferentParameterId_;
}

inline void SetFactorySettingsNewResult::set_has_DefSetStateGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFactorySettingsNewResult::clear_has_DefSetStateGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetFactorySettingsNewResult::set_has_DefSetStateMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetFactorySettingsNewResult::clear_has_DefSetStateMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetFactorySettingsNewResult::set_has_DefSetStateSuccessful () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetFactorySettingsNewResult::clear_has_DefSetStateSuccessful () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SetFactorySettingsNewResult::set_has_DefSetStateFirstDifferentParameterId () {
    _has_bits_[0] |= 1u << 3;
}

inline void SetFactorySettingsNewResult::clear_has_DefSetStateFirstDifferentParameterId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  StartCalibrationSessionStart::StartCalibrationSessionStart ()  :
    _Table (::midw_diagnostics_fi_types::T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartCalibrationSessionStart::StartCalibrationSessionStart (const StartCalibrationSessionStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Table (::midw_diagnostics_fi_types::T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartCalibrationSessionStart::StartCalibrationSessionStart (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_)  :
    _Table (Table_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_CalibrationTable_IsValid(Table_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Table_, "T_e8_CalibrationTable", "Table", "StartCalibrationSessionStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartCalibrationSessionStart::~StartCalibrationSessionStart() {
}

inline StartCalibrationSessionStart& StartCalibrationSessionStart::operator = (const StartCalibrationSessionStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTable()) {
            setTable(rhs.getTable());
        } else {
            clearTable();
        }
    }
    return *this;
}

inline bool StartCalibrationSessionStart::operator == (const StartCalibrationSessionStart& rhs) const {
    return (((!hasTable() && !rhs.hasTable()) || getTable() == rhs.getTable()));
}

inline bool StartCalibrationSessionStart::operator != (const StartCalibrationSessionStart& rhs) const {
    return ! (*this == rhs);
}

inline bool StartCalibrationSessionStart::operator < (const StartCalibrationSessionStart& rhs) const {
    if (hasTable() || rhs.hasTable()) {
        if ((uint32)getTable() < (uint32)rhs.getTable()) return true;
        if ((uint32)getTable() > (uint32)rhs.getTable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartCalibrationSessionStart::clone() {
    return new StartCalibrationSessionStart(*this);
}

inline bool StartCalibrationSessionStart::operator > (const StartCalibrationSessionStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartCalibrationSessionStart::clear() {
    clearTable();
}

inline void StartCalibrationSessionStart::clearTable() {
    if (hasTable()) {
         clear_has_Table();
        _Table = ::midw_diagnostics_fi_types::T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM;
     }
}

inline bool StartCalibrationSessionStart::hasTable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_CalibrationTable StartCalibrationSessionStart::getTable () const {
    return _Table;
}

inline void StartCalibrationSessionStart::setTable (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_CalibrationTable_IsValid(Table_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Table_, "T_e8_CalibrationTable", "Table", "StartCalibrationSessionStart");
    }
    #endif
    set_has_Table();
    this->_Table = Table_;
}

inline void StartCalibrationSessionStart::set_has_Table () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartCalibrationSessionStart::clear_has_Table () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartCalibrationSessionResult::StartCalibrationSessionResult ()  :
    _Table (::midw_diagnostics_fi_types::T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM),
    _SessionHandle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartCalibrationSessionResult::StartCalibrationSessionResult (const StartCalibrationSessionResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Table (::midw_diagnostics_fi_types::T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM),
    _SessionHandle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartCalibrationSessionResult::StartCalibrationSessionResult (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_, uint32 SessionHandle_)  :
    _Table (Table_),
    _SessionHandle (SessionHandle_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_CalibrationTable_IsValid(Table_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Table_, "T_e8_CalibrationTable", "Table", "StartCalibrationSessionResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartCalibrationSessionResult::~StartCalibrationSessionResult() {
}

inline StartCalibrationSessionResult& StartCalibrationSessionResult::operator = (const StartCalibrationSessionResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTable()) {
            setTable(rhs.getTable());
        } else {
            clearTable();
        }
        if (rhs.hasSessionHandle()) {
            setSessionHandle(rhs.getSessionHandle());
        } else {
            clearSessionHandle();
        }
    }
    return *this;
}

inline bool StartCalibrationSessionResult::operator == (const StartCalibrationSessionResult& rhs) const {
    return (((!hasTable() && !rhs.hasTable()) || getTable() == rhs.getTable()) &&
        ((!hasSessionHandle() && !rhs.hasSessionHandle()) || getSessionHandle() == rhs.getSessionHandle()));
}

inline bool StartCalibrationSessionResult::operator != (const StartCalibrationSessionResult& rhs) const {
    return ! (*this == rhs);
}

inline bool StartCalibrationSessionResult::operator < (const StartCalibrationSessionResult& rhs) const {
    if (hasTable() || rhs.hasTable()) {
        if ((uint32)getTable() < (uint32)rhs.getTable()) return true;
        if ((uint32)getTable() > (uint32)rhs.getTable()) return false;
    }
    if (hasSessionHandle() || rhs.hasSessionHandle()) {
        if (getSessionHandle() < rhs.getSessionHandle()) return true;
        if (getSessionHandle() > rhs.getSessionHandle()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartCalibrationSessionResult::clone() {
    return new StartCalibrationSessionResult(*this);
}

inline bool StartCalibrationSessionResult::operator > (const StartCalibrationSessionResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartCalibrationSessionResult::clear() {
    clearTable();
    clearSessionHandle();
}

inline void StartCalibrationSessionResult::clearTable() {
    if (hasTable()) {
         clear_has_Table();
        _Table = ::midw_diagnostics_fi_types::T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM;
     }
}

inline bool StartCalibrationSessionResult::hasTable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_CalibrationTable StartCalibrationSessionResult::getTable () const {
    return _Table;
}

inline void StartCalibrationSessionResult::setTable (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_CalibrationTable_IsValid(Table_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Table_, "T_e8_CalibrationTable", "Table", "StartCalibrationSessionResult");
    }
    #endif
    set_has_Table();
    this->_Table = Table_;
}

inline void StartCalibrationSessionResult::clearSessionHandle() {
    if (hasSessionHandle()) {
         clear_has_SessionHandle();
        _SessionHandle = 0u;
     }
}

inline bool StartCalibrationSessionResult::hasSessionHandle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 StartCalibrationSessionResult::getSessionHandle () const {
    return _SessionHandle;
}

inline void StartCalibrationSessionResult::setSessionHandle (uint32 SessionHandle_) {
    set_has_SessionHandle();
    this->_SessionHandle = SessionHandle_;
}

inline void StartCalibrationSessionResult::set_has_Table () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartCalibrationSessionResult::clear_has_Table () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartCalibrationSessionResult::set_has_SessionHandle () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartCalibrationSessionResult::clear_has_SessionHandle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StopCalibrationSessionStart::StopCalibrationSessionStart ()  :
    _SessionHandle (0u),
    _TimeStamp ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopCalibrationSessionStart::StopCalibrationSessionStart (const StopCalibrationSessionStart &rhs)  :
    ::asf::core::Payload(rhs),
    _SessionHandle (0u),
    _TimeStamp ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopCalibrationSessionStart::StopCalibrationSessionStart (uint32 SessionHandle_, const ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& TimeStamp_)  :
    _SessionHandle (SessionHandle_),
    _TimeStamp (TimeStamp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StopCalibrationSessionStart::~StopCalibrationSessionStart() {
}

inline StopCalibrationSessionStart& StopCalibrationSessionStart::operator = (const StopCalibrationSessionStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSessionHandle()) {
            setSessionHandle(rhs.getSessionHandle());
        } else {
            clearSessionHandle();
        }
        if (rhs.hasTimeStamp()) {
            setTimeStamp(rhs.getTimeStamp());
        } else {
            clearTimeStamp();
        }
    }
    return *this;
}

inline bool StopCalibrationSessionStart::operator == (const StopCalibrationSessionStart& rhs) const {
    return (((!hasSessionHandle() && !rhs.hasSessionHandle()) || getSessionHandle() == rhs.getSessionHandle()) &&
        ((!hasTimeStamp() && !rhs.hasTimeStamp()) || getTimeStamp() == rhs.getTimeStamp()));
}

inline bool StopCalibrationSessionStart::operator != (const StopCalibrationSessionStart& rhs) const {
    return ! (*this == rhs);
}

inline bool StopCalibrationSessionStart::operator < (const StopCalibrationSessionStart& rhs) const {
    if (hasSessionHandle() || rhs.hasSessionHandle()) {
        if (getSessionHandle() < rhs.getSessionHandle()) return true;
        if (getSessionHandle() > rhs.getSessionHandle()) return false;
    }
    if (hasTimeStamp() || rhs.hasTimeStamp()) {
        if (getTimeStamp() < rhs.getTimeStamp()) return true;
        if (getTimeStamp() > rhs.getTimeStamp()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StopCalibrationSessionStart::clone() {
    return new StopCalibrationSessionStart(*this);
}

inline bool StopCalibrationSessionStart::operator > (const StopCalibrationSessionStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopCalibrationSessionStart::clear() {
    clearSessionHandle();
    clearTimeStamp();
}

inline void StopCalibrationSessionStart::clearSessionHandle() {
    if (hasSessionHandle()) {
         clear_has_SessionHandle();
        _SessionHandle = 0u;
     }
}

inline bool StopCalibrationSessionStart::hasSessionHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 StopCalibrationSessionStart::getSessionHandle () const {
    return _SessionHandle;
}

inline void StopCalibrationSessionStart::setSessionHandle (uint32 SessionHandle_) {
    set_has_SessionHandle();
    this->_SessionHandle = SessionHandle_;
}

inline void StopCalibrationSessionStart::clearTimeStamp() {
    if (hasTimeStamp()) {
         clear_has_TimeStamp();
        _TimeStamp.clear();
     }
}

inline bool StopCalibrationSessionStart::hasTimeStamp () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& StopCalibrationSessionStart::getTimeStamp () const {
    return _TimeStamp;
}

inline ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& StopCalibrationSessionStart::getTimeStampMutable () {
    set_has_TimeStamp();
    return _TimeStamp;
}

inline void StopCalibrationSessionStart::setTimeStamp (const ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& TimeStamp_) {
    set_has_TimeStamp();
    this->_TimeStamp = TimeStamp_;
}

inline void StopCalibrationSessionStart::set_has_SessionHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void StopCalibrationSessionStart::clear_has_SessionHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StopCalibrationSessionStart::set_has_TimeStamp () {
    _has_bits_[0] |= 1u << 1;
}

inline void StopCalibrationSessionStart::clear_has_TimeStamp () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StopCalibrationSessionResult::StopCalibrationSessionResult ()  :
    _Table (::midw_diagnostics_fi_types::T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopCalibrationSessionResult::StopCalibrationSessionResult (const StopCalibrationSessionResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Table (::midw_diagnostics_fi_types::T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopCalibrationSessionResult::StopCalibrationSessionResult (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_)  :
    _Table (Table_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_CalibrationTable_IsValid(Table_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Table_, "T_e8_CalibrationTable", "Table", "StopCalibrationSessionResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StopCalibrationSessionResult::~StopCalibrationSessionResult() {
}

inline StopCalibrationSessionResult& StopCalibrationSessionResult::operator = (const StopCalibrationSessionResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTable()) {
            setTable(rhs.getTable());
        } else {
            clearTable();
        }
    }
    return *this;
}

inline bool StopCalibrationSessionResult::operator == (const StopCalibrationSessionResult& rhs) const {
    return (((!hasTable() && !rhs.hasTable()) || getTable() == rhs.getTable()));
}

inline bool StopCalibrationSessionResult::operator != (const StopCalibrationSessionResult& rhs) const {
    return ! (*this == rhs);
}

inline bool StopCalibrationSessionResult::operator < (const StopCalibrationSessionResult& rhs) const {
    if (hasTable() || rhs.hasTable()) {
        if ((uint32)getTable() < (uint32)rhs.getTable()) return true;
        if ((uint32)getTable() > (uint32)rhs.getTable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StopCalibrationSessionResult::clone() {
    return new StopCalibrationSessionResult(*this);
}

inline bool StopCalibrationSessionResult::operator > (const StopCalibrationSessionResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopCalibrationSessionResult::clear() {
    clearTable();
}

inline void StopCalibrationSessionResult::clearTable() {
    if (hasTable()) {
         clear_has_Table();
        _Table = ::midw_diagnostics_fi_types::T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM;
     }
}

inline bool StopCalibrationSessionResult::hasTable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_CalibrationTable StopCalibrationSessionResult::getTable () const {
    return _Table;
}

inline void StopCalibrationSessionResult::setTable (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_CalibrationTable_IsValid(Table_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Table_, "T_e8_CalibrationTable", "Table", "StopCalibrationSessionResult");
    }
    #endif
    set_has_Table();
    this->_Table = Table_;
}

inline void StopCalibrationSessionResult::set_has_Table () {
    _has_bits_[0] |= 1u << 0;
}

inline void StopCalibrationSessionResult::clear_has_Table () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CalibrationParameterStatus::CalibrationParameterStatus ()  :
    _Table (::midw_diagnostics_fi_types::T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM),
    _Name (),
    _Value (),
    _ElementSize (::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize__CALIBRATION_SIZE_BIT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CalibrationParameterStatus::CalibrationParameterStatus (const CalibrationParameterStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Table (::midw_diagnostics_fi_types::T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM),
    _Name (),
    _Value (),
    _ElementSize (::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize__CALIBRATION_SIZE_BIT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CalibrationParameterStatus::CalibrationParameterStatus (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_, const ::std::string& Name_, const ::midw_diagnostics_fi_types::T_CalibrationValue& Value_, ::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize ElementSize_)  :
    _Table (Table_),
    _Name (Name_),
    _Value (Value_),
    _ElementSize (ElementSize_)
{
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_CalibrationTable_IsValid(Table_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Table_, "T_e8_CalibrationTable", "Table", "CalibrationParameterStatus");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize_IsValid(ElementSize_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ElementSize_, "T_e8_CalibrationParameterSize", "ElementSize", "CalibrationParameterStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CalibrationParameterStatus::~CalibrationParameterStatus() {
}

inline CalibrationParameterStatus& CalibrationParameterStatus::operator = (const CalibrationParameterStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTable()) {
            setTable(rhs.getTable());
        } else {
            clearTable();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
        if (rhs.hasElementSize()) {
            setElementSize(rhs.getElementSize());
        } else {
            clearElementSize();
        }
    }
    return *this;
}

inline bool CalibrationParameterStatus::operator == (const CalibrationParameterStatus& rhs) const {
    return (((!hasTable() && !rhs.hasTable()) || getTable() == rhs.getTable()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()) &&
        ((!hasElementSize() && !rhs.hasElementSize()) || getElementSize() == rhs.getElementSize()));
}

inline bool CalibrationParameterStatus::operator != (const CalibrationParameterStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool CalibrationParameterStatus::operator < (const CalibrationParameterStatus& rhs) const {
    if (hasTable() || rhs.hasTable()) {
        if ((uint32)getTable() < (uint32)rhs.getTable()) return true;
        if ((uint32)getTable() > (uint32)rhs.getTable()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    if (hasElementSize() || rhs.hasElementSize()) {
        if ((uint32)getElementSize() < (uint32)rhs.getElementSize()) return true;
        if ((uint32)getElementSize() > (uint32)rhs.getElementSize()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CalibrationParameterStatus::clone() {
    return new CalibrationParameterStatus(*this);
}

inline bool CalibrationParameterStatus::operator > (const CalibrationParameterStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CalibrationParameterStatus::clear() {
    clearTable();
    clearName();
    clearValue();
    clearElementSize();
}

inline void CalibrationParameterStatus::clearTable() {
    if (hasTable()) {
         clear_has_Table();
        _Table = ::midw_diagnostics_fi_types::T_e8_CalibrationTable__CALIBRATION_TABLE_ID_SYSTEM;
     }
}

inline bool CalibrationParameterStatus::hasTable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_CalibrationTable CalibrationParameterStatus::getTable () const {
    return _Table;
}

inline void CalibrationParameterStatus::setTable (::midw_diagnostics_fi_types::T_e8_CalibrationTable Table_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_CalibrationTable_IsValid(Table_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Table_, "T_e8_CalibrationTable", "Table", "CalibrationParameterStatus");
    }
    #endif
    set_has_Table();
    this->_Table = Table_;
}

inline void CalibrationParameterStatus::clearName() {
    if (hasName()) {
         clear_has_Name();
        _Name.clear();
     }
}

inline bool CalibrationParameterStatus::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& CalibrationParameterStatus::getName () const {
    return _Name;
}

inline ::std::string& CalibrationParameterStatus::getNameMutable () {
    set_has_Name();
    return _Name;
}

inline void CalibrationParameterStatus::setName (const ::std::string& Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name = Name_;
}

inline void CalibrationParameterStatus::setName (const char* Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(Name_);
}

inline void CalibrationParameterStatus::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(value, size);
}

inline void CalibrationParameterStatus::clearValue() {
    if (hasValue()) {
         clear_has_Value();
        _Value.clear();
     }
}

inline bool CalibrationParameterStatus::hasValue () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_CalibrationValue& CalibrationParameterStatus::getValue () const {
    return _Value;
}

inline ::midw_diagnostics_fi_types::T_CalibrationValue& CalibrationParameterStatus::getValueMutable () {
    set_has_Value();
    return _Value;
}

inline void CalibrationParameterStatus::setValue (const ::midw_diagnostics_fi_types::T_CalibrationValue& Value_) {
    set_has_Value();
    this->_Value = Value_;
}

inline void CalibrationParameterStatus::clearElementSize() {
    if (hasElementSize()) {
         clear_has_ElementSize();
        _ElementSize = ::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize__CALIBRATION_SIZE_BIT;
     }
}

inline bool CalibrationParameterStatus::hasElementSize () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize CalibrationParameterStatus::getElementSize () const {
    return _ElementSize;
}

inline void CalibrationParameterStatus::setElementSize (::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize ElementSize_) {
    #ifndef NDEBUG
    if (!(::midw_diagnostics_fi_types::T_e8_CalibrationParameterSize_IsValid(ElementSize_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ElementSize_, "T_e8_CalibrationParameterSize", "ElementSize", "CalibrationParameterStatus");
    }
    #endif
    set_has_ElementSize();
    this->_ElementSize = ElementSize_;
}

inline void CalibrationParameterStatus::set_has_Table () {
    _has_bits_[0] |= 1u << 0;
}

inline void CalibrationParameterStatus::clear_has_Table () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CalibrationParameterStatus::set_has_Name () {
    _has_bits_[0] |= 1u << 1;
}

inline void CalibrationParameterStatus::clear_has_Name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CalibrationParameterStatus::set_has_Value () {
    _has_bits_[0] |= 1u << 2;
}

inline void CalibrationParameterStatus::clear_has_Value () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void CalibrationParameterStatus::set_has_ElementSize () {
    _has_bits_[0] |= 1u << 3;
}

inline void CalibrationParameterStatus::clear_has_ElementSize () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  CalibrationParameterSet::CalibrationParameterSet ()  :
    _SessionHandle (0u),
    _Name (),
    _Value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CalibrationParameterSet::CalibrationParameterSet (const CalibrationParameterSet &rhs)  :
    ::asf::core::Payload(rhs),
    _SessionHandle (0u),
    _Name (),
    _Value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CalibrationParameterSet::CalibrationParameterSet (uint32 SessionHandle_, const ::std::string& Name_, const ::midw_diagnostics_fi_types::T_CalibrationValue& Value_)  :
    _SessionHandle (SessionHandle_),
    _Name (Name_),
    _Value (Value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CalibrationParameterSet::~CalibrationParameterSet() {
}

inline CalibrationParameterSet& CalibrationParameterSet::operator = (const CalibrationParameterSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSessionHandle()) {
            setSessionHandle(rhs.getSessionHandle());
        } else {
            clearSessionHandle();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool CalibrationParameterSet::operator == (const CalibrationParameterSet& rhs) const {
    return (((!hasSessionHandle() && !rhs.hasSessionHandle()) || getSessionHandle() == rhs.getSessionHandle()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool CalibrationParameterSet::operator != (const CalibrationParameterSet& rhs) const {
    return ! (*this == rhs);
}

inline bool CalibrationParameterSet::operator < (const CalibrationParameterSet& rhs) const {
    if (hasSessionHandle() || rhs.hasSessionHandle()) {
        if (getSessionHandle() < rhs.getSessionHandle()) return true;
        if (getSessionHandle() > rhs.getSessionHandle()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CalibrationParameterSet::clone() {
    return new CalibrationParameterSet(*this);
}

inline bool CalibrationParameterSet::operator > (const CalibrationParameterSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CalibrationParameterSet::clear() {
    clearSessionHandle();
    clearName();
    clearValue();
}

inline void CalibrationParameterSet::clearSessionHandle() {
    if (hasSessionHandle()) {
         clear_has_SessionHandle();
        _SessionHandle = 0u;
     }
}

inline bool CalibrationParameterSet::hasSessionHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 CalibrationParameterSet::getSessionHandle () const {
    return _SessionHandle;
}

inline void CalibrationParameterSet::setSessionHandle (uint32 SessionHandle_) {
    set_has_SessionHandle();
    this->_SessionHandle = SessionHandle_;
}

inline void CalibrationParameterSet::clearName() {
    if (hasName()) {
         clear_has_Name();
        _Name.clear();
     }
}

inline bool CalibrationParameterSet::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& CalibrationParameterSet::getName () const {
    return _Name;
}

inline ::std::string& CalibrationParameterSet::getNameMutable () {
    set_has_Name();
    return _Name;
}

inline void CalibrationParameterSet::setName (const ::std::string& Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name = Name_;
}

inline void CalibrationParameterSet::setName (const char* Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(Name_);
}

inline void CalibrationParameterSet::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(value, size);
}

inline void CalibrationParameterSet::clearValue() {
    if (hasValue()) {
         clear_has_Value();
        _Value.clear();
     }
}

inline bool CalibrationParameterSet::hasValue () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_CalibrationValue& CalibrationParameterSet::getValue () const {
    return _Value;
}

inline ::midw_diagnostics_fi_types::T_CalibrationValue& CalibrationParameterSet::getValueMutable () {
    set_has_Value();
    return _Value;
}

inline void CalibrationParameterSet::setValue (const ::midw_diagnostics_fi_types::T_CalibrationValue& Value_) {
    set_has_Value();
    this->_Value = Value_;
}

inline void CalibrationParameterSet::set_has_SessionHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void CalibrationParameterSet::clear_has_SessionHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CalibrationParameterSet::set_has_Name () {
    _has_bits_[0] |= 1u << 1;
}

inline void CalibrationParameterSet::clear_has_Name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CalibrationParameterSet::set_has_Value () {
    _has_bits_[0] |= 1u << 2;
}

inline void CalibrationParameterSet::clear_has_Value () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  CalibrationParameterGet::CalibrationParameterGet ()  :
    _SessionHandle (0u),
    _Name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CalibrationParameterGet::CalibrationParameterGet (const CalibrationParameterGet &rhs)  :
    ::asf::core::Payload(rhs),
    _SessionHandle (0u),
    _Name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CalibrationParameterGet::CalibrationParameterGet (uint32 SessionHandle_, const ::std::string& Name_)  :
    _SessionHandle (SessionHandle_),
    _Name (Name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CalibrationParameterGet::~CalibrationParameterGet() {
}

inline CalibrationParameterGet& CalibrationParameterGet::operator = (const CalibrationParameterGet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSessionHandle()) {
            setSessionHandle(rhs.getSessionHandle());
        } else {
            clearSessionHandle();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool CalibrationParameterGet::operator == (const CalibrationParameterGet& rhs) const {
    return (((!hasSessionHandle() && !rhs.hasSessionHandle()) || getSessionHandle() == rhs.getSessionHandle()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool CalibrationParameterGet::operator != (const CalibrationParameterGet& rhs) const {
    return ! (*this == rhs);
}

inline bool CalibrationParameterGet::operator < (const CalibrationParameterGet& rhs) const {
    if (hasSessionHandle() || rhs.hasSessionHandle()) {
        if (getSessionHandle() < rhs.getSessionHandle()) return true;
        if (getSessionHandle() > rhs.getSessionHandle()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CalibrationParameterGet::clone() {
    return new CalibrationParameterGet(*this);
}

inline bool CalibrationParameterGet::operator > (const CalibrationParameterGet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CalibrationParameterGet::clear() {
    clearSessionHandle();
    clearName();
}

inline void CalibrationParameterGet::clearSessionHandle() {
    if (hasSessionHandle()) {
         clear_has_SessionHandle();
        _SessionHandle = 0u;
     }
}

inline bool CalibrationParameterGet::hasSessionHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 CalibrationParameterGet::getSessionHandle () const {
    return _SessionHandle;
}

inline void CalibrationParameterGet::setSessionHandle (uint32 SessionHandle_) {
    set_has_SessionHandle();
    this->_SessionHandle = SessionHandle_;
}

inline void CalibrationParameterGet::clearName() {
    if (hasName()) {
         clear_has_Name();
        _Name.clear();
     }
}

inline bool CalibrationParameterGet::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& CalibrationParameterGet::getName () const {
    return _Name;
}

inline ::std::string& CalibrationParameterGet::getNameMutable () {
    set_has_Name();
    return _Name;
}

inline void CalibrationParameterGet::setName (const ::std::string& Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name = Name_;
}

inline void CalibrationParameterGet::setName (const char* Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(Name_);
}

inline void CalibrationParameterGet::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(value, size);
}

inline void CalibrationParameterGet::set_has_SessionHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void CalibrationParameterGet::clear_has_SessionHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CalibrationParameterGet::set_has_Name () {
    _has_bits_[0] |= 1u << 1;
}

inline void CalibrationParameterGet::clear_has_Name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PartNumberStatus::PartNumberStatus ()  :
    _DataIdentifier (0u),
    _PartNumber (0u),
    _AlphaCode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PartNumberStatus::PartNumberStatus (const PartNumberStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DataIdentifier (0u),
    _PartNumber (0u),
    _AlphaCode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PartNumberStatus::PartNumberStatus (uint8 DataIdentifier_, uint32 PartNumber_, const ::midw_diagnostics_fi_types::T_AlphaCode& AlphaCode_)  :
    _DataIdentifier (DataIdentifier_),
    _PartNumber (PartNumber_),
    _AlphaCode (AlphaCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PartNumberStatus::~PartNumberStatus() {
}

inline PartNumberStatus& PartNumberStatus::operator = (const PartNumberStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataIdentifier()) {
            setDataIdentifier(rhs.getDataIdentifier());
        } else {
            clearDataIdentifier();
        }
        if (rhs.hasPartNumber()) {
            setPartNumber(rhs.getPartNumber());
        } else {
            clearPartNumber();
        }
        if (rhs.hasAlphaCode()) {
            setAlphaCode(rhs.getAlphaCode());
        } else {
            clearAlphaCode();
        }
    }
    return *this;
}

inline bool PartNumberStatus::operator == (const PartNumberStatus& rhs) const {
    return (((!hasDataIdentifier() && !rhs.hasDataIdentifier()) || getDataIdentifier() == rhs.getDataIdentifier()) &&
        ((!hasPartNumber() && !rhs.hasPartNumber()) || getPartNumber() == rhs.getPartNumber()) &&
        ((!hasAlphaCode() && !rhs.hasAlphaCode()) || getAlphaCode() == rhs.getAlphaCode()));
}

inline bool PartNumberStatus::operator != (const PartNumberStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool PartNumberStatus::operator < (const PartNumberStatus& rhs) const {
    if (hasDataIdentifier() || rhs.hasDataIdentifier()) {
        if (getDataIdentifier() < rhs.getDataIdentifier()) return true;
        if (getDataIdentifier() > rhs.getDataIdentifier()) return false;
    }
    if (hasPartNumber() || rhs.hasPartNumber()) {
        if (getPartNumber() < rhs.getPartNumber()) return true;
        if (getPartNumber() > rhs.getPartNumber()) return false;
    }
    if (hasAlphaCode() || rhs.hasAlphaCode()) {
        if (getAlphaCode() < rhs.getAlphaCode()) return true;
        if (getAlphaCode() > rhs.getAlphaCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PartNumberStatus::clone() {
    return new PartNumberStatus(*this);
}

inline bool PartNumberStatus::operator > (const PartNumberStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PartNumberStatus::clear() {
    clearDataIdentifier();
    clearPartNumber();
    clearAlphaCode();
}

inline void PartNumberStatus::clearDataIdentifier() {
    if (hasDataIdentifier()) {
         clear_has_DataIdentifier();
        _DataIdentifier = 0u;
     }
}

inline bool PartNumberStatus::hasDataIdentifier () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 PartNumberStatus::getDataIdentifier () const {
    return _DataIdentifier;
}

inline void PartNumberStatus::setDataIdentifier (uint8 DataIdentifier_) {
    set_has_DataIdentifier();
    this->_DataIdentifier = DataIdentifier_;
}

inline void PartNumberStatus::clearPartNumber() {
    if (hasPartNumber()) {
         clear_has_PartNumber();
        _PartNumber = 0u;
     }
}

inline bool PartNumberStatus::hasPartNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 PartNumberStatus::getPartNumber () const {
    return _PartNumber;
}

inline void PartNumberStatus::setPartNumber (uint32 PartNumber_) {
    set_has_PartNumber();
    this->_PartNumber = PartNumber_;
}

inline void PartNumberStatus::clearAlphaCode() {
    if (hasAlphaCode()) {
         clear_has_AlphaCode();
        _AlphaCode.clear();
     }
}

inline bool PartNumberStatus::hasAlphaCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_AlphaCode& PartNumberStatus::getAlphaCode () const {
    return _AlphaCode;
}

inline ::midw_diagnostics_fi_types::T_AlphaCode& PartNumberStatus::getAlphaCodeMutable () {
    set_has_AlphaCode();
    return _AlphaCode;
}

inline void PartNumberStatus::setAlphaCode (const ::midw_diagnostics_fi_types::T_AlphaCode& AlphaCode_) {
    set_has_AlphaCode();
    this->_AlphaCode = AlphaCode_;
}

inline void PartNumberStatus::set_has_DataIdentifier () {
    _has_bits_[0] |= 1u << 0;
}

inline void PartNumberStatus::clear_has_DataIdentifier () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PartNumberStatus::set_has_PartNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void PartNumberStatus::clear_has_PartNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PartNumberStatus::set_has_AlphaCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void PartNumberStatus::clear_has_AlphaCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  PartNumberSet::PartNumberSet ()  :
    _DataIdentifier (0u),
    _PartNumber (0u),
    _AlphaCode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PartNumberSet::PartNumberSet (const PartNumberSet &rhs)  :
    ::asf::core::Payload(rhs),
    _DataIdentifier (0u),
    _PartNumber (0u),
    _AlphaCode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PartNumberSet::PartNumberSet (uint8 DataIdentifier_, uint32 PartNumber_, const ::midw_diagnostics_fi_types::T_AlphaCode& AlphaCode_)  :
    _DataIdentifier (DataIdentifier_),
    _PartNumber (PartNumber_),
    _AlphaCode (AlphaCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PartNumberSet::~PartNumberSet() {
}

inline PartNumberSet& PartNumberSet::operator = (const PartNumberSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataIdentifier()) {
            setDataIdentifier(rhs.getDataIdentifier());
        } else {
            clearDataIdentifier();
        }
        if (rhs.hasPartNumber()) {
            setPartNumber(rhs.getPartNumber());
        } else {
            clearPartNumber();
        }
        if (rhs.hasAlphaCode()) {
            setAlphaCode(rhs.getAlphaCode());
        } else {
            clearAlphaCode();
        }
    }
    return *this;
}

inline bool PartNumberSet::operator == (const PartNumberSet& rhs) const {
    return (((!hasDataIdentifier() && !rhs.hasDataIdentifier()) || getDataIdentifier() == rhs.getDataIdentifier()) &&
        ((!hasPartNumber() && !rhs.hasPartNumber()) || getPartNumber() == rhs.getPartNumber()) &&
        ((!hasAlphaCode() && !rhs.hasAlphaCode()) || getAlphaCode() == rhs.getAlphaCode()));
}

inline bool PartNumberSet::operator != (const PartNumberSet& rhs) const {
    return ! (*this == rhs);
}

inline bool PartNumberSet::operator < (const PartNumberSet& rhs) const {
    if (hasDataIdentifier() || rhs.hasDataIdentifier()) {
        if (getDataIdentifier() < rhs.getDataIdentifier()) return true;
        if (getDataIdentifier() > rhs.getDataIdentifier()) return false;
    }
    if (hasPartNumber() || rhs.hasPartNumber()) {
        if (getPartNumber() < rhs.getPartNumber()) return true;
        if (getPartNumber() > rhs.getPartNumber()) return false;
    }
    if (hasAlphaCode() || rhs.hasAlphaCode()) {
        if (getAlphaCode() < rhs.getAlphaCode()) return true;
        if (getAlphaCode() > rhs.getAlphaCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PartNumberSet::clone() {
    return new PartNumberSet(*this);
}

inline bool PartNumberSet::operator > (const PartNumberSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PartNumberSet::clear() {
    clearDataIdentifier();
    clearPartNumber();
    clearAlphaCode();
}

inline void PartNumberSet::clearDataIdentifier() {
    if (hasDataIdentifier()) {
         clear_has_DataIdentifier();
        _DataIdentifier = 0u;
     }
}

inline bool PartNumberSet::hasDataIdentifier () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 PartNumberSet::getDataIdentifier () const {
    return _DataIdentifier;
}

inline void PartNumberSet::setDataIdentifier (uint8 DataIdentifier_) {
    set_has_DataIdentifier();
    this->_DataIdentifier = DataIdentifier_;
}

inline void PartNumberSet::clearPartNumber() {
    if (hasPartNumber()) {
         clear_has_PartNumber();
        _PartNumber = 0u;
     }
}

inline bool PartNumberSet::hasPartNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 PartNumberSet::getPartNumber () const {
    return _PartNumber;
}

inline void PartNumberSet::setPartNumber (uint32 PartNumber_) {
    set_has_PartNumber();
    this->_PartNumber = PartNumber_;
}

inline void PartNumberSet::clearAlphaCode() {
    if (hasAlphaCode()) {
         clear_has_AlphaCode();
        _AlphaCode.clear();
     }
}

inline bool PartNumberSet::hasAlphaCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::midw_diagnostics_fi_types::T_AlphaCode& PartNumberSet::getAlphaCode () const {
    return _AlphaCode;
}

inline ::midw_diagnostics_fi_types::T_AlphaCode& PartNumberSet::getAlphaCodeMutable () {
    set_has_AlphaCode();
    return _AlphaCode;
}

inline void PartNumberSet::setAlphaCode (const ::midw_diagnostics_fi_types::T_AlphaCode& AlphaCode_) {
    set_has_AlphaCode();
    this->_AlphaCode = AlphaCode_;
}

inline void PartNumberSet::set_has_DataIdentifier () {
    _has_bits_[0] |= 1u << 0;
}

inline void PartNumberSet::clear_has_DataIdentifier () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PartNumberSet::set_has_PartNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void PartNumberSet::clear_has_PartNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PartNumberSet::set_has_AlphaCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void PartNumberSet::clear_has_AlphaCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  PartNumberGet::PartNumberGet ()  :
    _DataIdentifier (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PartNumberGet::PartNumberGet (const PartNumberGet &rhs)  :
    ::asf::core::Payload(rhs),
    _DataIdentifier (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PartNumberGet::PartNumberGet (uint8 DataIdentifier_)  :
    _DataIdentifier (DataIdentifier_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PartNumberGet::~PartNumberGet() {
}

inline PartNumberGet& PartNumberGet::operator = (const PartNumberGet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataIdentifier()) {
            setDataIdentifier(rhs.getDataIdentifier());
        } else {
            clearDataIdentifier();
        }
    }
    return *this;
}

inline bool PartNumberGet::operator == (const PartNumberGet& rhs) const {
    return (((!hasDataIdentifier() && !rhs.hasDataIdentifier()) || getDataIdentifier() == rhs.getDataIdentifier()));
}

inline bool PartNumberGet::operator != (const PartNumberGet& rhs) const {
    return ! (*this == rhs);
}

inline bool PartNumberGet::operator < (const PartNumberGet& rhs) const {
    if (hasDataIdentifier() || rhs.hasDataIdentifier()) {
        if (getDataIdentifier() < rhs.getDataIdentifier()) return true;
        if (getDataIdentifier() > rhs.getDataIdentifier()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PartNumberGet::clone() {
    return new PartNumberGet(*this);
}

inline bool PartNumberGet::operator > (const PartNumberGet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PartNumberGet::clear() {
    clearDataIdentifier();
}

inline void PartNumberGet::clearDataIdentifier() {
    if (hasDataIdentifier()) {
         clear_has_DataIdentifier();
        _DataIdentifier = 0u;
     }
}

inline bool PartNumberGet::hasDataIdentifier () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 PartNumberGet::getDataIdentifier () const {
    return _DataIdentifier;
}

inline void PartNumberGet::setDataIdentifier (uint8 DataIdentifier_) {
    set_has_DataIdentifier();
    this->_DataIdentifier = DataIdentifier_;
}

inline void PartNumberGet::set_has_DataIdentifier () {
    _has_bits_[0] |= 1u << 0;
}

inline void PartNumberGet::clear_has_DataIdentifier () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace Midw_Diagnostics_FI

#endif // MIDW_DIAGNOSTICS_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
