/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "org/bosch/cm/lcmccadbusgw/LcmccadbusgwAsf.h"
#include "org/bosch/cm/lcmccadbusgw/LcmccadbusgwAsfComponent.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "LcmccadbusgwAsf" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace cm {
namespace lcmccadbusgw {

DEFINE_LOGGER_AND_LEVEL (_logger, "/org/bosch/cm/lcmccadbusgw/LcmccadbusgwAsf", Info);

/* static */ const char* LcmccadbusgwAsf::asfComponent = "asfComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool LcmccadbusgwAsf_enabledASFSignalHandler = false;

void importLcmccadbusgwAsf() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach LcmccadbusgwAsf, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression0;
        {
            __expression0.setApplicationId(238);
        }
        ccaConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Thread 'AsfClientThread'

    ::asf::core::ComponentContainerSharedPtr AsfClientThread(new ::asf::core::ComponentContainer("AsfClientThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (AsfClientThread);

        // Component 'LcmccadbusgwAsfComponent asfComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::org::bosch::cm::lcmccadbusgw::LcmccadbusgwAsfComponent > > asfComponentFactory(new ::asf::core::ComponentFactory< ::org::bosch::cm::lcmccadbusgw::LcmccadbusgwAsfComponent >);
        ::asf::core::ComponentDescriptionSharedPtr asfComponentDescription(new ::asf::core::ComponentDescription(1, "asfComponent", /* immediate = */ true, /* threadBridge = */ false, asfComponentFactory));
        AsfClientThread->addComponentDescription(asfComponentDescription);

            // Port 'LcmDbusFiFiPort'

            ::asf::core::ProvidedPort& asfComponent_LcmDbusFiFiPort = asfComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", "LcmDbusFiFiPort", false, false));
            (void)asfComponent_LcmDbusFiFiPort; // prevent unused variable warning

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& asfComponent_spmFiPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)asfComponent_spmFiPort; // prevent unused variable warning

    // Expression

    dbusConnector_->exportByName (asfComponent_LcmDbusFiFiPort, ::std::string("/com/bosch/cm/lcmccadbusgw/server/LcmDbusFi"));

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 4, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_spmFiPort, spmFiImport);


    LOG_INFO_STATIC("Starting application 'LcmccadbusgwAsf' version 1.0.0");

    app->start();
}

int executeLcmccadbusgwAsf(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("org.bosch.cm.lcmccadbusgw", "LcmccadbusgwAsf");
    } else {
        ::asf::core::Logger::setupLogging ("org.bosch.cm.lcmccadbusgw", "LcmccadbusgwAsf", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", LcmccadbusgwAsf_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("org.bosch.cm.lcmccadbusgw", "LcmccadbusgwAsf", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create LcmccadbusgwAsf");

    app->enableExceptionHandler(false);

    importLcmccadbusgwAsf();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace lcmccadbusgw
} // namespace cm
} // namespace bosch
} // namespace org

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::org::bosch::cm::lcmccadbusgw::executeLcmccadbusgwAsf(argc, argv);
}

