/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "org/genivi/LcmAsfComponent.h"
#include "org/genivi/NodeStateManager.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "NodeStateManager" isn't clear, then there should be a description here.
 */

namespace org {
namespace genivi {

DEFINE_LOGGER_AND_LEVEL (_logger, "/org/genivi/NodeStateManager", Info);

/* static */ const char* NodeStateManager::asfComponent = "asfComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool NodeStateManager_enabledASFSignalHandler = false;

void importNodeStateManager() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach NodeStateManager, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression0;
        {
            __expression0.setApplicationId(28);
        }
        ccaConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Thread 'LcmLateClientThread'

    ::asf::core::ComponentContainerSharedPtr LcmLateClientThread(new ::asf::core::ComponentContainer("LcmLateClientThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (LcmLateClientThread);

        // Component 'LcmAsfComponent asfComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::org::genivi::LcmAsfComponent > > asfComponentFactory(new ::asf::core::ComponentFactory< ::org::genivi::LcmAsfComponent >);
        ::asf::core::ComponentDescriptionSharedPtr asfComponentDescription(new ::asf::core::ComponentDescription(1, "asfComponent", /* immediate = */ true, /* threadBridge = */ false, asfComponentFactory));
        LcmLateClientThread->addComponentDescription(asfComponentDescription);

            // Port 'ConsumerPort'

            ::asf::core::ProvidedPort& asfComponent_ConsumerPort = asfComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort", false, false));
            (void)asfComponent_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::ProvidedPort& asfComponent_LifecycleControlPort = asfComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort", false, false));
            (void)asfComponent_LifecycleControlPort; // prevent unused variable warning

            // Port 'GenericRecoveryClientPort'

            ::asf::core::ProvidedPort& asfComponent_GenericRecoveryClientPort = asfComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.lcm.Generic_RecoveryClient", "GenericRecoveryClientPort", false, false));
            (void)asfComponent_GenericRecoveryClientPort; // prevent unused variable warning

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& asfComponent_spmFiPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)asfComponent_spmFiPort; // prevent unused variable warning

            // Port 'StartupCtrlClientFiPort'

            ::asf::core::RequiredPort& asfComponent_StartupCtrlClientFiPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.lcm.startupcontroller", "StartupCtrlClientFiPort"));
            (void)asfComponent_StartupCtrlClientFiPort; // prevent unused variable warning

            // Port 'DBusSystemdManagerPort'

            ::asf::core::RequiredPort& asfComponent_DBusSystemdManagerPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.freedesktop.systemd1.Manager", "DBusSystemdManagerPort"));
            (void)asfComponent_DBusSystemdManagerPort; // prevent unused variable warning

            // Port 'DBusUnitClientPort'

            ::asf::core::RequiredPort& asfComponent_DBusUnitClientPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.freedesktop.systemd1.Unit", "DBusUnitClientPort", /* wired at runtime */ true));
            (void)asfComponent_DBusUnitClientPort; // prevent unused variable warning

            // Port 'DBusServiceClientPort'

            ::asf::core::RequiredPort& asfComponent_DBusServiceClientPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.freedesktop.systemd1.Service", "DBusServiceClientPort", /* wired at runtime */ true));
            (void)asfComponent_DBusServiceClientPort; // prevent unused variable warning

            // Port 'DBusLifecycleConsumerPort'

            ::asf::core::RequiredPort& asfComponent_DBusLifecycleConsumerPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "DBusLifecycleConsumerPort", /* wired at runtime */ true));
            (void)asfComponent_DBusLifecycleConsumerPort; // prevent unused variable warning

    // Expression

    dbusSystemConnector_->exportByName (asfComponent_ConsumerPort, ::std::string("/org/genivi/NodeStateManager/Consumer"));

    // Expression

    dbusSystemConnector_->exportByName (asfComponent_LifecycleControlPort, ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));

    // Expression

    dbusSystemConnector_->exportByName (asfComponent_GenericRecoveryClientPort, ::std::string("/org/bosch/cm/lcm/GenericRecoveryClient"));

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 2, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_spmFiPort, spmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& StartupCtrlClientFiImport = dbusSystemConnector_->importByName (::std::string("org.bosch.cm.lcm.startupcontroller.StartupController"), ::std::string("/org/bosch/cm/lcm/StartupController"));
    StartupCtrlClientFiImport.setServiceName("org.bosch.cm.lcm.startupcontroller");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_StartupCtrlClientFiPort, StartupCtrlClientFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& systemdService = dbusSystemConnector_->importByName (::std::string("org.freedesktop.systemd1"), ::std::string("/org/freedesktop/systemd1"));
    systemdService.setServiceName("org.freedesktop.systemd1.Manager");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_DBusSystemdManagerPort, systemdService);


    LOG_INFO_STATIC("Starting application 'NodeStateManager' version 1.0.0");

    app->start();
}

int executeNodeStateManager(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("org.genivi", "NodeStateManager");
    } else {
        ::asf::core::Logger::setupLogging ("org.genivi", "NodeStateManager", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", NodeStateManager_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("org.genivi", "NodeStateManager", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create NodeStateManager");

    app->enableExceptionHandler(false);

    importNodeStateManager();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace genivi
} // namespace org

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::org::genivi::executeNodeStateManager(argc, argv);
}

