/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_tv_fi/SdsTvService.h"
#include "sds_tv_fi/SdsTvServiceDBus.h"
#include "sds_tv_fi/SdsTvServiceJson.h"
#include "sds_tv_fi/SdsTvServiceStub.h"

#include "asf/dbus/DBusMessage.h"

namespace sds_tv_fi {
namespace SdsTvService {

DEFINE_CLASS_LOGGER("/sds_tv_fi/sds_tv_fi/SdsTvService", SdsTvServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 19, "storeTVChannelNames", 0 },
};


class SdsTvServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SdsTvServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SdsTvServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SdsTvServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "sds_tv_fi.SdsTvService"),
          _logger(logger) {}

    virtual ~SdsTvServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SdsTvServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'storeTVChannelNames'

            LOG_DEBUG_STUB("process method '%s'", "storeTVChannelNames");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreTVChannelNamesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StoreTVChannelNames", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StoreTVChannelNamesRequest > payload = ::boost::static_pointer_cast<StoreTVChannelNamesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsTvServiceStub*>(getStub())->onStoreTVChannelNamesRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SdsTvServiceStubDelegate::introspect() const {
    return     "<interface name=\"sds_tv_fi.SdsTvService\">\n"
            "    <method name=\"storeTVChannelNames\">\n"
            "      <arg direction=\"in\" name=\"channelList\" type=\"a(uus)\">\n"
            "        <doc>\n"
            "          <line>channelList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"ProcessingFinished\"/>\n"
            "    <signal name=\"ProcessingInterrupted\"/>\n"
            "</interface>\n";
}

void SdsTvServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SdsTvServiceStub*>(getStub()))->onGetAll (properties);
}

void SdsTvServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SdsTvServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SdsTvServiceStub::SdsTvServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsTvServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsTvServiceStub::SdsTvServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsTvServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsTvServiceStub::~SdsTvServiceStub() {
    delete _stubDelegate;
}

void SdsTvServiceStub::sendProcessingFinishedSignal() {
    if (_stubDelegate->isConnected()) {
        ProcessingFinishedSignal* payload = new ProcessingFinishedSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ProcessingFinished", ProcessingFinishedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProcessingFinished");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProcessingFinished");
    }
}

void SdsTvServiceStub::sendProcessingInterruptedSignal() {
    if (_stubDelegate->isConnected()) {
        ProcessingInterruptedSignal* payload = new ProcessingInterruptedSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ProcessingInterrupted", ProcessingInterruptedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProcessingInterrupted");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProcessingInterrupted");
    }
}

void  SdsTvServiceStub::sendStoreTVChannelNamesResponse (act_t act) {
    StoreTVChannelNamesResponse* payload = new StoreTVChannelNamesResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "storeTVChannelNames", StoreTVChannelNamesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StoreTVChannelNames", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsTvServiceStub::sendStoreTVChannelNamesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StoreTVChannelNamesError* payload = new StoreTVChannelNamesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "storeTVChannelNames", StoreTVChannelNamesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StoreTVChannelNames", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SdsTvServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace SdsTvService
} // namespace sds_tv_fi
