/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_TV_FI_SDSTVSERVICEPROXY_H
#define SDS_TV_FI_SDSTVSERVICEPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "sds_tv_fi/SdsTvService.h"
#include <dbus/dbus.h>
#include <vector>

namespace sds_tv_fi {
namespace SdsTvService {

class SdsTvServiceProxy;

class ProcessingFinishedCallbackIF {
public:
    virtual ~ProcessingFinishedCallbackIF() {}

    virtual void onProcessingFinishedError(const ::boost::shared_ptr< SdsTvServiceProxy >& proxy, const ::boost::shared_ptr< ProcessingFinishedError >& error) = 0;

    virtual void onProcessingFinishedSignal(const ::boost::shared_ptr< SdsTvServiceProxy >& proxy, const ::boost::shared_ptr< ProcessingFinishedSignal >& signal) = 0;
};

class ProcessingInterruptedCallbackIF {
public:
    virtual ~ProcessingInterruptedCallbackIF() {}

    virtual void onProcessingInterruptedError(const ::boost::shared_ptr< SdsTvServiceProxy >& proxy, const ::boost::shared_ptr< ProcessingInterruptedError >& error) = 0;

    virtual void onProcessingInterruptedSignal(const ::boost::shared_ptr< SdsTvServiceProxy >& proxy, const ::boost::shared_ptr< ProcessingInterruptedSignal >& signal) = 0;
};

class StoreTVChannelNamesCallbackIF {
public:
    virtual ~StoreTVChannelNamesCallbackIF() {}

    virtual void onStoreTVChannelNamesError(const ::boost::shared_ptr< SdsTvServiceProxy >& proxy, const ::boost::shared_ptr< StoreTVChannelNamesError >& error) = 0;

    virtual void onStoreTVChannelNamesResponse(const ::boost::shared_ptr< SdsTvServiceProxy >& proxy, const ::boost::shared_ptr< StoreTVChannelNamesResponse >& response) = 0;
};


/**
 * SdsTvServiceProxy is the client side representation of the D-Bus
 * service interface 'sds_tv_fi.SdsTvService' (specified in file
 * sds_tv_fi_.xml).
 *
 * If the meaning of "sds_tv_fi.SdsTvService" isn't clear, then there should be a description here.
 */
class SdsTvServiceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of SdsTvServiceProxy.
     */
    static ::boost::shared_ptr< SdsTvServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of SdsTvServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< SdsTvServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of SdsTvServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< SdsTvServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< SdsTvServiceProxy > proxyNew(new SdsTvServiceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~SdsTvServiceProxy ();


    // Signal 'ProcessingFinished'

    /**
     * Notify on the signal 'ProcessingFinished'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'ProcessingFinished'</b>:
     *
     * If the meaning of "ProcessingFinished" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProcessingFinishedRegister(ProcessingFinishedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ProcessingFinished'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ProcessingFinished'</b>:
     *
     * If the meaning of "ProcessingFinished" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendProcessingFinishedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendProcessingFinishedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ProcessingFinished'.
     */
    void sendProcessingFinishedDeregisterAll () const;

    // Signal 'ProcessingInterrupted'

    /**
     * Notify on the signal 'ProcessingInterrupted'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'ProcessingInterrupted'</b>:
     *
     * If the meaning of "ProcessingInterrupted" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProcessingInterruptedRegister(ProcessingInterruptedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ProcessingInterrupted'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ProcessingInterrupted'</b>:
     *
     * If the meaning of "ProcessingInterrupted" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendProcessingInterruptedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendProcessingInterruptedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ProcessingInterrupted'.
     */
    void sendProcessingInterruptedDeregisterAll () const;



    // Method 'storeTVChannelNames'

    /**
     * Call the method 'storeTVChannelNames'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'storeTVChannelNames'</b>:
     *
     * If the meaning of "storeTVChannelNames" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param channelList If the meaning of "channelList" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStoreTVChannelNamesRequest(StoreTVChannelNamesCallbackIF& cb, const ::std::vector< TVChannelItem >& channelList) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    SdsTvServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class SdsTvServiceProxyCallback;
};

} // namespace SdsTvService
} // namespace sds_tv_fi

#endif // SDS_TV_FI_SDSTVSERVICEPROXY_H
