/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_tv_fi/SdsTvService.h"
#include "sds_tv_fi/SdsTvServiceDBus.h"
#include "sds_tv_fi/SdsTvServiceJson.h"
#include "sds_tv_fi/SdsTvServiceProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace sds_tv_fi {
namespace SdsTvService {

DEFINE_CLASS_LOGGER("/sds_tv_fi/sds_tv_fi/SdsTvService", SdsTvServiceProxy);

class SdsTvServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SdsTvServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SdsTvServiceProxy >& proxyShared = ::boost::static_pointer_cast< SdsTvServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ProcessingFinished:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProcessingFinishedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProcessingFinished", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProcessingFinishedSignal> payload = ::boost::static_pointer_cast<ProcessingFinishedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProcessingFinishedCallbackIF*) _callback)->onProcessingFinishedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ProcessingInterrupted:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProcessingInterruptedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProcessingInterrupted", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProcessingInterruptedSignal> payload = ::boost::static_pointer_cast<ProcessingInterruptedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProcessingInterruptedCallbackIF*) _callback)->onProcessingInterruptedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_storeTVChannelNames:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StoreTVChannelNamesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreTVChannelNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreTVChannelNamesError> payload = ::boost::static_pointer_cast<StoreTVChannelNamesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreTVChannelNamesCallbackIF*) _callback)->onStoreTVChannelNamesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreTVChannelNamesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreTVChannelNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreTVChannelNamesResponse> payload = ::boost::static_pointer_cast<StoreTVChannelNamesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreTVChannelNamesCallbackIF*) _callback)->onStoreTVChannelNamesResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ProcessingFinished: {
                ::boost::shared_ptr< ProcessingFinishedError > payload = ::boost::shared_ptr< ProcessingFinishedError >
                (new ProcessingFinishedError(DBUS_ERROR_NO_SERVER, "The DBus service SdsTvService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProcessingFinished", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsTvServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsTvServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProcessingFinishedCallbackIF*) _callback)->onProcessingFinishedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ProcessingInterrupted: {
                ::boost::shared_ptr< ProcessingInterruptedError > payload = ::boost::shared_ptr< ProcessingInterruptedError >
                (new ProcessingInterruptedError(DBUS_ERROR_NO_SERVER, "The DBus service SdsTvService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProcessingInterrupted", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsTvServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsTvServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProcessingInterruptedCallbackIF*) _callback)->onProcessingInterruptedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_storeTVChannelNames: {
                ::boost::shared_ptr< StoreTVChannelNamesError > payload = ::boost::shared_ptr< StoreTVChannelNamesError >
                (new StoreTVChannelNamesError(DBUS_ERROR_NO_SERVER, "The DBus service SdsTvService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StoreTVChannelNames", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsTvServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsTvServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StoreTVChannelNamesCallbackIF*) _callback)->onStoreTVChannelNamesError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SdsTvServiceProxyCallback::_logger (SdsTvServiceProxy::_logger);

SdsTvServiceProxy::SdsTvServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "sds_tv_fi.SdsTvService", serviceAvailable, _logger) {
}

SdsTvServiceProxy::~SdsTvServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SdsTvServiceProxy > SdsTvServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SdsTvServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SdsTvServiceProxy > proxyNew(new SdsTvServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t SdsTvServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SdsTvServiceProxyCallback* callback = new SdsTvServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SdsTvServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SdsTvServiceProxyCallback* callback = new SdsTvServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void SdsTvServiceProxy::sendDeregisterAll () const
{
    sendProcessingFinishedDeregisterAll();
    sendProcessingInterruptedDeregisterAll();
}

act_t SdsTvServiceProxy::sendProcessingFinishedRegister(ProcessingFinishedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ProcessingFinished");
    act_t act = addSignalCallback(ID_ProcessingFinished, "ProcessingFinished", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProcessingFinished", &cb, act);
    return act;
}

bool SdsTvServiceProxy::sendProcessingFinishedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ProcessingFinished", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProcessingFinished", act, static_cast<int>(rv));
    return rv;
}

void SdsTvServiceProxy::sendProcessingFinishedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProcessingFinished");
    _dbusProxyDelegate->deregisterSignalCallback("ProcessingFinished", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsTvServiceProxy::sendProcessingInterruptedRegister(ProcessingInterruptedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ProcessingInterrupted");
    act_t act = addSignalCallback(ID_ProcessingInterrupted, "ProcessingInterrupted", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProcessingInterrupted", &cb, act);
    return act;
}

bool SdsTvServiceProxy::sendProcessingInterruptedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ProcessingInterrupted", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProcessingInterrupted", act, static_cast<int>(rv));
    return rv;
}

void SdsTvServiceProxy::sendProcessingInterruptedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProcessingInterrupted");
    _dbusProxyDelegate->deregisterSignalCallback("ProcessingInterrupted", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsTvServiceProxy::sendStoreTVChannelNamesRequest(StoreTVChannelNamesCallbackIF& cb, const ::std::vector< TVChannelItem >& channelList) const {
    StoreTVChannelNamesRequest* payload = new StoreTVChannelNamesRequest();
    CHECK_ALLOCATION(payload);
    payload->setChannelList(channelList);
    DBUS_MESSAGE_CALL(dbusMessage, "storeTVChannelNames", StoreTVChannelNamesRequest, payload, true)
    act_t act = addMethodCallback(ID_storeTVChannelNames, dbusMessage.getUniqueSerial(), "storeTVChannelNames", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StoreTVChannelNames", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SdsTvService
} // namespace sds_tv_fi
