/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "sds_sxm_fi/SdsSxmService.h"
#include "sds_sxm_fi/SdsSxmServiceDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of SXMChannelItem

void serializeDBus (const ::sds_sxm_fi::SdsSxmService::SXMChannelItem& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        uint16 o1 = in.getServiceID();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT16, &o1));
        uint16 o2 = in.getChannelID();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT16, &o2));
        uint16 o3 = in.getChannelNumber();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT16, &o3));
        const char* o4 = in.getChannelName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o4));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::sds_sxm_fi::SdsSxmService::SXMChannelItem& out) {
    {
        DBusMessageIter o5;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o5);
                {
                    uint16 serviceIDValue;
                    uint16 &serviceIDTmpValue = serviceIDValue;
                    dbus_message_iter_get_basic(&o5, &serviceIDTmpValue);
                    out.setServiceID(serviceIDValue);
                }

                if (dbus_message_iter_has_next(&o5)) {
                    dbus_message_iter_next(&o5);
                } else {
                    return true;
                }

                {
                    uint16 channelIDValue;
                    uint16 &channelIDTmpValue = channelIDValue;
                    dbus_message_iter_get_basic(&o5, &channelIDTmpValue);
                    out.setChannelID(channelIDValue);
                }

                if (dbus_message_iter_has_next(&o5)) {
                    dbus_message_iter_next(&o5);
                } else {
                    return true;
                }

                {
                    uint16 channelNumberValue;
                    uint16 &channelNumberTmpValue = channelNumberValue;
                    dbus_message_iter_get_basic(&o5, &channelNumberTmpValue);
                    out.setChannelNumber(channelNumberValue);
                }

                if (dbus_message_iter_has_next(&o5)) {
                    dbus_message_iter_next(&o5);
                } else {
                    return true;
                }

                {
                    ::std::string channelNameValue;
                    ::std::string &channelNameTmpValue = channelNameValue;
                    {
                        char* o6 = 0;
                        dbus_message_iter_get_basic(&o5, &o6);
                        channelNameTmpValue.assign (o6);
                    }
                    out.setChannelName(channelNameValue);
                }

                if (dbus_message_iter_has_next(&o5)) {
                    dbus_message_iter_next(&o5);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SXMPhoneticData

void serializeDBus (const ::sds_sxm_fi::SdsSxmService::SXMPhoneticData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o7Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o7Struct));
        uint16 o8 = in.getLanguageID();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o7Struct, DBUS_TYPE_UINT16, &o8));
        uint16 o9 = in.getServiceID();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o7Struct, DBUS_TYPE_UINT16, &o9));
        const char* o10 = in.getPhoneticData().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o7Struct, DBUS_TYPE_STRING, &o10));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o7Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::sds_sxm_fi::SdsSxmService::SXMPhoneticData& out) {
    {
        DBusMessageIter o11;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o11);
                {
                    uint16 languageIDValue;
                    uint16 &languageIDTmpValue = languageIDValue;
                    dbus_message_iter_get_basic(&o11, &languageIDTmpValue);
                    out.setLanguageID(languageIDValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    uint16 serviceIDValue;
                    uint16 &serviceIDTmpValue = serviceIDValue;
                    dbus_message_iter_get_basic(&o11, &serviceIDTmpValue);
                    out.setServiceID(serviceIDValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::std::string phoneticDataValue;
                    ::std::string &phoneticDataTmpValue = phoneticDataValue;
                    {
                        char* o12 = 0;
                        dbus_message_iter_get_basic(&o11, &o12);
                        phoneticDataTmpValue.assign (o12);
                    }
                    out.setPhoneticData(phoneticDataValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of StoreSXMChannelNamesRequest

void serializeDBus (const ::sds_sxm_fi::SdsSxmService::StoreSXMChannelNamesRequest& in, DBusMessageIter* out) {
    DBusMessageIter o13ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qqqs)", &o13ArrayIter));
    const ::std::vector< ::sds_sxm_fi::SdsSxmService::SXMChannelItem >* o14 = &in.getChannelsList();
    ::std::vector< ::sds_sxm_fi::SdsSxmService::SXMChannelItem >::const_iterator o15 = o14->end();
    for (::std::vector< ::sds_sxm_fi::SdsSxmService::SXMChannelItem >::const_iterator o16 = o14->begin(); o16 != o15; ++o16) {
        serializeDBus((*o16), &o13ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o13ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::sds_sxm_fi::SdsSxmService::StoreSXMChannelNamesRequest& out) {
    {
        ::std::vector< ::sds_sxm_fi::SdsSxmService::SXMChannelItem > channelsListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o17ArrayIter;
            dbus_message_iter_recurse (in, &o17ArrayIter);

            if(dbus_message_iter_get_arg_type(&o17ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::sds_sxm_fi::SdsSxmService::SXMChannelItem o18;
                    if (!deserializeDBus(&o17ArrayIter, o18)) {
                        return false;
                    }
                    channelsListValue.push_back(o18);
                } while (dbus_message_iter_next(&o17ArrayIter));
            }
        }
        out.setChannelsList(channelsListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StoreSXMPhoneticDataRequest

void serializeDBus (const ::sds_sxm_fi::SdsSxmService::StoreSXMPhoneticDataRequest& in, DBusMessageIter* out) {
    DBusMessageIter o19ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qqs)", &o19ArrayIter));
    const ::std::vector< ::sds_sxm_fi::SdsSxmService::SXMPhoneticData >* o20 = &in.getPhonemesList();
    ::std::vector< ::sds_sxm_fi::SdsSxmService::SXMPhoneticData >::const_iterator o21 = o20->end();
    for (::std::vector< ::sds_sxm_fi::SdsSxmService::SXMPhoneticData >::const_iterator o22 = o20->begin(); o22 != o21; ++o22) {
        serializeDBus((*o22), &o19ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o19ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::sds_sxm_fi::SdsSxmService::StoreSXMPhoneticDataRequest& out) {
    {
        ::std::vector< ::sds_sxm_fi::SdsSxmService::SXMPhoneticData > phonemesListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o23ArrayIter;
            dbus_message_iter_recurse (in, &o23ArrayIter);

            if(dbus_message_iter_get_arg_type(&o23ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::sds_sxm_fi::SdsSxmService::SXMPhoneticData o24;
                    if (!deserializeDBus(&o23ArrayIter, o24)) {
                        return false;
                    }
                    phonemesListValue.push_back(o24);
                } while (dbus_message_iter_next(&o23ArrayIter));
            }
        }
        out.setPhonemesList(phonemesListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ProcessingFinishedSignal

void serializeDBus (const ::sds_sxm_fi::SdsSxmService::ProcessingFinishedSignal& in, DBusMessageIter* out) {
    const char* o25 = in.getMessage().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o25));
}

bool deserializeDBus (DBusMessageIter* in, ::sds_sxm_fi::SdsSxmService::ProcessingFinishedSignal& out) {
    {
        ::std::string messageValue;
        ::std::string &messageTmpValue = messageValue;
        {
            char* o26 = 0;
            dbus_message_iter_get_basic(in, &o26);
            messageTmpValue.assign (o26);
        }
        out.setMessage(messageValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ProcessingInterruptedSignal

void serializeDBus (const ::sds_sxm_fi::SdsSxmService::ProcessingInterruptedSignal& in, DBusMessageIter* out) {
    const char* o27 = in.getMessage().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o27));
}

bool deserializeDBus (DBusMessageIter* in, ::sds_sxm_fi::SdsSxmService::ProcessingInterruptedSignal& out) {
    {
        ::std::string messageValue;
        ::std::string &messageTmpValue = messageValue;
        {
            char* o28 = 0;
            dbus_message_iter_get_basic(in, &o28);
            messageTmpValue.assign (o28);
        }
        out.setMessage(messageValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

