#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_SXM_FI_SDSSXMSERVICE_H
#define SDS_SXM_FI_SDSSXMSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "sds_sxm_fi.SdsSxmService" isn't clear, then there should be a description here.
 */

namespace sds_sxm_fi {
namespace SdsSxmService {

// method IDs
static const uint16 ID_storeSXMChannelNames = 0;
static const uint16 ID_storeSXMPhoneticData = 1;

// signal IDs
static const uint16 ID_ProcessingFinished = 2;
static const uint16 ID_ProcessingInterrupted = 3;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class SXMChannelItem;

class SXMPhoneticData;

class StoreSXMChannelNamesRequest;

class StoreSXMPhoneticDataRequest;

class ProcessingFinishedSignal;

class ProcessingInterruptedSignal;

// type definitions
/**
 * If the meaning of "storeSXMChannelNames" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StoreSXMChannelNamesResponse;

/**
 * If the meaning of "StoreSXMChannelNamesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StoreSXMChannelNamesError;

/**
 * If the meaning of "storeSXMPhoneticData" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StoreSXMPhoneticDataResponse;

/**
 * If the meaning of "StoreSXMPhoneticDataError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StoreSXMPhoneticDataError;

/**
 * If the meaning of "ProcessingFinishedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProcessingFinishedError;

/**
 * If the meaning of "ProcessingInterruptedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProcessingInterruptedError;


/**
 * If the meaning of "SXMChannelItem" isn't clear, then there should be a description here.
 */
class SXMChannelItem {
public:

    /**
     * Default constructor
     */
    inline  SXMChannelItem ();

    /**
     * Copy constructor
     */
    inline  SXMChannelItem (const SXMChannelItem &rhs);

    /**
     * All fields constructor
     */
    inline  SXMChannelItem (uint16 serviceID_, uint16 channelID_, uint16 channelNumber_, const ::std::string& channelName_);

    /**
     * Destructor
     */
    inline  ~SXMChannelItem();

    /**
     * Assignment operator
     */
    inline SXMChannelItem& operator = (const SXMChannelItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SXMChannelItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SXMChannelItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SXMChannelItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SXMChannelItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceID"

    static const int kServiceID = 0;

    /**
     * Clears the field "serviceID".
     *
     * The field will be set to its default value. The hasServiceID()
     * method will return false.
     */
    inline void clearServiceID();

    /**
     * Checks whether the field "serviceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceID()). Otherwise it will return false.
     */
    inline bool hasServiceID () const;

    /**
     * Returns the value of the member "serviceID".
     *
     * If the meaning of "serviceID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "serviceID"
     */
    inline uint16 getServiceID () const;

    /**
     * Sets the value of the member "serviceID".
     *
     * If the meaning of "serviceID" isn't clear, then there should be a description here.
     *
     * @param serviceID The value which will be set
     */
    inline void setServiceID (uint16 serviceID_);

    // API of field "channelID"

    static const int kChannelID = 1;

    /**
     * Clears the field "channelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "channelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "channelID".
     *
     * If the meaning of "channelID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "channelID"
     */
    inline uint16 getChannelID () const;

    /**
     * Sets the value of the member "channelID".
     *
     * If the meaning of "channelID" isn't clear, then there should be a description here.
     *
     * @param channelID The value which will be set
     */
    inline void setChannelID (uint16 channelID_);

    // API of field "channelNumber"

    static const int kChannelNumber = 2;

    /**
     * Clears the field "channelNumber".
     *
     * The field will be set to its default value. The hasChannelNumber()
     * method will return false.
     */
    inline void clearChannelNumber();

    /**
     * Checks whether the field "channelNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelNumber()). Otherwise it will return false.
     */
    inline bool hasChannelNumber () const;

    /**
     * Returns the value of the member "channelNumber".
     *
     * If the meaning of "channelNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "channelNumber"
     */
    inline uint16 getChannelNumber () const;

    /**
     * Sets the value of the member "channelNumber".
     *
     * If the meaning of "channelNumber" isn't clear, then there should be a description here.
     *
     * @param channelNumber The value which will be set
     */
    inline void setChannelNumber (uint16 channelNumber_);

    // API of field "channelName"

    static const int kChannelName = 3;

    /**
     * Clears the field "channelName".
     *
     * The field will be set to its default value. The hasChannelName()
     * method will return false.
     */
    inline void clearChannelName();

    /**
     * Checks whether the field "channelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelName()). Otherwise it will return false.
     */
    inline bool hasChannelName () const;

    /**
     * Returns the value of the member "channelName".
     *
     * If the meaning of "channelName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "channelName"
     */
    inline const ::std::string& getChannelName () const;

    /**
     * Retrieves the value of the field "channelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "channelName".
     */
    inline ::std::string& getChannelNameMutable ();

    /**
     * Sets the value of the member "channelName".
     *
     * If the meaning of "channelName" isn't clear, then there should be a description here.
     *
     * @param channelName The value which will be set
     */
    inline void setChannelName (const ::std::string& channelName_);

    /**
     * Sets the value of the member "channelName".
     *
     * If the meaning of "channelName" isn't clear, then there should be a description here.
     *
     * @param channelName The value which will be set
     */
    inline void setChannelName (const char* channelName_);

    /**
     * Sets the value of the member "channelName".
     *
     * If the meaning of "channelName" isn't clear, then there should be a description here.
     *
     * @param channelName The value which will be set
     */
    inline void setChannelName (const char* value, size_t size);

    static const SXMChannelItem &getDefaultInstance();

private:

    inline void set_has_serviceID ();

    inline void clear_has_serviceID ();

    inline void set_has_channelID ();

    inline void clear_has_channelID ();

    inline void set_has_channelNumber ();

    inline void clear_has_channelNumber ();

    inline void set_has_channelName ();

    inline void clear_has_channelName ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _serviceID;

    uint16 _channelID;

    uint16 _channelNumber;

    ::std::string _channelName;

};

/**
 * If the meaning of "SXMPhoneticData" isn't clear, then there should be a description here.
 */
class SXMPhoneticData {
public:

    /**
     * Default constructor
     */
    inline  SXMPhoneticData ();

    /**
     * Copy constructor
     */
    inline  SXMPhoneticData (const SXMPhoneticData &rhs);

    /**
     * All fields constructor
     */
    inline  SXMPhoneticData (uint16 languageID_, uint16 serviceID_, const ::std::string& phoneticData_);

    /**
     * Destructor
     */
    inline  ~SXMPhoneticData();

    /**
     * Assignment operator
     */
    inline SXMPhoneticData& operator = (const SXMPhoneticData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SXMPhoneticData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SXMPhoneticData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SXMPhoneticData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SXMPhoneticData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "languageID"

    static const int kLanguageID = 0;

    /**
     * Clears the field "languageID".
     *
     * The field will be set to its default value. The hasLanguageID()
     * method will return false.
     */
    inline void clearLanguageID();

    /**
     * Checks whether the field "languageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageID()). Otherwise it will return false.
     */
    inline bool hasLanguageID () const;

    /**
     * Returns the value of the member "languageID".
     *
     * If the meaning of "languageID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "languageID"
     */
    inline uint16 getLanguageID () const;

    /**
     * Sets the value of the member "languageID".
     *
     * If the meaning of "languageID" isn't clear, then there should be a description here.
     *
     * @param languageID The value which will be set
     */
    inline void setLanguageID (uint16 languageID_);

    // API of field "serviceID"

    static const int kServiceID = 1;

    /**
     * Clears the field "serviceID".
     *
     * The field will be set to its default value. The hasServiceID()
     * method will return false.
     */
    inline void clearServiceID();

    /**
     * Checks whether the field "serviceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceID()). Otherwise it will return false.
     */
    inline bool hasServiceID () const;

    /**
     * Returns the value of the member "serviceID".
     *
     * If the meaning of "serviceID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "serviceID"
     */
    inline uint16 getServiceID () const;

    /**
     * Sets the value of the member "serviceID".
     *
     * If the meaning of "serviceID" isn't clear, then there should be a description here.
     *
     * @param serviceID The value which will be set
     */
    inline void setServiceID (uint16 serviceID_);

    // API of field "phoneticData"

    static const int kPhoneticData = 2;

    /**
     * Clears the field "phoneticData".
     *
     * The field will be set to its default value. The hasPhoneticData()
     * method will return false.
     */
    inline void clearPhoneticData();

    /**
     * Checks whether the field "phoneticData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneticData()). Otherwise it will return false.
     */
    inline bool hasPhoneticData () const;

    /**
     * Returns the value of the member "phoneticData".
     *
     * If the meaning of "phoneticData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneticData"
     */
    inline const ::std::string& getPhoneticData () const;

    /**
     * Retrieves the value of the field "phoneticData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "phoneticData".
     */
    inline ::std::string& getPhoneticDataMutable ();

    /**
     * Sets the value of the member "phoneticData".
     *
     * If the meaning of "phoneticData" isn't clear, then there should be a description here.
     *
     * @param phoneticData The value which will be set
     */
    inline void setPhoneticData (const ::std::string& phoneticData_);

    /**
     * Sets the value of the member "phoneticData".
     *
     * If the meaning of "phoneticData" isn't clear, then there should be a description here.
     *
     * @param phoneticData The value which will be set
     */
    inline void setPhoneticData (const char* phoneticData_);

    /**
     * Sets the value of the member "phoneticData".
     *
     * If the meaning of "phoneticData" isn't clear, then there should be a description here.
     *
     * @param phoneticData The value which will be set
     */
    inline void setPhoneticData (const char* value, size_t size);

    static const SXMPhoneticData &getDefaultInstance();

private:

    inline void set_has_languageID ();

    inline void clear_has_languageID ();

    inline void set_has_serviceID ();

    inline void clear_has_serviceID ();

    inline void set_has_phoneticData ();

    inline void clear_has_phoneticData ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _languageID;

    uint16 _serviceID;

    ::std::string _phoneticData;

};

/**
 * If the meaning of "storeSXMChannelNames" isn't clear, then there should be a description here.
 */
class StoreSXMChannelNamesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StoreSXMChannelNamesRequest ();

    /**
     * Copy constructor
     */
    inline  StoreSXMChannelNamesRequest (const StoreSXMChannelNamesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StoreSXMChannelNamesRequest (const ::std::vector< SXMChannelItem >& channelsList_);

    /**
     * Destructor
     */
    inline virtual  ~StoreSXMChannelNamesRequest();

    /**
     * Assignment operator
     */
    inline StoreSXMChannelNamesRequest& operator = (const StoreSXMChannelNamesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreSXMChannelNamesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreSXMChannelNamesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreSXMChannelNamesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreSXMChannelNamesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "channelsList"

    static const int kChannelsList = 0;

    /**
     * Clears the field "channelsList".
     *
     * The field will be set to its default value. The hasChannelsList()
     * method will return false.
     */
    inline void clearChannelsList();

    /**
     * Checks whether the field "channelsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelsList()). Otherwise it will return false.
     */
    inline bool hasChannelsList () const;

    /**
     * Returns the value of the member "channelsList".
     *
     * If the meaning of "channelsList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "channelsList"
     */
    inline const ::std::vector< SXMChannelItem >& getChannelsList () const;

    /**
     * Retrieves the value of the field "channelsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "channelsList".
     */
    inline ::std::vector< SXMChannelItem >& getChannelsListMutable ();

    /**
     * Sets the value of the member "channelsList".
     *
     * If the meaning of "channelsList" isn't clear, then there should be a description here.
     *
     * @param channelsList The value which will be set
     */
    inline void setChannelsList (const ::std::vector< SXMChannelItem >& channelsList_);

    static const StoreSXMChannelNamesRequest &getDefaultInstance();

private:

    static const ::std::vector< SXMChannelItem >& getSXMChannelItemList_DefaultInstance ();

    inline void set_has_channelsList ();

    inline void clear_has_channelsList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< SXMChannelItem > _channelsList;

};

/**
 * If the meaning of "storeSXMPhoneticData" isn't clear, then there should be a description here.
 */
class StoreSXMPhoneticDataRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StoreSXMPhoneticDataRequest ();

    /**
     * Copy constructor
     */
    inline  StoreSXMPhoneticDataRequest (const StoreSXMPhoneticDataRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StoreSXMPhoneticDataRequest (const ::std::vector< SXMPhoneticData >& phonemesList_);

    /**
     * Destructor
     */
    inline virtual  ~StoreSXMPhoneticDataRequest();

    /**
     * Assignment operator
     */
    inline StoreSXMPhoneticDataRequest& operator = (const StoreSXMPhoneticDataRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreSXMPhoneticDataRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreSXMPhoneticDataRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreSXMPhoneticDataRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreSXMPhoneticDataRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "phonemesList"

    static const int kPhonemesList = 0;

    /**
     * Clears the field "phonemesList".
     *
     * The field will be set to its default value. The hasPhonemesList()
     * method will return false.
     */
    inline void clearPhonemesList();

    /**
     * Checks whether the field "phonemesList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonemesList()). Otherwise it will return false.
     */
    inline bool hasPhonemesList () const;

    /**
     * Returns the value of the member "phonemesList".
     *
     * If the meaning of "phonemesList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phonemesList"
     */
    inline const ::std::vector< SXMPhoneticData >& getPhonemesList () const;

    /**
     * Retrieves the value of the field "phonemesList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "phonemesList".
     */
    inline ::std::vector< SXMPhoneticData >& getPhonemesListMutable ();

    /**
     * Sets the value of the member "phonemesList".
     *
     * If the meaning of "phonemesList" isn't clear, then there should be a description here.
     *
     * @param phonemesList The value which will be set
     */
    inline void setPhonemesList (const ::std::vector< SXMPhoneticData >& phonemesList_);

    static const StoreSXMPhoneticDataRequest &getDefaultInstance();

private:

    static const ::std::vector< SXMPhoneticData >& getSXMPhoneticDataList_DefaultInstance ();

    inline void set_has_phonemesList ();

    inline void clear_has_phonemesList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< SXMPhoneticData > _phonemesList;

};

/**
 * If the meaning of "ProcessingFinished" isn't clear, then there should be a description here.
 */
class ProcessingFinishedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProcessingFinishedSignal ();

    /**
     * Copy constructor
     */
    inline  ProcessingFinishedSignal (const ProcessingFinishedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ProcessingFinishedSignal (const ::std::string& message_);

    /**
     * Destructor
     */
    inline virtual  ~ProcessingFinishedSignal();

    /**
     * Assignment operator
     */
    inline ProcessingFinishedSignal& operator = (const ProcessingFinishedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProcessingFinishedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProcessingFinishedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProcessingFinishedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProcessingFinishedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "message"

    static const int kMessage = 0;

    /**
     * Clears the field "message".
     *
     * The field will be set to its default value. The hasMessage()
     * method will return false.
     */
    inline void clearMessage();

    /**
     * Checks whether the field "message" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessage()). Otherwise it will return false.
     */
    inline bool hasMessage () const;

    /**
     * Returns the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return The value of the field "message"
     */
    inline const ::std::string& getMessage () const;

    /**
     * Retrieves the value of the field "message" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "message".
     */
    inline ::std::string& getMessageMutable ();

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const ::std::string& message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* value, size_t size);

    static const ProcessingFinishedSignal &getDefaultInstance();

private:

    inline void set_has_message ();

    inline void clear_has_message ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _message;

};

/**
 * If the meaning of "ProcessingInterrupted" isn't clear, then there should be a description here.
 */
class ProcessingInterruptedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProcessingInterruptedSignal ();

    /**
     * Copy constructor
     */
    inline  ProcessingInterruptedSignal (const ProcessingInterruptedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ProcessingInterruptedSignal (const ::std::string& message_);

    /**
     * Destructor
     */
    inline virtual  ~ProcessingInterruptedSignal();

    /**
     * Assignment operator
     */
    inline ProcessingInterruptedSignal& operator = (const ProcessingInterruptedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProcessingInterruptedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProcessingInterruptedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProcessingInterruptedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProcessingInterruptedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "message"

    static const int kMessage = 0;

    /**
     * Clears the field "message".
     *
     * The field will be set to its default value. The hasMessage()
     * method will return false.
     */
    inline void clearMessage();

    /**
     * Checks whether the field "message" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessage()). Otherwise it will return false.
     */
    inline bool hasMessage () const;

    /**
     * Returns the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return The value of the field "message"
     */
    inline const ::std::string& getMessage () const;

    /**
     * Retrieves the value of the field "message" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "message".
     */
    inline ::std::string& getMessageMutable ();

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const ::std::string& message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* value, size_t size);

    static const ProcessingInterruptedSignal &getDefaultInstance();

private:

    inline void set_has_message ();

    inline void clear_has_message ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _message;

};

inline  SXMChannelItem::SXMChannelItem ()  :
    _serviceID (0u),
    _channelID (0u),
    _channelNumber (0u),
    _channelName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SXMChannelItem::SXMChannelItem (const SXMChannelItem &rhs)  :
    _serviceID (0u),
    _channelID (0u),
    _channelNumber (0u),
    _channelName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SXMChannelItem::SXMChannelItem (uint16 serviceID_, uint16 channelID_, uint16 channelNumber_, const ::std::string& channelName_)  :
    _serviceID (serviceID_),
    _channelID (channelID_),
    _channelNumber (channelNumber_),
    _channelName (channelName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (channelName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SXMChannelItem::~SXMChannelItem() {
}

inline SXMChannelItem& SXMChannelItem::operator = (const SXMChannelItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasServiceID()) {
            setServiceID(rhs.getServiceID());
        } else {
            clearServiceID();
        }
        if (rhs.hasChannelID()) {
            setChannelID(rhs.getChannelID());
        } else {
            clearChannelID();
        }
        if (rhs.hasChannelNumber()) {
            setChannelNumber(rhs.getChannelNumber());
        } else {
            clearChannelNumber();
        }
        if (rhs.hasChannelName()) {
            setChannelName(rhs.getChannelName());
        } else {
            clearChannelName();
        }
    }
    return *this;
}

inline bool SXMChannelItem::operator == (const SXMChannelItem& rhs) const {
    return (((!hasServiceID() && !rhs.hasServiceID()) || getServiceID() == rhs.getServiceID()) &&
        ((!hasChannelID() && !rhs.hasChannelID()) || getChannelID() == rhs.getChannelID()) &&
        ((!hasChannelNumber() && !rhs.hasChannelNumber()) || getChannelNumber() == rhs.getChannelNumber()) &&
        ((!hasChannelName() && !rhs.hasChannelName()) || getChannelName() == rhs.getChannelName()));
}

inline bool SXMChannelItem::operator != (const SXMChannelItem& rhs) const {
    return ! (*this == rhs);
}

inline bool SXMChannelItem::operator < (const SXMChannelItem& rhs) const {
    if (hasServiceID() || rhs.hasServiceID()) {
        if (getServiceID() < rhs.getServiceID()) return true;
        if (getServiceID() > rhs.getServiceID()) return false;
    }
    if (hasChannelID() || rhs.hasChannelID()) {
        if (getChannelID() < rhs.getChannelID()) return true;
        if (getChannelID() > rhs.getChannelID()) return false;
    }
    if (hasChannelNumber() || rhs.hasChannelNumber()) {
        if (getChannelNumber() < rhs.getChannelNumber()) return true;
        if (getChannelNumber() > rhs.getChannelNumber()) return false;
    }
    if (hasChannelName() || rhs.hasChannelName()) {
        if (getChannelName() < rhs.getChannelName()) return true;
        if (getChannelName() > rhs.getChannelName()) return false;
    }
    return false;
}

inline bool SXMChannelItem::operator > (const SXMChannelItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SXMChannelItem::clear() {
    clearServiceID();
    clearChannelID();
    clearChannelNumber();
    clearChannelName();
}

inline void SXMChannelItem::clearServiceID() {
    if (hasServiceID()) {
         clear_has_serviceID();
        _serviceID = 0u;
     }
}

inline bool SXMChannelItem::hasServiceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SXMChannelItem::getServiceID () const {
    return _serviceID;
}

inline void SXMChannelItem::setServiceID (uint16 serviceID_) {
    set_has_serviceID();
    this->_serviceID = serviceID_;
}

inline void SXMChannelItem::clearChannelID() {
    if (hasChannelID()) {
         clear_has_channelID();
        _channelID = 0u;
     }
}

inline bool SXMChannelItem::hasChannelID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 SXMChannelItem::getChannelID () const {
    return _channelID;
}

inline void SXMChannelItem::setChannelID (uint16 channelID_) {
    set_has_channelID();
    this->_channelID = channelID_;
}

inline void SXMChannelItem::clearChannelNumber() {
    if (hasChannelNumber()) {
         clear_has_channelNumber();
        _channelNumber = 0u;
     }
}

inline bool SXMChannelItem::hasChannelNumber () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 SXMChannelItem::getChannelNumber () const {
    return _channelNumber;
}

inline void SXMChannelItem::setChannelNumber (uint16 channelNumber_) {
    set_has_channelNumber();
    this->_channelNumber = channelNumber_;
}

inline void SXMChannelItem::clearChannelName() {
    if (hasChannelName()) {
         clear_has_channelName();
        _channelName.clear();
     }
}

inline bool SXMChannelItem::hasChannelName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& SXMChannelItem::getChannelName () const {
    return _channelName;
}

inline ::std::string& SXMChannelItem::getChannelNameMutable () {
    set_has_channelName();
    return _channelName;
}

inline void SXMChannelItem::setChannelName (const ::std::string& channelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (channelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_channelName();
    this->_channelName = channelName_;
}

inline void SXMChannelItem::setChannelName (const char* channelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (channelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_channelName();
    this->_channelName.assign(channelName_);
}

inline void SXMChannelItem::setChannelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_channelName();
    this->_channelName.assign(value, size);
}

inline void SXMChannelItem::set_has_serviceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SXMChannelItem::clear_has_serviceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SXMChannelItem::set_has_channelID () {
    _has_bits_[0] |= 1u << 1;
}

inline void SXMChannelItem::clear_has_channelID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SXMChannelItem::set_has_channelNumber () {
    _has_bits_[0] |= 1u << 2;
}

inline void SXMChannelItem::clear_has_channelNumber () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SXMChannelItem::set_has_channelName () {
    _has_bits_[0] |= 1u << 3;
}

inline void SXMChannelItem::clear_has_channelName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SXMPhoneticData::SXMPhoneticData ()  :
    _languageID (0u),
    _serviceID (0u),
    _phoneticData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SXMPhoneticData::SXMPhoneticData (const SXMPhoneticData &rhs)  :
    _languageID (0u),
    _serviceID (0u),
    _phoneticData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SXMPhoneticData::SXMPhoneticData (uint16 languageID_, uint16 serviceID_, const ::std::string& phoneticData_)  :
    _languageID (languageID_),
    _serviceID (serviceID_),
    _phoneticData (phoneticData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (phoneticData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SXMPhoneticData::~SXMPhoneticData() {
}

inline SXMPhoneticData& SXMPhoneticData::operator = (const SXMPhoneticData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLanguageID()) {
            setLanguageID(rhs.getLanguageID());
        } else {
            clearLanguageID();
        }
        if (rhs.hasServiceID()) {
            setServiceID(rhs.getServiceID());
        } else {
            clearServiceID();
        }
        if (rhs.hasPhoneticData()) {
            setPhoneticData(rhs.getPhoneticData());
        } else {
            clearPhoneticData();
        }
    }
    return *this;
}

inline bool SXMPhoneticData::operator == (const SXMPhoneticData& rhs) const {
    return (((!hasLanguageID() && !rhs.hasLanguageID()) || getLanguageID() == rhs.getLanguageID()) &&
        ((!hasServiceID() && !rhs.hasServiceID()) || getServiceID() == rhs.getServiceID()) &&
        ((!hasPhoneticData() && !rhs.hasPhoneticData()) || getPhoneticData() == rhs.getPhoneticData()));
}

inline bool SXMPhoneticData::operator != (const SXMPhoneticData& rhs) const {
    return ! (*this == rhs);
}

inline bool SXMPhoneticData::operator < (const SXMPhoneticData& rhs) const {
    if (hasLanguageID() || rhs.hasLanguageID()) {
        if (getLanguageID() < rhs.getLanguageID()) return true;
        if (getLanguageID() > rhs.getLanguageID()) return false;
    }
    if (hasServiceID() || rhs.hasServiceID()) {
        if (getServiceID() < rhs.getServiceID()) return true;
        if (getServiceID() > rhs.getServiceID()) return false;
    }
    if (hasPhoneticData() || rhs.hasPhoneticData()) {
        if (getPhoneticData() < rhs.getPhoneticData()) return true;
        if (getPhoneticData() > rhs.getPhoneticData()) return false;
    }
    return false;
}

inline bool SXMPhoneticData::operator > (const SXMPhoneticData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SXMPhoneticData::clear() {
    clearLanguageID();
    clearServiceID();
    clearPhoneticData();
}

inline void SXMPhoneticData::clearLanguageID() {
    if (hasLanguageID()) {
         clear_has_languageID();
        _languageID = 0u;
     }
}

inline bool SXMPhoneticData::hasLanguageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SXMPhoneticData::getLanguageID () const {
    return _languageID;
}

inline void SXMPhoneticData::setLanguageID (uint16 languageID_) {
    set_has_languageID();
    this->_languageID = languageID_;
}

inline void SXMPhoneticData::clearServiceID() {
    if (hasServiceID()) {
         clear_has_serviceID();
        _serviceID = 0u;
     }
}

inline bool SXMPhoneticData::hasServiceID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 SXMPhoneticData::getServiceID () const {
    return _serviceID;
}

inline void SXMPhoneticData::setServiceID (uint16 serviceID_) {
    set_has_serviceID();
    this->_serviceID = serviceID_;
}

inline void SXMPhoneticData::clearPhoneticData() {
    if (hasPhoneticData()) {
         clear_has_phoneticData();
        _phoneticData.clear();
     }
}

inline bool SXMPhoneticData::hasPhoneticData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& SXMPhoneticData::getPhoneticData () const {
    return _phoneticData;
}

inline ::std::string& SXMPhoneticData::getPhoneticDataMutable () {
    set_has_phoneticData();
    return _phoneticData;
}

inline void SXMPhoneticData::setPhoneticData (const ::std::string& phoneticData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (phoneticData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_phoneticData();
    this->_phoneticData = phoneticData_;
}

inline void SXMPhoneticData::setPhoneticData (const char* phoneticData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (phoneticData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_phoneticData();
    this->_phoneticData.assign(phoneticData_);
}

inline void SXMPhoneticData::setPhoneticData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_phoneticData();
    this->_phoneticData.assign(value, size);
}

inline void SXMPhoneticData::set_has_languageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SXMPhoneticData::clear_has_languageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SXMPhoneticData::set_has_serviceID () {
    _has_bits_[0] |= 1u << 1;
}

inline void SXMPhoneticData::clear_has_serviceID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SXMPhoneticData::set_has_phoneticData () {
    _has_bits_[0] |= 1u << 2;
}

inline void SXMPhoneticData::clear_has_phoneticData () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  StoreSXMChannelNamesRequest::StoreSXMChannelNamesRequest ()  :
    _channelsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StoreSXMChannelNamesRequest::StoreSXMChannelNamesRequest (const StoreSXMChannelNamesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _channelsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StoreSXMChannelNamesRequest::StoreSXMChannelNamesRequest (const ::std::vector< SXMChannelItem >& channelsList_)  :
    _channelsList (channelsList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StoreSXMChannelNamesRequest::~StoreSXMChannelNamesRequest() {
}

inline StoreSXMChannelNamesRequest& StoreSXMChannelNamesRequest::operator = (const StoreSXMChannelNamesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChannelsList()) {
            setChannelsList(rhs.getChannelsList());
        } else {
            clearChannelsList();
        }
    }
    return *this;
}

inline bool StoreSXMChannelNamesRequest::operator == (const StoreSXMChannelNamesRequest& rhs) const {
    return (((!hasChannelsList() && !rhs.hasChannelsList()) || getChannelsList() == rhs.getChannelsList()));
}

inline bool StoreSXMChannelNamesRequest::operator != (const StoreSXMChannelNamesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StoreSXMChannelNamesRequest::operator < (const StoreSXMChannelNamesRequest& rhs) const {
    if (hasChannelsList() || rhs.hasChannelsList()) {
        if (getChannelsList() < rhs.getChannelsList()) return true;
        if (getChannelsList() > rhs.getChannelsList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StoreSXMChannelNamesRequest::clone() {
    return new StoreSXMChannelNamesRequest(*this);
}

inline bool StoreSXMChannelNamesRequest::operator > (const StoreSXMChannelNamesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StoreSXMChannelNamesRequest::clear() {
    clearChannelsList();
}

inline void StoreSXMChannelNamesRequest::clearChannelsList() {
    if (hasChannelsList()) {
         clear_has_channelsList();
        _channelsList.clear();
     }
}

inline bool StoreSXMChannelNamesRequest::hasChannelsList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< SXMChannelItem >& StoreSXMChannelNamesRequest::getChannelsList () const {
    return _channelsList;
}

inline ::std::vector< SXMChannelItem >& StoreSXMChannelNamesRequest::getChannelsListMutable () {
    set_has_channelsList();
    return _channelsList;
}

inline void StoreSXMChannelNamesRequest::setChannelsList (const ::std::vector< SXMChannelItem >& channelsList_) {
    set_has_channelsList();
    this->_channelsList = channelsList_;
}

inline void StoreSXMChannelNamesRequest::set_has_channelsList () {
    _has_bits_[0] |= 1u << 0;
}

inline void StoreSXMChannelNamesRequest::clear_has_channelsList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StoreSXMPhoneticDataRequest::StoreSXMPhoneticDataRequest ()  :
    _phonemesList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StoreSXMPhoneticDataRequest::StoreSXMPhoneticDataRequest (const StoreSXMPhoneticDataRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _phonemesList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StoreSXMPhoneticDataRequest::StoreSXMPhoneticDataRequest (const ::std::vector< SXMPhoneticData >& phonemesList_)  :
    _phonemesList (phonemesList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StoreSXMPhoneticDataRequest::~StoreSXMPhoneticDataRequest() {
}

inline StoreSXMPhoneticDataRequest& StoreSXMPhoneticDataRequest::operator = (const StoreSXMPhoneticDataRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhonemesList()) {
            setPhonemesList(rhs.getPhonemesList());
        } else {
            clearPhonemesList();
        }
    }
    return *this;
}

inline bool StoreSXMPhoneticDataRequest::operator == (const StoreSXMPhoneticDataRequest& rhs) const {
    return (((!hasPhonemesList() && !rhs.hasPhonemesList()) || getPhonemesList() == rhs.getPhonemesList()));
}

inline bool StoreSXMPhoneticDataRequest::operator != (const StoreSXMPhoneticDataRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StoreSXMPhoneticDataRequest::operator < (const StoreSXMPhoneticDataRequest& rhs) const {
    if (hasPhonemesList() || rhs.hasPhonemesList()) {
        if (getPhonemesList() < rhs.getPhonemesList()) return true;
        if (getPhonemesList() > rhs.getPhonemesList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StoreSXMPhoneticDataRequest::clone() {
    return new StoreSXMPhoneticDataRequest(*this);
}

inline bool StoreSXMPhoneticDataRequest::operator > (const StoreSXMPhoneticDataRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StoreSXMPhoneticDataRequest::clear() {
    clearPhonemesList();
}

inline void StoreSXMPhoneticDataRequest::clearPhonemesList() {
    if (hasPhonemesList()) {
         clear_has_phonemesList();
        _phonemesList.clear();
     }
}

inline bool StoreSXMPhoneticDataRequest::hasPhonemesList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< SXMPhoneticData >& StoreSXMPhoneticDataRequest::getPhonemesList () const {
    return _phonemesList;
}

inline ::std::vector< SXMPhoneticData >& StoreSXMPhoneticDataRequest::getPhonemesListMutable () {
    set_has_phonemesList();
    return _phonemesList;
}

inline void StoreSXMPhoneticDataRequest::setPhonemesList (const ::std::vector< SXMPhoneticData >& phonemesList_) {
    set_has_phonemesList();
    this->_phonemesList = phonemesList_;
}

inline void StoreSXMPhoneticDataRequest::set_has_phonemesList () {
    _has_bits_[0] |= 1u << 0;
}

inline void StoreSXMPhoneticDataRequest::clear_has_phonemesList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ProcessingFinishedSignal::ProcessingFinishedSignal ()  :
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProcessingFinishedSignal::ProcessingFinishedSignal (const ProcessingFinishedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProcessingFinishedSignal::ProcessingFinishedSignal (const ::std::string& message_)  :
    _message (message_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProcessingFinishedSignal::~ProcessingFinishedSignal() {
}

inline ProcessingFinishedSignal& ProcessingFinishedSignal::operator = (const ProcessingFinishedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessage()) {
            setMessage(rhs.getMessage());
        } else {
            clearMessage();
        }
    }
    return *this;
}

inline bool ProcessingFinishedSignal::operator == (const ProcessingFinishedSignal& rhs) const {
    return (((!hasMessage() && !rhs.hasMessage()) || getMessage() == rhs.getMessage()));
}

inline bool ProcessingFinishedSignal::operator != (const ProcessingFinishedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ProcessingFinishedSignal::operator < (const ProcessingFinishedSignal& rhs) const {
    if (hasMessage() || rhs.hasMessage()) {
        if (getMessage() < rhs.getMessage()) return true;
        if (getMessage() > rhs.getMessage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProcessingFinishedSignal::clone() {
    return new ProcessingFinishedSignal(*this);
}

inline bool ProcessingFinishedSignal::operator > (const ProcessingFinishedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProcessingFinishedSignal::clear() {
    clearMessage();
}

inline void ProcessingFinishedSignal::clearMessage() {
    if (hasMessage()) {
         clear_has_message();
        _message.clear();
     }
}

inline bool ProcessingFinishedSignal::hasMessage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ProcessingFinishedSignal::getMessage () const {
    return _message;
}

inline ::std::string& ProcessingFinishedSignal::getMessageMutable () {
    set_has_message();
    return _message;
}

inline void ProcessingFinishedSignal::setMessage (const ::std::string& message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message = message_;
}

inline void ProcessingFinishedSignal::setMessage (const char* message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(message_);
}

inline void ProcessingFinishedSignal::setMessage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(value, size);
}

inline void ProcessingFinishedSignal::set_has_message () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProcessingFinishedSignal::clear_has_message () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ProcessingInterruptedSignal::ProcessingInterruptedSignal ()  :
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProcessingInterruptedSignal::ProcessingInterruptedSignal (const ProcessingInterruptedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProcessingInterruptedSignal::ProcessingInterruptedSignal (const ::std::string& message_)  :
    _message (message_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProcessingInterruptedSignal::~ProcessingInterruptedSignal() {
}

inline ProcessingInterruptedSignal& ProcessingInterruptedSignal::operator = (const ProcessingInterruptedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessage()) {
            setMessage(rhs.getMessage());
        } else {
            clearMessage();
        }
    }
    return *this;
}

inline bool ProcessingInterruptedSignal::operator == (const ProcessingInterruptedSignal& rhs) const {
    return (((!hasMessage() && !rhs.hasMessage()) || getMessage() == rhs.getMessage()));
}

inline bool ProcessingInterruptedSignal::operator != (const ProcessingInterruptedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ProcessingInterruptedSignal::operator < (const ProcessingInterruptedSignal& rhs) const {
    if (hasMessage() || rhs.hasMessage()) {
        if (getMessage() < rhs.getMessage()) return true;
        if (getMessage() > rhs.getMessage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProcessingInterruptedSignal::clone() {
    return new ProcessingInterruptedSignal(*this);
}

inline bool ProcessingInterruptedSignal::operator > (const ProcessingInterruptedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProcessingInterruptedSignal::clear() {
    clearMessage();
}

inline void ProcessingInterruptedSignal::clearMessage() {
    if (hasMessage()) {
         clear_has_message();
        _message.clear();
     }
}

inline bool ProcessingInterruptedSignal::hasMessage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ProcessingInterruptedSignal::getMessage () const {
    return _message;
}

inline ::std::string& ProcessingInterruptedSignal::getMessageMutable () {
    set_has_message();
    return _message;
}

inline void ProcessingInterruptedSignal::setMessage (const ::std::string& message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message = message_;
}

inline void ProcessingInterruptedSignal::setMessage (const char* message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(message_);
}

inline void ProcessingInterruptedSignal::setMessage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(value, size);
}

inline void ProcessingInterruptedSignal::set_has_message () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProcessingInterruptedSignal::clear_has_message () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace SdsSxmService
} // namespace sds_sxm_fi

#endif // SDS_SXM_FI_SDSSXMSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
