/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SettingsService.h"
#include "sds_gui_fi/SettingsServiceConst.h"
#include "sds_gui_fi/SettingsServiceDBus.h"
#include "sds_gui_fi/SettingsServiceJson.h"
#include "sds_gui_fi/SettingsServiceStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace SettingsService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/SettingsService", SettingsServiceStub);


static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 10, "speechRate", 6 },
    { 11, "shortPrompt", 3 },
    { 12, "beepOnlyMode", 2 },
    { 12, "voiceBargeIn", 4 },
    { 14, "bestMatchAudio", 0 },
    { 15, "voicePreference", 5 },
    { 18, "bestMatchPhoneBook", 1 },
    { 29, "speechRecognitionLanguageList", 7 },
};

class SettingsServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SettingsServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SettingsServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SettingsServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "sds_gui_fi.SettingsService"),
          _logger(logger) {}

    virtual ~SettingsServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SettingsServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SettingsServiceStubDelegate::introspect() const {
    return     "<interface name=\"sds_gui_fi.SettingsService\">\n"
            "    <property access=\"readwrite\" name=\"bestMatchAudio\" type=\"b\"/>\n"
            "    <property access=\"readwrite\" name=\"bestMatchPhoneBook\" type=\"b\"/>\n"
            "    <property access=\"readwrite\" name=\"beepOnlyMode\" type=\"b\"/>\n"
            "    <property access=\"readwrite\" name=\"shortPrompt\" type=\"b\"/>\n"
            "    <property access=\"readwrite\" name=\"voiceBargeIn\" type=\"b\"/>\n"
            "    <property access=\"readwrite\" name=\"voicePreference\" type=\"u\"/>\n"
            "    <property access=\"readwrite\" name=\"speechRate\" type=\"u\"/>\n"
            "    <property access=\"readwrite\" name=\"speechRecognitionLanguageList\" type=\"a(qsqqyb)\"/>\n"
            "</interface>\n";
}

void SettingsServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SettingsServiceStub*>(getStub()))->onGetAll (properties);
}

void SettingsServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 8, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "bestMatchAudio");
            ::boost::shared_ptr< BestMatchAudioSet > payload(new BestMatchAudioSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SettingsServiceStub*>(getStub())->onBestMatchAudioSet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "bestMatchPhoneBook");
            ::boost::shared_ptr< BestMatchPhoneBookSet > payload(new BestMatchPhoneBookSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SettingsServiceStub*>(getStub())->onBestMatchPhoneBookSet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "beepOnlyMode");
            ::boost::shared_ptr< BeepOnlyModeSet > payload(new BeepOnlyModeSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SettingsServiceStub*>(getStub())->onBeepOnlyModeSet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "shortPrompt");
            ::boost::shared_ptr< ShortPromptSet > payload(new ShortPromptSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SettingsServiceStub*>(getStub())->onShortPromptSet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "voiceBargeIn");
            ::boost::shared_ptr< VoiceBargeInSet > payload(new VoiceBargeInSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SettingsServiceStub*>(getStub())->onVoiceBargeInSet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "voicePreference");
            ::boost::shared_ptr< VoicePreferenceSet > payload(new VoicePreferenceSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SettingsServiceStub*>(getStub())->onVoicePreferenceSet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "speechRate");
            ::boost::shared_ptr< SpeechRateSet > payload(new SpeechRateSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SettingsServiceStub*>(getStub())->onSpeechRateSet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "speechRecognitionLanguageList");
            ::boost::shared_ptr< SpeechRecognitionLanguageListSet > payload(new SpeechRecognitionLanguageListSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SettingsServiceStub*>(getStub())->onSpeechRecognitionLanguageListSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SettingsServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 8, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "bestMatchAudio");
            ::boost::shared_ptr< BestMatchAudioGet > payload(new BestMatchAudioGet());
            payload->setAct(act);
            static_cast<SettingsServiceStub*>(getStub())->onBestMatchAudioGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "bestMatchPhoneBook");
            ::boost::shared_ptr< BestMatchPhoneBookGet > payload(new BestMatchPhoneBookGet());
            payload->setAct(act);
            static_cast<SettingsServiceStub*>(getStub())->onBestMatchPhoneBookGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "beepOnlyMode");
            ::boost::shared_ptr< BeepOnlyModeGet > payload(new BeepOnlyModeGet());
            payload->setAct(act);
            static_cast<SettingsServiceStub*>(getStub())->onBeepOnlyModeGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "shortPrompt");
            ::boost::shared_ptr< ShortPromptGet > payload(new ShortPromptGet());
            payload->setAct(act);
            static_cast<SettingsServiceStub*>(getStub())->onShortPromptGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "voiceBargeIn");
            ::boost::shared_ptr< VoiceBargeInGet > payload(new VoiceBargeInGet());
            payload->setAct(act);
            static_cast<SettingsServiceStub*>(getStub())->onVoiceBargeInGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "voicePreference");
            ::boost::shared_ptr< VoicePreferenceGet > payload(new VoicePreferenceGet());
            payload->setAct(act);
            static_cast<SettingsServiceStub*>(getStub())->onVoicePreferenceGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "speechRate");
            ::boost::shared_ptr< SpeechRateGet > payload(new SpeechRateGet());
            payload->setAct(act);
            static_cast<SettingsServiceStub*>(getStub())->onSpeechRateGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "speechRecognitionLanguageList");
            ::boost::shared_ptr< SpeechRecognitionLanguageListGet > payload(new SpeechRecognitionLanguageListGet());
            payload->setAct(act);
            static_cast<SettingsServiceStub*>(getStub())->onSpeechRecognitionLanguageListGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SettingsServiceStub::SettingsServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SettingsServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SettingsServiceStub::SettingsServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SettingsServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SettingsServiceStub::~SettingsServiceStub() {
    delete _stubDelegate;
}

void SettingsServiceStub::sendBestMatchAudioUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BestMatchAudioUpdate payload(_bestMatchAudioProperty);

        LOG_INFO ("-> send%s", "BestMatchAudioUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("bestMatchAudio", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.SettingsService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BestMatchAudioUpdate");
    }
}

void SettingsServiceStub::onBestMatchAudioGet(const ::boost::shared_ptr< BestMatchAudioGet >& bestMatchAudio) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BestMatchAudioGet", bestMatchAudio->getAct());
    sendBestMatchAudioGetUpdate(_bestMatchAudioProperty.getBestMatchAudio(), bestMatchAudio->getAct());
}

void SettingsServiceStub::sendBestMatchAudioGetUpdate(bool bestMatchAudio, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BestMatchAudioGet payload(bestMatchAudio);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BestMatchAudioGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SettingsServiceStub::onBestMatchAudioSet(const ::boost::shared_ptr< BestMatchAudioSet >& bestMatchAudio) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BestMatchAudioSet", bestMatchAudio->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*bestMatchAudio, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setBestMatchAudio (bestMatchAudio->getBestMatchAudio());
    sendBestMatchAudioSetUpdate(bestMatchAudio->getAct());
}

void SettingsServiceStub::sendBestMatchAudioSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BestMatchAudioSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SettingsServiceStub::setBestMatchAudio(bool bestMatchAudio) {
    if(bestMatchAudio!=_bestMatchAudioProperty.getBestMatchAudio()) {
        _bestMatchAudioProperty.setBestMatchAudio(bestMatchAudio);
        sendBestMatchAudioUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool SettingsServiceStub::getBestMatchAudio() const {
    return _bestMatchAudioProperty.getBestMatchAudio();
}

void SettingsServiceStub::sendBestMatchPhoneBookUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BestMatchPhoneBookUpdate payload(_bestMatchPhoneBookProperty);

        LOG_INFO ("-> send%s", "BestMatchPhoneBookUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("bestMatchPhoneBook", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.SettingsService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BestMatchPhoneBookUpdate");
    }
}

void SettingsServiceStub::onBestMatchPhoneBookGet(const ::boost::shared_ptr< BestMatchPhoneBookGet >& bestMatchPhoneBook) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BestMatchPhoneBookGet", bestMatchPhoneBook->getAct());
    sendBestMatchPhoneBookGetUpdate(_bestMatchPhoneBookProperty.getBestMatchPhoneBook(), bestMatchPhoneBook->getAct());
}

void SettingsServiceStub::sendBestMatchPhoneBookGetUpdate(bool bestMatchPhoneBook, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BestMatchPhoneBookGet payload(bestMatchPhoneBook);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BestMatchPhoneBookGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SettingsServiceStub::onBestMatchPhoneBookSet(const ::boost::shared_ptr< BestMatchPhoneBookSet >& bestMatchPhoneBook) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BestMatchPhoneBookSet", bestMatchPhoneBook->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*bestMatchPhoneBook, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setBestMatchPhoneBook (bestMatchPhoneBook->getBestMatchPhoneBook());
    sendBestMatchPhoneBookSetUpdate(bestMatchPhoneBook->getAct());
}

void SettingsServiceStub::sendBestMatchPhoneBookSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BestMatchPhoneBookSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SettingsServiceStub::setBestMatchPhoneBook(bool bestMatchPhoneBook) {
    if(bestMatchPhoneBook!=_bestMatchPhoneBookProperty.getBestMatchPhoneBook()) {
        _bestMatchPhoneBookProperty.setBestMatchPhoneBook(bestMatchPhoneBook);
        sendBestMatchPhoneBookUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool SettingsServiceStub::getBestMatchPhoneBook() const {
    return _bestMatchPhoneBookProperty.getBestMatchPhoneBook();
}

void SettingsServiceStub::sendBeepOnlyModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BeepOnlyModeUpdate payload(_beepOnlyModeProperty);

        LOG_INFO ("-> send%s", "BeepOnlyModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("beepOnlyMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.SettingsService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BeepOnlyModeUpdate");
    }
}

void SettingsServiceStub::onBeepOnlyModeGet(const ::boost::shared_ptr< BeepOnlyModeGet >& beepOnlyMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BeepOnlyModeGet", beepOnlyMode->getAct());
    sendBeepOnlyModeGetUpdate(_beepOnlyModeProperty.getBeepOnlyMode(), beepOnlyMode->getAct());
}

void SettingsServiceStub::sendBeepOnlyModeGetUpdate(bool beepOnlyMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BeepOnlyModeGet payload(beepOnlyMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BeepOnlyModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SettingsServiceStub::onBeepOnlyModeSet(const ::boost::shared_ptr< BeepOnlyModeSet >& beepOnlyMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BeepOnlyModeSet", beepOnlyMode->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*beepOnlyMode, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setBeepOnlyMode (beepOnlyMode->getBeepOnlyMode());
    sendBeepOnlyModeSetUpdate(beepOnlyMode->getAct());
}

void SettingsServiceStub::sendBeepOnlyModeSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BeepOnlyModeSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SettingsServiceStub::setBeepOnlyMode(bool beepOnlyMode) {
    if(beepOnlyMode!=_beepOnlyModeProperty.getBeepOnlyMode()) {
        _beepOnlyModeProperty.setBeepOnlyMode(beepOnlyMode);
        sendBeepOnlyModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool SettingsServiceStub::getBeepOnlyMode() const {
    return _beepOnlyModeProperty.getBeepOnlyMode();
}

void SettingsServiceStub::sendShortPromptUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ShortPromptUpdate payload(_shortPromptProperty);

        LOG_INFO ("-> send%s", "ShortPromptUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("shortPrompt", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.SettingsService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ShortPromptUpdate");
    }
}

void SettingsServiceStub::onShortPromptGet(const ::boost::shared_ptr< ShortPromptGet >& shortPrompt) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ShortPromptGet", shortPrompt->getAct());
    sendShortPromptGetUpdate(_shortPromptProperty.getShortPrompt(), shortPrompt->getAct());
}

void SettingsServiceStub::sendShortPromptGetUpdate(bool shortPrompt, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ShortPromptGet payload(shortPrompt);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ShortPromptGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SettingsServiceStub::onShortPromptSet(const ::boost::shared_ptr< ShortPromptSet >& shortPrompt) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ShortPromptSet", shortPrompt->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*shortPrompt, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setShortPrompt (shortPrompt->getShortPrompt());
    sendShortPromptSetUpdate(shortPrompt->getAct());
}

void SettingsServiceStub::sendShortPromptSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ShortPromptSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SettingsServiceStub::setShortPrompt(bool shortPrompt) {
    if(shortPrompt!=_shortPromptProperty.getShortPrompt()) {
        _shortPromptProperty.setShortPrompt(shortPrompt);
        sendShortPromptUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool SettingsServiceStub::getShortPrompt() const {
    return _shortPromptProperty.getShortPrompt();
}

void SettingsServiceStub::sendVoiceBargeInUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VoiceBargeInUpdate payload(_voiceBargeInProperty);

        LOG_INFO ("-> send%s", "VoiceBargeInUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("voiceBargeIn", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.SettingsService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VoiceBargeInUpdate");
    }
}

void SettingsServiceStub::onVoiceBargeInGet(const ::boost::shared_ptr< VoiceBargeInGet >& voiceBargeIn) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VoiceBargeInGet", voiceBargeIn->getAct());
    sendVoiceBargeInGetUpdate(_voiceBargeInProperty.getVoiceBargeIn(), voiceBargeIn->getAct());
}

void SettingsServiceStub::sendVoiceBargeInGetUpdate(bool voiceBargeIn, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VoiceBargeInGet payload(voiceBargeIn);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VoiceBargeInGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SettingsServiceStub::onVoiceBargeInSet(const ::boost::shared_ptr< VoiceBargeInSet >& voiceBargeIn) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VoiceBargeInSet", voiceBargeIn->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*voiceBargeIn, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setVoiceBargeIn (voiceBargeIn->getVoiceBargeIn());
    sendVoiceBargeInSetUpdate(voiceBargeIn->getAct());
}

void SettingsServiceStub::sendVoiceBargeInSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VoiceBargeInSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SettingsServiceStub::setVoiceBargeIn(bool voiceBargeIn) {
    if(voiceBargeIn!=_voiceBargeInProperty.getVoiceBargeIn()) {
        _voiceBargeInProperty.setVoiceBargeIn(voiceBargeIn);
        sendVoiceBargeInUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool SettingsServiceStub::getVoiceBargeIn() const {
    return _voiceBargeInProperty.getVoiceBargeIn();
}

void SettingsServiceStub::sendVoicePreferenceUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VoicePreferenceUpdate payload(_voicePreferenceProperty);

        LOG_INFO ("-> send%s", "VoicePreferenceUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("voicePreference", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.SettingsService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VoicePreferenceUpdate");
    }
}

void SettingsServiceStub::onVoicePreferenceGet(const ::boost::shared_ptr< VoicePreferenceGet >& voicePreference) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VoicePreferenceGet", voicePreference->getAct());
    sendVoicePreferenceGetUpdate(_voicePreferenceProperty.getVoicePreference(), voicePreference->getAct());
}

void SettingsServiceStub::sendVoicePreferenceGetUpdate(ActiveSpeakerGender voicePreference, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VoicePreferenceGet payload(voicePreference);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VoicePreferenceGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SettingsServiceStub::onVoicePreferenceSet(const ::boost::shared_ptr< VoicePreferenceSet >& voicePreference) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VoicePreferenceSet", voicePreference->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*voicePreference, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setVoicePreference (voicePreference->getVoicePreference());
    sendVoicePreferenceSetUpdate(voicePreference->getAct());
}

void SettingsServiceStub::sendVoicePreferenceSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VoicePreferenceSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SettingsServiceStub::setVoicePreference(ActiveSpeakerGender voicePreference) {
    if(voicePreference!=_voicePreferenceProperty.getVoicePreference()) {
        _voicePreferenceProperty.setVoicePreference(voicePreference);
        sendVoicePreferenceUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

ActiveSpeakerGender SettingsServiceStub::getVoicePreference() const {
    return _voicePreferenceProperty.getVoicePreference();
}

void SettingsServiceStub::sendSpeechRateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SpeechRateUpdate payload(_speechRateProperty);

        LOG_INFO ("-> send%s", "SpeechRateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("speechRate", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.SettingsService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SpeechRateUpdate");
    }
}

void SettingsServiceStub::onSpeechRateGet(const ::boost::shared_ptr< SpeechRateGet >& speechRate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SpeechRateGet", speechRate->getAct());
    sendSpeechRateGetUpdate(_speechRateProperty.getSpeechRate(), speechRate->getAct());
}

void SettingsServiceStub::sendSpeechRateGetUpdate(uint32 speechRate, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SpeechRateGet payload(speechRate);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SpeechRateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SettingsServiceStub::onSpeechRateSet(const ::boost::shared_ptr< SpeechRateSet >& speechRate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SpeechRateSet", speechRate->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*speechRate, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setSpeechRate (speechRate->getSpeechRate());
    sendSpeechRateSetUpdate(speechRate->getAct());
}

void SettingsServiceStub::sendSpeechRateSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SpeechRateSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SettingsServiceStub::setSpeechRate(uint32 speechRate) {
    if(speechRate!=_speechRateProperty.getSpeechRate()) {
        _speechRateProperty.setSpeechRate(speechRate);
        sendSpeechRateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 SettingsServiceStub::getSpeechRate() const {
    return _speechRateProperty.getSpeechRate();
}

void SettingsServiceStub::sendSpeechRecognitionLanguageListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SpeechRecognitionLanguageListUpdate payload(_speechRecognitionLanguageListProperty);

        LOG_INFO ("-> send%s", "SpeechRecognitionLanguageListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("speechRecognitionLanguageList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("sds_gui_fi.SettingsService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SpeechRecognitionLanguageListUpdate");
    }
}

void SettingsServiceStub::onSpeechRecognitionLanguageListGet(const ::boost::shared_ptr< SpeechRecognitionLanguageListGet >& speechRecognitionLanguageList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SpeechRecognitionLanguageListGet", speechRecognitionLanguageList->getAct());
    sendSpeechRecognitionLanguageListGetUpdate(_speechRecognitionLanguageListProperty.getSpeechRecognitionLanguageList(), speechRecognitionLanguageList->getAct());
}

void SettingsServiceStub::sendSpeechRecognitionLanguageListGetUpdate(const ::std::vector< SpeechRecognitionLanguage >& speechRecognitionLanguageList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SpeechRecognitionLanguageListGet payload(speechRecognitionLanguageList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SpeechRecognitionLanguageListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SettingsServiceStub::onSpeechRecognitionLanguageListSet(const ::boost::shared_ptr< SpeechRecognitionLanguageListSet >& speechRecognitionLanguageList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SpeechRecognitionLanguageListSet", speechRecognitionLanguageList->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*speechRecognitionLanguageList, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setSpeechRecognitionLanguageList (speechRecognitionLanguageList->getSpeechRecognitionLanguageList());
    sendSpeechRecognitionLanguageListSetUpdate(speechRecognitionLanguageList->getAct());
}

void SettingsServiceStub::sendSpeechRecognitionLanguageListSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SpeechRecognitionLanguageListSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SettingsServiceStub::setSpeechRecognitionLanguageList(const ::std::vector< SpeechRecognitionLanguage >& speechRecognitionLanguageList) {
    if(speechRecognitionLanguageList!=_speechRecognitionLanguageListProperty.getSpeechRecognitionLanguageList()) {
        _speechRecognitionLanguageListProperty.setSpeechRecognitionLanguageList(speechRecognitionLanguageList);
        sendSpeechRecognitionLanguageListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< SpeechRecognitionLanguage >& SettingsServiceStub::getSpeechRecognitionLanguageList() const {
    return _speechRecognitionLanguageListProperty.getSpeechRecognitionLanguageList();
}

::std::vector< SpeechRecognitionLanguage >& SettingsServiceStub::getSpeechRecognitionLanguageListMutable() {
    return _speechRecognitionLanguageListProperty.getSpeechRecognitionLanguageListMutable();
}

void SettingsServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'bestMatchAudio'
    {
        ::asf::dbus::DBusVariant variant;
        BestMatchAudioGet payload(_bestMatchAudioProperty.getBestMatchAudio());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("bestMatchAudio", variant));
    }

    //property 'bestMatchPhoneBook'
    {
        ::asf::dbus::DBusVariant variant;
        BestMatchPhoneBookGet payload(_bestMatchPhoneBookProperty.getBestMatchPhoneBook());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("bestMatchPhoneBook", variant));
    }

    //property 'beepOnlyMode'
    {
        ::asf::dbus::DBusVariant variant;
        BeepOnlyModeGet payload(_beepOnlyModeProperty.getBeepOnlyMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("beepOnlyMode", variant));
    }

    //property 'shortPrompt'
    {
        ::asf::dbus::DBusVariant variant;
        ShortPromptGet payload(_shortPromptProperty.getShortPrompt());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("shortPrompt", variant));
    }

    //property 'voiceBargeIn'
    {
        ::asf::dbus::DBusVariant variant;
        VoiceBargeInGet payload(_voiceBargeInProperty.getVoiceBargeIn());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("voiceBargeIn", variant));
    }

    //property 'voicePreference'
    {
        ::asf::dbus::DBusVariant variant;
        VoicePreferenceGet payload(_voicePreferenceProperty.getVoicePreference());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("voicePreference", variant));
    }

    //property 'speechRate'
    {
        ::asf::dbus::DBusVariant variant;
        SpeechRateGet payload(_speechRateProperty.getSpeechRate());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("speechRate", variant));
    }

    //property 'speechRecognitionLanguageList'
    {
        ::asf::dbus::DBusVariant variant;
        SpeechRecognitionLanguageListGet payload(_speechRecognitionLanguageListProperty.getSpeechRecognitionLanguageList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("speechRecognitionLanguageList", variant));
    }
}

} // namespace SettingsService
} // namespace sds_gui_fi
