/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SdsPhoneService.h"
#include "sds_gui_fi/SdsPhoneServiceConst.h"
#include "sds_gui_fi/SdsPhoneServiceDBus.h"
#include "sds_gui_fi/SdsPhoneServiceJson.h"
#include "sds_gui_fi/SdsPhoneServiceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace SdsPhoneService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/SdsPhoneService", SdsPhoneServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 14, "VoiceTagAction", 0 },
};


class SdsPhoneServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SdsPhoneServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SdsPhoneServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SdsPhoneServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "sds_gui_fi.SdsPhoneService"),
          _logger(logger) {}

    virtual ~SdsPhoneServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SdsPhoneServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'VoiceTagAction'

            LOG_DEBUG_STUB("process method '%s'", "VoiceTagAction");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VoiceTagActionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "VoiceTagAction", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< VoiceTagActionRequest > payload = ::boost::static_pointer_cast<VoiceTagActionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsPhoneServiceStub*>(getStub())->onVoiceTagActionRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SdsPhoneServiceStubDelegate::introspect() const {
    return     "<interface name=\"sds_gui_fi.SdsPhoneService\">\n"
            "    <method name=\"VoiceTagAction\">\n"
            "      <arg direction=\"in\" name=\"userAction\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>userAction = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"uniqueContactID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>uniqueContactID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"phoneProfileID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>phoneProfileID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"SpokenDigits\">\n"
            "      <arg direction=\"out\" name=\"digits\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>digits = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SmsContent\">\n"
            "      <arg direction=\"out\" name=\"firstLastSMS\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>firstLastSMS = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"message\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>message = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"UserWordUpdate\">\n"
            "      <arg direction=\"out\" name=\"userWordLists\" type=\"a(uau)\">\n"
            "        <doc>\n"
            "          <line>userWordLists = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"PhoneBookPhonetization\">\n"
            "      <arg direction=\"out\" name=\"phoneBookPhonetizationStatus\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>phoneBookPhonetizationStatus = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void SdsPhoneServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SdsPhoneServiceStub*>(getStub()))->onGetAll (properties);
}

void SdsPhoneServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SdsPhoneServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SdsPhoneServiceStub::SdsPhoneServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsPhoneServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsPhoneServiceStub::SdsPhoneServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsPhoneServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsPhoneServiceStub::~SdsPhoneServiceStub() {
    delete _stubDelegate;
}

void SdsPhoneServiceStub::sendSpokenDigitsSignal(const ::std::string& digits) {
    if (_stubDelegate->isConnected()) {
        SpokenDigitsSignal* payload = new SpokenDigitsSignal(digits);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SpokenDigits", SpokenDigitsSignal, payload)
        LOG_INFO ("-> send%sSignal", "SpokenDigits");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SpokenDigits");
    }
}

void SdsPhoneServiceStub::sendSmsContentSignal(FirstLastSMS firstLastSMS, const ::std::string& message) {
    if (_stubDelegate->isConnected()) {
        SmsContentSignal* payload = new SmsContentSignal(firstLastSMS, message);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SmsContent", SmsContentSignal, payload)
        LOG_INFO ("-> send%sSignal", "SmsContent");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SmsContent");
    }
}

void SdsPhoneServiceStub::sendUserWordUpdateSignal(const ::std::vector< UserWordList >& userWordLists) {
    if (_stubDelegate->isConnected()) {
        UserWordUpdateSignal* payload = new UserWordUpdateSignal(userWordLists);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "UserWordUpdate", UserWordUpdateSignal, payload)
        LOG_INFO ("-> send%sSignal", "UserWordUpdate");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "UserWordUpdate");
    }
}

void SdsPhoneServiceStub::sendPhoneBookPhonetizationSignal(PhoneBookPhonetization phoneBookPhonetizationStatus) {
    if (_stubDelegate->isConnected()) {
        PhoneBookPhonetizationSignal* payload = new PhoneBookPhonetizationSignal(phoneBookPhonetizationStatus);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PhoneBookPhonetization", PhoneBookPhonetizationSignal, payload)
        LOG_INFO ("-> send%sSignal", "PhoneBookPhonetization");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PhoneBookPhonetization");
    }
}

void  SdsPhoneServiceStub::sendVoiceTagActionResponse (act_t act) {
    VoiceTagActionResponse* payload = new VoiceTagActionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "VoiceTagAction", VoiceTagActionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "VoiceTagAction", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsPhoneServiceStub::sendVoiceTagActionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    VoiceTagActionError* payload = new VoiceTagActionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "VoiceTagAction", VoiceTagActionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "VoiceTagAction", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SdsPhoneServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace SdsPhoneService
} // namespace sds_gui_fi
